<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'data', language 'pt', version '4.4'.
 *
 * @package     data
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'Ação';
$string['actionsmenu'] = 'Menu de Ações';
$string['add'] = 'Adicionar registo';
$string['addcomment'] = 'Adicionar comentário';
$string['addedby'] = 'Adicionado por';
$string['addentries'] = 'Adicionar registos';
$string['addtemplate'] = 'Modelo de adicionar registo';
$string['advancedsearch'] = 'Pesquisa avançada';
$string['allowcomments'] = 'Permitir comentários aos registos';
$string['alttext'] = 'Texto alternativo';
$string['approvalstatus'] = 'Estado da aprovação';
$string['approve'] = 'Aprovar';
$string['approved'] = 'Aprovado';
$string['areacontent'] = 'Campos';
$string['ascending'] = 'Ascendente';
$string['asearchtemplate'] = 'Modelo de pesquisa avançada';
$string['atmaxentry'] = 'Já inseriu o número máximo de registos permitido!';
$string['authorfirstname'] = 'Nome';
$string['authorlastname'] = 'Apelido';
$string['autogenallforms'] = 'Gerar todos os formulários predefinidos.';
$string['autolinkurl'] = 'Criar hiperligação para o URL';
$string['availablefromdate'] = 'Disponível a partir de';
$string['availabletags'] = 'Marcadores disponíveis';
$string['availabletags_help'] = 'Os marcadores são espaços reservados no modelo que serão substituídos por dados ou outros itens quando os registos forem editados ou visualizados (ex: ícone de edição, valor de um campo, etc.).

Os marcadores para os campos são definidos no formato <b>[[nomedocampo]]</b>. Todos os outros marcadores possuem o formato <b>##marcadorexemplo##</b>.

Apenas os marcadores que estão na lista <b>Marcadores disponíveis</b> podem ser usados no modelo atual.';
$string['availabletodate'] = 'Disponível até';
$string['availabletodatevalidation'] = '"Disponível até" não pode ser anterior a "Disponível a partir de".';
$string['blank'] = 'Em branco';
$string['buttons'] = 'Botões';
$string['bynameondate'] = 'por {$a->name} - {$a->date}';
$string['calendarend'] = 'Fecha \'{$a}\'';
$string['calendarstart'] = 'Abre \'{$a}\'';
$string['cancel'] = 'Cancelar';
$string['cannotaccesspresentsother'] = 'Não tem permissão para aceder a protótipos de outros utilizadores';
$string['cannotadd'] = 'Não foi possível adicionar registos!';
$string['cannotapplypreset'] = 'Ocorreu um erro ao aplicar o protótipo.';
$string['cannotdeletepreset'] = 'Ocorreu um erro ao apagar o protótipo';
$string['cannotoverwritepreset'] = 'Ocorreu um erro ao criar o protótipo!';
$string['cannotunziptopreset'] = 'Não foi possível descompactar o ficheiro para a pasta do protótipo.';
$string['checkbox'] = 'Caixas de seleção';
$string['chooseexportfields'] = 'Escolha os campos que pretende exportar';
$string['chooseexportformat'] = 'Escolha o formato da exportação';
$string['chooseorupload'] = 'Selecionar ficheiro';
$string['choosepreset'] = 'Ficheiro do protótipo';
$string['closebeforeopen'] = 'Indicou uma data de fim antes da data de início.';
$string['columns'] = 'Colunas';
$string['comment'] = 'Comentar';
$string['commentdeleted'] = 'O comentário foi apagado';
$string['commentempty'] = 'O comentário estava vazio';
$string['comments'] = 'Comentários';
$string['commentsaved'] = 'O comentário foi guardado';
$string['commentsn'] = '{$a} comentário(s)';
$string['commentsoff'] = 'A opção de comentários não está ativa';
$string['completiondetail:entries'] = 'Adicionar registos: {$a}';
$string['completionentries'] = 'Requer registos';
$string['completionentriescount'] = 'Adicionar entradas';
$string['completionentriesdesc'] = 'Número mínimo de registos requeridos: {$a}';
$string['configenablerssfeeds'] = 'A ativação desta configuração permite a geração de listas RSS em todas as bases de dados, ao nível do site. Para utilizar esta funcionalidade numa base de dados específica deve ainda ativar a mesma na respectiva página de configuração.';
$string['confirmdeletefield'] = 'Tem a certeza de que pretende apagar este campo?';
$string['confirmdeleterecord'] = 'Tem a certeza de que pretende apagar este registo?';
$string['confirmdeleterecords'] = 'Tem a certeza de que pretende apagar estes registos?';
$string['createactivity'] = 'Crie os seus próprios campos para armazenar dados ou use um protótipo que já inclua campos.';
$string['createfields'] = 'Crie campos para armazenar diferentes tipos de dados.';
$string['createtemplates'] = 'Os modelos definem a interface da sua atividade. Depois de criar campos, os modelos serão criados automaticamente. Como alternativa, pode usar um protótipo, que inclua campos e modelos.';
$string['csstemplate'] = 'CSS personalizado';
$string['csvfailed'] = 'Não foi possível ler a informação existente no ficheiro CSV';
$string['csvfile'] = 'CSV ou Zip com ficheiro CSV';
$string['csvimport'] = 'Importação de ficheiro CSV';
$string['csvimport_help'] = 'Os registos podem ser importados através de um ficheiro de texto, indicando na primeira linha os nomes dos campos e nas linhas seguintes a respetiva informação, com um registo por linha.';
$string['csvwithselecteddelimiter'] = '<abbr title="Valores separados por vírgulas">CSV</abbr>';
$string['data:addinstance'] = 'Adicionar nova Base de Dados';
$string['data:approve'] = 'Aprovar e cancelar registos já aprovados';
$string['data:comment'] = 'Escrever comentários';
$string['data:exportallentries'] = 'Exportar todos os registos';
$string['data:exportentry'] = 'Exportar um registo';
$string['data:exportownentry'] = 'Exportar registo do próprio';
$string['data:exportuserinfo'] = 'Exportar informação do utilizador';
$string['data:managecomments'] = 'Gerir comentários';
$string['data:manageentries'] = 'Gerir registos';
$string['data:managetemplates'] = 'Gerir modelos';
$string['data:manageuserpresets'] = 'Gerir protótipos';
$string['data:rate'] = 'Avaliar registos';
$string['data:readentry'] = 'Ler registos';
$string['data:view'] = 'Ver atividade Base de dados';
$string['data:viewallratings'] = 'Ver todas as avaliações atribuídas pelos utilizadores';
$string['data:viewalluserpresets'] = 'Ver protótipos de todos os utilizadores';
$string['data:viewanyrating'] = 'Ver as avaliações totais que todos obtiveram';
$string['data:viewentry'] = 'Ver registos';
$string['data:viewrating'] = 'Ver a avaliação que obteve';
$string['data:writeentry'] = 'Escrever registos';
$string['date'] = 'Data';
$string['dateentered'] = 'Data de criação';
$string['datemodified'] = 'Última edição:';
$string['defaultfielddelimiter'] = '(o valor predefinido é a vírgula)';
$string['defaultfieldenclosure'] = '(não existe valor predefinido)';
$string['defaultsortfield'] = 'Campo de ordenação predefinido';
$string['delcheck'] = 'Caixa de seleção de exclusão';
$string['delete'] = 'Apagar';
$string['deleteallentries'] = 'Apagar todos os registos';
$string['deletecomment'] = 'Tem a certeza de que pretende apagar este comentário?';
$string['deleteconfirm'] = 'Apagar o protótipo \'{$a}\'?';
$string['deleted'] = 'apagado(s)';
$string['deleteentry'] = 'Apagar registo';
$string['deletefield'] = 'Apagar campo';
$string['deletenotenrolled'] = 'Apagar registos criados por utilizadores que não estão inscritos';
$string['deletewarning'] = 'Apagar um protótipo remove-o da lista de protótipos disponíveis em todas as disciplinas.';
$string['descending'] = 'Descendente';
$string['directorynotapreset'] = '{$a->directory} Não é um protótipo: faltam os ficheiros: {$a->missing_files}';
$string['disapprove'] = 'Anular aprovação';
$string['download'] = 'Descarregar';
$string['edit'] = 'Editar';
$string['editcomment'] = 'Editar comentário';
$string['editentry'] = 'Editar registo';
$string['editfield'] = 'Editar campo';
$string['editordisable'] = 'Desativar editor';
$string['editorenable'] = 'Ativar editor de código';
$string['editpreset'] = 'Editar protótipo';
$string['emptyadd'] = 'O modelo <b>Adicionar</b> está vazio. A gerar o formulário predefinido...';
$string['emptyaddform'] = 'Não preencheu nenhum campo!';
$string['emptypresetname'] = 'O nome ou ficheiro do protótipo não pode estar em branco';
$string['enabletemplateeditorcheck'] = 'Tem a certeza de que pretende ativar o editor? Esta ação pode resultar numa alteração de conteúdo quando o modelo for guardado.';
$string['entries'] = 'Registos';
$string['entrieslefttoadd'] = 'Tem de adicionar mais {$a->entriesleft} registo(s) para concluir esta atividade.';
$string['entrieslefttoaddtoview'] = 'Tem de adicionar mais {$a->entrieslefttoview} registo(s) para conseguir visualizar os registos dos outros participantes.';
$string['entry'] = 'Registo';
$string['entrysaved'] = 'O seu registo foi guardado';
$string['errordatafilenotfound'] = 'O ficheiro não pôde ser importado. Os tipos de ficheiro aceites são CSV ou Zip contendo um ficheiro CSV no formato usado para exportar os registos.';
$string['errormustbeteacher'] = 'Apenas os professores podem usar esta página!';
$string['errormustsupplyvalue'] = 'Indique aqui um valor.';
$string['errorpresetexists'] = 'Já existe um protótipo com este nome.';
$string['errorpresetexistsbutnotoverwrite'] = 'Já existe um protótipo com este nome. Escolha um nome diferente.';
$string['errorpresetnotfound'] = 'Não foi encontrado o protótipo com o nome \'{$a}\'.';
$string['eventfieldcreated'] = 'Campo criado';
$string['eventfielddeleted'] = 'Campo eliminado';
$string['eventfieldupdated'] = 'Campo atualizado';
$string['eventrecordcreated'] = 'Registo criado';
$string['eventrecorddeleted'] = 'Registo eliminado';
$string['eventrecordupdated'] = 'Registo atualizado';
$string['eventtemplateupdated'] = 'Modelo atualizado';
$string['eventtemplateviewed'] = 'Modelos visualizados';
$string['example'] = 'Exemplo de módulo de <b>Base de dados</b>';
$string['excel'] = 'Ficheiro Excel';
$string['expired'] = 'A atividade terminou em <b>{$a}</b> e já não está disponível';
$string['export'] = 'Exportar';
$string['exportaszip'] = 'Exportar como ficheiro Zip';
$string['exportaszip_help'] = 'A exportação para ficheiro Zip permite o armazenamento dos modelos e campos num ficheiro Zip protótipo que pode ser descarregado. Este ficheiro pode depois ser importado para outra disciplina.';
$string['exportedtozip'] = 'Exportado para ficheiro Zip temporário...';
$string['exportentries'] = 'Exportar registos';
$string['exportformat'] = 'Formato da exportação';
$string['exportoptions'] = 'Opções da exportação';
$string['exportownentries'] = 'Exportar apenas os seus registos? ({$a->mine} / {$a->all})';
$string['exportpreset'] = 'Exportar protótipo';
$string['failedpresetdelete'] = 'Ocorreu um erro ao tentar apagar o protótipo.';
$string['fieldadded'] = 'O campo foi adicionado';
$string['fieldallowautolink'] = 'Permitir hiperligações automáticas';
$string['fielddeleted'] = 'O campo foi apagado';
$string['fielddelimiter'] = 'Separador de campo';
$string['fielddescription'] = 'Descrição do campo';
$string['fieldenclosure'] = 'Limites do campo';
$string['fieldheight'] = 'Altura';
$string['fieldheightlistview'] = 'Altura (em píxeis) no modo lista';
$string['fieldheightsingleview'] = 'Altura (em píxeis) no modo registo';
$string['fieldids'] = 'Identificadores de campo';
$string['fieldmappings'] = 'Mapeamentos dos campos';
$string['fieldmappings_help'] = 'Este menu permite-lhe manter os dados da base de dados existente. Para preservar os dados de um campo, este deverá ser mapeado para um novo campo. Os campos podem ser deixados em branco, caso em que não será copiada a informação. Todos os campos que não sejam mapeados para novos campos serão apagados e a sua informação perdida.
Apenas podem ser mapeados campos do mesmo tipo, pelo que cada lista pendente apresentará os tipos permitidos. Não é permitido o mapeamento de um campo para mais do que um novo campo.';
$string['fieldname'] = 'Nome do campo';
$string['fieldnametype'] = '{$a->name} ({$a->type})';
$string['fieldnotmatched'] = 'Os seguintes campos presentes no ficheiro não existem nesta base de dados: {$a}';
$string['fieldoptions'] = 'Opções (uma por linha)';
$string['fields'] = 'Campos';
$string['fieldshelp'] = 'Crie campos para armazenar diferentes tipos de dados. Os campos definem a estrutura das entradas na sua base de dados.';
$string['fieldsinformationtags'] = 'Informação do campo';
$string['fieldsnavigation'] = 'Navegação terciária dos campos';
$string['fieldtagdescription'] = 'Descrição de {$a}';
$string['fieldtagid'] = 'ID de {$a}';
$string['fieldtagname'] = 'Nome de {$a}';
$string['fieldupdated'] = 'O campo foi atualizado';
$string['fieldwidth'] = 'Largura';
$string['fieldwidthlistview'] = 'Largura (em píxeis) no modo lista';
$string['fieldwidthsingleview'] = 'Largura (em píxeis) no modo registo';
$string['file'] = 'Ficheiro';
$string['fileencoding'] = 'Código';
$string['filesnotgenerated'] = 'Não foi possível gerar todos os ficheiros: {$a}';
$string['filtername'] = 'Hiperligações automáticas à base de dados';
$string['footer'] = 'Rodapé';
$string['forcelinkname'] = 'Texto da hiperligação';
$string['foundnorecords'] = 'Não foram encontrados registos. <a href="{$a->reseturl}">Limpar tudo</a>';
$string['foundrecords'] = 'Encontrados {$a->num} de {$a->max} registos. <a href="{$a->reseturl}">Limpar tudo</a>';
$string['fromfile'] = 'Importar ficheiro Zip';
$string['fromfile_help'] = 'Esta configuração permite consultar e importar um Zip protótipo de modelos e campos de base de dados.';
$string['generateerror'] = 'Não foi possível gerar todos os ficheiros!';
$string['header'] = 'Cabeçalho';
$string['headeraddtemplate'] = 'Define a aparência da página de adição ou edição de registos.';
$string['headerasearchtemplate'] = 'Define a aparência da página de pesquisa avançada.';
$string['headercsstemplate'] = 'Adicionar CSS personalizado aos modelos.';
$string['headerjstemplate'] = 'Adicionar JavaScript personalizado para manipular como são mostrados nos modelos Lista, Simples ou Adicionar registo.';
$string['headerlisttemplate'] = 'Define a aparência do modo lista.';
$string['headerrsstemplate'] = 'Define a aparência dos registos nas listas RSS.';
$string['headersingletemplate'] = 'Define a aparência da página de registos individuais.';
$string['id'] = 'ID do registo';
$string['importandapply'] = 'Importar protótipo e aplicar';
$string['importapreset'] = 'Importar um protótipo';
$string['importentries'] = 'Importar registos';
$string['importpreset'] = 'Importar protótipo';
$string['importpreset_desc'] = 'O protótipo será aplicado a esta atividade, criando campos e modelos.
Não aparecerá na lista de potótipos.';
$string['importpresetmissingcapability'] = 'Não tem permissão para importar protótipos.';
$string['importsuccess'] = 'Protótipo aplicado com sucesso.';
$string['includeapproval'] = 'Incluir estado de aprovação';
$string['includefiles'] = 'Incluir ficheiros na exportação';
$string['includetags'] = 'Incluir palavras-chave';
$string['includetime'] = 'Incluir data de criação/modificação';
$string['includeuserdetails'] = 'Incluir detalhes do utilizador';
$string['indicator:cognitivedepth'] = 'Compreensão da Base de dados';
$string['indicator:cognitivedepth_help'] = 'Este indicador é baseado na capacidade cognitiva alcançada pelo aluno na atividade Base de dados.';
$string['indicator:cognitivedepthdef'] = 'Compreensão da Base de dados';
$string['indicator:cognitivedepthdef_help'] = 'O participante alcançou esta percentagem da capacidade cognitiva oferecida pelas atividades Base de dados durante esse intervalo de análise (Níveis = Não visualizado, Visualizado, Submetido)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Socialização da Base de dados';
$string['indicator:socialbreadth_help'] = 'Este indicador é baseado na extensão social alcançada pelo aluno na atividade Base de dados.';
$string['indicator:socialbreadthdef'] = 'Socialização da Base de dados';
$string['indicator:socialbreadthdef_help'] = 'O participante alcançou esta percentagem do relacionamento social oferecido pelas atividades Base de dados durante esse intervalo de análise (Níveis = Sem participação, Participante individual)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['insufficiententries'] = 'são necessários mais registos para ver esta base de dados';
$string['intro'] = 'Descrição';
$string['invalidaccess'] = 'Esta página não foi acedida corretamente';
$string['invalidfieldid'] = 'O ID do campo não está correto';
$string['invalidfieldname'] = 'Deve ser indicado outro nome para este campo';
$string['invalidfieldtype'] = 'O tipo de campo não está correto';
$string['invalidid'] = 'O ID da informação não está correto';
$string['invalidpreset'] = '<b>{$a}</b> não é um protótipo.';
$string['invalidrecord'] = 'Registo incorreto';
$string['invalidurl'] = 'O URL que inseriu não é válido';
$string['jstemplate'] = 'JavaScript personalizado';
$string['latitude'] = 'Latitude';
$string['latlong'] = 'Coordenadas';
$string['latlongboth'] = 'É necessário a latitude e a longitude.';
$string['latlongdownloadallhint'] = 'Hiperligação para descarregar todos os registos como KML';
$string['latlongkmllabelling'] = 'Como classificar itens em ficheiros KML (Google Earth)';
$string['latlonglinkservicesdisplayed'] = 'Mapas externos a mostrar';
$string['latlongotherfields'] = 'Outros campos';
$string['list'] = 'Ver lista';
$string['listtemplate'] = 'Modelo do modo lista';
$string['listview'] = 'Modo lista';
$string['longitude'] = 'Longitude';
$string['manageapproved'] = 'Permitir editar os registos já aprovados';
$string['manageapproved_help'] = 'Permitir que os alunos editem ou apaguem as suas entradas depois de serem aprovadas. As entradas editadas terão de ser aprovadas.';
$string['managefields'] = 'Gerir campos';
$string['mapexistingfield'] = 'Mapear para {$a}';
$string['mapnewfield'] = 'Criar novo campo';
$string['mapping:applypresets'] = 'Aplicar protótipo';
$string['mapping:dialogtitle:usepreset'] = 'Aplicar o protótipo {$a}?';
$string['mapping:fieldstocreate'] = 'Campos a serem criados: {$a}';
$string['mapping:fieldstodelete'] = 'Campos existentes a serem apagados: {$a}';
$string['mapping:mapfields'] = 'Mapear campos';
$string['mapping:warningmessagedelete'] = 'Se os campos a serem apagados forem do mesmo tipo que os novos campos no protótipo que está a aplicar, poderá mapeá-los em \'Mapear campos\'.';
$string['mapping:warningmessagedeleteandcreate'] = 'Se os campos a serem apagados forem do mesmo tipo que os novos campos a serem criados, poderá mapeá-los em \'Mapear campos\'.';
$string['mappingwarning'] = 'Todos os campos que não forem mapeados para novos campos serão apagados e a sua informação removida.';
$string['maxentries'] = 'Número máximo de registos';
$string['maxentries_help'] = 'Número máximo de registos que um utilizador pode submeter nesta atividade.';
$string['maxsize'] = 'Tamanho máximo';
$string['menu'] = 'Menu';
$string['menuchoose'] = 'Selecione...';
$string['missingdata'] = 'Tem de ser indicado um identificador de informação ou um objeto para a classe do campo.';
$string['missingfield'] = 'Erro de programação: Deve especificar um campo e/ou dados na definição da classe do campo.';
$string['missingfieldtype'] = 'Não foi encontrado o tipo de campo para \'{$a->name}\'';
$string['missingfieldtypeimport'] = 'Os campos a seguir não foram importados porque os seus tipos de campo correspondentes não estão instalados:';
$string['missingfieldtypes'] = 'Os campos a seguir não têm os seus tipos de campo correspondentes instalados e não serão incluídos no formulários de adicionar registos. É necessário verificar o modelo de Adicionar registo e remover todos os nomes de campo.';
$string['modulename'] = 'Base de dados';
$string['modulename_help'] = 'A atividade Base de dados permite aos participantes criar, gerir e pesquisar informação num conjunto de entradas.

A estrutura das entradas é definida usando diferentes tipos de campos, como texto curto, lista pendente, área de texto, URL, imagem ou ficheiro.

Como professor, pode comentar e avaliar entradas. Pode também permitir que os alunos avaliem e comentem as entradas (avaliação por pares). As avaliações podem ser agregadas para formar uma nota final, que é registada na pauta.

Se o filtro autoligação à base de dados estiver ativado, todas as entradas na base de dados serão vinculadas automaticamente às palavras ou frases que aparecem na disciplina.

A base de dados pode ser usada para:

* Criar um repositório colaborativo de hiperligações, livros, referências a jornais, etc.
* Mostrar trabalhos realizados pelos alunos (como fotos, cartazes, sites, poemas, etc.) para que os pares possam comentar e rever.';
$string['modulename_link'] = 'mod/data/view';
$string['modulenameplural'] = 'Bases de dados';
$string['more'] = 'Mais';
$string['moreurl'] = 'Mais URL';
$string['movezipfailed'] = 'Não é possível mover o ficheiro Zip';
$string['multientry'] = 'Registo repetido';
$string['multimenu'] = 'Menu (seleção múltipla)';
$string['multipletags'] = 'Foram encontrados múltiplos marcadores! O modelo não foi guardado';
$string['newentry'] = 'Novo registo';
$string['newfield'] = 'Criar campo';
$string['newfield_help'] = 'Um campo permite a inserção de um determinado tipo de informação. Cada registo da base de dados pode ter diversos campos, de vários tipos. Ex: Um campo <b>Data</b> permite aos participantes escolher um dia, mês e ano a partir de uma lista pendente; um campo <b>Imagem</b> permite aos participantes enviar um ficheiro de imagem; um campo <b>Caixa seleção</b> permite aos participantes selecionar uma ou mais opções.

Cada campo deve ter um nome único na estrutura do registo. A descrição do campo é opcional.';
$string['noaccess'] = 'Não tem permissão para aceder a esta página';
$string['nodefinedfields'] = 'Não existem campos definidos no novo protótipo!';
$string['nofieldcontent'] = 'O conteúdo do campo não foi encontrado';
$string['nofieldindatabase'] = 'Não existem campos definidos para esta base de dados.';
$string['nofields'] = 'Ainda não existem campos';
$string['nolisttemplate'] = 'O modelo do Modo lista ainda não foi definido';
$string['nomatch'] = 'Não foram encontrados registos correspondentes!';
$string['nomaximum'] = 'Não existe máximo';
$string['nopreviewavailable'] = 'Nenhuma pré-visualização disponível para {$a}';
$string['norecords'] = 'Ainda não existem registos';
$string['nosingletemplate'] = 'O modelo do modo registo ainda não foi definido';
$string['notapproved'] = 'Aprovação pendente';
$string['notapprovederror'] = 'O registo ainda não foi aprovado.';
$string['notemplates'] = 'Ainda sem modelos';
$string['notinjectivemap'] = 'Não é um mapa injetivo';
$string['notopenyet'] = 'A atividade apenas será disponibilizada em <b>{$a}</b>';
$string['number'] = 'Número';
$string['numberrssarticles'] = 'Entradas na lista RSS';
$string['numnotapproved'] = 'Pendente(s)';
$string['numrecords'] = '<b>{$a}</b> registos';
$string['ods'] = '<abbr title="OpenDocument Spreadsheet">ODS</abbr>&nbsp;(OpenOffice)';
$string['openafterclose'] = 'Indicou uma data de abertura posterior à data de fecho';
$string['optionaldescription'] = 'Descrição resumida (opcional)';
$string['optionalfilename'] = 'Nome do ficheiro (opcional)';
$string['other'] = 'Outro';
$string['otherfields'] = 'Todos os outros campos';
$string['overrwritedesc'] = 'Se ativar esta opção, o nome do protótipo será substituído por este e substituirá o conteúdo.';
$string['overwrite'] = 'Substituir';
$string['overwritesettings'] = 'Substituir configurações atuais, tais como, comentários, classificações, etc.';
$string['page-mod-data-x'] = 'Qualquer página da atividade Base de Dados';
$string['pagesize'] = 'Registos por página';
$string['participants'] = 'Utilizadores';
$string['picture'] = 'Imagem';
$string['pleaseaddsome'] = 'Crie campos abaixo ou <a href="{$a}">escolha um protótipo</a> para definir a estrutura da base de dados.';
$string['pluginadministration'] = 'Administração da Base de dados';
$string['pluginname'] = 'Base de dados';
$string['portfolionotfile'] = 'Exportar para portefólio em vez de para ficheiro (apenas CSV e Leap2a)';
$string['presetdeleted'] = 'Protótipo apagado.';
$string['presetinfo'] = 'Guardar como protótipo permite a outros utilizadores usar o mesmo nas suas bases de dados.';
$string['presetnotselected'] = 'Nenhum protótipo foi selecionado.';
$string['presets'] = 'Protótipos';
$string['presetshelp'] = 'Escolher protótipo para usar como ponto de partida';
$string['preview'] = 'Pré-visualização de {$a}';
$string['previewaction'] = 'Pré-visualização';
$string['privacy:metadata:commentpurpose'] = 'Comentários aos registos da Base de dados';
$string['privacy:metadata:data_content'] = 'O conteúdo de um campo';
$string['privacy:metadata:data_content:content'] = 'Conteúdo';
$string['privacy:metadata:data_content:content1'] = 'Conteúdo adicional 1';
$string['privacy:metadata:data_content:content2'] = 'Conteúdo adicional 2';
$string['privacy:metadata:data_content:content3'] = 'Conteúdo adicional 3';
$string['privacy:metadata:data_content:content4'] = 'Conteúdo adicional 4';
$string['privacy:metadata:data_content:fieldid'] = 'ID da definição do campo';
$string['privacy:metadata:data_records'] = 'Registos na atividade Base de dados';
$string['privacy:metadata:data_records:approved'] = 'Estado da aprovação';
$string['privacy:metadata:data_records:groupid'] = 'Grupo';
$string['privacy:metadata:data_records:timecreated'] = 'Data e hora de criação do registo';
$string['privacy:metadata:data_records:timemodified'] = 'Data e hora da última modificação';
$string['privacy:metadata:data_records:userid'] = 'Utilizador que criou o registo';
$string['privacy:metadata:datafieldnpluginsummary'] = 'Campos para a atividade Base de dados';
$string['privacy:metadata:filepurpose'] = 'Ficheiro anexado ao registo da Base de dados';
$string['privacy:metadata:ratingpurpose'] = 'Avaliações dos registos da Base de dados';
$string['privacy:metadata:tagpurpose'] = 'Palavras-chave do registo da Base de dados';
$string['radiobutton'] = 'Botões de rádio';
$string['recordapproved'] = 'Registo aprovado';
$string['recorddeleted'] = 'Registo apagado';
$string['recorddisapproved'] = 'Registo não aprovado';
$string['recordsnotsaved'] = 'Não foram guardados registos. Verifique o formato do ficheiro enviado.';
$string['recordssaved'] = 'os registos foram guardados';
$string['removealldatatags'] = 'Apagar todas as tags da base de dados';
$string['requireapproval'] = 'Requer aprovação dos registos';
$string['requireapproval_help'] = 'Um professor tem de aprovar as entradas antes de ficarem visíveis para todos os utilizadores.';
$string['required'] = 'Obrigatório';
$string['requiredentries'] = 'Registos requeridos para conclusão (antigo)';
$string['requiredentries_help'] = 'Se ativar esta opção, será mostrada uma mensagem para informar o número de registos necessários para a conclusão. Tenha em atenção que esta configuração não está ligada à conclusão da atividade.

Para os registos necessários para a conclusão da atividade, na nova configuração de conclusão da atividade, deve ser usada \'Requer registos\'. Para remover completamente esta definição, defina como Nenhum e, em seguida, guarde as alterações.
Em vez desta configuração, use "Requer registos" na secção "Conclusão da atividade".';
$string['requiredentriestoview'] = 'Registos requeridos antes de ser permitida a visualização';
$string['requiredentriestoview_help'] = 'Número de registos que o aluno tem de submeter antes de poder ver os registos dos outros participantes.

Não é compatível com o filtro Autoligação à base de dados.';
$string['requiredentrieswarning'] = 'Esta configuração foi substituída por uma configuração de conclusão da atividade "Requer registos"';
$string['requiredfield'] = 'Campo obrigatório';
$string['resetalltemplates'] = 'Reiniciar modelos';
$string['resetalltemplatesconfirm'] = 'Está prestes a remover todos os modelos do seu protótipo atual. Se pretender restaurar os modelos mais tarde, tem de escolher novamente o protótipo no separador \'Protótipos\'.';
$string['resetalltemplatesconfirmtitle'] = 'Reiniciar todos os modelos?';
$string['resetsettings'] = 'Reiniciar filtros';
$string['resettemplate'] = 'Reiniciar modelo atual';
$string['resettemplateconfirm'] = 'Removerá permanentemente {$a} do protótipo atual.';
$string['resettemplateconfirmtitle'] = 'Redefinir modelo?';
$string['resizingimages'] = 'A redimensionar imagens...';
$string['rows'] = 'linhas';
$string['rssglobaldisabled'] = 'Desativado. Consulte as variáveis de configuração do site.';
$string['rsstemplate'] = 'Modelo de lista RSS';
$string['rsstitletemplate'] = 'Listas RSS';
$string['rsstype'] = 'Lista RSS para esta atividade';
$string['save'] = 'Guardar';
$string['saveandadd'] = 'Guardar e adicionar outro';
$string['saveandview'] = 'Guardar e visualizar';
$string['saveaspreset'] = 'Publicar o protótipo neste site';
$string['saveaspreset_help'] = 'Guardar como protótipo permite gguardar os modelos existentes e os campos da base de dados como um protótipo que os outros utilizadores podem usar. Em qualquer momento poderá apagar o protótipo da lista de protótipos.';
$string['saveaspresetmissingcapability'] = 'O utilizador não tem permissão para guardar a base de dados como um protótipo.';
$string['savedataaspreset'] = 'Guardar todos os campos e modelos e publicar como protótipo neste site.';
$string['savesettings'] = 'Guardar configurações';
$string['savesuccess'] = 'Protótipo guardado. <a href="{$a->url}">Pré-visualizar protótipo</a>';
$string['savetemplate'] = 'Guardar modelo';
$string['search'] = 'Pesquisar';
$string['search:activity'] = 'Base de dados - informações da atividade';
$string['search:entry'] = 'Base de dados - registos';
$string['searchresults'] = 'Registos que contêm "{$a}"';
$string['selectedrequired'] = 'Todos os selecionados são obrigatórios';
$string['selectexportoptions'] = 'Selecione as opções da exportação';
$string['selectfields'] = 'Selecionar campos';
$string['selectfordeletion'] = 'Selecione o registo para apagar';
$string['showall'] = 'Mostrar todos os registos';
$string['showmore'] = 'Mostrar mais';
$string['single'] = 'Ver registo';
$string['singletemplate'] = 'Modelo do modo registo';
$string['singleview'] = 'Modo registo';
$string['startbuilding'] = 'Comece a construir a atividade';
$string['subplugintype_datafield'] = 'Tipo de campo da base de dados';
$string['subplugintype_datafield_plural'] = 'Tipos de campo da base de dados';
$string['subplugintype_datapreset'] = 'Protótipo';
$string['subplugintype_datapreset_plural'] = 'Protótipos';
$string['tagarea_data_records'] = 'Registos de dados';
$string['tags'] = 'Palavras-chave';
$string['tagsdeleted'] = 'Todas as palavras-chave da base de dados foram apagadas';
$string['teachersandstudents'] = '{$a->teachers} e {$a->students}';
$string['templatereset'] = 'Redefinir modelo';
$string['templateresetall'] = 'Todos os modelos foram reiniciados';
$string['templates'] = 'Modelos';
$string['templatesaved'] = 'O modelo foi guardado';
$string['templatesnavigation'] = 'Navegação terciária dos modelos';
$string['text'] = 'Texto';
$string['textarea'] = 'Área de texto';
$string['timeadded'] = 'Data e hora de criação';
$string['timemodified'] = 'Data e hora de modificação';
$string['todatabase'] = 'para esta base de dados.';
$string['type'] = 'Tipo de campo';
$string['undefinedprocessactionmethod'] = 'Não foi definido o método de ação em Data_Preset para executar a ação "{$a}".';
$string['unknown'] = 'Campo desconhecido';
$string['unsupportedfields'] = 'Campos não suportados';
$string['unsupportedfieldslist'] = 'Os seguintes campos não podem ser exportados:';
$string['updatefield'] = 'Atualizar um campo existente';
$string['uploadfile'] = 'Enviar ficheiro';
$string['uploadrecords'] = 'Importar registos';
$string['uploadrecords_help'] = 'Importar registos que exportou de outra base de dados, via CSV ou Zip contendo um ficheiro CSV (se os ficheiros forem incluídos na exportação).

Como alternativa, para criar um ficheiro CSV para importação, adicione um registo à base de dados e exporte-o. Edite o ficheiro CSV e adicione mais registos.';
$string['uploadrecords_link'] = 'mod/data/import';
$string['url'] = 'URL';
$string['usedate'] = 'Incluir na pesquisa.';
$string['usepredefinedset'] = 'Usar predefinido';
$string['usepreset'] = 'Usar este protótipo';
$string['usestandard'] = 'Usar um protótipo';
$string['usestandard_help'] = 'Para criar a base de dados a partir de um protótipo, selecione um da lista. (Se adicionou um protótipo ao <b>Guardar como protótipo</b> pode remover o mesmo em qualquer momento).';
$string['viewfromdate'] = 'Só consulta a partir de';
$string['viewnavigation'] = 'Navegação terciária do modo de visualização';
$string['viewtemplates'] = 'Ver modelos';
$string['viewtodate'] = 'Só consulta até';
$string['viewtodatevalidation'] = '"Apenas de leitura até" não pode ser anterior a "Apenas de leitura a partir de".';
$string['wrongdataid'] = 'O ID dos dados fornecido é inválido';
