<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'lti', language 'lt', version '4.4'.
 *
 * @package     lti
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accept'] = 'Priimti';
$string['accept_grades'] = 'Priimti įvertinimus iš įrankio';
$string['accept_grades_admin'] = 'Priimti įvertinimus iš įrankio';
$string['accept_grades_admin_help'] = 'Nurodykite, ar įrankio teikėjas gali pridėti, atnaujinti, skaityti ir ištrinti įverčius, susijusius su šio įrankio egzemplioriais.

Kai kurie įrankių teikėjai palaiko įvertinimų ataskaitų teikimą atgal į Moodle, atsižvelgdami į įrankyje atliekamus veiksmus, taip sukurdami labiau integruotą patirtį.';
$string['accept_grades_from_tool'] = 'Leisti {$a} pridėti įvertinimus į įvertinimų knygelę';
$string['accept_grades_help'] = 'Nurodykite, ar įrankio teikėjas gali pridėti, atnaujinti, skaityti ir ištrinti įverčius, susijusius tik su šiuo išorinio įrankio egzemplioriumi.

Kai kurie įrankių teikėjai palaiko įvertinimų ataskaitų teikimą atgal į Moodle, atsižvelgdami į įrankyje atliekamus veiksmus, taip sukurdami labiau integruotą patirtį.

Atminkite, kad šis nustatymas gali būti pakeistas įrankio konfigūracijoje.';
$string['accepted'] = 'Priimtas';
$string['action'] = 'Veiksmas';
$string['activate'] = 'Aktyvuoti';
$string['activatetoadddescription'] = 'Turite aktyvuoti šį įrankį prieš pridėdami aprašymą.';
$string['active'] = 'Veiklus';
$string['activity'] = 'Veikla';
$string['add_ltiadv'] = 'Pridėti LTI Advantage';
$string['add_ltilegacy'] = 'Pridėti Legacy LTI';
$string['addnewapp'] = 'Įjungti išorines programas';
$string['addserver'] = 'Pridėti naują patikimą serverį';
$string['addtool'] = 'Pridėti įrankį';
$string['addtype'] = 'Pridėkite iš anksto sukonfigūruotą įrankį';
$string['allow'] = 'Leisti';
$string['allowsetting'] = 'Leisti įrankiu talpinti 8K nustatymų Moodle';
$string['always'] = 'Visada';
$string['autoaddtype'] = 'Įtraukti įrankį';
$string['automatic'] = 'Automatinis, pagal įrankį URL';
$string['baseurl'] = 'Bazinis URL / įrankio registracijos pavadinimas';
$string['basiclti'] = 'LTI';
$string['basiclti_base_string'] = 'LTI OAuth bazinė eilutė';
$string['basiclti_endpoint'] = 'LTI paleidimo pabaigos taškas';
$string['basiclti_in_new_window'] = 'Jūsų veikla atsidarė naujame lange';
$string['basiclti_in_new_window_open'] = 'Atverti naujame lange';
$string['basiclti_parameters'] = 'LTI paleidimo parametrai';
$string['basicltiactivities'] = 'LTI veiklos';
$string['basicltifieldset'] = 'Individualaus pavyzdžio lauko rinkinio';
$string['basicltiintro'] = 'Veiklos aprašymas';
$string['basicltiname'] = 'Veiklos pavadinimas';
$string['basicltisettings'] = 'Bazinio mokymosi įrankio sąveikos nustatymai';
$string['cachedef_keyset'] = 'Išsaugo įrankių raktų rinkinio informaciją talpykloje';
$string['cancel'] = 'Atšaukti';
$string['cancelled'] = 'Atšauktas';
$string['cannot_delete'] = 'Jums negalima ištrinti šio įrankio nustatymų';
$string['cannot_edit'] = 'Jums negalima keisti šio įrankio nustatymų';
$string['capabilities'] = 'Galimybės';
$string['capabilities_help'] = 'Pasirinkite tas galimybes, kurias norite pasiūlyti įrankių teikėjui. Galima pasirinkti daugiau nei vieną galimybę.';
$string['capabilitiesrequired'] = 'Norint aktyvuoti šį įrankį, reikia turėti prieigą prie šių duomenų:';
$string['cleanaccesstokens'] = 'Išorinis įrankis pašalina pasibaigusio galiojimo prieigos raktus';
$string['click_to_continue'] = '<a href="{$a->link}" target="_top">Spragtelkite, kad tęsti</a>';
$string['clientidadmin'] = 'Kliento ID';
$string['clientidadmin_help'] = 'Kliento ID yra unikali reikšmė, naudojama įrankiui identifikuoti. Jis sukuriamas automatiškai kiekvienam įrankiui, kuriame naudojamas JWT saugos profilis, įdiegtas LTI 1.3 versijoje, ir turėtų būti dalis informacijos, perduodamos įrankio tiekėjui, kad jie galėtų konfigūruoti ryšį.';
$string['comment'] = 'Komentaras';
$string['configpassword'] = 'Numatytas nuotolinio įrankio slaptažodis';
$string['configpreferheight'] = 'Numatytas pageidautinas aukštis';
$string['configpreferwidget'] = 'Nustatyti įtaisėlį kaip numatytą pradžią';
$string['configpreferwidth'] = 'Numatytas pageidautinas plotis';
$string['configresourceurl'] = 'Numatytas išteklius URL';
$string['configtoolurl'] = 'Numatytas išorinio įrankio URL';
$string['configtypes'] = 'Įjungti LTI aplikacijas.';
$string['configured'] = 'Sukonfigūruotas';
$string['confirmtoolactivation'] = 'Ar esate įsitikinę, jog norite aktyvuoti šį įrankį?';
$string['contentitem_deeplinking'] = 'Palaiko gilųjį susiejimą (Turinio elemento pranešimas)';
$string['contentitem_deeplinking_help'] = 'Jei pažymėta, parinktis „Pasirinkti turinį“ bus matoma pridedant išorinį įrankį.';
$string['contentitem_multiple_description'] = 'Į jūsų kursą bus įtraukti šie elementai:';
$string['contentitem_multiple_graded'] = 'Įvertinta veikla (maksimalus įvertinimas: {$a})';
$string['contentselected'] = 'Pasirinktas turinys';
$string['course_tool_types'] = 'Kurso įrankiai';
$string['courseactivitiesorresources'] = 'Kurso veiklos arba ištekliai';
$string['courseexternaltooladd'] = 'Pridėti naują LTI išorinį įrankį';
$string['courseexternaltooladdsuccess'] = '{$a} pridėta.';
$string['courseexternaltooledit'] = 'Redaguoti {$a}';
$string['courseexternaltooleditsuccess'] = 'Pakeitimai išsaugoti.';
$string['courseexternaltooliconalt'] = 'Ikona {$a}';
$string['courseexternaltools'] = 'LTI Išoriniai įrankiai';
$string['courseexternaltoolsinfo'] = 'LTI išorinės priemonės - tai papildomos programos, kurias galite integruoti į savo kursą, pavyzdžiui, interaktyvų turinį ar vertinimus. Besimokantieji gali jas pasiekti ir naudoti neišeidami iš kurso.';
$string['courseexternaltoolsnoeditpermissions'] = 'Jūs neturite teisės redaguoti šio įrankio';
$string['courseexternaltoolsnoviewpermissions'] = 'Peržiūrėti kurso išorinius įrankius';
$string['courseid'] = 'Kurso ID numeris';
$string['courseinformation'] = 'Kurso informacija';
$string['courselink'] = 'Eiti į kursą';
$string['coursemisconf'] = 'Kursas yra blogai sukonfigūruotas';
$string['coursetooldeleted'] = '{$a} ištrinta';
$string['createdon'] = 'Sukurtas';
$string['curllibrarymissing'] = 'PHP cURL plėtinys reikalingas išoriniam įrankiui.';
$string['custom'] = 'Individualūs parametrai';
$string['custom_config'] = 'Naudojama individuali įrankio konfigūracija';
$string['custom_help'] = 'Tinkinti parametrai yra nustatymai, kuriuos naudoja įrankio teikėjas. Pavyzdžiui, tinkintas parametras gali būti naudojamas konkrečiam teikėjo ištekliui parodyti. Kiekvienas parametras turi būti įvestas atskiroje eilutėje, naudojant formatą „name=value"; for example, "chapter=3“.

Saugu palikti šį lauką nepakeistą, nebent įrankio tiekėjas nurodytų.';
$string['custominstr'] = 'Individualūs parametrai';
$string['debuglaunch'] = 'Derinimo nustatymai';
$string['debuglaunchoff'] = 'Normali paleistis';
$string['debuglaunchon'] = 'Derinimo paleistis';
$string['default'] = 'Numatyta';
$string['default_launch_container'] = 'Numatytasis paleidimo konteineris';
$string['default_launch_container_help'] = 'Paleidimo konteineris turi įtakos įrankio ekranui, kai jis paleistas iš kurso. Kai kurie paleidimo konteineriai suteikia įrankiui daugiau ekrano vietos, o kiti suteikia labiau integruotą Moodle aplinkos pojūtį.

* **Numatytasis** – naudoti paleidimo konteinerį, nurodytą įrankio konfigūracijoje.
* **Įterpti** – įrankis rodomas esamame Moodle lange panašiai kaip ir daugelis kitų veiklos tipų.
* **Įterpti be blokų** – įrankis rodomas esamame „Moodle“ lange, naudojant tik naršymo valdiklius
         puslapio viršuje.
* **Naujas langas** – įrankis atsidaro naujame lange, užimdamas visą laisvą vietą.
         Priklausomai nuo naršyklės, jis bus atidarytas naujame skirtuke arba iššokančiajame lange.
         Gali būti, kad naršyklės neleis atidaryti naujo lango.';
$string['delegate'] = 'Deleguoti pas dėstytoją';
$string['delegate_tool'] = 'Kaip nurodyta giliojo susiejimo apibrėžime arba Deleguoti dėstytojui';
$string['delete'] = 'Pašalinti';
$string['delete_confirmation'] = 'Ar esate įsitikinęs, kad norite pašalinti šį nustatytą įrankį?';
$string['deletecoursetool'] = 'Ištrinti {$a}';
$string['deletecoursetoolconfirm'] = 'Tai ištrins {$a} iš jūsų kurso galimų LTI įrankių.';
$string['deletecoursetoolwithusageconfirm'] = '{$a} šiuo metu naudojamas bent vienoje jūsų kurso veikloje. Jei ištrinsite šį įrankį, jį naudojanti veikla nebeveiks.<br><br>Ar tikrai norite ištrinti {$a}?';
$string['deletetype'] = 'Pašalinti iš anksto sukonfigūruotą įrankį';
$string['display_description'] = 'Rodyti veiklos aprašymą, kai besimokantieji prisijungia prie įrankio';
$string['display_description_help'] = 'Šio įrankio turinys rodomas įterptas į kurso puslapį. Šis nustatymas lemia, ar tame puslapyje bus rodomas veiklos aprašymas.';
$string['display_name'] = 'Rodyti veiklos pavadinimą, kai besimokantieji prisijungia prie įrankio';
$string['display_name_help'] = 'Šio įrankio turinys rodomas įterptas į kurso puslapį. Šis nustatymas lemia, ar tame puslapyje bus rodomas veiklos pavadinimas.';
$string['domain_mismatch'] = 'Įrankio URL domenas neatitinka įrankio konfigūracijos.';
$string['donot'] = 'Nesiųsti';
$string['donotaccept'] = 'Nepriimti';
$string['donotallow'] = 'Neleisti';
$string['dontshowinactivitychooser'] = 'Nerodyti veiklos parinkiklio';
$string['duplicateregurl'] = 'Ši registracijos URL jau naudojama';
$string['dynreg_update_btn_new'] = 'Užsiregistruoti kaip naują išorinį įrankį';
$string['dynreg_update_btn_update'] = 'Atnaujinti';
$string['dynreg_update_name'] = 'Įrankio pavadinimas';
$string['dynreg_update_notools'] = 'Nėra įrankių kontekste.';
$string['dynreg_update_text'] = 'Prie registracijos domeno yra prijungti esami įrankiai. Ar norite atnaujinti jau įdiegtą išorinį įrankį ar sukurti naują išorinį įrankį?';
$string['dynreg_update_url'] = 'Bazinis URL';
$string['dynreg_update_version'] = 'LTI versija';
$string['dynreg_update_warn_dupdomain'] = 'Nerekomenduojama tame pačiame domene turėti kelių išorinių įrankių.';
$string['editdescription'] = 'Spustelėkite čia veiklos aprašymo peržiūrai';
$string['edittype'] = 'Redaguoti iš anksto sukonfigūruotą įrankį';
$string['embed'] = 'Įdėti';
$string['embed_no_blocks'] = 'Įdėti be blokų';
$string['enableemailnotification'] = 'Siųsti pranešimus el. laišku';
$string['enableemailnotification_help'] = 'Jei įjungta, besimokantieji gaus el. laiško patvirtinimą kai jų įrankio pateikimas buvo įvertintas.';
$string['enterkeyandsecret'] = 'Įveskite naudotojo raktą ir pasidalykite paslaptimi';
$string['enterkeyandsecret_help'] = 'Jei Jums buvo suteiktas naudotojo raktas ir/arba bendra paslaptis, juos įveskite  čia';
$string['entitycourseexternaltools'] = 'LTI Išoriniai įrankiai';
$string['errorbadurl'] = 'URL nėra galiojantis įrankio URL arba kasetė.';
$string['errorincorrectconsumerkey'] = 'Neteisingas naudotojo raktas.';
$string['errorinvaliddata'] = 'Netinkama data: {$a}';
$string['errorinvalidmediatype'] = 'Netinkamas medijos tipas: {$a}';
$string['errorinvalidresponseformat'] = 'Netinkamas turinio elemento atsakymo formatas.';
$string['errormisconfig'] = 'Prastai sukonfigūruotas įrankis. Prašau paprašyti savo Moodle administratoriaus sutvarkyti šią klaidą.';
$string['errortooltypenotfound'] = 'LTI įrankio tipas nerastas.';
$string['existing_window'] = 'Esamas langas';
$string['extensions'] = 'LTI išplėtimo paslauga';
$string['external_tool_type'] = 'Iš anksto sukonfigūruotas įrankis';
$string['external_tool_type_help'] = '* *** **Automatinis, pagal įrankio URL** – geriausia įrankio konfigūracija parenkama automatiškai. Jei įrankio URL neatpažįstamas, įrankio konfigūracijos informaciją gali reikėti įvesti rankiniu būdu.
* **Konkretus iš anksto sukonfigūruotas įrankis** – nurodyto įrankio konfigūracija bus naudojama bendraujant su išoriniu įrankio tiekėju. Jei atrodo, kad įrankio URL nepriklauso įrankio tiekėjui, bus rodomas įspėjimas. Ne visada būtina įvesti įrankio URL.
* **Tinkinta konfigūracija** – naudotojo raktą ir bendrinamą paslaptį gali reikėti įvesti rankiniu būdu. Naudotojo raktą ir bendrinamą paslaptį galima gauti iš įrankio tiekėjo. Tačiau ne visiems įrankiams reikalingas naudotojo raktas ir bendrinama paslaptis, tokiu atveju laukai gali būti palikti tušti.

### Iš anksto sukonfigūruoto įrankio redagavimas

Po iš anksto sukonfigūruoto įrankio iškrentančiu meniu yra trys piktogramos::
* **Pridėti** – sukurkite kurso lygio įrankio konfigūraciją. Visi šio kurso išoriniai įrankių egzemplioriai gali naudoti įrankio konfigūraciją.
* **Redaguoti** – iškrentančiame meniu pasirinkite kurso lygio įrankį, tada spustelėkite šią piktogramą. Išsamią įrankio konfigūracijos informaciją galima redaguoti.
* **Ištrinti** – pašalinkite pasirinktą kurso lygio įrankį.';
$string['external_tool_types'] = 'Iš anksto sukonfigūruoti įrankiai';
$string['failedtoconnect'] = 'Moodle nepavyko susisiekti su "$a" sistema';
$string['failedtocreatetooltype'] = 'Nepavyko sukurti naujo įrankio. Patikrinkite URL ir bandykite dar kartą.';
$string['failedtodeletetoolproxy'] = 'Nepavyko ištrinti įrankio registracijos. Gali tekti apsilankyti „Tvarkyti išorinių įrankių registracijas“ ir ištrinti jį rankiniu būdu.';
$string['filter_basiclti_configlink'] = 'Nustatyti jūsų norimas svetaines ir jų slaptažodžius';
$string['filter_basiclti_password'] = 'Slaptažodis yra privalomas';
$string['filterconfig'] = 'LTI administratorius';
$string['filtername'] = 'LTI';
$string['fixexistingconf'] = 'Naudokite esamus nustatymus blogai sukonfigūruotam pavyzdžiui';
$string['fixnew'] = 'Nauji nustatymai';
$string['fixnewconf'] = 'Nustatyti naujus nustatymus blogai sukonfigūruotam pavyzdžiui';
$string['fixold'] = 'Naudoti esamą';
$string['force_ssl'] = 'Priversti SSL';
$string['force_ssl_help'] = 'Pasirenkant šį nustatymą priverčia visus paleidimus šio įrankio tiekėjui naudoti SSL. Visų  voratinklio paslaugų užklausos iš įrankio tiekėjo naudos SSL. Jei naudojate šį nustatymą, patvirtinkite kad Moodle svetainė ir įrankio tiekėjas palaiko SSL.';
$string['forced_help'] = 'Šis nustatymas buvo priverstinai pridėtas į kursą arba svetainės lygio įrankio konfigūravimu. Jūs negalite jo keisti per šią grafinę sąsają.';
$string['generaltool'] = 'Bendra priemonė';
$string['global_tool_types'] = 'Iš anksto sukonfigūruoti įrankiai';
$string['grading'] = 'Vertinimo maršrutai';
$string['icon_url'] = 'Piktogramos URL';
$string['icon_url_help'] = 'Piktogramos URL leidžia modifikuoti piktogramos pasirodymą kurso sąrašuose. Vietoj to kad naudoti numatytąją LTI piktogramą, piktograma piktograma kuri perteikia veiklos tipą gali būti apibūdinta.';
$string['id'] = 'ID';
$string['indicator:cognitivedepth'] = 'LTI kognityvinis';
$string['indicator:cognitivedepth_help'] = 'Šis rodiklis pagrįstas pažinimo gyliu, kurį besimokantysis pasiekia LTI veikloje.';
$string['indicator:cognitivedepthdef'] = 'LTI kognityvinis';
$string['indicator:cognitivedepthdef_help'] = 'Dalyvis per šį analizės intervalą pasiekė šią LTI veiklų siūlomą pažinimo įtraukimo procentą (Lygiai = Nėra peržiūros, Peržiūra, Pateikimas, Atsiliepimų peržiūra)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'LTI socialinis';
$string['indicator:socialbreadth_help'] = 'Šis rodiklis pagrįstas socialiniu platumu, kurį besimokantysis pasiekia LTI veikloje.';
$string['indicator:socialbreadthdef'] = 'LTI socialinis';
$string['indicator:socialbreadthdef_help'] = 'Dalyvis per šį analizės intervalą pasiekė šį socialinio įsitraukimo procentą, kurį siūlo LTI veikla (Lygiai = Nedalyvauja, Dalyvis vienas, Dalyvis su kitais)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['initiatelogin'] = 'Inicijuoti prisijungimo URL';
$string['initiatelogin_help'] = 'Įrankio URL, į kurį turi būti siunčiamos užklausos inicijuoti prisijungimą. Šis URL reikalingas, kad pranešimas būtų sėkmingai išsiųstas įrankiui.';
$string['invalidid'] = 'LTI ID buvo neteisingas';
$string['jwtsecurity'] = 'LTI 1.3';
$string['keytype'] = 'Viešojo rakto tipas';
$string['keytype_help'] = 'Autentifikavimo metodas, naudojamas įrankiui patvirtinti.';
$string['keytype_keyset'] = 'Raktų rinkinio URL';
$string['keytype_rsa'] = 'RSA raktas';
$string['launch_in_moodle'] = 'Paleidimo įrankis Moodle';
$string['launch_in_popup'] = 'Paleidimo įrankis iššokančiame lange';
$string['launch_url'] = 'Įrankio URL';
$string['launch_url_help'] = 'Įrankio URL nurodo išorinio įrankio žiniatinklio adresą ir gali turėti papildomos informacijos, pvz., rodytino šaltinio.
Jei nesate tikri, ką įvesti įrankio URL, daugiau informacijos teiraukitės įrankio teikėjo.

Galite įvesti kasetės URL, jei tokį turite, o likusi formos informacija bus užpildyta automatiškai.

Jei pasirinkote iš anksto sukonfigūruotą įrankį, jums gali nereikėti įvesti įrankio URL. Jei įrankio nuoroda naudojama tiesiog paleisti į įrankio tiekėjo sistemą, o ne nukreipti į konkretų šaltinį, greičiausiai taip ir bus.';
$string['launchinpopup'] = 'Paleidimo konteineris';
$string['launchinpopup_help'] = 'Paleidimo konteineris turi įtakos įrankio ekranui, kai jis paleistas iš kurso. Kai kurie paleidimo konteineriai suteikia įrankiui daugiau ekrano vietos, o kiti suteikia labiau integruotą Moodle aplinkos pojūtį.

* **Numatytasis** – naudoti paleidimo konteinerį, nurodytą įrankio konfigūracijoje.
* **Įterpti** – įrankis rodomas esamame Moodle lange panašiai kaip ir daugelis kitų veiklos tipų.
* **Įterpti be blokų** – įrankis rodomas esamame „Moodle“ lange, naudojant tik naršymo valdiklius
         puslapio viršuje.
* **Naujas langas** – įrankis atsidaro naujame lange, užimdamas visą laisvą vietą.
         Priklausomai nuo naršyklės, jis bus atidarytas naujame skirtuke arba iššokančiajame lange.ujo lango.';
$string['launchoptions'] = 'Paleidimo nustatymai';
$string['lti'] = 'LTI';
$string['lti:addcoursetool'] = 'Vertinti LTI veiklą';
$string['lti:addinstance'] = 'Pridėti naują išorinį įrankį';
$string['lti:addmanualinstance'] = 'Pridėti rankiniu būdu sukonfigūruotą įrankį';
$string['lti:addmanualinstanceprohibitederror'] = 'Įrankių kūrimas rankiniu būdu be kurso įrankio apibrėžties nebepalaikomas. Pirmiausia sukurkite kurso įrankį, o tada naudokite jį veiklos atvejams kurti.';
$string['lti:addpreconfiguredinstance'] = 'Pridėti iš anksto sukonfigūruotą įrankį';
$string['lti:admin'] = 'Būkite administratoriumi paleidę įrankį';
$string['lti:grade'] = 'Vertinti LTI veiklą';
$string['lti:manage'] = 'Redaguoti LTI veiklą';
$string['lti:requesttooladd'] = 'Patvirtinkite įrankį administratoriams konfigūruoti';
$string['lti:view'] = 'Peržiūrėti LTI veiklas';
$string['lti_administration'] = 'Redaguoti iš anksto sukonfigūruotą įrankį';
$string['lti_errormsg'] = 'Įrankis gražino tokią klaidos žinutę: "$a"';
$string['lti_launch_error'] = 'Įvyko klaida paleidžiant išorinį įrankį';
$string['lti_launch_error_tool_request'] = '<p> Pateikti prašymą administratoriui kad užbaigti įrankio konfigūraciją, spauskite  <a href="{$a->admin_request_url}" target="_top">čia</a>. </p>';
$string['lti_launch_error_unsigned_help'] = '<p> Ši klaida gali būti rezultatas nerasto naudotojo rakto ar bendros paslapties įrankio tiekėjui. </p> <p> Jei turite naudotojo raktą raktą ir bendrą raktą, jūs galite įvesti jį kai redaguojate išorinio įrankio kopiją (įsitikinkite kad papildomi pasirinkimai yra matomi). <br /> Kitu atveju, jūs galite sukurti kurso lygio įrankio tiekėjo konfigūraciją <a href="{$a->course_tool_editor}">čia</a>. </p>';
$string['lti_tool_request_added'] = 'Įrankio nustatymų užklausa buvo sėkmingai priimta. Jums gali reikėti susisiekti su administratoriumi,kad užbaigti įrankio konfigūraciją.';
$string['lti_tool_request_existing'] = 'Įrankio konfigūracija įrankio domenui jau buvo pateikta.';
$string['ltisettings'] = 'LTI nustatymai';
$string['ltiunknownserviceapicall'] = 'LTI nežinomos paslaugos API kreipimasis.';
$string['ltiversion'] = 'LTI versija';
$string['ltiversion_help'] = 'Pranešimams ir paslaugų užklausoms pasirašyti naudojama LTI versija: LTI 1.0/1.1 ir LTI 2.0 naudoja OAuth 1.0A saugos profilį; LTI 1.3.0 naudoja JWT.';
$string['main_admin'] = 'Bendra pagalba';
$string['main_admin_help'] = 'Išoriniai įrankiai leidžia Moodle naudotojams bendrauti su nuotoliniu būdu priglobtais mokymosi ištekliais. Naudodamas specialų paleidimo protokolą, nuotolinis įrankis turi prieigą prie bendros informacijos apie paleidžiantį vartotoją. Pavyzdžiui, institucijos pavadinimo, kurso ID, naudotojo ID ir kitos informacijos, pvz., naudotojo vardo arba el. pašto adreso.

Šiame puslapyje išvardyti įrankiai yra suskirstyti į tris kategorijas:

* **Aktyvus** – šiuos įrankių tiekėjus patvirtino ir sukonfigūravo administratorius. Jie gali būti naudojami bet kuriame šios svetainės kurse. Jei įvedamas vartotojo raktas ir bendra paslaptis, tarp šios svetainės ir nuotolinio įrankio užmezgamas pasitikėjimo ryšys, užtikrinantis saugų ryšio kanalą.
* **Laukiama** – šie įrankių tiekėjai buvo gauti importuojant paketą, bet jų nesukonfigūravo administratorius. Dėstytojai vis tiek gali naudoti šių teikėjų įrankius, jei jie turi vartotojo raktą ir bendrinamą paslaptį arba jei jo nereikia.
* **Atmesta** – šie įrankių tiekėjai pažymėti kaip tie, kurių administratorius neketina pateikti svetainėje. Dėstytojai vis tiek gali naudoti šių teikėjų įrankius, jei jie turi vartotojo raktą ir bendrinamą paslaptį arba jei jo nereikia.';
$string['manage_external_tools'] = 'Tvarkyti įrankius';
$string['manage_tool_proxies'] = 'Tvarkyti išorinių įrankių registracijas';
$string['manage_tools'] = 'Tvarkykite iš anksto sukonfigūruotus įrankius';
$string['manuallyaddtype'] = 'Arba galite <a href="{$a}">konfigūruoti įrankį rankiniu būdu</a>.';
$string['miscellaneous'] = 'Kita';
$string['misconfiguredtools'] = 'Blogai sukonfigūruotas pavyzdys aptiktas';
$string['missingparameterserror'] = 'Puslapis yra blogai sukonfigūruotas: "$a"';
$string['module_class_type'] = 'Moodle modulio tipai';
$string['modulename'] = 'Išorinis įrankis';
$string['modulename_help'] = 'Išoriniai įrankiai leidžia Moodle naudotojams bendrauti su mokymosi ištekliais ir veiklomis kitose internetiniuose puslapiuose. Pavyzdžiui, išorinis įrankis gali suteikti priėjimą prie naujos veiklos tipo ar mokymosi medžiagos iš leidėjo. Kad nustatyti išorinio įrankio kopiją yra reikalingas įrankio tiekėjas kuris palaiko MĮS (Mokymosi įrankio sąveiką(angl. LTI)) . Jei susiradote įrankio tiekėją kuris palaiko MĮS, jis turėtų pateikti ir nurodymus kaip nusistatyti išorinio įrankio kopiją. Papildomai, įrankio tipus sukonfigūruotus puslapio administratoriaus taip pat bus galima naudoti. Išoriniai įrankiai skiriasi nuo URL išteklių: * **Žinantis kontekstą** - Išoriniai įrankiai turi priėjimą prie informacijos apie naudotoją(įstaiga, kursas, vardas ir kt. informacija) kuris paleido įrankį. * **Gili integracija** - Išorinis įrankis palaiko skaitymą, atnaujinimą ir įvertinimų ištrynimą susijusį su veiklos kopija. Daugiau integracijos punktų yra suplanuota naujausiuose leidimuose. * **Sauga** - Išorinio įrankio nustatymai sukuria patikimą ryšį tarp Moodle ir įrankio tiekėjo, leidžiančio apsaugotą ryšį tarp jų.';
$string['modulename_link'] = 'mod/lti/view';
$string['modulename_shortcut_link'] = 'mod/lti/view/custom';
$string['modulenameplural'] = 'Išoriniai įrankiai';
$string['modulenamepluralformatted'] = 'Išoriniai įrankiai';
$string['name'] = 'Pavadinimas';
$string['never'] = 'Niekada';
$string['new_window'] = 'Naujas langas';
$string['no_lti_configured'] = 'Nėra jokio aktyvaus sukonfigūruoto išorinio įrankio.';
$string['no_lti_pending'] = 'Nėra nei vieno laukiančio išorinio įrankio.';
$string['no_lti_rejected'] = 'Nėra nei vieno atmesto išorinio įrankio.';
$string['no_lti_tools'] = 'Nėra nustatytų išorinių įrankių.';
$string['no_tp_accepted'] = 'Nėra priimtų išorinių įrankių registracijų.';
$string['no_tp_cancelled'] = 'Nėra atšauktų išorinių įrankių registracijų.';
$string['no_tp_configured'] = 'Nustatytų neregistruotų išorinių įrankių registracijų nėra.';
$string['no_tp_pending'] = 'Nėra laukiančių išorinių įrankių registracijų.';
$string['no_tp_rejected'] = 'Nėra pašalintų išorinių įrankių registracijų.';
$string['noattempts'] = 'Nebuvo jokių bandymų šio įrankio kopijoj.';
$string['nocourseexternaltoolsnotice'] = 'LTI išorinių įrankių dar nėra.';
$string['noltis'] = 'Nėra išorinių įrankių kopijų';
$string['noprofileservice'] = 'Profilio paslauga nerasta';
$string['noservers'] = 'Nerastas joks serveris';
$string['notypes'] = 'Šiuo metu nėra nei vienos LTI įrankio instaliacijos Moodle. Spauskite „Diegti“ nuorodą aukščiau, kad pridėti.';
$string['noviewusers'] = 'Nerastas nei vienas naudotojas su leidimu naudoti šį įrankį';
$string['oauthsecurity'] = 'LTI 1.0/1.1';
$string['opensslconfiginvalid'] = 'Naudojant LTI 1.3 reikia sukonfigūruoti galiojantį openssl.cnf failą, kuris būtų pasiekiamas jūsų interneto serveriui. Norėdami sukonfigūruoti ir įjungti šios svetainės openssl, susisiekite su svetainės administratoriumi.';
$string['optionalsettings'] = 'Papildomi nustatymai';
$string['organization'] = 'Organizacijos informacija';
$string['organizationdescr'] = 'Organizacijos aprašas';
$string['organizationid_default'] = 'Numatytasis organizacijos ID';
$string['organizationid_default_help'] = 'Numatytoji reikšmė, naudojama organizacijos ID. Svetainės ID identifikuoja šį „Moodle“ diegimą.';
$string['organizationidguid'] = 'Organizacijos ID';
$string['organizationidguid_help'] = 'Unikalus šio Moodle egzemplioriaus identifikatorius buvo perduotas įrankiui kaip platformos egzemplioriaus GUID.

Jei šis laukas paliekamas tuščias, bus naudojama numatytoji reikšmė.';
$string['organizationurl'] = 'Organizacijos url';
$string['organizationurl_help'] = 'Bazinis šios Moodle kopijos URL. Jei šis laukas paliktas tuščias, numatyta reikšmė bus naudojama, priklausomai nuo svetainės nustatymų.';
$string['pagesize'] = 'Rodomos pateiktys per puslapį.';
$string['parameter'] = 'Įrankio parametrai';
$string['parameter_help'] = 'Įrankio parametrai yra nustatymai, kuriuos įrankio teikėjas turi perduoti priimtame įrankio tarpiniame serveryje.';
$string['password'] = 'Bendra paslaptis';
$string['password_admin'] = 'Bendra paslaptis';
$string['password_admin_help'] = 'Bendra paslaptis gali būti laikoma kaip slaptažodis naudojamas patvirtinti priėjimą prie įrankio. Jis turėtų būti pateiktas kartu su naudotojo raktu iš įrankio tiekėjo. Įrankiai kurie nereikalauja saugios komunikacijos iš Moodle ir nepateikia papildomų paslaugų (tokių kaip vertinimų ataskaitos) gali nereikalauti bendros paslapties.';
$string['password_help'] = 'Iš anksto sukonfigūruotiems įrankiams nereikia įvesti bendros paslapties,  nes bendra paslaptis bus pateikta kaip dalis konfigūracijos proceso. Šis laukas turėtų būti įvestas jei kuriate sąsają į įrankio tiekėją kuris dar nėra sukonfigūruotas. Jei įrankio tiekėjas bus naudojamas daugiau nei vieną kartą šiame kurse, pridėti kurso įrankio konfigūraciją yra gera idėja. Bendra paslaptis gali būti laikoma slaptažodžiu patvirtinant priėjimą prie įrankio.  Ji turėtų būti pateikta kartu su naudotojo raktu iš įrankio tiekėjo. Įrankis kuris nereikalauja saugios komunikacijos iš Moodle ir neteikia papildomų paslaugų (tokių kaip vertinimo ataskaitos) gali nereikalauti bendros paslapties.';
$string['pending'] = 'Laukiama';
$string['pluginadministration'] = 'Išorinio įrankio administravimas';
$string['pluginname'] = 'Išorinis įrankis';
$string['preferheight'] = 'Norimas aukštis';
$string['preferwidget'] = 'Norimas įtaiso paleidimas';
$string['preferwidth'] = 'Norimas plotis';
$string['press_to_submit'] = 'Spauskite kad paleisti šią veiklą';
$string['privacy'] = 'Privatumas';
$string['privacy:metadata:coursefullname'] = 'Visas kurso, iš kurio naudotojas pasiekia LTI naudotoją, pavadinimas';
$string['privacy:metadata:courseid'] = 'Kurso, iš kurio naudotojas pasiekia LTI naudotoją, ID';
$string['privacy:metadata:courseidnumber'] = 'Kurso, iš kurio naudotojas pasiekia LTI naudotoją, ID numeris';
$string['privacy:metadata:courseshortname'] = 'Trumpas kurso pavadinimas, iš kurio naudotojas pasiekia LTI naudotoją';
$string['privacy:metadata:createdby'] = 'Naudotojas, sukūręs įrašą';
$string['privacy:metadata:email'] = 'Naudotojo, prisijungusio prie LTI naudotojo, el. pašto adresas';
$string['privacy:metadata:externalpurpose'] = 'LTI vartotojas pateikia naudotojo informaciją ir kontekstą LTI įrankių teikėjui.';
$string['privacy:metadata:firstname'] = 'Naudotojo, prisijungusio prie LTI vartotojo, vardas';
$string['privacy:metadata:fullname'] = 'Visas naudotojo, prisijungusio prie LTI vartotojo, vardas';
$string['privacy:metadata:lastname'] = 'Naudotojo, prisijungusio prie LTI vartotojo, pavardė';
$string['privacy:metadata:lti_submission'] = 'LTI pateikimas';
$string['privacy:metadata:lti_submission:datesubmitted'] = 'Laiko žyma, nurodanti pateikimo laiką';
$string['privacy:metadata:lti_submission:dateupdated'] = 'Laiko žyma, nurodanti, kada pateikimas buvo pakeistas';
$string['privacy:metadata:lti_submission:gradepercent'] = 'Naudotojo įvertinimas procentais';
$string['privacy:metadata:lti_submission:originalgrade'] = 'Originalus įvertinimas naudotojui';
$string['privacy:metadata:lti_submission:userid'] = 'Naudotojo, kuris pateikė LTI veiklą, ID';
$string['privacy:metadata:lti_tool_proxies'] = 'LTI tarpinis serveris';
$string['privacy:metadata:lti_tool_proxies:name'] = 'LTI tarpinio serverio pavadinimas';
$string['privacy:metadata:lti_types'] = 'LTI tipai';
$string['privacy:metadata:lti_types:name'] = 'LTI tipo pavadinimas';
$string['privacy:metadata:role'] = 'Kurso vaidmuo naudotojui, kuris pasiekia LTI vartotoją';
$string['privacy:metadata:timecreated'] = 'Data, kada įrašas sukurtas';
$string['privacy:metadata:timemodified'] = 'Data, kada įrašas keistas';
$string['privacy:metadata:userid'] = 'Naudotojo, pasiekiančio LTI vartotoją, ID';
$string['privacy:metadata:useridnumber'] = 'Naudotojo, prisijungusio prie LTI vartotojo, ID numeris';
$string['privacy:metadata:username'] = 'Naudptojo, prisijungusio prie LTI vartotojo, naudotojo vardas';
$string['publickey'] = 'Viešasis raktas';
$string['publickey_help'] = 'Viešasis raktas (PEM formatu), kurį suteikia įrankis, leidžiantis patikrinti gaunamų pranešimų ir paslaugų užklausų parašus.';
$string['publickeyset'] = 'Viešasis raktų rinkinys';
$string['publickeyset_help'] = 'Viešųjų raktų rinkinys, iš kurio ši svetainė nuskaitys įrankio viešąjį raktą, kad būtų galima patikrinti gaunamų pranešimų ir paslaugų užklausų parašus.';
$string['quickgrade'] = 'Leisti greitąjį vertinimą';
$string['quickgrade_help'] = 'Jei įjungtas, keletas įrankių gali būti įvertinti per vieną puslapį. Pridėti įvertinimus ir komentarus tada spauskite „Išsaugoti visus mano atsiliepimus“ mygtuką kad išsaugotumėte šio puslapio pakeitimus.';
$string['redirect'] = 'Tuoj būsite peradresuoti, jei ne, spauskite mygtuką.';
$string['redirectionuris'] = 'Peradresavimo URI';
$string['redirectionuris_help'] = 'Sąrašas URI (po vieną eilutėje), kuris įrankis naudojamas teikiant prieigos užklausas. Kad pranešimas būtų sėkmingai išsiųstas įrankiui, turi būti užregistruotas bent vienas.';
$string['register'] = 'Registruoti';
$string['register_warning'] = 'Panašu, kad registracijos puslapis bus atidarytas šiek tiek laiko. Jei jis nerodomas, patikrinkite, ar konfigūracijos nustatymuose įvedėte teisingą URL. Jei Moodle naudoja https, įsitikinkite, kad jūsų konfigūruojamas įrankis palaiko https ir URL naudojate https.';
$string['registertype'] = 'Sukonfigūruoti naujo išorinio įrankio registraciją';
$string['registration_options'] = 'Registracijos parinktys';
$string['registrationname'] = 'Įrankio teikėjo pavadinimas';
$string['registrationname_help'] = 'Įveskite įrankio teikėjo pavadinimą registracijai pradėti.';
$string['registrationurl'] = 'Registracijos URL';
$string['registrationurl_help'] = 'Registracijos URL turi būti prieinamas įrankių teikėjui kaip vieta, į kurią turėtų būti siunčiami registracijos prašymai.';
$string['reject'] = 'Atmesti';
$string['rejected'] = 'Atmestas';
$string['resource'] = 'Išteklius';
$string['resourcekey'] = 'Naudotojo raktas';
$string['resourcekey_admin'] = 'Naudotojo raktas';
$string['resourcekey_admin_help'] = 'Naudotojo raktas gali būti laikomas naudotojo vardu kad patvirtinti priėjimą prie įrankio. Jis gali būti naudojamas įrankio tiekėjo kad unikaliai atpažinti  Moodle svetainę iš kurios naudotojai paleidžia įrankį. Naudotojo raktas privalo būti pateiktas įrankio tiekėjo. Kaip yra gaunamas naudotojo raktas skiriasi nuo įrankio tiekėjo. Tai gali būti automatinis procesas, arba gali būti reikalaujamas dialogas su įrankio tiekėju. Įrankiai kurie nereikalauja saugios komunikacijos iš Moodle ir nepateikia papildomų paslaugų (tokių kaip vertinimo ataskaitos) gali nereikalauti išteklių rakto.';
$string['resourcekey_help'] = 'Iš anksto sukonfigūruotiems įrankiams nėra būtina įvesti išteklių rakto, nes naudotojo raktas bus pateiktas kaip dalis konfigūracijos proceso. Šis laukas turėtų būti įvestas jei kuriate sąsają į įrankio tiekėją kuris dar nėra sukonfigūruotas. Jei įrankio tiekėjas bus naudojamas daugiau nei kartą šiame kurse, pridėti kurso įrankio konfigūraciją yra gera idėja. Naudotojo raktas gali būti laikomas kaip naudotojo vardas patvirtinti priėjimą prie įrankio. Jis gali būti naudojamas įrankio tiekėjo kad unikaliai atpažinti Moodle svetainę iš kurios naudotojas paleido įrankį. Naudotojo raktas privalo būti pateiktas įrankio tiekėjo. Naudotojo rakto gavimas skiriasi tarp įrankio tiekėjų. Tai gali būti automatinis procesas, arba tai gali reikalauti dialogo su įrankio tiekėju. Įrankiai kurie nereikalauja saugios komunikacijos iš Moodle ir neteikia papildomų paslaugų (tokių kaip įvertinimų ataskaitos) gali nereikalauti išteklių rakto.';
$string['resourceurl'] = 'Ištekliaus URL';
$string['restricttocategory'] = 'Apriboti kategorijai';
$string['restricttocategory_help'] = 'Norėdami apriboti šio įrankio naudojimą tik tam tikros kategorijos kursams, sąraše pasirinkite kategoriją arba kategorijas.';
$string['return_to_course'] = 'Spauskite <a href="{$a->link}" target="_top">here</a>  kad sugrįžtumėte į kursą.';
$string['saveallfeedback'] = 'Išsaugoti visus mano atsiliepimus';
$string['search:activity'] = 'Išorinis įrankis - veiklos informacija';
$string['secure_icon_url'] = 'Saugios piktogramos URL';
$string['secure_icon_url_help'] = 'Panašus į piktogramos URL, bet naudojamas, kai svetainė saugiai pasiekiama per SSL. Šis laukas skirtas neleisti naršyklei rodyti įspėjimo apie nesaugų vaizdą.';
$string['secure_launch_url'] = 'Saugaus įrankio URL';
$string['secure_launch_url_help'] = 'Panašus į įrankio URL, bet naudojamas vietoj įrankio URL, jei reikalingas didelis saugumas. Moodle naudos saugaus įrankio URL, o ne įrankio URL, jei Moodle svetainė pasiekiama per SSL arba jei įrankio konfigūracija nustatyta taip, kad visada būtų paleista per SSL.

Įrankio URL taip pat gali būti nustatytas kaip https adresas, kad būtų galima priverstinai paleisti per SSL, ir šis laukas gali būti paliktas tuščias.';
$string['selectcontent'] = 'Pasirinkti turinį';
$string['selectcontentvalidationerror'] = 'Šiai veiklai reikia pasirinkti turinį.';
$string['send'] = 'Siųsti';
$string['services'] = 'Paslaugos';
$string['services_help'] = 'Pasirinkite paslaugas, kurias norite pasiūlyti įrankių teikėjui. Galima pasirinkti daugiau nei vieną paslaugą.';
$string['setupoptions'] = 'Sąrankos nustatymai';
$string['share_email'] = 'Dalintis paleidėjo el.paštu su įrankiu';
$string['share_email_admin'] = 'Dalintis paleidėjo el.paštu su įrankiu';
$string['share_email_admin_help'] = 'Nurodykite, ar įrankį paleidusio naudotojo el. pašto adresas bus bendrinamas su įrankio teikėju.
Įrankio tiekėjui gali prireikti paleidimo priemonės el. pašto adresų, kad būtų galima atskirti naudotojus, turinčius tą patį vardą naudotojo sąsajoje, arba siųsti el. laiškus naudotojams pagal įrankio veiksmus.';
$string['share_email_help'] = 'Nurodykite, ar įrankį paleidusio naudotojo el. pašto adresas bus bendrinamas su įrankio teikėju.

Įrankio teikėjui gali prireikti paleidimo priemonės el. pašto adresų, kad atskirtų naudotojus su tuo pačiu vardu, arba siųsti el. laiškus naudotojams pagal įrankio veiksmus.

Atminkite, kad šis nustatymas gali būti pakeistas įrankio konfigūracijoje.';
$string['share_name'] = 'Dalintis paleidėjo vardu su įrankiu.';
$string['share_name_admin'] = 'Dalintis paleidėjo vardu su įrankiu.';
$string['share_name_admin_help'] = 'Nurodykite, ar visas įrankį paleidžiančio naudotojo vardas ir pavardė turi būti bendrinami su įrankio teikėju.
Įrankio teikėjui gali prireikti paleidimo priemonių pavadinimų, kad įrankyje būtų rodoma reikšminga informacija.';
$string['share_name_help'] = 'Nurodykite, ar visas įrankį paleidžiančio naudotojo vardas ir pavardė turi būti bendrinami su įrankio teikėju.

Įrankio teikėjui gali prireikti paleidimo priemonių pavadinimų, kad įrankyje būtų rodoma prasminga informacija.

Atminkite, kad šis nustatymas gali būti pakeistas įrankio konfigūracijoje.';
$string['share_roster'] = 'Leisti įrankiui pasiekti šio kurso sąrašą.';
$string['share_roster_admin'] = 'Įrankis gali prieiti prie kurso sąrašo';
$string['share_roster_admin_help'] = 'Nurodykite, ar įrankis gali pasiekti naudotojų, užsiregistravusių į kursus, iš kurių paleidžiamas šis įrankis, sąrašą.';
$string['share_roster_help'] = 'Nurodykite, ar įrankis gali pasiekti šiame kurse užsiregistravusių naudotojų sąrašą.

Atminkite, kad šis nustatymas gali būti nepaisomas įrankio konfigūracijoje.';
$string['show_in_course_activity_chooser'] = 'Rodyti veiklos parinkiklyje ir kaip sukonfigūruotą įrankį';
$string['show_in_course_lti1'] = 'Įrankio konfigūracijos naudojimas';
$string['show_in_course_lti1_help'] = 'Šis įrankis gali būti rodomas veiklos parinkiklyje, kad mokytojas galėtų pasirinkti, kad pridėtų prie kurso. Arba jis gali būti rodomas iš anksto sukonfigūruotame įrankių išskleidžiamajame meniu, kai prie kurso pridedamas išorinis įrankis. Kita parinktis – įrankio konfigūracija bus naudojama tik tuo atveju, jei į kursą įtraukiamas tikslus įrankio URL.';
$string['show_in_course_lti2'] = 'Įrankio konfigūracijos naudojimas';
$string['show_in_course_lti2_help'] = 'Šis įrankis gali būti rodomas veiklos parinkiklyje, kurį dėstytojas gali pasirinkti pridėti prie kurso, arba iš anksto sukonfigūruotame įrankio išskleidžiamajame meniu, kai prie kurso pridedamas išorinis įrankis.';
$string['show_in_course_no'] = 'Nerodyti; naudoti tik tada, kai įvedamas atitinkantis įrankio URL';
$string['show_in_course_preconfigured'] = 'Pridedant išorinį įrankį rodyti kaip iš anksto sukonfigūruotą įrankį';
$string['showinactivitychooser'] = 'Rodyti veiklos parinkiklį';
$string['sitehost'] = 'Svetainės prieglobos pavadinimas';
$string['siteid'] = 'Svetainės ID';
$string['size'] = 'Dydžio parametrai';
$string['submission'] = 'Pateikimas';
$string['submissions'] = 'Pateikimai';
$string['submissionsfor'] = 'Pateikimas {$a}';
$string['subplugintype_ltiresource'] = 'LTI paslaugos išteklius';
$string['subplugintype_ltiresource_plural'] = 'LTI paslaugos ištekliai';
$string['subplugintype_ltiservice'] = 'LTI paslauga';
$string['subplugintype_ltiservice_plural'] = 'LTI paslaugos';
$string['subplugintype_ltisource'] = 'LTI šaltinis';
$string['subplugintype_ltisource_plural'] = 'LTI  šaltiniai';
$string['successfullycreatedtooltype'] = 'Sėkmingai sukurtas naujas įrankis!';
$string['successfullyfetchedtoolconfigurationfromcontent'] = 'Įrankio konfigūracija sėkmingai gauta iš pasirinkto turinio.';
$string['toggle_debug_data'] = 'Perjungti derinimo duomenis';
$string['tool_config_not_found'] = 'Įrankio konfigūracija nerasta šiam URL';
$string['tool_settings'] = 'Įrankio nustatymai';
$string['tooldescription'] = 'Įrankio aprašymas';
$string['tooldescription_help'] = 'Įrankio aprašymas, rodomas dėstytojų veiklos sąraše.

Tai turėtų apibūdinti kokia tai priemonė, kam ji skirta ir ką ji daro bei pateikiama kita papildoma informacija, kurią dėstytojai turi žinoti.';
$string['tooldetailsaccesstokenurl'] = 'Prieigos rakto URL';
$string['tooldetailsauthrequesturl'] = 'Autentifikavimo užklausos URL';
$string['tooldetailsclientid'] = 'Kliento ID';
$string['tooldetailsdeploymentid'] = 'Diegimo ID';
$string['tooldetailsmailtosubject'] = 'LTI įrankio konfigūravimas';
$string['tooldetailsmodalemail'] = 'El. paštas';
$string['tooldetailsmodallink'] = 'Peržiūrėti išsamią konfigūracijos informaciją';
$string['tooldetailsmodaltitle'] = 'Išsami įrankio konfigūracijos informacija';
$string['tooldetailsplatformid'] = 'Platformos ID';
$string['tooldetailspublickeyseturl'] = 'Viešojo rakto rinkinio URL';
$string['toolisbeingused'] = 'Įrankis naudojamas {$a} kartus';
$string['toolisnotbeingused'] = 'Šis įrankis dar nebuvo naudojamas';
$string['toolproxy'] = 'Išorinio įrankio registracijos';
$string['toolproxy_help'] = 'Išorinių įrankių registracijos leidžia Moodle svetainės administratoriams konfigūruoti išorinius įrankius iš įrankių tarpinio serverio, gauto iš įrankių tiekėjo, palaikančio LTI 2.0. Įrankio teikėjo pateiktas registracijos URL yra viskas, ko reikia norint pradėti procesą. Įrankio tiekėjo siūlomos galimybės ir paslaugos pasirenkamos konfigūruojant naują registraciją.

Šiame puslapyje išvardytos įrankių registracijos yra suskirstytos į keturias kategorijas:

* **Sukonfigūruota** – šios įrankių registracijos buvo nustatytos, bet registracijos procesas dar nepradėtas.
* **Laukiama** – šių įrankių registravimo procesas buvo pradėtas, bet nebaigtas. Atidarykite ir išsaugokite nustatymus, kad jį perkeltumėte atgal į kategoriją „Sukonfigūruota“.
* **Priimta** – šios įrankių registracijos patvirtintos; įrankių tarpiniame serveryje nurodyti ištekliai bus rodomi iš anksto sukonfigūruotų įrankių puslapyje su pradine būsena „Laukiama“.
* **Atmesta** – šios įrankio registracijos yra tos, kurios buvo atmestos registracijos proceso metu. Atidarykite ir išsaugokite nustatymus, kad perkeltumėte atgal į kategoriją „Sukonfigūruota“, kad būtų galima pradėti registracijos procesą iš naujo.';
$string['toolproxyregistration'] = 'Išorinio įrankio registracija';
$string['toolregistration'] = 'Išorinio įrankio registracija';
$string['toolsetup'] = 'Išorinio įrankio konfigūracija';
$string['tooltypeadded'] = 'Pridėtas iš anksto sukonfigūruotas įrankis';
$string['tooltypedeleted'] = 'Iš anksto sukonfigūruotas įrankis ištrintas';
$string['tooltypenotdeleted'] = 'Nepavyko ištrinti iš anksto sukonfigūruoto įrankio';
$string['tooltypenotfounderror'] = 'Šioje veikloje naudotas LTI įrankis buvo ištrintas. Jei reikia pagalbos, kreipkitės į dėstytoją arba svetainės administratorių.';
$string['tooltypes'] = 'Įrankiai';
$string['tooltypeupdated'] = 'Iš anksto sukonfigūruotas įrankis atnaujintas';
$string['toolurl'] = 'Įrankio URL';
$string['toolurl_contentitemselectionrequest'] = 'Turinio pasirinkimo URL';
$string['toolurl_contentitemselectionrequest_help'] = 'Turinio pasirinkimo URL bus naudojamas paleisti turinio pasirinkimo puslapį iš įrankio teikėjo. Jei jis tuščias, bus naudojamas įrankio URL';
$string['toolurl_help'] = 'Įrankio URL naudojamas siekiant suderinti įrankio URL su teisinga įrankio konfigūracija. URL priešdėlis su http (-ais) yra neprivalomas.

Be to, bazinis URL naudojamas kaip įrankio URL, jei išoriniame įrankio egzemplioriuje nenurodytas įrankio URL.

Pavyzdžiui, bazinis URL *tool.com* atitiktų:

* tool.com
* tool.com/quizzes
* tool.com/quizzes/quiz.php?id=10
* www.tool.com/quizzes

Bazinis *www.tool.com/quizzes* URL atitiktų:

* www.tool.com/quizzes
* tool.com/quizzes
* tool.com/quizzes/take.php?id=10

Bazinis *quiz.tool.com* URL atitiktų:

* quiz.tool.com
* quiz.tool.com/take.php?id=10

Jei tam pačiam domenui skirtos dvi skirtingos įrankių konfigūracijos, bus naudojama  labiausiai sutampanti.

Taip pat galite įterpti kasetės URL, jei tokį turite, ir informacija apie įrankį bus užpildyta automatiškai.';
$string['toolurlplaceholder'] = 'Įrankio URL...';
$string['typename'] = 'Įrankio pavadinimas';
$string['typename_help'] = 'Įrankio pavadinimas naudojamas Moodle įrankio teikėjui identifikuoti. Įvestas pavadinimas bus matomas dėstytojams, kai kursuose prideda išorinių įrankių.';
$string['types'] = 'Tipas';
$string['unabletocreatetooltype'] = 'Nepavyko sukurti įrankio';
$string['unabletofindtooltype'] = 'Negalima rasti įrankio {$a->id}';
$string['unknownstate'] = 'Nežinoma būsena';
$string['update'] = 'Atnaujinti';
$string['usage'] = 'Naudojimo atvejų kiekis';
$string['useraccountinformation'] = 'Naudotojo paskyros informacija';
$string['userpersonalinformation'] = 'Naudotojo asmeninė informacija';
$string['using_tool_cartridge'] = 'Įrankių kasetės naudojimas';
$string['using_tool_configuration'] = 'Naudojamos įrankio konfigūracijos:';
$string['validurl'] = 'Tinkamas URL turi prasidėti su http(s)://';
$string['viewsubmissions'] = 'Peržiūrėti pateiktis ir vertinimo langą';
