<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'assign', language 'uk', version '4.4'.
 *
 * @package     assign
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityattachments'] = 'Додатки до виконання завдань';
$string['activitydate:submissionsdue'] = 'Термін спливає:';
$string['activitydate:submissionsopen'] = 'Доступно з:';
$string['activitydate:submissionsopened'] = 'Початок приймання:';
$string['activityeditor'] = 'Інструкції щодо діяльності';
$string['activityeditor_help'] = 'Дії, які ви хочете, щоб студент виконав для цього завдання. Це відображається лише на сторінці подання, де студент редагує та подає своє завдання.';
$string['activityoverview'] = 'Ви маєте завдання, які потребують вашої уваги';
$string['addattempt'] = 'Дозволити іншу спробу';
$string['addnewattempt'] = 'Додати нову спробу';
$string['addnewattempt_help'] = 'Це створить новий бланк для можливості повторної здачі роботи.';
$string['addnewattemptfromprevious'] = 'Додати нову спробу на основі попередньої';
$string['addnewattemptfromprevious_help'] = 'Це скопіює відповідь з вашої попередньої спроби, щоб ви змогли з нею працювати в наступній.';
$string['addnewgroupoverride'] = 'Додати заміну групи';
$string['addnewuseroverride'] = 'Додати заміну користувача';
$string['addsubmission'] = 'Здати роботу';
$string['addsubmission_help'] = 'Ви ще не подали заявку.';
$string['allocatedmarker'] = 'Виділені маркер';
$string['allocatedmarker_help'] = 'Маркер, призначений для цього подання.';
$string['allowsubmissions'] = 'Дозволяє користувачам продовжувати здачу робіт для цього завдання.';
$string['allowsubmissionsfromdate'] = 'Відповіді приймаються з';
$string['allowsubmissionsfromdate_help'] = 'Якщо включено, то студенти не матимуть можливості здати роботу до вказаної дати. Якщо відключено, то студенти зможуть задавати роботи у будь-який час.';
$string['allowsubmissionsshort'] = 'Дозволити змінювати роботу';
$string['alwaysshowdescription'] = 'Завжди показувати завдання';
$string['alwaysshowdescription_help'] = 'Якщо вимкнено, наведений вище опис завдання стане видимим для студентів лише на дату «Дозволити подання з».';
$string['applytoteam'] = 'Застосувати оцінки та відгуки для всієї групи';
$string['assign:addinstance'] = 'Додавати нові завдання';
$string['assign:editothersubmission'] = 'Редагувати роботи інших студентів';
$string['assign:exportownsubmission'] = 'Експортувати власні роботи';
$string['assign:grade'] = 'Оцінювати відповідь завдання';
$string['assign:grantextension'] = 'Надавати відстрочку терміну';
$string['assign:manageallocations'] = 'Управляти призначенням оцінювачів для робіт';
$string['assign:managegrades'] = 'Переглядати оцінки та оцінювати';
$string['assign:manageoverrides'] = 'Керувати замінами призначення';
$string['assign:receivegradernotifications'] = 'Отримувати повідомлення про роботу оцінювача';
$string['assign:releasegrades'] = 'Оцінювати';
$string['assign:revealidentities'] = 'Виявляти ідентифікацію студентів';
$string['assign:reviewgrades'] = 'Переглядати оцінки';
$string['assign:showhiddengrader'] = 'Перегляньте особу прихованого грейдера';
$string['assign:submit'] = 'Відсилати відповідь на завдання';
$string['assign:view'] = 'Переглядати завдання';
$string['assign:viewblinddetails'] = 'Переглядайте ідентифікатори студентів, коли ввімкнено анонімні подання';
$string['assign:viewgrades'] = 'Переглядати оцінки';
$string['assign:viewownsubmissionsummary'] = 'Переглянути власний підсумок подання';
$string['assignfeedback'] = 'Модуль відгуку';
$string['assignfeedbackpluginname'] = 'Модуль відгуку';
$string['assignmentisdue'] = 'Прийом робіт закінчено';
$string['assignmentmail'] = '{$a->grader} опублікував свій відгук на результати вашої роботи із завдання \'{$a->assignment}\' .
Ви можете переглянути його на сторінці оцінення завдання:  {$a->url}';
$string['assignmentmailhtml'] = '{$a->grader} опублікував свій відгук на результати вашої роботи із завдання \'<i>{$a->assignment}</i>\' .<br /><br />
Ви можете переглянути його на <a href="{$a->url}">сторінці оцінення завдання</a>.';
$string['assignmentmailsmall'] = '{$a->grader} опублікував свій відгук на результати вашої роботи із завдання \'{$a->assignment}\' .
Ви можете переглянути його на сторінці завдання';
$string['assignmentname'] = 'Назва завдання';
$string['assignmentplugins'] = 'Модулі завдань';
$string['assignmentsperpage'] = 'Завдань на сторінку';
$string['assignsubmission'] = 'Модуль подачі робіт';
$string['assignsubmissionpluginname'] = 'Модуль подачі робіт';
$string['assigntimeleft'] = 'Залишився час';
$string['attemptheading'] = 'Спроба {$a->attemptnumber}: {$a->submissionsummary}';
$string['attempthistory'] = 'Попередні спроби';
$string['attemptnumber'] = 'Спроба номер';
$string['attemptreopenmethod'] = 'Додаткові спроби';
$string['attemptreopenmethod_help'] = 'Цей параметр визначає, чи може учень робити додаткові спроби виконати завдання. За кожну спробу оцінка та відгуки зберігаються, і їх можуть переглядати вчитель та учень. Доступні варіанти:

* Ніколи - можлива лише одна спроба.
* Вручну – додаткові спроби можуть бути дозволені викладачем.
* Автоматично до здачі – додаткові спроби дозволені автоматично, доки учень не досягне оцінки, встановленої в журналі оцінок для цього завдання.';
$string['attemptreopenmethod_manual'] = 'Вручну';
$string['attemptreopenmethod_none'] = 'Ніколи';
$string['attemptreopenmethod_untilpass'] = 'Автоматично до виконання';
$string['attemptsettings'] = 'Налаштування спроби';
$string['availability'] = 'Доступність';
$string['back'] = 'Назад';
$string['backtoassignment'] = 'Повернутися до завдання';
$string['batchoperationconfirmaddattempt'] = 'Дозволити іншу спробу для вибраних?';
$string['batchoperationconfirmdownloadselected'] = 'Завантажити вибрані роботи?';
$string['batchoperationconfirmgrantextension'] = 'Надати відстрочку для всіх вибраних завдань?';
$string['batchoperationconfirmlock'] = 'Заблокувати всі вибрані роботи?';
$string['batchoperationconfirmremovesubmission'] = 'Вилучити вибрані матеріали?';
$string['batchoperationconfirmreverttodraft'] = 'Повернути вибрані роботи до чернетки?';
$string['batchoperationconfirmsetmarkingallocation'] = 'Встановити призначення оцінювачів для всіх вибраних робіт?';
$string['batchoperationconfirmsetmarkingworkflowstate'] = 'Встановити стан оцінювання для всіх вибраних робіт?';
$string['batchoperationconfirmunlock'] = 'Розблокувати всі вибрані роботи?';
$string['batchoperationlock'] = 'заблокувати роботи';
$string['batchoperationreverttodraft'] = 'повернути роботи до чернетки';
$string['batchoperationsdescription'] = 'З вибраними...';
$string['batchoperationunlock'] = 'розблокувати роботи';
$string['batchsetallocatedmarker'] = 'Встановити призначеного оцінювача для {$a} вибраних студентів';
$string['batchsetmarkingworkflowstateforusers'] = 'Встановити стан оцінювання для {$a} вибраних студентів';
$string['beginassignment'] = 'Почати завдання';
$string['blindmarking'] = 'Анонімні подання';
$string['blindmarking_help'] = 'Анонімні подання приховують особистості студентів від маркерів. Налаштування анонімної подачі буде заблоковано після того, як подання або оцінка буде виставлена стосовно цього завдання.';
$string['blindmarkingenabledwarning'] = 'Для цієї дії ввімкнено анонімні подання. Оцінки не будуть додані до журналу оцінок, доки особистості студентів не будуть виявлені в меню дій щодо оцінювання.';
$string['cachedef_overrides'] = 'Інформація про заміну користувача та групи';
$string['calendardue'] = 'Строк {$a} спливає';
$string['calendargradingdue'] = 'Час оцінення {$a} спливає';
$string['caneditsubmission'] = 'Ви можете редагувати свою заявку та надіслати її після закінчення терміну, але вона буде позначена як пізня.';
$string['changefilters'] = 'Змінити фільтри';
$string['changeuser'] = 'Змінити студента';
$string['choosegradingaction'] = 'Тип оцінювання';
$string['choosemarker'] = 'Виберіть...';
$string['chooseoperation'] = 'Виберіть дію';
$string['clickexpandreviewpanel'] = 'Натисніть, щоб розгорнути панель огляду';
$string['collapsegradepanel'] = 'Згорнути панель оцінювання';
$string['collapsereviewpanel'] = 'Згорнути панель огляду';
$string['comment'] = 'Коментар';
$string['completiondetail:submit'] = 'Здайте роботу';
$string['completionsubmit'] = 'Зробіть подання';
$string['configshowrecentsubmissions'] = 'Кожен може бачити інформацію про здачі завдань в блоці останніх подій.';
$string['confirmbatchgradingoperation'] = 'Ви впевнені, що хочете {$a->operation} для {$a->count} студента(ів)?';
$string['confirmstart'] = 'У вас є {$a}, щоб виконати це завдання. Коли ви починаєте, таймер почне відлік, і його не можна призупинити.';
$string['confirmsubmission'] = 'Відправити вашу роботу на перевірку? Після цього ви не зможете робити в ній ніяких змін.';
$string['confirmsubmissionheading'] = 'Підтвердити подання';
$string['conversionexception'] = 'Не вдалося конвертувати завдання. Зауваження до: {$a}.';
$string['couldnotconvertgrade'] = 'Не вдалося конвертувати оцінку завдання для користувача {$a}.';
$string['couldnotconvertsubmission'] = 'Не вдалося конвертувати роботу із завдання для користувача {$a}.';
$string['couldnotcreatecoursemodule'] = 'Не вдалося створити модуль курсу.';
$string['couldnotcreatenewassignmentinstance'] = 'Не вдалося створити нове завдання.';
$string['couldnotfindassignmenttoupgrade'] = 'Не вдалося знайти старе завдання для його оновлення.';
$string['crontask'] = 'Фонова обробка для модуля призначення';
$string['currentassigngrade'] = 'Поточна оцінка за завдання';
$string['currentattempt'] = 'Це спроба {$a}.';
$string['currentattemptof'] = 'Це спроба {$a->attemptnumber} (дозволено спроб - {$a->maxattempts}).';
$string['currentgrade'] = 'Поточна оцінка в журналі';
$string['cutoffdate'] = 'Термін неприйняття здачі';
$string['cutoffdate_help'] = 'Якщо встановлено, подання не прийматимуться після цієї дати без продовження. Якщо не встановлено, подання завжди прийматимуться.';
$string['cutoffdatecolon'] = 'Термін неприйняття:: {$a}';
$string['cutoffdatefromdatevalidation'] = 'Кінцева дата не може бути раніше дати дозволу на подання.';
$string['cutoffdatevalidation'] = 'Граничний термін не може бути раніше встановленого терміну.';
$string['defaultlayout'] = 'Відновити типове';
$string['defaultsettings'] = 'Типові налаштування завдань';
$string['defaultsettings_help'] = 'Ці налаштування будуть відразу підставлятися до всіх нових завдань.';
$string['defaultteam'] = 'Типова група';
$string['deleteallsubmissions'] = 'Видалити всі відповіді';
$string['description'] = 'Зміст завдання';
$string['disabled'] = 'Вимкнено';
$string['downloadall'] = 'Завантажити всі роботи';
$string['downloadasfolders'] = 'Завантажуйте матеріали в папках';
$string['downloadasfolders_help'] = 'Завдання можна завантажувати в папках. Кожне подання потім поміщається в окрему папку, при цьому структура папок зберігається для будь-яких підпапок, а файли не перейменовуються.';
$string['downloadselectedsubmissions'] = 'Завантажити вибрані роботи';
$string['duedate'] = 'Кінцевий термін здачі';
$string['duedate_help'] = 'Це той момент, коли призначено завдання. Після цієї дати все ще буде дозволено подання, але всі завдання, надіслані після цієї дати, будуть позначені як пізні. Встановіть кінцеву дату призначення, щоб запобігти подачі після певної дати.';
$string['duedateaftersubmissionvalidation'] = 'Термін виконання має бути після дозволеної дати подання.';
$string['duedatecolon'] = 'Кінцевий термін здачі: {$a}';
$string['duedatereached'] = 'Термін для здачі робіт цього завдання вже минув';
$string['duedatevalidation'] = 'Термін виконання не може бути раніше, ніж дозволено подання з дати.';
$string['duplicateoverride'] = 'Повторне перевизначення';
$string['editaction'] = 'Дії...';
$string['editattemptfeedback'] = 'Редагувати оцінку та відгук для спроби {$a}.';
$string['editingpreviousfeedbackwarning'] = 'Ви редагуєте відгук до попередньої спроби. Це спроба {$a->attemptnumber} з {$a->totalattempts}.';
$string['editingstatus'] = 'Зміна статусу';
$string['editonline'] = 'Редагувати онлайн';
$string['editoverride'] = 'Заміна редагування';
$string['editsubmission'] = 'Редагувати відповідь';
$string['editsubmission_help'] = 'Ви все ще можете вносити зміни до свого подання.';
$string['editsubmissionother'] = 'Редагувати роботу {$a}';
$string['enabled'] = 'Дозволено';
$string['enabletimelimit'] = 'Увімкнути відкладені завдання';
$string['enabletimelimit_help'] = 'Якщо ввімкнено, ви можете встановити обмеження часу на сторінці налаштувань призначення.';
$string['errornosubmissions'] = 'Немає робіт для завантаження';
$string['errorquickgradingvsadvancedgrading'] = 'Оцінки не збережено, оскільки це завдання зараз використовує розширене оцінювання';
$string['errorrecordmodified'] = 'Оцінки не збережено, оскільки хтось змінив один або кілька записів з того часу як ви завантажили сторінку.';
$string['eventallsubmissionsdownloaded'] = 'Завантажено всі здані роботи.';
$string['eventassessablesubmitted'] = 'Здано роботу.';
$string['eventbatchsetmarkerallocationviewed'] = 'Переглянуто встановлених оцінювачів';
$string['eventbatchsetworkflowstateviewed'] = 'Переглянуто стан оцінювання';
$string['eventextensiongranted'] = 'Надано відстрочку';
$string['eventfeedbackupdated'] = 'Оновлено відгук';
$string['eventfeedbackviewed'] = 'Переглянуто відгук';
$string['eventgradingformviewed'] = 'Переглянуто форму оцінювання';
$string['eventgradingtableviewed'] = 'Переглянуто таблицю оцінювання';
$string['eventidentitiesrevealed'] = 'Виявлено ідентичність';
$string['eventmarkerupdated'] = 'Оновлено встановлення оцінювачів';
$string['eventoverridecreated'] = 'Створено заміну призначення';
$string['eventoverridedeleted'] = 'Заміну призначення видалено';
$string['eventoverrideupdated'] = 'Заміна призначення оновлено';
$string['eventremovesubmissionformviewed'] = 'Переглянуто підтвердження видалення.';
$string['eventrevealidentitiesconfirmationpageviewed'] = 'Переглянуто сторінку підтвердження виявлених ідентичностей';
$string['eventstatementaccepted'] = 'Користувач прийняв заяву виконавця';
$string['eventsubmissionconfirmationformviewed'] = 'Переглянуто форму підтвердження подання роботи';
$string['eventsubmissioncreated'] = 'Створено подання';
$string['eventsubmissionduplicated'] = 'Користувач продублював їх подання.';
$string['eventsubmissionformviewed'] = 'Переглянуто форму подання роботи';
$string['eventsubmissiongraded'] = 'Оцінено подання роботи';
$string['eventsubmissionlocked'] = 'Подані роботи заблоковано для користувача';
$string['eventsubmissionremoved'] = 'Подання видалено.';
$string['eventsubmissionstatusupdated'] = 'Оновлено статус подання роботи';
$string['eventsubmissionstatusviewed'] = 'Переглянуто статус подання роботи';
$string['eventsubmissionunlocked'] = 'Подані роботи розблоковано для користувача';
$string['eventsubmissionupdated'] = 'Оновлено подання';
$string['eventsubmissionviewed'] = 'Переглянуто подання';
$string['eventworkflowstateupdated'] = 'Оновлено стан оцінювання';
$string['expandreviewpanel'] = 'Розгорнути панель огляду';
$string['extensionduedate'] = 'Відстрочений кінцевий термін';
$string['extensionduedatecurrent'] = 'Поточний термін продовження';
$string['extensionduedatenone'] = 'Жодного';
$string['extensionnotafterduedate'] = 'Відстрочений кінцевий термін повинен бути після дати першого кінцевого терміну';
$string['extensionnotafterfromdate'] = 'Відстрочений кінцевий термін повинен бути після дати початку здачі завдання';
$string['feedback'] = 'Відгук';
$string['feedbackavailableanonhtml'] = 'У вас є новий відгук про ваш подання завдання для \'<i>{$a->assignment}</i>\'<br /><br /> Ви можете побачити це a href="{$a->url}">додане до вашого завдання</a>.';
$string['feedbackavailableanonsmall'] = 'Новий відгук щодо завдання {$a->assignment}';
$string['feedbackavailableanontext'] = 'У вас є новий відгук про ваш подання завдання для \'{$a->assignment}\'

Ви можете побачити його додане до вашого завдання:

{$a->url}';
$string['feedbackavailablehtml'] = '{$a->username} опублікував свій відгук на результати вашої роботи із завдання \'<i>{$a->assignment}</i>\' .<br /><br />
Ви можете переглянути його на <a href="{$a->url}">сторінці завдання</a>.';
$string['feedbackavailablesmall'] = '{$a->username} дав відгук на результати вашої роботи із завдання {$a->assignment}';
$string['feedbackavailabletext'] = '{$a->username} опублікував свій відгук на результати вашої роботи із завдання \'{$a->assignment}\'.
Ви можете переглянути його на сторінці завдання:  {$a->url}';
$string['feedbackplugin'] = 'Модуль відгуків';
$string['feedbackpluginforgradebook'] = 'Модуль відгуків дозволяє залишати коментарі в журналі оцінок.';
$string['feedbackpluginforgradebook_help'] = 'Тільки один модуль відгуків може залишати відгук в журналі оцінок.';
$string['feedbackplugins'] = 'Модулі відгуків';
$string['feedbacksettings'] = 'Налаштування відгуків';
$string['feedbacktypes'] = 'Типи відгуків';
$string['filesubmissions'] = 'Файл роботи';
$string['filter'] = 'Фільтр';
$string['filterdraft'] = 'Чернетка';
$string['filtergrantedextension'] = 'Надано продовження';
$string['filternone'] = 'Без фільтрації';
$string['filternotsubmitted'] = 'Без зданих робіт';
$string['filterrequiregrading'] = 'Потрібно оцінити';
$string['filtersubmitted'] = 'Здано';
$string['fixrescalednullgrades'] = 'Це завдання містить деякі помилкові оцінки. Ви можете <a href="{$a->link}">автоматично виправити ці оцінки</a>. Це може вплинути на підсумок курсу.';
$string['fixrescalednullgradesconfirm'] = 'Ви впевнені, що хочете виправити помилкові оцінки? Усі позначені оцінки будуть видалені. Це може вплинути на підсумок курсу.';
$string['fixrescalednullgradesdone'] = 'Оцінки виправлені.';
$string['gradeabovemaximum'] = 'Оцінка повинна бути менше або дорівнювати {$a}.';
$string['gradebelowzero'] = 'Оцінка повинна бути більше або дорівнювати нулю.';
$string['gradebreakdown'] = 'Розбивка оцінок';
$string['gradecanbechanged'] = 'Оцінка може бути змінена';
$string['gradechangessaveddetail'] = 'Зміни оцінки та відгуку збережено';
$string['graded'] = 'Оцінено';
$string['gradedby'] = 'Оцінив';
$string['gradedfollowupsubmit'] = 'Оцінено – подано повторно';
$string['gradedon'] = 'Оцінено на';
$string['gradeitem:submissions'] = 'Подання';
$string['gradelocked'] = 'Ця оцінка заблокована або змінена вручну в Журналі оцінок';
$string['gradeoutof'] = 'Оцінка (макс. {$a})';
$string['gradeoutofhelp'] = 'Оцінка';
$string['gradeoutofhelp_help'] = 'Вкажіть оцінку за студентську роботу тут. Можна використовувати дробові значення.';
$string['gradersubmissionupdatedhtml'] = '{$a->username} відправив(ла) нову відповідь на завдання <i>\'{$a->assignment}\'</i><br /><br /> Відповіді на це завдання <a href="{$a->url}">розміщені на сайті</a>.';
$string['gradersubmissionupdatedsmall'] = '{$a->username} оновив(ла) свою відповідь на завдання {$a->assignment}.';
$string['gradersubmissionupdatedtext'] = '{$a->username} оновив(ла) свою відповідь на завдання \'{$a->assignment}\'. Відповіді на завдання доступні за адресою: {$a->url}';
$string['gradestudent'] = 'Оцінка студента: (код={$a->id}, повне ім’я={$a->fullname}).';
$string['gradeuser'] = 'Оцінити {$a}';
$string['grading'] = 'Оцінення';
$string['gradingchangessaved'] = 'Зміни збережено';
$string['gradingduedate'] = 'Нагадати мені поставити оцінку';
$string['gradingduedate_help'] = 'Очікувана дата, до якої має бути завершено позначення подання. Ця дата використовується для визначення пріоритетності сповіщень на інформаційній панелі для вчителів.';
$string['gradingdueduedatevalidation'] = 'Дата \'Нагадати мені поставити оцінку\' не може бути раніше дати завершення.';
$string['gradingduefromdatevalidation'] = 'Дата \'Нагадати мені поставити оцінку\' не може бути раніше ніж дата дозволенного відправлення матеріалів.';
$string['gradingmethodpreview'] = 'Критерій оцінювання';
$string['gradingoptions'] = 'Параметри';
$string['gradingstatus'] = 'Статус оцінення';
$string['gradingstudent'] = 'Оцінюється студент';
$string['gradingsummary'] = 'Результат оцінювання';
$string['grantextension'] = 'Надати відстрочку';
$string['grantextensionforusers'] = 'Надати відстрочку для {$a} студента(ів)';
$string['groupoverrides'] = 'Групові заміни';
$string['groupoverridesdeleted'] = 'Групові заміни видалено';
$string['groupsnone'] = 'Немає груп, до яких ви можете отримати доступ.';
$string['groupsubmissionsettings'] = 'Налаштування групової здачі';
$string['hiddenuser'] = 'Учасник';
$string['hidegrader'] = 'Не показувати студентам викладача, який виконав оцінювання';
$string['hidegrader_help'] = 'Якщо ввімкнено, особистість будь-якого користувача, який оцінює завдання, не відображатиметься, тому студенти не можуть бачити, хто відзначив їх роботу.

Зауважте, що це налаштування не впливає на поле коментарів на сторінці оцінювання.';
$string['hideshow'] = 'Показати/Приховати';
$string['inactiveoverridehelp'] = '* Це перевизначення неактивне, оскільки доступ користувача до активності обмежено. Це може бути пов’язано з призначенням груп або ролей, іншими обмеженнями доступу або прихованою активністю.';
$string['indicator:cognitivedepth'] = 'Завдання: пізнавальний аспект';
$string['indicator:cognitivedepth_help'] = 'Цей показник базується на глибині пізнання, досягнутої студентом під час виконання завдання.';
$string['indicator:cognitivedepthdef'] = 'Завдання пізнавальне';
$string['indicator:cognitivedepthdef_help'] = 'Учасник досяг цього відсотка когнітивної активності, запропонованої діяльністю Завдання протягом цього інтервалу аналізу (Рівні = Немає перегляду, Перегляд, Надіслати, Переглянути відгук, Коментар до відгуку, Повторно надіслати після перегляду відгуку)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Завдання: соціальний аспект';
$string['indicator:socialbreadth_help'] = 'Цей показник базується на соціальному розширенні, досягнутому студентом у виконанні завдання.';
$string['indicator:socialbreadthdef'] = 'Призначення соціальне';
$string['indicator:socialbreadthdef_help'] = 'Учасник досяг цього відсотка соціальної залученості, запропонованої діяльністю Завдання протягом цього інтервалу аналізу (Рівні = Без участі, Учасник сам, Учасник з іншими)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['instructionfiles'] = 'Файли інструктажу';
$string['introattachments'] = 'Додаткові файли';
$string['introattachments_help'] = 'Можуть бути додані додаткові файли для використання в завданні, наприклад шаблони відповідей.';
$string['invalidfloatforgrade'] = 'Проставлена оцінка не зрозуміла: {$a}';
$string['invalidgradeforscale'] = 'Проставлена оцінка не відповідає поточній шкалі';
$string['invalidoverrideid'] = 'Недійсний ідентифікатор заміни';
$string['lastmodifiedgrade'] = 'Востаннє змінювалося (оцінка)';
$string['lastmodifiedsubmission'] = 'Востаннє змінювалося (здача)';
$string['latesubmissions'] = 'Прострочені завдання';
$string['latesubmissionsaccepted'] = 'Дозволено до {$a}';
$string['loading'] = 'Завантаження...';
$string['locksubmissionforstudent'] = 'Заборонит подальші здачі студенту: (код={$a->id}, повне ім’я={$a->fullname}).';
$string['locksubmissions'] = 'Заблокувати здачу';
$string['manageassignfeedbackplugins'] = 'Керування модулями відгуків завдань';
$string['manageassignsubmissionplugins'] = 'Керування модулями здачі завдань';
$string['marker'] = 'Оцінювач';
$string['markerfilter'] = 'Фільтр оцінювачів';
$string['markerfilternomarker'] = 'Без оцінювачів';
$string['markingallocation'] = 'Використати призначення оцінювачів';
$string['markingallocation_help'] = 'Якщо включено разом з позначенням процесу оцінювання, то для конкретного студента може бути призначений окрема особа оцінювач.';
$string['markinganonymous'] = 'Дозволити часткове оприлюднення оцінок під час анонімного оцінювання';
$string['markinganonymous_help'] = 'Якщо ввімкнено разом із анонімним поданням і робочим процесом виставлення оцінок, це дозволяє частково видавати оцінки під час анонімного оцінювання.';
$string['markingworkflow'] = 'Використати позначення процесу оцінювання';
$string['markingworkflow_help'] = 'Якщо включено, то оцінювання буде проходити через ряд етапів робочого процесу, перш ніж показати студенту. Це дозволяє проводити безліч циклів оцінювання і дозволяє визначити, коли оцінки будуть показані для всіх студентів одночасно.';
$string['markingworkflowstate'] = 'Стан оцінювання';
$string['markingworkflowstate_help'] = 'Можливі стани робочого процесу можуть включати (залежно від ваших дозволів):

* Не позначено - маркер ще не почався
* У розмітці - маркер почався, але ще не закінчився
* Позначення завершено - маркер завершено, але, можливо, доведеться повернутися для перевірки/виправлення
* На огляді - оцінка тепер у викладача, який відповідає за перевірку якості
* Готовий до випуску - відповідальний викладач задоволений оцінкою, але може почекати, перш ніж надати учням доступ до оцінок
* Звільнено – учень може отримати доступ до оцінок/відгуків';
$string['markingworkflowstateinmarking'] = 'В оцінюванні';
$string['markingworkflowstateinreview'] = 'В перегляді';
$string['markingworkflowstatenotmarked'] = 'Не оцінено';
$string['markingworkflowstatereadyforrelease'] = 'Готово до показу';
$string['markingworkflowstatereadyforreview'] = 'Оцінено';
$string['markingworkflowstatereleased'] = 'Показано';
$string['maxattempts'] = 'Максимум спроб';
$string['maxattempts_help'] = 'Максимальна кількість спроб подання, яку може зробити студент. Після того, як цей номер буде досягнутий, подання більше не може бути відкрито повторно.';
$string['maxgrade'] = 'Максимальна оцінка';
$string['maxperpage'] = 'Максимум відповідей на сторінку';
$string['maxperpage_help'] = 'Максимальна кількість завдань, які оцінювач може показати на сторінці оцінювання завдань. Цей параметр корисний для запобігання тайм-аутам для курсів з великою кількістю учасників.';
$string['messageprovider:assign_notification'] = 'Розсилати повідомлення із задань';
$string['modulename'] = 'Завдання';
$string['modulename_help'] = '<p>Модуль діяльності <b>Завдання</b> дозволяє викладачам видавати завдання, збирати роботи, оцінювати їх та залишати відгуки на ці роботи.</p>
<p>Студенти можуть надавати будь-які файли, такі як: текстові документи, електронні таблиці, зображення, аудіо та відео файли; або вводити свою відповідь безпосередньо в текстовому редакторі на сайті.</p>
<p>Крім того <b>Завдання</b> може бути використане в якості нагадування виконати завдання, яке не потребує оформлення в цифровому вигляді, наприклад творча робота.</p>
<p>При оцінюванні завдання викладач може залишати відгуки у вигляді коментарів або завантажити файли з детальним роз’ясненням по роботі студента.</p>
<p>Завдання можуть бути оцінені балами або розширеним методом у вигляді рубрик. Підсумкова оцінка заноситься до журналу оцінок.</p>';
$string['modulename_link'] = 'mod/assignment/view';
$string['modulenameplural'] = 'Завдання';
$string['moreusers'] = 'Ще {$a} ...';
$string['multipleteams'] = 'Учасник кількох груп';
$string['multipleteams_desc'] = 'Завдання потрібно подавати в групах. Ви є членом більш ніж однієї групи. Щоб мати можливість подати заявку, ви повинні бути членом лише однієї групи. Зверніться до свого викладача, щоб змінити членство в групі.';
$string['multipleteamsgrader'] = 'Є учасником більше ніж однієї групи, тому не може відправляти відповіді на завдання.';
$string['newsubmissions'] = 'Завдання здали';
$string['nextuser'] = 'Наступний користувач';
$string['noattempt'] = 'Немає спроб';
$string['noclose'] = 'Немає закритої дати';
$string['nofiles'] = 'Немає файлів.';
$string['nofilters'] = 'Без фільтрації';
$string['nograde'] = 'Немає оцінки.';
$string['nogroupoverrides'] = 'Наразі немає групових замін.';
$string['nomoresubmissionsaccepted'] = 'Дозволено лише для учасників, яким продовжено термін виконання';
$string['none'] = 'Жодного';
$string['noonlinesubmissions'] = 'Завдання не вимагає нічого здавати в онлайні';
$string['noopen'] = 'Немає дати відкриття';
$string['nooverridedata'] = 'Ви повинні замінити принаймні одне з налаштувань призначення.';
$string['nosavebutnext'] = 'Далі';
$string['nosubmission'] = 'Нічого не відправлялося';
$string['nosubmissionyet'] = 'Подання ще не подано';
$string['noteam'] = 'Не є учасником жодної групи';
$string['noteam_desc'] = 'Це завдання вимагає подання в групах. Ви не є членом жодної групи, тому не можете створити подання. Будь ласка, зв’яжіться зі своїм викладачем, щоб додати вас до групи.';
$string['noteamgrader'] = 'Не є учасником жодної групи, тому здати завдання не можна.';
$string['notgraded'] = 'Не оцінено';
$string['notgradedyet'] = 'Ще не оцінено';
$string['notifications'] = 'Повідомлення';
$string['nouseroverrides'] = 'Наразі немає змін користувача.';
$string['nousers'] = 'Немає користувачів';
$string['nousersselected'] = 'Нікого не вибрано';
$string['numberofdraftsubmissions'] = 'Чорновики';
$string['numberofparticipants'] = 'Учасники';
$string['numberofsubmissionsneedgrading'] = 'Потрібно оцінити';
$string['numberofsubmissionsneedgradinglabel'] = 'Потрібна оцінка: {$a}';
$string['numberofsubmittedassignments'] = 'Здано';
$string['numberofteams'] = 'Групи';
$string['offline'] = 'Не потрібно здавати в онлайні';
$string['open'] = 'Відкрити';
$string['opensubmissionexists'] = 'Відкрите подання завдання вже існує.';
$string['outlinegrade'] = 'Оцінка: {$a}';
$string['outof'] = '{$a->current} з {$a->total}';
$string['overdue'] = 'Завдання прострочено на: {$a}';
$string['override'] = 'Перевизначити';
$string['overridedeletegroupsure'] = 'Ви впевнені, що хочете видалити заміну для групи {$a}?';
$string['overridedeleteusersure'] = 'Ви впевнені, що хочете видалити заміну для користувача {$a}?';
$string['overridegroup'] = 'Перевизначити групу';
$string['overridegroupeventname'] = '{$a->assign} - {$a->group}';
$string['overrides'] = 'Перевизначає';
$string['overrideuser'] = 'Перевизначити користувача';
$string['overrideusereventname'] = '{$a->assign} - Замінити';
$string['page-mod-assign-view'] = 'Головна сторінка модуля завдань';
$string['page-mod-assign-x'] = 'Будь-яка сторінка модуля завдань';
$string['paramtimeremaining'] = '{$a} залишилося';
$string['participant'] = 'Учасник';
$string['pluginadministration'] = 'Керування завданням';
$string['pluginname'] = 'Завдання';
$string['preventsubmissionnotingroup'] = 'Необхідна група щоб здати роботу';
$string['preventsubmissionnotingroup_help'] = 'Якщо включено, то студенти, які не належать до визначених груп не зможуть здавати завдання';
$string['preventsubmissions'] = 'Заборонити користувачу більше здавати роботи з цього завдання.';
$string['preventsubmissionsshort'] = 'Заборонити змінювати роботи';
$string['previous'] = 'Назад';
$string['previoususer'] = 'Попередній користувач';
$string['privacy:attemptpath'] = 'спроба {$a}';
$string['privacy:blindmarkingidentifier'] = 'Ідентифікатор, який використовується для анонімних повідомлень';
$string['privacy:gradepath'] = 'клас';
$string['privacy:metadata:assigndownloadasfolders'] = 'Налаштування користувача щодо того, чи слід завантажувати декілька поданих файлів у папки';
$string['privacy:metadata:assignfeedbackpluginsummary'] = 'Дані зворотного зв’язку для виконання завдання.';
$string['privacy:metadata:assignfilter'] = 'Параметри фільтра, такі як "Надіслано", "Не надіслано", "Потрібна оцінка" та "Надано розширення"';
$string['privacy:metadata:assigngrades'] = 'Зберігає оцінки користувачів за завдання';
$string['privacy:metadata:assignmarkerfilter'] = 'Відфільтруйте підсумок призначення за призначеним маркером.';
$string['privacy:metadata:assignmentid'] = 'Ідентифікатор завдання';
$string['privacy:metadata:assignmessageexplanation'] = 'Повідомлення надсилаються учням через систему обміну повідомленнями.';
$string['privacy:metadata:assignoverrides'] = 'Зберігає інформацію про заміну для призначення';
$string['privacy:metadata:assignperpage'] = 'Кількість завдань, показаних на сторінці.';
$string['privacy:metadata:assignquickgrading'] = 'Переваги щодо того, чи використовується швидке оцінювання чи ні.';
$string['privacy:metadata:assignsubmissiondetail'] = 'Зберігає інформацію про подання користувачів';
$string['privacy:metadata:assignsubmissionpluginsummary'] = 'Дані для подання завдання.';
$string['privacy:metadata:assignuserflags'] = 'Зберігає метадані користувача, такі як дати розширення';
$string['privacy:metadata:assignusermapping'] = 'Зіставлення для анонімних повідомлень';
$string['privacy:metadata:assignworkflowfilter'] = 'Відфільтруйте за різними етапами робочого процесу.';
$string['privacy:metadata:grade'] = 'Числова оцінка за це завдання. Можна визначити за шкалами/формами для розширеної оцінки тощо, але завжди буде перетворено назад у число з плаваючою комою.';
$string['privacy:metadata:grader'] = 'Ідентифікатор користувача, який оцінює.';
$string['privacy:metadata:groupid'] = 'Ідентифікатор групи, членом якої є користувач.';
$string['privacy:metadata:latest'] = 'Значно спрощує запити, які хочуть знати інформацію лише про останню спробу.';
$string['privacy:metadata:mailed'] = 'Цього користувача вже надіслали?';
$string['privacy:metadata:timecreated'] = 'Час створення';
$string['privacy:metadata:timestarted'] = 'Час початку';
$string['privacy:metadata:userid'] = 'ID користувача';
$string['privacy:studentpath'] = 'студентські завдання';
$string['privacy:submissionpath'] = 'завдання';
$string['quickgrading'] = 'Швидке оцінювання';
$string['quickgrading_help'] = 'Швидке оцінювання дозволяє вам виставити оцінки (та дати відгуки) прямо в таблиці з результатами завдань. Швидке оцінювання не сумісне з розширеним оцінюваннм та не рекомендується при наявності рубрик.';
$string['quickgradingchangessaved'] = 'Всі зміни збережено';
$string['quickgradingresult'] = 'Швидке оцінювання';
$string['recordid'] = 'Ідентифікатор';
$string['relativedatessubmissiontimeleft'] = 'Розраховано на кожного учня';
$string['removeallgroupoverrides'] = 'Видалити всі заміни груп';
$string['removealluseroverrides'] = 'Видалити всі заміни користувача';
$string['removesubmission'] = 'Видалити завдання';
$string['removesubmissionconfirm'] = 'Ви впевнені, що бажаєте видалити свій матеріал?';
$string['removesubmissionconfirmforstudent'] = 'Ви впевнені, що хочете видалити завдання про {$a}?';
$string['removesubmissionconfirmforstudentwithtimelimit'] = 'Ви впевнені, що хочете видалити завдання про {$a}? Зауважте, що це не скине ліміт часу студента. Ви можете дати більше часу, додавши обмеження часу для користувача.';
$string['removesubmissionconfirmwithtimelimit'] = 'Ви впевнені, що бажаєте видалити свій матеріал? Зауважте, що це не скине ліміт часу.';
$string['removesubmissionforstudent'] = 'Видалити заявку для студента: (id={$a->id}, fullname={$a->fullname}).';
$string['reopenuntilpassincompatiblewithblindmarking'] = 'Опція «Відкрити до проходження» несумісна з анонімними заявами, оскільки оцінки не публікуються в журналі оцінок, доки не буде виявлено особистості студента.';
$string['requireallteammemberssubmit'] = 'Обов’язкова здача всіх членів групи';
$string['requireallteammemberssubmit_help'] = 'Цей параметр потрібно використовувати разом із параметром «Вимагати від студентів натиснути кнопку надсилання» в налаштуваннях подання.

Якщо ввімкнено, усі учасники групи повинні натиснути кнопку «Надіслати», щоб групове подання вважалося надісланим. Якщо вимкнено, будь-який учасник групи може натиснути кнопку «Надіслати».';
$string['requiresubmissionstatement'] = 'Студенти повинні обов’язково прийняти заяву виконавця';
$string['requiresubmissionstatement_help'] = 'Студенти повинні обов’язково прийняти заяву виконавця у всіх завданнях на всіх курсах. Якщо ця опція виключена, то викладачі самостійно можуть регулювати її в кожному завданні.';
$string['revealidentities'] = 'Показати ідентифікацію студентів';
$string['revealidentitiesconfirm'] = 'Ви впевнені, що хочете розкрити особистості студентів для цього завдання? Цю операцію неможливо скасувати. Після того, як особистості студентів будуть виявлені, оцінки будуть занесені в журнал оцінок.';
$string['reverttodefaults'] = 'Повернутися до значень за замовчуванням';
$string['reverttodraft'] = 'Повернути завдання до статусу чернетки';
$string['reverttodraftforgroup'] = 'Повернути подання до чернетки для групи {$a}.';
$string['reverttodraftforstudent'] = 'Повернути в стан чернетки для студента: (код={$a->id}, повне ім’я={$a->fullname}).';
$string['reverttodraftshort'] = 'Повернути до чернетки';
$string['reviewed'] = 'Переглянуто';
$string['save'] = 'Зберегти';
$string['saveallquickgradingchanges'] = 'Зберегти всі зміни';
$string['saveandcontinue'] = 'Зберегти та продовжити';
$string['savechanges'] = 'Зберегти';
$string['savegradingresult'] = 'Оцінка';
$string['savenext'] = 'Зберегти та показати наступне';
$string['saveoverrideandstay'] = 'Збережіть та введіть інше перевизначення';
$string['savingchanges'] = 'Збереження змін...';
$string['scale'] = 'Шкала';
$string['search:activity'] = 'Завдання - інформація про діяльність';
$string['selectedusers'] = 'Вибрані користувачі';
$string['selectlink'] = 'Вибрати';
$string['selectuser'] = 'Вибрати  {$a}';
$string['sendlatenotifications'] = 'Повідомити викладачів про прострочені завдання';
$string['sendlatenotifications_help'] = 'Якщо включено, то оцінювач (зазвичай викладач) буде отримувати повідомлення щораз, коли студент здає роботу із запізненням. Методи повідомлень можуть налаштовуватися.';
$string['sendnotifications'] = 'Повідомити викладачів про здані роботи';
$string['sendnotifications_help'] = 'Якщо включено, то оцінювач (зазвичай викладач) буде отримувати повідомлення щораз, коли студент здає роботу раніше, вчасно або із запізненням. Методи повідомлень можуть налаштовуватися.';
$string['sendstudentnotifications'] = 'Повідомити студента';
$string['sendstudentnotifications_help'] = 'Установіть цей прапорець, щоб надіслати сповіщення про оновлену оцінку або відгук. Якщо завдання використовує робочий процес оцінювання або оцінки приховано у звіті оцінювача, сповіщення не буде надіслано, доки оцінка не буде знята.';
$string['sendstudentnotificationsdefault'] = 'За замовчуванням для "Повідомити студента"';
$string['sendstudentnotificationsdefault_help'] = 'Під час оцінювання кожного учня, чи потрібно поставити галочку «Повідомити студента» за замовчуванням?';
$string['sendsubmissionreceipts'] = 'Надіслати підтвердження здачі роботи студентам';
$string['sendsubmissionreceipts_help'] = 'Цей перемикач дозволяє студентам отримувати інформацію про завдання. Студенти отримають сповіщення щоразу, коли вони успішно подають завдання.';
$string['setmarkerallocationforlog'] = 'Встановити призначення оцінювання: (id={$a->id}, fullname={$a->fullname}, marker={$a->marker}).';
$string['setmarkingallocation'] = 'Встановити призначеного оцінювача';
$string['setmarkingworkflowstate'] = 'Встановити стан оцінювання';
$string['setmarkingworkflowstateforlog'] = 'Встановити стан оцінювання: (id={$a->id}, fullname={$a->fullname}, state={$a->state}).';
$string['settings'] = 'Налаштування завдання';
$string['showrecentsubmissions'] = 'Показати останні здачі';
$string['status'] = 'Статус';
$string['studentnotificationworkflowstateerror'] = 'Щоб повідомити студентів, необхідно перейти до етапу оцінювання "Показано"';
$string['submission'] = 'Прийнято відповідей';
$string['submissionattachments'] = 'Показувати файли лише під час подання';
$string['submissionattachments_help'] = 'Установіть прапорець, щоб на сторінці подання відображалися лише файли. В іншому випадку файли відображатимуться як на сторінках завдання, так і на сторінках подання.';
$string['submissioncopiedhtml'] = 'Ви зробили копію своєї попередньої відповіді на завдання \'<i>{$a->assignment}</i>\'<br /><br /> Ви можете переглянути статус вашої <a href="{$a->url}">поданої роботи</a>.';
$string['submissioncopiedsmall'] = 'Ви зробили копію своєї попередньої відповіді на завдання {$a->assignment}';
$string['submissioncopiedtext'] = 'Ви зробили копію своєї попередньої відповіді на завдання \'{$a->assignment}\'

Ви можете переглянути статус вашої поданої роботи:

{$a->url}';
$string['submissiondrafts'] = 'Вимагати від студентів натиснути кнопку надіслати';
$string['submissiondrafts_help'] = 'Чи повинні студенти мати кнопку «Надіслати», щоб вказувати, коли вони закінчили вносити зміни до свого поданого завдання і воно готове до оцінювання?';
$string['submissioneditable'] = 'Студент може редагувати свою роботу';
$string['submissionempty'] = 'Нічого не здано';
$string['submissionlog'] = 'Студент: {$a->fullname}, Статус: {$a->status}';
$string['submissionmodified'] = 'Ви вже маєте здану роботу. Будь ласка, залиште цю сторінку та спробуйте знову.';
$string['submissionmodifiedgroup'] = 'Дані роботи було змінено кимось іншим. Будь ласка, залиште цю сторінку та спробуйте знову.';
$string['submissionnotcopiedinvalidstatus'] = 'Ця відповідь не була скопійована, оскільки вона була відредагована при перездачі роботи.';
$string['submissionnoteditable'] = 'Студент не може редагувати свою роботу';
$string['submissionnotopen'] = 'Це завдання не можна подавати';
$string['submissionnotready'] = 'Це завдання не готове до здачі:';
$string['submissionplugins'] = 'Модуль здачі завдань';
$string['submissionreceipthtml'] = 'Ви здали роботу на завдання \'<i>{$a->assignment}</i>\'<br /><br /> Ви можете переглядати статус своєї роботи на <a href="{$a->url}">сторінці завдання</a>.';
$string['submissionreceiptotherhtml'] = 'Вашу роботу з  \'<i>{$a->assignment}</i>\' прийнято.<br /><br /> Статус перевірки вашої роботи ви можете переглянути <a href="{$a->url}">тут</a>.';
$string['submissionreceiptothersmall'] = 'Вашу роботу з  \'{$a->assignment}\' прийнято.';
$string['submissionreceiptothertext'] = 'Вашу роботу з  \'{$a->assignment}\' прийнято.

Статус перевірки вашої роботи:

{$a->url}';
$string['submissionreceipts'] = 'Надіслати підтвердження здачі роботи';
$string['submissionreceiptsmall'] = 'Ви здали роботу на завдання \'{$a->assignment}';
$string['submissionreceipttext'] = 'Ви здали роботу на завдання \'{$a->assignment}\' Ви можете переглядати статус своєї роботи на сторінці завдання:  {$a->url}';
$string['submissionsclosed'] = 'Подання робіт закрито';
$string['submissionsettings'] = 'Параметри відповідей';
$string['submissionslocked'] = 'Це завдання не приймає робіт';
$string['submissionslockedshort'] = 'Зміна результатів робіт не дозволена';
$string['submissionstatement'] = 'Заява виконавця роботи';
$string['submissionstatement_help'] = 'Заява, яку кожен студент повинен прийняти, щоб подати свою роботу.';
$string['submissionstatementacceptedlog'] = 'Заява виконавця роботи прийнята користувачем  {$a}';
$string['submissionstatementdefault'] = 'Цей матеріал є моєю власною роботою, за винятком випадків, коли я підтверджую використання робіт інших людей.';
$string['submissionstatementrequired'] = 'Ви повинні погодитися з цією заявою, перш ніж ви зможете подати.';
$string['submissionstatementteamsubmission'] = 'Заява про подання групи';
$string['submissionstatementteamsubmission_help'] = 'Заява, яку кожен студент повинен прийняти, щоб подати роботу своєї групи.';
$string['submissionstatementteamsubmissionallsubmit'] = 'Заява про подання групи, де подають усі члени групи';
$string['submissionstatementteamsubmissionallsubmit_help'] = 'Заява, яку кожен студент повинен прийняти, щоб подати свою роботу як член групи.';
$string['submissionstatementteamsubmissionallsubmitdefault'] = 'Цей матеріал є моєю власною роботою як члена групи, за винятком випадків, коли я підтверджую використання робіт інших людей.';
$string['submissionstatementteamsubmissiondefault'] = 'Це подання є роботою моєї групи, за винятком випадків, коли ми визнаємо використання робіт інших людей.';
$string['submissionstatus'] = 'Статус роботи';
$string['submissionstatus_'] = 'Не здано';
$string['submissionstatus_draft'] = 'Чорновик (не здано)';
$string['submissionstatus_marked'] = 'Оцінено';
$string['submissionstatus_new'] = 'Немає відповіді';
$string['submissionstatus_reopened'] = 'Дозволено перездати';
$string['submissionstatus_submitted'] = 'Здано на оцінення';
$string['submissionstatusheading'] = 'Статус роботи';
$string['submissionsummary'] = '{$a->status}. Остання зміна {$a->timemodified}';
$string['submissionteam'] = 'Група';
$string['submissiontypes'] = 'Типи подання відповідей';
$string['submitaction'] = 'Відсилати відповідь';
$string['submitassignment'] = 'Відправити на оцінення';
$string['submitassignment_help'] = 'Як тільки ви відішлете роботу на оцінення, ви не зможете зробити в ній ніяких змін';
$string['submitforgrading'] = 'Відправити на оцінення';
$string['submitted'] = 'Відповідь прийнято';
$string['submittedearly'] = 'Завдання здано раніше на {$a}';
$string['submittedlate'] = 'Завдання здано пізніше на {$a}';
$string['submittedlateshort'] = 'Здано на {$a} пізніше';
$string['submittedovertime'] = 'Завдання було надіслано на {$a} протягом обмеженого часу';
$string['submittedundertime'] = 'Завдання було надіслано {$a} протягом обмеженого часу';
$string['subpagetitle'] = '{$a->contextname} - {$a->subpage}';
$string['subplugintype_assignfeedback'] = 'Модуль відгуку';
$string['subplugintype_assignfeedback_plural'] = 'Модулі відгуку';
$string['subplugintype_assignsubmission'] = 'Модуль подання';
$string['subplugintype_assignsubmission_plural'] = 'Модулі подання';
$string['teamname'] = 'Команда: {$a}';
$string['teamsubmission'] = 'Студенти здають у групі';
$string['teamsubmission_help'] = 'Якщо ввімкнено, студенти будуть розділені на групи на основі набору груп за замовчуванням або спеціального групування. Надсилання групи буде надано учасникам групи, і всі учасники групи бачитимуть зміни, які внесли один одного.';
$string['teamsubmissiongroupingid'] = 'Групування студентських груп';
$string['teamsubmissiongroupingid_help'] = 'Це групування, яке використовуватиме завдання для пошуку груп студентських груп. Якщо не встановлено, буде використовуватися набір груп за замовчуванням.';
$string['textinstructions'] = 'Інструкція до завдання';
$string['timelimit'] = 'Часовий ліміт';
$string['timelimit_help'] = 'Якщо ввімкнено, ліміт часу вказується на сторінці призначення, а під час призначення відображається таймер зворотного відліку.';
$string['timelimitnotenabled'] = 'Обмеження часу не ввімкнено для призначення.';
$string['timelimitpassed'] = 'Ліміт часу закінчився';
$string['timemodified'] = 'Востаннє змінено';
$string['timeremaining'] = 'Залишилося часу';
$string['timeremainingcolon'] = 'Залишилося часу: {$a}';
$string['togglezoom'] = 'Збільшити/зменшити масштаб';
$string['ungroupedusers'] = 'Налаштування «Вимагати групу для подання» увімкнено, і деякі користувачі або не є членами жодної групи, або є членами кількох груп, тому не можуть робити подання.';
$string['ungroupedusersoptional'] = 'Налаштування «Студенти надсилають у групи» увімкнено, і деякі користувачі або не є членами жодної групи, або є членами кількох груп. Зауважте, що ці студенти подадуться як члени «групи за замовчуванням».';
$string['unlimitedattempts'] = 'Необмежено';
$string['unlimitedattemptsallowed'] = 'Дозволено необмежену кількість спроб.';
$string['unlimitedpages'] = 'Необмежено';
$string['unlocksubmissionforstudent'] = 'Дозволити здати роботу студенту: (код={$a->id}, повне ім’я={$a->fullname}).';
$string['unlocksubmissions'] = 'Розблокувати роботи';
$string['unsavedchanges'] = 'Незбережені зміни';
$string['unsavedchangesquestion'] = 'Є незбережені зміни в оцінках або відгуках. Хочете зберегти зміни та продовжити?';
$string['updategrade'] = 'Оновити оцінку';
$string['updatetable'] = 'Зберегти та оновити таблицю';
$string['upgradenotimplemented'] = 'Оновлення не реалізовано в модулі ({$a->type} {$a->subtype})';
$string['userassignmentdefaults'] = 'Призначення користувача за замовчуванням';
$string['userextensiondate'] = 'Продовжено до: {$a}';
$string['usergrade'] = 'Оцінка';
$string['useridlistnotcached'] = 'Зміни оцінок НЕ збережено, оскільки не вдалося визначити для яких робіт вони призначені.';
$string['useroverrides'] = 'Перевизначення користувача';
$string['useroverridesdeleted'] = 'Перевизначення користувача видалено';
$string['usersnone'] = 'Жоден студент не має доступу до цього завдання.';
$string['usersubmissioncannotberemoved'] = 'Подання {$a} не можна видалити.';
$string['userswhoneedtosubmit'] = 'Користувачі, яким потрібно здати: {$a}';
$string['validmarkingworkflowstates'] = 'Допустимі стани оцінювання';
$string['viewadifferentattempt'] = 'Переглянути іншу спробу';
$string['viewbatchmarkingallocation'] = 'Переглянути сторінку встановлення призначень оцінювачів.';
$string['viewbatchsetmarkingworkflowstate'] = 'Переглянути сторінку встановлення станів оцінювання.';
$string['viewfeedback'] = 'Переглянути відгук';
$string['viewfeedbackforuser'] = 'Переглянути відгук для користувача: {$a}';
$string['viewfull'] = 'Повний перегляд';
$string['viewfullgradingpage'] = 'Відкрити сторінку оцінювання для надання відгуку';
$string['viewgradebook'] = 'Переглянути журнал оцінок';
$string['viewgrading'] = 'Переглянути всі роботи';
$string['viewgradingformforstudent'] = 'Переглянути сторінку оцінювання для студента: (код={$a->id}, повне ім’я={$a->fullname}).';
$string['viewownsubmissionform'] = 'Переглянути сторінку з поданою роботою.';
$string['viewownsubmissionstatus'] = 'Переглянути сторінку зі статусом поданої роботи.';
$string['viewrevealidentitiesconfirm'] = 'Переглянути сторінку підтвердження показу студентської ідентифікації.';
$string['viewsubmission'] = 'Переглянути роботу';
$string['viewsubmissionforuser'] = 'Переглянути роботу користувача: {$a}';
$string['viewsubmissiongradingtable'] = 'Переглянути таблицю оцінення робіт.';
$string['viewsummary'] = 'Переглянути резюме';
$string['workflowfilter'] = 'Фільтр станів';
$string['xofy'] = '{$a->x} з {$a->y}';
