<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_boost_union', language 'id', version '4.4'.
 *
 * @package     theme_boost_union
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['aboutuscontentsetting'] = 'Konten tentang kami';
$string['aboutuscontentsetting_desc'] = 'Dalam pengaturan ini, Anda dapat menambahkan konten teks kaya yang akan ditampilkan di halaman tentang kami.';
$string['aboutusdisabled'] = 'Halaman tentang kami dinonaktifkan untuk situs ini. Tidak ada yang bisa dilihat di sini.';
$string['aboutusheading'] = 'Tentang kami';
$string['aboutuslinkpositionboth'] = 'Tambahkan tautan ke halaman tentang kami ke catatan kaki dan ke ikon footer (questionmark)';
$string['aboutuslinkpositionfooter'] = 'Tambahkan tautan ke halaman tentang kami ke ikon footer (questionmark)';
$string['aboutuslinkpositionfootnote'] = 'Tambahkan tautan ke halaman tentang kami ke catatan kaki';
$string['aboutuslinkpositionnone'] = 'Jangan secara otomatis menampilkan tautan ke halaman tentang kami';
$string['aboutuslinkpositionsetting'] = 'Tautan posisi tentang kami';
$string['aboutuslinkpositionsetting_desc'] = 'Dalam pengaturan ini, Anda dapat mengonfigurasi apakah tautan ke halaman tentang kami akan ditambahkan secara otomatis ke halaman Moodle. Jika Anda tidak ingin menampilkan tautan secara otomatis, Anda dapat menambahkan tautan ke {$a->url} dari mana saja di Moodle secara manual.';
$string['aboutuspagetitledefault'] = 'Tentang kami';
$string['aboutuspagetitlesetting'] = 'Judul halaman tentang kami';
$string['aboutuspagetitlesetting_desc'] = 'Dalam pengaturan ini, Anda dapat menentukan judul halaman tentang kami. Teks ini juga akan digunakan sebagai teks tautan ke halaman tentang kami jika Anda mengonfigurasi \'Posisi tautan tentang kami\' sebagaimana mestinya.';
$string['accessibilitydeclarationcontentsetting'] = 'Deklarasi konten halaman aksesibilitas';
$string['accessibilitydeclarationcontentsetting_desc'] = 'Dalam pengaturan ini, Anda dapat menambahkan konten teks kaya yang akan ditampilkan pada halaman deklarasi aksesibilitas.';
$string['accessibilitydeclarationdisabled'] = 'Halaman informasi aksesibilitas dinonaktifkan untuk situs ini. Tidak ada yang bisa dilihat di sini.';
$string['accessibilitydeclarationheading'] = 'Deklarasi aksesibilitas';
$string['accessibilitydeclarationlinkpositionboth'] = 'Tambahkan tautan ke halaman deklarasi aksesibilitas ke catatan kaki dan ke ikon footer (questionmark)';
$string['accessibilitydeclarationlinkpositionfooter'] = 'Tambahkan tautan ke halaman deklarasi aksesibilitas ke ikon footer (questionmark)';
$string['accessibilitydeclarationlinkpositionfootnote'] = 'Tambahkan tautan ke halaman deklarasi aksesibilitas ke catatan kaki';
$string['accessibilitydeclarationlinkpositionnone'] = 'Jangan secara otomatis menampilkan tautan ke halaman deklarasi aksesibilitas';
$string['accessibilitydeclarationlinkpositionsetting'] = 'Deklarasi posisi tautan halaman aksesibilitas';
$string['accessibilitydeclarationlinkpositionsetting_desc'] = 'Dalam pengaturan ini, Anda dapat mengonfigurasi apakah tautan ke halaman deklarasi aksesibilitas harus ditambahkan secara otomatis ke halaman Moodle. Jika Anda tidak ingin menampilkan tautan secara otomatis, Anda dapat menambahkan tautan ke {$a->url} dari mana saja di Moodle secara manual.';
$string['accessibilitydeclarationpagetitledefault'] = 'Deklarasi aksesibilitas';
$string['accessibilitydeclarationpagetitlesetting'] = 'Judul halaman deklarasi aksesibilitas';
$string['accessibilitydeclarationpagetitlesetting_desc'] = 'Dalam pengaturan ini, Anda dapat menentukan judul halaman deklarasi aksesibilitas. Teks ini akan digunakan sebagai teks tautan ke halaman deklarasi aksesibilitas juga jika Anda mengonfigurasi \'Posisi tautan halaman deklarasi aksesibilitas\' sebagaimana mestinya.';
$string['accessibilitydeclarationtab'] = 'Deklarasi';
$string['accessibilitysupportanonymouscheckbox'] = 'Saya lebih suka mengirim permintaan dukungan aksesibilitas saya secara anonim';
$string['accessibilitysupportanonymousemail'] = 'anonymous@email.invalid';
$string['accessibilitysupportanonymoususer'] = 'Pengguna anonim';
$string['accessibilitysupportcontentdefault'] = '<p>Jika Anda memiliki masukan terkait aksesibilitas atau ingin melaporkan kendala, silakan gunakan formulir di bawah ini.</p><p>Apakah Anda bekerja dengan teknologi bantuan seperti pembaca layar, kaca pembesar, kontrol suara, atau perangkat lunak pengenalan ucapan? Jika ya, harap sebutkan yang mana. Untuk membantu kami memproses permintaan Anda, Anda dapat mengizinkan formulir tersebut untuk secara otomatis mengirimkan informasi berikut beserta pesan Anda: URL tempat Anda membuka formulir dukungan ini (ini disebut \'referrer\') dan beberapa informasi tentang peramban Anda.</p>';
$string['accessibilitysupportcontentsetting'] = 'Konten halaman dukungan aksesibilitas';
$string['accessibilitysupportcontentsetting_desc'] = 'Dalam pengaturan ini, Anda dapat menambahkan konten teks kaya yang akan ditampilkan pada halaman dukungan aksesibilitas, bersama dengan formulir untuk mengirimkan umpan balik aksesibilitas atau untuk melaporkan hambatan aksesibilitas.';
$string['accessibilitysupportdefaultsubject'] = 'Umpan balik aksesibilitas';
$string['accessibilitysupportdisabled'] = 'Halaman dukungan aksesibilitas dinonaktifkan untuk situs ini. Tidak ada yang bisa dilihat di sini.';
$string['accessibilitysupportheading'] = 'Halaman dukungan aksesibilitas';
$string['accessibilitysupportlinkpositionboth'] = 'Tambahkan tautan ke halaman dukungan aksesibilitas ke catatan kaki dan ikon footer (questionmark)';
$string['accessibilitysupportlinkpositionfooter'] = 'Tambahkan tautan ke halaman dukungan aksesibilitas ke ikon footer (questionmark)';
$string['accessibilitysupportlinkpositionfootnote'] = 'Tambahkan tautan ke halaman dukungan aksesibilitas ke catatan kaki';
$string['accessibilitysupportlinkpositionnone'] = 'Jangan secara otomatis menampilkan tautan ke halaman dukungan aksesibilitas';
$string['accessibilitysupportlinkpositionsetting'] = 'Posisi tautan halaman dukungan aksesibilitas';
$string['accessibilitysupportlinkpositionsetting_desc'] = 'Dalam pengaturan ini, Anda dapat mengonfigurasi apakah tautan ke halaman dukungan aksesibilitas harus ditambahkan secara otomatis ke halaman Moodle. Jika Anda tidak ingin menampilkan tautan secara otomatis, Anda dapat menambahkan tautan ke {$a->url} dari mana saja di Moodle secara manual.';
$string['accessibilitysupportmessagenotsent'] = 'Sayangnya permintaan dukungan aksesibilitas Anda tidak dapat dikirim.';
$string['accessibilitysupportmessagesent'] = 'Permintaan dukungan aksesibilitas Anda telah terkirim.';
$string['accessibilitysupportmessagetryagain'] = 'Silakan coba lagi nanti.';
$string['accessibilitysupportmessagetryalternative'] = 'Silakan coba lagi nanti atau kirim surel langsung ke <a href="mailto:{$a}">{$a}</a>.';
$string['accessibilitysupportpagesrlinktitledefault'] = 'Dapatkan dukungan aksesibilitas';
$string['accessibilitysupportpagesrlinktitlesetting'] = 'Judul tautan pembaca layar halaman dukungan aksesibilitas';
$string['accessibilitysupportpagesrlinktitlesetting_desc'] = 'Dalam pengaturan ini, Anda dapat menentukan judul tautan pembaca layar untuk halaman dukungan aksesibilitas. Teks ini akan digunakan sebagai teks tautan yang hanya ditampilkan kepada pembaca layar.';
$string['accessibilitysupportpagetitledefault'] = 'Dukungan aksesibilitas';
$string['accessibilitysupportpagetitlesetting'] = 'Judul halaman dukungan aksesibilitas';
$string['accessibilitysupportpagetitlesetting_desc'] = 'Dalam pengaturan ini, Anda dapat menentukan judul halaman dukungan aksesibilitas. Teks ini juga akan digunakan sebagai teks tautan ke halaman informasi dukungan aksesibilitas jika Anda mengonfigurasi \'Posisi tautan halaman dukungan aksesibilitas\' sebagaimana mestinya.';
$string['accessibilitysupportrecaptcha'] = 'Tambahkan re-captcha ke halaman dukungan aksesibilitas';
$string['accessibilitysupportrecaptcha_desc'] = 'Dengan pengaturan ini, Anda dapat mengontrol apakah re-captcha akan ditambahkan ke halaman dukungan aksesibilitas. Hal ini dilakukan untuk mencegah spam dan penyalahgunaan formulir dukungan aksesibilitas, seperti yang dilakukan dalam <a href="{$a->support}">formulir dukungan inti Moodle</a>. Namun, menambahkan re-captcha akan menambah hambatan aksesibilitas bagi pengguna yang menggunakan pembaca layar atau teknologi bantuan lainnya yang mungkin kontraproduktif dalam kasus ini. Jadi, harap pilih dengan bijak jika Anda ingin mengaktifkan pengaturan ini. Harap perhatikan juga bahwa, meskipun diaktifkan, re-captcha tidak akan ditampilkan hingga Anda menyetel <a href="{$a->settings}">kunci API yang diperlukan dalam pengaturan otentikasi</a>.';
$string['accessibilitysupportsentforanonymoususer'] = 'Pengguna meminta untuk mengirimkan umpan balik aksesibilitas ini secara anonim.';
$string['accessibilitysupportsubmit'] = 'Kirim';
$string['accessibilitysupporttab'] = 'Halaman dukungan';
$string['accessibilitysupporttechinfo'] = 'Informasi teknis';
$string['accessibilitysupporttechinfocheckbox'] = 'Saya setuju untuk mengirimkan informasi teknis berikut bersama dengan pesan saya';
$string['accessibilitysupporttechinfolabel'] = 'Informasi teknis untuk dikirim';
$string['accessibilitysupporttechinforeferrer'] = 'Halaman rujukan';
$string['accessibilitysupporttechinfosysinfo'] = 'Informasi sistem';
$string['accessibilitysupportuserfirstname'] = 'Aksesibilitas';
$string['accessibilitysupportuserlastname'] = 'dukungan';
$string['accessibilitysupportusermail'] = 'Surel pengguna dukungan aksesibilitas';
$string['accessibilitysupportusermail_desc'] = 'Di sini Anda menentukan alamat surel yang akan dikirimi permintaan dukungan aksesibilitas. Jika Anda membiarkan kolom ini kosong, permintaan akan dikirim ke <a href="{$a->url}">kontak dukungan situs yang dikonfigurasi</a>.';
$string['accessibilitysupportusermailsubject'] = 'Permintaan dukungan aksesibilitas';
$string['activitiesheading'] = 'Blok aktivitas';
$string['activitiestintenabled'] = 'Ikon aktivitas aktivitas warna';
$string['activitiestintenabled_desc'] = 'Dengan pengaturan ini, Anda dapat mewarnai ikon aktivitas di blok aktivitas berdasarkan tujuan aktivitas. Secara bawaan, inti Moodle menampilkannya hanya sebagai ikon hitam.';
$string['activitybrandingtab'] = 'Merek aktivitas';
$string['activityiconcoloradministrationsetting'] = 'Warna ikon aktivitas untuk "Administrasi"';
$string['activityiconcoloradministrationsetting_desc'] = 'Warna ikon aktivitas untuk "Administrasi"';
$string['activityiconcolorassessmentsetting'] = 'Warna ikon aktivitas untuk "Penilaian"';
$string['activityiconcolorassessmentsetting_desc'] = 'Warna ikon aktivitas untuk "Penilaian"';
$string['activityiconcolorcollaborationsetting'] = 'Warna ikon aktivitas untuk "Kolaborasi"';
$string['activityiconcolorcollaborationsetting_desc'] = 'Warna ikon aktivitas untuk "Kolaborasi"';
$string['activityiconcolorcommunicationsetting'] = 'Warna ikon aktivitas untuk "Komunikasi"';
$string['activityiconcolorcommunicationsetting_desc'] = 'Warna ikon aktivitas untuk "Komunikasi"';
$string['activityiconcolorcontentsetting'] = 'Warna ikon aktivitas untuk "Konten"';
$string['activityiconcolorcontentsetting_desc'] = 'Warna ikon aktivitas untuk "Konten"';
$string['activityiconcolorfidelity_detailled'] = 'Penelitian terperinci (hingga 100 iterasi)';
$string['activityiconcolorfidelity_insane'] = 'Pencarian mendalam (hingga 500 iterasi)';
$string['activityiconcolorfidelity_oneshot'] = 'Sekali proses  (1 iterasi)';
$string['activityiconcolorfidelity_sometries'] = 'Beberapa percobaan (hingga 10 iterasi)';
$string['activityiconcolorfidelitysetting'] = 'Akurasi warna ikon aktivitas';
$string['activityiconcolorfidelitysetting_desc'] = 'Dengan pengaturan di atas, Anda menetapkan warna heksadesimal yang akan digunakan untuk mewarnai ikon aktivitas tertentu. Namun, secara teknis, ikon aktivitas diwarnai dengan filter CSS. Boost Union menggunakan algoritma canggih untuk menentukan filter CSS yang cocok secara visual dengan warna heksadesimal yang diberikan, tetapi algoritma ini didasarkan pada pencarian acak dan mungkin menghasilkan hasil yang kurang optimal jika dijalankan hanya sekali. Dengan pengaturan ini, Anda dapat mengizinkan Boost Union untuk menjalankan algoritma beberapa kali dan memilih filter yang paling sedikit menyimpang dari warna heksadesimal pada akhirnya. Harap dicatat bahwa pengaturan ini berdampak pada waktu pembersihan cache (semakin banyak iterasi yang Anda izinkan, semakin lama waktu yang dibutuhkan Moodle untuk membersihkan cache tema), tetapi tidak akan berdampak pada waktu muat halaman.';
$string['activityiconcolorinteractivecontentsetting'] = 'Warna ikon aktivitas untuk "Konten interaktif"';
$string['activityiconcolorinteractivecontentsetting_desc'] = 'Warna ikon aktivitas untuk "Konten interaktif"';
$string['activityiconcolorinterfacesetting'] = 'Warna ikon aktivitas untuk "Antarmuka"';
$string['activityiconcolorinterfacesetting_desc'] = 'Warna ikon aktivitas untuk "Antarmuka"';
$string['activityiconcolorsheading'] = 'Warna ikon aktivitas';
$string['activitynavigationsetting'] = 'Elemen navigasi aktivitas & bagian';
$string['activitynavigationsetting_desc'] = 'Dengan pengaturan ini, elemen untuk melompat ke aktivitas/sumber daya sebelumnya dan berikutnya serta menu tarik-turun untuk melompat ke aktivitas/sumber daya tertentu akan ditampilkan. Lebih jauh, dalam kursus yang menggunakan mode \'satu bagian per halaman\', elemen serupa untuk bagian sebelumnya dan berikutnya juga ditampilkan. Elemen UI seperti ini sudah ada di Boost dalam Moodle Core hingga Moodle 3.11, tetapi dihapus di 4.0. Dengan Boost Union, Anda dapat mengembalikannya.';
$string['activitypurposeadministration'] = 'Administrasi';
$string['activitypurposeassessment'] = 'Penilaian';
$string['activitypurposecollaboration'] = 'Kolaborasi';
$string['activitypurposecommunication'] = 'Komunikasi';
$string['activitypurposecontent'] = 'Konten';
$string['activitypurposeheading'] = 'Tujuan ikon aktivitas';
$string['activitypurposeheading_desc'] = 'Dengan pengaturan ini, Anda dapat mengganti warna latar belakang ikon aktivitas yang ditentukan oleh tujuan aktivitas (dan yang merupakan fitur plugin yang dikodekan secara permanen di setiap aktivitas).';
$string['activitypurposeheadingtechnote'] = 'Catatan teknis: Karena cara inti Moodle mengimplementasikan tujuan aktivitas dan warnanya, tujuan aktivitas hanya diganti dengan CSS oleh Boost Union. Saat ini, semua area di inti Moodle yang menampilkan ikon aktivitas berwarna harus dicakup. Jika Anda melihat area atau plugin pihak ketiga yang terus menampilkan warna tujuan aktivitas yang tidak berubah, harap laporkan di {$a}.';
$string['activitypurposeinteractivecontent'] = 'Konten interaktif';
$string['activitypurposeinterface'] = 'Antarmuka';
$string['activitypurposeother'] = 'Lainnya';
$string['additionalresourcesfileurlpersistent'] = 'URL (persisten)';
$string['additionalresourcesfileurlrevisioned'] = 'URL (direvisi)';
$string['additionalresourcesheading'] = 'Sumber tambahan';
$string['additionalresourceslistsetting'] = 'Daftar sumber tambahan';
$string['additionalresourceslistsetting_desc'] = 'Ini adalah daftar berkas yang telah Anda unggah ke area berkas sumber tambahan. URL yang diberikan dapat digunakan untuk menautkan ke berkas-berkas ini dari dalam CSS kustom Anda, dari catatan kaki, atau di mana pun Anda perlu menggunakan berkas yang diunggah tetapi tidak dapat mengunggah berkas di tempatnya.';
$string['additionalresourcessetting'] = 'Sumber tambahan';
$string['additionalresourcessetting_desc'] = 'Dengan pengaturan ini, Anda dapat mengunggah sumber tambahan ke tema. Keuntungan mengunggah berkas ke area berkas ini adalah berkas-berkas tersebut dapat dikirimkan tanpa pemeriksaan jika pengguna login. Inilah sebabnya Anda hanya boleh menambahkan berkas yang tidak penting dan semua orang harus diizinkan untuk mengakses dan tidak perlu dilindungi dengan masuk yang valid. Segera setelah Anda mengunggah setidaknya satu berkas ke area berkas ini dan menyimpan pengaturan, daftar akan muncul di bawahnya yang akan memberi Anda URL yang dapat Anda gunakan untuk merujuk ke berkas tertentu.';
$string['addpreferredlangsetting'] = 'Tambahkan tautan bahasa pilihan ke menu bahasa';
$string['addpreferredlangsetting_desc'] = 'Dengan pengaturan ini, Anda dapat menambahkan pengaturan \'Tetapkan bahasa pilihan\' ke menu bahasa dalam menu pengguna. Dapat dipahami, pengaturan ini hanya diproses jika pengaturan <a href="{$a->url1}">Menu bahasa tampilan</a> diaktifkan, dan jika setidaknya <a href="{$a->url2}">paket bahasa kedua diinstal</a> dan <a href="{$a->url3}">ditawarkan untuk dipilih</a>.';
$string['administrationtab'] = 'Administrasi';
$string['allowaccessibilitysupportwithoutlogin'] = 'Izinkan halaman dukungan aksesibilitas tanpa login';
$string['allowaccessibilitysupportwithoutlogin_desc'] = 'Jika pengaturan ini diaktifkan, halaman dukungan aksesibilitas akan ditampilkan kepada pengguna yang tidak masuk. Jika pengaturan ini dinonaktifkan, hanya pengguna yang masuk yang akan diizinkan mengakses halaman dukungan aksesibilitas.';
$string['allowanonymoussubmitssetting'] = 'Izinkan pengiriman halaman dukungan anonim';
$string['allowanonymoussubmitssetting_desc'] = 'Dengan pengaturan ini, Anda dapat mengizinkan pengguna untuk mengirimkan umpan balik aksesibilitas secara anonim melalui halaman dukungan aksesibilitas. Pengguna kemudian dapat memutuskan apakah mereka ingin mengirimkan umpan balik secara anonim (tanpa mengirimkan nama pengguna dan alamat email mereka) atau tidak.';
$string['allowsendtechinfoalongsetting'] = 'Izinkan pengiriman informasi teknis bersama';
$string['allowsendtechinfoalongsetting_desc'] = 'Dengan pengaturan ini, Anda dapat mengizinkan pengguna untuk mengirim informasi teknis di halaman dukungan aksesibilitas. Pengguna kemudian dapat memutuskan apakah mereka ingin mengirim informasi teknis atau tidak.';
$string['alternativelogolinkurlsetting'] = 'URL tautan logo alternatif';
$string['alternativelogolinkurlsetting_desc'] = 'Dengan pengaturan ini, Anda dapat menetapkan URL tautan alternatif yang akan digunakan sebagai tautan pada logo di bilah navigasi. Anda dapat menggunakan pengaturan ini untuk, misalnya, menautkan ke situs web organisasi Anda alih-alih beranda Moodle guna mempertahankan bilah navigasi yang homogen di seluruh sistem organisasi Anda.';
$string['always'] = 'Selalu';
$string['auto'] = 'Secara otomatis';
$string['backgroundimagepositionsetting'] = 'Posisi gambar latar belakang';
$string['backgroundimagepositionsetting_desc'] = 'Dengan pengaturan ini, Anda mengendalikan posisi gambar latar belakang di dalam jendela browser. Nilai pertama adalah posisi horizontal, nilai kedua adalah posisi vertikal.';
$string['backgroundimagesetting'] = 'Gambar latar belakang';
$string['backgroundimagesetting_desc'] = 'Di sini, Anda dapat mengunggah gambar khusus untuk ditampilkan sebagai latar belakang situs. Gambar latar yang Anda unggah di sini akan menggantikan gambar latar dalam berkas prasetel tema Anda.';
$string['backgroundimagesheading'] = 'Gambar latar belakang umum';
$string['backtotop'] = 'Kembali ke atas';
$string['backtotopbuttonsetting'] = 'Tombol kembali ke atas';
$string['backtotopbuttonsetting_desc'] = 'Dengan pengaturan ini, tombol kembali ke atas akan muncul di sudut kanan bawah halaman segera setelah pengguna menggulir halaman ke bawah. Tombol seperti ini sudah ada di Boost di Moodle Core hingga Moodle 3.11, tetapi dihapus di 4.0. Dengan Boost Union, Anda dapat mengembalikannya.';
$string['blockdrawerwidthsetting'] = 'Lebar laci blok';
$string['blockdrawerwidthsetting_desc'] = 'Dengan pengaturan ini, Anda dapat mengganti lebar laci blok Moodle tanpa modifikasi SCSS manual. Secara bawaan, Moodle menggunakan lebar konten medium maksimal 315 piksel. Anda dapat memasukkan nilai berbasis piksel lainnya seperti 400 piksel, tetapi nilai dengan unit lain seperti nilai berbasis persentase atau nilai lebar viewport tidak akan berfungsi.';
$string['blockregionfooterwidth'] = 'Lebar wilayah blok untuk wilayah \'Footer\'';
$string['blockregionfooterwidth_desc'] = 'Dengan pengaturan ini, Anda dapat mengatur lebar blok \'Footer\'. Anda dapat memilih antara lebar penuh, lebar konten kursus, dan lebar hero.';
$string['blockregionoutsidebottomwidth'] = 'Lebar wilayah blok untuk wilayah \'Luar (bawah)\'';
$string['blockregionoutsidebottomwidth_desc'] = 'Dengan pengaturan ini, Anda dapat mengatur lebar area blok \'Luar (bawah)\' yang ditampilkan di bawah konten utama. Anda dapat memilih antara lebar penuh, lebar konten kursus, dan lebar hero.';
$string['blockregionoutsideleftwidth'] = 'Lebar wilayah blok untuk wilayah \'Luar (kiri)\'';
$string['blockregionoutsideleftwidth_desc'] = 'Dengan pengaturan ini, Anda dapat mengatur lebar area blok \'Luar (kiri)\' yang ditampilkan di sisi kiri area konten utama. Secara bawaan, Boost Union menggunakan lebar 300 piksel. Anda dapat memasukkan nilai berbasis piksel lainnya seperti 200 piksel, tetapi Anda juga dapat memasukkan nilai berbasis persentase seperti 10% atau nilai lebar viewport seperti 10vw.';
$string['blockregionoutsiderightwidth'] = 'Lebar wilayah blok untuk wilayah \'Luar (kanan)\'';
$string['blockregionoutsiderightwidth_desc'] = 'Dengan pengaturan ini, Anda dapat mengatur lebar area blok \'Luar (kanan)\' yang ditampilkan di sisi kanan area konten utama. Secara bawaan, Boost Union menggunakan lebar 300 piksel. Anda dapat memasukkan nilai berbasis piksel lainnya seperti 200 piksel, tetapi Anda juga dapat memasukkan nilai berbasis persentase seperti 10% atau nilai lebar viewport seperti 10vw.';
$string['blockregionoutsidetopwidth'] = 'Lebar wilayah blok untuk wilayah \'Luar (atas)\'';
$string['blockregionoutsidetopwidth_desc'] = 'Dengan pengaturan ini, Anda dapat mengatur lebar area blok \'Luar (atas)\' yang ditampilkan di bagian paling atas halaman. Anda dapat memilih antara lebar penuh, lebar konten kursus, dan lebar hero.';
$string['blockregionsforlayout'] = 'Wilayah blok tambahan untuk tata letak \'{$a}\'';
$string['blockregionsforlayout_desc'] = 'Dengan pengaturan ini, Anda dapat mengaktifkan wilayah blok tambahan untuk tata letak \'{$a}\'.';
$string['blockregionsheading'] = 'Wilayah blok tambahan';
$string['blockregionsheading_desc'] = '<p>Boost Union menyediakan sejumlah besar area blok tambahan yang dapat digunakan untuk menambahkan dan menampilkan blok di seluruh halaman Moodle:</p>
<ul><li><em>Area blok Luar</em> ditempatkan di keempat sisi halaman Moodle. Area ini dapat digunakan untuk menampilkan blok yang menyertai halaman Moodle yang ditampilkan tetapi tidak secara langsung merupakan bagian dari konten utama.</li>
<li><em>Area blok Header</em> ditempatkan di antara area Luar (atas) dan area konten utama. Area ini dapat digunakan untuk menampilkan blok sebagai informasi header kursus.</li>
<li><em>Area blok Konten</em> ditempatkan langsung di atas dan di bawah konten utama di area konten utama. Area ini dapat digunakan untuk menambahkan blok ke alur konten kursus.</li>
<li><em>Area blok Footer</em> ditempatkan di bagian bawah halaman, di antara area Luar (bawah) dan catatan kaki. Anda memiliki tiga area footer yang tersedia untuk membuat kolom jika diperlukan.</li>
<li><em>Area blok Off-canvas</em> terasa istimewa karena berada di atas seluruh halaman Moodle sebagai laci. Laci ini dibuka oleh ikon 9 titik di sisi paling kanan bilah navigasi. Anda memiliki tiga area off-canvas yang tersedia untuk membuat kolom jika diperlukan.</li></ul>
<p>Harap diperhatikan:</p>
<ul><li>Secara bawaan, semua area blok tambahan dinonaktifkan. Harap aktifkan area blok tertentu pada tata letak halaman tertentu sesuai kebutuhan Anda. Usahakan untuk sefokus mungkin – terlalu banyak area blok dapat membingungkan pengguna akhir.</li>
<li>Begitu area blok tambahan diaktifkan, area tersebut akan terlihat oleh semua pengguna yang terautentikasi dan dapat diedit oleh guru dan manajer (tentu saja, tergantung pada apakah pengguna tersebut diizinkan untuk mengedit halaman Moodle tertentu). Namun, terdapat juga kemampuan theme/boost_union:viewregion* dan theme/boost_union:editregion* yang memungkinkan Anda menyesuaikan penggunaan setiap wilayah blok sesuai kebutuhan.</li>
<li>Wilayah blok Luar (kiri), Luar (kanan), Konten (atas), Konten (bawah), dan Header tidak tersedia untuk semua tata letak halaman.</li></ul>';
$string['blockregionsheading_experimental'] = 'Harap diperhatikan: Wilayah blok <em>Luar (kiri) dan Luar (kanan)</em> berfungsi penuh dalam status implementasi saat ini, tetapi harus <em>dianggap sebagai eksperimental</em> karena belum dapat terbungkus dengan benar pada layar dengan lebar sedang. Dengan latar belakang ini, harap gunakan dengan hati-hati. Masalah ini akan diperbaiki dalam rilis mendatang.';
$string['blocksgeneralheading'] = 'Blok umum';
$string['blockstab'] = 'Blok';
$string['boost_union:configure'] = 'Untuk dapat mengonfigurasi tema sebagai non-admin';
$string['boost_union:editregioncontentlower'] = 'Untuk dapat menyunting wilayah blok Konten (bawah)';
$string['boost_union:editregioncontentupper'] = 'Untuk dapat menyunting wilayah blok Konten (atas)';
$string['boost_union:editregionfootercenter'] = 'Untuk dapat menyunting wilayah blok Footer (tengah)';
$string['boost_union:editregionfooterleft'] = 'Untuk dapat menyunting wilayah blok Footer (kiri)';
$string['boost_union:editregionfooterright'] = 'Untuk dapat menyunting wilayah blok Footer (kanan)';
$string['boost_union:editregionheader'] = 'Untuk dapat menyunting wilayah blok Header';
$string['boost_union:editregionoffcanvascenter'] = 'Untuk dapat menyunting wilayah blok Off-canvas (tengah)';
$string['boost_union:editregionoffcanvasleft'] = 'Untuk dapat menyunting wilayah blok Off-canvas (kiri)';
$string['boost_union:editregionoffcanvasright'] = 'Untuk dapat menyunting wilayah blok Off-canvas (kanan)';
$string['boost_union:editregionoutsidebottom'] = 'Untuk dapat menyunting wilayah blok Luar (bawah)';
$string['boost_union:editregionoutsideleft'] = 'Untuk dapat meyunting wilayah blok Luar (kiri)';
$string['boost_union:editregionoutsideright'] = 'Untuk dapat menyunting wilayah blok Luar (kanan)';
$string['boost_union:editregionoutsidetop'] = 'Untuk dapat menyunting wilayah blok Luar (atas)';
$string['boost_union:viewhintcourseselfenrol'] = 'Untuk dapat melihat petunjuk untuk pendaftaran mandiri tanpa batas dalam kursus yang terlihat.';
$string['boost_union:viewhintinhiddencourse'] = 'Untuk dapat melihat petunjuk dalam kursus tersembunyi.';
$string['boost_union:viewregioncontentlower'] = 'Untuk dapat melihat wilayah blok Konten (bawah)';
$string['boost_union:viewregioncontentupper'] = 'Untuk dapat melihat wilayah blok Konten (atas)';
$string['boost_union:viewregionfootercenter'] = 'Untuk dapat melihat wilayah blok Footer (tengah)';
$string['boost_union:viewregionfooterleft'] = 'Untuk dapat melihat wilayah blok Footer (kiri)';
$string['boost_union:viewregionfooterright'] = 'Untuk dapat melihat wilayah blok Footer (kanan)';
$string['boost_union:viewregionheader'] = 'Untuk dapat melihat wilayah blok Header';
$string['boost_union:viewregionoffcanvascenter'] = 'Untuk dapat melihat wilayah blok Off-canvas (tengah)';
$string['boost_union:viewregionoffcanvasleft'] = 'Untuk dapat melihat wilayah blok Off-canvas (kiri)';
$string['boost_union:viewregionoffcanvasright'] = 'Untuk dapat melihat wilayah blok Off-canvas (kanan)';
$string['boost_union:viewregionoutsidebottom'] = 'Untuk dapat melihat wilayah blok Luar (bawah)';
$string['boost_union:viewregionoutsideleft'] = 'Untuk dapat melihat wilayah blok Luar (kiri)';
$string['boost_union:viewregionoutsideright'] = 'Untuk dapat melihat wilayah blok Luar (kanan)';
$string['boost_union:viewregionoutsidetop'] = 'Untuk dapat melihat wilayah blok Luar (atas)';
$string['bootstrapcolordangersetting'] = 'Warna bootstrap untuk "Danger"';
$string['bootstrapcolordangersetting_desc'] = 'Warna Bootstrap untuk "Danger"';
$string['bootstrapcolorinfosetting'] = 'Warna bootstrap untuk "Info"';
$string['bootstrapcolorinfosetting_desc'] = 'Warna Bootstrap untuk "Info"';
$string['bootstrapcolorsheading'] = 'Warna bootstrap';
$string['bootstrapcolorsuccesssetting'] = 'Warna bootstrap untuk "Success"';
$string['bootstrapcolorsuccesssetting_desc'] = 'Warna Bootstrap untuk "Success"';
$string['bootstrapcolorwarningsetting'] = 'Warna bootstrap untuk "Warning"';
$string['bootstrapcolorwarningsetting_desc'] = 'Warna Bootstrap untuk "Warning"';
$string['bootstrapdangercolor'] = 'Warna danger';
$string['bootstrapdarkcolor'] = 'Warna gelap';
$string['bootstrapinfocolor'] = 'Warna info';
$string['bootstraplightcolor'] = 'Warna terang';
$string['bootstrapnone'] = 'Tidak ada warna Bootstrap';
$string['bootstrapprimarycolor'] = 'Warna primary';
$string['bootstrapsecondarycolor'] = 'Warna secondary';
$string['bootstrapsuccesscolor'] = 'Warna success';
$string['bootstrapwarningcolor'] = 'Warna warning';
$string['brandcolorsheading'] = 'Warna brand';
$string['breadcrumbsheading'] = 'Breadcrumb';
$string['cachedef_flavours'] = 'Flavor yang berlaku untuk ID kategori halaman tertentu untuk pengguna saat ini';
$string['cachedef_hookoverrides'] = 'Kaitan menimpa';
$string['cachedef_smartmenu_items'] = 'Item menu pintar';
$string['cachedef_smartmenus'] = 'Menu pintar';
$string['cachedef_touchiconsios'] = 'Sentuh berkas ikon untuk iOS';
$string['categorybreadcrumbs'] = 'Menampilkan breadcrumb kategori di header kursus';
$string['categorybreadcrumbs_desc'] = 'Secara bawaan, breadcrumb kategori kursus tidak ditampilkan pada halaman kursus di header kursus. Dengan pengaturan ini, Anda dapat menampilkan breadcrumb kategori kursus di header kursus di atas nama kursus.';
$string['categoryindextab'] = 'Indeks kategori / Beranda situs';
$string['categorylistingheading'] = 'Daftar kategori';
$string['categorylistingpresentation'] = 'Presentasi daftar kategori';
$string['categorylistingpresentation_boxlist'] = 'Daftar kotak';
$string['categorylistingpresentation_desc'] = 'Dengan pengaturan ini, Anda dapat mengubah tampilan & nuansa daftar kategori pada halaman indeks kategori dan di beranda situs. Sebagai alternatif dari cara inti Moodle mempresentasikannya, Anda dapat mempresentasikan daftar kategori sebagai daftar kotak yang diperbarui.';
$string['categorylistingpresentation_nochange'] = 'Mimpi buruk desainer (tidak berubah seperti yang dipresentasikan oleh inti Moodle)';
$string['categorylistingpresentation_note'] = 'Harap diperhatikan: Jika Anda mengaktifkan pengaturan \'Presentasi daftar kursus\' di atas, kami sarankan untuk mengaktifkan pengaturan ini juga. Keduanya didesain untuk bekerja sama.';
$string['choosereadme'] = 'Tema Boost Union merupakan tema turunan Boost yang disempurnakan yang dimaksudkan, di satu sisi, untuk membuat Boost lebih mudah dikonfigurasi dan, di sisi lain, untuk menyediakan fitur tambahan yang bermanfaat bagi operasi Moodle harian para admin, guru, dan siswa. Boost Union dikelola oleh Moodle an Hochschulen e.V., bekerja sama dengan ssystems GmbH, bersama dengan bdecent GmbH dan lern.link GmbH';
$string['closeoffcanvas'] = 'Tutup laci Off-canvas';
$string['configtitle'] = 'Boost Union';
$string['configtitleaccessibility'] = 'Aksesibilitas';
$string['configtitlecontent'] = 'Konten';
$string['configtitlefeel'] = 'Nuansa';
$string['configtitleflavours'] = 'Flavor';
$string['configtitlefunctionality'] = 'Fungsionalitas';
$string['configtitlelook'] = 'Tampilan';
$string['contactcontentsetting'] = 'Konten halaman kontak';
$string['contactcontentsetting_desc'] = 'Dalam pengaturan ini, Anda dapat menambahkan konten teks kaya yang akan ditampilkan pada halaman kontak (yang tidak sama dengan halaman bawaan Moodle \'Hubungi dukungan situs\').';
$string['contactdisabled'] = 'Halaman kontak dinonaktifkan untuk situs ini. Tidak ada yang bisa dilihat di sini.';
$string['contactheading'] = 'Kontak';
$string['contactlinkpositionboth'] = 'Tambahkan tautan ke halaman kontak ke catatan kaki dan ke ikon footer (questionmark)';
$string['contactlinkpositionfooter'] = 'Tambahkan tautan ke halaman kontak ke ikon footer (questionmark)';
$string['contactlinkpositionfootnote'] = 'Tambahkan tautan ke halaman kontak ke catatan kaki';
$string['contactlinkpositionnone'] = 'Jangan secara otomatis menampilkan tautan ke halaman kontak';
$string['contactlinkpositionsetting'] = 'Posisi tautan halaman kontak';
$string['contactlinkpositionsetting_desc'] = 'Dalam pengaturan ini, Anda dapat mengonfigurasi apakah tautan ke halaman kontak harus ditambahkan secara otomatis ke halaman Moodle. Jika Anda tidak ingin menampilkan tautan secara otomatis, Anda dapat menambahkan tautan ke {$a->url} dari mana saja di Moodle secara manual.';
$string['contactpagetitledefault'] = 'Kontak';
$string['contactpagetitlesetting'] = 'Judul halaman kontak';
$string['contactpagetitlesetting_desc'] = 'Dalam pengaturan ini, Anda dapat menentukan judul halaman kontak. Teks ini juga akan digunakan sebagai teks tautan ke halaman kontak jika Anda mengonfigurasi \'Posisi tautan halaman kontak\' sebagaimana mestinya.';
$string['contentwidthheading'] = 'Lebar konten';
$string['coursecardscolumncount'] = 'Jumlah kolom kartu kursus';
$string['coursecardscolumncount_desc'] = 'Kisi kartu kursus akan disajikan dengan cara yang responsif dan kolom-kolomnya akan terbungkus pada layar yang lebih kecil. Dengan pengaturan ini, Anda tinggal mengendalikan jumlah kolom maksimum dalam kisi kartu kursus pada layar yang lebih besar. Menetapkan jumlah kolom maksimum menjadi 2, bukan 3, dapat membuat kartu kursus tampak lebih luas dan tidak terlalu ramai. Menetapkan jumlah kolom maksimum menjadi 1 juga memungkinkan dan secara efektif akan mengubah daftar kursus menjadi daftar kartu vertikal.';
$string['coursecontentmaxwidthsetting'] = 'Lebar maksimum konten kursus';
$string['coursecontentmaxwidthsetting_desc'] = 'Dengan pengaturan ini, Anda dapat mengganti lebar konten kursus Moodle tanpa modifikasi SCSS manual. Lebar ini digunakan sebagai lebar halaman kursus dan dalam beberapa aktivitas. Secara bawaan, Moodle menggunakan lebar maksimum konten kursus sebesar 830 piksel. Anda dapat memasukkan nilai berbasis piksel lainnya seperti 1200 piksel, tetapi Anda juga dapat memasukkan nilai berbasis persentase seperti 100% atau nilai lebar viewport seperti 90vw.';
$string['courseheaderheading'] = 'Header Kursus';
$string['courseheaderimageenabled'] = 'Menampilkan gambar kursus di header kursus';
$string['courseheaderimageenabled_desc'] = 'Bila diaktifkan, gambar kursus (yang dapat diunggah dalam pengaturan kursus) akan ditampilkan di header kursus. Gambar kursus ditampilkan di sana selain di halaman \'Kursus saya\' yang selalu ditampilkan.';
$string['courseheaderimagefallback'] = 'Gambar header kursus fallback';
$string['courseheaderimagefallback_desc'] = 'Jika Anda mengunggah gambar dalam pengaturan ini, gambar tersebut digunakan sebagai gambar fallback dan ditampilkan di header kursus jika tidak ada gambar kursus yang diunggah dalam pengaturan kursus tertentu. Jika Anda tidak mengunggah gambar di sini, gambar header kursus hanya ditampilkan dalam kursus tertentu jika gambar kursus diunggah dalam pengaturan kursus tertentu.';
$string['courseheaderimageheight'] = 'Tinggi gambar header kursus';
$string['courseheaderimageheight_desc'] = 'Dengan pengaturan ini, Anda mengontrol tinggi gambar header kursus yang dipresentasikan.';
$string['courseheaderimagelayout'] = 'Tata letak gambar tajuk kursus';
$string['courseheaderimagelayout_desc'] = 'Dengan pengaturan ini, Anda mengontrol tata letak gambar header kursus dan judul kursus.';
$string['courseheaderimagelayoutheadingabove'] = 'Judul kursus di atas gambar kursus';
$string['courseheaderimagelayoutstackeddark'] = 'Judul kursus ditumpuk pada gambar kursus (warna font putih untuk gambar latar belakang gelap)';
$string['courseheaderimagelayoutstackedlight'] = 'Judul kursus ditumpuk pada gambar kursus (warna font hitam untuk gambar latar belakang terang)';
$string['courseheaderimageposition'] = 'Posisi gambar header kursus';
$string['courseheaderimageposition_desc'] = 'Dengan pengaturan ini, Anda mengendalikan posisi gambar header kursus dalam wadah gambar header kursus. Nilai pertama adalah posisi horizontal, nilai kedua adalah posisi vertikal.';
$string['courseindexcompletioninfoposition'] = 'Posisi indikasi penyelesaian aktivitas';
$string['courseindexcompletioninfoposition_desc'] = 'Pilih posisi di mana indikasi penyelesaian ditampilkan. <em>Akhir baris</em> menampilkan indikator penyelesaian standar di akhir baris indeks kursus. <em>Awal baris</em> menampilkan indikator penyelesaian standar di awal baris indeks kursus. <em>Warna ikon</em> tidak menunjukkan indikator penyelesaian standar, tetapi mengodekan informasi penyelesaian sebagai latar belakang ikon modul kursus.';
$string['courseindexcompletioninfopositionendofline'] = 'Baris akhir';
$string['courseindexcompletioninfopositioniconcolor'] = 'Warna ikon';
$string['courseindexcompletioninfopositionstartofline'] = 'Baris awal';
$string['courseindexdrawerwidthsetting'] = 'Lebar laci indeks kursus';
$string['courseindexdrawerwidthsetting_desc'] = 'Dengan pengaturan ini, Anda dapat mengganti lebar laci indeks kursus Moodle tanpa modifikasi SCSS manual. Secara bawaan, Moodle menggunakan lebar laci indeks kursus sebesar 285 piksel. Anda dapat memasukkan nilai berbasis piksel lainnya seperti 320 piksel, tetapi nilai dengan satuan lain seperti nilai berbasis persentase atau nilai lebar viewport tidak akan berfungsi.';
$string['courseindexheading'] = 'Indeks Kursus';
$string['courseindexmodiconenabled'] = 'Menampilkan ikon jenis aktivitas dalam indeks kursus';
$string['courseindexmodiconenabled_desc'] = 'Bila diaktifkan, ikon jenis aktivitas yang sesuai ditampilkan di depan baris indeks dengan judul aktivitas. Dengan demikian, jenis aktivitas kursus akan menggantikan indikator penyelesaian kursus yang dipindahkan dari depan ke akhir baris indeks kursus, atau diwarnai dengan warna status penyelesaian.';
$string['courselistingcontacts'] = 'Kontak kursus';
$string['courselistingfields'] = 'Klasifikasi kursus';
$string['courselistinggoto'] = 'Pergi ke kursus';
$string['courselistingheading'] = 'Daftar kursus';
$string['courselistinghowcategory'] = 'Tampilkan kategori kursus dalam daftar kursus';
$string['courselistinghowcategory_desc'] = 'Dengan pengaturan ini, Anda mengontrol apakah kategori kursus ditampilkan dalam daftar kursus atau tidak.';
$string['courselistinghowenrolicons'] = 'Tampilkan ikon pendaftaran kursus di daftar kursus';
$string['courselistinghowenrolicons_desc'] = 'Dengan pengaturan ini, Anda mengontrol apakah ikon pendaftaran kursus ditampilkan dalam daftar kursus atau tidak.';
$string['courselistinghowfields'] = 'Tampilkan bidang kursus dalam daftar kursus';
$string['courselistinghowfields_desc'] = 'Dengan pengaturan ini, Anda mengontrol apakah bidang kursus khusus ditampilkan dalam daftar kursus atau tidak.';
$string['courselistinghowgoto'] = 'Tampilkan tombol pergi ke di daftar kursus';
$string['courselistinghowgoto_desc'] = 'Dengan pengaturan ini, Anda dapat mengontrol apakah tombol \'Pergi ke kursus\' akan ditampilkan dalam daftar kursus atau tidak. Jika pengaturan ini dinonaktifkan, pengguna masih dapat membuka kursus dengan mengklik judul kursus atau gambar kursus.';
$string['courselistinghowimage'] = 'Tampilkan gambar kursus di daftar kursus';
$string['courselistinghowimage_desc'] = 'Dengan pengaturan ini, Anda mengontrol apakah gambar kursus ditampilkan dalam daftar kursus atau tidak.';
$string['courselistinghowpopup'] = 'Tampilkan popup detail di daftar kursus';
$string['courselistinghowpopup_desc'] = 'Dengan pengaturan ini, Anda dapat mengontrol apakah tombol \'Rincian kursus\' akan ditampilkan dalam daftar kursus atau tidak. Dengan tombol ini, pengguna dapat membuka jendela pop-up rincian yang berisi ringkasan kursus, kontak kursus, dan kolom kursus. Jendela pop-up akan berisi informasi ini terlepas dari apakah Anda mengaktifkannya pada kartu / baris kursus itu sendiri atau tidak.';
$string['courselistinghowprogress'] = 'Tampilkan kemajuan penyelesaian kursus dalam daftar kursus';
$string['courselistinghowprogress_desc'] = 'Dengan pengaturan ini, Anda mengontrol apakah kemajuan penyelesaian kursus ditampilkan dalam daftar kursus atau tidak.';
$string['courselistinghowshortname'] = 'Tampilkan nama pendek kursus dalam daftar kursus';
$string['courselistinghowshortname_desc'] = 'Dengan pengaturan ini, Anda mengontrol apakah nama pendek kursus ditampilkan dalam daftar kursus atau tidak.';
$string['courselistingnosummary'] = 'Kursus ini tidak memiliki ringkasan';
$string['courselistingpopup'] = 'Rinci';
$string['courselistingpresentation'] = 'Presentasi daftar kursus';
$string['courselistingpresentation_cards'] = 'Kartu kursus';
$string['courselistingpresentation_desc'] = 'Dengan pengaturan ini, Anda dapat mengubah tampilan & nuansa daftar kursus pada halaman indeks kategori dan di beranda situs. Sebagai alternatif dari cara inti Moodle mempresentasikannya, Anda dapat mempresentasikan daftar kursus sebagai kartu kursus (mirip dengan kartu kursus pada halaman \'Kursus saya\') atau sebagai daftar kursus (mirip dengan daftar kursus pada halaman \'Kursus saya\').';
$string['courselistingpresentation_list'] = 'Daftar kursus';
$string['courselistingpresentation_nochange'] = 'Mimpi buruk desainer (tidak berubah seperti yang disajikan oleh inti Moodle)';
$string['courselistingpresentation_note'] = 'Harap diperhatikan: Jika Anda mengaktifkan kartu kursus atau daftar kursus, pengaturan <a href="{$a->url1}">coursesperpage</a> masih berlaku dan akan mengontrol berapa banyak kartu/baris yang akan ditampilkan. Namun, pengaturan <a href="{$a->url2}">courseswithsummarieslimit</a> tidak lagi berpengaruh – semua kursus akan ditampilkan dengan detail lengkap. Harap berhati-hati untuk tidak menetapkan <a href="{$a->url1}">coursesperpage</a> terlalu tinggi untuk menghindari waktu muat halaman yang lama pada halaman dengan banyak kursus.';
$string['courselistingshowcontacts'] = 'Tampilkan kontak kursus dalam daftar kursus';
$string['courselistingshowcontacts_desc'] = 'Dengan pengaturan ini, Anda dapat mengontrol apakah foto kontak kursus ditampilkan dalam daftar kursus atau tidak. Harap diperhatikan: Foto kontak ditampilkan bersama dengan gambar kursus, sehingga tidak mungkin menampilkan kontak kursus tanpa menampilkan gambar kursus.';
$string['courselistingummary'] = 'Ringkasan kursus';
$string['courselistingviewprofile'] = 'Lihat profil';
$string['coursemanagementheading'] = 'Manajemen kursus';
$string['courseoverviewheading'] = 'Blok ikhtisar kursus';
$string['courseoverviewshowcourseimagessetting'] = 'Tampilkan gambar kursus';
$string['courseoverviewshowcourseimagessetting_desc'] = 'Dengan pengaturan ini, Anda dapat mengontrol apakah gambar kursus terlihat di dalam blok ikhtisar kursus atau tidak. Anda dapat memilih pengaturan yang berbeda untuk tampilan Kartu, tampilan Ringkasan, dan tampilan Daftar.';
$string['courseoverviewshowprogresssetting'] = 'Tampilkan kemajuan penyelesaian kursus';
$string['courseoverviewshowprogresssetting_desc'] = 'Dengan pengaturan ini, Anda dapat mengontrol apakah kemajuan penyelesaian kursus terlihat di dalam blok ikhtisar kursus atau tidak.';
$string['coursestab'] = 'Kursus';
$string['coursetab'] = 'Kursus';
$string['cssh5pheading'] = 'CSS Mentah untuk H5P';
$string['cssh5psetting'] = 'CSS Mentah untuk H5P';
$string['cssh5psetting_desc'] = 'Gunakan kolom ini untuk memberikan kode CSS yang akan diterapkan pada penyajian konten H5P oleh mod_h5p dan mod_hvp. Harap periksa jenis konten H5P untuk menemukan pemilih CSS yang diperlukan.';
$string['customfontsfileurlpersistent'] = 'URL (persisten)';
$string['customfontsfileurlrevisioned'] = 'URL (direvisi)';
$string['customfontsheading'] = 'Font kustom';
$string['customfontslistsetting'] = 'Daftar font kustom';
$string['customfontslistsetting_desc'] = 'Ini adalah daftar font yang telah Anda unggah ke area berkas font kustom. Cuplikan CSS yang diberikan dapat digunakan untuk menambahkan font ini ke SCSS kustom Anda. Harap perhatikan bahwa Anda harus mengurus sendiri nilai format font serta properti CSS font-family, font-style, dan font-weight untuk saat ini karena Boost Union belum dapat mengurai berkas font.';
$string['customfontssetting'] = 'Font kustom';
$string['customfontssetting_desc'] = 'Dengan pengaturan ini, Anda dapat mengunggah font kustom ke tema. Keuntungan mengunggah font ke area berkas ini adalah font tersebut dapat dikirimkan tanpa pemeriksaan jika pengguna masuk dan dapat digunakan sebagai font yang terpasang secara lokal di mana saja di situs. Segera setelah Anda mengunggah setidaknya satu font ke area berkas ini dan menyimpan pengaturan, daftar akan muncul di bawahnya yang akan memberi Anda cuplikan kode CSS yang dapat Anda gunakan sebagai boilerplate untuk merujuk font tertentu di SCSS kustom Anda.';
$string['dashboardtab'] = 'Dasbor / Kursus saya';
$string['dontchange'] = 'Jangan mengubah apa pun';
$string['drawerwidthheading'] = 'Lebar laci';
$string['emailbrandinghtmldemobody'] = '<p>Badan surel dimulai di sini.</p><p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.</p><p>Id donec ultrices tincidunt arcu non sodales. Id volutpat lacus laoreet non curabitur gravida arcu.</p><p>Cursus turpis massa tincidunt dui. Pellentesque nec nam aliquam sem et tortor consequat id. In ornare quam viverra orci sagittis eu volutpat. Sem nulla pharetra diam sit amet nisl suscipit. Justo donec enim diam vulputate ut pharetra..</p><p>Badan surel berakhir di sini.</p>';
$string['emailbrandinghtmlheading'] = 'Pratinjau surel HTML';
$string['emailbrandinghtmlintro'] = 'Ini adalah pratinjau surel HTML berdasarkan awalan dan akhiran merek yang saat ini ditetapkan dalam paket bahasa.';
$string['emailbrandinghtmlnopreview'] = 'Hingga saat ini, surel HTML belum disesuaikan dalam fitur ini. Surel akan disusun dan dikirim secara normal.';
$string['emailbrandinginstruction'] = 'Cara-cara';
$string['emailbrandinginstruction0'] = 'Dengan fitur Boost Union ini, Anda dapat menerapkan branding ke semua surel yang dikirim Moodle.';
$string['emailbrandinginstructionli1'] = 'Pergi ke <a href="{$a->url}" target="_blank">halaman pengaturan penyesuaian bahasa</a> untuk membuka paket bahasa <em>{$a->lang}</em> untuk disunting.';
$string['emailbrandinginstructionli2'] = 'Cari dan ubah string berikut dalam paket bahasa <code>theme_boost_union</code>:';
$string['emailbrandinginstructionli2li1'] = '<code>templateemailhtmlprefix</code>: Cuplikan ini akan ditambahkan <em>di awal / sebelum badan</em> semua <em>surel HTML</em> yang dikirim Moodle.';
$string['emailbrandinginstructionli2li2'] = '<code>templateemailhtmlsuffix</code>: Cuplikan ini akan ditambahkan <em>di akhir / setelah badan</em> semua <em>surel HTML</em> yang dikirim Moodle.';
$string['emailbrandinginstructionli2li3'] = '<code>templateemailtextprefix</code>: Cuplikan ini akan ditambahkan <em>di awal / sebelum badan</em> semua <em>surel teks biasa</em> yang dikirim Moodle.';
$string['emailbrandinginstructionli2li4'] = '<code>templateemailtextsuffix</code>: Cuplikan ini akan ditambahkan <em>di akhir / setelah badan</em> semua <em>surel teks biasa</em> yang dikirimkan Moodle.';
$string['emailbrandinginstructionli3'] = 'Simpan perubahan pada paket bahasa.';
$string['emailbrandinginstructionli4'] = 'Kembali ke halaman ini dan lihat pratinjau surel di bawah.';
$string['emailbrandingintroheading'] = 'Pengantar';
$string['emailbrandingintronote'] = 'Harap diperhatikan: Ini adalah fungsi lanjutan yang menggunakan beberapa solusi untuk menyediakan opsi merek surel. Harap ikuti petunjuknya dengan saksama.';
$string['emailbrandingpitfalls'] = 'Kendala';
$string['emailbrandingpitfalls0'] = 'Saat menggunakan fitur ini, ada beberapa kendala yang perlu Anda waspadai:';
$string['emailbrandingpitfallsli1'] = 'Anda wajib mengubah rangkaian paket bahasa <em>bahasa bawaan saat ini</em> di situs ini. Meskipun Anda telah menginstal beberapa paket bahasa, hanya perubahan pada bahasa bawaan yang akan berpengaruh.';
$string['emailbrandingpitfallsli2'] = 'Menghormati bahasa penerima tidaklah mungkin. Oleh karena itu, Anda harus menggunakan istilah yang tidak terikat bahasa dalam cuplikan merek surel Anda.';
$string['emailbrandingpitfallsli3'] = 'Jika Anda mengubah bahasa bawaan situs di masa mendatang, Anda harus memigrasikan string paket bahasa yang dimodifikasi ke paket bahasa bawaan yang baru.';
$string['emailbrandingpitfallsli4'] = 'Dalam surel teks biasa, ada jeda baris dan baris kosong yang ditambahkan secara otomatis setelah awalan dan baris kosong yang ditambahkan secara otomatis sebelum potongan sufiks. Ini untuk memastikan bahwa sufiks dan awalan tidak menempel langsung pada badan surel.';
$string['emailbrandingpitfallsli5'] = 'Dalam surel HTML, awalan dan akhiran ditambahkan langsung sebelum dan di atas badan surel. Hal ini untuk memastikan bahwa Anda dapat bekerja dengan tag HTML dengan mudah, namun Anda harus mengatur sendiri semua spasi di sekitar badan.';
$string['emailbrandingpitfallsli6'] = 'Dalam HTML surel, Anda dapat membuka tag HTML dalam potongan awalan dan menutup tag dalam potongan akhiran tanpa masalah. Ingatlah untuk membuat HTML yang valid dalam surel yang dihasilkan.';
$string['emailbrandingtab'] = 'Merek surel';
$string['emailbrandingtextdemobody'] = 'Badan surel dimulai di sini.

Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.

Id donec ultrices tincidunt arcu non sodales. Id volutpat lacus laoreet non curabitur gravida arcu.

Cursus turpis massa tincidunt dui. Pellentesque nec nam aliquam sem et tortor consequat id. In ornare quam viverra orci sagittis eu volutpat. Sem nulla pharetra diam sit amet nisl suscipit. Justo donec enim diam vulputate ut pharetra.

Badan surel berakhir di sini.';
$string['emailbrandingtextheading'] = 'Pratinjau surel teks biasa';
$string['emailbrandingtextintro'] = 'Ini adalah pratinjau surel teks biasa berdasarkan awalan dan akhiran merek yang saat ini ditetapkan dalam paket bahasa.';
$string['emailbrandingtextnopreview'] = 'Hingga saat ini, surel teks biasa belum disesuaikan dalam fitur ini. Surel akan disusun dan dikirim secara normal.';
$string['enableaboutussetting'] = 'Aktifkan halaman tentang kami';
$string['enableaccessibilitydeclarationsetting'] = 'Aktifkan deklarasi halaman aksesibilitas';
$string['enableaccessibilitydeclarationsetting_desc'] = 'Dengan pengaturan ini, Anda dapat mengaktifkan deklarasi halaman aksesibilitas. Halaman ini akan berperilaku seperti <a href="{$a->url}">halaman statis lainnya</a> di Boost Union.';
$string['enableaccessibilitysupportfooterbuttonsetting'] = 'Aktifkan tombol footer dukungan aksesibilitas';
$string['enableaccessibilitysupportfooterbuttonsetting_desc'] = 'Dengan pengaturan ini, Anda dapat menambahkan tautan ke halaman dukungan aksesibilitas sebagai ikon aksesibilitas mengambang di atas ikon footer (questionmark).';
$string['enableaccessibilitysupportsetting'] = 'Aktifkan halaman dukungan aksesibilitas';
$string['enableaccessibilitysupportsetting_desc'] = 'Dengan pengaturan ini, Anda dapat mengaktifkan halaman dukungan aksesibilitas. Halaman ini akan berperilaku serupa dengan <a href="{$a->url}">halaman dukungan situs inti Moodle</a>.';
$string['enablecontactsetting'] = 'Aktifkan halaman kontak';
$string['enablefooterbutton'] = 'Aktifkan footer';
$string['enablefooterbutton_desc'] = 'Dengan "footer", yang dimaksud adalah lingkaran yang berisi tanda tanya di bagian bawah halaman.<br />Setelah diklik, pengguna akan dipresentasikan dengan overlay. Bergantung pada konfigurasi situs, Moodle menampilkan beberapa tautan (seperti "Dokumentasi untuk halaman ini" atau "Ringkasan penyimpanan data") yang ditampilkan dalam overlay ini.<br />Dengan pengaturan ini, Anda dapat mengontrol apakah akan menampilkan atau menyembunyikan tombol footer di bagian bawah halaman.';
$string['enablefooterbuttonboth'] = 'Aktifkan di desktop, tablet, dan seluler';
$string['enablefooterbuttondesktop'] = 'Aktifkan hanya di desktop dan tablet, sembunyikan di ponsel (tidak berubah seperti yang disajikan oleh inti Moodle)';
$string['enablefooterbuttonhidden'] = 'Sembunyikan di semua perangkat';
$string['enablefooterbuttonmobile'] = 'Aktifkan hanya di ponsel, sembunyikan di desktop dan tablet';
$string['enablehelpsetting'] = 'Aktifkan halaman bantuan';
$string['enableimprintsetting'] = 'Aktifkan jejak';
$string['enablemaintenancesetting'] = 'Aktifkan halaman informasi pemeliharaan';
$string['enableofferssetting'] = 'Aktifkan halaman penawaran';
$string['enablepage1setting'] = 'Aktifkan halaman generik 1';
$string['enablepage2setting'] = 'Aktifkan halaman generik 2';
$string['enablepage3setting'] = 'Aktifkan halaman generik 3';
$string['error:infobannerdismissnonotdismissible'] = 'Spanduk info yang diberikan tidak dapat ditutup';
$string['error:infobannerdismissnonotvalid'] = 'Nomor spanduk info yang diberikan tidak valid';
$string['error:smartmenusmenuitemnotfound'] = 'Item menu pintar tidak ditemukan';
$string['error:smartmenusmenunotfound'] = 'Menu pintar tidak ditemukan';
$string['extscssgithubfilepath_example'] = 'Contoh: Jika Anda dapat melihat berkas di akun Github Anda di https://github.com/moodle-an-hochschulen/moodle-theme_boost_union-extscsstest/blob/main/extscss.scss, jalur berkas akan menjadi <em>/extscss.scss</em>.';
$string['extscssgithubpostfilepath'] = 'Jalur berkas Github Post SCSS Eksternal';
$string['extscssgithubpostfilepath_desc'] = 'Jalur dalam repositori Github pribadi tempat berkas Post SCSS berada.';
$string['extscssgithubprefilepath'] = 'Jalur berkas Github Pra SCSS Eksternal';
$string['extscssgithubprefilepath_desc'] = 'Jalur dalam repositori Github pribadi tempat berkas Pra SCSS berada.';
$string['extscssgithubrepo'] = 'Repositori API Github SCSS Eksternal';
$string['extscssgithubrepo_desc'] = 'Repositori Github pribadi tempat berkas SCSS berada.';
$string['extscssgithubrepo_example'] = 'Contoh: Jika Anda dapat melihat berkas di akun Github Anda di https://github.com/moodle-an-hochschulen/moodle-theme_boost_union-extscsstest/blob/main/extscss.scss, repositorinya adalah <em>moodle-theme_boost_union-extscsstest</em>.';
$string['extscssgithubtoken'] = 'Token API Github SCSS Eksternal';
$string['extscssgithubtoken_desc'] = 'Token API Github yang akan digunakan untuk mengambil kode SCSS dari repositori Github pribadi yang diberikan.';
$string['extscssgithubtoken_docs'] = 'Pergi ke <a href="https://github.com/settings/tokens">pengaturan token Github Anda</a> untuk membuat token API dan melihat dokumentasi resmi.';
$string['extscssgithubuser'] = 'Pengguna API Github SCSS Eksternal';
$string['extscssgithubuser_desc'] = 'Pengguna API Github atau organisasi yang memiliki repositori Github pribadi.';
$string['extscssgithubuser_example'] = 'Contoh: Jika Anda dapat melihat berkas di akun Github Anda di https://github.com/moodle-an-hochschulen/moodle-theme_boost_union-extscsstest/blob/main/extscss.scss, pengguna akan menjadi <em>moodle-an-hochschulen</em>.';
$string['extscssheading'] = 'SCSS Eksternal';
$string['extscssheading_desc'] = 'Selain pengaturan SCSS mentah di atas, Boost Union dapat memuat SCSS dari sumber eksternal. Ia disertakan sebelum kode SCSS yang didefinisikan di atas yang berarti Anda dapat mengelola basis kode SCSS eksternal yang terpusat dan masih dapat mengubahnya dengan penambahan SCSS lokal.';
$string['extscssheading_drop'] = 'Jika Boost Union tidak dapat mengambil berkas SCSS eksternal karena alasan apa pun, ia akan mengabaikan berkas SCSS eksternal tersebut untuk menghindari masalah pada kompilasi SCSS dan kerusakan pada frontend.';
$string['extscssheading_instr'] = 'Instruksi:';
$string['extscssheading_prepost'] = 'Sama seperti pengaturan SCSS mentah di atas, SCSS eksternal dibagi menjadi dua bagian: Pre dan Post SCSS. Pre SCSS dapat digunakan untuk menginisialisasi variabel SCSS, Post SCSS digunakan untuk kode SCSS Anda yang sebenarnya.';
$string['extscssheading_sources'] = 'Anda dapat mengonfigurasi Boost Union untuk mengambil berkas SCSS eksternal baik dari URL unduhan publik (yang akan diakses dan diambil dengan permintaan cURL yang tidak diautentikasi) atau dari repositori Github pribadi (yang akan diakses dan diambil dengan token API Github).';
$string['extscssheading_structure'] = 'SCSS eksternal harus disediakan sebagai file teks biasa, tanpa header atau footer, dan hanya berisi kode SCSS.';
$string['extscssheading_task'] = 'Ada <a href="{$a}">tema tugas terjadwal theme_boost_union\\task\\purge_cache</a> yang dinonaktifkan secara bawaan tetapi dapat Anda aktifkan jika Anda ingin Boost Union mengambil dan mengompilasi kode SCSS eksternal secara berkala.';
$string['extscsssource'] = 'Sumber SCSS eksternal';
$string['extscsssource_desc'] = 'Pilih jenis sumber dari mana Anda ingin mengambil SCSS eksternal.';
$string['extscsssourcedownload'] = 'URL unduhan publik';
$string['extscsssourcegithub'] = 'Repositori Github pribadi';
$string['extscsssourcenone'] = 'Tidak ada';
$string['extscssurlpost'] = 'URL unduhan Post SCSS Eksternal';
$string['extscssurlpost_desc'] = 'URL unduhan publik tempat Post SCSS eksternal akan diambil.';
$string['extscssurlpre'] = 'URL unduhan Pra SCSS Eksternal';
$string['extscssurlpre_desc'] = 'URL unduhan publik tempat Pra SCSS Eksternal harus diambil.';
$string['extscssvalidationsetting'] = 'Validasi SCSS eksternal';
$string['extscssvalidationsetting_desc'] = 'Jika pengaturan ini diaktifkan, SCSS eksternal divalidasi jika dapat dikompilasi sebelum ditambahkan ke tumpukan SCSS. Kode SCSS eksternal yang tidak dapat dikompilasi diabaikan dan tidak digunakan. Namun, validasi ini hanya dijalankan pada kode SCSS eksternal saja, tidak dijalankan pada tumpukan SCSS gabungan yang merupakan hasil integrasi SCSS eksternal. Ini berarti bahwa, segera setelah Anda menggunakan variabel SCSS dari inti Moodle atau Bootstrap di SCSS eksternal Anda, Anda harus menonaktifkan validasi dan memverifikasi sendiri bahwa kode SCSS valid untuk menghindari frontend yang rusak.';
$string['faviconheading'] = 'Favicon';
$string['faviconheading_desc'] = 'Harap diperhatikan: Boost Union memiliki unggahan faviconnya sendiri dan tidak menggunakan favicon dari <a href="{$a}">pengaturan favicon inti Moodle</a>.<br />Boost Union secara khusus memungkinkan Anda untuk mengganti favicon yang diunggah dalam variasinya.';
$string['faviconsetting'] = 'Favicon';
$string['faviconsetting_desc'] = 'Di sini, Anda dapat mengunggah gambar kustom (format .ico atau .png) yang akan ditampilkan oleh peramban sebagai favicon situs web Moodle Anda. Jika tidak ada favicon kustom yang diunggah, favicon Moodle standar akan digunakan.';
$string['flavoursactivityiconcoloradministration'] = 'Warna ikon aktivitas untuk "Administrasi"';
$string['flavoursactivityiconcoloradministration_help'] = 'Dengan pengaturan ini, flavor akan menggantikan warna ikon aktivitas "Administrasi" yang dikonfigurasi dalam pengaturan tampilan Boost Union.';
$string['flavoursactivityiconcolorassessment'] = 'Warna ikon aktivitas untuk "Penilaian"';
$string['flavoursactivityiconcolorassessment_help'] = 'Dengan pengaturan ini, flavor akan menggantikan warna ikon aktivitas "Penilaian" yang dikonfigurasi dalam pengaturan tampilan Boost Union.';
$string['flavoursactivityiconcolorcollaboration'] = 'Warna ikon aktivitas untuk "Kolaborasi"';
$string['flavoursactivityiconcolorcollaboration_help'] = 'Dengan pengaturan ini, flavor akan menggantikan warna ikon aktivitas "Kolaborasi" yang dikonfigurasikan dalam pengaturan tampilan Boost Union.';
$string['flavoursactivityiconcolorcommunication'] = 'Warna ikon aktivitas untuk "Komunikasi"';
$string['flavoursactivityiconcolorcommunication_help'] = 'Dengan pengaturan ini, flavor akan menggantikan warna ikon aktivitas "Komunikasi" yang dikonfigurasi dalam pengaturan tampilan Boost Union.';
$string['flavoursactivityiconcolorcontent'] = 'Warna ikon aktivitas untuk "Konten"';
$string['flavoursactivityiconcolorcontent_help'] = 'Dengan pengaturan ini, flavor akan menggantikan warna ikon aktivitas "Konten" yang dikonfigurasi dalam pengaturan tampilan Boost Union.';
$string['flavoursactivityiconcolorinteractivecontent'] = 'Warna ikon aktivitas untuk "Konten interaktif"';
$string['flavoursactivityiconcolorinteractivecontent_help'] = 'Dengan pengaturan ini, flavor akan menggantikan warna ikon aktivitas "Konten interaktif" yang dikonfigurasi dalam pengaturan tampilan Boost Union.';
$string['flavoursactivityiconcolorinterface'] = 'Warna ikon aktivitas untuk "Antarmuka"';
$string['flavoursactivityiconcolorinterface_help'] = 'Dengan pengaturan ini, flavor akan menggantikan warna "Antarmuka" ikon aktivitas yang dikonfigurasikan dalam pengaturan tampilan Boost Union.';
$string['flavoursappliesto'] = 'Terapkan ke';
$string['flavoursapplytocategories'] = 'Terapkan ke kategori kursus';
$string['flavoursapplytocategories_help'] = 'Di sini, Anda menentukan apakah flavor ini harus diterapkan ke kategori kursus.';
$string['flavoursapplytocategories_ids'] = 'Kategori kursus';
$string['flavoursapplytocategories_ids_help'] = 'Di sini, Anda menentukan satu atau beberapa kategori kursus tertentu yang akan diterapkan pada flavor ini. Begitu halaman Moodle yang ditampilkan berada dalam salah satu kategori kursus yang dikonfigurasi, flavor akan diterapkan.';
$string['flavoursapplytocohorts'] = 'Terapkan ke kohor';
$string['flavoursapplytocohorts_help'] = 'Di sini, Anda menentukan apakah varian ini harus diterapkan ke kohor.';
$string['flavoursapplytocohorts_ids'] = 'Kohor';
$string['flavoursapplytocohorts_ids_help'] = 'Di sini, Anda menentukan satu atau beberapa kohor tertentu yang akan diterapkan pada flavor ini. Begitu pengguna menjadi anggota salah satu kohor yang dikonfigurasi, flavor tersebut akan diterapkan.<br /><br />Harap perhatikan bahwa, jika Anda menentukan lebih dari satu kohor, pengguna tidak perlu menjadi anggota semuanya pada saat yang sama.<br /><br />Harap perhatikan juga bahwa pada status implementasi saat ini, kohor kategori diperlakukan sama seperti kohor sistem.';
$string['flavoursbackgroundimage'] = 'Gambar latar belakang';
$string['flavoursbackgroundimage_help'] = 'Dengan pengaturan ini, flavor akan mengesampingkan gambar latar belakang yang dikonfigurasikan dalam pengaturan tampilan Boost Union.';
$string['flavoursbackgroundimageposition'] = 'Posisi gambar latar belakang';
$string['flavoursbackgroundimageposition_help'] = 'Dengan pengaturan ini, flavor akan mengesampingkan posisi gambar latar belakang yang dikonfigurasikan dalam pengaturan tampilan Boost Union.';
$string['flavoursbacktooverview'] = 'Kembali ke ikhtisar flavor';
$string['flavoursbootstrapcolordanger'] = 'Warna bootstrap untuk "Danger"';
$string['flavoursbootstrapcolordanger_help'] = 'Dengan pengaturan ini, flavor akan mengesampingkan warna "danger" Bootstrap yang dikonfigurasi dalam pengaturan tampilan Boost Union.';
$string['flavoursbootstrapcolorinfo'] = 'Warna bootstrap untuk "Info"';
$string['flavoursbootstrapcolorinfo_help'] = 'Dengan pengaturan ini, flavor akan mengesampingkan "color" info Bootstrap yang dikonfigurasi dalam pengaturan tampilan Boost Union.';
$string['flavoursbootstrapcolorsuccess'] = 'Warna bootstrap untuk "Success"';
$string['flavoursbootstrapcolorsuccess_help'] = 'Dengan pengaturan ini, flavor akan menggantikan warna "success" Bootstrap yang dikonfigurasikan dalam pengaturan tampilan Boost Union.';
$string['flavoursbootstrapcolorwarning'] = 'Warna bootstrap untuk "Warning"';
$string['flavoursbootstrapcolorwarning_help'] = 'Dengan pengaturan ini, flavor akan mengesampingkan warna "warning" Bootstrap yang dikonfigurasi dalam pengaturan tampilan Boost Union.';
$string['flavoursbrandcolor'] = 'Warna merek';
$string['flavoursbrandcolor_help'] = 'Dengan pengaturan ini, flavor akan menggantikan warna merek yang dikonfigurasikan dalam pengaturan tampilan Boost Union.';
$string['flavourscreateflavour'] = 'Buat flavor';
$string['flavourscustomscss'] = 'SCSS mentah';
$string['flavourscustomscss_help'] = 'Dengan pengaturan ini, Anda dapat menulis SCSS khusus untuk flavor tersebut. SCSS akan ditambahkan ke tumpukan kode CSS yang dikirimkan ke peramban segera setelah flavor diterapkan.';
$string['flavourscustomscsspre'] = 'SCSS awal mentah';
$string['flavourscustomscsspre_help'] = 'Dengan pengaturan ini, Anda dapat menulis SCSS awal khusus untuk flavor tersebut. SCSS ini akan digunakan saat membuat kode CSS yang dikirimkan ke peramban segera setelah flavor diterapkan.';
$string['flavoursdelete'] = 'Hapus';
$string['flavoursdeleteconfirmation'] = 'Apakah Anda benar-benar ingin hapus flavor <em>{$a}</em>?';
$string['flavoursdeleteflavour'] = 'Hapus flavor';
$string['flavoursdescription'] = 'Deskripsi';
$string['flavoursdescription_help'] = 'Deskripsi flavor hanya digunakan secara internal untuk memungkinkan Anda mengidentifikasi flavor tertentu dalam daftar flavor.';
$string['flavoursedit'] = 'Sunting';
$string['flavourseditflavour'] = 'Sunting flavor';
$string['flavoursfavicon'] = 'Favicon';
$string['flavoursfavicon_help'] = 'Dengan pengaturan ini, flavor akan menggantikan favicon yang dikonfigurasikan dalam pengaturan tampilan Boost Union.';
$string['flavoursflavours'] = 'Flavor';
$string['flavoursgeneralsettings'] = 'Pengaturan umum';
$string['flavoursincludesubcategories'] = 'Sertakan subkategori';
$string['flavoursincludesubcategories_help'] = 'Jika dicentang, flavor juga akan diterapkan ke subkategori dari kategori yang dipilih.';
$string['flavourslogo'] = 'Logo';
$string['flavourslogo_help'] = 'Dengan pengaturan ini, flavor akan menggantikan logo yang dikonfigurasikan dalam pengaturan tampilan Boost Union.';
$string['flavourslogocompact'] = 'Logo kompak';
$string['flavourslogocompact_help'] = 'Dengan pengaturan ini, flavor akan menggantikan logo yang dikonfigurasikan dalam pengaturan tampilan Boost Union.';
$string['flavoursnavbarcolor'] = 'Warna navbar';
$string['flavoursnavbarcolor_help'] = 'Dengan pengaturan ini, flavor akan menggantikan warna navbar yang dikonfigurasikan dalam pengaturan tampilan Boost Union.';
$string['flavoursnothingtodisplay'] = 'Belum ada flavor yang dibuat. Silakan buat flavor pertama Anda untuk memulai.';
$string['flavoursnotificationcreated'] = 'Flavor telah berhasil dibuat';
$string['flavoursnotificationdeleted'] = 'Flavor telah berhasil dihapus';
$string['flavoursnotificationedited'] = 'Flavor telah berhasil disunting';
$string['flavoursoverview_desc'] = '<p>Flavor Boost Union menawarkan kemungkinan untuk mengganti pengaturan tampilan & nuansa Moodle tertentu dalam konteks tertentu. Di halaman ini, Anda dapat membuat dan mengelola flavor.</p><p>Dalam setiap flavor, Anda menentukan apakah flavor tersebut harus diterapkan pada kategori kursus tertentu atau kelompok tertentu. Setelah itu, selama setiap perenderan halaman Moodle, Boost Union memeriksa apakah ada flavor yang berlaku. Harap perhatikan bahwa, untuk setiap perenderan halaman Moodle, hanya flavor pertama yang cocok dalam daftar yang diterapkan dan flavor yang tersisa diabaikan. Jadi, urutan flavor pada halaman ini adalah kuncinya.</p><p>Harap perhatikan juga bahwa setelah setiap perubahan yang Anda buat pada rangkaian flavor, cache tema akan dihapus. Ini diperlukan untuk memastikan bahwa semua aset dikirimkan dengan benar dan terkini ke peramban.</p>';
$string['flavourspreview'] = 'Pratinjau';
$string['flavourspreviewblindtext'] = 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Nunc id cursus metus aliquam eleifend mi in nulla. Felis imperdiet proin fermentum leo vel orci porta. Sed nisi lacus sed viverra tellus in hac habitasse. Vivamus arcu felis bibendum ut. Nisi porta lorem mollis aliquam ut porttitor. Odio euismod lacinia at quis risus sed vulputate odio. Sed felis eget velit aliquet sagittis id consectetur purus. Nec ullamcorper sit amet risus nullam eget. Pellentesque sit amet porttitor eget dolor. Cursus mattis molestie a iaculis at erat pellentesque.';
$string['flavourspreviewflavour'] = 'Pratinjau flavor';
$string['flavourstitle'] = 'Judul';
$string['flavourstitle_help'] = 'Judul flavor hanya digunakan secara internal untuk memungkinkan Anda mendokumentasikan flavor tertentu dalam daftar flavor.';
$string['footerheading'] = 'Footer';
$string['footersuppresschatsetting'] = 'Hapus tautan \'Obrolan dengan peserta kursus\'';
$string['footersuppresschatsetting_desc'] = 'Dengan pengaturan ini, Anda dapat sepenuhnya menghapus tautan \'Obrolan dengan peserta kursus\' di footer. Tautan ini akan muncul di dalam kursus segera setelah ruang komunikasi ditambahkan di pengaturan kursus.';
$string['footersuppresscontactsetting'] = 'Hapus tautan \'Hubungi dukungan situs\'';
$string['footersuppresscontactsetting_desc'] = 'Dengan pengaturan ini, Anda dapat sepenuhnya menghapus tautan \'Hubungi dukungan situs\' di footer. Tautan ini akan muncul jika <a href="{$a->url}">tautan Hubungi dukungan situs</a> diatur.';
$string['footersuppresshelpsetting'] = 'Hapus tautan \'Dokumentasi untuk halaman ini\'';
$string['footersuppresshelpsetting_desc'] = 'Dengan pengaturan ini, Anda dapat sepenuhnya menghapus tautan \'Dokumentasi untuk halaman ini\' di footer. Tautan ini akan muncul jika <a href="{$a->url}">akar dokumen Moodle Docs</a> ditetapkan.';
$string['footersuppressiconssetting'] = 'Hapus ikon di depan tautan footer';
$string['footersuppressiconssetting_desc'] = 'Dengan pengaturan ini, Anda dapat sepenuhnya menghilangkan ikon di depan tautan footer. \'Dokumentasi untuk halaman ini\' memiliki ikon buku, \'Layanan dan dukungan\' memiliki ikon lingkaran kehidupan, dsb.';
$string['footersuppresslogininfosetting'] = 'Hapus info login';
$string['footersuppresslogininfosetting_desc'] = 'Dengan pengaturan ini, Anda dapat sepenuhnya menyembunyikan info login di footer. Info ini akan menampilkan tautan ke profil pengguna dan ke halaman logout.';
$string['footersuppresspoweredsetting'] = 'Hapus tautan \'Didukung oleh Moodle\'';
$string['footersuppresspoweredsetting_desc'] = 'Dengan pengaturan ini, Anda dapat sepenuhnya menghilangkan tautan \'Didukung oleh Moodle\' di footer. Tautan ini akan menampilkan informasi bahwa situs ini menjalankan Moodle dan menyediakan tautan ke Moodle HQ.';
$string['footersuppressservicessetting'] = 'Tekan tautan \'Layanan dan dukungan\'';
$string['footersuppressservicessetting_desc'] = 'Dengan pengaturan ini, Anda dapat sepenuhnya menghapus tautan \'Layanan dan dukungan\' di footer. Tautan ini akan menampilkan <a href="{$a->url}">tautan Layanan dan dukungan</a> kepada administrator.';
$string['footersuppressstandardfooter'] = 'Tekan keluaran footer dengan pengaya \'{$a}\'';
$string['footersuppressstandardfooter_desc'] = 'Dengan pengaturan ini, Anda dapat sepenuhnya menekan output footer dengan pengaya \'{$a}\'. Pengaya (meskipun disertakan dengan inti Moodle, tetapi secara teknis masih merupakan pengaya) dapat menambahkan konten tambahan ke footer dengan menerapkan hook atau fungsi tertentu. Pengaya ini telah menerapkan hook/fungsi ini dan dapat menambahkan konten ke footer dalam keadaan tertentu.<br />Harap diperhatikan: Karena cara penerapan fitur penekanan, pengaturan mungkin tidak berlaku sebelum halaman kedua dimuat setelah menyimpan pengaturan.';
$string['footersuppressstandardfootercore'] = 'Hapus keluaran footer oleh komponen inti \'{$a}\'';
$string['footersuppressstandardfootercore_desc'] = 'Dengan pengaturan ini, Anda dapat sepenuhnya menghapus output footer oleh komponen inti \'{$a}\'. Komponen inti dapat menambahkan konten tambahan ke footer dengan menerapkan hook atau fungsi tertentu. Komponen inti ini telah menerapkan hook/fungsi ini dan dapat menambahkan konten ke footer dalam keadaan tertentu.';
$string['footersuppressthemeswitchsetting'] = 'Hapus tautan pengalih tema';
$string['footersuppressthemeswitchsetting_desc'] = 'Dengan pengaturan ini, Anda dapat sepenuhnya menghapus tautan pengalih tema di bagian bawah. Sistem dasar untuk tema khusus perangkat telah dihapus di Moodle 4.3, tetapi rutinitas keluaran masih ada, jadi lebih baik aman daripada menyesal.';
$string['footersuppressusertoursetting'] = 'Hapus tautan \'Atur ulang tur pengguna di halaman ini\'';
$string['footersuppressusertoursetting_desc'] = 'Dengan pengaturan ini, Anda dapat sepenuhnya menghapus tautan \'Atur ulang tur pengguna di halaman ini\' di bagian bawah. Tautan ini akan memberikan kemungkinan untuk mengatur ulang tur pengguna di halaman tertentu.';
$string['footertab'] = 'Footer';
$string['footnoteheading'] = 'Catatan kaki';
$string['footnotesetting'] = 'Catatan kaki';
$string['footnotesetting_desc'] = 'Apa pun yang Anda tambahkan ke area teks ini akan ditampilkan di akhir halaman, di footer (bukan footer mengambang) di setiap halaman yang menggunakan tata letak "drawers", "columns2" atau "login". Konten di area ini dapat berupa hak cipta, ketentuan penggunaan, atau nama organisasi Anda. <br/> Jika Anda ingin menghapus catatan kaki lagi, cukup kosongkan area teks.';
$string['forguestsonly'] = 'Hanya untuk tamu dan pengguna yang tidak login';
$string['githubissueslink'] = '<a href="https://github.com/moodle-an-hochschulen/moodle-theme_boost_union/issues">Masalah Github</a>';
$string['h5pcontentmaxwidthsetting'] = 'Lebar maksimum bank konten H5P';
$string['h5pcontentmaxwidthsetting_desc'] = 'Dengan pengaturan ini, Anda dapat menimpa lebar bank konten H5P Moodle tanpa modifikasi SCSS manual. Lebar ini digunakan untuk editor H5P dalam bank konten. Lebar ini <em>tidak</em> digunakan untuk lebar aktivitas H5P. Secara bawaan, Moodle menggunakan lebar maksimum bank konten H5P sebesar 960 piksel. Anda dapat memasukkan nilai berbasis piksel lainnya seperti 1200 piksel, tetapi Anda juga dapat memasukkan nilai berbasis persentase seperti 100% atau nilai lebar viewport seperti 90vw.';
$string['h5ptab'] = 'H5P';
$string['helpcontentsetting'] = 'Konten halaman bantuan';
$string['helpcontentsetting_desc'] = 'Dalam pengaturan ini, Anda dapat menambahkan konten rich text yang akan ditampilkan di halaman bantuan.';
$string['helpdisabled'] = 'Halaman bantuan dinonaktifkan untuk situs ini. Tidak ada yang bisa dilihat di sini.';
$string['helpheading'] = 'Bantuan';
$string['helplinkpositionboth'] = 'Tambahkan tautan ke halaman bantuan ke catatan kaki dan ke ikon footer (questionmark)';
$string['helplinkpositionfooter'] = 'Tambahkan tautan ke halaman bantuan ke ikon footer (questionmark)';
$string['helplinkpositionfootnote'] = 'Tambahkan tautan ke halaman bantuan ke catatan kaki';
$string['helplinkpositionnone'] = 'Jangan secara otomatis menampilkan tautan ke halaman bantuan';
$string['helplinkpositionsetting'] = 'Posisi tautan halaman bantuan';
$string['helplinkpositionsetting_desc'] = 'Dalam pengaturan ini, Anda dapat mengonfigurasi apakah tautan ke halaman bantuan harus ditambahkan secara otomatis ke halaman Moodle. Jika Anda tidak ingin menampilkan tautan secara otomatis, Anda dapat menambahkan tautan ke {$a->url} dari mana saja di Moodle secara manual.';
$string['helppagetitledefault'] = 'Bantuan';
$string['helppagetitlesetting'] = 'Judul halaman bantuan';
$string['helppagetitlesetting_desc'] = 'Dalam pengaturan ini, Anda dapat menentukan judul halaman bantuan. Teks ini juga akan digunakan sebagai teks tautan ke halaman bantuan jika Anda mengonfigurasi \'Posisi tautan halaman bantuan\' sebagaimana mestinya.';
$string['hidenodesprimarynavigationsetting'] = 'Sembunyikan node di navigasi utama';
$string['hidenodesprimarynavigationsetting_desc'] = 'Dengan pengaturan ini, Anda dapat menyembunyikan satu atau beberapa node dari navigasi utama.<br /><br />
Harap diperhatikan: Di sini, Anda dapat menghapus node navigasi saja. Namun, jika Anda ingin menambahkan node navigasi khusus, harap pertimbangkan untuk menggunakan <a href="{$a->url}">fungsionalitas menu pintar Boost Union</a>.';
$string['imprintcontentsetting'] = 'Konten cetakan';
$string['imprintcontentsetting_desc'] = 'Dalam pengaturan ini, Anda dapat menambahkan konten rich text yang akan ditampilkan pada halaman cetakan.';
$string['imprintdisabled'] = 'Halaman cetakan dinonaktifkan untuk situs ini. Tidak ada yang bisa dilihat di sini.';
$string['imprintheading'] = 'Cetakan';
$string['imprintlinkpositionboth'] = 'Tambahkan tautan ke halaman cetakan ke catatan kaki dan ke ikon footer (questionmark)';
$string['imprintlinkpositionfooter'] = 'Tambahkan tautan ke halaman cetakan ke ikon footer (questionmark)';
$string['imprintlinkpositionfootnote'] = 'Tambahkan tautan ke halaman cetakan ke catatan kaki';
$string['imprintlinkpositionnone'] = 'Jangan secara otomatis menampilkan tautan ke halaman cetakan';
$string['imprintlinkpositionsetting'] = 'Posisi tautan cetakan';
$string['imprintlinkpositionsetting_desc'] = 'Dalam pengaturan ini, Anda dapat mengonfigurasi apakah tautan ke halaman cetakan harus ditambahkan secara otomatis ke halaman Moodle. Jika Anda tidak ingin menampilkan tautan secara otomatis, Anda dapat menambahkan tautan ke {$a->url} dari mana saja di Moodle secara manual.';
$string['imprintpagetitledefault'] = 'Cetakan';
$string['imprintpagetitlesetting'] = 'Judul halaman cetakan';
$string['imprintpagetitlesetting_desc'] = 'Dalam pengaturan ini, Anda dapat menentukan judul halaman cetakan. Teks ini akan digunakan sebagai teks tautan ke halaman cetakan juga jika Anda mengonfigurasi \'Posisi tautan cetakan\' sebagaimana mestinya.';
$string['infobannerbsclasssetting'] = 'Spanduk info {$a->no} kelas Bootstrap';
$string['infobannerbsclasssetting_desc'] = 'Dengan pengaturan ini, Anda dapat memilih gaya Bootstrap yang akan digunakan untuk menampilkan spanduk info {$a->no}. Jika Anda memilih opsi \'Tanpa warna Bootstrap\', spanduk info akan ditampilkan tanpa warna Bootstrap tertentu yang memberi Anda kebebasan untuk memberi gaya pada spanduk sendiri di dalam penyunting rich-text.';
$string['infobannerclose'] = 'Tutup';
$string['infobannercontentsetting'] = 'Spanduk info {$a->no} konten';
$string['infobannercontentsetting_desc'] = 'Di sini, Anda memasukkan informasi yang seharusnya ditampilkan dalam spanduk info {$a->no}.';
$string['infobannerdismissconfirm'] = 'Apakah Anda benar-benar ingin mengatur ulang visibilitas spanduk info {$a->no} dan ingin menampilkannya lagi kepada semua pengguna yang telah menutupnya?';
$string['infobannerdismissfail'] = 'Pengaturan ulang visibilitas spanduk info {$a->no} telah gagal untuk setidaknya satu pengguna';
$string['infobannerdismissiblesetting'] = 'Spanduk info {$a->no} dapat ditutup';
$string['infobannerdismissiblesetting_desc'] = 'Dengan pengaturan ini, Anda dapat membuat info spanduk {$a->no} dapat ditutup. Jika pengguna mengklik tombol x di info spanduk, spanduk akan disembunyikan untuk pengguna ini secara permanen. Visibilitas tidak akan diatur ulang secara otomatis, meskipun Anda mengubah konten info spanduk. Jika Anda ingin mengatur ulang visibilitas info spanduk, klik tombol \'Atur ulang visibilitas\' di bawah.';
$string['infobannerdismissreset'] = 'Atur ulang visibilitas spanduk info yang ditutup';
$string['infobannerdismissresetbutton'] = 'Atur ulang visibilitas spanduk info {$a->no}';
$string['infobannerdismisssuccess'] = 'Visibilitas info spanduk {$a->no} telah diatur ulang';
$string['infobannerenabledsetting'] = 'Aktifkan spanduk info {$a->no}';
$string['infobannerenabledsetting_desc'] = 'Dengan pengaturan ini, Anda dapat mengaktifkan spanduk info {$a->no}.';
$string['infobannerendsetting'] = 'Spanduk info {$a->no} waktu berakhir';
$string['infobannerendsetting_desc'] = 'Dengan pengaturan ini, Anda dapat menentukan hingga kapan info spanduk {$a->no} akan ditampilkan. Waktu yang dikonfigurasi ditafsirkan sebagai waktu server, bukan waktu pengguna.';
$string['infobannerheading'] = 'Spanduk info {$a->no}';
$string['infobannermodeperpetual'] = 'Abadi';
$string['infobannermodesetting'] = 'Mode tampilan spanduk info {$a->no}';
$string['infobannermodesetting_desc'] = 'Dengan pengaturan ini, Anda dapat menentukan apakah info spanduk {$a->no} harus berupa spanduk abadi (yang selalu ditampilkan) atau spanduk yang dikontrol waktu (yang hanya ditampilkan dalam interval waktu yang dikonfigurasi)';
$string['infobannermodetimebased'] = 'Waktu terkendali';
$string['infobannerordersetting'] = 'Spanduk info {$a->no} posisi pesanan';
$string['infobannerordersetting_desc'] = 'Dengan pengaturan ini, Anda menentukan posisi pesanan spanduk info {$a->no}. Secara bawaan, spanduk info diurutkan dari atas ke bawah seperti yang Anda lihat di halaman pengaturan ini. Namun, Anda dapat memutuskan untuk menugaskan posisi pesanan lain dengan pengaturan ini. Jika Anda menugaskan posisi pesanan yang sama ke dua atau lebih spanduk informasi, spanduk tersebut akan diurutkan lagi sesuai dengan urutan di halaman pengaturan ini.';
$string['infobannerpageloginpage'] = 'Halaman login';
$string['infobannerpagessetting'] = 'Tata letak halaman untuk menampilkan info spanduk {$a->no} pada';
$string['infobannerpagessetting_desc'] = 'Dengan pengaturan ini, Anda dapat memilih tata letak halaman di mana spanduk info {$a->no} akan ditampilkan.';
$string['infobannerstartsetting'] = 'Spanduk info {$a->no} waktu mulai';
$string['infobannerstartsetting_desc'] = 'Dengan pengaturan ini, Anda dapat menentukan kapan info spanduk {$a->no} akan ditampilkan. Waktu yang dikonfigurasi ditafsirkan sebagai waktu server, bukan waktu pengguna.';
$string['infobannertab'] = 'Spanduk info';
$string['invalidurl'] = 'URL yang diberikan tidak valid';
$string['javascriptdisabledhint'] = 'Petunjuk JavaScript dinonaktifkan';
$string['javascriptdisabledhint_desc'] = 'Dengan pengaturan ini, petunjuk akan muncul di bagian atas halaman Moodle jika JavaScript tidak diaktifkan. Ini sangat membantu karena beberapa fitur Moodle tidak berfungsi tanpa JavaScript.';
$string['javascriptdisabledhinttext'] = 'JavaScript dinonaktifkan di peramban Anda.<br />Banyak fitur Moodle tidak dapat digunakan atau tampak rusak.<br />Harap aktifkan JavaScript untuk pengalaman Moodle sepenuhnya.';
$string['javascriptheading'] = 'JavaScript';
$string['linkstab'] = 'Tautan';
$string['loginbackgroundimage'] = 'Gambar latar belakang halaman login';
$string['loginbackgroundimage_desc'] = 'Gambar yang akan ditampilkan sebagai latar belakang halaman login. Salah satu gambar ini akan dipilih secara acak dan ditampilkan saat pengguna mengunjungi halaman login. Pastikan untuk tidak menggunakan karakter non-ASCII dalam nama berkas jika Anda ingin menampilkan teks untuk gambar latar login.';
$string['loginbackgroundimagepositionsetting'] = 'Posisi gambar latar belakang halaman login';
$string['loginbackgroundimagepositionsetting_desc'] = 'Dengan pengaturan ini, Anda mengendalikan posisi gambar latar halaman login di dalam jendela peramban. Nilai pertama adalah posisi horizontal, nilai kedua adalah posisi vertikal.';
$string['loginbackgroundimagesheading'] = 'Gambar latar belakang halaman login';
$string['loginbackgroundimagetextsetting'] = 'Tampilkan teks untuk gambar latar belakang login';
$string['loginbackgroundimagetextsetting_desc'] = 'Dengan pengaturan opsional ini, Anda dapat menambahkan teks, misalnya, pemberitahuan hak cipta pada gambar latar yang Anda unggah. Teks ini akan muncul di bagian atas footer halaman pada halaman login. Namun, karena alasan tampilan layar, teks ini hanya ditampilkan pada ukuran layar yang lebih besar.<br/>
Setiap baris terdiri dari pengenal berkas (nama berkas), teks yang harus ditampilkan, dan warna teks, dipisahkan oleh karakter pipa. Setiap deklarasi perlu ditulis dalam baris baru. <br/>
Misalnya:<br/>
background-image-1.jpg|Hak Cipta: CC0|gelap<br/>
Sebagai warna teks, Anda dapat menggunakan nilai "gelap" atau "terang".<br />
Anda dapat mendeklarasikan teks untuk jumlah gambar latar login yang Anda unggah yang tidak terbatas. Teks hanya akan ditambahkan ke gambar yang sesuai dengan nama berkasnya dengan pengenal yang dideklarasikan dalam pengaturan ini.';
$string['loginformheading'] = 'Formulir login';
$string['loginformpositionsetting'] = 'Posisi formulir login';
$string['loginformpositionsetting_center'] = 'Tengah';
$string['loginformpositionsetting_desc'] = 'Dengan pengaturan ini, Anda dapat mengoptimalkan formulir login agar sesuai dengan berbagai macam gambar latar belakang. Secara bawaan, formulir login ditampilkan di tengah halaman login. Atau, Anda dapat memindahkannya ke kiri atau kanan halaman login agar bagian lain dari gambar latar belakang terlihat. Tentu saja, Anda juga dapat mengubah pengaturan ini jika tidak ada gambar latar belakang yang diunggah sama sekali.';
$string['loginformpositionsetting_left'] = 'Rata kiri';
$string['loginformpositionsetting_right'] = 'Rata kanan';
$string['loginformtransparencysetting'] = 'Transparansi formulir login';
$string['loginformtransparencysetting_desc'] = 'Dengan pengaturan ini, Anda dapat membuat formulir login sedikit transparan agar gambar latar belakang lebih menonjol.';
$string['loginidpshowintrosetting'] = 'Intro login IDP';
$string['loginidpshowintrosetting_desc'] = 'Dengan pengaturan ini, Anda dapat mengontrol apakah intro <em>\'{$a}\'</em> ditampilkan di atas tombol login IDP atau tidak. Secara bawaan, intro ditampilkan dan pengguna akan segera diberi tahu tentang tombol IDP tersebut. Jika Anda menonaktifkan pengaturan ini, intro IDP akan disembunyikan. Hal ini memungkinkan Anda untuk menyediakan antarmuka login pengguna yang bersih jika Anda hanya menggunakan penyedia identitas eksternal seperti OAuth2 atau OIDC.';
$string['loginlocalintro'] = 'Login dengan akun Moodle Anda';
$string['loginlocalloginenablesetting'] = 'Login lokal';
$string['loginlocalloginenablesetting_desc'] = 'Dengan pengaturan ini, Anda dapat mengontrol apakah formulir login lokal ditampilkan di halaman login atau tidak. Secara bawaan, formulir login lokal ditampilkan dan pengguna dapat login ke situs seperti biasa. Jika Anda menonaktifkan pengaturan ini, formulir login lokal akan disembunyikan. Ini memungkinkan Anda untuk hanya menyediakan tombol login untuk penyedia identitas eksternal seperti OAuth2 atau OIDC.';
$string['loginlocalloginenablesetting_note'] = 'Harap diperhatikan: Begitu Anda menyembunyikan formulir login lokal, Anda berisiko bahwa admin tidak dapat login lagi dengan akun lokal jika ada masalah dengan penyedia identitas eksternal. Hal yang sama berlaku jika tidak ada metode autentikasi lain selain autentikasi manual yang diaktifkan sama sekali.<br />Untuk mengizinkan login lokal dalam kasus seperti itu, <a href="{$a->url}">halaman login lokal pintu masuk samping</a> (lihat di bawah untuk rinciannya) diaktifkan secara otomatis. Harap tandai URL ini sebagai jaring pengaman Anda sendiri.';
$string['loginlocalloginformhead'] = 'Login lokal';
$string['loginlocalloginlocalnotdisabled'] = 'Tidak perlu login pada halaman login pintu masuk samping ini. Silakan gunakan <a href="{$a->url}">halaman login standar</a> untuk login.';
$string['loginlocalshowintrosetting'] = 'Intro login lokal';
$string['loginlocalshowintrosetting_desc'] = 'Dengan pengaturan ini, Anda dapat mengontrol apakah intro <em>\'{$a}\'</em> ditampilkan di atas formulir login lokal atau tidak. Secara bawaan, intro tidak ditampilkan. Namun, jika Anda mengaktifkannya, intro ini dapat membantu pengguna memahami kredensial mana yang akan digunakan dalam formulir login lokal, terutama jika Anda menyediakan lebih dari satu metode login atau jika Anda telah mengubah urutan metode login.';
$string['loginorderfirsttimesignupsetting'] = 'Informasi untuk pengunjung pertama kali & Registrasi mandiri';
$string['loginorderguestsetting'] = 'Login tamu';
$string['loginorderheading'] = 'Urutan login';
$string['loginorderheading_desc'] = 'Dengan pengaturan ini, Anda dapat mengontrol urutan metode login dalam formulir login. Urutan yang ditampilkan akan ditentukan dari nomor urut terendah hingga tertinggi, dengan mengabaikan semua metode login dan elemen formulir login yang dinonaktifkan di Moodle.';
$string['loginorderheading_note'] = 'Catatan teknis: Urutan yang disajikan akan diwujudkan dengan perintah CSS flexbox, bukan dengan menata ulang widget login di HTML DOM. Ini seharusnya baik-baik saja di semua peramban modern tetapi mungkin tidak berfungsi di peramban yang sangat lama.';
$string['loginorderidpsetting'] = 'Login IDP';
$string['loginorderlocalsetting'] = 'Login lokal';
$string['loginpagetab'] = 'Halaman login';
$string['loginprovidersheading'] = 'Penyedia login';
$string['logocompactsetting'] = 'Logo ringkas';
$string['logocompactsetting_desc'] = 'Di sini, Anda dapat mengunggah versi ringkas dari logo yang sama seperti di atas, seperti emblem, perisai, atau ikon. Gambar ini khususnya digunakan di bilah navigasi di bagian atas setiap halaman Moodle. Gambar harus jelas meskipun ukurannya kecil.';
$string['logosetting'] = 'Logo';
$string['logosetting_desc'] = 'Di sini, Anda dapat mengunggah logo lengkap untuk digunakan sebagai dekorasi. Gambar ini khususnya digunakan pada halaman login. Gambar ini dapat memiliki resolusi yang cukup tinggi karena akan diperkecil untuk digunakan.';
$string['logosheading'] = 'Logo';
$string['logosheading_desc'] = 'Harap diperhatikan: Boost Union memiliki pengunggahan logo sendiri dan tidak menggunakan logo dari <a href="{$a}">pengaturan logo inti Moodle</a>.<br />Boost Union secara khusus memungkinkan Anda mengunggah lebih banyak format gambar yang diizinkan oleh inti Moodle dan memungkinkan Anda untuk mengganti logo yang diunggah dalam variasinya.';
$string['maintenancecontentsetting'] = 'Konten halaman informasi pemeliharaan';
$string['maintenancecontentsetting_desc'] = 'Dalam pengaturan ini, Anda dapat menambahkan konten rich text yang akan ditampilkan pada halaman informasi pemeliharaan (yang tidak sama dengan halaman mode pemeliharaan bawaan Moodle).';
$string['maintenancedisabled'] = 'Halaman informasi pemeliharaan dinonaktifkan untuk situs ini. Tidak ada yang bisa dilihat di sini.';
$string['maintenanceheading'] = 'Pemeliharaan';
$string['maintenancelinkpositionboth'] = 'Tambahkan tautan ke halaman informasi pemeliharaan ke catatan kaki dan ke ikon footer (questionmark)';
$string['maintenancelinkpositionfooter'] = 'Tambahkan tautan ke halaman informasi pemeliharaan ke ikon footer (questionmark)';
$string['maintenancelinkpositionfootnote'] = 'Tambahkan tautan ke halaman informasi pemeliharaan ke catatan kaki';
$string['maintenancelinkpositionnone'] = 'Jangan secara otomatis menampilkan tautan ke halaman informasi pemeliharaan';
$string['maintenancelinkpositionsetting'] = 'Posisi tautan halaman informasi pemeliharaan';
$string['maintenancelinkpositionsetting_desc'] = 'Dalam pengaturan ini, Anda dapat mengonfigurasi apakah tautan ke halaman informasi pemeliharaan harus ditambahkan secara otomatis ke halaman Moodle. Jika Anda tidak ingin menampilkan tautan secara otomatis, Anda dapat menambahkan tautan ke {$a->url} dari mana saja di Moodle secara manual.';
$string['maintenancepagetitledefault'] = 'Pemeliharaan';
$string['maintenancepagetitlesetting'] = 'Judul halaman informasi pemeliharaan';
$string['maintenancepagetitlesetting_desc'] = 'Dalam pengaturan ini, Anda dapat menentukan judul halaman informasi pemeliharaan. Teks ini juga akan digunakan sebagai teks tautan ke halaman informasi pemeliharaan jika Anda mengonfigurasi \'Posisi tautan halaman informasi pemeliharaan\' sebagaimana mestinya.';
$string['markbrokenlinkssetting'] = 'Tandai tautan rusak';
$string['markbrokenlinkssetting_desc'] = 'Menambahkan ikon "rantai putus" di depan tautan yang rusak (yang mengarah ke berkas draf yang diunggah yang belum diproses dengan benar) dan menandai tautan tersebut dalam warna bootstrap sebagai "bahaya". Berbeda dengan pengaturan "Tandai tautan eksternal" dan "Tandai tautan mailto", tidak ada kemungkinan untuk membatasi cakupan pengaturan ini karena menandai tautan yang rusak merupakan indikator bahwa ada sesuatu yang rusak dan harus diperbaiki secara manual.';
$string['markexternallinksscopesetting'] = 'Tandai cakupan tautan eksternal';
$string['markexternallinksscopesetting_desc'] = 'Dengan pengaturan ini, Anda mengendalikan cakupan tempat Boost Union harus menandai tautan eksternal. Secara bawaan, Boost Union menandai tautan eksternal di seluruh halaman Moodle dan berupaya sebaik mungkin untuk mencakup beberapa kasus khusus di mana menambahkan ikon tautan eksternal tidak begitu masuk akal. Namun, Anda juga dapat membatasi cakupan untuk menghindari kasus khusus dengan lebih baik.';
$string['markexternallinkssetting'] = 'Tandai tautan eksternal';
$string['markexternallinkssetting_desc'] = 'Menambahkan ikon "tautan eksternal" setelah tautan eksternal (yang mengarahkan pengguna ke target di luar Moodle).';
$string['marklinksscopesetting_coursemain'] = 'Dalam area konten utama hanya halaman utama kursus';
$string['marklinksscopesetting_wholepage'] = 'Di seluruh halaman';
$string['markmailtolinksscopesetting'] = 'Tandai cakupan tautan mailto';
$string['markmailtolinksscopesetting_desc'] = 'Dengan pengaturan ini, Anda mengendalikan cakupan tempat Boost Union harus menandai tautan mailto. Secara bawaan, Boost Union menandai tautan mailto di seluruh halaman Moodle. Namun, Anda juga dapat membatasi cakupan untuk menghindari kasus-kasus ekstrem.';
$string['markmailtolinkssetting'] = 'Tandai tautan mailto';
$string['markmailtolinkssetting_desc'] = 'Menambahkan ikon "amplop" di depan tautan mailto.';
$string['maxlogowidth'] = 'Lebar maksimal logo di navbar';
$string['maxlogowidth_desc'] = 'Di bilah navigasi, logo ringkas yang diunggah biasanya ditampilkan dengan tinggi 100% dan lebar proporsional. Namun, jika logo terlalu lebar atau memiliki rasio aspek khusus lainnya, Anda dapat mengatur lebar maksimal logo di bilah navigasi di sini. Anda dapat memasukkan nilai berbasis piksel seperti 120px, tetapi Anda juga dapat memasukkan nilai berbasis persentase seperti 10% atau nilai lebar viewport seperti 5vw. Jika Anda tidak memasukkan nilai apa pun, logo akan ditampilkan dengan presentasi bawaan.';
$string['mediumcontentmaxwidthsetting'] = 'Lebar maksimum konten sedang';
$string['mediumcontentmaxwidthsetting_desc'] = 'Dengan pengaturan ini, Anda dapat mengganti lebar konten medium Moodle tanpa modifikasi SCSS manual. Lebar halaman ini digunakan dalam aktivitas tertentu seperti aktivitas basis data. Secara bawaan, Moodle menggunakan lebar maksimum konten medium sebesar 1120 piksel. Anda dapat memasukkan nilai berbasis piksel lainnya seperti 1200 piksel, tetapi Anda juga dapat memasukkan nilai berbasis persentase seperti 100% atau nilai lebar viewport seperti 90vw.';
$string['misctab'] = 'Lain-lain';
$string['mobileappearanceheading'] = 'Penampilan seluler';
$string['mobileappheading'] = 'Aplikasi seluler';
$string['mobilecss'] = 'CSS Tambahan untuk aplikasi Seluler';
$string['mobilecss_desc'] = 'Dengan pengaturan ini, Anda dapat menulis kode CSS kustom untuk menyesuaikan antarmuka aplikasi seluler Anda. Kode CSS hanya akan ditambahkan ke penggambaran aplikasi Seluler dari instansi Moodle ini dan tidak akan ditampilkan dalam versi peramban web. Baca selengkapnya tentang fitur ini di <a href="https://moodledev.io/general/app/customisation/remote-themes#how-do-remote-themes-work">dokumen pengembangan Moodle</a>.';
$string['mobilecss_donotchange'] = 'Langkah ini diperlukan untuk mengirim kode CSS ke aplikasi Seluler. Jangan ubah URL di sana kecuali Anda benar-benar ingin menghapus kode CSS dari aplikasi Seluler lagi.';
$string['mobilecss_overwrite'] = 'Begitu Anda menambahkan kode CSS apa pun ke pengaturan ini dan menyimpan pengaturan tersebut, <a href="{$a->url}">pengaturan inti Moodle <em>mobilecssurl</em></a> akan secara otomatis ditimpa dengan URL tema Boost Union. Saat ini pengaturan ini ditetapkan ke <a href="{$a->value}">{$a->value}</a>.';
$string['mobilecss_set'] = 'Segera setelah Anda menambahkan kode CSS apa pun ke pengaturan ini dan menyimpan pengaturan tersebut, <a href="{$a->url}">pengaturan inti Moodle <em>mobilecssurl</em></a> akan secara otomatis ditetapkan ke URL tema Boost Union.';
$string['mobiletab'] = 'Seluler';
$string['modiconactivity'] = 'Aktivitas';
$string['modiconactivityunknown'] = 'Tidak diketahui';
$string['modicongtmoodle4'] = 'Ikon Moodle 4';
$string['modiconlistsetting'] = 'Daftar berkas ikon kustom';
$string['modiconlistsetting_desc'] = 'Ini adalah daftar berkas ikon kustom yang telah Anda unggah ke area berkas ikon kustom di atas. Semua berkas ikon yang valid tercantum di sini. Selain itu, berkas lain yang mungkin telah Anda unggah juga tetapi bukan berkas ikon yang valid juga ditampilkan sebagai berkas yang rusak.';
$string['modiconltmoodle311'] = 'Ikon lama Moodle 3';
$string['modiconnamefail'] = 'Berkas ini diunggah ke folder yang benar untuk aktivitas <em>{$a}</em>, tetapi nama berkasnya tidak valid. Harap ubah nama berkas menjadi <em>monologo.svg</em> / <em>monologo.png</em> (untuk ikon Moodle 4) atau menjadi <em>icon.svg</em> / <em>icon.png</em> (untuk ikon lama Moodle 3).';
$string['modiconnotexist'] = 'Berkas ini diunggah ke lokasi yang tidak sesuai karena tidak mungkin untuk menyimpulkan aktivitas tertentu dari jalur berkas <em>{$a}</em>.';
$string['modiconsenablesetting'] = 'Aktifkan ikon kustom untuk aktivitas dan sumber daya';
$string['modiconsenablesetting_desc'] = 'Dengan pengaturan ini, Anda dapat mengubah ikon untuk aktivitas dan sumber daya yang digunakan oleh Moodle di halaman kursus dan di pemilih aktivitas.';
$string['modiconserrorcreatingpath'] = 'Folder pix_plugins/mod tidak dapat dibuat di direktori Moodledata Anda.<br />Pesan pengecualiannya adalah:{$a}.';
$string['modiconsfiles'] = 'Berkas ikon kustom';
$string['modiconsfiles_desc'] = 'Di sini, Anda dapat mengunggah ikon kustom untuk semua atau hanya beberapa modul aktivitas yang diinstal dalam instansi Moodle ini.';
$string['modiconsfileshowto'] = 'Untuk mengunggah ikon aktivitas kustom tertentu, mulailah dengan membuat folder dengan nama internal aktivitas, misalnya <em>tugas</em> untuk aktivitas penugasan. Di folder ini, unggah ikon sebagai berkas SVG yang disebut monologo.svg dan, jika memungkinkan, sebagai berkas PNG cadangan yang disebut monologo.png. Jika Anda ingin menyesuaikan ikon berwarna yang telah digunakan hingga Moodle 3 dan yang mungkin masih digunakan oleh pengaya lama, Anda juga dapat mengunggahnya sebagai berkas icon.svg dan icon.png. Namun, harap gunakan ikon SVG monokromatik jika memungkinkan untuk hasil terbaik. Kemudian, simpan halaman pengaturan. Segera setelah Anda menyimpan pengaturan dengan setidaknya satu berkas, daftar berkas akan muncul di bawah yang membantu Anda memeriksa apakah ikon kustom telah diunggah dengan benar.';
$string['modiconsfilestech'] = 'Catatan teknis: Setelah menyimpan pengaturan, struktur folder yang diunggah dan berkas ikon akan disalin ke folder pix_plugins/mod di direktori Moodledata Anda. Di sinilah inti Moodle mencari ikon aktivitas kustom. Semua berkas ikon yang mungkin sudah ada di tempat ini akan ditimpa saat Anda menyimpan pengaturan ini.';
$string['modiconsheading'] = 'Ikon aktivitas';
$string['modiconsuccess3x'] = 'Ikon ini akan digunakan untuk aktivitas <em>{$a}</em> sebagai ikon lama Moodle 3.';
$string['modiconsuccess4x'] = 'Ikon ini akan digunakan untuk aktivitas <em>{$a}</em> sebagai ikon Moodle 4.';
$string['modiconversion'] = 'Versi ikon';
$string['navbarcolorsetting'] = 'Warna bilah navigasi';
$string['navbarcolorsetting_dark'] = 'Bilah navigasi gelap dengan warna font terang';
$string['navbarcolorsetting_desc'] = 'Dengan pengaturan ini, Anda dapat mengubah warna bilah navigasi dari bilah navigasi terang bawaan menjadi bilah navigasi gelap atau berwarna.';
$string['navbarcolorsetting_light'] = 'Bilah navigasi terang dengan warna font gelap (tidak berubah seperti yang disajikan oleh inti Moodle)';
$string['navbarcolorsetting_primarydark'] = 'Bilah navigasi warna primer dengan warna font terang';
$string['navbarcolorsetting_primarylight'] = 'Bilah navigasi warna primer dengan warna font gelap';
$string['navbarheading'] = 'Bilah navigasi';
$string['navigationheading'] = 'Navigasi';
$string['navigationtab'] = 'Navigasi';
$string['never'] = 'Tidak pernah';
$string['nochange'] = 'Tidak ada perubahan';
$string['offerscontentsetting'] = 'Konten penawaran';
$string['offerscontentsetting_desc'] = 'Dalam pengaturan ini, Anda dapat menambahkan konten rich text yang akan ditampilkan di halaman penawaran.';
$string['offersdisabled'] = 'Halaman penawaran dinonaktifkan untuk situs ini. Tidak ada yang bisa dilihat di sini.';
$string['offersheading'] = 'Penawaran';
$string['offerslinkpositionboth'] = 'Tambahkan tautan ke halaman penawaran ke catatan kaki dan ke ikon footer (questionmark)';
$string['offerslinkpositionfooter'] = 'Tambahkan tautan ke halaman penawaran ke ikon footer (questionmark)';
$string['offerslinkpositionfootnote'] = 'Tambahkan tautan ke halaman penawaran ke catatan kaki';
$string['offerslinkpositionnone'] = 'Jangan secara otomatis menampilkan tautan ke halaman penawaran';
$string['offerslinkpositionsetting'] = 'Posisi tautan penawaran';
$string['offerslinkpositionsetting_desc'] = 'Dalam pengaturan ini, Anda dapat mengonfigurasi apakah tautan ke halaman penawaran harus ditambahkan secara otomatis ke halaman Moodle. Jika Anda tidak ingin menampilkan tautan secara otomatis, Anda dapat menambahkan tautan ke {$a->url} dari mana saja di Moodle secara manual.';
$string['offerspagetitledefault'] = 'Penawaran';
$string['offerspagetitlesetting'] = 'Judul halaman penawaran';
$string['offerspagetitlesetting_desc'] = 'Dalam pengaturan ini, Anda dapat menentukan judul halaman penawaran. Teks ini juga akan digunakan sebagai teks tautan ke halaman penawaran jika Anda mengonfigurasi \'Posisi tautan penawaran\' sebagaimana mestinya.';
$string['openoffcanvas'] = 'Buka laci kanvas';
$string['outsideregionsheading'] = 'Wilayah luar';
$string['outsideregionsheading_desc'] = 'Wilayah luar tidak hanya dapat diaktifkan dengan pengaturan tata letak di atas, tampilannya juga dapat disesuaikan.';
$string['outsideregionsplacement'] = 'Penempatan horizontal di wilayah luar';
$string['outsideregionsplacement_desc'] = 'Dengan pengaturan ini, Anda dapat mengendalikan apakah, pada layar yang lebih besar, wilayah blok \'Luar (kiri)\' dan \'Luar (kanan)\' harus ditempatkan di dekat area konten utama atau lebih tepatnya di dekat tepi jendela.';
$string['outsideregionsplacementnearwindowedges'] = 'Tampilkan wilayah \'Luar (kiri)\' dan \'Luar (kanan)\' di dekat tepi jendela';
$string['outsideregionsplacementnextmaincontent'] = 'Tampilkan wilayah \'Luar (kiri)\' dan \'Luar (kanan)\' di samping area konten utama';
$string['outsideregionswidthcoursecontentwidth'] = 'Lebar konten kursus';
$string['outsideregionswidthfullwidth'] = 'Lebar penuh';
$string['outsideregionswidthherowidth'] = 'Lebar hero';
$string['page1contentsetting'] = 'Konten halaman generik 1';
$string['page1contentsetting_desc'] = 'Dalam pengaturan ini, Anda dapat menambahkan konten rich text yang akan ditampilkan pada halaman generik 1.';
$string['page1disabled'] = 'Halaman generik 1 dinonaktifkan untuk situs ini. Tidak ada yang bisa dilihat di sini.';
$string['page1heading'] = 'Halaman generik 1';
$string['page1linkpositionboth'] = 'Tambahkan tautan ke halaman generik 1 ke catatan kaki dan ke ikon footer (questionmark)';
$string['page1linkpositionfooter'] = 'Tambahkan tautan ke halaman generik 1 ke ikon footer (questionmark)';
$string['page1linkpositionfootnote'] = 'Tambahkan tautan ke halaman generik 1 ke catatan kaki';
$string['page1linkpositionnone'] = 'Jangan secara otomatis menampilkan tautan ke halaman generik 1';
$string['page1linkpositionsetting'] = 'Posisi tautan halaman generik 1';
$string['page1linkpositionsetting_desc'] = 'Dalam pengaturan ini, Anda dapat mengonfigurasi apakah tautan ke halaman generik 1 harus ditambahkan secara otomatis ke halaman Moodle. Jika Anda tidak ingin menampilkan tautan secara otomatis, Anda dapat menambahkan tautan ke {$a->url} dari mana saja di Moodle secara manual.';
$string['page1pagetitledefault'] = 'Halaman generik 1';
$string['page1pagetitlesetting'] = 'Judul halaman generik 1';
$string['page1pagetitlesetting_desc'] = 'Dalam pengaturan ini, Anda dapat menentukan judul halaman generik 1. Teks ini juga akan digunakan sebagai teks tautan ke halaman generik 1 jika Anda mengonfigurasi \'Posisi tautan halaman generik 1\' sebagaimana mestinya.';
$string['page2contentsetting'] = 'Konten halaman generik 2';
$string['page2contentsetting_desc'] = 'Dalam pengaturan ini, Anda dapat menambahkan konten rich text yang akan ditampilkan di halaman generik 2.';
$string['page2disabled'] = 'Halaman generik 2 dinonaktifkan untuk situs ini. Tidak ada yang bisa dilihat di sini.';
$string['page2heading'] = 'Halaman generik 2';
$string['page2linkpositionboth'] = 'Tambahkan tautan ke halaman generik 2 ke catatan kaki dan ke ikon footer (questionmark)';
$string['page2linkpositionfooter'] = 'Tambahkan tautan ke halaman generik 2 ke ikon footer (questionmark)';
$string['page2linkpositionfootnote'] = 'Tambahkan tautan ke halaman generik 2 ke catatan kaki';
$string['page2linkpositionnone'] = 'Jangan secara otomatis menampilkan tautan ke halaman generik 2';
$string['page2linkpositionsetting'] = 'Posisi tautan halaman generik 2';
$string['page2linkpositionsetting_desc'] = 'Dalam pengaturan ini, Anda dapat mengonfigurasi apakah tautan ke halaman generik 2 harus ditambahkan secara otomatis ke halaman Moodle. Jika Anda tidak ingin menampilkan tautan secara otomatis, Anda dapat menambahkan tautan ke {$a->url} dari mana saja di Moodle secara manual.';
$string['page2pagetitledefault'] = 'Halaman generik 2';
$string['page2pagetitlesetting'] = 'Judul halaman generik 2';
$string['page2pagetitlesetting_desc'] = 'Dalam pengaturan ini, Anda dapat menentukan judul halaman generik 2. Teks ini juga akan digunakan sebagai teks tautan ke halaman generik 2 jika Anda mengonfigurasi \'Posisi tautan halaman generik 2\' sebagaimana mestinya.';
$string['page3contentsetting'] = 'Konten halaman generik 3';
$string['page3contentsetting_desc'] = 'Dalam pengaturan ini, Anda dapat menambahkan konten rich text yang akan ditampilkan pada halaman generik 3.';
$string['page3disabled'] = 'Halaman generik 3 dinonaktifkan untuk situs ini. Tidak ada yang bisa dilihat di sini.';
$string['page3heading'] = 'Halaman generik 3';
$string['page3linkpositionboth'] = 'Tambahkan tautan ke halaman generik 3 ke catatan kaki dan ke ikon footer (questionmark)';
$string['page3linkpositionfooter'] = 'Tambahkan tautan ke halaman generik 3 ke ikon footer (questionmark)';
$string['page3linkpositionfootnote'] = 'Tambahkan tautan ke halaman generik 3 ke catatan kaki';
$string['page3linkpositionnone'] = 'Jangan secara otomatis menampilkan tautan ke halaman generik 3';
$string['page3linkpositionsetting'] = 'Posisi tautan halaman generik 3';
$string['page3linkpositionsetting_desc'] = 'Dalam pengaturan ini, Anda dapat mengonfigurasi apakah tautan ke halaman generik 3 harus ditambahkan secara otomatis ke halaman Moodle. Jika Anda tidak ingin menampilkan tautan secara otomatis, Anda dapat menambahkan tautan ke {$a->url} dari mana saja di Moodle secara manual.';
$string['page3pagetitledefault'] = 'Halaman generik 3';
$string['page3pagetitlesetting'] = 'Judul halaman generik 3';
$string['page3pagetitlesetting_desc'] = 'Dalam pengaturan ini, Anda dapat menentukan judul halaman generik 3. Teks ini juga akan digunakan sebagai teks tautan ke halaman generik 3 jika Anda mengonfigurasi \'Posisi tautan halaman generik 3\' sebagaimana mestinya.';
$string['pagelayoutstab'] = 'Tata letak halaman';
$string['pagetab'] = 'Halaman';
$string['pagewidthheading'] = 'Lebar halaman';
$string['pluginname'] = 'Boost Union';
$string['policyheading'] = 'Kebijakan';
$string['policyoverviewnavigationsetting'] = 'Tampilkan navigasi pada halaman ikhtisar kebijakan';
$string['policyoverviewnavigationsetting_desc'] = 'Secara bawaan, <a href="{$a->url}">halaman ikhtisar kebijakan (disediakan oleh tool_policy)</a> tidak menampilkan menu navigasi atau footer. Dengan pengaturan ini, Anda dapat menampilkan navigasi utama dan footer pada halaman tersebut.';
$string['presetbutton'] = 'Setel prasetel tema di Boost';
$string['presetheading'] = 'Prasetel tema';
$string['presetheading_desc'] = 'Prasetel tema dapat digunakan untuk mengubah tampilan tema secara drastis. Boost Union tidak menerapkan ulang pengaturan prasetel tema. Jika Anda ingin menggunakan prasetel tema, silakan atur langsung di Boost. Boost Union akan mewarisi dan menggunakan prasetel yang dikonfigurasi.';
$string['primarynavigationheading'] = 'Navigasi utama';
$string['privacy:metadata'] = 'Tema Boost Union tidak menyimpan data pribadi apa pun tentang pengguna mana pun.';
$string['recentlyaccesseditemsheading'] = 'Blok item yang baru saja diakses';
$string['recentlyaccesseditemstintenabled'] = 'Warnai ikon aktivitas item yang baru diakses';
$string['recentlyaccesseditemstintenabled_desc'] = 'Dengan pengaturan ini, Anda dapat mewarnai ikon aktivitas di blok item yang baru diakses berdasarkan tujuan aktivitas. Secara bawaan, inti Moodle menampilkannya hanya sebagai ikon hitam.';
$string['region-content-lower'] = 'Konten (bawah)';
$string['region-content-upper'] = 'Konten (atas)';
$string['region-footer-center'] = 'Footer (tengah)';
$string['region-footer-left'] = 'Footer (kiri)';
$string['region-footer-right'] = 'Footer (kanan)';
$string['region-header'] = 'Header';
$string['region-none'] = 'Tidak ada';
$string['region-offcanvas-center'] = 'Off-canvas (tengah)';
$string['region-offcanvas-left'] = 'Off-canvas (kiri)';
$string['region-offcanvas-right'] = 'Off-canvas (kanan)';
$string['region-outside-bottom'] = 'Luar (bawah)';
$string['region-outside-left'] = 'Luar (kiri)';
$string['region-outside-right'] = 'Luar (kanan)';
$string['region-outside-top'] = 'Luar (atas)';
$string['resourcescachecontrolnote'] = 'Harap perhatikan bahwa berkas dikirim ke peramban dengan header \'Cache-Control\' yang memberi tahu peramban untuk menyimpan berkas dalam cache. Jika Anda yakin tidak akan mengubah berkas dalam waktu dekat, Anda dapat menggunakan URL tetap untuk menautkan ke berkas tersebut. Namun, jika Anda berencana untuk mengubah berkas tetapi tetap menggunakan nama berkas yang sama setiap saat, sebaiknya Anda menggunakan URL yang telah direvisi dan menautkan ulang berkas tersebut ke tempat Anda menggunakannya setiap kali Anda memperbarui berkas untuk menghindari peramban menampilkan versi berkas lama yang tersimpan dalam cache.';
$string['resourcestab'] = 'Sumber';
$string['scrollspysetting'] = 'Mata-mata gulir';
$string['scrollspysetting_desc'] = 'Dengan pengaturan ini, saat mengaktifkan dan menonaktifkan mode sunting, posisi gulir di mana pengguna berada saat melakukan pengalihaan akan dipertahankan.';
$string['scssheading'] = 'SCSS mentah';
$string['scsstab'] = 'SCSS';
$string['setpreferredlanglink'] = 'Setel bahasa pilihan';
$string['settingsoverview'] = 'Ikhtisar pengaturan';
$string['settingsoverview_accessibility_desc'] = 'Pengaturan untuk fungsionalitas terkait aksesibilitas pada situs Moodle Anda terletak di sini.';
$string['settingsoverview_all'] = 'Semua pengaturan pada satu halaman';
$string['settingsoverview_all_desc'] = 'Di sini, Anda dapat membuka halaman pengaturan kategori Moodle standar untuk Boost Union yang menampilkan semua pengaturan pada satu halaman. Namun hati-hati, halaman ini sangat padat.';
$string['settingsoverview_content_desc'] = 'Pengaturan untuk konten global situs Moodle Anda terletak di sini: Footer, halaman statis, spanduk info, ubin iklan, dan slider.';
$string['settingsoverview_feel_desc'] = 'Pengaturan untuk perilaku keseluruhan situs Moodle Anda terletak di sini: Item navigasi, pembantu navigasi, blok dan tautan.';
$string['settingsoverview_flavours_desc'] = 'Dengan flavor, Anda dapat mendiversifikasi tampilan situs Moodle Anda antar kohor dan/atau kategori kursus.';
$string['settingsoverview_functionality_desc'] = 'Pengaturan untuk fungsionalitas global atau terkait kursus tambahan yang berguna di situs Moodle Anda terletak di sini.';
$string['settingsoverview_look_desc'] = 'Pengaturan untuk merek situs Moodle Anda terletak di sini: Warna, ikon, gambar, ukuran dan, tentu saja, SCSS kustom.';
$string['settingsoverview_smartmenus_desc'] = 'Dengan menu pintar, Anda dapat memperluas item navigasi situs Moodle Anda di menu utama dan menu pengguna serta memperkenalkan menu bawah atau menu atas.';
$string['settingsoverview_title'] = 'Ikhtisar pengaturan Boost Union';
$string['showfullnameinusermenussetting'] = 'Tampilkan nama lengkap di menu pengguna';
$string['showfullnameinusermenussetting_desc'] = 'Dengan pengaturan ini, Anda dapat menampilkan nama lengkap pengguna yang masuk di bagian atas menu pengguna. Ini dapat sangat membantu untuk situasi ujian di mana guru harus mengonfirmasi bahwa pengguna masuk dengan akunnya sendiri, tetapi mungkin juga berguna bagi pengguna itu sendiri. Berbeda dengan tema Klasik yang menampilkan nama lengkap pengguna di bilah navigasi dekat avatar, pendekatan ini tidak mengklaim ruang langka tambahan di bilah navigasi.';
$string['showfullnameinusermenussetting_loggedinas'] = 'Anda masuk sebagai:';
$string['showhintcourseguestaccessgeneral'] = 'Anda saat ini melihat kursus ini sebagai <strong>{$a->role}</strong>.';
$string['showhintcourseguestaccesslink'] = 'Untuk memiliki akses penuh ke kursus, Anda dapat <a href="{$a->url}">daftar sendiri ke kursus ini</a>.';
$string['showhintcourseguestaccesssetting_desc'] = 'Dengan pengaturan ini, petunjuk akan muncul di header kursus saat pengguna mengaksesnya dengan fitur akses tamu. Jika kursus menyediakan pendaftaran mandiri yang aktif, tautan ke halaman tersebut juga akan ditampilkan kepada pengguna.';
$string['showhintcoursehiddengeneral'] = 'Kursus ini saat ini <strong>disembunyikan</strong>. Hanya guru yang terdaftar yang dapat mengakses kursus ini saat disembunyikan.';
$string['showhintcoursehiddensetting'] = 'Tampilkan petunjuk di kursus tersembunyi';
$string['showhintcoursehiddensetting_desc'] = 'Dengan pengaturan ini, petunjuk akan muncul di header kursus selama visibilitas kursus disembunyikan. Ini membantu mengidentifikasi status visibilitas kursus secara sekilas tanpa perlu melihat pengaturan kursus.';
$string['showhintcoursehiddensettingslink'] = 'Anda dapat mengubah visibilitas di <a href="{$a->url}">pengaturan kursus</a>.';
$string['showhintcourseselfenrolfrom'] = 'Instansi pendaftaran <strong>{$a->name}</strong> memperbolehkan pendaftaran mandiri tanpa batas dari {$a->from} dan seterusnya.';
$string['showhintcourseselfenrolfromuntil'] = 'Instansi pendaftaran <strong>{$a->name}</strong> memperbolehkan pendaftaran mandiri tanpa batas dari {$a->from} hingga {$a->until}.';
$string['showhintcourseselfenrolinstancecallforaction'] = 'Jika Anda tidak ingin pengguna Moodle mana pun memiliki akses ke kursus ini secara bebas, harap batasi pengaturan pendaftaran mandiri.';
$string['showhintcourseselfenrolsetting'] = 'Tampilkan petunjuk untuk pendaftaran mandiri tanpa kunci pendaftaran';
$string['showhintcourseselfenrolsetting_desc'] = 'Dengan pengaturan ini, petunjuk akan muncul di tajuk kursus jika kursus tersebut terlihat dan pendaftaran tanpa kunci pendaftaran saat ini memungkinkan.';
$string['showhintcourseselfenrolsince'] = 'Instansi pendaftaran <strong>{$a->name}</strong> saat ini memperbolehkan pendaftaran mandiri tanpa batas.';
$string['showhintcourseselfenrolsinceuntil'] = 'Instansi pendaftaran <strong>{$a->name}</strong> memperbolehkan pendaftaran mandiri tanpa batas hingga {$a->until}.';
$string['showhintcourseselfenrolstartcurrently'] = 'Kursus ini saat ini dapat dilihat oleh semua orang dan <strong>pendaftaran mandiri tanpa kunci pendaftaran</strong> dimungkinkan.';
$string['showhintcourseselfenrolstartfuture'] = 'Kursus ini saat ini dapat dilihat oleh semua orang dan <strong>pendaftaran mandiri tanpa kunci pendaftaran</strong> direncanakan akan memungkinkan.';
$string['showhintcourseselfenrolunlimited'] = 'Instansi pendaftaran <strong>{$a->name}</strong> memungkinkan pendaftaran mandiri tanpa batas dan tanpa batas.';
$string['showhintcourseselfenroluntil'] = 'Instansi pendaftaran <strong>{$a->name}</strong> memperbolehkan pendaftaran mandiri tanpa batas hingga {$a->until}.';
$string['showhintcoursguestaccesssetting'] = 'Tampilkan petunjuk untuk akses tamu';
$string['showhintforumnotifications'] = 'Kursus ini saat ini <strong>disembunyikan</strong>. Ini berarti bahwa <strong>mahasiswa tidak akan diberi tahu</strong> secara daring atau melalui surel tentang pesan apa pun yang Anda posting di forum ini.';
$string['showhintforumnotificationssetting'] = 'Tampilkan petunjuk untuk pemberitahuan forum di kursus tersembunyi';
$string['showhintforumnotificationssetting_desc'] = 'Dengan pengaturan ini, petunjuk tidak hanya akan muncul di tajuk kursus tetapi juga di forum selama visibilitas kursus disembunyikan. Ini untuk memperjelas bahwa pemberitahuan dalam forum tidak dikirimkan kepada siswa dan untuk membantu guru memahami keadaan ini.';
$string['shownavbarstarredcourses_config'] = 'Atur kursus berbintang di halaman \'{$a}\'';
$string['shownavbarstarredcourses_label'] = 'Kursus berbintang';
$string['shownavbarstarredcoursessetting'] = 'Tampilkan popover kursus berbintang di bilah navigasi';
$string['shownavbarstarredcoursessetting_desc'] = 'Dengan pengaturan ini, Anda dapat menampilkan menu popover dengan tautan ke kursus berbintang di samping menu pesan dan pemberitahuan.';
$string['showsitehomerighthandblockdraweronfirstloginsetting'] = 'Tampilkan laci blok sebelah kanan beranda situs saat login pertama';
$string['showsitehomerighthandblockdraweronfirstloginsetting_desc'] = 'Dengan pengaturan ini, laci blok sebelah kanan beranda situs akan ditampilkan dalam keadaan diperluas secara bawaan. Ini hanya berlaku untuk pengguna yang masuk untuk pertama kalinya dan tidak menimpa status sakelar masing-masing pengguna.';
$string['showsitehomerighthandblockdraweronguestloginsetting'] = 'Tampilkan laci blok sebelah kanan beranda situs saat login tamu';
$string['showsitehomerighthandblockdraweronguestloginsetting_desc'] = 'Dengan pengaturan ini, laci blok sebelah kanan beranda situs akan ditampilkan dalam keadaan diperluas secara bawaan. Ini hanya berlaku untuk pengguna yang masuk sebagai tamu.';
$string['showsitehomerighthandblockdraweronvisitsetting'] = 'Tampilkan laci blok sebelah kanan situs beranda saat berkunjung';
$string['showsitehomerighthandblockdraweronvisitsetting_desc'] = 'Dengan pengaturan ini, laci blok sebelah kanan beranda situs akan ditampilkan dalam keadaan diperluas secara bawaan. Ini hanya berlaku untuk pengguna yang tidak masuk dan tidak menimpa status sakelar masing-masing pengguna.';
$string['showswitchedroleincoursesetting'] = 'Tampilkan petunjuk untuk peran yang diubah';
$string['showswitchedroleincoursesetting_desc'] = 'Dengan pengaturan ini, petunjuk akan muncul di header kursus jika pengguna telah mengubah peran dalam kursus tersebut. Secara bawaan, informasi ini hanya ditampilkan tepat di dekat avatar pengguna di menu pengguna. Dengan mengaktifkan opsi ini, Anda dapat menampilkan informasi ini - bersama dengan tautan untuk beralih kembali - di dalam halaman kursus juga.';
$string['showviewcourseiconincoursemgntsesetting_desc'] = 'Secara bawaan, pada <a href="{$a}">halaman manajemen kursus</a>, Moodle mengharuskan Anda untuk membuka rincian kursus atau melewati pengaturan kursus sebelum Anda dapat mengklik elemen UI tambahan untuk melihat kursus. Dengan mengaktifkan pengaturan ini, Anda dapat menambahkan ikon \'Lihat kursus\' langsung ke daftar kategori di halaman manajemen kursus.';
$string['showviewcourseiconincoursemgntsetting'] = 'Tampilkan ikon tampilan kursus';
$string['sideentranceloginenablesetting'] = 'Aktifkan login masuk samping';
$string['sideentranceloginenablesetting_desc'] = 'Dengan pengaturan ini, Anda dapat mengaktifkan <a href="{$a->url}">halaman login lokal masuk samping</a>. Halaman ini diaktifkan secara otomatis jika Anda menonaktifkan formulir login lokal (lihat di atas), tetapi Anda juga dapat mengaktifkannya secara terus-menerus untuk memungkinkan pengguna lokal melewati halaman login utama dan proses login yang sangat membantu dalam pengaturan SSO. Di halaman login lokal masuk samping, semua langkah keamanan login Moodle juga berlaku, tentu saja.';
$string['sideentranceloginheading'] = 'Login masuk samping';
$string['sitebrandingtab'] = 'Merek situs';
$string['sitehomerighthandblockdrawerbehaviour'] = 'Situs beranda laci blok kanan';
$string['slidebackgroundimagealtsetting'] = 'Atribut alt gambar latar belakang slide {$a->no}';
$string['slidebackgroundimagealtsetting_desc'] = 'Di sini, Anda dapat menyetel atribut alt untuk gambar slide {$a->no}. Ini adalah pengaturan opsional, slide akan ditampilkan meskipun Anda tidak menyetel atribut alt. Harap perhatikan bahwa tidak menyediakan atribut alt akan menurunkan aksesibilitas.';
$string['slidebackgroundimagesetting'] = 'Gambar latar belakang slide {$a->no}';
$string['slidebackgroundimagesetting_desc'] = 'Di sini, Anda dapat mengunggah berkas gambar yang akan ditampilkan sebagai gambar latar belakang di balik konten slide {$a->no}. Pastikan atau periksa apakah konten masih dapat dibaca pada gambar latar belakang. Pastikan juga rasio aspek semua gambar latar belakang slide sama (karena rasio aspek gambar latar belakang mengendali tinggi slide dan Anda mungkin ingin menghindari kedipan saat slide diubah). Ini adalah pengaturan wajib, slide tidak akan ditampilkan jika Anda tidak mengunggah gambar latar belakang apa pun.';
$string['slidecaptionsetting'] = 'Teks slide {$a->no}';
$string['slidecaptionsetting_desc'] = 'Di sini, Anda memasukkan teks yang akan ditampilkan di slide {$a->no}. Teks ditampilkan di bagian tengah bawah slide. Ini adalah pengaturan opsional, slide akan ditampilkan meskipun Anda tidak menyetel teks.';
$string['slidecontentsetting'] = 'Konten slide {$a->no}';
$string['slidecontentsetting_desc'] = 'Di sini, Anda memasukkan konten yang akan ditampilkan di slide {$a->no}. Konten ditampilkan di bagian tengah bawah slide. Jika teks disetel, konten akan ditampilkan di bawah teks tersebut. Harap perhatikan bahwa penyunting teks kaya menghasilkan teks rata kiri secara bawaan, tetapi Anda mungkin ingin mengubahnya menjadi teks tengah untuk tampilan yang lebih bagus. Harap juga hindari menambahkan terlalu banyak konten ke slide dan harap uji konten Anda pada perangkat kecil karena konten yang memenuhi slide akan disembunyikan. Ini adalah pengaturan opsional, slide akan ditampilkan meskipun Anda tidak menyetel konten apa pun.';
$string['slidecontentstylesetting'] = 'Gaya konten slide {$a->no}';
$string['slidecontentstylesetting_dark'] = 'Gelap (warna font hitam untuk gambar latar belakang terang)';
$string['slidecontentstylesetting_darkshadow'] = 'Gelap & Bayangan (warna font hitam dengan bayangan terang untuk gambar latar belakang terang)';
$string['slidecontentstylesetting_desc'] = 'Di sini, Anda dapat mengubah gaya konten slide {$a->no}. Secara bawaan, gaya konten adalah warna font putih untuk gambar latar belakang gelap. Namun, untuk memungkinkan penataan gaya yang konsisten dan mudah pada semua jenis gambar latar belakang, Anda dapat mengganti gaya di sini. Harap perhatikan bahwa pengaturan ini akan mengganti warna font yang Anda tetapkan di peyunting teks kaya di atas dalam hal apa pun.';
$string['slidecontentstylesetting_light'] = 'Terang (warna font putih untuk gambar latar belakang gelap)';
$string['slidecontentstylesetting_lightshadow'] = 'Terang & Bayangan (warna font putih dengan bayangan gelap untuk gambar latar belakang gelap)';
$string['slideenabledsetting'] = 'Aktifkan slide {$a->no}';
$string['slideenabledsetting_desc'] = 'Dengan pengaturan ini, Anda dapat mengaktifkan slide {$a->no}.';
$string['slideheading'] = 'Slide {$a->no}';
$string['slidelinksetting'] = 'Tautan URL slide {$a->no}';
$string['slidelinksetting_desc'] = 'Di sini, Anda dapat menyetel URL (Moodle-internal atau eksternal) yang akan ditautkan dengan konten slide {$a->no}. Ini adalah pengaturan opsional, slide akan ditampilkan meskipun Anda tidak menyetel URL tautan.';
$string['slidelinksourcesetting'] = 'Sumber tautan slide {$a->no}';
$string['slidelinksourcesetting_both'] = 'Elemen gambar latar belakang dan teks';
$string['slidelinksourcesetting_desc'] = 'Di sini, Anda dapat mengontrol elemen slider mana yang akan ditautkan ke URL tautan yang diberikan. Anda dapat memilih antara menautkan gambar latar saja, menautkan elemen teks slide (keterangan dan konten) saja, atau menautkan keduanya.';
$string['slidelinksourcesetting_image'] = 'Hanya gambar latar belakang';
$string['slidelinksourcesetting_text'] = 'Hanya elemen teks';
$string['slidelinktargetsetting'] = 'Target tautan slide {$a->no}';
$string['slidelinktargetsetting_desc'] = 'Di sini, Anda dapat menyetel target tautan yang ditetapkan untuk tautan slide segera setelah Anda menyetel URL tautan di slide {$a->no}.';
$string['slidelinktargetsetting_newtab'] = 'Tab baru';
$string['slidelinktargetsetting_samewindow'] = 'Jendela yang sama';
$string['slidelinktitlesetting'] = 'Judul tautan slide {$a->no}';
$string['slidelinktitlesetting_desc'] = 'Di sini, Anda dapat mengatur judul tautan yang ditampilkan sebagai keterangan alat segera setelah pengguna mengarahkan kursor ke slide {$a->no}. Ini adalah pengaturan opsional, slide akan ditautkan meskipun Anda tidak mengatur judul tautan. Harap perhatikan bahwa tidak menyediakan judul tautan akan menurunkan aksesibilitas.';
$string['slideordersetting'] = 'Posisi urutan slide {$a->no}';
$string['slideordersetting_desc'] = 'Dengan pengaturan ini, Anda menentukan posisi urutan slide {$a->no}. Secara bawaan, slide diurutkan seperti yang Anda lihat di halaman pengaturan ini. Namun, Anda dapat memutuskan untuk menugaskan posisi urutan lain dengan pengaturan ini. Jika Anda menugaskan posisi urutan yang sama ke dua slide atau lebih, slide tersebut akan diurutkan lagi sesuai urutan di halaman pengaturan ini.';
$string['slideranimationsetting'] = 'Tipe animasi slider';
$string['slideranimationsetting_desc'] = 'Dengan pengaturan ini, Anda mengendalikan animasi slider. \'Geser\' menerapkan animasi geser, \'Pudar\' menerapkan animasi memudar dan \'Tidak ada\' menghapus semua animasi.';
$string['slideranimationsetting_fade'] = 'Pudar';
$string['slideranimationsetting_none'] = 'Tidak ada';
$string['slideranimationsetting_slide'] = 'Geser';
$string['sliderarrownavsetting'] = 'Aktifkan navigasi panah';
$string['sliderarrownavsetting_desc'] = 'Dengan pengaturan ini, Anda dapat menambahkan panah navigasi di kedua sisi slider.';
$string['sliderfrontpagepositionsetting'] = 'Posisi slider di situs beranda';
$string['sliderfrontpagepositionsetting_afterafter'] = 'Setelah konten beranda situs (dan setelah ubin iklan)';
$string['sliderfrontpagepositionsetting_afterbefore'] = 'Setelah konten beranda situs (tetapi sebelum ubin iklan)';
$string['sliderfrontpagepositionsetting_beforeafter'] = 'Sebelum konten beranda situs (tetapi setelah ubin iklan)';
$string['sliderfrontpagepositionsetting_beforebefore'] = 'Sebelum konten beranda situs (dan sebelum ubin iklan)';
$string['sliderfrontpagepositionsetting_desc'] = 'Slider hanya ditampilkan di beranda situs. Dengan pengaturan ini, Anda dapat mengendali apakah slider akan ditampilkan sebelum konten beranda situs atau setelah konten beranda situs. Jika Anda ingin menampilkan slider hanya di beranda situs dan tidak ada yang lain, semua konten beranda situs lainnya dapat dihapus dengan mengubah <a href="{$a->url}">pengaturan beranda situs</a>.';
$string['slidergeneralheading'] = 'Slider umum';
$string['sliderindicatornavsetting'] = 'Aktifkan navigasi indikator slider';
$string['sliderindicatornavsetting_desc'] = 'Dengan pengaturan ini, Anda dapat menambahkan indikator navigasi di bagian bawah slider.';
$string['sliderintervalsetting'] = 'Kecepatan interval slider';
$string['sliderintervalsetting_desc'] = 'Dengan pengaturan ini, Anda dapat mengontrol durasi tampilan slide dalam milidetik. Nilai minimum adalah 1000 (satu detik) dan nilai maksimum adalah 10000 (10 detik).';
$string['sliderkeyboardsetting'] = 'Izinkan interaksi papan ketik slider';
$string['sliderkeyboardsetting_desc'] = 'Dengan pengaturan ini, Anda mengaktifkan input papan ketik (tombol panah) untuk mengontrol slider. Harap perhatikan bahwa menonaktifkan ini akan menurunkan aksesibilitas.';
$string['sliderpausesetting'] = 'Jeda slider saat kursor ke atas';
$string['sliderpausesetting_desc'] = 'Dengan pengaturan ini, Anda mencegah slider berpindah-pindah slide saat pengguna mengarahkan kursor ke slide tersebut. Harap perhatikan bahwa menonaktifkan ini akan menurunkan aksesibilitas.';
$string['sliderridesetting'] = 'Berputar melalui slide';
$string['sliderridesetting_afterinteraction'] = 'Setelah interaksi';
$string['sliderridesetting_desc'] = 'Dengan pengaturan ini, Anda mengendalikan perilaku perputaran slider. \'Saat halaman dimuat\' mulai berputar melalui slide setelah halaman selesai dimuat, \'Setelah interaksi\' akan mulai berputar setelah pengguna berinteraksi dengan slider. \'Tidak pernah\' menonaktifkan perputaran slide secara otomatis, yang mengharuskan masukan pengguna untuk berputar melalui slide.';
$string['sliderridesetting_never'] = 'Tidak pernah';
$string['sliderridesetting_onpageload'] = 'Saat memuat halaman';
$string['slidertab'] = 'Slider';
$string['sliderwrapsetting'] = 'Terus menerus berputar melalui slide';
$string['sliderwrapsetting_desc'] = 'Dengan pengaturan ini, Anda membuat slider berputar melalui semua slide. Jika Anda menonaktifkan ini, slider akan berhenti berputar di slide terakhir.';
$string['smartmenus'] = 'Menu pintar';
$string['smartmenus_desc'] = '<p>Menu pintar memungkinkan administrator situs membuat menu yang dapat disesuaikan yang dapat ditempatkan di berbagai lokasi di situs, seperti menu utama situs, menu seluler bawah, dan menu pengguna. Menu dapat dikonfigurasi untuk menampilkan berbagai jenis konten, termasuk tautan ke halaman atau sumber daya lain, tautan kategori, atau tautan profil pengguna.</p><p>Administrator situs dapat membuat menu baru dan menentukan item menu, serta pengaturan tampilan. Administrator juga dapat memilih di mana menu akan ditampilkan di situs dan apakah menu tersebut harus terlihat oleh semua pengguna atau hanya untuk peran pengguna tertentu.</p>';
$string['smartmenusbyadmin'] = 'Tampilkan ke';
$string['smartmenusbyadmin_admins'] = 'Hanya admin situs';
$string['smartmenusbyadmin_all'] = 'Semua pengguna';
$string['smartmenusbyadmin_help'] = 'Batasi visibilitas berdasarkan fakta apakah pengguna adalah admin situs atau bukan.';
$string['smartmenusbyadmin_nonadmins'] = 'Hanya non-admin';
$string['smartmenusbycohort'] = 'Berdasarkan kohor';
$string['smartmenusbycohort_help'] = 'Batasi visibilitas berdasarkan kohor pengguna.';
$string['smartmenusbydate'] = 'Berdasarkan tanggal';
$string['smartmenusbydate_help'] = 'Batasi visibilitas berdasarkan tanggal';
$string['smartmenusbydatefrom'] = 'Dari';
$string['smartmenusbydatefrom_help'] = 'Batasi visibilitas sebelum tanggal yang diberikan tercapai';
$string['smartmenusbydateuntil'] = 'Sampai';
$string['smartmenusbydateuntil_help'] = 'Batasi visibilitas setelah tanggal yang diberikan tercapai';
$string['smartmenusbylanguage'] = 'Berdasarkan bahasa';
$string['smartmenusbylanguage_help'] = 'Batasi visibilitas berdasarkan bahasa pengguna';
$string['smartmenusbyrole'] = 'Berdasarkan peran';
$string['smartmenusbyrole_help'] = 'Batasi visibilitas berdasarkan peran pengguna.';
$string['smartmenusdynamiccoursescompletionstatus'] = 'Status penyelesaian';
$string['smartmenusdynamiccoursescompletionstatus_help'] = 'Daftar item menu kursus dinamis akan berisi semua kursus pengguna yang sesuai dengan status penyelesaian yang dipilih. Misalnya, jika Anda memilih \'Dalam kemajuan\' sebagai status penyelesaian, daftar item menu kursus dinamis hanya akan berisi kursus yang sedang dikerjakan oleh pengguna saat ini.';
$string['smartmenusdynamiccoursescompletionstatuscompleted'] = 'Selesai';
$string['smartmenusdynamiccoursescompletionstatusenrolled'] = 'Terdaftar';
$string['smartmenusdynamiccoursescompletionstatusinprogress'] = 'Dalam kemajuan';
$string['smartmenusdynamiccoursescoursecategory'] = 'Kategori kursus';
$string['smartmenusdynamiccoursescoursecategory_help'] = 'Daftar item menu kursus dinamis akan berisi semua kursus dari kategori kursus yang dipilih.';
$string['smartmenusdynamiccoursescoursecategorysubcats'] = 'Sertakan subkategori';
$string['smartmenusdynamiccoursescoursecategorysubcats_help'] = 'Jika dicentang, menu kursus dinamis juga akan berisi semua kursus dari subkategori kategori kursus yang dipilih.';
$string['smartmenusdynamiccoursesdaterange'] = 'Rentang tanggal';
$string['smartmenusdynamiccoursesdaterange_help'] = 'Daftar item menu kursus dinamis akan berisi semua kursus yang termasuk dalam rentang tanggal yang dipilih.';
$string['smartmenusdynamiccoursesdaterangefuture'] = 'Mendatang';
$string['smartmenusdynamiccoursesdaterangepast'] = 'Lampau';
$string['smartmenusdynamiccoursesdaterangepresent'] = 'Kini';
$string['smartmenusdynamiccoursesenrolmentrole'] = 'Peran pendaftaran';
$string['smartmenusdynamiccoursesenrolmentrole_help'] = 'Daftar item menu kursus dinamis akan berisi semua kursus tempat pengguna terdaftar dengan peran yang dipilih.';
$string['smartmenusexperimental'] = 'Harap diperhatikan: Fungsionalitas menu pintar sepenuhnya dapat digunakan dalam kondisi implementasi saat ini, tetapi harus <em>dianggap sebagai eksperimental</em> karena banyaknya kombinasi pengaturan yang masih dapat memicu masalah yang tidak terduga. Dengan latar belakang ini, harap uji menu pintar Anda dengan pengaturan menu individual secara menyeluruh. Jika Anda mengalami masalah dengan menu pintar, harap laporkan di <a href="https://github.com/moodle-an-hochschulen/moodle-theme_boost_union/issues">Github</a> dengan langkah-langkah yang jelas untuk mereproduksi.';
$string['smartmenusgeneralsectionheader'] = 'Pengaturan umum';
$string['smartmenusmenuaddnewitem'] = 'Tambahkan item menu';
$string['smartmenusmenucardform'] = 'Formulir kartu';
$string['smartmenusmenucardform_help'] = 'Pilih bentuk kartu untuk menu bergaya kartu, pilih antara persegi, potret, lanskap, atau lebar penuh.';
$string['smartmenusmenucardformfullwidth'] = 'Lebar penuh';
$string['smartmenusmenucardformlandscape'] = 'Lanskap';
$string['smartmenusmenucardformportrait'] = 'Potret';
$string['smartmenusmenucardformsquare'] = 'Persegi';
$string['smartmenusmenucardoverflowbehavior'] = 'Perilaku kartu yang meluap';
$string['smartmenusmenucardoverflowbehavior_help'] = 'Pilih bagaimana menu akan berperilaku saat meluap dari kontainernya, pilih antara menampilkan bilah gulir atau membungkus item yang meluap.';
$string['smartmenusmenucardoverflowbehaviornowrap'] = 'Tidak ada bungkus';
$string['smartmenusmenucardoverflowbehaviorwrap'] = 'Bungkus';
$string['smartmenusmenucardsize'] = 'Ukuran kartu';
$string['smartmenusmenucardsize_help'] = 'Pilih ukuran kartu untuk menu bergaya kartu, pilih antara kecil, kecil, sedang, atau besar.';
$string['smartmenusmenucardsizelarge'] = 'Besar';
$string['smartmenusmenucardsizemedium'] = 'Sedang';
$string['smartmenusmenucardsizesmall'] = 'Kecil';
$string['smartmenusmenucardsizetiny'] = 'Mungil';
$string['smartmenusmenucreate'] = 'Buat menu';
$string['smartmenusmenucreatesuccess'] = 'Menu pintar berhasil dibuat';
$string['smartmenusmenucssclass'] = 'Kelas CSS';
$string['smartmenusmenucssclass_help'] = 'Masukkan kelas CSS untuk menu. Kelas ini dapat digunakan untuk menerapkan gaya kustom pada menu.';
$string['smartmenusmenudeleteconfirm'] = 'Apakah Anda yakin ingin menghapus menu ini dari menu pintar?';
$string['smartmenusmenudeletesuccess'] = 'Menu pintar berhasil dihapus';
$string['smartmenusmenudescription'] = 'Deskripsi';
$string['smartmenusmenudescription_help'] = 'Deskripsi menu. Ini terutama akan digunakan sebagai dokumentasi internal, tetapi Anda juga dapat menampilkannya di dalam menu dengan menggunakan opsi \'Tampilkan deskripsi\'.';
$string['smartmenusmenuduplicate'] = 'Menu duplikat dan itemnya';
$string['smartmenusmenuduplicatesuccess'] = 'Menu dan item menunya berhasil diduplikasi';
$string['smartmenusmenuedit'] = 'Sunting menu';
$string['smartmenusmenueditsuccess'] = 'Menu pintar berhasil diperbarui';
$string['smartmenusmenuitemcardappearanceheader'] = 'Penampilan kartu';
$string['smartmenusmenuitemcardbackgroundcolor'] = 'Warna latar belakang kartu';
$string['smartmenusmenuitemcardbackgroundcolor_help'] = 'Pilih warna latar belakang untuk kartu item menu';
$string['smartmenusmenuitemcardimage'] = 'Gambar kartu';
$string['smartmenusmenuitemcardimage_help'] = 'Pilih gambar untuk ditampilkan di samping judul item menu dalam kartu.';
$string['smartmenusmenuitemcardimagealt'] = 'Teks alt gambar kartu';
$string['smartmenusmenuitemcardimagealt_help'] = 'Teks alt untuk gambar kartu item menu ini. Anda dapat menggunakan tempat {menutitle} untuk memasukkan judul item menu yang dikonfigurasi ke dalam teks alt Anda sendiri. Jika Anda membiarkan kolom ini kosong sepenuhnya, teks item menu akan digunakan secara otomatis sebagai teks alt.';
$string['smartmenusmenuitemcardtextcolor'] = 'Warna teks kartu';
$string['smartmenusmenuitemcardtextcolor_help'] = 'Pilih warna untuk kartu item menu.';
$string['smartmenusmenuitemcreate'] = 'Buat item menu';
$string['smartmenusmenuitemcreatesuccess'] = 'Item menu pintar berhasil dibuat';
$string['smartmenusmenuitemcssclass'] = 'Kelas CSS';
$string['smartmenusmenuitemcssclass_help'] = 'Masukkan kelas CSS untuk item menu. Kelas ini dapat digunakan untuk menerapkan gaya kustom pada item menu.';
$string['smartmenusmenuitemdeleteconfirm'] = 'Apakah Anda yakin ingin menghapus item menu ini dari menu pintar?';
$string['smartmenusmenuitemdeletesuccess'] = 'Item menu pintar berhasil dihapus';
$string['smartmenusmenuitemdisplayfield'] = 'Presentasi nama kursus';
$string['smartmenusmenuitemdisplayfield_help'] = 'Nama kursus yang akan digunakan sebagai judul item menu kursus dinamis. Pilih antara nama lengkap kursus dan nama singkat kursus';
$string['smartmenusmenuitemdisplayfieldcoursefullname'] = 'Nama lengkap kursus';
$string['smartmenusmenuitemdisplayfieldcourseshortname'] = 'Nama pendek kursus';
$string['smartmenusmenuitemdisplayoptions'] = 'Judul presentasi';
$string['smartmenusmenuitemdisplayoptions_help'] = 'Pilih bagaimana Anda ingin judul item menu ditampilkan.';
$string['smartmenusmenuitemdisplayoptionshidetitle'] = 'Sembunyikan teks judul dan tampilkan hanya ikon (di semua perangkat)';
$string['smartmenusmenuitemdisplayoptionshidetitlemobile'] = 'Sembunyikan teks judul dan tampilkan hanya ikon (di perangkat seluler)';
$string['smartmenusmenuitemdisplayoptionsshowtitleicon'] = 'Tampilkan teks dan ikon sebagai judul';
$string['smartmenusmenuitemduplicate'] = 'Duplikatkan item menu';
$string['smartmenusmenuitemduplicatesuccess'] = 'Item menu berhasil diduplikasi';
$string['smartmenusmenuitemedit'] = 'Sunting item menu';
$string['smartmenusmenuitemeditsuccess'] = 'Item menu pintar berhasil diperbarui';
$string['smartmenusmenuitemicon'] = 'Ikon';
$string['smartmenusmenuitemicon_help'] = 'Ikon yang akan ditampilkan di samping judul item menu.';
$string['smartmenusmenuitemlinktarget'] = 'Target tautan';
$string['smartmenusmenuitemlinktarget_help'] = 'Target untuk tautan item menu. Tautan item menu akan terbuka di target ini saat diklik (misalnya di jendela yang sama atau di tab baru).';
$string['smartmenusmenuitemlinktargetnewtab'] = 'Tab baru';
$string['smartmenusmenuitemlinktargetsamewindow'] = 'Jendela yang sama';
$string['smartmenusmenuitemlistsort'] = 'Penyortiran daftar kursus';
$string['smartmenusmenuitemlistsort_help'] = 'Daftar kursus akan diurutkan berdasarkan kriteria dan urutan yang dipilih. Pilih antara nama lengkap, nama pendek, ID kursus, dan nomor ID kursus sebagai kriteria yang dikombinasikan dengan urutan menaik dan menurun.';
$string['smartmenusmenuitemlistsortcourseidasc'] = 'ID Kursus menaik';
$string['smartmenusmenuitemlistsortcourseiddesc'] = 'ID Kursus menurun';
$string['smartmenusmenuitemlistsortcourseidnumberasc'] = 'Nomor ID kursus menaik';
$string['smartmenusmenuitemlistsortcourseidnumberdesc'] = 'Nomor ID kursus menurun';
$string['smartmenusmenuitemlistsortfullnameasc'] = 'Nama lengkap kursus menaik';
$string['smartmenusmenuitemlistsortfullnamedesc'] = 'Nama lengkap kursus menurun';
$string['smartmenusmenuitemlistsortshortnameasc'] = 'Nama pendek kursus menaik';
$string['smartmenusmenuitemlistsortshortnamedesc'] = 'Nama pendek kursus menurun';
$string['smartmenusmenuitemmode'] = 'Mode item menu';
$string['smartmenusmenuitemmode_help'] = '<p>Pilih mode tampilan item menu di dalam menu.</p><ul><li>Inline: Item menu ditampilkan sebagai item menu biasa di dalam menu. Ini adalah opsi bawaan.</li><li>Submenu: Item menu ditampilkan sebagai item submenu, yang dapat diluaskan atau diciutkan dengan mengklik item induk. Mode ini berguna untuk membangun level navigasi ketiga serta untuk item menu kursus dinamis, di mana daftar kursus dapat ditampilkan sebagai item submenu dari item menu ini. Judul item menu ini digunakan sebagai teks untuk item submenu.</li></ul>';
$string['smartmenusmenuitemnothingtodisplay'] = 'Belum ada item yang ditambahkan ke menu pintar ini. Harap tambahkan item ke menu ini.';
$string['smartmenusmenuitemorder'] = 'Urutan';
$string['smartmenusmenuitemorder_help'] = 'Atur ulang posisi item jika diperlukan. Semua item menu dalam menu akan diurutkan berdasarkan nilai pesanan ini.';
$string['smartmenusmenuitempresentationheader'] = 'Presentasi item menu';
$string['smartmenusmenuitemresponsive'] = 'Penyembunyian responsif';
$string['smartmenusmenuitemresponsive_help'] = 'Dengan mengaktifkan salah satu kotak centang ini, item menu akan disembunyikan pada perangkat dengan ukuran tampilan yang diberikan.';
$string['smartmenusmenuitemresponsivedesktop'] = 'Komputer';
$string['smartmenusmenuitemresponsivemobile'] = 'Seluler';
$string['smartmenusmenuitemresponsivetablet'] = 'Tablet';
$string['smartmenusmenuitemrestriction'] = 'Aturan akses';
$string['smartmenusmenuitems'] = 'Item menu';
$string['smartmenusmenuitemstructureheader'] = 'Struktur item menu';
$string['smartmenusmenuitemtextcount'] = 'Jumlah kata';
$string['smartmenusmenuitemtextcount_help'] = 'Tentukan jumlah kata maksimum yang akan ditampilkan sebagai judul dalam item menu kursus dinamis. Jika Anda membiarkan kolom ini kosong, judul akan ditampilkan secara penuh.';
$string['smartmenusmenuitemtextposition'] = 'Posisi teks kartu';
$string['smartmenusmenuitemtextposition_help'] = '<p>Pilih posisi teks item menu dalam kaitannya dengan gambar kartu, dengan memilih dari bawah gambar, hamparan atas, dan hamparan bawah.</p><ul><li>Hamparan atas: Menampilkan judul item menu di atas hamparan dan di bagian atas kartu.</li><li>Hamparan bawah: Menampilkan judul item menu di atas hamparan dan di bagian bawah kartu.</li><li>Di bawah gambar: Menampilkan judul item menu di bawah gambar kartu.</li></ul>';
$string['smartmenusmenuitemtextpositionbelowimage'] = 'Bawah gambar';
$string['smartmenusmenuitemtextpositionoverlaybottom'] = 'Hamparan bawah';
$string['smartmenusmenuitemtextpositionoverlaytop'] = 'Hamparan atas';
$string['smartmenusmenuitemtitle'] = 'Judul';
$string['smartmenusmenuitemtitle_help'] = 'Judul menu. Ini akan digunakan sebagai label item menu ini. Jika Anda ingin menampilkan pemisah di menu, pilih Heading sebagai jenis dan gunakan tanda pagar (###) sebagai judul.';
$string['smartmenusmenuitemtooltip'] = 'Keterangan alat';
$string['smartmenusmenuitemtooltip_help'] = 'Keterangan alat yang akan ditampilkan saat pengguna mengarahkan kursor ke item menu.';
$string['smartmenusmenuitemtype'] = 'Tipe item menu';
$string['smartmenusmenuitemtype_help'] = '<p>Pilih jenis item menu yang ingin Anda buat, pilih antara statis, judul, dokumentasi moodle, dan kursus dinamis.</p><ul><li>Statis: Item menu statis hanyalah tautan ke URL tetap yang tidak berubah.</li><li>Judul: Item menu judul digunakan untuk mengelompokkan item menu terkait bersama-sama di bawah judul umum. Item ini tidak memiliki tautan dan tidak dapat diklik.</li><li>Dokumentasi Moodle: Item menu dokumentasi moodle digunakan untuk menautkan ke artikel MoodleDocs yang sesuai, mirip dengan tautan MoodleDocs yang terletak di footer Moodle (ikon tanda tanya).</li><li>Kursus dinamis: Item menu kursus dinamis digunakan untuk menampilkan daftar kursus berdasarkan kriteria tertentu, seperti kategori kursus, peran pendaftaran kursus, status penyelesaian kursus, atau rentang tanggal. Konten yang ditampilkan dalam item menu kursus dinamis akan diperbarui secara otomatis saat kriteria berubah.</li></ul>';
$string['smartmenusmenuitemtypedocs'] = 'Dokumentasi Moodle';
$string['smartmenusmenuitemtypedynamiccourses'] = 'Kursus dinamis';
$string['smartmenusmenuitemtypeheading'] = 'Judul';
$string['smartmenusmenuitemtypestatic'] = 'Statis';
$string['smartmenusmenuitemurl'] = 'URL item menu';
$string['smartmenusmenuitemurl_help'] = 'URL statis untuk item menu. Ini adalah tautan yang akan diikuti saat item menu diklik.';
$string['smartmenusmenulocation'] = 'Lokasi menu';
$string['smartmenusmenulocation_help'] = '<p>Pilih lokasi di mana Anda ingin menu tersebut muncul di halaman:</p><ul><li>Navigasi utama berada di bagian atas halaman, di mana inti Moodle sudah menampilkan item navigasi Beranda, Dasbor, Kursus saya, dan Administrasi situs.</li><li>Bilah menu terletak di atas navigasi utama, di bagian atas halaman.</li><li>Menu pengguna dapat diakses dengan mengklik avatar pengguna di bilah navigasi.</li><li>Bilah bawah ditempatkan di bagian bawah layar dan dapat digunakan untuk menerapkan navigasi jempol guna memudahkan akses ke area penting, seperti dasbor, halaman kursus saya, atau beranda.</li></ul><p>Harap perhatikan bahwa setelah mengaktifkan bilah bawah, ikon hamburger akan digantikan oleh logo situs Anda, karena pengguna dapat mengakses navigasi utama menggunakan bilah bawah.</p>';
$string['smartmenusmenulocationbottom'] = 'Bilah bawah';
$string['smartmenusmenulocationmain'] = 'Navigasi utama';
$string['smartmenusmenulocationmenu'] = 'Bilah menu';
$string['smartmenusmenulocationuser'] = 'Menu pengguna';
$string['smartmenusmenumode'] = 'Mode menu';
$string['smartmenusmenumode_help'] = '<p>Pilih mode tampilan item menu.</p><ul><li>Submenu: Item menu ditampilkan sebagai submenu dengan judul menu sebagai simpul induk. Ini adalah opsi bawaan.</li><li>Inline: Item menu ditampilkan langsung di navigasi, satu demi satu. Harap perhatikan bahwa opsi ini tidak didukung untuk menu jenis kartu.</li></ul>';
$string['smartmenusmenumoremenubehavior'] = 'Perilaku menu lainnya';
$string['smartmenusmenumoremenubehavior_help'] = '<p>Pilih apa yang akan terjadi jika terdapat terlalu banyak menu yang tidak muat di lokasi menu.</p><ul><li>Jangan ubah apa pun: Tidak ada perilaku tertentu yang akan diberlakukan, menu yang berlebih akan dipindahkan ke menu \'Lainnya\' secara otomatis.</li><li>Paksa ke menu lainnya: Mode ini memindahkan menu langsung ke menu \'Lainnya\' meskipun masih ada ruang.</li><li>Tetap di luar menu lainnya: Mode ini membuat menu tetap berada di luar menu \'Lainnya\' selama mungkin – memindahkan menu berikutnya ke menu lainnya sebagai gantinya jika diperlukan.</li></ul><p>Harap perhatikan bahwa pengaturan ini hanya memengaruhi menu yang terletak di navigasi utama atau di area bilah menu.</p>';
$string['smartmenusmenumoremenubehaviorforceinto'] = 'Paksa ke menu lainnya';
$string['smartmenusmenumoremenubehaviorkeepoutside'] = 'Tetap di luar menu lainnya';
$string['smartmenusmenunothingtodisplay'] = 'Belum ada menu pintar yang dibuat. Silakan buat menu pintar pertama Anda untuk memulai.';
$string['smartmenusmenupresentationheader'] = 'Presentasi menu';
$string['smartmenusmenushowdescription'] = 'Tampilkan deskripsi';
$string['smartmenusmenushowdescription_help'] = '<p>Pilih apakah/bagaimana deskripsi akan ditampilkan di menu, pilih antara Tidak pernah, Atas, Bawah dan Bantuan.</p><ul><li>Tidak pernah: Jangan tampilkan deskripsi di menu dan gunakan hanya untuk keperluan internal. Ini adalah opsi bawaan.</li><li>Atas: Tampilkan deskripsi di bagian atas daftar item menu.</li><li>Bawah: Tampilkan deskripsi di akhir daftar item menu.</li><li>Bantuan: Tampilkan deskripsi sebagai ikon bantuan di dekat daftar item menu.</li></ul>';
$string['smartmenusmenushowdescriptionabove'] = 'Atas';
$string['smartmenusmenushowdescriptionbelow'] = 'Bawah';
$string['smartmenusmenushowdescriptionhelp'] = 'Bantuan';
$string['smartmenusmenushowdescriptionnever'] = 'Tidak pernah';
$string['smartmenusmenustructureheader'] = 'Struktur menu';
$string['smartmenusmenutitle'] = 'Judul';
$string['smartmenusmenutitle_help'] = 'Judul menu. Ini akan digunakan sebagai label simpul induk menu ini.';
$string['smartmenusmenutype'] = 'Tipe presentasi';
$string['smartmenusmenutype_help'] = '<p>Pilih jenis presentasi untuk menu, pilih antara daftar dan kartu.</p><ul><li>Daftar: Menu daftar terdiri dari tautan teks sederhana. Ini adalah opsi bawaan.</li><li>Kartu: Menu kartu terdiri dari kartu-kartu.</li></ul>';
$string['smartmenusmenutypecard'] = 'Kartu';
$string['smartmenusmenutypelist'] = 'Daftar';
$string['smartmenusmodeinline'] = 'Inline';
$string['smartmenusmodesubmenu'] = 'Submenu';
$string['smartmenusnorestrict'] = 'Tidak dibatasi';
$string['smartmenusoperator'] = 'Operator';
$string['smartmenusoperator_help'] = 'Pilih operator untuk kondisi kohor (Apa pun atau Semua)';
$string['smartmenusrestrictbyadminheader'] = 'Batasi visibilitas berdasarkan status admin situs';
$string['smartmenusrestrictbycohortsheader'] = 'Batasi visibilitas berdasarkan kohor';
$string['smartmenusrestrictbydateheader'] = 'Batasi visibilitas berdasarkan tanggal';
$string['smartmenusrestrictbylanguageheader'] = 'Batasi visibilitas berdasarkan bahasa';
$string['smartmenusrestrictbyrolesheader'] = 'Batasi visibilitas berdasarkan peran';
$string['smartmenusrolecontext'] = 'Konteks';
$string['smartmenusrolecontext_help'] = 'Pilih konteks di mana peran pengguna akan diperiksa (Hanya konteks apa pun atau konteks sistem)';
$string['smartmenussavechangesandconfigure'] = 'Simpan dan konfigurasikan item';
$string['smartmenussettings'] = 'Pengaturan menu pintar';
$string['speciallinksmarkupheading'] = 'Markup tautan spesial';
$string['starredcourseslinktargetsetting'] = 'Ikon roda gigi popover kursus berbintang tautan target';
$string['starredcourseslinktargetsetting_desc'] = 'Dengan pengaturan ini, Anda dapat mengatur target tautan ikon roda gigi di popover kursus berbintang. Secara bawaan, ikon roda gigi terhubung ke halaman \'Kursus saya\'. Namun, Anda juga dapat terhubung ke halaman \'Dasbor\', terutama jika Anda telah menonaktifkan halaman \'Kursus saya\' di navigasi utama.';
$string['staticpagestab'] = 'Halaman statis';
$string['switchedroleto'] = 'Anda sedang melihat kursus ini saat ini dengan peran: <strong>{$a->role}</strong>';
$string['task_purgecache'] = 'Bersihkan cache tema';
$string['tertiarysettings'] = 'Daftar halaman pengaturan Boost Union';
$string['tilebackgroundimagepositionsetting'] = 'Posisi gambar latar belakang ubin iklan {$a->no}';
$string['tilebackgroundimagepositionsetting_desc'] = 'Dengan pengaturan ini, Anda mengendalikan posisi gambar latar belakang dalam kontainer ubin iklan {$a->no}. Nilai pertama adalah posisi horizontal, nilai kedua adalah posisi vertikal.';
$string['tilebackgroundimagesetting'] = 'Ubin iklan {$a->no} gambar latar belakang';
$string['tilebackgroundimagesetting_desc'] = 'Di sini, Anda dapat mengunggah berkas gambar yang akan ditampilkan sebagai gambar latar di balik konten ubin iklan {$a->no}. Pastikan atau periksa apakah konten masih dapat dibaca pada gambar latar. Ini adalah pengaturan opsional, ubin iklan akan berfungsi meskipun Anda tidak mengunggah gambar latar apa pun.';
$string['tilecolumnssetting'] = 'Jumlah kolom ubin iklan per baris';
$string['tilecolumnssetting_desc'] = 'Di sini, Anda menentukan jumlah kolom per baris dalam kisi ubin iklan yang disajikan. Harap perhatikan bahwa jumlah kolom ini berlaku untuk komputer / layar yang lebih besar. Pada layar yang lebih kecil dan layar seluler, kolom ubin iklan dibungkus secara otomatis.';
$string['tilecontentsetting'] = 'Ubin iklan {$a->no} konten';
$string['tilecontentsetting_desc'] = 'Di sini, Anda memasukkan konten yang akan ditampilkan di petak iklan {$a->no}. Konten ditampilkan di tengah petak. Ini adalah pengaturan opsional, petak iklan akan ditampilkan bahkan jika Anda tidak mengatur konten apa pun.';
$string['tilecontentstylesetting'] = 'Ubin iklan {$a->no} gaya konten';
$string['tilecontentstylesetting_dark'] = 'Gelap (warna font hitam untuk gambar latar belakang terang)';
$string['tilecontentstylesetting_darkshadow'] = 'Gelap & Bayangan (warna font hitam dengan bayangan terang untuk gambar latar belakang terang)';
$string['tilecontentstylesetting_desc'] = 'Di sini, Anda dapat mengubah gaya konten ubin iklan {$a->no}. Secara bawaan, gaya konten dikontrol oleh gaya yang Anda tetapkan di penyunting teks kaya di atas. Namun, untuk memungkinkan penataan gaya yang konsisten dan mudah terutama saat menggunakan teks pada gambar latar belakang, Anda dapat mengganti gaya di sini.';
$string['tilecontentstylesetting_light'] = 'Terang (warna font putih untuk gambar latar belakang gelap)';
$string['tilecontentstylesetting_lightshadow'] = 'Cahaya & Bayangan (warna font putih dengan bayangan gelap untuk gambar latar belakang gelap)';
$string['tilecontentstylesetting_nochange'] = 'Tidak ada perubahan (mengendalikan semua gaya di penyunting teks kaya)';
$string['tileenabledsetting'] = 'Aktifkan ubin iklan {$a->no}';
$string['tileenabledsetting_desc'] = 'Dengan pengaturan ini, Anda dapat mengaktifkan ubin iklan {$a->no}.';
$string['tilefrontpagepositionsetting'] = 'Posisi ubin iklan di beranda situs';
$string['tilefrontpagepositionsetting_after'] = 'Setelah konten beranda situs';
$string['tilefrontpagepositionsetting_before'] = 'Sebelum konten beranda situs';
$string['tilefrontpagepositionsetting_desc'] = 'Ubin iklan hanya ditampilkan di beranda situs. Dengan pengaturan ini, Anda dapat mengontrol apakah ubin iklan ditampilkan sebelum konten beranda situs atau setelah konten beranda situs. Jika Anda ingin hanya menampilkan ubin iklan di beranda situs dan tidak ada yang lain, semua konten beranda situs lainnya dapat dihapus dengan mengubah <a href="{$a->url}">pengaturan beranda situs</a>.';
$string['tileheading'] = 'Ubin iklan {$a->no}';
$string['tileheightsetting'] = 'Tinggi ubin iklan';
$string['tileheightsetting_desc'] = 'Dengan pengaturan ini, Anda dapat mengontrol tinggi ubin iklan. Tinggi yang dikonfigurasi adalah tinggi minimum setiap ubin. Jika konten ubin lebih tinggi dari tinggi yang dikonfigurasi ini, seluruh baris ubin akan secara otomatis dibuat lebih tinggi sesuai kebutuhan.';
$string['tilelinksetting'] = 'URL tautan ubin iklan {$a->no}';
$string['tilelinksetting_desc'] = 'Di sini, Anda dapat menyetel URL (Moodle-internal atau eksternal) yang akan ditawarkan sebagai tombol tautan di akhir ubin iklan {$a->no}. Ini adalah pengaturan opsional, ubin iklan akan berfungsi bahkan jika Anda tidak menyetel URL tautan apa pun.';
$string['tilelinktargetsetting'] = 'Iklan ubin {$a->no} target tautan';
$string['tilelinktargetsetting_desc'] = 'Di sini, Anda dapat menetapkan target tautan yang ditetapkan untuk tombol tautan segera setelah Anda menetapkan URL tautan di ubin iklan {$a->no}.';
$string['tilelinktargetsetting_newtab'] = 'Tab baru';
$string['tilelinktargetsetting_samewindow'] = 'Jendela yang sama';
$string['tilelinktitlefallback'] = 'Tautan';
$string['tilelinktitlesetting'] = 'Judul tautan ubin iklan {$a->no}';
$string['tilelinktitlesetting_desc'] = 'Di sini, Anda dapat menetapkan judul tautan yang digunakan sebagai label tombol tautan segera setelah Anda menetapkan URL tautan di petak iklan {$a->no}. Harap perhatikan bahwa jika Anda menetapkan URL tautan tetapi tidak menetapkan judul tautan, tombol tautan hanya akan diberi label \'Tautan\'.';
$string['tileordersetting'] = 'Posisi urutan ubin iklan {$a->no}';
$string['tileordersetting_desc'] = 'Dengan pengaturan ini, Anda menentukan posisi urutan ubin iklan {$a->no}. Secara bawaan, ubin iklan diurutkan dari atas ke bawah dan kiri ke kanan seperti yang Anda lihat di halaman pengaturan ini. Namun, Anda dapat memutuskan untuk menugaskan posisi urutan lain dengan pengaturan ini. Jika Anda menetapkan posisi urutan yang sama ke dua atau lebih ubin iklan, ubin tersebut akan diurutkan lagi sesuai dengan urutan di halaman pengaturan ini.';
$string['tilesgeneralheading'] = 'Ubin iklan umum';
$string['tilestab'] = 'Ubin iklan';
$string['tiletitlesetting'] = 'Judul ubin iklan {$a->no}';
$string['tiletitlesetting_desc'] = 'Di sini, Anda memasukkan judul yang akan ditampilkan di petak iklan {$a->no}. Ini adalah pengaturan opsional, petak iklan akan ditampilkan bahkan jika Anda tidak menetapkan judul.';
$string['timelineheading'] = 'Blok garis waktu';
$string['timelinetintenabled'] = 'Warna ikon aktivitas garis waktu';
$string['timelinetintenabled_desc'] = 'Dengan pengaturan ini, Anda dapat mewarnai ikon aktivitas di blok garis waktu berdasarkan tujuan aktivitas. Secara bawaan, inti Moodle menampilkannya hanya sebagai ikon hitam.';
$string['touchiconfilesios'] = 'Sentuh berkas ikon untuk iOS';
$string['touchiconfilesios_desc'] = 'Dalam pengaturan ini, Anda dapat mengunggah berkas yang digunakan sebagai ikon layar beranda segera setelah situs Moodle ditambahkan ke layar beranda iOS sebagai penanda.';
$string['touchiconfilesios_example'] = 'Contoh nama berkas: apple-icon-152x152.png';
$string['touchiconfilesios_note'] = 'Berkas yang direkomendasikan memiliki ukuran yang baik untuk ditampilkan dengan benar pada perangkat iOS terkini dan harus disediakan. Berkas opsional didukung (atau sebelumnya pernah didukung) oleh perangkat iOS juga, tetapi harus benar-benar dianggap opsional kecuali Anda memiliki perangkat lama tertentu yang perlu didukung.';
$string['touchiconfilesios_optional'] = 'Berkas opsional untuk iOS:';
$string['touchiconfilesios_recommended'] = 'Berkas yang direkomendasikan untuk iOS:';
$string['touchiconfilesioslist'] = 'Daftar berkas ikon sentuh untuk iOS';
$string['touchiconfilesioslist_desc'] = 'Ini adalah daftar berkas yang telah Anda unggah ke berkas ikon sentuh untuk area berkas iOS.';
$string['touchiconlistiosoptionalmissing'] = 'Ini adalah berkas opsional untuk digunakan sebagai ikon sentuh pada perangkat iOS dan tidak diunggah.';
$string['touchiconlistiosoptionaluploaded'] = 'Ini adalah berkas opsional untuk digunakan sebagai ikon sentuh pada perangkat iOS dan telah diunggah.';
$string['touchiconlistiosrecommendedmissing'] = 'Ini adalah berkas yang direkomendasikan untuk digunakan sebagai ikon sentuh pada perangkat iOS, tetapi tidak diunggah dengan benar.';
$string['touchiconlistiosrecommendeduploaded'] = 'Ini adalah berkas yang direkomendasikan untuk digunakan sebagai ikon sentuh pada perangkat iOS dan telah diunggah.';
$string['upcomingeventsheading'] = 'Blok acara mendatang';
$string['upcomingeventstintenabled'] = 'Warna ikon aktivitas acara mendatang';
$string['upcomingeventstintenabled_desc'] = 'Dengan pengaturan ini, Anda dapat mewarnai ikon aktivitas di blok acara mendatang berdasarkan tujuan aktivitas. Secara bawaan, inti Moodle menampilkannya hanya sebagai ikon hitam.';
$string['upgradenotice_2022080922'] = 'Sejak rilis ini, Boost Union memiliki logo sendiri dan pengaturan logo ringkas dan tidak lagi menggunakan berkas-berkas ini dari pengaturan inti Moodle.';
$string['upgradenotice_2022080922_copied'] = '<strong>{$a}</strong> yang ada dari pengaturan inti Moodle telah disalin ke pengaturan Boost Union {$a} selama pemutakhiran ini. Harap periksa kembali hasilnya.';
$string['upgradenotice_2022080922_logo'] = 'logo';
$string['upgradenotice_2022080922_logocompact'] = 'logo ringkas';
$string['upgradenotice_2022080922_notcopied'] = 'Pengaturan <strong>{$a}</strong> dalam Boost Union sekarang kosong. Jika Anda ingin menggunakan {$a} dalam Boost Union mulai sekarang, unggah saja ke pengaturan Boost Union {$a} nanti.';
$string['usermenuheading'] = 'Menu pengguna';
$string['warningslashargumentsdisabled'] = 'Peringatan: <a href="{$a->url}">Pengaturan argumen slash</a> saat ini dinonaktifkan dalam konfigurasi Moodle Anda. Namun, pengaturan ini diperlukan untuk pengoperasian pengaturan Boost Union berikut dengan benar. Harap aktifkan argumen slash, jika tidak, pengaturan Boost Union berikut tidak akan berpengaruh.';
