<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'cachestore_redis', language 'no', version '4.4'.
 *
 * @package     cachestore_redis
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['ca_file'] = 'CA sti';
$string['ca_file_help'] = 'Plassering av CA-fil på lokalt filsystem';
$string['clustermode'] = 'Cluster mode';
$string['clustermode_help'] = 'Enabling cluster mode will run the Redis Cluster function, allowing your server to serve multiple servers to handle concurrent requests simultaneously.';
$string['clustermodeunavailable'] = 'Redis Cluster is currently unavailable. Please ensure that the PHP Redis extension supports Redis Cluster functionality.';
$string['compressor_none'] = 'Ingen nedpakking';
$string['compressor_php_gzip'] = 'Bruk gzip';
$string['compressor_php_zstd'] = 'Bruk Zstandard';
$string['connectiontimeout'] = 'Connection timeout';
$string['connectiontimeout_help'] = 'Dette bestemmer timeout ved forsøk på tilkobling til Redisserveren.';
$string['encrypt_connection'] = 'Bruk TLS-kryptering';
$string['encrypt_connection_help'] = 'Bruk TLS for å koble til Redis. Ikke bruk \'tls://\' i vertsnavnet for Redis, bruk dette alternativet i stedet.';
$string['password'] = 'Passord';
$string['password_help'] = 'Dette besttemer passordet for Redis serveren.';
$string['pluginname'] = 'Redis';
$string['prefix'] = 'Nøkkelprefiks';
$string['prefix_help'] = 'Dette prefikset brukes for alle nøkkelnavn på Redis-serveren.
*Hvis du bare har en Moodleinstallasjon på denne serveren, så kan du bruke standardverdien
*På grunn av lengderestriksjoner kan du maksimalt bruke 5 tegn';
$string['prefixinvalid'] = 'Ugyldig prefiks. Du kan bare bruker a-z A-Z 0-9 -_.';
$string['privacy:metadata:redis'] = 'Modulen "Redis cachestore" lagrer data i kort tid som en del av sin mellomlagringsfunksjonalitet. Dataene lagres på en Redisserver der data regelmessig blir fjernet.';
$string['privacy:metadata:redis:data'] = 'De ulike dataene lagret i cachen.';
$string['serializer_igbinary'] = 'Igbinære serialiserer';
$string['serializer_php'] = 'Standard PHP serialisering';
$string['server'] = 'Server(e)';
$string['server_help'] = 'Redis-server som skal brukes til testing.

Noen eksempelverdier:

* testredis.abc.com - For å koble til en Redis-server med vertsnavn (Port 6379 som standard).
* testredis.abc.com:1234 - For å koble til en Redis-server med vertsnavn med en spesifikk port.
* 1.2.3.4 - For å koble til en Redis-server med IP-adresse (port 6379 som standard).
* 1.2.3.4:1234 - For å koble til en Redis-server med IP-adresse med en spesifikk port.
* unix:///var/redis.sock - For å koble til en Redis-server ved hjelp av en Unix-socket.
* /var/redis.sock - For å koble til en Redis-server ved hjelp av en Unix-socket (alternativt format).

Dersom cluster mode er aktivert, spesifiser servere på separate linje, f.eks.:<br>
  172.23.0.11<br>
  172.23.0.12<br>
  172.23.0.13<br>

Se <a href="https://redis.io/docs/reference/clients/#accepting-client-connections" target="_new">Godta klienttilkoblinger</a> og <a href="https:// redis.io/resources/clients/#php" target="_new">Redis PHP-klienter</a> for mer informasjon.';
$string['task_ttl'] = 'Frigjør minne som brukes av utløpte oppføringer i Redis-cacher';
$string['test_clustermode'] = 'Cluster mode';
$string['test_clustermode_desc'] = 'Enable Test in Redis Cluster mode.';
$string['test_password'] = 'Testserverpassord';
$string['test_password_desc'] = 'Redis testserverpassord';
$string['test_serializer'] = 'Serialisering';
$string['test_serializer_desc'] = 'Serialisering for testformål';
$string['test_server'] = 'Testserver';
$string['test_server_desc'] = 'Redis-server som skal brukes til testing.

Noen eksempelverdier:

* testredis.abc.com - For å koble til en Redis-server med vertsnavn (Port 6379 som standard).
* testredis.abc.com:1234 - For å koble til en Redis-server med vertsnavn med en spesifikk port.
* 1.2.3.4 - For å koble til en Redis-server med IP-adresse (port 6379 som standard).
* 1.2.3.4:1234 - For å koble til en Redis-server med IP-adresse med en spesifikk port.
* unix:///var/redis.sock - For å koble til en Redis-server ved hjelp av en Unix-socket.
* /var/redis.sock - For å koble til en Redis-server ved hjelp av en Unix-socket (alternativt format).

Dersom cluster mode er aktivert, spesifiser servere på separate linje, f.eks.:<br>
  172.23.0.11<br>
  172.23.0.12<br>
  172.23.0.13<br>

Se <a href="https://redis.io/docs/reference/clients/#accepting-client-connections" target="_new">Godta klienttilkoblinger</a> og <a href="https:// redis.io/resources/clients/#php" target="_new">Redis PHP-klienter</a> for mer informasjon.';
$string['test_ttl'] = 'Tester TTL';
$string['test_ttl_desc'] = 'Kjør ytelsestesten med en hurtigbuffer som krever TTL (langsommere sett).';
$string['usecompressor'] = 'Bruk nedpakker';
$string['usecompressor_help'] = 'Angir kompressoren som skal brukes etter serialisering. Det gjøres på Moodle Cache API-nivå, ikke på php-redis-nivå.';
$string['useserializer'] = 'Bruker serialisering';
$string['useserializer_help'] = 'Angi serialiseringsmodul som skal brukes til serialisering';
