<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'error', language 'no', version '4.4'.
 *
 * @package     error
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['TODO'] = 'GJØREMÅL';
$string['activityisscheduledfordeletion'] = 'Aktivitetssletting foregår...';
$string['agedigitalconsentmapinvalidage'] = '"{$a}" er ikke en gyldig verdi for alder.';
$string['agedigitalconsentmapinvalidcomma'] = '"{$a}" har mer eller mindre enn ent kommaskilletegn.';
$string['agedigitalconsentmapinvalidcountry'] = '"{$a}" er ikke en gyldig verdi for land.';
$string['agedigitalconsentmapinvaliddefault'] = 'Standardverdi (*) mangler.';
$string['agelocationverificationdisabled'] = 'Alders- og stedsbekreftelse er deaktivert.';
$string['alreadyloggedin'] = 'Du er allerede logget inn som {$a}. Du må logge ut før du logger inn som en annen bruker.';
$string['authnotexisting'] = 'Autoriseringsmodulen eksisterer ikke';
$string['backupcontainexternal'] = 'Denne sikkerhetskopifilen inneholder ekstern Moodle Nettverk vert som ikke er konfigurert på denne portalen';
$string['backuptablefail'] = 'Backuptabell kunne IKKE konfigureres ordentlig.';
$string['blockcannotconfig'] = 'Denne boksen støtter ikke global konfigurasjon';
$string['blockcannotinistantiate'] = 'Problemer med å instansiering av blokkobjekt.';
$string['blockcannotread'] = 'Kunne ikke lese data for blockid= {$a}';
$string['blockdoesnotexist'] = 'Denne blokken eksisterer ikke';
$string['blockdoesnotexistonpage'] = 'Denne blokken (id={$a->instanceid}) eksisterer ikke på denne siden  ({$a->url}).';
$string['blocknameconflict'] = 'Navnekonflikt: block {$a->name} har samme tittel som den eksisterende blokken: {$a->conflict}!';
$string['callbackrejectcomment'] = 'Modulen avviser å legge til denne kommentaren';
$string['cannotaddcoursemodule'] = 'Kunne ikke legge til ny kursmodul';
$string['cannotaddcoursemoduletosection'] = 'Kunne ikke legge til ny kursmodul i denne seksjonen';
$string['cannotaddmodule'] = '{$a} modulen kunne ikke legges til moduloversikten!';
$string['cannotaddnewmodule'] = 'Kunne ikke legge til ny modul med {$a}';
$string['cannotaddrss'] = 'Du har ikke tillatelse til å legge til RSS-agenter';
$string['cannotaddthisblocktype'] = 'Du kan ikke legge til en {$a} blokk på denne siden.';
$string['cannotassignrole'] = 'Kan ikke tildele rolle i kurset';
$string['cannotassignrolehere'] = 'Du har ikke tillatelse til å tildele rollen (id = {$a->roleid}) i konteksten ({$a->context})';
$string['cannotassignselfasparent'] = 'Kan ikke tildele seg selv overordnet status!';
$string['cannotcallscript'] = 'Du kan ikke kalle dette skriptet på denne måten.';
$string['cannotcallusgetselecteduser'] = 'Du kan ikke kalle user_selector::get_selected_user dersom flervalg er gjort.';
$string['cannotcreatebackupdir'] = 'Kunne ikke opprette mappe for sikkerhetskopi. Portaladministrator må sette korrekt filtilgang.';
$string['cannotcreatecategory'] = 'Kategorien ble ikke lagt til';
$string['cannotcreatedboninstall'] = '<p>Kan ikke opprette databasen.</p>
<p>Den angitte databasen eksisterer ikke og oppgitt bruker har ikke rettigheter til å opprette databasen.</p>
<p>Portaladministratoren må derfor verifisere databaseoppsettet.</p>';
$string['cannotcreategroup'] = 'Feil ved oppretting av gruppe';
$string['cannotcreatelangbase'] = 'Feil: Kunne ikke opprette hovedspråk kategori';
$string['cannotcreatelangdir'] = 'Kan ikke opprette mappen \'lang\'.';
$string['cannotcreateorfindstructs'] = 'Det oppstod en feil ved søk eller opprettelse av seksjonsstruktur for dette kurset';
$string['cannotcreatepopupwin'] = 'Udefinert element -  kan ikke opprette popup-vindu.';
$string['cannotcreatesitedir'] = 'Kan ikke opprette portalmappe. Portaladministratoren må korrigere filrettighetene.';
$string['cannotcreatetempdir'] = 'Kan ikke opprette mappen \'temp';
$string['cannotcreateuploaddir'] = 'Kan ikke opprette opplastingsmappe. Portaladministratoren må korrigere filrettighetene.';
$string['cannotcustomisefiltersblockuser'] = 'Du kan ikke tilpasse filterinstillingene i en bruker- eller blokk-kontekst.';
$string['cannotdeletebackupids'] = 'Kunne ikke slette forrige sikkerhetskopi id-er.';
$string['cannotdeletecategorycourse'] = 'Kurset \'{$a}\' ble ikke slettet som det skulle.';
$string['cannotdeletecategoryquestions'] = 'Kunne ikke slette spørsmål fra kategorien \'{$a}\'';
$string['cannotdeletecourse'] = 'Du har ikke tillatelse til å slette dette kurset';
$string['cannotdeletecustomfield'] = 'Feil ved sletting av egedefinerte feltdata';
$string['cannotdeletedir'] = 'Kan ikke slette ({$a})';
$string['cannotdeletefile'] = 'Kan ikke slette denne filen';
$string['cannotdeleterole'] = 'Det kan ikke slettes fordi {$a}';
$string['cannotdeleterolewithid'] = 'Kunne ikke slette rollen med ID {$a}';
$string['cannotdeletethisrole'] = 'Du kan ikke slette denne rollen fordi den brukes av systemet eller fordi det er den siste rollen med administrative rettigheter.';
$string['cannotdisableformat'] = 'Du kan ikke deaktivere standardformatet';
$string['cannotdownloadcomponents'] = 'Kan ikke laste ned komponentene.';
$string['cannotdownloadlanguageupdatelist'] = 'Kan ikke laste ned oversikten over språkoppdateringer fra download.moodle.org';
$string['cannotdownloadzipfile'] = 'Kan ikke laste ned ZIP-fil.';
$string['cannoteditcomment'] = 'Du kan ikke redigere en kommentar du ikke har skrevet selv!';
$string['cannoteditcommentexpired'] = 'Du kan ikke redigere dette. Redigeringstiden er utløpt!';
$string['cannoteditpostorblog'] = 'Du kan ikke poste innlegg i eller redigere blogger';
$string['cannoteditsiteform'] = 'Du kan ikke redigere portalkurset med dette skjemaet';
$string['cannotedituserpreferences'] = 'Kan ikke redigere denne brukerens preferanser';
$string['cannotedityourprofile'] = 'Beklager, du kan ikke redigere egen profil';
$string['cannotexecduringupgrade'] = 'Kan ikke utføres under oppgradering';
$string['cannotfindcategory'] = 'Kan ikke finne kategorioppføring fra databasen med ID - {$a}';
$string['cannotfindcomponent'] = 'Kan ikke finne komponenten.';
$string['cannotfindcontext'] = 'Kan ikke finne konteksten';
$string['cannotfindcourse'] = 'Kan ikke finne kursetq';
$string['cannotfinddocs'] = 'Kan ikke finne "{$a}" språkets dokumentasjonsfiler';
$string['cannotfindgradeitem'] = 'Kan ikke finne vurderingselement';
$string['cannotfindgroup'] = 'Ikke i stand til å finne gruppen';
$string['cannotfindhelp'] = 'Kan ikke finne "{$a}" språkets hjelp-filer';
$string['cannotfindinfo'] = 'Kan ikke finne informasjon for: "{$a}"';
$string['cannotfindlang'] = 'Kan ikke finne språkpakken "{$a}"!';
$string['cannotfindteacher'] = 'Kan ikke finne lærer';
$string['cannotfinduser'] = 'Kan ikke finne brukeren "{$a}"';
$string['cannotgeoplugin'] = 'Kan ikke koble til geoPlugin server på http://www.geoplugin.com. Vennligst sjekk proxy-innstillinger eller enda bedre: Installer MaxMind GeoLite City datafilen.';
$string['cannotgetblock'] = 'Kunne ikke motta blokker fra databasen';
$string['cannotgetcats'] = 'Kan ikke hente kategorioversikten';
$string['cannotgetdata'] = 'Kan ikke innhente data';
$string['cannotgradeuser'] = 'Kan ikke gi karakter til denne brukeren';
$string['cannothaveparentcate'] = 'Kurskategorien kan ikke ha overordnet kategori!';
$string['cannotimport'] = 'Importfeil';
$string['cannotimportformat'] = 'Beklager, import av dette formatet er ikke implementert ennå!';
$string['cannotimportgrade'] = 'Feil ved karakterimport';
$string['cannotinsertgrade'] = 'Kan ikke legge til vurderingselement uten kurs ID!';
$string['cannotinsertrate'] = 'Kunne ikke legge til ny vurdering ({$a->id} = {$a->rating})';
$string['cannotinsertrecord'] = 'Kan ikke legge til ny oppføring ID {$a}';
$string['cannotmailconfirm'] = 'Feil ved sending av mail om passordendring';
$string['cannotmanualctrack'] = 'Aktiviteten tilbyr ikke manuell sporing av fullføring';
$string['cannotmapfield'] = 'Mappingskonflikt oppdaget - to felter mapper til samme vurderingselement {$a}';
$string['cannotmarktopic'] = 'Kunne ikke merke denne seksjonen for dette kurset';
$string['cannotmigratedatacomments'] = 'Kan ikke migrere datamodul kommentarer';
$string['cannotmodulename'] = 'Kan ikke hente modulnavnet når navigeringen bygges';
$string['cannotmoduletype'] = 'Kan ikke hente modultype når navigeringen bygges';
$string['cannotmovecategory'] = 'Kan ikke flytte kategori';
$string['cannotmovecourses'] = 'Kan ikke flytte kursene fra kategorine de tilhører til en annen kategori.';
$string['cannotmoverolewithid'] = 'Kan ikke flytte rolle med ID {$a}';
$string['cannotopencsv'] = 'Kan ikke åpne CSV-fil en';
$string['cannotopenfile'] = 'Kan ikke åpne filen ({$a})';
$string['cannotopenforwrit'] = 'Kan ikke åpne for redigering: {$a}';
$string['cannotopentemplate'] = 'Kan ikke åpne malfilen ({$a})';
$string['cannotopenzip'] = 'Kan ikke åpne zip-filen, trolig en feil i zip-tillegget på 64bit OS.';
$string['cannotoverridebaserole'] = 'Kan ikke overstyre grunnleggende rollefunksjoner';
$string['cannotoverriderolehere'] = 'Du har ikke tillatelse til å overstyre denne rollen  (id = {$a->roleid}) i denne konteksten ({$a->context}) ';
$string['cannotreadfile'] = 'Kan ikke lese filen  ({$a})';
$string['cannotreadtmpfile'] = 'Feil ved lesing av midlertidig fil';
$string['cannotreaduploadfile'] = 'Kunne ikke lese den opplastede filen';
$string['cannotremovefrommeta'] = 'Kunne ikke fjerne valgte kurs fra dette metakurset!';
$string['cannotreprocessgrades'] = 'Kunne ikke beregne karakterer på nytt for denne aktiviteten.';
$string['cannotresetguestpwd'] = 'Du kan ikke tilbakestille gjestepassordet';
$string['cannotresetmail'] = 'Feil ved tilbakestilling av passord og epostsending til deg';
$string['cannotresetthisrole'] = 'Kan ikke tilbakestille denne rollen';
$string['cannotrestore'] = 'Det oppstod en feil og gjenopprettingen kunne ikke fullføres!';
$string['cannotrestoreadminorcreator'] = 'Du må være kursoppretter eller administrator for å gjenopprette til et nytt kurs!';
$string['cannotrestoreadminoredit'] = 'Du må være lærer eller administrator for å gjenopprette til valgte kurs!';
$string['cannotsaveagreement'] = 'Kunne ikke lagre bekreftelsen din';
$string['cannotsaveblock'] = 'Feil ved lagring av blokkoppsettet';
$string['cannotsavecomment'] = 'Kan ikke lagre kommentaren';
$string['cannotsavedata'] = 'Kan ikke lagre data';
$string['cannotsavefile'] = 'Kan ikke lagre filen "{$a}"!';
$string['cannotsavemd5file'] = 'Kan ikke lagre md5-fil.';
$string['cannotsavezipfile'] = 'Kan ikke lagre ZIP-fil.';
$string['cannotservefile'] = 'Kan ikke håndtere filen - det kan være et konfigurasjonsproblem på serveren.';
$string['cannotsetparentforcatoritem'] = 'Kan ikke angi overordnet for kategorien eller kurselementet!';
$string['cannotsetpassword'] = 'Kunne ikke angi nytt brukerpassord!';
$string['cannotsetprefgrade'] = 'Kunne ikke angi innstillinger for hvordan $a} skal vises for denne karakterkategorien.';
$string['cannotsettheme'] = 'Kan ikke angi nytt design!';
$string['cannotsetupblock'] = 'Blokktabellene ble ikke satt opp korrekt!';
$string['cannotsetupcapformod'] = 'Kunne ikke angi funksjonene for {$a}';
$string['cannotsetupcapforplugin'] = 'Kunne ikke angi funksjonene for {$a}';
$string['cannotshowhidecoursesincategory'] = 'Kan ikke vise/skjule kursens i kategorien {$a}';
$string['cannotsignup'] = 'Du kan ikke opprette en ny konto fordi du allerede er logget inn som {$a}.';
$string['cannotswitcheditmodeon'] = 'Kunne ikke slå på redigeringsmodus';
$string['cannotunassigncap'] = 'Kunne ikke fradele undertrykket funksjon {$a->cap} fra rollen {$a->role}';
$string['cannotunassignrolefrom'] = 'Kan ikke fradele denne brukeren fra rolleID: {$a}';
$string['cannotunzipfile'] = 'Kan ikke pakke opp filen.';
$string['cannotupdatemod'] = 'Kunne ikke oppdatere {$a}';
$string['cannotupdatepasswordonextauth'] = 'Oppdatering av passord via extern autentisering: {$a} var mislykket. Se i serverloggen for flere detaljer.';
$string['cannotupdateprofile'] = 'Feil ved oppdatering av brukeroppføring';
$string['cannotupdaterecord'] = 'Kan ikke oppdatere oppføring ID ???';
$string['cannotupdaterss'] = 'Kan ikke oppdatere RSS';
$string['cannotupdatesubcourse'] = 'Kunne ikke oppdatere underordnet kurs!';
$string['cannotupdateusermsgpref'] = 'Kan ikke oppdatere brukerens meldingspreferanser';
$string['cannotupdateuseronexauth'] = 'Oppdatering av brukerdata via ekstern autentisering; {$a} var mislykket. Se i serverloggen for flere detaljer.';
$string['cannotuploadfile'] = 'Feil ved behandling av opplastet fil.';
$string['cannotuseadmin'] = 'Denne siden er bare for administratorer';
$string['cannotuseadminadminorteacher'] = 'Denne siden er bare for lærere og administratorer';
$string['cannotusepage'] = 'Denne siden er bare for lærere og administratorer';
$string['cannotusepage2'] = 'Beklager, du kan ikke bruke denne siden';
$string['cannotviewcategory'] = 'Du har ikke tillatelser til å se kurs her.';
$string['cannotviewprofile'] = 'Du kan ikke se profilen på  denne brukeren.';
$string['cannotviewreport'] = 'Du har ikke tillatelse til å se denne rapporten';
$string['cannotwritefile'] = 'Kan ikke skrive til filen  ({$a})';
$string['categoryerror'] = 'Kategorifeil';
$string['categoryidnumbertaken'] = 'ID-nummeret er allerede brukt i en annen kategori';
$string['categorynamerequired'] = 'Kategorinavn er påkrevd';
$string['categorytoolong'] = 'Kategorinavnet er for langt';
$string['commentmisconf'] = 'Kommentar ID er feilkonfigurert';
$string['componentisuptodate'] = 'Komponenten er oppdatert';
$string['confirmationnotenabled'] = 'Brukerbekrefting er deaktivert på denne portalen';
$string['confirmsesskeybad'] = 'Beklager, sesjonsnøkkelen din kunne ikke aksepteres for utførelse av denne handlingen. Denne sikkerhetssperren forhindrer tilfeldig eller ondsinnet utførelse av viktige funksjoner i ditt navn. Forsikr deg om at du virkelig ønsker å utføre denne funksjonen.';
$string['contenttypenotfound'] = 'Innholdsbanken \'{$a}\' eksisterer ikke eller blir ikke gjenkjent';
$string['contentvisibilitynotfound'] = 'Innholdssynligheten med verdien \'{$a}\' eksisterer ikke eller gjenkjennes ikke.';
$string['couldnotassignrole'] = 'En alvorlig uspesifisert feil oppsto da du skulle tildeles en rolle';
$string['couldnotupdatenoexistinguser'] = 'Kan ikke oppdatere brukeren - brukeren eksisterer ikke.';
$string['couldnotverifyagedigitalconsent'] = 'Det oppstod en feil under verifisering av alderen for samtykke.<br />Vennligst kontakt portaladministrator.';
$string['countriesphpempty'] = 'FEIL: Filen countries.php i språkpakken {$a} er tom eller mangler.';
$string['coursedoesnotbelongtocategory'] = 'Kurset hører ikke lenger til denne kategorien';
$string['courseformatnotfound'] = 'Kursformatet \'{$a}\' eksisterer ikke, eller kan ikke lenger brukes.';
$string['coursegroupunknown'] = 'Kurs som korresponderer til gruppe {$a} er ikke spesifisert';
$string['courseidnotfound'] = 'KursID-en eksisterer ikke';
$string['courseidnumbertaken'] = 'ID-nummeret er allerede i bruk for et annet kurs ({$a})';
$string['coursemisconf'] = 'Kurset er feilkonfigurert';
$string['courserequestdisabled'] = 'Beklager, men kursønsker er deaktivert av administrator.';
$string['csvcolumnduplicates'] = 'Oppdaget duplikate kolonner';
$string['csvemptyfile'] = 'CSV-fila er tom.';
$string['csvfewcolumns'] = 'Ikke nok kolonner, vennligst sjekk innstillinger for skille av feltene. (Komma, semikolon osv)';
$string['csvfileerror'] = 'Det er noe galt med formatet på CSV-filen. Kontroller at antall overskrifter og kolonner samsvarer, og at skilletegn og filkodingen er riktig: {$a}';
$string['csvinvalidcols'] = '<b>Ugyldig CSV-fil:</b> Første linje må ha med kolonnefeltdefinisjoner og filen må være av typen
 <br />"Expanded Fields/Comma Separated"<br />or<br /> "Expanded Fields with CAVV Result Code/Comma Separated"';
$string['csvinvalidcolsnum'] = 'Ugyldg CSV-fil - hver linje må være på 49 eller 70 felter';
$string['csvloaderror'] = 'Feil ved lasting av CSV-filen: {$a}';
$string['csvnodata'] = 'Ugyldig CSV-fil. CSV-fila har headere, men inneholder ikke noe data.';
$string['csvweirdcolumns'] = 'Ugyldig CSV-filformat - antall kolonner er ikke konstant!';
$string['dbconnectionfailed'] = '<p>FEIL: Databasekoblingen mislykkes</p>
<p>Det er mulig at databasen er overbelastet eller ikke kjører som den skal.</p>
<p>Portaladministrator bør også sjekke at databaseinformasjonen er korrekt angitt i config.php</p>';
$string['dbdriverproblem'] = '<p>FEIL: Databasedriverproblem oppdaget</p>
<p>Portaladministratoren må verifisere serveroppsettet</p><p>{$a}</p>';
$string['dbsessionbroken'] = 'Alvorlig database sesjonsproblem oppdaget. <br /><br />Vennligst kontakt serveradministratoren.';
$string['dbsessionhandlerproblem'] = 'Oppsettet av databasesesjonen mislykkes. Vennligst kontakt serveradministratoren.';
$string['dbsessionmysqlpacketsize'] = 'Alvorlig sesjonsfeil oppdaget. Vennligst kontakt administrator - dette problemet er trolig oppstått pga for lav verdi i max_allowed_packet MySQL innstillingene.';
$string['dbupdatefailed'] = 'Oppdateringen av databasen mislykkes.';
$string['ddldependencyerror'] = '{$a->targettype} "{$a->targetname}" kan ikke endres. Avhengighet funnet med {$a->offendingtype} "{$a->offendingname}"';
$string['ddlexecuteerror'] = 'DDL sql feil oppdaget';
$string['ddlfieldalreadyexists'] = 'Feltet "{$a}" eksisterer allerede';
$string['ddlfieldnotexist'] = 'Feltet "{$a->fieldname}" eksisterer ikke i tabellen "{$a->tablename}"';
$string['ddltablealreadyexists'] = 'Tabellen "{$a}" eksisterer allerede';
$string['ddltablenotexist'] = 'Tabellen "{$a}" finnes ikke';
$string['ddlunknownerror'] = 'Ukjent DDL biblioteksfeil';
$string['ddlxmlfileerror'] = 'Feil i XML databasefil oppdaget';
$string['ddsequenceerror'] = 'Feil tabelldefinisjon for "{$a}", det kan bare være en autokolonne og den må være definert som nøkkel.';
$string['destinationcmnotexit'] = 'Målmodulen i kurset eksisterer ikke.';
$string['detectedbrokenplugin'] = 'Modulen "{$a}" har feil eller er utdatert - kan dessverre ikke fortsette.';
$string['dmlexceptiononinstall'] = '<p>Det oppstod en databasefeil [{$a->errorcode}].<br />{$a->debuginfo}</p>';
$string['dmlparseexception'] = 'Feil under analyse av SQL-spørring';
$string['dmlreadexception'] = 'Feil ved lesing fra databasen';
$string['dmltransactionexception'] = 'Feil i databasetransaksjonen
';
$string['dmlwriteexception'] = 'Feil ved skriving til databasen';
$string['dndmaxbytes'] = 'Filen er for stor. Maksimal tillatt størrelse er {$a->size}.';
$string['dndread'] = 'Feil ved lesing av filen';
$string['dndunkownfile'] = 'Denne filtypen støttes ikke';
$string['dndupload'] = 'En ukjent feil oppstod under opplasting av filen';
$string['downgradedcore'] = 'FEIL: Koden du bruker er eldre enn koden for denne databaseversjonen';
$string['downloadedfilecheckfailed'] = 'Sjekk av nedlastet fil mislykkes.';
$string['duplicatefieldname'] = 'Duplikat feltnavn "{$a}" oppdaget';
$string['duplicatenosupport'] = 'Aktiviteten \'{$a->modname}\' kunne ikke dupliseres fordi modulen {$a->modtype} støtter ikke sikkerhetskopiering og gjenoppretting.';
$string['duplicateparaminsql'] = 'FEIL: fant duplikat parameternavn i spørringen';
$string['duplicaterolename'] = 'Det finnes allerede en rolle med samme navn!';
$string['duplicateroleshortname'] = 'Det finne allerede en rolle med dette kortnavnet!';
$string['duplicateusername'] = 'Duplikat brukernavn - dropper oppføringen';
$string['editedpagenotfound'] = 'Systemet kunne ikke bestemme siden du er på. Oppdater siden og prøv igjen.';
$string['emailfail'] = 'E-postsendingen mislykkes';
$string['encryption_decryptfailed'] = 'Dekryptering feilet';
$string['encryption_encryptfailed'] = 'Kryptering feilet';
$string['encryption_invalidkey'] = 'Ugyldig nøkkel';
$string['encryption_keyalreadyexists'] = 'Nøkkel eksisterer allerede';
$string['encryption_nokey'] = 'Nøkkel ikke funnet';
$string['encryption_wrongmethod'] = 'Data samsvarer ikke med en støttet krypteringsmetode';
$string['enddatebeforestartdate'] = 'Kursets sluttdato må være etter kursets startdato';
$string['error'] = 'Feil oppstod';
$string['error_question_answers_missing_in_db'] = 'Kunne ikke finne et svar til "{$a->answer}" i databasetabellen question_answers. Dette skjedde under gjenoppretting av spørsmålet med id {$a->filequestionid} i sikkerhetskopien, som har blitt koblet med spørsmålet med id {$a->dbquestionid} i databasen.';
$string['errorcleaningdirectory'] = 'Feil ved tømming av mappe "{$a}"';
$string['errorcopyingfiles'] = 'Feil under kopiering av filene';
$string['errorcreatingdirectory'] = 'Feil ved oppretting av mappen "{$a}"';
$string['errorcreatingfile'] = 'Feil ved oppretting av filen "{$a}".';
$string['errorcreatingrole'] = 'Feil ved oppretting av rolle';
$string['errorfetchingrssfeed'] = 'Feil ved samling av RSS-agent.';
$string['erroronline'] = 'Feil på linje {$a}';
$string['erroroutput'] = 'Feil utdata, deaktiverer automatisk viderekobling.';
$string['errorparsingxml'] = 'Modulen "{$a}" har feil eller er utdatert - kan dessverre ikke fortsette.';
$string['errorprocessingarchive'] = 'Det skjedde en feil under behandlingen av arkivfila';
$string['errorreadingfile'] = 'Feil under lesning av fil "{$a}"';
$string['errorsavingrequest'] = 'En feil oppsto da du prøvde å lagre henvendelsen.';
$string['errorsettinguserpref'] = 'Feil ved lagring av brukerpreferanser';
$string['errorunzippingfiles'] = 'Feil ved utpakking av filer';
$string['expiredkey'] = 'Utgått nøkkel';
$string['externalauthpassworderror'] = 'Ikke tomt passord for ekstern autentisering';
$string['externalfilenolocation'] = 'Ekstern fil har ingen gyldig sti.';
$string['failtoloadblocks'] = 'En eller flere blokker er registrert i databasen, men lastingen av dem mislykkes!';
$string['fieldrequired'] = '"{$a}" er et obligatorisk felt';
$string['fileexists'] = 'Filen eksisterer';
$string['filemismatch'] = 'Manglende samsvar i filnavn. Filen "{$a->current}" skulle være {$a->file}';
$string['filenotfound'] = 'Beklager, det var ikke mulig å finne filen';
$string['filenotreadable'] = 'Filen ikke lesbar';
$string['filterdoesnothavelocalconfig'] = 'Filteret {$a} tillater ikke lokal konfigurering.';
$string['filternotactive'] = 'Filteret {$a} er ikke aktivt for øyeblikket';
$string['filternotenabled'] = 'Filtrering er ikke aktivert!';
$string['filternotinstalled'] = 'Filteret {$a} er ikke installert';
$string['forumblockingtoomanyposts'] = 'Du har overskredet grensen for innlegg som er satt for dette forumet.';
$string['functionalityremoved'] = 'Du prøver å få tilgang til funksjonalitet som er fjernet.';
$string['generalexceptionmessage'] = 'Unntak - {$a}';
$string['gradecantregrade'] = 'Det oppstod en feil i karakterberegningen: {$a}';
$string['gradepubdisable'] = 'Publisering av karakterer er deaktivert';
$string['gradesneedregrading'] = 'Kurskarakterene må beregnes på nytt';
$string['groupalready'] = 'Brukeren tilhører allerede gruppen {$a}';
$string['groupexistforcourse'] = 'Gruppe "{$a}" eksisterer allerede for dette kurset';
$string['groupexistforcoursewithidnumber'] = '{$a->problemgroup}: Gruppen "{$a->name}" med id-nummeret "{$a->idnumber}" finnes allerede i dette kurset.';
$string['grouphasidnumber'] = 'Gruppen "{$a}" har et id-nummer som kan være automatisk opprettet på et eksternt system. Du har ikke tillatelse til å fjerne denne gruppen.';
$string['groupinghasidnumber'] = 'Tilgangsgruppen "{$a}" har et id-nummer som kan være automatisk opprettet på et eksternt system. Du har ikke tillatelse til å fjerne denne tilgangsgruppen.';
$string['groupingnotaddederror'] = 'Tilgangsgruppen "{$a}" ble ikke lagt til';
$string['groupnotaddederror'] = 'Gruppe "{$a}" ble ikke lagt til';
$string['groupnotaddedtogroupingerror'] = 'Gruppen "{$a->groupname}" ble ikke lagt til tilgangsgruppen "{$a->groupingname}"';
$string['groupunknown'] = 'Gruppe {$a} er ikke tilordnet spesifisert klasse';
$string['groupusernotmember'] = 'Brukeren er ikke medlem av denne gruppen';
$string['guestcantaccessprofiles'] = 'Gjester kan ikke se brukerprofiler. Logg inn med en brukerkonto for å fortsette.';
$string['guestnocomment'] = 'Gjester har ikke lov til å skrive kommentarer!';
$string['guestnoeditprofile'] = 'En gjest kan ikke redigere profilen sin';
$string['guestnoeditprofileother'] = 'Gjesteprofilen kan ikke redigeres';
$string['guestnorate'] = 'Gjester har ikke lov til å vurdere innlegg';
$string['guestsarenotallowed'] = 'Gjestebrukere har ikke lov til å gjøre dette';
$string['hackdetected'] = 'Hackeangrep oppdaget!';
$string['hashpoolproblem'] = 'Ugyldig filinnhold i poolen {$a}.';
$string['headersent'] = 'Overskrifter er allerede sendt';
$string['idnumbertaken'] = 'Feil, dette ID-nummeret er allerede i bruk';
$string['idnumbertoolong'] = 'ID-nummeret er for langt';
$string['importformatnotimplement'] = 'Beklager, men dette formatet er ikkke støttet ennå!';
$string['incorrectext'] = 'Filen har feil filendelse';
$string['inplaceeditableerror'] = 'Feil ved kall til oppdateringsprosessoren';
$string['installproblem'] = 'Det er vanligvis ikke mulig å gjenopprette fra feil som blir trigget under installasjonen. Du kan bli nødt til å lage en ny database eller bruke en annen databaseprefix hvis du ønsker å prøve å installere en gang til.';
$string['internalauthpassworderror'] = 'Mangler eller feil passord policy for intern autentisering';
$string['invalidaccess'] = 'Denne siden ble ikke hentet korrekt';
$string['invalidaccessparameter'] = 'Ugyldig tilgangsparameter';
$string['invalidaction'] = 'Ugyldig handlingsparameter';
$string['invalidactivityid'] = 'Feil aktivitets ID';
$string['invalidadminsettingname'] = 'Ugyldig admin-innstilling ({$a})';
$string['invalidargorconf'] = 'Ingen gyldige argumenter oppgitt - eller muligens feil i serveroppsettet';
$string['invalidarguments'] = 'Ingen gyldige argumenter oppgitt';
$string['invalidblockinstance'] = 'Ugyldig blokk-instans: {$a}';
$string['invalidbulkenrolop'] = 'Du har forsøkt en ugyldig massepåmeldng.';
$string['invalidcategory'] = 'Feil kategori!';
$string['invalidcategoryid'] = 'Feil kategori ID!';
$string['invalidcomment'] = 'Kommentaren er  feil';
$string['invalidcommentarea'] = 'Ugyldig kommentarområde';
$string['invalidcommentid'] = 'Ugyldig kommentar-ID';
$string['invalidcommentitemid'] = 'Ugyldig kommentarelement-ID';
$string['invalidcommentparam'] = 'Ugyldig kommentarparametre';
$string['invalidcomponent'] = 'Ugyldig komponentnavn';
$string['invalidconfirmdata'] = 'Ugyldige bekreftesdata';
$string['invalidcontentid'] = 'Ugyldig innholdsID';
$string['invalidcontext'] = 'Ugyldig kontekst';
$string['invalidcountrycode'] = 'Ugyldig landskode: {$a}';
$string['invalidcourse'] = 'Ugyldig kurs';
$string['invalidcourseformat'] = 'Ugyldig kursformat';
$string['invalidcourseid'] = 'Du prøver å bruke en ugyldig kurs-ID';
$string['invalidcourselevel'] = 'Feil kontekstnivå';
$string['invalidcoursemodule'] = 'Ugyldig kursmodul-ID';
$string['invalidcoursemoduleid'] = 'Ugyldig kursmodul-ID: {$a}';
$string['invalidcoursenameshort'] = 'Ugyldig kort kursnavn';
$string['invaliddata'] = 'Innsendt data er ugyldig';
$string['invaliddatarootpermissions'] = 'Ugyldige tillatelser oppdaget  ved forsøk på å opprette en mappe. Slå på debug mer mer informasjon.';
$string['invaliddevicetype'] = 'Ugyldig enhetstype';
$string['invalidelementid'] = 'Feil element id!';
$string['invalidentry'] = 'Dette er ikke et gyldig innlegg!';
$string['invalidevent'] = 'Ugyldig hendelse';
$string['invalidfieldname'] = '"{$a}" er ikke et gyldig navn';
$string['invalidfiletype'] = '"{$a}" er ikke en gyldig filtype';
$string['invalidformatpara'] = 'Ugyldig format for valgte parameter';
$string['invalidformdata'] = 'Feil skjemadata';
$string['invalidfunction'] = 'Feil funksjon';
$string['invalidgradeitemid'] = 'Feil karakterelementID';
$string['invalidgroupid'] = 'Feil gruppeID angitt';
$string['invalidipformat'] = 'Ugyldig IP-adresseformat';
$string['invaliditemid'] = 'Feil elementID';
$string['invalidkey'] = 'Feil nøkkel';
$string['invalidlanguagecode'] = 'Ugyldig språkkode: {$a}';
$string['invalidlegacy'] = 'Feil arvet rolledefinisjon for typen: {$a}';
$string['invalidmd5'] = 'Ugyldig md5, prøv igjen';
$string['invalidmode'] = 'Ugyldig modus ({$a})';
$string['invalidmodule'] = 'Ugyldig modul';
$string['invalidmoduleid'] = 'Ugyldig modul ID: {$a}';
$string['invalidmodulename'] = 'Ugyldig modulnavn: {$a}';
$string['invalidnum'] = 'Feil tallverdi';
$string['invalidnumkey'] = '$conditions array bør ikke inneholde numeriske nøkler, vennligst fiks koden!';
$string['invalidoutcome'] = 'Feil ID for læringsutbytte';
$string['invalidpagesize'] = 'Ugyldig sidestørrelse';
$string['invalidpasswordpolicy'] = 'Feil passordpolicy';
$string['invalidpaymentmethod'] = 'Ugyldig betalingsmetode: {$a}';
$string['invalidpersistenterror'] = 'Feil: {$a}';
$string['invalidqueryparam'] = 'FEIL: Feil antall parametere i spørringen. Forventet {$a->expected}, fikk {$a->actual}.';
$string['invalidratingarea'] = 'Ugyldig vurderingsområde';
$string['invalidrecord'] = 'Kan ikke finne dataoppføringen i databasetabellen {$a}.';
$string['invalidrecordunknown'] = 'Kan ikke finne dataoppføringen i databasen.';
$string['invalidrequest'] = 'Ugyldig forespørsel';
$string['invalidrole'] = 'Ugyldig rolle';
$string['invalidroleid'] = 'Ugyldig rolle ID';
$string['invalidscaleid'] = 'Feil ID for skala';
$string['invalidsection'] = 'Kursmodulens oppføring inneholder en ugyldig seksjon';
$string['invalidsesskey'] = 'Sesjonen din fikk mest sannsynlig en timeout, vennligst logg inn på nytt.';
$string['invalidshortname'] = 'Dette er et ugyldig kortnavn for kurs';
$string['invalidsourcefield'] = 'Kildefilen til kladdefil er ugyldig';
$string['invalidstatedetected'] = 'Noe gikk helt galt: {$a}. Dette skal normalt aldri hende. :-(';
$string['invalidurl'] = 'Ugyldig URL';
$string['invaliduser'] = 'Ugyldig bruker';
$string['invaliduserdata'] = 'Ugyldig brukerinformasjon: {$a}';
$string['invaliduserfield'] = 'Ugyldig brukerfelt: {$a}';
$string['invaliduserid'] = 'Ugyldig brukerID';
$string['invalidusername'] = 'Brukernavnet du valgte inneholder ugyldige tegn';
$string['invalidusernameblank'] = 'Brukernavnet kan ikke være tomt';
$string['invalidxmlfile'] = '"{$a}" er ikke en gyldig XML-fil';
$string['iplookupfailed'] = 'Finner ingen GEO informasjon om denne IP-adressen {$a}.';
$string['iplookupprivate'] = 'Kan ikke vise oppslag på private IP-adresser';
$string['ipmismatch'] = 'Klientens IP-adresse stemmer ikke';
$string['listcantmovedown'] = 'Mislykkes i å flytte elementet nedover, det er allerede siste element.';
$string['listcantmoveleft'] = 'Mislykkes i å flytte elementet til venstre, har ikke overordnet element.';
$string['listcantmoveright'] = 'Mislykkes i å flytte elementet til høyre, finner ingen tilhørighet å det bli underelement av.';
$string['listcantmoveup'] = 'Mislykkes i å flytte elementet opp. Det er allerede først i listen.';
$string['listnochildren'] = 'Fant ingen underordnede elementer.';
$string['listnoitem'] = 'Fant ikke elementet.';
$string['listnopeers'] = 'Fant ingen tilhørigheter for elementet.';
$string['listupdatefail'] = 'DB operasjonen lykkes ikke i å endre listerekkefølgen.';
$string['logfilenotavailable'] = 'Logger ikke tilgjengelig';
$string['loginasnoenrol'] = 'Du kan ikke bruke på- og avmelding når du har skiftet til en annen rollevisning i et kurs.';
$string['loginasonecourse'] = 'Du kan ikke gå inn i dette kurset.<br />Du  må gå tilbake til din vanlige rolle før du skifter til et annet kurs.';
$string['maxareabytes'] = 'Ikke nok plass til å lagre denne filen';
$string['maxbytesfile'] = 'Filen {$a->file} er for stor. Den maksimale filstørrelsen du kan laste opp er {$a->size}.';
$string['maxdraftitemids'] = 'Filopplastningene dine er midlertidig begrenset etter at du har lastet opp et stort antall filer. Vent litt før du prøver igjen.';
$string['messageundeliveredbynotificationsettings'] = 'Meldingen kunne ikke sendes fordi personlige meldinger mellom brukere (i varslingsinnstillinger) er deaktivert av en portaladministrator.';
$string['messagingdisable'] = 'Meldingstjenste er slått av på denne portalen.';
$string['mimetexisnotexist'] = 'Systemet ditt er ikke satt opp til å kjøre mimeTeX. Du må laste ned C-koden fra <a href="http://www.forkosh.com/mimetex.zip"> http://www.forkosh.com/mimetex.zip</a>, kompilere den og lagre kjørbar fil i mappen moodle/filter/tex.';
$string['mimetexnotexecutable'] = 'Egendefinert mimetex er ikke kjørbar!';
$string['missing_moodle_backup_xml_file'] = 'Sikkerhetskopien mangler XML-filen: {$a}';
$string['missingcategoryrole'] = 'Kunne ikke tilordne rolle til bruker: manglende rolle for kategori.';
$string['missingfield'] = 'Feltet "{$a}" mangler';
$string['missingkeyinsql'] = 'FEIL: mangler parameteren "{$a}" i spørringen';
$string['missingparam'] = 'En obligatorisk parameter ({$a}) mangler';
$string['missingparameter'] = 'Parameter mangler';
$string['missingrequiredfield'] = 'Noen påkrevde felt mangler';
$string['missinguseranditemid'] = 'Manglende user ID og Element ID';
$string['missingvarname'] = 'Nødvendig variabelnavn mangler!';
$string['mixedtypesqlparam'] = 'FEIL: Blandede SQL-typer av parametere!';
$string['mnetdisable'] = 'MNET deaktivert';
$string['mnetlocal'] = 'Eksterne MNET-brukere kan ikke logge inn lokalt';
$string['moduledisable'] = 'Denne modulen ({$a}) har blitt deaktivert for akkurat dette kurset';
$string['moduledoesnotexist'] = 'Denne modulen eksisterer ikke';
$string['moduleinstancedoesnotexist'] = 'Instansen av denne modulen eksisterer ikke';
$string['modulemissingcode'] = 'Modul {$a} mangler koden som er nødvendig for å utføre denne funksjonen';
$string['moodlenet:invalidshareformat'] = 'Ugyldig MoodleNet delingsformat';
$string['moodlenet:invalidsharestatus'] = 'Ugyldig MoodleNet-delingsstatus';
$string['moodlenet:invalidsharetype'] = 'Ugyldig MoodleNet-delingstype';
$string['moodlenet:usernotconfigured'] = 'Du har ikke tillatelse for å del innhold til MoodleNet eller så er ikke kontoen din satt opp riktig.';
$string['movecatcontentstoroot'] = 'Det er ikke tillatt å flytte kategori-innhold til root. Du må flytte innhold til en eksisterende kategori!';
$string['movecatcontentstoselected'] = 'Noe av kategoriinnholdet kan ikke flyttes til den valgte kategorien.';
$string['movecategorynotpossible'] = 'Du kan ikke flytte kategorien \'{$a}\' inn i den valgte kategorien.';
$string['movecategoryownparent'] = 'Du kan ikke gjøre kategorien \'{$a}\' til en overkategori for seg selv.';
$string['movecategoryparentconflict'] = 'Du kan ikke gjøre kategorien \'{$a}\' til en underkategori i en av dens egne underkategorier.';
$string['mssqlrcsmodemissing'] = 'Databasen bruker ikke den forventede READ_COMMITTED_SNAPSHOT-modusen, noe som kan føre til feil resultater, spesielt under scenarier med høy samtidighet. Aktiver den for riktig oppførsel. For ytterligere informasjon, se dokumentasjonen <a href="https://docs.moodle.org/en/Installing_MSSQL_for_PHP"> Installere MSSQL for PHP </a>.';
$string['multiplerecordsfound'] = 'Mer enn en oppføring funnet, forventer bare ett treff.';
$string['multiplerestorenotallow'] = 'Mer enn en gjenopprettingskjøring er ikke tillatt!';
$string['mustbeloggedin'] = 'Du må være innlogget for å gjøre dette';
$string['mustbeteacher'] = 'Du må være lærer for å kunne slå opp denne siden';
$string['myisamproblem'] = 'Databasetabellene bruker MyISAM-motoren, det anbefales at det brukes ACID-kompatibel motor med full transaksjonsstøtte slik som InnoDB.';
$string['needcopy'] = 'Du må kopiere noe først!';
$string['needcoursecategroyid'] = 'Enten kurs ID eller kategori må angis';
$string['needphpext'] = 'Du må legge til {$a} støtte i PHP-installasjonen';
$string['noadmins'] = 'Ingen administratorer!';
$string['noblocks'] = 'Fant ingen blokker!';
$string['nocapabilitytousethisservice'] = 'Brukeren har ikke tilstrekkelig rettigheter til å bruke denne tjenesten';
$string['nocategorydelete'] = 'Kategorien \'{$a}\' kan ikke slettes!';
$string['nocontext'] = 'Beklager, men det kurset er ingen gyldig kontekst.';
$string['nodata'] = 'Ingen data';
$string['noexistingcategory'] = 'Kategorien eksisterer ikke';
$string['nofile'] = 'Fil ikke angitt';
$string['nofiltersenabled'] = 'Ingen filtre er aktivert.';
$string['nofolder'] = 'Forespurte mappe eksisterer ikke';
$string['noformdesc'] = 'Fant ingen formslib-definisjoner for denne aktiviteten.';
$string['noguest'] = 'Ingen gjester her!';
$string['noinstances'] = 'Det er ingen forekomster av {$a} i dette kurset!';
$string['nologinas'] = 'Du har ikke rettighet til å logge inn som den brukeren.';
$string['nonmeaningfulcontent'] = 'Ikke meningfullt innhold';
$string['noparticipants'] = 'Fant ingen deltakere for dette kurset';
$string['noparticipatorycms'] = 'Beklager, men det er deltar ikke i kursmoduler som det kan rapporteres fra.';
$string['nopermissions'] = 'Beklager, men du har ikke rettighet til å gjøre dette ({$a})';
$string['nopermissiontoaccesspage'] = 'Du har ikke tilgang til denne siden.';
$string['nopermissiontocomment'] = 'Du kan ikke legge til kommentarer';
$string['nopermissiontodelentry'] = 'Du kan ikke slette denne kommentaren!';
$string['nopermissiontoeditcomment'] = 'Du kan ikke endre andre brukeres oppføringer!';
$string['nopermissiontohide'] = 'Ikke tillatelse til å skjule';
$string['nopermissiontoimportact'] = 'Du har ikke tilstrekkelig rettigheter til å importere aktiviteter til dette kurset';
$string['nopermissiontolock'] = 'Ikke tillatelse til å låse!';
$string['nopermissiontomanagegroup'] = 'Du har ikke tilstrekkelig rettigheter til å administrere grupper';
$string['nopermissiontorate'] = 'Vurdering av elementer ikke tillatt!';
$string['nopermissiontoshow'] = 'Ikke tillatelse til å se dette!';
$string['nopermissiontounlock'] = 'Ikke tillatelse til å låse opp!';
$string['nopermissiontoupdatecalendar'] = 'Beklager, men du har ikke tillatelse til å oppdatere kalenderhendelser';
$string['nopermissiontoviewcalendar'] = 'Beklager, men du har ikke tillatelse til å se kalenderhendelsen.';
$string['nopermissiontoviewgrades'] = 'Kan ikke vise karakterer.';
$string['nopermissiontoviewletergrade'] = 'Manglende rettighet til å se denne siden';
$string['nopermissiontoviewpage'] = 'Du har ikke rett til å se denne siden';
$string['nosite'] = 'Kunne ikke finne overordnet kurs!';
$string['nositeid'] = 'Ingen portal ID';
$string['nostartdatenoenddate'] = 'En sluttdato for kurset kan bare settes om det også er satt en startdato';
$string['nostatstodisplay'] = 'Beklager, ingen tilgjengelige data å vise.';
$string['notallowedtoupdateprefremotely'] = 'Du har ikke lov til å oppdatere brukerpreferanser eksternt fra';
$string['notavailable'] = 'Det er ikke tilgjengelig enda';
$string['notlocalisederrormessage'] = '{$a}';
$string['notmemberofgroup'] = 'Du er ikke medlem av denne kursgruppen';
$string['notownerofkey'] = 'Du er ikke eier av denne nøkkelen';
$string['nousers'] = 'Ingen slik bruker!';
$string['oauth1accesstoken'] = 'OAuth 1.0 feil: Vi fikk ikke tilgangstoken.';
$string['oauth1requesttoken'] = 'OAuth 1.0 feil: Vi fikk ikke tak i forespørselstoken - tjenesteleverandøren kan være midlertidig nede.';
$string['oauth2refreshtokenerror'] = 'Kunne ikke oppdatere OAuth 2-token. HTTP-status for eksternt sluttpunkt: {$a}';
$string['oauth2refreshtokentaskerror'] = 'Kunne ikke oppdatere OAuth 2-token for en eller flere utstedere. Se oppgavens utdata for detaljer.';
$string['oauth2upgradetokenerror'] = 'Kunne ikke oppgradere OAuth 2-token. HTTP-status for eksternt sluttpunkt: {$a}';
$string['onlyadmins'] = 'Kun administratorer kan gjøre det.';
$string['onlyeditingteachers'] = 'Bare lærere med administratorrettigheter kan gjøre det.';
$string['onlyeditown'] = 'Du kan bare redigere din egen informasjon';
$string['opensslsealerror'] = 'OpenSSL kan ikke forsegle data';
$string['opensslsignerror'] = 'OpenSSL kan ikke signere data';
$string['orderidnotfound'] = 'Ordre ID {&a} ikke funnet';
$string['pagenotexist'] = '<p>En uvanlig feil oppstod da du forsøkte å nå en side som ikke eksisterer:</p>{$a}';
$string['pagenotexisttitle'] = '404 FEIL: Fila finnes ikke';
$string['passwordexceeded'] = 'Passordet kan ikke ha flere enn {$a} tegn!';
$string['pathdoesnotstartslash'] = 'Ingen gyldige argumenter oppgitt, stien starter ikke med en slash (/) !';
$string['pleasereport'] = 'Hvis du har tid, vær vennlig å la oss få vite hva du forsøkte å gjøre da feilen oppsto.';
$string['pluginnotexist'] = '{$a} modulen eksisterer ikke';
$string['pluginrequirementsnotmet'] = 'Plugin "{$a->pluginname}" ({$a->pluginversion}) kunne ikke installeres. Det krever en nyere versjon av Moodle (du bruker nå {$a->currentmoodle}, og du trenger {$a->requiremoodle}).';
$string['pluginunsupported'] = 'Plugin "{$a-> pluginname}" {$a-> pluginversion} støtter ikke denne versjonen av Moodle {$a-> moodleversion}. Søk plugin-informasjon for å finne støttede versjoner.';
$string['prefixcannotbeempty'] = '<p>FEIL: databasens tabellprefiks kan ikke være tom ({$a})</p>
<p>Portalens administrator må fikse dette problemet.</p>';
$string['prefixtoolong'] = '<p>FEIL: databasens tabellprefiks er for langt  ({$a->dbfamily})</p>
<p>Portalens administrator må fikse dette problemet. Maks lengde for tabellprefiks i {$a->dbfamily} er {$a->maxlength} tegn.</p>';
$string['privatefilesupload'] = 'Opplasting direkte til brukerens private filområde er ikke lenger støttet. Last opp filen til kladdeområdet og flytt så filene med core_user::add_user_private_files';
$string['processingstops'] = 'Prosesseringen stopper her. Gjenværende poster blir ignorert.';
$string['protected_cc_not_supported'] = 'Beskyttede beholdere støttes ikke';
$string['querystringcannotbeempty'] = 'Spørrestrengen kan ikke være tom';
$string['redirecterrordetected'] = 'Ikke støttet omdirigering oppdaget, scriptkjøringen er stoppet.';
$string['redissessionhandlerproblem'] = 'Konfigurering av redis-økt mislyktes. Vennligst informer serveradministratoren.';
$string['refoundto'] = 'Kan ikke bli refundert til {$a}';
$string['refoundtoorigi'] = 'Refundert til originalt beløp: {$a}';
$string['registrationdisabled'] = 'Registrering er deaktivert på denne portalen';
$string['remotedownloaderror'] = '<p>Mislykkes i å laste ned komponenten til din server, vennligst sjekk proxy-innstillingene. PHP cURL tillegget er sterkt anbefalt. </p>
<p>Du må laste ned <a href="{$a->url}">{$a->url}</a> filen manuelt, kopiere den til "{$a->dest}" på serveren din og pakke den ut der.</p>';
$string['remotedownloadnotallowed'] = 'Nedlasting av komponenter til din tjenermaskin er ikke tillatt (allow_url_fopen er satt til ulovlig). <br /> <br />Du må laste ned
<a href="{$a->url}">{$a->url}</a>-filen manuelt, kopiere den til "{$a->dest}" på tjeneren og pakke den ut der.';
$string['reportnotavailable'] = 'Denne rapporttypen er bare tilgjengelig for portalkurset';
$string['requirecorrectaccess'] = 'Ugyldig URL eller port.';
$string['requireloginerror'] = 'Kurs eller aktivitet ikke tilgjengelig';
$string['restore_path_element_missingmethod'] = 'Gjenopprettingsmetoden {$a} mangler. Den må defineres av en utvikler.';
$string['restore_path_element_noobject'] = 'Gjenopprettingsobjekt {$a} er ikke et objekt.';
$string['restorechecksumfailed'] = 'Det oppstod problemer ved gjenoppretting av informasjonen i din brukersesjon. Vennligst sjekk PHP-minnegrense/DB-pakkegrenser. Gjenoppretting er stoppet.';
$string['restrictedcontextexception'] = 'Beklager, kjøring av eksterne funksjoner bryter med kontekstrestriksjonene.';
$string['restricteduser'] = 'Beklager, men din brukerkonto "{$a}" har ikke tilgang til å gjøre det.';
$string['reverseproxyabused'] = 'Revers proxy aktivert, serveren er dessverre ikke direkte tilgjengelig. <br />Vennligst kontakt serveradministratoren.';
$string['rpcerror'] = 'OOOPS: MNET-kommunikasjonen feilet! Her har du en feilmelding du kan videresende til portaladministratoren: {$a}';
$string['scheduledbackupsdisabled'] = 'Tidsstyrte sikkerhetskopier er frakoblet av serveradministrator';
$string['secretalreadyused'] = 'Lenken for endre passord er allerede brukt, passordet blir ikke endret denne gangen.';
$string['sectionnotexist'] = 'Denne seksjonen eksisterer ikke';
$string['sendmessage'] = 'Send melding';
$string['sendmessagesent'] = 'Takk for din tilbakemelding om: <br>{$a}';
$string['serverconnection'] = 'Feil ved tilkobling til server';
$string['servicedonotexist'] = 'Denne tjenesten eksisterer ikke';
$string['sessioncannotobtainlock'] = '<p>Kan ikke få lås for økt-ID {$a->id} innen {$a->acquiretimeout}.</p>
<p>Det er sannsynlig at en annen side ({$a->whohaslock}) fortsatt kjører i en annen nettleserfane, eller at den ikke frigjorde låsen på grunn av en feil.</p>
<p>Du kan vente til tidsavbruddet for øktlåsen ({$a->lockexpire}), eller du kan starte nettleserøkten på nytt. Hvis denne feilen vedvarer, vennligst gi beskjed til serveradministratoren.</p>';
$string['sessioncookiesdisable'] = 'Feil bruk av require_key_login() - sesjonscookier må deaktiveres!';
$string['sessiondiskfull'] = 'Sesjonspartisjonen er full. Det er ikke mulig å logge inn akkurat nå. Vennligst varsle portaladministrator.';
$string['sessionerroruser'] = 'Du har vært inaktiv for lenge. Logg inn på nytt.';
$string['sessionerroruser2'] = 'En feil på tjenermaskinen som påvirker din innlogging ble oppdaget. Vær vennlig å logge inn igjen eller restart nettleseren din.';
$string['sessionexpired'] = 'Sesjon utløpt';
$string['sessionhandlerproblem'] = 'Sesjonsbehandleren er feilkonfigurert';
$string['sessionipnomatch'] = 'Beklager, men IP-nummeret ditt ser ut til å ha forandret seg siden du logget inn. Denne sikkerhetsforanstaltningen skal hindre nettbanditter i å stjele identiteten din mens du er logget inn på denne nettsida. Normale brukere skal normalt ikke se denne meldinga. Be administrator om hjelp.';
$string['sessionipnomatch2'] = '<p>Beklager, men det ser ut til at IP-adressen din er endret siden du logget inn. Denne sikkerhetsfunksjonen beskytter mot hackere som prøver å stjele identiteten din mens du er innlogget. Du kan i blant se denne feilen hvis du er innlogget fra et trådløst nettverk eller du beveger deg mellom forskjellige nettverk. Vennligst spør administratoren etter hjelp.</p>
<p>Dersom du vil fortsette kan trykke F5 for å friske opp denne siden.</p>';
$string['sessionwaiterr'] = 'Timeout i påvente av sesjonslås. <br />Vent på at gjeldende forespørsel er kjørt ferdig eller prøv igjen senere.';
$string['shortnametaken'] = 'Kortnavnet er allerede i bruk på et annet kurs ({$a})';
$string['sitepolicynotagreed'] = 'Portalreglene er ikke godtatt: <a href="{$a}">Klikk her for å lese portalreglene.</a>';
$string['socksnotsupported'] = 'SOCKSS proxy støttes ikke i PHP4';
$string['spellcheckernotconf'] = 'Stavekontroll er ikke konfigurert';
$string['sslonlyaccess'] = 'Av sikkerhetsgrunner er det dessverre kun tillatt med https-tilkoblinger.';
$string['statscatchupmode'] = 'Statistikken er nå i innhentingsmodus. Så langt er {$a->daysdone} dag(er) prosessert og {$a->dayspending} gjenstår. Sjekk tilbake snart!';
$string['statsdisable'] = 'Statistikk er ikke aktivert';
$string['statsnodata'] = 'Det finnes ingen tilgjengelige data for den kombinasjonen av kurs og tidsperiode';
$string['storedfilecannotcreatefile'] = 'Kan ikke opprette lokal fil-pool fil. Vennligst sjekk filrettighetene i dataroot og tilgjengelig diskplass.';
$string['storedfilecannotcreatefiledirs'] = 'Kan ikke opprette lokale fil-pool mapper. Vennligst sjekk filrettighetene i dataroot.';
$string['storedfilecannotread'] = 'Kan ikke lese filen, enten eksisterer ikke filen eller så er det tilgangsproblemer.';
$string['storedfilecannotreadfile'] = 'Kunne ikke lese filen \'{$a}\'. Enten eksisterer ikke filen eller så er det et tilgangsproblem.';
$string['storedfilenotcreated'] = 'Kan ikke opprette filen "{$a->contextid}/{$a->component}/{$a->filearea}/{$a->itemid}{$a->filepath}{$a->filename}"';
$string['storedfileproblem'] = 'Ukjent unntak relatert tl lokale filer ({$a})';
$string['tagdisabled'] = 'Tagger er deaktivert!';
$string['tagnotfound'] = 'Fant ikke oppgitt tag i databasen';
$string['targetdatabasenotempty'] = 'Måldatabasen er ikke tom. Overføringen er stoppet av sikkerhetsgrunner.';
$string['textconditionsnotallowed'] = 'Betinget sammenligning av tekstkolonner er ikke tillatt. Vennligst bruk sql_compare_text() i spørringen din.';
$string['themenotinstall'] = 'Dette designet er ikke installert!';
$string['tokengenerationfailed'] = 'Kan ikke generere ny token';
$string['transactionvoid'] = 'Transaksjonen kan ikke annulleres siden den allerede er annulert.';
$string['unenrolerror'] = 'Det oppstod en feil under forsøket på å melde ut den brukeren';
$string['unicodeupgradeerror'] = 'Beklager, men databasen du bruker er ikke i Unicode, og denne versjonen av Moodle kan ikke migrere til Unicode. Vennligst oppgrader til Moodle 1.7.x først og utfør Unicode migreringen fra Admin-siden. Etter dette kan Moodle migreres til Moodle {$a}';
$string['unknowaction'] = 'Ukjent handling!';
$string['unknowcategory'] = 'Ukjent kategori!';
$string['unknowcontext'] = 'Det er en ukjent kontekst ({$a}) i get_child_contexts!';
$string['unknowformat'] = 'Formatet ikke kjent ({$a})';
$string['unknownbackupexporterror'] = 'Ukjent feil ved forberedelse av informasjon for import';
$string['unknownblockregion'] = 'Blokkregionen \'{$a}\' var ikke å finne på denne siden.';
$string['unknowncategory'] = 'Ukjent kategori med kategori-ID-nummer «{$a}»';
$string['unknowncontext'] = 'Dette er en ukjent kontekst.';
$string['unknowncourse'] = 'Ingen klasse med navnet "{$a}"';
$string['unknowncourseidnumber'] = 'Ukjent kurs ID "{$a}"';
$string['unknowncourserequest'] = 'Ukjent kursforespørsel';
$string['unknowncoursesection'] = 'Ukjent kursseksjon i kurset "{$a}"';
$string['unknownevent'] = 'Ukjent hendelse';
$string['unknownfiletype'] = 'Filtypen er ukjent';
$string['unknowngroup'] = 'Ukjent gruppe "{$a}"';
$string['unknownhelp'] = 'Hjelpeemnet er ukjent {$a}';
$string['unknownjsinrequirejs'] = 'Kan ikke finne Javascript biblioteket: {$a}';
$string['unknownmodulename'] = 'Ukjent modulnavn for skjemaet';
$string['unknownrole'] = 'Ukjent rolle "{$a}"';
$string['unknownsortcolumn'] = 'Ukjent sorteringskolonne {$a}';
$string['unknownuseraction'] = 'Beklager men jeg forsto ikke denne brukerhandlingen.';
$string['unknownuserselector'] = 'Ukjent bruker-velger';
$string['unknoworder'] = 'Ukjent rekkefølge';
$string['unknowparamtype'] = 'Ukjent parametertype: {$a}';
$string['unknowquestiontype'] = 'Spørsmålstypen støttes ikke: {$a}';
$string['unknowuploadaction'] = 'FEIL: Ukjent handling ved opplasting ({$a})';
$string['unspecifycourseid'] = 'Må angi kurs ID, kortnavn eller id-nummer';
$string['unsupportedevent'] = 'Handlingstypen støttes ikke';
$string['unsupportedstate'] = 'Fullføringsstatus støttes ikke';
$string['unsupportedwebserver'] = 'Webserver programvaren ({$a}) er dessverre ikke støttet.';
$string['upgraderequires19'] = 'FEIL: Ny Moodle-versjon ble installert på serveren, men beklageligvis en oppgradering fra en ikke-støttet eldre Moodle-versjon.<br />Vennligst oppgrader først til siste Moodle 1.9 utgivelse før du fortsetter. Du kan alternativt reinstallere den gamle versjonen.';
$string['upgraderunning'] = 'Portalen oppgraderes, vennligst prøv igjen senere.';
$string['urlnotdefinerss'] = 'URL mangler for RSS-agenten';
$string['useradmineditadmin'] = 'Bare administratorer kan modifisere andre adminstratorkontoer';
$string['useradminodelete'] = 'Administratorkontoer kan ikke slettes.';
$string['userautherror'] = 'Ukjent modul for autentisering';
$string['userauthunsupported'] = 'Denne modulen for autentisering støttes ikke.';
$string['useremailduplicate'] = 'Duplikat adresse';
$string['userisfilteredout'] = 'Denne brukeren samsvarer ikke med filtre og tabellpreferanser!';
$string['usermustbemnet'] = 'Brukere i MNET tilgangskontroll-listen må være eksterne brukere.';
$string['usernamelowercase'] = 'Brukernavnet kan kun bestå av små bokstaver';
$string['usernotaddederror'] = 'Bruker ble ikke lagt til - ukjent feil';
$string['usernotaddedregistered'] = 'Bruker  ble ikke lagt til - er allerede registrert';
$string['usernotaddedusernameexists'] = 'Bruker ikke lagt til. Brukernavnet er allerede i bruk på en konto med en annen epostadresse';
$string['usernotavailable'] = 'Detaljene til denne brukeren er ikke tilgjengelige for deg.';
$string['usernotdeletedadmin'] = 'Bruker ikke slettet  - kan ikke slette administratorkontoer';
$string['usernotdeleteddeleted'] = 'Denne brukeren har allerede blitt slettet';
$string['usernotdeletederror'] = 'Brukeren ble ikke slettet!';
$string['usernotdeletedmissing'] = 'Brukeren ble ikke slettet - fant ikke brukernavnet.';
$string['usernotdeletedoff'] = 'Brukeren ble ikke slettet - sletting ikke tillatt.';
$string['usernotfullysetup'] = 'Bruker ikke ferdig satt opp';
$string['usernotincourse'] = 'Denne brukeren er ikke i dette kurset';
$string['usernotrenamedadmin'] = 'Kan ikke endre navn på administratorkontoer.';
$string['usernotrenamedexists'] = 'Brukernavn ble ikke endret -- dette brukernavnet er allerede i bruk.';
$string['usernotrenamedmissing'] = 'Brukernavn ble ikke endret -- kunne ikke finne det gamle brukernavnet.';
$string['usernotrenamedoff'] = 'Brukeren fikk ikke endret navn - ikke tillatt.';
$string['usernotupdatedadmin'] = 'Kan ikke oppdatere administratorkontoer';
$string['usernotupdatederror'] = 'Brukeren ble ikke oppdatert!';
$string['usernotupdatednotexists'] = 'Brukeren ble ikke oppdatert - eksisterer ikke.';
$string['userquotalimit'] = 'Du har fylt opp filkvoten din';
$string['userselectortoomany'] = 'user_selector fikk valgt mer enn en bruker, selv om flervalg er slått av.';
$string['verifyagedigitalconsentnotpossible'] = 'Beklager, bekreftelse av alder for samtykke er ikke tilgjengelig akkurat nå.';
$string['wrongcall'] = 'Dette skriptet ble kalt feil';
$string['wrongcontextid'] = 'Kontekt ID var ikke riktig (kan ikke finne den)';
$string['wrongdestpath'] = 'Gal målmappe';
$string['wrongroleid'] = 'Feil rolle ID!';
$string['wrongsourcebase'] = 'Feil kilde URL base';
$string['wrongusernamepassword'] = 'Feil bruker/passord';
$string['wrongzipfilename'] = 'Galt ZIP-filnavn.';
$string['wscouldnotcreateecoursenopermission'] = 'WS - kunne ikke opprette kurs - ingen tilgang';
$string['wwwrootmismatch'] = 'Feil i data oppdaget, denne serveren kan bare logges inn på via "{$a}"-adressen.<br />Vennligst kontakt administrator.';
$string['wwwrootslash'] = 'Oppdaget feil $CFG->wwwroot i config.php, adressen må inneholde en avsluttende skråstrek (-/- slash)<br />Vennligst kontakt administrator.';
$string['xmldberror'] = 'XMLDB feil!';
$string['youcannotdeletecategory'] = 'Du kan ikke slette kategorien \'{$a}\' fordi du hverken kan slette innholdet eller flytte det andre steder.';
