<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'gradingform_guide', language 'no', version '4.4'.
 *
 * @package     gradingform_guide
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addcomment'] = 'Legg til ofte brukt kommentar';
$string['addcriterion'] = 'Legg til kriterium';
$string['additionalcomments'] = 'Kommentarer';
$string['additionalcommentsforcriterion'] = 'Tilleggskommentarer for kriteriet {$a}';
$string['alwaysshowdefinition'] = 'Vis guidedefinisjonen til studentene';
$string['backtoediting'] = 'Tilbake til redigering';
$string['clicktocopy'] = 'Klikk for å kopiere denne teksten inn i tilbakemeldingen på kriteriene';
$string['clicktoedit'] = 'Klikk for å redigere';
$string['clicktoeditname'] = 'Klikk for å redigere kriteriumnavnet';
$string['comment'] = 'Kommenter';
$string['commentpickerforcriterion'] = 'Ofte brukte kommentarvelger for {$a} tilleggskommentarer';
$string['comments'] = 'Ofte brukte kommentarer';
$string['commentsdelete'] = 'Slett kommentar';
$string['commentsempty'] = 'Klikk for å redigere kommentaren';
$string['commentsmovedown'] = 'Flytt ned';
$string['commentsmoveup'] = 'Flytt opp';
$string['confirmdeletecriterion'] = 'Er du sikker på at du vil slette dette elementet?';
$string['confirmdeletelevel'] = 'Er du sikker på at du vil slette dette nivået?';
$string['criterion'] = 'Kriterienavn';
$string['criteriondelete'] = 'Slett kriterium';
$string['criterionempty'] = 'Klikk for å redigere kriterium';
$string['criterionmovedown'] = 'Flytt ned';
$string['criterionmoveup'] = 'Flytt opp';
$string['criterionname'] = 'Kriteriumsnavn';
$string['criterionremark'] = '{$a} kriteriekommentar';
$string['definemarkingguide'] = 'Angi vurderingsguide';
$string['description'] = 'Beskrivelse';
$string['descriptionmarkers'] = 'Beskrivelse for Karaktergivere';
$string['descriptionstudents'] = 'Beskrivelse for studenter';
$string['err_maxscoreisnegative'] = 'Makskarakteren er ikke gyldig. Det er ikke tillatt med negative karakterer.';
$string['err_maxscorenotnumeric'] = 'Makspoengsum på kriterium må være numerisk';
$string['err_nocomment'] = 'Kommentarfeltet kan ikke stå tomt';
$string['err_nodescription'] = 'Feltet for studentbeskrivelse kan ikke stå tomt';
$string['err_nodescriptionmarkers'] = 'Feltet for karaktergiverbeskrivelse kan ikke stå tomt';
$string['err_nomaxscore'] = 'Feltet for makspoengsum på kriterium kan ikke stå tomt';
$string['err_noshortname'] = 'Feltet for navn på kriterium kan ikke stå tomt';
$string['err_scoreinvalid'] = 'Poengsummen som er gitt for {$a->criterianame} er ikke gyldig. Maks poengsum er: {$a->maxscore}';
$string['err_scoreisnegative'] = 'Karakteren gitt til \'{$a->criterianame}\' er ugyldig. Negative verdier er ikke tillatt.';
$string['err_shortnametoolong'] = 'Kriterienavn må være på mindre enn 256 tegn';
$string['gradingof'] = '{$a} karaktersetting';
$string['guide'] = 'Vurderingsguide';
$string['guidemappingexplained'] = 'ADVARSEL: Din vurderingsguide har en makskarakter på <b>{$a->maxscore} poeng</b>, mens makskarakteren i aktiviteten din er {$a->modulegrade}. Makskarakteren i guiden din vil bli skalert til makskarakteren i modulen.<br />
Poengsummer i midtsjiktet vil bli konvertert respektivt og rundet opp eller ned til nærmeste tilgjengelige karakter.';
$string['guidenotcompleted'] = 'Vennligst oppgi en gyldig karakter for hvert kriterium';
$string['guideoptions'] = 'Valg for vurderingsguide';
$string['guidestatus'] = 'Gjeldende status på vurderingsguide';
$string['hidemarkerdesc'] = 'Skjul karaktergivers beskrivelser';
$string['hidestudentdesc'] = 'Skjul studentens beskrivelser';
$string['informationforcriterion'] = '{$a} informasjon';
$string['insertcomment'] = 'Sett inn mye brukt kommentar';
$string['maxscore'] = 'Maksimal poengsum';
$string['name'] = 'Navn';
$string['needregrademessage'] = 'Vurderingsguidens definisjon har blitt endret etter at denne studenten fikk karakter. Studenten kan ikke se denne veilederen før du har sjekket vurderingsguiden og oppdatert karakteren.';
$string['outof'] = 'Resultat av {$a}';
$string['pluginname'] = 'Vurderingsguide';
$string['previewmarkingguide'] = 'Forhåndsvis vurderingsguide';
$string['privacy:metadata:criterionid'] = 'En identifikator for et kriterie for avansert karaktersetting.';
$string['privacy:metadata:fillingssummary'] = 'Lagrer informasjon om en brukers karakter og tilbakemelding for karaktersettingsguiden.';
$string['privacy:metadata:instanceid'] = 'En identifikator til en karakter brukt av en aktivitet.';
$string['privacy:metadata:preference:showmarkerdesc'] = 'Om karakterkriteriedefinisjonene skal vises';
$string['privacy:metadata:preference:showstudentdesc'] = 'Om deltakeren skal se kriteriebeskrivelser';
$string['privacy:metadata:remark'] = 'Kommentarer til dette karakterkriteriet';
$string['privacy:metadata:score'] = 'Scoren for dette karakterkriteriet';
$string['regrademessage1'] = 'Du er i ferd med å lagre endringer i en vurderingsguide som allerede har blitt brukt til karaktersetting. Vennligst angi hvorvidt eksisterende karakterer må revurderes. Hvis du gjør disse endringene, vil denne vurderingsguiden være skjult for studentene til karakterene deres er oppdatert.';
$string['regrademessage5'] = 'Du er i ferd med å lagre betydelige endringer i en vurderingsguide som allerede har blitt brukt til karaktersetting. Karakteren i karakterboken vil være uendret, men vurderingsguiden kommer til å være skjult for studentene fram til karakterene deres er oppdatert.';
$string['regradeoption0'] = 'Ikke merk for oppdatering av karakter';
$string['regradeoption1'] = 'Merk for oppdatering av karakter';
$string['remark_help'] = 'Legg til en kommtentar for dette kriteriet';
$string['restoredfromdraft'] = 'MERK: Det siste forsøket på å sette karakter på denne personen ble ikke lagret ordentlig, så karakterutkastet har blitt gjenopprettet. Hvis du vil kansellere disse endringene, bruk \'Avbryt\'-knappen under.';
$string['save'] = 'Lagre';
$string['saveguide'] = 'Lagre vurderings guiden og gjør den klar';
$string['saveguidedraft'] = 'Lagre som utkast';
$string['score'] = 'skår';
$string['score_help'] = 'Legg inn et resultat for {$a->criterion} mellom 0 og {$a->maxscore}.';
$string['scoreforcriterion'] = '{$a} resultat';
$string['showmarkerdesc'] = 'Vis karaktergivers beskrivelser';
$string['showmarkspercriterionstudents'] = 'Vis poeng per kriterium til studentene';
$string['showstudentdesc'] = 'Vis studentens beskrivelser';
