<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'hvp', language 'tr', version '4.4'.
 *
 * @package     hvp
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['acceptterms'] = '<a href=":url" target="_blank">kullanım şartlarını</a> kabul ediyorum';
$string['accountdetailslinktext'] = 'İşte';
$string['action'] = 'Eylem';
$string['add'] = 'Ekle';
$string['addedandupdatedpp'] = '{$a->%new} yeni H5P kütüphanesi eklendi ve {$a->%old} tane eski olan güncellendi.';
$string['addedandupdatedps'] = '{$a->%new} yeni H5P kütüphanesi eklendi ve {$a->%old} tane eski olan güncellendi.';
$string['addedandupdatedsp'] = '{$a->%new} yeni H5P kütüphanesi eklendi ve {$a->%old} tane eski olan güncellendi.';
$string['addedandupdatedss'] = '{$a->%new} yeni H5P kütüphanesi eklendi ve {$a->%old} tane eski olan güncellendi.';
$string['addednewlibraries'] = '{$a->%new} yeni H5P kütüphanesi eklendi.';
$string['addednewlibrary'] = '{$a->%new} yeni H5P kütüphanesi eklendi.';
$string['additionalinfo'] = 'Ek Bilgiler';
$string['additionallicenseinfo'] = 'Lisansla ilgili herhangi bir ek bilgi';
$string['addlibraries'] = 'Kütüphane ekle';
$string['address'] = 'Adres';
$string['age'] = 'Yaş';
$string['agedescription'] = 'Bu içeriğin hedef kitlesi. Virgülle ayrılmış olası girdi biçimleri: "1, 34-45, -50, 59-".';
$string['ajaxfailed'] = 'Veri yüklenemedi.';
$string['alttext'] = 'Bu içeriğin hedef kitlesi. Virgülle ayrılmış olası girdi biçimleri: "1, 34-45, -50, 59-".';
$string['anunexpectedsave'] = 'Beklenmedik bir şey oldu. Bu içeriği kaydedemedik.';
$string['assistivetechnologieslabel'] = 'Yardımcı Teknolojiler etiketi';
$string['attribution'] = 'Attribution 4.0';
$string['attributionnc'] = 'Attribution-NonCommercial 4.0';
$string['attributionncnd'] = 'Attribution-NonCommercial-NoDerivs 4.0';
$string['attributionncsa'] = 'Attribution-NonCommercial-ShareAlike 4.0';
$string['attributionnd'] = 'Attribution-NoDerivs 4.0';
$string['attributionsa'] = 'Attribution-ShareAlike 4.0';
$string['author'] = 'Yazar';
$string['authorcomments'] = 'Yazar yorumları';
$string['authorcommentsdescription'] = 'İçeriğin editörü için yorumlar (Bu metin, telif hakkı bilgilerinin bir parçası olarak yayınlanmayacaktır)';
$string['authorname'] = 'Yazarın ismi';
$string['authorrole'] = 'Yazarın rolü';
$string['back'] = 'Geri';
$string['by'] = 'tarafından';
$string['cancel'] = 'İptal etmek';
$string['cancellabel'] = 'İptal';
$string['cancelpublishconfirmationdialogcancelbuttontext'] = 'Hayır';
$string['cancelpublishconfirmationdialogconfirmbuttontext'] = 'Evet';
$string['cancelpublishconfirmationdialogdescription'] = 'Paylaşım sürecini iptal etmek istediğinizden emin misiniz?';
$string['cancelpublishconfirmationdialogtitle'] = 'Paylaşımı iptal et';
$string['ccattribution'] = 'Atıf (CC BY)';
$string['ccattributionnc'] = 'Atıf-Ticari Olmayan (CC BY-NC)';
$string['ccattributionncnd'] = 'Atıf-Ticari Olmayan-Türetilemez (CC BY-NC-ND)';
$string['ccattributionncsa'] = 'Atıf-NonCommercial-ShareAlike (CC BY-NC-SA)';
$string['ccattributionnd'] = 'Atıf-Doğrulama Yok (CC BY-ND)';
$string['ccattributionsa'] = 'Attribution-ShareAlike (CC BY-SA)';
$string['ccpdd'] = 'Kamu Malı Tahsisi (CC0)';
$string['ccpdm'] = 'Public Domain Mark (PDM)';
$string['changedby'] = 'Tarafından değiştirildi';
$string['changedescription'] = 'Değişimin tanımı';
$string['changehasbeensubmitted'] = 'İçin bir değişiklik gönderildi';
$string['changelog'] = 'Değişiklik günlüğü';
$string['changeplaceholder'] = 'Fotoğraf kırpıldı, metin değiştirildi vb.';
$string['city'] = 'Kent';
$string['close'] = 'Kapat';
$string['completionpass'] = 'Geçme notu gerekli';
$string['completionpass_help'] = 'Etkinleştirilirse, öğrenci bir geçme notu (H5P aktivite ayarlarının Not bölümünde belirtildiği gibi) veya daha yüksek bir not aldığında bu aktivite tamamlanmış sayılır.';
$string['completionpassdesc'] = 'Bu aktiviteyi tamamlamak için öğrencinin geçer not alması gerekir';
$string['confirmdialogbody'] = 'Devam etmeyi istediğinizi onaylayın. Bu eylem geri alınamaz.';
$string['confirmdialogheader'] = 'Eylemi onayla';
$string['confirmlabel'] = 'Onayla';
$string['connectionlost'] = 'Bağlantı koptu. Tekrar bağlantı kurduğunuzda sonuçlar saklanacak ve gönderilecektir.';
$string['connectionreestablished'] = 'Bağlantı yeniden kuruldu.';
$string['contactperson'] = 'İlgili kişi';
$string['contactpersondescription'] = 'Yayıncı tarafından paylaşılan içerikle ilgili herhangi bir sorun olması durumunda H5P ilgili kişiye ulaşacaktır. İlgili kişinin adı veya diğer bilgileri yayınlanmayacak veya üçüncü şahıslarla paylaşılmayacaktır.';
$string['contentavailable'] = 'İçeriğiniz normalde bir iş günü içinde Hub\'da mevcut olacaktır.';
$string['contentchanged'] = 'Son kullandığınızdan bu yana bu içerik değişti.';
$string['contentcopied'] = 'İçerik panoya kopyalanır';
$string['contenthub:changesettings'] = 'Hesap ayarlarını <a href="{$a}"> buradan </a> değiştirin';
$string['contenthub:licenseagreementdescription'] = 'Lütfen devam etmeden önce aşağıdaki sözleşmeyi okuyun';
$string['contenthub:licenseagreementmaintext'] = 'HER ŞEY';
$string['contenthub:licenseagreementtitle'] = 'Son Kullanıcı Lisans Sözleşmesi (EULA)';
$string['contenthub:nopermissions'] = 'Siteyi içerik bankasına kaydetme izniniz yok.';
$string['contenthub:register'] = 'H5P Hub\'ında bir hesap açın <a href=\'{$a}\'>buraya tıklayın</a>';
$string['contenthub:settings:box'] = 'İçerik Merkezi Hesabı';
$string['contenthub:settings:heading'] = 'H5P Hub Hesap Ayarları';
$string['contenthubeditsharing'] = 'Paylaşım bilgilerini düzenleyin';
$string['contenthuboptions'] = 'H5P HUB OPSİYONLARI HAKKINDA';
$string['contenthubshare'] = 'H5P Hub\'da paylaşın';
$string['contenthubsharinginprogress'] = 'Paylaşılıyor ...';
$string['contenthubsyncchanges'] = 'Değişiklikleri senkronize et';
$string['contenthubunshare'] = 'Paylaşımı kaldır';
$string['contentissyncing'] = 'İçerik senkronize ediliyor.';
$string['contentlicensetitle'] = 'İçerik Lisans Bilgisi';
$string['contentnotshared'] = 'İçerik, Hub\'da paylaşılmaz.';
$string['contentstatefrequency'] = 'İçerik durumunu kaydetme sıklığı';
$string['contentstatefrequency_help'] = 'Saniye değeriyle, kullanıcının ilerlemesi ne sıklıkla kendiliğinden kaydedilsin. Ajax istemleriyle sorun yaşıyorsanız bu sayıyı artırın.';
$string['contenttype'] = 'İçerik türü';
$string['contenttypecacheheader'] = 'İçerik Türü Önbelleği';
$string['contentupdatesoon'] = 'İçeriğiniz yakında güncellenecek';
$string['copyright'] = 'Kullanım hakları';
$string['copyrightinfo'] = 'Telif hakkı bilgisi';
$string['copyrightstring'] = 'Telif hakkı';
$string['copyrighttitle'] = 'Bu içeriğin telif hakkı bilgisine bak.';
$string['copyrightwarning'] = 'Telif hakkıyla korunan materyal H5P Content Hub\'da paylaşılamaz. İçerik Creative Commons gibi OER dostu bir lisansla lisanslandıysa, lütfen uygun lisansı seçin. Aksi takdirde bu içerik paylaşılamaz.';
$string['couldnotcopy'] = 'Dosya kopyalanamadı.';
$string['couldnotparsejsonfromzip'] = 'JSON paketinden ayrıştırılamıyor: %fileName';
$string['couldnotparsepostdata'] = 'Gönderi verileri ayrıştırılamadı.';
$string['couldnotreadfilefromzip'] = 'Paketten dosya okunamıyor:%fileName';
$string['couldnotsave'] = 'Dosya kaydedilemedi.';
$string['country'] = 'Ülke';
$string['create'] = 'Oluştur';
$string['creativecommons'] = 'Creative Commons';
$string['ctcachebuttonlabel'] = 'İçerik türü önbelleğini güncelle';
$string['ctcacheconnectionfailed'] = 'H5P Hub ile iletişim kurulamadı.  Lütfen daha sonra tekrar deneyiniz.';
$string['ctcachedescription'] = 'İçerik türü önbelleğinin güncel olduğundan emin olmak, en son kitaplıkları görüntüleyebilmenizi, indirebilmenizi ve kullanabilmenizi sağlayacaktır.  Bu, kitaplıkların kendilerini güncellemekten farklıdır.';
$string['ctcachelastupdatelabel'] = 'Son Güncelleme';
$string['ctcacheneverupdated'] = 'Asla';
$string['ctcachenolibraries'] = 'H5P Hub\'dan hiçbir içerik türü alınmadı.  Lütfen daha sonra tekrar deneyiniz.';
$string['ctcachesuccess'] = 'Kitaplık önbelleği başarıyla güncellendi!';
$string['ctcachetaskname'] = 'İçerik türü önbelleğini güncelle';
$string['currentpage'] = 'Sayfa $current / $total';
$string['currentstep'] = 'Adım : adım : toplam';
$string['dataviewreportlabel'] = 'Cevapları Görüntüle';
$string['date'] = 'Tarih';
$string['description'] = 'Açıklama';
$string['disablefileextensioncheck'] = 'Dosya uzantısı denetimini devreden çıkar';
$string['disablefileextensioncheckwarning'] = 'Dikkat! Dosya uzantısı denetimini devreden çıkarmak, .php uzantılı dosyaların da yüklenmesine olanak vereceği için, güvenlik sorunu oluşturabilir. Bu tür dosyalar sitenize zararlı kodların yüklenmesini sağlayabilir. Ne yükleneceğinden emin olmadıkça bu seçeneği kullanmayın.';
$string['disablefullscreen'] = 'Tam ekranı kapat';
$string['disablehubconfirmationmsg'] = 'Hâlâ hub\'ı etkinleştirmek istiyor musunuz?';
$string['disablehubdescription'] = 'Bu seçeneği etkin durumda tutmanız kesinlikle önerilir.  H5P Hub, yeni içerik türlerini almak ve mevcut içerik türlerini güncel tutmak için kolay bir arayüz sağlar.  Gelecekte, içeriği paylaşmayı ve yeniden kullanmayı da kolaylaştıracak.  Bu seçenek devre dışı bırakılırsa, dosya yükleme formları aracılığıyla içerik türlerini yüklemeniz ve güncellemeniz gerekir.';
$string['disciplinedescription'] = 'Birden fazla disiplin seçebilirsiniz';
$string['disciplinelabel'] = 'Disiplinler';
$string['disciplinelimitreachedmessage'] = 'En fazla :numDisciplines disiplini seçebilirsiniz';
$string['disciplines'] = 'Disiplinler';
$string['displayoptionalwaysshow'] = 'Her zaman göster';
$string['displayoptionauthoroff'] = 'Yazar tarafından kontrol edilir, varsayılan değeri: kapalı';
$string['displayoptionauthoron'] = 'Yazar tarafından kontrol edilir, varsayılan değeri: açık';
$string['displayoptiondownloadalways'] = 'Her zaman';
$string['displayoptiondownloadnever'] = 'Asla';
$string['displayoptiondownloadpermission'] = 'Sadece kullanıcının H5P dışarı aktarma izni varsa';
$string['displayoptionnevershow'] = 'Asla gösterme';
$string['displayoptionpermissions'] = 'Sadece kullanıcının H5P dışarı aktarma izni varsa göster';
$string['displayoptionpermissionsembed'] = 'Sadece kullanıcının H5P dışarı aktarma izni varsa göm';
$string['displayoptions'] = 'Seçenekleri Göster';
$string['download'] = 'İndir';
$string['downloadfailed'] = 'İstenen kütüphane indirilemedi.';
$string['downloadtitle'] = 'Bu içeriği bir H5P dosyası olarak indir.';
$string['dropdownbutton'] = 'Açılır düğme';
$string['editinfotitle'] = '<strong>:title</strong> için bilgileri düzenle';
$string['editingfailed'] = 'Düzenleme başarısız oldu.';
$string['editor'] = 'Editör';
$string['emailaddress'] = 'E-posta Adresi';
$string['emailaddressdescription'] = 'E-posta adresi, içerikle ilgili herhangi bir sorun olması durumunda veya yayıncının hesabını kurtarması gerektiğinde yayıncıya ulaşmak için H5P tarafından kullanılacaktır.  Yayınlanmayacak ve üçüncü kişilerle paylaşılmayacaktır.';
$string['emailconfirmbody'] = 'Merhaba {$a->username},

 \'{$a->coursename}\' kursunda \'{$a->hvpname}\' için yanıtlarınızı gönderdiğiniz için teşekkür ederiz.

 Bu mesaj, yanıtlarınızın kaydedildiğini onaylar.

 Bu H5P\'ye {$a->hvpurl} adresinden erişebilirsiniz.';
$string['emailconfirmsmall'] = 'Cevaplarınızı \'{$a->hvpname}\' adresine gönderdiğiniz için teşekkür ederiz.';
$string['emailconfirmsubject'] = 'Gönderim onayı: {$a->hvpname}';
$string['embed'] = 'Embed(Göm)';
$string['embedloginfailed'] = 'Bu içeriğe erişim hakkınız yok. Giriş yapmayı deneyin.';
$string['embedtitle'] = 'Bu içeriğin embed(gömme) koduna bak.';
$string['empty'] = 'Sonuç yok';
$string['enableabout'] = 'H5P bilgisi tuşu';
$string['enablecopyright'] = 'Telif hakkı tuşu';
$string['enabledownload'] = 'İndirmeye izin ver';
$string['enableembed'] = 'Embed(gömme) tuşu';
$string['enableframe'] = 'Eylem çubuğunu ve çerçevesini göster';
$string['enablejavascript'] = 'JavaScript devreye sokulmalı.';
$string['enablesavecontentstate'] = 'İçerik durumunu kaydet';
$string['enablesavecontentstate_help'] = 'Her bir kullanıcı için mevcut etkileşimli içerik durumunu kendiliğinden kaydet. Böylece kullanıcı bıraktığı yerden devam edebilir.';
$string['filenotimage'] = 'Bu bir resim dosyası değil.';
$string['filetypenotallowed'] = 'Dosya türüne izin yok.';
$string['finished'] = 'Bitti';
$string['fullscreen'] = 'Tam Ekran';
$string['gpl'] = 'General Public License v3';
$string['h5pfile'] = 'H5P Dosyası';
$string['h5ptitle'] = 'Daha fazla içerik için H5P.org adresine gidin.';
$string['helpchoosinglicense'] = 'Bir lisans seçmeme yardım et';
$string['hide'] = 'Saklamak';
$string['hideadvanced'] = 'İleri düzeyi gizle';
$string['hubcommunicationdisabled'] = 'Bir veya daha fazla H5P gereksinimi başarısız olduğu için H5P hub iletişimi devre dışı bırakıldı.';
$string['hubisdisabled'] = 'Hub devre dışı bırakıldı. H5P ayarlarında yeniden etkinleştirebilirsiniz.';
$string['hubisdisableduploadlibraries'] = 'H5P Hub, bu sorun çözülene kadar devre dışı bırakılmıştır. Yine de "H5P Kitaplıkları" sayfası aracılığıyla kitaplıkları yükleyebilirsiniz.';
$string['hubsettingsheader'] = 'İçerik Türleri';
$string['hvp:addinstance'] = 'Yeni bir H5P etkinliği ekle';
$string['hvp:contenthubregistration'] = 'Siteyi H5P İçerik Merkezi\'ne kaydedin';
$string['hvp:emailconfirmsubmission'] = 'Gönderirken bir onay mesajı alın';
$string['hvp:emailnotifysubmission'] = 'Bir deneme gönderildiğinde bir bildirim mesajı alın';
$string['hvp:getcachedassets'] = 'Ön belleğe alınmış H5P içerik değerlerini al';
$string['hvp:getembedcode'] = '\'izin ile kontrol edilir\' seçeneği ayarlanmışsa H5P embed(gömülü) kodunu görüntüle';
$string['hvp:getexport'] = '\'izin ile kontrol edilir\' seçeneği ayarlanmışsa .h5p dosyasını indir';
$string['hvp:installrecommendedh5plibraries'] = 'H5P.org tarafından önerilen yeni güvenli H5P içerik tiplerini kur';
$string['hvp:manage'] = 'Mevcut olan H5P içeriğini düzenle';
$string['hvp:restrictlibraries'] = 'Belirli H5P içerik tiplerine olan erişimi kısıtla';
$string['hvp:savecontentuserdata'] = 'H5P içerik kullanıcısı verisini kaydet';
$string['hvp:saveresults'] = 'H5P içeriği için sonucu kaydet';
$string['hvp:share'] = 'H5P OER Hub\'da içerik paylaşın';
$string['hvp:updatelibraries'] = 'Yeni H5P içerik tiplerini kur veya var olanları güncelle';
$string['hvp:userestrictedlibraries'] = 'Kısıtlanmış H5P içerik tiplerini kullan';
$string['hvp:view'] = 'H5P içeriğini gör ve etkileşimde bulun';
$string['hvp:viewallresults'] = 'Tamamlanmış H5P içeriği sonuçlarının hepsini gör';
$string['hvp:viewresults'] = 'Tamamlanmış H5P içeriği sonuçlarının kendine ait olanları gör';
$string['installdenied'] = 'İçerik tiplerini kurma yetkisine sahip değilsiniz. Site yöneticisi ile iletişime geçiniz.';
$string['installedlibraries'] = 'Kurulu kütüphaneler';
$string['intro'] = 'Giriş';
$string['invalidaudioformat'] = 'Ses dosyası formatı geçersiz. mp3 ya da wav kullanın.';
$string['invalidcontentfolder'] = 'Geçersiz içerik klasörü';
$string['invalidcontenttype'] = 'Seçilen içerik tipi geçersiz.';
$string['invalidfieldtype'] = 'Geçersiz alan türü.';
$string['invalidfile'] = 'Dosya "{$a->%filename}" için izin yok. İzin verilen dosya uzantıları: {$a->%files-allowed}.';
$string['invalidimageformat'] = 'Geçersiz resim dosyası formatı. jpg, png ya da gif kullanın.';
$string['invalidlanguagefile'] = '{$a->%library} kütüphanesindeki {$a->%file} dil dosyası geçersiz';
$string['invalidlanguagefile2'] = 'Geçersiz dil dosyası {$a->%languageFile}, {$a->%name} kütüphanesine dahil değilmiş';
$string['invalidlibrary'] = 'Geçersiz kütüphane';
$string['invalidlibrarydata'] = '{$a->%library} kütüphanesinde {$a->%property} için geçersiz veri sağlandı';
$string['invalidlibrarydataboolean'] = '{$a->%library} kütüphanesinde {$a->%property} için geçersiz veri. Türü Boolean olmalı.';
$string['invalidlibraryname'] = 'Kütüphane adı geçersiz: {$a->%name}';
$string['invalidlibrarynamed'] = 'İçerikte kullanılan {$a->%library} H5P kütüphanesi geçersiz';
$string['invalidlibraryoption'] = '{$a->%library} kütüphanesinde geçersiz seçenek {$a->%option}';
$string['invalidlibraryproperty'] = '{$a->%library} kütüphanesinde {$a->%property} okunamıyor';
$string['invalidmainjson'] = 'Geçerli bir ana h5p.json dosyası yok';
$string['invalidmultiselectoption'] = 'Birden fazla seçenekte geçersiz seçili unsur.';
$string['invalidparameters'] = 'Geçersiz parametreler';
$string['invalidselectoption'] = 'Seçimde geçersiz seçili unsur.';
$string['invalidsemanticsjson'] = 'semantics.json dosyası kütüphane {$a->%name} içìn geçersiz';
$string['invalidsemanticstype'] = 'H5P dahili hatası: semantikte bilinmeyen içerik türü "{$a->@type}". İçerik kaldırılıyor!';
$string['invalidstring'] = 'Semantikteki regexp değerine göre sağlanan dizge geçersiz. (value: \\"{$a->%value}\\", regexp: \\"{$a->%regexp}\\")';
$string['invalidtoken'] = 'Güvenlik bilgisi geçersiz.';
$string['invalidvideoformat'] = 'Geçersiz video dosyası türü. mp4 ya da webm kullanın.';
$string['invalidxapiresult'] = 'Verilen içerik ve kullanıcı numarasına karşılık hiç bir xAPI sonucu bulunamadı';
$string['javascriptloading'] = 'JavaScript bekleniyor...';
$string['keywordexists'] = 'Anahtar kelimeler zaten var!';
$string['keywords'] = 'Anahtar kelimeler';
$string['keywordsexists'] = 'Anahtar kelimeler zaten var!';
$string['libraries'] = 'H5P Kütüphaneleri';
$string['librarydirectoryerror'] = 'Kütüphane dizin adı machineName ya da machineName-majorVersion.minorVersion (library.json gereksinimi) ile uyuşmalı. (Dizin: {$a->%directoryName} , machineName: {$a->%machineName}, majorVersion: {$a->%majorVersion}, minorVersion: {$a->%minorVersion})';
$string['librarylistactions'] = 'Eylemler';
$string['librarylistinstancedependencies'] = 'Oluşum bağımlılıkları';
$string['librarylistinstances'] = 'Oluşumlar';
$string['librarylistlibrarydependencies'] = 'Kütüphane bağımlılıkları';
$string['librarylistrestricted'] = 'Kısıtlı';
$string['librarylisttitle'] = 'Başlık';
$string['librarynotselected'] = 'Bir içerik tipi seçmelisiniz.';
$string['license'] = 'Lisans';
$string['licenseCC010'] = 'CC0 1.0 Universal (CC0 1.0) Public Domain Dedication';
$string['licenseCC010U'] = 'CC0 1.0 Universal';
$string['licenseCC10'] = '1.0 Generic';
$string['licenseCC20'] = '2.0 Generic';
$string['licenseCC25'] = '2.5 Generic';
$string['licenseCC30'] = '3.0 Unported';
$string['licenseCC40'] = '4.0 International';
$string['licenseGPL'] = 'General Public License';
$string['licenseV1'] = 'Sürüm 1';
$string['licenseV2'] = 'Sürüm 2';
$string['licenseV3'] = 'Sürüm 3';
$string['licensedescription'] = 'İçeriğiniz için bir lisans seçin';
$string['licensedetails'] = 'Lisans ayrıntıları';
$string['licensedialogdescription'] = 'Doğru kullanım hakkında bilgi almak için belirli bir lisansa tıklayın';
$string['licensee'] = 'Lisans Sahibi';
$string['licenseextras'] = 'Lisans Ekstraları';
$string['licenseversion'] = 'Lisans Sürümü';
$string['licenseversiondescription'] = 'Bir lisans sürümü seçin';
$string['loadingdata'] = 'Veri yükleniyor.';
$string['logouploadtext'] = 'Kuruluş logosu veya avatarı';
$string['longdescription'] = 'Uzun Açıklama';
$string['longdescriptionplaceholder'] = 'İçeriğinizin uzun açıklaması';
$string['lookforupdates'] = 'H5P güncellemelerine bak';
$string['maximumgrade'] = 'En yüksek not';
$string['maximumgradeerror'] = 'Bu içerik mümkün olabilecek en yüksek nokta olarak lütfen geçerli bir pozitif tam sayı giriniz';
$string['maxlength'] = ': uzunluk maksimum karakter sayısıdır';
$string['maxscore'] = 'En Yüksek Skor';
$string['messageprovider:confirmation'] = 'Kendi H5P gönderimlerinizin onayı';
$string['messageprovider:submission'] = 'H5P gönderimlerinin bildirilmesi';
$string['missingcontentfolder'] = 'Geçerli bir içerik klasörü eksik';
$string['missingcontentuserdata'] = 'Hata: İçerik kullanıcısı verisi bulunamadı';
$string['missingcoreversion'] = 'Sistem bu paketten <em>{$a->%component}</em> içeriğini yükleyemedi; H5P eklentisinin daha üst bir sürümü gerekiyor. Bu sitede şu an kullanılan sürüm {$a->%current}; gereken sürüm ise en az {$a->%required}. Yükseltip yeniden deneyebilirsiniz.';
$string['missingdependency'] = '{$a->@lib} için gereken bağımlılık {$a->@dep} yok.';
$string['missinglibrary'] = 'Gereken kitaplık eksik {$a->@library}';
$string['missinglibraryfile'] = '"{$a->%file}" dosyası bu kitaplıkta yok: "{$a->%name}"';
$string['missinglibraryjson'] = 'Geçerli json formatında library.json dosyası bu kitaplık {$a->%name} için bulunamadı';
$string['missinglibraryproperty'] = '{$a->%library} kitaplığında gerekli {$a->%property} özelliği yok';
$string['missingmbstring'] = 'Mbstring PHP uzantısı yüklenmedi. H5P\'nin düzgün çalışması için buna ihtiyacı var';
$string['missingparameters'] = 'Parametreler eksik';
$string['missinguploadpermissions'] = 'Yüklediğiniz dosyada kitaplıklar olabilir ama yeni kitaplık yükleme izniniz yok. Bu konuda site yönetimiyle iletişime geçin.';
$string['modulename'] = 'Etkileşimli İçerik';
$string['modulename_help'] = 'H5P etkinlik modülü Etkileşili Videolar, Soru Setleri, Sürükle ve Bırak Sorular, Çoktan Seçmeli Sorular, Sunumlar ve daha bir çoğu etkileşili içerik türünü oluşturmanızı sağlar.

H5P, zengin içerik için bir yazarlık aracı olmasının yanı sıra, içeriğin etkili bir şekilde yeniden kullanılması ve paylaşılması için H5P dosyalarını içe ve dışa aktarmanıza da imkan tanır.

Kullanıcı etkileşimleri ve puanları xAPI kullanılarak izlenir ve Moodle Not Defteri aracılığıyla kullanılabilir. Şu anda programlama becerisine sahip kişilerin H5P etkileşimlerinde hile yapmasının ve doğru cevapları bilmeden tam puan almasının mümkün olduğunu unutmayın. H5P\'ler sınavlar veya benzerleri için kullanılmamalıdır.

Etkileşimli H5P içeriğini, yerleşik yazma aracını kullanarak içerik oluşturarak veya diğer H5P özellikli sitelerde bulunan H5P dosyalarını yükleyerek eklersiniz.

Translated with www.DeepL.com/Translator (free version)';
$string['modulename_link'] = 'https://h5p.org/moodle-more-help';
$string['modulenameplural'] = 'Etkileşimli İçerik';
$string['nextpage'] = 'Sonraki sayfa';
$string['noanswersubmitted'] = 'Kullanıcı H5P\'e henüz bir cevap göndermemiş';
$string['nocontent'] = 'content.json dosyası bulunamadı ya da işlenemedi';
$string['nocontenttype'] = 'İçerik tipi belirtilmedi.';
$string['nocopyright'] = 'Bu içerik için telif hakkı bilgisi yok.';
$string['nodata'] = 'Ölçütünüze uyan veri yok.';
$string['noextension'] = 'Yüklediğiniz dosya geçerli bir HTML5 Paketi değil (Dosya uzantısı .h5p değil.)';
$string['noh5ps'] = 'Bu kurs için etkileşimli içerik yok.';
$string['nojson'] = 'Ana h5p.json dosyası geçersiz';
$string['noparameters'] = 'Parametre yok';
$string['noparse'] = 'Ana h5p.json dosyası işlenemedi';
$string['nopermissiontogettranslations'] = 'Bu çeviriyi almak için gerekli izine sahip değilsiniz';
$string['nopermissiontorestrict'] = 'Kütüphane kısıtlama yetkiniz yok.';
$string['nopermissiontosavecontentuserdata'] = 'İçerik kullanıcısı verilerini kaydetme yetkiniz yok.';
$string['nopermissiontosaveresult'] = 'Bu içerik için sonucu kaydetme yetkiniz yok.';
$string['nopermissiontoupgrade'] = 'Kütüphanelerin versiyonlarını yükseltme yetkiniz yok.';
$string['nopermissiontoviewresult'] = 'Bu içerik için sonuçları görme yetkiniz yok.';
$string['nosuchlibrary'] = 'Böyle bir kütüphane yok';
$string['notapplicable'] = 'Yok';
$string['nounzip'] = 'Yüklediğiniz dosya geçerli bir HTML5 Paketi değil (Dosya açılamadı)';
$string['noversionattribution'] = 'Attribution';
$string['noversionattributionnc'] = 'Attribution-NonCommercial';
$string['noversionattributionncnd'] = 'Attribution-NonCommercial-NoDerivs';
$string['noversionattributionncsa'] = 'Attribution-NonCommercial-ShareAlike';
$string['noversionattributionnd'] = 'Attribution-NoDerivs';
$string['noversionattributionsa'] = 'Attribution-ShareAlike';
$string['noziparchive'] = 'PHP sürümünüz ZipArchive desteklemiyor.';
$string['oldphpversion'] = 'PHP sürümünüz eski.  H5P\'nin düzgün çalışması için sürümün 5.2 gerekir.  Sürüm 5.6 veya üstü önerilir.';
$string['onlyupdate'] = 'Yalnızca mevcut kütüphaneleri güncelle';
$string['options'] = 'Seçenekler';
$string['pd'] = 'Public Domain';
$string['pddl'] = 'Public Domain Dedication and Licence';
$string['pdm'] = 'Public Domain Mark';
$string['pluginadministration'] = 'H5P';
$string['pluginname'] = 'H5P';
$string['previouspage'] = 'Önceki sayfa';
$string['privacy:metadata:hvp_events:content_id'] = 'Eylemin gerçekleştirildiği içerik kimliği, yeniyse veya içerik yoksa 0.';
$string['privacy:metadata:hvp_events:content_title'] = 'İçeriğin başlığı.';
$string['privacy:metadata:hvp_events:created_at'] = 'Etkinliğin oluşturulduğu saat.';
$string['privacy:metadata:hvp_events:id'] = 'Etkinliğin benzersiz kimliği.';
$string['privacy:metadata:hvp_events:library_name'] = 'Olayın etkilediği kitaplık.';
$string['privacy:metadata:hvp_events:library_version'] = 'Etkinliğin etkilediği kitaplık sürümü.';
$string['privacy:metadata:hvp_events:sub_type'] = 'Olayın alt türü veya olayın eylemi.';
$string['privacy:metadata:hvp_events:type'] = 'olayın türü.';
$string['privacy:metadata:hvp_events:user_id'] = 'Eylemi gerçekleştiren kullanıcının kimliği.';
$string['privacy:metadata:hvp_xapi_results'] = 'xAPI olaylarını H5P içeriğinde saklar.';
$string['privacy:metadata:hvp_xapi_results:additionals'] = 'H5P\'nin gönderebileceği ek bilgiler.';
$string['privacy:metadata:hvp_xapi_results:content_id'] = 'Etkinliğin gerçekleştirildiği içeriğin kimliği.';
$string['privacy:metadata:hvp_xapi_results:correct_responses_pattern'] = 'Doğru cevap modeli.';
$string['privacy:metadata:hvp_xapi_results:description'] = 'Eylemin gerçekleştirildiği içeriğin açıklaması, görevi veya sorusu.';
$string['privacy:metadata:hvp_xapi_results:id'] = 'xAPI olayının benzersiz kimliği.';
$string['privacy:metadata:hvp_xapi_results:interaction_type'] = 'Etkileşim türü.';
$string['removeoldlogentries'] = 'Eski H5P kütük girdilerini kaldır';
$string['removeoldmobileauthentries'] = 'Eski H5P mobil kimlik doğrulama girdilerini kaldır';
$string['removetmpfiles'] = 'Eski H5P geçici dosyalarını kaldır';
$string['reportingquestionsremaininglabel'] = 'notlanmamış sorular';
$string['reportingscaledscoredelimiter'] = ',';
$string['reportingscaledscorelabel'] = 'Not defteri skoru:';
$string['reportingscoredelimiter'] = '/';
$string['reportingscorelabel'] = 'Skor:';
$string['reportnotsupported'] = 'Desteklenmiyor';
$string['reportsubmitgradelabel'] = 'Notu gönder';
$string['resizescript'] = 'Embedded(gömülü) içeriğin dinamik boyutlandırılmasını istiyorsanız web sitenize bu dizgeyi dahil edin:';
$string['reuse'] = 'Tekrar kullan';
$string['savechanges'] = 'Değişiklikleri kaydet';
$string['score'] = 'Skor';
$string['search'] = 'Ara';
$string['sendusagestatistics'] = 'Kullanım istatistiklerine katkıda bulun';
$string['sendusagestatistics_help'] = 'Kullanım istatistikleri geliştiricilerin H5P kullanımını anlamaları ve muhtemel iyileştirmelere karar vermeleri amacıyla otomatik olarak raporlanacaktır. Daha fazla bilgi için <a {$a}>h5p.org\'da toplanan veri</a>\'ye bakabilirsiniz.';
$string['settings'] = 'H5P Ayarları';
$string['showadvanced'] = 'İleri düzeyi göster';
$string['showless'] = 'Daha az göster';
$string['showmore'] = 'Daha falza göster';
$string['size'] = 'Boyut';
$string['source'] = 'Kaynak';
$string['sslnotenabled'] = 'Sunucunuzda SSL etkin değil. H5P hub ile güvenli bir bağlantı sağlamak için SSL etkinleştirilmelidir.';
$string['startingover'] = 'Yeniden başlayacaksınız.';
$string['subcontentwarning'] = 'Alt içerik (resimler, sorular vb.), yazarlık aracında aksi belirtilmedikçe :lisansı altında paylaşılacaktır';
$string['sublevel'] = 'Alt seviye';
$string['submitted'] = 'Gönderilen!';
$string['successfullyregisteredwithhub'] = 'Siteniz H5P Hub\'a başarıyla kaydedildi.';
$string['successfullyregistred'] = 'H5P Hub\'da bir hesabı başarıyla kaydettiniz';
$string['successfullyregistreddescription'] = 'Hesap detaylarınız değiştirilebilir';
$string['successfullyupdated'] = 'H5P Hub hesap ayarlarınız başarıyla değiştirildi';
$string['thumbnail'] = 'Küçük resim';
$string['title'] = 'Başlık';
$string['unabletocreatedir'] = 'Dizin oluşturulamadı.';
$string['unabletogetfieldtype'] = 'Alan türü alınamadı.';
$string['undisclosed'] = 'Gizli';
$string['unpackedfilesexceedsmaxsize'] = 'Paketlenmemiş dosyaların toplam boyutu, izin verilen maksimum boyutu aşıyor.  (%kullanılan > %maks)';
$string['updatedlibraries'] = '{$a->%old} H5P kütüphanesi güncellendi.';
$string['updatedlibrary'] = '{$a->%old} H5P kütüphanesi güncellendi.';
$string['updatelibraries'] = 'Tüm Kitaplıkları Güncelle';
$string['updateregistrationonhub'] = 'Hesap ayarlarını kaydet';
$string['upgrade'] = 'H5P versiyonunu yükselt';
$string['upgradebuttonlabel'] = 'Versiyon yükselt';
$string['upgradedone'] = '{$a} içerik oluşumu başarıyla yükseltildi.';
$string['upgradeerror'] = 'Parametreler işlenirken bir sorun oluştu:';
$string['upgradeerrorcontent'] = '%id içeriği yükseltilemedi:';
$string['upgradeerrordata'] = '%lib kitaplığı için veriler yüklenemedi.';
$string['upgradeerrormissinglibrary'] = '%lib kütüphanesi eksik.';
$string['upgradeerrornotsupported'] = '%used içeren parametreler desteklenmemiştir.';
$string['upgradeerrorparamsbroken'] = 'Parametreler bozuk.';
$string['upgradeerrorscript'] = '%lib kütüphanesi için yükseltme dizgesi yüklenemedi.';
$string['upgradeerrortoohighversion'] = '%used içeren parametreler sadece %supported veya daha eskileri desteklenmektedir.';
$string['upgradeheading'] = '{$a} içeriğini yükselt';
$string['upgradeinprogress'] = '%ver sürümüne yükseltiliyor...';
$string['upgradeinvalidtoken'] = 'Hata: Güvenlik bilgisi geçersiz!';
$string['upgradelibrarycontent'] = 'Kütüphane içeriğini yükselt';
$string['upgradelibrarymissing'] = 'Hata: Kütüphane yok!';
$string['upgrademessage'] = '{$a} içerik oluşumu yükseltilecek. Yükseltme sürümünü seçin.';
$string['upgradenoavailableupgrades'] = 'Bu kütüphane için mevcut yükseltme yok.';
$string['upgradenothingtodo'] = 'Yükseltilecek içerik oluşumu yok.';
$string['upgradereturn'] = 'Geri dön';
$string['upload'] = 'Yükle';
$string['uploadlibraries'] = 'Kitaplıkları Yükle';
$string['uploadsizelargerthanpostsize'] = 'PHP maksimum yükleme boyutunuz, maksimum gönderi boyutunuzdan daha büyük.  Bunun bazı kurulumlarda sorunlara neden olduğu bilinmektedir.';
$string['user'] = 'Kullanıcı';
$string['validatingh5pfailed'] = 'h5p paketi doğrulama başarısız.';
$string['validationfailed'] = 'İstenen H5P geçerli değildi';
$string['viewreportlabel'] = 'Rapor';
$string['welcomecommunity'] = 'Umarız H5P kullanmaktan memnun kalır ve sürekli büyüyen topluluğumuza<a {$a->forums}>forumlarımız</a>.';
$string['welcomecontactus'] = 'Herhangi bir geribildiriminiz varsa<a {$a}>bize iletin</a>. Geribildirimleri titizlikle ele alıyor ve her geçen gün H5P yazılımını geliştirmeye çabalıyoruz!';
$string['welcomegettingstarted'] = 'H5P ve Moodle kullanımına bakmak için <a {$a->moodle_tutorial}>kullanım</a> turumuza bakabilir ve h5p.org üzerinde <a {$a->example_content}>örnek içerik</a> le bir fikir edinebilirsiniz.';
$string['welcomeheader'] = 'H5P dünyasına hoşgeldiniz!';
$string['wrongversion'] = 'Bu içerikte kullanılan {$a->%machineName}  H5P kitaplığının sürümü geçerli değil.  İçerik, {$a->%contentLibrary} içeriyor, ancak {$a->%semanticsLibrary} olmalıdır.';
$string['year'] = 'Yıl';
$string['years'] = 'Yıl';
$string['yearsfrom'] = 'Yıldan';
$string['yearsto'] = 'Yıla';
$string['zip'] = 'Zip';
