<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_adaptable', language 'tr', version '4.4'.
 *
 * @package     theme_adaptable
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['aboutme'] = 'Hakkımda';
$string['actingasrole'] = 'Şu anda farklı bir rol oynuyorsunuz';
$string['activatetemplateoverride'] = '\'{$a}\' için şablon geçersiz kılma özelliğini etkinleştir';
$string['activatetemplateoverridedesc'] = 'İşaretlendiğinde, \'{$a->setting}\' ayarındaki değer, metin içeriyorsa \'{$a->template}\' şablonu olarak kullanılacaktır.';
$string['activebreadcrumb'] = 'Etkin içerik haritası arka plan rengi';
$string['activebreadcrumbdesc'] = 'Etkin içerik haritası renginin arka plan rengini ve içerik haritası çubuğunun kalanını ayarlayın.';
$string['activitiesheading'] = 'Etkinlikler';
$string['alertaccess'] = 'Uyarı görünürlüğü';
$string['alertaccessadmins'] = 'Yöneticilere görünür';
$string['alertaccessdesc'] = 'Uyarı görünürlüğü için erişim kısıtlama türünü ayarlayın.  Not: "Özel profil alanı kısıtlaması ekle" seçeneğini kullanıyorsanız, aşağıdaki profil alanları için değerler eklemeniz gerekecektir.';
$string['alertaccessglobal'] = 'Herkese görünür';
$string['alertaccessprofile'] = 'Özel profil alanı kısıtlaması ekle';
$string['alertaccessusers'] = 'Giriş yapan kullanıcılar görebilir';
$string['alertannounce'] = 'Duyuru';
$string['alertannouncedesc'] = 'Uyarıda bir duyuru görüntüleyin.';
$string['alertbackgroundcolorinfo'] = 'Bilgi arkaplan rengi';
$string['alertbackgroundcolorinfodesc'] = 'Bilgi türü uyarılarının arka plan rengi.';
$string['alertbackgroundcolorsuccess'] = 'Duyuru Arkaplan Rengi';
$string['alertbackgroundcolorsuccessdesc'] = 'Duyuru türü uyarıların arka plan rengi';
$string['alertbackgroundcolorwarning'] = 'İkaz arkaplan rengi';
$string['alertbackgroundcolorwarningdesc'] = 'İkaz türü uyarıların arka plan rengi.';
$string['alertbordercolorinfo'] = 'Bilgi kenarlık rengi';
$string['alertbordercolorinfodesc'] = 'Bilgi türü uyarılarının kenarlık rengi.';
$string['alertbordercolorsuccess'] = 'Duyuru kenarlık rengi';
$string['alertbordercolorsuccessdesc'] = 'Duyuru Duyuru türü uyarılarının kenarlık rengi.uyarı kutularının kenarlık rengi,';
$string['alertbordercolorwarning'] = 'ikaz çerçeve rengi';
$string['alertbordercolorwarningdesc'] = 'İkaz türü uyarıların kenarlık rengi.';
$string['alertcolorinfo'] = 'Bilgi rengi';
$string['alertcolorinfodesc'] = 'Bilgi türü uyarılarının simge rengi.';
$string['alertcolorsheading'] = 'Uyarı renkleri ve simgesi';
$string['alertcolorsuccess'] = 'Duyuru rengi';
$string['alertcolorsuccessdesc'] = 'Duyuru türü uyarılarının simge rengi.';
$string['alertcolorwarning'] = 'İkaz rengi';
$string['alertcolorwarningdesc'] = 'İkaz türü uyarıların simge rengi.';
$string['alertcount'] = 'Uyarı sayısı';
$string['alertcountdesc'] = 'Aşağıdaki düzenleme alanında gösterilecek uyarıların sayısı.';
$string['alertdesc'] = 'Sitenin üst kısmında uyarı olarak görüntülenecek bir metin girin ve özelleştirin.  Farklı kullanıcı türlerini hedeflemek için birden fazla uyarı ayarlamak mümkündür.';
$string['alertdisabled'] = 'Devre dışı';
$string['alertdisabledesc'] = 'Bu uyarıyı devre dışı bırakın.';
$string['alerthiddencourse'] = 'Gizli kurs uyarısı';
$string['alerthiddencoursedesc'] = 'Öğretmenleri kursların gizli olduğu konusunda uyarın.';
$string['alerthiddencoursetext-end'] = '.';
$string['alerthiddencoursetext-link'] = 'ayarları güncellemek için buraya tıklayın';
$string['alerthiddencoursetext-start'] = 'Bu kurs gizlidir ve öğrenciler tarafından erişilemez,';
$string['alerticoninfo'] = 'Simge bilgisi';
$string['alerticoninfodesc'] = 'Bilgi türü uyarılarında kullanılmak üzere \'<a href="{$a}" target="_blank">Font Awesome Simgeleri</a>\'ni ayarlayın.  Simge adını \'fa-\' öneki olmadan girin.';
$string['alerticonsuccess'] = 'Duyuru simgesi';
$string['alerticonsuccessdesc'] = 'Duyuru türü uyarı kutularında kullanılacak <a href="http://fortawesome.github.io/Font-Awesome/icons/">Yazı Tipi Awesome Simgesi</a>\'ni ayarlayın. Önek olmadan simge adını girin.';
$string['alerticonwarning'] = 'Uyarı simgesi';
$string['alerticonwarningdesc'] = 'İkaz türü uyarılarda kullanılmak üzere \'<a href="{$a}" target="_blank">Font Awesome Simgeleri</a>\'ni ayarlayın.  Simge adını \'fa-\' öneki olmadan girin.';
$string['alertinfo'] = 'Bilgi';
$string['alertinfodesc'] = 'Uyarıda bilgi görüntüleyin.';
$string['alertkeyvalue'] = 'Uyarı anahtarı';
$string['alertkeyvalue_details'] = 'Bu uyarıyı tanımlayan anahtar.  Bunu yalnızca aynı uyarıyı tekrar göstermek istiyorsanız, yani içerik değişmediyse veya daha önce kullanıldıysa değiştirmeniz gerekir.  Not: Biçimlendirme değişiklikleri içerikte yapılan bir değişiklik olarak sayılmaz.';
$string['alertprofilefield'] = 'Özel profil alan Adı=Değer (isteğe bağlı)';
$string['alertprofilefielddesc'] = 'Özel profil alanı için erişim kuralı ekleyin, örneğin: kullanıcıtipi= öğrenci';
$string['alertsettings'] = 'Uyarı {$a}';
$string['alertsettingscourse'] = 'Kurs Uyarı Ayarları';
$string['alertsettingsgeneral'] = 'Genel uyarı ayarları';
$string['alertsettingsheading'] = 'Uyarılar';
$string['alerttext'] = 'Uyarı Metni';
$string['alerttextdesc'] = 'Uyarıda görüntülenecek metni girin.';
$string['alerttype'] = 'Uyarı türü';
$string['alerttypedesc'] = 'Uyarı türünü seçin: bilgi (mavi), uyarı (sarı) veya duyuru (yeşil)';
$string['alertwarning'] = 'Uyarı';
$string['alertwarningdesc'] = 'Uyarıda bir ikaz görüntüleyin.';
$string['analyticscount'] = 'Analiz sayısı';
$string['analyticscountdesc'] = 'Aşağıdaki düzenleme alanında gösterilecek analiz alanlarının sayısı.';
$string['analyticsprofilefield'] = 'Özel Profil Alan Adı=Değer (isteğe bağlı)';
$string['analyticsprofilefielddesc'] = 'Özel profil alanı için kullanarak erişim kuralı ekleyin, örneğin: kullanıcıtipi=öğrenci';
$string['analyticssettings'] = 'Analiz';
$string['analyticssettingsdesc'] = 'Google Analytics için birden fazla kod kurabilir ve bunları kullanıcı profili alanlarına hedefleyebilirsiniz. Veya açık kaynaklı analiz olan Matomo\'yu kullanabilirsiniz.';
$string['analyticssettingsheading'] = 'Google Analytics ve/veya Matomo\'yu kurun';
$string['analyticstext'] = 'Analytics Kimliği';
$string['analyticstextdesc'] = 'Google Analytics Kimliğini girin';
$string['anonymizega'] = 'Kullanıcı IP\'sini anonimleştirin';
$string['anonymizegadesc'] = 'Google Analytics\'e gönderilen kullanıcı IP\'sini anonimleştirin.';
$string['backcolor'] = 'Zemin rengi';
$string['backcolordesc'] = 'Zemin rengi ayarla';
$string['bcustyle'] = 'BCU stili';
$string['blockbackgroundcolor'] = 'Blok zemin rengi';
$string['blockbackgroundcolordesc'] = 'Tüm bloklar için arkaplan rengini ayarlayın.';
$string['blockbordercolor'] = 'Blok kenarlık rengi';
$string['blockbordercolordesc'] = 'Blok kenarlık rengini ayarlayın.';
$string['blockheaderbackgroundcolor'] = 'Başlık arka plan rengini engelle';
$string['blockheaderbackgroundcolordesc'] = 'Tüm bloklar için başlık arka plan rengini ayarlayın.';
$string['blockheaderborderbottom'] = 'Başlık alt kenar kalınlığını engelle';
$string['blockheaderborderbottomdesc'] = 'Blok başlıklarının alt sınırının kalınlığını ayarlayın.';
$string['blockheaderborderleft'] = 'Başlık sol kenarlık kalınlığını engelle';
$string['blockheaderborderleftdesc'] = 'Blok başlıklarının sol kenarının kalınlığını ayarlayın.';
$string['blockheaderborderright'] = 'Üstbilgi sağ kenarlık kalınlığını engelle';
$string['blockheaderborderrightdesc'] = 'Blok başlıklarının sağ kenarının kalınlığını ayarlayın.';
$string['blockheaderbordertop'] = 'Başlık üst kenar kalınlığını engelle';
$string['blockheaderbordertopdesc'] = 'Blok başlıklarının üst sınırının kalınlığını ayarlayın.';
$string['blockheaderbordertopstyle'] = 'Üstbilgi kenarlık stilini engelle';
$string['blockheaderbordertopstyledesc'] = 'Blok başlıklarının sınır stilini ayarlayın.';
$string['blockheaderbottomradius'] = 'Üstbilgi alt yarıçapını engelle';
$string['blockheaderbottomradiusdesc'] = 'Eğri / yuvarlatılmış bir etki elde etmek için alt başlık bloğunun yarıçapını ayarlayın.';
$string['blockheadercolor'] = 'Başlık yazı tipi rengini engelle';
$string['blockheadercolordesc'] = 'Blok başlığı yazı tipi rengini ayarlayın.';
$string['blockheadertopradius'] = 'Üstbilgi üst yarıçapını engelle';
$string['blockheadertopradiusdesc'] = 'Eğri / yuvarlatılmış bir etki elde etmek için üst başlık bloğunun yarıçapını ayarlayın.';
$string['blockicons'] = 'Blok simgeleri';
$string['blockiconsdesc'] = 'Bunu, blok başlık alanında blok simgelerini gösterecek şekilde ayarlayın.';
$string['blockiconsheadersize'] = 'Başlık simgesi boyutunu engeller';
$string['blockiconsheadersizedesc'] = 'Moodle blokları başlığında kullanılan yazı tipi simgesi boyutunu ayarlayın. Listeden bir değer seçin.';
$string['blocklayoutbuilder'] = 'Ön sayfa engelleme bölgeleri';
$string['blocklayoutbuilderdesc'] = 'Aşağıda, ön sayfada blok bölgeleri için kendi düzeninizi oluşturabilirsiniz.<br/>Bu bölgelere içerik eklemek için <strong>Moodle\'ın ön sayfasında düzenlemeyi açmanız</strong> gerekir.<br/>Ardından blokları oluşturduğunuz bölgelere sürükleyip bırakmaya başlayabilirsiniz!';
$string['blocklayoutlayoutcheck'] = 'Düzeninizi kontrol edin';
$string['blocklayoutlayoutcheckdesc'] = 'Kullandığınız blok sayısını kontrol etmek ve yeni düzeninizin bir temsilini görmek için aşağıdaki aracı kullanın.';
$string['blocklayoutlayoutcount1'] = 'Bir maksimum ayarlayabilirsiniz';
$string['blocklayoutlayoutcount2'] = 'blok bölgeler. Şu anda kullanıyorsunuz:';
$string['blocklayoutlayoutrow'] = 'Bölge satırını engelle';
$string['blocklayoutlayoutrowdesc'] = 'Ön sayfada blok bölgesi satırı için düzen ekleyin / ayarlayın.';
$string['blockmainborderbottom'] = 'Ana alt kenar kalınlığını engelle';
$string['blockmainborderbottomdesc'] = 'Ana blok alanının alt sınırının kalınlığını ayarlayın.';
$string['blockmainborderleft'] = 'Sol ana kenar kalınlığını engelle';
$string['blockmainborderleftdesc'] = 'Ana blok alanının sol kenarının kalınlığını ayarlayın.';
$string['blockmainborderright'] = 'Sağ ana kenar kalınlığını engelle';
$string['blockmainborderrightdesc'] = 'Ana blok alanının sağ kenarının kalınlığını ayarlayın.';
$string['blockmainbordertop'] = 'Ana üst sınır kalınlığını engelle';
$string['blockmainbordertopdesc'] = 'Ana blok alanının üst sınırının kalınlığını ayarlayın.';
$string['blockmainbordertopstyle'] = 'Ana sınır stilini engelle';
$string['blockmainbordertopstyledesc'] = 'Blok içerik alanı sınırının stilini ayarlayın.';
$string['blockmainbottomradius'] = 'Ana alt yarıçapı engelle';
$string['blockmainbottomradiusdesc'] = 'Eğri / yuvarlatılmış bir etki elde etmek için ana blok alanının alt yarıçapını ayarlayın.';
$string['blockmaintopradius'] = 'Ana üst yarıçapı engelle';
$string['blockmaintopradiusdesc'] = 'Eğri / yuvarlak bir etki elde etmek için ana blok alanının üst yarıçapını ayarlayın.';
$string['blockregionbackground'] = 'Bölge arka plan rengini engelle';
$string['blockregionbackgrounddesc'] = 'Ön sayfada özel blok düzenleri tutan kabın arka plan rengi.';
$string['blockregioneditingtitleshown'] = 'Düzenlerken blok bölgesi başlığını göster';
$string['blockregioneditingtitleshowndesc'] = 'Düzenleme yaparken blok bölgesi başlığını gösterebilir / gizleyebilirsiniz.';
$string['blockshowhide'] = 'Bloğu göster / gizle';
$string['blockside'] = 'Blokların yeri';
$string['blocksidedesc'] = 'Blokların sayfanın solunda mı yoksa sağında mı görüneceğini kontrol edin.';
$string['breadcrumb'] = 'Hesapta görüntülenen yeri gösteren bağlantı';
$string['breadcrumbbackgroundcolor'] = 'İçerik haritası arka plan rengi';
$string['breadcrumbbackgroundcolordesc'] = 'Hesapta görüntülenen yeri gösteren bağlantının arka plan rengini ayarlayın.';
$string['breadcrumbdisplay'] = 'İçerik haritası ekranı';
$string['breadcrumbdisplaydesc'] = 'Bir kursta içerik haritası alanında olması gerekenlerin görüntüsünü ayarlayın.';
$string['breadcrumbhome'] = 'Breadcrumb ana sayfa';
$string['breadcrumbhomedesc'] = 'Ana sayfa kırıntılarını bir simge veya metin olarak görüntüleyin.';
$string['breadcrumbhomeicon'] = 'İkon';
$string['breadcrumbhometext'] = 'Metin';
$string['breadcrumbseparator'] = 'İçerik haritası ayırıcı';
$string['breadcrumbseparatordesc'] = '\'<a href="{$a}" target="_blank">Font Awesome Simgeleri</a>\'ni içerik haritasında öğe ayırıcı olarak kullanılmak üzere ayarlayın. simge adını \'fa-\' öneki olmadan girin.';
$string['breadcrumbtextcolor'] = 'İçerik haritası metin rengi';
$string['breadcrumbtextcolordesc'] = 'İçerik haritasının metin rengini ayarlayın.';
$string['breadcrumbtitle'] = 'İçerik haritası ders adı';
$string['breadcrumbtitledesc'] = 'İçerik haritasındaki ders başlığını görüntülemek için modu ayarlayın.';
$string['bs4all'] = 'Ekstra küçük - Ekstra büyük';
$string['bs4extralarge'] = 'Yalnızca ekstra büyük';
$string['bs4large'] = 'Büyük - Ekstra büyük';
$string['bs4medium'] = 'Orta - Ekstra büyük';
$string['bs4none'] = 'Yok';
$string['bs4small'] = 'Küçük - Çok Büyük';
$string['buttoncolor'] = 'Düğme rengi';
$string['buttoncolorcancel'] = 'Düğme rengini iptal et';
$string['buttoncolordesc'] = 'Site genelinde kullanılan ana düğmelerin rengi.';
$string['buttoncolordesccancel'] = 'İptal düğmesi için arka plan rengi. <br/> Şeffaflık için kutuya şeffaf yazın.';
$string['buttoncolordescscnd'] = 'Site genelinde kullanılan ikincil düğmelerin rengi.';
$string['buttoncolorscnd'] = 'İkincil düğme rengi';
$string['buttondesc'] = 'Bu temada kullanılan düğmelerin görünümünü değiştirin.';
$string['buttondropshadow'] = 'Düğmenin altında alt gölge dekorasyonu';
$string['buttondropshadowdesc'] = 'Düğmenin altında bir alt gölge (gölgeleme) gösterin.';
$string['buttonfocuscolour'] = 'Düğme odak arka plan rengi';
$string['buttonfocuscolourdesc'] = 'Düğmeye odaklanırken düğmenin kullandığı renk.';
$string['buttonhovercolor'] = 'Düğme arkaplanın vurgu rengi';
$string['buttonhovercolorcancel'] = 'Düğme vurgulu rengini iptal et';
$string['buttonhovercolordesc'] = 'Düğmenin üzerine gelindiğinde düğme arka planının değiştiği renk.';
$string['buttonhovercolordesccancel'] = 'Düğmenin üzerine gelindiğinde iptal düğmesinin değiştiği renk. <br/> Şeffaflık için kutuya şeffaf yazın.';
$string['buttonhovercolordescscnd'] = 'İkincil düğmenin, düğmenin üzerine gelindiğinde değiştiği renk.';
$string['buttonhovercolorscnd'] = 'İkincil düğmenin üzerine gelme rengi';
$string['buttonlogincolor'] = 'Oturum açma düğmesinin rengi';
$string['buttonlogincolordesc'] = 'Giriş düğmesinin rengi.';
$string['buttonloginheight'] = 'Giriş düğmesinin yüksekliğini ayarlayın';
$string['buttonloginheightdesc'] = 'Yalnızca üst başlıkta bir giriş formu kullanıldığında etkilidir.';
$string['buttonloginhovercolor'] = 'Oturum açma düğmesinin fareyle üzerine gelme rengi';
$string['buttonloginhovercolordesc'] = 'Giriş düğmesinin fareyle üzerine gelme rengi.';
$string['buttonloginmargintop'] = 'Giriş düğmesinin üst kenar boşluğunu ayarlayın';
$string['buttonloginmargintopdesc'] = 'Giriş düğmesinin aralığının / konumunun değiştirilmesine izin verir.';
$string['buttonloginpadding'] = 'Oturum açma düğmesi için dolguyu ayarlayın';
$string['buttonloginpaddingdesc'] = 'Daha yüksek sayı = daha büyük düğme.';
$string['buttonlogintextcolor'] = 'Oturum açma düğmesi metin rengi';
$string['buttonlogintextcolordesc'] = 'Giriş düğmesinde kullanılan metnin rengi.';
$string['buttonradius'] = 'Düğme yarıçapını ayarlayın';
$string['buttonradiusdesc'] = 'Daha yüksek yarıçap = eğimli düğmeler, daha düşük yarıçap = kare düğmeler.';
$string['buttonsettings'] = 'Düğmeler';
$string['buttonsettingsheading'] = 'Bu temanın düğmelerini özelleştirin.';
$string['buttontextcolor'] = 'Düğme metni rengi';
$string['buttontextcolorcancel'] = 'Düğme metni rengini iptal et';
$string['buttontextcolordesc'] = 'Düğmelerde kullanılan metnin rengi.';
$string['buttontextcolordesccancel'] = 'İptal düğmelerinde kullanılan metnin rengi.';
$string['buttontextcolordescscnd'] = 'İkincil düğmelerde kullanılan metnin rengi.';
$string['buttontextcolorscnd'] = 'İkincil düğme metni rengi';
$string['buttontextfocuscolour'] = 'Düğme odak metni rengi';
$string['buttontextfocuscolourdesc'] = 'Düğmeye odaklanırken düğmenin kullandığı metin rengi.';
$string['buttontexthovercolor'] = 'Düğme metni vurgu rengi';
$string['buttontexthovercolordesc'] = 'Düğmenin üzerine gelindiğinde düğme metninin değişeceği renk.';
$string['cachedef_adaptablefontawesomeiconmapping'] = 'Önbellek font awesome simgeleri';
$string['categoryhavecustomheader'] = 'Kategori özel başlığı';
$string['categoryhavecustomheaderdesc'] = 'Özel bir başlığa sahip olacak üst düzey kategorileri seçin. Birden fazla seçmek veya bir kategori seçimini kaldırmak için \'Ctrl\' tuşunu kullanın. Güncellemek için sayfayı kaydedin ve yeniden meshleyin Not: Seçilenin alt kategorileri, ayar değerlerini devralır.';
$string['categoryheaderlogo'] = '\'{$a->id}\' kimliğine sahip \'{$a->name}\' kategorisi logosu';
$string['categoryheaderssettings'] = 'Kategori başlıkları';
$string['categoryheaderssettingsdesc'] = 'Bir kategori içindeki başlıklara ilişkin ayarları belirleyin.';
$string['categoryheaderssettingsheading'] = 'Bir veya daha fazla üst düzey kategori ve altının başlığını değiştirin.';
$string['cdefaulticon'] = 'Kurslarım varsayılan simgesi';
$string['chiddenicondesc'] = 'Gizli kurslar için kullanılacak \'fa-\' ön eki olmayan Font Awesome simgesi. Boşsa varsayılan kullanılacaktır.';
$string['cneveraccessedicon'] = 'Kurslarıma hiç erişilmedi simgesi';
$string['collapsedtopicscoloursenableddesc'] = 'Adaptable\'ın \'sectionheadingcolor\' ve \'coursesectionheaderbg\' ayarları yerine Daraltılmış Konular\'ın ön ve arka plan renk ayarlarını kullanın.';
$string['colorsettings'] = 'Renkler';
$string['colorsettingsheading'] = 'Temadakullanılan ana renkleri değiştirin.';
$string['configtabtitle'] = 'Ayarlar';
$string['configtitle'] = 'Adaptable';
$string['course'] = 'Kurs';
$string['courseactivitynavigationenabled'] = 'Etkinlik gezintisi';
$string['courseactivitynavigationenableddesc'] = 'Etkinlik gezintisi etkinleştirildi.';
$string['courseindexenabled'] = 'Etkinleştirildi';
$string['courseindexenableddesc'] = '\'Kurs Dizini\'ni etkinleştirin veya devre dışı bırakın.';
$string['courseindexitemcolor'] = 'Renk ögeleri';
$string['courseindexitemcolordesc'] = 'Bir kurstaki \'Ders Dizinii öğe rengi.';
$string['courseindexitemhovercolor'] = 'Öğenin vurgu rengi';
$string['courseindexitemhovercolordesc'] = 'Bir kurstaki \'Kurs Dizini\' üzerindeki öğenin vurgulu rengi.';
$string['courseindexpageitembgcolor'] = 'Sayfa ögeleri Arka plan rengi';
$string['courseindexpageitembgcolordesc'] = 'Bir kurstaki \'Ders Dizini\'ndeki sayfa öğesinin arka plan rengi.';
$string['courseindexpageitemcolor'] = 'Sayfa öğesi rengi';
$string['courseindexpageitemcolordesc'] = 'Bir kurstaki \'Ders Dizini\'ndeki sayfa öğesi rengi.';
$string['courseindexsettings'] = 'Kurs Dizini';
$string['courseindexsettingsdesc'] = 'Kurs Dizinini özelleştirin.';
$string['courseindexsettingsheading'] = 'Kurs dizini ayarları';
$string['coursepageblocksenableddesc'] = 'Kurs sayfasında özel blok bölgelerini (üst ve alt) etkinleştirebilir / devre dışı bırakabilirsiniz.  Daha sonra blokları oluşturduğunuz bölgelere sürükleyip bırakabilirsiniz.';
$string['coursepageheaderhidesitetitle'] = 'Kurs sayfalarında site başlığını gizle';
$string['coursepagesidebarinfooterenabled'] = 'Kenar çubuğunu Kurs sayfasında alt bilgiye taşı';
$string['coursepagesidebarinfooterenableddesc'] = 'Kenar çubuğunu altbilgiye taşıyarak geniş kurs sayfası yerleşimi.';
$string['coursepagesidebarinfooterenabledsection'] = 'Genel Ayarlar';
$string['coursepagesidebarinfooterenabledsectiondesc'] = 'Kurs biçimlerinin çoğu için ortak ayarlar.';
$string['courses'] = 'Kurslar';
$string['coursesearch'] = 'Kurs arama';
$string['coursesectionactivityassignbgcolor'] = 'Ödev etkinliği arka plan rengi';
$string['coursesectionactivityassignbgcolordesc'] = 'Ödev etkinliği arka plan rengini ayarlayın. Şeffaflık için kutuya <strong>şeffaf</strong> yazın.';
$string['coursesectionactivityassignleftbordercolor'] = 'Ödev etkinliği sol kenarlık görüntüleme rengi';
$string['coursesectionactivityassignleftbordercolordesc'] = 'Sol kenarlığın rengini ayarla.';
$string['coursesectionactivitybordercolor'] = 'Kurs bölümü etkinliği alt kenarlık rengi';
$string['coursesectionactivitybordercolordesc'] = 'Kurs bölümü etkinliği alt sınırının rengini ayarlayın.';
$string['coursesectionactivityborderstyle'] = 'Kurs bölümü etkinliği alt kenarlık biçimi';
$string['coursesectionactivityborderstyledesc'] = 'Kurs bölümü etkinliği alt kenarlığının biçimini ayarlayın.';
$string['coursesectionactivityborderwidth'] = 'Kurs bölümü etkinliği alt kenar genişliği';
$string['coursesectionactivityborderwidthdesc'] = 'Kurs bölümü etkinliğinin altında görünen kenarlığın genişliğini ayarlayın.';
$string['coursesectionactivitycolors'] = 'Kurs bölümü etkinlik seçenekleri';
$string['coursesectionactivityforumbgcolor'] = 'Forum etkinliği arka plan rengi';
$string['coursesectionactivityforumbgcolordesc'] = 'Forum etkinliği arka plan rengini ayarlayın. Şeffaflık için kutuya <strong>şeffaf</strong> yazın.';
$string['coursesectionactivityforumleftbordercolor'] = 'Forum etkinliği sol kenarlık görüntüleme rengi';
$string['coursesectionactivityforumleftbordercolordesc'] = 'Sol kenarlığın rengini ayarlayın.';
$string['coursesectionactivityheadingcolour'] = 'Kurs bölümü aktivite başlığı rengi';
$string['coursesectionactivityheadingcolourdesc'] = 'Kurs ana sayfasında görüntülenen tıklanabilir etkinliklerin rengi.';
$string['coursesectionactivityiconsize'] = 'Kurs bölümü etkinlik simgesi boyutu';
$string['coursesectionactivityquizbgcolor'] = 'Sınav etkinliğ arkaplan rengi';
$string['coursesettings'] = 'Kurslar';
$string['customcoursesubtitledesc'] = 'Kurs başlığı için kullanıcı profili özel alanının adı.';
$string['dangericoncolor'] = 'İkaz sime rengi';
$string['dangericoncolordesc'] = 'Özellikle zorunlu alanlarda kullanılan uyarı/tehlike simgesinin rengini ayarlayın.';
$string['dashblocksenableddesc'] = 'Özel blok bölgelerini \'Gösterge Paneli\' sayfasında etkinleştirebilir / devre dışı bırakabilirsiniz.  Daha sonra blokları oluşturduğunuz bölgelere sürükleyip bırakabilirsiniz.';
$string['disabled'] = 'Devre dışı';
$string['discardbuttontext'] = 'İptal';
$string['displayparticipantsdesc'] = 'Menüdeki katılımcılar öğesini görüntüleyin.';
$string['edithorizontalpadding'] = 'Düzenleme düğmelerinin yatay dolgusunu ayarlayın';
$string['editoffbk'] = 'Bu sayfanın \'Kapalı\' düğme arka planını düzenleme ve özelleştirme';
$string['editoffbkdesc'] = 'Düzenleme için arka plan rengini ayarlayın ve bu sayfayı özelleştir düğmesini \'Kapalı\' duruma getirin.';
$string['editonbk'] = 'Bu sayfanın düğme arka planını düzenleme ve özelleştirme';
$string['editonbkdesc'] = 'Düzenleme için arka plan rengini ayarlayın ve bu sayfa düğmesini özelleştirin.';
$string['editsettingsbutton'] = 'Ayarları ve düğme görüntüsünü düzenle';
$string['enableaccesstool'] = 'Erişilebilirlik  araçları';
$string['enableaccesstooldesc'] = 'Kullanıcıların "Erişilebilirlik Aracı" tercih sayfasına bir bağlantı görüntüleyin - Not: Bunun için \'<a href="https://github.com/sharpchi/moodle-local_accessibilitytool" target="blank">Erişilebilirlik Aracı Eklentisi</a>\' gerekir.';
$string['enablealert'] = '{$a} uyarısını etkinleştir';
$string['enablealertdesc'] = '{$a} uyarısını etkinleştirin.';
$string['enablealerts'] = 'Uyarıları etkinleştirme/devre dışı bırakma';
$string['enablealertsdesc'] = 'Site uyarılarını etkinleştirin / devre dışı bırakın, kurs değil, \'alerthiddencourse\' ayarına bakın.';
$string['enablealertstriptags'] = 'Html etiketlerini uyarılardan otomatik olarak çıkarın';
$string['enablealertstriptagsdesc'] = 'Etkinleştir, uyarı mesajlarını otomatik olarak temizler ve mesajlarda html / bağlantılar kullanmanıza izin vermek için devre dışı bırakır, ancak html görünümünde manuel olarak temizlemeniz gerekir.';
$string['enableanalytics'] = 'Google Analytics\'i etkinleştirin';
$string['enableanalyticsdesc'] = 'Moodle sitenizde Google Analytics ayarlarını etkinleştirin';
$string['enableavailablecourses'] = '"Mevcut Kursları"Göster';
$string['enableavailablecoursesdesc'] = 'Ön sayfada "Mevcut Kurslar" metnini görüntüleyin.';
$string['enablebadges'] = 'Rozetler';
$string['enablebadgesdesc'] = 'Kullanıcı rozetlerine bir bağlantı görüntüleyin.';
$string['enableblog'] = 'Bloglarımı etkinleştir';
$string['enablecoursetitle'] = 'Kurs başlığı';
$string['enablecoursetitledesc'] = 'Kurs başlığını görüntülemek için modu ayarlayın.';
$string['enabledtabbedprofileeditprofilelink'] = 'Profili düzenleme bağlantısını etkinleştir';
$string['enabledtabbedprofileuserpreferenceslink'] = 'Tercihler bağlantısını etkinleştir';
$string['enableeditprofile'] = 'Profili düzenle';
$string['enablegrades'] = 'Notlar';
$string['enablemenus'] = 'Menüleri etkinleştir';
$string['enablemy'] = 'Gösterge Paneli';
$string['enablenavbarwhenloggedout'] = 'Oturum kapatıldığında gezinme çubuğunu etkinleştir';
$string['enablenavbarwhenloggedoutdesc'] = 'Oturum kapatıldığında bile gezinme çubuğunu gösterir.  Yalnızca yardım ve araçlar menüsüyle sınırlıdır.';
$string['enablenote'] = 'Bildirimlerim';
$string['enableposts'] = 'Postalarım';
$string['enablepref'] = 'Tercihlerim';
$string['enableprivatefiles'] = 'Özel dosyalar';
$string['enableprofile'] = 'Kullanıcı profili';
$string['enableshowhideblocks'] = 'Blokları Göster Gizle\'yi Etkinleştir';
$string['enabletoolsmenus'] = 'Araç menülerini etkinleştir';
$string['events'] = 'Etkinlikler';
$string['fav'] = 'FontAwesome 6 Ücretsiz';
$string['favicon'] = 'Site simgesi';
$string['favoff'] = 'Core FontAwesome 6 Ücretsiz sürüm';
$string['fontnamedesc'] = 'Sitenin ana yazı tipini seçin.';
$string['fontsettings'] = 'Yazı tipleri';
$string['fontsize'] = 'Ana yazı tipi boyutu';
$string['fontsubset'] = 'Google yazı tipleri alt kümesi';
$string['fonttitlecolor'] = 'Site/kurs başlığı yazı tipi rengi';
$string['footerbkcolor'] = 'Altbilgi arka plan rengi';
$string['footerbkcolordesc'] = 'Altbilgi arka plan rengini ayarlayın.';
$string['footerblocksplacement'] = 'Altbilgi bloklarının yerleşimi';
$string['footerblocksplacement1'] = 'Site geneli';
$string['footerblocksplacement2'] = 'Yalnızca ana sayfa';
$string['footerblocksplacement3'] = 'Asla';
$string['footerblocksplacementdesc'] = 'Üst alt bilgi bloklarının nerede görüntüleneceğini kontrol edin.  Site geneli varsayılandır.';
$string['footercontent'] = 'Altbilgi içeriği bölümü';
$string['footercontentdesc'] = 'Altbilgi bölümüne içerik ekleyin.';
$string['footerdesc'] = 'Altbilgi bölümü için bir başlık ekleyin.';
$string['footerheader'] = 'Altbilgi başlığı bölümü';
$string['footerlayoutrow'] = 'Altbilg yerleşimi oluşturucusu';
$string['frontpageblocksenableddesc'] = 'Ön sayfada özel blok bölgelerini etkinleştirebilir / devre dışı bırakabilirsiniz.  Daha sonra blokları oluşturduğunuz bölgelere sürükleyip bırakabilirsiniz.';
$string['gdprbutton'] = 'Veri saklama özeti düğmesi';
$string['gdprbuttondesc'] = 'Altbilgide veri saklama özeti düğmesini görüntüleyin.';
$string['headersearchandsocialnone'] = 'Yok';
$string['headersearchandsocialsocialheader'] = 'Sosyal Wiki başlığı';
$string['home'] = 'Anasayfa';
$string['inprogress'] = 'Devam ediyor';
$string['layoutaddcontentdesc1'] = 'Yapılandırdınız';
$string['layoutcheck'] = 'Yerleşimi kotrol et';
$string['layoutdesc'] = 'Kullanıcıların göreceği varsayılan düzeni ayarlayın.';
$string['layoutsettings'] = 'Düzen';
$string['layoutsettingsheading'] = 'Site düzeninin özelliklerini kontrol edin';
$string['leftblocks'] = 'Sol Taraf';
$string['linkcolor'] = 'Bağlantı rengi';
$string['loginbgimage'] = 'Arka plan görüntüsü';
$string['loginfooter'] = 'Giriş sayfası altbilgisi';
$string['loginheader'] = 'Giriş sayfası başlığı';
$string['loginplaceholder'] = 'Kullanıcı adı';
$string['logintextbutton'] = 'Giriş yap';
$string['logintextbuttonwhenoidc'] = 'Misafir/Manuel Giriş';
$string['logintextmanualbutton'] = 'Hesap girişini test edin';
$string['logo'] = 'Logo';
$string['maincolor'] = 'Ana renk';
$string['marketingvisibleloggedin'] = 'Giriş';
$string['menubkcolor'] = 'Ana menü Arka plan rengi';
$string['menubkcolordesc'] = 'Ana menü arka plan rengini ayarlayın.';
$string['menufontcolor'] = 'Ana menü yazı tipi rengi';
$string['menusettings'] = 'Başlık menüsü';
$string['more'] = 'Daha fazla';
$string['myblogs'] = 'Bloglarım';
$string['mycoursesmenulimit'] = 'Kurslarım menü sınırı';
$string['mysites'] = 'Kurslarım';
$string['mysitesdisabled'] = 'Devredışı bırak';
$string['navbardropdownborderradius'] = 'Açılır menü kenarlık yarıçapı';
$string['newmenufielddesc'] = 'Özel profil alanı için erişim kuralı ekleyin, örneğin: usertype=student.';
$string['newmenuheading'] = 'Üst Menü';
$string['newmenurequirelogin'] = 'Oturum açmayı zorunlu tut';
$string['newmenurequirelogindesc'] = 'Etkinleştirilirse bu menü yalnızca oturum açmış kullanıcılar tarafından görülebilecektir.';
$string['newmenutitle'] = 'Üst menü başlığı';
$string['newmenutitledefault'] = 'Menü';
$string['newmenutitledesc'] = 'Sitenizin başlığında görünecek açılır listenin başlığı.';
$string['newstickercount'] = 'Haber şeridi bölümlerinin sayısı';
$string['newstickercountdesc'] = 'Farklı hedef kitleleri hedeflemek için erişim kurallarıyla birden fazla haber şeridi bölümü tanımlayın.';
$string['newstickersettings'] = 'Haber şeridi';
$string['nextactivity'] = 'Sonraki etkinlik';
$string['nextsection'] = 'Sonraki bölüm';
$string['none'] = 'Yok';
$string['nostyle'] = 'Stil yok';
$string['onetopicdesc'] = '\'<a href="https://moodle.org/plugins/format_onetopic">Tek Konulu Kurs Formatı</a>\'nın (sitenizde kullanılıyorsa) görünümünü özelleştirin.';
$string['pageheaderalternative'] = 'Alternatif';
$string['pageheaderheight'] = 'Sayfa başlığı yüksekliği';
$string['pageheadernosearch'] = 'Arama yok';
$string['pageheaderoriginal'] = 'Orijinal';
$string['passwordplaceholder'] = 'Şifre';
$string['past'] = 'Geçmiş';
$string['pastcourses'] = 'Geçmiş kurslar';
$string['people'] = 'Katılımcılar';
$string['piwikenabled'] = 'Etkinleştirilmiş';
$string['piwikenableddesc'] = 'Moodle için Matomo izlemeyi etkinleştirin.';
$string['piwikimagetrack'] = 'Görüntü izleme';
$string['piwikimagetrackdesc'] = 'JavaScript\'in devre dışı olduğu tarayıcılar için Moodle için resim izlemeyi etkinleştirin.';
$string['piwiksettings'] = 'Matomo (eski adıyla Piwik) analitiği';
$string['piwiksettingsdesc'] = 'Gelişmiş izleme için temiz URL oluşturun.';
$string['piwiksettingsheading'] = 'Matomo\'yu kur';
$string['piwiksiteid'] = 'Site kimliği';
$string['piwiksiteiddesc'] = 'Site Kimliğinizi girin.';
$string['piwiksiteurl'] = 'Matomo URL\'si';
$string['printbodyfontsize'] = 'Gövde yazı tipi boyutu';
$string['printbodyfontsizedesc'] = 'Gövde yazı tipinin boyutunu ayarlayın.';
$string['printlineheight'] = 'Satır yüksekliği';
$string['printlineheightdesc'] = 'Satır yüksekliğini ayarlayın.';
$string['privacy:metadata:preference:themeadaptablealertkey'] = 'Verilen uyarı.';
$string['privacy:request:preference:themeadaptablealertkey'] = 'Uyarı kimliği "{$a->alertid}" için kullanıcı tercihi "{$a->name}", verilen uyarı için "{$a->value}" değerine sahiptir, \'undismissable\' veya uyarının kullanıcı için var olduğunu temsil eden başka bir \'alertkey\'.';
$string['propertiesdesc'] = 'Bu bölümde mevcut Uyarlanabilir tema ayarlarını (özellikler) JSON formatında içe / dışa aktarabilirsiniz. Ayrıca bu Moodle kurulumundaki tüm mevcut ayarları da görüntüleyebilirsiniz.';
$string['propertiesexport'] = 'Özellikleri bir JSON dizesi olarak dışa aktarın';
$string['putpropertiesdesc'] = 'JSON dizesini yapıştırın ve \'Değişiklikleri kaydet\'.  İkaz!  Ayar değerlerini doğrulamaz ve bir \'Tüm önbellekleri temizle\' gerçekleştirir.';
$string['putpropertiesname'] = 'Özellikleri içe aktar';
$string['putpropertyproperties'] = 'Özellikler';
$string['putpropertyreport'] = 'Rapor:';
$string['putpropertyversion'] = 'sürüm:';
$string['region-content'] = 'İçerik';
$string['region-side-post'] = 'Sağ';
$string['region-side-pre'] = 'Sol';
$string['responsivecoursetitle'] = 'Kurs / site başlığı';
$string['responsiveheader'] = 'Ana başlık';
$string['responsiveheaderdesc'] = 'Ana başlığın hangi boyuttaki ekranlarda görüntülenmesini istersiniz?<br/>Başlığın tamamen kaldırılması, içindeki öğelerin de kaldırılmasına neden olur:<br/><ul><li>Sosyal Simgeler</li><li>Logo </li><li>Site / Ders Adı</li></ul>';
$string['responsivelogo'] = 'Logo';
$string['responsivepagefooter'] = 'Altbilgi';
$string['responsivesettings'] = 'Duyarlı yerleşim';
$string['responsivesettingsheading'] = 'Sitenizin farklı ekran boyutlarında nasıl davranacağını kontrol edin';
$string['responsivesitetitle'] = 'Site Başlığı';
$string['responsivesocial'] = 'Sosyal simgeler';
$string['responsiveticker'] = 'Haber şeridi';
$string['responsivetickerdesc'] = 'Haber şeridinin hangi boyuttaki ekranlarda görüntülenmesini istersiniz?';
$string['rightblocks'] = 'Sağ Taraf';
$string['savebuttontext'] = 'Değişiklikleri Kaydet';
$string['searchboxpadding'] = 'Başlık arama kutusu dolgusu';
$string['searchboxpaddingdesc'] = 'Başlıktayken arama kutusu için dolguyu ayarlayın (sosyal simgeler yerine kullanılıyorsa) < br />Örneğin 5px 10px 5px 10px (üst, sağ, alt, sol).< Br> Altında sosyal simgeler ayarlayabilirsiniz/../ yönetici / ayarlar.php?section = theme_adaptable_social " > Başlık Sosyal</a>ayarlar sayfası</strong>.';
$string['sectionheadingcolor'] = 'Bölüm başlığı metin rengi';
$string['sections'] = 'Bölümler';
$string['settingsalertbox'] = 'Uyarı kutusu';
$string['settingsanalytics'] = 'Analitikler';
$string['settingsblockicons'] = 'Simgeler';
$string['settingscolors'] = 'Renkler';
$string['settingscourses'] = 'Kurslar';
$string['settingsfonts'] = 'Yazı tipleri';
$string['settingsfootercolors'] = 'Altbilgi renkleri';
$string['settingsforumheading'] = 'Forum';
$string['settingsheadercolors'] = 'Başlık renkleri';
$string['settingsmaincolors'] = 'Ana renkler';
$string['settingsnavbarcolors'] = 'Gezinti çubuğu (gezinti çubuğu) renkleri';
$string['settingspagealertsettings'] = 'Uyarılar';
$string['settingspageblocksettings'] = 'Blok';
$string['settingstopicsweeks'] = 'Konu/Hafta';
$string['show'] = 'Göster';
$string['showfooterblocks'] = 'Altbilgi bloklarını gözterd';
$string['showusername'] = 'Kullanıcı adını göster';
$string['sidebaricon'] = 'Kenar çubuğunu göster / gizle';
$string['sitelinkslabel'] = 'Site bağlantıları';
$string['sitetitle'] = 'Site başlığını görüntüle';
$string['sitetitlecoursesdisabled'] = 'Devre Dışı - kurs sayfalarında yalnızca kurs başlıklarını göster';
$string['sitetitlecoursesenabled'] = 'Etkin - kurs sayfalarında site başlığını ve kurs başlıklarını göster';
$string['sitetitlecustom'] = 'Özel site başlığı kullanın (aşağıdaki \'sitetitletext\' kutusuna girin)';
$string['sitetitledefault'] = 'Moodle site başlığını kullanın (site adı)';
$string['sitetitledesc'] = '<a href="./../admin/settings.php?section=frontpagesettings" target="_blank">Ön Sayfa Ayarları</a>\'ndan varsayılan Moodle site başlığını görüntüleyin veya metin kutusuna özel bir site başlığı girin altında.';
$string['sitetitleoff'] = 'Site başlığını devre dışı bırak';
$string['sitetitletext'] = 'Site Başlığı';
$string['slidercaption'] = 'Sayt başlığı';
$string['sliderurl'] = 'Slayt bağlantısı URL\'si';
$string['socialheading'] = 'Sosyal sime ayarları';
$string['socialiconlist'] = 'Sosyal simge listesi';
$string['socialsearchicon'] = 'Moodle\'da ara';
$string['socialtarget'] = 'Sosyal bağlantılar açık hedef';
$string['socialtargetdesc'] = 'Sosyal bağlantıların nasıl açılmasını istersiniz (aynı veya yeni pencere).';
$string['socialtitledesc'] = 'Site genelinde arama kutusunu devre dışı bırakabilir ve yerine sosyal simgeleri / bağlantıları etkinleştirebilirsiniz. Simgeleri ayarlamak için aşağıdaki "Sosyal Simge Listesi" alanına sınırlandırılmış bir liste girin.<br/> Bu formatta olmalıdır:

url|başlık|simge

Örneğin:
<pre>
https://example.com/course/search.php|Search Moodle|fa-search
https://facebook.com/|Facebook|fa-square-facebook
https://X.com/|X|fa-square-x-twitter
https://twitter.com/|Twitter|fa-square-twitter
https://instagram.com|Instagram|fa-square-instagram
https://example.com|My Web|fa-globe
</pre>
Başvuru içinFont Awesome  Simgelerinin tam listesini \'  \'<a href="{$a}" target="_blank">here</a>\'burada</a>\' bulabilirsiniz.';
$string['standard'] = 'Standart';
$string['standardscreenwidth'] = 'Standart ekran genişliği';
$string['standardview'] = 'Standart görünüm';
$string['static'] = 'Statik';
$string['stylecover'] = 'Kapak';
$string['tabbedlayoutdashboard'] = 'Göstrge paneli sayfası sekmeli düzeni';
$string['tabbedlayoutdashboarddesc'] = 'Gösterge Paneli sayfası için sekmeli bir düzen kullanın.  Bu, tüm içeriği sekmeler halinde görüntüler, kurs içeriği bir sekmede bulunur ve diğer sekmelerdeki içeriği uyarlamanıza olanak tanır. Sekmelerin sırasını yapılandırmak için bu ayarı kullanın.';
$string['tabbedlayoutdashboardtab1condition'] = 'Birinci Sekme Özel Profil Alanı Kısıtlaması (isteğe bağlı)';
$string['tabbedlayoutdashboardtab1conditiondesc'] = 'Özel profil alanını kullanarak Sekme 1\'i görüntülemek için erişim kuralı ekleyin, örneğin: showtab1=true.';
$string['tabbedlayoutdashboardtab2condition'] = 'Sekme iki Özel Profil Alanı Kısıtlaması (isteğe bağlı)';
$string['tabbedlayouttablabelcourse'] = 'Kurs içeriği';
$string['tabbedlayouttablabelcourse1'] = 'İlk sekme';
$string['tabbedlayouttablabelcourse2'] = 'İkinci sekme';
$string['tabbedlayouttablabeldashboard'] = 'Gösterge paneli içeriği';
$string['tabbedlayouttablabeldashboard1'] = 'İlk sekme';
$string['tabbedlayouttablabeldashboard2'] = 'İkinci sekme';
$string['targetnewwindow'] = 'Yeni Pencere';
$string['targetsamewindow'] = 'Aynı pencere';
$string['templatesheading'] = 'Şablon ayarları';
$string['templatesheadingdesc'] = 'Şablonları geçersiz kıl.';
$string['templatessel'] = 'Geçersiz kılınacak şablonlar';
$string['templatesseldesc'] = 'Geçersiz kılınacak şablonları seçin, ardından her biri kendi sayfasında gösterilecektir.  Burada seçilmezse şablon etkinleştirilse bile geçersiz kılınmayacaktır.  Hiçbirini seçmek için \'Ctrl\' tuşunu kullanın.';
$string['templatessettings'] = 'Şablonlar';
$string['themechanges'] = 'Değişiklikler';
$string['themereadme'] = 'Beni oku';
$string['thiscourse'] = 'Bu kurs';
$string['ticker'] = 'Duyuru';
$string['tickerdefault'] = 'Görüntülenecek yeni haber yok';
$string['tickerdesc'] = 'Burada Moodle sitenizde yayınlanacak bir haber şeridi ayarlayabilirsiniz.
   Çok az yer kaplayan kaydırıcıya daha az müdahaleci bir alternatif olarak tasarlanmıştır.
   Kayan yazınızı ayarlamak için bir paragraf listesi girmeniz ve bu metne ihtiyacınız olan tüm köprüleri eklemeniz yeterlidir.
   <strong>Not:</strong> Kayan yazınız düzgün şekilde yüklenmezse HTML görünümüne geçin ve yalnızca p etiketleriniz olduğundan emin olun:
   <pre>
   <p>Birinci haber.....</p>
   <p>İkinci haber.....</p>
   </pre>';
$string['tickerfullscreen'] = 'Tam ekran genişliği';
$string['tickersettings'] = 'Haber bandı';
$string['tickersettingsheading'] = 'Haber şeridini ayarla';
$string['tickertext'] = 'Haber bandı metni';
$string['tilescontactstitle'] = 'Kurs iletişim kişisi rolünü göster';
$string['tilescontactstitledesc'] = 'Kurs iletişim kişisinin rolünü gösterin/gizleyin.  Görüntülenmezse, her kişiden önce bir resim görüntülenecektir.';
$string['tilesshowallcontacts'] = 'Kurstaki tüm kişileri göster';
$string['tilesshowallcontactsdesc'] = 'Kurstaki tüm kişileri veya yalnızca birini gösterin.';
$string['tilesshowcontacts'] = 'Kurs iletişim kişilerini göster';
$string['togglenavigation'] = 'Gezintiyi değiştir';
$string['toolsmenu'] = 'Araçlar menüsü açılır menüsü';
$string['toolsmenudesc'] = 'Bağlantıları buraya ekleyin.';
$string['toolsmenufield'] = 'Özel profil alanı adı=Değer (isteğe bağlı)';
$string['toolsmenufielddesc'] = 'Özel profil alanı için erişim kuralı ekleyin, örneğin: usertype=student.';
$string['toolsmenuheading'] = 'Araçlar menüsü';
$string['toolsmenuheadingdesc'] = 'Ana gezinme çubuğuna bir açılır menü ekleyin. Bağlantıları bir araçlar menüsü altında (ana gezinme çubuğunda) gösterilecek şekilde yapılandırabilirsiniz. \'Metin|url|başlık|diller|fontawesome sınıfları|kontrol etme yeteneği\' biçiminde. Yalnızca ihtiyacınız olanı girin. Bir şeye ihtiyacınız yoksa ancak daha ileride başka bir şeye ihtiyacınız varsa boş bırakın ancak yine de \'|\' işaretini kullanın. sınırlayıcı. Örneğin: \'metin|url|||harika yazı tipleri\'. Kullanmak istediğiniz simgeye ilişkin FontAwesome(Free) sınıflarını bulmak için <a href="https://fontawesome.com/search?o=r&m=free" target="_blank">Font Awesome ücretsiz</a\'a gidin. a> ve simgeyi arayın. \'mezuniyet-cap\' gibi bir adı veya \'fa-solid fa-graduation-cap\' sınıflarının tam listesini kullanabilirsiniz. Örneğin:<pre>
Kayıt Ekranı|https://mysite.localhost|Kayıt Ekranı||video
Fotoğraflar|https://mysite.localhost|Fotoğraflar||fa-solid fa-image
Sınav Saati|https://mysite.localhost|Sınav Saati|en|saat
Cloc arholiad|https://mysite.localhost|Cloc arholiad|cy|clock
</pre>';
$string['toolsmenuheadingindex'] = 'Araçlar menüsü {$a}';
$string['toolsmenuscount'] = 'Araç menülerinin sayısı';
$string['toolsmenuscountdesc'] = 'Ana gezinme çubuğuna eklemek istediğiniz araç menülerinin sayısını ayarlayın.';
$string['toolsmenutitle'] = 'Araçlar menü başlığı';
$string['toolsmenutitledefault'] = 'Araçlar';
$string['toolsmenutitledesc'] = 'Ana gezinme çubuğunda görüntülemek istediğiniz menünün başlığını ekleyin.';
$string['topicsweeks'] = 'Konular / Haftalar kurs biçimi';
$string['topicsweeksdesc'] = '\'Konular\' / \'Haftalar\' kurs biçimi için stilleri ayarlayın';
$string['topmenufontsize'] = 'Üst menü yazı tipi boyutu';
$string['topmenufontsizedesc'] = 'Üst menülerin yazı tipi boyutunu ayarlayın.';
$string['topmenuscount'] = 'Üst menülerin sayısı';
$string['topmenuscountdesc'] = 'Tema başlığına eklemek istediğiniz üst menülerin sayısını ayarlayın.';
$string['turngradereditingoff'] = 'Not veren düzenlemeyi kapatma';
$string['turngradereditingon'] = 'Not veren düzenlemesini aç';
$string['usermenu'] = 'Kullanıcı menüsü';
$string['usernameposition'] = 'Kullanıcı adı pozisyonu';
$string['usernamepositiondesc'] = 'Kullanıcı adının konumunu \'Sol\' veya \'Sağ\' olarak ayarlayın.';
$string['usernav'] = 'Başlık kullanıcısı';
$string['usernavdesc'] = 'Kullanıcı gezinti açılır menüsünde görünen tüm öğeleri kontrol etmenizi sağlar';
$string['usernavheading'] = 'Kullanıcı gezinme açılır menüsünü özelleştirme';
$string['usernodescription'] = 'Kullanıcı henüz açıklamasını güncellemedi.';
$string['usernointerests'] = 'Kullanıcı henüz ilgi alanlarını güncellemedi.';
$string['usersettings'] = 'Kullanıcı profili';
$string['usersettingsdesc'] = 'Kullanıcı profili ayarlarını yapın.';
$string['usersettingsheading'] = 'Kullanıcı profilinin kontrol özellikleri';
$string['versionalpha'] = 'Alfa sürümü - Neredeyse kesinlikle hatalar içeriyor.  Bu \'yalnızca\' geliştiricilere yönelik bir geliştirme sürümüdür!  Üretim sunucusuna kurulum yapmayı aklınızdan bile geçirmeyin!';
$string['versionbeta'] = 'Beta sürümü - Hata içermesi muhtemeldir.  Yalnızca bir test sunucusunda yöneticiler tarafından test edilmeye hazırdır.';
$string['versioninfo'] = 'Sürüm {$a->release}, sürüm {$a->version} Moodle\'da {$a->moodle}';
$string['versionrc'] = 'Sürüm adayı sürümü - Hatalar içerebilir.  Bir üretim sunucusu üzerinde düşünmeden önce bir test sunucusunda tamamen kontrol edin.';
$string['versionstable'] = 'Kararlı sürüm - Evrende tümün bulmak için yeterli zaman kalmadığından hatalar içerebilir.  Ürününüzüün sunucuna yüklemeden önce bir test sunucusunda kontrol edin, cidden yapın!  Pişman olmayacaksınız ve mutlu olana kadar özelleştirebilecek, ardından ayar değerlerini aktarmak için \'Ayarları içe / dışa aktar\' işlevini kullanabileceksiniz.';
$string['wide'] = 'Tam ekren';
