<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'error', language 'lo', version '4.4'.
 *
 * @package     error
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['TODO'] = 'TODO';
$string['activityisscheduledfordeletion'] = 'ກຳລັງລຶບກິດຈະກຳ...';
$string['agedigitalconsentmapinvalidage'] = '"{$a}" ບໍ່ແມ່ນຄ່າທີ່ຖືກຕ້ອງສໍາລັບອາຍຸ.';
$string['agedigitalconsentmapinvalidcomma'] = '"{$a}" ມີຕົວແຍກໝາຍຈຸດຫຼາຍ ຫຼື ໜ້ອຍກວ່າໜຶ່ງ.';
$string['agedigitalconsentmapinvalidcountry'] = '"{$a}" ບໍ່ແມ່ນຄ່າທີ່ຖືກຕ້ອງສໍາລັບປະເທດ.';
$string['agedigitalconsentmapinvaliddefault'] = 'ຄ່າເລີ່ມຕົ້ນ (*) ຂາດຫາຍໄປ.';
$string['agelocationverificationdisabled'] = 'ປິດການນຳໃຊ້ການຢັ້ງຢືນອາຍຸ ແລະ ສະຖານທີ່ແລ້ວ';
$string['alreadyloggedin'] = 'ທ່ານໄດ້ເຂົ້າສູ່ລະບົບເປັນ {$a} ຢູ່ກ່ອນແລ້ວ, ທ່ານຕ້ອງອອກຈາກລະບົບກ່ອນເຂົ້າສູ່ລະບົບເປັນຜູ້ໃຊ້ອື່ນ.';
$string['authnotexisting'] = 'ບໍ່ມີປລັກອິນການອະນຸຍາດ';
$string['backupcontainexternal'] = 'ໄຟລ໌ສໍາຮອງຂໍ້ມູນນີ້ປະກອບມີເຈົ້າພາບເຄືອຂ່າຍ Moodle ພາຍນອກທີ່ບໍ່ໄດ້ຖືກຕັ້ງຄ່າຢູ່ໃນທ້ອງຖິ່ນ';
$string['backuptablefail'] = 'ຕາຕະລາງສຳຮອງບໍ່ສາມາດຕັ້ງໄດ້ສຳເລັດ!';
$string['blockcannotconfig'] = 'ບລັອກນີ້ບໍ່ຮອງຮັບການຕັ້ງຄ່າທົ່ວໂລກ';
$string['blockcannotinistantiate'] = 'ເກີດບັນຫາໃນການສ້າງວັດຖຸປິດບລັອກດ່ວນ';
$string['blockcannotread'] = 'ບໍ່ສາມາດອ່ານຂໍ້ມູນສໍາລັບ blockid = {$a}';
$string['blockdoesnotexist'] = 'ບໍ່ມີບລັອກນີ້';
$string['blockdoesnotexistonpage'] = 'ບລັອກນີ້ (id={$a->instanceid}) ບໍ່ມີຢູ່ໃນ ໜ້ານີ້ ({$a->url}).';
$string['blocknameconflict'] = 'ການຂັດແຍ້ງໃນການຕັ້ງຊື່: ບລັອກ {$a->name} ມີຊື່ດຽວກັນກັບບລັອກທີ່ມີຢູ່: {$a->conflict}!';
$string['callbackrejectcomment'] = 'ການເອີ້ນກັບຄືນຄຳເຫັນໄດ້ປະຕິເສດຄຳເຫັນນີ້.';
$string['cannotaddcoursemodule'] = 'ບໍ່ສາມາດເພີ່ມຊຸດລາຍວິຊາໃໝ່ໄດ້';
$string['cannotaddcoursemoduletosection'] = 'ບໍ່ສາມາດເພີ່ມຊຸດລາຍວິຊາໃໝ່ໃສ່ພາກນັ້ນໄດ້';
$string['cannotaddmodule'] = 'ບໍ່ສາມາດເພີ່ມຊຸດ {$a} ໃສ່ລາຍການຊຸດໄດ້!';
$string['cannotaddnewmodule'] = 'ບໍ່ສາມາດເພີ່ມຊຸດໃໝ່ຂອງ {$a} ໄດ້';
$string['cannotaddrss'] = 'ທ່ານບໍ່ໄດ້ຮັບອະນຸຍາດໃຫ້ເພີ່ມຟີດ rss ໄດ້';
$string['cannotaddthisblocktype'] = 'ທ່ານບໍ່ສາມາດເພີ່ມບລັອກ {$a} ໃສ່ໜ້ານີ້ໄດ້.';
$string['cannotassignrole'] = 'ບໍ່ສາມາດກຳນົດບົດບາດໄດ້ໃນລາຍວິຊາ';
$string['cannotassignrolehere'] = 'ທ່ານຍັງບໍ່ໄດ້ຮັບອະນຸຍາດໃຫ້ແຕ່ງຕັ້ງໜ້າທີ່ນີ້ (id = {$a->roleid}) ໃນບໍລິບົດນີ້ ({$a->context})';
$string['cannotassignselfasparent'] = 'ບໍ່ສາມາດແຕ່ງຕັ້ງຕົວເອງເປັນພໍ່ແມ່ໄດ້!';
$string['cannotcallscript'] = 'ເຈົ້າບໍ່ສາມາດເອີ້ນສະຄຣິບນີ້ໃນແບບນັ້ນໄດ້';
$string['cannotcallusgetselecteduser'] = 'ເຈົ້າບໍ່ສາມາດໂທຫາ user_selector::get_selected_user ຖ້າການເລືອກຫຼາຍອັນເປັນຄວາມຈິງ.';
$string['cannotcreatebackupdir'] = 'ບໍ່ສາມາດສ້າງໂຟນເດີ backupdata. ຜູ້ຄວບຄຸມເວັບໄຊທ໌ຕ້ອງການແກ້ໄຂການອະນຸຍາດໄຟລ໌';
$string['cannotcreatecategory'] = 'ບໍ່ໄດ້ໃສ່ໃນປະເພດ';
$string['cannotcreatedboninstall'] = '<p>ບໍ່ສາມາດສ້າງຖານຂໍ້ມູນໄດ້.</p>
<p>ຖານຂໍ້ມູນທີ່ລະບຸນັ້ນບໍ່ມີຢູ່ ແລະ ຜູ້ໃຊ້ທີ່ໃຫ້ມາບໍ່ໄດ້ຮັບອະນຸຍາດໃຫ້ສ້າງຖານຂໍ້ມູນ. </p>
<p> ຜູ້ຄວບຄຸມເວັບໄຊທ໌ຄວນກວດສອບການຕັ້ງຄ່າຖານຂໍ້ມູນ.</p>';
$string['cannotcreategroup'] = 'ເກີດຄວາມຜິດພາດໃນການສ້າງກຸ່ມ';
$string['cannotcreatelangbase'] = 'ຜິດພາດ: ບໍ່ສາມາດສ້າງບັນຊີພາສາພື້ນຖານໄດ້';
$string['cannotcreatelangdir'] = 'ບໍ່ສາມາດສ້າງບັນຊີລາຍຊື່ພາສາໄດ້';
$string['cannotcreateorfindstructs'] = 'ເກີດຄວາມຜິດພາດໃນການຊອກຫາ ຫຼື ສ້າງໂຄງສ້າງພາກສ່ວນສຳລັບລາຍວິຊານີ້';
$string['cannotcreatepopupwin'] = 'ອົງປະກອບທີ່ບໍ່ໄດ້ລະບຸ - ບໍ່ສາມາດສ້າງ ໜ້າຈໍປັອບອັບໄດ້';
$string['cannotcreatesitedir'] = 'ບໍ່ສາມາດສ້າງໂຟນເດີເວັບໄຊທ໌ໄດ້. ຜູ້ຄວບຄຸມເວັບໄຊທ໌ຕ້ອງການແກ້ໄຂການອະນຸຍາດໄຟລ໌.';
$string['cannotcreatetempdir'] = 'ບໍ່ສາມາດສ້າງບັນຊີລາຍຊື່ຊົ່ວຄາວໄດ້';
$string['cannotcreateuploaddir'] = 'ບໍ່ສາມາດສ້າງໂຟນເດີອັບໂຫຼດໄດ້. ຜູ້ຄວບຄຸມເວັບໄຊທ໌ຕ້ອງການແກ້ໄຂການອະນຸຍາດໄຟລ໌.';
$string['cannotcustomisefiltersblockuser'] = 'ທ່ານບໍ່ສາມາດປັບແຕ່ງການຕັ້ງຄ່າຕົວກັ່ນຕອງຢູ່ໃນຜູ້ໃຊ້ ຫຼື ບລັອກບໍລິບົດໄດ້.';
$string['cannotdeletebackupids'] = 'ບໍ່ສາມາດລຶບລະຫັດປະຈຳຕົວສຳຮອງກ່ອນ ໜ້າໄດ້';
$string['cannotdeletecategorycourse'] = 'ລຶບລາຍວິຊາ \'{$a}\' ບໍ່ສໍາເລັດ.';
$string['cannotdeletecategoryquestions'] = 'ບໍ່ສາມາດລຶບຄຳຖາມອອກຈາກປະເພດ \'{$a}\' ໄດ້';
$string['cannotdeletecourse'] = 'ເຈົ້າບໍ່ໄດ້ຮັບອະນຸຍາດໃຫ້ລຶບລາຍວິຊານີ້';
$string['cannotdeletecustomfield'] = 'ເກີດຄວາມຜິດພາດໃນການລຶບຊ່ອງຂໍ້ມູນແບບກຳນົດເອງ';
$string['cannotdeletedir'] = 'ບໍ່ສາມາດລຶບ ({$a}) ໄດ້';
$string['cannotdeletefile'] = 'ບໍ່ສາມາດລຶບໄຟລ໌ນີ້ໄດ້';
$string['cannotdeleterole'] = 'ມັນບໍ່ສາມາດລຶບໄດ້, ເພາະວ່າ {$a}';
$string['cannotdeleterolewithid'] = 'ບໍ່ສາມາດລຶບໜ້າທີ່ດ້ວຍລະຫັດປະຈຳຕົວ {$a} ໄດ້';
$string['cannotdeletethisrole'] = 'ເຈົ້າບໍ່ສາມາດລຶບໜ້າທີ່ນີ້ໄດ້ເພາະວ່າມັນຖືກໃຊ້ໂດຍລະບົບ, ຫຼື ເພາະວ່າມັນເປັນໜ້າທີ່ສຸດທ້າຍທີ່ມີຄວາມສາມາດຂອງຜູ້ຄວບຄຸມລະບົບ.';
$string['cannotdisableformat'] = 'ຮູບແບບມາດຕະຖານບໍ່ສາມາດປິດໃຊ້ງານໄດ້.';
$string['cannotdownloadcomponents'] = 'ບໍ່ສາມາດດາວໂຫຼດອົງປະກອບໄດ້';
$string['cannotdownloadlanguageupdatelist'] = 'ບໍ່ສາມາດດາວໂຫຼດລາຍຊື່ການປັບປຸງພາສາຈາກ download.moodle.org';
$string['cannotdownloadzipfile'] = 'ບໍ່ສາມາດດາວໂຫຼດໄຟລ໌ ZIP ໄດ້';
$string['cannoteditcomment'] = 'ຄຳເຫັນນີ້ບໍ່ແມ່ນຂອງທ່ານທີ່ຈະແກ້ໄຂ!';
$string['cannoteditcommentexpired'] = 'ທ່ານບໍ່ສາມາດແກ້ໄຂສິ່ງນີ້ໄດ້. ເວລາໝົດແລ້ວ!';
$string['cannoteditpostorblog'] = 'ທ່ານບໍ່ສາມາດໂພສ ຫຼື ແກ້ໄຂບລັອກໄດ້';
$string['cannoteditsiteform'] = 'ທ່ານບໍ່ສາມາດແກ້ໄຂຫຼັກສູດເວັບໄຊທ໌ໂດຍໃຊ້ແບບຟອມນີ້';
$string['cannotedituserpreferences'] = 'ບໍ່ສາມາດແກ້ໄຂຄວາມມັກຂອງຜູ້ໃຊ້ນີ້ໄດ້';
$string['cannotedityourprofile'] = 'ຂໍອະໄພ, ທ່ານບໍ່ສາມາດແກ້ໄຂໂປຼໄຟລ໌ຂອງຕົນເອງໄດ້';
$string['cannotexecduringupgrade'] = 'ບໍ່ສາມາດດຳເນີນການໄດ້ໃນລະຫວ່າງການປັບປຸງ';
$string['cannotfindcategory'] = 'ບໍ່ສາມາດຊອກຫາບັນທຶກປະເພດຈາກຖານຂໍ້ມູນດ້ວຍລະຫັດປະຈຳຕົວ - {$a}';
$string['cannotfindcomponent'] = 'ບໍ່ພົບອົງປະກອບ';
$string['cannotfindcontext'] = 'ບໍ່ສາມາດຊອກຫາບໍລິບົດໄດ້';
$string['cannotfindcourse'] = 'ບໍ່ສາມາດຊອກຫາລາຍວິຊາໄດ້';
$string['cannotfinddocs'] = 'ບໍ່ສາມາດຊອກຫາໄຟລ໌ເອກະສານພາສາ "{$a}" ໄດ້';
$string['cannotfindgradeitem'] = 'ບໍ່ສາມາດຊອກຫາ grade_item';
$string['cannotfindgroup'] = 'ບໍ່ສາມາດຊອກຫາກຸ່ມ';
$string['cannotfindhelp'] = 'ບໍ່ສາມາດຊອກຫາໄຟລ໌ຊ່ວຍເຫຼືອພາສາ "{$a}" ໄດ້';
$string['cannotfindinfo'] = 'ບໍ່ສາມາດຊອກຫາຂໍ້ມູນຂອງ: "{$a}"';
$string['cannotfindlang'] = 'ບໍ່ສາມາດຊອກຫາຊຸດພາສາ "{$a}" ໄດ້!';
$string['cannotfindteacher'] = 'ບໍ່ພົບຄູສອນ';
$string['cannotfinduser'] = 'ບໍ່ສາມາດຊອກຫາຜູ້ໃຊ້ຊື່ "{$a}" ໄດ້';
$string['cannotgeoplugin'] = 'ບໍ່ສາມາດເຊື່ອມຕໍ່ຫາເຊີບເວີ geoPlugin ໄດ້ທີ່ https://www.geoplugin.com. ກະລຸນາກວດເບິ່ງການຕັ້ງຄ່າຕົວແທນຂອງທ່ານ ຫຼື ຕິດຕັ້ງໄຟລ໌ຂໍ້ມູນ MaxMind GeoLite City.';
$string['cannotgetblock'] = 'ບໍ່ສາມາດດຶງຂໍ້ມູນບລັອກຈາກຖານຂໍ້ມູນໄດ້';
$string['cannotgetcats'] = 'ບໍ່ສາມາດເອົາບັນທຶກປະເພດໄດ້';
$string['cannotgetdata'] = 'ບໍ່ສາມາດເອົາຂໍ້ມູນໄດ້';
$string['cannotgradeuser'] = 'ບໍ່ສາມາດໃຫ້ຄະແນນຜູ້ໃຊ້ນີ້ໄດ້';
$string['cannothaveparentcate'] = 'ປະເພດວິຊາບໍ່ສາມາດມີພໍ່ແມ່ໄດ້!';
$string['cannotimport'] = 'ການນຳເຂົ້າຜິດພາດ';
$string['cannotimportformat'] = 'ຂໍອະໄພ, ການນຳເຂົ້າຮູບແບບນີ້ຍັງບໍ່ທັນຖືກຈັດຕັ້ງປະຕິບັດ!';
$string['cannotimportgrade'] = 'ການນຳເຂົ້າຄະແນນຜິດພາດ';
$string['cannotinsertgrade'] = 'ບໍ່ສາມາດໃສ່ລາຍການຄະແນນໂດຍບໍ່ລະຫັດປະຈຳຕົວລາຍວິຊາໄດ້!';
$string['cannotinsertrate'] = 'ບໍ່ສາມາດໃສ່ການຈັດອັນດັບໃໝ່ໄດ້ ({$a->id} = {$a->rating})';
$string['cannotinsertrecord'] = 'ບໍ່ສາມາດໃສ່ບັນທຶກລະຫັດປະຈຳຕົວໃໝ່ {$a} ໄດ້';
$string['cannotmailconfirm'] = 'ເກີດຄວາມຜິດພາດໃນການສົ່ງອີເມລຢືນຢັນການປ່ຽນລະຫັດຜ່ານ';
$string['cannotmanualctrack'] = 'ກິດຈະກໍາບໍ່ໄດ້ໃຫ້ການຕິດຕາມການສໍາເລັດດ້ວຍຕົນເອງ';
$string['cannotmapfield'] = 'ກວດພົບການຕຳກັນທາງແຜນທີ່ - ແຜນທີ່ສອງຊ່ອງໃສ່ກັບລາຍການຄະແນນດຽວກັນ {$a}';
$string['cannotmarktopic'] = 'ບໍ່ສາມາດໝາຍຫົວຂໍ້ນັ້ນໃສ່ຫຼັກສູດນີ້ໄດ້';
$string['cannotmigratedatacomments'] = 'ບໍ່ສາມາດຍ້າຍຄຳເຫັນຊຸດຂໍ້ມູນໄດ້';
$string['cannotmodulename'] = 'ບໍ່ສາມາດເອົາຊື່ຊຸດໃນການສ້າງຕົວນໍາທາງ';
$string['cannotmoduletype'] = 'ບໍ່ສາມາດເອົາປະເພດຊຸດໃນການສ້າງການນໍາທາງ';
$string['cannotmovecategory'] = 'ບໍ່ສາມາດຍ້າຍປະເພດໄດ້';
$string['cannotmovecourses'] = 'ບໍ່ສາມາດຍ້າຍຫຼັກສູດຈາກປະເພດທີ່ເຂົາທ່ານຢູ່ໄປຫາບ່ອນອື່ນໄດ້.';
$string['cannotmoverolewithid'] = 'ບໍ່ສາມາດຍ້າຍຕຳແໜ່ງດ້ວຍ ID {$a}';
$string['cannotopencsv'] = 'ບໍ່ສາມາດເປີດໄຟລ໌ CSV ໄດ້';
$string['cannotopenfile'] = 'ບໍ່ສາມາດເປີດໄຟລ໌ ({$a}) ໄດ້';
$string['cannotopenforwrit'] = 'ບໍ່ສາມາດເປີດເພື່ອຂຽນໄດ້: {$ a}';
$string['cannotopentemplate'] = 'ບໍ່ສາມາດເປີດໄຟລ໌ແມ່ແບບ ({$ a}) ໄດ້';
$string['cannotopenzip'] = 'ບໍ່ສາມາດເປີດໄຟລ໌ zip ໄດ້, ອາດຈະເປັນເພາະວ່າມີ zip ສ່ວນຂະຫຍາຍບັກຢູ່ໃນລະບົບປະຕິບັດການ 64-bit.';
$string['cannotoverridebaserole'] = 'ບໍ່ສາມາດລົບລ້າງຄວາມສາມາດພື້ນຖານໄດ້';
$string['cannotoverriderolehere'] = 'ທ່ານຍັງບໍ່ໄດ້ຮັບອະນຸຍາດໃຫ້ລົບລ້າງໜ້າທີ່ນີ້ (id = {$a->roleid}) ໃນບໍລິບົດນີ້ ({$a->context})';
$string['cannotreadfile'] = 'ບໍ່ສາມາດອ່ານໄຟລ໌ ({$a})';
$string['cannotreadtmpfile'] = 'ເກີດຄວາມຜິດພາດໃນການອ່ານໄຟລ໌ຊົ່ວຄາວ';
$string['cannotreaduploadfile'] = 'ບໍ່ສາມາດອ່ານໄຟລ໌ທີ່ອັບໂຫຼດແລ້ວ';
$string['cannotremovefrommeta'] = 'ບໍ່ສາມາດລຶບລາຍວິຊາທີ່ເລືອກອອກຈາກລາຍວິຊາເມຕ້ານີ້ໄດ້!';
$string['cannotreprocessgrades'] = 'ບໍ່ສາມາດປະມວນຜົນຄະແນນຄືນໃໝ່ສໍາລັບກິດຈະກໍານີ້ {$a}';
$string['cannotresetguestpwd'] = 'ທ່ານບໍ່ສາມາດຕັ້ງລະຫັດຜ່ານຂອງແຂກຄືນໃໝ່ໄດ້';
$string['cannotresetmail'] = 'ເກີດຄວາມຜິດພາດໃນການຕັ້ງລະຫັດຜ່ານຄືນໃໝ່ ແລະ ສົ່ງຈົດໝາຍຫາທ່ານ';
$string['cannotresetthisrole'] = 'ບໍ່ສາມາດຕັ້ງໜ້າທີ່ນີ້ຄືນໃໝ່ໄດ້';
$string['cannotrestore'] = 'ເກີດຄວາມຜິດພາດຂຶ້ນ ແລະ ການກູ້ຄືນບໍ່ສາມາດສໍາເລັດໄດ້!';
$string['cannotrestoreadminorcreator'] = 'ເຈົ້າຕ້ອງເປັນຜູ້ສ້າງ ຫຼື ຜູ້ໃຊ້ບໍລິຫານ ເພື່ອຟື້ນຟູເຂົ້າສູ່ລາຍວິຊາໃໝ່!';
$string['cannotrestoreadminoredit'] = 'ທ່ານຕ້ອງເປັນຄູສອນການແກ້ໄຂ ຫຼື ຜູ້ໃຊ້ບໍລິຫານ ເພື່ອຟື້ນຟູເຂົ້າສູ່ລາຍວິຊາທີ່ເລືອກ!';
$string['cannotsaveagreement'] = 'ບໍ່ສາມາດບັນທຶກຂໍ້ຕົກລົງຂອງທ່ານໄດ້';
$string['cannotsaveblock'] = 'ເກີດຄວາມຜິດພາດໃນການບັນທຶກການຕັ້ງຄ່າບລັອກ';
$string['cannotsavecomment'] = 'ບໍ່ສາມາດບັນທຶກຄຳເຫັນໄດ້';
$string['cannotsavedata'] = 'ບໍ່ສາມາດບັນທຶກຂໍ້ມູນໄດ້';
$string['cannotsavefile'] = 'ບໍ່ສາມາດບັນທຶກໄຟລ໌ "{$a}" ໄດ້!';
$string['cannotsavemd5file'] = 'ບໍ່ສາມາດບັນທຶກໄຟລ໌ md5 ໄດ້';
$string['cannotsavezipfile'] = 'ບໍ່ສາມາດບັນທຶກໄຟລ໌ ZIP ໄດ້';
$string['cannotservefile'] = 'ບໍ່ສາມາດຮັບໃຊ້ໄຟລ໌ໄດ້ເນື່ອງຈາກບັນຫາການຕັ້ງຄ່າເຊີບເວີ.';
$string['cannotsetparentforcatoritem'] = 'ບໍ່ສາມາດຕັ້ງຄ່າຫຼັກໃຫ້ເປັນປະເພດ ຫຼື ລາຍການວິຊາໄດ້!';
$string['cannotsetpassword'] = 'ບໍ່ສາມາດຕັ້ງລະຫັດຜ່ານຜູ້ໃຊ້ໄດ້!';
$string['cannotsetprefgrade'] = 'ບໍ່ສາມາດຕັ້ງຄ່າການລວມການສະແດງຄວາມຕ້ອງການເປັນ {$a} ສໍາລັບປະເພດຄະແນນນີ້ໄດ້';
$string['cannotsettheme'] = 'ບໍ່ສາມາດຕັ້ງຊຸດຮູບແບບໄດ້!';
$string['cannotsetupblock'] = 'ບໍ່ສາມາດຕັ້ງຕາຕະລາງບລັອກສຳເລັດໄດ້!';
$string['cannotsetupcapformod'] = 'ບໍ່ສາມາດຕັ້ງຄ່າຄວາມສາມາດສໍາລັບ {$a} ໄດ້';
$string['cannotsetupcapforplugin'] = 'ບໍ່ສາມາດຕັ້ງຄ່າຄວາມສາມາດສໍາລັບ {$a} ໄດ້';
$string['cannotshowhidecoursesincategory'] = 'ບໍ່ສາມາດສະແດງ/ເຊື່ອງວິຊາໃນປະເພດ {$a} ໄດ້.';
$string['cannotsignup'] = 'ທ່ານບໍ່ສາມາດສ້າງບັນຊີໃໝ່ໄດ້ ເພາະວ່າທ່ານໄດ້ເຂົ້າສູ່ລະບົບເປັນ {$a} ຢູ່ແລ້ວ.';
$string['cannotswitcheditmodeon'] = 'ບໍ່ສາມາດສະຫຼັບເປີດໂໝດແກ້ໄຂໄດ້';
$string['cannotunassigncap'] = 'ບໍ່ສາມາດຍົກເລີກການມອບໝາຍຄວາມສາມາດທີ່ບໍ່ຍອມຮັບໄດ້ {$a->cap} ຈາກໜ້າທີ່ {$a->role}';
$string['cannotunassignrolefrom'] = 'ບໍ່ສາມາດມອບໝາຍຜູ້ໃຊ້ນີ້ຈາກໜ້າທີ່ຂອງ: {$a}';
$string['cannotunzipfile'] = 'ບໍ່ສາມາດແຍກໄຟລ໌';
$string['cannotupdatemod'] = 'ບໍ່ສາມາດປັບປຸງ {$a}';
$string['cannotupdatepasswordonextauth'] = 'ປັບປຸງລະຫັດຜ່ານຢູ່ໃນການຮັບຮອງພາຍນອກບໍ່ສຳເລັດ: {$a}. ເບິ່ງບັນທຶກຂອງເຊີບເວີສໍາລັບລາຍລະອຽດເພີ່ມເຕີມ.';
$string['cannotupdateprofile'] = 'ເກີດຄວາມຜິດພາດໃນການປັບປຸງບັນທຶກຜູ້ໃຊ້';
$string['cannotupdaterecord'] = 'ບໍ່ສາມາດປັບປຸງລະຫັດປະຈຳຕົວການບັນທຶກ {$a} ໄດ້';
$string['cannotupdaterss'] = 'ບໍ່ສາມາດປັບປຸງ RSS ໄດ້';
$string['cannotupdatesubcourse'] = 'ບໍ່ສາມາດປັບປຸງລາຍວິຊາເດັກນ້ອຍໄດ້!';
$string['cannotupdateusermsgpref'] = 'ບໍ່ສາມາດປັບປຸງການຕັ້ງຄ່າຂໍ້ຄວາມຜູ້ໃຊ້ໄດ້';
$string['cannotupdateuseronexauth'] = 'ປັບປຸງຂໍ້ມູນຜູ້ໃຊ້ຢູ່ໃນການຮັບຮອງພາຍນອກບໍ່ສຳເລັດ: {$a}. ເບິ່ງບັນທຶກຂອງເຊີບເວີສໍາລັບລາຍລະອຽດເພີ່ມເຕີມ.';
$string['cannotuploadfile'] = 'ເກີດຄວາມຜິດພາດໃນການປະມວນໄຟລ໌ອັບໂຫຼດ';
$string['cannotuseadmin'] = 'ທ່ານຕ້ອງເປັນຜູ້ໃຊ້ບໍລິຫານ ເພື່ອໃຊ້ ໜ້ານີ້';
$string['cannotuseadminadminorteacher'] = 'ທ່ານຕ້ອງເປັນຄູສອນ ຫຼື ຜູ້ໃຊ້ບໍລິຫານ ເພື່ອໃຊ້ໜ້ານີ້';
$string['cannotusepage'] = 'ມີພຽງຄູສອນ ແລະ ຜູ້ບໍລິຫານເທົ່ານັ້ນສາມາດໃຊ້ໜ້ານີ້ໄດ້';
$string['cannotusepage2'] = 'ຂໍອະໄພ, ທ່ານອາດຈະບໍ່ໃຊ້ໜ້ານີ້';
$string['cannotviewcategory'] = 'ເຈົ້າບໍ່ມີສິດອະນຸຍາດເບິ່ງລາຍຊື່ວິຊານີ້.';
$string['cannotviewprofile'] = 'ທ່ານບໍ່ສາມາດເບິ່ງໂປຼໄຟລ໌ຂອງຜູ້ໃຊ້ນີ້ໄດ້';
$string['cannotviewreport'] = 'ທ່ານບໍ່ສາມາດເບິ່ງລາຍງານນີ້ໄດ້';
$string['cannotwritefile'] = 'ບໍ່ສາມາດຂຽນໃສ່ໄຟລ໌ ({$a})';
$string['categoryerror'] = 'ປະເພດຜິດພາດ';
$string['categoryidnumbertaken'] = 'ໝາຍເລກລະຫັດປະຈຳຕົວຖືກໃຊ້ສຳລັບປະເພດອື່ນຢູ່ກ່ອນແລ້ວ';
$string['categorynamerequired'] = 'ຕ້ອງລະບຸຊື່ປະເພດ';
$string['categorytoolong'] = 'ຊື່ປະເພດຍາວເກີນໄປ';
$string['commentmisconf'] = 'ລະຫັດປະຈຳຕົວຄຳເຫັນຖືກກຳນົດຄ່າຜິດ';
$string['componentisuptodate'] = 'ອົງປະກອບໃໝ່ຫຼ້າສຸດແລ້ວ';
$string['confirmationnotenabled'] = 'ການຢືນຢັນຜູ້ໃຊ້ບໍ່ໄດ້ຖືກເປີດນຳໃຊ້ຢູ່ໃນເວັບໄຊທ໌ນີ້';
$string['confirmsesskeybad'] = 'ຂໍອະໄພ, ແຕ່ກະແຈຊ່ວງເວລາຂອງທ່ານບໍ່ສາມາດຢືນຢັນໄດ້ ເພື່ອດໍາເນີນການການປະຕິບັດນີ້. ຄຸນສົມບັດຄວາມປອດໄພນີ້ປ້ອງກັນການປະຕິບັດໜ້າທີ່ສໍາຄັນທີ່ບັງເອີນ ຫຼື ເປັນອັນຕະລາຍໃນຊື່ຂອງທ່ານ. ກະລຸນາກວດໃຫ້ແນ່ໃຈວ່າທ່ານຕ້ອງການປະຕິບັດໜ້າທີ່ນີ້ແທ້ຫຼືບໍ່.';
$string['contenttypenotfound'] = 'ປະເພດທະນາຄານເນື້ອຫາ \'{$a}\' ບໍ່ມີຢູ່ ຫຼື ບໍ່ຖືກຮັບຮູ້.';
$string['contentvisibilitynotfound'] = 'ການເບິ່ງເຫັນເນື້ອໃນທີ່ມີຄ່າ \'{$a}\' ບໍ່ມີຢູ່ ຫຼື ບໍ່ຖືກຮັບຮູ້.';
$string['couldnotassignrole'] = 'ຂໍ້ຜິດພາດຮ້າຍແຮງແຕ່ບໍ່ໄດ້ລະບຸໄດ້ເກີດຂຶ້ນໃນຂະນະທີ່ພະຍາຍາມມອບໝາຍໜ້າທີ່ໃຫ້ກັບທ່ານ';
$string['couldnotupdatenoexistinguser'] = 'ບໍ່ສາມາດອັບເດດຜູ້ໃຊ້ໄດ້ - ບໍ່ມີຜູ້ໃຊ້ຢູ່';
$string['couldnotverifyagedigitalconsent'] = 'ເກີດຄວາມຜິດພາດຂຶ້ນໃນຂະນະທີ່ພະຍາຍາມກວດສອບອາຍຸຂອງການຍິນຍອມເຫັນດີທາງດ້ານດິຈິຕອລ.<br />ກະລຸນາຕິດຕໍ່ຜູ້ເບິ່ງແຍງລະບົບ.';
$string['countriesphpempty'] = 'ຜິດພາດ: ໄຟລ໌ countries.php ໃນຊຸດພາສາ {$a} ແມ່ນຫວ່າງເປົ່າ ຫຼື ຂາດຫາຍໄປ.';
$string['coursedoesnotbelongtocategory'] = 'ລາຍວິຊາບໍ່ໄດ້ຢູ່ໃນປະເພດນີ້';
$string['courseformatnotfound'] = 'ຮູບແບບລາຍວິຊາ \'{$a}\' ບໍ່ມີຢູ່ ຫຼື ບໍ່ຖືກຮັບຮູ້.';
$string['coursegroupunknown'] = 'ລາຍວິຊາທີ່ກົງກັບກຸ່ມ {$a} ບໍ່ໄດ້ລະບຸ';
$string['courseidnotfound'] = 'ລະຫັດປະຈຳຕົວລາຍວິຊາບໍ່ມີຢູ່.';
$string['courseidnumbertaken'] = 'ໝາຍເລກລະຫັດປະຈຳຕົວໄດ້ຖືກໃຊ້ສຳ ລັບລາຍວິຊາອື່ນຢູ່ກ່ອນແລ້ວ ({$a})';
$string['coursemisconf'] = 'ລາຍວິຊາມີການຕັ້ງຄ່າຜິດ';
$string['courserequestdisabled'] = 'ຂໍອະໄພ, ແຕ່ການຮ້ອງຂໍລາຍວິຊາໄດ້ຖືກປິດການນຳໃຊ້ໂດຍຜູ້ເບິ່ງແຍງລະບົບ.';
$string['csvcolumnduplicates'] = 'ກວດພົບຖັນທີ່ຊ້ຳກັນ';
$string['csvemptyfile'] = 'ໄຟລ໌ CSV ຫວ່າງເປົ່າ';
$string['csvfewcolumns'] = 'ຖັນບໍ່ພຽງພໍ, ກະລຸນາກວດສອບການຕັ້ງຄ່າຕົວຂັ້ນ';
$string['csvfileerror'] = 'ມີບາງຢ່າງຜິດພາດກັບຮູບແບບຂອງໄຟລ໌ CSV. ກະລຸນາກວດເບິ່ງຈໍານວນຫົວຂໍ້ ແລະ ຖັນທີ່ກົງກັນ, ແລະ ຕົວຂັ້ນ ແລະ ການເຂົ້າລະຫັດໄຟລ໌ແມ່ນຖືກຕ້ອງ. {$a}';
$string['csvinvalidcols'] = '<b>ໄຟລ໌ CSV ບໍ່ຖືກຕ້ອງ:</b> ແຖວທໍາອິດຕ້ອງປະກອບມີ "ຊ່ອງຂໍ້ມູນສ່ວນຫົວ" ແລະ ໄຟລ໌ຕ້ອງເປັນປະເພດຂອງ <br /> "ຊ່ອງຂໍ້ມູນທີ່ຂະຫຍາຍ/ແຍກໝາຍຈຸດ"<br />ຫຼື<br />"ຊ່ອງຂໍ້ມູນຂະຫຍາຍທີ່ມີລະຫັດຜົນລັບ CAVV/ແຍກໝາຍຈຸດ"';
$string['csvinvalidcolsnum'] = 'ໄຟລ໌ CSV ບໍ່ຖືກຕ້ອງ - ແຕ່ລະແຖວຕ້ອງປະກອບມີ 49 ຫຼື 70 ຊ່ອງຂໍ້ມູນ';
$string['csvloaderror'] = 'ເກີດຄວາມຜິດພາດຂຶ້ນໃນຂະນະທີ່ໂຫຼດໄຟລ໌ CSV: {$a}';
$string['csvnodata'] = 'ໄຟລ໌ CSV ບໍ່ຖືກຕ້ອງ - ໄຟລ໌ CSV ມີສ່ວນຫົວແຕ່ບໍ່ມີຂໍ້ມູນໃດ.';
$string['csvweirdcolumns'] = 'ຮູບແບບໄຟລ໌ CSV ບໍ່ຖືກຕ້ອງ - ຈໍານວນຖັນບໍ່ຄົງທີ່!';
$string['dbconnectionfailed'] = '<p>ຜິດພາດ: ການເຊື່ອມຕໍ່ຖານຂໍ້ມູນບໍ່ສໍາເລັດ</p>
<p>ມັນເປັນໄປໄດ້ວ່າຖານຂໍ້ມູນເຮັດວຽກ ໜັກເກີນໄປ ຫຼື ເຮັດວຽກບໍ່ເໝາະສົມ. </p>
<p>ຜູ້ຄວບຄຸມເວັບໄຊທ໌ ຄວນກວດເບິ່ງວ່າລາຍລະອຽດຂອງຖານຂໍ້ມູນໄດ້ລະບຸໄວ້ຢ່າງຖືກຕ້ອງຢູ່ໃນ config.php</p>';
$string['dbdriverproblem'] = '<p>ຜິດພາດ: ກວດພົບບັນຫາໄດຣເວີຖານຂໍ້ມູນ</p>
<p>ຜູ້ຄວບຄຸມເວັບໄຊທ໌ ຄວນກວດສອບການຕັ້ງຄ່າເຊີບເວີ</p><p>{$a}</p>';
$string['dbsessionbroken'] = 'ກວດພົບບັນຫາຊ່ວງເວລາຖານຂໍ້ມູນຮ້າຍແຮງ.<br /><br />ກະລຸນາແຈ້ງຜູ້ເບິ່ງແຍງລະບົບເຊີບເວີ.';
$string['dbsessionhandlerproblem'] = 'ຕັ້ງຄ່າຊ່ວງເວລາຖານຂໍ້ມູນບໍ່ສຳເລັດ. ກະລຸນາແຈ້ງຜູ້ເບິ່ງແຍງລະບົບເຊີບເວີ.';
$string['dbsessionmysqlpacketsize'] = 'ກວດພົບຂໍ້ຜິດພາດຊ່ວງເວລາເຂົ້າໃຊ້ທີ່ຮ້າຍແຮງ. ກະລຸນາແຈ້ງຜູ້ບໍລິຫານເວັບໄຊທ໌. ບັນຫາສ່ວນຫຼາຍອາດຈະເກີດຈາກຄ່ານ້ອຍໃນການຕັ້ງຄ່າ MySQL max_allowed_packet.';
$string['dbupdatefailed'] = 'ປັບປຸງຖານຂໍ້ມູນບໍ່ສຳເລັດ';
$string['ddldependencyerror'] = '{$a->targettype}} "{$a->targetname}" ບໍ່ສາມາດແກ້ໄຂໄດ້. ພົບການເພິ່ງພາອາໄສດ້ວຍ {$a->offendingtype} "{$a->offendingname}"';
$string['ddlexecuteerror'] = 'ການປະຕິບັດ DDL sql ຜິດພາດ';
$string['ddlfieldalreadyexists'] = 'ມີຊ່ອງຂໍ້ມູນ "{$a}" ຢູ່ແລ້ວ';
$string['ddlfieldnotexist'] = 'ຊ່ອງຂໍ້ມູນ "{$a->fieldname}" ບໍ່ມີຢູ່ໃນຕາຕາລາງ "{$a->tablename}"';
$string['ddltablealreadyexists'] = 'ມີຕາຕາລາງ "{$a}" ຢູ່ແລ້ວ';
$string['ddltablenotexist'] = 'ບໍ່ມີຕາຕາລາງ "{$a}"';
$string['ddlunknownerror'] = 'ຄວາມຜິດພາດຫ້ອງສະໝຸດ DDL ທີ່ບໍ່ຮູ້ຈັກ';
$string['ddlxmlfileerror'] = 'ພົບໄຟລ໌ຖານຂໍ້ມູນ XML ຜິດພາດ';
$string['ddsequenceerror'] = 'ຄຳນິຍາມຕາຕະລາງ "{$a}" ບໍ່ຖືກຕ້ອງ; ມັນສາມາດມີຖັນອັດຕະໂນມັດພຽງອັນດຽວ ແລະ ມັນຕ້ອງຖືກກໍານົດເປັນກະແຈ.';
$string['destinationcmnotexit'] = 'ຊຸດຫຼັກສູດປາຍທາງບໍ່ມີຢູ່';
$string['detectedbrokenplugin'] = 'ປລັກອິນ {$a} ມີຂໍ້ບົກພ່ອງ ຫຼື ລ້າສະໄໝ; ຂໍອະໄພ ທ່ານບໍ່ສາມາດສືບຕໍ່ໄດ້.';
$string['dmlexceptiononinstall'] = '<p>ເກີດຄວາມຜິດພາດທາງຖານຂໍ້ມູນ [{$a->errorcode}].<br />{$a->debuginfo}</p>';
$string['dmlparseexception'] = 'ເກີດຄວາມຜິດພາດໃນແຍກວິເຄາະແບບສອບຖາມ SQL';
$string['dmlreadexception'] = 'ເກີດຄວາມຜິດພາດໃນການອ່ານຈາກຖານຂໍ້ມູນ';
$string['dmltransactionexception'] = 'ທຸລະກຳຖານຂໍ້ມູນຜິດພາດ';
$string['dmlwriteexception'] = 'ເກີດຄວາມຜິດພາດໃນການຂຽນຖານຂໍ້ມູນ';
$string['downgradedcore'] = 'ຜິດພາດ!!! ລະຫັດທີ່ທ່ານໃຊ້ແມ່ນເກົ່າກວ່າສະບັບທີ່ສ້າງຖານຂໍ້ມູນເຫຼົ່ານີ້!';
$string['downloadedfilecheckfailed'] = 'ດາວໂຫຼດໄຟລ໌ກວດສອບບໍ່ສຳເລັດ';
$string['duplicatefieldname'] = 'ກວດພົບຊື່ຊ່ອງຂໍ້ມູນຊ້ຳກັນ "{$a}"';
$string['duplicatenosupport'] = 'ກິດຈະກໍາ \'{$a->modname}\' ບໍ່ສາມາດຊໍ້າກັນໄດ້ເພາະວ່າຊຸດ {$a->modtype} ບໍ່ສະໜັບສະໜູນການສໍາຮອງ ແລະ ການກູ້ຄືນ.';
$string['duplicateparaminsql'] = 'ຜິດພາດ: ຊື່ຕົວກຳນັດຊໍ້າກັນໃນແບບສອບຖາມ';
$string['duplicaterolename'] = 'ມີໜ້າທີ່ກັບຊື່ນີ້ຢູ່ແລ້ວ!';
$string['duplicateroleshortname'] = 'ມີໜ້າທີ່ມີຊື່ສັ້ນນີ້ຢູ່ແລ້ວ!';
$string['duplicateusername'] = 'ຊື່ຜູ້ໃຊ້ຊໍ້າກັນ - ຂ້າມການບັນທຶກ';
$string['emailfail'] = 'ສົ່ງອີເມວບໍ່ສຳເລັດ';
$string['encryption_decryptfailed'] = 'ການຖອດລະຫັດບໍ່ສຳເລັດ';
$string['encryption_encryptfailed'] = 'ການເຂົ້າລະຫັດລົ້ມເຫຼວ';
$string['encryption_invalidkey'] = 'ລະຫັດບໍ່ຖືກຕ້ອງ';
$string['encryption_keyalreadyexists'] = 'ມີລະຫັດຢູ່ແລ້ວ';
$string['encryption_nokey'] = 'ບໍ່ພົບລະຫັດ';
$string['encryption_wrongmethod'] = 'ຂໍ້ມູນບໍ່ກົງກັບວິທີການເຂົ້າລະຫັດທີ່ຮອງຮັບ';
$string['enddatebeforestartdate'] = 'ວັນທີຈົບລາຍວິຊາຈະຕ້ອງແມ່ນຫຼັງຈາກວັນທີເລີ່ມຕົ້ນ.';
$string['error'] = 'ເກີດຄວາມຜິດພາດຂຶ້ນ';
$string['error_question_answers_missing_in_db'] = 'ຊອກຫາຄໍາຕອບທີ່ກົງກັບ "{$a->answer}" ຢູ່ໃນຕາຕະລາງຖານຂໍ້ມູນ question_answers ບໍ່ສໍາເລັດ. ສິ່ງນີ້ເກີດຂຶ້ນໃນຂະນະທີ່ກູ້ຄືນຄໍາຖາມທີ່ມີລະຫັດປະຈຳຕົວ {$a->filequestionid} ຢູ່ໃນໄຟລ໌ສຳຮອງ, ເຊິ່ງໄດ້ເຂົ້າກັນກັບຄໍາຖາມທີ່ມີຢູ່ແລ້ວກັບລະຫັດປະຈຳຕົວ {$a->dbquestionid} ຢູ່ໃນຖານຂໍ້ມູນ.';
$string['errorcleaningdirectory'] = 'ເກີດຄວາມຜິດພາດໃນການລຶບລາຍຊື່ "{$a}"';
$string['errorcopyingfiles'] = 'ເກີດຄວາມຜິດພາດໃນການສຳເນົາໄຟລ໌';
$string['errorcreatingdirectory'] = 'ເກີດຄວາມຜິດພາດໃນການສ້າງບັນຊີລາຍການ "{$a}"';
$string['errorcreatingfile'] = 'ເກີດຄວາມຜິດພາດໃນການສ້າງໄຟລ໌ "{$a}"';
$string['errorcreatingrole'] = 'ເກີດຄວາມຜິດພາດໃນການສ້າງໜ້າທີ່';
$string['errorfetchingrssfeed'] = 'ເກີດຄວາມຜິດພາດໃນການໂຫຼດຟີດ RSS.';
$string['erroronline'] = 'ເກີດຄວາມຜິດພາດຢູ່ແຖວທີ {$a}';
$string['erroroutput'] = 'ຜົນໄດ້ຮັບຜິດພາດ, ສະນັ້ນປິດການນຳໃຊ້ການປ່ຽນເສັ້ນທາງອັດຕະໂນມັດ.';
$string['errorparsingxml'] = 'ເກີດຄວາມຜິດພາດໃນການແຍກວິເຄາະ XML: {$a->errorstring} ຢູ່ແຖວ {$a->errorline}, char {$a->errorchar}';
$string['errorprocessingarchive'] = 'ເກີດຄວາມຜິດພາດໃນການປະມວນຜົນໄຟລ໌ຈັດເກັບ';
$string['errorreadingfile'] = 'ເກີດຄວາມຜິດພາດໃນການອ່ານໄຟລ໌ "{$a}"';
$string['errorsavingrequest'] = 'ເກີດຄວາມຜິດພາດຂຶ້ນໃນເວລາພະຍາຍາມບັນທຶກຄຳຮ້ອງຂໍຂອງທ່ານ.';
$string['errorsettinguserpref'] = 'ເກີດຄວາມຜິດພາດໃນການຕັ້ງຄ່າຜູ້ໃຊ້';
$string['errorunzippingfiles'] = 'ເກີດຄວາມຜິດພາດໃນການແຍກໄຟລ໌';
$string['expiredkey'] = 'ລະຫັດໝົດອາຍຸແລ້ວ';
$string['externalauthpassworderror'] = 'ລະຫັດຜ່ານບໍ່ຫວ່າງເປົ່າສໍາລັບການກວດສອບຄວາມຖືກຕ້ອງພາຍນອກ';
$string['externalfilenolocation'] = 'ໄຟລ໌ພາຍນອກບໍ່ມີເສັ້ນທາງສະຖານທີ່';
$string['failtoloadblocks'] = 'ໜຶ່ງ ຫຼື ຫຼາຍບລັອກຖືກລົງທະບຽນຢູ່ໃນຖານຂໍ້ມູນ, ແຕ່ພວກມັນທັງໝົດບໍ່ສາມາດໂຫຼດໄດ້!';
$string['fieldrequired'] = '"{$a}" ແມ່ນຊ່ອງຂໍ້ມູນທີ່ຈໍາເປັນ';
$string['fileexists'] = 'ມີໄຟລ໌ຢູ່';
$string['filemismatch'] = 'ຊື່ໄຟລ໌ທີ່ບໍ່ແມ່ນຫຼັກບໍ່ກົງກັນ. ໄຟລ໌ "{$a->current}" ຄວນຈະເປັນ {$a->file}';
$string['filenotfound'] = 'ຂໍອະໄພ, ບໍ່ພົບໄຟລ໌ທີ່ຮ້ອງຂໍ';
$string['filenotreadable'] = 'ໄຟລ໌ບໍ່ສາມາດອ່ານໄດ້';
$string['filterdoesnothavelocalconfig'] = 'ຕົວກັ່ນຕອງ {$a} ບໍ່ອະນຸຍາດການຕັ້ງຄ່າໃນເຄື່ອງ.';
$string['filternotactive'] = 'ຕອນນີ້ຕົວກັ່ນຕອງ {$a} ບໍ່ໄດ້ນຳໃຊ້';
$string['filternotenabled'] = 'ບໍ່ໄດ້ເປີດໃຊ້ງານຕົວກັ່ນຕອງ!';
$string['filternotinstalled'] = 'ຕອນນີ້ຍັງບໍ່ໄດ້ຕິດຕັ້ງຕົວກັ່ນຕອງ {$a} ເທື່ອ';
$string['forumblockingtoomanyposts'] = 'ທ່ານໄດ້ເກີນຂອບເຂດທີ່ກໍານົດໄວ້ໃນການໂພສສໍາລັບເວທີສົນທະນານີ້';
$string['functionalityremoved'] = 'ທ່ານກໍາລັງພະຍາຍາມເຂົ້າຫາການທຳງານທີ່ຖືກເອົາອອກໄປແລ້ວ.';
$string['generalexceptionmessage'] = 'ຂໍ້ຍົກເວັ້ນ - {$a}';
$string['gradecantregrade'] = 'ເກີດຄວາມຜິດພາດຂຶ້ນໃນລະຫວ່າງການຄິດໄລ່ຄະແນນ: {$a}';
$string['gradepubdisable'] = 'ປິດການນຳໃຊ້ການເຜີຍແຜ່ຄະແນນແລ້ວ';
$string['gradesneedregrading'] = 'ຄະແນນລາຍວິຊາຕ້ອງໄດ້ຄິດໄລ່ຄືນໃໝ່';
$string['groupalready'] = 'ຜູ້ໃຊ້ເປັນຂອງກຸ່ມ {$a} ຢູ່ແລ້ວ';
$string['groupexistforcourse'] = 'ກຸ່ມ "{$a}" ມີຢູ່ແລ້ວສຳລັບລາຍວິຊານີ້';
$string['groupexistforcoursewithidnumber'] = '{$a->problemgroup}: ກຸ່ມ "{$a->name}" ທີ່ມີຈໍານວນ "{$a->idnumber}" ມີຢູ່ແລ້ວສໍາລັບລາຍວິຊານີ້';
$string['grouphasidnumber'] = 'ກຸ່ມ "{$a}" ມີຕົວເລກປະຈຳຕົວ ແລະ ອາດຈະຖືກສ້າງຂຶ້ນໂດຍອັດຕະໂນມັດໂດຍລະບົບພາຍນອກ. ທ່ານບໍ່ໄດ້ຮັບອະນຸຍາດໃຫ້ລຶບກຸ່ມນີ້ອອກ.';
$string['groupinghasidnumber'] = 'ກຸ່ມ "{$a}" ມີຕົວເລກປະຈຳຕົວ ແລະ ອາດຈະຖືກສ້າງຂຶ້ນໂດຍອັດຕະໂນມັດໂດຍລະບົບພາຍນອກ. ທ່ານບໍ່ໄດ້ຮັບອະນຸຍາດໃຫ້ລຶບກຸ່ມນີ້ອອກ.';
$string['groupingnotaddederror'] = 'ບໍ່ໄດ້ຖືກເພີ່ມການຈັດກຸ່ມ "{$a}"';
$string['groupnotaddederror'] = 'ບໍ່ໄດ້ຖືກເພີ່ມກຸ່ມ "{$a}"';
$string['groupnotaddedtogroupingerror'] = 'ກຸ່ມ "{$a->groupname}" ບໍ່ໄດ້ຖືກເພີ່ມເຂົ້າກຸ່ມ "{$a->groupingname}"';
$string['groupunknown'] = 'ກຸ່ມ {$a} ບໍ່ກ່ຽວຂ້ອງກັບລາຍວິຊາທີ່ລະບຸ';
$string['groupusernotmember'] = 'ຜູ້ໃຊ້ບໍ່ແມ່ນສະມາຊິກຂອງກຸ່ມນີ້.';
$string['guestcantaccessprofiles'] = 'ແຂກບໍ່ສາມາດເຂົ້າເຖິງໂປຼໄຟລ໌ຜູ້ໃຊ້ໄດ້. ເຂົ້າສູ່ລະບົບດ້ວຍບັນຊີຜູ້ໃຊ້ເຕັມຮູບແບບເພື່ອສືບຕໍ່.';
$string['guestnocomment'] = 'ແຂກບໍ່ໄດ້ຮັບອະນຸຍາດໃຫ້ຂຽນຄຳເຫັນ!';
$string['guestnoeditprofile'] = 'ຜູ້ໃຊ້ແຂກບໍ່ສາມາດແກ້ໄຂໂປຼໄຟລ໌ຂອງເຂົາເຈົ້າໄດ້';
$string['guestnoeditprofileother'] = 'ໂປຼໄຟລ໌ຜູ້ໃຊ້ແຂກບໍ່ສາມາດແກ້ໄຂໄດ້';
$string['guestnorate'] = 'ແຂກບໍ່ໄດ້ຮັບອະນຸຍາດໃຫ້ຄະແນນລາຍການ';
$string['guestsarenotallowed'] = 'ຜູ້ໃຊ້ແຂກບໍ່ໄດ້ຮັບອະນຸຍາດໃຫ້ເຮັດສິ່ງນີ້';
$string['hackdetected'] = 'ກວດພົບການໂຈມຕີ Hack!';
$string['hashpoolproblem'] = 'ເນື້ອຫາອ່າງເກັບໄຟລ໌ບໍ່ຖືກຕ້ອງ {$a}.';
$string['headersent'] = 'ສົ່ງສ່ວນຫົວໄປກ່ອນແລ້ວ';
$string['idnumbertaken'] = 'ໝາຍເລກປະຈຳຕົວນີ້ຖືກໃຊ້ຢູ່ແລ້ວ';
$string['idnumbertoolong'] = 'ໝາຍເລກປະຈຳຕົວຍາວເກີນໄປ';
$string['importformatnotimplement'] = 'ຂໍອະໄພ, ການນຳເຂົ້າຮູບແບບນີ້ຍັງບໍ່ທັນຖືກຈັດຕັ້ງປະຕິບັດ!';
$string['incorrectext'] = 'ໄຟລ໌ມີສ່ວນຂະຫຍາຍບໍ່ຖືກຕ້ອງ';
$string['inplaceeditableerror'] = 'ເກີດຄວາມຜິດພາດໃນການເອີ້ນຫາໜ່ວຍປະມວນຜົນປັບປຸງ';
$string['installproblem'] = 'ໂດຍປົກກະຕິແລ້ວມັນບໍ່ສາມາດກູ້ຄືນຈາກຄວາມຜິດພາດທີ່ເກີດຂຶ້ນໃນລະຫວ່າງການຕິດຕັ້ງ, ທ່ານອາດຈະຕ້ອງສ້າງຖານຂໍ້ມູນໃໝ່ ຫຼື ໃຊ້ຄໍານໍາໜ້າຖານຂໍ້ມູນທີ່ແຕກຕ່າງກັນ ຖ້າທ່ານຕ້ອງການລອງການຕິດຕັ້ງຄືນໃໝ່.';
$string['internalauthpassworderror'] = 'ບໍ່ມີລະຫັດຜ່ານ ຫຼື ນະໂຍບາຍລະຫັດຜ່ານບໍ່ຖືກຕ້ອງສໍາລັບການກວດສອບຄວາມຖືກຕ້ອງພາຍໃນ';
$string['invalidaccess'] = 'ໜ້ານີ້ບໍ່ຖືກເຂົ້າຫາຢ່າງຖືກຕ້ອງ';
$string['invalidaccessparameter'] = 'ຕົວກຳນົດການເຂົ້າເຖິງບໍ່ຖືກຕ້ອງ';
$string['invalidaction'] = 'ຕົວກຳນົດການປະຕິບັດບໍ່ຖືກຕ້ອງ';
$string['invalidactivityid'] = 'ລະຫັດປະຈຳຕົວກິດຈະກຳບໍ່ຖືກຕ້ອງ';
$string['invalidadminsettingname'] = 'ການຕັ້ງຄ່າຜູ້ເບິ່ງແຍງລະບົບບໍ່ຖືກຕ້ອງ ({$a})';
$string['invalidargorconf'] = 'ບໍ່ມີການໂຕ້ແຍ້ງທີ່ສະໜອງໃຫ້ຖືກຕ້ອງ ຫຼື ການຕັ້ງຄ່າເຊີບເວີບໍ່ຖືກຕ້ອງ';
$string['invalidarguments'] = 'ບໍ່ໄດ້ໃຫ້ການໂຕ້ແຍ້ງທີ່ຖືກຕ້ອງ';
$string['invalidblockinstance'] = 'ຕົວຢ່າງການບລັອກທີ່ບໍ່ຖືກຕ້ອງສໍາລັບ: {$a}';
$string['invalidbulkenrolop'] = 'ຮ້ອງຂໍການດຳເນີນການລົງທະບຽນຈຳນວນຫຼາຍບໍ່ຖືກຕ້ອງ.';
$string['invalidcategory'] = 'ປະເພດບໍ່ຖືກຕ້ອງ!';
$string['invalidcategoryid'] = 'ປະເພດລະຫັດປະຈຳຕົວບໍ່ຖືກຕ້ອງ!';
$string['invalidcomment'] = 'ຄຳເຫັນແມ່ນບໍ່ຖືກຕ້ອງ';
$string['invalidcommentarea'] = 'ພື້ນທີ່ຄຳເຫັນບໍ່ຖືກຕ້ອງ';
$string['invalidcommentid'] = 'ລະຫັດປະຈຳຕົວຄຳເຫັນບໍ່ຖືກຕ້ອງ';
$string['invalidcommentitemid'] = 'ລະຫັດປະຈຳຕົວລາຍການຄຳເຫັນບໍ່ຖືກຕ້ອງ';
$string['invalidcommentparam'] = 'ຕົວກຳນົດຄຳເຫັນບໍ່ຖືກຕ້ອງ';
$string['invalidcomponent'] = 'ຊື່ອົງປະກອບບໍ່ຖືກຕ້ອງ';
$string['invalidconfirmdata'] = 'ຂໍ້ມູນການຢືນຢັນບໍ່ຖືກຕ້ອງ';
$string['invalidcontentid'] = 'ລະຫັດປະຈຳຕົວເນື້ອໃນບໍ່ຖືກຕ້ອງ';
$string['invalidcontext'] = 'ບໍລິບົດບໍ່ຖືກຕ້ອງ';
$string['invalidcountrycode'] = 'ລະຫັດປະເທດບໍ່ຖືກຕ້ອງ: {$a}';
$string['invalidcourse'] = 'ລາຍວິຊາບໍ່ຖືກຕ້ອງ';
$string['invalidcourseformat'] = 'ຮູບແບບລາຍວິຊາບໍ່ຖືກຕ້ອງ';
$string['invalidcourseid'] = 'ທ່ານກຳລັງພະຍາຍາມໃຊ້ລະຫັດປະຈຳຕົວລາຍວິຊາທີ່ບໍ່ຖືກຕ້ອງ';
$string['invalidcourselevel'] = 'ລະດັບບໍລິບົດບໍ່ຖືກຕ້ອງ';
$string['invalidcoursemodule'] = 'ລະຫັດປະຈຳຕົວຊຸດລາຍວິຊາບໍ່ຖືກຕ້ອງ';
$string['invalidcoursenameshort'] = 'ຊື່ລາຍວິຊາສັ້ນບໍ່ຖືກຕ້ອງ';
$string['invaliddata'] = 'ຂໍ້ມູນທີ່ສົ່ງເຂົ້າບໍ່ຖືກຕ້ອງ';
$string['invaliddatarootpermissions'] = 'ກວດພົບການອະນຸຍາດທີ່ບໍ່ຖືກຕ້ອງເມື່ອພະຍາຍາມສ້າງບັນຊີລາຍການ. ເປີດການດີບັກສຳລັບລາຍລະອຽດເພີ່ມເຕີມ.';
$string['invaliddevicetype'] = 'ປະເພດອຸປະກອນບໍ່ຖືກຕ້ອງ';
$string['invalidelementid'] = 'ລະຫັດປະຈຳຕົວອົງປະກອບບໍ່ຖືກຕ້ອງ!';
$string['invalidentry'] = 'ນີ້ບໍ່ແມ່ນການປ້ອນເຂົ້າທີ່ຖືກຕ້ອງ!';
$string['invalidevent'] = 'ນັດໝາຍບໍ່ຖືກຕ້ອງ';
$string['invalidfieldname'] = '"{$a}" ບໍ່ແມ່ນຊື່ຊ່ອງຂໍ້ມູນທີ່ຖືກຕ້ອງ';
$string['invalidfiletype'] = '"{$a}" ບໍ່ແມ່ນປະເພດໄຟລ໌ທີ່ຖືກຕ້ອງ';
$string['invalidformatpara'] = 'ຮູບແບບບໍ່ຖືກຕ້ອງສໍາລັບການເລືອກຕົວກຳນົດ';
$string['invalidformdata'] = 'ຂໍ້ມູນແບບຟອມບໍ່ຖືກຕ້ອງ';
$string['invalidfunction'] = 'ການໃຊ້ງານບໍ່ຖືກຕ້ອງ';
$string['invalidgradeitemid'] = 'ລະຫັດປະຈຳຕົວລາຍການຄະແນນບໍ່ຖືກຕ້ອງ';
$string['invalidgroupid'] = 'ລະບຸກຸ່ມລະຫັດປະຈຳຕົວບໍ່ຖືກຕ້ອງ';
$string['invalidipformat'] = 'ຮູບແບບທີ່ຢູ່ IP ບໍ່ຖືກຕ້ອງ';
$string['invaliditemid'] = 'ລະຫັດປະຈຳຕົວລາຍການບໍ່ຖືກຕ້ອງ';
$string['invalidkey'] = 'ລະຫັດບໍ່ຖືກຕ້ອງ';
$string['invalidlanguagecode'] = 'ລະຫັດພາສາບໍ່ຖືກຕ້ອງ: {$a}';
$string['invalidlegacy'] = 'ນິຍາມຕໍາແໜ່ງເດີມບໍ່ຖືກຕ້ອງສໍາລັບປະເພດ: {$a}';
$string['invalidmd5'] = 'ຕົວປ່ຽນການກວດສອບບໍ່ຖືກຕ້ອງ - ລອງໃໝ່ອີກຄັ້ງ';
$string['invalidmode'] = 'ໂໝດບໍ່ຖືກຕ້ອງ ({$a})';
$string['invalidmodule'] = 'ຊຸດບໍ່ຖືກຕ້ອງ';
$string['invalidmoduleid'] = 'ລະຫັດປະຈຳຕົວຊຸດບໍ່ຖືກຕ້ອງ: {$a}';
$string['invalidmodulename'] = 'ຊື່ຊຸດບໍ່ຖືກຕ້ອງ: {$a}';
$string['invalidnum'] = 'ຄ່າໂຕເລກບໍ່ຖືກຕ້ອງ';
$string['invalidnumkey'] = '$ເງື່ອນໄຂແຖວອາດຈະບໍ່ມີປຸ່ມຕົວເລກ. ກະລຸນາແກ້ໄຂລະຫັດ!';
$string['invalidoutcome'] = 'ລະຫັດປະຈຳຕົວຜົນໄດ້ຮັບບໍ່ຖືກຕ້ອງ';
$string['invalidpagesize'] = 'ຂະໜາດໜ້າບໍ່ຖືກຕ້ອງ';
$string['invalidpasswordpolicy'] = 'ນະໂຍບາຍລະຫັດຜ່ານບໍ່ຖືກຕ້ອງ';
$string['invalidpaymentmethod'] = 'ວິທີການຈ່າຍເງິນບໍ່ຖືກຕ້ອງ: {$a}';
$string['invalidpersistenterror'] = 'ຜິດພາດ: {$a}';
$string['invalidqueryparam'] = 'ຜິດພາດ: ຕົວເລກການສອບຖາມບໍ່ຖືກຕ້ອງ. ຄາດຫວັງ {$a->expected}, ໄດ້ຮັບ {$a->actual}.';
$string['invalidratingarea'] = 'ພື້ນທີ່ໃຫ້ຄະແນນບໍ່ຖືກຕ້ອງ';
$string['invalidrecord'] = 'ບໍ່ສາມາດຊອກຫາບັນທຶກຂໍ້ມູນຢູ່ໃນຕາຕະລາງຖານຂໍ້ມູນ {$a}.';
$string['invalidrecordunknown'] = 'ບໍ່ສາມາດຊອກຫາບັນທຶກຂໍ້ມູນຢູ່ໃນຖານຂໍ້ມູນໄດ້.';
$string['invalidrequest'] = 'ການຮ້ອງຂໍບໍ່ຖືກຕ້ອງ';
$string['invalidrole'] = 'ໜ້າທີ່ບໍ່ຖືກຕ້ອງ';
$string['invalidroleid'] = 'ລະຫັດປະຈຳຕົວໜ້າທີ່ບໍ່ຖືກຕ້ອງ';
$string['invalidscaleid'] = 'ລະຫັດປະຈຳຕົວມາດຕາສ່ວນບໍ່ຖືກຕ້ອງ';
$string['invalidsection'] = 'ບັນທຶກຊຸດລາຍວິຊາມີພາກທີ່ບໍ່ຖືກຕ້ອງ';
$string['invalidsesskey'] = 'ຊ່ວງເວລາຂອງທ່ານໝົດເວລາ. ກະລຸນາເຂົ້າສູ່ລະບົບອີກຄັ້ງ.';
$string['invalidshortname'] = 'ຊື່ລາຍວິຊາສັ້ນບໍ່ຖືກຕ້ອງ';
$string['invalidsourcefield'] = 'ຊ່ອງຂໍ້ມູນແຫຼ່ງຂອງໄຟລ໌ສະບັບຮ່າງບໍ່ຖືກຕ້ອງ';
$string['invalidstatedetected'] = 'ມີບາງຢ່າງຜິດພາດ: {$a}. ສິ່ງນີ້ບໍ່ຄວນຈະເກີດຂຶ້ນຕາມປົກກະຕິ.';
$string['invalidurl'] = 'URL ບໍ່ຖືກຕ້ອງ';
$string['invaliduser'] = 'ຜູ້ໃຊ້ບໍ່ຖືກຕ້ອງ';
$string['invaliduserdata'] = 'ຂໍ້ມູນຜູ້ໃຊ້ບໍ່ຖືກຕ້ອງ: {$a}';
$string['invaliduserfield'] = 'ບ່ອນໃສ່ຂໍ້ມູນຜູ້ໃຊ້ບໍ່ຖືກຕ້ອງ: {$a}';
$string['invaliduserid'] = 'ລະຫັດປະຈຳຕົວຜູ້ໃຊ້ບໍ່ຖືກຕ້ອງ';
$string['invalidusername'] = 'ຊື່ຜູ້ໃຊ້ທີ່ໄດ້ໃຫ້ມີຕົວອັກສອນທີ່ບໍ່ຖືກຕ້ອງ';
$string['invalidusernameblank'] = 'ຊື່ຜູ້ໃຊ້ບໍ່ສາມາດຫວ່າງເປົ່າໄດ້';
$string['invalidxmlfile'] = '"{$a}" ບໍ່ແມ່ນໄຟລ໌ XML ທີ່ຖືກຕ້ອງ';
$string['iplookupfailed'] = 'ບໍ່ສາມາດຊອກຫາຂໍ້ມູນພູມສາດກ່ຽວກັບທີ່ຢູ່ IP ນີ້ {$a}';
$string['iplookupprivate'] = 'ບໍ່ສາມາດສະແດງການຊອກຫາທີ່ຢູ່ IP ສ່ວນຕົວໄດ້';
$string['ipmismatch'] = 'ທີ່ຢູ່ IP ຂອງລູກຄ້າບໍ່ກົງກັນ';
$string['listcantmovedown'] = 'ຍ້າຍລາຍການລົງບໍ່ສຳເລັດ, ເພາະວ່າມັນເປັນອັນສຸດທ້າຍຂອງກຸ່ມດຽວກັນ.';
$string['listcantmoveleft'] = 'ຍ້າຍລາຍການໄປຊ້າຍບໍ່ສຳເລັດເນື່ອງຈາກມັນບໍ່ມີຕົວຫຼັກ';
$string['listcantmoveright'] = 'ຍ້າຍລາຍການໄປທາງຂວາບໍ່ສຳເລັດ, ເນື່ອງຈາກບໍ່ກຸ່ມດຽວກັນທີ່ຈະເຮັດໃຫ້ມັນເປັນຂອງລູກໄດ້. ຍ້າຍມັນໄປຂ້າງລຸ່ມກຸ່ມອື່ນ ແລະ ຈາກນັ້ນທ່ານສາມາດຍ້າຍມັນໄປທາງຂວາ.';
$string['listcantmoveup'] = 'ຍ້າຍລາຍການຂຶ້ນເທິງບໍ່ສຳເລັດ, ເພາະວ່າມັນເປັນອັນດັບທຳອິດຂອງກຸ່ມດຽວກັນ.';
$string['listnochildren'] = 'ບໍ່ພົບລູກຂອງລາຍການ';
$string['listnoitem'] = 'ບໍ່ພົບລາຍການ';
$string['listnopeers'] = 'ບໍ່ພົບກຸ່ມດຽວກັນລາຍການ';
$string['listupdatefail'] = 'ການດຳເນີນການ DB ລົ້ມເຫຼວເມື່ອແກ້ໄຂ ລຳດັບບັນຊີລາຍຊື່';
$string['logfilenotavailable'] = 'ບໍ່ມີບັນທຶກ';
$string['loginasnoenrol'] = 'ທ່ານບໍ່ສາມາດໃຊ້ລົງທະບຽນ ຫຼື ຍົກເລີກການລົງທະບຽນໄດ້ໃນເວລາທີ່ຢູ່ໃນລາຍວິຊາ "ເຂົ້າສູ່ລະບົບເປັນ" ຊ່ວງເວລາ';
$string['loginasonecourse'] = 'ທ່ານບໍ່ສາມາດເຂົ້າລາຍວິຊານີ້ໄດ້. <br /> ທ່ານຕ້ອງຢຸດຕິຊ່ວງເວລາ "ເຂົ້າສູ່ລະບົບເປັນ" ກ່ອນເຂົ້າຮຽນລາຍວິຊາອື່ນ.';
$string['maxareabytes'] = 'ໄຟລ໌ໃຫຍ່ກ່ວາຊ່ອງທີ່ຍັງເຫຼືອຢູ່ໃນພື້ນທີ່ນີ້.';
$string['maxbytesfile'] = 'ໄຟລ໌ {$a->file} ໃຫຍ່ເກີນໄປ. ຂະໜາດສູງສຸດທີ່ທ່ານສາມາດອັບໂຫຼດໄດ້ແມ່ນ {$ a->size}.';
$string['maxdraftitemids'] = 'ການອັບໂຫຼດໄຟລ໌ຂອງທ່ານຖືກຈຳກັດຊົ່ວຄາວຫຼັງຈາກທ່ານອັບໂຫຼດໄຟລ໌ໃນປະລິມານສູງ. ກະລຸນາລໍຖ້າຈາກນັ້ນລອງໃໝ່.';
$string['messageundeliveredbynotificationsettings'] = 'ບໍ່ສາມາດສົ່ງຂໍ້ຄວາມໄດ້ເພາະວ່າຂໍ້ຄວາມສ່ວນຕົວລະຫວ່າງຜູ້ໃຊ້ (ຢູ່ໃນການຕັ້ງຄ່າການແຈ້ງເຕືອນ) ຖືກປິດໃຊ້ໂດຍຜູ້ບໍລິຫານເວັບໄຊທ໌.';
$string['messagingdisable'] = 'ການສົ່ງຂໍ້ຄວາມຢູ່ໃນເວັບໄຊທ໌ນີ້ຖືກປິດໃຊ້ງານ';
$string['mimetexisnotexist'] = 'ລະບົບຂອງທ່ານບໍ່ໄດ້ຖືກຕັ້ງຄ່າໃຫ້ແລ່ນ mimeTeX. ທ່ານຕ້ອງໄດ້ຮັບແຫຼ່ງ C ຈາກ <a href="https://www.forkosh.com/mimetex.zip">https://www.forkosh.com/mimetex.zip</a>, ລວບລວມມັນ ແລະ ວາງການປະຕິບັດເຂົ້າໄປໃນ  moodle/filter/tex/directory ຂອງທ່ານ.';
$string['mimetexnotexecutable'] = 'mimetex ກຳນົດເອງບໍ່ສາມາດໃຊ້ໄດ້!';
$string['missing_moodle_backup_xml_file'] = 'ການສຳຮອງຂໍ້ມູນບໍ່ມີໄຟລ໌ XML: {$a}';
$string['missingcategoryrole'] = 'ບໍ່ສາມາດແຕ່ງຕັ້ງໜ້າທີ່ໃຫ້ຜູ້ໃຊ້: ບົດບາດຂາດຫາຍສຳລັບປະເພດ.';
$string['missingfield'] = 'ຊ່ອງຂໍ້ມູນ "{$a}" ຂາດຫາຍໄປ';
$string['missingkeyinsql'] = 'ຜິດພາດ: ຂາດຕົວກຳນົດ "{$a}" ໃນການສອບຖາມ';
$string['missingparam'] = 'ຕົວກຳນົດທີ່ຕ້ອງການ ({$a}) ຂາດຫາຍໄປ';
$string['missingparameter'] = 'ຕົວກຳນົດຂາດຫາຍໄປ';
$string['missingrequiredfield'] = 'ຊ່ອງຂໍ້ມູນທີ່ຕ້ອງການບາງບ່ອນຂາດຫາຍໄປ';
$string['missinguseranditemid'] = 'ບໍ່ມີ userid ແລະ itemid';
$string['missingvarname'] = 'ຊື່ຕົວແປທີ່ຕ້ອງການຂາດຫາຍໄປ!';
$string['mixedtypesqlparam'] = 'ຜິດພາດ: ປະເພດປະສົມຂອງຕົວກຳນົດການສອບຖາມ sql!!';
$string['mnetdisable'] = 'MNET ຖືກປິດການນຳໃຊ້';
$string['mnetlocal'] = 'ຜູ້ໃຊ້ MNET ທາງໄກບໍ່ສາມາດເຂົ້າສູ່ລະບົບຢູ່ໃນເຄື່ອງໄດ້';
$string['moduledisable'] = 'ຊຸດນີ້ ({$a}) ໄດ້ຖືກປິດໃຊ້ງານສໍາລັບລາຍວິຊາສະເພາະນີ້';
$string['moduledoesnotexist'] = 'ບໍ່ມີຊຸດນີ້';
$string['moduleinstancedoesnotexist'] = 'ຕົວຢ່າງຂອງຊຸດນີ້ບໍ່ມີຢູ່';
$string['modulemissingcode'] = 'ຊຸດ {$a} ຂາດລະຫັດທີ່ຕ້ອງການເພື່ອເຮັດໜ້າທີ່ນີ້';
$string['movecatcontentstoroot'] = 'ບໍ່ອະນຸຍາດໃຫ້ຍ້າຍເນື້ອຫາປະເພດໄປຫາຮາກ. ທ່ານຕ້ອງຍ້າຍເນື້ອໃນໄປຫາປະເພດທີ່ມີຢູ່ແລ້ວ!';
$string['movecatcontentstoselected'] = 'ບາງເນື້ອໃນປະເພດບໍ່ສາມາດຖືກຍ້າຍເຂົ້າໄປໃນປະເພດທີ່ເລືອກໄດ້.';
$string['movecategorynotpossible'] = 'ທ່ານບໍ່ສາມາດຍ້າຍປະເພດ \'{$a}\' ເຂົ້າໄປໃນປະເພດທີ່ເລືອກໄດ້.';
$string['movecategoryownparent'] = 'ທ່ານບໍ່ສາມາດຕັ້ງປະເພດ \'{$a}\' ໃຫ້ເປັນຫຼັກຂອງຕົວມັນເອງໄດ້.';
$string['movecategoryparentconflict'] = 'ທ່ານບໍ່ສາມາດເຮັດໃຫ້ປະເພດ \'{$a}\' ເປັນປະເພດຍ່ອຍຂອງໜຶ່ງໃນປະເພດຍ່ອຍຂອງຕົນເອງໄດ້.';
$string['mssqlrcsmodemissing'] = 'ຖານຂໍ້ມູນບໍ່ໄດ້ໃຊ້ໂໝດ READ_COMMITTED_SNAPSHOT ທີ່ຄາດໄວ້ເຊິ່ງສາມາດນໍາໄປສູ່ຜົນໄດ້ຮັບທີ່ບໍ່ຖືກຕ້ອງ, ໂດຍສະເພາະພາຍໃຕ້ສະຖານະການທີ່ມີຄວາມສອດຄ່ອງກັນສູງ. ກະລຸນາເປີດໃຊ້ມັນເພື່ອການປະພຶດທີ່ຖືກຕ້ອງ. ສໍາລັບຂໍ້ມູນເພີ່ມເຕີມ, ເບິ່ງເອກະສານ <a href="https://docs.moodle.org/en/Installing_MSSQL_for_PHP">ການຕິດຕັ້ງ MSSQL ສຳລັບ PHP</a>.';
$string['multiplerecordsfound'] = 'ພົບເຫັນບັນທຶກຫຼາຍອັນ, ຄາດວ່າບັນທຶກໄດ້ພຽງບັນທຶກດຽວເທົ່ານັ້ນ.';
$string['multiplerestorenotallow'] = 'ບໍ່ອະນຸຍາດໃຫ້ດຳເນີນການກູ້ຄືນຫຼາຍຄັ້ງ!';
$string['mustbeloggedin'] = 'ທ່ານຕ້ອງເຂົ້າສູ່ລະບົບເພື່ອເຮັດສິ່ງນີ້';
$string['mustbeteacher'] = 'ທ່ານຕ້ອງເປັນຄູສອນເພື່ອເບິ່ງໜ້ານີ້';
$string['myisamproblem'] = 'ຕາຕະລາງຖານຂໍ້ມູນກໍາລັງໃຊ້ເຄື່ອງຈັກຖານຂໍ້ມູນ MyISAM, ແນະນໍາໃຫ້ໃຊ້ເຄື່ອງຈັກທີ່ເຂົ້າກັນໄດ້ກັບ ACID ດ້ວຍການຮອງຮັບການເຮັດທຸລະກໍາເຕັມຮູບແບບເຊັ່ນ: InnoDB.';
$string['needcopy'] = 'ທ່ານຈຳເປັນຕ້ອງສຳເນົາບາງອັນໄວ້ກ່ອນ!';
$string['needcoursecategroyid'] = 'ຕ້ອງລະບຸລະຫັດປະຈຳຕົວລາຍວິຊາ ຫຼື ປະເພດ';
$string['needphpext'] = 'ທ່ານຕ້ອງການເພີ່ມການຮອງຮັບ {$a} ເຂົ້າໃນການຕິດຕັ້ງ PHP ຂອງທ່ານ';
$string['noadmins'] = 'ບໍ່ມີຜູ້ບໍລິຫານ!';
$string['noblocks'] = 'ບໍ່ພົບບລັອກ!';
$string['nocapabilitytousethisservice'] = 'ຜູ້ໃຊ້ບໍ່ມີຄວາມສາມາດທີ່ຕ້ອງການເພື່ອໃຊ້ການບໍລິການນີ້';
$string['nocategorydelete'] = 'ບໍ່ສາມາດລຶບປະເພດ \'{$a}\' ໄດ້!';
$string['nocontext'] = 'ຂໍອະໄພ, ແຕ່ຫຼັກສູດນັ້ນບໍ່ແມ່ນບໍລິບົດທີ່ຖືກຕ້ອງ';
$string['nodata'] = 'ບໍ່ມີຂໍ້ມູນ';
$string['noexistingcategory'] = 'ບໍ່ມີປະເພດທີ່ມີຢູ່';
$string['nofile'] = 'ໄຟລ໌ບໍ່ໄດ້ລະບຸ';
$string['nofiltersenabled'] = 'ບໍ່ໄດ້ເປີດໃຊ້ຕົວກັ່ນຕອງ.';
$string['nofolder'] = 'ບໍ່ມີບັນຊີລາຍຊື່ທີ່ຮ້ອງຂໍ';
$string['noformdesc'] = 'ບໍ່ພົບໄຟລ໌ຄຳອະທິບາຍແບບຟອມ formlib ສຳລັບກິດຈະກຳນີ້.';
$string['noguest'] = 'ບໍ່ມີແຂກຢູ່ທີ່ນີ້!';
$string['noinstances'] = 'ບໍ່ມີຕົວຢ່າງຂອງ {$a} ໃນລາຍວິຊານີ້!';
$string['nologinas'] = 'ທ່ານຍັງບໍ່ໄດ້ຮັບອະນຸຍາດໃຫ້ເຂົ້າສູ່ລະບົບເປັນຜູ້ໃຊ້ນັ້ນ';
$string['nonmeaningfulcontent'] = 'ເນື້ອຫາທີ່ບໍ່ມີຄວາມາຍ';
$string['noparticipants'] = 'ບໍ່ພົບຜູ້ເຂົ້າຮ່ວມສຳລັບລາຍວິຊານີ້';
$string['noparticipatorycms'] = 'ຂໍອະໄພ, ແຕ່ທ່ານບໍ່ມີລາຍວິຊາການມີສ່ວນຮ່ວມເພື່ອລາຍງານໃສ່';
$string['nopermissions'] = 'ຂໍອະໄພ, ແຕ່ປະຈຸບັນທ່ານບໍ່ມີສິດອະນຸຍາດໃນການເຮັດສິ່ງນັ້ນ ({$a}).';
$string['nopermissiontoaccesspage'] = 'ທ່ານບໍ່ມີສິດອະນຸຍາດເຂົ້າເຖິງໜ້ານີ້.';
$string['nopermissiontocomment'] = 'ທ່ານບໍ່ສາມາດເພີ່ມຄຳເຫັນໄດ້';
$string['nopermissiontodelentry'] = 'ທ່ານບໍ່ສາມາດລຶບຄຳເຫັນນີ້ອອກໄດ້!';
$string['nopermissiontoeditcomment'] = 'ທ່ານບໍ່ສາມາດແກ້ໄຂຄຳເຫັນຂອງຄົນອື່ນໄດ້!';
$string['nopermissiontohide'] = 'ບໍ່ມີການອະນຸຍາດໃຫ້ເຊື່ອງ!';
$string['nopermissiontoimportact'] = 'ທ່ານບໍ່ມີສິດອະນຸຍາດທີ່ຈຳເປັນເພື່ອນຳ ເຂົ້າກິດຈະກຳເຂົ້າໃນລາຍວິຊານີ້';
$string['nopermissiontolock'] = 'ບໍ່ມີການອະນຸຍາດໃຫ້ລັອກ!';
$string['nopermissiontomanagegroup'] = 'ທ່ານບໍ່ມີສິດອະນຸຍາດທີ່ຕ້ອງການເພື່ອຈັດການກຸ່ມ';
$string['nopermissiontorate'] = 'ບໍ່ອະນຸຍາດໃຫ້ຄະແນນລາຍການ!';
$string['nopermissiontoshow'] = 'ບໍ່ມີການອະນຸຍາດໃຫ້ເບິ່ງສິ່ງນີ້!';
$string['nopermissiontounlock'] = 'ບໍ່ມີການອະນຸຍາດໃຫ້ປົດລັອກ!';
$string['nopermissiontoupdatecalendar'] = 'ຂໍອະໄພ, ແຕ່ທ່ານບໍ່ໄດ້ຮັບອະນຸຍາດໃຫ້ປັບປຸງນັດໝາຍປະຕິທິນ.';
$string['nopermissiontoviewcalendar'] = 'ຂໍອາໄພ, ແຕ່ວ່າທ່ານບໍ່ໄດ້ຮັບການອານຸມັດໃຫ້ເບິ່ງເຫດການໃນປະຕິທິນ.';
$string['nopermissiontoviewgrades'] = 'ບໍ່ສາມາດເບິ່ງຄະແນນໄດ້.';
$string['nopermissiontoviewletergrade'] = 'ຂາດການອະນຸຍາດເພື່ອເບິ່ງຄະແນນຕົວ ໜັງສື';
$string['nopermissiontoviewpage'] = 'ທ່ານຍັງບໍ່ໄດ້ຮັບອະນຸຍາດໃຫ້ເບິ່ງໜ້ານີ້';
$string['nosite'] = 'ບໍ່ສາມາດຊອກຫາລາຍວິຊາລະດັບສູງສຸດໄດ້!';
$string['nositeid'] = 'ບໍ່ມີລະຫັດປະຈຳຕົວເວັບໄຊທ໌';
$string['nostartdatenoenddate'] = 'ວັນທີຈົບລາຍວິຊາສາມາດຕັ້ງໄດ້ສະເພາະຖ້າຕັ້ງວັນທີເລີ່ມຕົ້ນເທົ່ານັ້ນ.';
$string['nostatstodisplay'] = 'ຂໍອະໄພ, ບໍ່ມີຂໍ້ມູນທີ່ສາມາດສະແດງໄດ້';
$string['notallowedtoupdateprefremotely'] = 'ທ່ານຍັງບໍ່ໄດ້ຮັບອະນຸຍາດໃຫ້ປັບປຸງການຕັ້ງຄ່າຜູ້ໃຊ້ນີ້ຈາກທາງໄກ';
$string['notavailable'] = 'ນັ້ນບໍ່ມີໃຫ້ໃນປະຈຸບັນ';
$string['notlocalisederrormessage'] = '{$a}';
$string['notmemberofgroup'] = 'ທ່ານບໍ່ແມ່ນສະມາຊິກຂອງກຸ່ມລາຍວິຊານີ້';
$string['notownerofkey'] = 'ທ່ານບໍ່ແມ່ນເຈົ້າຂອງກະແຈນີ້';
$string['nousers'] = 'ບໍ່ມີຜູ້ໃຊ້ດັ່ງກ່າວ!';
$string['oauth1accesstoken'] = 'ຜິດພາດ OAuth 1.0: ພວກເຮົາບໍ່ໄດ້ຮັບໂທເຄັນການເຂົ້າຫາ.';
$string['oauth1requesttoken'] = 'ຜິດພາດ OAuth 1.0: ພວກເຮົາບໍ່ໄດ້ຮັບໂທເຄັນການຮ້ອງຂໍ - ຜູ້ໃຫ້ບໍລິການອາດຈະຢຸດເຮັດວຽກຊົ່ວຄາວ.';
$string['oauth2refreshtokenerror'] = 'ບໍ່ສາມາດໂຫຼດໂທເຄັນ OAuth 2 ຄືນໃໝ່ໄດ້. ສະຖານະ HTTP ສໍາລັບຈຸດປາຍທາງທາງໄກ: {$a}';
$string['oauth2refreshtokentaskerror'] = 'ບໍ່ສາມາດໂຫຼດໂທເຄັນ OAuth 2 ຄືນໃໝ່ສໍາລັບຜູ້ອອກໃຫ້ຫຼາຍກວ່າໜຶ່ງຄົນ. ເບິ່ງລາຍລະອຽດໜ້າວຽກ.';
$string['oauth2upgradetokenerror'] = 'ບໍ່ສາມາດຍົກລະດັບໂທເຄັນ OAuth 2 ໄດ້. ສະຖານະ HTTP ສໍາລັບຈຸດປາຍທາງທາງໄກ: {$a}';
$string['onlyadmins'] = 'ມີແຕ່ຜູ້ບໍລິຫານເທົ່ານັ້ນສາມາດເຮັດໄດ້';
$string['onlyeditingteachers'] = 'ມີພຽງແຕ່ຄູສອນແກ້ໄຂເທົ່ານັ້ນທີ່ສາມາດເຮັດໄດ້';
$string['onlyeditown'] = 'ທ່ານສາມາດແກ້ໄຂຂໍ້ມູນຂອງທ່ານເອງເທົ່ານັ້ນ';
$string['orderidnotfound'] = 'ບໍ່ພົບລະຫັດປະຈຳຕົວຄຳສັ່ງ {$a}';
$string['pagenotexist'] = '<p>ມີຂໍ້ຜິດພາດຜິດປົກກະຕິເກີດຂຶ້ນໃນການພະຍາຍາມເບິ່ງໜ້າທີ່ບໍ່ມີຢູ່:</p> {$a}';
$string['pagenotexisttitle'] = '404 ຜິດພາດ: ບໍ່ພົບໄຟລ໌';
$string['pathdoesnotstartslash'] = 'ບໍ່ໄດ້ໃຫ້ການໂຕ້ແຍ້ງທີ່ຖືກຕ້ອງ, ເສັ້ນທາງບໍ່ໄດ້ເລີ່ມຕົ້ນດ້ວຍເຄື່ອງໝາຍທັບ!';
$string['pleasereport'] = 'ຖ້າທ່ານມີເວລາ, ກະລຸນາບອກໃຫ້ພວກເຮົາຮູ້ວ່າ ທ່ານພະຍາຍາມເຮັດຫຍັງເມື່ອເກີດຄວາມຜິດພາດຂຶ້ນ:';
$string['pluginrequirementsnotmet'] = 'ປລັກອິນ "{$a->pluginname}" ({$a->pluginversion}) ບໍ່ສາມາດຕິດຕັ້ງໄດ້. ມັນຕ້ອງໃຊ້ Moodle ສະບັບທີ່ໃໝ່ກວ່າ (ປະຈຸບັນທ່ານກຳລັງໃຊ້ {$a->currentmoodle}, ທ່ານຕ້ອງການ {$a->requiremoodle}).';
$string['pluginunsupported'] = 'ປລັກອິນ "{$a->pluginname}" {$a->pluginversion} ບໍ່ຮອງຮັບ Moodle {$a->moodleversion} ສະບັບນີ້. ຊອກຫາຂໍ້ມູນປລັກອິນເພື່ອຊອກຫາສະບັບທີ່ຮອງຮັບ.';
$string['prefixcannotbeempty'] = '<p>ຜິດພາດ: ຄໍານໍາໜ້າຕາຕະລາງຖານຂໍ້ມູນບໍ່ສາມາດຫວ່າງເປົ່າໄດ້ ({$a})</p>
<p>ຜູ້ຄວບຄຸມເວັບໄຊທ໌ຕ້ອງແກ້ໄຂບັນຫານີ້.</p>';
$string['prefixtoolong'] = '<p>ຜິດພາດ: ຄໍານໍາໜ້າຕາຕະລາງຖານຂໍ້ມູນຍາວເກີນໄປ ({$a->dbfamily})</p>
<p>ຜູ້ເບິ່ງແຍງລະບົບຕ້ອງແກ້ໄຂບັນຫານີ້. ຄວາມຍາວສູງສຸດສຳລັບຄຳນຳໜ້າຕາຕະລາງໃນ {$a->dbfamily} ແມ່ນ {$a->ຄວາມຍາວສູງສຸດ} ຕົວອັກສອນ. </p>';
$string['privatefilesupload'] = 'ບໍ່ຮອງຮັບການອັບໂຫຼດໂດຍກົງໃສ່ພື້ນທີ່ໄຟລ໌ສ່ວນຕົວຂອງຜູ້ໃຊ້ອີກຕໍ່ໄປ. ອັບໂຫຼດໃສ່ພື້ນທີ່ສະບັບຮ່າງ ແລະ ຈາກນັ້ນຍ້າຍໄຟລ໌ດ້ວຍ core_user::add_user_private_files';
$string['processingstops'] = 'ການປະມວນຜົນຢຸດຢູ່ທີ່ນີ້. ບັນທຶກທີ່ຍັງເຫຼືອຖືກລະເລີຍ.';
$string['protected_cc_not_supported'] = 'ບໍ່ຮອງຮັບຕະລັບປ້ອງກັນ.';
$string['querystringcannotbeempty'] = 'ສະຕຣິງສອບຖາມບໍ່ສາມາດປ່ອຍໃຫ້ຫວ່າງໄດ້.';
$string['redirecterrordetected'] = 'ກວດພົບການປ່ຽນເສັ້ນທາງທີ່ບໍ່ຮອງຮັບ, ການປະຕິບັດສະຄຣິບສິ້ນສຸດລົງ';
$string['refoundto'] = 'ສາມາດຄືນເງິນໃຫ້ {$a} ໄດ້';
$string['refoundtoorigi'] = 'ຄືນເງິນໃຫ້ຈໍານວນເດີມ: {$a}';
$string['registrationdisabled'] = 'ການລົງທະບຽນຖືກປິດການນຳໃຊ້ໃນເວັບໄຊທ໌ນີ້';
$string['remotedownloaderror'] = '<p>ການດາວໂຫຼດອົງປະກອບໃສ່ເຊີບເວີຂອງທ່ານບໍ່ສໍາເລັດ. ກະລຸນາກວດສອບການຕັ້ງຄ່າຕົວແທນ; ສ່ວນຂະຫຍາຍ PHP cURL ແມ່ນແນະນໍາທີ່ສຸດ. </p> <p>ທ່ານຕ້ອງດາວໂຫຼດໄຟລ໌ <a href="{$a->url}">{$a->url}</a> ດ້ວຍຕົນເອງ, ອັດສຳເນົາມັນໃສ່ "{$a->dest} "ຢູ່ໃນເຊີບເວີຂອງທ່ານ ແລະ ແຍກມັນຢູ່ທີ່ນັ້ນ.</p>';
$string['remotedownloadnotallowed'] = 'ບໍ່ອະນຸຍາດໃຫ້ດາວໂຫຼດອົງປະກອບໄປຫາເຊີບເວີຂອງທ່ານ (allow_url_fopen ຖືກປິດການນຳໃຊ້). <br /><br /> ທ່ານຕ້ອງດາວໂຫຼດ <a href="{$a->url}">{$a->url} </a> ໄຟລ໌ດ້ວຍຕົນເອງ, ອັດສໍາເນົາມັນໃສ່ "{$a->dest}" ຢູ່ໃນເຊີບເວີຂອງທ່ານ ແລະ ພ້ອມທັງແຍກມັນຢູ່ທີ່ນັ້ນ.';
$string['reportnotavailable'] = 'ປະເພດຂອງບົດລາຍງານນີ້ແມ່ນມີພຽງແຕ່ສໍາລັບລາຍວິຊາຂອງສະຖານທີ່';
$string['requirecorrectaccess'] = 'URL ຫຼື ຜອດບໍ່ຖືກຕ້ອງ.';
$string['requireloginerror'] = 'ບໍ່ສາມາດເຂົ້າເຖິງລາຍວິຊາ ຫຼື ກິດຈະກຳໄດ້.';
$string['restore_path_element_missingmethod'] = 'ວິທີການກູ້ຄືນ {$a} ຂາດຫາຍໄປ. ມັນຕ້ອງຖືກກຳນົດໂດຍນັກພັດທະນາ.';
$string['restore_path_element_noobject'] = 'ກູ້ຄືນວັດຖຸ {$a} ບໍ່ແມ່ນວັດຖຸ.';
$string['restorechecksumfailed'] = 'ບາງບັນຫາເກີດຂຶ້ນກັບຂໍ້ມູນການກູ້ຄືນທີ່ເກັບໄວ້ຢູ່ໃນຊ່ວງເວລາຂອງທ່ານ. ກະລຸນາກວດເບິ່ງຂີດຈຳກັດຂະໜາດແພັກເກດ PHP/DB ຂອງທ່ານ. ຢຸດການກູ້ຄືນມາແລ້ວ.';
$string['restrictedcontextexception'] = 'ຂໍອະໄພ, ການປະຕິບັດໜ້າທີ່ພາຍນອກລະເມີດຂໍ້ຈຳກັດບໍລິບົດ.';
$string['restricteduser'] = 'ຂໍອະໄພ, ແຕ່ບັນຊີປັດຈຸບັນຂອງທ່ານ "{$a}" ແມ່ນຖືກຈຳກັດບໍ່ໃຫ້ເຮັດສິ່ງນັ້ນ';
$string['reverseproxyabused'] = 'ເປີດໃຊ້ຕົວແທນຍ້ອນກັບ ດັ່ງນັ້ນບໍ່ສາມາດເຂົ້າຫາເຊີບເວີໂດຍກົງໄດ້. <br />ກະລຸນາຕິດຕໍ່ຫາຜູ້ຄວບຄຸມເຊີບເວີ.';
$string['rpcerror'] = 'ອຸຍ! ການສື່ສານ MNET ຂອງທ່ານບໍ່ສໍາເລັດ! ນີ້ແມ່ນຂໍ້ຄວາມຜິດພາດທີ່ຈະສົ່ງຕໍ່ໄປຫາຜູ້ຄວບຄຸມຂອງທ່ານ: {$a}';
$string['scheduledbackupsdisabled'] = 'ການສຳຮອງຂໍ້ມູນທີ່ກຳນົດເວລາໄວ້ໄດ້ຖືກປິດການນຳໃຊ້ໂດຍຜູ້ເບິ່ງແຍງລະບົບເຊີບເວີ';
$string['secretalreadyused'] = 'ປ່ຽນລິ້ງຢືນຢັນລະຫັດຜ່ານແລ້ວ, ລະຫັດຜ່ານບໍ່ໄດ້ຖືກປ່ຽນ';
$string['sectionnotexist'] = 'ບໍ່ມີພາກສ່ວນນີ້';
$string['sendmessage'] = 'ສົ່ງຂໍ້ຄວາມ';
$string['sendmessagesent'] = 'ຂອບໃຈສໍາລັບຄໍາຄິດເຫັນຂອງທ່ານກ່ຽວກັບ: <br>{$a}';
$string['serverconnection'] = 'ເກີດຄວາມຜິດພາດໃນການເຊື່ອມຕໍ່ຫາເຊີບເວີ';
$string['servicedonotexist'] = 'ບໍລິການບໍ່ມີຢູ່';
$string['sessioncannotobtainlock'] = '<p>ບໍ່ສາມາດຮັບການລັອກສຳລັບ ລະຫັດ id ເຊດຊັນ {$a->id} ພາຍໃນ {$a->acquiretimeout}.</p>
<p>ມັນເປັນໄປໄດ້ວ່າໜ້າອື່ນ ({$a->whoaslock}) ຍັງແລ່ນຢູ່ໃນແຖບບຣາວເຊີອື່ນຢູ່ ຫຼື ມັນບໍ່ປ່ອຍຕົວລັອກເນື່ອງຈາກເກີດຄວາມຜິດພາດ.</p>
<p>ທ່ານສາມາດລໍຖ້າຈົນກ່ວາໝົດເວລາການລັອກເຊດຊັນ ({$a->lockexpire}) ຫຼື ທ່ານສາມາດຣີສະຕາດເຊດຊັນບຣາວເຊີຂອງທ່ານໄດ້. ຖ້າຄວາມຜິດພາດນີ້ຍັງຄົງຢູ່, ກະລຸນາແຈ້ງຜູ້ເບິ່ງແຍງເຊີບເວີ.</p>';
$string['sessioncookiesdisable'] = 'ການນໍາໃຊ້ທີ່ບໍ່ຖືກຕ້ອງຂອງ require_key_login() - ຄຸກກີ້ຊ່ວງເວລາຕ້ອງຖືກປິດການນຳໃຊ້!';
$string['sessiondiskfull'] = 'ການແບ່ງສ່ວນຊ່ວງເວລາເຕັມແລ້ວ. ມັນເປັນໄປບໍ່ໄດ້ທີ່ຈະເຂົ້າສູ່ລະບົບໃນເວລານີ້. ກະລຸນາແຈ້ງຜູ້ເບິ່ງແຍງລະບົບເຊີບເວີ.';
$string['sessionerroruser'] = 'ຊ່ວງເວລາຂອງທ່ານໝົດເວລາ. ກະລຸນາເຂົ້າສູ່ລະບົບອີກຄັ້ງ.';
$string['sessionerroruser2'] = 'ເກີດຄວາມຜິດພາດເຊີບເວີທີ່ກະທົບກັບຊ່ວງເວລາການເຂົ້າສູ່ລະບົບຂອງທ່ານ. ກະລຸນາເຂົ້າສູ່ລະບົບອີກຄັ້ງ ຫຼື ປິດເປີດໂປຼແກຼມທ່ອງເວັບຂອງທ່ານຄືນໃໝ່.';
$string['sessionexpired'] = 'ຊ່ວງເວລາໝົດອາຍຸແລ້ວ';
$string['sessionhandlerproblem'] = 'ຕົວຈັດການຊ່ວງເວລາຖືກຕັ້ງຄ່າຜິດ';
$string['sessionipnomatch'] = 'ຂໍອະໄພ, ແຕ່ໝາຍເລກ IP ຂອງທ່ານເບິ່ງຄືວ່າໄດ້ມີການປ່ຽນແປງຈາກຕອນທີ່ທ່ານເຂົ້າສູ່ລະບົບຄັ້ງທໍາອິດ. ຄຸນສົມບັດຄວາມປອດໄພນີ້ປ້ອງກັນບໍ່ໃຫ້ crackers ລັກເອົາການລະບຸຕົວຕົນຂອງທ່ານໃນຂະນະທີ່ເຂົ້າສູ່ລະບົບຫາເວັບໄຊທ໌ນີ້. ຜູ້ໃຊ້ປົກກະຕິບໍ່ຄວນຈະເຫັນຂໍ້ຄວາມນີ້ - ກະລຸນາຖາມຜູ້ເບິ່ງແຍງລະບົບເພື່ອຂໍຄວາມຊ່ວຍເຫຼືອ.';
$string['sessionipnomatch2'] = '<p>ຂໍອະໄພ, ແຕ່ໝາຍເລກ IP ຂອງທ່ານເບິ່ງຄືວ່າໄດ້ມີການປ່ຽນແປງຈາກຕອນທີ່ທ່ານເຂົ້າສູ່ລະບົບຄັ້ງທໍາອິດ. ຄຸນສົມບັດຄວາມປອດໄພນີ້ປ້ອງກັນບໍ່ໃຫ້ crackers ລັກເອົາກາຍລະບຸຕົວຕົນຂອງທ່ານໃນຂະນະທີ່ເຂົ້າສູ່ລະບົບຫາເວັບໄຊທ໌ນີ້. ທ່ານອາດຈະເຫັນຄວາມຜິດພາດນີ້ ຖ້າທ່ານໃຊ້ເຄືອຂ່າຍໄຮ້ສາຍ ຫຼື ຖ້າທ່ານກໍາລັງໂຣມມິງລະຫວ່າງເຄືອຂ່າຍຕ່າງກັນ. ກະລຸນາຖາມຜູ້ຄວບຄຸມເວັບໄຊທ໌ສໍາລັບການຊ່ວຍເຫຼືອເພີ່ມເຕີມ.</p>
<p>ຖ້າທ່ານຕ້ອງການສືບຕໍ່ກະລຸນາກົດປຸ່ມ F5 ເພື່ອໂຫຼດໜ້ານີ້ຄືນໃໝ່.</p>';
$string['sessionwaiterr'] = 'ໝົດເວລາໃນຂະນະທີ່ລໍຖ້າການລັອກຊ່ວງເວລາ.<br />ລໍຖ້າໃຫ້ການຮ້ອງຂໍປັດຈຸບັນຂອງທ່ານສໍາເລັດ ແລະ ລອງໃໝ່ພາຍຫຼັງ.';
$string['shortnametaken'] = 'ຊື່ສັ້ນຖືກໃຊ້ສໍາລັບລາຍວິຊາອື່ນຢູ່ກ່ອນແລ້ວ ({$a})';
$string['sitepolicynotagreed'] = 'ບໍ່ໄດ້ຕົກລົງນະໂຍບາຍເວັບໄຊທ໌: <a href="{$a}">ຄລິກທີ່ນີ້ເພື່ອເປີດນະໂຍບາຍຂອງເວັບໄຊທ໌.</a>';
$string['socksnotsupported'] = 'SOCKS5 proxy ບໍ່ຖືກຮອງຮັບໃນ PHP4';
$string['spellcheckernotconf'] = 'ບໍ່ໄດ້ກຳນົດຄ່າຕົວກວດຄຳຜິດ';
$string['sslonlyaccess'] = 'ສໍາລັບເຫດຜົນດ້ານຄວາມປອດໄພ, ການເຊື່ອມຕໍ່ https ເທົ່ານັ້ນໄດ້ຮັບອະນຸຍາດ, ຂໍອະໄພ.';
$string['statscatchupmode'] = 'ປະຈຸບັນສະຖິຕິຢູ່ໃນຮູບໂໝດການຈັບຕົວ. ມາຮອດປະຈຸບັນມີການປະມວນຜົນ {$a->daysdone} ມື້ ແລະ {$a->dayspending} ຍັງຄ້າງຢູ່. ກວດຄືນໃນໄວໆນີ້!';
$string['statsdisable'] = 'ສະຖິຕິບໍ່ໄດ້ຖືກເປີດໃຊ້.';
$string['statsnodata'] = 'ບໍ່ມີຂໍ້ມູນທີ່ມີຢູ່ສໍາລັບການລວມກັນຂອງລາຍວິຊາ ແລະ ໄລຍະເວລານັ້ນ';
$string['storedfilecannotcreatefile'] = 'ບໍ່ສາມາດສ້າງໄຟລ໌ອ່າງເກັບໄຟລ໌ໃນເຄື່ອງໄດ້. ກະລຸນາກວດສອບການອະນຸຍາດຢູ່ໃນ dataroot ແລະ ພື້ນທີ່ແຜ່ນດິສກທີ່ມີຢູ່.';
$string['storedfilecannotcreatefiledirs'] = 'ບໍ່ສາມາດສ້າງບັນຊີລາຍຊື່ອ່າງເກັບໄຟລ໌ ໃນເຄື່ອງໄດ້. ກະລຸນາກວດສອບການອະນຸຍາດຢູ່ໃນຖານຂໍ້ມູນ.';
$string['storedfilecannotread'] = 'ບໍ່ສາມາດອ່ານໄຟລ໌. ບໍ່ມີໄຟລ໌ຢູ່ ຫຼື ມີບັນຫາການອະນຸຍາດ.';
$string['storedfilecannotreadfile'] = 'ບໍ່ສາມາດອ່ານໄຟລ໌ \'{$a}\' ໄດ້. ບໍ່ມີໄຟລ໌ຢູ່ຫຼື ມີບັນຫາການອະນຸຍາດ.';
$string['storedfilenotcreated'] = 'ບໍ່ສາມາດສ້າງໄຟລ໌ {$a->contextid}/{$a->component}/{$a->filearea}/{$a->itemid}{$a->filepath}{$a->filename}';
$string['storedfileproblem'] = 'ຂໍ້ຍົກເວັ້ນທີ່ບໍ່ຮູ້ຈັກທີ່ກ່ຽວຂ້ອງກັບໄຟລ໌ໃນເຄື່ອງ ({$a})';
$string['tagdisabled'] = 'ແທັກຖືກປິດການນຳໃຊ້!';
$string['tagnotfound'] = 'ບໍ່ພົບແທັກທີ່ລະບຸໄວ້ໃນຖານຂໍ້ມູນ';
$string['targetdatabasenotempty'] = 'ຖານຂໍ້ມູນເປົ້າໝາຍບໍ່ຫວ່າງເປົ່າ. ຍົກເລີກການໂອນຍ້າຍດ້ວຍເຫດຜົນດ້ານຄວາມປອດໄພ.';
$string['textconditionsnotallowed'] = 'ບໍ່ອະນຸຍາດໃຫ້ມີການປຽບທຽບເງື່ອນໄຂຖັນ. ກະລຸນາໃຊ້ sql_compare_text () ໃນການສອບຖາມຂອງທ່ານ.';
$string['themenotinstall'] = 'ຮູບແບບສີສັນນີ້ບໍ່ໄດ້ຖືກຕິດຕັ້ງ!';
$string['tokengenerationfailed'] = 'ບໍ່ສາມາດສ້າງໂທເຄັນໃໝ່ໄດ້.';
$string['transactionvoid'] = 'ບໍ່ສາມາດຍົກເລີກທຸລະກໍາໄດ້ເນື່ອງຈາກວ່າມັນໄດ້ຖືກຍົກເລີກແລ້ວ';
$string['unenrolerror'] = 'ເກີດຄວາມຜິດພາດຂຶ້ນໃນຂະນະທີ່ພະຍາຍາມຍົກເລີກການລົງທະບຽນບຸກຄົນນັ້ນ';
$string['unicodeupgradeerror'] = 'ຂໍອະໄພ, ແຕ່ຖານຂໍ້ມູນຂອງທ່ານບໍ່ມີຢູ່ໃນ Unicode ແລ້ວ, ແລະ Moodle ສະບັບນີ້ບໍ່ສາມາດຍ້າຍຖານຂໍ້ມູນຂອງທ່ານໄປສູ່ Unicode. ກະລຸນາຍົກລະດັບເປັນ Moodle 1.7.x ກ່ອນ ແລະ ເຮັດການເຄື່ອນຍ້າຍ Unicode ຈາກໜ້າ Admin. ຫຼັງຈາກນັ້ນສຳເລັດແລ້ວທ່ານຄວນຈະສາມາດຍ້າຍໄປ Moodle {$a}';
$string['unknowaction'] = 'ຄຳສັ່ງທີ່ບໍ່ຮູ້ຈັກ!';
$string['unknowcategory'] = 'ບໍ່ຮູ້ຈັກປະເພດ!';
$string['unknowcontext'] = 'ນີ້ແມ່ນບໍລິບົດທີ່ບໍ່ຮູ້ຈັກ ({$a}) ໃນ get_child_contexts!';
$string['unknowformat'] = 'ບໍ່ຮູ້ຮູບແບບ ({$a})';
$string['unknownbackupexporterror'] = 'ເກີດຄວາມຜິດພາດທີ່ບໍ່ຮູ້ຈັກໃນການກະກຽມຂໍ້ມູນສໍາລັບການນໍາເຂົ້າ';
$string['unknownblockregion'] = 'ຂົງເຂດບລັອກ \'{$a}\' ບໍ່ຖືກຮັບຮູ້ຢູ່ໃນ ໜ້ານີ້.';
$string['unknowncategory'] = 'ປະເພດບໍ່ຮູ້ຈັກກັບໝຍເລກປະຈຳຕົວປະເພດ "{$a}"';
$string['unknowncontext'] = 'ນີ້ແມ່ນບໍລິບົດທີ່ບໍ່ຮູ້ຈັກ.';
$string['unknowncourse'] = 'ລາຍວິຊາທີ່ບໍ່ຮູ້ຈັກຊື່ "{$a}"';
$string['unknowncourseidnumber'] = 'ລະຫັດປະຈຳຕົວລາຍວິຊາທີ່ບໍ່ຮູ້ຈັກ "{$a}"';
$string['unknowncourserequest'] = 'ຄຳຮ້ອງຂໍລາຍວິຊາທີ່ບໍ່ຮູ້ຈັກ';
$string['unknowncoursesection'] = 'ພາກສ່ວນລາຍວິຊາທີ່ບໍ່ຮູ້ຈັກໃນລາຍວິຊາ "{$a}"';
$string['unknownevent'] = 'ເຫດການທີ່ບໍ່ຮູ້ຈັກ';
$string['unknownfiletype'] = 'ເກີດຄວາມຜິດພາດປະເພດການກັ່ນຕອງທີ່ບໍ່ຮູ້ຈັກ';
$string['unknowngroup'] = 'ກຸ່ມທີ່ບໍ່ຮູ້ຈັກ "{$a}"';
$string['unknownhelp'] = 'ຫົວຂໍ້ຊ່ວຍເຫຼືອທີ່ບໍ່ຮູ້ຈັກ {$a}';
$string['unknownjsinrequirejs'] = 'ບໍ່ສາມາດຊອກຫາຫ້ອງສະໝຸດ JavaScript {$a}.';
$string['unknownmodulename'] = 'ບໍ່ຮູ້ຊື່ຊຸດສຳລັບແບບຟອມ';
$string['unknownrole'] = 'ບົດບາດທີ່ບໍ່ຮູ້ຈັກ "{$a}"';
$string['unknownsortcolumn'] = 'ບໍ່ຮູ້ຈັກການຈັດຮຽງຖັນ {$a}';
$string['unknownuseraction'] = 'ຂໍອະໄພ, ຂ້ອຍບໍ່ເຂົ້າໃຈການກະທຳຂອງຜູ້ໃຊ້ນີ້';
$string['unknownuserselector'] = 'ຕົວເລືອກຜູ້ໃຊ້ທີ່ບໍ່ຮູ້ຈັກ';
$string['unknoworder'] = 'ບໍ່ຮູ້ການສັ່ງ';
$string['unknowparamtype'] = 'ປະເພດຕົວກຳນົດທີ່ບໍ່ຮູ້ຈັກ: {$a}';
$string['unknowquestiontype'] = 'ປະເພດຄຳຖາມທີ່ບໍ່ຮອງຮັບ {$a}';
$string['unknowuploadaction'] = 'ຜິດພາດ: ຄຳສັ່ງອັບໂຫຼດທີ່ບໍ່ຮູ້ຈັກ ({$a})';
$string['unspecifycourseid'] = 'ຕ້ອງລະບຸລະຫັດປະຈຳຕົວລາຍວິຊາ, ຊື່ຫຍໍ້ ຫຼື ໝາຍເລກລະຫັດປະຈຳຕົວ';
$string['unsupportedevent'] = 'ປະເພດເຫດການທີ່ບໍ່ຮອງຮັບ';
$string['unsupportedstate'] = 'ສະຖານະການສໍາເລັດທີ່ບໍ່ຮອງຮັບ';
$string['unsupportedwebserver'] = 'ບໍ່ຮອງຮັບຊອບແວເຊີບເວີເວັບ ({$a}), ຂໍອະໄພ.';
$string['upgraderequires19'] = 'ຜິດພາດ: Moodle ສະບັບໃໝ່ໄດ້ຖືກຕິດຕັ້ງໃສ່ເຊີບເວີ, ໜ້າເສຍດາຍທີ່ການຍົກລະດັບຈາກສະບັບກ່ອນບໍ່ຮອງຮັບ.<br /> ກະລຸນາຍົກລະດັບກ່ອນເປັນການປ່ອຍສະບັບລ້າສຸດ 1.9.x. ທ່ານຍັງສາມາດກັບຄືນຫາສະບັບກ່ອນໄດ້ໂດຍການຕິດຕັ້ງໄຟລ໌ຕົ້ນສະບັບຄືນໃໝ່.';
$string['upgraderunning'] = 'ເວັບໄຊທ໌ກໍາລັງຖືກຍົກລະດັບ, ກະລຸນາລອງໃໝ່ພາຍຫຼັງ.';
$string['urlnotdefinerss'] = 'URL ບໍ່ໄດ້ກຳນົດສຳລັບຟີດ RSS';
$string['useradmineditadmin'] = 'ມີພຽງຜູ້ບໍລິຫານເທົ່ານັ້ນທີ່ໄດ້ຮັບອະນຸຍາດໃຫ້ແກ້ໄຂບັນຊີຜູ້ເບິ່ງແຍງລະບົບອື່ນ';
$string['useradminodelete'] = 'ບັນຊີຜູ້ເບິ່ງແຍງລະບົບບໍ່ສາມາດລຶບໄດ້.';
$string['userautherror'] = 'ປລັກອິນການກວດສອບຄວາມຖືກຕ້ອງທີ່ບໍ່ຮູ້ຈັກ';
$string['userauthunsupported'] = 'ບໍ່ຮອງຮັບປລັກອິນການກວດສອບຄວາມຖືກຕ້ອງຢູ່ບ່ອນນີ້';
$string['useremailduplicate'] = 'ທີ່ຢູ່ຊ້ຳກັນ';
$string['userisfilteredout'] = 'ຜູ້ໃຊ້ນີ້ບໍ່ກົງກັບການຕັ້ງຄ່າຕົວກັ່ນຕອງ ແລະ ຕາຕະລາງ!';
$string['usermustbemnet'] = 'ຜູ້ໃຊ້ຢູ່ໃນລາຍການຄວບຄຸມການເຂົ້າຫາ MNET ຕ້ອງເປັນຜູ້ໃຊ້ MNET ທາງໄກ';
$string['usernamelowercase'] = 'ຊື່ຜູ້ໃຊ້ຕ້ອງເປັນຕົວພິມນ້ອຍ';
$string['usernotaddederror'] = 'ບໍ່ໄດ້ເພີ່ມຜູ້ໃຊ້ເຂົ້າ - ຜິດພາດ';
$string['usernotaddedregistered'] = 'ບໍ່ໄດ້ເພີ່ມຜູ້ໃຊ້ - ລົງທະບຽນແລ້ວ';
$string['usernotavailable'] = 'ລາຍລະອຽດຂອງຜູ້ໃຊ້ຄົນນີ້ບໍ່ມີໃຫ້ທ່ານ';
$string['usernotdeletedadmin'] = 'ບໍ່ໄດ້ລຶບຜູ້ໃຊ້ເປັນບັນຊີຜູ້ເບິ່ງແຍງລະບົບບໍ່ສາມາດລຶບໄດ້.';
$string['usernotdeleteddeleted'] = 'ຜູ້ໃຊ້ນີ້ຖືກລຶບໄປກ່ອນແລ້ວ.';
$string['usernotdeletederror'] = 'ຜູ້ໃຊ້ບໍ່ໄດ້ລຶບ - ຜິດພາດ';
$string['usernotdeletedmissing'] = 'ຜູ້ໃຊ້ບໍ່ຖືກລຶບ - ບໍ່ສາມາດຊອກຫາຊື່ຜູ້ໃຊ້ໄດ້';
$string['usernotdeletedoff'] = 'ບໍ່ໄດ້ລຶບຜູ້ໃຊ້ - ບໍ່ອະນຸຍາດໃຫ້ລຶບ';
$string['usernotfullysetup'] = 'ຜູ້ໃຊ້ບໍ່ໄດ້ຕັ້ງຄ່າເຕັມຮູບແບບ';
$string['usernotincourse'] = 'ຜູ້ໃຊ້ນີ້ບໍ່ໄດ້ຢູ່ໃນຫຼັກສູດນີ້!';
$string['usernotrenamedadmin'] = 'ບໍ່ສາມາດປ່ຽນຊື່ບັນຊີຜູ້ເບິ່ງແຍງລະບົບໄດ້';
$string['usernotrenamedexists'] = 'ຜູ້ໃຊ້ບໍ່ໄດ້ຖືກປ່ຽນຊື່ - ຊື່ຜູ້ໃຊ້ໃໝ່ຖືກໃຊ້ຢູ່ແລ້ວ';
$string['usernotrenamedmissing'] = 'ຜູ້ໃຊ້ບໍ່ໄດ້ຖືກປ່ຽນຊື່ - ບໍ່ສາມາດຊອກຫາຊື່ຜູ້ໃຊ້ເກົ່າ';
$string['usernotrenamedoff'] = 'ບໍ່ໄດ້ປ່ຽນຊື່ຜູ້ໃຊ້ - ບໍ່ອະນຸຍາດໃຫ້ປ່ຽນຊື່ໄດ້';
$string['usernotupdatedadmin'] = 'ບໍ່ສາມາດປັບປຸງບັນຊີຜູ້ເບິ່ງແຍງລະບົບໄດ້';
$string['usernotupdatederror'] = 'ຜູ້ໃຊ້ບໍ່ໄດ້ປັບປຸງ - ຜິດພາດ';
$string['usernotupdatednotexists'] = 'ບໍ່ໄດ້ປັບປຸງຜູ້ໃຊ້ - ບໍ່ມີຢູ່';
$string['userquotalimit'] = 'ທ່ານໄດ້ໃຊ້ໂຄຕ້າຮອດຂີດຈຳກັດແລ້ວ.';
$string['userselectortoomany'] = 'user_selector ໄດ້ຮັບຫຼາຍກວ່າໜຶ່ງຜູ້ໃຊ້ທີ່ເລືອກ, ເຖິງແມ່ນວ່າການເລືອກຫຼາຍອັນແມ່ນບໍ່ຖືກຕ້ອງ.';
$string['verifyagedigitalconsentnotpossible'] = 'ຂໍອະໄພ, ບໍ່ສາມາດຢັ້ງຢືນການຍິນຍອມເຫັນດີໃນຍຸກດີຈີຕອນໄດ້ໃນເວລານີ້.';
$string['wrongcall'] = 'ສະຄຣິບນີ້ເອີ້ນຜິດ';
$string['wrongcontextid'] = 'ລະຫັດປະຈຳຕົວບໍລິບົດບໍ່ຖືກຕ້ອງ (ບໍ່ສາມາດຊອກຫາມັນໄດ້)';
$string['wrongdestpath'] = 'ເສັ້ນທາງປາຍທາງຜິດ';
$string['wrongroleid'] = 'ລະຫັດປະຈຳຕົວໜ້າທີ່ບໍ່ຖືກຕ້ອງ!';
$string['wrongsourcebase'] = 'ຖານ URL ແຫຼ່ງທີ່ມາບໍ່ຖືກຕ້ອງ';
$string['wrongusernamepassword'] = 'ຜູ້ໃຊ້/ລະຫັດຜ່ານຜິດ';
$string['wrongzipfilename'] = 'ຊື່ໄຟລ໌ ZIP ບໍ່ຖືກຕ້ອງ';
$string['wscouldnotcreateecoursenopermission'] = 'WS - ບໍ່ສາມາດສ້າງລາຍວິຊາໄດ້ - ບໍ່ມີການອະນຸຍາດ';
$string['wwwrootmismatch'] = 'ກວດພົບການເຂົ້າເຖິງທີ່ບໍ່ຖືກຕ້ອງ, ເຊີບເວີນີ້ອາດຈະເຂົ້າເຖິງໄດ້ສະເພາະຜ່ານທີ່ຢູ່ "{$a}", ຂໍອະໄພ.<br />ກະລຸນາແຈ້ງຜູ້ຄວບຄຸມເຊີບເວີ.';
$string['wwwrootslash'] = 'ກວດພົບ $CFG-> wwwroot ທີ່ບໍ່ຖືກຕ້ອງຢູ່ໃນ config.php, ມັນຈະຕ້ອງບໍ່ມີເຄື່ອງໝາຍທັບຢູ່ທາງຫຼັງ.<br />ກະລຸນາແຈ້ງຜູ້ຄວບຄຸມເຊີບເວີ.';
$string['xmldberror'] = 'XMLDB ຜິດພາດ!';
$string['youcannotdeletecategory'] = 'ທ່ານບໍ່ສາມາດລຶບປະເພດ \'{$a}\' ໄດ້ເພາະວ່າທ່ານບໍ່ສາມາດລຶບເນື້ອຫາໄດ້, ຫຼືຍ້າຍພວກມັນໄປບ່ອນອື່ນ.';
