<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'wiki', language 'lo', version '4.4'.
 *
 * @package     wiki
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addcomment'] = 'ເພີ່ມຄຳເຫັນ';
$string['addedbegins'] = 'ເລີ່ມການເພີ່ມແລ້ວ';
$string['addedends'] = 'ສິ້ນສຸດການເພີ່ມແລ້ວ';
$string['admin'] = 'ການບໍລິຫານ';
$string['adminmenu'] = 'ເມນູຜູ້ບໍລິຫານ';
$string['attachmentattach'] = 'ເພີ່ມເປັນເອກະສານຊ້ອນທ້າຍ';
$string['attachmentimage'] = 'ເພີ່ມເປັນຮູບພາບ';
$string['attachmentlink'] = 'ເພີ່ມເປັນລິ້ງ';
$string['attachments'] = 'ເອກະສານຊ້ອນທ້າຍ';
$string['backcomments'] = 'ກັບໄປຫາຄຳເຫັນ';
$string['backhistory'] = 'ກັບໄປຫາປະຫວັດ';
$string['backoldversion'] = 'ກັບໄປຫາສະບັບເກົ່າ';
$string['backpage'] = 'ກັບໄປຫາໜ້າ';
$string['backtomapmenu'] = 'ກັບໄປຫາເມນູແຜນທີ່';
$string['cannotcomparenewerversion'] = 'ສະບັບໜ້າສາມາດປຽບທຽບກັບເວີຊັນເກົ່າກວ່າເທົ່ານັ້ນ.';
$string['cannoteditpage'] = 'ທ່ານສາມາດແກ້ໄຂໜ້ານີ້.';
$string['cannotmanagefiles'] = 'ທ່ານບໍ່ໄດ້ຮັບອະນຸຍາດໃນການຈັດການໄຟລ໌ wiki';
$string['cannotviewfiles'] = 'ທ່ານບໍ່ໄດ້ຮັບອະນຸຍາດໃຫ້ເບິ່ງໄຟລ໌ wiki';
$string['cannotviewpage'] = 'ທ່ານບໍ່ສາມາດເບິ່ງໜ້ານີ້.';
$string['changerate'] = 'ທ່ານຕ້ອງການປ່ຽນມັນບໍ?';
$string['comments'] = 'ຄຳເຫັນ';
$string['commentscount'] = 'ຄຳເຫັນ ({$a})';
$string['comparesel'] = 'ການສົມທຽບທີ່ໄດ້ເລືອກ';
$string['comparewith'] = 'ສະບັບການສົມທຽບ {$a->old} ກັບສະບັບ {$a->new}';
$string['contributions'] = 'ການປະກອບສ່ວນ';
$string['contributions_help'] = 'ລາຍການໜ້າທີ່ທ່ານໄດ້ແກ້ໄຂ.';
$string['createcomment'] = 'ກຳລັງສ້າງຄຳເຫັນ';
$string['createddate'] = 'ໄດ້ສ້າງ: {$a->date} by {$a->username}';
$string['createpage'] = 'ສ້າງໜ້າ';
$string['creating'] = 'ສ້າງໜ້າ wiki';
$string['creole'] = 'ເຄຼໂອ (Creole)';
$string['defaultformat'] = 'ຮູບແບບມາດຕະຖານ';
$string['defaultformat_help'] = 'ການຕັ້ງຄ່ານີ້ກຳນົດຮູບແບບເລີ່ມຕົ້ນທີ່ໃຊ້ໃນເວລາແກ້ໄຂໜ້າ wiki.

* HTML - ຕົວແກ້ໄຂ HTML ສາມາດໃຊ້ໄດ້
* Creole - ພາສາເຄື່ອງໝາຍ wiki ທົ່ວໄປທີ່ແຖບເຄື່ອງມືແກ້ໄຂຂະໜາດນ້ອຍສາມາດໃຊ້ໄດ້
* Nwiki - ພາສາເຄື່ອງໝາຍຄ້າຍຄື Mediawiki ທີ່ໃຊ້ໃນໂມດູນ Nwiki ທີ່ປະກອບສ່ວນ';
$string['deleteallpages'] = 'ລຶບໜ້າ wiki ທັງໝົດ';
$string['deletecomment'] = 'ກຳລັງລຶບຄຳເຫັນ';
$string['deletecommentcheck'] = 'ລຶບຄຳເຫັນ';
$string['deletecommentcheckfull'] = 'ທ່ານແນ່ໃຈບໍ່ວ່າທ່ານຕ້ອງການລຶບຄຳເຫັນ?';
$string['deletedbegins'] = 'ເລີ່ມການລຶບແລ້ວ';
$string['deletedends'] = 'ສິ້ນສຸດການລຶບແລ້ວ';
$string['deleteupload'] = 'ລຶບ';
$string['deleteversions'] = 'ລຶບສະບັບໜ້າ';
$string['diff'] = 'ສ່ວນຕ່າງ';
$string['diff_help'] = 'ສະບັບທີ່ເລືອກຂອງໜ້າອາດຈະຖືກປຽບທຽບເພື່ອຊອກຫາຄວາມແຕກຕ່າງ.';
$string['edit'] = 'ແກ້ໄຂ';
$string['editblocks'] = 'ເປີດບລັອກການແກ້ໄຂ';
$string['editcomment'] = 'ແກ້ໄຂຄຳເຫັນ';
$string['editfiles'] = 'ແກ້ໄຂໄຟລ໌ wiki';
$string['editing'] = 'ກຳລັງແກ້ໄຂໄຟລ໌ wiki';
$string['editingcomment'] = 'ກຳລັງແກ້ໄຂຄຳເຫັນ';
$string['editingpage'] = 'ກຳລັງແກ້ໄຂໜ້າ \'{$a}\' ນີ້';
$string['editsection'] = 'ແກ້ໄຂ';
$string['eventdiffviewed'] = 'ເບິ່ງຄວາມແຕກຕ່າງ Wiki ແລ້ວ';
$string['eventhistoryviewed'] = 'ເບິ່ງປະຫວັດ Wiki ແລ້ວ';
$string['eventmapviewed'] = 'ເບິ່ງໜ້າແຜນທີ່ Wiki ແລ້ວ';
$string['eventpagecreated'] = 'ສ້າງໜ້າ Wiki ແລ້ວ';
$string['eventpagedeleted'] = 'ລຶບໜ້າ Wiki ແລ້ວ';
$string['eventpagelocksdeleted'] = 'ລຶບໜ້າລັອກ Wiki ແລ້ວ';
$string['eventpageupdated'] = 'ປັບປຸງໜ້າ Wiki ແລ້ວ';
$string['eventpageversiondeleted'] = 'ປັບສະບັບໜ້າ Wiki ແລ້ວ';
$string['eventpageviewed'] = 'ເບິ່ງໜ້າ Wiki ແລ້ວ';
$string['eventversionrestored'] = 'ກູ້ຄືນສະບັບ Wiki ແລ້ວ';
$string['eventversionviewed'] = 'ເບິ່ງສະບັບ Wiki ແລ້ວ';
$string['filenotuploadederror'] = 'ໄຟລ໌ \'{$a}\' ບໍ່ສາມາດອັບໂຫຼດຢ່າງຖືກຕ້ອງ.';
$string['files'] = 'ໄຟລ໌';
$string['filtername'] = 'ເຊື່ອມຕໍ່ Wiki ອັດຕະໂນມັດ';
$string['firstpagetitle'] = 'ຊື່ໜ້າທຳອິດ';
$string['firstpagetitle_help'] = 'ຫົວຂໍ້ຂອງໜ້າເວັບທໍາອິດຂອງ wiki. ເມື່ອ wiki ຖືກສ້າງຂຶ້ນ, ຫົວຂໍ້ບໍ່ສາມາດຖືກປ່ຽນແປງໄດ້.';
$string['forceformat'] = 'ຮູບແບບບັງຄັບ';
$string['forceformat_help'] = 'ຖ້າຮູບແບບຖືກບັງຄັບ (ຖືກໝາຍຖືກໃສ່ກ່ອງກາເຄື່ອງໝາຍ), ບໍ່ມີທາງເລືອກທີ່ຈະເລືອກຮູບແບບໃນເວລາທີ່ດັດແກ້ໜາ wiki.';
$string['format'] = 'ຮູບແບບ';
$string['format_help'] = '* HTML - ຕົວແກ້ໄຂ HTML ສາມາດໃຊ້ໄດ້
* Creole - ພາສາເຄື່ອງໝາຍ wiki ທົ່ວໄປທີ່ແຖບເຄື່ອງມືແກ້ໄຂຂະໜາດນ້ອຍສາມາດໃຊ້ໄດ້
* Nwiki - ພາສາເຄື່ອງໝາຍຄ້າຍຄື Mediawiki ທີ່ໃຊ້ໃນໂມດູນ Nwiki ທີ່ປະກອບສ່ວນ';
$string['formatcreole'] = 'ຮູບແບບເຄຼໂອ';
$string['formatcreole_help'] = 'Creole ເປັນພາສາເຄື່ອງໝາຍ wiki ທົ່ວໄປທີ່ມີແຖບເຄື່ອງມືແກ້ໄຂສໍາລັບການໃສ່ເຄື່ອງໝາຍທີ່ເຫມາະສົມ.

ເພື່ອສ້າງໜ້າໃໝ່, ພິມຊື່ໜ້າໃໝ່ທີ່ຕິດຢູ່ໃນວົງເລັບຫຼ່ຽມສອງເທົ່າ, ຕົວຢ່າງ: [[ຫນ້າ 2]].';
$string['formatcreole_link'] = 'mod/wiki/creole';
$string['formathtml'] = 'ຮູບແບບ HTML';
$string['formathtml_help'] = 'ຕົວແກ້ໄຂ HTML ອາດຈະຖືກໃຊ້ສໍາລັບການຈັດຮູບແບບເນື້ອຫາ.

ເພື່ອສ້າງໜ້າໃໝ່, ພິມຊື່ໜ້າໃໝ່ທີ່ຕິດຢູ່ໃນວົງເລັບຫຼ່ຽມສອງເທົ່າ, ຕົວຢ່າງ: [[ຫນ້າ 2]].';
$string['formatnwiki'] = 'ຮູບແບບ NWiki';
$string['formatnwiki_help'] = 'Nwiki ແມ່ນພາສາເຄື່ອງໝາຍຄ້າຍຄື Mediawiki ທີ່ໃຊ້ໃນຊຸດ Nwiki ທີ່ປະກອບສ່ວນ.

ເພື່ອສ້າງໜ້າໃໝ່, ພິມຊື່ໜ້າໃໝ່ທີ່ຕິດຢູ່ໃນວົງເລັບຫຼ່ຽມສອງເທົ່າ, ຕົວຢ່າງ: [[ຫນ້າ 2]].';
$string['formatnwiki_link'] = 'mod/wiki/nwiki';
$string['history'] = 'ປະຫວັດ';
$string['history_help'] = 'ລິ້ງລາຍການປະຫວັດໄປຫາສະບັບກ່ອນໜ້າຂອງໜ້າ.';
$string['html'] = 'HTML';
$string['incorrectdeleteversions'] = 'ສະບັບໜ້າທີ່ໄດ້ໃຫ້ສຳລັບການລຶບແມ່ນບໍ່ຖືກຕ້ອງ.';
$string['incorrectpageid'] = 'ລະຫັດປະຈຳຕົວໜ້າແມ່ນບໍ່ຖືກຕ້ອງ.';
$string['incorrectsubwikiid'] = 'ລະຫັດປະຈຳຕົວ Subwiki ລະຫັດປະຈຳຕົວ';
$string['incorrectwikiid'] = 'ລະຫັດປະຈຳຕົວ Wiki ແມ່ນບໍ່ຖືກຕ້ອງ.';
$string['indicator:cognitivedepth'] = 'ຄວາມຮູ້ Wiki';
$string['indicator:cognitivedepth_help'] = 'ຕົວຊີ້ວັດນີ້ແມ່ນອີງໃສ່ຄວາມເລິກຂອງສະຕິປັນຍາບັນລຸໄດ້ໂດຍນັກຮຽນໃນກິດຈະກໍາ Wiki.';
$string['indicator:cognitivedepthdef'] = 'ຄວາມຮູ້ Wiki';
$string['indicator:cognitivedepthdef_help'] = 'ຜູ້ເຂົ້າຮ່ວມໄດ້ບັນລຸອັດຕາສ່ວນນີ້ຂອງການມີສ່ວນພົວພັນທາງດ້ານສະຕິປັນຍາທີ່ສະເໜີໃຫ້ໂດຍກິດຈະກໍາ Wiki ໃນລະຫວ່າງໄລຍະການວິເຄາະນີ້ (ລະດັບ = ບໍ່ມີການເບິ່ງ, ເບິ່ງ, ສົ່ງ)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'ສັງຄົມ Wiki';
$string['indicator:socialbreadth_help'] = 'ຕົວຊີ້ວັດນີ້ແມ່ນອີງໃສ່ຄວາມກວ້າງຂອງສັງຄົມທີ່ນັກຮຽນບັນລຸໄດ້ໃນກິດຈະກໍາ Wiki.';
$string['indicator:socialbreadthdef'] = 'ສັງຄົມ Wiki';
$string['indicator:socialbreadthdef_help'] = 'ຜູ້ເຂົ້າຮ່ວມໄດ້ບັນລຸອັດຕາສ່ວນນີ້ຂອງການມີສ່ວນຮ່ວມທາງສັງຄົມທີ່ສະເໜີໂດຍກິດຈະກໍາ Wiki ໃນລະຫວ່າງໄລຍະການວິເຄາະນີ້ (ລະດັບ = ບໍ່ມີການເຂົ້າຮ່ວມ, ຜູ້ເຂົ້າຮ່ວມຢ່າງດຽວ, ຜູ້ເຂົ້າຮ່ວມກັບຜູ້ອື່ນ)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['individualpagedoesnotexist'] = 'ບໍ່ມີໜ້າ wiki ສ່ວນບຸກຄົນ';
$string['insertcomment'] = 'ໃສ່ຄຳເຫັນ';
$string['insertimage'] = 'ໃສ່ຮູບພາບ...';
$string['insertimage_help'] = 'ບັນຊີລາຍຊື່ແບບເລື່ອນລົງນີ້ ຈະໃສ່ຮູບພາບໃສ່ຕົວແກ້ໄຂ wiki. ຖ້າທ່ານຕ້ອງການເພີ່ມຮູບພາບເພີ່ມເຕີມໃສ່ wiki, ກະລຸນາໃຊ້ແຖບ "ໄຟລ໌".';
$string['invalidlock'] = 'ໜ້ານີ້ໄດ້ຖືກລັອກໂດຍຜູ້ໃຊ້ຄົນອື່ນແລ້ວ.';
$string['invalidparameters'] = 'ໄດ້ໃຫ້ຕົວກຳນົດບໍ່ຖືກຕ້ອງ.';
$string['invalidsection'] = 'ພາກສ່ວນບໍ່ຖືກຕ້ອງ.';
$string['invalidsesskey'] = 'ຊ່ວງເວລາຂອງທ່ານເກືອບໝົດເວລາແລ້ວ. ກະລຸນາບັນທຶກການແກ້ໄຂຂອງທ່ານແລ້ວເຂົ້າສູ່ລະບົບອີກຄັ້ງ.';
$string['javascriptdisabledlocks'] = 'Javascript ຖືກປິດໃຊ້ງານຢູ່ໃນຕົວທ່ອງເວັບຂອງທ່ານ ແລະ ການລັອກບໍ່ເຮັດວຽກ. ການປ່ຽນແປງທີ່ທ່ານເຮັດອາດຈະບໍ່ຖືກບັນທຶກໄວ້ຢ່າງຖືກຕ້ອງ.';
$string['links'] = 'ລິ້ງ';
$string['listall'] = 'ທັງໝົດລາຍການ';
$string['listorphan'] = 'ລາຍການລູກກຳພ້າ';
$string['lockingajaxtimeout'] = 'ແກ້ໄຂໜ້າການລັອກ';
$string['lockingtimeout'] = 'ລັອກໝົດເວລາ';
$string['map'] = 'ແຜນທີ່';
$string['mapmenu'] = 'ເມນູແຜນທີ່';
$string['migrationfinished'] = 'ການໂອນຍ້າຍສຳເລັດແລ້ວ';
$string['migrationfinishednowikis'] = 'ການໂອນຍ້າຍສຳເລັດແລ້ວ, ບໍ່ມີ wikis ໄດ້ໂອນ';
$string['missingpages'] = 'ໜ້າບໍ່ມີເນື້ອຫາ';
$string['modified'] = 'ດັດແກ້';
$string['modulename'] = 'Wiki';
$string['modulename_help'] = 'ຊຸດກິດຈະກໍາ wiki ຊ່ວຍໃຫ້ຜູ້ເຂົ້າຮ່ວມສາມາດເພີ່ມ ແລະ ແກ້ໄຂການສະສົມຂອງໜ້າເວັບໄດ້. wiki ສາມາດເປັນການຮ່ວມມືກັນໄດ້, ໂດຍທຸກຄົນສາມາດແກ້ໄຂໄດ້, ຫຼື ບຸກຄົນ, ເຊິ່ງທຸກຄົນມີ wiki ຂອງຕົນເອງ ເຊິ່ງມີພຽງແຕ່ເຂົາເຈົ້າສາມາດແກ້ໄຂໄດ້.

ປະຫວັດຂອງສະບັບກ່ອນຫນ້າຂອງແຕ່ລະໜ້າໃນ wiki ແມ່ນເກັບຮັກສາໄວ້, ລາຍຊື່ການແກ້ໄຂທີ່ເຮັດໂດຍຜູ້ເຂົ້າຮ່ວມແຕ່ລະຄົນ.

Wikis ມີຫຼາຍການນໍາໃຊ້, ເຊັ່ນ:

* ສໍາລັບບັນທຶກການບັນຍາຍກຸ່ມ ຫຼື ຄູ່ມືການສຶກສາ
* ສໍາລັບສະມາຊິກຂອງຄະນະວິຊາທີ່ຈະວາງແຜນການເຮັດວຽກ ຫຼື ວາລະກອງປະຊຸມຮ່ວມກັນ
* ສໍາລັບນັກຮຽນທີ່ຈະຮ່ວມມືກັນຂຽນປຶ້ມອອນລາຍ, ການສ້າງເນື້ອຫາໃນຫົວຂໍ້ທີ່ຄູສອນຂອງເຂົາເຈົ້າກໍານົດ
* ສໍາລັບການເລົ່າເລື່ອງຮ່ວມກັນ ຫຼື ການສ້າງບົດກະວີ, ບ່ອນທີ່ຜູ້ເຂົ້າຮ່ວມແຕ່ລະຄົນຂຽນແຖວ ຫຼື ຄຳກອນ
* ເປັນວາລະສານສ່ວນບຸກຄົນສໍາລັບບົດບັນທຶກການກວດສອບ ຫຼື ການທົບທວນຄືນ (ການນໍາໃຊ້ wiki ສ່ວນບຸກຄົນ)';
$string['modulename_link'] = 'mod/wiki/view';
$string['modulenameplural'] = 'Wikis';
$string['navigation'] = 'ການນຳທາງ';
$string['navigationfrom'] = 'ໜ້ານີ້ມາຈາກ';
$string['navigationfrom_help'] = 'ຫນ້າ wiki ທີ່ເຊື່ອມຕໍ່ກັບໜ້ານີ້';
$string['navigationto'] = 'ໜ້ານີ້ໄປຫາ';
$string['navigationto_help'] = 'ລິ້ງໄປຫາໜ້າອື່ນ';
$string['newpage'] = 'ໃໝ່';
$string['newpagehdr'] = 'ໜ້າໃໝ່';
$string['newpagetitle'] = 'ຫົວຂໍ້ໜ້າໃໝ່';
$string['noattachments'] = '<strong>ບໍ່ມີໄຟລ໌ແນບມາ</strong>';
$string['nocomments'] = 'ບໍ່ມີຄຳເຫັນ';
$string['nocontent'] = 'ບໍ່ມີເນື້ອຫາສຳລັບໜ້ານີ້';
$string['nocontribs'] = 'ທ່ານບໍ່ມີການປະກອບສ່ວນໃນ wiki ນີ້';
$string['nocreatepermission'] = 'ສ້າງການອະນຸຍາດຫນ້າທີ່ຈໍາເປັນ';
$string['noeditcommentpermission'] = 'ແກ້ໄຂການອະນຸຍາດຄຳເຫັນທີ່ຈໍາເປັນ';
$string['noeditpermission'] = 'ແກ້ໄຂການອະນຸຍາດຫນ້າທີ່ຈໍາເປັນ';
$string['nofrompages'] = 'ບໍ່ມີລິ້ງໄປຫາໜ້ານີ້';
$string['nohistory'] = 'ບໍ່ມີປະຫວັດໄປຫາໜ້ານີ້';
$string['nomanagecommentpermission'] = 'ຈັດການການອະນຸຍາດຄຳເຫັນທີ່ຈໍາເປັນ';
$string['nomanagewikipermission'] = 'ຈັດການການອະນຸຍາດ wiki ທີ່ຈໍາເປັນ';
$string['noorphanedpages'] = 'ບໍ່ມີໜ້າລູກກຳພ້າ';
$string['nooverridelockpermission'] = 'ລົບລ້າງການອະນຸຍາດລັອກທີ່ຈໍາເປັນ';
$string['norated'] = 'ໜ້ານີ້ຍັງບໍ່ໄດ້ໃຫ້ຄະແນນເທື່ອ, ເປັນຜູ້ທຳອິດ!';
$string['norating'] = 'ບໍ່ມີການໃຫ້ຄະແນນ';
$string['nosearchresults'] = 'ບໍ່ມີຜົນໄດ້ຮັບ';
$string['noteditblocks'] = 'ປິດການແກ້ໄຂບລັອກ';
$string['notingroup'] = 'ບໍ່ຢູ່ໃນກຸ່ມ';
$string['notmigrated'] = 'wiki ນີ້ຍັງບໍ່ໄດ້ຖືກຍົກຍ້າຍເທື່ອ. ກະລຸນາຕິດຕໍ່ຜູ້ເບິ່ງແຍງລະບົບຂອງທ່ານ.';
$string['notopages'] = 'ໜ້ານີ້ບໍ່ໄດ້ເຊື່ອມຕໍ່ກັບໜ້າອື່ນ';
$string['noupdatedpages'] = 'ບໍ່ມີໜ້າທີ່ໄດ້ປັບປຸງ';
$string['noviewcommentpermission'] = 'ເບິ່ງການອະນຸຍາດຄຳເຫັນທີ່ຈຳເປັນ';
$string['noviewpagepermission'] = 'ເບິ່ງການອະນຸຍາດໜ້າທີ່ຈຳເປັນ';
$string['nwiki'] = 'NWiki';
$string['oldversion'] = 'ສະບັບເກົ່າ';
$string['orphaned'] = 'ໜ້າລູກກຳພ້າ';
$string['orphaned_help'] = 'ບັນຊີລາຍຊື່ຂອງໜ້າທີ່ບໍ່ໄດ້ເຊື່ອມຕໍ່ຈາກໜ້າອື່ນ.';
$string['overridelocks'] = 'ລົບລ້າງລັອກ';
$string['overridinglocks'] = 'ກຳລັງລົບລ້າງລັອກ...';
$string['page-mod-wiki-comments'] = 'ໜ້າຄຳເຫັນຊຸດ Wiki';
$string['page-mod-wiki-history'] = 'ໜ້າປະຫວັດ Wiki';
$string['page-mod-wiki-map'] = 'ໜ້າແຜນທີ່ Wiki';
$string['page-mod-wiki-view'] = 'ໜ້າຫຼັກຊຸດ Wiki';
$string['page-mod-wiki-x'] = 'ໜ້າຊຸດ Wiki ໃດໜຶ່ງ';
$string['pageexists'] = 'ໜ້ານີ້ມີຢູ່ແລ້ວ';
$string['pageindex'] = 'ໜ້າດັດສະນີ';
$string['pageindex_help'] = 'ຕົ້ນໄມ້ໜ້າຂອງ wiki ນີ້';
$string['pageislocked'] = 'ມີຄົນກຳລັງແກ້ໄຂໜ້ານີ້ຢູ່. ພະຍາຍາມແກ້ໄຂມັນໃນສອງສາມນາທີ.';
$string['pagelist'] = 'ລາຍການໜ້າ';
$string['pagelist_help'] = 'ລາຍຊື່ໜ້າຈັດປະເພດຕາມລຳດັບຕົວອັກສອນ';
$string['pagename'] = 'ຊື່ໜ້າ';
$string['peerreview'] = 'ທົບທວນຄືນໝູ່ເພື່ອ';
$string['pluginadministration'] = 'ການບໍລິຫານ Wiki';
$string['pluginname'] = 'Wiki';
$string['prettyprint'] = 'ລຸ້ນທີ່ເປັນມິດກັບເຄື່ອງພິມ';
$string['previewwarning'] = 'ນີ້ແມ່ນຕົວຢ່າງ. ບໍ່ໄດ້ບັນທຶກການປ່ຽນແປງເທື່ອ.';
$string['print'] = 'ພິມ';
$string['privacy:metadata:core_comment'] = 'ຄຳເຫັນເທິງໜ້າ wiki';
$string['privacy:metadata:core_files'] = 'ໄຟລ໌ແນບມາໄປຫາ subwikis';
$string['privacy:metadata:core_tag'] = 'ແທັກທີ່ກ່ຽວຂ້ອງກັບໜ້າ wiki';
$string['privacy:metadata:wiki_locks'] = 'ການເກັບຮັກສາຊົ່ວຄາວສໍາລັບການລັອກແກ້ໄຂ wiki';
$string['privacy:metadata:wiki_locks:lockedat'] = 'ວັນທີ່ເມື່ອໄດ້ລັອກ';
$string['privacy:metadata:wiki_locks:sectionname'] = 'ຊື່ຂອງພາກສ່ວນໜ້າທີ່ໄດ້ລັອກ';
$string['privacy:metadata:wiki_locks:userid'] = 'ຜູ້ໃຊ້ທີ່ໄດ້ລັອກໜ້າ';
$string['privacy:metadata:wiki_pages'] = 'ຂໍ້ມູນກ່ຽວກັບໜ້າ wiki';
$string['privacy:metadata:wiki_pages:cachedcontent'] = 'ແຄັກເນື້ອຫາໃນຮູບແບບ HTML';
$string['privacy:metadata:wiki_pages:pageviews'] = 'ຈຳນວນຄັ້ງທີ່ໜ້າຖືກເບິ່ງ';
$string['privacy:metadata:wiki_pages:readonly'] = 'ບໍ່ວ່າໜ້າໃດໜຶ່ງແມ່ນອ່ານເທົ່ານັ້ນ';
$string['privacy:metadata:wiki_pages:timecreated'] = 'ເວລາທີ່ໜ້າຖືກສ້າງຄັ້ງທຳອິດ';
$string['privacy:metadata:wiki_pages:timemodified'] = 'ເວລາທີ່ໜ້າຖືກດັດແປງຄັ້ງສຸດທ້າຍ';
$string['privacy:metadata:wiki_pages:timerendered'] = 'ເວລາທີ່ໜ້າຖືກສະແດງຄັ້ງສຸດທ້າຍ';
$string['privacy:metadata:wiki_pages:title'] = 'ຊື່ຂອງໜ້າ';
$string['privacy:metadata:wiki_pages:userid'] = 'ຜູ້ໃຊ້ສຸດທ້າຍທີ່ແກ້ໄຂໜ້າ';
$string['privacy:metadata:wiki_subwikis'] = 'ຂໍ້ມູນກ່ຽວກັບ subwikis (ໃນກໍລະນີຂອງຮູບແບບກຸ່ມ ຫຼື ບຸກຄົນ)';
$string['privacy:metadata:wiki_subwikis:groupid'] = 'ກຸ່ມທີ່ເປັນເຈົ້າຂອງ subwiki';
$string['privacy:metadata:wiki_subwikis:userid'] = 'ຜູ້ໃຊ້ທີ່ເປັນເຈົ້າຂອງ subwiki (ສໍາລັບແຕ່ລະ wikis)';
$string['privacy:metadata:wiki_versions'] = 'ຂໍ້ມູນກ່ຽວກັບປະຫວັດຂອງຫນ້າ wiki';
$string['privacy:metadata:wiki_versions:content'] = 'ເນື້ອໃນການກວດແກ້';
$string['privacy:metadata:wiki_versions:contentformat'] = 'ຮູບແບບເນື້ອໃນການກວດແກ້';
$string['privacy:metadata:wiki_versions:timecreated'] = 'ເວລາທີ່ການດັດແກ້ໄດ້ຖືກສ້າງຂື້ນ';
$string['privacy:metadata:wiki_versions:userid'] = 'ຜູ້ໃຊ້ທີ່ໄດ້ສ້າງການກວດແກ້';
$string['privacy:metadata:wiki_versions:version'] = 'ໝາຍເລກສະບັບ';
$string['rated'] = 'ທ່ານໃຫ້ຄະແນນໜ້ານີ້ເປັນ {$a}';
$string['rating'] = 'ໃຫ້ຄະແນນ';
$string['ratingmode'] = 'ໂໝດໃຫ້ຄະແນນ';
$string['removeallwikitags'] = 'ເອົາໜ້າ wiki ທັງໝົດອອກ';
$string['removepages'] = 'ເອົາໜ້າອອກ';
$string['reparsetimeout'] = 'ກຳລັງສ້ອມແປງການໝົດເວລາເລີ່ມຕົ້ນ';
$string['repeatedsection'] = 'Wiki ຜິດພາດ: ຊື່ພາກສ່ວນບໍ່ສາມາດຊ້ຳກັນໄດ້ \'{$a}\'';
$string['restore'] = 'ຟື້ນຟູ';
$string['restoreconfirm'] = 'ທ່ານແນ່ໃຈບໍ່ວ່າທ່ານຕ້ອງການກູ້ສະບັບ #{$a}?';
$string['restoreerror'] = 'ບໍ່ສາມາດກູ້ສະບັບ #{$a} ໄດ້';
$string['restorethis'] = 'ຟື້ນຟູສະບັບນີ້';
$string['restoreversion'] = 'ຟື້ນຟູສະບັບເກົ່າ';
$string['restoring'] = 'ຟື້ນຟູສະບັບ #{$a}';
$string['return'] = 'ກັບຄືນ';
$string['save'] = 'ບັນທຶກ';
$string['saving'] = 'ກຳລັງບັນທຶກໜ້າ wiki';
$string['savingerror'] = 'ການບັນທຶກຜິດພາດ';
$string['search:activity'] = 'Wiki - ຂໍ້ມູນກິດຈະກຳ';
$string['search:collaborative_page'] = 'Wiki - ໜ້າການຮ່ວມມື';
$string['searchcontent'] = 'ຄົ້ນຫາໃນໜ້າເນື້ອຫາ';
$string['searchresult'] = 'ຜົນໄດ້ຮັບການຄົ້ນຫາ:';
$string['searchterms'] = 'ຂໍ້ກຳນົດການຄົ້ນຫາ';
$string['searchwikis'] = 'ຄົ້ນຫາ wikis';
$string['special'] = 'ພິເສດ';
$string['tableofcontents'] = 'ສາລະບານ';
$string['tagarea_wiki_pages'] = 'ໜ້າ Wikis';
$string['tagsdeleted'] = 'ລຶບແທັກ Wikis ແລ້ວ';
$string['teacherrating'] = 'ໃຫ້ຄະແນນຄູສອນ';
$string['timesrating'] = 'ໜ້ານີ້ຖືກຈັດອັນດັບ {$a->c} ເທື່ອໂດຍສະເລ່ຍ: {$a->s}';
$string['updatedpages'] = 'ປັບປຸງໜ້າແລ້ວ';
$string['updatedpages_help'] = 'ປັບປຸງນ້າ wiki ແລ້ວໃນປະຈຸບັນ';
$string['updatedwikipages'] = 'ປັບປຸງນ້າ wiki ແລ້ວ';
$string['upload'] = 'ອັບໂຫຼດ ແລະ ລຶບ';
$string['uploadactions'] = 'ການປະຕິບັດ';
$string['uploadfiletitle'] = 'ເອກະສານຊ້ອນທ້າຍ';
$string['uploadname'] = 'ຊື່ໄຟລ໌';
$string['uploadtitle'] = 'ໄຟລ໌ແນບ';
$string['version'] = 'ສະບັບ';
$string['versionerror'] = 'ບໍ່ມີລະຫັດປະຈຳຕົວສະບັບ';
$string['versionnum'] = 'ສະບັບ #{$a}';
$string['view'] = 'ເບິ່ງ';
$string['viewallhistory'] = 'ເບິ່ງປະຫວັດທັງໝົດ';
$string['viewcurrent'] = 'ສະບັບປະຈຸບັນ';
$string['viewperpage'] = 'ສະແດງສະບັບ {$a} ຕໍ່ໜ້າ';
$string['viewversion'] = 'ສະແດງສະບັບໜ້າ #{$a}';
$string['wiki'] = 'Wiki';
$string['wiki:addinstance'] = 'ເພີ່ມ wiki ໃໝ່';
$string['wiki:createpage'] = 'ສ້າງເພີ່ມ wiki ໃໝ່';
$string['wiki:editcomment'] = 'ເພີ່ມຄຳເຫັນໄປຫາໜ້າ';
$string['wiki:editpage'] = 'ແກ້ໄຂໜ້າ wiki';
$string['wiki:managecomment'] = 'ຈັດການຄຳເຫັນ wiki';
$string['wiki:managefiles'] = 'ຈັດການໄຟລ໌ wiki';
$string['wiki:managewiki'] = 'ຈັດການການຕັ້ງຄ່າ wiki';
$string['wiki:overridelock'] = 'ລົບລ້າງລັອກ wiki';
$string['wiki:viewcomment'] = 'ເບິ່ງຄຳເຫັນໜ້າ';
$string['wiki:viewpage'] = 'ເບິ່ງໜ້າ wiki';
$string['wikiattachments'] = 'ເອກະສານຊ້ອນທ້າຍ wiki';
$string['wikiboldtext'] = 'ຕົວໜາ';
$string['wikiexternalurl'] = 'URL ພາຍນອກ';
$string['wikifiles'] = 'ໄຟລ໌ Wiki';
$string['wikifiletable'] = 'ອັບໂຫຼດລາຍການໄຟລ໌ແລ້ວ';
$string['wikiheader'] = 'ລະດັບ {$a} ສ່ວນຫົວ';
$string['wikihr'] = 'ກົດລະບຽບແນວນອນ';
$string['wikiimage'] = 'ຮູບພາບ';
$string['wikiinternalurl'] = 'ລິ້ງພາຍໃນ';
$string['wikiintro'] = 'ຄຳອະທິບາຍ';
$string['wikiitalictext'] = 'ຕົວອຽງ';
$string['wikilockingsettings'] = 'ການລັອກ ແລະ ການສ້ອມແປງໝົດເວລາ';
$string['wikimode'] = 'ໂໝດ Wiki';
$string['wikimode_help'] = 'ຮູບແບບ wiki ກໍານົດວ່າ ທຸກຄົນສາມາດແກ້ໄຂ wiki - wiki ຮ່ວມມື - ຫຼື ວ່າທຸກຄົນມີ wiki ຂອງຕົນເອງທີ່ມີພຽງແຕ່ເຂົາເຈົ້າສາມາດແກ້ໄຂໄດ້ - wiki ສ່ວນບຸກຄົນ.';
$string['wikimodecollaborative'] = 'wiki ການຮ່ວມມື';
$string['wikimodeindividual'] = 'wiki ສ່ວນບຸກຄົນ';
$string['wikiname'] = 'ຊື່ wiki';
$string['wikinowikitext'] = 'ບໍ່ມີຂໍ້ຄວາມ wiki';
$string['wikiorderedlist'] = 'ລາຍການເປັນລະບຽບ';
$string['wikipages'] = 'ໜ້າ Wiki';
$string['wikisettings'] = 'ການຕັ້ງຄ່າ Wiki';
$string['wikiunorderedlist'] = 'ລາຍການບໍ່ເປັນລະບຽບ';
$string['wrongversionlock'] = 'ຜູ້ໃຊ້ອື່ນໄດ້ດັດແກ້ໜ້ານີ້ໃນຂະນະທີ່ທ່ານກໍາລັງດັດແກ້ ແລະ ເນື້ອຫາຂອງທ່ານແມ່ນລ້າສະໄຫມ.';
$string['wrongversionsave'] = 'ຜູ້ໃຊ້ອື່ນໄດ້ສ້າງສະບັບໃນຂະນະທີ່ທ່ານກໍາລັງແກ້ໄຂ ແລະ ທ່ານໄດ້ຂຽນທັບການປ່ຽນແປງຂອງລາວ, ກວດເບິ່ງປະຫວັດໜ້າ.';
