<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'admin', language 'ja', version '5.0'.
 *
 * @package     admin
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessdenied'] = 'アクセスが拒否されました。';
$string['accountlocked'] = 'あなたのアカウントがロックされました。ロック解除リンクがメール送信されました。';
$string['accounts'] = 'アカウント';
$string['accountunlocked'] = 'あなたのアカウントがロック解除されました。あなたはログインできます。';
$string['addcategory'] = 'カテゴリを追加する';
$string['additionalhtml'] = '追加HTML';
$string['additionalhtml_desc'] = 'これらの設定ではあなたがすべてのページに追加したいHTMLを指定することができます。あなたはページのHEADタグ内、BODYタグが開かれた直後、またはBODYタグが閉じられる直前にHTMLを設定することができます。<br />この設定により、すべてのページにカスタムヘッダおよびフッタを追加またはGoogle Analyticsのようなサービスのサポートをあなたが選択したテーマから独立して簡単に追加することができます。';
$string['additionalhtml_heading'] = 'すべてのページに追加される追加HTMLです。';
$string['additionalhtmlfooter'] = 'BODYタグが閉じられる前';
$string['additionalhtmlfooter_desc'] = 'このコンテンツはすべてのページのBODYタグが閉じられる直前に追加されます。';
$string['additionalhtmlhead'] = 'HEADタグ内';
$string['additionalhtmlhead_desc'] = 'このコンテンツはすべてのページのHEADタグの最後に追加されます。';
$string['additionalhtmltopofbody'] = 'BODYタグが開かれた時';
$string['additionalhtmltopofbody_desc'] = 'このコンテンツはすべてのページのBODYタグが開かれた直後に追加されます。';
$string['admincategory'] = 'カテゴリ: {$a}';
$string['adminseesall'] = '管理者にすべてを表示する';
$string['adminseesallevents'] = '管理者にすべてのイベントを表示する';
$string['adminseesownevents'] = '管理者は他のユーザと同じ';
$string['advancedfeatures'] = '拡張機能';
$string['agedigitalconsentverification'] = 'デジタル許可年齢確認';
$string['agedigitalconsentverification_desc'] = '自己登録ユーザのサインアップページが表示される前にデジタル許可年齢の確認を有効にします。これはあなたのサイトに未成年が保護者の同意なしに登録することを防ぎます。さらなる支援のため<a target="_blank" href="{$a}">サポート連絡先</a>詳細が提供されます。';
$string['ageofdigitalconsentmap'] = 'デジタル許可年齢';
$string['ageofdigitalconsentmap_desc'] = 'デフォルトのデジタル許可年齢および年齢が異なる場合、すべての国においてここで指定することができます。新しい年齢の行を次のフォーマットで入力してください: 国コード, 年齢 (カンマ区切り)。デフォルトの年齢は国コードの代わりに「*」が表示されています。国コードはISO 3166-2で指定されています。';
$string['allcountrycodes'] = 'すべての国コード';
$string['allowattachments'] = '添付を許可する';
$string['allowbeforeblock'] = '最初に「許可されるIPアドレスリスト」を参照する';
$string['allowbeforeblockdesc'] = 'デフォルトでは「ブロックされるIPアドレスリスト」が最初に参照されます。このオプションが有効にされた場合、「ブロックされるIPアドレスリスト」の前に「許可されるIPアドレスリスト」が参照されます。';
$string['allowcategorythemes'] = 'カテゴリテーマを許可する';
$string['allowcohortthemes'] = 'コーホートテーマを許可する';
$string['allowcoursethemes'] = 'コーステーマを許可する';
$string['allowedemaildomains'] = '許可されたメールドメイン';
$string['allowediplist'] = '許可されるIPアドレスリスト';
$string['allowemailaddresses'] = '許可されるメールアドレスのドメイン';
$string['allowemojipicker'] = '絵文字ピッカ';
$string['allowframembedding'] = 'フレーム内埋め込みを許可する';
$string['allowframembedding_help'] = 'この設定を有効にした場合、「LTIツールとして公開する」登録プラグイン使用時に推奨されるようにこのサイトをリモートシステム内のフレームに埋め込むことができます。そうでない場合、セキュリティ上の理由からフレーム埋め込みを無効のままにすることをお勧めします。モバイルアプリの場合、この設定が無視されること、フレーム埋め込みが常に有効にされることにも留意してください。';
$string['allowguestmymoodle'] = 'ダッシュボードへのゲストアクセスを許可する';
$string['allowindexing'] = 'サーチエンジンによるインデックス化を許可する';
$string['allowindexing_desc'] = 'ここではあなたのサイトをサーチエンジンがインデックス化できるかどうか指定します。「どこでも」はログインおよびサインアップページを含むどこでもサーチエンジンによるインデックス化を許可します。これは強制ログインが有効にされていたとしてもインデックス化されることを意味します。サインアップページを検索できることを含むスパムのリスクを防ぐには「ログインおよびサインアップページを除くどこでも」を使用してください。「なし」はどのページもサーチエンジンにインデックス化しないよう指示します。これはサイトのヘッダ内タグのみであるため、サーチエンジンによるタグの尊重に依存することに留意してください。';
$string['allowindexingeverywhere'] = 'どこでも';
$string['allowindexingexceptlogin'] = 'ログインおよびサインアップページを除くどこでも';
$string['allowindexingnowhere'] = 'なし';
$string['allowobjectembed'] = 'EMBEDおよびOBJECTタグを許可する';
$string['allowthemechangeonurl'] = 'テーマ変更URLを許可する';
$string['allowuserblockhiding'] = 'ユーザのブロック非表示を許可する';
$string['allowusermailcharset'] = 'ユーザの文字セット選択を許可する';
$string['allowuserswitchrolestheycantassign'] = '「ユーザにロールを割り当てる」ケイパビリティのないユーザにロールのスイッチを許可する';
$string['allowuserthemes'] = 'ユーザテーマを許可する';
$string['alternativefullnameformat'] = '代替フルネームフォーマット';
$string['alternativefullnameformat_desc'] = 'ここでは「viewfullnames」ケイパビリティ  (デフォルトではマネージャ、教師または編集権限のない教師ロール) のユーザに名前がどのように表示されるか定義します。「フルネームフォーマット」のプレースホルダを使用することができます。';
$string['always'] = '常に';
$string['appearance'] = 'アピアランス';
$string['aspellpath'] = 'aspellのパス';
$string['asyncbackupdisabled'] = 'あなたのサイトは現在、同期バックアップを使用するよう設定されています。非同期バックアップはより良いユーザエクスペリエンスを提供します。ユーザはバックアップまたはリストアの進行中に他の操作を実行できます。非同期バックアップはMoodle 4.5 LTSからすべてのサイトで有効になります。同期バックアップはMoodle LMS 4.5 LTS以降のバージョンから削除されます。';
$string['authentication'] = '認証';
$string['authpreventaccountcreation'] = 'ユーザ認証時のアカウント作成を抑制する';
$string['authpreventaccountcreation_help'] = 'ユーザ認証時にまだユーザアカウントが存在しない場合、アカウントが自動的に作成されます。LDAPのような外部データベースを認証に使用して存在するアカウントにのみサイトアクセスを制限したい場合、このオプションを有効にしてください。新しいアカウントは手動で作成するかユーザアップロード機能を使用して作成する必要があります。この設定はMNet認証には適用されないことに留意してください。';
$string['authsettings'] = '認証管理';
$string['autolang'] = '言語の自動認識';
$string['autolangusercreation'] = 'アカウント作成時、ユーザの優先言語からブラウザの言語を設定する';
$string['autologinguests'] = 'ゲストの自動ログイン';
$string['availableto'] = '利用可能';
$string['availabletoanyone'] = 'サイト訪問者の誰でも利用可能';
$string['availabletoauthenticated'] = '認証済みユーザに制限する';
$string['backgroundcolour'] = '透過色';
$string['backup_shortname'] = 'バックアップファイル名にコース名を使用する';
$string['backup_shortnamehelp'] = 'コース名をバックアップファイル名の一部として使用します。';
$string['backups'] = 'バックアップ';
$string['badwordsconfig'] = 'あなたの使用禁止用語をカンマで区切って入力してください。';
$string['badwordsdefault'] = 'カスタムリストが空白の場合、言語パックからデフォルトリストが使用されます。';
$string['badwordslist'] = 'カスタム使用禁止用語リスト';
$string['blockediplist'] = 'ブロックされるIPアドレスリスト';
$string['blockinstances'] = 'インスタンス';
$string['blockmultiple'] = '複数設置';
$string['blockprotect'] = 'インスタンスを保護する';
$string['blockprotect_help'] = 'あなたが特定のタイプのブロックをロックした場合、誰もインスタンスを追加または削除できなくなります (もちろん、あなたはできますが、インスタンス編集する場合はロック解除してください)。

これは主に間違って削除された場合に元に戻すことが難しいナビゲーションおよび設定ブロックを保護することを目的としています。';
$string['blockprotectblock'] = '{$a} のインスタンスを保護する';
$string['blockprotected'] = '{$a} ブロックインスタンスが保護されました。';
$string['blocksettings'] = 'ブロックを管理する';
$string['blockunprotectblock'] = '{$a} のインスタンス保護を解除する';
$string['blockunprotected'] = '{$a} ブロックインスタンスが保護されなくなりました。';
$string['bloglevel'] = 'ブログ可視性';
$string['bookmarkadded'] = 'ブックマークが追加されました。';
$string['bookmarkalreadyexists'] = 'あなたはすでにこのページをブックマークしています。';
$string['bookmarkdeleted'] = 'ブックマークが削除されました。';
$string['bookmarkthispage'] = 'このページをブックマークする';
$string['cacheapplication'] = 'アプリケーションキャッシュ';
$string['cacheapplicationhelp'] = 'キャッシュアイテムはすべてのユーザで共有され、指定された生存時間 (TTL) で有効期限が切れます。';
$string['cachejs'] = 'JavaScriptをキャッシュする';
$string['cachejs_help'] = 'JavaScriptキャッシングおよび圧縮によりページ読み込みのパフォーマンスが大幅に向上します。実運用サイトでの適用を強くお勧めします。開発者は恐らくこの機能を無効にしても良いでしょう。';
$string['cacherequest'] = 'リクエストキャッシュ';
$string['cacherequesthelp'] = 'リクエスト完了時に有効期限が切れるユーザ固有のキャッシュです。私たちが使用している静的保存エリアの置換を目的とします。';
$string['cachesession'] = 'セッションキャッシュ';
$string['cachesessionhelp'] = 'ユーザ固有キャッシュはユーザセッション終了時に有効期限切れとなります。セッション負荷を軽減することを目的としています。';
$string['cachesettings'] = 'キャッシュ設定';
$string['cachetemplates'] = 'キャッシュテンプレート';
$string['cachetemplates_help'] = 'テンプレートキャッシングはページ読み込みのパフォーマンスを改善するため、実運用サイトへの適用を強くお勧めします。恐らく、開発者はこの機能を無効にしても良いでしょう。';
$string['caching'] = 'キャッシング';
$string['calendar_weekend'] = '週末日';
$string['calendarexportsalt'] = 'カレンダーエクスポートsalt';
$string['calendarsettings'] = 'カレンダー';
$string['calendartype'] = 'カレンダータイプ';
$string['calendartype_desc'] = 'サイト全体のカレンダータイプを選択してください。この設定はコース設定またはユーザ個人のプロファイルでオーバーライドすることができます。';
$string['campaign'] = 'キャンペーン';
$string['cannotdeletemodfilter'] = '「 {$a->module} 」モジュールの一部のため、あなたは「 {$a->filter} 」をアンインストールできません。';
$string['cannotuninstall'] = '{$a} をアンインストールすることはできません。';
$string['categoryemail'] = 'メール';
$string['cfgwwwrootslashwarning'] = 'あなたはconfig.phpファイルの$CFG->wwwrootを正しく定義していません。末尾に「/」文字が含まれています。「/」文字を取り除いてください。';
$string['cfgwwwrootwarning'] = 'あなたはconfig.phpファイルの$CFG->wwwrootを正しく定義していません。あなたがこのページにアクセスしているURLに合致する必要があります。';
$string['change'] = '変更';
$string['checkboxno'] = 'No';
$string['checkboxyes'] = 'Yes';
$string['checkupgradepending'] = 'アップグレード';
$string['choosefiletoedit'] = '編集するファイルを選択してください。';
$string['cleanup'] = 'クリーンアップ';
$string['clianswerno'] = 'n';
$string['cliansweryes'] = 'y';
$string['cliexitgraceful'] = '丁寧に終了しています、しばらくお待ちください ...';
$string['cliexitnow'] = 'すぐに終了する';
$string['cliincorrectvalueerror'] = 'エラー: 「 {$a->option} 」の値「 {$a->value} 」が正しくありません。';
$string['cliincorrectvalueretry'] = '値が正しくありません、再度入力してください。';
$string['clistatusdisabled'] = 'ステータス: 無効';
$string['clistatusenabled'] = 'ステータス: 有効';
$string['clistatusenabledlater'] = 'ステータス: CLIメンテナンスモードは {$a} に有効にされます。';
$string['clitypevalue'] = '値を入力してください。';
$string['clitypevaluedefault'] = '値を入力してください。デフォルト値 ({$a}) を使用するにはEnterキーを押してください。';
$string['cliunknowoption'] = '不明なオプション:
{$a}
「--help」オプションを使用してください。';
$string['cliupgradecompletenomaintenanceupgrade'] = 'ユーザトラフィックの新しいコードへの移行後に既存のキャッシュをパージするには:

  php admin/cli/purge_caches.php --muc
  php admin/cli/purge_caches.php --js
  php admin/cli/purge_caches.php --filter
  php admin/cli/purge_caches.php --other

あなたはWebサーバの負荷スパイクを軽減するためにこれらのパージをコマンドとコマンドの間に間隔を空けて単独実行する必要があります。';
$string['cliupgradedefault'] = '新しい設定: {$a}';
$string['cliupgradedefaultheading'] = '新しいデフォルト値の設定';
$string['cliupgradedefaultverbose'] = '新しい設定: {$a->name} / デフォルト値: {$a->defaultsetting}';
$string['cliupgradefinished'] = 'コマンドラインによる {$a->oldversion} から {$a->newversion} へのアップグレードが正常に完了しました。';
$string['cliupgrademaintenancenotrequired'] = 'このアップグレードでユーザがメンテナンスモードになることはありません。';
$string['cliupgrademaintenancerequired'] = 'このアップグレードではユーザがメンテナンスモードになります。';
$string['cliupgradenoneed'] = 'インストール済みバージョン {$a} をアップグレードする必要はありません。ありがとうございます!';
$string['cliupgradepending'] = 'アップグレード保留中';
$string['cliupgradesetlock'] = 'アップグレードはCLI実行時のみロックされました。';
$string['cliupgradeunsetlock'] = '既存のCLI実行アップグレードロックが解除されました。';
$string['cliyesnoprompt'] = 'y (yes) または n (no) を入力してください。';
$string['close'] = '閉じる';
$string['cohort_customfield'] = 'カスタムコーホートフィールド';
$string['commentsperpage'] = '1ページあたりに表示するコメント数';
$string['commonactivitysettings'] = '共通設定';
$string['commonfiltersettings'] = 'フィルタ共通設定';
$string['commonsettings'] = '共通設定';
$string['componentinstalled'] = 'コンポーネントがインストールされました。';
$string['computedfromlogs'] = '{$a} 以降のログより計算しています。';
$string['condifmodeditdefaults'] = 'デフォルト値は新しい活動またはリソースの作成時に設定フォームで使用されます。';
$string['confeditorhidebuttons'] = 'HTMLエディタ内で隠すボタンを選択してください。';
$string['configallcountrycodes'] = '例えばユーザプロファイルのように、これは多くの場所で選択できる国リストです。空白にした場合 (デフォルト)、標準英語言語パックのcountries.php内リストが使用されます。このリストはISO 3166-1から作成されています。そうでない場合、例えば「JA,GB,FR,ES」 のように、カンマ区切りのコードのリストを記述することができます。あなたが新しい非標準コードをここに入力した場合、「en」内のcontries.phpおよびあなたの言語パックに追加する必要があります。';
$string['configallowassign'] = '左側カラム内のそれぞれのロールに関して、どのロールを他の人に割り当てれるか選択してください。';
$string['configallowattachments'] = 'この設定を有効にした場合、サイトから送信されるメールにバッジ等を添付できるようになります。';
$string['configallowcategorythemes'] = 'この設定を有効にした場合、カテゴリに独自のテーマを設定することができます。独自テーマが設定されていない限り、これはすべての子カテゴリおよびコースに影響を及ぼします。警告: カテゴリテーマを有効にした場合、パフォーマンスに影響を及ぼします。';
$string['configallowcohortthemes'] = 'この設定を有効にした場合、コーホートレベルでテーマを設定できるようになります。これは1つのコーホートのみのユーザすべてまたは2つ以上のコーホートで同じテーマのユーザに影響します。';
$string['configallowcoursethemes'] = 'この設定を有効にした場合、コースに独自テーマを設定できます。コーステーマは他のすべてのテーマ (サイト、ユーザ、カテゴリ、コーホートまたはＵＲＬ定義テーマ) をオーバーライドします。';
$string['configallowedemaildomains'] = '送信メールの「From」セクションで公開を許可するメールドメインの一覧です。デフォルトの「空」では送信メールすべてにno-replyアドレスを使用します。ワイルドカードの使用は許可されます。例えば「*.example.com」では「example.com」のすべてのサブドメインからメール送信を許可しますが、「example.com」自体からは許可しません。この場合、別々のエントリを必要とします。';
$string['configallowemailaddresses'] = '新しいメールアドレスすべてを特定のドメインのみに制限したい場合、ここにスペースで区切って入力してください。他のドメインはすべて拒否されます。サブドメインを許可する場合、先頭に「.」を付けたドメインを入力してください。サブドメインと一緒にルートドメインも許可する場合、先頭に「.」を付けたドメイン、先頭に「.」を付けないドメインの2つを入力してください。例) .ourcollege.edu.au ourcollege.edu.au';
$string['configallowemojipicker'] = '絵文字ピッカはユーザがメッセージおよび他のテキストエリアにAttoツールバー下部の絵文字ピッカボタンでスマイリー等の絵文字を選択して追加できるようにします。';
$string['configallowemojipickerincompatible'] = 'あなたの現在のデータベース設定は適切に絵文字をサポートしません。絵文字ピッカを有効にするには<a href="https://docs.moodle.org/en/MySQL_full_unicode_support">あなたのデータベースをフルユニコードサポートにアップルグレードする必要があります</a>。';
$string['configallowguestmymoodle'] = 'この設定を有効にした場合、ゲストがダッシュボードにアクセスできるようになります。そうでない場合、ゲストはサイトホームにリダイレクトされます。';
$string['configallowobjectembed'] = 'セキュリティのため、学生ロールのユーザはHTMLのEMBEDおよびOBJECTタグを使用してマルチメディアをテキストに埋め込めません。あなたがこれらのタグを許可したい場合、このオプションを有効にしてください。';
$string['configallowoverride'] = 'あなたは左側のロールを持つ人が他の人にカラムのロールをオーバーライドすることを許可できます。';
$string['configallowoverride2'] = '左側カラム内のそれぞれのロールに関して、オーバーライドを設定できるロールを選択してください。<br />ユーザはケイパビリティ「moodle/role:override」または「moodle/role:safeoverride」を持つ必要があります。';
$string['configallowswitch'] = 'ユーザが持つロールをベースに、どのロールにスイッチできるか選択してください。このテーブルのエントリに加えてロールをスイッチできるようにするにはユーザが「moodle/role:switchroles」ケイパビリティを持つ必要があります。<br />「moodle/course:view」ケイパビリティを持ち、「moodle/site:doanything」ケイパビリティを持たないロールにのみスイッチできるため、このテーブルのいくつかのカラムは無効にされていることに留意してください。';
$string['configallowthemechangeonurl'] = 'この設定を有効にした場合、MoodleのURLに以下のいずれかを追加することにより、テーマを変更することができます。
<br />
?theme=themename (例: mymoodlesite.com/?theme=afterburner )
<<br />
&theme=themename (例: mymoodlesite.com/course/view.php?id=2&theme=afterburner )';
$string['configallowuserblockhiding'] = 'サイト全体において、ユーザにブロックの表示/非表示を許可しますか? 折りたたみ可能なブロックの状態を記憶するため、この機能はJavaScriptおよびクッキーを使用します。また、この設定はユーザ自身の閲覧にのみ影響します。';
$string['configallowusermailcharset'] = 'この設定を有効にした場合、ユーザはメッセージプレファレンスで自分のメールの文字コードを選択することができます。';
$string['configallowuserswitchrolestheycantassign'] = 'デフォルトではmoodle/role:assignはロールをスイッチするユーザに必要です。この設定を有効にすることで、この必要条件を解除します。また、「ロールを切り替える ...」ドロップダウンメニューで利用できるロールは「ロールの割り当て許可」テーブルの設定でのみ決定されることになります。「ロールの割り当て許可」テーブルの設定ではユーザの既存ロールより多くのケイパビリティを持ったロールへの切り替えを許可しないことをお勧めします。';
$string['configallowuserthemes'] = 'この設定を有効にした場合、ユーザは自分のテーマを設定することができます。ユーザテーマはサイトテーマをオーバーライドします (コーステーマはオーバーライドされません)。';
$string['configallowview'] = '左側カラム内のそれぞれのロールに関して、表示、検索およびフィルタが可能なロールを選択してください。';
$string['configallusersaresitestudents'] = 'サイトホームにある活動ですべてのユーザを学生と考えてもよろしいですか? この設定を「Yes」にした場合、承認済みユーザアカウントのユーザは学生としてこれらの活動に参加できます。この設定を「No」にした場合、少なくとも1つのコースに登録しているユーザのみこれらの活動に参加できます。管理者および特別に割り当てられた教師のみサイトホームの活動で教師として行動できます。';
$string['configauthenticationplugins'] = 'あなたが使用したい認証プラグインを選択して、フェイルスルーの順に並べ替えてください。';
$string['configautolang'] = 'ブラウザの設定からデフォルト言語を認識します。この設定を有効にしない場合、サイトデフォルトが使用されます。';
$string['configautolangusercreation'] = 'この設定を有効にした場合、初回ログイン (例 LDAPまたはOAuth 2認証を使用) でユーザアカウントが自動作成される時にユーザのブラウザ言語が優先言語として設定されます。そうでない場合、サイトのデフォルト言語がユーザの優先言語として設定されます。';
$string['configautologinguests'] = '利用者がコースにゲストアクセスした場合、自動的にゲストとしてログインさせますか?';
$string['configbloglevel'] = 'ここではどのユーザブログをこのサイトで閲覧できるかアクセスレベルを制限することができます。ここで設定するのは閲覧者に関する最大コンテクストであり投稿者またはブログ記事のタイプではないことに注意してください。不要な場合、ブログを完全に無効にすることもできます。';
$string['configcalendarcustomexport'] = 'カレンダーのカスタム日付幅エクスポートを有効にする';
$string['configcalendarexportsalt'] = 'このランダムテキストはカレンダーのエクスポート時に使用される認証トークンのセキュリティを改善するため使用されます。あなたがこのハッシュsaltを変更した場合、現在のトークンすべてが無効にされることに留意してください。';
$string['configcookiesecure'] = 'サーバがhttps接続のみ受け付ける場合、セキュアクッキーの送信を有効にすることをお勧めします。この設定を有効にした場合、ウェブサーバがhttp://を受け付けないこと、またはhttps://アドレスにパーマネントにリダイレクトされていることを確認してください。また、理想的にはHSTSヘッダを送信してください。<em>wwwroot</em>アドレスがhttps://で始まらない場合、この設定は自動的に無効にされます。';
$string['configcountry'] = 'ここで国を設定した場合、新規ユーザアカウントの国のデフォルトとして選択されます。ユーザに自分で国を選ばせる場合、設定しないままにしてください。';
$string['configcoursegraceperiodafter'] = '過去のコースを進行中として扱うコース終了日後の日数を指定してください。';
$string['configcoursegraceperiodbefore'] = '未来のコースを進行中として扱うコース開始日前の日数を指定してください。';
$string['configcourseoverviewfilesext'] = 'コースイメージファイルに許可する拡張子をカンマで区切って入力してください。';
$string['configcourseoverviewfileslimit'] = 'コースページのコース概要一覧の隣に表示できるファイルの最大数です。最初に追加されたイメージファイルはユーザのダッシュボードのコース概要内のコースイメージとして使用されます。他のすべての追加ファイルはコースページ一覧のみに表示されます。';
$string['configcourserequestnotify'] = '新しいコースがリクエストされた場合、通知されるユーザのユーザ名を入力してください。';
$string['configcourserequestnotify2'] = '新しいコースがリクエストされた場合、通知されるユーザです。コースリクエストを承認できるユーザのみ、ここに一覧表示されます。';
$string['configcoursesperpage'] = 'コース一覧の1ページあたりに表示するコース数を入力してください。';
$string['configcourseswithsummarieslimit'] = 'シンプルな一覧に戻る前、コース一覧に表示するコース概要を含むコースの最大数です。';
$string['configcronclionly'] = 'ウェブ経由でcronを実行することにより、匿名ユーザに機密情報を晒してしまいます。そのため、コマンドラインによるcronの実行またはリモートアクセスに対してcronにパスワードを設定することをお勧めします。';
$string['configcronremotepassword'] = 'cronパスワードを設定した場合、以下の形式のURLを使用してcronパスワードを提供しない限り、ウェブブラウザからcron.phpを動作させることはできません。<pre>
https://site.example.com/admin/cron.php?password=opensesame
</pre>これが空白の場合、パスワードは要求されません。';
$string['configcurlcache'] = 'cURLキャッシュの有効期間 (Time-to-live) を秒で指定してください。';
$string['configcustommenuitems'] = 'ここでカスタムメニューを設定できます。次のフォーマットで新しい行にメニューアイテムを入力してください: メニューテキスト、リンクURL (任意、サブアイテムのあるトップメニューアイテム用ではありません)、ツールチップタイトル (任意) および言語コードまたはコードのカンマ区切り一覧 (任意、指定された言語でのみユーザに行を表示する)。ハイフンで開始する行は前のトップレベルメニューのメニューアイテムとして表示されます。### は分離記号です。例えば次のようになります:
<pre>
Courses
-All courses|/course/
-Course search|/course/search.php
-###
-FAQ|https://example.org/faq
-Preguntas más frecuentes|https://example.org/pmf||es
Mobile app|https://example.org/app|Download our app
</pre>';
$string['configcustomusermenuitems'] = 'あなたはユーザメニューのコンテンツを設定することができます (自動的に追加されるログアウトリンクを除きます)。それぞれの行はパイプ文字で区切ってください。また、次の行で構成されます。
1) 「langstringname, componentname」の形のストリングまたはプレインテキスト
2) URL 必要に応じて1つまたはそれ以上の「#」文字の行の追加によりディバイダ (区切り) を使用できます。';
$string['configdbsessions'] = 'この設定を有効にした場合、現在のセッション情報を保存するためデータベースが使用されます。この設定を変更した場合、(あなたも含めて) 現在のユーザがログアウトされることに留意してください。あなたがMySQLを使用している場合、my.cnf (またはmy.ini) の「max_allowed_packet」を少なくとも4Mにしてください。他のセッションドライバは直接config.php設定できます。詳細はconfig-dist.phpをご覧ください。あなたがconfig.phpファイル内でセッションドライバを指定した場合、このオプションは秘匿されます。';
$string['configdebug'] = 'この設定を有効にした場合、PHPのerror_reportingが増加し、より多くの警告が表示されるようになります。これは開発者にのみ便利な設定です。';
$string['configdebugdisplay'] = 'この設定を有効にした場合、エラー報告はHTMLページに表示されます。これは実際、役に立ちますが、一般的にXHTML、JS、cookiesおよびHTTPヘッダを壊します。この設定を無効にした場合、エラー報告がサーバログに記録されて、デバッグしやすくなります。PHP設定のerror_logでどのログを記録するかコントロールできます。';
$string['configdebugpageinfo'] = 'この設定を有効にした場合、ページフッタにページ情報が表示されます。';
$string['configdebugvalidators'] = 'この設定を有効にした場合、フッタに外部Validatorサーバのリンクが表示されます。あなたは新たなユーザ名「w3cvalidator」を作成して、ゲストアクセスを有効にする必要があります。これらの変更により、サーバに対して不正なアクセスを許可してしまうことになります。実運用サイトでは有効にしないでください!';
$string['configdefaulthomepage'] = 'サイトにログインした後、ユーザをどのページにリダイレクトさせますか? この設定はクラシックベースのテーマを使用しているユーザのためのナビゲーションの最初のリンクも決定します。';
$string['configdefaultrequestcategory'] = 'ユーザが異なるカテゴリを選択できない限り、システムコンテクストで新しいコースをリクエストできるケイパビリティのユーザによりリクエストされたコースはこのカテゴリに置かれます。';
$string['configdefaultrequestedcategory'] = 'リクエストされたコースが承認された場合、コースが設置されるデフォルトカテゴリです。';
$string['configdefaultuserroleid'] = 'すべてのログインユーザにはそれぞれのユーザに与えられるロールに加えて、あなたがここで指定したケイパビリティを持つロールがサイトレベルで与えられます。デフォルトは認証済みユーザロールです。ここでの設定はユーザに与えられているロールと矛盾することはなく、すべてのユーザにコースレベルで割り当てすることができないケイパビリティを割り当てます (例 ブログエントリの投稿、自分のカレンダーの管理等)。';
$string['configdeleteincompleteusers'] = 'この期間終了後、姓名、またはメールアドレスフィールドが入力されていないアカウントは削除されます。';
$string['configdeleteunconfirmed'] = 'メールベースの自己登録等、特定の認証方法においてユーザは指定された期間内にアカウントを確認する必要があります。この期間終了後、確認未了の古いアカウントは削除されます。';
$string['configdenyemailaddresses'] = '特定ドメインから新しいメールアドレスを拒否したい場合、ここにスペースで区切って入力してください。他のドメインはすべて認められます。サブドメインを拒否するには設定値の先頭に「.」を追加してください。例  <strong>hotmail.com yahoo.co.uk .live.com</strong>';
$string['configdisableuserimages'] = 'ユーザがユーザプロファイルイメージを変更できないようにします。';
$string['configdisplayloginfailures'] = 'ここで選択したユーザに前回のログイン失敗情報を表示します。';
$string['configdndallowtextandlinks'] = 'この設定を有効にした場合、コースへのテキスト、リンクおよびファイルのドラッグ＆ドロップを有効にします。Firefoxへのテキストのドラッグ、または異なるブラウザ間でのテキストのドラッグは信頼性に欠けます。結果として、データがアップロードされない、または文字化けしたテキストがアップロードされる可能性があることに留意してください。';
$string['configdoclang'] = 'この言語がドキュメンテーションページのリンクに使用されます。';
$string['configdocroot'] = 'それぞれのページのフッタに表示される「このページのドキュメンテーション」リンクに関して文脈固有のMoodle Docsのパスを定義してください。フィールドを空白のままにした場合、リンクは表示されません。';
$string['configdoctonewwindow'] = 'この設定を有効にした場合、新しいウィンドウにMoodle Docsのリンクが表示されます。';
$string['configduration_high'] = 'この値は高すぎます。最大値は {$a} です。';
$string['configduration_low'] = 'この値は低すぎます。最小値は {$a} です。';
$string['configeditordictionary'] = 'この値はAspellがユーザ言語の辞書を持っていない場合に使用されます。';
$string['configeditorfontlist'] = 'エディタのドロップダウンリストに表示されるフォントを選択してください。';
$string['configemailchangeconfirmation'] = 'ユーザがプロファイルでメールアドレスを変更した場合、メール確認ステップを求めます。';
$string['configemaildkimselector'] = 'DKIMは任意であり、あなたのDNSレコードが合致する必要があります。';
$string['configemailfromvia'] = '送信メールの「From」セクションに送信元情報を追加します。これはこのメールが誰から送信されたのか受信者に知らせます。また、受信者が間違ってno-replyアドレスに返信してしまうことを防ぎます。';
$string['configemailheaders'] = 'すべての出力メールに文字どおり追加される生メールヘッダです。';
$string['configemailsubjectprefix'] = 'すべての送信メールの件名行の前に付けられるテキストです。';
$string['configenableanalytics'] = '「脱落リスクのある学生」または「直近の活動期限」のようなアナリティクスモデルは予測の生成、洞察通知の送信およびユーザへのメッセージ通知等のさらなるアクションを提供できます。';
$string['configenableblogs'] = 'ここではサイトユーザすべてに独自のブログを提供します。';
$string['configenablecalendarexport'] = 'カレンダーのエクスポートまたは購読を有効にします。';
$string['configenablecomments'] = 'コメントを有効にします。';
$string['configenablecourserequests'] = 'この設定を有効にした場合、新しいコースをリクエストできるケイパビリティ (moodle/course:request) のユーザにはコースをリクエストするオプションが与えられます。このケイパビリティは他のすべてのデフォルトロールでは許可されません。これはシステムまたはカテゴリコンテクストで適用できます。';
$string['configenablemobilewebservice'] = 'Moodleアプリにはモバイルウェブサービスが必要です。あなたのサイトがHTTPSを使用している場合、モバイルウェブサービスはデフォルトで有効にされています。詳細は {$a} をご覧ください。';
$string['configenablerssfeeds'] = 'このオプションを有効にした場合、ブログ、フォーラム、データベース活動および用語集を含むサイト全体の様々な機能によってRSSフィードが生成されます。特定のモジュールでRSSフィードを有効にする必要があることに留意してください。';
$string['configenablerssfeedsdisabled'] = 'サイトすべてにおいてRSSフィードが無効にされているため、利用できません。管理設定内の詳細設定でRSSフィードを利用可能にできます。';
$string['configenablerssfeedsdisabled2'] = 'RSSフィードはサイトレベルで無効にされています。サイト管理の拡張機能で有効にすることができます。';
$string['configenablestats'] = 'この設定を有効にした場合、Moodleのcronジョブがログを処理して統計情報を集めます。あなたのサイトのトラフィックにより時間を要する場合があります。このオプションを有効にした場合、あなたのそれぞれのコースまたはサイト全体に関して興味深いグラフおよび統計データを閲覧することができます。';
$string['configenabletrusttext'] = 'デフォルトではMoodleは常にユーザによりアップロードされたセキュリティ上のリスクのある悪意を持ったスクリプト、メディア等をテキストを完全にクリーニングします。コンテンツ信頼システムでは特定のユーザによるコンテンツに対して、干渉しない拡張機能を適用することができます。このシステムを動作させるには最初にこの設定を有効にした後、個別のMoodleロールにコンテンツ信頼パーミッションを与える必要があります。このようなユーザにより作成またはアップロードされたテキストには信頼されている旨のマークが付けられ、表示前にクリーニングされることはありません。';
$string['configenablewebservices'] = 'ウェブサービスではMoodle appのような他のシステムがサイトにログインして操作できるようにします。セキュリティのため、あなたがアプリまたはウェブサービスによる統合が必要な外部ツール/サービスを使用しない場合、この設定は無効にしてください。';
$string['configenablewsdocumentation'] = 'ウェブサービスドキュメンテーションの自動生成を有効にします。ユーザは「セキュリティキー」ページでドキュメンテーションにアクセスすることができます。有効にされたプロトコルのドキュメンテーションのみ表示されます。';
$string['configerrorlevel'] = '表示したいPHPの警告数を選択してください。通常はNormalが最良の選択です。';
$string['configexportlookahead'] = 'エクスポート中に考慮する将来の日数';
$string['configexportlookback'] = 'エクスポート中に考慮する過去の日数';
$string['configextendedusernamechars'] = 'この設定を有効にした場合、大文字以外、ユーザ名にどのような文字でも使用できます。そうでない場合、英数字小文字、アンダースコア (_)、ハイフン (-)、ピリオド (.) またはアットマーク (@) が許可されます。';
$string['configextramemorylimit'] = '検索、バックアップ/リストアまたはcronのようなスクリプトではさらなるメモリを必要とします。規模の大きなサイトでは設定値を上げてください。';
$string['configfilterall'] = 'ヘッダ、タイトル、ナビゲーションバー等を含むすべての文字をフィルタします。これは多言語フィルタを使用している時に最も有用です。そうでない場合、あなたのサイトに単に負荷がかかるだけになります。';
$string['configfiltermatchoneperpage'] = 'オートリンクフィルタはページ全体で最初のテキストマッチングに該当した1つのテキストリンクのみ生成します。他のすべては無視されます。';
$string['configfiltermatchonepertext'] = 'オートリンクフィルタはそれぞれのアイテムのページテキストで最初のテキストマッチングに該当した1つのテキストリンクのみ生成します。他はすべて無視されます。「1ページあたり1回フィルタマッチする」が有効にされている場合、この設定は無視されます。';
$string['configfilternavigationwithsystemcontext'] = '通常のフィルタリング使用は使用されるコンテクスト (例: コースコンテクスト) に関連しますが、サイトナビゲーションでは「コンテンツおよびヘッディング」フィルタリングを使用する場合、明示的にすべてをサイトのコンテクストでフィルタリングすることによりパフォーマンスの改善を期待できます。';
$string['configfilteruploadedfiles'] = '「すべてのファイル」はアップロードしたすべてのHTMLおよびテキストファイル、「HTMLファイルのみ」はアップロードしたHTMLファイルのみ、表示する前にフィルタをかけます。「なし」は全くフィルタをかけません。';
$string['configforcelogin'] = '通常、サイトホームおよびコース一覧 (コースではなく) はサイトにログインせずに閲覧できます。すべての操作の前にユーザにログインを強制したい場合、この設定を有効にしてください。';
$string['configforceloginforprofiles'] = 'この設定ではユーザプロファイルページの閲覧に関して、(ゲストではない) 実アカウントでのログインをユーザに強制します。この設定を無効にした場合、ユーザが広告 (スパム) を投稿、または他の不適切なコンテンツをプロファイルに投稿して、世界中から閲覧できる可能性があります。';
$string['configfrontpage'] = '上で選択したアイテムはサイトホームに表示されます。';
$string['configfrontpagecourselimit'] = '最大コース数';
$string['configfrontpagecourselimithelp'] = 'サイトホームのコース一覧に表示される最大コース数です。';
$string['configfrontpageloggedin'] = '上で選択したアイテムはユーザのログイン時にサイトホームに表示されます。';
$string['configfullnamedisplay'] = 'ここでは氏名がどのように表示されるか設定します。デフォルト値「language」のままにした場合、現在の言語パック内のストリング「fullnamedisplay」が決定します。いくつかの言語では異なる氏名表示の慣習があります。

単一言語を使用したほとんどのサイトでは「名 + 姓」を使用した方が良いでしょう。しかし、あなたは姓を完全に隠すこともできます。使用できるプレースホルダは次のとおりです:
firstname, lastname, firstnamephonetic, lastnamephonetic, middlename, alternatename';
$string['configgeoipfile'] = 'GeoIP Cityバイナリデータファイルのロケーションです。このファイルはMoodleディストリビューションの一部ではなく、<a href="https://www.maxmind.com/">MaxMind</a>から個別に取得する必要があります。あなたは商用バージョンを購入または無料バージョンを使用できます。<a href="https://dev.maxmind.com/geoip/geoip2/geolite2/" >https://dev.maxmind.com/geoip/geoip2/geolite2/</a>からダウンロードできるCityデータベースファイルをダウンロードする場合、あなたは登録する必要があります。あなたが登録してファイルをダウンロードした後、あなたのサーバの「 {$a} 」ディレクトリで展開してください。';
$string['configgetremoteaddrconf'] = 'リバースプロキシの背後にサーバを設置している場合、あなたはリモートIPアドレスを含んだ信頼できるHTTPヘッダを指定することができます。ヘッダは順番に読まれ最初の有効なヘッダが使用されます。';
$string['configgradebookroles'] = 'ここでは誰が評定表に表示されるか設定することができます。ユーザがコース評定表で表示されるためにはこれらの中から少なくとも１つのロールを割り当ててください。';
$string['configgradeexport'] = 'どの評定表エクスポートフォーマットをあなたの主要な評定表エクスポート方法にするか選択してください。選択されたフォーマットのプラグインが設定され、すべての評定の「最新エクスポート」フィールドに使用されます。例えばエクスポートされたレコードは「新規」または「更新」レコードとして認識されます。この設定に関して自信を持てない場合、すべてをチェックしないままにしてください。';
$string['configgradeexportdefault'] = '評定をエクスポートするためのあなたのデフォルトの方法としてどの評定表エクスポートフォーマットを使用するかを選択してください。';
$string['confighiddenuserfields'] = 'あなたがコース教師/管理者以外のユーザに隠したいユーザ情報フィールドを選択してください。この設定により、ユーザのプライバシーを強化することができます。複数フィールドを選択するにはCTRLキーを押したままにしてください。';
$string['configidnumber'] = 'このオプションでは次の内容を設定します。(a)ユーザがユーザIDの入力を求められない、(b)ユーザがユーザIDを空白にできる、(c)ユーザはユーザIDの入力を求められ、空白にできない。ユーザIDが入力された場合、ユーザのプロファイルに表示されます。';
$string['configintro'] = 'このページではあなたのサーバでMoodleが最適に動くための設定値を入力できます。設定値を過度に心配しないでください - 通常、デフォルト値で最適に動作するよう設定されています。いつでもこのページに戻って再度設定することができます。';
$string['configintroadmin'] = 'このページではサイトすべてを管理できる最高管理者アカウントを作成します。正しいメールアドレスおよび安全なユーザ名、パスワードを設定してください。あなたは後でさらに管理者アカウントを作成することができます。';
$string['configintrosite'] = 'このページではこの新しいサイトのサイトホームおよびサイト名を設定します。管理メニューを使用することで、いつでもここに戻って、これらの設定を変更することができます。';
$string['configiplookup'] = 'あなたがログ等でIPアドレス (例 34.12.222.93) をクリックした場合、そのIPアドレスがどこから来たものなのか推量しやすいマップが表示されます。この機能にはあなたが選択できる異なるプラグインがあり、それぞれに利点と不利点があります。';
$string['configkeeptagnamecase'] = 'ユーザが入力したタグ名の大文字小文字を保持したい場合、この設定を有効にしてください。';
$string['configlang'] = 'サイト全体に適用されるデフォルト言語を選択してください。ユーザは言語設定メニューまたはパーソナルプロファイルにより、この設定をオーバーライドすることができます。';
$string['configlanglist'] = 'この設定を空白にした場合、サイトにインストールされた言語すべてが言語メニューに表示されます。代わりにカンマ区切りの言語コードリストの入力により言語メニューを短くできます。例: ja,en,es_es,fr,it 必要であれば、次のフォーマットで言語パックと異なる言語名を使用できます。例) ja_kids|Japanese,en_kids|English,de_kids|Deutsch.';
$string['configlangmenu'] = '汎用の言語選択メニューをホームページ、ログインページ等に表示するかどうか選択してください。この設定はユーザが自身のプロファイルで優先言語を設定することに影響を及ぼしません。';
$string['configlangstringcache'] = 'すべての言語ファイルをデータディレクトリ内のコンパイル済みファイル内にキャッシュします。あなたがMoodleを翻訳またはMoodleソースコード内のストリングを変更している場合、無効にしてください。そうでない場合、パフォーマンスを向上させるため有効のままにしてください。';
$string['configlatinexcelexport'] = 'Excelエクスポートのエンコーディングを選択してください。';
$string['configlocale'] = 'サイト全体に適用されるロケールを選択してください - この設定はすべての言語パックの日付の書式および言語をオーバーライドします (カレンダーの曜日には影響しません)。あなたのオペレーティングシステムにロケールデータがインストールされている必要があります (例 linuxの場合、ja_JP.UTF-8、en_US.UTF-8、es_ES.UTF-8)。 ほとんどの場合、このフィールドは空白のままにしてください。';
$string['configlockrequestcategory'] = 'この設定を有効にした場合、システムコンテクストで新しいコースをリクエストできるケイパビリティのユーザは新しいコースのリクエストフォームでカテゴリを選択できます。代わりにユーザが1つのカテゴリのみで新しいコースをリクエストできるよう制限したい場合、新しいコースをリクエストできるケイパビリティをカテゴリコンテクストで適用してください。';
$string['configloglifetime'] = 'ここではユーザの活動に関するログの保持期間を設定します。指定した値より古いログは自動的に削除されます。あなたが必要な場合、可能な限り長い間ログを保持することをお勧めしますが、アクセス数が多く、サーバのパフォーマンスに問題がある場合、ログの保持期間を短く設定してください。統計が正常に動作しないため、30以下の値はお勧めできません。';
$string['configlookahead'] = '直近イベント日';
$string['configmailnewline'] = 'メールメッセージに使用される改行文字です。RFC 822bisによるとCRLFは必須です。いくつかのメールサーバでは自動的にLFがCRLFに変換され、他のメールサーバではCRLFがCRCRLFに誤って変換され、また、生のLFを拒否するメールサーバ (例えばqmail) もあります。メールが送信されなかったり、改行が2重になる問題がある場合、この設定を変更してください。';
$string['configmaxbytes'] = 'ここではサイト全体でアップロードできるファイルの最大サイズを設定します。この設定はPHP設定のpost_max_sizeおよびupload_max_filesize、同様にApache設定のLimitRequestBodyに制限されます。maxbytesはコースレベルまたは活動レベルで選択できるサイズの範囲を制限します。「サイトアップロード上限」が選択された場合、サーバで設定された最大値が使用されます。';
$string['configmaxconsecutiveidentchars'] = 'パスワードにはこの値以上の連続した同一文字を使用することができません。このチェックを無効にするにはゼロを指定してください。';
$string['configmaxeditingtime'] = 'ここではフォーラム投稿、用語集コメント等を編集可能な時間を設定します。通常、30分が適切な値です。';
$string['configmaxevents'] = '直近イベント数';
$string['configmaxusersperpage'] = 'コース、グループ、コーホート、ウェブサービス等において、ユーザセレクタに表示するユーザの最大数です。';
$string['configmessaging'] = 'この設定を有効にした場合、ユーザはサイトの他のユーザにメッセージを送信できるようになります。';
$string['configmessagingallowemailoverride'] = 'プロファイルのメールアドレス以外のメールアドレスへの通知メッセージ送信をユーザに許可します。';
$string['configmessagingallusers'] = 'この設定を有効にした場合、ユーザはメッセージ送信先を選択する時にサイトの誰からでもメッセージの受信を許可しているユーザすべての一覧を閲覧することができます。この設定を無効にした場合、ユーザは自分のコースのユーザ一覧のみ閲覧することができます。また、メッセージプレファレンスに次の2つのオプションが提供されます - コンタクトからのメッセージのみ受信する、コンタクト先およびコース内の誰からでもメッセージを受信する。';
$string['configmessagingdefaultpressenter'] = 'ユーザのメッセージング設定で「Enterで送信する」をデフォルトで有効にするか指定します。';
$string['configmessagingdeleteallnotificationsdelay'] = '既読および未読の通知を削除することによりスペースを節約することができます。通知作成後、どのくらいの期間で通知を削除しますか?';
$string['configmessagingdeletereadnotificationsdelay'] = 'スペースを空けるため、未読通知を削除することができます。どのくらいの期間の後、未読通知を削除しますか?';
$string['configminpassworddigits'] = 'パスワードには少なくともここで設定した数の数字を使用する必要があります。';
$string['configminpasswordlength'] = 'パスワードは少なくともここで設定した長さである必要があります。';
$string['configminpasswordlower'] = 'パスワードには少なくともここで設定した数の小文字を使用する必要があります。';
$string['configminpasswordnonalphanum'] = 'パスワードには少なくともここで設定した数の非英数字を使用する必要があります。';
$string['configminpasswordupper'] = 'パスワードには少なくともここで設定した数の大文字を使用する必要があります。';
$string['configmypagelocked'] = 'この設定により、非管理者からデフォルトページが編集されることを防ぎます。';
$string['confignavcourselimit'] = 'ナビゲーションバーでユーザに表示されるコース数を制限します。';
$string['confignavshowallcourses'] = 'ここではコースに登録されているユーザがナビゲーション内にコース (すべてのコース一覧) およびマイコース (登録しているコース一覧) を閲覧できるかどうか決定します。';
$string['confignavshowcategories'] = 'ナビゲーションバーおよびナビゲーションブロックにコースカテゴリを表示します。この設定変更は現在ユーザが登録しているコースには反映されません。これらのコースでのナビゲーションバーおよびナビゲーションブロックはカテゴリなしのマイコース下に表示されます。';
$string['confignoreplyaddress'] = 'Moodleではユーザに代わってメールが送信される場合があります (例 フォーラム投稿)。ここで設定するメールアドレスは「From」に使用され、受信者が直接送信者に返信できないようにします (例 ユーザが自分のメールアドレスを隠すよう設定している場合)。';
$string['confignotifyloginfailures'] = '選択されたユーザにログイン失敗通知メッセージを送信します。内部ログストア (例 標準ログストア) を有効にする必要があります。';
$string['confignotifyloginthreshold'] = 'ログイン失敗通知が有効の場合、同一ユーザまたはIPアドレスで何回ログインに失敗した場合に通知を送信しますか?';
$string['confignotloggedinroleid'] = 'サイトにログインしていないユーザはサイトコンテクストに関して、このロールが割り当てられているかのように扱われます。ほとんどの場合、あなたがここで割り当てるロールは「ゲスト」で十分ですが、権限を減らしたロールまたはさらに制限されたロールを作成することもできます。それでもフォーラムへの投稿等はユーザが適切にログインする必要があります。';
$string['configopentowebcrawlers'] = 'この設定を有効にした場合、Googleはあなたのサイトにゲストとして入ることができます。加えてGoogleが自動的に記録したデータを元に他の人がゲストとしてあなたのサイトにアクセスできます。これはすでにゲストアクセスを許可しているコースのみ、透過アクセスを提供することに留意してください。';
$string['configoverride'] = 'config.phpで設定済み';
$string['configpasswordpolicy'] = 'この設定を有効にした場合、下の設定で指定されたパスワードポリシを基にユーザパスワードがチェックされます。パスワードポリシーを有効にした場合、ユーザがパスワードの変更を決定または要求された場合、または「ログイン時にパスワードをチェックする」設定が有効にされるまで影響しません。';
$string['configpasswordpolicycheckonlogin'] = 'この設定を有効にした場合、ユーザログイン時に毎回パスワードポリシーを基にユーザパスワードがチェックされます。チェックに失敗した場合、ユーザは続行の前にパスワーの変更を要求されます。
この設定の有効化はパスワードポリシの更新後に有用です。';
$string['configpasswordresettime'] = 'この設定では有効期限切れ前にユーザがパスワードを確認する必要のある時間を指定します。通常、30分が適切な値です。';
$string['configpathtodu'] = 'duのパスを指定してください。恐らく「/usr/bin/du」のようになります。あなたがduのパスを設定した場合、多くのファイルを含んだディレクトリに関してディレクトリコンテンツを表示するページの表示速度がはるかに速くなります。';
$string['configpathtophp'] = 'PHP CLIのパスです。恐らく、/usr/bin/phpのようになります。あなたがここに入力した場合、管理ウェブインタフェースからcronスクリプトを実行することができます。';
$string['configperfdebug'] = 'この設定を有効にした場合、パフォーマンス情報がスタンダードテーマのフッタに表示されます。';
$string['configprofileroles'] = 'ユーザプロファイルおよび参加者ページで一覧表示されるロールです。';
$string['configprofilesforenrolledusersonly'] = 'スパム送信者による乱用を避けるため、コースに登録されていないユーザに関するプロファイルの自己紹介欄が非表示にされます。プロファイルの自己紹介欄にコンテンツを追加するには新しいユーザは少なくとも1つのコースに登録する必要があります。';
$string['configprotectusernames'] = 'この設定を有効にした場合、パスワード喪失フォームにユーザ名またはメールアドレスを推測できるヒントは表示されません。';
$string['configproxybypass'] = 'プロキシをバイパスするホスト名 (の一部) またはIPアドレスのリストです。それぞれのアイテムはカンマで区切ってスペースは入れないでください。例: 192.168.0.0/16,*.mydomain.com。';
$string['configproxyfixunsafe_help'] = 'ここではMoodleBotユーザエージェントを追加してプロキシを使用することにより、プロキシを通らない内部コールの修正を試みます。';
$string['configproxyhost'] = '<b>サーバ</b>のインターネットアクセスにプロキシ (例 ファイアウォール) が必要な場合、プロキシのホスト名を入力してください。必要でない場合、空白にしてください。';
$string['configproxylogunsafe_help'] = 'ここではプロキシを通らない内部コールの記録を試みます。';
$string['configproxypassword'] = 'プロキシ経由でインターネットにアクセスする必要がある場合、パスワードを入力してください。必要でない場合、空白にしてください (PHP cURL拡張モジュールが必要です)。';
$string['configproxyport'] = 'サーバがプロキシの使用を必要とする場合、ここにプロキシのポート番号を入力してください。';
$string['configproxytype'] = 'ウェブプロキシのタイプです (SOCKS5をサポートするにはPHP5およびcURL拡張モジュールが必要です)。';
$string['configproxyuser'] = 'プロキシ経由でインターネットにアクセスする必要がある場合、ユーザ名を入力してください。必要でない場合、空白にしてください (PHP cURL拡張モジュールが必要です)。';
$string['configrecaptchaprivatekey'] = '文字列 (秘密鍵) はあなたのMoodleサーバとReCAPTCHAサーバ間の通信に使用されます。ReCAPTCHAキーは<a target="_blank" href="https://www.google.com/recaptcha">Google reCAPTCHA</a>で取得することができます。';
$string['configrecaptchapublickey'] = '文字列 (サイトキー) はサインアップフォームおよびサイトサポートフォームにReCAPTCHAエレメントを表示するため使用されます。ReCAPTCHAキーは<a target="_blank" href="https://www.google.com/recaptcha">Google reCAPTCHA</a>で取得できます。';
$string['configrequestedstudentname'] = 'リクエストされたコースで使用する学生 (単数) に対する呼称';
$string['configrequestedstudentsname'] = 'リクエストされたコースで使用する学生 (複数) に対する呼称';
$string['configrequestedteachername'] = 'リクエストされたコースで使用する教師 (単数) に対する呼称';
$string['configrequestedteachersname'] = 'リクエストされたコースで使用する教師 (複数) に対する呼称';
$string['configreverseproxyignore'] = 'ヘッダに「X-Forwarded-For」を追加する複数のリバースプロキシの背後にあなたのサーバがある場合、リバースプロキシを無視してユーザの正しいIPアドレスを探すため、リバースプロキシのカンマ区切りのIPアドレスまたはサブネットの一覧を指定してください。';
$string['configsectioninterface'] = 'インタフェース';
$string['configsectionmail'] = 'メール';
$string['configsectionmaintenance'] = 'メンテナンス';
$string['configsectionmisc'] = 'その他';
$string['configsectionoperatingsystem'] = 'オペレーティングシステム';
$string['configsectionpermissions'] = 'パーミッション';
$string['configsectionrequestedcourse'] = 'コースリクエスト';
$string['configsectionsecurity'] = 'セキュリティ';
$string['configsectionstats'] = '統計';
$string['configsectionuser'] = 'ユーザ';
$string['configsecureforms'] = 'フォームデータを受け入れる場合、Moodleでは追加的なレベルのセキュリティを使用することができます。この設定を有効にした場合、ブラウザのHTTP_REFERER変数とフォーム設置のアドレスが照合されます。 ユーザがファイアウォール(例 Zonealarm) を使用してトラフィックからHTTP_REFERERを取除く設定をしている場合、まれに問題が生じる場合があります。 これはフォーム使用時に画面が「固まる」現象です。例えばユーザがログインページで問題を抱えている場合、この設定を無効にしてください。しかし、この設定ではあなたのサイトがブルートフォース・パスワードアタックに対して、無防備な状態になります。分からない場合、この設定を「Yes」のままにしてください。';
$string['configservicespage'] = 'サービスおよびサポートページのURLを入力するか、moodle.comのMoodleサービスにリンクするために空のままにしてください。リンクはサイト管理者にのみ表示されます。';
$string['configsessioncookie'] = 'ここではMoodleセッションで使用されるクッキーの名称をカスタマイズします。2つ以上のMoodleが同じウェブサイトで稼動している場合、クッキーが混乱するのを防ぐためだけに、この設定を任意でお使いください。';
$string['configsessioncookiedomain'] = 'ここではMoodleクッキーが利用できるドメインを変更します。これは別のサブドメインのウェブアプリケーションとMoodleセッションを共有する必要のある、特別なMoodle (例 認証または登録プラグイン) に有用です。<strong>警告: この設定をデフォルト (空) のままにすることを強くお勧めします - 正しくない値を設定することで、すべてのユーザがサイトにログインできなくなります。</strong>';
$string['configsessioncookiepath'] = 'ブラウザが送信するMoodleクッキーの場所を変更したい場合、ここでウェブサイトのサブディレクトリを指定することができます。変更しない場合、デフォルトの「/」を使用してください。';
$string['configsessiontimeout'] = 'このサイトにログインして長時間何もしない (ページを読み込まない) 場合、ユーザを自動的にログアウト (セッション終了) させます。この変数にはログアウトさせるまでの時間を設定します。';
$string['configsessiontimeoutwarning'] = 'このサイトにログインしている人が長時間 (ページを読み込まずに) 操作していない場合、セッションが終了しようとしていることに関して警告されます。この変数ではこの時間を指定します。';
$string['configsessiontimeoutwarningcheck'] = 'セッションタイムアウト警告はセッションタイムアウトより小さい値にしてください。';
$string['configshowcommentscount'] = 'コメント総数を表示します。コメントリンクの表示時にさらに1つのクエリ実行による負荷がかかります。';
$string['configshowicalsource'] = 'iCalイベントのソース情報を表示する';
$string['configshowsiteparticipantslist'] = 'サイトすべての学生および教師がサイト参加者リストに表示されます。誰がこのサイト参加者リストを閲覧することができますか?';
$string['configsitedefaultlicense'] = 'デフォルトサイトライセンス';
$string['configsitedefaultlicensehelp'] = 'デフォルトライセンスはこのサイトのコンテンツを公開するため使用されます。';
$string['configsitemailcharset'] = 'この設定ではサイトから送信されるメールすべてに対してデフォルト文字セットを指定します。';
$string['configsitemaxcategorydepth'] = '最大カテゴリ深度';
$string['configsitemaxcategorydepthhelp'] = 'ここではカテゴリまたはコンボリストの表示時に展開表示される子カテゴリの最大深度を設定します。深いレベルのカテゴリはリンクとして表示され、ユーザはAJAXリクエストにより展開することができます。';
$string['configslasharguments'] = '「スラッシュ引数」 (<em>PATH_INFO</em>に使用) はSCORMパッケージおよび複数ファイルリソースを正しく表示するために必要です。あなたのウェブサーバがスラッシュ引数をサポートしない場合、そしてあなたが設定できない場合、結果として動作しないものが発生する可能性もありますが、この設定を無効にすることはできます。<br />注意: 「スラッシュ引数」の使用は将来的なMoodleのバージョンに必須となります。';
$string['configsmtpauthtype'] = 'ここではSMTPサーバに使用する認証タイプを設定します。';
$string['configsmtphosts'] = 'Moodleでメールを送信する時に使用する1つまたはそれ以上のローカルSMTPサーバ名を入力してください (例 mail.a.comまたはmail.a.com;mail.b.com)。デフォルト以外のポート (例 ポート25以外) を指定するには[サーバ]:[ポート]シンタックスを使用することができます (例 mail.a.com:587)。セキュアコネクションのためには通常ポート465 (SSL)、ポート587 (TLS) が使用されます。必要であれば以下にセキュリティプロトコルを指定してください。空白にした場合、MoodleはデフォルトのPHPメール送信メソッドを使用します。';
$string['configsmtpmaxbulk'] = 'SMTPセッションごとに送信するメッセージの最大数です。メッセージのグルーピングにより、メールの送信をスピードアップすることができます。2より少ない値に設定した場合、メールごとに新しいSMTPセッションの開始が強制されます。';
$string['configsmtpoauthservice'] = 'SMTPサーバと通信するよう設定されたOAuth 2サービスを選択してください。サービスがまだ存在しない場合、あなたはサービスを作成する必要があります。SMTP認証タイプをXOAUTH2に設定する必要があることに留意してください。';
$string['configsmtpsecure'] = 'SMTPサーバにセキュアコネクションが必要な場合、正しいプロトコルタイプを指定してください。';
$string['configsmtpuser'] = '上でSMTPサーバを設定し、なおかつ認証が必要な場合、ユーザ名およびパスワードを入力してください。';
$string['configstartwday'] = '週の始め';
$string['configstatsfirstrun'] = 'ここではcronジョブが<b>最初の</b>統計処理で、どのくらい過去にさかのぼるか指定します。トラフィックが多く、共有ホスティングを利用している場合、あまりにも過去にさかのぼることは良い考えではありません。統計処理は長時間を要してリソースに過大な負荷がかかります (この設定では1ヵ月 = 28日となることに留意してください。グラフおよびレポートの生成には1ヶ月 = 1カレンダー月が使用されます)。';
$string['configstatsmaxruntime'] = '統計処理ではサーバに大きな負荷がかかる場合があります。このオプションおよび次のオプションの組み合わせで、「いつ」および「どのくらい」稼動させるか設定してください。';
$string['configstatsmaxruntime2'] = '統計処理ではサーバに大きな負荷がかかる場合があります。1日の統計データの収集で許可する最大時間を指定してください。1回のcron実行で処理できる最大日数は31です。';
$string['configstatsmaxruntime3'] = '1日のうち、統計の計算に許される最大時間を指定してください。統計処理はサーバに対して大きな負荷がかかることに留意してください。1つのcronで処理する最大日数は次の設定で指定することができます。';
$string['configstatsruntimedays'] = 'それぞれの統計処理で処理する最大日数を指定してください。統計が最新の場合、1日のみ処理されますので、あなたのサーバの負荷に応じて設定値を調整してください。cron実行間隔が短い場合、この値を小さくしてください。';
$string['configstatsruntimestart'] = '何時にcronジョブの統計処理を開始しますか? 1つのサーバに複数のMoodleが存在する場合、それぞれ異なる時間を指定することをお勧めします。';
$string['configstatsuserthreshold'] = 'この設定では統計計算に含まれるコースの登録済みユーザ最少数を指定します。';
$string['configstrictformsrequired'] = 'フォームの必須フィールドにスペースまたは改行のみが入力された場合に受け付けないようにします。';
$string['configstripalltitletags'] = 'この設定を無効にした場合、活動およびリソース名にHTMLタグの使用を許可します。';
$string['configsupportavailability'] = 'フッタからサイトサポートに連絡するためのアクセス権を持つ人を決定します。';
$string['configsupportemail'] = 'このサイトにSMTPが設定されてサポートページが設定されていない場合、このメールアドレスはサポートフォームから送信されたメッセージを受信します。送信に失敗した場合、ログインユーザにこのメールアドレスが表示されます。';
$string['configsupportname'] = 'これはサポートフォームまたはサポートページ経由でサポートを提供する人の名前または団体の名称です。';
$string['configsupportpage'] = 'サポートページのURLを入力するか、コンタクトフォームにリンクする場合は空欄にしてください。リンクはサイトフッタに表示されます。';
$string['configtempdatafoldercleanup'] = '選択された時間より古い一時データファイルをデータフォルダから削除します。';
$string['configthemedesignermode'] = '通常パフォーマンスのため、すべてのテーマイメージおよびスタイルシートは長期間ブラウザおよびサーバ内にキャッシュされます。あなたがテーマをデザインまたはコードを開発している場合、キャッシュされたバージョンを表示しないため、この設定を有効にしてください。警告: この設定により、あなたのサイトがすべてのユーザに対して遅くなります! 代わりに「テーマセレクタ」ページで手動でテーマキャッシュをクリアすることができます。';
$string['configthemelist'] = '空白にした場合、すべてのテーマを使用することができます。テーマメニューを短くしたい場合、カンマで区切ったテーマ名を入力してください (テーマ名に空白を使用しないでください!)。例: standard,orangewhite';
$string['configtimezone'] = 'これは日付表示のためのデフォルトタイムゾーンです。それぞれのユーザはこの設定をプロファイルでオーバーライドすることができます。Cronタスクおよび他のサーバ設定において、このタイムゾーンが指定されます。「無効なタイムゾーン」が表示された場合、あなたは設定を変更する必要があります。';
$string['configuseblogassociations'] = 'ユーザがブログエントリをコースおよびコースモジュールに関連付けることができるようにしますか?';
$string['configusesitenameforsitepages'] = 'この設定を有効にした場合、「サイトページ」の代わりにサイト省略名がナビゲーションのサイトページノードに使われます。';
$string['configusetags'] = 'サイト全体でタグ機能を有効にしますか?';
$string['configvariables'] = '詳細設定';
$string['configverifychangedemail'] = '変更済みメールアドレスの確認に関して、「許可されるメールアドレスのドメイン」および「拒否されるメールアドレスのドメイン」設定を使用します。この設定が無効にした場合、新しいユーザ作成時のみ、ドメインが強制されます。';
$string['configvisiblecourses'] = '非表示のカテゴリ内に通常どおりコースを表示します。';
$string['configwarning'] = '慎重にこれらの設定を変更してください - 間違った設定はトラブルの原因となります。';
$string['configyuicomboloading'] = 'このオプションによりYUIライブラリの入出力共用ファイルの読み込みを最適化することができます。パフォーマンスの理由から、実運用サイトではこの設定を有効にしてください。';
$string['confirmation'] = '確認';
$string['confirmationpending'] = '確認保留';
$string['confirmcontextlock'] = '現在、{$a->contextname} は凍結されていません。凍結することによりリードオンリーにしてユーザの変更を防ぐことができます。本当に続けてもよろしいですか?';
$string['confirmcontextunlock'] = '現在、{$a->contextname} は凍結されています。凍結解除することによりユーザは変更できるようになります。本当に続けてもよろしいですか?';
$string['confirmdeletecomments'] = '本当に選択したコメントを削除してもよろしいですか?';
$string['confirmed'] = '確認済み';
$string['contactsitesupport'] = 'サイトサポートに連絡する';
$string['contenttypeuninstalling'] = '{$a->type} でサポートされる {$a->count} 個のコンテンツがあります。これらは削除されます。本当に続けてもよろしいですか?';
$string['contextlockappliestoadmin'] = 'コンテクスト凍結を管理者に適用する';
$string['contextlockappliestoadmin_desc'] = 'この設定を無効にした場合、管理者はすべての凍結済みコンテクストに対する書き込み権限を保持したままとなります。';
$string['contextlocking'] = 'コンテクスト凍結';
$string['contextlocking_desc'] = 'この設定により選択されたカテゴリ、コース、活動およびブロックへのリードオンリーアクセスを有効にします。';
$string['cookiesecure'] = 'セキュアクッキーのみ';
$string['country'] = 'デフォルトの国';
$string['course_customfield'] = 'コースカスタムフィールド';
$string['coursecolor'] = '色 {$a}';
$string['coursecolorheading_desc'] = 'コース設定でコース画像が設定されていないコースはマイコースページで模様入りのコースカードとともに表示されます。模様に使用される色は以下で指定できます。';
$string['coursecolorsettings'] = 'コースカード色';
$string['coursecontact'] = 'コース連絡先';
$string['coursecontact_desc'] = 'ここでは誰がコース説明に表示されるか設定することができます。ユーザがコース説明に表示されるためにはこれらの中から少なくとも１つのコースロールを割り当てる必要があります。';
$string['coursecontactduplicates'] = 'すべてのコース連絡先ロールを表示する';
$string['coursecontactduplicates_desc'] = 'この設定を有効にした場合、選択された複数のコース連絡先ロールのユーザがロールと共にコース説明に表示されます。そうでない場合、 (どれがサイト管理の「ロールを定義する」で上位に表示されていたとしても) 1つのロールのみが表示されます。';
$string['coursecreationguide'] = 'Moodleコース作成ガイドURL';
$string['coursecreationguide_help'] = 'コースを作成するための短いビデオおよび一般的なヒントを含むクイックスタートガイドへのパスを定義します。表示するコースがない場合、ガイドへのリンクがマイコースページに表示されます。コースを作成するケイパビリティのあるユーザにのみリンクが表示されます。';
$string['coursegraceperiodafter'] = '過去のコースの猶予期間';
$string['coursegraceperiodbefore'] = '未来のコースの猶予期間';
$string['courselistshortnames'] = '拡張コース名を表示する';
$string['courselistshortnames_desc'] = 'この設定を有効にした場合、コース一覧においてコースフルネームに加えてコース省略名が表示されます。必要であれば、言語カスタマイゼーション機能を使用して「courseextendednamedisplay」言語ストリングを編集することで、拡張コース名をカスタマイズすることができます。';
$string['coursemgmt'] = 'コースおよびカテゴリを管理する';
$string['courseoverview'] = 'コース概要';
$string['courserequestnotify'] = 'コースリクエスト通知';
$string['courserequestnotifyemail'] = 'ユーザ {$a->user} が新しいコース <a href="{$a->link}">{$a->link}</a> をリクエストしました。';
$string['courserequests'] = 'コースリクエスト';
$string['courserequestspending'] = '保留中のコースリクエスト';
$string['courses'] = 'コース';
$string['coursesperpage'] = '1ページあたりのコース数';
$string['courseswithsummarieslimit'] = 'コース概要を含むコースの制限';
$string['creatornewroleid'] = '新しいコース内でのコース作成者ロール';
$string['creatornewroleid_help'] = 'ユーザに新しいコースを管理するためのパーミッションがない場合、このロールを使用して自動的に登録されます。';
$string['cron'] = 'Cron';
$string['cron_enabled'] = 'cronを有効にする';
$string['cron_enabled_desc'] = '通常、cronは有効にすべきですが、例えばサーバの再起動時、この設定で一時的に無効にできます。この設定を無効にした場合、システムは新しいバックグラウンドタスクの開始を中止します。重要な機能の動作を停止してしまうため、長時間cronを無効にすべきではない点に留意してください。';
$string['cron_help'] = 'cron.phpメンテナンススクリプトは新しいフォーラム投稿のコピーをメール送信する等、スケジュールベースでMoodleモジュールによるタスク実行をサポートします。スクリプトは定期的 (理想的には毎分) に実行してください。';
$string['cron_keepalive'] = 'キープアライブ';
$string['cron_keepalive_desc'] = '追加タスクのポーリングを継続する時間の長さです。この設定はcronが常に実行されていることを確認するためのものです。あなたが専用タスクランナを使用する場合、0に設定してください。それ以外の場合、アドホックタスクの同時実行数制限と同様の値に設定してください。長い時間は避けてください。最大時間は15分です。';
$string['cron_link'] = 'admin/cron';
$string['cronclionly'] = 'コマンドラインでのみcronを実行する';
$string['cronerrorclionly'] = '申し訳ございません、このページへのインターネットアクセスは管理者より無効にされています。';
$string['cronerrorpassword'] = '申し訳ございません、あなたはこのページにアクセスするための有効なパスワードを提供していません。';
$string['croninfrequent'] = '最後の2件のcronメンテナンススクリプトの実行間隔は {$a->actual} です。これは毎 {$a->expected} ごとに実行されるべきです。私たちはさらに頻繁に実行されるよう設定することをお勧めします。';
$string['cronremotepassword'] = 'リモートアクセスのcronパスワード';
$string['cronwarning'] = '<a href="{$a->url}">admin/cron.php メンテナンススクリプト</a>が少なくとも {$a->actual} 稼動していません。これは毎 {$a->expected} ごとに実行されるべきです。';
$string['cronwarningcli'] = 'admin/cli/cron.phpススクリプト</a>が少なくとも {$a->actual} 実行されていません。これは毎 {$a->expected} ごとに実行されるべきです。';
$string['cronwarningnever'] = 'admin/cli/cron.phpスクリプトが実行されたことはありません。これは毎 {$a->expected} ごとに実行されるべきです。';
$string['cronwarningneverweb'] = '<a href="{$a->url}">admin/cron.php script</a>スクリプトが実行されていません。毎 {$a->expected} に実行する必要があります。';
$string['ctyperequired'] = 'サイトパフォーマンスの改善および多言語サポートを提供するため、MoodleではPHP ctype拡張モジュールが必須です。';
$string['curlcache'] = 'cURLキャッシュTTL';
$string['curlrequired'] = 'Moodleリポジトリと通信するため、MoodleではPHP cURL拡張モジュールが必須です。';
$string['curlsecurityallowedport'] = 'cURL許可済みポート一覧';
$string['curlsecurityallowedportsyntax'] = 'cURLが接続できるポート番号一覧です。有効なエントリは整数のみです。それぞれのエントリを新しい行に入力してください。空白の場合、すべてのポートが許可されます。ほとんどの場合、cURLが標準的なHTTPSおよびHTTPポートに接続するための443および80の両方を指定してください。';
$string['curlsecurityblockedhosts'] = 'cURLブロック済みホスト一覧';
$string['curlsecurityblockedhostssyntax'] = 'それぞれのエントリを新しい1行に入力してください。有効なエントリは単一ホストに合致するフルIPv4またはIPv6アドレス (例 192.168.10.1, 0:0:0:0:0:0:0:1, ::1, fe80::)、CIDR表記法 (例 231.54.211.0/20 または fe80::/64)、最後のアドレスグループに適用されるIPアドレスの範囲 (例 231.3.56.10-20 または fe80::1111-bbbb)、ドメイン名 (例 localhost or example.com)、ワイルドカードドメイン名 (例 *.example.com または *.sub.example.com) です。空白行は許可されません。';
$string['curlsecurityurlblocked'] = 'URLがブロックされています。';
$string['curltimeoutkbitrate'] = 'cURLタイムアウト計算時のビットレート (Kbps)';
$string['curltimeoutkbitrate_help'] = 'この設定は大きなcURLリクエストの適切なタイムアウトを計算するために使用されます。この計算の一環としてコンテンツサイズを決定するためにHTTP HEADリクエストが作成されます。設定値をゼロにした場合、このリクエストの作成が無効にされます。';
$string['currenttheme'] = '現在のテーマ';
$string['customcheck'] = 'その他のチェック';
$string['custommenu'] = 'カスタムメニュー';
$string['custommenuitems'] = 'カスタムメニューアイテム';
$string['customusermenuitems'] = 'ユーザメニューアイテム';
$string['datarootsecurityerror'] = '<p><strong>セキュリティ警告!</strong></p><p>あなたのデータディレクトリは適切ではない場所にあるため、ウェブに晒されています。これはあなたの個人ファイルを世界中の誰でも利用でき、あなたのサイトに対してクラッカーが不正に管理アクセスできることを意味します!</p>
<p>あなたはデータディレクトリ ({$a}) を公開ウェブディレクトリ以外の新しい場所に移動すべきです。それに応じて、あなたのconfig.phpの「<code>$CFG->dataroot</code>」設定を変更してください。</p>';
$string['datarootsecuritywarning'] = 'あなたのサイト設定は安全ではない可能性があります。datarootディレクトリ ({$a}) がウェブから直接アクセスできないことを確認してください。';
$string['dbprefixtoolong'] = 'あなたのサイトのデータベース接頭辞 ($CFG->prefix) が長過ぎます ({$a->current} 文字)。許可される最大文字数は {$a->maximum} です。';
$string['dbsessions'] = 'セッション情報にデータベースを使用する';
$string['debug'] = 'デバッグメッセージ';
$string['debugall'] = 'ALL: すべての妥当なPHPデバッグメッセージを表示する';
$string['debugdeveloper'] = 'DEVELOPER: 開発者のための特別Moodleデバッグメッセージ';
$string['debugdisplay'] = 'デバックメッセージを表示する';
$string['debugging'] = 'デバッグ';
$string['debugminimal'] = 'MINIMAL: 致命的なエラーのみ表示する';
$string['debugnone'] = 'NONE: デバッグ情報を表示しない';
$string['debugnormal'] = 'NORMAL: エラー、警告および注意を表示する';
$string['debugpageinfo'] = 'ページ情報を表示する';
$string['debugsqltrace'] = 'SQLコールの発行元を表示する';
$string['debugsqltrace1'] = '単一コール行のみ表示する';
$string['debugsqltrace100'] = '完全なスタックトレースを表示する';
$string['debugsqltrace2'] = 'スタックトレースの2行を表示する';
$string['debugsqltrace_desc'] = 'この設定を有効にした場合、一部または完全なPHPスタックトレースをSQLにコメントとして追加します。';
$string['debugstringids'] = '言語ストリングの原語を表示する';
$string['debugstringids_desc'] = 'この設定を有効にした場合、ページURLに「?strings=1」または「&strings=1」を付加することにより言語ストリングコンポーネントおよびIDが表示されます。';
$string['debugtemplateinfo'] = 'テンプレート情報を表示する';
$string['debugtemplateinfo_desc'] = 'この設定を有効にした場合、レンダリングに使用されるテンプレートがページのHTMLにコメントとして表示されます。設定変更後、あなたはキャッシュを消去する必要があります。HTMLの検証エラーが発生して一部のページスクリプトが壊れる可能性があるため、一時的なデバッグにのみ使用してください。コアの機能を壊してしまう可能性もあります!';
$string['debugvalidators'] = 'Validatorリンクを表示する';
$string['defaultcity'] = 'デフォルトの都道府県';
$string['defaultcity_help'] = 'ここに入力した都道府県は新しいユーザアカウント作成時のデフォルトの都道府県となります。';
$string['defaultformatnotset'] = 'デフォルトコースフォーマットの決定時にエラーが発生しました。サイト設定を確認してください。';
$string['defaulthomepage'] = 'ユーザのスタートページ';
$string['defaultrequestcategory'] = 'コースリクエストのデフォルトカテゴリ';
$string['defaultsettinginfo'] = 'デフォルト: {$a}';
$string['defaultuserroleid'] = 'すべてのユーザのデフォルトロール';
$string['deletedplugintypesdetected'] = '削除されたプラグイン「 {$a} 」 が検出されました。これは廃止予定期間中に移行またはアンインストールされるはずでした。これは現在サポートされていないプラグインタイプであるため、このプラグインがアンインストールされるまでインストールまたはアップグレードを続行できません。';
$string['deleteduserx'] = 'ユーザ {$a} を削除する';
$string['deleteincompleteusers'] = '不完全なユーザを削除する日数';
$string['deleteunconfirmed'] = 'セットアップ未了のユーザを削除する日数';
$string['deleteuser'] = 'ユーザを削除する';
$string['density'] = '密度';
$string['denyemailaddresses'] = '拒否されるメールアドレスのドメイン';
$string['development'] = '開発';
$string['devicetype'] = 'デバイスタイプ';
$string['devlibdirpresent'] = '特にvendorおよびnode_modulesのような開発ライブラリのディレクトリはパブリックサイトに存在すべきではありません。詳細は<a href="{$a->moreinfourl}">セキュリティ概要レポート</a>をご覧ください。';
$string['disabled'] = '無効';
$string['disableplugin'] = '{$a} 無効にする';
$string['disableuserimages'] = 'ユーザプロファイルイメージを無効にする';
$string['displayerrorswarning'] = 'いくつかのエラーメッセージではあなたのサーバに関する機密情報を公開する場合があるため、実運用サイトでのPHP設定「display_errors」の有効化はお勧めできません。';
$string['displayloginfailures'] = 'ログイン失敗を表示する';
$string['divertallemails'] = 'メール転送';
$string['divertallemailsdetail'] = 'メールテスト時の開発環境のセーフガードとして使用してください。実運用環境では使用しないでください。';
$string['divertallemailsexcept'] = 'メール転送例外';
$string['divertallemailsexcept_desc'] = 'カンマまたは新しい行で区切られたメール例外ルール一覧です。それぞれの行は正規表現として解析されます。例)
<pre>simone@acme.com
.*@acme.com
fred(\\+.*)?@acme.com
</pre>';
$string['divertallemailsto'] = 'すべてのメールを転送する';
$string['divertallemailsto_desc'] = '設定された場合、すべてのメールは代わりにこの単一メールアドレス宛に転送されます。';
$string['dndallowtextandlinks'] = 'テキストおよびリンクのドラッグ＆ドロップアップロード';
$string['doclang'] = 'docsの言語';
$string['docroot'] = 'Moodle Docsドキュメントルート';
$string['doctonewwindow'] = '新しいウィンドウで開く';
$string['doesnotfit'] = 'メール表示設定';
$string['doesnotfitdetail'] = 'Moodleから送信されるメールの表示設定です。';
$string['download'] = 'ダウンロード';
$string['downloadcoursecontentallowed'] = 'コースコンテンツのダウンロード機能利用可能';
$string['downloadcoursecontentallowed_desc'] = 'コースでコースコンテンツのダウンロード機能を利用できるかどうか決定します。利用可能な場合、コース編集メニューの「コースコンテンツのダウンロードを有効にする」設定を使用してコースコンテンツのダウンロードを有効/無効にできます (この設定のデフォルトは<a href={$a} target="_blank">コースデフォルト設定</a>で設定できます)。';
$string['durationunits'] = '継続時間単位';
$string['edithelpdocs'] = 'ヘルプドキュメントを編集する';
$string['editlang'] = '<b>編集</b>';
$string['editorbackgroundcolor'] = '背景色';
$string['editordictionary'] = 'エディタディレクトリ';
$string['editorfontfamily'] = 'フォントファミリ';
$string['editorfontlist'] = 'フォント一覧';
$string['editorfontsize'] = 'フォントサイズ';
$string['editorhidebuttons'] = 'ボタン非表示';
$string['editorkillword'] = 'ワードフォーマットフィルタ';
$string['editorspelling'] = 'エディタスペリング';
$string['editorspellinghelp'] = 'ここではスペルチェックをするかどうか設定します。この設定を有効にした場合、サーバに<strong>aspell</strong> をインストールする必要があります。';
$string['editstrings'] = '翻訳ストリングを編集する';
$string['emailchangeconfirmation'] = 'メール変更確認';
$string['emaildkim'] = 'DKIMメール (DomainKeys Identified Mail) 署名';
$string['emaildkiminfo'] = 'DKIMセレクタが設定されて$CFG->dataroot/dkim/[domain]/[selector].privateのメール「From」アドレスドメインに合致するプライベート証明書ファイルが見つかった場合、メールが署名されます。多くの場合 (例 allowedemaildomainsが空の場合)、<pre>{$a->path}</pre> で単一の証明書のみ必要です。セットアップに関する詳細はドキュメンテーション<a href="{$a->docs}">メール設定</a>をご覧ください。';
$string['emaildkimselector'] = 'DKIMセレクタ';
$string['emailfromvia'] = 'メール送信元情報';
$string['emailheaders'] = 'メールヘッダ';
$string['emailsubjectprefix'] = 'メール件名接頭辞テキスト';
$string['emoticonalt'] = '代替テキスト';
$string['emoticoncomponent'] = 'イメージコンポーネント';
$string['emoticonimagename'] = 'イメージ名';
$string['emoticons'] = 'エモーティコン';
$string['emoticons_desc'] = 'このフォームではあなたのサイトで使用されるエモーティコン (またはスマイリー) を定義します。テーブルから行を削除するにはすべての必須フィールドを空白にして保存してください。新しいエモーティコンを追加するには最後の空白行のフィールドに必要事項を入力してください。すべてのフィールドをデフォルト値にリセットするには上記リンクをクリックしてください。

* テキスト (必須) - このテキストはエモーティコンイメージと置換されます。少なくとも半角2文字を入力してください。
* イメージ名 (必須) - コンポーネントpixフォルダ内のエモーティコンイメージファイル名 (拡張子なし) です。
* イメージコンポーネント (必須) - アイコンを提供するコンポーネントです。
* 代替テキスト (任意) - ストリング識別子およびエモーティコン代替テキストのコンポーネントです。';
$string['emoticonsreset'] = 'エモーティコン設定をデフォルト値にリセットする';
$string['emoticontext'] = 'テキスト';
$string['emptysettingvalue'] = '空';
$string['enableanalytics'] = 'アナリティクス';
$string['enableblogs'] = 'ブログを有効にする';
$string['enablecalendarexport'] = 'カレンダーエクスポートを有効にする';
$string['enablecomments'] = 'コメントを有効にする';
$string['enablecommunicationsubsystem'] = 'コミュニケーションプロバイダを有効にする';
$string['enablecommunicationsubsystem_desc'] = '教師と学生がより簡単にコミュニケーションできるようMatrixのようなコミュニケーションプロバイダとの統合を許可します。あなたはこれらの統合を<a href="settings.php?section=managecommunicationproviders">プラグイン</a>で管理できます。';
$string['enablecourserelativedates'] = 'コース相対日付を有効にする';
$string['enablecourserelativedates_desc'] = 'ユーザのコース開始日に相対的な日付をコースが表示するようセットアップできるようにします。';
$string['enablecourserequests'] = 'コースリクエストを有効にする';
$string['enabled'] = '有効';
$string['enabledashboard'] = 'ダッシュボードを有効にする';
$string['enabledashboard_help'] = 'ダッシュボードにはデフォルトでタイムライン、カレンダー、最近アクセスしたアイテムが表示されます。あなたはすべての人に異なるデフォルトのダッシュボードを設定できます。また、ユーザが自分のダッシュボードをカスタマイズできるようにできます。 無効の場合、あなたは「ユーザの開始ページ」をダッシュボード以外の値に設定する必要があります。';
$string['enableglobalsearch'] = 'グローバル検索を有効にする';
$string['enableglobalsearch_desc'] = 'この設定を有効にした場合、スケジュールタスクによりデータがインデックスおよび同期されます。';
$string['enablegravatar'] = 'Gravatarを有効にする';
$string['enablegravatar_help'] = 'この設定を有効にした場合、ユーザのイメージがアップロードされていない場合にMoodleがGravatartからユーザ画像を取得します。';
$string['enablemobilewebservice'] = 'モバイルデバイスのウェブサービスを有効にする';
$string['enablepdfexportfont'] = 'PDFフォントを有効にする';
$string['enablepdfexportfont_desc'] = '生成されたPDFファイルに他のフォントを必要とする異なる言語のコースがあなたのサイトにある場合、コース設定でフォント設定オプションを提供できます。あなたはconfig.phpの$CFG->pdfexportfontで利用可能なフォントを指定する必要があります。';
$string['enableplugin'] = '{$a} 有効にする';
$string['enablerecordcache'] = 'レコードキャッシュを有効にする';
$string['enablerssfeeds'] = 'RSSフィードを有効にする';
$string['enablesearchareas'] = '検索エリアを有効にする';
$string['enablesharingtomoodlenet'] = 'MoodleNetへの共有を可能にする (外向き)';
$string['enablesharingtomoodlenet_desc'] = 'ユーザに関連するケイパビリティがある場合、設定されたMoodleNetインスタンスにコースコンテンツを共有できるようにします。';
$string['enablestats'] = '統計を有効にする';
$string['enabletrusttext'] = 'コンテンツ信頼を有効にする';
$string['enableuserfeedback'] = 'このソフトウェアに関するフィードバックを有効にする';
$string['enableuserfeedback_desc'] = 'この設定を有効にした場合、ユーザがこのソフトウェアに関するフィードバックをMoodle HQに送信できる「このソフトウェアに関してフィードバックを投稿する」リンクがフッタに表示されます。「次のフィードバックリマインダ」オプションが設定された場合、ユーザには特定の間隔でダッシュボードにリマインダも表示されます。フッタの「このソフトウェアに関してフィードバックを投稿する」リンクそのままにした場合、「次のフィードバックリマインダ」を「なし」に設定することにより、ダッシュボードリマインダを無効にできます。';
$string['enablewebservices'] = 'ウェブサービスを有効にする';
$string['enablewsdocumentation'] = 'ウェブサービスドキュメンテーション';
$string['encryptedpassword_edit'] = '新しい値を入力する';
$string['encryptedpassword_set'] = '(設定および暗号化)';
$string['enroladminnewcourse'] = '管理者を新しいコースに自動登録する';
$string['enroladminnewcourse_help'] = '管理者が新しいコースを追加した場合、新しいコースに自動的に登録して作成者ロールを割り当てます。';
$string['enrolinstancedefaults'] = '登録インスタンスデフォルト';
$string['enrolinstancedefaults_desc'] = '新しいコースのデフォルト登録設定';
$string['enrolmultipleusers'] = 'ユーザを登録する';
$string['entitytasklog'] = 'タスクログ';
$string['environment'] = '動作環境';
$string['environmenterrortodo'] = 'このバージョンのMoodleをインストールする前に、発見された動作環境の問題 (エラー) を解消してください!';
$string['environmenterrorupgrade'] = '警告: このバージョンのMoodleをアップグレードする前に、発見された動作環境の問題 (エラー) を解消してください! これらの必要条件を修正せずにアップグレードした場合、データ喪失等の問題が生じる可能性があります。本当にアップグレードを続けてもよろしいですか?';
$string['environmentmariadbwrongdbtype'] = '正しくない $CFG->dbtype です。あなたのconfig.phpファイルで「mysql」を「mariadb」に変更する必要があります。';
$string['environmentmustfixsetting'] = 'PHP設定を必ず変更してください。';
$string['environmentok'] = 'あなたのサーバ環境は最小限の必要条件すべてに合致します。';
$string['environmentrecommendcustomcheck'] = 'このテストに不適合の場合、潜在的な問題が存在することを意味します。';
$string['environmentrecommendinstall'] = '最適な動作のためインストールおよび有効化してください。';
$string['environmentrecommendversion'] = 'バージョン {$a->needed} 以上を推奨します。あなたは現在 {$a->current} を使用しています。';
$string['environmentrequirecustomcheck'] = 'このテストにパスする必要があります。';
$string['environmentrequireinstall'] = '必ずインストールおよび有効化してください。';
$string['environmentrequireversion'] = 'バージョン {$a->needed} 以上が必須です。あなたは現在 {$a->current} を使用しています。';
$string['environmentsettingok'] = '推奨設定が検出されました。';
$string['environmentshouldfixcustomcheck'] = '最適な動作のため有効化してください。';
$string['environmentshouldfixsetting'] = 'PHP設定を変更してください。';
$string['environmentxmlerror'] = '環境データ ({$a->error_code}) の読み込み中にエラーが発生しました。';
$string['errordeletingconfig'] = 'プラグイン「 {$a} 」の設定レコード削除中にエラーが発生しました。';
$string['errorsetting'] = '設定を保存できませんでした:';
$string['errorwithsettings'] = 'エラーが発生したため、いくつかの設定は変更されませんでした:';
$string['eventshandlersinuse'] = 'あなたのシステムの次のプラグインは廃止予定のハンドラ「 {$a} 」のイベント1APIを使用しています。イベント2APIを使用するよう更新してください。詳細は次をご覧ください: https://docs.moodle.org/dev/Events_API#Event_dispatching_and_observers';
$string['everyonewhocan'] = '「 {$a} 」ことができるユーザすべて';
$string['exceptions'] = '例外';
$string['execpathnotallowed'] = 'config.php内で実行パスおよびローカルパスを無効に設定することができます。';
$string['experimental'] = '実験用';
$string['experimentalsettings'] = '実験用設定';
$string['extendedusernamechars'] = 'ユーザ名に拡張文字を許可する';
$string['extramemorylimit'] = '特別PHPメモリ制限';
$string['fatalsessionautostart'] = '<p>深刻な設定エラーが見つかりました、サーバ管理者に報告してください。</p><p>適切に動作させるため、Moodleは管理者によるPHP設定変更を必要とします。</p><p><code>session.auto_start</code>を<code>off</code>にしてください。</p><p>この設定は<code>php.ini</code>、Apache/IIS <br />設定またはサーバの<code>.htaccess</code>ファイルの編集によりコントロールすることができます。</p>';
$string['favicon'] = 'ファビコン';
$string['favicon_desc'] = 'ファビコンはブラウザタブのページタイトルの横に表示されます。カスタムファビコンが提供されない場合、Moodleファビコンが表示されます。';
$string['feedbacksettings'] = 'フィードバック設定';
$string['fileconversioncleanuptask'] = 'ファイル変換の一時レコードを削除する';
$string['filecreated'] = '新しいファイルが作成されました。';
$string['filescleanupperiod'] = 'ゴミ箱ファイルを削除する';
$string['filescleanupperiod_help'] = 'ゴミ箱ファイルの削除頻度を設定します。例えばコースが削除された場合のようにコンテクストに関連して存在しなくなったファイルがあります。次に留意してください: 「自動バックアップ設定」の「ファイルを含む (backup_auto_files)」が無効にされている場合、この設定によりバックアップおよび削除されたコースファイルをリストア時に喪失することになります。';
$string['filesizeunits'] = 'ファイルサイズ単位';
$string['filestoredin'] = '言語ファイルを保存するフォルダ:';
$string['filestoredinhelp'] = 'ファイルが保存される場所';
$string['filterall'] = 'すべての文字をフィルタする';
$string['filtermatchoneperpage'] = '1ページあたり1回フィルタマッチする';
$string['filtermatchonepertext'] = 'テキストあたり1回フィルタマッチする';
$string['filternavigationwithsystemcontext'] = 'システムコンテクストによるフィルタナビゲーション';
$string['filters'] = 'フィルタ';
$string['filtersettings'] = 'フィルタ設定';
$string['filtersettingsgeneral'] = '一般フィルタ設定';
$string['filteruploadedfiles'] = 'アップロードファイルをフィルタする';
$string['forceclean'] = 'すべての場所のコンテンツをクリーニングする';
$string['forceclean_desc'] = 'サイトに追加されたコンテンツはセキュリティ上の脅威を取り除くため、本来は表示される前にクリーニングされます。しかし、活動の説明、ページリソースまたはHTMLブロックのようにスクリプト、メディア、インラインフレームを追加できる場所ではクリーニングされません。この設定を有効にした場合、すべてのコンテンツはクリーニングされます。これで既存のコンテンツが正常に表示されなくなる場合があります。';
$string['forcelogin'] = 'ユーザにログインを強制する';
$string['forceloginforprofileimage'] = 'ユーザ画像の閲覧にユーザのログインを強制する';
$string['forceloginforprofileimage_help'] = 'この設定を有効にした場合、ユーザプロファイル画像の閲覧時にユーザはログインする必要があります。また、すべての通知メールにおいて、デフォルトのユーザ画像が使用されます。';
$string['forceloginforprofiles'] = 'プロファイル閲覧にユーザのログインを強制する';
$string['forcetimezone'] = 'タイムゾーンを強制する';
$string['formatuninstallwithcourses'] = '{$a->format} を使用しているコースが {$a->count} 件あります。これらのフォーマットは {$a->defaultformat} (このサイトのデフォルトフォーマット) に変更されます。いくつかのフォーマット特有のデータを喪失する場合があります。本当に処理を進めてもよろしいですか?';
$string['frontpage'] = 'サイトホーム';
$string['frontpagebackup'] = 'サイトホームバックアップ';
$string['frontpagedefaultrole'] = 'デフォルトのサイトホームロール';
$string['frontpagefilters'] = 'サイトホームフィルタ';
$string['frontpageloggedin'] = 'ログイン時のサイトホームアイテム';
$string['frontpageoverrides'] = 'サイトホームパーミッションのオーバーライド';
$string['frontpagequestions'] = 'サイトホーム問題';
$string['frontpagerestore'] = 'サイトホームリストア';
$string['frontpageroles'] = 'サイトホームロール';
$string['frontpagesettings'] = 'サイトホーム設定';
$string['fullnamedisplay'] = 'フルネームフォーマット';
$string['fullnamedisplayprivate'] = 'フルネームフォーマット - プライベート';
$string['gdrequired'] = '画像変換のため、MoodleではGD拡張モジュールが必要です。';
$string['generalsettings'] = '一般設定';
$string['geoipdbedition'] = 'GeoIPデータベースエディション';
$string['geoipdbedition_desc'] = 'ダウンロードするGeoIP データベースのエディションを選択してください。GeoIP2-City データベースを使用するには有効な有料ライセンスが必要であることに留意してください。';
$string['geoipfile'] = 'GeoIP City DB';
$string['geoipmaxmindaccid'] = 'MaxMindアカウントID';
$string['geoipmaxmindaccid_desc'] = 'MaxMind APIサービスで作成されたアカウントのアカウントIDです。';
$string['geoipmaxmindlicensekey'] = 'MaxMindライセンスキー';
$string['geoipmaxmindlicensekey_desc'] = 'MaxMind APIサービスで作成されたアカウントのライセンスキーです。';
$string['getremoteaddrconf'] = '記録されるIPアドレスのソース';
$string['globalsearch'] = 'グローバル検索';
$string['globalsearchmanage'] = 'グローバル検索を管理する';
$string['googlemapkey3'] = 'Google Maps API V3キー';
$string['googlemapkey3_help'] = 'あなたはIPアドレスのルックアップを視覚化するために利用するGoogle Mapsの特殊キーを入力する必要があります。あなたは<a href="https://developers.google.com/maps/documentation/javascript/tutorial#api_key" target="_blank">https://developers.google.com/maps/documentation/javascript/tutorial#api_key</a>より、キーを無償で取得することができます。';
$string['gotofirst'] = '最初の未翻訳ストリングに移動する';
$string['gradebook'] = '評定表';
$string['gradebookroles'] = '評定ロール';
$string['gradeexport'] = '主要な評定表エクスポート方法';
$string['gradeexportdefault'] = 'デフォルト評定エクスポート方法';
$string['gravatardefaulturl'] = 'GravatarデフォルトイメージURL';
$string['gravatardefaulturl_help'] = 'Gravatarではユーザ画像が見つからない場合に表示するデフォルトイメージが必要です。イメージの完全なURLを提供してください。デフォルトイメージを生成するためのコードは<a href="https://docs.gravatar.com/api/avatars/images/">Gravatar for Developers - Avatar Requests</a>で利用可能です。';
$string['group_customfield'] = 'グループカスタムフィールド';
$string['groupenrolmentkeypolicy'] = 'デフォルト登録キーポリシー';
$string['groupenrolmentkeypolicy_desc'] = 'この設定を有効にした場合、上の設定で指定されたパスワードポリシーを基にグループ登録キーがチェックされます。';
$string['grouping_customfield'] = 'グルーピングカスタムフィールド';
$string['guestroleid'] = 'ゲストのロール';
$string['guestroleid_help'] = 'このロールは自動的にゲストユーザに割り当てられます。また、パスワードなしで受講できるコースにゲスト登録プラグイン経由で入ったユーザに対しても一時的に割り当てられます。';
$string['h5pgetcontenttypestask'] = '利用可能なH5Pコンテンツをh5p.orgからダウンロードする';
$string['helpadminseesall'] = 'サイトカレンダーにおいて管理者はすべてのコースカレンダーのイベントを閲覧およびフィルタできますか? それとも自分が登録しているコースのカレンダーのみ閲覧およびフィルタできますか? 選択したオプションにかかわらず、管理者は最初にコースに入って直接コースカレンダーにアクセスすることによりそれぞれのコースカレンダーのイベントを管理することができます。';
$string['helpcalendarcustomexport'] = 'カレンダーエクスポートに関して、カスタム日付幅エクスポートを有効にします。この設定を動作させるにはカレンダーエクスポートを有効にする必要があります。';
$string['helpexportlookahead'] = 'カスタムエクスポートオプションによるエクスポート中、イベントに関して、カレンダーは将来の日数を何日考慮しますか?';
$string['helpexportlookback'] = 'カスタムエクスポートオプションによるエクスポート中、イベントに関して、カレンダーは過去の日数を何日考慮しますか?';
$string['helpforcetimezone'] = 'あなたはユーザに独自のタイムゾーンを選択させることができます。またはすべてのユーザに対してタイムゾーンを強制します。';
$string['helpshowicalsource'] = 'この設定を有効にした場合、iCalインポートイベントのiCal購読名およびリンクが表示されます。';
$string['helpsitemaintenance'] = 'アップグレードやその他の作業時に使用します。';
$string['helpstartofweek'] = '何曜日をカレンダーの週の始めとしますか?';
$string['helpupcominglookahead'] = '何日前のイベントをデフォルトで直近イベントとして表示しますか?';
$string['helpupcomingmaxevents'] = '直近イベントをデフォルトで最大何件ユーザに表示しますか?';
$string['helpweekenddays'] = '何曜日を「週末」として異なる色で表示しますか?';
$string['hiddenuserfields'] = 'ユーザフィールドを隠す';
$string['hidefromall'] = 'ユーザすべてに対して非表示にする';
$string['hidefromnone'] = '誰に対しても非表示にしない';
$string['hidefromstudents'] = '学生に対して非表示にする';
$string['hookcallbacknotcallable'] = 'このコールバックは呼び出し可能ではありません。これはクラスまたはメソッドが存在しないか、メソッドがパブリックではない可能性があります。';
$string['hookcallbacks'] = 'コールバック';
$string['hookcallbacks_help'] = 'フックのディスパッチ時に呼び出されるコールバックのリストです。

表示されている順番はコールバックが呼び出される順番です。

優先順位の高いコールバックは優先順位の低いコールバックより先に呼び出されます。';
$string['hookclassmissing'] = 'フッククラスが見つかりませんでした。';
$string['hookclassmissing_desc'] = 'フックディスカバリエージェントが存在しないクラスを返しました。';
$string['hookconfigoverride'] = 'オーバーライド';
$string['hookconfigoverride_help'] = 'このコールバックの定義はサイト設定ファイル (config.php) でオーバーライドされています。';
$string['hookdeprecates'] = '非推奨のコールバックです。';
$string['hookdescription'] = '説明';
$string['hookdescriptionmissing'] = 'フックに説明方法がありません。';
$string['hookname'] = 'フック';
$string['hooksoverview'] = 'フック概要';
$string['hookunknown'] = 'フックが見つかりませんでした。';
$string['hookunknown_desc'] = 'このコールバックがリスニングするオブジェクトは利用できません。削除、リネームまたはMoodleのこのバージョンでは利用できない可能性があります。';
$string['hostname'] = 'ホスト名';
$string['htmleditor'] = 'HTMLエディタ';
$string['htmleditorsettings'] = 'HTMLエディタ設定';
$string['htmlsettings'] = 'HTML設定';
$string['http'] = 'HTTP';
$string['httpsecurity'] = 'HTTPセキュリティ';
$string['iconvrequired'] = 'ICONV拡張モジュールのインストールが必須です。';
$string['igbinary322buggyversion'] = 'このサイトにインストールされているphp-igbinary拡張モジュールをPHP 7.2で動作させた場合、問題が発生する可能性があります。php-igbinary 3.2.5またはそれ以降にアップグレードするか、PHP 7.3またはそれ以降へのアップグレードをお勧めします。';
$string['ignore'] = '無視';
$string['importantupdates_content'] = '<p>Moodle 5.0ではチャットおよび調査活動はコアMoodleから取り除かれます。これらは<a href="https://moodle.org/plugins/">Moodleプラグインディレクトリ</a>でプラグインとして利用できるようになります。</p>
<p>あなたのサイトでチャットまたは調査を継続して使用したい場合、Moodle 5.0にアップグレード時にプラグインとしてインストールできます。</p>';
$string['importantupdates_title'] = 'チャットおよび調査活動に関する重要なお知らせ';
$string['includemoduleuserdata'] = 'モジュールユーザデータを含む';
$string['incompatibleblocks'] = '互換性がないブロック';
$string['incompleteunicodesupport'] = '現在のMySQLまたはMariaDBの設定では「utf8」を使用しています。この文字セットは絵文字を含む4バイト文字をサポートしていません。これらの文字を使用した場合、結果としてレコードのアップデート時にエラーが発生してデータベースに送信されるデータが失われてしまいます。あなたの設定を「utf8mb4」に変更することをお考えください。詳細はドキュメンテーションをご覧ください。';
$string['indexdata'] = 'データをインデックス化する';
$string['indexinginfo'] = 'あなたのサイトコンテンツをインデックス化するための推奨方法は「グローバル検索インデックス化」スケジュールタスクを使用することです。';
$string['installhijacked'] = '申し訳ございません、インストールはオリジナルのIPアドレスから完了する必要があります。';
$string['installsessionerror'] = 'PHPセッションを初期化できません、あなたのブラウザがクッキーを受け付けるかどうか確認してください。';
$string['intlrecommended'] = 'intl拡張モジュールの使用はロケールに関するソート等の国際化サポートを改善します。';
$string['intlrequired'] = 'intl拡張モジュールはロケールのソートおよび国際化ドメイン名等の国際化サポートの改善に必要です。';
$string['invalidagedigitalconsent'] = 'デジタル許可年齢が有効ではありません: {$a}';
$string['invalidforgottenpasswordurl'] = 'パスワード喪失URLが有効なURLではありません。';
$string['invalidsection'] = 'セクションが正しくありません。';
$string['invalidthemepreset'] = '選択されたプリセットファイルはこのテーマに互換性がありません。SCSSコンパイルエラーは次のとおりです: {$a}';
$string['invaliduserchangeme'] = 'ユーザ名「changeme」は予約されています -- あなたはこのユーザ名のアカウントを作成することができません。';
$string['ipblocked'] = '現在、このサイトは利用できません。';
$string['ipblocker'] = 'IPブロッカー';
$string['ipblockersyntax'] = '1行につき1項目を入力してください。有効な項目は単一ホストに合致するフルIPアドレス (例: <b>192.168.10.1</b>)、指定されたIPアドレスで始まる部分アドレス (例: <b>192.168</b>)、CIDR表記 (例: <b>231.54.211.0/20</b>)、またはアドレスの最後の区切りに適用されるIPアドレスの範囲 (例: <b>231.3.56.10-20</b>)  です。「example.com」のようなテキストドメインはサポートされません。空白行および「#」記号以降の文字列は無視されます。';
$string['iplookup'] = 'IPアドレスのルックアップ';
$string['iplookupgeoplugin'] = '現在、<a href="https://www.geoplugin.com">geoPlugin</a> は地理情報を取得するために使用されています。さらに正確な結果を取得するにはローカルへのMaxMind GeoIP Cityデータベースのインストールをお勧めします。';
$string['iplookupinfo'] = 'IPアドレスのロケーションをルックアップするため、MoodleはフリーオンラインNetGeoサーバを利用します。このデータベースは今後メンテナンスされることはなく、不正確なデータを返す可能性があります。<br />
MaxMindからGeoIPデータベースのローカルコピーへのインストールをお勧めします。<br />
Google Maps API V3キーが提供されている場合、IPアドレスの位置はGoogle Mapsを使用して表示されます。あなたはGoogleアカウント必要です。また、Google Maps APIキーの申請も必要です。Google Maps API V3キーが提供されていない場合、IPアドレスの位置はOpenStreetMapを使用して表示されます。';
$string['iplookupmaxmindnote'] = 'この製品は<a href="https://www.maxmind.com/">https://www.maxmind.com/</a>で利用できるMaxMindによって作成されたGeoIP Cityデータを含みます。';
$string['iscustomadminwarnings'] = 'あなたのサイトでカスタム管理ディレクトリの使用が検出されました。この機能はサポートされなくなったため、Moodle 4.2以降に削除されます。';
$string['ishttpswarning'] = 'あなたのサイトでは安全なHTTPSを使用していないことが検出されました。セキュリティを増して他のシステムとの統合を改善するため、あなたのサイトをHTTPSに移行することを強くお勧めします。';
$string['keeptagnamecase'] = 'タグ名の大文字小文字を保持する';
$string['lang'] = 'デフォルト言語';
$string['langcache'] = '言語メニューをキャッシュする';
$string['langcache_desc'] = '言語メニューをキャッシュします。この設定を有効にした場合、利用可能な翻訳一覧がキャッシュされます。あなたがビルトインの言語パック管理ツール経由で言語パックをインストールまたは削除した場合、自動的にキャッシュが更新されます。あなたが手動で新しい言語パックをインストールした場合、すべてのキャッシュを削除する機能を使って、キャッシュリストを更新する必要があります。';
$string['langlist'] = '言語メニューの言語';
$string['langmenu'] = '言語メニューを表示する';
$string['langmenuinsecurelayout'] = 'セキュアレイアウトに言語メニューを表示する';
$string['langmenuinsecurelayout_desc'] = 'この設定を有効にした場合、ユーザはセキュアレイアウト使用中の小テストまたは他の活動受験時に言語を変更できます。';
$string['langpackwillbeupdated'] = '注意: アップグレード中、Moodleは現在の言語パックのアップグレードを試みます。';
$string['langstringcache'] = 'すべての言語ストリングをキャッシュする';
$string['languagesettings'] = '言語設定';
$string['latinexcelexport'] = 'Excelエンコーディング';
$string['legacyfilesaddallowed'] = 'レガシコースファイルの追加を許可する';
$string['legacyfilesaddallowed_help'] = 'コースにレガシコースファイルがある場合、そこに新しいファイルおよびフォルダの追加を許可します。';
$string['legacyfilesinnewcourses'] = '新しいコースのレガシコースファイル';
$string['legacyfilesinnewcourses_help'] = 'デフォルトではレガシコースファイルエリアはアップグレードされたコースでのみ使用することができます。活動のバックアップおよびリストアのようないくつかの機能に関して、この設定の互換性がないことに留意してください。';
$string['libcurlwarning'] = 'CURLOPT_PROTOCOLをサポートしているLibcurlが検出されませんでした。セキュリティ上の理由から、最新版のlibcurlのインストレーションをお勧めします。';
$string['licensesettings'] = 'ライセンス設定';
$string['linkadmincategories'] = 'カテゴリ管理にリンクする';
$string['linkadmincategories_help'] = 'この設定を有効にした場合、カテゴリ管理設定がリンクとしてナビゲーションに表示されます。表示されたリンクにより、カテゴリ管理ページにアクセスすることができます。';
$string['loading'] = '読み込み中';
$string['localetext'] = 'サイト全体のロケール';
$string['localstringcustomization'] = 'ローカルストリングのカスタマイズ';
$string['location'] = 'ロケーション';
$string['locationsettings'] = 'ロケーション設定';
$string['locked'] = 'ロック';
$string['lockoutduration'] = 'アカウントロックアウト継続時間';
$string['lockoutduration_desc'] = 'この時間の後、ロックアウトされたアカウントが自動的にロック解除されます。';
$string['lockoutemailbody'] = '{$a->fullname} さん

サーバ「 {$a->sitename} 」内のあなたのアカウント (ユーザ名: {$a->username}  )  は無効な複数回のログインによりロックアウトされました。

すぐにアカウントをロック解除するには次のアドレスにアクセスしてください。

{$a->link}

ほとんどのメールプログラムではあなたがクリックできる青いリンクとして表示されているはずです。クリックできない場合、あなたのウェブブラウザウィンドウのアドレス欄にアドレスをコピー＆ペーストしてください。

分からないことがある場合、サイト管理者にご連絡ください。
{$a->admin}';
$string['lockoutemailsubject'] = '{$a} のあなたのアカウントはロックアウトされました。';
$string['lockouterrorunlock'] = '無効なアカウントロック解除情報が提供されました。';
$string['lockoutthreshold'] = 'アカウントロックアウト閾値';
$string['lockoutthreshold_desc'] = 'アカウントがロックアウトされるまでのログイン失敗回数を選択してください。この機能はサービス妨害攻撃により悪用される可能性があります。';
$string['lockoutwindow'] = 'アカウントロックアウト監視時間';
$string['lockoutwindow_desc'] = 'ロックアウト閾値の監視時間です。失敗ログインが発生しない場合、この時間の後、閾値カウンターはリセットされます。';
$string['lockrequestcategory'] = 'カテゴリ選択を禁止する';
$string['log'] = 'ログ';
$string['logguests'] = 'ゲストアクセスを記録する';
$string['logguests_help'] = 'この設定ではゲストアクセスおよび未ログインユーザの行動を記録します。パフォーマンスの理由から、高負荷のサイトではこの設定を無効にした方が良いでしょう。実運用サイトではこの設定を有効のままにすることをお勧めします。';
$string['logininfoinsecurelayout'] = 'ログインユーザをセキュアレイアウトに表示する';
$string['logininfoinsecurelayout_desc'] = 'この設定を有効にした場合、セキュアレイアウト使用中の小テストまたは他の活動受験時のナビゲーションバーにログインユーザのフルネームが表示されます。';
$string['loginpageautofocus'] = 'ログインページフォームのオートフォーカス';
$string['loginpageautofocus_help'] = 'この設定を有効にした場合、ログインページのユーザビリティを改善します。しかし、フィールドにオートフォーカスさせる場合、アクセシビリティ問題に関して考慮した方が良いでしょう。';
$string['loglifetime'] = 'ログの保存期間';
$string['logo'] = 'ロゴ';
$string['logo_desc'] = '完全なロゴはいくつかのテーマ (例 コアテーマ) で装飾のために使用されます。使用時に縮小されるため  (およびパフォーマンスのためにキャッシュされるため)、このイメージは極めて高い解像度にすることができます。ロゴは高さより幅が広い方が良い結果となります。';
$string['logocompact'] = 'コンパクトロゴ';
$string['logocompact_desc'] = '上と同じエンブレム、シールドまたはアイコンのようなロゴのコンパクトバージョンです。イメージは小さなサイズでも鮮明なるようにしてください。';
$string['logossettings'] = 'ロゴ';
$string['logstorenotrequired'] = 'ログストア不要';
$string['logstoressupported'] = 'このレポートをサポートするログストア';
$string['longtimewarning'] = '<bこの処理には長時間を要することに留意してください。</b>';
$string['mailnewline'] = 'メールの改行文字';
$string['maintenancemode'] = 'メンテナンスモード';
$string['maintenancemodeisscheduled'] = 'このサイトは {$a->min} 分 {$a->sec} 秒でメンテナンスモードに切り替わります。';
$string['maintenancemodeisscheduledlong'] = 'このサイトは {$a->hour} 時間 {$a->min} 分 {$a->sec} 秒でメンテナンスモードに切り替わります。';
$string['maintfileopenerror'] = 'メンテナンスファイルのオープン中にエラーが発生しました！';
$string['maintinprogress'] = 'メンテナンス処理中です ...';
$string['managecontextlock'] = 'このコンテクストを凍結する';
$string['managecontextlocklocked'] = '{$a->contextname} およびすべての低いコンテクストは現在凍結されています。';
$string['managecontextlockunlocked'] = '{$a->contextname} およびすべての低いコンテクストは現在凍結されていません。';
$string['managecontextunlock'] = 'このコンテクストを凍結解除する';
$string['managecustomfields'] = 'カスタムフィールドタイプを管理する';
$string['manageformats'] = 'コースフォーマットを管理する';
$string['manageformatsgotosettings'] = 'デフォルトフォーマットは {$a} で変更することができます。';
$string['managelang'] = '管理';
$string['manageqbanks'] = '問題バンクプラグインを管理する';
$string['manageqbehaviours'] = '問題動作管理';
$string['manageqtypes'] = '問題タイプ管理';
$string['maturity100'] = 'ベータ';
$string['maturity150'] = 'リリース候補版';
$string['maturity200'] = '安定版';
$string['maturity50'] = 'アルファ版';
$string['maturityallowunstable'] = 'ヒント: あなたは --allow-unstable オプションを付けて、このスクリプトを実行することができます。';
$string['maturitycoreinfo'] = '現在、あなたのサイトでは不安定な「 {$a} 」開発コードが動作しています。';
$string['maturitycorewarning'] = 'あなたは不安定な「 {$a} 」コードを含んだMoodleのバージョンを使ってインストールまたはアップグレードしようとしています。このバージョンはほとんどの実運用サイトに適していません。これがあなたの希望することではない場合、MoodleのSTABLEブランチコードを使って更新するようにしてください。詳細はMoodle Docsをご覧ください。';
$string['maxbytes'] = '最大アップロードファイルサイズ';
$string['maxcharacter'] = '最大文字数: {$a}';
$string['maxconsecutiveidentchars'] = '連続した同一文字';
$string['maxeditingtime'] = '投稿を編集できる最大時間';
$string['maxsizeperdownloadcoursefile'] = 'ファイルごとの最大サイズ';
$string['maxsizeperdownloadcoursefile_desc'] = 'コースコンテンツのダウンロード時のそれぞれのファイルの最大サイズです。このサイズを超えるファイルはダウンロードから除外されます。';
$string['maxtimelimit'] = '最大制限時間';
$string['maxtimelimit_desc'] = 'Moodleが許可するPHP最大実行時間を出力表示なしで制限するにはここに値 (秒) を入力してください。ゼロはMoodleのデフォルト制限が使用されることを意味します。あなたが独自の制限時間を持ったフロントエンドサーバを使用する場合、この値を低くすることでPHPエラーをログに受け付けることになります。CLIスクリプトには適用されません。';
$string['maxusersperpage'] = '1ページあたりのユーザ数';
$string['mbstringrecommended'] = 'サイトパフォーマンスを改善するため、mbstringライブラリのインストールおよび稼動を強くお勧めします。あなたのサイトがラテン文字以外をサポートしている場合、特にお勧めします。';
$string['mbstringrequired'] = '特にあなたのサイトが非ラテン言語をサポートしている場合、サイトパフォーマンスを改善するためmbstringライブラリのインストールは必須です。';
$string['mediapluginavi'] = '.aviフィルタを有効にする';
$string['mediapluginflv'] = '.flvフィルタを有効にする';
$string['mediapluginimg'] = 'リンクイメージの自動埋め込みを有効にする';
$string['mediapluginmov'] = '.movフィルタを有効にする';
$string['mediapluginmp3'] = '.mp3フィルタを有効にする';
$string['mediapluginmpg'] = '.mpgフィルタを有効にする';
$string['mediapluginogg'] = '.oggフィルタを有効にする';
$string['mediapluginogv'] = 'ogvフィルタを有効にする';
$string['mediapluginram'] = '.ramフィルタを有効にする';
$string['mediapluginrm'] = '.rmフィルタを有効にする';
$string['mediapluginrpm'] = '.rpmフィルタを有効にする';
$string['mediapluginwmv'] = '.wmvフィルタを有効にする';
$string['mediapluginyoutube'] = 'YouTubeリンクフィルタを有効にする';
$string['messaging'] = 'メッセージングシステムを有効にする';
$string['messagingallowemailoverride'] = '通知メールのオーバーライド';
$string['messagingallusers'] = 'サイト全体のメッセージングを許可する';
$string['messagingcategory'] = 'メッセージング';
$string['messagingdefaultpressenter'] = 'デフォルトで「Enterで送信する」を有効にする';
$string['messagingdeleteallnotificationsdelay'] = 'すべての通知を削除する';
$string['messagingdeletereadnotificationsdelay'] = '未読通知を削除する';
$string['messagingssettings'] = 'メッセージング設定';
$string['minpassworddigits'] = '数字';
$string['minpasswordlength'] = 'パスワード長';
$string['minpasswordlower'] = '小文字';
$string['minpasswordnonalphanum'] = '非英数字';
$string['minpasswordupper'] = '大文字';
$string['misc'] = 'その他';
$string['mlbackendsettings'] = '機械学習バックエンド設定';
$string['mnetrestore_extusers'] = '<strong>注意:</strong> このバックアップファイルは処理中にリストアされるMoodleネットワークユーザアカウントを含んでいます。';
$string['mnetrestore_extusers_admin'] = '<strong>注意:</strong> このバックアップファイルは他のMoodleで作成され、Moodleネットワークユーザアカウントを含んでるようです。リストア処理ではすべての作成済みユーザにMoodleネットワークホストでのマッチングを試みます。合致しないユーザは (mnet認証の代わりに) 自動的に内部認証へ切り替えられます。あなたはこの処理に関する情報をリストアログで閲覧することができます。';
$string['mnetrestore_extusers_mismatch'] = '<strong>注意:</strong> このバックアップファイルは他のMoodleで作成され、リストアできないMoodleネットワークユーザアカウントを含んでいます。この処理はサポートされていません。バックアップファイルがこのMoodleでバックアップされたこと、または必要なすべてのMoodleネットワークホストが設定されていることをあなたが保証できる場合のみ、リストアを試みてください。';
$string['mnetrestore_extusers_noadmin'] = '<strong>注意:</strong> このバックアップファイルは他のMoodleで作成されMoodleネットワークユーザアカウントを含んでいます。あなたはこのタイプのリストア処理の実行を許可されていません。サイト管理者に連絡するか代わりにこのコースをユーザ情報なし (モジュール、ファイル ...) でリストアしてください。';
$string['mnetrestore_extusers_switchuserauth'] = 'リモートMoodleネットワークユーザ {$a->username} ({$a->mnethosturl}) がローカル {$a->auth} 認証済みユーザに切り替えられました。';
$string['mobilenotconfiguredwarning'] = 'Moodleアプリは有効にされていません。';
$string['modassignmentinuse'] = 'あなたのサイトはまだ課題2.2プラグインを使用しています。アップグレードする前にあなたは 1) 課題活動を保持してリストアできるようにするために課題2.2活動をバックアップした後、2) データベースから課題2.2データすべてを削除する必要があります。';
$string['modassignmentsubpluginsexist'] = '課題 2.2のサブプラグインが存在する可能性があります。アップグレードする前にmod/assignmentフォルダおよびそのサブプラグインすべてを削除する必要があります。';
$string['modeditdefaults'] = '活動設定のデフォルト値';
$string['modsettings'] = '活動を管理する';
$string['modulesecurity'] = 'モジュールセキュリティ';
$string['moodlebrandedapp'] = 'ブランドMoodleアプリ';
$string['moodlebrandedappreference'] = '代わりにあなたのカスタムブランドの<a href="https://moodle.com/branded-app/">ブランドMoodleアプリ</a>を入手してください。';
$string['mustenablestats'] = 'このサイトでは統計が有効にされていません。';
$string['mycourses'] = 'マイコース';
$string['mydashboard'] = 'システムデフォルダッシュボード';
$string['mymoodle'] = 'ダッシュボード';
$string['mypage'] = 'デフォルトダッシュボードページ';
$string['mypagelocked'] = 'デフォルトページをロックする';
$string['myprofile'] = 'デフォルトプロファイルページ';
$string['navadduserpostslinks'] = 'ユーザ投稿閲覧のためのリンクを追加する';
$string['navadduserpostslinks_help'] = 'この設定を有効にした場合、それぞれのユーザに2つのリンクがナビゲーション内に追加されます。1つはユーザが開始したディスカッションを閲覧するため、もう1つはサイト全体または特定のコース内フォーラムでユーザが投稿した内容を閲覧するためです。';
$string['navcourselimit'] = 'コース制限';
$string['navfilter'] = 'カスタムメニューをフィルタする';
$string['navfilter_desc'] = '<strong>コンテンツおよびヘッディング</strong>に適用されるように設定されたMoodleフィルタでカスタムメニューを処理します。動的カスタムメニューアイテムを有効にするのに有用です。';
$string['navigationupgrade'] = 'このアップグレードでは次のブロックに替えて、新しい2つのナビゲーションブロックが導入されます: 管理、コース、活動および参加者。これらのブロックに特別なパーミッションを設定している場合、すべてがあなたの希望どおりに動作するか確認してください。';
$string['navshowallcourses'] = 'すべてのコースを表示する';
$string['navshowcategories'] = 'コースカテゴリを表示する';
$string['navshowfrontpagemods'] = 'ナビゲーションにサイトホーム活動を表示する';
$string['navshowfrontpagemods_help'] = 'この設定を有効にした場合、サイトページ下のナビゲーションにサイトホーム活動が表示されます。';
$string['navshowfullcoursenames'] = 'コースフルネームを表示する';
$string['navshowfullcoursenames_help'] = 'この設定を有効にした場合、ナビゲーションに省略名ではなくコースフルネームが使用されます。';
$string['navshowmycoursecategories'] = 'マイコースカテゴリを表示する';
$string['navshowmycoursecategories_help'] = 'この設定を有効にした場合、ナビゲーションブロック (クラシックベースのテーマのみ) のカテゴリ内にユーザのマイコースが表示されます。';
$string['navsortmycourseshiddenlast'] = '私の非表示コースを最後に並べ替える';
$string['navsortmycourseshiddenlast_help'] = 'この設定を有効にした場合、すべての非表示コースは表示コースの後に一覧表示されます (非表示コースを表示できるユーザに対して)。そうでない場合、すべてのコースは可視性にかかわらず、「マイコースを並べ替える」設定に基づき一覧表示されます。';
$string['navsortmycoursessort'] = 'ナビゲーションブロックのコースを並べ替える';
$string['navsortmycoursessort_help'] = '「サイト管理 > コース >  コースおよびカテゴリを管理する」で設定された並べ替え順に従ってコースを一覧表示しますか? それともコース設定によるアルファベット順で表示しますか? この設定はクラシックをベースにしたテーマにのみ適用されます。';
$string['never'] = 'なし';
$string['neverdeleteruns'] = '実行結果を削除しない';
$string['newestdocindexed'] = 'インデックス化された最新ドキュメント';
$string['nobookmarksforuser'] = 'あなたのブックマークはありません。';
$string['nodatabase'] = 'データベースなし';
$string['noemaileverwarning'] = '<strong>注意:</strong> すべての送信メールは無効になっています。';
$string['nohttpsformobilewarning'] = '有効な証明書のHTTPSを有効にすることをお勧めします。Moodle appは常に最初にセキュアコネクションの使用を試みます。';
$string['nomissingstrings'] = '未翻訳ストリングはありません。';
$string['none'] = 'なし';
$string['nonewsettings'] = 'このアップグレードで新しい設定は追加されませんでした。';
$string['nonexistentbookmark'] = 'あなたがリクエストしたブックマークは登録されていません。';
$string['noreplyaddress'] = 'no-replyアドレス';
$string['noreplydomain'] = 'no-replyおよびドメイン';
$string['noreplydomaindetail'] = 'no-replyおよびドメインを設定します。';
$string['noresults'] = '該当するデータは見つかりませんでした。';
$string['noroles'] = 'ロールなし';
$string['nosupportedlogstore'] = 'サポートされたログストアは見つかりませんでした。';
$string['noteunneededblocks'] = '注意: ブロックがテーマ設定「不要ブロック」で指定された場合、表示するよう設定されたブロックはコース内の「ブロックを追加する」メニューには表示されません。';
$string['notifications'] = '通知';
$string['notifyloginfailures'] = 'ログイン失敗をメール通知する';
$string['notifyloginthreshold'] = 'メール通知の閾値';
$string['notloggedinroleid'] = 'ビジターのロール';
$string['numberofmissingstrings'] = '未翻訳ストリング数: {$a}';
$string['numberofstrings'] = '合計ストリング数: {$a->strings}<br />未翻訳数: {$a->missing} ({$a->missingpercent}&nbsp;%)';
$string['oauthrefreshtokenexpired'] = 'あなたのサイト {$a->siteurl} のOAuthサービス {$a->issuer} のリフレッシュトークンの1つの有効期限が切れました。これでこのサービスを利用しているすべてのプラグインの機能が制限されます。この問題を解決するにはOAuth 2サービス設定ページに移動してこのサービスのテーブル行にある「システムアカウントに接続する」アイコンをクリックしてください。毎回必ずOAuthシステムの同じサービスアカウントを使用してログインしてください。';
$string['oauthrefreshtokenexpiredshort'] = 'あなたのサイト {$a->siteurl} の {$a->issuer} のOAuthリフレッシュトークンの有効期限が切れました。';
$string['onlynoreply'] = 'no-replyアドレスからの場合のみ';
$string['opcacherecommended'] = 'PHP OPcacheキャッシングはパフォーマンスを改善して、必要メモリを減らします。OPcache拡張モジュールは推奨および完全にサポートされます。';
$string['opensslrecommended'] = 'Moodleネットワーキング機能を有効にするため、OpenSSLライブラリのインストールを強くお勧めします。';
$string['opensslrequired'] = '現在、強固なCryptographicサービスを提供するためMoodleはOpenSSL PHP拡張モジュールを必要とします。';
$string['opentowebcrawlers'] = 'Googleに公開する';
$string['optionalmaintenancemessage'] = '任意のメンテナンスメッセージ';
$string['order1'] = '1番目';
$string['order2'] = '2番目';
$string['order3'] = '3番目';
$string['order4'] = '4番目';
$string['outgoingmailconfig'] = '送信メール設定';
$string['overridetossl'] = 'HTTPSログインは廃止されました。このインスタンスはSSLに強制されています。この警告を改善するにはあなたのconfig.php内の「wwwroot」を「https://」に変更してください。';
$string['pageinfodebugsummary'] = 'このページ: {$a}';
$string['passwordchangelogout'] = 'パスワード変更後、ログアウトする';
$string['passwordchangelogout_desc'] = 'この設定を有効にした場合、新しいパスワードの設定を除いてパスワード変更後にすべてのブラウザセッションが終了されます (この設定はバルクユーザアップロードのパスワード変更には影響しません)。';
$string['passwordchangetokendeletion'] = 'パスワード変更後、ウェブサービスアクセストークンを削除する';
$string['passwordchangetokendeletion_desc'] = 'この設定を有効にした場合、パスワード変更後、すべてのユーザウェブサービスアクセストークンが削除されます。';
$string['passwordpolicy'] = 'パスワードポリシー';
$string['passwordpolicycheckonlogin'] = 'ログイン時にパスワードをチェックする';
$string['passwordresettime'] = 'パスワードリセットリクエスト確認の最大時間';
$string['passwordreuselimit'] = 'パスワードローテーション制限';
$string['passwordreuselimit_desc'] = 'ユーザがパスワードの再利用を許可されるまでにパスワードを変更する必要のある回数です。前に使用されたパスワードのハッシュがローカルデータベーステーブルに保存されます。この機能はいくつかの外部認証プラグインと併用できません。';
$string['pathtodot'] = 'dotのパス';
$string['pathtodot_help'] = 'dotのパスを指定してください。Linuxでは「/usr/bin/dotの」ようになります。Windowsでは「C:\\Program Files (x86)\\Graphviz2.38\\bin\\dot.exe」のようになります。Macでは「/opt/local/bin/dot」のようになります。DOTファイルからグラフィックを生成するにはあなたはdot実行ファイルをインストールした後、ここでパスを指定する必要があります';
$string['pathtodu'] = 'duのパス';
$string['pathtogs'] = 'Ghostscriptのパス';
$string['pathtogs_help'] = 'ほとんどのLinuxインストールの場合、ここは「/usr/bin/gs」のままにしてください。Windowsでは「c:\\gs\\bin\\gswin32c.exe」のようになります (パスの間にスペースがないことを確認してください - 必要であれば、ファイル「gswin32c.exe」および「gsdll32.dll」をパス内にスペースを入れずに新しいフォルダにコピーしてください)。';
$string['pathtopdftoppm'] = 'pdftoppmのパス';
$string['pathtopdftoppm_help'] = '<a href="https://poppler.freedesktop.org/">Poppler</a>はPDF レンダリングライブラリでPDFファイルをPNGに変換するツールpdftoppmが含まれます。一般的にGhostscriptを使用した場合よりパフォーマンスが良く、特に大きなファイルの場合に良くなります。利用可能な場合、Ghostscriptに優先してpdftoppmが使用されます。ほとんどのLinuxインストールではパスを「/usr/bin/pdftoppm」のままにできます。そうでない場合、あなたのLinuxディストリビューションに応じてpoppler-utilsまたはpopplerパッケージをインストールする必要があります。WindowsではCygwinインストールで提供されます。';
$string['pathtopgdump'] = 'pg_dumpのパス';
$string['pathtopgdumpdesc'] = 'あなたのシステムに2つ以上のpg_dumpが存在する場合 (例 2つ以上のバージョンのpostgresqlがインストールされている場合) のみ入力する必要があります。';
$string['pathtopgdumpinvalid'] = 'pg_dumpのパスが正しくありません - パスが間違っているか実行可能ではありません。';
$string['pathtophp'] = 'PHP CLIのパス';
$string['pathtopsql'] = 'psqlのパス';
$string['pathtopsqldesc'] = 'あなたのシステムに2つ以上のpsqlが存在する場合 (例 2つ以上のバージョンのpostgresqlがインストールされている場合) のみ入力する必要があります。';
$string['pathtopsqlinvalid'] = 'psqlのパスが正しくありません - パスが間違っているか実行可能ではありません。';
$string['pathtopython'] = 'Pythonのパス';
$string['pathtopythondesc'] = 'あなたのPython実行バイナリのパスです (Python 2およびPython 3の両方とも設定可能です)。';
$string['pathtosassc'] = 'SassCのパス';
$string['pathtosassc_help'] = 'SassCバイナリのロケーションを指定することによりSASSコンパイラをMoodleのPHP実装からSassCに変更します。詳細はhttps://github.com/sass/sasscをご覧ください。';
$string['pcreunicodewarning'] = 'ユニコード文字への互換性のため、PCRE PHP拡張モジュールの使用を強くお勧めします。';
$string['perfdebug'] = 'パフォーマンス情報';
$string['perfdebugdeferred'] = 'パフォーマンスデバッギングを表示するにはスクリプトが終了するまでお待ちください ...';
$string['performance'] = 'パフォーマンス';
$string['pgcluster'] = 'PostgreSQLクラスタ';
$string['pgclusterdescription'] = 'コマンドライン処理のためのPostgreSQLバージョン/クラスタパラメータです。あなたのシステムに1つのPostgreSQLのみある場合、またはこの設定が分からない場合、空白にしてください。';
$string['phpfloatproblem'] = 'PHP浮動数の処理に予期しない問題が発見されました - {$a}';
$string['pid'] = 'PID';
$string['pleaserefreshregistration'] = 'あなたのサイトが登録されました。登録は {$a} に更新されました。あなたの登録を「サイト登録」スケジュールタスクが最新状態に更新します。いつでもあなたの登録を手動更新することもできます。';
$string['pleaserefreshregistrationnewdata'] = '登録情報が更新されました。「登録を更新する」ボタンを使用して内容を確認してください。';
$string['pleaserefreshregistrationunknown'] = 'あなたのサイトは登録されましたが、日付が不明です。あなたの登録を「登録を更新する」ボタンを使用して更新するかあなたの登録を自動更新するよう「サイト登録」スケジュールタスクが有効にされているか確認してください。';
$string['plugin'] = 'プラグイン';
$string['plugin_disabled'] = '{$a} が無効にされました。';
$string['plugin_enabled'] = '{$a} が有効にされました。';
$string['plugins'] = 'プラグイン';
$string['pluginscheck'] = 'プラグイン依存関係チェック';
$string['pluginscheckfailed'] = '{$a->pluginslist} の依存関係チェックに失敗しました。';
$string['pluginschecktodo'] = 'このMoodleバージョンをインストールする前に、あなたはすべてのプラグイン必要条件を解決する必要があります!';
$string['pluginsoverview'] = 'プラグイン概要';
$string['pluginsoverviewsee'] = '詳細は<a href="{$a->url}">プラグイン概要</a>ページをご覧ください。';
$string['policysettings'] = 'ポリシー設定';
$string['privacy:metadata'] = '管理プラグインはいかなる個人データも保存しません。';
$string['privacyandpolicies'] = 'プライバシーおよびポリシー';
$string['privacysettings'] = 'プライバシー設定';
$string['profilecategory'] = 'カテゴリ';
$string['profilecategoryname'] = 'カテゴリ名 (ユニークにしてください)';
$string['profilecategorynamenotunique'] = 'このカテゴリ名はすでに使用されています。';
$string['profilecommonsettings'] = '共通設定';
$string['profileconfirmcategorydeletion'] = 'このカテゴリには上記 (トップカテゴリの場合は以下) カテゴリに移動される {$a} 個のフィールドが含まれています。<br />本当にこのカテゴリを削除してもよろしいですか?';
$string['profileconfirmfielddeletion'] = 'このフィールドには削除される {$a} 名のユーザレコードが含まれています。<br />本当にこのフィールドを削除してもよろしいですか?';
$string['profilecreatecategory'] = '新しいプロファイルカテゴリを作成する';
$string['profilecreatefield'] = '新しいプロファイルフィールドを作成する';
$string['profilecreatenewcategory'] = '新しいカテゴリの作成';
$string['profilecreatenewfield'] = '新しいプロファイルフィールド「 {$a} 」の作成';
$string['profiledefaultcategory'] = 'その他のフィールド';
$string['profiledefaultchecked'] = 'デフォルトでチェックする';
$string['profiledefaultdata'] = 'デフォルト値';
$string['profiledeletecategory'] = 'カテゴリの削除';
$string['profiledeletefield'] = 'フィールド「 {$a} 」の削除';
$string['profiledescription'] = 'フィールド説明';
$string['profiledscript'] = 'このスクリプトはプロファイルされました。';
$string['profiledscriptview'] = 'このスクリプトのプロファイリング情報を表示する';
$string['profileeditcategory'] = 'カテゴリの編集: {$a}';
$string['profileeditfield'] = 'プロファイルフィールドの編集: {$a}';
$string['profilefield'] = 'プロファイルフィールド';
$string['profilefieldcolumns'] = '列';
$string['profilefieldispassword'] = 'これはパスワードフィールドですか?';
$string['profilefieldlink'] = 'リンク';
$string['profilefieldlink_help'] = 'テキストをリンクに変換するには$$を含んだURLを入力してください。$$はテキストと置換されます。例えばTwitter IDをリンクに変換したい場合、次のように入力してください: https://twitter.com/$$';
$string['profilefieldlinktarget'] = 'リンクターゲット';
$string['profilefieldmaxlength'] = '文字制限';
$string['profilefieldmaxlength_help'] = 'このフィールドを「表示するユーザ固有情報」設定で使用する場合、制限は半角255文字以下にしてください。';
$string['profilefieldrows'] = '行';
$string['profilefields'] = 'ユーザプロファイルフィールド';
$string['profilefieldsize'] = '表示サイズ';
$string['profileforceunique'] = 'データがユニークである必要がありますか?';
$string['profileinvaliddata'] = '値が有効ではありません。';
$string['profilelocked'] = 'このフィールドをロックしますか?';
$string['profilemenudefaultnotinoptions'] = 'デフォルト値がオプションの1つではありません。';
$string['profilemenunooptions'] = 'メニューオプションを入力してください。';
$string['profilemenuoptions'] = 'メニューオプション (1行あたり１つ)';
$string['profilemenutoofewoptions'] = 'あなたは少なくとも2つのオプションを入力する必要があります。';
$string['profilename'] = '名前';
$string['profilenofieldsdefined'] = '定義されているフィールドはありません。';
$string['profilerequired'] = 'このフィールドは必須入力ですか?';
$string['profileroles'] = 'プロファイル可視ロール';
$string['profilesforenrolledusersonly'] = 'プロファイルを登録済みユーザにのみ表示する';
$string['profileshortname'] = '省略名 (ユニークにしてください)';
$string['profileshortnameinvalid'] = 'この省略名には半角英数字 (文字および数字) またはアンダースコア (_)のみ含むことができます。';
$string['profileshortnamenotunique'] = 'この省略名はすでに使用されています。';
$string['profilesignup'] = 'サインアップページに表示しますか?';
$string['profilespecificsettings'] = '詳細設定';
$string['profilevisible'] = 'このフィールドを誰に表示しますか?';
$string['profilevisible_help'] = '* 非表示 - 管理者およびマネージャのみ閲覧できる個人情報です。
* ユーザに表示する - ユーザおよび管理者のみ閲覧できる個人情報です。
* ユーザ、教師および管理者に表示する - (コースプロファイルの) ユーザ、教師および管理者 のみ閲覧できる個人情報です。
* すべての人に表示する';
$string['profilevisibleall'] = 'すべての人に表示する';
$string['profilevisiblenone'] = '非表示';
$string['profilevisibleprivate'] = 'ユーザに表示する';
$string['profilevisibleteachers'] = 'ユーザ、教師および管理者に表示する';
$string['profiling'] = 'プロファイリング';
$string['profilingallowall'] = '継続プロファイリング';
$string['profilingallowall_help'] = 'この設定を有効にした場合、あなたはいつでもどこでも (PGC) Moodleセッションにおける実行スクリプトすべてをプロファイリングするため、PROFILEALLパラメータを使用することができます。同様にスクリプトを停止するため、あなたはPROFILEALLSTOPパラメータを使用することもできます。';
$string['profilingallowme'] = '選択的プロファイリング';
$string['profilingallowme_help'] = 'この設定を有効にした場合、あなたは選択的にどこでも (PGC) Moodleセッションにおける実行スクリプトをプロファイリングするため、PROFILEMEパラメータを使用することができます。同様にプロファイリングの実行を回避するため、あなたはDONTPROFILEMEパラメータを使用することもできます。';
$string['profilingautofrec'] = '自動プロファイリング';
$string['profilingautofrec_help'] = 'このオプションを設定することで、いくつかのリクエスト (指定された頻度に基づいて - 1/ N) が選択されて、継続解析結果を保存するために自動的にプロファイルされます。このプロファイリングでは「組み込み/除外」設定を参照することに留意してください。ゼロを設定した場合、自動プロファイリングは無効にされます。';
$string['profilingenabled'] = 'プロファイリングを有効にする';
$string['profilingenabled_help'] = 'この設定を有効にした場合、このサイト内でプロファイリングを使用できるようになります。あなたは次のオプションでプロファイリングの動作を定義することができます。';
$string['profilingexcluded'] = 'プロファイリングを除外する';
$string['profilingexcluded_help'] = '「これらをプロファイルする」設定で定義されたプロファイリングからプロファイリングを除外するための (wwwrootを除いたカンマ区切りまたは新しい行区切りの実行可能な絶対パスの) URL一覧です。';
$string['profilingimportprefix'] = 'プロファイリングインポート接頭辞';
$string['profilingimportprefix_desc'] = '簡単に探すことができるようインポート済みプロファイリング実行すべてに対して、ここで指定した値の接頭辞が付加されます。';
$string['profilingincluded'] = 'これらをプロファイルする';
$string['profilingincluded_help'] = '自動的にプロファイルされる (wwwrootを除いたカンマ区切りまたは新しい行区切りの実行可能な絶対パスの) URL一覧です。例: /index.php, /course/view.php また、どのような場所であってもワイルドカード (*) を使用することができます。例:  /mod/forum/*, /mod/*/view.php';
$string['profilinglifetime'] = 'プロファイリング実行を保持する';
$string['profilinglifetime_help'] = 'あなたが古いプロファイリング実行を保持したい期間を指定してください。古いプロファイリングは定期的に削除されます。ここでは「参照実行」としてマークされたプロファイリングを除外することに留意してください。';
$string['profilingslow'] = 'スローページをプロファイルする';
$string['profilingslow_help'] = '最小時間 (秒) を設定した場合、設定した時間より遅いすべてのページはプロファイルされます。同じスクリプトで既存のプロファイルがある場合、より遅いものが保持されます。ゼロを設定することで無効にできます。この監視は設定を除外することに留意してください。';
$string['protectusernames'] = 'ユーザ名を保護する';
$string['proxybypass'] = 'プロキシバイパスホスト';
$string['proxyfixunsafe'] = 'プロキシされないコールを修正する';
$string['proxyhost'] = 'プロキシホスト';
$string['proxylogunsafe'] = 'プロキシされないコールを記録する';
$string['proxypassword'] = 'プロキシパスワード';
$string['proxyport'] = 'プロキシポート';
$string['proxytype'] = 'プロキシタイプ';
$string['proxyuser'] = 'プロキシユーザ名';
$string['purgecaches'] = 'すべてのキャッシュを削除する';
$string['purgecachesconfirm'] = 'Moodleはテーマ、JavaScript、言語ストリング、フィルタされたテキスト、RSSフィードおよびその他の計算されたデータをキャッシュできます。キャッシュを削除した場合、サーバからデータが削除されてブラウザはデータを再取得するようになります。キャッシュの削除に危険性はありませんが、サーバおよびクライアントが新しい情報を計算してキャッシュするまでのしばらくの間、あなたのサイトが遅く表示される場合がります。';
$string['purgecachesfinished'] = 'すべてのキャッシュが削除されました。';
$string['purgecachesnoneselected'] = '削除するキャッシュを1つまたはそれ以上選択してください。';
$string['purgecachespage'] = 'キャッシュを削除する';
$string['purgecoursecache'] = 'コース';
$string['purgefiltercache'] = 'テキストフィルタ';
$string['purgejscache'] = 'JavaScript';
$string['purgelangcache'] = '言語ストリング';
$string['purgemuc'] = 'すべてのMUCキャッシュ';
$string['purgeothercaches'] = 'すべてのファイルおよび各種キャッシュ';
$string['purgeselectedcaches'] = '選択されたキャッシュを削除する';
$string['purgeselectedcachesfinished'] = '選択されたキャッシュが削除されました。';
$string['purgetemplates'] = 'テンプレート';
$string['purgethemecache'] = 'テーマ';
$string['query'] = 'クエリ';
$string['question'] = '問題';
$string['questionbehaviours'] = '問題動作';
$string['questioncwqpfscheck'] = '1つまたはそれ以上の小テストの「ランダム」問題が共有および非共有カテゴリから混在して選択されるように設定されています。<a href="{$a->reporturl}">ランダム問題レポート</a>および<a href="{$a->docsurl}">ドキュメンテーション</a>をご覧ください。';
$string['questioncwqpfsok'] = '素晴らしい。あなたの小テストでは共有および非共有カテゴリから混在して選択されるように設定されている「ランダム」問題はありません。';
$string['questiontype'] = '問題タイプ';
$string['questiontypes'] = '問題タイプ';
$string['quizattemptsupgradedmessage'] = 'Moodle 2.1において、問題の大幅なアップグレードがありました。また、データベースアップグレードの一部を後で実行するよう遅らせることができました。Moodle 2.7へアップグレードする前に、このアップグレードを完了する必要があります。';
$string['recaptchaprivatekey'] = 'reCAPTCHA秘密鍵';
$string['recaptchapublickey'] = 'reCAPTCHAサイトキー';
$string['referrernone'] = 'ブラウザデフォルト';
$string['referrerpolicy'] = 'リファラポリシー';
$string['referrerpolicydesc'] = 'あなたのサイトからのレスポンスに含むためのリファラポリシーのヘッダを設定します。';
$string['register'] = 'あなたのサイトを登録する';
$string['registration'] = '登録';
$string['registration_help'] = '登録することにより:

* あなたはセキュリティ警告を受信します。
* あなたのサイトからのモバイルアプリプッシュ通知を有効にできます。
* あなたは私たちの世界規模のコミュニティのMoodle統計に貢献できます。';
$string['registrationwarning'] = '重要なアップデートおよびセキュリティアラートを見逃さないようにしてください。';
$string['registrationwarningcontactadmin'] = 'このサイトは登録されていません。重要な更新を見逃さないためにも管理者にサイトの登録をご依頼ください。';
$string['releasenoteslink'] = 'このバージョンのMoodleに関する詳細情報はオンライン<a target="_blank" href="{$a}">リリースノート</a>をご覧ください。';
$string['rememberuserlicensepref'] = 'ユーザライセンスプレファレンスを記憶する';
$string['rememberuserlicensepref_help'] = 'この設定を有効にした場合、ユーザが最後に選択したライセンスがファイルピッカでのファイルアップロード時に事前選択されます。そうでない場合、デフォルトサイトライセンスが事前選択されます。';
$string['rememberusername'] = 'ユーザ名を記憶する';
$string['rememberusername_desc'] = 'ユーザログイン中、あなたがユーザ名を永続クッキーに保存したい場合、この設定を有効にしてください。同意なしに使用した場合、永続的クッキーはプライバシー問題であると考えられる可能性があります。';
$string['replacefrontsearch'] = 'サイトホームコース検索に使用する';
$string['reportsmanage'] = 'レポートを管理する';
$string['required'] = '必須';
$string['requiredentrieschanged'] = '注意: アップグレード後、設定「閲覧の前にエントリを必要とする」が次のデータベース活動で強制されます:<br/>{$a->text}<br/>';
$string['requiremodintro'] = '活動説明を必須とする';
$string['requiremodintro_desc'] = 'この設定を有効にした場合、ユーザはそれぞれの活動の説明の入力を強制されます。';
$string['requires'] = '必要条件';
$string['resetindentation'] = 'サイト全体のインデントをリセットする';
$string['resetindentation_help'] = 'これでサイト内のすべてのコースの {$a->format} で設定されていたインデントが解除されます。';
$string['resetindentation_title'] = 'サイト全体のインデントをリセットしてもよろしいですか?';
$string['resetindentationsuccess'] = 'インデントがリセットされました。';
$string['restorecourse'] = 'コースをリストアする';
$string['restorernewroleid'] = 'コース内でのリストア担当者ロール';
$string['restorernewroleid_help'] = '新しくリストアされるコースを管理するためのパーミッションがすでに割り当てられていない場合、ユーザに対して自動的にこのロールが割り当てられます。同時に必要であればコースに登録されます。あなたがリストア済みコースすべてを管理できるようにしたくない場合、「なし」を選択してください。';
$string['resultfilter'] = '結果でフィルタする';
$string['reverseproxy'] = 'リバースプロキシ';
$string['reverseproxyignore'] = 'リバースプロキシを無視する';
$string['riskconfig'] = 'ユーザはサイト設定および動作を変更することができます。';
$string['riskconfigshort'] = '設定リスク';
$string['riskdataloss'] = 'ユーザは大量のコンテンツまたは情報を破壊することができます。';
$string['riskdatalossshort'] = 'データ喪失リスク';
$string['riskmanagetrust'] = 'ユーザは他のユーザの信頼度設定を変更することができます。';
$string['riskmanagetrustshort'] = '信頼度管理';
$string['riskpersonal'] = 'ユーザは他のユーザの個人情報にアクセスすることができます。';
$string['riskpersonalshort'] = 'プライバシーリスク';
$string['riskspam'] = 'ユーザはサイトユーザまたはそれ以外にスパムを送信することができます。';
$string['riskspamshort'] = 'スパムリスク';
$string['riskxss'] = 'ユーザはクロスサイトスクリプティング (XSS) を許すファイルおよびテキストを追加することができます。';
$string['riskxssshort'] = 'XSSリスク';
$string['roleswithexceptions'] = '{$a->roles} および {$a->exceptions}';
$string['rssglobaldisabled'] = 'サイトレベルで無効済み';
$string['save'] = '保存';
$string['savechanges'] = '変更を保存する';
$string['scssinvalid'] = 'SCSSコードが有効ではありません。エラー理由: {$a}';
$string['search'] = '検索';
$string['searchablecourses'] = '検索可能コース';
$string['searchallavailablecourses'] = '検索可能コース';
$string['searchallavailablecourses_desc'] = '大量のコースを検索する場合、検索エンジンが動作しないことも考えられます。あなたがコース検索数を制限したい場合、登録済みコースのみ検索するよう設定してください。';
$string['searchallavailablecourses_off'] = '登録済みコース内のみ検索する';
$string['searchallavailablecourses_on'] = 'ユーザがアクセス可能なコースすべてを検索する';
$string['searchallavailablecoursesdesc'] = '登録済みコースのみを検索するよう設定した場合、コース情報 (名称および概要) およびコースコンテンツのみユーザが登録しているコースで検索されます。そうでない場合、例えばゲストアクセスが有効にされているコースのようにユーザがアクセスできるコースすべてのコース情報およびコースコンテンツが検索されます。';
$string['searchalldeleted'] = 'すべてのインデックスコンテンツが削除されました。';
$string['searchalternatesettings'] = 'クエリ専用代替設定';
$string['searchalternatesettings_desc'] = 'これらの設定を完了した場合、あなたは「グローバル検索を管理する」ページのクエリ専用検索エンジンオプションでこの検索エンジンに「代替設定」を選択できます。これは同じタイプの2つの検索エンジン間を移動する場合のみ有用です。';
$string['searchareadisabled'] = '検索エリア無効';
$string['searchareaenabled'] = '検索エリア有効';
$string['searchareas'] = '検索エリア';
$string['searchbanner'] = '検索情報';
$string['searchbannerenable'] = '検索情報を表示する';
$string['searchbannerenable_desc'] = 'この設定を有効にした場合、以下のテキストがすべてのユーザの検索画面の最上部に表示されます。これは検索エンジンのメンテナンス実施中、ユーザに通知するため使用できます。';
$string['searchdefaultcategory'] = 'デフォルト検索カテゴリ';
$string['searchdefaultcategory_desc'] = '選択された検索エリアカテゴリの結果がデフォルトで表示されます。';
$string['searchdeleteindex'] = 'すべてのインデックスコンテンツを削除する';
$string['searchdisplay'] = '検索結果表示オプション';
$string['searchenablecategories'] = '別々のカテゴリに結果を表示する';
$string['searchenablecategories_desc'] = 'この設定を有効にした場合、検索結果は別々のカテゴリに表示されます。';
$string['searchengine'] = '検索エンジン';
$string['searchenginealternatesettings'] = '{$a} (代替設定)';
$string['searchenginequeryonly'] = 'クエリ専用検索エンジン';
$string['searchenginequeryonly_desc'] = 'この検索エンジンはインデックス化ではなくクエリ作成にのみ使用されます。あなたはこの機能を使用することにより継続してこの検索エンジンからユーザクエリを動作させつつ異なる検索エンジンを再インデックス化できます。';
$string['searchenginequeryonly_none'] = 'なし (クエリにメイン検索エンジンを使用する)';
$string['searchenginequeryonlysame'] = 'クエリ専用検索エンジンおよびメイン検索エンジンを同じ値に設定できません。';
$string['searchhideallcategory'] = 'すべての結果カテゴリを隠す';
$string['searchhideallcategory_desc'] = 'この設定を有効にした場合、すべての結果カテゴリは検索結果画面から非表示にされます。';
$string['searchincludeallcourses'] = 'すべての可視コースを含む';
$string['searchincludeallcourses_desc'] = 'この設定を有効にした場合、ユーザがコースコンテンツにアクセスできない場合でも検索結果にはユーザが閲覧できるコース情報 (名称および概要) を含みます。';
$string['searchindexactions'] = 'インデックス操作';
$string['searchindexdeleted'] = 'インデックスが削除されました。';
$string['searchindextime'] = 'インデックス化制限時間';
$string['searchindextime_desc'] = '大量の新しいコンテンツをインデックス化する場合、この制限時間後にスケジュールタスクは停止します。次回タスク実行時にインデックス化を再開します。';
$string['searchindexupdated'] = 'サーチエンジンコンテンツが更新されました。';
$string['searchindexwhendisabled'] = '無効時にインデックス化する';
$string['searchindexwhendisabled_desc'] = '検索が無効にされている場合でもスケジュールタスクによる検索インデックスの構築を許可します。これはあなたが学生に検索機能を表示する前にインデックスを構築したい場合に有用です。';
$string['searchinsettings'] = '設定検索';
$string['searchlastrun'] = '最終実行 (# ドキュメント、# レコード、# 除外)';
$string['searchmanagement'] = '検索管理';
$string['searchmanagement_desc'] = 'このオプションは再構築に長時間を要する非常に大きな検索インデックスのサイト変更時に有用です。';
$string['searchmaxtopresults'] = '最大上位結果';
$string['searchmaxtopresults_desc'] = 'コースコンテンツ、コースおよびユーザの検索結果の上に表示される最高ランクの結果の最大数です。';
$string['searchnotavailable'] = '検索は利用できません。';
$string['searchoptions'] = '検索オプション';
$string['searchpartial'] = '(まだ完全にはインデックス化されていません)';
$string['searchreindexed'] = 'すべてのサイトコンテンツがインデックス化されました。';
$string['searchreindexindex'] = 'すべてのサイトコンテンツを再インデックス化する';
$string['searchresults'] = '検索結果';
$string['searchsetupinfo'] = '検索設定';
$string['searchteacherroles'] = '教師ロール';
$string['searchteacherroles_desc'] = 'ロールランカーのユーザが検索結果で上位になるロールをすべて選択してください。';
$string['searchtopresults'] = '上位結果';
$string['searchupdateindex'] = 'インデックスコンテンツを更新する';
$string['sectionerror'] = 'セクションエラー!';
$string['secureforms'] = '追加的なフォームセキュリティを使用する';
$string['security'] = 'セキュリティ';
$string['selectsearchengine'] = '検索エンジンを選択する';
$string['server'] = 'サーバ';
$string['serverchecks'] = 'サーバチェック';
$string['serverlimit'] = 'サーバリミット';
$string['servicespage'] = 'サービスおよびサポートリンク';
$string['sessionautostartwarning'] = '<p>深刻な設定エラーが検出されました。サーバ管理者に通知してください。</p><p>Moodleを適切に動作させるためにはPHPの設定変更を必要とします。</p><p><code>session.auto_start</code>を<code>off</code>にしてください。</p><p>この設定は<code>php.ini</code>、 Apache/IIS設定またはサーバの<code>.htaccess</code>ファイルを使用して管理することができます。</p>';
$string['sessioncookie'] = 'クッキー接頭辞';
$string['sessioncookiedomain'] = 'クッキードメイン';
$string['sessioncookiepath'] = 'クッキーパス';
$string['sessionhandling'] = 'セッションハンドリング';
$string['sessiontimeout'] = 'タイムアウト';
$string['sessiontimeoutwarning'] = 'タイムアウト警告';
$string['settingdependenton'] = 'この設定は「 {$a} 」の値に基づき非表示にできます。';
$string['settingfileuploads'] = 'ファイルアップロードは通常の操作に必要です。PHP設定で有効にしてください。';
$string['settingmaxinputvars'] = 'PHP設定「max_input_vars」は少なくとも5000以上を推奨します。';
$string['settingmaxinputvarsrequired'] = 'PHP設定「max_input_vars」は少なくとも5000以上にする必要があります。';
$string['settingmemorylimit'] = 'メモリ不足が検出されました。PHP設定でメモリ制限を現在より高く設定してください。';
$string['settingsafemode'] = 'Moodleではセーフモードに完全な互換性はありません。サーバ管理者にセーフモードの無効化を依頼してください。セーフモードでのMoodleの動作はサポートされていません。Moodleをセーフモードで動作させる場合、様々な問題が発生する可能性があります。';
$string['settingzendexceptionignoreargs'] = 'セキュリティ対策のため、PHP設定「zend.exception_ignore_args」の有効化を強くお勧めします。';
$string['setupsearchengine'] = '検索エンジンを設定する';
$string['showcommentscount'] = 'コメント総数を表示する';
$string['showdetails'] = '詳細を表示する';
$string['showuseridentity'] = '表示するユーザ固有情報';
$string['showuseridentity_desc'] = 'ユーザの選択および検索、またユーザ一覧を表示する場合、これらのフィールドはユーザのフルネームの横に表示されます。フィールドは「moodle/site:viewuseridentity」ケイパビリティを持ったユーザにのみ、デフォルトでは教師およびマネージャにのみ表示されます (あなたの組織で1つまたは2つのフィールドを必須入力にした場合、このオプションは最も意味をなします)。

「*」がマークされたフィールドはカスタムユーザプロファイルフィールドです。あなたはこれらのフィールドを選択できますが、現在、画面に表示されないフィールドもあります。';
$string['simplexmlrequired'] = '現在、MoodleにはSimpleXML PHP拡張モジュールが必要です。';
$string['sitemailcharset'] = '文字セット';
$string['sitemaintenance'] = 'このサイトはメンテナンス中です。現在ご利用いただけません。';
$string['sitemaintenancemode'] = 'メンテナンスモード';
$string['sitemaintenanceoff'] = 'メンテナンスモードが解除されました。サイトは正常に動作しています。';
$string['sitemaintenanceon'] = 'あなたのサイトは現在メンテナンスモードで運用されています (管理者のみログインまたはサイトを利用することができます)。';
$string['sitemaintenanceoncli'] = '現在、あなたのサイトはCLIメンテナンスモードで運用されています。ウェブアクセスは許可されません。';
$string['sitemaintenancetitle'] = '{$a} メンテナンス中';
$string['sitemaintenancewarning'] = 'あなたのサイトは現在メンテナンスモードで運用されています (管理者のみログインできます)。通常運用に戻すには<a href="maintenance.php">メンテナンスモードを解除してください</a>。';
$string['sitemaintenancewarning2'] = 'あなたのサイトは現在メンテナンスモードで運用されています (管理者のみログインできます)。通常運用に戻すには<a href="{$a}">メンテナンスモードを解除してください</a>。';
$string['sitemenubar'] = 'サイトナビゲーション';
$string['sitenameintitle'] = 'ページタイトルにサイト名を含む';
$string['sitenameintitle_help'] = 'この設定によりページタイトルの最後にサイト名が追加されます。ユーザが現在いるページをすぐに特定できるようになりサイトのアクセシビリティが向上するため、ページタイトルにサイト名を含めることを推奨します。';
$string['sitepolicies'] = 'サイトセキュリティ設定';
$string['sitepolicy'] = 'サイトポリシーURL';
$string['sitepolicy_help'] = 'すべての登録済みユーザがサイトにアクセスする前に閲覧および同意する必要のあるサイトポリシーのURLです。この設定はサイトポリシーハンドラがデフォルト (コア) に設定されている場合のみ影響する点に留意してください。';
$string['sitepolicyguest'] = 'ゲストのサイトポリシーURL';
$string['sitepolicyguest_help'] = 'すべてのゲストがサイトにアクセスする前に閲覧および同意する必要のあるサイトポリシーのURLです。この設定はサイトポリシーハンドラがデフォルト (コア) に設定されている場合のみ影響する点に留意してください。';
$string['sitepolicyhandler'] = 'サイトポリシーハンドラ';
$string['sitepolicyhandler_desc'] = 'ここではポリシーおよびユーザ同意がどのように管理されるか決定します。デフォルト (コア) ハンドラはサイトポリシーURLを有効にしてゲストのサイトポリシーURLを指定します。ポリシーハンドラはサイト、プライバシおよび他のポリシーを有効にして設定します。ユーザ同意を閲覧できるようにもします。必要であれば未成年の代わりに同意することもできます。';
$string['sitepolicyhandlercore'] = 'デフォルト (コア)';
$string['sitepolicyhandlerplugin'] = '{$a->name} ({$a->component})';
$string['sitesectionhelp'] = 'あなたがカスタムコンテンツを追加できるセクションをページ上部に表示します。';
$string['sixtyfourbitsrequired'] = 'あなたのサイトでは64ビットPHPバージョンが使用されていないことが検出されました。あなたはこのMoodleバージョンをインストールする前にシステム (オペレーティングシステム、PHP...) をアップグレードする必要があります。';
$string['sixtyfourbitswarning'] = 'あなたのサイトは64ビットのPHPバージョンを使用していないことが検出されました。将来的な互換性を保証するため、あなたのサイトをアップグレードすることをお勧めします。';
$string['slasharguments'] = 'スラッシュ引数を使用する';
$string['slashargumentswarning'] = '「スラッシュ引数を使用する」を有効にすることをお勧めします。これは将来的に必須となります。詳細はドキュメンテーション「<a href="https://docs.moodle.org/en/admin/environment/slasharguments">Using slash arguments</a>.」をご覧ください。';
$string['smallscreensonly'] = '小型スクリーンのみ';
$string['smtp'] = 'SMTP';
$string['smtpauthtype'] = 'SMTP認証タイプ';
$string['smtpdetail'] = 'メールを送信するためのSMTP (Simple Mail Transfer Protocol) 設定です。';
$string['smtphosts'] = 'SMTPホスト';
$string['smtpmaxbulk'] = 'SMTPセッション制限';
$string['smtppass'] = 'SMTPパスワード';
$string['smtpsecure'] = 'SMTPセキュリティ';
$string['smtpuser'] = 'SMTPユーザ名';
$string['soaprecommended'] = '任意のSOAP拡張モジュールをインストールすることはウェブサービスおよびいくつかのプラグインに有用です。';
$string['sort_fullname'] = '長いコース名';
$string['sort_idnumber'] = 'コースIDナンバ';
$string['sort_shortname'] = 'コース省略名';
$string['sort_sortorder'] = '並べ替え順';
$string['spellengine'] = 'スペルエンジン';
$string['spelllanguagelist'] = 'スペル言語リスト';
$string['splrequired'] = '現在、MoodleではSPL PHP拡張モジュールを必要とします。';
$string['stats'] = '統計';
$string['statsfirstrun'] = '最大処理間隔';
$string['statsmaxruntime'] = '最大実行時間';
$string['statsmoodleorg'] = '統計';
$string['statsruntimedays'] = '処理日数';
$string['statsruntimestart'] = '開始時刻';
$string['statsuserthreshold'] = 'ユーザ閾値';
$string['stickyblocks'] = 'スティッキーブロック';
$string['stickyblockscourseview'] = 'コースページ';
$string['stickyblocksduplicatenotice'] = 'あなたがここで追加するブロックがすでに特定のページに登録されている場合、ブロックが重複することになります。<br />この場合、固定ブロックのみ編集不可となりますが、重複したブロックは編集することができます。';
$string['stickyblocksmymoodle'] = 'マイMoodle';
$string['stickyblockspagetype'] = '設定するページタイプ';
$string['storedprogressbarcleanuptask'] = '保存されたプログレスバーのクリーンアップタスク';
$string['strictformsrequired'] = '必須フィールドの厳密な妥当性確認';
$string['stripalltitletags'] = 'すべての活動名からHTMLタグを取り除く';
$string['supportandservices'] = 'サポートおよびサービス';
$string['supportavailability'] = 'サポート利用';
$string['supportcontact'] = 'サポート連絡先';
$string['supportemail'] = 'サポートメール';
$string['supportemailsubject'] = 'サイトサポートリクエスト - {$a}';
$string['supportname'] = 'サポート名';
$string['supportpage'] = 'サイトサポート連絡リンク';
$string['suspenduser'] = 'ユーザアカウントを利用停止する';
$string['swaggerui'] = 'Moodle REST API UI (SwaggerUI)';
$string['switchlang'] = '言語ディレクトリを切り替える';
$string['systempaths'] = 'システムパス';
$string['tablenosave'] = '上のテーブル内の変更は自動的に保存されます。';
$string['tablesnosave'] = '上のテーブル内の変更は自動的に保存されます。';
$string['tabselectedtofront'] = 'タブ付きテーブルにおいて、現在選択されているタブを最前部に表示します。';
$string['tabselectedtofronttext'] = '選択されたタブを最前部に表示する';
$string['task_adhoc_concurrency_limit'] = 'アドホックタスク同時実行制限';
$string['task_adhoc_concurrency_limit_desc'] = '同時に実行できるアドホックタスクランナー数です。制限が高い場合、そして多くのアドホックがある場合、スケジュールタスクを定期的に実行できなくなります。ゼロに設定した場合、アドホックタスク処理は完全に無効にされます。';
$string['task_adhoc_failed_retention'] = '失敗したアドホックタスクの保存期間';
$string['task_adhoc_failed_retention_desc'] = '失敗したアドホックタスクが再試行回数制限に達した後、キューに残される最大期間です。';
$string['task_adhoc_max_runtime'] = 'アドホックタスクランナー生存期間';
$string['task_adhoc_max_runtime_desc'] = 'アドホックランナーが取り除かれるまでの時間です。キューに入れられるアドホックタスク数の制限がなくなるよう低い継続期間を推奨します。この数が高すぎる場合、そして多くのアドホックタスクがキューに入れられる場合、スケジュールタスクを定期的に実行できなくなります。';
$string['task_dbreads'] = 'データベース読み込み';
$string['task_dbstats'] = 'データベース';
$string['task_dbwrites'] = 'データベース書き込み';
$string['task_duration'] = '期間';
$string['task_endtime'] = '終了時間';
$string['task_logmode'] = 'ログの記録タイミング';
$string['task_logmode_all'] = 'すべてのジョブのログアウトプットを保存する';
$string['task_logmode_desc'] = 'あなたはタスクがログに記録されるタイミングを選択できます。デフォルトではログは常に取得されます。あなたはログの記録を完全に無効にすること、またはタスクが失敗した場合のみログに記録することができます。';
$string['task_logmode_failonly'] = '失敗したジョブのログのみ保存する';
$string['task_logmode_none'] = '何もログに記録しない';
$string['task_logoutput'] = 'タスクアウトプット';
$string['task_logretainruns'] = '実行保持';
$string['task_logretainruns_desc'] = '保持するタスクの実行数です。この設定は「保持期間」設定に関連します。どちらか最初に達した方が適用されます。';
$string['task_logretention'] = '保持期間';
$string['task_logretention_desc'] = 'ログが存続する最大期間です。この設定は「実行保持」設定と関連します。どちらか最初に達した方が適用されます。';
$string['task_logtostdout'] = 'ログアウトプットを表示する';
$string['task_logtostdout_desc'] = 'ログ実行中にアウトプットが取得された場合、取得されたアウトプットもタスク実行として表示するかどうか指定します。';
$string['task_result'] = '結果';
$string['task_result:failed'] = '失敗';
$string['task_scheduled_concurrency_limit'] = 'スケジュールタスク同時実行制限';
$string['task_scheduled_concurrency_limit_desc'] = '同時に実行できるスケジュールタスクランナー数です。制限が高い場合、サーバにはパフォーマンスに影響する高い負荷がかかってしまう可能性があります。ゼロに設定した場合、スケジュールタスク処理が完全に無効にされます。';
$string['task_scheduled_max_runtime'] = 'スケジュールタスクランナー生存期間';
$string['task_scheduled_max_runtime_desc'] = 'スケジュールタスクが取り除かれるまでの時間です。';
$string['task_starttime'] = '開始日時';
$string['task_stats:dbreads'] = '{$a} 読み込み';
$string['task_stats:dbwrites'] = '{$a} 書き込み';
$string['task_status'] = 'タスクステータス';
$string['task_status_desc'] = 'タスク「 {$a->name} 」は {$a->status} の状態です。詳細は<a href="{$a->gotourl}">スケジュールタスク</a>の {$a->class}{$a->extradescription} をご覧ください。';
$string['task_type:adhoc'] = 'アドホック';
$string['task_type:scheduled'] = 'スケジュール';
$string['taskadmintitle'] = 'タスク';
$string['taskanalyticscleanup'] = 'アナリティクスクリーンアップ';
$string['taskautomatedbackup'] = '自動バックアップ';
$string['taskautomatedbackup_report'] = '自動バックアップレポート';
$string['taskbackupcleanup'] = 'バックアップテーブル、ログおよびファイルを削除する';
$string['taskbadgesadhoc'] = 'バッジ授与';
$string['taskbadgescron'] = 'バッジ授与アドホックタスクを追加する';
$string['taskbadgesmessagecron'] = 'バッジ通知を送信するためのバックグランド処理';
$string['taskblogcron'] = '外部ブログを同期する';
$string['taskcachecleanup'] = '有効期限切れキャッシュエントリを削除する';
$string['taskcachecron'] = 'キャッシュのバックグランド処理';
$string['taskcalendarcron'] = 'カレンダー通知を送信する';
$string['taskcheckforupdates'] = '更新をチェックする';
$string['taskcompletiondaily'] = '完了マーク開始';
$string['taskcompletionregular'] = '標準完了データを計算する';
$string['taskcontextcleanup'] = 'コンテクストをクリーンアップする';
$string['taskcreatecontexts'] = '不足しているコンテクストを作成する';
$string['taskdeleteincompleteusers'] = '不完全なユーザを削除する';
$string['taskdeleteunconfirmedusers'] = '確認未了のユーザを削除する';
$string['taskeventscron'] = 'イベントのバックグラウンド処理';
$string['taskfiletrashcleanup'] = 'ゴミ箱のファイルを削除する';
$string['taskglobalsearchindex'] = 'グローバル検索インデックス化';
$string['taskglobalsearchoptimize'] = 'グローバル検索インデックス最適化';
$string['taskgradecron'] = '評定表のバックグラウンド処理';
$string['taskgradehistorycleanup'] = '評定履歴テーブル削除のバックグラウンド処理';
$string['taskh5pcleanup'] = '未使用H5Pファイルのクリーンアップ';
$string['tasklegacycron'] = 'プラグインのレガシcron処理';
$string['tasklockcleanuptask'] = 'アドホックタスクメタデータをクリーンアップする';
$string['tasklogcleanup'] = 'タスクログのクリーンアップ';
$string['tasklogging'] = 'タスクログ設定';
$string['tasklogs'] = 'タスクログ';
$string['taskmessagingcleanup'] = 'メッセージングのバックグラウンド処理';
$string['taskpasswordresetcleanup'] = 'パスワードリセットの試みを削除する';
$string['taskplagiarismcron'] = '盗作プラグインのレガシcronによるバックグラウンド処理';
$string['taskportfoliocron'] = 'ポートフォリオプラグインのバックグラウンド処理';
$string['taskprocessing'] = 'タスク処理';
$string['taskquestioncron'] = '問題プレビューを削除するためのバックグラウンド処理';
$string['taskquestionstatscleanupcron'] = '問題統計キャッシュをクリーンアップするためのバックグラウンド処理';
$string['taskrefreshsystemtokens'] = 'サービスアカウントOAuthトークンをリフレッシュする';
$string['taskregistrationcron'] = 'サイト登録';
$string['tasksendfailedloginnotifications'] = 'ログイン失敗通知を送信する';
$string['tasksendnewuserpasswords'] = '新しいユーザパスワードを送信する';
$string['tasksessioncleanup'] = '古いセッションを削除する';
$string['taskstatscron'] = '統計のバックグラウンド処理';
$string['tasktagcron'] = 'タグのバックグラウンド処理';
$string['tasktempfilecleanup'] = '古い一時ファイルを削除する';
$string['tasktype'] = 'タイプ';
$string['taskupdategeoip2file'] = 'GeoIPファイルを更新する';
$string['tempdatafoldercleanup'] = '次より古い一時データファイルを削除する';
$string['templates'] = 'テンプレート';
$string['testoutgoingmailconf'] = '送信メール設定をテストする';
$string['testoutgoingmailconf_errorcommunications'] = 'あなたのサイトはあなたのメールサーバに接続できませんでした。あなたの送信メール設定を確認してください。';
$string['testoutgoingmailconf_fromemail'] = '送信元ユーザ名またはメールアドレス';
$string['testoutgoingmailconf_fromemail_help'] = 'このフィールドはユーザからのメッセージ送信をエミュレートしますが、実際に送信されるメールで使用されるFromヘッダは「allowedemaildomains」等の他の設定に依存します。';
$string['testoutgoingmailconf_fromemail_invalid'] = 'Fromのユーザ名またはメールアドレスが無効です。有効なメールフォーマットまたはMoodleの既存のユーザ名である必要があります。';
$string['testoutgoingmailconf_message'] = 'これはあなたのサイトの送信メールが正常に設定されたことを確認するためのテストメッセージです。送信日時: {$a}';
$string['testoutgoingmailconf_sendtest'] = 'テストメッセージを送信する';
$string['testoutgoingmailconf_sentmail'] = 'このサイトがテストメッセージをメールサーバへ正常に送信しました。<br />送信元: {$a->fromemail}<br />送信先: {$a->toemail}';
$string['testoutgoingmailconf_subject'] = '{$a->site}: テストメッセージ {$a->additional} 送信日時: {$a->time}';
$string['testoutgoingmailconf_subjectadditional'] = '追加件名';
$string['testoutgoingmailconf_toemail'] = '送信先メールアドレス';
$string['testoutgoingmaildetail'] = '注意: テストする前にあなたの設定を保存してください。<br />{$a}';
$string['testsiteupgradewarning'] = '現在、あなたは {$a} テストサイトを使用しています。適切にアップグレードするにはコマンドラインインタフェースツールを使用してください。';
$string['themedefinedinconfigphp'] = 'config.phpでテーマが {$a} で設定されているためテーマを変更できません。';
$string['themedesignermode'] = 'テーマデザイナモード';
$string['themedesignermodewarning'] = 'テーマデザイナモードが有効にされています。パフォーマンスを著しく低下させるため、実運用サイトでは有効にすべきではありません。';
$string['themeeditsettingsname'] = 'テーマ設定「 {$a} 」を編集する';
$string['themelist'] = 'テーマリスト';
$string['themeresetcaches'] = 'テーマキャッシュをクリアする';
$string['themeselect'] = 'テーマを変更する';
$string['themeselector'] = 'テーマ';
$string['themesettingsadvanced'] = '高度なテーマ設定';
$string['themesettingscustom'] = 'カスタムテーマ設定';
$string['themesettingsname'] = 'テーマ設定「 {$a} 」';
$string['themeusagereportname'] = 'テーマ使用レポート「 {$a} 」';
$string['therewereerrors'] = 'あなたのデータにエラーがあります。';
$string['thirdpartylibrary'] = 'ライブラリ';
$string['thirdpartylibrarylocation'] = 'ロケーション';
$string['thirdpartylibs'] = 'サードパーティライブラリ';
$string['timezone'] = 'デフォルトタイムゾーン';
$string['timezoneforced'] = 'サイト管理者によって強制されています。';
$string['timezoneinvalid'] = '無効なタイムゾーン「 {$a} 」';
$string['timezoneisforcedto'] = 'すべてのユーザに使用を強制する';
$string['timezonenotforced'] = 'ユーザは独自のタイムゾーンを使用できる';
$string['timezonephpdefault'] = 'デフォルトPHPタイムゾーン ({$a})';
$string['timezoneserver'] = 'サーバタイムゾーン ({$a})';
$string['tlswarning'] = 'TLSv1.2をサポートするPHP/cURL拡張モジュールが検出されませんでした。いくつかのサービスは動作しません。あなたのTLSライブラリのアップグレードを強くお勧めします。';
$string['tokenduration'] = 'ユーザ作成トークンの持続時間';
$string['tokenduration_desc'] = 'ユーザ  (例えばモバイルアプリ) によって新しく作成されたトークンが有効な時間です。';
$string['tokenizerrecommended'] = 'PHP Tokenizer拡張モジュールのインストールをお勧めします - Moodleネットーワーキングの機能性を改善します。';
$string['tools'] = '管理ツール';
$string['toolsmanage'] = '管理ツール管理';
$string['unattendedoperation'] = '無人オペレーション';
$string['unbookmarkthispage'] = 'このページをブックマーク解除する';
$string['unicoderequired'] = 'すべてのデータはユニコードフォーマット (UTF-8) で保存する必要があります。新しいインストールの場合、データベースのデフォルト文字セットをUTF-8にする必要があります。アップグレードする場合、あなたはUTF-8移行処理に従う必要があります。';
$string['uninstallplugin'] = 'アンインストール';
$string['unlockaccount'] = 'アカウントをロック解除する';
$string['unoconvwarning'] = 'あなたがインストールしているunoconvのバージョンはサポートされません。';
$string['unsupported'] = '未サポート';
$string['unsupporteddbfileformat'] = 'あなたのデータベーステーブルはファイルフォーマットにAntelopeを使用しています。MySQLおよびMariaDBでUTF-8をフルサポートするにはBarracudaファイルフォーマットが必要です。Barracudaファイルフォーマットに変更してください。<a href="https://docs.moodle.org/en/admin/environment/custom check/mysql full unicode support">MySQLフルユニコードサポート</a>の詳細に関してドキュメンテーションをご覧ください。';
$string['unsupporteddbfilepertable'] = 'MySQLおよびMariaDBをUTF-8フルサポートにするにはあなたのMySQL設定「innodb_file_per_table」を「ON」にする必要があります。詳細はドキュメンテーションをご覧ください。';
$string['unsupporteddblargeprefix'] = 'MySQLおよびMariaDBをUTF-8フルサポートにするにはあなたのMySQL設定「innodb_large_prefix」を「ON」にする必要があります。詳細はドキュメンテーションをご覧ください。';
$string['unsupporteddbstorageengine'] = '使用されているデータベースストレージエンジンは今後サポートされません。';
$string['unsupporteddbtablerowformat'] = 'あなたのデータベースはファイルフォーマットとしてAntelopeを使用しています。Barracudaファイルフォーマットへのテーブルコンバートをお勧めします。InnoDBテーブルのBarracudaへのコンバートツールに関して詳細は<a href="https://docs.moodle.org/en/cli">コマンドラインによる管理</a>をご覧ください。';
$string['unsupportedphpversion7'] = 'PHPバージョン7以降はサポートされません。';
$string['unsupportedphpversion71'] = 'PHPバージョン7.1以降はサポートされません。';
$string['unsupportedphpversion72'] = 'PHPバージョン7.2以降はサポートされません。';
$string['unsupportedphpversion73'] = 'PHPバージョン7.3以降はサポートされません。';
$string['unsupportedphpversion74'] = 'PHPバージョン7.4以降はサポートされません。';
$string['unsupportedphpversion80'] = 'PHP version 8.0以降はサポートされません。';
$string['unsupportedphpversion81'] = 'PHP version 8.1以降はサポートされません。';
$string['unsupportedphpversion82'] = 'PHPバージョン8.2以降はサポートされません。';
$string['unsupportedphpversion83'] = 'PHPバージョン8.3以上はサポートされません。';
$string['unsupportedphpversion84'] = 'PHPバージョン8.4およびそれ以上はサポートされていません。';
$string['unsuspenduser'] = 'ユーザアカウントを有効にする';
$string['updateaccounts'] = '既存のアカウントを更新する';
$string['updateautocheck'] = '利用可能な更新を自動チェックする';
$string['updateautocheck_desc'] = 'この設定を有効にした場合、あなたのサイトはMoodleコードおよびすべての追加プラグインの更新を自動的にチェックします。新しい更新が利用可能な場合、サイト管理者に通知が送信されます。';
$string['updateavailable'] = '利用可能な新しいバージョンのMoodleがあります!';
$string['updateavailable_moreinfo'] = '詳細情報 ...';
$string['updateavailable_release'] = 'Moodle {$a}';
$string['updateavailable_version'] = 'バージョン {$a}';
$string['updateavailabledetailslink'] = '詳細は {$a->url} をご覧ください。';
$string['updateavailableforplugin'] = 'あなたのプラグインに利用可能な新しいバージョンがあります!';
$string['updateavailableinstall'] = 'この更新をインストールする';
$string['updateavailableinstallall'] = '利用可能な更新をインストールする ({$a})';
$string['updateavailableinstallallhead'] = '利用可能な更新のインストール';
$string['updateavailablenot'] = 'あなたのMoodleコードは最新版です!';
$string['updateavailablerecommendation'] = '最新のセキュリティおよびバグフィックスを適用するため、あなたのサイトの最新バージョンへのアップデートを強くお勧めします。';
$string['updatecomponent'] = 'コンポーネントを更新する';
$string['updateminmaturity'] = '要求されるコード完成度';
$string['updateminmaturity_desc'] = '少なくとも選択された完成度に達したコードがある場合、利用可能な更新に関して通知します。プラグインがコードの完成度を宣言していない場合、この設定にかかわらず常に報告されます。';
$string['updatenotificationfooter'] = 'あなたのMoodleサイト {$a->siteurl} は利用可能な更新を自動チェックするよう設定されています。あなたはサイト管理者としてメッセージを受信しています。あなたは「サイト管理 / サーバ / 更新通知」で利用可能な更新の自動チェックを無効にできます。また、あなたのプレファレンスページでこのメッセージの配信に関してカスタマイズできます。';
$string['updatenotifications'] = '更新通知';
$string['updatenotificationsubject'] = 'Moodle更新利用可能 ({$a->siteurl})';
$string['updatenotifybuilds'] = '新しいビルドに関して通知する';
$string['updatenotifybuilds_desc'] = 'この設定を有効にした場合、現在のバージョンの新しいビルドに関して報告される時点で利用可能なMoodleコードの更新も報告されます。ビルドは既存のMoodleバージョンに関する継続的な改善です。通常、ビルドは毎週リリースされます。この設定を無効にした場合、高いバージョンのMoodleがリリースされた場合のみ、利用可能な更新が報告されます。プラグインのチェックはこの設定により影響を受けません。';
$string['upgradeerror'] = '{$a->plugin} のバージョン {$a->version} へのバージョンアップに不明なエラーが発生したため継続できません。';
$string['upgradeforumread'] = 'Moodle1.5にはフォーラムの既読/未読記事を追跡する新しい機能が追加されました。<br />この機能を有効にするには<a href="{$a}">あなたのテーブルをアップデート</a>する必要があります。';
$string['upgradeforumreadinfo'] = 'Moodle1.5ではフォーラムの既読/未読記事を追跡するための新しい機能が追加されました。この機能を有効にするには投稿内容の未読管理を含むテーブルをアップデートする必要があります。あなたのサイトのサイズにより、この作業には長時間かかる場合があります。また、データベースに非常に負荷がかかる可能性がありますので、閑散期のアップデート作業をお勧めします。このアップデート期間中も、あなたのサイトは動作し続け、ユーザは影響を受けません。この処理を開始した場合、 (ブラウザを開いたままにして) 処理を終わらせてください。ウィンドウを閉じて処理を終わらせてしまった場合でも心配しないでください。アップデート処理を再開することができます。<br /><br />本当に今からアップデート処理を始めてもよろしいですか?';
$string['upgradekeyreq'] = 'アップグレードキー必須';
$string['upgradekeyset'] = 'アップグレードキー (設定しない場合、空白にしてください)';
$string['upgradelogs'] = '正常に動作させるためには古いログのアップグレードが必要です。<a href="{$a}">詳細はこちら</a>';
$string['upgradelogsinfo'] = 'ログの保存方法に変更点があります。あなたの活動ベースの古いログを閲覧できるようにするには古いログをアップグレードする必要があります。サイトによってはアップグレード作業に長時間(例 数時間) を要し、規模が大きなサイトではデータベースに負荷がかかります。処理を開始した場合は終了するまでそのまま (ブラウザを開いたまま) にしてください。心配する必要はありません - ログが更新された後、あなたのサイトは正常に動作します。<br /><br />本当にログをアップグレードしてもよろしいですか?';
$string['upgradepluginsfirst'] = '最初に利用可能な更新のインストールをお勧めします。';
$string['upgradepluginsinfo'] = 'プラグインの更新';
$string['upgradepluginsinfo_help'] = 'あなたのプラグインに関して利用可能な更新があります。あなたはMoodleデータベースのアップグレード前にそれらをインストールする必要があります。あなたのサイトが自動更新適用をサポートしていない場合、新しいプラグインバージョンをダウンロードして、あなたのサーバに手動でインストールする必要があります。';
$string['upgradepluginsinfo_link'] = 'admin/upgradepluginsinfo';
$string['upgradesettings'] = '新しい設定';
$string['upgradesettingsintro'] = '以下に表示されている設定はあなたの直近のMoodleアップグレードで追加されました。必要に応じて変更内容をデフォルトに設定した後、このページ下部にある「変更を保存する」ボタンをクリックしてください。';
$string['upgradestalefiles'] = '混合したMoodleバージョンが検出されたため、アップグレードを続けることができません。';
$string['upgradestalefilesinfo'] = 'Moodleディレクトリ内に少なくとも過去2つのメジャーバージョンのMoodle PHPスクリプトが検出されたためMoodleアップデート処理は中断されました。

後で重大な問題が発生する可能性があるためあなたはMoodleディレクトリ内に単一バージョンのMoodleファイルのみ含まれていることを確認する必要があります。

以下の方法であなたのMoodleディレクトリから不要なファイルを取り除くことをお勧めします:

* 現在のMoodleディレクトリを「moodle_old」にリネームしてください。
* ダウンロードまたはMoodle Gitリポジトリから取得した標準Moodleパッケージのみを含む新しいMoodleディレクトリを作成してください。
* オリジナルのconfig.phpおよびすべての非標準プラグインを「moodle_old」ディレクトリから新しいMoodleディレクトリにコピーしてください。

Moodleディレクトリから不要なファイルを取り除いた後、Moodleアップデート処理を再開するためこのページをリフレッシュしてください。

しばしばこの警告は前のバージョンのMoodle上に標準パッケージを展開したことにより発生します。マイナアップグレードでは問題ありませんが、メジャーアップグレードの場合は決してお勧めできることではありません。

また、この警告はGITリポジトリからの不完全なチェックアウトまたはアップデート処理により発生することがあります。この場合、処理が完了するまで待つか適切なクリーンアップコマンドを実行した後、処理を再試行してくだｓだい。

さらなる詳細情報は「<a href="{$a}">{$a}</a>」のアップグレードドキュメンテーションでご覧いただけます。';
$string['upgradestart'] = 'Moodleデータベースを更新する';
$string['upgradesure'] = '<p>あなたのMoodleファイルが更新されました。あなたはMoodleを以下のバージョンに自動的にアップグレードしようとしています: </p>
<p><strong>{$a}</strong></p>
</p>一旦この処理を開始すると元に戻すことはできません。この処理には長時間を要する場合があることに留意してください。</p>
<p>本当にこのサーバのMoodleをこのバージョンにアップグレードしてもよろしいですか?</p>';
$string['upgradetimedout'] = 'アップグレードがタイムアウトしました。アップグレードをリスタートしてください。';
$string['upgradingdata'] = 'データのアップグレード';
$string['upgradinglogs'] = 'ログのアップグレード';
$string['upgradingversion'] = '新しいバージョンへのアップグレード';
$string['upwards'] = '以上';
$string['useblogassociations'] = '関連付けを有効にする';
$string['user'] = 'ユーザ';
$string['userbulk'] = 'バルクユーザ処理';
$string['userbulkdownload'] = 'ユーザをエクスポートする';
$string['userdefaultpreferences'] = 'ユーザデフォルトプレファレンス';
$string['userfeedbackafterupgrade'] = '主要アップグレード後に毎回';
$string['userfeedbackencouragement'] = '<p>MoodleにはMoodle HQがホストする外部アンケートサイトを通じてMoodleソフトウェアに関するフィードバックを提供する機能があります。アンケートサイトにユーザを特定する情報が転送されることはありません。</p>
<p>Moodle HQはこのデータ収集に関してオープンであり透明性を保つため努力します。そのため、私たちはあなたがこの機能に関して主導権を握っていることを確実にしたいと思います。</p>
<p>ユーザからのフィードバックはMoodleソフトウェア改善に役立ちます。この機能を有効にするには<a href="{$a}">フィードバック設定</a>にアクセスしてください。</p>';
$string['userfeedbacknextreminder'] = '次のフィードバックリマインダ';
$string['userfeedbacknextreminder_desc'] = '私たちはどのタイミングで再度ユーザにフィードバックを依頼した方がよいですか?';
$string['userfeedbackperiodically'] = '定期的に';
$string['userfeedbackremindafter'] = '次の日数以降、リマインダを表示する';
$string['userfeedbackremindafter_desc'] = '指定された日数の後、再度ユーザにフィードバックを思い出させます。';
$string['userfiltersdefault'] = 'デフォルトユーザフィルタ';
$string['userfiltersdefault_desc'] = 'あなたが「バルクユーザ処理」ページに表示したいフィルタを選択してください。複数のフィルタを選択するにはCtrlキーを押したままにしてください。選択されていないフィルタには「さらに表示する」リンクからアクセスはできます。';
$string['userimagesdisabled'] = 'プロファイルユーザイメージは無効にされています。';
$string['userlist'] = 'ユーザ一覧を表示する';
$string['usermanagement'] = 'ユーザ管理';
$string['userpolicies'] = 'ユーザポリシー';
$string['userpreference'] = 'ユーザプレファレンス';
$string['userquota'] = 'プライベートファイルスペース';
$string['userquota_desc'] = 'それぞれのユーザが自分のプライベートファイルエリアに保存できる最大データ量です。';
$string['users'] = 'ユーザ';
$string['usesitenameforsitepages'] = 'サイトページにサイト名を使用する';
$string['usetags'] = 'タグ機能を有効にする';
$string['validateemptylineerror'] = '空白行は有効ではありません。';
$string['validateerror'] = 'この値は有効ではありません:';
$string['validateerrorlist'] = 'これらのエントリは無効です: {$a}';
$string['validateiperror'] = 'これらのIPアドレスは無効です: {$a}';
$string['verifychangedemail'] = 'メールアドレスの変更時、ドメインを制限する';
$string['warningcurrentsetting'] = '無効な現在値: {$a}';
$string['warningiconvbuggy'] = 'あなたのバージョンのiconvライブラリはIGNORE modifierをサポートしていません。無効なUTF-8文字列を含むストリングをクリーニングするため、代わりにmbstring拡張モジュールをインストールする必要があります。';
$string['webproxy'] = 'ウェブプロキシ';
$string['webproxyinfo'] = 'あなたのMoodleサーバが直接インターネットに接続できない場合、以下のオプションに必要事項を入力してください。インターネットアクセスは環境データ、言語パック、RSSフィード、タイムゾーン等のダウンロードに必要です。<br />PHP cURL拡張モジュールの使用を強くお勧めします。';
$string['xmlrpcwebserviceenabled'] = 'あなたのサイトでXML-RPCウェブサービスプロトコルが有効にされていることを検出しました。この機能はPHP XML-RPC拡張モジュールに依存していますが、現在、PHPによってメンテナンスされていません。';
$string['yuicomboloading'] = 'YUI combo読み込み';
$string['ziprequired'] = 'MoodleではPHP Zip拡張モジュールが必須です。info-ZIPバイナリまたはPclZipライブラリは今後使用されません。';
