<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_oauth2', language 'ja', version '5.0'.
 *
 * @package     local_oauth2
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actions'] = 'アクション';
$string['delete_oauth_client_confirm'] = '本当にこのOAuthクライアントを削除してもよろしいですか?';
$string['error_creating_oauth_client'] = 'OAuthクライアントの作成中にエラーが発生しました。';
$string['error_deleting_oauth_client'] = 'OAuthクライアントの削除中にエラーが発生しました。';
$string['error_updating_oauth_client'] = 'OAuthクライアントの更新中にエラーが発生しました。';
$string['event_access_token_created'] = 'アクセストークンが作成されました。';
$string['event_access_token_deleted'] = 'アクセストークンが削除されました。';
$string['event_access_token_updated'] = 'アクセストークンが更新されました。';
$string['event_user_granted'] = 'OAuth2サーバへのアクセスを許可されたユーザです。';
$string['event_user_not_granted'] = 'OAuth2サーバへのアクセスを許可されていないユーザです。';
$string['manage_oauth_clients'] = 'OAuthクライアントを管理する';
$string['not_implemented'] = '未実装';
$string['oauth2:manage_oauth_clients'] = 'OAuthクライアントを管理する';
$string['oauth_add_client'] = 'OAuthクライアントを追加する';
$string['oauth_auth_question'] = 'あなたのMoodleアカウントへのアクセスをアプリケーション「 {$a} 」に許可しますか?</br>';
$string['oauth_client_changes_saved'] = 'OAuthクライアントの変更が保存されました。';
$string['oauth_client_details'] = 'クライアント詳細';
$string['oauth_client_id'] = 'クライアントID';
$string['oauth_client_id_already_exists'] = 'クライアントIDはすでに存在します。';
$string['oauth_client_id_cannot_contain_space'] = 'クライアントIDにはスペースを含めません。';
$string['oauth_client_id_help'] = 'OAuthクライアントのクライアントIDです。';
$string['oauth_client_not_exists'] = 'Oauthクライアントが存在しません。';
$string['oauth_client_secret'] = 'クライアント秘密鍵';
$string['oauth_redirect_uri'] = 'リダイレクトURI';
$string['oauth_redirect_uri_help'] = 'OAuthクライアントのリダイレクトURIです。';
$string['oauth_redirect_uri_help_local_copilot'] = '<br/>
Microsoft 365 Copilotとの統合には次を使用してください: <b>https://teams.microsoft.com/api/platform/v1.0/oAuthRedirect</b>';
$string['oauth_scope'] = 'スコープ';
$string['oauth_scope_help'] = 'OAuthクライアントのスコープです。';
$string['oauth_scope_help_local_copilot'] = '<br/>
複数のスコープはスペースで区切ってください。</br>
Microsoft 365 Copilotとの統合では以下ようにする必要があります:
<ul>
<li>教師用OAuth2 クライアント: teacher.read teacher.write</li>
<li>学生用OAuth2 クライアント: student.read student.write</li>
</ul>';
$string['oauth_scope_list'] = 'アプリケーションは以下のデータにアクセスします:';
$string['oauth_scope_login'] = 'ログイン';
$string['pluginname'] = 'Oauth2サーバ';
$string['privacy:metadata:local_oauth2_access_token'] = 'ユーザに発行されたアクセストークンに関する情報です。';
$string['privacy:metadata:local_oauth2_access_token:access_token'] = 'ユーザに発行されたアクセストークンです。';
$string['privacy:metadata:local_oauth2_access_token:client_id'] = 'アクセストークンが発行されたOAuth2クライアントのIDです。';
$string['privacy:metadata:local_oauth2_access_token:expires'] = 'アクセストークンの有効期限です。';
$string['privacy:metadata:local_oauth2_access_token:scope'] = 'アクセストークンのスコープです。';
$string['privacy:metadata:local_oauth2_access_token:user_id'] = 'アクセストークンが発行されたユーザのIDです。';
$string['privacy:metadata:local_oauth2_authorization_code'] = 'ユーザに発行された認証コードに関する情報です。';
$string['privacy:metadata:local_oauth2_authorization_code:authorization_code'] = 'ユーザに発行された認証コードです。';
$string['privacy:metadata:local_oauth2_authorization_code:client_id'] = '認証コードが発行されたOAuth2クライアントのIDです。';
$string['privacy:metadata:local_oauth2_authorization_code:expires'] = '認証コードの有効期限です。';
$string['privacy:metadata:local_oauth2_authorization_code:id_token'] = 'ユーザに発行されたIDトークンです。';
$string['privacy:metadata:local_oauth2_authorization_code:redirect_uri'] = '認証コードが発行されたOAuth2クライアントのリダイレクトURIです。';
$string['privacy:metadata:local_oauth2_authorization_code:scope'] = '認証コードのスコープです。';
$string['privacy:metadata:local_oauth2_authorization_code:user_id'] = '認証コードが発行されたユーザのIDです。';
$string['privacy:metadata:local_oauth2_refresh_token'] = 'ユーザに発行されたリフレッシュトークンに関する情報です。';
$string['privacy:metadata:local_oauth2_refresh_token:client_id'] = 'リフレッシュトークンが発行されたOAuth2クライアントのIDです。';
$string['privacy:metadata:local_oauth2_refresh_token:expires'] = 'リフレッシュトークンの有効期限です。';
$string['privacy:metadata:local_oauth2_refresh_token:refresh_token'] = 'ユーザに発行されたリフレッシュトークンです。';
$string['privacy:metadata:local_oauth2_refresh_token:scope'] = 'リフレッシュトークンのスコープです。';
$string['privacy:metadata:local_oauth2_refresh_token:user_id'] = 'リフレッシュトークンが発行されたユーザのIDです。';
$string['privacy:metadata:local_oauth2_user_auth_scope'] = 'ユーザがOAuth2クライアントに付与したスコープに関する情報です。';
$string['privacy:metadata:local_oauth2_user_auth_scope:client_id'] = 'OAuth2クライアントのIDです。';
$string['privacy:metadata:local_oauth2_user_auth_scope:scope'] = 'ユーザがOAuth2クライアントに付与したスコープです。';
$string['privacy:metadata:local_oauth2_user_auth_scope:user_id'] = 'スコープを付与したユーザのIDです。';
$string['prvacy:metadata:local_oauth2_refresh_token:refresh_token'] = 'ユーザに発行されたリフレッシュトークンです。';
$string['settings_access_token_lifetime'] = 'アクセストークン有効期間';
$string['settings_access_token_lifetime_desc'] = 'アクセストークンの有効期間です。';
$string['settings_refresh_token_lifetime'] = 'リフレッシュトークン有効期間';
$string['settings_refresh_token_lifetime_desc'] = 'リフレッシュトークンの有効期間です。';
$string['settings_token_settings'] = 'トークン設定';
$string['task_cleanup'] = '有効期限切れ認証コードおよびトークンをクリーンアップする';
