<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'tool_tenant', language 'ja', version '5.0'.
 *
 * @package     tool_tenant
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accountalreadyconfirmedinfo'] = '{$a} 件のアカウントはすでに確認済みのため、スキップされました。';
$string['accountconfirmedfail'] = '{$a} 件のアカウントが見つからないか、確認できませんでした。';
$string['accountconfirmedsuccess'] = '{$a} 件のアカウントが確認されました。';
$string['activateusers'] = 'ユーザを有効化';
$string['activateusersintotenant'] = 'テナントにユーザを有効化...';
$string['activateusersintotenantdescription'] = 'ユーザを割り当てるテナントを選択してください。すべてのユーザは、選択した新しいテナントで以前の役割を維持します（テナント管理者を含む）。';
$string['activateusersintotenantfail'] = '{$a->users} 件のユーザは「{$a->tenant}」に割り当てることができませんでした！';
$string['activateusersintotenantsuccess'] = 'すべてのユーザは現在アクティブで「{$a->tenant}」に割り当てられています！ <a href="{$a->link}">ユーザを管理</a>';
$string['activateusersintotenantsuccesswithfails'] = '{$a->users} 件のユーザが「{$a->tenant}」に割り当てられ、{$a->unsuspendedusers} 件のユーザが現在アクティブになりました！ <a href="{$a->link}">ユーザを管理</a>';
$string['activetenants'] = 'アクティブなテナント';
$string['activeusers'] = 'ユーザアカウントの有効化';
$string['addtenant'] = 'テナントを追加';
$string['adduser'] = '新しいユーザ';
$string['admin'] = '管理者';
$string['administrators'] = '管理者';
$string['advanced'] = '高度な設定';
$string['advancedbrandingwarning'] = 'ここでの変更は、サイトのアクセシビリティやユーザエクスペリエンスに影響を与える可能性があります。';
$string['allocateusers'] = 'ユーザを割り当て';
$string['alltenants'] = '全てのテナント';
$string['alltenantsselected'] = 'すべてのテナント（将来のテナントも含む）ユーザ';
$string['allusers'] = '全てのユーザ';
$string['alluserslegacy'] = '全てのユーザ（レガシー）';
$string['andxmoretenants'] = '{$a} さらに...';
$string['archive'] = 'アーカイブ';
$string['archivedon'] = 'アーカイブ日';
$string['archivedtenants'] = 'アーカイブされたテナント';
$string['assigntenantadmins'] = 'テナント管理者に追加';
$string['authdisabledavailable'] = '無効、利用可能';
$string['autheditstatus'] = 'ステータスの編集';
$string['authenabledoptional'] = '有効、オプション';
$string['authmethod'] = '認証方法';
$string['authnewstatusfor'] = '{$a} の新しいステータス';
$string['authpluginsettings'] = '{$a}。設定';
$string['authtypeofloginwarning'] = '一部のテナントは特定の認証方法を使用しています。モバイルアプリユーザに一貫したエクスペリエンスを提供するには、<a href="{$a}">モバイル認証ページ</a>で、設定「ログインタイプ」を「アプリ経由」から別のオプションに変更することをお勧めします。';
$string['basicinformation'] = '基本情報';
$string['brand'] = 'プライマリーカラー';
$string['brand_help'] = 'すべてのリンクの色およびサイトのアクセントカラー';
$string['brandgraytones'] = 'グレーの色調を原色に合わせる';
$string['brandgraytones_help'] = 'ブランドカラーを選択すると、さまざまな補色が自動的に生成されます。これらの色は、リンクやボタンなど、ユーザインターフェースのさまざまな部分を強調します。';
$string['branding'] = 'ブランディング';
$string['buttoncolour'] = '主ボタンの色';
$string['buttoncolour_help'] = '主ボタン背景の色';
$string['cachedef_mytenant'] = '現在のテナントに関する情報';
$string['cachedef_tenants'] = 'テナントの一覧';
$string['cannotallocateusertotenant'] = '特定のテナントにユーザを割り当てることができません';
$string['cannotarchivetenant'] = 'デフォルトのテナントをアーカイブすることはできません。';
$string['category'] = 'コースカテゴリ';
$string['category_help'] = 'テナント管理者は、このコースカテゴリで自動的に「コースカテゴリ内のテナント管理者」ロールが割り当てられ、コースの作成、ロールの割り当てなどができるようになります。
すべてのテナントユーザには、このカテゴリで自動的に「テナントユーザ」ロールが割り当てられます。<br><br>
テナントカテゴリとして選択できるのは、最上位のカテゴリのみです。<br>
「新しいカテゴリ」を選択すると、テナント名と同じ名前のカテゴリが作成されます。';
$string['categorynameexist'] = '名前 \'{$a}\' のカテゴリがすでにトップレベルに存在しています。このカテゴリを選択するか、他の名前にしてください。';
$string['categorynameexistws'] = '\'{$a}\' という名前のカテゴリがすでにトップレベルに存在します。テナント名を変更するか、カテゴリなしで作成してください。';
$string['categorynotfound'] = 'カテゴリが存在しないか、トップレベルにありません。';
$string['categorytaken'] = 'このカテゴリは他のテナントに割り当てられています。';
$string['changesite'] = 'サイトを変更する';
$string['chooseexistingcategory'] = '既存のカテゴリを選択してください。';
$string['colours'] = '色';
$string['conditionuserallocateddescription'] = 'ユーザはテナント \'{$a}\' に割り当てられました';
$string['conditionusernotallocateddescription'] = 'ユーザはテナント \'{$a}\' に割り当てられていません';
$string['configoverride'] = 'オーバーライド';
$string['configureoauth2link'] = 'OAuth2サービスを設定する';
$string['configusedefault'] = 'デフォルトを使用';
$string['confirmaccounts'] = 'アカウントを確認';
$string['confirmactivateuser'] = '本当にこのユーザを有効化してもよろしいですか？';
$string['confirmactivateusers'] = '選択したユーザを本当に有効化してもよろしいですか？';
$string['confirmallocateusers'] = '本当に選択中のユーザを選択中のテナントに割り当てますか？';
$string['confirmarchivetenant'] = '本当にテナント \'{$a}\' をアーカイブしますか？このテナントに割り当てられているすべてのユーザはデフォルトテナントに移動します。';
$string['confirmarchivetenantwarning'] = 'テナント管理者は一般ユーザとなり、テナントをリストアしてもテナント管理者ロールはリストアされません。';
$string['confirmarchivetenantwithoutusers'] = 'テナント「{$a}」をアーカイブしてもよろしいですか？';
$string['confirmarchivetenantwithusers'] = 'テナント「{$a->tenant}」をアーカイブしてもよろしいですか？このテナントに割り当てられている{$a->users} 件のユーザは一時停止されます。';
$string['confirmassigntenantadmins'] = '選択したユーザをテナント管理者のリストに追加してもよろしいですか？';
$string['confirmdeletetenant'] = 'テナント「{$a}」を完全に削除してもよろしいですか？このテナントに割り当てられているすべてのユーザが削除されます。';
$string['confirmdeleteuser'] = '本当にこのユーザを削除しますか？この操作は元に戻せません。';
$string['confirmdeleteusers'] = '本当に選択中のユーザを削除しますか？この操作は元に戻せません。';
$string['confirmresendemailuser'] = 'このユーザに確認メールを再送信してもよろしいですか？';
$string['confirmresendemailusers'] = '選択したユーザに確認メールを再送信してもよろしいですか？このアクションは元に戻せません。';
$string['confirmrestoretenant'] = 'テナント「{$a}」をリストアしてもよろしいですか？このテナントに割り当てられているすべてのユーザがアクティブになります。';
$string['confirmsuspenduser'] = '本当にこのユーザを一時停止にしますか？';
$string['confirmsuspendusers'] = '本当に選択中のユーザを一時停止にしますか？';
$string['confirmunassigntenantadmins'] = '選択したユーザをテナント管理者のリストから削除してもよろしいですか？';
$string['confirmunsuspenduser'] = '本当にこのユーザを一時停止解除しますか？';
$string['confirmunsuspendusers'] = '本当に選択中のユーザを一時停止解除しますか？';
$string['confirmuser'] = 'ユーザの確認';
$string['confirmusers'] = 'ユーザの確認';
$string['createnewcategory'] = '新しいカテゴリを作成';
$string['customcss'] = 'カスタムSCSS';
$string['defaultdashboardconfiguration'] = 'デフォルトのダッシュボード設定';
$string['defaultname'] = 'デフォルトのテナント';
$string['defaultsitedashboardpage'] = 'デフォルトのサイトダッシュボード';
$string['defaulttenantmobileconfig'] = 'これはデフォルトのテナントであるため、その構成は常にモバイルアプリによって使用されます。';
$string['deleteuser'] = 'ユーザを削除';
$string['deleteusers'] = 'ユーザを削除';
$string['editdashboard'] = 'ダッシュボードの編集';
$string['editdashboarddescription'] = 'このテナントのみダッシュボードを編集する';
$string['editdetailsinsharedspace'] = '共有スペースで編集';
$string['editingdashboard'] = 'あなたは \'{$a}\' のダッシュボードを編集しています';
$string['editingsitedashboard'] = 'あなたはデフォルトのサイトダッシュボードを編集しています';
$string['edittenantname'] = '名前を編集';
$string['edituser'] = 'ユーザアカウントを編集';
$string['edituserwithname'] = 'ユーザ \'{$a}\' を編集';
$string['emailsconfirmationresend'] = '確認メールを再送信する';
$string['enablesharedspace'] = '共有スペースを有効にする';
$string['enrolinseparategroups'] = 'このコースは他のテナントと共有されますが、異なるテナントのユーザは別グループに割り当てられます。';
$string['enrolwithoutgroups'] = '他のテナントのユーザが登録されています。このコースは分離グループモードではないため、ユーザがお互いに閲覧できます。';
$string['errorcannotallocate'] = 'テナントに割り当てられません';
$string['errorexperimentalmultidomain'] = 'テナントごとの個別ドメインの実験的機能はもはやサポートされていません。設定を調整してください。詳細は<a href="{$a}">マルチドメイン設定の移行</a>をご参照ください。';
$string['errorinvalidtenant'] = '無効なテナント \'{$a}\'';
$string['errormultidomainandtenant'] = 'マルチテナンシーの設定が無効です。設定を調整してください。詳細は<a href="{$a}">マルチドメイン設定の移行</a>をご参照ください。';
$string['errornewcategorytenant'] = 'パラメータ \'autocreatecategory\' と \'categoryid\' は併用できません。';
$string['errornopermissionaddcondition'] = '現在、テナントリストを表示する権限がありません。';
$string['errornopermissionallocateusers'] = 'ユーザをこのテナントに割り当てる権限がありません。';
$string['errortenantarchived'] = 'このテナントはアーカイブされています';
$string['errortenantidnumberunique'] = 'このID番号は別のテナントですでに使用されています。';
$string['errortenantnotfound'] = 'このテナントは存在しません';
$string['errorurlnotavailable'] = '少なくとも1つのログインURLが使用可能である必要があります。';
$string['errorwwwroot'] = 'カスタムドメインは、http://またはhttps://で始まり、末尾にスラッシュ（/）を含まない有効なURLでなければなりません。パスやポートを含むことはできません。';
$string['eventtenantcreated'] = '作成されたテナント';
$string['eventtenantdeleted'] = '削除されたテナント';
$string['eventtenantupdated'] = '更新されたテナント';
$string['eventtenantusercreated'] = 'テナントに割り当てられたユーザ';
$string['eventtenantuserupdated'] = 'テナントへのユーザ割り当てが変更されました';
$string['favicon'] = 'ファビコン';
$string['footertext'] = 'フッターテキスト';
$string['forceforalltenants'] = 'すべてのテナントに強制';
$string['gotosharedspace'] = '共有スペースに移動';
$string['headerlogo'] = 'ヘッダーロゴ';
$string['headerlogo_help'] = 'エンブレム、シールド、トップナビゲーションバーに使用されるアイコンのような、ロゴのコンパクトバージョンです';
$string['idnumber'] = 'IDナンバー';
$string['idnumber_help'] = 'テナントのIDナンバーは、外部システムやアップロードユーザツールと合致させるときにのみ使用され、サイトの他の場所には表示されません。テナントが正式なコードネームがあれば入力してください。そうでない場合は空白のままにすることができます。';
$string['images'] = 'イメージ';
$string['invalidcolour'] = 'このカラーコードは正しいフォーマットではありません。#000フォーマットか#000000フォーマットを使用してください。';
$string['ismultitenant'] = 'マルチテナント';
$string['issuernologin'] = 'この発行者はログインに使用できません。';
$string['linkalltenants'] = 'すべてのテナントへのリンク...';
$string['linkalltenantscheckbox'] = '影響を受けたテナントのすべてのユーザに対して、ダッシュボードもリセットしてください。';
$string['linkalltenantsdescription'] = 'この操作を行うと、デフォルトのサイトダッシュボードページにリンクされていないすべてのテナントがリセットされ、今後はこのページにリンクされ続けます。';
$string['linkalltenantsmessage'] = 'すべてのテナントが正常にリンクされました。';
$string['linkdashboard'] = 'パーソナライズされたダッシュボードを削除し、サイトのデフォルトダッシュボードを使用します。';
$string['linkdashboarddescription'] = '現在、このテナントのダッシュボードは「デフォルトのサイトダッシュボードページ」で定義されたコンテンツと同期されていません。このボタンをクリックすると同期されます。この操作を行うと、「デフォルトのサイトダッシュボードページ」で行われた変更が、このテナントのダッシュボードにも反映されます。<br>この操作は将来的に元に戻すことができます。';
$string['linkdashboarddescriptionforadmin'] = '現在、このダッシュボードは「デフォルトのサイトダッシュボードページ」で定義されたコンテンツと同期されていません。このボタンをクリックすると同期されます。この操作を行うと、「デフォルトのサイトダッシュボードページ」で行われた変更が、このダッシュボードにも反映されます。<br>この操作は将来的に元に戻すことができます。';
$string['linkdashboarddialog'] = '進行すると、パーソナライズされたダッシュボードが削除され、「デフォルトのサイトダッシュボードページ」で定義されたコンテンツにリンクされます。既存のユーザのダッシュボードには変更はありませんが、後で手動でリセットすることができます。<br><br>新しいユーザのダッシュボードは、グローバルマネージャーによって制御される「デフォルトのサイトダッシュボードページ」から作成されます。<br><br>この操作は将来的に元に戻すことができます。';
$string['linkdashboarddialogforadmin'] = '進行すると、このテナントのダッシュボードは「デフォルトのサイトダッシュボードページ」で定義されたコンテンツにリンクされます。今後、「デフォルトのサイトダッシュボードページ」で行われた変更は、このテナントのダッシュボードに反映されます。<br><br>既存のユーザのダッシュボードには変更はありませんが、後で手動でリセットすることができます。<br><br>このテナントの新しいユーザのダッシュボードは、「デフォルトのサイトダッシュボードページ」から作成されます。<br><br>この操作は将来的に元に戻すことができます。';
$string['linkdashboardmessage'] = 'ダッシュボードは正常にリンクされました。';
$string['linkeddashboard'] = 'デフォルトサイトダッシュボードへのリンク';
$string['loginbackground'] = 'ログインの背景イメージ';
$string['loginlogo'] = 'ログインロゴ';
$string['loginlogo_help'] = 'ログインページの装飾として使用される完全なロゴ';
$string['loginurl'] = 'ログインURL';
$string['loginurl_help'] = '選択したURLはテナント管理者に表示され、テナントの初期テーマとして適用し、ユーザに渡すことができます。 「ID番号」が指定されていない場合、IDナンバーリンクはURLを選択していても使用できません。 テナントの作成中はテナントIDが使用できないことに注意してください。';
$string['lookingfordifferentsite'] = '別のサイトをお探しですか?';
$string['management'] = '管理';
$string['managetenants'] = 'テナントを管理';
$string['migrationcoursecategories'] = 'コーホートとコース構造を含むコースカテゴリ';
$string['migrationcreate'] = '新しいテナントを作成する';
$string['migrationdestinationsummary'] = '宛先: {$a}';
$string['migrationexporterdescription'] = 'テナントとそれに含まれるすべての物';
$string['migrationlogerror'] = 'テナント \'{$a}\' をインポートできませんでした';
$string['migrationlogsuccess'] = 'インポートしたテナント \'<a href="{$a->url}">{$a->name}</a>\'';
$string['migrationmappingerror'] = '一部のテナントが存在しません';
$string['migrationmappingerrorlog'] = 'テナント {$a} が見つかりませんでした';
$string['migrationmerge'] = '既存のテナントにマージ...';
$string['migrationmerge_help'] = 'テナント情報を選択したエンティティとともに既存のテナントにマージします。詳細と外観（選択した場合）は上書きされることに注意してください。';
$string['migrationmergeselecttenant'] = 'マージするテナントを選択します';
$string['migrationmergetoomany'] = '既存のテナントにマージするために選択できるインスタンスは1つだけです';
$string['migrationselectalltenants'] = 'すべてのテナントを選択';
$string['migrationselectexcludingarchived'] = 'すべてのテナントを選択（アーカイブを除く）';
$string['migrationselectincludingarchived'] = 'すべてのテナントを選択（アーカイブを含む）';
$string['migrationselectmanually'] = 'テナントを手動で選択する...';
$string['missingtenant'] = 'テナントがありません';
$string['modurl:configtenantdata'] = 'テナントIDおよびID番号を利用可能なパラメータ変数のリストに含めたい場合は、有効にしてください。';
$string['modurl:tenantdata'] = 'テナントデータ';
$string['modurl:tenantdatadesc'] = 'URLアクティビティにテナントデータを追加できます';
$string['modurl:tenantid'] = 'テナントID';
$string['modurl:tenantidnumber'] = 'テナントIDナンバー';
$string['movebetweentenants'] = 'テナントを移動';
$string['movetenant'] = 'テナント \'{$a}\' を移動';
$string['name'] = 'テナント名';
$string['namewithempty'] = 'テナント名（テナントなしを含む）';
$string['navbarcolour'] = 'ナビゲーションバーの色';
$string['navbarcolour_help'] = 'トップナビゲーションバーの背景色';
$string['newname'] = '新しいテナント \'{$a}\'';
$string['newnamefor'] = '\'{$a}\' の新しい名前';
$string['nocategory'] = 'カテゴリなし';
$string['nomanualassignment'] = 'このロールはどのコンテキストにも手動で割り当てることはできません';
$string['noreplyaddressdescription'] = 'noreplyメールはデフォルトでサイトレベルで設定されています。「オーバーライド」を選択すると、新しいメールアドレスを提供することができます。';
$string['notavailablefortenants'] = 'どのテナントでも利用不可';
$string['notnow'] = '特になし';
$string['notspecified'] = '指定されていない';
$string['oauth2_alltenants'] = 'このサービスは、すべてのテナント（将来のテナントを含む）が利用できます。';
$string['oauth2_exceptfollowingtenants'] = 'このサービスは、以下を除くすべてのテナントが利用できます。';
$string['oauth2_onlyfollowingtenants'] = 'このサービスは、以下のテナントのみが利用できます。';
$string['oauth2_tenantavailability_success'] = 'サービステナントの空きが正しく更新されました';
$string['oauth2availableforlogin'] = 'OAuth 2 services available for login.';
$string['organisationadmintab'] = '組織';
$string['outcomeallocation'] = 'ユーザをテナントに割り当てる';
$string['outcomeallocationdescription'] = 'ユーザをテナント \'{$a}\' に割り当てる';
$string['pluginname'] = 'マルチテナント';
$string['privacy:metadata:user'] = 'ユーザのテナントへの割り当て';
$string['privacy:metadata:user:component'] = '割り当てを担当するコンポーネント';
$string['privacy:metadata:user:id'] = 'ID';
$string['privacy:metadata:user:reason'] = '割り当ての理由';
$string['privacy:metadata:user:tenantid'] = 'テナント';
$string['privacy:metadata:user:timecreated'] = '割り当てた時間';
$string['privacy:metadata:user:timemodified'] = '更新された時間';
$string['privacy:metadata:user:userid'] = 'ユーザ';
$string['privacy:metadata:user:usermodified'] = '記録を更新したユーザ';
$string['profilecategory_alltenants'] = 'このカテゴリーは、すべてのテナント（将来のテナントも含む）が利用可能です。';
$string['profilecategory_exceptfollowingtenants'] = 'このカテゴリーは、以下を除くすべてのテナントが利用できます。';
$string['profilecategory_onlyfollowingtenants'] = 'このカテゴリーは以下のテナントのみ利用可能です。';
$string['reg_wpsharedspaceenabled'] = '共有スペースが有効です（{$a}）。';
$string['reg_wptenantdomains'] = 'カスタムドメインが設定されたテナントの数（{$a}）';
$string['reg_wptenants'] = 'テナント ({$a}) の数';
$string['resendemailsentfail'] = '{$a} ユーザが見つからないか、確認メールを送信できませんでした';
$string['resendemailsentsuccess'] = '{$a} ユーザに送信された確認メール';
$string['resendemailuser'] = 'ユーザにメールを再送信する';
$string['resetappearance'] = '外観をリセット';
$string['resetdashboard'] = 'すべてのユーザのダッシュボードをリセットする';
$string['resetdashboarddescription'] = 'このテナント内のすべてのユーザのダッシュボードをリセットする';
$string['resetdashboarddialog'] = '進行すると、すべてのユーザのダッシュボードがリセットされます。<br><br>この操作は元に戻すことができません。';
$string['resetdashboarddialogforadmin'] = '進行すると、このテナント内のすべてのユーザのダッシュボードがリセットされます。<br><br>この操作は元に戻すことができません。';
$string['resetdashboardmessage'] = 'ダッシュボードはすべてのユーザに対して正常にリセットされました。';
$string['resetlinkeddashboard'] = 'リンクされたテナントのすべてのユーザのダッシュボードをリセットします...';
$string['resetlinkeddashboarddialog'] = '進行すると、リンクされたテナントのすべてのユーザのダッシュボードがリセットされます。<br><br>この操作は元に戻すことができません。';
$string['resetlinkeddashboardmessage'] = 'すべてのユーザのダッシュボードは正常にリセットされました。';
$string['resettenantappearance'] = 'テナントの外観をリセット';
$string['resettenantappearancecolours'] = 'すべてのカスタムカラーをリセット';
$string['resettenantappearancecss'] = 'カスタムSCSSを削除';
$string['resettenantappearancedesc'] = 'このボタンをクリックすると、アクセシビリティ標準に復元する要素（画像、色など）を選択できます。';
$string['resettenantappearancefooter'] = 'フッターテキストを削除する';
$string['resettenantappearanceformend'] = 'この操作は元に戻せません';
$string['resettenantappearanceformintro'] = 'このテナント構成をデフォルトのアクセス可能な構成にリセットします。<br> この操作は次のようになります:';
$string['resettenantappearanceimages'] = 'アップロードされたすべての画像（ロゴ、背景）を削除します';
$string['saml2_alltenants'] = 'このIdPはすべてのテナント（今後のテナントも含む）で利用可能です。';
$string['saml2_exceptfollowingtenants'] = 'このIdPは、以下のテナントを除くすべてのテナントで利用可能です。';
$string['saml2_onlyfollowingtenants'] = 'このIdPは、以下のテナントにのみ利用可能です。';
$string['saml2_tenantavailability_success'] = 'IdPのテナント可用性は正常に更新されました。';
$string['saml2availableforlogin'] = 'ログインに利用可能なSAML2アイデンティティプロバイダー。';
$string['seealltenants'] = 'すべて参照';
$string['selecttenant'] = 'テナントを選択';
$string['selecttenantoutcome'] = 'テナントを選択';
$string['selecttenants'] = 'テナントを選択';
$string['selectuser'] = 'ユーザ \'{$a}\' を選択';
$string['sharedspace'] = '共用スペース';
$string['sharedspaceconfirmationtext'] = '共有スペースは、すべてのテナント間でエンティティとコンテンツを共有するための場所です。このスペース内で作成したものはすべて、適切な権限を持っているテナントのユーザがすぐに利用できるようになります。 <br/> 共有スペースがアクティブ化されると、非アクティブ化することはできません。 <br/> 共有スペースを有効にしますか？';
$string['sharedspaceenabledmessage'] = '共有スペースが正常に有効化されました。ナビゲーションバーのテナントスイッチを使用してアクセスします。';
$string['showintenantselector'] = 'ログインセレクタにこのテナントを表示する';
$string['showintenantselector_help'] = 'このオプションを有効にすると、すべてのテナントのログインページに、このテナントが代替ログインページとして表示されます。';
$string['showtenantselector'] = 'ログインページにテナントセレクターを表示する';
$string['showtenantselector_help'] = 'このオプションを有効にすると、ユーザはログインページで異なるテナントを切り替えることができます。各テナントは、このリストでその可視性を個別に設定できます。';
$string['sitename'] = 'サイト名';
$string['sitename_help'] = 'このテナントのユーザのデフォルトサイト名の上書きを許可';
$string['siteshortname'] = 'サイト省略名';
$string['siteshortname_help'] = 'このテナントのユーザのデフォルトサイト省略名の上書きを許可します。 <br> フィールド「ヘッダーロゴ」（テナントブランド設定内）を空のままにすると、サイトの省略名がヘッダーに表示されます。';
$string['siteshortnamedesc'] = 'フィールド「ヘッダーロゴ」（テナントブランド設定内）を空のままにすると、サイトの省略名がヘッダーに表示されます。';
$string['siteuserlimit'] = 'サイトユーザ制限';
$string['siteuserlimit_desc'] = 'サイトで許可されるユーザアカウントの最大数';
$string['siteuserlimitenabled'] = 'サイトユーザ制限を有効にする';
$string['status'] = 'ステータス';
$string['supportavailability'] = 'サポートアベイラビリティ';
$string['supportavailabilitydescription'] = 'サポートアベイラビリティは、デフォルトではサイトレベルで設定されています。上書き」を選択することで、新しいアベイラビリティを提供することができます。';
$string['supportemail'] = 'サポートメール';
$string['supportemaildescription'] = 'サポートメールは、デフォルトではサイトレベルで設定されています。「上書き」を選択することで、新しいEメールを送信することができます。';
$string['supportname'] = 'サポート名';
$string['supportnamedescription'] = 'サポート名は、デフォルトではサイトレベルで設定されています。「上書き」を選択することで、新しい名前を設定することができます。';
$string['supportpage'] = 'サイトサポートへの連絡リンク';
$string['supportpagedescription'] = 'サポートサポートへの連絡リンクは、デフォルトではサイトレベルで設定されています。「上書き」を選択することで、新しいURLを設定することができます。';
$string['suspendedusers'] = '一時停止されたユーザ';
$string['suspenduser'] = 'ユーザを一時停止';
$string['suspendusers'] = 'ユーザを一時停止';
$string['switchedto'] = '\'{$a}\' に切り替えました';
$string['switchtenant'] = 'テナントの切り替え';
$string['tenant'] = 'テナント';
$string['tenant:allocate'] = 'すべてのテナントにユーザを割り当てる';
$string['tenant:authconfig'] = 'テナント認証設定の編集';
$string['tenant:browseusers'] = '現在のテナントにいるユーザを閲覧';
$string['tenant:manage'] = 'テナントの追加や編集を管理';
$string['tenant:managedashboard'] = '現在のテナントのダッシュボード設定を管理';
$string['tenant:managetheme'] = '現在のテナントのテーマ設定を管理';
$string['tenant:managethemeadvanced'] = '現在のテナントのテーマ設定を管理';
$string['tenant:manageusers'] = '現在のテナントのユーザを追加、編集';
$string['tenant:mobileconfig'] = 'テナントのモバイル設定を編集';
$string['tenantadmin'] = 'テナント管理者';
$string['tenantadminalreadyassigned'] = '{$a} ユーザはすでにテナント管理者であるため、スキップされました';
$string['tenantadminalreadyunassigned'] = '{$a} ユーザはテナント管理者ではないため、スキップされました';
$string['tenantadmincapabilitieslimit'] = 'マルチテナントとの互換性のないケイパビリティは一覧表示されません。<a href=" {$a} ">詳細...</a>';
$string['tenantadmindescription'] = 'Workplaceテナント管理者ロール。システムコンテキスト内で、テナント管理者に自動的に割り当てられます。';
$string['tenantadministration'] = 'テナント管理';
$string['tenantadministrator'] = 'このユーザはテナント管理者です';
$string['tenantadmins'] = 'テナント管理者';
$string['tenantarchivedsuccess'] = 'テナント「{$a}」はアーカイブされました！割り当てられたすべてのユーザは一時停止されました。';
$string['tenantavailability'] = 'テナントの可用性';
$string['tenantavailabilityfor'] = '\'{$a}\'のテナントの可用性';
$string['tenantcategorycapabilitieslimit'] = 'コースカテゴリのコンテキストで設定できるケイパビリティのみ、ここに表示されます';
$string['tenantdeleted'] = 'テナント「{$a}」は削除されました。';
$string['tenantdetails'] = '詳細';
$string['tenantlimit'] = 'テナントの制限';
$string['tenantlimit_desc'] = 'システム内で許容されている最大テナント数は、アクティブおよびアーカイブされたテナント数が含まれます。';
$string['tenantlimitenabled'] = 'テナント制限を有効にする';
$string['tenantlimitenabled_desc'] = '有効にするとこのサイトのテナントの数を制限できます。';
$string['tenantlimitreached'] = 'テナントが制限に到達';
$string['tenantlimitreached1'] = 'マルチテナント機能はこのサイトでは利用できません';
$string['tenantlimitreachedmult'] = 'このサイトでテナントを {$a} つ作成できます。アーカイブされたテナントも制限にカウントされるので注意してください。';
$string['tenantmanager'] = 'コースカテゴリ内のテナント管理者';
$string['tenantmanagerdescription'] = '2つ目のWorkplaceテナント管理者ロール。コースカテゴリのコンテキスト内で、テナント管理者に自動的に割り当てられます。';
$string['tenantnotfound'] = 'テナントが見つかりません';
$string['tenantrestoredsuccess'] = 'テナント「{$a->tenant}」は復元されました！このテナントに割り当てられているすべてのユーザが現在アクティブです。 <a href="{$a->link}">ユーザを管理</a>';
$string['tenants'] = 'テナント';
$string['tenantselectorlogo'] = 'テナントセレクターロゴ';
$string['tenantselectorlogo_help'] = 'このロゴは、ログインテナントセレクターでこのテナントを識別するのに役立ちます（テナントセレクター機能が有効になっている場合）。指定しない場合、ログインロゴが使用されます。';
$string['tenantsexceptselected'] = '以下を除くすべてのテナントのユーザ';
$string['tenantsexceptselecteddesc'] = '以下を除くすべてのテナントのユーザ  {$a}';
$string['tenantsselected'] = '以下のテナントユーザ';
$string['tenantsselecteddesc'] = '以下のテナントユーザ {$a}';
$string['tenantuser'] = 'テナントユーザ';
$string['tenantuserdescription'] = 'Workplaceのテナントユーザロール。コースカテゴリ上のコンテキスト内のすべてのテナントユーザに自動的に割り当てられます。';
$string['tenantuserlimit'] = 'テナントユーザ制限';
$string['tenantuserlimit_desc'] = 'テナントごとに許可されるユーザアカウントの最大数';
$string['tenantuserlimitenabled'] = 'テナントユーザ制限を有効にする';
$string['tenantusers'] = 'テナントユーザ';
$string['themesettingssaved'] = 'テーマ設定が保存されました。変更がサイトに表示されるまで数分かかることがあります。';
$string['toomanytenantstoshow'] = 'テナントが多すぎて表示できません';
$string['unassigntenantadmins'] = 'テナント管理者から削除';
$string['unlinkdashboard'] = 'パーソナライズされたダッシュボードの作成';
$string['unlinkdashboarddescription'] = '現在、このテナントのダッシュボードは「デフォルトのサイトダッシュボードページ」で定義されたコンテンツにリンクされています。このボタンをクリックすると、このテナントのために個別に設定可能なダッシュボードページが作成されます。<br>この操作は将来的に元に戻すことができます。';
$string['unlinkdashboarddescriptionforadmin'] = '現在、このダッシュボードは「デフォルトのサイトダッシュボードページ」で定義されたコンテンツにリンクされています。このボタンをクリックすると、個別に設定可能な独立したダッシュボードページが作成されます。<br>この操作は将来的に元に戻すことができます。';
$string['unlinkdashboarddialog'] = '進行すると、このダッシュボードは「デフォルトのサイトダッシュボードページ」で定義されたコンテンツとのリンクが解除され、代わりに個別に設定可能な独立したダッシュボードページになります。<br><br>既存のユーザの個別ダッシュボードには変更はありません。<br><br>この操作は将来的に元に戻すことができます。';
$string['unlinkdashboarddialogforadmin'] = '進行すると、このテナントのダッシュボードは「デフォルトのサイトダッシュボードページ」で定義されたコンテンツとのリンクが解除され、代わりに個別に設定可能な独立したダッシュボードページになります。<br><br>このテナントのユーザのダッシュボードは直ちにはリセットされませんが、後で手動でリセットすることができます。<br><br>この操作は将来的に元に戻すことができます。';
$string['unlinkdashboardmessage'] = 'ダッシュボードは正常にリンク解除されました。';
$string['unlinkeddashboard'] = 'リンク解除されました';
$string['unrecognisedaction'] = '認識されないアクションです';
$string['unsuspenduser'] = 'ユーザの一時停止を解除';
$string['unsuspendusers'] = 'ユーザの一時停止を解除';
$string['useractivatedsuccess'] = 'ユーザは正常に有効化されました';
$string['useralreadyconfirmedinfo'] = 'ユーザ {$a} はすでに確認されているのでスキップされました';
$string['userconfirmedfail'] = 'ユーザ {$a} が見つからないか、確認できませんでした';
$string['userconfirmedsuccess'] = 'ユーザ {$a} が確認されました';
$string['userdeletedfail'] = 'ユーザ {$a} が見つからないか、削除できませんでした';
$string['userdeletedsuccess'] = 'ユーザ {$a} が削除されました';
$string['usermanagement'] = 'ユーザ管理';
$string['usermovetotenant'] = '{$a->count}人のユーザが次のテナントに移動しました: {$a->tenant}';
$string['usernotmovetotenant'] = '{$a->count}人のユーザを次のテナントに移動できませんでした: {$a->tenant}';
$string['usersactivatedfail'] = '{$a} 件のユーザが見つからないか、有効化できませんでした';
$string['usersactivatedsuccess'] = '{$a} 件のユーザが有効化されました';
$string['usersallocatedtotenant'] = 'テナントに割り当てられたユーザ';
$string['usersassignedtenantadminfail'] = 'テナント管理者のリストにユーザ {$a} を追加できませんでした';
$string['usersassignedtenantadminsuccess'] = 'テナント管理者のリストにユーザ {$a} を追加しました';
$string['userscount'] = 'ユーザ';
$string['userslimitreached'] = 'ユーザアカウントの制限に達しました';
$string['usersnotallocatedtotenant'] = 'テナントに割り当てられていないユーザ';
$string['userssuspendedfail'] = 'ユーザ {$a} が見つからないか、一時停止を解除できませんでした';
$string['userssuspendedsuccess'] = 'ユーザ {$a} が一時停止されました';
$string['usersunassignedtenantadminfail'] = 'テナント管理者のリストからユーザ {$a} を削除できませんでした';
$string['usersunassignedtenantadminsuccess'] = 'テナント管理者のリストからユーザ {$a} を削除しました';
$string['usersunsuspendedfail'] = 'ユーザ {$a} が見つからないか、一時停止解除できませんでした';
$string['usersunsuspendedsuccess'] = 'ユーザ {$a} の一時停止解除';
$string['usersuspendedsuccess'] = 'ユーザが正常に一時停止されました';
$string['usertenant'] = 'ユーザのテナント';
$string['userunsuspendedsuccess'] = 'ユーザが正常に一時停止解除されました';
$string['wwwroot'] = 'カスタムドメイン';
$string['wwwroot_help'] = 'このテナントで使用するURLを指定してください。指定する前に、DNSが設定されていて、そのURLが同じサイトを指すようになっていることを確認してください。';
