<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'quiz', language 'cs', version '5.0'.
 *
 * @package     quiz
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessnoticesheader'] = 'Tento test si můžete zobrazit, ale v případě reálného spuštění testu byste byli blokováni z důvodu:';
$string['action'] = 'Akce';
$string['activityoverview'] = 'Máte jeden či více nových testů (klikněte zde pro zobrazení).';
$string['adaptive'] = 'Adaptivní režim';
$string['adaptive_help'] = 'Pokud je tato možnost povolena, je možno v jednom pokusu úlohy odpovědět vícekrát. Tak například, pokud je odpověď označena jako chybná, může student okamžitě odpovědět znovu. Nicméně v závislosti na nastavení "Penalizace", bude za každý špatný pokus odečtena penalizace.';
$string['add'] = 'Přidat';
$string['addaquestion'] = 'novou úlohu';
$string['addarandomquestion'] = 'náhodnou úlohu z banky úloh';
$string['addarandomquestion_help'] = 'Zadání Přidat náhodnou úlohu má za následek vložení náhodně vybrané úlohy do testu z kategorie úloh. To znamená, že různí studenti získat jiný výběr úloh a pokud test umožňuje více pokusů, pak každý pokus bude pravděpodobně obsahovat nový výběr úloh.';
$string['addarandomquestion_success'] = 'Náhodné otázky byly přidány';
$string['addarandomselectedquestion'] = 'Přidat náhodně vybranou úlohu ...';
$string['addasection'] = 'záhlaví nové sekce';
$string['adddescriptionlabel'] = 'Přidat popisek';
$string['addingquestion'] = 'Přidávám úlohu';
$string['addingquestions'] = '<p>Zde spravujete databázi svých testových úloh. Úlohy se ukládají do kategorií – vytvářením kategorií tak můžete svou databázi přehledně strukturovat. Jednotlivé kategorie lze použít v jakémkoliv testu v tomto kurzu, a dokonce i v jiných kurzech, pokud se rozhodnete je \'zveřejnit\'..</p>
<p>Poté, co vyberete nebo vytvoříte kategorii, budete moci vytvářet nebo upravovat úlohy. Ty pak můžete přidávat do testu v levé části této stránky..</p>';
$string['addmoreoverallfeedbacks'] = 'Přidat další {no} pole pro komentáře';
$string['addnewgroupoverride'] = 'Přidat přenastavení skupiny';
$string['addnewpagesafterselected'] = 'Po vybraných úlohách přidat nové stránky';
$string['addnewquestionsqbank'] = 'Přidat úlohy do kategorie {$a->catname}: {$a->link}';
$string['addnewuseroverride'] = 'Přidat přenastavení uživatele';
$string['addpagebreak'] = 'Přidat zalomení stránky';
$string['addpagehere'] = 'Přidat prázdnou stránku zde';
$string['addquestion'] = 'Přidat úlohu';
$string['addquestionfrombankatend'] = 'Přidat na konec z banky úloh';
$string['addquestionfrombanktopage'] = 'Přidat z banky úloh na stránku {$a}';
$string['addquestions'] = 'Přidat úlohy';
$string['addquestionstoquiz'] = 'Přidat úlohy do stávajícího testu';
$string['addrandom'] = 'Přidat do testu uvedený počet náhodných úloh: {$a}';
$string['addrandom1'] = '<< Přidat';
$string['addrandom2'] = 'náhodné úlohy';
$string['addrandomfromcategory'] = 'Přidat náhodné úlohy z kategorie:';
$string['addrandomquestion'] = 'Přidat náhodnou úlohu';
$string['addrandomquestionatend'] = 'Přidat náhodnou otázku na konec';
$string['addrandomquestiontopage'] = 'Přidat náhodnou úlohu na stránku {$a}';
$string['addrandomquestiontoquiz'] = 'Přidat náhodnou úlohu do testu {$a}';
$string['addselectedquestionstoquiz'] = 'Přidat vybrané úlohy do testu';
$string['addselectedtoquiz'] = 'Přidat vybranou do testu';
$string['addtoquiz'] = 'Přidat do testu';
$string['affectedstudents'] = 'Počet studentů, kterých se změna dotkne: {$a}';
$string['aftereachquestion'] = 'Po přidání každé úlohy';
$string['afternquestions'] = 'Po přidání {$a} úloh';
$string['age'] = 'věk';
$string['allattempts'] = 'Všechny pokusy';
$string['allinone'] = 'Bez omezení';
$string['allowreview'] = 'Umožnit prohlédnutí';
$string['alreadysubmitted'] = 'V tomto pokusu jste své odpovědi zřejmě již odeslali.';
$string['alternativeunits'] = 'Alternativní jednotky';
$string['alwaysavailable'] = 'Stále k dispozici';
$string['alwayslatest'] = 'Vždy nejnovější';
$string['analysisoptions'] = 'Nastavení analýzy';
$string['analysistitle'] = 'Tabulka položkové analýzy';
$string['answer'] = 'Odpověď';
$string['answered'] = 'Zodpovězeno';
$string['answerhowmany'] = 'Jedna nebo více odpovědí?';
$string['answers'] = 'Řešení';
$string['answersingleno'] = 'Umožnit více odpovědí';
$string['answersingleyes'] = 'Pouze jedna odpověď';
$string['answertoolong'] = 'Odpověď je přiliš dlouhá (limit překročen na řádku {$a}), použijte nejvýše 255 znaků.';
$string['anytags'] = 'Všechny štítky';
$string['aon'] = 'Formát AON';
$string['areyousureremoveselected'] = 'Skutečně chcete vymazat všechny označené úlohy?';
$string['asshownoneditscreen'] = 'Jak je zobrazeno při úpravách';
$string['attempt'] = 'Pokus {$a}';
$string['attemptalreadyclosed'] = 'Tento pokus byl již ukončen.';
$string['attemptclosed'] = 'Pokus nebyl dosud ukončen';
$string['attemptduration'] = 'Trvání';
$string['attemptedon'] = 'Datum a čas pokusu';
$string['attempterror'] = 'V současnosti se nemůžete pokusit o tento test, protože: {$a}';
$string['attempterrorcontentchange'] = 'Tento náhled testu(revize) již neexistuje. (Při úpravě testu jsou všechny průběžné náhledy automaticky smazány.)';
$string['attempterrorcontentchangeforuser'] = 'Tento pokus testu již neexistuje.';
$string['attempterrorinvalid'] = 'Neplatné ID pokusu testu';
$string['attemptfirst'] = 'První pokus';
$string['attemptgradeddelay'] = 'Prodleva oznámení o hodnocením pokusu';
$string['attemptgradeddelay_desc'] = 'Před odesláním oznámení o hodnocení pokusu se použije prodleva, aby měl učitel čas na úpravu hodnocení.';
$string['attemptincomplete'] = 'Tento pokus (uživatele {$a}) není dosud dokončen.';
$string['attemptlast'] = 'Poslední pokus';
$string['attemptnumber'] = 'Pokus';
$string['attemptquiz'] = 'Pokus testu';
$string['attemptquiznow'] = 'Pokusit se o zvládnutí testu';
$string['attemptreviewtitle'] = '{$a}: Náhled pokusu';
$string['attemptreviewtitlepaged'] = '{$a->name}: Náhled pokusu (strana {$a->currentpage} z {$a->totalpages})';
$string['attempts'] = 'Pokusy';
$string['attempts_help'] = 'Celkový počet povolených pokusů (nikoliv počet dalších pokusů).';
$string['attemptsallowed'] = 'Povolený počet pokusů';
$string['attemptsdeleted'] = 'Pokusy odstraněny';
$string['attemptselection'] = 'Vyberte pokusy, které mají být u každého uživatele zahrnuty do analýzy:';
$string['attemptsexist'] = 'Přidávat či odebírat úlohy již není možné.';
$string['attemptsnum'] = 'Pokusů: {$a}';
$string['attemptsnumthisgroup'] = 'Pokusů: {$a->total} ({$a->group} z této skupiny)';
$string['attemptsnumyourgroups'] = 'Pokusů: {$a->total} ({$a->group} z vašich skupin)';
$string['attemptsonly'] = 'Ukázat pouze studenty s pokusy';
$string['attemptstate'] = 'Stav';
$string['attemptstillinprogress'] = 'Pokus probíhá';
$string['attemptsummarytitle'] = '{$a}: Souhrn pokusu';
$string['attemptsunlimited'] = 'Neomezený počet pokusů';
$string['attempttitle'] = '{$a}';
$string['attempttitlepaged'] = '{$a->name} (strana {$a->currentpage} z {$a->totalpages})';
$string['autosaveperiod'] = 'Zpoždění automatického ukládání';
$string['autosaveperiod_desc'] = 'Odpovědi studentů mohou být během testu automaticky ukládány každých pár minut. Toto nastavení zvyšuje zátěž serveru, ale minimalizuje možnou ztrátu veškeré práce studentů.

Odpovědi studentů mohou být během testu automaticky ukládány . Odpovědi jsou uloženy vždy, když se změní, a pak po tomto zpoždění. Jedná se o kompromis: kratší zpoždění zvyšuje zátěž serveru, ale minimalizuje možnou ztrátu veškeré práce studentů. Pokud se chystáte  toto zpoždění mnohem zkrátit, měli byste změnit hodnotu postupně a sledovat zatížení serveru. Pokud je zatížení příliš vysoké, zpoždění prodlužte. Nastavení zpoždění na 0 vypne automatické ukládání.';
$string['back'] = 'Zpět k náhledu úlohy';
$string['backtocourse'] = 'Návrat do kurzu';
$string['backtoquestionlist'] = 'Zpět k seznamu úloh';
$string['backtoquiz'] = 'Zpět k úpravě testu';
$string['banknotfound'] = 'Banka úloh nebyla nalezena, hledejte prosím znovu';
$string['bestgrade'] = 'Nejlepší známka';
$string['bothattempts'] = 'Ukázat všechny studenty';
$string['browsersecurity'] = 'Zabezpečení prohlížeče';
$string['browsersecurity_help'] = 'Je-li vybrána možnost "Vyskakovací okno přes celou obrazovku zabezpečené pomocí JavaScriptu",

* Test začne pouze tehdy, pokud má student ve webovém prohlížeči povolen JavaScript
* Test se zobrazí v celoobrazovkovém vyskakovacím okně, které se zobrazí přes všechna ostatní okna a nemá žádné navigační ovládací prvky
* Studentům jsou zakázány, pokud je to možné, používat možnosti jako je kopírování a vkládání';
$string['cachedef_overrides'] = 'Informace o přenastavení uživatele a skupiny';
$string['calculated'] = 'Vypočítávaná úloha';
$string['calculatedquestion'] = 'Vypočítávaná úloha na řádku {$a} není podporována. Úloha bude ignorována';
$string['cannotcreatepath'] = 'Cestu nelze vytvořit ({$a})';
$string['cannoteditafterattempts'] = 'Již nelze přidávat nebo odebírat úlohy, někdo se již pokusil o zvládnutí testu.  ({$a})';
$string['cannotfindprevattempt'] = 'Nelze nalézt předchozí pokus.';
$string['cannotfindquestionregard'] = 'Nepodařilo se získat úlohy pro nové oznámkování!';
$string['cannotinsert'] = 'Nelze vložit úlohu';
$string['cannotinsertrandomquestion'] = 'Nepodařilo se vložit novou náhodnou úlohu!';
$string['cannotloadquestion'] = 'Nebylo možné nahrát možnosti úlohy';
$string['cannotloadtypeinfo'] = 'Není možné nahrát informaci o konkrétním typu úlohy';
$string['cannotopen'] = 'Nelze otevřít exportovaný soubor ({$a})';
$string['cannotremoveallsectionslots'] = 'Vybrali jste všechny úlohy pod nadpisem "{$a}". Není dovoleno odstraňovat všechny úlohy pod hlavičkou sekce.';
$string['cannotremoveslots'] = 'Nelze odebrat úlohy';
$string['cannotrestore'] = 'Nepodařilo se obnovit stavy úloh';
$string['cannotreviewopen'] = 'Nelze prohlížet tento pokus, je stále otevřený.';
$string['cannotsavelayout'] = 'Nepodařilo se uložit rozložení';
$string['cannotsavenumberofquestion'] = 'Nebylo možné uložit počet úloh na stránce';
$string['cannotsavequestion'] = 'Není možné uložit seznam úloh';
$string['cannotsetgrade'] = 'Pro úlohu nelze nastavit nové maximální hodnocení ';
$string['cannotsetsumgrades'] = 'Nepodařilo se nastavit sumu hodnocení';
$string['cannotstartgradesmismatch'] = 'V tomto testu nelze zahájit pokusy. Test je připraven na známku {$a->grade}, ale žádná z úloh v testu nemá známku. To může být upraveno na stránce "Upravit test".';
$string['cannotstartmissingquestion'] = 'Pokus v testu nelze spustit. Definice testu obsahuje úlohu, která neexistuje.';
$string['cannotstartnoquestions'] = 'Pokus v testu nelze spustit. Test nebyl ještě nastaven. Neobsahuje úlohy.';
$string['cannotwrite'] = 'Nelze zapisovat do souboru pro export ({$a})';
$string['canredoquestions'] = 'V pokusu povolit Novou odpověď';
$string['canredoquestions_desc'] = 'Pokud je povoleno, po dokončení pokusu o otázku se zobrazí tlačítko „Zkuste jinou otázku, jako je tato“. To umožňuje pokusit se o podobnou otázku (náhodně vybranou) nebo o stejnou otázku znovu, aniž by bylo nutné odeslat celý pokus o kvíz a zahájit další pokus.
 Tato volba je užitečná hlavně pro praktické testy.

Toto nastavení má vliv pouze na otázky a chování úloh (například Okamžitý výsledek, nebo Interaktivní s vícero pokusy), kde je možné, aby student dokončit otázku, ještě před odesláním svého pokusu.';
$string['canredoquestions_help'] = 'Pokud je povoleno, po dokončení pokusu o otázku se zobrazí tlačítko „Zkuste jinou otázku, jako je tato“. To umožňuje pokusit se o podobnou otázku (náhodně vybranou) nebo o stejnou otázku znovu, aniž by bylo nutné odeslat celý pokus o kvíz a zahájit další pokus.
 Tato volba je užitečná hlavně pro praktické testy.

Toto nastavení má vliv pouze na otázky a chování úloh (například Okamžitý výsledek, nebo Interaktivní s vícero pokusy), kde je možné, aby student dokončit otázku, ještě před odesláním svého pokusu.';
$string['canredoquestionsyes'] = 'Ano, poskytněte možnost vyzkoušet jinou otázku';
$string['caseno'] = 'Ne, na malých/VELKÝCH nezáleží';
$string['casesensitive'] = 'Rozlišovat malá/VELKÁ';
$string['caseyes'] = 'Ano, velikost písmen musí odpovídat';
$string['categoryadded'] = 'Kategorie "{$a}" byla přidána';
$string['categorydeleted'] = 'Kategorie "{$a}" byla odstraněna';
$string['categorynoedit'] = 'Nemáte oprávnění potřebná pro provádění úprav v kategorii "{$a}".';
$string['categoryupdated'] = 'Kategorie byla úspěšně aktualizována';
$string['close'] = 'Zavřít okno';
$string['closebeforeopen'] = 'Datum uzavření musí být po datu otevření.';
$string['closed'] = 'Zavřeno';
$string['closepreview'] = 'Uzavřít náhled';
$string['closereview'] = 'Uzavřít';
$string['comment'] = 'Komentář';
$string['commentorgrade'] = 'Vložte komentář, nebo přepište body';
$string['comments'] = 'Komentáře';
$string['completedon'] = 'Dokončeno';
$string['completionattemptsexhausted'] = 'Požadovaná známka a všechny dostupné pokusy byly dokončeny';
$string['completionattemptsexhausted_help'] = 'Hodnocení testu bylo dokončeno, student vyčerpal maximální počet pokusů.';
$string['completiondetail:minattempts'] = 'Vytvořit pokusy: {$a}';
$string['completiondetail:passorexhaust'] = 'Získat potřebnou známku nebo dokončit všechny dostupné pokusy';
$string['completionminattempts'] = 'Minimální počet pokusů';
$string['completionminattemptsdesc'] = 'Minimální požadovaný počet pokusů: {$a}';
$string['completionminattemptserror'] = 'Minimální počet pokusů musí být nižší nebo roven povoleným pokusům.';
$string['completionpassorattemptsexhausteddesc'] = 'Pro dokončení této aktivity musí student získat potřebnou známku nebo vyčerpat všechny dostupné pokusy';
$string['configadaptive'] = 'Zvolíte-li v této volbě Ano, student bude moci odpovídat na jednu úlohu testu vícekrát';
$string['configattemptsallowed'] = 'Omezení počtu povolených pokusů v rámci testu.';
$string['configdecimaldigits'] = 'Počet desetinných míst v zobrazení hodnocení.';
$string['configdecimalplaces'] = 'Počet desetinných míst v zobrazení hodnocení testu.';
$string['configdecimalplacesquestion'] = 'Počet číslic, které se mají zobrazit za desetinnou čárkou při zobrazení  hodnocení jednotlivých úloh.';
$string['configdelay1'] = 'Nastavíte-li časové zpoždění, pak student musí student po prvním pokusu čekat tuto dobu.';
$string['configdelay1st2nd'] = 'Nastavíte-li zde časové zpoždění, pak student musí student po ukončení prvního pokusu čekat tuto dobu do začátku druhého.';
$string['configdelay2'] = 'Nastavíte-li zde časové zpoždění, pak student musí student před třetím a dalším pokusem čekat tuto dobu do začátku dalšího pokusu.';
$string['configdelaylater'] = 'Pokud nastavíte časovou prodlevu, nebude student moci zahájit třetí, čtvrtý, ... atd. pokus, dokud neuplyne tato doba od konce předešlého pokusu.';
$string['configeachattemptbuildsonthelast'] = 'Pokud je povoleno více pokusů, pak každý následující obsahuje výsledky předchozího pokusu.';
$string['configgrademethod'] = 'Je-li povoleno více pokusů, je třeba určit způsob výpočtu výsledného hodnocení tohoto testu.';
$string['configintro'] = 'Zde definované výchozí hodnoty jsou ty, které jsou použity v novém testu. Můžete tak konfigurovat nastavení testu, která považujete jako pokročilá.';
$string['configintroglobal'] = 'Tato nastavení řídí chování aktivity test v celém systému.';
$string['configmaximumgrade'] = 'Výchozí známka je taková, že známka testu je mimo rozsah.';
$string['confignavmethod'] = 'Při volné navigaci mohou být úlohy zodpovězeny pomocí navigace v libovolném pořadí. V sekvenční navigaci musí být úlohy zodpovězeny v zadaném pořadí.';
$string['confignewpageevery'] = 'Při přidávání úlohy do testu budou vloženy konce stránek budou automaticky podle vybraného nastavení.';
$string['configoutcomesadvanced'] = 'Pokud je povolena tato volba, pak Očekávané výstupy testu mají pokročilé nastavení.';
$string['configpenaltyscheme'] = 'V adaptivním režimu je  za každou nesprávnou odpověď odečtena penalizace.';
$string['configpopup'] = 'Vynucuje při pokusu otevření ve vyskakovacím okně a používá nástroje JavaScript, aby se pokusil omezit kopírování a vkládání, atd. během zpracování testu.';
$string['configrequirepassword'] = 'Studenti musí zadat toto heslo, než se budou moci pokusit řešit test.';
$string['configrequiresubnet'] = 'Studenti mohou realizovat test pouze z těchto počítačů.';
$string['configreviewoptions'] = 'Tyto možnosti určují, které informace uživatelé uvidí při prohlídce pokusu testu nebo v sestavě testu.';
$string['configshowblocks'] = 'Zobrazit bloky během vyplňování testu.';
$string['configshowuserpicture'] = 'Zobraz během vyplňování testu obrázek uživatele.';
$string['configshufflewithin'] = 'Pokud povolíte tuto možnost, pak části, které tvoří jednotlivé úlohy budou náhodně zamíchány pokaždé, když student začne v tomto testu pokus, za předpokladu, že volba je současně povolena v nastavení úloh.';
$string['configtimelimit'] = 'Výchozí časový limit pro testy v minutách. 0 znamená bez omezení.';
$string['configtimelimitsec'] = 'Výchozí časový limit pro testy v sekundách. 0 znamená bez omezení.';
$string['configurerandomquestion'] = 'Konfigurovat úlohu';
$string['confirmclose'] = 'Po uzavření pokusu již nebudete mít možnost upravit své odpovědi.';
$string['confirmremovequestion'] = 'Jste si jisti, že chcete odstranit tuto {$a} úlohu?';
$string['confirmremovesectionheading'] = 'Jste si jisti, že chcete odstranit záhlaví sekce "{$a}"?';
$string['confirmserverdelete'] = 'Opravdu chcete odstranit server <b>{$a}</b> ze seznamu?';
$string['connectionerror'] = 'Ztráta připojení k síti, automatické ukládání selhalo.

Poznamenejte si odpovědi na této stránce a pokuste se znovu připojit.

Pokud se spojení samo obnoví, vaše odpovědi budou uloženy a tato zpráva zmizí.';
$string['connectionok'] = 'Připojení k síti obnoveno, můžete bezpečně pokračovat.';
$string['containercategorycreated'] = 'Tato kategorie byla vytvořena proto, aby do ní mohly být umístěny všechny původní kategorie přesunuté z důvodů uvedených níže do kategorie nejvyšší úrovně.';
$string['continueattemptquiz'] = 'Pokračovat v pokusu';
$string['continuepreview'] = 'Pokračovat v poslední prohlídce';
$string['copyingfrom'] = 'Vytváří se kopie úlohy "{$a}"';
$string['copyingquestion'] = 'Vytváří se kopie úlohy';
$string['correct'] = 'Správná odpověď';
$string['correctanswer'] = 'Správná odpověď';
$string['correctanswerformula'] = 'Vzorec správné odpovědi';
$string['correctansweris'] = 'Správná odpověď: {$a}';
$string['correctanswerlength'] = 'Platné číslice';
$string['correctanswers'] = 'Správné odpovědi';
$string['correctanswershows'] = 'U správných odpovědí se zobrazují';
$string['corrresp'] = 'Správná odpověď';
$string['countdown'] = 'Odpočítávání';
$string['countdownfinished'] = 'Test se uzavírá, měli byste okamžitě odeslat své odpovědi.';
$string['countdowntenminutes'] = 'Test bude uzavřen za deset minut.';
$string['coursetestmanager'] = 'Formát Course Test Manager';
$string['createcategoryandaddrandomquestion'] = 'Vytvořit kategorii a přidat náhodnou úlohu';
$string['createfirst'] = 'Nejdříve musíte vytvořit úlohy s krátkou tvořenou odpovědí.';
$string['createmultiple'] = 'Vytvořit více úloh najednou';
$string['createnewquestion'] = 'Vytvořit novou úlohu';
$string['createquestionandadd'] = 'Vytvořit novou úlohu a uložit ji do testu.';
$string['currentbank'] = 'Aktuální banka: {$a}';
$string['custom'] = 'Vlastní formát';
$string['dataitemneed'] = 'Pro vytvoření platné úlohy musíte vložit nejméně jednu datovou sadu.';
$string['datasetdefinitions'] = 'Definice sdílených datových sad v kategorii {$a}';
$string['datasetnumber'] = 'Číslo';
$string['daysavailable'] = 'Zbývá dnů';
$string['decimaldigits'] = 'Počet desetinných míst ve známce';
$string['decimalplaces'] = 'Počet desetinných míst ve známkách';
$string['decimalplaces_help'] = 'Pomocí tohoto nastavení můžete určit, kolik desetinných míst se zobrazí v bodovém skóre nebo ve známkách studentů.
Toto nastavení ovlivňuje pouze zobrazení známek. Nemá vliv na vlastní vnitřní výpočty a zaokrouhlování známek.';
$string['decimalplacesquestion'] = 'Desetinná místa v hodnocení úloh';
$string['decimalplacesquestion_help'] = 'Počet číslic zobrazených za desetinnou čárkou při zobrazování hodnocení jednotlivých úloh.';
$string['decimalpoints'] = 'Počet desetinných míst';
$string['default'] = 'Výchozí';
$string['defaultgrade'] = 'Standardní počet bodů za úlohu';
$string['defaultinfo'] = 'Výchozí kategorie pro ukládání testových úloh';
$string['defaultsettings'] = 'Výchozí nastavení testu';
$string['delay1'] = 'Časová prodleva mezi prvním a druhým pokusem';
$string['delay1st2nd'] = 'Časová prodleva mezi prvním a druhým pokusem';
$string['delay1st2nd_help'] = '<p>Pokud nastavíte časovou prodlevu mezi prvním a druhým pokusem, bude student
muset čekat před tím, než se bude moci pokusit o druhé splnění testu.</p>';
$string['delay2'] = 'Časová prodleva mezi dalšími pokusy';
$string['delaylater'] = 'Prodleva mezi dalšími pokusy';
$string['delaylater_help'] = '<p>Pokud nastavíte časovou prodlevu mezi dalšími pokusy, bude student muset
čekat před tím, než se bude moci pokusit o třetí nebo další splnění testu.</p>';
$string['deleteattemptcheck'] = 'Jste si naprosto jisti, že chcete úplně odstranit tyto pokusy?';
$string['deleteselected'] = 'Odstranit vybrané';
$string['deletingquestionattempts'] = 'Odstraňování pokusů';
$string['description'] = 'Popis';
$string['disabled'] = 'Zakázáno';
$string['displayoptions'] = 'Způsob zobrazení';
$string['donotuseautosave'] = 'Nepoužívat automatické ukládání';
$string['download'] = 'Klikněte pro stažení exportovaného souboru';
$string['downloadextra'] = '(Soubor je rovněž uložen ve složce souborů kurzu v adresáři \'test\'.)';
$string['dragtoafter'] = 'Za {$a}';
$string['dragtostart'] = 'Na začátek';
$string['duplicateresponse'] = 'Tato odpověď byla ignorována, protože jste stejnou odpověď zadali již dříve.';
$string['eachattemptbuildsonthelast'] = 'Každý pokus staví na předchozím';
$string['eachattemptbuildsonthelast_help'] = '<p>Pokud povolíte více pokusů pro splnění testu a u nastavení "Každý pokus
staví na předchozím" zvolíte <b>Ano</b>, bude test při každém novém pokusu
obsahovat výsledky pokusu předchozího. Test pak může být splněn v rámci
několika pokusů.</p>

<p>Pokud chcete, aby se studentovi při každém pokusu ukázal prázdný test,
zvolte u tohoto nastavení <b>Ne</b>.</p>';
$string['edit_slotdisplaynumber_hint'] = 'Upravit číslo otázky (max. 16 znaků)';
$string['edit_slotdisplaynumber_label'] = 'Nová hodnota pro {$a}';
$string['editcategories'] = 'Upravit kategorie';
$string['editcategory'] = 'Upravit kategorii';
$string['editcatquestions'] = 'Upravit kategorie úloh';
$string['editingquestion'] = 'Úprava úlohy';
$string['editingquiz'] = 'Úprava testu';
$string['editingquiz_help'] = 'Při vytváření testu jsou hlavní následující pojmy:

* Test, obsahující úlohy na jedné nebo více stránkách
* Banka úloh, která uchovává kopie všech úloh organizovaných do kategorií
* Náhodné úlohy - student dostane při každém pokusu různé úlohy a jednotliví studenti dostanou odlišné úlohy';
$string['editingquiz_link'] = 'mod/quiz/edit';
$string['editingquizx'] = 'Upravit test: {$a}';
$string['editmaxmark'] = 'Upravit maximální známku';
$string['editoverride'] = 'Upravit přenastavení';
$string['editqcats'] = 'Upravit kategorie úloh';
$string['editquestion'] = 'Upravit úlohu';
$string['editquestions'] = 'Upravit úlohy';
$string['editquiz'] = 'Upravit test';
$string['editquizquestions'] = 'Upravit testové úlohy';
$string['emailconfirmautosubmitsmall'] = 'Děkujeme za zaslání odpovědí na "{$a->quizname}"';
$string['emailconfirmbody'] = 'Vážený/á {$a->username},

Děkujeme vám za odevzdání vašich odpovědí na test \'{$a->quizname}\' v kurzu \'{$a->coursename}\', ke kterému došlo {$a->submissiontime}.

Tento email potvrzuje, že  vaše odpovědi byly uloženy.

Pro další přístup k informacím o tomto testu navštivte {$a->quizurl}.';
$string['emailconfirmbodyautosubmit'] = 'Vážený/á {$a->username},

Termín na odevzdání na test "{$a->quizname}" v kurzu "{$a->coursename}" vypršel. Vaše odpovědi byly odeslány automaticky v {$a->timetime}.

Tato zpráva potvrzuje, že  vaše odpovědi byly uloženy.

Pro další přístup k tomuto testu navštivte {$a->quizurl}.';
$string['emailconfirmsmall'] = 'Potvrzujeme úspěšné odevzdání testu "{$a->quizname}"';
$string['emailconfirmsubject'] = 'Potvrzení o odevzdání: {$a->quizname}';
$string['emailmanualgradedbody'] = 'Zdravíme {$a->studentname},

Vaše odpovědi na "{$a->quizname}" v kurzu "{$a->coursename}" na adrese {$a->attempttimefinish} byly nyní ohodnoceny.

Své skóre a zpětnou vazbu si budete moci prohlédnout tak, že navštívíte "{$a->quizurl}"  a zkontrolujete svůj pokus.';
$string['emailmanualgradedsubject'] = 'Váš pokus o {$a->quizname} byl ohodnocen';
$string['emailnotifybody'] = 'Vážený/á {$a->username},

{$a->studentname} odevzdal(a) odpovědi na test "{$a->quizname}" ({$a->quizurl})
v kurzu "{$a->coursename}"

Výsledky tohoto pokusu si můžete prohlédnout na stránce {$a->quizreviewurl}.';
$string['emailnotifysmall'] = '{$a->studentname} dokončil test {$a->quizname}. Podrobnosti najdete na {$a->quizreviewurl}';
$string['emailnotifysubject'] = '{$a->studentname} odevzdal test {$a->quizname}';
$string['emailoverduebody'] = 'Vážený/á {$a->studentname},

zahájil/a jste pokus v testu "{$a->quizname}"
v kurzu "{$a->coursename}", ale neodeslal/a jste jej. Váš test musí být odeslán nejpozději do {$a->attemptduedate}.

Pro odeslání tohoto pokusu přejděte na stránku {$a->attemptsummaryurl} a stiskněte tlačítko Odeslat. Musíte tak učinit nejpozději do {$a->attemptgraceend}, jinak se vám pokus nebude počítat.';
$string['emailoverduesmall'] = 'Neodeslal/a jste pokus v testu  {$a->quizname}.
Pokud jej chcete odeslat, přejděte na {$a->attemptsummaryurl} před {$a->attemptgraceend}.';
$string['emailoverduesubject'] = 'Pokus je po limitu: {$a->quizname}';
$string['empty'] = 'Prázdný';
$string['enabled'] = 'Povoleno';
$string['endtest'] = 'Konec testu…';
$string['erroraccessingreport'] = 'Nemáte přístup k tomuto přehledu';
$string['errorinquestion'] = 'Chyba v úloze';
$string['errormissingquestion'] = 'Chyba – systém postrádá úlohu s id {$a}';
$string['errornotnumbers'] = 'Chyba – odpovědi musejí být číselné';
$string['errorunexpectedevent'] = 'Neočekávaný kód události {$a->event} nalezen pro úlohu {$a->questionid} v pokusu {$a->attemptid}.';
$string['essay'] = 'Dlouhá tvořená odpověď';
$string['essayquestions'] = 'Zadání';
$string['eventattemptautosaved'] = 'Pokus testu se automaticky uloží';
$string['eventattemptdeleted'] = 'Pokus testu odstraněn';
$string['eventattemptmanualgradingcomplete'] = 'Ruční hodnocení pokusu testu dokončen';
$string['eventattemptpreviewstarted'] = 'Zahájen náhled pokusu testu';
$string['eventattemptquestionrestarted'] = 'Úloha testu byla restartována';
$string['eventattemptreviewed'] = 'Přehled pokusu testu';
$string['eventattemptsummaryviewed'] = 'Zobrazen souhrn pokusů testu';
$string['eventattemptupdated'] = 'Úloha testu byla aktualizována';
$string['eventattemptviewed'] = 'Zobrazen pokus testu';
$string['eventeditpageviewed'] = 'Zobrazena stránka úpravy testu';
$string['eventoverridecreated'] = 'Schváleno vytvoření testu';
$string['eventoverridedeleted'] = 'Schváleno odstranění testu';
$string['eventoverrideupdated'] = 'Schváleno aktualizování testu';
$string['eventpagebreakcreated'] = 'Konec stránky byl vytvořen';
$string['eventpagebreakdeleted'] = 'Konec stránky odstraněn';
$string['eventquestionmanuallygraded'] = 'Ručně známkované úlohy';
$string['eventquizattemptabandoned'] = 'Přerušený pokus';
$string['eventquizattemptgraded'] = 'Pokus testu hodnocen';
$string['eventquizattemptregraded'] = 'Pokus testu byl znovu phodnocen';
$string['eventquizattemptreopened'] = 'Znovuotevření pokusu testu';
$string['eventquizattemptstarted'] = 'Zahájený pokus';
$string['eventquizattemptsubmitted'] = 'Odeslán pokus testu';
$string['eventquizattempttimelimitexceeded'] = 'Vypršel časový limit pokusu';
$string['eventquizgradeitemcreated'] = 'Položka hodnocení testu byla vytvořena';
$string['eventquizgradeitemdeleted'] = 'Položka hodnocení testu byla smazána';
$string['eventquizgradeitemorderchanged'] = 'Pořadí položek hodnocení testu změněno';
$string['eventquizgradeitemupdated'] = 'Položka hodnocení testu byla aktualizována';
$string['eventquizgradeupdated'] = 'Hodnocení testu aktualizováno';
$string['eventquizrepaginated'] = 'Test přestránkován';
$string['eventreportviewed'] = 'Zobrazena sestava testu';
$string['eventsectionbreakcreated'] = 'Byl vytvořen konec sekce';
$string['eventsectionbreakdeleted'] = 'Konec sekce odstraněn';
$string['eventsectionshuffleupdated'] = 'Míchání pořadí sekcí aktualizováno';
$string['eventsectiontitleupdated'] = 'Název sekce aktualizován';
$string['eventslotcreated'] = 'Slot vytvořen';
$string['eventslotdeleted'] = 'Slot smazán';
$string['eventslotdisplayedquestionnumberupdated'] = 'Číslo zobrazené úlohy ve slotu bylo aktualizováno';
$string['eventslotgradeitemupdated'] = 'Položka hodnocení slotu byla aktualizována';
$string['eventslotmarkupdated'] = 'Značka slotu aktualizována';
$string['eventslotmoved'] = 'Slot přesunut';
$string['eventslotrequirepreviousupdated'] = 'Slot vyžaduje předchozí aktualizaci';
$string['eventslotversionupdated'] = 'Verze slotu aktualizována';
$string['everynquestions'] = 'Každých {$a} úloh';
$string['everyquestion'] = 'Každá úloha';
$string['everythingon'] = 'Vše zapnuto';
$string['existingcategory'] = 'Existující kategorie';
$string['exportcategory'] = 'exportovat kategorii';
$string['exporterror'] = 'V průběhu exportu se objevila chyba';
$string['exportingquestions'] = 'Úlohy se exportují do souboru';
$string['exportname'] = 'Jméno souboru';
$string['exportquestions'] = 'Exportovat úlohy do souboru';
$string['extraattemptrestrictions'] = 'Další omezení pokusů';
$string['false'] = 'Nepravda';
$string['feedback'] = 'Komentář';
$string['feedbackerrorboundaryformat'] = 'Meze hodnocení reakce musí být buď procentem, nebo číslem. Hodnota, kterou vkládáte pro mez {$a} není uznána.';
$string['feedbackerrorboundaryoutofrange'] = 'Meze hodnocení reakce musí být mezi 0% a 100%. Hodnota, kterou vkládáte pro mez {$a} je mimo rozsah.';
$string['feedbackerrorjunkinboundary'] = 'Do políček mezí hodnocení reakce musíte psát bez vynechávání mezer';
$string['feedbackerrorjunkinfeedback'] = 'Do políček reakce musíte psát bez vynechávání mezer';
$string['feedbackerrororder'] = 'Meze hodnocení reakce musí být uspořádány, nejvyšší první. Hodnota, kterou jste vložili pro mez {$a} je mimo pořadí.';
$string['file'] = 'Soubor';
$string['fileformat'] = 'Formát souboru';
$string['fillcorrect'] = 'Ukázat správné odpovědi';
$string['filloutnumericalanswer'] = 'Poskytněte alespoň jednu možnou odpověď a toleranci. První odpovídající odpověď bude použita pro určení známky a reakce. Pokud připravíte nějakou reakci bez odpovědi na konci, bude ukázána studentovi, jehož odpověď nekoresponduje s žádnou jinou danou odpovědí.';
$string['filloutoneanswer'] = 'Musíte vyplnit alespoň jednu odpověď. Prázdné odpovědi nebudou použity. "*" může být použit jako zástupný znak pro libovolné znaky. První vyhovující odpověď bude použita pro určení známky a reakce.';
$string['filloutthreequestions'] = 'Musíte vyplnit alespoň tři otázky s přiřazením odpovědí. Můžete nabídnout další špatné odpovědi tím, že odpověď má prázdnou otázku. Záznamy, kde otázka i odpověď jsou prázdné, budou ignorovány.';
$string['fillouttwochoices'] = 'Musíte vyplnit alespoň dvě možnosti. Prázdné možnosti nebudou použity.';
$string['finishattemptdots'] = 'Dokončení pokusu ...';
$string['finishreview'] = 'Dokončit prohlídku';
$string['forceregeneration'] = 'vnutit regeneraci';
$string['formatnotfound'] = 'Nelze najít formát pro export/import: {$a}';
$string['formulaerror'] = 'Chyba ve vzorci!';
$string['fractionsaddwrong'] = 'Součet kladných hodnocení není roven 100 %, nýbrž činí {$a} %. <br />Chcete se vrátit a opravit tuto úlohu?';
$string['fractionsnomax'] = 'Jedna z odpovědí by měla být ohodnocena 100 %, aby bylo možné <br />získat plný počet bodů. <br />Chcete se vrátit a opravit tuto úlohu?';
$string['fromfile'] = 'ze souboru';
$string['functiondisabledbysecuremode'] = 'Tato funkcionalita je v současnosti zakázána';
$string['generalfeedback'] = 'Obecná reakce';
$string['generalfeedback_help'] = 'Obecná reakce je text, který se zobrazí po ukončení úlohy. Na rozdíl od reakce, která závisí na odpovědi na konkrétní úlohu, je vždy zobrazena stejná obecná reakce.';
$string['gobacktoquiz'] = 'Zpět';
$string['graceperiod'] = 'Lhůta pro odevzdání';
$string['graceperiod_desc'] = 'Nastavení je aktivní v případě, že bylo v sekci <b>Když vyprší čas</b> zvoleno „Existuje lhůta ...“, pak je to výchozí množství času navíc, které je povoleno.';
$string['graceperiod_help'] = 'Nastavení je aktivní v případě, že bylo v sekci <b>Když vyprší čas</b> zvoleno „Existuje lhůta ...“, pak je to výchozí množství času navíc, které je povoleno.';
$string['graceperiodmin'] = 'Poslední lhůta pro odevzdání';
$string['graceperiodmin_desc'] = 'Na konci testu je potenciální problém.
Na jedné straně chceme, aby studenti pracovali až do poslední vteřiny - když vyprší čas je časovačem pokus testu automaticky odesílán. Na druhé straně pak může být server přetížen a nějaký čas bude trvat zpracování odeslaných odpovědí.
Proto budeme odpovědi přijímat ještě několik vteřin po vypršení termínu, tak studenti nejsou trestáni za pomalý server. Avšak student by mohl podvádět a získat tolik vteřin na odpovědi v testu. Musíte udělat kompromis založený na víře ve výkon vašeho serveru během testů.';
$string['graceperiodtoosmall'] = 'Lhůta musí být delší než {$a}.';
$string['gradeall'] = 'Oznámkovat vše';
$string['gradeaverage'] = 'Průměrná známka';
$string['gradeboundary'] = 'Meze bodování';
$string['gradeessays'] = 'Oznámkovat dlouhé tvořené odpovědi';
$string['gradehighest'] = 'Nejvyšší známka';
$string['gradeitemdefaultname'] = 'Nová položka hodnocení {$a}';
$string['gradeitemdelete'] = 'Smazat položku hodnocení {$a}';
$string['gradeitemedit'] = 'Upravit název položky hodnocení {$a}';
$string['gradeitemmarkscheme'] = 'Přiřadit položky hodnocení';
$string['gradeitemnewname'] = 'Nový název položky hodnocení {$a}';
$string['gradeitemnoneselected'] = '[žádný]';
$string['gradeitemnoslots'] = 'Tento test nemá zatím žádné otázky. Nejprve přidejte otázky a poté se vraťte sem a nastavte položky hodnocení.';
$string['gradeitems'] = 'Položky hodnocení';
$string['gradeitemsautosetup'] = 'Nastavit hodnocení pro každou sekci';
$string['gradeitemsetup'] = 'Nastavení hodnocení položek';
$string['gradeitemsnoneyet'] = 'Vytvořte položky hodnocení ve svém testu. Přidělte úlohy nebo testové sekce těmto položkám hodnocení, abyste mohli výsledky hodnocení rozdělit do různých oblastí.';
$string['gradeitemsremoveall'] = 'Resetovat nastavení';
$string['gradeitemsremoveallconfirm'] = 'Resetovat nastavení položek hodnocení?';
$string['gradeitemsremoveallmessage'] = 'Tím smažete všechny položky hodnocení a zrušíte přiřazení otázek a sekcí k nim.<br><br>Tato akce neovlivní samotné úlohy a sekce ani stávající pokusy v rámci testu.';
$string['gradeitemsremovealltitle'] = 'Obnovit nastavení položek hodnocení';
$string['grademethod'] = 'Metoda známkování';
$string['grademethod_help'] = '<p>Jestliže povolíte více pokusů pro splnění testu, máte k dispozici několik
metod, jak z hodnocení jednotlivých pokusů vypočítat výslednou známku studenta
za daný test.</p>

<p><b>Nejvyšší známka</b></p>

<p>&nbsp;</p>

<div style="margin-left: 2em">
  <p>Jako výsledná známka se použije výsledek pokusu, ve kterém student dosáhl
  nejvyššího počtu bodů.</p>
</div>

<p><b>Průměrná známka</b></p>

<p>&nbsp;</p>

<div style="margin-left: 2em">
  <p>Jako výsledná známka se použije průměrný počet bodů vypočtený ze všech
  pokusů.</p>
</div>

<p><b>První pokus</b></p>

<p>&nbsp;</p>

<div style="margin-left: 2em">
  <p>Jako výsledná známka se použije počet bodů, kterého student dosáhl při
  prvním pokusu (na ostatní pokusy se nebere ohled).</p>
</div>

<p><b>Poslední pokus</b></p>

<p>&nbsp;</p>

<div style="margin-left: 2em">
  <p>Jako výsledná známka se použije počet bodů, kterého student dosáhl při
  posledním pokusu.</p>
</div>';
$string['gradesdeleted'] = 'Známky z testu odstraněny';
$string['gradesofar'] = '{$a->method}: {$a->mygrade} / {$a->quizgrade}.';
$string['gradetopassmustbeset'] = 'Požadovaná známka nemůže být nula, protože to test má svou metodu dokončení nastavena na vyžadovanou požadovanou známku. Nastavte prosím nenulovou hodnotu.';
$string['gradetopassoutof'] = 'Požadovaná známka: {$a->grade} z {$a->maxgrade}';
$string['gradingdetails'] = 'Bodový zisk: {$a->raw}/{$a->max}.';
$string['gradingdetailsadjustment'] = 'Výsledný bodový zisk při započtení předchozích penalizací: <strong>{$a->cur}/{$a->max}</strong>.';
$string['gradingdetailspenalty'] = 'Tento pokus byl zatížen penalizací {$a}.';
$string['gradingdetailszeropenalty'] = 'Tento pokus nebyl penalizován.';
$string['gradingmethod'] = 'Metoda hodnocení: {$a}';
$string['groupoverrides'] = 'Skupinová přenastavení';
$string['groupoverridesdeleted'] = 'Přenastavení skupiny odstraněna';
$string['groupsnone'] = 'V tomto kurzu nejsou žádné skupiny, ke kterým máte přístup.';
$string['guestsno'] = 'Bohužel, hosté si nemohou prohlížet nebo zkoušet testy.';
$string['hidebreaks'] = 'Skrýt zalomení stránky';
$string['hidereordertool'] = 'Skrýt nástroj pro změnu pořadí';
$string['history'] = 'Historie odpovědí:';
$string['howquestionsbehave_desc'] = 'Výchozí chování úloh v testu.';
$string['imagedisplay'] = 'Obrázek k zobrazení';
$string['import_help'] = 'Tato funkce vám umožňuje importovat úlohy z externích textových souborů.

Pokud váš soubor obsahuje jinou znakovou sadu než ASCII znaky, pak musíte použít kódování UTF-8. Buďte zvláště opatrní u souborů generovaných aplikací Microsoft Office, které obyčejně používají speciální kódování, které nebude správně zpracováno.

Import a export formátů jsou zásuvné doplňky. Další volitelné formáty mohou být k dispozici v databázi doplňků.';
$string['import_link'] = 'question/import';
$string['importcategory'] = 'importovat kategorii';
$string['importerror'] = 'V průběhu importu se objevila chyba';
$string['importfilearea'] = 'Importovat ze souboru v kurzu';
$string['importfileupload'] = 'Importovat ze souboru na vašem počítači';
$string['importfromthisfile'] = 'Importovat z tohoto souboru';
$string['importingquestions'] = 'Importuji {$a} úloh ze souboru';
$string['importmax10error'] = 'Chybná definice úlohy: úloha nesmí obsahovat více než deset odpovědí.';
$string['importmaxerror'] = 'Chybná definice úlohy: příliš mnoho odpovědí.';
$string['importquestions'] = 'Importovat úlohy ze souboru';
$string['inactiveoverridehelp'] = '* Toto přepsání není aktivní, protože přístup uživatele k aktivitě je omezen. Důvodem může být přiřazení skupin nebo rolí, jiná omezení přístupu nebo skrytá aktivita.';
$string['incorrect'] = 'Nesprávná odpověď';
$string['indicator:cognitivedepth'] = 'Kognitivní Test';
$string['indicator:cognitivedepth_help'] = 'Tento ukazatel je založen na studentem získané kognitivní hloubce v aktivitě Test.';
$string['indicator:cognitivedepthdef'] = 'Kognitivní Test';
$string['indicator:cognitivedepthdef_help'] = 'Během tohoto intervalu analýzy dosáhl účastník tohoto procenta kognitivní angažovanosti nabízené aktivitami Test (Úrovně = Bez zobrazení, Zobrazení, Odevzdání, Zobrazení zpětné vazby, Komentář ke zpětné vazbě, Nové odevzdání po zobrazení zpětné vazby)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Sociální Test';
$string['indicator:socialbreadth_help'] = 'Tento ukazatel je založen na studentem získané sociální šířce v aktivitě Test.';
$string['indicator:socialbreadthdef'] = 'Sociální Test';
$string['indicator:socialbreadthdef_help'] = 'Během tohoto intervalu analýzy dosáhl účastník tohoto procenta sociální angažovanosti nabízené aktivitou Test (Úrovně = Bez účasti, Účastník sám, Účastník s ostatními)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['indivresp'] = 'Odpovědi uživatelů';
$string['info'] = 'Info';
$string['infoshort'] = 'i';
$string['initialnumfeedbacks'] = 'Hodnota pro počet polí Celkové reakce';
$string['initialnumfeedbacks_desc'] = 'Při vytvoření testu je nabídnuto tolik prázdných polí pro Celkovou reakci. Jakmile je test vytvořen, zobrazuje formulář počet polí požadovaných pro reakci v testu. Výchozí hodnota musí být alespoň 1.';
$string['inprogress'] = 'Probíhá';
$string['introduction'] = 'Popis';
$string['invalidattemptid'] = 'Pokus s tímto identifikátorem neexistuje';
$string['invalidcategory'] = 'Neplatné ID kategorie';
$string['invalidoverrideid'] = 'Neplatné ID přepsání.';
$string['invalidquestionid'] = 'Neplatný identifikátor úlohy';
$string['invalidquizid'] = 'Neplatný identifikátor testu';
$string['invalidrandomslot'] = 'Neplatné identifikační číslo místa pro úlohy.';
$string['invalidsource'] = 'Tento zdroj není považován za platný.';
$string['invalidsourcetype'] = 'Neplatný typ úlohy.';
$string['invalidstateid'] = 'Neplatný identifikátor stavu';
$string['lastanswer'] = 'Vaše předchozí odpověď';
$string['lastautosave'] = 'Naposledy uloženo: {$a}';
$string['layout'] = 'Rozložení';
$string['layoutasshown'] = 'Rozložení na stránce jak je zobrazeno';
$string['layoutasshownwithpages'] = 'Rozložení na stránce jak je zobrazeno <small>(nová stránka automaticky po {$a} úlohách)</small>';
$string['layoutshuffledandpaged'] = 'Náhodně zamíchané úlohy, počet úloh na stránce: {$a}';
$string['layoutshuffledsinglepage'] = 'Náhodně zamíchané úlohy, všechny na jedné stránce';
$string['link'] = 'Odkaz';
$string['listitems'] = 'Seznam položek testu';
$string['literal'] = 'Literál';
$string['loadingquestionsfailed'] = 'Nepodařilo se nahrát úlohy: {$a}';
$string['makecopy'] = 'Uložit jako novou úlohu';
$string['managetypes'] = 'Spravovat typy úloh a servery';
$string['manualgradequestion'] = 'Ručně známkované úlohy {$a->question} v {$a->quiz} uživatelem {$a->user}';
$string['manualgrading'] = 'Známkování';
$string['mark'] = 'Odeslat';
$string['markall'] = 'Odeslat aktuální stránku';
$string['marks'] = 'Body';
$string['marks_help'] = 'Známka za každou úlohu a celkové skóre pokusu. Známky můžete vybrat pouze v případě, že je vybrána možnost Maximální známka.';
$string['match'] = 'Přiřazování';
$string['matchanswer'] = 'Přiřazená odpověď';
$string['matchanswerno'] = 'Přiřazená odpověď {$a}';
$string['max'] = 'Max.';
$string['maxmark'] = 'Nejvyšší známka';
$string['maxmarks'] = 'Maximální známky';
$string['maxmarks_help'] = 'Maximální možný počet bodů pro každou úlohu.';
$string['messageprovider:attempt_grading_complete'] = 'Oznámení, že váš pokus byl ohodnocen';
$string['messageprovider:attempt_overdue'] = 'Upozornění na lhůtu pro odevzdání testu';
$string['messageprovider:confirmation'] = 'Potvrzení o odevzdání testu';
$string['messageprovider:quiz_open_soon'] = 'Test se brzy otevře';
$string['messageprovider:submission'] = 'Oznámení o odevzdání testu vašich studentů';
$string['min'] = 'Min.';
$string['minutes'] = 'Minuty';
$string['missingcategory'] = 'Chybí kategorie úloh';
$string['missingcorrectanswer'] = 'Musíte určit správnou odpověď';
$string['missingitemtypename'] = 'Chybí název';
$string['missingquestion'] = 'Chybí popisek úlohy za řádkem {$a}';
$string['modulename'] = 'Test';
$string['modulename_help'] = 'Modul Test umožňuje vkládat testy skládající se z výběrových úloh, dichotomických úloh, srovnávacích úloh, úloh s krátkou tvořenou odpovědí a dalších. Každý pokus o absolvování testu je automaticky ohodnocen a student může v závislosti na nastavení dostat zpětnou vazbu a/nebo zjistit správné odpovědi.

Učitel může nastavit počet povolených pokusů, úlohy zamíchat nebo náhodně vybírat z banky úloh. Může být nastaven časový limit pro testování.

Každý pokus je automaticky hodnocen vyjma tvořené dlouhé tvořené odpovědi a hodnocení je zapsáno do klasifikace.

Učitel si může vybrat kdy a zda poskytne pokyny, celkovou reakci a zda jsou studentům zobrazeny správné odpovědi .

Testy mohou být použity

* jako zkouška v kurzu
* jako mini test pro samostudium nebo na konci tématu
* v souborném testu s využitím úloh předchozích testů
* chcete-li zajistit okamžitý test výkonu
* pro sebehodnocení studenta';
$string['modulename_link'] = 'mod/quiz/view';
$string['modulenameplural'] = 'Testy';
$string['moveselectedonpage'] = 'Přesunout vybrané úlohy na stranu: {$a}';
$string['multichoice'] = 'Úloha s výběrem odpovědí';
$string['multipleanswers'] = 'Označte všechny správné odpovědi';
$string['mustbesubmittedby'] = 'Tento pokus musí být odeslán nejpozději {$a}.';
$string['name'] = 'Jméno';
$string['navigatenext'] = 'Další stránka';
$string['navigateprevious'] = 'Předchozí stránka';
$string['navmethod'] = 'Metoda navigace';
$string['navmethod_free'] = 'Volně';
$string['navmethod_help'] = 'Pokud je zvolena metoda "Sekvenčně" namísto "Volně", student musí procházet úlohy v testu popořadě a nemůže se vracet na předchozí stránky nebo přeskakovat dopředu.';
$string['navmethod_seq'] = 'Sekvenčně';
$string['navnojswarning'] = 'Upozornění: tyto odkazy neuloží vaše odpovědi. Použijte tlačítko Další v dolní části stránky.';
$string['neverallononepage'] = 'Nikdy, všechny úlohy na jedné stránce';
$string['newattemptfail'] = 'Chyba: Nebylo možné začít nový pokus.';
$string['newcategory'] = 'Nová kategorie';
$string['newpage'] = 'Nová strana';
$string['newpage_help'] = '<p>Pokud je test dlouhý, má smysl jej rozložit na více stránek tak, že se omezí počet úloh na jedné stránce. V závislosti na tomto nastavení budou do testu automaticky spolu s úlohami vkládány i předěly mezi jednotlivými stránkami. Předěly mezi stránkami je ale možné později přesouvat i ručně, a to na stránce pro úpravu testu.</p>';
$string['newpageevery'] = 'Automaticky začít novou stranu';
$string['newsectionheading'] = 'Nový nadpis';
$string['noanswers'] = 'Není vybrána žádná odpověď!';
$string['noattempts'] = 'Zatím se nikdo nepokusil napsat tento test.';
$string['noattemptsfound'] = 'Nenalezen žádný pokus.';
$string['noattemptstoshow'] = 'Nenalezeny žádné pokusy';
$string['nocategory'] = 'Nebyla určena kategorie, nebo byla určena nesprávně.';
$string['noclose'] = 'Neexistuje datum uzavření';
$string['nocommentsyet'] = 'Zatím bez komentářů';
$string['noconnection'] = 'Momentálně není možné připojit se k webové službě, která by zpracovala tuto úlohu. Obraťte se prosím na správce serveru.';
$string['nodataset'] = 'ničím – nejedná se o masku';
$string['nodatasubmitted'] = 'Nebyly vloženy žádné údaje.';
$string['noessayquestionsfound'] = 'Nebyly nalezeny žádné ručně známkované úlohy.';
$string['nogradewarning'] = 'Tento test není známkován. Nelze proto nastavit celkovou reakci, která je závislá na výsledné známce.';
$string['nomoreattempts'] = 'Již nemáte další pokusy.';
$string['none'] = 'Žádné';
$string['noopen'] = 'Neexistuje datum otevření';
$string['nooverridedata'] = 'Musíte přenastavit alespoň jedno z nastavení testu.';
$string['nopossibledatasets'] = 'Nejsou dostupné žádné datové sady.';
$string['noquestionintext'] = 'Úloha neobsahuje žádné vnořené otázky.';
$string['noquestions'] = 'Dosud nebyly vloženy žádné úlohy.';
$string['noquestionsfound'] = 'Nenalezeny žádné úlohy.';
$string['noquestionsinquiz'] = 'V tomto test nejsou žádné úlohy.';
$string['noquestionsnotinuse'] = 'Tato náhodná úloha se nepoužije, protože její kategorie je prázdná';
$string['noquestionsonpage'] = 'Prázdná stránka';
$string['noresponse'] = 'Nezodpovězeno';
$string['noreview'] = 'Nejste oprávněni prohlédnout si tento test.';
$string['noreviewattempt'] = 'Nemůžete revidovat tento pokus.';
$string['noreviewshort'] = 'Recenze není povolena';
$string['noreviewuntil'] = 'Nejste oprávněni prohlédnout si tento test až do tohoto data: {$a}';
$string['noreviewuntilshort'] = 'Dostupné {$a}';
$string['noscript'] = 'Pro pokračování musíte povolit JavaScript!';
$string['notavailabletostudents'] = 'Upozornění: studenti k tomuto testu nyní nemají přístup.';
$string['notenoughrandomquestions'] = 'V této kategorii  {$a->category} není dost úloh na vytvoření úlohy {$a->name} ({$a->id}).';
$string['notenoughsubquestions'] = 'Není definováno dost podotázek!<br />Chcete se vrátit zpět a opravit tuto úlohu?';
$string['notifyattemptsgradedtask'] = 'Odeslat oznámení o hodnocení pokusů testu';
$string['notimedependentitems'] = 'Časově závislé položky nejsou nyní modulem Test podporovány. Náhradním řešením může být nastavení časového limitu pro celý test. Přejete si vybrat jinou položku (nebo přesto použít stávající)?';
$string['notyetgraded'] = 'Dosud nehodnoceno';
$string['notyetviewed'] = 'Doposud nezobrazeno';
$string['notyourattempt'] = 'Toto není váš pokus!';
$string['noview'] = 'Přihlášený uživatel nemůže prohlížet tento test.';
$string['numattempts'] = '{$a->studentstring}: {$a->studentnum}, pokusů: {$a->attemptnum}';
$string['numberabbr'] = 'č.';
$string['numerical'] = 'Numerická úloha';
$string['numquestionsx'] = 'Úlohy: {$a}';
$string['oneminute'] = '1 minuta';
$string['onlyteachersexport'] = 'Pouze učitelé mohou exportovat úlohy.';
$string['onlyteachersimport'] = 'Pouze učitelé s právem upravovat obsah kurzu mohou importovat úlohy.';
$string['onthispage'] = 'Na této stránce';
$string['open'] = 'Nezodpovězeno';
$string['openafterclose'] = 'Test nelze aktualizovat. Datum zahájení jste zadali po datu uzavření.';
$string['openclosedatesupdated'] = 'Data zpřístupnění a uzavření kurzu';
$string['optional'] = 'volitelný';
$string['orderandpaging'] = 'Pořadí a stránkování';
$string['orderandpaging_help'] = 'Čísla 10, 20, 30, ... u každé úlohy označují pořadí úloh. Hodnota přírůstku v krocích po 10 ponechává prostor pro další úlohy, které zde mohou být vloženy. Chcete-li změnit pořadí úloh, změňte čísla a pak klikněte na tlačítko "Změnit pořadí úloh".

Chcete-li přidat konce stránek po konkrétní úloze, zaškrtněte políčko vedle úlohy, pak klikněte na tlačítko "Po vybraných úlohách přidat novou stránku".

Chcete-li uspořádat úlohy vzhledem k počtu stránek,  vyberte požadovaný počet úloh na jedné stránce a klepněte na tlačítko "Opakovat stránkování ..."';
$string['orderingquiz'] = 'Pořadí a stránkování';
$string['orderingquizx'] = 'Řazení a stránkování: {$a}';
$string['outcomesadvanced'] = 'Očekávané výsledky mají pokročilé nastavení';
$string['outof'] = '{$a->grade} z možných {$a->maxgrade}';
$string['outofpercent'] = '{$a->grade} z možných {$a->maxgrade} ({$a->percent}%)';
$string['outofshort'] = '{$a->grade}/{$a->maxgrade}';
$string['overallfeedback'] = 'Celková reakce';
$string['overallfeedback_help'] = 'Celková reakce je text zobrazený poté, co je test odeslán. Text této zpětné vazby je možné přizpůsobit dosažené známce (např. pochvala při dobrém výsledku a pokárání či povzbuzení při špatném).';
$string['overdue'] = 'Zpožděný';
$string['overduehandling'] = 'Když vyprší čas';
$string['overduehandling_desc'] = 'Co by se stalo ve výchozím nastavení, pokud student neodevzdá test před vypršením lhůty.';
$string['overduehandling_help'] = 'Toto nastavení určuje, co se stane, když během testu vyprší čas.
Pokud student v současné době na testu aktivně pracuje, odpočítávací časovač mu automaticky pokusí odeslat pokus, ale pokud se odhlásil, pak toto nastavení určuje, co se stane.';
$string['overduehandling_link'] = 'mod/quiz/timing';
$string['overduehandlingautoabandon'] = 'Pokusy musí být odeslány před vypršením lhůty, nebo se nepočítají';
$string['overduehandlingautosubmit'] = 'Otevřené pokusy jsou automaticky odeslány';
$string['overduehandlinggraceperiod'] = 'Existuje  lhůta, kdy mohou být odeslány otevřené pokusy, ale nelze odpovědět na další úlohy';
$string['overduemustbesubmittedby'] = 'Tento pokus překročil požadovaný časový limit. Měl již být odeslán. Pokud chcete, aby byl tento test oznámkován, musíte musíte jej odeslat do {$a}. Pokud pokus do té doby neodešlete, známka nebude započítána.';
$string['override'] = 'Přenastavení';
$string['overridecannotchange'] = 'Po vytvoření přepsání nelze uživatele nebo skupinu změnit.';
$string['overridecannotsetbothgroupanduser'] = 'Skupinu a uživatele nelze nastavit současně.';
$string['overridedeletegroupsure'] = 'Skutečně chcete odstranit přenastavení skupiny {$a}?';
$string['overridedeleteusersure'] = 'Skutečně chcete odstranit přenastavení uživatele {$a}?';
$string['overridegroup'] = 'Přenastavit skupinu';
$string['overridegroupeventname'] = '{$a->quiz} - {$a->group}';
$string['overrideinvalidattempts'] = 'Hodnota pokusů musí být větší než nula.';
$string['overrideinvalidexistingid'] = 'Stávající přepsání neexistuje.';
$string['overrideinvalidgroup'] = 'Daná skupina neexistuje.';
$string['overrideinvalidquiz'] = 'Sada ID testu neexistuje.';
$string['overrideinvalidtimelimit'] = 'Časový limit musí být větší než nula.';
$string['overrideinvaliduser'] = 'Zadaný uživatel neexistuje.';
$string['overridemissingdelete'] = 'Přepsaná id(a) {$a} nebylo možné smazat, protože neexistují nebo nejsou součástí daného testu.';
$string['overridemultiplerecordsexist'] = 'Pro stejného uživatele/skupinu nelze provést více přepsání.';
$string['overridemustsetuserorgroup'] = 'Musí být nastaven uživatel nebo skupina.';
$string['overrides'] = 'Přenastavení';
$string['overridesforquiz'] = 'Přepsat přenastavení: {$a}';
$string['overridesnoneforgroups'] = 'Pro tento test nebyly vytvořeny žádná přenastavení skupiny.';
$string['overridesnoneforusers'] = 'Pro tento test nebyly vytvořeny žádná uživatelská přenastavení.';
$string['overridessummary'] = 'Existují přenastavení ({$a})';
$string['overridessummarygroup'] = 'Skupiny: {$a}';
$string['overridessummarythisgroup'] = 'Pro tuto skupinu existují přenastavení ({$a})';
$string['overridessummaryuser'] = 'Uživatelé: {$a}';
$string['overridessummaryyourgroups'] = 'Pro vaše skupiny existují přenastavení ({$a})';
$string['overrideuser'] = 'Přenastavit uživatele';
$string['overrideusereventname'] = '{$a->quiz} - přenastavení';
$string['page-mod-quiz-attempt'] = 'Stránka pokusu testu';
$string['page-mod-quiz-edit'] = 'Stránka pro úpravu testu';
$string['page-mod-quiz-report'] = 'Stránka sestavy testu';
$string['page-mod-quiz-review'] = 'Stránka revize pokusu';
$string['page-mod-quiz-summary'] = 'Stránka přehledu pokusu testu';
$string['page-mod-quiz-view'] = 'Informační stránka testu';
$string['page-mod-quiz-x'] = 'Jakákoliv stránka testu';
$string['pageshort'] = 'P';
$string['pagesize'] = 'Stránkovat po';
$string['parent'] = 'Úroveň vnoření';
$string['parentcategory'] = 'Nadřazená kategorie';
$string['parsingquestions'] = 'Analyzuji úlohy z importního souboru.';
$string['partiallycorrect'] = 'Částečně správná odpověď';
$string['penalty'] = 'Penalizace';
$string['penaltyscheme'] = 'Penalizace';
$string['penaltyscheme_help'] = '<p>Pokud je v testu povolen adaptivní režim, může se student po nesprávném
pokusu o řešení úlohy pokusit znovu odpovědět. V takovém případě možná budete
chtít zatížit každou nesprávnou odpověď určitou penalizací, která bude odečtena
z výsledné známky za danou úlohu. Hodnota penalizace se vybírá pro každou úlohu
samostatně při nastavování nebo úpravě této úlohy.</p>

<p>Nastavení nemá žádný vliv, pokud není v testu povolen adaptivní režim.</p>';
$string['percentcorrect'] = 'Procent správně';
$string['pleaseclose'] = 'Váš požadavek byl zpracován, nyní můžete toto okno zavřít.';
$string['pluginadministration'] = 'Správa testu';
$string['pluginname'] = 'Test';
$string['popup'] = 'Test zobrazit v „zabezpečeném“ okně';
$string['popupblockerwarning'] = 'Tato část testu je v bezpečném modu. To znamená, že musíte test absolvovat v zabezpečeném okně. Prosím vypněte blokování vyskakovacích oken. Děkujeme.';
$string['popupnotice'] = 'Studentům se tento test zobrazí v zabezpečeném okně.';
$string['precreateattempts'] = 'Předběžné pokusy';
$string['precreateattempts_desc'] = 'Pokud je tato možnost povolena, pokusy testů budou vytvořeny před otevřením testu, na základě "Období před vytvořením", které musí být také nastaveno.

Tím se zabrání skokům v zatížení serveru, když studenti začnou složité nebo velké testy najednou.

Testy bez otevírací doby nejsou ovlivněny.

Pokud je toto nastavení uzamčeno, je nuceně zapnuto nebo vypnuto pro všechny testy. Pokud je tato funkce odemčena a je nastaveno „Období předběžného vytvoření“, testy se mohou k této funkci přihlásit. Pokud není nastaveno období "Předběžné", toto nastavení se nezobrazí ve formuláři nastavení testu.';
$string['precreateattempts_help'] = 'Předběžné pokusy pomáhají optimalizovat výkon webu. Testové otázky nelze upravit, pokud má test pokusy.';
$string['precreateoff'] = 'Nevytvářejte předem pokusy';
$string['precreateperiod'] = 'Předběžné období';
$string['precreateperiod_desc'] = 'Období před otevřením testu, kdy budou pokusy předem vytvořeny.

Pokusy jsou generovány naplánovanou úlohou (mod_quiz\\task\\precreate_attempts), která ve výchozím nastavení běží každou hodinu.

Vzhledem k tomu, že testy nelze upravovat, jakmile mají pokusy, je nejlepší, aby toto období bylo co nejkratší.
Pokud máte tendenci mít jeden test nebo sadu testů, které začínají najednou, je rozumné krátké období, jako je 1 hodina.

Pokud máte několik startů v různou dobu během dne a přejete si, aby se všechna příprava prováděla, když je systém klidný jako přes noc, můžete to nastavit na delší dobu, například 12 hodin, a upravit naplánovanou úlohu tak, aby běžela během klidných hodin.

Toto nastavení je řízeno na úrovni webu, nelze jej přepsat jednotlivými testy.';
$string['precreatetask'] = 'Pokusy v předběžném období';
$string['precreateusedefault'] = 'Použít výchozí nastavení pro celý web ({$a})';
$string['precreateyes'] = 'Ano, {$a} hodin před otevírací dobou testu';
$string['preprocesserror'] = 'Došlo k chybě při předzpracování!';
$string['preview'] = 'Náhled';
$string['previewquestion'] = 'Náhled úlohy';
$string['previewquiz'] = 'Náhled  {$a}';
$string['previewquiznow'] = 'Okamžitý náhled testu';
$string['previewquizstart'] = 'Náhled testu';
$string['previous'] = 'O krok zpět';
$string['privacy:metadata:core_question'] = 'Činnost Test ukládá informace o využití úlohy v subsystému core_question.';
$string['privacy:metadata:quiz'] = 'Činnost Test využívá sestavy testu.';
$string['privacy:metadata:quiz_attempts'] = 'Podrobnosti o každém pokusu testu.';
$string['privacy:metadata:quiz_attempts:attempt'] = 'Číslo pokusu.';
$string['privacy:metadata:quiz_attempts:currentpage'] = 'Aktuální stránka, na které je uživatel.';
$string['privacy:metadata:quiz_attempts:gradednotificationsenttime'] = 'Čas, kdy byl uživatel upozorněn, že ruční hodnocení jejich pokusu bylo dokončeno';
$string['privacy:metadata:quiz_attempts:preview'] = 'Zda je to náhled testu.';
$string['privacy:metadata:quiz_attempts:state'] = 'Aktuální stav pokusu.';
$string['privacy:metadata:quiz_attempts:sumgrades'] = 'Součet známek v pokusu.';
$string['privacy:metadata:quiz_attempts:timecheckstate'] = 'Čas kontroly stavu.';
$string['privacy:metadata:quiz_attempts:timefinish'] = 'Čas dokončení pokusu.';
$string['privacy:metadata:quiz_attempts:timemodified'] = 'Čas aktualizace pokusu.';
$string['privacy:metadata:quiz_attempts:timemodifiedoffline'] = 'Čas, kdy byl pokus aktualizován prostřednictvím aktualizace offline.';
$string['privacy:metadata:quiz_attempts:timestart'] = 'Čas zahájení pokusu.';
$string['privacy:metadata:quiz_grades'] = 'Podrobnosti o celkovém hodnocení tohoto testu.';
$string['privacy:metadata:quiz_grades:grade'] = 'Celková známka tohoto testu.';
$string['privacy:metadata:quiz_grades:quiz'] = 'Test, který byl oznámkován.';
$string['privacy:metadata:quiz_grades:timemodified'] = 'Čas úpravy známky.';
$string['privacy:metadata:quiz_grades:userid'] = 'Uživatel, který byl oznámkován.';
$string['privacy:metadata:quiz_overrides'] = 'Podrobnosti o přepsání tohoto testu';
$string['privacy:metadata:quiz_overrides:quiz'] = 'Test s informacemi o přepsání';
$string['privacy:metadata:quiz_overrides:timeclose'] = 'Nový čas uzavření testu.';
$string['privacy:metadata:quiz_overrides:timelimit'] = 'Nová lhůta pro odevzdání testu.';
$string['privacy:metadata:quiz_overrides:timeopen'] = 'Nový čas zpřístupnění testu.';
$string['privacy:metadata:quiz_overrides:userid'] = 'Uživatel je přepsán';
$string['privacy:metadata:quizaccess'] = 'Činnost Test využívá testová přístupová pravidla.';
$string['publish'] = 'Zveřejnit';
$string['publishedit'] = 'Pro úpravu nebo přidávání úloh v této kategorii musíte mít příslušná práva v kurzu, který ji zveřejňuje.';
$string['qbrief'] = 'Úloha. {$a}';
$string['qname'] = 'název';
$string['qti'] = 'Formát IMS QTI';
$string['qtypename'] = 'typ, název';
$string['question'] = 'Úloha';
$string['questionbank'] = 'existující úlohu z banky úloh';
$string['questionbankmanagement'] = 'Správa banky úloh';
$string['questionbehaviour'] = 'Chování úloh';
$string['questioncats'] = 'Kategorie úloh';
$string['questiondeleted'] = 'Tato úloha byla odstraněna. Prosím, kontaktujte svého vyučujícího.';
$string['questiondependencyadd'] = 'Pro pokus této úlohy {$a->thisq}  bez omezení • Klikněte, chcete-li změnu';
$string['questiondependencyfree'] = 'Pro tuto úlohu bez omezení';
$string['questiondependencyremove'] = 'Úloha {$a->thisq} může být spuštěna teprve po dokončení předchozí úlohy {$a->previousq}  • Klikněte, chcete-li změnu';
$string['questiondependsonprevious'] = 'Úloha může být spuštěna teprve po dokončení předchozí úlohy.';
$string['questiondraftonly'] = 'Úloha {$a}  je ve stavu Návrh. Chcete-li jej použít v testu, přejděte do banky úloh a změňte stav na Hotovo.';
$string['questiondraftwillnotwork'] = 'Tato úloha je ve stavu Návrh. Chcete-li jej použít v testu, přejděte do banky úloh a změňte stav na Hotovo.';
$string['questioninuse'] = 'Úloha \'{$a->questionname}\' je právě používána v: <br />{$a->quiznames}<br />Úloha nebude odstraněna z těchto testů, ale pouze ze seznamu kategorií.';
$string['questionmissing'] = 'Úloha pro toto sezení chybí';
$string['questionname'] = 'Název úlohy';
$string['questionnonav'] = '<span class="accesshide">Úloha </span>{$a->number}<span class="accesshide"> {$a->attributes}</span>';
$string['questionnonavinfo'] = '<span class="accesshide">Informace </span>{$a->number}<span class="accesshide"> {$a->attributes}</span>';
$string['questionnotloaded'] = 'Úloha {$a} nebyla nahrána z databáze';
$string['questionorder'] = 'Pořadí úloh';
$string['questionposition'] = 'Nová pozice v pořadí pro úlohu {$a}';
$string['questions'] = 'Úlohy';
$string['questionsetpreview'] = 'Nastavení náhledu úlohy';
$string['questionsinclhidden'] = 'Úlohy (včetně skrytých)';
$string['questionsinthisquiz'] = 'Úlohy v tomto testu';
$string['questionsmatchingfilter'] = 'Úlohy odpovídající tomuto filtru: {$a}';
$string['questionsperpage'] = 'Počet úloh na stránce';
$string['questionsperpageselected'] = 'Počet úloh na stránku byl nastaven tak, že stránkování je aktuálně neměnné. V důsledku toho byly zakázány ovládací prvky stránkování. Toto nastavení můžete změnit v {$a}.';
$string['questionsperpagex'] = 'Počet úloh na stránce: {$a}';
$string['questiontext'] = 'Text úlohy';
$string['questiontextisempty'] = '[Prázdný text úlohy]';
$string['questiontype'] = 'Typ úlohy: {$a}';
$string['questiontypesetupoptions'] = 'Nastavení pro jednotlivé typy úloh:';
$string['questionversion'] = 'v{$a}';
$string['questionversionlatest'] = 'v{$a} (nejnovější)';
$string['quiz:addinstance'] = 'Přidat nový test';
$string['quiz:attempt'] = 'Pokusit se absolvování testů';
$string['quiz:deleteattempts'] = 'Smazat pokusy v testech';
$string['quiz:emailconfirmsubmission'] = 'Získávat emailové potvrzení o zdárném odevzdání testu';
$string['quiz:emailnotifyattemptgraded'] = 'Obdržet upozornění, když byl váš pokus ohodnocen';
$string['quiz:emailnotifysubmission'] = 'Získávat emailové upozornění na odevzdané úlohy studenty';
$string['quiz:emailwarnoverdue'] = 'Dostávat upozornění na blížící se lhůtu pro pokus testu';
$string['quiz:grade'] = 'Známkovat testy ručně';
$string['quiz:ignoretimelimits'] = 'Ignorovat časové limity v testech';
$string['quiz:manage'] = 'Spravovat testy';
$string['quiz:manageoverrides'] = 'Spravovat přenastavení testu';
$string['quiz:preview'] = 'Nahlížet testy';
$string['quiz:regrade'] = 'Znovu oznámkovat pokusy testu';
$string['quiz:reopenattempts'] = 'Znovu otevřít nikdy neodeslané pokusy testu';
$string['quiz:reviewmyattempts'] = 'Znovu si prohlížet vlastní pokusy';
$string['quiz:view'] = 'Zobrazit informace o testech';
$string['quiz:viewoverrides'] = 'Zobrazit přenastavení testu';
$string['quiz:viewreports'] = 'Zobrazit  zprávy o testech';
$string['quizavailable'] = 'Test je přístupný až do: {$a}';
$string['quizclose'] = 'Uzavřít test';
$string['quizclosed'] = 'Test byl uzavřen {$a}';
$string['quizcloses'] = 'Datum a čas uzavření testu';
$string['quizcloseson'] = 'Tento test se zavírá {$a}.';
$string['quizeventcloses'] = '{$a} - uzavřeno';
$string['quizeventopens'] = '{$a} - otevřeno';
$string['quizinvalidquestions'] = 'Tento test obsahuje úlohy s neplatnými typy. Před použitím testu je nutné chybějící typ úlohy znovu nainstalovat nebo odstranit dotčené úlohy.';
$string['quizisclosed'] = 'Tento test je uzavřen';
$string['quizisclosedwillopen'] = 'Test uzavřen (otevřen {$a})';
$string['quizisopen'] = 'Tento test je otevřený';
$string['quizisopenwillclose'] = 'Test se otvírá (zavírá {$a})';
$string['quiznavigation'] = 'Navigace testu';
$string['quizopen'] = 'Zpřístupnit test';
$string['quizopenclose'] = 'Datum zpřístupnění a uzavření';
$string['quizopenclose_help'] = 'Studenti mohou začít svůj pokus nejdříve po zpřístupnění testu a musí test odevzdat před časem uzavření testu.';
$string['quizopenclose_link'] = 'mod/quiz/timing';
$string['quizopendatesoonhtml'] = '<p>Zdravíme {$a->firstname},</p>
<p>Brzy se otevírá test <strong>{$a->quizname}</strong> v kurzu {$a->coursename}.
<p><strong>Otevírá: {$a->timeopen}</strong></p>
<p><strong>Zavírá: {$a->timeclose}</strong></p>
<p><a href="{$a->url}">Přejít na test</a></p>';
$string['quizopendatesoonsubject'] = 'Otevře se {$a->timeopen}: {$a->quizname}';
$string['quizopened'] = 'Tento test je otevřený.';
$string['quizopenedon'] = 'Tento test byl zahájen v {$a}';
$string['quizopens'] = 'Test zpřístupněn';
$string['quizopenwillclose'] = 'Tento test je otevřený, bude uzavřen dne {$a} v';
$string['quizordernotrandom'] = 'Pořadí úloh v testu není zamícháno';
$string['quizorderrandom'] = '* Pořadí úloh  v testu je zamícháno';
$string['quizreport'] = 'Sestava testu';
$string['quizsettings'] = 'Nastavení testů';
$string['quizsetupnavigation'] = 'Nastavení navigace testu';
$string['quiztimer'] = 'Časomíra testu';
$string['quizwillopen'] = 'Tento test bude zahájen v {$a}';
$string['random'] = 'Náhodně vybraná úloha';
$string['randomcatwithsubcat'] = '{$a} a podkategorie';
$string['randomcoursecatwithsubcat'] = 'Jakákoli kategorie v kategorii kurzu {$a}';
$string['randomcoursewithsubcat'] = 'Jakákoli kategorie v tomto kurzu';
$string['randomcreate'] = 'Vytvořit náhodně vybrané úlohy';
$string['randomediting'] = 'Úprava náhodných úloh';
$string['randomfaultynosubcat'] = 'Chybná otázka';
$string['randomfromcategory'] = 'Náhodná úloha z kategorie:';
$string['randomfromexistingcategory'] = 'Náhodná úloha z existující kategorie';
$string['randomfromunavailabletag'] = '{$a} (není k dispozici)';
$string['randommodulewithsubcat'] = 'Jakákoli kategorie tohoto testu';
$string['randomnosubcat'] = 'Náhodná úloha pouze z této kategorie, ne z dalších podkategorií';
$string['randomnumber'] = 'Počet náhodných úloh';
$string['randomqname'] = 'Náhodná otázka na základě stavu filtru';
$string['randomqnamecat'] = 'Náhodné ({$a->category}) na základě podmínky filtru';
$string['randomqnamecattags'] = 'Náhodné ({$a->category}) na základě podmínky filtru se štítky: {$a->tags}';
$string['randomqnametags'] = 'Náhodná otázka na základě podmínky filtru se štítky: {$a}';
$string['randomquestion'] = 'Náhodná úloha';
$string['randomquestion_help'] = 'Náhodná úloha  je způsob vložení náhodně zvolené úlohy z určité kategorie nebo zadaného štítku do aktivity.';
$string['randomquestiontags'] = 'Štítky';
$string['randomquestiontags_help'] = 'Zde můžete omezit další kritéria výběru zadáním některých štítků úloh.

"Náhodné" úlohy budou vybrány z úloh, které obsahují všechny tyto štítky.';
$string['randomquestionusinganewcategory'] = 'Náhodná úloha z nové kategorie';
$string['randomsystemwithsubcat'] = 'Jakákoli kategorie na úrovni systému';
$string['randomwithsubcat'] = 'Úlohy z této kategorie a jejích podkategorií';
$string['readytosend'] = 'Rozhodli jste se dokončit tento pokus. Chcete jej opravdu dokončit?';
$string['reattemptquiz'] = 'Začít další pokus';
$string['recentlyaddedquestion'] = 'Úloha byla nově přidána!';
$string['recurse'] = 'Zobrazit také úlohy z podkategorií';
$string['redoesofthisquestion'] = 'Další pokusy jsou: {$a}';
$string['redoquestion'] = 'Zkuste jinou úlohu, jako je tato';
$string['regrade'] = 'Znovu oznámkovat všechny pokusy';
$string['regradecomplete'] = 'Všechny pokusy byly znovu oznámkovány';
$string['regradecount'] = '{$a->changed} z {$a->attempt} známek bylo změněno';
$string['regradedisplayexplanation'] = 'Pokusy, které byly v průběhu přeznámkování změněny, jsou zobrazeny jako odkazy na revizi příslušné úlohy.';
$string['regradenotallowed'] = 'Nemáte oprávnění znovu oznámkovat výsledky tohoto testu';
$string['regradingquestion'] = 'Znovu známkuji otázku: "{$a}"';
$string['regradingquiz'] = 'Znovu známkuji test: "{$a}"';
$string['remove'] = 'Odstranit';
$string['removeallgroupoverrides'] = 'Všechna přenastavení skupiny';
$string['removeallquizattempts'] = 'Všechny pokusy testu';
$string['removealluseroverrides'] = 'Všechna přenastavení uživatelů';
$string['removeemptypage'] = 'Odstanit prázdnou stránku';
$string['removepagebreak'] = 'Odstranit zalomení stránky';
$string['removeselected'] = 'Odebrat vybrané';
$string['rename'] = 'Přejmenovat';
$string['renderingserverconnectfailed'] = 'Server {$a} nezpracoval požadavek RQP. Zkontrolujte prosím, že zadané URL je správné.';
$string['reopenattempt'] = 'Znovu otevřít';
$string['reopenattemptareyousuremessage'] = 'Tím se znovu otevře pokus {$a->attemptnumber} od {$a->attemptuser}.';
$string['reopenattemptareyousuretitle'] = 'Opětovné otevření pokusu?';
$string['reopenattemptwrongstate'] = 'Pokus {$a->attemptid} je ve špatném stavu ({$a->state}), aby mohl být znovu otevřen.';
$string['reopenedattemptwillbeinprogress'] = 'Pokus zůstane otevřený a lze v něm pokračovat.';
$string['reopenedattemptwillbeinprogressuntil'] = 'Pokus zůstane otevřený a lze v něm pokračovat, dokud se test neuzavře dne {$a}.';
$string['reopenedattemptwillbesubmitted'] = 'Pokus bude okamžitě odeslán k hodnocení.';
$string['reorderquestions'] = 'Změnit pořadí úloh';
$string['reordertool'] = 'Zobrazovat pomůcku pro změnu pořadí';
$string['repaginate'] = 'Znovu stránkovat, počet úloh na stránce: {$a}';
$string['repaginatecommand'] = 'Znovu nastavit stránkování';
$string['repaginatenow'] = 'Nyní znovu stránkovat';
$string['replace'] = 'Přepsat';
$string['replacementoptions'] = 'Možnosti nahrazení';
$string['report'] = 'Výsledky';
$string['reportanalysis'] = 'Položková analýza';
$string['reportattemptsfrom'] = 'Pokusy od uživatelů, kteří';
$string['reportattemptsthatare'] = 'Pokusy, které';
$string['reportdisplayoptions'] = 'Možnosti zobrazení';
$string['reportfullstat'] = 'Podrobná statistika';
$string['reportmulti_percent'] = 'Multi-procenta';
$string['reportmulti_q_x_student'] = 'Multi-studentské volby';
$string['reportmulti_resp'] = 'Odpovědi uživatelů';
$string['reportmustselectstate'] = 'Musíte vybrat nejméně jeden stav.';
$string['reportnotfound'] = 'Neznámý přehled ({$a})';
$string['reportoverview'] = 'Přehled';
$string['reportregrade'] = 'Znovu oznámkovat pokusy';
$string['reportresponses'] = 'Odpovědi podrobně';
$string['reports'] = 'Výsledky';
$string['reportshowonly'] = 'Zobrazit pouze pokusy';
$string['reportshowonlyfinished'] = 'Zobrazit maximálně jeden ukončený pokus uživatele ({$a})';
$string['reportsimplestat'] = 'Souhrnná statistika';
$string['reportusersall'] = 'všichni uživatelé, kteří mají pokus v testu';
$string['reportuserswith'] = 'uživatelé zapsaní v kurzu a mají pokus v testu';
$string['reportuserswithorwithout'] = 'uživatelé zapsaní v kurzu, kteří mají nebo nemají pokus v testu';
$string['reportuserswithout'] = 'jsou zapsaní v kurzu, ale bez pokusu v testu';
$string['reportwhattoinclude'] = 'Co zahrnout do sestavy';
$string['requirepassword'] = 'Vyžaduje heslo';
$string['requirepassword_help'] = '<p>Toto pole je volitelné.</p>

<p>Pokud v tomto poli nastavíte určité heslo, budou studenti muset zadat stejné
heslo před každým pokusem o splnění testu.</p>';
$string['requiresubnet'] = 'Vyžaduje síťovou adresu';
$string['requiresubnet_help'] = '<p>Toto pole je volitelné.</p>

<p>Přístup k testu můžete omezit na konkrétní podsítě v rámci Internetu nebo
sítě LAN. Jednotlivé úplné a neúplné IP adresy, které určíte pro přístup,
musejí být ve výčtu odděleny čárkou.</p>

<p>Tato možnost je vhodná zvláště pro chráněné testy, u kterých si chcete být
jisti, že k nim mají přístup pouze studenti v dané místnosti.</p>

<p>Příklad: <b>192.168. , 231.54.211.0/20, 231.3.56.211</b></p>

<p>Můžete použít tři typy číselných zápisů (není možné používat textová jména
domén, např. example.com):</p>

<ol>
  <li>Úplné IP adresy, jako např. <b>192.168.10.1</b>, které odpovídají jednomu
  počítači (nebo proxy serveru).</li>

  <li>Neúplné IP adresy, jako např. <b>192.168</b>, které odpovídají všem
  umístěním, jež začínají těmito čísly.</li>

  <li>Zápis CIDR, jako např. <b>231.54.211.0/20</b>, který umožňuje ještě
  podrobnější určení podsítí.</li>
</ol>
<p>

<p>Mezery jsou ignorovány.</p>';
$string['response'] = 'Odpověď';
$string['responses'] = 'Odpovědi';
$string['results'] = 'Výsledky';
$string['returnattempt'] = 'Návrat k pokusu';
$string['reuseifpossible'] = 'znovu použít dříve odstraněnou';
$string['reverttodefaults'] = 'Vrátit se k výchozím nastavením testu';
$string['review'] = 'Revize';
$string['reviewafter'] = 'Po uzavření testu';
$string['reviewalways'] = 'Kdykoliv';
$string['reviewattempt'] = 'Prohlédnout pokus';
$string['reviewbefore'] = 'Dokud je test zpřístupněn';
$string['reviewclosed'] = 'Po uzavření testu';
$string['reviewduring'] = 'V průběhu pokusu';
$string['reviewimmediately'] = 'Ihned po pokusu o zvládnutí testu';
$string['reviewnever'] = 'Nikdy';
$string['reviewofquestion'] = 'Kontrola úlohy {$a->question} v {$a->quiz} uživatelem {$a->user}';
$string['reviewopen'] = 'Později, dokud je test zpřístupněn';
$string['reviewoptions'] = 'Studentům se mají zobrazit';
$string['reviewoptionsheading'] = 'Možnosti prohlídky';
$string['reviewoptionsheading_help'] = 'Tato nastavení určují, jaké informace jsou poskytovány studentům při prohlížení svých odeslaných pokusů a známek.

Nastavení **V průběhu pokusu** se týká pouze některých testových režimů, např. "Interaktivní s vícero pokusy", kde se zobrazuje zpětná vazba v průběhu pokusu.

Nastavení **Ihned po pokusu o zvládnutí testu** určuje chování v prvních dvou minutách po odeslání pokusu.

Nastavení **Později, dokud je test zpřístupněn** upravuje informaci zobrazovanou v období do uzavření testu.

Nastavení **Po uzavření testu** určuje, jaká informace se zobrazí studentům po uzavření testu. Pokud není datum uzavření určeno, toto nastavení se nevyužije.';
$string['reviewoverallfeedback'] = 'Celková reakce';
$string['reviewoverallfeedback_help'] = 'Celková reakce je uvedena na konci pokusu v závislosti na celkové známce studenta';
$string['reviewresponse'] = 'Prohlédnout odpověď';
$string['reviewresponsetoq'] = 'Prohlédnout odpověď (úloha {$a})';
$string['reviewthisattempt'] = 'Prohlídka odpovědí tohoto pokusu';
$string['rqp'] = 'Vzdáleně zpracovávaná úloha';
$string['rqps'] = 'Vzdáleně zpracovávané úlohy';
$string['sameasoverall'] = 'Stejně jako v celkovém hodnocení';
$string['save'] = 'Uložit';
$string['saveandedit'] = 'Uložit změny a upravit úlohy';
$string['saveattemptfailed'] = 'Nepodařilo se uložit aktuální pokus o řešení testu.';
$string['savedfromdeletedcourse'] = 'Uloženo z odstraněného kurzu "{$a}"';
$string['savegrades'] = 'Uložit známky';
$string['savemanualgradingfailed'] = 'Úprava nebyla uložena. Zkontrolujte prosím níže uvedenou zprávu a zkuste to znovu.';
$string['savemyanswers'] = 'Uložit mé odpovědi';
$string['savenosubmit'] = 'Uložit bez odeslání';
$string['saveoverrideandstay'] = 'Uložit a zadat další přenastavení';
$string['savequiz'] = 'Uložit celý test';
$string['saving'] = 'Ukládání';
$string['savingnewgradeforquestion'] = 'Ukládání nového hodnocení úlohy id {$a}.';
$string['savingnewmaximumgrade'] = 'Ukládání nového maxima hodnocení.';
$string['score'] = 'Hrubý skór';
$string['scores'] = 'Body';
$string['search:activity'] = 'Test - informace';
$string['searchbyname'] = 'Hledat podle jména...';
$string['sectionheadingedit'] = 'Upravit záhlaví "{$a}"';
$string['sectionheadingremove'] = 'Odstranit záhlaví "{$a}"';
$string['sectionnoname'] = 'Sekce bez názvu';
$string['seequestions'] = '(Viz úlohy)';
$string['select'] = 'Vybrat';
$string['selectall'] = 'Vybrat vše';
$string['selectattempt'] = 'Vybrat pokus';
$string['selectcategory'] = 'Vyberte kategorii';
$string['selectedattempts'] = 'Vybrané pokusy...';
$string['selectmultipleitems'] = 'Vybrat více položek';
$string['selectmultipletoolbar'] = 'Vyberte násobný panel nástrojů';
$string['selectnone'] = 'Zrušit výběr';
$string['selectquestionbank'] = 'Vyberte banku úloh';
$string['selectquestionslot'] = 'Vybrat úlohu {$a}';
$string['selectquestiontype'] = '-- Vyberte typ úlohy --';
$string['sendnotificationopendatesoon'] = 'Upozornit uživatele na blížící se datum otevření testu';
$string['serveradded'] = 'Server přidán';
$string['serveridentifier'] = 'Identifikátor';
$string['serverinfo'] = 'Informace serveru';
$string['servers'] = 'Servery';
$string['serverurl'] = 'URL adresa serveru';
$string['shortanswer'] = 'Krátká tvořená odpověď';
$string['show'] = 'Ukázat';
$string['showall'] = 'Zobrazit všechny úlohy na jedné stránce';
$string['showblocks'] = 'Zobrazit bloky během pokusů testu ';
$string['showblocks_help'] = 'Pokud je vybrána možnost "Ano", budou studentům v průběhu pokusu zobrazeny postranní bloky. Toto nastavení nemá vliv na blok Navigace testem, týká se dalších bloků, které učitel přidá do testu.';
$string['showbreaks'] = 'Zobrazovat předěly mezi stránkami testu';
$string['showcategorycontents'] = 'Zobraz obsah kategorie {$a->arrow}';
$string['showcorrectanswer'] = 'Zobrazovat správnou odpověď v hodnocení';
$string['showdetailedmarks'] = 'Zobrazovat podrobné hodnocení';
$string['showeachpage'] = 'Zobrazovat po stránkách';
$string['showfeedback'] = 'Zobrazovat hodnocení po odpovědi';
$string['showinsecurepopup'] = 'Pro pokusy použijte bezpečné vyskakovací okno';
$string['showlargeimage'] = 'Velký obrázek';
$string['shownoattempts'] = 'Zobrazovat studenty, kteří se o test nepokusili';
$string['shownoattemptsonly'] = 'Zobrazovat pouze studenty, kteří se o test nepokusili';
$string['shownoimage'] = 'Bez obrázku';
$string['showreport'] = 'Zobrazit sestavu';
$string['showsmallimage'] = 'Malý obrázek';
$string['showteacherattempts'] = 'Zobrazovat pokusy učitelů';
$string['showuserpicture'] = 'Zobraz obrázek uživatele';
$string['showuserpicture_help'] = 'Pokud je povoleno,  bude v průběhu testu na obrazovce zobrazeno jméno a profilové foto studenta během pokusu, což usnadňuje kontrolu, zda je student přihlášen osobně na dozorované (sledované) zkoušce.';
$string['shuffle'] = 'Zamíchat';
$string['shuffleanswers'] = 'Zamíchat odpovědi';
$string['shuffledrandomly'] = 'Náhodně zamíchané';
$string['shufflequestions'] = 'Zamíchat úlohy';
$string['shufflequestions_help'] = 'Pokud je povoleno, pak se v této sekci pokaždé při pokusu o zvládnutí testu náhodně zamíchají pořadí otázek.

To může být těžší pro studenty při sdílení odpovědí, také to ale může být těžší pro studenty, kteří chtějí diskutovat o konkrétní otázce s učitelem.';
$string['shufflewithin'] = 'Zamíchat v rámci úloh';
$string['shufflewithin_help'] = '<p>Pokud je tato možnost povolena, budou při každém pokusu o splnění testu
náhodně zamíchány jednotlivé části úloh, jestliže to umožňuje nastavení
konkrétní úlohy.</p>

<p>Zamíchání v rámci úloh má studentům poněkud ztížit opisování.</p>

<p>Nastavení se vztahuje pouze na úlohy, u kterých je možnost výběru, tedy
úlohy s výběrem odpovědí a přiřazovací úlohy. Pro úlohy s výběrem odpovědí
platí, že pořadí odpovědí bude zamícháno, pouze je-li tato možnost nastavena na
"Ano".U přiřazovacích úloh jsou odpovědi zamíchány vždy a toto nastavení tak
navíc určuje, zda má být zamícháno i pořadí párů otázka-odpověď.</p>

<p>Toto nastavení nesouvisí s použitím Náhodně vybraných úloh.</p>';
$string['singleanswer'] = 'Vyberte jednu odpověď';
$string['sortage'] = 'Seřadit podle stáří';
$string['sortalpha'] = 'Seřadit abecedně podle názvu';
$string['sortquestionsbyx'] = 'Seřadit úlohy podle: {$a}';
$string['sortsubmit'] = 'Seřadit úlohy';
$string['sorttypealpha'] = 'Seřadit abecedně podle typu';
$string['specificapathnotonquestion'] = 'Zadaná cesta k souboru není v zadané úloze';
$string['specificquestionnotonquiz'] = 'Stanovená úloha není zadaném testu';
$string['startagain'] = 'Začít znovu';
$string['startattempt'] = 'Zahájení pokusu';
$string['startedon'] = 'Zahájení';
$string['startnewpreview'] = 'Začít nový náhled';
$string['stateabandoned'] = 'Neodesláno';
$string['statefinished'] = 'Dokončeno';
$string['statefinisheddetails'] = 'Odesláno {$a}';
$string['stateinprogress'] = 'Probíhá';
$string['statenotloaded'] = 'Stav úlohy {$a} nebyl načten z databáze';
$string['statenotstarted'] = 'Nezahájeno';
$string['stateoptions'] = 'Možnosti stavu pokusu';
$string['stateoptions_help'] = '* Nezahájeno: Pokus byl automaticky vytvořen před otevřením testu. Student zatím pokus nezahájil.
* Probíhá: Student zahájil pokus. Ještě má čas odeslat.
* Po termínu: Pokus byl otevřen déle, než je povolený časový limit. Student jej stále může odeslat v rámci období hodnocení.
* Odesláno: Student dokončil pokus a odeslal své odpovědi. Je ve frontě na automatické známkování.
* Dokončeno: Pokus byl odeslán a jakékoli automatické známkování je dokončeno.
* Nikdy neodesláno: Student zahájil pokus, ale neodevzdal jej v časovém limitu nebo dodatečné lhůtě.';
$string['stateoverdue'] = 'Překročen časový limit';
$string['stateoverduedetails'] = 'Musí být odesláno {$a}';
$string['statesubmitted'] = 'Odesláno';
$string['status'] = 'Stav';
$string['stoponerror'] = 'Zastavit při chybě';
$string['submission_confirmation'] = 'Odeslat všechny odpovědi a skončit?';
$string['submission_confirmation_unanswered'] = 'Úlohy bez odpovědi: {$a}';
$string['submitallandfinish'] = 'Odeslat vše a ukončit pokus';
$string['subneterror'] = 'Litujeme, ale tento test byl nastaven tak, aby k němu bylo možné přistupovat jen z některých počítačů. Váš počítač nepatří k těm, pro které je přístup povolen.';
$string['subnetnotice'] = 'Tento test je nastaven tak, aby k němu bylo možné přistupovat jen z některých počítačů. Váš počítač nepatří k těm, pro které je přístup povolen. Jako vyučující však máte možnost prohlédnout si test i přesto.';
$string['subplugintype_quiz'] = 'Sestava';
$string['subplugintype_quiz_plural'] = 'Sestavy';
$string['subplugintype_quizaccess'] = 'Přístupové pravidlo';
$string['subplugintype_quizaccess_plural'] = 'Přístupová pravidla';
$string['substitutedby'] = 'bude nahrazena';
$string['summaryofattempt'] = 'Souhrn pokusu';
$string['summaryofattempts'] = 'Vaše pokusy';
$string['summaryofattemptscaption'] = 'Souhrn pokusu {$a}';
$string['temporaryblocked'] = 'Dočasně vám není dovoleno pokusit o další zvládnutí testu.<br />Další pokus budete moci absolvovat:';
$string['theattempt'] = 'Pokus';
$string['theattempt_help'] = 'Zda si student může pokus vůbec prohlédnout.';
$string['time'] = 'Čas';
$string['timecompleted'] = 'Hotovo';
$string['timedelay'] = 'Není vám dovoleno absolvovat tento test, protože vám dosud neuplynula nastavená prodleva mezi dvěma testy.';
$string['timeleft'] = 'Zbývající čas';
$string['timelimit'] = 'Časový limit';
$string['timelimit_help'] = 'Je-li povoleno, časový limit je uveden na úvodní stránce testu. V průběhu testu je zbývající čas odpočítáván v navigačním bloku.';
$string['timelimit_link'] = 'mod/quiz/timing';
$string['timelimitexeeded'] = 'Překročen časový limit testu!';
$string['timestr'] = '%H:%M:%S on %d/%m/%y';
$string['timesup'] = 'Čas!';
$string['timing'] = 'Časování';
$string['tofile'] = 'do souboru';
$string['tolerance'] = 'Tolerance';
$string['toomanyrandom'] = 'Počet požadovaných náhodných úloh je větší, než kolik jich tato kategorie obsahuje! (Některé typy úloh nemusejí být podporovány a do počtu úloh v kategorii se pak nezapočítávají)';
$string['top'] = 'Nejvyšší úroveň';
$string['totalmarks'] = 'Celkový počet známek';
$string['totalmarksx'] = 'Celkem bodů: {$a}';
$string['totalquestionsinrandomqcategory'] = 'Celkem {$a} úloh v kategorii';
$string['true'] = 'Pravda';
$string['truefalse'] = 'Pravda/Nepravda';
$string['type'] = 'Typ';
$string['unfinished'] = 'nedokončeno';
$string['ungraded'] = 'Neznámkováno';
$string['unit'] = 'Jednotka';
$string['unknowntype'] = 'Na řádku {$a} se nachází nepodporovaný typ úlohy. Úloha bude ignorována.';
$string['updatefilterconditon'] = 'Aktualizovat podmínky filtru';
$string['updatefilterconditon_success'] = 'Podmínky filtru byly úspěšně aktualizovány';
$string['updateoverdueattemptstask'] = 'Aktualizace překročení časového limitu pokusu testu';
$string['updatequizslotswithrandomxofy'] = 'Aktualizace testových slotů s "náhodnými" úlohami ({$a->done}/{$a->total})';
$string['updatesettings'] = 'Aktualizovat nastavení testu';
$string['updatingatttemptgrades'] = 'Aktualizace hodnocení pokusu.';
$string['updatingfinalgrades'] = 'Aktualizace konečného hodnocení.';
$string['updatingthegradebook'] = 'Aktualizace hodnocení.';
$string['upgradesure'] = '<div>Obzvláště modul Test provede rozsáhlé změny v databázi, a tento upgrade ještě nebyl dostatečně otestován. Velmi důrazně vás vybízíme, abyste nejdříve provedli zálohu své databáze.</div>';
$string['upgradingquizattempts'] = 'Aktualizace pokusů: test {$a->done}/{$a->outof} (Quiz id {$a->info})';
$string['upgradingveryoldquizattempts'] = 'Aktualizace starých pokusů: {$a->done}/{$a->outof}';
$string['url'] = 'URL';
$string['usedcategorymoved'] = 'Tato kategorie byla přesunuta na úroveň stránek, neboť i po odstranění kurzu byly jeho úlohy používány v dalších testech na serveru.';
$string['useroverrides'] = 'Uživatelské přenastavení';
$string['useroverridesdeleted'] = 'Přenastavení uživatele odstraněno';
$string['usersnone'] = 'K tomuto testu nemají přístup žádní studenti';
$string['validate'] = 'Potvrdit';
$string['viewallanswers'] = 'Zobrazit {$a} hotových testů';
$string['viewallreports'] = 'Zobrazit výsledky {$a} pokusů';
$string['viewed'] = 'Zobrazeno';
$string['warningmissingtype'] = '<p><b>Tento typ úloh není na vašem serveru nainstalován.<br />Prosím, upozorněte správce Moodlu.</b></p>';
$string['wheregrade'] = 'Kde je moje známka?';
$string['wildcard'] = 'Maska';
$string['windowclosing'] = 'Toto okno se brzo zavře.';
$string['withsummary'] = 'se Souhrnnou statistikou';
$string['wronguse'] = 'Nepovolené použití stránky';
$string['xhtml'] = 'Formát XHTML';
$string['youneedtoenrol'] = 'Před otevřením testu se nejprve musíte zapsat do tohoto kurzu.';
$string['yourfinalgradeis'] = 'Vaše konečná známka za tento test je {$a}';
