<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'admin', language 'ar', version '5.0'.
 *
 * @package     admin
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessdenied'] = 'الدخول مرفوض';
$string['accountlocked'] = 'حسابك قد تم إقفاله. رابط إلغاء الإقفال أُرسل عبر البريد الالكتروني.';
$string['accounts'] = 'الحسابات';
$string['accountunlocked'] = 'حسابك قد تم إلغاء إقفاله. بإمكانك تسجيل دخولك.';
$string['addcategory'] = 'إضافة تصنيف';
$string['additionalhtml'] = 'نصوص HTML إضافية';
$string['additionalhtml_desc'] = 'يسمح لك هذا الخيار بتحديد نصوص HTML لإضافتها لكل الصفحات. يمكنك ضبط HTML التي ستتم إضافتها إلى وسم HEAD  الصفحة، أو بعد فتح وسم BODY مباشرة، أو قبل إغلاقه مباشرة.<br /> يسمح لك هذا بإضافة ترويسات وتذييلات إلى كل الصفحات، أو إضافة دعم للخدمات كخدمة Google Analytics بسهولة كبيرة وبشكل مستقل عن القالب المختار للموقع.';
$string['additionalhtml_heading'] = 'نصوص HTML الإضافية التي تضاف إلى كل الصفحات.';
$string['additionalhtmlfooter'] = 'قبل إغلاق وسم المتن BODY';
$string['additionalhtmlfooter_desc'] = 'المحتوى هنا سيضاف في كل صفحة مباشرة قبل إغلاق وسم المتن.';
$string['additionalhtmlhead'] = 'ضمن وسم الترويسة';
$string['additionalhtmlhead_desc'] = 'المحتوى هنا سيضاف إلى أسفل وسم الترويسة لكل صفحة.';
$string['additionalhtmltopofbody'] = 'عندما يتم فتح وسم BODY';
$string['additionalhtmltopofbody_desc'] = 'المحتوى هنا سيضاف إلى كل صفحة مباشرة بعد افتتاح وسم BODY.';
$string['admincategory'] = 'الفئة: {$a}';
$string['adminseesall'] = 'كل شيء سيكون ظاهر للمشرفين';
$string['adminseesallevents'] = 'كل الأحداث ستكون ظاهرة للمشرفين';
$string['adminseesownevents'] = 'المشرفون هم تمامًا مثل المستخدمين الآخرين';
$string['advancedfeatures'] = 'المزايا المتقدمة';
$string['agedigitalconsentverification'] = 'التحقق من عمر القبول الرقمي';
$string['agedigitalconsentverification_desc'] = 'تُمكِّن التحقق من عمر القبول الرقمي قبل عرض صفحة التسجيل لمستخدمي التسجيل الذاتي. يحمي هذا موقعك من القُصَّر عند الاشتراك بدون موافقة ولي الأمر / الوصي. سيتم تقديم تفاصيل <a target="_blank" href="{$a}">الدعم الفني</a> للحصول على مزيد من المساعدة.';
$string['ageofdigitalconsentmap'] = 'عمر القبول الرقمي';
$string['ageofdigitalconsentmap_desc'] = 'العمر الرقمي المفترض للموافقة، والعمر في أي بلد يختلف فيه عن العمر المفترض يمكن تحديده هنا. أدخل كل عمر على سطر جديد بالتنسيق التالي: رمز البلد والعمر المفترض (مفصولة بفاصلة). يتم تحديد العمر المفترض بواسطة * بدلاً من رمز البلد. رموز البلد هي كما هو محدد في ISO 3166-2.';
$string['allcountrycodes'] = 'جميع رموز البلدان';
$string['allowattachments'] = 'السماح بالمرفقات';
$string['allowbeforeblock'] = 'قائمة المسموحات ستتم معالجتها أولاً';
$string['allowbeforeblockdesc'] = 'إفتراضياً، تتم مطابقة المدخلات في قائمة عناوين IP المحظورة أولاً. أما إذا قمت بتفعيل هذا الخيار، فستتم معالجة المدخلات في قائمة عناوين IP المسموحة قبل معالجة القائمة المحظورة.';
$string['allowcategorythemes'] = 'السماح بقوالب التصنيفات';
$string['allowcohortthemes'] = 'السماح بقوالب الدفعات';
$string['allowcoursethemes'] = 'السماح بقوالب المقررات الدراسية';
$string['allowedemaildomains'] = 'نطاقات البريد الإلكتروني المسموح  بها';
$string['allowediplist'] = 'قائمة عناوين IP المسموح بها';
$string['allowemailaddresses'] = 'مجالات البريد الإلكتروني المسموح بها';
$string['allowemojipicker'] = 'منتقي الرموز التعبيرية';
$string['allowframembedding'] = 'اسمح بتضمين الإطارات';
$string['allowframembedding_help'] = 'إذا تم تمكينه، فسيكون بالإمكان تضمين هذا الموقع في إطار في نظام آخر، كما هو موصى به عند استعمال لاحقة التسجيل "النشر كأداة LTI". وإلا، فمن المستحسن ترك التضمين المؤطر معطلاً لأسباب أمنية. يرجى ملاحظة أنه بالنسبة لتطبيق الجوال، يتم تجاهل هذا الإعداد ويسمح دائماً بالتضمين المؤطر.';
$string['allowguestmymoodle'] = 'السماح للزوار بالوصول إلى لوحة التحكم';
$string['allowindexing'] = 'السماح لمحركات البحث بالفهرسة';
$string['allowindexing_desc'] = 'هذا يحدد ما إذا كنت تسمح لمحركات البحث بفهرسة موقعك أم لا. "بكل مكان" تسمح لمحركات البحث بفهرسة موقعك بالكامل حتى صفحات تسجيل الدخول، مما يعني أن المواقع التي تم فيها فرض تسجيل الدخول ستتم فهرستها أيضاً. لتفادي مخاطر التعرض للإزعاج، استعمل خيار "بكل مكان عدا صفحات التسجيل وتسجيل الدخول". "لا مكان"  تخبر محركات البحث بعدم فهرسة أي صفحة. أما احترام هذا الوسم، فمتروك على عاتق محرك البحث نفسه.';
$string['allowindexingeverywhere'] = 'في كل مكان';
$string['allowindexingexceptlogin'] = 'في كل مكان باستثناء صفحات تسجيل الدخول والتسجيل';
$string['allowindexingnowhere'] = 'لا مكان';
$string['allowobjectembed'] = 'السماح بوسوم EMBED ووسوم OBJECT';
$string['allowthemechangeonurl'] = 'السماح بتغييرات القالب في عنوان الرابط';
$string['allowuserblockhiding'] = 'إسمح للمستخدمين بإخفاء الكتل';
$string['allowusermailcharset'] = 'إسمح للمستخدمين باختيار طقم الحروف';
$string['allowuserswitchrolestheycantassign'] = 'السماح للمستخدمين الذين ليست لهم إمكانية تعيين الأدوار بتبديل الأدوار';
$string['allowuserthemes'] = 'إسمح بقوالب الموقع على مستوى المستخدمين';
$string['alternativefullnameformat'] = 'التنسيق البديل للاسم الكامل';
$string['alternativefullnameformat_desc'] = 'هذا يحدد كيفية إظهار الأسماء للمستخدمين الذين لديهم الإمكانية viewfullnames (إفتراضياً، هم كل من المدير، المعلم، والمعلم بلا صلاحية التحرير).
العناصر النائبة التي يمكن استعمالها هي كما تم ذكرها في الإعداد "تنسيق الاسم الكامل".';
$string['always'] = 'دائماً';
$string['appearance'] = 'المظهر';
$string['aspellpath'] = 'المسار إلى aspell';
$string['asyncbackupdisabled'] = 'موقعك مهيأ حاليًا لاستعمال الحفظ الاحتياطي التزامني.
الحفظ الاحتياطي اللاتزامني يوفر تجربة مستخدم أفضل، مما يسمح للمستخدمين بالقيام بأعمال أخرى خلال فترة تنفيذ الحفظ الاحتياطي أو الاستعادة. سيتم تمكين الحفظ الاحتياطي اللاتزامني بدءًا من مودل 4.5. ستتم إزالة الحفظ الاحتياطي التزامني من مودل بعد الإصدار 4.5 ذي فترة الدعم المطولة.';
$string['authentication'] = 'المصادقة';
$string['authpreventaccountcreation'] = 'إمنع إنشاء الحساب عند المصادقة';
$string['authpreventaccountcreation_help'] = 'عند المُصادقة على مستخدم، يتم إنشاء حساب له في الموقع تلقائياً إذا لم يكن موجوداً حتى الآن. إذا تم استعمال قاعدة بيانات خارجية، مثل LDAP للمصادقة، ولكن كنت ترغب في تقييد الوصول إلى الموقع وجعله مقتصراً على المستخدمين الذين لديهم حسابات موجودة مُسبقاً فقط، فهذا الخيار يجب تفعيله. الحسابات الجديدة ستتطلب إنشاءها إما يدوياً أو عن طريق ميزة رفع المستخدمين. لاحظ أن هذا الإعداد لا ينطبق على مصادقة شبكة مودل.';
$string['authsettings'] = 'إدارة المصادقة';
$string['autolang'] = 'التعرف التلقائي على اللغة';
$string['autolangusercreation'] = 'عند إنشاء الحساب، إجعل لغة المتصفح الذي يستعمله المستخدم بمثابة لغته المفضلة';
$string['autologinguests'] = 'الدخول التلقائي للضيوف';
$string['availableto'] = 'متاح الى';
$string['availabletoanyone'] = 'متاح لأي شخص يزور الموقع';
$string['availabletoauthenticated'] = 'مقتصر على المستخدمين المصرح لهم';
$string['backgroundcolour'] = 'لون شفاف';
$string['backup_shortname'] = 'استعمل اسم المقرر الدراسي في تسمية ملف الحفظ الاحتياطي';
$string['backup_shortnamehelp'] = 'استعمل اسم المقرر كجزء من تسمية ملف الحفظ الاحتياطي.';
$string['backups'] = 'الحفظ الاحتياطي';
$string['badwordsconfig'] = 'أدخل قائمتك للكلمات الممنوعة مفصولة بشولة.';
$string['badwordsdefault'] = 'إذا كانت القائمة المخصصة فارغة، سيتم استعمال القائمة الافتراضية الموجودة في حزمة اللغة.';
$string['badwordslist'] = 'قائمة الكلمات السيئة المخصصة';
$string['blockediplist'] = 'قائمة عناوين IP المحظورة';
$string['blockinstances'] = 'المثيلات';
$string['blockmultiple'] = 'اختيار من متعدد';
$string['blockprotect'] = 'حماية المثيلات';
$string['blockprotect_help'] = 'إذا قمت بتأمين نوع معين من الكتل، فلن يتمكن أي شخص من إضافة أو حذف عيناتها. (يمكنك بالطبع إلغاء التأمين مرة أخرى إذا كنت بحاجة إلى تعديل العينات).

 يهدف هذا إلى حماية الكتل مثل التنقل والإعدادات التي يصعب استعادتها إذا تم حذفها عن طريق الخطأ.';
$string['blockprotectblock'] = 'حماية عيِّنات {$a}';
$string['blockprotected'] = 'عيِّنات كتلة {$a} محمية الآن.';
$string['blocksettings'] = 'إدارة الكتل';
$string['blockunprotectblock'] = 'إلغاء حماية عيِّنات {$a}';
$string['blockunprotected'] = 'عيِّنات كتلة {$a} لم تعد محمية';
$string['bloglevel'] = 'المرئي من المدونة';
$string['bookmarkadded'] = 'تمت إضافة الإشارة المرجعية';
$string['bookmarkalreadyexists'] = 'لديك بالفعل إشارة مرجعية لهذه الصفحة.';
$string['bookmarkdeleted'] = 'تم حذف الإشارة المرجعية';
$string['bookmarkthispage'] = 'ضع إشارة مرجعية لهذه الصفحة';
$string['cacheapplication'] = 'مُخَبَّأ التطبيق';
$string['cacheapplicationhelp'] = 'العناصر المخبأة مشتركة بين جميع المستخدمين وتنتهي صلاحيتها حتى وقت استبقاء محدد (ttl).';
$string['cachejs'] = 'تخبئة Javascript';
$string['cachejs_help'] = 'تُحسِّن تخبئة Javascript وضغطه من أداء تحميل الصفحات بشكل كبير. يُنصح به بشدة لمواقع الإنتاج. ربما قد يرغب المطورون بتعطيل هذه الميزة.';
$string['cacherequest'] = 'مُخَبَّأ الطلب';
$string['cacherequesthelp'] = 'النسخة المخبأة الخاصة بالمستخدم والتي تنتهي عندما يكون الطلب جاهزاً. مصممة لتحل محل المناطق التي تستعمل مخازن ثابتة.';
$string['cachesession'] = 'مُخَبَّأ الجلسة';
$string['cachesessionhelp'] = 'النسخة المخبأة الخاصة بالمستخدم والتي تنتهي عندما تنتهي جلسة عمله. تهدف إلى تخفيف ضغط الجلسة وانتفاخها.';
$string['cachesettings'] = 'إعدادات المخبوءات';
$string['cachetemplates'] = 'تخبئة القوالب';
$string['cachetemplates_help'] = 'تعمل تخبئة للمظهر على تحسين أداء تحميل الصفحة ويوصى به بشدة في مواقع الإنتاج. ربما يريد المطورون تعطيل هذه الميزة.';
$string['caching'] = 'الذاكرة المؤقتة';
$string['calendar_weekend'] = 'أيام عطلة نهاية الأسبوع';
$string['calendarexportsalt'] = 'الشفرة الفريدة الخاصة بتصدير التقويم';
$string['calendarsettings'] = 'التقويم';
$string['calendartype'] = 'نوع التقويم';
$string['calendartype_desc'] = 'اختر نوع التقويم الافتراضي للموقع بأكمله. هذا الإعداد يمكن تغييره في إعدادات المقرر أو من قبل المستخدمين في ملفاتهم الشخصية.';
$string['campaign'] = 'الحملة';
$string['cannotdeletemodfilter'] = 'لا يمكنك إلغاء تنصيب المرشح \'{$a->filter}\'  لأنه جزء من الوحدة \'{$a->module}\'';
$string['cannotuninstall'] = '{$a} لا يمكن إلغاء تنصيبه.';
$string['categoryemail'] = 'البريد الإلكتروني';
$string['cfgwwwrootslashwarning'] = 'يتم تحديد $ CFG-> wwwroot بشكل غير صحيح في ملف config.php. يتضمن حرف "/" في النهاية يجب إزالته.';
$string['cfgwwwrootwarning'] = 'تم تعريف $CFG->wwwroot بشكل غير صحيح في ملف config.php. ينبغي أن يتطابق مع عنوان الرابط الذي تستعمله للوصول إلى هذه الصفحة.';
$string['change'] = 'تغيير';
$string['checkboxno'] = 'لا';
$string['checkboxyes'] = 'نعم';
$string['checkupgradepending'] = 'الترقية';
$string['choosefiletoedit'] = 'إختر الملف للتحرير';
$string['cleanup'] = 'التنظيف';
$string['clianswerno'] = 'لا';
$string['cliansweryes'] = 'نعم';
$string['cliexitgraceful'] = 'يجري الخروج بأمان، إنتظر لطفاً...';
$string['cliexitnow'] = 'يجري الخروج فوراً';
$string['cliincorrectvalueerror'] = 'خطأ، القيمة "{$a->value}" غير صحيحة لـ "{$a->option}"';
$string['cliincorrectvalueretry'] = 'قيمة غير صحيحة، حاول مرة أخرى';
$string['clistatusdisabled'] = 'الحالة: معطّل';
$string['clistatusenabled'] = 'الحالة: ممكّن';
$string['clistatusenabledlater'] = 'الحالة: سيتم تمكين نمط صيانة عبر واجهة سطر الأوامر في {$a}';
$string['clitypevalue'] = 'اكتب قيمة';
$string['clitypevaluedefault'] = 'أدخل القيمة أو إضغط مفتاح Enter لاستعمال القيمة الافتراضية ({$a})';
$string['cliunknowoption'] = 'خيارات غير معروفة: {$a} الرجاء استخدام -- خيار المساعدة.';
$string['cliupgradecompletenomaintenanceupgrade'] = 'النص البرمجي لتطهير المخبوءات المتبقية بعد انقطاع اتصال المستخدم:

  php admin/cli/purge_caches.php --muc
  php admin/cli/purge_caches.php --js
  php admin/cli/purge_caches.php --filter
  php admin/cli/purge_caches.php --other

ينبغي عليك القيام بتلك التطهيرات مع ترك فترة بين تنفيذ أوامرها من أجل تقليل طفرة الجهد العالي على المخدم.';
$string['cliupgradedefault'] = 'نص جديد : {$a}';
$string['cliupgradedefaultheading'] = 'تعيين القيم الافتراضية الجديدة';
$string['cliupgradedefaultverbose'] = 'إعداد جديد: {$a->name}، القيمة الافتراضية: {$a->defaultsetting}';
$string['cliupgradefinished'] = 'تم إكمال ترقية سطر الأوامر من  {$a->oldversion} إلى {$a->newversion} بنجاح.';
$string['cliupgrademaintenancenotrequired'] = 'هذه الترقية لن تؤدي إلى جعل الموقع في وضع الصيانة بالنسبة للمستخدمين.';
$string['cliupgrademaintenancerequired'] = 'هذه الترقيةستؤدي إلى جعل الموقع في وضع الصيانة بالنسبة للمستخدمين.';
$string['cliupgradenoneed'] = 'لا ترقية لازمة للإصدار {$a} المثبت. شكرا لمجيئك على أيّ حال !';
$string['cliupgradepending'] = 'الترقية معلقة';
$string['cliupgradesetlock'] = 'الترقية تتم حصريًا عبر التنفيذ من سطر الأوامر فقط.';
$string['cliupgradeunsetlock'] = 'تمت إزالة جعل الترقية مقصورة على التنفيذ من سطر الأوامر.';
$string['cliyesnoprompt'] = 'أدخل y (وتعني نعم) أو n (وتعني لا)';
$string['close'] = 'إغلاق';
$string['cohort_customfield'] = 'الحقول المخصصة للدفعات';
$string['commentsperpage'] = 'التعليقات المعروضة في كل صفحة';
$string['commonactivitysettings'] = 'إعدادات عامة';
$string['commonfiltersettings'] = 'إعدادات المرشح الشائعة';
$string['commonsettings'] = 'الإعدادات العامة';
$string['componentinstalled'] = 'تم تنصيب المُكون';
$string['computedfromlogs'] = 'محسوب من سجلات الوقوعات منذ {$a}.';
$string['condifmodeditdefaults'] = 'القيم الافتراضية تستعمل في نموذج الإعدادات عند إنشاء نشاط أو مورد جديد.';
$string['confeditorhidebuttons'] = 'إختر الأزرار التي ينبغي إخفاؤها من محرر HTML.';
$string['configallcountrycodes'] = 'هذه تمثل قائمة البلدان التي يمكن اختيارها في مواضع عدة من الموقع، مثلاً في الملف الشخصي للمستخدم. إذا تُركت فارغة (الوضع الافتراضي) سيتم استعمال قائمة البلدان من الملف countries.php والذي هو جزء من حزمة اللغة الإنجليزية القياسية. وهي القائمة المقدمة من قبل ISO 3166-1. بخلاف ذلك، يمكنك تحديد قائمة من الترميزات، مفصولاً بينها بفوارز، مثلاً \'AR,GB,FR,ES\'. إذا قمت بإضافة ترميزات جديدة، لا قياسية هنا، سيترتب عليك إضافتها أيضاً إلى الملف countries.php ضمن الحزمة \'en\' فضلاً عن حزم اللغات التي تستعملها.';
$string['configallowassign'] = 'لكل دور في العمود الأيمن، حدد الأدوار التي يمكنه تعيينها للآخرين.';
$string['configallowattachments'] = 'في حالة التمكين ، يمكن أن تحتوي رسائل البريد الإلكتروني المرسلة من الموقع على مرفقات ، مثل الشارات.';
$string['configallowcategorythemes'] = 'إذا مكّنت هذا، فالقوالب يمكن تعيينها على مستوى التصنيف. سيؤثر هذا على جميع التصنيفات الفرعية والمقررات الدراسية ما لم تكن قد خُصِّصَت بقالب خاص بها.
تحذير: تمكين قوالب التصنيف قد يؤثر على الأداء.';
$string['configallowcohortthemes'] = 'إذا قمت بتمكينه، فسيكون بالإمكان تعيين القالب على مستوى الدفعة. سيؤثر هذا على كل المستخدمين في دفعة واحدة فقط أو أكثر من واحدة ولكن مع نفس القالب.';
$string['configallowcoursethemes'] = 'عند تمكينه، سيُسمح للمقررات الدراسية باختيار القوالب الخاصة بها. قوالب المقررات تتجاوز كل خيارات القوالب الأخرى (الموقع، المستخدم، التصنيف، الدفعة أو القوالب المعرفة حسب عنوان الرابط).';
$string['configallowedemaildomains'] = 'أدرج نطاقات البريد الإلكتروني التي يسمح بكشفها في خانة "من" للبريد الصادر. في حال ترك الخانة فارغة، فسيتم استخدام العنوان المعتمد لعدم الرد لكل بريد صادر. استخدام رموز مستبدله مثل *.example.com سيسمح بمرور كل البريد المرسل من نطاقات بريدية متفرعة عن النطاق example.com دون أن يسمح للبريد الصادر عن النطاق example.com نفسه. للسماح بمرور البريد الصادر عن النطاق الرئيس، فيجب أدراجه أيضا بشكل منفصل.';
$string['configallowemailaddresses'] = 'إذا كنت ترغب بتقييد كل عناوين البريد الإلكتروني الجديدة بنطاقات معينة، يتوجب عليك سردهم هنا منفصلين بمسافة. كل النطاقات الأخرى سترفض. للسماح بالنطاقات الفرعية أضف النطاق وقبله نقطة \'.\'. للسماح بالنطاق الرئيسي مع نطاقاته الفرعية، أضف النطاق مرتين - مرة مسبوقًا بنقطة \'.\' ومرة أخرى بدونها، على سبيل المثال، <strong>.ourcollege.edu.au</strong> و <strong>ourcollege.edu.au</strong>';
$string['configallowemojipicker'] = 'يمكّن منتقي الرموز التعبيرية المستخدمين من اختيار الرموز التعبيرية، مثل الابتسامات، لإضافتها إلى الرسائل ومناطق النص الأخرى عبر زر منتقي الرموز التعبيرية في شريط أدوات Atto.';
$string['configallowemojipickerincompatible'] = 'تهيئة قاعدة البيانات الحالية لا تدعم الرموز التعبيرية بشكل صحيح. من أجل تمكين منتقي الرموز التعبيرية، ستحتاج إلى <a href="https://docs.moodle.org/en/MySQL_full_unicode_support"> ترقية قاعدة البيانات للحصول على دعم يونيكود الكامل</a>.';
$string['configallowguestmymoodle'] = 'عند التمكين، سيتمكن الضيوف من الوصول إلى لوحة التحكم، بخلاف ذلك سيتم توجيه الضيوف إلى واجهة الموقع.';
$string['configallowobjectembed'] = 'كإجراء أمني، لا يسمح للمستخدمين ذوي دور الطالب بتضمين ملفات وسائط متعددة ضمن النصوص باستعمال وسوم التضمين EMBED وOBJECT في نصوص HTML، على الرغم من أنه لا يزال بالإمكان عرض الوسائط المتعددة باستعمال ملحق مرشح تضمين الوسائط المتعددة. إذا أردتَ السماح بهذه الوسوم، قم بتمكين هذا الخيار.';
$string['configallowoverride'] = 'يمكنك السماح لذوي الأدوار التي على الجانب الأيمن بتجاوز بعض من الأدوار في العمود.';
$string['configallowoverride2'] = 'لكل دور في العمود الأيمن، حدد الأدوار التي يمكنه ضبط التخطي لها.<br/>على المستخدمين أيضًا أن تكون لديهم الإمكانية moodle/role:override أو الإمكانية moodle/role:safeoverride.';
$string['configallowswitch'] = 'لكل دور في العمود الأيمن، حدد الأدوار التي يمكنه التبديل إليها. ينبغي أن تكون للمستخدم أيضاً الإمكانية moodle/role:switchroles';
$string['configallowthemechangeonurl'] = 'عند تمكينه، يمكن تغيير القالب بإضافة إمّا:<br/>?theme=themename إلى أي رابط في مودل (مثل: mymoodlesite.com/?theme=afterburner) أو <br/>&theme=themename إلى أي رابط داخلي في مودل (مثل: mymoodlesite.com/course/view.php?id=2&theme=afterburner).';
$string['configallowuserblockhiding'] = 'هل ترغب بالسماح للمستخدمين بإخفاء/إظهار الكتل الجانبية في الموقع؟ هذه الخاصية تستعمل Javascript  وملفات تعريف الارتباط لتتذكر حالة كل كتلة، وهذا سيؤثر على معاينة المستخدم.';
$string['configallowusermailcharset'] = 'تمكين هذا الخيار، سيمكن مستخدمي الموقع من تحديد مجموعة أحرف البريد الالكتروني في تفضيلاتهم للمراسلة.';
$string['configallowuserswitchrolestheycantassign'] = 'إفتراضي، الإمكانية moodle/role:assign مطلوبة ليتمكن المستخدمون من تبديل الأدوار. يؤدي تمكين هذا الإعداد إلى إزالة هذا المطلب، ويؤدي إلى جعل الأدوار المتاحة في القائمة المنسدلة "تبديل الدور إلى" مقتصرة على الإعدادات في جدول "السماح بتعيينات الدور" فقط. يوصى بأن الإعدادات في جدول "السماح بتعيينات الدور" لا تسمح للمستخدمين بالتبديل إلى دور ذي إمكانيات أعلى من دورهم الحالي.';
$string['configallowuserthemes'] = 'إذا تم تمكينه، سيسمح ذلك للمستخدمين باختيار القوالب الخاصة بهم، قالب المستخدم يطغى على قالب الموقع، (ولكنه لن يطغى على قالب المقرر)';
$string['configallowview'] = 'لكل دور في العمود الأيمن، حدد الأدوار التي يمكنه معاينتها، البحث عنها ترشيح المستخدمين وفقاً لها.';
$string['configallusersaresitestudents'] = 'للأنشطة التي في واجهة الموقع، هل كُلّ المستخدمين يَنبغي اعتبارهم طلابًا؟ إذا كانت الإجابة "نعم"، سَيُسْمحُ بالمُشَارَكَة فيها بدور الطالب لأيّ صاحب حساب مؤكد. إن كانت الإجابة "لا"، فقط المستخدمون الذين هم مشاركون في مقرر واحد على الأقل سيكونون قادرين على الاشتِراك في أنشطة الواجهة.
فقط المشرفون والمعلمون المعينون بشكل خاص يُمْكِنُهم أَنْ يتصرفوا كمعلمين مع أنشطة واجهة الموقع.';
$string['configauthenticationplugins'] = 'الرجاء اختيار المكونات الإضافية للمصادقة التي ترغب في استخدامها ثم رتبها حسب إمكانيات الدخول .';
$string['configautolang'] = 'إكتشف اللغة الافتراضية من إعدادات المتصفح، في حالة تعطيله، استعمل اللغة الافتراضية للموقع.';
$string['configautolangusercreation'] = 'إذا تم تمكينه، عند إنشاء حساب المستخدم تلقائياً خلال دخوله الأول (مثلاً عند استعمال مصادقة LDAP أو OAuth 2)، سيتم اعتبار لغة المتصفح الذي يستعمله المستخدم بمثابة لغته المفضلة في الموقع. بخلاف ذلك، ستكون اللغة الافتراضية في الموقع هي لغته المفضلة.';
$string['configautologinguests'] = 'هل ينبغي اعتبار الزوار تلقائياً كضيوف عندما يدخلون إلى مقررات تسمح بدخول الضيوف؟';
$string['configbloglevel'] = 'هذا الاعداد يَسْمحُ لك بتقييد المستوى الذي يمكن من خلاله معاينة المدونات الخاصة بالمستخدمين في هذا الموقعِ. لاحظ أن هذا سيُحدّدَ السياقَ الأقصى للمشاهدِ ولَيس للمشارك أَو أنواعَ منشورات المدونات. كما يُمْكِنُ تعطيل المدونات بالكامل إذا كنت لا تُريدُها مطلقاً.';
$string['configcalendarcustomexport'] = 'تمكين تصدير نطاق مخصص من تواريخ التقويم';
$string['configcalendarexportsalt'] = 'يُستعمل هذا النص العشوائي لتحسين أمان ترميزات المصادقة المستعملة عند تصدير التقويمات. يرجى ملاحظة أن جميع الترميزات الحالية تبطل إذا قمت بتغيير هذه الشفرة .';
$string['configcookiesecure'] = 'إذا كان المخدم يقبل فقط اتصالات https، فمن المستحسن تمكين إرسال ملفات تعريف الارتباط الآمنة. إذا مكّن، يرجى التأكد من أن مخدم الويب لا يقبل http:// أو قم بضبطه بحيث تكون هناك إعادة توجيه دائمة إلى عنوان https://، وبشكل مثالي، إرسال تروسيات HSTS. عندما لا يبدأ عنوان <em>wwwroot</em> بـ https://، يتم تجاهل هذا الإعداد.';
$string['configcountry'] = 'إذا قمت بتحديد البلد هنا، فسيكون هو البلد الافتراضي لكل المستخدمين الجدد، لتفرض على المستخدمين إختيار دولهم، أتركه خالياً.';
$string['configcoursegraceperiodafter'] = 'صنّف المقررات الدراسية المنتهية على أنها جارية حالياً لهذا العدد من الأيام بعد تاريخ انتهائها.';
$string['configcoursegraceperiodbefore'] = 'صنّف المقررات الدراسية المستقبلية على أنها جارية حالياً بدءً من هذا العدد من الأيام السابقة لتاريخ بدئها.';
$string['configcourseoverviewfilesext'] = 'قائمة مفصولة بفواصل لامتدادات ملفات صور المقرر المسموح بها.';
$string['configcourseoverviewfileslimit'] = 'أقصى عدد من الملفات التي يمكن عرضها بجوار ملخص المقرر في صفحة قائمة المقررات الدراسية. يتم استعمال ملف الصورة الأول المُضاف كصورة للمقرر في نظرة عامة على المقرر؛ عند لوحة التحكم بالمستخدمين. يتم عرض أيّ ملفات إضافية في صفحة قائمة المقررات الدراسية فقط.';
$string['configcourserequestnotify'] = 'أكتب اسم المستخدم الخاص بالمستخدم الذي سيتم إشعاره عند طلب مقرر جديد';
$string['configcourserequestnotify2'] = 'قائمة المستخدمين الذين سيتم إشعارهم عند طلب المقرر. المستخدمون التالية أسماؤهم فقط هم من يستطيع الموافقة على طلبات إنشاء المقررات الدراسية.';
$string['configcoursesperpage'] = 'أدخل عدد المقررات الدراسية المعروضة لكل صفحة من صفحات قائمة المقررات';
$string['configcourseswithsummarieslimit'] = 'أقصى عدد من المقررات الدراسية التي سيتم عرضها في قائمة المقررات  ذات الملخصات قبل التراجع إلى قائمة أبسط.';
$string['configcronclionly'] = 'يمكن أن يؤدي تشغيل cron من مستعرض الويب إلى كشف المعلومات المميزة للمستخدمين المجهولين. وبالتالي فمن المستحسن تشغيل cron فقط من سطر الأوامر أو تعيين كلمة مرور cron للوصول البعيد.';
$string['configcronremotepassword'] = 'هذا يعني أن النص البرمجي الخاص بـ cron.php لا يمكن تنفيذه من متصفح الويب بدون تزويد كلمة المرور باستعمال الصيغة الآتية من عنوان الويب:<pre>
https://site.example.com/admin/cron.php?password=opensesame </pre>لا حاجة لكلمة مرور في حالة تركه خالياً.';
$string['configcurlcache'] = 'وقت النشاط المتاح مقابل سطر نقل الأوامر من الذاكرة المؤقتة ، بالثواني.';
$string['configcustommenuitems'] = 'يمكن تهيئة قائمة مخصصة هنا. أدخل كل عنصر من عناصر القائمة في سطر جديد بالصيغة الآتية: نص عنصر القائمة، رابط (اختياري وليس لعنصر القائمة الرئيسي ذي العناصر الفرعية)، نص التلميح (اختياري)، ورمز اللغة أو قائمة برموز اللغات مفصولاً بين عناصرها بفارزة (اختياري، من أجل عرض النص للمستخدمين بهذه اللغة حصرياً)... مفصولة جميعاً فيما بينها بحرف الأنبوب (|). السطور البادئة بالحرف (-) ستظهر بمثابة فقرات فرعية ضمن عنصر القائمة الأعلى منها رتبة. استعمل ### لإنشاء فاصل أفقي ما بين العناصر في القائمة. على سبيل المثال:
<pre>
Courses
-All courses|/course/
-Course search|/course/search.php
-###
-FAQ|https://someurl.xyz/faq
-Preguntas más frecuentes|https://someurl.xyz/pmf||es
Mobile app|https://someurl.xyz/app|Download our app
</pre>';
$string['configcustomusermenuitems'] = 'يمكنك تهيئة محتويات قائمة المستخدم (باستثناء رابط تسجيل الخروج، الذي تتم إضافته تلقائياً). يتم الفصل ما بين مكونات كل سطر بأحرف توجيهية ويتكون من:
1) سلسلة بشكل "langstringname ، componentname" أو كنص عادي
2) عنوان الرابط
يمكن استعمال المقسمات عن طريق إضافة سطر من الرمز # منفرداً أو أكثر في المكان المطلوب.';
$string['configdbsessions'] = 'في حالة التمكين ، سيستخدم هذا الإعداد قاعدة البيانات لتخزين معلومات حول الجلسات الحالية. لاحظ أن تغيير هذا الإعداد الآن سيؤدي إلى تسجيل خروج جميع المستخدمين الحاليين (بمن فيهم أنت). إذا كنت تستخدم MySQL ، فيرجى التأكد من أن "max_allowed_packet" في my.cnf (أو my.ini) لا يقل عن 4 ملايين. يمكن تكوين برامج تشغيل الجلسات الأخرى مباشرةً في config.php ، راجع config-dist.php لمزيد من المعلومات. يختفي هذا الخيار إذا قمت بتحديد برنامج تشغيل الجلسة في ملف config.php.';
$string['configdebug'] = 'إذا قمت بتشغيل هذا، إذن تقارير PHP من نوع error_reporting ستزداد لذلك سيظهر المزيد من التحذيرات. هذا مفيدٌ فقط للمطوّرين.';
$string['configdebugdisplay'] = 'عند تعيينه إلى تشغيل، التقرير عن الخطأ سيذهب إلى صفحة HTML. هذا عملي، ولكنه يكسر ملفات تعريف الارتباط، HTML، JS،  ورؤوس HTTP بشكل عام. عند تعيينه إلى إيقاف، سيرسل المخرجات إلى سجلات وقوعات المخدم الخاص بك، مما يتيح فرصة أفضل للتصحيح. إعداد PHP المسمى error_log يتحكم بأيّ سجل سيذهب هذا.';
$string['configdebugpageinfo'] = 'مكّنه إذا أردتَ طباعة معلومات الصفحة في تذييل الصفحة.';
$string['configdebugvalidators'] = 'مكّنه إذا كنت تريد أن يكون لك روابط إلى مخدمات تدقيق خارجي في تذييل الصفحة. قد تحتاج إلى إنشاء مستخدم جديد باستعمال اسم المستخدم <<em>w3cvalidator</em>، وتمكين دخول الضيف. هذه التغييرات قد تسمح بدخول غير المصرح لهم إلى المخدم، لا تقم بتمكينه في مواقع الإنتاج!';
$string['configdefaulthomepage'] = 'أي صفحة تنبغي إعادة توجيه المستخدمين إليها بعد تسجيل دخولهم إلى الموقع؟ يحدد هذا الإعداد أيضًا الرابط الأول في التنقل لمستخدمي القوالب المبنية على القالب الكلاسيكي.';
$string['configdefaultrequestcategory'] = 'سيتم وضع المقررات الدراسية التي يطلبها المستخدمون مع إمكانية طلب مقررات جديدة في سياق النظام في هذا التصنيف؛ ما لم يتمكن المستخدمون من تحديد تصنيف مختلف.';
$string['configdefaultrequestedcategory'] = 'التصنيف الافتراضي التي توضع فيه المقررات الدراسية المطلوبة، إذا تمت الموافقة عليها.';
$string['configdefaultuserroleid'] = 'كُلّ المستخدمين الذين دخلوا الموقع سَيَعطونَ الإمكانات في الدورِ الذي تُحدّدُه هنا، على مستوى الموقعَ، بالإضافة إلى أيّ أدوار أخرى تم منحهم إياها مسبقًا. مستوى الدور الافتراضي هو دورُ المستخدم المصرح له. لاحظْ بِأَنَّ هذا لَنْ يتعارض مع الأدوارِ الأخرى الممنوحة، إلا إذا كنت تمنع الإمكانات، إنه يضمن فقط أن جميع المستخدمين لديهم القدرات التي هي غير قابلة للمنح على مستوى المقرر (على سبيل المثال النشر في المدونات، إدارة التقويم الشخصي... إلخ).';
$string['configdeleteincompleteusers'] = 'بعد هذه الفترة، يتم حذف أيّ حساب بدون الاسم الأول أو اسم العائلة أو حقل البريد الالكتروني.';
$string['configdeleteunconfirmed'] = 'بالنسبة لبعض طرق المصادقة ، مثل التسجيل الذاتي القائم على البريد الإلكتروني ، يجب على المستخدمين تأكيد حساباتهم في غضون فترة زمنية معينة. بعد هذه الفترة ، يتم حذف أيّ حسابات قديمة غير مؤكدة.';
$string['configdenyemailaddresses'] = 'لرفض عناوين البريد الالكتروني مِنْ مجالاتِ معيّنة، قم بإدراج تلك المجالات هنا بالطريقة نفسها. كُلّ المجالات الأخرى سَتَكُونُ مقبولة.  لرفض مجالات فرعية، أضف المجال مع سبقه بنقطة \'.\' ومثالاً على ذلك: - <strong>hotmail.com yahoo.co.uk .live.com</strong>';
$string['configdisableuserimages'] = 'عطل قدرة المستخدمين على تغيير الصورة في الملف الشخصي .';
$string['configdisplayloginfailures'] = 'سيعرض هذا معلومات للمستخدمين حول عمليات تسجيل الدخول الفاشلة السابقة.';
$string['configdndallowtextandlinks'] = 'تمكين أو تعطيل السحب والإفلات للنص والروابط في صفحة المقرر، جنبًا إلى جنب مع سحب وإفلات الملفات. لاحظ أن سحب النص إلى فايرفوكس أو بين مختلف المتصفحات لا يعتمد عليه وربما يؤدي إلى فقد البيانات التي يتم تحميلها، أو عطب النص المحمل.';
$string['configdoclang'] = 'سيتم استخدام هذه اللغة في روابط صفحات التوثيق.';
$string['configdocroot'] = 'يحدد المسار المؤدي إلى توثيقات مودل لتوفير ما هو خاص بالسياق عبر روابط \'التوثيقات الخاصة بالصفحة\' عند تذييل كل صفحة. إذا تُرِك الحقل فارغاً، فلن يتم عرض الروابط.';
$string['configdoctonewwindow'] = 'عند تمكينه، ستُفتح روابط توثيقات مودل في نافذة جديدة.';
$string['configduration_high'] = 'هذه القيمة عالية جدًا. القيمة القصوى هي {$a}.';
$string['configduration_low'] = 'هذه القيمة صغيرة جدًا. القيمة الصغرى هي {$a}.';
$string['configeditordictionary'] = 'سيتم استعمال هذه القيمة إذا لم يكن لدى aspell قاموس للغة المستخدم.';
$string['configeditorfontlist'] = 'اخترْ الخطوطَ التي يَجِبُ أَنْ تَظْهرَ في القائمة المنسدلة للمحرّرَ .';
$string['configemailchangeconfirmation'] = 'يتطلب خطوة التأكيد بالبريد الالكتروني عند تغيير المستخدمين لعنوان بريدهم في ملفاتهم الشخصية.';
$string['configemaildkimselector'] = 'إن منتقي DKIM عشوائي وعلى سجل/سجلات DNS أن تتوافق مع ذلك.';
$string['configemailfromvia'] = 'أضف معلومة (بواسطة) في قسم "من" للبريد الالكتروني الصادر. هذا يُعلم المستلم من أين جاء هذا البريد الالكتروني ويساعد أيضًا في إيقاف المستلمين الذين يردون بطريق الخطأ على عناوين البريد الالكتروني التي لا ترد.';
$string['configemailheaders'] = 'رؤوس العناوين الخام التي يراد إضافتها حرفياً إلى كل الرسائل الخارجة من النظام.';
$string['configemailsubjectprefix'] = 'النص المطلوب كبادئة إلى سطر الموضوع الخاص بكل البريد الصادر.';
$string['configenableanalytics'] = 'نماذج التحليلات، مثل \'الطلاب المعرضون لخطر الرسوب\' أو \'الأنشطة القادمة المستحقة\'، يمكنها أن تولّد تنبؤات، ترسل إشعارات بتلك الرؤى، وتقدم إجراءات إضافية، مثل مراسلة المستخدمين.';
$string['configenableblogs'] = 'هذا المحول يوفر لجميع مستخدمي الموقع مع مدوناتهم الخاصة بهم.';
$string['configenablecalendarexport'] = 'تمكين التصدير أو الاشتراك في التقاويم.';
$string['configenablecomments'] = 'تمكين التعليقات';
$string['configenablecourserequests'] = 'في حالة التمكين، سيكون لدى المستخدمين الذين لديهم إمكانية طلب مقررات دراسية جديدة (moodle/course:request) خيار طلب إنشاء مقرر. هذه الإمكانية غير مسموح بها لأي من الأدوار الافتراضية. قد يتم تطبيقها في سياق النظام أو التصنيف.';
$string['configenablemobilewebservice'] = 'تمكين خدمة الجوال لتطبيق مودل الرسمي أو التطبيقات الأخرى التي قد تطلبها. لمزيد من المعلومات، يرجى قراءة {$a}';
$string['configenablerssfeeds'] = 'في حالة التمكين، يتم إنشاء مغذيات خدمة الأخبار بواسطة العديد من الميزات عبر الموقع، مثل المدونات، المنتديات، أنشطة قواعد البيانات والمسارد. لاحظ أن مغذيات خدمة الأخبار تتطلب أيضاً التمكين في وحدات النشاط بعينها.';
$string['configenablerssfeedsdisabled'] = 'لَيست متوفرة لأن خدمة تغذية الأخبار معطلة في كُلّ الموقعِ . لتفعيلها ، اذْهبُ إلى إعدادات المتغيّراتَ تحت إعدادات المسؤول .';
$string['configenablerssfeedsdisabled2'] = 'خدمة تغذية الأخبار معطلة حالياً على مستوى الموقع. ينبغي تمكينها أولاً في المزايا المتقدمة في إدارة الموقع.';
$string['configenablestats'] = 'إذا قمت باختيار \'نعم\' هنا، سيقوم مشغل المهام المجدولة لمودل بمعالجة السجلات وتَجْميع بَعْض الإحصائياتِ. إعتِماداً على حجم الحركة في موقعِكَ، سيستغرق ذلك وقتاً، إذا قمت بتمْكِين هذا الخيار، سَتَكُونُ قادراً على رُؤية بَعْض الرسوم البيانية المثيرةِ والإحصائياتِ لكُلّ مقرراتك، أو على مستوى الموقع عموماً.';
$string['configenabletrusttext'] = 'إفتراضياً سيقوم مودل بتنظّيف النَص الذي يوضع مِنْ قبل المستخدمين لإزالة أيّ نصوص برمجية خبيثة محتملة قد تشكل خطراً. إنّ نظام المحتوى الموثوق هو طريقة لمنح بعض المستخدمين الذين تثق بهم صلاحية تَضْمين هذه الميزاتِ المتقدّمةِ في ما يقدمونه من محتوى بدون تدخل. لتَمْكين هذا النظامِ، عليك أولاً تَمْكين هذا الإعداد، ثم مْنح صلاحية وضع المحتوى الموثوق إلى دور معين. النصوص المنشأة أَو المرفوعة مِن قِبل هؤلاء المستخدمين ستؤشَّر على أنها موثق بها ولن يتم تنظيفها قبل عرضها.';
$string['configenablewebservices'] = 'خدمات الويب تمكن الأنظمة الأخرى، كتطبيقات الجوال من تسجيل الدخول إلى مودل وتنفيذ الأعمال فيه. حفاظاً على الأمان، ينبغي تعطيل هذه الميزة إلا إذا كنت تستعملها حقاً، أو كانت لديك أداة/خدمة خارجية تستدعي التكامل مع مودل عبر خدمات الويب.';
$string['configenablewsdocumentation'] = 'تمكين التوليد الآلي لتوثيقات خدمات الإنترنت. يمكن للمستخدم الوصول إلى التوثيقات الخاصة به من صفحة مفاتيح الأمان الخاصة به، {$a}. هناك تُعرض توثيقات البروتوكولات المُمَكَّنة فقط.';
$string['configerrorlevel'] = 'إخترْ كميةَ تحذيراتِ PHP التي تُريدُها أَنْ تُعْرَضَ. الوضع الطبيعي عادة هو أفضل إختيار.';
$string['configexportlookahead'] = 'عدد الأيام التي يغطيها التصدير في المستقبل';
$string['configexportlookback'] = 'عدد الأيام التي يغطيها التصدير في الماضي';
$string['configextendedusernamechars'] = 'إذا تم تمكينها، يمكن أن تتضمن أسماء دخول المستخدمين أيّ أحرف باستثناء الحروف اللاتينية الكبيرة. ما عدا ذلك، سيسمح الموقع فقط باستعمال الحروف اللاتينية الصغيرة، الأرقام، الشُّرط التحتانية (_)، الشُرط (-)، النقاط (.) والرمز (@) في أسماء الدخول.';
$string['configextramemorylimit'] = 'بعض النصوص البرمجية لوظائف مثل البحث، الحفظ الاحتياطي\\الاستعادة أو مشغل الوظائف الدورية تحتاج إلى ذاكرة أكبر. إضبط قيم أعلى للمواقع الكبيرة.';
$string['configfilterall'] = 'نقح كُلّ المقاطع، بما في ذلك العناوينِ، شريط التصفّح وهكذا. هذا مفيدُ في الغالب عند استعمال منقح متعدد اللغات، بخلاف ذلك فإِنَّهُ سيقوم بإضافة حمل إضافي على موقعِكَ مقابل فائدة ضئيلة.';
$string['configfiltermatchoneperpage'] = 'منقحات الربط التلقائي ستقوم بتوليد رابط منفرد لأول تطابق نصي يُعثر عليه في الصفحة، وسيتم تجاهل باقي المتطابقات.';
$string['configfiltermatchonepertext'] = 'ستقوم منقحات الربط التلقائي بتوليد رابط منفرد لأول عيِّنة من التطابق النصي يُعثر عليها في الصفحة لكل عنصر. سيتم تجاهل ما سواها. هذا الإعداد لا تأثير له إذا تم تمكين \'المنقح يطابق مرة واحد لكل صفحة\'.';
$string['configfilternavigationwithsystemcontext'] = 'الاستعمال العادي للمرشح يختص بالسياق الذي هو فيه (مثلاً سياق المقرر)، ولكن على مستوى تنقل الموقع، أن تجعل كل شيء مرشحًا وفقًا لسياق الموقع فهذا سيؤدي إلى تحسين الأداء عند استعمال ترشيح "المحتوى والعناوين".';
$string['configfilteruploadedfiles'] = 'معالجة كل الملفات ونصوص HTML المرفوعة إلى الموقع باستعمال المنقحات قبل عَرْضها، أو فقط فحص ملفات HTML أو إهمال الفحص على الإطلاق.';
$string['configforcelogin'] = 'عادة، يمكن قراءة صفحة واجهة الموقعِ وقائمة المقررات الدراسية فيها (لكن لَيس المقررات نفسها) مِن قِبل الناسِ بدون تسجيل الدخول إلى الموقعِ. إذا كنتَ تريد إجبار الناس على تسجيل الدخول قبل أن يقوموا بأي شيء في الموقع، فعليك تمكين هذا الإعداد.';
$string['configforceloginforprofiles'] = 'هذا الإعداد يجبر الناسِ على الدخول إلى الموقع بصفة مستخدم فعلي (ليس كضيف) قبل أن يُسْمَحَ له برُؤية صفحات الملفات الشخصية لباقي المستخدمين. إذا قمتَ بتعطيل هذا الإعداد، فقد يصادفك بعض المستخدمين الذين يقومون بوضع منشورات دعائية (مزعجة) أو أي أمور أخرى غير لائقة ضمن ملفاتهم الشخصية، والتي عندها ستكون مرئية للعالم أجمع.';
$string['configfrontpage'] = 'سيتم عرض العناصر المحددة أعلاه في واجهة الموقع.';
$string['configfrontpagecourselimit'] = 'أقصى عدد من المقررات الدراسية';
$string['configfrontpagecourselimithelp'] = 'أقصى عدد من المقررات الدراسية التي تظهر في صفحة واجهة الموقع ضمن قائمة المقررات.';
$string['configfrontpageloggedin'] = 'سيتم عرض العناصر المحددة أعلاه في واجهة الموقع بعد قيام المستخدم بتسجيل دخوله.';
$string['configfullnamedisplay'] = 'يحدد هذا كيفية إظهار الأسماء عند عرضها بالكامل. القيمة الافتراضية، "language"، تترك اتخاذ هذا القرار على عاتق السلسلة "fullamedisplay" في حزمة اللغة الحالية. تحتوي بعض اللغات على اصطلاحات عرض أسماء مختلفة.

بالنسبة إلى لمعظم المواقع أحادية اللغة، يكون الإعداد الأكثر كفاءة هو "firstname lastname"، ولكنك قد تختار إخفاء أسماء الألقاب تماماً. العناصر النائبة التي يمكن استعمالها هي: firstname، lastname، firstnamephonetic، lastnamephonetic، middlename، و alternatename.';
$string['configgeoipfile'] = 'موضع ملف بيانات GeoIP City. هذا الملف ليس جزءًا من توزيعة مودل وينبغي الحصول عليه بشكل منفصل من
<a href="https://www.maxmind.com/">MaxMind</a>.
يمكنك إما شراء نسخة تجارية أو استعمال الإصدار المجاني. سيكون عليك التسجيل من أجل تنزيل ملف قاعدة بيانات City، ويمكنك القيام بذلك من
<a href="https://dev.maxmind.com/geoip/geoip2/geolite2/" >https://dev.maxmind.com/geoip/geoip2/geolite2/</a>. بمجرد قيامك بالتسجيل وتنزيل الملف، قم بفك ضغطه في المجلد "{$a}" في مخدمك.';
$string['configgetremoteaddrconf'] = 'إذا كان الخادم الخاص بك هو وراء وكيل عكسي، يمكنك استعمال هذا الإعداد لتحديد أيّ من رؤوس HTTP يمكن الوثوق بها لاحتواء عنوان IP البعيد. تتم قراءة الرؤوس بالترتيب باستعمال أول واحد متاح منها.';
$string['configgradebookroles'] = 'هذا الإعداد يَسْمحُ لك بالسَيْطَرَة على مَنْ يظْهرُ في سجل التقديرات. ينبغي للمستخدمين أَنْ يَكُونَ عِنْدَهُمْ على الأقل أحد هذه الأدوارِ في المقرر ليتم إظهارهم في سجل تقديرات ذلك المقرر.';
$string['configgradeexport'] = 'إختر أيّ من صيغ تصدير سجل التقديرات لتكون هي الطريقة الرئيسية لتصديرها. الإضافات التي تحددها سيتم ضبطها وستستعمل حقل "آخر تصدير" لكل درجة. على سبيل المثال، هذا قد ينتج عنه تعريف السجلات المصدرة بأنها "جديدة" أو "محدّثة". إذا كنت غير متأكد من هذا، فاترك كل شيء دون تأشير.';
$string['configgradeexportdefault'] = 'حدد التنسيق الافتراضي لملف تصدير سجل التقديرات.';
$string['confighiddenuserfields'] = 'إختر حقول معلومات المستخدم التي ترغب بإخفائها عن باقي المستخدمين، عدا معلمي المقرر والمشرفين. هذا يزيد من خصوصية الطلاب. استمر بالضغط على المفتاح CTRL لاختيار أكثر من حقل.';
$string['configidnumber'] = 'هذا الخيار يحدد إمّا:
(أ) عدم مطالبة المستخدمين برقم الهوية أبداً،
(ب) مطالبة المستخدمين برقم الهوية، ولكن يمكنهم تْركه فارغاً،
(ج) مطالبة المستخدمين برقم الهوية ولا يَستطيعونَ تَرْكه فارغاً.
إذا تم التزويد بالرقم، فسيكون رقم الهوية مَعْرُوضًا في صفحة الملف الشخصي.';
$string['configintro'] = 'في هذه الصفحةِ يُمْكِنُك تحديد عدد مِنْ متغيّراتِ الإعدادات التي تُساعدُ على جَعْل مودل قادراً على العملِ بشكل صحيح في مخدمِك. لا تقلق كثيراً بشأن هذا الإعداد - الوضع الافتراضي سيعمل عادة بشكل صحيح ويمكنك دائماً العودة إلى هذه الصفحةِ لاحقاً للقيام بتغيير هذه الإعدادات.';
$string['configintroadmin'] = 'في هذه الصفحةِ يَجِبُ تهيئة حساب المشرف الرئيسي الذي سَتكونُ له سيطرةٌ كاملةٌ على الموقعِ. تأكّدْ من منحه اسم مستخدم وكلمةَ مرور آمنة فضلاً عن عنوان بريد الكتروني صحيح. ستتمكن من إنشاء حسابات مشرفين آخرين لاحقاً.';
$string['configintrosite'] = 'هذه الصفحة تسمح لك بتهيئة واجهة الموقع واسم هذا الموقع الجديد. يمكنك الرجوع إلى هنا في وقت لاحق لتغيير هذه الإعدادات متى تشاء باستعمال قوائم الإدارة.';
$string['configiplookup'] = 'عند النقر على عنوان IP (مثل 34.12.222.93)، كما هو الحال في سجلات الوقوعات، تظهر لك خريطة مع أفضل تخمين لموضع هذا الـ IP. هناك إضافات مختلفة تقوم بذلك والتي يمكنك الاختيار من بينها، ولكل منها مزايا وعيوب.';
$string['configkeeptagnamecase'] = 'ضع تأشيرة هنا إذا أردت أن تحتفظ أسماء الوسوم بحالة الأحرف الأصلية كما أدخلها المستخدمون الذين أوجدوها.';
$string['configlang'] = 'إختر اللغة الافتراضية للموقع بأكمله. يمكن للمستخدمين تجاوز هذا الإعداد باستعمال قائمة اللغة أو الإعداد في الملف الشخصي.';
$string['configlanglist'] = 'في حالة تركها فارغة، سيتم عرض كل اللغات المنصبة في الموقع في قائمة اللغة. بدلاً من ذلك، قد يتم تقصير قائمة اللغة عن طريق إدخال قائمة برموز اللغات مفصولة بفواصل. على سبيل المثال en,de,fr. إذا رغبت في ذلك، قد يتم تحديد اسم مختلف للغة عن اسم حزمة اللغة باستعمال التنسيق: language code|language name. على سبيل المثال en_kids|English,de_kids|Deutsch.';
$string['configlangmenu'] = 'اختر ما إذا كنت ترغب في عرض قائمة اللغة للأغراض العامة على الصفحة الرئيسية، مثل صفحة تسجيل الدخول ...
هذا لا يؤثر على قدرة المستخدم على تعيين اللغة المفضلة في ملفه الشخصي .';
$string['configlangstringcache'] = 'يقوم بتخبئة كل جُمل اللغة في ملفات مُجمعة داخل مجلد البيانات. ربما ترغب في تعطيل هذه الميزة في أثناء قيامك بترجمة مودل أو تغيير بعض الجُمل في مصدر النصوص البرمجية لمودل. بخلاف ذلك، يفضل أن تتركه مُمكَّناً لتحصل على أداء أفضل.';
$string['configlatinexcelexport'] = 'إختر ترميز التصدير إلى Excel.';
$string['configlocale'] = 'إختر ترميز لغة الموقع ككل - هذا سيتجاوز التنسيقات واللغة التي تُعرَض بها التواريخ التي تأتي بها حزم اللغات المختلفة (رغم أن أسماء الأيام في التقويم لا تتأثر به). تَحتاجُ لأَنْ يكُونَ هذا الترميز منصباً أيضاً في نظامِ تشغيلك (مثال من بيئة لينكس: en_US.UTF-8 أو es_ES.UTF-8). في أغلب الحالات، ينبغي ترك هذا الخيار فارغاً.';
$string['configlockrequestcategory'] = 'عند تمكينه، لن يتمكن المستخدمون الذين لديهم إمكانية طلب مقررات جديدة في سياق النظام من تحديد التصنيف في نموذج الطلب. تتمثل إحدى الطرق البديلة لتقييد طلبات المستخدمين لمقررات جديدة ضمن تصنيف واحد فقط؛ بتطبيق إمكانية طلب المقررات الدراسية الجديدة في سياق التصنيف.';
$string['configloglifetime'] = 'هذا يُحدّدُ طولَ المدة الزمنية التي ترغب فيها بإبْقاء سجلاتِ وقوعات الانشطة قبل أن تحذف تلقائياً. السجلات الأقدم مِنْ هذه المدة ستحْذفُ آلياً. من الأفضل إبْقاء السجلاتِ أطول فترة ممكنة تحسباً لاحتمالية الحاجة إليها، ولكن إذا كان المخدم عندك مشغولاً جداً ويُواجهُ مشاكلَ في الأداءِ، فقد تفضل تقليل هذه المدة الزمنية. القيم الأقل من 30 غير موصى بها لأن الإحصائيات قد لا تعمل بشكل صحيح.';
$string['configlookahead'] = 'أيام المستقبل التي سيُنظر إليها';
$string['configmailnewline'] = 'أحرف السطر الجديد المستعملة في رسائل البريد. يتطلب الأمر استعمال CRLF وفقًا لـ RFC 822bis، تقوم بعض خوادم البريد بالتحويل التلقائي من LF إلى CRLF، بينما تقوم خوادم البريد الأخرى بتحويل غير صحيح من CRLF إلى CRCRLF، ويرفض آخرون رسائل البريد ذات LF العارية (qmail على سبيل المثال). حاول تغيير هذا الإعداد إذا كنت تواجه مشاكل مع رسائل البريد الالكتروني غير المسلّمة أو الأسطرالجديدة المزدوجة.';
$string['configmaxbytes'] = 'هذا يُحدّدُ الحجم الأقصى للملفاتَ المرفوعة إلى الموقع. هذا الإعداد مقيد ببعض إعدادات الـ PHP في المخدم وهي: post_max_size و upload_max_filesize، فضلاً عن إعداد Apache المسمى LimitRequestBody. بدوره، يقوم الإعداد maxbytes بتحديد مدى حجوم الملفات التي يمكن الاختيار فيما بينها على مستوى المقرر أو النشاط. إذا تم اختيار "الحجم الأقصى للموقع"، فسيتم استعمال أقصى حجم لرفع الملفات الذي تسمح به إعدادات المخدم.';
$string['configmaxconsecutiveidentchars'] = 'كلمات المرور يجب أن لا تكون أكثر من هذا العدد من الأحرف المتطابقة المتتالية. استخدام 0 لتعطيل هذا الاختيار .';
$string['configmaxeditingtime'] = 'هذا يُحدّدُ الفترة الزمنية التي يمكن خلالها للمستخدمين تحرير منشورات المنتدى، قاموس المصطلحات، التعليقات... إلخ. في الغالب، تعتبر 30 دقيقة فترة زمنية جيدة.';
$string['configmaxevents'] = 'أحداث المستقبل التي سيُنظر إليها';
$string['configmaxusersperpage'] = 'العدد الأقصى من المستخدمين المعروضين في صفحات المقررات الدراسية، المجموعات، الفِرَق، خدمات الويب... إلخ.';
$string['configmessaging'] = 'في حالة التمكين ، يمكن للمستخدمين إرسال رسائل إلى مستخدمين آخرين على الموقع.';
$string['configmessagingallowemailoverride'] = 'إسمح للمستخدمين باختيار استلام إشعارات الرسائل عبر بريد الكتروني مختلف عن العنوان البريدي الموجود في ملفهم الشخصي.';
$string['configmessagingallusers'] = 'في حالة التمكين، يمكن للمستخدمين معاينة قائمة بكل المستخدمين في الموقع عند اختيار شخص ما لمراسلته، وستتضمن تفضيلات المراسلة خيار قبول الرسائل من أي شخص في الموقع. إذا تم تعطيله، يمكن فقط للمستخدمين معاينة قائمة المستخدمين في مقرراتهم، مع خيارين فقط في تفضيلات المراسلة، هما - قبول الرسائل من جهات اتصالهم فقط، أو جهات اتصالهم وأي شخص في مقرراتهم.';
$string['configmessagingdefaultpressenter'] = 'ما إذا كان ينبغي تمكين \'استعمال مفتاح Enter للإرسال\' إفتراضياً في إعدادات المراسلة للمستخدمين.';
$string['configmessagingdeleteallnotificationsdelay'] = 'يمكن حذف الإشعارات المقروءة وغير المقروءة لتوفير المساحة. كم من الوقت يبقى الإشعار بعد إنشائه قبل حذفه؟';
$string['configmessagingdeletereadnotificationsdelay'] = 'يمكن حذف الإشعارات المقروءة لتوفير المساحة التخزينية. ما هي المدة المنقضية بعد قراءة الإشعار والتي يمكن عندها حذفه؟';
$string['configminpassworddigits'] = 'كلمات المرور يجب أن تحتوي على الأقل هذا العدد من الخانات.';
$string['configminpasswordlength'] = 'كلمات المرور يجب أن تحتوي على الأقل هذا العدد من الحروف .';
$string['configminpasswordlower'] = 'كلمات المرور يجب أن تحتوي على الأقل هذا العدد من الحروف الصغيرة .';
$string['configminpasswordnonalphanum'] = 'كلمات المرور يجب أن تحتوي على الأقل هذا العدد من الرموز .';
$string['configminpasswordupper'] = 'كلمات المرور يجب أن تحتوي على الأقل هذا العدد من الحروف الكبيرة .';
$string['configmypagelocked'] = 'يمنع هذا الإعداد من تحرير الصفحة الافتراضية  بواسطة غير المسؤولين';
$string['confignavcourselimit'] = 'يحدد عدد المقررات الدراسية المعروضة للمستخدم ضمن أدوات التنقل.';
$string['confignavshowallcourses'] = 'هذا الإعداد يقرر ما إذا كان المستخدمون المنضمون إلى مقررات قادرين على مشاهدة كل المقررات الدراسية (استعراض كل المقررات الدراسية) ضمن أدوات التنقل، فضلاً عن \'مقرراتي\' (استعراض مقرراتهم المنضمين إليها).';
$string['confignavshowcategories'] = 'أظهر تصنيفات المقررات الدراسية في شريط التنقل وكتل التنقل. هذا لا يحدث مع المقررات المنضم إليها المستخدم حالياً، فهي ستبقى مدرجة ضمن قائمة مقرراتي بدون التصنيفات.';
$string['confignoreplyaddress'] = 'قد يتم إرسال الرسائل البريدية أحياناً بالنيابة عَن المستخدم (كما في منشورات المنتديات مثلاً). عنوان البريد الإلكتروني الذي تحدده هنا سَيستعمل في خانة "مِنْ" في تلك الحالاتِ التي لا ينبغي فيها لمتلقي الرسائل أَنْ يَكُونوا قادرون على الإجابة مباشرة (كما هو الحال عندما يَختارُ المستخدم حجب عنوان بريده عن الآخرين). هذا الإعداد سيكون أيضاً بمثابة غلاف المُرسل في المراسلات.';
$string['confignotifyloginfailures'] = 'أرسل إشعارات بمحاولات الدخول الفاشلة في الموقع إلى هؤلاء المستخدمين. هذا يتطلب تمكين مخزون سجلات التوثيق ( مثلاً مخزن سجلات التوثيق القياسي).';
$string['confignotifyloginthreshold'] = 'إذا تم تمكين إشعارات محاولات الدخول الفاشلة، كم عدد محاولات الدخول الفاشلة للمستخدم الواحد أو العنوان الواحد تكفي للإشعار بها؟';
$string['confignotloggedinroleid'] = 'سيكون للمستخدمين الذين لم يتم تسجيل دخولهم إلى الموقع أن يعاملوا كما لو كان لديهم هذا الدور الممنوح لهم في سياق الموقع. الضيف هو غالبًا ما تريده هنا، ولكن قد ترغب في إنشاء أدوار تكون أقل أو أكثر تقييدًا. أمور مثل إنشاء المنشورات لا تزال تتطلب من المستخدم تسجيل الدخول بشكل صحيح.';
$string['configopentowebcrawlers'] = 'إذا قمت بتمكين هذا الإعداد، سَتتمكن محركات البحث من الدُخُول إلى موقعِكَ كضيف. فضلاً عن ذلك، سيتم اعتبار الزائرين القادمين إلى موقعك عبر محركات البحث ضيوفاً بشكل تلقائي. لاحظْ بِأَنَّ هذا فقط يُسهل العثور على المقررات الدراسية التي تم السماح فيها بوصول الضيوف.';
$string['configoverride'] = 'تم تعريفة في ملف config.php';
$string['configpasswordpolicy'] = 'إذا تم تمكينه، سيتم التحقق من مدى مطابقة كلمات مرور المستخدمين لسياسة وضع كلمات المرور المحددة أدناه. تمكين سياسة وضع كلمات المرور لن يؤثر على المستخدمين الحاليين، حتى يبادروا أو يُجبروا على تغيير كلمات مرورهم، أو إذا تم تمكين الإعداد "فحص كلمة المرور عند الدخول" في الموقع.';
$string['configpasswordpolicycheckonlogin'] = 'إذا تم تمكينه، سيتم التحقق من مدى مطابقة كلمات مرور المستخدمين لسياسة وضع كلمات المرور كلما حاولوا دخول الموقع. إذا تبين أن كلمة المرور مخالفة لتلك السياسة، سيُطلب من المستخدم تغيير كلمة مروره قبل المتابعة. من المفيد تمكين هذا الإعداد بعد تغيير سياسة وضع كلمات المرور.';
$string['configpasswordresettime'] = 'يحدد هذا مقدار الوقت الذي يتعين على الأشخاص التحقق من صحة طلب إعادة تعيين كلمة المرور قبل انتهاء صلاحيته. عادة 30 دقيقة هي قيمة جيدة.';
$string['configpathtodu'] = 'المسار إلى du. ربما هو شيء مشابه لـ /usr/bin/du. لو أدخلته، سيسرع ذلك كثيراً عرض الصفحات التي تظهر محتويات المجلدات وبخاصة المجلدات التي تحتوي على ملفات كثيرة.';
$string['configpathtophp'] = 'المسار إلى واجهة سطر الأوامر لـ PHP. ربما شيء مثل /usr/bin/php. إذا قمت بإدخال هذ ، يمكن تنفيذ نصوص أوامر مشغل الوظائف الدورية من واجهة الويب الخاصة بالمسؤول.';
$string['configperfdebug'] = 'إذا قمتَ بتمكينه، ستتم طباعة معلومات الأداء في تذييل صفحة القالب القياسي';
$string['configprofileroles'] = 'الأدوار التي تُدرج في الملف الشخصي للمستخدم وصفحة المشاركين.';
$string['configprofilesforenrolledusersonly'] = 'لمنع سوء الاستعمال من قبل المزعجين، يتم إخفاء وصف الملف الشخصي للمستخدمين الذين لم ينضموا بعد لأيّ مقرر. يجب على المستخدمين الجدد الانضمام إلى مقرر واحد على الأقل قبل أن يتمكنوا من إضافة وصف الملف الشخصي.';
$string['configprotectusernames'] = 'إذا تم تمكينه، فإن نموذج استعادة كلمة المرور لن يقدم للمستخدم أي تلميحات من شأنها أن تجعل أسماء دخول المستخدمين أو عناوينهم الالكترونية قابلة للتخمين.';
$string['configproxybypass'] = 'قائمة بأسماء المضيفين (جزئياً) أو عناوين IP التي يجب عليها تجاوز الوكيل. إفصل ما بين العناصر بفوارز إنجليزية، بدون فراغات. على سبيل المثال: 192.168.0.0/16،*.mydomain.com.';
$string['configproxyfixunsafe_help'] = 'هذا يحاول إصلاح النداءات الداخلية التي لا تمر من خلال الوكيل عبر إضافة عميل المستخدم MoodleBot واستعمال الوكيل.';
$string['configproxyhost'] = 'إذا كان هذا <b>المخدم</b> يَحتاجُ اسْتِعْمال وكيل (كما في برنامج الجدار الناري) لدُخُول الإنترنتِ، ضع اسمَ المضيف الوكيل ورقم المنفذ هنا. عدا ذلك أتركُه فارغاً.';
$string['configproxylogunsafe_help'] = 'هذا يحاول توثيق النداءات الداخلية التي لا تمر من خلال الوكيل رغم أن عليها ذلك.';
$string['configproxypassword'] = 'تحتاج كلمة المرور للوصول إلى الإنترنت من خلال الوكيل إذا لزم الأمر، فارغة إذا لا يوجد (الامتداد PHP cURL مطلوب ).';
$string['configproxyport'] = 'إذا كان يحتاج هذا المخدم استعمال حاسوب وكيل، ضع منفذه هنا.';
$string['configproxytype'] = 'نوع وكيل الإنترنت (PHP5 وامتداد cURL مطلوبان لدعم SOCKS5).';
$string['configproxyuser'] = 'تحتاج اسم المستخدم للوصول إلى الإنترنت من خلال الوكيل إذا كانت مطلوبة ، فارغة إذا لا يوجد (الامتداد PHP cURL  مطلوب ) .';
$string['configrecaptchaprivatekey'] = 'سلسلة من الأحرف (مفتاح سري) تستعمل للاتصال بين مخدم مودل الخاص بك ومخدم اختبار reCAPTCHA. يمكن الحصول على مفاتيح ReCAPTCHA من خلال زيارة <a target="_blank" href="https://www.google.com/recaptcha">Google reCAPTCHA</a>.';
$string['configrecaptchapublickey'] = 'سلسلة من الأحرف (مفتاح الموقع) تستعمل لعرض عنصر اختبار reCAPTCHA في نموذج التسجيل ونموذج الدعم الفني للموقع. مفاتيح ReCAPTCHA يمكن الحصول عليها من <a target="_blank" href="https://www.google.com/recaptcha">Google reCAPTCHA</a>.';
$string['configrequestedstudentname'] = 'كلمة للطالب يستخدمها في طلب المقررات الدراسية';
$string['configrequestedstudentsname'] = 'كلمة للطلاب يستخدمونها في طلبهم المقررات الدراسية';
$string['configrequestedteachername'] = 'كلمة للمعلم يستخدمها في طلب المقررات الدراسية';
$string['configrequestedteachersname'] = 'كلمة للمعلمين يستخدمونها في طلبهم المقررات الدراسية';
$string['configreverseproxyignore'] = 'إذا كان مخدمك يعمل خلف عدة ملقمات وكيلة عكسية (reverse proxies) والتي تقوم بإلحاق رؤوس كشف عناوين IP الفعلية، أو ما يعرف بـ (X-Forwarded-For header)، فعليك وضع قائمة عناوين IP لتلك الملقمات الوكيلة أو شبكاتها الفرعية، مفصولاً بينها بفارزة ليتم تجاهلها بغرض معرفة عنوان IP الفعلي لزوار الموقع.';
$string['configsectioninterface'] = 'الواجهة';
$string['configsectionmail'] = 'البريد';
$string['configsectionmaintenance'] = 'الصيانة';
$string['configsectionmisc'] = 'متنوع';
$string['configsectionoperatingsystem'] = 'نظام التشغيل';
$string['configsectionpermissions'] = 'الصلاحيات';
$string['configsectionrequestedcourse'] = 'طلبات المقرر';
$string['configsectionsecurity'] = 'الأمان';
$string['configsectionstats'] = 'الإحصائيات';
$string['configsectionuser'] = 'المستخدم';
$string['configsecureforms'] = 'يستطيع مودل استعمال مستوى أمان إضافي عند قبول البيانات مِنْ من نماذج الويب. لو تم تمكين هذا، سيتم فحص متغير HTTP_REFERER للمتصفّح إزاء عنوان رابط النموذج الحالي. في حالات قليلة جداً قد يسبب هذا بعض المشاكل إذا كان المستخدم  مستعملاً لبرنامج جدار ناري (مثل Zonealarm) معد لتَعْرِية HTTP_REFERER مِنْ حركة مروره على الويب. من أعراض ذلك \'التوقف\' عند النموذج. إذا كان المستخدمون عندك يواجهون مشكلة مع صفحة الدخول إلى الموقع (على سبيل المثال)، فقَدْ ترغب في تعطيل هذا الإعداد، ولكن من الممكن ان يَتْرك ذلك موقعَكَ معرضاً إلى هجماتِ القوة الغاشمة التي تستهدف العثور على كلمةِ المرور. لو كنت في شك، قم باختيار \'نعم\' في هذا الإعداد';
$string['configservicespage'] = 'أدخل عنوان الرابط المؤدي إلى صفحة الخدمات والدعم أو أتركه فارغًا ليرتبط بخدمات مودل في moodle.com. الرابط يُعرض فقط لمشرفي الموقع.';
$string['configsessioncookie'] = 'هذا الإعداد يخصص تسمية ملف تعريف الارتباط المستعمل في جلساتِ مودل. هذا إختياري، ومفيد فقط لتفادي اختلاط ملفات تعريف الارتباط عندما تكون هناك أكثر من نسخة من مودل في موقع واحد.';
$string['configsessioncookiedomain'] = 'هذا يسمح لك بتغيير المجال الذي يوفر ملفات تعريف الارتباط لمودل. وهذا مفيد لتخصيص مودل (مثل إضافات المصادقة أو الانضمام) التي تحتاج إلى مشاركة معلومات جلسة عمل مودل مع تطبيق ويب آخر على مجال فرعي. <strong> تحذير: من المستحسن بشدة أن يترك هذا الإعداد افتراضياً (فارغ) - أي قيمة غير صحيحة سوف تمنع جميع تسجيلات الدخول إلى الموقع.</strong>';
$string['configsessioncookiepath'] = 'إذا أردت تغيير الموضع الذي ترسِلُ إليه المتصفحات ملفات تعريف الارتباط العائدة لمودل، يمكنك تغيير هذا الإعداد لتحديد مجلد فرعي خاص بموقعك. عدا ذلك، الإعداد الافتراضي \'/\' سيعمل بشكل صحيح.';
$string['configsessiontimeout'] = 'سيتم إخراج المستخدمين من الموقع تلقائياً في حالة بقائهم فترة زمنية طويلة دون القيام بإي تفاعل مع الموقع (بدون تحميل صفحاتِ) وتكون (جلساتهم قد انتهت). هذا المتغيّرِ يحدد طول تلك الفترة الزمنية.';
$string['configsessiontimeoutwarning'] = 'إذا كان الأشخاص المتواجدون في الموقع غير نشطين لمدة طويلة (بدون تحميل الصفحات) عندها سيتم تنبيههم بأن جلستهم على وشك الانتهاء. هذا المتغير يحدد مقدار ما ينبغي أن يكون عليه هذا الوقت.';
$string['configsessiontimeoutwarningcheck'] = 'تنبيه نفاد الوقت ينبغي أن يكون أقل من فترة انتهاء الجلسة';
$string['configshowcommentscount'] = 'أظهر عدد التعليقات، سيكلف ذلك عملية استدعاء إضافية عند عرض روابط التعليقات';
$string['configshowicalsource'] = 'أظهر مصدر المعلومة لأحداث iCal';
$string['configshowsiteparticipantslist'] = 'سيتم سرد كل من طلاب الموقع ومعلمي الموقع على لائحة المشاركين فيه. من الذين يجب أن يسمح لهم برؤية هذه القائمة؟';
$string['configsitedefaultlicense'] = 'الرخصة الافتراضية للموقع';
$string['configsitedefaultlicensehelp'] = 'الرخصة الافتراضية لنشر المحتوى في هذا الموقع';
$string['configsitemailcharset'] = 'يحدد هذا الإعداد مجموعة الأحرف الافتراضية لجميع رسائل البريد الإلكتروني المرسلة من الموقع.';
$string['configsitemaxcategorydepth'] = 'العمق الأقصى للتصنيف';
$string['configsitemaxcategorydepthhelp'] = 'يحدد هذا أقصى عمق للتصنيفات الفرعية التي يتم توسيعها عند عرض التصنيفات أو القائمة المنسدلة. ستظهر التصنيفات ذات المستويات الأعمق كروابط، ويمكن للمستخدم توسيعها بطلب يعمل بنصوص برمجية من AJAX.';
$string['configslasharguments'] = 'تسمية "العوامل ذات رمز (\\)" (باستعمال <em>PATH_INFO</em>) المطلوبة عند استعمال حزم سكورم والموارد الأخرى متعددة الملفات لكي يتم عرضها بالشكل الصحيح. إن كان مخدم الويب لديك لا يدعم "العوامل ذات رمز (\\)" ويتعذر عليك تهيئته لدعمها، يمكن تعطيل هذا الإعداد، مع أن ذلك قد يؤدي إلى جعل بعض الإجراءات متعذرة عن التشغيل.<br /> ملاحظة: إن استعمال "العوامل ذات رمز (\\)" سيكون مطلوباً حتماً مع الإصدارات المستقبلية من مودل.';
$string['configsmtpauthtype'] = 'هذا يعين نوع المصادقة لاستعماله مع مخدم SMTP.';
$string['configsmtphosts'] = 'أعط الاسم الكامل لمخدم (SMTP) محلي أو أكثر ليقوم مودل باستعماله لإرسال البريد (مثلاً: \'mail.a.com\' أو \'mail.a.com;mail.b.com\'). لتحديد منفذ مغاير للافتراضي (أي غير المنفذ 25)، يمكنك استعمال الصيغة  [server]:[port] (مثلاً: \'mail.a.com:587\'). يستخدم المنفذ 465 عادة مع SSL للاتصالات الآمنة، يستخدم المنفذ 587 عادة مع TLS. حدد برتوكول الأمان في الأسفل عند الحاجة. إذا تركته فارغاً، سيقوم مودل باستعمال طريقة PHP الافتراضية لإرسال البريد.';
$string['configsmtpmaxbulk'] = 'الحد الأقصى لعدد الرسائل المرسلة لكل جلسة SMTP. تجميع الرسائل قد تسرع إرسال رسائل البريد الإلكتروني. القيم الأقل من 2 تفرض إنشاء جلسة SMTP جديدة لكل بريد إلكتروني.';
$string['configsmtpoauthservice'] = 'إختر خدمة OAuth 2 المهيئة للتخاطب مع مخدم SMTP. إذا لم تكن الخدمة موجودة بعد فستحتاج إلى إنشائها. لاحظ بأن عليك ضبط نوع المصادقة في SMTP إلى XOAUTH2.';
$string['configsmtpsecure'] = 'إذا كان خادم SMTP يتطلب اتصالاً آمنًا ، فحدد نوع البروتوكول الصحيح.';
$string['configsmtpuser'] = 'إذا حددت مخدم SMTP أعلاه، وكان المخدم يتطلب المصادقة، فأدخل اسم المستخدم وكلمة المرور هنا.';
$string['configstartwday'] = 'بداية الأسبوع';
$string['configstatsfirstrun'] = 'هذا يحدد المدى الذي ينبغي الرجوع إليه في الماضية لمعالجة سجلات الوقوعات عند <b>المرة الأولى</b> التي يريد فيها مشغل المهام المجدولة مُعَالَجَة الإحصائياتِ. إذا كان موقعك يتعرض إلى حركة طلب عالية وهو يتشارك الاستضافة مع مواقع أخرى، ربما من الأفضل عدم العودة إلى الماضي كثيراً، لأن استخلاص الإحصائيات قد يستغرق وقتاً طويلاً ويكون مستنزفاً للموارد. (لاحظ أنه في هذا الإعداد، 1 شهر = 28 يوم. في الرسوم البيانية والتقاريرِ، 1 شهر = 1 شهر حسب التقويم).';
$string['configstatsmaxruntime'] = 'معالجة الإحصائيات يُمكنُ أَنْ يكُونَ أمراً ثقيلاً جدًا، لذا قم باستعمال هذا الحقل والحقل التالي لتَحديد متى ولأيّ فترة زمنية سيتم تشغيلها.';
$string['configstatsmaxruntime2'] = 'يمكن أن تكون معالجة الإحصائيات مكثفة للغاية ، حدد الوقت الأقصى المسموح به للجمع في يوم إحصائي واحد . الحد الأقصى لعدد أيام المعالجة في تنفيذ دوري واحد هو 31.';
$string['configstatsmaxruntime3'] = 'تحديد الحد الأقصى للوقت المسموح به لحساب إحصاءات اليوم الواحد ، مع الأخذ في الاعتبار أن معالجة الإحصاءات يمكن أن تضع حملا كبيرا على الخادم . الحد الأقصى لعدد أيام المعالجة في دوري واحد أدناه يمكن تحديدها أسفل .';
$string['configstatsruntimedays'] = 'هذا يحدد الحد الأقصى لعدد الأيام التي تتم معالجتها عند كل تنفيذ للإحصائيات. عندما تصير الإحصائيات كاملة التحديث، ستتم معالجة يوم واحد فقط، لذلك قم بضبط تلك القيمة حسب حمل المخدم الخاص بك، وقم بتقليلها إن كانت هناك حاجة إلى فترات تنفيذ أقصر من جانب مشغل الوظائف الدورية.';
$string['configstatsruntimestart'] = 'متي يجب على المهمة المجدولة المتعلقة بمعالجة الإحصائياتِ أن تبدأ؟ تحديد أوقات مختلفة أمر موصى به إن كان هناك عدة مواقع لمودل على مخدم واحد.';
$string['configstatsuserthreshold'] = 'هذا الإعداد يحدد أقل عدد من المستخدمين المنضمين إلى المقرر ليتم شموله في حسابات الإحصائيات.';
$string['configstrictformsrequired'] = 'إذا تم تمكينه، يتم منع المستخدمين من إدخال مسافة أو فاصل أسطر فقط في الحقول المطلوبة في النماذج.';
$string['configstripalltitletags'] = 'قم بإلغاء تحديد هذا الإعداد للسماح بوسوم HTML في أسماء النشاطات والموارد .';
$string['configsupportavailability'] = 'يحدد من بإمكانته الوصول إلى جهات اتصال الدعم الفني من تذييل الصفحة';
$string['configsupportemail'] = 'إذا تمت تهيئة بروتوكول SMTP في هذا الموقع ولم تتم تهيئة صفحة الدعم الفني، فعنوان البريد الالكتروني هذا سيتلقى الرسائل المقدمة من خلال نموذج الدعم. إذا فشلت تلك المراسلة، سيتم عرض عنوان البريد الالكتروني للمستخدمين المسجلين لدخولهم.';
$string['configsupportname'] = 'اسم الشخص أو الكيان الذي يوفر المساعدة العامة عن طريق نموذج المساعدة أو صفحة المساعدة.';
$string['configsupportpage'] = 'أدخل الرابط المؤدي إلى صفحة دعم الموقع أو أتركه فارغاً ليرتبط بنموذج المراسلة. يتم عرض الرابط في تذييل الموقع.';
$string['configtempdatafoldercleanup'] = 'إزالة ملفات البيانات المؤقتة من مجلد البيانات الأقدم من الوقت المحدد.';
$string['configthemedesignermode'] = 'عادة كل صور القالب وأوراق الأنماط يتم تخزينها مؤقتا في المتصفحات وفي المخدم فترة طويلة جدًا، لأداء أفضل. إذا كنت تصمم القوالب أو تطور البرمجة فربما ترغب في تمكينه لكي لا تحصل على الإصدارات المخبأة. تحذير: هذا سيجعل موقعك أبطأ لجميع المستخدمين! بدلاً من ذلك، يمكنك أيضًا إعادة تعيين مخبوءات القالب يدويًا من صفحة اختيار المظهر.';
$string['configthemelist'] = 'أتركْ هذا فارغاً للسَماح باستعمال أيّ قالب صالح. إذا كنت تُريدُ تَقصير قائمةِ القوالب، يُمْكِنُك أَنْ تُحدّدَ قائمة منها عبر إدخال قيم مفصولة بفوارز من أسمائها هنا (لا تستعمل الفراغاتَ!).
على سبيل المثال: standard,orangewhite.';
$string['configtimezone'] = 'هذه هي المنطقة الزمنية الافتراضية لعرض التواريخ. يستطيع كل مستخدم تجاوز هذا الإعداد في صفحة ملفه الشخصي. المهام المجدولة وغيرها من إعدادات المخدم ستُبنى توقيتاتها على أساس المنطقة الزمنية هذه. ينبغي عليك تعديلها إن كانت تظهر بشكل "منطقة زمنية غير صحيحة".';
$string['configuseblogassociations'] = 'هل ينبغي أن يكون المستخدمون قادرين على تنظيم مدوناتهم من خلال ربط مدخلاتها مع المقررات الدراسية ووحدات المقررات الدراسية؟';
$string['configusesitenameforsitepages'] = 'عند تمكينه، سيتم استعمال الاسم المختصر للموقع في عقدة صفحات الموقع التي في التنقل بدلاً من عبارة \'صفحات الموقع\'.';
$string['configusetags'] = 'هل ينبغي تمكين وظيفة الوسوم في عموم الموقع؟';
$string['configvariables'] = 'متغيرات';
$string['configverifychangedemail'] = 'تمكّن التحقق من عناوين البريد الالكتروني المتغيرة باستعمال إعدادات مجالات البريد الالكتروني المسموح بها والمرفوضة. إذا تم تعطيل هذا الإعداد، يتم فرض المجالات فقط عند إنشاء مستخدمين جدد.';
$string['configvisiblecourses'] = 'اعرض المقررات الدراسية في التصنيفات المخفية بشكل طبيعي';
$string['configwarning'] = 'كن حذرا عند تعديل هذه الإعدادات - القيم الغريبة قد تسبب مشاكل.';
$string['configyuicomboloading'] = 'هذه الخيارات تُمَكن الجمع بين تحميل الملفات الأمثل لمكتبات YUI. وينبغي تمكين هذا الإعداد في مواقع الإنتاج لأسباب تتعلق بالأداء.';
$string['confirmation'] = 'تأكيد الحساب';
$string['confirmationpending'] = 'بانتظار التأكيد';
$string['confirmcontextlock'] = '{$a->contextname} غير مجمد حاليًا. تجميده سيجعله للقراءة فقط ويمنع المستخدمين من إجراء التغييرات. هل أنت متأكد أنك تريد المتابعة؟';
$string['confirmcontextunlock'] = '{$a->contextname} مجمد حاليًا. إلغاء التجميد سيسمح للمستخدمين بإجراء تغييرات. هل أنت متأكد أنك تريد المتابعة؟';
$string['confirmdeletecomments'] = 'هل أنت متأكد من رغبتك في حذف التعليقات المحددة؟';
$string['confirmed'] = 'الحساب مؤكَّد';
$string['contactsitesupport'] = 'الاتصال مع دعم الموقع';
$string['contenttypeuninstalling'] = 'هناك {$a->count} من المحتويات المدعومة من قبل {$a->type}. سيتم حذفها جميعاً. هل أنت متأكد من رغبتك في المتابعة؟';
$string['contextlockappliestoadmin'] = 'ينطبق تجميد السياق على المسؤولين';
$string['contextlockappliestoadmin_desc'] = 'في حالة التعطيل ، يظل المسؤولون لديهم حق الوصول للكتابة إلى أيّ سياقات مجمدة.';
$string['contextlocking'] = 'تجميد السياق';
$string['contextlocking_desc'] = 'يتيح هذا الإعداد إمكانية منح الوصول للقراءة فقط لبعض التصنيفات، المقررات الدراسية، الأنشطة، أو الكتل وفقاً لما يتم تحديده منها.';
$string['cookiesecure'] = 'ملفات تعريف الارتباط الآمنة فقط';
$string['country'] = 'البلد الافتراضي';
$string['course_customfield'] = 'تخصيص حقول المقررات الدراسية';
$string['coursecolor'] = 'اللون {$a}';
$string['coursecolorheading_desc'] = 'يتم عرض المساقات التي لم توضع لها صورة في إعداداتها ستُعرض بشكل بطاقة منقوشة في صفحة مساقاتي. يمكن تحديد الألوان المستعملة في النقشة مما في أدناه.';
$string['coursecolorsettings'] = 'ألوان بطاقة المقرر';
$string['coursecontact'] = 'عناوين الاتصال للمقرر الدراسي';
$string['coursecontact_desc'] = 'هذا الإعداد يَسْمحُ لك بالسَيْطَرَة على مَنْ يظْهرُ في وصف المقرر. ينبغي للمستخدمين أَنْ يَكُونَ عِنْدَهُمْ على الأقل أحد هذه الأدوارِ في المقرر ليتم إظهارهم في وصف ذلك المقرر.';
$string['coursecontactduplicates'] = 'عرض جميع أدوار الاتصال بالمقرر';
$string['coursecontactduplicates_desc'] = 'في حالة التمكين، سيتم عرض المستخدمين الذين لديهم أكثر من دور من أدوار جهات اتصال بالمقرر في وصف المقرر مع كل دور من أدوارهم. وإلا، سيتم عرضهم مع دور واحد فقط (أيها أعلى في \'تحديد الأدوار\' في إدارة الموقع).';
$string['coursecreationguide'] = 'رابط دليل إنشاء المقرر في مودل';
$string['coursecreationguide_help'] = 'يُعرِّف المسار المؤدي إلى دليل البدء السريع الذي يحتوي على أفلام قصيرة وتلميحات عامة لإنشاء المقررات. يُعرض رابط الدليل في صفحة مودل الخاصة بي عندما لا يكون هناك مقررات لعرضها. فقط المستخدمون الذين لديهم إمكانية إنشاء المقررات سيشاهدون الرابط.';
$string['coursegraceperiodafter'] = 'فترة السماح للمقررات الدراسية المنتهية';
$string['coursegraceperiodbefore'] = 'فترة السماح للمقررات الدراسية المستقبلية';
$string['courselistshortnames'] = 'عرض أسماء المقرر المطولة';
$string['courselistshortnames_desc'] = 'عند التمكين، سيتم عرض الأسماء المختصرة للمقررات الدراسية بالإضافة إلى أسمائها الكاملة في قوائم المقررات. إذا لزم الأمر، يمكن تخصيص الأسماء الموسعة للمقررات الدراسية عن طريق تحرير سلسلة اللغة \'courseextendedamedisplay\' باستعمال ميزة تخصيص اللغة.';
$string['coursemgmt'] = 'إدارة المقررات الدراسية والتصنيفات';
$string['courseoverview'] = 'نظرة عامة عن المقرر';
$string['courserequestnotify'] = 'إشعار طلب المقرر';
$string['courserequestnotifyemail'] = 'المستخدم {$a->user} قام بطلب مساق جديد عند <a href="{$a->link}">{$a->link}</a>.';
$string['courserequests'] = 'طلبات على مقررات دراسية';
$string['courserequestspending'] = 'طلبات معلّقة لمقرر';
$string['courses'] = 'المقررات الدراسية';
$string['coursesperpage'] = 'عدد المقررات في الصفحة الواحدة';
$string['courseswithsummarieslimit'] = 'مُحدد عدد المقررات ذات الملخص';
$string['creatornewroleid'] = 'دور منشئي المقررات الدراسية في الجديد منها';
$string['creatornewroleid_help'] = 'إذا كان المستخدم لا يملك مسبقًا صلاحية إدارة المقرر الجديد، فالمستخدم يتم ضمه تلقائيًا بهذا الدور.';
$string['cron'] = 'مشغل الوظائف الدورية';
$string['cron_enabled'] = 'تمكين مشغل الوظائف الدورية';
$string['cron_enabled_desc'] = 'بشكل طبيعي، ينبغي تمكين مشغل الوظائف الدورية، مع ذلك، هذا الإعداد يسمح بتعطيله مؤقتاً، كما هو الحال قبل إعادة تشغيل المخدم. إذا جرى تعطيله، سيتم منع النظام من الشروع بمهام جديدة في الخلفية. لاحظ أنه لا ينبغي إبقاؤه معطلاً لمدة طويلة، لأن ذلك سيمنع وظائف هامة من العمل.';
$string['cron_help'] = 'يقوم النص البرنامجي cron.php بتشغيل عدد من المهام عند فترات زمنية مجدولة مختلفة، مثل إرسال إشعارات البريد الالكتروني بشأن منشورات المنتدى. ينبغي تشغيل هذا النص بانتظام - من الناحية المثالية كل دقيقة.';
$string['cron_keepalive'] = 'الإبقاء منشغلاً';
$string['cron_keepalive_desc'] = 'مدة الاستمرار في طلب المهام الإضافية. هذا الإعداد مفيد لضمان استمرارية تشغيل الوظائف الدورية. إذا كنت تستعمل مشغلات مهام متفرغة فعليك ضبط هذه القيمة إلى 0، بخلاف ذلك، ننصح بضبطه إلى قيمة تتماثل مع حد تتابع مهامك المخصصة. ينبغي تجنب القيم الأكبر من ذلك، وإن القيمة القصوى هي 15 دقيقة.';
$string['cron_link'] = 'admin/cron';
$string['cronclionly'] = 'تنفيذ مشغل الوظائف الدورية من خلال سطر الأوامر فقط';
$string['cronerrorclionly'] = 'عذراً،  لقد تم منع الوصول لهذه الصفحة من قبل مدير الموقع .';
$string['cronerrorpassword'] = 'عذرًا، أنت لم تقدّم كلمة مرور صالحة لدخول هذه الصفحة';
$string['croninfrequent'] = 'هناك توقف مقداره {$a->actual} ما بين آخر تنفيذين لمهمة الصيانة التي يقوم بها مشغل الوظائف الدورية، في حين أنه لا بد من تنفيذها كل {$a->expected}. نوصي بتهيئتها لتصير قابلة للتنفيذ بوتيرة أعلى.';
$string['cronremotepassword'] = 'كلمة مرور مشغل الوظائف الدورية للدخول عن بُعد';
$string['cronwarning'] = 'إن <a href="{$a->url}">admin/cron.php script</a> لم يتم تشغيله منذ {$a->actual} بينما ينبغي له أن يعمل كل {$a->expected}.';
$string['cronwarningcli'] = 'إن النص البرمجي <code>admin/cli/cron.php</code> لم يتم تنفيذه منذ {$a->actual} بينما ينبغي له أن يُنفذ كل {$a->expected}.';
$string['cronwarningnever'] = 'إن النص البرمجي <code>admin/cli/cron.php</code> لم يتم تنفيذه إطلاقاً في حين أنه لا بد من تنفيذه كل {$a->expected}.';
$string['cronwarningneverweb'] = 'إن طلب الرابط <a href="{$a->url}">admin/cron.php script</a> لم يتم تمريره إطلاقاً في حين أنه لا بد من طلبه كل {$a->expected}.';
$string['ctyperequired'] = 'الامتداد ctype PHP مطلوب الآن من مودل، من أجل تحسين أداء الموقع وتقديم التوافق لتعدد اللغات.';
$string['curlcache'] = 'مهلة خبء cURL';
$string['curlrequired'] = 'الامتداد cURL PHP مطلوب الآن من مودل، من أجل التواصل مع مستودعات مودل.';
$string['curlsecurityallowedport'] = 'منافذ cURL المسموح بها';
$string['curlsecurityallowedportsyntax'] = 'قائمة بأرقام المنافذ التي يمكن لـ cURL الاتصال بها. الإدخالات الصالحة هي أرقام صحيحة فقط. ضع كل إدخال في سطر جديد. إذا تركته فارغاً، فكل المنافذ مسموح بها. في حالة ضبطه، في جميع الحالات تقريباً، ينبغي تحديد كل من 443 و 80 لـ CURL للاتصال بمنافذ HTTPS و HTTP القياسية.';
$string['curlsecurityblockedhosts'] = 'قائمة cURL للمضيفين المحظورين';
$string['curlsecurityblockedhostssyntax'] = 'ضع كل إدخال في سطر جديد. الإدخالات الصالحة هي إما عناوين IPv4 أو IPv6 كاملة (مثل 192.168.10.1 و 0:0:0:0:0:0:0:1, ::1, fe80::) والتي تتطابق مع مضيف واحد؛ أو رمز CIDR (مثل 231.54.211.0/20 أو fe80::/64)؛ أو مجموعة من عناوين IP (مثل 231.3.56.10-20 أو fe80::1111-bbbb) حيث ينطبق النطاق على المجموعة الأخيرة من العنوان؛ أو أسماء النطاقات (مثل localhost أو example.com)؛ أو أسماء نطاقات ذات الرمز البديل (مثل *.example.com أو *.sub.example.com). السطور الفارغة غير مسموح بها.';
$string['curlsecurityurlblocked'] = 'تم حظر عنوان URL.';
$string['curltimeoutkbitrate'] = 'معدل البت لاستخدامه عند حساب مهلة cURL (كيلوبت في الثانية)';
$string['curltimeoutkbitrate_help'] = 'يستخدم هذا الإعداد لحساب مهلة مناسبة أثناء طلبات cURL الكبيرة. كجزء من هذا الحساب ، يتم تقديم طلب HTTP HEAD لتحديد حجم المحتوى. يؤدي تعيين هذا إلى 0 إلى تعطيل هذا الطلب.';
$string['currenttheme'] = 'القالب الحالي';
$string['customcheck'] = 'عمليات التحقق الأخرى';
$string['custommenu'] = 'قائمة مخصصة';
$string['custommenuitems'] = 'عناصر القائمة المخصصة';
$string['customusermenuitems'] = 'بنود قائمة المستخدم';
$string['datarootsecurityerror'] = '<p><strong>تحذير أمني!</strong></p><p> المجلد الرئيسي للبيانات في موقع خاطئ ومكشوف على الويب. هذا يعني أن جميع الملفات الخاصة بك متاحة لأيّ شخص في العالم، وبعضها يمكن استعمالها من قبل المخترقين للحصول على حق الوصول الإداري غير المصرح به إلى موقعك!</p>
<p><em>يجب</em> عليك نقل المجلد الرئيسي ({$a}) إلى موضع جديد غير موجود ضمن مجلد الويب العام، وتحديث الإعداد <code>$CFG->dataroot</code> في الملف config.php وفقًا لذلك.</P>';
$string['datarootsecuritywarning'] = 'من المحتمل أن إعدادات موقعك غير آمنة. الرجاء التأكد من أن دليل البيانات الرئيسي ({$a}) لا يمكن الوصول إليه عن طريق الشبكة .';
$string['dbprefixtoolong'] = 'بادئة قاعدة بياناتك ($CFG->prefix) طويلة جدًا ({$a->current} من الحروف). أقصى عدد مسموح به من الحروف هو {$a->maximum}.';
$string['dbsessions'] = 'استعمل قاعدة البيانات لمعلومات الجلسة';
$string['debug'] = 'رسائل التصحيح';
$string['debugall'] = 'الكل : اعرض كافة رسائل PHP لتصحيح الأخطاء المعقولة';
$string['debugdeveloper'] = 'المطورون: المزيد من رسائل مودل التصحيحية للمطورين.';
$string['debugdisplay'] = 'عرض رسائل التصحيح';
$string['debugging'] = 'التصحيح';
$string['debugminimal'] = 'الأدنى : اظهر فقط الأخطاء الجسيمة';
$string['debugnone'] = 'لا شيء: لا تظهر أي من الأخطاء أو التحذيرات';
$string['debugnormal'] = 'عادي: أظهر الأخطاء، التحذيرات والملاحظات';
$string['debugpageinfo'] = 'إظهار صفحة المعلومات';
$string['debugsqltrace'] = 'إظهار أصول استدعاءات SQL';
$string['debugsqltrace1'] = 'أظهر سطر استدعاء واحد فقط';
$string['debugsqltrace100'] = 'أظهر متابع المكدس الكامل';
$string['debugsqltrace2'] = 'أظهر سطرين من متابع المكدس';
$string['debugsqltrace_desc'] = 'عند تمكينه، تتم إضافة جزء مقتطع من متابع مكدس PHP أو كله إلى نصوص SQL بمثابة تعليق.';
$string['debugstringids'] = 'إظهار أصول عبارات اللغات';
$string['debugstringids_desc'] = 'تم تصميم هذا الخيار لمساعدة المترجمين. عندم تمكينه، سيتم عرض مكونات جُمل اللغة ومعرفاتها في الصفحة إذا قمت بإلحاق أي من العبارتين الآتيتين بعنوان رابط الصفحة:
?strings=1
&strings=1';
$string['debugtemplateinfo'] = 'إظهار معلومات القالب';
$string['debugtemplateinfo_desc'] = 'عند تمكينه، سيتم إظهار القوالب المستعملة كتعليقات في HTML الخاص بالصفحة. بعد تغيير هذا الإعداد، عليك تطهير المخبوءات. استعملها في تحري الأخطاء البرمجية حصرًا، لأنها تولد أخطاء عند التحقق من صحة HTML للصفحة وقد تكسر تماسك النص  البرمجي لبعضها. قد تؤثر أيضًا على بعض الوظائف الأساسية!';
$string['debugvalidators'] = 'إظهار روابط المدقق';
$string['defaultcity'] = 'المدينة الافتراضية';
$string['defaultcity_help'] = 'المدينة المختارة هنا ستكون المدينة الافتراضية عند إنشاء حسابات المستخدمين الجدد.';
$string['defaultformatnotset'] = 'خطأ في تحديد تنسيق المقرر الافتراضي . الرجاء التحقق من إعدادات الموقع.';
$string['defaulthomepage'] = 'صفحة البدء للمستخدمين';
$string['defaultrequestcategory'] = 'التصنيف الافتراضي لطلبات المقررات الدراسية';
$string['defaultsettinginfo'] = 'الافتراضي: {$a}';
$string['defaultuserroleid'] = 'الدور الافتراضي لكل المستخدمين';
$string['deletedplugintypesdetected'] = 'تم اكتشاف ملحق محذوف \'{$a}\'. كان ينبغي أن يتم ترحيله/إلغاء تنصيبه خلال نافذة الإلغاء. حاليًا هو ملحق من نوع غير مدعوم ويتعذر إجراء التنصيب/الترقية حتى يتم إلغاء تنصيب ذلك الملحق.';
$string['deleteduserx'] = '{$a} للمستخدم المحذوف';
$string['deleteincompleteusers'] = 'احذف المستخدمين غير المكتملين بعد';
$string['deleteunconfirmed'] = 'إحذف المستخدمين الذين لم يُكملوا تسجيلهم بعد';
$string['deleteuser'] = 'احذف المستخدم';
$string['density'] = 'الكثافة';
$string['denyemailaddresses'] = 'نطاقات البريد الإلكتروني المرفوضة';
$string['development'] = 'التطوير';
$string['devicetype'] = 'نوع الجهاز';
$string['devlibdirpresent'] = 'يجب أن لا تكون المجلدات التي تحتوي على مكتبات التطوير، وخاصة <em>/vendor</em> و <em>/node_modules</em>، موجودة في المواقع العمومية. أنظر <a href="{$a->moreinfourl}">تقرير استعراض الأمان</a>لمزيد من التفاصيل.';
$string['disabled'] = 'معطل';
$string['disableplugin'] = 'تعطيل {$a}';
$string['disableuserimages'] = 'تعطيل صور الملف الشخصي للمستخدمين';
$string['displayerrorswarning'] = 'تمكين إعداد PHP <em> لعرض الأخطاء </em> لا ينصح به على مواقع الإنتاج بسبب أن بعض رسائل الخطأ قد تكشف عن معلومات حساسة عن الخادم الخاص بك .';
$string['displayloginfailures'] = 'عرض تسجيلات الدخول الفاشلة';
$string['divertallemails'] = 'تحويل البريد الالكتروني';
$string['divertallemailsdetail'] = 'يُستعمل كحماية في بيئات التطوير عند اختبار عناوين البريد الالكتروني ولا ينبغي استعماله في ظروف الإنتاج.';
$string['divertallemailsexcept'] = 'استثناءات تحويل البريد الالكتروني';
$string['divertallemailsexcept_desc'] = 'قائمة بقواعد استثناء البريد الالكتروني مفصولة إما بفوارز أو أسطر جديدة. كل قاعدة تتم ترجمتها بمثابة تعبير إعتيادي، مثلاً،
<pre>simone@acme.com
.*@acme.com
fred(\\+.*)?@acme.com
</pre>';
$string['divertallemailsto'] = 'تحويل كل رسائل البريد الالكتروني';
$string['divertallemailsto_desc'] = 'عند تحديده، سيتم تحويل كل رسائل البريد الالكتروني إلى هذا العنوان المنفرد بدلاً من ذلك.';
$string['dndallowtextandlinks'] = 'السحب والإفلات لرفع النصوص/الروابط';
$string['doclang'] = 'لغة المستندات';
$string['docroot'] = 'المجلد الجذري لتوثيقات مودل';
$string['doctonewwindow'] = 'إفتح في صفحة جديدة';
$string['doesnotfit'] = 'إعدادات عرض البريد الإلكتروني';
$string['doesnotfitdetail'] = 'عرض إعدادات البريد الالكتروني الذي يصدر عن مودل.';
$string['download'] = 'تنزيل';
$string['downloadcoursecontentallowed'] = 'ميزة تنزيل محتوى المقرر متاحة';
$string['downloadcoursecontentallowed_desc'] = 'فيما إذا كانت ميزة تنزيل محتويات المقررات الدراسية متاحة لها. عندما تكون متاحة، يمكن تمكين/تعطيل تنزيل محتويات المقرر باستعمال الإعداد "تمكين تنزيل محتوى المقرر" ضمن قائمة تحرير المقرر (القيمة الافتراضية لهذا يمكن تحديدها في <a href={$a} target="_blank">الإعدادات الافتراضية للمقرر الدراسي</a>).';
$string['durationunits'] = 'وحدات المدة';
$string['edithelpdocs'] = 'حرر مستندات المساعدة';
$string['editlang'] = '<b>حرّر</b>';
$string['editorbackgroundcolor'] = 'لون الخلفية';
$string['editordictionary'] = 'قاموس المحرر';
$string['editorfontfamily'] = 'عائلة الخط';
$string['editorfontlist'] = 'قائمة الخط';
$string['editorfontsize'] = 'حجم الخط';
$string['editorhidebuttons'] = 'الأزرار المخفية';
$string['editorkillword'] = 'مرشح تنسيق وورد';
$string['editorspelling'] = 'محرر الإملاء';
$string['editorspellinghelp'] = 'تمكين التدقيق الإملائي أو تعطيله. عند التمكين، <strong>aspell</strong> ينبغي أن يكون منصبًا في المخدم';
$string['editstrings'] = 'تحرير الكلمات أو العبارات';
$string['emailchangeconfirmation'] = 'تأكيد تغيير كلمة المرور عبر البريد الالكتروني';
$string['emaildkim'] = 'توقيع رسائل البريد المعرف بمفاتيح النطاق DKIM';
$string['emaildkiminfo'] = 'إذا تم ضبط منتقي DKIM وتم العثور على ملف الشهادة الشخصي وكلاهما يطابقان نطاق عنوان "من" في رسالة البريد الالكتروني في $CFG->dataroot/dkim/[domain]/[selector].private فعندها سيتم توقيع الرسالة. في أغلب الأحيان (مثلاً إذا كان الإعداد allowedemaildomains فارغاً)، فسيتطلب الأمر شهادة مفردة في: <code>{$a->path}</code>. لمزيد من تفاصيل التهيئة أنظر <a href="{$a->docs}">توثيقات البريد</a>.';
$string['emaildkimselector'] = 'منتقي DKIM';
$string['emailfromvia'] = 'معلومة مُرسل بواسطة';
$string['emailheaders'] = 'رؤوس عناوين الرسالة البريدية';
$string['emailsubjectprefix'] = 'نص بادئة موضوع البريد الإلكتروني';
$string['emoticonalt'] = 'النص البديل';
$string['emoticoncomponent'] = 'مُكون الصورة';
$string['emoticonimagename'] = 'اسم الصورة';
$string['emoticons'] = 'الرموز التعبيرية';
$string['emoticons_desc'] = 'يعرِّف هذا النموذج الرموز التعبيرية (أو الابتسامات) المستعملة في موقعك. لإزالة صف من الجدول، قم بحفظ النموذج مع قيمة فارغة في أيّ من الحقول المطلوبة. لتسجيل الرموز التعبيرية الجديدة، إملأ الحقول في الصف الفارغ الأخير. لإعادة تعيين كافة الحقول إلى القيم الافتراضية، اتبع الرابط أعلاه.

* النص (مطلوب) - سيتم استبدال هذا النص مع الصورة التعبيرية. ينبغي أن يكون من حرفين على الأقل.
* اسم الصورة (مطلوب) - اسم ملف الصورة التعبيرية بدون الامتداد، نسبة إلى مجلد صور العنصر.
* مُكون الصورة (مطلوب) - المكون المزود للرمز.
* النص البديل (إختياري) - مُعرّف النص ومُكون النص البديل للرموز التعبيرية.';
$string['emoticonsreset'] = 'إعادة تعيين إعدادات الرموز التعبيرية إلى الحالة الافتراضية';
$string['emoticontext'] = 'النص';
$string['emptysettingvalue'] = 'فارغ';
$string['enableanalytics'] = 'التحليلات';
$string['enableblogs'] = 'تمكين المدونات';
$string['enablecalendarexport'] = 'تمكين تصدير التقويم';
$string['enablecomments'] = 'تمكين التعليقات';
$string['enablecommunicationsubsystem'] = 'تمكين مزودي الاتصالات';
$string['enablecommunicationsubsystem_desc'] = 'يسمح بالتكامل مع مزودي الاتصالات مثل Matrix مما يسهل التواصل ما بين المعلمين والطلاب. يمكنك إدارة تلك التكاملات من <a href="settings.php?section=managecommunicationproviders">الملاحق</a>.';
$string['enablecourserelativedates'] = 'تمكين التواريخ المرتبطة بالمقرر';
$string['enablecourserelativedates_desc'] = 'السماح للمقررات الدراسية بأن يتم ضبطها لعرض التواريخ نسبة إلى تاريخ بدء المستخدم في المقرر.';
$string['enablecourserequests'] = 'تمكين طلب المقررات الدراسية';
$string['enabled'] = 'ممكّن';
$string['enabledashboard'] = 'تمكين لوحة التحكم';
$string['enabledashboard_help'] = 'لوحة التحكم تُظهر المخطط الزمني، التقويم والعناصر التي تم الوصول إليها مؤخرًا بشكل إفتراضي. يمكنك تعيين لوحة تحكم إفتراضية مختلفة لكل شخص والسماح للمستخدمين بتخصيص لوحات التحكم الخاصة بهم. عند تعطيله، ستحتاج إلى ضبط الإعداد \'صفحة البدء للمستخدمين\' إلى قيمة أخرى غير لوحة التحكم.';
$string['enableglobalsearch'] = 'تمكين البحث العمومي';
$string['enableglobalsearch_desc'] = 'عند التمكين، ستتم فهرسة البيانات ومزامنتها من قِبَل مهمة مجدولة.';
$string['enablegravatar'] = 'تمكين Gravatar';
$string['enablegravatar_help'] = 'عند تمكينه، سيحاول مودل جلب صورة الملف الشخصي للمستخدم من Gravatar إذا لم يرفع المستخدم له صورة في الموقع.';
$string['enablemobilewebservice'] = 'تمكين خدمات الويب للأجهزة المحمولة';
$string['enablepdfexportfont'] = 'تمكين خطوط PDF';
$string['enablepdfexportfont_desc'] = 'إذا كان لموقعك مقررات بلغات مختلفة تحتاج إلى خطوط أخرى في ملفات PDF المولدة، يمكنك توفير خيار يسمح بضبط الخط في إعدادات المقرر. تحتاج تحديد الخطوط المتاحة في $CFG->pdfexportfont في ملف التهيئة config.php.';
$string['enableplugin'] = 'تمكين {$a}';
$string['enablerecordcache'] = 'تمكين تخبئة السجل';
$string['enablerssfeeds'] = 'تمكين خدمة تغذية الأخبار';
$string['enablesearchareas'] = 'تمكين مناطق البحث';
$string['enablesharingtomoodlenet'] = 'تمكين المشاركة إلى شبكة مودل (صادر)';
$string['enablesharingtomoodlenet_desc'] = 'تمكين المستخدمين من مشاركة محتوى لمقرر ما إلى عيِّنة مهيأة من شبكة مودل إذا كانت لديها الإمكانيات ذات الصلة.';
$string['enablestats'] = 'تمكين الإحصائيات';
$string['enabletrusttext'] = 'تمكين المحتوى الموثوق منه';
$string['enableuserfeedback'] = 'تمكين الحصول على الآراء بشأن هذا البرنامج';
$string['enableuserfeedback_desc'] = 'إذا تم تمكينه، فسيتم وضع الرابط "أعطنا رأيك بشأن هذا البرنامج" عند أسفل الصفحة للسماح للمستخدمين بالإدلاء بآرائهم بشأنه إلى مقر مؤسسة مودل. إذا تم تمكين خيار "التذكير بإعطاء الرأي لاحقاً"، فسيُعرض للمستخدم تذكير أيضاً بهذا على صفحته الرئيسية عند فترات زمنية معينة. تعطيل خيار "التذكير بإعطاء الرأي لاحقاً" سيؤدي إلى تعطيل ظهور التذكير على الصفحة الرئيسية للمستخدم بينما سيبقى الرابط أسفل الصفحة موجوداً في محله.';
$string['enablewebservices'] = 'تمكين خدمات الويب';
$string['enablewsdocumentation'] = 'وثائق خدمات الشبكة';
$string['encryptedpassword_edit'] = 'أدخل قيمة جديدة';
$string['encryptedpassword_set'] = '(مهيأ ومشفر)';
$string['enroladminnewcourse'] = 'إنضمام تلقائي للمشرف في المقررات الدراسية الجديدة';
$string['enroladminnewcourse_help'] = 'عندما يضيف المشرف مقررا دراسيًا جديدًا، هل ينبغي ضمه تلقائيًا ومنحه دور المنشئ فيه؟';
$string['enrolinstancedefaults'] = 'إفتراضيات عينة الانضمام';
$string['enrolinstancedefaults_desc'] = 'إعدادات الانضمام الافتراضية في المقررات الدراسية الجديدة';
$string['enrolmultipleusers'] = 'إلحاق المستخدمين';
$string['entitytasklog'] = 'سجل وقوعات المهمة';
$string['environment'] = 'البيئة';
$string['environmenterrortodo'] = 'ينبغي عليك تصحيح كل المشاكل (الأخطاء) الموضحة أعلاه قبل الاستمرار في تنصيب هذا الإصدار من مودل!';
$string['environmenterrorupgrade'] = 'تحذير: يجب حل جميع المشاكل البيئية (الأخطاء) الموجودة أعلاه قبل الشروع في ترقية هذا الإصدار مودل! الترقية دون تحديد هذه المتطلبات يمكن أن يسبب مشاكل مثل فقدان البيانات. هل أنت متأكد أنك تريد المتابعة مع الترقية ؟';
$string['environmentmariadbwrongdbtype'] = '$CFG->dbtype خاطئ: تحتاج إلى تغييره في ملف config.php الخاص بك، من \'mysql\' إلى \'mariadb\'.';
$string['environmentmustfixsetting'] = 'إعداداتPHP  يجب أن تغير.';
$string['environmentok'] = 'بيئة مخدمك متوافقة مع الحد الأدنى لمتطلبات التنصيب';
$string['environmentrecommendcustomcheck'] = 'إذا فشل هذا الاختبار، فإنه يشير إلى وجود مشكلة محتملة';
$string['environmentrecommendinstall'] = 'ينبغي تنصيبه/تمكينه للحصول على أفضل النتائج';
$string['environmentrecommendversion'] = 'يفضل الإصدار {$a->needed}، وأنت تستعمل الإصدار {$a->current}';
$string['environmentrequirecustomcheck'] = 'هذا الاختبار لا بد أن تجتازه';
$string['environmentrequireinstall'] = 'يجب تنصيبه/تمكينه';
$string['environmentrequireversion'] = 'يتطلب الإصدار {$a->needed}، وأنت تستعمل الإصدار {$a->current}';
$string['environmentsettingok'] = 'تم الكشف عن الإعداد المستحسن';
$string['environmentshouldfixcustomcheck'] = 'ينبغي تمكينه للحصول على النتائج الأفضل';
$string['environmentshouldfixsetting'] = 'إعداداتPHP  يفضل أن تغير';
$string['environmentxmlerror'] = 'خطأ عند قراءة بيانات البيئة ({$a->error_code})';
$string['errordeletingconfig'] = 'وقع خطأ عند حذف سجلات تهيئة الإضافة \'{$a}\'.';
$string['errorsetting'] = 'لم يتم حفظ الإعدادات :';
$string['errorwithsettings'] = 'لم تتغير بعض الإعدادات نظراً لوجود خطأ.';
$string['eventshandlersinuse'] = 'تستعمل الملاحق الآتية في نظامك معالجات الأحداث 1 لواجهة برمجة التطبيق المهملة: \'{$a}\'. يرجى تحديثها لتستعمل الأحداث 2 لواجهة برمجة التطبيق. أنظر https://docs.moodle.org/dev/Events_API#Event_dispatching_and_observers.';
$string['everyonewhocan'] = 'كل من يستطيع \'{$a}\'';
$string['exceptions'] = 'استثناءات';
$string['execpathnotallowed'] = 'تحديد المسارات القابلة للتنفيذ والمسارات المحلية مُعطَّل في الملف config.php';
$string['experimental'] = 'تجريبي';
$string['experimentalsettings'] = 'إعدادات تجريبية';
$string['extendedusernamechars'] = 'السماح بالرموز الموسعة في أسماء المستخدمين';
$string['extramemorylimit'] = 'حد ذاكرة PHP الإضافية';
$string['fatalsessionautostart'] = '<p>الكشف عن خطأ جدي في التكوين ، الرجاء إبلاغ مسؤول الخادم . </ P> <p> لتعمل بشكل صحيح، يتطلب مودل أن يغير المسؤول في إعدادات PHP. </p><p><code> لتبدأ الجلسة تلقائيا </code>يجب أن يتم تعيين <code> "مغلق" </code>.</p><p> التحكم في هذا الإعداد عن طريق تحرير ملف php.ini على </code>, Apache/IIS <br />الإعدادات أو <code>.htaccess</code> ملف على الخادم .</p>';
$string['favicon'] = 'الأيقونة المفضلة';
$string['favicon_desc'] = 'الأيقونة المفضلة تُعرض بجوار عنوان الصفحة في تبويب المستعرض. يتم عرض الأيقونة المفضلة لمودل إذا لم يتم تقديم أيقونة مفضلة مخصصة.';
$string['feedbacksettings'] = 'إعدادات الإفادة';
$string['fileconversioncleanuptask'] = 'تنظيف السجلات المؤقتة لتحويلات الملفات';
$string['filecreated'] = 'تم إنشاء ملف جديد';
$string['filescleanupperiod'] = 'تنظيف ملفات سلة المحذوفات';
$string['filescleanupperiod_help'] = 'عدد مرات حذف ملفات سلة المحذوفات. هذه ملفات كانت مرتبطة بسياق لم يعد موجوداً حالياً، على سبيل المثال عند حذف المقرر. يرجى ملاحظة: يمكن أن يؤدي هذا الإعداد إلى فقدان الملفات في المقررات الدراسية التي تم حفظها إحتياطياً ثم حذفها ثم استعادتها؛ إذا تم تعطيل الإعداد \'تضمين الملفات\' (backup_auto_files) في \'إعدادات الحفظ الاحتياطي التلقائي\'.';
$string['filesizeunits'] = 'وحدات حجم الملف';
$string['filestoredin'] = 'احفظ الملف في المجلد :';
$string['filestoredinhelp'] = 'أين سيتم تخزين الملف ؟';
$string['filterall'] = 'ترشيح كل الجُمل';
$string['filtermatchoneperpage'] = 'رشح مطابقة لمرة واحدة في الصفحة';
$string['filtermatchonepertext'] = 'رشح مطابقة لمرة واحدة في النص';
$string['filternavigationwithsystemcontext'] = 'ترشيح التنقل مع سياق النظام';
$string['filters'] = 'المنقحات';
$string['filtersettings'] = 'إدارة المنقحات';
$string['filtersettingsgeneral'] = 'الإعدادات العامة للمنقحات';
$string['filteruploadedfiles'] = 'ترشيح الملفات المرفوعة';
$string['forceclean'] = 'تنظيف المحتوى في كل مكان';
$string['forceclean_desc'] = 'عادةً ما يتم تنظيف المحتوى المُضاف إلى الموقع قبل عرضه، لإزالة أي شيء قد يكون تهديدًا أمنيًا. ومع ذلك، لا يتم تنظيف المحتوى في أماكن معينة مثل أوصاف النشاط أو موارد الصفحة أو كتل HTML للسماح بإضافة البرامج النصية أو الوسائط أو الإطارات المضمنة وما إلى ذلك. إذا تم تمكين هذا الإعداد، فسيتم تنظيف جميع المحتويات. قد ينتج عن ذلك عرض المحتوى الموجود بشكل غير صحيح.';
$string['forcelogin'] = 'افرض على المستخدمين تسجيل الدخول';
$string['forceloginforprofileimage'] = 'افرض على المستخدمين الدخول لمشاهدة صور المستخدم';
$string['forceloginforprofileimage_help'] = 'عند تمكينه، ينبغي على المستخدمين تسجيل الدخول لمشاهدة صور الملفات الشخصية والصورة الافتراضية للمستخدم هي ما سيتم استعماله في كل إشعارات رسائل البريد الالكتروني.';
$string['forceloginforprofiles'] = 'فرض تسجيل الدخول للوصول إلى الملفات الشخصية';
$string['forcetimezone'] = 'فرض المنطقة الزمنية';
$string['formatuninstallwithcourses'] = 'هناك  {$a->count} مقررات دراسية تستخدم {$a->format} . تنسيقها سيتغير إلى {$a->defaultformat} (التنسيق الافتراضي لهذا الموقع) . قد تفقد بعض البيانات ذات التنسيق المعين . هل أنت متأكد أنك تريد المتابعة ؟';
$string['frontpage'] = 'الصفحة الرئيسية';
$string['frontpagebackup'] = 'الحفظ الاحتياطي لواجهة الموقع';
$string['frontpagedefaultrole'] = 'الدور الافتراضي لواجهة الموقع';
$string['frontpagefilters'] = 'منقحات واجهة الموقع';
$string['frontpageloggedin'] = 'عناصر واجهة الموقع عند تسجيل الدخول';
$string['frontpageoverrides'] = 'تجاوزات صلاحية واجهة الموقع';
$string['frontpagequestions'] = 'أسئلة واجهة الموقع';
$string['frontpagerestore'] = 'استرجاع واجهة الموقع';
$string['frontpageroles'] = 'أدوار واجهة الموقع';
$string['frontpagesettings'] = 'إعدادات واجهة الموقع';
$string['fullnamedisplay'] = 'تنسيق الاسم الكامل';
$string['fullnamedisplayprivate'] = 'تنسيق الاسم الكامل - خاص';
$string['gdrequired'] = 'الامتداد GD مطلوب الآن في مودل لتحويل الصور.';
$string['generalsettings'] = 'الإعدادات العامة';
$string['geoipdbedition'] = 'نسخة قاعدة بيانات GeoIP';
$string['geoipdbedition_desc'] = 'إختر نسخة قاعدة بيانات GeoIP لتنزيلها. يرجى الأخذ بنظر الاعتبار أن استعمال قاعدة بيانات GeoIP2-City يتطلب رخصة مدفوعة الأجر صالحة.';
$string['geoipfile'] = 'قاعدة بيانات GeoIP City';
$string['geoipmaxmindaccid'] = 'مُعرَّف حساب MaxMind';
$string['geoipmaxmindaccid_desc'] = 'مُعرَّف الحساب المنشأ في مخدم واجهة برمجة التطبيق لـ MaxMind';
$string['geoipmaxmindlicensekey'] = 'مفتاح رخصة MaxMind';
$string['geoipmaxmindlicensekey_desc'] = 'مفتاح رخصة الحساب المنشأ في مخدم واجهة برمجة التطبيق لـ MaxMind';
$string['getremoteaddrconf'] = 'تسجيل مصدر عنوان IP';
$string['globalsearch'] = 'البحث العالمي';
$string['globalsearchmanage'] = 'إدارة البحث العمومي';
$string['googlemapkey3'] = 'خرائط جوجل API الرئيسية V3';
$string['googlemapkey3_help'] = 'تحتاج إلى إدخال مفتاح خاص لاستخدام خرائط Google للبحث عن عنوان IP المصور . يمكنك الحصول على مفتاح مجانا في <a href="https://developers.google.com/maps/documentation/javascript/tutorial#api_key" target="_blank">https://developers.google.com/maps/documentation/javascript/tutorial#api_key</a>';
$string['gotofirst'] = 'اذهب لأول مقطع مفقود';
$string['gradebook'] = 'سجل التقديرات';
$string['gradebookroles'] = 'أدوار تُمنح لها التقديرات';
$string['gradeexport'] = 'الطرق الأولية لتصدير التقديرات';
$string['gradeexportdefault'] = 'الطريقة الافتراضية لتصدير التقديرات';
$string['gravatardefaulturl'] = 'الرابط الافتراضي للصورة من Gravatar';
$string['gravatardefaulturl_help'] = 'Gravatar يحتاج إلى الصورة الافتراضية لعرضها إذا كان غير قادر على العثور على صورة للمستخدم المعين. أعطِ الرابط الكامل للصورة. ترميزات توليد الصور الافتراضية متاحة في <a href="https://docs.gravatar.com/api/avatars/images/">Gravatar للمطورين - طلبات الصور المستعارة</a>.';
$string['group_customfield'] = 'الحقول المخصصة للمجموعة';
$string['groupenrolmentkeypolicy'] = 'سياسة مفتاح انضمام المجموعة';
$string['groupenrolmentkeypolicy_desc'] = 'عند تمكنه، سيتم فحص مفاتيح الانضمام للمجموعة على ضوء سياسة كلمة المرور كما تم تحديدها أعلاه.';
$string['grouping_customfield'] = 'الحقول المخصصة للتجمع';
$string['guestroleid'] = 'دور الضيف';
$string['guestroleid_help'] = 'يتم تعيين هذا الدور تلقائياً إلى المستخدم الضيف. أيضاً يتم تعيينه مؤقتاً للمستخدمين غير المسجلين الذين يدخلون إلى المقرر عن طريق إضافة إنضمام الضيف.';
$string['h5pgetcontenttypestask'] = 'تنزيل أنواع محتوى H5P المتاحة من h5p.org';
$string['helpadminseesall'] = 'في تقويم الموقع، هل يشاهد المشرفون الأحداث ويقومون بترشحها من كل تقويمات المقررات الدراسية، أم فقط للمقررات المنضمين إليها؟ بغض النظر عن الخيار الذي يتم تحديده هنا، سيتمكن المشرفون دائماً من إدارة الأحداث لكل تقاويم المقررات الدراسية من خلال الانتقال إلى المقرر أولاً، ثم الوصول إلى تقويمه مباشرةً.';
$string['helpcalendarcustomexport'] = 'تمكين خيار تحديد نطاق مخصص من التواريخ عند تصدير التقويم. ينبغي تمكين تصدير التقويم قبل أن يصير هذا سارياً.';
$string['helpexportlookahead'] = 'ما عدد الأيام في المستقبل التي يبحث فيها التقويم عن الأحداث خلال التصدير لخيار التصدير المخصص؟';
$string['helpexportlookback'] = 'كم يوما في الماضي يبحث التقويم عن الأحداث أثناء التصدير لخيار التصدير المخصص؟';
$string['helpforcetimezone'] = 'تستطيع السماح للمستخدمين باختيار مناطقهم الزمنية، أو أن تفرض منطقة زمنية على الجميع.';
$string['helpshowicalsource'] = 'في حالة التمكين، سيتم عرض اسم الاشتراك والارتباط للأحداث المستوردة من iCal.';
$string['helpsitemaintenance'] = 'للترقيات وأعمال أخرى';
$string['helpstartofweek'] = 'ما هو اليوم الذي يبدأ به الأسبوع في التقويم؟';
$string['helpupcominglookahead'] = 'ما هو عدد الأيام في المستقبل التي سيُظهر التقويم أحداثها القادمة إفتراضياً؟';
$string['helpupcomingmaxevents'] = 'إفتراضياً، ما هو (العدد الأقصى) من الأحداث القادمة التي ستُعرض للمستخدمين؟';
$string['helpweekenddays'] = 'أيّ الأيام من الأسبوع ستعامل بمثابة "نهاية الأسبوع" وستعرض بلون مختلف؟';
$string['hiddenuserfields'] = 'أخف حقول المستخدم';
$string['hidefromall'] = 'أخف عن جميع المستخدمين';
$string['hidefromnone'] = 'لا تخفيه عن أحد';
$string['hidefromstudents'] = 'أخف عن الطلاب';
$string['hookcallbacknotcallable'] = 'هذا الاستدعاء لا يمكن طلبه. قد يعود ذلك إلى كون الفئة أو الطريقة غير موجودين أو لأن الطريقة ليست عامة.';
$string['hookcallbacks'] = 'الاستدعاءات';
$string['hookcallbacks_help'] = 'قائمة الاستدعاءات التي سيتم طلبها عند إطلاق الوَصلة.

الترتيب الظاهر هو الترتيب الذي سيتم به طلب الاستدعاءات.

الاستدعاء ذي الأولوية الأعلى سيتم طلبه قبل الاستدعاء الأدنى أولوية.';
$string['hookclassmissing'] = 'تعذر العثور على فئة الوَصلة';
$string['hookclassmissing_desc'] = 'وكيل استكشاف الوَصلة قد أعاد فئة غير موجودة.';
$string['hookconfigoverride'] = 'متجاوَز';
$string['hookconfigoverride_help'] = 'لقد تم تجاوز تعريف هذا الاستدعاء في ملف تهيئة الموقع، config.php';
$string['hookdeprecates'] = 'الاستدعاءات المهملة';
$string['hookdescription'] = 'الوصف';
$string['hookdescriptionmissing'] = 'الوَصلة لا تمتلك طريقة الوصف';
$string['hookname'] = 'الوَصلة';
$string['hooksoverview'] = 'استعراض الوَصلات';
$string['hookunknown'] = 'الوَصلة غير موجودة';
$string['hookunknown_desc'] = 'المكون الذي يصغي له هذا الاسترجاع غير متاح. قد يكون مزالاً أو أُعيدت تسميته، أو قد لا يكون متاحًا لهذا الإصدار من مودل.';
$string['hostname'] = 'اسم المضيف';
$string['htmleditor'] = 'محرر HTML';
$string['htmleditorsettings'] = 'إعدادات محرر لغة رقم النص الفائق';
$string['htmlsettings'] = 'إعدادات HTML';
$string['http'] = 'HTTP';
$string['httpsecurity'] = 'أمان HTTP';
$string['iconvrequired'] = 'تنصيب الامتداد ICONV مطلوب.';
$string['igbinary322buggyversion'] = 'إن الامتداد php-igbinary المنصب في الموقع قد يؤدي إلى مشاكل عند تشغيله مع PHP 7.2. نوصيك إما بالترقية إلى php-igbinary 3.2.5 أو ما بعدها، أو بدلاً من ذلك الترقية إلى PHP 7.3 أو ما بعده.';
$string['ignore'] = 'تجاهل';
$string['importantupdates_content'] = '<p>في الإصدار القادم من مودل 5.0، المخطط إطلاقه في نيسان 2025، ستتم إزالة نشاطات الدردشة والاستبيان من الحزمة الأساسية لمودل. ستكون تلك متاحة كملاحق في
<a href="https://moodle.org/plugins/">مجلد ملاحق مودل</a>.</p>
<p>إذا كنت ترغب بالاستمرار في استعمال الدردشة والاستبيان في موقعك، ستتمكن من تنصيبها كملاحق قبل الترقية إلى مودل 5.0.</p>';
$string['importantupdates_title'] = 'تحديث هام بشأن نشاطات الدردشة والاستبيان';
$string['includemoduleuserdata'] = 'يتضمن الوحدة النمطية لبيانات المستخدم';
$string['incompatibleblocks'] = 'كتل غير متوافقة';
$string['incompleteunicodesupport'] = 'يستعمل الإعداد الحالي لـ MySQL أو MariaDB الترميز \'utf8\'. لا تدعم مجموعة الأحرف هذه حروف الأربعة بايتات والتي تتضمن بعض الرموز التعبيرية. ستؤدي محاولة استعمال هذا الترميز من الأحرف إلى حدوث خطأ عند تحديث السجل، وستفقد أي معلومات يتم إرسالها إلى قاعدة البيانات. يرجى التفكير في تغيير إعداداتك إلى "utf8mb4". أنظر التوثيقات للحصول على التفاصيل الكاملة.';
$string['indexdata'] = 'بيانات الفهرس';
$string['indexinginfo'] = 'الطريقة الموصى بها لفهرسة محتويات موقعك هي استعمال المهمة المجدولة \'فهرسة البحث العمومي\'.';
$string['installhijacked'] = 'ينبغي أن يتم الانتهاء من التنصيب من عنوان IP الأصلي، عذراً.';
$string['installsessionerror'] = 'لا يمكن الشروع بجلسة PHP، يرجى التحقق من أن متصفحك يقبل ملفات تعريف الارتباط.';
$string['intlrecommended'] = 'يستعمل الامتداد Intl لتحسين دعم التدويل، مثل الفرز المراعي للغة.';
$string['intlrequired'] = 'إمتداد Intl مطلوب لتحسين دعم التدويل، مثل الفرز المراعي للغة المحلية وأسماء النطاقات الدولية.';
$string['invalidagedigitalconsent'] = 'العمر الرقمي للموافقة غير صالح: {$a}';
$string['invalidforgottenpasswordurl'] = 'عنوان URL الخاص بكلمة المرور المنسية ليس عنوان URL صالحًا.';
$string['invalidsection'] = 'قسم غير صالح .';
$string['invalidthemepreset'] = 'الملف المحدد مسبقاً غير متوافق مع هذا القالب. الخطأ في ترجمة SCSS كان: "{$a}"';
$string['invaliduserchangeme'] = 'اسم المستخدم "changeme" محجوز -- لن تستطيع إنشاء حساب به.';
$string['ipblocked'] = 'هذا الموقع غير متوفر حالياً .';
$string['ipblocker'] = 'حظر IP';
$string['ipblockersyntax'] = 'ضع كل إدخال في سطر واحد. الإدخالات الصالحة إمّا عنوان IP كامل (مثل<b>192.168.10.1</b>) والذي يطابق مضيفا واحداً ، أو عنواناً جزئياً (مثل<b>192.168.</b>) والذي يطابق أي عنوان يبدأ بتلك الأرقام، أو تأشير  CIDR (مثل  <b>231.54.211.0/20</b>)؛ أو مدى من عناوين IP (مثل<b>231.3.56.10-20</b>) حيث ينطبق النطاق على الجزء الأخير من العنوان. نص أسماء النطاقات (مثل \'example.com\') غير مدعوم. يتم تجاهل الأسطر الفارغة والنصوص التي تتبع الرمز "#".';
$string['iplookup'] = 'التعرف على العنوان من برتوكول الإنترنت';
$string['iplookupgeoplugin'] = 'خدمة <a href="https://www.geoplugin.com">geoPlugin</a> يتم استعمالها حالياً للبحث عن المعلومات الجغرافية. لنتائج أكثر دقة، من المستحسن تنصيب نسخة محلية من قاعدة بيانات GeoIP City.';
$string['iplookupinfo'] = 'يتم استعمال مخدم NetGeo المجاني للبحث في مواقع عناوين IP. مع ذلك، قاعدة البيانات هذه لم تعد مُدامة، وربما ترجع بيانات غير صحيحة. من المستحسن تنصيب نسخة محلية لقاعدة البيانات المجانية من GeoIP من MaxMind.<br />
إذا تم توفير مفتاح واجهة برمجة التطبيق لخرائط Google بالإصدار الثالث، فموقع عنوان IP سيتم عرضه باستعمال خرائط Google. ستحتاج أن يكون لديك حساب في Google مع طلب مفتاح واجهة برمجة التطبيق لخرائط Google.إذا لم يتم توفير مفتاح واجهة برمجة التطبيق لخرائط Google بالإصدار الثالث، سيتم عرض موقع عنوان IP باستعمال OpenStreetMap.';
$string['iplookupmaxmindnote'] = 'هذا المنتج يتضمن بيانات GeoIP City التي تم إنشاؤها بواسطة MaxMind، التي تتوفر من <a href="https://www.maxmind.com/">https://www.maxmind.com/</a>.';
$string['iscustomadminwarnings'] = 'لقد تم الكشف على أن موقعك يستعمل مجلد إدارة مخصص. هذه الميزة لم تعد مدعومة وستتم إزالتها بعد مودل 4.2.';
$string['ishttpswarning'] = 'لقد تم اكتشاف أن موقعك غير مُؤمَّن باستعمال HTTPS. يوصى بشدة بترحيل موقعك إلى HTTPS لزيادة الأمان وتحسين التكامل مع الأنظمة الأخرى.';
$string['keeptagnamecase'] = 'الحفاظ على حالة أحرف اسم الوسم';
$string['lang'] = 'اللغة الافتراضية';
$string['langcache'] = 'تخبئة قائمة اللغة';
$string['langcache_desc'] = 'تخبئة قائمة اللغة. إذا تم تمكينه، يتم التخزين المؤقت للائحة الترجمات المتاحة. يتم تحديث تلك النسخة المخبأة تلقائياً عند تنصيب أو حذف حزمة اللغة عن طريق أداة إدارة حزم اللغات. إذا قمت بتنصيب حزمة لغة جديدة يدوياً، عليك استعمال ميزة تطهير كافة النسخ المخبأة لتحديث القائمة.';
$string['langlist'] = 'اللغات على قائمة اللغة';
$string['langmenu'] = 'اعرض قائمة اللغة';
$string['langmenuinsecurelayout'] = 'عرض قائمة اللغة بتشكيل آمن';
$string['langmenuinsecurelayout_desc'] = 'إذا تم تمكينه، سيتمكن المستخدم من تغيير اللغة في الموقع في أثناء أدائه للامتحان أو تعامله مع النشاطات الأخرى عبر تداولها مع المخدم بصيغة مشفرة.';
$string['langpackwillbeupdated'] = 'ملاحظة: مودل سيحاول تنزيل التحديثات لحزم اللغات الخاصة بك أثناء الترقية.';
$string['langstringcache'] = 'تخزين كافة مقاطع اللغة';
$string['languagesettings'] = 'إعدادات اللغة';
$string['latinexcelexport'] = 'ترميز Excel';
$string['legacyfilesaddallowed'] = 'السماح بالإضافة إلى ملفات المقرر القديمة';
$string['legacyfilesaddallowed_help'] = 'إذا كان المقرر محتوياً على ملفات قديمة، إسمح بإضافة الملفات والمجلدات الجديدة إليه.';
$string['legacyfilesinnewcourses'] = 'توريث ملفات المقرر في مقررات دراسية جديدة';
$string['legacyfilesinnewcourses_help'] = 'إفتراضياً، تتواجد المناطق القديمة لملفات المقررات الدراسية فقط في المقررات المُحدثة. يرجى ملاحظة بعض الميزات مثل الحفظ الاحتياطي للنشاط واستعادته غير متوافقة مع هذا الإعداد.';
$string['libcurlwarning'] = 'تم اكتشاف أن libcurl لا يحتوي على دعم CURLOPT_PROTOCOL. يوصى بتنصيب برنامج libcurl المحدث لأسباب أمنية.';
$string['licensesettings'] = 'إعدادات الرخصة';
$string['linkadmincategories'] = 'روابط لفئات الإدارة';
$string['linkadmincategories_help'] = 'عند تمكينه، سيتم عرض فئات إعدادات الإدارة كروابط في أدوات التنقل وستقود إلى صفحات فئات الإدارة.';
$string['loading'] = 'تحميل';
$string['localetext'] = 'لغة الموقع';
$string['localstringcustomization'] = 'تخصيص المقاطع المحلية';
$string['location'] = 'الموقع';
$string['locationsettings'] = 'إعدادات الموقع';
$string['locked'] = 'مغلق';
$string['lockoutduration'] = 'فترة تعطيل الحساب';
$string['lockoutduration_desc'] = 'يتم تلقائياً إلغاء قفل الحساب المقفول بعد هذه المدة.';
$string['lockoutemailbody'] = 'مرحبًا {$a->firstname}،

لقد تم قفل حسابك باسم المستخدم {$a->username} في الموقع \'{$a->sitename}\'
بعد عدة محاولات غير صالحة لتسجيل الدخول.

لإلغاء قفل الحساب فوراً، إنتقل إلى العنوان التالي

{$a->link}

في معظم برامج البريد، ينبغي أن يظهر هذا كرابط أزرق اللون
يمكنك النقر عليه. إذا لم ذلك متأتِّياً، قم بنسخ العنوان ولصقه
في شريط العنوان أعلى نافذة المتصفح.

إذا كنت بحاجة إلى مساعدة، يرجى الاتصال بمسؤول الموقع،
{$a->admin}';
$string['lockoutemailsubject'] = 'تم إغلاق حسابك على {$a}';
$string['lockouterrorunlock'] = 'معلومات غير صالحة لإلغاء تأمين الحساب.';
$string['lockoutthreshold'] = 'عتبة تأمين الحساب';
$string['lockoutthreshold_desc'] = 'حدد عدد محاولات تسجيل الدخول الفاشلة التي تؤدي إلى تأمين الحساب. قد يتم إساءة استخدام هذه الميزة في هجمات رفض الخدمة.';
$string['lockoutwindow'] = 'فترة رصد قفل الحساب';
$string['lockoutwindow_desc'] = 'مدة الرصد لعتبة القفل، إذا لم تكن هناك محاولات فاشلة، يتم إعادة ضبط العتبة بعد هذا الوقت.';
$string['lockrequestcategory'] = 'منع اختيار التصنيف';
$string['log'] = 'الوقوعات';
$string['logguests'] = 'تسجل دخول الضيوف';
$string['logguests_help'] = 'يتيح هذا الإعداد تسجيل الإجراءات المتخذة من حساب الضيف وليس للمستخدمين. المواقع الراقية قد ترغب في تعطيل هذا التسجيل لأسباب تتعلق بالأداء. فمن المستحسن إبقاء هذا الإعداد ممكّناً في مواقع الإنتاج.';
$string['logininfoinsecurelayout'] = 'عرض اسم المستخدم الحالي بتشكيل آمن';
$string['logininfoinsecurelayout_desc'] = 'إذا تم تمكينه، فإن الاسم الكامل للمستخدم الحالي سيتم عرضه ضمن شريط التنقل في أثناء أدائه للامتحان أو تعامله مع النشاطات الأخرى وسيتم تداوله مع المخدم بصيغة مشفرة.';
$string['loginpageautofocus'] = 'ضبط تلقائي لنموذج صفحة الدخول';
$string['loginpageautofocus_help'] = 'تمكين هذا الخيار يحسّن من استخدام صفحة تسجيل الدخول ، لكن التركيز التلقائي للحقول يمكن اعتبارها مشكلة معاقين.';
$string['loglifetime'] = 'إحتفظ بسجلات الوقوعات لمدة';
$string['logo'] = 'الشعار';
$string['logo_desc'] = 'شعار كامل ليتم استعماله كزينة لبعض القوالب (مثل القوالب الأساسية). يمكن أن تكون هذه الصورة عالية الدقة لأنه سيتم تصغيرها للاستخدام (وتخبئتها لمتطلب الأداء). الشعارات ذات العرض الأكبر من ارتفاعها تعطي عادةً نتائج أفضل.';
$string['logocompact'] = 'الشعار المضغوط';
$string['logocompact_desc'] = 'إصدار مضغوط من نفس الشعار المذكور أعلاه، مثل الشارة أو الدرع أو الرمز. يجب أن تكون الصورة واضحة حتى في أحجام صغيرة.';
$string['logossettings'] = 'الشعارات';
$string['logstorenotrequired'] = 'مخزن سجل الوقوعات غير مطلوب';
$string['logstoressupported'] = 'مخازن سجلات الوقوعات التي تدعم هذا التقرير';
$string['longtimewarning'] = '<b>فضلاً مراعاة أن هذه العملية ستأخذ وقتاً طويلاً .</b>';
$string['mailnewline'] = 'أحرف السطر الجديد في البريد';
$string['maintenancemode'] = 'في وضع الصيانة';
$string['maintenancemodeisscheduled'] = 'سيتم تبديل هذا الموقع إلى وضع الصيانة في {$a->min} دقيقة {$a->sec} ثانية';
$string['maintenancemodeisscheduledlong'] = 'سيتم تبديل هذا الموقع إلى وضع الصيانة في {$a->hour} ساعة {$a->min} دقيقة {$a->sec} ثانية';
$string['maintfileopenerror'] = 'خطأ عند فتح ملفات الصيانة!';
$string['maintinprogress'] = 'الصيانة قيد التنفيذ...';
$string['managecontextlock'] = 'تجميد هذا السياق';
$string['managecontextlocklocked'] = '{$a->contextname} وأي سياقات أقل، تم تجميدها الآن.';
$string['managecontextlockunlocked'] = '{$a->contextname} وأي سياقات أقل، الآن هي غير مجمدة.';
$string['managecontextunlock'] = 'إلغِ تجميد هذا السياق';
$string['managecustomfields'] = 'أدارة أنواع الحقول المخصصة';
$string['manageformats'] = 'إدارة تنسيقات المقررات الدراسية';
$string['manageformatsgotosettings'] = 'التنسيق الافتراضي يمكن تغييره في {$a}';
$string['managelang'] = 'إدارة';
$string['manageqbanks'] = 'إدارة إضافات بنك الأسئلة';
$string['manageqbehaviours'] = 'إدارة سلوك الأسئلة';
$string['manageqtypes'] = 'إدارة أنواع الأسئلة';
$string['maturity100'] = 'بيتا';
$string['maturity150'] = 'الإصدار المرشح';
$string['maturity200'] = 'الإصدار المستقر';
$string['maturity50'] = 'ألفا';
$string['maturityallowunstable'] = 'تلميح : قد ترغب في تشغيل هذا البرنامج النصي مع - سماح - خيار غير مستقر';
$string['maturitycoreinfo'] = 'موقعك يشتغل حالياً بنصوص برمجية غير مستقرة، ترميز التطوير هو "{$a}".';
$string['maturitycorewarning'] = 'إصدار مودل الذي أنت على وشك تنصيبه أو ترقيته سيحتوي رمز التطوير "{$a}" غير المستقر والذي لا يتناسب مع استعمالات معظم المواقع الإنتاجية. إذا لم يكن هذا ما تريده، فينبغي عليك التأكد من أنك تقوم بالتحديث من إصدار مستقر لبرنامج مودل.
أنظر توثيقات مودل لمزيد من التفاصيل.';
$string['maxbytes'] = 'الحجم الأقصى للملف المرفوع';
$string['maxcharacter'] = '{$a} من الحروف كحد أقصى';
$string['maxconsecutiveidentchars'] = 'الأحرف المتشابهة المتتابعة';
$string['maxeditingtime'] = 'الحد الاقصى لتحرير المنشورات';
$string['maxsizeperdownloadcoursefile'] = 'أقصى حجم لكل ملف';
$string['maxsizeperdownloadcoursefile_desc'] = 'أقصى حجم لكل ملف عند تنزيل محتوى المقرر. الملفات التي تتجاوز هذا الحجم سيتم التغافل عنها عند التنزيل.';
$string['maxtimelimit'] = 'حد الوقت الاقصى';
$string['maxtimelimit_desc'] = 'لتقييد وقت تنفيذ PHP الأقصى الذي سيسمح به مودل دون عرض أي مخرجات، أدخل قيمة بالثواني هنا. 0 تعني استعمال تقييدات مودل الافتراضية. إذا كان لديك مخدم طرف أمامي له الحد الزمني الخاص به، فقم بجعل هذه القيمة أقل لتلقي أخطاء PHP في سجلات الوقوعات. لا ينطبق هذا على النصوص البرمجية لواجهة سطر الأوامر.';
$string['maxusersperpage'] = 'أقصى عدد من المستخدمين لكل صفحة';
$string['mbstringrecommended'] = 'يفضل وبشدة تنصيب مكتبة (MBSTRING) لتحسين أداء الموقع، خاصة إذا كان موقعك يدعم اللغات غير اللاتينية.';
$string['mbstringrequired'] = 'يتطلب تنصيب مكتبة MBSTRING لتحسين أداء الموقع، خاصة إذا كان موقعك يدعم اللغات غير اللاتينية.';
$string['mediapluginavi'] = 'تمكين منقح (.avi)';
$string['mediapluginflv'] = 'تمكين منقح (.flv)';
$string['mediapluginimg'] = 'تمكين التضمين التلقائي لروابط الصور';
$string['mediapluginmov'] = 'تمكين منقح (.mov)';
$string['mediapluginmp3'] = 'تمكين منقح (.mp3)';
$string['mediapluginmpg'] = 'تمكين منقح (.mpg)';
$string['mediapluginogg'] = 'تمكين مرشح .ogg';
$string['mediapluginogv'] = 'تمكين مرشح .ogv';
$string['mediapluginram'] = 'تمكين منقح (.ram)';
$string['mediapluginrm'] = 'تمكين منقح (.rm)';
$string['mediapluginrpm'] = 'تمكين منقح (.rpm)';
$string['mediapluginwmv'] = 'تمكين منقح (.wmv)';
$string['mediapluginyoutube'] = 'تمكين مرشح روابط يوتيوب';
$string['messaging'] = 'تمكين نظام المراسلة';
$string['messagingallowemailoverride'] = 'تجاوز البريد الالكتروني للإشعارات';
$string['messagingallusers'] = 'السماح بالرسائل على مستوى الموقع';
$string['messagingcategory'] = 'الرسائل';
$string['messagingdefaultpressenter'] = 'استعمال مفتاح Enter للإرسال مُمَكَّن افتراضياً';
$string['messagingdeleteallnotificationsdelay'] = 'حذف كل الإشعارات';
$string['messagingdeletereadnotificationsdelay'] = 'حذف الإشعارات المقروءة';
$string['messagingssettings'] = 'إعدادات المراسلة';
$string['minpassworddigits'] = 'أرقام';
$string['minpasswordlength'] = 'طول كلمة المرور';
$string['minpasswordlower'] = 'أحرف صغيرة';
$string['minpasswordnonalphanum'] = 'أحرف غير أبجدية ولا رقمية';
$string['minpasswordupper'] = 'أحرف كبيرة';
$string['misc'] = 'متنوع';
$string['mlbackendsettings'] = 'إعدادات خلفية تعلم الآلة';
$string['mnetrestore_extusers'] = '<strong>ملاحظة:</strong> هذا الملف الاحتياطي يحتوي على حسابات المستخدمين لشبكة مودل البعيدة والتي سيتم استعادتها كجزء من العملية.';
$string['mnetrestore_extusers_admin'] = '<strong>ملاحظة:</strong> يبدو أن ملف الحفظ الاحتياطي هذا يأتي من تنصيب مختلف لمودل ويحتوي على حسابات المستخدمين لشبكة مودل عن بعد. عملية الاستعادة ستحاول مطابقة مستضيفي شبكة مودل لجميع المستخدمين المنشئين. تلك غير المطابقة، سيتم تحويلها تلقائياً إلى المصادقة الداخلية (بدلاً من مصادقة شبكة مودل). سجل وقوعات الاستعادة سيبلغكم عن ذلك.';
$string['mnetrestore_extusers_mismatch'] = '<strong>ملاحظة:</strong> يبدو أن ملف الحفظ الاحتياطي هذا ينشأ من تنصيب مودل مختلف ويحتوي على حسابات مستخدمين لشبكة مودل البعيدة التي قد تفشل في استعادتها. هذه العملية غير معتمدة. إذا كنت متأكدًا أنه تم إنشاؤها في هذا التنصيب من مودل، أو يمكنك التأكد من أن كافة المستضيفين لشبكة مودل المطلوبين قد تمت تهيئتهم، فقد ترغب في محاولة الاستعادة.';
$string['mnetrestore_extusers_noadmin'] = '<strong>ملاحظة:</strong> يبدو أن ملف الحفظ الاحتياطي هذا يأتي من تنصيب مختلف لمودل ويحتوي على حسابات المستخدمين لشبكة مودل عن بعد. لا يسمح لك بتنفيذ هذا النوع من الاستعادة. إتصل بالمسؤول عن الموقع أو، بدلاً من ذلك، قم باستعادة هذا المقرر بدون أي معلومات عن المستخدمين (الوحدات، الملفات...).';
$string['mnetrestore_extusers_switchuserauth'] = 'مستخدم لشبكة مودل عن بعد {$a->username}
 (قادم من  {$a->mnethosturl})
انتقل إلى المحلية
{$a->auth}
مستخدم تمت مصادقته.';
$string['mobilenotconfiguredwarning'] = 'لم يتم تمكين تطبيق مودل.';
$string['modassignmentinuse'] = 'موقعك لا يزال يستعمل ملحق الواجب 2.2. قبل الترقية ينبغي عليك 1) إجراء الحفظ الاحتياطي لأي نشاطات تستعمل الواجب 2.2 ترغب في الاحتفاظ بها ومن ثم استعادتها بمثابة واجبات جديدة؛ أو 2) حذف كل بيانات الواجبات 2.2 من قاعدة البيانات.';
$string['modassignmentsubpluginsexist'] = 'قد تكون الملاحق الفرعية للواجب 2.2 موجودة. تحتاج إلى إزال المجلد mod/assignment مع كل الملاحق الفرعية فيه قبل الترقية.';
$string['modeditdefaults'] = 'القيم الافتراضية لإعدادات النشاط';
$string['modsettings'] = 'إدارة النشاطات';
$string['modulesecurity'] = 'وحدة الأمان';
$string['moodlebrandedapp'] = 'علامة تطبيق مودل';
$string['moodlebrandedappreference'] = 'بدلاً من ذلك، إحصل على <a href="https://moodle.com/branded-app/">تطبيق مودل ذي العلامة التجارية</a> معززاً بعلامتك التجارية المخصصة.';
$string['mustenablestats'] = 'لم يتم تمكين الإحصائيات على هذا الموقع.';
$string['mycourses'] = 'مقرراتي';
$string['mydashboard'] = 'لوحة النظام الافتراضية';
$string['mymoodle'] = 'لوحة التحكم';
$string['mypage'] = 'صفحة لوحة التحكم الافتراضية';
$string['mypagelocked'] = 'تأمين الصفحة الافتراضية';
$string['myprofile'] = 'الصفحة الافتراضية للملف الشخصي';
$string['navadduserpostslinks'] = 'أضف روابط لمشاهدة منشورات المستخدم';
$string['navadduserpostslinks_help'] = 'عند تمكينه، سيضاف رابطان لكل مستخدم في التنقل لعرض مناقشاته التي بدأها، ومنشوراته في المنتديات في جميع أنحاء الموقع أو في مقررات دراسية معينة.';
$string['navcourselimit'] = 'محدد عدد المقررات الدراسية';
$string['navfilter'] = 'تصفية القائمة المخصصة';
$string['navfilter_desc'] = 'معالجة القائمة المخصصة من خلال مرشحات مودل المعدة لتطبيقها على <strong>المحتوى والعناوين</strong>. مفيد لتمكين عناصر القائمة المخصصة القابلة للتغيير.';
$string['navigationupgrade'] = 'هذه الترقية تدخل اثنين من كتل التنقل الجديدة التي سوف تحل محل هذه الكتل:
الإدارة، المقررات الدراسية، الأنشطة والمشاركون. إذا كنت قد وضعت أيّ صلاحيات خاصة لتلك الكتل، ينبغي عليك مراجعتها للتأكد من أن كل شيء يتصرف كما تريد.';
$string['navshowallcourses'] = 'إظهار كل المقررات الدراسية';
$string['navshowcategories'] = 'أظهر تصنيفات المقررات الدراسية';
$string['navshowfrontpagemods'] = 'إظهار نشاطات واجهة الموقع في التنقل';
$string['navshowfrontpagemods_help'] = 'عند تمكينه، سيتم إظهار أنشطة واجهة الموقع في التنقل ضمن صفحات الموقع. هذا الإعداد ينطبق فقط على القوالب المبنية على القالب الكلاسيكي.';
$string['navshowfullcoursenames'] = 'إظهار أسماء المقررات الدراسية كاملة';
$string['navshowfullcoursenames_help'] = 'في حالة التمكين، سيتم استعمال الأسماء الكاملة للمقررات الدراسية في التنقل بدلاً من الأسماء المختصرة.';
$string['navshowmycoursecategories'] = 'أظهر تصنيفات مقرراتي';
$string['navshowmycoursecategories_help'] = 'عند تمكينه، فالمقررات التي تظهر للمستخدم ضمن فرع مقرراتي ستكون مبوبة حسب التصنيفات في كتلة التنقل (للمظاهر الكلاسيكية فقط).';
$string['navsortmycourseshiddenlast'] = 'ضع المقررات الدراسية المخفية عند نهاية القائمة';
$string['navsortmycourseshiddenlast_help'] = 'في حالة التمكين، سيتم سرد أيّ مقررات مخفية بعد المرئي منها (للمستخدمين الذين يمكنهم معاينة المقررات الدراسية المخفية). وإلا، سيتم إدراج جميع المقررات، بصرف النظر عن حالة إظهارها، وفقاً لإعداد \'ترتيب مقرراتي\'.';
$string['navsortmycoursessort'] = 'ترتيب المقررات في كتلة التنقل';
$string['navsortmycoursessort_help'] = 'هل ينبغي عرض المقررات وفقًا لترتيبها الموجود في إدارة الموقع > المقررات > إدارة المقررات والتصنيفات) أو هجائياً حسب إعداد المقرر؟ هذا الإعداد يُطبق فقط مع القوالب المبنية على القالب الكلاسيكي.';
$string['never'] = 'أبداً';
$string['neverdeleteruns'] = 'أبداً لا تحذف التشغيلات';
$string['newestdocindexed'] = 'أحدث وثيقة مفهرسة';
$string['nobookmarksforuser'] = 'ليس لديك أيّ إشارات مرجعية.';
$string['nodatabase'] = 'لا قاعدة بيانات';
$string['noemaileverwarning'] = '<strong>ملاحظة:</strong> لقد تم تعطيل كل البريد الصادر';
$string['nohttpsformobilewarning'] = 'من المستحسن تمكين HTTPS مع شهادة صالحة. لأن تطبيق مودل دائماً سيحاول استخدام اتصال آمن أولاً .';
$string['nomissingstrings'] = 'لا يوجد مقاطع مفقودة';
$string['none'] = 'لا شيء';
$string['nonewsettings'] = 'لم تتم إضافة أيّ إعدادات جديدة خلال هذه الترقية.';
$string['nonexistentbookmark'] = 'الإشارة المرجعية المطلوبة غير موجودة.';
$string['noreplyaddress'] = 'عدم الرد';
$string['noreplydomain'] = 'عنوان عدم الرد ومجاله';
$string['noreplydomaindetail'] = 'إعدادات عدم الرد والمجالات المهيئة له';
$string['noresults'] = 'لا نتائج موجودة.';
$string['noroles'] = 'لا أدوار';
$string['nosupportedlogstore'] = 'لم يتم العثور على أي سجل وقوعات مدعوم';
$string['noteunneededblocks'] = 'ملاحظة: الكتل المهيأة للظهور لن يتم إدراجها في قائمة \'إضافة كتلة\' ضمن مقرر أكاديمي معين إذا تم تحديدها في إعداد القالب \'الكتل غير الضرورية\'.';
$string['notifications'] = 'الإشعارات';
$string['notifyloginfailures'] = 'بريد الكتروني لمحاولات الدخول الفاشلة إلى';
$string['notifyloginthreshold'] = 'عتبة إشعارات البريد الالكتروني';
$string['notloggedinroleid'] = 'الدور للزوار';
$string['numberofmissingstrings'] = 'عدد المقاطع المفقودة : {$a}';
$string['numberofstrings'] = 'إجمالي عدد الجُمل: {$a->strings}
المفقود: {$a->missing} ({$a->missingpercent}٪)';
$string['oauthrefreshtokenexpired'] = 'انتهت صلاحية ترميز التنشيط لإحدى خدمات OAuth {$a->issuer} في موقعك {$a->siteurl}. سيؤدي ذلك إلى تقييد وظائف أيّ إضافات تستعمل هذه الخدمة. لحل هذه المشكلة، قم بزيارة صفحة تهيئة خدمات OAuth 2 وانقر على أيقونة "ربط حساب النظام" في صف الجدول لهذه الخدمة. تأكد من تسجيل دخولك باستعمال حساب الخدمة نفسه لنظام OAuth في كل مرة.';
$string['oauthrefreshtokenexpiredshort'] = 'انتهت صلاحية ترميز التنشيط OAuth لـ {$a->issuer} في موقعك {$a->siteurl}.';
$string['onlynoreply'] = 'فقط عندما يكون من عنوان عدم الرد';
$string['opcacherecommended'] = 'تؤدي تخبئة شفرة PHP باستعمال opcode إلى تحسين الأداء وتقليل متطلبات الذاكرة. يوصى باستعمال الامتداد OPcache وهو مدعوم بالكامل.';
$string['opensslrecommended'] = 'تنصيب المكتبة OpenSSL الاختيارية يُنصح به بشدة -- إنها تتيح وظائف التشبيك لمودل.';
$string['opensslrequired'] = 'إن الامتداد OpenSSL PHP صار مطلوباً الآن من قِبل مودل لتوفير خدمات تشفير أقوى.';
$string['opentowebcrawlers'] = 'الانفتاح لمحركات البحث';
$string['optionalmaintenancemessage'] = 'رسالة الصيانة (إختيارية)';
$string['order1'] = 'الأول';
$string['order2'] = 'الثاني';
$string['order3'] = 'الثالث';
$string['order4'] = 'الرابع';
$string['outgoingmailconfig'] = 'تكوين البريد الصادر';
$string['overridetossl'] = 'تم الآن إهمال HTTPS لتسجيلات الدخول. هذه العيِّنة مجبورة الآن على SSL. لعلاج هذا التحذير، قم بتغيير wwwroot في الملف config.php إلى https://';
$string['pageinfodebugsummary'] = 'هذه الصفحة هي: {$a}';
$string['passwordchangelogout'] = 'تسجيل الخروج بعد تغيير كلمة المرور';
$string['passwordchangelogout_desc'] = 'في حالة التمكين ، عند تغيير كلمة المرور ، يتم إنهاء جميع جلسات المتصفح ، بصرف النظر عن الجلسة التي تم فيها تحديد كلمة المرور الجديدة. (لا يؤثر هذا الإعداد على تغييرات كلمة المرور من خلال تحميل المستخدم المجمع.)';
$string['passwordchangetokendeletion'] = 'إزالة ترميزات للوصول إلى خدمة الويب بعد تغيير كلمة المرور';
$string['passwordchangetokendeletion_desc'] = 'عند تمكينه، فتغيير كلمة المرور سيؤدي إلى حذف كل ترميزات الوصول إلى خدمة الويب للمستخدم.';
$string['passwordpolicy'] = 'سياسة كلمة المرور';
$string['passwordpolicycheckonlogin'] = 'فحص كلمة المرور عند الدخول';
$string['passwordresettime'] = 'الحد الأقصى للوقت للتحقق من صحة طلب إعادة تعيين كلمة المرور';
$string['passwordreuselimit'] = 'حد تدوير كلمة المرور';
$string['passwordreuselimit_desc'] = 'عدد المرات التي يجب على المستخدم تغيير كلمة المرور الخاصة به قبل السماح له بإعادة استخدام كلمة المرور. يتم تخزين تجزئة كلمات المرور المستخدمة مسبقًا في جدول قاعدة البيانات المحلية. قد لا تكون هذه الميزة متوافقة مع بعض المكونات الإضافية للمصادقة الخارجية.';
$string['pathtodot'] = 'المسار إلى dot';
$string['pathtodot_help'] = 'المسار إلى dot. في بيئة لينكس، ربما شيء مثل /usr/bin/dot. في وندوز، هي شيء مماثل لـ C:\\Program Files (x86)\\Graphviz2.38\\bin\\dot.exe. في بيئة ماك، ستكون ستكون مماثلة لـ /opt/local/bin/dot.
لتكون قادراً على توليد الرسومات من ملفات DOT، يجب تنصيب الملف التنفيذي dot والإشارة إليه هنا.';
$string['pathtodu'] = 'المسار إلى du';
$string['pathtogs'] = 'مسار ghostscript';
$string['pathtogs_help'] = 'في معظم تنصيبات لينكس، يمكن ترك هذا كـ \'/usr/bin/gs\'. في نظام التشغيل Windows، سيكون هناك شيء مثل \'c:\\gs\\bin\\gswin32c.exe\' (تأكد من عدم وجود مسافات في المسار - إذا لزم الأمر، إنسخ الملفين \'gswin32c.exe\' و \'gsdll32.dll\' إلى مجلد جديد بدون فراغ في المسار)';
$string['pathtopdftoppm'] = 'المسار إلى pdftoppm';
$string['pathtopdftoppm_help'] = '<a href="https://poppler.freedesktop.org/">Poppler</a> هي مكتبة استدعاء PDF تتضمن الأداة pdftoppm لتحويل ملفات PDF إلى صيغة PNG. الأداء أفضل عادة من استعمال Ghostscript وبخاصة للملفات الكبيرة. إن كان موجودًا، سيتم استعمال  pdftoppm بدلاً من Ghostscript. في أغلب تنصيبات لينكس، يمكن ترك المسار بالشكل \'/usr/bin/pdftoppm\'. بخلاف ذلك، أنت بحاجة إلى تنصيب poppler-utils أو حزمة poppler، إعتمادًا على تقليعة لينكس. في وندوز، سيتم توفيره عبر تنصيبات Cygwin.';
$string['pathtopgdump'] = 'مسار pg_dump';
$string['pathtopgdumpdesc'] = 'هذا ضروري فقط للدخول إذا كان لديك أكثر من pg_dump على النظام الخاص بك (على سبيل المثال إذا كان لديك أكثر من إصدار من postgresql مثبت)';
$string['pathtopgdumpinvalid'] = 'مسار غير صالح لـ pg_dump - إمّا المسار خاطئ أو غير قابل للتنفيذ';
$string['pathtophp'] = 'المسار إلى واجهة سطر الأوامر لـ PHP';
$string['pathtopsql'] = 'مسار psql';
$string['pathtopsqldesc'] = 'هذا ضروري فقط للدخول إذا كان لديك أكثر من psql على النظام (على سبيل المثال إذا كان لديك أكثر من إصدار واحد من postgresql مثبت)';
$string['pathtopsqlinvalid'] = 'مسار غير صالح لـ psql - إما المسار خاطئ أو غير قابل للتنفيذ';
$string['pathtopython'] = 'المسار إلى بايثون';
$string['pathtopythondesc'] = 'المسار إلى ثنائي بايثون القابل للتنفيذ (كل من بايثون 2 وبايثون 3 مقبولان).';
$string['pathtosassc'] = 'مسار SassC';
$string['pathtosassc_help'] = 'سيؤدي تحديد موقع ثنائي SassC إلى تبديل برنامج التحويل البرمجي SASS من تطبيق PHP الخاص بـ Moodle إلى SassC. أنظر https://github.com/sass/sassc لمزيد من المعلومات.';
$string['pcreunicodewarning'] = 'يوصى بشدة باستعمال الامتداد PCRE الخاص بـ PHP والذي يتوافق مع أحرف يونيكود.';
$string['perfdebug'] = 'معلومات الأداء';
$string['perfdebugdeferred'] = 'بانتظار إنتهاء النص البرمجي لإظهار رسائل تصحيح الأداء ...';
$string['performance'] = 'الأداء';
$string['pgcluster'] = 'الكتلة PostgreSQL';
$string['pgclusterdescription'] = 'معامل إصدار/كتلة لعمليات سطر الأوامر الخاصة بـ PostgreSQL. إذا كان لديك تنصيب PostgreSQL واحدة فقط في نظامك أو لم تكن متأكدًا من ماهية هذا، أترك هذا فارغًا.';
$string['phpfloatproblem'] = 'الكشف عن مشكلة غير متوقعة في التعامل مع  الأرقام العائمة PHP - {$a}';
$string['pid'] = 'مُعرَّف العملية';
$string['pleaserefreshregistration'] = 'موقعك تم تسجيله مع moodle.org، يرجى النظر في تحديث التسجيل إذا حدث تغييرات كبيرة منذ التحديث الأخير، على  {$a}';
$string['pleaserefreshregistrationnewdata'] = 'تم تغيير معلومات التسجيل. يرجى تأكيد ذلك باستخدام زر "تحديث التسجيل".';
$string['pleaserefreshregistrationunknown'] = 'تم تسجيل موقعك ولكن تاريخ التسجيل غير معروف. يرجى تحديث التسجيل الخاص بك باستخدام زر \'تحديث التسجيل\' أو التأكد من تمكين المهمة المجدولة \'تسجيل الموقع\' بحيث يتم تحديث تسجيلك تلقائياً.';
$string['plugin'] = 'الإضافة';
$string['plugin_disabled'] = '{$a} قد تم تعطيله';
$string['plugin_enabled'] = '{$a} قد تم تمكينه';
$string['plugins'] = 'الإضافات';
$string['pluginscheck'] = 'التحقق من تبِعات الإضافة';
$string['pluginscheckfailed'] = 'فشل التحقق من التبِعات {$a->pluginslist}';
$string['pluginschecktodo'] = 'ينبغي عليك حل كل متطلبات الإضافات قبل الشروع بتنصيب هذا الإصدار من مودل!';
$string['pluginsoverview'] = 'استعراض الإضافات';
$string['pluginsoverviewsee'] = 'أنظر صفحة <a href="{$a->url}">استعراض الإضافات</a> لمزيد من التفاصيل.';
$string['policysettings'] = 'إعدادات السياسة';
$string['privacy:metadata'] = 'لا يقوم إضافة الإدارة بتخزين أي بيانات شخصية.';
$string['privacyandpolicies'] = 'الخصوصية والسياسات';
$string['privacysettings'] = 'إعدادات الخصوصية';
$string['profilecategory'] = 'الفئة';
$string['profilecategoryname'] = 'اسم الفئة (ينبغي أن يكون فريداً)';
$string['profilecategorynamenotunique'] = 'اسم الفئة هذه موجود مسبقاً';
$string['profilecommonsettings'] = 'الإعدادات العامة';
$string['profileconfirmcategorydeletion'] = 'هناك مجالات {$a} في هذه الفئة التي سيتم نقلها إلى فئة أعلى (أو أقل إذا كانت في فئة أعلى) . <br/> هل لا تزال ترغب في حذف هذه الفئة ؟';
$string['profileconfirmfielddeletion'] = 'هناك {$a} سجل للمستخدم  لهذا المجال الذي سيتم حذفه. <br /> هل لا تزال ترغب في حذف هذا المجال ؟';
$string['profilecreatecategory'] = 'إنشاء فئة جديدة لحقول الملف الشخصي';
$string['profilecreatefield'] = 'إنشاء حقل ملف شخصي جديد';
$string['profilecreatenewcategory'] = 'إنشاء فئة جديدة';
$string['profilecreatenewfield'] = 'إنشاء حقل ملف تعريف \'{$a}\' جديد';
$string['profiledefaultcategory'] = 'حقول أخرى';
$string['profiledefaultchecked'] = 'فحص افتراضياً';
$string['profiledefaultdata'] = 'القيمة الافتراضية';
$string['profiledeletecategory'] = 'حذف الفئة';
$string['profiledeletefield'] = 'حذف الحقل  \'{$a}\'';
$string['profiledescription'] = 'وصف الحقل';
$string['profiledscript'] = 'التشكيل الجانبي لهذا البرنامج النصي';
$string['profiledscriptview'] = 'عرض معلومات التنميط لهذا النص البرمجي';
$string['profileeditcategory'] = 'تحرير الفئة: {$a}';
$string['profileeditfield'] = 'تحرير حقل الملف الشخصي: : {$a}';
$string['profilefield'] = 'حقل الملف الشخصي';
$string['profilefieldcolumns'] = 'الأعمدة';
$string['profilefieldispassword'] = 'هل هذا حقل كلمة مرور؟';
$string['profilefieldlink'] = 'الرابط';
$string['profilefieldlink_help'] = 'لتحويل النص إلى رابط، أدخل عنوان الرابط محتوياً على $$، حيث سيتم استبدال $$ بالنص. على سبيل المثال، لتحويل مُعرَّف تويتر إلى رابط، أدخل https://twitter.com/$$.';
$string['profilefieldlinktarget'] = 'مقصد الرابط';
$string['profilefieldmaxlength'] = 'محدد عدد الحروف';
$string['profilefieldmaxlength_help'] = 'لاستعمال هذا الحقل في الإعداد \'إظهار هوية المستخدم\'، ينبغي أن يكون عدد الحروف 255 أو أقل.';
$string['profilefieldrows'] = 'الصفوف';
$string['profilefields'] = 'حقول الملف الشخصي للمستخدمين';
$string['profilefieldsize'] = 'الحجم المعروض';
$string['profileforceunique'] = 'هل يجب أن تكون البيانات فريدة ؟';
$string['profileinvaliddata'] = 'قيمة غير صالحة';
$string['profilelocked'] = 'هل هذا الحقل مغلق ؟';
$string['profilemenudefaultnotinoptions'] = 'القيمة الافتراضية ليست إحدى الخيارات';
$string['profilemenunooptions'] = 'لم يتم التزويد بخيارات القائمة';
$string['profilemenuoptions'] = 'خيارات القائمة (خيار بكل سطر)';
$string['profilemenutoofewoptions'] = 'يجب عليك تقديم خيارين على الأقل';
$string['profilename'] = 'الاسم';
$string['profilenofieldsdefined'] = 'لم يتم تعريف الحقول';
$string['profilerequired'] = 'هل هذا الحقل مطلوب؟';
$string['profileroles'] = 'الأدوار ذات الملفات الشخصية المرئية';
$string['profilesforenrolledusersonly'] = 'الملف الشخصي للمستخدمين الملتحقين فقط';
$string['profileshortname'] = 'الاسم المختصر (ينبغي أن يكون فريداً)';
$string['profileshortnameinvalid'] = 'يمكن أن يحتوي هذا الاسم المختصر فقط على أحرف لاتينية؛ أبجدية رقمية (حروف وأرقام) أو الشرطة السفلية (_).';
$string['profileshortnamenotunique'] = 'الاسم المختصر هذا مستعمل سلفاً';
$string['profilesignup'] = 'هل تريد العرض في صفحة التسجيل؟';
$string['profilespecificsettings'] = 'الإعدادات الخاصة';
$string['profilevisible'] = 'لِمَن يكون هذا الحقل مرئياً؟';
$string['profilevisible_help'] = '* غير مرئي - للبيانات الخاصة المرئية فقط للمشرفين والمدراء
* مرئي للمستخدم - للبيانات الخاصة المرئية فقط للمستخدم وللمشرفين
* مرئي للمستخدم، للمعلمين وللمشرفين - للبيانات الخاصة المرئية فقط للمستخدم، للمعلمين وللمشرفين (في الملف الشخصي للمقرر الدراسي)
* مرئي للجميع';
$string['profilevisibleall'] = 'مرئي للكل';
$string['profilevisiblenone'] = 'غير مرئي';
$string['profilevisibleprivate'] = 'مرئي للمستخدم';
$string['profilevisibleteachers'] = 'مرئي للمستخدم، للمعلمين وللمشرفين';
$string['profiling'] = 'الجانبي';
$string['profilingallowall'] = 'التنميط المستمر';
$string['profilingallowall_help'] = 'إذا مكّنت هذا الإعداد، ثم، في أيّ لحظة، يمكنك استخدام المعامل PROFILEALL في أيّ مكان (PGC) لتمكين التشكيل الجانبي من تنفيذ البرامج النصية للجميع على طول فترة جلسة مودل. بشكل مشابه، يمكنك استخدام المعامل PROFILEALLSTOP لوقفه .';
$string['profilingallowme'] = 'التنميط الانتقائي';
$string['profilingallowme_help'] = 'إذا مكّنت هذا الإعداد، فعندها بشكل انتقائي، يمكنك استعمال المعامل PROFILEME في أيّ مكان يحدث فيه التنميط لذلك النص البرمجي و(PGC). بشكل مشابه، يمكنك استعمال المعامل DONTPROFILEME لمنع حدوث التنميط.';
$string['profilingautofrec'] = 'التنميط التلقائي';
$string['profilingautofrec_help'] = 'عبر تهيئة هذا الإعداد، طلب ما (عشوائيًا، استنادًا إلى التردد المحدد - 1 من N) سيتم اختياره وتنميطه تلقائيًا، وتخزين النتائج لمزيد من التحليل. لاحظ أن هذه الطريقة من التنميط تعاين تضمين/استبعاد الإعدادات. عيّنها إلى 0 لتعطيل التنميط التلقائي.';
$string['profilingenabled'] = 'تمكين التنميط';
$string['profilingenabled_help'] = 'إذا قمت بتمكين هذا الإعداد ، فسيكون التوصيف متاحًا في هذا الموقع وستكون قادرًا على تحديد سلوكه من خلال تكوين الخيارات التالية.';
$string['profilingexcluded'] = 'استبعاد التنميط';
$string['profilingexcluded_help'] = 'قائمة (مفصولة بفوارز أو بسطور، مطلقة بدون كلمة wwwroot، قابلة للاستدعاء) بالروابط التي سيتم استبعادها من التعريف بخلاف تلك التي يحددها الإعداد \'التعرف على هؤلاء\'.';
$string['profilingimportprefix'] = 'بادئة استيراد التنميط';
$string['profilingimportprefix_desc'] = 'لتسهيل الكشف ، سيتم بادئة جميع عمليات تشغيل ملفات التعريف المستوردة بالقيمة المحددة هنا.';
$string['profilingincluded'] = 'التعرف عليها';
$string['profilingincluded_help'] = 'قائمة (مفصولة بفوارز أو بسطور، مطلقة بدون كلمة wwwroot، قابلة للاستدعاء) بالروابط التي سيتم التعرف عليها تلقائياً. مثلاً: /index.php و /course/view.php. كما يتقبل أيضاً الحرف النائب (*) عند أي موضع. أمثلة ذلك: /mod/forum/* و  /mod/*/view.php.';
$string['profilinglifetime'] = 'الحفاظ على التنميط يعمل';
$string['profilinglifetime_help'] = 'تحديد الوقت الذي تريده للاحتفاظ بمعلومات حول تشغيلات التشكيل الجانبي القديمة . القديم منها سوف يكون مجرّدا بصفة دورية. لاحظ أن هذا لا يشمل أيّ تشغيل تشكيل جانبي وضع له علامة على أنه "تشغيل مرجعي".';
$string['profilingslow'] = 'التنميط يبطئ الصفحات';
$string['profilingslow_help'] = 'من خلال تحديد الحد الأدنى من الوقت بالثواني ، سيتم تصنيف جميع الصفحات الأبطأ. سيتم الاحتفاظ فقط بملفات التعريف التي تكون أبطأ من ملف التعريف الموجود للنص البرمجي نفسه. اضبط على 0 لتعطيل.
لاحظ أن هذا يشاهد إعدادات الاستبعاد.';
$string['protectusernames'] = 'حماية اسم المستخدم';
$string['proxybypass'] = 'المضيفين المتجاوزين للوكيل';
$string['proxyfixunsafe'] = 'إصلاح النداءات غير المارة عبر الوكيل';
$string['proxyhost'] = 'المضيف الوكيل';
$string['proxylogunsafe'] = 'توثيق النداءات غير المارة عبر الوكيل';
$string['proxypassword'] = 'كلمة مرور الوكيل';
$string['proxyport'] = 'منفذ الوكيل';
$string['proxytype'] = 'نوع الوكيل';
$string['proxyuser'] = 'اسم المستخدم للوكيل';
$string['purgecaches'] = 'تطهير كل المخبوءات';
$string['purgecachesconfirm'] = 'مودل يمكنه تخبئة القوالب، javascript، جُمل اللغة، النص المرشح، التغذية الإخبارية، وغيرها من البيانات المحسوبة. بتطهير هذه المخبوءات ستحذف تلك البيانات من المخدم وتفرض على المتصفحات إعادة جلبها، بحيث يمكنك التأكد من أنك ترى القيم الأكثر حداثة التي ينتجها البرنامج حالياً. ليس هناك خطر من تطهير المخبوءات ولكن قد يظهر موقعك أبطأ لفترة من الوقت حتى يحسب المخدم والعملاء المعلومات الجديدة ويعيدوا تخبئتها لديهم.';
$string['purgecachesfinished'] = 'تم تطهير كل المخبوءات.';
$string['purgecachesnoneselected'] = 'حدد خبأً واحداً أو أكثر للتطهير';
$string['purgecachespage'] = 'تطهير المخبوءات';
$string['purgecoursecache'] = 'المساقات';
$string['purgefiltercache'] = 'منقحات النص';
$string['purgejscache'] = 'JavaScript';
$string['purgelangcache'] = 'سلاسل اللغة';
$string['purgemuc'] = 'كل مخبوءات MUC';
$string['purgeothercaches'] = 'كل الملفات والمخبوءات المتنوعة';
$string['purgeselectedcaches'] = 'تطهير الخبء المحدد';
$string['purgeselectedcachesfinished'] = 'تم تطهير المخبوءات المحددة.';
$string['purgetemplates'] = 'القوالب';
$string['purgethemecache'] = 'قوالب';
$string['query'] = 'استعلام';
$string['question'] = 'السؤال';
$string['questionbehaviours'] = 'سلوك الأسئلة';
$string['questioncwqpfscheck'] = 'تم تعيين واحد أو أكثر من الأسئلة \'العشوائية\' في الاختبار بحيث ينتقي الأسئلة من خليط من أصناف الأسئلة المشتركة وغير المشتركة. أنظر <a href="{$a->reporturl}">تقرير الأسئلة العشوائية</a> و <a href="{$a->docsurl}">التوثيقات</a>.';
$string['questioncwqpfsok'] = 'جيدة. لا توجد أسئلة \'عشوائية\' في اختباراتك التي تم إعدادها لتحديد الأسئلة من خليط من أصناف الأسئلة المشتركة وغير المشتركة.';
$string['questiontype'] = 'نوع السؤال';
$string['questiontypes'] = 'أنواع الأسئلة';
$string['quizattemptsupgradedmessage'] = 'في Moodle 2.1 كانت هناك ترقية رئيسية للأسئلة. كان من الممكن تأخير أجزاء من ترقية قاعدة البيانات ليتم تشغيلها لاحقًا. قبل الترقية إلى Moodle 2.7 ، يجب إكمال هذه الترقية.';
$string['recaptchaprivatekey'] = 'المفتاح الخاص reCAPTCHA';
$string['recaptchapublickey'] = 'المفتاح العام reCAPTCHA';
$string['referrernone'] = 'الافتراضي للمتصفح';
$string['referrerpolicy'] = 'سياسة المُحيل';
$string['referrerpolicydesc'] = 'حدد مقدمة عنوان سياسة المُحيل ليتم تضمينها مع الردود الخارجة من موقعك.';
$string['register'] = 'سجّل موقعك';
$string['registration'] = 'تسجيل الموقع';
$string['registration_help'] = 'عند التسجيل:

* ستتلقى تنبيهات الأمان
* ستتمكن من تفعيل دفع الإشعارات إلى أجهزة الجوال من موقعك
* ستساهم في إحصائيات مودل للمجتمع في أرجاء المعمورة';
$string['registrationwarning'] = 'لا تفوتنك التحديثات الهامة وتنبيهات الأمان.';
$string['registrationwarningcontactadmin'] = 'موقعك غير مسجل بعد. يرجى إبلاغ المسؤول الخاص بك لتسجيله حتى لا تفوته التحديثات الهامة.';
$string['releasenoteslink'] = 'للحصول على معلومات عن هذا الإصدار من مودل، يرجى الاطلاع على <a target="_blank" href="{$a}">ملاحظات الإصدار</a>';
$string['rememberuserlicensepref'] = 'تذكر تفضيل رخصة المستخدم';
$string['rememberuserlicensepref_help'] = 'إذا تم تمكينه، فإن آخر رخصة استعمال منتخبة من قبل المستخدم سيتم اعتمادها عند رفع الملفات عبر ملتقط الملفات. بخلاف ذلك، ستكون رخصة الاستعمال الافتراضية في الموقع هي المعتمدة.';
$string['rememberusername'] = 'تذكر اسم المستخدم';
$string['rememberusername_desc'] = 'مكّنه إذا كنت تريد تخزين ملفات تعريف الارتباط الدائمة ذات أسماء المستخدمين خلال تسجيل دخول المستخدم . يمكن اعتبار ملفات تعريف الارتباط الدائمة مشكلة في الخصوصية إذا ما استعملت بدون موافقة.';
$string['replacefrontsearch'] = 'يستعمل للبحث عن المقررات الدراسية في صفحة الواجهة';
$string['reportsmanage'] = 'إدارة التقارير';
$string['required'] = 'مطلوب';
$string['requiredentrieschanged'] = 'ملاحظة: بعد الترقية، الإعداد \'الإدخالات مطلوبة قبل المعاينة\' مفروض منذ الآن في النشاطات الآتية لقاعدة البيانات:<br/>{$a->text}<br/>';
$string['requiremodintro'] = 'يتطلب وصف النشاط';
$string['requiremodintro_desc'] = 'إذا تم التمكين ، فسيضطر المستخدمون إلى إدخال وصف لكل نشاط.';
$string['requires'] = 'يتطلب';
$string['resetindentation'] = 'إعادة تعيين المحاذاة في عموم الموقع';
$string['resetindentation_help'] = 'هذا من شأنه إزالة أي محاذاة تم ضبطها سابقًا للمقررات في الموقع والتي بتنسيق {$a->format}.';
$string['resetindentation_title'] = 'أتريد إعادة تعيين المحاذاة في عموم الموقع؟';
$string['resetindentationsuccess'] = 'المحاذاة أُعيد تعيينها.';
$string['restorecourse'] = 'استعادة المقررات الدراسية';
$string['restorernewroleid'] = 'استعادة الأدوار في المقررات الدراسية';
$string['restorernewroleid_help'] = 'إذا كان المستخدم لا يملك مسبقاً صلاحية إدارة المقرر المستعاد حديثاً، يتم تعيين هذا الدور له تلقائياً وضمه إليه إن لزم الأمر. إختر "بلا" إذا كنت لا تريد جعل المستعيدين قادرين على إدارة كل مقرر مستعاد.';
$string['resultfilter'] = 'الترشيح حسب النتيجة';
$string['reverseproxy'] = 'عكس الوكيل';
$string['reverseproxyignore'] = 'تجاهل الملقمات الوكيلة العكسية';
$string['riskconfig'] = 'يمكن للمستخدمين تغيير سلوك وإعدادات الموقع';
$string['riskconfigshort'] = 'خطر التكوين';
$string['riskdataloss'] = 'يمكن للمستخدمين تدمير كميات كبيرة من المحتوى أو المعلومات';
$string['riskdatalossshort'] = 'خطر فقد البيانات';
$string['riskmanagetrust'] = 'يمكن للمستخدمين تغيير إعدادات الثقة للمستخدمين الآخرين';
$string['riskmanagetrustshort'] = 'إدارة الثقات';
$string['riskpersonal'] = 'يمكن للمستخدمين الوصول إلى المعلومات الخاصة بالمستخدمين الآخرين';
$string['riskpersonalshort'] = 'خطر على الخصوصية';
$string['riskspam'] = 'يمكن للمستخدمين إرسال بريد مزعج لمستخدمي الموقع أو لغيرهم';
$string['riskspamshort'] = 'خطر الرسائل المزعجة';
$string['riskxss'] = 'يمكن للمستخدمين إضافة ملفات ونصوص تسمح بهجمات النصوص عبر المواقع (XSS)';
$string['riskxssshort'] = 'خطر XSS';
$string['roleswithexceptions'] = '{$a->roles}،  مع {$a->exceptions}';
$string['rssglobaldisabled'] = 'معطل على مستوى الموقع';
$string['save'] = 'احفظ';
$string['savechanges'] = 'حفظ التغييرات';
$string['scssinvalid'] = 'ترميز SCSS غير صالح، يفشل مع: {$a}';
$string['search'] = 'البحث';
$string['searchablecourses'] = 'المقررات الدراسية القابلة للبحث';
$string['searchallavailablecourses'] = 'المقررات الدراسية القابلة للبحث';
$string['searchallavailablecourses_desc'] = 'في بعض الحالات، قد لا يعمل محرك البحث عند البحث في عدد كبير من المقررات الدراسية. أضبطه للبحث في المقررات الدراسية المنضم إليها فقط إذا كنت بحاجة إلى تقييد عدد المقررات التي يتم البحث فيها.';
$string['searchallavailablecourses_off'] = 'البحث ضمن المقررات الدراسية المنْضَم إليها فقط';
$string['searchallavailablecourses_on'] = 'البحث ضمن كل المقررات الدراسية التي يمكن للمستخدم الوصول إليها';
$string['searchallavailablecoursesdesc'] = 'إذا تم ضبطه للبحث ضمن المقررات الدراسية المنضم إليها فقط، فسيتم البحث في معلومات المقررات الدراسية (الاسم والملخص) ومحتوياتها من التي تم الانضمام إليها. وإلا، سيتم البحث في معلومات المقررات ومحتوياتها لكل المقررات التي يمكن للمستخدم الوصول إليها، مثل المقررات التي تسمح بدخول الضيف.';
$string['searchalldeleted'] = 'تم حذف جميع المحتويات المفهرسة';
$string['searchalternatesettings'] = 'الإعدادات البديلة لمجرد الاستعلام';
$string['searchalternatesettings_desc'] = 'إذا أكملتَ هذه الإعدادات، ستتمكن من تحديد \'الإعدادات البديلة\' لمحرك البحث هذا في خيار محرك البحث المتعلق بمجرد الاستعلام؛ عند صفحة \'إدارة البحث العمومي\'. هذا مفيد فقط عند الانتقال ما بين محركَي بحث من نفس النوع.';
$string['searchareadisabled'] = 'منطقة البحث معطلة';
$string['searchareaenabled'] = 'تمكين منطقة البحث';
$string['searchareas'] = 'مناطق البحث';
$string['searchbanner'] = 'معلومات البحث';
$string['searchbannerenable'] = 'عرض معلومات البحث';
$string['searchbannerenable_desc'] = 'عند تمكينه، النص أدناه سيتم عرضه في أعلى شاشة البحث لكل المستخدمين. يمكن استعماله لإبلاغ المستخدمين بمواعيد إجراء الصيانة لمحرك البحث.';
$string['searchdefaultcategory'] = 'فئة البحث الافتراضية';
$string['searchdefaultcategory_desc'] = 'سيتم عرض النتائج من فئة منطقة البحث المحددة افتراضيًا.';
$string['searchdeleteindex'] = 'حذف كل المحتويات المفهرسة';
$string['searchdisplay'] = 'خيارات عرض نتائج البحث';
$string['searchenablecategories'] = 'عرض النتائج في فئات منفصلة';
$string['searchenablecategories_desc'] = 'في حالة التمكين ، سيتم عرض نتائج البحث في فئات منفصلة.';
$string['searchengine'] = 'محرك البحث';
$string['searchenginealternatesettings'] = '{$a} (الإعدادات البديلة)';
$string['searchenginequeryonly'] = 'محرك البحث لمجرد الاستعلام';
$string['searchenginequeryonly_desc'] = 'محرك البحث هذا سيتم استعماله فقط لعمل الاستعلامات، وليس للفهرسة. باستعمال هذه الميزة، يمكنك إجراء الفهرسة بمحرك بحث مختلف، في الوقت الذي تستمر فيه استعلامات البحث القادمة من المستخدمين بالصدور منه.';
$string['searchenginequeryonly_none'] = 'لا أحد (استعمل محرك البحث الرئيسي للاستعلامات)';
$string['searchenginequeryonlysame'] = 'لا يمكن وضع محرك البحث لمجرد الاستعلام ومحرك البحث الرئيسي على قيمة واحدة.';
$string['searchhideallcategory'] = 'إخفاء فئة \'كل النتائج\'';
$string['searchhideallcategory_desc'] = 'إذا تم تحديده ، فسيتم إخفاء الفئة التي تحتوي على جميع النتائج على شاشة نتائج البحث.';
$string['searchincludeallcourses'] = 'شمول كل المقررات الدراسية المرئية';
$string['searchincludeallcourses_desc'] = 'عند تمكينه، ستتضمن نتائج البحث معلومات المقرر (الاسم والملخص) للمقررات الدراسية التي تكون مرئية للمستخدم، حتى لو لم يكن لديهم إمكانية الوصول إلى محتوى المقرر.';
$string['searchindexactions'] = 'إجراءات الفهرس';
$string['searchindexdeleted'] = 'تم حذف الفهرس';
$string['searchindextime'] = 'مهلة الفهرسة';
$string['searchindextime_desc'] = 'عند فهرسة كميات كبيرة من المحتوى الجديد، ستتوقف المهمة المجدولة بعد الوصول إلى هذا الحد الزمني. ستستمر في المرة القادمة التي تشتغل فيها المهمة.';
$string['searchindexupdated'] = 'تم تحديث محتويات محرك البحث';
$string['searchindexwhendisabled'] = 'الفهرس عند تعطيله';
$string['searchindexwhendisabled_desc'] = 'للسماح للمهمة المجدولة بإنشاء فهرس البحث حتى عند تعطيل البحث. هذا مفيد إذا كنت تريد إنشاء الفهرس قبل ظهور أداة البحث للطلاب.';
$string['searchinsettings'] = 'ابحث في الإعدادات';
$string['searchlastrun'] = 'التشغيل الأخير (الوقت ، # المستندات ، # السجلات ، # التجاهل)';
$string['searchmanagement'] = 'إدارة البحث';
$string['searchmanagement_desc'] = 'هذه الخيارات مفيدة عند إجراء تعديلات في المواقع ذات الفهارس العملاقة التي تستغرق وقتاً كبيراً لبنائها.';
$string['searchmaxtopresults'] = 'أقصى النتائج العليا';
$string['searchmaxtopresults_desc'] = 'أقصى عدد من النتائج العليا المراد عرضها فوق نتائج البحث بالنسبة إلى محتوى المقرر، المقررات الدراسية والمستخدمين.';
$string['searchnotavailable'] = 'البحث غير متاح';
$string['searchoptions'] = 'خيارات البحث';
$string['searchpartial'] = '(لم تتم فهرسته بالكامل بعد)';
$string['searchreindexed'] = 'جميع محتويات الموقع قد تم اعادة توصيفها.';
$string['searchreindexindex'] = 'إعادة فهرسة جميع محتويات الموقع';
$string['searchresults'] = 'نتائج البحث';
$string['searchsetupinfo'] = 'إعداد البحث';
$string['searchteacherroles'] = 'أدوار المعلم';
$string['searchteacherroles_desc'] = 'حدد كل الأدوار التي تجعل بها المستخدمين يظهرون بمراتب أعلى في نتائج البحث.';
$string['searchtopresults'] = 'النتائج العليا';
$string['searchupdateindex'] = 'تحديث المحتويات المفهرسة';
$string['sectionerror'] = 'خطأ القسم!';
$string['secureforms'] = 'استخدم نماذج أمان إضافية';
$string['security'] = 'الأمان';
$string['selectsearchengine'] = 'إختر محرك البحث';
$string['server'] = 'المخدم';
$string['serverchecks'] = 'فحوصات المخدم';
$string['serverlimit'] = 'حدود المخدم';
$string['servicespage'] = 'رابط الخدمات والدعم';
$string['sessionautostartwarning'] = '<p>  الكشف عن خطأ جدّي في التكوين ، الرجاء إبلاغ مسؤول الخادم .</p><p>
 لتعمل بشكل صحيح ، مودل يتطلب من المسؤول تغيير إعدادات
PHP.</p><p>
<code>session.auto_start</code> يجب تعيينه إلى  <code>مغلق</code>.
 يتم التحكم في هذا الإعداد عن طريق تحرير ملف  <code>php.ini</code>, Apache/IIS <br />
للتكوين أو  <code>.htaccess</code> الملف الذي على الخادم .</p>';
$string['sessioncookie'] = 'لاحقة ملف تعريف الارتباط';
$string['sessioncookiedomain'] = 'نطاق ملف تعريف الارتباط';
$string['sessioncookiepath'] = 'مسار ملف تعريف الارتباط';
$string['sessionhandling'] = 'معالجة جلسة العمل';
$string['sessiontimeout'] = 'انتهاء المهلة';
$string['sessiontimeoutwarning'] = 'تنبيه نفاد الوقت';
$string['settingdependenton'] = 'قد يكون هذا الإعداد مخفيًا ، استنادًا إلى قيمة {$a}.';
$string['settingfileuploads'] = 'تحميل الملفات أمر يتطلبه التشغيل العادي. يرجى تمكينه من تهيئة PHP لمخدمك.';
$string['settingmaxinputvars'] = 'من الموصى به أن يكون الإعداد max_input_vars في PHP على الأقل بقيمة 5000.';
$string['settingmaxinputvarsrequired'] = 'ينبغي أن يكون الإعداد max_input_vars في PHP على الأقل بقيمة 5000.';
$string['settingmemorylimit'] = 'تم الكشف عن ذاكرة غير كافية، يرجى تعيين  حد أعلى للذاكرة في إعدادات PHP.';
$string['settingsafemode'] = 'مودل غير متوافق تماماً مع الوضع الآمن، الرجاء أطلب من المسؤول عن المخدم إيقافه. تشغيل مودل بالوضع الآمن غير معتمد، فضلاً توقع مشاكل مختلفة إذا شغلته هكذا.';
$string['settingzendexceptionignoreargs'] = 'من الموصى به بشدة تمكين إعداد PHP المسمى zend.exception_ignore_args بمثابة إحتياط أمني.';
$string['setupsearchengine'] = 'إعداد محرك البحث';
$string['showcommentscount'] = 'أظهر عدد التعليقات';
$string['showdetails'] = 'اظهر التفاصيل';
$string['showuseridentity'] = 'اظهر هوية المستخدم';
$string['showuseridentity_desc'] = 'عند اختيار المستخدمين أو البحث عنهم، وعند عرض قوائم المستخدمين، هذه الحقول قد يتم عرضها بالإضافة إلى الاسم الكامل. تظهر هذه الحقول فقط للمستخدمين الذين لديهم الإمكانية moodle/site:viewuseridentity؛ وهم إفتراضياً، المعلمون والمدراء. (هذا الخيار منطقي جداً إذا اخترت واحداً أو اثنين من الحقول الإجبارية في مؤسستك).

الحقول المؤشرة بعلامة * هي حقول ملف شخصي مخصصة. يمكنك اختيار هذه الحقول، ولكن هناك حاليًا بعض الشاشات التي لن تظهر فيها.';
$string['simplexmlrequired'] = 'الامتداد SimpleXML PHP صار مطلوباً من قِبل مودل.';
$string['sitemailcharset'] = 'حزمة الحروف';
$string['sitemaintenance'] = 'الموقع غير متاح بسبب الصيانة!';
$string['sitemaintenancemode'] = 'وضع الصيانة';
$string['sitemaintenanceoff'] = 'تم تعطيل وضع الصيانة والموقع يعمل بشكل طبيعي مجدداً.';
$string['sitemaintenanceon'] = 'موقعك حالياً في وضع الصيانة (فقط المشرفون يستطيعون الدخول إلى الموقع أو استعماله).';
$string['sitemaintenanceoncli'] = 'موقعك حالياً في وضع الصيانة عبر واجهة سطر الأوامر، لا يُسمح بالوصول إليه عبر الويب.';
$string['sitemaintenancetitle'] = '{$a} قيد الصيانة';
$string['sitemaintenancewarning'] = 'موقعك حالياً في وضع الصيانة (المشرفون فقط يستطيعون الدخول إلى الموقع). لإعادة الموقع إلى وضع التشغيل العادي، <a href="maintenance.php">عطّل وضع الصيانة</a>.';
$string['sitemaintenancewarning2'] = 'موقعك حالياً في وضع الصيانة (فقط المشرفون يستطيعون الدخول). لإعادة الموقع إلى وضع التشغيل العادي، <a href="{$a}">عطّل وضع الصيانة</a>.';
$string['sitemenubar'] = 'التنقل في الموقع';
$string['sitenameintitle'] = 'تضمين اسم الموقع في عنوان الصفحة';
$string['sitenameintitle_help'] = 'هذا الإعداد سيقوم بإلحاق اسم الموقع عند نهاية عنوان الصفحة. من الموصى به القيام بذلك لأن من شأنه تحسين إمكانية الوصول عبر السماح للمستخدمين بالتعرف السريع على الصفحة التي هم عندها حاليًا.';
$string['sitepolicies'] = 'إعدادات أمان الموقع';
$string['sitepolicy'] = 'رابط سياسة الموقع';
$string['sitepolicy_help'] = 'رابط سياسة الموقع والتي على كل مستخدميه الاطلاع والموافقة عليها قبل الشروع باستعماله. لاحظ أن هذا الإعداد سيكون مؤثراً فقط إذا تم ضبط معالج سياسة الموقع على وضعه الافتراضي.';
$string['sitepolicyguest'] = 'عنوان إتفاقية الموقع للضيوف';
$string['sitepolicyguest_help'] = 'إذا كانت لديك سياسة للموقع وترغب من كل الضيوف مشاهدتها والموافقة عليها قبل استعماله، فقم بتحديد عنوان صفحتها هنا، وإلا أترك هذا الحقل فارغاً. يمكن أن يحتوي هذا الإعداد على أيّ رابط عام. لاحظ أن هذا الإعداد له تأثير فقط إن كان معالج سياسة الموقع مضبوطاً على قيمته الافتراضية.';
$string['sitepolicyhandler'] = 'معالج سياسة الموقع';
$string['sitepolicyhandler_desc'] = 'يحدد هذا كيفية إدارة سياسات المستخدم وموافقاته. يمكّن المعالج الافتراضي (النواة) من تحديد عنوان رابط سياسة الموقع وعنوان رابط سياسة الموقع للضيوف. يتيح معالج السياسات تعيين سياسة الموقع وسياسة الخصوصية والسياسات الأخرى، كما أنه يمكّن من عرض موافقات المستخدمين وعند الضرورة، الموافقات نيابة عن القُصَّر.';
$string['sitepolicyhandlercore'] = 'الافتراضي (النواة)';
$string['sitepolicyhandlerplugin'] = '{$a->name} ({$a->component})';
$string['sitesectionhelp'] = 'عرض القسم عند أعلى الصفحة حيث يمكنك إضافة المحتوى المخصص.';
$string['sixtyfourbitsrequired'] = 'لقد تبين بأن موقعك لا يستعمل الإصدار 64 من PHP. يتطلب الأمر أن تقوم بترقية نظامك  (نظام التشغيل، PHP...) قبل تنصيب هذا الإصدار من مودل.';
$string['sixtyfourbitswarning'] = 'لقد تم اكتشاف أن موقعك لا يستعمل إصدار PHP 64 بت. يوصى بترقية موقعك لضمان التوافق في المستقبل.';
$string['slasharguments'] = 'استخدام الشرطة المائلة';
$string['slashargumentswarning'] = 'يوصى بتمكين استعمال معامل الشطبة المائلة. مستقبلاً ستكون مطلوبة. لمزيد من التفاصيل، راجع التوثيقات <a href="https://docs.moodle.org/en/admin/environment/slasharguments">استعمال معاملات الشطبات المائلة</a>.';
$string['smallscreensonly'] = 'الشاشات الصغيرة فقط';
$string['smtp'] = 'SMTP';
$string['smtpauthtype'] = 'نوع مصادقة SMTP';
$string['smtpdetail'] = 'إعدادات بروتوكول نقل البريد البسيط (SMTP) لإرسال البريد الإلكتروني.';
$string['smtphosts'] = 'مضيف SMTP';
$string['smtpmaxbulk'] = 'حد جلسة SMTP';
$string['smtppass'] = 'كلمة مرور SMTP';
$string['smtpsecure'] = 'أمان SMTP';
$string['smtpuser'] = 'اسم المستخدم SMTP';
$string['soaprecommended'] = 'تنصيب الامتداد الاختياري soap مفيد لخدمات الويب وبعض الإضافات الأخرى.';
$string['sort_fullname'] = 'الاسم الكامل للمقرر الدراسي';
$string['sort_idnumber'] = 'رقم مُعرَّف المقرر';
$string['sort_shortname'] = 'الاسم المختصر للمقرر الدراسي';
$string['sort_sortorder'] = 'إتجاه الفرز';
$string['spellengine'] = 'محرك التدقيق الإملائي';
$string['spelllanguagelist'] = 'دقق قائمة اللغة';
$string['splrequired'] = 'الامتداد PHP SPL صار مطلوباً من قِبل مودل.';
$string['stats'] = 'الإحصاءات';
$string['statsfirstrun'] = 'أقصى فترة للمعالجة';
$string['statsmaxruntime'] = 'الحد الأقصى للتشغيل';
$string['statsmoodleorg'] = 'الإحصاءات';
$string['statsruntimedays'] = 'عدد الأيام المزمع معالجتها';
$string['statsruntimestart'] = 'تشغيل عند';
$string['statsuserthreshold'] = 'عتبة المستخدم';
$string['stickyblocks'] = 'الكتل الدبِقة';
$string['stickyblockscourseview'] = 'صفحة المقرر';
$string['stickyblocksduplicatenotice'] = 'لو قمت بإضافة كتلة موجودة مسبقاً إلى صفحة معينة، سينتج ذلك تكرارها<br /> لن تكن الكتلة المثبَّتة قابلة للتحرير، ولكن يمكن تحرير الكتلة المكررة.';
$string['stickyblocksmymoodle'] = 'مودل الخاص بي';
$string['stickyblockspagetype'] = 'نوع الصفحة المراد تهيئتها';
$string['storedprogressbarcleanuptask'] = 'مهمة تطهير شريط التقدم المخزون';
$string['strictformsrequired'] = 'التحقق الصارم من الحقول المطلوبة';
$string['stripalltitletags'] = 'إزالة وسوم لغة HTML من كافة أسماء النشاطات';
$string['supportandservices'] = 'الدعم والخدمات';
$string['supportavailability'] = 'توافر الدعم الفني';
$string['supportcontact'] = 'الدعم بالاتصال';
$string['supportemail'] = 'البريد الالكتروني للدعم';
$string['supportemailsubject'] = 'طلب مساعدة الموقع - {$a}';
$string['supportname'] = 'اسم مُقدم الدعم';
$string['supportpage'] = 'رابط الاتصال بالدعم الفني للموقع';
$string['suspenduser'] = 'تعليق حساب المستخدم';
$string['swaggerui'] = 'واجهة المستخدم لـ REST مودل لبرمجة التطبيق (SwaggerUI)';
$string['switchlang'] = 'تبديل مجلد اللغة';
$string['systempaths'] = 'أدلة النظام';
$string['tablenosave'] = 'التغييرات في الجداول أعلاه يتم حفظها تلقائياً.';
$string['tablesnosave'] = 'التغييرات في الجداول أعلاه يتم حفظها تلقائياً.';
$string['tabselectedtofront'] = 'في الجداول ذات التبويبات، هل ينبغي أن يكون التبويب ذي الصف المحدد حاليًا ظاهرًا في المقدمة';
$string['tabselectedtofronttext'] = 'إحضار التبويب ذي الصف المحدد إلى الأمام';
$string['task_adhoc_concurrency_limit'] = 'حد تواتر المهمة المخصصة';
$string['task_adhoc_concurrency_limit_desc'] = 'أقصى عدد لمشغلات المهام المخصصة بشكل متزامن. إذا كان العدد مرتفعاً، فقد لا تعمل المهام المجدولة بانتظام عندما يكون هناك الكثير من مشغلات المهام المخصصة. سيؤدي ضبط الإعداد على 0 إلى تعطيل معالجة المهام المخصصة بالكامل.';
$string['task_adhoc_failed_retention'] = 'مهلة استبقاء المهمة المخصصة الفاشلة';
$string['task_adhoc_failed_retention_desc'] = 'أقصى فترة استبقاء للمهمة المخصصة الفاشلة في الطابور بمجرد استنفادها لعدد  إعادة المحاولة.';
$string['task_adhoc_max_runtime'] = 'فترة حياة المهمة المخصصة';
$string['task_adhoc_max_runtime_desc'] = 'عمر المهمة المخصصة قبل التحرر منها. من الموصى به أن تكون المهام المخصصة قصيرة الأمد نظراً لعدم وجود حد أقصى لعدد المهام المخصصة التي يمكن وضعها في طابور الانتظار. إذا كان هذا الرقم مرتفعاً جداً وكان لديك طابور انتظار كبير للمهام المخصصة، فقد لا يتم تشغيل المهام المجدولة بانتظام.';
$string['task_dbreads'] = 'قراءات قاعدة البيانات';
$string['task_dbstats'] = 'قاعدة البيانات';
$string['task_dbwrites'] = 'كتابات قاعدة البيانات';
$string['task_duration'] = 'المدة الزمنية';
$string['task_endtime'] = 'وقت الانتهاء';
$string['task_logmode'] = 'متى يتم تسجيل الوقوعات';
$string['task_logmode_all'] = 'تخزين مخرجات التسجيل من جميع الوظائف';
$string['task_logmode_desc'] = 'يمكنك اختيار متى ترغب بتسجيل وقوعات المهام. إفتراضيًا، يتم توثيق الوقوعات دائمًا. يمكنك تعطيل تسجيلها بالكامل، أو التغيير لمجرد توثيق المهام التي تفشل.';
$string['task_logmode_failonly'] = 'حفظ سجلات وقوعات المهام التي تفشل فقط';
$string['task_logmode_none'] = 'لا تسجل أي شيء';
$string['task_logoutput'] = 'مخرجات المهمة';
$string['task_logretainruns'] = 'إحتفظ بالأشواط';
$string['task_logretainruns_desc'] = 'عدد مرات تشغيل كل مهمة الذي من المزمع الاحتفاظ به. يتفاعل هذا الإعداد مع إعداد \'فترة الاستبقاء\': أيهما يتم الوصول إليه أولاً، سيتم تطبيقه.';
$string['task_logretention'] = 'فترة الاحتفاظ';
$string['task_logretention_desc'] = 'أقصى مدة للاحتفاظ بسجلات الوقوعات. يتفاعل هذا الإعداد مع إعداد \'الاحتفاظ بالتشغيل\': أيهما يتم الوصول إليه أولاً، سيتم تطبيقه.';
$string['task_logtostdout'] = 'عرض سجل الإخراج';
$string['task_logtostdout_desc'] = 'عند تشغيل المهام والتقاط المخرجات، ما إذا كان ينبغي أيضاً عرض المخرجات الملتقطة في أثناء تشغيل المهمة.';
$string['task_result'] = 'نتيجة';
$string['task_result:failed'] = 'فشل';
$string['task_scheduled_concurrency_limit'] = 'حد المهام المتزامنة المجدولة';
$string['task_scheduled_concurrency_limit_desc'] = 'عدد برامج تشغيل المهام المجدولة المسموح لها بالعمل بشكل متزامن. إذا كان الحد مرتفعاً، فقد يواجه المخدم حملاً عالياً مما يؤثر على الأداء. سيؤدي ضبطه على 0 إلى تعطيل معالجة المهام المجدولة تماماً.';
$string['task_scheduled_max_runtime'] = 'فترة حياة مُنَفِّذ المهمة المجدولة';
$string['task_scheduled_max_runtime_desc'] = 'عمر مُنَفِّذ المهمة المجدولة قبل تحريره.';
$string['task_starttime'] = 'وقت البدء';
$string['task_stats:dbreads'] = 'يقرأ {$a}';
$string['task_stats:dbwrites'] = 'يكتب {$a}';
$string['task_status'] = 'حالة المهمة';
$string['task_status_desc'] = 'إن المهمة \'{$a->name}\' {$a->status}. للتفاصيل أنظر {$a->class}{$a->extradescription} في <a href="{$a->gotourl}">المهام المجدولة</a>.';
$string['task_type:adhoc'] = 'مخصص';
$string['task_type:scheduled'] = 'مجدول';
$string['taskadmintitle'] = 'المهام';
$string['taskanalyticscleanup'] = 'تنظيف التحليلات';
$string['taskautomatedbackup'] = 'الحفظ الاحتياطي التلقائي';
$string['taskautomatedbackup_report'] = 'تقرير المحفوظات الاحتياطية التلقائية';
$string['taskbackupcleanup'] = 'إخلاء جداول الحفظ الاحتياطي، سجلات الوقوعات والملفات';
$string['taskbadgesadhoc'] = 'منح الشارة';
$string['taskbadgescron'] = 'إضافة المهمة المخصصة لمنح الشارات';
$string['taskbadgesmessagecron'] = 'المعالجة في الخلفية لإرسال إشعارات الشارات';
$string['taskblogcron'] = 'مزامنة المدونات الخارجية';
$string['taskcachecleanup'] = 'إزالة مدخلات الخبء منتهية الصلاحية';
$string['taskcachecron'] = 'المعالجة الخلفية للمخبوءات';
$string['taskcalendarcron'] = 'إرسال إشعارات التقويم';
$string['taskcheckforupdates'] = 'التحقق من التحديثات';
$string['taskcompletiondaily'] = 'علامة الانتهاء كما بدأت';
$string['taskcompletionregular'] = 'حساب بيانات الانتهاء العادية';
$string['taskcontextcleanup'] = 'تنظيف السياقات';
$string['taskcreatecontexts'] = 'إنشاء السياقات المفقودة';
$string['taskdeleteincompleteusers'] = 'حذف المستخدمين غير المكتملة حساباتهم';
$string['taskdeleteunconfirmedusers'] = 'حذف المستخدمين غير المؤكد تسجيلهم';
$string['taskeventscron'] = 'المعالجة الخلفية للأحداث';
$string['taskfiletrashcleanup'] = 'تنظيف الملفات في سلة المحذوفات';
$string['taskglobalsearchindex'] = 'فهرسة البحث العمومي';
$string['taskglobalsearchoptimize'] = 'تحسين فهرس البحث العالمي';
$string['taskgradecron'] = 'المعالجة الخلفية لسجل التقديرات';
$string['taskgradehistorycleanup'] = 'المعالجة الخلفية لتنظيف تاريخ جداول التقديرات';
$string['taskh5pcleanup'] = 'إزالة ملفات H5P غير المستعملة';
$string['tasklegacycron'] = 'معالجة مشغل الوظائف الدورية القديم للإضافات';
$string['tasklockcleanuptask'] = 'تصفير البيانات الوصفية للمهام المخصصة';
$string['tasklogcleanup'] = 'تنظيف سجلات المهام';
$string['tasklogging'] = 'تهيئة سجل وقوعات المهمة';
$string['tasklogs'] = 'سجلات وقوعات المهمة';
$string['taskmessagingcleanup'] = 'المعالجة الخلفية للرسائل';
$string['taskpasswordresetcleanup'] = 'تنظيف محاولات إعادة تعيين كلمة المرور';
$string['taskplagiarismcron'] = 'المعالجة الخلفية لمشغل الوظائف الدورية القديم في إضافات منع الانتحال';
$string['taskportfoliocron'] = 'المعالجة الخلفية لإضافات المحافظ';
$string['taskprocessing'] = 'معالجة المهمة';
$string['taskquestioncron'] = 'المعالجة الخلفية لتنظيف معاينات الأسئلة';
$string['taskquestionstatscleanupcron'] = 'المعالجة الخلفية لتنظيف مخبوءات إحصائيات السؤال';
$string['taskrefreshsystemtokens'] = 'تحديث رموز OAuth لحسابات الخدمة';
$string['taskregistrationcron'] = 'تسجيل الموقع';
$string['tasksendfailedloginnotifications'] = 'إرسال إشعارات تسجيل الدخول الفاشلة';
$string['tasksendnewuserpasswords'] = 'أرسل كلمات مرور المستخدمين الجدد';
$string['tasksessioncleanup'] = 'تنظيف الجلسات القديمة';
$string['taskstatscron'] = 'المعالجة في الخلفية للإحصاءات';
$string['tasktagcron'] = 'المعالجة في الخلفية للوسوم';
$string['tasktempfilecleanup'] = 'حذف الملفات المؤقتة التي لا معنى لها';
$string['tasktype'] = 'النوع';
$string['taskupdategeoip2file'] = 'تحديث ملف GeoIP';
$string['tempdatafoldercleanup'] = 'تنظيف ملفات البيانات المؤقتة الأقدم من';
$string['templates'] = 'القوالب';
$string['testoutgoingmailconf'] = 'اختبار تكوين البريد الصادر';
$string['testoutgoingmailconf_errorcommunications'] = 'تعذر على موقعك التواصل مع خادم البريد الخاص بك.
يرجى التحقق من تكوين البريد الصادر.';
$string['testoutgoingmailconf_fromemail'] = 'اسم المستخدم المُرسل أو بريده الالكتروني';
$string['testoutgoingmailconf_fromemail_help'] = 'هذا الحقل يحاكي إرسال الرسالة من ذلك المستخدم، ولكن مقدمة الرسالة المتعلقة بعنوان المُرسل في الرسائل الحقيقية المرسلة ستعتمد على إعدادات أخرى مثل: allowedemaildomains';
$string['testoutgoingmailconf_fromemail_invalid'] = 'اسم المستخدم المُرسل أو بريده الالكتروني خاطئان. ينبغي أن يكون بصيغة بريد الكتروني صحيح أو اسم مستخدم موجود بالفعل في مودل.';
$string['testoutgoingmailconf_message'] = 'هذه رسالة اختبار لتأكيد نجاحك في تهيئة البريد الصادر من موقعك. أُرسلت: {$a}';
$string['testoutgoingmailconf_sendtest'] = 'إرسال رسالة اختبار';
$string['testoutgoingmailconf_sentmail'] = 'أرسل هذا الموقع بنجاح رسالة اختبار إلى خادم البريد.
من: {$a->romemail}
إلى: {$a-> toenail}';
$string['testoutgoingmailconf_subject'] = '{$a->site}: رسالة اختبار. {$a->additional} مرسلة في: {$a->time}';
$string['testoutgoingmailconf_subjectadditional'] = 'الموضوع الإضافي';
$string['testoutgoingmailconf_toemail'] = 'إلى عنوان البريد الإلكتروني';
$string['testoutgoingmaildetail'] = 'ملاحظة: قبل الاختبار، يرجى حفظ التهيئة الخاص بك.
{$a}';
$string['testsiteupgradewarning'] = 'أنت تستعمل حالياً موقع الاختبار {$a}، لترقيته بشكل صحيح استعمل أداة واجهة سطر الأوامر';
$string['themedefinedinconfigphp'] = 'لا يمكن تغيير القالب بسبب ضبطه إلى {$a} في ملف التهيئة config.php.';
$string['themedesignermode'] = 'نمط مصمم القالب';
$string['themedesignermodewarning'] = 'تم تمكين وضع مصمم القالب. لا ينبغي تمكين هذا في مواقع الإنتاج لأنه يمكن أن يقلل الأداء بشكل كبير.';
$string['themeeditsettingsname'] = 'تحرير إعدادات القالب \'{$a}\'';
$string['themelist'] = 'قائمة القوالب';
$string['themeresetcaches'] = 'تنظيف مخبوءات القالب';
$string['themeselect'] = 'تغيير القالب';
$string['themeselector'] = 'القوالب';
$string['themesettingsadvanced'] = 'إعدادات القالب المتقدمة';
$string['themesettingscustom'] = 'إعدادات القالب المخصصة';
$string['themesettingsname'] = 'إعدادات القالب \'{$a}\'';
$string['themeusagereportname'] = 'تقرير استعمال القالب \'{$a}\'';
$string['therewereerrors'] = 'توجد أخطاء في بياناتك';
$string['thirdpartylibrary'] = 'مكتبة';
$string['thirdpartylibrarylocation'] = 'الموقع';
$string['thirdpartylibs'] = 'مكتبات الطرف الثالث';
$string['timezone'] = 'المنطقة الزمنية الافتراضية';
$string['timezoneforced'] = 'هذا تم فرضه من قبل مشرف الموقع';
$string['timezoneinvalid'] = 'التوقيت غير صالح "{$a}"';
$string['timezoneisforcedto'] = 'افرض على جميع المستخدمين استخدام';
$string['timezonenotforced'] = 'المستخدمين يمكنهم اختيار مناطقهم الزمنية';
$string['timezonephpdefault'] = 'التوقيت الافتراضي لـ ({$a}) بحسب PHP';
$string['timezoneserver'] = 'توقيت المُخدِّم ({$a})';
$string['tlswarning'] = 'لم يتم اكتشاف الامتداد PHP/cURL بدعم TLSv1.2. قد لا تعمل بعض الخدمات. نوصي بشدة بتحديث مكتبات TLS.';
$string['tokenduration'] = 'مدة بقاء الترميز المنشأ من قبل المستخدم';
$string['tokenduration_desc'] = 'طول الفترة الزمنية التي يكون فيها رمز خدمات الويب الذي أنشأه المستخدم (على سبيل المثال عبر تطبيق الهاتف المحمول) صالحًا.';
$string['tokenizerrecommended'] = 'ننصح بتنصيب إمتداد PHP Tokenizer الاختياري -- إنه يحسن أداء وظائف التشبيك في مودل.';
$string['tools'] = 'أدوات المشرف';
$string['toolsmanage'] = 'إدارة أدوات المشرف';
$string['unattendedoperation'] = 'عملية غير مراقبة';
$string['unbookmarkthispage'] = 'حذف الإشارة المرجعية للصفحة';
$string['unicoderequired'] = 'كل البيانات ينبغي تخزينها بنظام ترميز (UTF-8). بالنسبة للتنصيبات الجديدة، ينبغي ترميز قاعدة البيانات باستعمال UTF-8 ليكون الشكل الافتراضي للترميز. إذا كنت بصدد الترقية، ينبغي عليك اتباع عملية التحويل إلى UTF-8.';
$string['uninstallplugin'] = 'إلغاء التنصيب';
$string['unlockaccount'] = 'إلغاء قفل الحساب';
$string['unoconvwarning'] = 'إصدار unoconv الذي قمت بتنصيبه غير مدعوم.';
$string['unsupported'] = 'غير مدعوم';
$string['unsupporteddbfileformat'] = 'تستعمل قاعدة بياناتك نظام تنسيق الملفات Antelope. يتطلب الدعم الكامل لنظام UTF-8 في أنظمة MySQL و MariaDB نظام تنسيق الملفات Barracuda. الرجاء التحويل لنظام تنسيق الملفات Barracuda. انظر التوثيق <a href="https://docs.moodle.org/en/admin/environment/custom check/mysql full unicode support">الدعم الكامل لليونيكود في MySQL</a> لمعرفة التفاصيل.';
$string['unsupporteddbfilepertable'] = 'من أجل الدعم الكامل لـ UTF-8، كل من MySQL و MariaDB يتطلبان منك تغيير الإعداد في MySQL المسمى \'innodb_file_per_table\' إلى حالة \'ON\'. للمزيد من التفاصيل أنظر التوثيق.';
$string['unsupporteddblargeprefix'] = 'من أجل الدعم الكامل لـ UTF-8، كل من MySQL و MariaDB يتطلبان منك تغيير الإعداد في MySQL المسمى \'innodb_large_prefix\' إلى حالة \'ON\'. للمزيد من التفاصيل أنظر التوثيق.';
$string['unsupporteddbstorageengine'] = 'محرك تخزين قاعدة البيانات المستعمل لم يعد معتمداً.';
$string['unsupporteddbtablerowformat'] = 'جداول قاعدة بياناتك تستعمل تنسيق الملفات Antelope. من المفضل تحويل الجداول إلى تنسيق الملفات Barracuda. للمزيد من التفاصيل حول تحويل جداول InnoDB إلى تنسيق Barracuda انظر التوثيقات <a href="https://docs.moodle.org/en/cli">الإدارة من سطر الأوامر</a>.';
$string['unsupportedphpversion7'] = 'الإصدار 7 من لغة PHP وما بعده غير مدعوم.';
$string['unsupportedphpversion71'] = 'الإصدار 7.1 من لغة PHP وما بعده غير مدعوم.';
$string['unsupportedphpversion72'] = 'الإصدار 7.2 من لغة PHP وما بعده غير مدعوم.';
$string['unsupportedphpversion73'] = 'الإصدار 7.3 من لغة PHP وما بعده غير مدعوم.';
$string['unsupportedphpversion74'] = 'الإصدار 7.4 من لغة PHP وما بعده غير مدعوم.';
$string['unsupportedphpversion80'] = 'الإصدار 8.0 من PHP وما بعده غير مدعوم.';
$string['unsupportedphpversion81'] = 'الإصدار 8.1 من PHP وما بعده غير مدعوم.';
$string['unsupportedphpversion82'] = 'الإصدار 8.2 من PHP فما بعده ليس مدعومًا.';
$string['unsupportedphpversion83'] = 'إصدار PHP 8.3 وما بعده غير مدعوم.';
$string['unsupportedphpversion84'] = 'إصدار PHP 8.4 أو الأعلى منه غير مدعوم.';
$string['unsuspenduser'] = 'تفعيل حساب المستخدم';
$string['updateaccounts'] = 'حدّث الحسابات الموجودة';
$string['updateautocheck'] = 'تحقق تلقائياً من وجود التحديثات';
$string['updateautocheck_desc'] = 'عند تمكينه، سيتحقق موقعك تلقائياً من وجود تحديثات لبرمجة مودل وإضافاته. في حالة وجود تحديثات متاحة، سيتم إشعار مشرف الموقع.';
$string['updateavailable'] = 'هناك إصدار أحدث من مودل!';
$string['updateavailable_moreinfo'] = 'المزيد من المعلومات ...';
$string['updateavailable_release'] = 'مودل {$a}';
$string['updateavailable_version'] = 'الإصدار {$a}';
$string['updateavailabledetailslink'] = 'أنظر {$a->url} لمزيد من التفاصيل';
$string['updateavailableforplugin'] = 'تتوفر إصدارات جديدة لبعض الإضافات!';
$string['updateavailableinstall'] = 'تنصيب هذا التحديث';
$string['updateavailableinstallall'] = 'تنصيب التحديثات ({$a}) المتاحة.';
$string['updateavailableinstallallhead'] = 'يجري تنصيب التحديثات المتاحة';
$string['updateavailablenot'] = 'برنامج مودل لديك محدث إلى آخر إصدار!';
$string['updateavailablerecommendation'] = 'يوصى بشدة بتحديث موقعك إلى آخر إصدار للحصول على كل ما هو جديد من إصلاحات الأمان والأخطاء.';
$string['updatecomponent'] = 'حدّث العنصر';
$string['updateminmaturity'] = 'النضج المطلوب للنصوص البرمجية';
$string['updateminmaturity_desc'] = 'إخطار حول التحديثات المتوفرة فقط إذا كانت التعليمات البرمجية المتوفرة لديها مستوى نضج محدد على الأقل. يتم الإبلاغ عن تحديثات المكونات الإضافية التي لا تعلن مستوى نضج التعليمات البرمجية دائما بغض النظر عن هذا الإعداد.';
$string['updatenotificationfooter'] = 'موقع مودل {$a->siteurl} تمت تهيئته للتحري التلقائي عن التحديثات المتاحة. أنت تتلقى هذه الرسالة كمسؤول للموقع.
يمكنك تعطيل التحري التلقائي عن التحديثات المتاحة في إدارة الموقع / المخدم / إشعارات التحديث، أو يمكنك تخصيص إيصال هذه الرسالة عبر صفحة تفضيلاتك الشخصية.';
$string['updatenotifications'] = 'إشعارات التحديث';
$string['updatenotificationsubject'] = 'تحديثات متاحة لمودل ({$a->siteurl})';
$string['updatenotifybuilds'] = 'إبلاغ عن بنيات جديدة';
$string['updatenotifybuilds_desc'] = 'عند تمكينه، يتم الإبلاغ عن التحديثات المتاحة للتعليمات البرمجية لمودل وأيضاً عند توفر بناء جديد متاح للإصدار الحالي. البنايات هي تحسينات مستمرة من إصدار مودل معين. عادة ما يتم إطلاقها كل أسبوع. عند تعطيله، فالتحديث المتاح سيتم الإبلاغ عنه فقط عندما يكون هناك إصدار أعلى من إصدار مودل. لا تتأثر تدقيقات إصدارات الإضافات بهذا الإعداد.';
$string['upgradeerror'] = 'خطأ غير معروف في ترقية {$a->plugin} إلى الإصدار {$a->version}، لا يمكن المتابعة.';
$string['upgradeforumread'] = 'تمت إضافة ميزة جديدة في مودل 1.5 لتعقب المشاركات مقروءة / غير مقروءة . <br /> لاستخدام هذه الوظيفة تحتاج إلى <a href="{$a}"> تحديث جداولك </a>.';
$string['upgradeforumreadinfo'] = 'تمت إضافة ميزة جديدة في مودل 1.5 لتعقب المنشورات المقروءة/غير المقروءة. لاستعمال هذه الوظيفة تحتاج إلى تحديث جداولك بكل معلومات التتبع للمنشورات القائمة. إعتمادًا على حجم موقعك، هذا قد يستغرق وقتًا طويلاَ (ساعات) ويمكن أن يكون مكلفًا تمامًا لقاعدة البيانات، لذلك فمن الأفضل أن تقوم به خلال فترة الخمول. مع ذلك، موقعك سيستمر في العمل خلال هذه الترقية ولن يتأثر المستخدمون. بمجرد البدء بهذه العملية يجب أن تدعها إلى النهاية (أبقِ نافذة المتصفح مفتوحة). مع ذلك، إذا قمت بإيقاف العملية عن طريق إغلاق النافذة: لا تقلق، يمكنك البدء من جديد.<br /><br /> هل تريد أن تبدأ عملية الترقية الآن؟';
$string['upgradekeyreq'] = 'مفتاح الترقية مطلوب';
$string['upgradekeyset'] = 'مفتاح التحديث (اتركها فارغة إن لم ترغب بتحديده)';
$string['upgradelogs'] = 'للحصول على الوظائف الكاملة، تحتاج إلى ترقية السجلات القديمة للوقوعات. <a href="{$a}">مزيد من المعلومات </a>';
$string['upgradelogsinfo'] = 'تم مؤخرًا إجراء بعض التغييرات في الطريقة التي يتم بها تخزين سجلات الوقوعات. لتكون قادرًا على عرض كافة السجلات القديمة الخاصة بك على أساس كل نشاط، تحتاج إلى ترقية السجلات القديمة. اعتمادًا على موقعك، هذا قد يستغرق وقتًا طويلاً (على سبيل المثال عدة ساعات) ويمكن أن يكون مكلفًا تمامًا لقاعدة بيانات المواقع الكبيرة. بمجرد البدء بهذه العملية يجب أن تدعها إلى النهاية (عن طريق الحفاظ على نافذة المتصفح مفتوحة). لا تقلق - موقعك سوف يعمل بشكل جيد للناس الآخرين بينما تتم ترقية سجلات الوقوعات.<br /><br /> هل تريد ترقية سجلاتك الآن؟';
$string['upgradepluginsfirst'] = 'من الموصى به تنصيب كل التحديثات المتاحة أولاً';
$string['upgradepluginsinfo'] = 'تحديث الإضافات';
$string['upgradepluginsinfo_help'] = 'توجد تحديثات متاحة لبعض إضافاتك. ينبغي تنصيبها جميعاً قبل ترقية قاعدة بيانات مودل. إذا كان موقعك لا يدعم نشر التحديثات التلقائية، يجب عليك تنزيل وتنصيب الإصدارات الجديدة من الإضافات يدوياً في مخدمك.';
$string['upgradepluginsinfo_link'] = 'admin/upgradepluginsinfo';
$string['upgradesettings'] = 'الإعدادات الجديدة';
$string['upgradesettingsintro'] = 'تمت إضافة الإعدادات المبينة أدناه خلال آخر ترقية لمودل. قم بإجراء أي تغييرات ضرورية في الإعدادات الافتراضية ثم انقر زر \'حفظ التغييرات\' في أسفل هذه الصفحة.';
$string['upgradestalefiles'] = 'تم اكتشاف خليط من إصدارات مودل، لا يمكن الاستمرار بالترقية';
$string['upgradestalefilesinfo'] = 'تم إيقاف عملية تحديث لمودل لأنه تم الكشف عن نصوص PHP عائدة لاثنين على الأقل من الإصدارات الرئيسية من مودل في مجلده.

يمكن أن يسبب هذا مشاكل كبيرة لاحقا، لذلك من أجل الاستمرار، عليك التأكد من أن مجلد مودل يحتوي على ملفات من إصدار واحد فقط من مودل.

الطريقة الموصى بها لتنظيف مجلد مودل الخاص بك هي كما يلي:

* إعادة تسمية المجلد الحالي لمودل إلى "moodle_old"
* إنشاء مجلد جديد لمودل يحتوي فقط على الملفات القادمة إما من حزمة مودل القياسية المنزلة، أو من مستودع مودل في Git
* نقل ملف config.php الأصلي وأي إضافات غير قياسية من المجلد "moodle_old" إلى مجلد مودل الجديد

عندما يكون لديك مجلد نظيف لمودل، حدّث هذه الصفحة لاستئناف عملية تحديث مودل.

هذا التحذير غالبًا ما يحدث بسبب فك ضغط حزمة مودل القياسية على إصدار سابق من مودل. في حين أن هذا موافق للترقيات الطفيفة، لكنه غير موصى به بالمرة في الترقيات الرئيسية لمودل.

هذا التحذير يمكن أيضا أن يكون بسبب خروج ناقص أو عملية تحديث من مستودع Git، وفي هذه الحالة قد تضطر إلى مجرد انتظار العملية حتى اكتمالها، أو ربما تشغيل أمر التنظيف المناسب ثم إعادة العملية.

يمكنك العثور على مزيد من المعلومات عن توثيقات الترقية في <a href="{$a}">{$a}</a>';
$string['upgradestart'] = 'ترقية قاعدة بيانات مودل الآن';
$string['upgradesure'] = '<p>تم تغيير ملفات مودل الخاصة بك، وأنت على وشك ترقية مخدمك تلقائياً إلى هذا الإصدار:</p>
<p><strong>{$a}</strong></p>
<p>بمجرد القيام بذلك لا يمكنك الرجوع مرة أخرى. يرجى ملاحظة أن هذه العملية قد تستغرق وقتاً طويلاً.</p>
<p>هل تريد بالتأكيد ترقية هذا المخدم إلى هذا الإصدار؟</p>';
$string['upgradetimedout'] = 'انتهت مهلة الترقية ، يرجى إعادة تشغيل الترقية .';
$string['upgradingdata'] = 'ترقية البيانات';
$string['upgradinglogs'] = 'ترقية سجلات الوقوعات';
$string['upgradingversion'] = 'الترقية إلى إصدار جديد';
$string['upwards'] = 'إلى الأعلى';
$string['useblogassociations'] = 'تمكين الجمعيات';
$string['user'] = 'المستخدم';
$string['userbulk'] = 'إجراءات بالجملة على المستخدمين';
$string['userbulkdownload'] = 'تصدير المستخدمين بشكل';
$string['userdefaultpreferences'] = 'تفضيلات المستخدم الافتراضية';
$string['userfeedbackafterupgrade'] = 'بعد كل ترقية رئيسية';
$string['userfeedbackencouragement'] = '<p>مودل يتضمن ميزة تسمح للمستخدمين بالإدلاء بآرائهم عن برنامج مودل بواسطة موقع استبيان خارجي مستضاف لدى مؤسسة مودل. لن يتم تمرير أي بيانات شخصية إلى موقع الاستبيان.</p>
<p>إن مؤسسة مودل تسعى إلى الانفتاح والشفافية في ممارساتها التي تتضمن جمع البيانات. لذلك، نريد أن نتأكد من أنك على دراية بهذه الوظيفة ومسيطر عليها.</p>
<p>التعرف على آراء المستخدمين سيساعد مؤسسة مودل كثيراً في تطوير هذا البرنامج. لتمكين هذه الميزة، لطفاً قم بزيارة <a href="{$a}">إعدادات الإفادة</a>.</p>';
$string['userfeedbacknextreminder'] = 'التذكير بتقديم الإفادة لاحقاً';
$string['userfeedbacknextreminder_desc'] = 'متى علينا مطالبة المستخدم بتقديم رأيه مرة أخرى؟';
$string['userfeedbackperiodically'] = 'دورياً';
$string['userfeedbackremindafter'] = 'أظهر التذكير بعد';
$string['userfeedbackremindafter_desc'] = 'قم بتذكير المستخدمين مجدداً بشأن تقديم آرائهم بعد هذا العدد من الأيام.';
$string['userfiltersdefault'] = 'منقحات المستخدم الافتراضية';
$string['userfiltersdefault_desc'] = 'حدد المنقحات التي تريد عرضها في صفحة \'إجراءات بالجملة على المستخدمين\'. إضغط باستمرار على المفتاح Ctrl لتحديد عناصر متعددة. المنقحات غير المحددة ستبقى متاحة من رابط \'أظهر المزيد\'.';
$string['userimagesdisabled'] = 'الصور الشخصية للمتسخدم معطلة';
$string['userlist'] = 'تصفح قائمة المستخدمين';
$string['usermanagement'] = 'إدارة المستخدم';
$string['userpolicies'] = 'سياسات المستخدمين';
$string['userpreference'] = 'تفضيلات المستخدم';
$string['userquota'] = 'مساحة الملفات الخاصة';
$string['userquota_desc'] = 'الحد الأقصى لمقدار البيانات التي يمكن لكل مستخدم تخزينها في مساحة ملفاته الخاصة.';
$string['users'] = 'المستخدمون';
$string['usesitenameforsitepages'] = 'استخدام اسم الموقع لصفحات الموقع';
$string['usetags'] = 'تمكين وظيفة الوسوم';
$string['validateemptylineerror'] = 'الأسطر الفارغة غير صحيحة';
$string['validateerror'] = 'هذه القيمة غير صالحة';
$string['validateerrorlist'] = 'هذه الإدخالات غير صالحة: {$a}';
$string['validateiperror'] = 'عناوين IP هذه غير صالحة: {$a}';
$string['verifychangedemail'] = 'تقييد النطاقات عند تغيير البريد الإلكتروني';
$string['warningcurrentsetting'] = 'القيمة الحالية غير صالحة: {$a}';
$string['warningiconvbuggy'] = 'الإصدار الخاص بك من مكتبة iconv لا يدعم مبدل //IGNORE. ينبغي تنصيب إضافة المقاطع متعددة البايتات mbstring الذي يمكن استعماله بدلاً من مقاطع التنظيف التي تحتوي على أحرف UTF-8 غير صالحة.';
$string['webproxy'] = 'وكيل الويب';
$string['webproxyinfo'] = 'إملأ الخيارات التالية إذا كان مخدم مودل عندك غير قادر على الوصول إلى الإنترنت مباشرة. الوصول إلى الإنترنت مطلوب لتنزيل البيانات البيئة، حزم اللغات، مغذيات خدمة الأخبار، المناطق الزمنية، ... إلخ.<br/><em>الامتداد PHP cURL يوصى به بشدة.</em>';
$string['xmlrpcwebserviceenabled'] = 'لقد تم الكشف عن تمكين بروتوكول خدمة الويب XML-RPC في موقعك. هذه الميزة تعتمد على امتداد PHP XML-RPC وهذا الأخير لم يعد مدعومًا من قبل PHP.';
$string['yuicomboloading'] = 'تحميل YUI combo';
$string['ziprequired'] = 'مطلوب الآن امتداد PHP المضغوط عن طريق مودل ، معلومات-ZIP الملفات الثنائية أو مكتبة PclZip لا تستخدم بعد الآن.';
