<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'offlinequiz', language 'ar', version '5.0'.
 *
 * @package     offlinequiz
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['add'] = 'أضف';
$string['addarandomquestion'] = 'أسئلة عشوائية';
$string['addarandomquestion_help'] = 'يضيف مودل عشوائياً من أسئلة الخيارات المتعددة (أو إما الكل أو لا شيء من أسئلة الاختيارات المتعددة) إلى مجموعة الاختبار غير المتصل بالإنترنت الحالي. يمكن تحديد عدد الأسئلة المضافة. يتم اختيار الأسئلة من صنف الأسئلة الحالي (وتصنيفاته الفرعية في حالة تحديد ذلك).';
$string['addarandomselectedquestion'] = 'أضف سؤالاً مختاراً بشكل عشوائي ...';
$string['addlist'] = 'أضف قائمة';
$string['addnewpagesafterselected'] = 'إضافة فاصل صفحات بعد الأسئلة المحددة';
$string['addnewquestion'] = 'سؤال جديد';
$string['addnewquestionsqbank'] = 'أضف أسئلة الى الصنف {$a->catname}: {$a->link}';
$string['addnewuseroverride'] = 'أضف تجاوز لمستخدم';
$string['addpagebreak'] = 'إضافة فاصل صفحات';
$string['addpagehere'] = 'إضافة صفحة هنا';
$string['addparts'] = 'أضف مشاركين';
$string['addquestionfrombankatend'] = 'أضف من بنك الأسئلة عند نهاية الصفحة';
$string['addquestionfrombanktopage'] = 'أضف من من بنك الأسئلة الى الصفحة {$a}';
$string['addrandom'] = 'أضف عشوائياً {$a} سؤال/أسئلة من ذات الخيارات المتعددة';
$string['addrandomfromcategory'] = 'أسئلة عشوائية';
$string['addrandomquestion'] = 'أسئلة عشوائية';
$string['addrandomquestiontoofflinequiz'] = 'تجري إضافة أسئلة الى الاختبار غير المتصل بالإنترنت {$a->name} (group {$a->group})';
$string['addrandomquestiontopage'] = 'أضف سؤالاً عشوائياً الى الصفحة {$a}';
$string['addtoofflinequiz'] = 'أضف الى الاختبار غير المتصل بالإنترنت';
$string['addtoqueue'] = 'أضف الى طابور الانتظار';
$string['allinone'] = 'غير محدد';
$string['alllists'] = 'كل القوائم';
$string['allornothing'] = 'الكل أو لا شيء';
$string['allresults'] = 'أظهر كل النتائج';
$string['allstudents'] = 'اظهر كل الطلبة';
$string['alwaysavailable'] = 'متاح دائماً';
$string['analysis'] = 'تحليلات العنصر';
$string['answerform'] = 'ورقة الإجابة';
$string['answerformforgroup'] = 'نموذج الإجابة للمجموعة {$a}';
$string['answerforms'] = 'نماذج الإجابات';
$string['answerpdfxy'] = 'نموذج الإجابات ({$a}->maxquestions أسئلة / {$a}->maxanswers خيارات)';
$string['areyousureremoveselected'] = 'هل أنتَ متأكد من رغبتك في إزالة كل الأسئلة المختارة؟';
$string['attemptexists'] = 'المحاولة موجودة';
$string['attemptsexist'] = 'لم يعد بإمكانك إضافة الأسئلة أو حذفها.';
$string['attemptsnum'] = 'النتائج: {$a}';
$string['attemptsonly'] = 'أظهر الطلبة الذين لديهم نتائج فقط';
$string['attendances'] = 'الحاضرون';
$string['basicideasofofflinequiz'] = 'الأفكار الأساسية لعمل الاختبار غير المتصل بالإنترنت';
$string['blackwhitethreshold'] = 'عتبة تمييز البياض من السواد.';
$string['bulksavegrades'] = 'حفظ التقديرات';
$string['calibratescanner'] = 'قم بتعيير الماسح الضوئي';
$string['cannoteditafterattempts'] = 'لا يمكنك إضافة الأسئلة أو إزالتها لوجود نتائج مكتملة مسبقاً. ({$a})';
$string['category'] = 'الصنف';
$string['changed'] = 'تم تغيير النتيجة.';
$string['changeevaluationmode'] = 'غيِّر طريقة إجراء التقييم. ممكن فقط إذا سمح به المشرف.';
$string['checkparts'] = 'إجعل كل المشاركين حاضرين';
$string['checkuserid'] = 'تحقق من مُعرَّف المجموعة/المستخدم';
$string['chooseagroup'] = 'إختر مجموعة...';
$string['closebeforeopen'] = 'تعذر تحديث الاختبار غير المتصل بالإنترنت. لقد جعلت تاريخ الإغلاق قبل تاريخ الفتح.';
$string['closestudentview'] = 'أغلق صفحة معاينة المستخدم';
$string['closewindow'] = 'أغلق النافذة';
$string['cmmissing'] = 'وحدة المساق الخاصة بالاختبار غير المتصل بالإنترنت ذي المُعرَّف {$a} مفقودة';
$string['configblackwhitethreshold'] = 'يحدد عتبة التمييز ما بين البياض والسواد على قيمة تتراوح بين 1 و 99 - كلما زادت القيمة كلما زاد البياض المتوقع من البكسل المستورد ليتم التعرف عليه كبياض. أي قيمة خارج هذا المدى تؤدي إلى عدم تحويل السواد/البياض على الإطلاق.';
$string['configdecimalplaces'] = 'عدد المراتب الرقمية التي يجب عرضها بعد الفاصلة العشرية عند عرض الدرجات للاختبار غير المتصل بالإنترنت.';
$string['configdisableimgnewlines'] = 'يقوم هذا الخيار بتعطيل الأسطر الجديدة قبل الصور وبعدها في أوراق الأسئلة ذات صيغة pdf. تحذير: قد يؤدي هذا إلى مشاكل في التنسيق.';
$string['configexperimentalevaluation'] = 'التقييم التجريبي لأوراق الإجابة';
$string['configexperimentalevaluationdesc'] = 'لا تستعمله في التشغيل الإنتاجي! يُستعمل هذا الخيار في الفحوص التجريبية لخوارزمية التقييم الجديدة. إذا تم تحويل هذا الخيار إلى نعم، فسيمكنك تمكينه في خيارات عينة الاختبار غير المتصل بالإنترنت. نحن بشدة لا نشجع استعمال  هذا الخيار. لا يوجد دعم على الإطلاق بشأن البيانات المفقودة بسبب تمكين هذا الخيار.';
$string['configintro'] = 'القيم التي تقوم بتعيينها هنا ستكون بمثابة القيم الافتراضية لإعدادات الاختبارات الجديدة غير المتصلة بالإنترنت.';
$string['configkeepfilesfordays'] = 'حدد عدد الأيام التي يتم فيها الاحتفاظ بملفات الصور التي يتم رفعها إلى التخزين المؤقت. خلال هذا الوقت، تكون ملفات الصور متاحة في تقرير إدارة الاختبار غير المتصل بالإنترنت.';
$string['configonlylocalcategories'] = 'لا توجد أصناف أسئلة مشتركة مسموح بها.';
$string['configpapergray'] = 'قيمة بياض الورق، وهو المستعمل لتقييم أوراق الإجابة';
$string['configshuffleanswers'] = 'خلط الإجابات';
$string['configshufflequestions'] = 'إذا قمت بتمكين هذا الخيار، فسيتم تبديل ترتيب الأسئلة في مجموعات الاختبار غير المتصل بالإنترنت عشوائياً في كل مرة تقوم فيها بإعادة إنشاء المعاينة في التبويب "أنشئ النماذج".';
$string['configshufflewithin'] = 'إذا قمت بتمكين هذا الخيار، فسيتم خلط الأجزاء المكونة للأسئلة الفردية عشوائياً عند إنشاء نماذج الأسئلة والإجابات.';
$string['configuseridentification'] = 'صيغة تصف تعريف المستخدم. تُستعمل هذه الصيغة لتعيين نماذج الإجابات للمستخدمين في النظام. يجب أن يشير الجانب الأيمن من المعادلة إلى أحد حقول جدول المستخدمين في مودل.';
$string['confirmremovequestion'] = 'هل أنت متأكد من رغبتك في إزالة هذا السؤال {$a}؟';
$string['copy'] = 'نسخ';
$string['copyright'] = '<strong>تحذير: النصوص الموجودة في هذه الصفحة هي لمعلوماتك الشخصية فقط. مثل أي نصوص أخرى، تخضع هذه الأسئلة لقيود الحقوق الفكرية. لا يسمح لك بنسخها أو إظهارها للآخرين!</strong>';
$string['copyselectedtogroup'] = 'أضف الأسئلة المختارة إلى المجموعة: {$a}';
$string['copytogroup'] = 'أضف كل الأسئلة الى المجموعة: {$a}';
$string['correct'] = 'صحيحة';
$string['correcterror'] = 'حل الإشكال';
$string['correctforgroup'] = 'الإجابات الصحيحة للمجموعة {$a}';
$string['correctionform'] = 'التصحيح';
$string['correctionforms'] = 'نماذج التصحيح';
$string['correctionoptionsheading'] = 'خيارات التصحيح';
$string['correctupdated'] = 'نموذج التصحيح المحدث للمجموعة {$a}.';
$string['couldnotgrab'] = 'تعذر انتزاع الصورة {$a}';
$string['couldnotregister'] = 'تعذر تسجيل المستخدم {$a}';
$string['createcategoryandaddrandomquestion'] = 'أنشئ صنفاً وأضف سؤالاً عشوائياً';
$string['createlistfirst'] = 'أضف مشاركين';
$string['createofflinequiz'] = 'أنشئ النماذج';
$string['createpartpdferror'] = 'تعذر إنشاء نموذج PDF لقائمة المشاركين {$a}. قد تكون القائمة فارغة.';
$string['createpdf'] = 'النموذج';
$string['createpdferror'] = 'تعذر إنشاء نموذج المجموعة {$a}. ربما لا توجد أسئلة في المجموعة.';
$string['createpdffirst'] = 'أنشئ أولاً قائمة بصيغة PDF';
$string['createpdfforms'] = 'أنشئ النماذج';
$string['createpdfs'] = 'تنزيل النماذج';
$string['createpdfsparticipants'] = 'نماذج PDF لقائمة المشاركين';
$string['createquestionandadd'] = 'قم بإنشاء سؤال جديد وإضفه إلى الاختبار.';
$string['createquiz'] = 'أنشئ النماذج';
$string['csvfile'] = 'ملف CSV';
$string['csvformat'] = 'ملف نصي ذو قيمة مفصولة بفوارز (CSV)';
$string['csvplus1format'] = 'ملف نصي ذو بيانات خام (CSV)';
$string['csvpluspointsformat'] = 'ملف نصي مع نقاط (CSV)';
$string['darkgray'] = 'رمادي داكن';
$string['datanotsaved'] = 'تعذر حفظ الإعدادات';
$string['decimalplaces'] = 'المنازل العشرية';
$string['decimalplaces_help'] = 'عدد المراتب الرقمية التي يجب إظهارها بعد الفاصلة العشرية عند عرض الدرجات للاختبار غير المتصل بالإنترنت.';
$string['defaultpdffontsize_help'] = 'حجم الخط الافتراضي الذي ستستعمله كل النماذج';
$string['deletelistcheck'] = 'هل ترغب حقاً في حذف القائمة المحددة وكل ما فيها من مشاركين؟';
$string['deletepagecheck'] = 'هل ترغب حقاً في حذف الصفحات المحددة؟';
$string['deletepagesafterselected'] = 'إزالة فواصل الصفحات بعد الأسئلة المحددة';
$string['deletepartcheck'] = 'هل ترغب حقاً في حذف المشاركين المحددين؟';
$string['deleteparticipantslist'] = 'حذف قائمة المشاركين';
$string['deletepdfs'] = 'حذف المستندات';
$string['deleteresultcheck'] = 'هل ترغب حقاً في حذف النتائج المحددة؟';
$string['deleteselectedpart'] = 'حذف المشاركين المحددين';
$string['deleteselectedresults'] = 'حذف النتائج المحددة';
$string['deletethislist'] = 'حذف هذه القائمة';
$string['deleteupdatepdf'] = 'الحذف وتحديث نماذج PDF';
$string['difficultytitle'] = 'الصعوبة';
$string['difficultytitlea'] = 'الصعوبة أ';
$string['difficultytitleb'] = 'الصعوبة ب';
$string['difficultytitlediff'] = 'الفرق';
$string['disableimgnewlines'] = 'تعطيل السطور الجديدة قبل الصور وبعدها';
$string['disableimgnewlines_help'] = 'هذا الخيار يعطل وضع السطور الجديدة قبل الصور وبعدها في أوراق pdf للأسئلة.
تنبيه: قد يؤدي ذلك إلى مشاكل في التنسيق.';
$string['displayoptions'] = 'خيارات العرض';
$string['done'] = 'أُنجِز';
$string['downloadallzip'] = 'تنزيل كل الملفات بشكل ملف مضغوط';
$string['downloadpartpdf'] = 'تنزيل ملف PDF للقائمة \'{$a}\'';
$string['downloadpdfs'] = 'تنزيل المستندات';
$string['downloadresultsas'] = 'تنزيل النتائج بشكل:';
$string['dragtoafter'] = 'بعد {$a}';
$string['dragtostart'] = 'إلى البداية';
$string['editgroupquestions'] = 'تحرير أسئلة المجموعة';
$string['editgroups'] = 'تحرير مجموعات عدم الاتصال';
$string['editingofflinequiz'] = 'تحرير أسئلة المجموعة';
$string['editingofflinequiz_help'] = 'عند إنشاء اختبار بدون الاتصال، المفاهيم الأساسية هي:
<ul><li> يحتوي الاختبار بدون الاتصال على أسئلة موزعة على صفحة واحدة أو أكثر</li>
<li> بنك الأسئلة الذي يخزن نسخاً من كل الأسئلة منظم بشكل أصناف</li></ul>';
$string['editingofflinequizx'] = 'تحرير الاختبار بدون الاتصال: {$a}';
$string['editlist'] = 'تحرير القائمة';
$string['editlists'] = 'تحرير القوائم';
$string['editmaxmark'] = 'تعديل الدرجة العليا';
$string['editofflinequiz'] = 'تحرير الاختبار بدون الاتصال';
$string['editofflinesettings'] = 'تحرير إعدادات عدم الاتصال';
$string['editorder'] = 'تحرير الترتيب';
$string['editparticipants'] = 'تحرير المشاركين';
$string['editquestion'] = 'تحرير السؤال';
$string['editquestions'] = 'تحرير الأسئلة';
$string['editscannedform'] = 'تحرير النموذج الممسوح';
$string['editthislist'] = 'تحرير هذه القائمة';
$string['emptygroups'] = 'بعض مجموعات الاختبار غير المتصل فارغة. لطفاً، أضف بعض الأسئلة.';
$string['enroluser'] = 'ضم المستخدم';
$string['erroraccessingreport'] = 'ليس مسموحاً لك بمعاينة هذا التقرير.';
$string['errorreport'] = 'تقرير أخطاء الاستيراد';
$string['eventattemptdeleted'] = 'محاولة اختبار بدون اتصال تم حذفها';
$string['eventattemptpreviewstarted'] = 'استعراض محاولة اختبار بدون اتصال تم بدؤه';
$string['eventattemptreviewed'] = 'محاولة اختبار بدون اتصال تمت مراجعتها';
$string['eventattemptsummaryviewed'] = 'ملخص محاولة اختبار بدون اتصال تمت معاينته';
$string['eventattemptviewed'] = 'محاولة اختبار بدون اتصال تمت معاينتها';
$string['eventdocscreated'] = 'نماذج أسئلة وإجابات للاختبار بدون اتصال تم إنشاؤها';
$string['eventdocsdeleted'] = 'نماذج أسئلة وإجابات للاختبار بدون اتصال تم حذفها';
$string['eventeditpageviewed'] = 'صفحة تحرير اختبار بدون اتصال تمت معاينتها';
$string['eventofflinequizattemptsubmitted'] = 'محاولة إختبار بدون اتصال تم تسليمها';
$string['eventoverridecreated'] = 'تجاوز إختبار بدون اتصال تم إنشاؤه';
$string['eventoverridedeleted'] = 'تجاوز إختبار بدون اتصال تم حذفه';
$string['eventoverrideupdated'] = 'تجاوز إختبار بدون اتصال تم تحديثه';
$string['eventparticipantmarked'] = 'مشارك في اختبار غير متصل تم تأشيره يدوياً';
$string['eventquestionmanuallygraded'] = 'تقدير سؤال تم منحه يدوياً';
$string['eventreportviewed'] = 'تقرير اختبار بدون اتصال تمت معاينته';
$string['eventresultsregraded'] = 'تقديرات نتائج إختبار غير متصل تم إعادة منحها';
$string['everythingon'] = 'مُمَكَّنة';
$string['excelformat'] = 'جداول Excel (XLSX)';
$string['experimentalevaluation'] = 'التقييم التجريبي لأوراق الإجابة';
$string['experimentalevaluation_help'] = 'التقييم التجريبي لأوراق الإجابة';
$string['fileformat'] = 'تنسيق أوراق الأسئلة';
$string['fileformat_help'] = 'إختر ما إذا كنت تريد تخريج أوراق أسئلتك بصيغ PDF، DOCX أو TEX.
نماذج الإجابة وأوراق التصحيح سيتم توليدها دوماً بصيغة PDF.';
$string['fileprefixanswer'] = 'نموذج_إجابة';
$string['fileprefixcorrection'] = 'نموذج_تصحيح';
$string['fileprefixform'] = 'نموذج_أسئلة';
$string['fileprefixparticipants'] = 'قائمة_مشاركين';
$string['filesizetolarge'] = 'بعض ملفات صورك كبيرة الحجم. ستتم إعادة تحجيم الأبعاد خلال عملية التمييز. لطفاً، حاول إجراء المسح بدقة تتراوح ما بين 200 و 300 dpi ونمط الأسود والأبيض. هذا من شأنه تسريع عملية التمييز في المرة القادمة.';
$string['filterbytags'] = 'الترشيح حسب الوسوم...';
$string['fontsize'] = 'حجم الخط';
$string['forautoanalysis'] = 'للتحليل التلقائي';
$string['formforcorrection'] = 'نموذج التصحيح للمجموعة {$a}';
$string['formforgroup'] = 'نموذج الأسئلة للمجموعة {$a}';
$string['formforgroupdocx'] = 'نموذج الأسئلة للمجموعة {$a} (DOCX)';
$string['formforgrouplatex'] = 'نموذج الأسئلة للمجموعة {$a} (LATEX)';
$string['formsexist'] = 'تم إنشاء النماذج سابقاً.';
$string['formsexistx'] = 'تم إنشاء النماذج سابقاً. (<a href="{$a}">تنزيل النماذج</a>)';
$string['formsheetsettings'] = 'إعدادات النموذج';
$string['formspreview'] = 'استعراض النماذج';
$string['formwarning'] = 'لم يتم تعريف أي نماذج للإجابات. يرجى التواصل مع مشرفك.';
$string['fromquestionbank'] = 'من بنك الأسئلة';
$string['functiondisabledbysecuremode'] = 'تلك الوظيفة معطلة حالياً';
$string['generalfeedback'] = 'الإفادة العامة';
$string['generalfeedback_help'] = 'الإفادة العامة هي النص الذي يتم إظهاره بعد محاولة السؤال.
بخلاف الإفادة التي تختص بسؤال معين والتي تعتمد على الاستجابة المعطاة، يتم إظهار الإفادة العامة نفسها دائماً.';
$string['generatepdfform'] = 'توليد نموذج PDF';
$string['grade'] = 'منح الدرجة';
$string['gradedon'] = 'مقيَّم في';
$string['gradedscannedform'] = 'النموذج الممسوح مع التقديرات';
$string['gradeiszero'] = 'ملاحظة: أقصى علامة للاختبار غير المتصل هذا هي 0 درجة!';
$string['gradeswarning'] = 'درجات السؤال ينبغي أن تكون أرقاماً!';
$string['gradewarning'] = 'درجة السؤال ينبغي أن تكون رقماً!';
$string['gradingofflinequiz'] = 'التقديرات';
$string['gradingofflinequizx'] = 'التقديرات: {$a}';
$string['gradingoptionsheading'] = 'خيارات منح التقديرات';
$string['greeniscross'] = 'محسوبة بمثابة تقاطع';
$string['group'] = 'المجموعة';
$string['groupoutofrange'] = 'المجموعة كانت خارج المدى وتم استبدالها بالمجموعة أ';
$string['hasresult'] = 'النتيجة موجودة';
$string['hotspotdeletiontask'] = 'حذف نقاط الجذب';
$string['html'] = 'HTML';
$string['idnumber'] = 'رقم المُعرَّف';
$string['imagefile'] = 'ملف الصورة';
$string['imagenotfound'] = 'ملف الصورة: {$a} غير موجود!';
$string['imagenotjpg'] = 'الصورة ليست بصيغة jpg أو png: {$a}';
$string['imagickwarning'] = 'نفتقد imagemagick: أطلب من المشرف على موقعك أن ينصب مكتبة imagemagick والتحقق من المسار المؤدي إلى موضع ثتائي التحويل في إعدادات الترميز لمنقح TeX. لا يمكنك استيراد الملفات التي بصيغة TIF بدون imagemagick!';
$string['import'] = 'استيراد';
$string['importedon'] = 'مستورد في';
$string['importerror11'] = 'توجد نتيجة أخرى';
$string['importerror12'] = 'المستخدم غير مسجل';
$string['importerror13'] = 'لا بيانات للمجموعة';
$string['importerror14'] = 'تعذر الاستخراج';
$string['importerror15'] = 'تأشيرات غير واضحة';
$string['importerror16'] = 'خطأ الصفحة';
$string['importerror17'] = 'الصفحات غير مكتملة';
$string['importerror21'] = 'تعذر الاستخراج';
$string['importerror22'] = 'تأشيرات غير واضحة';
$string['importerror23'] = 'المستخدم ليس ضمن القائمة';
$string['importerror24'] = 'القائمة غير مكتشفة';
$string['importforms'] = 'استيراد نماذج الإجابات';
$string['importfromto'] = 'يجري استيراد {$a->from} إلى {$a->to} من أصل {$a->total}.';
$string['importisfinished'] = 'عملية الاستيراد للاختبار من غير الاتصال {$a} قد انتهت.';
$string['importlinkresults'] = 'الرابط إلى النتائج: {$a}';
$string['importlinkverify'] = 'الرابط إلى التحقق: {$a}';
$string['importmailsubject'] = 'إشعار استيراد الاختبار غير المتصل بالإنترنت';
$string['importnew'] = 'استيراد';
$string['importnew_help'] = '<p>
يمكنك استيراد صفحة ممسوحة منفردة أو ملفات لعدة صفحات ممسموحة ضمن أرشيف مضغوط بصيغة ZIP. ستقوم وحدة الاختبار بدون الاتصال بمعالجة ملفات الصور في الخلفية.
أسماء الملفات ليست ذات أهمية ولكنها ينبغي أن لا تحتوي على رموز خاصة كالعلامات. ينبغي أن تكون الصور بصيغة GIF، PNG أو TIF. يوصى باستعمال الدقة التي تتراوح ما بين 200 و 300 نقطة بالإنج.</p>';
$string['importnumberexisting'] = 'عدد النماذج المكررة: {$a}';
$string['importnumberpages'] = 'عدد الصفحات المستوردة بنجاح: {$a}';
$string['importnumberresults'] = 'عدد ما تم استيراده: {$a}';
$string['importnumberverify'] = 'عدد النماذج التي تستدعي التحقق: {$a}';
$string['importtimefinish'] = 'العملية انتهت: {$a}';
$string['importtimestart'] = 'العملية ابتدأت: {$a}';
$string['inconsistentdata'] = 'البيانات المتضاربة: {$a}';
$string['info'] = 'معلومة';
$string['infoshort'] = 'م';
$string['insecuremarkings'] = 'التأشيرات غير الواضحة تتطلب تصحيحًا يدويًا';
$string['insecuremarkingsforquestion'] = 'التأشيرات غير الواضحة تتطلب تصحيحًا يدويًا للسؤال';
$string['insertnumber'] = 'يرجى إدخال رقم التعريف الصحيح المؤشر من قبل الإطار الأزرق.';
$string['instruction1'] = 'سيتم مسح نموذج الإجابة هذا تلقائياً. رجاءً لا تقم بطيِّه أو تبقيعه. استعمل قلمًا أسود أو أزرق لتعليم الحقول:';
$string['instruction2'] = 'العلامات الواضحة فقط يمكن تفسيرها بشكل صحيح! إذا أردت تصحيح أي علامة، إملأ مربعها باللون بشكل كامل. سيتم تفسير هذا الحقل بمثابة مربع فارغ:';
$string['instruction3'] = 'المربعات المصححة لا يمكن تأشيراها مجددًا. لطفًا، لا تكتب شيئًا خارج المربعات.';
$string['introduction'] = 'المقدمة';
$string['invalidformula'] = 'صيغة التعرف على المستخدم خاطئة. ينبغي أن تكون الصيغة بشكل <prefix>[<#digits>]<suffix>=<db-field&>.';
$string['invalidnumberofdigits'] = 'عدد المراتب المستعملة خاطئ. يُسمح فقط بمراتب تتراوح ما بين 1 و 9.';
$string['invaliduserfield'] = 'حقل جدول المستخدمين المستعمل خاطئ.';
$string['invigilator'] = 'المراقب';
$string['ischecked'] = 'تم التحقق من المشاركة';
$string['isnotchecked'] = 'لم يتم التحقق من المشاركة';
$string['itemdata'] = 'عنصر البيانات';
$string['keepfilesfordays'] = 'الإبقاء على الملفات لأيام';
$string['letter'] = 'الحرف';
$string['lightgray'] = 'رمادي باهت';
$string['linktoscannedform'] = 'معاينة النموذج الممسوح';
$string['listnotdetected'] = 'تعذر اكتشاف الرمز الشريطي للقائمة!';
$string['logdeleted'] = 'تم حذف إدخال سجل الوقوعات {$a}.';
$string['logourl'] = 'عنوان رابط الشعار';
$string['logourldesc'] = 'عنوان رابط ملف الصورة المعروضة عن الزاوية العليا اليسرى من نماذج الإجابة، بمعنى آخر <b>http://www.yoursite.tld/mylogo.png</b> أو <b>../path/to/your/logo.png</b>. الحجم الأقصى المسموح به هو 520 × 140 بكسل. لا يمكن تقييم نماذج الإجابة إذا تجاوزت الصورة الحجم الأقصى!';
$string['lowertrigger'] = 'الحد الثاني السفلي';
$string['lowertriggerzero'] = 'الحد الثاني السفلي هو صفر';
$string['lowerwarning'] = 'الحد الأول السفلي';
$string['lowerwarningzero'] = 'الحد الأول السفلي هو صفر';
$string['marginwarning'] = 'يرجى طباعة ملفات PDF الآتية بدون هوامش إضافية!<br /> تجنب تسليم النسخ الضوئية إلى الطلبة.';
$string['marks'] = 'الدرجات';
$string['matrikel'] = 'رقم الطالب';
$string['maxgradewarning'] = 'التقدير الأقصى ينبغي أن يكون رقماً!';
$string['maxmark'] = 'الدرجة القصوى';
$string['membersinplist'] = '{$a->count} من المشاركين في <a href="{$a->url}">{$a->name}</a>';
$string['missingimagefile'] = 'نفتقد ملف الصورة';
$string['missingitemdata'] = 'الإجابات المفقودة للمستخدم {$a}';
$string['missinglogdata'] = 'يفتقر إلى بيانات سجل الوقوعات للنتيجة الموجودة،';
$string['missingquestion'] = 'يبدو أن هذا السؤال لم يعد موجوداً';
$string['missinguserid'] = 'يفتقر إلى الرقم التعريفي للمستخدم! تعذرت قراءة الرمز الشريطي!';
$string['modulename'] = 'اختبار غير متصل';
$string['modulename_help'] = 'هذه الوحدة تسمح للمعلم بتصميم إختبارات بدون الاتصال بالإنترنت تتضمن أسئلة متعددة الخيارات.
يُحتفظ بهذه الأسئلة في بنك أسئلة مودل ويمكن استعمالها مجددًا ضمن المقررات الدراسية، لا بل حتى فيما بينها.
يمكن تنزيل الاختبارت غير المتصلة بصيغة ملفات PDF، DOCX أو LaTeX. يؤشر الطلاب إجاباتهم على نماذج ورقية. يتم مسح أوراق الإجابات ومن ثم استيراد الإجابات إلى النظام.';
$string['modulenameplural'] = 'اختبارات غير متصلة';
$string['moodleprocessing'] = 'دع مودل يعالج البيانات';
$string['movecorners'] = 'قم بتغيير مواضع علامات الزوايا. استعمل السحب والإفلات.';
$string['moveselectedonpage'] = 'أنقل الأسئلة المحددة إلى الصفحة: {$a}';
$string['multianswersforsingle'] = 'إجابات متعددة لسؤال خيارات واحد';
$string['multichoice'] = 'متعدد الخيارات';
$string['multipleanswers'] = 'إختر جواباً واحداً على الأقل.';
$string['name'] = 'اسم الاختبار غير المتصل';
$string['neededcorrection'] = '<strong>إنتباه: بعض تأشيراتك تطلبت التصحيح اليدوي. ألقِ نظرة على المربعات الحمراء في الصورة الآتية.
<br />تضمن ذلك التدخل اليدوي من قبل المعلم وأدى إلى تأخير نشر نتائج الاختبار غير المتصل بالإنترنت!</strong>';
$string['newgrade'] = 'مُقَيَّم';
$string['newpage'] = 'صفحة جديدة';
$string['noattemptexists'] = 'لا توجد نتيجة';
$string['noattempts'] = 'لم يتم استيراد أي نتائج!';
$string['noattemptsonly'] = 'إظهار الطلاب الذين بلا نتائج فقط';
$string['nocourse'] = 'المساق ذي المُعرَّف {$a->course} الذي يعود له الاختبار غير المتصل ذي المُعرَّف {$a->offlinequiz} مفقود.';
$string['nogradesseelater'] = 'هذا الاختبار غير مُقيَّم بعد لـ {$a}. سيتم نشر النتائج هنا.';
$string['nogroupdata'] = 'لا بيانات مجموعة للمستخدم {$a}';
$string['nomcquestions'] = 'لا توجد أسئلة من نوع متعدد الخيارات في المجموعة {$a}!';
$string['noofflinequiz'] = 'ليس هناك اختبار بدون اتصال بالمُعرَّف {$a}!';
$string['nopages'] = 'لم يتم استيراد أي صفحات';
$string['noparticipantsfound'] = 'لم يتم العثور على أي مشاركين';
$string['nopdfscreated'] = 'لم يتم إنشاء أي مستندات!';
$string['noquestions'] = 'بعض مجموعات الاختبار بدون الاتصال بالإنترنت فارغة. لطفاً، أضف بعض الأسئلة.';
$string['noquestionselected'] = 'لم يتم اختيار أي أسئلة!';
$string['noquestionsfound'] = 'لا توجد أسئلة في المجموعة {$a}!';
$string['noquestionsonpage'] = 'صفحة فارغة';
$string['noresults'] = 'لا توجد نتائج.';
$string['noreview'] = 'ليس مسموحاً لك بمراجعة الاختبار غير المتصل هذا';
$string['noscannedpage'] = 'ليست هناك صفحة ممسوحة بالمُعرَّف {$a}!';
$string['notagselected'] = 'لم يتم اختيار أي وسم';
$string['nothingtodo'] = 'ليس هناك شيء للقيام به!';
$string['notxtfile'] = 'لا ملف نصي';
$string['notyetgraded'] = 'غير مُقَيَّم حتى الآن';
$string['nozipfile'] = 'لا ملف مضغوط';
$string['numattempts'] = 'عدد النتائج المستوردة: {$a}';
$string['numattemptsqueue'] = 'نماذج إجابات {$a} أضيفت إلى الطابور. سيتم إرسال بريد الكتروني إلى عنوانك بعد معالجة البيانات.';
$string['numattemptsverify'] = 'النماذج الممسوحة التي تنتظر التصحيح: {$a}';
$string['numberformat'] = 'ينبغي أن تكون القيمة رقماً ذي {$a} مراتب!';
$string['numbergroups'] = 'عدد المجموعات';
$string['numpages'] = '{$a} من الصفحات تم استيرادها';
$string['numquestionsx'] = 'الأسئلة: {$a}';
$string['numusersadded'] = '{$a} من المشاركين تمت إضافتهم';
$string['odsformat'] = 'جدول OpenDocument (ODS)';
$string['offlineimplementationfor'] = 'التطبيق غير المتصل بالإنترنت لـ';
$string['offlinequiz:addinstance'] = 'إضافة اختبار بدون الاتصال';
$string['offlinequiz:attempt'] = 'محاولة الاختبارات';
$string['offlinequiz:changeevaluationmode'] = 'إجعل من الممكن تغيير نمط التقييم. تحذير: لا تستعمله في الأنظمة الإنتاجية!';
$string['offlinequiz:createofflinequiz'] = 'إنشاء نماذج الاختبار بدون الاتصال';
$string['offlinequiz:deleteattempts'] = 'حذف نتائج الاختبار بدون الاتصال';
$string['offlinequiz:grade'] = 'منح تقديرات الاختبار بدون الاتصال يدوياً';
$string['offlinequiz:manage'] = 'إدارة الاختبارات بدون الاتصال';
$string['offlinequiz:preview'] = 'استعراض الاختبار بدون الاتصال';
$string['offlinequiz:view'] = 'معاينة معلومات الاختبار بدون الاتصال';
$string['offlinequiz:viewreports'] = 'معاينة تقارير الاختبار بدون الاتصال';
$string['offlinequizcloses'] = 'الاختبار بدون الاتصال يغلق';
$string['offlinequizcloseson'] = 'مراجعة الاختبار بدون الاتصال هذا ستغلق في {$a}';
$string['offlinequizisclosed'] = 'تم إغلاق الاختبار بدون الاتصال';
$string['offlinequizisclosedwillopen'] = 'تم إغلاق الاختبار بدون الاتصال (يفتح في {$a})';
$string['offlinequizisopen'] = 'الاختبار بدون الاتصال هذا مفتوح';
$string['offlinequizisopenwillclose'] = 'تم فتح الاختبار بدون الاتصال (يغلق في {$a})';
$string['offlinequizopenedon'] = 'الاختبار بدون الاتصال هذا يفتح في {$a}';
$string['offlinequizopens'] = 'الاختبار بدون الاتصال يفتح';
$string['offlinequizsettings'] = 'إعدادات عدم الاتصال';
$string['offlinequizwillopen'] = 'الاختبار بدون الاتصال يُفتح في {$a}';
$string['oneclickenrol'] = 'الانضمام بنقرة واحدة';
$string['oneclickenroldesc'] = 'إذا تم تفعيل هذا الخيار، سيكون للمعلمين إمكانية ضم المستخدمين بنقرة واحدة عند تصحيح نماذج الإجابات (وتجاهل خطأ "المستخدم ليس في المساق").';
$string['oneclickrole'] = 'الدور المعني بالانضمام بنقرة واحدة';
$string['oneclickroledesc'] = 'إختر الدور المعني بالانضمام بنقرة واحدة. يمكن فقط إختيار الأدوار ذات النموذج الأصلي "طالب".';
$string['onlylocalcategories'] = 'فقط أصناف الأسئلة المحلية';
$string['orderandpaging'] = 'الترتيب وتقسيم الصفحات';
$string['orderandpaging_help'] = 'الأرقام 10، 20، 30، ... المحاذية لكل سؤال تشير إلى ترتيب الأسئلة. تتزايد الأرقام بمقدار 10 لفسح المجال لإدراج المزيد من الأسئلة. لإعادة ترتيب الأسئلة، قم بتغيير الأرقام ثم انقر زر "إعادة ترتيب الأسئلة".

لإضافة فواصل صفحات بعد أسئلة معينة، قم بتأشير مربعات الاختيار المجاورة لها، ثم انقر زر "إضافة فواصل صفحات بعد الأسئلة المحددة".

لترتيب الأسئلة على امتداد عدد من الصفحات، أنقر زر إعادة ترتيب الصفحات، ثم اختر عدد الأسئلة التي ترغب بها في كل صفحة.';
$string['orderingofflinequiz'] = 'الترتيب وترقيم الصفحات';
$string['otherresultexists'] = 'توجد مسبقاً نتيجة مختلفة لـ {$a}. تم تجاهل الاستيراد! إحذف النتيجة أولاً.';
$string['outof'] = '{$a->grade} من الحد الأقصى البالغ {$a->maxgrade}';
$string['outofshort'] = '{$a->grade}/{$a->maxgrade}';
$string['overallfeedback'] = 'الإفادة الشاملة';
$string['overview'] = 'الاستعراض';
$string['overviewdownload_help'] = 'تنزيل الاستعراض';
$string['page-mod-offlinequiz-edit'] = 'تحرير صفحة الاختبار غير المتصل';
$string['page-mod-offlinequiz-x'] = 'أي صفحة من الاختبار غير المتصل';
$string['pagecorrected'] = 'تم استيراد الورقة المصححة لقائمة المشاركين';
$string['pageevaluationtask'] = 'تقييم ورقة الإجابة لملحق الاختبار بدون الاتصال';
$string['pageimported'] = 'تم استيراد ورقة قائمة المشاركين';
$string['pagenotdetected'] = 'تعذر اكتشاف الرمز الشريطي للصفحة!';
$string['pagenumberimported'] = 'تم استيراد الورقة {$a} لقائمة المشاركين';
$string['pagenumberupdate'] = 'تحديث رقم الصفحة';
$string['pagesizeparts'] = 'المشاركون الظاهرون في الصفحة الواحدة:';
$string['papergray'] = 'قيمة البياض للورقة';
$string['papergray_help'] = 'إذا كانت الأجزاء البيضاء من نماذج الإجابات الممسوحة ضوئياً داكنة جداً، يمكنك تصحيح الأمر عبر جعل هذه القيمة رصاصي داكن.';
$string['partcheckedwithoutresult'] = '<a href="{$a->url}">{$a->count} المشاركون المتحقق منهم والذين بلا نتائج</a>';
$string['partcheckedwithresult'] = '{$a} المشاركون المتحقق منهم الذين لهم نتائج';
$string['partial'] = 'جزئي';
$string['participants'] = 'المشاركون';
$string['participants_help'] = '<p>قوائم المشاركين مصممة للاختبار غير المتصلة الكبيرة ذات الأعداد الكبيرة من المشاركين. إنها تساعد المعلم في معرفة أي من الطلاب قد شارك في الاختبار وما إذا تم استيراد كل النتائج بشكل صحيح.
يمكنك إضافة المستخدمين إلى قوائم مختلفة. كل قائمة يمكنها أن تتضمن، على سبيل المثال، المشاركين المتواجدين في غرفة معينة. يمكن للمشاركين أن يكونوا أعضاءً في مجموعة خاصة. يمكن استعمال أداة التسجيل في المجموعات لإنشائها.
قوائم المشاركين يمكن تنزيلها بصيغة ملفات PDF، طباعتها وتأشيرها بتقاطعات تمامًا كما هو حال نماذج الإجابة الخاصة بالاختبار غير المتصل. بعد ذلك، يمكن رفعها والطلبة المؤشرين فيها سيتم اعتبارهم حاضرين في قاعدة البيانات.
لطفاً، تجنب تبقيع الرموز الشريطية لأنها تستعمل للتعرف على الطلبة.</p>';
$string['participantsinlists'] = 'المشاركون في القوائم';
$string['participantslist'] = 'قائمة المشاركين';
$string['participantslists'] = 'المشاركون';
$string['partimportnew'] = 'رفع قوائم المشاركين';
$string['partimportnew_help'] = '<p>
في هذا التبويب يمكنك رفع القوائم المعبأة بالمشاركين. يمكنك رفع ملفات ذات صفحة منفردة ممسوحة أو أكثر من ملف ذي عدة صفحات بشكل ملف مضغوط بصيغة ZIP. وحدة الاختبار غير المتصل ستعالج ملفات الصور في الخلفية.
أسماء الملفات ليست مهمة ولكنها ينبغي أن لا تحتوي حروفاً خاصة مثل العلامات. الصور ينبغي أن تكون بصيغة GIF، PNG أو TIF. يوصى باستعمال الدقة التي تتراوح بين 200 و 300 نقطة بالإنج.</p>';
$string['partuncheckedwithoutresult'] = '{$a} المشاركون غير المتحقق منهم الذين بلا نتائج';
$string['partuncheckedwithresult'] = '<a href="{$a->url}">{$a->count} المشاركون غير المتحقق منهم الذين لهم نتائج</a>';
$string['pdfdeletedforgroup'] = 'تم حذف النموذج الذي للمجموعة {$a}';
$string['pdfintro'] = 'معلومات إضافية';
$string['pdfintro_help'] = 'ستتم طباعة هذه المعلومات على الصفحة الأولى من أوراق الأسئلة وينبغي أن تتضمن معلومات عامة عن كيفية إملاء نموذج الإجابة.';
$string['pdfintrotext'] = '<b>كيف أقوم بالتأشير بشكل صحيح؟</b><br />سيتم مسح نموذج الإجابة هذا بشكل آلي. يرجى الحفاظ عليه خالياً من الطي ومن البقع. استعمل قلماً أسود أو أزرق لتأشير الحقول. إذا أردت تصحيح التأشير، إملأ المربع بالكامل باللون. ستتم ترجمة المربع المملوء وكأنه خالٍ.<br />';
$string['pdfintrotoolarge'] = 'المقدمة طويلة جداً (حدها الأقصى 2000 حرف).';
$string['pdfscreated'] = 'تم إنشاء نماذج PDF';
$string['pdfsdeletedforgroup'] = 'تم حذف النماذج التي للمجموعة {$a}';
$string['pearlywhite'] = 'أبيض لؤلؤي';
$string['pluginadministration'] = 'إدارة الاختبار غير المتصل';
$string['pluginname'] = 'الاختبار غير المتصل';
$string['point'] = 'نقطة';
$string['present'] = 'حاضر';
$string['preventsamequestion'] = 'منع الاستعمال المتعدد لنفس السؤال في المجموعات المختلفة';
$string['preview'] = 'استعراض';
$string['previewforgroup'] = 'استعراض المجموعة {$a}';
$string['previewquestion'] = 'استعراض السؤال';
$string['printstudycodefield'] = 'طباعة حقل رمز الدراسة في ورقة الأسئلة';
$string['printstudycodefield_help'] = 'عند تأشيره، ستتم طباعة حقل رمز الدراسة في الصفحة الأولى من أوراق الأسئلة.';
$string['privacy:data_folder_name'] = 'بيانات الاختبار غير المتصل';
$string['privacy:metadata:core_files'] = 'الاختبار غير المتصل يستعمل واجهة برمجة التطبيق الخاصة بالملفات لخزن أوراق الأسئلة المولدة، أوراق الإجابات وأوراق التصحيح فضلاً عن أوراق الإجابات المعبأة.';
$string['privacy:metadata:core_question'] = 'الاختبار غير المتصل يستعمل واجهة برمجة التطبيق الخاصة بالأسئلة لحفظ الأسئلة للاختبارات.';
$string['privacy:metadata:mod_quiz'] = 'الاختبار غير المتصل يستعمل واجهة برمجة التطبيق الخاصة بالاختبارات لحفظ نتائج الاختبارات.';
$string['privacy:metadata:offlinequiz'] = 'يحفظ جدول الاختبار غير المتصل كل المعلومات الخاصة بعيِّنة الاختبار غير المتصل';
$string['privacy:metadata:offlinequiz:course'] = 'عمود \'المساق\' في جدول الاختبار غير المتصل يحفظ المساق الذي يتواجد فيه هذا الاختبار';
$string['privacy:metadata:offlinequiz:decimalpoints'] = 'عدد المنازل العشرية المزمع إحتسابها في الدرجات';
$string['privacy:metadata:offlinequiz:disableimgnewlines'] = 'هل ينبغي تعطيل السطور الجديدة قبل الصور وبعدها';
$string['privacy:metadata:offlinequiz:docscreated'] = 'إذا تم إنشاء المستندات فهذا الحقل قيمته 1، وبخلاف ذلك قيمته 0';
$string['privacy:metadata:offlinequiz:fileformat'] = 'صيغة الملف المستعملة لطباعة أوراق الأسئلة، 0 تعني pdf، 1 تعني docx، 2 تعني LaTeX';
$string['privacy:metadata:offlinequiz:fontsize'] = 'حجم الخط في أوراق الأسئلة';
$string['privacy:metadata:offlinequiz:grade'] = 'التقدير يظهر أعلى مقدار من الدرجات يمكن الحصول عليها في الاختبار غير المتصل هذا';
$string['privacy:metadata:offlinequiz:id_digits'] = 'يحفظ عدد المراتب التي كانت في رقم المُعرَّف عند إنشاء أوراق الإجابات. هذا مطلوب لأغراض التوافق مع الإصدارات السابقة إذا تم رفع المقدار ما بين الإنشاء واستيراد أوراق الإجابات';
$string['privacy:metadata:offlinequiz:introformat'] = 'هذا الحقل غير مستعمل';
$string['privacy:metadata:offlinequiz:name'] = 'عمود \'name\' يخزن اسم الاختبار غير المتصل';
$string['privacy:metadata:offlinequiz:numgroups'] = 'عدد المجموعات التي في هذا الاختبار غير المتصل';
$string['privacy:metadata:offlinequiz:papergray'] = 'قيمة البياض للاختبار بدون الاتصال هذا';
$string['privacy:metadata:offlinequiz:pdfintro'] = 'المعلومات الإضافية التي تم إدراجها في أوراق الأسئلة عند البدء';
$string['privacy:metadata:offlinequiz:printstudycodefield'] = 'تفضيل ما إذا كان ينبغي وضع رمز الدراسة في صيغة السؤال. 1 تعني صح، 0 بخلافه.';
$string['privacy:metadata:offlinequiz:review'] = 'هذا العمود يحفظ معلومات عن كيفية إجراء المراجعة.';
$string['privacy:metadata:offlinequiz:showgrades'] = 'يحفظ ما إذا كان ينبغي طبع مقدار الدرجات المقدرة للسؤال في أوراق الأسئلة';
$string['privacy:metadata:offlinequiz:showquestioninfo'] = 'يحفظ ما إذا كان ينبغي عرض المعلومات عن الأسئلة، 0 تقابل لا، 1 تقابل المعلومات عن نوع السؤال، 2 تقابل المعلومات عن مقدار الإجابات الصحيحة';
$string['privacy:metadata:offlinequiz:showtutorial'] = 'يحفظ ما إذا كانت تنبغي مطالبة المشاركين باجتيار اختبار غير متصل تدريبي';
$string['privacy:metadata:offlinequiz:shufflequestions'] = 'تفضيل بشأن ما إذا كان ينبغي خلط الأسئلة عند إنشاء الاختبار غير المتصل؛ 1 تعني الخلط، 0 تعني خلاف ذلك';
$string['privacy:metadata:offlinequiz:time'] = 'عمود الوقت يحفظ تاريخ الاختبار غير المتصل';
$string['privacy:metadata:offlinequiz:timeclose'] = 'عمود وقت الإغلاق يحفظ متى أُغلق/سيُغلق الاختبار غير المتصل';
$string['privacy:metadata:offlinequiz:timecreated'] = 'عمود وقت الإنشاء يحفظ الوقت الذي إنشئ فيه الاختبار غير المتصل';
$string['privacy:metadata:offlinequiz:timemodified'] = 'عمود وقت التعديل يحفظ الوقت الذي تم فيه آخر تعديل للاختبار غير المتصل';
$string['privacy:metadata:offlinequiz:timeopen'] = 'عمود وقت الفتح يحفظ متى فُتح/سيُفتح الاختبار غير المتصل';
$string['privacy:metadata:offlinequiz_choices'] = 'هذا الجدول يحفظ المعلومات الخاصة بكل التقاطعات العائدة لكل الصفحات الممسوحة. تلك المعلومات مطلوبة لإنشاء النتائج فيما بعد بناءً على تلك التقاطعات';
$string['privacy:metadata:offlinequiz_choices:choicenumber'] = 'رقم الخيار لهذا السؤال';
$string['privacy:metadata:offlinequiz_choices:scannedpageid'] = 'الصفحة الممسوحة العائد لها هذا الخيار';
$string['privacy:metadata:offlinequiz_choices:slotnumber'] = 'خانة السؤال العائدة لهذا الخيار';
$string['privacy:metadata:offlinequiz_choices:value'] = 'هل تم اعتبار الخيار مؤشرًا بتقاطع. 0 تعني لا، 1 تعني نعم، 1- تعني غير مؤكد';
$string['privacy:metadata:offlinequiz_group_questions'] = 'هذا الجدول يحفظ كل الأسئلة لكل مجموعات الاختبار غير المتصل بالإنترنت';
$string['privacy:metadata:offlinequiz_group_questions:maxmark'] = 'أقصى عدد من النقاط التي بالإمكان إحرازها لهذا السؤال';
$string['privacy:metadata:offlinequiz_group_questions:offlinegroupid'] = 'مجموعة الاختبار غير المتصل التي يعود لها سؤال المجموعة هذا';
$string['privacy:metadata:offlinequiz_group_questions:offlinequizid'] = 'مُعرَّف الاختبار غير المتصل العائد له سؤال المجموعة هذا';
$string['privacy:metadata:offlinequiz_group_questions:page'] = 'الصفحة التي تمت فيها طباعة هذا السؤال في أوراق الإجابة';
$string['privacy:metadata:offlinequiz_group_questions:position'] = 'الموضع في الاختبار غير المتصل هذا';
$string['privacy:metadata:offlinequiz_group_questions:questionid'] = 'مُعرَّف السؤال المختار';
$string['privacy:metadata:offlinequiz_group_questions:slot'] = 'موضع السؤال في الاختبار';
$string['privacy:metadata:offlinequiz_groups'] = 'جدول المجموعات الذي نُظمت به الاختبارات غير المتصلة';
$string['privacy:metadata:offlinequiz_groups:answerfilename'] = 'اسم الملف الذي تم استعماله لحفظ ملف الإجابة';
$string['privacy:metadata:offlinequiz_groups:correctionfilename'] = 'اسم الملف الذي تم استعماله لحفظ ملف التصحيح';
$string['privacy:metadata:offlinequiz_groups:number'] = 'رقم المجموعة للاختبار غير المتصل هذا، 1 للمجموعة أ، 2 للمجموعة ب، وهكذا';
$string['privacy:metadata:offlinequiz_groups:numberofpages'] = 'عدد الصفحات المطلوبة لطباعة أوراق الإجابة';
$string['privacy:metadata:offlinequiz_groups:offlinequizid'] = 'مُعرَّف الاختبار غير المتصل المعني';
$string['privacy:metadata:offlinequiz_groups:questionfilename'] = 'اسم الملف المستعمل عند خزن ملف السؤال';
$string['privacy:metadata:offlinequiz_groups:sumgrades'] = 'مجموع كل التقديرات لجميع الأسئلة في هذه المجموعة';
$string['privacy:metadata:offlinequiz_groups:templateusageid'] = 'مُعرَّف القالب المستعمل لإنشاء النتيجة في واجهة برمجة التطبيق للاختبار';
$string['privacy:metadata:offlinequiz_hotspots'] = 'هذا الجدول يحفظ كل المواضع للمربعات وما إذا تم تقييمها بشكل صحيح';
$string['privacy:metadata:offlinequiz_hotspots:blank'] = 'ما إذا تم تحليل المنطقة المؤثرة بشكل صحيح';
$string['privacy:metadata:offlinequiz_hotspots:name'] = 'نوع المنطقة المؤثرة، مثل u%number لمنطقة مؤثرة خاصة بالمستخدم، a-0-0 للسؤال 1 الجواب 1، وهكذا';
$string['privacy:metadata:offlinequiz_hotspots:scannedpageid'] = 'الصفحة الممسوحة التي فيها المنطقة المؤثرة';
$string['privacy:metadata:offlinequiz_hotspots:time'] = 'وقت آخر تحديث لهذه المنطقة المؤثرة';
$string['privacy:metadata:offlinequiz_hotspots:x'] = 'قيمة الإحداثي س للمنطقة المؤثرة';
$string['privacy:metadata:offlinequiz_hotspots:y'] = 'قيمة الإحداثي ص للمنطقة المؤثرة';
$string['privacy:metadata:offlinequiz_p_choices'] = 'هذا الجدول يحفظ كل تأشيرات التقاطعات لقوائم المشاركين';
$string['privacy:metadata:offlinequiz_p_choices:scannedpageid'] = 'الصفحة الممسوحة ضوئياً التي يعود لها هذا الخيار';
$string['privacy:metadata:offlinequiz_p_choices:userid'] = 'مُعرَّف المستخدم العائد له هذا الخيار';
$string['privacy:metadata:offlinequiz_p_choices:value'] = 'ما إذا كان التقاطع مملوء أم لا (0 لغير المملوء، 1 للمملوء، -1 لغير الواضح).';
$string['privacy:metadata:offlinequiz_p_lists'] = 'هذا الجدول يحفظ معلومات عن قوائم المشاركين حيث يمكن للمعلمين التأشير عليه بتقاطعات للدلالة على ما إذا كان الطالب حاضرًا أم لا';
$string['privacy:metadata:offlinequiz_p_lists:filename'] = 'اسم الملف للقائمة';
$string['privacy:metadata:offlinequiz_p_lists:name'] = 'اسم قائمة المشاركين';
$string['privacy:metadata:offlinequiz_p_lists:number'] = 'رقم القائمة في الاختبار بدون الاتصال';
$string['privacy:metadata:offlinequiz_p_lists:offlinequizid'] = 'الاختبار بدون الاتصال الذي تعود له هذه القائمة';
$string['privacy:metadata:offlinequiz_page_corners'] = 'هذا الجدول يحفظ الزوايا لكل ورقة ممسوحة لتقييمها أو تصحيحها بشكل أسرع مستقبلاً';
$string['privacy:metadata:offlinequiz_page_corners:position'] = 'معلومة ما إذا كانت الزاوية في الأعلى أو الأسفل وفي اليمين أو اليسار';
$string['privacy:metadata:offlinequiz_page_corners:scannedpageid'] = 'الورقة الممسوحة التي فيها هذه الزاوية';
$string['privacy:metadata:offlinequiz_page_corners:x'] = 'قيمة الإحداثي س لهذه الزاوية';
$string['privacy:metadata:offlinequiz_page_corners:y'] = 'قيمة الإحداثي ص لهذه الزاوية';
$string['privacy:metadata:offlinequiz_participants'] = 'جدول المشاركين يحفظ ما إذا شارك المستخدم في الاختبار غير المتصل أم لا';
$string['privacy:metadata:offlinequiz_participants:checked'] = 'معلومة ما إذا تم تأشير هذا المستخدم ضمن قوائم المشاركين';
$string['privacy:metadata:offlinequiz_participants:listid'] = 'مُعرَّف القائمة التي يوجد فيها هذا المشارك';
$string['privacy:metadata:offlinequiz_participants:userid'] = 'مُعرَّف المستخدم';
$string['privacy:metadata:offlinequiz_queue'] = 'هذا الجدول يحفظ طابور عمليات الرفع. لكل عملية رفع هناك مكون عائد لها في هذا الجدول';
$string['privacy:metadata:offlinequiz_queue:importuserid'] = 'مُعرَّف المستخدم للمعلم الذي استورد الملفات';
$string['privacy:metadata:offlinequiz_queue:offlinequizid'] = 'مُعرَّف الاختبار غير المتصل للطابور';
$string['privacy:metadata:offlinequiz_queue:status'] = 'حالة الطابور المطلوب';
$string['privacy:metadata:offlinequiz_queue:timecreated'] = 'وقت استيراد أوراق الاختبار غير المتصل هذا';
$string['privacy:metadata:offlinequiz_queue:timefinish'] = 'وقت انتهاء تقييم طابور الاختبار غير المتصل';
$string['privacy:metadata:offlinequiz_queue:timestart'] = 'وقت بدء تقييم طابور الاختبار غير المتصل';
$string['privacy:metadata:offlinequiz_queue_data'] = 'هذا الجدول يحفظ البيانات للطابور حيث أن كل ملف في الطابور سيحصل على مكون بيانات خاص به ضمن الطابور';
$string['privacy:metadata:offlinequiz_queue_data:error'] = 'إذا كانت الحالة خطأ، فهنا ستوضع رسالة أكثر تفصيلاً عن الخطأ';
$string['privacy:metadata:offlinequiz_queue_data:filename'] = 'اسم الملف العائد له هذا الطابور';
$string['privacy:metadata:offlinequiz_queue_data:queueid'] = 'الطابور العائدة له هذه البيانات';
$string['privacy:metadata:offlinequiz_queue_data:status'] = 'حالة بيانات الطابور';
$string['privacy:metadata:offlinequiz_results'] = 'هذا الجدول يحفظ كل بيانات النتائج، والتي لا يتم حفظها في واجهة برمجة التطبيق للاختبار';
$string['privacy:metadata:offlinequiz_results:offlinegroupid'] = 'مجموعة الاختبار غير المتصل التي تعود لها هذه النتيجة';
$string['privacy:metadata:offlinequiz_results:offlinequizid'] = 'الاختبار غير المتصل الذي تعود لها هذه النتيجة';
$string['privacy:metadata:offlinequiz_results:status'] = 'حالة النتيجة (مكتملة أو غير مكتملة)';
$string['privacy:metadata:offlinequiz_results:sumgrades'] = 'مجموع كل التقديرات لهذه النتيجة';
$string['privacy:metadata:offlinequiz_results:teacherid'] = 'المعلم الذي رفع النتيجة';
$string['privacy:metadata:offlinequiz_results:timefinish'] = 'وقت الانتهاء الذي تم فيه إدراج النتيجة للمرة الأولى';
$string['privacy:metadata:offlinequiz_results:timemodified'] = 'وقت تعديل النتيجة';
$string['privacy:metadata:offlinequiz_results:timestart'] = 'وقت البدء الذي تم فيه إدراج النتيجة للمرة الأولى';
$string['privacy:metadata:offlinequiz_results:usageid'] = 'مُعرَّف مظهر الاستعمال لواجهة برمجة التطبيق العائدة للاختبار حيث تم حفظ هذه النتيجة';
$string['privacy:metadata:offlinequiz_results:userid'] = 'المستخدم العائدة له هذه النتيجة';
$string['privacy:metadata:offlinequiz_scanned_p_pages'] = 'هذا الجدول يحفظ صفحات المشاركين ومعلوماتها العامة';
$string['privacy:metadata:offlinequiz_scanned_p_pages:error'] = 'الخطأ (إن وجد) الذي أثارته هذه الصفحة عند المعالجة';
$string['privacy:metadata:offlinequiz_scanned_p_pages:filename'] = 'اسم الملف للصفحة الممسوحة';
$string['privacy:metadata:offlinequiz_scanned_p_pages:listnumber'] = 'رقم القائمة';
$string['privacy:metadata:offlinequiz_scanned_p_pages:offlinequizid'] = 'الاختبار غير المتصل العائدة له صفحة المشاركين هذه';
$string['privacy:metadata:offlinequiz_scanned_p_pages:status'] = 'حالة هذه الصفحة الممسوحة ضوئياً';
$string['privacy:metadata:offlinequiz_scanned_p_pages:time'] = 'وقت معالجة هذه الصفحة';
$string['privacy:metadata:offlinequiz_scanned_pages'] = 'هذا الجدول يحفظ معلومات عن الصفحة الممسوحة للاختبار غير المتصل';
$string['privacy:metadata:offlinequiz_scanned_pages:error'] = 'تفاصيل الخطأ الذي في هذه الصفحة (إن وجد)';
$string['privacy:metadata:offlinequiz_scanned_pages:filename'] = 'اسم الملف للصفحة الممسوحة';
$string['privacy:metadata:offlinequiz_scanned_pages:groupnumber'] = 'رقم المجموعة العائد لها الاختبار غير المتصل هذا';
$string['privacy:metadata:offlinequiz_scanned_pages:offlinequizid'] = 'الاختبار غير المتصل للصفحة الممسموحة';
$string['privacy:metadata:offlinequiz_scanned_pages:pagenumber'] = 'رقم الصفحة المعطى لهذه الصفحة';
$string['privacy:metadata:offlinequiz_scanned_pages:resultid'] = 'النتيجة العائدة لهذه الصفحة';
$string['privacy:metadata:offlinequiz_scanned_pages:status'] = 'حالة هذه الصفحة';
$string['privacy:metadata:offlinequiz_scanned_pages:time'] = 'وقت معالجة الصفحة';
$string['privacy:metadata:offlinequiz_scanned_pages:userkey'] = 'مفتاح المستخدم (ليس مُعرَّف المستخدم) للمستخدم المؤشر بتقاطع في الصفحة';
$string['privacy:metadata:offlinequiz_scanned_pages:warningfilename'] = 'اسم الملف الذي تم إنشاؤه عند تصحيح الاختبار غير المتصل المعبأ بشكل خاطئ والمستخدم تلقى تنبيهًا بشأن ذلك';
$string['questionanalysis'] = 'تحليل الصعوبة';
$string['questionanalysistitle'] = 'جدول تحليل الصعوبة';
$string['questionbankcontents'] = 'محتويات بنك الأسئلة';
$string['questionforms'] = 'نماذج الأسئلة';
$string['questioninfoanswers'] = 'عدد الإجابات الصحيحة';
$string['questioninfocorrectanswer'] = 'الإجابة الصحيحة';
$string['questioninfocorrectanswers'] = 'الإجابات الصحيحة';
$string['questioninfonone'] = 'لا شيء';
$string['questioninfoqtype'] = 'نوع السؤال';
$string['questionname'] = 'اسم السؤال';
$string['questionpage'] = 'الصفحة';
$string['questionsheet'] = 'ورقة الأسئلة';
$string['questionsheetlatextemplate'] = '% !TEX encoding = UTF-8 Unicode
\\documentclass[11pt,a4paper]{article}
\\usepackage[utf8x]{inputenc}
\\usepackage[T1]{fontenc}
\\textwidth 16truecm
\\textheight 23truecm
\\setlength{\\oddsidemargin}{0cm}
\\setlength{\\evensidemargin}{0cm}
\\setlength{\\topmargin}{-1cm}
\\usepackage{amsmath} % من أجل \\implies إلخ
\\usepackage{amsfonts} % من أجل \\mathbb إلخ
\\usepackage[colorlinks=true,urlcolor=dunkelrot,linkcolor=black]{hyperref} % لاستعمال الروابط
\\usepackage{ifthen}
\\usepackage{enumitem}
\\usepackage{xcolor}
\\usepackage{ulem}
\\parindent 0pt % لا مسافة بادئة في بداية القسم
\\renewcommand\\UrlFont{\\sf}
\\usepackage{lastpage}
\\usepackage{fancyhdr}
\\pagestyle{fancy}
\\chead{\\sc \\Title, Group \\Group}
\\cfoot{Seite \\thepage/\\pageref{LastPage}}
\\makeatletter %%% تعطيل فواصل الصفحات بين الإجابات
\\@beginparpenalty=10000
\\@itempenalty=10000
\\makeatother
%
\\newcommand{\\answerIs}[1]{} %%% تعطيل إظهار الإجابة الصحيحة
% \\newcommand{\\answerIs}[1]{[#1]} %%% تمكين إظهار الإجابة الصحيحة
%%%


% ===========================================================================================================
%%% بيانات المساق:
\\newcommand{\\Group}{{$a->groupname}}
\\newcommand{\\Title}{{$a->coursename}}
\\newcommand{\\Date}

\\newcommand{\\TestTitle}{%
\\begin{center}
{\\bf \\Large Question sheet}\\\\[3mm]
\\fbox{
\\begin{tabular}{rl}
\\rule{0pt}{25pt} Name: & $\\underline{\\hspace*{8cm}}$ \\rule{20pt}{0pt}\\\\[5mm]
ID number: & $\\underline{\\hspace*{8cm}}$\\\\[5mm]
\\ifthenelse{\\equal{true}{{$a->printstudycodefield}}}{\\rule{10pt}{0pt} Study code: & $\\underline{\\hspace*{8cm}}$\\\\[5mm]}{}
\\rule[-20pt]{0pt}{20pt} Signature: & $\\underline{\\hspace*{8cm}}$
\\end{tabular}}
\\end{center}
}

\\InputIfFileExists{offline_test_extras.tex}{}{} % إدخال المزيد من تعاريف المستخدم

\\begin{document}


% ===========================================================================================================
\\TestTitle

% ===========================================================================================================


\\bigskip
% ===========================================================================================================

{$a->pdfintrotext}

% ===========================================================================================================

\\newpage

% ===========================================================================================================


{$a->latexforquestions}


\\end{document}';
$string['questionsin'] = 'الأسئلة في';
$string['questionsingroup'] = 'الأسئلة في المجموعة';
$string['questionsinthisofflinequiz'] = 'الأسئلة في الاختبار بدون الاتصال هذا';
$string['questiontextisempty'] = '[نص السؤال فارغ]';
$string['quizdate'] = 'تاريخ الاختبار غير المتصل';
$string['quizopenclose'] = 'تاريخا الفتح والإغلاق';
$string['quizopenclose_help'] = 'يمكن للطلبة فقط مشاهدة محاولاتهم بعد وقت الفتح وقبل وقت الإغلاق.';
$string['randomfromexistingcategory'] = 'سؤال عشوائي من صنف موجود';
$string['randomnumber'] = 'عدد الأسئلة العشوائية';
$string['randomquestionusinganewcategory'] = 'سؤال عشوائي باستعمال صنف جديد';
$string['readjust'] = 'إعادة الضبط';
$string['reallydeletepdfs'] = 'هل ترغب حقًا في حذف ملفات النموذج؟';
$string['reallydeleteupdatepdf'] = 'هل ترغب حقًا في حذف قائمة المشاركين وتحديثها؟';
$string['recreatepdfs'] = 'إعادة أنشاء ملفات PDF';
$string['recurse'] = 'تضمين الأسئلة من الأصناف الفرعية أيضًا';
$string['rediswrong'] = 'تقاطع خاطئ أو مفقود';
$string['refreshpreview'] = 'تنشيط الاستعراض';
$string['regrade'] = 'إعادة التقييم';
$string['regradedisplayexplanation'] = '<b>إنتباه:</b> إعادة التقييم لن يغير التقديرات التي تم وضعها يدويًا!';
$string['regradinginfo'] = 'إذا غيَّرت درجة أي سؤال، فعليك إعادة تقييم الاختبار غير المتصل من أجل تحديث نتائج المشاركين.';
$string['regradingquiz'] = 'إعادة وضع التقديرات';
$string['regradingresult'] = 'نتيجة إعادة وضع التقدير للمستخدم {$a}...';
$string['reloadpreview'] = 'إعادة تحميل الاستعراض';
$string['reloadquestionlist'] = 'إعادة تحميل قائمة الأسئلة';
$string['remove'] = 'إزالة';
$string['removeemptypage'] = 'إزالة الصفحة الفارغة';
$string['removepagebreak'] = 'إزالة فاصل الصفحات';
$string['removeselected'] = 'إزالة المحدد';
$string['reordergroupquestions'] = 'إعادة ترتيب أسئلة المجموعة';
$string['reorderquestions'] = 'إعادة ترتيب الأسئلة';
$string['reordertool'] = 'إظهار أداة إعادة الترتيب';
$string['repaginate'] = 'إعادة تعيين الصفحات مع وضع {$a} من الأسئلة لكل صفحة';
$string['repaginatecommand'] = 'إعادة تعيين الصفحات';
$string['repaginatenow'] = 'إعادة تعيين الصفحات الآن';
$string['reportends'] = 'إنتهت مراجعة النتائج';
$string['reportoverview'] = 'نظرة عامة';
$string['reportstarts'] = 'بدأت مراجعة النتائج';
$string['resetofflinequizzes'] = 'إعادة تعيين بيانات الاختبار بدون الاتصال';
$string['resultexists'] = 'توجد سابقاً نفس النتيجة لـ {$a}، تم تجاهل الاستيراد';
$string['resultimport'] = 'استيراد النتائج';
$string['results'] = 'النتائج';
$string['review'] = 'مراجعة';
$string['reviewbefore'] = 'السماح بالمراجعة طالما الاختبار غير المتصل مفتوح';
$string['reviewclosed'] = 'بعد إغلاق الاختبار غير المتصل';
$string['reviewcloses'] = 'المراجعة تُغلق';
$string['reviewimmediately'] = 'مباشرة بعد المحاولة';
$string['reviewincludes'] = 'المراجعة تتضمن';
$string['reviewofresult'] = 'مراجعة النتيجة';
$string['reviewopens'] = 'المراجعة تُفتح';
$string['reviewoptions'] = 'الطلاب يمكنهم معاينة';
$string['reviewoptions_help'] = 'مع هذه الخيارات يمكنك التحكم بما قد يشاهده الطلاب بعد استيراد النتائج.
يمكنك أيضاً تعريف وقت بدء تقرير النتائج وانتهائه. مربعات التأشير تعني:
<table>
<tr><td style="vertical-align: top;"><b>المحاولة</b></td><td>
سيتم إظهار نصوص الأسئلة وإجاباتها للطلبة. سيشاهدون ما اختاروه من الإجابات، ولكن لن تتم الإشارة إلى الإجابات الصائبة.</td>
</td></tr>
<tr><td style="vertical-align: top;"><b>فيما إذا كانت صحيحة</b></td><td>
هذا الخيار يمكن تفعيله فقط إذا تم تفعيل الخيار "المحاولة". عند التفعيل، سيتمكن الطلاب من مشاهدة أي من الإجابات المختارة هو الصائب (الخلفية الخضراء) أو الخاطئ (الخلفية الحمراء).
</td></tr>
<tr><td style="vertical-align: top;"><b>الدرجات</b></td><td>
المجموعة (مثل ب)، الدرجات (الدرجة المحفوظة، إجمالي درجات الأسئلة، الدرجة المحفوظة كنسبة مئوية، مثل 40/80 (50)) والدرجة (مثل 50 من أصل 100) هي ما سيتم عرضه.
فضلاً عن ذلك، إذا تم تأشير "المحاولة"، سيتم إظهار الدرجة المحفوظة والدرجة القصوى لكل سؤال.
</td></tr>
<tr><td style="vertical-align: top;"><b>الإفادة الخاصة</b></td><td>
الإفادة التي تعتمد على الاستجابة التي قدمها الطالب.
</td></tr>
<tr><td style="vertical-align: top;"><b>الإفادة العامة</b></td><td>
<p>يتم إظهار الإفادة العامة للطالب بعد استيراد النتائج.
بخلاف الإفادة الخاصة، التي تعتمد على نوع السؤال والاستجابة التي دمها الطالب، يتم إظهار نفس نص الإفادة العامة لكل الطلاب.</p>
<p></p><p>يمكنك استعمال الإفادة العامة لإعطاء الطلبة إجابة مفصلة عن السؤال أو ربما، رابطًا لمزيد من المعلومات يمكنهم الاستفادة منها إن لم يكونوا قد فهموا السؤال كما يجب.</p>
</td></tr>
<tr><td style="vertical-align: top;"><b>الإجابات الصائبة</b></td><td>
هذا يظهر أي من الإجابات هي الصائبة وأيُّها خاطئة. هذا الخيار متاح فقط عند تأشير "المحاولة".
</td></tr>
<tr><td style="vertical-align: top;"><b>النموذج الممسوح</b></td><td>
يتم إظهار نماذج الإجابات الممسوحة. مربعات التأشير معلمة بمربعات خضراء.
</td></tr>
<tr><td style="vertical-align: top;"><b>النموذج الممسوح مع التقديرات</b></td><td>
يتم إظهار نماذج الإجابات الممسوحة. مربعات التأشير معلمة بمربعات خضراء.. يتم إبراز التأشيرات الخاطئة وتلك المفقودة.
فضلاً عن ذلك، يظهر جدول يتضمن الدرجة القصوى والدرجة المحرزة لكل سؤال.
</td></tr>
</table>';
$string['reviewoptionsheading'] = 'خيارات المراجعة';
$string['rimport'] = 'رفع/تصحيح';
$string['rotate'] = 'تدوير';
$string['rotatingsheet'] = 'تم تدوير الورقة...';
$string['save'] = 'حفظ';
$string['saveandshow'] = 'حفظ مع إظهار التغييرات للطالب';
$string['savescannersettings'] = 'حفظ إعدادات الماسح الضوئي';
$string['scannedform'] = 'النموذج الممسوح';
$string['scannerformfortype'] = 'النموذج للنوع {$a}';
$string['scanneroptions'] = 'إعدادات الماسح الضوئي';
$string['scannerpdfs'] = 'النماذج الفارغة';
$string['scannerpdfstext'] = 'قم بتنزيل النماذج الفارغة الآتية إذا أردت استعمال برنامج الماسح الضوئي الخاص بك.';
$string['scanningoptionsheading'] = 'خيارات المسح الضوئي';
$string['score'] = 'الدرجة';
$string['search:activity'] = 'الاختبار غير المتصل - معلومات النشاط';
$string['select'] = 'إختر';
$string['selectagroup'] = 'إختر المجموعة';
$string['selectall'] = 'إختر الكل';
$string['selectcategory'] = 'إختر الصنف';
$string['selectdifferentgroup'] = 'يرجى اختيار مجموعة مختلفة!';
$string['selectedattempts'] = 'المحاولات المحددة...';
$string['selectformat'] = 'إختر التنسيق...';
$string['selectgroup'] = 'إختر المجموعة';
$string['selectlist'] = 'يرجى اختيار القائمة أو حاول إعادة ضبط الورقة:';
$string['selectmultipletoolbar'] = 'إختر شريط الأدوات المتعدد';
$string['selectnone'] = 'إلغاء تحديد الكل';
$string['selectpage'] = 'يرجى اختيار رقم الصفحة أو حاول إعادة ضبط الورقة:';
$string['selectquestiontype'] = '-- إختر نوع السؤال --';
$string['showallparts'] = 'إظهار المشاركين البالغ عددهم {$a} جميعًا';
$string['showcopyright'] = 'إظهار بيان الحقوق الفكرية';
$string['showcopyrightdesc'] = 'إذا قمت بتمكين هذا الخيار، سيتم إظهار بيان للحقوق الفكرية في صفحة مراجعة نتائج الطالب.';
$string['showgrades'] = 'طباعة درجات الأسئلة';
$string['showgrades_help'] = 'هذا الخيار يتحكم فيما إذا كان ينبغي طباعة الدرجات القصوى لأسئلة الاختبار غير المتصل على أوراق الأسئلة.';
$string['showmissingattemptonly'] = 'إظهار كل المشاركين المحددين الذين بلا نتائج';
$string['showmissingcheckonly'] = 'إظهار كل المشاركين غير المحددين الذين لهم نتائج';
$string['shownumpartsperpage'] = 'إظهار {$a} من المشاركين في الصفحة الواحدة';
$string['showquestioninfo'] = 'طباعة معلومات عن الإجابات';
$string['showquestioninfo_help'] = 'مع هذا الخيار يمكنك التحكم بالمعلومات الإضافية التي تريد طباعتها عن السؤال في ورقة الأسئلة.
يمكنك اختيار واحد مما يأتي:
<ul>
<li> لا شيء
<li> نوع السؤال - إعتمادًا على نوع السؤال، ستتم طباعة: إختيار منفرد، متعدد الخيارات، الكل أو لا شيء متعدد الخيارات
<li> عدد الإجابات الصحيحة - ستتم طباعة عدد الإجابات الصحيحة
</ul>';
$string['showstudentview'] = 'إظهار ما يعاينه الطالب';
$string['showtutorial'] = 'إظهار الاختبار غير المتصل التدريبي للطلاب.';
$string['showtutorial_help'] = 'هذا الخيار يحدد ما إذا كان بإمكان الطلاب مشاهدة اختبار تدريبي عن أساسيات الاختبارات بدون الاتصال.
هذا الاختبار التدريبي يعطي معلومات عن كيفية التعامل مع الأنواع المختلفة من المستندات في الاختبارات غير المتلة. في جزء تفاعلي يتعلمون كيفية التأشير على مُعرَّف الطالب الخاص بهم بشكل صحيح.<br />
<b>يرجى ملاحظة:</b><br />
إذا وضعت هذا الخيار على "نعم" ولكن أخفيت الاختبار غير المتصل، لن يكون الرابط المؤدي إلى الاختبار التدريبي ظاهراً. في هذه الحالة، يمكنك إضافة رابط إلى الاختبار التدريبي في صفحة المقرر.';
$string['showtutorialdescription'] = 'يمكنك إضافة رابط للاختبار التدريبي في صفحة المقرر مستعملاً العنوان الآتي:';
$string['shuffleanswers'] = 'خلط الإجابات';
$string['shufflequestions'] = 'خلط الأسئلة';
$string['shufflequestionsanswers'] = 'خلط الأسئلة والإجابات';
$string['shufflequestionsselected'] = 'تم ضبطه للخلط ما بين الأسئلة، لذلك بعض الإجراءات المتعلقة بالصفحات لن تكون متاحة. لتغيير خيار الخلط، {$a}.';
$string['shufflewithin'] = 'الخلط ما بين الأسئلة';
$string['shufflewithin_help'] = 'عند التمكين، الأجزاء المكونة لكل سؤال سيتم خلطها عند كل مرة تضغط فيها زر إعادة التحميل في استعراض النموذج. ملاحظة: هذا الإعداد ينطبق فقط على الأسئلة التي يُتاح فيها خيار الخلط.';
$string['signature'] = 'التوقيع';
$string['singlechoice'] = 'إختيار مفرد';
$string['standard'] = 'قياسي';
$string['starttutorial'] = 'إبدأ التدريب على الاختبار';
$string['statistics'] = 'الإحصائيات';
$string['statisticsplural'] = 'الإحصائيات';
$string['statsoverview'] = 'نظرة عامة على الإحصائيات';
$string['studycode'] = 'رمز الدراسة';
$string['temporaryfiledeletiontask'] = 'حذف الملفات المؤقتة';
$string['theattempt'] = 'المحاولة';
$string['timesup'] = 'الوقت انتهى!';
$string['totalmarksx'] = 'إجمالي الدرجات: {$a}';
$string['totalpointsx'] = 'إجمالي الدرجات: {$a}';
$string['totalquestionsinrandomqcategory'] = 'إجمالاً {$a} من الأسئلة في الصنف.';
$string['trigger'] = 'الحد الأعلى/الأدنى';
$string['tutorial'] = 'التدريب على الاختبارات غير المتصلة';
$string['type'] = 'النوع';
$string['uncheckparts'] = 'تأشير المشاركين المحددين على أنهم غائبون';
$string['updatedsumgrades'] = 'مجموع كل التقديرات للمجموعة {$a->letter} قد أُعيد احتسابه إلى {$a->grade}.';
$string['upgradingfilenames'] = 'ترقية أسماء الملفات للمستندات: الاختبار غير المتصل {$a->done}/{$a->outof} (مُعرَّف الاختبار غير المتصل {$a->info})';
$string['upgradingilogs'] = 'ترقية الصفحات الممسوحة: الصفحة الممسوحة {$a->done}/{$a->outof} <br/>(مُعرَّف الاختبار غير المتصل {$a->info})';
$string['upgradingofflinequizattempts'] = 'ترقية محاولات الاختبار بدون الاتصال: الاختبار بدون الاتصال {$a->done}/{$a->outof} <br/>(مُعرَّف الاختبار بدون الاتصال {$a->info})';
$string['upload'] = 'رفع/تصحيح';
$string['uploadpart'] = 'رفع/القوائم الصحيحة للمشاركين';
$string['uppertrigger'] = 'الحد الثاني الأعلى';
$string['uppertriggerzero'] = 'الحد الثاني الأعلى هو صفر';
$string['upperwarning'] = 'الحد الأول الأعلى';
$string['upperwarningzero'] = 'الحد الأول الأعلى هو صفر';
$string['useradded'] = 'أُضيف المستخدم {$a}';
$string['userdoesnotexist'] = 'المستخدم {$a} ليس موجودًا في النظام';
$string['useridentification'] = 'هوية المستخدم';
$string['useridviolation'] = 'تم العثور على مستخدمين متعددين';
$string['userimported'] = 'تم استيراد المستخدم {$a} وتقييمه';
$string['usernotincourse'] = 'المستخدم {$a} ليس منضمًا إلى المساق.';
$string['usernotinlist'] = 'المستخدم ليس مسجلاً في القائمة!';
$string['usernotregistered'] = 'المستخدم {$a} ليس منضمًا إلى المساق';
$string['userpageimported'] = 'تم استيراد صفحة منفردة للمستخدم {$a}';
$string['valuezero'] = 'القيمة ينبغي أن لا تكون صفرًا';
$string['viewresults'] = 'معاينة النتائج';
$string['white'] = 'أبيض';
$string['withselected'] = 'مع ما هو محدد...';
$string['zerogradewarning'] = 'تنبيه: درجة اختبارك غير المتصل هي 0.0!';
$string['zipfile'] = 'ملف مضغوط ZIP';
$string['zipok'] = 'تم استيراد الملف المضغوط';
