<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_nimble', language 'de', version '5.0'.
 *
 * @package     theme_nimble
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['backgroundcolor'] = 'Hintergrund im Kopfbereich ';
$string['backgroundcolordesc'] = 'Hintergrundfarbe im Kopfbereich ändern';
$string['choosereadme'] = '<div class="clearfix">
<div class="theme_screenshot">
<h2>Nimble</h2>
<img src="nimble/pix/screenshot.png" />
<h3>Forum zur Designdiskussion:</h3>
<p><a href="http://moodle.org/mod/forum/view.php?id=46">http://moodle.org/mod/forum/view.php?id=46</a></p>
<h3>Danksagungen (Designs):</h3>
<p><a href="http://docs.moodle.org/en/Theme_credits">http://docs.moodle.org/en/Theme_credits</a></p>
<h3>Dokumentationen:</h3>
<p><a href="http://docs.moodle.org/de/Designs">http://docs.moodle.org/de/Designs</a></p>
<h3>Fehler melden:</h3>
<p><a href="http://tracker.moodle.org">http://tracker.moodle.org</a></p>
</div>
<div class="theme_description">
<h2>Über Nimble</h2>
<p>Nimble ist ein Zwei-Spalten-Design mit variabler Breite für Moodle 2.0. Das Design hat Einstellungen für die Linkfarbe, für einen Untertitel auf der Startseite und für eine Fußzeile auf jeder Seite.</p>
<h2>Hinweise</h2>
<p>Dieses Design basiert auf den beiden in Moodle enthaltenen Grunddesigns Base und Canvas. Wenn Sie Änderungen vornehmen wollen, empfehlen wir unbedingt, vorher immer eine Kopie zu erstellen und diese umzubenennen. So wird verhindert, dass Ihre Änderungen bei einem Update von Moodle verloren gehen; Sollte Ihnen ein Fehler in den Änderungen unterlaufen, haben Sie so ebenfalls noch eine funktionierende Sicherheitskopie. Weitere Informationen zum Bearbeiten von Designs finden Sie in der <a href="http://docs.moodle.org/de/Designs">Designdokumentation</a>.</p>
<h2>Autor</h2>
<p>Dieses Design wurde erstellt von Patrick Malley (patrick@newschoollearning.com) mit Unterstützung von John Stabinger (john@newschoollearning.com).</p>
<h2>Lizenz</h2>
<p>Dieses und alle weiteren in Moodle enthaltenen Grunddesigns stehen unter der <a href="http://www.gnu.org/licenses/gpl.html">GNU General Public License</a>. </p>
</div>
</div>';
$string['footerline'] = 'Fußzeile';
$string['footerlinedesc'] = 'Beliebigen Text für die Fußzeile hinzufügen, z.B. einen Copyrighthinweis o.ä.';
$string['linkcolor'] = 'Linkfarbe';
$string['linkcolordesc'] = 'Diese Farbe wird für alle Links benutzt. Verwenden Sie HTML hex-Code.';
$string['linkhover'] = 'Menüfarbe (on hover)';
$string['linkhoverdesc'] = 'Diese Farbe wird für Menülinks (on hover) benutzt. (HTML-Hexcode)';
$string['pluginname'] = 'Nimble';
$string['region-side-post'] = 'Rechts';
$string['region-side-pre'] = 'Links';
$string['tagline'] = 'Untertitel';
$string['taglinedesc'] = 'Der Untertitel erscheint unter dem Website-Namen auf der Startseite.';
