<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'questionnaire', language 'el', version '5.0'.
 *
 * @package     questionnaire
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'Ενέργεια';
$string['activityoverview'] = 'Έχετε ερωτηματολόγια που οφείλονται';
$string['additionalinfo'] = 'Επιπρόσθετες πληροφορίες';
$string['additionalinfo_help'] = 'Κείμενο που θα εμφανίζεται στην κορυφή της πρώτης σελίδας αυτού του ερωτηματολογίου. (δηλαδή οδηγίες, πληροφορίες ιστορικού κ.λπ.)';
$string['addnewquestion'] = 'Προσθήκη {$a} ερωτήσεων';
$string['addnewsection'] = 'Προσθήκη νέας ενότητας';
$string['addquestion'] = 'Προσθήκη ερώτησης...';
$string['addquestions'] = 'Πρόσθεσε ερωτήσεις';
$string['addquestiontosection'] = 'Προσθήκη ερώτησης στην ενότητα';
$string['addselqtype'] = 'Προσθήκη επιλεγμένου τύπου ερώτησης';
$string['alignment'] = 'Στοίχιση κουμπιών μοναδικής επιλογής';
$string['alignment_help'] = 'Επιλογή ευθυγράμμισης πλήκτρων: κάθετη (προεπιλογή) ή οριζόντια.';
$string['alignment_link'] = 'mod/questionnaire/questions#Radio_Buttons';
$string['all'] = 'Όλα';
$string['allnameddegrees'] = 'Λεκτικό βαθμού';
$string['allnameddegrees_help'] = 'Καθορίστε κείμενο για εμφάνιση για τιμές κατάταξης αντί για αριθμούς. Αφήστε κενό για μη χρήση.';
$string['alreadyfilled'] = 'Έχετε ήδη συμπληρώσει το ερωτηματολόγιο για εμάς {$a}. Ευχαριστούμε.';
$string['andaveragevalues'] = 'και μέσες τιμές';
$string['anonymous'] = 'Ανώνυμος';
$string['answer'] = 'Απάντηση';
$string['answergiven'] = 'Αυτή η απάντηση δίνεται';
$string['answernotgiven'] = 'Αυτή η απάντηση δεν δίνεται';
$string['answerquestions'] = 'Απαντήστε στις ερωτήσεις...';
$string['answers'] = 'Απαντήσεις';
$string['attempted'] = 'Αυτό το ερωτηματολόγιο έχει υποβληθεί.';
$string['attemptstillinprogress'] = 'Σε εξέλιξη. Αποθηκεύτηκε στις:';
$string['autonumbering'] = 'Αυτόματη αρίθμηση';
$string['autonumbering_help'] = 'Αυτόματη αρίθμηση ερωτήσεων και σελίδων. Ίσως θέλετε να απενεργοποιήσετε την αυτόματη αρίθμηση για ερωτηματολόγια με διαφορετικές ερωτήσεις ανάλογα με τις απαντήσεις.';
$string['autonumberno'] = 'Χωρίς αρίθμηση ερωτήσεων ή σελίδων';
$string['autonumberpages'] = 'Αυτόματη αρίθμηση σελίδων';
$string['autonumberpagesandquestions'] = 'Αυτόματη αρίθμηση σελίδων και ερωτήσεων';
$string['autonumberquestions'] = 'Αυτόματη αρίθμηση ερωτήσεων';
$string['average'] = 'Μέσος όρος';
$string['averageposition'] = 'Μέση θέση';
$string['averagerank'] = 'Μέση κατάταξη';
$string['averagesrow'] = 'Μέσοι όροι (όπου ταιριάζει):';
$string['bodytext'] = 'Κείμενο σώματος';
$string['boxesnbexact'] = 'ακριβώς {$a} κουτάκι/-α.';
$string['boxesnbmax'] = 'το πολύ {$a} κουτάκι/-α.';
$string['boxesnbmin'] = 'τουλάχιστον {$a} κουτάκι/-α.';
$string['boxesnbreq'] = 'Για αυτήν την ερώτηση πρέπει να επιλέξετε/τικάρετε';
$string['by'] = 'από';
$string['cannotviewpublicresponses'] = 'Δεν μπορείτε να δείτε τις απαντήσεις σε αυτό το δημόσιο ερωτηματολόγιο.';
$string['chart:bipolar'] = 'Διπολικές μπάρες';
$string['chart:hbar'] = 'Οριζόντιες μπάρες';
$string['chart:radar'] = 'Ραντάρ';
$string['chart:rose'] = 'Τριαντάφυλλο';
$string['chart:type'] = 'Τύπος γραφήματος';
$string['chart:type_help'] = 'Επιλέξτε τον τύπο γραφήματος που θέλετε να χρησιμοποιήσετε για αυτήν την ανατροφοδότηση/σχόλιο';
$string['chart:vprogress'] = 'Κάθετη μπάρα προόδου';
$string['checkallradiobuttons'] = 'Παρακαλούμε, τσεκάρετε <strong>{$a}</strong> κουμπιά μοναδικής επιλογής!';
$string['checkboxes'] = 'Πλαίσια επιλογής';
$string['checkboxes_link'] = '';
$string['clicktoswitch'] = '(κάντε κλικ για εναλλαγή)';
$string['closebeforeopen'] = 'Έχετε δηλώσει ημερομηνία λήξη προγενέστερη της ημερομηνίας έναρξης';
$string['closed'] = 'Το ερωτηματολόγιο έκλεισε στις {$a}. Ευχαριστώ.';
$string['closedate'] = 'Επιτρέπονται απαντήσεις μέχρι';
$string['closeson'] = 'Το ερωτηματολόγιο κλείνει στις {$a}';
$string['completionsubmit'] = 'Ο μαθητής πρέπει να υποβάλει αυτό το ερωτηματολόγιο για να το ολοκληρώσει';
$string['condition'] = 'Συνθήκη';
$string['confalts'] = '- Ή - <br />Σελίδα επιβεβαίωσης';
$string['configemailreporting'] = 'Να επιτρέπονται αναφορές μέσω ηλε.ταχυδρομείου';
$string['configemailreportinglong'] = 'Επιτρέπει στις επιλογές ορισμένων αναφορών να αποστέλλονται απευθείας μέσω ηλε.ταχυδρομείου σε συγκεκριμένες διευθύνσεις.';
$string['configmaxsections'] = 'Μέγιστες ενότητες σχολίων';
$string['configusergraph'] = 'Εμφάνιση γραφημάτων για ανατροφοδότηση «Δοκιμής Προσωπικότητας»';
$string['confirmdelallresp'] = 'Είστε βέβαιοι ότι θέλετε να διαγράψετε ΟΛΕΣ τις απαντήσεις σε αυτό το ερωτηματολόγιο;';
$string['confirmdelchildren'] = 'Αν διαγράψετε αυτήν την ερώτηση, θα διαγραφεί/-ούν επίσης οι θυγατρικές ερωτήσεις:';
$string['confirmdeletesection'] = 'Είστε βέβαιοι ότι θέλετε να διαγράψετε την ενότητα ανατροφοδότησης «{$a}»;';
$string['confpage'] = 'Κείμενο επικεφαλίδας';
$string['contentoptions'] = 'Επιλογές περιεχομένου';
$string['couldnotcreatenewsurvey'] = 'Αδυναμία δημιουργίας μιας νέας έρευνας!';
$string['couldnotdelresp'] = 'Αδυναμία διαγραφής απόκρισης';
$string['createcontent'] = 'Ορισμός νέου περιεχομένου';
$string['createcontent_help'] = 'Ορισμός μιας από τις επιλογές κουμπιού μοναδικής επιλογής. Το «Δημιουργία νέου» είναι η προεπιλογή.';
$string['createcontent_link'] = 'mod/questionnaire/mod#Content_Options';
$string['createnew'] = 'Δημιουργία νέου';
$string['crontask'] = 'Εργασία καθαρισμού ερωτηματολογίου';
$string['date'] = 'Ημερομηνία';
$string['date_link'] = 'mod/questionnaire/questions#Date';
$string['deleteallresponses'] = 'Διαγραφή ΟΛΩΝ των αποκρίσεων';
$string['deletecurrentquestion'] = 'Διαγραφή ερώτησης {$a}';
$string['deletedallgroupresp'] = 'Διαγραφή ΟΛΩΝ των αποκρίσεων στην ομάδα {$a}';
$string['deletedallresp'] = 'Οι αποκρίσεις ερωτηματολογίου διαγράφηκαν';
$string['deletedisabled'] = 'Αυτό το στοιχείο δεν μπορεί να διαγραφεί';
$string['deletedresp'] = 'Η απόκριση διαγράφηκε';
$string['deleteresp'] = 'Διαγραφή αυτής της απόκρισης';
$string['deletesection'] = 'Διαγραφή αυτής της ενότητας';
$string['deletingresp'] = 'Διαγραφή απόκρισης...';
$string['dependencies'] = 'Εξαρτήσεις';
$string['dependquestion'] = 'Γονική Ερώτηση';
$string['dependquestion_link'] = 'mod/questionnaire/questions#Parent_Question';
$string['didnotrespondtoquestion'] = 'Δεν αποκρίθηκε στην ερώτηση';
$string['directwarnings'] = 'Οι άμεσες εξαρτήσεις σε αυτήν την ερώτηση θα καταργηθούν. Αυτό θα επηρεάσει:';
$string['displaymethod'] = 'Δεν έχει καθοριστεί μέθοδος εμφάνισης για την ερώτηση.';
$string['download'] = 'Λήψη';
$string['downloadpdf'] = 'Λήψη PDF';
$string['downloadtextformat'] = 'Λήψη';
$string['downloadtextformat_link'] = 'mod/questionnaire/report#Download_in_text_format';
$string['downloadtypes'] = 'Τύπος αναφοράς';
$string['dropdown'] = 'Πτυσσόμενο πλαίσιο';
$string['dropdown_help'] = 'Δεν υπάρχει κανένα πραγματικό πλεονέκτημα για τη χρήση του πτυσσόμενου πλαισίου πέρα από τη χρήση των κουμπιών μοναδικής επιλογής
, εκτός ίσως από μακρές λίστες επιλογών, για εξοικονόμηση χώρου στην οθόνη.';
$string['dropdown_link'] = 'mod/questionnaire/questions#Dropdown_Box';
$string['edit'] = 'Επεξεργασία';
$string['editingfeedback'] = 'Επεξεργασία ρυθμίσεων ανατροφοδότησης';
$string['editingquestionnaire'] = 'Επεξεργασία ρυθμίσεων ερωτηματολογίου';
$string['editquestion'] = 'Επεξεργασία ερώτησης {$a}';
$string['email'] = 'Διεύθυνση ηλε.ταχυδρομείου';
$string['emailextra'] = 'Αποστολή λήψης σε ηλε.ταχυδρομείο';
$string['emailroles'] = 'Αποστολή λήψης σε ρόλους';
$string['emailsend'] = 'Αποστολή αναφορών';
$string['emailsnotspecified'] = 'Δεν καθορίστηκε/-αν διευθύνσεις ηλε.ταχυδρομείου.';
$string['emailssent'] = 'Οι λήψεις στάλθηκαν στην/στις καθορισμένες διευθύνσεις ηλε.ταχυδρομείου.';
$string['errnewname'] = 'Λυπούμαστε, το όνομα χρησιμοποιείται ήδη. Διαλέξτε ένα άλλο όνομα.';
$string['erroropening'] = 'Σφάλμα κατά το άνοιγμα του ερωτηματολογίου.';
$string['essaybox'] = 'Πλαίσιο εισαγωγής έκθεσης';
$string['event_all_responses_deleted'] = 'Όλες οι αποκρίσεις διαγράφηκαν';
$string['event_all_responses_saved_as_text'] = 'Όλες οι αποκρίσεις αποθηκεύτηκαν ως κείμενο';
$string['event_all_responses_viewed'] = 'Όλες οι αναφορές αποκρίσεων εμφανίστηκαν';
$string['event_individual_responses_viewed'] = 'Οι αναφορές ατομικών αποκρίσεων εμφανίστηκαν';
$string['event_non_respondents_viewed'] = 'Προβλήθηκαν οι μη απαντήσαντες';
$string['event_previewed'] = 'Έγινε προεπισκόπηση του ερωτηματολογίου';
$string['event_question_created'] = 'Η ερώτηση δημιουργήθηκε';
$string['event_question_deleted'] = 'Η ερώτηση διαγράφηκε';
$string['event_response_deleted'] = 'Η μεμονωμένη απόκριση διαγράφηκε';
$string['event_resumed'] = 'Η προσπάθεια συνεχίστηκε';
$string['event_saved'] = 'Οι αποκρίσεις αποθηκεύτηκαν';
$string['event_submitted'] = 'Οι αποκρίσεις υποβλήθηκαν';
$string['feedback'] = 'Ανατροφοδότηση';
$string['feedback_help'] = 'Βοήθεια ανατροφοδοτήσεων';
$string['feedback_link'] = 'mod/questionnaire/personality_test#Editing_Questionnaire_Feedback_Messages';
$string['feedbackaddmorefeedbacks'] = 'Προσθήκη {no} ακόμη κενών πεδίων ανατροφοδότησης';
$string['feedbackbysection'] = 'Ανατροφοδότηση ενοτήτων';
$string['feedbackdefaultlabel'] = '[Νέα ενότητα]';
$string['feedbackglobal'] = 'Καθολική ανατροφοδότηση';
$string['feedbackglobalheading'] = 'Επικεφαλίδα καθολικής ανατροφοδότησης';
$string['feedbackglobalmessages'] = 'Μηνύματα καθολικής ανατροφοδότησης';
$string['feedbackhdr'] = 'Ανατροφοδοτήσεις';
$string['feedbackheading'] = 'Επικεφαλίδα ανατροφοδότησης';
$string['feedbackmessages'] = '{$a} μηνύματα ενότητας';
$string['feedbacknextsection'] = 'Επόμενη ενότητα {$a}';
$string['feedbacknone'] = 'Δεν υπάρχουν μηνύματα ανατροφοδότησης';
$string['feedbacknotes'] = 'Σημειώσεις ανατροφοδότησης';
$string['feedbackoptions'] = 'Επιλογές ανατροφοδότησης';
$string['feedbackoptions_link'] = 'mod/questionnaire/personality_test';
$string['feedbackremovesection'] = 'Η κατάργηση αυτής της ερώτησης θα καταργήσει εντελώς την ενότητα ανατροφοδότησης [{$a}]';
$string['feedbackreport'] = 'Αναφορά ανατροφοδότησης';
$string['feedbackscore'] = 'Σκορ ανατροφοδότησης';
$string['feedbackscoreboundary'] = 'Όριο για το σκορ ανατροφοδότησης';
$string['feedbackscores'] = 'Εμφάνιση των σκορ';
$string['feedbackscores_help'] = 'Εμφάνιση του πίνακα των σκορ ανατροφοδότησης';
$string['feedbacksection'] = 'Ενότητα';
$string['feedbacksectionheading'] = 'Επικεφαλίδα {$a} ενότητας';
$string['feedbacksectionheadingmissing'] = 'Πρέπει να δώσετε μια επικεφαλίδα για αυτή την ενότητα ανατροφοδότησης!';
$string['feedbacksectionheadingtext'] = 'Επικεφαλίδα';
$string['feedbacksectionlabel'] = 'Ταμπέλα';
$string['feedbacksectionquestions'] = '{$a} ερωτήσεις ενότητας';
$string['feedbacksections'] = 'Ενότητες ανατροφοδότησης';
$string['feedbacksectionsselect'] = 'Ενότητες';
$string['feedbacksectionsselect_help'] = 'Τοποθετήστε τις ερωτήσεις σας σε αυτές τις ενότητες';
$string['feedbacksectionsselect_link'] = 'mod/questionnaire/personality_test#Editing_Questionnaire_Feedback_Sections_2';
$string['feedbacksettingssaved'] = 'Οι ρυθμίσεις ανατροφοδότησης αποθηκεύτηκαν';
$string['feedbacktype'] = 'Τύπος ανατροφοδότησης';
$string['field'] = 'Ερώτηση {$a}';
$string['fieldlength'] = 'Μήκος πλαισίου εισαγωγής κειμένου';
$string['finished'] = 'Απαντήσατε σε όλες τις ερωτήσεις αυτού του ερωτηματολογίου!';
$string['firstrespondent'] = 'Πρώτος αποκρινόμενος';
$string['formateditor'] = 'Πρόγραμμα επεξεργασίας HTML';
$string['formatplain'] = 'Απλό κείμενο';
$string['grade'] = 'Βαθμός υποβολής';
$string['gradesdeleted'] = 'Οι βαθμοί του ερωτηματολογίου διαγράφηκαν';
$string['headingtext'] = 'Κείμενο επικεφαλίδας';
$string['horizontal'] = 'Οριζόντιο';
$string['id'] = 'Αναγνωριστικό';
$string['includechoicecodes'] = 'Συμπερίληψη κωδικών επιλογής';
$string['includechoicetext'] = 'Συμπερίληψη κειμένου επιλογής';
$string['includeincomplete'] = 'Συμπερίληψη ελλιπών απαντήσεων';
$string['incorrectcourseid'] = 'Το αναγνωριστικό μαθήματος είναι λανθασμένο';
$string['incorrectmodule'] = 'Το αναγνωριστικό αρθρώματος μαθήματος ήταν λανθασμένο';
$string['incorrectquestionnaire'] = 'Το ερωτηματολόγιο δεν είναι σωστό';
$string['invalidresponse'] = 'Καθορίστηκε μη έγκυρη απόκριση.';
$string['invalidresponserecord'] = 'Καθορίστηκε μη έγκυρη εγγραφή απόκρισης.';
$string['invalidsectionid'] = 'Καθορίστηκε μη έγκυρη ενότητα ανατροφοδότησης.';
$string['invalidsurveyid'] = 'Μη έγκυρο αναγνωριστικό ερωτηματολογίου.';
$string['kindofratescale'] = 'Τύπος κλίμακας αξιολόγησης';
$string['kindofratescale_link'] = 'mod/questionnaire/questions#Type_of_rate_scale';
$string['lastrespondent'] = 'Τελευταίος αποκρινόμενος';
$string['length'] = 'Μήκος';
$string['managequestions'] = 'Διαχείριση ερωτήσεων';
$string['managequestions_link'] = 'mod/questionnaire/questions#Manage_questions';
$string['maxdigitsallowed'] = 'Μέγιστο επιτρεπόμενων ψηφίων';
$string['maxdigitsallowed_link'] = 'mod/questionnaire/questions#Numeric';
$string['maxtextlength'] = 'Μέγιστο μήκος κειμένου';
$string['messageprovider:message'] = 'Υπενθύμιση ερωτηματολογίου';
$string['messageprovider:notification'] = 'Υποβολή ερωτηματολογίου';
$string['misconfigured'] = 'Το μάθημα έχει μη έγκυρες ρυθμίσεις';
$string['missingquestion'] = 'Παρακαλούμε, απαντήστε στην απαιτούμενη ερώτηση';
$string['missingquestions'] = 'Παρακαλούμε, απαντήστε στις απαιτούμενες ερωτήσεις:';
$string['modulename'] = 'Ερωτηματολόγιο';
$string['modulename_help'] = 'Η δραστηριότητα ερωτηματολόγιο σας επιτρέπει να δημιουργείτε και να διεξάγετε έρευνες χρησιμοποιώντας μία ποικιλία τύπων ερωτήσεων προκειμένου να συγκεντρώσετε δεδομένα από τους χρήστες.';
$string['modulename_link'] = 'mod/questionnaire/view';
$string['modulenameplural'] = 'Ερωτηματολόγια';
$string['movedisabled'] = 'Δεν είναι δυνατή η μετακίνηση αυτού του στοιχείου';
$string['myresponses'] = 'Όλες οι αποκρίσεις σας';
$string['myresponsetitle'] = 'Οι απαντήσεις σας {$a}';
$string['myresults'] = 'Τα αποτελέσματά σας';
$string['name'] = 'Όνομα';
$string['navigate'] = 'Να επιτρέπονται ερωτήσεις διακλάδωσης';
$string['navigate_link'] = 'mod/questionnaire/conditional_branching';
$string['navigatetosection'] = 'Μεταβείτε στην ενότητα ανατροφοδότησης';
$string['next'] = 'Επόμενο';
$string['nextpage'] = 'Επόμενη σελίδα';
$string['nlines'] = '{$a} γραμμές';
$string['noanswer'] = 'Καμιά απάντηση';
$string['noattempts'] = 'Δεν έχουν γίνει καθόλου προσπάθειες σε αυτό το ερωτηματολόγιο';
$string['nodata'] = 'Δεν στάλθηκαν καθόλου δεδομένα.';
$string['non_respondents'] = 'Χρήστες που δεν έχουν ακόμη υποβάλει τις αποκρίσεις τους σε αυτό το ερωτηματολόγιο';
$string['noneinuse'] = 'Αυτό το ερωτηματολόγιο δεν περιέχει καθόλου ερωτήσεις.';
$string['nopublicsurveys'] = 'Κανένα δημόσιο ερωτηματολόγιο.';
$string['noresponsedata'] = 'Καμία απόκριση για αυτή την ερώτηση.';
$string['noresponses'] = 'Καμία απόκριση';
$string['normal'] = 'Κανονικό';
$string['not_started'] = 'δεν ξεκίνησε';
$string['notanumber'] = '<strong>{$a}</strong> δεν είναι ένας αποδεκτός μορφότυπος αριθμού.';
$string['notapplicable'] = 'Δ/Υ';
$string['notapplicablecolumn'] = 'Δ/Υ στήλη';
$string['notavail'] = 'Αυτό το ερωτηματολόγιο δεν είναι πλέον διαθέσιμο. Ζητήστε από τον διδάσκοντα να το διαγράψει.';
$string['notemplatesurveys'] = 'Κανένα υπόδειγμα ερωτηματολογίου.';
$string['notificationfull'] = 'Πλήρης υποβολή';
$string['notifications'] = 'Αποστολή ειδοποιήσεων υποβολής';
$string['notifications_link'] = 'mod/questionnaire/mod#Submission_Notifications';
$string['notificationsimple'] = 'Μόνο ειδοποίηση';
$string['notopen'] = 'Το ερωτηματολόγιο αυτό δεν θα ανοίξει μέχρι {$a}.';
$string['notrequired'] = 'Δεν απαιτείται απόκριση';
$string['notset'] = 'δεν ορίστηκε';
$string['nousersselected'] = 'Δεν επιλέχθηκαν χρήστες';
$string['num'] = '#';
$string['numattemptsmade'] = 'Έγιναν {$a} προσπάθειες σε αυτό το ερωτηματολόγιο';
$string['numberofdecimaldigits'] = 'Αριθμός δεκαδικών ψηφίων';
$string['numberofdecimaldigits_help'] = 'Χρησιμοποιήστε τη ρύθμιση **Αριθμός δεκαδικών ψηφίων** για να καθορίσετε το μορφότυπο της μέσης τιμής που υπολογίζεται και εμφανίζεται στη σελίδα αναφοράς ερωτηματολογίου.';
$string['numberofdecimaldigits_link'] = 'mod/questionnaire/questions#Numeric';
$string['numberscaleitems'] = 'Αριθμ. αντικειμένων κλίμακας';
$string['numeric'] = 'Αριθμητικό';
$string['of'] = 'από';
$string['opendate'] = 'Να επιτρέπονται απαντήσεις από';
$string['option'] = 'επιλογή {$a}';
$string['optional'] = 'Προαιρετικό - Πρέπει να πληρούται τουλάχιστον μία από τις εξαρτήσεις.';
$string['optionalname'] = 'Όνομα ερώτησης';
$string['optionalname_link'] = 'mod/questionnaire/questions#Question_Name';
$string['or'] = '- Ή -';
$string['order_ascending'] = 'Αύξουσα σειρά';
$string['order_default'] = 'Εμφάνιση προεπιλεγμένης σειράς';
$string['order_descending'] = 'Φθίνουσα σειρά';
$string['orderresponses'] = 'Άλλες αποκρίσεις';
$string['orderresponses_link'] = 'mod/questionnaire/report#Order_Responses';
$string['other'] = 'Άλλη:';
$string['otherempty'] = 'Εάν τικάρετε αυτή την επιλογή, πρέπει να δώσετε κάποιο κείμενο στο πλαίσιο κειμένου!';
$string['overviewnumresplog'] = 'αποκρίσεις';
$string['overviewnumresplog1'] = 'απόκριση';
$string['overviewnumrespvw'] = 'αποκρίσεις';
$string['overviewnumrespvw1'] = 'απόκριση';
$string['owner'] = 'Ιδιοκτήτης';
$string['page'] = 'Σελίδα';
$string['pageof'] = 'Σελίδα {$a->page} από {$a->totpages}';
$string['parent'] = 'Γονικό';
$string['participant'] = 'Συμμετέχοντας';
$string['pleasecomplete'] = 'Παρακαλούμε, συμπληρώστε αυτή την επιλογή.';
$string['pluginadministration'] = 'Διαχείριση ερωτηματολογίου';
$string['pluginname'] = 'Ερωτηματολόγιο';
$string['position'] = 'θέση';
$string['possibleanswers'] = 'Πιθανές απαντήσεις';
$string['preview_label'] = 'Προεπισκόπηση';
$string['preview_questionnaire'] = 'Προεπισκόπηση Ερωτηματολογίου';
$string['previewing'] = 'Προεπισκόπηση ερωτηματολογίου...';
$string['previous'] = 'Προηγούμενο';
$string['previouspage'] = 'Προηγούμενη σελίδα';
$string['print'] = 'Εκτύπωση αυτής της απόκρισης';
$string['printblank'] = 'Εκτύπωση κενού';
$string['privacy:metadata:questionnaire_resp_multiple'] = 'Μια απόκριση ερώτησης πολλαπλής επιλογής.';
$string['privacy:metadata:questionnaire_resp_single'] = 'Μια απόκριση ερώτησης απλής επιλογής.';
$string['privacy:metadata:questionnaire_response'] = 'Μια απόκριση σε εξέλιξη ή που υποβλήθηκε';
$string['privacy:metadata:questionnaire_response:complete'] = 'Η κατάσταση ολοκλήρωσης απόκρισης.';
$string['privacy:metadata:questionnaire_response:grade'] = 'Ο βαθμός για αυτή την απόκριση.';
$string['privacy:metadata:questionnaire_response:userid'] = 'Το αναγνωριστικό του χρήστη για αυτή την απόκριση.';
$string['privacy:metadata:questionnaire_response_bool'] = 'Μια απόκριση ερώτησης αληθείας (boolean) (ναι/όχι).';
$string['privacy:metadata:questionnaire_response_bool:choice_id'] = 'Η συγκεκριμένη απάντηση αληθείας (boolean).';
$string['privacy:metadata:questionnaire_response_date'] = 'Μια απόκριση ερώτησης ημερομηνίας.';
$string['privacy:metadata:questionnaire_response_date:response'] = 'Η συγκεκριμένη απάντηση ημερομηνίας.';
$string['privacy:metadata:questionnaire_response_other:response'] = 'Η συγκεκριμένη απάντηση κειμένου.';
$string['privacy:metadata:questionnaire_response_text'] = 'Μια απόκριση ερώτησης κειμένου.';
$string['privacy:metadata:questionnaire_response_text:response'] = 'Η συγκεκριμένη απάντηση κειμένου.';
$string['private'] = 'Ιδιωτικό';
$string['progressbar'] = 'Εμφάνιση μπάρας προόδου';
$string['progressbar_info'] = 'Ολοκληρώθηκε το ερωτηματολόγιο {$a}.';
$string['progresshelp'] = 'Μπάρα προόδου';
$string['progresshelp_help'] = 'Μεταβείτε στην επόμενη σελίδα για να συμπληρωθεί η γραμμή προόδου';
$string['public'] = 'Δημόσιο';
$string['publiccopy'] = 'Αντίγραφο:';
$string['publicoriginal'] = 'Πρωτότυπο:';
$string['qtype'] = 'Τύπος';
$string['qtype_help'] = 'Επιλέξτε αν θα επιτρέπεται στους χρήστες να αποκρίνονται μία φορά, καθημερινά, εβδομαδιαία, μηνιαία ή απεριόριστες φορές (πολλές).';
$string['qtypedaily'] = 'απόκριση ημερησίως';
$string['qtypemonthly'] = 'απόκριση μηνιαίως';
$string['qtypeonce'] = 'απόκριση μία φορά';
$string['qtypeunlimited'] = 'απόκριση πολλές φορές';
$string['qtypeweekly'] = 'απόκριση εβδομαδιαίως';
$string['questionnaire:addinstance'] = 'Προσθήκη νέου ερωτηματολογίου';
$string['questionnaire:createpublic'] = 'Δημιουργία δημοσίων ερωτηματολογίων';
$string['questionnaire:createtemplates'] = 'Δημιουργία υποδειγμάτων ερωτηματολογίων';
$string['questionnaire:deleteresponses'] = 'Διαγραφή της απόκρισής μου';
$string['questionnaire:downloadresponses'] = 'Διαγραφή αποκρίσεων σε ένα αρχείο CSV';
$string['questionnaire:editquestions'] = 'Δημιουργία και τροποποίηση ερωτήσεων ερωτηματολογίων';
$string['questionnaire:manage'] = 'Δημιουργία και τροποποίηση ερωτηματολογίων';
$string['questionnaire:message'] = 'Αποστολή μηνύματος σε μη απαντήσαντες';
$string['questionnaire:preview'] = 'Προεπισκόπηση ερωτηματολογίων';
$string['questionnaire:printblank'] = 'Εκτύπωση κενού ερωτηματολογίου';
$string['questionnaire:readownresponses'] = 'Διαβάστε τις δικές σας απαντήσεις';
$string['questionnaire:submissionnotification'] = 'Λάβετε ειδοποίηση για κάθε υποβολή';
$string['questionnaire:submit'] = 'Ολοκλήρωση και υποβολή ενός ερωτηματολογίου';
$string['questionnaire:view'] = 'Εμφάνιση ενός ερωτηματολογίου';
$string['questionnaireadministration'] = 'Διαχείριση Ερωτηματολογίου';
$string['questionnairecloses'] = 'Το ερωτηματολόγιο κλείνει';
$string['questionnaireopens'] = 'Το ερωτηματολόγιο ανοίγει';
$string['questionnairereport'] = 'Αναφορά Ερωτηματολογίου';
$string['questionnum'] = 'Ερώτηση #';
$string['questions'] = 'Ερωτήσεις';
$string['questionsinsection'] = 'Ερωτήσεις σε αυτήν την ενότητα:';
$string['questiontypes'] = 'Τύποι ερωτήσεων';
$string['questiontypes_help'] = 'Δείτε την τεκμηρίωση του Moodle παρακάτω';
$string['questiontypes_link'] = '';
$string['radiobuttons'] = 'Κουμπιά μοναδικής επιλογής';
$string['radiobuttons_link'] = '';
$string['rank'] = 'Κατάταξη';
$string['ratescale'] = 'Κατάταξη (κλίμακα 1..5)';
$string['ratescale_help'] = 'Δείτε την τεκμηρίωση του Moodle παρακάτω';
$string['ratescale_link'] = 'mod/questionnaire/questions#Rate_.28scale_1..5.29';
$string['realm'] = 'Τύπος Ερωτηματολογίου';
$string['realm_link'] = '';
$string['remove'] = 'Διαγραφή';
$string['removeallquestionnaireattempts'] = 'Διαγραφή όλων των αποκρίσεων ερωτηματολογίου';
$string['required'] = 'Η απόκριση απαιτείται';
$string['required_link'] = '';
$string['requiredparameter'] = 'Μια απαιτούμενη παράμετρος λείπει.';
$string['reset'] = 'Επαναρχικοποίηση';
$string['respondent'] = 'Αποκρινόμενος';
$string['respondenteligibleall'] = 'όλα';
$string['respondenteligiblestudents'] = 'μόνο μαθητές';
$string['respondenteligibleteachers'] = 'μόνο διδάσκοντες';
$string['respondents'] = 'Αποκρινόμενοι';
$string['respondenttype'] = 'Τύπος αποκρινόμενου';
$string['respondenttype_link'] = 'mod/questionnaire/mod#Respondent_Type';
$string['respondenttypeanonymous'] = 'ανώνυμα';
$string['respondenttypefullname'] = 'πλήρες όνομα';
$string['response'] = 'Απόκριση';
$string['responsefieldlines'] = 'Μέγεθος πλαισίου εισόδου';
$string['responseformat'] = 'Μορφότυπος απόκρισης';
$string['responseoptions'] = 'Επιλογές απόκρισης';
$string['responses'] = 'Αποκρίσεις';
$string['responseview'] = 'Οι μαθητές μπορούν να δουν ΟΛΕΣ τις αποκρίσεις';
$string['responseview_link'] = 'mod/questionnaire/mod#Response_viewing';
$string['responseviewstudentsalways'] = 'Πάντα';
$string['responseviewstudentsnever'] = 'Ποτέ';
$string['responseviewstudentswhenanswered'] = 'Μετά την απάντηση του ερωτηματολογίου';
$string['responseviewstudentswhenclosed'] = 'Αφού κλείσει το ερωτηματολόγιο';
$string['restrictedtoteacher'] = 'Αυτές οι λειτουργίες περιορίζονται μόνο για συντάκτες-διδάσκοντες (με δικαίωμα επεξεργασίας)!';
$string['resume'] = 'Αποθήκευση/Συνέχιση απαντήσεων';
$string['resume_link'] = 'mod/questionnaire/mod#Save/Resume_answers';
$string['resumesurvey'] = 'Συνέχιση ερωτηματολογίου';
$string['return'] = 'Επιστροφή';
$string['save'] = 'Αποθήκευση';
$string['saveasnew'] = 'Αποθήκευση ως νέας ερώτησης';
$string['savedbutnotsubmitted'] = 'Αυτό το ερωτηματολόγιο έχει αποθηκευτεί αλλά δεν έχει υποβληθεί ακόμη.';
$string['savedprogress'] = 'Η πρόοδός σας έχει αποθηκευτεί. Μπορείτε να επιστρέψετε σε οποιαδήποτε στιγμή για να ολοκληρώσετε αυτό το ερωτηματολόγιο.';
$string['saveeditedquestion'] = 'Αποθήκευση της ερώτησης {$a}';
$string['savesettings'] = 'Αποθήκευση ρυθμίσεων';
$string['search:activity'] = 'Ερωτηματολόγιο - πληροφορίες δραστηριότητας';
$string['search:question'] = 'Ερωτηματολόγιο - ερωτήσεις';
$string['section'] = 'Περιγραφή';
$string['sectionbreak'] = '--- Αλλαγή Σελίδας --';
$string['sectionbreak_help'] = '--- Αλλαγή Σελίδας --';
$string['sectionsnotset'] = 'Πρέπει να επιλέξετε τουλάχιστον ΜΙΑ ερώτηση ανά ενότητα!<br />Μη επιλεγμένη/-ες ενότητες: {$a}';
$string['sectiontext'] = 'Ταμπέλα';
$string['sectiontext_help'] = 'Αυτό δεν είναι μια ερώτηση αλλά ένα (σύντομο) κείμενο που θα εμφανιστεί για να εισαγάγει μια σειρά ερωτήσεων.';
$string['selecttheme'] = 'Επιλογή ενός αισθητικού θέματος (css) προς χρήση με αυτό το ερωτηματολόγιο.';
$string['send'] = 'Αποστολή';
$string['send_message'] = 'Αποστολή μηνύματος σε επιλεγμένους χρήστες';
$string['send_message_to'] = 'Αποστολή μηνύματος προς:';
$string['sendemail'] = 'Αποστολή μηνύματος ηλε.ταχυδρομείου';
$string['settings'] = 'Ρυθμίσεις';
$string['settingssaved'] = 'Οι ρυθμίσεις αποθηκεύτηκαν';
$string['show_nonrespondents'] = 'Μη αποκριθέντες';
$string['started'] = 'ξεκίνησαν';
$string['strfdate'] = '%d/%m/%Y';
$string['strfdateformatcsv'] = 'd/m/Y H:i:s';
$string['subject'] = 'Θέμα';
$string['submissionnotificationhtmlanon'] = 'Υπάρχει μια νέα <a href="{$a->submissionurl}">υποβολή</a> για το ερωτηματολόγιο «{$a->name}».';
$string['submissionnotificationsubject'] = 'Υποβολή νέου ερωτηματολογίου';
$string['submissionnotificationtextanon'] = 'Υπάρχει μια νέα υποβολή ({$a->submissionurl}) για το ερωτηματολόγιο «{$a->name}».';
$string['submitoptions'] = 'Επιλογές υποβολής';
$string['submitpreview'] = 'Προεπισκόπηση υποβολής';
$string['submitsurvey'] = 'Υποβολή ερωτηματολογίου';
$string['submitted'] = 'Υποβλήθηκε:';
$string['subtitle'] = 'Υπότιτλος';
$string['summary'] = 'Περίληψη';
$string['surveynotexists'] = 'το ερωτηματολόγιο δεν υπάρχει.';
$string['surveyowner'] = 'Πρέπει να είστε ένας ιδιοκτήτης ερωτηματολογίου για να εκτελέσετε αυτή την λειτουργία.';
$string['template'] = 'Υπόδειγμα';
$string['templatenotviewable'] = 'Τα υποδείγματα ερωτηματολογίων δεν μπορούν να εμφανιστούν.';
$string['text'] = 'Κείμενο ερώτησης';
$string['textareacolumns'] = 'Στήλες περιοχής κειμένου';
$string['textarearows'] = 'Γραμμές περιοχής κειμένου';
$string['textbox'] = 'Πλαίσιο κειμένου';
$string['textdownloadoptions'] = 'Επιλογές για λήψη CSV';
$string['thank_head'] = 'Ευχαριστούμε για την συμπλήρωση αυτού του ερωτηματολογίου';
$string['theme'] = 'Αισθητικό θέμα';
$string['thismonth'] = 'αυτό το μήνα';
$string['thisresponse'] = 'Αυτή η απόκριση';
$string['thisweek'] = 'αυτή η εβδομάδα';
$string['thousands'] = 'Χωρίς χρήση διαχωριστών χιλιάδων.';
$string['title'] = 'Τίτλος';
$string['today'] = 'σήμερα';
$string['total'] = 'Σύνολο';
$string['totalofnumbers'] = 'Σύνολο αριθμών που δόθηκαν';
$string['totalresponses'] = 'Συνολικές αποκρίσεις στην ερώτηση';
$string['type'] = 'Τύπος ερώτησης';
$string['undefinedquestiontype'] = 'Μη ορισμένος τύπος ερώτησης!';
$string['unknown'] = 'Άγνωστος';
$string['unknownaction'] = 'Καθορίστηκε άγνωστη ενέργεια ερωτηματολογίου...';
$string['url'] = 'Διεύθυνση URL επιβεβαίωσης';
$string['useprivate'] = 'Αντιγραφή υπάρχοντος';
$string['usepublic'] = 'Χρήση δημόσιου';
$string['usetemplate'] = 'Χρήση υποδείγματος';
$string['vertical'] = 'Κάθετο';
$string['view'] = 'Προβολή';
$string['viewallresponses'] = 'Εμφάνιση όλων των αποκρίσεων';
$string['viewallresponses_link'] = 'Viewing_Questionnaire_responses#Group_filtering';
$string['viewbyresponse'] = 'Λίστα αποκρίσεων';
$string['viewindividualresponse'] = 'Προσωπικές αποκρίσεις';
$string['viewresponses'] = 'Όλες οι αποκρίσεις ({$a})';
$string['warning'] = 'Προειδοποίηση, παρουσιάστηκε σφάλμα.';
$string['wronganswers'] = 'Υπάρχει κάτι λάθος με τις απαντήσεις σας (δείτε παρακάτω)';
$string['wrongdateformat'] = 'Η ημερομηνία που εισαγάγατε: <strong>{$a}</strong> δεν αντιστοιχεί στον μορφότυπο που εμφανίζεται στο παράδειγμα.';
$string['wrongdaterange'] = 'ΣΦΑΛΜΑ! Το έτος πρέπει να καθοριστεί στην διάστημα 1902-2037.';
$string['wrongformat'] = 'Υπάρχει κάτι λάθος με την απάντησή σας στην ερώτηση:&nbsp;';
$string['wrongformats'] = 'Υπάρχει κάτι λάθος με την απάντησή σας σε ερωτήσεις:&nbsp;';
$string['yesno'] = 'Ναι/Όχι';
$string['yesno_help'] = 'Απλή ερώτηση Ναι/Όχι.';
$string['yourresponse'] = 'Η απόκρισή σας';
$string['yourresponses'] = 'Η αποκρίσεις σας';
