<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'auth_saml2', language 'no', version '5.0'.
 *
 * @package     auth_saml2
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['alterlogout'] = 'Alternativ utloggings-URL';
$string['alterlogout_help'] = 'Den URL-en en bruker sendes til når utlogging er fullført';
$string['anyauth'] = 'Tillatt alle autentiseringstyper';
$string['anyauth_help'] = 'JA: Tillat SAML innlogging for alle brukere? NEI: Bare brukere som har saml2 som autentiseringsmetode.';
$string['attemptsignout'] = 'Forsøk IdP utlogging';
$string['attemptsignout_help'] = 'Dette vil forsøke å kommunisere med IdP-en for å sende en utloggingsforespørsel';
$string['attrsimple'] = 'Forenkle attributter';
$string['attrsimple_help'] = 'Mange IdP-er som f.eks. ADFS bruker lange attributter som URNS eller "namespaced xml" skjemanavn. YES vil forenkle disse og mappe f.eks. http://schemas.xmlsoap.org/ws/2005/05/identity/claims/givenname til "givenname".';
$string['auth_data_mapping'] = 'Datamapping';
$string['auth_fieldlock_expl'] = '<p></br />Lås verdi:<br />Hvis aktivert, vil forhindre Moodle brukere og administratorer fra å redigere feltet direkte. Bruk dette valget hvis du vedlikeholder dataene fra et eksternt system.</p>';
$string['auth_fieldlockfield'] = 'Lås verdi ({$a})';
$string['auth_fieldlocks'] = 'Lås brukerfelter';
$string['auth_fieldmapping'] = 'Data mapping ({$a})';
$string['auth_saml2description'] = 'Autentiser via en SAML2 IdP';
$string['auth_updatelocalfield'] = 'Oppdater lokal ({$a})';
$string['auth_updateremotefield'] = 'Oppdater ekstern ({$a})';
$string['autocreate'] = 'Opprett nye brukere automatisk';
$string['autocreate_help'] = 'Hvis brukere finnes hos IdP, men ikke i Moodle, opprettes brukerkontoen automatisk.';
$string['availableidps'] = 'Administrere tilgjengelige IdP-er';
$string['availableidps_help'] = 'Hvis IdP metadata innholder flere IdP-kilder eller du har angitt flere metadata URL-er, vil du trenge å velge hvem av kildene brukerne skal benytte.';
$string['cannotmapfield'] = 'Mappingskonflikt oppdaget - to felter mapper det samme karakterelementet {$a}';
$string['certificate'] = 'Regenerér sertifikat';
$string['certificate_help'] = 'Regenerer privat nøkkel og sertifikat som er brukt med denne SP-en.  | <a href=\'{$a}\'>Vis SP-sertifikat</a>';
$string['certificatedetails'] = 'Sertifikatdetaljer';
$string['certificatedetailshelp'] = '<h1>SAML2 autogenerert offentlig sertifikatinnhold</h1><p>Stien til sertifikatet er her:</p>';
$string['certificatelock'] = 'Lås sertifikatet';
$string['certificatelock_help'] = 'Låsing av sertifikatet forhindrer at det blir overskrevet på et senere tidspunkt.';
$string['certificatelock_locked'] = 'Sertifikatet er låst';
$string['certificatelock_warning'] = 'Advarsel. Du er i ferd med å låse sertifikatene. Er du helt sikker på at du vil gjøre dette?';
$string['commonname'] = 'Vanlig navn';
$string['countryname'] = 'Land';
$string['debug'] = 'Debugging';
$string['debug_help'] = '<p>Dette aktiverer ekstra debug informasjon til standard Moodle logg | <a href=\'{$a}\'>Vis SSP config</a></p>';
$string['duallogin'] = 'Dobbelt pålogging';
$string['duallogin_help'] = '<p>Hvis PÅ, vil brukerne se både manuell og SAML innloggingsalternativene. Hvis AV, vil de alltid bli tatt rett til IdP-innloggingssiden.</p>
<p>Hvis PASSIV, vil brukere som allerede er innlogget hos IdP automatisk logges inn, ellers vil de bli sendt til standard Moodle innloggingsside.</p>
<p>Hvis AV, kan admin fortsatt se manuell innlogging via /login/index.php?saml=off</p>
<p>Hvis PÅ, kan eksterne sider dyplenke til Moodle ved å bruke saml, f.eks. /course/view.php?id=45&saml=on</p>';
$string['errorparsingxml'] = 'Feil ved parsing av XML: {$a}';
$string['exception'] = 'SAML2 unntak: {$a}';
$string['expirydays'] = 'Utløper (om dager)';
$string['idpattr'] = 'Mapping IdP';
$string['idpattr_help'] = 'Hvilke IdP attributter skal mappes mot Moodles brukerfelt?';
$string['idpmetadata'] = 'IdP metadata xml ELLER offentlig xml URL';
$string['idpmetadata_badurl'] = 'Ugyldige metadata på {$a}';
$string['idpmetadata_help'] = 'For å bruke multiple IdP-er legges hver offentlig metadata URL på en ny linje.<br />For å overstyre et navn kan du plassere teksten foran http. F.eks. "Egendefinert navn https:/ssp.local/simplesaml/saml2/idp/metadata.php"';
$string['idpmetadata_invalid'] = 'XML for IdP-en er ikke gyldig';
$string['idpmetadata_noentityid'] = 'XML-fila for IdP-en mangler EntityID';
$string['idpmetadatarefresh'] = 'Forny IdP metadata';
$string['idpmetadatarefresh_help'] = 'Kjør en cron-jobb for å oppdatere IdP metadata fra IdP metadata URL-en';
$string['idpname'] = 'Overstyr IdP-navnet';
$string['idpname_help'] = 'Eks. myUNI - dette detekteres fra metadataene og vil vises på en innloggingsside med multippel innlogging';
$string['idpnamedefault'] = 'Logg inn via SAML2';
$string['idpnamedefault_varaible'] = 'Logg inn via SAML2 ({$a})';
$string['localityname'] = 'Lokalitet';
$string['locked'] = 'Låst';
$string['logdir'] = 'Loggmappe';
$string['logdir_help'] = 'Loggmappen som SSPHP skal skrive til. Fila blir hetende simplesamlphp.log';
$string['logdirdefault'] = '/tmp/';
$string['logtofile'] = 'Aktiver logging til fil';
$string['logtofile_help'] = 'Aktivering vil omdirigere SSPHP-loggen til en fil i loggmappen';
$string['manageidpsheading'] = 'Administrere tilgjengelige IdP-er';
$string['mdlattr'] = 'Moodle-mapping';
$string['mdlattr_help'] = 'Hvilke Moodle brukerfelt skal IdP-attributtene kobles med?';
$string['metadatafetchfailed'] = 'Henting av metadata var mislykket: {$a}';
$string['metadatafetchfailedstatus'] = 'Henting av metadata var mislykket: Statuskode {$a}';
$string['metadatafetchfailedunknown'] = 'Henting av metadata var mislykket: Ukjent cURL-feil';
$string['multiidpbuttons'] = 'Knapper med ikoner';
$string['multiidpdisplay'] = 'Visningstype for multippel IdP';
$string['multiidpdisplay_help'] = 'Hvis en IdP metadata xml inneholder flere IdP-enheter, hvordan skal hver av dem vises?';
$string['multiidpdropdown'] = 'Listemeny';
$string['multiidpinfo'] = '<ul>
<li>En IdP kan bare benyttes om den er aktivert</li>
<li>Når dobbel innlogging er aktivert på vil alle aktive IdP-er vises på innloggingssiden</li>
<li>Når en IdP er angitt som Standard og dobbel innlogging ikke er aktivert, vil denne IdP-en automatisk velges så sant  ?multiidp=on eller saml=off is passed på /login/index.php</li>
<li>Når en IdP er satt som Admin, vil alle brukere som logger inn via denne IdP-en automatisk bli en administrator</li>
<li>En IdP kan tildeles en alias. Når en går til  /login/index.php?idpalias={alias} vil aliaset automatisk benytte ønsket IdP</li>
</ul>';
$string['nameidasattrib'] = 'Vis NameID som attributt';
$string['nameidasattrib_help'] = 'NameID attributten vil vises til SSPHP som en attributt ved navn nameid';
$string['nameidpolicy'] = 'NameID policy';
$string['nameidpolicy_help'] = '';
$string['noattribute'] = 'Innloggingen din ble godkjent, men vi fant ikke din attributt \'{$a}\' for å koble deg til en konto i Moodle.';
$string['noidpfound'] = 'IdP-en \'{$a}\' kunne ikke finnes som konfigurert IdP.';
$string['nouser'] = 'Innloggingen som \'{$a}\' var vellykket, men du har ingen brukerkonto i Moodle.';
$string['nullprivatecert'] = 'Opprettelsen av privat sertifikat feilet.';
$string['nullpubliccert'] = 'Opprettelsen av offentlig sertifikat feilet.';
$string['organizationalunitname'] = 'Organisasjonsenhet';
$string['organizationname'] = 'Organisasjon';
$string['passivemode'] = 'Passiv modus';
$string['phone1'] = 'Telefon';
$string['phone2'] = 'Mobil';
$string['pluginname'] = 'SAML2';
$string['privacy:no_data_reason'] = 'SAML2-modulen lagrer ingen personlige informasjon.';
$string['regenerate_submit'] = 'Regenerér';
$string['rememberidp'] = 'Husk valgte innloggingstjeneste';
$string['required'] = 'Dette feltet er obligatorisk';
$string['requireint'] = 'Dette feltet er obligatorisk og må være et positivt heltall';
$string['selectloginservice'] = 'Velg en innloggingstjeneste';
$string['sha1'] = 'Tidligere SHA1 (Potensielt farlig valg)';
$string['sha256'] = 'SHA256';
$string['sha384'] = 'SHA384';
$string['sha512'] = 'SHA512';
$string['showidplink'] = 'Vis IdP-lenke';
$string['showidplink_help'] = 'Dette vil vise IdP-lenken når portalen er ferdig konfigurert.';
$string['signaturealgorithm'] = 'Signeringsalgoritme';
$string['signaturealgorithm_help'] = 'Dette er algoritmen som vil bli benyttet for å signere SAML-forespørsler. ADVARSEL: SHA1-algoritmen er kun tatt med for å være bakoverkompatibel. Vi anbefaler minst SHA256 i stedet.';
$string['spmetadata'] = 'SP Metadata';
$string['spmetadata_help'] = '<a href=\'{$a}\'>Vis tjenestetilbyders metadata</a> | <a href=\'{$a}?download=1\'>Last ned SP Metadata</a>
<p>Du må i noen tilfeller gi dette til IdP-administrator for å hviteliste deg.</p>';
$string['spmetadatasign'] = 'SP metadata signatur';
$string['spmetadatasign_help'] = 'Signér SP metadataene';
$string['sspversion'] = 'SimpleSAMLphp-versjon';
$string['stateorprovincename'] = 'Stat eller provins';
$string['suspendeduser'] = 'Innloggingen din som  \'{$a}\' var vellykket, men brukerkontoen din i Moodle er suspendert.';
$string['taskmetadatarefresh'] = 'Cron-jobb for å fornye metadata';
$string['test_auth_button_login'] = 'IdP Innlogging';
$string['test_auth_button_logout'] = 'IdP Utlogging';
$string['test_auth_str'] = 'Autentiserings- og innloggingstest';
$string['test_passive_str'] = 'Test via passiv modus';
$string['tolower'] = 'Små bokstaver';
$string['tolower_help'] = 'Konvertére IdP-attributten til små bokstaver før matching?';
$string['unlocked'] = 'Åpen';
$string['unlockedifempty'] = 'Åpen hvis tom';
$string['update_never'] = 'Aldri';
$string['update_oncreate'] = 'Ved opprettelse';
$string['update_onlogin'] = 'Ved hver innlogging';
$string['update_onupdate'] = 'Ved oppdatering';
$string['wrongauth'] = 'Innloggingen din ble godkjent som \'{$a}\', men er ikke autorisert for tilgang til Moodle.';
