<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'moodle', language 'sr_cr', version '5.0'.
 *
 * @package     moodle
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['abouttobeinstalled'] = 'ће управо бити инсталирано';
$string['accept'] = 'Прихвати';
$string['action'] = 'Акција';
$string['actionchoice'] = 'Шта желите да урадите са датотеком \'{$a}\'?';
$string['actions'] = 'Акције';
$string['actionsfor'] = 'Акција за {$a}';
$string['actionsmenu'] = 'Мени акција';
$string['active'] = 'Активан';
$string['activeusers'] = 'Активни корисници';
$string['activities'] = 'Активности';
$string['activities_help'] = 'Активности, као што су форуми, тестови и вики документи омогућавају да курсу буде додат интерактивни садржај.';
$string['activity'] = 'Активност';
$string['activityclipboard'] = 'Премештање ове активности: {$a}';
$string['activityheader'] = 'Мени активности';
$string['activityicon'] = 'Иконица активности {$a}';
$string['activityiscurrentlyhidden'] = 'Нажалост, ова активност тренутно није доступна';
$string['activitymodule'] = 'Модул активности';
$string['activitymodules'] = 'Модули активности';
$string['activitynotready'] = 'Активност још није спремна';
$string['activityorresource'] = 'Активност или ресурс';
$string['activityreport'] = 'Извештај о активности';
$string['activityreports'] = 'Извештаји о активностима';
$string['activityselect'] = 'Изаберите ову активност како бисте је преместили на друго место';
$string['activitysince'] = 'Активност од {$a}';
$string['activitytypetitle'] = '{$a->activity} - {$a->type}';
$string['activityweighted'] = 'Активност по кориснику';
$string['add'] = 'Додај';
$string['addactivity'] = 'Додај активност...';
$string['addactivitytosection'] = 'Додај активност у секцију \'{$a}\'';
$string['addadmin'] = 'Додај администратора';
$string['addblock'] = 'Додај блок';
$string['addcomment'] = 'Додај коментар...';
$string['addcondition'] = 'Додај услов';
$string['addcontent'] = 'Додајте садржај';
$string['addcountertousername'] = 'Креирај корисника додавањем броја корисничком имену';
$string['addcreator'] = 'Додај креатора курса';
$string['adddots'] = 'Додај...';
$string['added'] = 'Додато {$a}';
$string['addedtogroup'] = 'Додат(а) групи "{$a}"';
$string['addedtogroupnot'] = 'Није додат(а) групи "{$a}"';
$string['addedtogroupnotenrolled'] = 'Није додат(а) групи "{$a}", јер није уписан(а) на курс';
$string['addfilehere'] = 'Спустите датотеке овде да бисте их додали на крај ове секције';
$string['addfilesdrop'] = 'Овде можете превући и спустити датотеке како бисте их поставили или кликнути како бисте их изабрали.';
$string['addinganew'] = 'Нова активност: {$a}';
$string['addingdatatoexisting'] = 'Додавање података постојећим';
$string['additionalcustomnav'] = 'Додатна прилагођена навигација';
$string['additionalnames'] = 'Додатна имена';
$string['addlinkhere'] = 'Додај линк овде';
$string['addnew'] = 'Додај нов {$a}';
$string['addnewcategory'] = 'Додај нову категорију';
$string['addnewcourse'] = 'Додај нови курс';
$string['addnewuser'] = 'Додај новог корисника';
$string['addnousersrecip'] = 'Додавање корисника који није приступио овоме {$a} на листу прималаца';
$string['addpagehere'] = 'Додај текст овде';
$string['addresource'] = 'Додај ресурс...';
$string['addresourceoractivity'] = 'Додај активност или ресурс';
$string['addresourcetosection'] = 'Додај ресурс у секцију \'{$a}\'';
$string['address'] = 'Адреса';
$string['addsections'] = 'Додај секције';
$string['addstudent'] = 'Додај полазника';
$string['addsubcategory'] = 'Додај поткатегорију';
$string['addteacher'] = 'Додај предавача';
$string['admin'] = 'Администрација';
$string['adminhelpaddnewuser'] = 'Ручно креирање новог корисничког налога';
$string['adminhelpassignadmins'] = 'Администратори имају потпуна овлашћења на овом сајту';
$string['adminhelpassigncreators'] = 'Креатори курсева могу да креирају нове курсеве';
$string['adminhelpassignsiteroles'] = 'Примени дефинисане улоге на нивоу сајта на одређене кориснике';
$string['adminhelpassignstudents'] = 'Идите на курс и додајте нове полазнике из администраторског менија';
$string['adminhelpauthentication'] = 'Можете користити интерне корисничке налоге или екстерне базе података';
$string['adminhelpbackup'] = 'Конфигуришите аутоматско креирање резервних копија и временски распоред њиховог извршавања';
$string['adminhelpconfiguration'] = 'Конфигуришите како сајт изгледа и функционише';
$string['adminhelpconfigvariables'] = 'Конфигуришите променљиве које утичу на општу функционалност сајта';
$string['adminhelpcourses'] = 'Одредите курсеве и категорије и упишите полазнике у њих, уредите курсеве на чекању';
$string['adminhelpeditorsettings'] = 'Дефинишите основна подешавања HTML едитора';
$string['adminhelpedituser'] = 'Претражите листу корисничких налога и уредите било који од њих';
$string['adminhelpenvironment'] = 'Проверите у којој мери ваш сервер испуњава тренутне и будуће захтеве за успешну инсталацију';
$string['adminhelpfailurelogs'] = 'Прегледајте записе о неуспешним пријавама на систем';
$string['adminhelplanguage'] = 'Провера и уређивање важећег језичког пакета';
$string['adminhelplogs'] = 'Прегледајте записе о свим активностима на сајту';
$string['adminhelpmanageblocks'] = 'Управљање инсталираним блоковима и њиховим подешавањима';
$string['adminhelpmanagedatabase'] = 'Директно приступите бази података (али опрезно!)';
$string['adminhelpmanagefilters'] = 'Избор текстуалних филтера и њихова подешавања';
$string['adminhelpmanagemodules'] = 'Управљање инсталираним модулима и њиховим подешавањима';
$string['adminhelpmanageroles'] = 'Креирање и дефинисање улога које се могу применити на кориснике';
$string['adminhelpmymoodle'] = 'Конфигуришите "Мој Moodle" блокове за кориснике';
$string['adminhelpreports'] = 'Извештаји на нивоу сајта';
$string['adminhelpsitefiles'] = 'Служи за објављивање општих датотека или постављање резервних копија';
$string['adminhelpsitesettings'] = 'Дефинишите како изгледа насловна страница сајта';
$string['adminhelpstickyblocks'] = 'Конфигуришите фиксне блокове на читавом сајту';
$string['adminhelpthemes'] = 'Изаберите како да изгледа сајт (боје, фонтови и сл.)';
$string['adminhelpuploadusers'] = 'Увезите нове корисничке налоге из текстуалне датотеке';
$string['adminhelpusers'] = 'Одредите своје кориснике и подесите начин провере идентитета';
$string['adminhelpxmldbeditor'] = 'Интерфејс за уређивање XMLDB датотека. Само за кориснике са уређивачким правима.';
$string['administration'] = 'Администрација';
$string['administrationsite'] = 'Администрација сајта';
$string['administrator'] = 'Администратор';
$string['administratordescription'] = 'Администратори обично могу да раде шта год желе у оквиру сајта, на било ком курсу.';
$string['administrators'] = 'Администратори';
$string['administratorsall'] = 'Сви администратори';
$string['administratorsandteachers'] = 'Администратори и предавачи';
$string['advanced'] = 'Напредно';
$string['advancedfilter'] = 'Напредно претраживање';
$string['advancedsettings'] = 'Напредна подешавања';
$string['afterresource'] = 'После ресурса "{$a}"';
$string['aftersection'] = 'Након секције "{$a}"';
$string['again'] = 'поново';
$string['agelocationverification'] = 'Провера старости и места';
$string['ajaxuse'] = 'AJAX и Javascript';
$string['all'] = 'Све';
$string['allactions'] = 'Све акције';
$string['allactivities'] = 'Све активности';
$string['allcategories'] = 'Све категорије';
$string['allchanges'] = 'Све промене';
$string['alldays'] = 'Сви дани';
$string['allfiles'] = 'Све датотеке';
$string['allgroups'] = 'Све групе';
$string['alllogs'] = 'Сви записи о активностима';
$string['allmods'] = 'Сви {$a}';
$string['allow'] = 'Дозволити';
$string['allowinternal'] = 'Дозволити и интерне начине ауторизације';
$string['allownone'] = 'Не дозволити ништа';
$string['allownot'] = 'Не дозволити';
$string['allowstealthmodules'] = 'Дозволи невидљиве активности';
$string['allowstealthmodules_help'] = 'Ако је омогућено, активности могу да буду доступне али не и приказане у видљивим секцијама на страници курса. У том случају линкови ка невидљивим активностима морају се поставити негде друго унутар курса (на пример, унутар ресурса \'Страница\'). Невидљиве активности ће и даље бити наведена у књизи оцена и другим извештајима.';
$string['allparticipants'] = 'Сви учесници';
$string['allteachers'] = 'Сви предавачи';
$string['alphanumerical'] = 'Може једино да садржи алфанумеричке знакове (слова и бројеве), цртицу (-) или тачку (.)';
$string['alreadyconfirmed'] = 'Регистрација је већ потврђена';
$string['alternatename'] = 'Алтернативно име';
$string['always'] = 'Увек';
$string['and'] = '{$a->one} и {$a->two}';
$string['answer'] = 'Одговор';
$string['any'] = 'Било које';
$string['appearance'] = 'Изглед';
$string['apply'] = 'Примени';
$string['applyfilters'] = 'Примени филтере';
$string['approve'] = 'Одобри';
$string['areyousure'] = 'Да ли сте сигурни?';
$string['areyousuretorestorethis'] = 'Желите ли да наставите?';
$string['areyousuretorestorethisinfo'] = 'Током овог поступка моћи ћете одабрати да ли желите да додате ову датотеку са резервним копијама већ постојећем курсу или да креирате потпуно нови курс.';
$string['asc'] = 'Растући';
$string['assessment'] = 'Процена';
$string['assignadmins'] = 'Одређивање администратора';
$string['assigncreators'] = 'Одређивање креатора';
$string['assignedrolecount'] = '{$a->role}: {$a->count}';
$string['assignsiteroles'] = 'Одређивање улога на нивоу сајта';
$string['authenticateduser'] = 'Ауторизовани корисник';
$string['authenticateduserdescription'] = 'Сви тренутно пријављени корисници';
$string['authentication'] = 'Провера идентитета';
$string['authenticationplugins'] = 'Додаци за проверу идентитета';
$string['autosubscribe'] = 'Аутоматска пријава на форум';
$string['autosubscribeno'] = 'Не: не желим аутоматску пријаву на дискусије форума';
$string['autosubscribeyes'] = 'Да: кад пошаљем поруку, пријави ме на ту дискусију форума';
$string['availability'] = 'Доступност';
$string['availablecourses'] = 'Доступни курсеви';
$string['back'] = 'Назад';
$string['backto'] = 'Повратак на {$a}';
$string['backtocourselisting'] = 'Повратак на листу курсева';
$string['backtohome'] = 'Повратак на насловну страницу сајта';
$string['backtopageyouwereon'] = 'Повратак на страницу на којој сте били';
$string['backup'] = 'Креирање резервне копије';
$string['backupactivehelp'] = 'Изаберите да ли треба или не треба аутоматски креирати резервне копије.';
$string['backupadhocpending'] = 'Ад хок задатак креирања резервне копије курса на чекању';
$string['backupcancelled'] = 'Креирање резервне копије је отказано';
$string['backupcoursefileshelp'] = 'Ако је ово подешавање омогућено,  датотеке курса ће бити укључене у аутоматски креиране резервне копије';
$string['backupdate'] = 'Датум креирања резервне копије';
$string['backupdatenew'] = '&nbsp; {$a->TAG} сада је {$a->weekday}, {$a->mday} {$a->month} {$a->year}<br />';
$string['backupdateold'] = '{$a->TAG} био је {$a->weekday}, {$a->mday} {$a->month} {$a->year}';
$string['backupdaterecordtype'] = '<br />{$a->recordtype} - {$a->recordname}<br />';
$string['backupdetails'] = 'Подаци о резервној копији';
$string['backuperrorinvaliddestination'] = 'Одредишни директоријум резервне копије не постоји или се у њега не може уписивати.';
$string['backupexecuteathelp'] = 'Изаберите време за аутоматско креирање резервних копија.';
$string['backupfailed'] = 'Неки од ваших курсева нису сачувани.';
$string['backupfilename'] = 'резервна копија';
$string['backupfinished'] = 'Креирање резервне копије је успешно завршено';
$string['backupfromthissite'] = 'Да ли је резервна копија креирана на овом сајту?';
$string['backupgradebookhistoryhelp'] = 'Ако је ово подешавање омогућено, онда ће историја књиге оцена бити укључена у аутоматску резервну копију. Имајте у виду, да историја оцена не сме бити онемогућена у подешавањима сервера (disablegradehistory) како би ово могло да функционише.';
$string['backupincludemoduleshelp'] = 'Одаберите желите ли у аутоматску процедуру креирања резервних копија да укључите и модуле курса, са или без корисничких података';
$string['backupincludemoduleuserdatahelp'] = 'Изаберите да ли желите да укључите податке корисника модула у аутоматски креиране резервне копије.';
$string['backupinfo'] = 'Креирајте копију овог курса, укључујући сав садржај и активности. Можете да употребите датотеку резервне копије како бисте рестаурирали курс.';
$string['backuplogdetailed'] = 'Детаљни извештај о извршавању';
$string['backuploglaststatus'] = 'Извештај о последњем извршавању';
$string['backupmissinguserinfoperms'] = 'Напомена: ова резервна копија података не садржи корисничке податке. Активности као што су Вежба и Радионица неће бити укључене у резервну копију, с обзиром да ови модули нису компатибилни са овим типом резервне копије података.';
$string['backupnext'] = 'Следећа резервна копија';
$string['backupnonisowarning'] = 'Упозорење: ова резервна копија је креирана у верзији Moodle система која није подржавала Unicode (пре верзије 1.6). Ако ова резервна копија садржи текстове који се не слажу са ISO-8859-1 може бити ОШТЕЋЕНА ако покушате да је рестаурирате у овој Unicode Moodle верзији. Погледајте <a href="https://docs.moodle.org/en/Backup_FAQ">Backup FAQ</a>за више информација о томе како да правилно урадите опоравак ове резервне копије.';
$string['backupnotyetrun'] = 'Аутоматска резервна копије на чекању';
$string['backuporiginalname'] = 'Назив резервне копије';
$string['backuproleassignments'] = 'Направи резервну копију доделе ових улога';
$string['backupsavetohelp'] = 'Пуна путања до директоријума у којем желите да сачувате датотеке са резервним копијама';
$string['backupsitefileshelp'] = 'Ако је ово подешавање омогућено, онда ће датотеке сајта коришћене у курсевима бити укључени у аутоматску резервну копију.';
$string['backuptakealook'] = 'Молимо погледајте записе о креирању ваших резервних копија у: {$a}';
$string['backupuserfileshelp'] = 'Одаберите да ли би требало да се корисничке датотеке (нпр. слике за личне профиле корисника) укључе у аутоматски креиране резервне копије';
$string['backupversion'] = 'Верзија резервне копије';
$string['badges'] = 'Беџеви';
$string['between'] = 'Између';
$string['block'] = 'Блок';
$string['blockconfiga'] = 'Конфигурисање блока {$a}';
$string['blockconfigbad'] = 'Овај блок није правилно имплементиран и зато не можете користити конфигурациони интерфејс';
$string['blocks'] = 'Блокови';
$string['blocks_main'] = 'Главни блокови';
$string['blocks_supplementary'] = 'Додатни блокови';
$string['blocksaddedit'] = 'Додај/Уреди блокове';
$string['blockseditoff'] = 'Искључи уређивање блокова';
$string['blocksediton'] = 'Укључи уређивање блокова';
$string['blocksetup'] = 'Подешавање табела блокова';
$string['blocksuccess'] = '{$a} табела је исправно подешена';
$string['brief'] = 'Укратко';
$string['bulkactions'] = 'Групне акције';
$string['bulkactionselect'] = 'Избор масовне акције {$a}';
$string['bulkcancel'] = 'Затворите групно уређивање';
$string['bulkmovecoursessuccess'] = 'Успешно је премештено {$a->courses} курс(ев)а у {$a->category}';
$string['bulkselection'] = 'Изабрано: {$а}';
$string['bycourseorder'] = 'Поредак по курсевима';
$string['byname'] = 'од {$a}';
$string['bypassed'] = 'Избегнуто';
$string['cachecontrols'] = 'Контрола кеширања';
$string['calltofeedback'] = 'Креатори овог софтвера би волели да добију повратне информације од вас.';
$string['calltofeedback_give'] = 'Пошаљите повратне информације о овом софтверу';
$string['calltofeedback_remind'] = 'Подсети ме касније';
$string['cancel'] = 'Откажи';
$string['cancelled'] = 'Отказано';
$string['categories'] = 'Категорије курсева';
$string['categoriesandcourses'] = 'Категорије курсева и курсеви';
$string['category'] = 'Категорија';
$string['categoryadded'] = 'Додата је категорија \'{$a}\'';
$string['categorybulkaction'] = 'Групне акције за изабране категорије';
$string['categorycontents'] = 'Поткатегорије и курсеви';
$string['categorycurrentcontents'] = 'Садржаји категорије {$a}';
$string['categorydeleted'] = 'Обрисана је категорија \'{$a}\'';
$string['categoryduplicate'] = 'Категорија под називом \'{$a}\' већ постоји';
$string['categoryheader'] = 'Мени категорије';
$string['categoryhidden'] = '(сакривена)';
$string['categorymodifiedcancel'] = 'Категорија је измењена! Молимо Вас да изађете и покушате поново.';
$string['categoryname'] = 'Назив категорије';
$string['categorypath'] = 'Путања категорије';
$string['categorysubcategoryof'] = '{$a->category} - поткатегорија категорије {$a->parentcategory}';
$string['categoryupdated'] = 'Категорија \'{$a}\' је ажурирана';
$string['changedpassword'] = 'Лозинка је промењена';
$string['changepassword'] = 'Промени лозинку';
$string['changesmade'] = 'Промене су направљене';
$string['changesmadereallygoaway'] = 'Направили сте промене. Да ли сте сигурни да желите да одете одавде  и изгубити своје промене?';
$string['changessaved'] = 'Промене су сачуване';
$string['check'] = 'Провери';
$string['checkactual'] = 'Стварно';
$string['checkall'] = 'Провери све';
$string['checkerror'] = 'Грешка при добијању резултата провере \'{$a}\'. Проверите конзолу веб читача за више информација.';
$string['checkexpected'] = 'Очекиванo';
$string['checkingbackup'] = 'Провера резервне копије';
$string['checkingcourse'] = 'Провера курса';
$string['checkingforbbexport'] = 'Провера BlackBoard извоза података';
$string['checkinginstances'] = 'Провера инстанци';
$string['checkingsections'] = 'Провера секција';
$string['checklanguage'] = 'Провера језика';
$string['checkloading'] = 'Преузимање резултата провере \'{$a}\'';
$string['checknone'] = 'Без провера';
$string['checks'] = 'Провере';
$string['checksok'] = 'Све провере: \'{$a}\' су ОК';
$string['childcoursenotfound'] = 'Подређени курс није пронађен!';
$string['childcourses'] = 'Подређени курсеви';
$string['choose'] = 'Изабери';
$string['choosecourse'] = 'Избор курса';
$string['choosedots'] = 'Изабери...';
$string['chooselivelogs'] = 'Или надгледајте тренутну активност';
$string['chooselogs'] = 'Избoр записa о активностима који желите да видите';
$string['choosereportfilter'] = 'Избор филтера за извештај';
$string['choosetheme'] = 'Изаберите графичку тему';
$string['chooseuser'] = 'Избор корисника';
$string['city'] = 'Место';
$string['cleaningtempdata'] = 'Брисање привремених података';
$string['clear'] = 'Обриши';
$string['clearall'] = 'Обришите све';
$string['clearfilterrow'] = 'Уклони ред филтера';
$string['clearfilters'] = 'Уклони филтере';
$string['clearsearch'] = 'Обриши поље за претрагу';
$string['clickhelpiconformoreinfo'] = '... наставља се... Кликните на иконицу за помоћ како бисте прочитали цео чланак';
$string['clickhere'] = 'Кликни овде ...';
$string['clicktohideshow'] = 'Кликните да бисте раширили или скупили';
$string['closeblockdrawer'] = 'Затвори фиоку са блоковима';
$string['closebuttontitle'] = 'Затвори';
$string['closecourseindex'] = 'Затвори фиоку са индексом курса';
$string['closedrawer'] = 'Затвори фиоку';
$string['closewindow'] = 'Затвори овај прозор';
$string['collapse'] = 'Скупи';
$string['collapseall'] = 'Скупи све';
$string['collapsecategory'] = 'Скупи {$a}';
$string['comebacklater'] = 'Молим вас, вратите се касније.';
$string['commentincontext'] = 'Пронађи овај коментар у контексту';
$string['comments'] = 'Коментари';
$string['commentscount'] = 'Коментари ({$a})';
$string['commentsnotenabled'] = 'Коментарисање није омогућено';
$string['commentsrequirelogin'] = 'Потребно је да се пријавите на систем да бисте видели коментаре.';
$string['comparelanguage'] = 'Упоредите и уредите тренутно одабрани језик';
$string['complete'] = 'Потпуно';
$string['completed'] = 'Завршено';
$string['completereport'] = 'Потпуни извештај';
$string['configuration'] = 'Конфигурација';
$string['confirm'] = 'Потврди';
$string['confirmaccount'] = 'Потврдите налог';
$string['confirmcheckfull'] = 'Да ли сте апсолутни сигурни да желите да потврдите {$a}?';
$string['confirmcoursemove'] = 'Да ли сте сигурни да желите да преместите курс ({$a->course}) у ову категорију ({$a->category})?';
$string['confirmdeletesection'] = 'Да ли сте апсолутно сигурни да желите да обришете у потпуности "{$a}" и све активности које садржи?';
$string['confirmed'] = 'Ваша регистрација је потврђена';
$string['confirmednot'] = 'Ваша регистрација још није потврђена. Проверите да ли је е-порука за потврду стигла у ваше поштанско сандуче.';
$string['considereddigitalminor'] = 'Превише сте млади да бисте могли да креирате налог на овом сајту.';
$string['contactsbyrolelist'] = '{$a->role}: {$a->contacts}';
$string['content'] = 'Садржај';
$string['contentbank'] = 'Банка садржаја';
$string['contentexport_aboutthiscourse'] = 'Резиме курса';
$string['contentexport_coursesummary'] = 'Ова датотека је део садржаја преузетог са <a href="{$a->courselink}">{$a->coursename}</a>.';
$string['contentexport_footersummary'] = 'Ова датотека је део садржаја преузетог са <a href="{$a->courselink}">{$a->coursename}</a> by {$a->userfullname} дана {$a->date}.';
$string['contentexport_modulesummary'] = 'Ова страница је део садржаја преузетог са <a href="{$a->modulelink}">{$a->modulename}</a> on {$a->date}. Имајте на уму да садржај и датотеке који су већи од {$a->maxfilesize} неће бити преузети.';
$string['contentexport_viewfilename'] = 'Погледајте датотеку {$a}';
$string['context'] = 'Контекст';
$string['contextlevel'] = 'Ниво контекста';
$string['contextname'] = 'Назив контекста';
$string['contextparent'] = 'Надређени';
$string['contexturl'] = 'URL адреса контекста';
$string['continue'] = 'Настави';
$string['continuetocourse'] = 'Кликните овде да бисте ушли на свој курс';
$string['convertingwikitomarkdown'] = 'Претварање wiki формата у Markdown формат';
$string['cookiesenabled'] = 'Ваш веб читач мора имати омогућене колачиће';
$string['cookiesenabled_help'] = 'На овом сајту се користе два колачића (<i>cookies</i>):

Од суштинског значаје је колачић сесије (<i>session cookie</i>), који се обично зове MoodleSession. Морате да дозволите употребу овог колачића у вашем веб читачу како бисте обезбедили континуитет сесије и како бисте све време остали пријављени на систем док сте на сајту. Када се одјавите са система или затворите веб читач, овај колачић се уништава (како у вашем читачу тако и на серверу).

Други колачић је чисто практичног карактера и обично се назива MOODLEID. Он само памти ваше корисничко име унутар веб читача. То значи, да ће, када се будете вратили на овај сајт, поље за корисничко име на страницу за пријаву, аутоматски бити попуњено вашим корисничким именом. Из разлога безбедности (нарочито када интернету приступате са јавног рачунара) боље је да одбијете овај колачић - у том случају мораћете да унесете своје корисничко име сваки пут када се будете пријављивали на систем.';
$string['cookiesenabled_help_html'] = 'На овом сајту се користе два колачића:<br/><br/>

Суштински је колачић сесије, који се обично назива MoodleSession. Морате дозволити овај колачић у вашем веб читачу  како би се обезбедио континуитет и како бисте остали све пријављени док сте на сајту. Када се одјавите или затворите веб читач, овај колачић се уништава (како у вашем читачу тако и на серверу).<br/><br/>

Други колачић постоји само ради погодности, и обично се назива MOODLEID или слично. Он само памти ваше корисничко име у веб читачу. То значи да је поље корисничког имена на страници за пријаву већ попуњено за вас, када се вратите на овај сајт. Безбедно је одбити овај колачић - само ћете морати поново да унесете своје корисничко име, сваки пут када се пријављујете.';
$string['cookiesenabledonlysession'] = 'Колачићи морају бити омогућени у вашем веб читачу';
$string['cookiesenabledonlysession_help'] = 'Овај сајт користи један колачић сесије, који се обично зове MoodleSession. Морате да дозволите употребу овог колачића у вашем веб читачу како бисте обезбедили континуитет сесије и како бисте остали све време остали пријављени на систем док сте на сајту. Када се одјавите са система или затворите веб читач, овај колачић се уништава (како у вашем читачу тако и на серверу).';
$string['cookiesnotenabled'] = 'Нажалост, колачићи тренутно нису омогућени у вашем веб читачу';
$string['cookiesnotice'] = 'Обавештење о колачићима';
$string['copy'] = 'копирање';
$string['copyasnoun'] = 'копирање';
$string['copycourse'] = 'Копирање курса';
$string['copyingcoursefiles'] = 'Копирање датотека курса';
$string['copyingsitefiles'] = 'Копирање фајлова са сајта који су коришћени у курсу';
$string['copyinguserfiles'] = 'Копирање корисничких датотека';
$string['copyingzipfile'] = 'Копирање zip датотека';
$string['copyrightnotice'] = 'Напомена о заштити ауторских права';
$string['copytoclipboard'] = 'Копирај у клипборд';
$string['coresystem'] = 'Систем';
$string['cost'] = 'Цена';
$string['costdefault'] = 'Подразумевана цена';
$string['count_of_total'] = '<strong>{$a->count}</strong> of {$a->total}';
$string['counteditems'] = '{$a->count} {$a->items}';
$string['country'] = 'Држава';
$string['course'] = 'Курс';
$string['courseadministration'] = 'Администрација курса';
$string['courseapprovedemail'] = 'Курс који сте тражили је одобрен, <a href="{$a->url}">{$a->name}</a>, и додељена вам је улога: {$a->teacher}.';
$string['courseapprovedemail2'] = 'Курс који сте тражили је одобрен: <a href="{$a->url}">{$a->name}</a>.';
$string['courseapprovedfailed'] = 'Није успело чување курса онако како је одобрено!';
$string['courseapprovedsubject'] = 'Ваш курс је одобрен.';
$string['courseavailable'] = 'Овај курс је доступан полазницима';
$string['courseavailablenot'] = 'Овај курс није доступан полазницима';
$string['coursebackup'] = 'Резервна копија курса';
$string['coursebulkaction'] = 'Групне акције за изабране курсеве';
$string['coursecategories'] = 'Категорије курсева';
$string['coursecategory'] = 'Категорија курса';
$string['coursecategory_help'] = 'Ово подешавање одређује категорију у којој ће се курс појавити на списку курсева.';
$string['coursecategorydeleted'] = 'Обрисана категорија $а';
$string['coursecatmanagement'] = 'Управљање курсевима и категоријама';
$string['coursecompletion'] = 'Завршетак курса';
$string['coursecompletions'] = 'Завршетак курсева';
$string['coursecreators'] = 'Креатор курса';
$string['coursecreatorsdescription'] = 'Креатори курсева могу да креирају нове курсеве.';
$string['coursedeleted'] = 'Обрисан курс $а';
$string['coursedetails'] = 'Подаци о курсeвима';
$string['coursedisplay'] = 'Прелом странице курса';
$string['coursedisplay_help'] = 'Секције курса могу бити приказане све на једној страници или подељене на неколико страница.';
$string['coursedisplay_multi'] = 'Прикажи једну секцију по страници';
$string['coursedisplay_single'] = 'Прикажи све секције на једној страници';
$string['courseduration'] = 'Трајање курса';
$string['courseduration_desc'] = 'Трајање курса се користи за израчунавање подразумеваног датума завршетка курса. Датум завршетка курса се користи како би се одредило да ли курс треба да буде укључен у списак курсева корисника. Такође, датум завршетка могу да користе прилагођени извештаји. Корисници и даље могу да уђу на курс након датума његовог завршетка.';
$string['courseenddateenabled'] = 'Датум завршетка курса стандардно омогућен';
$string['courseenddateenabled_desc'] = 'Ово подешавања одређује да ли ће датум завршетка курса бити стандардно омогућен за нове курсеве и подешен на датум израчунат на основу дужине трајања курса.';
$string['courseextendednamedisplay'] = '{$a->shortname} {$a->fullname}';
$string['coursefiles'] = 'Наслеђене датотеке курса';
$string['coursefilesedit'] = 'Уреди наслеђене датотеке курса';
$string['coursefileswarning'] = 'Датотеке курса су застареле';
$string['coursefileswarning_help'] = 'Опција \'Датотеке курса\' се не користи од верзије Moodle 2.0, Молимо да уместо тога користите спољашње репозиторијуме што је више могуће.';
$string['courseformatdata'] = 'Подаци о формату курса';
$string['courseformatoptions'] = 'Опције за форматирање - {$a}';
$string['courseformats'] = 'Формати курса';
$string['courseformatudpate'] = 'Ажурирај формат';
$string['coursegrades'] = 'Оцене на курсу';
$string['courseheader'] = 'Мени курса';
$string['coursehelpcategory'] = 'Поставите курс на листи курсева тако да полазници могу лакше да га пронађу.';
$string['coursehelpforce'] = 'Обавезан групни мод за све активности на курсу';
$string['coursehelpformat'] = 'Главна страница курса биће приказана у овом формату.';
$string['coursehelphiddensections'] = 'Како ће скривене секције курса бити приказане полазницима.';
$string['coursehelpmaximumupload'] = 'Одредите максималну величину датотеке која се може поставити у оквиру курса. Ова величина је ограничена подешавањем на нивоу сајта.';
$string['coursehelpnewsitemsnumber'] = 'Број најновијих обавештења који ће се појавити на почетној страници курса, у блоку "Најновија обавештења". Ако је подешено на  0, форум са обавештењима неће бити креиран.';
$string['coursehelpnumberweeks'] = 'Број секција унутар курса (важи само за одређене формате курса).';
$string['coursehelpshowgrades'] = 'Омогући приказ књиге са оценама. Ово не спречава да оцене буду приказане унутар појединачних активности.';
$string['coursehidden'] = 'Овај курс тренутно није доступан полазницима';
$string['courseinfo'] = 'Информације о курсу';
$string['courselegacyfiles'] = 'Наслеђене датотеке курса';
$string['courselegacyfiles_help'] = 'Подручје датотека курса обезбеђује извесну компатибилност са Moodle 1.9 и старијим верзијама. Све датотеке у овом подручју увек су доступне свим учесницима курса (независно од тога да ли су повезани са курсом или не) и не постоји начин да се сазна где је било која од ових датотека коришћена у Moodleu.

Ако ово подручје користите да би сте у њему чували датотеке курса, можете себе да изложите бројним проблемима који се тичу приватности и безбдности система. Исто тако може доћи до губитка датотека при креирању резервних копија, увозу података из једног у други курс, као и сваки пут када садржај делите или поново користите. Због тога препоручујемо да не користите ово подручје, осим ако нисте сасвим сигурни да знате шта радите.';
$string['courselegacyfiles_link'] = 'coursefiles2';
$string['courselegacyfilesofcourse'] = 'Наслеђене датотеке курса: {$a}';
$string['coursenotaccessible'] = 'Курс не дозвољава јавни приступ';
$string['courseoverview'] = 'Преглед курсева';
$string['courseoverviewfiles'] = 'Слика курса';
$string['courseoverviewfiles_help'] = 'Слика курса приказују се приказује на страници \'Моји курсеви\', као и на списку доступних курсева на почетној страници. Администратор сајта може омогућити додавање више од једне датотеке као и додатне типове датотека. Ако користите више датотека оне ће бити приказане на списку доступних курсева на почетној страници.';
$string['courseoverviewfilesext'] = 'Екстензије слике курса';
$string['courseoverviewfileslimit'] = 'Ограничење за слику курса';
$string['courseoverviewgraph'] = 'Графикон прегледа курсева';
$string['courseprofiles'] = 'Профили курсева';
$string['coursereasonforrejecting'] = 'Ваши разлози за одбијање овог захтева';
$string['coursereasonforrejectingemail'] = 'Ово ће бити послато е-поштом подносиоцу захтева.';
$string['coursereject'] = 'Одбаците захтев за покретање новог курса';
$string['courserejected'] = 'Курс је одбијен и подносилац захтева је обавештен о томе.';
$string['courserejectemail'] = 'Жао нам је, али ваш захтев за отварање курса је одбијен. Ево образложења такве одлуке:

{$a}';
$string['courserejectreason'] = 'Наведите своје разлоге за одбијање овог курса<br />(ово ће бити послато е-поштом подносиоцу захтева)';
$string['courserejectsubject'] = 'Ваш курс је одбијен';
$string['coursereport'] = 'Извештај о курсу';
$string['coursereports'] = 'Извештаји курса';
$string['courserequest'] = 'Захтев за покретање новог курса';
$string['courserequestdetails'] = 'Детаљније информације о курсу чије покретање тражите';
$string['courserequestfailed'] = 'Из неког разлога није могуће сачувати ваш захтев за покретање курса';
$string['courserequestintro'] = 'Употребите овај образац како бисте затражили да буде креиран нови курс за вас.<br />Покушајте да попуните образац са што више информација, како бисте помогли<br />администраторима да боље разумеју ваше разлоге због којих желите овај курс.';
$string['courserequestreason'] = 'Разлози за покретање овог курса';
$string['courserequestroleerror'] = 'Улога креатора у конфигурацији нових курсева је неисправна. Погледајте <a href="{$a}">правила за кориснике</a>.';
$string['courserequestsuccess'] = 'Захтев за покретање новог курса је предат.';
$string['courserequestsupport'] = 'Додатне информације које ће помоћи администратору да процени овај захтев';
$string['courserequestwarning'] = 'Корисник који захтева овај курс биће аутоматски уписан и биће му додељена улога {$a}.';
$string['courserestore'] = 'Рестаурирање курса';
$string['coursereuse'] = 'Поновна употреба курса';
$string['coursereusenavigationmenu'] = 'Навигациони мени за поновну употребу курса';
$string['courses'] = 'Курсеви';
$string['coursesectionsummaries'] = 'Резиме секција курса';
$string['coursesectiontitle'] = '{$a->sectionname}: {$a->sectiontitle} | {$a->course}';
$string['coursesectiontitlebulkediting'] = 'Групно уређивање {$a->sectionname}: {$a->sectiontitle} | {$a->course}';
$string['coursesectiontitleediting'] = 'Уређивање {$a->sectionname}: {$a->sectiontitle} | {$a->course}';
$string['coursesettings'] = 'Подразумевана подешавања курса';
$string['coursesmovedout'] = 'Курсеви премештени из {$a}';
$string['coursespending'] = 'Курсеви који чекају на одобрење';
$string['coursestart'] = 'Почетак курса';
$string['coursesummary'] = 'Резиме курса';
$string['coursesummary_help'] = 'Кратак опис вашег курса. Садржај који овде додате може се претраживати.';
$string['coursetitle'] = 'Курс: {$a->course}';
$string['coursetitlebulkediting'] = 'Групно уређивање курса: {$a->course}';
$string['coursetitleediting'] = 'Уређивање курса: {$a->course}';
$string['courseupdates'] = 'Ажурирања курса';
$string['coursevisibility'] = 'Видљивост курса';
$string['coursevisibility_help'] = '* Прикажи: курс се појављује на списку курсева и полазници му могу приступити.
* Сакриј: приступ је ограничен на предаваче и друге кориснике који имају способност да виде скривене курсеве.';
$string['create'] = 'Креирај';
$string['createaccount'] = 'Креирај мој нови налог';
$string['createcategory'] = 'Креирај категорију';
$string['createfolder'] = 'Креирање директоријума у {$a}';
$string['createnew'] = 'Креирај нови';
$string['createnewcategory'] = 'Креирај нову категорију';
$string['createnewcourse'] = 'Креирај нови курс';
$string['createnewsubcategory'] = 'Креирај нову поткатегорију';
$string['createsubcategoryof'] = 'Креирај нову поткатегорију за {$a}';
$string['createuser'] = 'Креирај корисника';
$string['createziparchive'] = 'Креирање zip архиве';
$string['creatingblocks'] = 'Креирање блокова';
$string['creatingblocksroles'] = 'Креирање задатака и преписивања улога на нивоу блока';
$string['creatingblogsinfo'] = 'Креирање информација о блоговима';
$string['creatingcategoriesandquestions'] = 'Креирање категорија и питања';
$string['creatingcoursemodules'] = 'Креирање модула курса';
$string['creatingcourseroles'] = 'Креирање задатака и преписивања улога на нивоу курса';
$string['creatingevents'] = 'Креирање догађаја';
$string['creatinggradebook'] = 'Креирање књиге оцена';
$string['creatinggroupings'] = 'Креирање груписања';
$string['creatinggroupingsgroups'] = 'Додавање група у груписања';
$string['creatinggroups'] = 'Креирање група';
$string['creatinglogentries'] = 'Креирање ставки извештаја о активностима';
$string['creatingmessagesinfo'] = 'Креирање информација о порукама';
$string['creatingmodroles'] = 'Креирање задатака и преписивања улога на нивоу модула';
$string['creatingnewcourse'] = 'Креирање новог курса';
$string['creatingrolesdefinitions'] = 'Креирање дефиниција улога';
$string['creatingscales'] = 'Креирање скала за оцењивање';
$string['creatingsections'] = 'Креирање секција';
$string['creatingtemporarystructures'] = 'Креирање привремених структура';
$string['creatinguserroles'] = 'Креирање задатака и преписивања улога на нивоу корисника';
$string['creatingusers'] = 'Креирање корисника';
$string['creatingxmlfile'] = 'Креирање XML датотеке';
$string['currency'] = 'Валута';
$string['currentcourse'] = 'Текући курс';
$string['currentcourseadding'] = 'Текући курс, додавање података већ постојећима';
$string['currentcoursedeleting'] = 'Текући курс, уз претходно брисање постојећих података';
$string['currentlanguage'] = 'Тренутно важећи језик';
$string['currentlocaltime'] = 'Ваше тренутно локално време';
$string['currentpicture'] = 'Тренутна слика';
$string['currentrelease'] = 'Информација о тренутној верзији програма';
$string['currenttheme'] = 'Актуелна тема';
$string['currentversion'] = 'Тренутна верзија';
$string['databasechecking'] = 'Надоградња базе података са верзије {$a->oldversion} на верзију {$a->newversion}';
$string['databaseperformance'] = 'Перформансе базе података';
$string['databasesetup'] = 'Подешавање базе података';
$string['databasesuccess'] = 'База података је успешно надограђена';
$string['databaseupgradebackups'] = 'Тренутна верзија резервне копије је {$a}';
$string['databaseupgradeblocks'] = 'Тренутна верзија блокова је {$a}';
$string['databaseupgradegroups'] = 'Верзија групе сада је {$a}';
$string['databaseupgradelocal'] = 'Тренутна верзија прилагођавања локалне базе података је {$a}';
$string['databaseupgrades'] = 'Надоградња базе података';
$string['dataformats'] = 'Формати података';
$string['date'] = 'Датум';
$string['datechanged'] = 'Датум промене';
$string['datemostrecentfirst'] = 'Датум - прво најновији';
$string['datemostrecentlast'] = 'Датум - прво најстарији';
$string['datetimefilterafter'] = '{$a->title} после';
$string['datetimefilterbefore'] = '{$a->title} пре';
$string['day'] = 'дан';
$string['days'] = 'дан/а';
$string['decodinginternallinks'] = 'Декодирање унутрашњих линкова';
$string['default'] = 'Подразумевано';
$string['defaultcategoryname'] = 'Категорија 1';
$string['defaultcompetencescale'] = 'Основна скала компетенција';
$string['defaultcompetencescaledesc'] = 'Бинарна скала која указује само да ли је неко демонстрирао стручност или не без детаљнијих информација.';
$string['defaultcompetencescalenotproficient'] = 'Још није компетентан';
$string['defaultcompetencescaleproficient'] = 'Kомпетентан';
$string['defaultcoursestudent'] = 'Полазник';
$string['defaultcoursestudentdescription'] = 'Полазници у општем случају имају мање привилегије у оквиру курса.';
$string['defaultcoursestudents'] = 'Полазници';
$string['defaultcoursesummary'] = 'Напишите кратак и занимљив резиме који објашњава које теме покрива Ваш курс.';
$string['defaultcourseteacher'] = 'Предавач';
$string['defaultcourseteacherdescription'] = 'Предавачи могу да раде било шта у оквиру курса, укључујући промену активности и оцењивање полазника.';
$string['defaultcourseteachers'] = 'Предавачи';
$string['defaulteditor'] = 'Подразумевани едитор';
$string['defaulthomepageuser'] = 'Почетна страница';
$string['defaulthomepageuser_help'] = 'На коју страницу треба да будете преусмерени након што се пријавите на сајт?';
$string['delete'] = 'Обриши';
$string['deleteablock'] = 'Обриши блок';
$string['deleteall'] = 'Обриши све';
$string['deleteallcannotundo'] = 'Обриши све - ова акција је неповратна';
$string['deleteallcomments'] = 'Сви коментари';
$string['deleteallratings'] = 'Сва оцењивања';
$string['deletecategory'] = 'Обриши категорију: {$a}';
$string['deletecategorycheck'] = 'Јесте ли апсолутно сигурни да желите да обришете категорију под називом <b>\'{$a}\'</b>?<br /> Ово ће преместити све курсеве који се налазе у тој категорији у надређену категорију (ако иста постоји), или у категорију Разно.';
$string['deletecategorycheck2'] = 'Ако обришете ову категорију, морате изабрати шта урадити са курсевима и поткатегоријама које она садржи.';
$string['deletecategoryempty'] = 'Ова категорија је празна';
$string['deletecheck'] = 'Обриши {$a} ?';
$string['deletecheckfiles'] = 'Јесте ли у потпуности сигурни да желите да обришете ове датотеке?';
$string['deletecheckfull'] = 'Да ли сте апсолутно сигурни да желите потпуно да обришете корисника {$a}, укључујући и његове уписе на курсеве, записе о активностима и остале податке о том кориснику?';
$string['deletechecktype'] = 'Да ли сте сигурни да желите да обришете овај {$a->type}?';
$string['deletechecktypename'] = 'Да ли сте сигурни да желите да обришете {$a->type} "{$a->name}"?';
$string['deletecheckwarning'] = 'Управо ћете обрисати ове датотеке';
$string['deletecommentbyon'] = 'Обриши коментар који је послао/ла {$a->user} у {$a->time}';
$string['deletecompletely'] = 'Комплетно брисање';
$string['deletecourse'] = 'Обриши курс';
$string['deletecoursecheck'] = 'Јесте ли сигурни да желите потпуно да обришете овај курс и све податке које он садржи?';
$string['deleted'] = 'Обрисано';
$string['deletedactivity'] = 'Обрисано {$a}';
$string['deletedcourse'] = '{$a} је потпуно обрисан';
$string['deletednot'] = '{$a} се не може обрисати.';
$string['deletepicture'] = 'Обриши';
$string['deletesection'] = 'Обриши';
$string['deleteselected'] = 'Обриши изабрано';
$string['deleteselectedkey'] = 'Обриши изабрани кључ';
$string['deletingcourse'] = 'Брисање {$a}';
$string['deletingexistingcoursedata'] = 'Брисање постојећих података курса';
$string['deletingolddata'] = 'Брисање старих података';
$string['department'] = 'Департман/Одсек';
$string['deprecatedeventname'] = '{$a} (није више у употреби)';
$string['desc'] = 'Опадајуће';
$string['description'] = 'Опис';
$string['deselectall'] = 'Поништи избор свега';
$string['deselectnos'] = 'Поништи одабир свих "Не"';
$string['detailedless'] = 'Мање детаљно';
$string['detailedmore'] = 'Детаљније';
$string['details'] = 'Детаљније информације';
$string['digitalminor'] = 'Дигитални малолетник';
$string['digitalminor_desc'] = 'Замолите свог родитеља/старатеља да контактира:';
$string['directory'] = 'Директоријум';
$string['disable'] = 'Онемогући';
$string['disabledcomments'] = 'Коментарисање је онемогућено';
$string['dismissnotification'] = 'Одбаци ово обавештење';
$string['displayingfirst'] = 'Приказано је само првих(а) {$a->count} {$a->things}';
$string['displayingrecords'] = 'Приказ {$a} записа';
$string['displayingusers'] = 'Приказ корисника од {$a->start} до {$a->end}';
$string['displayonpage'] = 'Прикажи на страници';
$string['dndcourse'] = 'Можете да превучете и спустити овај курс како бисте променили његово сортирање или га преместили у другу категорију.';
$string['dndenabled_inbox'] = 'Превуците и спустите датотеке овде како бисте их додали.';
$string['dndnotsupported'] = 'Није подржано постављање превлачењем';
$string['dndnotsupported_help'] = 'Ваш читач не подржава постављање помоћу опције \'превуци и спусти\'.<br />Ова функционалност је доступна у свим новијим верзијама читача Chrome, Firefox и Safari, као и у читачу Internet Explorer од верзије 10.';
$string['dndnotsupported_insentence'] = 'превлачење није подржано';
$string['dnduploadwithoutcontent'] = 'Ово постављање нема никакав садржај';
$string['dndworkingfile'] = 'Превуците и спустите датотеке на секцију курса како бисте их поставили';
$string['dndworkingfilelink'] = 'Превуците и спустите датотеке или линкове на секцију курса како бисте их поставили';
$string['dndworkingfiletext'] = 'Превуците и спустите датотеке или текст на секцију курса како бисте их поставили';
$string['dndworkingfiletextlink'] = 'Превуците и спустите датотеке, текст или линкове на секцију курса како бисте их поставили';
$string['dndworkinglink'] = 'Превуците и спустите линкове на секцију курса како бисте их поставили';
$string['dndworkingtext'] = 'Превуците и спустите текст на секцију курса како бисте га поставили';
$string['dndworkingtextlink'] = 'Превуците и спустите текст или линкове на секцију курса како бисте их поставили';
$string['documentation'] = 'Moodle документација';
$string['dontsortcategories'] = 'Не сортирај категорије';
$string['dontsortcourses'] = 'Не сортирај курсеве';
$string['down'] = 'Доле';
$string['download'] = 'Преузми';
$string['downloadall'] = 'Преузми све';
$string['downloadexcel'] = 'Преузми у Excel формату';
$string['downloadfile'] = 'Преузми датотеку';
$string['downloadods'] = 'Преузми у ODS формату';
$string['downloadtext'] = 'Преузми у текстуалном формату';
$string['doyouagree'] = 'Јесте ли прочитали наведене услове и разумели их у потпуности?';
$string['droptoupload'] = 'Спусти овде датотеке за слање';
$string['duplicate'] = 'Дуплирај';
$string['duplicatedmodule'] = '{$a} (копија)';
$string['duplicatedsection'] = '{$a} (копија)';
$string['edhelpaspellpath'] = 'Да бисте користили проверу правописа у едитору, МОРАТЕ имати <strong>aspell 0.50</strong> или новији инсталиран на Вашем серверу, и морате специфицирати тачну путању за приступ aspell бинарној датотеци. На Unix/Linux системима, ова путања је обично <strong>/usr/bin/aspell</strong>, али може бити и нека друга.';
$string['edhelpbgcolor'] = 'Одредите позадинску боју поља за уређивање.<br />Пример вредности које се могу задати су: #ffffff или white';
$string['edhelpcleanword'] = 'Ово подешавање омогућава или онемогућава филтрирање Word-специфичног формата.';
$string['edhelpenablespelling'] = 'Укључите или искључите проверу правописа (spell-checking). Ако је провера укључена, <strong>aspell</strong> мора бити инсталиран на серверу. Друга вредност је <strong>подразумевани речник</strong>. Ова вредност ће бити коришћена ако aspell нема речник за језик који користи корисник.';
$string['edhelpfontfamily'] = 'Карактеристика фамилија фонтова је листа назива група фонтова сродних језика и/или генеричких назива група сродних фонтова. Имена група сродних језика морају бити одвојена зарезом.';
$string['edhelpfontlist'] = 'Одредите фонтове који ће се користити у падајућем менију.';
$string['edhelpfontsize'] = 'Подразумевана величина величина фонта. <br />Примери вредности које се могу задати су: medium, large, smaller, larger, 10pt, 11px.';
$string['edit'] = 'Уреди';
$string['edita'] = 'Уреди {$a}';
$string['editcategorysettings'] = 'Уреди подешавања категорије';
$string['editcategorythis'] = 'Уреди ову категорију';
$string['editcoursesettings'] = 'Уреди подешавања курса';
$string['editfiles'] = 'Уређивање датотека';
$string['editgroupprofile'] = 'Уреди опис групе';
$string['editingteachershort'] = 'Едитор';
$string['editlock'] = 'Ова вредност се не може променити!';
$string['editmode'] = 'Режим уређивања';
$string['editmyprofile'] = 'Уреди профил';
$string['editorbgcolor'] = 'Боја позадине';
$string['editorcleanonpaste'] = 'Обриши Word HTML ознаке приликом копирања';
$string['editorcommonsettings'] = 'Општа подешавања';
$string['editordefaultfont'] = 'Подразумевани фонт';
$string['editorenablespelling'] = 'Омогући проверу правописа';
$string['editorfontlist'] = 'Списак фонтова';
$string['editorfontsize'] = 'Подразумевана величина фонта';
$string['editorpreferences'] = 'Параметри едитора текста';
$string['editorresettodefaults'] = 'Врати на подразумеване вредности';
$string['editorsettings'] = 'Подешавања едитора';
$string['editorshortcutkeys'] = 'Пречице са тастатуре едитора';
$string['editsection'] = 'Уреди подешавања';
$string['editsectionname'] = 'Уреди назив секције';
$string['editsectionsettings'] = 'Уреди подешавања секције';
$string['editsectiontitle'] = 'Уреди секцију: {$a}';
$string['editsettings'] = 'Уреди подешавања';
$string['editthisactivity'] = 'Уређивање ове активности';
$string['editthiscategory'] = 'Уреди ову категорију';
$string['edittitle'] = 'Уреди наслов';
$string['edittitleinstructions'] = 'Притисните тастер \'Escape\' за отказивање, а тастер \'Enter\' када завршите';
$string['edituser'] = 'Уређивање корисничких налога';
$string['edulevel'] = 'Сви догађаји';
$string['edulevel_help'] = '* Подучавање - активности предавача, нпр. ажурирање ресурса
* Учествовање - активности полазника, нпр. постављање нове теме на форуму
* Остало - активности корисника који није ни у улози предавача ни у улози полазника';
$string['edulevelother'] = 'Други';
$string['edulevelparticipating'] = 'Учествовање';
$string['edulevelteacher'] = 'Подучавање/настава';
$string['email'] = 'Адреса е-поште';
$string['emailactive'] = 'Адреса е-поште је активирана';
$string['emailagain'] = 'Адреса е-поште (поново)';
$string['emailalreadysent'] = 'Електронска порука за ресетовање лозинке је већ послата.
Молимо вас да проверите своју електронску пошту.';
$string['emailcharset'] = 'Скуп карактера коришћен за е-пошту';
$string['emailconfirm'] = 'Потврдите свој кориснички налог';
$string['emailconfirmation'] = 'Поштована/и {$a->firstname},

Затражено је отварање корисничког налога на сајту \'{$a->sitename}\' користећи вашу адресу е-поште.

Да бисте потврдили свој нови налог, молимо вас идите на следећу веб адресу

{$a->link}

У већини програма за електронску пошту, ово би требало да се појави као плаво обојени линк на који је потребно само кликнути. Ако та опција не функционише, копирајте наведену адресу у адресну линију на врху прозора вашег веб читача.

Ако вам је потребна помоћ, обратите се администратору сајта,
{$a->admin}';
$string['emailconfirmationresend'] = 'Пошаљи поново е-поруку за потврду';
$string['emailconfirmationsubject'] = '{$a}: потврда регистрације корисничког налога';
$string['emailconfirmsent'] = '<p>Требало би да је послата е-порука на вашу адресу <b>{$a}</b></p>
   <p>Порука садржи једноставна упутства о даљем поступку регистрације.</p>
   <p>Ако и даље имате проблема, контактирајте администратора.</p>';
$string['emailconfirmsentfailure'] = 'Е-порука за потврду није послата';
$string['emailconfirmsentsuccess'] = 'Е-порука за потврду успешно је послата';
$string['emaildigest'] = 'Начин обавештавања путем е-порука';
$string['emaildigest_help'] = 'Ово је подешавање одређује како ће копије порука са форума бит слате на вашу е-адресу.

* Без скраћивања - добијаћете по једну електронску поруку за сваку поруку (пост) објављену на форумима;
* Сажетак - комплетан преглед свих порука - добијаћете једну електронску поруку дневно са комплетним садржајем свих порука (постова) објављених у току 24 сата;
* Сажетак - само теме порука - добијаћете једну електронску поруку дневно која ће садржати само теме свих порука (постова) објављених у току 24 сата (без садржаја самих постова).

Ако желите можете одабрати другачије подешавање за сваки форум.';
$string['emaildigestcomplete'] = 'Комплетно (једна е-порука дневно са комплетним садржајем свих порука на форумима)';
$string['emaildigestoff'] = 'Без скраћивања (по једна е-порука за сваку поруку објављену на форумима)';
$string['emaildigestsubjects'] = 'Теме порука (једна е-порука дневно само, са темама порука објављених на форумима)';
$string['emaildisable'] = 'Ова адреса е-поште није доступна';
$string['emaildisableclick'] = 'Кликните овде како бисте онемогућили слања било какве е-поруке на ову адресу.';
$string['emaildisplay'] = 'Видљивост адресе е-поште';
$string['emaildisplay_help'] = 'Сакривено - само корисници са одговарајућим овлашћењима, као што су предавачи, могу да виде вашу адресу е-поште.
Видљиво свима - сви корисници на сајту могу да виде вашу адресу е-поште.
Видљиво учесницима курса - само учесници курсева на које сте уписани могу да виде вашу адресу е-поште.';
$string['emaildisplaycourse'] = 'Видљиво учесницима курса';
$string['emaildisplaycoursemembersonly'] = '(Видљиво осталим учесницима курса)';
$string['emaildisplayeveryone'] = '(Видљиво свима)';
$string['emaildisplayhide'] = '(Сакривено од свих осим корисника са одговарајућим овлашћењима)';
$string['emaildisplayno'] = 'Сакривено';
$string['emaildisplayyes'] = 'Видљиво свима';
$string['emailenable'] = 'Ова адреса е-поште је доступна';
$string['emailenableclick'] = 'Кликните овде како бисте поновно омогућили слања свих  е-порука на ову адресу';
$string['emailexists'] = 'Ова адреса е-поште је већ регистрована.';
$string['emailexistshintlink'] = 'Обнови заборављено корисничко име или лозинку';
$string['emailexistssignuphint'] = 'Можда сте раније већ креирали налог? {$a}';
$string['emailformat'] = 'Формат е-поште';
$string['emailmustbereal'] = 'Напомена: ваша адреса е-поште мора бити стварна.';
$string['emailnotallowed'] = 'Електронске адресе које припадају овим доменима нису дозвољене ({$a})';
$string['emailnotfound'] = 'Адреса е-поште није нађена у бази података';
$string['emailonlyallowed'] = 'Ова адресе е-поште  се не може користити. Дозвољени домени е-поште су: {$a}.';
$string['emailpasswordchangeinfo'] = 'Поштована/и {$a->firstname},

Неко (вероватно ви) је затражио нову лозинку за ваш кориснички налог  \'{$a->username}\' на сајту \'{$a->sitename}\'.

Да бисте променили своју лозинку идите на следећу веб адресу:

{$a->link}

У већини програма за електронску пошту, ово би требало да се појави као плаво обојени линк на који је потребно само кликнути. Ако та опција не функционише, копирајте наведену адресу у адресну линију на врху прозора вашег веб читача.

Уколико вам је потребна техничка помоћ, молимо вас да контактирате администратора,
{$a->admin}';
$string['emailpasswordchangeinfodisabled'] = 'Поштована/и {$a->firstname},

Неко (вероватно Ви) је затражио нову лозинку за Ваш кориснички налог на сајту \'{$a->sitename}\'.

На жалост, Ваш налог на овом сајту је онемогућен, па лозинка не може бити ресетована. Молимо, контактирајте администратора сајта, {$a->admin}.';
$string['emailpasswordchangeinfofail'] = 'Поштована/и {$a->firstname},

Неко (вероватно Ви) је тражио нову лозинку за Ваш кориснички налог на сајту \'{$a->sitename}\'.

На жалост, лозинке се не могу ресетовати на овом сајту. Молимо, контактирајте администратора сајта {$a->admin}.';
$string['emailpasswordchangeinfosubject'] = '{$a}: Информације о промени лозинке';
$string['emailpasswordconfirmation'] = 'Поштована/и {$a->firstname},

Неко (вероватно ви) је затражио нову лозинку за ваш кориснички налог на сајту \'{$a->sitename}\'.

Да бисте потврдили захтев и добили нову лозинку путем е-поште, идите на следећу веб адресу:

{$a->link}

У већини програма за електронску пошту, ово би требало да се појави као плаво обојени линк на који је потребно само кликнути. Ако та опција не функционише, копирајте наведену адресу у адресну линију на врху прозора вашег веб читача.

Уколико вам је потребна техничка помоћ, молимо вас да контактирате администратора,
{$a->admin}';
$string['emailpasswordconfirmationsubject'] = '{$a}: Потврда промене лозинке';
$string['emailpasswordconfirmmaybesent'] = '<p>Ако сте навели тачно корисничко име или јединствену адресу е-поште, требало би да вам је послата електронска порука.</p>
<p>Она садржи једноставна упутства за потврду и завршетак процеса промене лозинке.
Ако будете и даље имали потешкоће, молимо контактирајте администратора сајта.</p>';
$string['emailpasswordconfirmnoemail'] = '<p>Кориснички налог који сте навели нема забележену електронску адресу.</p>
   <p>Молимо вас да контактирате администратора.</p>';
$string['emailpasswordconfirmnotsent'] = '<p>Кориснички подаци које сте навели се не односе ни на један постојећи кориснички налог.</p>
   <p>Молимо вас, проверите информације које сте унели, а затим покушајте поново.
Ако и даље имате проблема, молимо вас да контактирате администратора.</p>';
$string['emailpasswordconfirmsent'] = 'Требало би да је послата е-порука на вашу адресу <b>{$a}</b>.
<p>Порука садржи једноставна упутства за потврђивање и завршетак ове промене лозинке.
Ако и даље имате проблема, контактирајте администратора.';
$string['emailresetconfirmation'] = 'Поштована/и {$a->firstname},

Затражена је нова лозинка за ваш кориснички налог \'{$a->username}\' на сајту {$a->sitename}.

Како бисте потврдили овај захтев и подесили нову лозинку за свој налог, молимо вас да посетите следећу веб адресу:
<a href="{$a->link}">{$a->link}</a>

(Овај линк је активан следећих {$a->resetminutes} минута од тренутка када је захтев за новом лозинком први пут затражен).

Ако нисте захтевали промену лозинке, не морате ништа да предузимате.

Ако вам је потребна помоћ, молимо вас обратите се администратору, {$a->admin}';
$string['emailresetconfirmationsubject'] = '{$a}: Захтев за промену лозинке';
$string['emailresetconfirmsent'] = 'Електронска порука је послата на вашу адресу <b>{$a}</b>.
<br />Порука садржи једноставна упутства како да потврдити и завршити промену лозинке.
Ако и даље имате проблема, молимо вас да контактирате администратора сајта.';
$string['emailstop'] = 'Онемогући обавештења';
$string['emailtoprivatefiles'] = 'Такође, можете да пошаљете датотеке, као прилоге, е-поштом, право у ваш простор за приватне датотеке, Једноставно приложите свој датотеке уз е-поруку и пошаљите је на {$a}';
$string['emailtoprivatefilesdenied'] = 'Ваш администратор је онемогућио опцију да постављате сопствене приватне датотеке.';
$string['emailvia'] = '{$a->name} (преко {$a->siteshortname})';
$string['emojicategoryactivities'] = 'Активности';
$string['emojicategoryanimalsnature'] = 'Животиње и природа';
$string['emojicategoryflags'] = 'Индикатори (заставице)';
$string['emojicategoryfooddrink'] = 'Храна и пиће';
$string['emojicategoryobjects'] = 'Предмети';
$string['emojicategorypeoplebody'] = 'Људи и тело';
$string['emojicategoryrecent'] = 'Скорашњи';
$string['emojicategorysmileysemotion'] = 'Смајлији и емоције';
$string['emojicategorysymbols'] = 'Симболи';
$string['emojicategorytravelplaces'] = 'Путовања и места';
$string['emptycmids'] = 'ID ознаке празних модула курса';
$string['emptydragdropregion'] = 'празан регион';
$string['emptysectionids'] = 'ID ознаке празних секција';
$string['enable'] = 'Омогући';
$string['encryptedcode'] = 'Шифровани кôд';
$string['enddate'] = 'Датум завршетка курса';
$string['enddate_help'] = 'Датум завршетка не спречава полазнике да приступе курсу. Он одређује да ли се курс приказује на списку прошлих курсева на страници \'Моји курсеви\'.';
$string['enddatewithtaskenabled'] = 'Датум завршетка курса';
$string['enddatewithtaskenabled_help'] = 'Датум када курс постаје скривен за студенте и када они више не могу да му приступе.';
$string['english'] = 'Енглески';
$string['enrolmentmethods'] = 'Методе уписа';
$string['entercourse'] = 'Кликните за приступ курсу';
$string['enteremail'] = 'Унесите своју електронску адресу';
$string['enteremailaddress'] = 'Да бисте поништили тренутну лозинку и добили нову, треба да унесете вашу важећу адресу електронске поште, на коју ће вам бити послата нова лозинка.';
$string['enterusername'] = 'Унесите своје корисничко име';
$string['entries'] = 'Улази';
$string['error'] = 'Грешка';
$string['errorcreatingactivity'] = 'Није могуће креирати инстанцу активности \'{$a}\'';
$string['errorfiletoobig'] = 'Датотека је била већа од ограничења од {$a} бајта (бајтова)';
$string['errornouploadrepo'] = 'На овом сајту не постоји репозиторијум за постављање датотека који је омогућен';
$string['errorwhenconfirming'] = 'Ваш кориснички налог још није још потврђен због грешке која се догодила. Ако сте кликнули на линк који сте добили у е-поруци, молимо проверите је ли линија у којој се налази наведени линк исправна (односно, је да је није ваш клијент е-поште можда форматирао у два реда, чиме је део линка завршио у другом реду). Постоји могућност да ћете морати ручним копирањем и уносом реконструисати оригинални линк.';
$string['eventcommentcreated'] = 'Коментар креиран';
$string['eventcommentdeleted'] = 'Коментар обрисан';
$string['eventcommentsviewed'] = 'Коментари приказани';
$string['eventconfiglogcreated'] = 'Конфигурациони запис креиран';
$string['eventcontentviewed'] = 'Садржај приказан';
$string['eventcoursebackupcreated'] = 'Резервна копија курса креирана';
$string['eventcoursecategorycreated'] = 'Категорија креирана';
$string['eventcoursecategorydeleted'] = 'Категорија обрисана';
$string['eventcoursecategoryupdated'] = 'Категорија ажурирана';
$string['eventcoursecategoryviewed'] = 'Категорија приказана';
$string['eventcoursecontentdeleted'] = 'Садржај курса обрисан';
$string['eventcoursecreated'] = 'Курс креиран';
$string['eventcoursedeleted'] = 'Курс обрисан';
$string['eventcourseended'] = 'Курс се завршио';
$string['eventcourseinformationviewed'] = 'Резиме курса приказан';
$string['eventcoursemodulecreated'] = 'Модул курса креиран';
$string['eventcoursemoduledeleted'] = 'Модул курса обрисан';
$string['eventcoursemoduleinstancelistviewed'] = 'Списак инстанци модула курса приказан';
$string['eventcoursemoduleupdated'] = 'Модул курса ажуриран';
$string['eventcoursemoduleviewed'] = 'Модул курса приказан';
$string['eventcourseoverviewviewed'] = 'Страница са прегледом активности на курсу приказана';
$string['eventcourseresetended'] = 'Ресетовање курса завршено';
$string['eventcourseresetstarted'] = 'Ресетовање курса покренуто';
$string['eventcourserestored'] = 'Курс рестауриран';
$string['eventcoursesectioncreated'] = 'Секција курса креирана';
$string['eventcoursesectiondeleted'] = 'Обрисана је секција курса';
$string['eventcoursesectionupdated'] = 'Секција курса ажурирана';
$string['eventcoursessearched'] = 'Претражени курсеви';
$string['eventcoursestarted'] = 'Курс је почео';
$string['eventcourseupdated'] = 'Курс ажуриран';
$string['eventcourseuserreportviewed'] = 'Извештај о кориснику на курсу приказан';
$string['eventcourseviewed'] = 'Курс приказан';
$string['eventdashboardreset'] = 'Враћање контролног панела на почетна подешавања';
$string['eventdashboardsreset'] = 'Враћање контролних панела на почетна подешавања';
$string['eventdashboardviewed'] = 'Контролни панел приказан';
$string['eventdatabasetextfieldcontentreplaced'] = 'Глобална претрага и замена унутар базе података';
$string['eventemailfailed'] = 'Покушај слања е-поруке није успео';
$string['eventmycoursesviewed'] = 'Моји курсеви приказани';
$string['eventname'] = 'Назив догађаја';
$string['eventrecentactivityviewed'] = 'Недавне активности приказане';
$string['eventsearchindexed'] = 'Претражи индексиране податке';
$string['eventsearchresultsviewed'] = 'Резултати претраге приказани';
$string['eventsectionviewed'] = 'Секција приказана';
$string['eventunknownlogged'] = 'Непознати догађај';
$string['eventurlblocked'] = 'URL адреса је блокирана';
$string['eventusercreated'] = 'Корисник креиран';
$string['eventuserdeleted'] = 'Корисник обрисан';
$string['eventuserfeedbackgiven'] = 'Кликнуто је на линк за повратне информације';
$string['eventuserfeedbackremind'] = 'Подсети ме касније да кликнем на линк за повратне информације';
$string['eventuserinfocategorycreated'] = 'Категорија поља корисничког профила креирана';
$string['eventuserinfocategorydeleted'] = 'Категорија поља корисничког профила обрисана';
$string['eventuserinfocategoryupdated'] = 'Категорија поља корисничког профила ажурирана';
$string['eventuserinfofieldcreated'] = 'Поље корисничког профила креирано';
$string['eventuserinfofielddeleted'] = 'Поље корисничког профила обрисано';
$string['eventuserinfofieldupdated'] = 'Поље корисничког профила ажурирано';
$string['eventuserlistviewed'] = 'Списак корисника приказан';
$string['eventuserloggedout'] = 'Корисник се одјавио';
$string['eventuserpasswordpolicyfailed'] = 'Лозинка корисника није у складу са правилима за креирање лозинке';
$string['eventuserpasswordupdated'] = 'Корисничка лозинка ажурирана';
$string['eventuserprofileviewed'] = 'Кориснички профил приказан';
$string['eventuserupdated'] = 'Корисник ажуриран';
$string['everybody'] = 'Сви';
$string['executeat'] = 'Извршити у';
$string['existing'] = 'Постојећи';
$string['existingadmins'] = 'Постојећи администратори';
$string['existingcourse'] = 'Постојећи курс';
$string['existingcourseadding'] = 'Постојећи курс - додавање података постојећим';
$string['existingcoursedeleting'] = 'Постојећи курс - претходно брисање курса';
$string['existingcreators'] = 'Постојећи креатори курса';
$string['existingstudents'] = 'Уписани полазници';
$string['existingteachers'] = 'Постојећи предавачи';
$string['expand'] = 'Прошири';
$string['expandall'] = 'Прошири све';
$string['expandcategory'] = 'Прошири {$a}';
$string['explanation'] = 'Објашњење';
$string['explanationdigitalminor'] = 'Ова информација је неопходна да би се утврдило да ли је ваш узраст изнад неопходног дигиталног узраста у ком појединац може самостално да прихвати одредбе и услове коришћења овог сајта и дâ сагласност да се подаци о њему легално чувају и обрађују.';
$string['extendperiod'] = 'Период продужења';
$string['extendsession'] = 'Продужи сесију';
$string['failedloginattempts'] = '{$a->attempts} неуспешних пријава на систем од Ваше последње пријаве';
$string['failedtaskbody'] = '<p>Здраво {$a->firstname},</p>
<p>Задатак <b>{$a->taskname}</b> није успео више пута и захтева пажњу.</p>
<p><a href="{$a->link}">Погледај задатак</a></p>';
$string['failedtaskcontexturlname'] = 'Извештај о статусу';
$string['failedtasksubject'] = 'Неуспешно извршени задатак: {$a}';
$string['favourites'] = 'Означено звездицом';
$string['feedback'] = 'Повратне информације';
$string['file'] = 'Датотека';
$string['fileexists'] = 'Већ постоји датотека под називом {$a}';
$string['filemissing'] = '{$a} недостаје';
$string['filereaderror'] = 'Није могуће прочитати датотеку  \'{$a}\'. Молимо проверите да ли је стварно у питању датотека, а не директоријум.';
$string['files'] = 'Датотеке';
$string['filesanduploads'] = 'Датотеке и постављене датотеке';
$string['filesfolders'] = 'Датотеке/Директоријуми';
$string['fileuploadwithcontent'] = 'Постављање датотека не треба укључује параметре садржаја';
$string['filloutallfields'] = 'Молимо испуните сва поља у овом обрасцу';
$string['filter'] = 'Филтер';
$string['filteroption'] = '{$a->criteria}: {$a->value}';
$string['filterrowlegend'] = 'Филтер {$a}';
$string['filters'] = 'Филтери';
$string['filtersetmatchdescription'] = 'Како треба комбиновати више филтера';
$string['filtertype'] = 'Тип филтера';
$string['findmorecourses'] = 'Пронађите још курсева...';
$string['first'] = 'Први';
$string['firstaccess'] = 'Први приступ';
$string['firstname'] = 'Име';
$string['firstnamephonetic'] = 'Име - фонетички';
$string['firstpage'] = 'Прва страница';
$string['firstsiteaccess'] = 'Први приступ сајту';
$string['firsttime'] = 'Да ли сте овде први пут?';
$string['folder'] = 'Директоријум';
$string['folderclosed'] = 'Затворен директоријум';
$string['folderopened'] = 'Отворен директоријум';
$string['followingoptional'] = 'Следећа поља су опциона';
$string['followingrequired'] = 'Следећа поља су обавезна';
$string['for'] = 'За';
$string['force'] = 'Обавезно';
$string['forcelanguage'] = 'Обавезан језик';
$string['forceno'] = 'Није обавезно';
$string['forcepasswordchange'] = 'Приморај на промену лозинке';
$string['forcepasswordchange_help'] = 'Ако је ово поље за потврду означено, од корисника ће се тражити да промене лозинку када се наредни пут буду пријавили на систем';
$string['forcepasswordchangecheckfull'] = 'Да ли сте сигурни да желите да приморате на промену лозинке корисника {$a}?';
$string['forcepasswordchangenot'] = 'Није било могуће приморати {$a} на промену лозинке.';
$string['forcepasswordchangenotice'] = 'Морате променити своју лозинку да бисте наставили';
$string['forcepasswordresetfailurenotice'] = 'Ваша тренутна лозинка више није у складу са постојећим правилима за креирање лозинке. Обратите се свом Moodle администратору за помоћ.
   {$a}';
$string['forcepasswordresetnotice'] = 'Ваша тренутна лозинка више није у складу са постојећим правилима за креирање лозинке. Морате ресетовати лозинку за пријаву на сајт.
   {$a}';
$string['forcetheme'] = 'Обавезна графичка тема';
$string['forgotaccount'] = 'Заборавили сте лозинку?';
$string['forgotten'] = 'Заборавили сте своје корисничко име или лозинку?';
$string['forgottenduplicate'] = 'Адресу е-поште дели више корисничких налога, молим вас да уместо е-адресе унесете корисничко';
$string['forgotteninvalidurl'] = 'Неисправна URL адреса за промену лозинке';
$string['format'] = 'Формат';
$string['formathtml'] = 'HTML формат';
$string['formatmarkdown'] = 'Markdown формат';
$string['formatplain'] = 'Текстуални формат';
$string['formattext'] = 'Moodle ауто-формат';
$string['forumpreferences'] = 'Параметри форума';
$string['framesetinfo'] = 'Овај скуп оквира садржи:';
$string['fromdate'] = 'Од';
$string['fromsender'] = 'Од';
$string['frontpagecategorycombo'] = 'Комбиновани списак';
$string['frontpagecategorynames'] = 'Списак категорија';
$string['frontpagecourselist'] = 'Списак курсева';
$string['frontpagecoursesearch'] = 'Поље за претраживање курсева';
$string['frontpagedescription'] = 'Резиме насловне странице сајта';
$string['frontpagedescriptionhelp'] = 'Овај резиме може бити приказан на насловној страници сајта коришћењем блока \'Резиме курса/сајта\'.';
$string['frontpageenrolledcourselist'] = 'Уписани курсеви';
$string['frontpageformat'] = 'Формат насловне странице';
$string['frontpageformatloggedin'] = 'Формат насловне странице када је корисник пријављен';
$string['frontpagenews'] = 'Обавештења';
$string['frontpagesettings'] = 'Подешавања насловне странице';
$string['fulllistofcourses'] = 'Сви курсеви';
$string['fullname'] = 'Пуно име';
$string['fullnamecourse'] = 'Пун назив курса';
$string['fullnamecourse_help'] = 'Пун назив курса се приказује на страници \'Моји курсеви\', као и на списку доступних курсева на почетној страници.';
$string['fullnamedisplay'] = '{$a->firstname} {$a->lastname}';
$string['fullnameuser'] = 'Пуно име корисника';
$string['fullprofile'] = 'Потпуни профил';
$string['fullsitename'] = 'Пун назив сајта';
$string['functiondisabled'] = 'Наведена функционалност тренутно није доступна';
$string['general'] = 'Опште';
$string['geolocation'] = 'ширина - дужина';
$string['gettheselogs'] = 'Преузми ове записе о активностима';
$string['go'] = 'Даље';
$string['gobacktosite'] = 'Вратите се на сајт';
$string['gpl'] = 'Ауторска права од 1999 па надаље Мартин Дугиамас (https://moodle.com)

Овај програм је бесплатан софтвер; можете вршити његову редистрибуцију и/или мењати га само под условима GNU General Public License коју је објавила Free Software Foundation, верзија 2 или (по вашем избору) било која новија верзија.

Овај програм се дистрибуира у нади да ће бити користан, али БЕЗ ИКАКВИХ ГАРАНЦИЈА; чак и без имплицитних гаранција ИСПЛАТИВОСТИ или ПОГОДНОСТИ ЗА КОНКРЕТНУ ПРИМЕНУ.

Погледајте Moodle License страницу са информацијама за више детаља: https://moodledev.io/general/license';
$string['gpl3'] = 'Ауторска права од 1999 па надаље Мартин Дугиамас  (https://moodle.com)

Овај програм је бесплатан софтвер; можете вршити његову редистрибуцију и/или мењати га само под условима GNU General Public License коју је објавила Free Software Foundation, верзија 3 или (по вашем избору) било која новија верзија.

Овај програм се дистрибуира у нади да ће бити користан, али БЕЗ ИКАКВИХ ГАРАНЦИЈА; чак и без имплицитних гаранција ИСПЛАТИВОСТИ или ПОГОДНОСТИ ЗА КОНКРЕТНУ ПРИМЕНУ.

Погледајте Moodle License страницу са информацијама за више детаља: https://moodledev.io/general/license';
$string['gpllicense'] = 'GPL лиценца';
$string['gradenoun'] = 'Оцена';
$string['grades'] = 'Оцене';
$string['gradeverb'] = 'Оцена';
$string['gravatarenabled'] = '<a href="https://www.gravatar.com/">Граватар</a> је омогућен за овај сајт. Ако сами не поставите своју слику Moodle ће покушати да је уместо вас учита са Граватара.';
$string['group'] = 'Група';
$string['groupadd'] = 'Додавање нове групе';
$string['groupaddusers'] = 'Додавање изабраних полазника групи';
$string['groupfor'] = 'за групу';
$string['groupinfo'] = 'Информације о изабраној групи';
$string['groupinfoedit'] = 'Уређивање подешавања групе';
$string['groupinfomembers'] = 'Информације о изабраним члановима';
$string['groupinfopeople'] = 'Информације о изабраним људима';
$string['groupmembers'] = 'Чланови групе';
$string['groupmemberssee'] = 'Приказ чланова групе';
$string['groupmembersselected'] = 'Чланови изабране групе';
$string['groupmode'] = 'Групни начин рада';
$string['groupmodeforce'] = 'Обавезан групни мод';
$string['groupmy'] = 'Моја група';
$string['groupnonmembers'] = 'Полазници који нису у групи';
$string['groupnotamember'] = 'Жао нам је, нисте члан те групе';
$string['grouprandomassign'] = 'Случајним одабиром распореди све полазнике у групе';
$string['groupremove'] = 'Уклони изабрану групу';
$string['groupremovemembers'] = 'Уклони изабране чланове';
$string['groups'] = 'Групе';
$string['groupsnone'] = 'Нема група';
$string['groupsseparate'] = 'Одвојене групе';
$string['groupsvisible'] = 'Видљиве групе';
$string['guest'] = 'Гост';
$string['guestdescription'] = 'Гости имају минималне привилегије и обично нигде не могу да унесу текст.';
$string['guestskey'] = 'Дозволи приступ гостима који имају лозинку курса';
$string['guestsno'] = 'Забрањен приступ гостима';
$string['guestsnotallowed'] = 'Нажалост, курс \'{$a}\' не дозвољава приступ гостима.';
$string['guestsyes'] = 'Дозволи приступ гостима без лозинке курса';
$string['guestuser'] = 'Корисник у улози госта';
$string['guestuserinfo'] = 'Овај корисник је посебан који дозвољава приступ неким курсевима само за читање.';
$string['help'] = 'Помоћ';
$string['helpprefix2'] = 'Помоћ за {$a}';
$string['helpwiththis'] = 'Помоћ за ово';
$string['hiddenassign'] = 'Сакривени задаци';
$string['hiddenfromstudents'] = 'Сакривено од полазника';
$string['hiddenoncoursepage'] = 'Доступно али се не приказује на страници курса';
$string['hiddensections'] = 'Сакривене секције';
$string['hiddensections_help'] = 'Скривене секције се полазницима приказују као недоступне на страници курса, или су у потпуности сакривене.';
$string['hiddensectionscollapsed'] = 'Сакривене секције су приказане као недоступне';
$string['hiddensectionsinvisible'] = 'Сакривене секције су у потпуности невидљиве';
$string['hiddenwithbrackets'] = '(скривено)';
$string['hide'] = 'Сакриј';
$string['hideadvancedsettings'] = 'Сакриј напредна подешавања';
$string['hidecategory'] = 'Сакриј категорију?';
$string['hidecategorymany'] = 'Категорија {$a->category} садржи следећи број курсева: {$a->coursecount}.
<br/>Ако сакријете категорију, корисници без дозволе да виде скривене категорије више неће имати приступ курсевима.';
$string['hidecategoryone'] = 'Категорија {$a->category} садржи 1 курс.
<br/>Ако je сакријете, корисници без дозволе да виде скривене категорије више неће имати приступ курсу.';
$string['hidechartdata'] = 'Сакриј податке графикона';
$string['hidefromstudents'] = 'Сакриј на страници курса';
$string['hideoncoursepage'] = 'Учини доступним али не приказуј на страници курса';
$string['hidepopoverwindow'] = 'Сакриј искачући прозор са додатним информацијама';
$string['hidesection'] = 'Сакриј секцију {$a}';
$string['hidesettings'] = 'Сакриј подешавања';
$string['hideshowblocks'] = 'Сакриј или прикажи блокове';
$string['highlight'] = 'Истакни';
$string['highlighted'] = 'Истакнуто';
$string['highlightoff'] = 'Уклони истицање';
$string['hits'] = 'Посете';
$string['hitsoncourse'] = 'Посете корисника {$a->username} курсу {$a->coursename}';
$string['hitsoncoursetoday'] = 'Данашње посете корисника {$a->username} курсу {$a->coursename}';
$string['home'] = 'Почетна страница';
$string['homeheader'] = 'Мени насловне странице';
$string['hour'] = 'h';
$string['hours'] = 'сат/а/и';
$string['howtomakethemes'] = 'Како направити нове графичке теме';
$string['htmleditor'] = 'Користи HTML едитор';
$string['htmleditoravailable'] = 'HTML едитор је доступан';
$string['htmleditordisabled'] = 'Искључили сте употребу HTML едитора у свом корисничком профилу';
$string['htmleditordisabledadmin'] = 'Администратор система је искључио употребу HTML едитора на овом сајту';
$string['htmleditordisabledbrowser'] = 'HTML едитор није доступан јер ваш веб читач није компатибилан са њим';
$string['htmlfilesonly'] = 'Само HTML датотеке';
$string['htmlformat'] = 'Улепшани HTML формат';
$string['icon'] = 'Иконица';
$string['idnumber'] = 'ID број';
$string['idnumbercourse'] = 'ID број курса';
$string['idnumbercourse_help'] = 'ID ознака курса се користи само приликом повезивања са екстерним системима. Ако курс нема официјелну ID ознаку, онда ово поље оставите празно.';
$string['idnumbercoursecategory'] = 'ID број категорије';
$string['idnumbercoursecategory_help'] = 'ID број категорије курса се користи само за поређење са екстерним системом ID бројева, и нигде се не приказује на сајту. Ако категорија има званичан кодни назив, он може бити унет, у супротном поље може бити остављено празно.';
$string['idnumbergroup'] = 'ID број групе';
$string['idnumbergroup_help'] = 'ID број групе се користи само приликом упоређивања са екстерним системима и не приказује се нигде на сајту. Ако група има неку официјелну шифру, она може овде бити уписана, у супротном поље може остати празно.';
$string['idnumbergrouping'] = 'ID број груписања';
$string['idnumbergrouping_help'] = 'ID број груписања се користи само приликом упоређивања са екстерним системима и не приказује се нигде на сајту. Ако груписање има неку официјелну шифру, она може овде бити уписана, у супротном поље може остати празно.';
$string['idnumbermod'] = 'ID број';
$string['idnumbermod_help'] = 'Постављање ID броја омогућава идентификацију активности или ресурса у сврхе као што су израчунавања оцена или креирања прилагођених извештаја. У супротном поље се може оставити празно.

За активности које се могу оцењивати. ID број се, такође, може поставити у дневнику оцена, иако се може уређивати једино на страници за подешавање активности.';
$string['idnumbertaken'] = 'Овај ID број је већ заузет';
$string['imagealt'] = 'Опис слике';
$string['import'] = 'Увоз';
$string['importdata'] = 'Увоз података курса';
$string['importdataexported'] = 'Извоз података из изворног курса прошао је успешно. <br /> Следи увоз података у одредишни курс';
$string['importdatafinished'] = 'Увоз података је успешно завршен! Наставите према свом курсу';
$string['importdatafrom'] = 'Пронађите курс из ког желите да увезете податке:';
$string['importinfo'] = 'Увезите ставке из других курсева, као што су активности, блокови или догађаји из календара. Кориснички подаци неће бити увезени.';
$string['inactive'] = 'Неактиван';
$string['include'] = 'Укључи';
$string['includeallusers'] = 'Укључи све кориснике';
$string['includecoursefiles'] = 'Укључи датотеке курса';
$string['includecourseusers'] = 'Укључи полазнике курса';
$string['included'] = 'Укључени';
$string['includelogentries'] = 'Укључи ставке извештаја о активностима';
$string['includemodules'] = 'Укључи модуле';
$string['includemoduleuserdata'] = 'Укључи податке корисника модула';
$string['includeneededusers'] = 'Укључи потребне кориснике';
$string['includenoneusers'] = 'Без укључивања корисника';
$string['includeroleassignments'] = 'Укључи доделе улога';
$string['includesitefiles'] = 'Укључи датотеке сајта коришћене у овом курсу';
$string['includesubcategories'] = 'Укључи поткатегорије';
$string['includeuserfiles'] = 'Укључи корисничке датотеке';
$string['increasesections'] = 'Повећај број секција';
$string['indicator:accessesafterend'] = 'Приступи курсу након датума завршетка';
$string['indicator:accessesafterend_help'] = 'Овај индикатор показује да ли је полазник приступао курсу након његовог завршетка.';
$string['indicator:accessesbeforestart'] = 'Приступи курсу пре датума почетка';
$string['indicator:accessesbeforestart_help'] = 'Овај индикатор показује да је полазник приступао курсу пре његовог почетка.';
$string['indicator:activitiesdue'] = 'Активности које се ускоро завршавају';
$string['indicator:activitiesdue_help'] = 'Корисник има активности које се ускоро завршавају';
$string['indicator:anycourseaccess'] = 'Приступ било ком курсу';
$string['indicator:anycourseaccess_help'] = 'Овај индикатор показује приступ било ком курсу на који је корисник уписан.';
$string['indicator:anywrite'] = 'Било која акција писања';
$string['indicator:anywrite_help'] = 'Овај индикатор представља било коју акцију писања (предаје) од стране полазника.';
$string['indicator:anywriteincourse'] = 'Било која акција писања на курсу';
$string['indicator:anywriteincourse_help'] = 'Овај индикатор представља било коју акцију писања (предаје) од стране полазника унутар било које активности на курсу.';
$string['indicator:completeduserprofile'] = 'Кориснички профил је попуњен';
$string['indicator:completeduserprofile_help'] = 'Овај индикатор показује да је полазник попунио свој кориснички профил.';
$string['indicator:completeduserprofiledef'] = 'Кориснички профил је попуњен';
$string['indicator:completeduserprofiledef_help'] = 'Корисник се сагласио са правилником о коришћењу сајта и попунио је следећа поља: Институција, Департман/Одсек, Адреса, Град, Држава, URL адреса.';
$string['indicator:completionenabled'] = 'Праћење завршетка је омогућено';
$string['indicator:completionenabled_help'] = 'Овај индикатор показује да је омогућено праћење завршетка за овај курс.';
$string['indicator:nostudent'] = 'Уписи полазника';
$string['indicator:nostudent_help'] = 'Овај индикатор показује доступност полазника на курсу.';
$string['indicator:noteacher'] = 'Доступност предавача';
$string['indicator:noteacher_help'] = 'Овај индикатор показује доступност предавача на курсу.';
$string['indicator:potentialcognitive'] = 'Потенцијална когнитивна дубина курса';
$string['indicator:potentialcognitive_help'] = 'Овај индикатор се заснива на потенцијалној когнитивној дубини коју би полазник могао постићи својим учешћем у активностима на курсу.';
$string['indicator:potentialcognitivedef'] = 'Потенцијална когнитивна дубина курса';
$string['indicator:potentialcognitivedef_help'] = 'Ниво до кога курс пружа „дубок“ когнитивни ангажман, нпр. предаја задатка/рада ради добијања повратних информација, могућност прегледа рада од стране других учесника, као и могућност ревизије и поновног предавања рада.';
$string['indicator:potentialcognitivedef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:potentialsocial'] = 'Потенцијални обим социјалних интеракција на курсу';
$string['indicator:potentialsocial_help'] = 'Овај индикатор се заснива на потенцијалној социјалној ширини коју би полазник могао постићи својим учешћем у активностима на курсу.';
$string['indicator:potentialsocialdef'] = 'Потенцијални обим социјалних интеракција на курсу';
$string['indicator:potentialsocialdef_help'] = 'Ниво до кога курс пружа „широк“ социјални ангажман, интеракцију са другим учесницима, као и са заједницом практичара изван самога курса.';
$string['indicator:potentialsocialdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['indicator:readactions'] = 'Број акција читања';
$string['indicator:readactions_help'] = 'Овај индикатор показује било коју акцију читања (прегледа) од стране полазника.';
$string['indicator:userforumstracking'] = 'Корисник прати форуме';
$string['indicator:userforumstracking_help'] = 'Овај индикатор показује да ли је полазник укључио праћење (не)прочитаних порука на форумима.';
$string['info'] = 'Информација';
$string['inprogress'] = 'У току';
$string['insertcontentbefore'] = 'Уметните садржај пре \'{$a->activityname}\'';
$string['insertresourceoractivitybefore'] = 'Убаците активност или ресурс пре \'{$a->activityname}\'';
$string['institution'] = 'Институција';
$string['instudentview'] = 'у полазничком погледу';
$string['interests'] = 'Интересовања';
$string['interestslist'] = 'Листа интересовања';
$string['interestslist_help'] = 'Унесите своја интересовања, једно по једно, . Она ће потом бити приказана на вашем профилу као ознаке (тагови).';
$string['invalidemail'] = 'Неисправна адреса електронске поште';
$string['invalidlogin'] = 'Погрешно корисничко име или лозинка. Молимо покушајте поново.';
$string['invalidtaskclassname'] = 'Неисправна класа задатака {$a}';
$string['invalidtaskid'] = 'Неисправна ID ознака задатака';
$string['invalidusername'] = 'Корисничко име може садржати само алфанумеричке знакове (мала слова и бројеве), доњу црту (_), цртицу (-), тачку (.) или симбол (@).';
$string['invalidusernameupload'] = 'Неисправно корисничко име';
$string['ip_address'] = 'IP адреса';
$string['jump'] = 'Прелаз';
$string['jumpto'] = 'Прелаз на...';
$string['keep'] = 'Задржите';
$string['labelvalue'] = '{$a->label}: {$a->value}';
$string['langltr'] = 'Смер писања с лева на десно';
$string['langrtl'] = 'Смер писања с десна на лево';
$string['language'] = 'Језик';
$string['languagegood'] = 'Овај језички пакет је ажуран.';
$string['languageselector'] = 'Бирач језика';
$string['last'] = 'Последњи';
$string['lastaccess'] = 'Последњи приступ';
$string['lastcourseaccess'] = 'Последњи приступ курсу';
$string['lastedited'] = 'Последњи пут уређено';
$string['lastip'] = 'Последња IP адреса';
$string['lastlogin'] = 'Последњи приступ систему';
$string['lastmodified'] = 'Последња измена';
$string['lastname'] = 'Презиме';
$string['lastnamephonetic'] = 'Презиме - фонетички';
$string['lastpage'] = 'Последња страница';
$string['lastsiteaccess'] = 'Последњи приступ сајту';
$string['lastyear'] = 'Прошлa годинa';
$string['latestlanguagepack'] = 'Погледајте најновије језичке пакете на moodle.org';
$string['layouttable'] = 'Распоред у табели';
$string['leavetokeep'] = 'Оставите празно поље да задржите тренутну лозинку';
$string['legacylogginginuse'] = 'На овом сајту је тренутно омогућено уписивање у старо складиште записа. Уписивање у то складиште је превазиђено. Молимо пребаците се на упис у подржана складишта записа као што је "стандардно" или "спољно".';
$string['legacythemeinuse'] = 'Овај сајт вам се приказује у тзв. компатибилном моду зато што је ваш веб читач застарео.';
$string['license'] = 'Лиценца';
$string['licenses'] = 'Лиценце';
$string['liketologin'] = 'Желите ли сад да приступите систему с правим корисничим налогом?';
$string['list'] = 'Списак';
$string['listfiles'] = 'Списак датотека у {$a}';
$string['listofallpeople'] = 'Списак свих корисника';
$string['listofcourses'] = 'Списак курсева';
$string['loading'] = 'Учитавање';
$string['loadinghelp'] = 'Учитавање ...';
$string['local'] = 'Локално';
$string['localplugins'] = 'Локални додаци';
$string['localpluginsmanage'] = 'Управљање локалним додацима';
$string['location'] = 'Локација';
$string['locktimeout'] = 'Операција је истекла док се чекало закључавање.';
$string['log_excel_date_format'] = 'd mmmm yyyy h:mm';
$string['loggedinas'] = 'Пријављени сте као {$a}';
$string['loggedinasguest'] = 'Тренутно приступате као гост';
$string['loggedinnot'] = 'Нисте пријављени.';
$string['login'] = 'Пријава';
$string['login_failure_logs'] = 'Записи о неуспешним пријавама';
$string['loginactivity'] = 'Преглед пријављивања на систем';
$string['loginagain'] = 'Пријавите се поново';
$string['loginalready'] = 'Већ сте пријављени на систем';
$string['loginas'] = 'Приступ систему као';
$string['loginaspasswordexplain'] = '<p>Морате унети специјалну "приступи систему као" лозинку да бисте користили ову могућност.<br />Ако не знате ту лозинку, питајте администратора свог сервера.</p>';
$string['loginguest'] = 'Приступите као гост';
$string['loginsite'] = 'Пријавите се на сајт';
$string['loginsteps'] = 'Како бисте имали пуни приступ овом сајту морате креирати кориснички налог.';
$string['loginstepsnone'] = '<p>Поштовани будући корисниче!</p>
<p>За потпуни приступ курсевима морате креирати кориснички налог.</p>
<p>Све што треба да урадите је да смислите корисничко име и лозинку и унесете их у за то одређена поља у обрасцу на овој страници!</p>
<p>Ако је неко пре Вас већ одабрао идентично корисничко име, морате одабрати неко друго и покушати поново.</p>';
$string['loginto'] = 'Пријава на {$a}';
$string['logoof'] = 'Логотип {$a}';
$string['logout'] = 'Одјава';
$string['logoutconfirm'] = 'Да ли заиста желите да се одјавите?';
$string['logs'] = 'Записи о активностима';
$string['logtoomanycourses'] = '[ <a href="{$a->url}">више</a> ]';
$string['logtoomanyusers'] = '[ <a href="{$a->url}">више</a> ]';
$string['lookback'] = 'Погледај уназад';
$string['mailadmins'] = 'Обавестити администраторе';
$string['mailstudents'] = 'Обавестити полазнике';
$string['mailteachers'] = 'Обавестити предаваче';
$string['maincoursepage'] = 'Главна страница курса';
$string['makeafolder'] = 'Креирај директоријум';
$string['makeavailable'] = 'Учини доступним';
$string['makeeditable'] = 'Ако подесите \'{$a}\' да се може уредити процесом веб сервера, онда можете мењати ову датотеку директно са ове странице';
$string['makethismyhome'] = 'Нека ово буде моја почетна страница';
$string['makeunavailable'] = 'Учини недоступним';
$string['manageblocks'] = 'Блокови';
$string['managecategories'] = 'Управљање категоријама курсева';
$string['managecategorythis'] = 'Управљање овом категоријом';
$string['managecombined'] = 'Управљање категоријама курсева и курсевима';
$string['managecontentbanktypes'] = 'Управљање типовима садржаја';
$string['managecourses'] = 'Управљање курсевима';
$string['managedatabase'] = 'База података';
$string['managedataformats'] = 'Управљање форматима података';
$string['manageeditorfiles'] = 'Управљање датотекама коришћеним од стране едитора';
$string['managefilters'] = 'Филтери';
$string['managemodules'] = 'Модули';
$string['manageroles'] = 'Улоге и права приступа';
$string['markallread'] = 'Означи све као прочитано';
$string['match'] = 'Нађи';
$string['matchingsearchandrole'] = 'Спаривање \'{$a->search}\' и {$a->role}';
$string['matchofthefollowing'] = 'од следећих:';
$string['maxareabytesreached'] = 'Датотека (или укупна величина неколико датотека) је већа од места који је преостало у овом простору.';
$string['maxfilesize'] = 'Максимална величина за нове датотеке {$a}';
$string['maxfilesreached'] = 'Дозвољено вам је да уз ову ставку приложите највише {$a} датотеку/е/а';
$string['maximumchars'] = 'Максималан број знакова: {$a}';
$string['maximumgrade'] = 'Максимална оцена';
$string['maximumgradex'] = 'Највећа оцена: {$a}';
$string['maximumshort'] = 'Макс.';
$string['maximumupload'] = 'Максимална величина датотека за постављање';
$string['maximumupload_help'] = 'Максимална величина датотеке која је полазницима дозвољена за постављање на курсу. Поред тога, можете додатно ограничити максималну величину датотеке за постављање за сваку активност, појединачно.';
$string['maxnumberweeks'] = 'Максималан број секција';
$string['maxnumberweeks_desc'] = 'Максимална вредност у падајућем менију  "Број секција" (важи само за одређене формате курса).';
$string['maxnumcoursesincombo'] = 'Претражи <a href="{$a->link}">{$a->numberofcourses} курсеве</a>';
$string['maxsectionslimit'] = 'Није могуће креирати нову секцију пошто би се тиме премашио максималан број секција који је дозвољен за овај курс ({$a}).';
$string['maxsize'] = 'Макс. величина: {$a}';
$string['maxsizeandareasize'] = 'Максимална величина за нове датотеке: {$a->size}, глобално ограничење: {$a->areasize}';
$string['maxsizeandattachments'] = 'Максимална величина датотеке: {$a->size}, максималан број датотека: {$a->attachments}';
$string['maxsizeandattachmentsandareasize'] = 'Максимална величина датотеке: {$a->size}, максималан број датотека: {$a->attachments}, укупно ограничење величине: {$a->areasize}';
$string['memberincourse'] = 'Учесници у курсу';
$string['menu'] = 'Мени';
$string['message'] = 'Порука';
$string['messagebody'] = 'Тело поруке';
$string['messagedselectedusers'] = 'Изабраним корисницима послата је порука, а списак прималаца је  ресетован.';
$string['messagedselectedusersfailed'] = 'Нешто није било у реду при слању поруке изабраним корисницима. Неки од њих су ипак можда примили послату поруку.';
$string['messageprovider:asyncbackupnotification'] = 'Обавештења о асинхроном креирању/рестаурирању резервних копија';
$string['messageprovider:availableupdate'] = 'Доступна обавештења о ажурирању';
$string['messageprovider:backup'] = 'Обавештења о креирању резервне копије';
$string['messageprovider:badgecreatornotice'] = 'Обавештење о креатору беџа';
$string['messageprovider:badgerecipientnotice'] = 'Обавештење о примаоцу беџа';
$string['messageprovider:competencyplancomment'] = 'Коментар објављен на плану учења';
$string['messageprovider:competencyusercompcomment'] = 'Коментар постављен на компетенцијама';
$string['messageprovider:coursecompleted'] = 'Курс завршен';
$string['messageprovider:coursecontentupdated'] = 'Промене садржаја курса';
$string['messageprovider:courserequestapproved'] = 'Обавештење о одобрењу захтева за креирање курса';
$string['messageprovider:courserequested'] = 'Обавештење о захтеву за креирање курса';
$string['messageprovider:courserequestrejected'] = 'Обавештење о одбијању захтева за креирање курса';
$string['messageprovider:enrolcoursewelcomemessage'] = 'Порука добродошлице за нове уписе на курс';
$string['messageprovider:errors'] = 'Важне грешке у вези са сајтом';
$string['messageprovider:errors_help'] = 'Ово су важне грешке о којима администратор мора да буде упознат';
$string['messageprovider:failedtaskmaxdelay'] = 'Задатак је достигао максимално време одлагања након неуспешног покушаја покретања';
$string['messageprovider:gradenotifications'] = 'Обавештења о оцени';
$string['messageprovider:infected'] = 'Обавештења о неуспелим операцијама антивирусног програма.';
$string['messageprovider:insights'] = 'Увиди које су генерисали модели предвиђања';
$string['messageprovider:instantmessage'] = 'Личне поруке између корисника';
$string['messageprovider:instantmessage_help'] = 'Ова секција конфигурише шта се догађа са порукама који су вам директно послате од стране других корисника на овом сајту.';
$string['messageprovider:messagecontactrequests'] = 'Обавештење о захтевима за контакт';
$string['messageprovider:newlogin'] = 'Обавештења о новим пријавама на сајт';
$string['messageprovider:notices'] = 'Обавештења о мањим проблемима';
$string['messageprovider:notices_help'] = 'Ово су обавештења која би могла да интересују администратора да их погледа.';
$string['messageprovider:reportbuilderschedule'] = 'Распореди за креирања прилагођених извештаја';
$string['messageselect'] = 'Изаберите овог корисника као примаоца поруке';
$string['messageselectadd'] = 'Пошаљи поруку';
$string['middlename'] = 'Средње име';
$string['migratinggrades'] = 'Миграција оцена';
$string['min'] = 'min';
$string['mins'] = 'min';
$string['minute'] = 'минут';
$string['minutes'] = 'минут/а';
$string['miscellaneous'] = 'Разно';
$string['missingcategory'] = 'Морате одабрати категорију';
$string['missingdescription'] = 'Недостаје опис';
$string['missingemail'] = 'Недостаје адреса е-поште';
$string['missingfirstname'] = 'Недостаје име';
$string['missingfromdisk'] = 'Недостаје на диску';
$string['missingfullname'] = 'Недостаје пуно име';
$string['missinglastname'] = 'Недостаје презиме';
$string['missingname'] = 'Недостаје име';
$string['missingnewpassword'] = 'Недостаје нова лозинка';
$string['missingpassword'] = 'Недостаје лозинка';
$string['missingrecaptchachallengefield'] = 'reCAPTCHA покушај није успео, пробајте поново.';
$string['missingreqreason'] = 'Недостаје разлог';
$string['missingshortname'] = 'Недостаје скраћени назив';
$string['missingshortsitename'] = 'Недостаје скраћени назив сајта';
$string['missingsitedescription'] = 'Недостаје опис сајта';
$string['missingsitename'] = 'Недостаје назив сајта';
$string['missingstrings'] = 'Провера непреведених речи или израза';
$string['missingstudent'] = 'Морате нешто одабрати';
$string['missingsummary'] = 'Недостаје резиме';
$string['missingteacher'] = 'Морате нешто одабрати';
$string['missingurl'] = 'Недостаје URL';
$string['missingusername'] = 'Недостаје корисничко име';
$string['moddoesnotsupporttype'] = 'Модул {$a->modname} не подржава постављања типа {$a->type}';
$string['modhide'] = 'Сакриј';
$string['modified'] = 'Измењено';
$string['modshow'] = 'Прикажи';
$string['moduleintro'] = 'Опис';
$string['modulesetup'] = 'Подешавање табела модула';
$string['modulesuccess'] = '{$a} табела је исправно подешено';
$string['modulesused'] = 'Коришћени модули';
$string['modvisible'] = 'Доступност';
$string['modvisible_help'] = '* Прикажи на страници курса: доступно полазницима (уз сва ограничења приступа која се могу подесити).
* Сакриј на страници курса: није доступно полазницима.';
$string['modvisiblehiddensection'] = 'Доступност';
$string['modvisiblehiddensection_help'] = '* Сакриј на страници курса: није доступно студентима.
* Учини доступним, али не приказуј на страници курса: доступно полазницима ако поставите линк. Активности ће се и даље појављивати у књизи оцена и другим извештајима.';
$string['modvisiblewithstealth'] = 'Доступност';
$string['modvisiblewithstealth_help'] = '* Прикажи на страници курса: доступно полазницима (уз сва ограничења приступа која се могу подесити).
* Сакриј на страници курса: није доступно полазницима.
* Учини доступним, али не приказуј на страници курса: доступно полазницима ако поставите линк. Активности ће се и даље појављивати у књизи оцена и другим извештајима.';
$string['month'] = 'Месец';
$string['months'] = 'Месеци';
$string['moodledocs'] = 'Moodle документација';
$string['moodledocslink'] = 'Документација за ову страницу';
$string['moodlelogo'] = 'Moodle лого';
$string['moodlenet:cannotconnecttoserver'] = 'Није могуће повезати се са MoodleNet сервером';
$string['moodlenet:columnname'] = 'Назив';
$string['moodlenet:columnsenddate'] = 'Датум слања';
$string['moodlenet:columnsendstatus'] = 'Статус слања';
$string['moodlenet:columntype'] = 'Тип';
$string['moodlenet:configoauthservice'] = 'Изаберите MoodleNet OAuth 2 сервис како бисте омогућили дељење на том MoodleNet сајту. Ако сервис још не постоји, мораћете да га <a href="{$a}">креирате</a> it.';
$string['moodlenet:deletedactivity'] = 'Обрисана активност';
$string['moodlenet:deletedcourse'] = 'Обрисан курс';
$string['moodlenet:eventresourceexported'] = 'Ресурс експортован';
$string['moodlenet:gotomoodlenet'] = 'Идите на радне верзије на MoodleNet платформи';
$string['moodlenet:issuerisnotauthorized'] = 'MoodleNet издавач није ауторизован';
$string['moodlenet:issuerisnotenabled'] = 'MoodleNet издавач није омогућен';
$string['moodlenet:issuerisnotset'] = 'MoodleNet издавач није подешен у администрацији сајта';
$string['moodlenet:nosharedresources'] = 'У овом тренутку не постоје дељени ресурси који се могу приказти.';
$string['moodlenet:outboundsettings'] = 'MoodleNet одлазна подешавања';
$string['moodlenet:packagingandsending'] = 'Паковање ваше датотеке и слање на MoodleNet...';
$string['moodlenet:sharefailtext'] = 'Дошло је до грешке приликом дељења вашег садржаја на MoodleNet платформи. <br>Покушајте поново касније.';
$string['moodlenet:sharefailtextwithsitesupport'] = 'Дошло је до грешке приликом дељења вашег садржаја на MoodleNet платформи. <br>Покушајте поново касније или <a href="{$a}">контактирајте подршку сајта</a>.';
$string['moodlenet:sharefailtitle'] = 'Нешто није у реду';
$string['moodlenet:sharefilesizelimitexceeded'] = 'Величина ресурса који се дели ({$a->filesize} бајтова) премашује ограничење од {$a->filesizelimit} бајтова.';
$string['moodlenet:sharenoticeactivity'] = 'Ова активност је доступна преко MoodleNet платформе као ресурс.';
$string['moodlenet:sharenoticecourse'] = 'Овај курс је доступан преко MoodleNet платформе као ресурс.';
$string['moodlenet:sharenoticepartial'] = 'Изабране активности се деле на MoodleNet платформи као ресурс.';
$string['moodlenet:sharenoticepartialactivitynumber'] = 'Број активности који ће бити укључене у курс: {$a}.';
$string['moodlenet:shareprogress'] = 'Напредак дељења на MoodleNet платформи';
$string['moodlenet:shareprogressinfo'] = 'Списак приказује курсеве и активности које сте поделили на MoodleNet платформи.<br>Кликните на назив ресурса како бисте га видели на MoodleNet платформи.';
$string['moodlenet:sharesuccesstext'] = 'Скоро сте готови! Посетите своје радне верзије на MoodleNet платформи како бисте завршили дељење свог садржаја.';
$string['moodlenet:sharesuccesstitle'] = 'Сачувано као радна верзија на MoodleNet платформи';
$string['moodlenet:sharetomoodlenet'] = 'Поделите на MoodleNet платформи';
$string['moodlenet:sharinglargefile'] = 'Слање великих датотека може потрајати неко време.';
$string['moodlenet:sharingstatus'] = 'Дељење на MoodleNet платформи';
$string['moodlenet:sharingto'] = 'Дељење на:';
$string['moodlerelease'] = 'Moodle верзија';
$string['moodleservicesandsupport'] = 'Сервиси и подршка';
$string['moodleversion'] = 'Moodle верзија';
$string['more'] = 'још';
$string['moreactions'] = 'Више акцијa';
$string['morehelp'] = 'Више помоћи';
$string['morehelpaboutmodule'] = 'Додатна помоћ о активности {$a}';
$string['moreinfo'] = 'Више информација';
$string['moreinformation'] = 'Више информација о овој грешци';
$string['moremenu'] = 'Више';
$string['morenavigationlinks'] = 'Више...';
$string['moreprofileinfoneeded'] = 'Молимо реците нам нешто више о себи';
$string['mostrecently'] = 'најновије';
$string['move'] = 'Премести';
$string['movecategoriessuccess'] = 'Успешно премештено  {$a->count} категорија/е у категорију \'{$a->to}\'';
$string['movecategoriestotopsuccess'] = 'Успешно премештено {$a->count} категорија/е на највиши ниво';
$string['movecategorycontentto'] = 'Премести у:';
$string['movecategorysuccess'] = 'Категорије \'{$a->moved}\' је успешно премештена  у категорију \'{$a->to}\'';
$string['movecategoryto'] = 'Премести категорију у:';
$string['movecategorytotopsuccess'] = 'Категорије \'{$a->moved}\' је успешно премештена на највиши ниво';
$string['movecontent'] = 'Премести {$a}';
$string['movecontentafter'] = 'После "{$a}"';
$string['movecontentstoanothercategory'] = 'Премести садржај у другу категорију';
$string['movecontenttothetop'] = 'На врх списак';
$string['movecoursemodule'] = 'Премести активност';
$string['movecoursesection'] = 'Премести секцију';
$string['movecourseto'] = 'Премести курс у:';
$string['movedown'] = 'Премести доле';
$string['movefilestohere'] = 'Премести датотеке овде';
$string['movefull'] = 'Премести {$a} на ову локацију';
$string['movehere'] = 'Премести овамо';
$string['moveitemdown'] = 'Премести {$a} надоле';
$string['moveitemup'] = 'Премести {$a} нагоре';
$string['moveleft'] = 'Помакни улево';
$string['moveright'] = 'Помакни удесно';
$string['movesection'] = 'Премести секцију {$a}';
$string['moveselectedcategoriesto'] = 'Премести изабране категорије у';
$string['moveselectedcoursesto'] = 'Премести изабране курсеве у...';
$string['movetoanotherfolder'] = 'Премести у други директоријум';
$string['moveup'] = 'Премести горе';
$string['mustchangepassword'] = 'Нова лозинка мора бити различита од тренутне';
$string['mustconfirm'] = 'Морате потврдити свој налог';
$string['mycourses'] = 'Моји курсеви';
$string['myfiles'] = 'Моје приватне датотеке';
$string['myfilesmanage'] = 'Управљање мојим приватним датотекема';
$string['myhome'] = 'Контролни панел';
$string['mymoodledashboard'] = 'Мој Moodle контролни панел';
$string['myprofile'] = 'Мој профил';
$string['name'] = 'Име';
$string['namedfiletoolarge'] = 'Датотека \'{$a->filename}\' је превелика и не може бити отпремљена';
$string['nameforlink'] = 'Како желите да назовете овај линк?';
$string['nameforpage'] = 'Назив';
$string['navigation'] = 'Навигација';
$string['needed'] = 'Потребно';
$string['networkdropped'] = 'Открили смо да ваша интерне веза није поуздана или да је у прекиду.<br />
Молимо вас. имајте на уму да промене не могу да буду сачуване онако како је то потребно све док се ваша веза не поправи.';
$string['never'] = 'Никад';
$string['neverdeletelogs'] = 'Никада не бриши  записе о активностима';
$string['new'] = 'Ново';
$string['newaccount'] = 'Нови кориснички налог';
$string['newactivityname'] = 'Нови назив за активност {$a}';
$string['newcourse'] = 'Нови курс';
$string['newloginnotificationbodyfull'] = '<p>Поштована/и, {$a->userfullname},</p>
<p>Ваш {$a->sitename} налог је управо употребљен за пријаву са новог уређаја.</p>
<ul>
<li>Ваш налог: {$a->username} {$a->useremail}</li>
<li>{$a->logintime}</li>
<li>Уређај: {$a->logindevice}</li>
<li>IP адреса: {$a->loginip}</li>
</ul>
<p>Ако сте то били ви, онда не морате ништа да радите.</p>
<p>Ако не препознајете ову активност, молим вас да <a href="{$a->changepasswordlink}">промените своју лозинку</a>.</p>';
$string['newloginnotificationbodysmall'] = 'Ваш {$a} налог је управо употребљен за пријаву са новог уређаја.';
$string['newloginnotificationtitle'] = 'Новa пријавa на {$a} са вашим налогом';
$string['newpassword'] = 'Нова лозинка';
$string['newpassword_help'] = 'Унесите нову лозинку или оставите поље празно како бисте задржали текућу лозинку.';
$string['newpasswordfromlost'] = '<strong>ОБАВЕШТЕЊЕ:</strong> Ваша <strong>тренутна лозинка</strong> биће вам послата у <strong>другој</strong> од две поруке послате у току поступка за поновно добијање изгубљене лозинке. Проверите да ли сте примили замену лозинке пре него што наставите са овим екраном.';
$string['newpasswordtext'] = 'Поштована/и {$a->firstname},

Лозинка вашег налога на сајту \'{$a->sitename}\' је ресетована и додељена вам је нова привремена лозинка.

Ваши тренутни подаци за приступ систему су:
   корисничко име: {$a->username}
   лозинка: {$a->newpassword}

Молимо вас да посетите ову страницу како бисте променили своју лозинку:
   {$a->link}

У већини програма за електронску пошту, ово би требало да се појави као плаво обојени линк на који је потребно само кликнути. Ако та опција не функционише, копирајте наведену адресу у адресну линију на врху прозора вашег веб читача.

Поздрав,
\'{$a->sitename}\' администратор,
{$a->signoff}';
$string['newpicture'] = 'Нова слика';
$string['newpicture_help'] = 'Да бисте додали нову слику, пронађите и одаберите једну (у JPG или PNG формату) и кликните на "Ажурирај профил". Слика ће бити исечена у облику квадрата а њена величина смањена на 100x100 пиксела.';
$string['newpictureusernotsetup'] = 'Слика се може додати на страницу профила тек када су сачуване све неопходне информације у профилу корисника.';
$string['newsectionname'] = 'Нови назив за секцију {$a}';
$string['newsitem'] = 'вест';
$string['newsitems'] = 'обавештења';
$string['newsitemsnumber'] = 'Број обавештења';
$string['newsitemsnumber_help'] = 'Стандардно, сви учесници курса су претплаћени на форум. Само предавачи и корисници са одговарајућим овлашћењима могу да објављују поруке на овом форуму.

Ако вам форум \'Обавештења\' није потребан, поставите ово подешавање на нулу.

Ово подешавање одређује колико ће се скорашњих обавештења појавити у блоку \'Најновија обавештења\'.';
$string['newuser'] = 'Нови корисник';
$string['newusernewpasswordsubj'] = 'Нови кориснички налог';
$string['newusernewpasswordtext'] = 'Поштована/и {$a->firstname},

Отворен вам је нови кориснички налог на сајту \'{$a->sitename}\'.

     корисничко име: {$a->username}
     лозинка: {$a->newpassword}

(Мораћете да промените лозинку када се први пут пријавите на систем)

Да бисте почели да користите сајт \'{$a->sitename}\', пријавите се на {$a->link}

Ако вам је потребна помоћ, можете контактирати администратора сајта,
{$a->admin}';
$string['newusers'] = 'Нови корисници';
$string['newwindow'] = 'Нови прозор';
$string['next'] = 'Следећи';
$string['nextpage'] = 'Следећа страница';
$string['nextsection'] = 'Следeћа секција';
$string['no'] = 'Не';
$string['noblockstoaddhere'] = 'Не постоје блокови које можете додати овој страници.';
$string['nobody'] = 'Нико';
$string['nochange'] = 'Без промена';
$string['nocomments'] = 'Нема коментара';
$string['nocourses'] = 'Нема курсева';
$string['nocoursesfound'] = 'Ниједан курс не садржи појам \'{$a}\'';
$string['nocoursestarttime'] = 'Курс нема датум почетка.';
$string['nocoursesyet'] = 'Нема курсева у овој категорији';
$string['nodstpresets'] = 'Администратор система није омогућио подршку за Daylight Savings Time.';
$string['nofilesselected'] = 'Није изабрана ниједна датотека за рестаурирање.';
$string['nofilesyet'] = 'Унутар овог курса још није постављена ниједна датотека';
$string['nofiltersapplied'] = 'Ниједан филтер није примењен';
$string['nograde'] = 'Нема оцене';
$string['nohelpforactivityorresource'] = 'Тренутно не постоји помоћ везана за овај ресурс или активност';
$string['noimagesyet'] = 'Унутар овог курса још није постављена ниједна слика';
$string['nologsfound'] = 'Није пронађен ниједан запис';
$string['nomatchingusers'] = 'Ниједан корисник се не поклапа са \'{$a}\'';
$string['nomorecourses'] = 'Није пронађено више курсева који се уклапају са задатим критеријумима';
$string['nomoreidnumber'] = 'Не користи се idnumber да би се избегле колизије';
$string['none'] = 'Ниједан';
$string['noneditingteacher'] = 'Предавач без уређивачких права';
$string['noneditingteacherdescription'] = 'Предавачи без уређивачких права могу да предају на курсевима и оцењују полазнике, али не могу да мењају активности.';
$string['nonstandard'] = 'Нестандардно';
$string['nopendingcourses'] = 'Нема курсева који чекају на одобрење';
$string['nopotentialadmins'] = 'Нема потенцијалних администратора';
$string['nopotentialcreators'] = 'Нема потенцијалних креатора курса';
$string['nopotentialstudents'] = 'Нема потенцијалних полазника';
$string['nopotentialteachers'] = 'Нема потенцијалних предавача';
$string['norecentactivity'] = 'Нема недавних активности';
$string['noreplybouncemessage'] = 'Одговорили сте на адресу електронске поште са које се поруке само шаљу (no-reply email address). Ако сте покушавали да одговорите на поруку са форума, молимо да то учините директно користећи {$a} форуме.

Следи садржај ваше поруке:';
$string['noreplybouncesubject'] = '{$a} - враћена е-порука.';
$string['noreplyname'] = 'Немојте одговарати на ову е-поруку';
$string['noresetrecord'] = 'Не постоји запис о овом захтеву за промену лозинке. Молимо вас да покренете нов захтев за промену лозинке.';
$string['noresults'] = 'Нема резултата';
$string['noresultsfor'] = 'Нема резултата за "{$a}"';
$string['normal'] = 'Нормално';
$string['normalfilter'] = 'Нормална претрага';
$string['nosite'] = 'Није пронађен курс на нивоу сајта';
$string['nostudentsfound'] = '{$a} - није пронађено';
$string['nostudentsingroup'] = 'Још нема полазника у овој групи';
$string['nostudentsyet'] = 'На овом курсу нема уписаних полазника.';
$string['nosuchemail'] = 'Нема такве адресе е-поште';
$string['notavailable'] = 'Није доступно';
$string['notavailablecourse'] = 'Секција {$a} није доступна';
$string['noteachersyet'] = 'Још увек нема предавача на овом курсу';
$string['noteachingupcomingcourses'] = 'Предстојећи курсеви немају предаваче или полазнике';
$string['notenrolled'] = '{$a} није уписан/а на овај курс.';
$string['notenrolledprofile'] = 'Овај профил није доступан јер корисник није пријављен за овај курс.';
$string['noteusercannotrolldatesoncontext'] = '<strong>Напомена:</strong> Могућност мењања датума приликом обнављања ове резервне копије је онемогућена јер немате потребна овлашћења.';
$string['noteuserschangednonetocourse'] = 'Напомена: Када рестаурирате корисничке податке (у активностима, датотекама или порукама) морате да рестаурирате и кориснике курса. Ово подешавање је промењено за вас.';
$string['nothingnew'] = 'Нема скорашњих активности';
$string['nothingtodisplay'] = 'Нема ничега за приказ';
$string['notice'] = 'Напомена';
$string['noticenewerbackup'] = 'Ова датотека резервне копије је направљена помоћу Moodle верзије {$a->backuprelease} ({$a->backupversion}) и новија је од ваше тренутно инсталиране верзије Moodlea {$a->serverrelease} ({$a->serverversion}). Ово би могло да  доведе до одређених недоследности због тога што не може да се гарантује компатибилност датотека резервних копија које су креиране помоћу новијих верзија Мoodlea.';
$string['notifications'] = 'Обавештења';
$string['notifyloginfailuresmessage'] = '{$a->time}, IP: {$a->ip}, Корисник: {$a->info}, Пуно име корисника: {$a->name}';
$string['notifyloginfailuresmessageend'] = 'Ове записе можете видети на {$a}';
$string['notifyloginfailuresmessagestart'] = 'Ово је списак грешака при приступу систему на {$a} од последњег обавештења које сте примили';
$string['notifyloginfailuressubject'] = '{$a} :: Обавештење о грешкама при приступу систему';
$string['notincluded'] = 'Није укључено';
$string['notingroup'] = 'Нажалост, морате бити члан групе како бисте видели ову страницу.';
$string['notpublic'] = 'Није јавно!';
$string['nousersfound'] = 'Није пронађен ниједан корисник';
$string['nousersmatching'] = 'Није пронађен ниједан корисник који се подудара са \'{$a}\'';
$string['nousersyet'] = 'Још нема корисника';
$string['novalidcourses'] = 'Нема важећих курсева који би били приказани';
$string['now'] = 'сада';
$string['numattempts'] = 'Број неуспешних покушаја приступа систему: {$a}';
$string['numberofcourses'] = 'Број курсева';
$string['numberweeks'] = 'Број секција';
$string['numday'] = '{$a} дан';
$string['numdays'] = '{$a} дан(а)';
$string['numhours'] = '{$a} h';
$string['numletters'] = '??? слово(а)';
$string['numminutes'] = '{$a} min';
$string['nummonth'] = '{$a} месец';
$string['nummonths'] = '{$a} месец(a)';
$string['numseconds'] = '{$a} s';
$string['numviews'] = '{$a} преглед(а)';
$string['numweek'] = '{$a} недеља';
$string['numweeks'] = '{$a} седмица/е';
$string['numwords'] = '{$a} реч(и)';
$string['numyear'] = '{$a} година';
$string['numyears'] = '{$a} година(е)';
$string['ok'] = 'OK';
$string['oldpassword'] = 'Тренутна лозинка';
$string['olduserdirectory'] = 'Ово је СТАРИ кориснички директоријум који више није потребан. Можете га слободно обрисати. Датотеке из овог директоријума су копиране у НОВИ кориснички директоријум.';
$string['opendrawerblocks'] = 'Отвори фиоку са блоковима';
$string['opendrawerindex'] = 'Отвори фиоку са индексом курса';
$string['opensinnewwindow'] = 'Отвара се у новом прозору';
$string['operator_and'] = 'и';
$string['operator_andnot'] = 'и';
$string['operator_or'] = 'или';
$string['optional'] = 'опционо';
$string['options'] = 'опције';
$string['order'] = 'Поредак';
$string['originalpath'] = 'Оригинална путања';
$string['orphanedactivitiesinsectionno'] = 'Активности сирочићи (секција {$a})';
$string['other'] = 'Остали';
$string['outline'] = 'Кратак преглед';
$string['outlinereport'] = 'Скраћени извештај';
$string['page'] = 'Страница';
$string['pagea'] = 'Страница {$a}';
$string['pagedcontentnavigation'] = 'Навигација нумерисаних страница';
$string['pagedcontentnavigationactiveitem'] = 'Текућа страница, страница {$a}';
$string['pagedcontentnavigationitem'] = 'Иди на страницу {$a}';
$string['pagedcontentpagingbaritemsperpage'] = 'Број ставки приказаних по страници: {$a}';
$string['pageheaderconfigablock'] = 'Конфигурисање блока у {$a->fullname}';
$string['pagepath'] = 'Путања до странице';
$string['pageshouldredirect'] = 'Ова страница би требало да вас аутоматски преусмери. Уколико се ништа не догађа молимо вас да за наставак употребите доњи линк.';
$string['parentcategory'] = 'Надређена категорија';
$string['parentcoursenotfound'] = 'Надређени курс није пронађен!';
$string['parentfolder'] = 'Надређени директоријум';
$string['participants'] = 'Учесници';
$string['participantslist'] = 'Списак учесника';
$string['participationratio'] = 'Однос учешћа';
$string['participationreport'] = 'Извештај о учешћу';
$string['password'] = 'Лозинка';
$string['passwordchanged'] = 'Лозинка је промењена';
$string['passwordextlink'] = 'Следећи линк Вам је на располагању за опоравак Ваше изгубљене лозинке. Клик на њега ће Вас извести из Moodle система.';
$string['passwordforgotten'] = 'Заборављена лозинка';
$string['passwordforgotteninstructions'] = 'Ваши подаци прво морају бити пронађени у бази података корисника. Молимо унесите <strong>или</strong> своје корисничко име или пријављену електронску адресу у одговарајуће поље. Нема потребе да уносите оба податка.';
$string['passwordforgotteninstructions2'] = 'За ресетовање ваше лозинке упишите своје корисничко име или електронску адресу. Уколико ти подаци постоје у бази података, биће вам послата порука на електронску адресу са упутством како поново да добијете приступ.';
$string['passwordpolicynomatch'] = 'Ваша тренутна лозинка се више не подудара са са постојећим правилима за креирање лозинке.
   {$a}';
$string['passwordsdiffer'] = 'Лозинке се не поклапају';
$string['passwordset'] = 'Ваша лозинка је подешена.';
$string['path'] = 'Путања';
$string['pathnotexists'] = 'Путања не постоји на Вашем серверу!';
$string['pathslasherror'] = 'Путања се не може завршавати косом цртом.';
$string['paymentinstant'] = 'Употребите дугме испод како бисте извршили уплату и уписали курс у року од неколико минута.';
$string['paymentpending'] = '(<small><b><u>{$a}</u></b> на чекању</small>)';
$string['paymentrequired'] = 'Овај курс захтева уплату за упис';
$string['payments'] = 'Уплате';
$string['paymentsorry'] = 'Хвала вам на уплати! Када, ваша уплата буде обрађена моћи ћете да се пријавите на курс {$a->fullname}. Молимо вас, сачекајте а онда покушајте поново. Ако и даље будете имали проблема, онда обавестите предавача {$a->teacher} или администратора сајта.';
$string['paymentthanks'] = 'Хвала вашој уплати. Сада сте уписани на курс {$a}.';
$string['pendingrequests'] = 'Захтеви на чекању';
$string['percents'] = '{$a}%';
$string['periodending'] = 'Завршетак периода ({$a})';
$string['perpage'] = 'По страници';
$string['perpagea'] = 'По страници: {$a}';
$string['personal'] = 'Лично';
$string['personalprofile'] = 'Лични профил';
$string['phone'] = 'Телефон';
$string['phone1'] = 'Телефон';
$string['phone2'] = 'мобилни телефон';
$string['phpinfo'] = 'PHP информације';
$string['picture'] = 'Слика';
$string['pictureof'] = 'Слика {$a}';
$string['pictureofuser'] = 'Слика корисника';
$string['placeholdertypeorselect'] = 'Унеси или изабери...';
$string['pleaseclose'] = 'Молим Вас затворите сада овај прозор.';
$string['pleasesearchmore'] = 'Наставите претрагу';
$string['pleaseusesearch'] = 'Употребите претрагу';
$string['plugin'] = 'Додатак';
$string['pluginarea'] = 'Област';
$string['plugincheck'] = 'Провера додатака';
$string['plugindeletefiles'] = 'Сви подаци повезани са додатком: \'{$a->name}\' су обрисани из базе података. Да бисте спречили аутоматску реинсталацију додатка,  потребно је да сада са сервера обришете овај директоријум: {$a->directory}';
$string['pluginitemid'] = 'ID ознака ставке';
$string['pluginmissingfromdisk'] = '{$a->name} (недостаје на диску)';
$string['pluginsetup'] = 'Подешавање табеле додатака';
$string['policyaccept'] = 'Разумем и пристајем';
$string['policyagree'] = 'Да би сте наставили коришћење овог сајта морате се сложити са правилима коришћења. Да ли се слажете?';
$string['policyagreement'] = 'Сагласност са правилником о коришћењу сајта';
$string['policyagreementclick'] = 'Правилник о коришћењу сајта';
$string['popup'] = 'искачући прозор';
$string['popupwindow'] = 'Отвори датотеку у новом прозору';
$string['popupwindowname'] = 'Искачући прозор';
$string['post'] = 'Порука';
$string['posts'] = 'Поруке';
$string['potentialadmins'] = 'Потенцијални администратори';
$string['potentialcreators'] = 'Потенцијални креатори курса';
$string['potentialstudents'] = 'Потенцијални полазници';
$string['potentialteachers'] = 'Потенцијални предавачи';
$string['poweredbymoodle'] = 'Овај портал покреће <a href="https://moodle.com">Moodle</a>';
$string['preferences'] = 'Параметри';
$string['preferredlanguage'] = 'Преферирани језик';
$string['preferredtheme'] = 'Преферирана графичка тема';
$string['preprocessingbackupfile'] = 'Претходна обрада датотеке резервне копије';
$string['prev'] = 'Претходно';
$string['preview'] = 'Преглед';
$string['previeworchoose'] = 'Прегледај или изабери графичку тему';
$string['previewthemename'] = 'Преглед теме \'{$a}\'';
$string['previous'] = 'Претходни';
$string['previouslyselectedusers'] = 'Претходно изабрани корисници се не поклапају са \'{$a}\'';
$string['previouspage'] = 'Претходна страница';
$string['previoussection'] = 'Претходна секција';
$string['primaryadminsetup'] = 'Подеси налог администратора';
$string['privacy:metadata:config_log'] = 'Запис о изменама конфигурације.';
$string['privacy:metadata:config_log:name'] = 'Назив измена подешавања.';
$string['privacy:metadata:config_log:oldvalue'] = 'Претходна вредност за ово подешавање.';
$string['privacy:metadata:config_log:plugin'] = 'Додатак је измењен.';
$string['privacy:metadata:config_log:timemodified'] = 'Време када је дошло до промене.';
$string['privacy:metadata:config_log:userid'] = 'Корисник који је направио промену.';
$string['privacy:metadata:config_log:value'] = 'Нова вредност за ово подешавање.';
$string['privacy:metadata:events_queue'] = 'Кориснички догађаји који чекају да буду обрађени.';
$string['privacy:metadata:events_queue:eventdata'] = 'Подаци који се чувају у догађају.';
$string['privacy:metadata:events_queue:stackdump'] = 'Сва стања стека повезана са овим догађајем.';
$string['privacy:metadata:events_queue:timecreated'] = 'Време када је овај догађај креиран.';
$string['privacy:metadata:events_queue:userid'] = 'Корисничка ID ознака повезана са овим догађајем';
$string['privacy:metadata:log'] = 'Колекција протеклих догађаја';
$string['privacy:metadata:log:action'] = 'Опис акције';
$string['privacy:metadata:log:cmid'] = 'cmid';
$string['privacy:metadata:log:course'] = 'курс';
$string['privacy:metadata:log:info'] = 'Додатне информације';
$string['privacy:metadata:log:ip'] = 'IP адреса коришћена у време догађаја';
$string['privacy:metadata:log:module'] = 'модул';
$string['privacy:metadata:log:time'] = 'Време када је акција извршена';
$string['privacy:metadata:log:url'] = 'URL адреса везана за догађај';
$string['privacy:metadata:log:userid'] = 'ID ознака корисника који је извршио акцију';
$string['privacy:metadata:moodlenet_share_progress'] = 'Детаљније информације MoodleNet платформе о напретку дељења';
$string['privacy:metadata:moodlenet_share_progress:cmid'] = 'Придружена ID ознака модула';
$string['privacy:metadata:moodlenet_share_progress:courseid'] = 'Придружена ID ознака курса';
$string['privacy:metadata:moodlenet_share_progress:resourceurl'] = 'Повратна URL адреса коју је послао MoodleNet након успешног дељења';
$string['privacy:metadata:moodlenet_share_progress:status'] = 'Резултујући статус дељења';
$string['privacy:metadata:moodlenet_share_progress:timecreated'] = 'Време када је дељење извршено';
$string['privacy:metadata:moodlenet_share_progress:type'] = 'Тип дељења који је извршен';
$string['privacy:metadata:moodlenet_share_progress:userid'] = 'Корисник који је извршио дељење';
$string['privacy:metadata:oauth2_refresh_token'] = 'Освежи токен који се користи у OAuth 2.0 комуникацији';
$string['privacy:metadata:oauth2_refresh_token:issuerid'] = 'ID ознака даваоца идентитета коме токен одговара';
$string['privacy:metadata:oauth2_refresh_token:scopehash'] = 'ID ознака корисника коме токен одговара';
$string['privacy:metadata:oauth2_refresh_token:timecreated'] = 'Време када је токен креиран';
$string['privacy:metadata:oauth2_refresh_token:timemodified'] = 'Време када је токен ажуриран';
$string['privacy:metadata:oauth2_refresh_token:token'] = 'Токен освежавања за одговарајући опсег и корисника';
$string['privacy:metadata:oauth2_refresh_token:userid'] = 'ID корисника којем токен одговара';
$string['privacy:metadata:task_adhoc'] = 'Статус ад хок задатака.';
$string['privacy:metadata:task_adhoc:component'] = 'Компонента која поседује задатак.';
$string['privacy:metadata:task_adhoc:nextruntime'] = 'Најраније време за покретање овог задатка.';
$string['privacy:metadata:task_adhoc:userid'] = 'Корисник који покреће задатак.';
$string['privacy:metadata:task_log'] = 'Испис за запис';
$string['privacy:metadata:task_log:component'] = 'Компонента која поседује задатак.';
$string['privacy:metadata:task_log:userid'] = 'Корисник ком је задатак припадао.';
$string['privacy:metadata:upgrade_log'] = 'Запис о надоградњи.';
$string['privacy:metadata:upgrade_log:backtrace'] = 'Списак свих функција повезаних са овим кораком надоградње.';
$string['privacy:metadata:upgrade_log:details'] = 'Додатне информације у вези са надоградњом.';
$string['privacy:metadata:upgrade_log:info'] = 'Главне информације за овај корак надоградње.';
$string['privacy:metadata:upgrade_log:plugin'] = 'Додатак који је надограђен.';
$string['privacy:metadata:upgrade_log:targetversion'] = 'Нова верзија за надоградњу.';
$string['privacy:metadata:upgrade_log:timemodified'] = 'Време када се надоградња одиграла.';
$string['privacy:metadata:upgrade_log:type'] = 'Тип ставке у запису.';
$string['privacy:metadata:upgrade_log:userid'] = 'Корисник који је покренуо надоградњу';
$string['privacy:metadata:upgrade_log:version'] = 'Стара верзија додатка.';
$string['private_files_handler'] = 'Сместите прилоге уз е-поруку у простор за приватне датотеке корисника.';
$string['private_files_handler_name'] = 'Пошаљи е-поштом у приватне датотеке';
$string['privatefiles'] = 'Приватне датотеке';
$string['privatefilesmanage'] = 'Управљање приватним датотекама';
$string['proceed'] = 'Наставите';
$string['profile'] = 'Профил';
$string['profilenotshown'] = 'Овај опис корисничког профила неће бити приказан све док се корисник не упише барем на један курс.';
$string['progress'] = 'Напредак';
$string['publicprofile'] = 'Јавни профил';
$string['publicsitefileswarning'] = 'Напомена: Датотекама које су овде смештене сви могу приступити.';
$string['publicsitefileswarning2'] = 'Напомена: Датотекам које су овде смештене може да приступи свако ко зна (или погоди) URL. Из разлога безбедности, препоручује се брисање датотека резервне копије одмах након након завшетка њиховог рестаурирања.';
$string['publicsitefileswarning3'] = 'Напомена: Датотекама које су овде постављене може да приступи свако ко зна (или може да погоди) URL.<br /> Из разлога безбедности, датотеке резервне копије би требало да буду чуване само у зато предвиђеном директоријуму (backupdata).';
$string['question'] = 'Питање';
$string['questionsinthequestionbank'] = 'Питања у банци питања';
$string['queued'] = 'На чекању';
$string['quotausage'] = 'Тренутно користите {$a->used} од максимално дозвољених {$a->total}.';
$string['readinginfofrombackup'] = 'Учитавање информација из резервне копије';
$string['readme'] = 'Прочитај ме';
$string['recentactivity'] = 'Недавне активности';
$string['recentactivityreport'] = 'Потпуни извештај о недавним активностима...';
$string['recipientslist'] = 'Списак прималаца';
$string['recommended'] = 'Препоручено';
$string['recreatedcategory'] = 'Поновно креирана категорија {$a}';
$string['redirect'] = 'Преусмери';
$string['reducesections'] = 'Смањи број секција';
$string['refresh'] = 'Освежи';
$string['refreshingevents'] = 'Освежавање догађаја';
$string['registration'] = 'Moodle регистрација.';
$string['registrationcontact'] = 'Јавни контакт';
$string['registrationcontactno'] = 'Не, не желим да ме контактирају други људи';
$string['registrationcontactyes'] = 'Да, прикажите образац како би други Moodle корисници могли да ме контактирају';
$string['registrationemail'] = 'Обавештења путем е-поште';
$string['registrationinfo'] = '<p>Ова страна вам омогућава да региструјете свој Moodle сајт на moodle.org. Регистрација је бесплатна.
Главна корист регистрације је у томе што ћете бити додати на ограничену мејлинг листу за примање важних обавештења, као што су сигурносна упозорења и нова издања Moodlea.</p>
<p>Стандардно, ваши подаци ће се чувати као поверљиви, и никада неће бити продати или прослеђени неком другом. Једини разлог за прикупљање ових информација јесте подршка, као и помоћи у формирању статистичке слике о целокупној Moodle заједници.</p>
<p>Ако изаберете, можете дозволити да име вашег сајта, држава и URL адрса буду додати на јавну листу Moodle сајтова.</p>
<p>Све нове регистрације се ручно проверавају пре додавања на листу.
Кад се једном нађете на листи, можете ажурирати своју регистрацију (и своје податке на јавној листи) у било ком тренутку, тако што ћете поново послати овај образац.</p>';
$string['registrationinfotitle'] = 'Информацијe о регистрацији';
$string['registrationsend'] = 'Слање регистрационих информација на moodle.org';
$string['registrationyes'] = 'Да, обавестите ме о новим Moodle издањима, безбедносним упозорењима и другим важним вестима';
$string['reject'] = 'Одбаци';
$string['rejectdots'] = 'Одбаци';
$string['relativedatesmode'] = 'Режим релативних датума';
$string['relativedatesmode_help'] = 'Прикажи датуме курса или активности релативно у односу на датум почетка корисниковог учешћа у курсу.

Тај датум ће бити датум почетка уписа корисника, уколико није уписан пре него што је курс почео, у ком случају ће се за његов датум почетка узети датум почетка курса.

УПОЗОРЕЊЕ: Ово је експериментално подешавање и могуће је да га још не подржавају све активности. Једном када се креира курс ово подешавање курса више не може да се мења.';
$string['relativedatesmode_warning'] = '<strong>Упозорење:</strong> Режим релативних датума не може да се промени након креирања курса.';
$string['reload'] = 'Учитај поново';
$string['remoteappuser'] = 'Удаљени корисник {$a}';
$string['remove'] = 'Уклони';
$string['removeadmin'] = 'Уклони администратора';
$string['removecreator'] = 'Уклони креатора курса';
$string['removestudent'] = 'removestudent';
$string['removeteacher'] = 'Уклони предавача';
$string['rename'] = 'Преименуј';
$string['renamefileto'] = 'Преименуј<b>{$a}</b> у';
$string['report'] = 'Извештај';
$string['reports'] = 'Извештаји';
$string['reporttype'] = 'Тип извештаја';
$string['repositories'] = 'Репозиторијум';
$string['requestcourse'] = 'Захтевај курс';
$string['requestedby'] = 'Захтеван од стране';
$string['requestedcourses'] = 'Захтевани курсеви';
$string['requestreason'] = 'Разлог за покретање новог курса';
$string['requests'] = 'Захтеви';
$string['required'] = 'Обавезно';
$string['requirespayment'] = 'Овај курс захтева плаћање за приступ';
$string['resendemail'] = 'Пошаљи поново е-поруку за потврду';
$string['reset'] = 'Ресетовање';
$string['resetcomponent'] = 'Компонента';
$string['resetcourse'] = 'Ресетовање курса';
$string['resetcourseconfirm'] = 'Ресетујте курс?';
$string['resetcoursewarning'] = 'Да ли сте сигурни да желите да ресетујете курс \'{$a}\'?
<br/><br/>
Ово ће обрисати изабране податке и вратити курс у првобитно стање. Ову радњу не можете опозвати.';
$string['resetinfo'] = 'Ова функција вам омогућава да обришете све корисничке податке и вратите курс у првобитно стање. Активности и подешавања курса ће остати нетакнути.';
$string['resetinfoselect'] = 'Изаберите податке које желите да избришете или ресетујете из категорија у наставку:';
$string['resetnotimplemented'] = 'Ресетовање није подржано';
$string['resetnotimplementedinfo'] = 'Ове активности се не могу ресетовати:';
$string['resetrecordexpired'] = 'Линк за промену лозинке који сте користи је истекао јер је старији од {$a} минута. Молимо вас да поново покренете захтев за промену лозинку.';
$string['resetstartdate'] = 'Ресетуј датума почетка';
$string['resetstatus'] = 'Статус';
$string['resettable'] = 'Ресетуј параметре табеле';
$string['resettask'] = 'Ресетуј';
$string['resettodefaults'] = 'Враћање на подразумеване вредности';
$string['resortcourses'] = 'Сортирај курсеве';
$string['resortsubcategoriesby'] = 'Сортирај поткатегорије растућим редоследом користећи као критеријум {$a}';
$string['resortsubcategoriesbyreverse'] = 'Сортирај поткатегорије опадајућим редоследом користећи као критеријум {$a}';
$string['resource'] = 'Ресурс';
$string['resource_type'] = 'Тип ресурса';
$string['resourcedisplayauto'] = 'Аутоматски';
$string['resourcedisplaydownload'] = 'Обавезно преузимање';
$string['resourcedisplayembed'] = 'Угради (Embed)';
$string['resourcedisplayframe'] = 'У оквиру (frame)';
$string['resourcedisplaynew'] = 'Нови прозор';
$string['resourcedisplayopen'] = 'Отвори';
$string['resourcedisplaypopup'] = 'У искачућем прозору';
$string['resources'] = 'Ресурси';
$string['resources_help'] = 'Ресурси омогућавају додавање било које врсте веб садржаја на Ваш курс.';
$string['restore'] = 'Рестаурирање резервнe копијe';
$string['restorecancelled'] = 'Рестаурирање је отказано';
$string['restorecannotassignroles'] = 'Процедура обнављања резервне копије података мора да додели улоге, а Ви немате овлашћење за то';
$string['restorecannotcreateorassignroles'] = 'Процедура обнављања резервне копије података мора да креира или додели улоге, а Ви немате овлашћење за то';
$string['restorecannotcreateuser'] = 'Процедура обнављања резервне копије података мора да креира корисника \'{$a}\', а Ви немате овлашћење за то';
$string['restorecannotoverrideperms'] = 'Процедура обнављања резервне копије података мора да измени овлашћења, а Ви немате овлашћење за то';
$string['restorecoursenow'] = 'Рестаурирајте овај курс сада!';
$string['restoredaccount'] = 'Обновљени кориснички налог';
$string['restoredaccountinfo'] = 'Овај кориснички налог је увезен са другог сервера и лозинка је изгубљена. Како бисте задали нову лозинку помоћу е-поште, кликните на "Настави".';
$string['restorefinished'] = 'Рестаурирање је успешно завршено';
$string['restoreinfo'] = 'Употребите датотеку резервне копије како бисте рестаурирали претходну верзију курса или како бисте креирали нови курс.';
$string['restoremnethostidmismatch'] = 'Идентификатор корисника \'{$a}\' на MNet домаћину се не слаже са идентификатором на локалном MNet домаћину.';
$string['restoreto'] = 'Рестаурирај у';
$string['restoretositeadding'] = 'Упозорење! Желите да рестаурирате резервну копију на насловну страницу сајта, тако што ћете постојећем придодати нови садржај!';
$string['restoretositedeleting'] = 'Упозорење! Желите да рестаурирате резервну копију на насловну страницу сајта, тако што ћете прво обрисати постојећи садржај са ње!';
$string['restoreuserconflict'] = 'Покушај рестаурирања корисника \'{$a}\' из рзервене копије података ће проузроковати конфликт';
$string['restoreuserinfofailed'] = 'Процес рестаурирања података је заустављен јер немате овлашћења за рестаурирање корисничких података.';
$string['restoreusersprecheck'] = 'Провера корисничких података';
$string['restoreusersprecheckerror'] = 'Уочени су одређени проблеми приликом провере корисничких података';
$string['restricted'] = 'Ограничено';
$string['resultsfound'] = 'Пронађено резултата: {$a}';
$string['retry'] = 'Покушај поново';
$string['returningtosite'] = 'Већ поседујете кориснички налог?';
$string['returntooriginaluser'] = 'Врати се на {$a}';
$string['revert'] = 'Вратите се назад';
$string['role'] = 'Улога';
$string['roleassignments'] = 'Додела улоге';
$string['rolemappings'] = 'Мапирања улога';
$string['rolerenaming'] = 'Преименовање улоге';
$string['rolerenaming_help'] = 'Промените приказ назива улога које се користе на овом курсу.';
$string['rolerenaming_success'] = 'Називи улога на курсу ажурирани.';
$string['roles'] = 'Улоге';
$string['rss'] = 'RSS';
$string['rssarticles'] = 'Број нових RSS чланака';
$string['rsserror'] = 'Грешка приликом читања RSS података';
$string['rsserrorauth'] = 'RSS линк не садржи исправан токен за проверу идентитета.';
$string['rsserrorguest'] = 'Овај RSS извор вести користи анонимни  (као гост) приступ подацима, али гости овде немају овлашћење за  читање података. Посетите изворну локацију са које овај извор вести долази (URL) као регистровани корисник и преузмите одатле нови RSS линк.';
$string['rsskeyshelp'] = '<p>Да би се обезбедила сигурност и приватност, URL адреса RSS извора садржи специјални токен који идентификује корисника за кога је токен креиран. Ово ће спречити друге кориснике да приступе оним деловима сајта који им нису дозвољени</p><p>Токен се аутоматски креира када први пут приступате делу сајта који производи RSS извор. Ако мислите да је је ваш токен RSS извора компромитован можете затражити нови токен тако што ћете овде кликнути на линк \'Ресетуј\'. Молимо вас, имајте у виду да ће тренутна URL адреса RSS извора постати неважећа.</p>';
$string['rsstype'] = 'RSS сервис за ову активност';
$string['save'] = 'Сачувај';
$string['saveandnext'] = 'Сачувај и прикажи следеће';
$string['savechanges'] = 'Сачувај промене';
$string['savechangesanddisplay'] = 'Сачувај и прикажи';
$string['savechangesandreturn'] = 'Сачувај и врати се';
$string['savechangesandreturntocourse'] = 'Сачувај и врати се на курс';
$string['savecomment'] = 'Сачувај коментар';
$string['savedat'] = 'Сачувано у:';
$string['savepreferences'] = 'Сачувај параметре';
$string['saveto'] = 'Сачувај у';
$string['scale'] = 'Скала за оцењивање';
$string['scale_help'] = 'Скала пружа начин за евалуацију или оцењивања постигнућа у активности. Дефинисана је као уређена листа вредности, у распону од негативних до позитивних, одвојених зарезима. На пример: "Разочаравајуће, Недовољно добро, Просечно, Добро, Врло добро, Одлично!"';
$string['scale_link'] = 'grade/scale';
$string['scales'] = 'Скале за оцењивање';
$string['scalescustom'] = 'Прилагођене скале за оцењивање';
$string['scalescustomcreate'] = 'Додај нову скалу за оцењивање';
$string['scalescustomno'] = 'Прилагођене скале за оцењивање још увек нису креиране';
$string['scalesstandard'] = 'Стандардне скале за оцењивање';
$string['scalestandard'] = 'Стандардна скала';
$string['scalestandard_help'] = 'Стандардна скала је доступна на нивоу целог сајта, за све курсеве.';
$string['scalestandard_link'] = 'grade/scale';
$string['scalestip'] = 'Како бисте креирали сопствене, прилагођене скале за оцењивање, употребите линк \'Скале...\' у менију за администрацију курса.';
$string['scalestip2'] = 'Да би сте креирали прилагођене скале, кликните на линк Оцене у административном менију курса, а онда изаберите Уреди Скале';
$string['schedule'] = 'Распоред';
$string['screenshot'] = 'Снимак екрана';
$string['search'] = 'Претрага';
$string['search_help'] = 'За основно претраживање једне или више речи било где у тексту, само их упишите одвојене размацима. Могу се претраживати све речи дуже од 2 знака.

За напредно претраживање, кликните на дугме за претрагу без уписивања појмова у поље за претрагу, како бисте приступили обрасцу за напредно претраживање.';
$string['searchactivities'] = 'Потражи активности по називу или опису';
$string['searchagain'] = 'Поновна претрага';
$string['searchbyemail'] = 'Претражите према адреси е-поште';
$string['searchbyusername'] = 'Претражите по корисничком имену';
$string['searchcoursecategories'] = 'Претражи категорије';
$string['searchcourses'] = 'Претражи курсеве';
$string['searchgroups'] = 'Претражите групе';
$string['searchitems'] = 'Претражите ставке';
$string['searchoptions'] = 'Опције за претрагу';
$string['searchresults'] = 'Резултати претраге';
$string['searchusers'] = 'Претражите кориснике';
$string['sec'] = 'сек';
$string['seconds'] = 'секунд/е';
$string['secondsleft'] = '{$a} секунди';
$string['secondstotime172800'] = '2 дана';
$string['secondstotime259200'] = '3 дана';
$string['secondstotime345600'] = '4 дана';
$string['secondstotime432000'] = '5 дана';
$string['secondstotime518400'] = '6 дана';
$string['secondstotime604800'] = '1 седмица';
$string['secondstotime86400'] = '1 дан';
$string['secretalreadyused'] = 'Линк за потврду промене лозинке је већ кориштен. Лозинка није промењена.';
$string['secs'] = 's';
$string['section'] = 'Секција';
$string['sectionactionnotsupported'] = 'Акција са секцијом  "{$a}" није подржана овде';
$string['sectionname'] = 'Назив секције';
$string['sectionoutline'] = 'Преглед секција';
$string['sections'] = 'Секције';
$string['seealsostats'] = 'Погледајте и статистику';
$string['selctauser'] = 'Изабери корисника';
$string['select'] = 'Изабери';
$string['selectacategory'] = 'Молимо вас да изаберете категорију';
$string['selectacountry'] = 'Изабери државу';
$string['selectacourse'] = 'Изабери курс';
$string['selectacoursesite'] = 'Изабери курс  или сајт';
$string['selectagroup'] = 'Изабери групу';
$string['selectall'] = 'Изабери све';
$string['selectallusersonpage'] = 'Изабери све кориснике на овој страници';
$string['selectalluserswithcount'] = 'Изабери свих {$a} корисника';
$string['selectamodule'] = 'Молимо изаберите модул активности';
$string['selectanaction'] = 'Изабери акцију';
$string['selectanoptions'] = 'Изабери опцију';
$string['selectaregion'] = 'Изабери регион';
$string['selectcategorysort'] = 'Које категорије желите да сортирате?';
$string['selectcategorysortby'] = 'Изаберите како желите да сортирате категорије';
$string['selectcoursesortby'] = 'Изаберите како желите да сортирате курсеве';
$string['selectdates'] = 'Изаберите датуме';
$string['selectdefault'] = 'Изабери подразумевано';
$string['selectedcategories'] = 'Изабране категорије';
$string['selectedfile'] = 'Изабрана датотека';
$string['selectednowmove'] = '{$a} датотека означено за премештање. Сада идите на место где желите да преместите датотеке и кликните на \'Премести датотеке овде\'';
$string['selectfiles'] = 'Изабери датотеке';
$string['selectfiltertype'] = 'Изабери';
$string['selectgroupsseparate'] = 'Изабери одвојене групе';
$string['selectgroupsvisible'] = 'Изабери видљиве групе';
$string['selectitem'] = 'Одабери \'{$a}\'';
$string['selectmoduletoviewhelp'] = 'Изаберите активност или ресурс како бисте видели помоћне информације о њима.

Да бисте брзо додали активност или ресурс кликните два пута на назив одговарајуће активности односно ресурса.';
$string['selectnos'] = 'Изаберите \'Не\' за све';
$string['selectperiod'] = 'Изабери период';
$string['selecttheme'] = 'Изаберите тему';
$string['selectthemename'] = 'Изаберите тему \'{$a}\'';
$string['senddetails'] = 'Пошаљи моје личне податке е-поштом';
$string['sent'] = 'Послато';
$string['separate'] = 'Одвоји';
$string['separateandconnected'] = 'Одвојени и повезани начини сазнавања';
$string['separateandconnected1'] = 'Углавном одвојено знање';
$string['separateandconnected2'] = 'Одвојено и повезано';
$string['separateandconnected3'] = 'Углавном повезано знање';
$string['separateandconnectedinfo'] = 'Ова скала се заснива на теорији одвојеног и повезаног сазнавања. Ова теорија описује два различита начина на које можемо да учимо о стварима које видимо и чујемо. <ul> <li><strong>Одвојени начин учења</strong> - полазници остају објективни што је више могуће без укључивања осећања. У дискусији са другим људима, они воле да бране своје идеје и ставове, користећи логику како би пронашли недостатке у идејама својих опонената.</li> <li><strong>Повезани начин учења</strong> - полазници су више осетљиви на друге људе. Они имају развијену способност емпатије и показују тенденцију да слушају и постављају питања док не осете да могу "разумети ствари из угла гледања својих саговорника". Они уче тако што покушавају да деле искуства која воде знању које проналазе код других људи.</li></ul>';
$string['servererror'] = 'Дошло је до грешке у току комуникације са сервером';
$string['serverlocaltime'] = 'Локално време сервера';
$string['sessionforceclean'] = 'Из разлога безбедности, као мера опреза, кориснички генерисане скрипте су онемогућене у овој сесији.';
$string['sessiontimeoutsoon'] = 'Ваша сесија ће ускоро истећи. Да ли желите да продужите текућу сесију?';
$string['setcategorytheme'] = 'Подеси графичку тему категорије';
$string['setmode'] = 'Подесите режим рада';
$string['setpassword'] = 'Подеси лозинку';
$string['setpasswordinstructions'] = 'Молимо вас, унесите своју нову лозинку и потом сачувајте промене.';
$string['settings'] = 'Подешавања';
$string['share'] = 'Поделите';
$string['shortname'] = 'Скраћени назив';
$string['shortnamecollisionwarning'] = '[*] = Овај скраћени назив већ користи неки други курс, те ће морати бити промењен по одобравању';
$string['shortnamecourse'] = 'Скраћени назив курса';
$string['shortnamecourse_help'] = 'Скраћени назив курса се појављује на оним местима где је простор ограничен (нпр. у навигацији курса или као део наслова електронске поруке). Скраћени назив курса мора бити јединствен.';
$string['shortnametaken'] = 'Скраћени назив се већ користи за неки други курс ({$a})';
$string['shortnameuser'] = 'Скраћено име корисника';
$string['shortsitename'] = 'Скраћени назив за сајт (нпр. једна реч)';
$string['show'] = 'Прикажи';
$string['showactions'] = 'Прикажи акције';
$string['showactivitydates'] = 'Прикажи датуме активности';
$string['showactivitydates_help'] = 'Прикажите датуме активности на страници курса.';
$string['showadvancededitor'] = 'Напредно';
$string['showadvancedsettings'] = 'Прикажи напредна подешавања';
$string['showall'] = 'Прикажи све {$a}';
$string['showallcourses'] = 'Прикажи све курсеве';
$string['showblockcourse'] = 'Прикажи списак курсева који садрже блокове';
$string['showcategory'] = 'Прикажи {$a}';
$string['showchartdata'] = 'Прикажи податке графикона';
$string['showcomments'] = 'Прикажи/сакриј коментаре';
$string['showcommentsnonjs'] = 'Прикажи коментаре';
$string['showdescription'] = 'Прикажи опис на страници курса';
$string['showdescription_help'] = 'Ако је ово подешавање омогућено, горњи опис биће приказан на страници курса одмах испод линка активности или ресурса.';
$string['showgrades'] = 'Прикажи оцене полазницима';
$string['showgrades_help'] = 'Дозволите полазницима да могу да види списак свих својих оцена на курсу.';
$string['showingacourses'] = 'Приказ свих {$a} курс(ев)а';
$string['showingxofycourses'] = 'Приказ курсева {$a->start} до {$a->end} од укупно {$a->total} курс(ев)а';
$string['showless'] = 'Прикажи мање';
$string['showlistofcourses'] = 'Прикажи списак курсева';
$string['showmodulecourse'] = 'Прикажи списка курсева који садрже активности';
$string['showmore'] = 'Прикажи више';
$string['showoncoursepage'] = 'Прикажи на страници курса';
$string['showonly'] = 'Прикажи само';
$string['showperpage'] = 'Прикажи {$a} по страници';
$string['showpopoverwindow'] = 'Прикажи искачући прозор са додатним информацијама';
$string['showrecent'] = 'Прикажи недавне активности';
$string['showreports'] = 'Прикажи извештај о активностима';
$string['showreports_help'] = 'Дозволите полазницима да виде сопствене извештаје о активностима преко њихове странице профила.';
$string['showsettings'] = 'Прикажи подешавања';
$string['showtheselogs'] = 'Прикажи ове записе о активностима';
$string['showthishelpinlanguage'] = 'Прикажи ову помоћ на језику: {$a}';
$string['sidepanel'] = 'Бочни панел';
$string['signoutofotherservices'] = 'Одјавите се са свих веб апликација';
$string['signoutofotherservices_help'] = 'Одјавите се са свих уређаја и система који користе веб сервисе, као што је мобилна апликација. Сесије веб читача ће остати активне.';
$string['since'] = 'Од';
$string['sincelast'] = 'од последњег приступа систему';
$string['site'] = 'Сајт';
$string['sitedefault'] = 'Подразумевано за сајт';
$string['sitedefaultspecified'] = 'Подразумевано за сајт ({$a})';
$string['siteerrors'] = 'Грешке на сајту';
$string['sitefiles'] = 'Датотеке сајта';
$string['sitefilesused'] = 'Датотеке сајта коришћени у овом курсу';
$string['sitehome'] = 'Насловна страница сајта';
$string['sitelegacyfiles'] = 'Изворне датотеке сајта';
$string['sitelogs'] = 'Записи о активностима на сајту';
$string['sitenews'] = 'Обавештења сајта';
$string['sitepages'] = 'Странице сајта';
$string['sitepartlist'] = 'Немате одговарајуће дозволе за преглед списка учесника';
$string['sitepartlist0'] = 'Морате бити предавач сајта да би Вам било дозвољено да видите списак учесника сајта.';
$string['sitepartlist1'] = 'Морате бити предавач да би Вам било дозвољено да видите списак учесника сајта.';
$string['sites'] = 'Сајтови';
$string['sitesection'] = 'Додајте прилагођени садржај';
$string['sitesettings'] = 'Подешавања сајта';
$string['siteteachers'] = 'Предавачи сајта';
$string['size'] = 'Величина';
$string['sizeb'] = 'бајта';
$string['sizegb'] = 'Gb';
$string['sizekb'] = 'Kb';
$string['sizemb'] = 'MB';
$string['sizepb'] = 'PB';
$string['sizetb'] = 'TB';
$string['skipped'] = 'Прескочено';
$string['skiptocategorylisting'] = 'Пређи на списак категорија';
$string['skiptocoursedetails'] = 'Пређи на детаљне информације о курсу';
$string['skiptocourselisting'] = 'Пређи на списак курсева';
$string['someallowguest'] = 'Неки од курсева могу дозволити приступ гостима (анонимним корисницима)';
$string['someerrorswerefound'] = 'Поједине информације недостају или су нетачне. Погледајте детаље испод.';
$string['sort'] = 'Сортирај';
$string['sortby'] = 'Сортирај по';
$string['sortbyx'] = 'Сортирај растућим редоследом пo {$a}';
$string['sortbyxreverse'] = 'Сортирај опадајућим редоследом пo {$a}';
$string['sorting'] = 'Сортирање';
$string['sourcerole'] = 'Изворна улога';
$string['specifyname'] = 'Морате навести име.';
$string['standard'] = 'Стандардно';
$string['starpending'] = '([*] = курс чека на одобрење)';
$string['startdate'] = 'Датум почетка курса';
$string['startdate_help'] = 'Овај датим одређује почетак прве недеље за курс у седмичном формату. То је такође датум почетка евидентирања активности на курсу.

Ако ресетујете курс и промените овај датум, сви датуми на курсу ће бити померени у складу са новим датумом полетка.';
$string['startdatewithtaskenabled'] = 'Датум почетка курса';
$string['startdatewithtaskenabled_help'] = 'Датум када курс постаје видљив за студенте. Пре овога датума, они неће моћи да приступе курсу.

Овај датум такође одређује почетак прве седмице за курс у седмичном формату и представља датум почетка за записивање активности курса. Ако ресетујете курс и промените овај датум, сви датуми на курсу ће бити померени у односу на нови датум почетка.';
$string['startingfrom'] = 'Почиње';
$string['startsignup'] = 'Креирај нови налог';
$string['state'] = 'Држава/Република';
$string['statistics'] = 'Статистика';
$string['statisticsgraph'] = 'Статистички графикон';
$string['stats'] = 'Статистика';
$string['statslogins'] = 'Приступи систему';
$string['statsmodedetailed'] = 'Детаљни (кориснички) приказ';
$string['statsmodegeneral'] = 'Општи приказ';
$string['statsnodata'] = 'Нема доступних података за ту комбинацију курса и временског периода.';
$string['statsnodatauser'] = 'Нема доступних података за ту комбинацију курса, корисника и временског периода.';
$string['statsoff'] = 'Статистика тренутно није омогућено';
$string['statsreads'] = 'Прегледи';
$string['statsreport1'] = 'Приступи систему';
$string['statsreport10'] = 'Активност корисника';
$string['statsreport11'] = 'Најактивнији курсеви';
$string['statsreport12'] = 'Најактивнији курсеви (пондерисано)';
$string['statsreport13'] = 'Курсеви са највише учешћа (уписи)';
$string['statsreport14'] = 'Курсеви са највише учешћа (постови/прегледи)';
$string['statsreport2'] = 'Прикази (све улоге)';
$string['statsreport3'] = 'Поруке (све улоге)';
$string['statsreport4'] = 'Укупна активност (све улоге)';
$string['statsreport5'] = 'Укупна активност (прикази и поруке)';
$string['statsreport7'] = 'Активност корисника (прикази и поруке)';
$string['statsreport8'] = 'Све активности корисника';
$string['statsreport9'] = 'Приступи (сајту/курсу)';
$string['statsreportactivity'] = 'Укупна активност (све улоге)';
$string['statsreportactivitybyrole'] = 'Укупна активност (прегледи и поруке)';
$string['statsreportforuser'] = 'за';
$string['statsreportlogins'] = 'Приступи систему';
$string['statsreportreads'] = 'Прикази (све улоге)';
$string['statsreporttype'] = 'Тип извештаја';
$string['statsreportwrites'] = 'Поруке (све улоге)';
$string['statsstudentactivity'] = 'Активност полазника';
$string['statsstudentreads'] = 'Прегледи полазника';
$string['statsstudentwrites'] = 'Објаве полазника';
$string['statsteacheractivity'] = 'Активност предавача';
$string['statsteacherreads'] = 'Прикази предавача';
$string['statsteacherwrites'] = 'Поруке предавача';
$string['statstimeperiod'] = 'Временски период - трајање:';
$string['statsuniquelogins'] = 'Различити приступи систему';
$string['statsuseractivity'] = 'Све активности';
$string['statsuserlogins'] = 'Приступи систему';
$string['statsuserreads'] = 'Прикази';
$string['statsuserwrites'] = 'Поруке';
$string['statswrites'] = 'Поруке';
$string['status'] = 'Статус';
$string['statuschecks'] = 'Провере статуса';
$string['statuscritical'] = 'Критично';
$string['statusdone'] = 'Готово';
$string['statuserror'] = 'Грешка';
$string['statusinfo'] = 'Инфо';
$string['statusna'] = 'N/A';
$string['statusok'] = 'OK';
$string['statusunknown'] = 'Непознато';
$string['statuswarning'] = 'Упозорење';
$string['stringsnotset'] = 'Следећи изрази нису дефинисани у {$a}';
$string['studentnotallowed'] = 'Нажалост, не можете приступити овом курсу као \'{$a}\'';
$string['students'] = 'Полазници';
$string['studentsandteachers'] = 'Полазници и предавачи';
$string['subcategories'] = 'Поткатегорије';
$string['subcategory'] = 'Поткатегорија';
$string['subcategoryof'] = 'Поткатегорија од {$a}';
$string['subject'] = 'Тема';
$string['submit'] = 'Предај';
$string['subsectionmoveerror'] = 'Није могуће преместити ову подсекцију у другу подсекцију';
$string['success'] = 'Успешно';
$string['successduration'] = 'Успешно ({$a} сек.)';
$string['summary'] = 'Резиме';
$string['suspended'] = 'Суспендован';
$string['suspendedusers'] = 'Суспендовани корисници';
$string['switchdevicedefault'] = 'Прелазак на стандардну графичку тему';
$string['switchdevicerecommended'] = 'Прелазак на препоручену графичку тему за ваш уређај';
$string['switchrolereturn'] = 'Повратак на моју уобичајену улогу';
$string['switchroleto'] = 'Промени улогу у...';
$string['switchroleto_help'] = 'Изаберите улогу како бисте видели како корисник са том улогом види овај курс.

Имајте у виду да приказ курса са другом улогом није савршен (<a href="https://docs.moodle.org/en/Switch_roles">Погледајте више информације</a>)';
$string['tag'] = 'Ознака';
$string['tagalready'] = 'Ознака већ постоји';
$string['tagmanagement'] = 'Додај/обриши ознаке...';
$string['tags'] = 'Ознаке';
$string['targetrole'] = 'Циљна улога';
$string['teacheronly'] = 'само за {$a}';
$string['teacherroles'] = '{$a} улоге';
$string['teachers'] = 'Предавачи';
$string['textcopiedtoclipboard'] = 'Текст је копиран у клипборд';
$string['textediting'] = 'Едитор текста';
$string['textediting_help'] = 'Ако је изабран HTML едитор (нпр. Atto или TinyMCE) поља за унос текста ће садржати траку са алатима помоћу којих ће се садржај лако додавати притиском на одговарајућу дугмад.

Ако је изабрана опција \'обичан текст\' може се бирати формат за унос текста као што је HTML или Markdown.

Списак расположивих едитора за уређивање текста одређује администратор сајта.';
$string['texteditor'] = 'Користити стандардне веб обрасце';
$string['textellipsis'] = '{$a}...';
$string['textformat'] = 'Обичан текстуални формат';
$string['thanks'] = 'Хвала';
$string['theme'] = 'Графичка тема';
$string['themepreviewdescription'] = 'Опис теме {$a}';
$string['themepreviewimage'] = 'Слика за преглед теме {$a}';
$string['themes'] = 'Графичке теме';
$string['themesaved'] = 'Нова графичка тема је сачувана';
$string['therearecourses'] = 'Постоји {$a} курс/а/ева';
$string['thereareno'] = 'Не постоје {$a} у овом курс';
$string['thiscategory'] = 'Ова категорија';
$string['thiscategorycontains'] = 'Ова категорија садржи';
$string['time'] = 'Време';
$string['timecreated'] = 'Време креирања';
$string['timecreatedcourse'] = 'Време креирања курса';
$string['timesplitting:deciles'] = 'Последња десетина';
$string['timesplitting:deciles_help'] = 'Овај интервал анализе дели курс на десетине (10 једнаких делова), при чему се свако предвиђање заснива само на подацима најновије претходне десетине.';
$string['timesplitting:decilesaccum'] = 'Све претходне десетине';
$string['timesplitting:decilesaccum_help'] = 'Овај интервал анализе дели курс на десетине (10 једнаких делова), при чему се свако предвиђање заснива на подацима свих претходних десетина.';
$string['timesplitting:nosplitting'] = 'Без временских ограничења';
$string['timesplitting:nosplitting_help'] = 'За овај модел није дефинисан интервал анализе.';
$string['timesplitting:onemonthafterstart'] = 'Месец дана након почетка';
$string['timesplitting:onemonthafterstart_help'] = 'Овај интервал анализе генерише предвиђање месец дана након почетка који се може анализирати.';
$string['timesplitting:oneweekafterstart'] = 'Недељу дана након почетка';
$string['timesplitting:oneweekafterstart_help'] = 'Овај интервал анализе генерише предвиђање недељу дана након почетка који се може анализирати.';
$string['timesplitting:past3days'] = 'Прошла 3 дана';
$string['timesplitting:past3days_help'] = 'Овај интервал анализе генерише предвиђања свака 3 дана. Израчунавања индикатора биће заснована протекла 3 дана.';
$string['timesplitting:pastmonth'] = 'Прошлог месеца';
$string['timesplitting:pastmonth_help'] = 'Овај интервал анализе генерише предвиђања сваког месеца. Израчунавања индикатора биће заснована на протеклих месец дана.';
$string['timesplitting:pastweek'] = 'Прошле недеље';
$string['timesplitting:pastweek_help'] = 'Овај интервал анализе генерише предвиђања сваке недеље. Израчунавања индикатора биће заснована на протеклој седмици.';
$string['timesplitting:quarters'] = 'Последње тромесечје';
$string['timesplitting:quarters_help'] = 'Овај интервал анализе дели курс на тромесечја (4 једнака дела), при чему се свако предвиђање заснива само на подацима најновијег претходног тромесечја.';
$string['timesplitting:quartersaccum'] = 'Тромесечја кумулативно';
$string['timesplitting:quartersaccum_help'] = 'Овај интервал анализе дели курс на тромесечја (4 једнака дела), при чему се свако предвиђање заснива на подацима свих претходних тромесечја.';
$string['timesplitting:singlerange'] = 'Од почетка до краја';
$string['timesplitting:singlerange_help'] = 'Овај интервал анализе посматра цео курс као јединствену целину.';
$string['timesplitting:tenpercentafterstart'] = '10% након почетка';
$string['timesplitting:tenpercentafterstart_help'] = 'Овај интервал анализе генерише предвиђање након завршетка 10% курса.';
$string['timesplitting:upcoming3days'] = 'Наредна 3 дана';
$string['timesplitting:upcoming3days_help'] = 'Овај интервал анализе генерише предвиђања свака 3 дана. Израчунавања индикатора биће заснована наредна 3 дана.';
$string['timesplitting:upcomingfortnight'] = 'Наредне 2 седмице';
$string['timesplitting:upcomingfortnight_help'] = 'Овај интервал анализе генерише предвиђања сваке две недеље. Израчунавања индикатора биће заснована на предстојећих петнаест дана.';
$string['timesplitting:upcomingweek'] = 'Наредна седмица';
$string['timesplitting:upcomingweek_help'] = 'Овај интервал анализе генерише предвиђања сваке недељњ. Израчунавања индикатора биће заснована на наредној седмици.';
$string['timezone'] = 'Временска зона';
$string['tocontent'] = 'Одредишна ставка "{$a}"';
$string['tocreatenewaccount'] = 'Прескочи за креирање новог корисничког налога';
$string['todate'] = 'До';
$string['today'] = 'Данас';
$string['todaylogs'] = 'Данашњи записи о активностима';
$string['toeveryone'] = 'свима';
$string['toggleemojipicker'] = 'Укључи/искључи бирач емоџија';
$string['togglesearch'] = 'Укључи/искључи поље за претрагу';
$string['toomanybounces'] = 'Са ове електронске адресе вратило се превише порука. <b>Морате</b> је променити да бисте наставили.';
$string['toomanytags'] = 'Ова претрага је садржала превише ознака; неке ће бити игнорисане.';
$string['toomanytoshow'] = 'Превише корисника за приказ';
$string['toomanyusersmatchsearch'] = 'Превише корисника ({$a->count}) се поклапа са\'{$a->search}\'';
$string['toomanyuserstoshow'] = 'Превише корисника за приказ ({$a}) to show';
$string['toonly'] = 'само за {$a}';
$string['top'] = 'Врх';
$string['topic'] = 'Тема';
$string['toplevelcategory'] = 'Категорија највишег нивоа';
$string['torecipient'] = 'До';
$string['total'] = 'Укупно';
$string['totopofsection'] = 'На почетак секције "{$a}"';
$string['trackforums'] = 'Праћење форума';
$string['trackforumsno'] = 'НЕ: не бележи информације о томе које сам поруке претходно прочитао/ла';
$string['trackforumsyes'] = 'ДА: истакни нове поруке';
$string['trysearching'] = 'Покушајте са претраживањем.';
$string['turneditingoff'] = 'Искључи уређивање';
$string['turneditingon'] = 'Укључи уређивање';
$string['unabletocopytoclipboard'] = 'Није могуће копирати текст у клипборд';
$string['unauthorisedlogin'] = 'Кориснички налог "{$a}" није доступан на овом сајту';
$string['undecided'] = 'Неодлучни';
$string['unexistingcmid'] = 'ID ознака модула курса није пронађена';
$string['unexistingsectionid'] = 'ID ознака секције курса није пронађена';
$string['unfinished'] = 'Недовршено';
$string['unknowncategory'] = 'Непозната категорија';
$string['unknownerror'] = 'Непозната грешка';
$string['unknownuser'] = 'Непознати корисник';
$string['unlimited'] = 'Неограничено';
$string['unpacking'] = 'Распакује се {$a}';
$string['unsafepassword'] = 'Несигурна лозинка - пробајте нешто комплексније';
$string['untilcomplete'] = 'Док се не заврши';
$string['unusedaccounts'] = 'Кориснички налози који се не користе {$a} дана се аутоматски исписују';
$string['unzip'] = 'Распакуј';
$string['unzippingbackup'] = 'Распакује се резервна копија';
$string['up'] = 'Горе';
$string['update'] = 'Ажурирај';
$string['updated'] = 'Ажурирано {$a}';
$string['updatemymoodleoff'] = 'Престани са уређивањем ове странице';
$string['updatemymoodleon'] = 'Прилагоди ову страницу';
$string['updatemyprofile'] = 'Ажурирај профил';
$string['updatesevery'] = 'Ажурирање на сваких {$a} секунди';
$string['updatethis'] = 'Ажурирај {$a}';
$string['updatethiscourse'] = 'Ажурирај овај курс';
$string['upload'] = 'Постави';
$string['uploadafile'] = 'Постављање датотеке';
$string['uploadcantwrite'] = 'Неуспешно уписивање датотеке на диск';
$string['uploadedfile'] = 'Датотека је успешно постављена';
$string['uploadedfileto'] = 'Датотека {$a->file} је постављена у директоријум {$a->directory}';
$string['uploadedfiletoobig'] = 'Нажалост, наведена датотека је превелика (ограничење износи {$a} бајта)';
$string['uploadextension'] = 'Постављање датотеке прекинуто од стране PHP екстензије';
$string['uploadfailednotrecovering'] = 'Постављање Ваших датотека није успело јер је уочен проблем са једном од њих, {$a->name}.<br /> Овде је извештај о уоченим проблемима:<br />{$a->problem}<br />Нема опоравка.';
$string['uploadfilelog'] = 'Извештај о постављању датотеке {$a}';
$string['uploadformlimit'] = 'Постављена датотека {$a} је премашила ограничење за максималну величину одређену обрасцем';
$string['uploadlabel'] = 'Наслов:';
$string['uploadlimitwithsize'] = '{$a->contextname} - ограничење за постављање датотека ({$a->displaysize})';
$string['uploadnewfile'] = 'Постави нову датотеку';
$string['uploadnofilefound'] = 'Датотека није пронађена - јесте ли сигурни да сте изабрали датотеку за постављање?';
$string['uploadnotallowed'] = 'Постављање није дозвољено';
$string['uploadnotempdir'] = 'Недостаје привремени директоријум';
$string['uploadoldfilesdeleted'] = 'Старе датотеке у Вашем одељку за постављање су обрисане';
$string['uploadpartialfile'] = 'Постављање датотеке није извршено у потпуности';
$string['uploadproblem'] = 'Приликом постављања датотеке \'{$a}\' догодила се непозната грешка (можда је наведена датотека била превелика?)';
$string['uploadrenamedchars'] = 'Назив датотека је промењен из {$a->oldname} у {$a->newname} зато што је садржао недозвољене знакове.';
$string['uploadrenamedcollision'] = 'Назив датотека је промењен из {$a->oldname} у {$a->newname} зато што је дошло до конфликта са називом неке друге датотеке.';
$string['uploadserverlimit'] = 'Датотека која је постављена је већа од максималне величине дозовољене ограничењем овог сервера';
$string['uploadthisfile'] = 'Постави датотеку';
$string['url'] = 'URL';
$string['used'] = 'Коришћено';
$string['usedinnplaces'] = 'Користи се на {$a} места';
$string['user'] = 'Корисник';
$string['useraccount'] = 'Кориснички налог';
$string['useractivity'] = 'Активност';
$string['userconfirmed'] = 'Потврђен {$a}';
$string['userdata'] = 'Подаци о кориснику';
$string['userdeleted'] = 'Овај кориснички налог је обрисан';
$string['userdescription'] = 'Опис';
$string['userdescription_help'] = 'Овде можете унети податке о себи који ће бити приказани на страници вашег профила и које ће моћи да виде други корисници.';
$string['userdetails'] = 'Детаљи о кориснику';
$string['userfiles'] = 'Корисничке датотеке';
$string['userlist'] = 'Списак корисника';
$string['usermatchedon'] = 'Овај корисник одговара претрази на основу следећег поља';
$string['usermenu'] = 'Кориснички мени';
$string['usermenugoback'] = 'Врати се на кориснички мени';
$string['username'] = 'Корисничко име';
$string['usernameemail'] = 'Корисничко име или е-адреса';
$string['usernameemailmatch'] = 'Корисничко име и адреса е-поште се не односе на истог корисника';
$string['usernameexists'] = 'Наведено корисничко име већ постоји, изаберите неко друго';
$string['usernamelowercase'] = 'Дозвољена су само мала слова';
$string['usernamenotfound'] = 'Корисничко име није пронађено у бази података';
$string['usernameoremail'] = 'Унесите или корисничко име или адресу е-поште';
$string['usernotconfirmed'] = 'Није се могло потврдити {$a}';
$string['userpic'] = 'Слика корисника';
$string['userpreferences'] = 'Корисничка подешавања';
$string['users'] = 'Корисници';
$string['userselectorautoselectunique'] = 'Ако само један корисник одговара критеријумима претраге нека аутоматски буде изабран';
$string['userselectorpreserveselected'] = 'Задржи изабране кориснике, чак и ако се више не одговарају критеријумима претраге';
$string['userselectorsearchanywhere'] = 'било где';
$string['userselectorsearchexactmatchonly'] = 'само потпуна поклапања';
$string['userselectorsearchfromstart'] = 'од почетка';
$string['userselectorsearchmatching'] = 'Подударање:';
$string['usersnew'] = 'Нови корисници';
$string['usersnoaccesssince'] = 'Неактивни више од';
$string['userswithfiles'] = 'Корисници са датотекама';
$string['useruploadtype'] = 'Тип постављања корисника: {$a}';
$string['userzones'] = 'Корисничке зоне';
$string['usetheme'] = 'Употреби ову тему';
$string['usingexistingcourse'] = 'Користећи постојећи курс';
$string['validatehtml'] = 'Проверите HTML';
$string['valuealreadyused'] = 'Ова вредност је већ искоришћена';
$string['version'] = 'Верзија';
$string['view'] = 'Приказ';
$string['viewallcourses'] = 'Прикажи све курсеве';
$string['viewallcoursescategories'] = 'Прикажи све курсеве и категорије';
$string['viewallresults'] = 'Прикажи све резултате ({$a})';
$string['viewallsubcategories'] = 'Погледај све поткатегорије';
$string['viewfileinpopup'] = 'Погледај датотеку у искачућем прозору';
$string['viewing'] = 'Преглед:';
$string['viewmore'] = 'Погледај још';
$string['viewprofile'] = 'Прегледај профил';
$string['views'] = 'Прикази';
$string['viewsolution'] = 'види решење';
$string['visible'] = 'Видљиво';
$string['visible_help'] = 'Ово подешавање одређује да ли ће се курс појавити на попису курсева. За разлику од наставника и администратора, корисницима није дозвољен улазак на курс.';
$string['visibletostudents'] = 'Видљиво за {$a}';
$string['warning'] = 'Упозорење';
$string['warningdeleteresource'] = 'Упозорење: на {$a} се односи ресурс. Да ли желите да ажурирате тај ресурс?';
$string['wcagcheck'] = 'Провера смерница за приступачност веб садржаја (Web Content Accessibility Guidelines - WCAG).';
$string['webpage'] = 'Веб страница';
$string['week'] = 'Седмица';
$string['weeks'] = 'седмица/е';
$string['welcomeback'] = 'Здраво, {$a->firstname}! 👋';
$string['welcometocourse'] = 'Добро дошли на курс {$a}';
$string['welcometocoursetext'] = 'Добро дошли на курс {$a->coursename}!

Уколико то већ нисте урадили, требало би да уредити страницу свог профила, тако да можемо да сазнамо нешто више о вама:

<a href="{$a->profileurl}">{$a->profileurl}</a>';
$string['welcometosite'] = 'Добродошао/ла, {$a->firstname}! 👋';
$string['whatforlink'] = 'Шта желите да урадите са линком?';
$string['whatforpage'] = 'Шта желите да урадите са линком?';
$string['whatisyourage'] = 'Колико Вам је година?';
$string['whattocallzip'] = 'Како желите да назовете архивирану датотеку?';
$string['whattodo'] = 'Шта урадити';
$string['wheredoyoulive'] = 'У којој земљи живите?';
$string['whyisthisrequired'] = 'Зашто је ово неопходно?';
$string['windowclosing'] = 'Овај прозор би требало да се аутоматски затвори. Ако се то није догодило молим вас да га сада затворите.';
$string['withchosenfiles'] = 'Са изабраним датотекама';
$string['withdisablednote'] = '{$a} (онемогућено)';
$string['withoutuserdata'] = 'без корисничких података';
$string['withselectedusers'] = 'Са изабраним корисницима...';
$string['withuserdata'] = 'с корисничким подацима';
$string['wontrunfuturescheduledtask'] = 'Неће покренути задатак који није успео и који је планиран да се покрене у будућности';
$string['wordforstudent'] = 'Ваша реч за полазника';
$string['wordforstudenteg'] = 'нпр. полазник, учесник, кандидат и сл.';
$string['wordforstudents'] = 'Ваша реч за полазнике';
$string['wordforstudentseg'] = 'нпр. полазници, учесници, кандидати и сл.';
$string['wordforteacher'] = 'Ваша реч за предавача';
$string['wordforteachereg'] = 'нпр. предавач, професор, модератор и сл.';
$string['wordforteachers'] = 'Ваша реч за предаваче';
$string['wordforteacherseg'] = 'нпр. предавачи, професори, модератори и сл.';
$string['writingblogsinfo'] = 'Уписивање информација о блоговима';
$string['writingcategoriesandquestions'] = 'Записивање категорија и питања';
$string['writingcoursedata'] = 'Записивање података курса';
$string['writingeventsinfo'] = 'Записивање информација о догађајима';
$string['writinggeneralinfo'] = 'Записивање општих информација';
$string['writinggradebookinfo'] = 'Записивање информација о оценама';
$string['writinggroupingsgroupsinfo'] = 'Записивање информација о груписањима-групама';
$string['writinggroupingsinfo'] = 'Записивање информација о групацијама';
$string['writinggroupsinfo'] = 'Записивање информација о групама';
$string['writingheader'] = 'Записивање заглавља';
$string['writingloginfo'] = 'Записивање информација о записима о активностима';
$string['writingmessagesinfo'] = 'Записивање информација о порукама';
$string['writingmoduleinfo'] = 'Записивање информација о модулима';
$string['writingscalesinfo'] = 'Записивање информација о скалама оцењивања';
$string['writinguserinfo'] = 'Записивање информација о корисницима';
$string['wrongpassword'] = 'Погрешна лозинка за ово корисничко име';
$string['year'] = 'година';
$string['years'] = 'година';
$string['yes'] = 'Да';
$string['youareabouttocreatezip'] = 'Управо ћете започети креирање zip архиве која садржи';
$string['youaregoingtorestorefrom'] = 'Управо ћете започети рестаурациони процес за';
$string['youhaveupcomingactivitiesdue'] = 'Имате предстојеће активности које се ускоро завршавају';
$string['youhaveupcomingactivitiesdueinfo'] = 'Поштовани/а {$a},

<br/><br/>Имате предстојеће активности које се ускоро завршавају';
$string['youneedtoenrol'] = 'Да бисте извршили ову акцију морате се уписати на овај курс.';
$string['yourlastlogin'] = 'Ваш последњи приступ систему';
$string['yourself'] = 'себе';
$string['yourteacher'] = 'Ваш {$a}';
$string['yourwordforx'] = 'Ваша реч за \'{$a}\'';
$string['zippingbackup'] = 'Креира се архива са резервном копијом';
