<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'tool_oauth2', language 'sr_cr', version '5.0'.
 *
 * @package     tool_oauth2
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['acceptrisk'] = 'Разумем да онемогућавање путем е-поште може бити безбедносни проблем.';
$string['acceptrisk_help'] = 'Онемогућавање потврде е-поште потенцијално може омогућити кориснику да се аутентификује као други корисник.';
$string['authconfirm'] = 'Ова акција ће одобрити стални API приступ Moodleu за овлашћени налог. Намера је да се овај налог користи као системски за управљање датотекама које су у власништву Moodlea.';
$string['authconnected'] = 'Системски налог је сада повезан за офлајн приступ';
$string['authnotconnected'] = 'Системски налог није повезан за офлајн приступ';
$string['clever_service'] = 'Сервис \'Clever\'';
$string['configured'] = 'Конфигурисано';
$string['configuredstatus'] = 'Конфигурисано';
$string['connectsystemaccount'] = 'Успостави везу са системским налогом';
$string['createfromtemplate'] = 'Креирај OAuth 2 сервис на основу шаблона';
$string['createfromtemplatedesc'] = 'Изаберите, у наставку, један од шаблона OAuth 2 сервиса како бисте креирали OAuth сервис са исправном конфигурацијом за један од познатих типова сервиса. То ће креирати OAuth 2 сервис, са свим свим исправним крајњим  тачкама и параметрима потребним за проверу идентитета. Ипак, мораћете да унесете ID ознаку клијента и тајни кључ за нови сервис, пре него што он буде могао да се користи.';
$string['createnewendpoint'] = 'Креирај нову крајњу тачку за даваоца идентитета "{$a}"';
$string['createnewservice'] = 'Креирај нови сервис:';
$string['createnewuserfieldmapping'] = 'Креирај ново мапирање корисничког поља за даваоца идентитета "{$a}"';
$string['custom_service'] = 'Прилагођено';
$string['deleteconfirm'] = 'Да ли сте сигурни да желите да обришете даваоца идентитета "{$a}"? Сви додаци који су повезани са овим даваоцем престаће са радом.';
$string['deleteendpointconfirm'] = 'Да ли сте сигурни да желите да обришете крајњу тачку "{$a->endpoint}" за даваоца идентитета "{$a}"? Сви додаци који су повезани са овим даваоцем престаће са радом.';
$string['deleteuserfieldmappingconfirm'] = 'Да ли сте сигурни да желите да обришете мапирање корисничког поља за даваоца идентитета "{$a}"?';
$string['discovered'] = 'Сервис успешно пронађен';
$string['discovered_help'] = 'Проналажење сервиса значи да се крајње тачке OAuth 2 сервиса могу аутоматски одредите из основне URL адресе. Није неопходно да сви сервиси буду "пронађени", али ако нису, онда ће бити потребно да се крајње тачке и информације о мапирању корисника ручно унесу.';
$string['discoverystatus'] = 'Проналажење';
$string['editendpoint'] = 'Крајња тачка "{$a->endpoint}" за даваоца идентитета {$a->issuer}';
$string['editendpoints'] = 'Конфигуриши крајње тачке';
$string['editissuer'] = 'Уреди даваоца идентитета: {$a}';
$string['edituserfieldmapping'] = 'Уреди мапирање корисничког поља за даваоца идентитета {$a}';
$string['edituserfieldmappings'] = 'Конфигуриши мапирања корисничког поља';
$string['endpointdeleted'] = 'Крајња тачка обрисана';
$string['endpointname'] = 'Назив';
$string['endpointname_help'] = 'Кључ који се користи за претраживање ове крајње тачке. Мора да се завршава са "_endpoint".';
$string['endpointsforissuer'] = 'Крајње тачке за даваоца идентитета: {$a}';
$string['endpointurl'] = 'URL адреса';
$string['endpointurl_help'] = 'URL адреса за ову крајњу тачку. Мора да користи https:// protocol.';
$string['facebook_service'] = 'Facebook';
$string['google_service'] = 'Google';
$string['issueralloweddomains'] = 'Домени за пријаву';
$string['issueralloweddomains_help'] = 'Ако је постављено, ово подешавање је списак домена, раздвојених зарезом, на које ће бити ограничена пријава на систем када се користи овај давалац.';
$string['issueralloweddomains_link'] = 'OAuth_2_login_domains';
$string['issuerbaseurl'] = 'Основна URL адреса сервиса';
$string['issuerbaseurl_help'] = 'Основна URL адреса која се користи за приступ сервису';
$string['issuerclientid'] = 'ID ознака клијента';
$string['issuerclientid_help'] = 'ID ознака OAuth клијента за овог даваоца.';
$string['issuerclientsecret'] = 'Клијентски тајни кључ';
$string['issuerclientsecret_help'] = 'OAuth клијентски тајни кључ за овог даваоца.';
$string['issuerdeleted'] = 'Давалац идентитета обрисан';
$string['issuerdisabled'] = 'Давалац идентитета онемогућен';
$string['issuerenabled'] = 'Давалац идентитета омогућен';
$string['issuerimage'] = 'URL адреса логотипа';
$string['issuerimage_help'] = 'URL адреса слике која се користи као лого за овог даваоца идентитета. Може бити приказан на страници за пријављивљње на систем.';
$string['issuerloginpagename'] = 'Име приказано на страници за пријављивање';
$string['issuerloginpagename_help'] = 'Ако је наведено, ово име ће се користити на страници за пријављивање уместо назива сервиса.';
$string['issuerloginparams'] = 'Додатни параметри укључени у захтев за пријаву на систем';
$string['issuerloginparams_help'] = 'Неки системи траже да у захтев за пријаву на систем буду укључени додатни параметри како би прочитали основни профил корисника.';
$string['issuerloginparamsoffline'] = 'Додатни параметри укључени у захтев за пријаву на систем за офлајн приступ.';
$string['issuerloginparamsoffline_help'] = 'Сваки OAuth систем дефинише на другачији начин захтев за офлајн приступ. Нпр. Google захтева додатне параметре: "access_type=offline&prompt=consent". Ови параметри треба да буду у формату параметара URL упита.';
$string['issuerloginscopes'] = 'Додатни опсези важења укључени у захтев за пријаву на систем.';
$string['issuerloginscopes_help'] = 'Неки системи захтевају да у захтев за пријаву на систем буду укључени додатни опсези важења како би прочитали корисников основни профил. Стандардни опсези важења за OpenID Connect компатибилни систем су "openid profile email".';
$string['issuerloginscopesoffline'] = 'Додатни опсези важења укључени у захтев за пријаву на систем за офлајн приступ.';
$string['issuerloginscopesoffline_help'] = 'Сваки OAuth систем дефинише на другачији начин захтев за офлајн приступ. Нпр. Microsoft захтева додатни опсег важења "offline_access".';
$string['issuername'] = 'Назив';
$string['issuername_help'] = 'Назив даваоца идентитета. Може бити приказан на страници за пријављивљње на систем.';
$string['issuerrequireconfirmation'] = 'Захтевај потврду е-поште';
$string['issuerrequireconfirmation_help'] = 'Захтевајте да сви корисници потврде своје адресе е-поште пре него што се могу пријавити помоћу OAuth система. Ово се односи на новокреиране налоге као део процеса пријављивања или када је постојећи Moodle налог повезан са OAuth пријавом путем одговарајућих е-адреса.';
$string['issuers'] = 'Даваоци идентитета';
$string['issuersetup'] = 'Детаљна упутства о конфигурацији општих OAuth 2 сервиса';
$string['issuersetuptype'] = 'Детаљна упутства о подешавању {$a} OAuth 2 даваоца';
$string['issuershowonloginpage'] = 'Прикажи на страници за пријављивљње на систем';
$string['issuershowonloginpage_help'] = 'Ако је додатак за проверу идентитета OAuth 2 омогућен, овај давалац идентитета биће наведен на страници за пријављивање како би омогућио корисницима да се пријаве на систем са налогом овог даваоца идентитета.';
$string['issuersservicesallow'] = 'Дозволите сервисе';
$string['issuersservicesnotallow'] = 'Не дозволите сервисе';
$string['issuerusedforinternal'] = 'Интерни сервиси';
$string['issuerusedforlogin'] = 'Пријава';
$string['issuerusein'] = 'Овај сервис ће се користити';
$string['issuerusein_help'] = 'OAuth 2 сервиси могу се користити за интерне сервисе, на страници за пријаву, или обоје, ако је потребно.';
$string['issueruseineverywhere'] = 'Страница за пријављивање и интерне сервисе';
$string['issueruseininternalonly'] = 'Само интерни сервиси';
$string['issueruseinloginonly'] = 'Само страница за пријављивање';
$string['linkedin_service'] = 'LinkedIn';
$string['logindisplay'] = 'Прикажите на страници за пријављивање као';
$string['loginissuer'] = 'Дозволи пријаву на систем';
$string['microsoft_service'] = 'Microsoft';
$string['moodlenet_service'] = 'MoodleNet';
$string['nextcloud_service'] = 'Nextcloud';
$string['notconfigured'] = 'Није конфигурисано';
$string['notdiscovered'] = 'Проналажење сервиса није успело';
$string['notloginissuer'] = 'Немој дозволити пријаву на систем';
$string['pluginname'] = 'OAuth 2 сервиси';
$string['privacy:metadata'] = 'Додатак OAuth 2 сервиси не чува никакве личне податке.';
$string['savechanges'] = 'Сачувај промене';
$string['serviceshelp'] = 'Упутства за подешавање даваоца сервиса';
$string['systemaccountconnected'] = 'Веза са системским налогом успостављена';
$string['systemaccountconnected_help'] = 'Системски налози се користе за пружање напредних функционалности за додатке. Они нису потребни само за пријаву на систем. Други додаци који користе OAuth сервис могу да понуде редуковани скуп функција уколико веза са системским налогом није успостављена. На пример, репозиторијуми не могу да подрже "контролисане линкове" без системског налога, како би обавили операције са датотекама.';
$string['systemaccountnotconnected'] = 'Веза са системским налогом није успостављена';
$string['systemauthstatus'] = 'Веза са системским налогом успостављена';
$string['usebasicauth'] = 'Захтеви за токенима за проверу идентитета путем HTTP заглавља';
$string['usebasicauth_help'] = 'Користите схему основне HTTP провере идентитета приликом слања ID ознаке и лозинке клијента са захтевом за освежавање токена. Препоручено према OAuth 2 стандарду, али можда није доступно код неких даваоца идентитета.';
$string['userfieldexternalfield'] = 'Назив екстерног поља';
$string['userfieldexternalfield_error'] = 'Ово поље не може да садржи HTML.';
$string['userfieldexternalfield_help'] = 'Назив поља које пружа екстерни OAuth систем';
$string['userfieldinternalfield'] = 'Назив интерног поља';
$string['userfieldinternalfield_help'] = 'Назив Moodle корисничког поља које треба да буде пресликано из екстерног поља.';
$string['userfieldmappingdeleted'] = 'Мапирање корисничког поља обрисано';
$string['userfieldmappingsforissuer'] = 'Мапирања корисничких поља за даваоца идентитета: {$a}';
