<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_essential', language 'pt', version '5.0'.
 *
 * @package     theme_essential
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['aftercontent'] = 'Depois do conteúdo';
$string['alert1'] = 'Primeiro Alerta';
$string['alert2'] = 'Segundo Alerta';
$string['alert3'] = 'Terceiro Alerta';
$string['alert_edit'] = 'Editar alertas';
$string['alert_general'] = 'Anúncio';
$string['alert_info'] = 'Informações';
$string['alert_warning'] = 'Aviso';
$string['alertinfodesc'] = 'Introduza as configurações para os alertas.';
$string['alertsdesc'] = 'Será apresentado na página principal do Moodle um alerta (ou vários) em três estilos diferentes. Por favor, lembre-se de desativar esta opção quando deixar de ser necessária.';
$string['alertsheading'] = 'Alertas ao Utilizador';
$string['alertsheadingsub'] = 'Mostrar mensagens importantes aos utilizadores na página principal';
$string['alerttext'] = 'Texto de Alerta';
$string['alerttextdesc'] = 'Qual é o texto que deseja exibir no seu alerta';
$string['alerttitle'] = 'Título';
$string['alerttitledesc'] = 'Título principal / cabeçalho para o alerta';
$string['alerttype'] = 'Nível';
$string['alerttypedesc'] = 'Defina o nível/tipo adequado para o alerta para melhor informar os utilizadores';
$string['allclasses'] = 'Todas as Classes';
$string['allcourses'] = 'Todas as Disciplinas';
$string['allmodules'] = 'Todos os Módulos';
$string['allunits'] = 'Todas as Unidades';
$string['alternativecolors'] = 'Cores Alternativas {$a}';
$string['alternativethemecolor'] = 'Cores Alternativas do Tema {$a}';
$string['alternativethemecolordesc'] = 'Escolha as cores alternativas para o seu Tema para as {$a}. Ao ativar esta opção as cores que escolher vão sobrepor-se às cores do Tema.';
$string['alternativethemecolorname'] = 'Designação do Conjunto de Cores Alternativas {$a}';
$string['alternativethemecolornamedesc'] = 'Forneça um nome para este conjunto de cores alternativas';
$string['alternativethemecolors'] = 'Cores Alternativas do Tema';
$string['alternativethemecolorsdesc'] = 'Define as cores alternativas que o utilizador pode selecionar.';
$string['alternativethemedefaultbuttonbackgroundcolour'] = 'Cor {$a} de fundo do botão predefinido';
$string['alternativethemedefaultbuttonbackgroundcolourdesc'] = 'Defina a cor {$a} de fundo para todos os botões predefinidos.';
$string['alternativethemedefaultbuttonbackgroundhovercolour'] = 'Cor {$a} de fundo do botão predefinido no estado Hover';
$string['alternativethemedefaultbuttonbackgroundhovercolourdesc'] = 'Defina a cor {$a} de fundo no estado Hover de todos os botões predefinidos.';
$string['alternativethemedefaultbuttontextcolour'] = 'Cor {$a} do texto do botão predefinido';
$string['alternativethemedefaultbuttontextcolourdesc'] = 'Defina a cor {$a} do texto para todos os botões predefinidos.';
$string['alternativethemedefaultbuttontexthovercolour'] = 'Cor {$a} do texto do botão predefinido no estado Hover';
$string['alternativethemedefaultbuttontexthovercolourdesc'] = 'Defina a cor {$a} do texto no estado Hover para todos os botões predefinidos.';
$string['alternativethemefooterblockbackgroundcolour'] = 'Cor {$a} de fundo do bloco de rodapé para as cores alternativas do tema';
$string['alternativethemefooterblockbackgroundcolourdesc'] = 'Defina a cor {$a} de fundo do bloco de rodapé para as cores alternativas do tema.';
$string['alternativethemefooterblockhovercolour'] = 'Cor {$a} da hiperligação no estado Hover no bloco de rodapé para as cores alternativas do tema';
$string['alternativethemefooterblockhovercolourdesc'] = 'Defina a cor {$a} do seu bloco de texto com hiperligação no estado Hover no rodapé para as cores alternativas do tema.';
$string['alternativethemefooterblocktextcolour'] = 'Cor {$a} do texto do bloco de rodapé para as cores alternativas do tema';
$string['alternativethemefooterblocktextcolourdesc'] = 'Defina a cor {$a} que pretende para o seu bloco de texto no rodapé para as cores alternativas do tema.';
$string['alternativethemefooterblockurlcolour'] = 'Cor {$a} da hiperligação do bloco de rodapé para as cores alternativas do tema';
$string['alternativethemefooterblockurlcolourdesc'] = 'Defina a cor {$a} do seu bloco texto com hiperligação no rodapé para as cores alternativas do tema.';
$string['alternativethemefootercolor'] = 'Cor {$a} de fundo do rodapé para as cores alternativas do tema';
$string['alternativethemefootercolordesc'] = 'Defina a cor {$a} de fundo que a caixa de rodapé deverá ter nas cores alternativas do tema';
$string['alternativethemefooterheadingcolor'] = 'Cor {$a} do cabeçalho do rodapé para as cores alternativas do tema';
$string['alternativethemefooterheadingcolordesc'] = 'Defina a cor {$a} dos cabeçalhos no rodapé para as cores alternativas do tema';
$string['alternativethemefooterhovercolor'] = 'Cor {$a} da hiperligação no estado Hover no rodapé para as cores alternativas do tema';
$string['alternativethemefooterhovercolordesc'] = 'Defina a cor {$a} para o texto com hiperligação no estado Hover no rodapé para as cores alternativas do tema.';
$string['alternativethemefootersepcolor'] = 'Cor {$a} do separador do rodapé para as cores alternativas do tema';
$string['alternativethemefootersepcolordesc'] = 'Os separadores são linhas utilizadas para separar conteúdo. Defina as cores {$a} destes para as cores alternativas do tema.';
$string['alternativethemefootertextcolor'] = 'Cor {$a} do texto do rodapé para as cores alternativas do tema';
$string['alternativethemefootertextcolordesc'] = 'Defina a cor {$a} que pretende que o seu texto tenha no rodapé para as cores alternativas do tema.';
$string['alternativethemefooterurlcolor'] = 'Cor {$a} das hiperligações do rodapé para as cores alternativas do tema';
$string['alternativethemefooterurlcolordesc'] = 'Defina a cor {$a} do texto com hiperligações no rodapé para as cores alternativas do tema.';
$string['alternativethemehovercolor'] = 'Cor {$a} Alternativa do Tema (estado Hover)';
$string['alternativethemehovercolordesc'] = 'Escolha as cores {$a} alternativas no estado Hover para o seu Tema. Ao ativar esta opção as cores que escolher vão sobrepor-se às cores do Tema.';
$string['alternativethemeiconcolor'] = 'Cor {$a} dos ícones alternativos';
$string['alternativethemeiconcolordesc'] = 'Defina a cor {$a} alternativa para todos os ícones.';
$string['alternativethememycoursesorderenrolbackcolour'] = 'Cor de fundo alternativa {$a} para disciplinas inscritas mas não acedidas';
$string['alternativethememycoursesorderenrolbackcolourdesc'] = 'Definir cor de fundo alternativa {$a} para disciplinas inscritas mas não acedidas. Para quando \'mycoursesorder\' estiver definida como \'Último acesso...\'.';
$string['alternativethemename'] = 'Nome para o Esquema de Cores';
$string['alternativethemenamedesc'] = 'Forneça um nome para este conjunto de cores alternativas';
$string['alternativethemenavcolor'] = 'Cor {$a} do texto da navegação';
$string['alternativethemenavcolordesc'] = 'Defina a cor {$a} de texto alternativa para a navegação, caso a barra de navegação e o trilho de navegação estejam com o estilo Fantasia.';
$string['alternativethemeslidebuttoncolor'] = 'Cor {$a} do botão do slide do tema alternativo';
$string['alternativethemeslidebuttoncolordesc'] = 'Escolha a cor {$a} do botão do slide para o seu tema para as cores alternativas do tema.';
$string['alternativethemeslidebuttonhovercolor'] = 'Cor {$a} no estado Hover do botão do slide do tema alternativo';
$string['alternativethemeslidebuttonhovercolordesc'] = 'Escolha a cor {$a} do botão do slide no estado Hover para o seu tema para as cores alternativas do tema.';
$string['alternativethemeslidecaptionbackgroundcolor'] = 'Cor {$a} de fundo da legenda do slide para o tema alternativo';
$string['alternativethemeslidecaptionbackgroundcolordesc'] = 'Escolha a cor {$a} de fundo do botão do slide para o seu tema para as cores alternativas do tema. Esta configuração não se aplica à opção de legenda do slide \'Ao lado\'.';
$string['alternativethemeslidecaptiontextcolor'] = 'Cor {$a} do texto da legenda do slide do tema alternativo';
$string['alternativethemeslidecaptiontextcolordesc'] = 'Escolha a cor {$a} do texto da legenda do slide para o seu tema para as cores alternativas do tema. Esta configuração não se aplica à opção de legenda do slide \'Ao lado\'.';
$string['alternativethemeslidecolors'] = 'Cores do slide para o tema alternativo';
$string['alternativethemeslidecolorsdesc'] = 'Define as cores do slide que o utilizador poderá selecionar para o tema alternativo.';
$string['alternativethemestripebackgroundcolour'] = 'Cor de fundo {$a} da faixa alternativa';
$string['alternativethemestripebackgroundcolourdesc'] = 'Definir a cor de fundo {$a} alternativa para as faixas nas tabelas';
$string['alternativethemestripetextcolour'] = 'Cor do texto {$a} das faixas alternativas';
$string['alternativethemestripetextcolourdesc'] = 'Definir a cor do texto {$a} alterantiva para as faixas nas tabelas';
$string['alternativethemestripeurlcolour'] = 'Cor alternativa da hiperligação da listra {$a}';
$string['alternativethemestripeurlcolourdesc'] = 'Definir a cor alternativa {$a} da hiperligação para listras em tabelas.';
$string['alternativethemetextcolor'] = 'Cor {$a} do texto alternativo';
$string['alternativethemetextcolordesc'] = 'Define a cor {$a} para o seu texto alternativo.';
$string['alternativethemeurlcolor'] = 'Cor {$a} do texto alternativo com hiperligação.';
$string['alternativethemeurlcolordesc'] = 'Define a cor {$a} para o seu texto alternativo com hiperligação.';
$string['alwaysdisplay'] = 'Mostrar sempre';
$string['android'] = 'Android (Google Play)';
$string['androiddesc'] = 'Indique um endereço URL da sua aplicação para dispositivos móveis na Google Play Store. Se não possuir uma, talvez queira considerar a hipótese de ligar à versão gratuita da aplicação Moodle Mobile. (https://play.google.com/store/apps/details?id=com.moodle.moodlemobile)';
$string['androidurl'] = 'Endereço URL Android (Google Play)';
$string['asconfigintlower'] = '{$a->value} é menor que o limite inferior do intervalo ({$a->lower})';
$string['asconfigintnan'] = '{$a->value} não é um número';
$string['asconfigintupper'] = '{$a->value} é maior que o limite superior do intervalo ({$a->upper})';
$string['backtotop'] = 'Voltar ao topo';
$string['badgepreferences'] = 'Medalha';
$string['beforecontent'] = 'Antes do conteúdo';
$string['breadcrumbsimple'] = 'Simples';
$string['breadcrumbstyle'] = 'Estilo do trilho de navegação';
$string['breadcrumbstyled'] = 'Fantasia';
$string['breadcrumbstyledesc'] = 'Altere aqui o estilo do trilho de navegação';
$string['breadcrumbstylednocollapse'] = 'Fantasia sem colapso';
$string['breadcrumbthin'] = 'Fino';
$string['cachesused'] = 'Usado em cache';
$string['categoryctidesc'] = 'Se ativar esta opção, poderá definir imagens para cada categoria.';
$string['categoryctiheading'] = 'Imagens de título da categoria da disciplina';
$string['categoryctiheadingcategory'] = 'Título das imagens da categoria de disciplinas: {$a->category}';
$string['categoryctiheadingcs'] = 'Configuração do título das imagens da categoria de disciplinas';
$string['categoryctiheadingsub'] = 'Utilize imagens para representar as suas categorias numa disciplina';
$string['categoryctiheight'] = 'Altura da imagem de título da categoria \'{$a->category}\' da disciplina';
$string['categoryctiheightdesc'] = 'Altura da imagem para o título da disciplina na categoria \'{$a->category}\' entre {$a->lower} e {$a->upper} píxeis. Introduza apenas o número, sem o sufixo \'px\'.';
$string['categoryctiinfo'] = 'Configurações {$a->category}';
$string['categoryctiinfodesc'] = 'Configurações da imagem de título para a categoria da disciplina: {$a->category}.';
$string['categoryctimage'] = 'Ficheiro da imagem de título da disciplina da categoria \'{$a->category}\'';
$string['categoryctimagedesc'] = 'Ficheiro da imagem para o título da disciplina na categoria \'{$a->category}\'.';
$string['categoryctimageurl'] = 'URL da imagem de título da disciplina da categoria \'{$a->category}\'';
$string['categoryctimageurldesc'] = 'URL da imagem para o título da disciplina na categoria \'{$a->category}\'.';
$string['categoryctitextbackgroundcolour'] = 'Cor de fundo do texto do título da disciplina da categoria \'{$a->category}\'';
$string['categoryctitextbackgroundcolourdesc'] = 'Cor de fundo do texto para o título da disciplina na categoria \'{$a->category}\'.';
$string['categoryctitextbackgroundopacity'] = 'Transparência do fundo do texto do título da disciplina da categoria \'{$a->category}\'';
$string['categoryctitextbackgroundopacitydesc'] = 'Transparência do fundo do texto para o título da disciplina na categoria \'{$a->category}\'.';
$string['categoryctitextcolour'] = 'Cor do texto do título da disciplina da categoria \'{$a->category}\'';
$string['categoryctitextcolourdesc'] = 'Cor do texto para o título da disciplina na categoria \'{$a->category}\'.';
$string['categoryiconcategory'] = 'Ícone para a categoria: {$a->category}.';
$string['categoryicondesc'] = 'Se ativar esta opção, poderá definir ícones para cada categoria de disciplinas.';
$string['categoryiconheading'] = 'Ícones da Categoria';
$string['categoryiconheadingsub'] = 'Use ícones para representar suas categorias';
$string['categoryiconinfo'] = 'Configurar Ícones da Categoria';
$string['categoryiconinfodesc'] = 'Insira o nome do ícone que pretende usar. Consulte a Lista <a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/" target="_new">aqui</a>. Insira apenas o texto que se segue após: "fa-".';
$string['categoryincoursebreadcrumbfeature'] = 'Categorias no trilho de navegação da disciplina';
$string['categoryincoursebreadcrumbfeaturedesc'] = 'Mostrar hiperligações para as categorias no trilho de navegação da disciplina.';
$string['choosereadme'] = '<div class="clearfix">
<div class="well">
<h2>Essential</h2>
<p><img class=img-polaroid src="essential/pix/screenshot.jpg"
alt="Imagem de Essential"/></p>
</div>
<div class="well">
<h3>Acerca do Tema Essential</h3>
<p>O Tema Essential é baseado no tema Bootstrap, criado para o Moodle 2.5, com o apoio de:<br>
Bas Brands, Stuart Lamour, Mark Aberdour, Paul Hibbitts, Mary Evans.</p>
<h3>Créditos do Tema</h3>
<p>Autor Original: Julian Ridden<br>
Desenvolvido em Julho de 2014 por:<br>
Gareth J. Barnard<br>
Trabalho realizado desde 9 de outubro de 2014 por:<br>
Gareth J. Barnard<br>
</p>
<h3>Patrocínios</h3>
<p>Este tema é fornecido de forma gratuita, e se quer expressar o seu agradecimento, por favor considere fazer um donativo por:
<h4>PayPal</h4>
<p>Entre em contacto comigo através do meu <a href="http://moodle.org/user/profile.php?id=442195" target="_blank"> \'perfil Moodle\'</a> para mais detalhes e, como sou um particular, não é possível ter botões de "Compre agora" sob os termos do Moodle. </ p>
<h4>Flattr</h4>
<a href="https://flattr.com/profile/gjb2048" target="_blank">
clique para patrocinar.
</a>
<br>Patrocínios ajudam na manutenção e permitem-me fornecer mais e melhores recursos. Sem estes apoios, é difícil manter o tema. </p>
<p>
<h3>Patrocinadores</h3>
<p>Agradecimentos aos donativos gratamente recebidos de:</p>
<ul>
<li>Mihai Bojonca,TCM International Institute.</li>
<li>Guido Hornig, actXcellence <a href="//actxcellence.de" target="_blank"> actxcellence.de </a></li>
<li>Delvon Forrester, Esparanza co uk</li>
<li>iZone</li>
<li>Anis Jradah</li>
<li>Ute Hlasek, <a href="//hlasek-it.de/moodle" target="_blank"> hlasek-it.de/moodle</a></li>
</ul>
</p>
<p>
<h3>Tema Essential para Moodle 3.0 gentilmente patrocinado por: </h3>
<ul>
<li>Leila Hiret</li>
<li>Vilar da Camara Neto</li>
<li>Kees Koopman</li>
<li>Matej Topolovec</li>
<li>Mihai Bojonca</li>
<li>V. Y. S. Cavalcanti</li>
<li>Christian Kleinhanss</li>
<li>Nadav Kavalerchik</li>
<li>Francisco Gomez Gonzalez</li>
<li>Lazar Ivanov</li>
<li>Duval Arnaud</li>
<li>Kai ner Maa Pitanta</li>
<li>Gregory Reinert</li>
<li>M van der Niet</li>
<li>Floyd Saner</li>
<li>Andreas Schenkel</li>
<li>Gemma Lesterhuis</li>
<li>Roy Bentley</li>
<li>Duane Cox</li>
</ul>
</p>
<h3>Personalização</h3>
<p>Se gosta deste tema e gostaria de personalizá-lo, transpor funcionalidades para outro tema, construir um novo tema a partir do zero ou um tema dependente, ofereço preços competitivos. Entre em contacto comigo via \'http://moodle.org/user/profile.php?id=442195\' para conversarmos sobre o que precisa.</p>
</div></div>';
$string['colordesc'] = 'Aqui poderá encontrar várias definições para alterar muitas das cores usadas neste tema.';
$string['colorheading'] = 'Definições de cor';
$string['colorheadingsub'] = 'Defina as cores usadas no tema';
$string['configtitle'] = 'Essential';
$string['contactinfo'] = 'Informações de contacto';
$string['contactinfodesc'] = 'Insira as suas informações de contacto';
$string['copyright'] = 'Direitos de autor';
$string['copyrightdesc'] = 'Nome de sua organização.';
$string['coursecontentsearch'] = 'Pesquisar conteúdo de disciplina';
$string['coursecontentsearchdesc'] = 'Ativar pesquisa de conteúdo da disciplina na página \'Painel do utilizador\'. Apenas funciona quando o Tema Essential não se encontra localizado em \'\\$CFG->themedir\'.';
$string['coursegrades'] = 'Notas da disciplina';
$string['courselistteachericon'] = 'Ícone da lista de professores da disciplina';
$string['courselistteachericondesc'] = 'Introduza o nome do ícone ou deixe o campo vazio se não quiser adicionar nenhum ícone. A lista está <a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/" target="_new">aqui</a>. Introduza o nome que está depois de "fa-", por exemplo, "star".';
$string['ctioverride'] = 'A redefinir as imagens da categoria numa disciplina';
$string['ctioverridedesc'] = 'Se deseja alterar a imagem de título da categoria da disciplina numa disciplina quando esta configuração \'enablecategorycti\' está ativa, então edite o sumário da disciplina nas configurações da disciplina e adicione a imagem. Depois no modo de edição HTML, remova as tags \'p\' e \'br\', e os atributos \'style\', \'width\' e \'height\'. Remova também os atributos de classes adicionados pelo editor de texto na tag \'img\'. Depois adicione a classe \'categorycti\'. Para especificar a altura (em píxeis) e a cor do texto do título da caixa, a cor de fundo e a transparência, utilize os seguintes atributos: \'ctih\', \'ctit\', \'ctib\' e \'ctio\', respetivamente, por exemplo: <br/><br/><img src="https://mymoodleinstall.me/pluginfile.php/493/course/section/237/myimage.jpg" alt="Replacement image" class="categorycti" ctih="250" ctit="#afafaf" ctib="#222222" ctio="0.5"><br/><br/> Esta imagem não será exibida no próprio sumário quando visualiza a lista de disciplinas.';
$string['ctioverrideheight'] = 'Valor predefinido para a altura da imagem do título da disciplina';
$string['ctioverrideheightdesc'] = 'Valor predefinido para a altura da imagem para o título da disciplina entre {$a->lower} e {$a->upper} píxeis. Introduza apenas o número, sem o sufixo \'px\'.';
$string['ctioverridetextbackgroundcolour'] = 'Valor predefinido para a cor de fundo do texto do título da disciplina';
$string['ctioverridetextbackgroundcolourdesc'] = 'Valor predefinido para a cor de fundo do texto para o título da disciplina.';
$string['ctioverridetextbackgroundopacity'] = 'Valor predefinido para a transparência do fundo do texto do título da disciplina';
$string['ctioverridetextbackgroundopacitydesc'] = 'Valor predefinido para a transparência do fundo do texto para o título da disciplina.';
$string['ctioverridetextcolour'] = 'Valor predefinido para a cor do texto do título da disciplina';
$string['ctioverridetextcolourdesc'] = 'Valor predefinido para a cor do texto para o título da disciplina.';
$string['customcss'] = 'CSS Personalizado';
$string['customcssdesc'] = 'As regras de CSS que adicionar aqui serão refletidas em todas as páginas, tornando mais fácil a personalização deste tema.';
$string['customscrollbars'] = 'Barras de scroll personalizadas';
$string['customscrollbarsdesc'] = 'Utilizar barras de scroll personalizadas. Se ativar esta opção, as barras de scroll predefinidas do navegador serão substituídas.';
$string['dbqueries'] = 'Leitura/Escrita da Base de dados';
$string['dbtime'] = 'Tempo dos pedidos à base de dados';
$string['defaultcategoryicon'] = 'Ícone predefinido de categoria';
$string['defaultcategoryicondesc'] = 'Definir um ícone predefinido de categoria';
$string['defaultcolors'] = 'Cores predefinidas';
$string['displayafterlogin'] = 'Mostrar apenas após da autenticação (login)';
$string['displaybeforelogin'] = 'Mostrar apenas antes da autenticação (login)';
$string['displayeditingmenu'] = 'Exibir botão de edição';
$string['displayeditingmenudesc'] = 'Exibe um botão com a mesma funcionalidade do botão de edição no cabeçalho da página predefinida.';
$string['displayhiddenmycourses'] = 'Exibir disciplinas ocultas';
$string['displayhiddenmycoursesdesc'] = 'Exibe aos utilizadores as disciplinas ocultas no Menu disciplinas caso tenham permissões para tal';
$string['displaymycourses'] = 'Mostrar disciplinas';
$string['displaymycoursesdesc'] = 'Mostrar aos utilizadores, na barra de navegação, as disciplinas em que estão inscritos.';
$string['dontdisplay'] = 'Nunca Mostrar';
$string['dropdownmenumaxheight'] = 'Altura máxima do menu pendente';
$string['dropdownmenumaxheightdesc'] = 'Altura máxima do menu pendente quando as barras de deslocamento estão ativas. Entre {$a->lower} e {$a->upper} píxeis.';
$string['dropdownmenuscroll'] = 'Barras de deslocamento nos menus pendentes';
$string['dropdownmenuscrolldesc'] = 'Existir uma barra de deslocamento no menu pendente quando a altura do menu é limitada.';
$string['editingmenu'] = 'Modo de edição da página';
$string['editingmenudesc'] = 'Mostra um botão para ativar/desativar o modo de edição da página atual, caso o utilizador tenha permissões de edição. Trata-se da mesma funcionalidade do botão de edição das páginas comuns.';
$string['enablealert'] = 'Ativar Alerta';
$string['enablealertdesc'] = 'Ativar ou desativar alertas';
$string['enablealternativethemecolors'] = 'Ativar Cores Alternativas para o Tema {$a}';
$string['enablealternativethemecolorsdesc'] = 'Se ativado, o utilizador poderá escolher cores alternativas para o tema {$a}.';
$string['enablecategorycti'] = 'Ativar as imagens de título da categoria da disciplina';
$string['enablecategoryctics'] = 'Ativar páginas de configuração do título da imagem da categoria da disciplina';
$string['enablecategorycticsdesc'] = 'Se ativar esta opção, cada categoria de nível topo terá sua própria página de configuração.';
$string['enablecategoryctidesc'] = 'Se ativar esta opção, poderá selecionar imagens de título da categoria da disciplina depois de clicar em "Gravar alterações".';
$string['enablecategoryicon'] = 'Ativar Ícones da Categoria';
$string['enablecategoryicondesc'] = 'Se ativado, poderá selecionar ícones da categoria depois de clicar em "Guardar alterações".';
$string['enablecustomcategoryicon'] = 'Ativar Ícones da Categoria Personalizados';
$string['enablecustomcategoryicondesc'] = 'Se ativado, verá por baixo desta secção uma listagem das categorias com a opção de personalizar o ícone. Por favor, grave após ativar ou desativar esta opção.';
$string['extperfinfoheading'] = 'Informação de desempenho estendida';
$string['facebook'] = 'Endereço URL do Facebook';
$string['facebookdesc'] = 'Endereço URL do Facebook. Exemplo: https://www.facebook.com/mycollege';
$string['facebookurl'] = 'Endereço URL do Facebook';
$string['favicon'] = 'Personalizar favicon';
$string['favicondesc'] = 'Carregue o seu próprio favicon. Deverá ser um ficheiro com a extensão .ico.';
$string['featuredesc'] = 'Aqui poderá encontrar várias configurações para alterar muitas das funcionalidades presentes neste tema.';
$string['featureheading'] = 'Funcionalidades';
$string['featureheadingsub'] = 'Configuração das funcionalidades presentes neste tema';
$string['findcoursecontent'] = 'Conteúdo da disciplina:';
$string['fitvids'] = 'Utilizar FitVids';
$string['fitvidsdesc'] = 'Ative o FitVids (fitvidsjs.com) de modo a tornar os seus vídeos incorporados responsivos. Se ativar esta configuração pode excluir um video em particular adicionando \'class="fitvidsignore"\' à tag \'iframe\' no modo de edição HTML. Por exemplo: \'iframe class="fitvidsignore" width="420" height="315" src="//www.youtube.com/embed/enmEmym85xc" frameborder="0" allowfullscreen=""></iframe\'.';
$string['fixedwidthnarrow'] = 'Largura Fixa - Estreito';
$string['fixedwidthnormal'] = 'Largura Fixa - Normal';
$string['fixedwidthwide'] = 'Largura Fixa - Largo';
$string['flickr'] = 'Flickr';
$string['flickrdesc'] = 'Insira o endereço URL do Flickr. Exemplo: http://www.flickr.com/photos/mycollege';
$string['flickrurl'] = 'Endereço URL do Flickr';
$string['floatingsubmitbuttons'] = 'Botões de submissão flutuantes';
$string['floatingsubmitbuttonsdesc'] = 'Ativa uma área flutuante que contem os botões utilizados em computadores para submeter formulários. Isto ajuda a reduzir o scroll em páginas longas. Não aplicável a inscrições na disciplina nem a mensagens em fóruns.';
$string['fontcharacterset'] = 'Conjunto de caracteres adicionais da fonte Google';
$string['fontcharactersetcyrillic'] = 'Alfabeto Cirílico';
$string['fontcharactersetcyrillicext'] = 'Alfabeto Cirílico estendido';
$string['fontcharactersetdesc'] = 'Selecione conjuntos de caracteres adicionais para diferentes idiomas. Utilizar muitos conjuntos de caracteres poderá tornar o Moodle lento, pelo que deverá selecionar apenas os conjuntos de caracteres de que realmente necessita.';
$string['fontcharactersetgreek'] = 'Alfabeto Grego';
$string['fontcharactersetgreekext'] = 'Alfabeto Grego estendido';
$string['fontcharactersetlatinext'] = 'Alfabeto Latim estendido';
$string['fontcharactersetvietnamese'] = 'Alfabeto Vietnamita';
$string['fontfileeotbody'] = 'Corpo do ficheiro EOT da fonte';
$string['fontfileeotheading'] = 'Cabeçalho do ficheiro EOT da fonte';
$string['fontfileotfbody'] = 'Corpo do ficheiro OTF da fonte';
$string['fontfileotfheading'] = 'Cabeçalho do ficheiro OTF da fonte';
$string['fontfiles'] = 'Ficheiros de fonte';
$string['fontfilesdesc'] = 'Carregue aqui os seus ficheiros de fontes.';
$string['fontfilesvgbody'] = 'Ficheiro da fonte SVG do corpo';
$string['fontfilesvgheading'] = 'Ficheiro da fonte SVG do cabeçalho';
$string['fontfilettfbody'] = 'Ficheiro da fonte TTF do corpo';
$string['fontfilettfheading'] = 'Ficheiro da fonte TTF do do cabeçalho';
$string['fontfilewoffbody'] = 'Ficheiro da fonte WOFF do corpo';
$string['fontfilewoffheading'] = 'Ficheiro da fonte WOFF do cabeçalho';
$string['fontfilewofftwobody'] = 'Ficheiro da fonte WOFF2 do corpo';
$string['fontfilewofftwoheading'] = 'Ficheiro da fonte WOFF2 do cabeçalho';
$string['fontheadingdesc'] = 'Selecione e indique os tipos de letra que pretende utilizar no seu ambiente Moodle.';
$string['fontheadingsub'] = 'Configurações do tipo de letra';
$string['fontnamebody'] = 'Tipo de letra do texto';
$string['fontnamebodydesc'] = 'Introduza a designação exata do tipo de letra a utilizar para o restante texto.';
$string['fontnameheading'] = 'Tipo de letra do cabeçalho';
$string['fontnameheadingdesc'] = 'Introduza a designação exata do tipo de letra a utilizar nos cabeçalhos.';
$string['fontselect'] = 'Selector do Tipo de Letra';
$string['fontselectdesc'] = 'Escolha a partir da lista de combinações de tipos de letra disponíveis:<ul><li>\'Fontes do utilizador\' encontram-se onde a fonte está atualmente instalada, no computador dos utilizadores, e necessita apenas de indicar o seu nome.</li><li>\'Fontes web do Google\' é onde encontra uma fonte em \'{$a->googlewebfonts}\' e indica o seu nome.</li><li>\'Fontes personalizadas\' estão onde especifica o nome e carrega o ficheiro da fonte respetiva.</li></ul>Por favor, grave as alterações para visualizar as opções da sua escolha.';
$string['fontsettings'] = 'Tipo de letra';
$string['fonttypecustom'] = 'Fontes personalizadas';
$string['fonttypegoogle'] = 'Fontes web do Google';
$string['fonttypeuser'] = 'Fontes do utilizador';
$string['footerblockbackgroundcolour'] = 'Cor de fundo do bloco de rodapé';
$string['footerblockbackgroundcolourdesc'] = 'Defina a cor de fundo para o bloco no rodapé.';
$string['footerblockhovercolour'] = 'Cor do bloco de rodapé com hiperligação (estado Hover)';
$string['footerblockhovercolourdesc'] = 'Defina a cor para o seu bloco de texto com hiperligação (estado Hovered over) no rodapé.';
$string['footerblocktextcolour'] = 'Cor de texto do bloco de rodapé';
$string['footerblocktextcolourdesc'] = 'Defina a cor que pretende para o seu bloco de texto no rodapé.';
$string['footerblockurlcolour'] = 'Cor da hiperligação do bloco no rodapé';
$string['footerblockurlcolourdesc'] = 'Defina a cor para o seu bloco de texto com hiperligação no rodapé.';
$string['footercolor'] = 'Cor de Fundo do Rodapé';
$string['footercolordesc'] = 'Defina a cor de fundo da caixa de rodapé.';
$string['footercolors'] = 'Cores do Rodapé';
$string['footercolorsdesc'] = 'Alterar as cores no rodapé das páginas';
$string['footerheading'] = 'Rodapé';
$string['footerheadingcolor'] = 'Cor do Cabeçalho do Rodapé';
$string['footerheadingcolordesc'] = 'Definir a cor para os títulos do bloco no rodapé.';
$string['footerhovercolor'] = 'Cor das hiperligações no estado Hover no rodapé';
$string['footerhovercolordesc'] = 'Defina a cor do texto com hiperligações no estado Hover no Rodapé.';
$string['footersepcolor'] = 'Cor do Separador no Rodapé';
$string['footersepcolordesc'] = 'Separadores são linhas usadas para separar conteúdo. Defina a cor dessas linhas aqui.';
$string['footertextcolor'] = 'Cor do Texto no Rodapé';
$string['footertextcolordesc'] = 'Defina a cor do texto no rodapé.';
$string['footerurlcolor'] = 'Cor das Hiperligações no Rodapé';
$string['footerurlcolordesc'] = 'Defina a cor das hiperligações no Rodapé.';
$string['footnote'] = 'Nota de Rodapé';
$string['footnotedesc'] = 'O que colocar nesta área será apresentado no Rodapé do Moodle.';
$string['fppagetopblocks'] = 'Ativar blocos adicionais \'Topo da página\' na página principal';
$string['fppagetopblocksdesc'] = 'Se ativar esta opção, será mostrada uma localização de bloco adicional ao lado dos blocos laterais e acima da área de conteúdo. Nota: O número de blocos por linha depende do parâmetro \'fppagetopblocksperrow\'.';
$string['fppagetopblocksperrow'] = 'Blocos topo da página por linha';
$string['fppagetopblocksperrowdesc'] = 'Definir quantos blocos por linha entre {$a->lower} e {$a->upper} para a região do bloco \'Topo da página\' na página principal.';
$string['frontcontent'] = 'Ativar conteúdo da Página Principal';
$string['frontcontentarea'] = 'Conteúdo da Página Principal';
$string['frontcontentareadesc'] = 'Tudo o que inserir nesta caixa será exibido em toda a largura da página, entre o Slideshow e as áreas de Marketing';
$string['frontcontentdesc'] = 'Adicione uma área personalizada de conteúdo entre o Slideshow e as caixas de Marketing onde poderá inserir conteúdo personalizado';
$string['frontcontentheading'] = 'Configurações da Página Principal';
$string['frontpageblocks'] = 'Alinhamento dos blocos na Página Principal';
$string['frontpageblocksdesc'] = 'Esta configuração determina se os blocos predefinidos do Moodle na página principal são alinhados antes ou depois do conteúdo.';
$string['frontpageblocksheading'] = 'Blocos da Página Principal';
$string['frontpageheading'] = 'Página Principal';
$string['frontpageheadingdesc'] = 'Configure aqui os itens adicionais que pretende que sejam exibidos na Página Principal';
$string['frontpagemiddleblocks'] = 'Ativar Blocos Intermédios na Página Principal';
$string['frontpagemiddleblocksdesc'] = 'Se ativado, apresentará 3 novos locais para blocos por baixo da área de Marketing';
$string['fullname'] = 'Nome completo do Site';
$string['fullnamesummary'] = 'Nome completo e sumário';
$string['generalheadingdesc'] = 'Configure aqui as definições gerais do tema';
$string['generalheadingsub'] = 'Configurações Gerais';
$string['genericsettings'] = 'Configurações Gerais';
$string['googleplus'] = 'Endereço URL do Google+';
$string['googleplusdesc'] = 'Insira o Endereço URL do perfil do Google+. Exemplo: https://plus.google.com/+mycollege';
$string['googleplusurl'] = 'Endereço URL do Google+';
$string['gotobottom'] = 'Ir para o fim da página';
$string['headerbackground'] = 'Imagem de fundo do cabeçalho';
$string['headerbackgrounddesc'] = 'Carregue a sua imagem de fundo.';
$string['headerbackgroundstyle'] = 'Estilo do fundo do cabeçalho';
$string['headerbackgroundstyledesc'] = 'Selecione o estilo de fundo do cabeçalho.';
$string['headerheading'] = 'Cabeçalho';
$string['headertextcolor'] = 'Cor do texto do cabeçalho';
$string['headertextcolordesc'] = 'Defina a cor do texto do cabeçalho.';
$string['headertitle'] = 'Título do cabeçalho';
$string['headertitledesc'] = 'Configure aqui o título a ser gerado para o cabeçalho. Note que o título do cabeçalho será apenas utilizado caso não exista nenhum logotipo.';
$string['helplink'] = 'Ajuda';
$string['helplinkdesc'] = 'Se escolher indicar um endereço URL, preencha o endereço URL completo para o seu site (deverá incluir o prefixo http:// ou https://). Caso escolha indicar um Endereço de e-mail, indique aqui o seu.';
$string['helplinktype'] = 'Ativar ajuda no menu';
$string['helplinktypedesc'] = 'Escolha se pretende ativar a opção de ajuda no menu de utilizador, poderá optar por indicar um endereço URL que será aberto numa nova janela ou um endereço de e-mail.';
$string['hidedefaulteditingbutton'] = 'Esconder botão de edição da página predefinida';
$string['hidedefaulteditingbuttondesc'] = 'Esconde o botão de edição da página predefinida de qualquer página. Esta opção apenas tem efeito caso a opção "Exibir botão de edição" esteja ativa.';
$string['hideonphone'] = 'Esconder Slideshow nos Telemóveis';
$string['hideonphonedesc'] = 'Aqui poderá desativar a apresentação do Slideshow nos Telemóveis.';
$string['hideontablet'] = 'Esconder Slideshow nos Tablets';
$string['hideontabletdesc'] = 'Aqui poderá desativar a apresentação do Slideshow nos Tablets.';
$string['included'] = 'Ficheiros incluidos';
$string['instagram'] = 'Endereço URL Instagram';
$string['instagramdesc'] = 'Insira o endereço URL da sua pánina do Instagram. Exemplo: http://instagram.com/mycollege.';
$string['instagramurl'] = 'Endereço URL do Instagram';
$string['ios'] = 'iPhone/iPad (App Store)';
$string['iosdesc'] = 'Fornecer um endereço URL da sua aplicação móvel na App Store. Se não possuir uma, talvez queira considerar a hipótese de endereçar  para a versão gratuita da aplicação Moodle Mobile. (https://itunes.apple.com/en/app/moodle-mobile/id633359593).';
$string['iosicon'] = 'Ícones no ecrã principal do iOS';
$string['iosicondesc'] = 'Este tema providencia ícones predefinidos para iOS e Android. Contudo, se pretender, poderá carregar ícones personalizados.';
$string['iosurl'] = 'Endereço URL iPhone/iPad (App Store)';
$string['ipadicon'] = 'Ícones para iPad (não Retina)';
$string['ipadicondesc'] = 'Os ícones devem ser carregados no formato PNG e ter a resolução de 72 x 72px';
$string['ipadretinaicon'] = 'Ícones para iPad (Retina)';
$string['ipadretinaicondesc'] = 'Os ícones devem ser carregados no formato PNG e ter a resolução de 144 x 144px';
$string['iphoneicon'] = 'Ícones iPhone/iPod Touch (não Retina)';
$string['iphoneicondesc'] = 'Os ícones devem ser carregados no formato PNG e ter a resolução de 57 x 57px';
$string['iphoneretinaicon'] = 'Ícones iPhone/iPod Touch (Retina)';
$string['iphoneretinaicondesc'] = 'Os ícones devem ser carregados no formato PNG e ter a resolução de 144 x 144px';
$string['layout'] = 'Usar estrutura de disciplina padrão';
$string['layoutdesc'] = 'Este tema foi concebido para colocar os blocos apenas de um lado. Se preferir a estrutura padrão do Moodle deve marcar esta opção para regressar à estrutura antiga com três colunas.';
$string['left'] = 'Esquerda';
$string['linkedin'] = 'Endereço URL do LinkedIn';
$string['linkedindesc'] = 'Insira o endereço URL da sua página do LinkedIn. Exemplo: https://www.linkedin.com/company/mycollege.';
$string['linkedinurl'] = 'Endereço URL do LinkedIn';
$string['loadtime'] = 'Tempo de carregamento';
$string['loggedinas'] = 'Autenticado como';
$string['loggedinfrom'] = 'Autenticado a partir de';
$string['logo'] = 'Logótipo';
$string['logodesc'] = 'Por favor, carregue o seu logótipo personalizado aqui para que apareça no cabeçalho.<br> Esta imagem deverá ter a mesma largura e altura especificada abaixo nas opções \'Largura do logotipo\' e \'Altura do logotipo\'. Se carregar o seu logotipo personalizado ele substituirá o logótipo padrão e o nome exibido por predefinição.';
$string['logodimerror'] = 'não é válido. Por favor, coloque \'px\' ou \'em\' imediatamente depois do valor de unidade e nada antes deste.';
$string['marketing1'] = 'Área de Marketing 01';
$string['marketing2'] = 'Área de Marketing 02';
$string['marketing3'] = 'Área de Marketing 03';
$string['marketingbuttontext'] = 'Texto de Hiperligação';
$string['marketingbuttontextdesc'] = 'Texto para Rótulo do Botão';
$string['marketingbuttonurl'] = 'Endereço URL';
$string['marketingbuttonurldesc'] = 'Endereço URL do Botão';
$string['marketingcontent'] = 'Conteúdo';
$string['marketingcontentdesc'] = 'Texto (curto) para apresentar na caixa de Marketing.';
$string['marketingdesc'] = 'Este tema disponibiliza 3 áreas de "Marketing" ou "Publicidade" imediatamente abaixo do Slideshow. Estas áreas permitem apresentar informação relevante aos utilizadores e fornecer hiperligações diretas.';
$string['marketingheading'] = 'Áreas de Marketing';
$string['marketingheadingsub'] = 'Três locais na Página Principal para adicionar informação e hiperligações';
$string['marketingheight'] = 'Altura (px) das Imagens (Marketing)';
$string['marketingheightdesc'] = 'Se quiser apresentar imagens na área de Marketing pode especificar a altura das mesmas aqui.';
$string['marketingicon'] = 'Ícone';
$string['marketingicondesc'] = 'Insira o nome do ícone que pretende usar. Consulte a Lista <a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/" target="_new">aqui</a>. Insira apenas o texto que se segue após: "fa-".';
$string['marketingimage'] = 'Imagem';
$string['marketingimagedesc'] = 'Esta opção permite apresentar uma imagem por cima do texto na área de Marketing';
$string['marketingimageheight'] = 'Altura das imagens de Marketing (px)';
$string['marketingimageheightdesc'] = 'Se pretende exibir imagens nas caixas de Marketing, poderá indicar aqui as suas alturas em píxeis.';
$string['marketinginfodesc'] = 'Configure a sua área de Marketing';
$string['marketingtitle'] = 'Título';
$string['marketingtitledesc'] = 'Título a apresentar na área de Marketing';
$string['marketingurltarget'] = 'Hiperligação de destino';
$string['marketingurltargetdesc'] = 'Escolha a forma como a hiperligação deve ser aberta';
$string['marketingurltargetnew'] = 'Nova Página';
$string['marketingurltargetparent'] = 'Frame';
$string['marketingurltargetself'] = 'Página Atual';
$string['memused'] = 'Memória utilizada';
$string['mobileappsdesc'] = 'Possui alguma aplicação Web na App Store ou Google Play Store? Indique aqui a hiperligação (link)';
$string['mobileappsheading'] = 'Aplicações Móveis';
$string['mobileappsheadingsub'] = 'Hiperligação para a sua aplicação para que os seus alunos usem dispositivos móveis';
$string['myclasses'] = 'As Minhas Turmas';
$string['mycourses'] = 'As minhas disciplinas';
$string['mycoursesinfo'] = 'Listagem de Alunos inscritos dinamicamente';
$string['mycoursesinfodesc'] = 'Apresentar uma listagem dinâmica de alunos inscritos';
$string['mycoursetitle'] = 'Designação';
$string['mycoursetitledesc'] = 'Alterar a designação de "As minhas disciplinas" na lista pendente';
$string['mygrades'] = 'As minhas notas';
$string['mymodules'] = 'Os Meus Módulos';
$string['myunits'] = 'As Minhas Unidades';
$string['navbarabove'] = 'Barra de navegação exibida acima do cabeçalho';
$string['navbarbelow'] = 'Barra de navegação exibida abaixo do cabeçalho';
$string['navbartitle'] = 'Título da barra de navegação';
$string['navbartitledesc'] = 'Configure aqui o título a ser gerado para a barra de navegação.';
$string['nextsection'] = 'Próxima Secção';
$string['nobreadcrumb'] = 'Ocultar';
$string['noenrolments'] = 'Não tem nenhuma inscrição';
$string['noslidetitle'] = 'Slide sem título {$a->slide}';
$string['notitle'] = 'Sem título';
$string['numberofcoursesandsubcatcourses'] = 'Número de disciplinas - categorias filha das disciplinas';
$string['numberofslides'] = 'Número de slides';
$string['numberofslides_desc'] = 'Número de slides na barra';
$string['oldnavbar'] = 'Utilizar a posição da Barra de Navegação antiga';
$string['oldnavbardesc'] = 'Ativar esta opção para utilizar a posição da Barra de Navegação antiga';
$string['pagebackground'] = 'Imagem do Fundo da Página';
$string['pagebackgrounddesc'] = 'Carregue uma imagem para utilizar como fundo. A imagem carregada será repetida como padrão em todas as páginas. Se não carregar uma imagem será usada uma imagem padrão do tema.';
$string['pagebackgroundstyle'] = 'Estilo de fundo da página';
$string['pagebackgroundstyledesc'] = 'Selecione o estilo para a imagem carregada.';
$string['pagewidth'] = 'Definir Largura da Página';
$string['pagewidthdesc'] = 'Escolha a partir da listagem uma das larguras disponíveis.';
$string['paypal_click'] = 'Perfil do Moodle';
$string['paypal_desc'] = '{$a->url} para obter mais detalhes em como eu sou um indivíduo e portanto sou incapaz de ter botões \'comprar agora\' abaixo dos termos ou';
$string['peakmem'] = 'Memória de topo';
$string['perf_max'] = 'Detalhado';
$string['perf_min'] = 'Básico';
$string['perfinfo'] = 'Informação de Performance do Moodle';
$string['perfinfodesc'] = 'Muitos sites não precisam da informação de performance totalmente detalhada. Quando ativada esta opção é apresentado um formulário com o sumário das informações básicas.';
$string['perfinfoheading'] = 'Informação de Performance';
$string['pinterest'] = 'Endereço URL do Pinterest';
$string['pinterestdesc'] = 'Insira o Endereço URL do Pinterest. Exemplo: http://pinterest.com/mycollege/mypinboard';
$string['pinteresturl'] = 'Endereço URL do Pinterest';
$string['pluginname'] = 'Essential';
$string['previoussection'] = 'Secção Anterior';
$string['profilebarcustomtitle'] = 'Bloco da Barra de Perfil: Título Personalizado';
$string['profilebarcustomtitledesc'] = 'Título para o Bloco da Barra de Perfil';
$string['readme_click'] = 'clique aqui para aceder ao ficheiro LEIAME.txt';
$string['readme_desc'] = 'Por favor, aceda ao ficheiro {$a->url} que contém mais informações acerca do Tema Essential, incluindo opções de personalização.';
$string['readme_title'] = 'Essential leia-me';
$string['readmore'] = 'Ler Mais';
$string['region-footer-left'] = 'Rodapé (Esquerda)';
$string['region-footer-middle'] = 'Rodapé (Centro)';
$string['region-footer-right'] = 'Rodapé (Direita)';
$string['region-hidden-dock'] = 'Ocultar dos Utilizadores';
$string['region-side-post'] = 'Direita';
$string['region-side-pre'] = 'Esquerda';
$string['returntosection'] = 'Regressar a: {$a->section}';
$string['returntosectionfeature'] = 'Regressar à secção';
$string['returntosectionfeaturedesc'] = 'Ativar a funcionalidade de regresso à secção dentro dos módulos da disciplina.';
$string['returntosectiontextlimitfeature'] = 'Limite de texto do nome regressar à secção';
$string['returntosectiontextlimitfeaturedesc'] = 'Limite do comprimento para o \'nome\' da secção no botão entre os caracteres {$a->lower} e {$a->upper}.';
$string['right'] = 'Direita';
$string['serverload'] = 'Carga do servidor';
$string['sessionsize'] = 'Tamanho da sessão';
$string['shortname'] = 'Nome curto do site';
$string['shortnamesummary'] = 'Nome curto e sumário';
$string['siteicon'] = 'Ícone do Site';
$string['siteicondesc'] = 'Não possui um logótipo? Escolha o nome do ícone que pretende utilizar. Listagem disponível <a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/" target="_new">aqui</a>. Insira apenas o texto que se segue após: "fa-".';
$string['skype'] = 'Conta Skype';
$string['skypedesc'] = 'Insira o nome de utilizador da sua conta Skype. Exemplo: my.college';
$string['skypeuri'] = 'Conta URI do Skype';
$string['slidebuttoncolor'] = 'Cor do botão do Slide';
$string['slidebuttoncolordesc'] = 'Introduza a cor que pretende para o botão na barra de slides.';
$string['slidebuttonhovercolor'] = 'Cor do botão do Slide';
$string['slidebuttonhovercolordesc'] = 'Introduza a cor que pretende para o botão na barra de slides.';
$string['slidecaption'] = 'Legenda para o Slide';
$string['slidecaptionbackgroundcolor'] = 'Cor de fundo da legenda do slide';
$string['slidecaptionbackgroundcolordesc'] = 'A cor de fundo que a legenda do slide deverá ter. Não se aplica à opção \'Ao lado\' de legenda do slide.';
$string['slidecaptionbelow'] = 'Imagem abaixo da legenda do slide';
$string['slidecaptionbelowdesc'] = 'Se a legenda do slide deve estar localizada abaixo da imagem.';
$string['slidecaptionbeside'] = 'Ao lado';
$string['slidecaptioncentred'] = 'Legenda do slide centrada';
$string['slidecaptioncentreddesc'] = 'Caso a legenda do slide deva estar centrada.';
$string['slidecaptiondesc'] = 'Introduza um texto curto para ser apresentado com o Slide';
$string['slidecaptionontop'] = 'Por cima';
$string['slidecaptionoptions'] = 'Opções da legenda do slide';
$string['slidecaptionoptionsdesc'] = 'Onde deverão ser exibidas as legendas em relação à imagem.';
$string['slidecaptiontextcolor'] = 'Cor do texto da legenda do slide';
$string['slidecaptiontextcolordesc'] = 'A cor do texto que a legenda do slide deverá ter. Não se aplica à opção \'Ao lado\' de legenda do slide.';
$string['slidecaptionunderneath'] = 'Por baixo';
$string['slidecolor'] = 'Cor do Texto no Slide';
$string['slidecolordesc'] = 'Introduza a cor que pretende para o texto na barra de slides.';
$string['slideimage'] = 'Imagem para o Slide';
$string['slideimagedesc'] = 'Para melhores resultados, a imagem que escolher deverá ter um fundo transparente.';
$string['slideinterval'] = 'Tempo de Intervalo entre Slides';
$string['slideintervaldesc'] = 'Tempo de Intervalo entre Slides em milissegundos.';
$string['slideno'] = 'Slide {$a->slide}';
$string['slidenodesc'] = 'Configuração do Slide {$a->slide}.';
$string['slideshowdesc'] = 'Esta opção cria um Slideshow dinâmico que pode conter até 16 slides para promover informação importante do seu site. O Slideshow é adaptado sendo a altura da imagem configurada de acordo com o tamanho do ecrã. A altura recomendada é 300 px. A largura é definida a 100%, pelo que a altura real será menor se a largura for superior ao ecrã. Para ecrãs pequenos a altura é reduzida dinamicamente sem ser necessário fornecer imagens diferentes. Para uma largura de referência < 767px = altura 165px, largura entre 768px e 979px = altura 225px e largura > 980px = altura 300px. Se não for selecionada imagem para um slide, então a imagem default_slide na pasta pix será usada.';
$string['slideshowheading'] = 'Slideshow da Página Principal';
$string['slideshowheadingsub'] = 'Slideshow Dinâmico para a Página Principal';
$string['slidetitle'] = 'Título do Slide';
$string['slidetitledesc'] = 'Introduza um Título sugestivo para o Slide';
$string['slideurl'] = 'Hiperligação do Slide';
$string['slideurldesc'] = 'Insira um endereço de destino para a Hiperligação (link) da imagem do slide';
$string['slideurltarget'] = 'Hiperligação de destino';
$string['slideurltargetdesc'] = 'Escolha como a Hiperligação (link) deve abrir';
$string['slideurltargetnew'] = 'Nova Página';
$string['slideurltargetparent'] = 'Frame';
$string['slideurltargetself'] = 'Página Atual';
$string['socialdesc'] = 'Forneça hiperligações para as redes sociais que melhor promovam a sua marca. Estas ligações vão aparecer em todos os cabeçalhos das páginas.';
$string['socialheading'] = 'Redes Sociais';
$string['socialheadingsub'] = 'Envolva os seus utilizadores através das Redes Sociais';
$string['socialnetworks'] = 'Redes Sociais';
$string['sponsor_desc'] = 'Por favor, faça o seu patrocínio através de PayPal, contactando-me através do meu &nbsp;';
$string['sponsor_desc2'] = 'para que o Tema Essential continue a ser desenvolvido, ou apenas para expressar a sua gratidão.';
$string['sponsor_title'] = 'Patrocinar o Tema Essential';
$string['stylefixed'] = 'Estilo fixo';
$string['styleguide'] = 'Guia de estilo';
$string['styleguidedesc'] = 'Código \'{$a->origcodelicenseurl}\' de documentação original licenciada. Holder.js \'{$a->holderlicenseurl}\' é licenciado. Código \'{$a->thiscodelicenseurl}\' adicional licenciado, que é uma licença \'{$a->compatible}\'. Conteúdo \'{$a->contentlicenseurl}\' licenciado. A documentação foi formatada para ser gerada pelo Moodle com a adição de ícones FontAwesome, sempre que apropriado. Poderá encontrar o CSS adicional no ficheiro \'essential_admin_setting_styleguide.php\' abaixo do comentário \'// Beyond docs.css.\'. A secção \'{$a->globalsettings}\' foi removida.';
$string['styleguidesub'] = 'Guia de estilos do Bootstrap V2.3.2';
$string['stylestretch'] = 'Estilo esticado';
$string['styletiled'] = 'Estilo azuleijo';
$string['themecolor'] = 'Cor do Tema';
$string['themecolordesc'] = 'Introduza a Cor que pretende para o Tema. Esta opção vai alterar alguns componentes para refletir a cor escolhida em todo o site Moodle';
$string['themecolors'] = 'Cores do Tema';
$string['themedefaultbuttonbackgroundcolour'] = 'Cor de fundo do botão predefinido';
$string['themedefaultbuttonbackgroundcolourdesc'] = 'Defina a cor de fundo para todos os botões predefinidos.';
$string['themedefaultbuttonbackgroundhovercolour'] = 'Cor de fundo (estado Hover) do botão predefinido';
$string['themedefaultbuttonbackgroundhovercolourdesc'] = 'Defina a cor de fundo para todos os botões predefinidos no estado Hover.';
$string['themedefaultbuttontextcolour'] = 'Cor do texto do botão predefinido';
$string['themedefaultbuttontextcolourdesc'] = 'Defina a cor do texto para todos os botões predefinidos.';
$string['themedefaultbuttontexthovercolour'] = 'Cor do texto dos botões predefinidos no estado Hover';
$string['themedefaultbuttontexthovercolourdesc'] = 'Defina a cor do texto no estado Hover para todos os botões predefinidos.';
$string['themehovercolor'] = 'Cor do Tema (estado: Hover)';
$string['themehovercolordesc'] = 'Introduza uma Cor (para hiperligações, menus, etc) a ser aplicada no estado Hover.';
$string['themeiconcolor'] = 'Cor dos ícones';
$string['themeiconcolordesc'] = 'Defina a cor para todos os ícones.';
$string['themenavcolor'] = 'Cor do texto da Navegação';
$string['themenavcolordesc'] = 'Defina a cor do texto para a navegação, caso a barra de navegação e o trilho de navegação estejam com o estilo Fantasia.';
$string['themestripebackgroundcolour'] = 'Cor de fundo das faixas';
$string['themestripebackgroundcolourdesc'] = 'Definir a cor de fundo para as faixas nas tabelas.';
$string['themestripetextcolour'] = 'Cor do texto das faixas';
$string['themestripetextcolourdesc'] = 'Definir a cor do texto para as faixas nas tabelas.';
$string['themetextcolor'] = 'Cor do texto';
$string['themetextcolordesc'] = 'Defina a cor para o seu texto.';
$string['themeurlcolor'] = 'Cor da Hiperligação (link)';
$string['themeurlcolordesc'] = 'Defina a cor que pretende atribuir às hiperligações textuais.';
$string['thiscourse'] = 'Esta disciplina';
$string['togglemarketing'] = 'Apresentação das Áreas de Marketing';
$string['togglemarketingdesc'] = 'Escolha se pretende ocultar ou mostrar as 3 áreas de Marketing.';
$string['toggleslideshow'] = 'Apresentação do Slideshow';
$string['toggleslideshowdesc'] = 'Escolha se pretende ocultar ou mostrar o Slideshow.';
$string['twitter'] = 'Endereço URL do Twitter';
$string['twitterdesc'] = 'Insira o Endereço URL do Twitter. Exemplo: https://www.twitter.com/mycollege';
$string['twitterurl'] = 'Endereço URL do Twitter';
$string['usermenu'] = 'Menu do utilizador';
$string['usermenudesc'] = 'O menu para o utilizador.';
$string['usesiteicon'] = 'Utilizar o ícone do site';
$string['usesiteicondesc'] = 'Utilizar o ícone do site caso não exista nenhum logotipo.';
$string['variablewidth'] = 'Largura Variável';
$string['versionalerttext1'] = 'Este Tema não foi concebido para esta versão Moodle.';
$string['versionalerttext2'] = 'Poderão ocorrer problemas inesperados, por favor, obtenha a versão correta do Tema para a sua versão Moodle.';
$string['versionalerttitle'] = 'Aviso da versão:';
$string['visibleadminonly'] = 'Os Blocos movidos para esta área serão apenas visíveis pelos Administradores';
$string['vk'] = 'Endereço URL VKontakte';
$string['vkdesc'] = 'Insira o Endereço URL do Vkontakte.';
$string['vkurl'] = 'Endereço URL do VKontakte';
$string['website'] = 'Endereço URL do Website';
$string['websitedesc'] = 'Introduza o endereço URL do seu site. Exemplo: http://www.uplearning.nl';
$string['websiteurl'] = 'Endereço URL do Site';
$string['windows'] = 'Ambiente de Trabalho do Windows';
$string['windowsdesc'] = 'Indique um endereço URL para a sua Aplicação móvel na Windows Store. Caso não possua um, considere introduzir o endereço para a aplicação móvel oficial Moodle Mobile. (http://apps.microsoft.com/windows/en-us/app/9df51338-015c-41b7-8a85-db2fdfb870bc)';
$string['windowsurl'] = 'Endereço URL do Ambiente de trabalho do Windows';
$string['winphone'] = 'Windows Mobile';
$string['winphonedesc'] = 'Indique um endereço URL para a sua Aplicação móvel na Google Play Store. Caso não possua um, considere introduzir o endereço para a aplicação móvel oficial Moodle Mobile. (http://www.windowsphone.com/en-us/store/app/moodlemobile/d0732b88-3c6d-4127-8f24-3fca2452a4dc)';
$string['winphoneurl'] = 'Endereço URL do Windows Mobile';
$string['youtube'] = 'Endereço URL do YouTube';
$string['youtubedesc'] = 'Insira o Endereço URL do YouTube. Exemplo: https://www.youtube.com/user/mycollege';
$string['youtubeurl'] = 'Endereço URL do Youtube';
