<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'ai', language 'zh_cn', version '5.0'.
 *
 * @package     ai
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['acceptai'] = '接受并继续';
$string['action'] = '指令';
$string['action_explain_text'] = '文本说明解释';
$string['action_explain_text_desc'] = '说明解释课程页面上的文本内容';
$string['action_explain_text_instruction'] = '你将收到用户的文本输入。你的任务是对提供的文本进行解释。请遵循以下指南：

     1. 深入阐述：扩展关键思想和概念，确保解释具有实际深度且不直接重复原文。
     2. 简化表达：将复杂术语或概念分解为更简单的组成部分，使其易于广泛受众理解，包括学习者。
     3. 提供背景信息：解释某件事情发生的原因、其工作原理或目的。适当情况下，使用相关示例或类比来增强理解。
     4. 逻辑组织：以自然流畅的结构进行解释，先从基本概念开始，再逐步深入细节。


重要说明：

     1. 仅返回纯文本摘要。
     2. 不要包含任何Markdown格式、问候语或客套话。
     3. 注重清晰性、简洁性和可访问性。


确保解释易于阅读，并有效传达原文的主要要点。';
$string['action_generate_image'] = '生成图像';
$string['action_generate_image_desc'] = '根据文本提示生成图像。';
$string['action_generate_text'] = '生成文本';
$string['action_generate_text_desc'] = '根据文本提示生成文本。';
$string['action_generate_text_instruction'] = '您将收到来自用户的文本输入。您的任务是根据他们的请求生成文本。遵循以下重要指示：
1. 仅以纯文本形式返回摘要。
2. 不要包含任何 markdown 格式、问候或陈词滥调。';
$string['action_summarise_text'] = '总结文本';
$string['action_summarise_text_desc'] = '总结课程页面上的文本内容。';
$string['action_summarise_text_instruction'] = '您将收到来自用户的文本输入。你的任务是总结所提供的文本。遵循以下准则：
    1. 精简：把冗长的段落缩短成重点。
    2. 简化：使复杂的信息更容易理解，尤其是对学习者。

重要说明:
    1. 仅以纯文本形式返回摘要。
    2. 不要包含任何 markdown 格式、问候或陈词滥调。
    3. 专注于清晰、简洁和可访问性。

确保摘要易于阅读，并有效地传达原文的要点。';
$string['action_translate_text'] = '翻译文本';
$string['action_translate_text_desc'] = '将提供的文本从一种语言翻译成另一种语言。';
$string['actionsettingprovider'] = '{$a}指令设置';
$string['actionsettingprovider_desc'] = '这些设置控制{$a->providername}如何提供{$a->actionname}指令。';
$string['actionsettings'] = '指令设置';
$string['actionsettings_desc'] = '这些设置控制此提供者实例的AI指令。';
$string['ai'] = 'AI';
$string['aiactionregister'] = 'AI 指令注册';
$string['aiplacements'] = 'AI 位置';
$string['aipolicyacceptance'] = 'AI 策略允许';
$string['aipolicyregister'] = 'AI 策略注册';
$string['aiproviders'] = 'AI提供者';
$string['aireports'] = 'AI 报告';
$string['aiusage'] = 'AI 使用';
$string['aiusagepolicy'] = 'AI 使用策略';
$string['availableplacements'] = '选择AI指令可用的位置';
$string['availableplacements_desc'] = '位置定义了AI指令可以在你的网站如何以及在哪里使用。您可以通过设置选择每个位置中可用的指令。';
$string['availableproviders'] = '管理连接到您的LMS的AI提供者';
$string['availableproviders_desc'] = 'AI提供者通过“actions”为您的网站添加文本摘要或图像生成AI功能。您可以在它们的设置中管理每个actions的操作。';
$string['btninstancecreate'] = '创建实例';
$string['btninstanceupdate'] = '更新实例';
$string['completiontokens'] = '完成令牌';
$string['completiontokens_help'] = '完成令牌是 AI 模型生成的文本单元，作为对您的输入的响应。较长的响应使用更多的令牌，这可能会花费更多。';
$string['configureprovider'] = '配置提供者实例';
$string['contentwatermark'] = '由AI生成';
$string['createnewprovider'] = '创建一个新的提供者实例';
$string['dateaccepted'] = '接受日期';
$string['declineaipolicy'] = '拒绝';
$string['enableglobalratelimit'] = '设置全站限制量';
$string['enableglobalratelimit_help'] = '限制OpenAI API提供者每小时接收来自全站的请求数量。';
$string['enableuserratelimit'] = '设置用户限制量';
$string['enableuserratelimit_help'] = '限制每一个用户向OpenAI API提供者使用的请求数量。';
$string['error:actionnotfound'] = '不支持操作 \'{$a}\' 。';
$string['error:providernotfound'] = '找不到 AI Provider 实例';
$string['globalratelimit'] = '全站请求的最大数量';
$string['globalratelimit_help'] = '每小时允许的全站请求的数量。';
$string['manageaiplacements'] = '管理 AI 位置';
$string['manageaiproviders'] = '管理AI提供者';
$string['noproviders'] = '此操作不可用。没有为此操作配置 <a href=“{$a}”>AI 提供程序</a>。';
$string['placement'] = '位置';
$string['placementactionsettings'] = '操作';
$string['placementactionsettings_desc'] = '可用于此位置的 AI 操作。';
$string['placementsettings'] = '特定位置的设置';
$string['placementsettings_desc'] = '这些设置控制此 AI 位置如何连接到 AI 服务以及相关操作。';
$string['privacy:metadata:ai_action_explain_text'] = '一个表，用于存储用户发出的解释文本请求。';
$string['privacy:metadata:ai_action_explain_text:completiontoken'] = '用于解释文本的完成标记。';
$string['privacy:metadata:ai_action_explain_text:fingerprint'] = '表示模型和内容的状态/版本的唯一哈希值。';
$string['privacy:metadata:ai_action_explain_text:generatedcontent'] = 'AI 模型基于输入提示生成的实际文本。';
$string['privacy:metadata:ai_action_explain_text:prompt'] = '说明文本请求的提示。';
$string['privacy:metadata:ai_action_explain_text:prompttokens'] = '用于解释文本的提示标记。';
$string['privacy:metadata:ai_action_explain_text:responseid'] = '响应 ID';
$string['privacy:metadata:ai_action_generate_image'] = '一个用于存储用户发出的图像生成请求的表。';
$string['privacy:metadata:ai_action_generate_image:aspectratio'] = '生成的图像的纵横比';
$string['privacy:metadata:ai_action_generate_image:numberimages'] = '生成的图像数';
$string['privacy:metadata:ai_action_generate_image:prompt'] = '请求生成图像的提示词。';
$string['privacy:metadata:ai_action_generate_image:quality'] = '生成的图像质量';
$string['privacy:metadata:ai_action_generate_image:revisedprompt'] = '修改过的生成图像的提示词';
$string['privacy:metadata:ai_action_generate_image:sourceurl'] = '生成图像的源 URL';
$string['privacy:metadata:ai_action_generate_image:style'] = '生成的图像的样式';
$string['privacy:metadata:ai_action_generate_text'] = '一个用于存储用户发出的文本生成请求的表';
$string['privacy:metadata:ai_action_generate_text:completiontoken'] = '用于生成文本的完成标记';
$string['privacy:metadata:ai_action_generate_text:fingerprint'] = '表示模型和内容的状态/版本的唯一哈希值。';
$string['privacy:metadata:ai_action_generate_text:generatedcontent'] = 'AI 模型基于输入提示生成的实际文本。';
$string['privacy:metadata:ai_action_generate_text:prompt'] = '文本生成请求的提示';
$string['privacy:metadata:ai_action_generate_text:prompttokens'] = '用于生成文本的提示标记';
$string['privacy:metadata:ai_action_generate_text:responseid'] = '回答的 ID';
$string['privacy:metadata:ai_action_register'] = '一个用于存储用户发出的操作请求的表';
$string['privacy:metadata:ai_action_register:actionid'] = '操作请求的 ID';
$string['privacy:metadata:ai_action_register:actionname'] = '请求的操作名称';
$string['privacy:metadata:ai_action_register:model'] = '用于生成响应的模型';
$string['privacy:metadata:ai_action_register:provider'] = '处理请求的提供程序的名称';
$string['privacy:metadata:ai_action_register:success'] = '操作请求的状态';
$string['privacy:metadata:ai_action_register:timecompleted'] = '请求的完成时间';
$string['privacy:metadata:ai_action_register:timecreated'] = '请求的创建时间';
$string['privacy:metadata:ai_action_register:userid'] = '发出请求的用户的 ID';
$string['privacy:metadata:ai_action_summarise_text'] = '一个用于存储用户发出的摘要文本请求的表';
$string['privacy:metadata:ai_action_summarise_text:completiontoken'] = '用于总结文本的完成标记';
$string['privacy:metadata:ai_action_summarise_text:fingerprint'] = '表示模型和内容的状态/版本的唯一哈希值。';
$string['privacy:metadata:ai_action_summarise_text:generatedcontent'] = 'AI 模型基于输入提示生成的实际文本';
$string['privacy:metadata:ai_action_summarise_text:prompt'] = '总结文本请求的提示';
$string['privacy:metadata:ai_action_summarise_text:prompttokens'] = '用于总结文本的提示标记';
$string['privacy:metadata:ai_action_summarise_text:responseid'] = '回答的 ID';
$string['privacy:metadata:ai_policy_register'] = '一个存储每个用户的 AI 策略接受状态的表';
$string['privacy:metadata:ai_policy_register:contextid'] = '保存其数据的上下文的 ID';
$string['privacy:metadata:ai_policy_register:timeaccepted'] = '用户接受 AI 策略的时间';
$string['privacy:metadata:ai_policy_register:userid'] = '保存其数据的用户的 ID';
$string['prompttokens'] = '提示词 token';
$string['prompttokens_help'] = '提示token是构成您发送到 AI 模型的输入的文本单元。较长的输入使用更多的token，可能会花费更多。';
$string['provider'] = '提供者';
$string['provideractionsettings'] = '指令';
$string['provideractionsettings_desc'] = '选择并配置 {$a} 可以在您的站点上执行的指令。';
$string['providerinstanceactionupdated'] = '{$a}指令设置已更新';
$string['providerinstancecreated'] = '{$a}AI提供者实例已创建';
$string['providerinstancedelete'] = '删除AI提供者实例';
$string['providerinstancedeleteconfirm'] = '你将删除AI提供者实例：“{$a->name} （{$a->provider}）”。你确定吗？';
$string['providerinstancedeleted'] = '{$a} AI提供者实例已删除';
$string['providerinstancedeletefailed'] = '无法删除 {$a} AI 提供程序实例。提供程序正在使用或存在数据库问题。检查提供程序是否处于活动状态，或者联系数据库管理员寻求帮助。';
$string['providerinstancedisablefailed'] = '无法禁用 AI 提供程序实例。提供程序正在使用或存在数据库问题。检查提供程序是否处于活动状态，或者联系数据库管理员寻求帮助。';
$string['providerinstanceupdated'] = '{$a}AI提供者实例已更新';
$string['providermoveddown'] = '{$a} 下移';
$string['providermovedup'] = '{$a} 上移';
$string['providername'] = '实例名称';
$string['providers'] = '提供者';
$string['providersettings'] = '设置';
$string['providertype'] = '选择AI提供者插件';
$string['timegenerated'] = '生成时间';
$string['unknownvalue'] = '—';
$string['userpolicy'] = '<h4><strong>欢迎使用新的 AI 功能！</strong></h4>
<p>此人工智能 （AI） 功能完全基于外部大型语言模型 （LLM），以改善您的学习和教学体验。在开始使用这些 AI 服务之前，请阅读此使用策略。</p>
<h4><strong>AI 生成内容的准确性</strong></h4>
<p>AI 可以提供有用的建议和信息，但其准确性可能会有所不同。您应该始终仔细检查所提供的信息，以确保其准确、完整且适合您的具体情况。</p>
<h4><strong>您的数据的处理方式</strong></h4>
<p>此 AI 功能使用外部大型语言模型 （LLM）。如果您使用此功能，您共享的任何信息或个人数据都将根据这些 LLM 的隐私政策进行处理。我们建议您阅读他们的隐私政策，了解他们将如何处理您的数据。此外，您与 AI 功能的交互记录可能会保存在此站点中。</p>
<p>如果您对数据的处理方式有疑问，请咨询您的老师或学习机构。</p>
<p>继续，即表示您承认您理解并同意本政策。</p>';
$string['userratelimit'] = '每个用户的最大请求数量';
$string['userratelimit_help'] = '每个用户每小时允许的请求数量。';
