<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'cachestore_memcached', language 'sk', version '5.0'.
 *
 * @package     cachestore_memcached
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['bufferwrites'] = 'Vyrovnávacia pamäť (buffer) je zapisovateľná';
$string['bufferwrites_help'] = 'Aktivuje alebo deaktivuje I/O s vyrovnávacou pamäťou. Aktivovanie I/O s vyrovnávacou pamäťou spôsobí, že príkazy sa budú ukladať do "vyrovnávacej pamäte" namiesto toho, aby sa odoslali. Akákoľvek akcia, ktorá znovu získa dáta spôsobí, že sa táto vyrovnávacia pamäť odošle na vzdialené pripojenie. Ukončenie alebo uzavretie pripojenia takisto spôsobí, že dáta uložené do vyrovnávacej pamäte budú posunuté na vzdialené pripojenie.';
$string['clustered'] = 'Aktivovať združené (clastrované) servery';
$string['clustered_help'] = 'Používa sa na povolenie funkcionality - načítať z jedného a nastaviť na mnohé.

Zámerom pre toto použitie je zdokonalená pamäť pre konfigurácie s rovnomerným rozdelením výkonu. Pamäť sa vyvolá z jedného servera (obyčajne localhost), ale nastaví na mnohé (všetky servery v úložisku s rovnomerne rozdeleným výkonom). Pre vyrovnávacie pamäte s veľmi vysokými pomermi čítania a nastavenia šetrí toto nastavenie významný objem réžie siete.

Keď je toto nastavenie aktivované, server uvedený ako prvý sa bude používať na vyvolanie.';
$string['clusteredheader'] = 'Rozdeliť servery';
$string['hash'] = 'Transformačná metóda';
$string['hash_crc'] = 'CRC';
$string['hash_default'] = 'Štandardne (postupne, po jednom)';
$string['hash_fnv1_32'] = 'FNV1_32';
$string['hash_fnv1_64'] = 'FNV1_64';
$string['hash_fnv1a_32'] = 'FNV1A_32';
$string['hash_fnv1a_64'] = 'FNV1A_64';
$string['hash_help'] = 'Špecifikuje algoritmus transformácie kľúčov použitý pre kľúče položky. Každý algoritmus má svoje výhody a nevýhody. Použite štandardné nastavenie, ak ich nepoznáte alebo je pre vás toto nastavenie irelevantné.';
$string['hash_hsieh'] = 'Hsieh';
$string['hash_md5'] = 'MD5';
$string['hash_murmur'] = 'Murmur';
$string['isshared'] = 'Zdieľaná vyrovnávacia pamäť';
$string['isshared_help'] = 'Je váš server s memcached používaný tiež inými aplikáciami?

Ak je vyrovnávacia pamäť zdieľaná inými aplikáciami, potom každý kľúč bude vymazaný jednotlivo, aby se zaistilo, že sa vyčistia iba údaje vlastnené touto aplikáciou (výstupné externé údaje medzipamäte aplikácie zostanú bez zmeny). To môže mať za následok, v závislosti na konfigurácii serveru, zníženie výkonu pri uvoľňovaní vyrovnávacej pamäti.

Ak je spustená vyhradená vyrovnávacia pamäť pre túto aplikáciu, potom môže byť celá vyrovnávacia pamäť bezpečne odstránená bez akéhokoľvek rizika zničenia údajov medzipamäte ostatných aplikácií. To by malo viesť k zvýšeniu výkonu pri uvoľňovaní medzipamäte.';
$string['pluginname'] = 'Memcached';
$string['prefix'] = 'Predpona kľúča';
$string['prefix_help'] = 'Táto voľba sa môže použiť na vytvorenie "domény" pre kľúče vašej položky, ktorá vám umožní vytvoriť viaceré memcached uloženia na jednej memcached inštalácii. Nemôže byť dlhšia ako 16 znakov, aby sa zaistilo, že sa neobjavia  problémy s dĺžkou kľúčov.';
$string['prefixinvalid'] = 'Neplatná predpona, môžete použiť iba a-z A-Z 0-9-_.';
$string['privacy:metadata:memcached'] = 'Modul Memcached cachestore ukladá údaje krátko ako súčasť svojej funkcie ukladania do medzipamäte. Tieto údaje sú uložené na serveru Memcache, kde sú údaje pravidelne odstraňované.';
$string['privacy:metadata:memcached:data'] = 'Rôzne údaje uložené v medzipamäti';
$string['serialiser_igbinary'] = 'igbinary serializér';
$string['serialiser_json'] = 'JSON serializér';
$string['serialiser_php'] = 'Štandardný PHP serializér';
$string['servers'] = 'Servery';
$string['servers_help'] = 'Táto možnosť nastaví servery, ktoré by mali byť využívané týmto adaptérom memcached. Servery by mali byť definované po jednom na každý riadok a skladajú sa z adresy servera a voliteľne portu a váhy. Ak nie je poskytnutý žiadny port, použije sa štandardný port (11211).

Napríklad:
<pre>
server.url.com
ipaddress:port
servername:port:weight
</pre>';
$string['serversclusterinvalid'] = 'Keď je aktivované združovanie (clustering), požaduje sa presne jeden server.';
$string['sessionhandlerconflict'] = 'UPOZORNENIE: Inštancia memcached ({$a}) bola konfigurovaná tak, aby používala rovnaký memcached server ako relácie. Vyčistenie všetkých vyrovnávacích pamätí povedie k tomu, že sa odstránia aj relácie.';
$string['setservers'] = 'Nastaviť servery';
$string['setservers_help'] = 'Toto je zoznam serverov, ktorý sa aktualizuje pri modifikácii dát vo vyrovnávacej pamäti. Vo všeobecnosti plne kvalifikovaný názov každého servera v úložisku.

**Musí** obsahovať server uvedený v *Serveroch* vyššie, dokonca aj keď majú rôzne názvy hostiteľov (hostname).

Servery by mali byť definované po jednom na riadok a skladajú sa z adresy servera a voliteľne portu.
Ak nie je uvedený žiadny port, potom sa použije štandardne predvolený port (11211).

Napríklad:
<pre>
server.url.com
ipaddress:port
</pre>';
$string['testservers'] = 'Testovacie servery';
$string['testservers_desc'] = 'Jeden alebo viac reťazcov pripojenia pre memcached servery na otestovanie. Ak bol špecifikovaný testovací server, potom je možné výkon memcached otestovať použitím stránky výkonu vyrovnávacej pamäte v bloku administrácie. Napríklad: 127.0.0.1:11211';
$string['upgrade200recommended'] = 'Odporúčame vám upgradovať Memcached rozšírenie PHP verzie 2.0.0 alebo vyššej.
Verzia rozšírenia Memcached PHP, ktorý práve používate, neposkytuje funkčnosť Moodle, používa k zaisteniu izolovanú medzipamäť. Do upgradu odporúčame nekonfigurovať všetky ostatné aplikácie používajúce rovnaké Memcached servery, ako je nakonfigurovaný Moodle.';
$string['usecompression'] = 'Použiť kompresiu';
$string['usecompression_help'] = 'Aktivuje alebo deaktivuje kompresiu užitočného zaťaženia. Ak je táto možnosť aktivovaná, hodnoty nad určitý limit (aktuálne 100 bytov) budú skomprimované počas ukladania a počas obnovenia prehľadne dekomprimované.';
$string['useserialiser'] = 'Použiť serializér';
$string['useserialiser_help'] = 'Špecifikuje serializér, ktorý sa použije na serializovanie neskalárnych hodnôt. Platné serializéry sú Memcached::SERIALIZER_PHP alebo Memcached::SERIALIZER_IGBINARY. Druhý je podporovaný iba vtedy, keď je spolu s ním nakonfigurovaný memcached - načíta sa možnosť enable-memcached-igbinary a rozšírenie igbinary.';
