<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'bigbluebuttonbn', language 'da', version '5.0'.
 *
 * @package     bigbluebuttonbn
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityoverview'] = 'Du har kommende BigBlueButton sessioner';
$string['bbbduetimeoverstartingtime'] = 'Lukketid skal være senere end åbningstid.';
$string['bbbdurationwarning'] = 'Den maksimale varighed for denne session er %duration% minutter.';
$string['bbbrecordallfromstartwarning'] = 'Denne session optages fra starten.';
$string['bbbrecordwarning'] = 'Denne session kan optages.';
$string['bigbluebuttonbn'] = 'BigBlueButton';
$string['bigbluebuttonbn:addinstance'] = 'Tilføj et nyt BigBlueButton rum';
$string['bigbluebuttonbn:addinstancewithmeeting'] = 'Opret live sessioner instans';
$string['bigbluebuttonbn:addinstancewithrecording'] = 'Opret instans med optagelser';
$string['bigbluebuttonbn:deleterecordings'] = 'Slet optagelser';
$string['bigbluebuttonbn:importrecordings'] = 'Importér optagelser';
$string['bigbluebuttonbn:join'] = 'Deltag i et BigBlueButton rum';
$string['bigbluebuttonbn:managerecordings'] = 'Administrer optagelser';
$string['bigbluebuttonbn:protectrecordings'] = 'Beskyt optagelser';
$string['bigbluebuttonbn:publishrecordings'] = 'Udgiv optagelser';
$string['bigbluebuttonbn:seepresentation'] = 'Altid se præsentationsfil på aktivitetsiden';
$string['bigbluebuttonbn:unprotectrecordings'] = 'Fjern beskyttelse af optagelser';
$string['bigbluebuttonbn:unpublishrecordings'] = 'Skjul optagelser';
$string['bigbluebuttonbn:view'] = 'Se BigBlueButton rum';
$string['bigbluebuttonbn:viewallrecordingformats'] = 'Se alle optagelsesformater';
$string['cachedef_currentfetch'] = 'Data for at liste enhver nyligt hentet optagelse.';
$string['cachedef_recordings'] = 'Optagelse metadata';
$string['cachedef_serverinfo'] = 'Fjernserver information';
$string['cachedef_subplugins'] = 'Cache bruges af subplugin-rutiner til at accelerere, når nødvendigt, plugin-opdagelsesprocessen.';
$string['cachedef_validatedurls'] = 'Cache af validerede URL-kontroller';
$string['calendarstarts'] = '{$a} er planlagt til';
$string['cannotperformaction'] = 'Kan ikke udføre handling {$a} på denne optagelse';
$string['completionattendance'] = 'Kræv tilstedeværelse (minutter)';
$string['completionattendance_desc'] = 'Indtast og forbliv i rummet i mindst {$a} minut(ter).';
$string['completionattendance_event_desc'] = 'Studenten har indtastet rummet og forbliver i sessionen i mindst {$a} minut(ter)';
$string['completionattendancegroup'] = 'Kræv tilstedeværelse (minutter)';
$string['completionengagement_desc'] = 'Deltag i aktiviteter under mødet.';
$string['completionengagementchats'] = 'Chats';
$string['completionengagementchats_desc'] = 'Deltage i {$a} chat(s).';
$string['completionengagementchats_event_desc'] = 'Har startet {$a} chat(s)';
$string['completionengagementemojis'] = 'Emojis';
$string['completionengagementemojis_desc'] = 'Skift deres emoji {$a} gang(e).';
$string['completionengagementemojis_event_desc'] = 'Har ændret deres emoji {$a} gang(e)';
$string['completionengagementgroup'] = 'Kræv deltagelse';
$string['completionengagementpollvotes'] = 'Afstemningsstemmer';
$string['completionengagementpollvotes_desc'] = 'Stemme i afstemninger {$a} gang(e).';
$string['completionengagementpollvotes_event_desc'] = 'Har svaret {$a} afstemningsstemme(er)';
$string['completionengagementraisehand'] = 'Kræv løftet hånd';
$string['completionengagementraisehand_desc'] = 'Løfte hånd {$a} gang(e).';
$string['completionengagementraisehand_event_desc'] = 'Har løftet hånd {$a} gange';
$string['completionengagementtalks'] = 'Tal';
$string['completionengagementtalks_desc'] = 'Tale {$a} gang(e)';
$string['completionengagementtalks_event_desc'] = 'Har startet {$a} snak(ke)';
$string['completionupdatestate'] = 'Opdater fuldførelsestilstand';
$string['completionvalidatestate'] = 'Valider fuldførelse';
$string['completionvalidatestatetriggered'] = 'Valider fuldførelse er blevet udløst.';
$string['completionview_event_desc'] = 'Har set rummet.';
$string['config_checksum_algorithm'] = 'BigBlueButton server checksum algoritme';
$string['config_checksum_algorithm_description'] = 'SHA1 er kompatibel med ældre servere. SHA256 og SHA512 er mere sikre. SHA512 er FIPS 140-2 kompatibel.';
$string['config_default_messages'] = 'Standard beskeder';
$string['config_default_messages_description'] = 'Sæt standardbeskeder til aktiviteter';
$string['config_disablecam_default'] = 'Deaktiver webcam aktiveret som standard';
$string['config_disablecam_default_description'] = 'Hvis aktiveret, vil webcamene være deaktiveret.';
$string['config_disablecam_editable'] = 'Deaktiver webcam kan redigeres';
$string['config_disablecam_editable_description'] = 'Deaktiver webcam som standard kan redigeres, når instansen tilføjes eller opdateres.';
$string['config_disablemic_default'] = 'Deaktiver mikrofon aktiveret som standard';
$string['config_disablemic_default_description'] = 'Hvis aktiveret, vil mikrofonerne være deaktiveret.';
$string['config_disablemic_editable'] = 'Deaktiver mikrofon kan redigeres';
$string['config_disablemic_editable_description'] = 'Deaktiver mikrofon som standard kan redigeres, når instansen tilføjes eller opdateres.';
$string['config_disablenote_default'] = 'Deaktiver delte noter aktiveret som standard';
$string['config_disablenote_default_description'] = 'Hvis aktiveret, vil de delte noter være deaktiveret.';
$string['config_disablenote_editable'] = 'Deaktiver delte noter kan redigeres';
$string['config_disablenote_editable_description'] = 'Deaktiver delte noter som standard kan redigeres, når instansen tilføjes eller opdateres.';
$string['config_disableprivatechat_default'] = 'Deaktiver privat chat aktiveret som standard';
$string['config_disableprivatechat_default_description'] = 'Hvis aktiveret, vil den private chat være deaktiveret.';
$string['config_disableprivatechat_editable'] = 'Deaktiver privat chat kan redigeres';
$string['config_disableprivatechat_editable_description'] = 'Deaktiver privat chat som standard kan redigeres, når instansen tilføjes eller opdateres.';
$string['config_disablepublicchat_default'] = 'Deaktiver offentlig chat aktiveret som standard';
$string['config_disablepublicchat_default_description'] = 'Hvis aktiveret, vil den offentlige chat være deaktiveret.';
$string['config_disablepublicchat_editable'] = 'Deaktiver offentlig chat kan redigeres';
$string['config_disablepublicchat_editable_description'] = 'Deaktiver offentlig chat som standard kan redigeres, når instansen tilføjes eller opdateres.';
$string['config_experimental_features'] = 'Eksperimentelle funktioner';
$string['config_experimental_features_description'] = 'Konfiguration for eksperimentelle funktioner.';
$string['config_extended_capabilities'] = 'Udvidede kapabiliteter';
$string['config_extended_capabilities_description'] = 'Konfiguration for udvidede kapabiliteter, når BigBlueButton-serveren tilbyder dem.';
$string['config_general'] = 'Generelle indstillinger';
$string['config_general_description'] = 'For at opsætte BigBlueButton kan du enten bruge din egen BigBlueButton server og oplysninger, eller få oplysninger gennem <a href="https://registration-portal.blindsidenetworks.com/" target="_blank">Blindside Networks Registreringsportal (åbner i et nyt vindue)</a>.';
$string['config_guestaccess_enabled'] = 'Ekstern gæsteadgang';
$string['config_guestaccess_enabled_description'] = 'Tillad brugere uden en konto på dit site at få adgang til rummet.';
$string['config_hideuserlist_default'] = 'Skjul bruger liste aktiveret som standard';
$string['config_hideuserlist_default_description'] = 'Hvis aktiveret, vil sessions brugerlisten være skjult.';
$string['config_hideuserlist_editable'] = 'Skjul bruger liste kan redigeres';
$string['config_hideuserlist_editable_description'] = 'Skjul bruger liste som standard kan redigeres, når instansen tilføjes eller opdateres.';
$string['config_importrecordings'] = 'Importér optagelser';
$string['config_importrecordings_description'] = 'Disse indstillinger er funktionsspecifikke.';
$string['config_importrecordings_enabled'] = 'Importér optagelser aktiveret';
$string['config_importrecordings_enabled_description'] = 'Når dette og optagelsesfunktionen er aktiveret, er det muligt at importere optagelser fra forskellige kurser til en aktivitet.';
$string['config_importrecordings_from_deleted_enabled'] = 'Importér optagelser fra slettede aktiviteter aktiveret';
$string['config_importrecordings_from_deleted_enabled_description'] = 'Når dette og funktionen til import af optagelser er aktiveret, er det muligt at importere optagelser fra aktiviteter, der ikke længere er i kurset.';
$string['config_locksettings'] = 'Konfiguration for låse indstillinger';
$string['config_locksettings_description'] = 'Disse indstillinger kan aktivere eller deaktivere muligheder i brugergrænsefladen til låseindstillinger, og også definere standardværdier for disse muligheder.';
$string['config_meetingevents_enabled'] = 'Registrér live sessioner';
$string['config_meetingevents_enabled_description'] = 'Hvis aktiveret, bliver live sessioner behandlet efter sessionens afslutning. Denne funktion kræves til Aktivitet fuldførelse og fungerer kun, hvis BigBlueButton serveren er i stand til at behandle post_events scripts.';
$string['config_muteonstart'] = 'Lydløs ved start';
$string['config_muteonstart_default'] = 'Lydløs ved start aktiveret som standard';
$string['config_muteonstart_default_description'] = 'Hvis aktiveret vil sessionen være lydløs ved start.';
$string['config_muteonstart_description'] = 'Disse indstillinger kan aktivere eller deaktivere muligheder i brugergrænsefladen og også definere standardværdier for disse muligheder.';
$string['config_muteonstart_editable'] = 'Lydløs ved start kan redigeres';
$string['config_muteonstart_editable_description'] = 'Lydløs ved start som standard kan redigeres, når instansen tilføjes eller opdateres.';
$string['config_participant'] = 'Deltagere';
$string['config_participant_description'] = 'Disse indstillinger definerer standardrollen for deltagere.';
$string['config_participant_moderator_default'] = 'Moderator';
$string['config_participant_moderator_default_description'] = 'Denne regel bruges som standard, når et nyt rum tilføjes.';
$string['config_poll_interval'] = 'Afbryderinterval (i sekunder) for at opdatere rummets status';
$string['config_poll_interval_description'] = 'Afbryderintervallet skal være mindst 2 sekunder. Hvis nødvendigt, kan du reducere belastningen på den eksterne server ved at øge intervallet.';
$string['config_presentation_default'] = 'Standard præsentationsfil';
$string['config_presentation_default_description'] = 'En fil kan stilles til rådighed til brug i alle rum.';
$string['config_preuploadpresentation'] = 'Præsentationsfil';
$string['config_preuploadpresentation_description'] = 'Disse indstillinger kan aktivere eller deaktivere muligheder i brugergrænsefladen og også definere standardværdier for disse muligheder. Funktionen fungerer kun, hvis Moodle serveren er tilgængelig for BigBlueButton.';
$string['config_preuploadpresentation_editable'] = 'Præsentationsfil på aktivitetsside';
$string['config_preuploadpresentation_editable_description'] = 'Mulighed i aktivitetsindstillingerne for at uploade præsentationsfil, der skal vises på aktivitetssiden.';
$string['config_profile_picture_enabled'] = 'Vis profilbilleder';
$string['config_profile_picture_enabled_description'] = 'Skal profilbilleder af deltagere vises i BigBlueButton sessioner?';
$string['config_recording'] = 'Optagelse';
$string['config_recording_all_from_start_default'] = 'Start optagelse fra begyndelsen';
$string['config_recording_all_from_start_default_description'] = 'Skal indstillingen \'Start optagelse fra begyndelsen\' være aktiveret som standard når man tilføjer et nyt BigBlueButton rum?';
$string['config_recording_all_from_start_editable'] = 'Start optagelse fra begyndelsen redigerbar';
$string['config_recording_all_from_start_editable_description'] = 'Skal \'Start optagelse fra begyndelsen\' være redigerbar i BigBlueButton aktivitetindstillinger?';
$string['config_recording_default'] = 'Optagelse aktiveret som standard';
$string['config_recording_default_description'] = 'Skal indstillingen \'Session kan optages\' være aktiveret som standard når man tilføjer et nyt BigBlueButton rum?';
$string['config_recording_description'] = 'Disse indstillinger er funktionsspecifikke';
$string['config_recording_editable'] = 'Session kan optages redigerbar';
$string['config_recording_editable_description'] = 'Skal \'Session kan optages\' være redigerbar i BigBlueButton aktivitetindstillinger?';
$string['config_recording_hide_button_default'] = 'Skjul optagelsesknap';
$string['config_recording_hide_button_default_description'] = 'Hvis markeret vil knappen til optagelse være skjult';
$string['config_recording_hide_button_editable'] = 'Skjul optagelsesknap redigerbar';
$string['config_recording_hide_button_editable_description'] = 'Skal \'Skjul optagelsesknap\' være redigerbar i BigBlueButton aktivitetindstillinger?';
$string['config_recording_protect_editable'] = 'Beskyttet optagelsestilstand kan redigeres';
$string['config_recording_protect_editable_description'] = 'Hvis markeret inkluderer interfacet en mulighed for at beskytte/fjerne beskyttelse af optagelser.';
$string['config_recording_refresh_period'] = 'Optagelsesopdateringsperiode (i sekunder)';
$string['config_recording_refresh_period_description'] = 'Hvor ofte skal BigBlueButton serveren forespørges for at opdatere fjerninformation for en optagelse?';
$string['config_recording_safe_formats'] = 'Optagelsesformater kan ses af alle';
$string['config_recording_safe_formats_description'] = 'Vælg de formater, der kan ses af alle.
Alle andre formater kan kun ses af lærere og andre brugere med mod/bigbluebuttonbn:viewallrecordingformats og
 mod/bigbluebuttonbn:managerecordings kapabiliteterne.';
$string['config_recordingready_enabled'] = 'Send optagelses tilgængelig notifikation';
$string['config_recordingready_enabled_description'] = 'Hvis aktiveret, sendes en notifikation, når der er et optagelseslink tilgængeligt. Denne funktion kræver, at scriptet post_publish_recording_ready_callback er aktiveret på BigBlueButton serveren.';
$string['config_recordings'] = 'Vis optagelser';
$string['config_recordings_asc_sort'] = 'List optagelser i kronologisk rækkefølge';
$string['config_recordings_asc_sort_description'] = 'Optagelserne er sorteret efter dato, enten kronologisk eller omvendt kronologisk rækkefølge (seneste optagelse først).';
$string['config_recordings_deleted_default'] = 'Inkluder optagelser fra slettede aktiviteter aktiveret som standard';
$string['config_recordings_deleted_default_description'] = 'Hvis aktiveret, vil optagelsestabellen inkludere optagelser af enhver aktivitet, som siden er blevet slettet.';
$string['config_recordings_deleted_editable'] = 'Inkluder optagelser fra slettede aktiviteter kan redigeres';
$string['config_recordings_deleted_editable_description'] = 'Inkluder optagelser fra slettede aktiviteter som standard kan redigeres, når instansen tilføjes eller opdateres.';
$string['config_recordings_description'] = 'Disse indstillinger er funktionsspecifikke';
$string['config_recordings_general'] = 'Vis optagelsesindstillinger';
$string['config_recordings_general_description'] = 'Disse indstillinger anvendes kun, når optagelser vises';
$string['config_recordings_imported_default'] = 'Vis kun importerede links aktiveret som standard';
$string['config_recordings_imported_default_description'] = 'Hvis aktiveret vil optagelsestabellen kun inkludere de importerede links til optagelser.';
$string['config_recordings_imported_editable'] = 'Vis kun importerede links kan redigeres';
$string['config_recordings_imported_editable_description'] = 'Vis kun importerede links som standard kan redigeres, når instansen tilføjes eller opdateres.';
$string['config_recordings_preview_default'] = 'Forhåndsvisning er aktiveret som standard';
$string['config_recordings_preview_default_description'] = 'Hvis aktiveret inkluderer tabellen en forhåndsvisning af præsentationen.';
$string['config_recordings_preview_editable'] = 'Forhåndsvisningsfunktion kan redigeres';
$string['config_recordings_preview_editable_description'] = 'Forhåndsvisningsfunktionen kan redigeres, når instansen tilføjes eller opdateres.';
$string['config_scheduled'] = 'Planlagte sessioner';
$string['config_scheduled_description'] = 'Disse indstillinger definerer standardadfærd for planlagte sessioner.';
$string['config_scheduled_pre_opening'] = 'Tilgængelig før åbningstid';
$string['config_scheduled_pre_opening_description'] = 'Tiden i minutter, som rummet er åbent før den planlagte åbningstid.';
$string['config_server_url'] = 'BigBlueButton server URL';
$string['config_server_url_description'] = 'URL til din BigBlueButton server.';
$string['config_shared_secret'] = 'BigBlueButton delt hemmelighed';
$string['config_shared_secret_description'] = 'Sikkerhedssekretessen til din BigBlueButton server.';
$string['config_showpresentation_default'] = 'Vis præsentationsfil på aktivitetsside';
$string['config_showpresentation_default_description'] = 'Skal studerende have adgang til præsentationsfilen før sessionen? Denne indstilling har ingen effekt på brugere med kapabiliteten \'Altid se præsentationsfil på aktivitetsside\' .';
$string['config_showpresentation_editable'] = '\'Vis præsentationsfil på aktivitetsside\' mulighed';
$string['config_showpresentation_editable_description'] = 'Mulighed i aktivitetsindstillingerne for lærere til at vælge, om de vil vise præsentationsfilen til studerende.';
$string['config_uidelegation_enabled'] = 'UI delegering er aktiveret';
$string['config_uidelegation_enabled_description'] = 'Disse indstillinger aktiverer eller deaktiverer UI delegering til BigBlueButton serveren.';
$string['config_userlimit'] = 'Brugergrænse';
$string['config_userlimit_default'] = 'Brugergrænse aktiveret som standard';
$string['config_userlimit_default_description'] = 'Antallet af brugere, der er tilladt i en session som standard, når et nyt rum tilføjes. Sæt til 0 for at tillade et ubegrænset antal brugere.';
$string['config_userlimit_description'] = 'Disse indstillinger kan aktivere eller deaktivere muligheder i brugergrænsefladen og også definere standardværdier for disse muligheder.';
$string['config_userlimit_editable'] = 'Brugergrænse funktion kan redigeres';
$string['config_userlimit_editable_description'] = 'Brugergrænseværdi som standard kan redigeres, når rummet eller konferencen tilføjes eller opdateres.';
$string['config_voicebridge'] = 'Voice bridge';
$string['config_voicebridge_description'] = 'Disse indstillinger kan aktivere eller deaktivere muligheder i brugergrænsefladen og også definere standardværdier for disse muligheder.';
$string['config_voicebridge_editable'] = 'Konferences Voice Bridge kan redigeres';
$string['config_voicebridge_editable_description'] = 'Et konference Voice Bridge nummer kan permanent tildeles et rum. Når tildelt, kan nummeret ikke bruges til noget andet rum.';
$string['config_waitformoderator'] = 'Vent på moderator';
$string['config_waitformoderator_cache_ttl'] = 'Vent på moderator cache TTL (sekunder)';
$string['config_waitformoderator_cache_ttl_description'] = 'For at understøtte en stor belastning af klienter gør dette plugin brug af en cache. Denne parameter definerer, hvor længe cachen vil blive opbevaret, før næste forespørgsel sendes til BigBlueButton serveren.';
$string['config_waitformoderator_default'] = 'Vent på moderator aktiveret som standard';
$string['config_waitformoderator_default_description'] = 'Skal indstillingen \'Vent på moderator\' være aktiveret som standard når man tilføjer et nyt BigBlueButton rum?';
$string['config_waitformoderator_description'] = 'Disse indstillinger er funktionsspecifikke';
$string['config_waitformoderator_editable'] = 'Vent på moderator redigerbar';
$string['config_waitformoderator_editable_description'] = 'Skal \'Vent på moderator\' være redigerbar i BigBlueButton aktivitetindstillinger?';
$string['config_waitformoderator_ping_interval'] = 'Vent på moderator ping (sekunder)';
$string['config_waitformoderator_ping_interval_description'] = 'Hvor ofte skal serveren forespørges for at kontrollere, om moderatoren er kommet ind i rummet?';
$string['config_warning_bigbluebuttonbn_cfg_deprecated'] = 'BigBlueButton anvender config.php med en global variabel, der er forældet. Konverter venligst filen, da den ikke vil blive understøttet i fremtidige versioner.';
$string['config_warning_curl_not_installed'] = 'Denne funktion kræver, at CURL-udvidelsen er installeret og aktiveret. Indstillingerne vil kun være tilgængelige, hvis denne betingelse er opfyldt.';
$string['config_welcome_default'] = 'Standard velkomstbesked';
$string['config_welcome_default_description'] = 'Velkomstbeskeden vises, når deltagere kommer ind i rummet. Hvis feltet efterlades tomt, anvendes sprogstrengen \'mod_form_field_welcome_default\'.';
$string['config_welcome_editable'] = 'Standard velkomstbesked kan redigeres af lærere';
$string['config_welcome_editable_description'] = 'Velkomstbesked kan redigeres, når instansen tilføjes eller opdateres';
$string['credentials_warning'] = 'Brugen af standard serveroplysninger vil snart udløbe (se ovenstående note for at få nye oplysninger).';
$string['end_session_confirm'] = 'Er du sikker på, at du vil afslutte sessionen?';
$string['end_session_confirm_title'] = 'Virkelig afslut session?';
$string['end_session_notification'] = 'Sessionen er afsluttet.';
$string['ends_at'] = 'Slutter';
$string['event_activity_created'] = 'Aktivitet oprettet';
$string['event_activity_deleted'] = 'Aktivitet slettet';
$string['event_activity_updated'] = 'Aktivitet opdateret';
$string['event_live_session'] = 'Live session hændelse';
$string['event_meeting_created'] = 'Møde oprettet';
$string['event_meeting_ended'] = 'Møde afsluttet';
$string['event_meeting_joined'] = 'Møde tilsluttet';
$string['event_meeting_left'] = 'Møde forladt';
$string['event_recording_deleted'] = 'Optagelse slettet';
$string['event_recording_edited'] = 'Optagelse redigeret';
$string['event_recording_imported'] = 'Optagelse importeret';
$string['event_recording_protected'] = 'Optagelse beskyttet';
$string['event_recording_published'] = 'Optagelse udgivet';
$string['event_recording_unprotected'] = 'Optagelse ubeskyttet';
$string['event_recording_unpublished'] = 'Optagelse skjult';
$string['event_recording_viewed'] = 'Optagelse set';
$string['event_unknown'] = 'Ukendt hændelse';
$string['general_error_cannot_create_meeting'] = 'Kan ikke oprette session.';
$string['general_error_cannot_get_recordings'] = 'Kan ikke hente optagelser.';
$string['general_error_no_answer'] = 'Tomt svar. Kontroller venligst BigBlueButton serverens URL OG kontroller, om BigBlueButton serveren kører.';
$string['general_error_not_allowed_to_create_instances'] = 'Brugeren har ikke tilladelse til at oprette nogen instanstype.';
$string['general_error_not_found'] = 'Kan ikke finde BigBlueButton aktiviteten med ID {$a}.';
$string['general_error_unable_connect'] = 'Kan ikke oprette forbindelse. Kontroller venligst BigBlueButton serverens URL OG kontroller, om BigBlueButton serveren kører.
Detaljer : {$a}';
$string['guest_invitation_full_message'] = 'Hej,
<p>Du er inviteret til en BigBlueButton session <strong>{$a->name}</strong> i kurset {$a->course_fullname}.</p>
<p>Link: {$a->guestjoinurl}<br/>
<p>Adgangskode: {$a->guestpassword}</p>
<p>Hvis du har brug for hjælp, kontakt venligst {$a->sender}.</p>';
$string['guest_invitation_small_message'] = 'Hej,

Du er inviteret til en BigBlueButton session {$a->name} i kurset {$a->course_fullname}.

Link: {$a->guestjoinurl}
Adgangskode: {$a->guestpassword}

Hvis du har brug for hjælp, kontakt venligst {$a->sender}.';
$string['guest_invitation_subject'] = 'Invitation: {$a->name} session i {$a->course_fullname}';
$string['guestaccess_activitynotfound'] = 'Aktivitet ikke fundet.';
$string['guestaccess_add'] = 'Tilføj gæster';
$string['guestaccess_add_no_id'] = 'Intet BigBlueButton instans ID angivet.';
$string['guestaccess_copy_link'] = 'Kopier link';
$string['guestaccess_copy_password'] = 'Kopier adgangskode';
$string['guestaccess_emails'] = 'Gæstemails';
$string['guestaccess_emails_help'] = 'En liste over e-mailadresser, adskilt med kommaer.';
$string['guestaccess_emails_invalidemail'] = 'Ugyldig e-mail: {$a}';
$string['guestaccess_feature_disabled'] = 'Gæsteadgang deaktiveret.';
$string['guestaccess_invite_failure'] = 'Fejl {$a->errors} ved invitation af {$a->emails}.';
$string['guestaccess_invite_success'] = 'En invitation vil blive sendt til {$a->emails}.';
$string['guestaccess_join_meeting'] = 'Deltag i mødet';
$string['guestaccess_meeting_invalid_password'] = 'Forkert adgangskode.';
$string['guestaccess_meeting_link'] = 'Møde link';
$string['guestaccess_meeting_not_started'] = 'Mødet er endnu ikke startet. Kom venligst tilbage senere.';
$string['guestaccess_meeting_password'] = 'Møde adgangskode';
$string['guestaccess_password'] = 'Adgangskode';
$string['guestaccess_title'] = 'Tilføj gæster til dette møde';
$string['guestaccess_username'] = 'Gæste brugernavn';
$string['index_confirm_end'] = 'Vil du afslutte sessionen?';
$string['index_disabled'] = 'deaktiveret';
$string['index_enabled'] = 'aktiveret';
$string['index_ending'] = 'Afslutter session ... vent venligst';
$string['index_error_bbtn'] = 'BigBlueButton ID {$a} er forkert';
$string['index_error_checksum'] = 'Der opstod en checksumfejl. Kontroller venligst, at du indtastede den korrekte hemmelighed.';
$string['index_error_forciblyended'] = 'Kan ikke deltage i sessionen, fordi den er blevet afsluttet manuelt.';
$string['index_error_noinstances'] = 'Der er ingen instanser af BigBlueButton rum';
$string['index_error_unable_display'] = 'Kan ikke vise sessioner. Kontroller venligst BigBlueButton serverens URL OG kontroller, om BigBlueButton serveren kører.';
$string['index_heading'] = 'BigBlueButton rum';
$string['index_heading_actions'] = 'Handlinger';
$string['index_heading_group'] = 'Gruppe';
$string['index_heading_moderator'] = 'Moderatører';
$string['index_heading_name'] = 'Rum';
$string['index_heading_recording'] = 'Optagelse';
$string['index_heading_users'] = 'Brugere';
$string['index_heading_viewer'] = 'Seere';
$string['indicator:cognitivedepth'] = 'BigBlueButton kognitiv';
$string['indicator:cognitivedepth_help'] = 'Denne indikator er baseret på den kognitive dybde, som eleven når i en BigBlueButton aktivitet.';
$string['indicator:socialbreadth'] = 'BigBlueButton social';
$string['indicator:socialbreadth_help'] = 'Denne indikator er baseret på den sociale bredde, som eleven når i en BigBlueButton aktivitet.';
$string['instance_type_default'] = 'Rum med optagelser';
$string['instance_type_recording_only'] = 'Kun optagelser';
$string['instance_type_room_only'] = 'Kun rum';
$string['instanceprofilewithoutrecordings'] = 'Denne instansprofil kan ikke vise optagelser';
$string['managebbbextplugins'] = 'Administrer BigBlueButton udvidelses plugins';
$string['messageprovider:instance_updated'] = 'BigBlueButton session opdateret';
$string['messageprovider:recording_ready'] = 'BigBlueButton optagelse tilgængelig';
$string['minute'] = 'minut';
$string['minutes'] = 'minutter';
$string['mod_form_block_general'] = 'Generel';
$string['mod_form_block_guestaccess'] = 'Gæsteadgang';
$string['mod_form_block_participants'] = 'Rolle tildelt under live session';
$string['mod_form_block_presentation'] = 'Præsentationsindhold';
$string['mod_form_block_presentation_default'] = 'Standard præsentationsindhold';
$string['mod_form_block_record'] = 'Optage indstillinger';
$string['mod_form_block_recordings'] = 'Optagelsesvisning';
$string['mod_form_block_room'] = 'Rum indstillinger';
$string['mod_form_block_schedule'] = 'Session timing';
$string['mod_form_field_closingtime'] = 'Luk';
$string['mod_form_field_conference_name'] = 'Session navn';
$string['mod_form_field_disablecam'] = 'Deaktiver webcams';
$string['mod_form_field_disablemic'] = 'Deaktiver mikrofoner';
$string['mod_form_field_disablenote'] = 'Deaktiver delte noter';
$string['mod_form_field_disableprivatechat'] = 'Deaktiver privat chat';
$string['mod_form_field_disablepublicchat'] = 'Deaktiver offentlig chat';
$string['mod_form_field_duration'] = 'Varighed';
$string['mod_form_field_duration_help'] = 'Indstilling af varigheden for et møde vil etablere den maksimale tid for et møde at forblive i live, før optagelsen slutter';
$string['mod_form_field_guestallowed'] = 'Tillad gæsteadgang';
$string['mod_form_field_hideuserlist'] = 'Skjul bruger liste';
$string['mod_form_field_instanceprofiles'] = 'Instance type';
$string['mod_form_field_instanceprofiles_help'] = 'Hvis en session skal optages, vælg \'Rum med optagelser\', ellers \'Rum kun\'. Efter en session er optaget, hvis der ikke skal være flere sessioner, vælg \'Optagelser kun\'.';
$string['mod_form_field_intro'] = 'Beskrivelse';
$string['mod_form_field_intro_help'] = 'En kort beskrivelse af rummet.';
$string['mod_form_field_mustapproveuser'] = 'Gæster der deltager, skal godkendes af en moderator';
$string['mod_form_field_muteonstart'] = 'Lydløs ved start';
$string['mod_form_field_name'] = 'Rumnavn';
$string['mod_form_field_nosettings'] = 'Ingen indstillinger kan redigeres';
$string['mod_form_field_openingtime'] = 'Åben';
$string['mod_form_field_participant_add'] = 'Tilføj tildeling';
$string['mod_form_field_participant_bbb_role_moderator'] = 'Moderator';
$string['mod_form_field_participant_bbb_role_viewer'] = 'Seer';
$string['mod_form_field_participant_list'] = 'Tildeling';
$string['mod_form_field_participant_list_action_add'] = 'Tilføj';
$string['mod_form_field_participant_list_action_remove'] = 'Fjern';
$string['mod_form_field_participant_list_text_as'] = 'deltager i sessionen som';
$string['mod_form_field_participant_list_type_all'] = 'Alle registrerede brugere';
$string['mod_form_field_participant_list_type_owner'] = 'Ejer';
$string['mod_form_field_participant_list_type_role'] = 'Rolle';
$string['mod_form_field_participant_list_type_user'] = 'Bruger';
$string['mod_form_field_record'] = 'Sessionen kan optages.';
$string['mod_form_field_recordallfromstart'] = 'Optag alt fra start';
$string['mod_form_field_recordhidebutton'] = 'Skjul optagelsesknap';
$string['mod_form_field_recordings_deleted'] = 'Inkluder optagelser fra slettede aktiviteter';
$string['mod_form_field_recordings_html'] = 'Vis tabellen i plain HTML';
$string['mod_form_field_recordings_imported'] = 'Vis kun importerede links';
$string['mod_form_field_recordings_preview'] = 'Vis optagelsesforhåndsvisning';
$string['mod_form_field_room_name'] = 'Rumnavn';
$string['mod_form_field_showpresentation'] = 'Vis præsentationsfil på aktivitetsside';
$string['mod_form_field_userlimit'] = 'Brugergrænse';
$string['mod_form_field_userlimit_help'] = 'Det maksimale antal brugere, der er tilladt i en session. Sæt til 0 for at tillade et ubegrænset antal brugere.';
$string['mod_form_field_voicebridge'] = 'Voice bridge [####]';
$string['mod_form_field_voicebridge_format_error'] = 'Formatfejl. Du skal indtaste et nummer mellem 1 og 9999.';
$string['mod_form_field_voicebridge_help'] = 'Et nummer mellem 1 og 9999, som deltagerne indtaster for at deltage i stemmesessionen, når de bruger opkald ind. Hvis værdien er 0, vil det statiske Voice Bridge nummer blive ignoreret, og et tilfældigt nummer vil blive genereret af BigBlueButton. Et nummer 7 vil få præfikset de fire indtastede cifre.';
$string['mod_form_field_voicebridge_notunique_error'] = 'Ikke en unik værdi. Dette nummer bruges af et andet rum.';
$string['mod_form_field_wait'] = 'Vent på moderator';
$string['mod_form_field_wait_help'] = 'Skal deltagere vente på en moderator før de kan komme ind i rummet?';
$string['mod_form_field_welcome'] = 'Velkomstbesked';
$string['mod_form_field_welcome_default'] = 'Velkommen til %%CONFNAME%%.';
$string['mod_form_field_welcome_help'] = 'Velkomstbeskeden vises, når deltagerne kommer ind i rummet. Hvis feltet efterlades tomt, vises en standardbesked, der er sat i site administrationen.';
$string['mod_form_locksettings'] = 'Lås indstillinger';
$string['modulename'] = 'BigBlueButton';
$string['modulename_help'] = 'BigBlueButton er et open-source webkonferencesystem designet til online læring, der understøtter realtidsdeling af lyd, video, chat, slides, skærmdeling, en multi-bruger whiteboard, grupperum, afstemninger og emojis.

Med BigBlueButton kan du oprette et rum til sessioner såsom online live klasser, virtuelle kontortimer eller gruppe samarbejde med fjernstuderende. Sessionen kan optages til senere afspilning.';
$string['modulename_link'] = 'BigBlueButton/view';
$string['modulenameplural'] = 'BigBlueButton';
$string['new_bigblubuttonbn_activities'] = 'BigBlueButton aktivitet';
$string['nosuchinstance'] = 'Ingen sådan instans {$a->entity} med ID {$a->id}';
$string['notification_instance_created_intro'] = 'Det <a href="{$a->link}">{$a->name}</a> BigBlueButton rum er blevet oprettet.';
$string['notification_instance_created_small'] = 'Et nyt BigBlueButton rum navngivet {$a->name} blev oprettet.';
$string['notification_instance_created_subject'] = 'Et nyt BigBlueButton rum er blevet oprettet';
$string['notification_instance_description'] = 'Beskrivelse';
$string['notification_instance_end_date'] = 'Slutdato';
$string['notification_instance_name'] = 'Titel';
$string['notification_instance_start_date'] = 'Startdato';
$string['notification_instance_updated_intro'] = 'Det <a href="{$a->link}">{$a->name}</a> BigBlueButton rum er blevet opdateret.';
$string['notification_instance_updated_small'] = 'BigBlueButton session {$a->name} blev opdateret';
$string['notification_instance_updated_subject'] = 'Dit BigBlueButton rum er blevet opdateret';
$string['notification_recording_ready_html'] = 'En optagelse er nu tilgængelig for sessionen i BigBlueButton rummet <a href="{$a->link}">{$a->name}</a>.';
$string['notification_recording_ready_plain'] = 'En optagelse er nu tilgængelig for sessionen i BigBlueButton rummet {$a->name}. Gå til {$a->link} for at få adgang til optagelseslinket.';
$string['notification_recording_ready_small'] = 'En optagelse er tilgængelig for BigBlueButton rummet {$a->name}.';
$string['notification_recording_ready_subject'] = 'Optagelse tilgængelig';
$string['pluginadministration'] = 'BigBlueButton administration';
$string['pluginname'] = 'BigBlueButton';
$string['privacy:metadata:bigbluebutton'] = 'For at oprette og deltage i BigBlueButton sessioner, skal brugerdata udveksles med serveren.';
$string['privacy:metadata:bigbluebutton:fullname'] = 'Brugerens fulde navn, når denne tilgår BigBlueButton serveren.';
$string['privacy:metadata:bigbluebutton:userid'] = 'Bruger ID af brugeren, der tilgår BigBlueButton serveren.';
$string['privacy:metadata:bigbluebuttonbn'] = 'BigBlueButton session konfiguration';
$string['privacy:metadata:bigbluebuttonbn:participants'] = 'En liste over regler, der definerer den rolle brugere vil have i BigBlueButton sessionen. Et bruger ID kan gemmes, da tilladelser kan gives pr. rolle eller pr. bruger.';
$string['privacy:metadata:bigbluebuttonbn_logs'] = 'Gemmer begivenheder udløst ved brug af pluginet.';
$string['privacy:metadata:bigbluebuttonbn_logs:log'] = 'Typen af begivenhed udløst af brugeren.';
$string['privacy:metadata:bigbluebuttonbn_logs:meetingid'] = 'Session ID som brugeren havde adgang til.';
$string['privacy:metadata:bigbluebuttonbn_logs:meta'] = 'Yderligere information relateret til sessionen eller optagelsen.';
$string['privacy:metadata:bigbluebuttonbn_logs:timecreated'] = 'Tidspunktet, hvor loggen blev oprettet.';
$string['privacy:metadata:bigbluebuttonbn_logs:userid'] = 'Bruger ID for den bruger, der udløste begivenheden.';
$string['privacy:metadata:bigbluebuttonbn_recordings'] = 'Gemmer metadata om optagelser.';
$string['privacy:metadata:bigbluebuttonbn_recordings:userid'] = 'Bruger ID for den bruger, der sidst ændrede en optagelse.';
$string['progress_createbigbluebuttonbn'] = 'Opretter BigBlueButton aktivitet ({$a})';
$string['recordings_from_deleted_activities'] = 'Optagelser fra slettede aktiviteter';
$string['recordingurlnotfound'] = 'Optagelses URL\'en er ugyldig.';
$string['removedevents'] = 'Slettede begivenheder';
$string['removedlogs'] = 'Slettede brugerdefinerede logs';
$string['removedrecordings'] = 'Slettede optagelser';
$string['removedtags'] = 'Slettede tags';
$string['report_join_info'] = '{$a} møde(r)';
$string['report_play_recording_info'] = '{$a} optagelse(r) afspillet';
$string['report_room_view'] = 'set';
$string['resetevents'] = 'Slet begivenheder';
$string['resetlogs'] = 'Slet brugerdefinerede logs';
$string['resetlogs_help'] = 'Sletning af loggene vil resultere i tabte referencer til optagelser.';
$string['resetrecordings'] = 'Slet optagelser';
$string['resetrecordings_help'] = 'Sletning af optagelserne vil gøre dem utilgængelige fra hvor som helst. Denne handling kan ikke fortrydes!';
$string['resettags'] = 'Slet tags';
$string['search:activity'] = 'BigBlueButton - aktivitetsinformation';
$string['search:tags'] = 'BigBlueButton - tags information';
$string['sendnotification'] = 'Send notifikation';
$string['settings'] = 'BigBlueButton indstillinger';
$string['settings_credential_warning'] = 'BigBlueButton serveroplysninger vil snart udløbe. Se de <a href="{$a->settingslink}" target="_blank"> generelle BigBlueButton indstillinger (åbner i et nyt vindue)</a>.';
$string['settings_credential_warning_no_capability'] = 'BigBlueButton serveroplysninger vil snart udløbe. Kontakt venligst din site administrator.';
$string['started_at'] = 'Startede';
$string['starts_at'] = 'Starter';
$string['subplugintype_bbbext'] = 'BigBlueButton aktivitets udvidelse';
$string['subplugintype_bbbext_plural'] = 'BigBlueButton aktivitets udvidelser';
$string['taskname:check_dismissed_recordings'] = 'Kontrollér optagelser, der ikke er fundet endnu';
$string['taskname:check_pending_recordings'] = 'Hent ventende optagelser';
$string['userlimitreached'] = 'Antallet af brugere, der må deltage i en session er nået.';
$string['view_conference_action_end'] = 'Afslut session';
$string['view_conference_action_join'] = 'Deltag i session';
$string['view_error_action_not_completed'] = 'Handling kunne ikke fuldføres';
$string['view_error_bigbluebutton'] = 'BigBlueButton svarede med fejl. {$a}';
$string['view_error_create'] = 'BigBlueButton serveren svarede med en fejlmeddelelse. Rummet kunne ikke oprettes.';
$string['view_error_current_state_not_found'] = 'Nuværende tilstand blev ikke fundet. Optagelsen kan være blevet slettet, eller BigBlueButton serveren er ikke kompatibel med den udførte handling.';
$string['view_error_import_no_courses'] = 'Der er ingen kurser at slå op for optagelser.';
$string['view_error_import_no_recordings'] = 'Der er ingen optagelser i dette kursus til import.';
$string['view_error_invalid_session'] = 'Sessionen er udløbet. Gå tilbage til aktivitetssiden.';
$string['view_error_max_concurrent'] = 'Antallet af samtidige sessioner tilladt er nået.';
$string['view_error_meeting_not_running'] = 'Noget gik galt; sessionen kører ikke.';
$string['view_error_no_group'] = 'Der er ingen grupper. Du skal oprette nogle grupper før du forsøger at deltage i sessionen.';
$string['view_error_no_group_student'] = 'Du er endnu ikke tilføjet til en gruppe. Kontakt venligst din underviser.';
$string['view_error_no_group_teacher'] = 'Der er ingen grupper. Du skal oprette nogle grupper.';
$string['view_error_unable_join'] = 'Kan ikke komme ind i rummet. Kontroller venligst URL\'en på BigBlueButton serveren OG kontroller om BigBlueButton serveren kører.';
$string['view_error_unable_join_student'] = 'Kan ikke oprette forbindelse til BigBlueButton serveren.';
$string['view_error_unable_join_teacher'] = 'Kan ikke oprette forbindelse til BigBlueButton serveren. Kontakt en administrator.';
$string['view_error_url_missing_parameters'] = 'Der mangler parametre i denne URL';
$string['view_error_userlimit_reached'] = 'Grænsen for hvor mange brugere der må deltage i en session er nået.';
$string['view_groups_nogroups_warning'] = 'Rummet blev konfigureret til at bruge grupper, men kurset har ikke defineret grupper.';
$string['view_groups_notenrolled_warning'] = 'Rummet blev konfigureret til at bruge grupper, men du er ikke medlem af en gruppe.';
$string['view_groups_selection'] = 'Vælg den gruppe, du ønsker at deltage i og bekræft handlingen';
$string['view_groups_selection_join'] = 'Deltag';
$string['view_groups_selection_warning'] = 'Der er et rum for hver gruppe, og du har adgang til mere end en. Vær sikker på at vælge den korrekte.';
$string['view_login_moderator'] = 'Logger på som moderator ...';
$string['view_login_viewer'] = 'Logger på som seer ...';
$string['view_message_and'] = 'og';
$string['view_message_conference_has_ended'] = 'Sessionen er afsluttet.';
$string['view_message_conference_in_progress'] = 'Sessionen er i gang.';
$string['view_message_conference_not_started'] = 'Sessionen er ikke startet endnu.';
$string['view_message_conference_room_ready'] = 'Dette rum er klar. Du kan deltage i sessionen nu.';
$string['view_message_conference_user_limit_reached'] = 'Grænsen for hvor mange brugere der må deltage i en session er nået.';
$string['view_message_conference_wait_for_moderator'] = 'Venter på, at en moderator tilslutter sig.';
$string['view_message_cron_disabled'] = 'Listen over optagelser er måske ikke opdateret. Kontakt venligst site administratoren med følgende information: {$a}';
$string['view_message_finished'] = 'Denne aktivitet er slut.';
$string['view_message_has_joined'] = 'har deltaget';
$string['view_message_have_joined'] = 'har deltaget';
$string['view_message_hour'] = 'time';
$string['view_message_hours'] = 'timer';
$string['view_message_importrecordings_disabled'] = 'Importér optagelseslinks er deaktiveret på serveren.';
$string['view_message_minute'] = 'minut';
$string['view_message_minutes'] = 'minutter';
$string['view_message_moderator'] = 'Moderator';
$string['view_message_moderators'] = 'Moderatører';
$string['view_message_norecordings'] = 'Der er ingen optagelser tilgængelige.';
$string['view_message_notavailableyet'] = 'Denne session er endnu ikke tilgængelig.';
$string['view_message_recordings_disabled'] = 'Optagelser er deaktiveret på serveren. BigBlueButton aktiviteter af typen \'Kun optagelser\' kan ikke bruges.';
$string['view_message_room_closed'] = 'Dette rum er lukket.';
$string['view_message_room_open'] = 'Dette rum er åbent.';
$string['view_message_room_ready'] = 'Dette rum er klar.';
$string['view_message_session_for'] = 'sessionen for';
$string['view_message_session_has_user'] = 'Der er';
$string['view_message_session_has_users'] = 'Der er';
$string['view_message_session_no_users'] = 'Der er ingen brugere i denne session';
$string['view_message_session_running_for'] = 'Denne session har kørt i';
$string['view_message_session_started_at'] = 'Sessionen startede kl';
$string['view_message_tab_close'] = 'Denne fane/vindue skal lukkes manuelt';
$string['view_message_times'] = 'gange';
$string['view_message_user'] = 'Bruger';
$string['view_message_users'] = 'Brugere';
$string['view_message_viewer'] = 'Seer';
$string['view_message_viewers'] = 'Seere';
$string['view_mobile_message_groups_not_supported'] = 'Denne instans er i gruppetilstand, men mobilappen understøtter det endnu ikke. Brug venligst webversionen.';
$string['view_mobile_message_reload_page_creation_time_meeting'] = 'Du har brugt mere end 45 sekunder på denne side. Opdater venligst siden for at deltage i sessionen.';
$string['view_noguests'] = 'BigBlueButton rummet er ikke åbent for gæster.';
$string['view_nojoin'] = 'Du har ikke en rolle, der har tilladelse til at deltage i denne session.';
$string['view_recording'] = 'optagelse';
$string['view_recording_actionbar'] = 'Værktøjslinje';
$string['view_recording_activity'] = 'Aktivitet';
$string['view_recording_button_import'] = 'Importér optagelseslinks';
$string['view_recording_button_return'] = 'Gå tilbage';
$string['view_recording_course'] = 'Kursus';
$string['view_recording_date'] = 'Dato';
$string['view_recording_delete_confirmation'] = 'Er du sikker på, at du vil slette {$a}?';
$string['view_recording_delete_confirmation_warning_p'] = 'Denne optagelse har {$a} links tilknyttet, som blev importeret til forskellige kurser eller aktiviteter. Hvis optagelsen slettes, vil disse links også blive fjernet.';
$string['view_recording_delete_confirmation_warning_s'] = 'Denne optagelse har {$a} link tilknyttet, som blev importeret til en anden kursus eller aktivitet. Hvis optagelsen slettes, vil dette link også blive fjernet.';
$string['view_recording_description'] = 'Beskrivelse';
$string['view_recording_description_edithint'] = 'Der kan tilføjes en beskrivelse for at hjælpe med at identificere optagelsen.';
$string['view_recording_description_editlabel'] = 'Rediger beskrivelse';
$string['view_recording_duration'] = 'Varighed';
$string['view_recording_duration_min'] = 'min';
$string['view_recording_format_errror_unreachable'] = 'URL\'en for dette optagelsesformat er utilgængelig.';
$string['view_recording_format_notes'] = 'Noter';
$string['view_recording_format_podcast'] = 'Podcast';
$string['view_recording_format_presentation'] = 'Præsentation';
$string['view_recording_format_screenshare'] = 'Skærmdeling';
$string['view_recording_format_statistics'] = 'Statistik';
$string['view_recording_format_video'] = 'Video';
$string['view_recording_import_confirmation'] = 'Er du sikker på, at du vil importere denne optagelse?';
$string['view_recording_length'] = 'Længde';
$string['view_recording_link'] = 'importeret link';
$string['view_recording_link_warning'] = 'Dette er et link, der peger til en optagelse, som blev oprettet i et andet kursus eller aktivitet.';
$string['view_recording_list_action_delete'] = 'Sletter';
$string['view_recording_list_action_edit'] = 'Opdaterer';
$string['view_recording_list_action_play'] = 'Spil';
$string['view_recording_list_action_process'] = 'Behandler';
$string['view_recording_list_action_protect'] = 'Beskytter';
$string['view_recording_list_action_publish'] = 'Udgiver';
$string['view_recording_list_action_unprotect'] = 'Fjerner beskyttelse';
$string['view_recording_list_action_unpublish'] = 'Skjuler';
$string['view_recording_list_action_update'] = 'Opdaterer';
$string['view_recording_list_actionbar'] = 'Værktøjslinje';
$string['view_recording_list_actionbar_delete'] = 'Slet';
$string['view_recording_list_actionbar_edit'] = 'Rediger';
$string['view_recording_list_actionbar_hide'] = 'Skjul';
$string['view_recording_list_actionbar_import'] = 'Importér';
$string['view_recording_list_actionbar_protect'] = 'Gør privat';
$string['view_recording_list_actionbar_publish'] = 'Udgiv';
$string['view_recording_list_actionbar_show'] = 'Vis';
$string['view_recording_list_actionbar_unprotect'] = 'Gør offentlig';
$string['view_recording_list_actionbar_unpublish'] = 'Skjul';
$string['view_recording_list_activity'] = 'Aktivitet';
$string['view_recording_list_course'] = 'Kursus';
$string['view_recording_list_date'] = 'Dato';
$string['view_recording_list_description'] = 'Beskrivelse';
$string['view_recording_list_duration'] = 'Varighed';
$string['view_recording_list_recording'] = 'Optagelse';
$string['view_recording_meeting'] = 'Møde';
$string['view_recording_modal_button'] = 'Ansøg';
$string['view_recording_modal_title'] = 'Sæt værdier for optagelsen';
$string['view_recording_name'] = 'Navn';
$string['view_recording_name_edithint'] = 'Der kan tilføjes et navn for at hjælpe med at identificere optagelsen.';
$string['view_recording_name_editlabel'] = 'Rediger navn';
$string['view_recording_playback'] = 'Afspilning';
$string['view_recording_preview'] = 'Forhåndsvisning';
$string['view_recording_preview_help'] = 'Hold musen over et billede for at se det i fuld størrelse';
$string['view_recording_protect_confirmation'] = 'Er du sikker på, at du vil beskytte denne {$a}?';
$string['view_recording_protect_confirmation_warning_p'] = 'Denne optagelse har {$a} links tilknyttet, som blev importeret til mange kurser eller aktiviteter. Hvis optagelsen beskyttes, vil det også påvirke de importerede links.';
$string['view_recording_protect_confirmation_warning_s'] = 'Denne optagelse har {$a} link tilknyttet, som blev importeret til en anden kursus eller aktivitet. Hvis optagelsen beskyttes, vil det også påvirke de importerede links.';
$string['view_recording_publish_confirmation'] = 'Er du sikker på, at du vil udgive denne {$a}?';
$string['view_recording_publish_confirmation_warning_p'] = 'Denne optagelse har {$a} links tilknyttet, som blev importeret til forskellige kurser eller aktiviteter. Hvis optagelsen udgives, vil disse links også blive udgivet.';
$string['view_recording_publish_confirmation_warning_s'] = 'Denne optagelse har {$a} link tilknyttet, som blev importeret til en anden kursus eller aktivitet. Hvis optagelsen udgives, vil dette link også blive udgivet.';
$string['view_recording_publish_link_deleted'] = 'Dette link kan ikke genudgives, fordi den oprindelige optagelse ikke eksisterer på BigBlueButton serveren. Linket bør fjernes.';
$string['view_recording_publish_link_not_published'] = 'Dette link kan ikke genudgives, fordi den oprindelige optagelse er skjult.';
$string['view_recording_recording'] = 'Optagelse';
$string['view_recording_select_course'] = 'Vælg først et kursus i dropdown menuen';
$string['view_recording_tags'] = 'Tags';
$string['view_recording_unprotect_confirmation'] = 'Er du sikker på, at du vil fjerne beskyttelsen af denne {$a}?';
$string['view_recording_unprotect_confirmation_warning_p'] = 'Denne optagelse har {$a} links tilknyttet, som blev importeret til mange kurser eller aktiviteter. Hvis beskyttelsen fjernes, vil det også påvirke de importerede links.';
$string['view_recording_unprotect_confirmation_warning_s'] = 'Denne optagelse har {$a} link tilknyttet, som blev importeret til en anden kursus eller aktivitet. Hvis beskyttelsen fjernes, vil det også påvirke de importerede links.';
$string['view_recording_unprotect_link_deleted'] = 'Dette link kan ikke fjernes fra beskyttelsen, fordi den oprindelige optagelse ikke eksisterer på BigBlueButton serveren. Linket bør fjernes.';
$string['view_recording_unprotect_link_not_unprotected'] = 'Dette link kan ikke fjernes fra beskyttelsen, fordi den oprindelige optagelse er beskyttet.';
$string['view_recording_unpublish_confirmation'] = 'Er du sikker på, at du vil skjule denne {$a}?';
$string['view_recording_unpublish_confirmation_warning_p'] = 'Denne optagelse har {$a} links tilknyttet, som blev importeret til forskellige kurser eller aktiviteter. Hvis optagelsen er skjult, vil disse links også blive skjult.';
$string['view_recording_unpublish_confirmation_warning_s'] = 'Denne optagelse har {$a} link tilknyttet, som blev importeret til en anden kursus eller aktivitet. Hvis optagelsen er skjult, vil dette link også blive skjult.';
$string['view_recording_yui_first'] = 'Første';
$string['view_recording_yui_go'] = 'Gå';
$string['view_recording_yui_last'] = 'Sidste';
$string['view_recording_yui_next'] = 'Næste';
$string['view_recording_yui_page'] = 'Side';
$string['view_recording_yui_prev'] = 'Forrige';
$string['view_recording_yui_rows'] = 'Rækker';
$string['view_recording_yui_show_all'] = 'Vis alle';
$string['view_room'] = 'Vis rum';
$string['view_section_title_presentation'] = 'Præsentationsfil';
$string['view_section_title_recordings'] = 'Optagelser';
$string['waitformoderator'] = 'Venter på, at en moderator tilslutter sig.';
