<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'scorm', language 'da', version '5.0'.
 *
 * @package     scorm
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activation'] = 'Aktivering';
$string['activityloading'] = 'Du vil automatisk blive omdirigeret til aktiviteten i';
$string['activityoverview'] = 'Du har SCORM-pakker, der kræver opmærksomhed';
$string['activitypleasewait'] = 'Aktiviteten indlæses, venligst vent ...';
$string['adminsettings'] = 'Adminindstillinger';
$string['advanced'] = 'Parametre';
$string['aicchacpkeepsessiondata'] = 'AICC HACP sessionsdata';
$string['aicchacpkeepsessiondata_desc'] = 'Varighed i dage for at opbevare de eksterne AICC HACP sessionsdata (en høj indstilling vil fylde tabellen med gamle data, men kan være nyttig ved fejlfinding)';
$string['aicchacptimeout'] = 'AICC HACP timeout';
$string['aicchacptimeout_desc'] = 'Varighed i minutter som en ekstern AICC HACP session kan forblive åben';
$string['aiccuserid'] = 'AICC send numerisk bruger-id';
$string['aiccuserid_desc'] = 'AICC-standarden for brugernavne er meget restriktiv sammenlignet med Moodle og tillader kun alfanumeriske tegn, bindestreg og understreg. Punktummer, mellemrum og @-symbolet er ikke tilladt. Hvis det er aktiveret, sendes bruger-ID-numre til AICC-pakken i stedet for brugernavne.';
$string['aliasonly'] = 'Når du vælger en imsmanifest.xml fil fra et repository, skal du bruge et alias/genvej til denne fil.';
$string['allowapidebug'] = 'Aktiver API-debugging og sporing (sæt capture-masken med apidebugmask)';
$string['allowtypeaicchacp'] = 'Aktiver ekstern AICC HACP';
$string['allowtypeaicchacp_desc'] = 'Hvis aktiveret tillader dette AICC HACP ekstern kommunikation uden at kræve brugerlogin for post requests fra den eksterne AICC pakke';
$string['allowtypeexternal'] = 'Aktiver ekstern pakke type';
$string['allowtypeexternalaicc'] = 'Aktiver direkte AICC URL';
$string['allowtypeexternalaicc_desc'] = 'Hvis aktiveret, tillader dette en direkte url til et simpelt AICC-pakke';
$string['allowtypelocalsync'] = 'Aktiver downloaded package type';
$string['apidebugmask'] = 'API debug capture maske - brug en simpel regex på &lt;brugernavn&gt;:&lt;aktivitetnavn&gt; f.eks. admin:.* vil debugge for admin-bruger kun';
$string['areacontent'] = 'Indholds filer';
$string['areapackage'] = 'Pakke fil';
$string['asset'] = 'Aktiv';
$string['assetlaunched'] = 'Aktiv - Set';
$string['attempt'] = 'Forsøg';
$string['attempt1'] = '1 forsøg';
$string['attempts'] = 'Forsøg';
$string['attemptsmanagement'] = 'Håndtering af forsøg';
$string['attemptstatusall'] = 'Dashboard og indgangsside';
$string['attemptstatusentry'] = 'Kun indgangsside';
$string['attemptstatusmy'] = 'Kun dashboard';
$string['attemptsx'] = '{$a} forsøg';
$string['attr_error'] = 'Ugyldig værdi for attribut ({$a->attr}) i tag {$a->tag}.';
$string['autocommit'] = 'Auto-commit';
$string['autocommit_help'] = 'Hvis det er aktiveret, gemmes SCORM-data automatisk i databasen. Nyttigt for SCORM-objekter, der ikke gemmer deres data regelmæssigt.';
$string['autocommitdesc'] = 'Automatisk gem SCORM-data, hvis SCORM-pakken ikke gemmer det.';
$string['autocontinue'] = 'Auto-fortsæt';
$string['autocontinue_help'] = 'Hvis det er aktiveret, startes efterfølgende læringsobjekter automatisk, ellers skal knappen Fortsæt bruges.';
$string['autocontinuedesc'] = 'Hvis det er aktiveret, startes efterfølgende læringsobjekter automatisk, ellers skal knappen Fortsæt bruges.';
$string['averageattempt'] = 'Gennemsnitlige forsøg';
$string['badarchive'] = 'Du skal angive en gyldig zip-fil';
$string['badimsmanifestlocation'] = 'En imsmanifest.xml fil blev fundet, men den var ikke i roden af din zip-fil, venligst pak din SCORM om.';
$string['badmanifest'] = 'Nogle manifestfejl: se fejlloggen';
$string['browse'] = 'Forhåndsvisning';
$string['browsed'] = 'Gennemset';
$string['browsemode'] = 'Forhåndsvisningstilstand';
$string['browserepository'] = 'Gennemse repository';
$string['cachedef_elements'] = 'Element cache';
$string['calculatedweight'] = 'Beregnet vægt';
$string['calendarend'] = '{$a} lukker';
$string['calendarstart'] = '{$a} åbner';
$string['cannotaccess'] = 'Du kan ikke kalde dette script på den måde';
$string['cannotfindsco'] = 'Kunne ikke finde SCO';
$string['chooseapacket'] = 'Vælg eller opdater en pakke';
$string['closebeforeopen'] = 'Du har angivet en lukningsdato før åbningsdatoen.';
$string['collapsetocwinsize'] = 'Skjul indholdsfortegnelsen når vinduets størrelse er under';
$string['collapsetocwinsizedesc'] = 'Denne indstilling giver dig mulighed for at angive vinduets størrelse, under hvilken TOC automatisk skal kollapsere.';
$string['compatibilitysettings'] = 'Kompatibilitetsindstillinger';
$string['completed'] = 'Fuldført';
$string['completiondetail:allscos'] = 'Udfør alle dele af denne aktivitet';
$string['completiondetail:completionscore'] = 'Modtag en score på {$a} eller mere';
$string['completiondetail:completionstatuscompleted'] = 'Fuldfør aktiviteten';
$string['completiondetail:completionstatuscompletedorpassed'] = 'Gennemfør eller bestå aktiviteten';
$string['completiondetail:completionstatuspassed'] = 'Bestå aktiviteten';
$string['completionscorerequired'] = 'Krav om minimumsscore';
$string['completionscorerequireddesc'] = 'Minimumscoren på {$a} er påkrævet for gennemførelse';
$string['completionstatus_completed'] = 'Fuldført';
$string['completionstatus_passed'] = 'Bestået';
$string['completionstatusallscos'] = 'Alle SCO\'er skal returnere status for fuldførelse';
$string['completionstatusallscos_help'] = 'Nogle SCORM-pakker indeholder flere komponenter eller scos - når dette er aktiveret, skal alle scos inden for pakken returnere den relevante lesson_status for at denne aktivitet kan blive markeret som fuldført.';
$string['completionstatusrequired'] = 'Kræv status';
$string['completionstatusrequired_help'] = 'At tjekke en eller flere statusser vil kræve, at en bruger opnår mindst en af de tjekkede statusser for at blive markeret som fuldført i denne SCORM aktivitet, samt opfylde eventuelle andre krav til aktivitetsfuldførelse.';
$string['completionstatusrequireddesc'] = 'Studerende skal opnå mindst en af følgende statusser: {$a}';
$string['confirmloosetracks'] = 'ADVARSEL: Pakken ser ud til at være ændret eller modificeret. Hvis pakkens struktur ændres, kan nogle brugeres spor gå tabt under opdateringsprocessen.';
$string['contents'] = 'Indhold';
$string['coursepacket'] = 'Kursuspakke';
$string['coursestruct'] = 'Indholdsstruktur';
$string['crontask'] = 'Baggrundsbehandling for SCORM';
$string['currentwindow'] = 'Nuværende vindue';
$string['datadir'] = 'Filsystemfejl: Kan ikke oprette kursusdata-mappe';
$string['defaultdisplaysettings'] = 'Standard visningsindstillinger';
$string['defaultgradesettings'] = 'Standard bedømmelsesindstillinger';
$string['defaultothersettings'] = 'Andre standardindstillinger';
$string['deleteallattempts'] = 'Alle SCORM-forsøg';
$string['deleteattemptcheck'] = 'Er du helt sikker på, at du vil slette disse forsøg helt?';
$string['deleteselected'] = 'Slet valgte forsøg';
$string['deleteuserattemptcheck'] = 'Er du helt sikker på, at du vil slette alle dine forsøg fuldstændigt?';
$string['details'] = 'Spor detaljer';
$string['directories'] = 'Vis mappelinks';
$string['disabled'] = 'Deaktiveret';
$string['display'] = 'Visningspakke';
$string['displayattemptstatus'] = 'Vis status for forsøg';
$string['displayattemptstatus_help'] = 'Denne indstilling tillader et resumé af brugerens forsøg at vise i kursusoversigtsblokken i Dashboard og/eller SCORM indgangssiden.';
$string['displayattemptstatusdesc'] = 'Om et resumé af brugerens forsøg vises i kursusoversigtsblokken i Dashboardet og/eller SCORM-indgangssiden.';
$string['displaycoursestructure'] = 'Vis indholdsstruktur på indgangssiden';
$string['displaycoursestructure_help'] = 'Hvis det er aktiveret, vises indholdsfortegnelsen på SCORM oversigtssiden.';
$string['displaycoursestructuredesc'] = 'Hvis det er aktiveret, vises indholdsfortegnelsen på SCORM oversigtssiden.';
$string['displaydesc'] = 'Om SCORM-pakken skal vises i et nyt vindue.';
$string['displaysettings'] = 'Visningsindstillinger';
$string['dnduploadscorm'] = 'Tilføj en SCORM-pakke';
$string['domxml'] = 'DOMXML ekstern biblioteks';
$string['element'] = 'Element';
$string['enter'] = 'Indtast';
$string['entercourse'] = 'Gå ind i kursus';
$string['errorlogs'] = 'Fejllog';
$string['eventattemptdeleted'] = 'Forsøg slettet';
$string['eventinteractionsviewed'] = 'Interaktioner set';
$string['eventreportviewed'] = 'Rapport set';
$string['eventscolaunched'] = 'Sco blev lanceret';
$string['eventscorerawsubmitted'] = 'Indsendt SCORM råscore';
$string['eventstatussubmitted'] = 'Indsendt SCORM-status';
$string['eventtracksviewed'] = 'Setninger vist';
$string['eventuserreportviewed'] = 'Brugerrapport set';
$string['everyday'] = 'Hver dag';
$string['everytime'] = 'Hver gang det bruges';
$string['exceededmaxattempts'] = 'Du har nået det maksimale antal forsøg.';
$string['exit'] = 'Forlad kursus';
$string['exitactivity'] = 'Afslutningsaktivitet';
$string['expired'] = 'Beklager, denne aktivitet lukkede den {$a} og er ikke længere tilgængelig';
$string['external'] = 'Opdatering af timing for eksterne pakker';
$string['failed'] = 'Mislykkedes';
$string['finishscorm'] = 'Hvis du har afsluttet visningen af denne ressource, {$a}';
$string['finishscormlinkname'] = 'klik her for at vende tilbage til kursussiden';
$string['firstaccess'] = 'Første adgang';
$string['firstattempt'] = 'Første forsøg';
$string['floating'] = 'Flydende';
$string['forceattemptalways'] = 'Altid';
$string['forceattemptoncomplete'] = 'Når den tidligere forsøg er afsluttet, bestået eller ikke bestået';
$string['forcecompleted'] = 'Tvang afsluttet';
$string['forcecompleted_help'] = 'Hvis aktiveret, tvinges status for det nuværende forsøg til "fuldført". (Kun gældende for SCORM 1.2 pakker.)';
$string['forcecompleteddesc'] = 'Denne indstilling angiver standardværdien for indstillingen for tvungen afslutning';
$string['forcejavascript'] = 'Tving brugerne til at aktivere JavaScript';
$string['forcejavascript_desc'] = 'Hvis aktiveret (anbefalet) forhindrer dette adgang til SCORM-objekter, når JavaScript ikke understøttes/er aktiveret i en brugers browser. Hvis deaktiveret kan brugeren se SCORM, men API-kommunikationen vil fejle, og ingen karakterinformation vil blive gemt.';
$string['forcejavascriptmessage'] = 'JavaScript er påkrævet for at se dette objekt, venligst aktiver JavaScript i din browser og prøv igen.';
$string['forcenewattempts'] = 'Tving ny forsøg';
$string['forcenewattempts_help'] = 'There are 3 options:

* No - If a previous attempt is completed, passed or failed, the student will be provided with the option to enter in review mode or start a new attempt.
* When previous attempt completed, passed or failed - This relies on the SCORM package setting the status of \'completed\', \'passed\' or \'failed\'.
* Always - Each re-entry to the SCORM activity will generate a new attempt and the student will not be returned to the same point they reached in their previous attempt.';
$string['found'] = 'Manifest fundet';
$string['frameheight'] = 'Højden på sceneindramningen eller vinduet.';
$string['framewidth'] = 'Bredden af sceneindramningen eller vinduet.';
$string['fromleft'] = 'Fra venstre';
$string['fromtop'] = 'Fra toppen';
$string['fullscreen'] = 'Fyld hele skærmen';
$string['general'] = 'Generelle data';
$string['gradeaverage'] = 'Gennemsnitlig karakter';
$string['gradeforattempt'] = 'Karakter for forsøg';
$string['gradehighest'] = 'Højeste karakter';
$string['grademethod'] = 'Vurderingsmetode';
$string['grademethod_help'] = 'The grading method defines how the grade for a single attempt of the activity is determined.

There are 4 grading methods:

* Learning objects - The number of completed/passed learning objects
* Highest grade - The highest score obtained in all passed learning objects
* Average grade - The mean of all the scores
* Sum grade - The sum of all the scores';
$string['grademethoddesc'] = 'Vurderingsmetoden definerer, hvordan karakteren for et enkelt forsøg på aktiviteten bestemmes.';
$string['gradereported'] = 'Karakter rapporteret';
$string['gradescoes'] = 'Læringsobjekter';
$string['gradesettings'] = 'Karakterindstillinger';
$string['gradesum'] = 'Sum karakter';
$string['height'] = 'Højde';
$string['hidden'] = 'Skjult';
$string['hidebrowse'] = 'Deaktiver forhåndsvisningstilstand';
$string['hidebrowse_help'] = 'Forhåndsvisningstilstand giver en studerende mulighed for at gennemse en aktivitet, inden den forsøges. Hvis forhåndsvisningstilstand er deaktiveret, skjules forhåndsvisningsknappen.';
$string['hidebrowsedesc'] = 'Forhåndsvisningstilstand giver en studerende mulighed for at gennemse en aktivitet, før den forsøges.';
$string['hideexit'] = 'Skjul exit-link';
$string['hidereview'] = 'Skjul anmeldelsesknap';
$string['hidetoc'] = 'Vis indholdsstruktur i afspilleren';
$string['hidetoc_help'] = 'Hvordan indholdsfortegnelsen vises i SCORM-afspilleren';
$string['hidetocdesc'] = 'Denne indstilling specificerer, hvordan indholdsfortegnelsen vises i SCORM-afspilleren.';
$string['highestattempt'] = 'Højeste forsøg';
$string['identifier'] = 'Spørgsmål identificering';
$string['incomplete'] = 'Ufuldstændig';
$string['indicator:cognitivedepth'] = 'SCORM kognitiv';
$string['indicator:cognitivedepth_help'] = 'Denne indikator er baseret på den kognitive dybde, som eleven har nået i en SCORM-aktivitet.';
$string['indicator:cognitivedepthdef'] = 'SCORM kognitiv';
$string['indicator:cognitivedepthdef_help'] = 'Deltageren har nået denne procentdel af den kognitive engagement, der tilbydes af SCORM-aktiviteterne i denne analyseperiode (Niveauer = Ingen visning, Visning, Indsend, Vis feedback)';
$string['indicator:cognitivedepthdef_link'] = 'Læringsanalyseindikatorer#Kognitiv_dybde';
$string['indicator:socialbreadth'] = 'SCORM social';
$string['indicator:socialbreadth_help'] = 'Denne indikator er baseret på den sociale bredde, som eleven har opnået i en SCORM-aktivitet.';
$string['indicator:socialbreadthdef'] = 'SCORM social';
$string['indicator:socialbreadthdef_help'] = 'Deltageren har nået denne procentdel af den sociale engagement, der tilbydes af SCORM-aktiviteterne i denne analyseperiode (Niveauer = Ingen deltagelse, Deltager alene)';
$string['indicator:socialbreadthdef_link'] = 'Læringsanalyseindikatorer#Social_bredde';
$string['interactions'] = 'Interaktioner';
$string['invalidactivity'] = 'SCORM-aktiviteten er forkert';
$string['invalidhacpsession'] = 'Ugyldig HACP-session';
$string['invalidmanifestname'] = 'Kun imsmanifest.xml eller .zip filer må vælges';
$string['invalidmanifestresource'] = 'ADVARSEL: De følgende ressourcer blev refereret i dit manifest, men kunne ikke findes:';
$string['invalidstatus'] = 'Ugyldig status';
$string['invalidurl'] = 'Ugyldig URL angivet';
$string['invalidurlhttpcheck'] = 'Ugyldig URL angivet. Fejlmeddelelse:<pre>{$a->cmsg}</pre>';
$string['largetrackupgrade'] = 'Dette næste opgraderingstrin kan tage noget tid at fuldføre, din side har {$a} SCORM sporingsoptegnelser, der skal migreres til den nye tabelstruktur, venligst vær tålmodig, da en statuslinje ikke kan vises.';
$string['last'] = 'Sidst tilgået den';
$string['lastaccess'] = 'Sidste adgang';
$string['lastattempt'] = 'Sidste gennemførte forsøg';
$string['lastattemptlock'] = 'Lås efter sidste forsøg';
$string['lastattemptlock_help'] = 'Hvis det er aktiveret, forhindres en studerende i at starte SCORM-afspilleren efter at have brugt alle deres tildelte forsøg.';
$string['lastattemptlockdesc'] = 'Hvis det er aktiveret, forhindres en studerende i at starte SCORM-afspilleren efter at have brugt alle deres tildelte forsøg.';
$string['location'] = 'Vis adressefeltet';
$string['masteryoverride'] = 'Mestringsscore overskriver status';
$string['masteryoverride_help'] = 'Hvis det er aktiveret, og en mestringsscore er angivet, når LMSFinish kaldes, og en rå score er blevet indstillet, vil status blive genberegnet ved hjælp af den rå score og mestringsscore, og enhver status angivet af SCORM (inklusive "incomplete") vil blive overskrevet.';
$string['masteryoverridedesc'] = 'Denne præference indstiller standarden for indstillingen for overstyring af mestringsscore';
$string['max'] = 'Maksimal score';
$string['maximumattempts'] = 'Antal forsøg';
$string['maximumattempts_help'] = 'Denne indstilling muliggør, at antallet af forsøg kan begrænses. Den er kun gældende for SCORM 1.2 og AICC pakker.';
$string['maximumattemptsdesc'] = 'Denne præference indstiller det standard maksimale antal forsøg for en aktivitet';
$string['maximumgradedesc'] = 'Denne indstilling fastsætter den standard maksimale karakter for en aktivitet';
$string['menubar'] = 'Vis menulinjen';
$string['min'] = 'Minimum score';
$string['minimumscoregreater'] = 'Minimumscoren skal være større end 0.';
$string['missing_attribute'] = 'Manglende attribut {$a->attr} i tag {$a->tag}';
$string['missing_tag'] = 'Mangler tag {$a->tag}';
$string['missingparam'] = 'En påkrævet parameter mangler eller er forkert';
$string['mode'] = 'Mode';
$string['modulename'] = 'SCORM-pakke';
$string['modulename_help'] = 'A SCORM package is a collection of files which are packaged according to an agreed standard for learning objects. The SCORM activity module enables SCORM or AICC packages to be uploaded as a zip file and added to a course.

Content is usually displayed over several pages, with navigation between the pages. There are various options for displaying content in a pop-up window, with a table of contents, with navigation buttons etc. SCORM activities generally include questions, with grades being recorded in the gradebook.

SCORM activities may be used

* For presenting multimedia content and animations
* As an assessment tool';
$string['modulename_link'] = 'mod/scorm/view';
$string['modulenameplural'] = 'SCORM-pakker';
$string['myaiccsessions'] = 'Mine AICC-sessioner';
$string['myattempts'] = 'Mine forsøg';
$string['nav'] = 'Vis navigation';
$string['nav_help'] = 'This setting specifies whether to show or hide the navigation buttons and their position.

There are 3 options:

* No - Navigation buttons are not shown
* Under content - Navigation buttons are shown below the SCORM package content
* Floating - Navigation buttons are shown floating, with the position from the top and from the left determined by the package.';
$string['navdesc'] = 'Denne indstilling angiver, om navigationsknapperne skal vises eller skjules, samt deres position.';
$string['navigation'] = 'Navigation';
$string['navpositionleft'] = 'Positionen af navigationsknapperne fra venstre i pixels.';
$string['navpositiontop'] = 'Positionen af navigationsknapperne fra toppen i pixels.';
$string['networkdropped'] = 'The SCORM player has determined that your Internet connection is unreliable or has been interrupted. If you continue in this SCORM activity, your progress may not be saved.<br />
You should exit the activity now, and return when you have a dependable Internet connection.';
$string['newattempt'] = 'Start et nyt forsøg';
$string['next'] = 'Fortsæt';
$string['no_attributes'] = 'Tag {$a->tag} skal have attributter';
$string['no_children'] = 'Tag {$a->tag} skal have børn';
$string['noactivity'] = 'Intet at rapportere';
$string['noattemptsallowed'] = 'Antal tilladte forsøg';
$string['noattemptsmade'] = 'Antal forsøg du har gjort';
$string['nolimit'] = 'Ubegrænsede forsøg';
$string['nomanifest'] = 'Forkert filpakke - mangler imsmanifest.xml eller AICC-struktur';
$string['noprerequisites'] = 'Beklager, men du har ikke de nødvendige forudsætninger for at få adgang til denne aktivitet.';
$string['noreports'] = 'Ingen rapport at vise';
$string['normal'] = 'Normal';
$string['noscriptnoscorm'] = 'Din browser understøtter ikke JavaScript, eller JavaScript-understøttelse er deaktiveret. Denne SCORM-pakke fungerer muligvis ikke korrekt eller gemmer ikke data.';
$string['not_corr_type'] = 'Type mismatch for tag {$a->tag}';
$string['notattempted'] = 'Ikke forsøgt';
$string['notopenyet'] = 'Beklager, denne aktivitet er ikke tilgængelig før {$a}';
$string['objectives'] = 'Mål';
$string['openafterclose'] = 'Du har angivet en åbningsdato efter lukningsdatoen';
$string['optallstudents'] = 'alle brugere';
$string['optattemptsonly'] = 'brugere med kun forsøg';
$string['options'] = 'Muligheder (Forhindret af nogle browsere)';
$string['optionsadv'] = 'Indstillinger (Avanceret)';
$string['optionsadv_desc'] = 'Hvis det er markeret, vil bredde og højde blive vist som avancerede indstillinger.';
$string['optnoattemptsonly'] = 'brugere med ingen forsøg kun';
$string['organization'] = 'Organisation';
$string['organizations'] = 'Organisationer';
$string['othersettings'] = 'Yderligere indstillinger';
$string['package'] = 'Pakke fil';
$string['package_help'] = 'Pakkefilen er en zip (eller pif) fil, der indeholder SCORM/AICC kursusdefinitionsfiler.';
$string['packagedir'] = 'Filsystemfejl: Kan ikke oprette pakkemappe';
$string['packagefile'] = 'Ingen pakke fil angivet';
$string['packagehdr'] = 'Pakke';
$string['packageurl'] = 'URL';
$string['packageurl_help'] = 'Denne indstilling muliggør, at der kan angives en URL til SCORM-pakken i stedet for at vælge en fil via filvælgeren.';
$string['page-mod-scorm-x'] = 'Enhver SCORM modulside';
$string['pagesize'] = 'Sidelængde';
$string['passed'] = 'Bestået';
$string['php5'] = 'PHP 5 (DOMXML native library)';
$string['pluginadministration'] = 'Administration af SCORM-pakker';
$string['pluginname'] = 'SCORM-pakke';
$string['popup'] = 'Nyt vindue';
$string['popuplaunched'] = 'Denne SCORM-pakke er blevet åbnet i et popup-vindue. Hvis du er færdig med at se denne ressource, klik her for at vende tilbage til kursussiden.';
$string['popupmenu'] = 'I en rullemenu';
$string['popupopen'] = 'Åbn pakken i et nyt vindue';
$string['popupsblocked'] = 'Det ser ud til, at popup-vinduer er blokeret, hvilket forhindrer denne SCORM-pakke i at afspille. Venligst tjek dine browserindstillinger, før du prøver igen.';
$string['position_error'] = 'Taggen {$a->tag} kan ikke være barn af taggen {$a->parent}';
$string['preferencespage'] = 'Præferencer kun for denne side';
$string['preferencesuser'] = 'Præferencer for denne rapport';
$string['prev'] = 'Tidligere';
$string['privacy:metadata:aicc:data'] = 'Personlige data blev overført fra AICC/SCORM subsystemet.';
$string['privacy:metadata:aicc:externalpurpose'] = 'Denne plugin sender data eksternt ved hjælp af AICC HACP.';
$string['privacy:metadata:aicc_session:lessonstatus'] = 'Status for lektionen der skal spores';
$string['privacy:metadata:aicc_session:scormmode'] = 'Tilstand for det element, der skal spores';
$string['privacy:metadata:aicc_session:scormstatus'] = 'Status for det element, der skal spores';
$string['privacy:metadata:aicc_session:sessiontime'] = 'Den tid, der skal spores for sessionen';
$string['privacy:metadata:aicc_session:timecreated'] = 'Tidspunktet hvor det sporende element blev oprettet';
$string['privacy:metadata:attempt'] = 'Forsøgsnummeret';
$string['privacy:metadata:scoes_track:element'] = 'Navnet på det element, der skal spores';
$string['privacy:metadata:scoes_track:value'] = 'Værdien af det givne element';
$string['privacy:metadata:scorm_aicc_session'] = 'Sessioninformation om AICC HACP';
$string['privacy:metadata:scorm_attempt'] = 'De SCORM-forsøg, der er foretaget af en bruger';
$string['privacy:metadata:timemodified'] = 'Tidspunktet for hvornår det sporende element sidst blev ændret';
$string['privacy:metadata:userid'] = 'ID\'et på den bruger, der tilgik SCORM-aktiviteten';
$string['protectpackagedownloads'] = 'Beskyt pakke-downloads';
$string['protectpackagedownloads_desc'] = 'Hvis aktiveret, kan SCORM-pakker kun downloades, hvis brugeren har kapabiliteten course:manageactivities. Hvis de er deaktiveret, kan SCORM-pakker altid downloades (via mobil eller andre midler).';
$string['raw'] = 'Rå score';
$string['regular'] = 'Regelmæssig manifest';
$string['report'] = 'Rapport';
$string['reportcountallattempts'] = '{$a->nbattempts} forsøg for {$a->nbusers} brugere, ud af {$a->nbresults} resultater';
$string['reportcountattempts'] = '{$a->nbresults} resultater ({$a->nbusers} brugere)';
$string['reports'] = 'Rapporter';
$string['repositorynotsupported'] = 'Dette repository understøtter ikke direkte linking til en imsmanifest.xml fil.';
$string['response'] = 'Svar';
$string['result'] = 'Resultat';
$string['results'] = 'Resultater';
$string['review'] = 'Gennemgang';
$string['reviewmode'] = 'Gennemgangstilstand';
$string['rightanswer'] = 'Korrekt svar';
$string['scoes'] = 'Læringsobjekter';
$string['score'] = 'Score';
$string['scorm:addinstance'] = 'Tilføj en ny SCORM-pakke';
$string['scorm:deleteownresponses'] = 'Slet egne forsøg';
$string['scorm:deleteresponses'] = 'Slet SCORM-forsøg';
$string['scorm:savetrack'] = 'Gem spor';
$string['scorm:skipview'] = 'Spring over oversigten';
$string['scorm:viewreport'] = 'Se rapporter';
$string['scorm:viewscores'] = 'Se resultater';
$string['scormclose'] = 'Tilgængelig for';
$string['scormcourse'] = 'Læringskursus';
$string['scormloggingoff'] = 'API-logning er deaktiveret';
$string['scormloggingon'] = 'API logging er aktiveret';
$string['scormopen'] = 'Tilgængelig fra';
$string['scormresponsedeleted'] = 'Slettede brugerforsøg';
$string['scormstandard'] = 'SCORM standarder tilstand';
$string['scormstandarddesc'] = 'Når det er deaktiveret, tillader Moodle SCORM 1.2 pakker at gemme mere end specifikationen tillader, og bruger Moodles indstillinger for fulde navnformat, når brugernavnet sendes til SCORM-pakken.';
$string['scormtype'] = 'Type';
$string['scormtype_help'] = 'This setting determines how the package is included in the course. There are up to 4 options:

* Uploaded package - Enables a SCORM package to be chosen via the file picker
* External SCORM manifest - Enables an imsmanifest.xml URL to be specified. Note: If the URL has a different domain name than your site, then "Downloaded package" is a better option, since otherwise grades are not saved.
* Downloaded package - Enables a package URL to be specified. The package will be unzipped and saved locally, and updated when the external SCORM package is updated.
* External AICC URL - this URL is the launch URL for a single AICC Activity.  A psuedo package will be constructed around this.';
$string['scrollbars'] = 'Tillad vinduet at blive rullet';
$string['search:activity'] = 'SCORM-pakke - aktivitetsinformation';
$string['selectall'] = 'Vælg alle';
$string['selectnone'] = 'Fravælg alle';
$string['show'] = 'Vis';
$string['sided'] = 'Til siden';
$string['skipview'] = 'Studerende springer indholdsstruktur siden over';
$string['skipview_help'] = 'Denne indstilling angiver, om indholdsstrukturen siden nogensinde skal springes over (ikke vises). Hvis pakken kun indeholder ét læringsobjekt, kan indholdsstrukturen siden altid springes over.';
$string['skipviewdesc'] = 'Denne indstilling fastsætter standarden for, hvornår indholdsstrukturen for en side skal springes over';
$string['slashargs'] = 'ADVARSEL: skråstregsargumenter er deaktiveret på dette site, og objekter fungerer muligvis ikke som forventet!';
$string['stagesize'] = 'Scene størrelse';
$string['stagesize_help'] = 'Disse to indstillinger angiver ramme/vinduesbredden og højden for læringsobjekterne.';
$string['started'] = 'Startede den';
$string['status'] = 'Status';
$string['statusbar'] = 'Vis statuslinjen';
$string['student_response'] = 'Svar';
$string['subplugintype_scormreport'] = 'Rapport';
$string['subplugintype_scormreport_plural'] = 'Rapporter';
$string['suspended'] = 'Suspenderet';
$string['syntax'] = 'Syntaxfejl';
$string['tag_error'] = 'Ukendt tag ({$a->tag}) med dette indhold: {$a->value}';
$string['time'] = 'Tid';
$string['title'] = 'Titel';
$string['toc'] = 'TOC';
$string['too_many_attributes'] = 'Tag {$a->tag} har for mange attributter';
$string['too_many_children'] = 'Tag {$a->tag} har for mange børn';
$string['toolbar'] = 'Vis værktøjslinjen';
$string['totaltime'] = 'Tid';
$string['trackcorrectcount'] = 'Korrekt antal';
$string['trackcorrectcount_help'] = 'Antal korrekte resultater for spørgsmålet';
$string['trackid'] = 'ID';
$string['trackid_help'] = 'Dette er identifikatoren, der er sat af dit SCORM-pakke for dette spørgsmål, SCORM-specifikationen tillader ikke, at den fulde spørgsmålstekst gives.';
$string['trackingloose'] = 'ADVARSEL: Sporingsdataene for denne pakke vil gå tabt!';
$string['tracklatency'] = 'Latency';
$string['tracklatency_help'] = 'Den tid, der er gået mellem det tidspunkt, hvor spørgsmålet blev gjort tilgængeligt for læreren til at give et svar, og tidspunktet for det første svar.';
$string['trackpattern'] = 'Mønster';
$string['trackpattern_help'] = 'Dette er, hvad et korrekt svar på dette spørgsmål ville være, det viser ikke brugerens svar.';
$string['trackresponse'] = 'Svar';
$string['trackresponse_help'] = 'Dette er svaret givet af læreren på dette spørgsmål';
$string['trackresult'] = 'Resultat';
$string['trackresult_help'] = 'Viser om læreren indtastede et korrekt svar.';
$string['trackscoremax'] = 'Maksimal score';
$string['trackscoremax_help'] = 'Maksimal værdi der kan tildeles for den rå score';
$string['trackscoremin'] = 'Minimum score';
$string['trackscoremin_help'] = 'Minimumsværdi der kan tildeles for den rå score';
$string['trackscoreraw'] = 'Rå score';
$string['trackscoreraw_help'] = 'Tal der afspejler den studerendes præstation i forhold til det interval, der er afgrænset af værdierne for min og max';
$string['tracksuspenddata'] = 'Suspender data';
$string['tracksuspenddata_help'] = 'Giver plads til at gemme og hente data mellem lærersessioner';
$string['tracktime'] = 'Tid';
$string['tracktime_help'] = 'Tidspunktet hvor forsøget blev påbegyndt';
$string['tracktype'] = 'Type';
$string['tracktype_help'] = 'Type af spørgsmålet, for eksempel "choice" eller "shortanswer".';
$string['trackweight'] = 'Vægt';
$string['trackweight_help'] = 'Vægt tildelt spørgsmålet ved beregning af score.';
$string['type'] = 'Type';
$string['typeaiccurl'] = 'Ekstern AICC URL';
$string['typeexternal'] = 'Ekstern SCORM manifest';
$string['typelocal'] = 'Uploadet pakke';
$string['typelocalsync'] = 'Downloadet pakke';
$string['undercontent'] = 'Under indhold';
$string['unziperror'] = 'Der opstår en fejl under udpakkning af pakken';
$string['updatefreq'] = 'Frekvens for automatisk opdatering';
$string['updatefreq_error'] = 'Frekvensen for automatisk opdatering kan kun indstilles, når pakke filen er hostet eksternt';
$string['updatefreq_help'] = 'Dette gør det muligt for den eksterne pakke at blive automatisk downloadet og opdateret';
$string['updatefreqdesc'] = 'Denne indstilling fastsætter den standard automatiske opdateringsfrekvens for en aktivitet';
$string['validateascorm'] = 'Valider en pakke';
$string['validation'] = 'Valideringsresultat';
$string['validationtype'] = 'Denne indstilling angiver den DOMXML-bibliotek, der anvendes til validering af SCORM-manifestet. Hvis du ikke ved det, skal du lade det valgte valg være uændret.';
$string['value'] = 'Værdi';
$string['versionwarning'] = 'Manifestversionen er ældre end 1.3, advarsel ved {$a->tag} tag';
$string['viewallreports'] = 'Se rapporter for {$a} forsøg';
$string['viewalluserreports'] = 'Se rapporter for {$a} brugere';
$string['whatgrade'] = 'Bedømmelse af forsøg';
$string['whatgrade_help'] = 'If multiple attempts are allowed, this setting specifies whether the highest, average (mean), first or last completed attempt is recorded in the gradebook. The last completed attempt option does not include attempts with a \'failed\' status.

Notes on handling of multiple attempts:

* The option to start a new attempt is provided by a checkbox above the Enter button on the content structure page, so be sure you\'re providing access to that page if you want to allow more than one attempt.
* Some SCORM packages are intelligent about new attempts, many are not. What this means is that if the learner re-enters an existing attempt, if the SCORM content does not have internal logic to avoid overwriting previous attempts they can be overwritten, even though the attempt was \'completed\' or \'passed\'.
* The settings "Force completed", "Force new attempt" and "Lock after final attempt" also provide further management of multiple attempts.';
$string['whatgradedesc'] = 'Om den højeste, gennemsnitlige (middel), første eller sidste gennemførte forsøg registreres i karakterbogen, hvis flere forsøg er tilladt.';
$string['width'] = 'Bredde';
$string['window'] = 'Vindue';
$string['youmustselectastatus'] = 'Du skal vælge en status, der skal kræves';
