<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'tool_oauth2', language 'da', version '5.0'.
 *
 * @package     tool_oauth2
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['acceptrisk'] = 'Jeg forstår, at deaktivering af e-mailverifikation kan være et sikkerhedsproblem.';
$string['acceptrisk_help'] = 'Deaktivering af e-mailverifikation kan potentielt tillade en bruger at autentificere sig som en anden bruger.';
$string['authconfirm'] = 'Denne handling vil give permanent API-adgang til Moodle for den autentificerede konto. Dette er beregnet til at blive brugt som en systemkonto til at administrere filer ejet af Moodle.';
$string['authconnected'] = 'Systemkontoen er nu tilsluttet for offline adgang';
$string['authnotconnected'] = 'Systemkontoen var ikke tilsluttet for offline adgang';
$string['clever_service'] = 'Clever';
$string['configured'] = 'Konfigureret';
$string['configuredstatus'] = 'Konfigureret';
$string['connectsystemaccount'] = 'Opret forbindelse til en systemkonto';
$string['createfromtemplate'] = 'Opret en OAuth 2 tjeneste fra en skabelon';
$string['createfromtemplatedesc'] = 'Vælg en af OAuth 2 tjenesteskabelonerne nedenfor for at oprette en OAuth tjeneste med en gyldig konfiguration for en af de kendte servicetyper. Dette vil oprette OAuth 2 tjenesten med alle de korrekte slutpunkter og parametre, der kræves for autentifikation, men du skal stadig indtaste klient-ID og hemmelighed for den nye tjeneste, før den kan anvendes.';
$string['createnewendpoint'] = 'Opret ny endpoint for udsteder "{$a}"';
$string['createnewservice'] = 'Opret ny tjeneste:';
$string['createnewuserfieldmapping'] = 'Opret ny brugerfeltkortlægning for udsteder "{$a}"';
$string['custom_service'] = 'Brugerdefineret';
$string['deleteconfirm'] = 'Er du sikker på, at du vil slette identitetsudstederen "{$a}"? Eventuelle plugins, der er afhængige af denne udsteder, vil stoppe med at fungere.';
$string['deleteendpointconfirm'] = 'Er du sikker på, at du vil slette endpointet "{$a->endpoint}" for udstederen "{$a->issuer}"? Eventuelle plugins, der er afhængige af dette endpoint, vil stoppe med at fungere.';
$string['deleteuserfieldmappingconfirm'] = 'Er du sikker på, at du vil slette brugerfeltkortlægningen for udsteder "{$a}"?';
$string['discovered'] = 'Tjenesteopdagelse lykkedes';
$string['discovered_help'] = 'Discovery betyder, at OAuth 2-endepunkterne automatisk kan bestemmes ud fra basis-URL\'en for OAuth-tjenesten. Ikke alle tjenester er forpligtet til at blive "opdaget", men hvis de ikke er, skal endepunkterne og bruger-mappingoplysningerne indtastes manuelt.';
$string['discoverystatus'] = 'Opdagelse';
$string['editendpoint'] = 'Rediger endpoint: {$a->endpoint} for udsteder {$a->issuer}';
$string['editendpoints'] = 'Konfigurer endpoints';
$string['editissuer'] = 'Rediger identitetsudsteder: {$a}';
$string['edituserfieldmapping'] = 'Rediger brugerfeltkortlægning for udsteder {$a}';
$string['edituserfieldmappings'] = 'Konfigurer brugerfeltkortlægninger';
$string['endpointdeleted'] = 'Endpoint slettet';
$string['endpointname'] = 'Navn';
$string['endpointname_help'] = 'Nøgle brugt til at søge efter denne endpoint. Skal slutte med "_endpoint".';
$string['endpointsforissuer'] = 'Endepunkter for udsteder: {$a}';
$string['endpointurl'] = 'URL';
$string['endpointurl_help'] = 'URL for denne endpoint. Skal bruge https:// protokol.';
$string['facebook_service'] = 'Facebook';
$string['google_service'] = 'Google';
$string['issueralloweddomains'] = 'Login-domæner';
$string['issueralloweddomains_help'] = 'Hvis den er indstillet, er denne indstilling en kommasepareret liste over domæner, som logins vil være begrænset til, når der anvendes denne udbyder.';
$string['issueralloweddomains_link'] = 'OAuth_2_login_domæner';
$string['issuerbaseurl'] = 'Service base URL';
$string['issuerbaseurl_help'] = 'Basis-URL der bruges til at få adgang til tjenesten.';
$string['issuerclientid'] = 'Klient ID';
$string['issuerclientid_help'] = 'OAuth-klient-ID\'et for denne udsteder.';
$string['issuerclientsecret'] = 'Klienthemmelighed';
$string['issuerclientsecret_help'] = 'OAuth-klienthemmeligheden for denne udsteder.';
$string['issuerdeleted'] = 'Identitetsudsteder slettet';
$string['issuerdisabled'] = 'Identitetsudsteder deaktiveret';
$string['issuerenabled'] = 'Identitetsudsteder aktiveret';
$string['issuerimage'] = 'Logo URL';
$string['issuerimage_help'] = 'En billed-URL, der bruges til at vise et logo for denne udsteder. Kan vises på login-siden.';
$string['issuerloginpagename'] = 'Navn vist på login siden';
$string['issuerloginpagename_help'] = 'Hvis angivet, vil dette navn blive brugt på login-siden i stedet for tjenestens navn.';
$string['issuerloginparams'] = 'Yderligere parametre inkluderet i en login request.';
$string['issuerloginparams_help'] = 'Nogle systemer kræver yderligere parametre til en login request for at kunne læse brugerens grundlæggende profil.';
$string['issuerloginparamsoffline'] = 'Yderligere parametre inkluderet i en login-anmodning for offline adgang.';
$string['issuerloginparamsoffline_help'] = 'Hvert OAuth-system definerer en forskellig måde at anmode om offline adgang. F.eks. kræver Google de ekstra parametre: "access_type=offline&prompt=consent". Disse parametre skal være i URL forespørgselsparameterformat.';
$string['issuerloginscopes'] = 'Områder inkluderet i en login-anmodning.';
$string['issuerloginscopes_help'] = 'Nogle systemer kræver yderligere scopes for en login request for at kunne læse brugerens grundlæggende profil. De standard scopes for et OpenID Connect-kompatibelt system er "openid profile email".';
$string['issuerloginscopesoffline'] = 'Omfang inkluderet i en login-anmodning for offline adgang.';
$string['issuerloginscopesoffline_help'] = 'Hvert OAuth-system definerer en forskellig måde at anmode om offline adgang. F.eks. kræver Microsoft en ekstra scope "offline_access".';
$string['issuername'] = 'Navn';
$string['issuername_help'] = 'Navn på identitetsudstederen. Kan vises på login-siden.';
$string['issuerrequireconfirmation'] = 'Kræv e-mailverifikation';
$string['issuerrequireconfirmation_help'] = 'Krav om, at alle brugere skal bekræfte deres e-mailadresse, før de kan logge ind med OAuth. Dette gælder for nyoprettede konti som en del af loginprocessen, eller når en eksisterende Moodle-konto er tilsluttet et OAuth-login via matchende e-mailadresser.';
$string['issuers'] = 'Udstedere';
$string['issuersetup'] = 'Detaljerede instruktioner til konfiguration af de almindelige OAuth 2-tjenester';
$string['issuersetuptype'] = 'Detaljerede instruktioner til opsætning af {$a} OAuth 2 udbyder';
$string['issuershowonloginpage'] = 'Vis på login siden';
$string['issuershowonloginpage_help'] = 'Hvis OAuth 2 autentificeringsplugin\'et er aktiveret, vil denne loginudsteder blive vist på login-siden for at give brugerne mulighed for at logge ind med konti fra denne udsteder.';
$string['issuersservicesallow'] = 'Tillad tjenester';
$string['issuersservicesnotallow'] = 'Tillad ikke tjenester';
$string['issuerusedforinternal'] = 'Interne tjenester';
$string['issuerusedforlogin'] = 'Log ind';
$string['issuerusein'] = 'Denne tjeneste vil blive brugt';
$string['issuerusein_help'] = 'OAuth 2-tjenester kan anvendes til interne tjenester, på login-siden, eller begge dele, hvis det er nødvendigt.';
$string['issueruseineverywhere'] = 'Login-side og interne tjenester';
$string['issueruseininternalonly'] = 'Kun interne tjenester';
$string['issueruseinloginonly'] = 'Kun login-side';
$string['linkedin_service'] = 'LinkedIn';
$string['logindisplay'] = 'Vis på login siden som';
$string['loginissuer'] = 'Tillad login';
$string['microsoft_service'] = 'Microsoft';
$string['moodlenet_service'] = 'MoodleNet';
$string['nextcloud_service'] = 'Nextcloud';
$string['notconfigured'] = 'Ikke konfigureret';
$string['notdiscovered'] = 'Tjenesteopdagelse ikke lykkedes';
$string['notloginissuer'] = 'Tillad ikke login';
$string['pluginname'] = 'OAuth 2 tjenester';
$string['privacy:metadata'] = 'OAuth 2-tjenester pluginet gemmer ikke nogen personlige data.';
$string['savechanges'] = 'Gem ændringer';
$string['serviceshelp'] = 'Instruktioner til opsætning af tjenesteudbyder.';
$string['systemaccountconnected'] = 'Systemkonto tilsluttet';
$string['systemaccountconnected_help'] = 'Systemkonti bruges til at give avanceret funktionalitet for plugins. De er ikke kun nødvendige for login-funktionalitet, men andre plugins, der bruger OAuth-tjenesten, kan tilbyde et reduceret sæt af funktioner, hvis systemkontoen ikke er blevet tilsluttet. For eksempel kan repositories ikke understøtte "kontrollerede links" uden en systemkonto til at udføre filoperationer.';
$string['systemaccountnotconnected'] = 'Systemkontoen er ikke tilsluttet';
$string['systemauthstatus'] = 'Systemkonto tilsluttet';
$string['usebasicauth'] = 'Godkend tokenanmodninger via HTTP-overskrifter';
$string['usebasicauth_help'] = 'Benyt HTTP Basic autentificeringsskemaet, når du sender klient-ID og adgangskode med en anmodning om opfrisknings-token. Anbefalet af OAuth 2 standarden, men muligvis ikke tilgængelig hos nogle udstedere.';
$string['userfieldexternalfield'] = 'Eksternt felt navn';
$string['userfieldexternalfield_error'] = 'Dette felt kan ikke indeholde HTML.';
$string['userfieldexternalfield_help'] = 'Navn på feltet leveret af det eksterne OAuth-system.';
$string['userfieldinternalfield'] = 'Intern felt navn';
$string['userfieldinternalfield_help'] = 'Navn på Moodle-brugerfeltet, der skal kortlægges fra det eksterne felt.';
$string['userfieldmappingdeleted'] = 'Brugerfeltkortlægning slettet';
$string['userfieldmappingsforissuer'] = 'Brugerfeltkortlægninger for udsteder: {$a}';
