<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_moodlemobileapp', language 'ru', version '5.0'.
 *
 * @package     local_moodlemobileapp
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addon.calendar.calendarevent'] = 'Событие календаря';
$string['addon.calendar.calendarevents'] = 'События календаря';
$string['addon.calendar.defaultnotificationtime'] = 'Время уведомлений по умолчанию';
$string['addon.calendar.errorloadevent'] = 'Ошибка при загрузке события';
$string['addon.calendar.errorloadevents'] = 'Ошибка при загрузке событий';
$string['addon.calendar.noevents'] = 'Нет событий';
$string['addon.calendar.setnewreminder'] = 'Установить новое напоминание';
$string['addon.competency.errornocompetenciesfound'] = 'Компетенций не найдено';
$string['addon.competency.nocompetencies'] = 'Нет компетенций';
$string['addon.coursecompletion.complete'] = 'Завершить';
$string['addon.coursecompletion.couldnotloadreport'] = 'Невозможно загрузить отчёт о завершении курса. Пожалуйста, попробуйте ещё раз позже.';
$string['addon.messageoutput_airnotifier.processorsettingsdesc'] = 'Настроить устройства';
$string['addon.messages.contactlistempty'] = 'Список контактов пуст';
$string['addon.messages.contactname'] = 'Имя контакта';
$string['addon.messages.errordeletemessage'] = 'Ошибка при удалении сообщения.';
$string['addon.messages.errorwhileretrievingcontacts'] = 'Ошибка при извлечении контактов с сервера.';
$string['addon.messages.errorwhileretrievingdiscussions'] = 'Ошибка при получении обсуждений с сервера.';
$string['addon.messages.errorwhileretrievingmessages'] = 'Ошибка при получении сообщений с сервера.';
$string['addon.messages.messagenotsent'] = 'Сообщение не было отправлено. Пожалуйста, повторите попытку позже.';
$string['addon.messages.newmessages'] = 'Новые сообщения';
$string['addon.messages.nousersfound'] = 'Пользователи не найдены';
$string['addon.messages.type_blocked'] = 'Заблокировано';
$string['addon.messages.type_offline'] = 'Вне сайта';
$string['addon.messages.type_online'] = 'На сайте';
$string['addon.messages.type_search'] = 'Результаты поиска';
$string['addon.messages.type_strangers'] = 'Другие';
$string['addon.messages.warningmessagenotsent'] = 'Не получилось отправить сообщение(я) пользователю {{user}}. {{error}}';
$string['addon.mod_assign.acceptsubmissionstatement'] = 'Пожалуйста, примите заявление к предоставляемому ответу.';
$string['addon.mod_assign.cannoteditduetostatementsubmission'] = 'Вы не можете добавить или отредактировать ответ в приложении, потому что не удалось получить с сайта заявление к предоставляемому ответу.';
$string['addon.mod_assign.cannotgradefromapp'] = 'Определённые методы оценки ещё не поддерживаются приложением и не могут быть изменены.';
$string['addon.mod_assign.cannotsubmitduetostatementsubmission'] = 'Вы не можете ответить в приложении, потому что не удалось получить с сайта заявление к предоставляемому ответу.';
$string['addon.mod_assign.erroreditpluginsnotsupported'] = 'Вы не можете добавлять или изменять ответ в приложении, потому что определённые плагины пока не поддерживают редактирование.';
$string['addon.mod_assign.errorshowinginformation'] = 'Информация об ответе не может быть отображена.';
$string['addon.mod_assign.feedbacknotsupported'] = 'Эта обратная связь не поддерживается приложением и может содержать не всю информацию.';
$string['addon.mod_assign.gradenotsynced'] = 'Оценка не синхронизирована';
$string['addon.mod_assign.notallparticipantsareshown'] = 'Участники, которые не дали ответ, не показаны.';
$string['addon.mod_assign.submissionnotsupported'] = 'Этот ответ не поддерживается приложением и может содержать не всю информацию.';
$string['addon.mod_assign.warningsubmissiongrademodified'] = 'Оценка ответа была изменена на сайте.';
$string['addon.mod_assign.warningsubmissionmodified'] = 'Ответ пользователя был изменён на сайте.';
$string['addon.mod_chat.errorwhileconnecting'] = 'Ошибка при подключении к чату';
$string['addon.mod_chat.errorwhilegettingchatdata'] = 'Ошибка при получении данных из чата';
$string['addon.mod_chat.errorwhilegettingchatusers'] = 'Ошибка при получении пользователей чата';
$string['addon.mod_chat.errorwhileretrievingmessages'] = 'Ошибка при получении сообщения от сервера.';
$string['addon.mod_chat.errorwhilesendingmessage'] = 'Ошибка при отправке сообщения';
$string['addon.mod_chat.mustbeonlinetosendmessages'] = 'Вы должны быть в сети, чтобы отправлять сообщения.';
$string['addon.mod_choice.errorgetchoice'] = 'Ошибка при получении данных выбора';
$string['addon.mod_choice.responsesresultgraphdescription'] = '{{number}}% пользователей выбрало вариант: {{text}}.';
$string['addon.mod_choice.resultsnotsynced'] = 'Ваш последний ответ должен быть синхронизирован прежде, чем будет включён в результат.';
$string['addon.mod_data.errorapproving'] = 'Ошибка подтверждения или неподтверждения записи.';
$string['addon.mod_data.errordeleting'] = 'Ошибка удаления записи.';
$string['addon.mod_feedback.captchaofflinewarning'] = 'Обратная связь с CAPTCHA не может быть выполнена если вы не в сети, если не настроена или если сервер недоступен.';
$string['addon.mod_feedback.feedback_submitted_offline'] = 'Этот отзыв был сохранён, для отправки позже.';
$string['addon.mod_folder.emptyfilelist'] = 'Нет файлов для отображения';
$string['addon.mod_forum.errorgetforum'] = 'Ошибка при получении данных форума';
$string['addon.mod_forum.errorgetgroups'] = 'Ошибка получения параметров группы';
$string['addon.mod_forum.forumnodiscussionsyet'] = 'В этом форуме ещё нет тем для обсуждения.';
$string['addon.mod_forum.group'] = 'Группа';
$string['addon.mod_forum.numdiscussions'] = 'Обсуждений - {{numdiscussions}}';
$string['addon.mod_forum.numreplies'] = 'Ответов - {{numreplies}}';
$string['addon.mod_forum.refreshposts'] = 'Обновить объявления';
$string['addon.mod_glossary.browsemode'] = 'Смотреть записи';
$string['addon.mod_glossary.byalphabet'] = 'Алфавитно';
$string['addon.mod_glossary.byauthor'] = 'Группировать по автору';
$string['addon.mod_glossary.bycategory'] = 'Группировать по категориям';
$string['addon.mod_glossary.bynewestfirst'] = 'Сначала новые';
$string['addon.mod_glossary.byrecentlyupdated'] = 'Недавно обновлённые';
$string['addon.mod_glossary.bysearch'] = 'Поиск';
$string['addon.mod_glossary.cannoteditentry'] = 'Невозможно редактировать запись';
$string['addon.mod_glossary.entriestobesynced'] = 'Записи на синзронизацию';
$string['addon.mod_glossary.entrypendingapproval'] = 'Эта запись ожидает подтверждения.';
$string['addon.mod_glossary.errorloadingentries'] = 'При загрузке записей произошла ошибка.';
$string['addon.mod_glossary.errorloadingentry'] = 'При загрузке записи произошла ошибка.';
$string['addon.mod_glossary.errorloadingglossary'] = 'При загрузке глоссария произошла ошибка.';
$string['addon.mod_glossary.noentriesfound'] = 'Записей не было найдено.';
$string['addon.mod_glossary.searchquery'] = 'Запрос на поиск';
$string['addon.mod_imscp.showmoduledescription'] = 'Показать описание';
$string['addon.mod_lesson.errorprefetchrandombranch'] = 'Эта лекция содержит переход на случайную страницу контента. Невозможно выполнить попытку в приложении до тех пор, пока она не будет запущена в веб-браузере.';
$string['addon.mod_lesson.errorreviewretakenotlast'] = 'Эта попытка больше не может быть просмотрена, так как была сделана другая попытка.';
$string['addon.mod_lesson.finishretakeoffline'] = 'Эта попытка была завершена вне сети.';
$string['addon.mod_lesson.retakefinishedinsync'] = 'Попытка, выполненная вне сети, была синхронизирована. Вы хотите её просмотреть?';
$string['addon.mod_lesson.retakelabelfull'] = '{{retake}}: {{grade}} {{timestart}} ({{duration}})';
$string['addon.mod_lesson.retakelabelshort'] = '{{retake}}: {{grade}} {{timestart}}';
$string['addon.mod_lesson.warningretakefinished'] = 'Попытка была завершена на сайте.';
$string['addon.mod_lti.errorgetlti'] = 'Ошибка при получении данных модуля';
$string['addon.mod_lti.errorinvalidlaunchurl'] = 'Запущенный URL не действителен';
$string['addon.mod_lti.launchactivity'] = 'Запустить активность';
$string['addon.mod_page.errorwhileloadingthepage'] = 'Ошибка при загрузке содержимого страницы';
$string['addon.mod_quiz.cannotsubmitquizdueto'] = 'Попытка прохождения теста не может быть отправлена по следующим причинам:';
$string['addon.mod_quiz.confirmcontinueoffline'] = 'Эта попытка не была синхронизирована с {{$a}}. Если вы продолжите попытку с другого устройства, то можете потерять данные.';
$string['addon.mod_quiz.confirmleavequizonerror'] = 'При сохранении ответа возникла ошибка. Вы уверены, что хотите покинуть тест?';
$string['addon.mod_quiz.errorbehaviournotsupported'] = 'Этот тест не может быть пройден в приложении, потому что поведение вопроса не поддерживается приложением.';
$string['addon.mod_quiz.errordownloading'] = 'Ошибка при загрузке необходимых данных.';
$string['addon.mod_quiz.errorgetattempt'] = 'Ошибка получения данных попытки.';
$string['addon.mod_quiz.errorgetquestions'] = 'Ошибка получения вопросов.';
$string['addon.mod_quiz.errorgetquiz'] = 'Ошибка получения данных теста.';
$string['addon.mod_quiz.errorparsequestions'] = 'При чтении вопросов произошла ошибка. Попробуйте пройти этот тест в браузере.';
$string['addon.mod_quiz.errorquestionsnotsupported'] = 'Данный тест не может быть пройден в приложении, потому что он содержит вопросы, не поддерживаемые приложением:';
$string['addon.mod_quiz.errorrulesnotsupported'] = 'Данный тест не может быть пройден в приложении, потому что он имеет правила доступа, не поддерживаемые приложением:';
$string['addon.mod_quiz.errorsaveattempt'] = 'При сохранении данных попытки возникла ошибка.';
$string['addon.mod_quiz.finishnotsynced'] = 'Завершено, но не синхронизировано';
$string['addon.mod_quiz.opentoc'] = 'Открыть всплывающее окно с навигацией';
$string['addon.mod_quiz.warningattemptfinished'] = 'Попытка, совершённая вне сети, отменена, так как она была завершена на сайте или не найдена.';
$string['addon.mod_quiz.warningdatadiscarded'] = 'Некоторые ответы, совершённые вне сети, были отменены, так как вопросы были изменены в сети.';
$string['addon.mod_quiz.warningdatadiscardedfromfinished'] = 'Попытка не завершена, так как некоторые ответы, данные вне сети, были отменены. Пожалуйста, проверьте свои ответы и отправьте попытку заново.';
$string['addon.mod_resource.errorwhileloadingthecontent'] = 'Ошибка при загрузке контента';
$string['addon.mod_resource.openthefile'] = 'Открыть файл';
$string['addon.mod_scorm.cannotcalculategrade'] = 'Оценка не может быть посчитана';
$string['addon.mod_scorm.dataattemptshown'] = 'Эти данные относятся к попытке номер {{number}}.';
$string['addon.mod_scorm.errorcreateofflineattempt'] = 'Во время создания новой попытки вне сети возникла ошибка. Пожалуйста, попробуйте снова.';
$string['addon.mod_scorm.errordownloadscorm'] = 'Ошибка загрузки SCORM: «{{name}}».';
$string['addon.mod_scorm.errorgetscorm'] = 'Ошибка получения данных SCORM.';
$string['addon.mod_scorm.errorinvalidversion'] = 'К сожалению, приложение поддерживает только SCORM 1.2.';
$string['addon.mod_scorm.errornotdownloadable'] = 'Загрузка пакетов SCORM отключена. Пожалуйста, свяжитесь с администратором вашего сайта.';
$string['addon.mod_scorm.errornovalidsco'] = 'Данный SCORM пакет не имеет видимого SCO для загрузки.';
$string['addon.mod_scorm.errorpackagefile'] = 'К сожалению, приложение поддерживает только ZIP-архивы.';
$string['addon.mod_scorm.errorsyncscorm'] = 'Во время синхронизации произошла ошибка. Пожалуйста, повторите попытку.';
$string['addon.mod_scorm.offlineattemptnote'] = 'В этой попытке содержатся данные, которые не были синхронизированы.';
$string['addon.mod_scorm.offlineattemptovermax'] = 'Данная попытка не может быть отправлена, так как вы превысили максимальное число попыток.';
$string['addon.mod_scorm.scormstatusnotdownloaded'] = 'Данный пакет SCORM не загружен. Он загрузится автоматически, когда вы откроете его.';
$string['addon.mod_scorm.scormstatusoutdated'] = 'Данный пакет SCORM был изменён с момента последней загрузки. Он будет автоматически загружен, когда вы откроете его.';
$string['addon.mod_scorm.warningofflinedatadeleted'] = 'Некоторые данные, добавленные вне сети, из попытки {{number}} были отклонены, так как попытка не могла считаться новой.';
$string['addon.mod_scorm.warningsynconlineincomplete'] = 'Некоторые попытки не могли быть синхронизированы с сайтом, так как последняя попытка в сети ещё не завершена. Пожалуйста, сначала завершите попытку в сети.';
$string['addon.mod_survey.cannotsubmitsurvey'] = 'К сожалению, возникла проблема отправки вашего опроса. Пожалуйста, попробуйте еще раз';
$string['addon.mod_survey.errorgetsurvey'] = 'Ошибка при получении данных опроса';
$string['addon.mod_survey.results'] = 'Результаты';
$string['addon.mod_url.accessurl'] = 'Открыть URL-адрес';
$string['addon.mod_url.pointingtourl'] = 'URL, на который указывает ресурс.';
$string['addon.mod_wiki.errorloadingpage'] = 'При загрузке страницы произошла ошибка.';
$string['addon.mod_wiki.errornowikiavailable'] = 'В этом модуле WIKI пока нет контента.';
$string['addon.mod_wiki.gowikihome'] = 'Перейти на первую страницу wiki';
$string['addon.mod_wiki.subwiki'] = 'Под-wiki';
$string['addon.mod_wiki.titleshouldnotbeempty'] = 'Заголовок не должен быть пустым';
$string['addon.mod_wiki.viewpage'] = 'Просмотреть страницу';
$string['addon.mod_wiki.wikipage'] = 'Страница Wiki';
$string['addon.mod_workshop.assessmentstrategynotsupported'] = 'Стратегия оценки {{$a}} не поддерживается';
$string['addon.mod_workshop.warningassessmentmodified'] = 'Отправка была изменена на сайте.';
$string['addon.mod_workshop.warningsubmissionmodified'] = 'Оценка была изменена на сайте.';
$string['addon.notes.warningnotenotsent'] = 'Не получилось добавить заметку(и) к курсу {{course}}. {{error}}';
$string['addon.notifications.errorgetnotifications'] = 'Ошибка получения уведомлений.';
$string['addon.notifications.notifications'] = 'Уведомления';
$string['addon.notifications.playsound'] = 'Проигрывать звук';
$string['addon.notifications.therearentnotificationsyet'] = 'Уведомлений нет.';
$string['appstoredescription'] = 'ПРИМЕЧАНИЕ: Это официальное приложение Moodle Mobile будет работать ТОЛЬКО с сайтами Moodle, в которых настроено соответствующее разрешение. Если у вас есть проблемы с подключением, обратитесь, пожалуйста, к вашему администратору Moodle.

Если ваш сайт Moodle правильно настроен, то вы можете использовать это приложение для того, чтобы:

- просматривать содержимое ваших курсов даже без подключения к сети
- получать моментальные уведомления о сообщениях и других событиях
- быстро находить и связываться с другими людьми в ваших курсах
- загружать изображения, аудио, видео и другие файлы с вашего мобильного устройства
- смотреть ваши оценки за курс
- и не только!

Чтобы получить самую свежую информацию, пожалуйста посетите http://docs.moodle.org/en/Mobile_app.

Мы были бы рады получить ваши обзоры по имеющемуся функционалу, также как и ваши предложения о том, что ещё данное приложение должно мочь делать.

Приложение требует следующих разрешений:
Запись аудио - Для записи аудио для загрузки на Moodle
Чтение и изменение содержимого вашей SD карты - Содержимое загружается на SD карту для просмотра в автономном режиме
Доступ к сети - Чтобы иметь возможность подключиться к вашему сайту Moodle  и проверить, подключены ли вы и переключиться в автономный режим в противном случае
Запуск при включении - Чтобы вы получали локальные оповещения даже когда приложение запущено в фоновом режиме
Не разрешать переход телефона в сон - Чтобы вы могли получать push-уведомления в любое время';
$string['core.cannotconnect'] = 'Не удается подключиться: Убедитесь, что вы правильно ввели URL.';
$string['core.cannotdownloadfiles'] = 'Загрузка файлов отключена. Пожалуйста, свяжитесь с администратором вашего сайта.';
$string['core.captureaudio'] = 'Записать аудио';
$string['core.capturedimage'] = 'Сделанное изображение';
$string['core.captureimage'] = 'Сделать изображение';
$string['core.capturevideo'] = 'Записать видео';
$string['core.clearsearch'] = 'Очистить поиск';
$string['core.clicktoseefull'] = 'Нажать, чтобы посмотреть полное содержимое.';
$string['core.confirmcanceledit'] = 'Вы уверены, что хотите покинуть эту страницу? Все изменения будут потеряны.';
$string['core.confirmloss'] = 'Вы уверены? Все изменения будут удалены.';
$string['core.confirmopeninbrowser'] = 'Вы хотите открыть это в веб-браузере?';
$string['core.contenteditingsynced'] = 'Содержимое, которое вы редактируете, было синхронизировано.';
$string['core.contentlinks.chooseaccount'] = 'Выберите учетную запись';
$string['core.contentlinks.chooseaccounttoopenlink'] = 'Выбрать учётную запись для перехода по ссылке.';
$string['core.contentlinks.confirmurlothersite'] = 'Эта ссылка ведёт на другой сайт. Вы хотите перейти по ней?';
$string['core.contentlinks.errornoactions'] = 'Не удалось найти действие для работы с этой ссылкой.';
$string['core.contentlinks.errornosites'] = 'Не удалось найти сайт, на который ведёт ссылка.';
$string['core.copiedtoclipboard'] = 'Текст скопирован в буфер обмена.';
$string['core.course.activitydisabled'] = 'Ваша организация отключила данный активный элемент в мобильном приложении.';
$string['core.course.activitynotyetviewableremoteaddon'] = 'Ваша организация установила плагин, который ещё не поддерживается.';
$string['core.course.allsections'] = 'Все разделы';
$string['core.course.confirmdownload'] = 'Вы собираетесь загрузить {{size}}. Вы уверены, что хотите продолжить?';
$string['core.course.confirmdownloadunknownsize'] = 'Оценить размер загружаемых данных не удалось. Вы уверены, что хотите продолжить?';
$string['core.course.confirmpartialdownloadsize'] = 'Вы собираетесь загрузить <strong>по меньшей мере</strong> {{size}}. Вы уверены, что хотите продолжить?';
$string['core.course.couldnotloadsectioncontent'] = 'Не удалось загрузить содержимое раздела. Пожалуйста, повторите попытку позже.';
$string['core.course.couldnotloadsections'] = 'Не удалось загрузить разделы. Пожалуйста, повторите попытку позже.';
$string['core.course.errordownloadingsection'] = 'Ошибка загрузки раздела.';
$string['core.course.errorgetmodule'] = 'Ошибка получения данных активного элемента.';
$string['core.course.nocontentavailable'] = 'Нет контента, доступного в данный момент';
$string['core.course.useactivityonbrowser'] = 'Вы по прежнему можете пользоваться этим, используя веб-браузер своего устройства.';
$string['core.courses.cannotretrievemorecategories'] = 'Категории глубже уровня {{$a}} не могут быть получены.';
$string['core.courses.enrolme'] = 'Записать меня';
$string['core.courses.errorloadcategories'] = 'Во время загрузки категорий произошла ошибка.';
$string['core.courses.errorloadcourses'] = 'При загрузке курсов произошла ошибка.';
$string['core.courses.errorsearching'] = 'Во время поиска произошла ошибка.';
$string['core.courses.filtermycourses'] = 'Поиск моих курсов';
$string['core.courses.notenrollable'] = 'Вы не можете самостоятельно записаться на этот курс.';
$string['core.courses.password'] = 'Кодовое слово';
$string['core.courses.searchcoursesadvice'] = 'Вы можете использовать кнопку поиска по курсам, чтобы найти курсы для гостевого доступа к ним или записать себя на курсы, которые это разрешают.';
$string['core.courses.totalcoursesearchresults'] = 'Всего курсов: {{$a}}';
$string['core.currentdevice'] = 'Данное устройство';
$string['core.datastoredoffline'] = 'Данные сохранены на устройстве, потому что не могут быть отправлены. Они будут автоматически отправлены позже.';
$string['core.deletedoffline'] = 'Удалено вне сети';
$string['core.deleting'] = 'Удаление';
$string['core.dfdaymonthyear'] = 'MM-DD-YYYY';
$string['core.dfdayweekmonth'] = 'ddd, D MMM';
$string['core.dffulldate'] = 'dddd, D MMMM YYYY h[:]mm A';
$string['core.dflastweekdate'] = 'ddd';
$string['core.dfmediumdate'] = 'LLL';
$string['core.dftimedate'] = 'h[:]mm A';
$string['core.discard'] = 'Сбросить';
$string['core.dismiss'] = 'Распустить';
$string['core.downloading'] = 'Загрузка';
$string['core.emptysplit'] = 'Эта страница отобразится незаполненной, если левая панель пуста или загружается.';
$string['core.errorchangecompletion'] = 'Во время изменения статуса завершения возникла ошибка. Пожалуйста, попробуйте снова.';
$string['core.errordeletefile'] = 'Ошибка при удалении файла. Пожалуйста, попробуйте снова.';
$string['core.errordownloading'] = 'Ошибка загрузки файла';
$string['core.errordownloadingsomefiles'] = 'Ошибка загрузки файлов. Некоторые файлы могут отсутствовать.';
$string['core.errorfileexistssamename'] = 'Файл с таким именем уже существует.';
$string['core.errorinvalidform'] = 'Форма содержит неверные данные. Пожалуйста, проверьте, что все требуемые поля заполнены и что данные верны.';
$string['core.errorinvalidresponse'] = 'Получен некорректный ответ. Пожалуйста, свяжитесь с администратором вашего сайта, если при последующих попытках ошибка не пропадёт.';
$string['core.errorloadingcontent'] = 'Ошибка загрузки содержимого.';
$string['core.erroropenfilenoapp'] = 'Ошибка открытия файла: не найдено приложение для открытия данного типа файла.';
$string['core.erroropenfilenoextension'] = 'Ошибка открытия файла: файл не имеет расширения.';
$string['core.erroropenpopup'] = 'Это действие пытается открыть всплывающее окно. Это не поддерживается в приложении.';
$string['core.errorrenamefile'] = 'Ошибка переименовывания файла. Пожалуйста, попытайтесь снова.';
$string['core.errorsync'] = 'При синхронизации возникла ошибка. Пожалуйста, попробуйте снова.';
$string['core.errorsyncblocked'] = 'В данный момент это {{$a}} не может быть синхронизировано по причине выполняющегося процесса. Пожалуйста, попытайтесь ещё раз позже. Если при последующих попытках ошибка не пропадёт, попробуйте перезапустить приложение.';
$string['core.filenameexist'] = 'Имя файла уже существует: {{$a}}';
$string['core.fileuploader.audio'] = 'Аудио';
$string['core.fileuploader.camera'] = 'Камера';
$string['core.fileuploader.confirmuploadfile'] = 'Вы собираетесь загрузить {{size}}. Вы уверены, что хотите продолжить?';
$string['core.fileuploader.confirmuploadunknownsize'] = 'Оценить размер загружаемых на сервер данных не удалось. Вы уверены, что хотите продолжить?';
$string['core.fileuploader.errorcapturingaudio'] = 'Ошибка захвата звука';
$string['core.fileuploader.errorcapturingimage'] = 'Ошибка захвата изображения';
$string['core.fileuploader.errorcapturingvideo'] = 'Ошибка захвата видео';
$string['core.fileuploader.errorgettingimagealbum'] = 'Ошибка получения изображения из альбома';
$string['core.fileuploader.errormustbeonlinetoupload'] = 'Вы должны быть на сайте, чтобы загружать файлы.';
$string['core.fileuploader.errornoapp'] = 'У Вас не установлено приложение для выполнения этого действия.';
$string['core.fileuploader.errorreadingfile'] = 'Ошибка при чтении файла';
$string['core.fileuploader.errorwhileuploading'] = 'Произошла ошибка во время загрузки файла';
$string['core.fileuploader.file'] = 'Файл';
$string['core.fileuploader.fileuploaded'] = 'Файл загружен';
$string['core.fileuploader.maxbytesfile'] = 'Файл {{$a.file}} слишком большой. Максимальный размер, который вы можете загрузить на сервер {{$a.size}}.';
$string['core.fileuploader.photoalbums'] = 'Фотоальбомы';
$string['core.fileuploader.readingfile'] = 'Чтение файла';
$string['core.fileuploader.selectafile'] = 'Выбрать файл';
$string['core.fileuploader.uploadafile'] = 'Загрузка файла';
$string['core.fileuploader.uploading'] = 'Загрузка';
$string['core.fileuploader.uploadingperc'] = 'Загрузка на сервер {{$a}}%';
$string['core.fileuploader.video'] = 'Видео';
$string['core.fullnameandsitename'] = '{{fullname}} ({{sitename}})';
$string['core.hasdatatosync'] = 'Это {{$a}} имеет данные, добавленные вне сети, для синхронизации.';
$string['core.humanreadablesize'] = '{{size}} {{unit}}';
$string['core.image'] = 'Изображение';
$string['core.imageviewer'] = 'Средство отображения изображений';
$string['core.lastdownloaded'] = 'Последнее загруженное';
$string['core.lastsync'] = 'Последняя синхронизация';
$string['core.loadmore'] = 'Загрузить больше';
$string['core.login.authenticating'] = 'Аутентификация';
$string['core.login.confirmdeletesite'] = 'Вы уверены, что хотите удалить сайт {{sitename}}?';
$string['core.login.connect'] = 'Подключено!';
$string['core.login.connecttomoodle'] = 'Подключение к Moodle';
$string['core.login.credentialsdescription'] = 'Пожалуйста, укажите Ваш логин и пароль для входа.';
$string['core.login.emailnotmatch'] = 'Адреса электронной почты не совпадают';
$string['core.login.erroraccesscontrolalloworigin'] = 'Запрос «Cross-Origin», который вы пытаетесь выполнить, отклонён. Пожалуйста, проверьте https://docs.moodle.org/dev/Moodle_Mobile_development_using_Chrome_or_Chromium';
$string['core.login.errordeletesite'] = 'При удалении этой страницы произошла ошибка. Пожалуйста, попробуйте еще раз.';
$string['core.login.errorupdatesite'] = 'При обновлении ключа сайта произошла ошибка.';
$string['core.login.invalidaccount'] = 'Пожалуйста, проверьте свои регистрационные данные или обратитесь к администратору сайта, чтобы он проверил настройки сайта.';
$string['core.login.invalidmoodleversion'] = 'Устаревшая версия Moodle. Минимальная требуемая версия - {{$a}} или новее.';
$string['core.login.invalidsite'] = 'URL-адрес сайта недействителен.';
$string['core.login.invalidtime'] = 'Некорректное время';
$string['core.login.invalidvaluemax'] = 'Максимальное значение: {{$a}}';
$string['core.login.invalidvaluemin'] = 'Минимальное значение: {{$a}}';
$string['core.login.loginbutton'] = 'Войти';
$string['core.login.mobileservicesnotenabled'] = 'Мобильный доступ отключен на вашем сайте. Пожалуйста, обратитесь к администратору вашего сайта, если вы считаете что мобильный доступ должен быть включен.';
$string['core.login.notloggedin'] = 'Вы должны быть идентифицированы.';
$string['core.login.passwordrequired'] = 'Требуется пароль';
$string['core.login.recaptchachallengeimage'] = 'картинка испытания reCAPTCHA';
$string['core.login.reconnect'] = 'Переподключение';
$string['core.login.searchby'] = 'Искать по:';
$string['core.login.selectsite'] = 'Пожалуйста, выберите ваш сайт:';
$string['core.login.signupplugindisabled'] = '{{$a}} не включено.';
$string['core.login.siteaddress'] = 'Адрес сайта';
$string['core.login.siteinmaintenance'] = 'Ваш сайт находится в режиме обслуживания';
$string['core.login.sitepolicynotagreederror'] = 'Политика сайта не принята.';
$string['core.login.siteurl'] = 'URL-адрес сайта';
$string['core.login.siteurlrequired'] = 'Требуется URL-адрес сайта, напр. <i>http://www.yourmoodlesite.org</i>';
$string['core.login.stillcantconnect'] = 'Всё ещё не можете подключиться?';
$string['core.login.usernamerequired'] = 'Требуется логин';
$string['core.login.visitchangepassword'] = 'Вы хотите посетить сайт, чтобы сменить пароль?';
$string['core.login.webservicesnotenabled'] = 'Сетевые службы не включены на сайте. Пожалуйста, обратитесь к администратору вашего сайта, если вы считаете, что они должны быть включены.';
$string['core.lostconnection'] = 'Ваш ключ аутентификации недействителен или просрочен. Вам придется повторно подключиться к сайту.';
$string['core.networkerrormsg'] = 'С подключением к сайту была проблема. Пожалуйста, проверьте ваше соединение и попытайтесь снова.';
$string['core.nopasswordchangeforced'] = 'Вы не можете продолжить, не поменяв свой пароль.';
$string['core.notapplicable'] = 'н/д';
$string['core.notsent'] = 'Не отправлено';
$string['core.openfullimage'] = 'Нажмите здесь, чтобы отобразить полноразмерное изображение';
$string['core.openinbrowser'] = 'Открыть в браузере';
$string['core.percentagenumber'] = '{{$a}}%';
$string['core.pulltorefresh'] = 'Потяните, чтобы обновить';
$string['core.question.errorquestionnotsupported'] = 'Данный тип вопросов пока не поддерживается приложением: {{$a}}.';
$string['core.question.howtodraganddrop'] = 'Нажмите, чтобы выбрать, затем нажмите, чтобы сбросить.';
$string['core.question.questionmessage'] = 'Вопрос {{$a}}: {{$b}}';
$string['core.redirectingtosite'] = 'Вы будете перенаправлены на сайт.';
$string['core.requireduserdatamissing'] = 'У этого пользователя не хватает необходимых данных профиля. Пожалуйста, введите данные на вашем сайте и попытайтесь снова.<br>{{$a}}';
$string['core.retry'] = 'Попробовать снова';
$string['core.searching'] = 'Поиск';
$string['core.settings.about'] = 'О приложении';
$string['core.settings.cannotsyncoffline'] = 'Невозможно синхронизировать пока не в сети.';
$string['core.settings.cannotsyncwithoutwifi'] = 'Невозможно синхронизироваться, потому что настоящие настройки разрешают синхронизироваться только когда есть подключение к Wi-Fi. Пожалуйста, подключитесь к сети Wi-Fi.';
$string['core.settings.colorscheme-dark'] = 'Темная';
$string['core.settings.colorscheme-light'] = 'Светлая';
$string['core.settings.colorscheme-system'] = 'По умолчанию для системы';
$string['core.settings.cordovadevicemodel'] = 'Модель устройства Cordova';
$string['core.settings.cordovadeviceosversion'] = 'Версия ОС устройства Cordova';
$string['core.settings.cordovadeviceplatform'] = 'Платформа устройства Cordova';
$string['core.settings.cordovadeviceuuid'] = 'UUID устройства Cordova';
$string['core.settings.cordovaversion'] = 'Версия Cordova';
$string['core.settings.deviceinfo'] = 'Информация об устройстве';
$string['core.settings.deviceos'] = 'ОС устройства';
$string['core.settings.displayformat'] = 'Формат отображения';
$string['core.settings.enabledownloadsection'] = 'Показать материалы, доступные для скачивания';
$string['core.settings.enablerichtexteditor'] = 'Включить текстовый редактор';
$string['core.settings.enablerichtexteditordescription'] = 'При включении функции текстовый редактор будет доступен во время ввода содержимого.';
$string['core.settings.estimatedfreespace'] = 'Ориентировочное свободное место';
$string['core.settings.filesystemroot'] = 'Корень файловой системы';
$string['core.settings.fontsize'] = 'Размер текста';
$string['core.settings.helpusimprove'] = 'Помогите нам улучшить приложение';
$string['core.settings.localnotifavailable'] = 'Локальные уведомления доступны';
$string['core.settings.locationhref'] = 'URL компонента Web view';
$string['core.settings.navigatorlanguage'] = 'Язык навигатора';
$string['core.settings.navigatoruseragent'] = 'userAgent навигатора';
$string['core.settings.networkstatus'] = 'Статус подключения к интернету';
$string['core.settings.privacypolicy'] = 'Политика конфиденциальности';
$string['core.settings.publisher'] = 'Издатель';
$string['core.settings.reportinbackground'] = 'Автоматически оповещать об ошибках';
$string['core.settings.screen'] = 'Информация об экране';
$string['core.settings.siteinfo'] = 'Информация о сайте';
$string['core.settings.spaceusage'] = 'Используемое пространство';
$string['core.settings.synchronization'] = 'Синхронизация';
$string['core.settings.synchronizenow'] = 'Синхронизировать сейчас';
$string['core.settings.syncsettings'] = 'Настройки синхронизации';
$string['core.settings.wificonnection'] = 'Подключение Wi-Fi';
$string['core.sharedfiles.chooseaccountstorefile'] = 'Выберите учётную запись для хранения файла.';
$string['core.sharedfiles.chooseactionrepeatedfile'] = 'Файл с таким именем уже существует. Вы хотите заменить существующий файл или переименовать этот файл в «{{$a}}»?';
$string['core.sharedfiles.errorreceivefilenosites'] = 'Нет сохранённых сайтов. Добавьте сайт чтобы делиться файлом при помощи приложения.';
$string['core.sharedfiles.nosharedfiles'] = 'На этом сайте нет открытых для доступа файлов.';
$string['core.sharedfiles.nosharedfilestoupload'] = 'У Вас нет файлов для загрузки на сервер. Если Вы хотите загрузить на сервер файл из другого приложения, найдите файл и нажмите кнопку «Открыть в».';
$string['core.sharedfiles.rename'] = 'Переименовать';
$string['core.sharedfiles.replace'] = 'Переместить';
$string['core.sharedfiles.sharedfiles'] = 'Файлы в открытом доступе';
$string['core.sharedfiles.successstorefile'] = 'Файл успешно сохранён. Выберите файл для загрузки на сервер в свои личные файлы или для использования в активном элементе.';
$string['core.sizetb'] = 'Тб';
$string['core.sorry'] = 'Извините...';
$string['core.tablet'] = 'Планшет';
$string['core.thereisdatatosync'] = 'Есть {{$a}} для синхронизации, созданные вне сети.';
$string['core.tryagain'] = 'Попытаться снова';
$string['core.twoparagraphs'] = '{{p1}}<br><br>{{p2}}';
$string['core.uhoh'] = 'Ой, ой!';
$string['core.unexpectederror'] = 'Неизвестная ошибка. Пожалуйста, закройте, затем ещё раз откройте приложение и попробуйте снова.';
$string['core.unicodenotsupported'] = 'Некоторые смайлики не поддерживаются на этом сайте. Такие символы будут удалены при отправке сообщения.';
$string['core.unicodenotsupportedcleanerror'] = 'Был обнаружен пустой текст при очистке символов Unicode.';
$string['core.unknown'] = 'Неизвестно';
$string['core.unzipping'] = 'Распаковка';
$string['core.updaterequired'] = 'Требуется обновление приложения';
$string['core.updaterequireddesc'] = 'Пожалуйста, обновите приложение до версии {{$a}}';
$string['core.user.contact'] = 'Контакты';
$string['core.user.detailsnotavailable'] = 'Вам не доступны подробности этого пользователя';
$string['core.user.errorloaduser'] = 'Ошибка загрузки пользователя';
$string['core.user.sendemail'] = 'Электронная почта';
$string['core.user.userwithid'] = 'Пользователь с ID {{id}}';
$string['core.warningofflinedatadeleted'] = 'Данные, добавленные вне сети, из {{component}} «{{name}}» были удалены. {{error}}';
$string['core.whyisthishappening'] = 'Почему так происходит?';
$string['core.wsfunctionnotavailable'] = 'Функция веб-службы не доступна.';
$string['pluginname'] = 'Строки языка «Moodle Mobile»';
