<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'moodle', language 'it', version '5.0'.
 *
 * @package     moodle
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['abouttobeinstalled'] = 'in procinto di essere installata';
$string['accept'] = 'Accetta';
$string['action'] = 'Azione';
$string['actionchoice'] = 'Cosa desideri fare con il file \'{$a}\'?';
$string['actions'] = 'Azioni';
$string['actionsfor'] = 'Azione su {$a}';
$string['actionsmenu'] = 'Menu delle azioni';
$string['active'] = 'Attivo';
$string['activeusers'] = 'Utenti attivi';
$string['activities'] = 'Attività';
$string['activities_help'] = 'Le attività, come i forum, i quiz, i wiki, consentono di inserire contenuti interattivi nei corsi.';
$string['activity'] = 'Attività';
$string['activityclipboard'] = 'Spostamento dell\'attività {$a}';
$string['activityheader'] = 'Menu attività';
$string['activityicon'] = 'Icona {$a}';
$string['activityiscurrentlyhidden'] = 'Purtroppo al momento questa attività è nascosta';
$string['activitymodule'] = 'Modulo attività';
$string['activitymodules'] = 'Moduli attività';
$string['activitynotready'] = 'Attività non ancora pronta';
$string['activityorresource'] = 'Attività o risorsa';
$string['activityreport'] = 'Report delle attività';
$string['activityreports'] = 'Report delle attività';
$string['activityselect'] = 'Seleziona questa attività per spostarla altrove';
$string['activitysince'] = 'Attività a partire da {$a}';
$string['activitytypetitle'] = '{$a->activity} - {$a->type}';
$string['activityweighted'] = 'Attività per utente';
$string['add'] = 'Aggiungi';
$string['addactivity'] = 'Aggiungi un\'attività...';
$string['addactivitytosection'] = 'Aggiungi un\'attività alla sezione \'{$a}\'';
$string['addadmin'] = 'Aggiungi amministratore';
$string['addblock'] = 'Aggiungi un blocco';
$string['addcomment'] = 'Aggiungi un commento...';
$string['addcondition'] = 'Aggiungi condizione';
$string['addcontent'] = 'Aggiungi contenuto';
$string['addcountertousername'] = 'Crea utente aggiungendo un numero al nome utente';
$string['addcreator'] = 'Aggiungi creatore corsi';
$string['adddots'] = 'Aggiungi...';
$string['added'] = 'Aggiunto {$a}';
$string['addedtogroup'] = 'Aggiunto al gruppo "{$a}"';
$string['addedtogroupnot'] = 'Non è stato aggiunto al gruppo {$a}';
$string['addedtogroupnotenrolled'] = 'Non è stato aggiunto al gruppo "{$a}" in quanto non iscritto al corso';
$string['addfilehere'] = 'Rilasciare qui i file per aggiungerli in fondo alla sezione';
$string['addfilesdrop'] = 'È possibile trascinare e rilasciare file per caricarli, oppure fare click per selezionarli.';
$string['addinganew'] = 'Nuovo {$a}';
$string['addingdatatoexisting'] = 'Aggiungi a dati esistenti';
$string['additionalcustomnav'] = 'Navigazione personalizzata aggiuntiva';
$string['additionalnames'] = 'Nomi aggiuntivi';
$string['addlinkhere'] = 'Aggiungi collegamento qui';
$string['addnew'] = 'Aggiungi {$a}';
$string['addnewcategory'] = 'Aggiungi una nuova categoria';
$string['addnewcourse'] = 'Aggiungi corso';
$string['addnewuser'] = 'Nuovo utente';
$string['addnousersrecip'] = 'Aggiungi all\'elenco dei destinatari gli utenti che non hanno mai acceduto {$a}';
$string['addpagehere'] = 'Aggiungi testo qui';
$string['addresource'] = 'Aggiungi una risorsa...';
$string['addresourceoractivity'] = 'Aggiungi un\'attività o una risorsa';
$string['addresourcetosection'] = 'Aggiungi una risorsa alla sezione \'{$a}\'';
$string['address'] = 'Indirizzo';
$string['addsections'] = 'Aggiungi sezione';
$string['addstudent'] = 'Aggiungi studente';
$string['addsubcategory'] = 'Aggiungi una sottocategoria';
$string['addteacher'] = 'Aggiungi docente';
$string['admin'] = 'Amministratore';
$string['adminhelpaddnewuser'] = 'Per creare manualmente un nuovo account utente';
$string['adminhelpassignadmins'] = 'Gli amministratori possono fare tutto ed andare dovunque nel sito';
$string['adminhelpassigncreators'] = 'I creatori di corsi posso creare nuovi corsi';
$string['adminhelpassignsiteroles'] = 'Applica i ruoli del sito a specifici utenti';
$string['adminhelpassignstudents'] = 'Accedi al corso e aggiungi studenti dal menu amministrazione';
$string['adminhelpauthentication'] = 'Puoi usare account di utenti interni o banche dati esterne';
$string['adminhelpbackup'] = 'Imposta backup automatici e la loro programmazione';
$string['adminhelpconfiguration'] = 'Configura l\'aspetto e il funzionamento del sito';
$string['adminhelpconfigvariables'] = 'Configura le variabili che interessano il funzionamento generale del sito';
$string['adminhelpcourses'] = 'Definisci corsi e categorie e associali alle persone, modifica corsi in sospeso';
$string['adminhelpeditorsettings'] = 'Definisci le impostazioni di base per conto del editor HTML';
$string['adminhelpedituser'] = 'Visualizza l\'elenco degli utenti e modificali';
$string['adminhelpenvironment'] = 'Verificare se il server supporta la versione installata e le versioni future di Moodle';
$string['adminhelpfailurelogs'] = 'Visualizza registro degli accessi falliti';
$string['adminhelplanguage'] = 'Per controllare e modificare l\'elenco delle lingue attualmente disponibili';
$string['adminhelplogs'] = 'Sfoglia il registro di tutte le attività su questo sito';
$string['adminhelpmanageblocks'] = 'Gestisci i blocchi installati e le loro impostazioni';
$string['adminhelpmanagedatabase'] = 'Accedi direttamente alla banca dati (fare attenzione!)';
$string['adminhelpmanagefilters'] = 'Scegli i filtri testuali e le relative impostazioni';
$string['adminhelpmanagemodules'] = 'Gestisci i moduli installati e le loro impostazioni';
$string['adminhelpmanageroles'] = 'Crea e definisci i ruoli che possono essere assegnati agli utenti';
$string['adminhelpmymoodle'] = 'Configura i blocchi MyMoodle per gli utenti';
$string['adminhelpreports'] = 'Report per l\'intero sito';
$string['adminhelpsitefiles'] = 'Per pubblicare file generici e caricare copie di salvataggio esterne';
$string['adminhelpsitesettings'] = 'Definisce l\'aspetto della home del sito';
$string['adminhelpstickyblocks'] = 'Imposta blocchi "permanenti" per tutto il sito Moodle';
$string['adminhelpthemes'] = 'Scelta del tema del sito (colori, caratteri, ecc)';
$string['adminhelpuploadusers'] = 'Importa registrazioni di nuovi utenti da un file di testo';
$string['adminhelpusers'] = 'Definisci e configura il metodo di autenticazione degli utenti';
$string['adminhelpxmldbeditor'] = 'Interfaccia per la modifica dei files XMLDB. Solo per sviluppatori.';
$string['administration'] = 'Amministrazione';
$string['administrationsite'] = 'Amministrazione del sito';
$string['administrator'] = 'Amministratore';
$string['administratordescription'] = 'Di norma gli Amministratori possono fare qualsiasi cosa nel sito ed in tutti i corsi.';
$string['administrators'] = 'Amministratori';
$string['administratorsall'] = 'Tutti gli amministratori';
$string['administratorsandteachers'] = 'Amministratori e docenti';
$string['advanced'] = 'Avanzata';
$string['advancedfilter'] = 'Ricerca avanzata';
$string['advancedsettings'] = 'Impostazioni avanzate';
$string['afterresource'] = 'Dopo la risorsa "{$a}"';
$string['aftersection'] = 'Dopo la sezione "{$a}"';
$string['again'] = 'ancora';
$string['agelocationverification'] = 'Verifica dell\'età e della nazione';
$string['ajaxuse'] = 'AJAX e Javascript';
$string['all'] = 'Tutto';
$string['allactions'] = 'Tutte le azioni';
$string['allactivities'] = 'Tutte le attività';
$string['allcategories'] = 'Tutte le categorie';
$string['allchanges'] = 'Tutte le modifiche';
$string['alldays'] = 'Tutti i giorni';
$string['allfiles'] = 'Tutti i file';
$string['allgroups'] = 'Tutti i gruppi';
$string['alllogs'] = 'Tutti i log';
$string['allmods'] = 'Tutti {$a}';
$string['allow'] = 'Consenti';
$string['allowinternal'] = 'Consenti anche i metodi interni';
$string['allownone'] = 'Non consentire niente';
$string['allownot'] = 'Non consentire';
$string['allowstealthmodules'] = 'Consenti attività invisibili';
$string['allowstealthmodules_help'] = 'Consente di creare attività disponibili agli studenti ma non visibili nella pagina home del corso. Affinché sia possibile accedere alle attività invisibili, sarà necessario fornire manualmente i link di accesso. Le attività invisibili saranno elencate nel registro valutatore e nei report.';
$string['allparticipants'] = 'Tutti i partecipanti';
$string['allteachers'] = 'Tutti i docenti';
$string['alphanumerical'] = 'Può contenere solamente caratteri alfanumerici, il segno meno (-) o il punto (.)';
$string['alreadyconfirmed'] = 'La registrazione è già stata confermata';
$string['alternatename'] = 'Nome alternativo';
$string['always'] = 'Sempre';
$string['and'] = '{$a->one} e {$a->two}';
$string['answer'] = 'Risposta';
$string['any'] = 'Qualsiasi';
$string['appearance'] = 'Aspetto';
$string['apply'] = 'Applica';
$string['applyfilters'] = 'Applica filtri';
$string['approve'] = 'Approva';
$string['areyousure'] = 'Sei sicuro?';
$string['areyousuretorestorethis'] = 'Sei sicuro di continuare?';
$string['areyousuretorestorethisinfo'] = 'Più avanti  verrà chiesto di ripristinare il backup aggiungendo i dati ad un corso esistente oppure di creare un corso nuovo.';
$string['asc'] = 'Crescente';
$string['assessment'] = 'Valutazione';
$string['assignadmins'] = 'Assegna amministratori';
$string['assigncreators'] = 'Assegna creatori corsi';
$string['assignedrolecount'] = '{$a->role}: {$a->count}';
$string['assignsiteroles'] = 'Attribuisci ruoli a livello di sito';
$string['authenticateduser'] = 'Utente autenticato';
$string['authenticateduserdescription'] = 'Tutti gli utenti autenticati.';
$string['authentication'] = 'Autenticazione';
$string['authenticationplugins'] = 'Plugin di autenticazione';
$string['autosubscribe'] = 'Sottoscrizione automatica forum';
$string['autosubscribeno'] = 'No: non sottoscrivo le discussioni automaticamente';
$string['autosubscribeyes'] = 'Si: quando invio messaggi, sottoscrivo la discussione automaticamente';
$string['availability'] = 'Disponibilità';
$string['availablecourses'] = 'Corsi disponibili';
$string['back'] = 'Indietro';
$string['backto'] = 'Torna a {$a}';
$string['backtocourselisting'] = 'Torna all\'elenco dei corsi';
$string['backtohome'] = 'Torna alla pagina home del sito';
$string['backtopageyouwereon'] = 'Torna alla pagina di provenienza';
$string['backup'] = 'Backup';
$string['backupactivehelp'] = 'Scegli se automatizzare o meno i backup';
$string['backupadhocpending'] = 'Elaborazione in attesa: backup ad hoc del corso';
$string['backupcancelled'] = 'Backup annullato';
$string['backupcoursefileshelp'] = 'Se abilitato, i file del corso saranno inclusi nel backup automatico';
$string['backupdate'] = 'Data del backup';
$string['backupdatenew'] = '{$a->TAG} ora è {$a->weekday}, {$a->mday} {$a->month} {$a->year}<br />';
$string['backupdateold'] = '{$a->TAG} era {$a->weekday}, {$a->mday} {$a->month} {$a->year}';
$string['backupdaterecordtype'] = '<br />{$a->recordtype} - {$a->recordname}<br />';
$string['backupdetails'] = 'Dettagli del backup';
$string['backuperrorinvaliddestination'] = 'La cartella di backup non esiste o non è scrivibile.';
$string['backupexecuteathelp'] = 'L\'orario per effettuare i backup automatici';
$string['backupfailed'] = 'Alcuni corsi non sono stati salvati.';
$string['backupfilename'] = 'backup';
$string['backupfinished'] = 'Backup completato correttamente';
$string['backupfromthissite'] = 'Sono stati eseguiti backup in questo sito?';
$string['backupgradebookhistoryhelp'] = 'Se abilitato, lo storico delle valutazioni verrà incluso nei backup automatici. Affinché questa impostazione funzioni correttamente è necessario che lo storico delle valutazioni sia abilitato al livello di sistema.';
$string['backupincludemoduleshelp'] = 'Scegliere se includere nei backup automatici i moduli dei corsi, con o senza i dati utente.';
$string['backupincludemoduleuserdatahelp'] = 'Scegliere se vuoi includere i dati utente dei moduli nei backup automatici';
$string['backupinfo'] = 'Crea una copia di questo corso, includendo tutti i contenuti e le attività aggiornati. È possibile utilizzare il file di backup per ripristinare il corso.';
$string['backuplogdetailed'] = 'Log dettagliato';
$string['backuploglaststatus'] = 'Log del backup più recente';
$string['backupmissinguserinfoperms'] = 'Nota: questo backup non contiene dati utente. Le attività Esercizio e workshop non saranno incluse nel backup poiché queste attività non sono compatibili con i backup privi di dati utente.';
$string['backupnext'] = 'Prossimo backup';
$string['backupnonisowarning'] = 'Attenzione: questo backup proviene da una versione di Moodle (pre 1.6) non-Unicode. Se il backup contiene testo non-ISO-8859-1, questo potrebbe essere ALTERATO se ne viene fatto il ripristino sulla presente versione Unicode di Moodle. Leggere <a href="http://docs.moodle.org/en/Backup_FAQ">Backup FAQ</a> per maggiori informazioni su come ripristinare correttamente questo backup.';
$string['backupnotyetrun'] = 'Backup automatico in attesa';
$string['backuporiginalname'] = 'Nome del backup';
$string['backuproleassignments'] = 'Backup delle assegnazioni di questi ruoli';
$string['backupsavetohelp'] = 'Percorso della cartella dove salvare i file di backup';
$string['backupsitefileshelp'] = 'Se abilitato, i file del sito saranno inclusi nei backup automatici';
$string['backuptakealook'] = 'Si prega di controllare i log dei backup in: {$a}';
$string['backupuserfileshelp'] = 'Scegliere quali file utente (es immagini del profilo) devono essere inclusi nei backup automatici';
$string['backupversion'] = 'Versione del backup';
$string['badges'] = 'Badge';
$string['between'] = 'Fra';
$string['block'] = 'Blocco';
$string['blockconfiga'] = 'Configurazione del blocco {$a}';
$string['blockconfigbad'] = 'Questo blocco non è stato implementato correttamente e pertanto non è possibile fornire un\'interfaccia di configurazione.';
$string['blocks'] = 'Blocchi';
$string['blocks_main'] = 'Blocchi di contenuto principale';
$string['blocks_supplementary'] = 'Blocchi supplementari';
$string['blocksaddedit'] = 'Aggiung/Modifica blocchi';
$string['blockseditoff'] = 'Termina modifica blocchi';
$string['blocksediton'] = 'Attiva modifica blocchi';
$string['blocksetup'] = 'Impostazione tabelle blocchi';
$string['blocksuccess'] = 'le tabelle {$a} sono state correttamente impostate';
$string['brief'] = 'Riassuntivo';
$string['bulkactions'] = 'Azioni in massa';
$string['bulkactionselect'] = '{$a} selezioni per azioni in massa';
$string['bulkcancel'] = 'Chiudi modifica in massa';
$string['bulkmovecoursessuccess'] = '{$a->courses} corsi sono stati spostati correttamente  nella categoria {$a->category}';
$string['bulkselection'] = 'Sezionanti: {$a}';
$string['bycourseorder'] = 'Ordina per corso';
$string['byname'] = 'di {$a}';
$string['bypassed'] = 'Aggirato';
$string['cachecontrols'] = 'Controlli cache';
$string['calltofeedback'] = 'Gli sviluppatori di questo software desiderano ascoltare il tuo feedback';
$string['calltofeedback_give'] = 'Invia feedback su questo software';
$string['calltofeedback_remind'] = 'Ricordamelo più tardi';
$string['cancel'] = 'Annulla';
$string['cancelled'] = 'Annullato';
$string['categories'] = 'Categorie di corso';
$string['categoriesandcourses'] = 'Categorie di corso e corsi';
$string['category'] = 'Categoria';
$string['categoryadded'] = 'La categoria \'{$a}\' è stata aggiunta';
$string['categorybulkaction'] = 'Azioni per tutte le categorie selezionate';
$string['categorycontents'] = 'Sotto categorie e corsi';
$string['categorycurrentcontents'] = 'Contenuto di {$a}';
$string['categorydeleted'] = 'La categoria \'{$a}\' è stata eliminata';
$string['categoryduplicate'] = 'Esiste già una categoria di nome \'{$a}\'!';
$string['categoryheader'] = 'Menu categorie';
$string['categoryhidden'] = '(nascosto)';
$string['categorymodifiedcancel'] = 'La categoria è stata modificata! Annulla e riprova.';
$string['categoryname'] = 'Nome categoria';
$string['categorypath'] = 'Percorso categoria';
$string['categorysubcategoryof'] = '{$a->category} - sottocategoria di {$a->parentcategory}';
$string['categoryupdated'] = 'La categoria \'{$a}\' è stata aggiornata';
$string['changedpassword'] = 'Password modificata';
$string['changepassword'] = 'Cambia password';
$string['changesmade'] = 'Modifiche apportate';
$string['changesmadereallygoaway'] = 'Hai effettuato delle modifiche. Sei sicuro di navigare altrove e perdere le modifiche ?';
$string['changessaved'] = 'Modifiche salvate';
$string['check'] = 'Verifica';
$string['checkactual'] = 'Effettivo';
$string['checkall'] = 'Verifica tutto';
$string['checkerror'] = 'Si è verificato un errore nell\'ottenere il risultato della verifica \'{$a}\'. Controllare la console del browser per ulteriori informazioni.';
$string['checkexpected'] = 'Atteso';
$string['checkingbackup'] = 'Verifica backup';
$string['checkingcourse'] = 'Verifica corso';
$string['checkingforbbexport'] = 'Verifica per l\'esportazione BlackBoard';
$string['checkinginstances'] = 'Verifica istanze';
$string['checkingsections'] = 'Verifica sezioni';
$string['checklanguage'] = 'Verifica lingua';
$string['checkloading'] = 'Ottenimento del risultato della veririca \'{$a}\'';
$string['checknone'] = 'Verifica nulla';
$string['checks'] = 'Verifiche';
$string['checksok'] = 'Le verifiche su \'{$a}\' sono andate tutte a buon fine';
$string['childcoursenotfound'] = 'Il corso figlio non è stato trovato!';
$string['childcourses'] = 'Corsi figli';
$string['choose'] = 'Seleziona';
$string['choosecourse'] = 'Scegli un corso';
$string['choosedots'] = 'Scegli...';
$string['chooselivelogs'] = 'Oppure osserva le attività  in corso';
$string['chooselogs'] = 'Scegli i log da visualizzare';
$string['choosereportfilter'] = 'Seleziona un filtro per il report';
$string['choosetheme'] = 'Seleziona un tema';
$string['chooseuser'] = 'Seleziona un utente';
$string['city'] = 'Città /Località';
$string['cleaningtempdata'] = 'Eliminazione dati temporanei';
$string['clear'] = 'Svuota';
$string['clearall'] = 'Cancella tutto';
$string['clearfilterrow'] = 'Elimina riga del filtro';
$string['clearfilters'] = 'Azzera filtri';
$string['clearsearch'] = 'Elimina le selezioni della ricerca';
$string['clickhelpiconformoreinfo'] = '...prosegue...Fate click sulla icona aiuto per accedere all\'articolo completo';
$string['clickhere'] = 'Clicca qui ...';
$string['clicktohideshow'] = 'Click per aprire e chiudere';
$string['closeblockdrawer'] = 'Chiudi cassetto dei blocchi';
$string['closebuttontitle'] = 'Chiudi';
$string['closecourseindex'] = 'Chiudi indice del corso';
$string['closedrawer'] = 'Chiudi cassetto';
$string['closewindow'] = 'Chiudi questa finestra';
$string['collapse'] = 'Minimizza';
$string['collapseall'] = 'Minimizza tutto';
$string['collapsecategory'] = 'Minimizza {$a}';
$string['comebacklater'] = 'Per favore riprovare più tardi.';
$string['commentincontext'] = 'Trova questo commento nel contesto';
$string['comments'] = 'Commenti';
$string['commentscount'] = 'Commenti: ({$a})';
$string['commentsnotenabled'] = 'La funzionalità commenti non è abilitata';
$string['commentsrequirelogin'] = 'Per visualizzare i commenti è necessario autenticarsi.';
$string['comparelanguage'] = 'Confronta e modifica la lingua in uso';
$string['complete'] = 'Completo';
$string['completed'] = 'Completato';
$string['completereport'] = 'Report completo';
$string['configuration'] = 'Configurazione';
$string['confirm'] = 'Conferma';
$string['confirmaccount'] = 'Conferma account';
$string['confirmcheckfull'] = 'Sei sicuro di confermare {$a}?';
$string['confirmcoursemove'] = 'Sei sicuro di spostare il corso ({$a->course}) nella categoria  ({$a->category})?';
$string['confirmdeletesection'] = 'Sei sicuro di eliminare "{$a}" e tutte le attività che contiene?';
$string['confirmed'] = 'La registrazione è stata confermata';
$string['confirmednot'] = 'La registrazione non è stata ancora confermata. Per favore controlla la tua casella postale per eventuali mail di conferma.';
$string['considereddigitalminor'] = 'Sei troppo giovane per creare un account su questo sito.';
$string['contactsbyrolelist'] = '{$a->role}: {$a->contacts}';
$string['content'] = 'Contenuto';
$string['contentbank'] = 'Deposito dei contenuti';
$string['contentexport_aboutthiscourse'] = 'Riassunto del corso';
$string['contentexport_coursesummary'] = 'Il file fa parte del contenuto di <a href="{$a->courselink}">{$a->coursename}</a>.';
$string['contentexport_footersummary'] = 'Il file fa parte del contenuto di <a href="{$a->courselink}">{$a->coursename}</a> e scaricato da {$a->userfullname} il {$a->date}.';
$string['contentexport_modulesummary'] = 'La pagina fa parte del contenuto di <a href="{$a->modulelink}">{$a->modulename}</a> scaricato il {$a->date}. Da notare che porzioni del contenuto e file più grandi di {$a->maxfilesize} non sono stati scaricati.';
$string['contentexport_viewfilename'] = 'Visualizza il file {$a}';
$string['context'] = 'Contesto';
$string['contextlevel'] = 'Livello del contesto';
$string['contextname'] = 'Nome del contesto';
$string['contextparent'] = 'Genitore';
$string['contexturl'] = 'URL del contesto';
$string['continue'] = 'Continua';
$string['continuetocourse'] = 'Clicca qui per entrare nel corso';
$string['convertingwikitomarkdown'] = 'È in corso la conversione del wiki al formato Markdown';
$string['cookiesenabled'] = 'Il browser deve avere i cookie abilitati';
$string['cookiesenabled_help'] = 'Il sito utilizza due tipi di cookie:

Il primo è un cookie di sessione ed è normalmente chiamato MoodleSession. È un cookie essenziale ed è indispensabile che il browser sia configurato per accettare questo cookie al fine di garantire la validità della propria autenticazione navigando tra le pagine. Quando si chiuderà il browser o si effettuerà la disconnessione, il cookie verrà eliminato, sia dal browser sia dal server.

Il secondo cookie, generalmente chiamato MOODLEID, serve solo per ricordare il proprio username all\'interno del browser. Grazie a questo cookie quando si ritorna a far vista allo stesso sito, il campo della pagina di login sarà già compilato con lo username. Non ci sono problemi a rifiutare questo cookie, l\'unico inconveniente sarà quello di dover inserire nuovamente lo username nella pagina di login.';
$string['cookiesenabled_help_html'] = 'Il sito utilizza due tipi di cookie:<br/><br/>

Il primo è un cookie di sessione ed è normalmente chiamato MoodleSession. È un cookie essenziale ed è indispensabile che il browser sia configurato per accettare questo cookie al fine di garantire la validità della propria autenticazione navigando tra le pagine. Quando si chiuderà il browser o si effettuerà la disconnessione, il cookie verrà eliminato, sia dal browser sia dal server.<br/><br/>

Il secondo cookie, generalmente chiamato MOODLEID, serve solo per ricordare il proprio username all\'interno del browser. Grazie a questo cookie quando si ritorna a far vista allo stesso sito, il campo della pagina di login sarà già compilato con lo username. Non ci sono problemi a rifiutare questo cookie, l\'unico inconveniente sarà quello di dover inserire nuovamente lo username nella pagina di login.';
$string['cookiesenabledonlysession'] = 'Il browser deve avere i cookie abilitati';
$string['cookiesenabledonlysession_help'] = 'Il sito utilizza un cookie di sessione, normalmente chiamato MoodleSession. È indispensabile che il browser sia configurato per accettare questo cookie al fine di garantire la validità della propria autenticazione navigando tra le pagine. Quando si chiuderà il browser o si effettuerà la disconnessione, il cookie verrà eliminato, sia dal browser sia dal server.';
$string['cookiesnotenabled'] = 'Purtroppo al momento i cookie non sono abilitati nel tuo browser.';
$string['cookiesnotice'] = 'Informativa cookie';
$string['copy'] = 'copia';
$string['copyasnoun'] = 'copia';
$string['copycourse'] = 'Copia corso';
$string['copyingcoursefiles'] = 'Copia dei file del corso';
$string['copyingsitefiles'] = 'Copia dei file del sito usati nel corso';
$string['copyinguserfiles'] = 'Copia dei file utente';
$string['copyingzipfile'] = 'Copia dei file compressi';
$string['copyrightnotice'] = 'Informazioni sul copyright';
$string['copytoclipboard'] = 'Copia nella clipboard';
$string['coresystem'] = 'Sistema';
$string['cost'] = 'Costo';
$string['costdefault'] = 'Costo standard';
$string['count_of_total'] = '<strong>{$a->count}</strong> su {$a->total}';
$string['counteditems'] = '{$a->count} {$a->items}';
$string['country'] = 'Nazione';
$string['course'] = 'Corso';
$string['courseadministration'] = 'Amministrazione del corso';
$string['courseapprovedemail'] = 'Il corso da te richiesto, <a href="{$a->url}">{$a->name}</a>, è stato approvato e ti è stato assegnato il ruolo {$a->teacher}.';
$string['courseapprovedemail2'] = 'Il corso da te richiesto, <a href="{$a->url}">{$a->name}</a>., è stato approvato.';
$string['courseapprovedfailed'] = 'È fallito il salvataggio dell\'approvazione del corso';
$string['courseapprovedsubject'] = 'Il corso è stato approvato.';
$string['courseavailable'] = 'Corso disponibile agli studenti';
$string['courseavailablenot'] = 'Corso non disponibile agli studenti';
$string['coursebackup'] = 'Backup del corso';
$string['coursebulkaction'] = 'Azioni per tutti i corsi selezionati';
$string['coursecategories'] = 'Categorie di corso';
$string['coursecategory'] = 'Categoria di corsi';
$string['coursecategory_help'] = 'L\'impostazione definisce in quale categoria apparirà il corso.';
$string['coursecategorydeleted'] = 'La categoria di corsi {$a} è stata eliminata';
$string['coursecatmanagement'] = 'Gestione corsi e categorie';
$string['coursecompletion'] = 'Completamento corso';
$string['coursecompletions'] = 'Corsi completati';
$string['coursecreators'] = 'Creatore di corsi';
$string['coursecreatorsdescription'] = 'I creatori di corsi possono creare nuovi corsi.';
$string['coursedeleted'] = 'Corso {$a} eliminato';
$string['coursedetails'] = 'Dettagli corso';
$string['coursedisplay'] = 'Visualizzazione corso';
$string['coursedisplay_help'] = 'Consente di impostare il modo con cui saranno visualizzate le sezioni del corso, tutte sulla stessa pagina oppure distribuite su più pagine.';
$string['coursedisplay_multi'] = 'Visualizza una sezione per pagina';
$string['coursedisplay_single'] = 'Visualizza le sezioni nella stessa pagina';
$string['courseduration'] = 'Durata del corso';
$string['courseduration_desc'] = 'La durata del corso viene utilizzata per calcolare di default la data di fine del corso. La data di fine del corso viene utilizzata per stabilire se il corso deve apparire o meno nell\'elenco dei corsi di ciascun utente.  Gli utenti potranno comunque accedere al corso anche dopo la data di fine.';
$string['courseenddateenabled'] = 'Data di fine corso abilitata di default';
$string['courseenddateenabled_desc'] = 'Abilita di default la data di fine corso  quando si crea un nuovo corso, calcolandola in base alla durata del corso stesso.';
$string['courseextendednamedisplay'] = '{$a->shortname} {$a->fullname}';
$string['coursefiles'] = 'File legacy del corso';
$string['coursefilesedit'] = 'Gestione file legacy del corso';
$string['coursefileswarning'] = 'I file del corso sono deprecati';
$string['coursefileswarning_help'] = 'I File del corso sono stati deprecati a partire da Moodle 2.0. Per favore utilizzare i repository esterni.';
$string['courseformatdata'] = 'Dati sul formato del corso';
$string['courseformatoptions'] = 'Opzioni di formattazione di {$a}';
$string['courseformats'] = 'Formati dei corsi';
$string['courseformatudpate'] = 'Aggiorna formato';
$string['coursegrades'] = 'Valutazioni del corso';
$string['courseheader'] = 'Menu corso';
$string['coursehelpcategory'] = 'Definisce a quale categoria apparterrà il corso.';
$string['coursehelpforce'] = 'Forza la modalità gruppo prescelta in qualsiasi attività presente nel corso.';
$string['coursehelpformat'] = 'Il formato con il quale sarà visualizzata la pagina principale del corso.';
$string['coursehelphiddensections'] = 'Imposta se ed in quale modo gli studenti visualizzeranno le sezioni nascoste nella pagina principale del corso.';
$string['coursehelpmaximumupload'] = 'Definisce la dimensione massima dei file che sarà possibile caricare nel corso. Questa dimensione  non può eccedere il limite impostato a livello di sito.';
$string['coursehelpnewsitemsnumber'] = 'Il numero di annunci  da visualizzare nel blocco Annunci recenti.  Impostando il valore a 0, il blocco annunci recenti non verrà visualizzato.';
$string['coursehelpnumberweeks'] = 'Il numero di sezioni del corso (solo per alcuni formati di corso).';
$string['coursehelpshowgrades'] = 'Gli studenti possono essere autorizzati a vedere il proprio registro delle valutazioni. Indipendentemente da questa impostazione, gli studenti potranno comunque visualizzare le valutazioni ricevute nelle singole attività.';
$string['coursehidden'] = 'Questo corso al momento non è disponibile agli studenti';
$string['courseinfo'] = 'Informazioni sul corso';
$string['courselegacyfiles'] = 'File legacy del corso';
$string['courselegacyfiles_help'] = 'L\'area file del corso fornisce una compatibilità con Moodle 1.9 e versioni precedenti. I file presenti in quest\'area sono sempre accessibili da tutti i partecipanti al corso, indipendentemente se sono collegati o meno tramite un link. Inoltre non è possibile sapere dove i file sono utilizzati da Moodle.

Utilizzando i File del corso ti esponi ad una serie di problemi di privacy, di sicurezza e problemi di backup, ripristino ed importazione: in generale potresti incorre in problemi tutte le volte che un file è riutilizzato o condiviso. Si raccomanda di non usare i File del corso a meno che non ti siano perfettamente chiare le limitazioni.';
$string['courselegacyfiles_link'] = 'coursefiles2';
$string['courselegacyfilesofcourse'] = 'File legacy del corso: {$a}';
$string['coursenotaccessible'] = 'Questo corso non è abilitato all\'accesso pubblico';
$string['courseoverview'] = 'Panoramica corsi';
$string['courseoverviewfiles'] = 'Immagine del corso';
$string['courseoverviewfiles_help'] = 'L\'immagine del corso verrà visualizzata ne I Miei Corsi e nell\'elenco dei corsi disponibili nella pagina home. Un amministratore del sito può impostare i tipi di file accettati e il numero di file caricabili, nel qual caso i file saranno visualizzati a fianco della descrizione del corso nell\'elenco dei corsi disponibili nella pagina home.';
$string['courseoverviewfilesext'] = 'Estensioni dei file dell\'immagine del corso';
$string['courseoverviewfileslimit'] = 'Limite file immagine del corso';
$string['courseoverviewgraph'] = 'Grafico riassuntivo del corso';
$string['courseprofiles'] = 'Profili corso';
$string['coursereasonforrejecting'] = 'Motivazione del rifiuto';
$string['coursereasonforrejectingemail'] = 'La motivazione sarà inviata per email al richiedente';
$string['coursereject'] = 'Rifiuta l\'attivazione di un corso a richiesta';
$string['courserejected'] = 'L\'attivazione del corso è stata rifiutata ed il richiedente è stato avvisato.';
$string['courserejectemail'] = 'Purtroppo la tua richiesta di attivazione del corso è stata rifiutata con la seguente motivazione:

{$a}';
$string['courserejectreason'] = 'Sintetizzare la motivazione per il rifiuto della creazione di questo corso<br /> (verrà  spedita al richiedente)';
$string['courserejectsubject'] = 'La tua richiesta di attivazione del corso è stata rifiutata';
$string['coursereport'] = 'Report del corso';
$string['coursereports'] = 'Report del corso';
$string['courserequest'] = 'Corsi a richiesta';
$string['courserequestdetails'] = 'Dettagli del corso che desideri sia attivato';
$string['courserequestfailed'] = 'Per qualche motivo, non è stato possibile salvare la tua richiesta';
$string['courserequestintro'] = 'Utilizzare questo modulo per richiedere la creazione di un corso.<br /> Fornire più informazioni possibili per consentire agli amministratori di capire la motivazione della richiesta.';
$string['courserequestreason'] = 'Motivazione della richiesta';
$string['courserequestroleerror'] = 'Il ruolo dei creatori nella configurazione dei nuovi corsi non è valido. Consultare le <a href="{$a}">politiche utente</a>.';
$string['courserequestsuccess'] = 'La tua richiesta di corso è stata inviata.';
$string['courserequestsupport'] = 'Informazioni aggiuntive per consentire agli Amministratori di valutare al meglio la richiesta';
$string['courserequestwarning'] = 'L\'utente che ha richiesto il corso verrà automaticamente iscritto con il ruolo di {$a}.';
$string['courserestore'] = 'Ripristino corso';
$string['coursereuse'] = 'Riutilizzo corso';
$string['coursereusenavigationmenu'] = 'Menu navigazione riutilizzo corso';
$string['courses'] = 'Corsi';
$string['coursesectionsummaries'] = 'Riassunti delle sezioni del corso';
$string['coursesectiontitle'] = '{$a->course}, {$a->sectionname}: {$a->sectiontitle}';
$string['coursesectiontitlebulkediting'] = 'Modifica in massa {$a->sectionname}: {$a->sectiontitle} | {$a->course}';
$string['coursesectiontitleediting'] = 'Modifica {$a->sectionname}: {$a->sectiontitle} | {$a->course}';
$string['coursesettings'] = 'Default creazione corsi';
$string['coursesmovedout'] = 'Corsi spostati da {$a}';
$string['coursespending'] = 'Corsi a richiesta in attesa di approvazione';
$string['coursestart'] = 'Inizio corso';
$string['coursesummary'] = 'Introduzione al corso';
$string['coursesummary_help'] = 'Una breve descrizione del corso che sarà anche utilizzata nelle ricerche.';
$string['coursetitle'] = 'Corso: {$a->course}';
$string['coursetitlebulkediting'] = 'Modifica in massa corso: {$a->course}';
$string['coursetitleediting'] = 'Modifica corso: {$a->course}';
$string['courseupdates'] = 'Aggiornamenti del corso';
$string['coursevisibility'] = 'Visibilità del corso';
$string['coursevisibility_help'] = '* Visualizza: il corso appare nell\'elenco dei corsi e gli studenti possono accedervi.
* Nascondi: l\'accesso è limitato ai docenti e ad altri utenti con la possibilità di visualizzare i corsi nascosti.';
$string['create'] = 'Crea';
$string['createaccount'] = 'Crea il mio nuovo account';
$string['createcategory'] = 'Crea categoria';
$string['createfolder'] = 'Crea una cartella dentro {$a}';
$string['createnew'] = 'Crea nuova';
$string['createnewcategory'] = 'Crea categoria';
$string['createnewcourse'] = 'Crea corso';
$string['createnewsubcategory'] = 'Crea sottocategoria';
$string['createsubcategoryof'] = 'Crea sottocategoria di {$a}';
$string['createuser'] = 'Crea utente';
$string['createziparchive'] = 'Crea un archivio compresso';
$string['creatingblocks'] = 'Creazione blocchi';
$string['creatingblocksroles'] = 'Creazione attribuzioni di ruolo a livello di blocco e relative modifiche';
$string['creatingblogsinfo'] = 'Creazione info dei blog';
$string['creatingcategoriesandquestions'] = 'Creazione categorie e domande';
$string['creatingcoursemodules'] = 'Creazione moduli corso';
$string['creatingcourseroles'] = 'Creazione attribuzioni di ruolo a livello di corso e relative modifiche';
$string['creatingevents'] = 'Creazione eventi';
$string['creatinggradebook'] = 'Creazione registro valutatore';
$string['creatinggroupings'] = 'Creazione raggruppamenti';
$string['creatinggroupingsgroups'] = 'Aggiunta gruppi in raggruppamenti';
$string['creatinggroups'] = 'Creazione gruppi';
$string['creatinglogentries'] = 'Creazione record di log';
$string['creatingmessagesinfo'] = 'Creazione informazioni dei messaggi';
$string['creatingmodroles'] = 'Creazione attribuzioni di ruolo a livello di modulo e relative modificheo';
$string['creatingnewcourse'] = 'Creazione nuovo corso';
$string['creatingrolesdefinitions'] = 'Creazione definizione dei ruoli';
$string['creatingscales'] = 'Creazione scale';
$string['creatingsections'] = 'Creazione sezioni';
$string['creatingtemporarystructures'] = 'Creazione strutture temporanee';
$string['creatinguserroles'] = 'Creazione attribuzioni di ruolo a livello di utente e relative modificheo';
$string['creatingusers'] = 'Creazione utenti';
$string['creatingxmlfile'] = 'Creazione file XML';
$string['currency'] = 'Valuta';
$string['currentcourse'] = 'Corso in uso';
$string['currentcourseadding'] = 'Corso in uso, accoda i dati';
$string['currentcoursedeleting'] = 'Corso in uso, sostituisci i dati';
$string['currentlanguage'] = 'Lingua in uso';
$string['currentlocaltime'] = 'La tua ora locale';
$string['currentpicture'] = 'Immagine attuale';
$string['currentrelease'] = 'Informazioni sulla versione attuale';
$string['currenttheme'] = 'Tema in uso';
$string['currentversion'] = 'Versione installata';
$string['databasechecking'] = 'È in corso l\'aggiornamento del database di Moodle dalla versione {$a->oldversion} to {$a->newversion}';
$string['databaseperformance'] = 'Prestazioni database';
$string['databasesetup'] = 'Impostazione database';
$string['databasesuccess'] = 'Il database è stato aggiornato con successo';
$string['databaseupgradebackups'] = 'La versione del backup ora è {$a}';
$string['databaseupgradeblocks'] = 'La versione dei blocchi ora è {$a}';
$string['databaseupgradegroups'] = 'La versione dei gruppi ora è {$a}';
$string['databaseupgradelocal'] = 'La versione della personalizzazione locale del database è ora {$a}';
$string['databaseupgrades'] = 'Aggiornamento database';
$string['dataformats'] = 'Formati dei dati';
$string['date'] = 'Data';
$string['datechanged'] = 'Data di modifica';
$string['datemostrecentfirst'] = 'Data - la più recente per prima';
$string['datemostrecentlast'] = 'Data - la più recente per ultima';
$string['datetimefilterafter'] = '{$a->title} dopo';
$string['datetimefilterbefore'] = '{$a->title} prima';
$string['day'] = 'giorno';
$string['days'] = 'giorni';
$string['decodinginternallinks'] = 'Decodifica collegamenti interni';
$string['default'] = 'Default';
$string['defaultcategoryname'] = 'Categoria 1';
$string['defaultcompetencescale'] = 'Scala di competenze di default';
$string['defaultcompetencescaledesc'] = 'Una scala di valutazione binaria che indica solo se un utente ha dimostrato esperienza oppure no.';
$string['defaultcompetencescalenotproficient'] = 'Non competente';
$string['defaultcompetencescaleproficient'] = 'Competente';
$string['defaultcoursestudent'] = 'Studente';
$string['defaultcoursestudentdescription'] = 'Gli studenti all\'interno di un corso di norma hanno privilegi limitati.';
$string['defaultcoursestudents'] = 'Studenti';
$string['defaultcoursesummary'] = 'Scrivi un paragrafo breve ma interessante che spieghi le caratteristiche di questo corso.';
$string['defaultcourseteacher'] = 'Docente';
$string['defaultcourseteacherdescription'] = 'I docenti gestiscono interamente un corso e possono modificare le attività e valutare gli studenti.';
$string['defaultcourseteachers'] = 'Docenti';
$string['defaulteditor'] = 'Editor di default';
$string['defaulthomepageuser'] = 'Pagina iniziale';
$string['defaulthomepageuser_help'] = 'Pagina di atterraggio degli utenti dopo l\'autenticazione';
$string['delete'] = 'Elimina';
$string['deleteablock'] = 'Elimina blocco';
$string['deleteall'] = 'Elimina tutto';
$string['deleteallcannotundo'] = 'Elimina tutto - non sarà possibile tornare indietro';
$string['deleteallcomments'] = 'Tutti i commenti';
$string['deleteallratings'] = 'Tutte le valutazioni';
$string['deletecategory'] = 'Elimina categoria: {$a}';
$string['deletecategorycheck'] = 'Sei sicuro di eliminare questa categoria <b>\'{$a}\'</b>?<br />Questa operazione sposterà tutti i corsi nella categoria padre, se esiste, o in quella Generale.';
$string['deletecategorycheck2'] = 'Prima di eliminare questa categoria, è necessario decidere cosa fare dei corsi e delle sotto categorie che contiene.';
$string['deletecategoryempty'] = 'Questa categoria è vuota.';
$string['deletecheck'] = 'Elimino {$a} ?';
$string['deletecheckfiles'] = 'Se sicuro di eliminare questi file?';
$string['deletecheckfull'] = 'Sei sicuro di eliminare l\'utente {$a} e tutti i dati associati relativi a iscrizioni, attività, eccetera ?';
$string['deletechecktype'] = 'Sei sicuro di voler eliminare questo {$a->type}?';
$string['deletechecktypename'] = 'Sei sicuro di eliminare questo {$a->type} "{$a->name}"?';
$string['deletecheckwarning'] = 'Stai per eliminare questi file';
$string['deletecommentbyon'] = 'Elimina i commenti dell\'utente  {$a->user} effettuati il {$a->time}';
$string['deletecompletely'] = 'Elimina completamente';
$string['deletecourse'] = 'Elimina un corso';
$string['deletecoursecheck'] = 'Sei sicuro di eliminare questo corso e tutti i dati che contiene?';
$string['deleted'] = 'Eliminato';
$string['deletedactivity'] = '{$a} è stato eliminato';
$string['deletedcourse'] = '{$a} è stato eliminato completamente';
$string['deletednot'] = 'Non è stato possibile eliminare {$a}.';
$string['deletepicture'] = 'Elimina';
$string['deletesection'] = 'Elimina';
$string['deleteselected'] = 'Elimina i selezionati';
$string['deleteselectedkey'] = 'Elimina chiave selezionata';
$string['deletingcourse'] = 'Eliminazione di {$a}';
$string['deletingexistingcoursedata'] = 'Eliminazione dei dati del corso';
$string['deletingolddata'] = 'Eliminazione vecchi dati';
$string['department'] = 'Dipartimento';
$string['deprecatedeventname'] = '{$a} (non è più utilizato)';
$string['desc'] = 'Decrescente';
$string['description'] = 'Descrizione';
$string['deselectall'] = 'Deseleziona tutto';
$string['deselectnos'] = 'Deseleziona tutti i \'No\'';
$string['detailedless'] = 'Meno dettagli';
$string['detailedmore'] = 'Più dettagli';
$string['details'] = 'Dettagli';
$string['digitalminor'] = 'Minore digitale';
$string['digitalminor_desc'] = 'Per creare un account un genitore o chi ne fa le veci deve contattare la seguente persona:';
$string['directory'] = 'Cartella';
$string['disable'] = 'Disabilita';
$string['disabledcomments'] = 'I commenti non sono abilitati';
$string['dismissnotification'] = 'Ignora notifica';
$string['displayingfirst'] = 'Sono visualizzati solo il primi {$a->count} {$a->things}';
$string['displayingrecords'] = 'Visualizzazione di {$a} record';
$string['displayingusers'] = 'Visualizza gli iscritti a partire da {$a->start} fino a {$a->end}';
$string['displayonpage'] = 'Visualizza nella pagina';
$string['dndcourse'] = 'È possibile trascinare e rilasciare il corso da una categoria all\'altra';
$string['dndenabled_inbox'] = 'Per caricare file, trascinali e rilasciali qui.';
$string['dndnotsupported'] = 'La funzione trascina e rilascia non è supportata.';
$string['dndnotsupported_help'] = 'Il browser non supporta il caricamento tramite trascina e rilascia. Questa funzione è disponibile in tutte le versioni più recenti di Chrome, Firefox, Safari e in Internet Explorer versioni 10 o successive.';
$string['dndnotsupported_insentence'] = 'trascina e rilascia non supportato';
$string['dnduploadwithoutcontent'] = 'Questo caricamento è privo di contenuti';
$string['dndworkingfile'] = 'Per caricare file, trascinali e rilasciali nelle sezioni del corso';
$string['dndworkingfilelink'] = 'Per caricare file o link, trascinali e rilasciali nelle sezioni del corso';
$string['dndworkingfiletext'] = 'Per caricare file o testi, trascinali e rilasciali nelle sezioni del corso';
$string['dndworkingfiletextlink'] = 'Per caricare file, testi o link, trascinali e rilasciali nelle sezioni del corso';
$string['dndworkinglink'] = 'Per caricare link, trascinali e rilasciali nelle sezioni del corso';
$string['dndworkingtext'] = 'Per caricare testi, trascinali e rilasciali nelle sezioni del corso';
$string['dndworkingtextlink'] = 'Per caricare testi o link, trascinali e rilasciali nelle sezioni del corso';
$string['documentation'] = 'Documentazione Moodle';
$string['dontsortcategories'] = 'Non ordinare categorie';
$string['dontsortcourses'] = 'Non ordinare corsi';
$string['down'] = 'In basso';
$string['download'] = 'Scarica';
$string['downloadall'] = 'Scarica tutto';
$string['downloadexcel'] = 'Scarica in formato Excel';
$string['downloadfile'] = 'Scarica file';
$string['downloadods'] = 'Scarica in formato ODS';
$string['downloadtext'] = 'Scarica in formato testo';
$string['doyouagree'] = 'Hai letto queste condizioni e le hai accettate?';
$string['droptoupload'] = 'Rilascia i file qui per caricarli';
$string['duplicate'] = 'Duplica';
$string['duplicatedmodule'] = '{$a} (copia)';
$string['duplicatedsection'] = '{$a} (copia)';
$string['edhelpaspellpath'] = 'Per usare il controllo ortografico nell\'editor HTML, è necessario installare <strong>aspell 0.50</strong> o una versione successiva sul server. Inoltre è necessario specificare il percorso di accesso alle librerie aspell nella configurazione di Moodle. Su sistemi Unix/Linux, in genere il percorso è <strong>/usr/bin/aspell</strong>.';
$string['edhelpbgcolor'] = 'Imposta il colore di sfondo dell\'area di edit.<br /> Valori possibili sono per esempio: #ffffff o white';
$string['edhelpcleanword'] = 'Questa impostazione abilita o disabilita il filtro del formato Word.';
$string['edhelpenablespelling'] = 'Abilita o disabilita il controllo ortografico. Quando abilitato <strong>aspell</strong> deve essere installato sul server.';
$string['edhelpfontfamily'] = 'La proprietà font-family è un elenco di nomi di font e/o font generici (es. serif). I nomi devono essere separati da virgole.';
$string['edhelpfontlist'] = 'Definisce i font utilizzati nel menu a discesa dell\'editor.';
$string['edhelpfontsize'] = 'font-size imposta la dimensione standard per i font.<br />Valori possibili sono per esempio: medium, large, smaller, larger, 10pt, 11px.';
$string['edit'] = 'Modifica';
$string['edita'] = 'Modifica {$a}';
$string['editcategorysettings'] = 'Modifica impostazioni categoria';
$string['editcategorythis'] = 'Modifica categoria';
$string['editcoursesettings'] = 'Modifica impostazioni del corso';
$string['editfiles'] = 'Modifica i file';
$string['editgroupprofile'] = 'Modifica descrizione del gruppo';
$string['editingteachershort'] = 'Editor';
$string['editlock'] = 'Questo valore non può essere modificato!';
$string['editmode'] = 'Modalità modifica';
$string['editmyprofile'] = 'Modifica';
$string['editorbgcolor'] = 'Colore di sfondo';
$string['editorcleanonpaste'] = 'Pulisci HTML di Word incollandolo';
$string['editorcommonsettings'] = 'Impostazioni comuni';
$string['editordefaultfont'] = 'Font di default';
$string['editorenablespelling'] = 'Abilita controllo ortografico';
$string['editorfontlist'] = 'Elenco font';
$string['editorfontsize'] = 'Dimensione standard del font';
$string['editorpreferences'] = 'Preferenze editor';
$string['editorresettodefaults'] = 'Ripristina i valori standard';
$string['editorsettings'] = 'Impostazioni editor';
$string['editorshortcutkeys'] = 'Tasti di scelta rapida dell\'editor';
$string['editsection'] = 'Modifica impostazioni';
$string['editsectionname'] = 'Modifica nome della sezione';
$string['editsectionsettings'] = 'Modifica impostazioni sezione';
$string['editsectiontitle'] = 'Modifica sezione: {$a}';
$string['editsettings'] = 'Impostazioni';
$string['editthisactivity'] = 'Modifica questa attività';
$string['editthiscategory'] = 'Modifica questa categoria';
$string['edittitle'] = 'Modifica titolo';
$string['edittitleinstructions'] = 'Escape per annullare, Invio al termine';
$string['edituser'] = 'Modifica account utenti';
$string['edulevel'] = 'Tutti gli eventi';
$string['edulevel_help'] = '* Insegnamento - azioni svolte da un docente, ad esempio aggiornare una risorsa
* Partecipazione - azioni svolte da uno studente, ad esempio intervenire in un forum
* Altro - azioni svolte da utenti con ruoli diversi da docente o studente';
$string['edulevelother'] = 'Altro';
$string['edulevelparticipating'] = 'Partecipazione';
$string['edulevelteacher'] = 'Insegnamento';
$string['email'] = 'Indirizzo email';
$string['emailactive'] = 'Email attiva';
$string['emailagain'] = 'Indirizzo email (ripeti)';
$string['emailalreadysent'] = 'L\'email di recupero password è già stata inviata. Per favore controlla la tua casella di posta.';
$string['emailcharset'] = 'Codifica caratteri delle email';
$string['emailconfirm'] = 'Conferma il tuo account';
$string['emailconfirmation'] = 'Gentile {$a->firstname},

è stata richiesta la creazione di un nuovo account su \'{$a->sitename}\' con il tuo indirizzo di posta elettronica.

Per confermare l\'account, devi cliccare sul link seguente:

{$a->link}

Nella maggior parte dei programmi di posta il link dovrebbe apparire colorato di blu ed è sufficiente cliccarlo. Se il link non dovesse essere attivo, copia e incolla il link nella barra dell\'indirizzo del tuo browser e premi il tasto invio.

Se hai bisogno di aiuto contatta l\'amministratore del sito,
{$a->admin}';
$string['emailconfirmationresend'] = 'Invia di nuovo email di conferma';
$string['emailconfirmationsubject'] = '{$a}: conferma account';
$string['emailconfirmsent'] = '<p>È stata inviata una mail all\'indirizzo <b>{$a}</b></p>
<p>La mail contiene alcune semplici istruzioni per completare la  registrazione.</p>
<p>In caso di difficoltà contattare l\'amministratore del sito.</p>';
$string['emailconfirmsentfailure'] = 'L\'email di conferma non è stata inviata';
$string['emailconfirmsentsuccess'] = 'L\'email di conferma è stata inviata correttamente';
$string['emaildigest'] = 'Tipo email di raccolta';
$string['emaildigest_help'] = 'Le impostazioni di default del forum per le email di raccolta.

* Nessuna raccolta - riceverai una email per ciascun messaggio nei forum
* Raccolta - messaggi per intero - riceverai una email al giorno contenente la raccolta dei messaggi  di ciascun messaggio nei forum.
* Raccolta - solo oggetto - Riceverai una email al giorno contenente la raccolta del solo oggetto di ciascun messaggio nei forum.

È anche possibile scegliere impostazioni diverse per ciascun forum.';
$string['emaildigestcomplete'] = 'Completa (email giornaliera con messaggi per intero)';
$string['emaildigestoff'] = 'Nessuna raccolta (una email per ciascun messaggio)';
$string['emaildigestsubjects'] = 'Oggetti (email giornaliera con solo l\'oggetto dei messaggi)';
$string['emaildisable'] = 'Questo indirizzo email è disabilitato.';
$string['emaildisableclick'] = 'Clicca qui per disabilitare tutte le email dall\'essere spedite a questo indirizzo';
$string['emaildisplay'] = 'Visibilità email';
$string['emaildisplay_help'] = '* Nascosto - Solo gli utenti con idonei privilegi (ad esempio docenti e manager) potranno visualizzare l\'indirizzo email.
* Visibile a tutti - Tutti gli utenti visualizzeranno l’indirizzo email
* Visibile agli iscritti al corso - Solo i partecipanti al corso dove si è iscritti potranno visualizzare l\'indirizzo email.';
$string['emaildisplaycourse'] = 'Visibile ai partecipanti del corso';
$string['emaildisplaycoursemembersonly'] = '(visibile ad altri partecipanti al corso)';
$string['emaildisplayeveryone'] = '(visibile a tutti)';
$string['emaildisplayhide'] = '(Nascosto per tutti gli utenti senza idonei privilegi)';
$string['emaildisplayno'] = 'Nascosto';
$string['emaildisplayyes'] = 'Visibile a tutti';
$string['emailenable'] = 'Questo indirizzo email è abilitato.';
$string['emailenableclick'] = 'Clicca qui per riabilitare tutte le email che sono spedite a questo indirizzo';
$string['emailexists'] = 'Questo indirizzo email è già esistente.';
$string['emailexistshintlink'] = 'Recupera username o password';
$string['emailexistssignuphint'] = 'Forse hai già creato un account in precedenza? {$a}';
$string['emailformat'] = 'Formato email';
$string['emailmustbereal'] = 'Nota: il tuo indirizzo email deve essere esistente';
$string['emailnotallowed'] = 'Gli indirizzi email di questi domini non sono ammessi ({$a})';
$string['emailnotfound'] = 'L\'indirizzo email non è stato trovato nella base dati';
$string['emailonlyallowed'] = 'Questo indirizzo email non può essere utilizzato. Di seguito i domini consentiti: {$a}.';
$string['emailpasswordchangeinfo'] = 'Gentile {$a->firstname},

è stata richiesta una nuova password per l\'account \'{$a->username}\' su \'{$a->sitename}\'.

Per cambiare la password devi cliccare sul link seguente:

{$a->link}

Nella maggior parte dei programmi di posta il link dovrebbe apparire colorato
di blu ed è sufficiente cliccarlo. Se il link non dovesse essere attivo, copia e incolla il link nella barra dell\'indirizzo del tuo browser e premi il tasto invio.

Se hai bisogno di aiuto, contatta l\'amministratore del sito: {$a->admin}';
$string['emailpasswordchangeinfodisabled'] = 'Gentile {$a->firstname},

è stata richiesta una nuova password per il tuo account su \'{$a->sitename}\'.

Purtroppo su questo sito il tuo account  è disabilitato, pertanto la password non può essere reimpostata. Se hai bisogno di aiuto, contatta l\'amministratore del sito: {$a->admin}';
$string['emailpasswordchangeinfofail'] = 'Gentile {$a->firstname},

è stata richiesta una nuova password per il tuo account su \'{$a->sitename}\'.

Purtroppo su questo sito le password non possono essere cambiate. Se hai bisogno di aiuto, contatta l\'amministratore del sito: {$a->admin}';
$string['emailpasswordchangeinfosubject'] = '{$a}: Informazioni su cambio password';
$string['emailpasswordconfirmation'] = 'Gentile {$a->firstname},

è stata richiesta una nuova password per il tuo account su \'{$a->sitename}\'.

Per confermare il cambiamento e ricevere la nuova password devi cliccare sul link seguente:

{$a->link}

Nella maggior parte dei programmi di posta il link dovrebbe apparire colorato
di blu ed è sufficiente cliccarlo. Se il link non dovesse essere attivo, copia e incolla il link nella barra dell\'indirizzo del tuo browser e premi il tasto invio.

Se hai bisogno di aiuto, contatta l\'amministratore del sito: {$a->admin}';
$string['emailpasswordconfirmationsubject'] = '{$a}: Conferma cambiamento password';
$string['emailpasswordconfirmmaybesent'] = '<p> Se hai fornito uno username corretto o un indirizzo email corretto, riceverai una email.</p>
<p>Nel messaggio troverai le istruzioni per confermare e completare la modifica della password.
Se continui ad avere difficoltà, contatta l\'amministratore del sito.</p>';
$string['emailpasswordconfirmnoemail'] = '<p>L\'account specificato non ha un indirizzo di posta elettronica.</p><p>Per favore contatta l\'amministratore del sito.</p>';
$string['emailpasswordconfirmnotsent'] = '<p>I dati inseriti non corrispondono a nessun account utente.</p>
<p>Per favore verifica i dati inseriti e riprova.
Se continui ad avere difficoltà, contatta l\'amministratore del sito.</p>';
$string['emailpasswordconfirmsent'] = 'È stata spedita un\'email  al tuo indirizzo <b>{$a}</b>.
<br />Nel messaggio troverai le istruzioni per confermare e completare la modifica della password. Se continui ad avere difficoltà, contatta l\'amministratore del sito.';
$string['emailresetconfirmation'] = 'Gentile {$a->firstname},

è stato richiesto un cambio password del tuo account \'{$a->username}\' su \'{$a->sitename}\'.

Per confermare la richiesta ed impostare una nuova password, fare click sul link seguente:
<a href="{$a->link}">{$a->link}</a>

(Il link sarà valido per {$a->resetminutes} minuti a partire dal momento in cui è stata effettuata la richiesta)

Se la richiesta non è stata effettuata da te, puoi ignorare questa email.

Se hai bisogno di aiuto, contatta l\'amministratore del sito, {$a->admin}';
$string['emailresetconfirmationsubject'] = '{$a}: Richiesta recupero password';
$string['emailresetconfirmsent'] = 'È stata inviata un\'email al tuo indirizzo di posta <b>{$a}</b>.
<br />L\'email contiene le istruzioni per confermare la richiesta di cambio password.
Se continui ad avere difficoltà, contatta l\'amministratore del sito.';
$string['emailstop'] = 'Disabilita notifiche';
$string['emailtoprivatefiles'] = 'È anche possibile inviare nei propri File personali gli allegati delle email. È sufficiente allegare file ad una email da inviare a {$a}';
$string['emailtoprivatefilesdenied'] = 'L\'amministratore ha disabilitato la funzionalità per caricare file personali';
$string['emailvia'] = '{$a->name} (da {$a->siteshortname})';
$string['emojicategoryactivities'] = 'Attività';
$string['emojicategoryanimalsnature'] = 'Animali & natura';
$string['emojicategoryflags'] = 'Bandiere';
$string['emojicategoryfooddrink'] = 'Cibo & bevande';
$string['emojicategoryobjects'] = 'Oggetti';
$string['emojicategorypeoplebody'] = 'Persone & corpo';
$string['emojicategoryrecent'] = 'Recenti';
$string['emojicategorysmileysemotion'] = 'Sorrisi & emozione';
$string['emojicategorysymbols'] = 'Simboli';
$string['emojicategorytravelplaces'] = 'Viaggi & luoghi';
$string['emptycmids'] = 'L\'ID del modulo del corso è vuoto';
$string['emptydragdropregion'] = 'regione vuota';
$string['emptysectionids'] = 'L\'ID della sezione è vuoto';
$string['enable'] = 'Abilita';
$string['encryptedcode'] = 'Codice criptato';
$string['enddate'] = 'Data di fine corso';
$string['enddate_help'] = 'La data di fine non limita l’accesso degli studenti al corso. Determina se un corso è elencato come Passato ne I miei corsi.';
$string['enddatewithtaskenabled'] = 'Data di fine del corso';
$string['enddatewithtaskenabled_help'] = 'Data in cui il corso diventerà nascosto agli studenti, i quali non potranno più accedervi.';
$string['english'] = 'Inglese';
$string['enrolmentmethods'] = 'Metodi di iscrizione';
$string['entercourse'] = 'Clicca per accedere a questo corso';
$string['enteremail'] = 'Inserisci la tua email';
$string['enteremailaddress'] = 'Inserisci la tua email per reimpostare la password e riceverne una nuova.';
$string['enterusername'] = 'Inserisci il tuo username';
$string['entries'] = 'Elementi';
$string['error'] = 'Errore';
$string['errorcreatingactivity'] = 'Non è stato possibile creare una istanza dell\'attività \'{$a}\'';
$string['errorfiletoobig'] = 'Il file è più grande del limite consentito pari a {$a} byte';
$string['errornouploadrepo'] = 'In questo sito non sono abilitati repository per il caricamento';
$string['errorwhenconfirming'] = 'La tua iscrizione non è stata ancora confermata a causa di un errore. Se hai cliccato sul link di una email per arrivare qui, assicurati che la riga nella tua email non era spezzata o andava accapo. Potresti dover utilizzare Copia e Incolla per ricostruire il link corretto.';
$string['eventcommentcreated'] = 'Creazione commento';
$string['eventcommentdeleted'] = 'Eliminazione commento';
$string['eventcommentsviewed'] = 'Visualizzazione commento';
$string['eventconfiglogcreated'] = 'Creazione log della configurazione';
$string['eventcontentviewed'] = 'Visualizzazione contenuto';
$string['eventcoursebackupcreated'] = 'Creazione backup del corso';
$string['eventcoursecategorycreated'] = 'Creazione categoria';
$string['eventcoursecategorydeleted'] = 'Eliminazione categoria';
$string['eventcoursecategoryupdated'] = 'Aggiornamento categoria';
$string['eventcoursecategoryviewed'] = 'Visualizzazione categoria';
$string['eventcoursecontentdeleted'] = 'Eliminazione contenuto corso';
$string['eventcoursecreated'] = 'Creazione corso';
$string['eventcoursedeleted'] = 'Eliminazione corso';
$string['eventcourseended'] = 'Corso terminato';
$string['eventcourseinformationviewed'] = 'Visualizzazione introduzione al corso';
$string['eventcoursemodulecreated'] = 'Creazione modulo corso';
$string['eventcoursemoduledeleted'] = 'Eliminazione modulo corso';
$string['eventcoursemoduleinstancelistviewed'] = 'Visualizzazione elenco istanze moduli corso';
$string['eventcoursemoduleupdated'] = 'Aggiornamento modulo corso';
$string['eventcoursemoduleviewed'] = 'Visualizzazione modulo corso';
$string['eventcourseoverviewviewed'] = 'Visualizzazione pagina panoramica delle attività del corso';
$string['eventcourseresetended'] = 'Fine reset corso';
$string['eventcourseresetstarted'] = 'Inizio reset corso';
$string['eventcourserestored'] = 'Ripristino corso';
$string['eventcoursesectioncreated'] = 'Creazione sezione di corso';
$string['eventcoursesectiondeleted'] = 'Eliminazione sezione corso';
$string['eventcoursesectionupdated'] = 'Aggiornamento sezione corso';
$string['eventcoursessearched'] = 'Ricerca corsi';
$string['eventcoursestarted'] = 'Corsi iniziato';
$string['eventcourseupdated'] = 'Aggiornamento corso';
$string['eventcourseuserreportviewed'] = 'Visualizzazione report utente del corso';
$string['eventcourseviewed'] = 'Visualizzazione corso';
$string['eventdashboardreset'] = 'Reimpostazione dashboard';
$string['eventdashboardsreset'] = 'Reimpostazione dashboard';
$string['eventdashboardviewed'] = 'Visualizzazione dashboard';
$string['eventdatabasetextfieldcontentreplaced'] = 'Ricerca e sostituzione nel database';
$string['eventemailfailed'] = 'Invio email fallito';
$string['eventmycoursesviewed'] = 'Visualizzazione I miei corsi';
$string['eventname'] = 'Evento';
$string['eventrecentactivityviewed'] = 'Visualizzazione attività recente';
$string['eventsearchindexed'] = 'Indicizzazione dati per la ricerca';
$string['eventsearchresultsviewed'] = 'Visualizzazione risultati della ricerca';
$string['eventsectionviewed'] = 'Sezione visualizzata';
$string['eventunknownlogged'] = 'Evento sconosciuto';
$string['eventurlblocked'] = 'L\'URL è stata bloccata';
$string['eventusercreated'] = 'Creazione utente';
$string['eventuserdeleted'] = 'Eliminazione utente';
$string['eventuserfeedbackgiven'] = 'Click su link feedback';
$string['eventuserfeedbackremind'] = 'Click link promemoria del feedback';
$string['eventuserinfocategorycreated'] = 'Creazione categoria di campi personalizzati del profilo';
$string['eventuserinfocategorydeleted'] = 'Eliminazione categoria di campi personalizzati del profilo';
$string['eventuserinfocategoryupdated'] = 'Aggiornamento categoria di campi personalizzati del profilo';
$string['eventuserinfofieldcreated'] = 'Creazione campo personalizzato del profilo';
$string['eventuserinfofielddeleted'] = 'Eliminazione campo personalizzato del profilo';
$string['eventuserinfofieldupdated'] = 'Aggiornamento campo personalizzato del profilo';
$string['eventuserlistviewed'] = 'Visualizzazione elenco utenti';
$string['eventuserloggedout'] = 'Disconnessione utente';
$string['eventuserpasswordpolicyfailed'] = 'La password utente non soddisfa i requisiti';
$string['eventuserpasswordupdated'] = 'Modifica password utente';
$string['eventuserprofileviewed'] = 'Visualizzazione profilo utente';
$string['eventuserupdated'] = 'Aggiornamento utente';
$string['everybody'] = 'Tutti';
$string['executeat'] = 'Esegui alle';
$string['existing'] = 'Esistente';
$string['existingadmins'] = 'Amministratori esistenti';
$string['existingcourse'] = 'Corso esistente';
$string['existingcourseadding'] = 'Corso esistente, accoda i dati';
$string['existingcoursedeleting'] = 'Corso esistente, sostituisci i dati';
$string['existingcreators'] = 'Creatori di corsi esistenti';
$string['existingstudents'] = 'Studenti iscritti';
$string['existingteachers'] = 'Docenti esistenti';
$string['expand'] = 'Espandi';
$string['expandall'] = 'Espandi tutto';
$string['expandcategory'] = 'Espandi {$a}';
$string['explanation'] = 'Spiegazione';
$string['explanationdigitalminor'] = 'L’informazione è necessaria per stabilire se la tua età è maggiore dell’età del consenso digitale, ossia l’età in cui un individuo può accettare termini e condizioni e acconsentire legalmente alla memorizzazione ed elaborazione dei propri dati.';
$string['extendperiod'] = 'Estendi periodo';
$string['extendsession'] = 'Prolunga sessione';
$string['failedloginattempts'] = '{$a->attempts} accessi falliti dall\'ultimo accesso corretto';
$string['failedtaskbody'] = '<p>Gentile{$a->firstname},</p>
<p>L\'elaborazione <b>{$a->taskname}</b> è andata in errore più volte e richiede attenzione.</p>
<p><a href="{$a->link}">Visualizza elaborazione</a></p>';
$string['failedtaskcontexturlname'] = 'Report sullo stato';
$string['failedtasksubject'] = 'Elaborazione in errore: {$a}';
$string['favourites'] = 'Preferiti';
$string['feedback'] = 'Feedback';
$string['file'] = 'File';
$string['fileexists'] = 'È già presente un file di nome {$a}';
$string['filemissing'] = '{$a} è mancante';
$string['filereaderror'] = 'Non è possibile leggere il file \'{$a}\'. Per favore verifica che sia realmente un file e non una cartella.';
$string['files'] = 'File';
$string['filesanduploads'] = 'File e caricamenti';
$string['filesfolders'] = 'File/Cartelle';
$string['fileuploadwithcontent'] = 'I caricamenti di file non devono contenere il parametro content';
$string['filloutallfields'] = 'Compila tutti i campi di questo form';
$string['filter'] = 'Filtro';
$string['filteroption'] = '{$a->criteria}: {$a->value}';
$string['filterrowlegend'] = 'Filtro {$a}';
$string['filters'] = 'Filtri';
$string['filtersetmatchdescription'] = 'La modalità di combinazione dei filtri';
$string['filtertype'] = 'Tipo di filtro';
$string['findmorecourses'] = 'Trova altri corsi...';
$string['first'] = 'Inizio';
$string['firstaccess'] = 'Primo accesso';
$string['firstname'] = 'Nome';
$string['firstnamephonetic'] = 'Nome - fonetico';
$string['firstpage'] = 'Prima pagina';
$string['firstsiteaccess'] = 'Primo accesso al sito';
$string['firsttime'] = 'È la prima volta che accedi qui?';
$string['folder'] = 'Cartella';
$string['folderclosed'] = 'Cartella chiusa';
$string['folderopened'] = 'Cartella aperta';
$string['followingoptional'] = 'I seguenti elementi sono opzionali';
$string['followingrequired'] = 'I seguenti elementi sono obbligatori';
$string['for'] = 'Per';
$string['force'] = 'Forza';
$string['forcelanguage'] = 'Forza lingua';
$string['forceno'] = 'Non forzare';
$string['forcepasswordchange'] = 'Forza il cambiamento della password';
$string['forcepasswordchange_help'] = 'Obbliga l\'utente a cambiare la propria password al suo primo login.';
$string['forcepasswordchangecheckfull'] = 'Sei sicuro di voler obbligare {$a} a cambiare la password ?';
$string['forcepasswordchangenot'] = 'Non è stato possibile obbligare il cambio della password per {$a}';
$string['forcepasswordchangenotice'] = 'È necessario cambiare la password per proseguire.';
$string['forcepasswordresetfailurenotice'] = 'La password attuale non è più conforme ai requisiti. Per assistenza contatta l\'amministratore del server Moodle.
{$a}';
$string['forcepasswordresetnotice'] = 'La password attuale non è più conforme ai requisiti. Dovete reimpostarla per poter accedere.<br/>
    {$a}';
$string['forcetheme'] = 'Tema obbligato';
$string['forgotaccount'] = 'Hai dimenticato la password?';
$string['forgotten'] = 'Hai dimenticato lo username o la password?';
$string['forgottenduplicate'] = 'L\'indirizzo email è usato da più account, per favore inserisci lo username';
$string['forgotteninvalidurl'] = 'URL per il reset della password non valido';
$string['format'] = 'Formato';
$string['formathtml'] = 'Formato HTML';
$string['formatmarkdown'] = 'Formato Markdown';
$string['formatplain'] = 'Formato testo';
$string['formattext'] = 'Formattazione automatica Moodle';
$string['forumpreferences'] = 'Preferenze forum';
$string['framesetinfo'] = 'Questo frame contiene:';
$string['fromdate'] = 'Da';
$string['fromsender'] = 'Da';
$string['frontpagecategorycombo'] = 'Elenco combinato';
$string['frontpagecategorynames'] = 'Elenco delle categorie';
$string['frontpagecourselist'] = 'Elenco dei corsi';
$string['frontpagecoursesearch'] = 'Riquadro cerca corsi';
$string['frontpagedescription'] = 'Descrizione home del sito';
$string['frontpagedescriptionhelp'] = 'La descrizione può essere visualizzata nella pagina home tramite il blocco "Descrizione del corso/sito".';
$string['frontpageenrolledcourselist'] = 'Elenco dei corsi dove l\'utente è iscritto';
$string['frontpageformat'] = 'Formato pagina home del sito';
$string['frontpageformatloggedin'] = 'Formato pagina home del sito dopo il login';
$string['frontpagenews'] = 'Annunci';
$string['frontpagesettings'] = 'Impostazioni pagina home del sito';
$string['fulllistofcourses'] = 'Tutti i corsi';
$string['fullname'] = 'Nome';
$string['fullnamecourse'] = 'Titolo del corso';
$string['fullnamecourse_help'] = 'Il titolo visualizzato in I miei corsi e nell\'elenco dei corsi disponibili nella Home page..';
$string['fullnamedisplay'] = '{$a->firstname} {$a->lastname}';
$string['fullnameuser'] = 'Nome completo dell\'utente';
$string['fullprofile'] = 'Descrizione completa';
$string['fullsitename'] = 'Nome del sito';
$string['functiondisabled'] = 'Funzionalità al momento non abilitata';
$string['general'] = 'Generale';
$string['geolocation'] = 'latitudine - longitudine';
$string['gettheselogs'] = 'Ottieni i log';
$string['go'] = 'Vai';
$string['gobacktosite'] = 'Torna al sito';
$string['gpl'] = 'Copyright (C) dal 1999 di Martin Dougiamas (http://moodle.com)

Questo programma è software libero; è possibile ridistribuirlo e/o modificarlo secondo le condizioni previste dalla licenza GNU General Public License  pubblicata dalla Free Software Foundation, licenza versione 2 oppure (a scelta) una qualsiasi versione successiva.

Questo programma viene distribuito nell\'auspicio che possa essere utile, ma SENZA ALCUNA GARANZIA, ivi inclusa qualsiasi garanzia implicita di COMMERCIABILITÀ o di IDONEITÀ PER UN USO SPECIFICO.

Per maggiori dettagli leggere la pagina relativa alla licenza di Moodle:
https://moodledev.io/general/license';
$string['gpl3'] = 'Copyright (C) dal 1999 di Martin Dougiamas
(http://moodle.com)

Questo programma è software libero; puoi ridistribuirlo e/o modificarlo secondo le condizioni previste dalla licenza GNU General Public License  pubblicata dalla Free Software Foundation\', licenza versione 3 oppure (a tua scelta) qualsiasi versione successiva.

Questo programma viene distribuito nell\'auspicio che possa essere utile, ma SENZA ALCUNA GARANZIA, ivi inclusa qualsiasi garanzia implicita di COMMERCIABILITÀ o di IDONEITÀ PER UN USO SPECIFICO.

Per maggiori dettagli leggere la pagina informativa sulla Licenza di Moodle:
https://moodledev.io/general/license';
$string['gpllicense'] = 'Licenza GPL';
$string['gradenoun'] = 'Valutazione';
$string['grades'] = 'Valutazioni';
$string['gradeverb'] = 'Valutazione';
$string['gravatarenabled'] = 'In questo sito è stato abilitato <a href="https://www.gravatar.com/">Gravatar</a>. Se nel tuo profilo non carichi nessuna immagine, Moodle proverà a caricarne una da Gravatar.';
$string['group'] = 'Gruppo';
$string['groupadd'] = 'Aggiunta nuovo gruppo';
$string['groupaddusers'] = 'Aggiunta al gruppo selezionato';
$string['groupfor'] = 'per gruppo';
$string['groupinfo'] = 'Informazioni sul gruppo selezionato';
$string['groupinfoedit'] = 'Modifica le impostazioni del gruppo';
$string['groupinfomembers'] = 'Informazioni sui membri selezionati';
$string['groupinfopeople'] = 'Informazioni sulla gente selezionata';
$string['groupmembers'] = 'Membri del gruppo';
$string['groupmemberssee'] = 'Visualizza membri del gruppo';
$string['groupmembersselected'] = 'Membri del gruppo selezionato';
$string['groupmode'] = 'Modalità gruppo';
$string['groupmodeforce'] = 'Forza modalità gruppo';
$string['groupmy'] = 'Mio gruppo';
$string['groupnonmembers'] = 'Persone non in un gruppo';
$string['groupnotamember'] = 'Spiacente, non sei membro di quel gruppo';
$string['grouprandomassign'] = 'Assegna casualmente tutti ai gruppi';
$string['groupremove'] = 'Rimuovi gruppo selezionato';
$string['groupremovemembers'] = 'Rimuovi membri selezionati';
$string['groups'] = 'Gruppi';
$string['groupsnone'] = 'Senza gruppi';
$string['groupsseparate'] = 'Gruppi separati';
$string['groupsvisible'] = 'Gruppi visibili';
$string['guest'] = 'Ospite';
$string['guestdescription'] = 'Gli ospiti hanno privilegi minimi e normalmente non possono partecipare alle attività.';
$string['guestskey'] = 'Consenti l\'accesso agli ospiti tramite la chiave di iscrizione';
$string['guestsno'] = 'Non consentire l\'accesso agli ospiti';
$string['guestsnotallowed'] = 'Spiacenti, \'{$a}\' non consente l\'accesso agli ospiti.';
$string['guestsyes'] = 'Consenti l\'accesso agli ospiti senza chiave di iscrizione';
$string['guestuser'] = 'Utente ospite';
$string['guestuserinfo'] = 'Questo utente è un utente speciale che ha accesso ai documenti del corso in modalità solo lettura in alcuni corsi.';
$string['help'] = 'Aiuto';
$string['helpprefix2'] = 'Aiuto su {$a}';
$string['helpwiththis'] = 'Aiuto per questo';
$string['hiddenassign'] = 'Attribuzione nascosta';
$string['hiddenfromstudents'] = 'Nascosta agli studenti';
$string['hiddenoncoursepage'] = 'Disponibile ma non visibile sulla pagina del corso';
$string['hiddensections'] = 'Sezioni nascoste';
$string['hiddensections_help'] = 'Le sezioni nascoste possono essere visualizzate agli studenti come "non disponibili" nella pagina del corso o mantenute completamente nascoste.';
$string['hiddensectionscollapsed'] = 'Le sezioni nascoste sono visualizzate come non disponibili';
$string['hiddensectionsinvisible'] = 'Le sezioni nascoste non sono visibili';
$string['hiddenwithbrackets'] = '(nascosto)';
$string['hide'] = 'Nascondi';
$string['hideadvancedsettings'] = 'Nascondi le impostazioni avanzate';
$string['hidecategory'] = 'Nascondi la categoria';
$string['hidecategorymany'] = 'La categoria {$a->category} contiene {$a->coursecount} corsi.
<br/>Se viene nascosta, gli utenti senza privilegi di visualizzare le categorie nascoste non avranno più accesso ai corsi.';
$string['hidecategoryone'] = 'The category {$a->category} contains 1 course.
<br/>If you hide it, users without permission to view hidden categories will no longer have access to the course.';
$string['hidechartdata'] = 'Nascondi i dati del grafico';
$string['hidefromstudents'] = 'Nascondi nella pagina home del corso';
$string['hideoncoursepage'] = 'Rendi disponibile ma non visibile nella pagina home del corso';
$string['hidepopoverwindow'] = 'Nascondi finestra popover';
$string['hidesection'] = 'Nascondi sezione {$a}';
$string['hidesettings'] = 'Nascondi impostazioni';
$string['hideshowblocks'] = 'Nascondi o visualizza blocchi';
$string['highlight'] = 'Evidenzia';
$string['highlighted'] = 'Evidenziato';
$string['highlightoff'] = 'Rimuovi evidenziazione';
$string['hits'] = 'Accessi';
$string['hitsoncourse'] = 'Accessi al corso {$a->coursename} dell\'utente {$a->username}';
$string['hitsoncoursetoday'] = 'Accessi di oggi al corso {$a->coursename} dell\'utente {$a->username}';
$string['home'] = 'Home';
$string['homeheader'] = 'Menu home';
$string['hour'] = 'ora';
$string['hours'] = 'ore';
$string['howtomakethemes'] = 'Come realizzare un nuovo tema';
$string['htmleditor'] = 'Usa editor HTML';
$string['htmleditoravailable'] = 'L\'editor HTML è disponibile';
$string['htmleditordisabled'] = 'Hai disabilitato l\'editor HTML nel tuo profilo utente.';
$string['htmleditordisabledadmin'] = 'L\'amministratore ha disabilitato l\'editor HTML in questo sito';
$string['htmleditordisabledbrowser'] = 'L\'editor HTML non è disponibile in quanto stai utilizzando un browser non compatibile.';
$string['htmlfilesonly'] = 'Solo file HTML';
$string['htmlformat'] = 'Formato HTML';
$string['icon'] = 'Icona';
$string['idnumber'] = 'Codice identificativo';
$string['idnumbercourse'] = 'Codice identificativo del corso';
$string['idnumbercourse_help'] = 'Utilizzato solo per collegare il corso con sistemi esterni. Lasciare vuoto se non si dispone di un codice identificativo ufficiale.';
$string['idnumbercoursecategory'] = 'Codice identificativo della categoria';
$string['idnumbercoursecategory_help'] = 'Il codice identificativo della categoria di corsi viene utilizzato solamente per identificare la categoria rispetto ad un sistema esterno e non viene mai visualizzato nel sito. Può essere utilizzato se la categoria ha una codifica ufficiale, altrimenti il campo può essere lasciato vuoto.';
$string['idnumbergroup'] = 'Codice identificativo del gruppo';
$string['idnumbergroup_help'] = 'Il codice identificativo del gruppo viene utilizzato solamente per identificare il gruppo rispetto ad un sistema esterno e non viene mai visualizzato nel sito. Può essere utilizzato se il gruppo ha una codifica ufficiale, altrimenti il campo può essere lasciato vuoto.';
$string['idnumbergrouping'] = 'Codice identificativo del raggruppamento';
$string['idnumbergrouping_help'] = 'Il codice identificativo del raggruppamento viene utilizzato solamente per identificare il raggruppamento rispetto ad un sistema esterno e non viene mai visualizzato nel sito. Può essere utilizzato se il raggruppamento ha una codifica ufficiale, altrimenti il campo può essere lasciato vuoto.';
$string['idnumbermod'] = 'Codice identificativo';
$string['idnumbermod_help'] = 'L\'impostazione del codice identificativo consente di identificare l\'attività ai fini del calcolo della valutazione o per report personalizzati. Se l\'attività non è inclusa in nessun calcolo, il campo può essere lasciato vuoto.

Il codice identificativo può essere impostato anche nel Registro valutatore, ma sarà comunque modificabile solamente nelle impostazioni dell\'attività';
$string['idnumbertaken'] = 'Il codice identificativo è già utilizzato.';
$string['imagealt'] = 'Descrizione dell\' immagine';
$string['import'] = 'Importa';
$string['importdata'] = 'Importa i dati del corso';
$string['importdataexported'] = 'I dati del corso \'from\' sono stati esportati correttamente..<br /> Prosegui con l\'importazione nel tuo corso \'to\'';
$string['importdatafinished'] = 'Importazione completa! Accedi al corso';
$string['importdatafrom'] = 'Scelta del corso e importazione dati:';
$string['importinfo'] = 'Importa elementi da altri corsi, come attività, blocchi o eventi del calendario. Nessun dato utente verrà importato.';
$string['inactive'] = 'Non attivo';
$string['include'] = 'Includi';
$string['includeallusers'] = 'Includi tutti gli utenti';
$string['includecoursefiles'] = 'Includi i file del corso';
$string['includecourseusers'] = 'Includi gli utenti del corso';
$string['included'] = 'Incluso';
$string['includelogentries'] = 'Includi i log';
$string['includemodules'] = 'Includi i moduli';
$string['includemoduleuserdata'] = 'Includi i dati utente presenti nel modulo';
$string['includeneededusers'] = 'Includi gli utenti necessari';
$string['includenoneusers'] = 'Escludi gli utenti';
$string['includeroleassignments'] = 'Includi le attribuzioni di ruolo';
$string['includesitefiles'] = 'Includi i file del sito usati in questo corso';
$string['includesubcategories'] = 'Includi sotto categorie';
$string['includeuserfiles'] = 'Includi i file degli utenti';
$string['increasesections'] = 'Aumenta il numero di sezioni';
$string['indicator:accessesafterend'] = 'Accesso al corso dopo la data di fine';
$string['indicator:accessesafterend_help'] = 'L\'indicatore rappresenta l\'accesso al corso da parte dello studente dopo la data di fine.';
$string['indicator:accessesbeforestart'] = 'Accesso al corso prima della data di inizio';
$string['indicator:accessesbeforestart_help'] = 'L\'indicatore rappresenta l\'accesso al corso da parte dello studente prima della data d\'inizio.';
$string['indicator:activitiesdue'] = 'Attività da svolgere';
$string['indicator:activitiesdue_help'] = 'L\'utente ha attività da svolgere.';
$string['indicator:anycourseaccess'] = 'Accesso nei corsi';
$string['indicator:anycourseaccess_help'] = 'L\'indicatore rappresenta l\'accesso a qualcuno dei corsi dove l\'utente è iscritto';
$string['indicator:anywrite'] = 'Scritture';
$string['indicator:anywrite_help'] = 'L\'indicatore rappresenta le azioni di scrittura (consegne, invii) operate dalla studente.';
$string['indicator:anywriteincourse'] = 'Scritture nel corso';
$string['indicator:anywriteincourse_help'] = 'L\'indicatore rappresenta le azioni di scrittura (consegne, invii) operate dalla studente nelle attività del corso.';
$string['indicator:completeduserprofile'] = 'Completamento profilo utente';
$string['indicator:completeduserprofile_help'] = 'L\'indicatore rappresenta il completamento del profilo da parte dello studente-';
$string['indicator:completeduserprofiledef'] = 'Profilo utente completato';
$string['indicator:completeduserprofiledef_help'] = 'Le politiche del sito sono state accettate e l\'utente ha compilato i seguenti campi: Istituzione, Dipartimento, Indirizzo, Città, Stato, URL.';
$string['indicator:completionenabled'] = 'Abilitazione del tracciamento del completamento';
$string['indicator:completionenabled_help'] = 'L\'indicatore rappresenta l\'abilitazione del tracciamento del completamento nel corso.';
$string['indicator:nostudent'] = 'Studenti iscritti';
$string['indicator:nostudent_help'] = 'L\'indicatore rappresenta l\'esistenza di studenti iscritti al corso.';
$string['indicator:noteacher'] = 'Presenza di docenti';
$string['indicator:noteacher_help'] = 'L\'indicatore rappresenta la presenza di docenti nel corso.';
$string['indicator:potentialcognitive'] = 'Profondità cognitiva potenziale del corso';
$string['indicator:potentialcognitive_help'] = 'L\'indicatore è basato sulla profondità cognitiva potenziale che lo studente potrebbe toccare svolgendo le attività del corso.';
$string['indicator:potentialcognitivedef'] = 'Profondità cognitiva potenziale del corso';
$string['indicator:potentialcognitivedef_help'] = 'La profondità che il corso offre in termini di coinvolgimento cognitivo, come ad esempio consegna di un lavoro per aver un feedback, la possibilità di rivedere i lavori di altri, la possibilità di rivedere e consegnare di nuovo il proprio lavoro.';
$string['indicator:potentialcognitivedef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:potentialsocial'] = 'Dimensione sociale potenziale del corso';
$string['indicator:potentialsocial_help'] = 'L\'indicatore è basato sulla dimensione sociale potenziale che lo studente potrebbe raggiungere svolgendo le attività del corso.';
$string['indicator:potentialsocialdef'] = 'Dimensione sociale potenziale del corso';
$string['indicator:potentialsocialdef_help'] = 'La dimensione che il corso offre in termini di coinvolgimento sociale, come ad esempio l\'interazione con altri partecipanti e con la comunità di pratica al di là della propria classe.';
$string['indicator:potentialsocialdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['indicator:readactions'] = 'Numero di letture';
$string['indicator:readactions_help'] = 'L\'indicatore rappresenta il numero di letture (visualizzazioni) effettuate dallo studente.';
$string['indicator:userforumstracking'] = 'Evidenziazione dei messaggi dei forum';
$string['indicator:userforumstracking_help'] = 'L\'indicatore rappresenta l\'attivazione o mancata attivazione dell\'evidenziazione dei messaggi dei forum da parte dello studente.';
$string['info'] = 'Informazioni';
$string['inprogress'] = 'In svolgimento';
$string['insertcontentbefore'] = 'Inserisci contenuto prima di \'{$a->activityname}\'';
$string['insertresourceoractivitybefore'] = 'Inserisci un\'attività o una risorsa prima di \'{$a->activityname}\'';
$string['institution'] = 'Istituzione';
$string['instudentview'] = 'nella vista studente';
$string['interests'] = 'Interessi';
$string['interestslist'] = 'Elenco interessi';
$string['interestslist_help'] = 'Inserisci i tuoi interessi. Verranno visualizzati nella pagina del tuo profilo sotto forma di tag.';
$string['invalidemail'] = 'Indirizzo email non valido';
$string['invalidlogin'] = 'Login errato, riprova';
$string['invalidtaskclassname'] = 'Classe {$a} dell\'elaborazione non valida';
$string['invalidtaskid'] = 'ID dell’elaborazione non valido';
$string['invalidusername'] = 'Lo username può contenere solamente caratteri alfanumerici minuscoli (lettere e numeri), il trattino basso (_), il segno meno (-), il punto (.) ed il simbolo \'at\' (@)';
$string['invalidusernameupload'] = 'Username non valido';
$string['ip_address'] = 'Indirizzo IP';
$string['jump'] = 'Vai';
$string['jumpto'] = 'Vai a...';
$string['keep'] = 'Mantieni';
$string['labelvalue'] = '{$a->label}: {$a->value}';
$string['langltr'] = 'Direzione scrittura da sinistra a destra';
$string['langrtl'] = 'Direzione scrittura da destra a sinistra';
$string['language'] = 'Lingua';
$string['languagegood'] = 'Questo language pack è aggiornato.';
$string['languageselector'] = 'Selettore Lingua';
$string['last'] = 'Fine';
$string['lastaccess'] = 'Accesso più recente';
$string['lastcourseaccess'] = 'Ultimo accesso al corso';
$string['lastedited'] = 'Ultima modifica';
$string['lastip'] = 'Indirizzo IP più recente';
$string['lastlogin'] = 'Login più recente';
$string['lastmodified'] = 'Ultime modifiche';
$string['lastname'] = 'Cognome';
$string['lastnamephonetic'] = 'Cognome - fonetico';
$string['lastpage'] = 'Ultima pagina';
$string['lastsiteaccess'] = 'Ultimo accesso al sito';
$string['lastyear'] = 'Anno scorso';
$string['latestlanguagepack'] = 'Verifica la presenza di un language pack aggiornato su moodle.org';
$string['layouttable'] = 'Tabella layout';
$string['leavetokeep'] = 'Lascia in bianco per conservare la tua attuale password';
$string['legacylogginginuse'] = 'La scrittura sul log legacy è abilitata. La scrittura su questo log è deprecata. Per favore impostare la scrittura su log supportati come il log "standard" o "esterno"';
$string['legacythemeinuse'] = 'Il sito viene visualizzato in compatibility mode poiché il tuo browser è obsoleto.';
$string['license'] = 'Licenza';
$string['licenses'] = 'Licenze';
$string['liketologin'] = 'Desideri autenticarti con un account utente?';
$string['list'] = 'Elenco';
$string['listfiles'] = 'Elenco dei file in {$a}';
$string['listofallpeople'] = 'Elenco di tutte le persone';
$string['listofcourses'] = 'Elenco dei corsi';
$string['loading'] = 'Caricamento in corso';
$string['loadinghelp'] = 'Caricamento in corso...';
$string['local'] = 'Locale';
$string['localplugins'] = 'Plugin locali';
$string['localpluginsmanage'] = 'Gestione plugin locali';
$string['location'] = 'File o sito web';
$string['locktimeout'] = 'Si è verificato un time out durante l\'attesa del lock.';
$string['log_excel_date_format'] = 'yyyy mmmm d h:mm';
$string['loggedinas'] = 'Sei collegato come {$a}.';
$string['loggedinasguest'] = 'Ospite';
$string['loggedinnot'] = 'Non sei collegato.';
$string['login'] = 'Login';
$string['login_failure_logs'] = 'Log accessi falliti';
$string['loginactivity'] = 'Attività di autenticazione';
$string['loginagain'] = 'Autenticati di nuovo';
$string['loginalready'] = 'Sei già collegato';
$string['loginas'] = 'Login come';
$string['loginaspasswordexplain'] = '<p>È necessario impostare la speciale "password login come" per utilizzare questa caratteristica.<br />Se non la conoscete, chiedete all\'amministratore del server.</p>';
$string['loginguest'] = 'Login come ospite';
$string['loginsite'] = 'Login al sito';
$string['loginsteps'] = 'Per accedere al sito devi creare un account.';
$string['loginstepsnone'] = '<p>Per accedere ai corsi è necessario creare un account.</p>
<p>Per farlo, scegli username e password ed autenticati usando questa pagina</p>
<p>Se lo username scelto è già utilizzato, dovrai scegliere uno username diverso.</p>';
$string['loginto'] = 'Login su {$a}';
$string['logoof'] = 'Logo di {$a}';
$string['logout'] = 'Esci';
$string['logoutconfirm'] = 'Vuoi uscire veramente?';
$string['logs'] = 'Log';
$string['logtoomanycourses'] = '[ <a href="{$a->url}">continua</a> ]';
$string['logtoomanyusers'] = '[ <a href="{$a->url}">continua</a> ]';
$string['lookback'] = 'Guarda dietro';
$string['mailadmins'] = 'Informa gli amministratori';
$string['mailstudents'] = 'Informa gli studenti';
$string['mailteachers'] = 'Informa i docenti';
$string['maincoursepage'] = 'Pagina home del corso';
$string['makeafolder'] = 'Crea una cartella';
$string['makeavailable'] = 'Rendi disponibile';
$string['makeeditable'] = 'Se si rende \'{$a}\' modificabile dal processo del server web (es. apache) si potrà modificare questo file direttamente da questa pagina.';
$string['makethismyhome'] = 'Rendi questa pagina la mia pagina home';
$string['makeunavailable'] = 'Rendi non disponibile';
$string['manageblocks'] = 'Blocchi';
$string['managecategories'] = 'Gestione categorie di corso';
$string['managecategorythis'] = 'Gestione categoria';
$string['managecombined'] = 'Gestione categorie  di corso e corsi';
$string['managecontentbanktypes'] = 'Gestione tipi contenuti';
$string['managecourses'] = 'Gestisci i corsi';
$string['managedatabase'] = 'Gestione database';
$string['managedataformats'] = 'Gestione formati dei dati';
$string['manageeditorfiles'] = 'Gestione file usati dall\'editor';
$string['managefilters'] = 'Filtri';
$string['managemodules'] = 'Moduli';
$string['manageroles'] = 'Ruoli e privilegi';
$string['markallread'] = 'Segna tutti come letti';
$string['match'] = 'Filtra';
$string['matchingsearchandrole'] = 'Corrispondenze per \'{$a->search}\' e {$a->role}';
$string['matchofthefollowing'] = 'delle seguenti condizioni:';
$string['maxareabytesreached'] = 'La dimensione del file (o la dimensione complessiva di più file) eccede lo spazio rimasto disponibile in quest\'area.';
$string['maxfilesize'] = 'Dimensione massima dei nuovi file: {$a}';
$string['maxfilesreached'] = 'Sei autorizzato ad allegare a questo elemento un massimo di {$a} file';
$string['maximumchars'] = 'Massimo di {$a} caratteri';
$string['maximumgrade'] = 'Voto massimo';
$string['maximumgradex'] = 'Voto massimo: {$a}';
$string['maximumshort'] = 'Massimo';
$string['maximumupload'] = 'Dimensione massima file caricabili';
$string['maximumupload_help'] = 'La dimensione massima del file consentita per i caricamenti degli studenti nel corso. Inoltre, È possibile limitare ulteriormente la dimensione massima di caricamento per ciascuna attività.';
$string['maxnumberweeks'] = 'Numero massimo di sezioni';
$string['maxnumberweeks_desc'] = 'Il numero massimo di sezioni presenti nel meni a discesa delle sezioni (si applica solamente ad alcuni formati di corso).';
$string['maxnumcoursesincombo'] = 'Visualizza <a href="{$a->link}">{$a->numberofcourses} corsi</a>.';
$string['maxsectionslimit'] = 'Non è possibile creare la sezione perché il numero di sezioni totale eccederebbe il numero consentito per il corso ({$a}).';
$string['maxsize'] = 'Dimensione massima: {$a}';
$string['maxsizeandareasize'] = 'Dimensione massima dei file: {$a->size}, limite complessivo: {$a->areasize}';
$string['maxsizeandattachments'] = 'Dimensione massima dei file: {$a->size}, numero massimo di file: {$a->attachments}';
$string['maxsizeandattachmentsandareasize'] = 'Dimensione massima dei file: {$a->size}, numero massimo di file: {$a->attachments}, dimensione totale: {$a->areasize}';
$string['memberincourse'] = 'Persone nel corso';
$string['menu'] = 'Menu';
$string['message'] = 'Messaggio';
$string['messagebody'] = 'Corpo del messaggio';
$string['messagedselectedusers'] = 'È stato inviato il messaggio agli utenti selezionati e l\'elenco dei destinatari è stata svuotata.';
$string['messagedselectedusersfailed'] = 'Qualcosa non è andato a buon fine mentre veniva mandato il messaggio agli utenti selezionati. Alcuni utenti potrebbero aver ricevuto la mail.';
$string['messageprovider:asyncbackupnotification'] = 'Notifiche backup/ripristino asincrono';
$string['messageprovider:availableupdate'] = 'Notifiche sulla disponibilità di aggiornamenti';
$string['messageprovider:backup'] = 'Notifiche backup';
$string['messageprovider:badgecreatornotice'] = 'Notifiche creatore del badge';
$string['messageprovider:badgerecipientnotice'] = 'Notifiche destinatario del badge';
$string['messageprovider:competencyplancomment'] = 'Commenti sui piani di formazione';
$string['messageprovider:competencyusercompcomment'] = 'Commenti sulle competenze';
$string['messageprovider:coursecompleted'] = 'Corso completato';
$string['messageprovider:coursecontentupdated'] = 'Modifiche ai contenuti dei corsi';
$string['messageprovider:courserequestapproved'] = 'Notifiche di approvazione corsi a richiesta';
$string['messageprovider:courserequested'] = 'Notifiche di richieste corsi';
$string['messageprovider:courserequestrejected'] = 'Notifiche di mancata approvazione corsi a richiesta';
$string['messageprovider:enrolcoursewelcomemessage'] = 'Messaggio di benvenuto di iscrizione al corso';
$string['messageprovider:errors'] = 'Errori gravi del sito';
$string['messageprovider:errors_help'] = 'Sono errori rilevanti dei quali l\'amministratore dovrebbe essere informato.';
$string['messageprovider:failedtaskmaxdelay'] = 'Elaborazione che raggiunge il ritardo massimo di errore';
$string['messageprovider:gradenotifications'] = 'Notifiche di valutazioni';
$string['messageprovider:infected'] = 'Notifiche errori antivirus';
$string['messageprovider:insights'] = 'Considerazioni generate dai modelli dei pronostici';
$string['messageprovider:instantmessage'] = 'Messaggi personali tra utenti';
$string['messageprovider:instantmessage_help'] = 'La sezione consente di configurare il comportamento dei  messaggi che ricevi dagli altri utenti del sito.';
$string['messageprovider:messagecontactrequests'] = 'Notifiche di richieste di contatto';
$string['messageprovider:newlogin'] = 'Notifiche di nuove autenticazione';
$string['messageprovider:notices'] = 'Notifiche di problemi minori';
$string['messageprovider:notices_help'] = 'Si tratta di note che dovrebbero essere rese note l\'amministratore.';
$string['messageprovider:reportbuilderschedule'] = 'Pianificazioni personalizzate di Report builder';
$string['messageselect'] = 'Seleziona questo utente come destinatario del messaggio';
$string['messageselectadd'] = 'Invia un messaggio';
$string['middlename'] = 'Secondo nome';
$string['migratinggrades'] = 'Migrazione valutazioni';
$string['min'] = 'min.';
$string['mins'] = 'min.';
$string['minute'] = 'minuto';
$string['minutes'] = 'minuti';
$string['miscellaneous'] = 'Generale';
$string['missingcategory'] = 'Devi scegliere una categoria';
$string['missingdescription'] = 'Non hai inserito la descrizione';
$string['missingemail'] = 'Non hai inserito l\'email';
$string['missingfirstname'] = 'Non hai inserito il nome';
$string['missingfromdisk'] = 'Manca sul disco';
$string['missingfullname'] = 'Non hai inserito il Nome';
$string['missinglastname'] = 'Il cognome è mancante';
$string['missingname'] = 'Non hai inserito il nome';
$string['missingnewpassword'] = 'Nuova password mancante';
$string['missingpassword'] = 'Non hai inserito la password';
$string['missingrecaptchachallengefield'] = 'Il challenge reCAPTCHA non è andato a buon fine. Per favore riprova.';
$string['missingreqreason'] = 'Non hai inserito la motivazione';
$string['missingshortname'] = 'Non hai inserito il nome abbreviato';
$string['missingshortsitename'] = 'Nome breve del sito mancante';
$string['missingsitedescription'] = 'Non hai inserito la descrizione del sito';
$string['missingsitename'] = 'Non hai inserito il nome del sito';
$string['missingstrings'] = 'Controlla le stringhe mancanti';
$string['missingstudent'] = 'Devi scegliere qualcosa';
$string['missingsummary'] = 'Non hai inserito l\'Introduzione';
$string['missingteacher'] = 'Devi scegliere qualcosa';
$string['missingurl'] = 'Non hai inserito la URL';
$string['missingusername'] = 'Non hai inserito un username';
$string['moddoesnotsupporttype'] = 'Il modulo {$a->modname} non supporta il caricamento di file di tipo {$a->type}';
$string['modhide'] = 'Nascondi';
$string['modified'] = 'Modificato';
$string['modshow'] = 'Visualizza';
$string['moduleintro'] = 'Descrizione';
$string['modulesetup'] = 'Impostazione tabelle modulo';
$string['modulesuccess'] = 'Tabelle {$a} impostate correttamente';
$string['modulesused'] = 'Moduli utilizzati';
$string['modvisible'] = 'Disponibilità';
$string['modvisible_help'] = '* Visualizza nella pagina home del corso*: disponibile agli studenti (a seconda delle eventuali condizioni di accesso).
* Nascondi nella pagina home del corso *:  Non disponibile agli studenti';
$string['modvisiblehiddensection'] = 'Disponibilità';
$string['modvisiblehiddensection_help'] = '* Nascondi nella pagina home del corso *:  Non disponibile agli studenti
* Rendi disponibile ma non visibile nella pagina home del corso: Disponibile agli studenti se viene fornito un link. Le attività appariranno comunque nel registro delle valutazioni ed n altri report.';
$string['modvisiblewithstealth'] = 'Disponibilità';
$string['modvisiblewithstealth_help'] = '* Visualizza nella pagina home del corso*: disponibile agli studenti (a seconda delle eventuali condizioni di accesso).
* Nascondi nella pagina home del corso *:  Non disponibile agli studenti
* Rendi disponibile ma non visibile nella pagina home del corso: Disponibile agli studenti se viene fornito un link. Le attività appariranno comunque nel registro delle valutazioni ed n altri report.';
$string['month'] = 'Mese';
$string['months'] = 'Mesi';
$string['moodledocs'] = 'Moodle Doc';
$string['moodledocslink'] = 'Documentazione su questa pagina';
$string['moodlelogo'] = 'Logo Moodle';
$string['moodlenet:cannotconnecttoserver'] = 'Non è passibile collegarsi al server MoodleNet';
$string['moodlenet:columnname'] = 'Nome';
$string['moodlenet:columnsenddate'] = 'Data di invio';
$string['moodlenet:columnsendstatus'] = 'Stati dell\'invio';
$string['moodlenet:columntype'] = 'Tipo';
$string['moodlenet:configoauthservice'] = 'Selezionare un servizio MoodleNet OAuth 2 per abilitare la condivisione sullo specifico sito MoodleNet. Se il servizio non esiste ancora, sarà necessario<a href="{$a}">crearlo</a>.';
$string['moodlenet:deletedactivity'] = 'Attività eliminata';
$string['moodlenet:deletedcourse'] = 'Corso eliminato';
$string['moodlenet:eventresourceexported'] = 'Risorsa esportata';
$string['moodlenet:gotomoodlenet'] = 'Vai alle bozze MoodleNet';
$string['moodlenet:issuerisnotauthorized'] = 'L\'issuer MoodleNet non è autorizzato';
$string['moodlenet:issuerisnotenabled'] = 'L\'issuer MoodleNet non è abilitato';
$string['moodlenet:issuerisnotset'] = 'L\'issuer MoodleNet non è impostato nell\'amministrazione del sito';
$string['moodlenet:nosharedresources'] = 'Al momento non ci sono risorse condivise da visualizzare.';
$string['moodlenet:outboundsettings'] = 'Impostazioni MoodleNet in uscita';
$string['moodlenet:packagingandsending'] = 'Pacchettizzazione del file e caricamento su MoodleNet...';
$string['moodlenet:sharefailtext'] = 'Si è verificato un errore durante la condivisione dei contenuti su MoodleNet.<br>Riprovare più tardi.';
$string['moodlenet:sharefailtextwithsitesupport'] = 'Si è verificato un errore durante la condivisione dei contenuti su MoodleNet.<br>Riprovare più tardi o <a href="{$a}">contattare l\'assistenza del sito</a>.';
$string['moodlenet:sharefailtitle'] = 'Qualcosa non ha funzionato';
$string['moodlenet:sharefilesizelimitexceeded'] = 'La dimensione della risorsa condivisa ({$a->filesize} byte) supera il limite di {$a->filesizelimit}.';
$string['moodlenet:sharenoticeactivity'] = 'L\'attività sarà condivisa come risorsa su MoodleNet.';
$string['moodlenet:sharenoticecourse'] = 'Il corso sarà condiviso come risorsa su MoodleNet.';
$string['moodlenet:sharenoticepartial'] = 'Le attività selezionate saranno condivise come risorse su MoodleNet.';
$string['moodlenet:sharenoticepartialactivitynumber'] = '{$a} attività saranno incluse nel corso.';
$string['moodlenet:shareprogress'] = 'Stato avanzamento della condivisone su MoodleNet';
$string['moodlenet:shareprogressinfo'] = 'L\'elenco visualizza i corsi e le attività condivisi su MoodleNet.<br>Fare clic sul nome della risorsa per visualizzarla su MoodleNet.';
$string['moodlenet:sharesuccesstext'] = 'Quasi fatto! Visualizza le bozze su MoodleNet per completare la condivisone dei tuoi contenuti.';
$string['moodlenet:sharesuccesstitle'] = 'Salvato nelle bozze su MoodleNet';
$string['moodlenet:sharetomoodlenet'] = 'Condividi su MoodleNet';
$string['moodlenet:sharinglargefile'] = 'I file di grandi dimensioni possono impiegare del tempo.';
$string['moodlenet:sharingstatus'] = 'Condivisione su Moodlenet';
$string['moodlenet:sharingto'] = 'Condivisone su:';
$string['moodlerelease'] = 'Release di Moodle';
$string['moodleservicesandsupport'] = 'Servizi e supporto';
$string['moodleversion'] = 'Versione Moodle';
$string['more'] = 'ancora';
$string['moreactions'] = 'Altra azioni';
$string['morehelp'] = 'Aiuto ulteriore';
$string['morehelpaboutmodule'] = 'Ulteriore aiuto sull\'attività {$a}';
$string['moreinfo'] = 'Ulteriori informazioni';
$string['moreinformation'] = 'Maggiori informazioni su questo errore';
$string['moremenu'] = 'Altro';
$string['morenavigationlinks'] = 'Altro...';
$string['moreprofileinfoneeded'] = 'Per cortesia, dicci di più su te stesso';
$string['mostrecently'] = 'più recentemente';
$string['move'] = 'Sposta';
$string['movecategoriessuccess'] = '{$a->count} categorie sono state spostate correttamente nella categoria \'{$a->to}\'';
$string['movecategoriestotopsuccess'] = '{$a->count} categorie sono state spostate correttamente al primo livello';
$string['movecategorycontentto'] = 'Sposta in';
$string['movecategorysuccess'] = 'La categoria \'{$a->moved}\' è stata spostata correttamente in {$a->to}\'';
$string['movecategoryto'] = 'Sposta categoria in:';
$string['movecategorytotopsuccess'] = 'La categoria \'{$a->moved}\' è stata spostata correttamente al primo livello';
$string['movecontent'] = 'Sposta {$a}';
$string['movecontentafter'] = 'Dopo "{$a}"';
$string['movecontentstoanothercategory'] = 'Sposta i corsi in un altra categoria';
$string['movecontenttothetop'] = 'All\'inizio dell\'elenco';
$string['movecoursemodule'] = 'Sposta attività';
$string['movecoursesection'] = 'Sposta sezione';
$string['movecourseto'] = 'Sposta corso in:';
$string['movedown'] = 'Sposta in basso';
$string['movefilestohere'] = 'Sposta i files qui';
$string['movefull'] = 'Sposta {$a} in questo posto';
$string['movehere'] = 'Sposta qui';
$string['moveitemdown'] = 'Sposta {$a} in basso';
$string['moveitemup'] = 'Sposta {$a} in alto';
$string['moveleft'] = 'Sposta a sinistra';
$string['moveright'] = 'Sposta a destra';
$string['movesection'] = 'Sposta sezione {$a}';
$string['moveselectedcategoriesto'] = 'Sposta categorie selezionate in';
$string['moveselectedcoursesto'] = 'Sposta i corsi selezionati in...';
$string['movetoanotherfolder'] = 'Sposta in un\'altra cartella';
$string['moveup'] = 'Sposta in alto';
$string['mustchangepassword'] = 'La nuova password deve essere diversa dall\'attuale.';
$string['mustconfirm'] = 'È necessario confermare l\'account';
$string['mycourses'] = 'I miei corsi';
$string['myfiles'] = 'File personali';
$string['myfilesmanage'] = 'Gestione file personali';
$string['myhome'] = 'Dashboard';
$string['mymoodledashboard'] = 'Dashboard My Moodle';
$string['myprofile'] = 'Il mio profilo';
$string['name'] = 'Nome';
$string['namedfiletoolarge'] = 'Il file \'{$a->filename}\' è troppo grande e non può essere caricato.';
$string['nameforlink'] = 'Come vuoi chiamare questo link?';
$string['nameforpage'] = 'Nome';
$string['navigation'] = 'Navigazione';
$string['needed'] = 'Necessario';
$string['networkdropped'] = 'È stato rilevato che la tua connessione internet è poco affidabile oppure si è interrotta.<br />
Le modifiche apportate non potranno essere salvate correttamente finché la connessione non migliorerà.';
$string['never'] = 'Mai';
$string['neverdeletelogs'] = 'Non eliminare mai i log';
$string['new'] = 'Nuovo';
$string['newaccount'] = 'Nuovo account';
$string['newactivityname'] = 'Nuovo nome dell\'attività {$a}';
$string['newcourse'] = 'Nuovo corso';
$string['newloginnotificationbodyfull'] = '<p>Gentile {$a->userfullname},</p>
<p>è stata rilevata un\'autenticazione con il tuo account su {$a->sitename} tramite un nuovo dispositivo.</p>
<ul>
<li>Account: {$a->username} {$a->useremail}</li>
<li>{$a->logintime}</li>
<li>Dispositivo: {$a->logindevice}</li>
<li>IP: {$a->loginip}</li>
</ul>
<p>Se riconosci questa attività, puoi ignorare questo messaggio.</p>
<p>Se invece non riconosci l\'attività, allora per favore <a href="{$a->changepasswordlink}">cambia subito la tua password</a>.</p>';
$string['newloginnotificationbodysmall'] = 'È stato appena effettuato l\'accesso al tuo account {$a} da un nuovo dispositivo.';
$string['newloginnotificationtitle'] = 'Nuova autenticazione del tuo account su {$a}';
$string['newpassword'] = 'Nuova password';
$string['newpassword_help'] = 'Inserisci una password oppure lascia vuoto per mantenere la password attuale.';
$string['newpasswordfromlost'] = '<strong>NOTA:</strong> La tua  <strong>Password </strong> ti verrà spedita nella <strong>seconda</strong> delle due mail spedite dalla procedura di recupero password. Accertati di aver ricevuto la nuova passowrd prima di proseguire.';
$string['newpasswordtext'] = 'Gentile {$a->firstname},

la password del tuo account su \'{$a->sitename}\' è stata reimpostata.

Le tue credenziali sono ora:
username: {$a->username}
password: {$a->newpassword}

Per collegart, recati su \'{$a->sitename}\' ed autenticati usando le credenziali soprastanti.

Puoi anche cambiare la nuova password da subito:
vai su {$a->link}
ed inserisci come password attuale la password fornita in questo messaggio e come nuova password una password di tua scelta.

Nella maggior parte dei programmi di posta elettronica i link appaiono in blu e sono cliccabili. Se i link non dovessero essere cliccabili,  copia ed incolla il link nella barra dell\'indirizzo del tuo browser web.

Saluti dall\'amministratore del sito \'{$a->sitename}\',
{$a->signoff}';
$string['newpicture'] = 'Nuova immagine';
$string['newpicture_help'] = 'Per caricare una nuova immagine, scegline una (in formato JPG o PNG) e poi clicca il pulsante "Aggiornamento profilo". L\'immagine sarà prima ritagliata in forma quadrata e poi ridimensionata a 100 x 100 pixel.';
$string['newpictureusernotsetup'] = 'L\'immagine del profilo può essere caricata solo dopo aver compilato e salvato i campi obbligatori.';
$string['newsectionname'] = 'Nuovo nome per la sezione {$a}';
$string['newsitem'] = 'news';
$string['newsitems'] = 'annunci';
$string['newsitemsnumber'] = 'Numero di annunci da visualizzare';
$string['newsitemsnumber_help'] = 'Il forum annunci è un forum particolare creato automaticamente con sottoscrizione obbligatoria di default e dove possono intervenire solo utenti con appositi privilegi (di default i docenti).

Se nel corso non si desidera il forum annunci, impostare il valore pari a zero.

L\'impostazione stabilisce il numero di annunci più recenti che appariranno nel blocco \'Annunci recenti\'.';
$string['newuser'] = 'Nuovo utente';
$string['newusernewpasswordsubj'] = 'Registrazione nuovo utente';
$string['newusernewpasswordtext'] = 'Gentile {$a->firstname},

È stato creato un nuovo account su \'{$a->sitename}\'
e ti è stata assegnata una nuova password temporanea.

Le tue informazioni di accesso sono:
username: {$a->username}
password: {$a->newpassword}
(dovrai cambiare la tua password
la prima volta che effettuerai l\'accesso )

Per iniziare a usare \'{$a->sitename}\', accedi a
{$a->link}

Se hai bisogno di aiuto, puoi contattare l\'amministratore del sito,
{$a->signoff}';
$string['newusers'] = 'Nuovi utenti';
$string['newwindow'] = 'Nuova finestra';
$string['next'] = 'Successivo';
$string['nextpage'] = 'Pagina successiva';
$string['nextsection'] = 'Sezione successiva';
$string['no'] = 'No';
$string['noblockstoaddhere'] = 'Non ci sono blocchi da aggiungere alla pagina';
$string['nobody'] = 'Nessuno';
$string['nochange'] = 'Nessun cambiamento';
$string['nocomments'] = 'Non ci sono commenti';
$string['nocourses'] = 'Non ci sono corsi';
$string['nocoursesfound'] = 'Non è stato trovato nessun corso contenente \'{$a}\'';
$string['nocoursestarttime'] = 'Il corso non ha una data d\'inizio.';
$string['nocoursesyet'] = 'Questa categoria non ha corsi';
$string['nodstpresets'] = 'L\'amministratore non ha attivato il supporto per l\'ora legale.';
$string['nofilesselected'] = 'Non sono stati selezionati file da recuperare';
$string['nofilesyet'] = 'Nessun file è stato ancora trasferito sul server';
$string['nofiltersapplied'] = 'Nessun filtro applicato';
$string['nograde'] = 'Senza valutazione';
$string['nohelpforactivityorresource'] = 'Non è presente un help associato a questa risorsa o attività';
$string['noimagesyet'] = 'Nessuna immagine è stata ancora trasferita sul server';
$string['nologsfound'] = 'Non ci sono log da visualizzare';
$string['nomatchingusers'] = 'Non è stato trovato nessun utente che corrisponda al criterio di ricerca \'{$a}\'';
$string['nomorecourses'] = 'Non possono essere trovati altri corsi corrispondenti';
$string['nomoreidnumber'] = 'Non vengono usati numeri di id per evitare conflitti';
$string['none'] = 'Nessuno';
$string['noneditingteacher'] = 'Docente non editor';
$string['noneditingteacherdescription'] = 'I docenti non editor possono insegnare nei corsi e valutare gli studenti, ma non possono modificare le attività.';
$string['nonstandard'] = 'Non standard';
$string['nopendingcourses'] = 'Non ci sono corsi in attesa di approvazione';
$string['nopotentialadmins'] = 'Non ci sono possibili amministratori';
$string['nopotentialcreators'] = 'Non ci sono possibili creatori di corsi';
$string['nopotentialstudents'] = 'Non ci sono possibili studenti';
$string['nopotentialteachers'] = 'Non ci sono potenziali docenti';
$string['norecentactivity'] = 'Nessuna attività recente';
$string['noreplybouncemessage'] = 'Hai risposto ad un indirizzo no-reply. Se stavi rispondendo ad un messaggio di un forum, dovresti usare il forum {$a}.

Questo è il messaggio che hai inviato:';
$string['noreplybouncesubject'] = '{$a} - email ritornata';
$string['noreplyname'] = 'Non rispondere a questa email';
$string['noresetrecord'] = 'Non sono presenti record della richiesta. Per favore avvia nuovamente la procedura di recupero password.';
$string['noresults'] = 'Nessun risultato';
$string['noresultsfor'] = 'Nessun risultato per "{$a}"';
$string['normal'] = 'Normale';
$string['normalfilter'] = 'Filtro normale';
$string['nosite'] = 'Non si trova corso a livello di sito';
$string['nostudentsfound'] = 'Nessun {$a} trovato';
$string['nostudentsingroup'] = 'In questo gruppo non ci sono ancora studenti';
$string['nostudentsyet'] = 'In questo corso non ci sono studenti iscritti.';
$string['nosuchemail'] = 'Nessun indirizzo email';
$string['notavailable'] = 'Non disponibile';
$string['notavailablecourse'] = '{$a} non è disponibile';
$string['noteachersyet'] = 'Non ci sono ancora docenti in questo corso';
$string['noteachingupcomingcourses'] = 'Prossimi corsi che non hanno docenti o studenti';
$string['notenrolled'] = '{$a} non è iscritto a questo corso.';
$string['notenrolledprofile'] = 'Questo profilo non è disponibile perché questo utente non è iscritto a questo corso.';
$string['noteusercannotrolldatesoncontext'] = '<strong>Nota:</strong> La possibilità di posticipare date di attività durante il ripristino è stato disabilitato poiché non possiedi questo privilegio.';
$string['noteuserschangednonetocourse'] = '<strong>Nota:</strong> devono essere recuperati anche i partecipanti del corso quando vengono recuperati i dati degli utenti. L\'impostazione è stata cambiata per te.';
$string['nothingnew'] = 'Non ci sono attività recenti';
$string['nothingtodisplay'] = 'Non ci sono elementi da visualizzare';
$string['notice'] = 'Nota';
$string['noticenewerbackup'] = 'Questo backup è stato creato con Moodle {$a->backuprelease} ({$a->backupversion}) che è più recente della versione di Moodle attualmente installata {$a->serverrelease} ({$a->serverversion}). Questo può provocare alcune inconsistenze perché la compatibilità con versioni precedenti dei backup non può essere garantita.';
$string['notifications'] = 'Notifiche';
$string['notifyloginfailuresmessage'] = '{$a->time}, IP: {$a->ip}, Utente: {$a->info}, Nome dell\'utente: {$a->name}';
$string['notifyloginfailuresmessageend'] = 'Per visualizzare questi log: {$a}';
$string['notifyloginfailuresmessagestart'] = 'Ecco l\'elenco degli accessi falliti a {$a} dall\'ultima notifica.';
$string['notifyloginfailuressubject'] = '{$a} :: Notifica accessi falliti';
$string['notincluded'] = 'Non incluso';
$string['notingroup'] = 'Per visualizzare l\'attività devi appartenere ad un gruppo .';
$string['notpublic'] = 'Questi dati non saranno pubblicati';
$string['nousersfound'] = 'Non è stato trovato nessun utente';
$string['nousersmatching'] = 'Nessun utente \'{$a}\' è stato trovato';
$string['nousersyet'] = 'Non ci sono ancora utenti registrati';
$string['novalidcourses'] = 'Nessun corso valido da visualizzare';
$string['now'] = 'adesso';
$string['numattempts'] = '{$a} tentativi di accesso falliti';
$string['numberofcourses'] = 'Numero di corsi';
$string['numberweeks'] = 'Numero di sezioni';
$string['numday'] = '{$a} giorno';
$string['numdays'] = '{$a} giorni';
$string['numhours'] = '{$a} ore';
$string['numletters'] = '{$a} lettere';
$string['numminutes'] = '{$a} minuti';
$string['nummonth'] = '{$a} mese';
$string['nummonths'] = '{$a} mesi';
$string['numseconds'] = '{$a} secondi';
$string['numviews'] = '{$a} letture';
$string['numweek'] = '{$a} settimana';
$string['numweeks'] = '{$a} settimane';
$string['numwords'] = '{$a} parole';
$string['numyear'] = '{$a} anno';
$string['numyears'] = '{$a} anni';
$string['ok'] = 'OK';
$string['oldpassword'] = 'Password attuale';
$string['olduserdirectory'] = 'Questa è la VECCHIA cartella utenti, e non è più necessaria. La puoi tranquillamente eliminare. Tutti i file che contiene sono stati copiati nella NUOVA cartella utenti.';
$string['opendrawerblocks'] = 'Apri il cassetto del blocco';
$string['opendrawerindex'] = 'Apri indice del corso';
$string['opensinnewwindow'] = 'Apri in una nuova finestra';
$string['operator_and'] = 'and';
$string['operator_andnot'] = 'and not';
$string['operator_or'] = 'or';
$string['optional'] = 'opzionale';
$string['options'] = 'opzioni';
$string['order'] = 'Ordine';
$string['originalpath'] = 'Percorso originale';
$string['orphanedactivitiesinsectionno'] = 'Attività orfane (sezione {$a})';
$string['other'] = 'Altro';
$string['outline'] = 'Profilo';
$string['outlinereport'] = 'Report riassuntivo';
$string['page'] = 'Pagina';
$string['pagea'] = 'Pagina {$a}';
$string['pagedcontentnavigation'] = 'Navigazione delle pagine';
$string['pagedcontentnavigationactiveitem'] = 'Pagina attuale, pagina {$a}';
$string['pagedcontentnavigationitem'] = 'Vai alla pagina {$a}';
$string['pagedcontentpagingbaritemsperpage'] = 'Visualizza {$a} elementi per pagina';
$string['pageheaderconfigablock'] = 'Configurazione blocco in {$a->fullname}';
$string['pagepath'] = 'Percorso della pagina';
$string['pageshouldredirect'] = 'La pagina dovrebbe reindirizzarti automaticamente. In mancanza, puoi usare il link sottostante.';
$string['parentcategory'] = 'Categoria di appartenenza';
$string['parentcoursenotfound'] = 'Corso padre non trovato!';
$string['parentfolder'] = 'Cartella superiore';
$string['participants'] = 'Partecipanti';
$string['participantslist'] = 'Elenco';
$string['participationratio'] = 'Tasso di partecipazione';
$string['participationreport'] = 'Report della partecipazione';
$string['password'] = 'Password';
$string['passwordchanged'] = 'La password è stata modificata';
$string['passwordextlink'] = 'Il link seguente è stato fornito per recuperare la password. Il link porta fuori da questo sito.';
$string['passwordforgotten'] = 'Password dimenticata';
$string['passwordforgotteninstructions'] = 'I tuoi dati devono essere reperiti nel database di Moodle. Inserisci il tuo username <strong>oppure</strong> la tua email nelle caselle corrispondenti. Non è necessario inserirli entrambi.';
$string['passwordforgotteninstructions2'] = 'Per recuperare la password, inserisci a tua scelta lo username oppure l\'email in uno solo dei campi sottostanti. Se il dato inserito è presente nel database, riceverai un\'email con le istruzioni per completare il recupero.';
$string['passwordpolicynomatch'] = 'La tua password non soddisfa più le regole password.
   {$a}';
$string['passwordsdiffer'] = 'Le password non corrispondono';
$string['passwordset'] = 'La password è stata impostata.';
$string['path'] = 'Percorso';
$string['pathnotexists'] = 'Il percorso non esiste sul tuo server!';
$string['pathslasherror'] = 'Il percorso non può terminare con uno slash.';
$string['paymentinstant'] = 'Utilizza il pulsante sottostante per pagare ed essere iscritto in pochi minuti.';
$string['paymentpending'] = '(<small><b><u>{$a}</u></b> pendenti</small>)';
$string['paymentrequired'] = 'L\'accesso al corso richiede un pagamento';
$string['payments'] = 'Pagamenti';
$string['paymentsorry'] = 'Grazie per il pagamento. Quando il pagamento sarà stato elaborato potrai accedere al corso {$a->fullname}. Per favore provare ad accedere tra qualche minuto. S continui ad avere problemi avverti {$a->teacher} o l\'amministratore del sito.';
$string['paymentthanks'] = 'Grazie per il pagamento. Ora sei iscritto nel corso:<br />"{$a}"';
$string['pendingrequests'] = 'Corsi da approvare';
$string['percents'] = '{$a}%';
$string['periodending'] = 'Termine periodo ({$a})';
$string['perpage'] = 'Per pagina';
$string['perpagea'] = 'Per pagina: {$a}';
$string['personal'] = 'Personale';
$string['personalprofile'] = 'Profilo personale';
$string['phone'] = 'Telefono';
$string['phone1'] = 'Telefono';
$string['phone2'] = 'Cellulare';
$string['phpinfo'] = 'PHP info';
$string['picture'] = 'Immagine';
$string['pictureof'] = 'Immagine {$a}';
$string['pictureofuser'] = 'Immagine dell\'utente';
$string['placeholdertypeorselect'] = 'Scrivi o seleziona...';
$string['pleaseclose'] = 'Si prega di chiudere questa finestra adesso.';
$string['pleasesearchmore'] = 'Per favore cercate ancora';
$string['pleaseusesearch'] = 'Per favore usate la ricerca';
$string['plugin'] = 'Plugin';
$string['pluginarea'] = 'Area';
$string['plugincheck'] = 'Controllo dei plugin';
$string['plugindeletefiles'] = 'Tutti i dati relativi al plugin \'{$a->name}\' sono stati eliminati dal database. Per evitare che il plugin si installi nuovamente, è necessario rimuovere dal server la seguente cartella: {$a->directory}';
$string['pluginitemid'] = 'ID elemento';
$string['pluginmissingfromdisk'] = '{$a->name} (Mancante sul disco)';
$string['pluginsetup'] = 'Impostazione tabelle plugin';
$string['policyaccept'] = 'Ho letto le condizioni e le accetto';
$string['policyagree'] = 'Per continuare ad usare questo sito, è necessario accettare le condizioni riportate.';
$string['policyagreement'] = 'Condizioni di utilizzo del sito';
$string['policyagreementclick'] = 'Accordo sulla politiche del sito';
$string['popup'] = 'popup';
$string['popupwindow'] = 'Apri file in una nuova finestra';
$string['popupwindowname'] = 'Finestra popup';
$string['post'] = 'Scrittura';
$string['posts'] = 'Scritture';
$string['potentialadmins'] = 'Amministratori possibili';
$string['potentialcreators'] = 'Creatori di corsi possibili';
$string['potentialstudents'] = 'Studenti possibili';
$string['potentialteachers'] = 'Potenziali docenti';
$string['poweredbymoodle'] = 'Powered by <a href="https://moodle.com">Moodle</a>';
$string['preferences'] = 'Preferenze';
$string['preferredlanguage'] = 'Preferenze lingua';
$string['preferredtheme'] = 'Tema preferito';
$string['preprocessingbackupfile'] = 'Pre elaborazione del file di backup';
$string['prev'] = 'Precedente';
$string['preview'] = 'Anteprima';
$string['previeworchoose'] = 'Anteprima o scegli tema';
$string['previewthemename'] = 'Anteprima tema \'{$a}\'';
$string['previous'] = 'Precedente';
$string['previouslyselectedusers'] = 'Utenti selezionati in precedenza che non soddisfano il criterio di ricerca \'{$a}\'';
$string['previouspage'] = 'Pagina precedente';
$string['previoussection'] = 'Sezione precedente';
$string['primaryadminsetup'] = 'Imposta account amministratore';
$string['privacy:metadata:config_log'] = 'Log delle modifiche alla configurazione.';
$string['privacy:metadata:config_log:name'] = 'Nome della impostazione modificata.';
$string['privacy:metadata:config_log:oldvalue'] = 'Precedente valorizzazione dell\'impostazione.';
$string['privacy:metadata:config_log:plugin'] = 'Pluign modificato.';
$string['privacy:metadata:config_log:timemodified'] = 'Orario della modifica.';
$string['privacy:metadata:config_log:userid'] = 'Utente che ha effettuato la modifica.';
$string['privacy:metadata:config_log:value'] = 'Nuova valorizzazione dell\'impostazione.';
$string['privacy:metadata:events_queue'] = 'Coda degli eventi utente in attesa di essere elaborati.';
$string['privacy:metadata:events_queue:eventdata'] = 'Dati memorizzati nell\'evento';
$string['privacy:metadata:events_queue:stackdump'] = 'Stack trace associato all\'evento.';
$string['privacy:metadata:events_queue:timecreated'] = 'Orario di creazione dell\'evento.';
$string['privacy:metadata:events_queue:userid'] = 'ID utente associata all\'evento';
$string['privacy:metadata:log'] = 'Insieme di eventi avvenuti';
$string['privacy:metadata:log:action'] = 'Descrizione dell\'azione';
$string['privacy:metadata:log:cmid'] = 'cmid';
$string['privacy:metadata:log:course'] = 'corso';
$string['privacy:metadata:log:info'] = 'Informazioni aggiuntive';
$string['privacy:metadata:log:ip'] = 'Indirizzo IP dell\'utente al verificarsi dell\'evento';
$string['privacy:metadata:log:module'] = 'modulo';
$string['privacy:metadata:log:time'] = 'Data di svolgimento dell\'azione';
$string['privacy:metadata:log:url'] = 'URL correlata all\'evento';
$string['privacy:metadata:log:userid'] = 'ID dell\'utente che ha svolto l\'azione';
$string['privacy:metadata:moodlenet_share_progress'] = 'Avanzamento della condivisione su MoodleNet';
$string['privacy:metadata:moodlenet_share_progress:cmid'] = 'ID del modulo associato';
$string['privacy:metadata:moodlenet_share_progress:courseid'] = 'ID del corso associato';
$string['privacy:metadata:moodlenet_share_progress:resourceurl'] = 'URL restituito da MoodleNet dopo una condivisione riuscita';
$string['privacy:metadata:moodlenet_share_progress:status'] = 'Stato risultante della condivisione';
$string['privacy:metadata:moodlenet_share_progress:timecreated'] = 'Ora in cui è stata eseguita la condivisione';
$string['privacy:metadata:moodlenet_share_progress:type'] = 'Tipo di condivisione eseguita';
$string['privacy:metadata:moodlenet_share_progress:userid'] = 'Utente che ha eseguito la condivisione';
$string['privacy:metadata:oauth2_refresh_token'] = 'Token aggiornato utilizzato nella comunicazione OAuth 2.0';
$string['privacy:metadata:oauth2_refresh_token:issuerid'] = 'ID dell\'issuer a cui corrisponde il token';
$string['privacy:metadata:oauth2_refresh_token:scopehash'] = 'ID dell\'utente a cui corrisponde il token';
$string['privacy:metadata:oauth2_refresh_token:timecreated'] = 'Orario di creazione del token';
$string['privacy:metadata:oauth2_refresh_token:timemodified'] = 'Orario in cui il token è stato aggiornato l\'ultima volta';
$string['privacy:metadata:oauth2_refresh_token:token'] = 'Token di aggiornamento per i rispettivi ambiti e utente';
$string['privacy:metadata:oauth2_refresh_token:userid'] = 'Id dell\'utente al quale appartiene il token';
$string['privacy:metadata:task_adhoc'] = 'Stato dell\'elaborazione ad hoc.';
$string['privacy:metadata:task_adhoc:component'] = 'Componente che richiede l\'elaborazione.';
$string['privacy:metadata:task_adhoc:nextruntime'] = 'Primo orario utile per svolgere l\'elaborazione.';
$string['privacy:metadata:task_adhoc:userid'] = 'Utente con il quale eseguire l\'elaborazione.';
$string['privacy:metadata:task_log'] = 'Output di log';
$string['privacy:metadata:task_log:component'] = 'Componente titolare del task';
$string['privacy:metadata:task_log:userid'] = 'Utente al quale appartiene l\'attività';
$string['privacy:metadata:upgrade_log'] = 'Log degli aggiornamenti.';
$string['privacy:metadata:upgrade_log:backtrace'] = 'Backtrace associati all\'aggiornamento.';
$string['privacy:metadata:upgrade_log:details'] = 'Informazioni aggiuntive sull\'aggiornamento.';
$string['privacy:metadata:upgrade_log:info'] = 'Informazioni principiali sull\'aggiornamento.';
$string['privacy:metadata:upgrade_log:plugin'] = 'Plugin che è stato aggiornato.';
$string['privacy:metadata:upgrade_log:targetversion'] = 'Nuova versione installata con l\'aggiornamento.';
$string['privacy:metadata:upgrade_log:timemodified'] = 'Orario di svolgimento dell\'aggiornamento';
$string['privacy:metadata:upgrade_log:type'] = 'Tipo di linea di log.';
$string['privacy:metadata:upgrade_log:userid'] = 'Utente che ha eseguito l\'aggiornamento.';
$string['privacy:metadata:upgrade_log:version'] = 'Versione del plugin precedente all\'aggiornamento.';
$string['private_files_handler'] = 'Memorizza gli allegati alle email nei File personali dell\'utente';
$string['private_files_handler_name'] = 'Email verso File personali';
$string['privatefiles'] = 'File personali';
$string['privatefilesmanage'] = 'Gestione file personali';
$string['proceed'] = 'Prosegui';
$string['profile'] = 'Profilo';
$string['profilenotshown'] = 'La descrizione presente nel profilo di questo utente non sarà visualizzata finché l\'utente stesso non risulti iscritto ad almeno un corso.';
$string['progress'] = 'Avanzamento';
$string['publicprofile'] = 'Profilo pubblico';
$string['publicsitefileswarning'] = 'Nota: i file salvati qui possono essere visualizzati da chiunque';
$string['publicsitefileswarning2'] = 'Nota: i file salvati qui possono essere visualizzati da chiunque a conoscenza della URL oppure in grado di ricavarla. Per motivi di sicurezza si consiglia di eliminare file di backup subito dopo il ripristino.';
$string['publicsitefileswarning3'] = 'Nota: i file caricati qui possono essere visualizzati da chiunque a conoscenza della URL oppure in grado di ricavarla. <br />Per motivi di sicurezza si raccomanda di caricare file di backup solamente nel folder sicuro \'backupdata\'.';
$string['question'] = 'Domanda';
$string['questionsinthequestionbank'] = 'Domande nel deposito';
$string['queued'] = 'Accodato';
$string['quotausage'] = 'Hai utilizzato {$a->used} su un massimo di {$a->total}';
$string['readinginfofrombackup'] = 'Lettura informazioni dal backup';
$string['readme'] = 'LEGGIMI';
$string['recentactivity'] = 'Attività recente';
$string['recentactivityreport'] = 'Report completo dell\'attività recente...';
$string['recipientslist'] = 'Elenco destinatari';
$string['recommended'] = 'Suggeriti';
$string['recreatedcategory'] = 'La categoria {$a} è stata creata nuovamente';
$string['redirect'] = 'Reindirizza';
$string['reducesections'] = 'Riduci il numero di sezioni';
$string['refresh'] = 'Aggiorna';
$string['refreshingevents'] = 'Aggiornamento eventi';
$string['registration'] = 'Registrazione di Moodle';
$string['registrationcontact'] = 'Possibilità di essere contattati';
$string['registrationcontactno'] = 'No, non desidero essere contattato';
$string['registrationcontactyes'] = 'Si, desidero un modello di contatto affinché altri Moodler mi possano contattare';
$string['registrationemail'] = 'Notifiche via email';
$string['registrationinfo'] = '<p>In questa pagina è possibileregistrare il sito Moodle su moodle.org. La registrazione è gratuita e l\'email fornita sarà inserita in una mailing list a basso traffico con avvisi di sicurezza e messaggi sulle nuove release di Moodle.</p>
<p>I dati inviati rimarranno privati e non saranno venduti o trasferiti a terzi. I motivi per i quali suggeriamo di registrare il sito sono la ricezione di avvisi sulla sicurezza e la raccolta di dati statistici utili a capire meglio l\'intera comunità Moodle.</p>
<p>Se lo si desidera il nome del sito assieme alla nazionalità ed alla URL per raggiungerlo possono essere pubblicati nell\'elenco dei siti registrati.</p>
<p>Le nuove registrazioni sono tutte verificate manualmente prima di essere inserite nell\'elenco pubblico. In qualsiasi momento è  possibile aggiornare i dati e modificare le preferenze di pubblicazione inviando nuovamente la registrazione.</p>';
$string['registrationinfotitle'] = 'Informazioni per la registrazione';
$string['registrationsend'] = 'Invia la registrazione a moodle.org';
$string['registrationyes'] = 'Si, inviatemi email su nuovi rilasci di Moodle, avvisi sulla sicurezza e altre novità di rilievo.';
$string['reject'] = 'Invia il rifiuto';
$string['rejectdots'] = 'Rifiuta...';
$string['relativedatesmode'] = 'Modalità date relative';
$string['relativedatesmode_help'] = 'Visualizza le date del corso relative alla data nella quale l\'utente ha iniziato il corso.

La data di inizio del corso corrisponderà alla data di iscrizione al corso a meno che l\'iscrizione sia avvenuta prima della data di inizio del corso, nel qual caso la data di inizio per l\'utente corrisponderà alla data di inizio del corso.<br/>
<strong>ATTENZIONE: si tratta di un\'impostazione sperimentale e potrebbe non essere supportata per tutte le attività. Una volta che il corso sarà stato creato, non sarà più possibile modificare questa impostazione.</strong>';
$string['relativedatesmode_warning'] = '<strong>Attenzione:</strong> una volta che il corso sarà stato creato, non sarà più possibile modificare la modalità date relative.';
$string['reload'] = 'Ricarica';
$string['remoteappuser'] = 'Utente remoto di {$a}';
$string['remove'] = 'Rimuovi';
$string['removeadmin'] = 'Rimuovi amministratore';
$string['removecreator'] = 'Rimuovi creatore di corsi';
$string['removestudent'] = 'Rimuovi studente';
$string['removeteacher'] = 'Rimuovi docente';
$string['rename'] = 'Rinomina';
$string['renamefileto'] = 'Rinomina <b>{$a}</b> in';
$string['report'] = 'Report';
$string['reports'] = 'Report';
$string['reporttype'] = 'Tipo di report';
$string['repositories'] = 'Repository';
$string['requestcourse'] = 'Richiedi l\'attivazione di un corso';
$string['requestedby'] = 'Richiesto da';
$string['requestedcourses'] = 'Corsi richesti';
$string['requestreason'] = 'Motivazione della richiesta del corso';
$string['requests'] = 'Richieste';
$string['required'] = 'Obbligatorio';
$string['requirespayment'] = 'Questo corso richiede un pagamento per l\'accesso';
$string['resendemail'] = 'Invia di nuovo l\'email di conferma';
$string['reset'] = 'Reset';
$string['resetcomponent'] = 'Componente';
$string['resetcourse'] = 'Reset corso';
$string['resetcourseconfirm'] = 'Reimpostare il corso?';
$string['resetcoursewarning'] = 'Sei sicuro di reimpostare il corso \'{$a}\'?
<br/><br/>
Saranno eliminati i dati selezionati e il corso sarà ripristinato al suo stato originale. L\'azione non potrà essere annullata.';
$string['resetinfo'] = 'Elimina tutti i dati utente e ripristina il corso al suo stato originale, mantenendo intatte le attività del corso e le relative impostazioni.';
$string['resetinfoselect'] = 'Selezionare dalle categorie seguenti i dati che si desidera eliminare o reimpostare:';
$string['resetnotimplemented'] = 'Reset non suportato';
$string['resetnotimplementedinfo'] = 'Le seguenti attività non possono essere resettate:';
$string['resetrecordexpired'] = 'Il link di recupero password è scaduto da più di {$a} minuti. Per favore avvia nuovamente la procedura di recupero password.';
$string['resetstartdate'] = 'Data inizio reset';
$string['resetstatus'] = 'Stato';
$string['resettable'] = 'Reimposta preferenze tabella';
$string['resettask'] = 'Reset';
$string['resettodefaults'] = 'Reimposta i valori standard';
$string['resortcourses'] = 'Ordina corsi';
$string['resortsubcategoriesby'] = 'Ordinamento crescente sotto categorie per {$a}';
$string['resortsubcategoriesbyreverse'] = 'Ordinamento decrescente sotto categorie per {$a}';
$string['resource'] = 'Risorsa';
$string['resource_type'] = 'Tipo di risorsa';
$string['resourcedisplayauto'] = 'Automatica';
$string['resourcedisplaydownload'] = 'Forza scaricamento';
$string['resourcedisplayembed'] = 'Incorpora';
$string['resourcedisplayframe'] = 'Frame';
$string['resourcedisplaynew'] = 'Nuova finestra';
$string['resourcedisplayopen'] = 'Apri';
$string['resourcedisplaypopup'] = 'Popup';
$string['resources'] = 'Risorse';
$string['resources_help'] = 'I tipi di risorse consentono di aggiungere al corso praticamente qualsiasi tipo di contenuto web.';
$string['restore'] = 'Ripristino';
$string['restorecancelled'] = 'Ripristino annullato';
$string['restorecannotassignroles'] = 'Il ripristino ha bisogno di assegnare ruoli ma tu non sei autorizzato a farlo';
$string['restorecannotcreateorassignroles'] = 'Il ripristino ha bisogno di creare o assegnare ruoli ma tu non sei autorizzato a farlo';
$string['restorecannotcreateuser'] = 'Il ripristino deve creare l\'utente \'{$a}\' ma non hai il permesso di farlo.';
$string['restorecannotoverrideperms'] = 'Il ripristino ha bisogno di modificare i privilegi ma tu non sei autorizzato a farlo';
$string['restorecoursenow'] = 'Recupera questo corso ora!';
$string['restoredaccount'] = 'Account ripristinato';
$string['restoredaccountinfo'] = 'Questo account è stato importato da un altro server e la password è stata perduta. Per impostare una nuova password tramite email, fai click su "Continua"';
$string['restorefinished'] = 'Recupero completato con successo';
$string['restoreinfo'] = 'Utilizza un file di backup per ripristinare una versione precedente di un corso o per creare un nuovo corso.';
$string['restoremnethostidmismatch'] = 'L\'host id MNet dell\'utente \'{$a}\' non corrisponde all\'host Id MNet locale.';
$string['restoreto'] = 'Recupera a';
$string['restoretositeadding'] = 'Attenzione: si sta per ripristinare la pagina home del sito in modalità aggiunta dati.';
$string['restoretositedeleting'] = 'Attenzione: si sta per ripristinare la pagina home del sito in modalità eliminazione dati esistenti.';
$string['restoreuserconflict'] = 'Tentare di ripristinare l\'utente \'{$a}\' causerà dei conflitti';
$string['restoreuserinfofailed'] = 'Il ripristino è stato interrotto poiché non hai il permesso di ripristinare dati utente.';
$string['restoreusersprecheck'] = 'Controllo dati utente';
$string['restoreusersprecheckerror'] = 'Si sono verificati alcuni problemi durante il controllo dei dati utente';
$string['restricted'] = 'Accesso vincolato';
$string['resultsfound'] = 'Risultati trovati: {$a}';
$string['retry'] = 'Riprova';
$string['returningtosite'] = 'Ciao, sei ritornato?';
$string['returntooriginaluser'] = 'Ritorna a {$a}';
$string['revert'] = 'Ripristina';
$string['role'] = 'Ruolo';
$string['roleassignments'] = 'Assegnazione ruoli';
$string['rolemappings'] = 'Mappatura dei ruoli';
$string['rolerenaming'] = 'Personalizzazione nomi dei ruoli';
$string['rolerenaming_help'] = 'Cambia il nome dei ruoli in questo corso.';
$string['rolerenaming_success'] = 'I nome dei ruoli in questo corso sono stati aggiornati.';
$string['roles'] = 'Ruoli';
$string['rss'] = 'RSS';
$string['rssarticles'] = 'Numero di ultimi articoli RSS';
$string['rsserror'] = 'Errore nella lettura dei dati RSS';
$string['rsserrorauth'] = 'Il tuo feed RSS non contiene un token di autenticazione valido.';
$string['rsserrorguest'] = 'Questo feed utilizza l\'accesso come ospite per accedere ai dati ma l\'ospite non è autorizzato a leggere i dati, Recati alla URL sorgente del del feed e ottieni un nuovo feed RSS valido,';
$string['rsskeyshelp'] = '<p>Per garantire sicurezza e privacy, gli URL dei feed RSS contengono un token speciale che identifica l\'utente dei feed. In questo modo è possibile evitare che altri utenti possano accedere ad aeree di Moodle dove non sono autorizzati ad accedere utilizzando i feed RSS.</p><p>Il token viene creato automaticamente al tuo primo accesso ad un\'area di Moodle dove vengono creati feed RSS. Se sospetti che il tuo token RSS sia stato compromesso, puoi richiederne uno nuovo tramite il link Reset. Eseguendo il reset tutti i tuoi URL di feed RSS non saranno più validi.</p>';
$string['rsstype'] = 'RSS per questa attività';
$string['save'] = 'Salva';
$string['saveandnext'] = 'Salva e visualizza il prossimo';
$string['savechanges'] = 'Salva modifiche';
$string['savechangesanddisplay'] = 'Salva e visualizza';
$string['savechangesandreturn'] = 'Salva';
$string['savechangesandreturntocourse'] = 'Salva e torna al corso';
$string['savecomment'] = 'Salva commento';
$string['savedat'] = 'Salvato:';
$string['savepreferences'] = 'Salva impostazioni';
$string['saveto'] = 'Salva in';
$string['scale'] = 'Scala';
$string['scale_help'] = '<p>I docenti possono creare scale di valutazione personalizzate utilizzabili
  in qualsiasi attività valutabile.</p>
<p>È preferibile assegnare alle scale di valutazione dei nomi che le identifichino
  in modo chiaro: il nome infatti apparirà nella lista drop-down delle scale
  di valutazione disponibili e negli help sensibili al contesto.</p>
<p>Le scale di valutazione sono definite tramite una lista di parole
  separate da virgole che spaziano da una valutazione minima a una massima. Di
  seguito è riportato un esempio di scala di valutazione:</p>
<blockquote><i>
   Gravemente insufficiente, Insufficiente, Sufficiente, Buono, Molto buono,
       Ottimo</i></blockquote>
<p>Le scale di valutazione personalizzate possono includere una descrizione
  del loro significato e suggerimenti su come potrebbero essere impiegate.
  Questa descrizione apparirà nelle pagine di help dei docenti e degli studenti.</p>
<p>È anche possibile definire una o più scale di valutazione "standard"
  a livello di sito da parte dell\'amministratore del sistema e queste saranno disponibili in tutti i corsi.</p>';
$string['scale_link'] = 'grade/scale';
$string['scales'] = 'Scale';
$string['scalescustom'] = 'Scale personalizzate';
$string['scalescustomcreate'] = 'Aggiungi una scala';
$string['scalescustomno'] = 'Non sono ancora state create scale personalizzate';
$string['scalesstandard'] = 'Scale standard';
$string['scalestandard'] = 'Scala standard';
$string['scalestandard_help'] = '<p>È una scala definita a livello di sito e disponibile in qualsiasi corso.</p>';
$string['scalestandard_link'] = 'grade/scale';
$string['scalestip'] = 'Per creare scale personalizzate, utilizza il link \'Scale\' nel menu di amministrazione del tuo corso.';
$string['scalestip2'] = 'Per creare scale personalizzate, fate click sul link Scale presente nel blocco Amministrazione del corso, poi selezionate Modifica -> Scale';
$string['schedule'] = 'Schedula';
$string['screenshot'] = 'Screenshot';
$string['search'] = 'Cerca';
$string['search_help'] = 'Per ricerche semplici, inserisci una o più parole separate da uno spazio. Saranno utilizzate tutte le parole più lunghe di due caratteri.

Per ricerche complesse, puoi accedere al form di ricerca avanzata facendo click sul pulsante cerca avendo cura di non aver inserito parole.';
$string['searchactivities'] = 'Cerca attività usando il nome o la descrizione';
$string['searchagain'] = 'Cerca ancora';
$string['searchbyemail'] = 'Cerca indirizzo email';
$string['searchbyusername'] = 'Cerca username';
$string['searchcoursecategories'] = 'Cerca categorie';
$string['searchcourses'] = 'Cerca corsi';
$string['searchgroups'] = 'Cerca gruppi';
$string['searchitems'] = 'Cerca elementi';
$string['searchoptions'] = 'Opzioni di ricerca';
$string['searchresults'] = 'Risultati della ricerca';
$string['searchusers'] = 'Cerca utente';
$string['sec'] = 'secondo';
$string['seconds'] = 'secondi';
$string['secondsleft'] = '{$a} secondi';
$string['secondstotime172800'] = '2 giorni';
$string['secondstotime259200'] = '3 giorni';
$string['secondstotime345600'] = '4 giorni';
$string['secondstotime432000'] = '5 giorni';
$string['secondstotime518400'] = '6 giorni';
$string['secondstotime604800'] = '1 settimana';
$string['secondstotime86400'] = '1 giorno';
$string['secretalreadyused'] = 'Link di conferma cambio password già utilizzato, la password non è stataodificata.';
$string['secs'] = 'secondi';
$string['section'] = 'Sezione';
$string['sectionactionnotsupported'] = 'L\'azione sulla sezione "{$a}" qui non è supportata';
$string['sectionname'] = 'Nome sezione';
$string['sectionoutline'] = 'Schema della sezione';
$string['sections'] = 'Sezioni';
$string['seealsostats'] = 'Vedi anche: statistiche';
$string['selctauser'] = 'Scegli un utente';
$string['select'] = 'Seleziona';
$string['selectacategory'] = 'Per favore scegliere una categoria';
$string['selectacountry'] = 'Stato';
$string['selectacourse'] = 'Scegli un corso';
$string['selectacoursesite'] = 'Scegli un corso o un sito';
$string['selectagroup'] = 'Scegli un gruppo';
$string['selectall'] = 'Seleziona tutto';
$string['selectallusersonpage'] = 'Seleziona tutti gli utenti visualizzati nella pagina';
$string['selectalluserswithcount'] = 'Seleziona tutti gli utenti ({$a})';
$string['selectamodule'] = 'Prego selezionare un modulo attività';
$string['selectanaction'] = 'Scegli un\'azione';
$string['selectanoptions'] = 'Scegli un\'opzione';
$string['selectaregion'] = 'Seleziona una regione';
$string['selectcategorysort'] = 'Quali categorie desideri riordinare?';
$string['selectcategorysortby'] = 'Scegli come vuoi riordinare le categorie';
$string['selectcoursesortby'] = 'Scegli come vuoi riordinare i corsi';
$string['selectdates'] = 'Seleziona date';
$string['selectdefault'] = 'Seleziona default';
$string['selectedcategories'] = 'Categorie selezionate';
$string['selectedfile'] = 'File selezionati';
$string['selectednowmove'] = 'Hai selezionato {$a} file da spostare. Ora vai alla cartella di destinazione e premi \'Sposta i file qui\'';
$string['selectfiles'] = 'Seleziona file';
$string['selectfiltertype'] = 'Seleziona';
$string['selectgroupsseparate'] = 'Seleziona gruppi separati';
$string['selectgroupsvisible'] = 'Seleziona gruppi visibili';
$string['selectitem'] = 'Seleziona \'{$a}\'';
$string['selectmoduletoviewhelp'] = 'Scegli una risorsa o un\'attività per visualizzare l\'help associato';
$string['selectnos'] = 'Seleziona tutti i \'no\'';
$string['selectperiod'] = 'Seleziona periodo';
$string['selecttheme'] = 'Selezione tema';
$string['selectthemename'] = 'Seleziona tema \'{$a}\'';
$string['senddetails'] = 'Invia i miei dati via email';
$string['sent'] = 'Inviato';
$string['separate'] = 'Separato';
$string['separateandconnected'] = 'Stile di apprendimento Separato e Collegato';
$string['separateandconnected1'] = 'Apprendimento prevalentemente separato';
$string['separateandconnected2'] = 'Apprendimento sia separato sia collegato';
$string['separateandconnected3'] = 'Apprendimento prevalentemente collegato';
$string['separateandconnectedinfo'] = 'Scala basata sulla teoria della conoscenza isolata e della conoscenza collegata. La teoria descrive due modi differenti con i quali possiamo valutare e imparare le cose che vediamo e che sentiamo.<ul>
<li>Il <strong>Conoscitore isolato</strong> preferisce rimanere il più obiettivo possibile senza tener conto dei propri sentimenti e delle proprie emozioni. Durante una discussione con persone che hanno idee diverse, gli piace difendere le proprie, usando la logica per trovare difetti nelle idee altrui.
<li>Il <strong>Conoscitore collegato</strong> è più disponibile verso le altre persone. È in grado di comunicare meglio e tende ad ascoltare e porre domande finché entra in sintonia e  "capisce le cose dal punto di vista degli altri". Impara cercando di condividere le esperienze che hanno portato alla conoscenza che ha trovato negli altri.</li></ul>';
$string['servererror'] = 'Si è verificato un errore durante la comunicazione con il server';
$string['serverlocaltime'] = 'Ora locale del server';
$string['sessionforceclean'] = 'Per motivi di sicurezza, in questa sessione gli script generati dall\'utente sono stati disabilitati.';
$string['sessiontimeoutsoon'] = 'La sessione sta per scadere. Desideri prolungarla?';
$string['setcategorytheme'] = 'Imposta tema di categoria';
$string['setmode'] = 'Imposta modalità';
$string['setpassword'] = 'Imposta password';
$string['setpasswordinstructions'] = 'Per favore inserisci sotto la nuova password e poi salva.';
$string['settings'] = 'Impostazioni';
$string['share'] = 'Condividi';
$string['shortname'] = 'Nome abbreviato';
$string['shortnamecollisionwarning'] = '[*] = Questo Titolo abbreviato è già utilizzato da un corso e sarà necessario modificarlo all\'approvazione';
$string['shortnamecourse'] = 'Titolo abbreviato';
$string['shortnamecourse_help'] = 'Il nome visualizzato in aree con spazio ridotto. Deve essere univoco.';
$string['shortnametaken'] = 'Titolo abbreviato già in uso in un altro corso ({$a})';
$string['shortnameuser'] = 'Nome utente abbreviato';
$string['shortsitename'] = 'Nome abbreviato del sito (es. singola parola)';
$string['show'] = 'Visualizza';
$string['showactions'] = 'Visualizza azioni';
$string['showactivitydates'] = 'Visualizza date dell\'attività';
$string['showactivitydates_help'] = 'Visualizza le date delle attività nella pagina home del corso.';
$string['showadvancededitor'] = 'Avanzata';
$string['showadvancedsettings'] = 'Visualizza impostazioni avanzate';
$string['showall'] = 'Visualizza tutti i {$a}';
$string['showallcourses'] = 'Visualizza tutti i corsi';
$string['showblockcourse'] = 'Visualizza l\'elenco dei corsi che contengono blocchi';
$string['showcategory'] = 'Visualizza {$a}';
$string['showchartdata'] = 'Visualizza i dati del grafico';
$string['showcomments'] = 'Visualizza/nascondi i commenti';
$string['showcommentsnonjs'] = 'Visualizza commenti';
$string['showdescription'] = 'Visualizza descrizione nella home del corso';
$string['showdescription_help'] = 'Consente di visualizzare la descrizione soprastante nella pagina home del corso, subito sotto il link della risorsa o dell\'attività.';
$string['showgrades'] = 'Visualizza valutazioni agli studenti';
$string['showgrades_help'] = 'Gli studenti potranno visualizzare le valutazioni ricevute nel corso.';
$string['showingacourses'] = 'Sono visualizzati tutti i {$a} corsi.';
$string['showingxofycourses'] = 'Sono visualizzati i corsi da  {$a->start} a {$a->end} su {$a->total}';
$string['showless'] = 'Visualizza di meno';
$string['showlistofcourses'] = 'Visualizza l\'elenco dei corsi';
$string['showmodulecourse'] = 'Visualizza l\'elenco dei corsi che contengono attività';
$string['showmore'] = 'Visualizza di più';
$string['showoncoursepage'] = 'Visualizza nella pagina home del corso';
$string['showonly'] = 'Visualizza solo';
$string['showperpage'] = 'Visualizza {$a} per pagina';
$string['showpopoverwindow'] = 'Visualizza finestra popover';
$string['showrecent'] = 'Visualizza le attività recenti';
$string['showreports'] = 'Visualizza i report delle attività';
$string['showreports_help'] = 'Gli studenti potranno visualizzare il proprio report delle attività tramite la pagina del profilo utente.';
$string['showsettings'] = 'Visualizza impostazioni';
$string['showtheselogs'] = 'Visualizza i log';
$string['showthishelpinlanguage'] = 'Visualizza l\'help nella lingua: {$a}';
$string['sidepanel'] = 'Pannello laterale';
$string['signoutofotherservices'] = 'Logout da tutte le app web';
$string['signoutofotherservices_help'] = 'L\'account sarà disconnesso da tutti i dispositivi e sistemi che usano i web service, ad esempio l\'app mobile. La sessione browser rimarrà attiva.';
$string['since'] = 'Dal';
$string['sincelast'] = 'dal login più recente';
$string['site'] = 'Sito';
$string['sitedefault'] = 'Default del sito';
$string['sitedefaultspecified'] = 'Default del sito ({$a})';
$string['siteerrors'] = 'Errori sito';
$string['sitefiles'] = 'File del sito';
$string['sitefilesused'] = 'File del sito usati in questo corso';
$string['sitehome'] = 'Home del sito';
$string['sitelegacyfiles'] = 'File legacy del sito ';
$string['sitelogs'] = 'Log del sito';
$string['sitenews'] = 'Annunci del sito';
$string['sitepages'] = 'Pagine del sito';
$string['sitepartlist'] = 'Non hai il privilegio per vedere l\'elenco dei partecipanti';
$string['sitepartlist0'] = 'Bisogna essere il docente del sito per poter vedere l\'elenco dei partecipanti al corso di sito';
$string['sitepartlist1'] = 'Bisogna essere un docente per poter vedere l\'elenco dei partecipanti al corso di sito';
$string['sites'] = 'Siti';
$string['sitesection'] = 'Aggiungi contenuto personalizzato';
$string['sitesettings'] = 'Impostazioni sito';
$string['siteteachers'] = 'Docenti del sito';
$string['size'] = 'Dimensione';
$string['sizeb'] = 'bytes';
$string['sizegb'] = 'GB';
$string['sizekb'] = 'KB';
$string['sizemb'] = 'MB';
$string['sizepb'] = 'PB';
$string['sizetb'] = 'TB';
$string['skipped'] = 'Saltato';
$string['skiptocategorylisting'] = 'Vai all\'elenco delle categorie';
$string['skiptocoursedetails'] = 'Vai alle informazioni di dettaglio del corso';
$string['skiptocourselisting'] = 'Vai all\'elenco dei corsi';
$string['someallowguest'] = 'Alcuni corsi possono consentire l\'accesso agli ospiti';
$string['someerrorswerefound'] = 'Qualche informazione è mancante o errata. Vedi sotto per i dettagli.';
$string['sort'] = 'Ordina';
$string['sortby'] = 'Ordina per';
$string['sortbyx'] = 'Ordinamento crescente per {$a}';
$string['sortbyxreverse'] = 'Ordinamento decrescente per {$a}';
$string['sorting'] = 'Ordinamento';
$string['sourcerole'] = 'Ruolo sorgente';
$string['specifyname'] = 'Devi specificare un nome.';
$string['standard'] = 'Standard';
$string['starpending'] = '([*] = corso in attesa di approvazione)';
$string['startdate'] = 'Data di inizio del corso';
$string['startdate_help'] = 'Questa data determina l\'inizio della prima settimana per un corso in formato settimanale. È anche la data di inizio dei log delle attività del corso.

Se si reimposta il corso e si cambia questa data, tutte le date del corso verranno spostate rispetto alla nuova data di inizio.';
$string['startdatewithtaskenabled'] = 'Data di inizio del corso';
$string['startdatewithtaskenabled_help'] = 'Data in cui il corso diventerà visibile agli studenti. Prima di questa data gli studenti non potranno accedere al corso.

Questa data determina anche l\'inizio della prima settimana di un corso nel formato settimanale ed è la data di inizio dei log delle attività del corso. Effettuando il reset del corso e cambiando questa data, tutte le date del del corso saranno spostate in relazione alla nuova data di inizio.';
$string['startingfrom'] = 'Inizio da';
$string['startsignup'] = 'Crea un account';
$string['state'] = 'Stato/Provincia';
$string['statistics'] = 'Statistiche';
$string['statisticsgraph'] = 'Grafico statistiche';
$string['stats'] = 'Statistiche';
$string['statslogins'] = 'Login';
$string['statsmodedetailed'] = 'Vista dettagliata (utente)';
$string['statsmodegeneral'] = 'Vista generale';
$string['statsnodata'] = 'Non ci sono dati disponibili per quella combinazione di corso e periodo di tempo.';
$string['statsnodatauser'] = 'Non ci sono dati disponibili per quella combinazione di corso, utente e periodo di tempo.';
$string['statsoff'] = 'Le statistiche non sono abilitate';
$string['statsreads'] = 'Letture';
$string['statsreport1'] = 'Login';
$string['statsreport10'] = 'Attività utente';
$string['statsreport11'] = 'Corsi più attivi';
$string['statsreport12'] = 'Corsi più attivi (pesato)';
$string['statsreport13'] = 'Corsi con maggiore partecipazione (iscrizioni)';
$string['statsreport14'] = 'Corsi con maggiore partecipazione (interventi/visualizzazioni)';
$string['statsreport2'] = 'Letture (tutti i ruoli)';
$string['statsreport3'] = 'Interventi (tutti i ruoli)';
$string['statsreport4'] = 'Tutta l\'attività (tutti i ruoli)';
$string['statsreport5'] = 'Tutta l\'attività (letture e interventi)';
$string['statsreport7'] = 'Attività utenti (letture e interventi)';
$string['statsreport8'] = 'Attività di tutti gli utenti';
$string['statsreport9'] = 'Login (sito)';
$string['statsreportactivity'] = 'Tutta l\'attività (tutti i ruoli)';
$string['statsreportactivitybyrole'] = 'Tutta l\'attività (letture e interventi)';
$string['statsreportforuser'] = 'per';
$string['statsreportlogins'] = 'Accessi';
$string['statsreportreads'] = 'Letture (tutti i ruoli)';
$string['statsreporttype'] = 'Tipo di report';
$string['statsreportwrites'] = 'Interventi (tutti i ruoli)';
$string['statsstudentactivity'] = 'Attività studente';
$string['statsstudentreads'] = 'Letture studente';
$string['statsstudentwrites'] = 'Interventi studente';
$string['statsteacheractivity'] = 'Attività docente';
$string['statsteacherreads'] = 'Letture docente';
$string['statsteacherwrites'] = 'Interventi docente';
$string['statstimeperiod'] = 'Periodo di tempo - ultimo:';
$string['statsuniquelogins'] = 'Login unici';
$string['statsuseractivity'] = 'Tutta l\'attività';
$string['statsuserlogins'] = 'Login';
$string['statsuserreads'] = 'Letture';
$string['statsuserwrites'] = 'Interventi';
$string['statswrites'] = 'Interventi';
$string['status'] = 'Stato';
$string['statuschecks'] = 'Verifiche di stato';
$string['statuscritical'] = 'Critico';
$string['statusdone'] = 'Fatto';
$string['statuserror'] = 'Errore';
$string['statusinfo'] = 'Informazione';
$string['statusna'] = 'N/D';
$string['statusok'] = 'OK';
$string['statusunknown'] = 'Sconosciuto';
$string['statuswarning'] = 'Avviso';
$string['stringsnotset'] = 'Le seguenti stringhe non sono definite in {$a}';
$string['studentnotallowed'] = 'Spiacenti, ma non puoi accedere a questo corso come \'{$a}\'';
$string['students'] = 'Studenti';
$string['studentsandteachers'] = 'Studenti e docenti';
$string['subcategories'] = 'Sotto categorie';
$string['subcategory'] = 'Sottocategoria';
$string['subcategoryof'] = 'Sottocategoria di {$a}';
$string['subject'] = 'Oggetto';
$string['submit'] = 'Invia';
$string['subsectionmoveerror'] = 'Non è possibile spostare questa sottosezione su un\'altra sottosezione';
$string['success'] = 'Operazione eseguita correttamente';
$string['successduration'] = 'Operazione completata correttamente ({$a} secondi)';
$string['summary'] = 'Introduzione';
$string['suspended'] = 'Sospeso';
$string['suspendedusers'] = 'Utente sospeso';
$string['switchdevicedefault'] = 'Passa al tema standard';
$string['switchdevicerecommended'] = 'Passa al tema consigliato per il tuo dispositivo';
$string['switchrolereturn'] = 'Ritorna al mio ruolo normale';
$string['switchroleto'] = 'Cambia ruolo in ...';
$string['switchroleto_help'] = 'Seleziona un ruolo per avere un\'idea di come visualizzeranno il corso gli utenti che hanno quel ruolo.

Da notare che la visualizzazione non sarà del tutto fedele.  (<a href="https://docs.moodle.org/en/Switch_roles">Maggiori dettagli e alternative</a>).';
$string['tag'] = 'Tag';
$string['tagalready'] = 'Questa tag già esiste';
$string['tagmanagement'] = 'Gestione tag';
$string['tags'] = 'Tag';
$string['targetrole'] = 'Ruolo finale';
$string['teacheronly'] = 'solo per {$a}';
$string['teacherroles'] = '{$a} ruoli';
$string['teachers'] = 'Docenti';
$string['textcopiedtoclipboard'] = 'Testo copiato negli appunti';
$string['textediting'] = 'Editor di testo';
$string['textediting_help'] = 'Selezionando un editor HTML come Atto o TinyMCE, le aree di testo presenteranno una barra degli strumenti con pulsanti che facilitano l\'inserimento di contenuti.

Selezionando \'testo semplice\'. sarà possibile scegliere la formattazione del testo inserito, ad esempio HTML o Markdown.

L\'elenco degli editor di testo disponibili può essere configurato dall\'amministratore del sito.';
$string['texteditor'] = 'Usa i forms web standard';
$string['textellipsis'] = '{$a}...';
$string['textformat'] = 'Formato testo';
$string['thanks'] = 'Grazie';
$string['theme'] = 'Tema';
$string['themepreviewdescription'] = 'Descrizione tema {$a}';
$string['themepreviewimage'] = 'Anteprima immagine {$a}';
$string['themes'] = 'Temi';
$string['themesaved'] = 'Nuovo tema salvato';
$string['therearecourses'] = 'Sono presenti {$a} corsi';
$string['thereareno'] = 'Non ci sono {$a} in questo corso';
$string['thiscategory'] = 'Questa categoria';
$string['thiscategorycontains'] = 'Questa categoria contiene';
$string['time'] = 'Data/Ora';
$string['timecreated'] = 'Data di creazione';
$string['timecreatedcourse'] = 'Data creazione corso';
$string['timesplitting:deciles'] = 'Ultimo decimo';
$string['timesplitting:deciles_help'] = 'L\'intervallo di analisi divide la durata del corso in decimi (10 parti uguali), con ogni pronostico basato sui dati di tutti i decimi precedenti.';
$string['timesplitting:decilesaccum'] = 'Tutti i decimi precedenti';
$string['timesplitting:decilesaccum_help'] = 'L\'intervallo di analisi divide la durata del corso in decimi (10 parti uguali), con ogni pronostico basato sui dati di tutti i decimi precedenti.';
$string['timesplitting:nosplitting'] = 'Senza intervallo';
$string['timesplitting:nosplitting_help'] = 'Il modello non ha nessun intervallo di analisi.';
$string['timesplitting:onemonthafterstart'] = 'Un mese dopo l\'inizio';
$string['timesplitting:onemonthafterstart_help'] = 'L\'intervallo di analisi genererà un pronostico 1 mese dopo l\'inizio.';
$string['timesplitting:oneweekafterstart'] = 'Una settimana dopo l\'inizio';
$string['timesplitting:oneweekafterstart_help'] = 'L\'intervallo di analisi genererà un pronostico 1 settimana dopo l\'inizio.';
$string['timesplitting:past3days'] = 'I tre giorni scorsi';
$string['timesplitting:past3days_help'] = 'L\'intervallo di analisi genererà un pronostico ogni 3 giorni. Il calcolo degli indicatori sarà basato sui tre giorni scorsi.';
$string['timesplitting:pastmonth'] = 'Mese scorso';
$string['timesplitting:pastmonth_help'] = 'L\'intervallo di analisi genererà un pronostico ogni mese. Il calcolo degli indicatori sarà basato sul mese scorso.';
$string['timesplitting:pastweek'] = 'Settimana scorsa';
$string['timesplitting:pastweek_help'] = 'L\'intervallo di analisi genererà un pronostico ogni settimana. Il calcolo degli indicatori sarà basato sula settimana scorsa.';
$string['timesplitting:quarters'] = 'Ultimo trimestre';
$string['timesplitting:quarters_help'] = 'L\'intervallo di analisi divide il corso in trimestri (4 parti uguali); ciascun pronostico è formulato in base ai dati del solo trimestre precedente.';
$string['timesplitting:quartersaccum'] = 'Tutti i trimestri precedenti';
$string['timesplitting:quartersaccum_help'] = 'L\'intervallo di analisi divide il corso in trimestri (4 parti uguali); ciascun pronostico è formulato in base ai dati di tutti i trimestri precedenti.';
$string['timesplitting:singlerange'] = 'Dall\'inizio alla fine';
$string['timesplitting:singlerange_help'] = 'L\'intervallo di analisi non divide la durata del corso.';
$string['timesplitting:tenpercentafterstart'] = '10% dopo l\'inizio';
$string['timesplitting:tenpercentafterstart_help'] = 'L\'intervallo di analisi genererà un pronostico dopo il completamento del 10% del corso.';
$string['timesplitting:upcoming3days'] = 'Prossimi 3 giorni';
$string['timesplitting:upcoming3days_help'] = 'L\'intervallo di analisi genererà pronostici ogni tre giorni. Il calcolo degli indicatori sarà basato sui prossimi tre giorni.';
$string['timesplitting:upcomingfortnight'] = 'Prossime due settimae';
$string['timesplitting:upcomingfortnight_help'] = 'L\'intervallo di analisi genererà pronostici ogni due settimane. Il calcolo degli indicatori sarà basato sulle due settimane entranti.';
$string['timesplitting:upcomingweek'] = 'Prossima settimana';
$string['timesplitting:upcomingweek_help'] = 'L\'intervallo di analisi genererà pronostici ogni settimana. Il calcolo degli indicatori sarà basato sulla settimana entrante.';
$string['timezone'] = 'Fuso orario';
$string['tocontent'] = 'All\'elemento "{$a}"';
$string['tocreatenewaccount'] = 'Vai a creazione account';
$string['todate'] = 'A';
$string['today'] = 'Oggi';
$string['todaylogs'] = 'Log di oggi';
$string['toeveryone'] = 'per tutti';
$string['toggleemojipicker'] = 'Attiva/DIsattiva il selettore degli emoji';
$string['togglesearch'] = 'Attiva/disattiva input di ricerca';
$string['toomanybounces'] = 'Questo indirizzo di email ha subito troppi rimbalzi. <b>Devi cambiarlo</b> per poter continuare.';
$string['toomanytags'] = 'La ricerca ha trovato troppi tag: alcuni tag sono stati esclusi.';
$string['toomanytoshow'] = 'Ci sono troppi utenti da visualizzare';
$string['toomanyusersmatchsearch'] = 'Ci sono troppi utenti ({$a->count}) che corrispondono alla ricerca \'{$a->search}\'';
$string['toomanyuserstoshow'] = 'Ci sono troppi utenti ({$a}) da visualizzare';
$string['toonly'] = 'per {$a} solamente';
$string['top'] = 'Primo livello';
$string['topic'] = 'Argomento';
$string['toplevelcategory'] = 'Categoria di primo livello';
$string['torecipient'] = 'A';
$string['total'] = 'Totale';
$string['totopofsection'] = 'All\'inizio della sezione "{$a}"';
$string['trackforums'] = 'Evidenziazione messaggi forum';
$string['trackforumsno'] = 'No: non evidenziare i messaggi non letti';
$string['trackforumsyes'] = 'Si: evidenzia i messaggi non letti';
$string['trysearching'] = 'Prova a cercare.';
$string['turneditingoff'] = 'Termina modifica';
$string['turneditingon'] = 'Attiva modifica';
$string['unabletocopytoclipboard'] = 'Impossibile copiare il testo negli appunti';
$string['unauthorisedlogin'] = 'L\'account utente "{$a}" non è presente in questo sito';
$string['undecided'] = 'Indeciso';
$string['unexistingcmid'] = 'L\'ID del modulo del corso non è stato trovato';
$string['unexistingsectionid'] = 'L\'ID della sezione del corso non è stato trovato';
$string['unfinished'] = 'Non terminato';
$string['unknowncategory'] = 'Categoria sconosciuta';
$string['unknownerror'] = 'Errore sconosciuto';
$string['unknownuser'] = 'Utente sconosciuto';
$string['unlimited'] = 'Nessun limite';
$string['unpacking'] = 'Decompressione {$a}';
$string['unsafepassword'] = 'Password non sicura - utilizzane un\'altra';
$string['untilcomplete'] = 'Fino al completamento';
$string['unusedaccounts'] = 'Gli account inutilizzati per più di {$a} giorni saranno rimossi automaticamente dal corso.';
$string['unzip'] = 'Decomprimi';
$string['unzippingbackup'] = 'Decompressione backup';
$string['up'] = 'In alto';
$string['update'] = 'Aggiorna';
$string['updated'] = 'Aggiornato {$a}';
$string['updatemymoodleoff'] = 'Termina personalizzazione';
$string['updatemymoodleon'] = 'Personalizza questa pagina';
$string['updatemyprofile'] = 'Aggiornamento profilo';
$string['updatesevery'] = 'Aggiornamenti ogni {$a} secondi';
$string['updatethis'] = 'Aggiorna {$a}';
$string['updatethiscourse'] = 'Aggiorna questo corso';
$string['upload'] = 'Caricamento sul server';
$string['uploadafile'] = 'Carica un file sul server';
$string['uploadcantwrite'] = 'Scrittura del file su disco fallita';
$string['uploadedfile'] = 'File caricato correttamente';
$string['uploadedfileto'] = 'File {$a->file} salvato nella directory {$a->directory}';
$string['uploadedfiletoobig'] = 'Spiacente, ma questo file è troppo grande (il limite è {$a} byte)';
$string['uploadextension'] = 'Caricamento interrotto a causa di un\'estensione PHP';
$string['uploadfailednotrecovering'] = 'L\'invio del file è fallito perché c\'è stato un problema con uno dei file, {$a->name}.<br />Qui c\'è il log dei problemi:<br />{$a->problem}<br />Non recuperabile.';
$string['uploadfilelog'] = 'Caricamento del log per il file  {$a}';
$string['uploadformlimit'] = 'Il file caricato {$a}  supera la dimensione massima permessa';
$string['uploadlabel'] = 'Titolo:';
$string['uploadlimitwithsize'] = 'Limite di caricamento del {$a->contextname}: ({$a->displaysize})';
$string['uploadnewfile'] = 'Carica un file';
$string['uploadnofilefound'] = 'Non è stato trovato alcun file. Sei sicuro di averne selezionato uno per il caricamento?';
$string['uploadnotallowed'] = 'I caricamenti di file non sono consentiti';
$string['uploadnotempdir'] = 'Manca una cartella temporanea';
$string['uploadoldfilesdeleted'] = 'I vecchi file sul server sono stati eliminati';
$string['uploadpartialfile'] = 'Il file era stato inviato parzialmente';
$string['uploadproblem'] = 'Un problema sconosciuto si è verificato salvando il file \'{$a}\' (può essere troppo grande?)';
$string['uploadrenamedchars'] = 'Il file è stato rinominato da {$a->oldname} a {$a->newname} perché conteneva caratteri non validi.';
$string['uploadrenamedcollision'] = 'Il file è stato rinominato da {$a->oldname} a {$a->newname} perché il nome era in conflitto con un altro.';
$string['uploadserverlimit'] = 'La dimensione del file inviato eccede la dimensione massima impostata per il server';
$string['uploadthisfile'] = 'Trasferisci questo file';
$string['url'] = 'URL';
$string['used'] = 'In uso';
$string['usedinnplaces'] = 'Utilizzato in {$a} posti';
$string['user'] = 'Utente';
$string['useraccount'] = 'Account utente';
$string['useractivity'] = 'Attività';
$string['userconfirmed'] = 'Utente {$a} confermato';
$string['userdata'] = 'Dati utente';
$string['userdeleted'] = 'Questo account è stato eliminato';
$string['userdescription'] = 'Descrizione';
$string['userdescription_help'] = 'L\'area di testo ti consente di inserire delle informazioni personali visibili anche ad altri utenti tramite il tuo profilo';
$string['userdetails'] = 'Dettagli dell\'utente';
$string['userfiles'] = 'File utente';
$string['userlist'] = 'Elenco utenti';
$string['usermatchedon'] = 'Questo utente corrisponde alla ricerca tramite il campo seguente';
$string['usermenu'] = 'Menu utente';
$string['usermenugoback'] = 'Torna al menu utente';
$string['username'] = 'Username';
$string['usernameemail'] = 'Username o email';
$string['usernameemailmatch'] = 'Il nome utente e l\'indirizzo mail non appartengono allo stesso utente';
$string['usernameexists'] = 'Questo username è già esistente, sceglierne un altro';
$string['usernamelowercase'] = 'Sono consentite solo lettere minuscole';
$string['usernamenotfound'] = 'Lo username non è stato trovato nella base dati';
$string['usernameoremail'] = 'Inserisci username o indirizzo email';
$string['usernotconfirmed'] = 'Non è possibile confermare {$a}';
$string['userpic'] = 'Immagine utente';
$string['userpreferences'] = 'Preferenze utente';
$string['users'] = 'Utenti';
$string['userselectorautoselectunique'] = 'Se la ricerca trova un solo utente, selezionalo automaticamente';
$string['userselectorpreserveselected'] = 'Mantieni gli utenti selezionati, anche se non soddisfano più i criteri di ricerca';
$string['userselectorsearchanywhere'] = 'ovunque';
$string['userselectorsearchexactmatchonly'] = 'solo corrispondenze esatte';
$string['userselectorsearchfromstart'] = 'dall\'inizio';
$string['userselectorsearchmatching'] = 'Corrispondenza:';
$string['usersnew'] = 'Nuovi utenti';
$string['usersnoaccesssince'] = 'Utenti inattivi per più di';
$string['userswithfiles'] = 'Utenti con file';
$string['useruploadtype'] = 'Tipo caricamento utente: {$a}';
$string['userzones'] = 'Zone utenti';
$string['usetheme'] = 'Usa questo tema';
$string['usingexistingcourse'] = 'Utilizza un corso già esistente';
$string['validatehtml'] = 'Validazione HTML';
$string['valuealreadyused'] = 'Questo valore è stato già utilizzato';
$string['version'] = 'Versione';
$string['view'] = 'Visualizza';
$string['viewallcourses'] = 'Visualizza tutti i corsi';
$string['viewallcoursescategories'] = 'Visualizza tutti i corsi e le categorie';
$string['viewallresults'] = 'Visualizza tutti i risultati ({$a})';
$string['viewallsubcategories'] = 'Visualizza tutte le sotto categorie';
$string['viewfileinpopup'] = 'Visualizza il file in un finestra popup';
$string['viewing'] = 'Visualizzazione:';
$string['viewmore'] = 'Visualizza altro';
$string['viewprofile'] = 'Visualizza';
$string['views'] = 'Letture';
$string['viewsolution'] = 'visualizza soluzione';
$string['visible'] = 'Visibilità';
$string['visible_help'] = 'L\'impostazione determina la visibilità del corso nell\'elenco dei corsi. Gli amministratori ed i docenti potranno comunque accedervi, mentre gli altri utenti non potranno entrare nel corso.';
$string['visibletostudents'] = 'Visibile da {$a}';
$string['warning'] = 'Attenzione';
$string['warningdeleteresource'] = 'Attenzione: {$a} è collegato a una risorsa. Si vuole aggiornare la risorsa?';
$string['wcagcheck'] = 'Verifica Web Content Accessibility Guidelines (WCAG)';
$string['webpage'] = 'Pagina web';
$string['week'] = 'Settimana';
$string['weeks'] = 'settimane';
$string['welcomeback'] = 'Bentornato, {$a->firstname}! 👋';
$string['welcometocourse'] = 'Benvenuto(a) {$a}';
$string['welcometocoursetext'] = 'Benvenuto in {$a->coursename}!

Se non lo hai già fatto, dovresti modificare la pagina del tuo profilo personale in modo da consentirci di conoscerti meglio:

<a href="{$a->profileurl}">{$a->profileurl}<a>';
$string['welcometosite'] = 'Benvenuto, {$a->firstname}! 👋';
$string['whatforlink'] = 'Cosa fare del link';
$string['whatforpage'] = 'Cosa fare del testo';
$string['whatisyourage'] = 'Quanti anni hai?';
$string['whattocallzip'] = 'Come vuoi chiamare il file zip?';
$string['whattodo'] = 'Cosa fare';
$string['wheredoyoulive'] = 'In quale nazioni vivi?';
$string['whyisthisrequired'] = 'Perché viene richiesto?';
$string['windowclosing'] = 'Questa finestra dovrebbe chiudersi automaticamente. Se non si chiude, per favore chiudetela ora.';
$string['withchosenfiles'] = 'Con i files scelti';
$string['withdisablednote'] = '{$a} (disabilitato)';
$string['withoutuserdata'] = 'senza dati utente';
$string['withselectedusers'] = 'Con gli utenti selezionati...';
$string['withuserdata'] = 'con i dati utente';
$string['wontrunfuturescheduledtask'] = 'Non esecuzione di attività che non ha avuto esito negativo e che è pianificata per l\'esecuzione in futuro';
$string['wordforstudent'] = 'Come vuoi chiamare lo studente';
$string['wordforstudenteg'] = 'es. Studente, Partecipante etc';
$string['wordforstudents'] = 'Come vuoi chiamare gli studenti';
$string['wordforstudentseg'] = 'es. Studenti, Partecipanti etc';
$string['wordforteacher'] = 'Come vuoi chiamare il docente';
$string['wordforteachereg'] = 'es. Docente, Tutor, Facilitatore etc';
$string['wordforteachers'] = 'Come vuoi chiamare i docenti';
$string['wordforteacherseg'] = 'es. Docenti, Tutor, Facilitatori etc.';
$string['writingblogsinfo'] = 'Scrittura informazioni di blog';
$string['writingcategoriesandquestions'] = 'Scrittura categorie e domande';
$string['writingcoursedata'] = 'Scrittura dati corso';
$string['writingeventsinfo'] = 'Scrittura informazioni eventi';
$string['writinggeneralinfo'] = 'Scrittura informazioni generali';
$string['writinggradebookinfo'] = 'Scrittura informazioni sulle valutazioni';
$string['writinggroupingsgroupsinfo'] = 'Scrittura informazioni raggruppamenti-gruppi';
$string['writinggroupingsinfo'] = 'Scrittura informazioni raggruppamenti';
$string['writinggroupsinfo'] = 'Scrittura informazioni gruppi';
$string['writingheader'] = 'Scrittura intestazione';
$string['writingloginfo'] = 'Scrittura informazioni log';
$string['writingmessagesinfo'] = 'Scrittura messaggi';
$string['writingmoduleinfo'] = 'Scrittura informazioni moduli';
$string['writingscalesinfo'] = 'Scrittura informazioni scale';
$string['writinguserinfo'] = 'Scrittura informazioni utenti';
$string['wrongpassword'] = 'Password errata per questo username';
$string['year'] = 'anno';
$string['years'] = 'anni';
$string['yes'] = 'Sì';
$string['youareabouttocreatezip'] = 'Stai per creare un file compresso contenente';
$string['youaregoingtorestorefrom'] = 'Stai per ripristinare da:';
$string['youhaveupcomingactivitiesdue'] = 'Sono presenti attività da svolgere';
$string['youhaveupcomingactivitiesdueinfo'] = 'Gentile {$a},

<br/><br/>Sono presenti attività da svolgere:';
$string['youneedtoenrol'] = 'Per effettuare questa operazione bisogna essere iscritti a questo corso.';
$string['yourlastlogin'] = 'Il tuo login più recente è stato:';
$string['yourself'] = 'te stesso';
$string['yourteacher'] = 'il tuo {$a}';
$string['yourwordforx'] = 'Per il ruolo \'{$a}\' usa';
$string['zippingbackup'] = 'Compressione backup';
