<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'ratingallocate', language 'nl', version '5.0'.
 *
 * @package     ratingallocate
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['algorithm_already_running'] = 'Er draait al een instantie van het toewijzingsalgoritme. Wacht een paar minuten en ververs dan de pagina.';
$string['algorithm_now_scheduled_for_cron'] = 'Het toewijzingsalgoritme is nu ingepland om via een crontaak uit te voeren. Wacht een aantal minuten en ververs dan deze pagina.';
$string['algorithm_scheduled_for_cron'] = 'De uitvoering van het toewijzingsalgoritme is gepland voor onmiddellijke uitvoering via cron. Wacht een paar minuten en ververs dan de pagina.';
$string['algorithmforcebackground'] = 'Berekening afdwingen in op de achtergrond draaiende taak';
$string['algorithmtimeout'] = 'Timeout van algoritme';
$string['allocation_manual_explain_all'] = 'Selecteer een optie om aan een gebruiker toe te wijzen.';
$string['allocation_manual_explain_only_raters'] = 'Selecteer een optie om aan een gebruiker toe te wijzen.
Er worden alleen gebruikers getoond die ten minste een optie hebben beoordeeld en die nog niet zijn toegewezen.';
$string['allocation_notification_message'] = 'Met betrekking tot "{$a->ratingallocate}" ben je toegewezen aan de optie "{$a->choice} ({$a->explanation})".';
$string['allocation_notification_message_subject'] = 'Toewijzing gepubliceerd voor {$a}';
$string['allocation_statistics'] = 'Statistieken van toewijzing';
$string['allocation_statistics_description'] = 'Deze statistiek geeft een indruk van de algemene tevredenheid over de toewijzing.
De toewijzingen worden geteld volgens de beoordeling die de gebruiker aan iedere keuze heeft gegeven.
<ul>
<li>{$a->rated} van {$a->usersinchoice} gebruiker(s) hebben gestemd.</li>
<li>{$a->users} van {$a->total} gebruiker(s) hebben een optie beoordeeld met "{$a->rating}".</li>
<li>{$a->unassigned} gebruiker(s) konden nog niet aan een optie worden toegewezen.</li>
</ul>';
$string['allocation_statistics_description_no_alloc'] = 'Deze statistiek geeft een indruk van de algemene tevredenheid over de toewijzing.
De toewijzingen worden geteld volgens de beoordeling die de gebruiker aan iedere keuze heeft gegeven.
<ul>
<li>Op dit moment hebben {$a->notrated} gebruiker(s) nog geen beoordeling gegeven.</li>
<li>{$a->rated} gebruiker(s) hebben al gestemd.</li>
<li>Er zijn nog geen toewijzingen.</li>
</ul>';
$string['allocation_table_description'] = 'Deze statistiek geeft een overzicht van alle toewijzingen voor deze instantie.</br>
Alle gebruikers die hebben beoordeeld maar niet zijn toegewezen, staan vermeld onder \'Geen toewijzing\'.';
$string['allocations_table'] = 'Overzicht van toewijzingen';
$string['allocations_table_choice'] = 'Keuze';
$string['allocations_table_noallocation'] = 'Geen toewijzing';
$string['allocations_table_users'] = 'Gebruikers';
$string['at_least_one_rateable_choices_needed'] = 'Maak ten minste een te beoordelen keuze.';
$string['calendarstart'] = '{$a} gaat open';
$string['calendarstop'] = '{$a} sluit';
$string['choice_active'] = 'Keuze is actief';
$string['choice_active_help'] = 'Alleen actieve keuzes worden aan de gebruiker getoond. Inactieve keuzes worden niet getoond.';
$string['choice_added_notification'] = 'Keuze opgeslagen.';
$string['choice_deleted_notification'] = 'Keuze "{$a}" is verwijderd.';
$string['choice_deleted_notification_error'] = 'Te verwijderen keuze niet gevonden.';
$string['choice_explanation'] = 'Beschrijving (optioneel)';
$string['choice_groupselect'] = 'Groepen';
$string['choice_maxsize'] = 'Max. aantal deelnemers';
$string['choice_maxsize_display'] = 'Maximum aantal leerlingen';
$string['choice_navigation'] = 'Keuzes';
$string['choice_table_active'] = 'Actief';
$string['choice_table_explanation'] = 'Beschrijving';
$string['choice_table_maxsize'] = 'Max. grootte';
$string['choice_table_title'] = 'Titel';
$string['choice_table_tools'] = 'Bewerk';
$string['choice_table_usegroups'] = 'Groepen';
$string['choice_title'] = 'Titel';
$string['choice_title_help'] = 'Titel van de keuze. *Let op* alle actieve keuzes worden gerangschikt op titel getoond.';
$string['choice_usegroups'] = 'Beperk zichtbaarheid tot groepen';
$string['choicestatusheading'] = 'Status';
$string['closebeforeopen'] = 'De activiteit moet eindigen nadat die begonnen is.';
$string['completionallocation'] = 'Is toegewezen aan een keuze';
$string['completionallocation_desc'] = 'Wordt toegewezen';
$string['completionallocation_help'] = 'Om deze activiteit te voltooien moeten gebruikers toegewezen worden aan een keuze.';
$string['completionvote'] = 'Stemmen in de activiteit';
$string['completionvote_desc'] = 'Stemmen';
$string['completionvote_help'] = 'Om deze activiteit te voltooien moeten gebruikers een keuze insturen.';
$string['configalgorithmtimeout'] = 'De tijd in seconden waarna wordt aangenomen dat het algoritme is vastgelopen.
De draaiende uitvoering ervan wordt beëindigd en gemarkeerd als mislukt.';
$string['confirm_start_distribution'] = 'Wanneer je het algoritme uitvoert, worden alle bestaande toewijzingen verwijderd, als die er zijn. Weet je zeker dat je wilt doorgaan?';
$string['create_moodle_groups'] = 'Groepen aanmaken vanuit toewijzing';
$string['crontask'] = 'Automatische toewijzing voor Gebruikers toewijzen';
$string['csvempty'] = 'CSV-bestand is leeg.';
$string['csvupload'] = 'CSV uploaden';
$string['csvupload_explanation'] = 'Upload keuzes in bulk met een CSV-bestand';
$string['csvupload_further_problems'] = '{$a} verdere problemen gevonden maar niet weergegeven.';
$string['csvupload_live_problems'] = 'Problemen gevonden in CSV import: {$a}';
$string['csvupload_live_success'] = 'CSV import succesvol: {$a->importcount} keuzes geïmporteerd.';
$string['csvupload_test_problems'] = 'Problemen gevonden bij het testen van de CSV import: {$a}';
$string['csvupload_test_success'] = 'Testen van CSV import succesvol: {$a->importcount} keuzes kunnen worden geïmporteerd.';
$string['csvupload_test_upload'] = 'Upload testen';
$string['csvupload_too_long_title'] = 'Te lange titel (> 255 tekens): {$a}';
$string['delete_all_ratings'] = 'Alle beoordelingen van leerlingen verwijderen';
$string['delete_choice'] = 'Keuze verwijderen';
$string['delete_rating'] = 'Beoordeling verwijderen';
$string['deletechoice'] = 'Keuze verwijderen';
$string['deleteconfirm'] = 'Weet je zeker dat je de keuze "{$a}" wilt verwijderen?';
$string['distribution_algorithm'] = 'Verdelingsalgoritme';
$string['distribution_published'] = 'Toewijzing is gepubliceerd';
$string['distribution_saved'] = 'Verdeling bewaard (in {$a}s).';
$string['distribution_table'] = 'Verdelingstabel';
$string['download_problem_mps_format'] = 'Berekening downloaden (mps/txt)';
$string['edit_choice'] = 'Keuze bewerken';
$string['edit_rating'] = 'Beoordeling bewerken';
$string['err_maximum'] = 'De maximale waarde voor dit veld is {$a}.';
$string['err_minimum'] = 'De minimale waarde voor dit veld is {$a}.';
$string['err_positivnumber'] = 'Je moet hier een positief getal invullen.';
$string['err_required'] = 'Je moet een waarde voor dit veld invullen.';
$string['export_choice_alloc_suffix'] = '- Toewijzing';
$string['export_choice_text_suffix'] = '- Tekst';
$string['export_options'] = 'Opties voor exporteren';
$string['filter_hide_users_without_rating'] = 'Gebruikers zonder toewijzing verbergen';
$string['filter_show_alloc_necessary'] = 'Gebruikers met toewijzing verbergen';
$string['filtermanualtabledesc'] = 'Beschrijft de filters die worden toegepast op de tabel van het formulier voor manueel toewijzen.';
$string['filtertabledesc'] = 'Beschrijft de filters die worden toegepast op de toewijzingstabel.';
$string['groupingname'] = 'Aangemaakt vanuit Gebruikers toewijzen "{$a}"';
$string['invalid_dates'] = 'Data zijn ongeldig. De startdatum moet voor de einddatum liggen.';
$string['invalid_publishdate'] = 'Publicatiedatum is ongeldig. Publicatiedatum moet liggen na het einde van de beoordeling.';
$string['is_published'] = 'Gepubliceerd';
$string['last_algorithm_run_date'] = 'Algoritme laatst uitgevoerd op';
$string['last_algorithm_run_date_none'] = '-';
$string['last_algorithm_run_status'] = 'Status laatste uitvoering';
$string['last_algorithm_run_status_-1'] = 'Mislukt';
$string['last_algorithm_run_status_0'] = 'Niet begonnen';
$string['last_algorithm_run_status_1'] = 'Loopt';
$string['last_algorithm_run_status_2'] = 'Succesvol';
$string['log_allocation_published'] = 'Toewijzing gepubliceerd';
$string['log_allocation_published_description'] = 'De gebruiker met id "{$a->userid}" heeft de toewijzing gepubliceerd voor Gebruikers toewijzen met id "{$a->ratingallocateid}".';
$string['log_allocation_statistics_viewed'] = 'Toewijzingsstatistieken bekeken';
$string['log_allocation_statistics_viewed_description'] = 'De gebruiker met id "{$a->userid}" heeft  de toewijzingsstatistieken bekeken voor Gebruikers toewijzen met id "{$a->ratingallocateid}".';
$string['log_allocation_table_viewed'] = 'Toewijzingstabel bekeken';
$string['log_allocation_table_viewed_description'] = 'De gebruiker met id "{$a->userid}" heeft de toewijzingstabel bekeken voor Gebruikers toewijzen met id "{$a->ratingallocateid}".';
$string['log_distribution_triggered'] = 'Verdeling getriggerd';
$string['log_distribution_triggered_description'] = 'De gebruiker met id "{$a->userid}" heeft de verdeling getriggerd voor Gebruikers toewijzen met id "{$a->ratingallocateid}".';
$string['log_index_viewed'] = 'Gebruiker bekeek alle instanties van Fair Allocation';
$string['log_index_viewed_description'] = 'De gebruiker met id "{$a->userid}" heeft alle instanties in deze cursus bekeken van Gebruikers toewijzen.';
$string['log_manual_allocation_saved'] = 'Manuele toewijzing bewaard';
$string['log_manual_allocation_saved_description'] = 'De gebruiker met id "{$a->userid}" heeft een manuele toewijzing bewaard voor Gebruikers toewijzen met id "{$a->ratingallocateid}".';
$string['log_rating_deleted'] = 'Gebruikersbeoordeling verwijderd';
$string['log_rating_deleted_description'] = 'De gebruiker met id "{$a->userid}" heeft zijn/haar beoordeling verwijderd voor Gebruikers toewijzen met id "{$a->ratingallocateid}".';
$string['log_rating_saved'] = 'Gebruikersbeoordeling bewaard';
$string['log_rating_saved_description'] = 'De gebruiker met id "{$a->userid}" heeft zijn/haar beoordeling bewaard voor Gebruikers toewijzen met id "{$a->ratingallocateid}".';
$string['log_rating_viewed'] = 'Gebruikersbeoordeling bekeken';
$string['log_rating_viewed_description'] = 'De gebruiker met id "{$a->userid}" heeft zijn/haar beoordeling bekeken voor Gebruikers toewijzen met id "{$a->ratingallocateid}".';
$string['log_ratingallocate_viewed'] = 'Gebruikers toewijzen bekeken';
$string['log_ratingallocate_viewed_description'] = 'De gebruiker met id "{$a->userid}" heeft de Gebruikers toewijzen met id "{$a->ratingallocateid}" bekeken.';
$string['log_ratings_and_allocation_table_viewed'] = 'Beoordelingen en toewijzingstabel bekeken';
$string['log_ratings_and_allocation_table_viewed_description'] = 'De gebruiker met id "{$a->userid}" heeft de beoordelingen en toewijzingstabel bekeken voor de Gebruikers toewijzen met id "{$a->ratingallocateid}".';
$string['manual_allocation'] = 'Handmatig toewijzen';
$string['manual_allocation_form'] = 'Formulier handmatig toewijzen';
$string['manual_allocation_nothing_to_be_saved'] = 'Er was niets om op te slaan.';
$string['manual_allocation_saved'] = 'Je manuele toewijzing is bewaard.';
$string['messageprovider:allocation'] = 'Melding over gepubliceerde toewijzing';
$string['messageprovider:notifyalloc'] = 'Melding van optie toewijzing';
$string['modify_allocation_group'] = 'Toewijzing aanpassen';
$string['modify_allocation_group_desc_published'] = 'De toewijzingen zijn gepubliceerd.
Wijzig ze alleen met de grootste zorg.
Als je ze wijzigt, informeer de leerlingen hier dan handmatig over.';
$string['modify_allocation_group_desc_rating_in_progress'] = 'De beoordelingsfase loopt op dit moment. Je kunt het proces van toewijzen starten nadat de beoordelingsfase is geëindigd.';
$string['modify_allocation_group_desc_ready'] = 'De beoordelingsfase is geëindigd. Je kunt nu het algoritme uitvoeren voor automatische toewijzing.';
$string['modify_allocation_group_desc_ready_alloc_started'] = 'De beoordelingsfase is geëindigd. Sommige toewijzingen zijn al aangemaakt.
Wanneer je het algoritme opnieuw uitvoert, worden alle huidige toewijzingen verwijderd.
Je kunt de toewijzingen nu handmatig aanpassen of overgaan tot publicatie van de toewijzingen.';
$string['modify_allocation_group_desc_too_early'] = 'De beoordelingsfase is nog niet begonnen. Je kunt het proces van toewijzen pas starten nadat de beoordelingsfase is geëindigd.';
$string['modify_choices'] = 'Keuzes bewerken';
$string['modify_choices_explanation'] = 'Toont de lijst me alle keuzes. Hier kunnen keuzes worden verborgen, aangepast en verwijderd.';
$string['modify_choices_group'] = 'Keuzes';
$string['modify_choices_group_desc_published'] = 'De toewijzingen zijn gepubliceerd. Er wordt geadviseerd de keuzes niet meer aan te passen.';
$string['modify_choices_group_desc_rating_in_progress'] = 'Er wordt beoordeeld. Het wordt afgeraden de set beschikbare opties in deze stap te wijzigen.';
$string['modify_choices_group_desc_ready'] = 'De beoordelingsfase is geëindigd. Je kunt nu het aantal leerlingen per optie aanpassen of opties uitschakelen om de uitkomsten van de verdeling te beïnvloeden.';
$string['modify_choices_group_desc_ready_alloc_started'] = 'De beoordelingsfase is geëindigd. Je kunt nu het aantal leerlingen per optie aanpassen of opties uitschakelen om de uitkomsten van de verdeling te beïnvloeden.';
$string['modify_choices_group_desc_too_early'] = 'Hier kunnen de opties worden ingesteld die beschikbaar moeten zijn voor de leerlingen.';
$string['modulename'] = 'Gebruikers toewijzen';
$string['modulename_help'] = 'De activiteit Gebruikers toewijzen stelt je in staat opties de definiëren die je deelnemers kunnen beoordelen. De deelnemers kunnen dan automatisch over de beschikbare opties worden verdeeld volgens hun beoordelingen.';
$string['modulenameplural'] = 'Gebruikers toewijzen';
$string['moodlegroups_created'] = 'Overeenkomende groepen en groeperingen zijn in Moodle aangemaakt.';
$string['newchoice'] = 'Nieuwe keuze toevoegen';
$string['newchoicetitle'] = 'Nieuwe keuze {$a}';
$string['no_allocation_notification_message'] = 'Met betrekking tot "{$a->ratingallocate}" kon je niet worden toegewezen aan een optie.';
$string['no_choice_to_rate'] = 'Er zijn geen opties om te beoordelen!';
$string['no_id_or_m_error'] = 'Je moet een course_module ID of instance ID specificeren';
$string['no_rating_given'] = 'Niet beoordeeld';
$string['no_rating_possible'] = 'Het is op dit moment niet mogelijk te beoordelen!';
$string['no_user_to_allocate'] = 'Er is geen gebruiker om toe te wijzen';
$string['pluginadministration'] = 'Beheer Gebruikers toewijzen';
$string['pluginname'] = 'Gebruikers toewijzen';
$string['privacy:metadata:preference:flextable_filter'] = 'Bewaart de filters die zijn toegepast op de toewijzingstabel.';
$string['privacy:metadata:preference:flextable_manual_filter'] = 'Bewaart de filters die zijn toegepast op de tabel met manuele toewijzingen.';
$string['privacy:metadata:ratingallocate_allocations'] = 'Informatie over de aan een gebruiker toegewezen opties voor een instantie van de activiteit.';
$string['privacy:metadata:ratingallocate_allocations:choiceid'] = 'Het ID van de optie waaraan de gebruiker is toegewezen';
$string['privacy:metadata:ratingallocate_allocations:ratingallocateid'] = 'Het ID van de instantie van de activiteit waar deze toewijzing bij hoort';
$string['privacy:metadata:ratingallocate_allocations:userid'] = 'Het ID van de gebruiker die aan een optie is toegewezen';
$string['privacy:metadata:ratingallocate_ratings'] = 'Informatie over de beoordelingen van een gebruiker voor de gegeven opties';
$string['privacy:metadata:ratingallocate_ratings:choiceid'] = 'Het ID van de optie die de gebruiker heeft beoordeeld';
$string['privacy:metadata:ratingallocate_ratings:rating'] = 'De beoordeling die een gebruiker aan een optie heeft gegeven.';
$string['privacy:metadata:ratingallocate_ratings:userid'] = 'Het ID van de gebruiker die deze optie beoordeelt';
$string['publish_allocation'] = 'Toewijzing publiceren';
$string['publish_allocation_group'] = 'Toewijzing publiceren';
$string['publish_allocation_group_desc_published'] = 'De toewijzingen zijn al gepubliceerd.
Je kunt ervoor kiezen groepen binnen je cursus te maken voor alle toewijzingen.
Als dezelfde groepen al zijn aangemaakt door deze plugin, worden ze opgeschoond voordat ze opnieuw worden gevuld.';
$string['publish_allocation_group_desc_rating_in_progress'] = 'De beoordelingsfase is bezig. Wacht eerst tot de beoordelingsfase is geëindigd voor je begint toewijzingen aan te maken.';
$string['publish_allocation_group_desc_ready'] = 'Er zijn nog geen toewijzingen. Zie de sectie Toewijzing aanpassen.';
$string['publish_allocation_group_desc_ready_alloc_started'] = 'De toewijzingen kunnen nu worden gepubliceerd.
Na publicatie kunnen de toewijzingen niet meer worden gewijzigd.
Bekijk de huidige toewijzingen door op de link te klikken in de sectie Rapporten.
Je kunt ervoor kiezen groepen binnen je cursus te maken voor alle toewijzingen.
Als dezelfde groepen al zijn aangemaakt door deze plugin, worden ze opgeschoond voordat ze opnieuw worden gevuld.
Dit kan worden gedaan voor- en nadat de toewijzingen zijn gepubliceerd.';
$string['publish_allocation_group_desc_too_early'] = 'De beoordelingsfase is nog niet begonnen. Wacht eerst tot de beoordelingsfase is geëindigd voor je begint toewijzingen aan te maken.';
$string['publishdate'] = 'Geschatte datum van publicatie';
$string['publishdate_estimated'] = 'Geschatte datum van publicatie';
$string['rateable_choices'] = 'Te beoordelen keuzes';
$string['rated'] = '{$a} beoordeeld';
$string['rating_begintime'] = 'Beoordelen begint op';
$string['rating_endtime'] = 'Beoordelen eindigt op';
$string['rating_is_over'] = 'Beoordelingsfase is voorbij.';
$string['rating_is_over_no_allocation'] = 'Beoordelingsfase is voorbij. Je kon niet worden toegewezen aan een keuze.';
$string['rating_is_over_with_allocation'] = 'Beoordelingsfase is voorbij. je bent toegewezen aan \'{$a}\'.';
$string['rating_raw'] = '{$a}';
$string['ratingallocate'] = 'Gebruikers toewijzen';
$string['ratingallocate:addinstance'] = 'Een nieuwe instantie van Gebruikers toewijzen toevoegen';
$string['ratingallocate:export_ratings'] = 'Mogelijkheid gebruikersbeoordelingen te exporteren';
$string['ratingallocate:give_rating'] = 'Keuze aanmaken of bewerken';
$string['ratingallocate:modify_choices'] = 'Mogelijkheid de keuzeset van een Gebruikers toewijzen aan te passen, te bewerken of verwijderen';
$string['ratingallocate:start_distribution'] = 'Toewijzing van gebruikers aan keuzes starten';
$string['ratingallocate:view'] = 'Instanties van Gebruikers toewijzen bekijken';
$string['ratingallocatename'] = 'Naam van deze Gebruikers toewijzen';
$string['ratingallocatename_help'] = 'Kies een naam voor deze activiteit Gebruikers toewijzen';
$string['ratings_deleted'] = 'Je beoordelingen zijn verwijderd.';
$string['ratings_saved'] = 'Je beoordelingen zijn bewaard.';
$string['ratings_table'] = 'Beoordelingen en toewijzingen';
$string['ratings_table_sum_allocations'] = 'Aantal toewijzingen / Maximum';
$string['ratings_table_sum_allocations_value'] = '{$a->sum} / {$a->max}';
$string['ratings_table_user'] = 'Gebruiker';
$string['reports_group'] = 'Rapporten';
$string['results_not_yet_published'] = 'Resultaten zijn nog niet gepubliceerd';
$string['runalgorithmbycron'] = 'Automatische toewijzing na beoordelingsfase';
$string['runalgorithmbycron_help'] = 'Voert het toewijzingsalgoritme automatisch uit nadat de beoordelingsperiode is geëindigd. De resultaten moeten echter handmatig worden gepubliceerd.';
$string['saveandcontinue'] = 'Bewaren en verder gaan';
$string['saveandnext'] = 'Bewaren en volgende toevoegen';
$string['select_strategy'] = 'Beoordelingsstrategie';
$string['select_strategy_help'] = 'Kies een beoordelingsstrategie:

* **Aanvaarden-Afwijzen** De gebruiker kan bij iedere optie beslissen deze te aanvaarden of af te wijzen.
* **Aanvaarden-Neutraal-Afwijzen** De gebruiker kan bij iedere optie beslissen deze te aanvaarden, af te wijzen of er neutraal over te zijn.
* **Likert-schaal** De gebruiker kan opties beoordelen met een waarde binnen een gedefinieerd bereik. Het bereik kan individueel worden gedefinieerd (te beginnen bij 0). Een hoge waarde staat voor een grote voorkeur.
* **Punten geven** De gebruiker kan opties beoordelen door er een aantal punten voor te geven. Het maximum aantal punten kan individueel worden gedefinieerd. Een hoog aantal punten staat voor een grote voorkeur.
* **Keuzes rangschikken** De gebruiker rangschikt de beschikbare opties. Hoeveel opties er moeten worden gerangschikt, kan individueel worden gedefinieerd.
* **Aanvaarden aanvinken** De gebruiker kan voor iedere optie aangeven of deze aanvaardbaar is voor hem/haar.';
$string['show_allocation_statistics'] = 'Statistieken van toewijzing tonen';
$string['show_allocation_table'] = 'Overzicht van toewijzingen tonen';
$string['show_choices_header'] = 'Lijst van alle keuzes';
$string['show_table'] = 'Beoordelingen en toewijzingen tonen';
$string['start_distribution'] = 'Algoritme van toewijzen uitvoeren';
$string['start_distribution_explanation'] = 'Een algoritme zal automatisch proberen gebruikers eerlijk toe te wijzen op basis van hun beoordelingen.';
$string['strategy_lickert_max_no'] = 'Je mag slechts 0 punten toekennen aan hoogstens {$a} optie(s).';
$string['strategy_lickert_name'] = 'Likert-schaal';
$string['strategy_lickert_rating_biggestwish'] = '{$a} - Zeer gewaardeerd';
$string['strategy_lickert_rating_exclude'] = '{$a} - Uitsluiten';
$string['strategy_lickert_setting_maxlickert'] = 'Hoogste waarde in de Likert-schaal (3, 5 of 7 zijn gebruikelijke waardes)';
$string['strategy_lickert_setting_maxno'] = 'Maximum aantal opties dat de gebruiker met 0 mag beoordelen';
$string['strategy_not_specified'] = 'Kies een strategie.';
$string['strategy_order_choice_none'] = 'Maak een keuze';
$string['strategy_order_explain_choices'] = 'Selecteer een optie per selectie-box. De eerste optie krijgt de hoogste prioriteit, enzovoort.';
$string['strategy_order_header_description'] = 'Beschikbare opties';
$string['strategy_order_name'] = 'Opties rangschikken';
$string['strategy_order_no_choice'] = '{$a}. Optie';
$string['strategy_order_setting_countoptions'] = 'Minimum aantal velden waarop de gebruiker moet stemmen (kleiner of gelijk aan het aantal opties!)';
$string['strategy_order_use_only_once'] = 'Opties kunnen niet tweemaal worden geselecteerd en moeten uniek zijn.';
$string['strategy_points_explain_distribute_points'] = 'Geef punten aan iedere optie. Je hebt totaal {$a} punten op te verdelen. Geef het hoogste aantal punten aan de beste optie.';
$string['strategy_points_explain_max_zero'] = 'Je mag slechts 0 punten toekennen aan hoogstens {$a} optie(s).';
$string['strategy_points_illegal_entry'] = 'De punten die je toekent aan een optie moeten tussen 0 en {$a} zijn.';
$string['strategy_points_incorrect_totalpoints'] = 'Onjuist aantal punten. De som van alle punten moet {$a} zijn.';
$string['strategy_points_max_count_zero'] = 'Je mag 0 punten geven aan hoogstens {$a} optie(s).';
$string['strategy_points_name'] = 'Punten geven';
$string['strategy_points_setting_maxzero'] = 'Maximum aantal opties waaraan de gebruiker 0 punten mag toekennen';
$string['strategy_points_setting_totalpoints'] = 'Totaal aantal punten dat de gebruiker kan toewijzen';
$string['strategy_settings_default'] = 'Standaardwaarde voor beoordelingsformulier';
$string['strategy_settings_default_help'] = 'Het beoordelingsformulier voor gebruikers bestaat uit een aantal selectierondjes voor iedere beschikbare optie.';
$string['strategy_settings_label'] = 'Benaming voor "{$a}"';
$string['strategy_tickyes_accept'] = 'Aanvaarden';
$string['strategy_tickyes_error_mintickyes'] = 'Je moet ten minste {$a} keuzes aanvinken.';
$string['strategy_tickyes_explain_mintickyes'] = 'Je moet ten minste {$a} keuzes aanvinken.';
$string['strategy_tickyes_name'] = 'Aanvaarden aanvinken';
$string['strategy_tickyes_not_accept'] = '-';
$string['strategy_tickyes_setting_mintickyes'] = 'Minimum aantal opties om te aanvaarden';
$string['strategy_yesmaybeno_max_count_no'] = 'Je mag "Afwijzen" maar toewijzen aan hoogstens {$a} optie(s).';
$string['strategy_yesmaybeno_max_no'] = 'Je mag "Afwijzen" maar toewijzen aan {$a} optie(s).';
$string['strategy_yesmaybeno_name'] = 'Aanvaarden-Neutraal-Afwijzen';
$string['strategy_yesmaybeno_rating_maybe'] = 'Neutraal';
$string['strategy_yesmaybeno_rating_no'] = 'Afwijzen';
$string['strategy_yesmaybeno_rating_yes'] = 'Aanvaarden';
$string['strategy_yesmaybeno_setting_maxno'] = 'Maximum aantal keuzes dat gebruiker kan beoordelen met "Afwijzen"';
$string['strategy_yesno_max_no'] = 'Je mag slechts "{$a}" keuze(s) beoordelen met "Afwijzen".';
$string['strategy_yesno_maximum_crossout'] = 'Je mag hoogstens "{$a}" keuze(s) beoordelen met "Afwijzen".';
$string['strategy_yesno_name'] = 'Aanvaarden-Afwijzen';
$string['strategy_yesno_rating_choose'] = 'Aanvaarden';
$string['strategy_yesno_rating_crossout'] = 'Afwijzen';
$string['strategy_yesno_setting_crossout'] = 'Maximaal aantal keuzes dat de gebruiker mag beoordelen met "Afwijzen"';
$string['strategyname'] = 'Strategie is "{$a}"';
$string['strategyspecificoptions'] = 'Specifieke opties strategie';
$string['timeremaining'] = 'Resterende tijd';
$string['title_too_long_error'] = 'De titel van de keuze bestaat uit teveel tekens, er zijn er maximaal 255 toegestaan.';
$string['too_early_to_distribute'] = 'Te vroeg om te verdelen. Beoordelingsfase is nog niet voorbij.';
$string['too_early_to_rate'] = 'Het is te vroeg om te beoordelen.';
$string['too_few_choices_to_rate'] = 'Er zijn te weinig keuzes om te beoordelen! Leerlingen moeten ten minste {4a} keuzes rangschikken!';
$string['unassigned_users'] = 'NIet toegewezen gebruikers';
$string['update_filter'] = 'Filter bijwerken';
$string['upload_choices'] = 'Keuzes uploaden via CSV';
$string['upload_choices_required_fields'] = 'Vereiste velden';
$string['userid'] = 'User ID';
$string['you_are_not_allocated'] = 'Je bent niet aan een keuze toegewezen!';
$string['your_allocated_choice'] = 'Je toewijzing';
$string['your_rating'] = 'Je beoordeling';
