<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_moodlemobileapp', language 'tr', version '5.0'.
 *
 * @package     local_moodlemobileapp
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addon.block_myoverview.browseallcourses'] = 'Tüm Kursları Görüntüle';
$string['addon.block_myoverview.nocoursesenrolled'] = 'Henüz herhangi bir derse kayıtlı değilsiniz';
$string['addon.block_myoverview.nocoursesenrolleddescription'] = 'Aşağıdaki mevcut tüm kurslara göz atın ve öğrenmeye başlayın.';
$string['addon.block_myoverview.noresult'] = 'Aramanız hiçbir ders ile eşleşmedi.';
$string['addon.block_myoverview.noresultdescription'] = 'Filtrelerinizi ayarlamayı deneyin veya aşağıdaki tüm derslere göz atın.';
$string['addon.blog.errorloadentries'] = 'Blog girişleri yüklenirken hata oluştu.';
$string['addon.blog.showonlyyourentries'] = 'Yalnızca kendi girişlerinizi gösterin';
$string['addon.calendar.calendarevent'] = 'Takvim etkinliği';
$string['addon.calendar.calendarevents'] = 'Takvim etkinlikleri';
$string['addon.calendar.calendarreminders'] = 'Takvim hatırlatıcıları';
$string['addon.calendar.currentmonth'] = 'İçinde bulunduğumuz ay';
$string['addon.calendar.defaultnotificationtime'] = 'Varsayılan bildirim süresi';
$string['addon.calendar.errorloadevent'] = 'Etkinlik yüklenirken hata oluştu.';
$string['addon.calendar.errorloadevents'] = 'Olaylar yüklenirken hata oluştu.';
$string['addon.calendar.monthlyview'] = 'Aylık görünüm';
$string['addon.calendar.noevents'] = 'Hiç bildiriminiz yok';
$string['addon.calendar.reminders'] = 'Hatırlatmalar';
$string['addon.calendar.setnewreminder'] = 'Yeni bir hatırlatıcı ayarla';
$string['addon.competency.errornocompetenciesfound'] = 'Yetkinlik bulunamdı';
$string['addon.competency.nocompetencies'] = 'Yetkinlik yok';
$string['addon.coursecompletion.complete'] = 'Tamamla';
$string['addon.coursecompletion.couldnotloadreport'] = 'Kurs tamamlama raporu yüklenemedi. Lütfen daha sonra tekrar deneyiniz.';
$string['addon.enrol_self.confirmselfenrol'] = 'Bu kursa kaydolmak istediğinizden emin misiniz?';
$string['addon.enrol_self.errorselfenrol'] = 'Kayıt sırasında bir hata oluştu';
$string['addon.messageoutput_airnotifier.processorsettingsdesc'] = 'Cihazları yapılandır';
$string['addon.messageoutput_airnotifier.pushdisabledwarning'] = 'Kullanıcılarınız mobil cihazlarına bu siteden herhangi bir bildirim almıyor. Bildirim ayarları sayfasında mobil bildirimleri etkinleştirin.';
$string['addon.messages.contactlistempty'] = 'Kişi listesi boş';
$string['addon.messages.contactname'] = 'Kişi adı';
$string['addon.messages.deletemessage'] = 'Mesajı sil';
$string['addon.messages.deletemessageconfirmation'] = 'Bu mesajı silmek istediğinizden emin misiniz? Yalnızca mesajlaşma geçmişinizden silinecek yine de mesajı gönderen veya alan kullanıcı tarafından görüntülenebilecektir.';
$string['addon.messages.errordeletemessage'] = 'Mesaj silinirken hata oluştu.';
$string['addon.messages.errorwhileretrievingcontacts'] = 'Sunucudan kişiler alınırken hata oluştu.';
$string['addon.messages.errorwhileretrievingdiscussions'] = 'Tartışmalar sunucudan alınırken hata oluştu.';
$string['addon.messages.errorwhileretrievingmessages'] = 'Sunucudan mesaj alınırken hata oluştu.';
$string['addon.messages.errorwhileretrievingusers'] = 'Sunucudan kullanıcılar alınırken hata oluştu.';
$string['addon.messages.messagenotsent'] = 'İleti gönderilemedi. Lütfen daha sonra tekrar deneyin.';
$string['addon.messages.newmessages'] = 'Yeni ileti';
$string['addon.messages.nousersfound'] = 'Kullanıcı bulunamadı';
$string['addon.messages.showdeletemessages'] = 'Silinmiş mesajları göster';
$string['addon.messages.type_blocked'] = 'Engellendi';
$string['addon.messages.type_offline'] = 'Çevrimdışı';
$string['addon.messages.type_online'] = 'Çevrimiçi';
$string['addon.messages.type_search'] = 'Arama sonuçları';
$string['addon.messages.type_strangers'] = 'Diğer';
$string['addon.messages.useentertosenddescdesktop'] = 'Devre dışı bırakılırsa, mesajı göndermek için Ctrl + Enter tuşlarını kullanabilirsiniz.';
$string['addon.messages.useentertosenddescmac'] = 'Devre dışı bırakılırsa, mesajı göndermek için Cmd + Enter tuşlarını kullanabilirsiniz.';
$string['addon.messages.warningconversationmessagenotsent'] = '{{conversation}} sohbetine mesaj gönderilemedi. {{error}}';
$string['addon.messages.warningmessagenotsent'] = '{{user}} kullanıcısına mesaj gönderilemedi. {{error}}';
$string['addon.mod_assign.acceptsubmissionstatement'] = 'Lütfen gönderim beyanını kabul edin.';
$string['addon.mod_assign.allowsubmissionsanddescriptionfromdatesummary'] = 'Ödev ayrıntılarına ve gönderim formuna <strong>{{$a}</strong> adresinden ulaşılabilir.';
$string['addon.mod_assign.allowsubmissionsfromdatesummary'] = 'Bu ödev <strong>{{$a}</strong>\'den gelen gönderimleri kabul edecek';
$string['addon.mod_assign.cannoteditduetostatementsubmission'] = 'Gönderme ifadesi siteden alınamadığı için uygulamada bir gönderi ekleyemez veya düzenleyemezsiniz.';
$string['addon.mod_assign.cannotgradefromapp'] = 'Bazı derecelendirme yöntemleri henüz uygulama tarafından desteklenmemektedir ve değiştirilemez.';
$string['addon.mod_assign.cannotsubmitduetostatementsubmission'] = 'Gönderme bildirimi siteden alınamadığı için uygulamada bir gönderim yapamazsınız.';
$string['addon.mod_assign.duedateno'] = 'Son tarih yok';
$string['addon.mod_assign.erroreditpluginsnotsupported'] = 'Belirli eklentiler henüz düzenleme için desteklenmediğinden uygulamada bir gönderi ekleyemez veya düzenleyemezsiniz.';
$string['addon.mod_assign.errorshowinginformation'] = 'Gönderim bilgileri görüntülenemez.';
$string['addon.mod_assign.feedbacknotsupported'] = 'Bu geri bildirim uygulama tarafından desteklenmemektedir ve tüm bilgileri içermeyebilir.';
$string['addon.mod_assign.gradenotsynced'] = 'Not senkronize edilmedi';
$string['addon.mod_assign.notallparticipantsareshown'] = 'Gönderi yapmayan katılımcılar gösterilmez.';
$string['addon.mod_assign.numberofdraftsubmissionscountdescription'] = '{{count}} taslak var.';
$string['addon.mod_assign.numberofparticipantscountdescription'] = '{{count}} katılımcı var.';
$string['addon.mod_assign.numberofsubmissionsneedgradingcountdescription'] = 'Not verilmesi gereken {{count}} gönderim var.';
$string['addon.mod_assign.numberofsubmittedassignmentscountdescription'] = 'Gönderilmiş {{count}} ödev var.';
$string['addon.mod_assign.numberofteamscountdescription'] = '{{count}} takım var.';
$string['addon.mod_assign.submissionnotsupported'] = 'Bu gönderim uygulama tarafından desteklenmemektedir ve tüm bilgileri içermeyebilir.';
$string['addon.mod_assign.syncblockedusercomponent'] = 'kullanıcı notu';
$string['addon.mod_assign.warningsubmissiongrademodified'] = 'Gönderme notu sitede değiştirildi.';
$string['addon.mod_assign.warningsubmissionmodified'] = 'Kullanıcı gönderimi sitede değiştirildi.';
$string['addon.mod_chat.confirmloss'] = 'Emin misin? Sohbet geçmişi kaybolabilir.';
$string['addon.mod_chat.errorwhileconnecting'] = 'Sohbete bağlanırken hata oluştu.';
$string['addon.mod_chat.errorwhilegettingchatdata'] = 'Sohbet verileri alınırken hata oluştu.';
$string['addon.mod_chat.errorwhilegettingchatusers'] = 'Sohbet kullanıcıları alınırken hata oluştu.';
$string['addon.mod_chat.errorwhileretrievingmessages'] = 'Sunucudan mesaj alınırken hata oluştu.';
$string['addon.mod_chat.errorwhilesendingmessage'] = 'Mesaj gönderilirken hata oluştu.';
$string['addon.mod_chat.mustbeonlinetosendmessages'] = 'Mesaj göndermek için çevrimiçi olmalısınız.';
$string['addon.mod_chat.nosessionsfound'] = 'Oturum bulunamadı';
$string['addon.mod_chat.showincompletesessions'] = 'Tamamlanmamış oturumları göster';
$string['addon.mod_choice.errorgetchoice'] = 'Seçim verileri alınırken hata oluştu.';
$string['addon.mod_choice.responsesresultgraphdescription'] = 'Kullanıcıların {{number}}%  kadarı şu seçeneği seçti: {{text}}.';
$string['addon.mod_choice.resultsnotsynced'] = 'Son yanıtınız sonuçlara eklenmeden önce senkronize edilmelidir.';
$string['addon.mod_data.edittagsnotsupported'] = 'Maalesef, etiketleri düzenlemek uygulama tarafından desteklenmiyor.';
$string['addon.mod_data.errorapproving'] = 'Girişi onaylama veya onaylamama hatası.';
$string['addon.mod_data.errordeleting'] = 'Giriş silinirken hata oluştu.';
$string['addon.mod_data.gettinglocation'] = 'Konum alma';
$string['addon.mod_data.locationnotenabled'] = 'Konum izni açık değil';
$string['addon.mod_data.locationpermissiondenied'] = 'Konumunuza erişim izni reddedildi.';
$string['addon.mod_data.mylocation'] = 'Benim konumum';
$string['addon.mod_data.searchbytagsnotsupported'] = 'Maalesef, etiketlere göre arama uygulama tarafından desteklenmiyor.';
$string['addon.mod_feedback.captchaofflinewarning'] = 'CAPTCHA ile geri bildirim çevrimdışı olarak veya yapılandırılmamışsa veya sunucu kapalıysa tamamlanamaz.';
$string['addon.mod_feedback.completedfeedbackscountdescription'] = 'Gönderilmiş {{count}} yanıt var.';
$string['addon.mod_feedback.feedback_submitted_offline'] = 'Bu geri bildirim daha sonra gönderilmek üzere kaydedildi.';
$string['addon.mod_feedback.questionscountdescription'] = '{{count}} adet soru var.';
$string['addon.mod_folder.emptyfilelist'] = 'Gösterilecek dosya yok';
$string['addon.mod_forum.errorgetforum'] = 'Forum verileri alınırken hata oluştu.';
$string['addon.mod_forum.errorgetgroups'] = 'Grup ayarları alınırken hata oluştu.';
$string['addon.mod_forum.errorloadingsortingorder'] = 'Forum bu sıralama düzeninde mevcut değil';
$string['addon.mod_forum.errorloadingsortingorderdetails'] = 'Sıralama düzenini değiştirmeyi veya bu forumu görüntülemek için çevrimiçi olmayı deneyin.';
$string['addon.mod_forum.errorposttoallgroups'] = 'Tüm gruplarda yeni tartışma oluşturulamadı.';
$string['addon.mod_forum.forumnodiscussionsyet'] = 'Bu forum da henuz hiç tartışma başlığı yok';
$string['addon.mod_forum.group'] = 'Grup';
$string['addon.mod_forum.numdiscussions'] = '{{numdiscussions}} tartışma';
$string['addon.mod_forum.numreplies'] = '{{numreplies}} cevapları';
$string['addon.mod_forum.postingroup'] = '"{{groupname}}" grubunda yayınlanıyor.';
$string['addon.mod_forum.refreshposts'] = 'Mesajyladı yenile';
$string['addon.mod_glossary.browsemode'] = 'Girişlere göz at';
$string['addon.mod_glossary.byalphabet'] = 'Alfabetik olarak';
$string['addon.mod_glossary.byauthor'] = 'Yazara göre gruplandır';
$string['addon.mod_glossary.bycategory'] = 'Kategoriye göre grupla';
$string['addon.mod_glossary.bynewestfirst'] = 'En yeni ilk';
$string['addon.mod_glossary.byrecentlyupdated'] = 'Son güncellenenler';
$string['addon.mod_glossary.bysearch'] = 'Ara';
$string['addon.mod_glossary.cannoteditentry'] = 'Giriş düzenlenemiyor';
$string['addon.mod_glossary.entriestobesynced'] = 'Senkronize edilecek girişler';
$string['addon.mod_glossary.entrypendingapproval'] = 'Bu giriş için onay bekliyor.';
$string['addon.mod_glossary.errordeleting'] = 'Giriş silinirken hata oluştu.';
$string['addon.mod_glossary.errorloadingentries'] = 'Girişler yüklenirken bir hata oluştu.';
$string['addon.mod_glossary.errorloadingentry'] = 'Giriş yüklenirken bir hata oluştu.';
$string['addon.mod_glossary.errorloadingglossary'] = 'Sözlük yüklenirken bir hata oluştu.';
$string['addon.mod_glossary.noentriesfound'] = 'Her hangi bir kayıt bulunamadı';
$string['addon.mod_glossary.searchquery'] = 'Arama sorgusu';
$string['addon.mod_h5pactivity.downloadh5pfile'] = 'H5P dosyasını indir';
$string['addon.mod_h5pactivity.errorgetactivity'] = 'H5P etkinlik verileri alınırken hata oluştu.';
$string['addon.mod_h5pactivity.filestatenotdownloaded'] = 'H5P paketi indirilmedi. Kullanabilmek için indirmeniz gerekiyor.';
$string['addon.mod_h5pactivity.filestateoutdated'] = 'H5P paketi son indirmeden beri değiştirildi. Kullanabilmek için tekrar indirmeniz gerekiyor.';
$string['addon.mod_h5pactivity.offlinedisabledwarning'] = 'H5P paketini görüntülemek için çevrimiçi olmanız gerekir.';
$string['addon.mod_h5pactivity.viewattempt'] = '{{$a}} denemesini görüntüle';
$string['addon.mod_imscp.showmoduledescription'] = 'Açıklamayı göster';
$string['addon.mod_lesson.errorprefetchrandombranch'] = 'Bu ders rastgele bir içerik sayfasına bir atlama içerir. Bir web tarayıcısında başlatılıncaya kadar uygulamada denenemez.';
$string['addon.mod_lesson.errorreviewretakenotlast'] = 'Başka bir deneme tamamlandığı için bu deneme artık gözden geçirilemez.';
$string['addon.mod_lesson.finishretakeoffline'] = 'Bu deneme çevrimdışı olarak tamamlandı.';
$string['addon.mod_lesson.retakefinishedinsync'] = 'Çevrimdışı bir deneme senkronize edildi. İncelemek istiyor musunuz?';
$string['addon.mod_lesson.retakelabelfull'] = '{{retake}}: {{grade}} {{timestart}} ({{duration}})';
$string['addon.mod_lesson.retakelabelshort'] = '{{retake}}: {{grade}} {{timestart}}';
$string['addon.mod_lesson.warningretakefinished'] = 'Deneme sitede tamamlandı.';
$string['addon.mod_lti.errorgetlti'] = 'Modül verileri alınırken hata oluştu.';
$string['addon.mod_lti.errorinvalidlaunchurl'] = 'Başlatma URL\'si geçerli değil.';
$string['addon.mod_lti.launchactivity'] = 'Etkinliği başlat';
$string['addon.mod_page.errorwhileloadingthepage'] = 'Sayfa içeriği yüklenirken hata oluştu.';
$string['addon.mod_quiz.canattemptbutnotsubmit'] = 'Bu sınavı uygulamada deneyebilirsiniz, ancak aşağıdaki nedenlerle tarayıcıdaki denemeyi göndermeniz gerekir:';
$string['addon.mod_quiz.cannotsubmitquizdueto'] = 'Bu sınav denemesi aşağıdaki nedenlerle gönderilemez:';
$string['addon.mod_quiz.confirmcontinueoffline'] = 'Bu deneme{{$a}} tarihinden beri senkronize edilmedi. O zamandan bu yana başka bir cihazda bu denemeye devam ettiyseniz, veri kaybedebilirsiniz.';
$string['addon.mod_quiz.confirmleavequizonerror'] = 'Yanıtlar kaydedilirken bir hata oluştu. Testten ayrılmak istediğinizden emin misiniz?';
$string['addon.mod_quiz.errorbehaviournotsupported'] = 'Soru davranışı uygulama tarafından desteklenmediğinden, bu test uygulamada denenemez:';
$string['addon.mod_quiz.errordownloading'] = 'Gerekli veriler indirilirken hata oluştu.';
$string['addon.mod_quiz.errorgetattempt'] = 'Deneme verisi alınırken hata oluştu.';
$string['addon.mod_quiz.errorgetquestions'] = 'Soru alınırken hata oluştu.';
$string['addon.mod_quiz.errorgetquiz'] = 'Test verileri alınırken hata oluştu.';
$string['addon.mod_quiz.errorparsequestions'] = 'Sorular okunurken bir hata oluştu. Lütfen bu testi bir web tarayıcısında deneyin.';
$string['addon.mod_quiz.errorquestionsnotsupported'] = 'Bu sınav, yalnızca uygulama tarafından desteklenmeyen sorular içerdiğinden uygulamada denenemez:';
$string['addon.mod_quiz.errorrulesnotsupported'] = 'Bu sınav, uygulama tarafından desteklenmeyen erişim kurallarına sahip olduğundan uygulamada denenemez:';
$string['addon.mod_quiz.errorsaveattempt'] = 'Deneme verileri kaydedilirken bir hata oluştu.';
$string['addon.mod_quiz.finishedofflinenotice'] = 'Denemeniz gönderildi ve kaydedildi. Tekrar çevrimiçi olduğunuzda siteye gönderilecektir.';
$string['addon.mod_quiz.finishnotsynced'] = 'Tamamlandı ancak senkronize edilmedi';
$string['addon.mod_quiz.opentoc'] = 'Gezinme penceresini aç';
$string['addon.mod_quiz.warningattemptfinished'] = 'Çevrimdışı deneme, sitede bittiği veya bulunmadığı için atıldı.';
$string['addon.mod_quiz.warningdatadiscarded'] = 'Sorular çevrimiçi olarak değiştirildiği için bazı çevrimdışı yanıtlar atıldı.';
$string['addon.mod_quiz.warningdatadiscardedfromfinished'] = 'Bazı çevrimdışı yanıtlar atıldığı için tamamlanmadı. Lütfen yanıtlarınızı gözden geçirin ve denemeyi tekrar gönderin.';
$string['addon.mod_quiz.warningquestionsnotsupported'] = 'Bu sınav uygulama tarafından desteklenmeyen sorular içerir:';
$string['addon.mod_resource.errorwhileloadingthecontent'] = 'İçerik yüklenirken hata oluştu.';
$string['addon.mod_resource.openthefile'] = 'Dosyayı aç';
$string['addon.mod_resource.resourcestatusoutdated'] = 'Bu dosya, onu son açtığınızdan beri değişti.';
$string['addon.mod_resource.resourcestatusoutdatedconfirm'] = 'Bu dosyanın daha yeni bir sürümü var.  Görmek için lütfen cihazınızı internete bağlayın.';
$string['addon.mod_scorm.cannotcalculategrade'] = 'Not hesaplanamadı.';
$string['addon.mod_scorm.dataattemptshown'] = 'Bu veriler {{number}} deneme numarasına aittir.';
$string['addon.mod_scorm.errorcreateofflineattempt'] = 'Yeni bir çevrimdışı deneme oluştururken bir hata oluştu. Lütfen tekrar deneyin.';
$string['addon.mod_scorm.errordownloadscorm'] = 'SCORM indirilirken hata oluştu: "{{name}}".';
$string['addon.mod_scorm.errorgetscorm'] = 'SCORM verileri alınırken hata oluştu.';
$string['addon.mod_scorm.errorinvalidversion'] = 'Maalesef uygulama yalnızca SCORM 1.2\'yi destekliyor.';
$string['addon.mod_scorm.errornotdownloadable'] = 'SCORM paketlerinin indirilmesi devre dışı. Lütfen site yöneticinize başvurun.';
$string['addon.mod_scorm.errornovalidsco'] = 'Bu SCORM paketinin yüklenecek görünür bir SCO\'su yok.';
$string['addon.mod_scorm.errorpackagefile'] = 'Maalesef uygulama yalnızca ZIP paketlerini destekliyor.';
$string['addon.mod_scorm.errorsyncscorm'] = 'Senkronizasyon sırasında bir hata oluştu. Lütfen tekrar deneyin.';
$string['addon.mod_scorm.offlineattemptnote'] = 'Bu denemede senkronize edilmemiş veriler var.';
$string['addon.mod_scorm.offlineattemptovermax'] = 'Maksimum deneme sayısını aştığınız için bu deneme gönderilemiyor.';
$string['addon.mod_scorm.scormstatusnotdownloaded'] = 'Bu SCORM paketi indirilmedi. Açtığınızda otomatik olarak indirilir.';
$string['addon.mod_scorm.scormstatusoutdated'] = 'Bu SCORM paketi son indirmeden beri değiştirildi. Açtığınızda otomatik olarak indirilir.';
$string['addon.mod_scorm.warningofflinedatadeleted'] = '{{number}} girişimindeki bazı çevrimdışı veriler, yeni deneme olarak sayılamadığı için atıldı.';
$string['addon.mod_scorm.warningsynconlineincomplete'] = 'Son deneme girişimi henüz tamamlanmadığından, bazı denemeler site ile senkronize edilemedi. Lütfen önce çevrimiçi denemeyi bitirin.';
$string['addon.mod_survey.cannotsubmitsurvey'] = 'Maalesef anketinizi gönderirken bir sorun oluştu. Lütfen tekrar deneyin.';
$string['addon.mod_survey.errorgetsurvey'] = 'Anket verileri alınırken hata oluştu.';
$string['addon.mod_survey.results'] = 'Sonuçlar';
$string['addon.mod_url.accessurl'] = 'URL\'ye erişin';
$string['addon.mod_url.pointingtourl'] = 'Kaynağın işaret ettiği URL.';
$string['addon.mod_wiki.errorloadingpage'] = 'Sayfa yüklenirken bir hata oluştu.';
$string['addon.mod_wiki.errornowikiavailable'] = 'Bu wiki\'nin henüz içeriği yok.';
$string['addon.mod_wiki.gowikihome'] = 'Wiki\'nin ilk sayfasına git';
$string['addon.mod_wiki.subwiki'] = 'Alt-wiki';
$string['addon.mod_wiki.titleshouldnotbeempty'] = 'Başlık boş olmamalıdır';
$string['addon.mod_wiki.viewpage'] = 'Sayfaya bak';
$string['addon.mod_wiki.wikipage'] = 'Wiki sayfası';
$string['addon.mod_workshop.assessmentstrategynotsupported'] = '{{$a}} değerlendirme stratejisi desteklenmiyor';
$string['addon.mod_workshop.submissionrequiredtitle'] = 'Bir başlık girmeniz gerekiyor.';
$string['addon.mod_workshop.warningassessmentmodified'] = 'Gönderim sitede değiştirildi.';
$string['addon.mod_workshop.warningsubmissionmodified'] = 'Değerlendirme sitede değiştirildi.';
$string['addon.notes.warningnotenotsent'] = 'Not(lar) eklenemedi veya silinemedi. {{error}}';
$string['addon.notifications.allownotifications'] = 'Bildirimlere izin ver';
$string['addon.notifications.errorgetnotifications'] = 'Bildirim alınırken hata oluştu.';
$string['addon.notifications.notifications'] = 'Bildirimler';
$string['addon.notifications.playsound'] = 'Sesi çal';
$string['addon.notifications.therearentnotificationsyet'] = 'Hiç bildiriminiz yok';
$string['addon.notifications.typeofnotification'] = 'Bildirim türü';
$string['addon.privatefiles.couldnotloadfiles'] = 'Dosya listesi yüklenemedi.';
$string['addon.privatefiles.emptyfilelist'] = 'Gösterilecek dosya yok.';
$string['addon.privatefiles.erroruploadnotworking'] = 'Maalesef şu anda sitenize dosya yüklemek mümkün değil.';
$string['addon.storagemanager.confirmdeleteallsitedata'] = 'Siteden indirilen tüm veriler silinsin mi?';
$string['addon.storagemanager.confirmdeletecourses'] = 'Tüm kurslardan indirilen veriler silinsin mi?';
$string['addon.storagemanager.confirmdeletedatafrom'] = 'İndirilen tüm veriler \'{{name}}\' üzerinden silinsin mi?';
$string['addon.storagemanager.coursedownloads'] = 'Kurs İndirmeleri';
$string['addon.storagemanager.courseinfo'] = 'Çevrimdışı çalışmak için ders içeriğini indirin. Cihazınız tekrar çevrimiçi olduğunda etkinliğiniz otomatik olarak senkronize edilir.';
$string['addon.storagemanager.deleteallsitedata'] = 'Siteden indirilen tüm verileri silin';
$string['addon.storagemanager.deleteallsitedatainfo'] = 'Bu işlem, indirilen tüm kurslar ve çevrimdışı çalışmanıza imkan veren veriler de dahil olmak üzere \'{{name}}\' adresinden indirilen tüm verileri silecektir.';
$string['addon.storagemanager.deletecourses'] = 'Tüm kurslardan indirilen verileri sil';
$string['addon.storagemanager.deletedata'] = 'İndirilen verileri sil';
$string['addon.storagemanager.deletedatafrom'] = '{{name}} alanından verileri kaldırın';
$string['addon.storagemanager.downloaddatafrom'] = 'İndir {{name}}';
$string['addon.storagemanager.downloadedcourses'] = 'İndirilen Kurslar';
$string['addon.storagemanager.downloads'] = 'İndirilenler';
$string['addon.storagemanager.errordeletedownloadeddata'] = 'İndirilen veriler silinirken hata oluştu.';
$string['addon.storagemanager.managedownloads'] = 'İndirmeleri Yönet';
$string['addon.storagemanager.totaldownloads'] = 'Toplam İndirme';
$string['addon.storagemanager.totalspaceusage'] = 'Toplam kullanılan alan';
$string['appstoredescription'] = 'NOT: Bu resmi Moodle Mobile uygulaması SADECE izin vermek için ayarlanmış Moodle siteleri ile çalışacaktır. Bağlanmakta sorun yaşıyorsanız lütfen Moodle yöneticinizle görüşün.

Moodle siteniz doğru yapılandırıldıysa, bu uygulamayı aşağıdakileri yapmak için kullanabilirsiniz:

- çevrimdışıyken bile derslerinizin içeriğine göz atın
- mesajlar ve diğer etkinlikler için anında bildirim alma
- kurslarınızdaki diğer kişileri hızlıca bulun ve iletişim kurun
- mobil cihazınızdan resim, ses, video ve diğer dosyaları yükleyin
- kurs notlarınızı görüntüleyin
- ve dahası!

En son bilgiler için lütfen http://docs.moodle.org/en/Mobile_app adresine bakın.

Şimdiye kadar işlevsellik hakkında iyi değerlendirmeleri ve bu uygulamanın başka ne yapmasını istediğiniz hakkındaki önerilerinizi gerçekten takdir ediyoruz!

Uygulama aşağıdaki izinleri gerektirir:
Ses kaydet - Moodle\'a yüklenecek ses kaydetmek için
SD kartınızın içeriğini okuyun ve değiştirin - İçerikler SD Karta indirilir, böylece çevrimdışı olarak görebilirsiniz
Ağ erişimi - Moodle sitenize bağlanmak ve bağlı olup olmadığınızı kontrol etmek için çevrimdışı moda geçmek
Başlangıçta çalıştır - Böylece uygulama arka planda çalışırken bile yerel bildirimler alırsınız
Telefonun uyku moduna geçmesini önleme - Böylece istediğiniz zaman anlık bildirimler alabilirsiniz';
$string['assets.mimetypes.application/vnd.apple.keynote'] = 'Apple Keynote sunumu';
$string['assets.mimetypes.application/vnd.apple.numbers'] = 'Apple Numbers hesap tablosu';
$string['assets.mimetypes.application/vnd.apple.pages'] = 'Apple Pages belgesi';
$string['assets.mimetypes.application/vnd.google-apps.audio'] = 'Google Drive sesi';
$string['assets.mimetypes.application/vnd.google-apps.document'] = 'Google Dokümanlar';
$string['assets.mimetypes.application/vnd.google-apps.drawing'] = 'Google Çizim';
$string['assets.mimetypes.application/vnd.google-apps.file'] = 'Google Drive Dosya';
$string['assets.mimetypes.application/vnd.google-apps.folder'] = 'Google Drive Klasörü';
$string['assets.mimetypes.application/vnd.google-apps.form'] = 'Google Formları';
$string['assets.mimetypes.application/vnd.google-apps.fusiontable'] = 'Google Füzyon Tabloları';
$string['assets.mimetypes.application/vnd.google-apps.presentation'] = 'Google Slaytlar';
$string['assets.mimetypes.application/vnd.google-apps.script'] = 'Google Apps Komut Dosyaları';
$string['assets.mimetypes.application/vnd.google-apps.site'] = 'Google Siteler';
$string['assets.mimetypes.application/vnd.google-apps.spreadsheet'] = 'Google E-Tablolar';
$string['assets.mimetypes.application/vnd.google-apps.video'] = 'Google Drive video';
$string['core.ajaxendpointnotfound'] = 'AJAX uç noktası bulunamadı. Bu durum, Moodle sitesi çok eskiyse veya bu uç noktaya erişimi engelliyorsa meydana gelebilir. Moodle uygulaması yalnızca {{$a}} sonrası Moodle sistemlerini destekler.';
$string['core.browser'] = 'Tarayıcı';
$string['core.calculating'] = 'Hesaplanıyor';
$string['core.cannotconnect'] = 'Bağlanamıyor';
$string['core.cannotdownloadfiles'] = 'Okulunuz veya öğrenme kuruluşunuz dosya indirmeyi devre dışı bıraktı.';
$string['core.cannotinstallapk'] = '.apk dosyaları yüklenemiyor';
$string['core.cannotinstallapkinfo'] = 'Güvenlik nedeniyle, bu uygulamadan bilinmeyen uygulamaları cihazınıza yükleyemezsiniz. Yine de kuruluma devam etmek istiyorsanız, onu bir tarayıcıda açmanız gerekir.';
$string['core.cannotlogoutpageblocks'] = 'Lütfen devam etmeden önce değişikliklerinizi kaydedin veya atın.';
$string['core.cannotopeninapp'] = 'Bu dosya bu cihazda beklendiği gibi çalışmayabilir. Yine de açmak istiyor musunuz?';
$string['core.cannotopeninappdownload'] = 'Bu dosya bu cihazda beklendiği gibi çalışmayabilir. Yine de indirmek istiyor musunuz?';
$string['core.captureaudio'] = 'Ses kaydet';
$string['core.capturedimage'] = 'Çekilen fotoğraf.';
$string['core.captureimage'] = 'Fotoğraf çek';
$string['core.capturevideo'] = 'Video kaydet';
$string['core.certificaterror'] = 'Cihazınız bu sitenin sertifikasına güvenemez: {{details}}';
$string['core.clearsearch'] = 'Aramayı temizle';
$string['core.clearstoreddata'] = 'Hafızayı temizle {{$a}}';
$string['core.clicktoseefull'] = 'Tüm içeriği görmek için tıklayın.';
$string['core.comments.commentsnotworking'] = 'Yorumlar alınamıyor';
$string['core.comments.warningcommentsnotsent'] = 'Yorumlar senkronize edilemedi. {{error}}';
$string['core.confirmcanceledit'] = 'Bu sayfadan ayrılmak istediğinizden emin misiniz? Tüm değişiklikler kaybolacak.';
$string['core.confirmleaveunknownchanges'] = 'Bu sayfadan ayrılmak istediğinizden emin misiniz? Kaydedilmemiş değişiklikleriniz varsa bunlar kaybolacaktır.';
$string['core.confirmloss'] = 'Emin misiniz? Tüm değişiklikler kaybolacaktır.';
$string['core.confirmopeninbrowser'] = 'Tarayıcıda açmak istediğine emin misin?';
$string['core.confirmremoveselectedfile'] = 'Bu, \'{{dosya adı}}\' öğesini kalıcı olarak silecektir. Bunu geri alamazsınız.';
$string['core.confirmremoveselectedfiles'] = 'Bu, seçilen dosyaları kalıcı olarak silecektir. Bunu geri alamazsınız.';
$string['core.connectionlost'] = 'Siteye bağlantı kesildi';
$string['core.contactsupport'] = 'İletişim desteği';
$string['core.contactverb'] = 'İletişim';
$string['core.contenteditingsynced'] = 'Düzenlemekte olduğunuz içerik senkronize edildi.';
$string['core.contentlinks.chooseaccount'] = 'Hesap seç';
$string['core.contentlinks.chooseaccounttoopenlink'] = 'Bağlantıyı açmak için bir hesap seçin.';
$string['core.contentlinks.confirmurlothersite'] = 'Bu bağlantı başka bir siteye ait. Açmak ister misin?';
$string['core.contentlinks.errornoactions'] = 'Bu bağlantıyla gerçekleştirilecek bir işlem bulunamadı.';
$string['core.contentlinks.errornosites'] = 'Bu bağlantıyı işleyecek hiçbir site bulunamadı.';
$string['core.contentlinks.errorredirectothersite'] = 'Yönlendirme URL\'si farklı bir siteyi gösteremez.';
$string['core.copiedtoclipboard'] = 'Metin panoya kopyalandı';
$string['core.copytoclipboard'] = 'Panoya kopyala';
$string['core.course.activitydisabled'] = 'Kuruluşunuz mobil uygulamada bu etkinliği devre dışı bıraktı.';
$string['core.course.activitynotyetviewableremoteaddon'] = 'Kuruluşunuz henüz desteklenmeyen bir eklenti yükledi.';
$string['core.course.allsections'] = 'Tüm Bölümler';
$string['core.course.aria:sectionprogress'] = 'Bölüm ilerlemesi:';
$string['core.course.availablespace'] = 'Şu anda yaklaşık {{available}} boş alanınız var.';
$string['core.course.cannotdeletewhiledownloading'] = 'Etkinlik indirilirken dosyalar silinemez. Lütfen indirme işleminin bitmesini bekleyin.';
$string['core.course.confirmdownload'] = '{{size}} dosyasını indirmek üzeresiniz. {{availableSpace}} Devam etmek istediğinizden emin misiniz?';
$string['core.course.confirmdownloadunknownsize'] = 'İndirme boyutunu hesaplamak mümkün olmadı. {{availableSpace}} Devam etmek istediğinizden emin misiniz?';
$string['core.course.confirmdownloadzerosize'] = 'İndirmeye başlamak üzeresiniz. {{availableSpace}} Devam etmek istediğinizden emin misiniz?';
$string['core.course.confirmlimiteddownload'] = 'Şu anda Kablosuz ağa bağlı değilsiniz.';
$string['core.course.confirmpartialdownloadsize'] = '<strong> En azından </strong> {{size}} dosyasını indirmek üzeresiniz. {{availableSpace}} Devam etmek istediğinizden emin misiniz?';
$string['core.course.couldnotloadsectioncontent'] = 'Bölüm içeriği yüklenemedi. Lütfen daha sonra tekrar deneyiniz.';
$string['core.course.couldnotloadsections'] = 'Bölümler yüklenemedi. Lütfen daha sonra tekrar deneyiniz.';
$string['core.course.downloadcoursesprogressdescription'] = 'Kurslar indiriliyor:  {{count}}  üzerinden {{count}} indirildi.';
$string['core.course.downloadsectionprogressdescription'] = 'İndirme bölümü: {{total}} üzerinden {{count}} indirildi.';
$string['core.course.errordownloadingcourse'] = 'Kurs indirilirken hata oluştu.';
$string['core.course.errordownloadingsection'] = 'Bölüm indirilirken hata oluştu.';
$string['core.course.errorgetmodule'] = 'Etkinlik verileri alınırken hata oluştu.';
$string['core.course.insufficientavailablequota'] = 'Cihazınız bu indirmeyi kaydetmek için yer ayıramadı. Uygulama ve sistem güncellemeleri için yer ayırıyor olabilir. Lütfen önce bir miktar depolama alanını temizleyin.';
$string['core.course.insufficientavailablespace'] = '{{size}} dosyasını indirmeye çalışıyorsunuz. Bu, cihazınızın normal şekilde çalışması için yeterli alana sahip olmayacaktır. Lütfen önce bir miktar depolama alanını temizleyin.';
$string['core.course.lastaccessedactivity'] = 'Son Erişilen Etkinlik';
$string['core.course.manualcompletionnotsynced'] = 'Manuel tamamlama senkronize değil.';
$string['core.course.modulenotfound'] = 'Kaynak veya etkinlik bulunamadı, lütfen çevrimiçi olduğunuzdan ve hala kullanılabilir durumda olduğundan emin olun.';
$string['core.course.nextactivity'] = 'Sonraki etkinlik';
$string['core.course.nextactivitynotfound'] = 'Sonraki Aktivite';
$string['core.course.nocontentavailable'] = 'Şu anda içerik yok.';
$string['core.course.previousactivity'] = 'Önceki etkinlik';
$string['core.course.previousactivitynotfound'] = 'Önceki etkinlik bulunamadı.  Gizlenmiş veya silinmiş olabilir.';
$string['core.course.refreshcourse'] = 'Kursu yenile';
$string['core.course.useactivityonbrowser'] = 'Yine de cihazınızın web tarayıcısını kullanarak kullanabilirsiniz.';
$string['core.course.warningmanualcompletionmodified'] = 'Bir etkinliğin manuel olarak tamamlanması sitede değiştirildi.';
$string['core.course.warningofflinemanualcompletiondeleted'] = '\'{{name}}\' dersin bazı çevrimdışı manuel tamamlamaları silindi. {{error}}';
$string['core.coursenogroups'] = 'Bu kursun herhangi bir grubunun üyesi değilsiniz.';
$string['core.courses.browserenrolinstructions'] = 'Sizi cihazınızın tarayıcısına götüreceğiz.  Kaydınızı tamamladıktan sonra, lütfen bu uygulamaya geri dönün.';
$string['core.courses.cannotretrievemorecategories'] = '{{$a}} düzeyinden daha derin kategoriler alınamıyor.';
$string['core.courses.completeenrolmentbrowser'] = 'Kaydı Tarayıcıdan Tamamla';
$string['core.courses.downloadcourses'] = 'Tüm kursları indir';
$string['core.courses.enrolme'] = 'Beni kaydet';
$string['core.courses.errorloadcategories'] = 'Kategoriler yüklenirken bir hata oluştu.';
$string['core.courses.errorloadcourses'] = 'Kurslar yüklenirken bir hata oluştu.';
$string['core.courses.errorloadplugins'] = 'Bu kursun gerektirdiği eklentiler doğru şekilde yüklenemedi. Lütfen tekrar denemek için uygulamayı yeniden yükleyin.';
$string['core.courses.errorsearching'] = 'Arama sırasında bir hata oluştu.';
$string['core.courses.filtermycourses'] = 'Kurslarımı filtrele';
$string['core.courses.notenrollable'] = 'Kendinizi bu kursa kaydedemezsiniz.';
$string['core.courses.otherenrolments'] = 'Diğer kayıtlar';
$string['core.courses.password'] = 'Kayıt anahtarı';
$string['core.courses.refreshcourses'] = 'Kursları yenile';
$string['core.courses.searchcoursesadvice'] = 'Misafir olarak erişebileceğiniz kursları bulmak için kurs ara düğmesini kullanabilir veya buna izin veren kurslara kendinizi kaydedebilirsiniz.';
$string['core.courses.showonlyenrolled'] = 'Sadece derslerimi göster';
$string['core.courses.totalcoursesearchresults'] = 'Toplam kurs sayısı: {{$a}}';
$string['core.currentdevice'] = 'Şuanki cihaz';
$string['core.datastoredoffline'] = 'Gönderilemediği için cihazda depolanan veriler. Daha sonra otomatik olarak gönderilecektir.';
$string['core.deletedoffline'] = 'Çevrimdışı silindi';
$string['core.deleting'] = 'Siliniyor';
$string['core.desktop'] = 'Masaüstü';
$string['core.dfdaymonthyear'] = 'MM-DD-YYYY';
$string['core.dfdayweekmonth'] = 'ddd, D MMM';
$string['core.dffulldate'] = 'dddd, D MMMM YYYY h[:]mm A';
$string['core.dflastweekdate'] = 'ddd';
$string['core.dfmediumdate'] = 'LLL';
$string['core.dftimedate'] = 'h[:]mm A';
$string['core.discard'] = 'Sil';
$string['core.dismiss'] = 'Reddet';
$string['core.dontshowagain'] = 'Tekrar gösterme';
$string['core.downloaded'] = 'İndirildi';
$string['core.downloading'] = 'İndirilmesi';
$string['core.editor.hidetoolbar'] = 'Sekmeyi gizle';
$string['core.editor.toggle'] = 'Düzenleyiciyi aç / kapat';
$string['core.emptysplit'] = 'Sol panel boşsa veya yükleniyorsa bu sayfa boş görünecektir.';
$string['core.endingtime'] = 'Bitiş zamanı: {{$a}}';
$string['core.errorchangecompletion'] = 'Tamamlanma durumu değiştirilirken bir hata oluştu. Lütfen tekrar deneyin.';
$string['core.errorcode'] = 'Hata kodu: {{errorCode}}';
$string['core.errordeletefile'] = 'Dosya silinirken hata oluştu. Lütfen tekrar deneyin.';
$string['core.errordetailshide'] = 'Hata ayrıntılarını gizle';
$string['core.errordetailsshow'] = 'Hata ayrıntılarını göster';
$string['core.errordownloading'] = 'Dosya indirmede  hata';
$string['core.errordownloadingsomefiles'] = 'Dosyalar indirilirken hata oluştu. Bazı dosyalar eksik olabilir.';
$string['core.errorfileexistssamename'] = 'Bu ada sahip bir dosya zaten var.';
$string['core.errorinvalidform'] = 'Lütfen gerekli tüm alanların doldurulduğunu ve girdiğiniz verilerin doğru formatta olduğunu kontrol edin.';
$string['core.errorinvalidresponse'] = '{{method}} web hizmeti için beklenmeyen yanıt.';
$string['core.errorloadingcontent'] = 'İçerik yüklenirken hata oluştu.';
$string['core.errorofflinedisabled'] = 'Sitenizde çevrimdışı tarama devre dışı bırakıldı. Uygulamayı kullanmak için internete bağlı olmanız gerekir.';
$string['core.erroropenfiledownloading'] = 'Dosya açılırken hata oluştu: İndirmenin tamamlanmasını beklemeniz gerekiyor.';
$string['core.erroropenfilenoapp'] = 'Dosya açılırken hata oluştu: Bu dosya türünü açmak için uygulama bulunamadı.';
$string['core.erroropenfilenoextension'] = 'Dosya açılırken hata oluştu: dosyanın uzantısı yok.';
$string['core.erroropenpopup'] = 'Bu etkinlik bir açılır pencere açmaya çalışıyor. Bu uygulamada desteklenmiyor.';
$string['core.errorrenamefile'] = 'Dosya yeniden adlandırılırken hata oluştu. Lütfen tekrar deneyin.';
$string['core.errorsitesupport'] = 'Sorun devam ederse site desteğiyle iletişime geçin.';
$string['core.errorsomedatanotdownloaded'] = 'Bu etkinliği indirdiyseniz, indirme işlemi sırasında performans ve veri kullanım nedenleriyle bazı verilerin indirilmediğini lütfen unutmayın.';
$string['core.errorsomethingwrong'] = 'Bir şeyler yanlış gitti.  Lütfen tekrar deneyin.';
$string['core.errorsync'] = 'Senkronizasyon sırasında bir hata oluştu. Lütfen tekrar deneyin.';
$string['core.errorsyncblocked'] = 'Bu {{$a}}, devam eden bir işlem nedeniyle şu anda senkronize edilemiyor. Lütfen daha sonra tekrar deneyiniz. Sorun devam ederse uygulamayı yeniden başlatmayı deneyin.';
$string['core.errorurlschemeinvalidscheme'] = 'Bu URL başka bir uygulamada kullanılmalı: {{$a}}.';
$string['core.errorurlschemeinvalidsite'] = 'Bu site URL\'si bu uygulamada açılamıyor.';
$string['core.exactalarmsturnedoff'] = 'Gerçek zamanlı bildirimler kapatıldı';
$string['core.exactalarmsturnedoffmessage'] = 'Önemli uyarıları kaçırmadığınızdan emin olmak için cihazınızın ayarlarından \'Alarmlar ve hatırlatıcılar\'ı açın.';
$string['core.filedeletedsuccessfully'] = '\'{{filename}}\' dosyasını başarıyla sildiniz';
$string['core.filenameexist'] = 'Dosya adı zaten var: {{$a}}';
$string['core.fileuploader.audio'] = 'Ses';
$string['core.fileuploader.camera'] = 'Kamera';
$string['core.fileuploader.confirmuploadfile'] = '{{size}} adlı videoyu yüklemek üzeresiniz. Devam etmek istediğine emin misin?';
$string['core.fileuploader.confirmuploadunknownsize'] = 'Yüklemenin boyutunu hesaplamak mümkün değildi. Devam etmek istediğine emin misin?';
$string['core.fileuploader.discardrecording'] = 'Kaydı sil';
$string['core.fileuploader.errorcapturingaudio'] = 'Ses kayıt hatası';
$string['core.fileuploader.errorcapturingimage'] = 'Resim çekilirken hata oluştu.';
$string['core.fileuploader.errorcapturingvideo'] = 'Video kayıt hatası';
$string['core.fileuploader.errorgettingimagealbum'] = 'Albümden resim alınırken hata oluştu.';
$string['core.fileuploader.errormustbeonlinetoupload'] = 'Dosyaları yüklemek için çevrimiçi olmanız gerekiyor';
$string['core.fileuploader.errornoapp'] = 'Bu işlemi gerçekleştirmek için yüklü bir uygulamanız yok.';
$string['core.fileuploader.errorreadingfile'] = 'Dosya okunurken hata oluştu.';
$string['core.fileuploader.errorwhileuploading'] = 'Dosya yükleme sırasında bir hata oluştu.';
$string['core.fileuploader.file'] = 'Dosya';
$string['core.fileuploader.fileuploaded'] = 'Dosya başarıyla yüklendi';
$string['core.fileuploader.maxbytesfile'] = '{{$a.file}} dosyası çok büyük. Yükleyebileceğiniz maksimum boyut {{$a.size}}.';
$string['core.fileuploader.microphonepermissiondenied'] = 'Mikrofona erişim izni reddedildi.';
$string['core.fileuploader.microphonepermissionrestricted'] = 'Mikrofon erişimi kısıtlandı.';
$string['core.fileuploader.pauserecording'] = 'Kaydı duraklat';
$string['core.fileuploader.photoalbums'] = 'Fotoğraf  albümleri';
$string['core.fileuploader.readingfile'] = 'Dosya okunuyor';
$string['core.fileuploader.readingfileperc'] = 'Dosya okunuyor: %{{$a}}';
$string['core.fileuploader.resumerecording'] = 'Kayda devam et';
$string['core.fileuploader.selectafile'] = 'Dosya seç';
$string['core.fileuploader.startrecordinginstructions'] = 'Kaydı başlatmak için dokunun';
$string['core.fileuploader.uploadafile'] = 'Dosya yükle';
$string['core.fileuploader.uploading'] = 'Yükleniyor';
$string['core.fileuploader.uploadingperc'] = 'Yükleniyor: {{$a}}%';
$string['core.fileuploader.video'] = 'Video';
$string['core.fullnameandsitename'] = '{{fullname}} ({{sitename}})';
$string['core.goto'] = '{{$a}}\'a git';
$string['core.h5p.errorgetemail'] = 'Kullanıcı e-postası alınırken hata oluştu. Lütfen bağlantınızı kontrol edin ve tekrar deneyin.';
$string['core.h5p.offlinedisabled'] = 'Site, H5P paketlerinin indirilmesine izin vermiyor.';
$string['core.h5p.play'] = 'H5P oynat';
$string['core.hasdatatosync'] = 'Bu {{$a}} senkronize edilecek çevrimdışı verilere sahip.';
$string['core.humanreadablesize'] = '{{size}} {{unit}}';
$string['core.iframehelp'] = 'Bu içerik çalışmıyor mu?';
$string['core.image'] = 'Resim';
$string['core.imageviewer'] = 'Resim görüntüleyici';
$string['core.ioscookieshelp'] = 'Gömülü içerik, çerezlerin çalışmasını gerektirebilir. Lütfen uygulamanın iOS ayarlarına gidin, \'Web Siteleri Arası İzlemeye İzin Ver\'i etkinleştirin ve tekrar deneyin.';
$string['core.lastdownloaded'] = 'Son indirilen';
$string['core.lastsync'] = 'Son senkronizasyon';
$string['core.loadmore'] = 'Daha fazla yükle';
$string['core.login.authenticating'] = 'Kimlik doğrulanıyor';
$string['core.login.changepasswordbutton'] = 'Şifre değiştirme sayfasını açın';
$string['core.login.changepasswordhelp'] = 'Parolanızı değiştirmekte sorun yaşıyorsanız, daha sonra tekrar deneyin veya okulunuzla ya da öğrenim sağlayıcınızla iletişime geçin.';
$string['core.login.changepasswordreconnectinstructions'] = 'Siteye yeniden bağlanmak için aşağıdaki düğmeyi tıklayın. (Şifrenizi başarılı bir şekilde değiştirmediyseniz, önceki ekrana döneceğinizi unutmayın).';
$string['core.login.changepasswordsupportsubject'] = 'Şifremi değiştirmek için yardıma ihtiyacım var';
$string['core.login.confirmdeletesite'] = '{{sitename}} sitesini silmek istediğinizden emin misiniz?';
$string['core.login.connect'] = 'Bağlan!';
$string['core.login.connecttomoodle'] = 'Moodle ile iletişime geç';
$string['core.login.connecttomoodleapp'] = 'Normal bir Moodle sitesine bağlanmaya çalışıyorsunuz. Bu siteye erişmek için resmi Moodle uygulamasını indirin.';
$string['core.login.connecttoworkplaceapp'] = 'Bir Moodle Workplace sitesine bağlanmaya çalışıyorsunuz. Bu siteye erişmek için lütfen Moodle Workplace uygulamasını indirin.';
$string['core.login.credentialsdescription'] = 'Lütfen giriş yapmak için kullanıcı adınızı ve şifrenizi girin.';
$string['core.login.credentialshelp'] = 'Giriş yapmakta sorun yaşıyorsanız, daha sonra tekrar deneyin veya okulunuzla veya öğrenim sağlayıcınızla iletişime geçin.';
$string['core.login.credentialssupportsubject'] = 'Giriş yapmak için yardıma ihtiyacınız var';
$string['core.login.emailconfirmsentnoemail'] = '<p> Adresinize bir e-posta gönderilmelidir. </p> <p> Kaydınızı tamamlamak için kolay talimatlar içerir. </p> <p> Sorun yaşamaya devam ederseniz, site yöneticisine başvurun. </p>';
$string['core.login.emailnotmatch'] = 'E-postalar uyuymuyor';
$string['core.login.erroraccesscontrolalloworigin'] = 'Gerçekleştirmeye çalıştığınız çapraz kökenli çağrı reddedildi. Lütfen https://moodledev.io/general/app/development/setup/app-in-browser adresini kontrol edin';
$string['core.login.errordeletesite'] = 'Bu site silinirken bir hata oluştu. Lütfen tekrar deneyin.';
$string['core.login.errorexampleurl'] = 'Https://campus.example.edu URL\'si yalnızca örnek bir URL\'dir, gerçek bir site değildir. <strong> Lütfen okulunuzun veya kuruluşunuzun sitesinin URL\'sini kullanın. </strong>';
$string['core.login.errorqrnoscheme'] = 'Bu URL geçerli bir giriş URL\'si değil.';
$string['core.login.errorupdatesite'] = 'Sitenin simgesi güncellenirken bir hata oluştu.';
$string['core.login.exceededloginattempts'] = 'Giriş yapmak için yardıma mı ihtiyacınız var?  {{recoverPassword}} deneyin veya site desteğinizle iletişime geçin.';
$string['core.login.exceededloginattemptsrecoverpassword'] = 'şifrenizi kurtarma';
$string['core.login.exceededloginattemptssupportsubject'] = 'Giriş yapamıyorum';
$string['core.login.exceededloginattemptswithoutpassword'] = 'Giriş yapmak için yardıma mı ihtiyacınız var?  Site desteğinizle iletişime geçmeyi deneyin.';
$string['core.login.exceededloginattemptswithoutsupport'] = 'Giriş yapmak için yardıma mı ihtiyacınız var?  {{recoverPassword}} deneyin.';
$string['core.login.exceededpasswordresetattempts'] = 'Görünüşe göre hesabınıza erişmekte sorun yaşıyorsunuz.  Okulunuzla veya öğrenim sağlayıcınızla iletişime geçebilir veya daha sonra tekrar deneyebilirsiniz.';
$string['core.login.exceededpasswordresetattemptssupportsubject'] = 'Şifremi sıfırlayamıyorum';
$string['core.login.faqcannotfindmysiteanswer'] = 'URL adresine göre arama yapmayı denediyseniz ve hala Moodle sitenizi bulamıyorsanız, lütfen okulunuzda veya öğrenim kurumunuzda Moodle ile ilgilenen kişiyle iletişime geçin.';
$string['core.login.faqcannotfindmysitequestion'] = 'Sitemi URL adresinden bulamıyorum.';
$string['core.login.faqcantloginanswer'] = '<p>Moodle sitenize bağlandığınızda, her zamanki kullanıcı adınız ve şifrenizle giriş yapabilmeniz gerekir.</p><br><p>Kullanıcı adınızı veya şifrenizi unuttuysanız <strong seçeneğini seçin. >Şifrenizi mi kaybettiniz?</strong>. Hala giriş yapmada sorun yaşıyorsanız veya kullanıcı adınızı veya şifrenizi almak için herhangi bir seçenek göremiyorsanız lütfen okulunuzda veya öğrenim organizasyonunuzda Moodle ile ilgilenen kişiyle iletişime geçin.</p>';
$string['core.login.faqcantloginquestion'] = 'Giriş yapamıyorum.';
$string['core.login.faqmore'] = 'Daha fazla yanıt için <a href="https://docs.moodle.org/en/Moodle_app_FAQ#toc" target="_blank">SSS\'mize</a> göz atın.';
$string['core.login.faqsetupsiteanswer'] = 'Kendi Moodle sitenizi oluşturmanız gereken farklı seçeneklere göz atmak için {{$link}} adresini ziyaret edin.';
$string['core.login.faqsetupsitelinktitle'] = 'Başlamak.';
$string['core.login.faqsetupsitequestion'] = 'Kendi Moodle sitemi kurmak istiyorum.';
$string['core.login.faqtestappanswer'] = 'Uygulamayı bir Moodle Demo Sitesinde test etmek için "Siteniz" alanına "öğretmen" veya "öğrenci" yazın ve "Sitenize bağlanın" düğmesini tıklayın.';
$string['core.login.faqtestappquestion'] = 'Sadece uygulamayı test etmek istiyorum, ne yapabilirim?';
$string['core.login.faqwhatisurlanswer'] = '<p>Sitenizi ada göre bulamıyorsanız, bunun yerine Moodle site URL adresinize (veya web adresine) göre aramayı deneyin.</p><p>Site adresinizi bulmak için:</p><ol>< li>Bir web tarayıcısı açın ve Moodle site giriş sayfanıza gidin.</li><li>Sayfanın üst kısmında, adres çubuğunda Moodle sitenizin URL adresini göreceksiniz, örneğin "campus. example.edu".<br>{{$image}}</li><li>URL\'yi kopyalayın (/login\'i ve ardından gelenleri kopyalamayın), <strong>Sitenize</strong> yapıştırın uygulamada, ardından <strong>Sitenize bağlanın</strong></li><li>Artık kullanıcı adınız ve şifrenizle sitenize giriş yapabilirsiniz.</li></ol><p>Eğer URL adresine göre arama yapmayı denediniz ve Moodle sitenizi hala bulamıyorsanız, lütfen okulunuzdaki veya eğitim kurumunuzdaki Moodle ile ilgilenen kişiyle iletişime geçin.</p>';
$string['core.login.faqwhatisurlquestion'] = 'Site adresim nedir? Site URL’mi nasıl bulabilirim?';
$string['core.login.faqwhereisqrcode'] = 'QR kodunu nerede bulabilirim?';
$string['core.login.faqwhereisqrcodeanswer'] = '<p> Kuruluşunuz etkinleştirdiyse, web sitesinde kullanıcı profili sayfanızın alt kısmında bir QR kodu bulacaksınız. </p> {{$image}}';
$string['core.login.findyoursite'] = 'Sitenizi bulun';
$string['core.login.invalidaccount'] = 'Lütfen giriş bilgilerinizi kontrol edin ve tekrar deneyin.';
$string['core.login.invalidmoodleversion'] = 'Bu Moodle sitesinin sürümü çok eski.  Moodle Uygulaması, {{$a}} veya daha yenisini kullanan sitelerle çalışır.';
$string['core.login.invalidsite'] = 'Site URL\'si geçerli değil.';
$string['core.login.invalidtime'] = 'Zaman geçerli değil';
$string['core.login.invalidvaluemax'] = 'En fazla değer {{$a}}';
$string['core.login.invalidvaluemin'] = 'En az değer {{$a}}';
$string['core.login.loginbutton'] = 'Giriş yap';
$string['core.login.mobileservicesnotenabled'] = 'Mobil Hizmetler sitenizde etkin değildir.';
$string['core.login.notloggedin'] = 'Giriş yapmanız gerekiyor.';
$string['core.login.onboardingcreatemanagecourses'] = 'Kurslarınızı oluşturun ve yönetin';
$string['core.login.onboardingenrolmanagestudents'] = 'Öğrencilerinizi kursa kaydedin ve yönetin';
$string['core.login.onboardinggetstarted'] = 'Moodle ile başlayın';
$string['core.login.onboardingialreadyhaveasite'] = 'Zaten bir Moodle sitem var';
$string['core.login.onboardingimalearner'] = 'Öğrenenim';
$string['core.login.onboardingimaneducator'] = 'Eğitimciyim';
$string['core.login.onboardingineedasite'] = 'Moodle sitesine ihtiyacım var';
$string['core.login.onboardingprovidefeedback'] = 'Zamanında geri bildirim sağlayın';
$string['core.login.onboardingtoconnect'] = 'Moodle Uygulamasına bağlanmak için bir Moodle sitesine ihtiyacınız olacak';
$string['core.login.onboardingwelcome'] = 'Moodle App hoş geldiniz!';
$string['core.login.or'] = 'Veya';
$string['core.login.passwordrequired'] = 'Şifre zorunludur';
$string['core.login.policyacceptmandatory'] = 'Zorunlu site politikalarını anlıyorum ve kabul ediyorum';
$string['core.login.recaptchachallengeimage'] = 'reCAPTCHA sınama resmi';
$string['core.login.recaptchaexpired'] = 'Doğrulamanın süresi doldu. Güvenlik sorusunu tekrar cevaplayın.';
$string['core.login.recaptchaincorrect'] = 'Güvenlik sorusunun cevabı yanlış.';
$string['core.login.reconnect'] = 'Yeniden bağlantı kur';
$string['core.login.reconnecthelp'] = 'Yeniden bağlanma konusunda sorun yaşıyorsanız daha sonra tekrar deneyin veya okulunuz veya öğrenim sağlayıcınızla iletişime geçin.';
$string['core.login.reconnectsupportsubject'] = 'Yeniden bağlanmak için yardıma ihtiyacınız var';
$string['core.login.reconnecttosite'] = 'Siteye yeniden bağlan';
$string['core.login.removeaccount'] = 'Hesabı kaldır';
$string['core.login.searchby'] = 'Arama ölçütü:';
$string['core.login.selectsite'] = 'Lütfen sitenizi seçin:';
$string['core.login.signupplugindisabled'] = '{{$a}} etkin değil.';
$string['core.login.signuprequiredfieldnotsupported'] = 'Kayıt formu, bu uygulamada desteklenmeyen zorunlu bir özel alan içeriyor. Lütfen hesabınızı bir tarayıcı kullanarak oluşturun.';
$string['core.login.siteaddress'] = 'Senin siten';
$string['core.login.siteaddressplaceholder'] = 'https://campus.example.edu';
$string['core.login.sitebadgedescription'] = '{{count}} adet okunmamış bildirim var.';
$string['core.login.sitehasredirect'] = 'Sitenizde en az bir HTTP yönlendirmesi var. Uygulama yönlendirmeleri takip edemez, bu uygulamanın sitenize bağlanmasını engelleyen bir sorun olabilir.';
$string['core.login.siteinmaintenance'] = 'Siteniz bakım modunda';
$string['core.login.sitenotallowed'] = 'Bu site artık mevcut değil.';
$string['core.login.sitepolicynotagreederror'] = 'Site politikası kabul edilmedi.';
$string['core.login.siteurl'] = 'Sİte Adresi';
$string['core.login.siteurlrequired'] = 'Site URL\'si gerekli, yani <i>https://campus.example.edu</i>';
$string['core.login.stillcantconnect'] = 'Henüz bağlantı kurulamadı';
$string['core.login.toggleremove'] = 'Hesap listesini düzenle';
$string['core.login.unsupportedsite'] = 'Siteye uygulama üzerinden erişilemiyor';
$string['core.login.unsupportedsitemessage'] = '{{site}} bu uygulama üzerinden erişilemez.<br><br>Bir web tarayıcısı kullanarak yine de erişebilirsiniz.';
$string['core.login.usernamerequired'] = 'Kullanıcı adı gerekiyor';
$string['core.login.visitchangepassword'] = 'Şifreyi değiştirmek için siteyi ziyaret etmek ister misiniz?';
$string['core.login.webservicesnotenabled'] = 'Sitenizin Web Hizmetleri ektin değildir. Mobil erişimin etkin olduğunu düşünüyrosanız. Moodle site yöneticinize başvurun.';
$string['core.login.youcanstillconnectwithcredentials'] = 'Yine de kullanıcı adınızı ve şifrenizi girerek siteye bağlanabilirsiniz.';
$string['core.login.yourenteredsite'] = 'Sitenize bağlanın';
$string['core.lostconnection'] = 'Oturumunuz sona erdi.  Devam etmek için lütfen tekrar giriş yapın.';
$string['core.mainmenu.switchaccount'] = 'Hesap Değiştir';
$string['core.mainmenu.usermenutourdescription'] = 'Notlarınızı kontrol edebileceğiniz, tercihleri veya hesap değiştirebileceğiniz bölümdür.';
$string['core.mainmenu.usermenutourtitle'] = 'Kişisel bilgilerinizi keşfedin';
$string['core.needhelp'] = 'Yardıma mı ihtiyacınız var?';
$string['core.networkerroriframemsg'] = 'Bu içerik çevrimdışı kullanılamıyor. Lütfen İnternet\'e bağlanın ve tekrar deneyin.';
$string['core.networkerrormsg'] = 'Ağ etkin değil ya da çalışmıyor.';
$string['core.nooptionavailable'] = 'Seçenek yok';
$string['core.nopasswordchangeforced'] = 'Şifrenizi değiştirmeden devam edemezsiniz.';
$string['core.nopermissionerror'] = 'Maalesef, şu anda bunu yapma izniniz yok';
$string['core.notapplicable'] = 'uygulanamaz';
$string['core.notdownloadable'] = 'indirilemez';
$string['core.notnow'] = 'Şimdi değil';
$string['core.notsent'] = 'Gönderilmedi';
$string['core.nummore'] = '{{$a}} daha fazla';
$string['core.openfile'] = 'Dosyayı aç';
$string['core.openfilewithextension'] = '{{extension}} dosyası açı';
$string['core.openfullimage'] = 'Resmi gerçek boyutunda görmek için tıklayın';
$string['core.openinbrowser'] = 'Tarayıcıda aç';
$string['core.openinbrowserdescription'] = 'Bir web tarayıcısına yönlendirileceksiniz';
$string['core.openmodinbrowser'] = '{{$a}} tarayıcıda aç';
$string['core.opensecurityquestion'] = 'Güvenlik sorusunu aç';
$string['core.opensettings'] = 'Ayarları aç';
$string['core.openwith'] = 'Birlikte aç...';
$string['core.percentagenumber'] = '{{$a}}%';
$string['core.play'] = 'Oyna';
$string['core.policy.havereadandagreepolicy'] = 'Okudum ve kabul ediyorum {{policyname}}';
$string['core.policy.nopoliciesyet'] = 'Henüz politika ve sözleşme yok.';
$string['core.policy.policyacceptmandatory'] = 'Zorunlu site politikalarını anlıyor ve kabul ediyorum';
$string['core.policy.sitepolicynotagreederror'] = 'Site politikası kabul edilmemiştir.';
$string['core.policy.viewpolicy'] = 'Politikayı görüntüle {{policyname}}.';
$string['core.pulltorefresh'] = 'Yenileme için çek';
$string['core.qrscanner'] = 'QR tarayıcı';
$string['core.question.cannotdeterminestatus'] = 'Durum tespit edilemiyor';
$string['core.question.errorattachmentsnotsupportedinsite'] = 'Siteniz henüz cevaplara dosya eklemeyi desteklemiyor.';
$string['core.question.errorembeddedfilesnotsupportedinsite'] = 'Siteniz henüz gömülü dosyaları düzenlemeyi desteklemiyor.';
$string['core.question.errorquestionnotsupported'] = 'Bu soru türü uygulama tarafından desteklenmiyor: {{$a}}.';
$string['core.question.howtodraganddrop'] = 'Seçmek için dokunun, ardından bırakmak için dokunun.';
$string['core.question.questionmessage'] = 'Soru {{$a}}: {{$b}}';
$string['core.redirectingtosite'] = 'Siteye yönlendirileceksiniz.';
$string['core.reminders.atthetime'] = 'olay zamanında';
$string['core.reminders.custom'] = 'Özel';
$string['core.reminders.customreminder'] = 'Özel hatırlatıcı';
$string['core.reminders.delete'] = 'Hatırlatıcıyı sil';
$string['core.reminders.reminderset'] = 'Hatırlatıcı {{$a}}için ayarlandı';
$string['core.reminders.reminderunset'] = 'Hatırlatıcı silindi';
$string['core.reminders.setareminder'] = 'Hatırlatıcı ayarla';
$string['core.reminders.setareminderfor'] = '"{{title}}" ({{label}})için bir hatırlatıcı ayarlayın';
$string['core.reminders.setreminder'] = 'Hatırlatıcıyı ayarla';
$string['core.reminders.timebefore'] = '{value} {units} önce';
$string['core.reminders.value'] = 'Değer';
$string['core.removedownloadeddata'] = 'İndirilen verileri kaldır';
$string['core.removefiles'] = 'Dosyaları kaldır {{$a}}';
$string['core.reportbuilder.filtersapplied'] = 'Bu görünüme uygulanan filtreler olabilir. Filtreleri düzenlemek veya sıralama düzenini değiştirmek için <a href="{{$a}}">bu raporu tarayıcınızda açın.</bir>';
$string['core.reportbuilder.hidecolumns'] = 'Sütunları gizle';
$string['core.reportbuilder.showcolumns'] = 'Sütunları göster';
$string['core.requireduserdatamissing'] = 'Bu kullanıcı bazı gerekli profil verilerine sahip değil. Lütfen verileri sitenize girin ve tekrar deneyin.<br>{{$a}}';
$string['core.resume'] = 'Sürdür';
$string['core.retry'] = 'Yeniden Dene';
$string['core.scanqr'] = 'QR kodunu tara';
$string['core.scrollbackward'] = 'Geri kaydır';
$string['core.scrollforward'] = 'İleri kaydır';
$string['core.search.allcategories'] = 'Tüm kategoriler';
$string['core.search.empty'] = 'Ne aramıştın?';
$string['core.search.filtercategories'] = 'Sonuçları şuna göre filitrele:';
$string['core.search.filtercourses'] = 'İçinde ara';
$string['core.search.noresults'] = '"{{$a}}" için sonuç yok';
$string['core.search.noresultshelp'] = 'Yazım hatalarını kontrol edin veya farklı anahtar kelimeler kullanmayı deneyin';
$string['core.search.resultby'] = '{{$a}} tarafından';
$string['core.searching'] = 'Aranıyor';
$string['core.serverconnection'] = 'Sunucuya bağlanırken hata oluştu: {{details}}';
$string['core.settings.about'] = 'Hakkında';
$string['core.settings.appsettings'] = 'Uygulama ayarları';
$string['core.settings.appversion'] = 'Uygulama sürümü';
$string['core.settings.cannotsyncloggedout'] = 'Çıkış yaptığınız için site senkronize edilemiyor. Lütfen tekrar siteye giriş yaptığınızda tekrar deneyin.';
$string['core.settings.cannotsyncoffline'] = 'Çevrimdışı senkronize edilemiyor.';
$string['core.settings.cannotsyncwithoutwifi'] = 'Geçerli ayarlar yalnızca kablosuz ağa bağlıyken senkronizasyona izin verdiği için senkronize edilemiyor. Lütfen bir kablosuz ağa bağlanın.';
$string['core.settings.changelanguage'] = '{{$a}}olarak değiştir';
$string['core.settings.changelanguagealert'] = 'Dili değiştirmek uygulamayı yeniden başlatır.';
$string['core.settings.colorscheme'] = 'Renk Düzeni';
$string['core.settings.colorscheme-dark'] = 'Koyu';
$string['core.settings.colorscheme-light'] = 'Açık';
$string['core.settings.colorscheme-system'] = 'Sistem varsayılanı';
$string['core.settings.colorscheme-system-notice'] = 'Sistem varsayılan modu, cihazınızın desteğine bağlı olacaktır.';
$string['core.settings.compilationinfo'] = 'Derleme bilgisi';
$string['core.settings.connecttosync'] = 'Cihazınız çevrimdışı. Siteleri senkronize etmek için internete bağlanın.';
$string['core.settings.connectwifitosync'] = 'Siteleri senkronize etmek için bir Wi-Fi ağına bağlanın veya Veri tasarrufu özelliğini kapatın.';
$string['core.settings.copyinfo'] = 'Cihaz bilgilerini panoya kopyala';
$string['core.settings.cordovadevicemodel'] = 'Cordova cihaz modeli';
$string['core.settings.cordovadeviceosversion'] = 'Cordova cihazı işletim sistemi sürümü';
$string['core.settings.cordovadeviceplatform'] = 'Cordova cihaz platformu';
$string['core.settings.cordovadeviceuuid'] = 'Cordova cihaz kullanıcı kimliği';
$string['core.settings.cordovaversion'] = 'Cordova sürümü';
$string['core.settings.debugdisplaydescription'] = 'Etkinleştirilirse, hata modları mümkünse hata hakkında daha fazla veri görüntüler.';
$string['core.settings.developeroptions'] = 'Geliştirici seçenekleri';
$string['core.settings.deviceinfo'] = 'Cihaz bilgisi';
$string['core.settings.deviceos'] = 'Cihaz işletim sistemi';
$string['core.settings.displayformat'] = 'Görüntüleme biçimi';
$string['core.settings.enableanalytics'] = 'Analitiği etkinleştirin';
$string['core.settings.enableanalyticsdescription'] = 'Etkinleştirilirse, uygulama anonim veri kullanımı toplayacaktır.';
$string['core.settings.enabledownloadsection'] = 'İndirme bölümlerini etkinleştirme';
$string['core.settings.enablerichtexteditor'] = 'Metin düzenleyiciyi etkinleşir';
$string['core.settings.enablerichtexteditordescription'] = 'Etkinleştirilirse, içerik girerken bir metin düzenleyici kullanılabilir.';
$string['core.settings.encryptedpushsupported'] = 'Şifrelenmiş anlık bildirimler desteklenir';
$string['core.settings.entriesincache'] = 'Önbellekteki {{$a}} girişi';
$string['core.settings.estimatedfreespace'] = 'Tahmini boş alan';
$string['core.settings.filesystemroot'] = 'Dosya sistemi kök dizini';
$string['core.settings.fontsize'] = 'Yazı boyutu';
$string['core.settings.forcedsetting'] = 'Bu ayar, site yapılandırmanız tarafından belirlenmiştir.';
$string['core.settings.helpusimprove'] = 'Bu uygulamayı geliştirmemize yardımcı olun';
$string['core.settings.ioscookies'] = 'Çapraz Web Sitesi Takibi';
$string['core.settings.ioscookiesdescription'] = 'Siteden gömülü içeriğin çalışması için siteler arası çerezler gerekebilir.  Etkinleştirmek için lütfen uygulamanın iOS ayarlarına gidin ve \'Web Siteleri Arası İzlemeye İzin Ver\' seçeneğini etkinleştirin.';
$string['core.settings.legaldisclaimer'] = 'Yasal sorumluluk reddi';
$string['core.settings.localnotifavailable'] = 'Yerel bildirimler mevcut';
$string['core.settings.locationhref'] = 'Web görünümü URL\'si';
$string['core.settings.logintosync'] = 'Senkronize etmek için giriş yapın';
$string['core.settings.navigatorlanguage'] = 'Gezgin dili';
$string['core.settings.navigatoruseragent'] = 'Gezgin kullanıcı aracısı';
$string['core.settings.networkstatus'] = 'İnternet bağlantısı durumu';
$string['core.settings.opensourcelicenses'] = 'Açık Kaynak Lisansları';
$string['core.settings.privacypolicy'] = 'Gizlilik Politikası';
$string['core.settings.publisher'] = 'Yayımcı';
$string['core.settings.pushid'] = 'Anlık bildirimler kimliği';
$string['core.settings.reportinbackground'] = 'Hataları otomatik olarak bildirme';
$string['core.settings.screen'] = 'Ekran bilgileri';
$string['core.settings.showdownloadoptions'] = 'İndirme seçeneklerini göster';
$string['core.settings.siteinfo'] = 'Site bilgisi';
$string['core.settings.sitesynccompleted'] = 'Site senkronizasyonu tamamlandı.';
$string['core.settings.sitesyncfailed'] = 'Site senkronizasyonu başarısız oldu';
$string['core.settings.spaceusage'] = 'Kullanılan alan';
$string['core.settings.syncdatasaver'] = 'Veri tasarrufu: Yalnızca Wi-Fi açıkken senkronize edin';
$string['core.settings.synchronization'] = 'Eşitleme';
$string['core.settings.synchronizenow'] = 'Şimde eşitle';
$string['core.settings.synchronizenowhelp'] = 'Bir siteyi senkronize etmek, bekleyen değişiklikleri ve cihazda depolanan tüm çevrimdışı etkinlikleri gönderir ve mesajlar ve bildirimler gibi bazı verileri senkronize eder.';
$string['core.settings.syncsettings'] = 'Eşitleme ayarları';
$string['core.settings.wificonnection'] = 'Wi-Fi Bağlantısı';
$string['core.settings.youradev'] = 'Artık bir geliştiricisiniz';
$string['core.sharedfiles.chooseaccountstorefile'] = 'Dosyayı saklamak için bir hesap seçin.';
$string['core.sharedfiles.chooseactionrepeatedfile'] = 'Bu ada sahip bir dosya zaten var. Mevcut dosyayı değiştirmek mi yoksa "{{$a}}" olarak yeniden adlandırmak istiyor musunuz?';
$string['core.sharedfiles.errorreceivefilenosites'] = 'Depolanmış site yok. Uygulama ile dosya paylaşmadan önce lütfen bir site ekleyin.';
$string['core.sharedfiles.nosharedfiles'] = 'Bu sitede depolanmış paylaşılan dosya yok.';
$string['core.sharedfiles.nosharedfilestoupload'] = 'Buraya yüklenecek dosyanız yok. Başka bir uygulamadan dosya yüklemek istiyorsanız, dosyayı bulun ve \'Şurada aç\' düğmesini tıklayın.';
$string['core.sharedfiles.rename'] = 'Yeniden adlandır';
$string['core.sharedfiles.replace'] = 'Değiştir';
$string['core.sharedfiles.sharedfiles'] = 'Paylaşılan dosyalar';
$string['core.sharedfiles.successstorefile'] = 'Dosya başarıyla saklandı. Özel dosyalarınıza yüklenecek veya bir etkinlikte kullanılacak dosyayı seçin.';
$string['core.sitenotfoundhelp'] = 'Girdiğiniz siteyi bulamıyoruz. Lütfen yazım hatalarını kontrol edin veya daha sonra tekrar deneyin. Bu mesajı görmeye devam ederseniz, okulunuza veya öğrenim sağlayıcınıza başvurun.';
$string['core.siteunavailablehelp'] = '"{{site}} " sitesi şu anda kullanılamıyor. Lütfen daha sonra tekrar deneyin veya okulunuza veya öğrenim sağlayıcınıza başvurun.';
$string['core.sizetb'] = 'TB';
$string['core.sorry'] = 'Üzgünüz...';
$string['core.start'] = 'Başlangıç';
$string['core.startingtime'] = 'Başlangıç zamanı: {{$a}}';
$string['core.storingfiles'] = 'Dosyaları saklama';
$string['core.submittedoffline'] = 'Gönderildi (Çevrimdışı)';
$string['core.swipenavigationtourdescription'] = 'Gezinmek için sola ve sağa kaydırın.';
$string['core.tablet'] = 'Tablet';
$string['core.tag.errorareanotsupported'] = 'Bu etiket alanı uygulama tarafından desteklenmiyor.';
$string['core.tag.tagareabadgedescription'] = 'Gezinmek için sola ve sağa kaydırın.';
$string['core.tag.warningareasnotsupported'] = 'Etiket alanlarından bazıları uygulama tarafından desteklenmediği için görüntülenmiyor.';
$string['core.thereisdatatosync'] = 'Senkronize edilecek çevrimdışı {{$a}} vardır.';
$string['core.toggledelete'] = 'Silme düğmeleri arasında geçiş yap';
$string['core.tryagain'] = 'Tekrar deneyin';
$string['core.turnon'] = 'Aç';
$string['core.turnonexactalarms'] = 'Gerçek zamanlı uyarıları açın';
$string['core.turnonnotifications'] = 'Bildirimleri açın';
$string['core.turnonnotificationsmessage'] = 'Etkinlikler ve ödevler hakkında bildirim almak ister misiniz?';
$string['core.twoparagraphs'] = '{{p1}}<br><br>{{p2}}';
$string['core.uhoh'] = 'Ah!';
$string['core.unexpectederror'] = 'Beklenmeyen hata. Lütfen uygulamanızı yeniden açın ve tekrar deneyin';
$string['core.unicodenotsupported'] = 'Bazı emojiler bu sitede desteklenmemektedir. Bu karakterler, mesaj gönderildiğinde kaldırılacaktır.';
$string['core.unicodenotsupportedcleanerror'] = 'Unicode karakterleri temizlenirken boş metin bulundu.';
$string['core.unknown'] = 'Bilinmeyen';
$string['core.unzipping'] = 'Çıkarılıyor';
$string['core.updaterequired'] = 'Uygulama güncellemesi gerekiyor';
$string['core.updaterequireddesc'] = 'Lütfen uygulamanızı {{$a}} sürümüne güncelleyin';
$string['core.user.completeprofile'] = 'Profilini Tamamla';
$string['core.user.completeprofilehelp'] = 'Profilinizi tamamlamakta sorun yaşıyorsanız, daha sonra tekrar deneyin veya okulunuzla ya da öğrenim sağlayıcınızla iletişime geçin.';
$string['core.user.completeprofilenotice'] = 'Devam etmeden önce, lütfen kullanıcı profilinizdeki gerekli alanları doldurun.';
$string['core.user.completeprofilereconnectinstructions'] = 'Profilinizi doğru bir şekilde tamamlamadıysanız, tekrar yapmanız istenecektir.';
$string['core.user.completeprofilesupportsubject'] = 'Profilimi tamamlamak için yardıma ihtiyacım var';
$string['core.user.completeyourprofile'] = 'Profiliniz tamamlayın';
$string['core.user.contact'] = 'Kişi';
$string['core.user.detailsnotavailable'] = 'Bu kişiye ait detayları görünteleyemezsiniz.';
$string['core.user.errorloaduser'] = 'Kullanıcı yüklenirken hata oluştu.';
$string['core.user.sendemail'] = 'Eposta';
$string['core.user.support'] = 'Site desteğiyle iletişim kurun';
$string['core.user.supportsubject'] = '[App] {{subject}}';
$string['core.user.userwithid'] = '{{id}} kimlikli kullanıcı';
$string['core.usernologin'] = 'Bu hesap için kimlik doğrulama iptal edildi';
$string['core.viewcode'] = 'Kodu görüntüle';
$string['core.vieweditor'] = 'Düzenleyiciyi görüntüle';
$string['core.viewembeddedcontent'] = 'Katıştırılmış içeriği görüntüleme';
$string['core.wanttochangesite'] = 'Siteleri değiştirmek veya oturumu kapatmak mı istiyorsunuz?';
$string['core.warningofflinedatadeleted'] = '{{component}} \'{{name}}\' adlı çevrimdışı veriler iptal edildi. {{error}}';
$string['core.warningofflinedatadeletedreason'] = 'Bu etkinlikteki daha yeni değişiklikler farklı bir cihazdan yapılmıştır.';
$string['core.warnopeninbrowser'] = '<p>Aşağıdaki URL\\\'yi cihazınızın tarayıcısında açmak için uygulamadan çıkmak üzeresiniz. Devam etmek istiyor musunuz?</p> <p><b>{url}</b></p>';
$string['core.whyisthishappening'] = 'Bu neden oluyor?';
$string['core.wsfunctionnotavailable'] = 'Web hizmeti işlevi kullanılamıyor.';
$string['core.youreoffline'] = 'Çevrimdışısınız';
$string['core.youreonline'] = 'Tekrar çevrimiçisiniz';
$string['core.zoomin'] = 'Yakınlaşır';
$string['core.zoomout'] = 'Uzaklaştır';
$string['freemium.biometriclogin'] = 'Biyometrik giriş';
$string['freemium.biometriclogindescription'] = 'Parmağınızı parmak izi okuyucusuna yerleştirin.';
$string['freemium.biometricloginenablefaceid'] = 'FaceID\'yi etkinleştir';
$string['freemium.biometricloginenablefingerprint'] = 'Parmak İzini Etkinleştir';
$string['freemium.biometricloginenabletouchid'] = 'TouchID\'yi Etkinleştir';
$string['freemium.biometricloginloginwithfaceid'] = 'Yüz tanıma ile girin';
$string['freemium.biometricloginloginwithfingerprint'] = 'Parmak İzi ile Giriş';
$string['freemium.biometricloginloginwithtouchid'] = 'TouchID ile giriş yapın';
$string['freemium.biometricloginskip'] = 'Şimdilik atla';
$string['freemium.biometricloginsuccessfullyenabled'] = '{{ biometricMethod }} etkinleştirildi.';
$string['freemium.biometricloginturnoff'] = 'Bu özelliği istediğiniz zaman ayarlardan açıp kapatabilirsiniz.';
$string['freemium.biometriclogintypefaceid'] = 'Yüztanıma';
$string['freemium.biometriclogintypefingerprint'] = 'Parmakizi';
$string['freemium.biometriclogintypetouchid'] = 'Dokunmatik Kimlik';
$string['freemium.biometricloginwithfingerorface'] = 'Parmak iziniz veya yüzünüz ile biyometrik oturum açmayı kullanın.';
$string['freemium.change'] = 'Değiştir';
$string['freemium.coursesbatchdownloaddisabled'] = 'Kursların toplu olarak indirilmesi bu site için etkinleştirilmemiştir.';
$string['freemium.coursesdownloadlimitreached'] = 'Kurs indirme limitine ulaşıldı! Yalnızca {{limit}} kurs indirebilirsiniz, bu limiti artırmak veya indirilen bazı kursları cihazınızdan kaldırmak için yöneticinizle iletişime geçin.';
$string['freemium.downloadmainapplicationrequired'] = 'Bu siteye yalnızca özel uygulama ile bağlanabilirsiniz.';
$string['freemium.downloadmainapplicationsuggestion'] = 'Bağlanmaya çalıştığınız sitenin, deneyebileceğiniz özel bir uygulaması vardır.';
$string['freemium.feature_biometriclogin'] = 'Biyometrik giriş';
$string['freemium.feature_coursesdownload'] = 'İndirilen kurslar';
$string['freemium.feature_multimediapushnotifications'] = 'Multimedya anlık bildirimler';
$string['freemium.feature_pushnotificationsdevices'] = 'Anlık bildirim yapan cihazlar';
$string['freemium.feature_qrlogin'] = 'QR kodu kullanarak kimlik doğrulaması yapın';
$string['freemium.feature_remotethemes'] = 'Uzak temalar';
$string['freemium.feature_sitelogo'] = 'Site logosu';
$string['freemium.notallowed'] = 'İzin verilmiyor';
$string['freemium.nottoday'] = 'Bugün olmaz.';
$string['freemium.qrlogindisabled'] = 'QR kodu kullanan uygulamada kimlik doğrulama, <br> <br> {{url}} <br> <br> sitesi için etkinleştirilmedi';
$string['freemium.qrloginexpiredkey'] = 'QR kodunun süresi doldu. Lütfen sayfayı QR koduyla yenileyin ve tekrar tarayın.';
$string['freemium.qrloginipmismatch'] = 'Bağlanmak için kullandığınız cihaz, QR kodunu görüntüleyen cihazla aynı ağda görünmüyor. Lütfen her iki cihazın da aynı ağa bağlı olduğundan emin olun (örneğin, aynı WiFi ağı).<br> < br>Hata devam ederse, lütfen site yöneticinize başvurun.';
$string['freemium.ratetheapp'] = 'Uygulamamızı beğendiniz mi?';
$string['freemium.ratetheapp_feedbackko'] = 'Bize neyin yanlış gittiğini söyle';
$string['freemium.ratetheapp_feedbackmessage'] = 'Geri bildirimleriniz anonim olacaktır';
$string['freemium.ratetheapp_feedbackok'] = 'Geri bildirim gönder';
$string['freemium.ratetheapp_feedbackplaceholder'] = 'Buraya bir şeyler yaz';
$string['freemium.ratetheapp_feedbacksent'] = 'Teşekkürler! Görüşleriniz başarıyla gönderildi.';
$string['freemium.ratetheapp_sendtostore'] = 'Uygulamamızı değerlendirmek için bir dakikanızı ayırabilir misiniz? Bu, uygulamayı geliştirmemize katkı sağlayacaktır.';
$string['freemium.remindmelater'] = 'Remind me later';
$string['freemium.settingsoptionsfacial'] = 'Yüz tanıma ile oturum açmayı etkinleştir';
$string['freemium.settingsoptionsfingerprint'] = 'Parmak iziyle oturum açmayı etkinleştir';
$string['freemium.subscription'] = 'Site üyeliği';
$string['freemium.subscriptiondetails'] = 'Abonelik detayları';
$string['freemium.subscriptionfeature_exceeded_customlanguagestrings'] = '{{ overflowCount }} özel dil dizeleri yok sayılıyor';
$string['freemium.subscriptionfeature_exceeded_custommenuitems'] = '{{overflowCount}} özel menü öğesi yok sayılıyor';
$string['freemium.subscriptionfeature_exceeded_disabledfeatures'] = '{{ overflowCount }} yapılandırılmış devre dışı özellikler hala etkin';
$string['freemium.subscriptionfeature_exceeded_remotethemes'] = 'Özel temanız kullanılamıyor';
$string['freemium.subscriptionfeature_exceeded_sitelogo'] = 'Site logonuz kullanılamıyor';
$string['freemium.subscriptionfeature_limited'] = '{{limit}} ile sınırlıdır';
$string['freemium.subscriptionfeature_unlimited'] = 'Sınırsız';
$string['freemium.subscriptionplan'] = 'Abonelik planı';
$string['freemium.subscriptionplan_expired'] = 'süresi dolmuş';
$string['freemium.subscriptionplan_free'] = 'Ücretsiz';
$string['freemium.subscriptionplan_upgrade'] = 'Planınızı yükseltin';
$string['freemium.subscriptionplan_validuntil'] = '{{date}} tarihine kadar geçerlidir';
$string['freemium.subscriptionplandescription'] = 'Abonelik planları, bu site için hangi kısıtlamanın geçerli olduğunu gösterir.';
$string['freemium.subscriptionplanlearnmore'] = 'Daha fazla bilgi edin';
$string['freemium.upsell_renewexpired'] = 'Aboneliğinizin süresi doldu';
$string['freemium.upsell_renewexpiring'] = 'Aboneliğiniz {{ days }} gün içinde sona erecektir';
$string['freemium.upsell_renewtitle'] = 'Aboneliğinizi yenileyin';
$string['freemium.upsell_upgradefreeaccept'] = 'Yükselt';
$string['freemium.upsell_upgradefreemessage'] = 'Şu anda ücretsiz plandasınız, daha fazla özelliğin kilidini açmak için yükseltin.';
$string['freemium.upsell_upgradefreepostpone'] = 'Sonra';
$string['freemium.upsell_upgradefreetitle'] = 'Planınızı yükseltin';
$string['pluginname'] = 'Moodle Uygulama dil dizeleri';
$string['privacy_metadata'] = 'Bu eklenti herhangi bir kullanıcı verisi saklamaz.';
$string['workplace.teams.isoverdue'] = 'Gecikmiş veya son kullanma tarihi geçmiş ürünler var';
