<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'admin', language 'mn', version '4.5'.
 *
 * @package     admin
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessdenied'] = 'Хандалтыг татгалзсан';
$string['accounts'] = 'Хэрэглэгчийн эрх';
$string['addcategory'] = 'Ангилал нэмэх';
$string['additionalhtml'] = 'Нэмэлт HTML';
$string['additionalhtml_desc'] = 'Энэ тохиргоо нь хуудас бүрд таны нэмэхийг хүссэн HTML-ийг тодорхойлох боломжийг олгоно. Та хуудасны HEAD таг дотор BODY таг нээгдсэний эсвэл BODY таг хаагдахын яг өмнөхөн HTML-ийг тохируулах боломжтой.<br /> Ингэснээр хуудас бүр дээр тусгай толгой эсвэл хөл хэсгийг оруулах, эсвэл сонгосон загвараас үл хамааран Google Analytics шиг үйлчилгээг маш хялбархан нэмэх боломжийг олгоно.';
$string['additionalhtml_heading'] = 'Хуудас бүр дээр нэмэлт HTML нэмэгдэх болно.';
$string['additionalhtmlfooter'] = 'BODY хаагдахын өмнө';
$string['additionalhtmlfooter_desc'] = 'Энд агуулгыг үндсэн хэсгийн таг хаагдахаас өмнө хуудас бүр дээр нэмэх болно.';
$string['additionalhtmlhead'] = 'HEAD дотор';
$string['additionalhtmlhead_desc'] = 'Энд агуулгыг хуудас бүрийн HEAD тагийн доод хэсэгт нэмэх болно.';
$string['additionalhtmltopofbody'] = 'BODY нээгдсэн үед';
$string['additionalhtmltopofbody_desc'] = 'Энд агуулгыг үндсэн хэсгийн таг нээгдсэний дараа хуудас бүр дээр нэмэх болно.';
$string['admincategory'] = 'Ангилал: {$a}';
$string['adminseesall'] = 'Админ бүгдийг нь харна';
$string['adminseesallevents'] = 'Админ бүх арга хэмжээг харна';
$string['adminseesownevents'] = 'Админ нь бусад хэрэглэгчтэй адилхан байна';
$string['advancedfeatures'] = 'Нарийвчилсан боломжууд';
$string['agedigitalconsentverification'] = 'Зөвшөөрлийн дижитал насны баталгаажуулалт';
$string['agedigitalconsentverification_desc'] = 'Хэрэглэгчийн өөрийн бүртгэлийн бүртгүүлэх хуудсыг харуулахын өмнө зөвшөөрлийн дижитал насны баталгаажуулалтыг идэвхжүүлдэг. Энэ нь таны сайтад насанд хүрээгүй хүүхэд эцэг эх/асран хамгаалагчийн зөвшөөрөлгүйгээр бүртгүүлэхээс хамгаална. Тусламжийн талаар дэлгэрэнгүй мэдээллийг <a target="_blank" href="{$a}">Дэмжлэгийн холбоо барих</a>хэсэгт өгсөн болно.';
$string['ageofdigitalconsentmap'] = 'Зөвшөөрлийн дижитал нас';
$string['ageofdigitalconsentmap_desc'] = 'Энд зөвшөөрлийн дижитал өгөгдмөл нас эсвэл өгөгдмөл наснаас ялгаатай тухайн улсад тогтоосон насыг зааж өгнө. Нас бүрийг шинэ мөрөнд улсын код, нас (таслалаар тусгаарласан) гэсэн форматаар оруулна. Улсын кодын оронд * тэмдэг тавьж өгөгдмөл насыг заана. Улсын кодыг ISO 3166-2 стандартад тодорхойлсон байдаг.';
$string['allcountrycodes'] = 'Бүх улсын код';
$string['allowattachments'] = 'Файл хавсаргахыг зөвшөөрөх';
$string['allowbeforeblock'] = 'Зөвшөөрөгдсөн жагсаалтыг эхэлж боловсруулна';
$string['allowbeforeblockdesc'] = 'Өгөгдмөл тохиргоогоор блоколсон IP хаягийн жагсаалтын бичлэгийг эхэлж нийцүүлнэ. Энэ сонголтыг идэвхжүүлсэн тохиолдолд блоколсон жагсаалтаас өмнө зөвшөөрөгдсөн IP хаягийн жагсаалтын бичлэгийг боловсруулна.';
$string['allowcategorythemes'] = 'Ангиллын загварыг зөвшөөрөх';
$string['allowcohortthemes'] = 'Кохорт загварыг зөвшөөрөх';
$string['allowcoursethemes'] = 'Хичээлийн загварыг зөвшөөрөх';
$string['allowedemaildomains'] = 'Зөвшөөрөгдсөн цахим шуудангийн домэйн';
$string['allowediplist'] = 'Зөвшөөрөгдсөн IP хаягийн жагсаалт';
$string['allowemailaddresses'] = 'Зөвшөөрөгдсөн цахим шуудангийн домэйн';
$string['allowemojipicker'] = 'Дүрс тэмдэг сонгох хэсэг';
$string['allowframembedding'] = 'Фрэйм эмбед хийхийг /оруулахыг/ зөвшөөрөх';
$string['allowframembedding_help'] = 'Publish as LTI tool\' бүртгэлийн програм ашиглаж байгаа тохиолдолд энэхүү вэб хуудсыг алсын зайн систем дэх хүрээнд байршуулж, нийтлэхээр тохируулж болно. Өөр бусад тохиолдолд аюулгүй байдлаа хангах үүднээс "хүрээнд байршуулж нийтлэх" сонголтыг идэвхгүйгээр тохируулах хэрэгтэй. Гар утсан дээрх хэрэглээний програмын хувьд энэ тохиргоог хийдэггүй буюу "хүрээнд байршуулж нийтлэх" сонголт үргэлж нээлттэй байдаг.';
$string['allowguestmymoodle'] = 'Зочин хэрэглэгчид самбар харуулахыг зөвшөөрөх';
$string['allowindexing'] = 'Хайлтын системээр индекслэхийг зөвшөөрөх';
$string['allowindexing_desc'] = 'Энэ хэсэгт хайлтын хөтөч дээр танай вэб хуудсыг зааж өгөх эсэхийг тодорхойлно. "Everywhere" гэвэл хайлтын хөтөч танай нэвтрэх, бүртгүүлэх бүх хуудас дотор хайх буюу Force Login тохиргоо нь асаалттай хуудсууд ч хайлтын хөтөч дээр гарч ирнэ гэсэн үг. Бүртгэлийн хуудсаа хуурамж халдлагаас хамгаалахын тулд "Everywhere except login and signup pages" тохиргоог сонгоорой. "Nowhere" гэвэл хайлтын програм танай аль ч хуудсыг илрүүлж заахгүй. Гэхдээ энэ нь вэб хуудасны дээд талд байрлах тэмдэг төдий гэдгийг санаарай. Тэмдгийг дагах эсэхийг хайлтын систем өөрөө шийддэг.';
$string['allowindexingeverywhere'] = 'Хаана ч';
$string['allowindexingexceptlogin'] = 'Нэвтрэх болон бүртгүүлэх хуудаснаас бусад бүх газар';
$string['allowindexingnowhere'] = 'Хаана ч биш';
$string['allowobjectembed'] = 'EMBED болон OBJECT тагуудыг зөвшөөрөх';
$string['allowthemechangeonurl'] = 'URL дээр өмсгөл өөрчлөхийг зөвшөөрөх';
$string['allowuserblockhiding'] = 'Хэрэглэгчдэд блокийг нуух зөвшөөрөл олгох';
$string['allowusermailcharset'] = 'Хэрэглэгчид тэмдэгтийн фонтны кодыг сонгохыг зөвшөөрөх';
$string['allowuserswitchrolestheycantassign'] = 'Уялтын роль боломжгүй хэрэглэгдэд ролио солихыг зөвшөөрөх';
$string['allowuserthemes'] = 'Хэрэглэгчийн загварыг зөвшөөрөх';
$string['alternativefullnameformat'] = 'Өөр бүтэн нэр харуулах хэлбэр';
$string['alternativefullnameformat_desc'] = 'Бүтэн нэрээр харах тохируулгаар (менежер, багш, тохиргоо хийх эрхгүй багш нар зэрэг албан тушаалтнууд) хэрэглэгчдэд нэрсийг ямар байдлаар харуулахыг энд зааж өгнө. Нэр бичих талбарт "Full name format" тохиргоог сонгоно.';
$string['always'] = 'Хэзээд';
$string['appearance'] = 'Харагдах байдал';
$string['aspellpath'] = 'Аспел руу очих зам';
$string['authentication'] = 'Баталгаажуулалт';
$string['authpreventaccountcreation'] = 'Нэвтрэлт танилтын үед данс үүсгэлтийг урьдчилан сэргийлэх';
$string['authpreventaccountcreation_help'] = 'Өмнө бүртгүүлж байгаагүй шинэ хэрэглэглэгч тогтоогдсон даруй вэб сайт түүний дансыг автоматаар нээнэ. Бүртгэлтэй хэрэглэгчийг танихдаа LDAP зэрэг гадны өгөгдлийн сан ашиглаж байгаа тохиолдолд хэрэглэгч давхар бүртгэл үүсгэхээс сэргийлэхийн тулд энэ тохиргоог идэвхжүүлэх хэрэгтэй. Ингэснээр шинэ дансыг гараар, эсвэл хэрэглэгчийн мэдээллийг шилжүүлэн татах аргаар л үүсгэх боломжтой болно. Энэ тохиргоо MNet таних програмд ажиллахгүй болохыг анхаарна уу.';
$string['authsettings'] = 'Нэвтрэлт танилтыг удирдах';
$string['autolang'] = 'Хэлийг автоматаар илрүүлэх';
$string['autolangusercreation'] = 'Бүртгэл үүсгэхдээ хэрэглэгчийн хөтчийн хэлийг хэрэгцээт хэлээр тохируулах';
$string['autologinguests'] = 'Автоматаар логин хийдэг зочид';
$string['availableto'] = 'Эдгээрт боломжтой';
$string['availabletoanyone'] = 'Энэ сайтад зочилсон хүн бүрд боломжтой';
$string['availabletoauthenticated'] = 'Баталгаажсан хэрэглэгчдэд хязгаарлагдмал';
$string['backgroundcolour'] = 'Тунгалаг өнгө';
$string['backup_shortname'] = 'Хичээлийн нэрийг Нөөц файлын нэрд ашиглах';
$string['backup_shortnamehelp'] = 'Хичээлийн нэрийг Нөөц файлын нэрийн хэсгээр ашиглах';
$string['backups'] = 'Нөөцүүд';
$string['badwordsconfig'] = 'Таслалаар тусгаарлагдсан муу үгсийн жагсаалтаа оруулна уу.';
$string['badwordsdefault'] = 'Хэрвээ жагсаалт хоосон бол хэлний файлаас стандарт утга хэрэглэгдэнэ.';
$string['badwordslist'] = 'Муу үгсийн жагсаалт';
$string['blockediplist'] = 'Хязгаарлагдсан IP хаягууд';
$string['blockinstances'] = 'Тохиолдол';
$string['blockmultiple'] = 'Олон';
$string['blockprotect'] = 'Санамсаргүй үйлдлүүдээс сэргийлэх';
$string['blockprotect_help'] = 'Хэрэв та аль нэг хэсгийг түгжвэл өөр хэн нэгэн санамсаргүйгээр өөрчлөх юмуу устгах боломжгүй болно. (Тухайн хэсгийг засах, тохируулах шаардлага гарвал та мэдээж түгжээгээ буцааж нээх боломжтой). Энэ нь нэгэнт устгагдчихвал нөхөн сэргээхэд хамгийн хэцүү шилжилт, тохиргоо хийх хэсгүүдийг хамгаалах зорилготой юм.';
$string['blockprotectblock'] = '{$a} тохиолдлыг хамгаалах';
$string['blockprotected'] = '{$a} блокийн тохиолдлыг хамгаалсан.';
$string['blocksettings'] = 'Хэсгүүдийг удирдах';
$string['blockunprotect'] = 'Хамгаалагдахгүй';
$string['blockunprotectblock'] = '{$a} тохиолдлын хамгаалалтыг цуцлах';
$string['blockunprotected'] = '{$a} блокийн тохиолдол хамгаалалтгүй байна.';
$string['bloglevel'] = 'Блогийн харагдац';
$string['bookmarkadded'] = 'Тэмдэглэгээ нэмэгдсэн.';
$string['bookmarkalreadyexists'] = 'Та энэ хуудсыг өмнө нь тэмдэглэчихсэн байна.';
$string['bookmarkdeleted'] = 'Тэмдэглэгээ устлаа.';
$string['bookmarkthispage'] = 'Энэ хуудсыг тэмдэглэх';
$string['cacheapplication'] = 'Аппын кэш';
$string['cacheapplicationhelp'] = 'Кэшлэгдсэн зүйлс нь бүх хэрэглэгчдийн дунд хуваалцагдах ба тодорхойлсон наслалтын цагаар дуусгавар болдог.';
$string['cachejs'] = 'Javascript кэш';
$string['cachejs_help'] = 'Javascript хадгалах, нягтруулах үйлдэл нь хуудас татаж нээх ажиллагааг ихээр хөнгөвчилдөг. Хөгжүүлэлт хийж буй вэб хуудсуудад бол маш хэрэгтэй тохиргоо. Харин вэб хуудас зохиогчид энэ тохиргоог идэвхжүүлэх сонирхолгүй л байх болов уу.';
$string['cacherequest'] = 'Хадгалах хүсэлт';
$string['cacherequesthelp'] = 'Хүсэлт биелсэн даруй хаагддаг хэрэглэгчид зориулсан хадгалах үйлдэл. Бидний байнгын санах ой ашиглаж байгаа хэсгүүдийг орлох зорилготой байдаг.';
$string['cachesession'] = 'Хичээл хадгалах хүсэлт';
$string['cachesessionhelp'] = 'Хичээл дууссан даруй хаагддаг хэрэглэгчид зориулсан хадгалах үйлдэл. Хичээл нээсэн үед програм хэт ачаалах/гацах зэргээс сэргийлэх зорилготой.';
$string['cachesettings'] = 'Хадгалах тохиргоо';
$string['cachetemplates'] = 'Хадгалах загвар';
$string['cachetemplates_help'] = 'Хадгалалтын тохиргоо нь хуудас татаж нээх ажиллагааг ихээхэн хөнгөвчилдөг тул хөгжүүлэлт хийж буй вэб сайтуудад зайлшгүй шаардлагатай. Харин вэб хуудас зохиогчид энэ тохиргоог идэвхжүүлэх сонирхолгүй л байх болов уу.';
$string['caching'] = 'Көүчинг';
$string['calendar_weekend'] = 'Амралтын өдөр';
$string['calendarexportsalt'] = 'Хуанли экспортлох salt';
$string['calendarsettings'] = 'Хуанли';
$string['calendartype'] = 'Кальендарын төрөл';
$string['calendartype_desc'] = 'Вэб хуудасны хуанлийн төрлийг сонго. Энэ тохиргоог хичээл тус бүрт юмуу хэрэглэгч өөртөө тааруулан тохируулах боломжтой.';
$string['cannotdeletemodfilter'] = '{$a->filter}\' нь \'{$a->module}\' модулийн хэсэг тул та арилгаж/устгах боломжгүй.';
$string['cannotuninstall'] = '{$a} - ыг арилгаж/устгаж болно.';
$string['categoryemail'] = 'И-мэйл';
$string['cfgwwwrootslashwarning'] = 'config.php файлд $CFG->wwwroot - ийн нэршил буруу байна. Сүүлд нь байгаа \'/\' тэмдэгтийг хасах хэрэгтэй.';
$string['cfgwwwrootwarning'] = 'config.php файлд $CFG->wwwroot - ийн нэршил буруу байна. Энэ хуудсанд хандаж байгаа таны URL хаягтай ижил байх ёстой.';
$string['change'] = 'Өөрчлөх';
$string['checkboxno'] = 'Үгүй';
$string['checkboxyes'] = 'Тийм';
$string['checkupgradepending'] = 'Шинэчил';
$string['choosefiletoedit'] = 'Файлаа сонгон засварлах';
$string['cleanup'] = 'Цэвэрлэх';
$string['clianswerno'] = 'n';
$string['cliansweryes'] = 'y';
$string['cliexitgraceful'] = 'Гарч байна. Түр хүлээнэ үү ...';
$string['cliexitnow'] = 'ЯГ ОДОО гарч байна';
$string['cliincorrectvalueerror'] = 'Алдаа! "{$a->option}" - ийн "{$a->value}" утга буруу байна.';
$string['cliincorrectvalueretry'] = 'Буруу утга, дахин оролдоно уу';
$string['clistatusdisabled'] = 'Төлөв: идэвхгүй';
$string['clistatusenabled'] = 'Төлөв: идэвхтэй';
$string['clistatusenabledlater'] = 'Тайлбар: даалгавар бичих мөр (CLI)-ийг засварлах төлвийг {$a}-р идэвхжүүлнэ.';
$string['clitypevalue'] = 'утга бичих';
$string['clitypevaluedefault'] = 'Утга бич, эсвэл Enter дарж ({$a}) тогтмол утга сонго.';
$string['cliunknowoption'] = 'Танихгүй сонголтууд:
{$a}
Тусламж хэсгийг сонгоно уу.';
$string['cliupgradecompletenomaintenanceupgrade'] = 'Хэрэглэгчийн урсгалыг шинэ кодод шилжүүлсний дараа үлдсэн кэшийг цэвэрлэхийн тулд:

   php admin/cli/purge_caches.php --muc
   php admin/cli/purge_caches.php --js
   php admin/cli/purge_caches.php - шүүлтүүр
   php admin/cli/purge_caches.php --бусад

Та веб серверийн ачааллыг багасгахын тулд цэвэрлэгээг тусад нь, команд хооронд хийх хэрэгтэй.';
$string['cliupgradedefault'] = 'Шинэ тохируулга: {$a}';
$string['cliupgradedefaultheading'] = 'Шинэ тогтмол утга тохируулж байна.';
$string['cliupgradedefaultverbose'] = 'Шинэ тохируулга: {$a->name}, Тогтмол утга: {$a->defaultsetting}';
$string['cliupgradefinished'] = 'Командын мөрийг {$a->oldversion} хувилбараас {$a->newversion} болгон амжилттай шинэчиллээ.';
$string['cliupgrademaintenancenotrequired'] = 'Энэхүү шинэчлэл нь хэрэглэгчийг засвар үйлчилгээний горимд ШИЛЖҮҮЛЭХГҮЙ.';
$string['cliupgrademaintenancerequired'] = 'Энэхүү шинэчлэл нь хэрэглэгчийг засвар үйлчилгээний горимд ШИЛЖҮҮЛЭХ БОЛНО.';
$string['cliupgradenoneed'] = 'Одоо суулгасан байгаа {$a} хувилбарыг шинэчлэх шаардлагагүй байна. Хандсанд баярлалаа!';
$string['cliupgradepending'] = 'Шинэчлэх ажил хүлээгдэж байна.';
$string['cliupgradesetlock'] = 'Шинэчлэлтийг зөвхөн CLI гүйцэтгэхээр түгжсэн.';
$string['cliupgradeunsetlock'] = 'Хийгдэж буй CLI гүйцэтгэлийн шинэчлэлтийн түгжээг устгасан.';
$string['cliyesnoprompt'] = 'y (гэвэл Тийм) n (гэвэл Үгүй)';
$string['close'] = 'Хаах';
$string['cohort_customfield'] = 'Кохорт тусгай талбарууд';
$string['commentsperpage'] = 'Нэг хуудсанд харагдах сэтгэгдэл';
$string['commonactivitysettings'] = 'Түгээмэл тохиргоо';
$string['commonfiltersettings'] = 'Түгээмэл шүлтүүрийн тохиргоо';
$string['commonsettings'] = 'Түгээмэл тохиргоо';
$string['componentinstalled'] = 'Бүрэлдэхүүн хэсгийг суулгасан';
$string['computedfromlogs'] = '{$а} хойших лог бүртгэлээс тооцоолсон.';
$string['condifmodeditdefaults'] = 'Өгөгдмөл утгыг шинэ үйл ажиллагаа эсвэл нөөц үүсгэх үед тохиргооны маягтад ашигладаг.';
$string['confeditorhidebuttons'] = 'HTML засварлагч дээр нууцлах товчлуурыг сонгоно.';
$string['configallcountrycodes'] = 'Энэ нь хэрэглэгчийн профайл зэрэг төрөл бүрийн газарт сонгож болох улс орнуудын жагсаалт юм. Хоосон (өгөгдмөл тохиргоогоор) тохиолдолд countries.php дахь жагсаалтыг стандарт англи хэлний багцыг ашиглана. Энэ бол ISO 3166-1 стандартын жагсаалт болно. Эсвэл та \'GB,FR,ES\' гэх мэтээр таслалаар тусгаарласан жагсаалтыг үүсгэж болно. Хэрэв та энд стандарт бус шинэ код нэмбэл тэдгээрийг countries.php файлын \'en\' болон өөрийн хэлний багцад нэмэх шаардлагатай.';
$string['configallowassign'] = 'Зүүн талын баганад байгаа үүрэг тус бүрээр бусдад ямар үүрэг оноохыг сонгоно.';
$string['configallowattachments'] = 'Идэвхжүүлсэн тохиолдолд сайтаас илгээсэн цахим шуудан нь ялгах тэмдэг гэх мэт хавсралттай байж болно.';
$string['configallowcategorythemes'] = 'Үүнийг идэвхжүүлсэн тохиолдолд ангиллын түвшинд загварыг тохируулах боломжийг олгоно. Энэ нь хэрэглэгч өөрийн загварыг тусгайлан сонгоогүй тохиолдолд бүх дэд ангилал болон хичээлд нөлөөлнө. АНХААРУУЛГА: Ангиллын загварыг идэвхжүүлэх нь гүйцэтгэлд нөлөөлж болзошгүй.';
$string['configallowcohortthemes'] = 'Үүнийг идэвхжүүлсэн тохиолдолд загварыг кохортын түвшинд тохируулах боломжтой болно. Энэ нь зөвхөн нэг кохортын эсвэл ижил загвар бүхий нэгээс олон кохортын бүх хэрэглэгчид нөлөөлнө.';
$string['configallowcoursethemes'] = 'Идэвхжүүлсэн тохиолдолд хичээлд өөрийн гэсэн загварыг тохируулан ашиглах боломжийг олгоно. Хичээлийн загвар нь бусад бүх загварын сонголтыг (сайт, хэрэглэгч, ангилал, кохорт эсвэл URL хаягаар тодорхойлсон загвар) хүчингүй болгоно.';
$string['configallowedemaildomains'] = 'Илгээх боломжтой цахим шуудангийн домэйны жагсаалт нь илгээх цахим шуудангийн "From" хэсэгт байна. "Empty" өгөгдмөл тохиргоог илгээх бүх захидалд хариулах боломжгүй хаягаас илгээхэд ашиглана. * гэх мэт хөрвөх тэмдэгт ашиглахыг зөвшөөрнө.  example.com нь example.com домэйноос бус, түүний дурын дэд домэйноос цахим шуудан илгээх боломжийг олгоно. Энэ нь тусдаа оролтыг шаардана.';
$string['configallowemailaddresses'] = 'Цахим шуудангийн шинэ хаягийг тодорхой домэйноор хязгаарлахын тулд тэдгээрийг сул зайгаар тусгаарлан энд жагсаана. Бусад бүх домэйноос татгалзах болно. Дэд домэйныг зөвшөөрөхийн тулд урдаа \'.\' тэмдэгтэй домэйныг нэмнэ. Үндсэн домэйныг түүний дэд домэйны хамт зөвшөөрөхийн тулд домэйныг хоёр удаа нэмнэ. Ингэхдээ эхлээд урдаа \'.\' тэмдэгтэйгээр дараа нь тэмдэггүйгээр нэмнэ. Жишээ нь .ourcollege.edu.au ourcollege.edu.au.';
$string['configallowemojipicker'] = 'Эмож сонгогч нь хэрэглэгчид Atto хэрэгслийн мөрний эмож сонгогч товчлуураар дамжуулан зурвас болон бусад бичвэр талбарт инээмсэглэл зэрэг эмож сонгох боломжийг олгодог.';
$string['configallowemojipickerincompatible'] = 'Таны одоогийн өгөгдлийн сангийн тохиргоо нь эможийг зохих ёсоор нь дэмждэггүй. Эмож сонгох хэсгийг идэвхжүүлэхийн тулд <a href="https://docs.moodle.org/en/MySQL_full_unicode_support">юникод бүрэн дэмждэг байхаар өгөгдлийн сангаа шинэчлэх шаардлагатай</a>.';
$string['configallowguestmymoodle'] = 'Идэвхжүүлсэн тохиолдолд зочид хяналтын самбарт хандах боломжтой болно. Эсрэг  тохиолдолд зочдыг сайтын нүүр хуудсанд шилжүүлнэ.';
$string['configallowobjectembed'] = 'Аюулгүй байдлын өгөгдсөл арга хэмжээний тухайд энгийн хэрэглэгчдийг HTML дотор EMBED, OBJECT тагийг ашиглан бичвэрт мультимедиа эмбед (флаш гэх мэт) хийхийг зөвшөөрдөггүй  (үүнийг mediaplugins шүүлтүүр ашиглан аюулгүйгээр хийх боломжтой боловч). Эдгээр тагийг зөвшөөрөхийг хүсвэл уг тохиргоог идэвхжүүлэх хэрэгтэй.';
$string['configallowoverride'] = 'Та зүүн талд байгаа үүрэг бүхий хүмүүст зарим баганын эрхийг хүчингүй болгохыг  зөвшөөрөх боломжтой.';
$string['configallowoverride2'] = 'Зүүн талын багана дахь үүрэг бүрээр тэдгээр нь хүчингүй болгох тохиргоо хийх эрхийг  сонгоно.<br />Хэрэглэгчид moodle/role:override эсвэл moodle/role:safeoverride үүрэгтэй байх шаардлагатай.';
$string['configallowswitch'] = 'Зүүн талын багана дахь эрх бүрээр шилжих боломжтой эрхийг сонгоно.<br/>Хэрэглэгчид moodle/role:switchroles эрхтэй байх ёстой.';
$string['configallowthemechangeonurl'] = 'Идэвхжүүлсэн тохиолдолд загварыг дурын Moodle URL хаягт <br />?theme=themename (жишээ нь: mymoodlesite.com/?theme=afterburner ) эсвэл дурын дотоод Moodle URL хаягт (жишээ нь: mymoodlesite.com/course/view.php?id=2&theme=afterburner) нэмснээр өөрчлөх боломжтой.';
$string['configallowuserblockhiding'] = 'Та хэрэглэгчдэд энэ сайтын хажуугийн блокуудыг нуух/харуулахыг зөвшөөрч байна уу? Уг тохиргоо нь эвхэгддэг блок тус бүрийн төлөвийг санахын тулд жаваскрипт болон күүки ашигладаг ба зөвхөн хэрэглэгчийн өөрийнх нь харагдацад нөлөөлдөг.';
$string['configallowusermailcharset'] = 'Идэвхжүүлсэн тохиолдолд хэрэглэгч зурвасын тохиргоондоо цахим шуудангаар харилцах тэмдэгтийн кодыг сонгох боломжтой болно.';
$string['configallowuserswitchrolestheycantassign'] = 'Өгөгдмөл тохиргоогоор хэрэглэгчийн эрхийг өөрчлөхөд moodle/role:assign шаарддаг. Уг тохиргоог идэвхжүүлснээр дээрх шаардлагыг устгаж, зөвхөн "Эрх хуваарилалтыг зөвшөөрөх" хүснэгтийн тохиргоогоор тодорхойлогддог "Эрх өөрчлөх" нээгдэх цэсэд буй боломжит эрхийг харуулна.
"Эрх хуваарилалтыг зөвшөөрөх" хүснэгт дэх тохиргоог хэрэглэгчид оноосон эрхээс нь илүү давуу эрх рүү шилжихийг зөвшөөрөхгүй байхаар тохируулахыг зөвлөж байна.';
$string['configallowuserthemes'] = 'Үүнийг идэвхжүүлсэн тохиолдолд хэрэглэгч өөрийн загварыг тохируулах боломжтой болно. Хэрэглэгчийн загвар нь сайтын загварыг хүчингүй болгоно (гэхдээ хичээлийн загвар биш)';
$string['configallowview'] = 'Зүүн баганад байгаа үүрэг бүрийн хувьд харах, хайх, шүүх боломжтой үүргүүдийг сонгоно.';
$string['configallusersaresitestudents'] = 'Сайтын нүүр хуудас дээрх үйл ажиллагаанд БҮХ хэрэглэгчийг суралцагч хэмээн тооцох эсэх? Хэрэв тийм бол бүртгэл бүхий хүн бүр эдгээр үйл ажиллагаанд суралцагч байдлаар оролцохыг зөвшөөрнө. Харин үгүй бол зөвхөн хамгийн багадаа нэг хичээлд хамрагдсан хэрэглэгч л эдгээр үйл ажиллагаанд оролцох боломжтой байна. Зөвхөн админ болон тусгайлан томилогдсон багш нар сайтын нүүр хуудас дээрх үйл ажиллагаанд багшаар ажиллах боломжтой.';
$string['configauthenticationplugins'] = 'Ашиглахыг хүсэж буй баталгаажуулалтын нэмэлт хэрэгслийг сонгож, эрэмбэлнэ үү.';
$string['configautolang'] = 'Хөтчийн тохиргооноос өгөгдмөл хэлийг таньж илрүүлэх ба идэвхжүүлээгүй тохиолдолд сайтад өгөгдмөл хэлийг ашиглана.';
$string['configautolangusercreation'] = 'Идэвхжүүлсэн тохиолдолд хэрэглэгчийн бүртгэлийг анх нэвтрэхэд нь автоматаар үүсгэж (жишээ нь LDAP эсвэл OAuth 2 баталгаажуулалт ашиглан), хэрэглэгчийн хөтчийн хэлийг тэдний сонгосон хэлээр тохируулна. Эсрэг тохиолдолд сайтын өгөгдмөл хэлийг хэрэглэгчийн сонгосон хэлээр тохируулна.';
$string['configautologinguests'] = 'Зочин байдлаар бүртгүүлсэн хэрэглэгч хичээл рүү орох үед автоматаар зочноор нэвтэрвэл зохистой юу?';
$string['configbloglevel'] = 'Энэ тохиргоо нь хэрэглэгчийн блог уг сайт дээрх харагдах түвшинг хязгаарлах боломжийг олгоно. Тэд зурагт хуудас эсвэл блогийн төрлийг бус, УНШИГЧ дахь хамгийн их утгыг тодорхойлдог болохыг анхаарна уу. Блогийг шаардлагагүй гэж үзвэл бүр идэвхгүй болгох боломжтой.';
$string['configcalendarcustomexport'] = 'Хуанлийг тогтсон огнооны мужаар экспортлох боломжтой болгох';
$string['configcalendarexportsalt'] = 'Энэхүү санамсаргүй бичвэрийг хуанлийг экспортлох үед ашигладаг баталгаажуулалтын токены аюулгүй байдлыг сайжруулахад ашигладаг. Хэрэв уг хэш тэмдэгт мөрийг өөрчилбөл одоогийн бүх токен хүчингүй болохыг анхаарна уу.';
$string['configcookiesecure'] = 'Сервер нь зөвхөн http холболтыг хүлээж авч байгаа тохиолдолд аюулгүй күүки илгээхийг идэвхжүүлэхийг зөвлөж байна. Идэвхжүүлсэн тохиолдолд веб сервер нь http:// хүлээж авахгү, эсвэл https:// хаяг руу дахин чиглүүлэхээр тохируулж, HSTS хэсэгт илгээж байгаа эсэхийгнягтална уу. <em>wwwroot</em> хаяг https:// гэж эхлээгүй бол энэ тохиргоо хамаарахгүй.';
$string['configcountry'] = 'Хэрэв энд улсаа тохируулбал шинэ хэрэглэгчийн бүртгэлд уг улсыг өгөгдмөл улсаар сонгогдоно. Хэрэглэгчээр улсыг нь албаар сонгуулахын тулд үүнийг тохируулахгүй орхино.';
$string['configcoursegraceperiodafter'] = 'Хичээл дуусах өдрөөс хойших олон хоногийн өмнөх хичээлүүдийг явагдаж байгаагаар ангилна.';
$string['configcoursegraceperiodbefore'] = 'Хичээл эхлэх өдрөөс өмнөх олон хоногийн цаашдын хичээлүүдийг явагдаж байгаагаар ангилна.';
$string['configcourseoverviewfilesext'] = 'Зөвшөөрөгдсөн хичээлийн зургийн файлын өргөтгөлийг таслалаар тусгаарласан жагсаалт.';
$string['configcourseoverviewfileslimit'] = 'Хичээлийн жагсаалтын хуудасны хичээлийн танилцуулга хэсгийн хажууд харуулах файлын хамгийн их тоо. Хамгийн эхэнд оруулсан зургийн файлыг хэрэглэгчийн хяналтын самбар дээрх хичээлийн танилцуулгад хичээлийн зураг болгон ашиглана. Дурын нэмэлт файл нь зөвхөн хичээлийн жагсаалтын хуудас дээр харагдана.';
$string['configcourserequestnotify'] = 'Хэрэглэгч шинэ хичээл хүссэн үед мэдэгдэх хэрэглэгчийн нэрийг бичнэ.';
$string['configcourserequestnotify2'] = 'Хичээл хүсэх үед мэдэгдэх хэрэглэгчид. Энд зөвхөн хичээлийн хүсэлтийг баталж чадах  хэрэглэгчийг жагсааж бичнэ.';
$string['configcoursesperpage'] = 'Хичээлийн жагсаалтад нэг хуудсанд харуулах хичээлийн тоог оруулна.';
$string['configcourseswithsummarieslimit'] = 'Энгийн жагсаалтад оруулахаас өмнө тойм бүхий хичээлийн жагсаалтад харуулах хичээлийн хамгийн их тоо.';
$string['configcronclionly'] = 'Веб хөтчөөс кроныг ажиллуулах нь нэрээ нууцалсан хэрэглэгчид давуу эрхтэй мэдээллийг харуулж болно. Иймд зөвхөн командын мөрөөс кроныг ажиллуулах эсвэл алсаас нэвтрэх тохиолдолд кроны нууц үгийг тохируулахыг зөвлөж байна.';
$string['configcronremotepassword'] = 'Энэ нь <pre> https://site.example.com/admin/cron.php?password=opensesame </pre>  URL хаягийг ашиглан нууц үг оруулахгүйгээр cron.php скриптийг веб хөтчөөс ажиллуулах боломжгүй гэсэн үг юм. Хэрэв үүнийг хоосон орхивол нууц үг шаардахгүй.';
$string['configcurlcache'] = 'cURL кэшийг ашиглах хугацаа, секундээр.';
$string['configcustommenuitems'] = 'Энд тусгай цэсийг тохируулж болно. Цэсийн зүйл бүрийг дараах форматаар шинэ мөрөөр оруулна. Үүнд: цэсийн бичвэр, холбоосын URL хаяг (сонголтоор, дэд зүйлтэй дээд түвшний цэсийн зүйлд хамаарахгүй), хэрэгслийн гарчиг (сонголтоор) болон хэлний код эсвэл таслалаар тусгаарласан кодын жагсаалт (сонголтоор, зөвхөн заасан хэлний хэрэглэгчид мөрийг харуулахад зориулагдсан), босоо зураасаар тусгаарласан. Зураасаар эхэлсэн мөр нь өмнөх дээд түвшний цэсэд цэсийн зүйл болж гарах ба ### нь хуваагч болно. Жишээлбэл:
<pre>
Хичээлүүд
-Бүх хичээл|/хичээл/
-Хичээл хайх|/course/search.php
-###
-FAQ|https://example.org/faq
-Preguntas más frecuentes|https://example.org/pmf||es
Мобайл аппликейшн|https://example.org/app|Манай аппликейшнг татаж авна уу
</pre>';
$string['configcustomusermenuitems'] = 'Та хэрэглэгчийн цэсийн агуулгыг тохируулах боломжтой (автоматаар нэмэгддэг холбоосыг эс тооцвол). Мөр бүр нь босоо зураасаар тусгаарлагдах бөгөөд 1) "langstringname, componentname" хэлбэрээр эсвэл энгийн бичвэр хэлбэрээрх тэмдэгт мөр, 2) URL хаянаас бүрдэнэ. Шаардлагатай хэсэгт нэг буюу хэд хэдэн # тэмдэгтийн мөрийг нэмэх байдлаар хуваагчийг ашиглаж болно.';
$string['configdbsessions'] = 'Идэвхжүүлсэн тохиолдолд уг тохиргоо нь явагдаж буй сейшны талаарх мэдээллийг хадгалахын тулд өгөгдлийн санг ашиглах болно. Уг тохиргоог өөрчилснөөр одоогийн бүх хэрэглэгчийг (таныг оролцуулан) системээс гаргахыг анхаарна уу. Та MySQL ашиглаж байгаа бол my.cnf (эсвэл my.ini) дээрх \'max_allowed_packet\' нь хамгийн багадаа 4M байгаа эсэхийг шалгана уу. Бусад сейшны драйверыг config.php файлд шууд тохируулах боломжтой. Дэлгэрэнгүй мэдээллийг config-dist.php хэсгээс үзнэ үү. Та config.php файлд сейшн драйверийг зааж өгсөн тохиолддолд уг сонголт гарахгүй.';
$string['configdebug'] = 'Үүнийг идэвхжүүлбэл PHP-н error_reporting нэмэгдэж анхааруулга алдаанууд ихсэх болно.';
$string['configdebugdisplay'] = 'Энэ сонголтыг on дээр тохируулж идэвхжүүлснээр алдааны тайлан HTML хуудас руу илгээгдэнэ. Хэрэглэхэд хялбар боловч XHTML, JS, күүки ба HTTP нарыг эвддэг сөрөг талтай. Off дээр тохируулсан тохиолдолд хариуг таны сервер бүртгэлд илгээж хамгаалалтыг сайжруулахад туслана. PHP дэх error_log тохируулгаар хариуг аль бүртгэлд илгээхийг зааж өгнө.';
$string['configdebugpageinfo'] = 'Хуудасны мэдээллийг хуудасны доод хэсэгт харуулах эсэхийг зааж өгнө.';
$string['configdebugvalidators'] = 'Хуудасны доод хэсэгт гадаад баталгаажуулагч серверт хөтлөх холбоос оруулах эсэхийг заана. Танд <em>w3cvalidator</em> нэрээр шинэ хэрэглэгчийн бүртгэл нээж, зочны эрх олгох шаардлага гарч болно. Эдгээр өөрчлөлт нь хэн нэгэн серверт зөвшөөрөлгүй нэвтрэх эрсдлийг үүсгэж болзошгүй тул хөгжүүлэлтийн хуудсанд идэвхжүүлж болохгүй.';
$string['configdefaulthomepage'] = 'Хэрэглэгч сайтад нэвтэрсний дараа аль хуудсанд шилжих шаардлагатай вэ? Түүнчлэн уг тохиргоо нь сонгодог загварт суурилсан хэрэглэгчдэд зориулсан удирдлагын эхний холбоосыг тодорхойлдог.';
$string['configdefaultrequestcategory'] = 'Системийн хамрах хүрээнд шинэ хичээлд хүсэлт гаргах боломжтой хэрэглэгчийн хүссэн хичээлийг хэрэглэгч өөр ангилал сонгох боломжгүй бол уг ангилалд оруулна.';
$string['configdefaultrequestedcategory'] = 'Хүссэн хичээлийг зөвшөөрсөн тохиолдолд оруулах өгөгдмөл ангилал.';
$string['configdefaultuserroleid'] = 'Нэвтэрсэн бүх хэрэглэгч энд тодорхойлсон дүрийн чадварыг сайтын түвшинд, өөрт нь өгсөн үүрэг дээр НЭМЖ өгөх болно. Өгөгдмөл үүрэг нь Баталгаажсан хэрэглэгчийн үүрэг болно. Чадварыг хориглоогүй тохиолдолд энэ нь тэдний бусад үүрэгтэй зөрчилдөхгүй, зөвхөн бүх хэрэглэгчид хичээлийн түвшинд хуваарилах боломжгүй чадварыг (жишээ нь блогт бичлэг оруулах, өөрийн хуанлигаа удирдах гэх мэт) байгаа эсэхийг баталгаажуулна.';
$string['configdeleteincompleteusers'] = 'Энэ хугацааны дараа нэр, овог, цахим шуудангийн хаягийн талбарыг бөглөөгүй дурын бүртгэл устгагдах болно.';
$string['configdeleteunconfirmed'] = 'Цахим шуудангаар өөрийгөө бүртгүүлэх зэрэг баталгаажуулалтын тодорхой аргуудын хувьд хэрэглэгч тодорхой хугацааны дотор бүртгэлээ баталгаажуулах ёстой. Энэ хугацаанаас хойш баталгаажаагүй дурын хуучин бүртгэл устах болно.';
$string['configdenyemailaddresses'] = 'Тодорхой домэйны цахим шуудангийн хаягаас татгалзахын тулд тэдгээр домэйны нэрийг энд ижил аргаар жагсаана. Дэд домэйнээс татгалзахын тулд <strong>hotmail.com yahoo.co.uk</strong> гэх мэтээр өмнөө \'.\' тэмдэгтэй домэйныг нэмнэ.';
$string['configdisableuserimages'] = 'Хэрэглэгчид өөрийн хэрэглэгчийн профайлын зургийг өөрчлөх боломжийг идэвхгүй болгоно.';
$string['configdisplayloginfailures'] = 'Энэ нь хэрэглэгчид өмнө нь нэвтэрч чадаагүй талаарх мэдээллийг харуулна.';
$string['configdndallowtextandlinks'] = 'Файлыг чирэх даралтаар зөөхийн зэрэгцээ хичээлийн хуудсанд бичвэр болон холбоосыг чирэх даралтаар зөөх үйлдлийг идэвхжүүлэх буюу идэвхгүй болгоно. Бичвэрийг Firefox эсвэл бусад хөтөч хооронд зөөх боломжгүй бөгөөд энэ нь өгөгдөл байршуулагдахгүй эсвэл байршуулсан бичвэр эвдэрч болзошгүйг анхаарна уу.';
$string['configdoclang'] = 'Уг хэлийг баримт бичгийн хуудасны холбоосуудад ашиглана.';
$string['configdocroot'] = 'Хуудас бүрийн доод хэсэгт байрлах \'Тусламж ба баримтжуулалт\' холбоосоор дамжуулан тодорхой сэдвээрх баримтжуулалтын Moodle Docs руу хандах замыг тодорхойлно. Талбарыг хоосон орхивол холбоосууд харагдахгүй.';
$string['configdoctonewwindow'] = 'Идэвхжүүлсэн тохиолдолд Moodle Docs руу хандах холбоос шинэ цонхонд харагдах болно.';
$string['configduration_high'] = 'Энэ утга хэт их байна. Хамгийн их утга нь {$a} байна.';
$string['configduration_low'] = 'Энэ утга хэт бага байна. Хамгийн бага утга нь {$a} байна.';
$string['configeditordictionary'] = 'Үгийн алдаа шалгагч программд хэрэглэгчийн өөрийнх нь хэлний толь бичиг байхгүй тохиолдолд энэ утгыг ашиглана.';
$string['configeditorfontlist'] = 'Засварлагчийн нээгдэх жагсаалтад харагдах фонтуудыг сонгоно.';
$string['configemailchangeconfirmation'] = 'Хэрэглэгч өөрийн профайллд цахим шуудангийн хаягаа өөрчлөх үед цахим шуудангаар  баталгаажуулах алхмыг шаардана.';
$string['configemaildkimselector'] = 'DKIM сонгогч нь тохиолдлоор сонгогддог бөгөөд үүнтэй таны DNS бичлэгүүд тохирч байх ёстой.';
$string['configemailfromvia'] = 'Илгээж буй цахим шуудангийн "From" хэсэгт мэдээлэл нэмнэ. Энэ нь хүлээн авагчид тухайн цахим шууданг хаанаас ирснийг мэдээлэхээс гадна хариулах боломжгүй цахим шуудангийн хаяг руу санамсаргүй хариу илгээхээс сэргийлнэ.';
$string['configemailheaders'] = 'Илгээж буй бүх цахим шууданд эцэслэгдээгүй толгой хэсгийг үгчлэн нэмнэ.';
$string['configemailsubjectprefix'] = 'Илгээж буй бүх захидлын гарчгийн мөрөнд оруулах бичвэр.';
$string['configenableanalytics'] = '\'Хичээлээс завсардах эрсдэлтэй суралцагч\' эсвэл \'Удахгүй болох үйл ажиллагаанууд\'  зэрэг аналитик загварууд нь таамаглал боловсруулж, хэрэглэгчид зурвас илгээх зэрэг цаашдын үйлдлийг санал болгох боломжтой.';
$string['configenableblogs'] = 'Энэ шилжүүлэгч нь сайтын бүх хэрэглэгч өөрийн блогтой болох боломжийг олгоно.';
$string['configenablecalendarexport'] = 'Хуанли экспортлох эсвэл захиалах боломжийг идэвхжүүлнэ.';
$string['configenablecomments'] = 'Сэтгэгдлийг идэвхжүүлэх';
$string['configenablecourserequests'] = 'Идэвхжүүлсэн тохиолдолд шинэ хичээл (moodle/course:request) хүсэх боломжтой хэрэглэгч хичээл хүсэх сонголттой болно. Энэ боломжийг дурын өгөгдмөл эрхэд зөвшөөрдөггүй. Үүнийг систем эсвэл ангиллын сэдвийн хүрээнд ашиглаж болно.';
$string['configenabledevicedetection'] = 'Загвар болон бусад функцийг ашиглахад гар утас, ухаалаг утас, таблет эсвэл үндсэн төхөөрөмжийн (суурин компьютер, зөөврийн компьютер зэрэг) танилтыг идэвхжүүлнэ.';
$string['configenablemobilewebservice'] = 'Албан ёсны Moodle аппликейшн эсвэл хүсэлт гаргасан бусад аппликейшны гар утасны сервисийг идэвхжүүлнэ. Дэлгэрэнгүй мэдээллийг авахыг хүсвэл {$a}-г уншина уу.';
$string['configenablerssfeeds'] = 'Идэвхжүүлсэн тохиолдолд блог, форум, өгөгдлийн сангийн үйл ажиллагаа, тайлбар толь зэрэг сайтын төрөл бүрийн функцээр RSS мэдэгдлийг бүрдүүлнэ. Тодорхой үйл ажиллагааны модульд RSS мэдэгдлийг идэвхжүүлэх шаардлагатайг анхаарна уу.';
$string['configenablerssfeedsdisabled'] = 'RSS мэдэгдлийг бүх сайтад идэвхгүй болгосон тул үүнийг ашиглах боломжгүй. Тэдгээрийг идэвхжүүлэхийн тулд админ тохиргооны хувьсагчийн тохиргоонд хандана уу.';
$string['configenablerssfeedsdisabled2'] = 'Одоогоор сайтын түвшинд RSS мэдэгдэл идэвхгүй байна. Тэдгээрийг сайтын удирдлагын  нэмэлт тохиргооны хэсэгт идэвхжүүлэх боломжтой.';
$string['configenablestats'] = 'Энд \'тийм\' гэж сонгосон тохиолдолд Moodle системийн cronjob лог бүртгэлийг боловсруулж, зарим статистик мэдээллийг цуглуулах болно. Энэ нь тухайн сайтын трафикийн хэмжээнээс хамаарч бага зэрэг хугацаа шаардаж болно. Үүнийг идэвхжүүлбэл өөрийн хичээл тус бүрийн талаарх зарим сонирхолтой график, статистик мэдээллийг харах боломжтой.';
$string['configenabletrusttext'] = 'Өгөгдмөл тохиргоогоор Moodle нь аюулгүй байдалд эрсдэл учруулахуйц дурын буруу скрипт, медиа зэргийг устгахын тулд хэрэглэгчээс ирсэн бичвэрийг үргэлж цэвэрлэдэг. Итгэмжлэгдсэн агуулгын систем нь тодорхой хэрэглэгчдэд эдгээр нэмэлт функцийг хөндлөнгийн оролцоогүйгээр агуулгадаа оруулах боломжийг олгодог. Энэ системийг идэвхжүүлэхийн тулд эхлээд уг тохиргоог идэвхжүүлж, улмаар тодорхой Moodle эрхэд итгэмжлэгдсэн агуулгын зөвшөөрлийг олгох хэрэгтэй. Ийм хэрэглэгчийн үүсгэсэн эсвэл байршуулсан бичвэрийг итгэмжлэгдсэн гэж тэмдэглэх бөгөөд харуулахаас өмнө цэвэрлэхгүй.';
$string['configenablewebservices'] = 'Веб сервисүүд нь Moodle аппликейшн зэрэг бусад системийг сайтад нэвтэрч, үйлдэл гүйцэтгэх боломжийг олгодог. Аюулгүй байдлаа дээд зэргээр хангах үүднээс аппликейшн эсвэл веб сервисээр дамжуулан нэгтгэхийг шаарддаг гадаад хэрэгсэл/сервисийг ашиглаагүй бол уг тохиргоог идэвхгүй болгох хэрэгтэй.';
$string['configenablewsdocumentation'] = 'Веб сервисийн баримтжуулалтыг автоматаар үүсгэхийг идэвхжүүлнэ. Хэрэглэгч өөрийн баримт бичигт өөрийн нууцлалын түлхүүрийн {$a} хуудаснаас хандах боломжтой. Энэ нь баримт бичгийг зөвхөн идэвхжүүлсэн протоколд харуулна.';
$string['configerrorlevel'] = 'Харуулахыг хүсэж буй PHP анхааруулгын хэмжээг сонгоно. Энгийн нь ихэвчлэн хамгийн сайн сонголт байдаг.';
$string['configexportlookahead'] = 'Экспортын үеэр ахиулж харах өдрүүд';
$string['configexportlookback'] = 'Экспортын үеэр ухрааж харах өдрүүд';
$string['configextendedusernamechars'] = 'Идэвхжүүлсэн тохиолдолд хэрэглэгчийн нэр том үсгээс бусад тэмдэгтийг агуулж болно. Эсрэг тохиолдолд зөвхөн жижиг үсэг, доогуур зураас (_), богино зураас (-), цэг (.), цахим шуудангийн тэмдэг (@) бүхий үсэг, тоон тэмдэгтийг зөвшөөрнө.';
$string['configextramemorylimit'] = 'Хайх, нөөцлөх/сэргээх зэрэг зарим скрипт эсвэл крон нь илүү их санах ойг шаарддаг. Том сайтуудад илүү өндөр утгыг тохируулна.';
$string['configfilterall'] = 'Гарчиг, нэр, удирдах талбар зэрэг бүх мөрийг шүүнэ. Энэ нь олон хэлний шүүлтүүрийг ашиглахад ихэвчлэн хэрэгтэй байдаг ба эсрэг тохиолдолд сайтад ашиг багатай ч нэмэлт ачаалал үүсгэх болно.';
$string['configfiltermatchoneperpage'] = 'Автомат холбох шүүлтүүр нь хуудасны хэмжээнд олдсон эхний тохирох бичвэрт зөвхөн нэг холбоос үүсгэх болно. Бусдыг нь хэрэгсэхгүй.';
$string['configfiltermatchonepertext'] = 'Автомат холбох шүүлтүүр нь хуудасны бичвэрийн зүйл тус бүрд олдсон эхний тохирох  бичвэрт зөвхөн нэг холбоос үүсгэх болно. Бусдыг нь хэрэгсэхгүй. Уг тохиргоо нь хэрэв \'Хуудас бүрийг нэг удаа шүүх\' тохиргоог идэрвхжүүлсэн тохиолдолд ямар ч нөлөө үзүүлэхгүй.';
$string['configfilternavigationwithsystemcontext'] = 'Шүүлтүүрийн ердийн хэрэглээ нь түүнийг ашиглаж буй нөхцөл байдалтай (жишээ нь хичээлийн нөхцөл) холбоотой байдаг боловч сайтын удирдлагын хувьд бүх зүйлийг сайтын сэдэвтэй хамт шүүдэг нь "агуулга ба гарчиг" шүүлтүүрийг ашиглах үед гүйцэтгэлийг сайжруулах боломжтой.';
$string['configfilteruploadedfiles'] = 'Байршуулсан бүх HTML болон бичвэр файлыг харуулахаас өмнө шүүж боловсруулна. Зөвхөн байршуулсан HTML файлыг боловсруулах эсвэл алийг нь ч боловсруулахгүй.';
$string['configforcelogin'] = 'Ерөнхийдөө хүмүүс сайтад нэвтрэхгүйгээр сайтын нүүр хуудас болон хичээлийн жагсаалтыг (гэхдээ хичээлийг биш) харж болдог. Хүмүүсийг сайтад ЯМАР НЭГ үйлдэл хийхээс өмнө нэвтэрсэн байхыг шаардах бол уг тохиргоог идэвхжүүлэх хэрэгтэй.';
$string['configforceloginforprofiles'] = 'Энэ тохиргоогоор хүмүүсийг дурын хэрэглэгчийн профайлыг харахаас өмнө жинхэнэ (зочин бус) бүртгэлээрээ нэвтэрсэн байхыг шаарддаг. Уг тохиргоог идэвхгүй болговол зарим хэрэглэгч өөрийн профайл дээр нийтэд нээлттэй харагдах зар сурталчилгаа (спам) эсвэл бусад зохисгүй агуулга нийтэлж болзошгүй.';
$string['configfrontpage'] = 'Сайтын нүүр хуудсанд дээрх сонгосон зүйлсийг харуулна.';
$string['configfrontpagecourselimit'] = 'Хичээлийн хамгийн их тоо';
$string['configfrontpagecourselimithelp'] = 'Сайтын нүүр хуудас дээрх хичээлийн жагсаалтад харуулах хичээлийн хамгийн их тоо';
$string['configfrontpageloggedin'] = 'Хэрэглэгч нэвтэрсэн үед дээрх сонгосон зүйлсийг сайтын нүүр хуудсанд харуулна.';
$string['configfullnamedisplay'] = 'Энэ нь нэрийг бүтнээр нь хэрхэн харуулахыг тодорхойлдог. Үүний тулд өгөгдмөл утга болох "language" нь үүнийг тухайн хэлний багц дахь "fullnamedisplay" мөрөнд үлдээдэг. Зарим хэл нь нэрийг өөрөөр харуулах дүрэмтэй байдаг.

Ихэнх нэг хэлээрх сайтын хувьд хамгийн үр дүнтэй тохиргоо нь "firstname lastname" бөгөөд овгийг харуулахгүйгээр сонгох боломжтой. Ашиглаж болох хувилбарууд: firstname, lastname, firstnamephonetic, lastnamephonetic, middlename, alternatename.';
$string['configgeoipfile'] = 'GeoLite2 City хоёртын өгөгдлийн файлын байршил. Энэ файл нь Moodle түгээлтийн  хэсэг биш бөгөөд <a href="https://www.maxmind.com/">MaxMind</a> гэдгээс тусад нь авах шаардлагатай. Арилжааны хувилбарыг худалдаж авах эсвэл үнэгүй хувилбарыг ашиглах боломжтой. City өггөдлийн сангийн файлыг татан авахын тулд <a href="https://dev.maxmind.com/geoip/geoip2/geolite2/" >https://dev.maxmind.com/geoip/geoip2/geolite2/</a> хаягаар бүргүүлэх шаардлагатай. Бүртгүүлж, файлыг татан авсны дараа серверийнхээ "{$a}" фолдерт задална.';
$string['configgetremoteaddrconf'] = 'Хэрэв таны сервер урвуу проксийн ард байдаг бол уг тохиргоог ашиглан алслагдсан IP хаягийг ямар HTTP гарчигт итгэж болохыг зааж өгч болно. Гарчгийг хамгийн эхэнд гарч ирсэн дарааллаар нь уншина.';
$string['configgradebookroles'] = 'Энэ тохиргоо нь дүнгийн журнал дээр хэн гарахыг хянах боломжийг олгоно. Хэрэглэгч нь тухайн хичээлийн дүнгийн журнал дээр харагдахын тулд эдгээр үүргээс хамгийн багадаа нэг үүрэгтэй байх ёстой.';
$string['configgradeexport'] = 'Дүнгээ экспортлох үндсэн аргын дүнгийн журнал экспортлох форматыг сонгоно. Сонгосон нэмэлт хэрэгсэл нь үнэлгээ тус бүрийн "сүүлд экспортолсон" талбарыг тохируулж, ашиглана. Жишээлбэл, энэ нь экспортолсон бичлэгийг "шинэ" эсвэл "шинэчилсэн" гэж тодорхойлно. Хэрэв энэ талаар итгэлгүй байгаа бол бүгдийг нь идэвхгүй хэвээр үлдээгээрэй.';
$string['confighiddenuserfields'] = 'Хичээлийн багш/админаас бусад хэрэглэгчээс нуухыг хүсэж байгаа хэрэглэгчийн мэдээллийн талбарыг сонгоно. Энэ нь суралцагчийн хувийн нууцлалыг нэмэгдүүлнэ. CTRL товч дараастайгаар хэд хэдэн талбарыг зэрэг сонгож болно.';
$string['configidnumber'] = 'Энэ сонголт нь (а) Хэрэглэгчээс ID дугаарыг огт асуухгүй, (б) Хэрэглэгчээс ID дугаар асуух боловч оруулахгүй байж болно, (в) Хэрэглэгчээс ID дугаар асуух ба заавал оруулах ёстой. Хэрэглэгчийн ID дугаарыг оруулсан бол тухайн хэрэглэгчийн профайл  дээр харагдах болно.';
$string['configintro'] = 'Энэ хуудсанд таны сервер дээр Moodle системийг зөв ажиллуулахад туслах хэд хэдэн тохиргооны хувьсагчийг тодорхойлох боломжтой. Үүнд хэт их санаа зовох шаардлагаггүй. Өгөгдмөл тохиргоогоор хэвийн ажиллагааг бүрэн хангах ба дараа нь эдгээр тохиргоог өөрчлөх боломжтой.';
$string['configintroadmin'] = 'Энэ хуудсанд сайтыг бүрэн хянах үндсэн администраторын бүртгэлийг тохируулах шаардлагатай. Нууцлал сайтай хэрэглэгчийн нэр, нууц үг, хүчинтэй цахим шуудангийн хаягаа өгөх оруулах хэрэгтэй. Дараа нь хэд хэдэн админ бүртгэл үүсгэж болно.';
$string['configintrosite'] = 'Энэ хуудсанд сайтын нүүр хуудас болон шинэ сайтын нэрийг тохируулах боломжтой. Эдгээр тохиргоог удирдлагын цэсийг ашиглан хүссэн үедээ өөрчлөх боломжтой.';
$string['configiplookup'] = 'Лог бүртгэл зэрэг IP хаяг (34.12.222.93 гэх мэт) дээр дарахад тухайн IP хаяг байрласан газрыг хамгийн сайнаар таамагласан газрын зургийг харуулна. Үүнд зориулсан төрөл бүрийн нэмэлт хэрэгсэл байдаг бөгөөд тэдгээрээс сонгох боломжтой. Нэмэлт хэрэгсэл бүр давуу ба сул талтай.';
$string['configkeeptagnamecase'] = 'Хэрэв тагийг үүсгэсэн хэрэглэгчийн оруулсан эх нүүрийг хадгалах бол энэ сонголтыг идэвхжүүлнэ.';
$string['configlang'] = 'Сайтын өгөгдмөл хэлийг сонгоно. Хэрэглэгч хэлний цэс эсвэл өөрийн профайл дээрх тохиргоог ашиглан уг тохиргоог хүчингүй болгож болно.';
$string['configlanglist'] = 'Хоосон орхисон тохиолдолд хэлний цэсэд тухайн сайтад суулгасан бүх хэлийг харуулах болно. Таслалаар тусгаарласан хэлний кодын жагсаалтыг en,de,fr гэх мэтээр оруулах замаар хэлний цэсийг богиносгох боломжтой. Шаардлагатай тохиолдолд хэлний багцын нэрээс өөр хэлний нэрийг language code|language name форматаар en_kids|English,de_kids|Deutsch гэх мэт зааж өгч болно.';
$string['configlangmenu'] = 'Нүүр хуудас, нэвтрэх хуудас зэрэгт ерөнхий зориулалтын хэлний цэсийг харуулах эсэхийг сонгоно. Энэ нь хэрэглэгчийн профайл дээрээ хэрэгцээт хэлээ сонгох боломжид нөлөөлөхгүй.';
$string['configlangstringcache'] = 'Өгөгдлийн лавлахын файлд бүх хэлний мөрийг хадгална. Хэрэв та Moodle системийг орчуулж байгаа, эсвэл Moodle эх кодын мөрийг өөрчилж байгаа бол уг сонголтыг идэвхгүй болгох хэрэгтэй. Гүйцэтгэлийн үр дүнг харах үүднээс үүнийг идэвхтэй хэвээр үлдээж болно.';
$string['configlatinexcelexport'] = 'Excel экспортын кодчиллыг сонгоно.';
$string['configlocale'] = 'Сайтын хүрээнд энэ нь бүх хэлний багцын огнооны формат ба хэлийг хүчингүй болгоно (энэ нь хуанли дахь өдрийн нэрэнд нөлөөлөхгүй). Уг локаль өгөгдлийг үйлдлийн системдээ суулгасан байх шаардлагатай (жишээ нь linux системд en_US.UTF-8 эсвэл es_ES.UTF-8). Ихэнх тохиолдолд энэ талбарыг хоосон орхих хэрэгтэй.';
$string['configlockrequestcategory'] = 'Идэвхжүүлсэн тохиолдолд системийн хүрээнд шинэ хичээлийн хүсэлт илгээх эрхтэй хэрэглэгч шинэ хичээлийн хүсэлтийн маягтаас ангилал сонгох боломжгүй болно. Хэрэглэгч зөвхөн нэг ангилалд шинэ хичээлийн хүсэлт гаргахыг хязгаарлах өөр нэг арга бол ангиллын сэдвийн хүрээнд шинэ хичээлийн хүсэх боломжийг ашиглах явдал юм.';
$string['configloglifetime'] = 'Энэ нь хэрэглэгчийн үйл ажиллагааны лог бүртгэлийг хадгалах хугацааг заадаг. Энэ хугацаанаас өмнөх лог бүртгэлийг автоматаар устгах болно. Шаардлагатай тохиолдолд лог бүртгэлийг боломжит удаан хугацаагаар хадгалах нь хамгийн сайн арга. Гэвч серверийн ачаалал өндөр, гүйцэтгэлд асуудал гардаг бол лог бүртгэлийг хадгалах хугацааг багасгах шаардлагатай. 30-аас доош утгыг хэрэглэхийг зөвлөдөггүй. Учир нь энэ тохиолдолд статистик зөв ажиллахгүй байж болзошгүй.';
$string['configlookahead'] = 'Төлөвлөх өдрүүд';
$string['configmailnewline'] = 'Шуудангийн зурваст шинэ мөрнөөс эхлэх тэмдэгтийг ашигладаг. RFC 822bis стандартын дагуу CRLF шаардлагатай бөгөөд зарим мэйл сервер LF-ээс CRLF рүү автоматаар хөрвүүлдэг, зарим мэйл сервер нь CRLF-ийг CRCRLF рүү алдаатай хөрвүүлдэг, зарим нь дан LF (жишээ нь qmail) бүхий шуудангаас татгалздаг. Илгээгдэхгүй цахим шуудан эсвэл давхар шинэ мөртэй холбоотой асуудал гарвал уг тохиргоог өөрчилж үзэх хэрэгтэй.';
$string['configmaxbytes'] = 'Энэ нь сайтад байршуулсан файлын хамгийн их хэмжээг заадаг. Уг тохиргоо нь PHP дахь post_max_size ба upload_max_filesize тохигоо, Apache дахь LimitRequestBody тохиргоогоор хязгаарлагддаг. Харин maxbytes нь хичээл эсвэл үйл ажиллагааны түвшинд сонгож болох хэмжээний мужийг хязгаарладаг. Хэрэв \'Сайтын байршуулалтын хязгаар\' сонголт хийвэл серверээс зөвшөөрсөн дээд хэмжээг ашиглах болно.';
$string['configmaxconsecutiveidentchars'] = 'Нууц үг нь энэ тооны дараалсан ижил тэмдэгтээс илүү тэмдэгттэй байж болохгүй. Үүнийг идэвхгүй болгохын тул 0 утгыг ашиглана.';
$string['configmaxeditingtime'] = 'Энэ нь хүмүүс хэлэлцүүлгийн нийтлэл, тайлбар толь бичгийн тайлбар зэргийг дахин засварлах хугацааг заадаг. Энэ хугацаа 30 минут байх нь тохиромжтой.';
$string['configmaxevents'] = 'Төлөвлөх арга хэмжээнүүд';
$string['configmaxusersperpage'] = 'Хичээл, бүлэг, кохорт, веб сервис зэрэг хэрэглэгчийн сонгох хэсэгт харуулах хэрэглэгчийн хамгийн их тоо.';
$string['configmessaging'] = 'Идэвхжүүлсэн тохиолдолд хэрэглэгч нь сайтын бусад хэрэглэгчид зурвас илгээх боломжтой болно.';
$string['configmessagingallowemailoverride'] = 'Хэрэглэгчид өөрийн профайл дээрх цахим шуудангийн хаягаас өөр хаягаар цахим шуудангийн мэдэгдэл илгээх боломжийг олгоно.';
$string['configmessagingallusers'] = 'Идэвхжүүлсэн тохиолдолд хэрэглэгч зурвас илгээх хүнээ сонгохдоо сайтын бүх хэрэглэгчийг харах боломжтой байх ба зурвасын тохиргоонд сайтын дурын хүнээс зурвас хүлээж авах сонголтыг байдаг. Идэвхгүй болговол хэрэглэгч зөвхөн өөрийн хичээл дэх хэрэглэгчийн жагсаалтыг харах боломжтой бөгөөд зөвхөн өөрийн хаягийн бүртгэлд байгаа хаягаас эсвэл өөрийн хаягийн бүртгэлд байгаа хаяг болон хичээлийн бусад оролцогчоос зурвас хүлээн гэсэн хоёр сонголттой байна.';
$string['configmessagingdefaultpressenter'] = 'Хэрэглэгчийн зурвасын тохиргоонд \'Илгээхдээ Enter дарах\' гэснийг өгөгдмөл утгаар тохируулах эсэхийг заана.';
$string['configmessagingdeleteallnotificationsdelay'] = 'Санах ой хэмнэх үүднээс уншсан болон уншаагүй мэдэгдлийг устгах боломжтой. Мэдэгдэл үүсгэснээс хойш ямар хугацааны дараа устгаж болох вэ?';
$string['configmessagingdeletereadnotificationsdelay'] = 'Санах ой хэмнэх үүднээс уншсан мэдэгдлийг устгах боломжтой. Мэдэгдлийг уншсанаас хойш ямар хугацааны дараа устгаж болох вэ?';
$string['configminpassworddigits'] = 'Нууц үг нь хамгийн багадаа эдгээр тооны цифртэй байх ёстой.';
$string['configminpasswordlength'] = 'Нууц үг нь хамгийн багадаа эдгээр тооны тэмдэгтийн урттай байх ёстой.';
$string['configminpasswordlower'] = 'Нууц үг нь хамгийн багадаа эдгээр тооны жижиг үсэгтэй байх ёстой.';
$string['configminpasswordnonalphanum'] = 'Нууц үг нь хамгийн багадаа эдгээр тооны тусгай тэмдэгтэй байх ёстой.';
$string['configminpasswordupper'] = 'Нууц үг нь хамгийн багадаа эдгээр тооны том үсэгтэй байх ёстой.';
$string['configmypagelocked'] = 'Энэхүү тохиргоо нь өгөгдмөл хуудсыг админ бус дурын хэрэглэгч засахаас сэргийлнэ.';
$string['confignavcourselimit'] = 'Удирдлагын хэсэгт хэрэглэгчид харуулах хичээлийн тоог хязгаарлана.';
$string['confignavshowallcourses'] = 'Энэ тохиргоо нь тухайн хичээлд бүртгүүлсэн хэрэглэгч удирдах хэсгээс Хичээлүүд (бүх хичээлийн жагсаалт) болон Миний хичээлүүд (хамрагдсан хичээлийн жагсаалт) хэсгийг харах боломжтой эсэхийг тодорхойлно.';
$string['confignavshowcategories'] = 'Хичээлийн ангиллыг удирдлагын мөр болон удирдлагын блокт харуулна. Энд хэрэглэгчийн хамрагдаж буй хичээлүүд харагдахгүй, эдгээр нь Миний хичээлүүд хэсэгт  ямар нэг ангилалгүйгээр харагдана.';
$string['confignoreplyaddress'] = 'Заримдаа хэрэглэгчийн өмнөөс цахим шуудан илгээх хэрэг гардаг. Энд тодорхойлж өгсөн и-мэйл хаяг нь и-мэйл авсан хүн буцааж таны хувиийн хаягт хариу хийх боломжгүй байх бөгөөд "Илгээгч" гэсэн хэсэгт нь харагдах и-мэйл хаяг юм.';
$string['confignotifyloginfailures'] = 'Логин амжилтгүй болоод и-мэйл анхааруулга явуулах бол энэ анхуулуулгыг хэн үзэх вэ?';
$string['confignotifyloginthreshold'] = 'Логин амжилтгүй болсон анхааруулга идэвхтэй байгаад нэг хэрэглэгч юм уу IP-с хэр олон амжилтгүй логин хийх оролдлогыг мэдээлэх вэ?';
$string['confignotloggedinroleid'] = 'Сайтанд нэвтрээгүй хэрэглэгчид сайтны агуулган дээр олгосон шиг эрхтэй байна. Зочин нь энд байнга нээлттэй тул та түүнээс ч бага эрх эсвэл хязгаарлагдмал эрх үүсгэхийг хүсэж болох юм. Бичлэг бичих зэрэг нь хэрэглэгчдийг зөв нэвтрэхийг шаардсан хэвээр байх болно';
$string['configopentowebcrawlers'] = 'Үүнийг идэвхжүүлснээр Google хайлтаас орсон хэрэглэгчид автоматаар Зочин болж сайтад орно. Энэ нь зочид орох боломжтой курсуудэд л хамаатай.';
$string['configoverride'] = 'config.php дотор тодорхойлсон';
$string['configpasswordpolicy'] = 'Энийг идэвхжүүлбэл хэрэглэгчийн нууц үгийг доорхи тохируулгын дагуу нууц үгний шаардлагатай харьцуулна. Нууц үгний шаардлагыг өөрчлөх нь одоогийн хэрэглэгчид өөрсдөө хүсэх, тэднээс шаардах, нууц үгээ өөрсдөө өөрчлөх, эсвэл "Нэвтрэх нууц үгийг шалгах" хүсэлт ирүүлэхээс бусад тохиолдолд нөлөөлөхгүй.';
$string['configpasswordpolicycheckonlogin'] = '"Энийг сонговол хэрэглэгч бүртгэлээрээ нэвтрэх болгонд нууц үгийг нь шаардлага хангаж байгаа эсэхийг шалгана. Шаардлага хангахгүй байх тохиолдолд хэрэглэгч нууц үгээ өөрчилж байж нэвтэрнэ.
Үүнийг нууц үгний шаардлагыг өөрчилсний дараа идэвхжүүлж ашиглавал зохимжтой."';
$string['configpasswordresettime'] = 'Энд хэрэглэгч нууц үгийнхээ хугацааг дуусахаас ямар хугацааны өмнө шинэ нууц үгийн хүсэлт ирүүлэх ёстойг заана. 30 минут хамгийн тохиромжтой байдаг.';
$string['configpathtodu'] = 'du руу очих зам. /usr/bin/du гэх мэт. Үүнийг оруулбал лавлах агуулгыг харуулсан хуудсыг олон файлтай лавлахад илүү хурдан ажиллуулах болно.';
$string['configpathtophp'] = 'PHP CLI руу очих зам. /usr/bin/php гэх мэт. Үүнийг оруулбал админ веб интерфэйсээс крон скриптийг ажиллуулж болно.';
$string['configperfdebug'] = 'Идэвхжүүлбэл стандарт загварын footer хэсэгт vзvvлэлтийн мэдээлэл гарах болно.';
$string['configprofileroles'] = 'Хэрэглэгчийн профайл болон суралцагчийн хуудсан дээрх жагсаасан дүрүүд.';
$string['configprofilesforenrolledusersonly'] = 'Зүй бус халдлагаас сэргийлэхийн тулд ямар ч хичээлд бүртгүүлээгүй байгаа хэрэглэгчдийн мэдээллийг нууна. Шинэ хэрэглэгчид ядаж нэг хичээлд бүртгүүлж байж танилцуулга мэдээлэл нэмэх боломжтой болно.';
$string['configprotectusernames'] = 'Идэвхжүүлсэн тохиолдолд мартагдсан нууц үгийн маягт нь хэрэглэгчийн нэр эсвэл цахим шуудангийн хаягийг таах боломжтой ямар ч зөвлөмжийг харуулахгүй.';
$string['configproxybypass'] = 'Проксиг алгасах (жишээ нь, 192.168., .mydomain.com) хостын нэр эсвэл IP хаягийн таслалаар тусгаарласан жагсаалт (хэсэгчилсэн)';
$string['configproxyfixunsafe_help'] = 'Энэ нь MoodleBot хэрэглэгчийн агентийг нэмж, прокси ашиглан түүгээр дамждаггүй дотоод дуудлагыг засахыг оролддог.';
$string['configproxyhost'] = 'Хэрэв энэ <b>сервер</b> интернэтэд нэвтрэхийн тулд прокси компьютер (жишээ нь галт хана) ашиглах шаардлагатай бол прокси хостын нэрийг энд оруулна. Үгүй бол хоосон орхино.';
$string['configproxylogunsafe_help'] = 'Энэ нь проксигоор дамждаггүй дотоод дуудлагыг бүртгэхийг оролддог.';
$string['configproxypassword'] = 'Шаардлагатай бол проксигоор дамжуулан интернэтэд нэвтрэх нууц үг шаардлагатай, байхгүй бол хоосон (PHP cURL өргөтгөл шаардлагатай).';
$string['configproxyport'] = 'Хэрвээ энэ сервер прокси компьютер шаардвал прокси портын дугаарыг энд заана.';
$string['configproxytype'] = 'Веб проксийн төрөл (SOCKS5 дэмжихийн тулд PHP5 ба cURL өргөлтгөл шаардлагатай)';
$string['configproxyuser'] = 'Хэрэглэгчийн нэр шаардлагатай бол проксигоор дамжуулан интернэтэд нэвтрэх шаардлагатай, хэрэв байхгүй бол хоосон (PHP cURL өргөтгөл шаардлагатай) орхино.';
$string['configrecaptchaprivatekey'] = 'Moodle сервер, recaptcha сервер хооронд харилцах тэмдэгт (нууц түлхүүр)-ийн цуваа. ReCAPTCHA түлхүүрийг <a target="_blank" href="https://www.google.com/recaptcha">Google reCAPTCHA</a>-ээс авах боломжтой.';
$string['configrecaptchapublickey'] = 'Бүртгэлийн болон сайтын дэмжлэгийн маягт дахь reCAPTCHA элементийг харуулахад ашигладаг тэмдэгт мөр (сайт түлхүүр). ReCAPTCHA түлхүүрийг <a target="_blank" href="https://www.google.com/recaptcha">Google reCAPTCHA</a>-аас авах боломжтой.';
$string['configrequestedstudentname'] = 'Хүссэн хичээлд ашигласан суралцагчид зориулсан үг';
$string['configrequestedstudentsname'] = 'Хүссэн хичээлд ашигласан суралцагчид зориулсан үг';
$string['configrequestedteachername'] = 'Хүссэн хичээлд ашигласан багшид зориулсан үг';
$string['configrequestedteachersname'] = 'Хүссэн хичээлд ашигласан багшид зориулсан үг';
$string['configreverseproxyignore'] = 'Хэрэв таны сервер X-Forwarded-For толгой хэсэгт хавсаргасан хэд хэдэн урвуу проксигийн ард байгаа бол хэрэглэгчийн зөв IP хаягийг олохын тулд таслалаар тусгаарласан IP хаяг эсвэл урвуу проксигийн дэд сүлжээг зааж өгнө.';
$string['configsectioninterface'] = 'Интерфэйс';
$string['configsectionmail'] = 'Цахим шуудан';
$string['configsectionmaintenance'] = 'Дэмжлэг';
$string['configsectionmisc'] = 'Төрөл бүрийн';
$string['configsectionoperatingsystem'] = 'Үйлдлийн систем';
$string['configsectionpermissions'] = 'Зөвшөөрөл';
$string['configsectionrequestedcourse'] = 'Хичээлийн хүсэлт';
$string['configsectionsecurity'] = 'Аюулгүй байдал';
$string['configsectionstats'] = 'Статистик';
$string['configsectionuser'] = 'Хэрэглэгч';
$string['configsecureforms'] = 'Moodle нь веб маягтаас өгөгдлийг хүлээж авахдаа аюулгүй байдлын нэмэлт түвшинг ашиглаж болно. Үүнийг идэвхжүүлсэн тохиолдолд хөтчийн HTTP_REFERER хувьсагчийг одоогийн маягтын хаягтай харьцуулан шалгана. Маш цөөн тохиолдолд хэрэглэгч веб трафикаас HTTP_REFERER салгах зориулалттай галт хана (жишээ нь Zonealarm) ашиглаж байгаа үед асуудал үүсэж болзошгүй. Маягт дээр \'гацах\' шинж тэмдэг илэрнэ. Хэрэглэгчид нэвтрэх хуудастай холбоотой асуудал гарвал (жишээ нь) та энэ тохиргоог идэвхгүй болгож болох ч энэ нь таны сайтыг нууц үгээр халдахад илүү нээлттэй болгож болзошгүй. Эргэлзэж байвал энэ тохиргоог \'Тийм\' хэвээр үлдээгээрэй.';
$string['configservicespage'] = 'Moodle.com дээрх Moodle сервисийг холбоход үйлчилгээ болон тусламжийн хуудасны URL хаягийг оруулна.';
$string['configsessioncookie'] = 'Энэ тохиргоо нь Moodle сейшнд ашигладаг күүкийн нэрийг өөрчилдөг. Энэ нь сонголттой бөгөөд зөвхөн нэг веб сайтад Moodle системийн хэд хэдэн хуулбар ажиллаж байгаа үед күүкиг төөрөгдүүлэхээс зайлсхийхэд хэрэгтэй.';
$string['configsessioncookiedomain'] = 'Энэ нь Moodle күүкийг ашиглах боломжтой домэйнийг өөрчлөх боломжийг олгоно. Энэ нь Moodle сейшн мэдээллийг өөр дэд домэйн дээрх хэрэглээний программтай хуваалцахад шаардлагатай тохиргоонд (жишээлбэл, баталгаажуулалт эсвэл бүртгэлийн нэмэлт хэрэгсэл) хэрэгтэй. <strong>АНХААРУУЛГА: Энэ тохиргоог өгөгдмөл (хоосон) хэвээр үлдээхийг онцгойлон зөвлөж байна. Буруу утга оруулбал сайтын бүх нэвтрэлтийг бүрмөсөн хязгаарлах эрсдэлтэй.</strong>';
$string['configsessioncookiepath'] = 'Хэрэв та хөтчийн Moodle күүки илгээдэг газрыг өөрчлөх шаардлагатай бол уг тохиргоог өөрчилж, өөрийн веб сайтын дэд хавтсыг зааж өгч болно. Үгүй бол өгөгдмөл  \'/\' тохиргоог хэвээр үлдээнэ.';
$string['configsessiontimeout'] = 'Хэрэв энэ сайтад нэвтэрсэн хүмүүс удаан хугацаагаар (хуудас ачаалахгүйгээр) идэвхгүй байвал автоматаар гарна (тэдний хувьд хэрэглэгчийн сейшн дууссан). Уг хувьсагч нь идэвхтэй байх хугацааг тодорхойлно.';
$string['configsessiontimeoutwarning'] = 'Хэрэв энэ сайтад нэвтэрсэн хүмүүс удаан хугацаагаар (хуудас ачаалахгүйгээр) идэвхгүй байвал тэдний сейшн дуусах гэж байгааг анхааруулна. Уг хувьсагч нь идэвхтэй байх хугацааг тодорхойлно.';
$string['configsessiontimeoutwarningcheck'] = 'Сейшн дуусах анхааруулгын хугацаа нь сейшн дуусах хугацаанаас бага байх ёстой';
$string['configshowcommentscount'] = 'Сэтгэгдлийн тоог харуулах ба энэ нь сэтгэгдлийн холбоосыг харуулах үед дахин нэг асуулт гаргана';
$string['configshowicalsource'] = 'iCal арга хэмжээний эх сурвалжийн мэдээллийг харуулах';
$string['configshowsiteparticipantslist'] = 'Сайтын бүх суралцагч болон багш нар сайтын оролцогчдын жагсаалтад байх болно. Уг сайтын жагсаалтыг хэнд харуулахыг зөвшөөрөх вэ?';
$string['configsitedefaultlicense'] = 'Сайтын өгөгдмөл лиценз';
$string['configsitedefaultlicensehelp'] = 'Энэ сайт дээр агуулга нийтлэх өгөгдмөл лиценз';
$string['configsitemailcharset'] = 'Энэ тохиргоо нь сайтаас илгээсэн бүх цахим шуудангийн өгөгдмөл багц тэмдэгтийг тодорхойлдог.';
$string['configsitemaxcategorydepth'] = 'Ангиллын гүнзгийрэлтийн дээд утга';
$string['configsitemaxcategorydepthhelp'] = 'Энэ нь ангилал эсвэл бчивэрт жагсаалт харуулах үед өргөтгөсөн салбар ангиллын гүнзгийрэлтийн хамгийн их утгыг заадаг. Гүнзгийрсэн түвшний ангилал нь холбоос хэлбэрээр харагдах бөгөөд хэрэглэгч AJAX хүсэлтээр нээх боломжтой.';
$string['configslasharguments'] = 'SCORM багц болон олон-файлт нөөцийг зөв харуулахад \'Slash arguments\'  (<em>PATH_INFO</em> ашиглан) шаардлагатай. Хэрэв веб сервер нь \'Slash arguments\' дэмждэггүй бол уг тохиргоог хийх боломжгүй, энэ тохиргоо нь идэвхгүй байж, ажиллахгүй байх болно.<br />Тэмдэглэл: \'Slash arguments\' ашиглах нь Moodle системийн цаашдын хувилбарт шаардагдана.';
$string['configsmtpauthtype'] = 'Энэ нь SMTP серверт ашиглах баталгаажуулалтын төрлийг тохируулна.';
$string['configsmtphosts'] = 'Moodle систем цахим шуудан илгээхэд ашиглах ёстой нэг буюу хэд хэдэн дотоод SMTP серверийн бүтэн нэрийг (жишээлбэл, \'mail.a.com\' эсвэл \'mail.a.com;mail.b.com\') оруулна. Өгөгдмөл бус портыг (өөрөөр хэлбэл, порт 25-аас өөр) заахад [сервер]:[port] синтакс (жишээ нь \'mail.a.com:587\') ашиглаж болно. Аюулгүй холболтын хувьд порт 465-ыг ихэвчлэн SSL, порт 587-г TLS хамтаар тус тус ашиглах ба шаардлагатай бол хамгаалалтын протоколыг зааж өгнө. Уг талбарыг хоосон орхивол Moodle шуудан илгээх PHP өгөгдмөл аргыг ашиглах болно.';
$string['configsmtpmaxbulk'] = 'SMTP сейшн бүрд илгээх зурвасын хамгийн их тоо. Зурвасыг багцлах нь цахим шуудан илгээх хурдыг нэмэгдүүлж болно. Утга нь 2-оос бага байвал цахим шуудан бүрд шинэ SMTP сейшн үүсгэхэд хүрдэг.';
$string['configsmtpoauthservice'] = 'SMTP сервертэй холбохоор тохируулсан OAuth 2 сервисийг сонгоно. Хэрэв уг сервис байхгүй бол үүнийг үүсгэх хэрэгтэй. SMTP баталгаажуулалтын төрлийг XOAUTH2 болгон тохируулах шаардлагатайг анхаарна уу.';
$string['configsmtpsecure'] = 'SMTP сервер нь аюулгүй холболт шаарддаг бол зөв протоколын төрлийг тодорхойлж өгнө.';
$string['configsmtpuser'] = 'Хэрэв дээр дурдсан SMTP серверийг зааж өгөөд уг сервер нь баталгаажуулалт шаарддаг бол хэрэглэгчийн нэр ба нууц үгийг энд оруулна.';
$string['configstartwday'] = 'Долоо хоногийн эхлэл';
$string['configstatsfirstrun'] = 'Энэ нь cronjob статистик боловсруулахыг хүссэн <b>эхний удаа</b> ажиллахад лог бүртгэл хэр удаан ажиллахыг заадаг. Маш их ачаалалтай, дундын хост ашиглаж байгаа тохиолдолд энэ нь ажиллахад хугацаа их шаардаж, нөөцийг эрчтэй зарцуулдаг тул их хэмжээтэй байх хэрэггүй. (Энэ тохиргоонд 1 сар = 28 хоног гэдгийг анхаарна уу. Үүсгэсэн график, тайланд 1 сар = хуанлийн 1 сар байна.)';
$string['configstatsmaxruntime'] = 'Статистик боловсруулалт нь нэлээд ачаалалтай байж болох тул энэ болон дараагийн талбарыг  хослуулан ашиглаж хэзээ, хэр удаан ажиллахыг тодорхойлно.';
$string['configstatsmaxruntime2'] = 'Статистик боловсруулалт нь бүхэлдээ багтаамж ихтэй байж болох тул нэг өдрийн статистикийг цуглуулах хамгийн их хугацааг зааж өгөн. Нэг крон гүйцэтгэл дэх боловсруулах хамгийн их хугацаа 31 хоног байна.';
$string['configstatsmaxruntime3'] = 'Энэ нь статистик боловсруулалт серверт их ачаалал үүсгэж болзошгүйг харгалзан нэг өдрийн статистикийг нэгтгэхэд ногдох хамгийн их хугацааг зааж өгнө. Нэг кроноор боловсруулахад шаардагдах хамгийн их өдрийн тоог дор тодорхойлж болно.';
$string['configstatsruntimedays'] = 'Энэ нь статистик тооцоо хийх бүрд шаардагдах хоногийн хамгийн их тоог заадаг. Статистик шинэчлэгдсэний дараа зөвхөн нэг л өдрийг боловсруулах тул серверийн ачааллаас хамааран энэ утгыг тохируулж, богино хугацаанд кроны гүйцэтгэлийг шаардах бол энэ утгыг багасгаж өгнө.';
$string['configstatsruntimestart'] = 'Статистик боловсруулалт хийдэг cronjob хэдэн цагт эхлэх ёстой вэ? Нэг сервер дээр хэд хэдэн Moodle сайт байвал өөр өөр цагийг зааж өгөхийг зөвлөж байна.';
$string['configstatsuserthreshold'] = 'Энэ тохиргоо нь статистик тооцоололд хамрагдах хичээлд бүртгүүлсэн хэрэглэгчдийн хамгийн бага тоог тодорхойлдог.';
$string['configstrictformsrequired'] = 'Идэвхжүүлсэн тохиолдолд хэрэглэгч зөвхөн маягтын шаардлагатай талбарт сул зай эсвэл хоосон мөр нэмэхээс сэргийлнэ.';
$string['configstripalltitletags'] = 'Энэ тохиргоог идэвхгүй болгосноор үйл ажиллагаа болон нөөцийн нэрэнд HTML хаягийг зөвшөөрнө.';
$string['configsupportavailability'] = 'Сайтын доод хэсгээс хэн тухайн сайтын тусламж үйлчилгээнд хандахыг тодорхойлно.';
$string['configsupportemail'] = 'Хэрэв энэ сайт дээр SMTP тохируулагдсан, тусламж үйлчилгээний хуудсыг тохируулаагүй бол энэ цахим шуудангийн хаягаар тусламж үйлчилгээний маягтаар илгээсэн зурвасыг хүлээн авах болно. Хэрэв илгээж чадахгүй бол нэвтэрсэн хэрэглэгчдэд цахим шуудангийн хаяг харагдах болно.';
$string['configsupportname'] = 'Тусламж үйлчилгээний маягт эсвэл хуудсаар дамжуулан тусламж үзүүлж буй хүн, бусад байгууллагын нэр.';
$string['configsupportpage'] = 'Холбоо барих маягт руу холбохын тулд тусламжийн хуудасны URL хаягийг оруулах буюу хоосон орхино.';
$string['configtempdatafoldercleanup'] = 'Сонгосон хугацаанаас удаан хугацаагаар хадгалагдаж байгаа түр зуурын өгөгдлийн файлыг өгөгдлийн хавтаснаас устгана.';
$string['configthemedesignermode'] = 'Бүх загварын зураг, хэв маягийн хуудсыг гүйцэтгэлийн үүднээс хөтөч болон сервер дээр удаан хугацаагаар хадгалдаг. Хэрэв загвар зохиомжлох эсвэл код хөгжүүлж байгаа бол уг горимыг идэвхжүүлж, кэшлэгдсэн хувилбарыг ашиглахгүй болно. Анхааруулга: Энэ нь сайтыг бүх хэрэглэгчийн хувьд удаашруулахыг анхаарна уу! Гэхдээ загвар сонгох хуудаснаас гараар кэшийн загварыг дахин тохируулах боломжтой.';
$string['configthemelist'] = 'Хүчинтэй загвар ашиглахыг зөвшөөрөхийн тулд үүнийг хоосон орхино. Хэрэв загварын цэсийг богиносгохыг хүсвэл энд таслалаар тусгаарласан нэрийн жагсаалтыг тодорхойлно (зай авч болохгүй!).
Жишээ нь: standard,orangewhite.';
$string['configtimezone'] = 'Энэ нь огноог харуулах өгөгдмөл цагийн бүс болно. Хэрэглэгч бүр өөрийн профайл дээрх уг тохиргоог хүчингүй болгох боломжтой. Кроны ажлууд болон серверийн бусад тохиргоог энэ цагийн бүсэд зааж өгсөн болно. Хэрэв энэ "цагийн бүс алдаатай" гэж харагдаж байвал уг тохиргоог өөрчлөх шаардлагатай.';
$string['configuseblogassociations'] = 'Хэрэглэгчид хичээл болон хичээлийн модультай холбоотой бичлэгийг холбох замаар өөрийн блогоо зохион байгуулах боломжтой байх ёстой эсэх?';
$string['configusesitenameforsitepages'] = 'Идэвхжүүлсэн тохиолдолд сайтын товч нэрийг \'Сайтын хуудсууд\' мөрөнд бус, сайтын удирдлагын хуудас хооронд шилжих хэсэгт ашиглана.';
$string['configusetags'] = 'Сайтын хэмжээнд тагийн функцийг идэвхжүүлэх шаардлагатай эсэх?';
$string['configvariables'] = 'Хувьсагчид';
$string['configverifychangedemail'] = 'Зөвшөөрсөн болон татгалзсан цахим шуудангийн домэйны тохиргоог ашиглан өөрчилсөн цахим шуудангийн хаягийг баталгаажуулахыг идэвхжүүлнэ. Уг сонголтыг идэвхгүй болговол зөвхөн шинэ хэрэглэгч үүсгэх үед домэйныг ашиглах болно.';
$string['configvisiblecourses'] = 'Гол төлөв нууцалсан ангиллын хичээлийг харуулна';
$string['configwarning'] = 'Эдгээр тохиргоог өөрчлөхдөө болгоомжтой хандана уу. Буруу утга оруулбал асуудал үүсгэж болзошгүй.';
$string['configyuicomboloading'] = 'Энэ сонголт нь YUI санд файл ачаалалтын оновчлолыг идэвхжүүлдэг. Энэ тохиргоог гүйцэтгэлийн зорилгоор хөгжүүлэлтийн сайт дээр идэвхжүүлэх шаардлагатай.';
$string['confirmation'] = 'Баталгаажуулалт';
$string['confirmcontextlock'] = '{$a->contextname} нь одоогоор түгжигдээгүй байна. Үүнийг түгжвэл хэрэглэгч зөвхөн  унших боломжтой болж, өөрчлөлт оруулахаас сэргийлнэ. Та үргэлжлүүлэхдээ итгэлтэй байна уу?';
$string['confirmcontextunlock'] = '{$a->contextname} нь одоогоор түгжигдсэн байна. Үүний түгжээг авбал хэрэглэгч өөрчлөлт хийх боломжтой болно. Та үргэлжлүүлэхдээ итгэлтэй байна уу?';
$string['confirmdeletecomments'] = 'Та сонгосон сэтгэгдлээ устгахдаа итгэлтэй байна уу?';
$string['confirmed'] = 'Баталгаажуулсан';
$string['contactsitesupport'] = 'Сайтын тусламж үйлчилгээтэй холбогдох';
$string['contenttypeuninstalling'] = '{$a->type} төрлөөр дэмжигдсэн {$a->count} агуулга байна. Эдгээрийг устгах болно. Та энэ үйлдлийг хийхдээ итгэлтэй байна уу?';
$string['contextlockappliestoadmin'] = 'Администраторууд агуулга түгжих боломжтой.';
$string['contextlockappliestoadmin_desc'] = 'Хэрэв идэвхгүй болговол админууд дурын түгжсэн сэдэвт бичих эрхтэй хэвээр байна.';
$string['contextlocking'] = 'Агуулга түгжих';
$string['contextlocking_desc'] = 'Энэ тохиргоо нь сонгосон ангилал, хичээл, үйл ажиллагаа эсвэл блокт зөвхөн унших хандалтыг тохируулах боломжийг олгоно.';
$string['cookiesecure'] = 'Зөвхөн аюулгүй күүки';
$string['country'] = 'Улсын өгөгдмөл утга';
$string['course_customfield'] = 'Хичээлийн тусгай талбарууд';
$string['coursecolor'] = '{$a} өнгө';
$string['coursecolorheading_desc'] = 'Хичээлийн тохиргоонд зураг оруулаагүй дурын хичээлийг хянах самбар дээр хээтэй карт байдлаар харуулна. Хээнд ашигласан өнгийг доор зааж өгч болно.';
$string['coursecolorsettings'] = 'Хичээлийн картын өнгө';
$string['coursecontact'] = 'Хичээлийн холбоо барих хаяг';
$string['coursecontact_desc'] = 'Энэ тохиргоо нь хичээлийн тайлбар хэсэгт хэн харагдахыг хянах боломжийг олгоно. Хэрэглэгч хичээлийн тайлбар дээр харагдахын тулд тухайн хичээлийн эдгээр эрхээс ядаж нэг эрхтэй байх шаардлагатай.';
$string['coursecontactduplicates'] = 'Хичээлийн бүх холбоо барих эрхийг харуулах';
$string['coursecontactduplicates_desc'] = 'Идэвхжүүлсэн тохиолдолд сонгосон хичээлийн нэгээс олон холбоо барих эрх бүхий хэрэглэгчдийг тэдгээрийн  эрх тус бүрийн хамтаар хичээлийн тайлбар хэсэгт гаргана. Эсрэг тохиолдолд тэдгээрийг зөвхөн нэг эрхтэйгээр (Сайтын удирдлагын \'Эрх тодорхойлох\' хэсэгт хамгийн дээр байгааг) харуулна.';
$string['coursecreationguide'] = 'Moodle хичээл үүсгэх гарын авлагын URL хаяг';
$string['coursecreationguide_help'] = 'Богино видео бичлэг, хичээл үүсгэх ерөнхий зөвлөмж бүхий шуурхай гарын авлагын замыг тодорхойлдог. Үзүүлэх хичээл байхгүй үед гарын авлагын холбоос нь Миний хичээл хуудсанд харагдана. Зөвхөн хичээл үүсгэх чадвартай хэрэглэгч уг холбоосыг харах болно.';
$string['coursegraceperiodafter'] = 'Өнгөрсөн хичээлийн хөнгөлөлтийн хугацаа';
$string['coursegraceperiodbefore'] = 'Судлах хичээлийн хөнгөлөлтийн хугацаа';
$string['courselistshortnames'] = 'Хичээлийн дэлгэрэнгүй нэрийг харуулах';
$string['courselistshortnames_desc'] = 'Идэвхжүүлсэн тохиолдолд хичээлийн жагсаалтад хичээлийн товч нэрийг бүтэн нэрийн хамт харуулна. Шаардлагатай бол хичээлийн дэлгэрэнгүй нэрийг хэлний тохиргооны функцыг ашиглан \'courseextendednamedisplay\' тэмдэгт мөрийг шинэчлэх замаар өөрчлөх боломжтой.';
$string['coursemgmt'] = 'Хичээл ба ангиллыг удирдах';
$string['courseoverview'] = 'Хичээлийн товч мэдээлэл';
$string['courserequestnotify'] = 'Хичээлийн хүсэлтийн мэдэгдэл';
$string['courserequestnotifyemail'] = '{$a->user} шинэ хичээлийн <a href="{$a->link}">{$a->link}</a> хүсэлт гаргалаа';
$string['courserequests'] = 'Хичээлийн хүсэлтүүд';
$string['courserequestspending'] = 'Хүлээгдэж буй хичээлийн хүсэлтүүд';
$string['courses'] = 'Хичээлүүд';
$string['coursesperpage'] = 'Нэг хуудсанд байх хичээлүүд';
$string['courseswithsummarieslimit'] = 'Дүгнэлтийн хязгаар бүхий хичээлүүд';
$string['creatornewroleid'] = 'Шинэ хичээл үүсгэгчийн эрх';
$string['creatornewroleid_help'] = 'Хэрэглэгч шинэ хичээлийг удирдах зөвшөөрөлгүй бол энэ эрхийг ашиглан хэрэглэгч автоматаар бүртгүүлнэ.';
$string['cron'] = 'Крон';
$string['cron_enabled'] = 'Кроныг идэвхжүүлэх';
$string['cron_enabled_desc'] = 'Кроныг идэвхжүүлсэн байх шаардлагатай хэдий ч энэ тохиргоо нь кроныг түр хугацаанд идэвхгүй болгох боломжийг олгодог. Жишээлбэл, серверийг дахин ачаалахын өмнө. Идэвхгүй тохиолдолд систем нь давхар ажил эхлүүлэхээс сэргийлдэг. Чухал функцыг ажиллахаас сэргийлдэг тул кроныг удаан хугацаанд идэвхгүй болгож болохгүйг анхаарна уу.';
$string['cron_help'] = 'cron.php скрипт нь хэлэлцүүлгийн нийтлэлийн мэдэгдэх цахим шуудан илгээх зэрэг олон тооны ажлыг өөр өөр төлөвлөгдсөн интервалд гүйцэтгэдэг. Скриптыг тогтмол, минут тутамд ажиллуулах хэрэгтэй.';
$string['cron_keepalive'] = 'Идэвхтэй байх';
$string['cron_keepalive_desc'] = 'Нэмэлт ажлын санал асуулгыг явуулах хугацаа. Энэ тохиргоо нь кроныг үргэлж ажилладаг байлгана. Тодорхой даалгавар ажиллуулагч ашигладаг тохиолдолд үүнийг 0 болгож тохируулна. Эсрэг тохиолдолд түр зуурын ажил гүйцэтгэгчид ойролцоо утгыг тохируулна. Урт хугацаанаас зайлсхийх хэрэгтэй. Хамгийн их хугацаа 15 минут байна.';
$string['cron_link'] = 'admin/cron';
$string['cronclionly'] = 'Кроныг зөвхөн командын мөрөөр гүйцэтгэх';
$string['cronerrorclionly'] = 'Уучлаарай, админ энэ хуудасны интернэт хандалтыг хаасан байна.';
$string['cronerrorpassword'] = 'Уучлаарай, та энэ хуудсанд нэвтрэх хүчинтэй нууц үг оруулаагүй байна.';
$string['croninfrequent'] = 'Крон нь засвар үйлчилгээний сүүлийн хоёр үйлдлийн хооронд {$a->actual} байсан ба энэ нь {$a->expected} тутамд ажиллах ёстой. Үүнийг олон удаа ажиллахаар тохируулахыг зөвлөж байна.';
$string['cronremotepassword'] = 'Алсаас нэвтрэх кроны нууц үг';
$string['cronwarning'] = '<a href="{$a->url}">admin/cron.php скрипт</a> нь {$a->actual} үед ажиллаагүй ба {$a->expected} тутамд ажиллах ёстой.';
$string['cronwarningcli'] = '<code>admin/cli/cron.php</code> скрипт нь {$a->actual} үед ажиллаагүй ба {$a->expected} тутамд ажиллах ёстой.';
$string['cronwarningnever'] = '<code>admin/cli/cron.php</code> скриптыг огт ажиллаж байгаагүй ба {$a->expected} тутамд ажиллах ёстой.';
$string['cronwarningneverweb'] = '<a href="{$a->url}">admin/cron.php скрипт</a> огт ажиллаж байгаагүй ба {$a->expected} тутамд ажиллах ёстой.';
$string['ctyperequired'] = 'Сайтын гүйцэтгэлийг сайжруулж, олон хэлний нийцтэй байдлыг хангах үүднээс Moodle системд ctype PHP өргөтгөл шаардлагатай болсон.';
$string['curlcache'] = 'cURL нь TTL-ийг кэшлэх';
$string['curlrequired'] = 'Moodle өгөгдлийн агуулахтай холбогдохын тулд Moodle системд cURL PHP өргөтгөл шаардлагатай болсон.';
$string['curlsecurityallowedport'] = 'cURL портын жагсаалтыг зөвшөөрсөн.';
$string['curlsecurityallowedportsyntax'] = 'cURL холбогдох боломжтой портын дугаарын жагсаалт. Зөвхөн бүхэл тоо оруулах боломжтой. Хоосон орхивол бүх портыг зөвшөөрнө. Тохируулсан үед бараг бүх тохиолдолд стандарт HTTPS болон HTTP хаягт холбогдохын тулд 443 ба 80 дугаарыг cURL хэсэгт зааж өгөх шаардлагатай.';
$string['curlsecurityblockedhosts'] = 'cURL нь хостын жагсаалтыг блоколсон.';
$string['curlsecurityblockedhostssyntax'] = 'Бичлэг бүрийг шинэ мөрөнд бичнэ. Хүчинтэй бичлэг нь нэг хост бүхий бүтэн IPv4 эсвэл IPv6 хаяг (192.168.10.1, 0:0:0:0:0:0:0:1, ::1, fe80:: гэх мэт), эсвэл CIDR тэмдэглэгээ (231.54.211.0/20 эсвэл fe80::/64 гэх мэт), эсвэл муж нь хаягийн сүүлийн бүлэгт хамаарах IP хаягийн муж (231.3.56.10-20 эсвэл fe80::1111-bbbb гэх мэт), эсвэл домэйн нэр (localhost эсвэл example.com гэх мэт), эсвэл орлуулагч домэйн нэр (*.example.com эсвэл *.sub.example.com гэх мэт) байж болно. Хоосон мөр оруулж болохгүй.';
$string['curlsecurityurlblocked'] = 'URL хаяг блоклогдсон.';
$string['curltimeoutkbitrate'] = 'cURL хугацаа хэтрэлтийг (с/Кбайт) тооцоолоход ашиглах битийн хурд';
$string['curltimeoutkbitrate_help'] = 'Энэ тохиргоог их хэмжээний cURL хүсэлтийн үед тохирох хугацаа хэтрэлтийг тооцоолоход ашигладаг. Уг тооцооллын нэг хэсэг болгон агуулгын хэмжээг тодорхойлохын тулд HTTP HEAD хүсэлтийг үүсгэнэ. Үүний ттгыг 0 болгон тохируулснаар энэ хүсэлтийг гүйцэтгэх боломжгүй болно.';
$string['currenttheme'] = 'Ашиглаж буй загвар';
$string['customcheck'] = 'Бусад сонголт';
$string['custommenu'] = 'Тусгай цэс';
$string['custommenuitems'] = 'Тусгай цэсийн сонголтууд';
$string['customusermenuitems'] = 'Хэрэглэгчийн цэсийн сонголтууд';
$string['datarootsecurityerror'] = '<p><strong>АЮУЛГҮЙ БАЙДЛЫН АНХААРУУЛГА!</strong></p><p> Таны өгөгдлийн суурь лавлах буруу байршсан байгаа тул вебд нээлттэй байна. Энэ нь таны хувийн бүх файлд дэлхийн хаанаас хандах боломжтой гэсэн үг бөгөөд таны сайтын админ эрхийг зөвшөөрөлгүй эзэмшихийн тулд заримыг нь ашиглах боломжтой!</p>
<p>Та өгөгдлийн суурь лавлахыг ({$a}) өөрийн нээлттэй веб лавлахаас өөр байршилд <em>заавал</em> шилжүүлж, өөрийн config.php файлд <code>$CFG->dataroot</code> тохиргоог шинэчлэх шаардлагатай.</p>';
$string['datarootsecuritywarning'] = 'Таны сайтын тохиргоо аюулгүй биш байж болзошгүй. Таны ({$a}) өгөгдлийн суурь лавлахад вебээр шууд хандах боломжгүй эсэхийг шалгана уу.';
$string['dbsessions'] = 'Сейшны мэдээлэлд өгөгдлийн санг ашиглах';
$string['debug'] = 'Алдааны мэдэгдэл';
$string['debugall'] = 'БҮГД: Боломжит бүх РНР алдааны мэдэгдлийг харуулах';
$string['debugdeveloper'] = 'ХӨГЖҮҮЛЭГЧ: хөгжүүлэгчдэд зориулсан Moodle нэмэлт алдааны мэдэгдэл';
$string['debugdisplay'] = 'Алдааны мэдэгдлийг харуулах';
$string['debugging'] = 'Алдаа илрүүлэх';
$string['debugminimal'] = 'БАГА: Зөвхөн ноцтой алдааг харуулах';
$string['debugnone'] = 'БАЙХГҮЙ: Ямар ч алдаа, анхааруулга харуулахгүй байх';
$string['debugnormal'] = 'ЭНГИЙН: Алдаа, анхааруулга, мэдэгдлийг харуулах';
$string['debugpageinfo'] = 'Хуудасны мэдээллийг харуулах';
$string['debugsqltrace'] = 'SQL дуудлагын эх сурвалжийг харуулах';
$string['debugsqltrace1'] = 'Зөвхөн нэг дуудлагын шугамыг харуулах';
$string['debugsqltrace100'] = 'Бүтэн стекийн алдааны тэмдэглэлийг харуулах';
$string['debugsqltrace2'] = 'Стекийн алдааны тэмдэглэлийн хоёр мөрийг харуулах';
$string['debugsqltrace_desc'] = 'Идэвхжүүлсэн тохиолдолд хэсэгчилсэн эсвэл бүрэн PHP стекийн алдааны тэмдэглэлийг SQL дотор тайлбар хэлбэрээр нэмнэ.';
$string['debugstringids'] = 'Хэлний тэмдэгт мөрийн эх сурвалжийг харуулах';
$string['debugstringids_desc'] = 'Идэвхжүүлсэн тохиолдолд URL хаягт ?strings=1 эсвэл &strings=1 хавсаргасан үед хэлний тэмдэгт мөрийн бүрэлдэхүүн хэсгүүд болон танигчийг харуулах болно.';
$string['debugtemplateinfo'] = 'Загварын мэдээллийг харуулах';
$string['debugtemplateinfo_desc'] = 'Идэвхжүүлсэн тохиолдолд рендерт ашигласан загвар нь HTML хуудасны тайлбар хэлбэрээр харагдана. Энэ нь HTML баталгаажуулалтын алдаа гаргаж, зарим хуудасны скриптийг эвдэж болзошгүй тул зөвхөн түр зуурын алдааг шалгахад ашиглана.';
$string['debugvalidators'] = 'Батлагч холбоосыг харуулах';
$string['defaultcity'] = 'Хотын өгөгдмөл нэр';
$string['defaultcity_help'] = 'Энд оруулсан хот нь шинэ хэрэглэгчийн бүртгэлийг үүсгэхэд өгөгдмөл хот байх болно.';
$string['defaultformatnotset'] = 'Хичээлийн өгөгдмөл форматыг тодорхойлоход алдаа гарлаа. Сайтын тохиргоог шалгана уу.';
$string['defaulthomepage'] = 'Хэрэглэгчдэд зориулсан эхлэл хуудас';
$string['defaultrequestcategory'] = 'Хичээлийн хүсэлтийн өгөгдмөл ангилал';
$string['defaultsettinginfo'] = 'Өгөгдмөл утга: {$a}';
$string['defaultuserroleid'] = 'Бүх хэрэглэгчийн өгөгдмөл эрх';
$string['deleteincompleteusers'] = 'Дараа нь бүрэн бус хэрэглэгчдийг устгах';
$string['deleteunconfirmed'] = 'Дараа нь бүрэн тохируулаагүй хэрэглэгчдийг устгах';
$string['deleteuser'] = 'Хэрэглэгчийг устгах';
$string['density'] = 'Нягтрал';
$string['denyemailaddresses'] = 'Татгалзсан цахим шуудангийн домэйн';
$string['development'] = 'Хөгжүүлэлт';
$string['devicedetectregex'] = 'Төхөөрөмж таних тогтмол илэрхийлэл';
$string['devicedetectregex_desc'] = '<p>Өгөгдмөл тохиргоогоор Moodle нь өгөгдмөл төрлийн төхөөрөмж (ширээний компьютер, зөөврийн компьютер гэх мэт), үүрэн телефон (гар утас, жижиг гар төхөөрөмж), таблет (iPad, Android таблет) болон хуучин (Internet Explorer 6 хэрэглэгчид) төхөөрөмжийг таньж чадна. Эдгээрт өөр өөр загварыг хэрэгжүүлэхэд загвар сонгогчийг ашиглаж болно. Уг тохиргоогоор нэмэлт төхөөрөмжийн төрлийг (эдгээр нь өгөгдмөл төрлөөс давуу эрхтэй) таньж илрүүлэх тогтмол илэрхийлийг зөвшөөрдөг.</p>
<p>Жишээлбэл, та \'/(MIDP-1.0|Maemo|Windows CE)/\' тогтмол илэрхийллийг оруулж, өргөн хэрэглэгддэг зарим гар утсыг таних боломжтой бөгөөд буцах утга дээр нь \'featurephone\' гэж нэмж өгнө. Ингэснээр загвар сонгогч дээр \'featurephone\' төрөл нэмэгдэж, эдгээр төхөөрөмж дээр хүссэн загвараа сонгох боломжтой болно. Бусад төрлийн утас нь зөөврийн төхөөрөмжийн төрөлд сонгосон загварыг ашигласан хэвээр байна.</p>';
$string['devicedetectregexexpression'] = 'Тогтмол илэрхийлэл';
$string['devicedetectregexvalue'] = 'Буцах утга';
$string['devicetype'] = 'Төхөөрөмжийн төрөл';
$string['devlibdirpresent'] = 'Хөгжүүлэлтийн сан бүхий лавлах, ялангуяа <em>/vendor</em> болон  <em>/node_modules</em> нь нийтэд нээлттэй сайт дээр байршиж болохгүй. Илүү дэлгэрэнгүй мэдээллийг <a href="{$a->moreinfourl}">аюулгүй байдлын тойм тайлан</a> хэсгээс авна уу.';
$string['disabled'] = 'Идэвхгүй';
$string['disableplugin'] = '{$a} идэвхгүй болгох';
$string['disableuserimages'] = 'Хэрэглэгчийн профайлын зургийг идэвхгүй болгох';
$string['displayerrorswarning'] = 'Зарим алдааны мэдэгдэл нь таны серверийн талаарх нууц мэдээллийг задруулж болзошгүй тул хөгжүүлэлтийн сайтад <em>display_errors</em> тохиргоог идэвхжүүлэхийг зөвлөдөггүй.';
$string['displayloginfailures'] = 'Нэвтрэлтийн алдааг харуулах';
$string['divertallemails'] = 'Цахим шууданг шилжүүлэх';
$string['divertallemailsdetail'] = 'Цахим шууданг турших үед хөгжүүлэлтийн орчинд хамгаалалт болгон ашиглах бөгөөд хөгжүүлэлтэд ашиглахгүй.';
$string['divertallemailsexcept'] = 'Цахим шууданг шилжүүлэх онцгой тохиолдол';
$string['divertallemailsexcept_desc'] = 'Таслал эсвэл шинэ мөрөөр тусгаарласан цахим шуудангийн онцгой дүрмийн жагсаалт. Дүрэм бүрийг <pre>simone@acme.com гэх мэт тогтмол илэрхийлэл гэж үзнэ.
.*@acme.com
fred(\\+.*)?@acme.com
</pre>';
$string['divertallemailsto'] = 'Бүх цахим шууданг шилжүүлэх';
$string['divertallemailsto_desc'] = 'Үүнийг тохируулбал бүх цахим шууданг нэг цахим шуудангийн хаяг руу шилжүүлэх болно.';
$string['dndallowtextandlinks'] = 'Бичвэр/холбоосыг чирэх даралтаар байршуулах';
$string['doclang'] = 'Баримт бичгийгщн хэл';
$string['docroot'] = 'Moodle Docs баримт бичгийн суурь';
$string['doctonewwindow'] = 'Шинэ цонхонд нээх';
$string['doesnotfit'] = 'Цахим шууданг харуулах тохиргоо';
$string['doesnotfitdetail'] = 'Moodle системээс илгээгдэх цахим шуудангийн тохиргоог харуулах';
$string['download'] = 'Татаж авах';
$string['downloadcoursecontentallowed'] = 'Хичээлийн агуулгыг татаж авах';
$string['downloadcoursecontentallowed_desc'] = 'Хичээлд тухайн хичээлийн агуулгыг татаж авах боломж байгаа эсэх. Боломжтой тохиолдолд хичээл засварлах цэсний "Татаж авах хичээлийн агуулгыг идэвхжүүлэх" тохиргоог ашиглан хичээлийн агуулгын татаж авахыг идэвхтэй/идэвхгүй болгож болно (үүний өгөгдмөл тохиргоог <a href={$a} target="_blank">Хичээлийн өгөгдмөл тохиргоо</a>) хэсэгт тохируулна).';
$string['durationunits'] = 'Үргэлжлэх хугацааны нэгж';
$string['edithelpdocs'] = 'Тусламжийн баримт бичгийг засварлах';
$string['editlang'] = '<b>Засварлах</b>';
$string['editorbackgroundcolor'] = 'Дэвсгэр өнгө';
$string['editordictionary'] = 'Засварлагчийн толь бичиг';
$string['editorfontfamily'] = 'Фонтын багц';
$string['editorfontlist'] = 'Фонтын жагсаалт';
$string['editorfontsize'] = 'Фонтын хэмжээ';
$string['editorhidebuttons'] = 'Нуугдмал товчлуур';
$string['editorkillword'] = 'Үгийн форматын шүүлтүүр';
$string['editorspelling'] = 'Засварлагчийн зөв бичгийн дүрэм';
$string['editorspellinghelp'] = 'Үг үсгийн алдаа шалгагчийг идэвхжүүлэх эсвэл идэвхгүй болгох. Идэвхжүүлсэн тохиолдолд сервер дээр <strong>үгийн алдаа шалгагч</strong> суулгасан байх ёстой.';
$string['editstrings'] = 'Үг, өгүүлбэрийг засах';
$string['emailchangeconfirmation'] = 'Цахим шуудангийн өөрчлөлтийн баталгаажуулалт';
$string['emaildkim'] = 'DomainKeys Identified Mail (DKIM) бүхий цахим шуудангийн гарын үсэг';
$string['emaildkiminfo'] = 'Хэрэв DKIM сонгогчийг хоёуланг нь тохируулсан, $CFG->dataroot/dkim/[domain]/[selector].private дахь цахим шуудангийн "Хэнээс" хаягийн домэйнтэй зохицох хувийн гэрчилгээний файл олдвол тухайн цахим шуудан гарын үсэгтэй байна. Ихэнх тохиолдолд (жишээлбэл, хэрэв allowedemaildomains хоосон бол) <pre>{$a->path}</pre> замд зөвхөн нэг л сертификат шаардагддаг. Тохиргооны дэлгэрэнгүй мэдээллийг <a href="{$a->docs}">Цахим шуудангийн тохиргоо</a> баримт бичгээс харна уу.';
$string['emaildkimselector'] = 'DKIM сонгогч';
$string['emailfromvia'] = 'Мэдээллээр дамжих цахим шуудан';
$string['emailheaders'] = 'Цахим шуудангийн гарчиг';
$string['emailsubjectprefix'] = 'Цахим шуудангийн сэдвийн угтвар бичвэр';
$string['emoticonalt'] = 'Хувилбар бичвэр';
$string['emoticoncomponent'] = 'Зургийн бүрэлдэхүүн хэсэг';
$string['emoticonimagename'] = 'Зургийн нэр';
$string['emoticons'] = 'Сэтгэл хөдлөлийн тэмдэгтүүд';
$string['emoticons_desc'] = 'Энэ маягт нь таны сайтад ашиглах сэтгэл хөдлөлийн тэмдэгтүүдийг (эсвэл инээмсэглэл)  тодорхойлдог. Хүснэгтээс мөр устгахын тулд маягтын шаардлагатай талбарыг хоосон утгатайгаар хадгална. Шинэ сэтгэл хөдлөлийн тэмдэгт бүртгэхийн тулд хамгийн сүүлийн хоосон мөрөнд байгаа талбаруудыг бөглөнө. Бүх талбарыг өгөгдмөл утгаар дахин тохируулахын тулд дээрх холбоосыг дагана.

* Бичвэр (шаардлагатай) - Энэ бичвэрийг сэтгэл хөдлөлийн тэмдэгтээр солих болно. Энэ нь хамгийн багадаа хоёр тэмдэгт байх ёстой.
* Зургийн нэр (шаардлагатай) - Бүрэлдэхүүн хэсгийн pix хавтастай холбоотой өргөтгөлгүй сэтгэл хөдлөлийн зургийн файлын нэр.
* Зургийн бүрэлдэхүүн хэсэг (шаардлагатай) - Тэмдэгт бүхий бүрэлдэхүүн хэсэг.
* Бичвэрийн хувилбар (сонголтоор) - Тэмдэгт мөр танигч ба сэтгэл хөдлөлийн тэмдэгтийн хувилбар бичвэрийн бүрэлдэхүүн хэсэг.';
$string['emoticonsreset'] = 'Сэтгэл хөдлөлийн тэмдэгтийн тохиргоог өгөгдмөл утгаар дахин тохируулах';
$string['emoticontext'] = 'Бичвэр';
$string['emptysettingvalue'] = 'Хоосон';
$string['enableanalytics'] = 'Логик анализын арга';
$string['enableblogs'] = 'Блогийг идэвхжүүлэх';
$string['enablecalendarexport'] = 'Хуанли экспортлохыг идэвхжүүлэх';
$string['enablecomments'] = 'Сэтгэгдлийг идэвхижүүлэх';
$string['enablecommunicationsubsystem'] = 'Харилцааны дэд системийг идэвхжүүлэх';
$string['enablecommunicationsubsystem_desc'] = 'Энэ тохиргоо нь шинэ холбооны дэд системийг идэвхжүүлдэг. Уг шинэ дэд систем нь сургах, суралцах үйл ажиллагаанд Moodle системийг ашиглахад багш, суралцагчийг илүү хялбар харилцах боломжийг олгодог';
$string['enablecourserelativedates'] = 'Хичээлтэй холбоотой огноог идэвхжүүлэх';
$string['enablecourserelativedates_desc'] = 'Хэрэглэгчийн хичээл эхлэх огноотой холбоотой хугацааг харуулахын тулд хичээлийн тохиргоо хийхийг зөвшөөрнө.';
$string['enablecourserequests'] = 'Хичээлийн хүсэлтийг идэвхжүүлэх';
$string['enabled'] = 'Идэвхжүүлсэн';
$string['enabledashboard'] = 'Хянах самбарыг идэвхжүүлэх';
$string['enabledashboard_help'] = 'Хяналтын самбар нь өгөгдмөл тохиргоогоор цагийн хуваарь, хуанли, сүүлд хандсан зүйлсийг харуулдаг. Та хүн бүрд өөрийн өгөгдмөл хяналтын самбарыг тохируулж, тэдэнд өөрийн хяналтын самбарыг өөрчлөх боломжийг олгох боломжтой. Идэвхгүй тохиолдолд \'Хэрэглэгчдэд зориулсан эхлэх хуудас\'-ыг хяналтын самбараас өөр утгаар тохируулах хэрэгтэй.';
$string['enabledevicedetection'] = 'Төхөөрөмж танилтыг идэвхжүүлэх';
$string['enableglobalsearch'] = 'Нээлттэй хайлтыг идэвхжүүлэх';
$string['enableglobalsearch_desc'] = 'Идэвхжүүлсэн тохиолдолд өгөгдлийг хуваарьт ажлын дагуу индексэлж, синхрончилно.';
$string['enablegravatar'] = 'Граватарыг идэвхжүүлэх';
$string['enablegravatar_help'] = 'Идэвхжүүлсэн үед хэрэглэгч зураг байршуулаагүй тохиолдолд Moodle нь Граватараас хэрэглэгчийн профайлын зургийг татах оролдлого хийнэ.';
$string['enablemobilewebservice'] = 'Мобайл төхөөрөмжид зориулсан веб сервисийг идэвхжүүлэх';
$string['enablepdfexportfont'] = 'PDF фонтуудыг идэвхжүүлэх';
$string['enablepdfexportfont_desc'] = 'Хэрэв танай сайтад PDF файлд өөр фонт шаарддаг төрөл бүрийн хэлээрх хичээл байдаг бол хичээлийн тохиргоонд фонтыг тохируулах сонголтыг өгч болно. Та config.php доторх $CFG->pdfexportfont дотор байгаа фонтыг зааж өгөх хэрэгтэй.';
$string['enableplugin'] = '{$a}-г идэвхжүүлэх';
$string['enablerecordcache'] = 'Бичлэгийн кэшийг идэвхжүүлэх';
$string['enablerssfeeds'] = 'RSS мэдэгдлийг идэвхжүүлэх';
$string['enablesearchareas'] = 'Хайлтын хэсгийг идэвхжүүлэх';
$string['enablesharingtomoodlenet'] = 'MoodleNet (гадагш) рүү хуваалцахыг идэвхжүүлэх';
$string['enablesharingtomoodlenet_desc'] = 'Хэрэглэгчид холбогдох чадвартай бол тохируулсан MoodleNet жишээнд хичээлийн агуулгыг хуваалцах боломжийг олгоно.';
$string['enablestats'] = 'Статистикийг идэвхжүүлэх';
$string['enabletrusttext'] = 'Итгэмжлэгдсэн агуулгыг идэвхжүүлэх';
$string['enableuserfeedback'] = 'Энэ программ хангамжийн талаарх санал хүсэлтийг идэвхжүүлэх';
$string['enableuserfeedback_desc'] = 'Идэвхжүүлсэн тохиолдолд хэрэглэгчийн дэлгэцний доод хэсэгт Moodle программын талаарх санал хүсэлтээ Moodle удирдах төвд өгөх боломжийг олгох \'Энэ программ хангамжийн талаар санал хүсэлт өгөх\' холбоос гарах болно. Харин \'Дараагийн санал хүсэлт өгөх хугацааг сануулах\' тохиргоог идэвхжүүлсэн бол хэрэглэгчийн хянах самбар дээо тодорхойлсон хугацаанд сануулгыг гаргана. \'Дараагийн санал хүсэлт өгөх хугацааг сануулах\' тохиргоог \'Хэзээ ч үгүй\' болговол хянах самбарт сануулга гарахгүй ч \'Энэ программ хангамжийн талаар санал хүсэлт өгөх\' холбоос дэлгэцийн доод хэсэгт хэвээр үлдэнэ.';
$string['enablewebservices'] = 'Веб сервисийг идэвхжүүлэх';
$string['enablewsdocumentation'] = 'Веб сервисийг баримтжуулах';
$string['encryptedpassword_edit'] = 'Шинэ утга оруулах';
$string['encryptedpassword_set'] = '(Тохируулж, шифрлэсэн)';
$string['enroladminnewcourse'] = 'Шинэ хичээлд админыг автоматаар бүртгүүлэх';
$string['enroladminnewcourse_help'] = 'Админ шинэ хичээл нэмэх үед тэдгээрийг автоматаар бүртгэж, шинэ хичээлд үүсгэгчийн эрхийг хуваарилах шаардлагатай эсэх?';
$string['enrolinstancedefaults'] = 'Бүртгэлийн өгөгдмөл тохиргоо';
$string['enrolinstancedefaults_desc'] = 'Шинэ хичээлийн бүртгэлийн өгөгдмөл тохиргоо';
$string['enrolmultipleusers'] = 'Хэрэглэгчийг бүртгэх';
$string['entitytasklog'] = 'Ажлын лог бүртгэл';
$string['environment'] = 'Орчин';
$string['environmenterrortodo'] = 'Та энэ Moodle хувилбарыг суулгахаас өмнө нь илэрсэн дээр дурдсан орчны бүх асуудлыг (алдаа) шийдэх ёстой.';
$string['environmenterrorupgrade'] = 'Анхааруулга: Та Moodle системийн энэ хувилбарыг шинэчлэхийн өмнө дээр илэрсэн орчны бүх асуудлыг (алдаа) шийдвэрлэх шаардлагатай! Эдгээр шаардлагыг хангахгүйгээр хувилбарыг шинэчлэх нь өгөгдөл алдагдах зэрэг асуудлыг үүсгэж болзошгүй. Та шинэчлэлийг үргэлжлүүлэхдээ итгэлтэй байна уу?';
$string['environmentmariadbwrongdbtype'] = 'Буруу <code>$CFG->dbtype</code>: та өөрийн <code>config.php</code> файлд \'<code>mysql</code>\' гэдгийг \'<code>mariadb</code>\' болгон өөрчлөх шаардлагатай.';
$string['environmentmustfixsetting'] = 'PHP тохиргоог өөрчлөх шаардлагатай.';
$string['environmentok'] = 'Таны серверийн орчин бүх үндсэн шаардлагыг хангаж байна.';
$string['environmentrecommendcustomcheck'] = 'хэрэв энэ туршилт амжилтгүй болбол энэ нь нуугдмал асуудал байгааг илтгэнэ.';
$string['environmentrecommendinstall'] = 'хамгийн сайн үр дүнд хүрэхийн тулд суулгаж, идэвхжүүлсэн байх шаардлагатай';
$string['environmentrecommendversion'] = 'та {$a->current} хувилбарыг ашиглаж байгаа ба {$a->needed} хувилбарыг ашиглахыг зөвлөж байна';
$string['environmentrequirecustomcheck'] = 'Энэ туршилтыг давах ёстой';
$string['environmentrequireinstall'] = 'суулгаж идэвхжүүлсэн байх ёстой';
$string['environmentrequireversion'] = 'та {$a->current} хувилбарыг ашиглаж байгаа ба {$a->needed} хувилбарыг ашиглах ёстой';
$string['environmentsettingok'] = 'санал болгосон тохиргоог таньсан';
$string['environmentshouldfixsetting'] = 'PHP тохиргоог өөрчлөх шаардлагатай.';
$string['environmentxmlerror'] = 'Орчны өгөгдлийг уншихад алдаа ({$a->error_code}) гарлаа';
$string['errordeletingconfig'] = '{$a}\' нэмэлт хэрэгслийн тохиргооны бүртгэлийг устгах явцад алдаа гарлаа.';
$string['errorsetting'] = 'Тохиргоог хадгалж чадсангүй:';
$string['errorwithsettings'] = 'Алдаанаас үүдэн зарим тохиргоог өөрчлөөгүй.';
$string['eventshandlersinuse'] = 'Таны систем дэх нэмэлт хэрэгслүүд нь Events 1 API ашиглагдаагүй  \'{$a}\' зохицуулагчийг ашиглаж байна. Events 2 API ашиглахын тулд тэдгээрийг шинэчилнэ үү. https://docs.moodle.org/dev/Event_2#Event_dispatching_and_observers мэдээллийг харна уу.';
$string['everyonewhocan'] = '{$a}\' чаддаг хүн бүр';
$string['exceptions'] = 'зөрчих тохиолдлууд';
$string['execpathnotallowed'] = 'config.php дээр гүйцэтгэх боломжтой болон локаль замын тохиргоог идэвхгүй болгосон';
$string['experimental'] = 'Туршилтын';
$string['experimentalsettings'] = 'Туршилтын тохиргоо';
$string['extendedusernamechars'] = 'Хэрэглэгчийн нэрэнд өргөтгөсөн тэмдэгт оруулахыг зөвшөөрөх';
$string['extramemorylimit'] = 'Нэмэлт PHP санах ойн хязгаарлалт';
$string['fatalsessionautostart'] = '<p>Тохируулгын ноцтой алдаа илэрсэн тул серверийн админд мэдэгдэнэ үү.</p><p> Moodle нь хэвийн ажиллахын тулд админаас РНР тохиргоог өөрчлөхийг шаарддаг.</p><p><code>session.auto_start</code> нь <code>off</code> болгон тохируулагдсан байх ёстой.</p><p>Энэ тохиргоог <code>php.ini</code>, Apache/IIS <br />тохиргоо эсвэл серверийн файл дээрх <code>.htaccess</code> тохиргоог засварлах замаар удирдана.</p>';
$string['favicon'] = 'Фавикон';
$string['favicon_desc'] = 'Хөтчийн мөрөнд хуудасны гарчгийн хажууд фавиконыг харуулдаг. Тусгай фавиконыг зааж өгөөгүй тохиолдолд Moodle фавикон гардаг.';
$string['feedbacksettings'] = 'Санал хүсэлтийн тохиргоо';
$string['fileconversioncleanuptask'] = 'Файл хөрвүүлэх түр бүртгэлийг цэвэрлэх';
$string['filecreated'] = 'Шинэ файл үүсгэсэн';
$string['filescleanupperiod'] = 'Хогийн савны файлыг цэвэрлэх';
$string['filescleanupperiod_help'] = 'Хогийн савны файлуудыг тогтмол устгана. Эдгээр нь устгасан хичээл гэх мэт байхгүй  болсон эх сурвалжтай хамааралтай файлууд болно. Анхааруулга: Энэ тохиргоо нь  \'Автомат нөөцлөлтийн тохиргоо\' дахь \'Файлыг оруулах\' (backup_auto_files) тохиргоог идэвхгүй болгосон тохиолдолд нөөцөлсөн, устгасан, дахин сэргээсэн хичээлийн файлыг алга болоход хүргэж болзошгүй.';
$string['filesizeunits'] = 'йайлын хэмжээний нэгж';
$string['filestoredin'] = 'Файлыг энэ хавтсанд хадгалах :';
$string['filestoredinhelp'] = 'Файлыг хадгалах байршил';
$string['filterall'] = 'Бүх тэмдэгт мөрөөр шүүх';
$string['filtermatchoneperpage'] = 'Хуудас бүрд зохицох шүүлтүүр';
$string['filtermatchonepertext'] = 'Бичвэр бүрд зохицох шүүлтүүр';
$string['filternavigationwithsystemcontext'] = 'Системийн хүрээний удирдлагын шүүлтүүр';
$string['filters'] = 'Шүүлтүүр';
$string['filtersettings'] = 'Шүүлтүүрийг удирдах';
$string['filtersettingsgeneral'] = 'Шүүлтүүрийн ерөнхий тохиргоо';
$string['filteruploadedfiles'] = 'Байршуулсан файлыг шүүх';
$string['forceclean'] = 'Хаа сайгүй агуулгыг цэвэрлэх';
$string['forceclean_desc'] = 'Аюулгүй байдалд заналхийлж болзошгүй дурын зүйлийг устгахын тулд сайтад нэмсэн агуулгыг харуулахаас өмнө ихэвчлэн цэвэрлэдэг. Гэвч скрипт, медиа, шугаман хүрээ зэргийг нэмэхийн тулд үйл ажиллагааны тодорхойлолт, хуудасны нөөц, HTML блок зэрэг тодорхой хэсгийн агуулгыг цэвэрлэдэггүй. Уг тохиргоог идэвхжүүлбэл БҮХ агуулгыг цэвэрлэдэг болно. Ингэснээр одоо байгаа агуулга эвдэрч харагдах магадлалтай.';
$string['forcelogin'] = 'Хэрэглэгчийг нэвтрэхийг шаардах';
$string['forceloginforprofileimage'] = 'Хэрэглэгчийн зургийг үзэхийн тулд хэрэглэгчийг нэвтрэхийг шаардах';
$string['forceloginforprofileimage_help'] = 'Идэвхжүүлсэн тохиолдолд хэрэглэгч нь хэрэглэгчийн зургийг харахын тулд нэвтрэх шаардлагатай бөгөөд бүх мэдэгдлийн цахим шууданд хэрэглэгчийн өгөгдмөл зургийг ашиглана.';
$string['forceloginforprofiles'] = 'Хэрэглэгчийн профайлд хандахын тулд хэрэглэгчийг нэвтрэхийг шаардах';
$string['forcetimezone'] = 'Цагийн бүсийг оноож өгөх';
$string['formatuninstallwithcourses'] = '{$a->format} ашигладаг {$a->count} хичээл байдаг. Тэдгээрийн форматыг {$a->defaultformat} (энэ сайтын өгөгдмөл формат) болгож өөрчилнө. Форматаас хамааралтай зарим өгөгдөл алдагдаж болзошгүй. Та үргэлжлүүлэхэд итгэлтэй байна уу?';
$string['frontpage'] = 'Сайтын нүүр хуудас';
$string['frontpagebackup'] = 'Сайтын нүүр хуудасны нөөцлөлт';
$string['frontpagedefaultrole'] = 'Сайтын нүүр хуудасны өгөгдмөл тохиргоо';
$string['frontpagefilters'] = 'Сайтын нүүр хуудасны шүүлтүүр';
$string['frontpageloggedin'] = 'Нэвтрэхэд сайтын нүүр хуудсан дээр гарах зүйлс';
$string['frontpageoverrides'] = 'Сайтын нүүр хуудасны зөвшөөрлийг хүчингүй болгох';
$string['frontpagequestions'] = 'Сайтын нүүр хуудасны асуултууд';
$string['frontpagerestore'] = 'Сайтын нүүр хуудсыг сэргээх';
$string['frontpageroles'] = 'Сайтын нүүр хуудасны эрх';
$string['frontpagesettings'] = 'Сайтын нүүр хуудасны тохиргоо';
$string['fullnamedisplay'] = 'Бүтэн нэрийн формат';
$string['fullnamedisplayprivate'] = 'Бүтэн нэрийн формат - хувийн';
$string['gdrequired'] = 'Moodle системд зургийг хөрвүүлэхэд GD өргөтгөл шаардлагатай.';
$string['generalsettings'] = 'Үндсэн тохиргоо';
$string['geoipfile'] = 'GeoLite2 City MaxMind DB';
$string['getremoteaddrconf'] = 'Нэвтэрсэн IP хаягийн эх сурвалж';
$string['globalsearch'] = 'Нээлттэй хайлт';
$string['globalsearchmanage'] = 'Нээлттэй хайлтыг удирдах';
$string['googlemapkey3'] = 'Google Maps API V3 түлхүүр';
$string['googlemapkey3_help'] = 'Та IP хаягийн байршлын дүрслэлд Google Maps үйлчилгээг ашиглахын тулд тусгай түлхүүрийг оруулах шаардлагатай. Уг түрхүүрийг <a href="https://developers.google.com/maps/documentation/javascript/tutorial#api_key" target="_blank">https://developers.google.com/maps/documentation/javascript/tutorial#api_key</a> хаягаар хандан үнэ төлбөргүй авах боломжтой.';
$string['gotofirst'] = 'Эхний дутуу тэмдэгт мөрөнд шилжих';
$string['gradebook'] = 'Дүнгийн журнал';
$string['gradebookroles'] = 'Дүгнэгдсэн эрх';
$string['gradeexport'] = 'Үнэлгээний экспортын үндсэн аргууд';
$string['gravatardefaulturl'] = 'Граватар өгөгдмөл зургийн URL хаяг';
$string['gravatardefaulturl_help'] = 'Граватар нь хэрэглэгчийн зургийг олж чадахгүй тохиолдолд тухайн хэрэглэгчийн зургийг харуулахад өгөгдмөл зургийг ашигладаг. Уг тохиргоог хоосон орхивол Moodle нь таны үзэж байгаа хуудсанд хамгийн тохиромжтой өгөгдмөл зургийг ашиглах болно. Түүнчлэн Граватарт <a href="https://en.gravatar.com/site/implement/images/#default-image">өгөгдмөл зураг үүсгэх</a> олон тооны код байдгийг анхаарна уу.';
$string['groupenrolmentkeypolicy'] = 'Бүлгээр элсүүлэх үндсэн дүрэм';
$string['groupenrolmentkeypolicy_desc'] = 'Идэвхжүүлсэн тохиолдолд бүлгээр элсүүлэх үндсэн дүрмийг дээрх тохиргоонд заасан нууц үгийн дүрэмтэй харьцуулан шалгах болно.';
$string['guestroleid'] = 'Зочны эрх';
$string['guestroleid_help'] = 'Энэ эрхийг зочин хэрэглэгчид автоматаар хуваарилна. Түүнчлэн уг эрхийг хичээлд зочны бүртгэлийн нэмэлт хэрэгслээр дамжин хандсан бүртгүүлээгүй хэрэглэгчид түр хугацаагаар оноодог.';
$string['h5pgetcontenttypestask'] = 'h5p.org сайтаас H5P агуулгыг боломжит төрлийг татан авах';
$string['helpadminseesall'] = 'Админ нь сайтын хуанлид бүх хичээлийн хуанлийн эсвэл зөвхөн бүртгүүлсэн хичээлийнхээ арга хэмжээг харж, шүүдэг эсэх? Админ нь сонгосон сонголтоос үл хамааран эхлээд хичээлд шилжиж, дараа нь хичээлийн хуанлид шууд хандах замаар хичээл бүрийн хуанлийн арга хэмжээг удирдах боломжтой.';
$string['helpcalendarcustomexport'] = 'Хуанлийн экспортын тохиргоонд тусгайлсан огнооны мужийг экспортлох сонголтыг идэвхжүүлнэ. Үүнийг идэвхжүүлэхээс өмнө хуанлийн экспортыг идэвхжүүлсэн байх шаардлагатай.';
$string['helpexportlookahead'] = 'Тусгай экспортын сонголтоор экспортлох тохиолдолд хуанли нь хэдэн өдрийн дараах арга хэмжээг хайх вэ?';
$string['helpexportlookback'] = 'Тусгай экспортын сонголтоор экспортлох тохиолдолд хуанцли нь хэдэн өдрийн өмнөх арга хэмжээг хайх вэ?';
$string['helpforcetimezone'] = 'Та хэрэглэгчид өөрийн цагийн бүсийг сонгох боломжийг олгох эсвэл тэдэнд цагийн бүсийг шууд оноох боломжтой.';
$string['helpshowicalsource'] = 'Идэвхжүүлсэн тохиолдолд бүртгэлийн нэр, холбоосыг iCal-импортолсон арга хэмжээнд харуулах болно.';
$string['helpsitemaintenance'] = 'Шинэчлэлт болон бусад ажилд зориулагдсан';
$string['helpstartofweek'] = 'Хуанлийн долоо хоног ямар өдөр эхлэх вэ?';
$string['helpupcominglookahead'] = 'Хуанлид болох гэж буй арга хэмжээг өгөгдмөл тохиргоогоор хэдэн өдрөөр харуулах вэ?';
$string['helpupcomingmaxevents'] = 'Болох гэж буй хэдэн (хамгийн их) арга хэмжээг хэрэглэгчид өгөгдмөл тохиргоогоор харуулах вэ?';
$string['helpweekenddays'] = 'Долоо хоногийн аль өдрийг "амралтын өдөр" гэж тооцож, өөр өнгөөр харуулах вэ?';
$string['hiddenuserfields'] = 'Хэрэглэгчийн талбарыг нуух';
$string['hidefromall'] = 'Бүх хэрэглэгчээс нуух';
$string['hidefromnone'] = 'Хэнээс ч нуухгүй';
$string['hidefromstudents'] = 'Суралцагчаас нуух';
$string['hookcallbacknotcallable'] = 'Энэ буцааж залгах дуудлагыг хийх боломжгүй. Энэ нь тухайн класс эсвэл арга байхгүй эсвэл уг арга нь нийтэд нээлттэй биш байгаатай холбоотой байж болно.';
$string['hookcallbacks'] = 'Буцааж залгах дуудлага';
$string['hookcallbacks_help'] = 'Хүүк илгээх үед дуудагдах буцааж залгах дуудлагын жагсаалт.

Дараалал нь буцааж залгах дуудлагыг дуудах дарааллыг харуулна.

Өндөр ач холбогдол бүхий буцааж дуудах дуудлагыг бага ач холбогдолтой дуудлагын өмнө хийх болно.';
$string['hookclassmissing'] = 'Хүүк класс олдсонгүй';
$string['hookclassmissing_desc'] = 'Хүүк илрүүлэх агент нь байхгүй классыг буцаасан.';
$string['hookconfigoverride'] = 'Хүчингүй болгосон';
$string['hookconfigoverride_help'] = 'Энэ буцааж дуудах дуудлагын тодорхойлолтыг сайтын тохиргооны config.php файлд хүчингүй болгосон';
$string['hookdeprecates'] = 'Хэрэггүй болсон lib.php дуудлагууд';
$string['hookdescription'] = 'Тодорхойлолт';
$string['hookdescriptionmissing'] = 'Хүүк нь тайлбарын арга байхгүй';
$string['hookname'] = 'Хүүк';
$string['hooksoverview'] = 'Хүүкийн тойм';
$string['hookunknown'] = 'Хүүк олдсонгүй';
$string['hookunknown_desc'] = 'Энэ буцааж дуудах дуудлагыг сонсох объект байхгүй байна. Үүнийг устгасан эсвэл нэрийг нь өөрчилсөн эсвэл Moodle системийн энэ хувилбарт байхгүй байж магадгүй.';
$string['hostname'] = 'Хостын нэр';
$string['htmleditor'] = 'HTML засварлагч';
$string['htmleditorsettings'] = 'HTML засварлагчийн тохиргоо';
$string['htmlsettings'] = 'HTML тохиргоо';
$string['http'] = 'HTTP';
$string['httpsecurity'] = 'HTTP аюулгүй байдал';
$string['iconvrequired'] = 'ICONV өргөтгөлийг суулгах шаардлагатай.';
$string['igbinary322buggyversion'] = 'Сайтад суулгасан php-igbinary өргөтгөл нь PHP 7.2 хувилбартай ажиллахад асуудал үүсгэж болзошгүй. Та php-igbinary 3.2.5 эсвэл түүнээс хойших хувилбараар шинэчлэх буюу PHP 7.3 эсвэл түүнээс хойших хувилбараа шинэчлэхийг зөвлөж байна.';
$string['ignore'] = 'Татгалзах';
$string['includemoduleuserdata'] = 'Хэрэглэгчийн өгөгдлийн модулийг оруулах';
$string['incompatibleblocks'] = 'Үл зохицох блокууд';
$string['incompleteunicodesupport'] = 'MySQL эсвэл MariaDB өгөгдлийн сангийн одоогийн тохиргоо нь \'utf8\' ашиглаж байна. Энэ тэмдэгтийн багц нь зарим эможийг агуулсан дөрвөн байтынн тэмдэгтийг дэмждэггүй. Эдгээр тэмдэгтийг ашиглавал бүртгэл шинэчлэх үед алдаа зааж, өгөгдлийн санд илгээсэн дурын мэдээлэл алдагдаж болзошгүй. Тохиргоогоо \'utf8mb4\' болгон өөрчилнө үү. Дэлгэрэнгүй мэдээллийг баримт бичгээс авна уу.';
$string['indexdata'] = 'Индекс өгөгдөл';
$string['indexinginfo'] = 'Таны сайтын агуулгыг индексжүүлэх санал болгож буй арга бол \'Нээлттэй хайлтыг индексжүүлэх\' төлөвлөгөөт аргыг ашиглах явадл юм.';
$string['installhijacked'] = 'Уучлаарай, суурилуулалтыг үндсэн IP хаягаас дуусгах ёстой. Уучлаарай.';
$string['installsessionerror'] = 'PHP сейшнг эхлүүлэх боломжгүй байна. Таны хөтөч күүки хүлээн авдаг эсэхийг шалгана уу.';
$string['intlrecommended'] = 'Intl өргөтгөлийг locale aware sorting зэрэг олон улсын чанартай дэмжлэгийг сайжруулахад ашигладаг.';
$string['intlrequired'] = 'Intl өргөтгөл нь locale aware sorting болон олон улсын домэйн нэршил зэрэг олон улсын чанартай дэмжлэгийг сайжруулахад шаардагддаг.';
$string['invalidagedigitalconsent'] = 'Дижитал зөвшөөрлийн нас шаардлага хангахгүй байна: {$a}';
$string['invalidforgottenpasswordurl'] = 'Мартсан нууц үгний URL хаяг нь хүчинтэй URL хаяг биш байна.';
$string['invalidsection'] = 'Хүчингүй хэсэг.';
$string['invalidthemepreset'] = 'Сонгосон урьдчилан тохируулсан файл нь энэ загвартай зохицохгүй байна. SCSS алдаа: "{$a}"';
$string['invaliduserchangeme'] = 'Хэрэглэгчийн"changeme" нэр нөөцлөгдсөн -- та ийм нэртэй бүртгэл үүсгэх боломжгүй.';
$string['ipblocked'] = 'Энэ сайт одоогоор ажиллахгүй байна.';
$string['ipblocker'] = 'IP хязгаарлагч';
$string['ipblockersyntax'] = 'Бичлэг бүрийг нэг мөрөнд оруулна. Хүчинтэй бичлэг нь нэг хосстой зохицох бүтэн IP хаяг (<b>192.168.10.1</b> гэх мэт); эсвэл эдгээр тоогоор эхлэх дурын хаягтай зохицох хаягийн хэсэг (<b>192.168</b> гэх мэт); эсвэл CIDR тэмдэглэгээ (<b>231.54.211.0/20</b> гэх мэт), эсвэл хаягийн сүүлчийн хэсэгт хамаарах IP хаягийн муж (<b>231.3.56.10-20</b> гэх мэт) зэрэг байж болно. Бичвэр домэйн нэрийг (\'example.com\') дэмждэггүй. Хоосон мөр, # тэмдэгтийн араас бичсэн бичвэрийг хүчингүйд тооцно.';
$string['iplookup'] = 'IP хаяг хайх';
$string['iplookupgeoplugin'] = 'Газар зүйн мэдээллийг хайхад <a href="https://www.geoplugin.com">geoPlugin</a> үйлчилгээг ашигладаг. Илүү нарийвчлалтай үр дүн шаардлагатай бол MaxMind GeoLite өгөгдлийн сангийн локал хуулбарыг суулгахыг зөвлөж байна.';
$string['iplookupinfo'] = 'Moodle нь IP хаягийн байршлыг хайхдаа NetGeo (Интернэтийн газар зүйн өгөгдлийн сан) үнэ төлбөргүй, онлайн серверийг ашиглах өгөгдмөл тохиргоотой байдаг. Харамсалтай нь энэ өгөгдлийн сан ажиллахаа больсон тул <em>маш буруу</em> өгөгдөл харуулж болзошгүй.
MaxMind үйлчилгээнээс GeoLite2 City өгөгдлийн сангийн үнэ төлбөргүй хуулбарыг суулгахыг зөвлөж байна.<br />
IP хаягийн байршлыг энгийн газрын зураг эсвэл Goodle Maps ашиглан харуулна. Интерактив газрын зургийг идэвхжүүлэхийн тулд Гүүглд бүртгэлтэй, мөн Google Maps  API үнэгүй түлхүүрийг авах хүсэлт гаргах шаардлагатайг анхаарна уу.';
$string['iplookupmaxmindnote'] = 'Энэ бүтээгдэхүүнд <a href="https://www.maxmind.com">https://www.maxmind.com</a> хаягаар хандах боломжтой MaxMind үйлчилгээний GeoLite2 өгөгдлийг агуулдаг.';
$string['iscustomadminwarnings'] = 'Таны сайт тусгай админ лавлах ашиглаж байгаа нь тогтоогдлоо. Энэ функцийг дэмжихээ больсон бөгөөд Moodle 4.2 хувилбарын дараа устгагдах болно.';
$string['ishttpswarning'] = 'Таны сайт HTTPS ашиглан хамгаалагдаагүй болох нь тогтоогдлоо. Аюулгүй байдлаа дээшлүүлж, бусад системтэй зохицон ажиллах байдлаа нэмэгдүүлэхийн тулд сайтаа HTTPS рүү шилжүүлэхийг зөвлөж байна.';
$string['keeptagnamecase'] = 'Тагий хүрээг хадгалах';
$string['lang'] = 'Өгөгдмөл хэл';
$string['langcache'] = 'Хэлний цэсийг кэшлэх';
$string['langcache_desc'] = 'Хэлний цэсийг кэшлэнэ. Идэвхжүүлсэн тохиолдолд боломжит орчуулгын жагсаалтыг кэшлэнэ. Хэлний багц удирдах хэрэгслээр дамжуулан хэлний багцыг суулгах эсвэл устгах үед кэш автоматаар шинэчлэгддэг. Шинэ хэлний багцыг гар аргаар суулгасан бол кэшийн жагсаалтыг шинэчлэхийн тулд Бүх кэшийг цэвэрлэх функцыг ашиглах хэрэгтэй.';
$string['langlist'] = 'Хэлний цэс дээрх хэлнүүд';
$string['langmenu'] = 'Хэлний цэсийг харуулах';
$string['langmenuinsecurelayout'] = 'Хэлний цэсийг аюулгүй байрлалаар харуулах';
$string['langmenuinsecurelayout_desc'] = 'Идэвхжүүлсэн тохиолдолд хэрэглэгч аюулгүй байрлалыг ашиглан асуултад хариулах эсвэл бусад үйлдлийг хийхэд хэлээ солих боломжтой болно.';
$string['langpackwillbeupdated'] = 'ТАЙЛБАР: Moodle нь шинэчлэл хийх явцад таны хэлний багцыг шинэчлэх оролдлого хийх болно.';
$string['langstringcache'] = 'Бүх хэлний тэмдэгт мөрийг кэшлэх';
$string['languagesettings'] = 'Хэлний тохиргоо';
$string['latinexcelexport'] = 'Excel кодчилол';
$string['legacyfilesaddallowed'] = 'Хичээлийн хуучин файлд нэмэхийг зөвшөөрөх';
$string['legacyfilesaddallowed_help'] = 'Хэрэв хичээл нь хичээлийн хуучин файлуудтай бол тэдгээрт шинэ файл, хавтас нэмэхийг зөвшөөрнө.';
$string['legacyfilesinnewcourses'] = 'Шинэ хичээлд буй хичээлийн хуучин файлууд';
$string['legacyfilesinnewcourses_help'] = 'Өгөгдмөл тохиргоогоор зөвхөн шинэчлэгдсэн хичээлүүдэд хичээлийн хуучин файлын  талбарууд байдаг. Уг тохиргоонд үйл ажиллагааг нөөцлөх, сэргээн татах зэрэг зарим үйлдэл зохицдоггүй болохыг анхаарна уу.';
$string['libcurlwarning'] = 'libcurl нь CURLOPT_PROTOCOL дэмжлэггүй болох нь тогтоогдлоо. Аюулгүй байдлын үүднээс хамгийн сүүлийн libcurl хувилбарыг суурилуулахыг зөвлөж байна.';
$string['licensesettings'] = 'Лицензийн тохиргоо';
$string['linkadmincategories'] = 'Админы ангиллыг холбох';
$string['linkadmincategories_help'] = 'Идэвхжүүлсэн тохиолдолд админы тохиргооны ангилал нь удирдлагын хэсэгт холбоос хэлбэрээр харагдах бөгөөд админы ангиллын хуудас руу хөтлөх болно.';
$string['linkcoursesections'] = 'Хичээлийн хэсгүүдийг үргэлж холбоно.';
$string['linkcoursesections_help'] = 'Хичээлийн хэсгүүдийн холсоосыг үргэлж гаргах хэрэгтэй. Хичээлийн формат нь хуудас бүрт нэг хэсгийг харуулдаг бол хичээлийн хэсгүүд нь ихэвчлэн холбоос хэлбэрээр харагдана. Энэ тохиргоог идэвхжүүлбэл холбоосыг үргэлж харуулах болно.';
$string['loading'] = 'Ачаалж байна';
$string['localetext'] = 'Сайтад бүхэлд нь ашиглагдах тохиргоо';
$string['localstringcustomization'] = 'Локал тэмдэгт мөрийн тохируулга';
$string['location'] = 'Байрлал';
$string['locationsettings'] = 'Байрлалын тохиргоо';
$string['locked'] = 'Түгжигдсэн';
$string['lockoutduration'] = 'Бүртгэлийг хаах хугацаа';
$string['lockoutduration_desc'] = 'Энэ хугацааны дараа түгжигдсэн бүртгэлийг автоматаар нээнэ.';
$string['lockoutemailbody'] = '{$a->sitename}\' сервер дээрх {$a->username} хэрэглэгчийн нэр бүхий таны бүртгэлийг олон удаагийн амжилтгүй оролдлогын түгжсэн байна.

Бүртгэлийг нээхийн тулд дараах хаягаар нэвтэрнэ үү.

{$a->link}

Ихэнх цахим шуудангийн программд энэ нь цэнхэр өнгөтэй холбоос байдлаар харагдах бөгөөд дээр нь дарахад л болно. Хэрэв холбоос нь ажиллахгүй байвал хаягийг веб хөтчийнхөө дээд талд байрлах хаягийн мөрөнд хуулж оруулна.

Тусламж шаардлагатай бол сайтын админтай холбогдоно уу.
{$a->admin}';
$string['lockoutemailsubject'] = 'Таны {$a} дээрх бүртгэл түгжигдсэн байна.';
$string['lockouterrorunlock'] = 'Бүртгэлийн түгжээг тайлах мэдээлэл буруу байна.';
$string['lockoutthreshold'] = 'Бүртгэлийг түгжих босго утга';
$string['lockoutthreshold_desc'] = 'Бүртгэлийг түгжихэд хүргэх амжилтгүй нэвтрэх оролдлогын тоог зааж өгнө. Үйлчилгээг таслагч халдлагын үеэр уг тохиргоог ашиглаж болзошгүй.';
$string['lockoutwindow'] = 'Бүртгэлийн түгжээг хянах цонх';
$string['lockoutwindow_desc'] = 'Түгжих босго утгыг хянах хугацаа, хэрэв амжилтгүй нэвтрэх оролдлого байхгүй бол энэ хугацааны дараа босгоны утгын тоолуур шинээр тохируулагдана.';
$string['lockrequestcategory'] = 'Ангилал сонгохоос урьдчилан сэргийлэх';
$string['log'] = 'Лог бүртгэл';
$string['logguests'] = 'Зочны хандалтын лог бүртгэл';
$string['logguests_help'] = 'Энэ тохиргоо нь зочны бүртгэл болон нэвтэрч ороогүй хэрэглэгчийн үйлдлийг бүртгэх боломжийг олгодог. Өндөр түвшний сайтууд гүйцэтгэлийн шалтгаанаар уг лог бүртгэлийг идэвхгүй болгох нь бий. Хөгжүүлэлтийн сайтад энэ тохиргоог идэвхтэй байлгахыг зөвлөж байна.';
$string['logininfoinsecurelayout'] = 'Нэвтэрсэн хэрэглэгчийг аюулгүй байдлаар харуулах';
$string['logininfoinsecurelayout_desc'] = 'Идэвхжүүлсэн тохиолдолд аюулгүй байрлалыг ашиглан асуулт хариулт болон бусад үйл ажиллагаа явуулах үед нэвтэрсэн хэрэглэгчийн бүтэн нэрийг удирдлагын талбарт харуулна.';
$string['loginpageautofocus'] = 'Автоматаар чиглүүлэх нэвтрэлтийн хуудасны маягт';
$string['loginpageautofocus_help'] = 'Энэ сонголтыг идэвхжүүлснээр нэвтрэх хуудасны ашиглалтыг сайжруулах боловч автоматаар чиглүүлэх талбаруудад хүртээмжтэй холбоотой асуудал үүсгэж болзошгүй.';
$string['loglifetime'] = 'Лог бүртгэлийг хадгалах';
$string['logo'] = 'Лого';
$string['logo_desc'] = 'Зарим загварт (үндсэн загвар гэх мэт) чимэглэл болгон ашиглах бүтэн лого. Энэ зураг нь өндөр нягтшилтай байдаг тул ашиглахын тулд хэмжээг багасгадаг (төдийгүй гүйцэтгэлийн хүрээнд кэшлэдэг). Өндрийн хэмжээнээсээ илүү өргөнтэй лого нь илүү тохиромжтой байдаг.';
$string['logocompact'] = 'Нягтшил сайтай лого';
$string['logocompact_desc'] = 'Сүлд тэмдэг, бамбай эсвэл дүрст тэмдэгт зэрэг дээрхтэй ижил логоны нягтшил сайтай хувилбар. Зургийн хэмжээ жижиг байсан ч тод байх ёстой.';
$string['logossettings'] = 'Логонууд';
$string['logstorenotrequired'] = 'Лог бүртгэлийн санг шаардахгүй';
$string['logstoressupported'] = 'Энэ тайланг дэмжих лог бүртгэлийн сан';
$string['longtimewarning'] = '<b>Энэ процесс удаан үргэлжилж болохыг анхаарна уу.</b>';
$string['mailnewline'] = 'Цахим шуудангийн шинэ мөрнөөс эхлэх тэмдэгт';
$string['maintenancemode'] = 'Засвар үйлчилгээний горимд байна';
$string['maintenancemodeisscheduled'] = 'Энэ сайт {$a->min} минут {$a->sec} секундын дараа засвар үйлчилгээний горимд шилжинэ';
$string['maintenancemodeisscheduledlong'] = 'Энэ сайт {$a->hour} цаг {$a->min} минут {$a->sec} секундын дараа засвар үйлчилгээний горимд шилжинэ';
$string['maintfileopenerror'] = 'Засвах үйлчилгээний файлуудыг нээхэд алдаа гарлаа!';
$string['maintinprogress'] = 'Засвар үйлчилгээ хийгдэж байна...';
$string['managecontextlock'] = 'Энэ сэдвийг түгжих';
$string['managecontextlocklocked'] = '{$a->contextname} ба дараагийн дурын сэдвүүд түгжигдсэн.';
$string['managecontextlockunlocked'] = '{$a->contextname} ба дараагийн дурын сэдвүүдийг нээсэн.';
$string['managecontextunlock'] = 'Энэ сэдвийг нээх';
$string['managecustomfields'] = 'Тусгай талбарын төрлийг удирдах';
$string['manageformats'] = 'Хичээлийн форматыг удирдах';
$string['manageformatsgotosettings'] = 'Өгөгдмөл форматыг {$a} дотор өөрчилж болно';
$string['managelang'] = 'Удирдах';
$string['manageqbanks'] = 'Асуултын сангийн нэмэлт хэрэгслийг удирдах';
$string['manageqbehaviours'] = 'Асуултын шинж чанарыг удирдах';
$string['manageqtypes'] = 'Асуултын төрлийг удирдах';
$string['maturity100'] = 'Бета';
$string['maturity150'] = 'Орлох хувилбарыг гаргах';
$string['maturity200'] = 'Тогтвортой хувилбар';
$string['maturity50'] = 'Альфа';
$string['maturityallowunstable'] = 'Сануулга: Та энэ скриптыг --allow-unstable сонголтоор ажиллуулж болно';
$string['maturitycoreinfo'] = 'Таны сайт одоогоор тогтворгүй "{$a}" хөгжүүлэлтийн кодыг ажиллуулж байна.';
$string['maturitycorewarning'] = 'Таны суулгах эсвэл шинэчлэх гэж буй Moodle системийн хувилбар нь ихэнх хөгжүүлэлтийн сайтад ашиглахад тохиромжгүй "{$a}" тогтворгүй хөгжүүлэлтийн кодыг агуулдаг. Хэрэв энэ нь таны хүссэн зүйл биш бол та Moodle кодын НАЙДВАРТАЙ салбараас шинэчилнэ үү. Дэлгэрэнгүй мэдээллийг Moodle Docs баримт бичгээс авна уу.';
$string['maxbytes'] = 'Байршуулсан файлын хамгийн дээд хэмжээ';
$string['maxconsecutiveidentchars'] = 'Дараалсан ижил тэмдэгтүүд';
$string['maxeditingtime'] = 'Нийтлэлийг засварлах хамгийн их хугацаа';
$string['maxsizeperdownloadcoursefile'] = 'Нэг файлын хамгийн дээд хэмжээ';
$string['maxsizeperdownloadcoursefile_desc'] = 'Хичээлийн агуулгыг татаж авах үеийн файл бүрийн хамгийн дээд хэмжээ. Энэ хэмжээнээс хэтэрсэн файлуудыг татан авалтаас хасах болно.';
$string['maxtimelimit'] = 'Хамгийн их цагийн хязгаар';
$string['maxtimelimit_desc'] = 'Moodle ямар ч гаралтыг харуулахгүйгээр PHP гүйцэтгэл хийх дээд хугацааг хязгаарлахад шаардлагатай утгыг энд секундээр оруулна. 0 утга нь Moodle системийн өгөгдмөл хязгаарлалтыг ашиглаж байгаа гэсэн үг. Хэрэв танд өөрийн цагийн хязгаарлалт бүхий сервер байгаа бол лог бүртгэлд PHP алдааг хүлээн авахын тулд энэ утгыг багаар тохируулах хэрэгтэй. CLI скриптэд хамаарахгүй.';
$string['maxusersperpage'] = 'Нэг хуудсанд байж болох хамгийн олон хэрэглэгчийн тоо';
$string['mbstringrecommended'] = 'Сайтын гүйцэтгэлийг сайжруулахын тулд, ялангуяа танай сайт латин бус хэлийг дэмждэг бол нэмэлт MBSTRING санг суулгахыг зөвлөж байна.';
$string['mbstringrequired'] = 'Сайтын гүйцэтгэлийг сайжруулахын тулд, ялангуяа танай сайт латин бус хэлийг дэмждэг бол MBSTRING санг суурилуулах шаардлагатай.';
$string['mediapluginavi'] = '.avi шүүлтүүрийг идэвхжүүлэх';
$string['mediapluginflv'] = '.flv шүүлтүүрийг идэвхжүүлэх';
$string['mediapluginimg'] = 'Холбогдсон зургуудын автоматаар эмбед хийхийг идэвхжүүлэх';
$string['mediapluginmov'] = '.mov шүүлтүүрийг идэвхжүүлэх';
$string['mediapluginmp3'] = ',mp3 шүүлтүүрийг идэвхжүүлэх';
$string['mediapluginmpg'] = '.mpg шүүлтүүрийг идэвхжүүлэх';
$string['mediapluginogg'] = '.ogg шүүлтүүрийг идэвхжүүлэх';
$string['mediapluginogv'] = '.ogv шүүлтүүрийг идэвхжүүлэх';
$string['mediapluginram'] = '.ram шүүлтүүрийг идэвхжүүлэх';
$string['mediapluginrm'] = '.rm шүүлтүүрийг идэвхжүүлэх';
$string['mediapluginrpm'] = '.rpm шүүлтүүрийг идэвхжүүлэх';
$string['mediapluginwmv'] = '.wmv шүүлтүүрийг идэвхжүүлэх';
$string['mediapluginyoutube'] = 'YouTube холбоосын шүүлтүүрийг идэвхжүүлэх';
$string['messaging'] = 'Зурвасын системийг идэвхжүүлэх';
$string['messagingallowemailoverride'] = 'Мэдэгдлийн цахим шууданг хүчингүй болгох';
$string['messagingallusers'] = 'Сайтын хэмжээнд зурвас бичихийг зөвшөөрөх';
$string['messagingcategory'] = 'Зурвас бичих';
$string['messagingdefaultpressenter'] = 'Өгөгдмөл тохиргоогоор Enter товчлуурыг ашиглан илгээнэ';
$string['messagingdeleteallnotificationsdelay'] = 'Бүх мэдэгдлийг устгах';
$string['messagingdeletereadnotificationsdelay'] = 'Уншсан мэдэгдлийг устгах';
$string['messagingssettings'] = 'Зурвас бичих тохиргоо';
$string['minpassworddigits'] = 'Цифр';
$string['minpasswordlength'] = 'Нууц үгийн урт';
$string['minpasswordlower'] = 'Жижиг үсэг';
$string['minpasswordnonalphanum'] = 'Тусгай тэмдэгтүүд';
$string['minpasswordupper'] = 'Том үсэг';
$string['misc'] = 'Бусад';
$string['mlbackendsettings'] = 'Машин сургалтын суурь тохиргоо';
$string['mnetrestore_extusers'] = '<strong>Тэмдэглэл:</strong> Энэхүү нөөц файл нь процессын хүрээнд дахин сэргээгдэх алсын зайн Moodle сүлжээний хэрэглэгчийн бүртгэлийг агуулдаг.';
$string['mnetrestore_extusers_admin'] = '<strong>Тэмдэглэл:</strong> Энэхүү нөөц файл нь Moodle системийн өөр суурилуулалтынх байж, алсын зайн Moodle сүлжээний хэрэглэгчийн бүртгэлийг агуулдаг байж болзошгүй. Сэргээх процесс нь бүх үүсгэсэн хэрэглэгчийн Moodle сүлжээний хосттой нийцүүлэхийг оролдох болно. Нийцээгүйг нь дотоод баталгаажуулалтад (mnet гэдгийн оронд) автоматаар шилжүүлнэ. Сэргээлтийн лог бүртгэл энэ талаар танд мэдэгдэх болно.';
$string['mnetrestore_extusers_mismatch'] = '<strong>Тэмдэглэл:</strong> Энэхүү файл нь Moodle системийн өөр суурилуулалтынх байж, сэргээх боломжгүй алсын зайн Moodle сүлжээний хэрэглэгчийн бүртгэлийг агуулж байна. Энэ үйлдлийг дэмждэггүй. Хэрэв та энэ нь уг Moodle суурилуулалтад үүсгэгдсэн гэдэгт итгэлтэй, эсвэл шаардлагатай бүх Moodle сүлжээний хостыг тохируулсан гэдгийг баталгаажуулж чадвал сэргээхээр дахин оролдож болох юм.';
$string['mnetrestore_extusers_noadmin'] = '<strong>Тэмдэглэл:</strong> Энэхүү нөөц файл нь Moodle системийн өөр суурилуулалтынх байж, алсын зайн Moodle сүлжээний хэрэглэгчийн бүртгэлийг агуулдаг байж болзошгүй. Та ийм төрлийн сэргээлтийг хийх эрхгүй байна. Сайтын админд хандах эсвэл уг хичээлийг хэрэглэгчийн дурын мэдээлэлгүйгээр (модуль, файл...) сэргээнэ үү.';
$string['mnetrestore_extusers_switchuserauth'] = 'Алсын зайн Moodle сүлжээний  {$a->username} хэрэглэгч ({$a->mnethosturl} хостоос ирсэн) нь локал {$a->auth} баталгаажуулсан хэрэглэгчид шилжсэн.';
$string['mobilenotconfiguredwarning'] = 'Moodle программ идэвхжээгүй байна.';
$string['modassignmentinuse'] = 'Таны сайт Assignment 2.2 нэмэлт хэрэгслийг ашигласаар байна. Шинэчлэхээсээ өмнө 1) хадгалахыг хүссэн дурын Assignment 2.2 үйлдлийг нөөцөлж, даалгаврын үйл ажиллагаа болгон сэргээх, 2) Assignment 2.2 бүх өгөгдлийг өгөгдлийн сангаас устгах шаардлагатай.';
$string['modassignmentsubpluginsexist'] = 'Assignment 2.2. дэд нэмэлт хэрэгсэл байж болно. Модуль/даалгаврын хавтас болон түүний бүх дэд нэмэлт хэрэгслийг шинэчлэхээсээ өмнө устгах шаардлагатай.';
$string['modeditdefaults'] = 'Үйл ажиллагааны тохиргооны өгөгдмөл утгууд';
$string['modsettings'] = 'Үйл ажиллагааг удирдах';
$string['modulesecurity'] = 'Модулийн аюулгүй байдал';
$string['moodleapp'] = 'Moodle программ';
$string['moodleapp_help'] = '<p>Үнэгүй Moodle программ нь хэрэглэгчид гар утаснаасаа хичээлдээ хандах боломжийг олгодог. Программын Pro эсвэл Premium багц нь нэмэлт функцүүдтэй.</p>
<a href="https://moodle.com/mobile-app">Moodle программ татах</a><br />
<a href="https://apps.moodle.com">Moodle программын портал сайт</a>';
$string['moodlebrandedapp'] = 'Байгууллагын нэр, лого бүхий Moodle аппликейшн';
$string['moodlebrandedapp_help'] = '<p>Байгууллагын нэр, лого бүхий Moodle аппликейшн нь Moodle системийн гар утасны үнэ төлбөргүй аппликейшны бүх боломжийг таны брэндтэй хослуулна.</p>
<a href="https://moodle.com/branded-app">Байгууллагын нэр, лого бүхий Moodle аппликейшны тухай</a>';
$string['moodlebrandedappreference'] = 'Өөрийн брэнд бүхий <a href="https://moodle.com/branded-app/">Байгууллагын нэр, лого бүхий Moodle аппликейшнг</a> татаж авна уу.';
$string['moodlepartners'] = 'Moodle түншүүд';
$string['moodlepartners_help'] = '<p>Moodle түншүүд нь Moodle төвөөс хүлээн зөвшөөрсөн, танай байгууллагын  чанартай онлайн сургалтын орчинд өндөр чанартай Moodle үйлчилгээ үзүүлэгчид юм.</p>
<a href="https://moodle.com/about-partners/">Манай түншүүдийн тухай</a><br />
<a href="https://moodle.com/partners">Түнш хайх</a>';
$string['moodleservices'] = 'Moodle үйлчилгээ';
$string['moodleservices_help'] = 'Та эдгээр Moodle үйлчилгээг ашиглан өөрийн Moodle сургалтын орчносс хамгийн сайн үр дүнг хүртэх болно. Үүнд:';
$string['mustenablestats'] = 'Энэ сайт дээр статистик мэдээллийг идэвхжүүлээгүй байна.';
$string['mycourses'] = 'Миний хичээлүүд';
$string['mydashboard'] = 'Системийн өгөгдмөл удирдах самбар';
$string['mymoodle'] = 'Удирдах самбар';
$string['mypage'] = 'Өгөгдмөл удирдах самбарын хуудас';
$string['mypagelocked'] = 'Өгөгдмөл хуудсыг түгжих';
$string['myprofile'] = 'Профайлын өгөгдмөл хуудас';
$string['navadduserpostslinks'] = 'Хэрэглэгчийн нийтлэлийг үзэх холбоосыг нэмэх';
$string['navadduserpostslinks_help'] = 'Идэвхжүүлсэн тохиолдолд хэрэглэгчийн эхлүүлсэн хэлэлцүүлэг, сайтын форум эсвэл тодорхой хичээлд хэрэглэгчийн оруулсан нийтлэлийг үзэхийн тулд удирдлагын мөрөнд  хэрэглэгч бүрд хоёр холбоосыг нэмэх болно.';
$string['navcourselimit'] = 'Хичээлийн хэмжээ';
$string['navigationupgrade'] = 'Энэ шинэчлэл нь Удирдлага, Хичээл, Үйл ажиллагаа, Оролцогчид гэсэн блокыг орлох удирдлагын хоёр шинэ блоктой. Хэрэв та эдгээр блокт дурын тусгай зөвшөөрлийг олгосон бол бүх зүйл таны хүссэнээр ажиллаж байгаа эсэхийг шалгах хэрэгтэй.';
$string['navshowallcourses'] = 'Бүх хичээлийг харуулах';
$string['navshowcategories'] = 'Хичээлийн ангиллыг харуулах';
$string['navshowfrontpagemods'] = 'Удирдлагын талбарт сайтын нүүр хуудасны үйл ажиллагааг харуулах';
$string['navshowfrontpagemods_help'] = 'Идэвхжүүлсэн тохиолдолд сайтын нүүр хуудасны үйл ажиллагааг сайтын хуудасны удирдлагын талбарт харуулах болно. Уг тохиргоо нь зөвхөн сонгодог загварт суурилсан загварт хамаарна.';
$string['navshowfullcoursenames'] = 'Хичээлийн бүтэн нэрийг харуулах';
$string['navshowfullcoursenames_help'] = 'Идэвхжүүлсэн тохиолдолд удирдлагын талбарт хичээлийн богино нэрийг бус, бүтэн нэрийг ашиглах болно.';
$string['navshowmycoursecategories'] = 'Миний хичээлийн ангиллыг харуулах';
$string['navshowmycoursecategories_help'] = 'Идэвхжүүлсэн тохиолдолд удирдлагын блокын ангилалд хэрэглэгчийн Миний хичээлүүд хэсэг харагдах болно (зөвхөн сонгодог загварт суурилсан загварт).';
$string['navsortmycourseshiddenlast'] = 'Миний нууцалсан хичээлүүдийг хамгийн сүүлд эрэмбэлэх';
$string['navsortmycourseshiddenlast_help'] = 'Идэвхжүүлсэн тохиолдолд харагдах хичээлүүдийн араас дурын нууцалсан хичээлийг жагсаах болно (зөвхөн нууцалсан хичээлийг үзэх боломжтой хэрэглэгчид зориулсан). Эсрэг тохиолдолд бүх хичээлийг харагдах байдлаас үл хамааран "Миний хичээлийг эрэмбэлэх" тохиргооны дагуу жагсаах болно.';
$string['navsortmycoursessort'] = 'Миний хичээлүүдийг эрэмбэлэх';
$string['navsortmycoursessort_help'] = 'Энэ нь хичээлүүдийг эрэмбэлэх дарааллын дагуу (жишээ нь Сайтын удирдлага > Хичээлүүд > Хичээл ба ангиллыг удирдах хэсэгт тохируулсан дараалал) эсвэл хичээлийн тохиргоогоор цагаан толгойн үсгийн дарааллаар Миний хичээлүүд хэсэгт жагсаагдсан эсэхийг тодорхойлно.';
$string['never'] = 'Хэзээ ч үгүй';
$string['neverdeleteruns'] = 'Ажиллагааг хэзээ ч устгахгүй';
$string['newestdocindexed'] = 'Шинэ баримт бичгийг индексжүүлсэн';
$string['nobookmarksforuser'] = 'Танд ямар нэгэн хавчуурга байхгүй байна.';
$string['nodatabase'] = 'Өгөгдлийн сан байхгүй';
$string['nohttpsformobilewarning'] = 'Хүчинтэй гэрчилгээтэй HTTPS-г идэвхжүүлэхийг зөвлөж байна. Moodle аппликейшн нь хамгаалалттай холболтыг эн түрүүнд ашиглахыг оролдох болно.';
$string['nomissingstrings'] = 'Алга болсон тэмдэгт мөр байхгүй';
$string['none'] = 'Байхгүй';
$string['nonewsettings'] = 'Энэ шинэчлэлийн үед шинэ тохиргоо нэмэгдээгүй.';
$string['nonexistentbookmark'] = 'Таны хүссэн хавчуурга байхгүй байна.';
$string['noreplyaddress'] = 'Хариу өгөхгүй хаяг';
$string['noreplydomain'] = 'Хариу өгөхгүй, домэйн';
$string['noreplydomaindetail'] = 'Хариу өгөхгүй болон тохируулсан домэйны тохиргоо';
$string['noresults'] = 'Үр дүн олдсонгүй.';
$string['noroles'] = 'Үүрэг байхгүй';
$string['nosupportedlogstore'] = 'Дэмжигдсэн лог бүртгэлийн сан олдсонгүй';
$string['noteunneededblocks'] = 'Тайлбар: "Шаардлагагүй блок" гэсэн загварын тохиргоонд заасан блокыг хичээлийн "Блок нэмэх" цэсэд оруулахгүй.';
$string['notifications'] = 'Мэдэгдлүүд';
$string['notifyloginfailures'] = 'Цахим шуудангаар нэвтрэх чадаагүй';
$string['notifyloginthreshold'] = 'Цахим шуудангийн мэдэгдлийн босго шалгуур';
$string['notloggedinroleid'] = 'Зочны үүрэг';
$string['numberofmissingstrings'] = 'Алга болсон тэмдэгт мөрийн тоо: {$a}';
$string['numberofstrings'] = 'Нийт тэмдэгт мөрийн тоо: {$a->strings}<br />Алга болсон: {$a->missing} ({$a->missingpercent}&nbsp;%)';
$string['oauthrefreshtokenexpired'] = 'Таны {$a->siteurl} сайт дээрх {$a->issuer} OAuth үйлчилгээний аль нэгийг шинэчлэх токены хугацаа дууссан. Энэ нь уг үйлчилгээг ашигладаг дурын нэмэлт хэрэгслийн үйл ажиллагааг хязгаарлах болно. Энэ асуудлыг шийдвэрлэхийн тулд OAuth 2 үйлчилгээний тохиргооны хуудаснаас уг үйлчилгээний хүснэгтийн мөрөнд буй "Системийн бүртгэлийг холбох" дүрст тэмдэг дээр дарна. OAuth системийн ижил үйлчилгээний бүртгэлийг ашиглах бүрд нэвтрэх хэрэгтэй.';
$string['oauthrefreshtokenexpiredshort'] = 'Таны {$a->siteurl} сайт дээрх {$a->issuer}-ийн OAuth сэргээх токены хугацаа дууссан.';
$string['onlynoreply'] = 'Зөвхөн хариу өгөхгүй хаягаас ирэх үед';
$string['opcacherecommended'] = 'PHP opcode кэш нь гүйцэтгэлийг сайжруулж, санах ойн хэрэгцээг бууруулдаг тул OPcache өргөтгөлийг санал болгож, бүрэн дэмждэг.';
$string['opensslrecommended'] = 'Нэмэлт OpenSSL санг суулгахыг зөвлөж байна. Энэ нь Moodle сүлжээний функцийг идэвхжүүлдэг.';
$string['opensslrequired'] = 'OpenSSL PHP өргөтгөл нь өдгөө Moodle системд илүү хүчтэй криптографын үйлчилгээ үзүүлэхийг шаардах болсон.';
$string['opentowebcrawlers'] = 'Хайлтын системд нээлттэй';
$string['optionalmaintenancemessage'] = 'Нэмэлт засвар үйлчилгээний зурвас';
$string['order1'] = 'Нэгдүгээр';
$string['order2'] = 'Хоёрдугаар';
$string['order3'] = 'Гуравдугаар';
$string['order4'] = 'Дөрөвдүгээр';
$string['outgoingmailconfig'] = 'Илгээгдэх цахим шуудангийн тохиргоо';
$string['overridetossl'] = 'Нэвтрэх HTTPS одоо хэрэггүй болсон. Энэ тохиолдлыг одоо SSL рүү шаардах болсон. Энэ анхааруулгыг арилгахын тулд config.php дээрх wwwroot-ийг https:// болгож өөрчилнө үү.';
$string['pageinfodebugsummary'] = 'Энэ хуудас нь: {$a}';
$string['passwordchangelogout'] = 'Нууц үгээ өөрчилсний дараа гарах';
$string['passwordchangelogout_desc'] = 'Идэвхжүүлсэн тохиолдолд нууц үг солигдох үед шинэ нууц үгийг зааж өгснөөс бусад хөтчийн бүх сейшн зогсоно. (Энэ тохиргоо нь хэрэглэгчийн бөөнөөр байршуулах замаар нууц үг солиход нөлөөлөхгүй.)';
$string['passwordchangetokendeletion'] = 'Нууц үгээ өөрчилсний дараа веб сервисийн хандалтын токеныг устгах';
$string['passwordchangetokendeletion_desc'] = 'Идэвхжүүлсэн тохиолдолд нууц үг солигдох үед хэрэглэгчийн веб сервисийн бүх хандалтын токеныг устах болно.';
$string['passwordpolicy'] = 'Нууц үгийн бодлого';
$string['passwordpolicycheckonlogin'] = 'Нэвтрэхэд нууц үгийг шалгах';
$string['passwordresettime'] = 'Нууц үг шинэчлэх хүсэлтийг баталгаажуулах хамгийн дээд хугацаа';
$string['passwordreuselimit'] = 'Нууц үгийн эргэлтийн хязгаар';
$string['passwordreuselimit_desc'] = 'Хэрэглэгч нууц үгээ дахин ашиглахыг зөвшөөрөхөөс өмнө нууц үгээ солих ёстой тоо. Өмнө нь ашигласан нууц үгийн хэшийг локал өгөгдлийн сангийн хүснэгтэд хадгалдаг. Энэ функц нь зарим гадаад баталгаажуулалтын нэмэлт хэрэгсэлтэй зохицохгүй байж болзошгүй.';
$string['pathtodot'] = 'dot хүрэх зам';
$string['pathtodot_help'] = 'dot хүртэлх зам. Энэ нь Linux дээр /usr/bin/dot шиг, Windows дээр  C:\\Program Files (x86)\\Graphviz2.38\\bin\\dot.exe шиг, Mac дээр /opt/local/bin/dot шиг зүйл байна. DOT файлаас график үүсгэхийн тулд та dot гүйцэтгэх файлыг суулгаж, энд зааж өгөх ёстой.';
$string['pathtodu'] = 'du хүрэх зам';
$string['pathtogs'] = 'ghostscript хүрэх зам';
$string['pathtogs_help'] = 'Ихэнх Linux суулгацад үүнийг \'/usr/bin/gs\' гэж болно. Windows дээр энэ нь \'c:\\gs\\bin\\gswin32c.exe\' шиг зүйл байна (замд сул зай байхгүй эсэхийг шалгах хэрэгтэй. Шаардлагатай бол \'gswin32c.exe\' болон \'gsdll32.dll\' файлыг шинэ хавтсанд замд нь сул зай байхгүйгээр хуулна)';
$string['pathtopdftoppm'] = 'pdftoppm хүрэх зам';
$string['pathtopdftoppm_help'] = '<a href="https://poppler.freedesktop.org/">Poppler</a> гэдэг нь PDF файлыг PNG форматад хөрвүүлэх pdftoppm хэрэгсэл бүхий PDF рендерлэх сан юм. Гүйцэтгэлийн тухайд ялангуяа том хэмжээтэй файлд ерөнхийдөө Ghostscript ашиглахаас илүү сайн байдаг. Боломжтой бол Ghostscript ашиглахаас илүүтэйгээр pdftoppm ашиглах хэрэгтэй. Ихэнх Linux суулгацад замыг /usr/bin/pdftoppm гэж зааж болно. Эсвэл Linux хувилбараас хамааран poppler-utils эсвэл poppler багцыг суулгах хэрэгтэй. Windows системийн тухайд Cygwin шаардлагатай.';
$string['pathtopgdump'] = 'pg_dump хүрэх зам';
$string['pathtopgdumpdesc'] = 'Үүнийг таны системд нэгээс илүү pg_dump байгаа тохиолдолд л (жишээ нь, нэгээс илүү postgresql хувилбар суулгасан бол) оруулах зайлшгүй шаардлагатай';
$string['pathtopgdumpinvalid'] = 'pg_dump хүрэх зам хүчингүй - зам нь буруу эсвэл биелэгдэх боломжгүй';
$string['pathtophp'] = 'PHP CLI хүрэх зам';
$string['pathtopsql'] = 'psql хүрэх зам';
$string['pathtopsqldesc'] = 'Үүнийг таны системд нэгээс илүү psql байгаа тохиолдолд л (жишээ нь, та нэгээс илүү postgresql хувилбар суулгасан бол) зайлшгүй оруулах шаардлагатай';
$string['pathtopsqlinvalid'] = 'psql хүрэх зам хүчингүй - зам нь буруу эсвэл биелэгдэх боломжгүй';
$string['pathtopython'] = 'Python хүрэх зам';
$string['pathtopythondesc'] = 'Таны биелэгдэх Python хоёртын файлд хүрэх зам (Python 2 ба Python 3 аль аль нь зөвшөөрөгдөх боломжтой).';
$string['pathtosassc'] = 'SassC хүрэх зам';
$string['pathtosassc_help'] = 'SassC хоёртын файлын байршлыг зааж өгснөөр SASS компайлерыг Moodle PHP хэрэгжүүлэлтээс SassC руу шилжүүлнэ. Дэлгэрэнгүй мэдээллийг https://github.com/sass/sassc хаягаар хандан авна уу.';
$string['pcreunicodewarning'] = 'Юникод тэмдэгттэй нийцтэй PCRE PHP өргөтгөлийг ашиглахыг зөвлөж байна.';
$string['perfdebug'] = 'Гүйцэтгэлийн мэдээлэл';
$string['performance'] = 'Гүйцэтгэл';
$string['pgcluster'] = 'PostgreSQL кластер';
$string['pgclusterdescription'] = 'PostgreSQL хувилбар/кластер параметр нь мөрөөр бичих командуудад зориулсан. Хэрвээ та систем дээрээ зөвхөн ганц postgresql-тэй бол эсвэл энэ юу гэдгийг сайн мэдэхгүй байгаа бол хоосон орхино уу.';
$string['phpfloatproblem'] = 'PHP хөвөгч тоотой ажиллахад гэнэтийн асуудал илэрсэн - {$a}';
$string['pid'] = 'PID';
$string['pleaserefreshregistration'] = 'Таны сайт бүртгэгдсэн байна. Бүртгэлийг хамгийн сүүлд {$a} шинэчилсэн байна.<br />\'Сайтын бүртгэл\' төлөвлөгөөт горимоор таны бүртгэлийг шинэчилж байх болно. Та дурын үед бүртгэлээ гараар шинэчлэх боломжтой.';
$string['pleaserefreshregistrationnewdata'] = 'Бүртгэлийн мэдээлэл өөрчлөгдсөн. \'Бүртгэлийг шинэчлэх\' товчийг ашиглан баталгаажуулна уу.';
$string['pleaserefreshregistrationunknown'] = 'Таны сайт бүртгэгдсэн хэдий ч бүртгэсэн огноо тодорхойгүй байна. \'Бүртгэлийг шинэчлэх\' товчийг ашиглан бүртгэлээ шинэчлэх буюу \'Сайтын бүртгэл\' төлөвлөгөөт горимыг идэвхжүүлж бүртгэлээ автоматаар шинэчилнэ үү.';
$string['plugin'] = 'Нэмэлт хэрэгсэл';
$string['plugin_disabled'] = '{$a} идэвхгүй болгосон.';
$string['plugin_enabled'] = '{$a} идэвхтэй болгосон.';
$string['plugins'] = 'Нэмэлт хэрэгслүүд';
$string['pluginscheck'] = 'Хамаарлыг шалгах нэмэлт хэрэгсэл';
$string['pluginscheckfailed'] = '{$a->pluginslist} жагсаалтын хамаарлыг шалгаж чадсангүй';
$string['pluginschecktodo'] = 'Та Moodle системийн энэ хувилбарыг суулгахаасаа өмнө нэмэлт хэрэгслийн бүх шаардлагыг шийдэх ёстой!';
$string['pluginsoverview'] = 'Нэмэлт хэрэгслийн тойм';
$string['pluginsoverviewsee'] = '<a href="{$a->url}">Нэмэлт хэрэгслийн тойм</a> хуудаснаас илүү дэлгэрэнгүй мэдээллийг авна уу.';
$string['policysettings'] = 'Бодлогын тохиргоо';
$string['privacy:metadata'] = 'Удирдлагын нэмэлт хэрэгсэл нь хувийн ямар ч мэдээллийг хадгалахгүй.';
$string['privacyandpolicies'] = 'Нууцлал ба бодлого';
$string['privacysettings'] = 'Нууцлалын тохиргоо';
$string['profilecategory'] = 'Ангилал';
$string['profilecategoryname'] = 'Ангиллын нэр (давтагдашгүй байх ёстой)';
$string['profilecategorynamenotunique'] = 'Энэ ангиллын нэр ашиглагдаж байна';
$string['profilecommonsettings'] = 'Нийтлэг тохиргоо';
$string['profileconfirmcategorydeletion'] = 'Дээрх ангилалд (эсвэл хэрэв дээд ангилалд орсон бол доорх) шилжүүлэх ангиллын {$a} талбар байна.<br />Та уг ангиллыг устгахыг хүсэж байна уу?';
$string['profileconfirmfielddeletion'] = 'Энэ талбарт устгагдах {$a} хэрэглэгчийн бүртгэл байна.<br />Та уг талбарыг устгахыг хүсэж байна уу?';
$string['profilecreatecategory'] = 'Шинэ профайлын ангилал үүсгэх';
$string['profilecreatefield'] = 'Шинэ профайлын талбар үүсгэх';
$string['profilecreatenewcategory'] = 'Шинэ ангилал үүсгэх';
$string['profilecreatenewfield'] = 'Шинэ \'{$a}\' профайлын талбар үүсгэж байна';
$string['profiledefaultcategory'] = 'Бусад талбар';
$string['profiledefaultchecked'] = 'Өгөгдмөл тохиргоогоор идэвхжүүлсэн';
$string['profiledefaultdata'] = 'Өгөгдмөл утга';
$string['profiledeletecategory'] = 'Ангиллыг устгах';
$string['profiledeletefield'] = '\'{$a}\' талбарыг устгах';
$string['profiledescription'] = 'Талбарын тодорхойлолт';
$string['profiledscript'] = 'Энэ скриптыг боловсруулсан';
$string['profiledscriptview'] = 'Энэ скриптын боловсруулсан мэдээллийг харах';
$string['profileeditcategory'] = 'Ангиллыг засварлах: {$a}';
$string['profileeditfield'] = 'Профайлын талбарыг засварлах: {$a}';
$string['profilefield'] = 'Профайлын талбар';
$string['profilefieldcolumns'] = 'Багана';
$string['profilefieldispassword'] = 'Энэ нь нууц үгийн талбар мөн эсэх?';
$string['profilefieldlink'] = 'Холбоос';
$string['profilefieldlink_help'] = 'Бичвэрийг холбоос болгон хувиргахын тулд $$ агуулсан URL хаягийг оруулна. Үүнд, $$ нь бичвэрээр солигдоно. Жишээлбэл, Twitter ID гэдгийг холбоос болгон хувиргахын тулд https://twitter.com/$$ гэж оруулна.';
$string['profilefieldlinktarget'] = 'Нээгдэх холбоос';
$string['profilefieldmaxlength'] = 'Тэмдэгтийн хязгаар';
$string['profilefieldmaxlength_help'] = 'Энэ талбарыг \'Хэрэглэгчийн шинж тэмдгийг харуулах\' тохиргоонд ашиглах хязгаар нь 255 тэмдэгт буюу түүнээс бага байх ёстой.';
$string['profilefieldrows'] = 'Мөр';
$string['profilefields'] = 'Хэрэглэгчийн профайлын талбарууд';
$string['profilefieldsize'] = 'Харуулах хэмжээ';
$string['profileforceunique'] = 'Өгөгдөл нь давтагдашгүй байх ёстой эсэх?';
$string['profileinvaliddata'] = 'Хүчингүй утга';
$string['profilelocked'] = 'Энэ талбар түгжигдсэн эсэх?';
$string['profilemenudefaultnotinoptions'] = 'Өгөгдмөл утга нь сонголтуудын нэг биш болно';
$string['profilemenunooptions'] = 'Цэсийн сонголт байхгүй байна';
$string['profilemenuoptions'] = 'Цэсний сонголтууд (мөр бүрд нэг)';
$string['profilemenutoofewoptions'] = 'Та хамгийн багадаа 2 сонголт хийх ёстой';
$string['profilename'] = 'Нэр';
$string['profilenofieldsdefined'] = 'Ямар ч талбар тодорхойлогдоогүй байна';
$string['profilerequired'] = 'Энэ талбар шаардлагатай эсэх?';
$string['profileroles'] = 'Профайлын харагдах үүрэг';
$string['profilesforenrolledusersonly'] = 'Зөвхөн бүртгүүлсэн хэрэглэгчид зориулсан профайл';
$string['profileshortname'] = 'Товч нэр (давтагдашгүй байх ёстой)';
$string['profileshortnameinvalid'] = 'Энэ товч нэр нь зөвхөн үсэг тоон тэмдэгт (үсэг, тоо) эсвэл доогуур зураас (_) агуулж болно.';
$string['profileshortnamenotunique'] = 'Энэ товч нэр ашиглагдаж байна';
$string['profilesignup'] = 'Бүртгэлийн хуудсан дээр харуулах эсэх?';
$string['profilespecificsettings'] = 'Тусгай тохиргоо';
$string['profilevisible'] = 'Хэнд энэ талбар харагдах вэ?';
$string['profilevisible_help'] = '* Харагдахгүй - Зөвхөн администратор, менежер харах боломжтой хувийн мэдээлэлд зориулагдсан
* Хэрэглэгчид харагдана - Зөвхөн хэрэглэгч, администратор харах боломжтой хувийн мэдээлэлд зориулагдсан
* Хэрэглэгч, багш, админд харагдана - Зөвхөн хэрэглэгч, администратор, багш нар харах боломжтой хувийн мэдээлэлд зориулагдсан (хичээлийн профайл дээр)
* Хүн бүрд харагдана';
$string['profilevisibleall'] = 'Хүн бүрд харагдана';
$string['profilevisiblenone'] = 'Харагдахгүй';
$string['profilevisibleprivate'] = 'Хэрэглэгчид харагдана';
$string['profilevisibleteachers'] = 'Хүн бүрд харагдана';
$string['profiling'] = 'Хуулбарлах';
$string['profilingallowall'] = 'Тасралтгүй хуулбарлалт';
$string['profilingallowall_help'] = 'Энэ тохиргоог идэвхжүүлсэн тохиолдолд Moodle сейшны хугацаанд бүх гүйцэтгэсэн скриптын профайлыг идэвхжүүлэхийн тулд PROFILEALL параметрийг хаана ч (PGC) ашиглаж болно. Үүнийг PROFILEALLSTOP параметр ашиглан зогсоож болно.';
$string['profilingallowme'] = 'Сонгомол хуулбарлалт';
$string['profilingallowme_help'] = 'Энэ тохиргоог идэвхжүүлсэн тохиолдолд PROFILEME параметрийг хаана ч (PGC) сонгон ашиглаж болох бөгөөд энэ скриптын хуулбарлалт хийгдэх болно. DONTPROFILEME параметрийг ашиглан хуулбарлалт хийгдэхээс урьдчилан сэргийлж болно.';
$string['profilingautofrec'] = 'Автомат хуулбарлалт';
$string['profilingautofrec_help'] = 'Энэ тохиргоог хийснээр зарим хүсэлтийг (заасан давтамжаас суурилан санамсаргүй байдлаар - N-ээс 1) сонгон автоматаар хуулбарлаж, цаашдын шинжилгээнд зориулан үр дүнг хадгалах болно. Хуулбарлалтын энэ арга нь оруулах/хасах тохиргоог дагаж мөрддөг болохыг анхаарна уу. Үүнийг 0 болгон тохируулж, автомат хуулбарлалтыг идэвхгүй  болгоно.';
$string['profilingenabled'] = 'Хуулбарлалтыг идэвхжүүлэх';
$string['profilingenabled_help'] = 'Энэ тохиргоог идэвхжүүлсэн тохиолдолд уг сайтад хуулбарлалт хийх боломжтой болох бөгөөд дараагийн сонголтыг тохируулснаар түүний төлөвийг тодорхойлох боломжтой болно.';
$string['profilingexcluded'] = 'Хуулбарлалтыг үл зөвшөөрөх';
$string['profilingexcluded_help'] = '\'Эдгээрийг хуулбарлах\'  тохиргоогоор тодорхойлсон хуулбарлалтаас хасагдах URL хаягийн жагсаалт (таслал эсвэл шинэ мөрөөр тусгаарлагдсан, шууд алгасах wwwroot, шаардах боломжтой).';
$string['profilingimportprefix'] = 'Импортын угтварыг хуулбарлах';
$string['profilingimportprefix_desc'] = 'Илрүүлэхэд хялбар болгохын тулд импортолсон бүх хуулбарлалтыг энд заасан утга бүхий угтвартай болгоно.';
$string['profilingincluded'] = 'Эдгээрийг хуулбарлах';
$string['profilingincluded_help'] = 'Автоматаар хуулбарлагдах URL хаягийн жагсаалт (таслал эсвэл шинэ мөрөөр тусгаарлагдсан, шууд алгасах wwwroot, шаардах боломжтой). Жишээ нь: /index.php, /course/view.php. Түүнчлэн дурын байрлалд * тэмдэгтийг зөвшөөрнө. Жишээ нь: /mod/forum/*, /mod/*/view.php.';
$string['profilinglifetime'] = 'Хуулбарлалтыг хадгалах';
$string['profilinglifetime_help'] = 'Хуучин хуулбарлалтын талаарх мэдээллийг хадгалах хугацааг заах. Хуучин хуулбарлалтыг тодорхой хугацааны дараа хасах болно. Энэ нь \'лавлагаа\' гэж тэмдэглэгдсэн дурын хуулбарлалтыг үл зөвшөөрөхийг анхаарна уу.';
$string['profilingslow'] = 'Хуулбарлалт удаашралтай хуудсууд';
$string['profilingslow_help'] = 'Хамгийн бага хугацааг секундээр тохируулснаар бүх хуудсыг удаашруулан хуулбарлах болно. Зөвхөн ижил скриптын хуулбарлатаас удаашралтай байгаа хуулбарлалтыг  хадгална. Идэвхгүй болгохын тулд 0 болгож тохируулна. Энэ нь хасах тохиргоог хянахыг анхаарна уу.';
$string['protectusernames'] = 'Хэрэглэгчийн нэрийг хамгаалах';
$string['proxybypass'] = 'Төлөөлөх хостыг тойрч гарах';
$string['proxyfixunsafe'] = 'Төлөөлөхгүй дуудлагыг засах';
$string['proxyhost'] = 'Төлөөлөх хост';
$string['proxylogunsafe'] = 'Төлөөлөхгүй дуудлагын лог бүртгэл';
$string['proxypassword'] = 'Төлөөлөх нууц үг';
$string['proxyport'] = 'Төлөөлөх порт';
$string['proxytype'] = 'Төлөөлөх төрөл';
$string['proxyuser'] = 'Төлөөлөх хэрэглэгчийн нэр';
$string['purgecaches'] = 'Бүх кэшийг цэвэрлэх';
$string['purgecachesconfirm'] = 'Moodle нь загвар, JavaScript, хэлний тэмдэгт мөр, шүүсэн бичвэр, rss мэдэгдэл болон тооцоолсон өгөгдлийн бусад олон хэсгийг кэшлэх боломжтой. Эдгээр кэшийг цэвэрлэснээр тухайн өгөгдлийг серверээс устгаж, хөтчийг өгөгдлийг дахин ачаалахад хүргэдэг бөгөөд ингэснээр танд идэвхтэй кодоор боловсруулсан хамгийн сүүлийн үеийн утгыг харуулах болно. Кэшийг цэвэрлэхэд ямар ч аюул байхгүй боловч сервер болон үйлчлүүлэгчид шинэ мэдээллийг тооцоолж, тэдгээрийг кэшлэх хүртэл хэсэг хугацаанд таны сайт удааширч болзошгүй.';
$string['purgecachesfinished'] = 'Бүх кэшийг цэвэрлэсэн.';
$string['purgecachesnoneselected'] = 'Цэвэрлэх нэг буюу хэд хэдэн кэшийг сонгох';
$string['purgecachespage'] = 'Кэшийг цэвэрлэх';
$string['purgefiltercache'] = 'Бичвэрийн шүүлтүүр';
$string['purgejscache'] = 'JavaScript';
$string['purgelangcache'] = 'Хэлний тэмдэгт мөр';
$string['purgemuc'] = 'Бүх MUC кэш';
$string['purgeothercaches'] = 'Бүх файл болон бусад кэш';
$string['purgeselectedcaches'] = 'Сонгосон кэшийг цэвэрлэх';
$string['purgeselectedcachesfinished'] = 'Сонгосон кэшийг цэвэрлэсэн.';
$string['purgetemplates'] = 'Загвар';
$string['purgethemecache'] = 'Загвар';
$string['query'] = 'Асуулга';
$string['question'] = 'Асуулт';
$string['questionbehaviours'] = 'Асуултын шинж чанар';
$string['questioncwqpfscheck'] = 'Асуулт-хариултын нэг буюу хэд хэдэн санамсаргүй асуултыг хуваалцсан болон хуваалцаагүй асуултын ангиллаас асуулт сонгохоор тохируулсан. <a href="{$a->reporturl}">санамсаргүй асуултын тайлан</a> болон <a href="{$a->docsurl}">баримт бичгийг</a> харна уу.';
$string['questioncwqpfsok'] = 'Сайн байна. Таны асуулт-хариултад хуваалцсан болон хуваалцаагүй асуултын ангиллаас асуулт сонгохоор тохируулсан \'санамсаргүй\' асуултууд байхгүй байна.';
$string['questiontype'] = 'Асуултын төрөл';
$string['questiontypes'] = 'Асуултын төрлүүд';
$string['quizattemptsupgradedmessage'] = 'Moodle 2.1 хувилбарт асуултад томоохон шинэчлэл хийсэн. Өгөгдлийн сангийн шинэчлэлтийн зарим хэсгийг дараа нь ажиллуулахын тулд хойшлуулах боломжтой болсон. Энэ шинэчлэлийг Moodle 2.7 хувилбараар шинэчлэхээс өмнө хийх шаардлагатай.';
$string['recaptchaprivatekey'] = 'ReCAPTCHA нууц түлхүүр';
$string['recaptchapublickey'] = 'ReCAPTCHA сайтын түлхүүр';
$string['referrernone'] = 'Өгөгдмөл хөтөч';
$string['referrerpolicy'] = 'Хамаарагчийн бодлого';
$string['referrerpolicydesc'] = 'Сайтынхаа хариу лавлагаа бүхий хамаарагчийн бодлогын толгой хэсгийг тохируулна.';
$string['register'] = 'Сайтаа бүртгүүлэх';
$string['registration'] = 'Бүртгэл';
$string['registration_help'] = 'Бүртгүүлснээр:

* Та аюулгүй байдлын сэрэмжлүүлгийг хүлээн авах болно
* Та өөрийн сайтаас гар утасны аппликейшны мэдэгдлийг идэвхжүүлэх боломжтой болно
* Та дэлхий даяарх Moodle статистик мэдээлэлд хувь нэмрээ оруулах болно';
$string['registrationwarning'] = 'Таны сайт хараахан бүртгэгдээгүй байна.';
$string['registrationwarningcontactadmin'] = 'Таны сайт хараахан бүртгэгдээгүй байна. Администратортоо мэдэгдэнэ үү.';
$string['releasenoteslink'] = 'Moodle системийн энэ хувилбарын талаарх мэдээллийг онлайнаар <a target="_blank" href="{$a}">Хувилбарын тайлбар</a> харна уу.';
$string['rememberuserlicensepref'] = 'Хэрэглэгчийн лицензийн сонголтыг сануулах';
$string['rememberuserlicensepref_help'] = 'Идэвхжүүлсэн тохиолдолд файл сонгогч дээр файл байршуулах үед хэрэглэгчийн сонгосон сүүлийн лицензийг урьдчилан сонгох болно. Эсрэг тохиолдолд сайтын өгөгдмөл лицензийг урьдчилан сонгосон байна.';
$string['rememberusername'] = 'Хэрэглэгчийн нэрийг сануулах';
$string['rememberusername_desc'] = 'Хэрэглэгч нэвтрэх үед хэрэглэгчийн нэр бүхий тогтмол күүкийг хадгалах тохиолдолд идэвхжүүлнэ. Тогтмол күүкийг зөвшөөрөлгүйгээр ашигласан тохиолдолд нууцлалын асуудал гэж үзэж болно.';
$string['replacefrontsearch'] = 'Сайтын нүүр хуудсыг хичээлийг хайхад ашигладаг';
$string['reportsmanage'] = 'Тайланг удирдах';
$string['required'] = 'Шаардлагатай';
$string['requiredentrieschanged'] = 'Тайлбар: Шинэчилсний дараа \'Үзэхээс өмнөх шаардлагатай бичлэгүүд\' тохиргоог дараах өгөгдлийн сангийн үйл ажиллагаанд шаардана:<br/>{$a->text}<br/>';
$string['requiremodintro'] = 'Үйл ажиллагааны тодорхойлолтыг шаардах';
$string['requiremodintro_desc'] = 'Идэвхжүүлсэн тохиолдолд хэрэглэгчийг үйл ажиллагаа тус бүрийн тодорхойлолтыг оруулахыг шаардах болно.';
$string['requires'] = 'Шаарддаг';
$string['resetindentation'] = 'Догол мөрийг дахин тохируулах';
$string['resetindentation_help'] = 'Энэ нь {$a->format} хичээлд өмнө тохируулсан догол мөрийг арилгах болно.';
$string['resetindentation_title'] = 'Хичээлийн хуудасны догол мөрийг дахин тохируулах эсэх?';
$string['resetindentationsuccess'] = 'Догол мөрийг дахин тохируулах';
$string['restorecourse'] = 'Хичээлийг сэргээх';
$string['restorernewroleid'] = 'Хичээлийн сэргээгчийн эрх';
$string['restorernewroleid_help'] = 'Хэрэв хэрэглэгч шинээр сэргээсэн хичээлийг удирдах зөвшөөрөлгүй бол тухайн хэрэглэгчид энэ үүргийг автоматаар оноож, шаардлагатай бол бүртгэнэ. Хэрэв та сэргээгчийг сэргээсэн хичээл бүрийг удирдахыг хүсэхгүй байгаа бол "Үгүй" гэдгийг сонгоно.';
$string['resultfilter'] = 'Үр дүнгээр шүүх';
$string['reverseproxy'] = 'Урвуу төлөөлөгч';
$string['reverseproxyignore'] = 'Урвуу төлөөлөгчийг алгасах';
$string['riskconfig'] = 'Хэрэглэгч сайтын тохиргоо болон шинж чанарыг өөрчлөх боломжтой';
$string['riskconfigshort'] = 'Тохиргооны эрсдэл';
$string['riskdataloss'] = 'Хэрэглэгч их хэмжээний агуулга эсвэл мэдээллийг устгах боломжтой';
$string['riskdatalossshort'] = 'Өгөгдөл алдагдах эрсдэл';
$string['riskmanagetrust'] = 'Хэрэглэгч нь бусад хэрэглэгчийн итгэлцлийн тохиргоог өөрчлөх боломжтой';
$string['riskmanagetrustshort'] = 'Итгэлцлийг удирдах';
$string['riskpersonal'] = 'Хэрэглэгч нь бусад хэрэглэгчийн хувийн мэдээлэлд хандах боломжтой';
$string['riskpersonalshort'] = 'Нууцлалын эрсдэл';
$string['riskspam'] = 'Хэрэглэгч нь сайтын хэрэглэгч болон бусдад спам илгээх боломжтой';
$string['riskspamshort'] = 'Спамын эрсдэл';
$string['riskxss'] = 'Хэрэглэгч нь XSS зөвшөөрдөг файл болон бичвэрийг нэмэх боломжтой';
$string['riskxssshort'] = 'XSS эрсдэл';
$string['roleswithexceptions'] = '{$a->exceptions} бүхий {$a->roles}';
$string['rssglobaldisabled'] = 'Сайтын түвшинд идэвхгүй болгосон';
$string['save'] = 'Хадгалах';
$string['savechanges'] = 'Өөрчлөлтийг хадгалах';
$string['scssinvalid'] = 'SCSS код буруу, алдаа нь: {$a}';
$string['search'] = 'Хайх';
$string['searchablecourses'] = 'Хайх боломжтой хичээлүүд';
$string['searchallavailablecourses'] = 'Хайх боломжтой хичээлүүд';
$string['searchallavailablecourses_desc'] = 'Зарим тохиолдолд хайлтын систем нь олон тооны хичээлд хайлт хийх үед ажиллахгүй байж болно. Хайх хичээлийн тоог хязгаарлах шаардлагатай бол зөвхөн бүртгүүлсэн хичээлд  хайлт хийхээр тохируулна.';
$string['searchallavailablecourses_off'] = 'Зөвхөн бүртгүүлсэн хичээлүүдээс хайх';
$string['searchallavailablecourses_on'] = 'Хэрэглэгч хандах боломжтой бүх хичээлээс хайх';
$string['searchallavailablecoursesdesc'] = 'Зөвхөн бүртгүүлсэн хичээлүүдээс хайлт хийхээр тохируулсан тохиолдолд хичээлийн мэдээлэл (нэр, хураангуй) болон агуулгыг зөвхөн тухайн хэрэглэгчийн бүртгүүлсэн хичээлүүдээс хайх болно. Эсрэг тохиолдолд хичээлийн мэдээлэл болон агуулгыг зочны хандалтыг идэвхжүүлсэн хичээл гэх мэт тухайн хэрэглэгчийн хандах боломжтой бүх хичээлээс хайх болно.';
$string['searchalldeleted'] = 'Бүх индекслэгдсэн агуулгыг устгасан';
$string['searchalternatesettings'] = 'Зөвхөн асуулгын хувилбарын тохиргоо';
$string['searchalternatesettings_desc'] = 'Эдгээр тохиргоог хийж дуусгавал \'Нээлттэй хайлтыг удирдах\' хуудасны зөвхөн асуулгын хайлтын системийн сонголтоос уг хайлтын системийн \'хувилбарын тохиргоо\' гэдгийг сонгож болно. Энэ нь зөвхөн ижил төрлийн хоёр хайлтын системийн хооронд шилжихэд хэрэгтэй байдаг.';
$string['searchareadisabled'] = 'Хайлтын хэсгийг идэвхгүй болгосон';
$string['searchareaenabled'] = 'Хайлтын хэсгийг идэвхжүүлсэн';
$string['searchareas'] = 'Хайлтын хэсэг';
$string['searchbanner'] = 'Хайлтын мэдээлэл';
$string['searchbannerenable'] = 'Хайлтын мэдээллийг харуулах';
$string['searchbannerenable_desc'] = 'Идэвхжүүлсэн тохиолдолд бүх хэрэглэгчид хайлтын дэлгэцийн дээд хэсэгт доорх бичвэрийг харуулна. Үүнийг хайлтын системийн засвар үйлчилгээ хийгдэж байгааг хэрэглэгчдэд мэдэгдэхэд ашиглаж болно.';
$string['searchdefaultcategory'] = 'Өгөгдмөл хайлтын ангилал';
$string['searchdefaultcategory_desc'] = 'Сонгосон хайлтын хэсгийн ангиллын үр дүнг өгөгдмөл байдлаар харуулах болно.';
$string['searchdeleteindex'] = 'Бүх индексжлэгдсэн агуулгыг устгах';
$string['searchdisplay'] = 'Хайлтын үр дүнг харуулах сонголтууд';
$string['searchenablecategories'] = 'Үр дүнг төрөл бүрийн ангиллаар харуулах';
$string['searchenablecategories_desc'] = 'Идэвхжүүлсэн тохиолдолд хайлтын үр дүнг төрөл бүрийн ангиллаар харуулах болно.';
$string['searchengine'] = 'Хайлтын систем';
$string['searchenginealternatesettings'] = '{$a} (хувилбарын тохиргоо)';
$string['searchenginequeryonly'] = 'Зөвхөн асуулгын хайлтын систем';
$string['searchenginequeryonly_desc'] = 'Энэ хайлтын систем нь зөвхөн асуулга хийхэд ашиглагдах бөгөөд индекслэдэггүй. Уг функцийг ашиглан төрөл бүрийн хайлтын системд дахин индексэлж, улмаар хэрэглэгчийн асуулгыг үргэлжлүүлэн ажиллуулах боломжтой.';
$string['searchenginequeryonly_none'] = 'Байхгүй (асуулгад үндсэн хайлтын системийг ашиглах)';
$string['searchenginequeryonlysame'] = 'Зөвхөн асуулгын хайлтын систем болон үндсэн хайлтын системийг ижил утгаар тохируулах боломжгүй.';
$string['searchhideallcategory'] = 'Бүх үр дүнгийн ангиллыг нуух';
$string['searchhideallcategory_desc'] = 'Сонгосон тохиолдолд хайлтын үр дүнгийн дэлгэц дээр бүх илэрц бүхий ангиллыг нуух болно.';
$string['searchincludeallcourses'] = 'Харагдах бүх хичээлийг оруулах';
$string['searchincludeallcourses_desc'] = 'Идэвхжүүлсэн тохиолдолд хайлтын илэрц нь тухайн хичээлийн агуулгад хандах эрхгүй  хэрэглэгчид харагдах хичээлийн мэдээллийг (нэр, хураангуй) агуулах болно.';
$string['searchindexactions'] = 'Үйлдлийг индекслэх';
$string['searchindexdeleted'] = 'Индексийг устгасан';
$string['searchindextime'] = 'Индекслэх хугацааны хязгаар';
$string['searchindextime_desc'] = 'Их хэмжээний шинэ агуулгыг индекслэх үед төлөвлөгөөт ажил нь энэ хугацааны хязгаарт хүрсний дараа зогсох болно. Энэ нь дараагийн удаа ажиллуулахад үргэлжлэн хийгдэх болно.';
$string['searchindexupdated'] = 'Хайлтын системийн агуулга шинэчлэгдсэн';
$string['searchindexwhendisabled'] = 'Идэвхгүй болсон үед индекслэх';
$string['searchindexwhendisabled_desc'] = 'Хайлтыг идэвхгүй болгосон ч хайлтын индексийг бий болгох төлөвлөгөөт ажлыг зөвшөөрдөг. Энэ нь суралцагчид хайлтын хэрэгслийг харуулахаас өмнө индекслэх тохиолдолд хэрэг болно.';
$string['searchinsettings'] = 'Тохиргооноос хайх';
$string['searchlastrun'] = 'Сүүлийн хайлт (хугацаа, # баримт, # бичлэг, # үл тооцсон)';
$string['searchmanagement'] = 'Хайлтын удирдлага';
$string['searchmanagement_desc'] = 'Эдгээр сонголт нь сэргээхэд удаан хугацаа шаарддаг маш том хайлтын индекс бүхий сайтуудад өөрчлөлт хийхэд хэрэгтэй байдаг.';
$string['searchmaxtopresults'] = 'Хамгийн дээд илэрцүүд';
$string['searchmaxtopresults_desc'] = 'Хичээлийн агуулга, хичээл, хэрэглэгчийн хайлтын илэрцийн дээр харуулах хамгийн өндөр зэрэглэлийн илэрцийн хамгийн их тоо.';
$string['searchnotavailable'] = 'Хайлт хийх боломжгүй';
$string['searchoptions'] = 'Хайлтын сонголтууд';
$string['searchpartial'] = '(хараахан бүрэн индекслэгдээгүй)';
$string['searchreindexed'] = 'Сайтын бүх агуулгыг дахин индекслэсэн.';
$string['searchreindexindex'] = 'Сайтын бүх агуулгыг дахин индекслэх';
$string['searchresults'] = 'Хайлтын илэрцүүд';
$string['searchsetupinfo'] = 'Хайлтын тохиргоо';
$string['searchteacherroles'] = 'Багшийн үүрэг';
$string['searchteacherroles_desc'] = 'Хайлтын илэрцэд хэрэглэгчийн эрхийн зэрэглэлийг өндөр болгох бүх эрхийг сонгоно.';
$string['searchtopresults'] = 'Дээд илэрцүүд';
$string['searchupdateindex'] = 'Индекслэсэн агуулгыг шинэчлэх';
$string['sectionerror'] = 'Хэсгийн алдаа!';
$string['secureforms'] = 'Аюулгүй байдлын нэмэлт маягтын ашиглах';
$string['security'] = 'Аюулгүй байдал';
$string['selectdevice'] = 'Төхөөрөмж сонгох';
$string['selectsearchengine'] = 'Хайлтын системийг сонгох';
$string['selecttheme'] = '{$a} төхөөрөмжийн загварыг сонгох';
$string['server'] = 'Сервер';
$string['serverchecks'] = 'Серверийн шалгалт';
$string['serverlimit'] = 'Серверийн хязгаар';
$string['servicespage'] = 'Үйлчилгээ ба тусламжийн холбоос';
$string['sessionautostartwarning'] = '<p>Тохируулгын ноцтой алдаа илэрсэн тул серверийн администраторт мэдэгдэнэ үү.</p><p> Администратор нь Moodle системийг зөв ажиллуулахын тулд PHP тохиргоог өөрчлөх шаардлагатай.</p><p><code>session.auto_start</code> нь <code>off</code> гэж тохируулагдах ёстой.</p><p>Уг тохиргоог <code>php.ini</code>, Apache/IIS <br />тохиргоо эсвэл сервер дээрх <code>.htaccess</code> файлыгзасварлах замаар удирдана.';
$string['sessioncookie'] = 'Күүки угтвар';
$string['sessioncookiedomain'] = 'Күүки домэйн';
$string['sessioncookiepath'] = 'Күүки зам';
$string['sessionhandling'] = 'Сейшн удирдах';
$string['sessiontimeout'] = 'Хугацаа хэтрэлт';
$string['sessiontimeoutwarning'] = 'Хугацаа хэтрэлтийн сануулга';
$string['settingdependenton'] = 'Энэ тохиргоог <strong>{$a}</strong> утгад үндэслэн нуух боломжтой.';
$string['settingfileuploads'] = 'Хэвийн үйл ажиллагаанд файл байршуулалт шаардлагатай тул PHP тохиргоонд идэвхжүүлнэ үү.';
$string['settingmaxinputvars'] = 'PHP тохиргооны max_input_vars нь хамгийн багадаа 5000 байхыг зөвлөж байна.';
$string['settingmaxinputvarsrequired'] = 'PHP тохиргооны max_input_vars нь хамгийн багадаа 5000 байх ёстой.';
$string['settingmemorylimit'] = 'Санах ой хангалтгүй байна, PHP тохиргоонд санах ойн дээд хязгаарыг тохируулна уу.';
$string['settingsafemode'] = 'Moodle нь аюулгүй горимд бүрэн нийцэхгүй байгаа тул серверийн администраторт хандан үүнийг унтраана уу. Moodle системийг аюулгүй горимд ажиллуулах нь боломжгүй тул төрөл бүрийн асуудал гарч болзошгүй.';
$string['setupsearchengine'] = 'Хайлтын системийг тохиуулах';
$string['showcommentscount'] = 'Сэтгэгдлийн тоог харуулах';
$string['showdetails'] = 'Дэлгэрэнгүй мэдээллийг харуулах';
$string['showuseridentity'] = 'Хэрэглэгчийн хувийн мэдээллийг харуулах';
$string['showuseridentity_desc'] = 'Хэрэглэгчийг сонгох, хайх, хэрэглэгчийн жагсаалтыг харуулахад хэрэглэгчийн бүтэн нэрийн хамтаар эдгээр талбарыг харуулах боломжтой. Талбарууд нь зөвхөн moodle/site:viewuseridentity бүхий хэрэглэгчид, өгөгдмөл тохиргоогоор багш, менежерт харагдана. (Байгууллагад заавал байх ёстой нэг эсвэл хоёр талбарыг сонгох нь илүү үр дүнтэй.)

* гэсэн тэмдэглэгээ бүхий талбар нь хэрэглэгчийн хувийн тохиргооны талбар болно. Эдгээр талбарыг сонгож болох ч одоогоор харагдахгүй зарим харагдац бий.';
$string['simplexmlrequired'] = 'Moodle системд SimpleXML PHP өргөтгөл шаардлагатай.';
$string['sitemailcharset'] = 'Тэмдэгтийн багц';
$string['sitemaintenance'] = 'Сайтад засвар үйлчилгээ хийгдэж байгаа тул одоогоор хандах боломжгүй';
$string['sitemaintenancemode'] = 'Засвар үйлчилгээний горим';
$string['sitemaintenanceoff'] = 'Засвар үйлчилгээний горимыг идэвхгүй болгосон тул сайт хэвийн ажиллаж байна';
$string['sitemaintenanceon'] = 'Таны сайт одоогоор засвар үйлчилгээний горимд байна (зөвхөн админ нэвтрэх эсвэл сайтыг ашиглах боломжтой).';
$string['sitemaintenanceoncli'] = 'Таны сайт одоогоор CLI засвар үйлчилгээний горимд байгаа тул веб хандалтыг зөвшөөрөхгүй.';
$string['sitemaintenancetitle'] = '{$a} засвар үйлчилгээ хийгдэж байна';
$string['sitemaintenancewarning'] = 'Таны сайт одоогоор засвар үйлчилгээний горимд байна (зөвхөн админ нэвтрэх боломжтой). Уг сайтыг хэвийн үйл ажиллагаанд оруулахын тулд <a href="maintenance.php">засвар үйлчилгээний горимыг идэвхгүй болгох</a> хэрэгтэй.';
$string['sitemaintenancewarning2'] = 'Таны сайт одоогоор засвар үйлчилгээний горимд байна (зөвхөн админ нэвтрэх боломжтой). Уг сайтыг хэвийн үйл ажиллагаанд оруулахын тулд <a href="{$a}">засвар үйлчилгээний горимыг идэвхгүй болгох</a> хэрэгтэй.';
$string['sitemenubar'] = 'Сайтын удирдлага';
$string['sitepolicies'] = 'Сайтын аюулгүй байдлын тохиргоо';
$string['sitepolicy'] = 'Сайтын бодлогын URL хаяг';
$string['sitepolicy_help'] = 'Бүртгэлтэй бүх хэрэглэгч сайтад хандахаас өмнө танилцаж, хүлээн зөвшөөрөх ёстой сайтын бодлогын URL хаяг. Энэ тохиргоо нь зөвхөн сайтын бодлого зохицуулагчийг өгөгдмөл (үндсэн) гэж тохируулсан тохиолдолд л үйлчлэхийг анхаарна уу.';
$string['sitepolicyguest'] = 'Зочдод зориулсан сайтын бодлогын URL хаяг';
$string['sitepolicyguest_help'] = 'Бүх зочин сайтад нэвтрэхээс өмнө танилцаж, хүлээн зөвшөөрөх ёстой сайтын бодлогын URL хаяг. Энэ тохиргоо нь зөвхөн сайтын бодлого зохицуулагчийг өгөгдмөл (үндсэн) гэж тохируулсан тохиолдолд л үйлчлэхийг анхаарна уу.';
$string['sitepolicyhandler'] = 'Сайтын бодлого зохицуулагч';
$string['sitepolicyhandler_desc'] = 'Энэ нь бодлого болон хэрэглэгчийн зөвшөөрлийг хэрхэн удирдахыг тодорхойлдог. Өгөгдмөл (үндсэн) зохицуулагч нь сайтын бодлогын URL хаяг болон зочдод зориулсан сайтын бодлогын URL хаягийг идэвхжүүлдэг. Бодлогын зохицуулагч нь сайт, нууцлал болон бусад бодлогыг тохируулах боломжийг олгодог. Энэ нь хэрэглэгчийн зөвшөөрлийг харах, шаардлагатай бол насанд хүрээгүй хүмүүсийн өмнөөс зөвшөөрөл өгөх боломжийг олгодог.';
$string['sitepolicyhandlercore'] = 'Өгөгдмөл (үндсэн)';
$string['sitepolicyhandlerplugin'] = '{$a->name} ({$a->component})';
$string['sitesectionhelp'] = 'Сонгосон тохиолдолд сайтын нүүр хуудсанд сэдвийн хэсгийг харуулах болно.';
$string['sixtyfourbitsrequired'] = 'Таны сайт 64 битийн PHP хувилбарыг ашиглаагүй байна. Та энэ Moodle хувилбарыг суулгахаасаа өмнө системээ (үйлдлийн систем, PHP...) шинэчлэх шаардлагатай.';
$string['sixtyfourbitswarning'] = 'Сайт нь 64 битийн PHP хувилбарыг ашиглахгүй байгаа нь тогтоогдлоо. Цаашид нийцтэй байхын тулд сайтаа шинэчлэхийг зөвлөж байна.';
$string['slasharguments'] = 'Налуу зураастай параметрийг ашиглах';
$string['slashargumentswarning'] = 'Налуу зураастай параметрийг ашиглахыг идэвхжүүлэхийг зөвлөж байна. Энэ нь цаашид зайлшгүй шаардлагатай болно. Дэлгэрэнгүй мэдээллийг <a href="https://docs.moodle.org/en/admin/environment/slasharguments">Налуу зураастай параметр ашиглах</a> баримт бичгээс авна уу.';
$string['smtp'] = 'SMTP';
$string['smtpauthtype'] = 'SMTP баталгаажуулалтын төрөл';
$string['smtpdetail'] = 'Цахим шуудан илгээх энгийн шуудан дамжуулах протокол (SMTP) тохиргоо.';
$string['smtphosts'] = 'SMTP хост';
$string['smtpmaxbulk'] = 'SMTP сейшний хязгаар';
$string['smtppass'] = 'SMTP нууц үг';
$string['smtpsecure'] = 'SMTP аюулгүй байдал';
$string['smtpuser'] = 'SMTP хэрэглэгчийн нэр';
$string['soaprecommended'] = 'Нэмэлт SOAP өргөтгөлийг суулгах нь веб сервис болон зарим нэмэлт хэрэгсэлд хэрэгтэй байдаг.';
$string['sort_fullname'] = 'Хичээлийн бүтэн нэр';
$string['sort_idnumber'] = 'Хичээлийн ID дугаар';
$string['sort_shortname'] = 'Хичээлийн товч нэр';
$string['sort_sortorder'] = 'Эрэмбэлэх дараалал';
$string['spellengine'] = 'Үг үсгийн систем';
$string['spelllanguagelist'] = 'Үг үсгийн хэлний жагсаалт';
$string['splrequired'] = 'Moodle системд SPL PHP өргөтгөл шаардлагатай.';
$string['stats'] = 'Статистик';
$string['statsfirstrun'] = 'Боловсруулах хамгийн их интервал';
$string['statsmaxruntime'] = 'Ажиллах хамгийн их цаг';
$string['statsmoodleorg'] = 'статистик';
$string['statsruntimedays'] = 'Боловсруулах хоног';
$string['statsruntimestart'] = 'Ажиллах';
$string['statsuserthreshold'] = 'Хэрэглэгчийн босго шалгуур';
$string['stickyblocks'] = 'Зохицохгүй блок';
$string['stickyblockscourseview'] = 'Хичээлийн хуудас';
$string['stickyblocksduplicatenotice'] = 'Энд нэмсэн блок нь тодорхой хуудсанд байх тохиолдолд давхардан орох болно.<br /> Үндсэн блокыг засварлах боломжгүй, давхардсан блокыг засварлах боломжтой байна.';
$string['stickyblocksmymoodle'] = 'My Moodle';
$string['stickyblockspagetype'] = 'Тохируулах хуудасны төрөл';
$string['strictformsrequired'] = 'Шаардлагатай талбарыг чандлан баталгаажуулах';
$string['stripalltitletags'] = 'Бүх үйл ажиллагааны нэрээс HTML хаягийг устгах';
$string['supportavailability'] = 'Тусламжийн бэлэн байдал';
$string['supportcontact'] = 'Тусламжийн холбоо барих хаяг';
$string['supportemail'] = 'Тусламжийн цахим шуудан';
$string['supportemailsubject'] = 'Сайтын тусламжийн хүсэлт - {$a}';
$string['supportname'] = 'Тусламжийн нэр';
$string['supportpage'] = 'Сайтыг дэмжих холбоосоор холбогдох';
$string['suspenduser'] = 'Хэрэглэгчийн бүртгэлийг түдгэлзүүлэх';
$string['switchlang'] = 'Хэлний лавлахыг солих';
$string['systempaths'] = 'Системийн замууд';
$string['tablenosave'] = 'Дээрх хүснэгтэд оруулсан өөрчлөлтийг автоматаар хадгална.';
$string['tablesnosave'] = 'Дээрх хүснэгтэд оруулсан өөрчлөлтийг автоматаар хадгална.';
$string['tabselectedtofront'] = 'Таб бүхий хүснэгтэд одоогоор сонгосон таб бүхий мөрийг нүүрэн талд байрлуулах хэрэгтэй';
$string['tabselectedtofronttext'] = 'Сонгосон таб мөрийг нүүрэн талд байрлуулах';
$string['task_adhoc_concurrency_limit'] = 'Түр зуурын ажлын нэгэн зэрэг ажиллах хязгаар';
$string['task_adhoc_concurrency_limit_desc'] = 'Нэгэн зэрэг ажиллуулахыг зөвшөөрсөн түр зуурын ажил гүйцэтгэгчийн тоо. Хязгаар нь өндөр байвал олон тооны түр зуурын ажил хийгдэх үед төлөвлөгөөт ажлууд тодорхой хугацаанд хийгдэхгүй байж болно. Түр зуурын ажлын боловсруулалтыг бүрэн идэвхгүй болгохын тулд 0 гэж тохируулна.';
$string['task_adhoc_max_runtime'] = 'Түр зуурын ажил гүйцэтгэгчийн ашиглалтын хугацаа';
$string['task_adhoc_max_runtime_desc'] = 'Түр зуурын ажил гүйцэтгэгчийн чөлөөлөхөөс өмнөх хугацаа. Дараалалд байгаа түр зуурын ажлын тоог хязгаарладаггүй тул үргэлжлэх хугацааг бага байлгахыг зөвлөж байна. Хэрэв энэ тоо нь хэт өндөр, дараалалд олон тооны түр зуурын ажил байвал төлөвлөгөөт ажлууд тодорхой хугацаанд ажиллахгүй байж болзошгүй.';
$string['task_dbreads'] = 'Өгөгдлийн сангийн уншилт';
$string['task_dbstats'] = 'Өгөгдлийн сан';
$string['task_dbwrites'] = 'Өгөгдлийн сангийн бичилт';
$string['task_duration'] = 'Үргэлжлэх хугацаа';
$string['task_endtime'] = 'Дуусах хугацаа';
$string['task_logmode'] = 'Нэвтрэх үед';
$string['task_logmode_all'] = 'Бүх ажлын гаралтын лог бүртгэлийг хадгалах';
$string['task_logmode_desc'] = 'Хэзээ ажлын лог бүртгэл хийхийг сонгож болно. Өгөгдмөл тохиргоогоор лог бүртгэлийг үргэлж хадгалдаг. Бүртгэлийг бүхэлд нь идэвхгүй болгох эсвэл зөвхөн амжилтгүй ажлыг лог бүртгэлийг өөрчлөх боломжтой.';
$string['task_logmode_failonly'] = 'Зөвхөн амжилтгүй болсон ажлын лог бүртгэлийг хадгалах';
$string['task_logmode_none'] = 'Ямар ч лог бүртгэл хийхгүй';
$string['task_logoutput'] = 'Ажлын гаралт';
$string['task_logretainruns'] = 'Ажиллагааг хадгалах';
$string['task_logretainruns_desc'] = 'Хадгалах ажил бүрийн ажиллагааны тоо. Энэ тохиргоо нь \'Хадгалах хугацаа\' тохиргоотой хамааралтай: аль эхэлж хүрсэн нь хэрэгжинэ.';
$string['task_logretention'] = 'Хадгалах хугацаа';
$string['task_logretention_desc'] = 'Лог бүртгэлийг хадгалах хамгийн их хугацаа. Энэ тохиргоо нь \'Ажиллагааг хадгалах\' тохиргоотой хамааралтай: аль түрүүлж хүрсэн нь хэрэгжинэ';
$string['task_logtostdout'] = 'Лог бүртгэлийн гаралтыг харуулах';
$string['task_logtostdout_desc'] = 'Ажил хийгдэх үед гаралтыг гаралтыг цуглуулах ба цуглуулсан гаралт нь ажил хийгдэж байх үед харагддаг байх ёстой.';
$string['task_result'] = 'Үр дүн';
$string['task_result:failed'] = 'Амжилтгүй';
$string['task_scheduled_concurrency_limit'] = 'Төлөвлөгөөт ажил нэгэн зэрэг хийгдэх хязгаар';
$string['task_scheduled_concurrency_limit_desc'] = 'Нэгэн зэрэг ажиллуулахыг зөвшөөрсөн төлөвлөгөөт ажил гүйцэтгэгчийн оролцогчдын тоо. Хязгаар өндөр байвал серверт өндөр ачаалал үүсэж, гүйцэтгэлд нөлөөлж болзошгүй. Төлөвлөгөөт ажлын боловсруулалтыг бүрэн идэвхгүй болгохын тулд тохиргоог 0 болгон идэвхгүй болгоно.';
$string['task_scheduled_max_runtime'] = 'Төлөвлөгөөт ажил гүйцэтгэгчийн ашиглалтын хугацаа';
$string['task_scheduled_max_runtime_desc'] = 'Төлөвлөгөөт ажил гүйцэтгэгчийг чөлөөлөхөөс өмнөх хугацаа.';
$string['task_starttime'] = 'Эхлэх хугацаа';
$string['task_stats:dbreads'] = '{$a} уншилт';
$string['task_stats:dbwrites'] = '{$a} бичилт';
$string['task_status'] = 'Ажлын төлөв';
$string['task_status_desc'] = '\'{$a->name}\' ажил нь {$a->status} төлөвтэй байна. Дэлгэрэнгүй мэдээллийг <a href="{$a->gotourl}">Төлөвлөгөөт ажлууд</a> хэсгийн {$a->class}{$a->extradescription} хэсгээс харна уу.';
$string['task_type:adhoc'] = 'Түр зуурын';
$string['task_type:scheduled'] = 'Төлөвлөгөөт';
$string['taskadmintitle'] = 'Ажлууд';
$string['taskanalyticscleanup'] = 'Логик анализын аргаар цэвэрлэх';
$string['taskautomatedbackup'] = 'Автомат нөөцлөлт';
$string['taskbackupcleanup'] = 'Нөөц хүснэгт, лог бүртгэл, файлыг цэвэрлэх';
$string['taskbadgescron'] = 'Батламж тэмдэг';
$string['taskbadgesmessagecron'] = 'Тэмдгийн мэдэгдэл илгээх арын боловсруулалт';
$string['taskblogcron'] = 'Гадаад блогуудыг синхрончлох';
$string['taskcachecleanup'] = 'Хугацаа нь дууссан кэш бичлэгийг устгах';
$string['taskcachecron'] = 'Кэшийн арын боловсруулалт';
$string['taskcalendarcron'] = 'Хуанлийн мэдэгдэл илгээх';
$string['taskcheckforupdates'] = 'Шинэчлэлтийг шалгах';
$string['taskcompletiondaily'] = 'Дууссан гэж тэмдэглэх';
$string['taskcompletionregular'] = 'Тодорхой хугацааны гүйцэтгэлийн өгөгдлийг тооцоолох';
$string['taskcontextcleanup'] = 'Сэдвийг арилгах';
$string['taskcreatecontexts'] = 'Алга болсон сэдвийг үүсгэх';
$string['taskdeletecachetext'] = 'Хуучин бичвэр кэш бичлэгийг устгах';
$string['taskdeleteincompleteusers'] = 'Бүрэн бус бүртгэлтэй хэрэглэгчийг устгах';
$string['taskdeleteunconfirmedusers'] = 'Баталгаажаагүй хэрэглэгчийг устгах';
$string['taskeventscron'] = 'Арга хэмжээний арын боловсруулалт';
$string['taskfiletrashcleanup'] = 'Хогийн саванд байгаа файлыг цэвэрлэх';
$string['taskglobalsearchindex'] = 'Нээлттэй хайлтын индексжүүлэлт';
$string['taskglobalsearchoptimize'] = 'Нээлттэй хайлтын индексийг оновчтой болгох';
$string['taskgradecron'] = 'Дүнгийн журналын арын боловсруулалт';
$string['taskgradehistorycleanup'] = 'Үнэлгээний түүхийн хүснэгтийг цэвэрлэх арын боловсруулалт';
$string['taskh5pcleanup'] = 'Ашиглагдаагүй H5P файлыг цэвэрлэх';
$string['tasklegacycron'] = 'Нэмэлт хэрэгслийн хуучин крон боловсруулалт';
$string['tasklockcleanuptask'] = 'Түр зуурын ажлын мета өгөгдлийг цэвэрлэх';
$string['tasklogcleanup'] = 'Ажлын лог бүртгэлийг цэвэрлэх';
$string['tasklogging'] = 'Ажлын лог бүртгэлийн тохиргоо';
$string['tasklogs'] = 'Ажлын лог бүртгэл';
$string['taskmessagingcleanup'] = 'Зурвасын арын боловсруулалт';
$string['taskpasswordresetcleanup'] = 'Нууц үг шинэчлэх оролдлогыг цэвэрлэх';
$string['taskplagiarismcron'] = 'Бүтээлийн хулгайн нэмэлт хэрэгсэл дэх хуучин кроны арын боловсруулалт';
$string['taskportfoliocron'] = 'Портфолио нэмэлт хэрэгслийн арын боловсруулалт';
$string['taskprocessing'] = 'Ажлын боловсруулалт';
$string['taskquestioncron'] = 'Асуултыг урьдчилан харуулахыг цэвэрлэх арын боловсруулалт';
$string['taskquestionstatscleanupcron'] = 'Асуултын статистикийн кэшийг цэвэрлэх арын боловсруулалт';
$string['taskrefreshsystemtokens'] = 'Сервисийн бүртгэлийн OAuth токенг сэргээх';
$string['taskregistrationcron'] = 'Сайтын бүртгэл';
$string['tasksendfailedloginnotifications'] = 'Нэвтрэлт амжилтгүй болсон мэдэгдлийг илгээх';
$string['tasksendnewuserpasswords'] = 'Хэрэглэгчийн шинэ нууц үг илгээх';
$string['tasksessioncleanup'] = 'Хуучин сейшнийг цэвэрлэх';
$string['taskstatscron'] = 'Статистикийн арын боловсруулалт';
$string['tasktagcron'] = 'Тагийн арын боловсруулалт';
$string['tasktempfilecleanup'] = 'Хуучирсан түр файлыг устгах';
$string['tasktype'] = 'Төрөл';
$string['tempdatafoldercleanup'] = 'Үүнээс өмнөх түр өгөгдлийн файлыг цэвэрлэх';
$string['templates'] = 'Загвар';
$string['testoutgoingmailconf'] = 'Илгээгдэх цахим шуудангийн тохиргоог туршин шалгах';
$string['testoutgoingmailconf_errorcommunications'] = 'Сайт нь цахим шуудангийн сервертэй холбогдож чадсангүй. Илгээгдэх цахим шуудангийн тохиргоогоо шалгана уу.';
$string['testoutgoingmailconf_fromemail'] = 'Хэрэглэгчийн нэр эсвэл цахим шуудангийн хаягаас';
$string['testoutgoingmailconf_fromemail_help'] = 'Энэ талбар нь тухайн хэрэглэгчээс зурвас илгээхийг дуурайдаг хэдий ч илгээсэн жинхэнэ цахим шууданд ашигласан илгээгчийн нэрийн хэсэг нь emaildomains зэрэг бусад тохиргооноос хамаардаг.';
$string['testoutgoingmailconf_fromemail_invalid'] = 'Хэрэглэгчийн нэр эсвэл цахим шуудан хүчингүй. Хүчинтэй цахим шуудангийн формат эсвэл Moodle дэх хэрэглэгчийн нэр байх ёстой.';
$string['testoutgoingmailconf_message'] = 'Энэ нь таны сайтад илгээх цахим шууданг амжилттай тохируулсан гэдгийг батлах туршилтын зурвас болно. Илгээсэн: {$a}';
$string['testoutgoingmailconf_sendtest'] = 'Туршилтын зурвас илгээх';
$string['testoutgoingmailconf_sentmail'] = 'Энэ сайтаас цахим шуудангийн серверт туршилтын зурвасыг амжилттай илгээлээ.<br />Хэнээс: {$a->fromemail<br />Хэнд: {$a->toemail}';
$string['testoutgoingmailconf_subject'] = '{$a->site}: туршилтын зурвас. {$a->additional} Илгээсэн: {$a->time}';
$string['testoutgoingmailconf_subjectadditional'] = 'Нэмэлт сэдэв';
$string['testoutgoingmailconf_toemail'] = 'Цахим шуудангийн хаяг руу';
$string['testoutgoingmaildetail'] = 'Тайлбар: Туршилт хийхээсээ өмнө тохиргоогоо хадгална уу.<br />{$a}';
$string['testsiteupgradewarning'] = 'Та одоогоор {$a} туршилтын сайтыг ашиглаж байгаа бөгөөд үүнийг зөв шинэчлэхийн тулд командын мөрийн интерфэйсийн хэрэгслийг ашиглана.';
$string['themedesignermode'] = 'Загвар боловсруулах горим';
$string['themedesignermodewarning'] = 'Загвар боловсруулах горимыг идэвхжүүлсэн. Энэ нь гүйцэтгэлийг мэдэгдэхүйц бууруулж болзошгүй тул хөгжүүлэлтийн сайт дээр үүнийг идэвхжүүлж болохгүй.';
$string['themelist'] = 'Загварын жагсаалт';
$string['themenoselected'] = 'Сонгосон загвар байхгүй';
$string['themeresetcaches'] = 'Загварын кэшийг цэвэрлэх';
$string['themeselect'] = 'Загварыг өөрчлөх';
$string['themeselector'] = 'Загвар сонгогч';
$string['themesettings'] = 'Загварын тохиргоо';
$string['therewereerrors'] = 'Таны өгөгдөлд алдаа байна';
$string['thirdpartylibrary'] = 'Сан';
$string['thirdpartylibrarylocation'] = 'Байрлал';
$string['thirdpartylibs'] = 'Хөндлөнгийн сан';
$string['timezone'] = 'Өгөгдмөл цагийн бүс';
$string['timezoneforced'] = 'Үүнийг админ шаардсан байна';
$string['timezoneinvalid'] = '"{$a}" хүчингүй цагийн бүс';
$string['timezoneisforcedto'] = 'Бүх хэрэглэгчийг ашиглахыг албадах';
$string['timezonenotforced'] = 'Хэрэглэгч өөрийн цагийн бүсийг сонгох боломжтой';
$string['timezonephpdefault'] = 'Өгөгдмөл PHP цагийн бүс ({$a})';
$string['timezoneserver'] = 'Серверийн цагийн бүс ({$a})';
$string['tlswarning'] = 'TLSv1.2 дэмжлэг бүхий PHP/cURL өргөтгөл олдсонгүй. Зарим сервис ажиллахгүй байж магадгүй. TLS санг шинэчлэхийг зөвлөж байна.';
$string['tokenduration'] = 'Хэрэглэгчийн үүсгэсэн токены үргэлжлэх хугацаа';
$string['tokenduration_desc'] = 'Хэрэглэгчийн үүсгэсэн веб сервисийн токены хүчинтэй хугацаа (жишээ нь гар утасны аппликейшнээр).';
$string['tokenizerrecommended'] = 'Нэмэлт PHP Tokenizer өргөтгөлийг суулгахыг зөвлөж байна. Энэ нь Moodle сүлжээний үйл ажиллагааг сайжруулдаг.';
$string['tools'] = 'Админы хэрэгслүүд';
$string['toolsmanage'] = 'Админы хэрэгслийг удирдах';
$string['unattendedoperation'] = 'Хяналтгүй үйлдэл';
$string['unbookmarkthispage'] = 'Энэ хуудасны хавчуургыг авах';
$string['unicoderequired'] = 'Та бүх өгөгдлөө Unicode (UTF-8) форматаар хадгалах шаардлагатай. Шинээр суурилуултыг өгөгдмөл тэмдэгтийн багцыг Юникод гэж тохируулсан өгөгдлийн санд хийх ёстой. Шинэчилж байгаа тохиолдолд UTF-8 хөрвүүлэлтийн процессыг хийх шаардлагатай (Админ хуудсыг харна уу).';
$string['uninstallplugin'] = 'Устгах';
$string['unlockaccount'] = 'Бүртгэлийг нээх';
$string['unoconvwarning'] = 'Таны суулгасан unoconv хувилбар дэмжигдэхгүй байна.';
$string['unsettheme'] = 'Загварын тохиргоог цуцлах';
$string['unsupported'] = 'Дэмжигдээгүй';
$string['unsupporteddbfileformat'] = 'Таны өгөгдлийн сан Antelope форматыг файлын формат болгон ашигладаг. MySQL болон MariaDB дээр бүрэн UTF-8 дэмжихэд Barracuda файлын форматыг шаарддаг. Barracuda файлын форматад шилжинэ үү. Дэлгэрэнгүйг <a href="https://docs.moodle.org/en/admin/environment/custom check/mysql юникодын бүрэн дэмжлэг">MySQL юникодын бүрэн дэмжлэг</a> баримтаас харна уу.';
$string['unsupporteddbfilepertable'] = 'UTF-8 бүрэн дэмжихийн тулд MySQL болон MariaDB аль алиных нь \'innodb_file_per_table\' MySQL тохиргоог \'ON\' болгож өөрчлөх шаардлагатай. Дэлгэрэнгүй мэдээллийг баримт бичгээс авна уу.';
$string['unsupporteddblargeprefix'] = 'UTF-8 бүрэн дэмжихийн тулд MySQL болон MariaDB аль алиных нь \'innodb_large_prefix\' MySQL тохиргоог \'ON\' болгож өөрчлөх шаардлагатай. Дэлгэрэнгүй мэдээллийг баримт бичгээс авна уу.';
$string['unsupporteddbstorageengine'] = 'Ашиглаж буй өгөгдлийн сангийн хадгалалтын системийг дэмжихээ больсон.';
$string['unsupporteddbtablerowformat'] = 'Таны өгөгдлийн санд Antelope файлын формат ашигладаг хүснэгтүүд байна. Хүснэгтийг Barracuda файлын форматад хөрвүүлэхийг зөвлөж байна. InnoDB хүснэгтийг Barracuda руу хөрвүүлэх хэрэгслийн талаарх дэлгэрэнгүй мэдээллийг <a href="https://docs.moodle.org/en/cli">Командын мөрөөр удирдах</a> баримт бичгээс авна уу.';
$string['unsupportedphpversion7'] = 'PHP 7 ба түүнээс дээших хувилбарыг дэмжихгүй.';
$string['unsupportedphpversion71'] = 'PHP 7.1 ба түүнээс дээших хувилбарыг дэмжихгүй.';
$string['unsupportedphpversion72'] = 'PHP 7.2 ба түүнээс дээших хувилбарыг дэмжихгүй.';
$string['unsupportedphpversion73'] = 'PHP 7.3 ба түүнээс дээших хувилбарыг дэмжихгүй.';
$string['unsupportedphpversion74'] = 'PHP 7.4 ба түүнээс дээших хувилбарыг дэмжихгүй.';
$string['unsupportedphpversion80'] = 'PHP 8.0 ба түүнээс дээших хувилбарыг дэмжихгүй.';
$string['unsupportedphpversion81'] = 'PHP 8.1 ба түүнээс дээших хувилбарыг дэмжихгүй.';
$string['unsuspenduser'] = 'Хэрэглэгчийн бүртгэлийг идэвхжүүлэх';
$string['updateaccounts'] = 'Бүртгэлийг шинэчлэх';
$string['updateautocheck'] = 'Одоо байгаа бүртгэлийг шинэчлэх';
$string['updateautocheck_desc'] = 'Идэвхжүүлсэн тохиолдолд таны сайт Moodle код болон бүх нэмэлт хэрэгслийг аль алиных нь шинэчлэлтийг автоматаар шалгах болно. Шинэ шинэчлэлт байвал сайтын админд мэдэгдэл илгээх болно.';
$string['updateavailable'] = 'Moodle шинэ хувилбар бэлэн байна!';
$string['updateavailable_moreinfo'] = 'Илүү мэдээлэл...';
$string['updateavailable_release'] = 'Moodle {$a}';
$string['updateavailable_version'] = 'Хувилбар {$a}';
$string['updateavailabledetailslink'] = 'Дэлгэрэнгүй мэдээллийг {$a->url} хаягаар хандан авна уу';
$string['updateavailableforplugin'] = 'Таны зарим нэмэлт хэрэгслийн шинэ хувилбар бэлэн байна!';
$string['updateavailableinstall'] = 'Энэ шинэчлэлтийг суулгах';
$string['updateavailableinstallall'] = 'Боломжит шинэчлэлтийг суулгах ({$a})';
$string['updateavailableinstallallhead'] = 'Боломжит шинэчлэлтийг суулгах';
$string['updateavailablenot'] = 'Таны Moodle код шинэчлэгдсэн байна!';
$string['updateavailablerecommendation'] = 'Сүүлд хийгдсэн аюулгүй байдал болон алдааны засварыг авахын тулд сайтаа хамгийн сүүлийн хувилбараар шинэчлэхийг зөвлөж байна.';
$string['updatecomponent'] = 'Бүрэлдэхүүн хэсгийг шинэчлэх';
$string['updateminmaturity'] = 'Шаардлагатай кодын хугацаа';
$string['updateminmaturity_desc'] = 'Боломжит код нь хамгийн багадаа сонгосон дуусгавар болсон түвшинд байх тохиолдолд л боломжит шинэчлэлтийн талаар мэдэгдэнэ. Кодын дуусгавар болсон түвшинг зарлаагүй нэмэлт хэрэгслийн шинэчлэлтийг энэ тохиргооноос үл хамааран үргэлж мэдээлэх болно.';
$string['updatenotificationfooter'] = 'Таны Moodle сайт {$a->siteurl} боломжит шинэчлэлтийг автоматаар шалгахаар тохируулагдсан. Та сайтын администраторын хувьд энэ зурвасыг хүлээн авч байна. Та Сайтын удирдлага / Сервер / Шинэчлэлийн мэдэгдэл дэх боломжит шинэчлэлтийг автоматаар шалгахыг идэвхгүй болгох эсвэл энэ зурвасыг өөрийн тохиргооны хуудсаар дамжуулан тохируулах боломжтой.';
$string['updatenotifications'] = 'Мэдэгдлийг шинэчлэх';
$string['updatenotificationsubject'] = 'Moodle шинэчлэлт бэлэн байна ({$a->siteurl})';
$string['updatenotifybuilds'] = 'Шинэчлэлийн талаар мэдэгдэх';
$string['updatenotifybuilds_desc'] = 'Идэвхжүүлсэн тохиолдолд одоогийн хувилбарын шинэчлэлийг гарах үед Moodle код нь  боломжит шинэчлэлийг мөн мэдээлнэ. Шинэчлэл нь тухайн Moodle хувилбарын тасралтгүй сайжруулалт бөгөөд гол төлөв долоо хоног бүр шинэчлэгддэг. Идэвхгүй болгосон бол Moodle системийн илүү өндөр хувилбар гарсан үед л боломжит шинэчлэлийг мэдээлэх болно. Уг тохиргоо нь нэмэлт хэрэгслийг идэвхжүүлэхэд нөлөөлөхгүй.';
$string['upgradeerror'] = '{$a->plugin} нэмэлт хэрэгслийг {$a->version} хувилбараар шинэчлэхэд үл мэдэгдэх алдаа гарлаа. Үргэлжлүүлэх боломжгүй.';
$string['upgradeforumread'] = 'Moodle 1.5 хувилбарт хэлэлцүүлгийн нийтлэлийг уншсан/уншаагүйг хянах шинэ боломж нэмэгдсэн. Уг функцыг хэрэглэхийн тулд <a href="{$a}">хүснэгтээ шинэчлэх шаардлагатайA new feature has been added in Moodle 1.5 to track read/unread forum posts.<br />To use this functionality you need to <a href="{$a}">update your tables</a>.</a>.';
$string['upgradeforumreadinfo'] = 'Moodle 1.5 хувилбарт хэлэлцүүлгийн нийтлэлийг уншсан/уншаагүйг хянах шинэ боломж нэмэгдсэн. Уг функцыг хэрэглэхийн тулд одоо байгаа нийтлэлийн хяналтын бүх мэдээллээр хүснэгтээ шинэчлэх шаардлагатай. Энэ нь сайтын хэмжээнээс хамааран их хугацаа (цаг) шаардаж, өгөгдлийн санд ачаалал үүсгэж болзошгүй тул ачаалал багатай үед хийх хэрэгтэй. Энэ шинэчлэлтийн үед сайт хэвийн ажиллах бөгөөд хэрэглэгчид нөлөө үзүүлэхгүй. Уг процессыг эхлүүлсний дараа дуусгах хэрэгтэй (хөтчийн цонхыг нээлттэй байлгана). Цонхыг хаавал процесс зогсох болно. Үүнд санаа зовох хэрэггүй, дахин эхлүүлж болно.<br /><br />Та шинэчлэх процессыг одоо эхлүүлэхийг хүсэж байна уу?';
$string['upgradekeyreq'] = 'Шинэчлэх түлхүүр шаардлагатай';
$string['upgradekeyset'] = 'Шинэчлэх түлхүүр (тохируулах бол хоосон орхино)';
$string['upgradelogs'] = 'Бүрэн ажиллагааг хангахын тулд таны хуучин лог бүртгэлийг шинэчлэх шаардлагатай. <a href="{$a}">Дэлгэрэнгүй мэдээллийг авна уу</a>';
$string['upgradelogsinfo'] = 'Лог бүртгэлийг хадгалах аргад зарим өөрчлөлт орсон. Бүх хуучин лог бүртгэлийг үйл ажиллагаа тус бүрээр үзэхийн тулд хуучин лог бүртгэлээ шинэчлэх шаардлагатай. Энэ нь сайтын хэмжээнээс хамааран их хугацаа (жишээ нь хэдэн цаг) шаардах бөгөөд том хэмжээний сайтын өгөгдлийн санд ачаалал ихээр үүсгэх болно. Уг процессыг эхлүүлсний дараа дуусгах хэрэгтэй (хөтчийн цонхыг нээлттэй байлгана). Цонхыг хаавал процесс зогсох болно. Үүнд санаа зовох хэрэггүй, лог бүртгэл шинэчлэгдэх үед бусад хэрэглэгчид сайт хэвийн ажиллах болно.<br /><br /> Та лог бүртгэлээ одоо шинэчлэхийг  хүсэж байна уу?';
$string['upgradepluginsfirst'] = 'Эхлээд боломжит бүх шинэчлэлийг суулгахыг зөвлөж байна.';
$string['upgradepluginsinfo'] = 'Нэмэлт хэрэгслийг шинэчилж байна';
$string['upgradepluginsinfo_help'] = 'Таны зарим нэмэлт хэрэгслийн шинэчлэлт гарсан байна. Та эдгээрийг Moodle өгөгдлийн санг шинэчлэхийн өмнө суулгах шаардлагатай. Хэрэв таны сайт автомат шинэчлэлтийг дэмждэггүй бол та сервертээ шинэ нэмэлт хэрэгслийн хувилбарыг гараар татаж авч  суулгах шаардлагатай.';
$string['upgradepluginsinfo_link'] = 'admin/upgradepluginsinfo';
$string['upgradesettings'] = 'Шинэ тохиргоо';
$string['upgradesettingsintro'] = 'Доорх тохиргоо нь таныг хамгийн сүүлд Moodle системээ шинэчлэх үед нэмэгдсэн байна. Өгөгдмөл тохиргоонд шаардлагатай өөрчлөлтийг хийж, дараа нь энэ хуудасны доод хэсэгт байрлах \'Өөрчлөлтийг хадгалах\' товчийг дарна.';
$string['upgradestalefiles'] = 'Moodle системийн холимог хувилбарууд илэрсэн тул шинэчлэлтийг үргэлжлүүлэх боломжгүй';
$string['upgradestalefilesinfo'] = 'Moodle лавлахад хамгийн багадаа Moodle системийн үндсэн хоёр үндсэн хувилбарт PHP скрипт илэрсэн тул Moodle системийн шинэчлэлтийн процесс түр зогссон.

Энэ нь хожим ноцтой асуудал үүсгэж болзошгүй тул үргэлжлүүлэхийн тулд та Moodle лавлах нь зөвхөн Moodle системийн нэг хувилбарын файлыг агуулж байгаа эсэхийг шалгах хэрэгтэй.

Moodle лавлахыг цэвэрлэх аргыг дараах байдлаар зөвлөж байна.Үүнд:

* одоогийн Moodle лавлахын нэрийг "moodle_old" болгон өөрчлөх
* стандарт Moodle багцын татан авалт эсвэл Moodle Git агуулахаас зөвхөн файл агуулсан шинэ Moodle лавлахыг үүсгэх
* эх config.php файл болон дурын стандарт бус нэмэлт хэрэгслийг "moodle_old" лавлахаас шинэ Moodle лавлах руу зөөх

Та Moodle лавлахыг цэвэрлэсний дараа Moodle шинэчлэх үйл явцыг үргэлжлүүлэхийн тулд энэ хуудсыг дахин ачаалах хэрэгтэй.

Энэ анхааруулга нь Moodle системийн өмнөх хувилбар дээр стандарт Moodle багцыг задлахад ихэвчлэн гардаг. Энэ нь бага зэргийн шинэчлэлтэд тохиромжтой боловч Moodle системийн томоохон шинэчлэлтэд хатуу хориглоно.

Энэхүү анхааруулга нь Git агуулахаас бүрэн дуусаагүй эсвэл шинэчлэлт хийснээс үүдэлтэй байж болох бөгөөд энэ тохиолдолд тухайн үйлдлийг дуусгахыг хүлээх эсвэл тохирох цэвэрлэх командыг ажиллуулж, үйлдлийг дахин эхлэх хэрэгтэй.

Та илүү мэдээллийг <a href="{$a}">{$a}</a> дээрх шинэчлэлтийн баримт бичгээс авах боломжтой.';
$string['upgradestart'] = 'Moodle өгөгдлийн санг одоо шинэчлэх';
$string['upgradesure'] = '<p>Таны Moodle файлууд өөрчлөгдсөн бөгөөд та серверээ энэ хувилбараар автоматаар шинэчлэх гэж байна:<p>
<p><strong>{$a}</strong></p>
<p>Та үүнийг эхэлсэн тохиолдолд буцах боломжгүй. Уг процесс нь удаан үргэлжилж болохыг анхаарна уу.</p>
<p>Та энэ серверийг энэ хувилбараар шинэчлэхэд итгэлтэй байна уу?</p>';
$string['upgradetimedout'] = 'Шинэчлэх хугацаа дууссан тул шинэчлэлтийг дахин эхлүүлнэ үү.';
$string['upgradingdata'] = 'Өгөгдлийг шинэчилж байна';
$string['upgradinglogs'] = 'Лог бүртгэлийг шинэчилж байна';
$string['upgradingversion'] = 'Шинэ хувилбараар шинэчилж байна';
$string['upwards'] = 'дээш';
$string['useblogassociations'] = 'Холбоог идэвхжүүлэх';
$string['user'] = 'Хэрэглэгч';
$string['userbulk'] = 'Хэрэглэгчийн бөөнөөр хийсэн үйлдэл';
$string['userbulkdownload'] = 'Хэрэглэгчийг экспортлох';
$string['userdefaultpreferences'] = 'Хэрэглэгчийн өгөгдмөл тохиргоо';
$string['userfeedbackafterupgrade'] = 'Томоохон шинэчлэлт бүрийн дараа';
$string['userfeedbackencouragement'] = '<p>Moodle 3.9 хувилбараас хойш хэрэглэгчид Moodle төвөөс зохион байгуулсан гадаад судалгааны сайтаар дамжуулан Moodle төв рүү Moodle программ хангамжийн талаар санал хүсэлт өгөх боломжийг олгох шинэ функцийг оруулсан. Судалгааны сайтад хэрэглэгчийн таних мэдээллийг дамжуулахгүй.</p>
<p>Moodle төв нь мэдээлэл цуглуулах үйл ажиллагаагаа нээлттэй, ил тод байлгахыг эрмэлздэг. Иймээс энэ функцыг мэдэж, хянаж байгаа эсэхийг шалгахыг хүсэж байна.</p>
<p>Хэрэглэгчийн санал хүсэлт нь Moodle программ хангамжийг сайжруулахад Moodle төвд ихээхэн үүрэгтэй. Энэ функцыг идэвхжүүлэхийн тулд <a href="{$a}">Санал хүсэлтийн тохиргоо</a> хэсэгт хандана уу.</p>';
$string['userfeedbacknextreminder'] = 'Дараагийн санал хүсэлтийн сануулга';
$string['userfeedbacknextreminder_desc'] = 'Хэзээ хэрэглэгчээс дахин санал хүсэлт авах ёстой вэ?';
$string['userfeedbackperiodically'] = 'Тодорхой давтамжтайгаар';
$string['userfeedbackremindafter'] = 'Сануулгыг дараа нь харуулах';
$string['userfeedbackremindafter_desc'] = 'Заасан өдрийн дараа санал хүсэлтээ өгөхийг хэрэглэгчид дахин сануулна.';
$string['userfiltersdefault'] = 'Хэрэглэгчийн өгөгдмөл шүүлтүүр';
$string['userfiltersdefault_desc'] = '\'Хэрэглэгчийн жагсаалтыг үзэх\' хуудас болон \'Хэрэглэгчийн бөөнөөр хийсэн үйлдэл\' хуудсанд харуулах шүүлтүүрийг сонгоно. Хэд хэдэн зүйлийг сонгохын тулд гарын Ctrl товчийг дарна. Сонгогдоогүй дурын шүүлтүүрийг \'Илүү ихийг харуулах\' холбоос дээр дарж үзэх боломжтой.';
$string['userimagesdisabled'] = 'Хэрэглэгчийн профайлын зургийг идэвхгүй болгосон';
$string['userlist'] = 'Хэрэглэгчийн жагсаалтыг гаргах';
$string['usermanagement'] = 'Хэрэглэгчийн удирдлага';
$string['userpolicies'] = 'Хэрэглэгчийн дүрмүүд';
$string['userpreference'] = 'Хэрэглэгчийн тохиргоо';
$string['userquota'] = 'Хувийн файлын зай';
$string['userquota_desc'] = 'Хэрэглэгч бүрийн хувийн файлын талбарт хадгалах өгөгдлийн дээд хэмжээ.';
$string['users'] = 'Хэрэглэгчид';
$string['usesitenameforsitepages'] = 'Сайтын хуудсанд сайтын нэрийг ашиглах';
$string['usetags'] = 'Тагийн ажиллагааг идэвхжүүлэх';
$string['validateemptylineerror'] = 'Хоосон мөр хүчингүй';
$string['validateerror'] = 'Энэ утга хүчингүй';
$string['validateerrorlist'] = 'Эдгээр бичлэг буруу байна: {$ a}';
$string['validateiperror'] = 'Эдгээр IP хаяг буруу байна: {$ a}';
$string['verifychangedemail'] = 'Цахим шууданг өөрчлөх үед домэйныг хязгаарлах';
$string['warningcurrentsetting'] = 'Одоогийн утга буруу байна: {$ a}';
$string['warningiconvbuggy'] = 'Таны iconv сангийн хувилбар нь //IGNORE өөрчлөгчийг дэмждэггүй. Хүчингүй UTF-8 тэмдэгт бүхий тэмдэгт мөрийг цэвэрлэхийн оронд ашиглаж болох mbstring өргөтгөлийг суулгах хэрэгтэй.';
$string['webproxy'] = 'Веб прокси';
$string['webproxyinfo'] = 'Хэрэв Moodle сервер нь интернэтэд шууд нэвтрэх боломжгүй бол дараах сонголтыг бөглөнө үү. Хүрээлэн буй орчны өгөгдөл, хэлний багц, RSS мэдэгдэл, цагийн бүс зэргийг татаж авахын тулд интернэт холболт шаардлагатай.<br /><em> PHP cURL өргөтгөлийг ашиглахыг зөвлөж байна </em>';
$string['xmlrpcwebserviceenabled'] = 'Таны сайт дээр XML-RPC веб сервисийн протокол идэвхжсэн нь тогтоогдлоо. Энэ функц нь PHP сайжруулахаа больсон PHP XML-RPC өргөтгөлд тулгуурладаг.';
$string['yuicomboloading'] = 'YUI комбинацийг ачаалж байна';
$string['ziprequired'] = 'Moodle нь Zip PHP өргөтгөлийг ашиглах шаардлагатай, info-ZIP хоёртын файл эсвэл PclZip санг ашиглахаа больсон.';
