<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'completion', language 'sl', version '4.5'.
 *
 * @package     completion
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['achievinggrade'] = 'Pridobitev ocene';
$string['achievingpassinggrade'] = 'Dosežena pozitivna ovena';
$string['activities'] = 'Dejavnosti';
$string['activitiescompleted'] = 'Zaključek dejavnosti';
$string['activitiescompletednote'] = 'Opomba: Dejavnost se pojavi v zgornjem seznamu, če je zanjo nastavljeno zaključevanje.';
$string['activitieslabel'] = 'Dejavnosti/Viri';
$string['activityaggregation'] = 'Pogoj zahteva';
$string['activityaggregation_all'] = 'VSE izbrane aktivnosti morajo biti zaključene';
$string['activityaggregation_any'] = 'KATERAKOLI izbrana aktivnost mora biti zaključena';
$string['activitycompletion'] = 'Zaključek dejavnosti';
$string['activitycompletionupdated'] = 'Spremembe so shranjene';
$string['activitygradenotrequired'] = 'Ocena ni zahtevana';
$string['activitygradetopassnotset'] = 'Ta dejavnost nima nastavljene ustrezne pozitivne ocene. Oceno lahko nastavite v sekciji Ocena v nastavitvah dejavnosti.';
$string['addconditions'] = 'Vsi pogoji';
$string['affectedactivities'] = 'Spremembe bodo vplivale na sledeče dejavnosti/vire (<b>{$a}</b>):';
$string['aggregationmethod'] = 'Način združevanja';
$string['all'] = 'Vse';
$string['allconditions'] = 'Dejavnost je zaključena, ko udeleženci opravijo vse sledeče:';
$string['any'] = 'Katerikoli';
$string['approval'] = 'Odobritev';
$string['areyousureoverridecompletion'] = 'Ste prepričani, da želite preglasiti trenutno stanje zaključenosti dejavnosti za uporabnika in ga označiti kot "{$a}"?';
$string['badautocompletion'] = 'Ko izberete samodejno zaključevanje, morate omogočiti vsaj eno od zahtev (spodaj).';
$string['badcompletiongradeitemnumber'] = 'Zahteva po oceni ne more biti izbrana za <b>{$a}</b>, ker ta aktivnost ne predvideva ocene.';
$string['bulkactivitycompletion'] = 'Zaključek dejavnosti množičnega urejanja';
$string['bulkactivitydetail'] = 'Izberite aktivnosti, ki jih želite množično urediti.';
$string['bulkcompletiontracking'] = 'Sledenje zaključevanju';
$string['bulkcompletiontracking_help'] = '<strong>Brez:</strong> Brez zaključevanja dejavnosti.

<strong>Ročno:</strong> Udeleženci lahko sami označijo dejavnost kot zaključeno.

<strong>Pod pogoji:</strong> Pokaži dejavnost kot zaključeno, ko so pogoji izpolnjeni';
$string['checkactivity'] = 'Potrditveno polje za dejavnost/vir: {$a}';
$string['checkall'] = 'Preveri ali ne preveri vse dejavnosti in vire';
$string['checkallsection'] = 'Preveri ali ne preveri vse dejavnosti in vire v naslednjem razdelku: {$a}';
$string['completeactivity'] = 'Dokončajte aktivnost';
$string['completed'] = 'Zaključeno';
$string['completedunlocked'] = 'Nastavitve zaključevanja so odklenjene';
$string['completedunlockedtext'] = 'Ko shranite ta obrazec, bodo podatki o zaključevanju izbrisani in, v kolikor bo mogoče, preračunani. Temu se izognete, da stran zapustite brez shranjevanja.';
$string['completedwarning'] = 'Nastavitve zaključevanja so zaklenjene';
$string['completedwarningtext'] = 'Ta dejavnost je označena kot zaključena za enega ali več udeležencev. Če odklenete to nastavitev, da bi jo spremenili in ponovno shranite obrazec, bodo podatki o zaključevanju izbrisani in, v kolikor bo mogoče, preračunani. Ročnih zaključevanj ni mogoče preračunati in bodo v tem primeru udeleženci morali dejavnost ponovno označiti kot zaključeno.';
$string['completion'] = 'Sledenje zaključevanju';
$string['completion-alt-auto-enabled'] = 'Sistem označi to postavko kot zaključeno v skladu s pogoji: {$a}';
$string['completion-alt-auto-fail'] = 'Zaključeno: {$a} (pozitivna ocena ni dosežena)';
$string['completion-alt-auto-n'] = 'Ni zaključeno: {$a}';
$string['completion-alt-auto-n-override'] = 'Ni zaključeno: {$a->modname} (nastavil/-a {$a->overrideuser})';
$string['completion-alt-auto-pass'] = 'Zaključeno: {$a} (pozitivna ocena dosežena)';
$string['completion-alt-auto-y'] = 'Zaključeno: {$a}';
$string['completion-alt-auto-y-override'] = 'Zaključeno {$a->modname} (nastavil/-a {$a->overrideuser})';
$string['completion-alt-manual-enabled'] = 'Udeleženci lahko ročno označijo ta element kot zaključeno: {$a}';
$string['completion-alt-manual-n'] = 'Ni zaključeno: {$a}. Izberite, da označite kot dokončano.';
$string['completion-alt-manual-n-override'] = 'Ni zaključeno: {$a->modname} (nastavil/-a {$a->overrideuser}). Izberite, da označite kot dokončano.';
$string['completion-alt-manual-y'] = 'Zaključeno: {$a}. Izberite, da označite kot nezaključeno.';
$string['completion-alt-manual-y-override'] = 'Zaključeno: {$a->modname} (nastavil/-a {$a->overrideuser}). Izberite, da označite kot nezaključeno.';
$string['completion-fail'] = 'Zaključeno (pozitivna ocena ni dosežena)';
$string['completion-n'] = 'Ni zaključeno';
$string['completion-n-override'] = 'Ni zaključeno (nastavil/-a {$a})';
$string['completion-pass'] = 'Zaključeno (pozitivna ocena dosežena)';
$string['completion-y'] = 'Zaključeno';
$string['completion-y-override'] = 'Zaključeno (nastavil/-a {$a})';
$string['completion_automatic'] = 'Pokaži dejavnost kot zaključeno, ko so pogoji izpolnjeni';
$string['completion_help'] = 'Če je to omogočeno, se sledi zaključevanju aktivnosti, bodisi ročno bodisi avtomatsko (tj. na podlagi določenih pogojev). Določi se lahko več pogojev. V tem primeru se aktivnost zaključi, ko so izpolnjeni VSI pogoji';
$string['completion_link'] = 'dejavnost/zaključenost';
$string['completion_manual'] = 'Udeleženci morajo to dejavnost ročno označiti kot zaključeno';
$string['completion_none'] = 'Ne prikaži zaključek dejavnosti';
$string['completionactivitydefault'] = 'Uporabi privzeto dejavnosti';
$string['completionanygrade_desc'] = 'Katerakoli ocena';
$string['completiondefault'] = 'Privzeto sledenje zaključevanju';
$string['completiondisabled'] = 'Onemogočeno, ni prikazano v nastavitvah dejavnosti';
$string['completionduration'] = 'Vpis';
$string['completionenabled'] = 'Omogočeno, urejanje poteka z nastavitvami zaključevanja in nastavitvami dejavnosti';
$string['completionexpected'] = 'Nastavi opomnik v časovnici';
$string['completionexpected_help'] = 'Ta nastavitev vam omogoča, da udeležencem nastavite opomnik za delo na tej dejavnosti. Prikazan bo v bloku Časovnica na njihovi nadzorni plošči v obliki "{$a} zahteva dejanje".';
$string['completionexpecteddesc'] = 'Pričakovana zaključenost do {$a}';
$string['completionexpectedfor'] = 'Pričakovana zaključenost za \'{$a->modulename}\' dejavnost \'{$a->instancename}\'';
$string['completionicons'] = 'Označni okvirji zaključenosti';
$string['completionicons_help'] = 'Kljukica v kvadratku poleg imena dejavnosti se lahko uporabi kot oznaka za zaključenost dejavnosti.

Če ima okvir <strong>črtkan rob</strong>, se bo kljukica prikazala samodejno, ko bo dejavnost zaključena v skladu s pogoji, ki jih je določil učitelj.

Če ima kvadratek <strong>neprekinjen rob</strong>, se lahko s klikom nanj ročno označi zaključenost. Ponovni klik odstrani kljukico.';
$string['completionmenuitem'] = 'Zaključek';
$string['completionnotenabled'] = 'Zaključevanje ni omogočeno';
$string['completionnotenabledforcourse'] = 'Za ta predmet zaključevanje ni omogočeno';
$string['completionnotenabledforsite'] = 'Za to spletno mesto zaključevanje ni omogočeno';
$string['completionondate'] = 'Datum';
$string['completionondatevalue'] = 'Datum, ko bo predmet označen kot zaključen';
$string['completionpassgrade'] = 'Zahteva pozitivno oceno';
$string['completionpassgrade_desc'] = 'Udeleženec mora doseči pozitivno oceno za zaključevanje te dejavnosti';
$string['completionpassgrade_help'] = 'Če je omogočeno, je dejavnost smatrana kot zaključena, ko udeleženec doseže pozitivno oceno.';
$string['completionsettingslocked'] = 'Nastavitve zaključevanja so zaklenjene';
$string['completionupdated'] = 'Posodobiti zaključevanje za dejavnost <b>{$a}</b>';
$string['completionusegrade'] = 'Zahtevaj oceno';
$string['completionusegrade_desc'] = 'Udeleženec mora dobiti oceno, da zaključi to dejavnost';
$string['completionusegrade_help'] = 'Če je omogočeno, se dejavnost smatra za zaključeno, ko udeleženec dobi oceno. Če je za dejavnost določena pozitivna ocena se v poročilu zaključenosti dejavnosti prikažeta ikoni za opravljeno/ne opravljeno.';
$string['completionview'] = 'Zahtevaj ogled';
$string['completionview_desc'] = 'Udeleženec si mora ogledati to dejavnost, da jo zaključi';
$string['configcompletiondefault'] = 'Privzete nastavitve za sledenje zaključevanju ob tvorjenju aktivnosti.';
$string['configenablecompletion'] = 'Če je to omogočeno, se lahko v nastavitvah dejavnosti nastavijo pogoji za zaključevanje dejavnosti in predmeta. Nastavitev je priporočljiva, saj omogoča, da so na Pregledni plošči prikazani podatki o napredku.';
$string['confirmselfcompletion'] = 'Potrditev ročnega zaključevanja';
$string['courseaggregation'] = 'Pogoj zahteva';
$string['courseaggregation_all'] = 'VSI izbrani predmeti morajo biti zaključeni';
$string['courseaggregation_any'] = 'KATERIKOLI izbrani predmet mora biti zaključen';
$string['coursealreadycompleted'] = 'Predmet je že označen kot zaključen';
$string['coursecomplete'] = 'Predmet zaključen';
$string['coursecompleted'] = 'Predmet zaključen';
$string['coursecompletedmessage'] = '<p>Čestitamo!</p><p>Zaključili ste predmet <a href="{$a->courselink}">{$a->coursename}</a>.</p>';
$string['coursecompletion'] = 'Zaključevanje predmeta';
$string['coursecompletioncondition'] = 'Pogoj: {$a}';
$string['coursecompletionnavigation'] = 'Terciarna navigacija za zaključevanje dejavnosti';
$string['coursecompletionsettings'] = 'Nastavitve zaključevanja dejavnosti';
$string['coursegrade'] = 'Ocena predmeta';
$string['coursesavailable'] = 'Predmeti, ki so na voljo';
$string['coursesavailableexplaination'] = 'Opomba: Da se predmet pojavi na zgornjem seznamu, morajo biti zanj nastavljeni pogoji zaključevanja predmeta.';
$string['criteria'] = 'Kriteriji';
$string['criteriagroup'] = 'Kriterij skupina';
$string['criteriarequiredall'] = 'Vsi spodnji kriteriji so zahtevani';
$string['criteriarequiredany'] = 'Zahtevan je vsaj eden od spodnjih kriterijev';
$string['criteriasummary'] = '{$a->type}: {$a->summary}';
$string['csvdownload'] = 'Prenesi v obliki razpredelnice (UTF-8 .csv)';
$string['datepassed'] = 'Datum je pretekel';
$string['days'] = 'Dnevi';
$string['daysoftotal'] = '{$a->days} od {$a->total}';
$string['daystakingcourse'] = 'Čas opravljanja predmeta';
$string['daysuntilcompletion'] = 'Dni do zaključevanja';
$string['defaultactivitycompletioncourse'] = 'To so privzeti pogoji za zaključevanje dejavnosti v tem predmetu.';
$string['defaultactivitycompletionsite'] = 'To so privzeti pogoji za zaključevanje dejavnosti v vseh predmetih.';
$string['defaultcompletion'] = 'Privzeta nastavitev zaključevanja dejavnosti';
$string['defaultcompletionupdated'] = 'Spremembe so shranjene';
$string['deletecompletiondata'] = 'Izbriši podatke o zaključevanju';
$string['dependencies'] = 'Odvisnosti';
$string['dependenciescompleted'] = 'Zaključevanje drugih predmetov';
$string['detail_desc:receivegrade'] = 'Prejeta ocena';
$string['detail_desc:receivepassgrade'] = 'Dosežena pozitivna ocena';
$string['detail_desc:view'] = 'Ogled';
$string['done'] = 'Opravljeno';
$string['editconditions'] = 'Uredi pogoje';
$string['editcoursecompletionsettings'] = 'Uredi nastavitve zaključevanja predmeta';
$string['emptyconditionsinfo'] = 'Za to dejavnost ni nastavljenega nobenega pogoja za zaključevanje.';
$string['emptyconditionswarning'] = 'Dodati morate vsaj en pogoj za zaključevanje';
$string['enablecompletion'] = 'Omogoči sledenje zaključevanju';
$string['enablecompletion_help'] = 'Če je to omogočeno, lahko nastavite pogoje za zaključevanje dejavnosti ali predmeta.';
$string['enrolmentduration'] = 'Trajanje vpisa';
$string['enrolmentdurationlength'] = 'Uprabnik mora ostati vpisan';
$string['err_noactivities'] = 'Informacija o zaključevanju ni omogočena za nobeno dejavnost, zato je prikaz prazen. Informacije o zaključevanju omogočite z urejanjem nastavitev za posamezno dejavnost.';
$string['err_nocourses'] = 'Zaključevanje predmeta ni omogočeno za noben drugi predmet, zato je prikaz prazen. Zaključevanje predmeta se omogoči v nastavitvah predmeta.';
$string['err_nograde'] = 'Ocena za uspešen zaključek predmeta še ni nastavljena. Da omogočite ta tip kriterija, morate za ta predmet nastaviti zahtevano oceno.';
$string['err_noroles'] = 'V tem predmetu ni vlog z možnostmi \'moodle/course:markcomplete\'.';
$string['err_nousers'] = 'V tem predmetu ni udeležencev ali skupini, za katere bi bile prikazane informacije o zaključenosti. (Privzeto je, da je informacija o zaključevanju prikazana samo za udeležence. Ta napaka se pojavi, če udeleženci niso prisotni. Skrbniki lahko spremenijo to možnost preko skrbniškega okna.)';
$string['err_settingslocked'] = 'Nastavitve so bile zaklenjene, ker je eden ali več udeležencev že izpolnilo kriterije. Odklepanje nastavitev kriterija za zaključevanje bo izbrisalo podatke o zaključevanju , kar lahko povzroči zmedo.';
$string['err_system'] = 'V sistemu zaključevanja je prišlo do napake. (Sistemski skrbniki lahko omogočijo razhroščevalne informacije za ogled več podrobnosti.)';
$string['eventcoursecompleted'] = 'Predmet zaključen';
$string['eventcoursecompletionupdated'] = 'Posodobljeno zaključevanje predmeta';
$string['eventcoursemodulecompletionupdated'] = 'Zaključevanje dejavnosti predmeta je posodobljeno';
$string['eventdefaultcompletionupdated'] = 'Zaključevanje dejavnosti predmeta je posodobljeno';
$string['excelcsvdownload'] = 'Prenesi v Excel-združljivi obliki (.csv)';
$string['failed'] = 'Neuspešno';
$string['fraction'] = 'Ulomek';
$string['graderequired'] = 'Zahtevana ocena pri predmetu';
$string['gradexrequired'] = 'zahtevano: {$a}';
$string['hiddenrules'] = 'Nekatere nastavitve, ki so specifične za <b>{$a}</b>, so skrite. V primeru, da si jih želite ogledati, odznačite druge aktivnosti';
$string['incompatibleplugin'] = 'Ta dejavnost ne podpira privzetih nastavitev za zaključevanje. Pogoje za zaključevanje boste morali nastaviti ročno ob vsaki uporabi.';
$string['inprogress'] = 'Se izvaja';
$string['manual'] = 'Ročno';
$string['manualcompletionby'] = 'Ročno zaključevanje od drugih';
$string['manualcompletionbynote'] = 'Opomba: Zmožnost moodle/course:markcomplete mora biti dovoljena, da se na seznamu pojavi vloga.';
$string['manualselfcompletion'] = 'Ročno samostojno zaključevanje';
$string['manualselfcompletionnote'] = 'Opomba: Predmetu je potrebno dodati blok za ročno zaključevanje, če je le-to omogočeno.';
$string['markcomplete'] = 'Označi kot zaključeno';
$string['markedcompleteby'] = 'Zaključenost označi: {$a}';
$string['markingyourselfcomplete'] = 'Samostojno označi zaključek';
$string['modifybulkactions'] = 'Spremenite ukaze, ki jih želitemnožično urediti';
$string['moredetails'] = 'Več podrobnosti';
$string['nocriteriaset'] = 'Za ta predmet ni določenega kriterija za zaključevanje';
$string['nogradeitem'] = 'Zahteva po oceni ne more biti izbrana za <b>{$a}</b>, ker ta dejavnost ne predvideva ocene.';
$string['notcompleted'] = 'Ni zaključeno';
$string['notenroled'] = 'V ta predmet niste vpisani';
$string['nottracked'] = 'V tem predmetu trenutno ni sledenja zaključevanju';
$string['notyetstarted'] = 'Še ni začeto';
$string['overallaggregation'] = 'Zahteve zaključka';
$string['overallaggregation_all'] = 'Predmet se zaključi, ko so izpolnjeni VSI pogoji';
$string['overallaggregation_any'] = 'Predmet se zaključi, ko je izpolnjen KATERIKOLI pogoj';
$string['pending'] = 'V čakanju';
$string['periodpostenrolment'] = 'Obdobje po vpisu';
$string['privacy:metadata:completionstate'] = 'Če je bila dejavnost zaključena';
$string['privacy:metadata:course'] = 'Identifikator predmeta';
$string['privacy:metadata:coursecompletedsummary'] = 'Shranjuje informacije o uporabnikih, ki so izpolnili kriterije v predmetu';
$string['privacy:metadata:coursemoduleid'] = 'ID dejavnosti';
$string['privacy:metadata:coursemodulesummary'] = 'Shranjuje podatke uporabnika o zaključenosti predmeta';
$string['privacy:metadata:coursesummary'] = 'Shranjuje podatke uporabnika o zaključenosti predmeta.';
$string['privacy:metadata:gradefinal'] = 'Končna ocena prejeta za zaključen predmeta';
$string['privacy:metadata:overrideby'] = 'ID uporabnika, ki je razveljavil zaključenost dejavnosti';
$string['privacy:metadata:reaggregate'] = 'Če je bilo zaključevanje predmeta ponovno izbrano.';
$string['privacy:metadata:timecompleted'] = 'Čas, ko je bil predmet zaključen.';
$string['privacy:metadata:timecreated'] = 'Čas, ko je bilo zaključevanje dejavnosti ustvarjeno';
$string['privacy:metadata:timeenrolled'] = 'Čas, ko je bil uporabnik vpisan v predmet';
$string['privacy:metadata:timemodified'] = 'Čas, ko je bila spremenjena zaključenost dejavnosti';
$string['privacy:metadata:timestarted'] = 'Čas začetka predmeta.';
$string['privacy:metadata:unenroled'] = 'Če je bil uporabnik izpisan iz predmeta';
$string['privacy:metadata:userid'] = 'ID uporabnika s podatki o zaključku predmeta in dejavnosti';
$string['privacy:metadata:viewed'] = 'Če je bila dejavnost ogledana';
$string['progress'] = 'Napredek udeleženca';
$string['progress-title'] = '{$a->user}, {$a->activity}: {$a->state} {$a->date}';
$string['progresstotal'] = 'Napredek: {$a->complete} / {$a->total}';
$string['recognitionofpriorlearning'] = 'Priznavanje predhodnega učenja';
$string['remainingenroledfortime'] = 'Ostanite vpisani določeno časovno obdobje';
$string['remainingenroleduntildate'] = 'Ostanite vpisani do določenega datuma';
$string['reportpage'] = 'Prikaz uporabnikov {$a->from} do {$a->to} od skupno {$a->total}.';
$string['requiredcriteria'] = 'Zahtevan kriterij';
$string['resetactivities'] = 'Počisti vse označene dejavnosti in vire';
$string['restoringcompletiondata'] = 'Zapis podatkov zaključevanja';
$string['roleaggregation'] = 'Pogoj zahteva';
$string['roleaggregation_all'] = 'VSE izbrane vloge morajo biti označene, ko je pogoj izpolnjen';
$string['roleaggregation_any'] = 'KATERAKOLI izbrana vloga mora biti označena, ko je pogoj izpolnjen';
$string['roleidnotfound'] = 'ID vloge {$a} ni bil najden';
$string['saved'] = 'Shranjeno';
$string['seedetails'] = 'Ogled podrobnosti';
$string['select'] = 'Izberi';
$string['self'] = 'Uporabnik';
$string['selfcompletion'] = 'Lastnoročno zaključevanje';
$string['showcompletionconditions'] = 'Pokaži pogoje za zaključevanje dejavnosti';
$string['showcompletionconditions_help'] = 'Prikaži pogoje za za zaključevanje dejavnosti na strani predmeta';
$string['showinguser'] = 'Prikaz uporabnika';
$string['studentsmust'] = 'Udeleženci morajo';
$string['timecompleted'] = 'Čas zaključitve';
$string['todo'] = 'Za opraviti';
$string['unenrolingfromcourse'] = 'Izpis iz predmeta';
$string['unenrolment'] = 'Izpis';
$string['unit'] = 'Enota';
$string['unlockcompletion'] = 'Odkleni nastavitve zaključevanja';
$string['unlockcompletiondelete'] = 'Odkleni nastavitve zaključevanja in izbriši podatke o zaključevanju';
$string['updateactivities'] = 'Posodobi stanje zaključevanja pri označenih dejavnostih';
$string['usealternateselector'] = 'Uporabi nadomestni izbirnik predmeta';
$string['usernotenroled'] = 'Uporabnik ni vpisan v ta predmet';
$string['viewcoursereport'] = 'Ogled poročila o predmetu';
$string['viewingactivity'] = 'Ogled {$a}';
$string['withconditions'] = 'Pod pogoji';
$string['writingcompletiondata'] = 'Zapis podatkov zaključevanja';
$string['xdays'] = '{$a} dni';
$string['youmust'] = 'Vi morate';
