<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'qtype_stack', language 'sl', version '4.5'.
 *
 * @package     qtype_stack
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['ATAlgEquiv_SA_not_equation'] = 'Odgovor morate zapisati v obliki enačbe.';
$string['ATAlgEquiv_SA_not_expression'] = 'Vaš odgovor naj bo izraz, ne enačba, neenačba, seznam, množica ali matrika.';
$string['ATAlgEquiv_SA_not_function'] = 'Vaš odgovor bi morala biti funkcija, definirana z operatorjem <tt>:=</tt>, vendar ni.';
$string['ATAlgEquiv_SA_not_inequality'] = 'Odgovor morate zapisati v obliki neenačbe.';
$string['ATAlgEquiv_SA_not_list'] = 'Vaš odgovor bi moral biti niz vrednosti, vendar ni. Upoštevajte, da je sintaksa za pravilen vnos elementov niza naslednja: vrednosti so ločene z vejico in zapisane znotraj oglatih oklepajev.';
$string['ATAlgEquiv_SA_not_logic'] = 'Odgovor morate zapisati v obliki enačbe, neenačbe ali kombinacije le-teh.';
$string['ATAlgEquiv_SA_not_matrix'] = 'Odgovor morate zapisati v obliki matrike.';
$string['ATAlgEquiv_SA_not_realset'] = 'Vaš odgovor naj bo podmnožica realnih števil. To je lahko množica števil ali nabor intervalov.';
$string['ATAlgEquiv_SA_not_set'] = 'Vaš odgovor bi morala biti množica, vendar ni. Upoštevajte, da je sintaksa za pravilen vnos elementov množice naslednja: vrednosti so ločene z vejico in zapisane znotraj zavitih oklepajev.';
$string['ATAlgEquiv_SA_not_string'] = 'Odgovor morate zapisati v obliki niza.';
$string['ATAlgEquiv_TA_not_equation'] = 'Vnesli ste enačbo, vendar se tukaj enačbe ne pričakuje. Morda ste vnesli funkcijski zapis, kot je "y=2*x+1", morali pa bi vnesti le "2*x+1".';
$string['ATCompSquare_SA_not_depend_var'] = 'Vaš odgovor mora biti zapisan v odvisnosti spremenljivke {$a->m0}.';
$string['ATCompSquare_false'] = '';
$string['ATCompSquare_false_no_summands'] = 'Popoln kvadrat je oblike \\(a(\\cdots\\cdots)^2 + b\\), pri čemer \\(a\\) in \\(b\\) nista odvisna od vaše spremenljivke. V vašem primeru pa je eden od vaših seštevancev odvisen od spremenljivke. Preverite!';
$string['ATCompSquare_not_AlgEquiv'] = 'Vaš odgovor je zapisan v pravilni obliki, ni pa pravilen.';
$string['ATCompSquare_true'] = '';
$string['ATDiff_error_list'] = 'Test odgovora ni uspel. Prosimo, da se obrnete na svojega sistemskega administratorja.';
$string['ATDiff_int'] = 'Izgleda, da ste integrirali in ne odvajali.';
$string['ATEquivFirst_SA_not_list'] = 'Prvi argument pri testu odgovora Equiv bi moral biti seznam, vendar test ni uspel. Obrnite se na učitelja.';
$string['ATEquivFirst_SA_wrong_end'] = 'Končni rezultat ni v pravilni obliki.';
$string['ATEquivFirst_SA_wrong_start'] = 'Prva vrstica pri vaši trditvi mora biti "{$a->m0}".';
$string['ATEquivFirst_SB_not_list'] = 'Drugi argument pri testu odgovora Equiv bi moral biti seznam, vendar test ni uspel. Obrnite se na učitelja.';
$string['ATEquiv_SA_not_list'] = 'Prvi argument pri testu odgovora Equiv bi moral biti seznam, vendar test ni uspel. Obrnite se na učitelja.';
$string['ATEquiv_SB_not_list'] = 'Drugi argument pri testu odgovora Equiv bi moral biti seznam, vendar test ni uspel. Obrnite se na učitelja.';
$string['ATFacForm_error_list'] = 'Test odgovora ni uspel. Obrnite se na svojega sistemskega administratorja.';
$string['ATFacForm_isfactored'] = 'Vaš odgovor/rezultat je faktoriziran. Odlično.';
$string['ATFacForm_notalgequiv'] = 'Vaš odgovor žal ni algebraično enakovreden pravilnemu odgovoru. Gotovo ste naredili kaj narobe.';
$string['ATFacForm_notfactored'] = 'Vaš odgovor/rezultat ni faktoriziran.';
$string['ATInequality_backwards'] = 'Neenakost lahko zapišemo tudi drugače. Uporabite "zrcalen" zapis neenakosti.';
$string['ATInequality_nonstrict'] = 'Vaša neenakost mora biti stroga neenakost. Vendar ni!';
$string['ATInequality_strict'] = 'Vaša neenakost ne sme biti stroga neenakost.';
$string['ATInt_EqFormalDiff'] = 'Odvod vašega odgovora ustreza izrazu, ki ste ga morali integrirati, vendar pa se vaš odgovor v zapisu bistveno razlikuje od pravilnega odgovora. (Npr. ne samo v konstanti integracije). Vprašajte o tem svojega učitelja.';
$string['ATInt_STACKERROR_OptList'] = 'Test odgovora ni bil pravilno izveden: o tem opozorite učitelja. Kadar je podana možnost ATInt seznam, mora le-ta imeti natančno dva elementa, vendar ga nima.';
$string['ATInt_const'] = 'Zdi se, da je vaš odgovor pravilen, seveda pa ne pozabite dodati integracijske konstante C h končnemu rezultatu. Dobro opravljeno.';
$string['ATInt_const_int'] = 'Dodati morate integracijsko konstanto C h končnemu rezultatu. Gre za poljubno konstanto in ne število.';
$string['ATInt_diff'] = 'Izgleda, da ste diferencirali (odvajali) in ne integrirali.';
$string['ATInt_error_list'] = 'Test odgovora ni uspel. Obrnite se na svojega sistemskega administratorja';
$string['ATInt_generic'] = 'Izpeljava vašega odgovora mora biti enaka izrazu, ki ste ga morali integrirati, to je: {$a->m0}. Natančneje, izpeljava vašega odgovora, ki je vezan na {$a->m1} je {$a->m2}. Pri izpeljavi je tako prišlo do napake!';
$string['ATInt_logabs'] = 'Odvod vašega odgovora ustreza izrazu, ki ste ga morali integrirati, vendar pa se vaš odgovor v zapisu bistveno razlikuje od pravilnega odgovora. (Npr. ne samo v konstanti integracije). Učitelj mogoče pričakuje rezultat oblike \\(\\int\\frac{1}{x} dx = \\log(|x|)+c\\), in ne \\(\\int\\frac{1}{x} dx = \\log(x)+c\\).  Vprašajte o tem svojega učitelja.';
$string['ATInt_logabs_inconsistent'] = 'Razvidne so nenavadne neskladnosti pri uporabi \\(\\log(...)\\) in \\(\\log(|...|)\\). O tem povprašajte svojega učitelja.';
$string['ATInt_weirdconst'] = 'Formalna izpeljava vašega odgovora ustreza izrazu, ki ste ga morali vključiti. Vendar je zaznati nenavadno konstanto. O tem povprašajte svojega učitelja.';
$string['ATList_wrongentries'] = 'Vnosi, ki so podčrtani z rdečo, so napačni. {$ a-> m0}';
$string['ATList_wronglen'] = 'Vaš seznam bi moral imeti {$a->m0} elementov, dejansko pa jih ima {$a->m1}.';
$string['ATLowestTerms_entries'] = 'Naslednji izrazi v vašem odgovoru niso "najmanjši". {$a->m0} Poskusite znova.';
$string['ATLowestTerms_not_rat'] = 'Iz imenovalca ulomka morate odstraniti naslednje: {$a->m0}';
$string['ATLowestTerms_wrong'] = 'V vašem odgovoru ne sme biti ulomkov.';
$string['ATMatrix_wrongentries'] = 'Vnosi, ki so podčrtani z rdečo barvo, so napačni. {$a->m0}';
$string['ATMatrix_wrongsz'] = 'Dimenzija vaše matrike bi morala biti {$a->m0} krat {$a->m1}, vendar je {$a->m2} krat {$a->m3}.';
$string['ATNumDecPlacesWrong_OptNotInt'] = 'Za ATNumDecPlacesWrong morate uporabiti pozitivno celo število, v resnici pa je bilo uporabljeno "{$a->opt}".';
$string['ATNumDecPlaces_NoDP'] = 'Vaš odgovor mora biti zapisan v decimalni obliki.';
$string['ATNumDecPlaces_OptNotInt'] = 'Za ATNumDecPlaces morate uporabiti pozitivno celo število, v resnici pa je bilo uporabljeno "{$a->opt}".';
$string['ATNumDecPlaces_Wrong_DPs'] = 'Vaš odgovor je bil podan z napačnim številom decimalnih mest.';
$string['ATNumSigFigs_Inaccurate'] = 'Natančna vrednost vašega odgovora ni pravilna. Ali števila niste pravilno zaokrožili ali pa ste zaokrožili vmesni odgovor in prihaja do napake.';
$string['ATNumSigFigs_NotDecimal'] = 'Vaš odgovor mora biti zapisan v decimalni obliki.';
$string['ATNumSigFigs_WrongDigits'] = 'Vaš odgovor vsebuje napačno število števk.';
$string['ATNumSigFigs_WrongSign'] = 'Vaš odgovor ima napačen algebraičen znak.';
$string['ATNumSigFigs_error_list'] = 'Test odgovora ni uspel. Obrnite se na svojega sistemskega administratorja';
$string['ATNum_OutofRange'] = 'Številčni zapis je zunaj podprtega obsega. Obrnite se na učitelja.';
$string['ATNumerical_FAILED'] = 'Vaš odgovor mora biti decimalno število, seznam ali niz števil. Vendar ni.';
$string['ATNumerical_SA_not_list'] = 'Vaš odgovor bi moral biti v obliki seznama, vendar ni. Upoštevajte skladnjo za vnos seznama. Vrednosti ločimo z vejicami ter uporabimo kvadratne oklepaje.';
$string['ATNumerical_SA_not_number'] = 'Vaš odgovor mora biti decimalno število, vendar ni.';
$string['ATNumerical_SA_not_set'] = 'Vaš odgovor bi moral biti v obliki niza (zaporedja števil), vendar ni. Upoštevajte skladnjo za zapis niza števil. Vrednosti ločimo z vejicami ter uporabimo zavite oklepaje.';
$string['ATNumerical_STACKERROR_tol'] = 'Številska toleranca za ATNumerical bi moralo biti število v decimalnem zapisu, vendar ni. To je notranja napaka testa. Vprašajte o tem svojega učitelja.';
$string['ATPartFrac_denom_ret'] = 'Če je vaš odgovor napisan kot ulomek, potem je imenovalec {$a->m0}. Pravzaprav bi moral biti {$a->m1}.';
$string['ATPartFrac_diff_variables'] = 'Spremenljivke v vašem odgovoru se razlikujejo od tistih, ki so navedene v vprašanju. Preverite jih.';
$string['ATPartFrac_error_list'] = 'Test vašega odgovora ni uspel. Obrnite se na svojega sistemskega administratorja';
$string['ATPartFrac_ret_expression'] = 'Vaš odgovor zapisan kot ulomek je sledeč {$a->m0}';
$string['ATPartFrac_single_fraction'] = 'Zdi se, da je vaš odgovor zapisan v obliki enega samega ulomka, moral pa bi biti zapisan v obliki delnega ulomka.';
$string['ATPartFrac_true'] = '';
$string['ATSRegExp_SA_not_string'] = 'Prvi argument testa odgovora SRegExp bi moral biti niz. Test odgovora ni uspel. Obrnite se na učitelja.';
$string['ATSRegExp_SB_not_string'] = 'Drugi argument testa odgovora SRegExp bi moral biti niz. Test odgovora ni uspel. Obrnite se na učitelja.';
$string['ATSet_wrongentries'] = 'Naslednji vnosi so napačni, čeprav se lahko pojavijo v poenostavljeni obliki od tiste, ki ste jo dejansko vnesli. {$a->m0}';
$string['ATSet_wrongsz'] = 'Vaša množica bi morala vsebovati {$a->m0} različnih elementov, dejansko pa jih ima {$a->m1}.';
$string['ATSets_SA_not_set'] = 'Vaš odgovor bi moral biti zapisan v obliki množice, vendar ni. Upoštevajte sintakso za vnos množice. Vrednosti morajo biti ločene z vejicami in zaključene z zavitimi oklepaji.';
$string['ATSets_SB_not_set'] = 'Test odgovora, ki vključuje "Množice", zahteva, da bo drugi argument množica. To je napaka. Obrnite se na učitelja.';
$string['ATSets_duplicates'] = 'Zdi se, da vaš vnos vsebuje podvojene vrednosti!';
$string['ATSets_missingentries'] = 'V vašem zapisu množice manjka naslednje {$a->m0}';
$string['ATSets_wrongentries'] = 'Ti vnosi ne bi smeli biti elementi vaše množice. {$a->m0}';
$string['ATSingleFrac_div'] = 'Vaš odgovor vsebuje ulomke znotraj ulomkov. Dvojni ulomek zapišite kot en sam ulomek.';
$string['ATSingleFrac_error_list'] = 'Test odgovora ni uspel. Obrnite se na svojega sistemskega administratorja';
$string['ATSingleFrac_part'] = 'Vaš odgovor mora biti v obliki ulomka  \\( {a}\\over{b} \\).';
$string['ATSingleFrac_ret_exp'] = 'Vaš odgovor ni algebrsko enakovreden pravilnemu odgovoru. Nekaj ste naredili narobe.';
$string['ATSingleFrac_true'] = '';
$string['ATSingleFrac_var'] = 'Spremenljivke v vašem odgovoru se razlikujejo od tistih, ki so navedene v vprašanju. Preverite jih.';
$string['ATSysEquiv_SA_extra_variables'] = 'Vaš odgovor vključuje preveč spremenljivk!';
$string['ATSysEquiv_SA_missing_variables'] = 'V vašem odgovoru manjka ena ali več spremenljivk!';
$string['ATSysEquiv_SA_not_eq_list'] = 'Vaš odgovor bi moral vsebovati enačbe, seznam enačb, vendar jih ne!';
$string['ATSysEquiv_SA_not_list'] = 'Vaš odgovor bi moral biti seznam, vendar ni!';
$string['ATSysEquiv_SA_not_poly_eq_list'] = 'Ena ali več vaših enačb ni polinomska enačba!';
$string['ATSysEquiv_SA_system_overdetermined'] = 'Vnosi, ki so podčrtani z rdečo barvo so tisti, ki so napačni. {$a->m0}';
$string['ATSysEquiv_SA_system_underdetermined'] = 'Zdi se, da so enačbe v vašem sistemu pravilne, vendar jih potrebujete še nekaj.';
$string['ATSysEquiv_SA_wrong_variables'] = 'Odgovor vsebuje napačne spremenljivke.';
$string['ATSysEquiv_SB_not_eq_list'] = 'Učiteljev odgovor ni seznam enačb, vendar bi moral biti.';
$string['ATSysEquiv_SB_not_list'] = 'Učiteljev odgovor ni seznam. Obrnite se na svojega učitelja.';
$string['ATSysEquiv_SB_not_poly_eq_list'] = 'Učiteljev odgovor bi moral biti seznam polinomskih enačb, vendar ni. Obrnite se na učitelja.';
$string['ATUnits_SA_bad_units'] = 'V vašem odgovoru morajo biti enote. Pri uporabi enot pa morate uporabiti množenje, na primer <code>3,2*m/s</code>.';
$string['ATUnits_SA_errorbounds_invalid'] = 'Vaš odgovor ima napako pri oceni mejnih vrednosti. V tem primeru ne navedite mejnih vrednosti, temveč uporabite le količino in enote.';
$string['ATUnits_SA_excess_units'] = 'V vašem odgovoru so bile uporabljene enote (ali spremenljivke), vendar jih ne bi smeli.';
$string['ATUnits_SA_no_units'] = 'Vaš odgovor mora vsebovati enote.';
$string['ATUnits_SA_not_expression'] = 'Vaš odgovor mora biti število, zapisano skupaj z enotami. Ne uporabljajte množic, seznamov, enačb ali matrik.';
$string['ATUnits_SA_only_units'] = 'Vaš odgovor mora biti število, zapisano skupaj z enotami. Vaš odgovor ima samo enote.';
$string['ATUnits_compatible_units'] = 'Vaše enote se razlikujejo od tistih, ki jih je uporabil učitelj, vendar so z njimi združljive. Numerične vrednosti se za primerjavo pretvorijo v osnovne enote SI.';
$string['ATUnits_correct_numerical'] = 'Prosimo, da ponovno preverite svoje enote.';
$string['ATUnits_incompatible_units'] = 'Vaše enote niso združljive s tistimi, ki jih je uporabil učitelj.';
$string['AT_EmptySA'] = 'Poskus testa odgovora pri čemer udeleženec odgovora ni podal.  Pri potrditvi vprašanja je verjetno prišlo do težav s potrjevanjem CAS-a.';
$string['AT_EmptyTA'] = 'Poskus testa odgovora pri čemer učitelj odgovora ni podal. Pri potrditvi vprašanja je verjetno prišlo do težav s potrjevanjem CAS-a.';
$string['AT_InvalidOptions'] = 'Izbirno polje je nepravilno. {$a->errors}';
$string['AT_MissingOptions'] = 'Pri izvedbi testa ni podane opcije.';
$string['AT_NOTIMPLEMENTED'] = 'Test odgovora ni bil izveden.';
$string['Bad_assignment'] = 'Ko naštevate vrednosti spremenljivk, to storite na naslednji način: {$a->m0}. Spremenite svoj vnos.';
$string['CommaError'] = 'Vaš odgovor vsebuje vejice, ki niso del seznama, množice ali matrike. <ul><li> Če ste želeli vnesti seznam, uporabite <tt>[...]</tt>,</li><li> Če ste želeli vnesti množico, uporabite <tt>{...}</tt>.</li></ul>';
$string['Equiv_Illegal_list'] = 'Seznami niso dovoljeni pri sklepanje o enakovrednosti.';
$string['Equiv_Illegal_matrix'] = 'Matrike niso dovoljene pri sklepanje o enakovrednosti.';
$string['Equiv_Illegal_set'] = 'Množice niso dovoljene pri sklepanje o enakovrednosti.';
$string['FacForm_UnPick_intfac'] = 'Izključiti/izvzeti morate skupni dejavnik/faktor.';
$string['FacForm_UnPick_morework'] = 'Smiselno bi bilo uporabiti še nekaj dela na izrazu {$a->m0}.';
$string['Illegal_floats'] = 'Vaš odgovor vsebuje decimalno število (število zapisano s plavajočo vejico), ki tukaj ni dovoljeno. Števila morate vnesti kot ulomke. Na primer, vnesite 1/3 in ne 0,3333, kar je navsezadnje le približek ene tretjine.';
$string['Lowest_Terms'] = 'Vaš odgovor vsebuje ulomke, ki niso popolnoma okrajšani. Poskusite znova.';
$string['Maxima_Args'] = 'args: argument mora biti zapisan drugače.';
$string['Maxima_DivisionZero'] = 'Deljenje z nič.';
$string['Subst'] = 'Vaš odgovor bi bil pravilen, če bi uporabili vpeljavo nove spremenljivke {$a->m0}';
$string['TEST_FAILED'] = 'Test odgovora ni bil izveden: opozorite učitelja. {$a->errors}';
$string['TEST_FAILED_Q'] = 'Test odgovora ni bil pravilno izveden: opozorite učitelja.';
$string['Variable_function'] = 'Naslednje se v vašem izrazu pojavi kot spremenljivka in funkcija: {$a->m0}. Pojasnite svoj vnos. Vstavite simbol <code>*</code>, če želite odstraniti funkcijo, ali naredite vse izraze kot funkcije.';
$string['addanothernode'] = 'Dodajte drugo vozlišče';
$string['addanothertestcase'] = 'Dodajte nov testni primer ...';
$string['addatestcase'] = 'Dodajte testni primer ...';
$string['addingatestcase'] = 'Dodajanje testnega primera k vprašanju {$a}';
$string['alg_indices_fact'] = 'Za računanje s potencami veljajo naslednja pravila:
\\[a^ma^n = a^{m+n}\\]
\\[\\frac{a^m}{a^n} = a^{m-n}\\]
\\[(a^m)^n = a^{mn}\\]
\\[a^0 = 1\\]
\\[a^{-m} = \\frac{1}{a^m}\\]
\\[a^{\\frac{1}{n}} = \\sqrt[n]{a}\\]
\\[a^{\\frac{m}{n}} = \\left(\\sqrt[n]{a}\\right)^m\\]';
$string['alg_indices_name'] = 'Pravila za računanje s potencami';
$string['alg_inequalities_fact'] = '\\[a>b \\hbox {pomeni} a \\hbox {je večji kot} b.\\]
\\[a<b \\hbox {pomeni} a \\hbox {je manjši kot} b.\\]
\\[a\\geq b \\hbox {pomeni} a \\hbox {je večji ali enak kot } b.\\]
\\[a\\leq b \\hbox {pomeni} a \\hbox {je manjši ali enak kot} b.\\]';
$string['alg_inequalities_name'] = 'Neenačbe';
$string['alg_logarithms_fact'] = 'Za vsak logaritem z osnovo \\(c>0\\) in \\(c \\neq 1\\) velja:
\\[\\log_c(a) = b \\mbox{, pomeni } a = c^b\\]
\\[\\log_c(a) + \\log_c(b) = \\log_c(ab)\\]
\\[\\log_c(a) - \\log_c(b) = \\log_c\\left(\\frac{a}{c}\\right)\\]
\\[n\\log_c(a) = \\log_c\\left(a^n\\right)\\]
\\[\\log_c(1) = 0\\]
\\[\\log_c(b) = 1\\]
Obrazec za prehod na novo osnovo je:
\\[\\log_a(x) = \\frac{\\log_b(x)}{\\log_b(a)}\\]
Logaritem z osnovo \\(e\\), katerega zapis je \\(\\log_e\\) ali \\(\\ln\\) imenujemo naravni logaritem.  Oznaka \\(e\\) predstavlja t.i. Eulerjevo število, katere vrednost je približno enaka \\(2.718\\).';
$string['alg_logarithms_name'] = 'Pravila za računanje z logaritmi';
$string['alg_partial_fractions_fact'] = 'V primeru ulomka obike \\[{\\frac{P(x)}{Q(x)}}\\], kjer
sta \\(P\\) in \\(Q\\) polinoma in je stopnja polinoma \\(P\\) manjša od stopnje \\(Q\\)
nadaljujemo po naslednjih korakih:
Polinom \\(Q(x)\\) zapišemo v faktorski obliki,
<ul>
<li>
V primeru<em>linearne oblike</em> \\(ax+b\\) v imenovalcu bomo parcialni ulomek zapisali v obliki \\[{\\frac{A}{ax+b}}.\\]
</li>
<li>
</li>
<li>
V primeru <em> potenc linearnih faktorjev</em> \\((ax+b)^2\\) v imenovalcu bomo parcialni ulomek zapisali v obliki \\[{A\\over ax+b}+{B\\over (ax+b)^2}.\\]
</li>
<li>
V primeru <em> kvadratne oblike (polinoma druge stopnje)</em> \\(ax^2+bx+c\\)
v imenovalcu bomo parcialni ulomek zapisali v obliki \\[{Ax+B\\over ax^2+bx+c}\\]
</li>
<li>
<em>Improper fractions (ulomki, kjer stopnja polinoma \\(P\\) ni manjša od stopnje \\(Q\\))</em>zahtevajo dodaten korak.
Poiskati moramo polinom stopnje \\(n-d\\), kjer je \\(n\\)
stopnja števca (tj. \\(P(x)\\)) in \\(d\\) je stopnja
imenovalca (tj. \\(Q(x)\\)).';
$string['alg_partial_fractions_name'] = 'Parcialni ulomki';
$string['alg_quadratic_formula_fact'] = 'Kvadratna enačba oblike
\\[ax^2 + bx + c = 0,\\]
ima naslednjo množico rešitev (izračunamo jih s pomočjo diskriminante)
\\[x = \\frac{-b \\pm \\sqrt{b^2 - 4ac}}{2a}.\\]';
$string['alg_quadratic_formula_name'] = 'Obrazec za izračun rešitev kvadratne enačbe';
$string['all'] = 'Vsa';
$string['allnodefeedbackmustusethesameformat'] = 'Povratne informacije za vsa vozlišča v PRT morajo biti zapisana v isti besedilni obliki.';
$string['allowwords'] = 'Dovoljene besede';
$string['allowwords_help'] = 'Imena poljubnih funkcij ali spremenljivk, dolga več kot dva znaka, privzeto niso dovoljena. To je seznam imen funkcij ali spremenljivk, ločenih z vejicami, ki so dovoljena v odgovoru.';
$string['allowwords_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md#Allow_Words';
$string['alreadydeployed'] = 'Različica, ki ustreza tej opombi, je že uporabljena.';
$string['ansnotemismatch'] = 'Predlagan odgovor se ne ujema/ni pravilen';
$string['answernote'] = 'Oznaka odgovora';
$string['answernote_err'] = 'Oznaka odgovora ne sme vsebovati znaka |. Ta znak je privzet s strani STACK-a in je v nadaljevanju uporabljen za avtomatično delitev oznak odgovorov.';
$string['answernote_err2'] = 'Oznaka odgovora ne sme vsebovati znakov ; ali : . Ti se uporabljajo za deljenje nizov povzetkov poskusov vprašanj v orodjih za poročanje brez povezave.';
$string['answernote_help'] = 'To je oznaka, ki je ključna za namene poročanja. Zasnovana je tako, da beleži edinstveno pot skozi drevesno strukturo in rezultate vsakega testa odgovora. To je samodejno generirano, vendar se lahko spremeni v kaj uporabnejšega.';
$string['answernote_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Potential_response_trees.md#Answer_note';
$string['answernotedefaultfalse'] = '{$a->prtname}-{$a->nodename}-F';
$string['answernotedefaulttrue'] = '{$a->prtname}-{$a->nodename}-T';
$string['answernoterequired'] = 'Oznaka odgovora ne sme ostati prazna.';
$string['answernoteunique'] = 'V drevesu so bile odkrite podvojene oznake odgovorov.';
$string['answertest'] = 'Test odgovora';
$string['answertest_help'] = 'Za primerjavo dveh izrazov se uporablja test odgovora. Z njim preverimo, ali izpolnjujeta določene matematične kriterije.';
$string['answertest_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Answer_Tests/index.md';
$string['api_correct'] = 'Pravilni odgovori';
$string['assumepositive'] = 'Predpostavi, da je pozitivno';
$string['assumepositive_help'] = 'Ta opcija nastavi vrednost Maxima\'s assume_pos spremenljivke.';
$string['assumepositive_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Options.md#Assume_Positive';
$string['assumereal'] = 'Predpostavi, da je realno';
$string['assumereal_help'] = 'Ta opcija nastavi assume_real spremenljivko.';
$string['assumereal_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Options.md#Assume_Real';
$string['autosimplify'] = 'Samodejne poenostavitve';
$string['autosimplify_help'] = 'Za to vprašanje morate v Maximi nastaviti spremenljivko "simp". Npr. spremenljivke vprašanja, besedilo vprašanja itd. Vrednost, ki je postavljena v drevesu potencialnih odgovorov, bo povozila vse izraze, ki so pozneje definirani znotraj drevesa.';
$string['autosimplify_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/CAS/Maxima.md#Simplification';
$string['autosimplifyprt'] = 'Samodejne poenostavitve';
$string['autosimplifyprt_help'] = 'Nastavi spremenljivko "simp" v Maximi za spremenljivke povratnih informacij, definirane v tem potencialnem drevesu odgovorov, medtem ko ocenjuje ta PRT. To bo zbrisalo in prepisalo katero koli vrednost, določeno v vprašanju, za vse izraze, opredeljene znotraj drevesa.';
$string['autosimplifyprt_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/CAS/Maxima.md#Simplification';
$string['booleangotunrecognisedvalue'] = 'Neveljaven vnos.';
$string['boxsize'] = 'Velikost polja za vnos';
$string['boxsize_help'] = 'Širina polja HTML obrazca.';
$string['boxsize_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md#Box_Size';
$string['branchfeedback'] = 'Povratne informacije vezane na vozlišča';
$string['branchfeedback_help'] = 'To je CASText, ki je lahko odvisen od katere koli spremenljivke vprašanja, vhodnih elementov ali povratnih spremenljivk.';
$string['bulktestcontinuefromhere'] = 'Zaženite znova ali nadaljujte, začenši od tu';
$string['bulktestindexintro'] = 'Če kliknete katero izmed povezav, se bodo izvedle vse preverbe odgovorov, ki so vezane na vprašanja iz STACKa.';
$string['bulktestindexintro_desc'] = 'Povezava <a href="{$a->link}">zažene test vprašanj v skriptni obliki</a>, vam omogoča enostaven zagon vseh vprašanj STACK v danem kontekstu. Ne samo, da preveri odgovore, ampak je tudi dober način za ponovno napolnitev predpomnilnika CAS po tem, ko je le-ta bil počiščen.';
$string['bulktestindextitle'] = 'Izvedite test vprašanj';
$string['bulktestnogeneralfeedback'] = 'To vprašanje v splošnem nima povratnih informacij.';
$string['bulktestnotests'] = 'To vprašanje nima pripravljenih testov (ne moremo ga preveriti).';
$string['bulktestrun'] = 'Zaženite teste za vsa vprašanja v sistemu (počasno, samo skrbnik)';
$string['bulktesttitle'] = 'Izvajanje vseh testov vprašanj v {$a}';
$string['calc_chain_rule_fact'] = 'Naslednje pravilo omogoča izračun odvoda dveh sestavljenih funkcij (oz. kompozituma funkcij).
Predpostavimo, da imamo funkcijo \\(f(g(x))\\). Definiramo \\(u=g (x)\\). Odvod funkcije glede na \\(x\\) je naslednji:
\\[\\frac{df(g(x))}{dx} = \\frac{dg(x)}{dx}\\cdot\\frac{df(u)}{du}.\\]
Lahko pa napišemo še:
\\[\\frac{df(x)}{dx} = f\'(g(x))\\cdot g\'(x).\\]';
$string['calc_chain_rule_name'] = 'Verižno pravilo';
$string['calc_diff_linearity_rule_fact'] = '\\[{{\\rm d}\\,\\over {\\rm d}x}\\big(af(x)+bg(x)\\big)=a{{\\rm d}f(x)\\over {\\rm d}x}+b{{\\rm d}g(x)\\over {\\rm d}x}\\quad a,b {\\rm\\  constant.}\\]';
$string['calc_diff_linearity_rule_name'] = 'Osnovno (Linearno) pravilo diferenciranja (odvajanja)';
$string['calc_diff_standard_derivatives_fact'] = 'Naslednja tabela prikazuje izpeljave odvodov nekaterih elementarnih funkcij. Koristno je, da se jih naučite na pamet, saj se pogosto uporabljajo pri računanju.
<center>
<table>
<tr><th>\\(f(x)\\)               </th><th> \\(f\'(x)\\)</th></tr>
<tr>
<td>\\(k\\), constant           </td> <td> \\(0\\) </td> </tr> <tr> <td>
\\(x^n\\), any constant \\(n\\) </td> <td> \\(nx^{n-1}\\)</td> </tr> <tr> <td>
\\(e^x\\)                   </td> <td> \\(e^x\\)</td> </tr> <tr> <td>
\\(\\ln(x)=\\log_{\\rm e}(x)\\)              </td> <td> \\(\\frac{1}{x}\\)                </td> </tr> <tr> <td>
\\(\\sin(x)\\)                             </td> <td> \\(\\cos(x)\\)                    </td> </tr> <tr> <td>
\\(\\cos(x)\\)                             </td> <td> \\(-\\sin(x)\\)                   </td> </tr> <tr> <td>
\\(\\tan(x) = \\frac{\\sin(x)}{\\cos(x)}\\)   </td> <td>   \\(\\sec^2(x)\\)                </td> </tr> <tr> <td>
\\(cosec(x)=\\frac{1}{\\sin(x)}\\)         </td> <td>   \\(-cosec(x)\\cot(x)\\)        </td> </tr> <tr> <td>
\\(\\sec(x)=\\frac{1}{\\cos(x)}\\)           </td> <td>   \\(\\sec(x)\\tan(x)\\)           </td> </tr> <tr> <td>
\\(\\cot(x)=\\frac{\\cos(x)}{\\sin(x)}\\)     </td> <td>   \\(-cosec^2(x)\\)             </td> </tr> <tr> <td>
\\(\\cosh(x)\\)                            </td> <td>   \\(\\sinh(x)\\)                 </td> </tr> <tr> <td>
\\(\\sinh(x)\\)                            </td> <td>   \\(\\cosh(x)\\)                 </td> </tr> <tr> <td>
\\(\\tanh(x)\\)                            </td> <td>   \\(sech^2(x)\\)               </td> </tr> <tr> <td>
\\(sech(x)\\)                            </td> <td>   \\(-sech(x)\\tanh(x)\\)        </td> </tr> <tr> <td>
\\(cosech(x)\\)                          </td> <td>   \\(-cosech(x)\\coth(x)\\)      </td> </tr> <tr> <td>
\\(coth(x)\\)                            </td> <td>   \\(-cosech^2(x)\\)            </td> </tr>
</table>
</center>

 \\[ \\frac{d}{dx}\\left(\\sin^{-1}(x)\\right) =  \\frac{1}{\\sqrt{1-x^2}}\\]
 \\[ \\frac{d}{dx}\\left(\\cos^{-1}(x)\\right) =  \\frac{-1}{\\sqrt{1-x^2}}\\]
 \\[ \\frac{d}{dx}\\left(\\tan^{-1}(x)\\right) =  \\frac{1}{1+x^2}\\]
 \\[ \\frac{d}{dx}\\left(\\cosh^{-1}(x)\\right) =  \\frac{1}{\\sqrt{x^2-1}}\\]
 \\[ \\frac{d}{dx}\\left(\\sinh^{-1}(x)\\right) =  \\frac{1}{\\sqrt{x^2+1}}\\]
 \\[ \\frac{d}{dx}\\left(\\tanh^{-1}(x)\\right) =  \\frac{1}{1-x^2}\\]';
$string['calc_diff_standard_derivatives_name'] = 'Odvodi elementarnih funkcij';
$string['calc_int_linearity_rule_fact'] = '\\[\\int \\left(af(x)+bg(x)\\right){\\rm d}x = a\\int\\!\\!f(x)\\,{\\rm d}x
\\,+\\,b\\int \\!\\!g(x)\\,{\\rm d}x, \\quad (a,b \\, \\, {\\rm constant.})
\\]';
$string['calc_int_linearity_rule_name'] = 'Osnovno (Linearno) pravilo integriranja';
$string['calc_int_methods_parts_fact'] = '\\[
\\int_a^b u{{\\rm d}v\\over {\\rm d}x}{\\rm d}x=\\left[uv\\right]_a^b-
\\int_a^b{{\\rm d}u\\over {\\rm d}x}v\\,{\\rm d}x\\]
or alternatively: \\[\\int_a^bf(x)g(x)\\,{\\rm d}x=\\left[f(x)\\,\\int
g(x){\\rm d}x\\right]_a^b -\\int_a^b{{\\rm d}f\\over {\\rm
d}x}\\left\\{\\int g(x){\\rm d}x\\right\\}{\\rm d}x.\\]';
$string['calc_int_methods_parts_name'] = 'INtegriranje po delih';
$string['calc_int_methods_substitution_fact'] = '\\[
\\int f(u){{\\rm d}u\\over {\\rm d}x}{\\rm d}x=\\int f(u){\\rm d}u
\\quad\\hbox{and}\\quad \\int_a^bf(u){{\\rm d}u\\over {\\rm d}x}\\,{\\rm
d}x = \\int_{u(a)}^{u(b)}f(u){\\rm d}u.
\\]';
$string['calc_int_methods_substitution_name'] = 'Integriranje z uvedbo nove spremenljivke';
$string['calc_int_standard_integrals_fact'] = '\\[\\int k\\ dx = kx +c, \\mbox{ kjer je k konstanta.}\\]
\\[\\int x^n\\ dx  = \\frac{x^{n+1}}{n+1}+c, \\quad (n\\ne -1)\\]
\\[\\int x^{-1}\\ dx = \\int {\\frac{1}{x}}\\ dx = \\ln(|x|)+c = \\ln(k*|x|) = \\left\\{\\matrix{\\ln(x)+c & x>0\\cr
\\ln(-x)+c & x<0\\cr}\\right.\\]

<center>
<table>
<tr><th>\\(f(x)\\)</th><th> \\(\\int f(x)\\ dx\\)</th></tr>
<tr><td>\\(e^x\\) </td> <td>  \\(e^x+c\\)</td> <td> </td> </tr>
<tr><td>\\(\\cos(x)\\) </td> <td>  \\(\\sin(x)+c\\)   </td> <td> </td> </tr>
<tr><td>\\(\\sin(x)\\) </td> <td>  \\(-\\cos(x)+c\\)  </td> <td> </td> </tr>
<tr><td>\\(\\tan(x)\\) </td> <td>  \\(\\ln(\\sec(x))+c\\) </td> <td>\\(-\\frac{\\pi}{2} < x < \\frac{\\pi}{2}\\)</td> </tr>
<tr><td>\\(\\sec x\\)  </td> <td>  \\(\\ln (\\sec(x)+\\tan(x))+c\\) </td> <td> \\( -{\\pi\\over 2}< x < {\\pi\\over 2}\\)</td> </tr>
<tr><td>cosec\\(\\, x\\) </td> <td>  \\(\\ln ($cosec$(x)-\\cot(x))+c\\) </td> <td>\\(0 < x < \\pi\\)</td> </tr>
<tr><td>cot\\(\\,x\\) </td> <td>  \\(\\ln(\\sin(x))+c\\) </td> <td>  \\(0< x< \\pi\\) </td> </tr>
<tr><td>\\(\\cosh(x)\\) </td> <td>  \\(\\sinh(x)+c\\)</td> <td></td> </tr>
<tr><td>\\(\\sinh(x)\\) </td> <td>  \\(\\cosh(x) + c\\) </td> <td> </td> </tr>
<tr><td>\\(\\tanh(x)\\) </td> <td>  \\(\\ln(\\cosh(x))+c\\)</td> <td> </td> </tr>
<tr><td>coth\\((x)\\) </td> <td>  \\(\\ln(\\sinh(x))+c \\)</td> <td>   \\(x>0\\)</td> </tr>
<tr><td>\\({1\\over x^2+a^2}\\) </td> <td>  \\({1\\over a}\\tan^{-1}{x\\over a}+c\\)</td> <td> \\(a>0\\)</td> </tr>
<tr><td>\\({1\\over x^2-a^2}\\) </td> <td>  \\({1\\over 2a}\\ln{x-a\\over x+a}+c\\) </td> <td>  \\(|x|>a>0\\)</td> </tr>
<tr><td>\\({1\\over a^2-x^2}\\) </td> <td>  \\({1\\over 2a}\\ln{a+x\\over a-x}+c\\) </td> <td>   \\(|x|<a\\)</td> </tr>
<tr><td>\\({1\\over \\sqrt{x^2+a^2}}\\) </td> <td>  \\(\\sinh^{-1}\\left(\\frac{x}{a}\\right) + c\\) </td> <td> \\(a>0\\) </td> </tr>
<tr><td>\\({1\\over \\sqrt{x^2-a^2}}\\) </td> <td>  \\(\\cosh^{-1}\\left(\\frac{x}{a}\\right) + c\\) </td> <td>  \\(x\\geq a > 0\\) </td> </tr>
<tr><td>\\({1\\over \\sqrt{x^2+k}}\\) </td> <td>  \\(\\ln (x+\\sqrt{x^2+k})+c\\)</td> <td> </td> </tr>
<tr><td>\\({1\\over \\sqrt{a^2-x^2}}\\) </td> <td>  \\(\\sin^{-1}\\left(\\frac{x}{a}\\right)+c\\)</td> <td>  \\(-a\\leq x\\leq a\\)  </td> </tr>
</table></center>';
$string['calc_int_standard_integrals_name'] = 'Integrali elementarnih funkcij';
$string['calc_product_rule_fact'] = 'Naslednje pravilo omogoča izračun odvoda produkta dveh funkcij.
Izračunati želimo odvod \\(f(x)g(x)\\) glede na spremenljivko \\(x\\).
\\[ \\frac{\\mathrm{d}}{\\mathrm{d}{x}} \\big(f(x)g(x)\\big) = f(x) \\cdot \\frac{\\mathrm{d} g(x)}{\\mathrm{d}{x}}  + g(x)\\cdot \\frac{\\mathrm{d} f(x)}{\\mathrm{d}{x}},\\] ali pa uporabimo alternativno obliko zapisa \\[ (f(x)g(x))\' = f\'(x)g(x)+f(x)g\'(x). \\]';
$string['calc_product_rule_name'] = 'Pravilo produkta';
$string['calc_quotient_rule_fact'] = 'Naslednje pravilo omogoča izračun odvoda kvocienta dveh funkcij
 \\(f(x)\\) in \\(g(x)\\).
 \\[\\frac{d}{dx}\\left(\\frac{f(x)}{g(x)}\\right)=\\frac{g(x)\\cdot\\frac{df(x)}{dx}\\ \\ - \\ \\ f(x)\\cdot \\frac{dg(x)}{dx}}{g(x)^2}. \\]';
$string['calc_quotient_rule_name'] = 'Pravilo kvocienta';
$string['calc_rules_fact'] = '<b>Pravilo produkta</b><br />Naslednje pravilo omogoča izračun odvoda produkta dveh funkcij.
Izračunati želimo odvod \\(f(x)g(x)\\) glede na spremenljivko \\(x\\).
\\[ \\frac{\\mathrm{d}}{\\mathrm{d}{x}} \\big(f(x)g(x)\\big) = f(x) \\cdot \\frac{\\mathrm{d} g(x)}{\\mathrm{d}{x}}  + g(x)\\cdot \\frac{\\mathrm{d} f(x)}{\\mathrm{d}{x}},\\] ali pa uporabimo alternativno obliko zapisa, \\[ (f(x)g(x))\' = f\'(x)g(x)+f(x)g\'(x). \\]
<b>Pravilo kvocienta</b><br />Naslednje pravilo omogoča izračun odvoda kvocienta dveh funkcij
 \\(f(x)\\) in \\(g(x)\\).
\\[\\frac{d}{dx}\\left(\\frac{f(x)}{g(x)}\\right)=\\frac{g(x)\\cdot\\frac{df(x)}{dx}\\ \\ - \\ \\ f(x)\\cdot \\frac{dg(x)}{dx}}{g(x)^2}. \\]
<b>Verižno pravilo</b><br />Naslednje pravilo omogoča izračun odvoda dveh sestavljenih funkcij (oz. kompozituma funkcij).
Predpostavimo, da imamo funkcijo \\(f(g(x))\\). Definiramo \\(u=g (x)\\). Odvod funkcije glede na \\(x\\) je naslednji:
\\[\\frac{df(g(x))}{dx} = \\frac{dg(x)}{dx}\\cdot\\frac{df(u)}{du}.\\]
Alternativni zapis je naslednji:
\\[\\frac{df(x)}{dx} = f\'(g(x))\\cdot g\'(x).\\]';
$string['calc_rules_name'] = 'Računske opracije (pravila)';
$string['casdisplay'] = 'Prikaz CAS-a';
$string['cassuitecolerrors'] = 'Napake CAS-a';
$string['castext'] = 'CAS tekst';
$string['casvalid'] = 'V2';
$string['casvalidatemismatch'] = '[Preverjanje CAS-a neustrezno]';
$string['casvalue'] = 'Vrednosti CAS';
$string['chat'] = 'Pošlji v CAS';
$string['chat_desc'] = 'Povezava <a href="{$a->link}">CAS skripte za pogovor</a> vam omogoča preizkus povezave s CAS-om in preizkus Maxima sintakse.';
$string['chatintro'] = 'Ta stran omogoča neposredno ocenjevanje besedila CAS. To je preprosta skripta, ki je koristen pripomoček za preverjanje delovanja CAS in testiranje različnih vnosov. Prvo besedilno polje omogoča določitev spremenljivk, drugo pa je namenjeno samemu besedilu CAS.';
$string['chattitle'] = 'Preveri povezljivost s CAS-om';
$string['checkanswertype'] = 'Preverite vrsto odziva';
$string['checkanswertype_help'] = 'Če je odgovor pritrdilen, se odgovori, ki so drugačnega "tipa" (npr. Izraz, enačba, matrika, seznam, množica), zavrnejo kot neveljavni.';
$string['checkanswertype_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md#Check_Type';
$string['clearedthecache'] = 'Predpomnilnik CASa je bil izbrisan.';
$string['clearingcachefiles'] = 'Brisanje predpomnjenih datotek STACK {$a->done}/{$a->total}';
$string['clearingthecache'] = 'Brisanje predpomnilnika';
$string['clearthecache'] = 'Izbriši predpomnilnik';
$string['completetestcase'] = 'Dopolnite vaš vnos, da lahko izvedete preverbo odgovora.';
$string['complexno'] = 'Pomen in prikaz sqrt (-1)';
$string['complexno_help'] = 'Pomen in prikaz simbola i in sqrt (-1)';
$string['complexno_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Options.md#sqrt_minus_one.';
$string['createtestcase'] = 'Ustvarite testni primer';
$string['currentlyselectedvariant'] = 'To je različica, ki je prikazana spodaj';
$string['ddl_badanswer'] = 'Polje odgovora modela za ta vnos je napačno oblikovano: <code> {$ a} </code>.';
$string['ddl_duplicates'] = 'Med generiranjem vhodnih možnosti so bile najdene podvojene vrednosti.';
$string['ddl_empty'] = 'Za ta spustni meni niso bile izbrane nobene možnosti.';
$string['ddl_nocorrectanswersupplied'] = 'Učitelj ni navedel vsaj enega pravilnega odgovora.';
$string['ddl_runtime'] = 'Pri vnosu je nastala naslednja napaka v izvajanju, ki vam preprečuje odgovarjanje. Obrnite se na učitelja.';
$string['ddl_unknown'] = 'STACK je prejel <code>{$a}</code>, vendar učitelj tega ne navaja kot možnost.';
$string['debuginfo'] = 'Informacija pregledovalnika';
$string['defaultmarkzeroifnoprts'] = 'Če to vprašanje nima PRTs-ov, mora biti privzeta oznaka 0.';
$string['defaultprtcorrectfeedback'] = '<span style="font-size: 1.5em; color:green;"><i class="fa fa-check"></i></span> Pravilen odgovor. Odlično!';
$string['defaultprtincorrectfeedback'] = '<span style="font-size: 1.5em; color:red;"><i class="fa fa-times"></i></span> Nepravilen odgovor.';
$string['defaultprtpartiallycorrectfeedback'] = '<span style="font-size: 1.5em; color:orange;"><i class="fa fa-adjust"></i></span> Vaš odgovor je delno pravilen.';
$string['deletetestcase'] = 'Izbris testnega primera {$a->no} za vprašanje {$a->question}';
$string['deletetestcaseareyousure'] = 'Ste prepričani, da želite izbrisati testni primer {$a->no} za vprašanje {$a->question}?';
$string['deletethistestcase'] = 'Izbrišite ta testni primer ...';
$string['deploy'] = 'Razmestite';
$string['deployedprogress'] = 'Razmestite variante (različice)';
$string['deployedvariants'] = 'Razmeščene različice';
$string['deployedvariantsn'] = 'Razmeščene različice ({$a})';
$string['deploymanyerror'] = 'Napaka pri vnosu uporabnika: ni mogoče razporediti "{$a->err}" različic.';
$string['deploymanynonew'] = 'Napisanih je bilo preveč ponovljenih vprašanj (opomb).';
$string['deploymanynotes'] = 'Upoštevajte, da se bo izvajanje STACK-a ustavilo, če bo izvedenih 10 neuspešnih poskusov ustvarjanja novega vprašanja (oz. opombe), ali če test vprašanja ne uspe.';
$string['deploymanysuccess'] = 'Število novih uspešno ustvarjenih, preizkušenih in uporabljenih različic: {$a->no}.';
$string['deployoutoftime'] = 'Časovna omejitev je bila prekoračena z uporabo približno {$a->time} sekund. Poskusite znova.';
$string['deployremoveall'] = 'Razmesti vse različice:';
$string['deploytestall'] = 'Zaženite vse teste na vseh nameščenih različicah (počasno):';
$string['deploytoomanyerror'] = 'STACK bo poskusil uporabiti do največ 100 novih različic v kateri koli zahtevi. Ni zavedenih novih različic.';
$string['displaymismatch'] = '[LaTeX mismatch] (LaTex neujemanje)';
$string['dropdowngotunrecognisedvalue'] = 'Nepravilen vnos.';
$string['editingtestcase'] = 'Urejanje testnega primera {$a->no} za vprašanje {$a->question}';
$string['editthistestcase'] = 'Uredi ta testni primer ...';
$string['equiv_AND'] = 'in';
$string['equiv_ANDOR'] = 'Preverite pravilno uporabo and/or (in/ali).';
$string['equiv_ASSUMEPOSREALVARS'] = 'Predpostavite +ve real vars';
$string['equiv_ASSUMEPOSVARS'] = 'Predpostavite +ve vars';
$string['equiv_LET'] = 'Naj';
$string['equiv_MISSINGVAR'] = 'Manjkajoče naloge';
$string['equiv_NOT'] = 'Ne/ni';
$string['equiv_OR'] = 'ali';
$string['equiv_SAMEROOTS'] = '(Same roots)';
$string['equivfirstline'] = 'V argumentu ste uporabili napačno prvo vrstico!';
$string['equivnocomments'] = 'Pri tej vrsti vnosa ne smete uporabljati komentarjev. Prosimo, delajte vrstico za vrstico.';
$string['errors'] = 'Napake';
$string['exceptionmessage'] = '{$a}';
$string['expectedanswernote'] = 'Pričakovani odgovor';
$string['expectedoutcomes'] = 'Pričakovani rezultati PRT: [uporabljeni vnosi] [inputs used]';
$string['expectedpenalty'] = 'Pričakovana napaka';
$string['expectedscore'] = 'Pričakovan odgovor';
$string['exportthisquestion'] = 'Izvozi ta odgovor';
$string['exportthisquestion_help'] = 'Ustvarjena bo izvozna datoteka Moodle XML, ki vsebuje samo to eno vprašanje. En primer, kdaj je le ta koristen. In če menite, da to vprašanje kaže na hrošče v STACK-u.';
$string['false'] = 'Napačen';
$string['falsebranch'] = 'Napačen odsek';
$string['falsebranch_help'] = 'Ta polja nadzirajo, kaj se zgodi, ko test odgovora ni uspešno opravljen.
## Mod in rezultat
Kako se prilagodi rezultate. = pomeni, da moramo rezultat postaviti na določeno vrednost, +/- pomeni, da dodamo ali odštejemo dano oceno od trenutne vrednosti.

### Odbitek
V prilagodljivem ali interaktivnem načinu je zabeleženo toliko kazni.

### Naslednji korak
Ali se je potrebno prestaviti na drugo vozlišče, in če je tako, na katero ali pa pride do ustavitve.

### Oznaka odgovora
To je oznaka, ki je ključna za namene poročanja. Zasnovana je tako, da beleži edinstveno pot skozi drevo odgovorov in rezultate testa vsakega odgovora. To je ustvarjeno samodejno.';
$string['feedbackfromprtx'] = '[Povratne informacije od {$a}. ]';
$string['feedbackstyle_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Potential_response_trees.md';
$string['feedbackvariables'] = 'Vrnjene spremenljivke';
$string['feedbackvariables_help'] = 'Povratne informacije spremenljivk vam omogočajo, da manipulirate, s katerimkoli vhodnim podatkom skupaj s spremenljivkami samih vprašanj. Tukaj definirane spremenljive se lahko uporabijo kjer koli v tem drevesu.';
$string['feedbackvariables_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Variables.md#Feedback_variables';
$string['fieldshouldnotcontainplaceholder'] = '{$a->field} ne bi smelo vsebovati nobenih [[{$a->type}: ...]] nosilcev mest.';
$string['firstnodemusthavelowestnumber'] = 'Prvo vozlišče mora imeti najnižjo vrednost.';
$string['fixdollars'] = 'Uporaba dolar znaka';
$string['fixdollars_help'] = 'Ta možnost je uporabna, če kopirate in lepite (ali vnašate) TeX z naslednjimi ločili: <code>$...$</code> in <code>$$...$$</code>. Uporabljena ločila bodo med postopkom shranjevanja nadomeščena s priporočenimi ločili.';
$string['fixdollarslabel'] = 'Nadomestite <code>$...$</code> z <code>\\(...\\)</code>, <code>$$...$$</code> z <code>\\[...\\]</code> in <code>@...@</code> z <code>{@...@}</code>.';
$string['forbiddendoubledollars'] = 'Pri matematičnem zapisu uporabite <code>\\(...\\) </code> ali <code>\\[...\\] </code>. Uporaba naslednjih zapisov <code>$...$</code> in <code>$$...$$</code> ni dovoljena. Na koncu obrazca obstaja tudi možnost samodejnih popravkov.';
$string['forbidfloat'] = 'Ne uporabi float (decimalni zapis)';
$string['forbidfloat_help'] = 'Če je nastavljeno na da, bo vsak odgovor udeleženca, ki vsebuje decimalni zapis oz. številko s plavajočo vejico, zavrnjen kot neveljaven.';
$string['forbidfloat_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md#Forbid_Floats';
$string['forbidwords'] = 'Prepovedane besede';
$string['forbidwords_help'] = 'To je seznam besed, ki jih udeleženci ne smejo uporabiti pri svojih odgovorih.';
$string['forbidwords_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md#Forbidden_Words';
$string['generalfeedback'] = 'Splošna povratna informacija';
$string['generalfeedback_help'] = 'Splošne povratne informacije so CASText. Splošne povratne informacije, znane tudi kot "delne rešitve", se študentom pokažejo po zastavljenem vprašanju. Za razliko od povratnih informacij, ki so odvisne od odgovora, ki ga je študent dal, so splošne povratne informacije vsem študentom podane enako. To je lahko odvisno od spremenljivk, ki se uporabijo pri samem vprašanju.';
$string['generalfeedback_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/CASText.md#general_feedback';
$string['greek_alphabet_fact'] = '<center>
<table>
<tr><td>
 Velike črke, \\(\\quad\\) </td><td>  male črke, \\(\\quad\\) </td><td> poimenovanje </td> </tr>   <tr> <td>
 \\(A\\)  </td><td>  \\(\\alpha\\)  </td><td>  alpha  </td> </tr>   <tr> <td>
 \\(B\\)  </td><td>  \\(\\beta\\)  </td><td>  beta </td> </tr>   <tr> <td>
 \\(\\Gamma\\)  </td><td>  \\(\\gamma\\)  </td><td>  gamma </td> </tr>   <tr> <td>
 \\(\\Delta\\)  </td><td>  \\(\\delta\\)  </td><td>  delta </td> </tr>   <tr> <td>
 \\(E\\)  </td><td>  \\(\\epsilon\\)  </td><td>  epsilon </td> </tr>   <tr> <td>
 \\(Z\\)  </td><td>  \\(\\zeta\\)  </td><td>  zeta </td> </tr>   <tr> <td>
 \\(H\\)  </td><td>  \\(\\eta\\)  </td><td>  eta </td> </tr>   <tr> <td>
 \\(\\Theta\\)  </td><td>  \\(\\theta\\)  </td><td>  theta </td> </tr>   <tr> <td>
 \\(K\\)  </td><td>  \\(\\kappa\\)  </td><td>  kappa </td> </tr>   <tr> <td>
 \\(M\\)  </td><td>  \\(\\mu\\)  </td><td>  mu </td> </tr>   <tr> <td>
 \\(N\\)  </td><td>  \\( u\\)  </td><td>  nu </td> </tr>   <tr> <td>
 \\(\\Xi\\)  </td><td>  \\(\\xi\\)  </td><td>  xi </td> </tr>   <tr> <td>
 \\(O\\)  </td><td>  \\(o\\)  </td><td>  omicron </td> </tr>   <tr> <td>
 \\(\\Pi\\)  </td><td>  \\(\\pi\\)  </td><td>  pi </td> </tr>   <tr> <td>
 \\(I\\)  </td><td>  \\(\\iota\\)  </td><td>  iota </td> </tr>   <tr> <td>
 \\(P\\)  </td><td>  \\(\\rho\\) </td><td>  rho </td> </tr>   <tr> <td>
 \\(\\Sigma\\)  </td><td>  \\(\\sigma\\)  </td><td>  sigma </td> </tr>   <tr> <td>
 \\(\\Lambda\\)  </td><td>  \\(\\lambda\\)  </td><td>  lambda </td> </tr>   <tr> <td>
 \\(T\\)  </td><td>  \\(\\tau\\)  </td><td>  tau </td> </tr>   <tr> <td>
 \\(\\Upsilon\\)  </td><td>  \\(\\upsilon\\)  </td><td>  upsilon </td> </tr>   <tr> <td>
 \\(\\Phi\\)  </td><td>  \\(\\phi\\)  </td><td>  phi </td> </tr>   <tr> <td>
 \\(X\\)  </td><td>  \\(\\chi\\)  </td><td>  chi </td> </tr>   <tr> <td>
 \\(\\Psi\\)  </td><td>  \\(\\psi\\)  </td><td> psi </td> </tr>   <tr> <td>
 \\(\\Omega\\)  </td><td>  \\(\\omega\\)  </td><td>  omega </td></tr>
</table></center>';
$string['greek_alphabet_name'] = 'Grška abeceda';
$string['healthautomaxopt'] = 'Samodejno ustvarite optimizirano Maxima sliko (image)';
$string['healthautomaxopt_failed'] = 'Izdelava optimizirane Maxima slike (image) NI USPELA: [{$a->errmsg}]';
$string['healthautomaxopt_nolisp'] = 'Različice LISP ni mogoče določiti, zato Maxima ni bila ustvarjena samodejno.';
$string['healthautomaxopt_nolisprun'] = 'Lisp.run ni mogoče samodejno najti. Poskusite "sudo updatedb" iz ukazne vrstice in uporabite dokumente za optimizacijo.';
$string['healthautomaxopt_notok'] = 'Maxima (image) se ni ustvarila samodejno.';
$string['healthautomaxopt_ok'] = 'Maxima (image) ustvarjena pri: <tt>{$a->command}</tt>';
$string['healthautomaxopt_succeeded'] = 'Optimizirana Maxima (image) je bila USPEŠNO ustvarjena';
$string['healthautomaxoptintro'] = 'Za najboljšo izvedbo je potrebno maximo optimizirati na napravi Linux. Oglejte si naslednjo dokumentacijo <a href="doc/doc.php/CAS/Optimising_Maxima.md">.';
$string['healthcheck'] = 'STACK pregled stanja';
$string['healthcheck_desc'] = 'Skripta za preverjanje stanja<a href="{$a->link}"> vam pomaga preveriti, ali vsi vidiki STACK delujejo pravilno.';
$string['healthcheckcache_db'] = 'Rezultati CAS so bili shranjeni v bazo podatkov.';
$string['healthcheckcache_none'] = 'Rezultati CAS se ne shranjujejo (v predpomnilnik).';
$string['healthcheckcache_otherdb'] = 'Rezultati CAS so bili shranjeni v drugo bazo podatkov.';
$string['healthcheckcachestatus'] = 'Predpomnilnik trenutno vsebuje {$a} vnosov.';
$string['healthcheckconfigintro1'] = 'Maxima je najdena in uporabljena v naslednjem imeniku:';
$string['healthcheckconnect'] = 'Poskus povezave s sistemom CAS';
$string['healthcheckconnectintro'] = 'Poskušamo oceniti naslednje besedilo CAS:';
$string['healthcheckcreateimage'] = 'Kreirajte Maxima image (sliko)';
$string['healthcheckfilters'] = 'Prepričajte se, da je {$a->filter} omogočen na <a href="{$a->url} "> strani upravljanja filtrov.';
$string['healthchecklatex'] = 'Preverite, ali se LaTeX prevede pravilno';
$string['healthchecklatexintro'] = 'STACK omogoča učiteljem, da uporabijo LaTeX kodo pri sestavljanju vprašanj. Predvideno je, da se bo LaTeX koda pretvorila s pomočjo samega Moodle filtra. Spodaj so navedeni primeri vgrajenih izrazov v LaTeX-u, ki se morajo pravilno prikazati v vašem brskalniku. Težave pri prikazu so posledica napačne nastavitev filtra in ne napake STACKa. STACK uporablja samo notacijo enojnega in dvojnega dolarja, vendar pa se nekateri avtorji morda zanašajo na druge oblike zapisa.';
$string['healthchecklatexmathjax'] = 'STACK je vezan na MathJax filter Moodla. Druga možnost je, da dodate JavaScript kodo v dodatno datoteko HTML samega Moodle. Za podrobnosti o tej možnosti si oglejte datoteko namestitev STACKa.';
$string['healthcheckmathsdisplaymethod'] = 'Uporabljena je bila metoda prikaza Math: {$a}.';
$string['healthcheckmaximabat'] = 'Manjka datoteka maxima.bat.';
$string['healthcheckmaximabatinfo'] = 'Ta skripta je poskušala samodejno kopirati skripto maxima.bat iz "C:\\Program files\\Maxima-1.xx.y\\bin" v "{$a}\\stack". Vendar se zdi, da kopiranje ni uspelo. Kopirajte to datoteko ročno.';
$string['healthcheckplots'] = 'Izris grafa funkcije.';
$string['healthcheckplotsintro'] = 'Obstajati bi morala dva različna izrisa. Če sta vidna dva enaka izrisa, potem je prišlo do napake pri poimenovanju datotek. Če napake niso označene in se izris kljub temu ne pokaže, si lahko pomagate na naslednji način: (i) preverite ali imate dovoljenje za branje iz dveh začasnih imenikov. (ii) spremenite možnosti, ki jih GNUPlot uporablja za izdelavo izrisov. Za te možnosti trenutno ni spletnega vmesnika.';
$string['healthchecksamplecas'] = 'Odvod {@ x^4/(1+x^4) @} je \\[ \\frac{d}{dx} \\frac{x^4}{1+x^4} = {@ diff(x^4/(1+x^4),x) @}. \\]';
$string['healthchecksampledisplaytex'] = '\\[\\sum_{n=1}^\\infty \\frac{1}{n^2} = \\frac{\\pi^2}{6}.\\]';
$string['healthchecksampleinlinetex'] = '\\(\\sum_{n=1}^\\infty \\frac{1}{n^2} = \\frac{\\pi^2}{6}\\).';
$string['healthchecksampleplots'] = 'Dva primera izrisa.  {@plot([x^4/(1+x^4),diff(x^4/(1+x^4),x)],[x,-3,3])@} {@plot([sin(x),x,x^2,x^3],[x,-3,3],[y,-3,3],grid2d)@} Tretja, manjša ploskev je tukaj morda prikazana z osi. (Samo novejše različice Maxima.) {@plot([sin(x),x,x^2,x^3],[x,-3,3],[y,-3,3],[box, false],[yx_ratio, 1],[axes, solid],[xtics, -3, 1, 3],[ytics, -3, 1, 3],[size,250,250])@}';
$string['healthchecksstackmaximanotupdated'] = 'Zdi se, da STACK ni bil ustrezno posodobljen. Obiščite <a href="{$a}">System administration -> Stran z obvestili </a>.';
$string['healthchecksstackmaximatooold'] = 'Različica/verzija je stara in zato neprepoznavna!';
$string['healthchecksstackmaximaversion'] = 'verzija Maxima';
$string['healthchecksstackmaximaversionfixoptimised'] = '<a href="{$a->url}"> obnovi optimizirano izvedljivo datoteko Maxima </a>.';
$string['healthchecksstackmaximaversionfixserver'] = 'Obnovite kodo Maxima na strežniku MaximaPool.';
$string['healthchecksstackmaximaversionfixunknown'] = 'Pravzaprav ni jasno, kako se je to zgodilo. Te težave boste morali odpraviti sami. Začnite z brisanjem predpomnilnika CAS.';
$string['healthchecksstackmaximaversionmismatch'] = 'Uporabljena različica knjižnice STACK-Maxima ({$a->usedversion}) se ne ujema s pričakovano ({$a->expectedversion}) različico STACK vprašanj. {$a->fix}';
$string['healthchecksstackmaximaversionok'] = 'Uporabljena je pravilna in pričakovana različica knjižnice STACK-Maxima ({$a->usedversion}).';
$string['healthunabletolistavail'] = 'Vrsta platforme (različice) trenutno ni nastavljena na "unix", zato ni mogoče navesti razpoložljivih različic Maxima.';
$string['healthuncached'] = 'Uncached CAS call ()';
$string['healthuncachedintro'] = 'Ta razdelek vedno pošlje pristni klic v CAS, ne glede na trenutne nastavitve predpomnilnika. To je potrebno, kot zagotovilo, da je povezava s sistemom CAS delujoča.';
$string['healthuncachedstack_CAS_calculation'] = 'Pričakovan CAS izračun: {$a->expected}.  Dejanski CAS izračun: {$a->actual}.';
$string['healthuncachedstack_CAS_not'] = 'CAS je vrnil nekaj podatkov, kot je bilo pričakovano, vendar je prišlo do napak.';
$string['healthuncachedstack_CAS_ok'] = 'CAS je vrnil podatke, kot je bilo pričakovano. Imate povezavo s CAS-om.';
$string['healthuncachedstack_CAS_version'] = 'Pričakovan Maxima izračun: {$a->expected}.  Dejanski Maxima izračun: {$a->actual}.';
$string['healthuncachedstack_CAS_versionnotchecked'] = 'Izbrali ste "privzeto" različico Maxima. Preverjanje različice Maxima ni bilo izvedeno. Vaša trenutna povezava dejansko uporablja različico {$a->actual}.';
$string['htmlfragment'] = 'Zdi se, da imate v izrazu nekaj HTML elementov.';
$string['hyp_functions_fact'] = 'Hiperbolične funkcije imajo podobne lastnosti kot trigonometrične funkcije, vendar jih lahko predstavimo v eksponentni obliki, kot sledi:
 \\[ \\cosh(x)      = \\frac{e^x+e^{-x}}{2}, \\qquad \\sinh(x)=\\frac{e^x-e^{-x}}{2} \\]
 \\[ \\tanh(x)      = \\frac{\\sinh(x)}{\\cosh(x)} = \\frac{{e^x-e^{-x}}}{e^x+e^{-x}} \\]
 \\[ {\\rm sech}(x) ={1\\over \\cosh(x)}={2\\over {\\rm e}^x+{\\rm e}^{-x}}, \\qquad  {\\rm cosech}(x)= {1\\over \\sinh(x)}={2\\over {\\rm e}^x-{\\rm e}^{-x}} \\]
 \\[ {\\rm coth}(x) ={\\cosh(x)\\over \\sinh(x)} = {1\\over {\\rm tanh}(x)} ={{\\rm e}^x+{\\rm e}^{-x}\\over {\\rm e}^x-{\\rm e}^{-x}}\\]';
$string['hyp_functions_name'] = 'Hiperbolične funkcije';
$string['hyp_identities_fact'] = 'Podobnost hiperboličnih in trigonometričnih funkcij je očitna, če si pogledamo že nekaj osnovnih hiperboličnih enakosti (identitet):
  \\[{\\rm e}^x=\\cosh(x)+\\sinh(x), \\quad {\\rm e}^{-x}=\\cosh(x)-\\sinh(x)\\]
  \\[\\cosh^2(x) -\\sinh^2(x) = 1\\]
  \\[1-{\\rm tanh}^2(x)={\\rm sech}^2(x)\\]
  \\[{\\rm coth}^2(x)-1={\\rm cosech}^2(x)\\]
  \\[\\sinh(x\\pm y)=\\sinh(x)\\ \\cosh(y)\\ \\pm\\ \\cosh(x)\\ \\sinh(y)\\]
  \\[\\cosh(x\\pm y)=\\cosh(x)\\ \\cosh(y)\\ \\pm\\ \\sinh(x)\\ \\sinh(y)\\]
  \\[\\sinh(2x)=2\\,\\sinh(x)\\cosh(x)\\]
  \\[\\cosh(2x)=\\cosh^2(x)+\\sinh^2(x)\\]
  \\[\\cosh^2(x)={\\cosh(2x)+1\\over 2}\\]
  \\[\\sinh^2(x)={\\cosh(2x)-1\\over 2}\\]';
$string['hyp_identities_name'] = 'Hiperbolične enakosti';
$string['hyp_inverse_functions_fact'] = '\\[\\cosh^{-1}(x)=\\ln\\left(x+\\sqrt{x^2-1}\\right) \\quad \\mbox{ for } x\\geq 1\\]
 \\[\\sinh^{-1}(x)=\\ln\\left(x+\\sqrt{x^2+1}\\right)\\]
 \\[\\tanh^{-1}(x) = \\frac{1}{2}\\ln\\left({1+x\\over 1-x}\\right) \\quad \\mbox{ for } -1< x < 1\\]';
$string['hyp_inverse_functions_name'] = 'Inverzne hiperbolične funkcije';
$string['illegalcaschars'] = 'Znaki @, $ in \\ pri vnosu CAS niso dovoljeni.';
$string['inputdisplayed'] = 'Predstavljeno kot';
$string['inputentered'] = 'Vstavljena vrednost';
$string['inputexpression'] = 'Testni vnos';
$string['inputextraoptions'] = 'Dodatne opcije';
$string['inputextraoptions_help'] = 'Nekatere vrste vnosov zahtevajo dodatne možnosti da delujejo. Lahko jih vnesete tukaj. Ta vrednost je CAS-zapis.';
$string['inputextraoptions_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md#Extra options';
$string['inputheading'] = 'Vnesite: {$a}';
$string['inputlanguageproblems'] = 'Med jezikovnimi vnosi in preverjanji obstajajo neskladnosti.';
$string['inputname'] = 'Vnesite ime';
$string['inputnamelength'] = 'Vnešena imena ne smejo biti daljša od 18 znakov. \'{$a}\' zapis je predolg.';
$string['inputoptionunknown'] = 'Vnos ne podpira opcije \'{$a}\'.';
$string['inputremovedconfirm'] = 'Potrjujem, da želim ta vnos odstraniti iz vprašanja.';
$string['inputremovedconfirmbelow'] = 'Vnos \'{$a}\' je bil odstranjen. Prosimo, potrdite to spodaj.';
$string['inputs'] = 'Vnosi';
$string['inputstatus'] = 'Status';
$string['inputstatusname'] = 'Prazen';
$string['inputstatusnameinvalid'] = 'Neveljaven';
$string['inputstatusnamescore'] = 'Rezultat';
$string['inputstatusnamevalid'] = 'Dovoljen';
$string['inputtest'] = 'Testni vnos';
$string['inputtype'] = 'Vrsta vnosa';
$string['inputtype_help'] = 'To določa vrsto vhodnega elementa, npr. polje obrazca, resnično/napačno, območje besedila.';
$string['inputtype_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md';
$string['inputtypealgebraic'] = 'Algebraični vnos';
$string['inputtypeboolean'] = 'Drži/Ne drži';
$string['inputtypecheckbox'] = 'Preveri';
$string['inputtypedropdown'] = 'Spustni seznam';
$string['inputtypeequiv'] = 'Razlogi za enakost (Equivalence reasoning)';
$string['inputtypematrix'] = 'Matrika';
$string['inputtypenotes'] = 'Zapisi';
$string['inputtypenumerical'] = 'Številčno';
$string['inputtyperadio'] = 'Radio';
$string['inputtypesinglechar'] = 'Eno črko';
$string['inputtypestring'] = 'Niz';
$string['inputtypetextarea'] = 'Področje za vnos besedila';
$string['inputtypeunits'] = 'Enote';
$string['inputwillberemoved'] = 'Ta vnos ni več vezan na besedilo vprašanja. Če vprašanje shranite zdaj, bodo podatki o tem trenutnem vnosu, izgubljeni. Potrdite, da to želite storiti. Lahko pa uredite besedilo vprašanja in ga tako vrnete na prejšnje stanje \'[[input:{$a}]]\' in \'[[validation:{$a}]]\'.';
$string['insertspaces'] = 'Za presledke vnesite samo zvezdice';
$string['insertstars'] = 'Vnesite/vstavite zvezdice';
$string['insertstars_help'] = 'Ta možnost ponuja številne različne možnosti za vstavljanje zvezdic, kjer je predvideno množenje. Prosimo, preberite podrobnejšo dokumentacijo.';
$string['insertstars_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md#Insert_Stars';
$string['insertstarsassumesinglechar'] = 'Vstavitev zvezdice predpostavi zapis spremenljivk z enim znakom';
$string['insertstarsno'] = 'Ne vnesite/vstavite zvezdice';
$string['insertstarsspaces'] = 'Znak zvezdico vnesite za operacijo množenja in presledke';
$string['insertstarsspacessinglechar'] = 'Vstavite znak zvezdico za eno-znakovne spremenljivke in za presledke';
$string['insertstarsyes'] = 'Znak zvezdico vnesite samo za operacijo množenja';
$string['inversetrig'] = 'Inverzne trigonometrične funkcije';
$string['inversetrig_help'] = 'Nadzira, kako CAS prikaže inverzne trigonometrične funkcije.';
$string['inversetrig_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Options.md#inverse_trig';
$string['irred_Q_commonint'] = 'Izvzeti morate skupni faktor.';
$string['irred_Q_factored'] = 'Izraz {$a->m0} ne sme biti faktoriziran (razstavljen), vendar je.';
$string['irred_Q_optional_fac'] = 'Lahko bi naredili še kakšen korak več, glede na to, da se izraz {$a->m0} še da faktorizirati (razstaviti). Vendar vam tega ni treba.';
$string['logicsymbol_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Options.md#logicsymbol';
$string['matrixparens'] = 'Privzeta oblika matričnih oklepajev';
$string['matrixparens_help'] = 'Nadzira privzeto obliko matričnih oklepajev, kot jih prikaže CAS.';
$string['matrixparens_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/CAS/Matrix.md#matrixparens';
$string['multcross'] = 'Križec';
$string['multdot'] = 'Pika';
$string['multiplicationsign'] = 'Znak za množenje';
$string['multiplicationsign_help'] = 'Nadzira, kako se prikazujejo znaki za množenje.';
$string['multiplicationsign_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Options.md#multiplication';
$string['mustverify'] = 'Udeleženec mora preveriti';
$string['mustverify_help'] = 'Določa, ali se vnos obravnava kot prisilni dvostopenjski postopek,  preden je ta vnos na voljo mehanizmu ocenjevanja. O sintaktičnih napakah se vedno poroča za nazaj.';
$string['mustverify_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md#Student_must_verify';
$string['mustverifyshowvalidation'] = 'Potrjevanja v dveh korakih žal ne morete izbrati. Udeležencu se tako po prvem koraku ne pokažejo rezultati potrjevanja. To postavlja udeleženca v nemogoč položaj.';
$string['namealreadyused'] = 'Vstavljeno ime ste že uporabili.';
$string['newnameforx'] = 'Na novo poimenujte \'{$a}\'';
$string['next'] = 'Naslednji korak';
$string['nextcannotbeself'] = 'Vozlišča samega s seboj ne smete povezati kot naslednje vozlišče.';
$string['nodehelp'] = 'Vozlišče odgovora';
$string['nodehelp_help'] = '### Test odgovora
Primerjalni test se uporablja za primerjavo dveh izrazov. S tem se preveri, ali ustrezata nekaterim matematičnim kriterijem.

### SAns
To je prvi argument funkcije testa. Pri asimetričnih testih to velja za "odgovor udeleženca", čeprav je lahko kateri koli veljaven izraz CAS in je lahko odvisen od spremenljivk vprašanja.

### TAns
To je drugi argument funkcije testa. Pri asimetričnih testih to velja za "odgovor učitelja", čeprav je lahko kateri koli veljaven izraz CAS in je lahko odvisen od spremenljivk vprašanja.

### Možnosti testa
To polje omogoča, da test sprejme eno od možnosti, npr. spremenljivka ali numerična vrednost.

### Tih.
Če je nastavljeno na da, se vsaka povratna informacija, ki jo test samodejno ustvari, udeležencu ne prikaže. Ta možnost ne vpliva na polja povratnih informacij v drevesu odgovorov.';
$string['nodeloopdetected'] = 'Ta povezava ustvarja cikel v PRT.';
$string['nodenotused'] = 'Na to vozlišče niso vezana druga vozlišča v PRT.';
$string['nodex'] = 'Vozlišče {$a}';
$string['nodexdelete'] = 'Odstranite vozlišče {$a}';
$string['nodexfalsefeedback'] = 'Vozlišče {$a}: povratna informacija na napačen odgovor';
$string['nodextruefeedback'] = 'Vozlišče {$a}: povratna informacija na pravilen odgovor';
$string['nodexwhenfalse'] = 'Vozlišče {$a}, ko je napačno';
$string['nodexwhentrue'] = 'Vozlišče {$a}, ko je pravilno';
$string['nonempty'] = 'To ne sme ostati prazno.';
$string['noprtsifnoinputs'] = 'Vprašanje brez vnosa ne more imeti PRT-ja.';
$string['notanswered'] = '(odgovor ni podan)';
$string['notavalidname'] = 'Neveljavno ime';
$string['notestcasesyet'] = 'Nobenih testnih primerov še ni bilo dodanih.';
$string['numericalinputdp'] = 'Uporabiti morate natančno \\ ({$a} \\) decimalnih mest.';
$string['numericalinputmaxdp'] = 'Uporabiti morate največ \\ ({$a} \\) decimalnih mest.';
$string['numericalinputmaxsf'] = 'Uporabiti morate največ \\ ({$a} \\) veljavnih mest.';
$string['numericalinputmindp'] = 'Uporabiti morate vsaj \\ ({$a} \\) decimalnih mest.';
$string['numericalinputminmaxerr'] = 'Zahtevano minimalno število uporabljenih številskih mest presega največje število dovoljenih mest!';
$string['numericalinputminsf'] = 'Uporabiti morate vsaj \\ ({$a} \\) veljavnih mest.';
$string['numericalinputminsfmaxdperr'] = 'Pri istem vnosu ne navedite istočasno zahtev za decimalna mesta in veljavna mesta.';
$string['numericalinputmustfloat'] = 'Za vnos uporabite decimalni zapis.';
$string['numericalinputmustnumber'] = 'Za vnos se pričakuje število.';
$string['numericalinputmustrational'] = 'Za vnos uporabite ulomek ali decimalni zapis';
$string['numericalinputoptboolerr'] = 'Vrednost izbrane možnosti <code>{$a->opt}</code> mora biti logična, binarna (boolean), v resnici pa je <code>{$a->val}</code>.';
$string['numericalinputoptinterr'] = 'Vrednost izbrane možnosti <code>{$a->opt}</code> mora biti celoštevilska, v resnici pa je <code>{$a->val}</code>.';
$string['numericalinputsf'] = 'Uporabiti morate natančno \\ ({$a} \\) veljavnih mest.';
$string['numericalinputvarsforbidden'] = 'Ta vnos predvideva število in zato morda ne vsebuje spremenljivk.';
$string['options'] = 'Možnosti';
$string['optionsnotrequired'] = 'Ta vrsta vnosa ne zahteva nobenih možnosti.';
$string['overallresult'] = 'Končen rezultat.';
$string['penalty'] = 'Odbitek (Kazenska točka)';
$string['penalty_help'] = 'Kazenske točke se odštejejo od rezultata vsakega PRT-ja za vsak drugačen in veljaven poskus, ki ni povsem pravilen.';
$string['penalty_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Feedback.md';
$string['penaltyerror'] = 'Odbitek mora biti številčna vrednost med 0 in 1.';
$string['penaltyerror2'] = 'Odbitek lahko pustite neovrednoten ali pa mu namenite številčno vrednost med 0 in 1.';
$string['phpcasstring'] = 'PHP izhod';
$string['phpsuitecolerror'] = 'PHP napake';
$string['phpvalid'] = 'V1';
$string['phpvalidatemismatch'] = '[PHP validate mismatch]  (PHP je potrdil neujemanje)';
$string['pleaseananswerallparts'] = 'Odgovorite na vse dele vprašanja.';
$string['pleasecheckyourinputs'] = 'Preverite, ali je tisto, kar ste vnesli, bilo pravilno interpretirano.';
$string['pluginname'] = 'STACK';
$string['pluginname_help'] = 'STACK je sistem za matematično ocenjevanje.';
$string['pluginnameadding'] = 'Dodajanje STACK vprašanja';
$string['pluginnameediting'] = 'Urejanje STACK vprašanja';
$string['pluginnamesummary'] = 'STACK ponuja matematična vprašanja za izdelavo Moodle kvizov. Te uporabljajo računalniško podprti sistem algebre za določitev matematičnih lastnosti samih odgovorov.';
$string['privacy:metadata'] = 'Vtičnik STACK ne shranjuje nobenih osebnih podatkov.';
$string['prtcorrectfeedback'] = 'Standardne povratne informacije za pravilno';
$string['prtheading'] = 'Drevo potencialnih odgovorov: {$a}';
$string['prtincorrectfeedback'] = 'Standardna povratna informacija za napačen (odgovor, zapis).';
$string['prtmustbesetup'] = 'Ta PRT mora biti nastavljen, preden vprašanje shranite.';
$string['prtname'] = 'PRT ime';
$string['prtnamelength'] = 'PRT imena ne smejo biti daljša od 18 znakov. \'{$a}\' je predolg.';
$string['prtnodesheading'] = 'Vozlišča drevesa potencialnih odgovorov ({$a})';
$string['prtpartiallycorrectfeedback'] = 'Standardne povratne informacije za delno pravilne zapise.';
$string['prtremovedconfirm'] = 'Potrjujem, da želim iz tega vprašanja odstraniti potencialno drevo odgovorov.';
$string['prtremovedconfirmbelow'] = 'Drevo potencialnih odgovorov \'{$a}\' je bilo odstranjeno. Prosimo, potrdite to spodaj.';
$string['prtruntimeerror'] = 'Vozlišče {$a->node} je ustvarilo naslednjo napako v izvajanju: {$a->error}';
$string['prts'] = 'Drevesa potencialnih odgovorov';
$string['prtwillbecomeactivewhen'] = 'To drevo potencialnih odgovorov bo postalo aktivno, ko bo udeleženec odgovoril: {$a}';
$string['prtwillberemoved'] = 'Drevo potencialnih odgovorov ni več vezano na besedilo vprašanja ali pripadajoče povratne informacije. Če vprašanje shranite zdaj, bodo podatki o tem drevesu potencialnih odgovorov izgubljeni. Potrdite, da to želite storiti. Lahko pa uredite besedilo vprašanja in pripadajoče povratne informacije, če želite vrniti \'[[feedback:{$a}]]\'.';
$string['qm_error'] = 'Vaš odgovor vsebuje znak ?, ki v odgovorih ni dovoljen. Zamenjati ga morate z določeno vrednostjo.';
$string['questiondoesnotuserandomisation'] = 'To vprašanje ne uporablja randomizacije.';
$string['questionnotdeployedyet'] = 'Nobena različica tega vprašanja še ni bila uporabljena.';
$string['questionnote'] = 'Vprašanje (oznaka)';
$string['questionnote_help'] = 'Vprašanje je vezano na CASText. Namen označitve vprašanja je razlikovati med naključnimi različicami vprašanja. Dve različici vprašanj sta enaki, če in samo, če sta oznaki vprašanj enaki. Pri kasnejših analizah je zelo koristno, če pustimo smiselne oznake vprašanj.';
$string['questionnote_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Question_note.md';
$string['questionnotempty'] = 'Označitev vprašanja ne sme ostati prazno, ko se v spremenljivkah vprašanja uporabi rand (). Namen označitve vprašanja je razlikovati med naključnimi različicami vprašanja.';
$string['questionpreview'] = 'Predogled vprašanja';
$string['questionsimplify'] = 'Poenostavite raven vprašanj';
$string['questionsimplify_help'] = 'Globalno spremenljivko "simp" znotraj Maxime nastavite za celotno vprašanje.';
$string['questionsimplify_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/CAS/Maxima.md#Simplification';
$string['questiontests'] = 'Testna vprašanja';
$string['questiontestspass'] = 'Vsi testi vprašanj so bili uspešno izvedeni.';
$string['questiontext'] = 'Besedilo vprašanja';
$string['questiontext_help'] = 'Besedilo vprašanja je del CASText. To je "vprašanje", ki ga študent dejansko vidi. Vhodne elemente in nize za potrditev morate vstaviti v to polje. Na primer z uporabo `[[input:ans1]] [[validation:ans1]]`.';
$string['questiontext_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/CASText.md#question_text';
$string['questiontextfeedbacklanguageproblems'] = 'V povratnih oznakah med jeziki obstajajo neskladnosti.';
$string['questiontextfeedbackonlycontain'] = 'Besedilo vprašanja v kombinaciji s posebnimi povratnimi informacijami mora vsebovati oznako (žeton) \'{$a}\' samo enkrat.';
$string['questiontextmustcontain'] = 'Besedilo vprašanja mora vsebovati simbol - (token) \'{$a}\'.';
$string['questiontextnonempty'] = 'Besedilo vprašanja ne sme biti prazno.';
$string['questiontextonlycontain'] = 'Besedilo vprašanja mora vsebovati simbol - (token) \'{$a}\' samo enkrat.';
$string['questiontextplaceholderswhitespace'] = 'Namestitve mesta ne smejo vsebovati praznega prostora. Zdi se, da je tako: \'{$a}\'.';
$string['questionvalue'] = 'Vrednost vprašanja';
$string['questionvaluepostive'] = 'Vrednost vprašanja ne sme biti negativna.';
$string['questionvariables'] = 'Spremenljivke vprašanja';
$string['questionvariables_help'] = 'To polje vam omogoča, da določite in upravljate s spremenljivkami CAS, npr. za ustvarjanje naključnih različic. Te so na voljo vsem drugim delom vprašanja.';
$string['questionvariables_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Variables.md#Question_variables';
$string['questionvariablevalues'] = 'Vrednosti spremenljivk samih vprašanj';
$string['quiet'] = 'Tih.';
$string['quiet_help'] = 'Če je nastavljeno na da, se vsako povratno informacijo, ki jo samodejno ustvari funkcija preverbe odgovora, zavrne in se študentu tudi ne prikaže. Ta možnost ne vpliva na polja povratnih informacij.';
$string['renamequestionparts'] = 'Preimenujte dele vprašanja';
$string['replacedollarscount'] = 'Ta kategorija vsebuje {$a} STACK vprašanj.';
$string['replacedollarserrors'] = 'Naslednja vprašanja so povzročila napake.';
$string['replacedollarsin'] = 'Fiksni matematični znaki oz. ločila v polju {$a}';
$string['replacedollarsindex'] = 'Konteksti (besedilo) s STACK vprašanji';
$string['replacedollarsindexintro'] = 'Če izberete katero koli povezavo, vas bo preusmerila na stran, na kateri si lahko ogledate vprašanja zapisana v "starem" slogu in jih lahko samodejno popravite. Če imate v enem kontekstu preveč vprašanj, bo količina izpisa verjetno "preplavila" vaš spletni brskalnik; v tem primeru v URL dodajte parameter za predogled=0 in poskusite znova.';
$string['replacedollarsindextitle'] = 'Zamenjajte $ v besedilu vprašanja';
$string['replacedollarsnoproblems'] = 'Najdenih ni bilo nobenih težav.';
$string['replacedollarstitle'] = 'Zamenjajte $ v {$a} v samem besedilu vprašanja';
$string['requiredfield'] = 'To polje je obvezno!';
$string['requirelowestterms'] = 'Uporabite male tiskane znake';
$string['requirelowestterms_help'] = 'Če je ta možnost nastavljena na da, morajo biti vsi koeficienti ali druga racionalna števila v izrazu zapisani z malimi tiskanimi črkami. V nasprotnem primeru je odgovor zavrnjen kot neveljaven.';
$string['requirelowestterms_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md#Require_lowest_terms';
$string['runquestiontests'] = 'Testna vprašanja in nameščene različice';
$string['sans'] = 'SAns';
$string['sans_help'] = 'To je prvi argument k funkciji testa odgovora. Pri asimetričnih preskusih se to šteje za "odgovor udeleženca", čeprav je lahko kateri koli veljaven CAS izraz in je lahko odvisen od spremenljivk samega vprašanja.';
$string['sans_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Answer_Tests/index.md';
$string['sansrequired'] = 'SAns ne sme biti prazen.';
$string['score'] = 'Rezultat';
$string['scoreerror'] = 'Rezultat mora biti številčna vrednost med 0 in 1.';
$string['scoremode'] = 'Mod (modul)';
$string['seedx'] = 'Seme {$a}';
$string['seethisquestioninthequestionbank'] = 'Poglej vprašanje v zbirki vprašanj';
$string['settingajaxvalidation'] = 'Hitra potrditev';
$string['settingajaxvalidation_desc'] = 'Če je ta nastavitev vklopljena, bo trenutni vnos udeleženca potrjen tudi, ko bo narejena pavza med tipkanjem. To zagotavlja boljšo uporabniško izkušnjo, vendar bo verjetno povečalo obremenitev strežnika.';
$string['settingcasdebugging'] = 'Odpravljanje napak CAS';
$string['settingcasdebugging_desc'] = 'Ali želite shraniti informacije glede odpravljanja napak vezano na povezavo CAS.';
$string['settingcasmaximaversion'] = 'Različica Maxima';
$string['settingcasmaximaversion_desc'] = 'Uporabljena različica Maxime.';
$string['settingcasresultscache'] = 'Predpomnjenje rezultatov CAS-a';
$string['settingcasresultscache_db'] = 'Predpomnilnik v bazi podatkov';
$string['settingcasresultscache_desc'] = 'Ta nastavitev določa, ali bodo pozivi CASa predpomnjeni. To nastavitev je treba vklopiti, če ne razvijate kode Maxima. Trenutno stanje predpomnilnika je prikazano na osnovni strani. Če spremenite svoje nastavitve, npr. ukaz gnuplot, boste morali počistiti predpomnilnik, preden boste lahko videli učinke teh sprememb.';
$string['settingcasresultscache_none'] = 'Ne vstavi v predpomnilnik';
$string['settingcastimeout'] = 'Čas prekinitve povezave CAS';
$string['settingcastimeout_desc'] = 'Čas, ki se porabi pri poskusu povezave z Maxima.';
$string['settingdefaultinputoptions'] = 'Privzete možnosti vnosa';
$string['settingdefaultinputoptions_desc'] = 'Uporablja se pri ustvarjanju novega vprašanja ali dodajanju novega vnosa k obstoječemu vprašanju.';
$string['settingdefaultquestionoptions'] = 'Privzete možnosti vnosa';
$string['settingdefaultquestionoptions_desc'] = 'Uporablja se pri ustvarjanju novega vprašanja.';
$string['settingmathsdisplay'] = 'Matematični filtri';
$string['settingmathsdisplay_desc'] = 'Metoda, ki se uporablja za prikaz matematičnih simbolov. Če izberete MathJax, boste za njegovo nastavitev morali upoštevati navodila na strani Healthcheck. Če izberete filter, pa mora le-ta biti omogočen na strani Upravljanja in konfiguriranja filtrov.';
$string['settingmathsdisplay_mathjax'] = 'MathJax';
$string['settingmathsdisplay_maths'] = 'Star OU matematični filter';
$string['settingmathsdisplay_oumaths'] = 'Nov OU matematični filter';
$string['settingmathsdisplay_tex'] = 'Moodlov TeX filter';
$string['settingmaximalibraries'] = 'Naložite izbirne/dodatne knjižnice Maxima:';
$string['settingmaximalibraries_desc'] = 'To je seznam imen - Maxima knjižnic, ki se bodo samodejno naložile v Maxima. Uporabljajo se lahko samo podprta imena knjižnic: "stats, distrib, descriptive, simplex".  Te knjižnice se ne bodo naložile, če ste shranili maksima verzijo (image) za optimizacijo delovanja.';
$string['settingmaximalibraries_error'] = 'Naslednji paket ni podprt: {$a}';
$string['settingmaximalibraries_failed'] = 'Zdi se, kot da nekaterih paketov Maxima, ki ste jih zahtevali, ni uspelo naložiti. Glede vrste napake si poglejte navodila za namestitev.';
$string['settingplatformmaximacommand'] = 'Ukaz Maxima';
$string['settingplatformmaximacommand_desc'] = 'Za vrsto platforme: Server, nastavite na URL servlet Maxima Pool. Za druge tipe platform, če je ta izbor prazen, bo STACK sam predlagal, kje najti Maxima. Če to ne uspe, je potrebno nastaviti na celotno pot maksime ali izvedbo Maxima-optimized. Razmislite o uporabi ukaza timeout v sistemih, ki temeljijo na unixu. Npr. timeout --kill-after=10s 10s maxima';
$string['settingplatformplotcommand'] = 'Izpiši/prikaži ukaze';
$string['settingplatformplotcommand_desc'] = 'Običajno lahko ta vnos pustite prazen, če pa izris grafa ne deluje, boste morda morali vnesti celotno pot do ukaza gnuplot.';
$string['settingplatformtype'] = 'Vrsta platforme';
$string['settingplatformtype_desc'] = 'STACK mora vedeti, v kakšnem operacijskem sistemu deluje. Možnost »Server« zagotavlja boljše delovanje za ceno nastavitve dodatnega strežnika. Možnost "Linux (optimizirano)" je razložena na strani Optimizing Maxima.';
$string['settingplatformtypeserver'] = 'Strežnik';
$string['settingreplacedollars'] = 'Zamenjaj <code>$</code> in <code>$$</code>';
$string['settingreplacedollars_desc'] = 'V besedilu nadomestite <code>$...$</code> in <code>$$...$$</code> z <code>\\\\[...\\\\]</code> in <code>\\\\(...\\\\)</code>.   Boljša možnost je uporaba skripte  \'Fix maths delimiters\', ki je navedena spodaj.';
$string['settingserveruserpass'] = 'Strežniško uporabniško ime:geslo';
$string['settingserveruserpass_desc'] = 'Če uporabljate vrsto platforme: strežnik in če ste svoj strežnik Maxima pool nastavili s preverjanjem HTTP, lahko tukaj vnesete uporabniško ime in geslo. To je nekoliko varneje, kot če jih vstavite v URL. Oblika je uporabniško ime: geslo.';
$string['settingsmathsdisplayheading'] = 'Možnosti prikaza funkcije Maths (matematične funkcije)';
$string['settingsmaximasettings'] = 'Povezujem se z Maxima';
$string['settingusefullinks'] = 'Uporabne povezave';
$string['showingundeployedvariant'] = 'Prikaz neuporabljene/nerazporejene variante: {$a}';
$string['showvalidation'] = 'Pokaži veljavnost';
$string['showvalidation_help'] = 'Prikaže kakršnekoli povratne informacije o potrditvi iz tega vnosa, vključno s ponovnim prikazom v tradicionalni dvodimenzionalni notaciji. O sintaksičnih napakah se vedno poroča za nazaj.';
$string['showvalidation_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md#Show_validation';
$string['showvalidationno'] = 'Ne';
$string['showvalidationyes'] = 'Da, s seznamom spremenljivk.';
$string['showvalidationyesnovars'] = 'Da, brez seznama spremenljivk.';
$string['singlechargotmorethanone'] = 'Tukaj lahko vnesete samo en znak.';
$string['specificfeedback'] = 'Posebne/specifične povratne informacije';
$string['specificfeedback_help'] = 'V tem bloku (razdelku) bodo privzeto prikazane povratne informacije za vsako drevo potencialnih odgovorov. Premaknete ga lahko na besedilo vprašanja. V tem primeru bo Moodle imel manj nadzora nad tem, kako bodo stvari prikazane. Upoštevajte, da ta blok (razdelek) ni CASText.';
$string['sqrtsign'] = 'Ali je kvadratni koren števila Iracionalno število?';
$string['sqrtsign_help'] = 'Izbor prikaza iracionalnih števil.';
$string['sqrtsign_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Options.md#surd';
$string['stack:usediagnostictools'] = 'Uporabite orodja STACK';
$string['stackBlock_elif_after_else'] = '"elif" uporabite za "else" v bloku if.';
$string['stackBlock_elif_out_of_an_if'] = '"elif" ne more obstajati zunaj bloka if.';
$string['stackBlock_else_out_of_an_if'] = '"else" ne more obstajati zunaj bloka if.';
$string['stackBlock_escapeNeedsValue'] = 'Escape-blok potrebuje atribut vrednosti.';
$string['stackBlock_ifNeedsCondition'] = 'If-blok potrebuje preizkusni atribut.';
$string['stackBlock_jsxgraph_height'] = 'Za višino JSXGraph moramo uporabiti znano CSS-enoto za dolžino.';
$string['stackBlock_jsxgraph_height_num'] = 'Številčni del zapisa višine JSXGraph mora biti samo število in ne sme vsebovati dodatnih znakov.';
$string['stackBlock_jsxgraph_param'] = 'Blok jsxgraph v tem kontekstu podpira samo te parametre: {$a->param}.';
$string['stackBlock_jsxgraph_ref'] = 'Blok jsxgraph podpira samo referenčne vhode, ki so prisotni v istem razdelku CASText; \'{$a->var}\' tukaj ne obstaja.';
$string['stackBlock_jsxgraph_width'] = 'Pri določitvi širine JSXGraph-a morate uporabiti znano enoto dolžine CSS.';
$string['stackBlock_jsxgraph_width_num'] = 'Številčni del zapisa širine JSXGraph-a mora biti samo število in ne sme vsebovati dodatnih znakov.';
$string['stackBlock_missmatch'] = 'se ne ujema.';
$string['stackBlock_multiple_else'] = 'Več else podrazdelkov v bloku if.';
$string['stackBlock_unknownBlock'] = 'Naslednji blok ni znan:';
$string['stackCas_CASError'] = 'CAS je vrnil naslednje napake:';
$string['stackCas_CASErrorCaused'] = 'povzročila naslednjo napako:';
$string['stackCas_MissingAt'] = 'Manjka vam znak <code>@</code>.';
$string['stackCas_MissingCloseDisplay'] = 'Manjka <code>\\]</code>.';
$string['stackCas_MissingCloseHTML'] = 'Manjka vam zaključna html oznaka.';
$string['stackCas_MissingCloseInline'] = 'Manjka <code>\\)</code>.';
$string['stackCas_MissingClosingRawCAS'] = 'Manjka <code>#}</code>.';
$string['stackCas_MissingClosingTeXCAS'] = 'Manjka <code>@}</code>.';
$string['stackCas_MissingDollar'] = 'Manjka vam znak <code>$</code>.';
$string['stackCas_MissingOpenDisplay'] = 'Manjka <code>\\[</code>.';
$string['stackCas_MissingOpenHTML'] = 'Manjka html oznaka.';
$string['stackCas_MissingOpenInline'] = 'Manjka <code>\\(</code>.';
$string['stackCas_MissingOpenRawCAS'] = 'Manjka <code>{#</code>.';
$string['stackCas_MissingOpenTeXCAS'] = 'Manjka <code>{@</code>.';
$string['stackCas_MissingStars'] = 'Videti je, da manjkajo *. Morda ste mislili vnesti {$a->cmd}.';
$string['stackCas_MissingString'] = 'Manjka znak za citiranje <code>"</code>.';
$string['stackCas_StringOperation'] = 'Zdi se, da je niz na napačnem mestu. Težava je v: <code>{$a->issue}</code>.';
$string['stackCas_allFailed'] = 'CAS ni uspel vrniti nobenega ocenjenega izraza. Preverite povezavo s sistemom CAS.';
$string['stackCas_apostrophe'] = 'Apostrof v odgovorih ni dovoljen.';
$string['stackCas_backward_inequalities'] = 'Neenakosti, npr. \\( \\leq \\) ali \\(\\geq \\) je potrebno vnesti kot <= ali >=. V zapisu imate {$a->cmd}, ki je narobe obrnjen.';
$string['stackCas_badLogIn'] = '';
$string['stackCas_bracketsdontmatch'] = 'V izrazu so oklepaji napačno vstavljeni: {$a->cmd}.';
$string['stackCas_chained_inequalities'] = 'Zdi se, da imate "povezane neenakosti", npr. \\(a &lt b &lt c\\).  Posamezne neenakosti morate povezati z logičnimi operacijami, kot sta \\(and\\) ali \\(or\\).';
$string['stackCas_failedReturn'] = 'CAS ni uspel vrniti nobenih podatkov.';
$string['stackCas_failedReturnOne'] = 'CAS ni uspel vrniti niti enega podatka.';
$string['stackCas_failedValidation'] = 'CASText ni bil potrjen.';
$string['stackCas_finalChar'] = '\'{$a->char}\' je neveljaven "končni" znak v {$a->cmd}';
$string['stackCas_forbiddenChar'] = 'Ukazi CAS ne smejo vsebovati naslednjih znakov: {$a->char}.';
$string['stackCas_forbiddenWord'] = 'Izraz {$a->forbid} je prepovedan.';
$string['stackCas_inputsdefined'] = 'Vhodnih imen ne smete uporabljati kot spremenljivke. Ste poskusili določiti <code>{$a}</code>';
$string['stackCas_invalidCommand'] = 'Ukazi CAS niso veljavni.';
$string['stackCas_missingLeftBracket'] = 'Manjka vam levi oklepaj <span class="stacksyntaxexample">{$a->bracket}</span>v izrazu: {$a->cmd}.';
$string['stackCas_missingRightBracket'] = 'Manjka vam desni oklepaj <span class = "stacksyntaxexample"> {$a->bracket} </span> v izrazu: {$a->cmd}.';
$string['stackCas_newline'] = 'Znaki za novo vrstico niso dovoljeni v odgovorih.';
$string['stackCas_percent'] = 'znak % se nahaja v izrazu {$a->expr}.';
$string['stackCas_spaces'] = 'V izrazu je zaslediti neveljavne presledke {$a->expr}.';
$string['stackCas_spuriousop'] = 'Neznani operator: {$a->cmd}.';
$string['stackCas_trigexp'] = 'Potence trigonometrične funkcije ne smete zapisati kot {$a->forbid}. Kvadrat funkcije \\(\\sin(x)\\) se zapiše kot \\(\\sin(x)^2\\).  Inverz funkcije \\(\\sin(x)\\) pa kot <tt>asin(x)</tt> in ne \\(\\sin^{-1}(x)\\) .';
$string['stackCas_triginv'] = 'Inverzne trigonometrične (trig) funkcije so zapisane kot {$a->goodinv} in ne {$a->badinv}.';
$string['stackCas_trigop'] = 'Za argument morate uporabiti {$a->trig}. Zdi se, da imate {$a->forbid}, od koder je razvidno, da ste poskušali uporabiti {$a->trig} kot ime spremenljivke.';
$string['stackCas_trigparens'] = 'Ko za argumente uporabite trig funkcijo, morate uporabiti okrogle oklepaje in ne kvadratnih. Npr. {$a->forbid}.';
$string['stackCas_trigspace'] = 'Če želite uporabiti trig funkcijo za svoje argumente, morate uporabiti oklepaje in ne presledke. Na primer, namesto tega uporabite {$a->trig}.';
$string['stackCas_underscores'] = 'Naslednja uporaba podčrtanih znakov ni dovoljena: {$a}.';
$string['stackCas_unencpsulated_comma'] = 'Vejica se v vašem izrazu pojavi na nepravilen način. Vejice se uporabljajo za ločevanje elementov v seznamih, nizih itd. Pri decimalnem zapisu števil morate uporabiti decimalno piko in ne vejice.';
$string['stackCas_unitssynonym'] = 'Zdi se, da imate naslednje enote {$a->forbid}. Ste mislili {$a->unit}?';
$string['stackCas_unknownFunction'] = 'Neznana funkcija: {$a->forbid}.';
$string['stackCas_unknownFunctionCase'] = 'Pri vnosu morate paziti na velike in male črke:  {$a->forbid} je neveljaven funkcijski zapis.  Ste imeli v mislih {$a->lower}?';
$string['stackCas_unknownUnitsCase'] = 'Pri vnosu morate paziti na velike in male črke:  {$a->forbid} je neveljaven zapis enote.  Ste imeli v mislih katero enoto iz naslednjega seznama {$a->unit}?';
$string['stackDoc_404'] = 'Napaka 404';
$string['stackDoc_404message'] = 'Datoteke ni mogoče najti.';
$string['stackDoc_directoryStructure'] = 'Struktura imenika (direktorija)';
$string['stackDoc_docs'] = 'Dokumentacija STACK';
$string['stackDoc_docs_desc'] = '<a href="{$a->link}"> Dokumentacija za STACK </a>: lokalni statični wiki.';
$string['stackDoc_home'] = 'Dokumentacija (home)';
$string['stackDoc_index'] = 'Indeks kategorije';
$string['stackDoc_siteMap'] = 'Načrt strani';
$string['stackDoc_version'] = 'Vaše spletno mesto se izvaja v STACK različici {$a}.';
$string['stackHintOld'] = 'CASText ima oznake z namigi v starem slogu. Te morajo biti zdaj v obliki <pre> [[facts: tag]] </pre>';
$string['stackInstall_input_intro'] = 'Ta stran vam omogoča, da preizkusite, kako STACK interpretira različne vnose udeleženca. Trenutno preverja z osnovnimi nastavitvami in poskuša sprejeti neformalno skladnjo in vstaviti zvezdice (simbole). <br /> Stolpci \'V\' beležijo veljavnost, kot jo ocenjujeta PHP in CAS. V1 = veljavno PHP, V2 = veljavno CAS.';
$string['stackInstall_input_title'] = 'Testna zbirka za potrjevanje pravilnega vnosa udeleženca';
$string['stackInstall_input_title_desc'] = '<a href="{$a->link}">Skripta vnešenih testov</a> ponuja testne primere z obrazložitvijo, kako STACK interpretira matematične izraze. Koristni so tudi za učenje s primerom.';
$string['stackInstall_replace_dollars_desc'] = '<a href="{$a->link}">Skripta za popravljanje matematičnega zapisa</a> se lahko uporablja za nadomestitev starih matematičnih zapisov, kot je <code>@...@</code>, <code>$...$</code> in <code>$$...$$</code> v vaših vprašanjih z novimi priporočenimi <code>{@...@}</code>, <code>\\(...\\)</code> in <code>\\[...\\]</code>.';
$string['stackInstall_testsuite_choose'] = 'Prosimo, izberite test odgovora.';
$string['stackInstall_testsuite_errors'] = 'To vprašanje je povzročilo naslednje napake med izvajanjem.';
$string['stackInstall_testsuite_fail'] = 'Vsi testi niso bili uspešno izvedeni!';
$string['stackInstall_testsuite_failingtests'] = 'Testi, ki niso bili uspešno izvedeni';
$string['stackInstall_testsuite_failingupgrades'] = 'Vprašanja, ki pri nadgradnji niso uspela.';
$string['stackInstall_testsuite_intro'] = 'Ta stran vam omogoča, da preverite, ali STACK testi odgovorov delujejo pravilno. Upoštevajte, da je le preko spletnega vmesnika mogoč test odgovorov. Druge Maxima ukaze je treba preveriti iz ukazne vrstice: glejte unittests.mac.';
$string['stackInstall_testsuite_nogeneralfeedback'] = 'Vprašanja brez splošnih povratnih informacij: študenti resnično cenijo delujoče rešitve!';
$string['stackInstall_testsuite_notests'] = 'Vprašanja brez testnih odgovorov: dodajte jih nekaj!';
$string['stackInstall_testsuite_pass'] = 'Vsi testi so bili uspešno izvedeni.';
$string['stackInstall_testsuite_title'] = 'Zbirka STACK testov odgovorov';
$string['stackInstall_testsuite_title_desc'] = 'Povezava <a href="{$a->link}">do skripte za teste odgovorov</a> preverja, ali testi odgovorov delujejo pravilno. Povezave so koristne tudi zato, da se preko njih in primerov naučite, kako je mogoče uporabiti teste.';
$string['stackOptions_AnsTest_values_AlgEquiv'] = 'AlgEquiv';
$string['stackOptions_AnsTest_values_AlgEquivNouns'] = 'AlgEquivNouns';
$string['stackOptions_AnsTest_values_CasEqual'] = 'CasEqual';
$string['stackOptions_AnsTest_values_CompSquare'] = 'CompletedSquare';
$string['stackOptions_AnsTest_values_Diff'] = 'Diff';
$string['stackOptions_AnsTest_values_EqualComAss'] = 'EqualComAss';
$string['stackOptions_AnsTest_values_Equiv'] = 'EquivReasoning';
$string['stackOptions_AnsTest_values_EquivFirst'] = 'EquivFirst';
$string['stackOptions_AnsTest_values_Expanded'] = 'Expanded';
$string['stackOptions_AnsTest_values_FacForm'] = 'FacForm';
$string['stackOptions_AnsTest_values_GT'] = 'Num-GT';
$string['stackOptions_AnsTest_values_GTE'] = 'Num-GTE';
$string['stackOptions_AnsTest_values_Int'] = 'Int';
$string['stackOptions_AnsTest_values_LowestTerms'] = 'LowestTerms';
$string['stackOptions_AnsTest_values_NumAbsolute'] = 'NumAbsolute';
$string['stackOptions_AnsTest_values_NumDecPlaces'] = 'NumDecPlaces';
$string['stackOptions_AnsTest_values_NumDecPlacesWrong'] = 'NumDecPlacesWrong';
$string['stackOptions_AnsTest_values_NumRelative'] = 'NumRelative';
$string['stackOptions_AnsTest_values_NumSigFigs'] = 'NumSigFigs';
$string['stackOptions_AnsTest_values_PartFrac'] = 'PartFrac';
$string['stackOptions_AnsTest_values_PropLogic'] = 'PropositionalLogic';
$string['stackOptions_AnsTest_values_SRegExp'] = 'SRegExp';
$string['stackOptions_AnsTest_values_SameType'] = 'SameType';
$string['stackOptions_AnsTest_values_Sets'] = 'Sets';
$string['stackOptions_AnsTest_values_SigFigsStrict'] = 'SigFigsStrict';
$string['stackOptions_AnsTest_values_SingleFrac'] = 'SingleFrac';
$string['stackOptions_AnsTest_values_String'] = 'String';
$string['stackOptions_AnsTest_values_StringSloppy'] = 'StringSloppy';
$string['stackOptions_AnsTest_values_SubstEquiv'] = 'SubstEquiv';
$string['stackOptions_AnsTest_values_SysEquiv'] = 'SysEquiv';
$string['stackOptions_AnsTest_values_UnitsAbsolute'] = 'UnitsAbsolute';
$string['stackOptions_AnsTest_values_UnitsRelative'] = 'UnitsRelative';
$string['stackOptions_AnsTest_values_UnitsSigFigs'] = 'UnitsSigFigs';
$string['stackOptions_AnsTest_values_UnitsStrictAbsolute'] = 'UnitsStrictAbsolute';
$string['stackOptions_AnsTest_values_UnitsStrictRelative'] = 'UnitsStrictRelative';
$string['stackOptions_AnsTest_values_UnitsStrictSigFigs'] = 'UnitsStrictSigFigs';
$string['stackQuestion_noQuestionParts'] = 'Ta postavka ne vsebuje vprašanj, na katere bi lahko odgovorili.';
$string['stackversionedited'] = 'To vprašanje je bilo napisano v različici STACK {$a}.';
$string['stackversionerror'] = 'To vprašanje uporablja {$a->pat} v {$a->qfield}, ki se je spremenil v STACK različici {$a->ver} in ni več podprt.';
$string['stackversionerroralt'] = 'Druga možnost oz. alternativa je {$a}.';
$string['stackversionmulerror'] = 'Vaše vprašanje uporablja možnost (opcijo) "mul", ki po STACK različici 4.2 ni več podprta. Prosimo, uredite to vprašanje.';
$string['stackversionnone'] = 'To vprašanje ni bilo urejeno odkar je bilo vpeljano oštevilčenje vprašanj v različici STACK 4.2. Pozorno preglejte svoje vprašanje.';
$string['stackversionnow'] = 'Trenutna različica STACK je {$a}.';
$string['stackversionregexp'] = 'Test odgovora RegExp ni več podprt po STACK različici 4.3. Prosimo, uporabite novejši test SRegExp.';
$string['stop'] = '[stop]';
$string['strictsyntax'] = 'Stroga sintaksa';
$string['strictsyntax_help'] = 'Ali je potrebno vnos zapisati s strogo Maxima sintakso? Če ne, to povečuje nabor vzorcev, ki kažejo na manjkajoče * pri vnosu, vključno s katero koli aplikacijo funkcije in znanstvenim zapisom.';
$string['strictsyntax_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/';
$string['strlengtherror'] = 'Ta niz ne sme biti daljši od 255 znakov.';
$string['studentValidation_invalidAnswer'] = 'Ta odgovor je neveljaven.';
$string['studentValidation_listofunits'] = 'Enote, najdene v vašem odgovoru, so bile: {$a}';
$string['studentValidation_listofvariables'] = 'Spremenljivke, najdene v vašem odgovoru, so bile: {$a}';
$string['studentValidation_notes'] = 'STACK tega vnosa ne preveri/oceni samodejno. Lahko ga uporabite za beleženje vašega dela ali kot komentarje za učitelja.';
$string['studentValidation_yourLastAnswer'] = 'Vaš zadnji odgovor je bil interpretiran kot: {$a}';
$string['studentanswer'] = 'Odgovor udeleženca';
$string['switchtovariant'] = 'Preklopite na poljubno/željeno različico';
$string['syntaxattribute'] = 'Namig za atribut';
$string['syntaxattribute_help'] = 'Namig za skladnjo bo prikazan kot *vrednost*, ki jo lahko urejate, ali že vnaprej *rezervirano mesto*, ki pa ni namenjeno urejanju.';
$string['syntaxattribute_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md#Syntax_Hint';
$string['syntaxattributeplaceholder'] = 'Mesto rezervirano za';
$string['syntaxattributevalue'] = 'Vrednost';
$string['syntaxhint'] = 'Namig za sintakso';
$string['syntaxhint_help'] = 'Namig za skladnjo (sintakso) se bo v okencu za odgovore pojavil vsakič, ko bo udeleženec le-tega pustil praznega.';
$string['syntaxhint_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md#Syntax_Hint';
$string['tans'] = 'TAns';
$string['tans_help'] = 'To je drugi argument k funkciji testa odgovora. Pri asimetričnih testih to velja za "odgovor učitelja", čeprav je lahko kateri koli veljaven izraz CAS in je lahko odvisen od spremenljivk vprašanj ali spremenljivk povratnih informacij.';
$string['tans_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Answer_Tests/index.md';
$string['tansrequired'] = 'TAns ne sme ostati prazen';
$string['teacheranswer'] = 'Odgovor učitelja';
$string['teacheranswerempty'] = 'Ta vnos lahko ostane prazen.';
$string['teacheranswershow'] = 'Pravilni odgovor je \\( {$a->display} \\), ki ga lahko vnesete na naslednji način: {$a->value}';
$string['teacheranswershow_disp'] = 'Pravilen odgovor je {$a->display}.';
$string['teacheranswershow_mcq'] = 'Pravilen odgovor je {$a->display}';
$string['teacheranswershownotes'] = 'Pravilen odgovor ni podan za ta vnos.';
$string['teachersanswer'] = 'Vzorčni odgovor';
$string['teachersanswer_help'] = 'Za vsak vnos mora učitelj določiti/specificirati obliko odgovora. To mora biti veljaven Maxima niz in je lahko oblikovan iz samih spremenljivk vprašanja.';
$string['teachersanswer_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Inputs.md#model_answer';
$string['testcasexresult'] = 'Testni primer {$a->no} {$a->result}';
$string['testingquestion'] = 'Testiranje vprašanja {$a}';
$string['testingquestionvariants'] = 'Pripravljanje različic vprašanja';
$string['testinputs'] = 'Testni vnosi';
$string['testinputsimpwarning'] = 'Upoštevajte, da so testni vhodi vedno <em>nepoenostavljeni</em> ne glede na vprašanje ali nastavitev možnosti PRT. Uporabite <tt>ev(...,simp)</tt> za poenostavitev dela ali vseh vhodnih izrazov.';
$string['testoptions'] = 'Testne možnosti';
$string['testoptions_help'] = 'To vnosno polje omogoča, da odgovorimo z vnoson npr. spremenljivke ali numerične vrednosti.';
$string['testoptions_link'] = '%%WWWROOT%%/question/type/stack/doc/doc.php/Authoring/Potential_response_trees.md';
$string['testoptionsinvalid'] = 'Testne možnosti so nepravilne: {$a}';
$string['testoptionsrequired'] = 'Za ta test je treba izpolniti testne možnosti.';
$string['testpassesandfails'] = '{$a->passes} (uspešne) izvedbe in {$a->fails} (neuspešne) izvedbe.';
$string['testsuitecolerror'] = 'CAS napake';
$string['testsuitecolpassed'] = 'Opravil?';
$string['testsuitefail'] = 'Neuspešno';
$string['testsuitefeedback'] = 'Povratne informacije';
$string['testsuiteknownfail'] = 'Pričakovana napaka';
$string['testsuiteknownfailmaths'] = 'Pričakovana napaka (matematična)';
$string['testsuitenotests'] = 'Število testov: {$a->no}.';
$string['testsuitepass'] = '';
$string['testsuiteteststook'] = 'Testi so trajali {$a->time} sekund.';
$string['testsuiteteststookeach'] = 'Povprečno na test: {$a->time} sekund.';
$string['testthisvariant'] = 'Preklopite, da preizkusite to različico';
$string['texdisplaystyle'] = 'Videz prikaza enačb';
$string['texinlinestyle'] = 'Inline (v vrstici)';
$string['tidyquestion'] = 'Urejeno (uredite) vprašanje';
$string['tidyquestionx'] = 'Preimenujte dele vprašanja {$a}';
$string['trig_degrees_radians_fact'] = '\\[
360^\\circ= 2\\pi \\hbox{ radianov},\\quad
1^\\circ={2\\pi\\over 360}={\\pi\\over 180}\\hbox{ radianov}
\\]
\\[
1 \\hbox{ radian} = {180\\over \\pi} \\hbox{ stopinj}
\\approx 57.3^\\circ
\\]';
$string['trig_degrees_radians_name'] = 'Stopinje in radiani';
$string['trig_standard_identities_fact'] = '\\[\\sin(a\\pm b)\\ = \\  \\sin(a)\\cos(b)\\ \\pm\\  \\cos(a)\\sin(b)\\]
 \\[\\cos(a\\ \\pm\\ b)\\ = \\  \\cos(a)\\cos(b)\\ \\mp \\sin(a)\\sin(b)\\]
 \\[\\tan (a\\ \\pm\\ b)\\ = \\  {\\tan (a)\\ \\pm\\ \\tan (b)\\over1\\ \\mp\\ \\tan (a)\\tan (b)}\\]
 \\[ 2\\sin(a)\\cos(b)\\ = \\  \\sin(a+b)\\ +\\ \\sin(a-b)\\]
 \\[ 2\\cos(a)\\cos(b)\\ = \\  \\cos(a-b)\\ +\\ \\cos(a+b)\\]
 \\[ 2\\sin(a)\\sin(b) \\ = \\  \\cos(a-b)\\ -\\ \\cos(a+b)\\]
 \\[ \\sin^2(a)+\\cos^2(a)\\ = \\  1\\]
 \\[ 1+{\\rm cot}^2(a)\\ = \\  {\\rm cosec}^2(a),\\quad \\tan^2(a) +1 \\ = \\  \\sec^2(a)\\]
 \\[ \\cos(2a)\\ = \\  \\cos^2(a)-\\sin^2(a)\\ = \\  2\\cos^2(a)-1\\ = \\  1-2\\sin^2(a)\\]
 \\[ \\sin(2a)\\ = \\  2\\sin(a)\\cos(a)\\]
 \\[ \\sin^2(a) \\ = \\  {1-\\cos (2a)\\over 2}, \\qquad \\cos^2(a)\\ = \\  {1+\\cos(2a)\\over 2}\\]';
$string['trig_standard_identities_name'] = 'Standardne trigonometrične enakosti';
$string['trig_standard_values_fact'] = '\\[\\sin(45^\\circ)={1\\over \\sqrt{2}}, \\qquad \\cos(45^\\circ) = {1\\over \\sqrt{2}},\\qquad
\\tan( 45^\\circ)=1
\\]
\\[
\\sin (30^\\circ)={1\\over 2}, \\qquad \\cos (30^\\circ)={\\sqrt{3}\\over 2},\\qquad
\\tan (30^\\circ)={1\\over \\sqrt{3}}
\\]
\\[
\\sin (60^\\circ)={\\sqrt{3}\\over 2}, \\qquad \\cos (60^\\circ)={1\\over 2},\\qquad
\\tan (60^\\circ)={ \\sqrt{3}}
\\]';
$string['trig_standard_values_name'] = 'Standardne trigonometrične vrednosti';
$string['true'] = 'Drži';
$string['truebranch'] = 'True branch';
$string['truebranch_help'] = 'Ta polja nadzirajo, kaj se zgodi, ko je test odgovora uspešno izveden.
### Mod in Rezultat
Kako se prilagodijo rezultati. = pomeni, da rezultat postavimo na določeno vrednost, +/- pomeni, da dodamo ali odštejemo dano oceno od trenutne vrednosti.

### Penalty (Odbitek)
V prilagodljivem ali interaktivnem načinu pridobite toliko kazenskih točk.

### Next (Naslednji)
Pojdite na drugo vozlišče in če je tako, na katero ali pa izvajanje ustavite.

### Answer note (Odgovor)
To je oznaka, ki je ključna za namene poročanja. Zasnovana je tako, da beleži edinstveno pot skozi drevesno strukturo in rezultat vsake preverbe odgovora. To se samodejno generira.';
$string['undeploy'] = 'Un-deploy (neuporabiti)';
$string['unrecognisedfactstags'] = 'Naslednje oznake niso prepoznane: {$a->tags}.';
$string['variant'] = 'Varianta (različica)';
$string['variantsselectionseed'] = 'Naključna skupina';
$string['variantsselectionseed_help'] = 'Običajno lahko to polje pustite prazno. Če pa želite, da v kvizu uporabite dve različni vprašanji, katerima pripada isto seme (seed, odgovor!), potem v to polje za obe vprašanji vnesite isti niz (in uporabite enak niz naključnih semen, če uporabljate razporejene različice). Naključna odgovora (semena) za obe vprašanji se bosta sinhronizirala.';
$string['verifyquestionandupdate'] = 'Preverite besedilo vprašanja in posodobite stran.';
$string['youmustconfirm'] = 'Potrdite tukaj.';
