<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'tool_brickfield', language 'sl', version '4.5'.
 *
 * @package     tool_brickfield
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessibility'] = 'Dostopnost';
$string['accessibilitydisabled'] = 'Orodje za dostopnost Brickfield na tem spletišču ni omogočeno. Obrnite se na skrbnika spletišča za omogočitev.';
$string['accessibilityreport'] = 'Komplet orodij za dostopnost';
$string['accessibilitytool'] = 'Orodje za dostopnost Brickfield';
$string['accessibilitytools'] = 'Orodja za dostopnost Brickfield';
$string['activate'] = 'Omogoči';
$string['activated'] = 'Vtičnik je omogočen in pripravljen za uporabo.';
$string['activationform'] = 'Registracija Brickfield';
$string['activationheader'] = 'Aktivacija Brickfield';
$string['activationinfo'] = '<p>Za uporabo tega vtičnika morate v tem obrazcu navesti veljavne ključe za to spletišče.</p>
<p>Če ključev še nimate, se prosimo <a href="{$a}" data-action="send_info" target="_blank">registrirajte na portalu Brickfield (odpre se v novem oknu)</a>, da jih pridobite.</p>
<p>Ko bo vtičnik aktiviran, bodo ključi preverjeni prek načrtovanih opravil (cron).</p>';
$string['activityresults:pluginname'] = 'Poročilo o dostopnosti po dejavnostih';
$string['activityresults:toolname'] = 'Povzetek razčlenitve dejavnosti';
$string['activityresults:toolshortname'] = 'Razčlenitev dejavnosti';
$string['advanced:pluginname'] = 'Napredno poročilo orodja za dostopnost';
$string['advanced:toolname'] = 'Napredni povzetek';
$string['advanced:toolshortname'] = 'Napredno';
$string['allcourses'] = 'Vsi pregledani predmeti ({$a})';
$string['allcoursescat'] = 'Vsi pregledani predmeti v kategoriji {$a->catname} ({$a->count})';
$string['analysis:byrequest'] = 'Na zahtevo';
$string['analysis:disabled'] = 'Onemogočeno';
$string['analysistype'] = 'Omogoči zahteve za analizo';
$string['analysistype_desc'] = 'Dovoli pošiljanje zahtev za analizo dostopnosti vsebine';
$string['analysistypedisabled'] = 'Analiza vsebine je onemogočena';
$string['bannercontentone'] = 'Komplet orodij za dostopnost Enterprise  vključuje celoten nabor funkcij, s katerimi lahko vaša organizacija izboljša dostopnost svojih predmetov. <a href="{$a}">Kontaktirajte Brickfield Education Labs</a> za brezplačen ogled naprednih funkcij.';
$string['bannercontenttwo'] = 'Ustvarite učinkovito in vključujočo platformo za poučevanje in učenje tako, da poiščete vsebine, ki ne ustrezajo smernicam, odpravite težave in dolgoročno poskrbite za dostopnost svojih Moodle predmetov z dostopnimi datotekami, urejevalnikom in naprednimi funkcijami.';
$string['bannerheadingone'] = 'Nadgradite na komplet orodij za dostopnost Enterprise';
$string['batch'] = 'Omejitev serije';
$string['brickfield'] = 'Komplet orodij Brickfield';
$string['brickfield:viewcoursetools'] = 'Ogled poročil po predmetih';
$string['brickfield:viewsystemtools'] = 'Ogled poročil za vse predmete';
$string['bulkprocesscaches'] = 'Obdelava serijskega predpomnjenja';
$string['bulkprocesscourses'] = 'Serijska obdelava preverjanja dostopnosti predmetov';
$string['buttonone'] = 'Pridobi brezplačen vzorčni ogled';
$string['cachepending'] = 'Povzetek podatkov se pripravlja';
$string['checkdesc:alinksdontopennewwindow'] = 'Povezave, ki se odprejo v novem oknu, morajo uporabnike o tem vnaprej opozoriti.';
$string['checkdesc:amustcontaintext'] = 'Povezava mora vsebovati besedilo, da jo je mogoče zaznati.';
$string['checkdesc:areadontopennewwindow'] = 'Območja, uporabljena v slikovnih zemljevidih, ki se odprejo v novem oknu, morajo uporabnike na to vnaprej opozoriti.';
$string['checkdesc:areahasaltvalue'] = 'Območja v slikovnih zemljevidih ne smejo biti brez nadomestnega besedila (alt), podobno kot slike.';
$string['checkdesc:asuspiciouslinktext'] = 'Besedilo povezave mora biti opisno in priskrbeti kontekst njene destinacije';
$string['checkdesc:basefontisnotused'] = 'Elementi Basefont, (ki so bili tradicionalno uporabljeni za oblikovanje) niso dostopni in se ne smejo uporabljati.';
$string['checkdesc:blinkisnotused'] = 'Elementi, ki povzročajo utripanje vsebine, niso dostopni in se ne smejo uporabljati.';
$string['checkdesc:boldisnotused'] = 'Uporaba krepkega besedila (b) ni priporočljiva; namesto njih je treba uporabiti "strong".';
$string['checkdesc:contenttoolong'] = 'Vsebina strani naj ne presega 500 besed.';
$string['checkdesc:csstexthascontrast'] = 'Barvni kontrast med besedilom in ozadjem je prenizek.';
$string['checkdesc:embedhasassociatednoembed'] = 'Elementom embed (za vdelavo multimedijskih vsebin) ne sme manjkati ustrezen element "noembed".';
$string['checkdesc:headerh3'] = 'Naslovi, ki sledijo naslovom H3 (veliki naslov v urejevalniku), ne smejo porušiti hierarhije naslovov na strani.';
$string['checkdesc:headershavetext'] = 'Naslov mora vsebovati besedilo, da ga je mogoče zaznati.';
$string['checkdesc:iisnotused'] = 'Elementov italic (i) ne smemo uporabljati; namesto njih je treba uporabiti "em".';
$string['checkdesc:imgaltisdifferent'] = 'Nadomestno besedilo slike (alt) ne sme biti ime slikovne datoteke.';
$string['checkdesc:imgaltistoolong'] = 'Poskrbite, da je nadomestno besedilo slike (alt) dovolj jedrnato za opis slike.';
$string['checkdesc:imgaltnotemptyinanchor'] = 'Nadomestno besedilo slike (alt) ne sme biti prazno, zlasti če je slika povezava na drugo mesto.';
$string['checkdesc:imgaltnotplaceholder'] = 'Nadomestno besedilo slike (alt) ne sme biti splošno nadomestno besedilo, kot na primer "slika".';
$string['checkdesc:imghasalt'] = 'Slike ne smejo biti brez nadomestnega besedila (alt), razen če so zgolj dekorativne in brez pomena.';
$string['checkdesc:imgwithmaphasusemap'] = 'Slikovni zemljevidi s klikljivimi območji potrebujejo ujemajoče elemente "usemap" in "map".';
$string['checkdesc:legendtextnotempty'] = 'Elementi legend, ki označujejo skupine polj (fieldset), morajo vsebovati besedilo.';
$string['checkdesc:marqueeisnotused'] = 'Elementi marquee (samodejno pomikajoče se besedilo) niso dostopni in se ne smejo uporabljati.';
$string['checkdesc:noheadings'] = 'Odsotnost naslovov zmanjša strukturo vsebine in oteži branje.';
$string['checkdesc:objectmusthaveembed'] = 'Elementi object (za vdelavo zunanjih virov) morajo imeti ustrezne elemente "embed".';
$string['checkdesc:objectmusthavetitle'] = 'Elementi object ne smejo biti brez ustreznega opisa v atributu "title".';
$string['checkdesc:objectmusthavevalidtitle'] = 'Elementi object morajo imeti veljaven atribut "title" z besedilom.';
$string['checkdesc:strikeisnotused'] = 'Elementi strike (prečrtano) se ne smejo uporabljati; namesto njih uporabite "del" (izbrisano).';
$string['checkdesc:tabledatashouldhaveth'] = 'Tabele naj ne bi bile brez naslovnih celic.';
$string['checkdesc:tablesummarydoesnotduplicatecaption'] = 'Povzetki tabel in napisi (captions) ne smejo biti enaki.';
$string['checkdesc:tabletdshouldnotmerge'] = 'Tabele naj ne bi vsebovale združenih celic.';
$string['checkdesc:tablethshouldhavescope'] = 'Glave vrstic ali stolpcev v tabelah morajo imeti naveden atribut področja (scope).';
$string['checkidvalidation'] = 'Opravilo za preverjanje neveljavnih identifikatorjev preverjanja (checkid)';
$string['checkscompleted'] = 'Preverjanja zaključena: {$a}';
$string['checktype'] = 'Skupina preverjanj';
$string['checktype:form'] = 'Obrazec';
$string['checktype:image'] = 'Slika';
$string['checktype:layout'] = 'Postavitev';
$string['checktype:link'] = 'Povezava';
$string['checktype:media'] = 'Medijska vsebina';
$string['checktype:table'] = 'Tabela';
$string['checktype:text'] = 'Besedilo';
$string['checktyperesults:pluginname'] = 'Poročilo orodja za dostopnost po vrstah vsebin';
$string['checktyperesults:toolname'] = 'Povzetek po vrstah vsebin';
$string['checktyperesults:toolshortname'] = 'Vrste vsebin';
$string['cmpercent'] = 'Skupni odstotek dejavnosti';
$string['cmpercenterrors'] = 'Skupni odstotek napak';
$string['cmpercenttitle'] = 'Celotna odstotna primerjava dejavnosti in napak';
$string['confirmationmessage'] = 'Ta predmet je načrtovan za analizo. Analiza bo predvidoma zaključena do {$a}. Preverite znova po tem datumu.';
$string['contactadmin'] = 'Za dokončanje registracije se obrnite na skrbnika.';
$string['contactus'] = 'Kontaktirajte nas';
$string['contentfive'] = 'Samodejno popravite zastarele oznake HTML.';
$string['contentfour'] = 'Ugotovite, katere dejavnosti imajo največ težav z dostopnostjo, da ustrezno določite prednostno obravnavo.';
$string['contentone'] = 'Samodejno ocenite vsebino predmeta in ocenjevanja glede težav z dostopnostjo.';
$string['contentsix'] = 'Učiteljem ponudite sprotne nasvete za ustvarjanje boljše vsebine.';
$string['contentthree'] = 'Študentom zagotovite vsebine v dostopnih formatih, kot so zvok, ePub in Electronic Braille.';
$string['contenttwo'] = 'Hkratno posodobite nejasno ali manjkajoče besedilo povezav, opise slik in podnapise videoposnetkov.';
$string['contenttypeerrors'] = 'Skupni rezultati preverjanja vsebine po predmetih in vrstah vsebin.';
$string['contentyperesults'] = 'Skupno število uspešno/neuspešno opravljenih preverjanj po predmetih in področjih vsebine.';
$string['contextid'] = 'ID konteksta';
$string['core_course'] = 'Predmet';
$string['core_question'] = 'Zbirke vprašanj';
$string['count'] = 'Število';
$string['country'] = 'Država';
$string['country_help'] = 'Država spletišča';
$string['coursecount'] = 'Število predmetov';
$string['deletehistoricaldata'] = 'Izbriši zgodovinske rezultate preverjanj';
$string['dependency'] = 'Odvisno od';
$string['emptycategory'] = 'V kategoriji {$a} ni najdenih predmetov';
$string['emptytagcourses'] = 'Ni najdenih predmetov s konfiguriranimi oznakami';
$string['enableaccessibilitytools'] = 'Omogoči orodja za dostopnost';
$string['enableaccessibilitytools_desc'] = 'Komplet orodij za dostopnost pomaga prepoznati težave z dostopnostjo v predmetih.';
$string['error:nocoursespecified'] = 'Povzetek poročila zahteva veljaven ID predmeta. Dostopajte do orodja za dostopnost znotraj predmeta.';
$string['errorlink'] = 'Uredi primer napake za {$a}';
$string['errors'] = 'Napake: {$a}';
$string['errors:pluginname'] = 'Orodje za seznam napak glede dostopnosti';
$string['errors:toolname'] = 'Povzetek seznama napak';
$string['errors:toolshortname'] = 'Seznam napak';
$string['eventanalysis_requested'] = 'Zahtevana analiza vsebine';
$string['eventanalysis_requesteddesc'] = 'Za predmet {$a} je bila zahtevana analiza vsebine.';
$string['eventreport_downloaded'] = 'Povzetek dostopnosti prenesen';
$string['eventreport_downloadeddesc'] = 'Povzetek dostopnosti je bil prenesen za ID predmeta {$a}.';
$string['eventreport_viewed'] = 'Ogledano poročilo o dostopnosti';
$string['eventreport_vieweddesc'] = 'Ogledano je bilo poročilo o dostopnosti za ID predmeta {$a->course}, ID kategorije {$a->category}, zavihek {$a->tab}.';
$string['failed'] = 'Neuspešno';
$string['failedcount'] = 'Neuspešno: {$a}';
$string['footerheading'] = 'Noga strani';
$string['fullcachedone'] = 'Onemogočite za ponovno izvedbo predpomnjenja';
$string['hashcorrect'] = 'Vnesena koda je pravilna.';
$string['hashincorrect'] = 'Vnesena koda ni pravilna.';
$string['headingfive'] = 'Popravki HTML';
$string['headingfour'] = 'Usmerjanje napora';
$string['headingone'] = 'Ocenjevanje vsebine';
$string['headingsix'] = 'Podpora za učinkovitost';
$string['headingthree'] = 'Dostopni formati datotek';
$string['headingtwo'] = 'Odprava napak';
$string['hideshow'] = 'Skrij/prikaži';
$string['icon:analytics-custom'] = 'Ikona za analitiko';
$string['icon:file-edit-custom'] = 'Ikona za urejanje datoteke';
$string['icon:hands-helping-custom'] = 'Ikona za pomoč';
$string['icon:search-plus-custom'] = 'Ikona za iskanje';
$string['icon:tools-custom'] = 'Ikona za orodja';
$string['icon:wand-magic-custom'] = 'Ikona čarobne paličice';
$string['inactive'] = 'Vtičnik ni aktiven in ga ni mogoče uporabljati. Vnesite veljavne registracijske ključe in kliknite »Omogoči«.';
$string['innercontextid'] = 'ID notranjega konteksta';
$string['installed'] = 'Vtičnik nameščen';
$string['installedcli'] = 'Vtičnik nameščen prek ukazne vrstice';
$string['installeddescription'] = 'Vtičnik je bil nameščen, preusmeritev na obrazec za aktivacijo.';
$string['invalidaccessibilitytool'] = 'Zahtevan je neveljaven podvtičnik za dostopnost.';
$string['invalidcategoryid'] = 'Neveljavna kategorija, preverite vnos';
$string['invalidcourseid'] = 'Neveljaven predmet, preverite vnos';
$string['invalidlinkphrases'] = 'klikni|klikni tukaj|tukaj|več|več tukaj|info|info tukaj|informacije|informacije tukaj|preberi več|preberi več tukaj|dodatne informacije|dodatne informacije tukaj|dodatne podrobnosti|dodatne podrobnosti tukaj';
$string['language'] = 'Jezik';
$string['language_help'] = 'Jezik spletišča';
$string['messageprovider:warningcheckid'] = 'Opozorilo o neveljavnih identifikatorjih preverjanja';
$string['mobileservice'] = 'Mobilne storitve omogočene ({$a})';
$string['module'] = 'Modul';
$string['modulename'] = 'Ime';
$string['moreinfo'] = 'Več informacij';
$string['newwindowphrases'] = 'novo okno|novo-okno|novo_okno';
$string['noerrorsfound'] = 'Pri vaših iskalnih parametrih ni bilo najdenih pogostih napak glede dostopnosti. Čestitamo!';
$string['norecords'] = 'Za izbrane iskalne parametre ni bilo najdenih ustreznih zapisov.';
$string['notregistered'] = 'Komplet orodij za dostopnost mora biti registriran.';
$string['notvalidated'] = 'Komplet orodij za dostopnost deluje med preverjanjem veljavnosti.';
$string['numcourses'] = 'Število predmetov ({$a})';
$string['numfactivities'] = 'Število dejavnosti ({$a})';
$string['numfiles'] = 'Število datotek ({$a})';
$string['numinstances'] = 'Število primerov';
$string['numusers'] = 'Število uporabnikov ({$a})';
$string['pagedesc:checktype'] = '<p>Za povzetek in analizo rezultatov različnih preverjanj združujemo ta preverjanja v skupine po vrstah vsebine. Tako so vsi rezultati preverjanja dostopnosti slik v skupini "Slika", vsi, ki se nanašajo na postavitev, v skupini "Postavitev" in tako naprej.</p>
<p>Dejavnosti so vključene kot dejavnosti, viri ali vsebine, povezane s predmeti.</p>
<p>Stran z grafom po vrstah vsebine prikazuje razčlenitev napak po skupinah: Slika, Postavitev, Povezava, Mediji, Tabela in Besedilo.</p>';
$string['pagedesc:pertarget'] = '<p>Za povzetek in analizo rezultatov preverjanja po dejavnostih združimo te rezultate po zaznanih dejavnostih.</p>
<p>Dejavnosti vključujejo dejavnosti, vire ali druge vsebine, povezane s predmeti. Vsaka dejavnost brez zaznanih napak se šteje kot uspešna, vsaka z vsaj eno napako pa kot neuspešna. Nato se prikaže razmerje uspešnih in neuspešnih.</p>
<p>Stran z grafom razčlenitve po dejavnostih prikazuje to razmerje po vrstah dejavnosti, kot so naloge, predmeti, oznake ipd.</p>';
$string['pagedesctitle:checktype'] = 'Razlaga vrst vsebine';
$string['pagedesctitle:pertarget'] = 'Razlaga razčlenitve dejavnosti';
$string['passed'] = 'Uspešno';
$string['passedcount'] = 'Uspešno: {$a}';
$string['passrate'] = 'Uspešnost: {$a}%';
$string['pdf:filename'] = 'Brickfield_PovzetekPorocila_PredmetID-{$a}';
$string['percheckerrors'] = 'Število posameznih preverjanj in napak na preverjanje po predmetu.';
$string['perpage'] = 'Število elementov na stran';
$string['pluginname'] = 'Komplet orodij za dostopnost';
$string['printable:downloadpdf'] = 'Prenesi PDF';
$string['printable:pluginname'] = 'Povzetek poročilu o dostopnosti';
$string['printable:printreport'] = 'Poročilo za tiskanje';
$string['printable:toolname'] = 'Povzetek poročila';
$string['printable:toolshortname'] = 'Povzetek poročila';
$string['privacy:metadata'] = 'Vtičnik za poročanje o preverjanju dostopnosti ne shranjuje osebnih podatkov.';
$string['processanalysisrequests'] = 'Obdelaj zahteve za analizo vsebine';
$string['registernow'] = 'Prosimo, registrirajte se zdaj.';
$string['registration'] = 'Obrazec za registracijo';
$string['registrationinfo'] = '<p>Ta registracija vam omogoča uporabo začetne različice kompleta orodij za dostopnost Brickfield za registrirano Moodle spletišče.</p>
<p>Uporaba je pogojena s <a href="{$a}" target="_blank">pogoji uporabe Brickfield Education Labs (odpre se v novem oknu)</a>, s katerimi se strinjate z uporabo tega izdelka.</p>';
$string['release'] = 'Moodle različica ({$a})';
$string['remaining'] = '(Preostalih napak: {$a})';
$string['response:0'] = 'Ta URL ne vodi nikamor';
$string['response:404'] = 'Strani na tem URL-ju ni bilo mogoče najti';
$string['schedule:blocknotscheduled'] = '<p>Ta predmet še ni bil načrtovan za analizo zaradi iskanja pogostih težav z dostopnostjo.</p>';
$string['schedule:notscheduled'] = '<p>Ta predmet še ni bil načrtovan za analizo pogostih težav z dostopnostjo.</p><p>S klikom na gumb "Pošlji v analizo" potrjujete, da želite, da se vsa pomembna HTML vsebina predmeta (opis poglavij, dejavnosti, vprašanja, strani ipd.) analizira.</p><p>Analiza bo izvedena v ozadju s pomočjo načrtovanih opravil in rezultati bodo prikazani na straneh poročila o dostopnosti.</p><p>Analiza bo izvedla več pogostih preverjanj dostopnosti vaše HTML vsebine predmeta, rezultati pa bodo prikazani na straneh poročila kompleta orodij za dostopnost. Analiza bo potekala v ozadju prek načrtovanih opravil, zato bo hitrost zaključka odvisna od časa in pogostosti izvajanja teh opravil.</p>';
$string['schedule:requestanalysis'] = 'Pošlji v analizo';
$string['schedule:scheduled'] = 'Ta predmet je bil načrtovan za analizo.';
$string['schedule:sitenotscheduled'] = '<p>Globalna vsebina (neodvisna od predmetov) še ni bila načrtovana za analizo pogostih težav z dostopnostjo.</p><p>S klikom na gumb "Pošlji v analizo" potrjujete, da želite, da se vsa vaša pomembna globalna vsebina (neodvisna od predmetov) načrtuje za analizo.</p><p>Analiza bo izvedla več pogostih preverjanj dostopnosti te vsebine, rezultati pa bodo prikazani na straneh poročila kompleta orodij za dostopnost. Izvedena bo v ozadju prek načrtovanih opravil, zato bo hitrost zaključka odvisna od časa in razporeda izvajanja teh opravil.</p>';
$string['schedule:sitescheduled'] = 'Globalna (od predmetov neodvisna) vsebina je bila načrtovana za analizo.';
$string['secretkey'] = 'API ključ';
$string['secretkey_help'] = 'To kodo prejmete po e-pošti po registraciji.';
$string['sendfollowinginfo'] = '<p>Spodnje informacije bodo občasno poslane izključno za statistične namene. Ne bodo javno objavljene v nobenem osrednjem seznamu.</p> {$a}';
$string['settings'] = 'Nastavitve kompleta orodij za dostopnost';
$string['sitehash'] = 'Skrivni ključ';
$string['sitehash_help'] = 'To kodo prejmete po e-pošti po registraciji.';
$string['taberrors'] = 'Preveri napake';
$string['targetavetitle'] = 'Povprečno število napak na dejavnost';
$string['targetpercentage'] = 'Odstotek uspešnih/neuspešnih primerov po dejavnosti';
$string['targetratio'] = 'Razmerje uspešnosti dejavnosti';
$string['tblcheck'] = 'Preverjanje';
$string['tblcheckexample'] = 'Primer';
$string['tblcheckfailed'] = 'Neuspešna preverjanja';
$string['tblchecksummary'] = 'Neuspešna preverjanja';
$string['tbledit'] = 'Uredi';
$string['tblerrorcount'] = 'Napake';
$string['tblhtmlcode'] = 'Obstoječa HTML koda';
$string['tblinstance'] = 'Primer';
$string['tblline'] = 'Vrstica';
$string['tbloverallpercentage'] = 'Skupni delež napak %';
$string['tblpercentage'] = 'Odstotek';
$string['tblpreview'] = 'Predogled';
$string['tbltarget'] = 'Dejavnost';
$string['tblupdateto'] = 'Posodobi na';
$string['titleactivityresultsall'] = 'Rezultati po dejavnosti: vsi pregledani predmeti ({$a->count} predmetov)';
$string['titleactivityresultspartial'] = 'Rezultati po dejavnosti: predmet {$a->name}';
$string['titleall'] = 'Podrobnosti o napakah: vsi pregledani predmeti ({$a->count} predmetov)';
$string['titlechecktyperesultsall'] = 'Rezultati po vrsti vsebine: vsi pregledani predmeti ({$a->count} predmetov)';
$string['titlechecktyperesultspartial'] = 'Rezultati po vrsti vsebine: predmet {$a->name}';
$string['titleerrorsall'] = 'Podrobnosti o napakah: vsi pregledani predmeti ({$a->count} predmetov)';
$string['titleerrorscount'] = 'Podrobnosti o napakah: (prikazanih prvih {$a} napak)';
$string['titleerrorspartial'] = 'Podrobnosti o napakah: predmet {$a->name}';
$string['titlepartial'] = 'Podrobnosti o napakah: predmet {$a->name}';
$string['titleprintableall'] = 'Predmet {$a->name}';
$string['titleprintablepartial'] = 'Predmet {$a->name}';
$string['tools'] = 'Poročila';
$string['toperrors'] = 'Najpogostejše napake';
$string['toptargets'] = 'Neuspešne dejavnosti';
$string['totalactivities'] = 'Skupno število dejavnosti';
$string['totalactivitiescount'] = 'Skupno število dejavnosti: {$a}';
$string['totalareas'] = 'Skupno število področij';
$string['totalerrors'] = 'Skupno število napak';
$string['totalgrouperrors'] = 'Skupno število napak po vrsti vsebine';
$string['updatesummarydata'] = 'Posodobi povzetek spletišča';
$string['usersmobileregistered'] = 'Število uporabnikov z registriranimi mobilnimi napravami ({$a})';
$string['validationerror'] = 'Preverjanje registracijskega ključa ni uspelo. Preverite, ali sta URL vašega registriranega spletišča in ključi pravilni.';
$string['warningcheckidbody'] = 'Prišlo je do težave s preverjanjem Brickfield, ki je aktivno, vendar ni zapisano v podatkovni bazi. Prosimo, preverite.';
$string['warningcheckidsubject'] = 'Opozorilo orodja Brickfield: checkID';
