<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'grades', language 'no', version '4.5'.
 *
 * @package     grades
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activities'] = 'Aktiviteter';
$string['addcategory'] = 'Legg til kategori';
$string['addcategoryerror'] = 'Kunne ikke legge til kategorien.';
$string['addexceptionerror'] = 'Det oppstod en feil under når unntak skulle legges til for userid:gradeitem';
$string['addfeedback'] = 'Legg til tilbakemelding';
$string['addgradeletter'] = 'Legg til karakterbokstav';
$string['addidnumbers'] = 'Legg til idnummer';
$string['additem'] = 'Legg til karakterelement';
$string['additionalfeedback'] = 'Ekstra tilbakemelding';
$string['addoutcome'] = 'Legg til et læringsmål';
$string['addoutcomeitem'] = 'Legg til læringsmålelement';
$string['addscale'] = 'Legg til en skala';
$string['adjustedweight'] = 'Vektingsjustering';
$string['aggregateextracreditmean'] = 'Middelverdi for karakterer (med ekstra poeng)';
$string['aggregatemax'] = 'Høyeste karakter';
$string['aggregatemean'] = 'Middelverdi for karakterer';
$string['aggregatemedian'] = 'Median for karakterer';
$string['aggregatemin'] = 'Laveste karakter';
$string['aggregatemode'] = 'Mest gitte karakterer';
$string['aggregatenotonlygraded'] = 'Inkluder tomme karakterer';
$string['aggregateonlygraded'] = 'Ekskluder tomme karakterer';
$string['aggregateonlygraded_help'] = '<p>Tomme karakterfelter blir behandlet entens om laveste karakter eller utelatt fra sammenstillingen.</p>';
$string['aggregateoutcomes'] = 'Inkluder læringsmål i beregningen';
$string['aggregateoutcomes_help'] = '<p>Å ta med læringsmål i karakteroversikten leder ikke nødvendigvis til ønsket samlet karakter, så du har muligheten til å ta med læringsmål eller utelate dem.</p>';
$string['aggregatesonly'] = 'Vis kun totaler';
$string['aggregatesubcatsupgradedgrades'] = 'Merk:  Aggregeringsmetoden "Aggreger inkludert underkategorier" er fjernet fra portalen som en del av oppgraderingen. Siden "Aggreger inkludert underkategorier" tidligere er benyttet i dette kurset, anbefaler vi at du ser over endringen i karakterboka.';
$string['aggregatesum'] = 'Naturlig';
$string['aggregateweightedmean'] = 'Vektet middelverdi av karakterer';
$string['aggregateweightedmean2'] = 'Enkel vektet middelverdi av karakterer';
$string['aggregation'] = 'Karakterberegning';
$string['aggregation_help'] = '<p>Denne menyen lar deg velge hvilken beregningsmetode som skal brukes for å regne ut hver brukers samlede karakter for denne kategorien. De forskjellige valgene er beskrevet under.</p>

<p>Karakterene blir først konvertert til en prosentverdi (intervall fra 0-1, dette kalles normalisering), deretter beregnet ved å benytte en av funksjonene under og til slutt konvertert til den skalaen du har valgt for kategorielementet (mellom valgt <em>Minimumsverdi</em> og <em>Maksimumsverdi</em>.</p>

<p><strong>VIKTIG!</strong>: En tom karakter er ganske enkelt en manglende karakter og kan bety forskjellige ting. F.eks. kan det bety at brukeren ikke har levert inn noe, at innleveringen ikke er vurdert av en lærer ennå, eller at karakteren er blitt slettet manuelt av en karakterbok-administrator. Du bør derfor ha spesiell oppmerksomhet mot disse "tomme" karakterene.</p>

<dl id="grade-aggregation-help">
    <dt>Middelverdi av karakterer</dt>
    <dd>Summen av alle karakterene blir delt på antall karakterelementer.</dd>
    <dd class="example">A1 70/100, A2 20/80, A3 10/10, kategoriens max 100:<br />
                     <code>(0.7 + 0.25 + 1.0)/3 = 0.65 --> 65/100</code></dd>

    <dt>Median av karakterer</dt>
        <dd>Karakteren midt på skalaen (eller gjennomsnittet av de to midterste) når karakterene ordnes etter verdi. Fordelen med dette framfor rent gjennomsnitt er at en utelater de høyeste og laveste fra beregningen (karakterer som vanligvis er langt fra middelverdien).</dd>
        <dd class="example">A1 70/100, A2 20/80, A3 10/10, kategoriens max 100:<br />
                         <code>median(0.7 ; 0.25 ; 1.0) = 0.7 --> 70/100</code></dd>

    <dt>Laveste karakter</dt>
        <dd>Resultatet blir laveste karakter etter en normalisering. Det brukes vanligvis i kombinasjon med <em>Beregn bare ikke-tomme karakterer</em>.</dd>
        <dd class="example">A1 70/100, A2 20/80, A3 10/10, kategoriens max 100:<br />
                         <code>min(0.7 ; 0.25 ; 1.0) = 0.25 --> 25/100</code></dd>

    <dt>Høyeste karakter</dt>
        <dd>Resultatet blir høyeste karakter etter en normalisering.</dd>
        <dd class="example">A1 70/100, A2 20/80, A3 10/10, kategoriens max 100:<br />
                         <code>max(0.7 ; 0.25 ; 1.0) = 1.0 --> 100/100</code></dd>

    <dt>Mest gitte karakter</dt>
        <dd>Mest gitte karakter er den karakteren som forekommer oftest. Dette er mest brukt for ikke-numeriske karakterer. Fordelen fremfor gjennomsnitt er at den ikke påvirkes av høyeste og laveste gitte karakterer (karakterer som er uvanlig langt fra gjennomsnittet). Beregningsmetoden vil likevel bli meningsløs dersom  mer enn en har meget høye eller lave karakterer (bare en beholdes), eller hvis alle karakterene er forskjellige fra hverandre.</dd>
        <dd class="example">A1 70/100, A2 35/50, A3 20/80, A4 10/10, A5 7/10 kategoriens max 100:<br />
                         <code>mode(0.7 ; 0.7 ; 0.25 ; 1.0 ; 0.7) = 0.7 --> 70/100</code></dd>

    <dt>Naturlig</dt>
        <dd>Hver karakter kan vektes, og deretter brukes i en aritmetisk beregning av middelverdien til å påvirke viktigheten av hvert element i den samlede middelverdien.</dd>
        <dd class="example">A1 70/100 vekt 10, A2 20/80 vekt 5, A3
                         10/10 vekt 3, kategoriens max 100:<br /><code>(0.7*10 + 0.25*5 + 1.0*3)/18 = 0.625 --> 62.5/100</code></dd>';
$string['aggregation_link'] = 'grade/aggregation';
$string['aggregationcoef'] = 'Beregningskoeffisent';
$string['aggregationcoefextra'] = 'Ekstra poeng';
$string['aggregationcoefextra_help'] = 'Dersom aggregeringsmetidoen er "Naturlig" eller "Enkel vektet middelverdi" og tilleggspoeng er merket av, vil maks karakter for dette elementet ikke bli lagt til maksimum for denne kategoriens karakter. Dette vil resultere i muligheten for at en kan få maks kategorikarakter uten å ha fått maks karakter i alle karaktersatte elementer. Hvis portaladministrator har aktivert mulighet for karakterer over maksimum, kan det være karakterer gitt over maksimum.

Hvis aggregeringen er "Middelverdi av karakterer (med tilleggspoeng)" og tilleggspoeng er satt til en større verdi enn null, vil tilleggspoeng være faktoren elementet er multiplisert med før summering av totalverdi, etter beregning av middelverdien.';
$string['aggregationcoefextra_link'] = 'grade/aggregation';
$string['aggregationcoefextrasum'] = 'Ekstra poeng';
$string['aggregationcoefextrasum_help'] = '<p>Dersom beregningsmetoden "Sum av karakterer" benyttes, kan ett karakterelement brukes som ekstrapoeng for kategorien. Dette betyr at karakterelementets maksimumskarakter ikke vil bli lagt til kategoriens maksimumskarakter, men elementets karakter vil tas med. For eksempel:</p>

<ul>
    <li>Element 1 har skalaen 0-100</li>
    <li>Element 2 har skalaen 0-75</li>
    <li>Element 1 har "Bruk som ekstrapoeng" avmerket, ELement 2 har det ikke.</li>
    <li>Begge elementene hører til Kategori 1, som har "Sum av karakterer" som beregningsmetode.</li>
    <li>Kategori 1 har skalaen 0-75</li>
    <li>En student får karakteren 20 på Element 1 og 70 på Element 2</li>
    <li>Students karakter for Kategori 1 vil da bli 75/75 (20+70 = 90, siden Element 1 bare brukes som ekstrapoeng vil totalen gi maksimumskarakter)</li>
</ul>';
$string['aggregationcoefextrasum_link'] = 'grade/aggregation';
$string['aggregationcoefextrasumabbr'] = '+';
$string['aggregationcoefextraweight'] = 'Vekting av ekstrapoeng';
$string['aggregationcoefextraweight_help'] = '<p>Dersom en verdi større enn 0 blir lagt til, vil dette karaktereelementet få beregnet ekstrapoeng. Verdien er en faktor som karakteren blir ganget med før den legges til summen av alle karakterer. Elementet med ekstrapoeng vil ikke tas med når middelverdien på resterende karakterer beregnes. For eksempel:</p>

<ul>
    <li>Element 1 har skalaen 0-100 og ekstrapoeng er satt til 2</li>
    <li>Element 2 har skalaen 0-100 og ekstrapoeng er satt til 0.0000</li>
    <li>Element 3 har skalaen 0-100 og ekstrapoeng er satt til 0.0000</li>
    <li>Alle 3 elementene hører til Kategori 1, som har "Middelverdi av karakterer (med ekstrapoeng)" som beregningsmetode.</li>
    <li>En student får karakteren 20 på Element 1, 40 på Element 2 og 70 på Element 3.</li>
    <li>Studentens samlede karakter for Kategor1 1 vil da bli 95/100 siden  20*2 + (40 + 70)/2 = 95</li>
</ul>';
$string['aggregationcoefextraweight_link'] = 'grade/aggregation';
$string['aggregationcoefweight'] = 'Enhetsvekting';
$string['aggregationcoefweight_help'] = '<p>Vekting som tillegges alle vurderinger i denne karaktergivingen når karakteren beregnes.</p>';
$string['aggregationcoefweight_link'] = 'grade/aggregation';
$string['aggregationhintdropped'] = '( Droppet )';
$string['aggregationhintexcluded'] = '( Ekskludert )';
$string['aggregationhintextra'] = '( Ekstra poeng )';
$string['aggregationhintnovalue'] = '( Tom )';
$string['aggregationofa'] = 'Sum av {$a}';
$string['aggregationposition'] = 'Beregningsposisjon';
$string['aggregationposition_help'] = '<p>Angir hvor på siden beregningskolonnen for totalkarakter skal vises.</p>';
$string['aggregationsvisible'] = 'Tilgjengelige karakterberegningstyper';
$string['aggregationsvisiblehelp'] = 'Velg hvilke beregningsstyper som skal være tilgjengelige. Hold nede Ctrl-tasten for å velge mer enn ett element.';
$string['allgrades'] = 'Alle karakterer på kategori';
$string['allstudents'] = 'Alle studentene';
$string['allusers'] = 'Alle brukere';
$string['aria-toggledropdown'] = 'Veksle på følgende rullegardinmeny';
$string['aria:dropdowngrades'] = 'Fant karakterelementer';
$string['autosort'] = 'Autosorter';
$string['availableidnumbers'] = 'TIlgjengelige idnummer';
$string['average'] = 'Gjennomsnitt';
$string['averagesdecimalpoints'] = 'Desimaler i kolonnegjennomsnitt';
$string['averagesdecimalpoints_help'] = 'Angi antall desimaler som skal vises i hver kolonnes middelverdi. Dersom arv er valgt vil visningstypen for hver kolonne bli benyttet.';
$string['averagesdisplaytype'] = 'Visningstype for kolonnegjennomsnitt';
$string['averagesdisplaytype_help'] = '<p>Angir hvordan middelverdien skal vises for hver kolonne. Dersom "arv" er valgt vil visningen som er angitt for hver kolonne bli benyttet.</p>';
$string['backupwithoutgradebook'] = 'Sikkerhetskopien inneholder ikke Karakterbok-konfigurasjon';
$string['badgrade'] = 'Angitte karakter er ugyldig';
$string['badlyformattedscale'] = 'Vennligst bruk en komma-separert liste av verdier. Det må være minst to verdier i listen.';
$string['baduser'] = 'Angitt bruker er ugyldig';
$string['bonuspoints'] = 'Bonuspoeng';
$string['bulkcheckboxes'] = 'Massebehandle avkrysningsbokser';
$string['calculatedgrade'] = 'Beregnet karakter';
$string['calculation'] = 'Beregning';
$string['calculation_help'] = 'En karakterberegning er en formel som brukes til å bestemme karakterer. Formelen må starte med et likhetstegn (=) og kan inneiholde vanlige matematiske tegn, slik som max, min og sum. Om ønskelig kan også andre karakterelementer tas med i beregningen ved å skrive inn ID-nummeret i doble hakeparenteser.';
$string['calculation_link'] = 'grade/calculation';
$string['calculationadd'] = 'Legg til beregning';
$string['calculationedit'] = 'Rediger beregning';
$string['calculationsaved'] = 'Beregningen er lagret';
$string['calculationview'] = 'Se beregning';
$string['calculationwarning'] = 'Denne kategorien bruker en karakterberegning for kategorisummen i stedet for en aggregering.';
$string['cannotaccessgroup'] = 'Desverre ingen tilgang til karakterer for valgte gruppe.';
$string['categories'] = 'Kategorier';
$string['category'] = 'Kategori';
$string['categoryedit'] = 'Rediger kategori';
$string['categoryname'] = 'Kategorinavn';
$string['categorytotal'] = 'Kategoritotal';
$string['categorytotalfull'] = '{$a->category} totalt';
$string['categorytotalname'] = 'Navn på kategoritotal';
$string['changedefaults'] = 'Endre standarder';
$string['changereportdefaults'] = 'Rediger rapportstandarder';
$string['chooseaction'] = 'Velg en handling...';
$string['choosecategory'] = 'Velg kategori';
$string['collapsecriterion'] = 'Minimer kriterie';
$string['compact'] = 'Kompakt';
$string['componentcontrolsvisibility'] = 'Hvorvidt dette karakterelementet er skjult, styres av aktivitetsinnstillingene.';
$string['contract'] = 'Kontraktkategori';
$string['contributiontocoursetotal'] = 'Bidrag til kurstotal';
$string['controls'] = 'Kontrollere';
$string['courseavg'] = 'Kursgjennomsnitt';
$string['coursegradecategory'] = 'Kurstegn kategori';
$string['coursegradedisplaytype'] = 'Visningstype for kurskarakter';
$string['coursegradedisplayupdated'] = 'Visningstype for kurskarakter er endret';
$string['coursegradesettings'] = 'Innstillinger for kurskarakterer';
$string['coursename'] = 'Kursnavn';
$string['coursescales'] = 'Kurs-skalaer';
$string['coursesettings'] = 'Kursinnstillinger';
$string['coursesettingsexplanation'] = 'Innstillingen bestemmer om karakterboken skal vises for alle deltakere i dette kurset.';
$string['coursesiamtaking'] = 'Kurs jeg tar';
$string['coursesiamteaching'] = 'Kurs jeg er lærer i';
$string['coursetotal'] = 'Kurstotal';
$string['createcategory'] = 'Lag kategori';
$string['createcategoryerror'] = 'Kunne ikke lage ny kategori';
$string['creatinggradebooksettings'] = 'Opprett innstillinger for karakterbok';
$string['csv'] = 'CSV';
$string['currentparentaggregation'] = 'Gjeldende overordnet posisjon';
$string['curveto'] = 'Curve To';
$string['decimalpoints'] = 'Gjennomgående antall desimaler';
$string['decimalpoints_help'] = 'Denne innstillingen angir antall desimaler som skal vises for hver karakter. Denne innstillingen har ingen effekt på karakterberegninger - de gjøres med fem desimaler uansett.';
$string['default'] = 'Standard';
$string['defaultprev'] = 'Standard ({$a})';
$string['deletecategory'] = 'Slett kategori';
$string['deletescale'] = 'Slett skala';
$string['disablegradehistory'] = 'Slå av karakterhistorie';
$string['disablegradehistory_help'] = 'Slå av historiesporing i endringer i karakter-relaterte tabeller. Dette kan øke serverens ytelse noe og spare plass i databasen.';
$string['displaylettergrade'] = 'Vis bokstavkarakterer';
$string['displaypercent'] = 'Vis prosent';
$string['displaypoints'] = 'Vis poeng';
$string['displayweighted'] = 'Vis vektede karakterer';
$string['droplow'] = 'Dropp den laveste';
$string['droplow_help'] = '<p>Dersom angitt, vil dette valget utelate X av de laveste karakterene. X er den verdien du valgte for "Utelat laveste".</p>';
$string['droplowestvalue'] = 'Sett dropp den laveste karakterverdien';
$string['droplowestvalues'] = 'Fjern {$a} laveste verdier';
$string['dropped'] = 'Utelatt';
$string['dropxlowest'] = 'Utelat X laveste';
$string['dropxlowestwarning'] = 'Merk: Dersom du utelater x laveste vil karaktermodulen anta at alle elementene i kategorien har samme poengverdi. Dersom poengsettingen varierer vil resultatene bli uforutsigbare.';
$string['duplicatedgradeitem'] = '{$a} (kopiér)';
$string['duplicatescale'] = 'Dupliker skala';
$string['edit'] = 'Rediger';
$string['editcalculation'] = 'Rediger beregning';
$string['editcalculationverbose'] = 'Rediger beregning for {$a->category}$a->itemmodule {$a->itemname}';
$string['editfeedback'] = 'Rediger tilbakemelding';
$string['editgrade'] = 'Rediger karakter';
$string['editgradeletters'] = 'Rediger bokstavkarakterer';
$string['editoutcome'] = 'Rediger læringsmål';
$string['editoutcomes'] = 'Rediger læringsutbytte';
$string['editscale'] = 'Rediger skala';
$string['edittree'] = 'Oppsett';
$string['editverbose'] = 'Rediger {$a->category}$a->itemmodule {$a->itemname}';
$string['enableajax'] = 'Slå på AJAX';
$string['enableajax_help'] = 'Legger til et lag med AJAX-funksjonalitet i lærerrapporten, forenkler og øker hastigheten på vanlige operasjoner. Betinger at Javascript er slått på i nettleseren.';
$string['enableoutcomes'] = 'Slå på læringsutbytte';
$string['enableoutcomes_help'] = 'Hvis aktivert, vil aktiviteter kunne vurderes ved å bruke en eller flere skalaer som er koblet til læringsmål.';
$string['encoding'] = 'Tegnsett';
$string['encoding_help'] = 'Velg tegnsettet som skal brukes for dataene. (Standard tegnsett er UTF-8). Hvis feil tegnsett velges ved et uhell, vil det være synlig når dataene forhåndsvises før importen.';
$string['errorcalculationbroken'] = 'Feil i beregningen av karakterelementet {$a}.';
$string['errorcalculationnoequal'] = 'Formelen må starte med erlik-tegn (=1+2)';
$string['errorcalculationunknown'] = 'Feil formel';
$string['errorgradevaluenonnumeric'] = 'Mottatt ikke-numerisk lavest eller høyest karakter for';
$string['errornocalculationallowed'] = 'Beregninger er ikke tillatt for denne enheten';
$string['errornocategorisedid'] = 'Kunne ikke få en ukategorisert id!';
$string['errornocourse'] = 'Kunne ikke hente kursinformasjonen';
$string['erroroverweight'] = 'Totalvekten overstiger 100 %.';
$string['errorreprintheadersnonnumeric'] = 'Received non-numeric value for reprint-headers';
$string['errorsavegrade'] = 'Beklager - kunne ikke lagre karakteren.';
$string['errorsettinggrade'] = 'Feil ved lagring av "{$a->itemname}" karakter for brukerID {$a->userid}';
$string['errorunderweight'] = 'Totalvekten er mindre enn 100 %.';
$string['errorupdatinggradecategoryaggregateonlygraded'] = 'Feil ved oppdatering av "Ta bare med ikke-tomme karakterer" innstillingen for karakterkategori ID {$a->id}';
$string['errorupdatinggradecategoryaggregateoutcomes'] = 'Feil ved oppdatering av "Ta med læringsutbytte i beregningen" innstillingen for karakterkategori ID {$a->id}';
$string['errorupdatinggradecategoryaggregation'] = 'Feil ved oppdatering av aggregeringstype for karakterkategori ID {$a->id}';
$string['errorupdatinggradeitemaggregationcoef'] = 'Feil ved oppdatering av aggregeringskoeffisient (vekting eller tilleggspoeng) for karakterelement ID {$a->id}';
$string['eventgradedeleted'] = 'Karakter slettet';
$string['eventgradeexported'] = 'Karakter eksportert';
$string['eventgradeitemcreated'] = 'Karakterelement opprettet';
$string['eventgradeitemdeleted'] = 'Karakterelement slettet';
$string['eventgradeitemupdated'] = 'Karakterelement oppdatert';
$string['eventgradelettercreated'] = 'Bokstavkarakter opprettet';
$string['eventgradeletterdeleted'] = 'Bokstavkarakter slettet';
$string['eventgradeletterupdated'] = 'Bokstavkarakter oppdatert';
$string['eventgradeviewed'] = 'Karakterer ble vist i karakterboka';
$string['eventscalecreated'] = 'Skala opprettet';
$string['eventscaledeleted'] = 'Skala slettet';
$string['eventscaleupdated'] = 'Skala oppdatert';
$string['eventusergraded'] = 'Brukeren har fått en karakter';
$string['excluded'] = 'Excluded';
$string['excluded_help'] = '<p>Dersom -utelatt- er aktivisert vil denne karakteren bli utelatt fra alle beregninger som foretas av overordnet karakterelement eller kategori.</p>';
$string['expand'] = 'Utvid kategori';
$string['expandcriterion'] = 'Utvid kriterie';
$string['export'] = 'Eksporter';
$string['exportalloutcomes'] = 'Eksporter alt utbytte';
$string['exportas'] = 'Eksportér som';
$string['exportfeedback'] = 'Inkluder tilbakemelding i eksporten';
$string['exportfeedback_desc'] = 'Dette kan overstyres ved eksport';
$string['exportformatoptions'] = 'Eksportformatvalg';
$string['exportonlyactive'] = 'Ekskludér utestengte brukere';
$string['exportonlyactive_help'] = 'Ta kun med studenter med aktiv påmelding og som ikke er utestengte i eksporten.';
$string['exportplugins'] = 'Eksporter moduler';
$string['exportsettings'] = 'Eksporter innstillinger';
$string['exportto'] = 'Eksporter til';
$string['externalurl'] = 'Ekstern URL';
$string['externalurl_desc'] = 'Hvis en ekstern karakterbok blir brukt, legg inn URLen her.';
$string['extracreditvalue'] = 'Ekstra poengverdi for {$a}';
$string['extracreditwarning'] = 'Note: Setting all items for a category to extra credit will effectively remove them from the grade calculation. Since there will be no point total';
$string['fail'] = 'Feil';
$string['feedback'] = 'Tilbakemelding';
$string['feedback_help'] = '<p>Kommentarer som læreren har lagt til karakteren. Dette kan være differensierte og personlige tilbakemeldinger, eller enkle koder som viser til et internt tilbakemeldingssystem.</p>';
$string['feedbackadd'] = 'Legg til tilbakemelding';
$string['feedbackedit'] = 'Rediger tilbakemelding';
$string['feedbackfiles'] = 'Tilbakemeldingsfiler';
$string['feedbackforgradeitems'] = 'Tilbakemelding for {$a}';
$string['feedbackhistoryfiles'] = 'Tilbakemeldingshistoriefiler';
$string['feedbackprovided'] = 'Tilbakemelding gitt';
$string['feedbacks'] = 'Tilbakemeldinger';
$string['feedbacksaved'] = 'Tilbakemelding lagret';
$string['feedbackview'] = 'Se tilbakemelding';
$string['filterbothactive'] = 'Første ({$a->first}) Siste ({$a->last})';
$string['filterbyname'] = 'Filtrer på navn';
$string['filterfirstactive'] = 'Første ({$a->first})';
$string['filterlastactive'] = 'Siste ({$a->last})';
$string['finalgrade'] = 'Endelig karakter';
$string['finalgrade_help'] = '<p>Sluttkarakteren etter at alle beregninger er gjennomført.</p>';
$string['fixedstudents'] = 'Lås studentnavn-kolonnen';
$string['fixedstudents_help'] = 'Frys kolonnen med studentnavn slik at en kan scrolle horisontalt i karaktene.';
$string['forceimport'] = 'Tving import';
$string['forceimport_help'] = 'Tving import av karakterer selv om karakterene ble oppdatert etter at importfilen ble eksportert';
$string['forceoff'] = 'Tving: Av';
$string['forceon'] = 'Tving: På';
$string['forelementtypes'] = 'for de valgte {$a}';
$string['forstudents'] = 'For studenter';
$string['full'] = 'Full';
$string['fullmode'] = 'Vis karakterer og totaler';
$string['generalsettings'] = 'Generelt';
$string['grade'] = 'Karakter';
$string['grade_help'] = 'Vurdering som denne personen skal få for dens arbeid.';
$string['gradeadministration'] = 'Karakterbok administrasjon';
$string['gradealreadyupdated'] = '{$a} karakterer har ikke blitt importert fordi karakterene i importfila er eldre enn karakterene i karakterrapporten. For å likevel fortsette med karakterimporten, bruk valget "Tving import"';
$string['gradeanalysis'] = 'Karakteranalyse';
$string['gradebook'] = 'Karakterbok';
$string['gradebookcalculationsfixbutton'] = 'Aksepter karakterendringer og fiks beregningsfeil';
$string['gradebookcalculationsuptodate'] = 'Beregningene i karakterboka er oppdaterte. Du må kanskje oppdatere denne siden for å se endringene';
$string['gradebookcalculationswarning'] = 'Merk: Det har blitt oppdaget noen feil i beregningen av karakterene som vises i karakterboka.  Dersom kurset ikke har startet eller at det er i gang, er det anbefalet at feilen rettes opp ved å klikke på knappen nedenfor. Dette vil føre til at noen karakterer blir endret.

Hvis kurset ditt allerede er avsluttet og sluttkarakterene er delt ut, bør du la være å fikse dette problemet.

For detaljert informasjon om endringer mellom ulike versjoner, se {$a->gradebookversion} og {$a->currentversion} under <a href="{$a->url}">Gradebook calculation changes</a>.';
$string['gradebookhiddenerror'] = 'Karakterboken er for tiden satt til å skjule alt fra studenten';
$string['gradebookhistories'] = 'Karakterhistorie';
$string['gradebooknavigationmenu'] = 'Vurderingsbok navigasjonsmeny';
$string['gradebooksetup'] = 'Karakterbokoppsett';
$string['gradeboundary'] = 'Grenser for bokstavkarakterer';
$string['gradeboundary_help'] = '<p>En prosentgrense over hvilke karakterer som vil bli tildelt en karakterbokstav (dersom vis bokstavkarakterer brukes).</p>';
$string['gradecategories'] = 'Karakterkategorier';
$string['gradecategory'] = 'Karakterkategori';
$string['gradecategoryonmodform'] = 'Karakterkategori';
$string['gradecategoryonmodform_help'] = 'Denne innstillingen styrer kategorien som inneholder aktivitetens karakterer i karakterboken.';
$string['gradecategorysettings'] = 'Karakterkategorier';
$string['gradedisplay'] = 'Karaktervisning';
$string['gradedisplaytype'] = 'Type karaktervisning';
$string['gradedisplaytype_help'] = 'Angi hvordan karakterer skal vises i karakter- og brukerrapporter.

* Bokstav - Bokstaver eller ord brukes til å vise karakterer slik de er definert under \'Bokstavkarakterer\' i karakterbokinnstillingene
* Prosent - Relativt til maks og minimumskarakteren
* Virkelig - Virkelig karakter eller skalaverdi';
$string['gradedon'] = 'Satt karakter: {$a}';
$string['gradeexport'] = 'Karaktereksport';
$string['gradeexportcolumntype'] = '{$a->name} ({$a->extra})';
$string['gradeexportcustomprofilefields'] = 'Tilpassede profilfelt for karaktereksport';
$string['gradeexportcustomprofilefields_desc'] = 'Inkluder disse tilpassede profilfeltene i karaktereksporten, separert med komma.';
$string['gradeexportdecimalpoints'] = 'Antall desimaler for karaktereksport';
$string['gradeexportdecimalpoints_desc'] = 'Antall desimaler som skal vises for eksport. Dette kan overstyres i eksporten.';
$string['gradeexportdisplaytype'] = 'Karaktereksport visningstype';
$string['gradeexportdisplaytype_desc'] = 'Karakterer kan vises som virkelige karakter, som prosent(i forhold til minimum og maksimumskarakterer som bokstaver(A,B,C osv) gjennom eksport. Dette kan overstyres i eksporten.';
$string['gradeexportdisplaytypes'] = 'Visningsvalg for karaktereksport';
$string['gradeexportuserprofilefields'] = 'Brukeres profilfelt for karaktereksport';
$string['gradeexportuserprofilefields_desc'] = 'Inkluder disse brukerprofilfeltene i karaktereksporten, separert med komma.';
$string['gradeforstudent'] = '{$a->student}<br />{$a->item}{$a->feedback}';
$string['gradegrademinmax'] = 'Standard maks- og minimumskarakterer';
$string['gradehelp'] = 'Hjelp for karakterer';
$string['gradehistorylifetime'] = 'Levetid for karakterhistorie';
$string['gradehistorylifetime_help'] = 'Dette angir hvor lenge du vil oppbevare endringshistorie i karakterrelaterte tabeller. Det er anbefalt å oppbevare dem så lenge som mulig. Hvis du opplever ytelsesproblemer eller har begrenset databaseplass, prøv å sett en lavere verdi.';
$string['gradeimport'] = 'Karakterimport';
$string['gradeimportfailed'] = 'Karakterimporten mislykkes. Detaljer:';
$string['gradeitem'] = 'Karakterenhet';
$string['gradeitemaddusers'] = 'Ekskluder fra vurdering';
$string['gradeitemadvanced'] = 'Avanserte karakterenhetsinnstillinger';
$string['gradeitemadvanced_help'] = 'Velg alle elementer som skal vises';
$string['gradeitemislocked'] = 'Denne aktiviteten er låst i karakterboka. Endringer som er gjort til karakteren i denne aktiviteten vil ikke kopieres til karakterboka før den er låst opp.';
$string['gradeitemlocked'] = 'Karakterlåsing';
$string['gradeitemmembersselected'] = 'Eksludert fra vurdering';
$string['gradeitemminmax'] = 'Maks- og minimumskarakter som spesifisert i karakterelementinnstillingene';
$string['gradeitemnonmembers'] = 'Inkludert i vurdering';
$string['gradeitemremovemembers'] = 'Inkluder i vurdering';
$string['gradeitems'] = 'Sett karakter';
$string['gradeitemsettings'] = 'Innstillinger for karaktersetting av elementer';
$string['gradeitemsinc'] = 'Karakterenheter som skal inkluderes';
$string['gradeletter'] = 'Bokstavkarakter';
$string['gradeletter_help'] = '<p>En bokstav eller et annet symbol brukt til å representere en skala av karakterer.</p>';
$string['gradeletternote'] = 'To delete a grade letter just empty any of the<br /> three text areas for that letter and click submit.';
$string['gradeletteroverridden'] = 'Standardbokstavkarakterene blir for tiden overstyrt';
$string['gradeletters'] = 'Bokstavkarakterer';
$string['gradelocked'] = 'Karakteren er låst';
$string['gradelong'] = '{$a->grade} / {$a->max}';
$string['grademax'] = 'Maksimal karakter';
$string['grademax_help'] = '<p>Når en benytter karaktertypen "verdi", kan det angis en maksimumskarakter. Maksimumskarakteren for en aktivitetsbasert karakter angis ved å redigere innstillinger for aktiviteten.</p>';
$string['grademin'] = 'Minimum karakter';
$string['grademin_help'] = '<p>Når en bruker karaktertypen "verdi" kan det angis en minimumskarakter.</p>';
$string['gradenotificationmessage'] = 'Du har fått en ny tilbakemelding for "{$a}"';
$string['gradenotificationsubject'] = 'Du har blitt vurdert';
$string['gradeoutcomeitem'] = 'Gi karakter for læringsutbytteenhet';
$string['gradeoutcomes'] = 'Læringsutbytte';
$string['gradeoutcomescourses'] = 'Kursresultater';
$string['gradepass'] = 'Ståkarakter';
$string['gradepass_help'] = '<p>Dersom et element har et karakterkrav som brukeren må oppnå for å bestå, kan du angi det her.</p>';
$string['gradepassgreaterthangrade'] = 'Ståkarakteren kan ikke være høyere enn den maksimale karakteren';
$string['gradepointdefault'] = 'Standard karakter';
$string['gradepointdefault_help'] = 'Denne innstilling bestemmer hvilken makskarakter som skal være standard i alle aktiviteter';
$string['gradepointdefault_validateerror'] = 'Denne innstillingen må være et heltall mellom 1 og maksimumskarakteren';
$string['gradepointmax'] = 'Maksimumskarakter';
$string['gradepointmax_help'] = 'Denne innstillingen bestemmer maksimal karakter tilgjengelig i en aktivitet.';
$string['gradepointmax_validateerror'] = 'Denne innstillingen må være et heltall mellom 1 og 10000';
$string['gradepreferences'] = 'Karakterinnstillinger';
$string['gradepreferenceshelp'] = 'Hjelp for karakterinnstillinger';
$string['gradepublishing'] = 'Tillat publisering';
$string['gradepublishing_help'] = 'Karakterpublisering en en metode for importering og eksportering av karakterer via URL uten å logge inn i Moodle. Hvis aktivert vil administratorer og brukere med tillatelser til å publisere karakterer (som standard kun superbrukere) kunne sette opp karakterpubliseringsinnstillingene i karakterboka i hvert enkelt kurs.';
$string['gradepublishinglink'] = 'Last ned: {$a}';
$string['gradereport'] = 'Karakterrapport';
$string['graderreport'] = 'Lærerrapport';
$string['grades'] = 'Karakterer';
$string['gradesforuser'] = 'Karakterer for {$a->user}';
$string['gradesmoduledeletionpendingwarning'] = 'Advarsel: Aktivitetssletting pågår! Noen karakterer er i ferd med å bli fjernet';
$string['gradesmoduledeletionprefix'] = '[Sletting pågår]';
$string['gradesonly'] = 'Vis kun karakterer';
$string['gradessettings'] = 'Karakterinnstillinger';
$string['gradetype'] = 'Karaktertype';
$string['gradetype_help'] = '<p>Angi hvilken karaktertype som skal brukes: "ingen" (det gis ikke karakter), "verdi" (slår på innstillinger for minimums- og maksimumskarakter), "skala" (slår på innstillinger for skalaer) eller "tekst" (bare tilbakemeldinger). Bare karaktertypene "verdi" og "skala" kan beregnes i formler. Karakterypen for et aktivitetsbasert element bestemmes under innstillingene for den enkelte aktivitet.</p>';
$string['gradevaluetoobig'] = 'En av karakterene er større enn den tillatte maksimumskarakteren på {$a}';
$string['gradevaluetoosmall'] = 'En av karakterverdiene er mindre enn tillatt karakter minimum på {$a}';
$string['gradeview'] = 'Se karakter';
$string['gradewasmodifiedduringediting'] = 'Karakteren for {$a->itemname} av {$a->username} ble ignorert fordi den nylig har blitt oppdatert av noen andre.';
$string['gradeweighthelp'] = 'Hjelp for karaktervekting';
$string['gradingmodulename'] = 'Vurdering ({$a})';
$string['groupavg'] = 'Gruppegjennomsnitt';
$string['hidden'] = 'Skjult';
$string['hidden_help'] = 'Dersom avmerket, blir karakterer skjult for studentene. Du kan om ønskelig angi en "Skjult til"-dato for å frigi karakterene når  karaktersettingen er ferdig.';
$string['hiddenasdate'] = 'Vis levert dato for skjulte karakterer';
$string['hiddenasdate_help'] = 'Hvis brukeren ikke kan se skjulte karakter vis innsendingsdatoen i stedet for \'-\'.';
$string['hiddenuntil'] = 'Skjult til';
$string['hiddenuntildate'] = 'Skjult til: {$a}';
$string['hideadvanced'] = 'Skjul avanserte egenskaper';
$string['hideaverages'] = 'Skjul gjennomsnitt';
$string['hidecalculations'] = 'Skjul beregninger';
$string['hidecategory'] = 'Skjult';
$string['hideeyecons'] = 'Skjul vis/skjul ikoner';
$string['hidefeedback'] = 'Skjul tilbakemelding';
$string['hideforcedsettings'] = 'Skjul tvungne innstillinger';
$string['hideforcedsettings_help'] = 'Ikke vis tvungne innstillinger i brukergrensesnittet for karakterboka.';
$string['hidegroups'] = 'Skjul grupper';
$string['hidelocks'] = 'Skjul låser';
$string['hidenooutcomes'] = 'Vis læringsutbytte';
$string['hidequickfeedback'] = 'Skjul hurtigtilbakemelding';
$string['hideranges'] = 'Skjul skalaer';
$string['hidetotalifhiddenitems'] = 'Skjule totaler dersom de inneholder skjulte elementer?';
$string['hidetotalifhiddenitems_help'] = '<p>Denne innstillingen angir hvorvidt totaler som inneholder skjulte karakterelementer skal vises for studentene eller erstattes med en bindestrek (-). Dersom skjulte elementer skal vises kan totalkarakter fortsatt beregnes med eller uten de skjulte elementene.</p>
<p>Dersom skjulte elementer ikke vises, vil totalkarakteren bli forskjellig fra den læreren ser, siden læreren alltid ser totalkarakterene basert på alle elementene, enten de er skjult eller ikke.</p>
<p>Dersom skjulte elementer tas med, kan studentene beregne de skjulte elementene.</p>';
$string['hidetotalshowexhiddenitems'] = 'Vis totaler hvor skjulte elementer er utelatt';
$string['hidetotalshowinchiddenitems'] = 'Vis totaler hvor skjulte elementer er regnet med';
$string['hideverbose'] = 'Skjul {$a->category}{$a->itemmodule} {$a->itemname}';
$string['highgradeascending'] = 'Sorter med høy karakter stigende';
$string['highgradedescending'] = 'Sorter med høy karakter synkende';
$string['highgradeletter'] = 'Høy';
$string['identifier'] = 'Identifiser bruker ved';
$string['idnumbers'] = 'Id nummer';
$string['ignore'] = 'Ignorer';
$string['import'] = 'Importer';
$string['importas'] = 'Importer som';
$string['importcsv'] = 'Importer CSV';
$string['importcsv_help'] = 'Karakterer kan importeres via en CSV-fil med formatet som følger:

* Hver linje i filen inneholder én oppføring
* Hver linje inneholder en serie av data atskilt med komma eller en alternativ separator
* Den første linja inneholder en liste over feltnavn å definere formatet til resten av filen
* Det kreves et feltnavn som inneholder brukeridentitetdata - enten brukernavn eller ID-nummer eller e-postadresse

En fil av riktig format kan fås ved først å eksportere noen karakterer. Filen kan redigeres og lagres som en CSV-fil.';
$string['importcsv_link'] = 'grade/import/csv/index';
$string['importcustom'] = 'Importer som egendefinerte læringsmål (bare for dette kurset)';
$string['importdata'] = 'Data';
$string['importdata_help'] = 'Karakterer kan limes inn direkte fra et OpenDocument- eller Excel-regneark med formatet som følger:

* Minst én kolonne skal inneholde brukeridentitetsdata – brukernavn, e-postadresse eller ID-nummer.
* Andre kolonner bør ha overskrifter som for eksisterende aktiviteter eller karakterelementer.

Et korrekt formatert regneark kan fås ved først å eksportere noen karakterer. Regnearket kan deretter redigeres for å legge til flere karakterer og lagres.

Velg og kopier kolonnene du vil importere fra regnearket, og lim dem deretter inn i dette feltet.';
$string['importerror'] = 'En feil oppstod, skriptet ble ikke oppkalt med riktige parametre.';
$string['importfailed'] = 'Importen feilet. Ingen data ble importert.';
$string['importfeedback'] = 'Tilbakemelding fra import';
$string['importfile'] = 'Importfil';
$string['importfilemissing'] = 'Ingen fil ble lastet opp, gå tilbake til skjemaet og pass på at du laster opp en gyldig fil.';
$string['importfrom'] = 'Importer fra';
$string['importoutcomenofile'] = 'Opplastet fil er tom eller ødelagt. Vær vennlig og pass på at det er en gyldig fil . Problemet ble oppdaget i linje {$a}; dette utløses ved at datalinjen ikke har så mange kolonner som første linje (overskriftslinjen) eller at den importerte filen mangler forventede overskrifter. Se på den eksporterte filen for et eksempel på en fil med gyldige overskrifter.';
$string['importoutcomes'] = 'Importer læringsutbytte';
$string['importoutcomes_help'] = 'Læringsutbytte kan importeres via CSV på samme måte som de kan eksporteres som CSV.';
$string['importoutcomes_link'] = 'grade/outcome';
$string['importoutcomesuccess'] = 'Importert læringsmål "{$a->name}" med ID #{$a->id}';
$string['importplugins'] = 'Importer moduler';
$string['importpreview'] = 'Importer forhåndsvisning';
$string['importsettings'] = 'Importer innstillinger';
$string['importskippednomanagescale'] = 'Du har ikke tillatelse til å legge til nye skalaer, så læringsutbytte "{$a}" ble hoppet over ettersom det krever at en ny skala blir opprettet.';
$string['importskippedoutcome'] = 'Et læringsutbytte med kortnavn "{$a}" eksisterer allerede i denne sammenhengen, den i den importerte filen ble hoppet over.';
$string['importstandard'] = 'Importer som standard læringsutbytte';
$string['importsuccess'] = 'Karakterimport suksessfull';
$string['importxml'] = 'Importer XML';
$string['includescalesinaggregation'] = 'Inkluder skalaer i summering';
$string['includescalesinaggregation_help'] = 'Du kan velge om skalaer skal inkluderes som tall i alle oppsamlede karakterer i alle karakterbøker i alle kurs. ADVARSEL: hvis du forandre denne innstillinger vil alle summerte karakterer bli omberegnet.';
$string['incorrectcourseid'] = 'Kurs ID var feil';
$string['incorrectcustomscale'] = '(Ugyldig egendefinert skala, vennligst endre den.)';
$string['incorrectminmax'] = 'Minimum må være mindre en maksimum';
$string['inherit'] = 'Arv';
$string['intersectioninfo'] = 'Student/Karakter info';
$string['invalidgradeexporteddate'] = 'Eksportdatoen var for mer enn et år siden, eller i fremtiden, eller så er formatet ugyldig.';
$string['item'] = 'Item';
$string['iteminfo'] = 'Enhetsinfo';
$string['iteminfo_help'] = '<p>Plass for å skrive inn informasjon om elementet. Teksten du skriver inn vil ikke synes noe annet sted.</p>';
$string['itemname'] = 'Enhetsnavn';
$string['itemnamehelp'] = 'Navnet på denne enheten, gitt av modulen';
$string['items'] = 'Enheter';
$string['itemsedit'] = 'Rediger karakterenhet';
$string['keephigh'] = 'Behold den høyeste';
$string['keephigh_help'] = 'Hvis satt, vil dette valget bare beholde de X høyeste karakterene, X er den valgte verdien for dette valget.';
$string['keephighestvalues'] = 'Behold {$a} høyeste verdier';
$string['keymanager'] = 'Nøkkelbehandler';
$string['lessthanmin'] = 'Karakteren for {$a->itemname} til {$a->username} er mindre en minimumm tillatt';
$string['letter'] = 'Bokstav';
$string['lettergrade'] = 'Bokstavkarakter';
$string['lettergradenonnumber'] = 'Low and/or High grade were non-numeric for';
$string['letterpercentage'] = 'Bokstav (prosent)';
$string['letterreal'] = 'Bokstav (virkelig)';
$string['letters'] = 'Bokstavkarakterer';
$string['linkedactivity'] = 'Linket aktivitet';
$string['linkedactivity_help'] = '<p>Angir en aktivitet som dette læringsresultatet er lenket til. Dette brukes tl å måle studentresultater mot kriterier som ikke er tilgjengelig via aktivitetens karakter alene.</p>';
$string['linktoactivity'] = '{$a->name} aktivitet {$a->title}';
$string['lock'] = 'Lås';
$string['locked'] = 'Låst';
$string['locked_help'] = 'Dersom avmerket vil ikke karakterer lenger automatisk oppdateres av den relaterte aktiviteten.';
$string['locktime'] = 'Lås etter';
$string['locktimedate'] = 'Låst etter: {$a}';
$string['lockverbose'] = 'Lås {$a->category}{$a->itemmodule} {$a->itemname}';
$string['lowest'] = 'Lowest';
$string['lowgradeletter'] = 'Low';
$string['manageoutcomes'] = 'Administrer resultater';
$string['manualitem'] = 'Manuell enhet';
$string['mapfrom'] = 'Kartlegg fra';
$string['mapfrom_help'] = 'Velg kolonnen i regnearket som inneholder data for å identifisere brukeren, for eksempel brukernavn, bruker-ID eller e-postadresse.';
$string['mappings'] = 'Oversikt over karakterenhet';
$string['mappings_help'] = 'For hver kolonne av karakterer i regnearket, velger du det tilsvarende karakterelementet for å importere karakterer inn.';
$string['mapto'] = 'Kartlegg til';
$string['mapto_help'] = 'Velg samme identifiseringsdata som valgt i "Hent fra".';
$string['max'] = 'Høyeste';
$string['maxgrade'] = 'Maks karakter';
$string['meanall'] = 'Alle karakterer';
$string['meangraded'] = 'Ikke-tomme karakterer';
$string['meanselection'] = 'Karakterer valgt for kolonnegjennomsnitt';
$string['meanselection_help'] = 'Om felt uten karakter skal inkluderes når en regner ut middleverdien for hver kolonne.';
$string['median'] = 'Median';
$string['min'] = 'Laveste';
$string['minimum_show'] = 'Vis minste karakter';
$string['minimum_show_help'] = 'Minste karakter brukes i beregninger og vektinger. Hvis det minste karakter ikke vises, vil den være 0 og ikke redigerbar.';
$string['minmaxtouse'] = 'Maks og minimumskarakter brukt i beregninger';
$string['minmaxtouse_desc'] = 'Denne innstillingen bestemmer om den opprinnelige minimums- eller maksimumskarakteren skal brukes, eller den nåværende minimums- eller maksimumskarakteren som er oppgitt i innstillingene for karakterelementet. Det anbefales at denne innstillingen endres på et tidspunkt med lite aktivitet siden en endring her vil kreve at alle karakterer revurderes, noe som fører til stor belastning på serveren.';
$string['minmaxtouse_help'] = 'Denne innstillingen bestemmer om den opprinnelige minimums- eller maksimumskarakteren skal brukes, eller den nåværende minimums- eller maksimumskarakteren som er oppgitt i innstillingene for karakterelementet.';
$string['minmaxtouse_link'] = 'Grades_min_max';
$string['minmaxupgradedgrades'] = 'Merk: Noen karakterer har blitt endret for å rette opp i inkonsistenser i karakterboka. Årsaken til dette er endringer i minimums- og maksimumskarakterer for ulike karakterelementer. Det anbefales at endringene sjekkes ut og aksepterer.';
$string['minmaxupgradefixbutton'] = 'Rett opp inkonsistenser';
$string['minmaxupgradewarning'] = 'Merk: En inkonsekvens er oppdaget med noen karakterer på grunn av en endring i de laveste og høyeste karakterer som benyttes ved beregning av vist karakter. Det anbefales at inkonsekvens er løst ved å klikke på knappen nedenfor, men dette vil føre til noen karakterer blir endret.';
$string['missingitemtypeoreid'] = 'Matrisenøkkel (varetype eller eid) mangler';
$string['missingscale'] = 'Skala må velges';
$string['mode'] = 'Modus';
$string['modgrade'] = 'Karakter';
$string['modgrade_help'] = '* Poeng - En numerisk verdi
* Ingen - Kun tilbakemelding
* Skala - Et element fra en liste';
$string['modgradecantchangegradetype'] = 'Du kan ikke endre karaktermetoden siden det allerede er delt ut karakterer for dette elementet.';
$string['modgradecantchangegradetypemsg'] = 'Noen karakterer har allerede blitt delt ut. Derfor kan ikke karaktertypen endres. Hvis du ønsker å endre maksimumskarakteren må du først velge om du skal reskalere eksisterende karakterer eller ikke.';
$string['modgradecantchangegradetyporscalemsg'] = 'Noen karakterer har blitt tildelt og du kan derfor ikke endre karaktermetode eller skala.';
$string['modgradecantchangeratingmaxgrade'] = 'Du kan ikke endre maksimumskarakteren når det allerede er gitt ut karakterer for et element.';
$string['modgradecantchangescale'] = 'Du kan ikke endre denne skalaen siden den allerede er i bruk.';
$string['modgradecategorycantchangegradetypemsg'] = 'Denne kategorien har tilknyttede karakterelementer som har blitt overstyrt. Derfor har noen karakterer allerede blitt tildelt, og karaktertypen kan ikke endres. Hvis du ønsker å endre maksimumskarakteren, må du første velge om du ønsker å reskalere eksisterende karakterer eller ikke.';
$string['modgradecategorycantchangegradetyporscalemsg'] = 'Denne kategorien inneholder overstyrte karakterelementer. Siden det allerede er blitt delt ut noen karakterer kan ikke karaktertypen eller skalaen endres.';
$string['modgradecategoryrescalegrades'] = 'Reskaler overstyrte karakterer';
$string['modgradecategoryrescalegrades_help'] = 'Når du endrer maksimumskarakteren på et element i karakterboka, må du spesifisere om dette skal endre på eksisterende prosentscorer i tillegg.

Om denne innstillingen settes til \'Ja\', vil alle eksisterende overstyrte karakterer reskaleres slik at den prosentvise karakteren forblir den samme.

For eksempel, om denne innstillingen er satt til \'Ja\', så vil endringen av makskarakteren på et element fra 10 til 20 føre til at den tidligere karakteren 6/10 (60%) blir endret til 12/20 (60%). Om denne innstillingen settes til \'Nei\', vil karakteren forbli uendret og vil kreve manuel justering av karakterelementen for å sikre korrekte poengsummer.';
$string['modgradedonotmodify'] = 'Ikke gjør endringer på eksisterende karakterer';
$string['modgradeerrorbadpoint'] = 'Ugyldig karakterverdi. Dette må være et heltall mellom 1 og {$a}';
$string['modgradeerrorbadscale'] = 'Ugyldig valg av skala. Vennligst velg en skala blant valgene nedenfor.';
$string['modgrademaxgrade'] = 'Maksimalt karakter';
$string['modgraderescalegrades'] = 'Reskaler eksisterende karakterer';
$string['modgraderescalegrades_help'] = 'Når du endrer maksimumskarakteren på et element i karakterboka, må du spesifisere om dette skal endre på eksisterende prosentscorer i tillegg.

Om denne innstillingen settes til \'Ja\', vil alle eksisterende overstyrte karakterer reskaleres slik at den prosentvise karakteren forblir den samme.

For eksempel, om denne innstillingen er satt til \'Ja\', så vil endringen av makskarakteren på et element fra 10 til 20 føre til at den tidligere karakteren 6/10 (60%) blir endret til 12/20 (60%). Om denne innstillingen settes til \'Nei\', vil karakteren endres fra 6/10 (60%) til 6/20 (30%), og den vil kreve manuell justering for å sikre korrekte poengsummer.';
$string['modgradetype'] = 'Type';
$string['modgradetypenone'] = 'Ingen';
$string['modgradetypepoint'] = 'Poeng';
$string['modgradetypescale'] = 'Skala';
$string['morethanmax'] = 'Karakteren lagt inn for {$a->itemname} til {$a->username} er høyere enn maksimum tillatt';
$string['moveselectedto'] = 'Flytt valgte elementer til:';
$string['movesitems'] = 'Flytt elementer';
$string['movingelement'] = 'Flytter {$a}';
$string['multfactor'] = 'Multiplikator';
$string['multfactor_help'] = '<p>Faktoren som alle karakterer for dette karakterelementet vil bli ganget med - med en maksimums- og minimumskarakter.</p>';
$string['multfactorvalue'] = 'Multiplikatorverdi for {$a}';
$string['mustchooserescaleyesorno'] = 'Du må velge om du skal reskalere eksisterende karakterer eller ikke.';
$string['mygrades'] = 'Karakterlenke i brukermeny';
$string['mygrades_desc'] = 'Denne innstillingen tillater å lenke til en ekstern karakterbok fra brukermenyen.';
$string['mypreferences'] = 'Mine innstillinger';
$string['myreportpreferences'] = 'Mine rapportinnstillinger';
$string['myself'] = 'Meg selv';
$string['neverdeletehistory'] = 'Aldri slett historien';
$string['newcategory'] = 'Ny kategori';
$string['newitem'] = 'Nytt karakterelement';
$string['newoutcomeitem'] = 'Nytt element for læringsmål';
$string['no'] = 'Nei';
$string['nocategories'] = 'Karakterkategori kunne ikke bli lagt til eller funnet for dette kurset';
$string['nocategoryname'] = 'Ikke noe kategorinavn ble gitt';
$string['nocategoryview'] = 'No category to view by';
$string['nocourses'] = 'Det er ingen kurs ennå';
$string['noexistingoutcomes'] = 'Det er ingen eksisterende resultater.';
$string['noexistingscales'] = 'Det er ingen eksisterende skalaer.';
$string['noforce'] = 'Ikke tving';
$string['nogradeletters'] = 'No grade letters set';
$string['nogradesreturned'] = 'No grades returned';
$string['noidnumber'] = 'Ikke noe idnummer';
$string['nolettergrade'] = 'Ingen bokstav karakter for';
$string['nomode'] = 'NA';
$string['nonnumericweight'] = 'Received non-numeric value for';
$string['nonunhideableverbose'] = 'For å vise denne karakteren, må du vise {$a->itemname}.';
$string['nonunlockableverbose'] = 'For å låse opp denne karakteren, må du låse opp {$a->itemname}.';
$string['nonweightedpct'] = 'ikke-vekted %';
$string['nooutcome'] = 'Ikke noe resultat';
$string['nooutcomes'] = 'Elementets læringsutbytte må lenkes til kursets læringsmål, men det er ingen læringsmål for dette kurset. Vil du legge til et læringsmål nå?';
$string['nopermissiontoresetweights'] = 'Ikke tillatelse til å tilbakestille vektingen';
$string['nopublish'] = 'Ikke publiser';
$string['noreports'] = 'Du er ikke påmeldt, eller underviser i noen kurs på denne portalen';
$string['norolesdefined'] = 'Ingen roller definert i Administrasjon > Karakterbok > Generelle innstillinger > Roller for karaktersetting';
$string['noscales'] = 'Læringsmål må lenkes til en vurderingsskala globalt eller i kurset, men det finnes ingen her. Vil du legge til en skala nå?';
$string['noselectedcategories'] = 'ingen kategorier ble valgt';
$string['noselecteditems'] = 'ingen enheter ble valgt';
$string['notenrolled'] = 'Du er for tiden ikke påmeldt noen kurs';
$string['notteachererror'] = 'Du må være lærer for å bruke denne aktiviteten.';
$string['nousersloaded'] = 'Ingen brukere lastet';
$string['nouserstograde'] = 'Ingen brukere å vurdere';
$string['numberofgrades'] = 'Antall karakterer';
$string['onascaleof'] = 'på en skala fra {$a->grademin} til {$a->grademax}';
$string['operations'] = 'Handlinger';
$string['options'] = 'Valg';
$string['others'] = 'Andre';
$string['otheruser'] = 'Bruker';
$string['outcome'] = 'Læringsutbytte';
$string['outcome_help'] = 'Denne innstillingen bestemmer utfallet som dette karakterelementet vil representere i karakterboken.';
$string['outcomeassigntocourse'] = 'Legg til et ekstra læringsmål til dette kurset.';
$string['outcomecategory'] = 'Lag læringsutbytte i kategori';
$string['outcomecategorynew'] = 'Ny kategori';
$string['outcomeconfirmdelete'] = 'Er du sikker på at du vil slette læringsutbytte "{$a}"?';
$string['outcomecreate'] = 'Legg til nytt læringsutbytte';
$string['outcomedelete'] = 'Slett læringsutbytte';
$string['outcomefullname'] = 'Fullt navn';
$string['outcomeitem'] = 'Læringsutbytteenhet';
$string['outcomeitemsedit'] = 'Rediger læringsutbytteenhet';
$string['outcomereport'] = 'Læringsutbytterapport';
$string['outcomes'] = 'Læringsutbytte';
$string['outcomescourse'] = 'Læringsutbytte inkludert i kurset';
$string['outcomescoursecustom'] = 'Egendefinert brukt (ikke ta bort)';
$string['outcomescoursenotused'] = 'Foreløpig ikke tilkoblet aktiviteter i kurset';
$string['outcomescourseused'] = 'Standard brukt (ikke fjern)';
$string['outcomescustom'] = 'Egendefinert læringsutbytte';
$string['outcomesdisabled'] = 'Resultater er ikke aktivert';
$string['outcomeshortname'] = 'Kort navn';
$string['outcomesstandard'] = 'Standard læringsutbytte';
$string['outcomesstandardavailable'] = 'Tilgjengelig standard læringsutbytte';
$string['outcomestandard'] = 'Standard læringsutbytte';
$string['outcomestandard_help'] = '<p>Et standard læringsresultat er (globalt) tilgjengelig for alle kurs.</p>';
$string['overallaverage'] = 'Totalgjennomsnitt';
$string['overridden'] = 'Overstyrt';
$string['overridden_help'] = 'Dersom merket av, kan ikke karakteren endres innenifra den relaterte aktiviteten lenger.

Når en karakter er endret i karakterboka, blir den overstyrte avmerkingsboksen merket av automatisk. Men den kan u-avmerkes for å tillate at karakteren kan endres via den relaterte aktiviteten.';
$string['overriddennotice'] = 'Den endelige karakteren fra denne aktiviteten ble redigert manuelt.';
$string['overridecat'] = 'Tillat kategorikarakterer å bli manuelt overstyrt';
$string['overridecat_help'] = 'Deaktivering av denne innstillingen gjør det umulig for brukere å overstyre kategorikarakterer.';
$string['overridesitedefaultgradedisplaytype'] = 'Overstyr portalinnstillinger';
$string['overridesitedefaultgradedisplaytype_help'] = '<p>Merk av her for å aktivere overstyring av de standarder som er satt for standard visning av karakterer i karakterboka. Dette aktiverer skjemaelementer som lar deg definere bokstavkarakterer og grenseverdier du måtte trenge.</p>';
$string['overrideweightofa'] = 'Overstyr vektingen av {$a}';
$string['parentcategory'] = 'Overordnet kategori';
$string['pass'] = 'Beståttgrense';
$string['pctoftotalgrade'] = '% av total karakter';
$string['percent'] = 'Prosent';
$string['percentage'] = 'Prosentandel';
$string['percentageletter'] = 'Prosent (Bokstav)';
$string['percentagereal'] = 'Prosent (Virkelig)';
$string['percentascending'] = 'Sorter etter prosent stigende';
$string['percentdescending'] = 'Sorter etter prosent synkende';
$string['percentshort'] = '%';
$string['plusfactor'] = 'Pluss-faktor';
$string['plusfactor_help'] = '<p>Et tall som blir lagt til alle karakterer for dette karakterelementet, ETTER at gangefaktoren er medregnet.</p>';
$string['plusfactorvalue'] = 'Oppveid verdi for {$a}';
$string['points'] = 'points';
$string['pointsascending'] = 'Sort by points ascending';
$string['pointsdescending'] = 'Sorter synkende etter poeng';
$string['positionfirst'] = 'Første';
$string['positionlast'] = 'Siste';
$string['preferences'] = 'Innstillinger';
$string['prefgeneral'] = 'Generell';
$string['prefletters'] = 'Bokstavkarakterer og grenseverdier';
$string['prefrows'] = 'Spesielle rader';
$string['prefshow'] = 'Vis/skjul endringer';
$string['previewrows'] = 'Forhåndsvis rader';
$string['privacy:metadata:categorieshistory'] = 'En oppføring med tidligere versjoner av karakterkategorier';
$string['privacy:metadata:filepurpose'] = 'Tilbakemeldingsfiler lagret i karakterboken for en bruker.';
$string['privacy:metadata:grade_import_newitem'] = 'Midlertidig tabell for lagring av nye karakterelementnavn fra karakterimport';
$string['privacy:metadata:grade_import_newitem:importcode'] = 'En unik batchkode for å identifisere en batch av import';
$string['privacy:metadata:grade_import_newitem:importer'] = 'Brukeren som importerte data';
$string['privacy:metadata:grade_import_newitem:itemname'] = 'Nytt karakterelementnavn';
$string['privacy:metadata:grade_import_values'] = 'Midlertidig tabell for import av karakterer';
$string['privacy:metadata:grade_import_values:feedback'] = 'Karaktertilbakemelding';
$string['privacy:metadata:grade_import_values:finalgrade'] = 'Råkarakterverdi';
$string['privacy:metadata:grade_import_values:importcode'] = 'En unik batch-kode for å identifisere en batch med importer';
$string['privacy:metadata:grade_import_values:importer'] = 'Bruker som imoprterer data';
$string['privacy:metadata:grade_import_values:importonlyfeedback'] = 'Flagg hvis kun tilbakemelding ble importert';
$string['privacy:metadata:grade_import_values:userid'] = 'Bruker hvis karakter ble importert';
$string['privacy:metadata:grades'] = 'En oppføring med karakterer';
$string['privacy:metadata:grades:aggregationstatus'] = 'Aggregeringsstatus';
$string['privacy:metadata:grades:aggregationweight'] = 'Aggregeringsvekting';
$string['privacy:metadata:grades:feedback'] = 'Tilbakemeldingen';
$string['privacy:metadata:grades:finalgrade'] = 'Karakteren';
$string['privacy:metadata:grades:information'] = 'Tilleggsinformasjon om karakteren';
$string['privacy:metadata:grades:timemodified'] = 'Når karakteren sist ble endret.';
$string['privacy:metadata:grades:userid'] = 'IDen til brukeren med karakteren';
$string['privacy:metadata:grades:usermodified'] = 'IDen til brukeren sm sist endret oppføringen';
$string['privacy:metadata:gradeshistory'] = 'En oppføring med tidligere karakterer';
$string['privacy:metadata:history:loggeduser'] = 'IDen til brukeren som var innlogget da versjoneringen oppstod.';
$string['privacy:metadata:history:timemodified'] = 'Tiden da karakterversjonering skjedde';
$string['privacy:metadata:itemshistory'] = 'En oppføring med tidligere versjoner av karakterelementer';
$string['privacy:metadata:outcomes'] = 'En oppføring med læringsutbytter';
$string['privacy:metadata:outcomes:timemodified'] = 'Tidspunktet oppføringen ble endret';
$string['privacy:metadata:outcomes:usermodified'] = 'Brukeren som endret oppføringen';
$string['privacy:metadata:outcomeshistory'] = 'En oppføring med tidligere versjoner av læringsutbytter';
$string['privacy:metadata:scale'] = 'En oppføring med skalaer';
$string['privacy:metadata:scale:timemodified'] = 'Tidspunktet oppføringen sist ble endret';
$string['privacy:metadata:scale:userid'] = 'Brukeren som sist endret oppføringen';
$string['privacy:metadata:scalehistory'] = 'En oppføring med tidligere versjoner av';
$string['privacy:path:relatedtome'] = 'Relatert til meg';
$string['privacy:request:historyactiondelete'] = 'Slett';
$string['privacy:request:historyactioninsert'] = 'Sett inn';
$string['privacy:request:historyactionupdate'] = 'Oppdater';
$string['privacy:request:unknowndeletedgradeitem'] = 'Ukjent (karakterelementet er slettet)';
$string['profilereport'] = 'Brukerprofilrapport';
$string['profilereport_help'] = 'Karakter-rapport brukt på brukerens profilside.';
$string['publishing'] = 'Publiserer';
$string['publishingoptions'] = 'Publiseringsvalg for karakter';
$string['quickfeedback'] = 'Hurtig tilbakemelding';
$string['quickgrading'] = 'Hurtig karaktersetting';
$string['quickgrading_help'] = 'Dersom aktivert kommer en tekstboks til syne for hver karakter når redigering er skrudd på. Dette gjør det mulig å endre mange karakterer på en gang. Endringer lagres og utheves når en trykker på oppdaterknappen.

Vær oppmerksom på at når en karakter blir endret i karakterboka, kommer det opp et overstyrt flagg. Dette betyr at karakteren ikke lenger kan endres innenifra den relaterte aktiviteten.';
$string['range'] = 'Skala';
$string['rangedecimals'] = 'Antall desimaler for utvalget';
$string['rangedecimals_help'] = 'Antall desimaler som skal vises for intervallet';
$string['rangesdecimalpoints'] = 'Visning av desimaler for område';
$string['rangesdecimalpoints_help'] = 'Denne innstillingen angir antall desimaler som skal vises for hver skala og om desimalinnstillingen for kategorien eller karakterelementet skal brukes (arv).';
$string['rangesdisplaytype'] = 'Område visningstype';
$string['rangesdisplaytype_help'] = '<p>Angir hvordan skalaer skal vises. Dersom arv er valgt, vil visningstypen for hver kolonne bli brukt.</p>';
$string['rank'] = 'Rank';
$string['rawpct'] = 'Rå %';
$string['real'] = 'Virkelig';
$string['realletter'] = 'Virkelig (Bokstav)';
$string['realpercentage'] = 'Virkelig (Prosent)';
$string['recalculatinggrades'] = 'Omberegner karakterer';
$string['recovergradesdefault'] = 'Gjenoppretter karakterer som standard';
$string['recovergradesdefault_help'] = 'Gjenoppretter gamle karakterer som standard når en bruker blir meldt inn på nytt i et kurs.';
$string['refreshpreview'] = 'Oppdater forhåndsvisning';
$string['regradeanyway'] = 'Gi nye karakterer likevel';
$string['removeallcoursegrades'] = 'Alle karakterer';
$string['removeallcoursegrades_help'] = 'Hvis det er krysset av, slettes alle karakterelementer og karakterer som ble manuelt lagt til karakterboken, samt data om overstyrte, ekskluderte, skjulte og låste karakterer. Kun karakterelementer og karakterer knyttet til aktiviteter blir stående.';
$string['removeallcourseitems'] = 'Alle enheter og kategorier';
$string['removeallcourseitems_help'] = 'Dersom avmerket, vil alle kategorier og karakterelementer som er manuelt lagt til i karakterboka bli slettet  - sammen med karakterer og overstyringsdata, eksludert og låste karakterer. Bare karakterelementer assossiert med aktiviteten vil bli beholdt.';
$string['report'] = 'Rapport';
$string['reportdefault'] = 'Rapport standard ({$a})';
$string['reportplugins'] = 'Rapportmoduler';
$string['reportsettings'] = 'Rapportinnstillinger';
$string['reprintheaders'] = 'Gjenta kolonneoverskrifter';
$string['resetweights'] = 'Tilbakestill vekting av {$a->itemname}';
$string['resetweightsshort'] = 'Tilbakestill vektingen';
$string['respectingcurrentdata'] = 'lar nåværende konfigurasjon stå uendret';
$string['rowpreviewnum'] = 'Forhåndsvis rader';
$string['rowpreviewnum_help'] = 'Importdata kan forhåndsvises før endelig import. Denne innstillingen bestemmer hvor mange rader som skal forhåndsvises.';
$string['savechanges'] = 'Lagre endringer';
$string['savepreferences'] = 'Lagre innstillinger';
$string['scaleconfirmdelete'] = 'Er du sikker på at du vil slette denne skalaen: {$a}?';
$string['scaledpct'] = 'Skalert %';
$string['searchcollapsedcolumns'] = 'Søk i minimerte kolonner';
$string['seeallcoursegrades'] = 'Se alle kurskarakterer';
$string['select'] = 'Velg {$a}';
$string['selectalloroneuser'] = 'Velg alle eller en bruker';
$string['selectauser'] = 'Velg en bruker';
$string['selectdestination'] = 'Velg mål for {$a}';
$string['selectgrouplink'] = 'Velg en gruppe';
$string['selectuserlink'] = 'Velg en bruker';
$string['separator'] = 'Delingstegn';
$string['separator_help'] = 'Velg separatoren som brukes i csv-filen. (Vanligvis er det komma)';
$string['sepcolon'] = 'Kolon';
$string['sepcomma'] = 'Komma';
$string['sepsemicolon'] = 'Semikolon';
$string['septab'] = 'Tabulator';
$string['setcategories'] = 'Sett kategorier';
$string['setcategorieserror'] = 'You must first set the categories for your course before you can give weights to them.';
$string['setgradeletters'] = 'Sett bokstavkarakterer';
$string['setpreferences'] = 'Sett innstillinger';
$string['setting'] = 'Innstilling';
$string['settings'] = 'Innstillinger';
$string['setup'] = 'Oppsett';
$string['setweights'] = 'Sett vektinger';
$string['showactivityicons'] = 'Vis aktivitetsikoner';
$string['showactivityicons_help'] = '<p>Hvorvidt aktivitetsikoner skal vises ved siden av aktivitetsnavn.</p>';
$string['showallgrades'] = 'Vis alle karakterer';
$string['showallhidden'] = 'Vis skjulte';
$string['showallstudents'] = 'Vis alle studenter';
$string['showanalysisicon'] = 'Vis karakteranalyseikonet';
$string['showanalysisicon_desc'] = 'Skal karakteranalyseikonet vises som standard? Hvis aktivitetsmodulen støtter det, vil karakteranalyseikonet lenke til en side med en mer detaljert utredning om karakteren og hvordan den ble oppnådd.';
$string['showanalysisicon_help'] = 'Hvis aktivitetsmodulen støtter det, vil karakteranalyseikonet lenke til en side med en mer detaljert begrunnelse for karakteren og hvordan den ble oppnådd.';
$string['showaverage'] = 'Vis gjennomsnitt';
$string['showaverage_help'] = 'Vise gjennomsnittkolonnen? Merk at studenter kan bli i stand til å finne ut av medstudenters karakterer dersom gjennomsnittet blir beregnet på et lite antall studenter og karakterer. Av ytelseshensyn er gjennomsnitt omtrentlig beregnet dersom den baserer seg på skjulte elementer.';
$string['showaverages'] = 'Vis kolonnegjennomsnitt';
$string['showaverages_help'] = 'Om en skal vise middelverdien for hver kolonne.';
$string['showcalculations'] = 'Vis beregninger';
$string['showcalculations_help'] = 'Når aktivert, vises et kalkulatorikon ved hvert karakterelement og kategori med en visuell indikator for at karakterelementene blir beregnet.';
$string['showcontributiontocoursetotal'] = 'Vis bidraget til kurstotalen';
$string['showcontributiontocoursetotal_help'] = 'Om det skal vises en tilleggskolonne med det prosenter som viser hvor mye hvert karakterelement bidrar til kurstotalen (etter at vektingen er gjennomført)';
$string['showeyecons'] = 'Vis vis/skjul ikoner';
$string['showeyecons_help'] = 'Om en skal vise/skjule ikon i nærheten av hver karakter (kontrollerer synbarheten for bruker).';
$string['showfeedback'] = 'Vis tilbakemelding';
$string['showfeedback_help'] = 'Om tilbakemeldingskolonnen skal vises eller ikke';
$string['showgrade'] = 'Vis karakterer';
$string['showgrade_help'] = 'Om karakterkolonnen skal vises eller ikke';
$string['showgroups'] = 'Vis grupper';
$string['showhiddenitems'] = 'Vis skjulte elementer';
$string['showhiddenitems_help'] = 'Angir hvordan skjulte karakterenheter vises.

Hvis Skjul er valgt, er fullstendig skjult. Hvis Vis er valgt, vil den skjulte karakteren vises i grått med karakteren skjult fullstendig. Hvis "Bare skjult til" er valgt, vil karakteren skjules til datoen som vises i grått med karakteren skjult fullstendig til angitt dato, hvor hele karakterenheten vises.';
$string['showhiddenuntilonly'] = 'Skjult til:';
$string['showingaggregatesonly'] = 'Viser kun totaler';
$string['showingfullmode'] = 'Viser karakterer og totaler';
$string['showinggradesonly'] = 'Viser kun karakterer';
$string['showlettergrade'] = 'Vis bokstavkarakterer';
$string['showlettergrade_help'] = 'Om bokstavkarakterkolonnen skal vises eller ikke';
$string['showlocks'] = 'Vis låser';
$string['showlocks_help'] = 'Om en skal vise et lås/lås-opp ikon nær karakteren';
$string['shownohidden'] = 'Skjul';
$string['shownooutcomes'] = 'Skjul læringsutbytte';
$string['shownumberofgrades'] = 'Vis antall karakterer i gjennomsnitt';
$string['shownumberofgrades_help'] = 'Om en skal vise antall karakter som brukes for å regne ut middelverdien i parantes etter hvert gjennomsnitt, for eksempel 45 (34).';
$string['showonlyactiveenrol'] = 'Vis kun aktive påmeldinger';
$string['showonlyactiveenrol_help'] = 'Denne innstillingen bestemmer om bare aktive påmeldte brukere skal være synlige i karakterboka. Hvis aktivert, blir ikke utestengte brukere vises i karakterboken.';
$string['showpercentage'] = 'Vis prosent';
$string['showpercentage_help'] = 'Om det skal vises en prosentverdi av hvert karakterelement eller ikke';
$string['showquickfeedback'] = 'Vis hurtigtilbakemelding';
$string['showquickfeedback_help'] = 'Hurtig tilbakemelding legger til et tekstelement i hver karaktercelle i lærerrapporten, og gjør at du kan redigere tilbakemelding for mange karakterer på en gang. Du kan så klikke på Oppdaterknappen for å gjennomføre alle disse endringene med en gang, istedet for en om gangen.';
$string['showrange'] = 'Vis spekter';
$string['showrange_help'] = 'Om kolonnen med variasjonsbredden skal vises eller ikke';
$string['showranges'] = 'Vis områder';
$string['showranges_help'] = 'Om en skal vise utvalget av karakterer for hver kolonne i en ekstra rekke';
$string['showrank'] = 'Vis rangering';
$string['showrank_help'] = 'Om en skal vise brukerens rangering for hvert karakterelement i forhold til resten av deltakerne eller ikke';
$string['showuserimage'] = 'Vis brukers profilbilde';
$string['showuserimage_help'] = 'Om en skal vise brukerens profilbilde ved siden av navnet i lærerrapporten.';
$string['showverbose'] = 'Vis {$a->category} {$a->itemmodule} {$a->itemname}';
$string['showweight'] = 'Vis vektinger';
$string['showweight_help'] = 'Om kolonnen for karaktervekting skal vises eller ikke.';
$string['simpleview'] = 'Enkeltvisning';
$string['sitewide'] = 'Portalgjeldende';
$string['sort'] = 'sorter';
$string['sortasc'] = 'Sorter i stigende rekkefølge';
$string['sortbyfirstname'] = 'Sorter etter fornavn';
$string['sortbylastname'] = 'Sorter etter etternavn';
$string['sortdesc'] = 'Sorter i synkende orden';
$string['standarddeviation'] = 'Standardavvik';
$string['stats'] = 'Statistikk';
$string['statslink'] = 'Stats';
$string['student'] = 'Student';
$string['studentsperpage'] = 'Studenter per side';
$string['studentsperpage_help'] = 'Antall studenter å vise per side i lærerrapporten.';
$string['studentsperpagereduced'] = 'Redusert maks antall studenter per side fra {$a->originalstudentsperpage} til {$a->studentsperpage}. Vurder å øke PHP-innstillingen max_input_vars fra {$a->maxinputvars}.';
$string['subcategory'] = 'Normal kategori';
$string['submissions'] = 'Innsendelser';
$string['submittedon'] = 'Levert: {$a}';
$string['sumofgradesupgradedgrades'] = 'En nylig oppdatering har endret beregningsmetoden "Sum av alle karakterer" til "Naturlig". Vennligst se over karakterene i dette kurset siden det brukte "Sum av alle karakterer" før.';
$string['switchtofullview'] = 'Bytt til full visning';
$string['switchtosimpleview'] = 'Bytt til forenklet visning';
$string['topcategory'] = 'Superkategori';
$string['total'] = 'Total';
$string['totalweight100'] = 'Total vekting er lik 100';
$string['totalweightnot100'] = 'Total vekting er ikke lik 100';
$string['turnfeedbackoff'] = 'Slå av tilbakemelding';
$string['turnfeedbackon'] = 'Slå på tilbakemelding';
$string['typenone'] = 'Ingen';
$string['typescale'] = 'Skala';
$string['typescale_help'] = '<p>Når du bruker karaktertypen "Skala", kan en skala velges. Skalaen for en aktivitetsbasert karakter blir satt ved ved å oppdatere innstillingene for aktiviteten det gjelder.</p>';
$string['typetext'] = 'Tekst';
$string['typevalue'] = 'Verdi';
$string['uncategorised'] = 'Ukategorisert';
$string['unchangedgrade'] = 'Karakter uendret';
$string['unenrolledusersinimport'] = 'Importen inkluderte følgende karakterer for brukere som for tiden ikke er med i kurset: {$a}';
$string['unlimitedgrades'] = 'Ingen karakterbegrensning';
$string['unlimitedgrades_help'] = 'Som standard avgrenses karakterer av en minimums- og maksimumsverdi for den karakteren. Ved aktivering overstyrer du denne grensen og tillater at karakterer over 100% kan skrives inn manuelt. Vi anbefaler at denne innstillingen gjøres på en rolig tid på døgnet, da den medfører omberegning av karakterer og høy serverbelastning.';
$string['unlock'] = 'Lås opp';
$string['unlockverbose'] = 'Lås opp {$a->category} {$a->itemmodule} {$a->itemname}';
$string['unused'] = 'Ubrukt';
$string['updatedgradesonly'] = 'Eksporter bare nye eller oppdaterte karakter';
$string['upgradedgradeshidemessage'] = 'Ignorer melding';
$string['upgradedminmaxrevertmessage'] = 'Gjør om endringene';
$string['uploadgrades'] = 'Last opp karakterer';
$string['useadvanced'] = 'Bruk avanserte egenskaper';
$string['usedcourses'] = 'Brukte kurs';
$string['usedgradeitem'] = 'Brukt karakterenhet';
$string['usenooutcome'] = 'Ikke bruk læringsutbytte';
$string['usenoscale'] = 'Ikke bruk skala';
$string['usepercent'] = 'Bruk prosent';
$string['user'] = 'Bruker';
$string['userenrolmentsuspended'] = 'Brukerpåmelding avbrutt';
$string['userfields_show'] = 'Vis brukerfelt';
$string['userfields_show_help'] = 'Vis flere brukerfelt (f.eks. epostadresse) i karakterrapporten. Feltene som skal vises bestemmes av portalinnstillingen showuseridentity';
$string['usergrade'] = 'Bruker {$a->fullname} ({$a->useridnumber}) om emnet {$a->gradeidnumber}';
$string['userid'] = 'Bruker ID';
$string['useridnumberwarning'] = 'Brukere uten et ID-nummer er ekskludert fra eksporten fordi de ikke kan importeres.';
$string['usermappingerror'] = 'Feil i brukermappingen: Fant ikke bruker med {$a->field} av "{$a->value}".';
$string['usermappingerrorcurrentgroup'] = 'Bruker er ikke medlem av gjeldende gruppe.';
$string['usermappingerrormultipleusersfound'] = 'Feil brukermapping: Flere brukere funnet med {$a->field} av "{$a->value}". Vennligst bruk et mer unikt mappefelt.';
$string['usermappingerrorusernotfound'] = 'Feil i brukermappingen. Fant ikke brukeren.';
$string['userpreferences'] = 'Brukerinnstillinger';
$string['useweighted'] = 'Bruk vektet';
$string['verbosescales'] = 'Utvidede skalaer';
$string['verbosescales_help'] = 'En ordbaserte skala bruker ord i stedet for tall. Sett til \'Ja\' hvis både numeriske og ordbaserte skalaer skal importeres. Sett til \'Nei\' hvis bare numeriske skalaer skal importeres.';
$string['viewas'] = 'Vis rapport som';
$string['viewbygroup'] = 'Gruppe';
$string['viewfeedback'] = 'Vis tilbakemelding';
$string['viewgrades'] = 'Se karakterer';
$string['weight'] = 'Vekting';
$string['weight_help'] = 'En verdi som brukes til å bestemme den relative verdien av flere karakterelementer i en kategori eller et kurs.';
$string['weightcourse'] = 'Bruk vektede karakterer for dette kurset';
$string['weightedascending'] = 'Sorter etter vektet prosent stigende';
$string['weighteddescending'] = 'Sorter etter vektet prosent synkende';
$string['weightedpct'] = 'vektet %';
$string['weightedpctcontribution'] = 'vektet % bidrag';
$string['weightofa'] = 'Vekting av {$a}';
$string['weightorextracredit'] = 'Vekting eller tilleggspoeng';
$string['weightoverride'] = 'Vektingstilpasning';
$string['weightoverride_help'] = 'Fjern avkrysningen for å tilbakestille vektingen av et karakterelement til standardverdien. Avkrysning her vil forhindre at vektingen justeres automatisk.';
$string['weights'] = 'Vekting';
$string['weightsadjusted'] = 'Vektingen har blitt justert slik at totalen er 100.';
$string['weightsedit'] = 'Rediger vekting og tilleggspoeng';
$string['weightuc'] = 'Vekting';
$string['writinggradebookinfo'] = 'Skriver karakterbokinnstillinger';
$string['xml'] = 'XML';
$string['yes'] = 'Ja';
$string['yourgrade'] = 'Din karakter';
