<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'forum', language 'id', version '4.5'.
 *
 * @package     forum
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actionsforgraderinterface'] = 'Aksi untuk antarmuka pemberi nilai';
$string['actionsforpost'] = 'Aksi untuk kiriman';
$string['activitydate:due'] = 'Jatuh tempo:';
$string['activityoverview'] = 'Terdapat pesan baru pada forum';
$string['addanewdiscussion'] = 'Tambahkan topik diskusi';
$string['addanewquestion'] = 'Tambahkan pertanyaan baru';
$string['addanewtopic'] = 'Tambahkan topik baru';
$string['addreply'] = 'Tambahkan balasan';
$string['addtofavourites'] = 'Bintangi diskusi ini';
$string['advancedsearch'] = 'Pencarian lanjutan';
$string['alldiscussions'] = 'Semua diskusu';
$string['allforums'] = 'Semua forum';
$string['allowdiscussions'] = 'Dapatkah {$a} mengirim ke forum ini?';
$string['allowsallsubscribe'] = 'Forum ini memungkinkan setiap orang untuk memilih apakah akan berlangganan atau tidak';
$string['allowsdiscussions'] = 'Forum ini memungkinkan setiap orang untuk memulai satu topik diskusi.';
$string['allsubscribe'] = 'Berlangganan semua forum';
$string['allunsubscribe'] = 'Berhenti berlangganan dari semua forum';
$string['allusers'] = 'Semua pengguna';
$string['alreadyfirstpost'] = 'Ini sudah menjadi kiriman pertama dalam diskusi';
$string['announcementsettings'] = 'Setelan Forum Pengumuman Bawaan';
$string['announcementsettings_help'] = 'Setalan ini menentukan bawaan untuk semua forum pengumuman.';
$string['anyfile'] = 'Berkas apapun';
$string['areaattachment'] = 'Lampiran';
$string['areapost'] = 'Pesan';
$string['attachment'] = 'Lampiran';
$string['attachment_help'] = 'Secara opsional, Anda dapat melampirkan satu atau beberapa berkas pada kiriman forum. Jika Anda melampirkan gambar, itu akan ditampilkan setelah pesan.';
$string['attachmentname'] = 'Lampiran {$a}';
$string['attachmentnameandfilesize'] = '{$a->name} ({$a->size})';
$string['attachmentnopost'] = 'Anda tidak dapat mengekspor lampiran tanpa ID kiriman';
$string['attachments'] = 'Lampiran';
$string['attachmentswordcount'] = 'Lampiran dan jumlah kata';
$string['authorreplyingprivatelytoauthor'] = '{$a->respondant} balas pribadi ke {$a->author}';
$string['authorreplyingtoauthor'] = '{$a->respondant} balas ke {$a->author}';
$string['availability'] = 'Ketersediaan';
$string['blockafter'] = 'Ambang batas kiriman untuk memblokir';
$string['blockafter_help'] = 'Tidak ada data yang tersedia untuk kombinasi kursus dan periode waktu tersebut';
$string['blockperiod'] = 'Periode waktu pemblokiran';
$string['blockperiod_help'] = 'Siswa dapat diblokir dari kiriman apabila melakukan kiriman dari jumlah yang ditentukan dalam jangka waktu tertentu. Pengguna dengan kemampuan mod/forum:postwithoutthrottling dikecualikan dari batas kiriman.';
$string['blockperioddisabled'] = 'Jangan blokir';
$string['blogforum'] = 'Forum standar ditampilkan dalam format seperti blog';
$string['bynameondate'] = 'oleh {$a->name} - {$a->date}';
$string['cachedef_forum_count_discussions'] = 'Diskusi forum penting';
$string['cachedef_forum_is_tracked'] = 'Status pelacakan forum untuk pengguna';
$string['calendardue'] = '{$a} jatuh tempo';
$string['cancelreply'] = 'Batalkan balasan';
$string['cannotadd'] = 'Tidak bisa menambahkan diskusi untuk forum ini';
$string['cannotadddiscussion'] = 'Anda harus menjadi anggota grup untuk menambahkan diskusi ke forum ini';
$string['cannotadddiscussionall'] = 'Anda tidak memiliki izin untuk menambahkan topik diskusi untuk semua peserta.';
$string['cannotadddiscussiongroup'] = 'Anda tidak dapat membuat diskusi karena Anda bukan anggota grup mana pun.';
$string['cannotaddsubscriber'] = 'Tidak dapat menambahkan pelanggan dengan ID {$a} ke forum ini!';
$string['cannotaddteacherforumto'] = 'Tidak dapat menambahkan model forum pengajar yang dikonversi ke Topik 0 dalam kursus';
$string['cannotcreatediscussion'] = 'Tidak dapat membuat diskusi baru';
$string['cannotcreateinstanceforteacher'] = 'Tidak dapat membuat model modul kursus baru untuk forum pengajar';
$string['cannotdeletepost'] = 'Anda tidak dapat menghapus kiriman ini!';
$string['cannoteditposts'] = 'Anda tidak dapat mengedit kiriman orang lain!';
$string['cannotexportforum'] = 'Anda tidak dapat mengekspor forum ini';
$string['cannotfavourite'] = 'Maaf, Anda tidak memiliki izin untuk membintangi diskusi.';
$string['cannotfinddiscussion'] = 'Tidak dapat menemukan diskusi tersebut dalam forum ini';
$string['cannotfindfirstpost'] = 'Tidak dapat menemukan kiriman pertama di forum ini';
$string['cannotfindorcreateforum'] = 'Tidak dapat menemukan atau membuat forum pengumuman utama untuk situs tersebut';
$string['cannotfindparentpost'] = 'Tidak dapat menemukan induk teratas dari kiriman {$a}';
$string['cannotmovefromsingleforum'] = 'Tidak dapat memindahkan diskusi dari sebuah forum diskusi sederhana';
$string['cannotmovenotvisible'] = 'Forum tidak terlihat';
$string['cannotmovetonotexist'] = 'Anda tidak dapat pindah ke forum itu - Forum tidak ada!';
$string['cannotmovetonotfound'] = 'Forum target tidak ditemukan dalam kursus ini.';
$string['cannotmovetosingleforum'] = 'Tidak dapat memindahkan diskusi ke suatu forum diskusi sederhana';
$string['cannotpindiscussions'] = 'Maaf, Anda tidak memiliki izin untuk menyematkan diskusi.';
$string['cannotpurgecachedrss'] = 'Tidak dapat membersihkan umpan RSS yang disinggahkan untuk forum sumber dan/atau tujuan - periksa berkas permissionsforums Anda';
$string['cannotremovesubscriber'] = 'Tidak dapat menghapus pelanggan dengan ID {$a} dari forum ini!';
$string['cannotreply'] = 'Anda tidak dapat membalas kiriman ini';
$string['cannotsplit'] = 'Diskusi dari forum ini tidak dapat dipisahkan';
$string['cannotsubscribe'] = 'Maaf, tetapi Anda harus menjadi anggota grup untuk berlangganan.';
$string['cannottrack'] = 'Tidak dapat berhenti melacak forum itu';
$string['cannotunsubscribe'] = 'Tidak dapat menghentikan langganan Anda dari forum tersebut';
$string['cannotupdatepost'] = 'Anda tidak dapat memperbarui kiriman ini';
$string['cannotuseseperategroupsandsingletopic'] = 'Grup terpisah tidak dapat digunakan dengan satu topik diskusi';
$string['cannotusesingletopicandseperategroups'] = 'Topik diskusi tunggal tidak dapat digunakan dengan kelompok terpisah';
$string['cannotviewpostyet'] = 'Anda belum bisa membaca kiriman siswa lain di diskusi ini karena belum mengirim pada forum.';
$string['cannotviewusersposts'] = 'Tidak ada kiriman yang dibuat oleh pengguna ini yang dapat Anda lihat.';
$string['cleanreadtime'] = 'Tandai kiriman lama sebagai jam baca';
$string['clicktofavourite'] = 'Anda belum membintangi diskusi ini. Klik untuk membintangi.';
$string['clicktolockdiscussion'] = 'Klik untuk mengunci diskusi ini';
$string['clicktosubscribe'] = 'Anda tidak berlangganan diskusi ini. Klik untuk berlangganan.';
$string['clicktounfavourite'] = 'Anda telah membintangi diskusi ini. Klik untuk  lepas tanda bintang.';
$string['clicktounlockdiscussion'] = 'Klik untuk membuka kunci diskusi ini';
$string['clicktounsubscribe'] = 'Anda berlangganan diskusi ini. Klik untuk berhenti berlangganan.';
$string['close'] = 'Tutup';
$string['closegrader'] = 'Tutup pemberi nilai';
$string['completiondetail:discussions'] = 'Mulai diskusi: {$a}';
$string['completiondetail:posts'] = 'Buat kiriman forum: {$a}';
$string['completiondetail:replies'] = 'Kirim balasan: {$a}';
$string['completiondiscussions'] = 'Mulai diskusi';
$string['completiondiscussionsdesc'] = 'Siswa harus membuat paling tidak  {$a} diskusi';
$string['completiondiscussionsgroup'] = 'Membutuhkan diskusi';
$string['completiondiscussionshelp'] = 'membutuhkan diskusi untuk diselesaikan';
$string['completionposts'] = 'Mulai diskusi atau kirim balasan';
$string['completionpostsdesc'] = 'Siswa harus memposting setidaknya {$a} diskusi atau balasan';
$string['completionpostsgroup'] = 'Membutuhkan kiriman';
$string['completionpostshelp'] = 'membutuhkan diskusi atau balasan untuk diselesaikan';
$string['completionpostsinforums'] = 'Kirim dalam forum';
$string['completionreplies'] = 'Kirim balasan';
$string['completionrepliesdesc'] = 'Siswa harus mengirim setidaknya {$a} balasan';
$string['completionrepliesgroup'] = 'Membutuhkan balasan';
$string['completionreplieshelp'] = 'membutuhkan balasan untuk diselesaikan';
$string['configcleanreadtime'] = 'Jam untuk membersihkan kiriman lama dari tabel \'baca\'.';
$string['configdigestmailtime'] = 'Orang yang memilih agar surel dikirim kepada mereka dalam bentuk intisari akan dikirimi intisari surel setiap hari. Setelan ini mengontrol jam berapa surel harian akan dikirim (cron berikutnya yang berjalan setelah jam ini akan mengirimkannya).';
$string['configdisplaymode'] = 'Mode tampilan bawaan untuk diskusi jika tidak disetel.';
$string['configenablerssfeeds'] = 'Tombol ini akan mengaktifkan kemungkinan umpan RSS untuk semua forum. Anda masih perlu mengaktifkan umpan secara manual di setelan untuk setiap forum.';
$string['configenabletimedposts'] = 'Setel ke \'ya\' jika Anda ingin mengizinkan setelan periode tampilan saat mengirim diskusi forum baru.';
$string['configlongpost'] = 'Kiriman apa pun yang melebihi panjang ini (dalam karakter tidak termasuk HTML) dianggap panjang. Kiriman yang ditampilkan di beranda situs, halaman kursus format sosial, atau profil pengguna disingkat menjadi jeda alami di antara nilai forum_shortpost dan forum_longpost.';
$string['configmanydiscussions'] = 'Jumlah diskusi maksimum yang ditampilkan di forum per halaman';
$string['configmaxattachments'] = 'Jumlah maksimum bawaan untuk lampiran yang diizinkan pada kiriman.';
$string['configmaxbytes'] = 'Ukuran maksimum untuk semua lampiran forum pada situs ( subjek pada limit kursus dan setelan lokal lainnya)';
$string['configoldpostdays'] = 'Jumlah hari setiap kiriman dianggap telah terbaca.';
$string['configreplytouser'] = 'Ketika kiriman forum diposkan, haruskah itu berisi alamat surel pengguna sehingga penerima dapat membalas secara pribadi alih-alih melalui forum? Bahkan jika disetel ke \'Ya\', pengguna dapat memilih di profil mereka untuk merahasiakan alamat surel mereka.';
$string['configrssarticlesdefault'] = 'Jika umpan RSS diaktifkan, setel jumlah artikel bawaan (baik diskusi atau kiriman).';
$string['configrsstypedefault'] = 'Jika umpan RSS diaktifkan, setel jenis aktivitas bawaan.';
$string['configshortpost'] = 'Setiap kiriman dengan panjang (dalam karakter tidak termasuk HTML) dianggap pendek (lihat di bawah).';
$string['configsubscriptiontype'] = 'Setelan bawaan untuk mode berlangganan.';
$string['configtrackingtype'] = 'Setelan bawaan untuk pelacakan membaca.';
$string['configtrackreadposts'] = 'Setel ke \'ya\' jika Anda ingin melacak telah dibaca/belum dibaca untuk setiap pengguna.';
$string['configusermarksread'] = 'Jika \'ya\', pengguna harus menandai kiriman menjadi telah dibaca secara manual. Jika \'tidak\', saat kiriman dilihat akan ditandai sudah dibaca.';
$string['confirmsubscribe'] = 'Anda yakin ingin berlangganan forum \'{$a}\'?';
$string['confirmsubscribediscussion'] = 'Anda yakin ingin berlangganan diskusi \'{$a->discussion}\' pada forum \'{$a->forum}\'?';
$string['confirmunsubscribe'] = 'Anda yakin ingin berhenti berlangganan dari forum \'{$a}\'?';
$string['confirmunsubscribediscussion'] = 'Anda yakin ingin berhenti berlangganan dari diskusi {$a->discussion}\' pada forum \'{$a->forum}\'?';
$string['couldnotadd'] = 'Tidak dapat menambahkan kiriman Anda karena galat yang tidak diketahui';
$string['couldnotdeletereplies'] = 'Maaf, itu tidak dapat dihapus karena telah ada orang yang menanggapinya';
$string['couldnotupdate'] = 'Tidak dapat memperbarui kiriman Anda karena galat yang tidak diketahui';
$string['created'] = 'Dibuat';
$string['crontask'] = 'Persuratan forum dan pekerjaan pemeliharaan';
$string['cutoffdate'] = 'Tanggal batas akhir kiriman';
$string['cutoffdate_help'] = 'Jika disetel, forum tidak akan menerima kiriman setelah tanggal ini.';
$string['cutoffdatereached'] = 'Sudah mencapai batas waktu untuk mengirim ke forum ini sehingga Anda tidak dapat lagi mengirim ke forum ini.';
$string['cutoffdatevalidation'] = 'Tanggal batas akhir tidak boleh lebih awal dari tanggal jatuh tempo.';
$string['delete'] = 'Hapus';
$string['deleteddiscussion'] = 'Topik diskusi telah dihapus';
$string['deletedpost'] = 'Kiriman telah dihapus';
$string['deletedposts'] = 'Kiriman tersebut telah dihapus';
$string['deleteduser'] = 'Pengguna terhapus';
$string['deletesure'] = 'Apakah Anda yakin ingin menghapus kiriman ini?';
$string['deletesureplural'] = 'Apakah Anda yakin ingin menghapus kiriman ini dan semua balasan? ({$a} posts)';
$string['digestmailheader'] = 'Ini adalah intisari harian Anda untuk kiriman baru dari forum {$a->sitename}. Untuk mengubah preferensi surel forum bawaan Anda, buka {$a->userprefs}.';
$string['digestmailpost'] = 'Ubah preferensi intisari forum Anda';
$string['digestmailpostlink'] = 'Ubah preferensi intisari forum Anda: {$a}';
$string['digestmailprefs'] = 'profil pengguna Anda';
$string['digestmailsubject'] = '{$a}: intisari forum';
$string['digestmailtime'] = 'Jam untuk mengirim surel intisari';
$string['digestsentusers'] = 'Intisari surel berhasil dikirim ke {$a} pengguna.';
$string['disallowsubscribe'] = 'Tidak diizinkan berlangganan';
$string['disallowsubscribeteacher'] = 'Tidak diizinkan berlangganan (kecuali pengajar)';
$string['disallowsubscription'] = 'Berlangganan';
$string['disallowsubscription_help'] = 'Forum ini telah dikonfigurasi sehingga Anda tidak dapat berlangganan diskusi.';
$string['discussion'] = 'Diskusi';
$string['discussionlistsortbycreatedasc'] = 'Urut naik berdasarkan tanggal pembuatan';
$string['discussionlistsortbycreateddesc'] = 'Urut turun berdasarkan tanggal pembuatan';
$string['discussionlistsortbydiscussionasc'] = 'Urut naik berdasarkan nama diskusi';
$string['discussionlistsortbydiscussiondesc'] = 'Urut turun berdasarkan nama diskusi';
$string['discussionlistsortbygroupasc'] = 'Urut naik berdasarkan grup';
$string['discussionlistsortbygroupdesc'] = 'Urut turun berdasarkan grup';
$string['discussionlistsortbylastpostasc'] = 'Urut naik berdasarkan tanggal kiriman forum terakhir';
$string['discussionlistsortbylastpostdesc'] = 'Urut turun berdasarkan tanggal kiriman forum terakhir';
$string['discussionlistsortbyrepliesasc'] = 'Urut naik berdasarkan jumlah tanggapan';
$string['discussionlistsortbyrepliesdesc'] = 'Urut turun berdasarkan jumlah tanggapan';
$string['discussionlistsortbystarterasc'] = 'Urut naik berdasarkan nama pembuka diskusi';
$string['discussionlistsortbystarterdesc'] = 'Urut turun berdasarkan nama pembuka diskusi';
$string['discussionlocked'] = 'Diskusi ini telah dikunci sehingga Anda tidak dapat lagi menanggapinya.';
$string['discussionlockingdisabled'] = 'Jangan kunci diskusi';
$string['discussionlockingheader'] = 'Penguncian diskusi';
$string['discussionmoved'] = 'Diskusi ini telah dipindahkan ke \'{$a}\'.';
$string['discussionmovedpost'] = 'Diskusi ini telah dipindahkan ke "{$a->discusshref}">sini</a> pada forum <a href="{$a->forumhref}">{$a->forumname}</a>';
$string['discussionname'] = 'Nama diskusi';
$string['discussionnownotsubscribed'] = '{$a->name} TIDAK akan diberitahu kiriman baru di \'{$a->discussion}\' dari \'{$a->forum}\'';
$string['discussionnowsubscribed'] = 'Anda akan diberitahu tentang kiriman baru di \'{$a->discussion}\' di forum \'{$a->forum}\'.';
$string['discussionpin'] = 'Semat';
$string['discussionpinned'] = 'Sematkan';
$string['discussionpinned_help'] = 'Diskusi yang disematkan akan berada paling atas.';
$string['discussions'] = 'Diskusi';
$string['discussionsplit'] = 'Diskusi telah dipisah';
$string['discussionsstartedby'] = 'Diskusi dimulai oleh {$a}';
$string['discussionsstartedbyrecent'] = 'Diskusi baru saja dimulai oleh {$a}';
$string['discussionsstartedbyuserincourse'] = 'Diskusi dimulai oleh {$a->fullname} pada {$a->coursename}';
$string['discussionsstartedincourse'] = 'Diskusi dimulai pada {$a}';
$string['discussionstartedby'] = 'Diskusi dimulai oleh {$a}';
$string['discussionsubscribed'] = 'Sekarang Anda berlangganan diskusi ini.';
$string['discussionsubscribestart'] = 'Kirim saya pemberitahuan tentang kiriman baru dalam diskusi ini';
$string['discussionsubscribestop'] = 'Saya tidak ingin diberi tahu tentang kiriman baru dalam diskusi ini';
$string['discussionsubscription'] = 'Diskusi berlangganan';
$string['discussionsubscription_help'] = 'Berlangganan ke diskusi berarti Anda akan menerima pemberitahuan kiriman baru ke diskusi itu.';
$string['discussionunpin'] = 'Lepas semat';
$string['discussionunsubscribed'] = 'Anda sekarang berhenti berlangganan dari diskusi ini.';
$string['discussthistopic'] = 'Diskusikan topik ini';
$string['discusstopicname'] = 'Diskusikan topik: {$a}';
$string['displayend'] = 'Ditampilkan sampai';
$string['displayend_help'] = 'Setelan ini menentukan apakah kiriman forum harus disembunyikan setelah tanggal tertentu. Perhatikan bahwa administrator selalu dapat melihat kiriman forum.';
$string['displayenddate'] = 'Ditampilkan sampai : {$a}.';
$string['displaymode'] = 'Mode tampilan';
$string['displayperiod'] = 'Periode tampil';
$string['displaystart'] = 'Mulai ditampilkan';
$string['displaystart_help'] = 'Setelan ini menentukan apakah posting forum harus ditampilkan dari tanggal tertentu. Perhatikan bahwa administrator selalu dapat melihat kiriman forum.';
$string['displaystartdate'] = 'Mulai tampil: {$a}.';
$string['displaywordcount'] = 'Tampilkan jumlah kata';
$string['displaywordcount_help'] = 'Setelan ini menentukan apakah jumlah kata dari setiap kiriman harus ditampilkan atau tidak.';
$string['duedate'] = 'Tanggal jatuh tempo';
$string['duedate_help'] = 'Ini adalah saat posting di forum sudah jatuh tempo. Meskipun tanggal ini ditampilkan di kalender sebagai tanggal jatuh tempo forum, Kiriman diskusi masih diperbolehkan setelah tanggal ini. Tetapkan tanggal batas forum untuk mencegah kiriman ke forum setelah tanggal tertentu.';
$string['duedatetodisplayincalendar'] = 'Tanggal jatuh tempo yang ditampilkan di kalender';
$string['eachuserforum'] = 'Setiap orang kirim satu diskusi';
$string['edit'] = 'Edit';
$string['editdiscussion'] = 'Edit diskusi';
$string['editdiscussiontopic'] = 'Edit topik diskusi';
$string['editedby'] = 'Diedit oleh {$a->name} - kiriman asli {$a->date}';
$string['editedpostupdated'] = 'Kiriman {$a} telah diperbarui';
$string['editing'] = 'Pengeditan';
$string['emaildigestcompleteshort'] = 'Lengkapi kiriman';
$string['emaildigestdefault'] = 'Bawaan ({$a})';
$string['emaildigestoffshort'] = 'Tidak dirangkum';
$string['emaildigestsubjectsshort'] = 'Hanya subjek';
$string['emaildigesttype'] = 'Opsi intisari surel';
$string['emaildigesttype_help'] = 'Jenis pemberitahuan yang akan Anda terima untuk setiap forum.
<ul><li> Bawaan - ikuti setelan rangkuman yang ditemukan di profil pengguna Anda. Jika Anda memperbarui profil Anda, maka perubahan itu akan tercermin di sini juga;
</li><li> Tidak dirangkum - Anda akan menerima satu surel per kiriman forum;
</li><li> Intisari - kiriman lengkap - Anda akan menerima satu rangkuman surel per hari yang berisi konten lengkap dari setiap kiriman forum;
</li><li> Intisari - hanya subjek - Anda akan menerima satu rangkuman surel per hari yang hanya berisi subjek setiap kiriman forum.</li><ul>';
$string['emptymessage'] = 'Ada yang salah dengan kiriman Anda. Mungkin Anda membiarkannya kosong, atau lampirannya terlalu besar. Perubahan Anda BELUM disimpan.';
$string['errorcannotlock'] = 'Anda tidak memiliki izin untuk mengunci diskusi.';
$string['errordiscussionnotfound'] = 'Diskusi tidak ditemukan';
$string['erroremptymessage'] = 'Pesan kiriman tidak boleh kosong';
$string['erroremptysubject'] = 'Subjek kiriman tidak boleh kosong.';
$string['errorenrolmentrequired'] = 'Anda harus terdaftar dalam kursus ini untuk mengakses konten ini';
$string['errorforumnotfound'] = 'Forum tempat diskusi ini tidak ditemukan';
$string['errorwhiledelete'] = 'Galat saat menghapus rekaman.';
$string['eventassessableuploaded'] = 'Mengirim beberapa konten.';
$string['eventcoursesearched'] = 'Mencari kursus';
$string['eventdiscussioncreated'] = 'Membuat diskusi';
$string['eventdiscussiondeleted'] = 'Menghapus diskusi';
$string['eventdiscussionlockupdated'] = 'Kunci diskusi diperbarui';
$string['eventdiscussionmoved'] = 'Memindah diskusi';
$string['eventdiscussionpinned'] = 'Menyematkan diskusi';
$string['eventdiscussionsubscriptioncreated'] = 'Membuat langganan diskusi';
$string['eventdiscussionsubscriptiondeleted'] = 'Menghapus langganan diskusi';
$string['eventdiscussionunpinned'] = 'Lepas semat diskusi';
$string['eventdiscussionupdated'] = 'Memperbarui diskusi';
$string['eventdiscussionviewed'] = 'Melihat diskusi';
$string['eventforumsubscriptionupdated'] = 'Mode langganan diperbarui';
$string['eventpostcreated'] = 'Membuat kiriman';
$string['eventpostdeleted'] = 'Menghapus kiriman';
$string['eventpostupdated'] = 'Memperbarui kiriman';
$string['eventreadtrackingdisabled'] = 'Menonaktifkan pelacakan baca';
$string['eventreadtrackingenabled'] = 'Mengaktifkan pelacakan baca';
$string['eventsubscribersviewed'] = 'Melihat pelanggan';
$string['eventsubscriptioncreated'] = 'Membuat berlangganan';
$string['eventsubscriptiondeleted'] = 'Menghapus langganan';
$string['eventuserreportviewed'] = 'Melihat laporan pengguna';
$string['everyonecanchoose'] = 'Setiap orang dapat memilih untuk berlangganan';
$string['everyonecannowchoose'] = 'Setiap orang sekarang dapat memilih untuk berlangganan';
$string['everyoneisnowsubscribed'] = 'Semua orang sekarang berlangganan forum ini';
$string['everyoneissubscribed'] = 'Semua orang berlangganan forum ini';
$string['existingsubscribers'] = 'Pelanggan yang sudah ada';
$string['export'] = 'Ekspor';
$string['exportattachmentname'] = 'Ekspor lampiran {$a} ke portofolio';
$string['exportdiscussion'] = 'Ekspor seluruh diskusi ke portofolio';
$string['exporthumandates'] = 'Tanggal yang terbaca manusia';
$string['exporthumandates_help'] = 'Apakah tanggal harus diekspor dalam format yang dapat dibaca manusia atau sebagai stempel waktu (urutan angka).';
$string['exportoptions'] = 'Opsi ekspor';
$string['exportstriphtml'] = 'Hapus HTML';
$string['exportstriphtml_help'] = 'Apakah tag HTML seperti p dan br harus dihapus dari pesan kiriman forum.';
$string['favourites'] = 'Berbintang';
$string['favouriteupdated'] = 'Opsi bintang Anda telah diperbarui.';
$string['firstpost'] = 'Kiriman pertama';
$string['forcedreadtracking'] = 'Izinkan pelacakan baca paksa';
$string['forcedreadtracking_desc'] = 'Izinkan forum disetel ke pelacakan baca paksa. Akan mengakibatkan penurunan kinerja untuk beberapa pengguna, terutama pada kursus dengan banyak forum dan kiriman. Jika nonaktif, forum apa pun yang sebelumnya disetel ke Paksa dianggap opsional.';
$string['forcesubscribed'] = 'Forum ini memaksa setiap orang untuk berlangganan';
$string['forcesubscribed_help'] = 'Forum ini telah dikonfigurasi sehingga Anda tidak dapat berhenti berlangganan diskusi.';
$string['forum'] = 'Forum';
$string['forum:addinstance'] = 'Tambahkan forum baru';
$string['forum:addnews'] = 'Tambahkan pengumuman';
$string['forum:addquestion'] = 'Tambahkan pertanyaan';
$string['forum:allowforcesubscribe'] = 'Izinkan berlangganan paksa';
$string['forum:canmailnow'] = 'Dapat mengirim ke forum Tanya Jawab tanpa penundaan waktu pengeditan';
$string['forum:canoverridecutoff'] = 'Posting ke forum setelah tanggal batas akhir kiriman forum mereka';
$string['forum:canoverridediscussionlock'] = 'Balas ke diskusi yang terkunci';
$string['forum:canposttomygroups'] = 'Poskan ke semua grup yang aksesnya Anda miliki';
$string['forum:cantogglefavourite'] = 'Bintangi diskusi';
$string['forum:createattachment'] = 'Buat lampiran';
$string['forum:deleteanypost'] = 'Hapus kiriman apa pun (kapan saja)';
$string['forum:deleteownpost'] = 'Hapus kiriman sendiri (dalam tenggat waktu)';
$string['forum:editanypost'] = 'Edit kiriman apa pun';
$string['forum:exportdiscussion'] = 'Ekspor seluruh diskusi';
$string['forum:exportforum'] = 'Ekspor forum';
$string['forum:exportownpost'] = 'Ekspor kiriman sendiri';
$string['forum:exportpost'] = 'Ekspor kiriman';
$string['forum:grade'] = 'Nilai forum';
$string['forum:managesubscriptions'] = 'Kelola pelanggan';
$string['forum:movediscussions'] = 'Pindahkan diskusi';
$string['forum:pindiscussions'] = 'Sematkan diskusi';
$string['forum:postprivatereply'] = 'Balas pribadi ke kiriman';
$string['forum:postwithoutthrottling'] = 'Dibebaskan dari ambang batas pos';
$string['forum:rate'] = 'Beri peringkat kiriman';
$string['forum:readprivatereplies'] = 'Lihat balasan pribadi';
$string['forum:replynews'] = 'Balas pengumuman';
$string['forum:replypost'] = 'Balas ke kiriman';
$string['forum:splitdiscussions'] = 'Pisahkan diskusi';
$string['forum:startdiscussion'] = 'Mulailah diskusi baru';
$string['forum:viewallratings'] = 'Lihat semua peringkat mentah yang diberikan oleh individu';
$string['forum:viewanyrating'] = 'Lihat peringkat total yang diterima siapa pun';
$string['forum:viewdiscussion'] = 'Lihat diskusi';
$string['forum:viewhiddentimedposts'] = 'Lihat kiirman berjangka waktu yang tersembunyi';
$string['forum:viewqandawithoutposting'] = 'Selalu lihat kiriman Tanya Jawab';
$string['forum:viewrating'] = 'Lihat nilai total yang Anda terima';
$string['forum:viewsubscribers'] = 'Lihat pelanggan';
$string['forumauthorhidden'] = 'Pengarang (tersembunyi)';
$string['forumblockingalmosttoomanyposts'] = 'Anda mendekati ambang pengeposan. Anda telah mengirim  {$a->numposts} kali dalam {{$a->blockperiod} terakhir dan batasnya adalah {$a->blockafter} kiriman.';
$string['forumbodydeleted'] = 'Konten kiriman forum ini telah dihapus dan tidak dapat diakses lagi.';
$string['forumbodyhidden'] = 'Kiriman ini saat ini disembunyikan, kemungkinan besar karena Anda harus mengirim di diskusi terlebih dahulu dan notifikasi kiriman forum harus dikirim. Kemungkinan lain adalah bahwa waktu saat ini tidak berada dalam periode tampilan yang ditetapkan untuk mengirim.';
$string['forumgrader'] = 'Pemberi nilai forum';
$string['forumgradingnavigation'] = 'Navigasi penilaian forum';
$string['forumgradingpanel'] = 'Panel penilaian forum';
$string['forumintro'] = 'Deskripsi';
$string['forumname'] = 'Nama forum';
$string['forumposts'] = 'Kiriman forum';
$string['forums'] = 'Forum';
$string['forumsubjectdeleted'] = 'Kiriman forum ini telah dihapus';
$string['forumsubjecthidden'] = 'Subjek (sembunyikan)';
$string['forumtracked'] = 'Kiriman yang belum dibaca sedang dilacak';
$string['forumtrackednot'] = 'Kiriman yang belum dibaca tidak sedang dilacak';
$string['forumtype'] = 'Jenis forum';
$string['forumtype_help'] = 'Ada 5 jenis forum:

* Diskusi sederhana - Satu topik diskusi yang dapat dibalas semua orang (tidak dapat digunakan dengan grup terpisah)
* Setiap orang mengirim satu diskusi - Setiap siswa dapat mengirim tepat satu topik diskusi baru, yang kemudian dapat diakses semua orang membalas
* Forum Tanya Jawab - Siswa harus mengirim perspektif mereka terlebih dahulu sebelum melihat posting siswa lain
* Forum standar ditampilkan dalam format seperti blog - Forum terbuka di mana siapa saja dapat memulai diskusi baru kapan saja, dan di mana topik diskusi ditampilkan pada satu halaman dengan tautan "Diskusikan topik ini"
* Forum standar untuk penggunaan umum - Forum terbuka tempat siapa pun dapat memulai diskusi baru kapan saja';
$string['generalforum'] = 'Forum standar untuk penggunaan umum';
$string['generalforums'] = 'Forum umum';
$string['grade_forum_header'] = 'Penilaian seluruh forum';
$string['grade_forum_name'] = 'Seluruh forum';
$string['grade_forum_title'] = 'Nilai';
$string['grade_rating_name'] = 'Peringkat';
$string['graded'] = 'Dinilai';
$string['gradedby'] = 'Dinilai oleh';
$string['gradeforrating'] = 'Nilai untuk penilaian: {$a->str_long_grade}';
$string['gradeforratinghidden'] = 'Nilai untuk peringkat tersembunyi';
$string['gradeforwholeforum'] = 'Nilai untuk forum: {$a->str_long_grade}';
$string['gradeforwholeforumhidden'] = 'Nilai untuk forum tersembunyi';
$string['gradeitem:forum'] = 'Forum';
$string['gradeitemnameforrating'] = 'Nilai peringkat untuk {$a->name}';
$string['gradeitemnameforwholeforum'] = 'Seluruh nilai forum untuk {$a->name}';
$string['grades:gradesavedfor'] = 'Nilai disimpan untuk {$a->fullname}';
$string['grades:gradesavefailed'] = 'Tidak dapat menyimpan nilai untuk {$a->fullname}: {$a->error}';
$string['gradeusers'] = 'Nilai pengguna';
$string['grading'] = 'Menilai';
$string['gradingstatus'] = 'Status nilai:';
$string['hiddenforumpost'] = 'Kiriman forum tersembunyi';
$string['hidegraderpanel'] = 'Sembunyikan panel penilai';
$string['hidepreviousrepliescount'] = 'Sembunyikan balasan sebelumnya ({$a})';
$string['hideusersearch'] = 'Sembunyikan pencarian pengguna';
$string['indexoutoftotal'] = '{$a->index} dari {$a->total}';
$string['indicator:cognitivedepth'] = 'Forum kognitif';
$string['indicator:cognitivedepth_help'] = 'Indikator ini didasarkan pada kedalaman kognitif yang dicapai siswa dalam suatu kegiatan Forum.';
$string['indicator:cognitivedepthdef'] = 'Forum kognitif';
$string['indicator:cognitivedepthdef_help'] = 'Peserta telah mencapai persentase keterlibatan kognitif ini yang ditawarkan oleh aktivitas Forum selama interval analisis ini (Tingkatan = Tidak ada tampilan, Lihat, Ajukan, Lihat umpan balik, Komentari umpan balik, Ajukan ulang setelah melihat umpan balik)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Forum sosial';
$string['indicator:socialbreadth_help'] = 'Indikator ini didasarkan pada jangkauan sosial yang dicapai siswa dalam suatu aktivitas Forum.';
$string['indicator:socialbreadthdef'] = 'Forum sosial';
$string['indicator:socialbreadthdef_help'] = 'Peserta telah mencapai persentase keterlibatan sosial yang ditawarkan oleh aktivitas Forum selama interval analisis ini (Tingkatan = Tidak ada partisipasi, Peserta sendiri, Peserta dengan orang lain)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['inforum'] = 'dalam {$a}';
$string['inreplyto'] = 'Sebagai balasan {$a}';
$string['introblog'] = 'Kiriman di forum ini disalin di sini secara otomatis dari blog pengguna dalam kursus ini karena entri blog itu tidak lagi tersedia';
$string['intronews'] = 'Berita dan pengumuman';
$string['introsocial'] = 'Forum terbuka untuk mengobrol tentang apa pun yang Anda inginkan';
$string['introteacher'] = 'Forum untuk catatan dan diskusi khusus pengajar';
$string['invalidaccess'] = 'Halaman ini tidak diakses dengan benar';
$string['invaliddigestsetting'] = 'Setelan intisari surel yang tidak valid disediakan';
$string['invaliddiscussionid'] = 'ID Diskusi salah atau tidak ada lagi';
$string['invalidforcesubscribe'] = 'Mode langganan paksa tidak valid';
$string['invalidforumid'] = 'ID Forum salah';
$string['invalidparentpostid'] = 'ID kiriman induk salah';
$string['invalidpostid'] = 'ID kiriman tidak valid - {$a}';
$string['lastpost'] = 'Kiriman terakhir';
$string['learningforums'] = 'Forum pembelajaran';
$string['lockdiscussion'] = 'Kunci diskusi ini';
$string['lockdiscussionafter'] = 'Kunci diskusi setelah periode tidak aktif';
$string['lockdiscussionafter_help'] = 'Diskusi dapat dikunci secara otomatis setelah waktu tertentu berlalu sejak balasan terakhir. Pengguna dengan kemampuan untuk membalas diskusi terkunci dapat membuka diskusi dengan membalasnya.';
$string['locked'] = 'Dikunci';
$string['lockupdated'] = 'Kunci opsi telah diperbarui.';
$string['longpost'] = 'Kiriman panjang';
$string['mailnow'] = 'Kirim pemberitahuan kiriman forum tanpa penundaan waktu pengeditan';
$string['managesubscriptionsoff'] = 'Selesaikan pengelolaan langganan';
$string['managesubscriptionson'] = 'Kelola pelanggan';
$string['manydiscussions'] = 'Diskusi per halaman';
$string['markalldread'] = 'Tandai semua kiriman dalam diskusi ini sebagai telah dibaca.';
$string['markallread'] = 'Tandai semua kiriman di forum ini sebagai telah dibaca.';
$string['markasread'] = 'Tandai terbaca';
$string['markasreadonnotification'] = 'Saat mengirim pemberitahuan kiriman forum';
$string['markasreadonnotification_help'] = 'Saat Anda diberi tahu tentang postingan forum, Anda dapat memilih apakah ini harus menandai postingan sebagai telah dibaca untuk tujuan pelacakan forum.';
$string['markasreadonnotificationno'] = 'Jangan tandai kiriman sebagai sudah dibaca';
$string['markasreadonnotificationyes'] = 'Tandai kiriman sebagai sudah dibaca';
$string['markread'] = 'Tandai terbaca';
$string['markreadbutton'] = 'Tandai <br />terbaca';
$string['markunread'] = 'Tandai belum dibaca';
$string['markunreadbutton'] = 'Tandai <br /> belum dibaca';
$string['maxattachments'] = 'Jumlah maksimum lampiran';
$string['maxattachments_help'] = 'Setelan ini menentukan jumlah maksimum berkas yang dapat dilampirkan ke kiriman forum.';
$string['maxattachmentsize'] = 'Ukuran maksimum lampiran';
$string['maxattachmentsize_help'] = 'Setelan ini menentukan ukuran berkas terbesar yang dapat dilampirkan ke kiriman forum.';
$string['maxtimehaspassed'] = 'Maaf, waktu maksimum untuk mengedit posting ini ({$a}) telah berlalu!';
$string['message'] = 'Pesan';
$string['messageinboundattachmentdisallowed'] = 'Tidak dapat mengeposkan balasan Anda, karena di dalamnya terdapat lampiran dan forum tidak mengizinkan lampiran.';
$string['messageinboundfilecountexceeded'] = 'Tidak dapat kirimkan balasan Anda, karena ini mencakup lebih dari jumlah maksimum lampiran yang diizinkan untuk forum
({$a>forum->maxattachments}).';
$string['messageinboundfilesizeexceeded'] = 'Tidak dapat mengirim balasan Anda, karena ukuran total lampiran ({$a->filesize}) lebih besar dari ukuran maksimum yang diperbolehkan untuk forum ({$a->maxbytes}).';
$string['messageinboundforumhidden'] = 'Tidak dapat mengirim balasan Anda, karena forum saat ini tidak tersedia.';
$string['messageinboundnopostforum'] = 'Tidak dapat mengirim balasan Anda, karena Anda tidak memiliki izin untuk mengirim di forum {$a->forum->name}.';
$string['messageinboundthresholdhit'] = 'Tidak dapat mengirim balasan Anda. Anda telah melampaui ambang pengeposan yang ditetapkan untuk forum ini';
$string['messageprovider:digests'] = 'Intisari forum yang dilanggan';
$string['messageprovider:posts'] = 'Berlangganan kiriman forum';
$string['missingsearchterms'] = 'Istilah penelusuran berikut hanya muncul di markup HTML pesan ini:';
$string['modeflatnewestfirst'] = 'Tampilkan tanggapan secara secara flat, dari yang terbaru';
$string['modeflatoldestfirst'] = 'Tampilkan tanggapan secara secara flat, dari yang terlama';
$string['modenested'] = 'menampilkan balasan dalam bentuk bertingkat';
$string['modenestedv2'] = 'Menampilkan balasan dalam bentuk bertingkat eksperimental';
$string['modethreaded'] = 'Tampilkan tanggapan dalam bentuk untaian';
$string['modulename'] = 'Forum';
$string['modulename_help'] = 'Modul aktivitas forum memungkinkan peserta untuk melakukan diskusi asinkron yaitu diskusi yang berlangsung selama jangka waktu yang panjang.

Ada beberapa jenis forum yang dapat dipilih, seperti forum standar di mana setiap orang dapat memulai diskusi baru kapan saja; sebuah forum di mana setiap siswa dapat mengirim tepat satu diskusi; atau forum tanya jawab di mana siswa harus mengirim terlebih dahulu sebelum dapat melihat kiriman siswa lain. Seorang pengajar dapat mengizinkan berkas untuk dilampirkan ke kiriman forum. Gambar yang dilampirkan ditampilkan di kiriman forum.

Peserta dapat berlangganan ke forum untuk menerima pemberitahuan dari kiriman forum baru. Seorang pengajar dapat mengatur mode berlangganan ke opsional, dipaksa atau otomatis, atau mencegah berlangganan sepenuhnya. Jika diperlukan, siswa dapat diblokir dari kiriman yang melebihi jumlah kiriman yang diizinkan dalam jangka waktu tertentu; ini dapat mencegah individu mendominasi diskusi.

Kiriman forum dapat dinilai oleh pengajar atau siswa (evaluasi rekan). Penilaian dapat dikumpulkan untuk membentuk nilai akhir yang dicatat dalam buku nilai.

Forum memiliki banyak kegunaan, seperti

* Ruang sosial bagi siswa untuk mengenal satu sama lain
* Untuk pengumuman kursus (menggunakan forum berita dengan langganan paksa)
* Untuk mendiskusikan konten kursus atau bahan bacaan
* Untuk melanjutkan masalah yang diajukan secara online sebelumnya dalam sesi tatap muka
* Untuk diskusi khusus pengajar (menggunakan forum tersembunyi)
* Pusat bantuan di mana pengajar dan siswa dapat memberikan saran
* Area dukungan satu-satu untuk komunikasi siswa-pengajar pribadi (menggunakan forum dengan grup terpisah dan dengan satu siswa per grup)
* Untuk aktivitas penyuluhan, misalnya \'permainan asah otak\' bagi siswa untuk berpikir dan menyarankan solusi';
$string['modulename_link'] = 'mod/forum/view';
$string['modulenameplural'] = 'Forum';
$string['more'] = 'detail ...';
$string['movedmarker'] = '(dipindahkan)';
$string['movethisdiscussionlabel'] = 'Pindahkan diskusi saat ini ke forum yang ditentukan';
$string['movethisdiscussionto'] = 'Pindahkan diskusi ke ...';
$string['mustprovidediscussionorpost'] = 'Anda harus menyediakan ID diskusi atau ID kiriman untuk diekspor';
$string['myprofileotherdis'] = 'Forum diskusi';
$string['myprofileowndis'] = 'Forum diskusiku';
$string['myprofileownpost'] = 'Kiriman forum saya';
$string['namenews'] = 'Pengumuman';
$string['namenews_help'] = 'Forum pengumuman kursus adalah forum khusus untuk pengumuman dan otomatis dibuat saat kursus dibuat. Sebuah kursus hanya dapat memiliki satu forum pengumuman. Hanya pengajar dan administrator yang dapat mengirim pengumuman. Blok "Pengumuman terbaru" akan menampilkan pengumuman terbaru.';
$string['namesocial'] = 'Forum sosial';
$string['nameteacher'] = 'Forum pengajar';
$string['newforumposts'] = 'Kiriman forum baru';
$string['nextdiscussiona'] = 'Diskusi selanjutnya: {$a}';
$string['nextuser'] = 'Simpan perubahan dan lanjutkan ke pengguna berikutnya';
$string['noattachments'] = 'Tidak ada lampiran dalam kiriman ini';
$string['nodiscussions'] = 'Belum ada topik diskusi pada forum ini';
$string['nodiscussionsstartedby'] = '{$a} tidak memulai diskusi apapun';
$string['nodiscussionsstartedbyyou'] = 'Anda belum memulai diskusi apapun';
$string['noguestpost'] = 'Maaf akun tamu tidak iizinkan untuk mengirim.';
$string['noguestpost:title'] = 'Log masuk untuk melanjutkan';
$string['noguestsubscribe'] = 'Maaf tamu tidak diizinkan untuk berlangganan.';
$string['noguesttracking'] = 'Maaf, tamu tidak diizinkan untuk menyetel opsi pelacakan.';
$string['nomorepostscontaining'] = 'Tidak menemukan  kiriman yang berisi \'{$a}\'';
$string['nonews'] = 'Belum ada berita yang dikirim.';
$string['noonecansubscribenow'] = 'Sekarang fitur langganan tidak diizinkan';
$string['nopermissiontosubscribe'] = 'Anda tidak memiliki izin untuk melihat pelanggan forum ini';
$string['nopermissiontoview'] = 'Anda tidak diizinkan untuk melihat kiriman ini';
$string['nopostforum'] = 'Maaf, Anda tidak diizinkan untuk mengirim ke forum ini';
$string['noposts'] = 'Belum ada kiriman';
$string['nopostsmadebyuser'] = '{$a} belum pernah mengirimkan ke forum';
$string['nopostsmadebyyou'] = 'Anda belum membuat kiriman';
$string['noquestions'] = 'Belum ada pertanyaan dalam forum ini';
$string['nosubscribers'] = 'Belum ada pelanggan untuk forum ini';
$string['notexists'] = 'Diskusi sudah tidak ada lagi';
$string['notgraded'] = 'Tidak dinilai';
$string['nothingnew'] = 'Tidak ada yang baru untuk {$a}';
$string['notingroup'] = 'Maaf, tapi Anda harus menjadi bagian dari grup untuk melihat forum ini.';
$string['notinstalled'] = 'Modul forum belum dipasang';
$string['notlocked'] = 'Kunci';
$string['notpartofdiscussion'] = 'Kiriman ini bukan bagian dari diskusi!';
$string['notrackforum'] = 'Jangan melacak kiriman yang belum dibaca';
$string['notsubscribed'] = 'Berlangganan';
$string['nousersmatch'] = 'Pengguna dengan kriteria yang dimaksud tidak ditemukan';
$string['noviewdiscussionspermission'] = 'Anda tidak memiliki izin untuk melihat diskusi di forum ini';
$string['nowallsubscribed'] = 'Anda sekarang berlangganan semua forum di {$a}.';
$string['nowallunsubscribed'] = 'Anda sekarang berhenti berlangganan dari semua forum di {$a}.';
$string['nowgradinguser'] = 'Sekarang menilai {$a}';
$string['nownotsubscribed'] = '{$a->name} TIDAK akan diberitahu tentang posting baru di \'{$a->forum}';
$string['nownottracking'] = '{$a->name} tidak lagi melacak \'{$a->forum}\'.';
$string['nowsubscribed'] = 'Anda akan diberitahu tentang kiriman baru di forum \'{$a->forum}\'.';
$string['nowtracking'] = '{$a->name} sekarang sedang melacak \'{$a->forum}\'.';
$string['numberofreplies'] = 'Jumlah balasan: {$a}';
$string['numposts'] = '{$a} kiriman';
$string['olderdiscussions'] = 'Diskusi lama';
$string['oldertopics'] = 'Topik lama';
$string['oldpostdays'] = 'Baca setelah berhari-hari';
$string['page-mod-forum-discuss'] = 'Halaman utas diskusi modul forum';
$string['page-mod-forum-view'] = 'Halaman utama modul forum';
$string['page-mod-forum-x'] = 'Setiap halaman modul forum';
$string['parent'] = 'Tampilkan induk';
$string['parentofthispost'] = 'Induk kiriman ini';
$string['permalink'] = 'Tautan permanen';
$string['permanentlinktoparentpost'] = 'Tautan permanen ke induk kiriman ini';
$string['permanentlinktopost'] = 'Tautan permanen ke kiriman ini';
$string['pindiscussion'] = 'Sematkan diskusi ini';
$string['pinupdated'] = 'Opsi semat telah diperbarui.';
$string['pluginadministration'] = 'Forum administrasi';
$string['pluginname'] = 'Forum';
$string['postadded'] = '<p>Kiriman Anda berhasil ditambahkan.</p> <p>Anda mempunyai waktu {$a} untuk mengedit jika anda ingin melakukan perubahan.</p>';
$string['postaddedsuccess'] = 'Kiriman Anda berhasil ditambahkan.';
$string['postaddedtimeleft'] = 'Anda mempunyai waktu {$a} untuk mengedit jika anda ingin melakukan perubahan.';
$string['postbymailsuccess'] = 'Kiriman forum Anda dengan subjek "{$a->subject}" berhasil ditambahkan. Anda bisa melihatnya di {$a->discussionurl}.';
$string['postbymailsuccess_html'] = 'Balasan Anda <a href="{$a->discussionurl}">{$a->subject}</a> berhasil dikirimkan.';
$string['postbyuser'] = '{$a->post} oleh {$a->user}';
$string['postincontext'] = 'Lihat kiriman ini dalam konteks';
$string['postisprivatereply'] = 'Ini adalah balasan pribadi. (Pengajar dan pengguna lain dengan kemampuan untuk melihat balasan pribadi juga dapat melihatnya.)';
$string['postmailinfo'] = 'Ini adalah salinan pesan yang dikirim di {$a}.';
$string['postmailnow'] = '<p>Kiriman ini akan segera dikirim ke semua pelanggan forum.</p>';
$string['postmailreply'] = 'Untuk membalas, klik tautan ini: {$a}';
$string['postmailsubject'] = '{$a->courseshortname}: {$a->subject}';
$string['posts'] = 'Kiriman';
$string['postsfrom'] = 'Kiriman dari';
$string['postsmadebyuser'] = 'Kiriman dibuat oleh {$a}';
$string['postsmadebyuserincourse'] = 'Kiriman dibuat oleh {$a->fullname} di {$a->coursename}';
$string['postsmadeincourse'] = 'Kiriman yang dibuat di {$a}';
$string['poststo'] = 'Dikirimkan ke';
$string['posttoforum'] = 'Kirim ke forum';
$string['posttomygroups'] = 'Kirim salinan ke semua grup';
$string['posttomygroups_help'] = 'Kirimkan salinan pesan ini ke semua grup yang Anda miliki aksesnya. Peserta dalam grup yang tidak Anda akses tidak akan melihat kiriman ini';
$string['postupdated'] = 'Kiriman Anda telah diperbarui';
$string['potentialsubscribers'] = 'Pelanggan potensial';
$string['prevdiscussiona'] = 'Diskusi sebelumnya: {$a}';
$string['previoususer'] = 'Simpan perubahan dan lanjutkan ke pengguna sebelumnya';
$string['privacy:digesttypenone'] = 'Kami tidak menyimpan data apa pun yang berkaitan dengan jenis intisari forum yang disukai untuk forum ini.';
$string['privacy:digesttypepreference'] = 'Anda telah memilih untuk menerima jenis intisari forum berikut: "{$a->type}".';
$string['privacy:discussionsubscriptionpreference'] = 'Anda telah memilih preferensi langganan diskusi berikut untuk forum ini: "{$a->preference}"';
$string['privacy:metadata:core_rating'] = 'Forum ini menggunakan subsistem peringkat untuk mendukung peringkat kiriman.';
$string['privacy:metadata:core_tag'] = 'Forum ini menggunakan subsistem tag untuk mendukung pemberian tag pada kiriman.';
$string['privacy:metadata:forum_digests'] = 'Informasi tentang preferensi intisari untuk setiap forum.';
$string['privacy:metadata:forum_digests:forum'] = 'Forum berlangganan.';
$string['privacy:metadata:forum_digests:maildigest'] = 'Preferensi intisari.';
$string['privacy:metadata:forum_digests:userid'] = 'ID pengguna dengan preferensi intisari.';
$string['privacy:metadata:forum_discussion_subs'] = 'Informasi tentang langganan ke diskusi forum individu';
$string['privacy:metadata:forum_discussion_subs:discussionid'] = 'ID diskusi yang dilanggani.';
$string['privacy:metadata:forum_discussion_subs:preference'] = 'Waktu mulai berlangganan.';
$string['privacy:metadata:forum_discussion_subs:userid'] = 'ID pengguna dengan langganan diskusi.';
$string['privacy:metadata:forum_discussions'] = 'Informasi tentang forum diskusi individu yang telah dibuat oleh pengguna';
$string['privacy:metadata:forum_discussions:assessed'] = 'TODOD - apa yang disimpan ruas ini';
$string['privacy:metadata:forum_discussions:name'] = 'Nama diskusi, sesuai pilihan penulis.';
$string['privacy:metadata:forum_discussions:timemodified'] = 'Waktu diskusi terakhir diubah.';
$string['privacy:metadata:forum_discussions:userid'] = 'ID pengguna yang membuat diskusi';
$string['privacy:metadata:forum_discussions:usermodified'] = 'ID pengguna yang terakhir kali mengubah diskusi dengan cara tertentu.';
$string['privacy:metadata:forum_grades'] = 'Menilai data untuk forum';
$string['privacy:metadata:forum_grades:forum'] = 'Forum telah dinilai';
$string['privacy:metadata:forum_grades:grade'] = 'Nilai diberikan';
$string['privacy:metadata:forum_grades:userid'] = 'Pengguna yang dinilai';
$string['privacy:metadata:forum_posts'] = 'Informasi tentang preferensi intisari untuk setiap forum.';
$string['privacy:metadata:forum_posts:created'] = 'Waktu kiriman dibuat.';
$string['privacy:metadata:forum_posts:discussion'] = 'Diskusi tempat kiriman tersebut berada.';
$string['privacy:metadata:forum_posts:message'] = 'Pesan dari kiriman forum.';
$string['privacy:metadata:forum_posts:modified'] = 'Waktu kiriman terakhir diubah.';
$string['privacy:metadata:forum_posts:parent'] = 'Kiriman induk yang telah dibalas.';
$string['privacy:metadata:forum_posts:privatereplyto'] = 'ID pengguna yang menerima balasan ini.';
$string['privacy:metadata:forum_posts:subject'] = 'Subjek kiriman forum.';
$string['privacy:metadata:forum_posts:totalscore'] = 'Pesan dari kiriman forum.';
$string['privacy:metadata:forum_posts:userid'] = 'ID pengguna yang menulis kiriman forum.';
$string['privacy:metadata:forum_queue'] = 'Log sementara dari kiriman yang akan dikirimkan dalam bentuk intisari';
$string['privacy:metadata:forum_queue:discussionid'] = 'ID forumforum diskusi';
$string['privacy:metadata:forum_queue:postid'] = 'ID kiriman forum';
$string['privacy:metadata:forum_queue:timemodified'] = 'Waktu modifikasi dari kiriman asli';
$string['privacy:metadata:forum_queue:userid'] = 'Pengguna yang perlu diberi tahu tentang kiriman tersebut';
$string['privacy:metadata:forum_read'] = 'Informasi tentang kiriman mana yang telah dibaca oleh pengguna.';
$string['privacy:metadata:forum_read:discussionid'] = 'Diskusi tempat kiriman tersebut berada.';
$string['privacy:metadata:forum_read:firstread'] = 'Pertama kali kiriman dibaca.';
$string['privacy:metadata:forum_read:lastread'] = 'Waktu terakhir kali kiriman dibaca.';
$string['privacy:metadata:forum_read:postid'] = 'Kiriman yang telah dibaca.';
$string['privacy:metadata:forum_read:userid'] = 'ID pengguna yang terkait dengan rekaman ini.';
$string['privacy:metadata:forum_subscriptions'] = 'Informasi tentang forum mana pengguna telah berlangganan.';
$string['privacy:metadata:forum_subscriptions:forum'] = 'Forum yang dilanggani.';
$string['privacy:metadata:forum_subscriptions:userid'] = 'ID pengguna yang terkait dengan langganan forum ini.';
$string['privacy:metadata:forum_track_prefs'] = 'Informasi tentang forum mana yang dipilih pengguna untuk melacak pembacaan kiriman.';
$string['privacy:metadata:forum_track_prefs:forumid'] = 'Forum yang mengaktifkan pelacakan baca.';
$string['privacy:metadata:forum_track_prefs:userid'] = 'ID pengguna yang terkait dengan preferensi pelacakan forum ini.';
$string['privacy:metadata:preference:autosubscribe'] = 'Apakah akan berlangganan diskusi saat membalas kiriman di dalamnya.';
$string['privacy:metadata:preference:forum_discussionlistsortorder'] = 'Urutan pengurutan daftar diskusi yang disukai';
$string['privacy:metadata:preference:maildigest'] = 'Preferensi intisari surel di seluruh situs';
$string['privacy:metadata:preference:markasreadonnotification'] = 'Apakah akan menandai kiriman forum sebagai telah dibaca saat menerimanya sebagai pesan.';
$string['privacy:metadata:preference:trackforums'] = 'Apakah akan mengaktifkan pelacakan baca.';
$string['privacy:postwasread'] = 'Kiriman ini pertama kali dibaca pada {$a->firstread} dan terakhir dibaca pada {$a->lastread}';
$string['privacy:readtrackingdisabled'] = 'Anda telah memilih untuk tidak melacak kiriman yang telah Anda baca dalam forum ini.';
$string['privacy:request:delete:discussion:name'] = 'Hapus atas permintaan penulis';
$string['privacy:request:delete:post:message'] = 'Isi kiriman ini telah dihapus atas permintaan pembuatnya.';
$string['privacy:request:delete:post:subject'] = 'Hapus atas permintaan penulis';
$string['privacy:subscribedtoforum'] = 'Anda berlangganan forum ini.';
$string['privatereply'] = 'Balas secara pribadi';
$string['privatereply_help'] = 'Saat Anda membalas secara pribadi, postingan Anda juga dapat dilihat oleh pengguna yang memiliki kemampuan untuk melihat balasan pribadi, seperti pengajar.';
$string['processingdigest'] = 'Memproses intisari surel untuk pengguna {$a}';
$string['processingpost'] = 'Memproses kiriman {$a}';
$string['prune'] = 'Membagi';
$string['prunediscussion'] = 'Diskusi terpisah';
$string['prunedpost'] = 'Diskusi baru telah dibuat dari kiriman tersebut';
$string['pruneheading'] = 'Pisahkan diskusi dan pindahkan kiriman ini ke diskusi baru';
$string['qandaforum'] = 'Forum tanya jawab';
$string['qandanotify'] = 'Ini forum tanya jawab. Untuk melihat balasan lain, Anda harus mengeposkan balasan terlebih dahulu.';
$string['re'] = 'Re:';
$string['readtherest'] = 'Baca sisa topik ini';
$string['removeallforumtags'] = 'Semua tag forum';
$string['removefromfavourites'] = 'Hapus bintang diskusi ini';
$string['replies'] = 'Balasan';
$string['repliesmany'] = '{$a} balasan sejauh ini';
$string['repliesone'] = '{$a} balasan sejauh ini';
$string['reply'] = 'Balas';
$string['reply_handler'] = 'Balas kiriman forum via surel';
$string['reply_handler_name'] = 'Balas kiriman forum';
$string['replyauthorself'] = '{$a} (Anda)';
$string['replyforum'] = 'Balas forum';
$string['replyingtoauthor'] = 'Balas ke {$a}...';
$string['replyplaceholder'] = 'Tulis balasanmu...';
$string['replypostdiscussion'] = 'Balas diskusi';
$string['replytopostbyemail'] = 'Anda bisa membalas ini via surel.';
$string['replytouser'] = 'Gunakan alamat surel sebagai balasan';
$string['resetdigests'] = 'Semua preferensi intisari forum per pengguna';
$string['resetforums'] = 'Hapus kirim dari';
$string['resetforumsall'] = 'Semua kiriman';
$string['resetsubscriptions'] = 'Semua langganan forum';
$string['resettrackprefs'] = 'Semua preferensi pelacakan forum';
$string['rssarticles'] = 'Jumlah artikel terbaru RSS';
$string['rssarticles_help'] = 'Setelan ini menentukan jumlah artikel (baik diskusi atau kiriman) untuk disertakan dalam umpan RSS. Antara 5 dan 20 secara umum dapat diterima.';
$string['rsssubscriberssdiscussions'] = 'Umpan RSS diskusi';
$string['rsssubscriberssposts'] = 'Umpan RSS kiriman';
$string['rsstype'] = 'Umpan RSS untuk aktivitas ini';
$string['rsstype_help'] = 'Untuk mengaktifkan umpan RSS untuk aktivitas ini, pilih diskusi atau posting untuk dimasukkan ke dalam umpan.';
$string['rsstypedefault'] = 'Jenis umpan RSS';
$string['search'] = 'Cari';
$string['search:activity'] = 'Forum - Informasi aktivitas';
$string['search:post'] = 'Forum - Kiriman';
$string['searchdatefrom'] = 'Kiriman harus lebih baru dari ini';
$string['searchdateto'] = 'Kiriman harus lebih lama dari ini';
$string['searchforumintro'] = 'Harap masukkan istilah pencarian ke dalam satu atau lebih ruas berikut:';
$string['searchforums'] = 'Cari forum';
$string['searchfullwords'] = 'Kata-kata ini harus muncul sebagai kata yang utuh';
$string['searchnotwords'] = 'Kata-kata ini TIDAK boleh disertakan';
$string['searcholderposts'] = 'Cari kiriman lama...';
$string['searchphrase'] = 'Ungkapan yang persis seperti ini harus muncul pada kiriman';
$string['searchresults'] = 'Hasil Pencarian';
$string['searchsubject'] = 'Kata-kata ini harus ada dalam subjek';
$string['searchtags'] = 'Diberi tagar dengan';
$string['searchuser'] = 'Nama ini harus sesuai dengan penulis';
$string['searchuserid'] = 'ID penulis Moodle';
$string['searchusers'] = 'Cari pengguna';
$string['searchwhichforums'] = 'Pilih forum mana yang akan dicari';
$string['searchwords'] = 'Kata-kata ini bisa muncul pada kiriman manapun';
$string['seeallposts'] = 'Lihat semua kiriman yang dibuat oleh pengguna ini.';
$string['sendstudentnotificationsdefault'] = 'Setelan bawaan untuk "Beritahu siswa"';
$string['sendstudentnotificationsdefault_help'] = 'Setel nilai bawaan untuk kotak centang "Beri tahu siswa" di formulir penilaian.';
$string['sendstudentnotificationsno'] = 'Tidak';
$string['sendstudentnotificationsyes'] = 'Ya, kirim pemberitahuan ke siswa';
$string['settings'] = 'Setelan';
$string['shortpost'] = 'Kiriman singkat';
$string['showgraderpanel'] = 'Tampilkan panel pemberi nilai';
$string['showingcountoftotaldiscussions'] = 'Daftar diskusi. Menampilkan {$a->count} dari {$a->total} diskusi';
$string['showmoreusers'] = 'Tampilkan lebih banyak pengguna';
$string['showpreviousrepliescount'] = 'Tampilkan balasan sebelumnya ({$a})';
$string['showsubscribers'] = 'Tampilkan/edit pengikut saat ini';
$string['showusersearch'] = 'Tampilkan pencarian pengguna';
$string['singleforum'] = 'Sebuah diskusi sederhana';
$string['smallmessage'] = '{$a->user} mengirim di forum {$a->forumname}';
$string['smallmessagedigest'] = 'Intisari forum berisi {$a} pesan';
$string['starredonly'] = 'Hanya tampilkan pencarian dari diskusi berbintang';
$string['startedby'] = 'Dimulai oleh';
$string['subject'] = 'Subjek';
$string['subplugintype_forumreport'] = 'Laporan forum';
$string['subplugintype_forumreport_plural'] = 'Laporan forum';
$string['subscribe'] = 'Berlangganan forum';
$string['subscribeall'] = 'Ikutkan semua orang ke forum ini';
$string['subscribed'] = 'Berlangganan';
$string['subscribediscussion'] = 'Berlangganan diskusi ini';
$string['subscribeenrolledonly'] = 'Maaf, hanya pengguna terdaftar yang diizinkan untuk berlangganan notifikasi kiriman forum.';
$string['subscribenone'] = 'Hentikan berlangganan semua orang dari forum ini';
$string['subscribers'] = 'Pelanggan';
$string['subscriberstowithcount'] = 'Pelanggan pada "{$a->name}" ({$a->count})';
$string['subscribestart'] = 'Beritahu saya jika terdapat kiriman baru di forum ini';
$string['subscribestop'] = 'Jangan beritahu saya jika terdapat kiriman baru di forum ini';
$string['subscription'] = 'Berlanggganan';
$string['subscription_help'] = 'Jika Anda berlangganan forum, itu artinya Anda akan menerima pemberitahuan jika terdapat kirimanbaru pada forum. Biasanya Anda dapat memilih apakah Anda ingin berlangganan, meskipun terkadang berlangganan dipaksakan agar semua orang menerima pemberitahuan.';
$string['subscriptionandtracking'] = 'Berlangganan dan pelacakan';
$string['subscriptionauto'] = 'Berlangganan otomatis';
$string['subscriptiondisabled'] = 'Berlangganan dinonaktifkan';
$string['subscriptionforced'] = 'Berlangganan dipaksakan';
$string['subscriptionmode'] = 'Mode berlangganan';
$string['subscriptionmode_help'] = 'Ketika seorang peserta berlangganan ke forum, itu artinya mereka akan menerima pemberitahuan kiriman forum. Ada 4 opsi mode langganan: * Berlangganan opsional - Peserta dapat memilih apakah akan berlangganan * Berlangganan paksa - Semua orang berlangganan dan tidak dapat berhenti berlangganan * Berlangganan otomatis - Semua orang pada awalnya berlangganan tetapi dapat memilih untuk berhenti berlangganan kapan saja * Langganan dinonaktifkan - Langganan tersedia tidak diperbolehkan';
$string['subscriptionmodeconfirm'] = 'Yakin ingin mengubah mode berlangganan ke {$a}?';
$string['subscriptionoptional'] = 'Berlangganan opsional';
$string['subscriptions'] = 'Berlangganan';
$string['tagarea_forum_posts'] = 'Kiriman forum';
$string['tagsdeleted'] = 'Tagar forum telah dihapus';
$string['thisforumhasduedate'] = 'Tanggal jatuh tempo untuk mengirim ke forum ini adalah {$a}.';
$string['thisforumisdue'] = 'Tanggal jatuh tempo untuk mengirim ke forum ini adalah {$a}.';
$string['thisforumisthrottled'] = 'Forum ini memiliki batas jumlah kiriman forum yang dapat Anda buat dalam jangka waktu tertentu - saat ini ditetapkan pada {$a->blockafter} kiriman dalam {$a->blockperiod}';
$string['timed'] = 'Durasi';
$string['timeddiscussion'] = 'Diskusi berdurasi';
$string['timedhidden'] = 'Status waktu: Disembunyikan dari siswa';
$string['timedposts'] = 'Kiriman berdurasi';
$string['timedvisible'] = 'Kiriman berdurasi: Terlihat oleh semua pengguna';
$string['timestartenderror'] = 'Tanggal akhir tampilan tidak boleh lebih awal dari tanggal mulai';
$string['togglediscussionmenu'] = 'Beralih menu diskusi';
$string['togglefullscreen'] = 'Beralih ke layar penuh';
$string['togglesettingsdrawer'] = 'Beralih laci setelan';
$string['trackforum'] = 'Lacak kiriman yang belum terbaca';
$string['tracking'] = 'Lacak';
$string['trackingoff'] = 'Matikan';
$string['trackingon'] = 'Paksakan';
$string['trackingoptional'] = 'Opsional';
$string['trackingtype'] = 'Baca pelacakan';
$string['trackingtype_help'] = 'Pelacakan baca memungkinkan peserta untuk dengan mudah memeriksa kiriman mana yang belum mereka lihat dengan menyorot kiriman baru.

Jika disetel ke opsional, peserta dapat memilih apakah akan mengaktifkan atau menonaktifkan pelacakan untuk forum. (Pengguna juga harus mengaktifkan pelacakan forum di preferensi forum mereka.)

Jika \'Izinkan pelacakan baca paksa\' diaktifkan di administrasi situs, maka opsi lebih lanjut tersedia - paksa. Artinya pelacakan selalu aktif, apa pun preferensi forum pengguna.';
$string['trackreadposts_header'] = 'Pelacakan forum';
$string['unlockdiscussion'] = 'Buka kunci diskusi ini';
$string['unpindiscussion'] = 'Lepas sematan diskusi ini';
$string['unread'] = 'Belum dibaca';
$string['unreadpost'] = 'Kiriman belum dibaca';
$string['unreadposts'] = 'Kiriman belum dibaca';
$string['unreadpostsnumber'] = '{$a} kiriman belum dibaca';
$string['unreadpostsone'] = '1 kiriman belum dibaca';
$string['unsubscribe'] = 'Berhenti berlangganan forum';
$string['unsubscribeall'] = 'Berhenti berlangganan dari semua forum';
$string['unsubscribeallconfirm'] = 'Anda saat ini berlangganan forum {$a->forums}, dan diskusi {$a->discussions}. Anda yakin ingin berhenti berlangganan dari semua forum dan diskusi, dan menonaktifkan langganan otomatis diskusi?';
$string['unsubscribeallconfirmdiscussions'] = 'Anda saat ini berlangganan diskusi {$a->discussions}. Anda yakin ingin berhenti berlangganan dari semua diskusi dan menonaktifkan langganan otomatis diskusi?';
$string['unsubscribeallconfirmforums'] = 'Anda saat ini berlangganan forum {$a->forums}. Anda yakin ingin berhenti berlangganan dari semua forum dan menonaktifkan langganan otomatis diskusi?';
$string['unsubscribealldone'] = 'Semua langganan forum opsional telah dihapus. Anda masih akan menerima pemberitahuan dari forum dengan langganan paksa. Untuk mengelola notifikasi forum, buka Olah pesan di Setelan Profil Saya.';
$string['unsubscribeallempty'] = 'Anda tidak berlangganan forum mana pun. Untuk menonaktifkan semua pemberitahuan dari server ini buka Olah pesan di Setelan Profil Saya.';
$string['unsubscribed'] = 'Tidak berlangganan';
$string['unsubscribediscussion'] = 'Berhenti berlangganan diskusi ini';
$string['unsubscribediscussionlink'] = 'Berhentikan berlangganan diskusi ini: {$a}';
$string['unsubscribelink'] = 'Berhentikan berlangganan forum ini: {$a}';
$string['unsubscribeshort'] = 'Berhenti berlangganan';
$string['useexperimentalui'] = 'Gunakan tampilan diskusi bertingkat eksperimental';
$string['usermarksread'] = 'Tandai telah dibaca secara manual';
$string['usernavigation'] = 'Navigasi pengguna';
$string['usersforumposts'] = 'Kiriman forum pengguna';
$string['viewalldiscussions'] = 'Lihat semua diskusi';
$string['viewconversation'] = 'Lihat diskusi';
$string['viewgrades'] = 'Lihat penilaian';
$string['viewparentpost'] = 'Lihat kiriman induk';
$string['viewthediscussion'] = 'Lihat semua diskusi';
$string['warnafter'] = 'Peringatan ambang batas kiriman';
$string['warnafter_help'] = 'Siswa dapat diperingatkan saat mereka mendekati jumlah maksimum kiriman yang diperbolehkan dalam periode tertentu. Setelan ini menentukan setelah berapa banyak kiriman mereka diperingatkan. Pengguna dengan mod/forum:postwithoutthrottling dibebaskan dari batas kiriman.';
$string['warnformorepost'] = 'Peringatan! Ada lebih dari satu diskusi di forum ini - gunakan yang terbaru';
$string['yournewquestion'] = 'Pertanyaan baru Anda';
$string['yournewtopic'] = 'Topik diskusi baru Anda';
$string['yourreply'] = 'Tanggapan Anda';
