<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'grades', language 'ar', version '4.5'.
 *
 * @package     grades
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activities'] = 'الأنشطة';
$string['addcategory'] = 'إضافة تصنيف';
$string['addcategoryerror'] = 'تعذرت إضافة التصنيف.';
$string['addexceptionerror'] = 'وقع خطأ عند لإضافة استثناء للإمكانية userid:gradeitem';
$string['addfeedback'] = 'إضافة إفادة';
$string['addgradeletter'] = 'أضف حرف الدرجة';
$string['addidnumbers'] = 'أضف أرقام المُعرَّفات';
$string['additem'] = 'إضافة عنصر تقييم';
$string['additionalfeedback'] = 'إفادة إضافية';
$string['addoutcome'] = 'أضف مخرج تعليمي';
$string['addoutcomeitem'] = 'إضاف عنصر مخرج تعلم';
$string['addscale'] = 'أضف مقياساً';
$string['adjustedweight'] = 'تم تعديل الوزن';
$string['aggregateextracreditmean'] = 'متوسط التقديرات (مع رصيد إضافي)';
$string['aggregatemax'] = 'الدرجة العليا';
$string['aggregatemean'] = 'متوسط الدرجات';
$string['aggregatemedian'] = 'وسيط الدرجات';
$string['aggregatemin'] = 'الدرجة الصغرى';
$string['aggregatemode'] = 'منوال التقديرات';
$string['aggregatenotonlygraded'] = 'قم بتضمين الدرجات الفارغة';
$string['aggregateonlygraded'] = 'استبعاد التقديرات الفارغة';
$string['aggregateonlygraded_help'] = 'الدرجة الفارغة هي درجة مفقودة في سجل التقديرات. قد تكون لتسليم واجب لم يتم تقييمه بعد، أو لاختبار لم تجرِ محاولته بعد... وما شابه.

هذا الإعداد يحدد فيما إذا كان ينبغي استبعاد الدرجات الفارغة من الحسبان أو اعتبارها بمثابة الدرجة الصغرى، مثلاً 0 بالنسبة إلى واجب تتراوح درجته ما بين 0 و 100.';
$string['aggregateoutcomes'] = 'تضمين مخرجات التعلم في الإجمالي';
$string['aggregateoutcomes_help'] = 'إذا تم تمكينه، فإن المخرجات سيتم تضمينها في الإجمالي. هذا قد ينتج عنه إجمالي غير متوقع للتصنيف.';
$string['aggregatesonly'] = 'إظهار الإجماليات فقط';
$string['aggregatesubcatsupgradedgrades'] = 'ملاحظة: إعداد الإجمال "الإجمالي يتضمن التصنيفات الفرعية" قد تمت إزالته كجزء من ترقية الموقع. بما أن "الإجمالي يتضمن التصنيفات الفرعية" قد سبق استعماله في هذا المساق، فيوصى بأن تقوم بمراجعة هذا التغيير في سجل التقديرات.';
$string['aggregatesum'] = 'بسيط';
$string['aggregateweightedmean'] = 'المتوسط الموزون للتقديرات';
$string['aggregateweightedmean2'] = 'المتوسط الموزون البسيط للتقديرات';
$string['aggregation'] = 'الإجمال';
$string['aggregation_help'] = 'الإجمال يحدد كيفية إحتساب الإجمالي للدرجات ضمن التصنيف، مثلاً:

* متوسط الدرجات - مجموع كل الدرجات مقسوماً على عددها الكلي
* وسيط الدرجات - الدرجة الوسطى عند ترتيب الدرجات حسب قيمها
* الدرجة الصغرى
* الدرجة الكبرى
* منوال الدرجات - الدرجة الأكثر ظهوراً بين التقديرات
* بسيط - مجموع كل قيم الدرجات مقاسة بأوزانها';
$string['aggregation_link'] = 'grade/aggregation';
$string['aggregationcoef'] = 'معامل الإجمال';
$string['aggregationcoefextra'] = 'نقاط إضافية';
$string['aggregationcoefextra_help'] = 'إن كان الإجمال بطريقة \'بسيط\' أو \'متوسط موزون بسيط\' وكانت خانة الرصيد الإضافي مؤشرة، فإن الدرجة القصوى للعنصر لن تتم إضافتها إلى الدرجة القصوى للتصنيف. هذا سيؤدي إلى احتمالية الوصول إلى الدرجة القصوى في التصنيف بدون تحقيق الدرجة القصوى في كل العناصر. إذا قام المشرف على الموقع بتمكين خيار السماح بتجاوز الدرجة القصوى، فقد تظهر درجات أعلى من الدرجة القصوى.

إن كان الإجمال بطريقة \'متوسط الدرجات (مع رصيد إضافي)\' والرصيد الإضافي موضوع على قيمة أعلى من الصفر، فسيكون الرصيد الإضافي هو المعامل الذي ستُضرب به الدرجة قبل إضافتها إلى الإجمالي من بعد إحتساب المتوسط.';
$string['aggregationcoefextra_link'] = 'grade/aggregation';
$string['aggregationcoefextrasum'] = 'نقاط إضافية';
$string['aggregationcoefextrasum_help'] = 'إن كانت خانة الرصيد الإضافي مؤشرة، فإن الدرجة العليا للعنصر لن تتم إضافتها إلى  الدرجة العليا للتصنيف. هذا سيؤدي إلى احتمالية الوصول إلى الدرجة العليا (أو درجات أعلى من الدرجة العليا إذا قام المشرف على الموقع بتمكين هذا الخيار) في التصنيف بدون تحقيق الدرجة العليا في كل العناصر.';
$string['aggregationcoefextrasum_link'] = 'grade/aggregation';
$string['aggregationcoefextrasumabbr'] = '+';
$string['aggregationcoefextraweight'] = 'ثقل النقاط الإضافية';
$string['aggregationcoefextraweight_help'] = 'إن كان وزن الرصيد الإضافي موضوعاً على قيمة أعلى من الصفر، فإن الدرجة ستكون بمثابة رصيد إضافي في الإجمالي. الرقم سيكون هو المعامل الذي ستُضرب به الدرجة قبل إضافتها إلى الإجمالي من أجل إحتساب المتوسط.';
$string['aggregationcoefextraweight_link'] = 'grade/aggregation';
$string['aggregationcoefweight'] = 'وزن عنصر التقييم';
$string['aggregationcoefweight_help'] = 'وزن العنصر يُستعمل في احتساب إجمالي التصنيف للتأثير على أهمية العنصر مقارنة مع باقي العناصر ضمن نفس التصنيف.';
$string['aggregationcoefweight_link'] = 'grade/aggregation';
$string['aggregationhintdropped'] = '(مهمل)';
$string['aggregationhintexcluded'] = '(مستبعد)';
$string['aggregationhintextra'] = '(رصيد إضافي)';
$string['aggregationhintnovalue'] = '(فارغ)';
$string['aggregationofa'] = 'إجمالي تقديرات {$a}';
$string['aggregationposition'] = 'موضع الإجمال';
$string['aggregationposition_help'] = 'يحدد هذا الخيار ما إذا كانت أعمدة مجموع التصنيف أو المساق ستظهر أولاً أم آخراً في تقارير سجلات التقديرات.';
$string['aggregationsvisible'] = 'أنواع الإجمال المتاحة';
$string['aggregationsvisiblehelp'] = 'إختر كل أنواع الإجمال التي تنبغي إتاحتها للاستعمال. إبقَ ضاغطاً على مفتاح Ctrl لاختيار عناصر متعددة.';
$string['allgrades'] = 'جميع الدرجات حسب الصنف';
$string['allstudents'] = 'كل الطلاب';
$string['allusers'] = 'جميع المستخدمين';
$string['aria-toggledropdown'] = 'تبديل المنسدل الآتي';
$string['aria:dropdowngrades'] = 'عناصر التقييم تم العثور عليها';
$string['autosort'] = 'فرز تلقائي';
$string['availableidnumbers'] = 'أرقام المُعرَّفات المتاحة';
$string['average'] = 'متوسط';
$string['averagesdecimalpoints'] = 'أعشار في متوسطات الأعمدة';
$string['averagesdecimalpoints_help'] = 'يحدد هذا الخيار عدد المراتب العشرية المراد عرضها لكل متوسط، أو ما إذا كان سيتم استعمال الإعداد العام لعدد المراتب العشرية للتصنيف أو العنصر (وراثة).';
$string['averagesdisplaytype'] = 'نوعية عرض المتوسطات في العمود';
$string['averagesdisplaytype_help'] = 'هذا الإعداد يحدد كيفية عرض المعدل (المتوسط)؛ رقماً حقيقياً، نسبة مئوية أو حروفاً، أو فيما إذا تم استعمال نوعية العرض المحددة للتصنيف أو العنصر (وراثة).';
$string['backupwithoutgradebook'] = 'الحفظ الاحتياطي لا يحتوي على إعدادات سجل التقديرات';
$string['badgrade'] = 'الدرجة المقدمة غير صالحة';
$string['badlyformattedscale'] = 'لطفاً، أدخل قيماً مفصولة بفارزة (قيمتان على الأقل إجباراً).';
$string['baduser'] = 'المستخدم المعطى غير صحيح';
$string['bonuspoints'] = 'نقاط إضافية';
$string['bulkcheckboxes'] = 'خانات تأشير بالجملة';
$string['calculatedgrade'] = 'الدرجة المحسوبة';
$string['calculation'] = 'العملية الحسابية';
$string['calculation_help'] = 'معادلة الدرجات هي معادلة تستعمل لاحساب الدرجة الإجمالية. ينبغي بدء المعادلة بعلامة المساواة (=) ويمكنها أن تتضمن العوامل الرياضية المتداولة، مثل: max، min و sum. عند الرغبة، يمكن تضمين العناصر الأخرى في الحساب عبر إدخال مُعرَّفاتها محصورة بين أقواس مربعة مزدوجة.';
$string['calculation_link'] = 'grade/calculation';
$string['calculationadd'] = 'أضف عملية الحسابية';
$string['calculationedit'] = 'حرر الحسابات';
$string['calculationsaved'] = 'تم حفظ العملية الحسابية';
$string['calculationview'] = 'معاينة العملية الحسابية';
$string['calculationwarning'] = 'هذا التصنيف يستعمل الحساب لمعرفة إجمالي التقييم بدلاً من التجميع.';
$string['cannotaccessgroup'] = 'يتعذر الوصول إلى تقديرات المجموعة المحددة، عذراً.';
$string['categories'] = 'التصنيفات';
$string['category'] = 'التصنيف';
$string['categoryedit'] = 'تحرير التصنيف';
$string['categoryname'] = 'اسم التصنيف';
$string['categorytotal'] = 'إجمالي التصنيف';
$string['categorytotalfull'] = '{$a->category} total';
$string['categorytotalname'] = 'تسمية إجمالي التصنيف';
$string['changedefaults'] = 'تغيير الافتراضيات';
$string['changereportdefaults'] = 'تغيير افتراضي التقرير';
$string['chooseaction'] = 'إختر الإجراء...';
$string['choosecategory'] = 'إختر التصنيف';
$string['collapsecriterion'] = 'معيار الانهيار';
$string['compact'] = 'إدمج';
$string['componentcontrolsvisibility'] = 'إخفاء هذا عنصر أمر مسيطر عليه ضمن إعدادات النشاط.';
$string['contract'] = 'تقليص التصنيف';
$string['contributiontocoursetotal'] = 'المساهمة في إجمالي المقرر';
$string['controls'] = 'المسيطرات';
$string['courseavg'] = 'متوسط المساق';
$string['coursegradecategory'] = 'تصنيف علامة المساق';
$string['coursegradedisplaytype'] = 'نوع عرض درجة المساق';
$string['coursegradedisplayupdated'] = 'طريقة عرض علامة المساق قد تم تحديثها.';
$string['coursegradesettings'] = 'إعدادات تقديرت المساق';
$string['coursename'] = 'اسم المقرر';
$string['coursescales'] = 'مقايس المساق';
$string['coursesettings'] = 'إعدادات المساق';
$string['coursesettingsexplanation'] = 'تحدد إعدادات المساق كيف يظهر سجل التقديرات لكل المشاركين في المساق.';
$string['coursesiamtaking'] = 'المقررات التي أدرسها';
$string['coursesiamteaching'] = 'المقررات الدراسية التي أقدمها';
$string['coursetotal'] = 'إجمالي المقرر';
$string['createcategory'] = 'إنشاء التصنيف';
$string['createcategoryerror'] = 'لا يمكن إنشاء تصنيف جديد';
$string['creatinggradebooksettings'] = 'يجري إنشاء إعدادات سجل التقديرات';
$string['csv'] = 'CSV';
$string['currentparentaggregation'] = 'الإجمالي الحالي الأعلى رتبة';
$string['curveto'] = 'منحنى إلى';
$string['decimalpoints'] = 'إجمالي المراتب العشرية';
$string['decimalpoints_help'] = 'يحدد هذا الإعداد عدد المراتب العشرية التي سيتم إظهارها لكل تقدير. لا تأثير لذلك على حسابات التقديرات، والذي يتم إجراؤه بدقة 5 مراتب عشرية.';
$string['default'] = 'إفتراضي';
$string['defaultprev'] = 'الافتراضي ({$a})';
$string['deletecategory'] = 'حذف تصنيف';
$string['deletescale'] = 'حذف المقياس';
$string['disablegradehistory'] = 'تعطيل سجل ماضي التقديرات';
$string['disablegradehistory_help'] = 'تعطيل متابعة التغييرات في الجداول المتعلقة بالتقديرات. هذا من شأنه تسريع المخدم قليلاً وتوفير المساحة في قاعدة البيانات.';
$string['displaylettergrade'] = 'عرض درجات الحروف';
$string['displaypercent'] = 'عرض النسب المئوية';
$string['displaypoints'] = 'عرض النقاط';
$string['displayweighted'] = 'عرض الدرجات المثقّلة';
$string['droplow'] = 'أهمل الأدنى';
$string['droplow_help'] = 'هذا الإعداد يتيح استبعاد عدد محدد من القيم الدنيا من الإجمالي';
$string['droplowestvalue'] = 'حدد قيمة العناصر الأدنى لإهمالها';
$string['droplowestvalues'] = 'أهمل أدنى {$a} قيمة/قيم';
$string['dropped'] = 'حذف';
$string['dropxlowest'] = 'أهمل أدنى كذا مفردة';
$string['dropxlowestwarning'] = 'ملاحظة: إذا استعملت أهمل أدنى كذا عنصراً، فأنت تفترض أن كل عناصر التصنيف لها نفس القيم الرقمية. إن كانت القيم الرقمية مختلفة من الأساس فإن النتائج ستكون غير قابلة للتنبؤ';
$string['duplicatedgradeitem'] = '{$a} (نسخة)';
$string['duplicatescale'] = 'نسخ سلم التقييم';
$string['edit'] = 'تحرير';
$string['editcalculation'] = 'تحرير الحسابات';
$string['editcalculationverbose'] = 'تحرير حساب {$a->category} {$a->itemmodule} {$a->itemname}';
$string['editfeedback'] = 'تحرير الإفادة';
$string['editgrade'] = 'تحرير درجة';
$string['editgradeletters'] = 'تحرير حروف الدرجة';
$string['editoutcome'] = 'تحرير مخرج تعلم';
$string['editoutcomes'] = 'تحرير مخرجات التعلم';
$string['editscale'] = 'تحرير المقياس';
$string['edittree'] = 'إعداد';
$string['editverbose'] = 'تحرير {$a->category} {$a->itemmodule} {$a->itemname}';
$string['enableajax'] = 'تفعيل AJAX';
$string['enableajax_help'] = 'يضيف طبقة من وظائف AJAX إلى تقرير المقيِّم لتبسيط وتسريع العمليات الدارجة. الأمر يعتمد على تمكين Javascript على مستوى المتصفح من طرف المستخدم.';
$string['enableoutcomes'] = 'تفعيل مخرجات التعلم';
$string['enableoutcomes_help'] = 'عند تمكينه، فقد يتم تقييم العناصر باستعمال واحد أو أكثر من المقاييس المرتبطة بعبارات المخرجات.';
$string['encoding'] = 'الترميز';
$string['encoding_help'] = 'إختر ترميز الحروف المستعمل في البيانات. (الترميز القياسي هو UTF-8). إذا تم اختيار الترميز الخطأ سهواً، فسيكون ذلك مُلاحظاً عند استعراض البيانات في أثناء الاستيراد.';
$string['errorcalculationbroken'] = 'خطأ عند احتساب عنصر التقييم {$a}.';
$string['errorcalculationnoequal'] = 'المعادلة ينبغي أن تبدأ بعلامة المساواة (=1+2)';
$string['errorcalculationunknown'] = 'معادلة غير صحيحة';
$string['errorgradevaluenonnumeric'] = 'حَصَل على علامة صغرى أو عليا بشكل لا رقمي لـ';
$string['errornocalculationallowed'] = 'الحسابات غير مسموح بها لهذا العنصر';
$string['errornocategorisedid'] = 'تعذر الحصول على مُعرَّف غير مصنف!';
$string['errornocourse'] = 'لم الحصول على معلومات المنهج الدراسي';
$string['erroroverweight'] = 'إجمالي الوزن يتخطى 100%.';
$string['errorreprintheadersnonnumeric'] = 'حَصَل على قيمة لا رقمية لرؤوس إعادة الطباعة';
$string['errorsavegrade'] = 'عذراً لم يتم حفظ الدرجة';
$string['errorsettinggrade'] = 'وقع خطأ عند حفظ الدرجة "{$a->itemname}" العائدة للمستخدم ذي المُعرَّف {$a->userid}';
$string['errorunderweight'] = 'إجمالي الوزن أقل من 100%.';
$string['errorupdatinggradecategoryaggregateonlygraded'] = 'وقع خطأ عند تحديث الإعداد "تجميع التقديرات اللافارغة حصراً" لتصنيف التقديرات ذي المُعرَّف {$a->id}';
$string['errorupdatinggradecategoryaggregateoutcomes'] = 'وقع خطأ عند تحديث الإعداد "تضمين المخرجات في الإجمالي" لتصنيف التقديرات ذي المُعرَّف {$a->id}';
$string['errorupdatinggradecategoryaggregation'] = 'وقع خطأ عند تحديث نوعية الإجمال لتصنيف التقديرات ذي المُعرَّف {$a->id}';
$string['errorupdatinggradeitemaggregationcoef'] = 'وقع خطأ عند تحديث معامل الإجمالي (الوزن أو الرصيد الإضافي) للعنصر ذي المُعرَّف {$a->id}';
$string['eventgradedeleted'] = 'تقدير تم حذفه';
$string['eventgradeexported'] = 'تقدير تم تصديره';
$string['eventgradeitemcreated'] = 'عنصر تقييم تم إنشاؤه';
$string['eventgradeitemdeleted'] = 'عنصر تقييم تم حذفه';
$string['eventgradeitemupdated'] = 'عنصر تقييم تم تحديثه';
$string['eventgradelettercreated'] = 'حرف تقييم تم إنشاؤه';
$string['eventgradeletterdeleted'] = 'حرف تقييم تم حذفه';
$string['eventgradeletterupdated'] = 'حرف تقييم تم تحديثه';
$string['eventgradeviewed'] = 'تقديرات في سجل التقديرات تمت معاينتها';
$string['eventscalecreated'] = 'مقياس تم إنشاؤه';
$string['eventscaledeleted'] = 'مقياس تم حذفه';
$string['eventscaleupdated'] = 'مقياس تم تحديثه';
$string['eventusergraded'] = 'مستخدم تم منحه تقديرًا';
$string['excluded'] = 'استبعد';
$string['excluded_help'] = 'عند تأشيره، فالدرجة لن يتم تضمينها في أي إجمالي.';
$string['expand'] = 'توسيع التصنيف';
$string['expandcriterion'] = 'معيار التوسيع';
$string['export'] = 'تصدير';
$string['exportalloutcomes'] = 'تصدير كل مخرجات التعلم';
$string['exportas'] = 'التصدير بشكل';
$string['exportfeedback'] = 'تضمين الإفادات في التصدير';
$string['exportfeedback_desc'] = 'هذا يمكن تجاوزه خلال التصدير.';
$string['exportformatoptions'] = 'خيارات صيغة التصدير';
$string['exportonlyactive'] = 'استبعاد المستخدمين المعلَّقين';
$string['exportonlyactive_help'] = 'عند التصدير، قم بتضمين الطلاب المنضمين حالياً، الذين لم يتم تعليق حساباتهم';
$string['exportplugins'] = 'إضافات التصدير';
$string['exportsettings'] = 'إعدادات التصدير';
$string['exportto'] = 'تصدير إلى';
$string['externalurl'] = 'الرابط الخارجي';
$string['externalurl_desc'] = 'إذا كان هناك سجل تقديرات خارجي، فلا بد من تحديد رابطه هنا.';
$string['extracreditvalue'] = 'قيمة الرصيد الإضافي لـ {$a}';
$string['extracreditwarning'] = 'ملاحظة: ضبط كل عناصر التصنيف على أنها رصيد إضافي سيؤدي عملياً إلى إزالتها من حسابات علامة التصنيف، نظراً لأنه لن يكون هناك إجمالي رقمي.';
$string['fail'] = 'راسب';
$string['feedback'] = 'الإفادة';
$string['feedback_help'] = 'هذه الخانة تسمح بوضع أي تعليقات بشأن الدرجة.';
$string['feedbackadd'] = 'إضافة إفادة';
$string['feedbackedit'] = 'تحرير الإفادة';
$string['feedbackfiles'] = 'ملفات الإفادة';
$string['feedbackforgradeitems'] = 'إفادة {$a}';
$string['feedbackhistoryfiles'] = 'ملفات ماضي الإفادات';
$string['feedbackprovided'] = 'الإفادة مقدمة';
$string['feedbacks'] = 'الإفادات';
$string['feedbacksaved'] = 'تم حفظ الإفادة';
$string['feedbackview'] = 'معاينة الإفادة';
$string['filterbothactive'] = 'الأول ({$a->first}) الأخير ({$a->last})';
$string['filterbyname'] = 'الترشيح حسب الاسم';
$string['filterfirstactive'] = 'الأول ({$a->first})';
$string['filterlastactive'] = 'الأخير ({$a->last})';
$string['finalgrade'] = 'الدرجة النهائية';
$string['finalgrade_help'] = 'إذا تم تأشير خانة التجاوز، يمكن إضافة الدرجة أو تعديلها.';
$string['fixedstudents'] = 'عمود طلاب ثابت';
$string['fixedstudents_help'] = 'يسمح بالتمرير الأفقي للتقديرات بدون تضييع عمود الطلاب، عبر تثبيته في الصفحة.';
$string['forceimport'] = 'فرض الاستيراد';
$string['forceimport_help'] = 'فرض استيراد التقديرات حتى وإن كانت قد تعرضت إلى التحديث بعد إنشاء ملف الاستيراد';
$string['forceoff'] = 'إجبار الإغلاق';
$string['forceon'] = 'إجبار الفتح';
$string['forelementtypes'] = 'للعناصر {$a} المحددة';
$string['forstudents'] = 'للطلاب';
$string['full'] = 'كامل';
$string['fullmode'] = 'إظهار التقديرات والإجماليات';
$string['generalsettings'] = 'الإعدادات العامة';
$string['grade'] = 'الدرجة';
$string['grade_help'] = 'الدرج التي يُمنحها الطالب لقاء عمله.';
$string['gradeadministration'] = 'إدارة التقديرات';
$string['gradealreadyupdated'] = '{$a} من التقديرات لم يتم استيرادها لأن التقديرات في ملف الاستيراد هي أقدم مما هي في تقرير المقيِّم. لمتابعة الاستيراد بأي حال، استعمل خيار فرض الاستيراد.';
$string['gradeanalysis'] = 'تحليل التقديرات';
$string['gradebook'] = 'سجل التقديرات';
$string['gradebookcalculationsfixbutton'] = 'إقبل تغييرات الدرجة وأصلح أخطاء الحساب';
$string['gradebookcalculationsuptodate'] = 'الحسابات في سجل التقديرات هي بآخر تحديث. قد ترغب بإعادة تحميل الصفحة لمعاينة التغييرات.';
$string['gradebookcalculationswarning'] = 'ملاحظة: تم اكتشاف بعض الأخطاء في حساب التقديرات المعروضة في سجل التقديرات. إن كان المساق لم يبدأ بعد أو لا زال مستمراً، من الموصى به إصلاح الأخطاء عبر النقر على الزر أدناه، رغم أن ذلك قد يؤدي إلى تغيير في بعض التقديرات. إن كان المساق قد انتهى والتقديرات قد تم إعلانها، قد لا يناسبك إصلاح هذه المشكلة.

الإصدار الأحدث هو {$a->currentversion}؛ أنت تستعمل الإصدار {$a->gradebookversion} لسجل التقديرات. يمكنك معاينة قائمة التغييرات في <a href="{$a->url}">تغييرات الحساب في سجل التقديرات</a>.';
$string['gradebookhiddenerror'] = 'سجل التقديرات منصَّب حالياً لإخفاء كل شيء عن الطلاب.';
$string['gradebookhistories'] = 'ماضي التقديرات';
$string['gradebooknavigationmenu'] = 'قائمة تنقل سجل التقديرات';
$string['gradebooksetup'] = 'إعدادات سجل التقديرات';
$string['gradeboundary'] = 'حدود حروف التقديرات';
$string['gradeboundary_help'] = 'هذه الإعداد يحدد النسب المئوية الأدنى التي يتم عندها تعيين الحرف للتقديرات';
$string['gradecategories'] = 'تصنيفات الدرجة';
$string['gradecategory'] = 'تصنيف التقديرات';
$string['gradecategoryonmodform'] = 'تصنيف الدرجة';
$string['gradecategoryonmodform_help'] = 'يتحكم هذا الخيار بالتصنيف الذي ستوضع فيه علامة هذا النشاط في سجل التقديرات.';
$string['gradecategorysettings'] = 'إعدادات تصنيف التقديرات';
$string['gradedisplay'] = 'عرض الدرجة';
$string['gradedisplaytype'] = 'طريقة عرض الدرجة';
$string['gradedisplaytype_help'] = 'هذا الإعداد يحدد كيفية عرض التقديرات في تقرير المقيِّم وتقرير المستخدم.

* حرف - الحروف أو الكلمات تستعمل لتمثيل مدى معين من التقديرات، كما هو مُعرَّف في التبويب \'حروف\' ضمن إعدادات سجل التقديرات
* نسبة مئوية - نسبة إلى الدرجتين الصغرى والعظمى
* حقيقي - التقديرات الفعلية أو قيم المقياس';
$string['gradedon'] = 'مقيَّم: {$a}';
$string['gradeexport'] = 'تصدير التقديرات';
$string['gradeexportcolumntype'] = '{$a->name} ({$a->extra})';
$string['gradeexportcustomprofilefields'] = 'الحقول المخصصة للملف الشخصي عند تصدير التقديرات';
$string['gradeexportcustomprofilefields_desc'] = 'تضمين هذه الحقول الشخصية المخصصة عند تصدير التقديرات، مفصولة بفوارز.';
$string['gradeexportdecimalpoints'] = 'المراتب العشرية لتصدير التقديرات';
$string['gradeexportdecimalpoints_desc'] = 'عدد المراتب العشرية المطلوب عرضها عند التصدير. يمكن تجاوز هذا الإعداد عند إجراء التصدير.';
$string['gradeexportdisplaytype'] = 'نوع عرض تصدير التقديرات';
$string['gradeexportdisplaytype_desc'] = 'يمكن إظهار التقديرات بشكلها الحقيقي، كنسب مئوية (بالنسبة إلى الدرجتين الصغرى والعظمى) أو بشكل أحرف (A، B، C إلخ.) خلال التصدير. يمكن تجاوز هذا الإعداد عند إجراء التصدير.';
$string['gradeexportdisplaytypes'] = 'طُرق عرض التقديرات المُصدَّرة';
$string['gradeexportuserprofilefields'] = 'حقول الملف الشخصي عند تصدير التقديرات';
$string['gradeexportuserprofilefields_desc'] = 'تضمين حقول الملف الشخصي هذه عند تصدير التقديرات، مفصولة بفوارز.';
$string['gradeforstudent'] = '{$a->student}<br />{$a->item}{$a->feedback}';
$string['gradegrademinmax'] = 'العلامتان الصغرى والعظمى الابتدائيتان';
$string['gradehelp'] = 'تعليمات الدرجة';
$string['gradehistorylifetime'] = 'فترة حياة ماضي التقديرات';
$string['gradehistorylifetime_help'] = 'هذا يحدد مدة الوقت التي تريد فيها الاحتفاظ بماضي التغييرات في الجداول المتعلقة بالتقديرات. من الموصى به إبقاؤها لأطول ما يمكن. إذا صادفتك مشاكل في الأداء أو كان لديك حجم محدد لقاعدة البيانات، حاول تقليل المدة.';
$string['gradeimport'] = 'استيراد التقديرات';
$string['gradeimportfailed'] = 'استيراد التقديرات فشل خلال التنفيذ. التفاصيل:';
$string['gradeitem'] = 'عنصر التقييم';
$string['gradeitemaddusers'] = 'استبعد من التقييم';
$string['gradeitemadvanced'] = 'خيارات متقدمة لعنصر التقييم';
$string['gradeitemadvanced_help'] = 'إختر كل العناصر التي ينبغي عرضها بمثابة خيارات متقدمة عند تحرير عناصر التقييم.';
$string['gradeitemislocked'] = 'هذا النشاط مؤمن في سجل التقديرات. أي تغييرات قد تطرأ على تقديرات هذا النشاط لن يتم نسخها إلى سجل التقديرات حتى يتم إلغاء تأمينه.';
$string['gradeitemlocked'] = 'التقييم مقفول';
$string['gradeitemmembersselected'] = 'مستبعد من التقييم';
$string['gradeitemminmax'] = 'العلامتان الصغرى والعظمى كما تم تعيينهما في إعدادات العنصر';
$string['gradeitemnonmembers'] = 'مضمنة في التقييم';
$string['gradeitemremovemembers'] = 'إجعلها ضمن التقييم';
$string['gradeitems'] = 'عناصر التقييم';
$string['gradeitemsettings'] = 'إعدادات عنصر التقييم';
$string['gradeitemsinc'] = 'عنصر التقييم المراد تضمينه';
$string['gradeletter'] = 'درجة حرفية';
$string['gradeletter_help'] = 'حروف التقديرات هي الحروف، A، B، C، ...، أو كلمات، مثل: تميز، جدارة، إجتياز، ...، والتي تستعمل للتعبير عن مدى من الدرجات.';
$string['gradeletternote'] = 'لحذف درجة حرفيه فقط افرغ اى من <br /> مناطق النص الثالثة لذلك الحرف ثم انقر سلم.';
$string['gradeletteroverridden'] = 'حروف التقديرات الإفتراضية قد تم تجاوزها حالياً.';
$string['gradeletters'] = 'أحرف الدرجة';
$string['gradelocked'] = 'التقدير مغلق';
$string['gradelong'] = '{$a->grade} / {$a->max}';
$string['grademax'] = 'الدرجة القصوى';
$string['grademax_help'] = 'هذا الإعداد يحدد الدرجة العظمى عند استعمال التقييم المبني على القيم الرقمية. الدرجة العظمى بالنسبة إلى عنصر التقييم العائدة إلى نشاط يتم ضبطها في صفحة إعدادات النشاط.';
$string['grademin'] = 'الدرجة الصغرى';
$string['grademin_help'] = 'هذا الإعداد يحدد الدرجة الصغرى عند استعمال التقييم المبني على القيم الرقمية.';
$string['gradenotificationmessage'] = 'لديك إفادة جديدة على عملك في "{$a}"';
$string['gradenotificationsubject'] = 'لقد تم منحك علامة';
$string['gradeoutcomeitem'] = 'عنصر تقييم المخرجات';
$string['gradeoutcomes'] = 'محرجات تعلم';
$string['gradeoutcomescourses'] = 'مخرجات تعلم لمساق';
$string['gradepass'] = 'درجة النجاح';
$string['gradepass_help'] = 'هذا الإعداد يحدد الدرجة الصغرى المطلوبة للنجاح. هذه القيمة تستعمل في إكمال النشاط والمساق، وفي سجل التقديرات، حيث يتم إظهار الدرجات الناجحة باللون الأخضر والراسبة باللون الأحمر.';
$string['gradepassgreaterthangrade'] = 'درجة النجاح لا يمكن أن تتجاوز الدرجة العظمى الممكنة {$a}';
$string['gradepointdefault'] = 'الدرجة الافتراضية';
$string['gradepointdefault_help'] = 'هذا الإعداد يحدد القيمة الافتراضية للدرجة المخصصة لعنصر التقييم.';
$string['gradepointdefault_validateerror'] = 'هذا الإعداد لا بد أن يكون رقماً صحيحاً يتراوح ما بين 1 والدرجة العظمى.';
$string['gradepointmax'] = 'الدرجة العظمى';
$string['gradepointmax_help'] = 'هذا الإعداد يحدد قيمة الدرجة العظمى المتاحة للنشاط.';
$string['gradepointmax_validateerror'] = 'هذا الإعداد ينبغي أن يكون رقماً صحيحاً يتراوح ما بين 1 و 10000.';
$string['gradepreferences'] = 'تفضيلات الدرجة';
$string['gradepreferenceshelp'] = 'تعليمات تفضيلات التقديرات';
$string['gradepublishing'] = 'تفعيل النشر';
$string['gradepublishing_help'] = 'نشر التقديرات هو طريقة لاستيراد وتصدير الدرجات عبر رابط دون الحاجة إلى دخول مودل. إذا تم تمكينه، سيتم توفير إعدادات نشر التقديرات للمشرفين والمستخدمين الذين يمتلكون صلاحية نشرها (إفتراضياً هم المستخدمون بدور المدير حصراً) في سجل التقديرات لكل مساق.';
$string['gradepublishinglink'] = 'تنزيل: {$a}';
$string['gradereport'] = 'تقرير الدرجة';
$string['graderreport'] = 'تقرير المصحح';
$string['grades'] = 'التقديرات';
$string['gradesforuser'] = 'تقديرات {$a->user}';
$string['gradesmoduledeletionpendingwarning'] = 'تحذير: حذف النشاط هو قيد التنفيذ! بعض التقديرات بصدد التعرض إلى الزوال.';
$string['gradesmoduledeletionprefix'] = '[الحذف جارٍ]';
$string['gradesonly'] = 'إظهار التقديرات فقط';
$string['gradessettings'] = 'إعدادات الدرجة';
$string['gradetype'] = 'نوع الدرجة';
$string['gradetype_help'] = 'هناك 4 أنواع من التقديرات :

* بلا - لا يتم منح تقديرات
* قيمة - قيمة رقمية بحدين أعلى وأدنى
* مقياس - عنصر من قائمة
* نص - إفادة فقط

يمكن تجميع التقديرات من نوعي القيمة والمقياس فقط. نوع التقييم للعنصر المبنية على نشاط يمكن ضبطها في صفحة إعدادات النشاط.';
$string['gradevaluetoobig'] = 'إحدى قيم التقدير  أكبر من القيمة العظمى المسموح بها والبالغة {$a}';
$string['gradevaluetoosmall'] = 'أحد قيم التقديرات أصغر من الدرجة الصغرى المسموح بها والبالغة {$a}';
$string['gradeview'] = 'معانية الدرجة';
$string['gradewasmodifiedduringediting'] = 'الدرجة المدخلة للعنصر {$a->itemname} العائدة لـ {$a->username} قد تم تجاهلها لأنها تعرضت للتحديث مؤخراً من قبل شخص آخر.';
$string['gradeweighthelp'] = 'تعليمات وزن الدرجة';
$string['gradingmodulename'] = 'منح تقديرات ({$a})';
$string['groupavg'] = 'متوسط المجموعة';
$string['hidden'] = 'مخفي';
$string['hidden_help'] = 'عند تأشيرها، ستختفي التقديرات عن أعين الطلبة. يمكن جعل الإخفاء حتى تاريخ معين إن لزم الأمر، لإطلاق التقديرات بعد الانتهاء من منحها.';
$string['hiddenasdate'] = 'إظهار تاريخ المنح للتقديرات المخفية';
$string['hiddenasdate_help'] = 'إن كان المستخدم غير قادر على معاينة التقديرات المخفية، أظهر تاريخ منحها بدلاً من "-".';
$string['hiddenuntil'] = 'مخفي حتى';
$string['hiddenuntildate'] = 'مخفي حتى: {$a}';
$string['hideadvanced'] = 'أخفِ المزايا المتقدمة';
$string['hideaverages'] = 'أخفِ المتوسط';
$string['hidecalculations'] = 'أخفِ العمليات الحسابية';
$string['hidecategory'] = 'مخفي';
$string['hideeyecons'] = 'إخفاء إيقونات إظهار/إخفاء';
$string['hidefeedback'] = 'اخفي الإفادات';
$string['hideforcedsettings'] = 'إخفاء الإعدادات المفروضة';
$string['hideforcedsettings_help'] = 'لا تُظهر الإعدادات المفروضة في واجهة التقديرات.';
$string['hidegroups'] = 'أخفِ المجموعات';
$string['hidelocks'] = 'أخفِ الكتل';
$string['hidenooutcomes'] = 'أظهر مخرجات التعلم';
$string['hidequickfeedback'] = 'أخفِ الإفادة السريعة';
$string['hideranges'] = 'إخفاء المجالات';
$string['hidetotalifhiddenitems'] = 'إخفاء المجاميع إن كانت تحوي عناصر مخفية';
$string['hidetotalifhiddenitems_help'] = 'هذا الإعداد يحدد فيما إذا كان ينبغي إظهار الإجماليات التي تضم عناصر تقييم مخفية للطلبة أو استبدالها بشارحة (-). عند إظهارها، قد يكون الإجمالي محسوباً عبر تضمين العناصر المخفية أو عبر استبعادها.

إذا تم استبعاد العناصر المخفية، سيكون الإجمالي مغايراً لما هو عليه الحال في تقرير المقيِّم، نظراً لكون المعلم يعاين دائماً الإجمالي محسوباً لكل العناصر، سواء الظاهر أم المخفي منها. إذا تم تضمين العناصر المخفية، فقد يتمكن الطلبة من احتساب قيم العناصر المخفية.';
$string['hidetotalshowexhiddenitems'] = 'إظهار المجاميع دون العناصر المخفية';
$string['hidetotalshowinchiddenitems'] = 'إظهار المجاميع متضمنة العناصر المخفية';
$string['hideverbose'] = 'إخفاء {$a->category} {$a->itemmodule} {$a->itemname}';
$string['highgradeascending'] = 'فرز تصاعدي حسب أعلى درجة';
$string['highgradedescending'] = 'فرز تنازلي حسب أعلى درجة';
$string['highgradeletter'] = 'عالي';
$string['identifier'] = 'تعريف المستخدم بواسطة';
$string['idnumbers'] = 'المُعرَّفات';
$string['ignore'] = 'تجاهل';
$string['import'] = 'إستيراد';
$string['importas'] = 'الاستيراد بشكل';
$string['importcsv'] = 'استيراد CSV';
$string['importcsv_help'] = 'يمكن استيراد التقديرات بواسطة ملف CSV مبني بالصيغة الآتية:

* كل سطر في الملف يحتوي على سجل واحد
* كل سجل هو سلسلة من البيانات مفصولة بالفاصلة المحددة
* السجل الأول يحتوي على قائمة بأسماء الحقول يحدد شكل باقي محتويات الملف
* لا بد من استعمال اسم حقل يعبر عن هوية المستخدم - إما اسم المستخدم أو مُعرَّفه الرقمي أو بريده الالكتروني

يمكن الحصول على ملف بالصيغة الصحيحة عبر تصدير بعض الدرجات أولاً. يمكن حينها تحرير الملف وحفظه بصيغة CSV.';
$string['importcsv_link'] = 'grade/import/csv/index';
$string['importcustom'] = 'الاستيراد بمثابة مخرجات مخصصة (هذا المساق فقط)';
$string['importdata'] = 'البيانات';
$string['importdata_help'] = 'يمكن لصق التقديرات مباشرة من ملف OpenDocument أو مصنف Excel معد بالشكل الآتي:

* ينبغي أن يوجد عمود واحد على الأقل يحتوي على بيانات تعريف بهوية المستخدم - اسم المستخدم، البريد الالكتروني أو المُعرَّف.
* الأعمدة الأخرى ينبغي أن تكون لها عناوين تشير إلى النشاطات الموجودة أو عناصر التقييم.

يمكن الحصول على جدول ذي صيغة صحيحة عبر تصدير بعض التقديرات أولاً. يمكن بعدها تحرير الجدول لإضافة المزيد من التقديرات ثم حفظه.

حدد الأعمدة التي تريد استيرادها من الجدول ثم انسخها إلى هذا الحقل.';
$string['importerror'] = 'وقع خطأ ما. هذا النص البرمجي لم يجرِ استدعاؤه مع العوامل الصحيحة.';
$string['importfailed'] = 'فشل الاستيراد. لم يتم استيراد أي بيانات.';
$string['importfeedback'] = 'إستيراد إفادة';
$string['importfile'] = 'إستيراد ملف';
$string['importfilemissing'] = 'لم يتم استلام أي ملف. عُد إلى النموذج وتأكد من رفع ملف صحيح.';
$string['importfrom'] = 'إستيراد من';
$string['importoutcomenofile'] = 'الملف المرفوع فارغ أو تالف. لطفاً، تحقق من كونه ملفاً صحيحاً. تم الكشف عن المشكلة عند السطر {$a}؛ هذا الأمر يُثار من قبل سطور البيانات التي لا تضم عدداً من الأعمدة يطابق عددها في السطر الأول (سطر العناوين)، أو كان الملف المستورد مفتقراً إلى العناوين المتوقعة. أنظر الملف المصدر كمثال على ملف يمتلك سطر عناوين صحيح.';
$string['importoutcomes'] = 'استيراد مخرجات التعلم';
$string['importoutcomes_help'] = 'المخرجات يمكن استيرادها بواسطة ملف CSV بصيغة مماثلة لما في ملف CSV لتصدير المخرجات.';
$string['importoutcomes_link'] = 'grade/outcome';
$string['importoutcomesuccess'] = 'المخرجات المستوردة "{$a->name}" ذات المُعرَّف #{$a->id}';
$string['importplugins'] = 'إضافات الاستيراد';
$string['importpreview'] = 'معاينة الإستيراد';
$string['importsettings'] = 'إعدادات الإستيراد';
$string['importskippednomanagescale'] = 'ليست لديك صلاحية إضافة مقياس جديد، لذلك فإن مخرجات "{$a}" قد تم تجاوزها نظراً لكونها تتطلب إنشاء مقياس جديد';
$string['importskippedoutcome'] = 'هناك مخرجات بنفس التسمية المختصرة "{$a}" موجودة سلفاً في هذا السياق. تم تجاوز تلك التي بنفس التسمية في الملف المستورد.';
$string['importstandard'] = 'الاستيراد بمثابة مخرجات قياسية';
$string['importsuccess'] = 'تم بنجاح استيراد التقديرات';
$string['importxml'] = 'إستراد إكس إم إل';
$string['includescalesinaggregation'] = 'تضمين المقاييس في الإجمال';
$string['includescalesinaggregation_help'] = 'يمكنك تغيير فيما لو كان ينبغي تضمين المقاييس بمثابة أرقام في كل الدرجات المجمعة على مدى كل سجلات التقديرات في كل المقررات الدراسية. حذارِ: تغيير هذا الإعداد سيفرض إعادة احتساب الدرجات في كل التجميعات';
$string['incorrectcourseid'] = 'رقم المساقالدراسي غير صحيح';
$string['incorrectcustomscale'] = '(مقياس مخصص غير صحيح، لطفاً، عدله).';
$string['incorrectminmax'] = 'القيمة الصغرى ينبغي أن تكون أقل من العظمى';
$string['inherit'] = 'وراثة';
$string['intersectioninfo'] = 'معلومة الطالب/الدرجة';
$string['invalidgradeexporteddate'] = 'تاريخ التصدير غير صحيح لأنه عائد لأكثر من سنة مضت أو هو في المستقبل، أو ربما كانت صيغته خاطئة.';
$string['item'] = 'بند';
$string['iteminfo'] = 'معلومات عنصر التقييم';
$string['iteminfo_help'] = 'هذا الإعداد يعطي مجالاً لإدخال معلومات عن العنصر. المعلومة لا يتم عرضها في أي مكان آخر.';
$string['itemname'] = 'اسم عنصر التقييم';
$string['itemnamehelp'] = 'اسم عنصر، مدفوعاً من قبل الوحدة.';
$string['items'] = 'بنود';
$string['itemsedit'] = 'تحرير عنصر التقييم';
$string['keephigh'] = 'أبقِ على أعلى';
$string['keephigh_help'] = 'عند تفعيله، هذا الخيار سيبقِ على أعلى كذا علامة، وكذا تمثل القيمة المحددة لهذا الخيار.';
$string['keephighestvalues'] = 'أبق على أعلى {$a} قيم';
$string['keymanager'] = 'مدير المفتاح';
$string['lessthanmin'] = 'الدرجة المعطاة للعنصر {$a->itemname} والممنوحة لـ {$a->username} أصغر من القيمة الصغرى المسموح بها';
$string['letter'] = 'حرف';
$string['lettergrade'] = 'علامة حرفية';
$string['lettergradenonnumber'] = 'الدرجة الدنئ/العليا لم يكون رقميا لـ';
$string['letterpercentage'] = 'حرف (نسبة مئوية)';
$string['letterreal'] = 'حرف (حقيقي)';
$string['letters'] = 'الحروف';
$string['linkedactivity'] = 'نشاط مرتبط';
$string['linkedactivity_help'] = 'هذا الإعداد يحدد النشاط الذي ترتبط به عنصر المخرجات هذه. يمكن استعماله لقياس أداء الطلاب وفقاً لمعيار لا تمثله علامة النشاط.';
$string['linktoactivity'] = 'نشاط {$a->name} المسمى {$a->title}';
$string['lock'] = 'تأمين';
$string['locked'] = 'مؤمن';
$string['locked_help'] = 'عند تأشيره، لن يكون النشاط ذي الصلة قادراً على تحديث التقديرات تلقائياً.';
$string['locktime'] = 'يُقفَل بعد';
$string['locktimedate'] = 'مؤمن بعد: {$a}';
$string['lockverbose'] = 'تأمين {$a->category} {$a->itemmodule} {$a->itemname}';
$string['lowest'] = 'الأدنى';
$string['lowgradeletter'] = 'دنئ';
$string['manageoutcomes'] = 'إدارة المخرجات';
$string['manualitem'] = 'عنصر يدوي';
$string['mapfrom'] = 'مُعيَّن من';
$string['mapfrom_help'] = 'إختر عمود الجدول الذي يحتوي على بيانات تحديد هوية المستخدم، مثل: اسم المستخدم، مُعرَّف المستخدم أو بريده الالكتروني.';
$string['mappings'] = 'تعيينات عنصر التقييم';
$string['mappings_help'] = 'لكل عمود من التقديرات في الجدول، إختر عنصر التقييم المقابلة لها، لاستيراد التقديرات إليها.';
$string['mapto'] = 'مُعيَّن إلى';
$string['mapto_help'] = 'إختر نفس البيانات التي يمثلها ما اخترته في \'مُعيَّن من\'.';
$string['max'] = 'أعلى';
$string['maxgrade'] = 'الدرجة العليا';
$string['meanall'] = 'كل التقديرات';
$string['meangraded'] = 'التقديرات غير الفارغة';
$string['meanselection'] = 'التقديرات المحددة لمتوسطات الأعمدة';
$string['meanselection_help'] = 'هذا الإعداد يحدد فيما إذا كانت الخلايا الخالية من تقديرات ينبغي تضمينها عند احتساب المعدل (المتوسط) لكل تصنيف أو عنصر تقييم.';
$string['median'] = 'متوسط';
$string['min'] = 'الأدنى';
$string['minimum_show'] = 'أظهر الدرجة الصغرى';
$string['minimum_show_help'] = 'الدرجة الصغرى تستعمل في حسابات الدرجات والأوزان. إذا لم تكن ظاهرة، فالدرجة الصغرى ستعتبر صفراً إفتراضاً ولن يكون بالإمكان تعديلها.';
$string['minmaxtouse'] = 'العلامتان الصغرى والعظمى المستعملتان في الحساب';
$string['minmaxtouse_desc'] = 'هذا الإعداد يحدد فيما إذا كان ينبغي استعمال العلامتين الصغرى والعظمى الابتدائيتين عند وقت منح الدرجة، أو الدرجتين الصغرى والعظمى كما هما معينتان في إعدادات عنصر التقييم وقت احتساب الدرجة المعروضة في سجل التقديرات. من الموصى به تغيير هذا الإعداد خارج أوقات ذروة العمل، لأن كل التقديرات سيُعاد احتسابها مما سيعرض المخدم إلى حمل عالٍ.';
$string['minmaxtouse_help'] = 'هذا الإعداد يحدد فيما إذا كان ينبغي استعمال الدرجتين الصغرى والعظمى الابتدائيتين عند وقت منح الدرجة، أو الدرجتين الصغرى والعظمى كما هما معينتان في إعدادات عنصر التقييم وقت احتساب الدرجة المعروضة في سجل التقديرات.';
$string['minmaxtouse_link'] = 'Grades_min_max';
$string['minmaxupgradedgrades'] = 'ملاحظة: بعض الدرجات قد تغيرت من أجل فك التضارب في سجل التقديرات بسبب تغيير في الدرجتين الصغرى والعظمى المستعملتين حين احتساب الدرجة المعروضة. من الموصى به تنقيح التغييرات والموافقة عليها.';
$string['minmaxupgradefixbutton'] = 'حل التضاربات';
$string['minmaxupgradewarning'] = 'ملاحظة: تم الكشف عن وجود تضارب في سجل التقديرات حدث بسبب تغيير في الدرجتين الصغرى والعظمى المستعملتين حين احتساب الدرجة المعروضة. من الموصى به حل هذا التضارب عبر النقر على الزر أدناه، ولو أن ذلك سيؤدي إلى تغييرات في بعض التقديرات.';
$string['missingitemtypeoreid'] = 'مفتاح المصفوفة (itemtype أو eid) مفقود';
$string['missingscale'] = 'لا بد من اختيار المقياس';
$string['mode'] = 'وضع';
$string['modgrade'] = 'علامة';
$string['modgrade_help'] = '* نقاط - قيمة رقمية
* لا شيء - إفادة فقط
* مقياس - عنصر من القائمة';
$string['modgradecantchangegradetype'] = 'لا يمكنك تغيير النوع نظراً لوجود تقديرات مسبقاً لهذا العنصر.';
$string['modgradecantchangegradetypemsg'] = 'لقد سبق منح بعض الدرجات بالفعل، ولذلك يتعذر تغيير النوع. إذا أردت تغيير الدرجة العظمى، عليك أولاً تحديد فيما لو كان سيتم إعادة مقايسة الدرجات الموجودة أم لا.';
$string['modgradecantchangegradetyporscalemsg'] = 'لقد سبق منح بعض التقديرات بالفعل، ولذلك يتعذر تغيير نوع العنصر ومقياسه.';
$string['modgradecantchangeratingmaxgrade'] = 'لا يمكنك تغيير الدرجة العليا عندما تكون الدرجات ممنوحة مسبقاً لنشاط فيه تقييمات.';
$string['modgradecantchangescale'] = 'لا يمكنك تغيير المقياس نظراً لوجود التقديرات مسبقاً في هذه العنصر.';
$string['modgradecategorycantchangegradetypemsg'] = 'هذا التصنيف فيه عناصر تقييم مرتبطة بنشاطات قد تم تجاوزها، لهذا فإن بعض الدرجات قد تم منحها سلفاً وصار متعذراً تغيير نوع الدرجة. إذا أردت تغيير الدرجة العليا، عليك أن تقرر أولاً فيما إذا كان ينبغي إعادة مقايسة الدرجات الحالية أم لا.';
$string['modgradecategorycantchangegradetyporscalemsg'] = 'هذا التصنيف فيه عناصر تقييم مرتبطة بنشاطات قد تم تجاوزها، لهذا فإن بعض الدرجات قد تم منحها سلفاً وصار متعذراً تغيير نوع الدرجة.';
$string['modgradecategoryrescalegrades'] = 'إعادة مقايسة التقديرات المتجاوَزة';
$string['modgradecategoryrescalegrades_help'] = 'عند تغيير الدرجة العظمى في أحد عناصر سجل التقديرات، عليك أن تقرر فيما إذا كان هذا يسبب تغيير النسب المئوية للتقديرات الموجودة سلفاً.

إذا تم ضبطه على \'نعم\'، فأي درجة سبق تجاوزها ستتم إعادة مقايستها من أجل إبقاء نسبتها المئوية كما هي.

على سبيل المثال، إذا تم وضع هذا الخيار على \'نعم\'، فتغيير الدرجة القصوى لعنصر ما من 10 إلى 20 سيؤدي إلى إعادة مقايسة العلامة 6 من 10 (60%) لتصير 12 من 20 (60%). أما عند ضبط هذا الخيار على \'لا\'، ستبقى العلامة كما هي، مما يستدعي التعديل اليدوي عليها لضمان صحة النتائج.';
$string['modgradedonotmodify'] = 'لا تقم بتعديل التقديرات الموجودة';
$string['modgradeerrorbadpoint'] = 'قيمة الدرجة غير صحيحة. ينبغي أن تكون رقماً صحيحاً يتراوح ما بين 1 و {$a}';
$string['modgradeerrorbadscale'] = 'المقياس المحدد غير صحيح. لطفاً، تأكد من اختيارك للمقياس من الخيارات أدناه.';
$string['modgrademaxgrade'] = 'الدرجة العظمى';
$string['modgraderescalegrades'] = 'أعد مقايسة التقديرات الحالية';
$string['modgraderescalegrades_help'] = 'عند تغيير الدرجة العليا في أحد عناصر سجل التقديرات، عليك أن تقرر فيما إذا كان هذا يسبب تغيير النسب المئوية للدرجات الموجودة سلفاً.

إذا تم ضبطه على \'نعم\'، فأي درجة موجودة سلفاً ستتم إعادة مقايستها من أجل إبقاء نسبتها المئوية كما هي.

على سبيل المثال، إذا تم وضع هذا الخيار على \'نعم\'، فتغيير الدرجة العليا لعنصر ما من 10 إلى 20 سيؤدي إلى إعادة مقايسة الدرجة 6 من 10 (60%) لتصير 12 من 20 (60%). أما عند ضبط هذا الخيار على \'لا\'، ستبقى الدرجة كما هي، مما يستدعي التعديل اليدوي عليها لضمان صحة النتائج.';
$string['modgradetype'] = 'النوع';
$string['modgradetypenone'] = 'لا شيء';
$string['modgradetypepoint'] = 'نقطة';
$string['modgradetypescale'] = 'المقياس';
$string['morethanmax'] = 'الدرجة المدخلة للنشاط {$a->itemname} والممنوحة إلى {$a->username} هي أعلى من الحد الأعلى المسموح به';
$string['moveselectedto'] = 'نقل العناصر المحددة إلى:';
$string['movesitems'] = 'نقل العناصر';
$string['movingelement'] = 'يجري نقل {$a}';
$string['multfactor'] = 'معامل الضرب';
$string['multfactor_help'] = 'معامل الضرب هو المعامل الذي تُضرب به كل الدرجات العائدة لعنصر التقييم هذا مع القيمة العظمى، مع مراعاة عدم تجاوزها. على سبيل المثال؛ إذا كان المعامل 2 والدرجة العظمى 100، فإذن كل الدرجات التي تقل عن 50 سيتم ضربها في 2، وكل الدرجات من 50 فما أعلى ستتغير إلى 100.';
$string['multfactorvalue'] = 'قيمة المعامل لـ {$a}';
$string['mustchooserescaleyesorno'] = 'عليك أن تقرر فيما إذا كان ينبغي إعادة مقايسة التقديرات الحالية أم لا.';
$string['mygrades'] = 'رابط تقديرات قائمة المستخدم';
$string['mygrades_desc'] = 'هذا الإعداد يسمح بخيار الربط مع سجل تقديرات خارجي من قائمة المستخدم.';
$string['mypreferences'] = 'تفضيلاتي خاص';
$string['myreportpreferences'] = 'تفضيلات تقريري';
$string['myself'] = 'نفسي';
$string['neverdeletehistory'] = 'لا تحذف الماضي أبداً';
$string['newcategory'] = 'تصنيف جديد';
$string['newitem'] = 'عنصر تقييم جديد';
$string['newoutcomeitem'] = 'بند مخرج تعلم جديد';
$string['no'] = 'لا';
$string['nocategories'] = 'لا يمكن إضافة أو العثور على تصنيفات الدرجة لهذا المساق';
$string['nocategoryname'] = 'اسم التصنيف الجديد لم يعطى';
$string['nocategoryview'] = 'لا يوجد تصنيف للمعاينة بواسطته';
$string['nocourses'] = 'لا توجد مساقات بعد';
$string['noexistingoutcomes'] = 'لا توجد هناك مخرجات.';
$string['noexistingscales'] = 'لا توجد هناك مقاييس.';
$string['noforce'] = 'لا تفرض';
$string['nogradeletters'] = 'لم يتم تحديد أحرف / حروف الدرجات';
$string['nogradesreturned'] = 'لا توجد درجات';
$string['noidnumber'] = 'لا يوجد مُعرَّف';
$string['nolettergrade'] = 'لا توجد درجة حرفية لـ';
$string['nomode'] = 'لا ينطبق';
$string['nonnumericweight'] = 'قيمة غير رقمية أُعطِيَت لـ';
$string['nonunhideableverbose'] = 'لإلغاء إخفاء هذا التقدير، تحتاج أيضًا إلى إلغاء إخفاء {$a->itemname}.';
$string['nonunlockableverbose'] = 'لإلغاء تأمين هذا التقدير، تحتاج إلى إلغاء تأمين {$a->itemname}.';
$string['nonweightedpct'] = 'غير مثقّل %';
$string['nooutcome'] = 'لا توجد مخرجات تعلم';
$string['nooutcomes'] = 'ينبغي ربط عناصر مخرجات التعلم مع مخرجات تعلم المساق، ولكن لا توجد مخرجات تعلم لهذا المساق. هل ترغب في إضافة مخرج تعلم؟';
$string['nopermissiontoresetweights'] = 'لا صلاحية لإعادة ضبط الأوزان';
$string['nopublish'] = 'لا تنشر';
$string['noreports'] = 'لست منضماً إلى أي مساق في هذا الموقع ولا معلماً فيه.';
$string['norolesdefined'] = 'لم يتم تعريف أدوار في: الإدارة > التقديرات > الإعدادات العامة > الأدوار الممنوحة تقديرات';
$string['noscales'] = 'ينبغي ربط مخرجات التعلم مع مقاييس المساق أو المقياس العمومي، ولكن لا يوجد أي منها. هل ترغب بإضافة واحد؟';
$string['noselectedcategories'] = 'لم يتم اختيار التصنيفات';
$string['noselecteditems'] = 'لم يتم اختيار بنود';
$string['notenrolled'] = 'لست منضماً إلى أي مساقات حالياً.';
$string['notteachererror'] = 'لابد أن تكون معلما لتستطيع استخدام هذه الميزة';
$string['nousersloaded'] = 'لم يتم تحميل مستخدمين';
$string['nouserstograde'] = 'لا مستخدمين لمنحهم تقديرات';
$string['numberofgrades'] = 'عدد التقديرات';
$string['onascaleof'] = 'على مقياس يتراوح ما بين {$a->grademin} إلى {$a->grademax}';
$string['operations'] = 'عمليات';
$string['options'] = 'اختيارات';
$string['others'] = 'غيرها';
$string['otheruser'] = 'مستخدم';
$string['outcome'] = 'مخرج تعلم';
$string['outcome_help'] = 'هذا الإعداد يحدد المخرجات التي ستمثله عنصر التقييم في سجل التقديرات.';
$string['outcomeassigntocourse'] = 'خصص مخرج تعلم أخر لهذا المساق';
$string['outcomecategory'] = 'أنشئ مخرجات تعلم في هذا التصنيف';
$string['outcomecategorynew'] = 'تصنيف جديد';
$string['outcomeconfirmdelete'] = 'هل أنت متأكد من القيام بحذف مخرج التعلم "{$a}"؟';
$string['outcomecreate'] = 'إضافة مُخرج تعلم جديد';
$string['outcomedelete'] = 'أحذف مخرج تعلم';
$string['outcomefullname'] = 'الاسم كاملا';
$string['outcomeitem'] = 'بند مخرج تعلم';
$string['outcomeitemsedit'] = 'تحرير بند مخرج تعلم';
$string['outcomereport'] = 'تقرير مخرج تعلم';
$string['outcomes'] = 'مخرجات التعلم';
$string['outcomescourse'] = 'مخرجات التعلم المستعملة في المساق';
$string['outcomescoursecustom'] = 'التخصيص مستخدم (لن يتم الاستبعاد)';
$string['outcomescoursenotused'] = 'المعايير غير مستخدمة';
$string['outcomescourseused'] = 'المعايير مستخدمة (لن يتم الاستبعاد)';
$string['outcomescustom'] = 'مخرجات تعلم مخصصة';
$string['outcomesdisabled'] = 'المخرجات غير مُفعلة';
$string['outcomeshortname'] = 'الاسم المختصر';
$string['outcomesstandard'] = 'مخرجات تعلم قياسية';
$string['outcomesstandardavailable'] = 'مخرجات التعلم القياسية المتاحة';
$string['outcomestandard'] = 'مخرج تعلم قياسي';
$string['outcomestandard_help'] = 'المخرجات القياسية متاحة على مستوى كل الموقع ولكل المقررات الدراسية.';
$string['overallaverage'] = 'المتوسط العام';
$string['overridden'] = 'تم تجاوزها';
$string['overridden_help'] = 'عند تأشيرها، لن يكون بالإمكان تغيير الدرجة من جانب النشاط ذي الصلة.

عند تحرير الدرجة في تقرير المقيِّم، يتم تأشير خانة التجاوز تلقائياً. مع ذلك، يمكن رفع التأشير عنها للسماح مجدداً للنشاط ذي الصلة بالقيام بالتغييرات من جانبه.';
$string['overriddennotice'] = 'تم ضبط درجتك النهائية من هذا النشاط يدويًا.';
$string['overridecat'] = 'إسمح بالتجاوز اليدوي لتقديرات التصنيف';
$string['overridecat_help'] = 'تعطيل هذا الإعداد يجعله مستحيلاً على المستخدمين تجاوز تقديرات التصنيف';
$string['overridesitedefaultgradedisplaytype'] = 'تخطى إفتراضيات الموقع';
$string['overridesitedefaultgradedisplaytype_help'] = 'عند تأشيره، يمكن تحديد حروف التقديرات ومدياتها للمساق بدلاً من استعمال إفتراضيات الموقع.';
$string['overrideweightofa'] = 'تجاوز وزن {$a}';
$string['parentcategory'] = 'التصنيف الأعلى';
$string['pass'] = 'ناجح';
$string['pctoftotalgrade'] = '% المجموع الكل لدرجة';
$string['percent'] = 'نسبة';
$string['percentage'] = 'النسبة المئوية';
$string['percentageletter'] = 'نسبة مئوية (حرف)';
$string['percentagereal'] = 'نسبة مئوية (حقيقي)';
$string['percentascending'] = 'فرز تصاعدي حسب النسبة المئوية';
$string['percentdescending'] = 'فرز تنازلي حسب النسبة المئوية';
$string['percentshort'] = '%';
$string['plusfactor'] = 'العوض';
$string['plusfactor_help'] = 'العوض هو رقم مضاف إلى كل علامة ضمن عنصر التقييم هذه بعد الضرب بالمعامل.';
$string['plusfactorvalue'] = 'قيمة العوض لـ {$a}';
$string['points'] = 'نقاط';
$string['pointsascending'] = 'فرز تصاعدي حسب النقاط';
$string['pointsdescending'] = 'فرز تنازلي حسب النقاط';
$string['positionfirst'] = 'الأول';
$string['positionlast'] = 'الأخير';
$string['preferences'] = 'تفضيلات';
$string['prefgeneral'] = 'عام';
$string['prefletters'] = 'حروف التقديرات ومدياتها';
$string['prefrows'] = 'أسطر خاصة';
$string['prefshow'] = 'إظهار/إخفاء';
$string['previewrows'] = 'معاينة الصفوف';
$string['privacy:metadata:categorieshistory'] = 'سجل للنسخ السابقة من تصنيفات التقديرات';
$string['privacy:metadata:filepurpose'] = 'ملفات الإفادات المخزونة في سجل التقديرات والعائدة للمستخدم';
$string['privacy:metadata:grade_import_newitem'] = 'جدول مؤقت لتخزين أسماء عناصر التقييم الجديدة القادمة من عملية الاستيراد';
$string['privacy:metadata:grade_import_newitem:importcode'] = 'رمز فريد لتمييز دفعة استيرادات واحدة';
$string['privacy:metadata:grade_import_newitem:importer'] = 'المستخدم المستورد للبيانات';
$string['privacy:metadata:grade_import_newitem:itemname'] = 'اسم عنصر التقييم الجديد';
$string['privacy:metadata:grade_import_values'] = 'جدول مؤقت لاستيراد التقديرات';
$string['privacy:metadata:grade_import_values:feedback'] = 'إفادة الدرجة';
$string['privacy:metadata:grade_import_values:finalgrade'] = 'القيمة الخام للعلامة';
$string['privacy:metadata:grade_import_values:importcode'] = 'رمز فريد لتمييز دفعة استيرادات واحدة';
$string['privacy:metadata:grade_import_values:importer'] = 'المستخدم المستورد للبيانات';
$string['privacy:metadata:grade_import_values:importonlyfeedback'] = 'التأشير ما إذا تم استيراد الإفادات فقط';
$string['privacy:metadata:grade_import_values:userid'] = 'المستخدم الذي تم استيراد علامته';
$string['privacy:metadata:grades'] = 'سجل التقديرات';
$string['privacy:metadata:grades:aggregationstatus'] = 'حالة الإجمال';
$string['privacy:metadata:grades:aggregationweight'] = 'الوزن في الإجمالي';
$string['privacy:metadata:grades:feedback'] = 'الإفادة';
$string['privacy:metadata:grades:finalgrade'] = 'الدرجة';
$string['privacy:metadata:grades:information'] = 'معلومات إضافية عن التقدير';
$string['privacy:metadata:grades:timemodified'] = 'وقت آخر تعديل في الدرجة';
$string['privacy:metadata:grades:userid'] = 'مُعرَّف المستخدم صاحب الدرجة';
$string['privacy:metadata:grades:usermodified'] = 'مُعرَّف المستخدم الذي أجرى آخر تعديل في السجل';
$string['privacy:metadata:gradeshistory'] = 'سجل التقديرات السابقة';
$string['privacy:metadata:history:loggeduser'] = 'مُعرَّف المستخدم الذي كان مسجلاً دخوله حين تغيير النسخة';
$string['privacy:metadata:history:timemodified'] = 'وقت حدوث تغيير نسخة الدرجة';
$string['privacy:metadata:itemshistory'] = 'سجل النسخ السابقة من عناصر التقييم';
$string['privacy:metadata:outcomes'] = 'سجل المخرجات';
$string['privacy:metadata:outcomes:timemodified'] = 'وقت تعديل السجل';
$string['privacy:metadata:outcomes:usermodified'] = 'المستخدم الذي أجرى آخر تعديل في السجل';
$string['privacy:metadata:outcomeshistory'] = 'سجل النسخ السابقة من المخرجات';
$string['privacy:metadata:scale'] = 'سجل المقاييس';
$string['privacy:metadata:scale:timemodified'] = 'وقت إجراء التعديل الأخير في السجل';
$string['privacy:metadata:scale:userid'] = 'المستخدم الذي أجرى آخر تعديل في السجل';
$string['privacy:metadata:scalehistory'] = 'سجل النسخ السابقة من المقاييس';
$string['privacy:path:relatedtome'] = 'عائدة لي';
$string['privacy:request:historyactiondelete'] = 'إحذف';
$string['privacy:request:historyactioninsert'] = 'أدرج';
$string['privacy:request:historyactionupdate'] = 'حدِّث';
$string['privacy:request:unknowndeletedgradeitem'] = 'مجهول (عنصر التقييم تم حذفه)';
$string['profilereport'] = 'تقرير الملف الشخصي للمستخدم';
$string['profilereport_help'] = 'تقرير التقديرات المستعمل في صفحة الملف الشخصي للمستخدم.';
$string['publishing'] = 'النشر';
$string['publishingoptions'] = 'خيارات نشر التقديرات';
$string['quickfeedback'] = 'إفادة سريعة';
$string['quickgrading'] = 'تصحيح سريع';
$string['quickgrading_help'] = 'عند تمكينها، إذا كان التحرير مُفعلاً، سيظهر مربع إدخال نصي لكل علامة، مما يسمح بتحرير علامات كثيرة في نفس الوقت. يتم حفظ التغييرات وإبرازها عند النقر على زر التحديث.

لاحظ أنه عند تعديل العلامة في تقرير المقيِّم، فإشارة التجاوز ستصير فعالة تلقائياً، مما يدل على أن العلامة لم تعد خاضعة للتغيير من جهة النشاط ذي الصلة.';
$string['range'] = 'المدى';
$string['rangedecimals'] = 'المراتب العشرية للمدى';
$string['rangedecimals_help'] = 'عدد المراتب العشرية التي سيتم إظهارها للمدى.';
$string['rangesdecimalpoints'] = 'المراتب العشرية الظاهرة في المديات';
$string['rangesdecimalpoints_help'] = 'يحدد هذا الخيار عدد المراتب العشرية التي سيتم استعمالها لكل مدى، أو فيما إذا كان سيتم استعمال الإعداد العام لعدد المراتب العشرية للتصنيف أو العنصر (وراثة).';
$string['rangesdisplaytype'] = 'طريقة إظهار المدى';
$string['rangesdisplaytype_help'] = 'هذا الإعداد يحدد فيما إذا كان سيتم عرض المدى بأرقام حقيقية، نسبة مئوية أو بحروف، أو فيما إذا كان سيتم استعمال نوع العرض للتصنيف أو العنصر (وراثة).';
$string['rank'] = 'مرتبة';
$string['rawpct'] = 'الخام %';
$string['real'] = 'حقيقي';
$string['realletter'] = 'حقيقي (حرف)';
$string['realpercentage'] = 'حقيقي (نسبة مئوية)';
$string['recalculatinggrades'] = 'إعادة إحتساب التقديرات';
$string['recovergradesdefault'] = 'استعادة إفتراضات التقديرات';
$string['recovergradesdefault_help'] = 'إفتراضياً، قم باستعادة التقديرات الماضية للمستخدم عند إعادة ضمه إلى المساق.';
$string['refreshpreview'] = 'تنشيط المعاينة';
$string['regradeanyway'] = 'إعادة منح التقديرات بأي حال';
$string['removeallcoursegrades'] = 'كل التقديرات';
$string['removeallcoursegrades_help'] = 'عند تأشيرها، فإن كل عناصر التقييم والتقديرات التي تمت إضافتها يدوياً إلى سجل التقديرات ستُحذف، مع بيانات التقديرات في التجاوز، الاستبعاد، الإخفاء والتأمين. ستبقى فقط التقديرات المرتبطة بالنشاطات.';
$string['removeallcourseitems'] = 'كل عناصر التقييم وتصنيفاته';
$string['removeallcourseitems_help'] = 'عند تأشيرها، فإن كل التصنيفات وعناصر التقييم التي تمت إضافتها يدوياً في سجل التقديرات ستزول، مع التقديرات والبيانات المدخلة في العناصر على سبيل التجاوز، الاستبعاد، الإخفاء والتأمين. ستبقى فقط التقديرات المرتبطة بالنشاطات.';
$string['report'] = 'تقرير';
$string['reportdefault'] = 'افتراضي التقرير ({$a})';
$string['reportplugins'] = 'إضافات التقرير';
$string['reportsettings'] = 'إعدادات التقرير';
$string['reprintheaders'] = 'إعادة طباعة رؤس المواضيع';
$string['resetweights'] = 'إعادة تعيين الأوزان في {$a->itemname}';
$string['resetweightsshort'] = 'إعادة تعيين الأوزان';
$string['respectingcurrentdata'] = 'يجري ترك التهيئة الحالية بلا تعديل';
$string['rowpreviewnum'] = 'صفوف الاستعراض';
$string['rowpreviewnum_help'] = 'يمكن استعراض البيانات المعدة للاستيراد قبيل تأكيده. هذا الإعداد يحدد عدد الصفوف المطلوب عرضها عند الاستعراض.';
$string['savechanges'] = 'حفظ التغييرات';
$string['savepreferences'] = 'حفظ التفضيلات';
$string['scaleconfirmdelete'] = 'هل أنت متأكد من رغبتك في حذف المقياس "{$a}"؟';
$string['scaledpct'] = 'مُقايَس %';
$string['searchcollapsedcolumns'] = 'البحث في الأعمدة المطوية';
$string['seeallcoursegrades'] = 'مشاهدة كل تقديرات المساق';
$string['select'] = 'إختر {$a}';
$string['selectalloroneuser'] = 'إختر كل المستخدمين أو مستخدم واحد';
$string['selectauser'] = 'إختر المستخدم';
$string['selectdestination'] = 'إختر الموضع المقصود لـ {$a}';
$string['selectgrouplink'] = 'إختر المجموعة';
$string['selectuserlink'] = 'إختر المستخدم';
$string['separator'] = 'الفاصلة';
$string['separator_help'] = 'إختر الفاصلة المستعملة في ملف CSV. (عادة ما يكون فارزة).';
$string['sepcolon'] = 'نقطتان';
$string['sepcomma'] = 'فارزة';
$string['sepsemicolon'] = 'فارزة منقوطة';
$string['septab'] = 'علامة جدولة';
$string['setcategories'] = 'أعد تصنيفات ';
$string['setcategorieserror'] = 'يجب عليك أول تحديد التصنيفات لمساقك الدراسي قبل تحديد الاوزان لهم.';
$string['setgradeletters'] = 'وضع حروف التقديرات';
$string['setpreferences'] = 'وضع التفضيلات';
$string['setting'] = 'الإعداد';
$string['settings'] = 'الإعدادات';
$string['setup'] = 'التنصيب';
$string['setweights'] = 'وضع الأوزان';
$string['showactivityicons'] = 'أظهر أيقونة لنشاط';
$string['showactivityicons_help'] = 'عند تمكينه، إيقونات النشاطات ستظهر محاذية لأسمائها.';
$string['showallgrades'] = 'إظهار كل التقديرات';
$string['showallhidden'] = 'أظهر المخفي';
$string['showallstudents'] = 'إظهار كل الطلاب';
$string['showanalysisicon'] = 'إظهار أيقونة تحليل التقديرات';
$string['showanalysisicon_desc'] = 'هل سيتم إظهار أيقونة تحليل التقديرات بشكل افتراضي. إن كان النشاط يدعم هذا، فإن أيقونة تحليل التقديرات سترتبط بصفحة تقدم شرحاً تفصيلياً للعلامة وكيف تم الحصول عليها.';
$string['showanalysisicon_help'] = 'إذا كانت وحدة النشاط تدعم ذلك، فإن أيقونة تحليل العلامة ستعطي رابطاً إلى صفحة تحتوي شرحاً تفصيلياً عن العلامة وكيفية الحصول عليها.';
$string['showaverage'] = 'إظهار المتوسط';
$string['showaverage_help'] = 'فيما إذا كان ينبغي إظهار عمود المعدل. لاحظ أن بإمكان المشاركين تقدير درجات الآخرين إن كان المعدل محسوباً من عدد قليل من الدرجات. لأسباب تتعلق بالأداء، المعدل سيكون تقريبياً إن كان معتمداً على أي عناصر مخفية.';
$string['showaverages'] = 'إظهار متوسطات الأعمدة';
$string['showaverages_help'] = 'عند تمكينه، سيتضمن تقرير المقيِّم صفاً إضافياً يعرض معدل (متوسط) كل تصنيف وعنصر.';
$string['showcalculations'] = 'إظهار الحسابات';
$string['showcalculations_help'] = 'عند تمكينه، ستظهر أيقونة لكل عنصر وتصنيف عند التحرير مع مؤشر بصري للدلالة على أن العنصر محسوب.';
$string['showcontributiontocoursetotal'] = 'أظهر نسبة المشاركة في إجمالي المقرر';
$string['showcontributiontocoursetotal_help'] = 'فيما إذا كان ينبغي إظهار عمود يحتوي نسب مئوية تشير إلى نسبة تأثير كل عنصر في الدرجة النهائية للمستخدم في المساق (بعد تطبيق الأوزان).';
$string['showeyecons'] = 'أظهر أيقونة الإظهار/الإخفاء';
$string['showeyecons_help'] = 'عند تمكينه، إذا تم تفعيل التحرير، ستظهر أيقونة إظهار/إخفاء لكل عنصر للتحكم بظهوره أمام أعين الطلبة.';
$string['showfeedback'] = 'إظهار الإفادة';
$string['showfeedback_help'] = 'فيما إذا كان ينبغي إظهار عمود الإفادة.';
$string['showgrade'] = 'إظهار التقديرات';
$string['showgrade_help'] = 'فيما إذا كان ينبغي إظهار عمود التقديرات.';
$string['showgroups'] = 'أظهر المجموعات';
$string['showhiddenitems'] = 'إظهار العناصر المخفية';
$string['showhiddenitems_help'] = 'فيما إذا كانت العناصر المخفية مخفية تماماً أو أن أسماءها ستظهر للطلبة.

* إظهاره مخفياً - أسماء العناصر المخفية ستظهر لكن تقديراتها سيتم إخفاؤها
* فقط مخفية حتى - العناصر ذات الإعداد "مخفية حتى" مع ضبط التاريخ ستكون مخفية تماماً حتى التاريخ المحدد، والذي بعده سيظهر كل شيء
* لا تُظهر - العناصر المخفية لن يظهر منها شيء';
$string['showhiddenuntilonly'] = 'فقط مخفي حتى';
$string['showingaggregatesonly'] = 'يجري إظهار الإجماليات فقط';
$string['showingfullmode'] = 'يجري إظهار التقديرات والإجماليات';
$string['showinggradesonly'] = 'إظهار التقديرات فقط';
$string['showlettergrade'] = 'إظهار أحرف التقديرات';
$string['showlettergrade_help'] = 'فيما إذا كان ينبغي إظهار عمود لحروف التقديرات.';
$string['showlocks'] = 'إظهار الأقفال';
$string['showlocks_help'] = 'عند تمكينه، إذا تم تمكين التحرير، ستظهر أيقونة قفل/فك لكل تقدير للسيطرة على إمكانية النشاط في التحديث التلقائي للتقدير.';
$string['shownohidden'] = 'لا تظهر';
$string['shownooutcomes'] = 'أخفِ مخرجات التعلم';
$string['shownumberofgrades'] = 'إظهار عدد التقديرات في المتوسطات';
$string['shownumberofgrades_help'] = 'إن تم تفعيله، سيتم عرض عدد التقديرات التي تم استعمالها عند احتساب المتوسط بين قوسين بعد كل متوسط.';
$string['showonlyactiveenrol'] = 'أظهر الإنضمامات النشطة فقط';
$string['showonlyactiveenrol_help'] = 'هذا الإعداد يحدد فيما إذا كان تقرير سجل التقديرات سيقتصر على أصحاب الإنضمامات النشطة. عند تمكينه، المستخدمون المعلقون لن يظهروا في سجل التقديرات.';
$string['showpercentage'] = 'إظهار النسبة المئوية';
$string['showpercentage_help'] = 'فيما إذا كان ينبغي إظهار النسبة المئوية لكل عنصر تقييم.';
$string['showquickfeedback'] = 'إظهار الإفادة السريعة';
$string['showquickfeedback_help'] = 'عند تمكينه، إذا تم تمكين التحرير، سيظهر مربع نص ذو حدود متقطعة لإدخال الإفادة لكل علامة، مما يسمح بتحرير العديد من الإفادات في نفس الوقت. التغييرات تُحفظ ويتم إبرازها عند النقر على زر التحديث.

لاحظ أنه عند تحرير الإفادة في تقرير المقيِّم، يتم تأشير التجاوز، ما يعني أن الإفادة لن تعود قابلة للتغيير من طرف النشاط ذي الصلة.';
$string['showrange'] = 'إظهار المديات';
$string['showrange_help'] = 'فيما إذا كان ينبغي إظهار عمود المدى.';
$string['showranges'] = 'إظهار المديات';
$string['showranges_help'] = 'عند تمكينه، فإن تقرير المقيِّم سيحتوي على صف إضافي يعرض المدى لكل تصنيف وعنصر تقييم.';
$string['showrank'] = 'عرض الترتيب';
$string['showrank_help'] = 'فيما إذا كان ينبغي إظهار ترتيب الطالب بين باقي زملائه لكل عنصر تقييم.';
$string['showuserimage'] = 'إظهار صور الملف الشخصي للمستخدمين';
$string['showuserimage_help'] = 'فيما إذا كان ينبغي إظهار صورة المستخدم بجوار اسمه في تقرير المقيِّم.';
$string['showverbose'] = 'أظهر {$a->category} {$a->itemmodule} {$a->itemname}';
$string['showweight'] = 'إظهار الأوزان';
$string['showweight_help'] = 'فيما إذا كان ينبغي إظهار عمود وزن الدرجة.';
$string['simpleview'] = 'معاينة منفردة';
$string['sitewide'] = 'على مستوى الموقع';
$string['sort'] = 'فرز';
$string['sortasc'] = 'فرز في ترتيب تصاعدي';
$string['sortbyfirstname'] = 'الفرز حسب الاسم الأول';
$string['sortbylastname'] = 'الفرز حسب اسم العائلة';
$string['sortdesc'] = 'الفرز في ترتيب تنازلي';
$string['standarddeviation'] = 'الانحراف المعياري';
$string['stats'] = 'الإحصائيات';
$string['statslink'] = 'أحصاء';
$string['student'] = 'طالب';
$string['studentsperpage'] = 'الطلاب في الصفحة الواحدة';
$string['studentsperpage_help'] = 'هذا الإعداد يحدد عدد الطلبة المراد عرضهم لكل صفحة في تقرير المقيِّم.';
$string['studentsperpagereduced'] = 'قلل العدد الأقصى للطلبة المراد عرضهم لكل صفحة من {$a->originalstudentsperpage} إلى {$a->studentsperpage}. خذ بنظر الاعتبار زيادة إعداد PHP المسمى max_input_vars واجعله أكثر من {$a->maxinputvars}.';
$string['subcategory'] = 'التصنيف الاعتيادي';
$string['submissions'] = 'تسليمات';
$string['submittedon'] = 'مُسلَّمة في: {$a}';
$string['sumofgradesupgradedgrades'] = 'ملاحظة: طريقة الإجمال "مجموع الدرجات" قد تم تغييرها إلى "بسيط" كجزء من ترقية الموقع. بما أن "مجموع الدرجات" كان مستعملاً سابقاً في هذا المساق، من الموصى به أن تقوم بمراجعة التغييرات في سجل التقديرات.';
$string['switchtofullview'] = 'التحول إلى معاينة كاملة';
$string['switchtosimpleview'] = 'التحول إلى معاينة بسيطة';
$string['topcategory'] = 'التصنيف الأعلى';
$string['total'] = 'المجموع';
$string['totalweight100'] = 'الوزن الكل يساوي 100';
$string['totalweightnot100'] = 'الوزن الكل لا يساوي 100';
$string['turnfeedbackoff'] = 'إيقاف الإفادات';
$string['turnfeedbackon'] = 'تفعيل الإفادات';
$string['typenone'] = 'لا شيء';
$string['typescale'] = 'المقياس';
$string['typescale_help'] = 'هذا الإعداد يحدد المقياس المستعمل عند اللجوء إلى التقييم المستند إلى المقاييس. المقياس الخاص بمفردة مرتبطة بنشاط ما، يتم ضبطها من صفحة إعدادات النشاط.';
$string['typetext'] = 'نص';
$string['typevalue'] = 'قيمة';
$string['uncategorised'] = 'غير مصنف';
$string['unchangedgrade'] = 'لم يتغير التقدير';
$string['unenrolledusersinimport'] = 'عملية الاستيراد هذه تضمنت التقديرات الآتية لمستخدمين ليسوا منضمين حالياً إلى هذا المساق: {$a}';
$string['unlimitedgrades'] = 'تقديرات غير محددة';
$string['unlimitedgrades_help'] = 'إفتراضياً، الدرجات تتراوح ما بين القيمتين العظمى والصغرى لمفردة التقييم. تمكين هذا الإعداد يزيل هذا التقييد مما يسمح لدرجات تتجاوز 100% بأن يتم إدخالها مباشرة في سجل التقديرات.';
$string['unlock'] = 'إلغاء التأمين';
$string['unlockverbose'] = 'إلغاء تأمين {$a->category} {$a->itemmodule} {$a->itemname}';
$string['unused'] = 'غير مستعمل';
$string['updatedgradesonly'] = 'تصدير التقديرات الجديدة أو المحدَّثة فقط';
$string['upgradedgradeshidemessage'] = 'إصرف الملاحظة';
$string['upgradedminmaxrevertmessage'] = 'تراجع عن التغييرات';
$string['uploadgrades'] = 'رفع التقديرات';
$string['useadvanced'] = 'استعمل المزايا المتقدمة';
$string['usedcourses'] = 'المقررات الدراسية المستخدمة';
$string['usedgradeitem'] = 'مفردة التقييم المستعملة';
$string['usenooutcome'] = 'لا تستخدم مخرجات تعلم';
$string['usenoscale'] = 'لا تستخدم مقياس';
$string['usepercent'] = 'استعمل النسب المئوية';
$string['user'] = 'مستخدم';
$string['userenrolmentsuspended'] = 'تم تعليق انضمام المستخدم';
$string['userfields_show'] = 'أظهر حقول المستخدم';
$string['userfields_show_help'] = 'أظهر حقول المستخدم الإضافية مثل البريد الالكتروني في تقرير المقيِّم. الحقول المعروضة بعينها تتم السيطرة على اختيارها بواسطة الإعداد showuseridentity على مستوى الموقع';
$string['usergrade'] = 'المستخدم {$a->fullname} ({$a->useridnumber}) في المفردة {$a->gradeidnumber}';
$string['userid'] = 'مُعرَّف المستخدم';
$string['useridnumberwarning'] = 'المستخدمون الذين ليس لهم مُعرَّف يتم استبعادهم من التصدير لتعذر استيرادهم';
$string['usermappingerror'] = 'خطأ في تعيين المستخدم: تعذر العثور على المستخدم الذي له {$a->field} بقيمة "{$a->value}".';
$string['usermappingerrorcurrentgroup'] = 'المستخدم ليس عضواً في المجموعة الحالية.';
$string['usermappingerrormultipleusersfound'] = 'خطأ في تعيين المستخدم: أكثر من مستخدم لديهم {$a->field} بقيمة "{$a->value}". لطفاً، استعمل حقل تعيين أكثر فرادة.';
$string['usermappingerrorusernotfound'] = 'خطأ في تعيين المستخدم. تعذر العثور على المستخدم.';
$string['userpreferences'] = 'تفضيلات مستخدم';
$string['useweighted'] = 'استعمل الموزون';
$string['verbosescales'] = 'مقاييس مسهبة';
$string['verbosescales_help'] = 'المقياس المسهب يستعمل الكلمات بدلاً من الأرقام. ضعه على \'نعم\' إذا كان المراد استيراد المقاييس الرقمية والمسهبة معاً. ضعه على \'لا\' إذا كان في النية استيراد المقاييس الرقمية فقط.';
$string['viewas'] = 'معاينة التقرير بمثابة';
$string['viewbygroup'] = 'محموعة';
$string['viewfeedback'] = 'معاينة الإفادة';
$string['viewgrades'] = 'معاينة التقديرات';
$string['weight'] = 'الوزن';
$string['weight_help'] = 'قيمة مستعملة لتحديد القيمة النسبية لعناصر متعددة في التصنيف أو المقرر.';
$string['weightcourse'] = 'استعمل التقديراتالموزونة في المساق';
$string['weightedascending'] = 'فرز تصاعدي حسب النسبة المئوية للوزن';
$string['weighteddescending'] = 'فرز تنازلي حسب النسبة المئوية للوزن';
$string['weightedpct'] = 'النسبة المئوية للوزن';
$string['weightedpctcontribution'] = 'توزيع النسبة المئوية للوزن';
$string['weightofa'] = 'وزن {$a}';
$string['weightorextracredit'] = 'وزن أم رصيد إضافي';
$string['weightoverride'] = 'تسوية الوزن';
$string['weightoverride_help'] = 'أزل التأشيرة لإعادة تعيين وزن المفردة إلى قيمته المحسوبة تلقائياً. التأشير هنا سيمنع من إجراء التسوية التلقائية على الوزن.';
$string['weights'] = 'الأوزان';
$string['weightsadjusted'] = 'تمت تسوية أوزانك إلى إجمالي قدره 100.';
$string['weightsedit'] = 'تحرير الأوزان والأرصدة الإضافية';
$string['weightuc'] = 'الوزن المحسوب';
$string['writinggradebookinfo'] = 'إعدادات كتابة سجل التقديرات';
$string['xml'] = 'XML';
$string['yes'] = 'نعم';
$string['yourgrade'] = 'الدرجة التي حصلت عليها';
