<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_degrade', language 'sr_lt', version '4.5'.
 *
 * @package     theme_degrade
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['access_course'] = 'Pristup kursu';
$string['acctoolbar_access_declaration'] = 'izjava o pristupačnosti';
$string['acctoolbar_btn_bright'] = 'svetao<br>kontrast';
$string['acctoolbar_btn_close'] = '✗ zatvori';
$string['acctoolbar_btn_cursor_black'] = 'veliki crni<br>kursor';
$string['acctoolbar_btn_cursor_white'] = 'veliki beli<br>kursor';
$string['acctoolbar_btn_font_down'] = 'smanji<br>veličinu teksta';
$string['acctoolbar_btn_font_up'] = 'povećaj<br>veličinu teksta';
$string['acctoolbar_btn_images_titles'] = 'naslovi<br>slika';
$string['acctoolbar_btn_invert'] = 'obrnuti<br>kontrast';
$string['acctoolbar_btn_monochrome'] = 'neobojen<br>prikaz';
$string['acctoolbar_btn_open'] = 'Meni za pristupačnost';
$string['acctoolbar_btn_underline_headers'] = 'podvučena<br>zaglavlja';
$string['acctoolbar_btn_underline_links'] = 'podvučeni<br>linkovi';
$string['acctoolbar_btn_zoom_in'] = 'zum<br>екран';
$string['acctoolbar_content_block_header'] = 'isticanje sadržaja';
$string['acctoolbar_contrast_block_header'] = 'kontrast boja';
$string['acctoolbar_debug_contacts'] = 'prijavite problem sa pristupačnošću sajtu';
$string['acctoolbar_image_without_alt'] = 'slika bez teksta';
$string['acctoolbar_keyboard_root'] = 'navigacija sa tastature';
$string['acctoolbar_reset_all_settings'] = 'resetujte podešavanja';
$string['acctoolbar_text_block_header'] = 'veličina teksta';
$string['acctoolbar_toolbar'] = 'Traka sa alatkama za pristupačnost';
$string['acctoolbar_zoom_block_header'] = 'uvećaj';
$string['background_color'] = 'Boja pozadine';
$string['background_color_black'] = 'Crna tema {$a}';
$string['background_color_blue'] = 'Plava tema {$a}';
$string['background_color_brasil'] = 'Brazil';
$string['background_color_default'] = 'Podrazumevana tema {$a}';
$string['background_color_desc'] = 'Boja pozadine vrha i podnožja stranice!';
$string['background_color_green'] = 'Zelena tema {$a}';
$string['background_color_random'] = 'Naumična grafička tema {$a}';
$string['background_color_red'] = 'Crvena tema {$a}';
$string['background_course_image'] = 'Podrazumevana pozadinska slika kursa';
$string['background_course_image_desc'] = 'Podešava podrazumevanu pozadinsku sliku za zaglavlje svih kurseva. Ova slika će biti prikazana na vrhu stranice kursa i može se pojedinačno zameniti u podešavanjima kursa.';
$string['background_profile_image'] = 'Pozadinska slika profila';
$string['background_profile_image_desc'] = 'Pozadinska slika koja se prikazuje na stranici korisničkog profila.';
$string['background_text_color'] = 'Boja teksta';
$string['background_text_color_desc'] = 'Boja teksta na vrhu i u podnožju stranice';
$string['cachedef_css_cache'] = 'CSS keš';
$string['choosereadme'] = 'Degrade je grafička tema pažljivo kreirana sa namerom da unese vedre boje u Moodle.';
$string['contact_address'] = 'Adresa';
$string['contact_email'] = 'E-adresa';
$string['contact_phone'] = 'Broj telefona';
$string['content_pagefonts'] = 'Google dodatni fontovi';
$string['content_pagefonts_desc'] = 'Dodaj ovde @import link sa Google-a za dodatne fontove.<br> Možete staviti više linkova za import.<br><a href="https://fonts.google.com/selection/embed" target="google">Уметнути кôд</a><br><img src="{$a}" style="max-width: 100%;width: 420px;">';
$string['content_type_default'] = 'Moodle standardno';
$string['content_type_empty'] = '(Bez sadržaja)';
$string['content_type_footer'] = 'Tip sadržaja za podnožje';
$string['content_type_footer_desc'] = 'Izaberite tip sadržaja koji želite da prikažete u podnožju.';
$string['content_type_home'] = 'Tip sadržaja za početnu stranicu';
$string['content_type_home_desc'] = 'Izaberite tip sadržaja koji želite da prikažete na početnoj stranici.';
$string['content_type_html'] = 'Stranica koja se kreira pomoću editora';
$string['continuar'] = 'Nastavite sa učenjem';
$string['countlesson'] = '{$a} lekcija';
$string['countlessons'] = '{$a} lekcije/a';
$string['course_access'] = 'Pristupite kursu';
$string['course_moore'] = 'Više detalja';
$string['customcss'] = 'Prilagođeni CSS';
$string['customcss_desc'] = 'Sva CSS pravila koja dodate u ovo polje za teksta odraziće se na sve stranice, što olakšava prilagođavanje ove teme.';
$string['customfield_category_name'] = 'Prilagođavanje teme';
$string['customfield_field_image'] = 'Prilagođena slika';
$string['customfield_field_name'] = 'Prikaži sliku na vrhu kursa';
$string['custommenuitems'] = 'Prilagođene stavke menija na vrhu stranice';
$string['custommenuitems_desc'] = 'Pored menija na vrhu stranice možete kreirati prilagođeni meni. Osnovni meni treba da počinje u ravni sa ivicom menija, a podmeniju treba da prethodi crtica (-). Broj crtica određuje dubinu tj. poziciju stavke u meniju. Dakle, stavke sa jednom crticom pojavljuju se u podmeniju ispod prethodne stavke najvišeg nivoa, a stavke sa dve crtice se pojavljuju u podmeniju ispod prethodnog podmenija.
Sadržaj svake stavke u meniju treba da se sastoji od najviše tri elementa (<strong>label</strong> | <strong>url</strong> | <strong>tooltip</strong> | <strong>lang</strong>), сваки одвојен знаком "|".
<ul>
<li><strong>label</strong>: Ovo je tekst koji će biti prikazan u okviru stavke u meniju. Morate navesti oznaku za svaku stavku u meniju.</li>
<li><strong>url</strong>: Ovo je URL adresa na koju će korisnik biti preusmeren nakon što klikne na stavku u meniju. Ovo je opciono; ako URL adresa nije navedena stavka u meniju neće biti linkovana.<br>
Ostali atributi kao što je "target" mogu se dodati na kraj URL adrese.</li>
<li><strong>tooltip</strong>: Ako ste naveli URL adresu, takođe možete izabrati da pružite kratak opis linka koji ste kreirali pomoću URL adrese. Ovo je opciono, a ako nije definisano, oznaka (label) će se koristi kao kratak opis stavke u meniju.</li>
<li><strong>lang</strong>: Takođe, možete dodati kôd jezika (ili spisak kôdova razdvojenih zarezima) kao četvrti element reda. Stavka u meniju će biti prikazana samo ako je korisnik izabrao neki od navedenih jezika.</li>
</ul>
U nastavku možete videti primer kako da kreirate prilagođeni meni:
<blockquote><pre>
Courses
-All courses | /course/
-My courses
--Example Course
---Example Course 7 | /course/view.php?id=7
---Example Course 9 | /course/view.php?id=9
--Test Course
---Test Course 2 | /course/view.php?id=2
---Test Course 5 | /course/view.php?id=5
Google
-Google in any language | https://google.com/" target="_blank
-Google in Mexico | https://www.google.com.mx/" target="_blank|Google Label|en
-Google in Portuguese | https://google.com.br/" target="_blank|Google Label|pt,pt_br,pt_br_kids
Support Page | https://support.com/" target="_blank
</pre></blockquote>
For Moodle with support for multiple languages, the <strong>label</strong> value should be formatted as <strong>"langstringname,componentname"</strong>.
<blockquote><pre>
profile,moodle | /user/profile.php
messages,message | /message/index.php
</pre></blockquote>
<a href="https://docs.moodle.org/404/en/Advanced_theme_settings" target="_blank">Više informacija o meniju</a>';
$string['editor_link_footer'] = 'Uredite blokove podnožja za {$a} jezik';
$string['editor_link_footer_all'] = 'Uredite blokove podnožja za sve jezike';
$string['editor_link_home'] = 'Uredite početnu stranicu za {$a} jezik';
$string['editor_link_home_all'] = 'Uredite početnu stranicu za sve jezike';
$string['favicon'] = 'Favikonica';
$string['favicon_desc'] = 'Favikonica se prikazuje pored naslova stranice na kartici veb čitača. Ako prilagođena favikonica nije obezbeđena biće prikazana Moodle favikonica.';
$string['fontfamily'] = 'Fontovi teksta na sajtu';
$string['fontfamily_desc'] = 'Izaberite koji font želite da koristite za tekst na svom Moodle sajtu.';
$string['fontfamily_menus'] = 'Fontovi menija';
$string['fontfamily_menus_desc'] = 'Izaberite koji font želite da koristite za menije na svom Moodle sajtu.';
$string['fontfamily_sitename'] = 'Font za naziv sajta';
$string['fontfamily_sitename_desc'] = 'Font koji će biti primenjen na naziv sajta ako logotip nije obezbeđen.';
$string['fontfamily_title'] = 'Fontovi teksta naslova';
$string['fontfamily_title_desc'] = 'Izaberite koji font želite da koristite za naslove na svom Moodle sajtu.';
$string['fontpreview'] = 'Pregled spiska fontova';
$string['footer_contact_title'] = 'Naslov bloka sa kontakt podacima';
$string['footer_contact_title_default'] = 'Kontaktirajte nas';
$string['footer_contact_title_desc'] = 'Unesite naslov bloka koji će se pojaviti u podnožju sa podacima o kontaktu.';
$string['footer_description'] = 'Opis';
$string['footer_description_desc'] = 'Opišite svoj Moodle, šta radite, a ove informacije će biti prikazane ispod logotipa u podnožju stranice';
$string['footer_frontpage_blockcourses_instructor'] = 'Pokažite imena predavača';
$string['footer_frontpage_blockcourses_instructor_desc'] = 'Ako je označeno, prikazuje imena predavača na spisku kurseva!';
$string['footer_frontpage_blockcourses_text'] = 'Kratak tekst koji objašnjava blok "{$a}"';
$string['footer_frontpage_blockcourses_text_desc'] = 'Dodajte tekst koji opisuje blok "{$a}"!';
$string['footer_links_title'] = 'Naslov bloka sa linkovima';
$string['footer_links_title_default'] = 'Važni linkovi';
$string['footer_show_copywriter'] = 'Prikaži pruku "Kreirano sa ❤️"';
$string['footer_show_copywriter_desc'] = 'Opozovite izbor ako želite da saktijete poruku ”Kreirano sa ❤️”';
$string['footer_social_title'] = 'Naslov bloka sa linkovima društvenih mreža';
$string['footer_social_title_default'] = 'Pratite nas na društvenim mrežama';
$string['footer_social_title_desc'] = 'Unesite naslov bloka koji će se pojaviti u podnožju sa podacima sa vaših društvenih mreža.';
$string['footerblink'] = 'Linkovi blokova podnožja';
$string['footerblink_desc'] = 'Ovde možete da konfigurišete linkove blokova u podnožju koji će biti prikazani.<br>Svaki red se sastoji od teksta stavke u meniju ili jezičkog ključa ili teksta, kao i URL adrese (opciono), razdvojenih vertikalnim trakama. Na primer:<br><pre>Moodle Support|https://moodle.org/support</pre>';
$string['footerblock_contact'] = 'Blok sa kontakt podacima';
$string['footerblock_copywriter'] = 'Kreirano sa ❤️';
$string['footerblock_description'] = 'Blok sa opisom';
$string['footerblock_links'] = 'Blok sa linkovima';
$string['footerblock_social'] = 'Blok društvenih mreža';
$string['free_name'] = 'Besplatno';
$string['frontpage_about_description'] = 'Opišite šta radite';
$string['frontpage_about_description_desc'] = 'Opišite u najviše 5 redova kome je namenjen vaš Moodle';
$string['frontpage_about_enable'] = 'Omogućite blok \'O nama\'';
$string['frontpage_about_enable_desc'] = 'Ako je označeno, blok \'O nama\' će se pojaviti ispod banera!';
$string['frontpage_about_info'] = 'Polje sa podacima {$a}';
$string['frontpage_about_logo'] = 'Ovde će biti prikazan drugačiji logo';
$string['frontpage_about_logo_desc'] = 'Ako je podešen, ovaj logotip će se koristiti umesto logotipa na vrhu stranice.<br>Ako se polje ostavi prazno koristići se standardni logotip na vrhu stranice,';
$string['frontpage_about_number'] = 'Broj';
$string['frontpage_about_number_desc'] = 'Unesite broj za gore navedeno polje sa podacima';
$string['frontpage_about_text'] = 'Naziv polja sa podacima';
$string['frontpage_about_text_1_defalt'] = 'Kursevi';
$string['frontpage_about_text_2_defalt'] = 'Predavači';
$string['frontpage_about_text_3_defalt'] = 'Polaznici';
$string['frontpage_about_text_4_defalt'] = 'Lekcije';
$string['frontpage_about_text_desc'] = 'Unesite naziv podataka koji će biti prikazani na početnoj stranici';
$string['frontpage_about_title'] = 'Naslov bloka\'O nama\'';
$string['frontpage_about_title_default'] = 'Naša globalna zajednica';
$string['heart'] = 'Ako vam se sviđa ova tema, ne zaboravite da kliknete na ❤️ na stranici za grafičke teme <a href="{$a}" target="_blank">tako što ćete kliknuti ovde</a>';
$string['instructor'] = 'Instruktor';
$string['login_backgroundcolor'] = 'Boja pozadine';
$string['login_backgroundcolor_desc'] = 'Izaberite boju pozadine stranice za obnovu izgubljene/zaboravljene lozinke';
$string['login_backgroundfoto'] = 'Pozadinska slika';
$string['login_backgroundfoto_desc'] = 'Izaberite pozadinsku sliku stranice za prijavu, za obnovu izgubljene/zaboravljene lozinke, kao i za kreiranje naloga. Podrazumevana slika je: {$a}';
$string['login_forgot_description'] = 'Tekst sa strane na stranici za zaboravljenu lozinku';
$string['login_forgot_description_desc'] = 'Tekst koji će se pojaviti samo na stranici za zaboravljenu lozinku';
$string['login_login_description'] = 'Tekst sa strane koji će se pojaviti na stranici za prijavu';
$string['login_login_description_desc'] = 'Tekst koji će se pojaviti samo na stranici za prijavu';
$string['login_signup_description'] = 'Tekst sa strane na stranici za kreiranje naloga';
$string['login_signup_description_desc'] = 'Tekst koji će se pojaviti samo na stranici za kreiranje naloga';
$string['login_theme'] = 'Izgled stranice za prijavu';
$string['login_theme_block'] = 'Centralni beli blok sa opcionom pozadinom';
$string['login_theme_desc'] = 'Izaberite kako želite da izgleda stranica za prijavu';
$string['login_theme_image_login'] = 'Pozadinska slika i obrazac za prijavu sa strane';
$string['login_theme_imagetext_login'] = 'Pozadinska slika, tekst preko slike i obrazac za prijavu sa strane';
$string['login_theme_login'] = 'Samo obrazac za prijavu, bez bočne slike';
$string['logo_color'] = 'Logo u boji';
$string['logo_color_desc'] = 'Postavite svoj LOGO u boji ako želite da on bude prikazan pri vrhu stranice. Ovaj logo će biti vidljiv prilikom premotavanja (skrolovanja) stranice, dok će meni biti prikazan na beloj pozadini.';
$string['logo_write'] = 'Logo menija na vrhu stranice prilikom skrolovanja';
$string['logo_write_desc'] = 'Postavite svoj logo ako želite da on bude prikazan pri vrhu stranice. Ovaj logo će biti vidljiv prilikom premotavanja (skrolovanja) stranice, dok će meni biti prikazan na pozadini u boji.';
$string['matricular'] = 'Upišite se';
$string['mycourses_color'] = 'Boja pozadine bloka';
$string['mycourses_color_desc'] = 'Boja pozadine za blok.';
$string['mycourses_icon'] = 'Ikonica';
$string['mycourses_icon_desc'] = 'Reprezentativna ikonica za blok. Veličina ikone treba da bude 48x48 piksela.';
$string['mycourses_info'] = 'Blok {$a}';
$string['mycourses_numblocos'] = 'Broj blokova';
$string['mycourses_numblocos_desc'] = 'Koliko slika želite da ima slajd-šou?';
$string['mycourses_numblocos_nenhum'] = 'Nema blokova na početnoj stranici';
$string['mycourses_title'] = 'Kratki naslov bloka';
$string['mycourses_title_desc'] = 'Kratak i deskriptivan naslov za blok.';
$string['mycourses_url'] = 'Link bloka';
$string['mycourses_url_desc'] = 'URL adresa na koju će korisnik biti preusmeren kada klikne na blok. To može biti eksterni ili interni link unutar platforme.';
$string['pluginname'] = 'Degrade';
$string['privacy:metadata'] = 'Grafička tema Degrade ne čuva nikakve lične podatke o bilo kom korisniku.';
$string['progress_percentage'] = 'Vaš napredak';
$string['settings_about_heading'] = 'O vašem Moodleu';
$string['settings_accessibility'] = 'Omogućite opcije za pristupačnost';
$string['settings_accessibility_desc'] = 'Omogućava prilagođavanje opcija za poboljšanje pristupačnosti platformi, kao što su kontrast, veličina fonta i navigacija na tastaturi.';
$string['settings_accessibility_heading'] = 'Pristupačnost';
$string['settings_course_heading'] = 'Podešavanja kursa';
$string['settings_css_heading'] = 'Fontovi i CSS';
$string['settings_footer_heading'] = 'Blokovi podnožja';
$string['settings_icons_change_icons'] = 'Promenite podrazumevanu ikonicu na spisku kurseva';
$string['settings_icons_color_icon'] = 'Podesite prilagođenu boju za ikonicu.';
$string['settings_icons_color_icon_desc'] = 'Izaberite boju pozadine za ikonicu prikazanu na spisku kurseva. Ostavite prazno kako biste koristili boju podrazumevanu za teme.';
$string['settings_icons_upload_icon'] = 'Postavite prilagođenu ikonicu.';
$string['settings_login_heading'] = 'Stranica za prijavu';
$string['settings_mycourses_heading'] = 'Blokovi na stranici \'Moji kursevi\'';
$string['settings_slideshow_heading'] = 'Slajd-šou';
$string['settings_theme_heading'] = 'Grafička tema';
$string['settings_top_heading'] = 'Meni na vrhu stranice';
$string['sitefonts'] = 'Dodatni Google fontovi';
$string['sitefonts_desc'] = 'Umetni @import kôd servisa Google fontovi kao što je prikazano na slici ispod. Nakon što sačuvate, polje "Fontovi sajta" će biti ažurirano, prikazujući ove fontove. Možete dodati više @import kôdova po potrebi.';
$string['slidecaption_desc'] = 'Unesite tekst naslova koji će se koristiti na slajdu';
$string['slideshow_image'] = 'Slika slajda';
$string['slideshow_image_desc'] = 'Slika treba da bude veličine 1250 x 400 piksela.';
$string['slideshow_info'] = 'Slajd {$a}';
$string['slideshow_numslides'] = 'Koliko slika staviti u slajd-šou';
$string['slideshow_numslides_desc'] = 'Koliko slika želite da ima slajd-šou?';
$string['slideshow_numslides_nenhum'] = 'Nema slajdova na početnoj stranici';
$string['slideshow_text'] = 'Kratak opisni tekst za slajd';
$string['slideshow_text_desc'] = 'Ubacite kratak tekst o slajdu.';
$string['slideshow_url'] = 'Link dugmeta na slajdu';
$string['slideshow_url_desc'] = 'Umetnite odredišni link za dugme na slici slajda';
$string['social_facebook'] = 'Ваш Facebook';
$string['social_facebook_desc'] = 'URL adresa Facebook naloga vaše organizacije/institucije';
$string['social_instagram'] = 'Vaš Instagram';
$string['social_instagram_desc'] = 'URL adresa Instagram naloga vaše organizacije/institucije';
$string['social_linkedin'] = 'Vaš Linkedin';
$string['social_linkedin_desc'] = 'URL adresa Linkedin naloga vaše organizacije/institucije';
$string['social_twitter'] = 'Vaš Twitter';
$string['social_twitter_desc'] = 'URL adresa Twitter naloga vaše organizacije/institucije.';
$string['social_youtube'] = 'Vaš Youtube';
$string['social_youtube_desc'] = 'URL adresa Youtube kanala vaše organizacije/institucije';
$string['tableofcontents'] = 'Sadržaj';
$string['theme_color-color_buttons'] = 'Boja dugmadi';
$string['theme_color-color_buttons_desc'] = 'Boja koja se koristi za dugmad, i koja ne samo da doprinosi vizuelnom identitetu već i naglašava interaktivnost.';
$string['theme_color-color_names'] = 'Boja naziva';
$string['theme_color-color_names_desc'] = 'Boja koja se koristi za isticanje naziva ili identifikatora, što doprinosi jasnoći i naglašava određene tekstualne informacije.';
$string['theme_color-color_primary'] = 'Primarna boja';
$string['theme_color-color_primary_desc'] = 'Glavna primarna boja teme, koja se obično koristi za isticanje i naglašavanje elemenata.';
$string['theme_color-color_secondary'] = 'Sekundarna boja';
$string['theme_color-color_secondary_desc'] = 'Sekundarna boja koja dopunjuje primarnu boju, i koja se koristi za isticanje sekundarnih elemenata ili za kontrast sa primarnom bojom.';
$string['theme_color_desc'] = 'Izaberite boje Moodle tekstova i dugmadi ili kliknite na liniju ispod:';
$string['theme_color_heading'] = 'Izbor boje orkuženja';
$string['theme_color_sugestion'] = 'Predlog za boje';
$string['theme_color_sugestion_text'] = 'Kliknite na željeni red tj. boju (plava, ljubičasta, crvena...) u nastavku, kako bi odgovarajući skup boja bio primenjen za dole navedene opcije (primarna boja, sekundarna boja, boja dugmadi...)';
$string['theme_degrade_about_editbooton'] = 'Uredite blok \'O nama\'';
$string['theme_degrade_frontpage_bloco'] = 'Blok "{$a}"';
$string['theme_degrade_frontpage_home'] = 'Blokovi na početnoj stranici';
$string['theme_degrade_mycourses_editbooton'] = 'Uredite blokove';
$string['theme_degrade_slideshow_editbooton'] = 'Uredi slajd-šou';
$string['theme_login_branco'] = 'Samo obrazac za prijavu na beloj pozadini, bez bočne slike';
$string['top_color_heading'] = 'Boja menija na vrhu stranice prilikom skrolovanja';
$string['top_scroll'] = 'Fiksirajte meni prilikom skrolovanja stranice';
$string['top_scroll_background_color'] = 'Boja pozadine menija na vrhu stranice prilikom premotavanja (skrolovanja)';
$string['top_scroll_background_color_desc'] = 'Podesite boju pozadine menija na vrhu stranice prilikom premotavanja (skrolovanja) stranice.';
$string['top_scroll_desc'] = 'Kada je omogućeno, meni će biti fiksiran za vrh stranice prilikom njenog premotavanja (skrolovanja). Tako će biti omogućen lak pristup opcijama menija.';
$string['top_scroll_text_color'] = 'Boja teksta menija prilikom skrolovanja';
$string['top_scroll_text_color_desc'] = 'Podesite boju teksta menija prilikom premotavanja (skrolovanja) stranice.';
$string['vvveb_footer_contact_title_default'] = 'Kontaktirajte nas';
$string['vvveb_home_access'] = 'Pristupite kursu';
$string['vvveb_home_automatically_catalogo'] = 'Nemojte uređivati. Ovaj blok će biti automatski zamenjen katalogom kurseva.';
$string['vvveb_home_automatically_category'] = 'Nemojte uređivati. Ovaj blok će biti automatski zamenjen kategorijama kurseva.';
$string['vvveb_home_automatically_my_course'] = 'Ne uređujte. Ovaj blok će automatski biti zamenjen kursom na koji je student upisan.';
$string['vvveb_home_automatically_popular'] = 'Nemojte uređivati. Ovaj blok će biti automatski zamenjen najpopularnijim kursevima.';
$string['vvveb_home_catalogo_heading'] = 'Katalog kurseva';
$string['vvveb_home_category_heading'] = 'Kategorije kurseva';
$string['vvveb_home_mycourses_heading'] = 'Moji kursevi';
$string['vvveb_home_popular_course'] = 'Popularni kursevi';
$string['vvveb_home_team_subtitle'] = 'Mi smo grupa profesionalaca posvećenih svom radu';
$string['vvveb_home_team_title'] = 'Upoznajte naš tim';
