<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'format_tiles', language 'fr', version '4.5'.
 *
 * @package     format_tiles
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addsections'] = 'Ajouter une tuile';
$string['admintools'] = 'Outils d’administration';
$string['all'] = 'Toutes';
$string['allcomplete'] = 'Toutes complètes';
$string['allcoursescomplypalette'] = 'Tous les cours ont déjà des couleurs de tuiles autorisées. Rien à réinitialiser. Assurez-vous d’enregistrer toutes les modifications apportées aux couleurs autorisées avant de lancer la réinitialisation.';
$string['allowphototiles'] = 'Autoriser les tuiles photo';
$string['allowphototiles_desc'] = 'Si cette option est sélectionnée, les enseignants pourront télécharger une photo qui servira de fond pour la tuile. Ils pourront toujours utiliser les icônes de tuiles standard, dans le même cours. (Si elle n’est pas sélectionnée, seules les icônes de tuiles seront autorisées et les autres paramètres de tuile photo ci-dessous seront ignorés.)';
$string['allowsubtilesview'] = 'Autoriser l’affichage de sous-tuiles';
$string['allowsubtilesview_desc'] = 'Permet l’utilisation d’un réglage de parcours qui, s’il est sélectionné, montre dans une tuile les activités (à l’exception des étiquettes) comme sous tuiles, au lieu d’une liste standard.';
$string['alternativelink'] = 'Lien alternatif';
$string['areyousure'] = 'Voulez-vous vraiment effectuer cette opération ?';
$string['asfraction'] = 'Afficher comme fraction';
$string['aspectratiotootallorwide'] = 'L’image importée a été enregistrée, mais veuillez vérifier, car elle peut être <strong> {$a->tallorwide} </strong>. Si cela ne semble pas correct, veuillez la recadrer aux dimensions standard du paysage et la déposer à nouveau. Par exemple 300 de large x 200 de haut conviendraient.';
$string['aspercentagedial'] = 'Afficher en %';
$string['assumedatastoreconsent'] = 'Consentir au stockage des données dans la mémoire locale du navigateur';
$string['assumedatastoreconsent_desc'] = 'Si cette option est sélectionnée, l’utilisateur <b>ne verra plus</b> apparaître une boîte de dialogue lui demandant de consentir au stockage des données dans la mémoire locale du navigateur.';
$string['backupfailed'] = 'La sauvegarde a échoué';
$string['basecolour'] = 'Couleur des tuiles';
$string['basecolour_help'] = 'La couleur définie ici sera appliquée à toutes les tuiles du cours. Les couleurs disponibles sont déterminées par l’administrateur de votre site dans les réglages du plugin Tuiles';
$string['brandcolour'] = 'Couleur du bandeau';
$string['cachedef_formatoptionelementids'] = 'Tableau simple d\'identifiants d\'éléments pour lesquels des options de format ont été définies, par exemple des identifiants de sections de cours avec photos.';
$string['cachedef_modalcmids'] = 'ID de module de cours (par cours) qui doit être lancé avec un modal';
$string['changedcolour'] = 'Couleur des tuiles par défaut pour le cours {$a}';
$string['checkforproblemcourses'] = 'Rechercher et résoudre les problèmes de cours';
$string['clearphoto'] = 'Réinitialiser cette tuile';
$string['clickiffailstoload'] = 'Cliquer si la page ne se charge pas';
$string['close'] = 'Fermer';
$string['collapse'] = 'Réduire la section';
$string['collapsesections'] = 'Tout réduire';
$string['colourblue'] = 'Bleu';
$string['colourdarkgreen'] = 'Vert foncé';
$string['colourgreen'] = 'Vert';
$string['colourlightblue'] = 'Bleu clair';
$string['colourname_descr'] = 'Nom d’affichage de la couleur. Le nom n’est en général pas vu par les utilisateurs, à qui est présenté un nuancier';
$string['colournamegeneral'] = 'Afficher le nom de la couleur ci-dessus';
$string['colourpurple'] = 'Violet';
$string['colourred'] = 'Rouge';
$string['colours'] = 'Couleurs';
$string['complete'] = 'Terminé';
$string['complete-n-auto'] = 'Élément non terminé. Il sera considéré comme terminé lorsque vous aurez rempli tous les critères d’achèvement. Vous ne pouvez pas le modifier manuellement.';
$string['complete-y-auto'] = 'Élément achevé. Il a été marquée comme étant achevé lorsque vous avez rempli les critères d’achèvement. Vous ne pouvez pas le modifier manuellement.';
$string['completion_help'] = 'Une coche à droite d’une activité peut être utilisée pour indiquer quand l’activité est terminée (un cercle vide sera affiché si non). <br><br>
Selon le réglage, une coche peut apparaître automatiquement lorsque vous avez terminé l’activité selon les conditions définies par l’enseignant.<br><br>
Dans d’autres cas, vous pouvez cliquer sur le cercle vide lorsque vous pensez avoir terminé l’activité. Celle-ci se transforme en une coche verte pleine. (Si vous cliquez de nouveau dessus, la coche se vide.)';
$string['completionswitchhelp'] = '<p>Vous avez choisi d’afficher le suivi de l’achèvement sur chaque tuile. Nous avons donc défini « Suivi de l’achèvement > Activer » plus bas dans cette page sur « Oui ».</p>
<p>En outre, vous devez activer le suivi d’achèvement pour <b>chaque élément </b> que vous suivez. Par exemple, pour un PDF, cliquez sur « Modifier les paramètres », regardez sous Activité terminée, et choisissez le paramètre dont vous avez besoin.</p>
<p>Vous pouvez aussi le faire <b>par lots</b> comme expliqué dans la <a href="https://docs.moodle.org/3x/fr/Achèvement_des_activités" target="_blank">documentation sur le suivi du progrès sur moodle.org</a></p>';
$string['completionwarning'] = 'Vous avez activé le suivi de l’achèvement au niveau du cours, mais au niveau de l’activité individuelle, aucun élément n’a activé le suivi, il n’y a donc rien à suivre.';
$string['completionwarning_changeinbulk'] = 'Modifier par lots';
$string['completionwarning_help'] = 'Vous devez rendre les éléments individuels traçables en les modifiant (sous Achèvement de l’activité > Suivi de l’achèvement) ou vous pouvez le faire en masse sous Administration des cours > Achèvement du cours';
$string['contact'] = 'Entrer en contact';
$string['contactdeveloper'] = 'Contacter le développeur';
$string['contents'] = 'Contenus';
$string['controls'] = 'Contrôles';
$string['coursephotomigrationincomplete'] = 'Les icônes et les photos des tuiles n’ont pas encore été migrées suite à une mise à niveau du système. Les éléments manquants devraient apparaître quelques heures après la mise à niveau.';
$string['courseshowtileprogress'] = 'Progression dans chaque tuile';
$string['courseshowtileprogress_error'] = 'Vous avez le \'Suivi de l’achèvement > Activer le suivi de l’achèvement\' réglé sur \'Non\' (voir plus bas sur cette page) qui entre en conflit avec ce paramètre. Si vous souhaitez afficher la progression sur les tuiles, définissez le \'Suivi de l’achèvement > Activer le suivi de l’achèvement\' sur \'Oui\'. Sinon, réglez ce paramètre sur \'Non\'.';
$string['courseshowtileprogress_help'] = '<p>Lorsque cette option est sélectionnée, la progression des activités de l’utilisateur sera affichée dans chaque tuile, soit sous la forme d’une <em>fraction</em> (par ex. \'Progrès 2/10\' signifiant que 2 activités sur 10 sont achevées), soit sous la forme d’un <em>pourcentage</em> dans un cercle.</p><p>Il ne peut être utilisé que si l’option \'Achèvement > Activer le suivi de l’achèvement\' a été activée.</p><p>S’il n’y a pas d’activités traçables dans une tuile donnée, l’indicateur ne sera pas affiché pour cette tuile.</p>';
$string['courseshowtileprogress_link'] = 'Activity_completion_settings#Activity_settings';
$string['coursetoomanysections'] = 'Attention aux éditeurs : ce cours a plus de tuiles que le maximum autorisé. Un maximum de {$a->max} sera montré aux étudiants (jusqu’à « {$a->tilename} ») (les éditeurs peuvent en voir plus).';
$string['courseusebarforheadings'] = 'Souligner les titres avec des onglets de couleur';
$string['courseusebarforheadings_help'] = 'Afficher un onglet coloré à gauche de l’en-tête dans le cours chaque fois qu’un style d’en-tête est sélectionné dans l’éditeur de texte.';
$string['courseusesubtiles'] = 'Utiliser des sous-tuiles pour les activités';
$string['courseusesubtiles_help'] = 'Dans chaque tuile, montrez chaque activité comme une sous-tuile, au lieu d’une liste d’activités en bas de la page. Ceci ne s’applique pas aux étiquettes qui ne seront pas affichées en tant que sous-tuiles et peuvent donc être utilisées comme titres entre les tuiles.';
$string['currentsection'] = 'Cette tuile';
$string['customcss'] = 'CSS personnalisé';
$string['customcssdesc'] = 'CSS personnalisé pour l’appliquer à la section du contenu du cours lorsque le format du cours est utilisé. Ceci ne sera pas validé, alors prenez soin d’entrer un code valide. Par exemple : <p>li.activity.subtile.resource.pdf { background-color: orange !important; }</p>';
$string['datapref'] = 'Préférence pour les données';
$string['datapreferror'] = 'La fonction de préférence de données n’est disponible que si JavaScript est disponible dans votre navigateur. Sinon, le stockage des données ne peut pas être activé.';
$string['dataprefquestion'] = '<p>Pour faciliter l’utilisation de ce site, nous stockons des informations fonctionnelles dans votre navigateur, telles que le numéro d’identification de la dernière tuile que vous avez ouverte. Cela reste sur votre machine pendant un court instant au cas où vous visiteriez à nouveau cette page. Nous ne l’utilisons pas pour le suivi. Êtes-vous d’accord ?</p><p>Nous nous souviendrons de votre choix jusqu’à ce que vous effaciez votre historique de navigation. Pour vous désabonner, cliquez sur « Annuler ».</p>';
$string['defaultthiscourse'] = 'Par défaut pour ce cours';
$string['defaulttilecolour'] = 'Couleur de tuile par défaut';
$string['defaulttileicon'] = 'Icône de tuile';
$string['defaulttileicon_help'] = 'L’icône sélectionnée ici apparaîtra par défaut sur <em>toutes</em> les tuiles dans ce cours. On peut définir des icônes différentes pour les tuiles en utilisant les différents réglages au niveau de chaque tuile.';
$string['deleteemptytiles'] = 'Supprimer les tuiles vides';
$string['deleteimage'] = 'Supprimer l’image';
$string['deletesection'] = 'Supprimer la tuile';
$string['deletetile'] = 'Supprimer la tuile';
$string['developedby'] = 'Format Tuiles développé par {$a}';
$string['developer'] = 'Développeur';
$string['disabledbyadmin'] = 'Désactivé par l’administrateur sur site';
$string['displayfilterbar'] = 'Barre de filtrage';
$string['displayfilterbar_error'] = 'Si vous n’avez pas défini de résultats pour ce cours, vous ne pouvez afficher qu’une barre de filtre basée sur le nombre de tuiles, et non sur les résultats. Créez d’abord quelques résultats, puis revenez ici. Voir';
$string['displayfilterbar_help'] = '<p>Lorsque sélectionné, s’affichera automatiquement un tableau de boutons avant l’écran de tuiles dans un cours, que les utilisateurs peuvent cliquer pour filtrer les tuiles jusqu’à une certaine plage.</p><p>Lorsque l’option « basé sur les numéros de tuiles » est sélectionnée, une série de boutons sera affichée, par exemple un bouton pour tuiles 1-4, un bouton pour tuiles 5-8, etc.</p><p>Lorsque l’option « basé sur les résultats du cours » est sélectionnée, il y a un bouton par résultat du cours. Chaque tuile peut être assignée à un résultat donné (et donc à un bouton donné) à partir de la page des paramètres de cette tuile.';
$string['displayfilterbar_link'] = 'Outcomes';
$string['displaytitle_mod_doc'] = 'Document Word';
$string['displaytitle_mod_html'] = 'Page Web';
$string['displaytitle_mod_jpeg'] = 'Image';
$string['displaytitle_mod_mp3'] = 'Audio';
$string['displaytitle_mod_mp4'] = 'Vidéo';
$string['displaytitle_mod_pdf'] = 'PDF';
$string['displaytitle_mod_ppt'] = 'Présentation PowerPoint';
$string['displaytitle_mod_txt'] = 'Texte';
$string['displaytitle_mod_xls'] = 'Feuille de calcul';
$string['displaytitle_mod_zip'] = 'Zip';
$string['documentation'] = 'Documentation';
$string['documentationurl'] = 'URL de la documentation';
$string['documentationurl_descr'] = 'URL de la documentation du format Tuiles.';
$string['download'] = 'Télécharger';
$string['editoradvicesubtiles'] = 'Dans cette version du plugin Tuiles, les activités n’apparaîtront en tant que sous-tuiles que si le mode d’édition est désactivé';
$string['editsection'] = 'Modifier la tuile';
$string['editsectionname'] = 'Modifier le nom de la section';
$string['embeddedurlerror'] = 'Si le site Web externe refuse de se connecter dans la fenêtre ci-dessus, utilisez ceci :';
$string['enablelinebreakfilter'] = 'Activer le filtre de saut de ligne';
$string['enablelinebreakfilter_desc'] = 'Filtrer les titres des tuiles par le caractère de jointure de mot invisible {$a} et, s’il est présent et que le titre est long, le remplacer par « - » pour permettre la césure d’une ligne. Sinon, remplacez-le par rien (c’est-à-dire sans saut de ligne).';
$string['entersection'] = 'Entrer dans la section';
$string['existingimage'] = 'Image existante pour cette tuile';
$string['expand'] = 'Déplier';
$string['expandall'] = 'Tout déplier';
$string['expandsections'] = 'Révéler toutes les activités (toutes les sections)';
$string['expandtopsection'] = 'Agrandir la section supérieure';
$string['experimental'] = 'expérimental';
$string['experimentalfeatures'] = 'Caractéristiques expérimentales';
$string['fileaddedtobottom'] = 'Fichier ajouté en bas de la section';
$string['filterboth'] = 'Afficher les boutons en fonction du nombre de tuiles et des résultats du cours';
$string['filternumbers'] = 'Afficher les boutons en fonction des numéros de tuile';
$string['filteroutcomes'] = 'Afficher les boutons en fonction des résultats du cours';
$string['filteroutcomesrestore'] = 'Le cours d’origine utilisait les résultats dans la barre de filtre, qui ne sont pas encore pris en charge pendant le processus de restauration. Le réglage de la barre de filtre a donc été modifié dans le parcours restauré. Si vous souhaitez utiliser les résultats pour filtrer les tuiles dans le cours restauré, veuillez configurer à nouveau les résultats. Le parcours initial n’a pas été modifié.';
$string['filters'] = 'Filtres';
$string['fittilestowidth'] = 'Ajuster les tuiles à la largeur de l’écran';
$string['fittilestowidth_desc'] = 'Si cette case est cochée, lorsqu’un utilisateur accède à un cours sur un appareil non mobile, les tuiles retardent le chargement d’une demi-seconde pendant qu’un calcul est effectué pour déterminer la meilleure mise en page. Par exemple. évitez une tuile par rangée, centrez les tuiles sur l’écran. Cela ne se produira que la première fois qu’elles apparaîtront dans le cours dans une session donnée et sera ensuite mémorisé pour la session ou jusqu’à ce que l’utilisateur ajuste la taille de son écran.';
$string['fixproblems'] = 'Résoudre les problèmes';
$string['folderdisplayerror'] = 'Les dossiers configurés pour afficher le contenu en ligne ne sont pas compatibles avec le format des sous-dossiers. Ce <a href="{$a}">dossier</a> a donc été changé pour s’afficher sur une page séparée';
$string['followthemecolour'] = 'Forcer la couleur du thème suivante';
$string['followthemecolour_desc'] = 'Si le paramètre a la valeur oui, les enseignants n’auront pas le choix avec ce plugin et toutes les couleurs des tuiles ci-dessous seront ignorées. Au lieu de cela, on tentera d’obtenir la couleur principale de la marque du thème et d’utiliser cette couleur à la place.';
$string['guidance'] = 'Guide';
$string['height'] = 'hauteur';
$string['hidden'] = 'Caché';
$string['hide'] = 'Cacher';
$string['hidefromothers'] = 'Cacher la tuile';
$string['highcontrastmode'] = 'Mode contraste élevé';
$string['highcontrastmodeallow'] = 'Autoriser le mode haut contraste';
$string['highcontrastmodeallow_desc'] = 'Permettre aux utilisateurs de définir une préférence pour l\'affichage des cours en tuiles avec un contraste élevé (les couleurs de tuiles sélectionnées par l\'enseignant seront remplacées par une couleur foncée).';
$string['highestsectionnum'] = 'Numéro de section le plus élevé trouvé';
$string['home'] = 'Accueil du cours';
$string['icontitle-address-book-o'] = 'Carnet d’adresses';
$string['icontitle-assessment_graded'] = 'Devoir A+';
$string['icontitle-assessment_timer'] = 'Devoir chronométré';
$string['icontitle-asterisk'] = 'Astérisque';
$string['icontitle-award-solid'] = 'Badge';
$string['icontitle-balance-scale'] = 'Balance';
$string['icontitle-bar-chart'] = 'Histogramme';
$string['icontitle-bell-o'] = 'Cloche';
$string['icontitle-binoculars'] = 'Jumelle';
$string['icontitle-bitcoin'] = 'Bitcoin';
$string['icontitle-book'] = 'Livre';
$string['icontitle-bookmark-o'] = 'Favori';
$string['icontitle-briefcase'] = 'Sacoche';
$string['icontitle-building'] = 'Immeuble';
$string['icontitle-bullhorn'] = 'Porte-voix';
$string['icontitle-bullseye'] = 'Cible';
$string['icontitle-calculator'] = 'Calculette';
$string['icontitle-calendar'] = 'Calendrier';
$string['icontitle-calendar-check-o'] = 'Calendrier avec coche';
$string['icontitle-check'] = 'Coche';
$string['icontitle-child'] = 'Enfant';
$string['icontitle-clock-o'] = 'Horloge';
$string['icontitle-clone'] = 'Copie';
$string['icontitle-cloud-download'] = 'Nuage (téléchargement)';
$string['icontitle-cloud-upload'] = 'Nuage (dépôt)';
$string['icontitle-comment-o'] = 'Bulle';
$string['icontitle-comments-o'] = 'Bulles';
$string['icontitle-compass'] = 'Boussole';
$string['icontitle-diamond'] = 'Diamant';
$string['icontitle-dollar'] = 'Dollar';
$string['icontitle-euro'] = 'Euro';
$string['icontitle-exclamation-triangle'] = 'Exclamation dans un triangle';
$string['icontitle-feed'] = 'Flux RSS';
$string['icontitle-file-text-o'] = 'Fichier texte';
$string['icontitle-film'] = 'Film';
$string['icontitle-flag-checkered'] = 'Drapeau (à damier)';
$string['icontitle-flag-o'] = 'Drapeau';
$string['icontitle-flash'] = 'Éclair';
$string['icontitle-flask'] = 'Flacon';
$string['icontitle-flipchart'] = 'Tableau de conférence';
$string['icontitle-frown-o'] = 'Froncement de sourcils';
$string['icontitle-gavel'] = 'Marteau';
$string['icontitle-gbp'] = 'Livre anglaise';
$string['icontitle-globe'] = 'Globe';
$string['icontitle-handshake-o'] = 'Mains';
$string['icontitle-headphones'] = 'Casque audio';
$string['icontitle-heartbeat'] = 'Battements de cœur';
$string['icontitle-history'] = 'Horloge (retour)';
$string['icontitle-home'] = 'Maison';
$string['icontitle-id-card-o'] = 'Carte d’identité';
$string['icontitle-info'] = 'Information';
$string['icontitle-jigsaw'] = 'Puzzle';
$string['icontitle-key'] = 'Clé';
$string['icontitle-laptop'] = 'Ordinateur';
$string['icontitle-life-buoy'] = 'Bouée de sauvetage';
$string['icontitle-lightbulb-o'] = 'Ampoule';
$string['icontitle-line-chart'] = 'Diagramme en ligne';
$string['icontitle-list'] = 'Liste (à puces)';
$string['icontitle-list-ol'] = 'Liste (numérotée)';
$string['icontitle-location-arrow'] = 'Flèche de direction';
$string['icontitle-map-marker'] = 'Repère cartographique';
$string['icontitle-map-o'] = 'Carte';
$string['icontitle-map-signs'] = 'Panneaux cartographiques';
$string['icontitle-microphone'] = 'Microphone';
$string['icontitle-mobile-phone'] = 'Téléphone portable';
$string['icontitle-mortar-board'] = 'Toque';
$string['icontitle-music'] = 'Musique';
$string['icontitle-newspaper-o'] = 'Journal';
$string['icontitle-number'] = 'Nombre {$a}';
$string['icontitle-pencil-square-o'] = 'Crayon dans un carré';
$string['icontitle-person'] = 'Personne';
$string['icontitle-pie-chart'] = 'Camembert';
$string['icontitle-podcast'] = 'Podcast';
$string['icontitle-puzzle-piece'] = 'Pièce de puzzle';
$string['icontitle-question-circle'] = 'Point d’interrogation';
$string['icontitle-random'] = 'Aléatoire';
$string['icontitle-refresh'] = 'Circulaire';
$string['icontitle-road'] = 'Autoroute';
$string['icontitle-search'] = 'Loupe';
$string['icontitle-sliders'] = 'Curseurs';
$string['icontitle-smile-o'] = 'Sourire';
$string['icontitle-star'] = 'Étoile (pleine)';
$string['icontitle-star-half-o'] = 'Étoile (à moitié pleine)';
$string['icontitle-star-o'] = 'Étoile (vide)';
$string['icontitle-survey'] = 'Sondage';
$string['icontitle-tags'] = 'Étiquettes';
$string['icontitle-tasks'] = 'Tâches';
$string['icontitle-television'] = 'Écran';
$string['icontitle-thinking-person'] = 'Personne avec ampoule';
$string['icontitle-thumbs-o-down'] = 'Pouce baissé';
$string['icontitle-thumbs-o-up'] = 'Pouce levé';
$string['icontitle-trophy'] = 'Trophée';
$string['icontitle-umbrella'] = 'Parapluie';
$string['icontitle-university'] = 'Université';
$string['icontitle-user-o'] = 'Personne (sans ombre)';
$string['icontitle-users'] = 'Gens';
$string['icontitle-volume-up'] = 'Haut parleur';
$string['icontitle-wrench'] = 'Clé à molette';
$string['imagecannotbeused'] = 'L’image ne peut pas être utilisée';
$string['imagedeletedfrom'] = 'Image supprimée de « {$a} »';
$string['imagesavedfor'] = 'Image enregistrée pour {$a}';
$string['imagesize'] = 'Taille de l’image';
$string['invalidsectionid'] = 'Identifiant de section invalide « {$a} »';
$string['jsactivate'] = 'Navigation animée';
$string['jsdeactivated'] = 'Vous avez désactivé la navigation animée. Vous pouvez la réactiver à l’aide du menu de navigation.';
$string['jsreactivated'] = 'Vous avez activé la navigation animée sur votre compte.';
$string['legacytiledata'] = 'Nombre de données de tuiles héritées';
$string['links'] = 'Liens';
$string['loading'] = 'Chargement';
$string['maxcoursesectionsallowed'] = 'Le nombre maximum de sections de cours autorisées dans cet environnement est de {$ a}.';
$string['migratecoursedata'] = 'Migrer les données de cours';
$string['migratedcourseid'] = 'ID de cours migré {$a}';
$string['migratenow'] = 'Migrer maintenant';
$string['modalmodules'] = 'Modules modaux';
$string['modalmodules_desc'] = 'Lancer ces modules de cours dans une fenêtre modale. D’autres modules pourraient être ajoutés dans une version ultérieure.';
$string['modalresources'] = 'Ressources modales';
$string['modalresources_desc'] = 'Lancer ces ressources dans une fenêtre modale. Remarque : si l’autorisation est donnée ici, les activités URL s’ouvriront dans une fenêtre modale si elles sont réglées sur {$a->displayembed} au niveau de l’activité (par exemple des vidéos YouTube ou Vimeo). Même dans ce cas, leur affichage intégré peut être bloqué par leur propriétaire. Voir {$a->link}';
$string['modalwindows'] = 'Fenêtres modales';
$string['newsectionname'] = 'Nouveau nom pour la section {$a}';
$string['newtiledata'] = 'Nombre de nouvelles données de tuile';
$string['nexttopic'] = 'Section suivante';
$string['noconnectionerror'] = 'Impossible de charger le contenu. Vérifiez votre connexion Internet';
$string['nojswarning'] = 'Il semble que votre navigateur ne pas supporte pas JavaScript, ou celui-ci est désactivé. Une interface améliorée est disponible si vous activez JavaScript';
$string['none'] = 'Aucun';
$string['noproblemsfound'] = 'Aucun problème trouvé';
$string['notcomplete'] = 'Non achevé';
$string['notrecommended'] = 'Non recommandé';
$string['novaliddefaultcolour'] = 'Aucune couleur valide définie pour la couleur de tuile par défaut ci-dessous';
$string['numberofsections'] = 'Nombre de sections dans le cours';
$string['numbers'] = 'Nombres';
$string['numbers_desc'] = 'Choisir une icône de numéro pour cette tuile';
$string['off'] = 'Arrêt';
$string['ok'] = 'D’accord';
$string['on'] = 'Marche';
$string['onlywhenediting'] = 'Uniquement lors de l’édition';
$string['other'] = 'Autre';
$string['outcomes'] = 'résultats';
$string['outcomesunavailable'] = 'Résultats non disponibles';
$string['overall'] = 'Global';
$string['overallprogress'] = 'Achèvement d’activité - progression générale';
$string['overallprogressshort'] = 'Progression générale';
$string['photoguidance_desc'] = '<p>Importez une photo au format <strong>paysage</strong>. La largeur doit être d’environ 1,35 fois la hauteur. Par exemple. largeur 270 x  hauteur 200 conviendraient bien. Ce rapport n’a pas besoin d’être exact. </p>
<p> Les photos au format portrait ne correspondront pas à la forme de la tuile. Les images ou fichiers volumineux seront réduits et compressés si nécessaire, après le téléchargement.</p>';
$string['photolibrary'] = 'Galerie photo';
$string['photolibrary_desc'] = 'Ce sont les photos que vous avez téléchargées ou utilisées récemment. Pour en utiliser une comme arrière-plan de cette tuile, cliquez dessus. Pour en télécharger une nouvelle, utilisez l’onglet de téléchargement ci-dessus.';
$string['phototilesaltstyle'] = 'Style alternatif de tuiles photo';
$string['phototilesaltstyle_desc'] = 'Si elles ne sont pas sélectionnées (ce qui est la valeur par défaut), les tuiles photo afficheront le titre en haut de la tuile. Le style alternatif montre le titre en bas';
$string['phototilesettings'] = 'Tuiles photo';
$string['phototiletitletransarency'] = 'Transparence du titre de la tuile photo';
$string['phototiletitletransarency_desc'] = 'La superposition de titre sur une tuile photo peut avoir un arrière-plan légèrement transparent ou un arrière-plan de couleur unie (0%)';
$string['phototitletitlelineheight'] = 'Hauteur de ligne de la tuile';
$string['phototitletitlepadding'] = 'Remplissage de la ligne verticale du titre';
$string['picknewicon'] = 'Choisir une nouvelle icône';
$string['picknewiconphoto'] = 'Choisir une nouvelle icône ou une photo d’arrière-plan';
$string['plugin_description'] = 'Un format visuellement riche, où les sections et activités sont représentées par des tuiles, avec des photos, des icônes et des couleurs personnalisables.';
$string['pluginname'] = 'Tuiles';
$string['previoustopic'] = 'Section précédente';
$string['privacy:metadata:preference:format_tiles_high_contrast_mode'] = 'Si l\'utilisateur utilise le mode contraste élevé.';
$string['privacy:metadata:preference:format_tiles_stopjsnav'] = 'Est-ce que l’utilisateur a désactivé la navigation JavaScript animée.';
$string['privacypolicy'] = 'Politique de confidentialité';
$string['problemcourses'] = 'Cours où il y a des problèmes';
$string['problemcoursesintro'] = 'Les cours suivants ont des numéros de section plus élevés que prévu. Veuillez utiliser les boutons ci-dessous pour résoudre les problèmes.';
$string['progress'] = 'Progression';
$string['progressincludesubsections'] = 'Indicateur de progrès - inclure les données de sous-section ?';
$string['progressincludesubsections_desc'] = 'L\'indicateur de progrès d\'une tuile doit-il inclure des données sur l\'avancement des activités au sein de ses sous-sections ?';
$string['progresstitle'] = '{$a->numComplete} / {$a->numOutOff} éléments terminés ({$a->percent}%)';
$string['reactivate'] = 'Réactiver';
$string['reopenlastsection'] = 'Ré-ouvrir la dernière tuile visitée';
$string['reopenlastsection_desc'] = 'Si coché, si un utilisateur revient sur un cours, la dernière section qu’il avait ouverte sera ré-ouverte à l’arrivée.';
$string['resetallcoursecolours'] = 'Réinitialiser toutes les couleurs de cours';
$string['resetalltiles'] = 'Réinitialiser les photos et les icônes des tuiles';
$string['resetalltilessure'] = 'Voulez-vous vraiment réinitialiser les tuiles de ce cours ? Cela supprimera toutes les photos en mosaïque et réinitialisera toutes les icônes par défaut ? Le contenu ne sera pas supprimé. Il s’agit d’une action destructrice qui ne peut être annulée. Sauvegardez d’abord votre cours en cas de doute.';
$string['resetcolours'] = 'Réinitialiser les couleurs';
$string['resetcolours_desc'] = 'Appuyez sur ce bouton pour réinitialiser la couleur de la tuile pour tous les cours qui n’ont pas l’une des couleurs ci-dessous. Les cours seront remplacés par la couleur de tuile par défaut ci-dessous. Vous pouvez l’utiliser après avoir modifié la palette de couleurs ci-dessous, mais assurez-vous d’avoir <strong>enregistré toutes les modifications</strong> des couleurs ci-dessous avant d’appuyer sur ce bouton. Attention, cela pourrait changer la couleur de nombreux cours !';
$string['resetincomplete'] = 'Réinitialisation incomplète';
$string['restorefailed'] = 'La restauration a échoué';
$string['restoreincorrectsections'] = 'Erreur : impossible de valider car le cours source contient des sections mal numérotées (par exemple, le numéro de section ({$a->sectionnum}) est supérieur au maximum autorisé ({$a->maxallowed}). Essayez d’exclure ou de supprimer les sections avec des nombres élevés.';
$string['restoretoomanysections'] = 'Erreur : impossible de sauvegarder ou de restaurer car trop de sections de cours sont incluses ({$a->numsections}) et c’est plus que le maximum autorisé ({$a->maxallowed}). Essayez d’exclure ou de supprimer certaines sections.';
$string['revealcontents'] = 'Révéler le contenu des tuiles';
$string['section0name'] = 'Général';
$string['sectionerrorstring'] = 'Votre session a peut-être expiré. Essayez d’actualiser cette page.';
$string['sectionerrortitle'] = 'Erreur au chargement du contenu';
$string['sectionname'] = 'Tuile';
$string['sectionnumber'] = 'Section / Numéro de tuile';
$string['seczerocollapsible'] = 'Section zéro réduite';
$string['seczerocollapsible_desc'] = 'Permettre à l\'utilisateur de réduire la section zéro dans le cours';
$string['selected'] = 'Sélectionné';
$string['setavailabletilecolours'] = 'Couleurs de tuiles autorisées (pour l’ensemble du site)';
$string['setbackgroundphoto'] = 'Définir une photo / une icône';
$string['settings'] = 'Paramètres du format Tuiles';
$string['show'] = 'Afficher';
$string['showalltiles'] = 'Afficher toutes les tuiles';
$string['showfromothers'] = 'Afficher la tuile';
$string['showoverallprogress'] = 'Afficher l’indicateur de progression globale';
$string['showoverallprogress_desc'] = 'Afficher l’indicateur « % de progression globale » en haut à droite du cours (la valeur affichée représente le total du % achevé de chaque tuile, en fonction de l’achèvement de l’activité et non de l’achèvement du cours';
$string['showprogresssphototiles_desc'] = 'Si cette option est sélectionnée, la progression de l’étudiant (par exemple, Progression 2/5) sera affichée sur les tuiles photo';
$string['showseczerocoursewide'] = 'Afficher la section 0 en haut de toutes les tuiles';
$string['showseczerocoursewide_desc'] = 'Si coché, la section zéro (la section du haut) sera affichée sur la page d’accueil du cours et en haut de <b>chaque page de section du parcours </b> (c’est-à-dire en haut du contenu de chaque tuile). Si la case n’est pas cochée (recommandé), elle ne sera affichée que sur la page d’atterrissage du parcours.';
$string['showseparatewin'] = 'Afficher dans une fenêtre séparée';
$string['sitename'] = 'Nom du site';
$string['snapwarning'] = 'Il peut être possible de modifier votre cours au format Tuiles en utilisant un autre thème, puis de revenir au thème Snap une fois que vous avez terminé l’édition.';
$string['snapwarning_help'] = 'Theme_settings#Allow_user_themes';
$string['style'] = 'Style';
$string['subtileiconcolourbackground'] = 'Icônes de sous-tuiles - utiliser un cercle d’arrière-plan de couleur unie';
$string['subtileiconcolourbackground_desc'] = 'Si cette case est cochée, les icônes de sous-tuiles sont affichées sous forme d’icônes blanches dans un cercle de couleur unie à l’arrière-plan. Sinon, les icônes sont (1) elles-mêmes colorées et (2) dans un cercle coloré, mais non uni.';
$string['subtileszeczerotoggled'] = 'Section du haut alternant entre le format liste et sous tuiles';
$string['suremigratelegacyoptions'] = 'Voulez-vous vraiment migrer {$a} choix de photos ou d’icônes de tuile pour ce cours ?';
$string['sureresetcolours'] = 'Voulez-vous vraiment réinitialiser les couleurs par défaut des tuiles de cours ? Cela affectera {$a} cours';
$string['tilearialabel'] = '{$a}, ouvre le détail dans une fenêtre contextuelle, lien';
$string['tilecolourgeneral'] = 'Palette de couleurs - couleur optionnelle';
$string['tilecolourgeneral_descr'] = 'Ce réglage permet à l’administrateur de déterminer les couleurs disponibles pour les enseignants dans leurs cours. Pour désactiver une couleur, la régler sur noir (#000). Si vous modifiez les couleurs ici, aucune modification ne sera reportée dans les cours existants jusqu’à ce que leur enseignant n’essaie de changer la couleur d’une tuile, auquel cas seules les couleurs définies ici lui seront proposées.';
$string['tilecolourschanged'] = 'Les couleurs des tuiles ont été réinitialisées. Toutes les tuiles ont maintenant des couleurs conformes aux couleurs ci-dessous.';
$string['tileicon'] = 'Icône / photo à afficher sur cette tuile uniquement';
$string['tileicon_help'] = 'L’élément sélectionné ici remplacera, pour cette tuile uniquement, l’icône de tuile qui a été définie au niveau du cours.';
$string['tileicons'] = 'Icônes de tuile';
$string['tileoutcome'] = 'Résultat pour cette tuile';
$string['tileoutcome_help'] = 'Si vous sélectionnez un résultat pour cette tuile, vous pourrez alors, dans les paramètres du cours, afficher un ensemble de <em>boutons de filtrage</em>, un pour chaque résultat, qui, appuyé, affichera les tuiles en fonction du résultat qui leur a été attribué.';
$string['tileselecttip'] = 'Dans le cours, en mode édition, cliquez simplement sur l’icône ou la photo que vous souhaitez modifier. La fenêtre du sélecteur d’icônes s’affiche.';
$string['tilesformatregistration'] = 'Enregistrement du format Tuiles';
$string['tilesreset'] = 'Les tuiles et les icônes ont été réinitialisées pour ce cours';
$string['tilestyle'] = 'Style de tuile';
$string['tilestyle_desc'] = 'Style 1 = les tuiles photo afficheront le titre en haut de la tuile, style 2 = titre en bas';
$string['togglecompletion'] = 'Cliquez pour basculer le statut d’achèvement';
$string['togglecompletioncomplete'] = 'Cliquer pour modifier le statut d’achèvement (terminé)';
$string['togglecompletionincomplete'] = 'Cliquer pour modifier le statut d’achèvement (non terminé)';
$string['tootall'] = 'Trop grand pour la tuile';
$string['toowide'] = 'Trop large pour la tuile';
$string['transparenttitleadjustments'] = 'Ajustements de transparence de titre';
$string['transparenttitleadjustments_desc'] = 'Sur les tuiles photo avec des arrière-plans de titre transparents, en fonction de votre thème, vous souhaiterez peut-être les ajuster pour vous assurer que les lignes transparentes du titre ne se chevauchent pas lorsqu’elles sont enveloppées.
Notez que celles-ci varient également un peu selon les navigateurs. Valeurs suggérées pour Chrome : Thèmes basés sur Boost et Clean : 30,5 et 4 | Adaptable : 32 et 4 | Moove : 32 et 2 | Remui : 32 et 2,5';
$string['unmigratedcoursesintro'] = 'Il semble que toutes les icônes et photos des cours suivants {$a} n’aient pas été migrées suite à une mise à jour du système. Cliquez sur le bouton pour traiter un cours maintenant. Si vous attendez, le processus "cron" en arrière-plan devrait traiter tout cela, mais si vous souhaitez traiter un cours donné maintenant, cliquez sur le bouton';
$string['uploadnewphoto'] = 'Déposer une nouvelle photo';
$string['uploadnewphoto_help'] = 'Importez une image à utiliser sur cette tuile';
$string['usecourseindex'] = 'Utiliser l’index des cours';
$string['usecourseindex_desc'] = 'Dans une tuile de cours, quand l’index du parcours doit-il s’afficher à gauche ?';
$string['usejavascriptnav'] = 'Utiliser la navigation JavaScript à partir de la page d’accueil du format Tuiles';
$string['usejavascriptnav_desc'] = 'Une fois cochée, si l’utilisateur clique sur une tuile sur la page d’accueil du cours, avec javascript activé, JS sera utilisé pour passer au contenu de la tuile. Le contenu des tuiles sera stocké localement dans le navigateur selon les autres paramètres ci-dessous. Si cette case n’est pas cochée, JS ne sera pas utilisé et la navigation existante sera utilisée à la place. Les autres paramètres JS ci-dessous seront ignorés.';
$string['usejseditingexpandcollapse'] = 'Mode d’édition - utilisez JavaScript pour développer / réduire les tuiles';
$string['usejseditingexpandcollapse_desc'] = 'Si cette option est sélectionnée, en mode édition, un enseignant peut développer et réduire les tuiles d’édition avec des transitions animées. Le contenu de la tuile sera chargé lors de l’expansion, sans rechargement de page.';
$string['usejsnavforsinglesection'] = 'Utiliser la navigation JS pour une section par page';
$string['usejsnavforsinglesection_desc'] = 'Si cette case est cochée, tout appel pour une seule section par page (&section=xx) sera traité en utilisant JavaScript, en lançant la page principale du cours, animée pour s’ouvrir à la section demandée via JS, plutôt que d’appeler l’ancienne page de section unique PHP.';
$string['usesubtilesseczero'] = 'Utiliser les sous-tuiles dans la section du haut';
$string['usesubtilesseczero_help'] = 'Si cette option est sélectionnée, les sous-tuiles seront utilisées dans la section supérieure, ainsi que dans toutes les tuiles. Uniquement disponible si vous utilisez des sous-tuiles dans l’ensemble du cours. Comme les sous-tuiles occupent beaucoup de place tout en haut du parcours, il peut être préférable de ne pas sélectionner cette option, afin que tous les éléments de la section supérieure soient affichés au format de liste standard à la place.';
$string['version'] = 'Version {$a}';
$string['width'] = 'largeur';
