<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'format_tiles', language 'es_mx', version '4.5'.
 *
 * @package     format_tiles
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addsections'] = 'Añadir mosaico';
$string['admintools'] = 'Herramientas del administrador';
$string['all'] = 'Todo(s)';
$string['allcomplete'] = 'Todo completo';
$string['allcoursescomplypalette'] = 'Todos los cursos ya tienen colores de mosaico permitidos. Nada para reiniciar. Asegúrese de guardar cualquier cambio a colores permitidos antes de oprimir reiniciar.';
$string['allowphototiles'] = 'Permitir mosaicos de fotos';
$string['allowphototiles_desc'] = 'Si se selecciona, los profesores podrán subir una foto para que sirva como fondo de mosaico. Ellos podrán seguir usando íconos de mosaico estándares también, en el mismo curso. (Si no se selecciona, solamente serán permitidos íconos de mosaico y las demás configuraciones de mosaico inferiores serán ignoradas).';
$string['allowsubtilesview'] = 'Permitir vista de sub mosaicos';
$string['allowsubtilesview_desc'] = 'Permitir el uso de una configuración de curso, la cual, si se selecciona, muestra las actividades (excepto etiquetas) como sub mosaicos, en lugar de la lista estándar';
$string['alternativelink'] = 'Enlace alternativo';
$string['areyousure'] = '¿Está seguro?';
$string['asfraction'] = 'Mostrar como fracción';
$string['aspectratiotootallorwide'] = 'La imagen subida ha sido guardada, pero por favor revísela, porque podría ser <strong>{$a->tallorwide}</strong>. Si no se observa bien, por favor recórtela a las dimensiones estándar apaisadas y súbala de nuevo. Por ejemplo, 300 de ancho y 200 de alto debería encajar bien.';
$string['aspercentagedial'] = 'Mostrar como %';
$string['assumedatastoreconsent'] = 'Asumir consentimiento a almacenamiento local del navegador';
$string['assumedatastoreconsent_desc'] = 'Si se selecciona,  al usuario <b>no</b> le será mostrado un diálogo que le solicite cosentimiento para almacenar datos en almacenamiento local del navegador';
$string['backupfailed'] = 'Restauración falló';
$string['basecolour'] = 'Color para mosaicos';
$string['basecolour_help'] = 'El color aquí configurado será aplicado a todos los mosaicos en el curso. Los colores disponibles están determinados por su administrador del sitio mediante la página de configuraciones del plugin Mosaicos).';
$string['brandcolour'] = 'Color de la marca';
$string['cachedef_modalcmids'] = 'IDs (por curso) de módulo de curso que necesitan ser invocados con un modal';
$string['changedcolour'] = 'Color del mosaico se reinicia al predeterminado para curso {$a}';
$string['checkforproblemcourses'] = 'Revisar y reparar cursos con problemas';
$string['clearphoto'] = 'Reiniciar este mosaico';
$string['clickiffailstoload'] = 'Clic si la página no cargó';
$string['close'] = 'Cerrar';
$string['closetopsection'] = 'Cerrar sección superior';
$string['collapse'] = 'Colapsar sección';
$string['collapsesections'] = 'Colapsar todo';
$string['colourblue'] = 'Azul';
$string['colourdarkgreen'] = 'Verde oscuro';
$string['colourgreen'] = 'Verde';
$string['colourlightblue'] = 'Azul claro';
$string['colourname_descr'] = 'Mostrar el nombre para el color (el nombre usualmente no es visto por usuarios - ellos verán una paleta coloreada)';
$string['colournamegeneral'] = 'Mostrar nombre para color de arriba';
$string['colourpurple'] = 'Morado';
$string['colourred'] = 'Rojo';
$string['colours'] = 'Colores';
$string['complete'] = 'Completo';
$string['complete-n-auto'] = 'Elemento incompleto. Será marcado como completo cuando Usted cumpla con todos los criterios de finalización. Usted no puede cambiar esto manualmente.';
$string['complete-y-auto'] = 'Ítem completo. Será marcado como completo cuando Usted cumpla con los criterios de finalización. Usted no puede cambiar esto manualmente.';
$string['completion_help'] = 'Una palomita  a la derecha de una actividad puede ser usada para indicar cuando una actividad está completada (se mostrará un círculo vacío cuando no lo esté).<br><br>
Dependiendo de la configuración, una palomita puede aparecer automáticamente cuando Usted haya completado la actividad de acuerdo a las condiciones configuradas por el profesor.<br><br>
En otros casos, Usted puede hacer clic en el círculo vacío cuando Usted piense que ha completado esta actividad y se cambiará a una paloma verde sólida. (El hacerle clic nuevamente quita la paloma si Usted cambia de opinión)';
$string['completionswitchhelp'] = '<p>Usted ha seleccionado el mostrar el seguimiento de finalización en cada mosaico. Por lo tanto, hemos configurado "Seguimiento de finalización > Habilitar" más abajo en esta página a "Si".</p>
<p>Adicionalmente, Usted necesita activar el seguimiento de finalización para <b>cada ítem</b> que Usted esté monitoreando; por ejemplo para un PDF, haga clic en "Editar configuraciones", vea debajo de Finalización de actividad, y elija la configuración que necesite.</p>
<p>Usted también puede hacer esto <b>masivamente</b> según se explica en  la <a href="https://docs.moodle.org/all/es/Configuraciones_de_finalizaci%C3%B3n_de_actividad" target="_blank">explicación detallada del seguimiento de finalización en moodle.org</a></p>';
$string['completionwarning'] = 'Usted tiene activado el seguimiento de finalización  a nivel del curso, pero al nivel de la actividad individual ningún ítem tiene el seguimiento habilitado, por lo que no hay nada que monitorear.';
$string['completionwarning_changeinbulk'] = 'Cambiar masivamente';
$string['completionwarning_help'] = 'Usted necesita hacer monitoreable elementos individuales al editarlos (bajo Finalización de actividad > Seguimiento de finalización) o Usted puede hacer esto masivamente bajo Administración del curso  > Finalización del curso > Editar masivamente finalización de actividad';
$string['contact'] = 'Mantenerse en contacto';
$string['contactdeveloper'] = 'Contactar al desarrollador';
$string['contents'] = 'Contenidos';
$string['controls'] = 'Controles';
$string['coursephotomigrationincomplete'] = 'Íconos y fotos del mosaico aun no han sido migrados después de una actualización del sistema . Los elementos faltantes deberían de aparecer dentro de unas pocas horas de la actualización.';
$string['courseshowtileprogress'] = 'Progreso en cada mosaico';
$string['courseshowtileprogress_error'] = 'Usted tiene \'Seguimiento de finalización > Habilitar seguimiento de finalización\' configurado a \'No\' (vea más abajo en esta página) lo que hace conflicto con esta configuración. Si Usted quiere mostrar el progreso en los mosaicos, por favor configure \'Seguimiento de finalización > Habilitar seguimiento de finalización\' a \'Si\'. En caso contrario, por favor ajuste esta configuración a \'No\'.';
$string['courseshowtileprogress_help'] = '<p>Cuando se selecciona, el progreso del usuario con las actividades será mostrado en cada mosaico, ya sea como una <em>fracción</em> (por ejemplo \'Progreso 2/10\' significa 2 de 10 actividades completadas), o como un <em>porcentaje</em> en un círculo.</p><p>Esto solamente puede ser usado si se ha activado la  \'Finalización > Habilitar seguimiento de finalización\' .</p><p>Si no hubiera actividades monitoreables dentro de un mosaico dado, no será mostrado el indicador para ese mosaico.</p>';
$string['courseshowtileprogress_link'] = 'Activity_completion_settings#Activity_settings';
$string['coursetoomanysections'] = 'Advertencia a los editores: este curso tiene más mosaicos que el máximo permitido.  Un máximo de {$a->max} serán mostrados a los estudiantes (reducidos a "{$a->tilename}") los editores pueden ver más).';
$string['courseusebarforheadings'] = 'Enfatizar encabezados con pestaña coloreada';
$string['courseusebarforheadings_help'] = 'Mostrar una pestaña coloreada a la izquierda del encabezado en el curso en todos lados donde esté seleccionado un estilo de encabezado en el editor de texto';
$string['courseusesubtiles'] = 'Usar sub mosaicos para actividades';
$string['courseusesubtiles_help'] = 'Dentro de cada mosaico, mostrar cada actividad como un sub mosaico, en lugar de una lista de actividades en la página. Esto no aplica en etiquetas, las cuales no serán mostradas como sub mosaicos, por lo que pueden ser usadas como encabezados entre los mosaicos.';
$string['currentsection'] = 'Este mosaico';
$string['customcss'] = 'CSS personalizado';
$string['customcssdesc'] = 'CSS personalizado a aplicar a la sección de contenido del curso miestras es usado el formato de curso. Esto no será validado, por lo que Usted debe tener cuidado de ingresar código válido. Por ejemplo: <p>.section { color: red; }</p><p>li.activity.subtile.resource.pdf { background-color: orange !important; }</p>';
$string['datapref'] = 'Preferencias de datos';
$string['datapreferror'] = 'La característica de preferencia de datos solamente está disponible si Usted tiene JavaScript disponible en su navegador. En caso contrario, el almacenamiento de datos no puede ser habilitado.';
$string['dataprefquestion'] = '<p>Para hacer este sitio más fácil de usar, nosotros almacenamos información funcional en su navegador, como por ejemplo el número ID del último mosaico que usted abrió. Esto permanece en su máquina por un corto tiempo en caso de que Usted visite la página nuevamente. Nosotros no lo usamos para espiarlo a Usted. ¿Está de acuerdo?</p><p>Nosotros recordaremos su elección hasta que Usted limpie la historia de su navegador. Para no aceptar, elija "Cancelar".</p>';
$string['defaultthiscourse'] = 'Ajuste por defecto para este curso';
$string['defaulttilecolour'] = 'Color predeterminado de mosaico';
$string['defaulttileicon'] = 'Ícono del mosaico';
$string['defaulttileicon_help'] = 'El ícono aquí seleccionado aparecerá en <em>todos</em> los mosaicos en este curso por defecto. Mosaicos individuales pueden tener un ícono diferente seleccionado, o una fotografía de fondo, usando la configuración diferente a nivel del mosaico.';
$string['deleteemptytiles'] = 'Eliminar mosaicos vacíos';
$string['deleteimage'] = 'Eliminar imagen';
$string['deletesection'] = 'Eliminar mosaico';
$string['deletetile'] = 'Eliminar mosaico';
$string['developedby'] = '"Mosaicos" desarrollado por {$a}';
$string['developer'] = 'Desarrollador';
$string['disabledbyadmin'] = 'Deshabilitado por el Administrador del Sitio';
$string['displayfilterbar'] = 'Barra de filtro';
$string['displayfilterbar_error'] = 'A menos que Usted haya configurado resultados para este curso, Usted solamente puede mostrar una barra de filtro en números de mosaico, y no basados en resultados. Cree algunos resultados  primeramente y después regrese aquí. Vea';
$string['displayfilterbar_help'] = '<p>Cuando se selecciona, mostrará automáticamente una matriz de botones antes de la pantalla del mosaico en un curso, en donde los usuarios pueden hacer clic para filtrar mosaicos a ciertos rangos</p><p>Cuando está seleccionado \'basado en los números\', serán mostrados una serie de botones; por ejemplo, un botón para mosaicos del 1 al 4, un botón para mosaicos del 5 al 8, etc.</p><p>Cuando está seleccionado \'basado en resultados del curso\' habrá un botón por cada resultado del curso. Cada mosaico puede ser asignado a un resultado dado (y por ende a un botón dado) desde la página de configuraciones de ese mosaico.</p>';
$string['displayfilterbar_link'] = 'Outcomes';
$string['displaytitle_mod_doc'] = 'Documento de Word';
$string['displaytitle_mod_html'] = 'Página web';
$string['displaytitle_mod_jpeg'] = 'Imagen';
$string['displaytitle_mod_mp3'] = 'Audio';
$string['displaytitle_mod_mp4'] = 'Video';
$string['displaytitle_mod_pdf'] = 'PDF';
$string['displaytitle_mod_ppt'] = 'Presentación PowerPoint';
$string['displaytitle_mod_txt'] = 'Texto';
$string['displaytitle_mod_xls'] = 'Hoja de cálculo';
$string['displaytitle_mod_zip'] = 'ZIP';
$string['documentation'] = 'Documentación';
$string['documentationurl'] = 'URL de Documentación';
$string['documentationurl_descr'] = 'URL donde puede encontrarse la documentación';
$string['download'] = 'Descargar';
$string['editoradvicesubtiles'] = 'En esta versión del plugin Mosaicos (Tiles), las actividades solamente aparecerán como sub-mosaicos si el modo de edición está desactivado';
$string['editsection'] = 'Editar sección';
$string['editsectionname'] = 'Editar nombre de sección';
$string['embeddedurlerror'] = 'Si un sitio web externo rehúsa a conectarse en la ventana superior, use este:';
$string['enablelinebreakfilter'] = 'Habilitar filtro de salto de línea';
$string['enablelinebreakfilter_desc'] = 'Filtrar los mosaicos para el caracter unión de palabras invisible {$a} y, si está presente y el título es largo, remplazarlo con "- " para permitir que se corten las líneas. En caso contrario, remplazar con nada (por ejemplo, sin saltos de línea).';
$string['entersection'] = 'Ingresar sección';
$string['existingimage'] = 'Imagen existente para este mosaico';
$string['expand'] = 'Expandir';
$string['expandall'] = 'Expandir todo';
$string['expandsections'] = 'Revelar todas las actividades (todas las secciones)';
$string['expandtopsection'] = 'Expandir sección superior';
$string['experimental'] = 'experimental';
$string['experimentalfeatures'] = 'Características experimentales';
$string['fileaddedtobottom'] = 'Archivo añadido al fondo de la sección';
$string['filterboth'] = 'Mostrar botones basados en números de mosaico y resultados del curso';
$string['filternumbers'] = 'Mostrar botones basados en números de mosaicos';
$string['filteroutcomes'] = 'Mostrar botones basados en resultados del curso';
$string['filteroutcomesrestore'] = 'El curso original empleaba resultados en la barra del filtro, lo que aun no está soportado durante el proceso de restauración. Por ello, la configuración de la barra del filtro ha sido cambiada en el curso restaurado. Si Usted desea usar resultados para filtrar mosaicos en el curso restaurado, por favor configure los resultados nuevamente. El curso original no ha sido cambiado.';
$string['filters'] = 'Filtros';
$string['fittilestowidth'] = 'Acomodar mosaicos al ancho de pantalla';
$string['fittilestowidth_desc'] = 'Si está activado, cuando un usuario accede a un curso en un dispositivo que no es móvil, los mosaicos se retrasarán al cargar por medio segundo mientras se hace un cálculo del mejor diseño. Por ejemplo, para evitar un mosaico por fila, centrar mosaicos en pantalla. Esto solamente pasará la primera vez que ingresen al curso en una sesión dada y entonces será recordado para la sesión o hasta que el usuario ajuste su tamaño de pantalla.';
$string['fixproblems'] = 'Corregir problemas';
$string['folderdisplayerror'] = 'Las carpetas configuradas para almacenar contenido en-línea no son compatibles con el formato de sub-mosaicos. Por eso, esta <a href="{$a}">carpeta</a> ha sido cambiada para mostrarse en una página separada';
$string['followthemecolour'] = 'Forzar seguir el color del tema';
$string['followthemecolour_desc'] = 'Si se configura a si, a los profesores se les dará una opción por este plugin y todos los colores de mosaicos debajo serán ignorados. en su lugar, se hará un intento para obtener los colores principales de la marca del tema y usarlos en sustitución';
$string['guidance'] = 'Guía';
$string['height'] = 'altura';
$string['hidden'] = 'Oculto';
$string['hide'] = 'Ocultar';
$string['hidefromothers'] = 'Ocultar sección';
$string['highcontrastmode'] = 'Modo de alto contraste';
$string['highcontrastmodeallow'] = 'Permitir Modo de alto contraste';
$string['highcontrastmodeallow_desc'] = 'Permitirle a los usuarios configurar una preferencia del usuario para mostrar cursos en mosaicos con alto contraste (los colores de mosaicos seleccionados por el profesor serán sobreescritos con un color oscuro)';
$string['highestsectionnum'] = 'Se encontró el número más alto de sección';
$string['home'] = 'Página inicial del curso';
$string['icontitle-address-book-o'] = 'Libro de direcciones';
$string['icontitle-assessment_graded'] = 'Evaluación A+';
$string['icontitle-assessment_timer'] = 'Reloj de evaluación';
$string['icontitle-asterisk'] = 'Asterisco';
$string['icontitle-award-solid'] = 'Roseta de premio';
$string['icontitle-balance-scale'] = 'Escalas de balanza';
$string['icontitle-bar-chart'] = 'Gráfico de barras';
$string['icontitle-bell-o'] = 'Campana';
$string['icontitle-binoculars'] = 'Binoculares';
$string['icontitle-bitcoin'] = 'Bitcoin';
$string['icontitle-book'] = 'Libro';
$string['icontitle-bookmark-o'] = 'Marcapáginas';
$string['icontitle-briefcase'] = 'Maletín';
$string['icontitle-building'] = 'Edificio';
$string['icontitle-bullhorn'] = 'Megáfono';
$string['icontitle-bullseye'] = 'Diana';
$string['icontitle-calculator'] = 'Calculadora';
$string['icontitle-calendar'] = 'Calendario';
$string['icontitle-calendar-check-o'] = 'Calendario con palomita';
$string['icontitle-check'] = 'Palomita';
$string['icontitle-child'] = 'Niño';
$string['icontitle-clock-o'] = 'Reloj';
$string['icontitle-clone'] = 'Clona';
$string['icontitle-cloud-download'] = 'Nube (descargar)';
$string['icontitle-cloud-upload'] = 'Nube (subir)';
$string['icontitle-comment-o'] = 'Comentario';
$string['icontitle-comments-o'] = 'Comentarios';
$string['icontitle-compass'] = 'Brújula';
$string['icontitle-diamond'] = 'Diamante';
$string['icontitle-dollar'] = 'Dólar';
$string['icontitle-euro'] = 'Euro';
$string['icontitle-exclamation-triangle'] = 'Exclamación adentro de triángulo';
$string['icontitle-feed'] = 'Canal RSS';
$string['icontitle-file-text-o'] = 'Archivo de texto';
$string['icontitle-film'] = 'Película';
$string['icontitle-flag-checkered'] = 'Bandera (a cuadros)';
$string['icontitle-flag-o'] = 'Bandera';
$string['icontitle-flash'] = 'Rayo';
$string['icontitle-flask'] = 'Matraz';
$string['icontitle-flipchart'] = 'Rotafolio';
$string['icontitle-frown-o'] = 'Carita triste';
$string['icontitle-gavel'] = 'Mazo';
$string['icontitle-gbp'] = 'Libra esterlina';
$string['icontitle-globe'] = 'Mapamundi';
$string['icontitle-handshake-o'] = 'Saludo de manos';
$string['icontitle-headphones'] = 'Audífonos';
$string['icontitle-heartbeat'] = 'Latido cardíaco';
$string['icontitle-history'] = 'Reloj de historia';
$string['icontitle-home'] = 'Hogar';
$string['icontitle-id-card-o'] = 'Tarjeta ID';
$string['icontitle-info'] = 'Información';
$string['icontitle-jigsaw'] = 'Rompecabezas';
$string['icontitle-key'] = 'LLave';
$string['icontitle-laptop'] = 'Laptop';
$string['icontitle-life-buoy'] = 'Salvavidas';
$string['icontitle-lightbulb-o'] = 'Foco';
$string['icontitle-line-chart'] = 'Gráfica de líneas';
$string['icontitle-list'] = 'Lista (viñetas)';
$string['icontitle-list-ol'] = 'Lista (numerada)';
$string['icontitle-location-arrow'] = 'Flecha ubicación';
$string['icontitle-map-marker'] = 'Marcador de mapa';
$string['icontitle-map-o'] = 'Mapa';
$string['icontitle-map-signs'] = 'Signos de mapa';
$string['icontitle-microphone'] = 'Micrófono';
$string['icontitle-mobile-phone'] = 'Teléfono móvil';
$string['icontitle-mortar-board'] = 'Birrete';
$string['icontitle-music'] = 'Música';
$string['icontitle-newspaper-o'] = 'Periódico diario';
$string['icontitle-number'] = 'Nuúmero {$a}';
$string['icontitle-pencil-square-o'] = 'Lápiz en cuadro';
$string['icontitle-person'] = 'Persona';
$string['icontitle-pie-chart'] = 'Gráfica de pastel';
$string['icontitle-podcast'] = 'Podcast';
$string['icontitle-puzzle-piece'] = 'Pieza de rompecabezas';
$string['icontitle-question-circle'] = 'Signo de interrogación en círculo';
$string['icontitle-random'] = 'Aleatorio';
$string['icontitle-refresh'] = 'Refrescar';
$string['icontitle-road'] = 'Carretera';
$string['icontitle-search'] = 'Lupa de aumento';
$string['icontitle-sliders'] = 'Deslizadores';
$string['icontitle-smile-o'] = 'Sonrisa';
$string['icontitle-star'] = 'Estrella (sombreada)';
$string['icontitle-star-half-o'] = 'Estrella (medio sombreada)';
$string['icontitle-star-o'] = 'Estrella (sin sombrear)';
$string['icontitle-survey'] = 'Encuesta';
$string['icontitle-tags'] = 'Etiquetas';
$string['icontitle-tasks'] = 'Trabajos pendientes';
$string['icontitle-television'] = 'Televisión';
$string['icontitle-thinking-person'] = 'Persona con foco';
$string['icontitle-thumbs-o-down'] = 'Pulgar abajo';
$string['icontitle-thumbs-o-up'] = 'Pulgar arriba';
$string['icontitle-trophy'] = 'Trofeo';
$string['icontitle-umbrella'] = 'Sombrilla';
$string['icontitle-university'] = 'Universidad';
$string['icontitle-user-o'] = 'Persona (sin sombrear)';
$string['icontitle-users'] = 'Gente';
$string['icontitle-volume-up'] = 'Bocina';
$string['icontitle-wrench'] = 'LLave inglesa';
$string['imagecannotbeused'] = 'La imagen no puede ser usada';
$string['imagedeletedfrom'] = 'Imagen eliminada de "{$a}"';
$string['imagesavedfor'] = 'Imagen guardada para {$a}';
$string['imagesize'] = 'Tamaño de imagen';
$string['invalidsectionid'] = 'ID de sección inválido "{$a}"';
$string['jsactivate'] = 'Navegación animada';
$string['jsdeactivated'] = 'Usted ha desactivado la navegación animada en su cuenta.';
$string['jsreactivated'] = 'Usted ha activado la navegación animada en su cuenta.';
$string['legacytiledata'] = 'Número de datos de mosaico antiguo';
$string['links'] = 'Enlace';
$string['loading'] = 'Cargando';
$string['maxcoursesectionsallowed'] = 'El número máximo de de secciones de curso permitidas en este entorno es {$a}.';
$string['migratecoursedata'] = 'Migrar datos del curso';
$string['migratedcourseid'] = 'ID de curso migrado {$a}';
$string['migratenow'] = 'Migrar ahorita mismo';
$string['modalmodules'] = 'Módulos modales';
$string['modalmodules_desc'] = 'Invocar estos módulos de curso en una ventana modal. (Otros módulos pueden ser añadidos en una versión posterior).';
$string['modalresources'] = 'Recursos modales';
$string['modalresources_desc'] = 'Invocar estos recursos en ventana modal. Tenga en cuenta: si se permite aquí, las actividades URL solamente abrirán en una ventana modal si están configuradas a  {$a->displayembed} al nivel de la actividad (por ejemplo, videos de YouTube o Vimeo).  Aun entonces, podrían estar bloqueadas por el propietario del sitio web para no mostrar incrustadas - vea {$a->link}';
$string['modalwindows'] = 'Ventanas modales';
$string['newsectionname'] = 'Nuevo nombre para sección {$a}';
$string['newtiledata'] = 'Número de datos de nuevo mosaico';
$string['nexttopic'] = 'Siguiente tópico';
$string['noconnectionerror'] = 'No se puede cargar contenido. revise su conexión de Internet';
$string['nojswarning'] = 'Al parecer su navegador no soporta JavaScript, o está deshabilitado. Si Usted habilita JavaScript estará disponible una interfaz mejorada';
$string['none'] = 'Ninguno';
$string['noproblemsfound'] = 'No se encontraron problemas';
$string['notcomplete'] = 'Incompleto';
$string['notrecommended'] = 'No recomendable';
$string['novaliddefaultcolour'] = 'No se ha configurado color válido para el color predeterminado de mosaico abajo';
$string['numberofsections'] = 'Número de secciones en curso';
$string['numbers'] = 'Números';
$string['numbers_desc'] = 'Elegir un número de ícono para este mosaico';
$string['off'] = 'Desactivada';
$string['ok'] = 'OK';
$string['on'] = 'Activada';
$string['onlywhenediting'] = 'Solamente al editar';
$string['other'] = 'Otras';
$string['outcomes'] = 'resultados';
$string['outcomesunavailable'] = 'Resultados no disponibles';
$string['overall'] = 'General';
$string['overallprogress'] = 'Finalización de actividad - progreso general';
$string['overallprogressshort'] = 'Progreso general';
$string['photoguidance_desc'] = '<p>Suba una foto en formato de <strong>paisaje</strong>.  El ancho debería ser alrededor de 1.35 veces la altura.  Por ejemplo 270 ancho x 200 alto encajaría bien. Usted no necesita ser exacto.</p>
<p>Las fotos en formato retrato no coincidirán con la forma del mosaico. Las imágenes o archivos grandes serán escalados y comprimidos si fuera necesario, después de subirse.</p>';
$string['photolibrary'] = 'Biblioteca de fotos';
$string['photolibrary_desc'] = 'Estas son las fotos que Usted ha subido o usado recientemente. Para usar una como el fondo para este mosaico, haga clic en ella. Para subir una foto nueva, use la pestaña para subir de arriba.';
$string['phototilesaltstyle'] = 'Estilo alternativo de mosaico de foto';
$string['phototilesaltstyle_desc'] = 'Si no está seleccionado (lo que está predeterminado), mosaicos de fotos mostrarán el título en la parte superior del mosaico. El estilo alternativo muestra el título en el fondo';
$string['phototilesettings'] = 'Mosaicos de foto';
$string['phototiletitletransarency'] = 'Transparencia de título de mosaico de foto';
$string['phototiletitletransarency_desc'] = 'El sobrepuesto del título en un mosaico de foto puede tener un fondo ligeramente transparente o un fondo de color sólido (0%)';
$string['phototitletitlelineheight'] = 'Altura de línea de título';
$string['phototitletitlepadding'] = 'El relleno vertical de línea del título';
$string['picknewicon'] = 'Elegir un nuevo ícono';
$string['picknewiconphoto'] = 'Elegir un nuevo ícono o imagen de fondo';
$string['plugin_description'] = 'Un formato visualmente rico, donde las secciones y actividades están representadas por mosaicos, con fotos, íconos y colores personalizables.';
$string['pluginname'] = 'Mosaicos';
$string['previoustopic'] = 'Tópico anterior';
$string['privacy:metadata:preference:format_tiles_high_contrast_mode'] = 'Si es que el usuario está o no usando el modo de alto contraste.';
$string['privacy:metadata:preference:format_tiles_stopjsnav'] = 'Si es que el usuario ha desactivado o no la navegación animada por JavaScript.';
$string['privacypolicy'] = 'Política de privacidad';
$string['problemcourses'] = 'Cursos con problemas';
$string['problemcoursesintro'] = 'Los cursos siguientes tienen números de sección mayores a los esperados. Por favor use los botones inferiores para resolver los problemas.';
$string['progress'] = 'Progreso';
$string['progressincludesubsections'] = 'Indicador del progreso - ¿incluir datos de sub-sección?';
$string['progressincludesubsections_desc'] = '¿Debería de incluir datos del progreso el indicador del progreso del mosaico para actividades adentro de sus sub-secciones?';
$string['progresstitle'] = '{$a->numComplete} / {$a->numOutOf} elementos completos ({$a->percent}%)';
$string['reactivate'] = 'Reactivar';
$string['reopenlastsection'] = 'Re-abrir el último mosaico visitado';
$string['reopenlastsection_desc'] = 'Cuando se activa, si un usuario re-visita un curso, la última sección que haya abierto será re-abierta al ingresar';
$string['resetallcoursecolours'] = 'Reiniciar los colores de todos los cursos';
$string['resetalltiles'] = 'Reiniciar fotos e íconos de mosaico';
$string['resetalltilessure'] = '¿Está seguro de querer reiniciar los mosaicos para este curso? Esto eliminará todas las fotos del mosaico, y reiniciará todos los íconos a lo predeterminado. El contenido NO será eliminado. Esta es una acción destructiva y no puede deshacerse. En caso de duda, respalde su curso primero.';
$string['resetcolours'] = 'Reiniciar colores';
$string['resetcolours_desc'] = 'Presione este botón para reiniciar el color del mosaico para todos los cursos que no tienen uno de los colores inferiores. Los cursos serán cambiados al color inferior del mosaico predeterminado. Usted puede usar esto después de que haya cambiado la paleta de colores inferior, pero asegúrese que haya <strong>guardado cualquier cambio</strong> a los colores debajo antes de presionar este botón. ¡Tenga cuidado ya que esto podría cambiar el color de muchos cursos!';
$string['resetincomplete'] = 'Reinicio incompleto';
$string['restorefailed'] = 'Falló restauración';
$string['restoreincorrectsections'] = 'Error: No se puede completar porque el curso orígen contiene secciones numeradas incorrectamente (por ejemplo el número de sección ({$a->sectionnum}) es mayor que el máximo permitido ({$a->maxallowed})  como está definido en la configuración administrativa \'moodlecourse | maxsections\').  Intente excluir o eliminar secciones con números grandes.';
$string['restoretoomanysections'] = 'Error: No se puede respaldar o restaurar porque están incluidas demasiadas secciones de curso ({$a->numsections}) y esto son más de lo permitido ({$a->maxallowed}).  Intente excluir o eliminar algunas secciones.';
$string['revealcontents'] = 'Revelar contenidos de mosaico';
$string['section0name'] = 'General';
$string['sectionerrorstring'] = 'Su sesión podría haber expirado. Intente refrescar esta página.';
$string['sectionerrortitle'] = 'Error al cargar contenido';
$string['sectionname'] = 'Mosaico';
$string['sectionnumber'] = 'Número de mosaico / sección';
$string['selected'] = 'Seleccionado';
$string['setavailabletilecolours'] = 'Colores de mosaico permitidos (todo el sitio)';
$string['setbackgroundphoto'] = 'Configurar foto / ícono';
$string['settings'] = 'Configuraciones de formato de mosaicos';
$string['show'] = 'Mostrar';
$string['showalltiles'] = 'Mostrar todos los mosaicos';
$string['showfromothers'] = 'Mostrar sección';
$string['showoverallprogress'] = 'Mostrar indicador general de progreso';
$string['showoverallprogress_desc'] = 'Mostrar indicador de "Progreso General %" en  la parte superior derecha del curso (el valor mostrado representa la agregación del % completado de cada mosaico, basado en la finalización de la actividad, no de la finalización del curso.';
$string['showprogresssphototiles_desc'] = 'Si se selecciona, el progreso del estudiante (por ejemplo: Progreso 2/5) será mostrado en mosaicos de foto';
$string['showseczerocoursewide'] = 'Mostrar sección cero en la parte superior de todas las secciones';
$string['showseczerocoursewide_desc'] = 'Si se activa, la sección cero (la sección más superior) será mostrada en la página de inicio del curso y en la parte superior de <b>cada página de sección de curso</b> por ejemplo en la parte superior de cada contenido de mosaico). Si no se activa (recomendado), solamente será mostrado en la página inicial del curso';
$string['showseparatewin'] = 'Mostrar en ventana separada';
$string['sitename'] = 'Nombre del sitio';
$string['snapwarning'] = 'Sería posible editar su curso en formato Mosaicos usando otro tema, y después cambiar de regreso al tema Snap una vez que Usted haya terminado de editar.';
$string['snapwarning_help'] = 'Theme_settings#Allow_user_themes';
$string['style'] = 'Estilo';
$string['subtileiconcolourbackground'] = 'Íconos de sub-mosaico - usar círculo de fondo de color sólido';
$string['subtileiconcolourbackground_desc'] = 'Si se activa, los íconos de sub-mosaico son mostrados como íconos blancos en un círculo con fondo de color sólido. En caso contrario, los íconos están (1) coloreados y (2) en un círculo coloreado pero no sólido';
$string['subtileszeczerotoggled'] = 'La sección superior alterna entre lista y formato sub mosaicos';
$string['suremigratelegacyoptions'] = '¿Está seguro de querer migrar la foto del mosaico {$a} o las opciones de ícono para este curso?';
$string['sureresetcolours'] = '¿Está seguro de querer reiniciar colores de mosaico del curso a predeterminados? Esto afectará {$a} cursos';
$string['tilearialabel'] = '{$a}, abre detalles en ventana emergente, enlace';
$string['tilecolourgeneral'] = 'Paleta de colores - color opcional';
$string['tilecolourgeneral_descr'] = 'Estas configuraciones le permiten al administrador configurar cuales colores estarán disponibles para que los profesores los apliquen a los cursos. Configure el color a negro (#000) para deshabilitar ese color. Si usted cambia aquí los colores, no se harán cambios a los cursos existentes, hasta la siguiente vez que el profesor trate de cambiar el color. En ese punto, solamente los colores que usted haya configurado aquí  estarán disponibles para el profesor.';
$string['tilecolourschanged'] = 'Los colores de mosaicos han sido reiniciados. Todos los mosaicos tienen colores conforme a los colores debajo.';
$string['tileicon'] = 'Ícono / foto a mostrar en este mosaico solamente';
$string['tileicon_help'] = 'El ítem aquí seleccionado anulará, solamente para este mosaico, cualquier ícono que  haya sido configurado a nivel del curso.';
$string['tileicons'] = 'Íconos del mosaico';
$string['tileoutcome'] = 'Resultado para este mosaico';
$string['tileoutcome_help'] = 'Si Usted selecciona un resultado para este mosaico, Usted podrá mostrar, debajo de configuraciones del curso, un conjunto de <em>botones filtro</em>, uno para cada resultado, los cuales cuando son presionados, filtran los mosaicos mostrados de acuerdo a cuales resultados  han sido asignados';
$string['tileselecttip'] = 'En el curso, con el modo de edición activado, simplemente hacer clic en el ícono o foto que desea cambiar. Aparecerá la ventana del selector de ícono.';
$string['tilesformatregistration'] = 'Registro del formato Mosaicos';
$string['tilesreset'] = 'Mosaicos e íconos han sido reiniciados para este curso';
$string['tilestyle'] = 'Estilo del Mosaico';
$string['tilestyle_desc'] = 'Estilo 1 = mosaicos con foto mostrarán el título en la parte superior del mosaico; estilo 2 = título al fondo';
$string['togglecompletion'] = 'Hacer clic para alternar estado de finalización';
$string['togglecompletioncomplete'] = 'Clic para alternar estado de finalización (completo)';
$string['togglecompletionincomplete'] = 'Clic para alternar estado de finalización (incompleto)';
$string['tootall'] = 'demasiado alto para el mosaico';
$string['toowide'] = 'demasiado ancho para el mosaico';
$string['transparenttitleadjustments'] = 'Ajustes de título transparente';
$string['transparenttitleadjustments_desc'] = 'En mosaico de foto con fondos de títulos transparente, dependiendo de su tema, usted podría querer ajustar estos para asegurar que las líneas transparentes del título no se sobrepongan cuando se den la vuelta.
Tenga en cuenta que esto también varía un poco entre los navegadores.  Los valores sugeridos para temas basados en Chrome: Boost y Clean: 30.5 y 4 | Adaptable: 32 and 4 | Moove: 32 y 2 | Remui: 32 y 2.5';
$string['unmigratedcoursesintro'] = 'Los siguientes {$a} cursos al parecer no han tenido sus íconos y fotos del mosaico migrados después de una actualización del sistema. Haga clic en el botón para procesar ahorita mismo un curso. Si lo desea, el proceso de "cron" en segundo plano debería de procesar esto, pero si usted quiere procesar ahorita mismo un curso dado, haga clic en el botón.';
$string['uploadnewphoto'] = 'Subir nueva foto';
$string['uploadnewphoto_help'] = 'Subir una imagen a ser usada en este mosaico';
$string['usecourseindex'] = 'Usar índice del curso';
$string['usecourseindex_desc'] = 'Cuando se trata de un curso con mosaicos, ¿debería de mostrarse el índice del curso a la izquierda?';
$string['usejavascriptnav'] = 'Usar navegación JavaScript desde la página  principal de Mosaicos';
$string['usejavascriptnav_desc'] = 'Cuando se activa, si un usuario hace clic en un Mosaico en la página de vista general del curso, y tiene JavaScript habilitado, se usará JS para transicionar a contenidos de mosaico. Los contenidos del mosaico serán almacenados localmente en el navegador de acuerdo a las otras configuraciones debajo. Si no se activa, JS no será usado y en su lugar se empleará la navegación antigua. Las otras configuraciones JS debajo serán ignoradas.';
$string['usejseditingexpandcollapse'] = 'Moodo de edición - use JavaScript para expandir/colapsar mosaicos';
$string['usejseditingexpandcollapse_desc'] = 'Si se selecciona, en modo de edición un profesor puede expandir y colapsar la edición de mosaicos con transiciones animadas. El contenido de los mosaicos será cargado al expandir, sin re-carga de la página.';
$string['usejsnavforsinglesection'] = 'Usar navegación JavaScript  para página de sección única';
$string['usejsnavforsinglesection_desc'] = 'Cuando se activa, cualquier llamada a una página de sección única  (&section=xx) será manejada usando JavaScript, al invocar la página principal del curso para abrir la sección solicitada vía JS, en lugar de llamar a la página de sección única con el estilo PHP antiguo';
$string['usesubtilesseczero'] = 'Usar sub mosaicos en sección superior';
$string['usesubtilesseczero_help'] = 'Si se selecciona, serán usados sub mosaicos en la sección superior del curso además de adentro de todos los mosaicos. Esto es porque los sub mosaicos usan mucho espacio en la parte más superior del curso. Sería mejor dejar esto sin seleccionar, para que, en vez de esto, cualquier elemento en la sección superior sea mostrado  en formato de lista estándar.';
$string['version'] = 'Versión {$a}';
$string['width'] = 'ancho';
