<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'pokcertificate', language 'es_mx', version '4.5'.
 *
 * @package     pokcertificate
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessdenied'] = 'Acceso Denegado';
$string['action'] = 'Acción';
$string['activity'] = 'Actividad';
$string['apifields'] = 'campo POK';
$string['apikeysurl'] = 'URL de API API_KEYS_ROOT';
$string['authenticationcheck'] = '¡Autenticación No verificada! Haga clic en continuar para verificar la autenticación';
$string['authenticationcheck_user'] = '¡Autenticación No verificada! Por favor póngase en contacto con el Administrador del Sitio';
$string['authenticationmethods'] = 'Método de autenticación';
$string['authtoken'] = 'Token de autenticación';
$string['authtoken_help'] = 'Por favor ingrese token válido de autenticación para verificar POK.';
$string['award'] = 'Otorgar';
$string['awardcertificate'] = 'Otorgar Certificado';
$string['back'] = 'Regresar';
$string['basiccredentials'] = 'Credenciales básicas';
$string['bulkupload'] = 'Subida masiva';
$string['cannotedit'] = 'Los profesores no pueden editar';
$string['cannotreadtmpfile'] = 'El archivo subido está vacío. Por favor suba un archivo válido.';
$string['certficatestobesent'] = 'Credenciales Blockchain a ser enviadas';
$string['certificateissuemsg'] = 'Uste dha recibido un email para aceptar su certificado';
$string['certificatename'] = 'Nombre del Certificado';
$string['certificatenotconfigured'] = '¡El certificado aun no está configurado! Por favor póngase en contacto con el Administrador del Sitio';
$string['certificatenotissued'] = '¡Certificado no emitido! Por favor póngase en contacto con el Administrador del Sitio';
$string['certificatepending'] = 'Certificado Pendiente';
$string['certificatesent'] = 'Éxito al enviar certificado';
$string['certificateslist'] = 'Cambiar Plantilla';
$string['certificatestatus'] = 'Estado del Certificado';
$string['certificatesuccess'] = 'Verificación de detalles de la Cuenta';
$string['certificatesuccessmsg'] = 'Usted ha recibido un Email para aceptar su certificado <br/><br/> <b><center>{$a}</center></b>';
$string['certificatetitle'] = 'Título del Certificado';
$string['certificatstatus'] = 'Estado del Certificado';
$string['checkstatus'] = 'Comprobar Estado';
$string['clickhere'] = 'Hacer clic aquí';
$string['complete'] = 'Completo';
$string['completedate'] = 'Fecha de Finalización';
$string['completiondetail:submit'] = 'Debe recibir certificado';
$string['completionmsg'] = 'Usted ha completado el curso';
$string['completionmustrecievecert'] = 'Debe recibir certificado';
$string['configdisplayoptions'] = 'Seleccionar todas las opciones que deberían estar disponible; las configuraciones existentes no son modificadas. Mantenga presionada la tecla CTRL para seleccionar varios campos.';
$string['congratulations'] = 'Felicitaciones';
$string['connecterror'] = 'Error de conexión API';
$string['contact'] = 'Ponerse en contacto con POK';
$string['contact_link'] = 'Póngase en contacto con nosotros vía <a href="#">contacto@pok.tech</a> para verlo';
$string['contact_text'] = 'Si usted no tiene su token de autenticación';
$string['content'] = 'Contenido de página';
$string['contentheader'] = 'Contenido';
$string['course'] = 'Curso';
$string['coursecertificatestatus'] = 'Estado de Certificado del Curso';
$string['coursename'] = 'Nombr del Curso';
$string['courseparticipants'] = 'Participantes del Curso';
$string['coursestatus'] = 'Estado del Curso';
$string['createpokcertificate'] = 'Crear un nuevo recurso de pokcertificate';
$string['credential_desc'] = 'Con POK, otorgue credenciales a estudiantes inscritos en sus cursos, asegurando autenticidad y transparencia en la cadena de bloque.';
$string['credential_link'] = 'Credenciales digitales';
$string['credential_title'] = 'Emitir Credenciales Verificables, Micro-Credenciales, Certificados, Diplomas, Insignias y Pruebas de Asistencia como NFTs en el Blockchain';
$string['csvfewcolumns'] = 'No hay suficientes columnas. Suba archivo con las columnas \'username, studentname, surname, email, studentid\'.';
$string['curlapierror'] = '¡Algo salió ma! Póngase en contacto con el Administrador del Sitio';
$string['custodianapisurl'] = 'URL de API CUSTODIAN_ROOT';
$string['description'] = 'Descripción';
$string['displaycertificatemsg'] = 'Por favor haga en el enlace de abajo para ver el Certificado <br/>';
$string['displayoptions'] = 'Opciones de vista disponibles';
$string['displayselect'] = 'Mostrar';
$string['displayselectexplain'] = 'Seleccionar tipo de vista';
$string['domain'] = 'Nombre del Dominio';
$string['domain_help'] = 'Nombre del Dominio';
$string['done'] = 'Hecho';
$string['duplicatefieldname'] = 'Nombre de campo duplicado \'{$a}\' detectado.';
$string['email'] = 'Email';
$string['email_help'] = 'Email que será mostrado en certificado';
$string['empfile_syncstatus'] = 'Estado de sincronización de archivo de estudiante';
$string['enrolldate'] = 'Fecha de Inscripción';
$string['errorscount_msg'] = 'Un total  de {$a} errores ocurieron en la subida masiva.';
$string['fail'] = 'Falló';
$string['failed'] = 'Verificación Falló';
$string['fieldmapping'] = 'Mapeo de campos';
$string['fieldmappingerror'] = 'Por favor seleccione campo del usuario a ser mapeado';
$string['filedmappingmissing'] = 'Campos de plantilla personalizada no mapeados';
$string['firstname'] = 'Nombre del Estudiante';
$string['firstname_help'] = 'El nombre del estudiante ser´mostrado en el certificado.';
$string['free'] = 'Gratuito';
$string['generalcertificate'] = 'Otorgar Certificados Generales';
$string['generalcertstatus'] = 'Estado de Certificado General';
$string['help_manual'] = 'Manual de Ayuda';
$string['helpmanual'] = 'Manual de Ayuda';
$string['helpmanualsdata'] = '<div class="field_type font-weight-bold" style="text-align:left;"></div>
    <br>
    <div class="helpmanual_table"><table class="generaltable" border="1">
        <table class="generaltable" border="1">
            <th>Campos Obligatorios</th>
            <th>Restricción</th>
            <tr>
                <td>usuario</td>
                <td>Por favor no cambie el nombre de usuario.</td>
            </tr>
            <tr>
                <td>studentname(firstname)</td>
                <td>Por favor ingrese/modifique studentname.</td>
            </tr>
            <tr>
                <td>surname(lastname)</td>
                <td>Por favor ingrese/modifique apellido(s).</td>
            </tr>
            <tr>
                <td>email</td>
                <td>Por favor ingrese/modifique  email.</td>
            </tr>
            <tr>
                <td>studentid(idnumber)</td>
                <td>Por favor ingrese/modifique  studentid.</td>
            </tr>
            <tr>
            <td>customprofilefields</td>
            <td>campos personalizados del perfil si hubiera (comienzan con  profile_field_fieldname).</td>
        </tr>
        </table>
    </div>';
$string['idnumber'] = 'ID del Estudiante / IDnumber';
$string['idnumber_help'] = 'IDnumber mismo es una ID del estudiante que será mostrada en el certificado. which will be displayed on certificate.';
$string['incomplete'] = 'Perfil Incompleto';
$string['incompleteactivity'] = 'Actividad Incompleta';
$string['incompleteprofile'] = 'Perfil del Estudiante Incompleto';
$string['incompletestudent'] = 'Perfiles de Estudiantes Incompletos';
$string['indicator:cognitivedepth'] = 'Página cognitivo';
$string['indicator:cognitivedepth_help'] = 'Este indicador está basado en la profundidad cognitiva alcanzada por el estudiante en un recurso Página.';
$string['indicator:cognitivedepthdef'] = 'Página cognitivo';
$string['indicator:cognitivedepthdef_help'] = 'El participante ha alcanzado este porcentaje de la dedicación cognitiva ofrecida por los recursos Página durante este intervalo de análisis (Niveles = No visto, Visto)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Página social';
$string['indicator:socialbreadth_help'] = 'Este indicador está basado en la amplitud social alcanzada por el estudiante en un recurso Página.';
$string['indicator:socialbreadthdef'] = 'Página social';
$string['indicator:socialbreadthdef_help'] = 'l participante ha alcanzado este porcentaje en la dedicación social ofrecida por los recurso Página durante este intervalo de análisis (Niveles = Sin participación, Participante solo)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['inprogress'] = 'EnProgreso';
$string['institution'] = 'Nombre de la Institución';
$string['institution_help'] = 'El nombre de la institución será auto-llenado una vez que el token de autenticación sea verificado.';
$string['institution_help_help'] = 'Este campo será mostrado en los certificados que van a ser emitidos <br> (Por favor verifique el token de autenticación en las configuraciones para obtener el nombre de la institución).';
$string['invalid'] = 'Inválido';
$string['invalidauthenticationtoken'] = 'Por favor ingrese un token válido de autenticación';
$string['invalidcoursemodule'] = 'ID de módulo de curso inválida';
$string['invalidemail'] = 'Por favor ingrese un Email válido';
$string['invalidemail_msg'] = 'Email inválido en línea {$a->linenumber}.';
$string['invalidfieldname'] = '\'{$a}\' no es un nombre de campo válido.';
$string['invalidinputs'] = 'Entradas inválidas recibidas';
$string['invalidsapecialcharecter'] = '{$a->field} inválido en línea {$a->linenumber}. Escríbalo sin caracteres especiales.';
$string['invalidspechar'] = 'Por favor No use caracteres especiales';
$string['invalidtemplate'] = 'Nombre inválido de palntilla; por favor seleccione uan plantilla va´lida';
$string['invalidtemplatedef'] = 'Definición inválida de Plantilla';
$string['issuecertificate'] = 'Emitir Certificado';
$string['issuecertificatestask'] = 'Trabajo para Emitir Certificado POK a usuario';
$string['issueddate'] = 'Fecha de Emisión';
$string['issuedddate'] = 'Fecha de Emisión';
$string['language'] = 'Idioma';
$string['lastname'] = 'Apellido(s)';
$string['lastname_help'] = 'Apellido(s) a mostrar en certificado.';
$string['legacyfiles'] = 'Archivo de migración de curso antiguo';
$string['legacyfilesactive'] = 'Activo';
$string['legacyfilesdone'] = 'Terminado';
$string['linkpokdetails'] = 'Enlazar Detalles de Cuenta POK';
$string['live'] = 'EN VIVO';
$string['mailacceptancepending'] = 'Actualmente su certificado está siendo procesado. Uste drecibirá un Email con isntrucciones acerca de cóo acetpar su certificado. Para cualquier pregunta por favor póngase en contacto con {$a->institution}.
<br /><br />';
$string['mailpending'] = 'Aceptación de correo pendiente';
$string['minterapiurl'] = 'URL de API MINTER_ROOT';
$string['missing'] = 'Falta {$a->field} en línea {$a->linenumber}.';
$string['modulename'] = 'Certificado POK';
$string['modulename_help'] = 'Los certificados POK (Proof Of Knowledge = Prueba del Conocimiento) le permiten a los administradores y profesores asignar certificados de su organización a cursos Moodle. Estos certificados serán enviados automáticamnet a estudiantes inscritos que cumplan con los requisitos del curso. O, pueden ser otorgados manualmente por administradores

<b>Ventajas de usar POK:</b><br>
    <span class="p-5">* Certificados inalterables y fáciles de verificar.<br></span>
    <span class="p-5">* Se pueden compartir en varios formatos y redes sociales.<br></span>
    <span class="p-5">* Reconocimiento de logros con tecnología de blockchain, que garantiza seguridad y privacidad.<br></span>

<b>Un pokcertificate puede ser usado como:</b><br>
    <span class="p-5"><b> * Certificado de Finalización de Curso: </b>Emitido automáticamente cuando el estuiante completa todas las actividades del curso.<br></span>
    <span class="p-5"><b> * Insignia de participación: </b>Otorgada a estudiantes que asistan a un número especificado de clases o actividades.<br></span>
    <span class="p-5"><b> * Micro-credenciales: </b>Reconocen habilidades específicas apendidas durante el curso, como completar un módulo o pasar un examen.<br></span>';
$string['modulename_link'] = 'https://www.pok.tech/';
$string['modulenameplural'] = 'Certificados POK';
$string['no_data_available'] = 'SIN Datos Disponibles';
$string['none'] = 'Ninguno';
$string['norecordavailable'] = 'SIN registro disponible';
$string['notissued'] = 'NO emitido';
$string['notverified'] = 'NO verificado';
$string['nouserrecord'] = 'No hay datos disponibles con usuario \'{$a->username}\' en línea {$a->linenumber}';
$string['optionsheader'] = 'Mostrar opciones';
$string['pages'] = 'Elegir una página personalizada';
$string['paid'] = 'De Pago';
$string['participants'] = 'Participantes del Curso';
$string['pendingcertificatemsg'] = 'Su certificado está siendo emitido por {$a->institution}.
Nos gustaría recordarle que es importante que usted compruebe su Email para poder aceptar el certificado. Para cualquier pregunta por favor póngase en contacto con {$a->institution} . <br /><br />';
$string['pluginadministration'] = 'Página de administración del módulo';
$string['pluginname'] = 'Certificado POK';
$string['pokcertificate-mod-pokcertificate-x'] = 'Cualquier pokcertificate del módulo pokcertificate';
$string['pokcertificate:addinstance'] = 'Añadir un nuevo recurso pokcertificate';
$string['pokcertificate:awardcertificate'] = 'Otorgar Certificado';
$string['pokcertificate:deleteinstance'] = 'Eliminar recurso pokcertificate';
$string['pokcertificate:editinstance'] = 'Editar recurso pokcertificate';
$string['pokcertificate:managecoursecertificate'] = 'Gestionar estado de certificado del curso';
$string['pokcertificate:manageinstance'] = 'Gestionar recurso pokcertificate';
$string['pokcertificate:updateincompleteprofile'] = 'Actualizar usted mismo el perfil incompleto';
$string['pokcertificate:uploadincompleteprofile'] = 'Actualizar masivamente perfil incompleto';
$string['pokcertificate:view'] = 'Ver contenido pokcertificate';
$string['pokcertificate:viewstatusreport'] = 'Ver reporte del estado';
$string['pokverifyauth'] = 'Verificación de autenticación POK';
$string['popupheight'] = 'Altura de ventana emergente (en pixeles)';
$string['popupheightexplain'] = 'Especificar altura predeterminada de ventanas emergentes.';
$string['popupwidth'] = 'Ancho de ventana emergente (en pixeles)';
$string['popupwidthexplain'] = 'Especificar ancho predeterminado de ventanas emergentes.';
$string['previewcertificate'] = 'Previsualizar certificado';
$string['previewnotexists'] = 'NO existe previsualización de certificado';
$string['printheading'] = 'Mostrar nombre de pokcertificate';
$string['printheadingexplain'] = '¿Mostrar nombre de pokcertificate arriba del contenido?';
$string['printintro'] = 'Mostrar descripción de pokcertificate';
$string['printintroexplain'] = '¿Mostrar descripción de pokcertificate arriba del contenido?';
$string['printlastmodified'] = 'Mostrar fecha de última modificación';
$string['printlastmodifiedexplain'] = '¿Mostrar fecha de última modificación debajo del contenido?';
$string['privacy:metadata'] = 'El plugin del recurso Página no almacena ningún dato personal.';
$string['privacy:metadata:pokcertificate_issues'] = 'La lsiat de POKcertificates emitidos';
$string['privacy:metadata:pokcertificate_issues:certificateurl'] = 'La URL del POKcertificate que pertenece al usuario';
$string['privacy:metadata:pokcertificate_issues:pokcertificateid'] = 'El código del POKcertificate que pertenece al usuario';
$string['privacy:metadata:pokcertificate_issues:pokid'] = 'La ID que pertenece a la actividad POKcertificate';
$string['privacy:metadata:pokcertificate_issues:status'] = 'El estado del POKcertificate, ya sea emitido o no';
$string['privacy:metadata:pokcertificate_issues:templateid'] = 'LA ID de la plantilla a la cual está mapeada la actividad de POKcertificate';
$string['privacy:metadata:pokcertificate_issues:timecreated'] = 'La hora de cuando fue emitido el POKcertificate';
$string['privacy:metadata:pokcertificate_issues:useremail'] = 'El Email del usuario al que es enviado el Email de confirmación para emitir un POKcertificate';
$string['privacy:metadata:pokcertificate_issues:userid'] = 'La ID del usuario al que se le otorgó el POKcertificate';
$string['prodtype'] = 'Tipo de Producción';
$string['prodtype_help'] = 'Seleccionar Tipo de Producción <br>(Basado en tipo de producción la URL de la API será tomada).';
$string['profile'] = 'Perfil';
$string['profilefields'] = 'Campos del Perfil del Usuario';
$string['profilestatus'] = 'Estado del Perfil';
$string['qa'] = 'QA';
$string['rbacapiurl'] = 'URL de API de RBAC_ROOT';
$string['removeissues'] = 'Quitar certificados emitidos';
$string['response'] = 'Respuesta';
$string['sample'] = 'Muestra';
$string['search:activity'] = 'Página';
$string['selectcourse'] = 'Seleccionar Curso';
$string['senttopok'] = 'Enviar a POK';
$string['studentexist'] = 'Estudiante ya existe con {$a->field} \'{$a->data}\' en línea {$a->linenumber}.';
$string['studentid'] = 'ID del Estudiante';
$string['studentname'] = 'Nombre del Estudiante';
$string['successful'] = 'Verificación Exitosa';
$string['surname'] = 'Apellido(s)';
$string['templateapiurl'] = 'URL de API TEMPLATE_MANAGER_ROOT';
$string['templateupdated'] = 'Plantilla actualizada para cetificado POK';
$string['title'] = 'Título';
$string['title_help'] = 'Este campo será mostrado en los certificados que van a ser emitidos';
$string['tryagain'] = 'Intentar nuevamente';
$string['typeofcerti'] = 'Tipo de Certificado';
$string['unlimited'] = 'Ilimitado';
$string['updatedusers_msg'] = 'Un total de {$a} usuarios tuvo detalles actualizados.';
$string['userfieldmapping'] = 'Mapeo de Campo de Usuario';
$string['userfields'] = 'CAmpo Moodle';
$string['userfullname'] = 'Nombrecompletodeusuario';
$string['userprofilefields'] = 'Para añadir campos del perfil del usuario';
$string['usethistemplate'] = 'Usar esta plantilla';
$string['validuserprofiles'] = 'Nota: Los certificados son otorgados a usuarios cuyo estado de peril es \'Completado\'.';
$string['validuserprofilesforteachers'] = 'Nota: Los profesores pueden ver/otorgar certificados a usuarios cuyo estado de peril es \'Completado\'.';
$string['verfiydesc'] = 'Ingrese el token generado en POK para enlazar sus atividades de Moodle y emitir credenciales de forma automática.';
$string['verfiytext'] = 'Verificar su Token de Autenticación';
$string['verification'] = 'Verificación de Detalles de Cuenta';
$string['verified'] = 'Verificado';
$string['verify'] = 'Verificar';
$string['verifyauth'] = 'Para verificar token de autenticación';
$string['viewcertificate'] = 'Ver Certificado';
