<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'forum', language 'tr', version '4.5'.
 *
 * @package     forum
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actionsforgraderinterface'] = 'Sınıflayıcı arayüzü için eylemler';
$string['actionsforpost'] = 'Yayın için eylemler';
$string['activitydate:due'] = 'Son tarih:';
$string['activityoverview'] = 'Yeni forum gönderileri var';
$string['addanewdiscussion'] = 'Yeni tartışma konusu ekle';
$string['addanewquestion'] = 'Yeni soru ekle';
$string['addanewtopic'] = 'Yeni konu ekle';
$string['addreply'] = 'Cevap ekle';
$string['addtofavourites'] = 'Bu tartışmaya yıldız ekle';
$string['advancedsearch'] = 'Gelişmiş arama';
$string['alldiscussions'] = 'Tüm tartışmalar';
$string['allforums'] = 'Tüm forumlar';
$string['allowdiscussions'] = '{$a} bu foruma mesaj gönderebilir mi?';
$string['allowsallsubscribe'] = 'Bu foruma herkes abone olabilir';
$string['allowsdiscussions'] = 'Bu forumda bir kişi bir tartışma konusu başlatabilir';
$string['allsubscribe'] = 'Tüm forumlara abone ol';
$string['allunsubscribe'] = 'Tüm forumlardan aboneliği kaldır';
$string['allusers'] = 'Tüm kullanıcılar';
$string['alreadyfirstpost'] = 'Bu mesaj, zaten bu tartışmadaki ilk mesajdır.';
$string['announcementsettings'] = 'Varsayılan duyuru forumu ayarları';
$string['announcementsettings_help'] = 'Bu ayarlar duyuru formları için varsayılan ayarları tanımlar';
$string['anyfile'] = 'Herhangi bir dosya';
$string['areaattachment'] = 'Dosyalar';
$string['areapost'] = 'İletiler';
$string['attachment'] = 'Dosya';
$string['attachment_help'] = 'İsteğe bağlı olarak bir veya daha fazla dosyayı bir forum mesajına ekleyebilirsiniz. Bir görüntü eklerseniz, mesajın ardından görüntülenir.';
$string['attachmentname'] = 'Ek {$a}';
$string['attachmentnameandfilesize'] = '{$a->name} ({$a->size})';
$string['attachmentnopost'] = 'Mesaj id olmadan ekleri dışa çıkaramazsınız';
$string['attachments'] = 'Ekler';
$string['attachmentswordcount'] = 'Ekler ve kelime sayısı';
$string['authorreplyingprivatelytoauthor'] = '{$a-> respondant} {$a-> author} \'a özel olarak yanıt veriyor';
$string['authorreplyingtoauthor'] = '{$a-> yazar}, {$a-> author}';
$string['availability'] = 'Uygunluk';
$string['blockafter'] = 'Engelleme için mesaj sınırı';
$string['blockafter_help'] = 'Bu ayar, bir kullanıcının belirli bir süre içinde gönderebileceği maksimum gönderi sayısını belirtir. Mod / forum: postwithrottling özelliği olan kullanıcılar, gönderi sınırlarından muaftır.';
$string['blockperiod'] = 'Engelleme için süre';
$string['blockperiod_help'] = 'Öğrencilerin belirli bir süre içinde belirli bir sayıdan fazla gönderi göndermeleri engellenebilir. Mod / forum: postwithrottling özelliği olan kullanıcılar, gönderi sınırlarından muaftır.';
$string['blockperioddisabled'] = 'Engelleme yok';
$string['blogforum'] = 'Blog biçiminde görünen standart forum';
$string['bynameondate'] = 'yazan {$a->name} - {$a->date}';
$string['cachedef_forum_count_discussions'] = 'Forum tartışmalarının sayısı';
$string['cachedef_forum_is_tracked'] = 'Kullanıcı için forum izleme durumu';
$string['calendardue'] = '{$a} süresi doluyor';
$string['cancelreply'] = 'Cevabı iptal et';
$string['cannotadd'] = 'Bu forum için tartışma eklenemedi';
$string['cannotadddiscussion'] = 'Bu foruma tartışma ekleme, grup üyeliği gerektirir.';
$string['cannotadddiscussionall'] = 'Tüm katılımcılar için yeni bir tartışma konusu ekleme izniniz yok.';
$string['cannotadddiscussiongroup'] = 'Herhangi bir grubun üyesi olmadığınız için tartışma oluşturamazsınız.';
$string['cannotaddsubscriber'] = '{$a} numaralı üye, bu foruma abone yapılamadı!';
$string['cannotaddteacherforumto'] = 'Kurs içinde bölüm 0\'a dönüştürülmüş öğretmen forumu örneği eklenemedi';
$string['cannotcreatediscussion'] = 'Yeni tartışma oluşturulamadı';
$string['cannotcreateinstanceforteacher'] = 'Öğretmen forumu için yeni kurs modülü örneği oluşturulamadı';
$string['cannotdeletepost'] = 'Bu mesajı silemezsiniz!';
$string['cannoteditposts'] = 'Diğer kişilerin mesajlarını silemezsiniz!';
$string['cannotexportforum'] = 'Bu forumu dışa aktaramazsınız';
$string['cannotfavourite'] = 'Maalesef, tartışmalara yıldız ekleme izniniz yok.';
$string['cannotfinddiscussion'] = 'Bu forumda tartışma bulunamadı';
$string['cannotfindfirstpost'] = 'Bu forumda ilk mesaj bulunamıyor';
$string['cannotfindorcreateforum'] = 'Site için ana duyurular forumu bulamadım veya oluşturamadım';
$string['cannotfindparentpost'] = '{$a} mesajının üst mesajı bulunamadı';
$string['cannotmovefromsingleforum'] = 'Tartışmayı basit bir tek tartışma forumundan alamazsınız';
$string['cannotmovenotvisible'] = 'Forum görünür değil';
$string['cannotmovetonotexist'] = 'Bu foruma taşıyamazsınız - forum yok!';
$string['cannotmovetonotfound'] = 'Bu kursda hedef forum yok.';
$string['cannotmovetosingleforum'] = 'Tartışmayı basit bir tek tartışma forumu ile değiştiremem';
$string['cannotpindiscussions'] = 'Maalesef, tartışmaları sabitleme izniniz yok.';
$string['cannotpurgecachedrss'] = 'Önbellekte bulunan RSS kaynak ve / veya hedef forum (lar) için feed\'leri silinemedi - dosya izinler forumunuzu kontrol edin';
$string['cannotremovesubscriber'] = '{$a} numaralı üyenin bu forumdan aboneliği kaldırılamadı.';
$string['cannotreply'] = 'Bu mesaja yanıt veremezsiniz';
$string['cannotsplit'] = 'Bu forumdaki tartışmalar ayrıştırılamaz';
$string['cannotsubscribe'] = 'Üzgünüz, abone olmak için grup üyesi olmalısınız.';
$string['cannottrack'] = 'Bu forumdaki izleme iptal edilemedi';
$string['cannotunsubscribe'] = 'Bu forumdan aboneliğiniz kaldırılamadı';
$string['cannotupdatepost'] = 'Bu mesajı güncelleyemezsiniz';
$string['cannotuseseperategroupsandsingletopic'] = 'Ayrık gruplar tek bir basit tartışma ile kullanılamaz.';
$string['cannotusesingletopicandseperategroups'] = 'Tek bir basit tartışma ayrık gruplarla kullanılamaz.';
$string['cannotviewpostyet'] = 'Bu tartışmaya henüz mesaj göndermediğinizden diğer öğrencilerin gönderdikleri mesajları okuyamazsınız';
$string['cannotviewusersposts'] = 'Bu kullanıcı tarafından, görüntüleyebildiğiniz herhangi bir mesaj bulunmamaktadır.';
$string['cleanreadtime'] = 'Eski mesajların okunmuş olarak işaretleneceği saat';
$string['clicktofavourite'] = 'Bu tartışmaya yıldız eklemediniz. Yıldız işaretiyle tıklayın.';
$string['clicktolockdiscussion'] = 'Bu tartışmayı kilitlemek için tıklayın';
$string['clicktosubscribe'] = 'Bu tartışmaya abone değilsiniz. Abone olmak için tıklayın.';
$string['clicktounfavourite'] = 'Bu tartışmaya yıldız eklediniz. Yıldızı kaldırmak için tıklayın.';
$string['clicktounlockdiscussion'] = 'Bu tartışmanın kilidini açmak için tıklayın';
$string['clicktounsubscribe'] = 'Bu tartışmaya abone oldunuz. Abonelikten çıkmak için tıklayın.';
$string['close'] = 'Kapat';
$string['closegrader'] = 'Sınıflayıcıyı kapat';
$string['completiondetail:discussions'] = 'Tartışmaları başlatın: {$a}';
$string['completiondetail:posts'] = 'Forum gönderileri yapın: {$a}';
$string['completiondetail:replies'] = 'Yanıt gönder: {$a}';
$string['completiondiscussions'] = 'Tartışma başlat';
$string['completiondiscussionsdesc'] = 'Öğrenciler en az {$a} tartışma oluşturmalı.';
$string['completiondiscussionsgroup'] = 'Tartışma gerekli';
$string['completiondiscussionshelp'] = 'bitirmek için tartışma gerekliliği';
$string['completionposts'] = 'Tartışma başlatın veya cevap gönderin';
$string['completionpostsdesc'] = 'Öğrenciler en az {$a} tartışmaya yanıt göndermelidir.';
$string['completionpostsgroup'] = 'Mesaj gerekli';
$string['completionpostshelp'] = 'bitirmek için tartışma veya mesaj gerekliliği';
$string['completionpostsinforums'] = 'Forumlarda yayınlayın';
$string['completionreplies'] = 'Cevap gönder';
$string['completionrepliesdesc'] = 'Öğrenciler en az {$a} tartışmaya cevap vermelidir.';
$string['completionrepliesgroup'] = 'Yanıt gerekli';
$string['completionreplieshelp'] = 'bitirmek için yanıt gerekliliği';
$string['configcleanreadtime'] = 'Eski mesajların \'okunmuş\' tablosundan silineceği günün saati';
$string['configdigestmailtime'] = 'Günlük özet türünü seçen kullanıcılara günlük olarak özet e-posta gönderilir. Bu ayar, günün hangi saatinde bu e-postaların gönderileceğini belirtir (bir sonraki çalışacak cron bu saatten sonra mesajları gönderir).';
$string['configdisplaymode'] = 'Hiç ayarlanmamışsa tartışmalar için görünüm modu';
$string['configenablerssfeeds'] = 'Bu seçenek tüm forumlar için RSS içeriklerinin etkinleştirilmesine olanak sağlar. Her bir forum için tek tek ayar yapmanız gerekir.';
$string['configenabletimedposts'] = 'Yeni bir forum tartışması gönderirken görüntüleme sürelerinin ayarlanmasına izin vermek isterseniz \'evet\' olarak ayarlayın.';
$string['configlongpost'] = 'Bu uzunluktaki herhangi bir gönderi (HTML içermeyen karakterler) uzun kabul edilir. Sitenin ana sayfasında, sosyal biçimdeki kurs sayfalarında veya kullanıcı profillerinde görüntülenen gönderiler, forum_shortpost ve forum_uzunpost değerleri arasında doğal bir mola olacak şekilde kısaltılır.';
$string['configmanydiscussions'] = 'Bir forumda her bir sayfada görünen en fazla tartışma sayısı';
$string['configmaxattachments'] = 'Her mesaj için izin verilen en fazla dosya sayısı';
$string['configmaxbytes'] = 'Sitedeki forum dosya ekleri için kabul edilecek en fazla dosya yükleme boyutu (kurs sınırlarına ve diğer yerel ayarlara bağımlıdır)';
$string['configoldpostdays'] = 'Herhangi bir mesajın kaç gün eskiyse okunmuş varsayılacağı';
$string['configreplytouser'] = 'Bir forum mesajı gönderildiğinde, alıcıların forum yoluyla değil kişisel olarak yanıtlayabilmesi için kullanıcının e-posta adresini içermesi gerekir mi? \'Evet\' olarak ayarlansa bile, kullanıcılar e-posta adreslerini gizli tutmak için tercihlerini seçebilir.';
$string['configrssarticlesdefault'] = 'RSS yayınları etkinleştirildiyse, varsayılan makale sayısını (tartışmalar veya yayınlar) ayarlar.';
$string['configrsstypedefault'] = 'RSS yayınları etkinleştirilirse, varsayılan etkinlik türünü ayarlar.';
$string['configshortpost'] = 'Bu uzunluğun altındaki herhangi bir yazı (HTML içermeyen karakterler) kısa kabul edilir (aşağıya bakın).';
$string['configsubscriptiontype'] = 'Başvuru modu için varsayılan ayar.';
$string['configtrackingtype'] = 'Okuma izlemesi için varsayılan  ayarlar';
$string['configtrackreadposts'] = 'Herbir kullanıcının okunmuş/okunmamış izlemesi yapmasını istiyorsanız Evet\'i seçin.';
$string['configusermarksread'] = 'Bu tartışmaya yıldız vermediniz. Yıldız vermek için tıklayın.';
$string['confirmsubscribe'] = '\'{$a}\' forumuna abone olmak istiyor musunuz?';
$string['confirmsubscribediscussion'] = '\'{$a->forum}\' forumunda \'{$a->discussion}\' tartışmasına gerçekten abone olmak istiyor musunuz?';
$string['confirmunsubscribe'] = '\'{$a}\' forumu gerçekten aboneliğinizi iptal etmek istiyor musunuz?';
$string['confirmunsubscribediscussion'] = '\'{$a-> forum}\' forumundaki \'{$a->discussion}\' tartışmalarını gerçekten iptal etmek istiyor musunuz?';
$string['couldnotadd'] = 'Bilinmeyen bir nedenle mesajınız eklenemedi';
$string['couldnotdeletereplies'] = 'Birileri bunu yanıtladığı için silinemez';
$string['couldnotupdate'] = 'Bilinmeyen bir nedenle mesajınız güncellenemedi';
$string['created'] = 'Düzenlendi';
$string['crontask'] = 'Forum posta ve bakım işleri';
$string['cutoffdate'] = 'Tamamlanması gereken tarih';
$string['cutoffdate_help'] = 'Ayarlanırsa, forum bu tarihten sonra yayınları kabul etmez.';
$string['cutoffdatereached'] = 'Bu foruma kayıt göndermek için tmamlanması gereken tarih geldiğinde foruma mesaj gönderemezsiniz.';
$string['cutoffdatevalidation'] = 'Tamamlanması gereken tarih son teslim tarihinden önce olamaz.';
$string['delete'] = 'Sil';
$string['deleteddiscussion'] = 'Tartışma konusu silindi';
$string['deletedpost'] = 'Mesaj silindi';
$string['deletedposts'] = 'Mesajlar silindi';
$string['deleteduser'] = 'Silinmiş kullanıcı';
$string['deletesure'] = 'Bu mesajı silmek istediğinizden emin misiniz?';
$string['deletesureplural'] = 'Bu mesajı ve bütün yanıtları silmek istediğinizden emin misiniz? ({$a} mesaj)';
$string['digestmailheader'] = 'Bu, {$a->sitename} forumlarındaki yeni gönderilerin günlük özetidir. Varsayılan forum e-posta tercihlerinizi değiştirmek için {$a->userprefs} adresine gidin.';
$string['digestmailpost'] = 'Forum özet tercihlerinizi değiştirin';
$string['digestmailpostlink'] = 'Forum özet tercihlerinizi değiştirin: {$a}';
$string['digestmailprefs'] = 'kullanıcı profiliniz';
$string['digestmailsubject'] = '{$a}: Forum Özeti';
$string['digestmailtime'] = 'Özet eposta gönderimi için saat';
$string['digestsentusers'] = 'E-posta özetleri başarıyla {$a} kullanıcıya gönderildi.';
$string['disallowsubscribe'] = 'Abonelik izni yok';
$string['disallowsubscribeteacher'] = 'Abonelik izni yok (eğitimciler hariç)';
$string['disallowsubscription'] = 'Abonelik';
$string['disallowsubscription_help'] = 'Bu forum, tartışmalara abone olamayacak şekilde yapılandırılmıştır.';
$string['discussion'] = 'Tartışma';
$string['discussionlistsortbycreatedasc'] = 'Artan tarihe göre oluşturma tarihine göre sırala';
$string['discussionlistsortbycreateddesc'] = 'Oluşturma tarihine göre azalan düzende sırala';
$string['discussionlistsortbydiscussionasc'] = 'Tartışma adına göre artan sırada sırala';
$string['discussionlistsortbydiscussiondesc'] = 'Tartışma adına göre azalan sırada sırala';
$string['discussionlistsortbygroupasc'] = 'Artan düzende gruba göre sırala';
$string['discussionlistsortbygroupdesc'] = 'Gruba göre azalan düzende sırala';
$string['discussionlistsortbylastpostasc'] = 'Son yazı oluşturma tarihine göre artan düzende sırala';
$string['discussionlistsortbylastpostdesc'] = 'Son gönderi oluşturma tarihine göre azalan düzende sırala';
$string['discussionlistsortbyrepliesasc'] = 'Artan sırada verilen cevap sayısına göre sırala';
$string['discussionlistsortbyrepliesdesc'] = 'Cevap sayısına göre azalan düzende sırala';
$string['discussionlistsortbystarterasc'] = 'Artan düzende tartışma başlatıcı adına göre sırala';
$string['discussionlistsortbystarterdesc'] = 'Azalan düzende tartışma başlatıcı adına göre sırala';
$string['discussionlocked'] = 'Bu tartışma kilitli olduğundan artık yanıtlayamıyorsunuz.';
$string['discussionlockingdisabled'] = 'Tartışmaları kilitleme';
$string['discussionlockingheader'] = 'Tartışma kilitleme';
$string['discussionmoved'] = 'Bu tartışma buraya taşındı: \'{$a}\'';
$string['discussionmovedpost'] = '<a href="{$a->forumhref}">{$a->forumname}</a> forumundaki bu konu <a href="{$a->discusshref}">buraya</a> taşındı';
$string['discussionname'] = 'Tartışma adı';
$string['discussionnownotsubscribed'] = '{$a->name}, \'{$a->forum}\' un \'{$a-> discussion}\' bölümündeki yeni mesajlardan haberdar değil';
$string['discussionnowsubscribed'] = '\'{$a->forum}\' forumundaki \'{$a->discussion}\' bölümündeki yeni gönderilerden haberdar edileceksiniz.';
$string['discussionpin'] = 'Sabitle';
$string['discussionpinned'] = 'Sabitlenmiş';
$string['discussionpinned_help'] = 'Sabitlenmiş tartışmalar bir forumun başında görünecek.';
$string['discussions'] = 'Tartışmalar';
$string['discussionsplit'] = 'Tartışma bölündü';
$string['discussionsstartedby'] = '{$a} tarafından başlatılan tartışmalar';
$string['discussionsstartedbyrecent'] = '{$a} tarafından yakında başlatılan tartışmalar';
$string['discussionsstartedbyuserincourse'] = '{$a->coursename} adresinde {$a->fullname} tarafından başlatılan tartışmalar';
$string['discussionsstartedincourse'] = '{$a} tarihinde başlayan tartışmalar';
$string['discussionstartedby'] = 'Tartışma {$a} tarafından başlatıldı';
$string['discussionsubscribed'] = 'Artık bu tartışmaya abone oldunuz.';
$string['discussionsubscribestart'] = 'Bu tartışma formundaki yeni postalar ile ilgili ileti almak istiyorum';
$string['discussionsubscribestop'] = 'Bu tartışma formundaki yeni postalar ile ilgili uyarı almak istemiyorum';
$string['discussionsubscription'] = 'Tartışma aboneliği';
$string['discussionsubscription_help'] = 'Tartışmaya abone olduğunuzda, bu tartışmaya yeni mesajların bildirileceği anlamına gelir.';
$string['discussionunpin'] = 'Sabitlemeyi iptal et';
$string['discussionunsubscribed'] = 'Artık bu tartışmanın aboneliğinden çıkmış durumdasınız.';
$string['discussthistopic'] = 'Bu konuyu tartış';
$string['discusstopicname'] = 'Konuyu tartışın: {$a}';
$string['displayend'] = 'Görünüm bitişi';
$string['displayend_help'] = 'Bu ayar, bir forum yazısının belirli bir tarihten sonra gizlenip gizlenemeyeceğini belirtir. Yöneticilerin forum yazılarını her zaman görebileceklerini unutmayın.';
$string['displayenddate'] = 'Ekran sonu: {$a}.';
$string['displaymode'] = 'Görünüm modu';
$string['displayperiod'] = 'Görüntüleme süresi';
$string['displaystart'] = 'Görünüm başlangıcı';
$string['displaystart_help'] = 'Bu ayar, bir forum yazısının belirli bir tarihten itibaren görüntülenip görüntülenmeyeceğini belirtir. Yöneticilerin forum yazılarını her zaman görebileceklerini unutmayın.';
$string['displaystartdate'] = 'Ekran başlangıcı: {$a}.';
$string['displaywordcount'] = 'Kelime sayısı göster';
$string['displaywordcount_help'] = 'Bu ayar, her yayının kelime sayısının görüntülenip görüntülenmeyeceğini belirtir.';
$string['duedate'] = 'Son teslim tarihi';
$string['duedate_help'] = 'Bu, foruma mesaj göndermenin zamanıdır. Bu tarih, takvimde forum için son tarih olarak gösterilse de, bu tarihten sonra yayınlamaya yine de izin verilecektir. Belirli bir tarihten sonra foruma mesaj göndermeyi önlemek için forumuntamamlanması gereken tarihi belirleyin.';
$string['duedatetodisplayincalendar'] = 'Takvimde gösterilecek son tarih';
$string['eachuserforum'] = 'Herkes tek mesaj gönderebilir';
$string['edit'] = 'Düzelt';
$string['editdiscussion'] = 'Tartışmayı düzenle';
$string['editdiscussiontopic'] = 'Tartışma başlıklarını düzenle';
$string['editedby'] = 'Düzenleyen: {$a->name} - ilk gönderim: {$a->date}';
$string['editedpostupdated'] = '{$a} adlı kişinin sonrası güncellendi';
$string['editing'] = 'Düzenleniyor';
$string['emaildigestcompleteshort'] = 'Yazıları tamamla';
$string['emaildigestdefault'] = 'Varsayılan({$a})';
$string['emaildigestoffshort'] = 'Özet yok';
$string['emaildigestsubjectsshort'] = 'Sadece konular';
$string['emaildigesttype'] = 'E-posta özet seçenekleri';
$string['emaildigesttype_help'] = 'Her bir forum için alacağınız bildirim türü.

* Varsayılan - kullanıcı profilinizde bulunan özet akış ayarını izleyin. Profilinizi güncellerseniz, o değişiklik de burada yansıtılacaktır;
* Sindirim yok - forum başlığı başına bir e-posta alacaksınız;
* Digest - eksiksiz mesajlar - her forum mesajının içeriğini içeren bir günlük e-posta alacaksınız;
* Digest - yalnızca konular - günlük olarak her forum mesajının konusunu içeren bir özet e-posta alacaksınız.';
$string['emptymessage'] = 'Gönderinizde bir sorun vardı. Belki boş bıraktınız veya ek çok büyüktü. Değişiklikleriniz KAYDEDİLMEDİ.';
$string['errorcannotlock'] = 'Tartışmaları kilitleme izniniz yok.';
$string['errordiscussionnotfound'] = 'Tartışma bulunamadı';
$string['erroremptymessage'] = 'Yazı mesajı boş olamaz';
$string['erroremptysubject'] = 'Gönderi konusu boş olamaz.';
$string['errorenrolmentrequired'] = 'Bu içeriğe erişmek için bu kursa kayıtlı olmanız gerekiyor';
$string['errorforumnotfound'] = 'Bu tartışmanın ait olduğu forum bulunamadı';
$string['errorwhiledelete'] = 'Kaydı silerken bir hata oluştu.';
$string['eventassessableuploaded'] = 'Bazı içerikler yayınlandı.';
$string['eventcoursesearched'] = 'Kurs arandı';
$string['eventdiscussioncreated'] = 'Tartışma oluşturuldu';
$string['eventdiscussiondeleted'] = 'Tartışma silindi';
$string['eventdiscussionlockupdated'] = '';
$string['eventdiscussionmoved'] = 'Tartışma taşındı';
$string['eventdiscussionpinned'] = 'Tartışma sabitlendi';
$string['eventdiscussionsubscriptioncreated'] = 'Tartışma aboneliği oluşturuldu';
$string['eventdiscussionsubscriptiondeleted'] = 'Tartışma aboneliği silindi';
$string['eventdiscussionunpinned'] = 'Tartışmanın sabitlenmesi iptal edildi';
$string['eventdiscussionupdated'] = 'Tartışma güncellendi';
$string['eventdiscussionviewed'] = 'Görüntülenen tartışma';
$string['eventforumsubscriptionupdated'] = 'Abonelik modu güncellendi';
$string['eventpostcreated'] = 'Yayın oluşturuldu';
$string['eventpostdeleted'] = 'Yazı silindi';
$string['eventpostupdated'] = 'Güncellenmiş yazı';
$string['eventreadtrackingdisabled'] = 'Oku izlemesi devre dışı';
$string['eventreadtrackingenabled'] = 'Oku izlemesi etkinleştirildi';
$string['eventsubscribersviewed'] = 'Görüntülenen aboneler';
$string['eventsubscriptioncreated'] = 'Abonelik yaratıldı';
$string['eventsubscriptiondeleted'] = 'Abonelik silindi';
$string['eventuserreportviewed'] = 'Görüntülenen kullanıcı raporu';
$string['everyonecanchoose'] = 'Herkes abone olabilir';
$string['everyonecannowchoose'] = 'Herkes şimdi abone olabilir';
$string['everyoneisnowsubscribed'] = 'Herkes şimdi bu foruma abone oldu';
$string['everyoneissubscribed'] = 'Bu foruma herkes abone oldu';
$string['existingsubscribers'] = 'Kayıtlı aboneler';
$string['export'] = 'Dışa aktar';
$string['exportattachmentname'] = '{$a} ekini portföye aktar';
$string['exportdiscussion'] = 'Tartışmayı portföye aktar';
$string['exporthumandates'] = 'İnsan tarafından okunabilir tarihler';
$string['exporthumandates_help'] = 'Tarihlerin insan tarafından okunabilir bir biçimde mi yoksa zaman damgası olarak mı (sayı dizisi) dışa aktarılması gerektiği.';
$string['exportoptions'] = 'Dışa aktarma seçenekleri';
$string['exportstriphtml'] = 'HTML\'yi kaldır';
$string['exportstriphtml_help'] = 'P ve br gibi HTML etiketlerinin forum gönderisi mesajından kaldırılıp kaldırılmayacağı.';
$string['favourites'] = 'Yıldızlı';
$string['favouriteupdated'] = 'Yıldızlı seçeneğiniz güncellendi.';
$string['firstpost'] = 'İlk gönderi';
$string['forcedreadtracking'] = 'Zorla okundu izlemeye izin ver';
$string['forcedreadtracking_desc'] = 'Forumların zorla okundu izlemesine ayarlanmasına izin verir. Bazı kullanıcılar için, özellikle birçok foruma ve yayına sahip kurslarda, performans düşüşüyle sonuçlanacaktır. Kapatıldığında, daha önce Zorunlu olarak ayarlanan forumlar isteğe bağlı olarak değerlendirilir.';
$string['forcesubscribed'] = 'Bu forum herkesin abone olmasını zorunlu kılar';
$string['forcesubscribed_help'] = 'Bu forum, tartışmalara aboneliğinizi iptal edemeyecek şekilde yapılandırılmıştır.';
$string['forum'] = 'Forum';
$string['forum:addinstance'] = 'Yeni forum ekle';
$string['forum:addnews'] = 'Duyuru ekleyin';
$string['forum:addquestion'] = 'Soru ekle';
$string['forum:allowforcesubscribe'] = 'Abone olmaya zorlamaya izin ver';
$string['forum:canmailnow'] = 'Soru ve Cevap forumuna düzenleme süresi gecikmesi olmadan gönderi yapabilir';
$string['forum:canoverridecutoff'] = 'Tamamlanması gereken tarihden sonra  forumlarda yayınlayın';
$string['forum:canoverridediscussionlock'] = 'Kilitli tartışmalara cevap ver';
$string['forum:canposttomygroups'] = 'Erişiminiz olan tüm gruplara yayınlayın';
$string['forum:cantogglefavourite'] = 'Yıldız tartışmaları';
$string['forum:createattachment'] = 'Dosya iliştir';
$string['forum:deleteanypost'] = 'Mesajları sil (her zaman)';
$string['forum:deleteownpost'] = 'Mesajları sil (son süreye kadar)';
$string['forum:editanypost'] = 'Bütün mesajları düzenle';
$string['forum:exportdiscussion'] = 'Tüm tartışmayı dışa ver';
$string['forum:exportforum'] = 'Forumu dışa aktar';
$string['forum:exportownpost'] = 'Kendi mesajını dışa ver';
$string['forum:exportpost'] = 'Mesajı dışa ver';
$string['forum:grade'] = 'Not forumu';
$string['forum:managesubscriptions'] = 'Aboneleri yönetin';
$string['forum:movediscussions'] = 'Tartışmaları taşı';
$string['forum:pindiscussions'] = 'Tartışmaları sabitle';
$string['forum:postprivatereply'] = 'Yayınları özel olarak yanıtlayın';
$string['forum:postwithoutthrottling'] = 'Posta eşiğinden muaf';
$string['forum:rate'] = 'Mesajları Değerlendir';
$string['forum:readprivatereplies'] = 'Özel yanıtları görüntüleyin';
$string['forum:replynews'] = 'Duyuruları yanıtlayın
Haberlere cevap yaz';
$string['forum:replypost'] = 'Mesajlara cevap yaz';
$string['forum:splitdiscussions'] = 'Tartışmaları ayır';
$string['forum:startdiscussion'] = 'Yeni tartışma başlat';
$string['forum:viewallratings'] = 'Bireylerin verdiği tüm ham notları görüntüle';
$string['forum:viewanyrating'] = 'Herkesin aldığı toplam oyları görüntüle';
$string['forum:viewdiscussion'] = 'Tartışmalara bak';
$string['forum:viewhiddentimedposts'] = 'Süresi dolmuş mesajlara bak';
$string['forum:viewqandawithoutposting'] = 'Soru ve Cevap gönderilerini her zaman görün';
$string['forum:viewrating'] = 'Aldığınız toplam oyu görüntüleyin';
$string['forum:viewsubscribers'] = 'Abonelere bak';
$string['forumauthorhidden'] = 'Yazan (gizli)';
$string['forumblockingalmosttoomanyposts'] = 'Mesaj gönderme sınırına yaklaşıyorsunuz. Son {$a->blockperiod} sürede {$a->numposts} kez mesaj gönderdiniz ve sınır {$a->blockafter} mesajdır.';
$string['forumbodydeleted'] = 'Bu forum gönderisinin içeriği kaldırıldı ve artık erişilemez.';
$string['forumbodyhidden'] = 'Bu gönderi şu anda gizli, büyük ihtimalle önce tartışmaya katılmanız ve forum gönderi bildirimlerinin gönderilmesi gerektiğindendir. Bir başka ihtimal de geçerli saatin gönderi için ayarlanan görüntüleme süresi içinde olmamasıdır.';
$string['forumgrader'] = 'Forumu değerlendirenler';
$string['forumgradingnavigation'] = 'Forum puanlama gezintisi';
$string['forumgradingpanel'] = 'Forum puanlama paneli';
$string['forumintro'] = 'Açıklama
';
$string['forumname'] = 'Forum adı';
$string['forumposts'] = 'Forum mesajları';
$string['forums'] = 'Forumlar';
$string['forumsubjectdeleted'] = 'Bu forum gönderisi kaldırıldı';
$string['forumsubjecthidden'] = 'Konu (gizli)';
$string['forumtracked'] = 'İzlenen okunmamış mesajlar';
$string['forumtrackednot'] = 'İzlenmeyen okunmamış mesajlar';
$string['forumtype'] = 'Forum türü';
$string['forumtype_help'] = '5 forum türü vardır:

* Tek bir basit tartışma - Herkesin cevap verebileceği tek bir tartışma konusu (ayrı gruplarla kullanılamaz)
* Herkes bir tartışma konusu gönderebilir - Her öğrenci herkesin cevap verebileceği tam olarak bir yeni tartışma konusu gönderebilir
* Soru ve Cevap forumu - Bir öğrenci, diğer öğrencilerin gönderilerini görüntülemeden önce öğretmen tarafından gönderilen bir soruya cevap göndermelidir
* Blog tarzı bir formatta görüntülenen standart forum - Herkesin istediği zaman yeni bir tartışma açabildiği ve tartışma konularının "Bu konuyu tartışın" bağlantılarıyla tek bir sayfada görüntülendiği açık bir forum
* Genel kullanım için standart forum - Herkesin istediği zaman yeni bir tartışma başlatabileceği açık bir forum';
$string['generalforum'] = 'Genel kullanım için standart forum';
$string['generalforums'] = 'Genel forumlar';
$string['grade_forum_header'] = 'Tüm forum puanları';
$string['grade_forum_name'] = 'Tüm forum';
$string['grade_forum_title'] = 'Not';
$string['grade_rating_name'] = 'Değerlendirme';
$string['graded'] = 'Not verildi';
$string['gradedby'] = 'Not veren';
$string['gradeforrating'] = 'Puanlama notu: {$a->str_long_grade}';
$string['gradeforratinghidden'] = 'Gizli puanlama notu';
$string['gradeforwholeforum'] = 'Forum için not: {$a->str_long_grade}';
$string['gradeforwholeforumhidden'] = 'Gizli forum notu';
$string['gradeitem:forum'] = 'Forum';
$string['gradeitemnameforrating'] = '{$a->name} değerlendirmesi';
$string['gradeitemnameforwholeforum'] = 'tüm forum {$a->name}';
$string['grades:gradesavedfor'] = '{$a->fullname} için not kaydedildi';
$string['grades:gradesavefailed'] = '{$a->fullname} için not kaydedilemedi: {$a->error}';
$string['gradeusers'] = 'Kullanıcı Notları';
$string['grading'] = 'Not verme';
$string['gradingstatus'] = 'Not durumu:';
$string['hiddenforumpost'] = 'Gizli forum yazısı';
$string['hidegraderpanel'] = 'Not veren panelini gizle';
$string['hidepreviousrepliescount'] = 'Önceki yanıtları gizle ({$a})';
$string['hideusersearch'] = 'Kullanıcı aramasını gizle';
$string['indexoutoftotal'] = '{$a->total} üzerinden {$a->index}';
$string['indicator:cognitivedepth'] = 'Forum bilişseli';
$string['indicator:cognitivedepth_help'] = 'Bu gösterge, bir Forum etkinliğinde öğrenci tarafından ulaşılan bilişsel derinliğe dayanmaktadır.';
$string['indicator:cognitivedepthdef'] = 'Forum bilişseli';
$string['indicator:cognitivedepthdef_help'] = 'Katılımcı, bu analiz aralığı sırasında Forum etkinlikleri tarafından sunulan bilişsel katılımın bu yüzdesine ulaştı (Seviyeler = Görüntüleme Yok, Görüntüle, Gönder, Geri Bildirimi Görüntüle, Geri Bildirime Yorum Yap, Geri Bildirimi Görüntüledikten Sonra Yeniden Gönder)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Forum sosyal';
$string['indicator:socialbreadth_help'] = 'Bu gösterge, bir Forum etkinliğinde öğrencinin ulaştığı sosyal genişliğe dayanmaktadır.';
$string['indicator:socialbreadthdef'] = 'Forum sosyali';
$string['indicator:socialbreadthdef_help'] = 'Katılımcı, bu analiz aralığı boyunca Forum faaliyetleri tarafından sunulan sosyal katılımın bu yüzdesine ulaştı (Düzeyler = Katılım yok, Yalnızca katılımcı, Diğerleriyle birlikte katılımcı)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['inforum'] = '{$a}\'de';
$string['inreplyto'] = '{$a} yanıt olarak';
$string['introblog'] = 'Bu forumdaki yayınlar, otomatik olarak bu kursda kullanıcıların bloglarından kopyalanmıştı çünkü bu blog girişleri artık mevcut değil';
$string['intronews'] = 'Genel haberler ve duyurular';
$string['introsocial'] = 'İstediğiniz herhangi bir konuda tartışabileceğiniz açık forum';
$string['introteacher'] = 'Öğretmenlere özel notlar ve tartışmalar için forum';
$string['invalidaccess'] = 'Bu sayfaya düzgün bir şekilde erişmediniz';
$string['invaliddigestsetting'] = 'Geçersiz bir e-posta özeti ayarı sağlandı';
$string['invaliddiscussionid'] = 'Tartışma ID hatalı yada artık yok.';
$string['invalidforcesubscribe'] = 'Katılmaya geçersiz zorlama';
$string['invalidforumid'] = 'Forum ID hatalı';
$string['invalidparentpostid'] = 'Üst mesaj ID geçersiz';
$string['invalidpostid'] = 'Hatalı gönderi ID - {$a}';
$string['lastpost'] = 'Son mesaj';
$string['learningforums'] = 'Öğrenme forumları';
$string['lockdiscussion'] = 'Bu tartışmayı kilitle';
$string['lockdiscussionafter'] = 'Hareketsizlik döneminin ardından tartışmaları kilitleyin';
$string['lockdiscussionafter_help'] = 'Tartışmalar son cevaptan bu yana belirli bir süre geçtikten sonra otomatik olarak kilitlenebilir.

Kilitli tartışmalara cevap verme özelliğine sahip kullanıcılar, bir tartışmayı cevaplayarak kilidini açabilir.';
$string['locked'] = 'Kilitli';
$string['lockupdated'] = 'Kilitleme seçeneği güncellendi.';
$string['longpost'] = 'Uzun mesaj';
$string['mailnow'] = 'Düzenleme süresi gecikmesi olmadan forum yayını bildirimleri gönderin';
$string['managesubscriptionsoff'] = 'Başvuruları yönetmeyi tamamla.';
$string['managesubscriptionson'] = 'Aboneleri yönetin';
$string['manydiscussions'] = 'Her sayfadaki tartışmalar';
$string['markalldread'] = 'Bu tartışmadaki bütün mesajları okundu olarak işaretle.';
$string['markallread'] = 'Bu forumdaki bütün mesajları okundu olarak işaretle.';
$string['markasread'] = 'Okundu olarak işaretle';
$string['markasreadonnotification'] = 'Forum postayla bildirim gönderirken';
$string['markasreadonnotification_help'] = 'Bir forum mesajından haberdar edildiğinizde, bunun forum izlemesi amacıyla okundu olarak işaretlenip işaretlenmemesini seçebilirsiniz.';
$string['markasreadonnotificationno'] = 'Yayını okundu olarak işaretleme';
$string['markasreadonnotificationyes'] = 'Postayı okundu olarak işaretle';
$string['markread'] = 'Okundu olarak işaretle';
$string['markreadbutton'] = 'Okundu olarak<br />işaretle';
$string['markunread'] = 'Okunmadı olarak işaretle';
$string['markunreadbutton'] = 'Okunmadı olarak<br />işaretle';
$string['maxattachments'] = 'En fazla ek sayısı';
$string['maxattachments_help'] = 'Bu ayar, bir forum mesajına eklenebilecek maksimum dosya sayısını belirtir.';
$string['maxattachmentsize'] = 'Dosya yükleme sınırı';
$string['maxattachmentsize_help'] = '<p>Kullanıcılar tarafından foruma iliştirilen dosyaların
   boyutu sınırlandırılabilir.</p>

<p>Bazen bu boyuttan daha büyük dosya göndermek mümkündür, ancak,
   dosya kaydedilmez ve kullanıcıya bir hata gösterilir.</p>';
$string['maxtimehaspassed'] = '({$a}) için düzeltme süresi doldu!';
$string['message'] = 'Mesaj';
$string['messageinboundattachmentdisallowed'] = 'Yanıtınız bir ek içeriyor ve forum eklere izin vermediğinden gönderilemiyor.';
$string['messageinboundfilecountexceeded'] = 'Forumunuza izin verilen en fazla eklentiyi ({$a->forum->maxattachments}) aştığından, yanıtınızı gönderemiyoruz.';
$string['messageinboundfilesizeexceeded'] = 'Toplam ek boyutu ({$a->filesize}), forum için izin verilen maksimum boyuttan ({$a->maxbytes}) büyük olduğundan yanıtınızı gönderemiyoruz.';
$string['messageinboundforumhidden'] = 'Şu anda forum kullanılamadığından, yanıtınızı gönderemiyoruz.';
$string['messageinboundnopostforum'] = '{$a->forum->name} forumuna yazı gönderme izniniz olmadığından, cevabınızı gönderemiyoruz.';
$string['messageinboundthresholdhit'] = 'Cevabınızı gönderemiyoruz. Bu forum için ayarlanan gönderim eşiğini aştınız';
$string['messageprovider:digests'] = 'Abone olunan forum özetleri';
$string['messageprovider:posts'] = 'Abone olunan forum mesajları';
$string['missingsearchterms'] = 'Aşağıdaki arama terimleri yalnızca bu mesajın HTML biçimlendirmesinde görülür:';
$string['modeflatnewestfirst'] = 'Yanıtları yeniler önce olacak şekilde düz göster';
$string['modeflatoldestfirst'] = 'Yanıtları eskiler önce olacak şekilde düz göster';
$string['modenested'] = 'Yanıtları içiçe göster';
$string['modenestedv2'] = 'Yanıtları deneysel olarak iç içe geçmiş biçimde görüntüle';
$string['modethreaded'] = 'Yanıtları tek tek göster';
$string['modulename'] = 'Forum';
$string['modulename_help'] = 'Forum etkinliği modülü, katılımcıların eşansız tartışmalara, diğer bir değişle uzun bir zaman aralığında gerçekleşen tartışmalar yapmalarını sağlar.

Aralarından seçim yapabileceğiniz çeşitli forum türleri var, örneğin herhangi bir zamanda herkesin yeni bir tartışma başlatabileceği standart bir forum; Her öğrencinin tam olarak bir tartışma gönderebileceği bir forum; Ya da öğrencilerin diğer öğrencilerin yazılarını görebilmeleri için önce göndermeleri gereken bir soru-cevap forumu. Bir öğretmen, dosyaların forum yazılarına eklenmesine izin verebilir. Ekli resimler forum mesajında görüntülenir.

Katılımcılar, yeni forum gönderilerinin bildirimlerini almak için bir foruma abone olabilir. Bir öğretmen, abonelik modunu isteğe bağlı, zorunlu veya otomatik olarak ayarlayabilir veya aboneliği tamamen engelleyebilir. Gerekli görüldüğünde, öğrencilerin belirli bir süre içinde belirli sayıda ileti göndermesine izin verilmeyebilir; Bu bireylerin tartışmalara yön vermesini önleyebilir.

Forum mesajları öğretmenler veya öğrenciler tarafından puanlanabilir (akran değerlendirmesi). Puanlamalar, not defterinde kaydedilen nihai bir not oluşturmak üzere bir araya getirilebilir.

Forumların birçok kullanımı vardır örnegin

 * Öğrencilerin birbirlerini tanıması için bir sosyal ortam
 * Kurs duyuruları için (zorunlu abone olan bir haber forumu kullanarak)
 * Kurs içeriğini tartışmak veya okumak için
 * Yüz yüze oturumda daha önce gündeme getirilen bir sorunu çevrimiçi olarak sürdürmek için
 * Öğretmenle yapılan tartışmalar için (gizli bir forum kullanarak)
 * Öğretmenlerin ve öğrencilerin danışabileceği bir yardım merkezi
 * Özel öğrenci-öğretmen iletişiminde birebir destek alanı (ayrı gruplar içeren ve grup başına bir öğrenci içeren bir forum kullanarak)
 * Kapsamlı etkinlikler için, örneğin öğrencilerin üzerinde düşünmeleri ve çözüm önerileri getirmeleri için \'akıl oyunları\'';
$string['modulename_link'] = 'mod/forum/view';
$string['modulenameplural'] = 'Forumlar';
$string['more'] = 'devamı';
$string['movedmarker'] = '(Taşındı)';
$string['movethisdiscussionlabel'] = 'Mevcut tartışmayı belirtilen foruma taşıyın';
$string['movethisdiscussionto'] = 'Bu tartışmayı taşı...';
$string['mustprovidediscussionorpost'] = 'Dışa aktarmak için bir tartışma kimliği veya posta kimliği sağlamalısınız.';
$string['myprofileotherdis'] = 'Forum tartışmaları';
$string['myprofileowndis'] = 'Forum tartışmalarım';
$string['myprofileownpost'] = 'Forum yazılarım';
$string['namenews'] = 'Duyurular';
$string['namenews_help'] = 'Kurs anonsları forumu duyurular için özel bir forumdur ve bir kursun oluşturulduğu zaman otomatik olarak oluşturulur. Bir kursun yalnızca bir anons forumu olabilir. Sadece öğretmenler ve yöneticiler duyurular gönderebilir. "Son duyurular" bloğu son duyuruları görüntüleyecektir.';
$string['namesocial'] = 'Sosyal forum';
$string['nameteacher'] = 'Öğretmen forumu';
$string['newforumposts'] = 'Yeni forum mesajı';
$string['nextdiscussiona'] = 'Sonraki tartışma: {$a}';
$string['nextuser'] = 'Değişiklikleri kaydedin ve sonraki kullanıcıya ilerleyin';
$string['noattachments'] = 'Bu mesajda ek dosya yok';
$string['nodiscussions'] = 'Bu forumda bir tartışma konusu henüz yoktur';
$string['nodiscussionsstartedby'] = '{$a} kullanıcısı tarafından herhangi bir tartışma başlatılmamış';
$string['nodiscussionsstartedbyyou'] = 'Henüz hiç tartışma başlatmamışsınız';
$string['noguestpost'] = 'Sadece oturum açmış kullanıcılar bu foruma mesaj gönderebilir.';
$string['noguestpost:title'] = 'Devam etmek için giriş yapın';
$string['noguestsubscribe'] = 'Üzgünüz, misafirlerin abone olmalarına izin verilmiyor.';
$string['noguesttracking'] = 'Üzgünüz, konuk kullanıcılar izleme ayarlarını yapamazlar.';
$string['nomorepostscontaining'] = 'İçinde \'{$a}\' olan başka mesaj bulunamadı';
$string['nonews'] = 'Henüz hiçbir duyuru gönderilmemiş.';
$string['noonecansubscribenow'] = 'Abonelikler artık kabul edilmiyor';
$string['nopermissiontosubscribe'] = 'Forum abonelerine bakma izniniz yoktur.';
$string['nopermissiontoview'] = 'Bu mesaja bakmak için gerekli izniniz yok';
$string['nopostforum'] = 'Üzgünüz, bu foruma mesaj gönderme izniniz yok';
$string['noposts'] = 'Mesaj yok';
$string['nopostsmadebyuser'] = '{$a} hiç yazı yayınlamadı';
$string['nopostsmadebyyou'] = 'Hiç gönderiniz yok';
$string['noquestions'] = 'Bu forumda henüz soru yok';
$string['nosubscribers'] = 'Bu forumun henüz abonesi yoktur';
$string['notexists'] = 'Tartışma artık yok';
$string['notgraded'] = 'Puanlanmamış';
$string['nothingnew'] = '{$a} için yeni bir şey yok';
$string['notingroup'] = 'Üzgünüz, bu forumu görebilmeniz için bir grubun üyesi olmalısınız.';
$string['notinstalled'] = 'Forum eklentisi kurulmamış';
$string['notlocked'] = 'Kilit';
$string['notpartofdiscussion'] = 'Bu mesaj bir tartışmanın parçası değil';
$string['notrackforum'] = 'Okunmamış yayınları izleme';
$string['notsubscribed'] = 'Abone ol';
$string['nousersmatch'] = 'Verilen kriterler için kullanıcı bulunamadı';
$string['noviewdiscussionspermission'] = 'Bu forumdaki tartışmaları görmek için yetkiniz yok';
$string['nowallsubscribed'] = 'Artık {$a} içindeki tüm forumlara abone oldunuz.';
$string['nowallunsubscribed'] = 'Artık {$a} içindeki tüm forumların aboneliğinden çıkmış durumdasınız.';
$string['nowgradinguser'] = 'Şimdi {$a} puan veriyor';
$string['nownotsubscribed'] = '{$a->name}, \'{$a->forum}\' içindeki yeni mesajlardan BİLDİRİLMEYECEKTİR';
$string['nownottracking'] = '{$a->name}, artık bu forumu izlemiyor: \'{$a->forum}\'';
$string['nowsubscribed'] = '\'{$a->forum}\' forumundaki yeni gönderilerden haberdar edileceksiniz.';
$string['nowtracking'] = '{$a->name}, şu anda bu forumu izliyor: \'{$a->forum}\'';
$string['numberofreplies'] = 'Yanıt sayısı: {$a}';
$string['numposts'] = '{$a} mesaj';
$string['olderdiscussions'] = 'Daha eski tartışmalar';
$string['oldertopics'] = 'Daha eski konular';
$string['oldpostdays'] = 'Gün sonra okunmuş say';
$string['page-mod-forum-discuss'] = 'Forum modülü tartışma dizgesi sayfası';
$string['page-mod-forum-view'] = 'Forum modülü ana sayfası';
$string['page-mod-forum-x'] = 'Herhangi bir forum modülü sayfası';
$string['parent'] = 'Üstünü göster';
$string['parentofthispost'] = 'Bu mesajın üstü';
$string['permalink'] = 'Kalıcı bağlantı';
$string['permanentlinktoparentpost'] = 'Bu yazının üst kısmına kalıcı bağlantı';
$string['permanentlinktopost'] = 'Bu gönderiye kalıcı bağlantı';
$string['pindiscussion'] = 'Bu tartışmayı sabitle';
$string['pinupdated'] = 'Sabitleme seçeneği güncellendi.';
$string['pluginadministration'] = 'Forum yönetimi';
$string['pluginname'] = 'Forum';
$string['postadded'] = '<p> Gönderiniz başarıyla eklendi. </p> <p> Değişiklik yapmak istiyorsanız onu düzenlemek için {$a} var. </p>';
$string['postaddedsuccess'] = 'Mesajınız başarıyla eklendi.';
$string['postaddedtimeleft'] = 'Herhangi bir değişiklik yapmanız için {$a} süreniz var.';
$string['postbymailsuccess'] = 'Yanıtınız "{$a->subject}" başarıyla gönderildi: {$a->discussionurl}';
$string['postbymailsuccess_html'] = '<a href="{$a->discussionurl} "> {$a->subject} </a> yanıtınız başarıyla gönderildi.';
$string['postbyuser'] = '{$a->user} dan {$a->post}';
$string['postincontext'] = 'Bu mesajı konu içinde göster';
$string['postisprivatereply'] = 'Bu gizli bir cevaptır. Yalnızca siz ve öğretmenler veya yöneticiler gibi gizli cevapları görüntüleme yeteneğine sahip herkes tarafından görülebilir.';
$string['postmailinfo'] = 'Bu metin {$a} websitesine gönderilmiş mesajın bir kopyasıdır.';
$string['postmailnow'] = '<p>Bu mesaj bütün forum abonelerine e-posta olarak gönderildi.</p>';
$string['postmailreply'] = 'Cevap vermek için şu bağlantıya tıklayın: {$a}';
$string['postmailsubject'] = '{$a->courseshortname}: {$a->subject}';
$string['posts'] = 'Mesajlar';
$string['postsfrom'] = 'Başlama tarihi';
$string['postsmadebyuser'] = '{$a} tarafından yapılan gönderiler';
$string['postsmadebyuserincourse'] = 'Tarafından oluşturulan gönderiler {$a->fullname} de {$a->coursename}';
$string['postsmadeincourse'] = '{$a} içinde oluşturulan gönderiler';
$string['poststo'] = 'Bitiş tarihi';
$string['posttoforum'] = 'Foruma gönder';
$string['posttomygroups'] = 'Tüm gruplara bir kopyasını gönder';
$string['posttomygroups_help'] = 'Bu mesajın bir kopyasını erişebileceğiniz tüm gruplara gönderir. Erişmediğiniz gruplara katılanlar bu postayı göremeyecekler';
$string['postupdated'] = 'Mesajınız güncellendi';
$string['potentialsubscribers'] = 'Olası aboneler';
$string['prevdiscussiona'] = 'Önceki tartışma: {$a}';
$string['previoususer'] = 'Değişiklikleri kaydedin ve önceki kullanıcıya ilerleyin';
$string['privacy:digesttypenone'] = 'Bu forum için tercih edilen forum özeti türüyle ilgili herhangi bir veri tutmuyoruz.';
$string['privacy:digesttypepreference'] = 'Aşağıdaki forum özet türünü almayı seçtiniz: "{$a->type}".';
$string['privacy:discussionsubscriptionpreference'] = 'Bu forum için şu tartışma abonelik tercihini seçtiniz: "{$a->preference}"';
$string['privacy:metadata:core_rating'] = 'Forum, gönderilerin oylanmasını desteklemek için oylama alt sistemini kullanır.';
$string['privacy:metadata:core_tag'] = 'Forum, gönderilerin etiketlenmesini desteklemek için etiket alt sistemini kullanır.';
$string['privacy:metadata:forum_digests'] = 'Her forum için özet tercihler hakkında bilgi.';
$string['privacy:metadata:forum_digests:forum'] = 'Foruma abone oldu.';
$string['privacy:metadata:forum_digests:maildigest'] = 'Özet tercihi.';
$string['privacy:metadata:forum_digests:userid'] = 'Özet tercihli kullanıcının kimliği.';
$string['privacy:metadata:forum_discussion_subs'] = 'Bireysel forum tartışmalarına abonelikler hakkında bilgiler';
$string['privacy:metadata:forum_discussion_subs:discussionid'] = 'Abone olunan tartışmanın kimliği.';
$string['privacy:metadata:forum_discussion_subs:preference'] = 'Aboneliğin başlangıç saati.';
$string['privacy:metadata:forum_discussion_subs:userid'] = 'Bir kullanıcının oluşturduğu bireysel forum tartışmaları hakkında bilgiler';
$string['privacy:metadata:forum_discussions'] = 'Bir kullanıcının oluşturduğu tekil forum tartışmaları hakkında bilgiler';
$string['privacy:metadata:forum_discussions:assessed'] = 'TODOD - bu alan neyi depolar?';
$string['privacy:metadata:forum_discussions:name'] = 'Yazar tarafından seçilen tartışmanın adı.';
$string['privacy:metadata:forum_discussions:timemodified'] = 'Yazar tarafından seçilen tartışmanın adı.';
$string['privacy:metadata:forum_discussions:userid'] = 'Tartışmayı oluşturan kullanıcının kimliği';
$string['privacy:metadata:forum_discussions:usermodified'] = 'Tartışmayı bir şekilde en son değiştiren kullanıcının kimliği.';
$string['privacy:metadata:forum_grades'] = 'Forum için verileri puanlama';
$string['privacy:metadata:forum_grades:forum'] = 'Not verilen forum';
$string['privacy:metadata:forum_grades:grade'] = 'Verilen not';
$string['privacy:metadata:forum_grades:userid'] = 'Not verilen kullanıcı';
$string['privacy:metadata:forum_posts'] = 'Her forum için özet tercihler hakkında bilgi.';
$string['privacy:metadata:forum_posts:created'] = 'Gönderinin oluşturulduğu saat.';
$string['privacy:metadata:forum_posts:discussion'] = 'Gönderinin içinde bulunduğu tartışma.';
$string['privacy:metadata:forum_posts:message'] = 'Forum gönderisinin mesajı.';
$string['privacy:metadata:forum_posts:modified'] = 'Yayının en son değiştirildiği zaman.';
$string['privacy:metadata:forum_posts:parent'] = 'Yanıtlanan ana gönderi.';
$string['privacy:metadata:forum_posts:privatereplyto'] = 'Bu yanıtın gönderildiği kullanıcının kimliği.';
$string['privacy:metadata:forum_posts:subject'] = 'Forum gönderisinin konusu.';
$string['privacy:metadata:forum_posts:totalscore'] = 'Forum gönderisinin mesajı.';
$string['privacy:metadata:forum_posts:userid'] = 'Forum gönderisini yazan kullanıcının kimliği.';
$string['privacy:metadata:forum_queue'] = 'Özet formda postalanacak yazıların geçici günlüğü';
$string['privacy:metadata:forum_queue:discussionid'] = 'Forum tartışma kimliği';
$string['privacy:metadata:forum_queue:postid'] = 'Forum gönderisi kimliği';
$string['privacy:metadata:forum_queue:timemodified'] = 'Orijinal gönderinin değiştirilme zamanı';
$string['privacy:metadata:forum_queue:userid'] = 'Gönderiden haberdar edilmesi gereken kullanıcı';
$string['privacy:metadata:forum_read'] = 'Kullanıcı tarafından hangi yazıların okunduğu hakkında bilgi.';
$string['privacy:metadata:forum_read:discussionid'] = 'Gönderinin içinde bulunduğu tartışma.';
$string['privacy:metadata:forum_read:firstread'] = 'Gönderinin ilk okunduğu zaman.';
$string['privacy:metadata:forum_read:lastread'] = 'Gönderinin en son okunduğu zaman.';
$string['privacy:metadata:forum_read:postid'] = 'Okunan gönderi.';
$string['privacy:metadata:forum_read:userid'] = 'Bu kaydın ilgili olduğu kullanıcının kimliği.';
$string['privacy:metadata:forum_subscriptions'] = 'Kullanıcının hangi forumlara abone olduğu hakkında bilgiler.';
$string['privacy:metadata:forum_subscriptions:forum'] = 'Abone olunan forum.';
$string['privacy:metadata:forum_subscriptions:userid'] = 'Bu forum aboneliğinin ilgili olduğu kullanıcının kimliği.';
$string['privacy:metadata:forum_track_prefs'] = 'Kullanıcının hangi forumları izlemeyi seçtiği hakkında bilgi okur.';
$string['privacy:metadata:forum_track_prefs:forumid'] = 'Okuma izleme özelliği etkinleştirilmiş forum.';
$string['privacy:metadata:forum_track_prefs:userid'] = 'Bu forum izleme tercihinin ilgili olduğu kullanıcının kimliği.';
$string['privacy:metadata:preference:autosubscribe'] = 'İçlerindeki gönderilere yanıt verirken tartışmalara abone olup olmayacağınız.';
$string['privacy:metadata:preference:forum_discussionlistsortorder'] = 'Tartışma listesinin tercih edilen sıralama düzeni';
$string['privacy:metadata:preference:maildigest'] = 'Site genelinde posta özeti tercihi';
$string['privacy:metadata:preference:markasreadonnotification'] = 'Forum mesajlarını mesaj olarak alırken okundu olarak işaretlenip işaretlenmeyeceği.';
$string['privacy:metadata:preference:trackforums'] = 'Okuma izlemenin etkinleştirilip etkinleştirilmeyeceği.';
$string['privacy:postwasread'] = 'Bu gönderi ilk olarak  {$a->firstread} tarihinde ve en son olarak {$a->lastread} tarihinde okundu';
$string['privacy:readtrackingdisabled'] = 'Bu forumda okuduğunuz gönderileri izlememeyi seçtiniz.';
$string['privacy:request:delete:discussion:name'] = 'Yazarın isteği üzerine sil';
$string['privacy:request:delete:post:message'] = 'Bu yazının içeriği yazarının isteği üzerine silindi.';
$string['privacy:request:delete:post:subject'] = 'Yazarın isteği üzerine sil';
$string['privacy:subscribedtoforum'] = 'Bu foruma üye oldunuz.';
$string['privatereply'] = 'Özel olarak yanıtla';
$string['privatereply_help'] = 'Özel olarak cevap verdiğinizde, gönderiniz öğretmenler gibi özel cevapları görüntüleme özelliğine sahip kullanıcılar tarafından da görülebilir.';
$string['processingdigest'] = '{$a} kullanıcısı için e-posta özetleri işleniyor';
$string['processingpost'] = '{$a} mesajı işleniyor';
$string['prune'] = 'Böl';
$string['prunediscussion'] = 'Bölünmüş tartışma';
$string['prunedpost'] = 'Yeni bir tartışma şu mesajdan oluşturuldu';
$string['pruneheading'] = 'Tartışmayı böl ve mesajı yeni bir tartışmaya taşı';
$string['qandaforum'] = 'Soru/Cevap forumu';
$string['qandanotify'] = 'Bu bir soru-cevap forumudur. Diğer cevapları görmek için önce kendi cevabınızı göndermelisiniz.';
$string['re'] = 'Ynt:';
$string['readtherest'] = 'Bu konunun kalanını oku';
$string['removeallforumtags'] = 'Tüm forum etiketleri';
$string['removefromfavourites'] = 'Bu tartışmayı kaldır';
$string['replies'] = 'Yanıtlar';
$string['repliesmany'] = 'Şimdiye kadar {$a} yanıt';
$string['repliesone'] = 'Şimdiye kadar {$a} yanıt';
$string['reply'] = 'Yanıtla';
$string['reply_handler'] = 'Forum mesajlarına e-posta ile cevap ver';
$string['reply_handler_name'] = 'Forum yazılarına cevap ver';
$string['replyauthorself'] = '{$a} (siz)';
$string['replyforum'] = 'Forumu yanıtla';
$string['replyingtoauthor'] = '{$a} yanıtlanıyor ...';
$string['replyplaceholder'] = 'Cevap yazınız ...';
$string['replypostdiscussion'] = 'Tartışmaya cevap ver';
$string['replytopostbyemail'] = 'Bunu e-postayla yanıtlayabilirsiniz.';
$string['replytouser'] = 'Yanıtta eposta adresi kullan';
$string['resetdigests'] = 'Kullanıcı başına forum özet tercihleri';
$string['resetforums'] = 'Mesajları sil';
$string['resetforumsall'] = 'Tüm mesajlar';
$string['resetsubscriptions'] = 'Tüm forum abonelikleri';
$string['resettrackprefs'] = 'Tüm forum izleme seçenekleri';
$string['rssarticles'] = 'RSS son makale sayısı';
$string['rssarticles_help'] = 'Bu ayar RSS beslemesine dahil edilecek makale (tartışmalar veya gönderiler) sayısını belirtir. Genellikle 5 ile 20 arası kabul edilebilir.';
$string['rsssubscriberssdiscussions'] = 'Tartışmaların RSS beslemesi';
$string['rsssubscriberssposts'] = 'Gönderilerin RSS beslemesi';
$string['rsstype'] = 'Bu etkinlik için RSS beslemesi';
$string['rsstype_help'] = '<p>Bu seçenek bu forumda RSS içeriklerini etkinleştirmenize olanak sağlar.</p>
<p>İki çeşit seçebilirsiniz:</p>

<ul>
<li><b>Tartışmalar:</b> Oluşturulan RSS içerikleri, yeni tartışmadaki ilk mesajı içerir.</li>
<li><b>Mesajlar:</b> Oluşturulan RSS içerikleri, forumdaki her mesajı içerir.</li>
</ul>';
$string['rsstypedefault'] = 'RSS besleme türü';
$string['search'] = 'Ara';
$string['search:activity'] = 'Forum - etkinlik bilgileri';
$string['search:post'] = 'Forum - yazılar';
$string['searchdatefrom'] = 'Mesajlar bu tarihten daha yeni olmalı';
$string['searchdateto'] = 'Mesajlar bu tarihten daha eski olmalı';
$string['searchforumintro'] = 'Lütfen aşağıdaki alanların birine veya birden fazlasına arama terimlerini giriniz';
$string['searchforums'] = 'Forumları ara';
$string['searchfullwords'] = 'Bu sözcükler geçebilir';
$string['searchnotwords'] = 'Bu sözcükler geçmemeli';
$string['searcholderposts'] = 'Daha eski mesajları ara...';
$string['searchphrase'] = 'Bu terim mesajda aynen olmalı';
$string['searchresults'] = 'Arama sonuçları';
$string['searchsubject'] = 'Bu sözcük konuda geçmeli';
$string['searchtags'] = 'ile etiketlendi mi?';
$string['searchuser'] = 'Bu isim yazar adı ile eşleşmeli';
$string['searchuserid'] = 'Yazarın ID numarası';
$string['searchusers'] = 'Kullanıcı ara';
$string['searchwhichforums'] = 'Hangi forum aranacak';
$string['searchwords'] = 'Bu sözcükler mesajın herhangi bir yerinde olabilir';
$string['seeallposts'] = 'Bu kullanıcı tarafından gönderilmiş bütün mesajlar';
$string['sendstudentnotificationsdefault'] = '"Öğrencileri bilgilendir" için varsayılan ayar';
$string['sendstudentnotificationsdefault_help'] = 'Puanlama formundaki "Öğrencileri bilgilendir" onay kutusu için varsayılan değeri ayarlayın.';
$string['sendstudentnotificationsno'] = 'Hayır';
$string['sendstudentnotificationsyes'] = 'Evet, öğrenciye bildirim gönder';
$string['settings'] = 'Ayarlar';
$string['shortpost'] = 'Kısa mesaj';
$string['showgraderpanel'] = 'Not veren panelini göster';
$string['showingcountoftotaldiscussions'] = 'Tartışma listesi. {$a->total} tartışmadan {$a->count} gösteriliyor';
$string['showmoreusers'] = 'Daha fazla kullanıcı göster';
$string['showpreviousrepliescount'] = 'Önceki yanıtları göster ({$a})';
$string['showsubscribers'] = 'Aboneleri göster/düzenle';
$string['showusersearch'] = 'Kullanıcı aramasını göster';
$string['singleforum'] = 'Tek bir tartışma';
$string['smallmessage'] = '{$a->user} yazılarda {$a->forumname}';
$string['smallmessagedigest'] = '{$a} mesaj içeren forum özeti';
$string['starredonly'] = 'Yalnızca yıldızlı tartışmalarda ara';
$string['startedby'] = 'Başlatan';
$string['subject'] = 'Konu';
$string['subplugintype_forumreport'] = 'Forum raporu';
$string['subplugintype_forumreport_plural'] = 'Forum raporları';
$string['subscribe'] = 'Foruma abone ol';
$string['subscribeall'] = 'Herkesi bu foruma abone yap';
$string['subscribed'] = 'Abone olundu';
$string['subscribediscussion'] = 'Bu tartışmaya abone olun';
$string['subscribeenrolledonly'] = 'Üzgünüz, yalnızca kayıtlı kullanıcılar forum yazısı bildirimlerine abone olabilirler.';
$string['subscribenone'] = 'Herkesin bu forumdan aboneliğini kaldır';
$string['subscribers'] = 'Aboneler';
$string['subscriberstowithcount'] = '"{$a->name}" aboneleri ({$a->count})';
$string['subscribestart'] = 'Bana bu forumdaki yeni mesajların bildirimlerini gönder';
$string['subscribestop'] = 'Bu forumdaki yeni mesajlardan haberdar olmak istemiyorum';
$string['subscription'] = 'Abonelik';
$string['subscription_help'] = 'Bir foruma abone olduysanız, yeni forum gönderileri için bildirim alacaksınız demektir. Genelde, abone olmak isteyip istemediğinizi seçebilirsiniz, ancak bazen herkes abone olmak zorunda olduğundan bildirim alır.';
$string['subscriptionandtracking'] = 'Abonelik ve takip';
$string['subscriptionauto'] = 'Otomatik abonelik';
$string['subscriptiondisabled'] = 'Abonelik devre dışı';
$string['subscriptionforced'] = 'Zorunlu abonelik';
$string['subscriptionmode'] = 'Abonelik modu';
$string['subscriptionmode_help'] = 'Bir katılımcı bir foruma abone olduğunda, forum gönderisi bildirimleri alacakları anlamına gelir. 4 abonelik modu seçeneği vardır:

* İsteğe bağlı abonelik - Katılımcılar abone olup olmayacağını seçebilir
* Zorunlu abonelik - Herkes abone olur ve abonelikten çıkamaz
* Otomatik abonelik - Başlangıçta herkes abone olur ancak herhangi bir zamanda abonelikten çıkmayı seçebilir
* Abonelik devre dışı - Abonelikler izin verilmedi';
$string['subscriptionmodeconfirm'] = 'Abonelik şeklini{$a} olarak değiştirmek istediğinizden emin misiniz?';
$string['subscriptionoptional'] = 'İsteğe bağlı abonelik';
$string['subscriptions'] = 'Abonelikler';
$string['tagarea_forum_posts'] = 'Forum mesajları';
$string['tagsdeleted'] = 'Forum etiketleri silindi';
$string['thisforumhasduedate'] = 'Bu foruma kayıt için son tarih {$a}.';
$string['thisforumisdue'] = 'Bu foruma kayıt için son tarih {$a} idi.';
$string['thisforumisthrottled'] = 'Bu forumda belirli sürede mesaj gönderme sınırlaması var. {$a->blockperiod} içinde en fazla {$a->blockafter} mesaj gönderebilirsiniz.';
$string['timed'] = 'Zamanlanmış';
$string['timeddiscussion'] = 'Zamanlanmış tartışma';
$string['timedhidden'] = 'Zamanlı durum: Öğrencilerden gizlendi';
$string['timedposts'] = 'Süreli mesaj';
$string['timedvisible'] = 'Zamanlı durum: Tüm kullanıcılar tarafından görülebilir';
$string['timestartenderror'] = 'Gösterme bitiş tarihi, başlangıç tarihinden erken bir tarihte olamaz';
$string['togglediscussionmenu'] = 'Tartışma menüsünü değiştirin';
$string['togglefullscreen'] = 'Tam ekrana geç';
$string['togglesettingsdrawer'] = 'Ayarlar çekmecesini aç / kapat';
$string['trackforum'] = 'Okunmamış yayınları takip edin';
$string['tracking'] = 'İzle';
$string['trackingoff'] = 'Kapalı';
$string['trackingon'] = 'Zorunlu';
$string['trackingoptional'] = 'İsteğe bağlı';
$string['trackingtype'] = 'İzlemeyi okuyun
';
$string['trackingtype_help'] = 'Okuma takibi, katılımcıların yeni gönderileri işaretleyerek henüz görmedikleri gönderileri kontrol etmelerini sağlar.

İsteğe bağlı olarak ayarlanırsa, katılımcılar forum için izlemeyi açmayı veya kapatmayı seçebilirler. (Kullanıcılar ayrıca forum tercihlerinde forum takibini etkinleştirmelidir).

Bir site yöneticisi tarafından \'Zorunlu okuma takibine izin ver\' seçeneği etkinleştirilirse, başka bir seçenek daha kullanılabilir - zorunlu. Bu, kullanıcıların forum tercihlerinden bağımsız olarak izlemenin her zaman açık olduğu anlamına gelir.';
$string['trackreadposts_header'] = 'Forum izleme';
$string['unlockdiscussion'] = 'Bu tartışmanın kilidini aç';
$string['unpindiscussion'] = 'Bu tartışmanın sabitlemesini kaldır';
$string['unread'] = 'Okunmamış';
$string['unreadpost'] = 'Okunmamış gönderi';
$string['unreadposts'] = 'Okunmamış mesajlar';
$string['unreadpostsnumber'] = '{$a} okunmamış mesaj';
$string['unreadpostsone'] = '1 okunmamış mesaj';
$string['unsubscribe'] = 'Forum aboneliğini kaldır';
$string['unsubscribeall'] = 'Tüm forumlardan aboneliği kaldır';
$string['unsubscribeallconfirm'] = 'Şu anda {$a->forums} forumlarına ve {$a->discussions} tartışmalarına abonesiniz. Tüm forumlardan ve tartışmalardan aboneliğinizi gerçekten iptal etmek ve tartışma otomatik aboneliğini devre dışı bırakmak istiyor musunuz?';
$string['unsubscribeallconfirmdiscussions'] = 'Şu anda {$a->discussion} tartışmalarına abone oldunuz. Gerçekten tüm tartışmalara aboneliğinizi iptal etmek ve otomatik aboneliği tartışmayı devre dışı bırakmak istiyor musunuz?';
$string['unsubscribeallconfirmforums'] = 'Şu anda {$a->forums} forumlarına abone oldunuz. Gerçekten tüm forumlardan çıkmak ve otomatik aboneliği tartışmayı devre dışı bırakmak istiyor musunuz?';
$string['unsubscribealldone'] = 'İsteğe bağlı tüm forum abonelikleri kaldırıldı. Yine de zorunlu aboneliğe sahip forumlardan bildirimler alacaksınız. Forum bildirimlerini yönetmek için Profil Ayarlarım\'da Mesajlaşma\'ya gidin.';
$string['unsubscribeallempty'] = 'Herhangi bir foruma üye değilsiniz. Bu sunucudan gelen tüm bildirimleri devre dışı bırakmak için Profil Ayarlarım\'da Mesajlaşma\'ya gidin.';
$string['unsubscribed'] = 'Abonelik kaldırıldı';
$string['unsubscribediscussion'] = 'Bu tartışmanın aboneliğinden çık';
$string['unsubscribediscussionlink'] = 'Bu tartışmayı iptal edin: {$a}';
$string['unsubscribelink'] = 'Bu forumu iptal edin: {$a}';
$string['unsubscribeshort'] = 'Aboneliği kaldır';
$string['useexperimentalui'] = 'Deneysel iç içe geçmiş tartışma görünümünü kullan';
$string['usermarksread'] = 'Mesaj okuma işaretlemesi';
$string['usernavigation'] = 'Kullanıcı navigasyonu';
$string['usersforumposts'] = 'Kullanıcının forum gönderileri';
$string['viewalldiscussions'] = 'Tüm tartışmalara bak';
$string['viewconversation'] = 'Tartışmayı görüntüleyin';
$string['viewgrades'] = 'Notları görüntüleyin';
$string['viewparentpost'] = 'Üst gönderiyi görüntüle';
$string['viewthediscussion'] = 'Tartışmayı görüntüle';
$string['warnafter'] = 'Uyarı için mesaj sınırı';
$string['warnafter_help'] = 'Öğretmenler, belirli bir dönemde izin verilen maksimum gönderi sayısına yaklaştıkça uyarılabilir. Bu ayar, kaç gönderiden sonra uyarıldıklarını belirtir. Mod/forum: postwithrottling özelliği olan kullanıcılar, gönderi sınırlarından muaftır.';
$string['warnformorepost'] = 'Uyarı! Bu forumda birden fazla tartışma var - en yeni';
$string['yournewquestion'] = 'Yeni sorunuz';
$string['yournewtopic'] = 'Yeni tartışma konunuz';
$string['yourreply'] = 'Yanıtınız';
