<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'moodle', language 'et', version '4.5'.
 *
 * @package     moodle
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['abouttobeinstalled'] = 'hakatakse installima';
$string['accept'] = 'Aktsepteeri';
$string['action'] = 'Toiming';
$string['actionchoice'] = 'Mida soovite failiga „{$a}“ teha?';
$string['actions'] = 'Toimingud';
$string['actionsfor'] = '{$a} toimingud';
$string['actionsmenu'] = 'Toimingute menüü';
$string['active'] = 'Aktiivne';
$string['activeusers'] = 'Aktiivsed kasutajad';
$string['activities'] = 'Tegevused';
$string['activities_help'] = 'Näiteks foorumid, testid ja vikid võimaldavad kursusse lisada interaktiivset sisu.';
$string['activity'] = 'Tegevus';
$string['activityclipboard'] = 'Järgmise tegevuse teisaldamine: {$a}';
$string['activityheader'] = 'Tegevusmenüü';
$string['activityicon'] = '{$a} ikoon';
$string['activityiscurrentlyhidden'] = 'Kahjuks on see tegevus praegu peidetud';
$string['activitymodule'] = 'Tegevusmoodul';
$string['activitymodules'] = 'Tegevusmoodulid';
$string['activitynotready'] = 'Tegevus ei ole veel valmis';
$string['activityorresource'] = 'Tegevus või vahend';
$string['activityreport'] = 'Tegevusaruanne';
$string['activityreports'] = 'Tegevusaruanded';
$string['activityselect'] = 'Vali see tegevus mujale viimiseks';
$string['activitysince'] = 'Tegevus alates {$a}';
$string['activitytypetitle'] = '{$a->activity} – {$a->type}';
$string['activityweighted'] = 'Tegevus kasutajate kaupa';
$string['add'] = 'Lisa';
$string['addactivity'] = 'Lisa tegevus...';
$string['addactivitytosection'] = 'Lisa tegevus jaotisse {$a}';
$string['addadmin'] = 'Lisa administraator';
$string['addblock'] = 'Lisa plokk';
$string['addcomment'] = 'Lisa kommentaar...';
$string['addcondition'] = 'Lisa tingimus';
$string['addcontent'] = 'Lisa sisu';
$string['addcountertousername'] = 'Loo kasutaja, lisades kasutajanimesse numbri';
$string['addcreator'] = 'Lisa kursuse disainer';
$string['adddots'] = 'Lisa...';
$string['added'] = 'Lisatud {$a}';
$string['addedtogroup'] = 'Lisatud rühma {$a}';
$string['addedtogroupnot'] = 'Ei lisatud rühma {$a}';
$string['addedtogroupnotenrolled'] = 'Ei lisatud rühma {$a}, kuna te pole kursusele registreerunud';
$string['addfilehere'] = 'Lisa failid siia';
$string['addfilesdrop'] = 'Sa võid failid üles laadimiseks siia lohistada või klikkida valiku tegemiseks';
$string['addinganew'] = 'Uue üksuse lisamine: {$a}';
$string['addinganewto'] = 'Uue vahendi {$a->what} lisamine asukohta {$a->to}';
$string['addingdatatoexisting'] = 'Lisan andmed olemasolevasse';
$string['additionalcustomnav'] = 'Lisanduv kohandatud navigeeriumine';
$string['additionalnames'] = 'Täiendavad nimed';
$string['addlinkhere'] = 'Lisa link siia';
$string['addnew'] = 'Lisa uus {$a}';
$string['addnewcategory'] = 'Lisa uus kategooria';
$string['addnewcourse'] = 'Lisa uus kursus';
$string['addnewuser'] = 'Lisa uus kasutaja';
$string['addnousersrecip'] = 'Lisa kasutajad, kes pole veel sisenenud {$a} adressaatide nimekirja';
$string['addpagehere'] = 'Lisa tekst siia';
$string['addresource'] = 'Lisa vahend...';
$string['addresourceoractivity'] = 'Lisa Tegevus või Vahend';
$string['addresourcetosection'] = 'Lisa vahend jaotisse „{$a}“';
$string['address'] = 'Aadress';
$string['addsections'] = 'Lisa jaotisi';
$string['addstudent'] = 'Lisa õppija';
$string['addsubcategory'] = 'Lisa alamkategooria';
$string['addteacher'] = 'Lisa õpetaja';
$string['admin'] = 'Administraator';
$string['adminhelpaddnewuser'] = 'Uue kasutajakonto loomiseks käsitsi';
$string['adminhelpassignadmins'] = 'Administraatorid saavad selles õpikeskkonnas kõike teha ja igale poole minna';
$string['adminhelpassigncreators'] = 'Kursuse loojad saavad luua uusi kursusi';
$string['adminhelpassignsiteroles'] = 'Määra õpikeskkonna rollid erikasutajale';
$string['adminhelpassignstudents'] = 'Mine kursusele ja lisa õppijaid administreerimise menüüst';
$string['adminhelpauthentication'] = 'Sa saad kasutada süsteemisiseseid kasutajakontosid või väliseid andmebaase';
$string['adminhelpbackup'] = 'Seadista automaatne varukoopia tegemine ja ajasta see';
$string['adminhelpconfiguration'] = 'Seadista õpikeskkonna väljanägemine ja töö';
$string['adminhelpconfigvariables'] = 'Seadista muutujad, mis mõjutavad süsteemi üldist tööd';
$string['adminhelpcourses'] = 'Määratle kursused ja kursuste kategooriad ning määra nendes osalejad';
$string['adminhelpeditorsettings'] = 'Määratle  HTML-toimeti seaded';
$string['adminhelpedituser'] = 'Sirvi kasutajakontode nimekirja ja muuda ükskõik millist neist';
$string['adminhelpenvironment'] = 'Kontrolli, kuidas server vastab praegustele ja tulevastele installinõuetele';
$string['adminhelpfailurelogs'] = 'Sirvi ebaõnnestunud sisenemisi';
$string['adminhelplanguage'] = 'Keelefailide kontroll ja muutmine';
$string['adminhelplogs'] = 'Sirvi õpikeskkonna kõiki tegevusi';
$string['adminhelpmanageblocks'] = 'Installeeritud plokkide ja nende seadete haldamine';
$string['adminhelpmanagedatabase'] = 'Otsene ligipääs andmebaasile (ole ettevaatlik!)';
$string['adminhelpmanagefilters'] = 'Vali tekstifiltrid ja nende seadistused';
$string['adminhelpmanagemodules'] = 'Paigaldatud moodulite ja nende seadete haldamine';
$string['adminhelpmanageroles'] = 'Loo rolle mida on võimalik määrata hiljem kasutajatele.';
$string['adminhelpmymoodle'] = 'Seadista Minu Moodle plokk kasutajatele';
$string['adminhelpreports'] = 'Õpikeskkonna ülevaated';
$string['adminhelpsitefiles'] = 'Üldiste failide publitseerimine või välise varukoopia üleslaadimine';
$string['adminhelpsitesettings'] = 'Määra esilehe kujundus';
$string['adminhelpstickyblocks'] = 'Seadista Moodle \'i üleselt kinnitatud plokid';
$string['adminhelpthemes'] = 'Määra õpikeskkonna kujundus(värvid, tähestiilid jne)';
$string['adminhelpuploadusers'] = 'Impordi uued kasutajakontod tekstifailist';
$string['adminhelpusers'] = 'Määra kasutajad ja seadista autentimine';
$string['adminhelpxmldbeditor'] = 'Liides XMLDB-failide redigeerimiseks. Ainult arendajatele.';
$string['administration'] = 'Haldus';
$string['administrationsite'] = 'Õpikeskkonna haldus';
$string['administrator'] = 'Administraator';
$string['administratordescription'] = 'Administraatorid saavad teha kõike õpikeskkonnas ja kõikidel kursustel.';
$string['administrators'] = 'Administraatorid';
$string['administratorsall'] = 'Kõik administraatorid';
$string['administratorsandteachers'] = 'Administraatorid ja õpetajad';
$string['advanced'] = 'Täpsemalt';
$string['advancedfilter'] = 'Täpsem otsing';
$string['advancedsettings'] = 'Täpsemad seaded';
$string['afterresource'] = 'Pärast vahendit „{$a}“';
$string['aftersection'] = 'Pärast jaotist „{$a}“';
$string['again'] = 'uuesti';
$string['agelocationverification'] = 'Vanuse ja asukoha kontroll';
$string['ajaxuse'] = 'AJAX ja Javascript';
$string['all'] = 'Kõik';
$string['allactions'] = 'Kõik toimingud';
$string['allactivities'] = 'Kõik tegevused';
$string['allcategories'] = 'Kõik kategooriad';
$string['allchanges'] = 'Kõik muudatused';
$string['alldays'] = 'Kõik päevad';
$string['allfiles'] = 'Kõik failid';
$string['allgroups'] = 'Kõik rühmad';
$string['alllogs'] = 'Kõik logid';
$string['allmods'] = 'Kõik {$a}';
$string['allow'] = 'Luba';
$string['allowinternal'] = 'Luba ka seesmisi meetodeid';
$string['allownone'] = 'Keela kõik';
$string['allownot'] = 'Keeldu';
$string['allowstealthmodules'] = 'Luba varjatud tegevused';
$string['allowstealthmodules_help'] = 'Kui see on lubatud, saab tegevused saadavaks teha nii, et neid ei kuvata kursuse lehe nähtavates jaotistes. Sel juhul peab lisama varjatud tegevuse lingi kuskile mujale, nt mõnele lehele. Varjatud tegevused kuvatakse siiski hinnetelehel ja muudes aruannetes.';
$string['allparticipants'] = 'Kõik osalejad';
$string['allteachers'] = 'Kõik õpetajad';
$string['alphanumerical'] = 'Võib sisaldada üksnes tähti ja numbreid, sidekriipsu (-) ja punkti (.)';
$string['alreadyconfirmed'] = 'Registreerumine on juba kinnitatud';
$string['alternatename'] = 'Teine nimi';
$string['always'] = 'Alati';
$string['and'] = '{$a->one} ja {$a->two}';
$string['answer'] = 'Vastus';
$string['any'] = 'Mis tahes';
$string['appearance'] = 'Välimus';
$string['apply'] = 'Lisa';
$string['applyfilters'] = 'Rakenda filtrid';
$string['approve'] = 'Kinnita';
$string['areyousure'] = 'Kas olete kindel?';
$string['areyousuretorestorethis'] = 'Kas soovid jätkata?';
$string['areyousuretorestorethisinfo'] = 'Hiljem avaneb võimalus lisada see varukoopia olemasolevale kursusele või luua täiesti uus kursus.';
$string['asc'] = 'Tõusvalt';
$string['assessment'] = 'Hindamine';
$string['assignadmins'] = 'Määra administraatorid';
$string['assigncreators'] = 'Määra kursuse disainerid';
$string['assignedrolecount'] = '{$a->role}: {$a->count}';
$string['assignsiteroles'] = 'Määra keskkonnaülesed rollid';
$string['authenticateduser'] = 'Autenditud kasutaja';
$string['authenticateduserdescription'] = 'Kõik sisseloginud kasutajad.';
$string['authentication'] = 'Autentimine';
$string['authenticationplugins'] = 'Autentimislisandmoodulid';
$string['autosubscribe'] = 'Foorumiteabe automaatne tellimine';
$string['autosubscribeno'] = 'Ei: ära liida mind automaatselt foorumiaruteludega';
$string['autosubscribeyes'] = 'Jah: kui ma postitan, siis liida mind selle foorumiaruteluga';
$string['availability'] = 'Kättesaadavus';
$string['availablecourses'] = 'Saadaolevad kursused';
$string['back'] = 'Tagasi';
$string['backto'] = 'Tagasi {$a} juurde';
$string['backtocourselisting'] = 'Tagasi kursuste loendisse';
$string['backtohome'] = 'Tagasi Saidi koju';
$string['backtopageyouwereon'] = 'Tagasi lehele kus sa olid';
$string['backup'] = 'Loo varukoopia';
$string['backupactivehelp'] = 'Valige, kas varundatakse automaatselt või mitte.';
$string['backupadhocpending'] = 'Kursuse adhoc koopia tegevus ootel';
$string['backupcancelled'] = 'Varukoopia tegemine katkestatud';
$string['backupcoursefileshelp'] = 'Kui see säte on lubatud, siis kaasatakse kursusefailid automaatvarundusse.';
$string['backupdate'] = 'Varukoopia tegemise kuupäev';
$string['backupdatenew'] = '&nbsp; {$a->TAG} on nüüd {$a->weekday}, {$a->mday} {$a->month} {$a->year}<br />';
$string['backupdateold'] = '{$a->TAG} oli {$a->weekday}, {$a->mday} {$a->month} {$a->year}';
$string['backupdaterecordtype'] = '<br />{$a->recordtype} - {$a->recordname}<br />';
$string['backupdetails'] = 'Varukoopia üksikasjad';
$string['backuperrorinvaliddestination'] = 'Varukoopia sihtkausta pole olemas või seal puuduvad kirjutusõigused.';
$string['backupexecuteathelp'] = 'Valige, millal alustatakse automaatse varukoopia tegemist.';
$string['backupfailed'] = 'Mõni kursus on salvestamata.';
$string['backupfilename'] = 'varundus';
$string['backupfinished'] = 'Varundus on nüüd lõpule viidud';
$string['backupfromthissite'] = 'Varukoopia oli tehtud sellel saidil?';
$string['backupgradebookhistoryhelp'] = 'Kui see säte on lubatud, siis kaasatakse hinnetelehe ajalugu automaatvarundusse. Arvestage, et selle valiku toimimiseks peab hinnete ajalugu olema serveri sätetes lubatud (disablegradehistory).';
$string['backupincludemoduleshelp'] = 'Valige, kas soovite kursusemoodulid (koos kasutajaandmetega või ilma) kaasata automaatsesse varukoopiasse';
$string['backupincludemoduleuserdatahelp'] = 'Valige, kas soovite automaatvarundusse kaasata mooduli kasutajaandmed.';
$string['backuplogdetailed'] = 'Üksikasjalik täitmislogi';
$string['backuploglaststatus'] = 'Viimane täitmislogi';
$string['backupmissinguserinfoperms'] = 'Varukoopias puuduvad kasutaja andmed. Harjutuse ja Õpikoja tegevusi ei lisata varukoopiasse, kuna need moodulid ei sobitu sellist tüüpi varukoopiaga.';
$string['backupnext'] = 'Järgmine varukoopia';
$string['backupnonisowarning'] = 'Hoiatus: käesolev varukoopia on pärit mitte-Unicode Moodle\'i versioonist (varasem kui 1.6). Kui selles varukoopias on mitte-ISO-8859-1 standardi järgi loodud tekstifaile, võivad need saada rikutud, kui proovid neid üles laadida praegusesse Unicode versiooniga Moodle\'isse. Varukoopia korrektseks taastamiseks saab lisainformatsiooni <a href="https://docs.moodle.org/en/Backup_FAQ">Varundamise KKK\'st</a>.';
$string['backupnotyetrun'] = 'Automaatne varundamine on ootel';
$string['backuporiginalname'] = 'Varukoopia nimi';
$string['backuproleassignments'] = 'Varunda rollimääramised nende rollide jaoks';
$string['backupsavetohelp'] = 'Selle kataloogi täielik tee, kuhu soovite varundusfailid salvestada';
$string['backupsitefileshelp'] = 'Kui see säte on lubatud, siis kursustel kasutatud saidifailid kaasatakse automaatvarundusse.';
$string['backuptakealook'] = 'Varunduslogisid saate vaadata siin:
  {$a}';
$string['backupuserfileshelp'] = 'Valige, kas kasutajate failid (nt profiilipildid) tuleks automaatvarundusse kaasata';
$string['backupversion'] = 'Varukoopia versioon';
$string['badges'] = 'Õpimärgid';
$string['block'] = 'Plokk';
$string['blockconfiga'] = '{$a} – ploki konfigureerimine';
$string['blockconfigbad'] = 'See plokk pole veel korralikult juurutatud ja seetõttu puudub ka ploki konfigureerimise kasutajaliides.';
$string['blocks'] = 'Plokid';
$string['blocksaddedit'] = 'Lisa/muuda plokke';
$string['blockseditoff'] = 'Keela plokkide muutmine';
$string['blocksediton'] = 'Luba plokkide muutmine';
$string['blocksetup'] = 'Plokkide tabelite seadistamine';
$string['blocksuccess'] = '{$a} tabelite seadistamine õnnestus';
$string['brief'] = 'Lühike';
$string['bulkactions'] = 'Hulgitoimingud';
$string['bulkactionselect'] = '{$a} hulgitoimingu valik';
$string['bulkmovecoursessuccess'] = '{$a->courses} kursust on edukalt teisaldatud kategooriasse {$a->category}';
$string['bulkselection'] = '{$a} valitud';
$string['bycourseorder'] = 'Kursuste järjekorra alusel';
$string['byname'] = 'nime {$a} alusel';
$string['bypassed'] = 'Läbitud';
$string['cachecontrols'] = 'Puhvri kontrollid';
$string['calltofeedback'] = 'Selle tarkvara loojad ootavad sinu tagasisidet.';
$string['calltofeedback_give'] = 'Anna selle tarkvara kohta tagasisidet';
$string['calltofeedback_remind'] = 'Tuleta hiljem meelde';
$string['cancel'] = 'Tühista';
$string['cancelled'] = 'Tühistatud';
$string['categories'] = 'Kursuste kategooriad';
$string['categoriesandcourses'] = 'Kursuste kategooriad ja kursused';
$string['category'] = 'Kategooria';
$string['categoryadded'] = 'Kategooria „{$a}“ lisati';
$string['categorybulkaction'] = 'Valitud kategooriate hulgitoimingud';
$string['categorycontents'] = 'Alamkategooriad ja kursused';
$string['categorycurrentcontents'] = '{$a} sisu';
$string['categorydeleted'] = 'Kategooria „{$a}“ on kustutatud';
$string['categoryduplicate'] = 'Kategooria nimega \'{$a}\' on juba olemas!';
$string['categoryheader'] = 'Kategooria menüü';
$string['categoryhidden'] = '(peidetud)';
$string['categorymodifiedcancel'] = 'Kategooriat muudeti. Tühistage ja proovige uuesti.';
$string['categoryname'] = 'Kategooria nimi';
$string['categorypath'] = 'Kategooria asukoht';
$string['categorysubcategoryof'] = '{$a->category} on kategooria {$a->parentcategory} alamkategooria';
$string['categoryupdated'] = 'Kategooria „{$a}“ värskendati';
$string['changedpassword'] = 'Parool muudetud';
$string['changepassword'] = 'Muuda parooli';
$string['changesmade'] = 'Tehtud muudatused';
$string['changesmadereallygoaway'] = 'Olete teinud muudatusi. Kas soovite kindlasti sellelt lehelt lahkuda ja lasta muudatustel kaotsi minna?';
$string['changessaved'] = 'Muudatused on salvestatud';
$string['check'] = 'Kontrolli';
$string['checkactual'] = 'Tegelik';
$string['checkall'] = 'Kontrolli kõiki';
$string['checkexpected'] = 'Oodatud';
$string['checkingbackup'] = 'Kontrollin varukoopiat';
$string['checkingcourse'] = 'Kontrollin kursust';
$string['checkingforbbexport'] = 'Kontrollin BlackBoard\'i eksporti';
$string['checkinginstances'] = 'Kontrollin eksemplare';
$string['checkingsections'] = 'Kontrollin sektsioone';
$string['checklanguage'] = 'Kontrolli keelt';
$string['checknone'] = 'Ära kontrolli';
$string['checks'] = 'Kontrollid';
$string['checksok'] = 'Kõik kontrollid \'{$a}\' on korras';
$string['childcoursenotfound'] = 'Alamkursust ei leitud!';
$string['childcourses'] = 'Alamkursused';
$string['choose'] = 'Vali';
$string['choosecourse'] = 'Vali kursus';
$string['choosedots'] = 'Valige...';
$string['chooselivelogs'] = 'Või jälgige jooksvat tegevust';
$string['chooselogs'] = 'Valige, milliseid logisid soovite näha';
$string['choosereportfilter'] = 'Vali filter kokkuvõttele';
$string['choosetheme'] = 'Valige kujundus';
$string['chooseuser'] = 'Valige kasutaja';
$string['city'] = 'Linn või maakond';
$string['cleaningtempdata'] = 'Ajutiste andmete kustutamine';
$string['clear'] = 'Puhasta';
$string['clearfilterrow'] = 'Eemalda filtrite rida';
$string['clearfilters'] = 'Puhasta filtrid';
$string['clearsearch'] = 'Tühjenda otsing';
$string['clickhelpiconformoreinfo'] = '... jätkub ... Vajutage abi ikoonil, et lugeda täispikka teksti';
$string['clickhere'] = 'Kliki siia ...';
$string['clicktochangeinbrackets'] = '{$a} (Klõpsake muutmiseks)';
$string['clicktohideshow'] = 'Klõpsake avamiseks või sulgemiseks';
$string['closeblockdrawer'] = 'Sulge plokisahtel';
$string['closebuttontitle'] = 'Sule';
$string['closecourseindex'] = 'Sulge kursuse sisukord';
$string['closedrawer'] = 'Sulge sahtel';
$string['closewindow'] = 'Sule see aken';
$string['collapse'] = 'Ahenda';
$string['collapseall'] = 'Ahenda kõik';
$string['collapsecategory'] = 'Ahenda {$a}';
$string['comebacklater'] = 'Palun tule hiljem tagasi';
$string['commentincontext'] = 'Otsi seda kommentaari kontekstist';
$string['comments'] = 'Kommentaarid';
$string['commentscount'] = 'Kommentaarid ({$a})';
$string['commentsnotenabled'] = 'Kommenteerimisvõimalus pole lubatud';
$string['commentsrequirelogin'] = 'Kommentaaride nägemiseks peate sisse logima.';
$string['comparelanguage'] = 'Võrdle ja muuda kasutatavat keelt';
$string['complete'] = 'Valmis';
$string['completed'] = 'Lõpetatud';
$string['completereport'] = 'Täielik aruanne';
$string['configuration'] = 'Konfiguratsioon';
$string['confirm'] = 'Kinnita';
$string['confirmcheckfull'] = 'Kas soovite üksuse {$a} kindlasti kinnitada?';
$string['confirmcoursemove'] = 'Kas soovite selle kursuse ({$a->course}) kindlasti sellesse kategooriasse ({$a->category}) teisaldada?';
$string['confirmdeletesection'] = 'Kas soovite jaotise „{$a}“ ja kõik selles sisalduvad tegevused kindlasti kustutada?';
$string['confirmed'] = 'Teie registreerumine on kinnitatud';
$string['confirmednot'] = 'Sinu registreerumist pole veel kinnitatud! Palun kontrolli kas sinu postkastis on kinnitusmail.';
$string['considereddigitalminor'] = 'Sa oled liiga noor, et siia lehele konto luua.';
$string['content'] = 'Sisu';
$string['contentbank'] = 'Sisupank';
$string['contentexport_aboutthiscourse'] = 'Kursuse kokkuvõte';
$string['contentexport_coursesummary'] = 'See fail on osa sisust, mis on alla laaditud lehelt <a href="{$a->courselink}">{$a->coursename}</a>.';
$string['contentexport_footersummary'] = 'See fail on osa sisust, mille kasutaja {$a->userfullname} on {$a->date} alla laadinud lehelt <a href="{$a->courselink}">{$a->Coursename}</a>.';
$string['contentexport_modulesummary'] = 'See leht on osa sisust, mis on alla laaditud lehelt <a href="{$a->modulelink}"> {$a-> modulename}</a>kuupäeval {$a->date}. Pane tähele, et osa sisust ja failidest, mis on suuremad kui {$a->maxfilesize}, ei laadita alla.';
$string['contentexport_viewfilename'] = 'Vaata faili {$a}';
$string['continue'] = 'Jätka';
$string['continuetocourse'] = 'Kursuselehele sisenemiseks klõpsake siin';
$string['convertingwikitomarkdown'] = 'Konverteerin Wiki formaadist märgenditega formaati';
$string['cookiesenabled'] = 'Teie brauseris peavad olema lubatud küpsisefailid';
$string['cookiesenabled_help'] = 'See sait kasutab kahte küpsisefaili:

Põhiline on seansiküpsisefail (enamasti nimega MoodleSession). Peate selle küpsisefaili brauseris lubama andmejärjepidevuse ja sisselogituks jäämise tagamiseks. Kui logite välja või brauseri sulgete, siis see küpsisefail hävitatakse (teie brauseris ja serveris).

Teine küpsisefail on mugavuse pärast (enamasti nimega MOODLEID). See küpsisefail on mõeldud teie kasutajanime meeles pidamiseks. See tähendab, et kui pöördute sellele saidile tagasi, on kasutajanime väli juba täidetud. Võite sellest küpsisefailist ka keelduda – peate sel juhul sisselogimisel iga kord uuesti oma kasutajanime sisestama.';
$string['cookiesenabled_help_html'] = 'Sellel saidil kasutatakse kahte küpsist:<br/><br/>

Oluline on sessiooniküpsis, mida tavaliselt nimetatakse "MoodleSession". Te peate selle küpsise oma brauseris lubama, et tagada järjepidevus ja jääda veebilehe sirvimisel sisse logitud. Kui logite välja või sulgete brauseri, hävitatakse see küpsis (teie brauseris ja serveris).
<br/><br/>

Teine küpsis on puhtalt mugavuse huvides, tavaliselt nimetatakse seda "MOODLEID" vms. See lihtsalt jätab teie kasutajanime brauseris meelde. See tähendab, et kui te sellele veebisaidile tagasi tulete, on kasutajanime väli sisselogimislehel juba teie jaoks täidetud. Sellest küpsisest on ohutu keelduda - peate lihtsalt oma kasutajanime iga kord uuesti sisestama, kui logite sisse.';
$string['cookiesenabledonlysession'] = 'Sinu veebilehitseja peab lubama "küpsised"';
$string['cookiesenabledonlysession_help'] = 'See sait kasutab ühte sessiooniküpsist, mida tavaliselt nimetatakse MoodleSessioniks. Pead lubama, et see küpsis oma brauseris tagaks järjepidevuse ja jääks saidi sirvimisel sisse logima. Kui logid välja või sulged brauser, hävitatakse see küpsis (sinu brauseris ja serveris).';
$string['cookiesnotenabled'] = 'Kahjuks pole küpsisefailid teie veebibrauseris lubatud.';
$string['cookiesnotice'] = 'Teave küpsiste kohta';
$string['copy'] = 'kopeeri';
$string['copyasnoun'] = 'kopeeri';
$string['copycourse'] = 'Kopeeri kursus';
$string['copyingcoursefiles'] = 'Kopeeri kursuse failid';
$string['copyingsitefiles'] = 'Kopeeritakse keskkonna faile mis on kasutatud kursusel';
$string['copyinguserfiles'] = 'Kopeeri kasutaja failid';
$string['copyingzipfile'] = 'Kopeeri kokkupakitud fail';
$string['copyrightnotice'] = 'Autoriõiguse teave';
$string['coresystem'] = 'Süsteem';
$string['cost'] = 'Hind';
$string['costdefault'] = 'Vaikimisi maksumus';
$string['counteditems'] = '{$a->count} {$a->items}';
$string['country'] = 'Riik';
$string['course'] = 'Kursus';
$string['courseadministration'] = 'Kursuse haldamine';
$string['courseapprovedemail'] = 'Sinu kursuse ("{$a->name}") taotlus on kinnitatud ja sind on määratud sellel kursusel {$a->teacher} rolli. Kursusele sisenemiseks ava aadress {$a->url}';
$string['courseapprovedemail2'] = 'Teie kursuse „{$a->name}“ taotlus on rahuldatud. Oma uuele kursusele juurdepääsuks avage veebileht {$a->url}';
$string['courseapprovedfailed'] = 'Kursuse kinnitatuna salvestamine nurjus.';
$string['courseapprovedsubject'] = 'Teie kursus on kinnitatud!';
$string['courseavailable'] = 'See kursus on õppijatele avatud';
$string['courseavailablenot'] = 'See kursus pole õppijatele avatud';
$string['coursebackup'] = 'Kursuse varukoopia tegemine';
$string['coursebulkaction'] = 'Valitud kursuste hulgitoimingud';
$string['coursecategories'] = 'Kursuste kategooriad';
$string['coursecategory'] = 'Kursuse kategooria';
$string['coursecategory_help'] = 'Selle sättega määratakse kategooria, kus kursus kursuseloendis kuvatakse.';
$string['coursecategorydeleted'] = 'Kursuse kategooria {$a} on kustutatud';
$string['coursecatmanagement'] = 'Kursuste ja kategooriate haldus';
$string['coursecompletion'] = 'Kursuse lõpetamise jälgimine';
$string['coursecompletions'] = 'Kursuse lõpetamised';
$string['coursecreators'] = 'Kursuse looja';
$string['coursecreatorsdescription'] = 'Kursuse loojad võivad luua uusi kursusi.';
$string['coursedeleted'] = 'Kursus {$a} on kustutatud';
$string['coursedetails'] = 'Kursuse üksikasjad';
$string['coursedisplay'] = 'Kursuse paigutus';
$string['coursedisplay_help'] = 'Selle sättega määratakse, kas kogu kursuse sisu kuvatakse ühel lehel või jagatakse mitme lehe peale laiali.';
$string['coursedisplay_multi'] = 'Kuva igal lehel üks jaotis';
$string['coursedisplay_single'] = 'Kuva ühel lehel kõik jaotised';
$string['courseduration'] = 'Kursuse kestus';
$string['courseduration_desc'] = 'Kursuse kestust kasutatakse kursuse vaikelõppkuupäeva arvutamiseks. Kursuse lõppkuupäeva kasutatakse ainult aruannetes. Siiski saavad kasutajad kursusega liituda ka pärast selle lõppkuupäeva.';
$string['courseenddateenabled'] = 'Kursuse lõppkuupäev on vaikimisi lubatud';
$string['courseenddateenabled_desc'] = 'See säte määrab, kas uute kursuste jaoks lubatakse vaikimisi kursuse lõppkuupäev ja kas see arvutatakse kursuse kestusest arvutatud kuupäeva järgi.';
$string['courseextendednamedisplay'] = '{$a->shortname} {$a->fullname}';
$string['coursefiles'] = 'Kursuse pärandfailid';
$string['coursefilesedit'] = 'Muuda kursuse pärandfaile';
$string['coursefileswarning'] = 'Kursuse failid on iganenud';
$string['coursefileswarning_help'] = 'Kursusefailide ala pole enam alates versioonist Moodle 2.0 kasutusel, kasutage võimalikult palju välishoidlaid.';
$string['courseformatdata'] = 'Kursuse vormingu andmed';
$string['courseformatoptions'] = '{$a}: vormingu valikud';
$string['courseformats'] = 'Kursusevormingud';
$string['courseformatudpate'] = 'Uuenda vormingut';
$string['coursegrades'] = 'Kursuse hinded';
$string['courseheader'] = 'Kursuse menüü';
$string['coursehelpcategory'] = 'Positsioneeri kursust kursuste nimekirjas ja see aitab õppijatel selle kergemini ülesleida.';
$string['coursehelpforce'] = 'Iga kursusetegevuse korral saab sundida kasutama kursuserühmarežiimi.';
$string['coursehelpformat'] = 'Kursuse pealeht kuvatakse selles vormingus.';
$string['coursehelphiddensections'] = 'Kuidas kursuse peidetud jaotised õppijatele kuvatakse.';
$string['coursehelpmaximumupload'] = 'Saate määratleda suurima failimahu, mida saab selles kursuses üles laadida. Mahu limiit on määratud saidiülese sättega.';
$string['coursehelpnewsitemsnumber'] = 'Kursuse lehel plokis „Värsked uudised“ kuvatavate teadaannete arv. Kui väärtuseks on määratud null, siis teadaannetefoorumit ei looda.';
$string['coursehelpnumberweeks'] = 'Kursuse jaotiste arv (üksnes teatud kursusevormingute puhul).';
$string['coursehelpshowgrades'] = 'Saate lubada hinnetelehe kuvamise. See ei keela hinnete kuvamist üksiktegevuste juures.';
$string['coursehidden'] = 'See kursus pole praegu õppijatele avatud';
$string['courseinfo'] = 'Kursuse teave';
$string['courselegacyfiles'] = 'Kursuse pärandfailid';
$string['courselegacyfiles_help'] = 'Kursusefailide ala pakub mõningast tagasiühilduvust Moodle’i 1.9 ja varasemate versioonidega.  Kõik failid selles alas on alati saadaval kõikidele kursusel osalejatele (olenemata sellest, kas need on lingitud või mitte) ning ei ole mingit võimalust teada saada, kas mõni neist failidest on Moodle’is kasutusel.

Kui kasutad seda ala kursusefailide talletamiseks, võivad sul tekkida privaatsus- ja turbeprobleemid. Lisaks võib juhtuda, et varundamisel, kursuste importimisel ja sisu jagamisel või taaskasutamisel ei kaasata kõiki faile.  Seetõttu on soovitatav seda ala mitte kasutada, välja arvatud juhul, kui oled täiesti kindel mida teed.';
$string['courselegacyfiles_link'] = 'kursuse failid';
$string['courselegacyfilesofcourse'] = 'Kursuse pärandfailid: {$a}';
$string['coursenotaccessible'] = 'See kursus ei ole avalikult kättesaadav';
$string['courseoverview'] = 'Kursuse ülevaade';
$string['courseoverviewfiles'] = 'Kursuse pilt';
$string['courseoverviewfiles_help'] = 'Kursuse kokkuvõtte failid (pildid) kuvatakse koos kokkuvõttega kursuste loendis.';
$string['courseoverviewfilesext'] = 'Kursuse kokkuvõtte failide laiendused';
$string['courseoverviewfileslimit'] = 'Failide piirarv';
$string['courseoverviewgraph'] = 'Kursuseülevaate diagramm';
$string['courseprofiles'] = 'Kursuse profiilid';
$string['coursereasonforrejecting'] = 'Põhjused, miks kursust ei saa luua.';
$string['coursereasonforrejectingemail'] = 'See saadetakse kursuse registreerijale.';
$string['coursereject'] = 'Lükka tagasi kursuse taotlus';
$string['courserejected'] = 'Kursus on tagasi lükatud ja taotlejat on teavitatud';
$string['courserejectemail'] = 'Kahjuks lükati teie taotletud kursus tagasi. Põhjuseks toodi:

{$a}';
$string['courserejectreason'] = 'Too välja kursuse tagasilükkamise põhjused<br />(info saadetakse kursuse tellijale)';
$string['courserejectsubject'] = 'Teie kursusetaotlus lükati tagasi';
$string['coursereport'] = 'Kursuse aruanne';
$string['coursereports'] = 'Kursuse aruanded';
$string['courserequest'] = 'Kursuse taotlemine';
$string['courserequestdetails'] = 'Taotletava kursuse üksikasjad';
$string['courserequestfailed'] = 'Mingil põhjusel sinu kursusetaotluse salvestamine ebaõnnestus';
$string['courserequestintro'] = 'Kasuta seda vormi et tellida sulle loodav kursus.<br />Lisa piisavalt informatsiooni et<br />lehe administraator mõistaks miks sa seda kursust vajad.';
$string['courserequestreason'] = 'Põhjus, miks soovite seda kursust';
$string['courserequestsuccess'] = 'Teie kursusetaotlus on nüüd salvestatud. Teile saadetakse e-kiri, kus teatatakse, kas teie taotlus kiideti heaks.';
$string['courserequestsupport'] = 'Tugiteave, mis aitab administraatoril taotlusega tegeleda';
$string['courserequestwarning'] = 'Sellele kursusele juurdepääsu taotlev kasutaja registreeritakse automaatselt ja talle määratakse roll {$a}.';
$string['courserestore'] = 'Kursuse taastamine';
$string['coursereuse'] = 'Kursuse taaskasutus';
$string['courses'] = 'Kursused';
$string['coursesearch'] = 'Otsi kursuseid';
$string['coursesearch_help'] = '<p>Saate otsida mitut sõna korraga ja täpsustada otsingut järgmiselt:</p>
<ul>
<li>sõna: otsi tekstist selle sõna kõik vasted;</li>
<li>+sõna: leitakse ainult otsitavale sõnale täpselt vastav sõna.</li>
<li>-sõna: seda sõna sisaldavaid tulemeid ei kaasata.</li>
</ul>';
$string['coursesectionsummaries'] = 'Kursuse jaotisekokkuvõtted';
$string['coursesectiontitle'] = 'Kursus: {$a->course}, {$a->sectionname}: {$a->sectiontitle}';
$string['coursesectiontitlebulkediting'] = 'Hulgimuuda {$a->sectionname}: {$a->sectiontitle} | {$a->course}';
$string['coursesectiontitleediting'] = 'Muuda {$a->sectionname}: {$a->sectiontitle} | {$a->course}';
$string['coursesettings'] = 'Kursuse vaikesätted';
$string['coursesmovedout'] = 'Kursus on üksusest {$a} välja teisaldatud';
$string['coursespending'] = 'Kinnitamist ootavad kursused';
$string['coursestart'] = 'Kursuse algus';
$string['coursesummary'] = 'Kursuse kokkuvõte';
$string['coursesummary_help'] = 'Kursuse lühikokkuvõte kuvatakse kursuseloendis. Kursuse otsimisel otsitakse teksti nii kursusenimedest kui ka kursuse kokkuvõttetekstist.';
$string['coursetitle'] = 'Kursus: {$a->course}';
$string['coursetitlebulkediting'] = 'Hulgimuuda kursust: {$a->course}';
$string['coursetitleediting'] = 'Muuda kursust: {$a->course}';
$string['courseupdates'] = 'Kursuse värskendused';
$string['coursevisibility'] = 'Kursuse nähtavus';
$string['coursevisibility_help'] = 'Selle sättega saate määrata, kas kursus kuvatakse kursuste loendis ja kas õppijatel on sellele juurdepääs. Kui sätte väärtuseks on määratud „Peida“, siis pääsevad kursusele juurde ainult kasutajad, kellel on peidetud kursuste vaatamise tegevusluba (nt õpetajad).';
$string['create'] = 'Loo';
$string['createaccount'] = 'Loo minu uus kasutajakonto';
$string['createcategory'] = 'Loo kategooria';
$string['createfolder'] = 'Loo uus kaust asukohta {$a}';
$string['createnew'] = 'Loo uus';
$string['createnewcategory'] = 'Loo uus kategooria';
$string['createnewcourse'] = 'Loo uus kursus';
$string['createnewsubcategory'] = 'Loo uus alamkategooria';
$string['createsubcategoryof'] = 'Loo kategooriale {$a} alamkategooria';
$string['createuser'] = 'Loo kasutaja';
$string['createziparchive'] = 'Paki  arhiivi';
$string['creatingblocks'] = 'Plokkide loomine';
$string['creatingblocksroles'] = 'Plokkide tasemel rollimääramiste ja alistamiste loomine';
$string['creatingblogsinfo'] = 'Blogi info loomine';
$string['creatingcategoriesandquestions'] = 'Kategooriate ja küsimuste loomine';
$string['creatingcoursemodules'] = 'Kursuse moodulite loomine';
$string['creatingcourseroles'] = 'Plokkide tasemel rollimääramiste ja alistamiste loomine';
$string['creatingevents'] = 'Sündmuste loomine';
$string['creatinggradebook'] = 'Hinnetelehe koostamine';
$string['creatinggroupings'] = 'Grupeeringute loomine';
$string['creatinggroupingsgroups'] = 'Lisatakse grupid grupeeringusse';
$string['creatinggroups'] = 'Rühmade moodustamine';
$string['creatinglogentries'] = 'Logikirjete loomine';
$string['creatingmessagesinfo'] = 'Sõnumite info esitamine';
$string['creatingmodroles'] = 'Luuakse mooduli tasemel rollide määrangud ja õiguste ülekatmised';
$string['creatingnewcourse'] = 'Uue kursuse loomine';
$string['creatingrolesdefinitions'] = 'Rollide defineerimine';
$string['creatingscales'] = 'Skaalade tegemine';
$string['creatingsections'] = 'Sektsioonide tegemine';
$string['creatingtemporarystructures'] = 'Esialgsete struktuuride loomine';
$string['creatinguserroles'] = 'Luuakse kasutaja tasemel rollide määrangud ja õiguste ülekatmised';
$string['creatingusers'] = 'Kasutajate määramine';
$string['creatingxmlfile'] = 'XML faili loomine';
$string['currency'] = 'Valuuta';
$string['currentcourse'] = 'Praegune kursus';
$string['currentcourseadding'] = 'Lisan andmeid käesolevale kursusele';
$string['currentcoursedeleting'] = 'Kustutan käesoleva kursuse esmalt';
$string['currentlanguage'] = 'Kasutatav keel';
$string['currentlocaltime'] = 'kehtiv aeg';
$string['currentpicture'] = 'Kasutatav pilt';
$string['currentrelease'] = 'Praegune väljalasketeave';
$string['currenttheme'] = 'Aktiivne teema';
$string['currentversion'] = 'Kehtiv versioon';
$string['databasechecking'] = 'Moodle’i andmebaasi uuendamine versioonilt {$a->oldversion} versioonile {$a->newversion}';
$string['databaseperformance'] = 'Andmebaasi jõudlus';
$string['databasesetup'] = 'Andmebaasi häälestamine';
$string['databasesuccess'] = 'Andmebaasi uuendamine õnnestus';
$string['databaseupgradebackups'] = 'Varukoopia versioon on praegu {$a}';
$string['databaseupgradeblocks'] = 'Plokkide versioon on praegu {$a}';
$string['databaseupgradegroups'] = 'Rühmade versioon on nüüd {$a}';
$string['databaseupgradelocal'] = 'Kohaliku andmebaasi versioon on nüüd {$a}';
$string['databaseupgrades'] = 'Andmebaasi uuendamine';
$string['dataformats'] = 'Andmevormingud';
$string['date'] = 'Kuupäev';
$string['datechanged'] = 'Kuupäev muudetud';
$string['datemostrecentfirst'] = 'Kuupäev – alates uuemast';
$string['datemostrecentlast'] = 'Kuupäev – alates vanemast';
$string['day'] = 'päev';
$string['days'] = 'päeva';
$string['decodinginternallinks'] = 'Dekodeeri sisemisi linke';
$string['default'] = 'Vaikimisi';
$string['defaultcategoryname'] = 'Kategooria 1';
$string['defaultcompetencescale'] = 'Pädevuse vaikeskaala';
$string['defaultcompetencescaledesc'] = 'Binaarne hinnanguskaala, kus kuvatakse ainult teave selle kohta, kas isik on oskusi tõendanud või mitte.';
$string['defaultcompetencescalenotproficient'] = 'Pole veel pädev';
$string['defaultcompetencescaleproficient'] = 'Pädev';
$string['defaultcoursestudent'] = 'Õppija';
$string['defaultcoursestudentdescription'] = 'Õppijatel on kursusekohaseid õigusi üldiselt vähem.';
$string['defaultcoursestudents'] = 'Õppijad';
$string['defaultcoursesummary'] = 'Kirjuta siia kokkuvõtlik ja huvitav lõik, mis iseloomustab kursust.';
$string['defaultcourseteacher'] = 'Õpetaja';
$string['defaultcourseteacherdescription'] = 'Õpetajad saavad teha kõiki kursusega seotud toiminguid, sh muuta tegevusi ja hinnata õppijaid.';
$string['defaultcourseteachers'] = 'Õpetajad';
$string['defaulteditor'] = 'Vaikeredaktor';
$string['defaulthomepageuser'] = 'Esileht';
$string['defaulthomepageuser_help'] = 'Missugusele lehele sind sisse logimisel järel suunata?';
$string['delete'] = 'Kustuta';
$string['deleteablock'] = 'Kustuta plokk';
$string['deleteall'] = 'Kustuta kõik';
$string['deleteallcannotundo'] = 'Kustuta kõik – ei saa tagasi võtta';
$string['deleteallcomments'] = 'Kõik kommentaarid';
$string['deleteallratings'] = 'Kõik hindamised';
$string['deletecategory'] = 'Kustuta kategooria {$a}';
$string['deletecategorycheck'] = 'Kas oled täiesti kindel, et soovid kustutada seda kategooriat <b>\'{$a}\'</b>?<br />Kõik kursused liigutatakse peakategooriasse (kui see eksisteerib), või kategooriasse "Varia".';
$string['deletecategorycheck2'] = 'Kui sa kustutad selle kategooria, sa pead valima mida teha kursustega ja alamkategooriatega, mida ta sisaldas';
$string['deletecategoryempty'] = 'See kategooria on tühi.';
$string['deletecheck'] = 'Kas soovite kategooria {$a} kustutada?';
$string['deletecheckfiles'] = 'Kas oled täiesti kindel, et soovid neid faile kustutada?';
$string['deletecheckfull'] = 'Kas soovite kindlasti kustutada kasutaja {$a} ning tema kursustele registreerumised, tegevuse ja muud kasutajaandmed?';
$string['deletechecktype'] = 'Kas soovite kategooria {$a->type} kindlasti kustutada?';
$string['deletechecktypename'] = 'Kas soovite üksuse {$a->type} "{$a->name}" kindlasti kustutada?';
$string['deletecheckwarning'] = 'Oled kustutamas neid faile';
$string['deletecommentbyon'] = 'Kustuta kasutaja {$a->user} kommentaar teemas {$a->time}.';
$string['deletecompletely'] = 'Kustuta lõplikult';
$string['deletecourse'] = 'Kustuta kursus';
$string['deletecoursecheck'] = 'Kas soovite selle kursuse ja kõik selles sisalduvad andmed kindlasti kustutada?';
$string['deleted'] = 'Kustutatud';
$string['deletedactivity'] = 'Kustutatud: {$a}';
$string['deletedcourse'] = '{$a} on jäädavalt kustutatud';
$string['deletednot'] = 'Üksust {$a} ei saa kustutada.';
$string['deletepicture'] = 'Kustuta';
$string['deletesection'] = 'Kustuta';
$string['deleteselected'] = 'Kustuta valitud';
$string['deleteselectedkey'] = 'Kustuta valitud võti';
$string['deletingcourse'] = 'Kursuse {$a} kustutamine';
$string['deletingexistingcoursedata'] = 'Kustuta olemasoleva kursuse andmed';
$string['deletingolddata'] = 'Kustuta vanad andmed';
$string['department'] = 'Osakond';
$string['deprecatedeventname'] = '{$a} (pole enam kasutusel)';
$string['desc'] = 'Kahanevalt';
$string['description'] = 'Kirjeldus';
$string['deselectall'] = 'Tühjenda kõik ruudud';
$string['deselectnos'] = 'Tühista kõik valikud „Ei”';
$string['detailedless'] = 'Vähem detailsem';
$string['detailedmore'] = 'Rohkem detailsem';
$string['details'] = 'Detailid';
$string['digitalminor'] = 'Digitaalne monitor';
$string['digitalminor_desc'] = 'Palu oma vanemal/hooldajal kontakteeruda:';
$string['directory'] = 'Kataloog';
$string['disable'] = 'Keela';
$string['disabledcomments'] = 'Kommentaarid on keelatud';
$string['dismissnotification'] = 'Loobu sellest teatest';
$string['displayingfirst'] = 'Ainult esimesed {$a->count} {$a->things} on näidatud';
$string['displayingrecords'] = 'Kuvatakse {$a} kirjet';
$string['displayingusers'] = 'Näitan kasutajaid {$a->start} kuni {$a->end}';
$string['displayonpage'] = 'Kuva lehel';
$string['dndcourse'] = 'Kursuse lohistamise abil saab kursuse sortimisjärjekorda muuta või kursuse mõnda muusse kategooriasse teisaldada.';
$string['dndenabled_inbox'] = 'Failide lisamiseks saate need siia lohistada.';
$string['dndnotsupported'] = 'Lohistamise abil üleslaadimist ei toetata';
$string['dndnotsupported_help'] = 'Teie veebilehitseja ei toeta lohistamise abil üleslaadimist.<br />See funktsioon on saadaval Chrome, Firefox ja Safari uuemates versioonides ning Internet Explorer versioonis v10 või uuemas.';
$string['dndnotsupported_insentence'] = 'lohistamist ei toetata';
$string['dnduploadwithoutcontent'] = 'Üleslaaditud failil puudub sisu';
$string['dndworkingfile'] = 'Failide üleslaadimiseks lohistage need kursusejaotiste peale';
$string['dndworkingfilelink'] = 'Failide või linkide üleslaadimiseks lohistage need kursuse jaotiste peale';
$string['dndworkingfiletext'] = 'Failide või tekstide üleslaadimiseks lohistage need kursuse jaotiste peale';
$string['dndworkingfiletextlink'] = 'Failide, tekstide või linkide üleslaadimiseks lohistage need kursuse jaotiste peale';
$string['dndworkinglink'] = 'Linkide üleslaadimiseks lohistage soovitud lingid kursuse jaotiste peale';
$string['dndworkingtext'] = 'Teksti üleslaadimiseks lohistage see kursuse jaotiste peale';
$string['dndworkingtextlink'] = 'Teksti või linkide üleslaadimiseks lohistage need kursuse jaotiste peale';
$string['documentation'] = 'Moodle’i dokumentatsioon';
$string['dontsortcategories'] = 'Ära sordi kategooriaid';
$string['dontsortcourses'] = 'Ära sordi kursusi';
$string['down'] = 'Alla';
$string['download'] = 'Laadi alla';
$string['downloadall'] = 'Laadi kõik alla';
$string['downloadexcel'] = 'Laadi alla Exceli formaadis';
$string['downloadfile'] = 'Laadi fail alla';
$string['downloadods'] = 'Laadi alla Open Office’i vormingus';
$string['downloadtext'] = 'Laadi alla tekstiformaadis';
$string['doyouagree'] = 'Kas olete need tingimused läbi lugenud ja neist aru saanud?';
$string['droptoupload'] = 'Aseta failid üleslaadimiseks siia';
$string['duplicate'] = 'Dubleeri';
$string['duplicatedmodule'] = '{$a} (koopia)';
$string['duplicatedsection'] = '{$a} (koopia)';
$string['edhelpaspellpath'] = 'Selles redaktoris õigekirjakontrolli kasutamiseks PEAB teil olema serverisse installitud <strong>Aspell 0.50</strong> või uuem versioon ja peate Aspelli täitmisfaili jaoks määrama õige juurdepääsutee. Unixis ja Linuxis on see tee tavaliselt <strong>/usr/bin/aspell</strong>, aga võib olla ka teistsugune.';
$string['edhelpbgcolor'] = 'Defineeri toimeti taustavärv <br /> Sobivad väärtused on näiteks #ffffff või white';
$string['edhelpcleanword'] = 'See seadistus lülitab sisse või välja Wordi-spetsiifilise formaadi filtreerimise.';
$string['edhelpenablespelling'] = 'Lülita sisse või välja õigekirja kontroll. Sisse lülitatuna peab serveris olema installeeritud <strong>aspell</strong>.
Teine väärtus on <strong>vaikimisi sõnastik </strong>. Seda väärtust kasutatakse, kui aspell\'il pole kasutaja keele sõnastikku.';
$string['edhelpfontfamily'] = 'Fondiperekonna atribuut on nimekiri fondiperekondade nimedest ja/või geneeriliste perekondade nimedest. Perekondade nimed tuleb eraldada komadega.';
$string['edhelpfontlist'] = 'Defineeri fondid, mida kasutatakse toimeti rippmenüüs.';
$string['edhelpfontsize'] = 'Vaikimisi fondisuurus määrab fondi suuruse. <br />Sobivad väärtused on näiteks : medium, large, smaller, larger, 10pt, 11px.';
$string['edit'] = 'Muuda';
$string['edita'] = 'Muuda {$a}';
$string['editcategorysettings'] = 'Muuda kategooria sätteid';
$string['editcategorythis'] = 'Muuda seda kategooriat';
$string['editcoursesettings'] = 'Muuda kursuse sätteid';
$string['editfiles'] = 'Muuda faile';
$string['editgroupprofile'] = 'Muuda rühma profiili';
$string['editinga'] = 'Üksuse {$a} muutmine';
$string['editingteachershort'] = 'Toimetaja';
$string['editlock'] = 'Seda väärtust ei saa muuta.';
$string['editmode'] = 'Redigeerimisrežiim';
$string['editmyprofile'] = 'Muuda profiili';
$string['editorbgcolor'] = 'Tausta värv';
$string['editorcleanonpaste'] = 'Kleepimisel eemalda Word`i HTML';
$string['editorcommonsettings'] = 'Üldised seaded';
$string['editordefaultfont'] = 'Vaikimisi font';
$string['editorenablespelling'] = 'Lülita sisse õigekirja kontroll';
$string['editorfontlist'] = 'Fondiloend';
$string['editorfontsize'] = 'Vaike-fondisuurus';
$string['editorpreferences'] = 'Redaktori sätted';
$string['editorresettodefaults'] = 'Taasta vaikeväärtustele';
$string['editorsettings'] = 'Redaktori sätted';
$string['editorshortcutkeys'] = 'Redaktori kiirklahvid';
$string['editsection'] = 'Muuda seadeid';
$string['editsectionname'] = 'Muuda setsiooni nime';
$string['editsectionsettings'] = 'Muuda sektsiooni seadeid';
$string['editsectiontitle'] = 'Muuda sektsiooni: {$a}';
$string['editsettings'] = 'Muuda sätteid';
$string['editsummary'] = 'Muuda kokkuvõtet';
$string['editthisactivity'] = 'Muuda tegevust';
$string['editthiscategory'] = 'Muuda seda kategooriat';
$string['edittitle'] = 'Muuda pealkirja';
$string['edittitleinstructions'] = 'Loobumiseks vajutage klaviatuuril paoklahvi (Esc), salvestamiseks vajutage sisestusklahvi (Enter)';
$string['edituser'] = 'Muuda kasutajakontosid';
$string['edulevel'] = 'Kõik sündmused';
$string['edulevel_help'] = '* Õpetamine: õpetaja tehtud toimingud, nt materjali värskendamine
* Osalemine: õppijate tehtud toimingud, nt foorumisse postitamine
* Muu: mõne muu rolliga (mitte õpetaja ega õppija) kasutaja tehtud toimingud';
$string['edulevelother'] = 'Muu';
$string['edulevelparticipating'] = 'Osaleb';
$string['edulevelteacher'] = 'Õpetab';
$string['email'] = 'Meiliaadress';
$string['emailactive'] = 'Meiliaadress on aktiveeritud';
$string['emailagain'] = 'Meiliaadress (uuesti)';
$string['emailalreadysent'] = 'Parooli lähtestamise e-kiri on juba saadetud. Palun vaata oma postkasti.';
$string['emailcharset'] = 'Meilisõnumi märgistik';
$string['emailconfirm'] = 'Kinnitage oma kasutajakonto';
$string['emailconfirmation'] = 'Tere,

Õpikeskkonnas \'{$a->sitename}\' on teie meiliaadressiga taotletud uue kasutajakonto loomist.

Uue kasutajakonto kinnitamiseks avage järgmine veebileht:

{$a->link}

Enamikus meiliprogrammides peaks see veebiaadress olema kuvatud sinise lingina, mida saab klõpsata. Kui see ei toimi, siis kopeerige aadress brauseri aadressiribale.

Abi saamiseks pöörduge õpikeskkonna administraatori {$a->admin} poole.';
$string['emailconfirmationresend'] = 'Saada kinnitusmail uuesti';
$string['emailconfirmationsubject'] = '{$a}: kasutajakonto kinnitamine';
$string['emailconfirmsent'] = '<p>Teie meiliaadressile <B>{$a}</B> saadeti kiri.</p>
   <p>See sisaldab lihtsaid juhiseid, kuidas registreerimine lõpule viia.</p>
   <p>Probleemide korral pöörduge õpikeskkonna administraatori poole.</p>';
$string['emailconfirmsentfailure'] = 'Kinnitusmaili saatmine ebaõnnestus';
$string['emailconfirmsentsuccess'] = 'Kinnistusmaili saatmine õnnestus';
$string['emaildigest'] = 'Meilitsi saadetava kokkuvõtte liik';
$string['emaildigest_help'] = 'See on päevakokkuvõtete säte, mida foorumid kasutavad vaikimisi.

* Kokkuvõtet pole – teile saadetakse iga foorumipostituse kohta üks meilisõnum;
* kokkuvõte, täielikud postitused – teile saadetakse iga päev kokkuvõte kõigi foorumipostituste sisust;
* kokkuvõte, ainult teemad – teile saadetakse iga päev kokkuvõte kõigi foorumipostituste teemadest.

Soovi korral saate igas foorumis eri sätte valida.';
$string['emaildigestcomplete'] = 'Täielik (iga päeva kohta meilisõnum koos täispikkade postitustega)';
$string['emaildigestoff'] = 'Ilma kokkuvõtteta (üks meilisõnum iga foorumipostituse kohta)';
$string['emaildigestsubjects'] = 'Pealkirjad (iga päeva kohta meilisõnum ainult koos pealkirjadega)';
$string['emaildisable'] = 'See meiliaadress on keelatud';
$string['emaildisableclick'] = 'Sellele meiliaadressile saatmise keelamiseks klõpsake siin';
$string['emaildisplay'] = 'Kuva e-mail';
$string['emaildisplay_help'] = '* Peidetud - Ainult suuremate rolliõigustega kasutajad (õpetajad, haldurid, kasutajatugi jne) näevad sinu meiliaadressi
* Nähtav kõigile - Kõik kasutajad selles keskkonnas näevad sinu meiliaadressi
* Nähtav kursusel osalejatele - Ainult sinu kursustel osalejad näevad sinu meiliaadressi';
$string['emaildisplaycourse'] = 'Nähtav kursusel osalejatele';
$string['emaildisplaycoursemembersonly'] = '(Nähtav teistele kursusel osalejatele)';
$string['emaildisplayeveryone'] = '(Kõikidele nähtav)';
$string['emaildisplayhide'] = '(Peidetud kõikide tavaõigustega kasutajate eest)';
$string['emaildisplayno'] = 'Peidetud';
$string['emaildisplayyes'] = 'Kõigile nähtav';
$string['emailenable'] = 'See meiliaadress on lubatud';
$string['emailenableclick'] = 'Sellele meiliaadressile saatmise uuesti lubamiseks klõpsake siin';
$string['emailexists'] = 'See meiliaadress on juba kasutusel.';
$string['emailexistshintlink'] = 'Taasta unustatud kasutajanimi või parool';
$string['emailexistssignuphint'] = 'Võib-olla oled sa varasemalt juba kasutajakonto loonud? {$a}';
$string['emailformat'] = 'Meilisõnumi vorming';
$string['emailmustbereal'] = 'Märkus: sinu e-posti aadress peab olema reaalselt eksisteeriv';
$string['emailnotallowed'] = 'Järgmiste domeenide meiliaadressid pole lubatud: {$a}';
$string['emailnotfound'] = 'Seda meiliaadressi andmebaasist ei leitud';
$string['emailonlyallowed'] = 'See meiliaadress pole üks nendest, mis on lubatud ({$a})';
$string['emailpasswordchangeinfo'] = 'Tere, {$a->firstname}!

Keegi (tõenäoliselt teie ise) on taotlenud teie konto jaoks õpikeskkonnas {$a->sitename} uut parooli.

Parooli muutmiseks avage järgmine veebileht:

{$a->link}

Enamikus meiliprogrammides peaks see veebiaadress olema kuvatud sinise klõpsatava lingina. Kui see ei toimi, siis kopeerige aadress brauseri aadressiribale.

Abi saamiseks pöörduge õpikeskkonna administraatori {$a->admin} poole.';
$string['emailpasswordchangeinfodisabled'] = 'Tere, {$a->firstname}!

Keegi (tõenäoliselt teie ise) on taotlenud teie konto jaoks õpikeskkonnas „{$a->sitename}“ uut parooli.

Kahjuks on teie konto selles õpikeskkonnas keelatud ja parooli ei saa lähtestada. Pöörduge saidi administraatori {$a->admin} poole.';
$string['emailpasswordchangeinfofail'] = 'Tere, {$a->firstname}!

Keegi (tõenäoliselt teie ise) on taotlenud teie konto jaoks õpikeskkonnas „{$a->sitename}“ uut parooli.

Kahjuks ei saa selles õpikeskkonnas paroole muuta. Pöörduge saidi administraatori {$a->admin} poole.';
$string['emailpasswordchangeinfosubject'] = '{$a}: Muuda parooliteavet';
$string['emailpasswordconfirmation'] = 'Tere, {$a->firstname}!

Keegi (tõenäoliselt teie ise) on taotlenud teie konto jaoks õpikeskkonnas {$a->sitename} uut parooli.

Kinnitamiseks ja uue parooli meilitsi saamiseks avage järgmine veebileht:

{$a->link}.

Enamikus meiliprogrammides peaks see veebiaadress olema kuvatud sinise klõpsatava lingina. Kui see ei toimi, siis kopeerige aadress brauseri aadressiribale.

Abi saamiseks pöörduge õpikeskkonna administraatori {$a->admin} poole.';
$string['emailpasswordconfirmationsubject'] = '{$a}: parooli muutmise kinnitus';
$string['emailpasswordconfirmmaybesent'] = '<p>Kui sisestasite õige kasutajanime või meiliaadressi, siis peaks teile olema saadetud meilisõnum.</p>
<p>See sisaldab hõlpsalt täidetavaid juhiseid parooli muutmise kinnitamise ja lõpuleviimise kohta.
Probleemide korral pöörduge õpikeskkonna administraatori poole.</p>';
$string['emailpasswordconfirmnoemail'] = '<p>Määratud kasutajakontol pole meiliaadressi registreeritud.</p>
   <p>Pöörduge saidi administraatori poole.</p>';
$string['emailpasswordconfirmnotsent'] = '<p>Sisestatud kasutajaandmete põhjal ei tuvastatud ühtegi kasutajakontot.</p>
   <p>Kontrollige sisestatud teavet ja proovige uuesti.
Probleemide korral pöörduge õpikeskkonna administraatori poole.</p>';
$string['emailpasswordconfirmsent'] = 'Teie meiliaadressile <b>{$a}</b> on saadetud meilisõnum.
<br />See sisaldab hõlpsalt täidetavaid juhiseid parooli muutmise kinnitamise ja lõpuleviimise kohta.
Probleemide korral pöörduge õpikeskkonna administraatori poole.';
$string['emailpasswordsent'] = 'Täname teid parooli muutmise kinnitamise eest.
Teie meiliaadressile <b>{$a->email}</b> saadeti meilisõnum, mis sisaldab uut parooli.<br />
Uus parool loodi automaatselt. <a href={$a->link}>Võite parooli</a> muuta, et seda oleks kergem meeles pidada.';
$string['emailresetconfirmation'] = 'Tere, {$a->firstname}!

Teie konto (kasutajanimi {$a->username}) parool saidil {$a->sitename} sooviti lähtestada.

Selle soovi kinnitamiseks ja kontole uue parooli määramiseks avage järgmine veebiaadress:

{$a->link}
(See link kehtib {$a->resetminutes} minutit alates lähtestamissoovi esitamisest).

Kui te ei soovinud parooli vahetada, ei pea te midagi tegema.

Abi saamiseks pöörduge õpikeskkonna administraatori {$a->admin} poole.';
$string['emailresetconfirmationsubject'] = '{$a}: parooli lähtestamine';
$string['emailresetconfirmsent'] = 'Teie meiliaadressile <b>{$al}</b> saadeti kiri.
<br />See sisaldab hõlpsalt täidetavaid juhiseid parooli muutmise kinnitamise ja lõpuleviimise kohta.
Probleemide korral pöörduge õpikeskkonna administraatori poole.';
$string['emailstop'] = 'Keela teatised';
$string['emailtoprivatefiles'] = 'Samuti saate failid saata meilimanustena otse oma isiklike failide hulka. Lihtsalt manustage failid meilisõnumile ja saatke see aadressile {$a}.';
$string['emailtoprivatefilesdenied'] = 'Teie administraator on keelanud isiklike failide üleslaadimise.';
$string['emailvia'] = '{$a->name} (saidi {$a->siteshortname} kaudu)';
$string['emojicategoryactivities'] = 'Tegevused';
$string['emojicategoryanimalsnature'] = 'Loomad ja loodus';
$string['emojicategoryflags'] = 'Lipud';
$string['emojicategoryfooddrink'] = 'Toit ja joogid';
$string['emojicategoryobjects'] = 'Objektid';
$string['emojicategoryrecent'] = 'Viimatine';
$string['emojicategorysmileysemotion'] = 'Emotikonid';
$string['emojicategorysymbols'] = 'Sümbolid';
$string['emojicategorytravelplaces'] = 'Reisimine ja riigid';
$string['emptycmids'] = 'Tühjenda kursusemooduli ID\'d';
$string['emptydragdropregion'] = 'tühi piirkond';
$string['emptysectionids'] = 'Tühjenda sektsiooni ID\'d';
$string['enable'] = 'Luba';
$string['encryptedcode'] = 'Krüptitud kood';
$string['enddate'] = 'Kursuse lõppkuupäev';
$string['enddate_help'] = 'Kursuse lõppkuupäeva kasutatakse ainult aruannetes. Siiski saavad kasutajad kursusega liituda ka pärast selle lõppkuupäeva.';
$string['enddatewithtaskenabled'] = 'Kursuse lõppkuupäev';
$string['enddatewithtaskenabled_help'] = 'Kuupäev, millest alates on kursus õppuritele peidetud ja neil ei ole sellele enam ligipääsu.';
$string['english'] = 'inglise';
$string['enrolmentmethods'] = 'Kursusele registreerumise viisid';
$string['entercourse'] = 'Klõpsake kursusele sisenemiseks';
$string['enteremail'] = 'Sisesta oma e-posti aadress';
$string['enteremailaddress'] = 'Sisesta oma e-posti aadress, et õpikeskkond saaks genereerida uue parooli ja saata selle sinu e-posti aadressile.';
$string['enterusername'] = 'Sisesta oma kasutajatunnus';
$string['entries'] = 'Sissekanded';
$string['error'] = 'Tõrge';
$string['errorcreatingactivity'] = 'Tegevuse „{$a}“ eksemplari ei saa luua.';
$string['errorfiletoobig'] = 'Faili maht ületab lubatud {$a} baiti';
$string['errornouploadrepo'] = 'Selle saidi jaoks pole saadaval ühtegi üleslaaditud failide hoidlat.';
$string['errorwhenconfirming'] = 'Kinnitamist ei viidud lõpule, sest tekkis tõrge. Kui klõpsasite meilisõnumis olnud linki, kontrollige, ega link olnud katkenud või mitmel real. Vajaduse korral kopeerige ja kleepige see link.';
$string['eventcommentcreated'] = 'Kommentaar on loodud';
$string['eventcommentdeleted'] = 'Kommentaar on kustutatud';
$string['eventcommentsviewed'] = 'Kommentaare on vaadatud.';
$string['eventconfiglogcreated'] = 'Konfiguratsioonilogi on loodud';
$string['eventcontentviewed'] = 'Sisu on vaadatud.';
$string['eventcoursebackupcreated'] = 'Kursuse koopia loodud';
$string['eventcoursecategorycreated'] = 'Kategooria on loodud';
$string['eventcoursecategorydeleted'] = 'Kategooria on kustutatud';
$string['eventcoursecategoryupdated'] = 'Kategooria on värskendatud';
$string['eventcoursecategoryviewed'] = 'Kategooriat on vaadatud';
$string['eventcoursecontentdeleted'] = 'Kursuse sisu on kustutatud';
$string['eventcoursecreated'] = 'Kursus on loodud';
$string['eventcoursedeleted'] = 'Kursus on kustutatud';
$string['eventcourseended'] = 'Kursus lõppes';
$string['eventcourseinformationviewed'] = 'Kursuse kokkuvõtet on vaadatud';
$string['eventcoursemodulecreated'] = 'Kursusemoodul on loodud';
$string['eventcoursemoduledeleted'] = 'Kursusemoodul on kustutatud';
$string['eventcoursemoduleinstancelistviewed'] = 'Kursusemooduli eksemplaride loendit on vaadatud.';
$string['eventcoursemoduleupdated'] = 'Kursusemoodul on värskendatud';
$string['eventcoursemoduleviewed'] = 'Kursusemoodulit on vaadatud.';
$string['eventcourseresetended'] = 'Kursuse lähtestamine on lõpetatud';
$string['eventcourseresetstarted'] = 'Kursuse lähtestamine on käivitatud';
$string['eventcourserestored'] = 'Kursus on taastatud';
$string['eventcoursesectioncreated'] = 'Kursuse jaotis on loodud';
$string['eventcoursesectiondeleted'] = 'Kursuse jaotis on kustutatud';
$string['eventcoursesectionupdated'] = 'Kursuse jaotis on värskendatud';
$string['eventcoursessearched'] = 'Kursuseid on otsitud';
$string['eventcoursestarted'] = 'Kursus algas';
$string['eventcourseupdated'] = 'Kursus on värskendatud';
$string['eventcourseuserreportviewed'] = 'Kursuse kasutajaaruannet on vaadatud.';
$string['eventcourseviewed'] = 'Kursust on vaadatud.';
$string['eventdashboardreset'] = 'Töölaud on lähtestatud';
$string['eventdashboardsreset'] = 'Töölauad on lähtestatud';
$string['eventdashboardviewed'] = 'Töölauda on vaadatud';
$string['eventdatabasetextfieldcontentreplaced'] = 'Andmebaasi globaalne otsing ja asendamine';
$string['eventemailfailed'] = 'Meilisõnumi saatmine nurjus.';
$string['eventmycoursesviewed'] = 'Minu vaadatud kursused';
$string['eventname'] = 'Sündmuse nimi';
$string['eventrecentactivityviewed'] = 'Viimatist tegevust on vaadatud.';
$string['eventsearchindexed'] = 'Otsinguandmed on indekseeritud';
$string['eventsearchresultsviewed'] = 'Otsingutulemeid on vaadatud';
$string['eventsectionviewed'] = 'Sektsioon vaadatud';
$string['eventunknownlogged'] = 'Tundmatu sündmus';
$string['eventurlblocked'] = 'URL on blokeeritud';
$string['eventusercreated'] = 'Kasutaja on loodud';
$string['eventuserdeleted'] = 'Kasutaja on kustutatud';
$string['eventuserfeedbackgiven'] = 'Tagasiside lingile on vajutatud';
$string['eventuserfeedbackremind'] = 'Tuleta hiljem meelde, et tagasiside lingile on vajutatud';
$string['eventuserinfocategorycreated'] = 'Kasutajaprofiilil välja kategooria loodud';
$string['eventuserinfocategorydeleted'] = 'Kasutaprofiili välja kategooria kustutatud';
$string['eventuserinfocategoryupdated'] = 'Kasutajaprofiili välja kategooria uuendatud';
$string['eventuserinfofieldcreated'] = 'Kasutajaprofiili väli loodud';
$string['eventuserinfofielddeleted'] = 'Kasutajaprofiili väli  kustutatud';
$string['eventuserinfofieldupdated'] = 'Kasutajaprofiili väli uuendatud';
$string['eventuserlistviewed'] = 'Kasutajate loendit on vaadatud';
$string['eventuserloggedout'] = 'Kasutaja logis välja';
$string['eventuserpasswordpolicyfailed'] = 'Kasutaja parool ei vasta reeglitele';
$string['eventuserpasswordupdated'] = 'Kasutaja parool uuendatud';
$string['eventuserprofileviewed'] = 'Kasutajaprofiili on vaadatud';
$string['eventuserupdated'] = 'Kasutaja on värskendatud';
$string['everybody'] = 'Kõik';
$string['executeat'] = 'Käivita';
$string['existing'] = 'Olemasolev';
$string['existingadmins'] = 'Olemasolevad administraatorid';
$string['existingcourse'] = 'Olemasolev kursus';
$string['existingcourseadding'] = 'Lisan andmeid käesolevale kursusele';
$string['existingcoursedeleting'] = 'Kustutan esmalt käesoleva kursuse';
$string['existingcreators'] = 'Olemasolevad kursuse disainerid';
$string['existingstudents'] = 'registreerunud õppijat';
$string['existingteachers'] = 'Olemasolevad õpetajad';
$string['expand'] = 'Laienda';
$string['expandall'] = 'Laienda kõik';
$string['expandcategory'] = 'Laienda {$a}';
$string['explanation'] = 'Selgitus';
$string['explanationdigitalminor'] = 'See teave on vajalik selleks, et teha kindlaks, kas sinu vanus on vanem digitaalse nõusoleku alampiirist. See on vanus, mil üksikisik võib nõustuda tingimustega ning nende andmete seadusliku säilitamise ja töötlemisega.';
$string['extendperiod'] = 'Pikendusperiood';
$string['extendsession'] = 'Pikenda sessiooni';
$string['failedloginattempts'] = '{$a->attempts} nurjunud sisselogimiskatset pärast teie viimast sisselogimist';
$string['favourites'] = 'Lemmikud';
$string['feedback'] = 'Tagasiside';
$string['file'] = 'Fail';
$string['fileexists'] = 'Fail nimega {$a} on juba olemas';
$string['filemissing'] = '{$a} puudub';
$string['filereaderror'] = 'Faili lugemine ebaõnnestus \'{$a}\'. Palun veendu, et tegu on faili, mitte kaustaga.';
$string['files'] = 'Failid';
$string['filesanduploads'] = 'Failid ja üleslaaditud failid';
$string['filesfolders'] = 'Failid/kaustad';
$string['fileuploadwithcontent'] = 'Üleslaaditavad failid ei tohiks sisaldada sisuparameetrit.';
$string['filloutallfields'] = 'Palun täitke kõik väljad';
$string['filter'] = 'Filter';
$string['filteroption'] = '{$a->criteria}: {$a->value}';
$string['filterrowlegend'] = 'Filter {$a}';
$string['filters'] = 'Filtrid';
$string['filtersetmatchdescription'] = 'Kuidas mitmikfiltreid peaks kombineerima';
$string['filtertype'] = 'Filtri tüüp';
$string['findmorecourses'] = 'Otsi veel kursusi...';
$string['first'] = 'Esimene';
$string['firstaccess'] = 'Esimene külastus';
$string['firstname'] = 'Eesnimi';
$string['firstnamephonetic'] = 'Eesnimi (foneetiline)';
$string['firstpage'] = 'Esimene lehekülg';
$string['firstsiteaccess'] = 'Esimene külastus saidil';
$string['firsttime'] = 'Kas olete siin esmakordselt?';
$string['folder'] = 'Kaust';
$string['folderclosed'] = 'Suletud kaust';
$string['folderopened'] = 'Avatud kaust';
$string['followingoptional'] = 'Järgnevad punktid on valikulised';
$string['followingrequired'] = 'Järgnevad punktid on kohustuslikud';
$string['for'] = 'Kasutajale';
$string['force'] = 'Sunni';
$string['forcelanguage'] = 'Sunni keel';
$string['forceno'] = 'Ära sunni';
$string['forcepasswordchange'] = 'Sunni parooli vahetama';
$string['forcepasswordchange_help'] = 'Kui see ruut on märgitud, siis peab kasutaja järgmisel sisselogimisel muutma oma parooli.';
$string['forcepasswordchangecheckfull'] = 'Oled sa täiesti kindel, et soovid sundida {$a} parooli vahetama?';
$string['forcepasswordchangenot'] = 'Parooli muutmise sundimine kasutajale {$a} ebaõnnestus';
$string['forcepasswordchangenotice'] = 'Edasi minemiseks pead muutma oma parooli.';
$string['forcepasswordresetfailurenotice'] = 'Sinu praegune salasõna  ei vasta enam salasõna normidele. Palun võta ühendust oma Moodle\'i administraatoriga.    {$a}';
$string['forcepasswordresetnotice'] = 'Sinu praegune salasõna ei vasta enam salasõna normidele. Sa pead parooli uuendama. {$a}';
$string['forcetheme'] = 'Sunni kujundus';
$string['forgotaccount'] = 'Parool ununenud?';
$string['forgotten'] = 'Oled unustanud oma kasutajanime või parooli?';
$string['forgottenduplicate'] = 'See meiliaadress on seotud mitme kontoga, sisestage hoopis kasutajanimi';
$string['forgotteninvalidurl'] = 'Vigane parooli tühistamise URL';
$string['format'] = 'Vorming';
$string['format_help'] = 'Kursuse vorming määrab kursuse lehe paigutuse.

* Üksiktegevuse vorming – Üksiktegevuse või vahendi (nt test või SCORM-pakett) kuvamiseks kursuse lehel
* Sotsiaalne vorming – kursuse lehel kuvatakse foorum
* Teemade vorming – väga sarnane nädalakava vorminguga, v.a see, et iga „nädalat“ nimetatakse teemaks. „Teema“ pole ajaliselt piiratud. Mingeid kuupäevi määrata ei tule.
* Nädalakava vorming – kursus on organiseeritud nädalate kaupa, konkreetse algus- ja lõppkuupäevaga. Igal nädalal on ette nähtud rida tegevusi. Mõnel neist (nt päevikutel) võivad olla „avatud aknad“ näiteks kahenädalaseks perioodiks, mille lõppedes nad pole enam saadaval.';
$string['formathtml'] = 'HTML-vorming';
$string['formatmarkdown'] = 'Märgenditega vorming';
$string['formatplain'] = 'Lihttekstivorming';
$string['formattext'] = 'Moodle’i automaatvorming';
$string['forumpreferences'] = 'Foorumi sätted';
$string['framesetinfo'] = 'See dokumendikomplekt  sisaldab:';
$string['from'] = 'Alates';
$string['fromdate'] = 'Alates';
$string['fromsender'] = 'Alates';
$string['frontpagecategorycombo'] = 'Liitloend';
$string['frontpagecategorynames'] = 'Kategooriate loend';
$string['frontpagecourselist'] = 'Kursuste loend';
$string['frontpagecoursesearch'] = 'Kursuseotsingu väli';
$string['frontpagedescription'] = 'Esilehe kokkuvõte';
$string['frontpagedescriptionhelp'] = 'Kursuse või õpikeskkonna kokkuvõtte ploki abil saab selle kokkuvõtte kuvada Esilehel.';
$string['frontpageenrolledcourselist'] = 'Registreeritud kursused';
$string['frontpageformat'] = 'Esilehe formaat';
$string['frontpageformatloggedin'] = 'Esilehe formaat pärast sisenemist';
$string['frontpagenews'] = 'Teadaanded';
$string['frontpagesettings'] = 'Esilehe sätted';
$string['fulllistofcourses'] = 'Kõik kursused';
$string['fullname'] = 'Täisnimi';
$string['fullnamecourse'] = 'Kursuse täisnimi';
$string['fullnamecourse_help'] = 'Kursuse nimi, mida kuvatakse Minu kursuste all ja avalehel saada olevate kursuste seas.';
$string['fullnamedisplay'] = '{$a->firstname} {$a->lastname}';
$string['fullnameuser'] = 'Kasutaja täisnimi';
$string['fullprofile'] = 'Terve profiil';
$string['fullsitename'] = 'Õpikeskkonna täisnimi';
$string['functiondisabled'] = 'See funktsioon on hetkel välja lülitatud';
$string['general'] = 'Üldine';
$string['geolocation'] = 'laius- ja pikkuskraad';
$string['gettheselogs'] = 'Too soovitud logid';
$string['go'] = 'Mine';
$string['gpl'] = 'Autoriõigus (C), 1999 ja edaspidi Martin Dougiamas (http://moodle.com)

See programm on vabavara, mida võib levitada ja/või muuta vastavalt Vaba Tarkvara Fondi avaldatud GNU üldise avaliku litsentsi versioonile 2 või teie omal valikul vastavalt mõnele hilisemale versioonile.

Seda programmi levitatakse lootuses, et see programm on kasulik, kuid ILMA IGASUGUSTE GARANTIIDETA, mis on seotud TURUSTATAVUSE või KONKREETSEKS EESMÄRGIKS SOBIVUSEGA.

Lisateavet leiate Moodle’i litsentsiteabe lehelt:
http://www.gnu.org/copyleft/gpl.html';
$string['gpl3'] = 'Autoriõigus (C), 1999 ja edaspidi Martin Dougiamas (http://moodle.com)

See programm on vabavara, mida võib levitada ja/või muuta vastavalt Vaba Tarkvara Fondi avaldatud GNU üldise avaliku litsentsi versioonile 2 või teie omal valikul vastavalt mõnele hilisemale versioonile.

Seda programmi levitatakse lootuses, et see programm on kasulik, kuid ILMA IGASUGUSTE GARANTIIDETA, mis on seotud TURUSTATAVUSE või KONKREETSEKS EESMÄRGIKS SOBIVUSEGA.

Lisateavet leiate Moodle’i litsentsiteabe lehelt:
http://www.gnu.org/copyleft/gpl.html';
$string['gpllicense'] = 'GPL litsents';
$string['gradenoun'] = 'Hinda';
$string['grades'] = 'Hinded';
$string['gradeverb'] = 'Hinda';
$string['gravatarenabled'] = '<a href="http://www.gravatar.com/">Gravatar</a> on selle saidi puhul lubatud. Kui jätate profiilipildi üles laadimata, siis proovib Moodle leida ja laadida alla teie Gravatari profiilipildi.';
$string['group'] = 'Rühm';
$string['groupadd'] = 'Lisa uus rühm';
$string['groupaddusers'] = 'Lisa valitud rühma';
$string['groupfor'] = 'rühmale';
$string['groupinfo'] = 'Teave valitud rühma kohta';
$string['groupinfoedit'] = 'Muuda rühma seadeid';
$string['groupinfomembers'] = 'Valitud kasutajate teave';
$string['groupinfopeople'] = 'Valitud inimeste teave';
$string['groupmembers'] = 'Rühma liikmed';
$string['groupmemberssee'] = 'Kuva rühma liikmed';
$string['groupmembersselected'] = 'Valitud rühma liikmed';
$string['groupmode'] = 'Rühmarežiim';
$string['groupmodeforce'] = 'Jõusta rühmarežiim';
$string['groupmy'] = 'Minu rühm';
$string['groupnonmembers'] = 'Inimesed, kes ei ole rühmas';
$string['groupnotamember'] = 'Kahjuks pole te selle rühma liige';
$string['grouprandomassign'] = 'Määra kõik juhuslikult rühmadesse';
$string['groupremove'] = 'Kustuta valitud rühm';
$string['groupremovemembers'] = 'Eemalda valitud liikmed';
$string['groups'] = 'Rühmad';
$string['groupsnone'] = 'Rühmi pole';
$string['groupsseparate'] = 'Eraldatud rühmad';
$string['groupsvisible'] = 'Nähtavad rühmad';
$string['guest'] = 'Külaliskasutaja';
$string['guestdescription'] = 'Külaliskasutajal on kursusega seotud õigusi vähe ja enamasti ei saa ta kuskil teksti sisestada.';
$string['guestskey'] = 'Luba külalisi, kes omavad võtit';
$string['guestsno'] = 'Ära luba külaliskasutajatel siseneda';
$string['guestsnotallowed'] = 'Kahjuks \'{$a}\' ei luba külalistel sisse logida.';
$string['guestsyes'] = 'Luba külalisi, kellel pole võtit';
$string['guestuser'] = 'Külaliskasutaja';
$string['guestuserinfo'] = 'See on eriline kasutaja, kellel on ainult teatud kursuste lugemisõigus.';
$string['help'] = 'Abiteave';
$string['helpprefix2'] = '{$a} – abi';
$string['helpwiththis'] = 'Abi:';
$string['hiddenassign'] = 'Peidetud ülesanne';
$string['hiddenfromstudents'] = 'Õppijate eest peidetud';
$string['hiddenoncoursepage'] = 'Saadaval, kuid ei kuvata kursuse lehel';
$string['hiddensections'] = 'Peidetud jaotised';
$string['hiddensections_help'] = 'Selle sättega määratakse, kas peidetud jaotised kuvatakse õppijatele ahendatud kujul (nädalavormingus kursuses näiteks vaheaegade tähistamiseks) või on täielikult peidetud.';
$string['hiddensectionscollapsed'] = 'Peidetud jaotised kuvatakse ahendatud kujul';
$string['hiddensectionsinvisible'] = 'Peidetud jaotised on täiesti nähtamatud';
$string['hiddenwithbrackets'] = '(peidetud)';
$string['hide'] = 'Peida';
$string['hideadvancedsettings'] = 'Peida laiendatud seaded';
$string['hidechartdata'] = 'Peida diagrammi andmed';
$string['hidefromstudents'] = 'Peida õppijate eest';
$string['hideoncoursepage'] = 'Tee saadavaks, kuid ära kuva kursuse lehel';
$string['hidepopoverwindow'] = 'Peida spikriaken';
$string['hidesection'] = 'Peida jaotis {$a}';
$string['hidesettings'] = 'Peida seaded';
$string['hideshowblocks'] = 'Peida või kuva plokid';
$string['highlight'] = 'Tõsta esile';
$string['highlighted'] = 'Esile tõstetud';
$string['highlightoff'] = 'Eemalda esiletõst';
$string['hits'] = 'Klõpsud';
$string['hitsoncourse'] = '{$a->username} klõpsud kursusel {$a->coursename}';
$string['hitsoncoursetoday'] = '{$a->username} tänased klõpsud kursusel {$a->coursename}';
$string['home'] = 'Avaleht';
$string['hour'] = 'tund';
$string['hours'] = 'tundi';
$string['howtomakethemes'] = 'Kuidas teha uusi kujundusi?';
$string['htmleditor'] = 'Kasuta HTML-i redaktorit';
$string['htmleditoravailable'] = 'HTML toimeti on saadaval';
$string['htmleditordisabled'] = 'Sa pole oma kasutaja andmetes võimaldanud HTML toimetit.';
$string['htmleditordisabledadmin'] = 'Administraator pole võimaldanud HTML toimetit õpikeskkonnas';
$string['htmleditordisabledbrowser'] = 'HTML toimeti pole saadaval, kuna sa ei kasuta Internet Explorer 5.5 või uuemat versiooni';
$string['htmlfilesonly'] = 'Ainult HTML-failid';
$string['htmlformat'] = 'Kena HTML-vorming';
$string['icon'] = 'Ikoon';
$string['idnumber'] = 'ID-number';
$string['idnumbercourse'] = 'Kursuse ID';
$string['idnumbercourse_help'] = 'Kursuse ID-numbrit kasutatakse üksnes väliste süsteemidega sidumiseks ja seda ei kuvata selle saidi muudes osades. Kui kursusel on ametlik koodnimi, siis võib selle sisestada, muul juhul võib selle välja tühjaks jätta.';
$string['idnumbercoursecategory'] = 'Kategooria ID-number';
$string['idnumbercoursecategory_help'] = 'Kursuse kategooria ID-d kasutatakse ainult kategooria ja välissüsteemide vastavusse viimiseks ning seda ei kuvata saidil üheski muus kohas. Kui kategoorial on ametlik koodnimi, võib selle sisestada, muul juhul võib selle välja tühjaks jätta.';
$string['idnumbergroup'] = 'Rühma ID-number';
$string['idnumbergroup_help'] = 'Rühma ID-d kasutatakse ainult rühma ja välissüsteemide vastavusse viimiseks ning seda ei kuvata saidil üheski muus kohas. Kui rühmal on ametlik koodnimi, võib selle sisestada, muul juhul võib selle välja tühjaks jätta.';
$string['idnumbergrouping'] = 'Rühmakogumi ID-number';
$string['idnumbergrouping_help'] = 'Rühmituse ID-d kasutatakse ainult rühmituse ja välissüsteemide vastavusse viimiseks ning seda ei kuvata saidil üheski muus kohas. Kui rühmitusel on ametlik koodnimi, võib selle sisestada, muul juhul võib selle välja tühjaks jätta.';
$string['idnumbermod'] = 'ID-number';
$string['idnumbermod_help'] = 'ID-numbri abil saab hindearvutuseks tegevuse kindlaks teha. Kui tegevus pole kaasatud ühegi hinde arvutamisse, siis võib ID-numbri välja tühjaks jätta.

ID-numbri võib samuti märkida hinnetelehel, kuigi seda saab muuta ainult tegevuse sätete lehel.';
$string['idnumbertaken'] = 'See ID-number on juba võetud';
$string['imagealt'] = 'Pildi kirjeldus';
$string['import'] = 'Impordi';
$string['importdata'] = 'Impordi kursuse andmed';
$string['importdataexported'] = '"Kust" kursuse andmed eksporditud edukalt.<br />Jätka importimist "kuhu" kursusesse.';
$string['importdatafinished'] = 'Importimine lõpetatud! Jätka oma kursust.';
$string['importdatafrom'] = 'Otsi kursust, kust andmeid importida';
$string['inactive'] = 'Passiivne';
$string['include'] = 'Kaasa';
$string['includeallusers'] = 'Kaasa kõik kasutajad';
$string['includecoursefiles'] = 'Kaasa kursuse failid';
$string['includecourseusers'] = 'Kaasa kursuse kasutajad';
$string['included'] = 'Kaasatud';
$string['includelogentries'] = 'Kaasa logide kirjed';
$string['includemodules'] = 'Kaasa moodulid';
$string['includemoduleuserdata'] = 'Kaasa mooduli kasutajaandmed';
$string['includeneededusers'] = 'Kaasa vajalikud kasutajad';
$string['includenoneusers'] = 'Ära kaasa kasutajaid';
$string['includeroleassignments'] = 'Lisa rollide määramised';
$string['includesitefiles'] = 'Lisa keskkonna failid, mis on kasutatud kursusel.';
$string['includesubcategories'] = 'Kaasa alamkategooriad';
$string['includeuserfiles'] = 'Kaasa kasutajate failid';
$string['increasesections'] = 'Suurenda jaotiste arvu';
$string['indicator:accessesafterend'] = 'Kursusele siseneti peale lõppkuupäeva';
$string['indicator:accessesafterend_help'] = 'See näitaja kajastab seda, kas tudeng sisenes kursusele pärast kursuse lõppkuupäeva.';
$string['indicator:accessesbeforestart'] = 'Kursusele siseneti enne alguskuupäeva';
$string['indicator:accessesbeforestart_help'] = 'See näitaja kajastab seda, ka studeng sisenes kursusele enne kursuse alguskuupäeva.';
$string['indicator:activitiesdue'] = 'Tähtajalised tegevused';
$string['indicator:activitiesdue_help'] = 'Kasutajal on tegevusi, mille tähtaeg on saabumas.';
$string['indicator:anycourseaccess'] = 'Ligipääs kõigile kursustele';
$string['indicator:anycourseaccess_help'] = 'See näitaja kajastab juurdepääsu kõigile kursustele, kuhu kasutaja on registreerunud.';
$string['indicator:anywrite'] = 'Kõik kirjutamise toimingud.';
$string['indicator:anywrite_help'] = 'See näitaja tähistab kõiki õpilase kirjutatud (edastatavaid) toiminguid.';
$string['indicator:anywriteincourse'] = 'Kõik kirjutamise toimingud kursusel.';
$string['indicator:anywriteincourse_help'] = 'See näitaja tähistab kõiki õpilase kirjutatud (edastatavaid) toiminguid mis tahes kursuse tegevuses.';
$string['indicator:completeduserprofile'] = 'Kasutaja profiil on valmis';
$string['indicator:completeduserprofile_help'] = 'See näitaja';
$string['indicator:completeduserprofiledef'] = 'User profile is completed';
$string['indicator:completeduserprofiledef_help'] = 'Kasutaja on Saidi tingimustega nõustunud ja on täitnud järgmised väljad: asutus, osakond, aadress, linn, riik, URL.';
$string['indicator:completionenabled'] = 'Lõpetamise jälgimine on lubatud';
$string['indicator:completionenabled_help'] = 'See näitaja ütleb, et lõpetamise jälgimine on kursusel lubatud.';
$string['indicator:nostudent'] = 'Õpilaste registreerumised';
$string['indicator:nostudent_help'] = 'See näitaja kajastab õpilaste kättesaadavust kursusel.';
$string['indicator:noteacher'] = 'Õpetaja kättesaadavus';
$string['indicator:noteacher_help'] = 'See näitaja kajastab õpetajate kättesaadavust kursusel.';
$string['indicator:potentialcognitive'] = 'Kursuse potentsiaalne kognitiivne sügavus';
$string['indicator:potentialcognitive_help'] = 'See näitaja põhineb potentsiaalsel kognitiivsel sügavusel, milleni kursuse tegevuses osalenud õpilane võiks jõuda.';
$string['indicator:potentialcognitivedef'] = 'Kursuse potentsiaalne kognitiivne sügavus';
$string['indicator:potentialcognitivedef_help'] = 'Mil määral pakub kursus "sügavat" kognitiivset seotust, nt. töö esitamine tagasiside saamiseks, võimalus teiste töö üle vaadata ning võimalus töö üle vaadata ja uuesti esitada.';
$string['indicator:potentialcognitivedef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:potentialsocial'] = 'Kursuse potentsiaalne sotsiaalne laius';
$string['indicator:potentialsocial_help'] = 'See indikaator põhineb potentsiaalsel sotsiaalsel laiusel, milleni kursuse tegevuses osalenud õpilane võiks jõuda.';
$string['indicator:potentialsocialdef'] = 'Kursuse potentsiaalne sotsiaalne laius';
$string['indicator:potentialsocialdef_help'] = 'Aste, milleni kursus pakub "laiahaardelist" sotsiaalset kaasatust, suheldes teiste osalejate ja klassiruumist väljaspool asuva praktikakogukonnaga.';
$string['indicator:potentialsocialdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['indicator:readactions'] = 'Loenda toimingute arvu';
$string['indicator:readactions_help'] = 'See näitaja tähistab õpilase tehtud (loetud) toimingute arvu.';
$string['indicator:userforumstracking'] = 'Kasutaja jälgib foorumeid';
$string['indicator:userforumstracking_help'] = 'See näitab, kas õpilasel on jälgimine foorumites sisse lülitatud või mitte.';
$string['info'] = 'Teave';
$string['inprogress'] = 'Töös';
$string['institution'] = 'Asutus';
$string['instudentview'] = 'õppija vaates';
$string['interests'] = 'Huvialad';
$string['interestslist'] = 'Huvialade loend';
$string['interestslist_help'] = 'Sisestage ükshaaval oma huvialad, mis seejärel kuvatakse teie profiililehel siltidena.';
$string['invalidemail'] = 'Meiliaadress ei sobi';
$string['invalidlogin'] = 'Vale kasutajanimi või parool. Palun proovi uuesti!';
$string['invalidusername'] = 'Kasutajanimi saab sisaldada ainult väiketähti, numbreid, alakriipsu (_), sidekriipsu (-), punkti (.) ja ät-sümbolit (@).';
$string['invalidusernameupload'] = 'Kasutajatunnus ei sobi';
$string['ip_address'] = 'IP-aadress';
$string['jump'] = 'Hüpe';
$string['jumpto'] = 'Mine...';
$string['keep'] = 'Säilita';
$string['labelvalue'] = '{$a->label}: {$a->value}';
$string['langltr'] = 'Teksti suund vasakult paremale';
$string['langrtl'] = 'Teksti suund paremalt vasakule';
$string['language'] = 'Keel';
$string['languagegood'] = 'See keelepakett on ajakohane! :-)';
$string['languageselector'] = 'Keele valik';
$string['last'] = 'Viimane';
$string['lastaccess'] = 'Viimane külastus';
$string['lastcourseaccess'] = 'Viimane külastus kursusel';
$string['lastedited'] = 'Viimati muudetud';
$string['lastip'] = 'Viimane IP-aadress';
$string['lastlogin'] = 'Viimane sisselogimine';
$string['lastmodified'] = 'Viimati muudetud';
$string['lastname'] = 'Perekonnanimi';
$string['lastnamephonetic'] = 'Perekonnanimi (foneetiline)';
$string['lastpage'] = 'Viimane lehekülg';
$string['lastsiteaccess'] = 'Viimane külastus saidil';
$string['lastyear'] = 'Eelmine aasta';
$string['latestlanguagepack'] = 'Kontrolli/otsi viimast keelepaketti moodle.org-is';
$string['layouttable'] = 'Paigutuse tabel';
$string['leavetokeep'] = 'Jäta tühjaks, kui soovid säilitada hetkel kasutusel oleva parooli';
$string['legacylogginginuse'] = 'Sellel saidil on praegu lubatud pärandlogisalve kirjutamine. Sellesse logisalve kirjutamine pole enam kasutusel. Kirjutage ühilduvasse logisalve, nt „Standardne“ või „Väline“.';
$string['legacythemeinuse'] = 'See sait kuvatakse ühilduvusrežiimis, sest teie brauseri versioon on liiga vana.';
$string['license'] = 'Litsents';
$string['licenses'] = 'Litsentsid';
$string['liketologin'] = 'Kas soovite sisse logida?';
$string['list'] = 'Loend';
$string['listfiles'] = 'Faililoend kataloogis {$a}';
$string['listofallpeople'] = 'Kõigi inimeste loend';
$string['listofcourses'] = 'Kursuste loend';
$string['loading'] = 'Laadimine';
$string['loadinghelp'] = 'Laadimine...';
$string['local'] = 'Kohalik';
$string['localplugins'] = 'Kohalikud lisandmoodulid';
$string['localpluginsmanage'] = 'Halda kohalikke lisandmooduleid';
$string['location'] = 'Asukoht';
$string['locktimeout'] = 'Toiming aegus lukustust oodates.';
$string['log_excel_date_format'] = 'yyyy mmmm d h:mm';
$string['loggedinas'] = 'Olete sisse loginud kui {$a}';
$string['loggedinasguest'] = 'Olete sisenenud külaliskasutajana';
$string['loggedinnot'] = 'Te pole sisse logitud.';
$string['login'] = 'Logi sisse';
$string['login_failure_logs'] = 'Ebaõnnestunud sisenemised';
$string['loginactivity'] = 'Sisselogimistegevus';
$string['loginagain'] = 'Logi uuesti sisse';
$string['loginalready'] = 'Olete juba sisse loginud';
$string['loginas'] = 'Logi sisse kasutajana';
$string['loginaspasswordexplain'] = '<p>Sa pead sisestama spetsiaalse "sisselogimise salasõna" et seda  funktsiooni kasutada.<br /> Kui sa seda ei tea, võta ühendust administraatoriga.</p>';
$string['loginguest'] = 'Logi sisse külalisena';
$string['loginsite'] = 'Logi sisse õpikeskkonda';
$string['loginsteps'] = 'Sellele õpikeskkonnale täieliku juurdepääsu saamiseks peate looma kasutajakonto.';
$string['loginstepsnone'] = '<p>Tere!</p>
<p>Kursustele juurdepääsuks peate endale looma kasutajakonto.</p>
<p>Nüüd looge kasutajanimi ja parool ning sisestage see sellel lehel olevatele väljadele.</p>
<p>Kui teie soovitav kasutajanimi on juba kasutusel, siis looge endale mõni muu kasutajanimi.</p>';
$string['loginto'] = 'Logi sisse kohta {$a}';
$string['logoof'] = '{$a} logo';
$string['logout'] = 'Logi välja';
$string['logoutconfirm'] = 'Kas soovite kindlasti välja logida?';
$string['logs'] = 'Logid';
$string['logtoomanycourses'] = '[ <a href="{$a->url}">rohkem</a> ]';
$string['logtoomanyusers'] = '[ <a href="{$a->url}">rohkem</a> ]';
$string['lookback'] = 'Vaata tagasi';
$string['mailadmins'] = 'Teavita administraatoreid';
$string['mailstudents'] = 'Teavita õppijaid';
$string['mailteachers'] = 'Teavita õpetajaid';
$string['maincoursepage'] = 'Kursuse põhileht';
$string['makeafolder'] = 'Loo kaust';
$string['makeavailable'] = 'Muuda saadavaks';
$string['makeavailablecmtitle'] = 'Muuda tegevus saadavaks';
$string['makeeditable'] = 'Kui teed \'{$a}\' muudetavaks veebiserveri protsessi jaoks (nt apache), siis saad seda faili muuta otse sellelt leheküljelt';
$string['makethismyhome'] = 'Määra see leht minu vaike-avaleheks';
$string['makeunavailable'] = 'Tühista saadavus';
$string['manageblocks'] = 'Plokid';
$string['managecategories'] = 'Halda kursuste kategooriaid';
$string['managecategorythis'] = 'Halda seda kategooriat';
$string['managecombined'] = 'Kursuste kategooriate ja kursuste haldamine';
$string['managecontentbanktypes'] = 'Halda sisutüüpe';
$string['managecourses'] = 'Kursuste haldamine';
$string['managedatabase'] = 'Andmebaas';
$string['managedataformats'] = 'Halda andmevorminguid';
$string['manageeditorfiles'] = 'Halda redaktori poolt kasutatavaid faile';
$string['managefilters'] = 'Filtrid';
$string['managemodules'] = 'Moodulid';
$string['manageroles'] = 'Rollid ja õigused';
$string['markallread'] = 'Märgi kõik loetuks';
$string['markedthistopic'] = 'See teema on esile tõstetud jooksva teemana';
$string['markthistopic'] = 'Märgi see teema jooksvaks teemaks';
$string['match'] = 'Vastab';
$string['matchingsearchandrole'] = '\'{$a->search}\' ja {$a->role} sobivus';
$string['matchofthefollowing'] = 'järgmistest:';
$string['maxareabytesreached'] = 'Fail (või mitme faili kogumaht) on suurem kui selles alas vaba ruumi.';
$string['maxfilesize'] = 'Uute failide maksimummaht: {$a}';
$string['maxfilesreached'] = 'Sellele üksusele võib manustada kuni {$a} faili';
$string['maximumchars'] = 'Kuni {$a} tähemärki';
$string['maximumgrade'] = 'Maksimumhinne';
$string['maximumgradex'] = 'Maksimumhinne: {$a}';
$string['maximumshort'] = 'Maksimum';
$string['maximumupload'] = 'Üleslaaditava faili maksimummaht';
$string['maximumupload_help'] = 'See seadistus määrab suurima lubatud üles laaditavad faili suuruse, olles piiratud saidiülese seadistusega administraatori poolt. Tegevuse moodulid samuti sisaldavad maksimaalset üles lükatava faili suuruse piiranguid.';
$string['maxnumberweeks'] = 'Jaotiste maksimumarv';
$string['maxnumberweeks_desc'] = 'Jaotiste rippmenüü arvu maksimumväärtus (üksnes teatud kursusevormingute puhul).';
$string['maxnumcoursesincombo'] = 'Saate sirvida <a href="{$a->link}">{$a->numberofcourses} kursust</a>.';
$string['maxsectionslimit'] = 'Uut sektsooni ei saa lisada, sest see ületaks kursusel lubatud maksmaalse sektsoioonide arvu ({$a}).';
$string['maxsize'] = 'Maksimummaht: {$a}';
$string['maxsizeandareasize'] = 'Uute failide maksimummaht: {$a->size}, üldine piirang: {$a->areasize}';
$string['maxsizeandattachments'] = 'Uute failide maksimummaht: {$a->size}, manuste piirarv: {$a->attachments}';
$string['maxsizeandattachmentsandareasize'] = 'Uute failide maksimummaht: {$a->size}, manuste piirarv: {$a->attachments}, üldpiirang: {$a->areasize}';
$string['memberincourse'] = 'Inimesed kursusel';
$string['menu'] = 'Menüü';
$string['message'] = 'Sõnum';
$string['messagebody'] = 'Sõnumi sisu';
$string['messagedselectedusers'] = 'Valitud kasutajaid on teavitatud ja saajate loend on lähtestatud.';
$string['messagedselectedusersfailed'] = 'Valitud kasutajatele sõnumi saatmisel ilmnes tõrge. Võimalik, et mõni adressaat sai selle meilisõnumi.';
$string['messageprovider:asyncbackupnotification'] = 'Mittesünkroonsed varundamise / taastamise teated';
$string['messageprovider:availableupdate'] = 'Saadaolevate värskenduste teatised';
$string['messageprovider:backup'] = 'Varundusteatised';
$string['messageprovider:badgecreatornotice'] = 'Õpimärgi looja teatised';
$string['messageprovider:badgerecipientnotice'] = 'Õpimärgi saaja teatised';
$string['messageprovider:competencyplancomment'] = 'Õpiplaani kohta postitati kommentaar';
$string['messageprovider:competencyusercompcomment'] = 'Pädevuse kohta postitati kommentaar';
$string['messageprovider:coursecompleted'] = 'Kursus on läbitud';
$string['messageprovider:coursecontentupdated'] = 'Muudatused kursuse sisus';
$string['messageprovider:courserequestapproved'] = 'Kursuse loomise taotluse kinnituse teatis';
$string['messageprovider:courserequested'] = 'Kursuse loomise taotluse teatis';
$string['messageprovider:courserequestrejected'] = 'Kursuse loomise taotluse tagasilükkamise teatis';
$string['messageprovider:errors'] = 'Saidi olulised tõrked';
$string['messageprovider:errors_help'] = 'Siin on olulised tõrked, millest administraator peaks teadma.';
$string['messageprovider:gradenotifications'] = 'Hinnete teatised';
$string['messageprovider:infected'] = 'Antiviiruse tõrgete märguanded.';
$string['messageprovider:insights'] = 'Ennustusmudelite poolt loodud teadmised';
$string['messageprovider:instantmessage'] = 'Kasutajatevahelised isiklikud sõnumid';
$string['messageprovider:instantmessage_help'] = 'Selles jaotises saab konfigureerida, mida tehakse sõnumitega, mille on saatnud teile selle saidi teised kasutajad.';
$string['messageprovider:messagecontactrequests'] = 'Sõnumi kontakt nõuab teavitust';
$string['messageprovider:newlogin'] = 'Uued sisselogimise teavitused';
$string['messageprovider:notices'] = 'Teave pisiprobleemide kohta';
$string['messageprovider:notices_help'] = 'See on teave, mis võib administraatorit huvitada.';
$string['messageprovider:reportbuilderschedule'] = 'Kohandatud aruannete koostamise ajakava';
$string['messageselect'] = 'Valige see kasutaja sõnumi adressaadiks';
$string['messageselectadd'] = 'Saada sõnum';
$string['middlename'] = 'Liignimi';
$string['migratinggrades'] = 'Hinnete migreerimine';
$string['min'] = 'min';
$string['mins'] = 'min';
$string['minute'] = 'minut';
$string['minutes'] = 'minutit';
$string['miscellaneous'] = 'Varia';
$string['missingcategory'] = 'Vali kategooria';
$string['missingdescription'] = 'Puudub kirjeldus';
$string['missingemail'] = 'Meiliaadressi pole';
$string['missingfirstname'] = 'Eesnime pole';
$string['missingfromdisk'] = 'Pole kettal';
$string['missingfullname'] = 'Täisnime pole';
$string['missinglastname'] = 'Perekonnanime pole';
$string['missingname'] = 'Nime pole';
$string['missingnewpassword'] = 'Puudub uus parool';
$string['missingpassword'] = 'Puudub parool';
$string['missingrecaptchachallengefield'] = 'Ebaõnnestunud reCAPTCHA, palun proovi uuesti.';
$string['missingreqreason'] = 'Põhjust pole';
$string['missingshortname'] = 'Lühinime pole';
$string['missingshortsitename'] = 'Puudub õpikeskkonna lühendnimi';
$string['missingsitedescription'] = 'Puudub õpikeskkonna kirjeldus';
$string['missingsitename'] = 'Puudub õpikeskkonna nimi';
$string['missingstrings'] = 'Kontrolli puuduvate sõnede olemasolu';
$string['missingstudent'] = 'Pead midagi valima';
$string['missingsummary'] = 'Puudub kokkuvõte';
$string['missingteacher'] = 'Pead midagi valima';
$string['missingurl'] = 'Puudub URL';
$string['missingusername'] = 'Kasutajanimi puudub';
$string['moddoesnotsupporttype'] = 'Moodul {$a->modname} ei toeta {$a->type} tüüpi üleslaaditavaid faile';
$string['modhide'] = 'Peida';
$string['modified'] = 'Muudetud';
$string['modshow'] = 'Näita';
$string['modshowcmtitle'] = 'Näita tegevust';
$string['moduleintro'] = 'Kirjeldus';
$string['modulesetup'] = 'Mooduli tabelite seadistamine';
$string['modulesuccess'] = '{$a} tabelid on korrektselt seadistatud';
$string['modulesused'] = 'Kasutatud moodulid';
$string['modvisible'] = 'Kättesaadavus';
$string['modvisible_help'] = 'Kui saadavuse väärtuseks on määratud „Kuva kursuse lehel“, on tegevus või materjal õppijatele saadaval (sõltuvalt võimalikest kehtivatest juurdepääsupiirangutest).<br><br>
Kui saadavuse väärtuseks on määratud „Peida õppijate eest“, on tegevus või materjal saadaval ainult kasutajatele, kellel on peidetud tegevuste vaatamise õigus (vaikimisi on see õpetaja ja redigeerimisõiguseta õpetaja rollidega kasutajatel).';
$string['modvisiblehiddensection'] = 'Kättesaadavus';
$string['modvisiblehiddensection_help'] = 'Kui saadavuse väärtuseks on määratud „Peida õppijate eest“, on Tegevus või Vahend saadaval ainult kasutajatele, kellel on peidetud tegevuste vaatamise õigus (vaikimisi on see õpetaja ja redigeerimisõiguseta õpetaja rollidega kasutajatel).<br><br>
Kui kursus sisaldab rohkelt Tegevusi või Vahendeid, saab kursuse lehte lihtsustada, kui määrata saadavuse väärtuseks „Tee saadavaks, kuid ära kuva kursuse lehel“. Sel juhul peab lisama Tegevuse või Vahendi lingi kuskile mujale, nt mõnele lehele. Tegevus kuvatakse siiski hinnetelehel ja muudes aruannetes.';
$string['modvisiblewithstealth'] = 'Kättesaadavus';
$string['modvisiblewithstealth_help'] = 'Kui saadavuse väärtuseks on määratud „Kuva kursuse lehel“, on Tegevus või Vahend õppijatele saadaval (sõltuvalt võimalikest kehtivatest juurdepääsupiirangutest).<br><br>
Kui saadavuse väärtuseks on määratud „Peida õppijate eest“, on Tegevus või Vahend saadaval ainult kasutajatele, kellel on peidetud tegevuste vaatamise õigus (vaikimisi on see õpetaja ja redigeerimisõiguseta õpetaja rollidega kasutajatel).<br><br>
Kui kursus sisaldab rohkelt Tegevusi või Vahendeid, saab kursuse lehte lihtsustada, kui määrata saadavuse väärtuseks „Tee saadavaks, kuid ära kuva kursuse lehel“. Sel juhul peab lisama tegevuse või materjali lingi kuskile mujale, nt mõnele lehele. Tegevus kuvatakse siiski hinnetelehel ja muudes aruannetes.';
$string['month'] = 'Kuu';
$string['months'] = 'Kuud';
$string['moodledocs'] = 'Moodle’i juhendid';
$string['moodledocslink'] = 'Moodle’i juhendid selle lehe kohta';
$string['moodlelogo'] = 'Moodle’i logo';
$string['moodlenet:columnname'] = 'Nimi';
$string['moodlenet:columnsenddate'] = 'Saatmise kuupäev';
$string['moodlenet:columnsendstatus'] = 'Saatmise staatus';
$string['moodlenet:columntype'] = 'Tüüp';
$string['moodlenet:deletedactivity'] = 'Kustutatud tegevus';
$string['moodlenet:deletedcourse'] = 'Kustutatud kursus';
$string['moodlenet:eventresourceexported'] = 'Eksporditud vahend';
$string['moodlenet:sharefailtitle'] = 'Miski läks valesti';
$string['moodlenet:sharenoticepartialactivitynumber'] = '{$a} tegevused on kursuse osa.';
$string['moodlenet:sharetyperesource'] = 'vahend';
$string['moodlenet:sharinglargefile'] = 'Suured failid võtavad natuke aega.';
$string['moodlerelease'] = 'Moodle’i väljaanne';
$string['moodleservicesandsupport'] = 'Teenused ja tugi';
$string['moodleversion'] = 'Moodle’i versioon';
$string['more'] = 'rohkem';
$string['moreactions'] = 'Rohkem tegevusi';
$string['morehelp'] = 'Rohkem abiteavet';
$string['morehelpaboutmodule'] = 'Rohkem abi  mooduli kohta{$a}';
$string['moreinfo'] = 'Rohkem teavet';
$string['moreinformation'] = 'Rohkem teavet ilmnenud tõrke kohta';
$string['moremenu'] = 'Rohkem';
$string['morenavigationlinks'] = 'Rohkem...';
$string['moreprofileinfoneeded'] = 'Palun räägi meile rohkem endast';
$string['mostrecently'] = 'viimati';
$string['move'] = 'Teisalda';
$string['movecategoriessuccess'] = '{$a->count} kategooriat on teisaldatud kategooriasse „{$a->to}“';
$string['movecategoriestotopsuccess'] = '{$a->count} kategooriat on teisaldatud ülatasemele';
$string['movecategorycontentto'] = 'Teisalda asukohta';
$string['movecategorysuccess'] = 'Kategooria „{$a->moved}“ teisaldati kategooriasse „{$a->to}“';
$string['movecategoryto'] = 'Teisalda kategooria asukohta';
$string['movecategorytotopsuccess'] = 'Kategooria „{$a->moved}“ teisaldati ülatasemele';
$string['movecontent'] = 'Teisalda [$a}';
$string['movecontentafter'] = 'Peale "{$a}"';
$string['movecontentstoanothercategory'] = 'Teisalda sisu mõnda muusse kategooriasse';
$string['movecontenttothetop'] = 'Loendi algusesse';
$string['movecoursemodule'] = 'Teisalda vahend';
$string['movecoursesection'] = 'Teisalda jaotis';
$string['movecourseto'] = 'Teisalda kursus asukohta:';
$string['movedown'] = 'Nihuta alla';
$string['movefilestohere'] = 'Tõsta failid siia';
$string['movefull'] = 'Teisalda {$a} siia';
$string['movehere'] = 'Teisalda siia';
$string['moveleft'] = 'Teisalda vasakule';
$string['moveright'] = 'Teisalda paremale';
$string['movesection'] = 'Teisalda jaotis {$a}';
$string['moveselectedcategoriesto'] = 'Teisalda valitud kategooriad asukohta';
$string['moveselectedcoursesto'] = 'Teisalda valitud kursused asukohta...';
$string['movetoanotherfolder'] = 'Tõsta teise kausta';
$string['moveup'] = 'Nihuta üles';
$string['mustchangepassword'] = 'Uus parool peab erinema eelmisest paroolist';
$string['mustconfirm'] = 'Kinnitage oma sisselogimisandmed';
$string['mycourses'] = 'Minu kursused';
$string['myfiles'] = 'Minu privaatfailid';
$string['myfilesmanage'] = 'Halda minu privaatfaile';
$string['myhome'] = 'Töölaud';
$string['mymoodledashboard'] = 'Minu Moodle töölaud';
$string['myprofile'] = 'Minu profiil';
$string['name'] = 'Nimi';
$string['namedfiletoolarge'] = 'Faili {$a->filename} maht on liiga suur ja seda ei saa üles laadida.';
$string['nameforlink'] = 'Mis nime soovite sellele lingile panna?';
$string['nameforpage'] = 'Nimi';
$string['navigation'] = 'Navigeerimine';
$string['needed'] = 'Vajalik';
$string['networkdropped'] = 'Märkasime, et teie Interneti-ühendus on ebausaldusväärne või katkendlik.<br />
Võimalik, et muudatusi ei salvestata enne, kui teie Interneti-ühendus on taastunud.';
$string['never'] = 'Mitte kunagi';
$string['neverdeletelogs'] = 'Ära logisid kunagi kustuta';
$string['new'] = 'Uus';
$string['newaccount'] = 'Uus kasutajakonto';
$string['newactivityname'] = 'Tegevuse {$a} uus nimi';
$string['newcourse'] = 'Uus kursus';
$string['newloginnotificationbodysmall'] = 'Sinu {$a} konto logiti uues asukohas just sisse.';
$string['newloginnotificationtitle'] = 'Uus sisse logimine sinu {$a} kontole';
$string['newpassword'] = 'Uus parool';
$string['newpassword_help'] = 'Sisesta uus parool või jäta väli tühjaks, et kasutada olemasolevat parooli.';
$string['newpasswordfromlost'] = '<strong> TEADE: </strong> Sinu <strong> praegune parool </strong> saadetakse sulle kahe kadunud parooli taastamise protsessi käigus saadetud e-kirjaga <strong> teises </strong>. Enne sellel lehel jätkamist veendu, et oled oma parooli kätte saanud.';
$string['newpasswordtext'] = 'Tere, {$a->firstname}!

Teie konto parool \'{$a->sitename}\' õpikeskkonnas on muudetud ning teile on genereeritud AJUTINE parool.

Teie sisselogimisandmed on järgmised:
   kasutajanimi: {$a->username}
   parool: {$a->newpassword}

Parooli muutmiseks avage järgmine veebileht:
{$a->link}

Enamikus meiliprogrammides peaks see veebiaadress olema kuvatud sinise lingina, mida saab klõpsata. Kui see ei toimi, siis kopeerige aadress brauseri aadressiribale.

Tervitades \'{$a->sitename}\' administraator
{$a->signoff}';
$string['newpicture'] = 'Uus pilt';
$string['newpicture_help'] = 'Uue pildi lisamiseks sirvige ja valige vastav pilt (JPG või PNG-vormingus) ning klõpsake nuppu Värskenda profiil. Kujutise fail lõigatakse ruudukujuliseks ning selle suurust vähendatakse kuni 100x100 pikslini.';
$string['newpictureusernotsetup'] = 'Profiilipildi saab lisada alles siis, kui kogu kohustuslik profiiliteave on salvestatud.';
$string['newsectionname'] = 'Jaotise {$a} uus nimi';
$string['newsitem'] = 'uudis';
$string['newsitems'] = 'teadaanded';
$string['newsitemsnumber'] = 'Teadaannete arv';
$string['newsitemsnumber_help'] = 'Teadaannetefoorum on erifoorum, mis luuakse kursusel automaatselt, on vaikimisi sunnitud liitumisega ja millesse saavad postitada ainult asjakohaste õigustega kasutajad (vaikimisi õpetajad).

See säte määratleb, mitu viimatist teadaannet kuvatakse plokis „Värsked uudised“.

Kui kursusel pole teadaannetefoorumit vaja, tuleks selleks sätteks määrata null.';
$string['newuser'] = 'Uus kasutaja';
$string['newusernewpasswordsubj'] = 'Uus kasutajakonto';
$string['newusernewpasswordtext'] = 'Tere, {$a->firstname}!

Teie jaoks on loodud kasutajakonto õpikeskkonnas \'{$a->sitename}\' ja teie kontole on määratud AJUTINE parool.

Teie sisselogimisandmed on järgmised:
   kasutajanimi: {$a->username}
   parool: {$a->newpassword}
Esimesel sisselogimisel palutakse teil parooli muuta.

Õpikeskkonna \'{$a->sitename}\' kasutamiseks logige sisse aadressil:
   {$a->link}

Enamikus meiliprogrammides peaks see veebiaadress olema kuvatud sinise lingina, mida saab klõpsata. Kui see ei toimi, siis kopeerige aadress brauseri aadressiribale.

Kui see ei toimi, siis kopeerige aadress brauseri aadressiribale.

Tervitades \'{$a->sitename}\' administraator
{$a->signoff}';
$string['newusers'] = 'Uued kasutajad';
$string['newwindow'] = 'Uus aken';
$string['next'] = 'Edasi';
$string['nextpage'] = 'Järgmine lehekülg';
$string['nextsection'] = 'Järgmine sektsioon';
$string['no'] = 'Ei';
$string['noblockstoaddhere'] = 'Pole plokke, mida saaksite siia lehele paigutada.';
$string['nobody'] = 'Mitte keegi';
$string['nochange'] = 'Muudatusi pole';
$string['nocomments'] = 'Kommentaare pole';
$string['nocourses'] = 'Kursusi pole';
$string['nocoursesfound'] = 'Sõna „{$a}“ ei esinenud üheski kursusenimes';
$string['nocoursestarttime'] = 'Sellel kursusel puudub alguskuupäev';
$string['nocoursesyet'] = 'Selles kategoorias pole kursusi';
$string['nodstpresets'] = 'Administraator ei ole võimaldanud suveaja kasutamise tuge.';
$string['nofilesselected'] = 'Taastamiseks pole valitud ühtegi faili';
$string['nofilesyet'] = 'Teie kursusele pole üles laaditud ühtegi faili';
$string['nofiltersapplied'] = 'Filtreid pole lisatud';
$string['nograde'] = 'Hinnet pole';
$string['nohelpforactivityorresource'] = 'Selle tegevuse või vahendi kohta praegu abiteavet pole';
$string['noimagesyet'] = 'Sinu kursusele pole üles laaditud veel ühtegi pilti';
$string['nologsfound'] = 'Logisid ei leitud';
$string['nomatchingusers'] = 'Ei leitud kasutajaid, kelle nimes esineks „{$a}“';
$string['nomorecourses'] = 'Rohkem sobivaid kursuseid ei leidunud';
$string['nomoreidnumber'] = 'Ei kasuta ID numbrit, vältimaks kokkupõrkeid';
$string['none'] = 'Pole';
$string['noneditingteacher'] = 'Muutmisõiguseta õpetaja';
$string['noneditingteacherdescription'] = 'Muutmisõiguseta õpetaja võib kursustel õppijaid õpetada ja hinnata, aga tegevuste muutmise õigust tal pole.';
$string['nonstandard'] = 'Ebastandardsed';
$string['nopendingcourses'] = 'Pole ühtegi kursust, mis ootaks kinnitust';
$string['nopotentialadmins'] = 'Võimalikke administraatoreid pole';
$string['nopotentialcreators'] = 'Võimalikke kursuse disainereid pole';
$string['nopotentialstudents'] = 'Võimalikke õppijaid pole';
$string['nopotentialteachers'] = 'Võimalikke õpetajaid pole';
$string['norecentactivity'] = 'Viimatisi tegevusi pole';
$string['noreplybouncemessage'] = 'Te vastasite meiliaadressile, kuhu ei saa meilisõnumeid saata. Kui soovite foorumipostitusele vastata, siis kasutage vastamiseks {$a} foorumit.

Järgnev on teie meilisõnumi sisu:';
$string['noreplybouncesubject'] = '{$a} - tagastatud meilisõnum';
$string['noreplyname'] = 'Ära vasta sellele meilisõnumile';
$string['noresetrecord'] = 'Selle lähtestustaotluse kohta pole andmeid. Saate esitada uue parooli lähtestamise taotluse.';
$string['noresults'] = 'Tulemeid pole';
$string['normal'] = 'Tavaline';
$string['normalfilter'] = 'Tavaotsing';
$string['nosite'] = 'Ei leidnud saiditaseme kursust';
$string['nostudentsfound'] = '{$a} ei leidunud';
$string['nostudentsingroup'] = 'Selles rühmas pole veel õppijaid';
$string['nostudentsyet'] = 'Sellele kursusele pole veel registreerunud ühtegi õppijat';
$string['nosuchemail'] = 'Sellist e-posti aadressi pole';
$string['notavailable'] = 'Pole saadaval';
$string['notavailablecourse'] = '{$a} pole saadaval';
$string['noteachersyet'] = 'Sellel kursusel pole veel õpetajaid';
$string['noteachingupcomingcourses'] = 'Saabuvatel kursustel puuduvad õpetajad ja õpilased';
$string['notenrolled'] = '{$a} pole sellele kursusele registreerunud.';
$string['notenrolledprofile'] = 'See kasutajaprofiil pole saadaval, sest see kasutaja pole sellele kursusele registreerunud.';
$string['noteusercannotrolldatesoncontext'] = '<strong> Märkus: </strong> varukoopia taastamisel kuupäevade valimise võimalus on keelatud, kuna sul puuduvad vajalikud õigused.';
$string['noteuserschangednonetocourse'] = 'Märkus: kasutajate andmeid taastades peab taastama ka kursuse kasutajad. See seadistus on nüüd muudetud.';
$string['nothingnew'] = 'Viimatisi tegevusi pole';
$string['nothingtodisplay'] = 'Pole midagi kuvada';
$string['notice'] = 'Märkus';
$string['noticenewerbackup'] = 'See varufail on loodud Moodle’i versiooniga {$a->backuprelease} ({$a->backupversion}), mis on uuem, kui praegu installitud Moodle’i versioon {$a->serverrelease} ({$a->serverversion}). See võib tekitada mõningaid probleeme, kuna varufailide tagasiühilduvus pole tagatud.';
$string['notifications'] = 'Teavitused';
$string['notifyloginfailuresmessage'] = '{$a->time}, IP: {$a->ip}, kasutaja: {$a->info}, kasutaja täisnimi: {$a->name}';
$string['notifyloginfailuresmessageend'] = 'Saate neid logisid vaadata siit: {$a}';
$string['notifyloginfailuresmessagestart'] = 'Siin on {$a} nurjunud sisselogimiskatsete loend alates sellest, kui teid viimati teavitati.';
$string['notifyloginfailuressubject'] = '{$a}: Nurjunud sisselogimiste teatis';
$string['notincluded'] = 'Pole kaasatud';
$string['notingroup'] = 'Kahjuks peate selle tegevuse nägemiseks olema rühmas.';
$string['notpublic'] = 'Pole avalik';
$string['nousersfound'] = 'Kasutajaid ei leitud';
$string['nousersmatching'] = 'Ei leitud sõna \'{$a}\' sisaldavaid kasutajaid.';
$string['nousersyet'] = 'Kasutajaid veel pole';
$string['novalidcourses'] = 'Pole sobivaid kursusi, mida kuvada';
$string['now'] = 'Praegu';
$string['numattempts'] = '{$a} nurjunud sisselogimiskatset';
$string['numberofcourses'] = 'Kursuste arv';
$string['numberweeks'] = 'Jaotiste arv';
$string['numday'] = '{$a} päev';
$string['numdays'] = '{$a} päeva';
$string['numhours'] = '{$a} tundi';
$string['numletters'] = '{$a} tähte';
$string['numminutes'] = '{$a} minutit';
$string['nummonth'] = '{$a} kuu';
$string['nummonths'] = '{$a} kuud';
$string['numseconds'] = '{$a} sekundit';
$string['numviews'] = '{$a} korda vaadatud';
$string['numweek'] = '{$a} nädal';
$string['numweeks'] = '{$a} nädalat';
$string['numwords'] = '{$a} sõna';
$string['numyear'] = '{$a} aasta';
$string['numyears'] = '{$a} aastat';
$string['ok'] = 'OK';
$string['oldpassword'] = 'Praegune parool';
$string['olduserdirectory'] = 'See on vanade kasutajate kataloog ja seda pole enam vaja. Võite selle turvaliselt kustutada. Selles olevad failid on kopeeritud uude kasutajakataloogi.';
$string['opendrawerblocks'] = 'Ava plokisahtel';
$string['opendrawerindex'] = 'Ava kursuse sisukord';
$string['opensinnewwindow'] = 'Avaneb uues aknas';
$string['operator_and'] = 'ja';
$string['operator_andnot'] = 'ja';
$string['operator_or'] = 'või';
$string['optional'] = 'valikuline';
$string['options'] = 'valikud';
$string['order'] = 'Järjekord';
$string['originalpath'] = 'Originaali tee';
$string['orphanedactivitiesinsectionno'] = 'Ilma kategooriata tegevused (jaotis {$a})';
$string['other'] = 'Muu';
$string['outline'] = 'Liigendus';
$string['outlinereport'] = 'Liigendusaruanne';
$string['page'] = 'Lehekülg';
$string['pagea'] = 'Lehekülg {$a}';
$string['pagedcontentnavigation'] = 'Navigeerimine lehtedel';
$string['pagedcontentnavigationactiveitem'] = 'Praegune leht {$a}';
$string['pagedcontentnavigationitem'] = 'Mine lehele {$a}';
$string['pagedcontentpagingbaritemsperpage'] = 'Näita {$a} rida lehel';
$string['pageheaderconfigablock'] = 'Konfigureerin plokki {$a->fullname}';
$string['pagepath'] = 'Lehekülje tee';
$string['pageshouldredirect'] = 'See leht peaks automaatselt edasi suunama. Kui seda ei juhtu, siis klõpsake allolevat linki.';
$string['parentcategory'] = 'Ülemkategooria';
$string['parentcoursenotfound'] = 'Ülemkursust ei leitud!';
$string['parentfolder'] = 'Ülemkaust';
$string['participants'] = 'Osalejad';
$string['participantslist'] = 'Osalejate nimekiri';
$string['participationratio'] = 'Osalusmäär';
$string['participationreport'] = 'Osalemisaruanne';
$string['password'] = 'Parool';
$string['passwordchanged'] = 'Parool on muudetud';
$string['passwordconfirmchange'] = 'Kinnita parooli muutmine';
$string['passwordextlink'] = 'Kadunud parooli taastamiseks on toodud järgmine link. See viib teid Moodle\'ist välja.';
$string['passwordforgotten'] = 'Unustatud parool';
$string['passwordforgotteninstructions'] = 'Sul peab Moodle\'is konto olema, et selle ligipääse taastada. Palun sisesta <strong>KAS</strong> oma kasutajanimi <strong>VÕI</strong> oma e-posti aadress vastavasse lahtrisse.<br><br>
<b>Palun ära sisesta mõlemat väärtust, sest muidu ei saadeta parooli lähtestamise kirja välja.</b>';
$string['passwordforgotteninstructions2'] = 'Parooli lähtestamiseks sisesta all olevatele väljadele <strong>kas</strong> oma kasutajanimi <strong>või</strong> e-posti aadress.
<br>Kui sul on meie andmebaasis konto, saadetakse sinu e-posti aadressile kiri, millest leiad juba edasised juhised oma kontole ligipääsu taastamiseks.';
$string['passwordnohelp'] = 'Kadunud parooli leidmiseks pole abi. Palun pöörduge oma Moodle\'i administraatori poole.';
$string['passwordpolicynomatch'] = 'Teie praegune parool ei vasta enam seatud paroolieeskirjadele.
    {$a}';
$string['passwordrecovery'] = 'Jah, aita mul siseneda';
$string['passwordsdiffer'] = 'Need paroolid ei lange kokku';
$string['passwordsent'] = 'Parool on saadetud';
$string['passwordsenttext'] = '<p>Sinu e-posti aadressile {$a->email} saadeti kiri.</p>

<p><b>Palun vaata sealt oma uut parooli.</b></p>

<p>Uus parool genereeriti automaatselt, <a href={$a->link}>muuda parool</a> millekski lihtsamini meeldejäävaks</a>.</p>';
$string['passwordset'] = 'Sinu parool on salvestatud.';
$string['path'] = 'Tee';
$string['pathnotexists'] = 'Antud tee ei eksisteeri Sinu serveris!';
$string['pathslasherror'] = 'Tee ei tohi lõppeda kaldkriipsuga!';
$string['paymentinstant'] = 'Maksmiseks ja kiireks registreerumiseks klõpsake allolevat nuppu.';
$string['paymentpending'] = '(<small><b><u>{$a}</u></b> ootel</small>)';
$string['paymentrequired'] = 'See kursus on tasuline.';
$string['payments'] = 'Maksed';
$string['paymentsorry'] = 'Täname makse eest. Kahjuks on teie makse töötlemine veel pooleli ja te pole veel kursusele „{$a->fullname}“ registreeritud. Proovige kursuselehele siseneda uuesti mõne sekundi pärast. Kui probleem ei lahene, teavitage sellest õpetajat {$a->teacher} või õpikeskkonna administraatorit.';
$string['paymentthanks'] = 'Täname makse eest. Olete nüüd registreeritud järgmisele kursusele:<br />„{$a}“';
$string['pendingrequests'] = 'Ootel taotlused';
$string['percents'] = '{$a}%';
$string['periodending'] = 'Perioodi lõppkuupäev ({$a})';
$string['perpage'] = 'Lehel';
$string['perpagea'] = 'Lehel: {$a}';
$string['personal'] = 'Isiklik';
$string['personalprofile'] = 'Isiklik profiil';
$string['phone'] = 'Telefon';
$string['phone1'] = 'Telefon';
$string['phone2'] = 'Mobiiltelefon';
$string['phpinfo'] = 'PHP-teave';
$string['pictureof'] = '{$a} pilt';
$string['pictureofuser'] = 'Kasutaja pilt';
$string['placeholdertypeorselect'] = 'Trüki või vali...';
$string['pleaseclose'] = 'Sulgege see aken.';
$string['pleasesearchmore'] = 'Otsige veel';
$string['pleaseusesearch'] = 'Kasutage otsingut';
$string['plugin'] = 'Lisandmoodul';
$string['plugincheck'] = 'Lisamoodulite kontroll';
$string['plugindeletefiles'] = 'Kõik lisandmooduliga „{$a->name}“ seotud andmed on andmebaasist kustutatud. Lisandmooduli uuesti installimise vältimiseks peaksite oma serverist kustutama järgmise kataloogi: {$a->directory}';
$string['pluginsetup'] = 'Pluginatabelite seadistamine';
$string['policyaccept'] = 'Saan aru ja nõustun';
$string['policyagree'] = 'Õpikeskkonna kasutamiseks peate nende tingimustega nõustuma. Kas olete nõus?';
$string['policyagreement'] = 'Õpikeskkonna kasutustingimused';
$string['policyagreementclick'] = 'Õpikeskkonna kasutustingimuste link';
$string['popup'] = 'Hüpikaken';
$string['popupwindow'] = 'Ava fail uues aknas';
$string['popupwindowname'] = 'Hüpikaken';
$string['post'] = 'Postitus';
$string['posts'] = 'Postitused';
$string['potentialadmins'] = 'võimalikku administraatorit';
$string['potentialcreators'] = 'võimalikku kursuse disainerit';
$string['potentialstudents'] = 'võimalikku õppijat';
$string['potentialteachers'] = 'võimalikku õpetajat';
$string['preferences'] = 'Eelistused';
$string['preferredlanguage'] = 'Eelistatud keel';
$string['preferredtheme'] = 'Eelistatud kujundus';
$string['preprocessingbackupfile'] = 'Eeltöötlen varukoopia faili';
$string['prev'] = 'Eelm';
$string['preview'] = 'Eelvaade';
$string['previeworchoose'] = 'Eelvaade või vali kujundus';
$string['previous'] = 'Eelmine';
$string['previouslyselectedusers'] = 'Eelnevalt valitud kasutajad, kes pole \'{$a}\\';
$string['previouspage'] = 'Eelmine lehekülg';
$string['previoussection'] = 'Eelmine sektsioon';
$string['primaryadminsetup'] = 'Administraatorikonto seadistamine';
$string['privacy:metadata:config_log'] = 'Konfiguratsiooni muutuste logi.';
$string['privacy:metadata:config_log:name'] = 'Seadistuste nimi on muudetud.';
$string['privacy:metadata:config_log:oldvalue'] = 'Selle seadistuse eelmine väärtus.';
$string['privacy:metadata:config_log:plugin'] = 'Pluginat on muudetud';
$string['privacy:metadata:config_log:timemodified'] = 'Aeg mil muudatus tehti.';
$string['privacy:metadata:config_log:userid'] = 'Kasutaja kes tegi muudatuse.';
$string['privacy:metadata:config_log:value'] = 'selle seadistuse uus väärtus.';
$string['privacy:metadata:events_queue'] = 'Töötlemist ootavate kasutaja sündmuste järjekord.';
$string['privacy:metadata:events_queue:eventdata'] = 'Sündmusele salvestatud andmed.';
$string['privacy:metadata:events_queue:stackdump'] = 'Kõik selle sündmusega seotud virnajäljed.';
$string['privacy:metadata:events_queue:timecreated'] = 'Aeg mil see sündmus loodi.';
$string['privacy:metadata:events_queue:userid'] = 'Kasutaja ID mis on selle sündmusega seotud.';
$string['privacy:metadata:log'] = 'Minevikusündmuste kogumik';
$string['privacy:metadata:log:action'] = 'Tegevuse kirjeldus';
$string['privacy:metadata:log:cmid'] = 'cmid';
$string['privacy:metadata:log:course'] = 'kursus';
$string['privacy:metadata:log:info'] = 'Lisainformatsioon';
$string['privacy:metadata:log:ip'] = 'Sündmuse ajal kasutatud IP-aadress';
$string['privacy:metadata:log:module'] = 'Moodul';
$string['privacy:metadata:log:time'] = 'Aeg, mil tegevus toimus';
$string['privacy:metadata:log:url'] = 'Sündmusega seotud URL';
$string['privacy:metadata:log:userid'] = 'Toimingu teostanud kasutaja ID';
$string['privacy:metadata:oauth2_refresh_token'] = 'Refresh token used in OAuth 2.0 communication';
$string['privacy:metadata:oauth2_refresh_token:issuerid'] = 'Väljaandja ID, kellele märk vastab';
$string['privacy:metadata:oauth2_refresh_token:scopehash'] = 'Kasutaja ID, kellele märk vastab';
$string['privacy:metadata:oauth2_refresh_token:timecreated'] = 'Märgi loomise aeg';
$string['privacy:metadata:oauth2_refresh_token:timemodified'] = 'Märgi muutmise aeg';
$string['privacy:metadata:oauth2_refresh_token:token'] = 'Vastavate reguleerimisalade ja kasutaja värskendusmärk';
$string['privacy:metadata:oauth2_refresh_token:userid'] = 'Kasutaja ID, kellele märk vastab';
$string['privacy:metadata:task_adhoc'] = 'Adhoc tegevuste staatus';
$string['privacy:metadata:task_adhoc:component'] = 'Komponent, millele kuulub ülesanne.';
$string['privacy:metadata:task_adhoc:nextruntime'] = 'Varasem aeg selle ülesande täitmiseks.';
$string['privacy:metadata:task_adhoc:userid'] = 'Kasutaja kes ülesande täidab.';
$string['privacy:metadata:task_log'] = 'Logi väljund';
$string['privacy:metadata:task_log:component'] = 'Log output for a log';
$string['privacy:metadata:task_log:userid'] = 'Kasutaja kellele ülesanne kuulub.';
$string['privacy:metadata:upgrade_log'] = 'Uuenduste logi';
$string['privacy:metadata:upgrade_log:backtrace'] = 'Logi väljund';
$string['privacy:metadata:upgrade_log:details'] = 'Lisainformatsioon uuenduse kohta';
$string['privacy:metadata:upgrade_log:info'] = 'Peamine teave selle uuenduse kohta.';
$string['privacy:metadata:upgrade_log:plugin'] = 'Plugin, mida uuendati';
$string['privacy:metadata:upgrade_log:targetversion'] = 'Uus versioon mille uuendada.';
$string['privacy:metadata:upgrade_log:timemodified'] = 'Uuenduse toimumise aeg.';
$string['privacy:metadata:upgrade_log:type'] = 'Logi sisestustüüp';
$string['privacy:metadata:upgrade_log:userid'] = 'Kasutaja, kes tegi uuenduse';
$string['privacy:metadata:upgrade_log:version'] = 'Vana plugain versioon';
$string['private_files_handler'] = 'Saate meilisõnumi manuseid talletada kasutaja isiklike failide salvestusruumis.';
$string['private_files_handler_name'] = 'Meilisõnumiga isiklike failide hulka';
$string['privatefiles'] = 'Privaatsed failid';
$string['privatefilesmanage'] = 'Isiklike failide haldamine';
$string['proceed'] = 'Jätka';
$string['profile'] = 'Profiil';
$string['profilenotshown'] = 'See profiilikirjeldus kuvatakse alles siis, kui see isik on registreerunud vähemalt ühele kursusele.';
$string['publicprofile'] = 'Avalik profiil';
$string['publicsitefileswarning'] = 'Märkus: siia pandud faile saab kasutada igaüks';
$string['publicsitefileswarning2'] = 'Märkus. Siia paigutatud failidele pääseb juurde igaüks, kes teab (või oskab arvata) URL-i. Turvalisuse huvides on soovitatav kõik varufailid kustutada kohe pärast nende taastamist.';
$string['publicsitefileswarning3'] = 'Märkus. Siia paigutatud failidele pääseb juurde igaüks, kes teab (või oskab arvata) URL-i. <br /> Turvakaalutlustel tuleks varundusfailid salvestada ainult turvalisse varukoopia andmete kausta.';
$string['question'] = 'Küsimus';
$string['questionsinthequestionbank'] = 'Küsimustepanga küsimused';
$string['queued'] = 'Järjekorras';
$string['quotausage'] = 'Te olete praegu kasutanud {$a->used} oma {$a->total} limiidist.';
$string['readinginfofrombackup'] = 'Loen infot varukoopiast';
$string['readme'] = 'SELETUSFAIL';
$string['recentactivity'] = 'Viimatine tegevus';
$string['recentactivityreport'] = 'Viimaste tegevuste aruanne';
$string['recipientslist'] = 'Saajate nimekiri';
$string['recommended'] = 'Soovitatav';
$string['recreatedcategory'] = 'Uuesti loodud kategooria {$a}';
$string['redirect'] = 'Suuna ümber';
$string['reducesections'] = 'Vähenda jaotiste arvu';
$string['refresh'] = 'Värskenda';
$string['refreshingevents'] = 'Sündmuste värskendamine';
$string['registration'] = 'Moodle’i registreerimine';
$string['registrationcontact'] = 'Kontakteerumine';
$string['registrationcontactno'] = 'Ei, ma ei soovi teistelt kasutajatelt teateid';
$string['registrationcontactyes'] = 'Jah, palun võimaldada vorm minuga kontakteerumiseks';
$string['registrationemail'] = 'E-posti teavitused';
$string['registrationinfo'] = '<p>See leht võimaldab registreerida oma Moodle’i keskkonna veebilehel moodle.org-is. Registreerimine on tasuta. Registreerimise kasulikkus seisneb selles, et liitute väikesemahulise meililistiga, kus edastatakse olulisi teateid (nt turbehoiatused ja teated Moodle’i uute versioonide kohta).</p>
<p>Vaikimisi hoitakse teie teavet privaatselt ega jagata ega müüda kunagi kellelegi teisele. Seda teavet kogutakse üksnes tugiteenuse pakkumise eesmärgil ning Moodle’i kasutajaskonnast tervikliku ülevaate loomiseks.</p>
<p>Soovi korral saate lubada, et teie õpikeskkonna nimi, riik ja URL lisataks Moodle’i õpikeskkondade avalikku loendisse.</p>
<p>Kõik uued registreerimised kontrollitakse enne loendisse lisamist ükshaaval üle, kuid juba loendis olles võite igal ajal oma registreeringut (ning oma sissekannet avalikus loendis) värskendada, esitades selle vormi uuesti.</p>';
$string['registrationinfotitle'] = 'Registreerimis informatsioon';
$string['registrationsend'] = 'Saada registreerimisinfo moodle.org-i';
$string['registrationyes'] = 'Jah, soovin oluliste probleemide kohta teavitusi';
$string['reject'] = 'Lükka tagasi';
$string['rejectdots'] = 'Lükka tagasi...';
$string['relativedatesmode'] = 'Suhteliste kuupäevade režiim';
$string['relativedatesmode_help'] = 'Kuva kursuse või tegevuse kuupäevad vastavalt kasutaja kursuse alguskuupäevale.

Kasutaja kursuse alguskuupäev on tema registreerumise alguskuupäev, välja arvatud juhul, kui kasutaja on registreerunud enne kursuse algust, sel juhul on nende alguskuupäev kursuse alguskuupäev.

HOIATUS: See on eksperimentaalne funktsioon ja mitte kõik tegevused ei pruugi seda toetada. Kui kursus on loodud, ei saa seda kursuse seadistust enam muuta.';
$string['relativedatesmode_warning'] = 'strong> Hoiatus: </strong> Suhteliste kuupäevade režiimi ei saa pärast kursuse loomist muuta.';
$string['reload'] = 'Laadi uuesti';
$string['remoteappuser'] = 'Kaugkasutaja {$a}';
$string['remove'] = 'Eemalda';
$string['removeadmin'] = 'Kustuta administraator';
$string['removecreator'] = 'Kustuta disainer kursuselt';
$string['removestudent'] = 'Kustuta õppija kursuselt';
$string['removeteacher'] = 'Kustuta õpetaja kursuselt';
$string['rename'] = 'Nimeta ümber';
$string['renamefileto'] = 'Nimeta ümber <b>{$a}</b> -';
$string['report'] = 'Aruanne';
$string['reports'] = 'Aruanded';
$string['reporttype'] = 'Aruande tüüp';
$string['repositories'] = 'Hoidlad';
$string['requestcourse'] = 'Taotle uue kursuse loomist';
$string['requestedby'] = 'Taotleja';
$string['requestedcourses'] = 'Taotletud kursused';
$string['requestreason'] = 'Kursuse taotluse põhjus';
$string['requests'] = 'Taotlused';
$string['required'] = 'Kohustuslik';
$string['requirespayment'] = 'Sellele kursusele pääs on tasuline';
$string['resendemail'] = 'Saada mail uuesti';
$string['reset'] = 'Lähtesta';
$string['resetcomponent'] = 'Komponent';
$string['resetcourse'] = 'Lähtesta kursus';
$string['resetinfo'] = 'Siin saate oma kursuse õppijate andmetest tühjendada, aga tegevused ja muud sätted säilivad. Seega pärast kursuse tühjendamist eelmistest õppijatest on teie kursus valmis järgmise rühma jaoks. Alles jäävad kõik õppejõu lisatud vahendid ja tegevused. Arvestage sellega, et kustutatud andmeid ei saa enam taastada. Automaatselt ei saa te tühjendada järgmisi tegevusi (soovi korral peate tegema seda käsitsi): õpipäevikud, wikid, mõistekaardid, mälukaardid, M-sisupaketid ja NanoGongid (suulised ülesanded). <b>NB! Alljärgnevalt on vaikimisi määratud soovituslikud sätted, mida tavaliselt kursuse tühjendamisel kasutatakse. </b>';
$string['resetnotimplemented'] = 'Lähtestust ei rakendatud';
$string['resetrecordexpired'] = 'Kasutatud paroolilähtestuse link on vanem kui {$a} minutit ja see on aegunud. Saate algatada uue paroolilähtestuse.';
$string['resetstartdate'] = 'Lähtesta alguskuupäev';
$string['resetstatus'] = 'Olek';
$string['resettable'] = 'Lähtesta tabeli sätted';
$string['resettask'] = 'Ülesanne';
$string['resettodefaults'] = 'Lähtesta  vaikimisi seaded';
$string['resortcourses'] = 'Sordi kursused';
$string['resortsubcategoriesby'] = 'Sordi alamkategooriad tõusvalt, sortimisalus {$a}';
$string['resortsubcategoriesbyreverse'] = 'Sordi alamkategooriad kahanevalt, sortimisalus {$a}';
$string['resource'] = 'Vahend';
$string['resourcedisplayauto'] = 'Automaatne';
$string['resourcedisplaydownload'] = 'Sunni alla laadima';
$string['resourcedisplayembed'] = 'Manusta';
$string['resourcedisplayframe'] = 'Paneelis';
$string['resourcedisplaynew'] = 'Uus aken';
$string['resourcedisplayopen'] = 'Avatud';
$string['resourcedisplaypopup'] = 'Hüpikaknas';
$string['resources'] = 'Vahendid';
$string['resources_help'] = 'Vahendite tüübid võimaldavad kursusele lisada peaaegu iga liiki veebisisu.';
$string['restore'] = 'Taasta';
$string['restorecancelled'] = 'Taastamine tühistatud';
$string['restorecannotassignroles'] = 'Taastamisel tuleb määrata rollid aga teil pole selleks luba';
$string['restorecannotcreateorassignroles'] = 'Taastamisel peab looma või määrama rolle aga teil pole selleks luba';
$string['restorecannotcreateuser'] = 'Taasteprotsessis on vaja kasutaja „{$a}“ varufailist luua, aga teil pole vastavaid õigusi';
$string['restorecannotoverrideperms'] = 'Taastamisel tuleb õigused üle kirjutada aga teil pole selleks luba';
$string['restorecoursenow'] = 'Taasta see kursus nüüd!';
$string['restoredaccount'] = 'Taastatud konto';
$string['restoredaccountinfo'] = 'See konto imporditi muust serverist ja protsessi käigus läks parool kaotsi. Uue parooli seadistamiseks e-posti teel vajuta palun "Jätka"';
$string['restorefinished'] = 'Taastamine õnnestus';
$string['restoremnethostidmismatch'] = 'Kasutaja „{$a}“ MNeti hosti ID ei ühti kohaliku MNeti hosti ID-ga.';
$string['restoreto'] = 'Taastamiskoht';
$string['restoretositeadding'] = 'Hoiatus. Taastate selle tegevusega saidi avalehe, lisades sellele andmeid!';
$string['restoretositedeleting'] = 'Hoiatus. Taastate selle tegevusega saidi avalehe, kustutades kõigepealt sellelt andmed!';
$string['restoreuserconflict'] = 'Kasutaja „{$a}“ varufailist taastamine põhjustab konflikti';
$string['restoreuserinfofailed'] = 'Taastamisprotsess on peatunud, kuna teil pole luba kasutaja-andmete taastamiseks.';
$string['restoreusersprecheck'] = 'Kontrollitakse kasutaja andmeid';
$string['restoreusersprecheckerror'] = 'Kasutajate andmete kontrollimisel tuvastati mõned probleemid';
$string['restricted'] = 'Piiratud';
$string['resultsfound'] = '{$a} tulemusi leitud';
$string['retry'] = 'Proovi uuesti';
$string['returningtosite'] = 'Kas soovite pöörduda tagasi sellele saidile?';
$string['returntooriginaluser'] = 'Tagasi {$a}';
$string['revert'] = 'Tühista';
$string['role'] = 'Roll';
$string['roleassignments'] = 'Rollide määramised';
$string['rolemappings'] = 'Rolli vastendused';
$string['rolerenaming'] = 'Rolli ümbernimetamine';
$string['rolerenaming_help'] = 'See säte võimaldab kursuses muuta kuvatavaid rollinimesid Muudetakse üksnes kuvatavad nimi – rolli õigused jäävad samaks. Rollide uued nimed kuvatakse kursusel osalejate lehel ja kursuse muudel lehtedel. Kui administraator on ümbernimetatud rolli valinud kursuse haldaja rolliks, siis uue rolli nimi kuvatakse samuti kursuse lehel.';
$string['rolerenaming_success'] = 'Kursuse rollide nimed uuendatud.';
$string['roles'] = 'Rollid';
$string['rss'] = 'RSS';
$string['rssarticles'] = 'Hiljutiste RSS-artiklite arv';
$string['rsserror'] = 'Tõrge RSS-i andmete lugemisel';
$string['rsserrorauth'] = 'Teie RSS-link ei sisalda kehtivat autentimisluba.';
$string['rsserrorguest'] = 'See kanal kasutab andmetele juurdepääsuks külalisjuurdepääsu, aga külalisel pole andmete lugemise õigust. Külastage algset kohta, kust kanal pärit on (URL), ja hankige uus RSS-i link sealt.';
$string['rsskeyshelp'] = '<p>Turvalisuse ja privaatsuse tagamiseks sisaldavad RSS-kanali URL-id eritõendit, mis tuvastab kasutaja, kellele need on välja antud. See tõkestab teistel kasutajatel juurdepääsu nendele õpikeskkonna aladele, kuhu nad pole lubatud.</p><p>Tõend luuakse automaatselt, kui kasutate esimest korda ala, mis tekitab RSS-kanalit. Kui kahtlustate, et teie RSS-kanali tõendit on rikutud, saate klõpsata lähtestamislinki ja taotleda uue. Pange tähele, et teie praegused RSS-kanali URL-id muutuvad siis sobimatuks.</p>';
$string['rsstype'] = 'Selle tegevuse RSS-kanal';
$string['save'] = 'Salvesta';
$string['saveandnext'] = 'Salvesta ja kuva järgmine';
$string['savechanges'] = 'Salvesta muudatused';
$string['savechangesanddisplay'] = 'Salvesta ja kuva';
$string['savechangesandreturn'] = 'Salvesta ja mine tagasi';
$string['savechangesandreturntocourse'] = 'Salvesta ja mine tagasi kursusele';
$string['savecomment'] = 'Salvesta kommentaar';
$string['savedat'] = 'Salvestatud asukohta:';
$string['savepreferences'] = 'Salvesta eelistused';
$string['saveto'] = 'Salvestuskoht';
$string['scale'] = 'Skaala';
$string['scale_help'] = 'Skaala võimaldab sooritusi hinnata ja neile hinnanguid anda. Skaala hõlmab järjestatud väärtusi, mis on reastatuna negatiivsest positiivseni ja eraldatud komadega. Näiteks „Mitterahuldav, Rahuldav, Keskmine, Hea, Väga hea, Suurepärane“.';
$string['scale_link'] = 'grade/scale';
$string['scales'] = 'Skaalad';
$string['scalescustom'] = 'Kohandatavad skaalad';
$string['scalescustomcreate'] = 'Lisa uus skaala';
$string['scalescustomno'] = 'Omatehtud skaalasid pole veel loodud';
$string['scalesstandard'] = 'Tavaskaalad';
$string['scalestandard'] = 'Tavaskaala';
$string['scalestandard_help'] = 'Standardskaala on saadaval kogu saidil ja kõigis kursustes.';
$string['scalestandard_link'] = 'grade/scale';
$string['scalestip'] = 'Omatehtud skaalade loomiseks kasuta \'Skaalad...\' linki kursuse administreerimise menüüs.';
$string['scalestip2'] = 'Kohandatavate skaalade loomiseks klõpsake kursuse halduse menüüs nuppu Hinded ja seejärel valige „Muuda“ ja „Skaalad“.';
$string['schedule'] = 'Ajasta';
$string['screenshot'] = 'Kuvatõmmis';
$string['search'] = 'Otsing';
$string['search_help'] = 'Ühe või rohkema sõna otsimiseks tekstist lihtsalt sisestage need (tühikutega eraldatult). Kasutatakse kõiki sõnu, mis on pikemad kui kaks tähemärki.

Täpsemaks otsinguks klõpsake otsingunuppu ilma otsinguväljale midagi sisestamata, seejärel kuvatakse täpsema otsingu vorm.';
$string['searchactivities'] = 'Otsige tegevusi nime või kirjelduse järgi';
$string['searchagain'] = 'Otsi uuesti';
$string['searchbyemail'] = 'Otsi e-posti aadressi järgi';
$string['searchbyusername'] = 'Otsi kasutajanime järgi';
$string['searchcoursecategories'] = 'Otsingu kategooriad';
$string['searchcourses'] = 'Otsi kursusi';
$string['searchgroups'] = 'Otsi rühmasid';
$string['searchitems'] = 'Otsi komponente';
$string['searchoptions'] = 'Otsinguvalikud';
$string['searchresults'] = 'Otsingutulemid';
$string['searchusers'] = 'Otsi kasutajaid';
$string['sec'] = 'sekund';
$string['seconds'] = 'sekundit';
$string['secondsleft'] = '{$a} sekundit';
$string['secondstotime172800'] = '2 päeva';
$string['secondstotime259200'] = '3 päeva';
$string['secondstotime345600'] = '4 päeva';
$string['secondstotime432000'] = '5 päeva';
$string['secondstotime518400'] = '6 päeva';
$string['secondstotime604800'] = '1 nädal';
$string['secondstotime86400'] = '1 päev';
$string['secretalreadyused'] = 'Parolimuutmise linki oli juba kasutatud, parooli ei muudetud.';
$string['secs'] = 'sekundit';
$string['section'] = 'Sektsioon';
$string['sectionactionnotsupported'] = 'Jaotisetoiming "{$a}" pole siin toetatud';
$string['sectionname'] = 'Jaotise nimi';
$string['sections'] = 'Jaotised';
$string['seealsostats'] = 'Vaata ka: statistika';
$string['selctauser'] = 'Valige kasutaja';
$string['select'] = 'Valige';
$string['selectacategory'] = 'Valige kategooria';
$string['selectacountry'] = 'Valige riik';
$string['selectacourse'] = 'Valige kursus';
$string['selectacoursesite'] = 'Valige kursus või sait';
$string['selectagroup'] = 'Valige rühm';
$string['selectall'] = 'Vali kõik';
$string['selectallusersonpage'] = 'Vali sellel lehel kõik kasutajad';
$string['selectalluserswithcount'] = 'Vali kõik {$a} kasutajat';
$string['selectamodule'] = 'Vali toimingu moodul';
$string['selectanaction'] = 'Valige toiming';
$string['selectanoptions'] = 'Tehke valik';
$string['selectaregion'] = 'Valige piirkond';
$string['selectcategorysort'] = 'Milliseid kategooriaid soovite sortida?';
$string['selectcategorysortby'] = 'Valige, kuidas soovite kategooriaid sortida';
$string['selectcoursesortby'] = 'Valige, kuidas soovite kursusi sortida';
$string['selectdefault'] = 'Vali vaikesäte';
$string['selectedcategories'] = 'Valitud kategooriad';
$string['selectedfile'] = 'Valitud fail';
$string['selectednowmove'] = '{$a} valitud faili liigutamiseks. Nüüd mine sihtkohta ja vajuta \'Liiguta failid siia\'';
$string['selectfiles'] = 'Valige failid';
$string['selectfiltertype'] = 'Vali';
$string['selectgroupsseparate'] = 'Vali eraldatud rühmad';
$string['selectgroupsvisible'] = 'Vali nähtavad rühmad';
$string['selectitem'] = 'Vali \'{$a}\'';
$string['selectmoduletoviewhelp'] = 'Abiteabe vaatamiseks valige vastav tegevus või vahend, mille teavet vaadata soovite.

Tegevuse või vahendi kiiresti lisamiseks topeltklõpsake selle nime.';
$string['selectnos'] = 'Valige kõigi väärtuseks „Ei“.';
$string['selectperiod'] = 'Valige ajavahemik';
$string['senddetails'] = 'Saada andmed minu e-posti aadressile';
$string['sent'] = 'Saadetud';
$string['separate'] = 'Eraldatud';
$string['separateandconnected'] = 'Teadmiste omandamise eraldatud ja ühendatud viisid';
$string['separateandconnected1'] = 'Enamasti eraldatud teadmised';
$string['separateandconnected2'] = 'Eraldatud ja seostatud';
$string['separateandconnected3'] = 'Enamasti seostatud teadmised';
$string['separateandconnectedinfo'] = 'Skaala põhineb eraldatud ja ühendatud teadmise teoorial. Teooria kirjeldab kahte erinevat moodust, kuidas saab hinnata ja õppida asju, mida me näeme ja kuuleme:<ul><li><strong>Eraldatud teadjad</strong> jäävad nii objektiivseteks kui võimalik, ilma tunnete ja emotsioonide kaasamiseta. Diskussioonides teistega kasutavad nad oma ideede kaitsmiseks loogikat ja püüavad oponendi ideedes nõrku kohti leida.</li><li><strong>Ühendatud teadjad</strong> on teiste suhtes tundlikumad. Nad on empaatiavõimelisemad, kuulavad rohkem ning küsivad küsimusi, kuni tunnevad, et nad on rääkijaga ühel lainel ja mõistavad asju rääkija vaatenurgast. Nad õpivad, jagades kogemusi, mis juhtisid neid teiste inimeste teadmisteni.</li></ul>';
$string['servererror'] = 'Serveriga suhtlemisel ilmnes tõrge.';
$string['serverlocaltime'] = 'Serveri kohalik aeg';
$string['sessionforceclean'] = 'Turvameetmetena on kasutaja loodud skriptid selle seansi jooksul keelatud.';
$string['sessiontimeoutsoon'] = 'Teie sessioon hakkab aeguma. Kas soovite oma praegust seanssi pikendada?';
$string['setcategorytheme'] = 'Sea kategooria kujundus';
$string['setpassword'] = 'Määra parool';
$string['setpasswordinstructions'] = 'Sisestage allpool uus parool, seejärel salvestage muudatused.';
$string['settings'] = 'Sätted';
$string['share'] = 'Jaga';
$string['shortname'] = 'Lühinimi';
$string['shortnamecollisionwarning'] = '[*] = See lühinimi on juba kasutusel ja kinnitamisel tuleb seda muuta';
$string['shortnamecourse'] = 'Kursuse lühinimi';
$string['shortnamecourse_help'] = 'Kursuse unikaalne lühinimi kuvatakse navigeerimisel ja kursusega seotud meilisõnumite teemareal.';
$string['shortnametaken'] = 'See lühinimi on juba mõne muu kursuse puhul kasutusel ({$a})';
$string['shortnameuser'] = 'Kasutaja lühinimi';
$string['shortsitename'] = 'Õpikeskkonna lühinimi (nt üks sõna)';
$string['show'] = 'Kuva';
$string['showactions'] = 'Kuva toimingud';
$string['showactivitydates'] = 'Näita tegevuse kuupäevasid';
$string['showactivitydates_help'] = 'Näita tegevuse kuupäevasid kursuse lehel.';
$string['showadvancededitor'] = 'Täpsem';
$string['showadvancedsettings'] = 'Näita laiendatud seadeid';
$string['showall'] = 'Kuva kõik {$a}';
$string['showallcourses'] = 'Kuva kõik kursused';
$string['showallusers'] = 'Kuva kõik kasutajad';
$string['showblockcourse'] = 'Kuva nende kursuste loend, mis sisaldavad plokki';
$string['showcategory'] = 'Kuva {$a}';
$string['showchartdata'] = 'Kuva diagrammi andmed';
$string['showcomments'] = 'Kuva/peida kommentaarid';
$string['showcommentsnonjs'] = 'Kuva kommentaarid';
$string['showdescription'] = 'Kuva kirjeldus kursuse esilehel';
$string['showdescription_help'] = 'Kui see säte on lubatud, kuvatakse ülaltoodud kirjeldus kursuse lehel tegevuse või vahendi lingi all.';
$string['showgrades'] = 'Kuva hinneteleht õppijatele';
$string['showgrades_help'] = 'Paljud tegevused kursuses võimaldavad hinnete panekut. Selle sättega määratakse, kas õppija saab vaadata kursuse halduse plokis oleva hinnete lingi kaudu oma vastava kursuse kõiki hindeid.';
$string['showingacourses'] = 'Kõigi {$a} kursuse kuvamine';
$string['showingxofycourses'] = '{$a->total} kursusest kuvatakse kursused {$a->start}–{$a->end}';
$string['showless'] = 'Näita vähem';
$string['showlistofcourses'] = 'Näita kursuste nimekirja';
$string['showmodulecourse'] = 'Kuva nende kursuste loend, mis sisaldavad tegevust';
$string['showmore'] = 'Näita rohkem';
$string['showoncoursepage'] = 'Kuva kursuse lehel';
$string['showonly'] = 'Kuva ainult';
$string['showperpage'] = 'Kuva {$a} lehel';
$string['showpopoverwindow'] = 'Kuva spikriaken';
$string['showrecent'] = 'Kuva viimatine tegevus';
$string['showreports'] = 'Kuva tegevusaruanded';
$string['showreports_help'] = 'Tegevusaruanded on saadaval iga osaleja kohta ja kajastavad osaleja kursusega seotud tegevust. Aruanded sisaldavad ka näiteks foorumipostituste ja tööde esitamiste loendit ning külastuslogisid. Selle seadega määratakse, kas õppija saab oma tegevusaruandeid vaadata oma profiililehe kaudu.';
$string['showsettings'] = 'Näita seadeid';
$string['showtheselogs'] = 'Näita neid logisid';
$string['showthishelpinlanguage'] = 'Näita seda abi {$a} keeles';
$string['sidepanel'] = 'Küljepaneel';
$string['signoutofotherservices'] = 'Logi igal pool välja';
$string['signoutofotherservices_help'] = 'Kui see ruut on märgitud, logitakse sellelt kontolt välja kõigis veebiteenuseid kasutavates seadmetes ja süsteemides (nt mobiilirakenduses).';
$string['since'] = 'Alates';
$string['sincelast'] = 'Alates viimasest sisenemisest';
$string['site'] = 'Õpikeskkond';
$string['sitedefault'] = 'Õpikeskkonna vaikimisi seaded';
$string['sitedefaultspecified'] = 'saidi vaikeväärtus ({$a})';
$string['siteerrors'] = 'Õpikeskkonna tõrked';
$string['sitefiles'] = 'Õpikeskkonna failid';
$string['sitefilesused'] = 'Sellel kursusel kasutatud saidi failid';
$string['sitehome'] = 'Õpikeskkonna avaleht';
$string['sitelegacyfiles'] = 'Õpikeskkonna pärandfailid';
$string['sitelogs'] = 'Õpikeskkonna sisenemised';
$string['sitenews'] = 'Õpikeskkonna teadaanded';
$string['sitepages'] = 'Õpikeskkonna lehed';
$string['sitepartlist'] = 'Sul pole nõutavaid õigusi osalejate nimekirja vaatamiseks';
$string['sitepartlist0'] = 'Pead olema õpikeskkonna õpetaja, et näha osalejate nimekirja';
$string['sitepartlist1'] = 'Pead olema õpetaja, et näha õpikeskkonna osalejate nimekirja';
$string['sites'] = 'Saidid';
$string['sitesection'] = 'Kaasa teemajaotis';
$string['sitesettings'] = 'Õpikeskkonna seaded';
$string['siteteachers'] = 'Õpikeskkonna õpetajad';
$string['size'] = 'Maht';
$string['sizeb'] = 'baidid';
$string['sizegb'] = 'GB';
$string['sizekb'] = 'kB';
$string['sizemb'] = 'MB';
$string['sizepb'] = 'PB';
$string['sizetb'] = 'TB';
$string['skipped'] = 'Vahele jäetud';
$string['skiptocategorylisting'] = 'Kohe kategoorialoendi juurde';
$string['skiptocoursedetails'] = 'Liigu kursuse üksikasjaliku teabe juurde.';
$string['skiptocourselisting'] = 'Kohe kursuseloendi juurde';
$string['socialheadline'] = 'Sotsiaalne foorum - viimased teemad';
$string['someallowguest'] = 'Mõne kursuse puhul on külalisjuurdepääs lubatud';
$string['someerrorswerefound'] = 'Osa informatsiooni puudus või oli ebakorrektne. Vaata järgnevat täpsustust.';
$string['sort'] = 'Sordi';
$string['sortby'] = 'Sortimisalus';
$string['sortbyx'] = 'Sordi {$a} järgi tõusvas järjestuses';
$string['sortbyxreverse'] = 'Sordi {$a} järgi laskuvas järjestuses';
$string['sorting'] = 'Sortimine';
$string['sourcerole'] = 'Lähteroll';
$string['specifyname'] = 'Pead täpsustama nime.';
$string['standard'] = 'Standardsed';
$string['starpending'] = '([*] = kinnitamist ootav kursus)';
$string['startdate'] = 'Kursuse alguskuupäev';
$string['startdate_help'] = 'See säte määratleb kursuse esimese nädala alguse nädalavormingus. Samuti määratleb see varaseima kuupäeva, mil kursuse tegevuste logid on saadaval. Kui kursus lähtestatakse ja kursuse alguskuupäeva muudetakse, nihutatakse uue alguskuupäeva põhjal kõiki kursuse kuupäevi.';
$string['startdatewithtaskenabled'] = 'Kursuse alguskuupäev';
$string['startingfrom'] = 'Alates';
$string['startsignup'] = 'Loo uus konto';
$string['state'] = 'Riik/maakond';
$string['statistics'] = 'Statistika';
$string['statisticsgraph'] = 'Statistikadiagramm';
$string['stats'] = 'Statistika';
$string['statslogins'] = 'Sisselogimised';
$string['statsmodedetailed'] = 'Üksikasjalik (kasutaja) vaade';
$string['statsmodegeneral'] = 'Üldvaade';
$string['statsnodata'] = 'Kursuste ja ajavahemiku kombinatsiooni kohta pole andmeid saadaval.';
$string['statsnodatauser'] = 'Selle kursuse, kasutaja ja ajavahemiku kombinatsiooni kohta andmed puuduvad.';
$string['statsoff'] = 'Statistika pole praegu lubatud';
$string['statsreads'] = 'Vaatamised';
$string['statsreport1'] = 'Sisselogimised';
$string['statsreport10'] = 'Kasutaja tegevus';
$string['statsreport11'] = 'Kõige aktiivsemad kursused';
$string['statsreport12'] = 'Kõige aktiivsemad kursused (kaalutud)';
$string['statsreport13'] = 'Suurima osalusega kursused (registreerunuid)';
$string['statsreport14'] = 'Suurima osalusega kursused (vaatamisi/postitusi)';
$string['statsreport2'] = 'Vaatamised (kõik rollid)';
$string['statsreport3'] = 'Postitused (kõik rollid)';
$string['statsreport4'] = 'Kõik tegevused (kõik rollid)';
$string['statsreport5'] = 'Kõik tegevused (vaatamised ja postitused)';
$string['statsreport7'] = 'Kasutaja tegevused (vaatamised ja postitused)';
$string['statsreport8'] = 'Kõik kasutaja tegevused';
$string['statsreport9'] = 'Sisselogimised (õpikeskkonna kursus)';
$string['statsreportactivity'] = 'Kõik tegevused (kõik rollid)';
$string['statsreportactivitybyrole'] = 'Kõik tegevused (vaatamised ja postitused)';
$string['statsreportforuser'] = 'vältel';
$string['statsreportlogins'] = 'Sisenemised';
$string['statsreportreads'] = 'Vaatamised (kõik rollid)';
$string['statsreporttype'] = 'Aruande tüüp';
$string['statsreportwrites'] = 'Postitused (kõik rollid)';
$string['statsstudentactivity'] = 'Õppija tegevused';
$string['statsstudentreads'] = 'Õppija vaatamised';
$string['statsstudentwrites'] = 'Õppija postitused';
$string['statsteacheractivity'] = 'Õpetaja tegevus';
$string['statsteacherreads'] = 'Õpetaja vaatamised';
$string['statsteacherwrites'] = 'Õpetaja postitused';
$string['statstimeperiod'] = 'Ajavahemik – viimane:';
$string['statsuniquelogins'] = 'Kordumatud sisselogimised';
$string['statsuseractivity'] = 'Kõik tegevused';
$string['statsuserlogins'] = 'Sisselogimised';
$string['statsuserreads'] = 'Vaatamised';
$string['statsuserwrites'] = 'Postitused';
$string['statswrites'] = 'Postitused';
$string['status'] = 'Olek';
$string['statuscritical'] = 'Kriitiline';
$string['statuserror'] = 'Viga';
$string['statusinfo'] = 'Info';
$string['statusna'] = 'N/A';
$string['statusok'] = 'OK';
$string['statuswarning'] = 'Hoiatus';
$string['stringsnotset'] = 'Järgnevad sõned pole defineeritud asukohas {$a}';
$string['studentnotallowed'] = 'Kahjuks ei või te sellele kursusele siseneda kui \'{$a}\\';
$string['students'] = 'Õppijad';
$string['studentsandteachers'] = 'Õppijad ja õpetajad';
$string['subcategories'] = 'Alamkategooriad';
$string['subcategory'] = 'Alamkategooria';
$string['subcategoryof'] = 'Kategooria {$a} alamkategooria';
$string['subject'] = 'Teema';
$string['submit'] = 'Esita';
$string['success'] = 'Tehtud';
$string['successduration'] = 'Edu saabub ({$a} sekundi pärast)';
$string['summary'] = 'Kokkuvõte';
$string['summary_help'] = 'Kokkuvõte on lühitekst, mis annab õppijale aimu vastava teema või nädalaga seotud tegevustest. See tekst kuvatakse vastava kursuse lehel jaotisenime all.';
$string['summaryof'] = '{$a} – kokkuvõte';
$string['suspended'] = 'Peatatud';
$string['suspendedusers'] = 'Peatatud kontoga kasutajad';
$string['switchdevicedefault'] = 'Aktiveeri tavakujundus';
$string['switchdevicerecommended'] = 'Aktiveeri minu seadme puhul soovitatud kujundus';
$string['switchrolereturn'] = 'Aktiveeri minu tavaroll';
$string['switchroleto'] = 'Aktiveeri roll...';
$string['switchroleto_help'] = 'Valige mõni roll, et vaadata, kuidas selle rolliga kasutajale seda kursust kuvatakse.

Võtke arvesse, et see vaade ei pruugi olla täiuslik (<a href="https://docs.moodle.org/en/Switch_roles">vt üksikasju ja alternatiive</a>).';
$string['tag'] = 'Silt';
$string['tagalready'] = 'See märksõna juba on olemas';
$string['tagmanagement'] = 'Lisa/kustuta märksõnad...';
$string['tags'] = 'Sildid';
$string['targetrole'] = 'Sihtroll';
$string['teacheronly'] = 'ainult  {$a} jaoks';
$string['teacherroles'] = '{$a} rollid';
$string['teachers'] = 'Õpetajad';
$string['textediting'] = 'Tekstiredaktor';
$string['textediting_help'] = 'Kui valitud on HTML-i redaktor (nt Atto või TinyMCE), kuvatakse tekstisisestusväljal tööriistariba, mille abil saab hõlpsalt sisu lisada.

Kui valitud on „Lihtteksti ala“, saab tekstisisestusväljadel valida vormingu (nt HTML või Markdown).

Saidi administraator saab valida, mis tekstiredaktorid on saadaval.';
$string['texteditor'] = 'Kasuta standardveebivorme';
$string['textellipsis'] = '{$a}...';
$string['textformat'] = 'Lihttekstivorming';
$string['thanks'] = 'Tänusõnad';
$string['theme'] = 'Kujundus';
$string['themes'] = 'Kujundused';
$string['themesaved'] = 'Uus kujundus on salvestatud';
$string['therearecourses'] = 'Kokku on {$a} kursust';
$string['thereareno'] = '{$a}: pole selles kursuses';
$string['thiscategory'] = 'See kategooria';
$string['thiscategorycontains'] = 'See kategooria sisaldab';
$string['time'] = 'Aeg';
$string['timecreated'] = 'Loomise aeg';
$string['timecreatedcourse'] = 'Kursuse loomisaeg';
$string['timesplitting:deciles'] = 'Viimane kümens';
$string['timesplitting:deciles_help'] = 'See analüüsi intervall jagab kursuse kümnendikeks (10 võrdset osa), kusjuures iga ennustus põhineb ainult viimase viimase kümnendatel andmetel.';
$string['timesplitting:decilesaccum'] = 'Kõik viimased kümned';
$string['timesplitting:decilesaccum_help'] = 'See analüüsi intervall jagab kursuse kümnendikeks (10 võrdset osa), kusjuures iga ennustus põhineb kõigi eelnevate kümnendike kogutud andmetel.';
$string['timesplitting:nosplitting'] = 'Ajalimiit puudub';
$string['timesplitting:nosplitting_help'] = 'Selle mudeli jaoks pole analüüsiintervalli määratletud.';
$string['timesplitting:onemonthafterstart'] = 'Üks kuu peale algust';
$string['timesplitting:onemonthafterstart_help'] = 'See analüüsiintervall genereerib prognoosi 1 kuu pärast analüüsitavat algust.';
$string['timesplitting:oneweekafterstart'] = 'Üks nädal peale algust';
$string['timesplitting:oneweekafterstart_help'] = 'See analüüsiintervall genereerib prognoosi 1 nädal pärast analüüsitavat algust.';
$string['timesplitting:past3days'] = 'Viimased 3 päeva.';
$string['timesplitting:past3days_help'] = 'See analüüsiintervall genereerib prognoose iga 3 päeva tagant. Näitajate arvutused põhinevad viimasel 3 päeval.';
$string['timesplitting:pastmonth'] = 'Eelmine kuu';
$string['timesplitting:pastmonth_help'] = 'See analüüsiintervall genereerib prognoose iga kuu. Näitajate arvutused põhinevad möödunud kuul.';
$string['timesplitting:pastweek'] = 'Eelmine nädal';
$string['timesplitting:pastweek_help'] = 'See analüüsiintervall genereerib prognoose igal nädalal. Näitajate arvutused põhinevad möödunud nädalal.';
$string['timesplitting:quarters'] = 'Eelmine kvartal';
$string['timesplitting:quarters_help'] = 'See analüüsiintervall jagab kursuse kvartaliteks (4 võrdset osa), kusjuures iga ennustus põhineb ainult viimase eelmise kvartali andmetel.';
$string['timesplitting:quartersaccum'] = 'Kõik eelmised kvartalid';
$string['timesplitting:quartersaccum_help'] = 'See analüüsiintervall jagab kursuse kvartaliteks (4 võrdset osa), kusjuures iga ennustus põhineb kõigi eelmiste kvartalite kogunenud andmetel.';
$string['timesplitting:singlerange'] = 'Algusest lõpuni';
$string['timesplitting:singlerange_help'] = 'Selle analüüsiintervalliga peetakse kogu kursust ühtseks ajavahemikuks.';
$string['timesplitting:tenpercentafterstart'] = '10% peale algust';
$string['timesplitting:tenpercentafterstart_help'] = 'See analüüsiintervall genereerib ennustuse pärast 10% kursuse läbimist.';
$string['timesplitting:upcoming3days'] = 'Järgnevad 3 päeva';
$string['timesplitting:upcoming3days_help'] = 'See analüüsiintervall genereerib prognoose iga 3 päeva tagant. Näitajate arvutused põhinevad eelseisval 3 päeval.';
$string['timesplitting:upcomingfortnight'] = 'Eelolevad kaks nädalat';
$string['timesplitting:upcomingfortnight_help'] = 'See analüüsi intervall genereerib prognoose iga kahe nädala tagant. Näitajate arvutused põhinevad eelseisval kahel nädalal.';
$string['timesplitting:upcomingweek'] = 'Järgmine nädal';
$string['timesplitting:upcomingweek_help'] = 'See analüüsi intervall genereerib prognoose igal nädalal. Näitajate arvutused põhinevad eelseisval nädalal.';
$string['timezone'] = 'Ajavöönd';
$string['to'] = 'Kuni';
$string['tocontent'] = 'Üksusele „{$a}“';
$string['tocreatenewaccount'] = 'Jäta vahele, et luua uus konto';
$string['todate'] = 'Kuni';
$string['today'] = 'Täna';
$string['todaylogs'] = 'Tänased logid';
$string['toeveryone'] = 'kõigile';
$string['toggleemojipicker'] = 'Lülitab emotikonide valija sisse';
$string['togglesearch'] = 'Lülitab otsingu sisendi';
$string['toomanybounces'] = 'Sellelt meiliaadressilt on tulnud liiga palju tagasisaatmisi. Jätkamiseks <b>peate</b> meiliaadressi muutma.';
$string['toomanytags'] = 'Otsing sisaldas liiga palju silte; mõnda neist eirati.';
$string['toomanytoshow'] = 'Kasutajaid on näitamiseks liiga palju';
$string['toomanyusersmatchsearch'] = 'Otsingule „{$a->search}“ vastas liiga palju kasutajaid ({$a->count})';
$string['toomanyuserstoshow'] = 'Kuvamiseks liiga palju kasutajaid ({$a})';
$string['toonly'] = 'ainult  {$a} jaoks';
$string['top'] = 'Üles';
$string['topic'] = 'Teema';
$string['topichide'] = 'Peida see teema {$a} eest';
$string['topicoutline'] = 'Kursuse/teemade ülevaade';
$string['topicshow'] = 'Näita teemat {$a} jaoks';
$string['toplevelcategory'] = 'Ülemkategooria';
$string['torecipient'] = 'Kuni';
$string['total'] = 'Kokku';
$string['totopofsection'] = 'Jaotise „{$a}“ algusse';
$string['trackforums'] = 'Foorumi jälgimine';
$string['trackforumsno'] = 'Ei: ära jälgi postitusi, mida juba näinud olen';
$string['trackforumsyes'] = 'Jah: tõsta uued postitused esile';
$string['trysearching'] = 'Proovi hoopis otsida';
$string['turneditingoff'] = 'Keela muutmine';
$string['turneditingon'] = 'Luba muutmine';
$string['unauthorisedlogin'] = 'Kasutajakonto "{$a}" pole selles õpikeskkonnas saadaval';
$string['undecided'] = 'Kõhklev';
$string['unexistingcmid'] = 'Kursusemooduli ID\'d ei leitud';
$string['unexistingsectionid'] = 'Kursuse sektsiooni ID\'d ei leitud';
$string['unfinished'] = 'Lõpetamata';
$string['unknowncategory'] = 'Tundmatu kategooria';
$string['unknownerror'] = 'Tundmatu tõrge';
$string['unknownuser'] = 'Tundmatu kasutaja';
$string['unlimited'] = 'Piiranguta';
$string['unpacking'] = '{$a} lahtipakkimine';
$string['unsafepassword'] = 'Ebaturvaline parool – proovi mõnda muud';
$string['untilcomplete'] = 'Lõpuleviimiseni';
$string['unusedaccounts'] = 'Kasutajakontod, mida pole kasutatud rohkem kui {$a} päeva, kustutatakse automaatselt nimekirjast';
$string['unzip'] = 'Paki lahti';
$string['unzippingbackup'] = 'Paki lahti varukoopia';
$string['up'] = 'Üles';
$string['update'] = 'Värskendus';
$string['updated'] = 'Värskendatud {$a}';
$string['updatemymoodleoff'] = 'Salvesta muudatused';
$string['updatemymoodleon'] = 'Luba muutmine';
$string['updatemyprofile'] = 'Värskenda kasutaja andmeid';
$string['updatesevery'] = 'Värskendus iga {$a} sekundi tagant';
$string['updatethis'] = 'Värskenda see {$a}';
$string['updatethiscourse'] = 'Uuenda see kursus';
$string['updatinga'] = 'Värskendamine: {$a}';
$string['updatingain'] = 'Värskendamine: {$a->what} asukohas {$a->in}';
$string['upload'] = 'Laadi üles';
$string['uploadafile'] = 'Laadi fail üles';
$string['uploadcantwrite'] = 'Faili kettale kirjutamine nurjus';
$string['uploadedfile'] = 'Faili on üles laaditud';
$string['uploadedfileto'] = 'Üles laaditud {$a->file} kausta {$a->directory}';
$string['uploadedfiletoobig'] = 'Fail on liiga suur (failimahu limiit on {$a} baiti)';
$string['uploadextension'] = 'PHP-laiendus on faili üleslaadimise peatanud';
$string['uploadfailednotrecovering'] = 'Faili üleslaadimine nurjus, kuna tekkis probleem failiga {$a->name}.<br /> Siin on probleemide logi:<br />{$a->problem}<br />Ei taastata.';
$string['uploadfilelog'] = 'Laadi üles logi  fail {$a} jaoks';
$string['uploadformlimit'] = 'Üleslaaditud fail {$a} ületas sellele vormile seatud maksimaalse suuruse limiidi';
$string['uploadlabel'] = 'Pealkiri:';
$string['uploadlimitwithsize'] = '{$a->contextname}: üleslaadimispiirang on ({$a->displaysize})';
$string['uploadnewfile'] = 'Laadi üles uus fail';
$string['uploadnofilefound'] = 'Ühtegi faili ei leitud – kas valisite kindlasti üleslaadimiseks faili?';
$string['uploadnotallowed'] = 'Üleslaadimised on keelatud';
$string['uploadnotempdir'] = 'Ajutist kausta pole';
$string['uploadoldfilesdeleted'] = 'Vanad failid on teie üleslaadimisalas kustutatud';
$string['uploadpartialfile'] = 'Fail laaditi üles ainult osaliselt';
$string['uploadproblem'] = 'Faili „{$a}“ üleslaadimisel tekkis tundmatu probleem (võimalik, et fail oli liiga suur)';
$string['uploadrenamedchars'] = 'Sobimatute märkide pärast nimetati fail ümber: nime {$a->oldname} asemel on nimi {$a->newname}';
$string['uploadrenamedcollision'] = 'Failinime konflikti tõttu nimettai fail: nime {$a->oldname} asemel nimi {$a->newname}';
$string['uploadserverlimit'] = 'Üleslaaditud fail ületas serveri poolt seatud maksimumsuuruse limiidi';
$string['uploadthisfile'] = 'Laadi see fail üles';
$string['url'] = 'URL';
$string['used'] = 'Kasutatud';
$string['usedinnplaces'] = 'Kasutatud {$a} kohas';
$string['user'] = 'Kasutaja';
$string['useraccount'] = 'Kasutajakonto';
$string['useractivity'] = 'Tegevus';
$string['userconfirmed'] = 'Kinnitatud {$a}';
$string['userdata'] = 'Kasutajaandmed';
$string['userdeleted'] = 'See kasutajakonto on kustutatud';
$string['userdescription'] = 'Kirjeldus';
$string['userdescription_help'] = 'Sellele väljale saate sisestada ennast kirjeldava teksti, mis kuvatakse teie profiililehel.';
$string['userdetails'] = 'Kasutaja üksikasjad';
$string['userfiles'] = 'Kasutaja failid';
$string['userlist'] = 'Kasutajate loend';
$string['usermatchedon'] = 'See kasutaja vastab otsingule läbi:';
$string['usermenu'] = 'Kasutajamenüü';
$string['usermenugoback'] = 'Mine tagasi kasutajamenüüsse';
$string['username'] = 'Kasutajanimi';
$string['usernameemail'] = 'Kasutajanimi või e-maili aadress';
$string['usernameemailmatch'] = 'Kasutajanimi ja meiliaadress ei ole seotud sama kasutajaga';
$string['usernameexists'] = 'See kasutajanimi on juba olemas, valige mõni teine';
$string['usernamelowercase'] = 'Lubatud on üksnes väiketähed';
$string['usernamenotfound'] = 'Seda kasutajanime ei leitud andmebaasist';
$string['usernameoremail'] = 'Sisestage kas kasutajanimi või meiliaadress';
$string['usernotconfirmed'] = 'Kasutajat {$a} ei saanud kinnitada';
$string['userpic'] = 'Kasutaja pilt';
$string['userpreferences'] = 'Kasutajaeelistused';
$string['users'] = 'Kasutajad';
$string['userselectorautoselectunique'] = 'Kui leidus ainult üks kasutaja, siis vali ta automaatselt';
$string['userselectorpreserveselected'] = 'Hoia valitud kasutajaid, isegi kui nad enam otsingutulemiste hulgas pole';
$string['userselectorsearchanywhere'] = 'Otsi otsitavat teksti kuvatavatel väljadel kõikjalt';
$string['userselectorsearchexactmatchonly'] = 'ainult täpsed vasted';
$string['userselectorsearchfromstart'] = 'algusest';
$string['userselectorsearchmatching'] = 'Vastab:';
$string['usersnew'] = 'Uued kasutajad';
$string['usersnoaccesssince'] = 'Passiivsed rohkem kui';
$string['userswithfiles'] = 'Kasutajate failid';
$string['useruploadtype'] = 'Kasutaja üles laaditud tüüp: {$a}';
$string['userzones'] = 'Kasutajatsoonid';
$string['usetheme'] = 'Kasuta kujundust';
$string['usingexistingcourse'] = 'Olemasoleva kursuse kasutamine';
$string['validatehtml'] = 'Kinnita HTML';
$string['valuealreadyused'] = 'See väärtus on juba kasutusel.';
$string['version'] = 'Versioon';
$string['view'] = 'Kuva';
$string['viewallcourses'] = 'Kuva kõik kursused';
$string['viewallcoursescategories'] = 'Kuva kõik kursused ja kategooriad';
$string['viewallresults'] = 'Vaata kõiki tulemusi ({$a})';
$string['viewallsubcategories'] = 'Kuva kõik alamkategooriaid';
$string['viewfileinpopup'] = 'Vaata faili hüpikaknas';
$string['viewing'] = 'Kuvamine:';
$string['viewmore'] = 'Kuva rohkem';
$string['viewprofile'] = 'Kuva profiil';
$string['viewresults'] = 'Vaata {$a} tulemusi';
$string['views'] = 'Vaatamised';
$string['viewsolution'] = 'kuva lahendus';
$string['visible'] = 'Nähtavus';
$string['visible_help'] = 'Selle sättega määratakse, kas see kursus kuvatakse kursuste loendis. Sellele kursusele saavad siseneda üksnes õpetaja ja administraatori rollis olevad kasutajad.';
$string['visibletostudents'] = 'Nähtav {$a} jaoks';
$string['warning'] = 'Hoiatus.';
$string['warningdeleteresource'] = 'Hoiatus: viidatakse ressursile {$a}. Kas soovite ressurssi värskendada?';
$string['webpage'] = 'Veebileht';
$string['week'] = 'Nädal';
$string['weekhide'] = 'Peida see nädal {$a} eest';
$string['weeklyoutline'] = 'Nädalavaade';
$string['weeks'] = 'nädalad';
$string['weekshow'] = 'Näita seda nädalat {$a} jaoks';
$string['welcomeback'] = 'Tere tulemast tagasi, {$a->firstname}! 👋';
$string['welcometocourse'] = 'Tere tulemast kursusele {$a}!';
$string['welcometocoursetext'] = 'Tere tulemast kursusele {$a->coursename}!

Seda linki klõpsates saate täiendada oma kasutajaandmeid, et teised kursusel osalejad saaksid teid paremini tundma õppida:

  {$a->profileurl}';
$string['welcometosite'] = 'Tere tulemast, {$a->firstname}! 👋';
$string['whatforlink'] = 'Mida soovite selle lingiga teha?';
$string['whatforpage'] = 'Mida soovite selle lingiga teha?';
$string['whatisyourage'] = 'Mis on sinu vanus?';
$string['whattocallzip'] = 'Mis pakitud faili nimeks saab?';
$string['whattodo'] = 'Mida teha';
$string['wheredoyoulive'] = 'Mis riigis sa elad?';
$string['whyisthisrequired'] = 'Miks seda nõutakse?';
$string['windowclosing'] = 'See aken peaks sulguma automaatselt. Kui ei sulgu automaatselt, siis sulgege nüüd.';
$string['withchosenfiles'] = 'Valitud failid';
$string['withdisablednote'] = '{$a} (keelatud)';
$string['withoutuserdata'] = 'ilma kasutaja andmeteta';
$string['withselectedusers'] = 'Valitud kasutajatega...';
$string['withuserdata'] = 'koos kasutaja andmetega';
$string['wordforstudent'] = 'Kuidas nimetad õppijat?';
$string['wordforstudenteg'] = 'näiteks õppija, osaleja jne';
$string['wordforstudents'] = 'Kuidas nimetad õppijaid?';
$string['wordforstudentseg'] = 'näiteks õppijad, osalejad jne';
$string['wordforteacher'] = 'Kuidas nimetad õpetajat?';
$string['wordforteachereg'] = 'näiteks õpetaja, tuutor, juhendaja jne';
$string['wordforteachers'] = 'Kuidas nimetad õpetajaid?';
$string['wordforteacherseg'] = 'näiteks õpetajad, tuutorid, juhendajad jne';
$string['writingblogsinfo'] = 'Blogiinfo kirjutamine';
$string['writingcategoriesandquestions'] = 'Kategooriate ja küsimuste kirjutamine';
$string['writingcoursedata'] = 'Kursuse info kirjutamine';
$string['writingeventsinfo'] = 'Sündmuste info kirjutamine';
$string['writinggeneralinfo'] = 'Üldinfo kirjutamine';
$string['writinggradebookinfo'] = 'Hinnetelehe teabe kirjutamine';
$string['writinggroupingsgroupsinfo'] = 'Rühmituste-rühmade info kirjutamine';
$string['writinggroupingsinfo'] = 'Rühmitamise info kirjutamine';
$string['writinggroupsinfo'] = 'Rühmade info kirjutamine';
$string['writingheader'] = 'Päise kirjutamine';
$string['writingloginfo'] = 'Logide info kirjutamine';
$string['writingmessagesinfo'] = 'Sõnumite info kirjutamine';
$string['writingmoduleinfo'] = 'Moodulite info kirjutamine';
$string['writingscalesinfo'] = 'Skaalade info kirjutamine';
$string['writinguserinfo'] = 'Kasutajate info kirjutamine';
$string['wrongpassword'] = 'Vale parool selle kasutajanime jaoks';
$string['year'] = 'aasta';
$string['years'] = 'aastat';
$string['yes'] = 'Jah';
$string['youareabouttocreatezip'] = 'Sa lood pakitud arhiivi järgnevatest failidest';
$string['youaregoingtorestorefrom'] = 'Sa  taastad:';
$string['youhaveupcomingactivitiesdue'] = 'Sul on tegevusi, mille tähtaeg on lähiajal';
$string['youhaveupcomingactivitiesdueinfo'] = 'Tere {$a},

<br/><br/>Sul on lähiajal vaja teha tegevused:';
$string['youneedtoenrol'] = 'Selle toimingu tegemiseks peate sellele kursusele registreeruma.';
$string['yourlastlogin'] = 'Sinu viimane sisenemine toimus';
$string['yourself'] = 'mina ise';
$string['yourteacher'] = 'Sinu {$a}';
$string['yourwordforx'] = 'Minu väljend „{$a}“ kohta';
$string['zippingbackup'] = 'Pakin kokku varukoopia';
