<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'pdfannotator', language 'es', version '4.5'.
 *
 * @package     pdfannotator
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actiondropdown'] = 'Opciones';
$string['activities'] = 'Actividades';
$string['addAComment'] = 'Añadir un comentario';
$string['add_private_comment'] = 'Agregar un comentario a una nota personal';
$string['add_protected_comment'] = 'Agregar un comentario a una pregunta privada';
$string['ago'] = 'hace {$a}';
$string['all'] = 'todos';
$string['all_answers'] = 'Todas las respuestas';
$string['all_questions'] = 'Todas las preguntas';
$string['allanswers'] = 'todos';
$string['allquestions'] = 'todos';
$string['allquestionsimgtitle'] = 'Mostrar todas las preguntas de este documento';
$string['allquestionstitle'] = 'Todas las preguntas en';
$string['allreports'] = 'todos los informes';
$string['annotationDeleted'] = 'Se eliminó la anotación';
$string['anonymous'] = 'Anónimo';
$string['answer'] = 'Respuesta';
$string['answerButton'] = 'Respuesta';
$string['answerSolved'] = 'Esta respuesta ha sido marcada como correcta por el profesor.';
$string['answercounthelpicon'] = 'Número de respuestas';
$string['answercounthelpicon_help'] = 'Esta columna indica cuántas respuestas ha recibido una pregunta.';
$string['answers'] = 'respuestas';
$string['answerstab'] = 'Respuestas';
$string['answerstabicon'] = 'Respuestas';
$string['answerstabicon_help'] = 'Esta página puede mostrarle todas las respuestas o sólo las de las preguntas a las que se haya suscrito*. La lista abarca a todos los anotadores de este curso.<br>*Cuando usted mismo publica una pregunta, queda automáticamente suscrito a ella mientras no se dé de baja.';
$string['author'] = 'Autor';
$string['average'] = 'promedio';
$string['average_answers'] = 'Respuestas promedio';
$string['average_help'] = 'Sólo los usuarios que escribieron al menos un comentario se incluyen en el cálculo del promedio (media aritmética)';
$string['average_questions'] = 'Preguntas promedio';
$string['by'] = 'por';
$string['by_other_users'] = 'por otros usuarios';
$string['bynameondate'] = 'por {$a->name} - {$a->date}';
$string['cancelButton'] = 'Cancelar';
$string['chart_title'] = 'Preguntas y respuestas en las anotaciones de este curso';
$string['clicktoopen2'] = 'Haga clic en el enlace {$a} para ver el archivo.';
$string['closedquestions'] = 'resueltas';
$string['colorPicker'] = 'Elegir un color';
$string['comment'] = 'Comentario';
$string['commentDeleted'] = 'El comentario ha sido eliminado.';
$string['comments'] = 'Comentarios';
$string['correct'] = 'correcto';
$string['count'] = 'número';
$string['createAnnotation'] = 'Crear Anotación';
$string['currentPage'] = 'Número de página actual';
$string['day'] = 'día';
$string['days'] = 'días';
$string['decision'] = 'Tomar una decisión';
$string['decision:overlappingAnnotation'] = 'Ha hecho clic en un área en la que hay más de una anotación. Decida en cuál quiere hacer clic.';
$string['delete'] = 'Eliminar';
$string['deleteComment'] = 'Eliminar comentario';
$string['deletedComment'] = 'comentario eliminado';
$string['deletedQuestion'] = 'pregunta eliminada';
$string['deletingAnnotation_manager'] = 'La Anotación y todos los comentarios relacionados serán eliminados.';
$string['deletingAnnotation_student'] = 'La anotación y todos los comentarios correspondientes serán eliminados.<br>Puede eliminar sus propias anotaciones siempre que no hayan sido comentadas por otros usuarios.';
$string['deletingComment'] = 'El comentario será eliminado. Se mostrará como borrado a menos que sea el último comentario en su hilo.';
$string['deletingCommentTitle'] = '¿Está seguro/ a?';
$string['deletingQuestion_manager'] = 'El comentario se borrará.<br> Sugerencia: Si quiere borrar también todas las respuestas, borre la anotación en el documento.';
$string['deletingQuestion_student'] = 'La pregunta se borrará.<br>Si no se responde, la anotación se borrará también, de lo contrario la pregunta se mostrará como borrada';
$string['deletionForbidden'] = 'No se permite el borrado';
$string['didyouknow'] = '¿Lo sabía?';
$string['dnduploadpdfannotator'] = 'Crear un archivo para la anotación en PDF';
$string['document'] = 'Documento';
$string['drawing'] = 'Dibujar en el documento con el bolígrafo.';
$string['edit'] = 'Editar';
$string['editAnnotation'] = 'La anotación se moverá. <br>Esto podría cambiar el contexto de la pregunta.';
$string['editAnnotationTitle'] = '¿Está seguro/ a?';
$string['editButton'] = 'Guardar';
$string['editNotAllowed'] = '¡No se permite el paneo!';
$string['editedComment'] = 'Última edición';
$string['emptypdf'] = 'Actualmente no hay comentarios en este anotador.';
$string['enterText'] = 'Introduzca el texto';
$string['entity_helptitle'] = 'Ayuda para';
$string['error'] = '¡Error!';
$string['error:addAnnotation'] = 'Se ha producido un error al añadir una anotación.';
$string['error:addComment'] = 'Se ha producido un error al añadir el comentario.';
$string['error:closequestion'] = 'Se ha producido un error al cerrar/abrir la pregunta';
$string['error:deleteAnnotation'] = 'Se ha producido un error al borrar una anotación.';
$string['error:editAnnotation'] = 'Se ha producido un error al editar una anotación.';
$string['error:editcomment'] = 'Se ha producido un error al intentar editar un comentario.';
$string['error:forwardquestion'] = 'Se ha producido un error al reenviar la pregunta.';
$string['error:forwardquestionnorecipient'] = 'Se ha producido un error al reenviar la pregunta. Ninguna persona en este curso tiene la capacidad de recibir preguntas reenviadas.';
$string['error:getAllQuestions'] = 'Se ha producido un error al obtener las preguntas de este documento.';
$string['error:getAnnotation'] = 'Se ha producido un error al obtener la anotación.';
$string['error:getAnnotations'] = 'Se ha producido un error al obtener todas las anotaciones.';
$string['error:getComments'] = 'Se ha producido un error al obtener los comentarios.';
$string['error:getQuestions'] = 'Se ha producido un error al obtener las preguntas de esta página.';
$string['error:hideComment'] = 'Se ha producido un error al intentar ocultar el comentario de la vista de los participantes.';
$string['error:markasread'] = 'No se ha podido marcar el comentario como leído.';
$string['error:markasunread'] = 'No se ha podido marcar el comentario como no leído.';
$string['error:markcorrectanswer'] = 'Se ha producido un error al marcar la respuesta como correcta.';
$string['error:missingAnnotationtype'] = 'El tipo de anotación no existe. Posiblemente falta la entrada en la tabla pdfannotator_annotationtypes.';
$string['error:openingPDF'] = 'Se ha producido un error al abrir el archivo PDF.';
$string['error:openprintview'] = 'Se ha producido un error al intentar abrir el pdf en Acrobat Reader.';
$string['error:printcomments'] = 'Se ha producido un error al intentar abrir los comentarios de un pdf.';
$string['error:printlatex'] = 'Se ha producido un error al intentar añadir una fórmula LaTeX al pdf.';
$string['error:redihideCommentsplayComment'] = 'Se ha producido un error al reinsertar el comentario de los asistentes.';
$string['error:redisplayComment'] = 'Se ha producido un error al volver a mostrar el comentario.';
$string['error:renderPage'] = 'Se ha producido un error en la visualización de la página.';
$string['error:reportComment'] = 'Se ha producido un error al guardar el informe.';
$string['error:subscribe'] = 'Se ha producido un error al suscribirse a la pregunta.';
$string['error:unsubscribe'] = 'Se ha producido un error al cancelar la suscripción a la pregunta.';
$string['error:voteComment'] = 'Se ha producido un error al guardar el voto.';
$string['eventreport_added'] = 'Se ha realizado un comentario';
$string['filenotfound'] = 'El archivo no se ha encontrado, lo sentimos.';
$string['forward'] = 'Enviar';
$string['forwardedquestionhtml'] = '{$a->sender} le ha remitido la siguiente pregunta: <br /> <br />  "{$a->questioncontent}"  <br /> <br /> con el mensaje: <br /> <br /> "{$a->message}" <br /> <br /> La pregunta está disponible <a href="{$a->urltoquestion}">aquí</a>.';
$string['forwardedquestiontext'] = '{$a->sender} le ha remitido la siguiente pregunta: "{$a->questioncontent}" con el mensaje: "{$a->message}"  La pregunta está disponible en: {$a->urltoquestion}';
$string['fullscreen'] = 'Pantalla completa';
$string['fullscreenBack'] = 'Salir de pantalla completa';
$string['global_setting_anonymous'] = '¿Permitir la publicación anónima?';
$string['global_setting_anonymous_desc'] = 'Con esta opción permites a tu usuario publicar comentarios de forma anónima. Esta opción activa globalmente la publicación anónima';
$string['global_setting_latexapisetting'] = 'LaTeX a PNG API';
$string['global_setting_latexapisetting_desc'] = 'API para la conversión de Latex a PNG para descargas de PDF.<br> Nota: Si selecciona Google Chart API, Google obtendrá todas las fórmulas del documento si alguien elige utilizar LaTeX<br> Si selecciona Internal Moodle API, necesita un binario de latex, dvips y convert instalado en su servidor.  (Ver <a href="https://docs.moodle.org/38/en/TeX_notation_filter"> Documentación de Moodle</a>)';
$string['global_setting_latexusegoogle'] = 'API Google Chart';
$string['global_setting_latexusemoodle'] = 'API Moodle Interna';
$string['global_setting_use_private_comments'] = '¿Permitir notas personales?';
$string['global_setting_use_private_comments_desc'] = 'Permitir que los participantes escriban anotaciones y notas personales';
$string['global_setting_use_protected_comments'] = '¿Permitir comentarios privados?';
$string['global_setting_use_protected_comments_desc'] = 'Permitir a los participantes escribir anotaciones y comentarios privados. Sólo el autor y el administrador pueden ver este comentario.';
$string['global_setting_use_studentdrawing'] = '¿Permitir dibujar a los participantes?';
$string['global_setting_use_studentdrawing_desc'] = 'Tenga en cuenta que los dibujos son anónimos y no se pueden comentar ni reportar.';
$string['global_setting_use_studenttextbox'] = '¿Permitir cuadros de texto para los participantes?';
$string['global_setting_use_studenttextbox_desc'] = 'Tenga en cuenta que las anotaciones de los cuadros de texto son anónimas y no pueden ser comentadas ni reportadas.';
$string['global_setting_useprint'] = '¿Permitir guardar e imprimir?';
$string['global_setting_useprint_comments'] = '¿Permitir guardar/imprimir comentarios?';
$string['global_setting_useprint_comments_desc'] = 'Permitir a los participantes guardar e imprimir las anotaciones y comentarios';
$string['global_setting_useprint_desc'] = 'Permitir a los participantes guardar e imprimir el documento pdf y sus comentarios';
$string['global_setting_useprint_document'] = '¿Permitir guardar/imprimir el documento?';
$string['global_setting_useprint_document_desc'] = 'Permitir a los participantes guardar e imprimir el documento pdf';
$string['global_setting_usevotes'] = '¿Permitir dar "me gusta" a los comentarios?';
$string['global_setting_usevotes_desc'] = 'Con esta opción los usuarios pueden dar "me gusta" o votar por otras publicaciones que no sean las suyas.';
$string['hiddenComment'] = 'comentario oculto';
$string['hiddenforparticipants'] = 'Ocultar a los estudiantes';
$string['hideAnnotations'] = 'Ocultar anotaciones';
$string['highlight'] = 'Resaltar el texto y añadir un comentario.';
$string['hour'] = 'hora';
$string['hours'] = 'horas';
$string['in_course'] = 'en el curso';
$string['in_document'] = 'en el documento';
$string['infonocomments'] = 'Actualmente este documento no contiene comentarios.';
$string['iscorrecthelpicon'] = 'Correcto';
$string['iscorrecthelpicon_help'] = 'Cuando un profesor o administrador ha marcado una respuesta como correcta, aparece una marca de verificación verde junto a ella.';
$string['itemsperpage'] = 'Comentarios por página';
$string['justnow'] = 'Justo ahora';
$string['lastanswered'] = 'Última respuesta';
$string['lastedited'] = 'Última edición';
$string['legacyfiles'] = 'Migración del archivo del curso antiguo';
$string['legacyfilesactive'] = 'Activo';
$string['legacyfilesdone'] = 'Terminado';
$string['like'] = 'me gusta';
$string['likeAnswer'] = 'útil';
$string['likeAnswerForbidden'] = 'Ya marcado como útil';
$string['likeCountAnswer'] = 'las personas creen que esta respuesta es útil';
$string['likeCountQuestion'] = 'las personas también están interesadas en esta cuestión';
$string['likeForbidden'] = 'No está permitido que te guste este comentario';
$string['likeOwnComment'] = 'mi comentario';
$string['likeQuestion'] = 'pregunta interesante';
$string['likeQuestionForbidden'] = 'Ya marcado como útil';
$string['loading'] = '¡Cargando!';
$string['markCorrect'] = 'Marcar como correcto';
$string['markSolved'] = 'Cerrar pregunta';
$string['markUnsolved'] = 'Reabrir pregunta';
$string['markasread'] = 'Marcar como leído';
$string['markasunread'] = 'Marcar como no leído';
$string['markhidden'] = 'Ocultar';
$string['me'] = 'yo';
$string['messageforwardform'] = 'Su mensaje para el/los destinatario/s';
$string['messageprovider:forwardedquestion'] = 'Cuando se le remitió una pregunta';
$string['messageprovider:newanswer'] = 'Cuando una pregunta a la que se suscribió fue respondida';
$string['messageprovider:newquestion'] = 'Cuando se plantea una nueva pregunta';
$string['messageprovider:newreport'] = 'Cuando un comentario fue publicado';
$string['minute'] = 'minuto';
$string['minutes'] = 'minutos';
$string['missingAnnotation'] = 'La anotación correspondiente no se ha podido encontrar.';
$string['modifiedby'] = 'por';
$string['modulename'] = 'Anotación PDF';
$string['modulename_help'] = 'Esta herramienta permite la anotación colaborativa de documentos PDF. Los usuarios pueden anotar partes específicas de un PDF y discutirlas con otros usuarios.';
$string['modulename_link'] = 'mod/pdfannotator/view';
$string['modulenameplural'] = 'Anotaciones PDF';
$string['month'] = 'mes';
$string['months'] = 'meses';
$string['myanswers'] = 'Mis respuestas';
$string['mypost'] = 'Mi publicación';
$string['myprivate'] = 'Mis comentarios personales';
$string['myprotectedanswers'] = 'Mis respuestas privadas';
$string['myprotectedquestions'] = 'Mis preguntas privadas';
$string['mypublicanswers'] = 'Mis respuestas públicas';
$string['mypublicquestions'] = 'Mis preguntas públicas';
$string['myquestion'] = 'Pregunta';
$string['myquestions'] = 'Mis preguntas';
$string['newanswerhtml'] = 'Su pregunta suscrita "{$a->question}" ha sido respondida por {$a->answeruser} con el comentario: <br /> <br /> "{$a->content}"<br /><br /> La respuesta está disponible <a href="{$a->urltoanswer}">aquí</a>.';
$string['newanswertext'] = 'Su pregunta suscrita "{$a->question}" ha sido respondida por {$a->answeruser} con el comentario: "{$a->content}" La respuesta está disponible en: {$a->urltoanswer}';
$string['newquestionhtml'] = 'Una nueva pregunta fue añadida por {$a->answeruser} con el contenido: <br /> <br /> "{$a->contenido}"<br /><br /> La pregunta está disponible <a href="{$a->urltoanswer}">aquí</a>.';
$string['newquestions'] = 'Preguntado recientemente';
$string['newquestiontext'] = 'Una nueva pregunta fue añadida por {$a->answeruser} con el contenido:"{$a->contenido}" La pregunta está disponible en: {$a->urltoanswer}';
$string['nextPage'] = 'Página siguiente';
$string['noCommentsupported'] = 'Este tipo de anotación no admite comentarios.';
$string['noanswers'] = 'Aún no hay respuestas en este curso.';
$string['noanswerssubscribed'] = 'Aún no hay respuestas a las preguntas suscritas en este curso.';
$string['nomyposts'] = 'Aún no ha publicado ninguna pregunta o respuesta en este curso.';
$string['noquestions'] = '¡No hay preguntas en esta página!';
$string['noquestions_overview'] = 'Actualmente no hay preguntas en este curso.';
$string['noquestions_view'] = 'Actualmente no hay preguntas en este documento.';
$string['noquestionsclosed_overview'] = 'Actualmente no hay preguntas cerradas en este curso.';
$string['noquestionsopen_overview'] = 'Actualmente no hay preguntas abiertas en este curso.';
$string['noreadreports'] = 'Actualmente no hay comentarios leídos en este curso.';
$string['noreports'] = 'Actualmente no hay comentarios en este curso.';
$string['nosearchresults'] = 'No se han encontrado resultados de búsqueda.';
$string['notificationsubject:forwardedquestion'] = 'Pregunta reenviada en {$a}';
$string['notificationsubject:newanswer'] = 'Nueva respuesta a la pregunta suscrita en {$a}';
$string['notificationsubject:newquestion'] = 'Nueva pregunta en {$a}';
$string['notificationsubject:newreport'] = 'Un comentario fue reportado en {$a}';
$string['nounreadreports'] = 'Actualmente no hay comentarios no leídos en este curso';
$string['on'] = 'en';
$string['onlyDeleteOwnAnnotations'] = ', porque pertenece a otro usuario.';
$string['onlyDeleteUncommentedPosts'] = ', porque los comentarios de los demás usuarios se borrarían también.';
$string['openquestions'] = 'sin resolver';
$string['overview'] = 'Visión general';
$string['overviewactioncolumn'] = 'Administrar';
$string['ownpoststab'] = 'Mis publicaciones';
$string['ownpoststabicon'] = 'Mis comentarios';
$string['ownpoststabicon_help'] = 'Esta página muestra todos los comentarios que has publicado en este curso.';
$string['page'] = 'página';
$string['pdfButton'] = 'Documento';
$string['pdfannotator'] = 'Documento';
$string['pdfannotator:addinstance'] = 'añadir instancia';
$string['pdfannotator:administrateuserinput'] = 'Administrar comentarios';
$string['pdfannotator:closeanyquestion'] = 'Cerrar cualquier pregunta';
$string['pdfannotator:closequestion'] = 'Cerrar las preguntas propias';
$string['pdfannotator:create'] = 'Crear anotaciones y comentarios';
$string['pdfannotator:deleteany'] = 'Eliminar cualquier anotación y comentario';
$string['pdfannotator:deleteown'] = 'Eliminar sus propias anotaciones y comentarios';
$string['pdfannotator:edit'] = 'Editar sus propias anotaciones y comentarios';
$string['pdfannotator:editanypost'] = 'Editar cualquier anotación y comentario';
$string['pdfannotator:forwardquestions'] = 'Enviar preguntas';
$string['pdfannotator:getforwardedquestions'] = 'Recibir las preguntas enviadas';
$string['pdfannotator:hidecomments'] = 'Ocultar los comentarios de los participantes';
$string['pdfannotator:markcorrectanswer'] = 'Marcar respuesta como correcta';
$string['pdfannotator:printcomments'] = 'Descargar los comentarios (incluso si la opción está desactivada para un anotador de PDF)';
$string['pdfannotator:printdocument'] = 'Descargar el documento (incluso si la opción está desactivada para un anotador de PDF)';
$string['pdfannotator:recievenewquestionnotifications'] = 'Recibir notificaciones sobre nuevas preguntas';
$string['pdfannotator:report'] = 'Informar de los comentarios inapropiados al responsable del curso';
$string['pdfannotator:seehiddencomments'] = 'Ver comentarios ocultos';
$string['pdfannotator:subscribe'] = 'Suscribirse a una pregunta';
$string['pdfannotator:usedrawing'] = 'Utilizar el dibujo (incluso si la opción está desactivada para un anotador de PDF)';
$string['pdfannotator:usetextbox'] = 'Utilizar el cuadro de texto (incluso si la opción está desactivada para una anotación de PDF)';
$string['pdfannotator:view'] = 'Ver anotación en PDF';
$string['pdfannotator:viewanswers'] = 'Ver las respuestas a las preguntas suscritas (página de resumen)';
$string['pdfannotator:viewposts'] = 'Ver comentarios propios (página de resumen)';
$string['pdfannotator:viewprotectedcomments'] = 'Ver comentarios privados';
$string['pdfannotator:viewquestions'] = 'Ver las preguntas abiertas (página de resumen)';
$string['pdfannotator:viewreports'] = 'Ver los comentarios reportados (página de resumen)';
$string['pdfannotator:viewstatistics'] = 'Ver página de estadísticas';
$string['pdfannotator:viewteacherstatistics'] = 'Ver información adicional en la página de estadísticas';
$string['pdfannotator:vote'] = 'Vote por una pregunta interesante o una respuesta útil';
$string['pdfannotator:writeprivatecomments'] = 'Hacer anotaciones personales';
$string['pdfannotator:writeprotectedcomments'] = 'Escribir comentarios privados';
$string['pdfannotatorcolumn'] = 'Documento';
$string['pdfannotatorcontent'] = 'Ficheros y subcarpetas';
$string['pdfannotatorname'] = 'Herramienta de anotación en PDF';
$string['pluginadministration'] = 'Administración de anotaciones en PDF';
$string['pluginname'] = 'Anotación PDF';
$string['point'] = 'Añadir una chincheta en el documento y escribir un comentario.';
$string['prevPage'] = 'Página anterior';
$string['print'] = 'Descargar documento';
$string['printButton'] = 'Descargar';
$string['printviewtitle'] = 'Comentarios';
$string['printwithannotations'] = 'Descargar comentarios';
$string['privacy:metadata:core_files'] = 'El Pdfannotator almacena archivos que han sido cargados por el usuario como base para la anotación y la discusión.';
$string['privacy:metadata:pdfannotator_annotations'] = 'Información sobre las anotaciones realizadas por un usuario. Incluye el tipo de anotación (por ejemplo, resaltado o dibujo), su posición dentro de un archivo específico, así como la hora de creación.';
$string['privacy:metadata:pdfannotator_annotations:annotationid'] = 'El ID de la anotación que se hizo. Hace referencia a los datos indicados anteriormente.';
$string['privacy:metadata:pdfannotator_annotations:userid'] = 'El ID del usuario que hizo esta anotación.';
$string['privacy:metadata:pdfannotator_comments'] = 'Información sobre los comentarios de un usuario. Esto incluye el contenido y la hora de creación del comentario, así como la anotación subyacente.';
$string['privacy:metadata:pdfannotator_comments:annotationid'] = 'El ID de la anotación subida.';
$string['privacy:metadata:pdfannotator_comments:content'] = 'El comentario literal.';
$string['privacy:metadata:pdfannotator_comments:userid'] = 'El ID de los comentarios del autor.';
$string['privacy:metadata:pdfannotator_reports'] = 'Los usuarios pueden denunciar los comentarios de otros usuarios como inapropiados. Estos informes se almacenan. Incluyen el ID del comentario denunciado, así como el autor, el contenido y la hora de la denuncia.';
$string['privacy:metadata:pdfannotator_reports:commentid'] = 'El Id del comentario realizado';
$string['privacy:metadata:pdfannotator_reports:message'] = 'El contenido del texto del informe.';
$string['privacy:metadata:pdfannotator_reports:userid'] = 'El autor del comentario.';
$string['privacy:metadata:pdfannotator_subscriptions'] = 'Información sobre las suscripciones a preguntas/discusiones individuales.';
$string['privacy:metadata:pdfannotator_subscriptions:annotationid'] = 'El ID de la pregunta/discusión a la que se suscribió.';
$string['privacy:metadata:pdfannotator_subscriptions:userid'] = 'El ID del usuario con esta suscripción.';
$string['privacy:metadata:pdfannotator_votes'] = 'Información sobre las preguntas y los comentarios que se marcaron como interesantes o útiles.';
$string['privacy:metadata:pdfannotator_votes:commentid'] = 'El ID del comentario.';
$string['privacy:metadata:pdfannotator_votes:userid'] = 'El ID del usuario que marcó el comentario como interesante o útil. Se guarda para evitar que los usuarios voten el mismo comentario repetidamente.';
$string['private_comments'] = 'Notas personales';
$string['private_comments_help'] = 'Visible sólo para usted.';
$string['protected_answers'] = 'Respuestas privadas';
$string['protected_comments'] = 'Comentarios privados';
$string['protected_comments_help'] = 'Visibles sólo para usted y los profesores';
$string['protected_questions'] = 'Preguntas privadas';
$string['public_comments'] = 'Comentarios públicos';
$string['publicanswers'] = 'Respuestas públicas';
$string['publicquestions'] = 'Preguntas públicas';
$string['question'] = 'Pregunta';
$string['questionSolved'] = 'Las preguntas están cerradas. Sin embargo, aún puede crear nuevos comentarios.';
$string['questionsimgtitle'] = 'Mostrar todas las preguntas en esta página';
$string['questionstab'] = 'Preguntas';
$string['questionstabicon'] = 'Preguntas';
$string['questionstabicon_help'] = 'Esta página muestra todas las preguntas no resueltas que se hicieron en este curso. También puede elegir ver todas o todas las preguntas resueltas en este curso.';
$string['questionstitle'] = 'Preguntas en la página';
$string['read'] = 'Leer';
$string['reason'] = 'Explicación';
$string['recievenewquestionnotifications'] = 'Notificar las nuevas preguntas';
$string['recipient'] = 'Destinatario/s';
$string['recipient_help'] = 'Para seleccionar varias personas, mantenga pulsada la tecla "Ctrl".';
$string['recipientforwardform'] = 'Enviar a';
$string['recipientrequired'] = 'Por favor seleccione el/los destinatario/s';
$string['rectangle'] = 'Añadir un rectángulo en el documento y escribir un comentario.';
$string['removeCorrect'] = 'Eliminar la marca como correcta';
$string['removehidden'] = 'Mostrar';
$string['report'] = 'Comentario';
$string['reportaddedhtml'] = '{$a->reportinguser} ha enviado un comentario con el mensaje: <br /><br />"{$a->introduction}"<br /><br />Está <a href="{$a->urltoreport}">disponible en el sitio web</a>.';
$string['reportaddedtext'] = '{$a->reportinguser} ha enviado un comentario con el mensaje: "{$a->introduction}" Está disponible en: {$a->urltoreport}';
$string['reportedby'] = 'por';
$string['reportedcomment'] = 'Comentario reportado';
$string['reports'] = 'Comentarios reportados';
$string['reportsendbutton'] = 'Enviar';
$string['reportstab'] = 'Comentarios reportados';
$string['reportstabicon'] = 'Comentarios reportados';
$string['reportstabicon_help'] = 'Esta página muestra los comentarios que fueron reportados como inapropiados en este curso. Puede elegir ver sólo los comentarios no leídos/leídos* o todos los comentarios.<br>* Cualquier administrador de este curso puede marcar un comentario como leído.';
$string['reportwassentoff'] = 'El comentario ha sido publicado.';
$string['search'] = 'Buscar';
$string['searchresults'] = 'Buscar resultados';
$string['second'] = 'segundo';
$string['seconds'] = 'segundos';
$string['seenreports'] = 'sólo leídos';
$string['send'] = 'Enviar';
$string['sendAnonymous'] = 'Comentario anónimo';
$string['sendPrivate'] = 'Publicar nota personal';
$string['sendProtected'] = 'Publicar un comentario privado';
$string['setting_alternative_name'] = 'Nombre';
$string['setting_alternative_name_desc'] = 'Proporcione un nombre alternativo para el PDF. Si está vacío, se tomará el nombre del pdf como nombre representativo';
$string['setting_alternative_name_help'] = 'Si el nombre tiene más de 20 caracteres, los caracteres restantes se sustituirán por \'...\' en la navegación interna del anotador.';
$string['setting_anonymous'] = '¿Permitir la publicación anónima?';
$string['setting_fileupload'] = 'Seleccione un archivo pdf';
$string['setting_fileupload_help'] = 'Sólo puede cambiar el archivo seleccionado hasta que se cree el anotador haciendo clic en "Guardar".';
$string['setting_use_private_comments'] = 'Permitir comentarios personales';
$string['setting_use_private_comments_help'] = 'Permitir a los participantes escribir notas personales. Otra persona no puede ver este comentario.';
$string['setting_use_protected_comments'] = 'Permitir comentarios privados';
$string['setting_use_protected_comments_help'] = 'Permitir a los participantes escribir comentarios privados. Sólo el autor y los profesores pueden ver este comentario.';
$string['setting_use_studentdrawing'] = 'Dibujo';
$string['setting_use_studentdrawing_help'] = 'Permitir a los participantes guardar e imprimir el documento pdf sin anotaciones ni comentarios';
$string['setting_use_studenttextbox'] = 'Cuadro de texto';
$string['setting_use_studenttextbox_help'] = 'Tenga en cuenta que las anotaciones de los cuadros de texto no son anónimas y no pueden ser comentadas ni reportadas.';
$string['setting_useprint'] = 'Guardar e imprimir';
$string['setting_useprint_comments'] = 'Guardar e imprimir comentarios';
$string['setting_useprint_comments_help'] = 'Permitir a los participantes guardar e imprimir las anotaciones y comentarios';
$string['setting_useprint_document'] = 'Guardar e imprimir documento en pdf';
$string['setting_useprint_document_help'] = 'Permitir a los participantes guardar e imprimir el documento pdf';
$string['setting_useprint_help'] = 'Tenga en cuenta que los dibujos no son anónimos y no se pueden comentar ni denunciar.';
$string['setting_usevotes'] = 'Votos/Me gusta';
$string['setting_usevotes_help'] = 'Con esta opción activada, los usuarios pueden dar "me gusta" o votar por otras publicaciones que no sean las suyas.';
$string['show'] = 'Mostrar';
$string['showAnnotations'] = 'Mostras anotaciones';
$string['showless'] = 'menos';
$string['showmore'] = 'más';
$string['slotdatetimelabel'] = 'Fecha y hora';
$string['startDiscussion'] = 'Comenzar una discusión';
$string['statistic'] = 'Estadísticas';
$string['strftimedatetime'] = '%d %b %Y, %I:%M %p';
$string['strikeout'] = 'Tachar el texto y añadir un comentario.';
$string['studentdrawingforbidden'] = 'Este anotador no admite dibujos para su función de usuario.';
$string['studenttextboxforbidden'] = 'Este anotador no admite cuadros de texto para su función de usuario.';
$string['subscribe'] = 'Suscribirse a estas anotaciones';
$string['subscribeQuestion'] = 'Suscribirse';
$string['subscribed'] = 'Suscrito';
$string['subscribedanswers'] = 'a mis preguntas suscritas';
$string['subtitleforreportcommentform'] = 'Su mensaje para el responsable del curso';
$string['successfullyEdited'] = 'Cambios guardados';
$string['successfullyHidden'] = 'Los participantes ven ahora este comentario como oculto.';
$string['successfullyRedisplayed'] = 'El comentario vuelve a ser visible para los participantes';
$string['successfullySubscribed'] = 'Su suscripción a la pregunta fue registrada.';
$string['successfullyUnsubscribed'] = 'Su suscripción fue cancelada.';
$string['successfullyUnsubscribedPlural'] = 'Su suscripción fue cancelada. Todas las respuestas {$a} a la pregunta fueron eliminadas de esta lista.';
$string['successfullyUnsubscribedSingular'] = 'Su suscripción a la pregunta fue cancelada y la única respuesta eliminada de esta lista.';
$string['successfullyUnsubscribedTwo'] = 'Su suscripción fue cancelada. Las dos respuestas a la pregunta fueron eliminadas de esta lista.';
$string['successfullymarkedasread'] = 'El comentario ha sido marcado como leído.';
$string['successfullymarkedasreadandnolongerdisplayed'] = 'El comentario fue marcado como leído y retirado de la lista.';
$string['successfullymarkedasunread'] = 'El comentario ha sido marcado como leído.';
$string['successfullymarkedasunreadandnolongerdisplayed'] = 'El comentario fue marcado como no leído y retirado de la lista.';
$string['sumPages'] = 'Número de páginas';
$string['text'] = 'Añadir un texto en el documento.';
$string['titleforreportcommentform'] = 'Enviar comentario';
$string['titleforwardform'] = 'Enviar pregunta';
$string['toreport'] = 'Comentario';
$string['unseenreports'] = 'sólo no leídos';
$string['unsolvedquestionstitle'] = 'Preguntas sin resolver';
$string['unsolvedquestionstitle_help'] = 'Se enumeran todas las preguntas no resueltas de este curso.';
$string['unsubscribe'] = 'Anular la suscripción a estas anotaciones';
$string['unsubscribeQuestion'] = 'Cancelar la suscripción';
$string['unsubscribe_notification'] = 'Para darse de baja de la notificación, haga clic <a href="{$a}">aquí</a>.';
$string['unsubscribingDidNotWork'] = 'No se ha podido cancelar la suscripción.';
$string['use_private_comments'] = '¿Permitir que los participantes escriban notas personales?';
$string['use_protected_comments'] = '¿Permitir que los participantes escriban comentarios privados?';
$string['use_studentdrawing'] = '¿Permitir que los participantes dibujen?';
$string['use_studenttextbox'] = '¿Habilitar la herramienta de caja de texto para los participantes?';
$string['useprint'] = '¿Proporcionar a los participantes acceso al PDF?';
$string['useprint_comments'] = '¿Proporcionar a los participantes acceso al PDF y a sus comentarios?';
$string['useprint_document'] = '¿Proporcionar a los participantes acceso al PDF?';
$string['usevotes'] = 'Permitir a los usuarios dar "me gusta" en los comentarios.';
$string['view'] = 'Documento';
$string['votes'] = 'Me gusta(n)';
$string['voteshelpicon'] = 'Me gusta(n)';
$string['voteshelpicon_help'] = 'Esta columna le indica cuántas personas están interesadas en la pregunta.';
$string['voteshelpicontwo'] = 'Me gusta(n)';
$string['voteshelpicontwo_help'] = 'Esta columna indica la frecuencia con la que sus publicaciones recibieron <em>"Me gusta"</em>.';
$string['week'] = 'semana';
$string['weeks'] = 'semanas';
$string['year'] = 'año';
$string['years'] = 'años';
$string['yesButton'] = 'Sí';
$string['zoom'] = 'zoom';
$string['zoomin'] = 'Acercar';
$string['zoomout'] = 'Alejar';
