<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'vpl', language 'es', version '4.5'.
 *
 * @package     vpl
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['VPL_COMPILATIONFAILED'] = 'La compilación o preparación de la ejecución ha fallado';
$string['about'] = 'Acerca de';
$string['acceptcertificates'] = 'Aceptar certificados auto firmados';
$string['acceptcertificates_description'] = 'Si sus servidores de ejecución NO están usando certificados auto firmados desmarque esta opción';
$string['acceptcertificatesnote'] = '<p>Usted está usando una conexión cifrada.<p/>
<p>Para usar una conexión cifrada con los servidores de ejecución usted debe aceptar sus certificados de seguridad.</p>
<p>Si no quiere aceptar los certificados o tiene problemas con ese proceso, puede
probar a usar una conexión http (no cifrada) u otro navegador.</p>
<p>Por favor, pulse sobre los siguientes enlaces (Sevidor #) y acepte los certificados ofrecidos.</p>';
$string['addfile'] = 'Añadir fichero';
$string['advanced'] = 'Avanzado';
$string['allfiles'] = 'Todos los ficheros';
$string['allsubmissions'] = 'Todas las entregas';
$string['always_use_ws'] = 'Siempre usar protocolo websocket sin cifrado (ws)';
$string['always_use_wss'] = 'Siempre usar protocolo websocket cifrado (wss)';
$string['anyfile'] = 'Cualquier fichero';
$string['attemptnumber'] = 'Intento número {$a}';
$string['autodetect'] = 'Autodetectar';
$string['automaticevaluation'] = 'Evaluación automática';
$string['automaticgrading'] = 'Calificación automática';
$string['averageperiods'] = 'Periodos promedio {$a}';
$string['averagetime'] = 'Tiempo promedio {$a}';
$string['basedon'] = 'Basado en';
$string['basic'] = 'Básico';
$string['binaryfile'] = 'Fichero binario';
$string['browserupdate'] = 'Actualice su navegador a la última versión<br />o use otro que soporte Websocket';
$string['calculate'] = 'Calcular';
$string['changesNotSaved'] = 'Los cambios no se han guardado';
$string['check_jail_servers'] = 'Comprobación de servidores de ejecución';
$string['check_jail_servers_help'] = '<p>Esta página comprueba y muestra el estado de los servidores de ejecución usados por esta actividad.</p>';
$string['clipboard'] = 'Portapapeles';
$string['closed'] = 'Cerrado';
$string['comments'] = 'Comentarios';
$string['compilation'] = 'Compilación';
$string['connected'] = 'conectado';
$string['connecting'] = 'conectando';
$string['connection_closed'] = 'conexión cerrada';
$string['connection_fail'] = 'conexión fallida';
$string['console'] = 'Consola';
$string['copy'] = 'Copiar';
$string['create_new_file'] = 'Crear un fichero nuevo';
$string['currentstatus'] = 'Estado actual';
$string['cut'] = 'Cortar';
$string['datesubmitted'] = 'Entregado el';
$string['debug'] = 'Depurar';
$string['debugging'] = 'Depurando';
$string['debugscript'] = 'Script de depuración';
$string['debugscript_help'] = 'Seleccionar script de depuración para usar en esta actividad';
$string['defaultexefilesize'] = 'Máximo tamaño por defecto de un fichero en ejecución';
$string['defaultexememory'] = 'Máxima memoria usada por defecto';
$string['defaultexeprocesses'] = 'Máximo número de procesos por defecto';
$string['defaultexetime'] = 'Máximo tiempo de ejecución por defecto';
$string['defaultfilesize'] = 'Tamaño máximo por defecto de cada fichero de subida';
$string['defaultresourcelimits'] = 'Límites por defecto de recursos de ejecución';
$string['delete'] = 'Borrar';
$string['delete_file_fq'] = '¿Confirma el borrado del fichero \'{\\$a}\'?';
$string['delete_file_q'] = '¿Borrar el fichero?';
$string['deleteallsubmissions'] = 'Elimina todas las entregas';
$string['depends_on_https'] = 'Usar wss o ws dependiendo de si se usa http o https';
$string['description'] = 'Descripción';
$string['diff'] = 'diff';
$string['discard_submission_period'] = 'Periodo de descarte de entregas';
$string['discard_submission_period_description'] = 'Para cada estudiante y tarea, se intenta descartar entregas manteniendo la última y al menos una por cada periodo';
$string['download'] = 'Descargar';
$string['downloadallsubmissions'] = 'Descargar todas las entregas';
$string['downloadsubmissions'] = 'Descargar entregas';
$string['duedate'] = 'Límite de entrega';
$string['edit'] = 'Editar';
$string['editing'] = 'Editando';
$string['editortheme'] = 'Tema de editor';
$string['evaluate'] = 'Evaluar';
$string['evaluateonsubmission'] = 'Evaluar al entregar';
$string['evaluating'] = 'evaluando';
$string['evaluation'] = 'Evaluación';
$string['examples'] = 'Ejemplos';
$string['execution'] = 'Ejecución';
$string['executionfiles'] = 'Ficheros para la ejecución';
$string['executionfiles_help'] = '<h2>Introducción</h2>
<p>Aquí se establecen los ficheros necesarios para la ejecución, depurado o evaluación de una entrega.
Esto incluye ficheros script, programas de prueba y ficheros de datos.</p>
<h2>Script por omisión para ejecutar o depurar</h2>
<p>Si no se establecen los script de ejecución o depuración,
el sistema deduce el lenguaje empleado atendiendo a la extensión de los ficheros entregados
para usar un script predefinidos. La siguiente tabla muestra los lenguajes soportados, las extensiones de ficheros usadas, los script disponibles, el compilador/interprete y depurador usado
por este y finalmente un comentario sobre uso del lenguaje.</p>
<table>
<tr><th>Lenguaje</th>
<th>Exten-siones</th>
<th>Ejecutar</th>
<th>Depurar</th>
<th>Compilador/ interprete<br>depurador</th>
<th>Comentario</th>
</tr>
<tr>
<td>Ada</td><td>ada, adb, ads</td><td>X</td><td>X</td><td>gnat (Ada 2005)/gdb</td><td>Usa primer fichero como principal</td>
</tr>
<tr>
<td>C</td><td>c</td><td>X</td><td>X</td><td>gcc C99/gdb</td><td>Compila todos los ficheros fuente</td>
</tr>
<tr>
<td>C++</td><td>cpp, C</td><td>X</td><td>X</td><td>g++/gdb</td><td>Compila todos los ficheros fuente</td>
</tr>
<tr>
<td>C#</td><td>cs</td><td>X</td><td>X</td><td>gmcs+mono/mdb</td><td>Compila todos los ficheros fuente</td>
</tr>
<tr>
<td>Fortran</td><td>f, f77</td><td>X</td><td>X</td><td>gfortran/gdb</td><td>Compila todos los ficheros fuente</td>
</tr>
<tr>
<td>Haskell</td><td>hs</td><td>X</td><td></td><td>hugs</td><td>Ejecuta primer fichero</td>
</tr>
<tr>
<td>Java</td><td>java</td><td>X</td><td>X</td><td>javac+java/jdb</td><td>Compila todos los ficheros fuente.<br />Localiza la clase con main</td>
</tr>
<tr>
<td>Matlab/Octave</td><td>m</td><td>X</td><td>-</td><td>matlab, octave</td><td>Ejecuta el primer fichero.<br>Use vpl_replot después de dibujar..</td>
</tr>
<tr>
<td>Pascal</td><td>pas, p</td><td>X</td><td>X</td><td>fpc o gpc/gdb</td><td>Compila el primer fihero (fpc) o compila todos los ficheros fuente.(gpc)</td>
</tr>
<tr>
<td>Perl</td><td>perl, prl</td><td>X</td><td>X</td><td>perl</td><td>Ejecuta primer fichero.</td>
</tr>
<tr>
<td>PHP</td><td>php</td><td>X</td><td>-</td><td>php5</td><td>Ejecuta primer fichero</td>
</tr>
<tr>
<td>Prolog</td><td>pl, pro</td><td>X</td><td>-</td><td>swipl</td><td>Ejecuta primer fichero</td>
</tr>
<tr>
<td>Python</td><td>py</td><td>X</td><td>X</td><td>python</td><td>Ejecuta primer fichero</td>
</tr>
<tr>
<td>Ruby</td><td>rb</td><td>X</td><td>X</td><td>ruby</td><td>Ejecuta primer fichero</td>
</tr>
<tr>
<td>Scheme</td><td>scm, s</td><td>X</td><td>-</td><td>mzscheme</td><td>Ejecuta primer fichero</td>
</tr>
<tr>
<td>Shell script</td><td>sh</td><td>X</td><td>-</td><td>bash</td><td>Ejecuta primer fichero</td>
</tr>
<tr>
<td>SQL</td><td>sql</td><td>X</td><td>-</td><td>sqlite3</td><td>Ejecuta todos los  ficheros fuente.<br />Primero los establecidos en ficheros de ejecución</td>
</tr>
<tr>
<td>VHDL</td><td>vhd, vhdl</td><td>X</td><td>-</td><td>ghdl</td><td>Compila todos los ficheros fuente, el primero debe tener el método Main.</td>
</tr>
</table>
<h2>Evaluación automática</h2>
<p>Si quiere usar las características de evaluación automática de programas de VPL debe rellenar el fichero "vpl_evaluate.cases".
Este fichero tiene el siguiente formato:</p>
<ul>
<li>"<b>case</b> = Descripción del caso": Optional. Establece el inicio de un caso de prueba.</li>
<li>"<b>input</b> = texto": puede ocupar varias líneas. Finaliza cuando se introduce otra instrucción.</li>
<li>"<b>output</b> = texto": puede ocupar varias líneas.  Finaliza con otra instrucción. Un caso de prueba puede tener varias salidas válidas. Existen tres tipos de salidas: sólo números, texto y texto exacto:
 <ul>
 <li><b>números</b>: Se escriben sólo números. Solo se comprueban los número de la salida, el resto del texto es ignorado. Los números reales se comprueban con cierta tolerancia</li>
 <li><b>texto</b>: Sólo se comprueban palabras, la comparación es insensible a mayúsculas y se ignora el resto de los caracteres.</li>
 <li><b>texto exacto</b>: El texto se escribe entre comillas dobles.</li>
 </ul>
 </li>
<li>"<b>grade reduction</b> = [valor|porcentaje%]" : Por defecto cuando se produce un error se descuenta de la nota máxima  (rango_nota/número de casos)
 pero con esta instrucción se puede cambiar el descuento por otro valor o porcentaje.
</li>
 </ul>
<h2>Uso general</h2>
<p>Aquí se establecen los ficheros necesarios para preparar la ejecución, depuración o evaluación de una entrega. Esto incluye ficheros de script, ficheros de pruebas de programas y ficheros de datos.</p>
<p>Se puede añadir un nuevo fichero escribiendo su nombre en la caja "Añadir fichero" y pulsando luego el botón "Añadir fichero".</p>
<p>Se puede cargar un fichero existente usando el control "Cargar fichero".</p>
<p>Todos los ficheros que se añadan o se cargen pueden ser editados, y todos, excepto los ficheros de script mencionados a continuación, pueden renombrarse o eliminarse.</p>
<p>Deben existir tres ficheros de script para preparar cada una de las tres posibles acciones. Estos ficheros tienen nombres predefinidos: <b>vpl_run.sh</b> (ejecución), <b>vpl_debug.sh</b>, (depuración) y <b>vpl_evaluate.sh</b>, (evaluación)</p>
<p>La ejecución de cualquiera de estos guiones debe generar un fichero denominado <b>vpl_execution</b>. Este fichero debe contener código binario ejecutable, o un script que comience por ""#!/bin/sh". La no generación de este fichero imposibilita ejecutar la acción seleccionada.</p>
<p>Si la actividad se basa en otra, los ficheros de la actividad base se añaden automáticamente. Los contenidos de los ficheros vpl_run.sh, vpl_debug.sh y vpl_evaluate.sh se concatenan para toda la cadena de actividades en la que se base la presente</p>
<p>Finalmente, se añade el fichero <b>vpl_environment.sh</b>, que contiene información sobre la entrega, la cual se suministra mediante variables de entorno:</p>
<ul><li>LANG: el lenguaje empleado.</li>
<li>LC_ALL: el mismo valor que LANG.</li>
<li>VPL_MAXTIME: tiempo máximo de ejecución en segundos.</li>
<li>VPL_FILEBASEURL: URL para acceder a los ficheros del curso.</li>
<li>VPL_SUBFILE#: cada nombre de los ficheros entregados por el alumno. # va de 0 a número de ficheros entregados.</li>
<li>VPL_SUBFILES: lista de todos los ficheros entregados.</li>
<li>VPL_VARIATION+id: donde id es el orden de variación comenzando por 0 y el valor es el valor de la variación.<br></li>
</ul>
Si la acción solicitada es &quot;evaluación&quot; se añaden las siguientes variables:
<ul>
	<li>VPL_MAXTIME: máximo tiempo de ejecución en segundos.</li>
	<li>VPL_MAXMEMORY: máxima memoria usable en byte.</li>
	<li>VPL_MAXFILESIZE: tamaño máximo en bytes de un fichero.</li>
	<li>VPL_MAXPROCESSES: número máximo de procesos que pueden ejecutarse simultaneamente.</li>
	<Li>VPL_FILEBASEURL: URL a ficheros del curso.</Li>
	<li>VPL_GRADEMIN: minimo nota para esta actividad.</li>
	<li>VPL_GRADEMAX: máxima nota para esta actividad.</li>
</ul>

<h2>Códigos de resultado de evaluación</h2>
<p>La salida de la evaluación es procesada para extraer, si es posible, comentarios sobre la evaluación y la nota propuesta.
Los comentarios se pueden establecer de dos formas: con un comentario de línea definido con una línea que comienza por \'Comment :=&gt;&gt;\' o
con comentarios de bloques que comienza con una línea que contiene únicamente \'&lt;|--\' y termina en una línea que contiene únicamente \'--|&gt;\'.
La calificación se toma de la última línea que comienze por \'Grade :=&gt;&gt;\'.
</p>';
$string['executionoptions'] = 'Opciones de ejecución';
$string['executionoptions_help'] = '<p>En esta página se establecen diferentes opciones de ejecución</p>
<ul>
<li><b>Basado en</b>: permite establecer otra instanción VPL de la que se toman diversas caracteristicas:
<ul><li>Ficheros de ejecución (los guiones predefinidos se concatenan)</li>
<li>Límites de los recursos de ejecución.</li>
<li>Variaciones, que se concatenan generando variaciones múltiples.</li>
<li>Tamaño máximo de cada fichero a subir</li>
</ul>
</li>
<li><b>Ejecutar, Depurar y Evaluar</b>: establecen si se puede usar la opción correspondiente durante la edición de la entrega. Esto sólo afecta a los estudiantes, los usuarios con capacidad de calificación pueden usar estas opciones en cualquier caso.</li>
<li><b>Evaluar al entregar</b>: al subir los ficheros se produce el proceso de evaluación automáticamente.</li>
<li><b>Calificación automática</b>: si el resultado de la evaluación contiene códigos de nota automática estos se toman como nota definitiva.</li>
</ul>';
$string['file'] = 'Fichero';
$string['fileNotChanged'] = 'El fichero no ha cambiado';
$string['file_name'] = 'Nombre del fichero';
$string['fileadded'] = 'El fichero \'{\\$a}\' ha sido añadido';
$string['filedeleted'] = 'El fichero \'{\\$a}\' ha sido borrado';
$string['filelist'] = 'Lista de ficheros';
$string['filenotadded'] = 'Fichero no añadido';
$string['filenotdeleted'] = 'El fichero \'{$a}\' NO ha sido borrado';
$string['filenotrenamed'] = 'El fichero \'{$a}\' NO ha sido renombrado';
$string['filerenamed'] = 'El fichero \'{\\$a->from}\' ha sido renombrado a \'{\\$a->to}\'';
$string['filesChangedNotSaved'] = 'Ficheros modificados pero no guardados';
$string['filesNotChanged'] = 'Ficheros no modificados';
$string['filestoscan'] = 'Ficheros a procesar';
$string['fileupdated'] = 'El fichero \'{\\$a}\' ha sido actualizado';
$string['finalreduction'] = 'Reducción final';
$string['finalreduction_help'] = '<b>RF [NE/ER R]</b><br>
<b>RF</b> Reducción final de la calificación.<br>
<b>NE</b> Número de evaluaciones automáticas solicitadas por el estudiante.<br>
<b>ER</b> Evaluaciones sin coste de reducción.<br>
<b>R</b> Reducción por cada evaluación. Si es un porcentaje, se aplicará sucesivamente.<br>';
$string['find'] = 'Buscar';
$string['find_replace'] = 'Buscar/Reemplazar';
$string['freeevaluations'] = 'Evaluaciones sin reducción';
$string['freeevaluations_help'] = 'Número de evaluaciones automáticas que se pueden solicitar sin coste de reducción';
$string['fulldescription'] = 'Descripción completa';
$string['fulldescription_help'] = '<p>Escriba aquí la descripción completa de la tarea a realizar en el laboratorio de programación.</p>
<p>En caso de que no escriba nada se mostrará en su lugar la descripción corta.</p>
<p>Si desea realizar una evaluación automática, es aconsejable que la especificación de las interfaces sea lo más detallada posible y que no tenga ambigüedad.</p>';
$string['fullscreen'] = 'Pantalla completa';
$string['getjails'] = 'Obteniendo servidores de ejecución';
$string['gradeandnext'] = 'Calificar y siguiente';
$string['graded'] = 'Evaluadas';
$string['gradedbyuser'] = 'Evaluadas por el usuario';
$string['gradedon'] = 'Evaluada el';
$string['gradedonby'] = 'Evaluada el {$a->date} por {$a->gradername}';
$string['gradenotremoved'] = 'La calificación NO ha sido eliminada. Comprueba la configuración de la actividad en calificaciones.';
$string['gradenotsaved'] = 'Calificación NO almacenada. Comprueba la configuración de la actividad en calificaciones.';
$string['gradeoptions'] = 'Opciones de evaluación';
$string['grader'] = 'Evaluada por';
$string['gradercomments'] = 'Comentarios del revisor';
$string['graderemoved'] = 'La calificación ha sido eliminada';
$string['groupwork'] = 'En grupo';
$string['inconsistentgroup'] = 'Usted no es miembro de un único grupo (0 o >1)';
$string['incorrect_file_name'] = 'Nombre de fichero incorrecto';
$string['individualwork'] = 'Individual';
$string['instanceselection'] = 'Selección de VPL';
$string['isexample'] = 'Esta actividad actúa como ejemplo';
$string['jail_servers'] = 'Lista de servidores de ejecución';
$string['jail_servers_config'] = 'Configuración de servidores de ejecución';
$string['jail_servers_description'] = 'Escriba un servidor en cada línea';
$string['joinedfiles'] = 'Ficheros seleccionados unidos';
$string['keepfiles'] = 'Ficheros a mantener mientras se ejecuta';
$string['keepfiles_help'] = '<p>Por razones de seguridad, los ficheros añadidos en "Ficheros de ejecución", se borran  antes de ejecutar el fichero vpl_execution.</p>
<p>Si es necesario que alguno de estos ficheros permanezca en la fase de ejecución,
por ejemplo, para usarlo como datos de entrada de las pruebas, márquelos en esta página</p>';
$string['keyboard'] = 'Teclado';
$string['lasterror'] = 'Información del último error';
$string['lasterrordate'] = 'Fecha del último error';
$string['listofcomments'] = 'Lista de comentarios';
$string['listsimilarity'] = 'Lista de similitudes encontradas';
$string['listwatermarks'] = 'Listado de marcas de agua';
$string['load'] = 'Carga';
$string['loading'] = 'Cargando';
$string['local_jail_servers'] = 'Servidores de ejecución locales';
$string['local_jail_servers_help'] = '<p>Aquí se establecen los servidores de ejecución locales para esta actividad y las que se basen en ella.</p>
<p>Escriba una la URL completa de servidor en cada línea. Se pueden introducir líneas en blanco y comentarios comenzando la línea por "#".</p>
<p>Si se quiere impedir que esta actividad y las que se basen en ella no use los servidores especificados en las actividades derivadas ni
los especificados globalmente, añada al final una línea que contenga "end_of_jails".
</p>';
$string['manualgrading'] = 'Calificación manual';
$string['maxexefilesize'] = 'Máximo tamaño de un fichero en ejecución';
$string['maxexememory'] = 'Máxima memoria usada';
$string['maxexeprocesses'] = 'Máximo número de procesos';
$string['maxexetime'] = 'Máximo tiempo de ejecución';
$string['maxfiles'] = 'Número máximo de ficheros';
$string['maxfilesexceeded'] = 'Superado el número máximo de ficheros';
$string['maxfilesize'] = 'Tamaño máximo de cada fichero de subida';
$string['maxfilesizeexceeded'] = 'Superado el tamaño máximo de los ficheros';
$string['maximumperiod'] = 'Periodo máximo {$a}';
$string['maxresourcelimits'] = 'Límites máximos de recursos de ejecución';
$string['maxsimilarityoutput'] = 'Máxima salida por similaridad';
$string['menucheck_jail_servers'] = 'Comprobación servidores ejecución';
$string['menuexecutionfiles'] = 'Ficheros ejecución';
$string['menuexecutionoptions'] = 'Opciones';
$string['menukeepfiles'] = 'Ficheros a mantener';
$string['menulocal_jail_servers'] = 'Servidores ejecución locales';
$string['menuresourcelimits'] = 'Límites de recursos';
$string['minsimlevel'] = 'Nivel de similaridad mínima a mostrar';
$string['moduleconfigtitle'] = 'Configuración del módulo VPL';
$string['modulename'] = 'Laboratorio virtual de programación';
$string['modulename_help'] = '<p>VPL permite la gestión de prácticas de programación teniendo como características más destacadas:
<ul>
<li>Posibilidad de editar el código fuente en el navegador.</li>
<li>Posibilidad de ejecutar las prácticas de forma interactiva desde el navegador.</li>
<li>Posibilidad de ejecutar pruebas que revisen las prácticas.</li>
<li>Búsqueda de similitud entre prácticas para el control del plagio.</li>
<li>Restricciones de entrega de prácticas que limitan el corta y pega de código externo.</li>
</ul></p>
<p><a href="http://vpl.dis.ulpgc.es">Página oficial de Virtual Programming lab</a></p>';
$string['modulename_link'] = 'mod/vpl/view';
$string['modulenameplural'] = 'Laboratorios virtuales de programación';
$string['multidelete'] = 'Borrado múltiple';
$string['nevaluations'] = '{$a} evaluaciones automáticas realizadas';
$string['new'] = 'Nuevo';
$string['new_file_name'] = 'Nombre del fichero nuevo';
$string['next'] = 'Siguiente';
$string['nojailavailable'] = 'No hay servidor de ejecución disponible';
$string['noright'] = 'No tiene permiso de acceso';
$string['nosubmission'] = 'No hay entrega';
$string['notexecuted'] = 'No ejecutado';
$string['notgraded'] = 'No evaluadas';
$string['notsaved'] = 'No guardado';
$string['novpls'] = 'No existe laboratorio de programación definido';
$string['nowatermark'] = 'Marcas de agua propias {$a}';
$string['nsubmissions'] = '{$a} entregas';
$string['numcluster'] = 'Grupo {$a}';
$string['open'] = 'Abierto';
$string['opnotallowfromclient'] = 'Acción no permitida desde esta máquina';
$string['options'] = 'Opciones';
$string['optionsnotsaved'] = 'Opciones no guardas';
$string['optionssaved'] = 'Opciones guardadas';
$string['origin'] = 'Origen';
$string['othersources'] = 'Otras fuentes a usar';
$string['outofmemory'] = 'Memoria agotada';
$string['paste'] = 'Pegar';
$string['pluginadministration'] = 'Administración de VPL';
$string['pluginname'] = 'Laboratorio virtual de programación';
$string['previoussubmissionslist'] = 'Lista entregas previas';
$string['print'] = 'Imprimir';
$string['proposedgrade'] = 'Nota propuesta: {$a}';
$string['proxy'] = 'proxy';
$string['proxy_description'] = 'Proxy de Moodle a servidores de ejecución';
$string['redo'] = 'Rehacer';
$string['reductionbyevaluation'] = 'Reducción por evaluación automática';
$string['reductionbyevaluation_help'] = 'Reducir puntuación final por un valor o porcentaje para cada evaluación automática solicitada por el estudiante';
$string['regularscreen'] = 'Pantalla normal';
$string['removegrade'] = 'Borra calificación';
$string['rename'] = 'Renombrar';
$string['rename_file'] = 'Renombrar fichero';
$string['replace_find'] = 'Reemplazar/Buscar';
$string['requestedfiles'] = 'Ficheros requeridos';
$string['requestedfiles_help'] = '<p>Aquí se fijan nombres y contenido inicial para los ficheros requeridos.</p>
<p>Si no se fijan nombres para el número máximo de ficheros establecido en la definición básica de la actividad, los ficheros para los que no se han establecido nombres son opcionales y pueden tener cualquier nombre.</p>
<p>Además, se pueden establecer contenidos para los ficheros requeridos, de forma que dichos contenidos estarán disponibles la primera vez que el fichero se abra usando el editor, si no se ha realizado una entrega previa.</p>';
$string['requirednet'] = 'Entregas restringidas a la red';
$string['requiredpassword'] = 'Se necesita una clave';
$string['resetfiles'] = 'Reestablecer ficheros';
$string['resetvpl'] = 'Reinicia {$a}';
$string['resourcelimits'] = 'Límites de recursos de ejecución';
$string['resourcelimits_help'] = '<p>Se pueden establecer límites máximos para el tiempo de ejecución, la memoria usada, el tamaño de los ficheros generados durante la ejecución y el número de procesos simultáneos.</p>
<p>Estos límites se aplican al ejecutar los ficheros de script  vpl_run.sh, vpl_debug.sh y vpl_evaluate.sh, y el fichero the file vpl_execution generado por ellos.</p>
<p>Si la actividad está basada en otra, los límites establecidos se pueden ver restringidos por los establecidos en aquella y otras en la que la misma se base, además de por los establecidos en la configuración global del módulo.</p>';
$string['restrictededitor'] = 'Desactivar la carga de archivos, pegar y soltar contenido externo';
$string['retrieve'] = 'Recupera resultados';
$string['run'] = 'Ejecutar';
$string['running'] = 'Ejecutando';
$string['runscript'] = 'Ejecutar script';
$string['runscript_help'] = 'Seleccionar el script de ejecución para usar en esta actividad';
$string['save'] = 'Guardar';
$string['savecontinue'] = 'Guardar y continuar';
$string['saved'] = 'Guardado';
$string['savedfile'] = 'El fichero \'{\\$a}\' ha sido guardado';
$string['saveoptions'] = 'Guardar opciones';
$string['saving'] = 'Guardando';
$string['scanactivity'] = 'Actividad';
$string['scandirectory'] = 'Directorio';
$string['scanningdir'] = 'Examinando el directorio ...';
$string['scanoptions'] = 'Opciones de búsqueda';
$string['scanother'] = 'Buscar similitud en otras fuentes';
$string['scanzipfile'] = 'Fichero zip';
$string['sebkeys'] = 'Clave(s) de examen de Navegador de Examen Seguro';
$string['sebkeys_help'] = 'Clave(s) de examen de Navegador de Examen Seguro (máx 3) obtenidas del archivo .seb <br>Esto es más seguro que la mera revisión del navegador.<br>https://safeexambrowser.org';
$string['sebrequired'] = 'Se requiere Navegador de Examen Seguro';
$string['sebrequired_help'] = 'Se requiere usar Navegador de Examen Seguro configurado apropiadamente';
$string['select_all'] = 'Seleccionar todo';
$string['server'] = 'Servidor';
$string['serverexecutionerror'] = 'Error en el servidor de ejecución';
$string['shortcuts'] = 'Atajos de teclado';
$string['shortdescription'] = 'Descripción corta';
$string['similarity'] = 'Similaridad';
$string['similarto'] = 'Similar a';
$string['startdate'] = 'Disponible desde';
$string['submission'] = 'Entrega';
$string['submissionperiod'] = 'Periodo de entrega';
$string['submissionrestrictions'] = 'Restricciones de entrega';
$string['submissions'] = 'Entregas';
$string['submissionselection'] = 'Selección de entregas';
$string['submissionslist'] = 'Lista de entregas';
$string['submissionview'] = 'Ver entrega';
$string['submittedby'] = 'Entregada por {$a}';
$string['submittedon'] = 'Entregada el';
$string['submittedonp'] = 'Entregada el {$a}';
$string['sureresetfiles'] = '¿Quiere perder todo su trabajo y reestablecer los ficheros a su estado original?';
$string['test'] = 'Probar actividad';
$string['testcases'] = 'Casos de prueba';
$string['testcases_help'] = '<p>Para usar las caracteristicas de evaluación automática de programas de VPL debe rellenar el fichero "vpl_evaluate.cases".
Este fichero tiene el siguiente formato:
<ul>
<li>"<b>case</b> = Descripción del caso": Optional. Establece el inicio de un caso de prueba.</li>
<li>"<b>input</b> = texto": puede ocupar varias líneas. Finaliza cuando se introduce otra instrucción.</li>
<li>"<b>output</b> = texto": puede ocupar varias líneas.  Finaliza con otra instrucción. Un caso de prueba puede tener varias salidas válidas. Existen tres tipos de salidas: sólo números, texto y texto exacto:
 <ul>
 <li><b>números</b>: Se escriben sólo números. Solo se comprueban los número de la salida, el resto del texto es ignorado. Los números reales se comprueban con cierta tolerancia</li>
 <li><b>texto</b>: Sólo se comprueban palabras, la comparación es insensible a mayúsculas y se ignara el resto de los caracteres.</li>
 <li><b>texto exacto</b>: El texto se escribe entre comillas dobles.</li>
 </ul>
 </li>
<li>"<b>grade reduction</b> = [valor|porcentaje%]" : Por defecto cuando se produce un error se descuenta de la nota máxima  (rango_nota/número de casos)
 pero con esta instrucción se puede cambiar el descuento por otro valor o porcentaje.
</li>
</ul>';
$string['timeleft'] = 'Tiempo restante';
$string['timelimited'] = 'Limitado en tiempo';
$string['timeout'] = 'Tiempo sobrepasado';
$string['timeunlimited'] = 'Sin límite de tiempo';
$string['totalnumberoferrors'] = 'Errores';
$string['undo'] = 'Deshacer';
$string['unexpected_file_name'] = 'Nombre de fichero incorrecto: se esperaba \'{\\$a->expected}\' y se encontró \'{\\$a->found}\'';
$string['unzipping'] = 'Descomprimiendo ...';
$string['uploadfile'] = 'Cargar fichero';
$string['usevariations'] = 'Usar variaciones';
$string['usewatermarks'] = 'Usar marcas de agua';
$string['usewatermarks_description'] = 'Añade marcas de agua a los ficheros de los estudiantes (sólo en lenguajes soportados)';
$string['variation_options'] = 'Opciones de variación';
$string['variations'] = 'Variaciones';
$string['variations_help'] = '<p>Se pueden definir variaciones para las actividades. Las variaciones se asignan de forma aleatoria a los estudiantes.</p>
<p>En esta página se puede indicar si la actividad tiene variaciones, dar un título al conjunto de variaciones, y añadir las variaciones deseadas.</p>
<p>Cada variación tiene un código de identificación y una descripción. El identificador se usa en el fichero <b>vpl_enviroment.sh</b> para pasar la
variación asignada al estudiante a los scripts. La descripción, con formato HTML, se muestra a los estudiantes a los que ha sido asignada la variación
correspondiente.</p>';
$string['variations_unused'] = 'Esta actividad tiene variaciones, pero están desactivadas';
$string['variationtitle'] = 'Título de variación';
$string['varidentification'] = 'Identificación';
$string['visiblegrade'] = 'Mostrar evaluación';
$string['vpl'] = 'Laboratorio virtual de programación';
$string['vpl:addinstance'] = 'Añade nuevas actividades VPL';
$string['vpl:grade'] = 'Evaluar una entrega';
$string['vpl:manage'] = 'Gestionar un vpl';
$string['vpl:setjails'] = 'Establece servidores de ejecución para instancias concretas de VPL';
$string['vpl:similarity'] = 'Buscar similiudes entre entregas';
$string['vpl:submit'] = 'Hacer entregas';
$string['vpl:view'] = 'Ver la descripción completa de un vpl';
$string['vpl_debug.sh'] = 'Prepara la depuración del programa';
$string['vpl_evaluate.cases'] = 'Escriba aquí los casos de prueba para evaluar automáticamente el programa';
$string['vpl_evaluate.sh'] = 'Evalúa el programa';
$string['vpl_run.sh'] = 'Prepara la ejecución del programa';
$string['websocket_protocol'] = 'Protocolo WebSocket';
$string['websocket_protocol_description'] = 'Tipo protocolo WebSocket (ws:// or wss://) a usar por el navegador al conectarse al servidor de ejecución.';
$string['workingperiods'] = 'Periodos de trabajo';
$string['worktype'] = 'Tipo de trabajo';
