<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'tool_mobile', language 'sk', version '4.5'.
 *
 * @package     tool_mobile
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['adodbdebugwarning'] = 'Ladenie ADOdb je povolené. Malo by byť zakázané v nastaveniach doplnku na overenie externej databázy alebo externej registrácie do databázy.';
$string['androidappid'] = 'Jedinečný identifikátor aplikácie pre Android';
$string['androidappid_desc'] = 'Toto nastavenie môže byť ponechané ako predvolené, pokiaľ nemáte vlastnú aplikáciu pre Android.';
$string['apppolicy'] = 'Webová adresa pravidiel aplikácie';
$string['apppolicy_help'] = 'Webová adresa pravidla pre používateľov aplikácie, ktorá je uvedená na stránke Informácie v aplikácii. Ak pole ponecháte prázdne, použije sa namiesto neho adresa URL pravidiel portálu.';
$string['apprequired'] = 'Táto funkcia je dostupná len vtedy, keď k nej pristupujete prostredníctvom mobilnej alebo desktopovej aplikácie Moodle.';
$string['autologinkeygenerationlockout'] = 'Generovanie automatického prihlasovacieho kľúča je zablokované. Medzi jednotlivými žiadosťami musíte počkať {$a} minút.';
$string['autologinmintimebetweenreq'] = 'Minimálny čas medzi žiadosťami o automatické prihlásenie';
$string['autologinmintimebetweenreq_desc'] = 'Minimálny čas medzi žiadosťami o automatické prihlásenie z mobilnej aplikácie. Ak sú používatelia aplikácie často žiadaní, aby zadali svoje poverenia pri prezeraní obsahu vloženého z portálu, nastavte nižšiu hodnotu.';
$string['autologinnotallowedtoadmins'] = 'Automatické prihlásenie nie je povolené pre správcov portálu.';
$string['cachedef_plugininfo'] = 'Toto ukladá zoznam doplnkov s mobilnými doplnkami';
$string['cachedef_subscriptiondata'] = 'Toto ukladá informácie o predplatnom aplikácie Moodle.';
$string['clickheretolaunchtheapp'] = 'Kliknite sem, ak sa aplikácia neotvorí automaticky.';
$string['configmobilecssurl'] = 'CSS súbor na prispôsobenie rozhrania vašej mobilnej aplikácie.';
$string['customlangstrings'] = 'Vlastné jazykové reťazce';
$string['customlangstrings_desc'] = 'Slová a frázy zobrazené v aplikácii je možné prispôsobiť tu. Zadajte každý reťazec vlastného jazyka na nový riadok vo formáte: identifikátor reťazca, reťazec vlastného jazyka a kód jazyka oddelené zvislými znakmi. Napríklad:
<pred>
mm.user.student|Študent|sk
mm.user.student|Aprendiz|es
</pre>
Úplný zoznam identifikátorov reťazcov nájdete v dokumentácii.';
$string['custommenuitems'] = 'Vlastné položky ponuky';
$string['custommenuitems_desc'] = 'Do hlavnej ponuky aplikácie je možné pridať ďalšie položky tak, že ich zadáte tu. Zadajte každú vlastnú položku ponuky na nový riadok s formátom: text položky, adresa URL odkazu, spôsob otvárania odkazu a kód jazyka (voliteľné, na zobrazenie položky len používateľom v zadanom jazyku), oddelené zvislými znakmi.

Metódy otvárania odkazu sú: aplikácia (na prepojenie s aktivitou podporovanou aplikáciou), inappbrowser (na otvorenie odkazu v prehliadači bez opustenia aplikácie), prehliadač (na otvorenie odkazu v predvolenom prehliadači zariadenia mimo aplikácie) a vložené (na zobrazenie odkazu v prvku iframe na novej stránke v aplikácii).

Ak položkám chýba preklad pre daný jazyk, použijú sa iné jazyky ako záložné, pokiaľ sa ku kódu jazyka nepripojí „_only“.

Napríklad:
<pred>
Pomocník aplikácie|https://someurl.xyz/help|inappbrowser
Moje známky|https://someurl.xyz/local/mygrades/index.php|embedded|sk
Mis calificaciones|https://someurl.xyz/local/mygrades/index.php|embedded|es
Toto uvidíte iba v angličtine|https://someurl.xyz/english|browser|en_only
</pre>';
$string['darkmode'] = 'Tmavý režim';
$string['disabledfeatures'] = 'Zakázané funkcie';
$string['disabledfeatures_desc'] = 'Tu vyberte funkcie, ktoré chcete zakázať v mobilnej aplikácii pre váš portál. Upozorňujeme, že niektoré funkcie uvedené tu už môžu byť zakázané prostredníctvom iných nastavení portálu. Ak chcete vidieť zmeny, musíte sa odhlásiť a znova prihlásiť do aplikácie.';
$string['displayerrorswarning'] = 'Zobrazenie ladiacich správ (debugdisplay) je povolené. Malo by byť zakázané.';
$string['downloadcourse'] = 'Stiahnuť kurz';
$string['downloadcourses'] = 'Stiahnuť kurzy';
$string['enablesmartappbanners'] = 'Povoliť bannery aplikácií';
$string['enablesmartappbanners_desc'] = 'Ak je povolené, pri prístupe na portál pomocou mobilného prehliadača sa zobrazí banner propagujúci mobilnú aplikáciu.';
$string['filetypeexclusionlist'] = 'Zoznam vylúčených typov súborov';
$string['filetypeexclusionlist_desc'] = 'Vyberte všetky typy súborov, ktoré sa nedajú použiť na mobilnom zariadení. Takéto súbory budú uvedené v kurze a ak sa ich používateľ pokúsi otvoriť, zobrazí sa upozornenie, že daný typ súboru nie je určený na použitie na mobilnom zariadení. Používateľ potom môže varovanie zrušiť alebo ignorovať a súbor aj tak otvoriť.';
$string['filetypeexclusionlistplaceholder'] = 'Zoznam vylúčených typov súborov na mobilnom zariadení';
$string['forcedurlscheme'] = 'Ak chcete povoliť otváranie iba vašej vlastnej značkovej aplikácie cez okno prehliadača, zadajte tu schému adresy URL. Ak chcete povoliť iba oficiálnu aplikáciu, nastavte predvolenú hodnotu. Ak chcete povoliť akúkoľvek aplikáciu, nechajte pole prázdne.';
$string['forcedurlscheme_key'] = 'URL schéma';
$string['forcelogout'] = 'Vynútiť odhlásenie';
$string['forcelogout_desc'] = 'Ak je táto možnosť povolená, používatelia budú vždy úplne odhlásení aj pri prepínaní účtov. Pri ďalšom prístupe na portál musia potom znova zadať svoje heslo.';
$string['getmoodleonyourmobile'] = 'Stiahnite si mobilnú aplikáciu';
$string['h5poffline'] = 'Zobraziť obsah H5P offline';
$string['httpsrequired'] = 'Vyžadované HTTPS';
$string['insecurealgorithmwarning'] = 'Zdá sa, že certifikát HTTPS používa na podpisovanie nezabezpečený algoritmus (SHA-1). Skúste aktualizovať certifikát.';
$string['invalidcertificatechainwarning'] = 'Zdá sa, že reťazec certifikátov je neplatný. Tento certifikát môže fungovať pre prehliadač, ale nie pre mobilnú aplikáciu.';
$string['invalidcertificateexpiredatewarning'] = 'Zdá sa, že platnosť certifikátu HTTPS pre web vypršala.';
$string['invalidcertificatestartdatewarning'] = 'Zdá sa, že certifikát HTTPS pre portál ešte nie je platný (s dátumom začiatku v budúcnosti).';
$string['invalidprivatetoken'] = 'Neplatný súkromný token. Token by nemal byť prázdny ani odovzdaný cez parameter GET.';
$string['invaliduserquotawarning'] = 'Používateľská kvóta (userquita) je nastavená na neplatné číslo. Mala by byť nastavená na platné číslo (celé číslo) v nastaveniach zabezpečenia portálu.';
$string['iosappid'] = 'Jedinečný identifikátor aplikácie pre iOS';
$string['iosappid_desc'] = 'Toto nastavenie možno ponechať ako predvolené, pokiaľ nemáte vlastnú aplikáciu pre iOS.';
$string['launchviasiteinbrowser'] = 'Spustiť cez stránku v systémovom prehliadači';
$string['loginintheapp'] = 'prostredníctvom aplikácie';
$string['logininthebrowser'] = 'Cez okno prehliadača (pre doplnky SSO)';
$string['loginintheembeddedbrowser'] = 'Prostredníctvom vstavaného prehliadača (pre doplnky SSO)';
$string['logoutconfirmation'] = 'Naozaj sa chcete odhlásiť z mobilnej aplikácie na svojich mobilných zariadeniach? Po odhlásení budete musieť znova zadať svoje používateľské meno a heslo do mobilnej aplikácie na všetkých zariadeniach, kde máte aplikáciu nainštalovanú.';
$string['mainmenu'] = 'Hlavné menu';
$string['managefiletypes'] = 'Spravovať typy súborov';
$string['minimumversion'] = 'Ak je špecifikovaná verzia aplikácie (3.8.0 alebo vyššia), všetci používatelia, ktorí používajú staršiu verziu aplikácie, budú vyzvaní, aby aktualizovali svoju aplikáciu predtým, ako im bude povolený prístup na portál.';
$string['minimumversion_key'] = 'Vyžaduje sa minimálna verzia aplikácie';
$string['mobileapp'] = 'Apka na mobil';
$string['mobileappearance'] = 'Mobilný vzhľad';
$string['mobileappenabled'] = 'Tento portál povoľuje prístup s mobilnou aplikáciou. <br /><a href="{$a}">Stiahnuť mobilnú aplikáciu</a>.';
$string['mobileappsubscription'] = 'Predplatné aplikácie Moodle';
$string['mobileauthentication'] = 'Mobilná autentifikácia';
$string['mobilecssurl'] = 'CSS';
$string['mobilefeatures'] = 'Mobilné funkcie';
$string['mobilenotificationsdisabledwarning'] = 'Nie sú povolené mobilné upozornenia. Mali by byť povolené na stránke Nastavenie upozornení.';
$string['mobilesettings'] = 'Mobilné nastavenia';
$string['moodleappsportalfeatureswarning'] = 'Upozorňujeme, že niektoré funkcie môžu byť obmedzené v závislosti od vášho predplatného aplikácie Moodle. Podrobnosti nájdete na <a href="{$a}" target="_blank">portáli aplikácií Moodle</a>.';
$string['notifications'] = 'Upozornenia';
$string['notificationsactivedevices'] = 'Aktívne zariadenia';
$string['notificationscurrentactivedevices'] = 'Zariadenia prijímajúce upozornenia tento mesiac';
$string['notificationsignorednotifications'] = 'Upozornenia neboli odoslané';
$string['notificationslimitreached'] = 'Mesačný limit aktívnych používateľských zariadení bol prekročený. Upozornenia pre niektorých používateľov nebudú odoslané. Odporúčame vám inovovať plán aplikácií na <a href="{$a}" target="_blank">portáli aplikácií Moodle</a>.';
$string['notificationsmissingwarning'] = 'Štatistiky upozornení aplikácie Moodle sa nepodarilo získať. Je to pravdepodobne preto, že na stránke ešte nie sú povolené mobilné upozornenia. Môžete ich povoliť v časti Správa stránky / Správy / Mobil.';
$string['notificationsnewdevices'] = 'Nové zariadenia';
$string['notificationsseemore'] = 'Poznámka: Štatistiky používania aplikácie Moodle sa nepočítajú v reálnom čase. Ak chcete získať prístup k podrobnejším štatistikám vrátane údajov z predchádzajúcich mesiacov, prihláste sa na <a href="{$a}" target="_blank">portál aplikácií Moodle</a>.';
$string['notificationssentnotifications'] = 'Upozornenia boli odoslané';
$string['oauth2identityproviders'] = 'Poskytovatelia identity OAuth 2';
$string['offlineuse'] = 'Použitie offline';
$string['pluginname'] = 'Nástroje apky Moodle';
$string['pluginnotenabledorconfigured'] = 'Plugin nie je povolený alebo nakonfigurovaný.';
$string['privacy:metadata:core_userkey'] = 'Používateľské kľúče používané na vytvorenie kľúča automatického prihlásenia pre aktuálneho používateľa.';
$string['privacy:metadata:preference:tool_mobile_autologin_request_last'] = 'Dátum poslednej žiadosti o kľúč na automatické prihlásenie. Medzi každou žiadosťou je potrebných 6 minút.';
$string['qrcodedisabled'] = 'Prístup cez QR kód je zakázaný';
$string['qrcodeformobileappaccess'] = 'QR kód pre prístup do mobilnej aplikácie';
$string['qrcodeformobileapploginabout'] = 'Naskenujte QR kód pomocou mobilnej aplikácie a budete automaticky prihlásení. Platnosť QR kódu vyprší o {$a}.';
$string['qrcodeformobileappurlabout'] = 'Naskenujte QR kód pomocou mobilnej aplikácie a vyplňte adresu URL stránky vo svojej aplikácii.';
$string['qrcodetype'] = 'Prístup pomocou QR kódu';
$string['qrcodetype_desc'] = 'Používatelia mobilnej aplikácie môžu naskenovať QR kód. Toto je možné použiť na vyplnenie URL portálu, alebo ak je portál zabezpečený pomocou HTTPS, na automatické prihlásenie používateľa bez toho, aby musel zadávať svoje používateľské meno a heslo.';
$string['qrcodetypelogin'] = 'QR kód s automatickým prihlásením';
$string['qrcodetypeurl'] = 'QR kód s URL adresou portálu';
$string['qrkeyttl'] = 'Trvanie overovacieho kľúča QR';
$string['qrkeyttl_desc'] = 'Čas, počas ktorého je platný QR kód na automatické prihlásenie.';
$string['qrsiteadminsnotallowed'] = 'Z bezpečnostných dôvodov nie je prihlásenie pomocou QR kódu povolené pre administrátorov stránok alebo ak ste prihlásený ako iný používateľ.';
$string['readingthisemailgettheapp'] = 'Čítate túto správu v maili? <a href="{$a}">Stiahnite si mobilnú aplikáciu a dostávajte notifikácie na svojom mobilnom telefóne</a>.';
$string['remoteaddons'] = 'Vzdialené doplnky';
$string['responsivemainmenuitems'] = 'Responzívne položky ponuky';
$string['scanqrcode'] = 'Naskenovať QR kód';
$string['selfsignedoruntrustedcertificatewarning'] = 'Zdá sa, že certifikát HTTPS je podpísaný sám sebou alebo nie je dôveryhodný. Mobilná aplikácia bude fungovať iba s dôveryhodnými stránkami. Na diagnostiku problému použite akúkoľvek online kontrolu SSL. Ak to znamená, že váš certifikát je v poriadku, môžete toto upozornenie ignorovať.';
$string['setuplink'] = 'Stránka na stiahnutie aplikácie';
$string['setuplink_desc'] = 'Adresa URL stránky s odkazmi k stiahnutiu mobilnej aplikácie z App Store a Google Play. Odkaz na stránku na stiahnutie aplikácie sa zobrazuje v päte stránky a v profile používateľa. Ak chcete odkaz nezobrazovať, nechajte pole prázdne.';
$string['smartappbanners'] = 'Bannery appky';
$string['subscription'] = 'Predplatné';
$string['subscriptioncreated'] = 'Dátum začiatku';
$string['subscriptionerrorrequest'] = 'Pri pokuse o načítanie informácií o odbere vašej appky Moodle sa vyskytla neočakávaná chyba.';
$string['subscriptionexpiration'] = 'Dátum expirácie';
$string['subscriptionfeaturenotapplied'] = 'Táto funkcia je nakonfigurovaná na vašej stránke, ale nie je zahrnutá vo vašom pláne aplikácie Moodle. Nastavenie teda nebude mať žiadny vplyv.';
$string['subscriptionfeatures'] = 'Funkcie predplatného';
$string['subscriptionlimitsurpassed'] = 'Prekročený limit predplatného';
$string['subscriptionregister'] = 'Podrobnosti o rôznych plánoch aplikácií a prístup k štatistikám používania aplikácií Moodle nájdete na <a href="{$a}" target="_blank">portáli aplikácií Moodle</a>.';
$string['subscriptionsseemore'] = 'Poznámka: Zobrazené informácie sa neaktualizujú v reálnom čase. Ak chcete zobraziť aktualizácie, možno sa budete musieť odhlásiť a znova prihlásiť. Ak chcete získať informácie o inovácii plánu aplikácií, prihláste sa na <a href="{$a}" target="_blank">portál aplikácií Moodle</a>.';
$string['switchaccount'] = 'Prepnúť účet';
$string['typeoflogin'] = 'Typ prihlásenia';
$string['typeoflogin_desc'] = 'Ak stránka používa metódu autentifikácie SSO, vyberte ju cez okno prehliadača alebo cez vstavaný prehliadač. Vstavaný prehliadač poskytuje lepšiu používateľskú skúsenosť, hoci nefunguje so všetkými doplnkami SSO.';
$string['viewqrcode'] = 'Zobraziť QR kód';
