<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'attendance', language 'cs', version '4.5'.
 *
 * @package     attendance
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['Aacronym'] = 'N';
$string['Afull'] = 'Nepřítomní';
$string['Eacronym'] = 'O';
$string['Efull'] = 'Omluveni';
$string['Lacronym'] = 'Z';
$string['Lfull'] = 'Zpožděni';
$string['Pacronym'] = 'P';
$string['Pfull'] = 'Přítomen';
$string['absenteereport'] = 'Sestava nepřítomných';
$string['acronym'] = 'Zkratka';
$string['add'] = 'Přidat';
$string['addedrecip'] = 'Přidán {$a} nový příjemce';
$string['addedrecips'] = 'Přidáno {$a} nových příjemců';
$string['addmultiplesessions'] = 'Opakovaná cvičení';
$string['addsession'] = 'Přidat cvičení';
$string['adduser'] = 'Přidat uživatele';
$string['addwarning'] = 'Přidat varování';
$string['all'] = 'Vše';
$string['allcourses'] = 'Všechny kurzy';
$string['allowupdatestatus'] = 'Umožnit studentům aktualizovat si vlastní docházku';
$string['allowupdatestatus_desc'] = 'Pokud je zaškrtnuto, studenti budou moci aktualizovat svou docházku na cvičení poté, co ji sami nahlásí.';
$string['allowupdatestatus_help'] = 'Pokud je zaškrtnuto, studenti budou moci aktualizovat svou docházku na cvičení poté, co ji sami nahlásí.';
$string['allpast'] = 'Vše v minulosti';
$string['allsessions'] = 'Všechna cvičení';
$string['allsessionstotals'] = 'Součty za vybraná cvičení';
$string['attendance:addinstance'] = 'Přidat novou činnost Docházka';
$string['attendance:canbelisted'] = 'Objeví se v seznamu';
$string['attendance:changeattendances'] = 'Upravit Docházku';
$string['attendance:changepreferences'] = 'Změnit nastavení';
$string['attendance:export'] = 'Export sestav';
$string['attendance:import'] = 'Import cvičení ze souboru (csv)';
$string['attendance:manageattendances'] = 'Správa Docházky';
$string['attendance:managetemporaryusers'] = 'Spravovat dočasné uživatele';
$string['attendance:manualautomark'] = 'Povolit proces ručního automatického označování';
$string['attendance:takeattendances'] = 'Zadat docházku';
$string['attendance:view'] = 'Zobrazení docházky';
$string['attendance:viewreports'] = 'Zobrazení sestav';
$string['attendance:viewsummaryreports'] = 'Zobrazení souhrnných přehledů kurzu';
$string['attendance:warningemails'] = 'Lze se přihlásit k odběru e-mailů s nepřítomnými uživateli';
$string['attendance_already_submitted'] = 'Vaše docházka již byla nastavena.';
$string['attendance_no_status'] = 'Není k dispozici žádný platný stav - možná byste přišli příliš pozdě na to, abyste zaznamenali účast.';
$string['attendancedata'] = 'Data docházky';
$string['attendancefile'] = 'Soubor s docházkou (formát CSV)';
$string['attendancefile_help'] = 'Soubor musí být CSV soubor s řádkem záhlaví a poli pro identifikaci záznamu uživatele a času docházky např. (E-mail, čas skenu) nebo (uživatelské jméno, čas)';
$string['attendancegrade'] = 'Známka za docházku';
$string['attendancenotset'] = 'Musíte nastavit svou docházku';
$string['attendancenotstarted'] = 'V tomto kurzu nebyla Docházka zahájena';
$string['attendancepercent'] = 'Procento účasti';
$string['attendancereport'] = 'Docházka';
$string['attendanceslogged'] = 'Docházka je žurnálována';
$string['attendancestaken'] = 'Docházka přijata';
$string['attendancesuccess'] = 'Účast byla úspěšně přijata';
$string['attendanceupdated'] = 'Docházka úspěšně aktualizována';
$string['attendanceuserreport'] = 'Sestava docházky';
$string['attforblockdirstillexists'] = 'starý adresář "mod/attforblock" stále existuje - před spuštěním této aktualizace je nutné odstranit tento adresář na serveru.';
$string['attrecords'] = 'Záznamy docházky';
$string['autoassignstatus'] = 'Automaticky vybrat nejvyšší dostupný stav';
$string['autoassignstatus_help'] = 'Pokud je vybrána tato možnost, bude studentům automaticky přidělena nejvyšší dostupná známka.';
$string['automark'] = 'Automatické známkování';
$string['automark_help'] = 'Umožňuje automatické vyplňování stavu.
Pokud "Ano", studenti budou automaticky označeni v závislosti na jejich prvním přístupu do kurzu.
Pokud je "Na konci cvičení nastavit na neoznačené", všichni studenti, kteří nezaznamenali svou účast, budou nastaveni na vybraný stav nepřítomnosti.';
$string['automarkall'] = 'Ano';
$string['automarkclose'] = 'Na konci cvičení nastavit na neoznačené';
$string['automarkingcomplete'] = 'Automatické značení dokončeno';
$string['automarkingnotavailableyet'] = 'Toto cvičení používá automatické označování při uzavření cvičení a cvičení ještě neskončilo.';
$string['automarkingnotenabled'] = 'Automatické označování není v tomto cvičení povoleno';
$string['automarktask'] = 'Zkontrolujte docházku na cvičení, které vyžadují automatické vyplnění';
$string['automarkuseempty'] = 'Automaticky označit stav dostupnosti';
$string['automarkuseempty_desc'] = 'Pokud je zaškrtnuto, položky stavu, které mají prázdné/nenastavené nastavení „dostupné pro“, budou během automatického označování povoleny';
$string['autorecorded'] = 'systém automaticky nahrál docházku';
$string['availability'] = 'Dostupnost vlastního označení docházky';
$string['availability_help'] = 'Omezit dostupnost tohoto stavu. <br> Pokud je vybrána možnost „Omezeno“, zadejte počet minut, po které je tento stav k dispozici po zahájení cvičení. To platí, když si studenti sami označují docházku.';
$string['availabilityalways'] = 'Vždy';
$string['availabilitylimitedtime'] = 'Omezený čas';
$string['availabilityno'] = 'Ne';
$string['availablebeforesession'] = 'K dispozici před zahájením cvičení';
$string['availablebeforesession_help'] = 'Když studenti označují svou vlastní účast, povolte, aby byl tento stav zvolen před zahájením cvičení.';
$string['averageattendance'] = 'Průměrná docházka';
$string['averageattendancegraded'] = 'Průměrná docházka';
$string['backtoparticipants'] = 'Zpět na seznam účastníků';
$string['below'] = 'Pod {$a}%';
$string['calclose'] = 'Zavřít';
$string['calendarevent'] = 'Vytvoření události kalendáře pro cvičení';
$string['calendarevent_help'] = 'Pokud je tato událost zapnuta, bude pro toto cvičení vytvořena událost kalendáře. Pokud je tato událost deaktivována, odstraní se pro toto cvičení veškeré události kalendáře.';
$string['caleventcreated'] = 'Událost kalendáře byla pro relaci úspěšně vytvořena';
$string['caleventdeleted'] = 'Událost kalendáře byla pro relaci úspěšně odstraněna';
$string['calmonths'] = 'Leden,Únor,Březen,Duben,Květen,Červen,Červenec,Srpen,Září,Říjen,Listopad,Prosinec';
$string['calshow'] = 'Zvolte datum';
$string['calweekdays'] = 'Ne,Po,Út,St,Čt,Pá,So';
$string['cannottakeforgroup'] = 'Pro skupinu "{$a}" nemůžete zadávat docházku';
$string['cannottakethisgroup'] = 'Nejste členem skupiny kurzu, které se toto cvičení týká, vaše docházka nebyla zaznamenána.';
$string['cantaddstatus'] = 'Při přidávání nového stavu musíte zadat zkratku a popis.';
$string['canthidestatus'] = 'Tento stav nemůžete skrýt, protože se již používá v rámci této aktivity docházky';
$string['categoryreport'] = 'Sestava kategoriiekurzu';
$string['changeattendance'] = 'Změna docházky';
$string['changeduration'] = 'Změna doby trvání';
$string['changesession'] = 'Změna cvičení';
$string['checkweekdays'] = 'Vyberte dny v týdnu, které spadají do zvoleného časového období cvičení.';
$string['closed'] = 'Toto cvičení není momentálně k dispozici pro zadání studentem';
$string['column'] = 'sloupec';
$string['columnmap'] = 'Mapování sloupců';
$string['columnmap_help'] = 'U každého z uvedených polí vyberte odpovídající sloupec v souboru CSV.';
$string['columns'] = 'sloupce';
$string['commonsession'] = 'Společné';
$string['commonsessions'] = 'Společné';
$string['confirm'] = 'Potvrdit';
$string['confirmcolumnmappings'] = 'Potvrďte mapování sloupců';
$string['confirmdeletehiddensessions'] = 'Jste si jisti, že chcete odstranit {$a-> count} cvičení naplánovaných před datem zahájení kurzu ({$a-> date})?';
$string['confirmdeleteuser'] = 'Jste si jisti, že chcete odstranit uživatele "{$a-> fullname}" ({$a->email})? <br/> Všechny jejich záznamy docházky budou trvale odstraněny.';
$string['copyfrom'] = 'Kopírování dat docházky z';
$string['countofselected'] = 'Počet vybraných';
$string['course'] = 'Kurz';
$string['coursemessage'] = 'Zpráva uživatelům kurzu';
$string['courseshortname'] = 'Krátký název kurzu';
$string['coursesummary'] = 'Souhrnná sestava o kurzu';
$string['createmultiplesessions'] = 'Vytvoření opakovaných cvičení';
$string['createmultiplesessions_help'] = 'Tato funkce vám umožní vytvořit opakované cvičení v jednom kroku.

* <strong>Cvičení Datum zahájení:</strong> Vyberte datum začátku kurzu (první den ve třídě)
* <strong>Cvičení Datum ukončení:</strong> Vyberte poslední den třídy (poslední den chcete mít docházku).
* <strong>Cvičení Dny:</strong> Vyberte dny v týdnu, kdy se s třídou setkáte  (např. pondělí / středa / pátek).
 * <strong>Frekvence:</strong> To umožňuje nastavení frekvence. Pokud se vaše třída bude scházet každý týden, zvolte 1, pokud splní každý druhý týden, zvolte 2, každý třetí týden, vyberte 3, atd.';
$string['createonesession'] = 'Vytvořit jedno cvičení v kurzu';
$string['csvdelimiter'] = 'CSV oddělovač';
$string['currentlyselectedusers'] = 'Aktuálně vybraní uživatelé';
$string['customexportfields'] = 'Export pole vlastních profilů uživatele';
$string['customexportfields_help'] = 'Další pole uživatelského profilu, která se mají zobrazit v sestavě exportu.';
$string['customfields'] = 'Vlastní pole cvičení';
$string['date'] = 'Datum';
$string['days'] = 'Dny';
$string['defaultdisplaymode'] = 'Výchozí režim zobrazení';
$string['defaults'] = 'Výchozí';
$string['defaultsessionsettings'] = 'Výchozí nastavení cvičení';
$string['defaultsessionsettings_help'] = 'Tato nastavení definují výchozí hodnoty pro všechna nová cvičení';
$string['defaultsettings'] = 'Výchozí nastavení docházky';
$string['defaultsettings_help'] = 'Tato nastavení definují výchozí hodnoty pro všechny nové docházky';
$string['defaultstatus'] = 'Výchozí nastavení stavu';
$string['defaultsubnet'] = 'Výchozí síťová adresa';
$string['defaultsubnet_help'] = 'Zadávání docházky může být omezeno jen na vybrané IP adresy. Zde můžete zadat čárkami oddělený seznam částečných nebo úplných IP adres.

Tato hodnota bude použita jako výchozí při vytváření nových cvičení.';
$string['defaultview'] = 'Výchozí zobrazení při přihlášení';
$string['defaultview_desc'] = 'Toto je výchozí zobrazení učitelům při prvním přihlášení.';
$string['defaultwarnings'] = 'Výchozí nastavení varování';
$string['defaultwarningsettings'] = 'Nastavení výchozího varování';
$string['defaultwarningsettings_help'] = 'Tato nastavení definují výchozí nastavení všech nových varování';
$string['delete'] = 'Odstranit';
$string['deletecheckfull'] = 'Opravdu chcete zcela smazat {$a}, včetně všech uživatelských dat?';
$string['deletedgroup'] = 'Skupina spojená s tímto cvičením byla odstraněna';
$string['deletehiddensessions'] = 'Odstranit všechna skrytá cvičení';
$string['deletelogs'] = 'Odstranit data docházky';
$string['deleteselected'] = 'Odstranit vybraná';
$string['deletesession'] = 'Odstranit cvičení';
$string['deletesessions'] = 'Odstranit všechna cvičení';
$string['deleteuser'] = 'Odstranit uživatele';
$string['deletewarningconfirm'] = 'Opravdu chcete tuto varování odstranit?';
$string['deletingsession'] = 'Odstranit cvičení v kurzu';
$string['deletingstatus'] = 'Odstranit stav v kurzu';
$string['description'] = 'Popis';
$string['display'] = 'Zobrazit';
$string['displaymode'] = 'Režim zobrazení';
$string['donotusepaging'] = 'Nepoužívat stránkování';
$string['downloadexcel'] = 'Stáhnout ve formátu Excel';
$string['downloadooo'] = 'Stáhnout ve formátu OpenOffice';
$string['downloadtext'] = 'Stáhnout v textovém formátu';
$string['duration'] = 'Trvání';
$string['editsession'] = 'Upravit cvičení';
$string['edituser'] = 'Upravit uživatele';
$string['emailcontent'] = 'Obsah e-mailu';
$string['emailcontent_default'] = 'Zdrvím %userfirstname%,
Vaše docházka v %coursename% %attendancename% klesla pod %warningpercent% a je aktuálně  %percent% - doufáme, že jste v pořádku!

Chcete-li z tohoto kurzu využít co nejvíce, měli byste zlepšit svoji účast, kontaktujte nás, pokud potřebujete další podporu.';
$string['emailcontent_help'] = 'Když je studentovi zasláno varování, přijde tento obsah e-mailu. Mohou být použity následující zástupné znaky:
<ul>
<li>%coursename%</li>
<li>%userfirstname%</li>
<li>%userlastname%</li>
<li>%userid%</li>
<li>%warningpercent%</li>
<li>%attendancename%</li>
<li>%cmid%</li>
<li>%numtakensessions%</li>
<li>%points%</li>
<li>%maxpoints%</li>
<li>%percent%</li>
</ul>';
$string['emailsubject'] = 'Předmět e-mailu';
$string['emailsubject_default'] = 'Varování docházky';
$string['emailsubject_help'] = 'Když je studentovi zasláno varování, přijme předmět e-mailu z tohoto pole.';
$string['emailuser'] = 'E-mail uživatele';
$string['emailuser_help'] = 'Pokud je zaškrtnuto, studentovi bude zasláno varování.';
$string['emptyacronym'] = 'Nejsou povoleny prázdné zkratky. Záznam stavu není aktualizován.';
$string['emptydescription'] = 'Není povolen prázdný popis. Záznam stavu není aktualizován.';
$string['enablecalendar'] = 'Vytvořit události kalendáře';
$string['enablecalendar_desc'] = 'Je-li povoleno, bude pro každé cvičení vytvořena událost kalendáře. Po změně tohoto nastavení byste měli spustit obnovení sestavy kalendáře.';
$string['enablewarnings'] = 'Povolit varování';
$string['enablewarnings_desc'] = 'To umožňuje nastavit sadu varovnou pro docházku a e-mailové upozornění pro uživatele, když docházka klesne pod nastavenou hranici. <br/><strong>UPOZORNĚNÍ: Jedná se o novou funkci a nebylo rozsáhle testováno. Použijte prosím své vlastní riziko a pokud zjistíte, že funguje dobře, poskytněte zpětnou vazbu v moodle fórech.';
$string['encoding'] = 'Kódování';
$string['encoding_help'] = 'Týká se to typu kódování čárového kódu použitého na identifikační kartě studenta. Typické typy kódovacích schémat čárových kódů zahrnují Code-39, Code-128 a UPC-A.';
$string['endofperiod'] = 'Konec období';
$string['endtime'] = 'Čas ukončení cvičení';
$string['enrolmentend'] = 'Zápis uživatelů končí {$a}';
$string['enrolmentstart'] = 'Zápis uživatelů začíná {$a}';
$string['enrolmentsuspended'] = 'Zápis pozastaven';
$string['enterpassword'] = 'Zadejte heslo';
$string['error:coursehasnoattendance'] = 'Kurz s krátkým názvem {$a} nemá žádné aktivity docházky.';
$string['error:coursenotfound'] = 'Kurz s krátkým názvem {$a} nelze nalézt.';
$string['error:qrcode'] = 'Aby bylo možné používat QR kód, musí být studentům umožněno zaznamenat vlastní docházku! Přeskočit.';
$string['error:sessioncourseinvalid'] = 'Cvičení kurzu je neplatné! Přeskočit.';
$string['error:sessiondateinvalid'] = 'Datum cvičení je neplatné! Přeskočit.';
$string['error:sessionendinvalid'] = 'Čas ukončení cvičení je neplatné! Přeskočit.';
$string['error:sessionstartinvalid'] = 'Čas zahájení cvičení je neplatné! Přeskočit.';
$string['error:statusnotfound'] = 'Uživatel: {$a->extuser} má stavovou hodnotu, kterou nelze najít: {$a->status}';
$string['error:timenotreadable'] = 'Uživatel: {$a->extuser} má čas skenu, které nelze převést strtotime: {$a->scantime}';
$string['error:userduplicate'] = 'Uživatel {$a} byl při importu nalezen dvakrát. uveďte prosím pouze jeden záznam na uživatele.';
$string['error:usernotfound'] = 'Uživatel s {$a->userfield} nastaveným na {$a->extuser} nebyl v tomto kurzu nalezen';
$string['errorgroupsnotselected'] = 'Vyberte jednu nebo více skupin';
$string['errorinaddingsession'] = 'Chyba při přidávání cvičení';
$string['erroringeneratingsessions'] = 'Chyba při generování cvičení';
$string['eventdurationupdated'] = 'Aktualizována doba trvání cvičení';
$string['eventreportviewed'] = 'Zobrazena sestava docházky';
$string['eventscreated'] = 'Vytvořeny události kalendáře';
$string['eventsdeleted'] = 'Události kalendáře odstraněny';
$string['eventsessionadded'] = 'Přidáno cvičení';
$string['eventsessiondeleted'] = 'Cvičení odstraněno';
$string['eventsessionipshared'] = 'Dochází ke konfliktu IP při zadání studentem';
$string['eventsessionsimported'] = 'Cvičení byla importována';
$string['eventsessionupdated'] = 'Cvičení aktualizováno';
$string['eventstatusadded'] = 'Stav přidán';
$string['eventstatusupdated'] = 'Stav aktualizován';
$string['eventstudentattendancesessionsupdated'] = 'Aktualizována sestava cvičení';
$string['eventstudentattendancesessionsviewed'] = 'Zobrazena sestava cvičení';
$string['eventtaken'] = 'Docházka zadána';
$string['eventtakenbystudent'] = 'Docházka zadána studentem';
$string['export'] = 'Export';
$string['extrarestrictions'] = 'Další omezení';
$string['formattexttype'] = 'Formátování';
$string['from'] = 'od:';
$string['gradebookexplanation'] = 'Známka v klasifikaci';
$string['gradebookexplanation_help'] = 'Modul Docházka zobrazuje vaši aktuální známku za docházku na základě počtu bodů, které jste získali na datum a počtu bodů, které by jste získali k dnešnímu dni, ale nezahrnuje budoucí období. Vaše známka za docházku je v klasifikaci založena na aktuální docházce v procentech a počtu bodů, které lze získat po dobu trvání kurzu, včetně budoucnosti. Jako takový, může známka docházky zobrazena v modulu Docházka a v Klasifikaci nemůže být stejný počet bodů, ale je to stejné procento.

Například, pokud jste získali 8 z 10 bodů k dnešnímu dni (80% docházky) a docházka za celý kurz je 50 bodů, bude Docházka zobrazovat 8/10 a klasifikace zobrazí 40/50. Ještě jste získal 40 bodů, ale 40 je ekvivalentní hodnota bodu do svého aktuálního docházky procentech 80%. Hodnota bodů, které jste získali v Docházce se nemůže snížit, protože je založena pouze na účast ke dni, ale hodnota bodů uvedených v Klasifikaci se může zvyšovat nebo snižovat v závislosti na budoucí účast, protože je založena na účasti po celou dobu kurzu.';
$string['graded'] = 'Známkované cvičení';
$string['gridcolumns'] = 'Sloupce mřížky';
$string['group'] = 'Skupina';
$string['groups'] = 'Skupiny';
$string['groupsession'] = 'Skupina studentů';
$string['groupsessionsby'] = 'Seskupit cvičení podle';
$string['hiddensessions'] = 'Skrytá cvičení';
$string['hiddensessions_help'] = 'Cvičení je skryté, pokud jsou naplánovány před datem zahájení kurzu.
Tuto funkci pro skrytí starších cvičení můžete použít místo odstranění. V hodnocení se zobrazí pouze viditelné relace.';
$string['hiddensessionsdeleted'] = 'Všechna skrytá cvičení byla odstraněna';
$string['hideextrauserdetails'] = 'Skrýt další uživatelské podrobnosti';
$string['hidensessiondetails'] = 'Skrýt podrobnosti cvičení';
$string['identifyby'] = 'Identifikovat studenta podle';
$string['import'] = 'Import';
$string['importfile'] = 'Importovat soubor';
$string['importfile_help'] = 'Importní soubor';
$string['importsessions'] = 'Importovat cvičení';
$string['importstatus'] = 'Stavové pole';
$string['importstatus_help'] = 'To umožňuje zahrnout do importu stavovou hodnotu - např. Hodnoty jako P, L, nebo A';
$string['includeabsentee'] = 'Při výpočtu Sestavy nepřítomných zahrnout cvičení';
$string['includeabsentee_help'] = 'Pokud je tato políčka zaškrtnuta, bude zahrnuto do výpočtů Sestavy nepřítomných.';
$string['includeall'] = 'Vybrat všechna cvičení';
$string['includedescription'] = 'Zahrnout popis cvičení';
$string['includenottaken'] = 'Zahrnout nevybraná cvičení';
$string['includeqrcode'] = 'Zahrnout QR kód';
$string['includeremarks'] = 'Zahrnout poznámky';
$string['incorrectpassword'] = 'Zadali jste nesprávné heslo a vaše docházka tak nebyla zaznamenána. Pro zaznamenání docházky prosím vložte správné heslo.';
$string['incorrectpasswordshort'] = 'Nesprávné heslo, účast nebyla zaznamenána.';
$string['indetail'] = 'V detailu...';
$string['indicator:cognitivedepth'] = 'Kognitivní docházka';
$string['indicator:cognitivedepth_help'] = 'Tento indikátor je založen na kognitivní hloubce, které student dosáhl v činnosti docházka.';
$string['indicator:cognitivedepthdef'] = 'Kognitivní docházka';
$string['indicator:cognitivedepthdef_help'] = 'Účastník během tohoto intervalu analýzy dosáhl tohoto procenta kognitivní angažovanosti nabízené Docházkou (Úrovně = Žádné zobrazení, Zobrazení)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Docházka sociální';
$string['indicator:socialbreadth_help'] = 'Tento indikátor je založen na sociální šíři dosažené studentem v činnosti docházka.';
$string['indicator:socialbreadthdef'] = 'Docházka sociální';
$string['indicator:socialbreadthdef_help'] = 'Účastník během tohoto analytického intervalu dosáhl tohoto procenta sociální angažovanosti nabízené Docházky (Úrovně = Žádná účast, Účastník sám)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['invalidaction'] = 'Musíte vybrat akci';
$string['invalidemails'] = 'Musíte zadat adresy existujících uživatelských účtů, nelze najít: {$a}';
$string['invalidimportfile'] = 'Formát souboru je neplatný.';
$string['invalidsessionenddate'] = 'Datum ukončení cvičení nemůže být před datem zahájení cvičení';
$string['invalidsessionendtime'] = 'Datum ukončení musí být větší než datum zahájení';
$string['invalidstatus'] = 'Zvolili jste neplatný stav, zkuste to znovu';
$string['iptimemissing'] = 'Neplatné minuty pro cvičení';
$string['jumpto'] = 'Přejít na';
$string['keepsearching'] = 'Pokračuj v hledání';
$string['lasttaken'] = 'Poslední záznam účasti';
$string['manualtriggerauto'] = 'Ručně spustit automatické označení';
$string['marksessionimportcsvhelp'] = 'Tento formulář umožňuje nahrát soubor CSV obsahující identifikátor uživatele a stav - stavovým polem může být zkratka stavu nebo čas, kdy byl u daného uživatele zaznamenána docházka. Pokud je předána časová hodnota, pokusí se přiřadit stavové hodnotě nejvyšší známku, která je v té době k dispozici.';
$string['maxpossible'] = 'Maximální možný zisk';
$string['maxpossible_help'] = 'Zobrazí skóre, které může každý uživatel dosáhnout, pokud obdrží maximální počet bodů v každém cvičení, které ještě neproběhlo (minulé a budoucí):
    <ul>
    <li><strong>Body</strong>: maximální počet bodů, které může každý uživatel dosáhnout ve všech cvičeních. </li>
    <li><strong>Procento</strong>: maximální procento, které může každý uživatel dosáhnout ve všech cvičeních.</li>
    </ul>';
$string['maxpossiblepercentage'] = 'Maximální možné procento';
$string['maxpossiblepoints'] = 'Maximální možný počet bodů';
$string['maxwarn'] = 'Maximální počet varování na e-mail';
$string['maxwarn_help'] = 'Maximální počet varování, které by mělo být odesláno (je odesláno pouze jedno varování za cvičení)';
$string['mergeuser'] = 'Sloučit uživatele';
$string['messagedselecteduserfailed'] = 'Odeslání zprávy jednomu nebo více uživatelům se nezdařilo. Chcete-li zjistit více, zapněte ladění.';
$string['mobilesessionfrom'] = 'Zobrazit cvičení starší než poslední';
$string['mobilesessionfrom_help'] = 'Umožňuje omezit seznam cvičení při označování v aplikaci - zobrazuje pouze relace, které začaly od této hodnoty';
$string['mobilesessionto'] = 'Zobrazit budoucí cvičení';
$string['mobilesessionto_help'] = 'Umožňuje omezit seznam cvičení tak, aby zobrazoval pouze malý počet budoucích relací.';
$string['mobilesettings'] = 'Nastavení mobilní aplikace';
$string['mobilesettings_help'] = 'Toto nastavení řídí chování mobilní aplikace Moodle';
$string['modulename'] = 'Docházka';
$string['modulename_help'] = 'Modul Docházka umožňuje učiteli, aby si vytvořil vlastní záznam účasti studentů ve vyučování.
Učitel může vytvářet více cvičení a lze označit stav účasti "Přítomen", "Nepřítomen", "Zpozdění", nebo "Omluven" nebo změnit stav tak, aby vyhovovaly jejich potřebám.
Jsou k dispozici sestavy pro celou třídu či jednotlivcům.';
$string['modulenameplural'] = 'Docházky';
$string['months'] = 'Měsíce';
$string['moreattendance'] = 'Na této stránce byla docházka úspěšně zadána';
$string['moveleft'] = 'Posunout doleva';
$string['moveright'] = 'Posunout doprava';
$string['multisessionexpanded'] = 'Rozbalit opakovaná cvičení';
$string['multisessionexpanded_desc'] = 'Zobrazit nastavení "Opakovaná cvičení " ve výchozím nastavení jako rozbalená, při vytváření nových cvičení.';
$string['mustselectusers'] = 'Je nutné vybrat uživatele pro export';
$string['name'] = 'Název';
$string['newdate'] = 'Nové datum';
$string['newduration'] = 'Nové trvání';
$string['newstatusset'] = 'Nová sada stavů';
$string['noabsentstatusset'] = 'Použitá stavová položka nemá stav, který se používá, pokud není označen.';
$string['noattendanceusers'] = 'Není možné exportovat všechna data, když v kurzu neexistují žádní studenti.';
$string['noattforuser'] = 'Pro uživatele neexistují žádné záznamy docházky';
$string['noautomark'] = 'Zakázáno';
$string['nocapabilitytotakethisattendance'] = 'Pokusili jste se změnit účast na relaci pomocí cmid: {$a}, ke kterému nemáte oprávnění upravovat.';
$string['nodescription'] = 'Pravidelné cvičení třídy';
$string['noeventstoreset'] = 'Neexistují žádné události kalendáře, které vyžadují aktualizaci.';
$string['nogroups'] = 'Tato aktivita byla nastavena na používání skupin, ale v kurzu neexistují žádné skupiny.';
$string['noguest'] = 'Host nevidí docházku';
$string['noofdaysabsent'] = 'Počet dní nepřítomnosti';
$string['noofdaysexcused'] = 'Počet dní s omluvou';
$string['noofdayslate'] = 'Počet dní zpoždění';
$string['noofdayspresent'] = 'Počet dní přítomen';
$string['nosessiondayselected'] = 'Nevybrán žádný den cvičení';
$string['nosessionexists'] = 'V tomto kurzu není cvičení';
$string['nosessionsselected'] = 'Nevybráno cvičení';
$string['notfound'] = 'V tomto kurzu nebyla nalezena žádná aktivita Docházka!';
$string['notifytask'] = 'Zaslat varování uživatelům';
$string['notmember'] = 'není členem';
$string['notset'] = 'nenastaveno';
$string['nounmarkedstatusset'] = 'Pro toto cvičení není nakonfigurován žádný neoznačený stav (id:{$a->sessionid}), k opravě této aktualizace <a href="{$a->url}">nastavit stav</a>';
$string['noupgradefromthisversion'] = 'Modul Docházka nelze upgradovat z verze attforblock, kterou  jste nainstalovali. Před instalací modulu Docházka odstraňte attforblock nebo aktualizujte na nejnovější verzi';
$string['numsessions'] = 'Počet cvičení';
$string['numsessionstaken'] = 'Počet uskutečněných cvičení';
$string['olddate'] = 'Staré datum';
$string['onactivitycompletion'] = 'Po dokončení činnosti';
$string['onlyselectedusers'] = 'Export konkrétních uživatelů';
$string['overallsessions'] = 'Za všechna cvičení';
$string['overallsessions_help'] = 'Zobrazuje statistiky pro všechna cvičení včetně těch, která ještě neproběhla (minulé a budoucí):
 <ul>
    <li><strong>Cvičení</strong>: celkový počet cvičení.</li>
    <li><strong>Body</strong>: body získané na základě cvičení.</li>
    <li><strong>Procenta</strong>: procento bodů získaných za maximální počet bodů pro všechna cvičení.</li>
    </ul>';
$string['oversessionstaken'] = 'Za proběhlá cvičení';
$string['oversessionstaken_help'] = 'Zobrazuje statistiky pro cvičení, která již proběhla:
 <ul>
    <li><strong>Cvičení</strong>: počet již proběhlých cvičení.</li>
    <li><strong>Body</strong>: body získané na základě cvičení.</li>
    <li><strong>Procenta</strong>: procento bodů získaných za maximální počet bodů pro proběhlá cvičení.</li>
    </ul>';
$string['pageof'] = 'Stránka {$a->page} z {$a->numpages}';
$string['participant'] = 'Účastník';
$string['password'] = 'Heslo';
$string['passwordgrp'] = 'Studentské heslo';
$string['passwordgrp_help'] = 'Je-li nastaveno, budou studenti povinni zadat toto heslo před zadáním stavu docházky do  cvičení. Je-li prázdné, není vyžadováno žádné heslo.';
$string['passwordheader'] = 'Pro přihlášení použijte níže uvedené heslo';
$string['passwordrequired'] = 'Před odesláním docházky musíte zadat heslo cvičení';
$string['percentage'] = 'Procenta';
$string['percentageallsessions'] = 'Procenta přes všechna cvičení';
$string['percentagesessionscompleted'] = 'Procenta přes proběhlá cvičení';
$string['pluginadministration'] = 'Správa docházky';
$string['pluginname'] = 'Docházka';
$string['points'] = 'Body';
$string['pointsallsessions'] = 'Body přes všechna cvičení';
$string['pointssessionscompleted'] = 'Body přes proběhlá cvičení';
$string['preferences_desc'] = 'Změny v souborech stavu ovlivní stávající docházku cvičení a mohou ovlivnit hodnocení.';
$string['preventsharederror'] = 'Zadávání docházky studentem pro cvičení bylo zakázáno, protože se zdá, že toto zařízení bylo použito k záznamu účasti pro jiného studenta.';
$string['preventsharedip'] = 'Zabránit studentům sdílet adresu IP';
$string['preventsharedip_help'] = 'Zabránit tomu, aby studenti používali stejné zařízení (identifikované pomocí adresy IP), aby zadávali docházku za další studenty.';
$string['preventsharediptime'] = 'Čas povolit opakované použití adresy IP (v minutách)';
$string['preventsharediptime_help'] = 'Povolte, aby se po uplynutí této doby opětovně použila adresa IP pro účast v tomto cvičení.';
$string['preview'] = 'Náhled souboru';
$string['previewhtml'] = 'Náhled formátu HTML';
$string['priorto'] = 'Datum cvičení je před datem zahájení kurzu ({$a}), tak nové cvičení plánované před tímto datem budou skryty (nepřístupné). Můžete změnit datum zahájení kurzu (viz Nastavení kurzu), aby měli přístup k starším cvičením. <br> Prosím, změňte datum cvičení, nebo stačí kliknout na tlačítko "Přidat cvičení" a znovu potvrdit?';
$string['privacy:metadata:attendancelog'] = 'Zaznamenává záznam návštěv uživatelů.';
$string['privacy:metadata:attendancesessions'] = 'Cvičení, na kterých bude účast zaznamenána.';
$string['privacy:metadata:attendancewarningdone'] = 'Zaznamenává výstrahy poslané uživatelům přes záznam docházky.';
$string['privacy:metadata:duration'] = 'Trvání cvičení v sekundách';
$string['privacy:metadata:groupid'] = 'ID skupiny přidružené k cvičení.';
$string['privacy:metadata:ipaddress'] = 'Byla označena docházka z IP adresy.';
$string['privacy:metadata:lasttaken'] = 'Časové razítko, kdy byla naposledy zaznamenána docházka na cvičení.';
$string['privacy:metadata:lasttakenby'] = 'Uživatelské jméno posledního uživatele, které se účastní tohoto cvičení';
$string['privacy:metadata:notifyid'] = 'Varování o docházce na cvičení je spojeno s ID.';
$string['privacy:metadata:remarks'] = 'Komentáře k docházce uživatele.';
$string['privacy:metadata:sessdate'] = 'Časové razítko zahájení cvičení.';
$string['privacy:metadata:sessionid'] = 'ID docházky cvičení.';
$string['privacy:metadata:statusid'] = 'ID stavu docházky studenta.';
$string['privacy:metadata:statusset'] = 'Stavová položka, ke které ID stavu patří.';
$string['privacy:metadata:studentid'] = 'ID studenta, který má zaznamenanou docházku.';
$string['privacy:metadata:takenby'] = 'ID uživatele, který zapsal docházkul studenta.';
$string['privacy:metadata:timemodified'] = 'Časové razítko poslední úpravy cvičení';
$string['privacy:metadata:timesent'] = 'Časové razítko odeslání varování.';
$string['privacy:metadata:timetaken'] = 'Časové razítko o době, kdy byl evidován záznam studenta.';
$string['privacy:metadata:userid'] = 'ID uživatele, kterému chcete upozornění odeslat.';
$string['processingfile'] = 'Zpracování souboru';
$string['qr_cookie_error'] = 'QR cvičení vypršela.';
$string['qr_pass_wrong'] = 'Heslo QR je nesprávné nebo jeho platnost vypršela.';
$string['qrcode'] = 'QR kód';
$string['qrcodeandpasswordheader'] = 'Pro účast naskenujte níže uvedený QR kód nebo použijte níže uvedené heslo';
$string['qrcodeheader'] = 'Naskenujte QR kód níže a získejte svou účast v docházce';
$string['qrcodevalidafter'] = 'vteřin';
$string['qrcodevalidbefore'] = 'QR kód platný pro:';
$string['randompassword'] = 'Náhodné heslo';
$string['remark'] = 'Poznámka pro: {a}';
$string['remarks'] = 'Poznámky';
$string['repeatasfollows'] = 'Zopakovat cvičení výše takto';
$string['repeatevery'] = 'Opakovat každý';
$string['repeaton'] = 'Opakujte do';
$string['repeatuntil'] = 'Opakujte dokud';
$string['report'] = 'Sestava';
$string['reportsessiondate'] = 'Datum cvičení';
$string['reportsessionduration'] = 'Délka cvičení';
$string['reportsessionlasttaken'] = 'Čas posledního trvání cvičení (učitel)';
$string['required'] = 'Vyžadováno*';
$string['requiredentries'] = 'Dočasné záznamy přepíší záznamy účastníků docházky';
$string['requiredentry'] = 'Nápověda pro Dočasné sloučení uživatel';
$string['requiredentry_help'] = '<p align="center"><b>Docházka</b></p>
<p align="left"><strong>Sloučení účtů</strong></p>
<p align="left">
<table border="2" cellpadding="4">
<tr>
<th>Moodle uživatel</th>
<th>Dočasný uživatel</th>
<th>Akce</th>
</tr>
<tr>
<td>Data docházky</td>
<td>Data docházky</td>
<td>Dočasný uživatel přepíše uživatele Moodle</td>
</tr>
<tr>
<td>Bez dat docházky</td>
<td>Data docházky</td>
<td>Docházka dočasných uživatelů bude převedena na uživatele Moodle</td>
</tr>
<tr>
<td>Data docházky</td>
<td>Bez data docházky</td>
<td>Dočasní uživatelé budou smazáni</td>
</tr>
<tr>
<td>Bez dat docházky</td>
<td>Bez dat docházky</td>
<td>Dočasný uživatel bude smazán</td>
</tr>
</table>

</p>
<p align="left"><strong>Dočasný uživatel bude vymazán ve všech případech po akci sloučení </strong></p>';
$string['requiresubnet'] = 'Vyžadovat síťovou adresu';
$string['requiresubnet_help'] = 'Zápis docházky může být omezen na určité podsítě zadáním čárkami oddělené částečné nebo úplné IP adresy.';
$string['resetcaledarcreate'] = 'Kalendářové události byly povoleny, ale řada stávajících cvičení nemá události. Chcete vytvořit události kalendáře pro všechny stávající cvičení?';
$string['resetcaledardelete'] = 'Kalendářové události byly zakázány, ale řada stávajících cvičení má události, které je třeba smazat. Chcete odstranit všechny stávající události?';
$string['resetcalendar'] = 'Obnovit kalendář';
$string['resetdescription'] = 'Pamatujte, že odstraněním docházky vymažete údaje z databáze. Stačí jen schovat starší cvičení změnou datum zahájení kurzu!';
$string['resetstatuses'] = 'Obnovit stavy na výchozí';
$string['restoredefaults'] = 'Obnovit výchozí';
$string['resultsperpage'] = 'Počet výsledků na stránku';
$string['resultsperpage_desc'] = 'Počet studentů zobrazených na stránce';
$string['rotateqrcode'] = 'Otočit QR kód';
$string['rotateqrcode_cleartemppass_task'] = 'Úloha pro vymazání dočasných hesel generovaných otočením funkce QR kódu.';
$string['rotateqrcodeexpirymargin'] = 'Otočit hranici vypršení platnosti QR kódu / hesla (v sekundách)';
$string['rotateqrcodeexpirymargin_desc'] = 'Časový interval (vteřiny) umožňující vypršení platnosti QR kódu / hesla.';
$string['rotateqrcodeinterval'] = 'Interval otočení QR kódu / hesla (v sekundách)';
$string['rotateqrcodeinterval_desc'] = 'Časový interval (sekundy) pro otočení QR kódu / hesla.';
$string['save'] = 'Uložit docházku';
$string['saveandshownext'] = 'Uložit a zobrazit další stránku';
$string['scantime'] = 'Skenovat čas';
$string['scantime_help'] = 'To umožňuje, aby bylo do importovaného souboru zahrnuto časové razítko - pokusí se převést časové razítko předané pomocí funkce strtotime PHP a poté pomocí nastavení stavu docházky rozhodnout, který stav pro uživatele nastavit';
$string['search:activity'] = 'Docházka - informace o činnosti';
$string['selectactivity'] = 'Vybrat aktivitu';
$string['session'] = 'Cvičení';
$string['session_help'] = 'Cvičení';
$string['sessionadded'] = 'Cvičení úspěšně přidána';
$string['sessionalreadyexists'] = 'Cvičení v tomto datu již existuje';
$string['sessiondate'] = 'Datum';
$string['sessiondays'] = 'Dny cvičení';
$string['sessiondeleted'] = 'Cvičení úspěšně smazána';
$string['sessiondescription'] = 'Popis cvičení';
$string['sessionduplicate'] = 'V kurzu existuje duplicitní cvičení: {$a->course} v Docházce: {$a->activity}, {$a->date}';
$string['sessionexist'] = 'Cvičení nebylo přidáno (již neexistuje)!';
$string['sessiongenerated'] = 'Jedno cvičení bylo úspěšně vygenerováno';
$string['sessions'] = 'Cvičení';
$string['sessionsallcourses'] = 'Všechny kurzy';
$string['sessionsbyactivity'] = 'Docházková instance';
$string['sessionsbycourse'] = 'Kurz';
$string['sessionsbydate'] = 'Týden';
$string['sessionscompleted'] = 'Proběhlá cvičení';
$string['sessionscurrentcourses'] = 'Aktuální kurzy';
$string['sessionsgenerated'] = '{$a} cvičení úspěšně vytvořeno';
$string['sessionsids'] = 'ID cvičení:';
$string['sessionsnotfound'] = 'V ve vybraném rozmezí není žádné cvičení';
$string['sessionstartdate'] = 'Datum zahájení cvičení';
$string['sessionstotal'] = 'Celkový počet cvičení';
$string['sessionsupdated'] = 'Aktualizováno cvičení';
$string['sessiontype'] = 'Typ';
$string['sessiontype_help'] = 'Můžete přidat cvičení pro všechny studenty nebo pro skupinu studentů. Možnost přidat různé typy závisí na režimu skupinové aktivity.

* V režimu skupin "Žádné skupiny" můžete přidat pouze společné cvičení.
* V režimu skupin "Viditelné skupiny" můžete přidat společné a skupinové cvičení.
* V režimu skupin "Oddělené skupiny" můžete přidat pouze skupinové cvičení.';
$string['sessiontypeshort'] = 'Typ';
$string['sessionunknowngroup'] = 'Cvičení specifikuje neznámé skupiny: {$a}';
$string['sessionupdated'] = 'Cvičení úspěšně aktualizováno';
$string['set_by_student'] = 'Docházka zadána studentem';
$string['setallstatuses'] = 'Nastavit stav pro';
$string['setallstatusesto'] = 'Nastavit stav pro «{$a}»';
$string['setperiod'] = 'Určený čas v minutách k uvolnění IP';
$string['settings'] = 'Nastavení';
$string['setunmarked'] = 'Automaticky nastavit, pokud není označen';
$string['setunmarked_help'] = 'Je-li ve cvičení povoleno, nastavte tento stav, pokud student neoznačil svou vlastní docházku.';
$string['showdefaults'] = 'Zobrazit výchozí';
$string['showduration'] = 'Zobrazit trvání';
$string['showextrauserdetails'] = 'Zobrazit další uživatelské podrobnosti';
$string['showqrcode'] = 'Zobrazit QR kód';
$string['showsessiondescriptiononreport'] = 'Zobrazit popis cvičení v přehledu';
$string['showsessiondescriptiononreport_desc'] = 'Zobrazit popis cvičení ve výpisu docházky.';
$string['showsessiondetails'] = 'Zobrazit detaily cvičení';
$string['somedisabledstatus'] = '(Některé možnosti byly odstraněny při zahájení cvičení.)';
$string['sortedgrid'] = 'Seřazená mřížka';
$string['sortedlist'] = 'Seřazený seznam';
$string['startofperiod'] = 'Začátek období';
$string['starttime'] = 'Čas zahájení';
$string['status'] = 'Stav';
$string['statusall'] = 'vše';
$string['statusdeleted'] = 'Stav odstraněn';
$string['statuses'] = 'Stavy';
$string['statusset'] = 'Stav nastaven {$a}';
$string['statussetsettings'] = 'Stav nastavení';
$string['statustotalcount'] = 'Stav {$a} – Celkový počet';
$string['statustotalcountcurrentweek'] = 'Stav {$a} – Celkový počet za aktuální týden';
$string['statustotalcountpreviousweek'] = 'Stav {$a} – Celkový počet za předchozí týden';
$string['statusunselected'] = 'nevybrané';
$string['strftimedm'] = '%d.%m';
$string['strftimedmw'] = '<nobr>%a %b %d</nobr>';
$string['strftimedmy'] = '%d. %m. %Y';
$string['strftimedmyhm'] = '%d. %m. %Y %H.%M';
$string['strftimedmyw'] = '%d. %m. %Y (%a)';
$string['strftimeh'] = '%H:%M';
$string['strftimehm'] = '%I:%M%p';
$string['strftimeshortdate'] = '%d. %m. %Y';
$string['studentid'] = 'ID studenta';
$string['studentmarked'] = 'Vaše docházka v tomto cvičení byla zaznamenána.';
$string['studentmarking'] = 'Záznam studenta';
$string['studentpassword'] = 'Studentské heslo';
$string['studentrecordingexpanded'] = 'Záznam studenta byl rozbalen';
$string['studentrecordingexpanded_desc'] = 'Při vytváření nových cvičení zobrazte nastavení "Záznam studenta" jako standardně rozbalené.';
$string['studentscanmark'] = 'Umožnit studentům zapsat vlastní docházku';
$string['studentscanmark_desc'] = 'Je-li povoleno, budou moci  učitelé moci povolit studentům zaznamenat vlastní docházku.';
$string['studentscanmark_help'] = 'Je-li povoleno, budou moci studenti měnit ve cvičení stav své docházky.';
$string['studentscanmarksessiontime'] = 'Studenti zaznamenávají docházku během doby trvání cvičení';
$string['studentscanmarksessiontime_desc'] = 'Je-li nastaveno, může student během cvičení zaznamenat pouze svou účast.';
$string['studentscanmarksessiontimeend'] = 'Konec cvičení (minuty)';
$string['studentscanmarksessiontimeend_desc'] = 'Nemá-li cvičení čas ukončení, kolik minut by mělo být k dispozici studentům, aby zaznamenali svou docházku ve cvičení.';
$string['studentsearlyopentime'] = 'Cvičení otevřete brzy pro zadání docházky';
$string['studentsearlyopentime_help'] = 'To umožňuje učitelům zahájit cvičení dříve, což umožňuje účast před skutečným začátkem.';
$string['submit'] = 'Odeslat';
$string['submitattendance'] = 'Odeslat docházku';
$string['submitattendancefuture'] = 'Nahlásit budoucí nepřítomnost';
$string['submitpassword'] = 'Zadat heslo';
$string['subnet'] = 'Podsíť';
$string['subnetactivitylevel'] = 'Povolit konfiguraci podsítě na úrovni aktivity';
$string['subnetactivitylevel_desc'] = 'Je-li povoleno, mohou učitelé při vytváření docházky přepsat výchozí podsíť na úrovni aktivity. V opačném případě bude výchozí stránka použita při vytváření cvičení.';
$string['subnetwrong'] = 'Docházku lze zadávat pouze z určitých míst a tento počítač není na seznamu povolených.';
$string['summary'] = 'Shrnutí';
$string['tablerenamefailed'] = 'Přejmenování staré tabulky attforblock Docházky selhalo';
$string['tactions'] = 'Akce';
$string['takeattendance'] = 'Zadat docházku';
$string['takensessions'] = 'Zadaná cvičení';
$string['tcreated'] = 'Vytvořeno';
$string['tempaddform'] = 'Přidat dočasného uživatele';
$string['tempexists'] = 'Dočasný uživatel s touto e-mailovou adresou již existuje';
$string['temptable'] = 'Seznam dočasných uživatelů';
$string['tempuser'] = 'Dočasný uživatel';
$string['tempusermerge'] = 'Sloučit dočasné uživatele';
$string['tempusers'] = 'Dočasní uživatelé';
$string['tempusersedit'] = 'Úpravit dočasného uživatele';
$string['tempuserslist'] = 'Dočasní uživatelé';
$string['thirdpartyemails'] = 'Oznámení ostatním uživatelům';
$string['thirdpartyemails_help'] = 'Seznam ostatních uživatelů, kteří budou upozorněni. (vyžaduje oprávnění mod/attendance:viewreports)';
$string['thirdpartyemailsubject'] = 'Varování docházky';
$string['thirdpartyemailtext'] = '{$a->firstname} {$a->lastname} docházka do {$a->coursename} {$a->aname} je nižší než {$a->warningpercent} ({$a->percent})';
$string['thirdpartyemailtextfooter'] = 'Obdrželi jste to, protože učitel tohoto kurzu přidal váš e-mail do seznamu příjemců';
$string['thiscourse'] = 'Tento kurz';
$string['time'] = 'Čas';
$string['timeahead'] = 'Opakované cvičení, která přesahují jeden rok nemůže být vytvořeno, upravte počáteční a koncové datum.';
$string['timemodified'] = 'Čas upraven';
$string['timetaken'] = 'Docházka zadána';
$string['to'] = 'do:';
$string['todate'] = 'do data';
$string['totalnumsessions'] = 'Celkový počet cvičení';
$string['triggered'] = 'První oznámení';
$string['tuseremail'] = 'Email';
$string['tusername'] = 'Celé jméno';
$string['ungraded'] = 'Nezařazená cvičení';
$string['unknowngroup'] = 'Neznámá skupina';
$string['unknownstatus'] = 'Neznámé ID stavu: {$a}';
$string['update'] = 'Aktualizovat';
$string['updateattendance'] = 'Aktualizovat docházku';
$string['uploadattendance'] = 'Nahrát docházku pomocí CSV';
$string['usedefaultsubnet'] = 'Použijte výchozí';
$string['usemessageform'] = 'nebo použijte níže uvedený formulář k odeslání zprávy vybraným studentům';
$string['userexistingstatus'] = 'Vaše účast již byla označena jako: <strong>{$a}</strong>, v případě potřeby jej změňte pomocí formuláře níže.';
$string['userexists'] = 'V současnosti již existuje skutečný uživatel s touto e-mailovou adresou';
$string['userid'] = 'ID uživatele';
$string['userimportfield'] = 'Další pole uživatele';
$string['userimportfield_help'] = 'Pole z nahraného souboru CSV, který obsahuje identifikátor uživatele';
$string['userimportto'] = 'Uživatelské pole Moodle';
$string['userimportto_help'] = 'Pole Moodle, které odpovídá datům z exportu CSV';
$string['users'] = 'Uživatelé k exportování';
$string['usersessiongrade'] = 'Uživatelské hodnocení cvičení';
$string['usersessionremarks'] = 'Uživatelská poznámka cvičení';
$string['usersessiontaken'] = 'Zadáno cvičení uživatele';
$string['userstatus'] = 'Stav cvičení uživatele';
$string['usestatusset'] = 'Stav nastaven';
$string['variable'] = 'proměnná';
$string['variablesupdated'] = 'Proměnné úspěšně aktualizovány';
$string['versionforprinting'] = 'verze pro tisk';
$string['viewmode'] = 'Režim zobrazení';
$string['warnafter'] = 'Počet cvičení realizovaných před varováním';
$string['warnafter_help'] = 'Varování budou spuštěna pouze tehdy, když se uživatel účastnil alespoň na tento počet návštěv.';
$string['warningdeleted'] = 'Varování odstraněno';
$string['warningdesc'] = 'Tato varování budou automaticky přidána do všech nových aktivit docházky. Pokud je současně spuštěno více než jedno varování, bude odesláno pouze varování se spodní varovnou prahovou hodnotou.';
$string['warningdesc_course'] = 'Výše prahové hodnoty varování ovlivňují sestavu o nepřítomnosti a umožňují studentům a třetím stranám být informován. Pokud je současně spuštěno více než jedno varování, bude odesláno pouze varování se spodní varovnou prahovou hodnotou.';
$string['warningfailed'] = 'Nemůžete vytvořit varování, které používá stejné procento a počet cvičení.';
$string['warningpercent'] = 'Varování, pokud procento klesne pod';
$string['warningpercent_help'] = 'Varování se spustí, když celkový podíl procent klesne pod toto číslo.';
$string['warnings'] = 'Nastavení varování';
$string['warningthreshold'] = 'Práh varování';
$string['warningupdated'] = 'Varování aktualizovaná';
$string['week'] = 'týden (y)';
$string['weekcommencing'] = 'Zahájení týdne';
$string['weeks'] = 'Týdny';
$string['youcantdo'] = 'Nemůžete nic dělat';
