<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_boost_magnific', language 'sr_cr', version '4.5'.
 *
 * @package     theme_boost_magnific
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['access_course'] = 'Приступ курсу';
$string['acctoolbar_access_declaration'] = 'Изјава о приступачности';
$string['acctoolbar_btn_bright'] = 'Светао контраст';
$string['acctoolbar_btn_cursor_black'] = 'Велики црни курсор';
$string['acctoolbar_btn_cursor_white'] = 'Велики бели курсор';
$string['acctoolbar_btn_font_down'] = 'Смањи величину текста';
$string['acctoolbar_btn_font_readable'] = 'Читљив текст';
$string['acctoolbar_btn_font_up'] = 'Повећај величину текста';
$string['acctoolbar_btn_images_titles'] = 'Наслови слика';
$string['acctoolbar_btn_invert'] = 'Обрнути контраст';
$string['acctoolbar_btn_monochrome'] = 'Приказ без боја';
$string['acctoolbar_btn_open'] = 'Мени за приступачност';
$string['acctoolbar_btn_underline_headers'] = 'Подвуци заглавља';
$string['acctoolbar_btn_underline_links'] = 'Подвуци линкове';
$string['acctoolbar_btn_zoom_in'] = 'Зумирај екран';
$string['acctoolbar_content_block_header'] = 'Истицање садржаја';
$string['acctoolbar_contrast_block_header'] = 'Контраст боја';
$string['acctoolbar_debug_contacts'] = 'Пријавите проблем у вези са приступачношћу';
$string['acctoolbar_dyslexic'] = 'Читљив фонт за дислексију';
$string['acctoolbar_image_without_alt'] = 'Слика без текста';
$string['acctoolbar_keyboard_root'] = 'навигација путем тастатуре';
$string['acctoolbar_reset_all_settings'] = 'Ресетујте подешавања';
$string['acctoolbar_text_block_header'] = 'Величина текста';
$string['acctoolbar_toolbar'] = 'Трака са алаткама за приступачност';
$string['acctoolbar_zoom_block_header'] = 'Увећајте';
$string['background_color'] = 'Боја позадине';
$string['background_color_desc'] = 'Боја позадине врха и подножја странице!';
$string['background_color_random'] = 'Насумична графичка тема {$a}';
$string['background_course_image'] = 'Подразумевана позадинска слика курса';
$string['background_course_image_desc'] = 'Подешава подразумевану позадинску слику за заглавље свих курсева. Ова слика ће бити приказана на врху главне странице курса и може бити замењена у подешавањима курса.';
$string['background_profile_image'] = 'Позадинска слика профила';
$string['background_profile_image_desc'] = 'Позадинска слика приказана на профилу корисника.';
$string['background_text_color'] = 'Боја текста';
$string['background_text_color_desc'] = 'Боја текста на врху и у подножју странице';
$string['cachedef_css_cache'] = 'CSS кеш';
$string['choosereadme'] = 'Boost Magnific је графичка тема пажљиво креирана са намером да унесе ведре боје u Moodle.';
$string['contact_address'] = 'Адреса';
$string['contact_email'] = 'Е-адреса';
$string['contact_phone'] = 'Број телефона';
$string['content_type_default'] = 'Moodle стандардно';
$string['content_type_empty'] = '(Без садржаја)';
$string['content_type_footer'] = 'Тип садржаја за подножје';
$string['content_type_footer_desc'] = 'Изаберите тип садржаја који желите да прикажете у подножју';
$string['content_type_home'] = 'Тип садржаја за почетну страницу';
$string['content_type_home_desc'] = 'Изаберите тип садржаја који желите да прикажете на почетној страници.';
$string['content_type_html'] = 'Страница која се креира помоћу едитора';
$string['continuar'] = 'Наставите са учењем';
$string['countlesson'] = '{$a} лекција';
$string['countlessons'] = '{$a} лекције/а';
$string['course_access'] = 'Приступите курсу';
$string['course_moore'] = 'Више детаља';
$string['customcss'] = 'Прилагођени CSS';
$string['customcss_desc'] = 'Сва CSS правила која додате у ово поље за текста одразиће се на све странице, што олакшава прилагођавање ове теме.';
$string['customfield_category_name'] = 'Прилагођавање графичке теме';
$string['customfield_field_image'] = 'Прилагођена слика';
$string['customfield_field_image_desc'] = 'Изаберите слику како бисте прилагодили поље. Слика ће бити заменити глобална подешавања курса.';
$string['customfield_field_name'] = 'Прикажи слику на врху главне странице курса';
$string['customfield_field_name_desc'] = '<p>Ово поље вам пружа могућност да изаберете да ли желите да прикажете слику на врху главне странице курса. Када је омогућено, слика по вашем избору биће истакнута, побољшавајући на тај начин визуелну атрактивност курса и дајући корисницима унапређено искуство.</p>';
$string['customfield_picture_missing'] = '<div class="alert alert-warning">Потребно је да инсталирате додатак <a href="https://moodle.org/plugins/customfield_picture" target="_blank">customfield_picture</a> како бисте подесили позадинску слику.</div>';
$string['custommenuitems'] = 'Прилагођене ставке менија на врху странице';
$string['custommenuitems_desc'] = 'Поред менија на врху странице можете креирати прилагођени мени. Основни мени треба да почиње у равни са ивицом менија, а подменију треба да претходи цртица (-). Број цртица одређује дубину тј. позицију ставке у менију. Дакле, ставке са једном цртицом појављују се у подменију испод претходне ставке највишег нивоа, а ставке са две цртице се појављују у подменију испод претходног подменија.
Садржај сваке ставке у менију треба да се састоји од највише три елемента (<strong>label</strong> | <strong>url</strong> | <strong>tooltip</strong> | <strong>lang</strong>), сваки одвојен знаком "|".
<ul>
<li><strong>label</strong>: Ово је текст који ће бити приказан у оквиру ставке у менију. Морате навести ознаку за сваку ставку у менију.</li>
<li><strong>url</strong>: Ово је URL адреса на коју ће корисник бити преусмерен након што кликне на ставку у менију. Ово је опционо; ако URL адреса није наведена ставка у менију неће бити линкована.<br>
Остали атрибути као што је "target" могу се додати на крај URL адресе.</li>
<li><strong>tooltip</strong>: Ако сте навели URL адресу, такође можете изабрати да пружите кратак опис линка који сте креирали помоћу URL адресе. Ово је опционо, а ако није дефинисано, ознака (label) ће се користи као кратак опис ставке у менију.</li>
<li><strong>lang</strong>: Такође, можете додати кôд језика (или списак кôдова раздвојених зарезима) као четврти елемент реда. Ставка у менију ће бити приказана само ако је корисник изабрао неки од наведених језика.</li>
</ul>
У наставку можете видети пример како да креирате прилагођени мени:
<blockquote><pre>
Courses
-All courses | /course/
-My courses
--Example Course
---Example Course 7 | /course/view.php?id=7
---Example Course 9 | /course/view.php?id=9
--Test Course
---Test Course 2 | /course/view.php?id=2
---Test Course 5 | /course/view.php?id=5
Google
-Google in any language | https://google.com/" target="_blank
-Google in Mexico | https://www.google.com.mx/" target="_blank|Google Label|en
-Google in Portuguese | https://google.com.br/" target="_blank|Google Label|pt,pt_br,pt_br_kids
Support Page | https://support.com/" target="_blank
</pre></blockquote>
For Moodle with support for multiple languages, the <strong>label</strong> value should be formatted as <strong>"langstringname,componentname"</strong>.
<blockquote><pre>
profile,moodle | /user/profile.php
messages,message | /message/index.php
</pre></blockquote>
<a href="https://docs.moodle.org/404/en/Advanced_theme_settings" target="_blank">Више информација о менију</a>';
$string['editor_link_footer'] = 'Уредите блокове подножја за {$a} језик';
$string['editor_link_footer_all'] = 'Уредите блокове подножја за све језике';
$string['editor_link_home'] = 'Уредите почетну страницу за {$a} језик';
$string['editor_link_home_all'] = 'Уредите почетну страницу за све језике';
$string['favicon'] = 'Фавиконица';
$string['favicon_desc'] = 'Фавиконица се приказује поред наслова странице на картици веб читача. Ако прилагођена фавиконица није обезбеђена биће приказана Moodle фавиконица.';
$string['fontfamily'] = 'Фонтови текста на сајту';
$string['fontfamily_desc'] = 'Изаберите који фонт желите да користите за текст на свом Moodle сајту.';
$string['fontfamily_menus'] = 'Фонтови менија';
$string['fontfamily_menus_desc'] = 'Изаберите који фонт желите да користите за меније на свом Moodle сајту.';
$string['fontfamily_sitename'] = 'Фонт за назив сајта';
$string['fontfamily_sitename_desc'] = 'Фонт који ће бити примењен на назив сајта ако логотип није обезбеђен.';
$string['fontfamily_title'] = 'Фонтови текста наслова';
$string['fontfamily_title_desc'] = 'Изаберите који фонт желите да користите за наслове на свом Moodle сајту.';
$string['fontpreview'] = 'Преглед списка фонтова';
$string['footer_contact_title'] = 'Наслов блока са контакт подацима';
$string['footer_contact_title_default'] = 'Контактирајте нас';
$string['footer_contact_title_desc'] = 'Унесите наслов блока који ће се појавити у подножју са подацима о контакту.';
$string['footer_description'] = 'Опис';
$string['footer_description_desc'] = 'Опишите свој Moodle, шта радите, а ове информације ће бити приказане испод логотипа у подножју странице';
$string['footer_frontpage_blockcourses_instructor'] = 'Прикажите имена предавача';
$string['footer_frontpage_blockcourses_instructor_desc'] = 'Ако је означено, приказује имена предавача на списку курсева!';
$string['footer_frontpage_blockcourses_text'] = 'Кратак текст који објашњава блок "{$a}"';
$string['footer_frontpage_blockcourses_text_desc'] = 'Додајте текст који описује блок "{$a}"!';
$string['footer_links_title'] = 'Наслов блока са линковима';
$string['footer_links_title_default'] = 'Важни линкови';
$string['footer_show_copywriter'] = 'Прикажи поруку ”Креирано са ❤️”';
$string['footer_show_copywriter_desc'] = 'Опозовите избор ако желите да сакријете поруку ”Креирано са ❤️”';
$string['footer_social_title'] = 'Наслов блока са линковима друштвених мрежа';
$string['footer_social_title_default'] = 'Пратите нас на друштвеним мрежама';
$string['footer_social_title_desc'] = 'Унесите наслов блока који ће се појавити у подножју са подацима са ваших друштвених мрежа.';
$string['footerblink'] = 'Линкови блокова подножја';
$string['footerblink_desc'] = 'Овде можете да конфигуришете линкове блокова у подножју који ће бити приказани.<br>Сваки ред се састоји од текста ставке у менију или језичког кључа или текста, као и URL адресе (опционо), раздвојених вертикалним тракама. На пример:<br><pre>Moodle Support|https://moodle.org/support</pre>';
$string['footerblock_contact'] = 'Блок са контакт подацима';
$string['footerblock_copywriter'] = 'Креирано са ❤️';
$string['footerblock_description'] = 'Блок са описом';
$string['footerblock_links'] = 'Блок са линковима';
$string['footerblock_social'] = 'Блок друштвених мрежа';
$string['free_name'] = 'Бесплатно';
$string['frontpage_about_description'] = 'Опишите шта радите';
$string['frontpage_about_description_desc'] = 'Опишите у највише 5 редова коме је намењен ваш Moodle';
$string['frontpage_about_enable'] = 'Омогућите блок \'О нама\'';
$string['frontpage_about_enable_desc'] = 'Ако је означена, блок \'О нама\' ће се појавити испод банера';
$string['frontpage_about_info'] = 'Поље са подацима {$a}';
$string['frontpage_about_logo'] = 'Овде ће бити приказан другачији лого';
$string['frontpage_about_logo_desc'] = 'Ако је подешен, овај логотип ће се користити уместо логотипа на врху странице.<br>Ако се поље остави празно користићи се стандардни логотип на врху странице,';
$string['frontpage_about_number'] = 'Број';
$string['frontpage_about_number_desc'] = 'Унесите број за горе наведено поље са подацима';
$string['frontpage_about_text'] = 'Назив поља са подацима';
$string['frontpage_about_text_1_defalt'] = 'Курсеви';
$string['frontpage_about_text_2_defalt'] = 'Предавачи';
$string['frontpage_about_text_3_defalt'] = 'Полазници';
$string['frontpage_about_text_4_defalt'] = 'Лекције';
$string['frontpage_about_text_desc'] = 'Унесите назив података који ће бити приказани на почетној страници';
$string['frontpage_about_title'] = 'Наслов блока \'О нама\'';
$string['frontpage_about_title_default'] = 'Наша глобална заједница';
$string['heart'] = 'Ако вам се свиђа ова тема, не заборавите да кликнете на ❤️ страници за графичке теме <a href="{$a}" target="_blank">тако што ћете кликнути овде</a>';
$string['instructor'] = 'Инструктор';
$string['login_backgroundcolor'] = 'Боја позадине';
$string['login_backgroundcolor_desc'] = 'Изаберите боју позадине странице за обнову изгубљене/заборављене лозинке';
$string['login_backgroundfoto'] = 'Позадинска слика';
$string['login_backgroundfoto_desc'] = 'Изаберите позадинску слику странице за пријаву, за обнову изгубљене/заборављене лозинке, као и за креирање налога. Подразумевана слика је: {$a}';
$string['login_forgot_description'] = 'Текст са стране на страници за заборављену лозинку';
$string['login_forgot_description_desc'] = 'Текст који ће се појавити само на страници за заборављену лозинку';
$string['login_login_description'] = 'Текст са стране који ће се појавити на страници за пријаву';
$string['login_login_description_desc'] = 'Текст који ће се појавити само на страници за пријаву';
$string['login_signup_description'] = 'Текст са стране на страници за креирање налога';
$string['login_signup_description_desc'] = 'Текст који ће се појавити само на страници за креирање налога';
$string['login_theme'] = 'Изглед странице за пријаву';
$string['login_theme_block'] = 'Централни бели блок са опционом позадином';
$string['login_theme_desc'] = 'Изаберите како желите да изгледа страница за пријаву';
$string['login_theme_image_login'] = 'Позадинска слика и образац за пријаву са стране';
$string['login_theme_imagetext_login'] = 'Позадинска слика, текст преко слике и образац за пријаву са стране';
$string['login_theme_login'] = 'Само образац за пријаву, без бочне слике';
$string['logo_color'] = 'Лого у боји';
$string['logo_color_desc'] = 'Поставите свој ЛОГО у боји ако желите да он буде приказан при врху странице. Овај лого ће бити видљив приликом премотавања (скроловања) странице, док ће мени бити приказан на белој позадини.';
$string['logo_write'] = 'Лого менија на врху странице приликом скроловања';
$string['logo_write_desc'] = 'Поставите свој лого ако желите да он буде приказан при врху странице. Овај лого ће бити видљив приликом премотавања (скроловања) странице, док ће мени бити приказан на позадини у боји.';
$string['matricular'] = 'Упишите се';
$string['mycourses_color'] = 'Боја позадине блока';
$string['mycourses_color_desc'] = 'Боја позадине за блок.';
$string['mycourses_icon'] = 'Иконица';
$string['mycourses_icon_desc'] = 'Репрезентативна иконица за блок. Величина иконе треба да буде 48x48 пиксела.';
$string['mycourses_info'] = 'Блок {$a}';
$string['mycourses_numblocos'] = 'Број блокова';
$string['mycourses_numblocos_desc'] = 'Колико слика желите да има слајд-шоу?';
$string['mycourses_numblocos_nenhum'] = 'Нема блокова на почетној страници';
$string['mycourses_title'] = 'Кратки наслов блока';
$string['mycourses_title_desc'] = 'Кратак и дескриптиван наслов за блок.';
$string['mycourses_url'] = 'Линк блока';
$string['mycourses_url_desc'] = 'URL адреса на коју ће корисник бити преусмерен када кликне на блок. То може бити екстерни или интерни линк унутар платформе.';
$string['pluginname'] = 'Boost Magnific';
$string['privacy:metadata'] = 'Графичка тема Boost Magnific не чува никакве личне податке о било ком кориснику.';
$string['progress_percentage'] = 'Ваш напредак';
$string['settings_about_heading'] = 'О вашем Moodleu';
$string['settings_accessibility'] = 'Омогућите опције за приступачност';
$string['settings_accessibility_desc'] = 'Омогућава прилагођавање опција за унапређење приступачности платформи, као што су контраст, величина фонта и навигација уз помоћ тастатуре.';
$string['settings_accessibility_heading'] = 'Приступачност';
$string['settings_course_heading'] = 'Подешавања курса';
$string['settings_css_heading'] = 'Фонтови и CSS';
$string['settings_footer_heading'] = 'Блокови подножја';
$string['settings_icons_change_icons'] = 'Промените подразумевану иконицу на списку курсева';
$string['settings_icons_color_icon'] = 'Подесите прилагођену боју за иконицу.';
$string['settings_icons_color_icon_desc'] = 'Изаберите боју позадине за иконицу приказану на списку курсева. Оставите празно како бисте користили боју подразумевану за теме.';
$string['settings_icons_upload_icon'] = 'Поставите прилагођену иконицу.';
$string['settings_login_heading'] = 'Страница за пријаву';
$string['settings_mycourses_heading'] = 'Блокови на страници \'Моји курсеви\'';
$string['settings_slideshow_heading'] = 'Слајд-шоу';
$string['settings_theme_heading'] = 'Графичка тема';
$string['settings_top_heading'] = 'Мени на врху странице';
$string['sitefonts'] = 'Додатни Google фонтови';
$string['sitefonts_desc'] = 'Уметните @import кôд сервиса Google фонтови као што је приказано на слици испод. Након што сачувате, поље "Фонтови сајта" ће бити ажурирано, приказујући ове фонтове. Можете додати више @import кôдова по потреби.';
$string['slidecaption_desc'] = 'Унесите текст наслова који ће се користити на слајду';
$string['slideshow_image'] = 'Слика слајда';
$string['slideshow_image_desc'] = 'Слика треба да буде величине 1250 x 400 пиксела.';
$string['slideshow_info'] = 'Слајд {$a}';
$string['slideshow_numslides'] = 'Колико слика ставити у слајд-шоу';
$string['slideshow_numslides_desc'] = 'Колико слика желите да има слајд-шоу?';
$string['slideshow_numslides_nenhum'] = 'Без слајдова на почетној страници';
$string['slideshow_text'] = 'Кратак описни текст за слајд';
$string['slideshow_text_desc'] = 'Убаците кратак текст о слајду.';
$string['slideshow_url'] = 'Линк дугмета на слајду';
$string['slideshow_url_desc'] = 'Уметните одредишни линк за дугме на слици слајда';
$string['social_facebook'] = 'Ваш Facebook';
$string['social_facebook_desc'] = 'URL адреса Facebook налога ваше организације/институције';
$string['social_instagram'] = 'Ваш Instagram';
$string['social_instagram_desc'] = 'URL адреса Instagram налога ваше организације/институције';
$string['social_linkedin'] = 'Ваш Linkedin';
$string['social_linkedin_desc'] = 'URL адреса Linkedin налога ваше организације/институције';
$string['social_twitter'] = 'Ваш Twitter';
$string['social_twitter_desc'] = 'URL адреса Twitter налога ваше организације/институције.';
$string['social_youtube'] = 'Ваш Youtube';
$string['social_youtube_desc'] = 'URL адреса Youtube канала ваше организације/институције';
$string['tableofcontents'] = 'Садржај';
$string['theme_boost_magnific_about_editbooton'] = 'Уредите блок \'О нама\'';
$string['theme_boost_magnific_frontpage_bloco'] = 'Блок "{$a}"';
$string['theme_boost_magnific_frontpage_home'] = 'Блокови на почетној страници';
$string['theme_boost_magnific_mycourses_editbooton'] = 'Уредите блокове';
$string['theme_boost_magnific_slideshow_editbooton'] = 'Уреди слајд-шоу';
$string['theme_color'] = 'Избор боја';
$string['theme_color-color_buttons'] = 'Боја дугмади';
$string['theme_color-color_buttons_desc'] = 'Боја која се користи за дугмад, и која не само да доприноси визуелном идентитету већ и наглашава интерактивност.';
$string['theme_color-color_primary'] = 'Примарна боја';
$string['theme_color-color_primary_desc'] = 'Главна примарна боја теме, која се обично користи за истицање и наглашавање елемената.';
$string['theme_color-color_secondary'] = 'Секундарна боја';
$string['theme_color-color_secondary_desc'] = 'Секундарна боја која допуњује примарну боју, и која се користи за истицање секундарних елемената или за контраст са примарном бојом.';
$string['theme_color_desc'] = 'Изаберите боје Moodle текстова и дугмади или кликните на линију испод:';
$string['theme_color_heading'] = 'Избор боје окружења';
$string['theme_color_sugestion'] = 'Предлог за боје';
$string['theme_color_sugestion_text'] = 'Кликните на жељени ред тј. боју (плава, љубичаста, црвена...) у наставку, како би одговарајући скуп боја био примењен за доле наведене опције (примарна боја, секундарна боја, боја дугмади...)';
$string['theme_login_branco'] = 'Само образац за пријаву на белој позадини, без бочне слике';
$string['top_color_heading'] = 'Боја менија на врху странице приликом скроловања';
$string['top_scroll'] = 'Фиксирајте мени приликом скроловања странице';
$string['top_scroll_background_color'] = 'Боја позадине менија на врху странице приликом премотавања (скроловања)';
$string['top_scroll_background_color_desc'] = 'Подесите боју позадине менија на врху странице приликом премотавања (скроловања) странице.';
$string['top_scroll_desc'] = 'Када је омогућено, мени ће бити фиксиран за врх странице приликом њеног премотавања (скроловања). Тако ће бити омогућен лак приступ опцијама менија.';
$string['top_scroll_text_color'] = 'Боја текста менија приликом скроловања';
$string['top_scroll_text_color_desc'] = 'Подесите боју текста менија приликом премотавања (скроловања) странице.';
$string['vvveb_footer_contact_title_default'] = 'Контактирајте нас';
$string['vvveb_home_access'] = 'Приступите курсу';
$string['vvveb_home_automatically_catalogo'] = 'Не уређујте. Овај блок ће бити аутоматски замењен каталогом курсева.';
$string['vvveb_home_automatically_category'] = 'Не уређујте. Овај блок ће бити аутоматски замењен категоријама курсева.';
$string['vvveb_home_automatically_my_course'] = 'Не уређујте. Овај блок ће бити аутоматски замењен курсевима на којима је студент уписан.';
$string['vvveb_home_automatically_popular'] = 'Не уређујте. Овај блок ће бити аутоматски замењен најпопуларнијим курсевима.';
$string['vvveb_home_catalogo_heading'] = 'Каталог курсева';
$string['vvveb_home_category_heading'] = 'Категорије курсева';
$string['vvveb_home_mycourses_heading'] = 'Моји курсеви';
$string['vvveb_home_popular_course'] = 'Популарни курсеви';
$string['vvveb_home_team_subtitle'] = 'Ми смо група професионалаца посвећених свом раду';
$string['vvveb_home_team_title'] = 'Упознајте наш тим';
